define("local_datacurso_ratings/ratings_report_course",["exports","core/ajax","core/templates","core/notification"],(function(_exports,_ajax,_templates,_notification){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Displays and manages the AI-powered ratings report for a course.
   *
   * @module     local_datacurso_ratings/ratings_report_course
   * @copyright  2025 Industria Elearning
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=_exports.default=void 0,_exports.showLoading=showLoading,_ajax=_interopRequireDefault(_ajax),_templates=_interopRequireDefault(_templates),_notification=_interopRequireDefault(_notification);const init=courseid=>{const container=document.querySelector("#ratings-report-container");container&&(showLoading(container),_ajax.default.call([{methodname:"local_datacurso_ratings_get_ratings_report_course",args:{courseid:courseid}}])[0].then((data=>function(data,courseid){let totalLikes=0,totalDislikes=0,activitiesWithRatings=0;const processedActivities=data.map((item=>{const likes=item.likes||0,dislikes=item.dislikes||0,totalRatings=likes+dislikes;totalLikes+=likes,totalDislikes+=dislikes,totalRatings>0&&activitiesWithRatings++;const porcentaje=item.approvalpercent||0,comentariosArray=Array.isArray(item.comments)?item.comments:[],comentarios=comentariosArray.join(" / ");return{curso:item.course||"",actividad:item.activity||"",modulo:item.modname||"",cmid:item.cmid||0,url:item.url||"",likes:likes,dislikes:dislikes,porcentaje:porcentaje,comentarios:comentarios,total_ratings:totalRatings,has_ratings:totalRatings>0,has_comments:comentariosArray.length>0,satisfaction_class:getSatisfactionClass(porcentaje),formatted_percentage:"".concat(porcentaje.toFixed(1),"%"),activityurl:item.url||"".concat(M.cfg.wwwroot,"/mod/").concat(item.modname,"/view.php?id=").concat(item.cmid)}})),totalRatings=totalLikes+totalDislikes,overallSatisfaction=totalRatings>0?totalLikes/totalRatings*100:0;return{courseid:courseid,activities:processedActivities,has_data:processedActivities.length>0,summary:{total_activities:processedActivities.length,activities_with_ratings:activitiesWithRatings,total_ratings:totalRatings,total_likes:totalLikes,total_dislikes:totalDislikes,overall_satisfaction:overallSatisfaction.toFixed(1),satisfaction_class:getSatisfactionClass(overallSatisfaction)}}}(data,courseid))).then((templateData=>_templates.default.render("local_datacurso_ratings/report_ratings_course",templateData))).then(((html,js)=>{container.innerHTML=html,_templates.default.runTemplateJS(js),document.querySelectorAll(".expand-comments").forEach((button=>{button.addEventListener("click",(e=>{const targetSelector=e.currentTarget.getAttribute("data-target"),commentsDiv=document.querySelector(targetSelector);if(!commentsDiv)return;const isHidden="none"===commentsDiv.style.display||!commentsDiv.style.display;commentsDiv.style.display=isHidden?"block":"none",e.currentTarget.textContent=isHidden?"Ocultar comentarios":"Ver comentarios"}))})),document.querySelectorAll("th[data-sort]").forEach((header=>{header.style.cursor="pointer",header.addEventListener("click",(()=>{!function(column,header){const table=header.closest("table"),tbody=null==table?void 0:table.querySelector("tbody");if(!tbody)return;const rows=Array.from(tbody.querySelectorAll("tr")),ascending=!header.classList.contains("sorted-asc");table.querySelectorAll("th[data-sort]").forEach((h=>h.classList.remove("sorted-asc","sorted-desc"))),header.classList.add(ascending?"sorted-asc":"sorted-desc"),rows.sort(((a,b)=>{const aValue=a.dataset[column]||"",bValue=b.dataset[column]||"";return ascending?aValue.localeCompare(bValue,void 0,{numeric:!0}):bValue.localeCompare(aValue,void 0,{numeric:!0})})),rows.forEach((row=>tbody.appendChild(row)))}(header.getAttribute("data-sort"),header)}))}))})).catch((error=>{_notification.default.exception(error)})))};function getSatisfactionClass(percentage){return percentage>=80?"success":percentage>=60?"warning":"danger"}async function showLoading(container){const html=await _templates.default.render("local_datacurso_ratings/report_ratings_loading",{});container.innerHTML=html}_exports.init=init;var _default={init:init};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=ratings_report_course.min.js.map