<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * German language strings for Tutor-IA plugin.
 *
 * @package    local_dttutor
 * @copyright  2025 Datacurso
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accepted_files_pdf_only'] = 'Nur PDF-Dateien akzeptiert';
$string['avatar'] = 'Tutor-IA Avatar';
$string['avatar_desc'] = 'Wählen Sie den Avatar aus, der auf der schwebenden Chat-Schaltfläche des Tutor-IA angezeigt werden soll. Wenn keiner ausgewählt ist oder die Datei nicht existiert, wird standardmäßig Avatar 1 verwendet.';
$string['avatar_position'] = 'Avatar-Position';
$string['avatar_position_desc'] = 'Konfigurieren Sie, wo die schwebende Avatar-Schaltfläche des Tutor-IA angezeigt wird. Wählen Sie eine vordefinierte Eckenposition oder passen Sie die genauen X,Y-Koordinaten an. Die Live-Vorschau zeigt, wie es erscheinen wird.';
$string['cachedef_sessions'] = 'Cache für Tutor-IA Chat-Sitzungen';
$string['cancel_indexing'] = 'Abbrechen';
$string['char'] = 'Zeichen';
$string['chars'] = 'Zeichen';
$string['choose_files'] = 'Dateien auswählen';
$string['clear_selection'] = 'Auswahl löschen';
$string['close'] = 'Tutor IA schließen';
$string['configuration_error'] = 'Konfigurationsfehler';
$string['configure_now'] = 'Jetzt konfigurieren';
$string['connection_interrupted'] = '[Verbindung unterbrochen]';
$string['course_custom_prompt'] = 'Kursspezifische benutzerdefinierte Eingabeaufforderung';
$string['course_custom_prompt_help'] = 'Diese benutzerdefinierte Eingabeaufforderung überschreibt die globale Einstellung nur für diesen Kurs. Leer lassen, um die globale Eingabeaufforderung zu verwenden.';
$string['course_indexing'] = 'Kurssynchronisierung';
$string['course_materials'] = 'Kursmaterialien (PDFs)';
$string['course_materials_help'] = 'Laden Sie zusätzliche PDF-Dateien hoch, auf die der KI-Tutor beim Beantworten von Fragen verweisen soll.';
$string['custom_prompt'] = 'Benutzerdefinierte Eingabeaufforderung';
$string['custom_prompt_desc'] = 'Benutzerdefinierte Anweisungen zur Steuerung des KI-Tutor-Verhaltens. Verwenden Sie dieses Feld, um spezifische Richtlinien, Ton oder Wissensgrenzen für den Tutor bereitzustellen.';
$string['customavatar'] = 'Benutzerdefinierter Avatar';
$string['customavatar_desc'] = 'Laden Sie Ihr eigenes benutzerdefiniertes Avatar-Bild hoch. Dies überschreibt den ausgewählten vordefinierten Avatar.';
$string['customavatar_dimensions'] = 'Empfohlene Abmessungen: 200x200 Pixel. Unterstützte Formate: PNG, JPG, JPEG, SVG. Maximale Dateigröße: 512KB.';
$string['drag_drop_upload'] = 'PDF-Dateien hier ablegen';
$string['drag_drop_upload_or_browse'] = 'oder klicken zum Durchsuchen';
$string['drawer_side'] = 'Öffnungsseite des Schubfachs';
$string['drawer_side_help'] = 'Wählen Sie, von welcher Seite das Chat-Schubfach geöffnet wird. Dies ist unabhängig von der Position der Avatar-Schaltfläche.';
$string['drawer_side_left'] = 'Von links öffnen';
$string['drawer_side_right'] = 'Von rechts öffnen';
$string['dttutor:use'] = 'Tutor-IA verwenden';
$string['enable_tutor_for_course'] = 'KI-Tutor für diesen Kurs aktivieren';
$string['enable_tutor_for_course_help'] = 'Wenn aktiviert, steht der KI-Tutor Studenten und Lehrern in diesem Kurs zur Verfügung. Die globale Plugin-Einstellung muss ebenfalls aktiviert sein.';
$string['enabled'] = 'Chat aktivieren';
$string['enabled_desc'] = 'Tutor-IA Chat global aktivieren oder deaktivieren';
$string['error_api_not_configured'] = 'API-Konfiguration fehlt. Bitte überprüfen Sie Ihre Einstellungen.';
$string['error_api_request_failed'] = 'API-Anfragefehler: {$a}';
$string['error_attempt_later'] = 'Ein Fehler ist aufgetreten. Bitte versuchen Sie es später erneut.';
$string['error_cache_unavailable'] = 'Der Chat-Dienst ist vorübergehend nicht verfügbar. Bitte versuchen Sie, die Seite zu aktualisieren.';
$string['error_empty_message'] = 'Die Nachricht darf nicht leer sein';
$string['error_establish_sse_connection'] = '[Fehler] SSE-Verbindung konnte nicht hergestellt werden';
$string['error_http_code'] = 'HTTP-Fehler {$a}';
$string['error_insufficient_tokens'] = 'Es sind nicht genügend KI-Credits verfügbar, um Ihre Anfrage zu bearbeiten. Bitte kontaktieren Sie Ihren Administrator, um weitere Credits hinzuzufügen und den KI-Tutor weiter zu nutzen.';
$string['error_insufficient_tokens_short'] = 'Unzureichende Credits';
$string['error_internal'] = 'Interner Fehler: {$a}';
$string['error_invalid_api_response'] = 'Ungültige API-Antwort';
$string['error_invalid_coordinates'] = 'Ungültige Koordinaten. Bitte verwenden Sie gültige CSS-Werte (z.B. 10px, 2rem, 50%)';
$string['error_invalid_message'] = 'Bitte geben Sie eine gültige Nachricht ein';
$string['error_invalid_position'] = 'Ungültige Positionsdaten';
$string['error_license_fallback'] = 'Lizenzfehler: {$a}';
$string['error_license_fallback_short'] = 'Lizenzfehler';
$string['error_license_not_allowed'] = 'Ihre Website-Lizenz erlaubt keinen Zugriff auf den KI-Tutor-Dienst. Bitte kontaktieren Sie Ihren Administrator, um Ihren Lizenzstatus zu überprüfen oder Ihren Plan zu aktualisieren.';
$string['error_license_not_allowed_short'] = 'Lizenzfehler';
$string['error_message_too_long'] = '[Fehler] Nachricht ist zu lang. Maximal 4000 Zeichen.';
$string['error_metadata_too_large'] = 'Die mit Ihrer Nachricht gesendeten Metadaten sind zu groß. Bitte versuchen Sie es erneut.';
$string['error_no_credits'] = 'Unzureichende KI-Credits verfügbar.';
$string['error_no_credits_fallback'] = 'Unzureichende Credits: {$a}';
$string['error_no_credits_short'] = 'Keine Credits Verfügbar';
$string['error_selected_text_too_large'] = 'Der ausgewählte Text ist zu groß. Bitte wählen Sie einen kleineren Abschnitt.';
$string['error_unexpected'] = 'Ein unerwarteter Fehler ist aufgetreten. Bitte versuchen Sie es erneut.';
$string['error_unknown'] = 'Ein unbekannter Fehler ist aufgetreten. Bitte versuchen Sie es erneut.';
$string['error_webservice_not_configured'] = 'Der KI-Tutor-Chat ist nicht richtig konfiguriert und ist derzeit nicht verfügbar.';
$string['error_webservice_not_configured_action'] = 'Bitte kontaktieren Sie Ihren Website-Administrator oder melden Sie dieses Problem, um den Chat-Service zu aktivieren.';
$string['error_webservice_not_configured_admin'] = 'Der Webservice des Datacurso KI-Providers muss konfiguriert werden, bevor der KI-Tutor verwendet werden kann. <a href="{$a}" target="_blank">Klicken Sie hier, um ihn jetzt zu konfigurieren</a>.';
$string['error_webservice_not_configured_admin_inline'] = 'Der Webservice des Datacurso KI-Providers muss konfiguriert werden, bevor der KI-Tutor verwendet werden kann.';
$string['error_webservice_not_configured_short'] = 'Chat-Service nicht verfügbar';
$string['indexing_cancelled'] = 'Abgebrochen';
$string['indexing_completed'] = 'Synchronisiert';
$string['indexing_failed'] = 'Synchronisierung fehlgeschlagen';
$string['indexing_interrupted'] = 'Unterbrochen';
$string['indexing_not_indexed'] = 'Nicht synchronisiert';
$string['indexing_phase_estimating'] = 'Token schätzen...';
$string['indexing_phase_fetching'] = 'Kursdaten abrufen...';
$string['indexing_phase_finalizing'] = 'Fertigstellen...';
$string['indexing_phase_initializing'] = 'Initialisieren...';
$string['indexing_phase_preparing'] = 'Dokumente vorbereiten...';
$string['indexing_phase_uploading'] = 'Dokumente hochladen...';
$string['indexing_progress'] = 'Fortschritt: {$a}%';
$string['indexing_running'] = 'Synchronisierung läuft';
$string['indexing_status'] = 'Synchronisierungsstatus';
$string['last_indexed'] = 'Zuletzt synchronisiert: {$a}';
$string['line'] = 'Zeile';
$string['lines'] = 'Zeilen';
$string['loading'] = 'Lädt...';
$string['manage_tutor'] = 'KI-Tutor Verwaltung';
$string['material_deleted'] = 'Material erfolgreich gelöscht';
$string['material_uploaded'] = 'Material erfolgreich hochgeladen';
$string['off_topic_detection_enabled'] = 'Off-Topic-Erkennung aktivieren';
$string['off_topic_detection_enabled_desc'] = 'Wenn aktiviert, erkennt der KI-Tutor Off-Topic-Nachrichten und reagiert entsprechend der unten konfigurierten Strenge.';
$string['off_topic_strictness'] = 'Off-Topic-Strenge';
$string['off_topic_strictness_desc'] = 'Kontrollieren Sie, wie streng die Off-Topic-Erkennung ist. Permissiv erlaubt mehr Flexibilität, während streng nur kursbezogene Gespräche erzwingt.';
$string['off_topic_strictness_moderate'] = 'Moderat';
$string['off_topic_strictness_permissive'] = 'Permissiv';
$string['off_topic_strictness_strict'] = 'Streng';
$string['open'] = 'Tutor IA öffnen';
$string['or_click_to_browse'] = 'oder klicken zum Durchsuchen';
$string['pluginname'] = 'Tutor IA';
$string['position_custom'] = 'Benutzerdefinierte Position';
$string['position_left'] = 'Untere linke Ecke';
$string['position_preset'] = 'Vordefinierte Position';
$string['position_right'] = 'Untere rechte Ecke';
$string['position_x'] = 'Horizontale Position (X)';
$string['position_x_help'] = 'Abstand vom linken Rand. Beispiele: 2rem, 20px, 5%. Verwenden Sie negative Werte, um vom rechten Rand zu positionieren.';
$string['position_x_label'] = 'X: {$a->value} (von {$a->ref})';
$string['position_y'] = 'Vertikale Position (Y)';
$string['position_y_help'] = 'Abstand vom unteren Rand. Beispiele: 6rem, 80px, 10%. Verwenden Sie negative Werte, um vom oberen Rand zu positionieren.';
$string['position_y_label'] = 'Y: {$a->value} (von {$a->ref})';
$string['positiondisplay_corner'] = 'Position: {$a->preset} Ecke | Schubfach: {$a->drawer}';
$string['positiondisplay_custom'] = 'Position: X: {$a->x}, Y: {$a->y} | Schubfach: {$a->drawer}';
$string['preview'] = 'Live-Vorschau';
$string['ref_bottom'] = 'Unten';
$string['ref_left'] = 'Links';
$string['ref_right'] = 'Rechts';
$string['ref_top'] = 'Oben';
$string['reference_edge_x'] = 'Horizontale Referenzkante';
$string['reference_edge_y'] = 'Vertikale Referenzkante';
$string['restart_indexing'] = 'Kurs erneut synchronisieren';
$string['selected'] = 'ausgewählt';
$string['selection_indicator'] = '{$a} Zeilen ausgewählt';
$string['selectionformat'] = '{$a->lines} {$a->linetext}, {$a->chars} {$a->chartext} ausgewählt';
$string['sendmessage'] = 'Nachricht senden';
$string['sessionnotready'] = 'Die Tutor-IA Sitzung ist nicht bereit. Bitte versuchen Sie es erneut.';
$string['start_indexing'] = 'Synchronisierung starten';
$string['student'] = 'Student';
$string['teacher'] = 'Lehrer';
$string['tutor_disabled_notice'] = 'Der KI-Tutor ist derzeit für diesen Kurs deaktiviert. Studenten sehen die Chat-Oberfläche nicht.';
$string['tutor_status'] = 'KI-Tutor Status';
$string['tutorcustomization'] = 'Tutor-Anpassung';
$string['tutorname_default'] = 'KI-Tutor';
$string['tutorname_setting'] = 'Tutor-Name';
$string['tutorname_setting_desc'] = 'Konfigurieren Sie den Namen, der im Chat-Header angezeigt wird. Sie können {teachername} verwenden, um den tatsächlichen Lehrernamen aus dem Kurs anzuzeigen, oder einen benutzerdefinierten Namen eingeben. Beispiele: "{teachername}" zeigt "Max Müller", "KI-Assistent" zeigt "KI-Assistent".';
$string['typemessage'] = 'Geben Sie Ihre Nachricht ein...';
$string['unauthorized'] = 'Unbefugter Zugriff';
$string['upload_files'] = 'Dateien hochladen';
$string['upload_material'] = 'Material hochladen';
$string['welcomemessage'] = 'Hallo! Ich bin Ihr KI-Assistent. Wie kann ich Ihnen heute helfen?';
$string['welcomemessage_default'] = 'Hallo! Ich bin {teachername}, Ihr KI-Assistent. Wie kann ich Ihnen heute helfen?';
$string['welcomemessage_setting'] = 'Willkommensnachricht';
$string['welcomemessage_setting_desc'] = 'Passen Sie die Willkommensnachricht an, die beim Öffnen des Chats angezeigt wird. Sie können Platzhalter verwenden: {teachername}, {coursename}, {username}, {firstname}';
$string['yesterday'] = 'Gestern';
