define("local_forum_ai/review",["exports","core/ajax","core/notification","core/str"],(function(_exports,_ajax,_notification,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Local forum ai review.
   *
   * @module      local_forum_ai/review
   * @copyright   2025 Datacurso
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_ajax=_interopRequireDefault(_ajax),_notification=_interopRequireDefault(_notification);_exports.init=async()=>{const editBtn=document.getElementById("edit-btn"),viewDiv=document.getElementById("airesponse-view"),editForm=document.getElementById("airesponse-edit"),cancelBtn=document.getElementById("cancel-edit"),textarea=editForm?editForm.querySelector("textarea[name='message']"):null,saveBtn=editForm?editForm.querySelector("button[type='submit']"):null,token=editForm?editForm.dataset.token:null,[strUpdatedSuccess,strUpdatedError,strApproved,strRejected,strActionFailed]=await Promise.all([(0,_str.get_string)("response_updated","local_forum_ai"),(0,_str.get_string)("response_update_failed","local_forum_ai"),(0,_str.get_string)("response_approved","local_forum_ai"),(0,_str.get_string)("response_rejected","local_forum_ai"),(0,_str.get_string)("action_failed","local_forum_ai")]);editBtn&&editBtn.addEventListener("click",(()=>{viewDiv.style.display="none",editForm.style.display="block"})),cancelBtn&&cancelBtn.addEventListener("click",(()=>{editForm.style.display="none",viewDiv.style.display="block"})),saveBtn&&saveBtn.addEventListener("click",(e=>{e.preventDefault();const newMessage=textarea.value;_ajax.default.call([{methodname:"local_forum_ai_update_response",args:{token:token,message:newMessage}}])[0].done((response=>{"ok"===response.status?(viewDiv.querySelector(".card-text").innerHTML=response.message,_notification.default.addNotification({message:strUpdatedSuccess,type:"success"}),editForm.style.display="none",viewDiv.style.display="block"):_notification.default.addNotification({message:strUpdatedError,type:"error"})})).fail(_notification.default.exception)})),document.querySelectorAll(".action-btn").forEach((btn=>{btn.addEventListener("click",(e=>{e.preventDefault();const action=btn.dataset.action,token=btn.dataset.token;_ajax.default.call([{methodname:"local_forum_ai_approve_response",args:{token:token,action:action}}])[0].done((response=>{response.success?(_notification.default.addNotification({message:"approve"===action?strApproved:strRejected,type:"success"}),setTimeout((()=>{window.location.href="".concat(M.cfg.wwwroot,"/mod/forum/discuss.php?d=").concat(btn.dataset.discussionid)}),1500)):_notification.default.addNotification({message:strActionFailed,type:"error"})})).fail(_notification.default.exception)}))}))}}));

//# sourceMappingURL=review.min.js.map