define("local_forum_ai/pending",["exports","core/modal_factory","core/ajax","core/notification","core/templates","local_forum_ai/utils/render_post","core/str"],(function(_exports,_modal_factory,_ajax,_notification,_templates,_render_post,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Local forum ai pending.
   *
   * @module      local_forum_ai/pending
   * @copyright   2025 Datacurso
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_modal_factory=_interopRequireDefault(_modal_factory),_ajax=_interopRequireDefault(_ajax),_notification=_interopRequireDefault(_notification),_templates=_interopRequireDefault(_templates);_exports.init=()=>{document.querySelectorAll(".view-details").forEach((btn=>{btn.addEventListener("click",(e=>{const token=e.currentTarget.dataset.token;_ajax.default.call([{methodname:"local_forum_ai_get_details",args:{token:token}}])[0].done((async data=>{const[modalTitle,discussionLabel,noPosts,aiResponseProposed,saveLabel,saveApproveLabel,rejectLabel]=await Promise.all([(0,_str.get_string)("modal_title_pending","local_forum_ai"),(0,_str.get_string)("discussion_label","local_forum_ai",data.discussion),(0,_str.get_string)("no_posts","local_forum_ai"),(0,_str.get_string)("ai_response_proposed","local_forum_ai"),(0,_str.get_string)("save","local_forum_ai"),(0,_str.get_string)("saveapprove","local_forum_ai"),(0,_str.get_string)("reject","local_forum_ai")]),body=await async function(data){let editMode=arguments.length>1&&void 0!==arguments[1]&&arguments[1],strings=arguments.length>2?arguments[2]:void 0;const posts=[];for(const post of data.posts){const postHtml=await(0,_render_post.renderPost)(post);posts.push({html:postHtml})}return _templates.default.render("local_forum_ai/pending_modal",{course:data.course,forum:data.forum,discussionlabel:strings.discussionLabel,noposts:0===data.posts.length,nopoststext:strings.noPosts,posts:posts,airesponseproposed:strings.aiResponseProposed,token:data.token,editmode:editMode,airesponse:data.airesponse,savelabel:strings.saveLabel,saveapprovelabel:strings.saveApproveLabel,rejectlabel:strings.rejectLabel})}(data,!0,{discussionLabel:discussionLabel,noPosts:noPosts,aiResponseProposed:aiResponseProposed,saveLabel:saveLabel,saveApproveLabel:saveApproveLabel,rejectLabel:rejectLabel});_modal_factory.default.create({type:_modal_factory.default.types.DEFAULT,title:modalTitle,body:body,large:!0}).done((modal=>{modal.show(),function(root,token){root.on("click",".save-ai",(e=>{e.preventDefault();const newMessage=root.find("#airesponse-edit").val();_ajax.default.call([{methodname:"local_forum_ai_update_response",args:{token:token,message:newMessage}}])[0].done((response=>{root.find("#airesponse-content").html(response.message),location.reload()})).fail(_notification.default.exception)})),root.on("click",".save-approve-ai",(e=>{e.preventDefault();const newMessage=root.find("#airesponse-edit").val();_ajax.default.call([{methodname:"local_forum_ai_update_response",args:{token:token,message:newMessage}}])[0].done((()=>{_ajax.default.call([{methodname:"local_forum_ai_approve_response",args:{token:token,action:"approve"}}])[0].done((()=>{location.reload()})).fail(_notification.default.exception)})).fail(_notification.default.exception)})),root.on("click",".reject-ai",(e=>{e.preventDefault(),_ajax.default.call([{methodname:"local_forum_ai_approve_response",args:{token:token,action:"reject"}}])[0].done((()=>{location.reload()})).fail(_notification.default.exception)}))}(modal.getRoot(),data.token)}))})).fail(_notification.default.exception)}))})),document.querySelectorAll(".action-btn").forEach((btn=>{btn.addEventListener("click",(e=>{e.preventDefault();const token=btn.dataset.token,action=btn.dataset.action;_ajax.default.call([{methodname:"local_forum_ai_approve_response",args:{token:token,action:action}}])[0].done((()=>{const row=btn.closest("tr");row&&row.remove()})).fail((ex=>{const msg=ex.message;_notification.default.addNotification({message:msg,type:"error"})}))}))}))}}));

//# sourceMappingURL=pending.min.js.map