/**
 * Forum AI grading integration module.
 *
 * Responsible for injecting and managing the "Review with AI" button
 * inside the Moodle forum grading interface. The button is dynamically
 * repositioned depending on the active grading method (simple grade,
 * rubric, or marking guide) and reacts to real DOM changes instead
 *
 * This implementation improves performance and stability by using:
 *  - Moodle PubSub events
 *  - MutationObserver for DOM changes
 *  - Controlled button state handling
 *
 * @module      local_forum_ai/analyze
 * @copyright   2025 Datacurso
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_forum_ai/analyze",["jquery","core/pubsub","core/ajax","core/str"],(function($,PubSub,Ajax,Str){function resetLoading(button){const originalText=button.dataset.originalText||"";button.classList.remove("forum-ai-btnloading"),button.removeAttribute("aria-disabled"),button.style.pointerEvents="",button.innerHTML=originalText}return{init:function(){const $button=$("#forum-ai-review-btn");let lastState=null;if(0===$button.length)return;const injectButtonIntoGrader=function(){const simpleInput=document.querySelector('input[name="grade"]'),rubricForm=document.querySelector('form[id^="gradingform_rubric"]'),guideForm=document.querySelector('form[id^="gradingform_guide"]');let target=null;simpleInput?target=simpleInput.closest("form"):rubricForm?target=rubricForm:guideForm&&(target=guideForm),target&&$(target).is(":visible")?$button.parent().is(target)?$button.is(":visible")||($button.show(),lastState="visible"):($button.detach().prependTo(target).show(),lastState="visible"):"hidden"!==lastState&&($button.hide(),lastState="hidden")};PubSub.subscribe("drawer-opened",(function(){setTimeout(injectButtonIntoGrader,300)})),function(){const container=document.querySelector('[data-region="user_picker"]');if(!container)return;new MutationObserver((function(){setTimeout(injectButtonIntoGrader,300)})).observe(container,{childList:!0,subtree:!0})}(),new MutationObserver((function(){injectButtonIntoGrader()})).observe(document.body,{childList:!0,subtree:!0}),setTimeout(injectButtonIntoGrader,500),$(document).on("click","#forum-ai-review-btn",(async function(e){e.preventDefault();const button=this;if(button.classList.contains("forum-ai-btnloading"))return;await async function(button){const loadingText=await Str.get_string("evaluatingwithai","local_forum_ai");button.dataset.originalText=button.innerHTML,button.classList.add("forum-ai-btnloading"),button.setAttribute("aria-disabled","true"),button.style.pointerEvents="none",button.innerHTML='<i class="fa fa-spinner fa-spin"></i> '+loadingText}(button);const cmid=new URLSearchParams(window.location.search).get("id"),userNode=document.querySelector('[data-region="name"][data-userid]'),userid=userNode?userNode.getAttribute("data-userid"):null;cmid&&userid?Ajax.call([{methodname:"local_forum_ai_process_review",args:{cmid:parseInt(cmid,10),userid:parseInt(userid,10)}}])[0].done((function(response){const data=JSON.parse(response.data);var guideData;"simple"===response.type&&function(data){$('input[name="grade"]').val(data.grade)}(data),"rubric"===response.type&&data.forEach((function(crit){document.querySelectorAll('h5[id^="criterion-description-"]').forEach((h5=>{if(h5.textContent.trim()!==crit.criterion)return;const mainContainer=h5.closest(".mb-3");if(!mainContainer)return;const selectedLevel=crit.levels[0],collapseDiv=mainContainer.querySelector('.collapse[role="radiogroup"]');if(!collapseDiv)return;collapseDiv.querySelectorAll(".form-check").forEach((formCheck=>{const label=formCheck.querySelector("label"),input=formCheck.querySelector('input.level[type="radio"]');if(!label||!input)return;const descriptionSpan=label.querySelector("span:first-child");descriptionSpan&&descriptionSpan.textContent.trim()===selectedLevel.description&&(input.checked=!0,input.setAttribute("aria-checked","true"),input.setAttribute("tabindex","0"),input.setAttribute("data-initial-value","true"),input.dispatchEvent(new Event("change",{bubbles:!0})))}));const textarea=mainContainer.querySelector('textarea[id^="advancedgrading-criteria-"][id$="-remark"]');textarea&&crit.reply&&(textarea.value=crit.reply,textarea.setAttribute("data-initial-value",JSON.stringify(crit.reply)),textarea.hasAttribute("data-auto-rows")&&textarea.dispatchEvent(new Event("input",{bubbles:!0})))}))})),"guide"===response.type&&(guideData=data,document.querySelectorAll('[data-gradingform-guide-role="criterion"]').forEach((container=>{const title=container.querySelector("h5").textContent.trim();if(!guideData[title])return;const result=guideData[title],inputScore=container.querySelector('input[type="number"]'),textarea=container.querySelector("textarea");inputScore&&(inputScore.value=result.grade),textarea&&(textarea.value=result.reply.join("\n"))}))),resetLoading(button)})).fail((function(){resetLoading(button)})):resetLoading(button)}))}}}));

//# sourceMappingURL=analyze.min.js.map