define("local_forum_ai/history",["exports","core/modal_factory","core/ajax","core/notification","core/str","core/templates","local_forum_ai/utils/render_post"],(function(_exports,_modal_factory,_ajax,_notification,_str,_templates,_render_post){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Local forum ai history
   *
   * @module      local_forum_ai/history
   * @copyright   2025 Datacurso
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_modal_factory=_interopRequireDefault(_modal_factory),_ajax=_interopRequireDefault(_ajax),_notification=_interopRequireDefault(_notification),_templates=_interopRequireDefault(_templates);_exports.init=()=>{document.querySelectorAll(".view-details").forEach((btn=>{btn.addEventListener("click",(e=>{const token=e.currentTarget.dataset.token;_ajax.default.call([{methodname:"local_forum_ai_get_details",args:{token:token}}])[0].done((async data=>{const[modalTitle,discussionLabel,noPosts,aiResponse,aiResponseApproved,aiResponseRejected]=await Promise.all([(0,_str.get_string)("modal_title","local_forum_ai"),(0,_str.get_string)("discussion_label","local_forum_ai",data.discussion),(0,_str.get_string)("no_posts","local_forum_ai"),(0,_str.get_string)("ai_response","local_forum_ai"),(0,_str.get_string)("ai_response_approved","local_forum_ai"),(0,_str.get_string)("ai_response_rejected","local_forum_ai")]),body=await async function(data,strings){const posts=[];for(const post of data.posts){const postHtml=await(0,_render_post.renderPost)(post);posts.push({html:postHtml})}let statusClass="bg-secondary",statusIcon="fa fa-robot",statusLabel=strings.aiResponse;"approved"===data.status?(statusClass="bg-success text-white",statusIcon="fa fa-check",statusLabel=strings.aiResponseApproved):"rejected"===data.status&&(statusClass="bg-danger text-white",statusIcon="fa fa-times",statusLabel=strings.aiResponseRejected);return _templates.default.render("local_forum_ai/history_modal",{course:data.course,forum:data.forum,discussionlabel:strings.discussionLabel,noposts:0===data.posts.length,nopoststext:strings.noPosts,posts:posts,statusclass:statusClass,statusicon:statusIcon,statuslabel:statusLabel,airesponse:data.airesponse})}(data,{discussionLabel:discussionLabel,noPosts:noPosts,aiResponse:aiResponse,aiResponseApproved:aiResponseApproved,aiResponseRejected:aiResponseRejected});_modal_factory.default.create({type:_modal_factory.default.types.DEFAULT,title:modalTitle,body:body,large:!0}).done((modal=>modal.show()))})).fail(_notification.default.exception)}))}))}}));

//# sourceMappingURL=history.min.js.map