define("local_socialcert/actions",["exports","core/str","core/ajax"],(function(_exports,_str,_ajax){var obj;
/**
   * Plugin version and other meta-data are defined here.
   *
   * @package
   * @copyright   2025 Manuel Bojaca <manuel@buendata.com>
   * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=function(cmid){const root=document.querySelector(".local-socialcert");if(!root)return;register("open-link",handleOpenLink),register("copy-html",handleCopyHtml),register("run-ai",runAiHandler(cmid)),function(root,selector,type,handler){root.addEventListener(type,(ev=>{const target=(ev.target instanceof Element?ev.target:root).closest(selector);target&&root.contains(target)&&handler(ev,target)}))}(root,"[data-action]","click",((ev,el)=>{const action=el.dataset.action,fn=registry.get(action);fn&&fn(ev,el)}))},_exports.register=register,_exports.runAiHandler=runAiHandler,_exports.typewriter=typewriter,_ajax=(obj=_ajax)&&obj.__esModule?obj:{default:obj};const registry=new Map;function handleOpenLink(ev,el){ev.preventDefault(),el.setAttribute("aria-busy","true");const url=el.getAttribute("href")||el.dataset.url;url&&window.open(url,"_blank","noopener"),setTimeout((()=>el.removeAttribute("aria-busy")),300)}async function handleCopyHtml(_ev,el){const sel=el.dataset.target||"",node=sel?document.querySelector(sel):null;if(!node)return;const clone=node.cloneNode(!0);clone.querySelectorAll(".lsc-caret").forEach((c=>c.remove()));const content="html"===("html"===el.dataset.copy?"html":"text")?clone.innerHTML:clone.innerText||clone.textContent||"";navigator.clipboard.writeText(content).then((()=>{const btn=el.querySelector('[data-action="copy-html"]');if(!btn)return;const originalHTML=btn.innerHTML;btn.textContent="✔",setTimeout((()=>{btn.textContent=originalHTML}),1200)})).catch((()=>{}))}function removeCaret(el){const caret=el.querySelector(".lsc-caret");caret&&caret.remove()}const streams=new WeakMap;function typewriter(el,text,mode,speedMs){if(/<[^>]+>/.test(text))return el.innerHTML=text,{stop(){},done:Promise.resolve()};const caret=function(el){const caret=document.createElement("span");return caret.className="lsc-caret",caret.textContent=" ",el.appendChild(caret),caret}(el),units="char"===mode?text.split(""):text.split(/\s+/);let i=0,stopped=!1;el.innerHTML="",el.appendChild(caret);return{stop(){const s=streams.get(el);s&&(s.stop(),streams.delete(el))},done:new Promise((resolve=>{const timer=setInterval((()=>{if(stopped)return clearInterval(timer),removeCaret(el),void resolve();if(i>=units.length)return clearInterval(timer),removeCaret(el),void resolve();const chunk=units[i++];caret.insertAdjacentText("beforebegin","word"===mode?chunk+" ":chunk)}),Math.max(10,speedMs||30));streams.set(el,{stop:()=>{stopped=!0}})}))}}function ai_response(certname,course,org,socialmedia,errorarray,cmid){return new Promise((resolve=>{_ajax.default.call([{methodname:"local_socialcert_get_ai_response",args:{body:{certname:certname,course:course,org:org,socialmedia:socialmedia},cmid:cmid}}])[0].then((response=>{if(response.json){const parsed=JSON.parse(response.json);return resolve({fulltext:parsed.reply,done:!0})}{const errormsg=function(message,errors){const msg=String(message||"").toLowerCase();return msg.includes("insufficient ai credits")?errors[0]:msg.includes("your license is not allowed")||msg.includes("manage credits")?errors[1]:errors[2]}(response.message,errorarray);return resolve({fulltext:errormsg,done:!1})}})).catch((()=>resolve({fulltext:errorarray[2],done:!1})))}))}function runAiHandler(cmid){return function(ev,btn){ev.preventDefault();const sel=btn.dataset.target;let target=null;if(sel)target=document.querySelector(sel);else{const wrap=btn.closest(".lsc-response-wrap");target=wrap?wrap.querySelector(".lsc-response"):null}if(!target)return;if(streams.has(target)){const s=streams.get(target);return s&&s.stop&&s.stop(),btn.disabled=!1,void(btn.textContent=(0,_str.get_string)("airesponsebtn","local_socialcert"))}const mode="char"===btn.dataset.mode?"char":"word",speed=parseInt(btn.dataset.speed||"40",10),certname=btn.dataset.certname||"",course=btn.dataset.course||"",org=btn.dataset.org||"",socialmedia=btn.dataset.socialmedia||"",original=btn.textContent;btn.disabled=!0,btn.textContent="Generating",target.setAttribute("aria-busy","true"),target.setAttribute("role","status");const loader=document.getElementById("ai-card"),copyBtn=document.getElementById("copyBtn"),errorLicense=btn.dataset.errorlicense,errorCredits=btn.dataset.errorcredits,errorGeneric=btn.dataset.errorgeneric,errorarray=[errorCredits,errorLicense,errorGeneric];let streamtext="";copyBtn.hidden=!0,ai_response(certname,course,org,socialmedia,errorarray,cmid).then((response=>{streamtext=response.fulltext,response.done&&(copyBtn.hidden=!1)})).catch((()=>{streamtext=errorGeneric})).finally((()=>{loader.classList.add("hidden"),loader.setAttribute("aria-busy","false");typewriter(target,streamtext,mode,speed).done.then((()=>{btn.disabled=!1,btn.textContent=original,target.removeAttribute("aria-busy"),streams.delete(target)}))}))}}function register(name,fn){registry.set(name,fn)}}));

//# sourceMappingURL=actions.min.js.map