/**
 * Provides live user search functionality for the lifestory report, including AJAX requests and dynamic result rendering.
 *
 * @module      report_lifestory/user_search
 * @copyright   2025 Datacurso
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("report_lifestory/user_search",["jquery","core/ajax","core/templates","core/notification"],(function($,Ajax,Templates,Notification){let searchTimeout=null;return{init:function(baseUrl){const searchInput=$("#usersearch"),clearButton=$("#clearsearch"),resultsContainer=$("#search-results");0!==searchInput.length&&(searchInput.on("input",(function(){const query=$(this).val().trim();if(0===query.length)return clearButton.hide(),void resultsContainer.addClass("d-none").empty();clearButton.show(),searchTimeout&&clearTimeout(searchTimeout),searchTimeout=setTimeout((function(){(function(query){return Ajax.call([{methodname:"report_lifestory_search_students",args:{query:query}}])[0]})(query).then((function(response){!function(students,baseUrl){const container=$("#search-results");if(container.empty(),!students||0===students.length)return void container.addClass("d-none");const context={students:students.map((student=>({id:student.id,fullname:student.fullname,email:student.email,profileimageurl:student.profileimageurl,baseurl:baseUrl,initial:student.fullname.charAt(0).toUpperCase()})))};Templates.render("report_lifestory/search_results",context).then((function(html,js){container.html(html).removeClass("d-none"),Templates.runTemplateJS(js)})).catch(Notification.exception)}(response&&response.students?response.students:[],baseUrl)})).catch(Notification.exception)}),300)})),clearButton.on("click",(function(e){e.preventDefault(),searchInput.val(""),clearButton.hide(),resultsContainer.addClass("d-none").empty(),searchInput.focus()})),searchInput.on("focus",(function(){$(this).val().trim().length>0&&resultsContainer.children().length>0&&resultsContainer.removeClass("d-none")})),$(document).on("click",(function(e){$(e.target).closest("#usersearch-wrapper").length||resultsContainer.addClass("d-none")})),searchInput.on("keydown",(function(e){"Enter"===e.key&&e.preventDefault()})))}}}));

//# sourceMappingURL=user_search.min.js.map