<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This plugin provides access to Moodle data in form of analytics and reports in real time.
 *
 * @package    local_intelliboard
 * @copyright  2020 IntelliBoard, Inc
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @website    http://intelliboard.net/
 */

namespace local_intelliboard\tools;

use local_intelliboard\repositories\tracking_file_storage;
use local_intelliboard\repositories\tracking_cache_storage;

class compress_tracking {

    const TYPE_LIVE = 0;
    const TYPE_FILE = 1;
    const TYPE_CACHE = 2;

    public static function getStorage($compresstrackingtype){
        if ($compresstrackingtype == self::TYPE_CACHE) {
            return new tracking_cache_storage();
        } elseif ($compresstrackingtype == self::TYPE_FILE) {
            return new tracking_file_storage();
        }
    }

}