<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
/**
* This plugin provides access to Moodle data in form of analytics and reports in real time.
*
*
* @package    local_intelliboard
* @copyright  2017 IntelliBoard, Inc
* @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
* @website    http://intelliboard.net/
*/
$string['pluginname'] = 'Plug-in IntelliBoard.net';
$string['tracking_title'] = 'Monitoreo de tiempo';
$string['tracking'] = 'Monitoreo de sesión';
$string['dashboard'] = 'Dashboard';
$string['settings'] = 'Ajustes';
$string['adv_settings'] = 'Ajustes avanzados';
$string['intelliboardroot'] = 'IntelliBoard';
$string['report'] = 'Informe';
$string['reports'] = 'Informes';
$string['learners'] = 'Estudiantes';
$string['courses'] = 'Cursos';
$string['load'] = 'Cargar';
$string['inactivity'] = 'Inactividad';
$string['inactivity_desc'] = 'Tiempo de inactividad del usuario (en segundos)';
$string['ajax'] = 'Frecuencia';
$string['ajax_desc'] = 'Frecuencia de almacenamiento de la sesión vía AJAX.O - AJAX desactivada (en segundos)';
$string['enabled'] = 'Monitoreo activado';
$string['enabled_desc'] = 'Activar monitoreo';
$string['trackadmin'] = 'Monitorear Admins';
$string['logs'] = 'Herramienta de migración';
$string['trackadmin_desc'] = 'Activar monitoreo para usuarios admin (no recomendado)';
$string['intelliboard:instructors'] = 'IntelliBoard [Instructor]';
$string['intelliboard:students'] = 'IntelliBoard [Estudiante]';
$string['intelliboard:view'] = 'IntelliBoard [Ver]';
$string['intelliboard:manage'] = 'IntelliBoard [Administrar]';
$string['intelliboard:competency'] = 'IntelliBoard [Competencia]';
$string['intelliboard:browseallcohorts'] = 'IntelliBoard [Browse All Cohorts]';
$string['tls12'] = 'TLS v1.2';
$string['tls12_desc'] = 'Ajustes avanzados:TLS v1.2';
$string['sso'] = 'SSO link';
$string['sso_desc'] = 'SSO Link a IntelliBoard.net';
$string['ssomenu'] = 'SSO item menu';
$string['ssomenu_desc'] = 'Enlace SSO en menu navegación (solo para admins)';
$string['server'] = 'Servidor IntelliBoard';
$string['server_usa'] = 'IntelliBoard USA';
$string['server_au'] = 'IntelliBoard Australia';
$string['server_eu'] = 'IntelliBoard Europa';
$string['filters'] = 'Filtros de Dashboard';
$string['filter1'] = 'Usuarios eliminados';
$string['filter2'] = 'Usuarios suspendidos';
$string['filter3'] = 'Usuario invitado';
$string['filter4'] = 'Filtro curso';
$string['filter5'] = 'Filtro método inscripción';
$string['filter6'] = 'Filtro inscripción usuario';
$string['filter7'] = 'Filtro actividades/recursos';
$string['filter8'] = 'Filtro usuarios inscritos';
$string['filter1_desc'] = 'Mostrar usuarios eliminados';
$string['filter2_desc'] = 'Mostrar usuarios suspendidos';
$string['filter3_desc'] = 'Mostrar usuários invitados en reportes';
$string['filter4_desc'] = 'Mostrar cursos no visibles';
$string['filter5_desc'] = 'Mostrar métodos de inscripción no activos';
$string['filter6_desc'] = 'Mostrar usuarios con estado de inscripción no activos';
$string['filter7_desc'] = 'Mostrar actividades/recursos no visibles';
$string['filter8_desc'] = 'Mostrar sólo usuarios inscritos (no recomendado)';
$string['intelliboardaccess'] = 'Ud. no tiene permiso para visualizar esta página.Por favor contacte a su Administrador de Sistema.';
$string['tex1'] = 'Dashboard del Estudiante no habilitado en IntelliBoard.';
$string['account'] = 'Información de suscripción';
$string['te12'] = 'Nombre';
$string['te13'] = 'Apellido';
$string['te1'] = 'Correo';
$string['te1_desc'] = 'Ingrese su correo utilizado para la suscripción a IntelliBoard.net.Si no tiene una suscripción activa, por favor regístrese en <a target="_blank" href="https://intelliboard.net">IntelliBoard.net</a>. Los Dashboards para estudiantes y profesores están disponibles con una suscripción de Nivel 4 y superior.';
$string['n1'] = 'Información [Progreso del Estudiante]';
$string['n2'] = 'Información [Progreso de Notas]';
$string['n3'] = 'Información [Progreso de Actividad]';
$string['n4'] = 'Información [Totales]';
$string['n5'] = 'Progreso actual';
$string['n6'] = 'Widget:Correlaciones';
$string['n7'] = 'Widget:Utilización de Evento';
$string['n8'] = 'Página de Curso';
$string['n9'] = 'Página de Reportes';
$string['n10'] = 'Dashboard Instructor';
$string['n11'] = 'Texto alternativo para menú de navegación';
$string['ts1'] = 'Dashboard del Estudiante';
$string['ts2'] = 'Dashboard Página del Estudiante';
$string['ts3'] = 'Dashboard Cursos del Estudiante';
$string['ts4'] = 'Dashboard Notas del Estudiante';
$string['ts5'] = 'Dashboard Reportes del Estudiante';
$string['learner_tf_last_week'] = 'Filtro de tiempo: Últimos 7 días';
$string['t01'] = 'Filtro de tiempo:Últimos 30 días';
$string['t02'] = 'Filtro de tiempo:Últimos 3 meses';
$string['t03'] = 'Filtro de tiempo:Últimos 6 meses';
$string['t04'] = 'Habilitar cursos completados [título]';
$string['t05'] = 'Habilitar cursos en progreso [título]';
$string['t06'] = 'Habilitar nota promedio de cursos [título]';
$string['t07'] = 'Habilitar Mensajes [título]';
$string['t08'] = 'Habilitar nota suma de cursos [título]';
$string['t09'] = 'El instructor puede ver a sus propios alumnos';
$string['t1'] = 'Habilitar Dashboard del Estudiante';
$string['t2'] = 'Habilitar Dashboard';
$string['t3'] = 'Habilitar cursos';
$string['t4'] = 'Habilitar notas';
$string['t48'] = 'Habilitar reportes';
$string['t5'] = 'Habilitar gráfico [Progreso de actividad]';
$string['t6'] = 'Habilitar gráfico [Progreso del curso]';
$string['t7'] = 'Habilitar [Mi promedio en el curso]';
$string['t8'] = 'Habilitar [Promedio general del curso]';
$string['t9'] = 'Habilitar widget [Tareas]';
$string['t10'] = 'Habilitar widget [Quizzes]';
$string['t11'] = 'Habilitar widget [Progreso del curso]';
$string['t12'] = 'Habilitar widget [Participación en actividad]';
$string['t13'] = 'Habilitar widget [Aprendizaje]';
$string['t14'] = 'Habilitar widget [Éxito del curso]';
$string['t15'] = 'Habilitar widget [Correlaciones]';
$string['t16'] = 'Habilitar profesor del curso';
$string['t17'] = 'Habilitar categoría del curso';
$string['t18'] = 'Habilitar conclusión del curso';
$string['t19'] = 'Habilitar nota del curso';
$string['t20'] = 'Habilitar promedio de la clase en el curso';
$string['t21'] = 'Habilitar tiempo invertido en el curso';
$string['t22'] = 'Habilitar fecha de inicio del curso';
$string['t23'] = 'Habilitar columna [Fecha de inicio del curso]';
$string['t24'] = 'Habilitar columna [Fecha inscrito]';
$string['t25'] = 'Habilitar columna [Progreso]';
$string['t26'] = 'Habilitar columna [Carta]';
$string['t27'] = 'Habilitar columna [Actividades completadas]';
$string['t28'] = 'Habilitar columna [Puntuación]';
$string['t29'] = 'Habilitar columna estatus [Conclusión del Curso]';
$string['t30'] = 'Habilitar columna [Notas de actividad]';
$string['t31'] = 'Habilitar columna widget [Tareas][Nota]';
$string['t32'] = 'Habilitar columna widget [Tareas][Fecha límite]';
$string['t33'] = 'Habilitar columna widget [Quizzes][Nota]';
$string['t34'] = 'Habilitar columna widget [Quizzes][Notas]';
$string['t35'] = 'Habilitar columna widget [Progreso del Curso][Progreso]';
$string['t36'] = 'Habilitar columna widget [Progreso del Curso][Nota]';
$string['t37'] = 'Habilitar columna widget [Progreso del Curso][Inscrito]';
$string['t38'] = 'Habilitar columna widget [Progreso del Curso][Completado]';
$string['t52'] = 'Habilitar fila widget [Progreso del Curso][Categoría]';
$string['t39'] = 'Habilitar opción [Progreso][Nota Objetivos]';
$string['t40'] = 'Habilitar opción [Progreso][Promedio Clase]';
$string['t41'] = 'Habilitar columna Completado el [Título Notas de actividad]';
$string['t42'] = 'Habilitar columna Último acceso al curso [Título Notas de actividad]';
$string['t43'] = 'Habilitar columna Tipo [Notas de actividad]';
$string['t44'] = 'Habilitar columna Puntuación [Notas de actividad]';
$string['t45'] = 'Habilitar columna Notas [Notas de actividad]';
$string['t46'] = 'Habilitar columna Completado [Notas de actividad]';
$string['t47'] = 'Color de fondo de cursos [grid]';
$string['t49'] = 'Columnas de filtrado de reportes';
$string['t50'] = 'Roles de profesor';
$string['t51'] = 'Roles de estudiante';
$string['current_grade'] = 'Nota actual';
$string['average_grade'] = 'Nota promedio';
$string['type_here'] = 'Escriba aquí...';
$string['enrolled_date'] = 'Fecha inscripción';
$string['teacher'] = 'Profesor';
$string['category'] = 'Categoría';
$string['current_grade'] = 'Nota actual';
$string['completion'] = 'Logro';
$string['class_average'] = 'Promedio de la clase';
$string['time_spent'] = 'Tiempo invertido';
$string['completed_on'] = 'Completado el {$a}';
$string['last_access_on_course'] = 'Último acceso al curso: {$a}';
$string['you_have_certificates'] = 'Ud. tiene certificados{$a}';
$string['close'] = 'Cerrar';
$string['view_course_details'] = 'Ver detalles del curso';
$string['incomplete'] = 'Incompleto';
$string['return_to_grades'] = 'Volver a Calificaciones';
$string['grade'] = 'Calificación';
$string['last_week'] = 'Últimos 7 días';
$string['last_month'] = 'Últimos 30 días';
$string['last_quarter'] = 'Últimos 3 meses';
$string['last_semester'] = 'Últimos 6 meses';
$string['activity_progress'] = 'Progreso de la actividad';
$string['course_progress'] = 'Progreso del curso';
$string['my_course_average_all'] = 'Mi promedio del curso (todos los cursos)';
$string['overall_course_average'] = 'Promedio global del curso (todos los estudiantes; todos los cursos))';
$string['assignments'] = 'Tareas';
$string['quizzes'] = 'Quizzes';
$string['assignment_name'] = 'Nombre tarea';
$string['due_date'] = 'Fecha límite';
$string['no_data'] = 'Sin datos';
$string['quiz_name'] = 'Nombre del quiz';
$string['all_courses'] = 'Todos los cursos';
$string['time_period_due'] = 'Período (Fecha límite)';
$string['all_data'] = 'Todos los datos';
$string['progress'] = 'Progreso';
$string['enrolled'] = 'Inscrito';
$string['completed'] = 'Completado el';
$string['activity_participation'] = 'Participación en actividad';
$string['learning'] = 'Aprendizaje';
$string['course_success'] = 'Éxito del curso';
$string['correlations'] = 'Correlaciones';
$string['course_start_date'] = 'Fecha de inicio del curso';
$string['letter'] = 'Letra';
$string['completed_activities'] = 'Actividades completadas';
$string['score'] = 'Puntuación';
$string['course_completion_status'] = 'Estatus de conclusión del curso';
$string['activity_grades'] = 'Notas de actividad';
$string['completion_is_not_enabled'] = 'Conclusión no habilitada para este curso';
$string['activities'] = 'Actividades';
$string['activity_name'] = 'Nombre actividad';
$string['type'] = 'Tipo';
$string['graded'] = 'Calificado';
$string['completed_courses'] = 'Cursos completados';
$string['courses_in_progress'] = 'Cursos en progreso';
$string['courses_avg_grade'] = 'Nota promedio de cursos';
$string['courses_sum_grade'] = 'Curso Suma Grado por Valor de Escala de Grado';
$string['grades'] = 'Notas';
$string['messages'] = 'Mensajes';
$string['x_completions'] = '{$a} Logros';
$string['completion_status'] = 'Estatus de conclusión';
$string['users_activity'] = 'Actividad del usuario';
$string['daily'] = 'Últimos 10 días';
$string['weekly'] = 'Últimos 90 días';
$string['monthly'] = 'Últimos 365 días';
$string['number_of_sessions'] = 'Número de sesiones';
$string['number_today'] = '{$a} hoy';
$string['number_this_week'] = '{$a} esta semana';
$string['course_completions'] = 'Cursos concluidos';
$string['user_enrolments'] = 'Inscripciones del usuario';
$string['users'] = 'Usuarios';
$string['modules'] = 'Módulos';
$string['categories'] = 'Categorías';
$string['total'] = 'Total';
$string['users_overview'] = 'Información de usuarios';
$string['enable_time_and_visits_users_overview'] = 'Habilitar tiempo invertido y visitas en Información de usuarios';
$string['disable_time_and_visits_users_overview'] = 'Inhabilitar tiempo invertido y visitas en Información de usuarios';
$string['loading'] = 'Cargando...';
$string['enrollments'] = 'Inscripciones';
$string['registrations'] = 'Registros';
$string['participation'] = 'Participación';
$string['time'] = 'Tiempo';
$string['enrolment_method'] = 'Método de inscripción';
$string['intelliBoard_migration_tool'] = 'Herramienta de Migración IntelliBoard';
$string['importing_totals'] = 'Totales de importaciones';
$string['total_numbers'] = 'Fecha: {$a->timepoint}, Sesiones: {$a->sessions}, Visitas: {$a->visits}, Tiempo invertidos: {$a->timespend}';
$string['total_numbers2'] = 'USUARIO:: {$a->userid}, Página: {$a->page}, Param:{$a->param}, Visitas: {$a->visits}, Tiempo invertido: {$a->timespend}';
$string['total_numbers3'] = '----Fecha: {$a->timecreated}, Monitorear ID: {$a->trackid}, Visitas: {$a->visits}, iempo invertido: {$a->timespend}';
$string['logs_to_process'] = 'Registros por procesar {$a}';
$string['please_wait_or_cancel'] = 'Por favor espere para continuar o <a href="{$a}">Cancelar</a>';
$string['done'] = 'Listo!';
$string['return_to_home'] = 'Volver a Inicio';
$string['importing_logs'] = 'Importar registros';
$string['intelliBoard_migration_tool_info'] = 'La herramienta de migración IntelliBoard se utiliza para migrar los datos históricos de la tabla de registros de Moodle hacia el nuevo formato.Por favor tenga en cuenta que el procedimiento de almacenamiento de los registros de Moodle no cambiará.Una vez completada la migración de los datos históricos hacia el nuevo formato, valores históricos como \'Tiempo invertido\' y \'Visitas\' estarán disponibles para visualización en IntelliBoard.net.';
$string['moodle_logs'] = 'Registros Moodle';
$string['intelliboard_tracking'] = 'Monitoreo IntelliBoard';
$string['intelliboard_logs'] = 'Registros IntelliBoard';
$string['intelliboard_totals'] = 'Totales IntelliBoard';
$string['intelliboard_start_tracking'] = 'Monitoreo de inicio IntelliBoard';
$string['total_values_include'] = 'Los valores totales incluyen sesiones únicas, cursos, visitas, tiempo invertido.';
$string['items_per_query'] = 'Elementos por consulta';
$string['import'] = 'Importar';
$string['log_values_include'] = 'Los valores de registro incluyen registros para cada usuario por día.';
$string['powered_by'] = 'Powered by <a href="https://intelliboard.net/">IntelliBoard.net</a>';
$string['intelliboardnet'] = 'IntelliBoard.net';
$string['visits'] = 'Visitas';
$string['registered'] = 'Registrado';
$string['disabled'] = 'Inhabilitado';
$string['enrolled_completed'] = 'Inscritos: {$a->courses}, Completado: {$a->completed_courses}';
$string['enrolled_users_completed'] = 'Usarios inscritos: {$a->users}, Completado: {$a->completed}';
$string['user_grade_avg'] = '{$a->user} Nota: {$a->grade}, Nota promedio: {$a->avg_grade_site})';
$string['user_visit_avg'] = '{$a->user} Visitas: {$a->visits}, Visitas promedio: {$a->avg_visits_site}';
$string['user_time_avg'] = '{$a->user} Tiempo: {$a->timespend}, Tiempo promedio: {$a->avg_timespend_site}';
$string['more_users'] = 'Más usuarios';
$string['more_courses'] = 'Más cursos';
$string['showing_1_to_10'] = 'Mostrar 1 a 10';
$string['course_grade'] = 'Nota del curso';
$string['completed_activities_resourses'] = 'Actividades/recursos completados';
$string['save'] = 'Guardar';
$string['help'] = '¿Necesita ayuda?';
$string['in1'] = 'Información general';
$string['in2'] = 'Progreso actual';
$string['in3'] = 'Total Cursos';
$string['in4'] = 'Total Estudiantes';
$string['in5'] = 'Notas totales del curso';
$string['in6'] = 'Estudiantes completos';
$string['in7'] = 'Estudiantes incompletos';
$string['in8'] = 'Nota promedio del estudiante';
$string['in9'] = 'Correlaciones';
$string['in10'] = 'Utilización de evento';
$string['in11'] = 'Progreso del estudiante';
$string['in12'] = 'Progreso de calificación';
$string['in13'] = 'Tiempo invertido (%)';
$string['in14'] = '% Progreso';
$string['in15'] = 'Logros Estudiante';
$string['in16'] = 'Último acceso';
$string['in17'] = 'Tiempo total invertido';
$string['in18'] = 'Visitas totales';
$string['in19'] = 'Nota promedio';
$string['in20'] = 'Volver a Estudiantes';
$string['in201'] = 'Volver a Actividades';
$string['in21'] = 'Nota promedio del curso';
$string['in22'] = 'Habilitado';
$string['in23'] = 'No hay estudiantes para mostrar.';
$string['in24'] = 'Módulos';
$string['in25'] = 'Nota aprobatoria';
$string['status'] = 'Estado';
$string['course_category'] = 'Categoría del curso';
$string['course_started'] = 'Curso iniciado';
$string['total_time_spent_enrolled_learners'] = 'Tiempo total invertido por estudiantes inscritos en curso';
$string['total_visits_enrolled_learners'] = 'Visitas totales por estudiantes inscritos en curso';
$string['learners_enrolled'] = 'Estudiante inscrito';
$string['learning_progress'] = 'Progreso del aprendizaje';
$string['sections'] = 'Secciones';
$string['section'] = 'Sección';
$string['total_activities_resources'] = 'Recursos/actividades totales';
$string['completions'] = 'Logros';
$string['return_to_courses'] = 'Volver a Cursos';
$string['click_link_below_support_pages'] = 'Haga clic en el siguiente link para acceder a las páginas de soporte de IntelliBoard:';
$string['support'] = 'Soporte';
$string['course_name'] = 'Nombre del curso';
$string['enrolled_completed_learners'] = 'Estudiantes inscritos/completados';
$string['activities_resources'] = 'Actividades/recursos';
$string['actions'] = 'Acciones';
$string['learner_name'] = 'Nombre Estudiante';
$string['completed_activities_resources'] = 'Actividades/recursos completados';
$string['a31'] = 'Marcos';
$string['a32'] = 'Planes de aprendizaje';
$string['a33'] = 'Calificado, proficiente';
$string['a34'] = 'Calificado, no proficiente';
$string['a35'] = 'No calificado';
$string['a36'] = 'Descripción de competencia';
$string['a37'] = 'No ha creado una competencia.Por favor contacte a su Administrador de Sistema';
$string['a38'] = 'Cursos vinculados a competencias';
$string['a39'] = 'Competencias totales';
$string['a40'] = 'Cursos vinculados';
$string['no_competency'] = 'Parece que usted no tiene las competencias habilitadas para su sitio.';
$string['a0'] = 'Dashboard Competencias';
$string['a1'] = 'Competencias';
$string['a2'] = 'Proficiencia';
$string['a3'] = 'Actividades asignadas';
$string['a4'] = 'Progreso de Proficiencia';
$string['a5'] = 'Competencias evaluadas';
$string['a6'] = '# de Evidencias';
$string['a7'] = 'Estudiantes calificados';
$string['a8'] = 'Progreso';
$string['a9'] = 'Estudiantes competentes';
$string['a10'] = 'Estudiante inscrito';
$string['a11'] = 'Lista de competencias asignadas al curso';
$string['a12'] = 'Estudiantes inscritos';
$string['a13'] = 'Nombre de la Competencia';
$string['a14'] = 'Creado en';
$string['a15'] = 'Asignado en';
$string['a16'] = 'Proficiente Indiceted';
$string['a17'] = 'Clasificación';
$string['a18'] = 'Competencias Proficiente';
$string['a19'] = 'Fecha Competencias Clasificación';
$string['a20'] = 'Apreciador de Competencias';
$string['a21'] = 'Actividades asignadas';
$string['a22'] = 'Competencia adquirida';
$string['a23'] = 'Competencias calificadas';
$string['a24'] = '# de Evidencias';
$string['a25'] = 'Estudiantes completos';
$string['a27'] = ' de ';
$string['a28'] = 'Detalles';
$string['a29'] = 'Habilitar Dashboard Competencias';
$string['a30'] = 'Habilitar reportes de competencias';
$string['a26'] = 'Esta tabla muestra el número de competencias asignadas a un curso, los alumnos que han sido calificados (competentes o no) y los alumnos que han sido designados competentes en la competencia.';
$string["n12"] = "Resumen [Resumen del curso]";
$string["n13"] = "Total de estudiantes";
$string["n14"] = "Widget: Participación de los estudiantes";
$string["n15"] = "Widget: Utilización de la actividad";
$string["n16"] = "Widget: Utilización del tema";
$string["passed"] = "Aprobado";
$string["failed"] = "Fallado";
$string["in26"] = "Participación de los estudiantes";
$string["in27"] = "Total de estudiantes";
$string["in28"] = "Tiempo promedio gastado";
$string["in29"] = "Estudiantes Activos";
$string["in30"] = "Estudiantes inactivos";
$string["in31"] = "Utilización de la actividad";
$string["in32"] = "Tiempo promedio en el período seleccionado";
$string["in33"] = "Utilización del tema";
$string["learners_enrolled_period"] = "Estudiantes matriculados dentro del período seleccionado";
$string["filter_dates"] = "Filtrar fechas:";
$string["select_date"] = "Seleccionar fechas";
$string["course_overview"] = "Resumen del curso";
$string["topics"] = "Temas";
$string["scalesettings"] = "Ajustes de escala";
$string["scales"] = "Habilitar escala personalizada";
$string["scale_raw"] = "Desactivar escala";
$string['scale_real'] = 'Mostrar porcentaje real en lugar de porcentaje';
$string["scale_total"] = "Grado total";
$string["scale_value"] = "Valor";
$string["scale_percentage"] = "Porcentaje";
$string["s25"] = "Tiempo dedicado a la actividad";
$string["s45"] = "Actividad";
$string["s46"] = "Porcentaje de estudiantes que intentaron";
$string["s47"] = "Tema";
$string["s48"] = "Tiempo dedicado al tema";
$string['passed_on'] = 'Completado (aprobado) {$a}';
$string['failed_on'] = 'Completado (fallado) en {$a}';
$string['completions'] = 'Estado de finalización de la actividad';
$string['completions_completed'] = 'Estado de finalización (completado)';
$string['completions_pass'] = 'Estado de finalización (pasar)';
$string['completions_fail'] = 'Estado de finalización (falla)';
$string['completions_desc'] = '1) El usuario ha completado esta actividad. No se especifica si han pasado o fallado. <br>
2) El usuario ha completado esta actividad con un grado por encima de la calificación de aprobado. <br>
3) El usuario ha completado esta actividad, pero su calificación es menor que la calificación de aprobado.';
$string['reportselect'] = 'Por favor seleccione al menos un reporte de App.IntelliBoard.net.  Clic en Informes, seleccione uno y luego de clic en Personalizar Informe, seleccione "Visible en Moodle".';
$string['monitorselect'] = 'Por favor seleccione al menos un monitor de App.IntelliBoard.net.  Clic en Monitores, seleccione uno y luego de clic en Personalizar Grupo de Monitores, seleccione "Visible en Moodle".';
$string['privacy:metadata:local_intelliboard_assign:rel'] = 'Tipo de actividad';
$string['privacy:metadata:local_intelliboard_assign:type'] = 'Tipo de Instancia Moodle';
$string['privacy:metadata:local_intelliboard_assign:instance'] = 'ID Instancia Moodle Conectada';
$string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'Registro de tiempos';
$string['privacy:metadata:local_intelliboard_details:logid'] = 'Tabla ID [local_intelliboard_logs]';
$string['privacy:metadata:local_intelliboard_details:visits'] = 'El numero de visitas, clics, por día';
$string['privacy:metadata:local_intelliboard_details:timespend'] = 'Tiempo empleado por hora';
$string['privacy:metadata:local_intelliboard_details:timepoint'] = 'La hora';
$string['privacy:metadata:local_intelliboard_logs:trackid'] = 'ID de la tabla [local_intelliboard_tracking]';
$string['privacy:metadata:local_intelliboard_logs:visits'] = 'Visitas, clics, por día';
$string['privacy:metadata:local_intelliboard_logs:timespend'] = 'Tiempo empleado, por día';
$string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'Registro del tiempo del dia en el año';
$string['privacy:metadata:local_intelliboard_totals:sessions'] = 'Numero Total de Sesiones de Usuario Moodle';
$string['privacy:metadata:local_intelliboard_totals:courses'] = 'Total Cursos en Moodle';
$string['privacy:metadata:local_intelliboard_totals:visits'] = 'Visitas Totales por todos los Usuarios en Moodle';
$string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Tiempo empleado en Moodle por el Total de Usuarios';
$string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'Registro del tiempo del dia en el año';
$string['privacy:metadata:local_intelliboard_tracking:userid'] = 'User ID que visitaron pagina de Moodle.';
$string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'Course ID que los usuarios visitaron';
$string['privacy:metadata:local_intelliboard_tracking:page'] = 'Tipo de Pagina [course,module,profile,site]';
$string['privacy:metadata:local_intelliboard_tracking:param'] = 'Page ID Tipo';
$string['privacy:metadata:local_intelliboard_tracking:visits'] = 'Visitas de Usuarios en una pagina';
$string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'Tiempo Empleado por Usuarios en la Pagina';
$string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'Primer Acceso Usuarios';
$string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'Ultimo Acceso Usuarios';
$string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'Navegador de los Usuarios';
$string['privacy:metadata:local_intelliboard_tracking:useros'] = 'Sistema Operativo de los Usuarios';
$string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'Idioma del Navegador de los Usuarios';
$string['privacy:metadata:local_intelliboard_tracking:userip'] = 'Ultima Direccion IP del Usuario';
$string['privacy:metadata:local_intelliboard_ntf:id'] = 'Notification ID';
$string['privacy:metadata:local_intelliboard_ntf:type'] = 'Tipo de Notificación';
$string['privacy:metadata:local_intelliboard_ntf:externalid'] = 'Notificación ExternalNID';
$string['privacy:metadata:local_intelliboard_ntf:userid'] = 'Notificación ExternalAppID';
$string['privacy:metadata:local_intelliboard_ntf:email'] = 'Notificación email';
$string['privacy:metadata:local_intelliboard_ntf:cc'] = 'Notificación cc';
$string['privacy:metadata:local_intelliboard_ntf:subject'] = 'Notificación asunto';
$string['privacy:metadata:local_intelliboard_ntf:message'] = 'Notificación mensaje';
$string['privacy:metadata:local_intelliboard_ntf:state'] = 'Notificación status';
$string['privacy:metadata:local_intelliboard_ntf:attachment'] = 'Notificación adjunto';
$string['privacy:metadata:local_intelliboard_ntf:tags'] = 'Notificación tags';
$string['privacy:metadata:local_intelliboard_ntf_hst:id'] = 'Historia Notificación ID';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = 'Notificación ID';
$string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = 'Notificación ExternalAppID';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = 'Notificación nombre';
$string['privacy:metadata:local_intelliboard_ntf_hst:email'] = 'Notificación historia email';
$string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = 'Notificación historia registro de tiempo';
$string['select_manager_role'] = 'Seleccionar rol de administrador';
$string['group_aggregation'] = 'Agrupación de grupos';
$string['ssodomain'] = 'Subdominio SSO';
$string['ssodomain_desc'] = 'Single Sign On con Servidor/Cuenta separada';
$string['instructor_redirect'] = 'Redireccionamiento del instructor';
$string['student_redirect'] = 'Redirección del estudiante';
$string['scale_percentage_round'] = 'Escala Porcentage Redondeo';
$string['api'] = 'API Alternativa';
$string['api_desc'] = 'Usar servidor API alternativa (para evitar bloqueo de firewall)';
$string['n18'] = 'Widget: Progresion calificación del estudiante';
$string['n101'] = 'Habilitar Dashboard para el Instructor';
$string['loading2'] = 'Por favor espere, cargando...';
$string['in34'] = 'Progresion calificación del estudiante';
$string['select'] = 'Seleccionar';
$string['selectall'] = 'Seleccionar Todo';
$string['ok'] = 'OK';
$string['moodle'] = 'Moodle';
$string['totara'] = 'Totara';
$string['monitors'] = 'Monitores';
$string['cohorts'] = 'Cohortes';
$string['widget_name27'] = 'Registros Acumulados';
$string['widget_name28'] = 'Compromiso';
$string['widget_name29'] = 'Logins unicos';
$string['widget_name30'] = 'Matriculas por Curso';
$string['widget_name31'] = 'Registrars & Supervisor up take';
$string['role1'] = 'Primer Rol';
$string['role2'] = 'Segundo Rol';
$string['select_course'] = 'Seleccionar curso';
$string['select_quiz'] = 'Seleccionar cuestionario';
$string['not_quiz'] = 'Ups, parece que no tienes cuestionarios creados para el curso seleccionado.';
$string['enter_course_and_quiz'] = 'Por favor seleccione su Curso y Cuestionario.';
$string['enter_quiz'] = 'Por favor seleccione su Cuestionario.';
$string['analityc_3_name'] = 'Resumen de Cuestionario & Detalle por pregunta';
$string['course_name_a'] = 'Curso: {$a}';
$string['quiz_name_a'] = 'Cuestionario: {$a}';
$string['cor_incor_answers'] = 'Respuestas Correctas/Incorrectas';
$string['quiz_finished'] = 'Cuestionario finalizado';
$string['quiz_grades'] = 'Calificaciones Cuestionario';
$string['correct_number'] = 'Correcto {$a}';
$string['incorrect_number'] = 'Incorrecto {$a}';
$string['correct'] = 'Correcto';
$string['incorrect'] = 'Incorrecto';
$string['weekday_0'] = 'Lunes';
$string['weekday_1'] = 'Martes';
$string['weekday_2'] = 'Miercoles';
$string['weekday_3'] = 'Jueves';
$string['weekday_4'] = 'Viernes';
$string['weekday_5'] = 'Sabado';
$string['weekday_6'] = 'Domingo';
$string['time_1'] = 'Mañana';
$string['time_2'] = 'Tarde';
$string['time_3'] = 'Noche';
$string['time_4'] = 'Madrugada';
$string['passing_score_for'] = 'Calificación para aprobar {$a}';
$string['name'] = 'Nombre';
$string['answers'] = 'Respuestas';
$string['ques_breakdown'] = 'Desglose por pregunta';
$string['n17'] = 'Pagina Analiticas';
$string['analytics'] = 'Analiticas';
$string['pdf'] = 'PDF';
$string['csv'] = 'CSV';
$string['excel'] = 'Excel';
$string['grades_alt_text'] = 'Texto alternativo para menu de navegación';
$string['course_chart'] = 'Habilitar diagrama de curso';
$string['course_activities'] = 'Habilitar actividades del curso';
$string['filter_this_year'] = 'Filtro de tiempo: Año Actual';
$string['filter_last_year'] = 'Filtro de tiempo: Año Pasado';
$string['this_year'] = 'Año Actual';
$string['last_year'] = 'Año Pasado';
$string['select_user'] = 'Seleccionar Usuario';
$string['course_max_grade'] = 'Máxima calificacíon del curso';
$string['no_data_notification'] = 'No hay nuevos datos para [date]';
$string['last_hour'] = 'hora';
$string['last_day'] = 'día';
$string['privacy:metadata:local_intelliboard_assign'] = 'Intelliboard tabla assigns-subcuentas';
$string['privacy:metadata:local_intelliboard_details'] = 'Intelliboard tabla alt/logs/por-hora';
$string['privacy:metadata:local_intelliboard_logs'] = 'Intelliboard tabla alt/logs/por-día';
$string['privacy:metadata:local_intelliboard_totals'] = 'Intelliboard tabla alt/logs/total';
$string['privacy:metadata:local_intelliboard_tracking'] = 'Intelliboard tabla alt/logs/todo-momento';
$string['privacy:metadata:local_intelliboard_reports'] = 'Intelliboard tabla reportes personalizados SQL';
$string['privacy:metadata:local_intelliboard_ntf'] = 'Intelliboard tabla princial de notificaciones';
$string['privacy:metadata:local_intelliboard_ntf_hst'] = 'Intelliboard historual de notificaciones';
$string['privacy:metadata:local_intelliboard_ntf_pms'] = 'Intelliboard tabla notificaciones parametros dinamicos';
$string['privacy:metadata:local_intelliboard_assign:userid'] = 'USER ID de registro';
$string['privacy:metadata:local_intelliboard_reports:status'] = 'Estatus de reporte - activado/no activado';
$string['privacy:metadata:local_intelliboard_reports:name'] = 'Nombre de reporte personalizado';
$string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'BASE64 codigo SQL codificado';
$string['privacy:metadata:local_intelliboard_reports:timecreated'] = 'Hora de creación';
$string['sqlreport'] = 'Reporte SQL';
$string['sqlreportcreate'] = 'Crear reporte';
$string['sqlreports'] = 'Reportes SQL';
$string['sqlreportname'] = 'Nombre del reporte';
$string['sqlreportcode'] = 'SQL';
$string['sqlreportdate'] = 'Creado el';
$string['sqlreportactive'] = 'Activado';
$string['sqlreportinactive'] = 'Desactivado';
$string['remove_message'] = 'Reporte SQL ha sido borrado';
$string['delete_message'] = 'Borrar reporte SQL?';
$string['success_message'] = 'Reporte SQL ha sido guardado';
$string['bbbapiendpoint'] = 'BBB API endpoint';
$string['bbbserversecret'] = 'BBB server secret';
$string['check_active_meetings'] = 'Revisar reuniones activas';
$string['bbbmeetings'] = 'Reuniones BigBlueButton';
$string['enablebbbmeetings'] = 'Habilitar monitoreo de reuniones en BigBlueButton';
$string['enablebbbdebug'] = 'BigBlueButton modo de depuración';
$string['privacy:metadata:local_intelliboard_bbb_meet'] = 'Log sobre reuniones BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_meet:id'] = 'ID del log de reuniones';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = 'Nombre de la reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'ID de la reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = 'Meeting ID interno (en el servidor BBB)';
$string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = 'Creat tiempo (registro de tiempo)';
$string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = 'Crear fecha (string)';
$string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = 'El numero de extensión para conectarse al audio vía telefonica';
$string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = 'El número de acceso de marcación al que los participantes pueden llamar usando un teléfono normal.';
$string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = 'La contraseña que se requerirá para que los asistentes se unan a la reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = 'La contraseña que se requerirá para que los moderadores se unan a la reunión o para ciertas acciones administrativas';
$string['privacy:metadata:local_intelliboard_bbb_meet:running'] = 'Estado de la reunión (activo | detenido)';
$string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = 'Duración de la reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = 'Notificación. Usuarios unidos a la reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = 'Notificación. La reunión se grabará ';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = 'Notificación. La reunión ha sido finalizada';
$string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = 'Hora de inicio de la reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = 'Hora final de la reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = 'Número de asistentes';
$string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'Número de oyentes';
$string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'Número de participantes con micrófono conectado';
$string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'Número de participantes con cámara de video conectada';
$string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = 'Número máximo de participantes';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'Número de moderadores';
$string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'ID del curso';
$string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'ID del módulo del curso';
$string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'ID de fila en la tabla bigbluebuttonbn';
$string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = 'ID de propietario (usuario que creó la reunión)';
$string['privacy:metadata:local_intelliboard_bbb_atten'] = 'Registro sobre los asistentes a las reuniones de BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_atten:id'] = 'ID del asistente';
$string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'ID de usuario (fila en la tabla "usuario")';
$string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = 'Nombre completo del asistente a la reunión';
$string['privacy:metadata:local_intelliboard_bbb_atten:role'] = 'Rol de los asistentes a la reunión';
$string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = 'Notificación. El asistente es presentador ';
$string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = 'Notificación. El asistente no tiene un micrófono o cámara web conectados ';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = 'Notificación. El asistente ha conectado el micrófono ';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = 'Notificación. El asistente ha conectado la cámara web ';
$string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = 'ID de reunión (ID en el servidor BigBlueButton)';
$string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = 'ID de reunión (ID en la tabla local_intelliboard_bbb_meet)';
$string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'Hora cuando el usuario se conectó a la reunión';
$string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'Hora en que el usuario se desconectó de la reunión';
$string['privacy:metadata:local_intelliboard_bb_partic'] = 'List of participants of collaborate session';
$string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'ID of session participation';
$string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'Session UUID';
$string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'User UUID (BlackBoard Collaborate service)';
$string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'User ID (Moodle)';
$string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'Session role';
$string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'User name';
$string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'First join to session';
$string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'Last leave from session';
$string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'Spent time on session';
$string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'Number of rejoins to session';
$string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'List of tracked sessions';
$string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'ID of track log';
$string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'Session UUID';
$string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = 'Track time';
$string['privacy:metadata:local_intelliboard_att_sync'] = 'List of synchronized sessions';
$string['privacy:metadata:local_intelliboard_att_sync:id'] = 'ID of sync log';
$string['privacy:metadata:local_intelliboard_att_sync:type'] = 'Session type';
$string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'Moodle session ID';
$string['privacy:metadata:local_intelliboard_att_sync:data'] = 'Additional sync data';
$string['myorders'] = 'Pedidos';
$string['myseats'] = 'Asientos';
$string['mywaitlist'] = 'Lista de espera';
$string['mysubscriptions'] = 'Suscripciones';
$string['seatscode'] = 'Código de asientos';
$string['numberofseats'] = 'Numero de asientos';
$string['downloadinvoice'] = 'Descargar factura';
$string['product'] = 'Producto';
$string['key'] = 'Clave';
$string['created'] = 'Creado';
$string['seatnumber'] = 'Número de asientos';
$string['seatsused'] = 'Asiento utilizado';
$string['details'] = 'Detalles';
$string['username'] = 'Nombre de usuario';
$string['used'] = 'Usado';
$string['subscriptiondate'] = 'Fecha de suscripción';
$string['price'] = 'Precio';
$string['recurringperiod'] = 'Período recurrente';
$string['billingcycles'] = 'Ciclos de facturación';
$string['active'] = 'Activo';
$string['suspended'] = 'Suspendido';
$string['canceled'] = 'Cancelado';
$string['expired'] = 'Expirado';
$string['process'] = 'Proceso';
$string['cancel_subscription'] = 'Cancelar suscripción';
$string['messageprovider:intelliboard_notification'] = "Notificación de IntelliBoard";
$string['verifypeer'] = "CURLOPT SSL VERIFYPEER";
$string['verifypeer_desc'] = "Esta opción determina si curl verifica la autenticidad del certificado del par.";
$string['verifyhost'] = "CURLOPT SSL VERIFYHOST";
$string['verifyhost_desc'] = "Esta opción determina si libcurl verifica que el certificado del servidor es para el servidor que se conoce";
$string['cipherlist'] = "CURLOPT SSL CIPHER LIST";
$string['cipherlist_desc'] = "Especificar cifrados a usar con TLS";
$string['sslversion'] = "CURLOPT SSLVERSION";
$string['sslversion_desc'] = "Pasar un campo Long como parámetro como para controlar qué rango de versiones de SSL / TLS usar";
$string['debug'] = "Depurar solicitudes CURL";
$string['debug_desc'] = "";
$string['instructor_show_suspended_enrollments'] = 'Show suspended enrollments';
$string['instructor_hide_suspended_enrollments'] = 'Hide suspended enrollments';
/* IntelliCart */
$string['intellicart'] = "Integración IntelliCart";
$string['intellicart_desc'] = "Permitir a los estudiantes ver informes de IntelliCart";
$string['coursessessionspage'] = "Página de sesiones de cursos";
$string['coursessessions'] = "Sesiones de Cursos";
$string['session_name'] = "Nombre de sesión";
$string['session_time'] = "Tiempo de sesión";
$string['return_to_sessions'] = "Regresar a las sesiones";
$string['intellicart_student_integration'] = 'Integration with Student Dashboard';
$string['intellicart_instructor_integration'] = 'Integration with Instructor Dashboard';
$string['intellicart_app_reports_integration'] = 'Integration with IntelliBoard Reports';
/* IntelliCart END*/
$string['allmod'] = "Todas las actividades";
$string['customod'] = "Actividades personalizadas";
$string['timespent'] = "------ Tiempo dedicado ----";
$string['inprogress'] = "En progreso";
$string['notstarted'] = "No empezado";
$string['modulename'] = "Nombre del módulo";
$string['viewed'] = "Visto";
$string['course'] = "Curso";
$string['courseaverage'] = "Promedio del Curso";
$string['mygrade'] = "Mi Calificación";
$string['myprogress'] = "Progreso de mi Calificación";
$string['instructor_course_shortname'] = "Mostrar nombre corto del curso en lugar del nombre completo del curso";
$string['trackmedia'] = "Seguimiento de contenidos HTML5";
$string['trackmedia_desc'] = "Rastrear video y audio HTML5";
$string['t53'] = 'Habilitar en diagrama [Activity progress] línea de promedio';
$string['ianalytics'] = 'IntelliBoard Analytics';
$string['instructor_course_visibility'] = 'Mostrar cursos ocultos / suspendidos para [instructor]';
$string['instructor_mode'] = 'Mostrar todos los cursos disponibles para [instructor]';
$string['instructor_mode_access'] = 'Mostrar todos los cursos disponibles para [instructor] con permisos [update]';
$string['student_course_visibility'] = 'Mostrar cursos ocultos / suspendidos para [student]';
$string['support_text1'] = "Todos sus datos de Moodle: fácil, compartibles, comprensibles y atractivos. IntelliBoard es un plugin de Moodle que pone <strong> +120 </strong> informes y monitores en sus manos";
$string['support_text2'] = "Todos sus datos de Moodle: fácil, compartibles, comprensibles y atractivos. IntelliBoard es su solución de análisis e informes de Moodle, que le brinda más de 120 informes y análisis para ayudarlo a informar sus decisiones educativas de negocios";
$string['support_info1'] = "¡Puede unirse a nuestros <a target='_blank' href='https://intelliboard.net/events'> Webinars </a> mientras lo llevamos en un recorrido por los informes y análisis de IntelliBoard 5.0!";
$string['support_info2'] = "Únase a nuestros <a target='_blank' href='https://intelliboard.net/events'> Webinars </a>, o programe un recorrido personal de sus propios datos. Con nuestro servicio y soporte de clase mundial, usted verá su LMS bajo una luz completamente nueva ";
$string['support_terms'] = "Todos los derechos reservados.";
$string['support_page'] = "Pagina de soporte";
$string['support_demo'] = "Programar una demostración";
$string['support_trial'] = "Iniciar prueba";
$string['support_close'] = "Cerrar";
$string['instructor_custom_groups'] = "Grupos personalizados del Instructor";
// settings of tables
$string['show_dashboard_tab'] = 'Mostrar pestaña del tablero de control';
$string['table_set_icg'] = 'Tabla del instructor "Calificaciones del curso"';
$string['table_set_icg_c1'] = 'Nombre del curso';
$string['table_set_icg_c2'] = 'Nombre corto';
$string['table_set_icg_c3'] = 'Categoría';
$string['table_set_icg_c4'] = 'Estudiantes matriculados / finalizados';
$string['table_set_icg_c5'] = 'Calificación promedio del curso';
$string['table_set_icg_c6'] = 'Secciones';
$string['table_set_icg_c7'] = 'Actividades / Recursos';
$string['table_set_icg_c8'] = 'Visitas';
$string['table_set_icg_c9'] = 'Tiempo dedicado';
$string['table_set_icg_c11'] = 'Acciones - Actividades';
$string['table_set_icg_c12'] = 'Acciones - Estudiantes';
$string['percentage_completed_learners'] = 'Porcentaje de estudiantes finalizados';
$string['avg_visits_per_stud'] = 'Promedio de visitas por estudiante';
$string['avg_time_spent_per_stud'] = 'Promedio tiempo dedicado por estudiante';
$string['table_set_ilg'] = 'Tabla del instructor "Calificación de los estudiantes"';
$string['table_set_ilg_c1'] = 'Nombre del estudiante';
$string['table_set_ilg_c2'] = 'Email';
$string['table_set_ilg_c3'] = 'Matriculado';
$string['table_set_ilg_c4'] = 'Último acceso';
$string['table_set_ilg_c5'] = 'Estatus';
$string['table_set_ilg_c6'] = 'Calificación';
$string['table_set_ilg_c7'] = 'Actividades / recursos completados';
$string['table_set_ilg_c8'] = 'Visitas';
$string['table_set_ilg_c9'] = 'Tiempo dedicado';
$string['table_set_ilg_c10'] = 'Acciones';
$string['table_set_ilg1'] = 'Tabla del instructor "Calificación de los estudiantes"';
$string['table_set_ilg1_c1'] = 'Nombre de la actividad';
$string['table_set_ilg1_c2'] = 'Tipo';
$string['table_set_ilg1_c3'] = 'Calificación';
$string['table_set_ilg1_c4'] = 'Calificado';
$string['table_set_ilg1_c5'] = 'Estatus';
$string['table_set_ilg1_c6'] = 'Visitas';
$string['table_set_ilg1_c7'] = 'Tiempo dedicado';
$string['table_set_iag'] = 'Tabla del instructor "Calificaciones de actividades" ';
$string['table_set_iag_c1'] = 'Nombre de la actividad';
$string['table_set_iag_c2'] = 'Tipo';
$string['table_set_iag_c3'] = 'Estudiantes Finalizaron';
$string['table_set_iag_c4'] = 'Calificación promedio';
$string['table_set_iag_c5'] = 'Visitas';
$string['table_set_iag_c6'] = 'Tiempo dedicado';
$string['table_set_iag_c7'] = 'Acciones';
$string['table_set_iag1'] = 'Tabla del instructor "Calificaciones de actividades" ';
$string['table_set_iag1_c1'] = 'Nombre del estudiante';
$string['table_set_iag1_c2'] = 'Email';
$string['table_set_iag1_c3'] = 'Estatus';
$string['table_set_iag1_c4'] = 'Calificación';
$string['table_set_iag1_c5'] = 'Calificado';
$string['table_set_iag1_c6'] = 'Visitas';
$string['table_set_iag1_c7'] = 'Tiempo dedicado';
$string['grade_activities_overview'] = 'Resumen de actividades calificadas';
$string['activity'] = 'Actividad';
$string['date_format'] = 'Formato de fecha';
$string['user_enrollments_sessions_completion'] = 'User Enrollment, Session, Completion Activity Levels';
$string['user_site_summary_detail'] = 'User Site Summary Detail';
$string['course_enrollment_types'] = 'Course Enrollment Types';
$string['user_map'] = 'User Map';
$string['course_enrollments_with_completion_overview'] = 'Course Enrollments with Completion Overview';
$string['all_modules'] = 'All modules';

/* Attendance */
$string['attendance'] = 'Attendance';
$string['enableattendance'] = 'Habilitar Attendance';
$string['attendancetoolurl'] = 'URL de Attendance';
$string['attendanceconsumerkey'] = 'Clave de Consumidor';
$string['attendancesharedsecret'] = 'Secreto compartido';
$string['sync_data_with_attendance'] = 'Sincronizar datos con Attendance';
$string['attendanceapibase'] = 'Attendance ruta base API';
$string['attendanceapikey'] = 'Attendance clave API';
$string['attendanceapisecret'] = 'Attendance secreto API';
$string['enablesyncattendance'] = 'Habilitar sincronización de sesiones de BB Collaborate con InAttendance';
/* BlackBoard Collaborate and InAttendance */
$string['bb_col_meetings'] = 'Reuniones de BlackBoard Collaborate';
$string['enable_bb_col_debug'] = 'Habiltar depuración BlackBoard Collaborate';
$string['bb_col_api_endpoint'] = 'BlackBoard Collaborate API endpoint';
$string['bb_col_consumer_key'] = 'Clave de consumidor de BlackBoard Collaborate';
$string['bb_col_secret'] = 'Secreto BlackBoard Collaborate';
$string['enable_bb_col_meetings'] = 'Habilitar reunions BlackBoard Collaborate';
$string['check_active_bb_col_meetings'] = 'Check active BlackBoard Collaborate meeting';
$string['local_intelliboard_bb_collaborate_session_tracking_started'] = 'Started tracking of BB collaborate session';
$string['local_intelliboard_bb_collaborate_session_tracking_finished'] = 'Finished tracking of BB collaborate session';
$string['local_intelliboard_bb_collaborate_api_request_finished'] = 'Finished API request to BB collaborate';

/* Admin dashboard */
$string['admin_dashboard'] = 'Admin dashboard';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'User Enrollment, Session, Completion Activity Levels';
$string['adm_dshb_adm_dashb_totals'] = 'Totals';
$string['adm_dshb_user_site_summary_details'] = 'User Site Summary Detail';
$string['adm_dshb_course_enrollments_types'] = 'Course Enrollment Types';
$string['adm_dshb_user_map'] = 'User Map';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'Course Enrollments with Completion Overview';
$string['adm_dshb_report_user_status'] = 'Report User status';
$string['adm_dshb_report_activity_stats_summary'] = 'Report Activity Stats Summary';
$string['adm_dshb_report_quiz_activity_detail'] = 'Report Quiz Activity Detail';

$string['intelliboard:attendanceadmin'] = "Attendance Admin";
$string['student_grades'] = "Student grades";
$string['grid_view'] = "Grid view";
$string['list_view'] = "List view";

$string['instructor_hide_need_help'] = 'Hide "Need help" button';
$string['names_order'] = 'Names order';
$string['firstname_lastname'] = '{First Name} {Last Name}';
$string['lastname_firstname'] = '{Last Name} {First Name}';
$string['issuer'] = 'Issuer';
$string['criteria_method'] = 'Criteria method';
$string['criteria_all_courses'] = 'All of the following courses have to be completed';
$string['criteria_any_course'] = 'Any of the following courses have to be completed';
$string['dashboard_settings'] = 'Dashboard settings';

$string['tracklogs'] = 'Track Time by User - Daily';
$string['trackdetails'] = 'Track Time by User - Hourly';
$string['tracktotals'] = 'Track Time Aggregate - Daily';

$string['enable_badges_report'] = 'Enable "Badges" report';
$string['sizemode'] = 'Size Mode: Large ( > 5,000 Users)';
$string['cachedef_bb_collaborate_access_token'] = 'BB collaborate access token';

$string['learner_menu'] = 'Mostrar enlace en el menú Bloqueo de navegación solo si los alumnos se inscribieron en algunos cursos';
#new strings
$string['intelliboard_reports'] = 'IntelliBoard Reports';
$string['n19'] = 'Course Navigation Link for Reports';
$string['t54'] = 'Enable [Activity Grades] Time Spent column';
$string['all_cohorts'] = 'All cohorts';
$string['privacy_shield_policy'] = 'Data Processing Addendum';
$string['privacy_policy'] = 'Privacy Policy';
$string['confirm_and_sign_up'] = 'Confirm and Sign Up';
$string['term_of_use'] = 'Terms Of Use';
$string['setup'] = 'Connect Now';
$string['protocol'] = 'Protocol';
$string['rest'] = 'REST';
$string['soap'] = 'SOAP';
$string['next'] = 'Next';
$string['terms_msg'] = 'By checking this box you confirm that you have read and agree to our Terms of Use.';
$string['privacy_msg'] = 'By checking this box you confirm that you have read and agree to our Privacy Policy.';
$string['shield_msg'] = 'By checking this box you confirm that you have read and agree to our Data Processing Addendum.';
$string['enable_webservice'] = 'Enable web services';
$string['you_need_to_enable_at_least_one_protocol'] = 'You need to enable at least one protocol';
$string['invalid_user'] = 'Invalid user';
$string['sign_in'] = 'Sign in';
$string['email'] = 'Email';
$string['password'] = 'Password';
$string['all_fields_required'] = 'All fields required';
$string['server_error'] = 'Server error';
$string['country'] = 'Country';
$string['please_accept_terms_and_conditions'] = 'Please accept terms and conditions';
$string['congratulations_intb_register'] = 'Congratulations';
$string['congratulations_intb_register_msg'] = 'Thank you for starting your 15 day free trial with IntelliBoard!  Please check your email to confirm your IntelliBoard account.  To begin, utilize the Single Sign On (SSO) Link, if enabled from Site Administration > IntelliBoard or sign in <a href="https://app.intelliboard.net/signin">here</a>.  The SSO Link reads as “INTELLIBOARD.NET” and is in the top right corner of the Dashboard. For questions, please contact Support@IntelliBoard.net';
$string['sign_up'] = 'Sign Up';
$string['sign_in'] = 'Sign In';
$string['intelliboard_settings'] = 'IntelliBoard settings';
$string['moodle_settings'] = 'Moodle Settings';
$string['email_is_required'] = 'Email is required';
$string['invalid_email'] = 'Invalid Email';
$string['intelliboard_terms'] = 'IntelliBoard Agreements';
$string['authentication'] = 'Account Creation';
$string['intb_settings_descr'] = "IntelliBoard requires one main, unique subscription email.  Please enter the email you wish to use as your subscription email below.  The email must be double verified through an email confirmation prior to use.  For questions, please contact <a href='mailto:Support@IntelliBoard.net'>Support@IntelliBoard.net</a>. For a full listing of IntelliBoard Settings, go to Site Administration > Plugins > Local Plugins > IntelliBoard";
$string['hosting_provider'] = 'Hosting Provider';
$string['self_hosted'] = 'Self-Hosted';

// date formats
$string['mysqlweek'] = '%Y, week %v';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlyear'] = '%Y';
$string['mysqlmonth'] = '%c';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlquarter'] = 'quarter';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';

$string['postgreweek'] = 'YYYY, "week" WW';
$string['postgremonthyear'] = 'Month YYYY';
$string['postgreyear'] = 'YYYY';
$string['postgremonth'] = 'MM';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgrequarter'] = 'quarter';
$string['postgredayshortmonthyear'] = 'DD Mon, YYYY';
$string['postgretimedate'] = 'HH12:MIAM, DD Mon YYYY';
$string['postgredaymonth'] = 'DD Mon YYYY';
$string['postgremonthyearday'] = 'Month YYYY, DD';
$string['postgrequarteryear'] = 'Q YYYY';
$string['postgremonthdayyear'] = 'MM/DD/YYYY';
$string['postgretimemonthdayyear'] = 'HH24 MM/DD/YYYY';

// new strings
$string['report1_name'] = 'User Status';
$string['report2_name'] = 'Course Stats';
$string['report3_name'] = 'Activity Stats Summary';
$string['report45_name'] = 'Quiz Activity Detail';
$string['report_activity_stats_summary'] = 'Activity Stats Summary';
$string['report_user_profile_information'] = 'User Profile Information';
$string['course_name'] = 'Course Name';
$string['course_short_name'] = 'Course Short Name';
$string['course_idnumber'] = 'ID Number';
$string['course_status'] = 'Status';
$string['number_of_learners'] = '# of Enrolled User(s)';
$string['number_of_modules'] = '# of Activity(ies)';
$string['number_of_completed_learners'] = '# of Completed User(s)';
$string['number_of_visits'] = 'Visit(s)';
$string['num_completed_activity'] = '# of Users Who Completed This Activity';
$string['total_time_spent'] = 'Total Time Spent';
$string['date_created'] = 'Date Created';
$string['initial_reports'] = 'Initial Reports';
$string['avg_score'] = 'Average Score';
$string['first_access'] = 'First Access';
$string['completion_not_enabled'] = 'Completion Not Enabled';
$string['first_name'] = 'First Name';
$string['last_name'] = 'Last Name';
$string['num_attempts'] = '# of Attempts';
$string['highest_grade'] = 'Highest Grade';
$string['lowest_grade'] = 'Lowest Grade';
$string['initial_reports_warning'] = 'To email, schedule, and further personalize these reports, click <a href="{$a}">Contact Us</a>.';
$string['last_access'] = 'Last Access';
$string['enrolment_expiration'] = 'Enrolment Expiration';
$string['id_number'] = 'ID Number';
$string['telephone1'] = 'Telephone 1';
$string['telephone2'] = 'Telephone 2';
$string['institution'] = 'Institution';
$string['department'] = 'Department';
$string['address'] = 'Address';
$string['city'] = 'City/Town';
$string['enroled_on'] = 'Enrollment Date';

$string['dashboard_link'] = 'Click to view Analytics';
$string['support_connect'] = 'Click the report buttons within the rectangle below. Get a glimpse into the power of IntelliBoard: 1 button access to your LMS insights. Want more? Click "Click to view Analytics". Still want more? <a href="{$a->connect_link}">Contact Us</a> in the top right, or anywhere you see the link.';
$string['support_text3'] = 'Thank you for installing IntelliBoard Lite!';
$string['support_text4'] = 'Meet an easy-to-use reporting and visualization platform that will help you achieve your retention, engagement, and compliance goals.';
$string['support_text6'] = 'Need more info? Click any of the blue buttons to connect with us.';

$string['web_services_descr'] = 'IntelliBoard requires Web services to be enabled. Web services enables other systems (e.g., IntelliBoard) to access this LMS system and preform operations.  For security purposes, this should be disabled when not in use.   For additional review, go to Site Administration > Advanced features > Web services';
$string['protocol_descr'] = 'IntelliBoard requires either REST or SOAP Protocol to be enabled.  For security purposes, only protocols that are in use should be enabled.  For additional review, go to Site Administration > Plugins > Web services > Manage protocols';
$string['authorized_user_descr'] = 'IntelliBoard requires an Authorized user.  The Authorized user will likely be a Site Administrator and must have privileges to manage web services, protocols and tokens.  For additional review, go to Site Administration > Plugins > Web services > External Services > IntelliBoard service > Authorized user';
$string['email_subscr'] = 'Subscription email';
$string['protocols_descr'] = 'IntelliBoard requires either REST or SOAP Protocol to be enabled.  For security purposes, only protocols that are in use should be enabled.  For additional review, go to Site Administration > Plugins > Web services > Manage protocols';
$string['enable_time_tracking'] = 'Enable Time Tracking';
$string['enable_time_tracking_descr'] = 'Enable Time Tracking for additional insights on user access, visits and time spent. IntelliBoard provides additional insights on time tracking separately from the Moodle time spent tables.';
$string['enable_sso'] = 'Enable Single Sign On (SSO) Link';
$string['enable_sso_descr'] = 'Enable Single Sign On Link for one click access for Site Administrators into the IntelliBoard SuperAdmin access on app.IntelliBoard.net';
$string['join_a_webinar'] = 'Join a Webinar';
$string['review_support_doc'] = 'Review Support Documentation';
$string['setup_subheading'] = 'Connect to experience the power of your data. No credit card. No obligation. Just 15 free days of data bliss.';

$string['instructor_courses_table_name'] = 'Course Grades';
$string['instructor_courses_table_name_learner'] = 'Course {$a->course}, Learner {$a->learner}, Grades';
$string['instructor_courses_table_name_activity'] = 'Course {$a->course}, Activity {$a->name}, Grades';
$string['instructor_courses_table_name_learners'] = 'Course {$a->fullname}, Learners';
$string['instructor_courses_table_name_activities'] = 'Course {$a->fullname}, Activities';

$string['successfull_connected'] = 'Sucessfully connected';
$string['not_connected'] = 'Not connected';

$string['transcripts'] = 'Transcripts';
$string['enable_transcripts'] = 'Enable Transcripts';
$string['closed'] = 'Closed';
$string['synctranscriptstask'] = 'Sync Transcripts Task';
$string['transcriptssyncrecordsnum'] = 'Transcripts Processing Size';
$string['transcriptssyncrecordsnum_desc'] = 'The number of users enrollments records which will be processed at once';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'Transcripts courses records';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'User ID';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'User email';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'User first name';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'User last name';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'Transcripts user enroll ID';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'Enroll record ID';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'Enroll method';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'Course ID';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = 'Course full name';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'Enrollment Date';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'Unenrollment Date';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'Completion Date';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'Transcript Status';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'Grade Item ID';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = 'Grade Grade ID';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'Max Grade';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'Min Grade';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'Final Grade';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'Formatted Grade';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'User Roles';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'User Groups';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'Timestamp when record created';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'Timestamp when record was updated last time';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'Transcripts courses records';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'Transcripts user enroll ID';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'Course ID';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'User ID';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'Course Module ID';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'Module ID';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Activity Name';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Module Type';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Start Date';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Completion Date';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Status';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'Grade Item ID';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = 'Grade Grade ID';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'Max Grade';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'Min Grade';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Final Grade';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'Formatted Grade';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'Timestamp when record created';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'Timestamp when record was updated last time';
$string['goal_grade'] = 'Goal Grade';
$string['importtrackingtask'] = 'Import Tracking Task';
$string['compresstracking'] = 'Compress Tracking';
$string['compresstracking_desc'] = 'Write Time Tracking data to file and transfer data to database with cron job (default: every 15 minutes)';
$string['cachedef_instructor_course_data'] = 'Cache for course data';
$string['cachedef_reports_list'] = 'Cache for reports list';
$string['do_not_use_compresstracking'] = 'Do not use Compress Tracking';
$string['cache_compresstracking'] = 'Save to Moodle Cache';
$string['file_compresstracking'] = 'Save to MoodleData';
$string['cachedef_tracking'] = 'Intelliboard Tracking data';
$string['cachedef_track_config'] = 'Intelliboard Tracking total data';
$string['coursecontainer_filter'] = 'Enable course container filter';
$string['enableexportcustomfont'] = 'Fuente compatible japonesa/china';
$string['all_selected'] = 'Todo seleccionado';
$string['custommenuitem'] = 'Display in Custom Menu';
$string['support_text7'] = 'To get started with <strong>IntelliBoard Lite</strong>, please <a href="{$a->meeting_link}">schedule a consultation</a> with one of our learning analytics experts.';
$string['support_text8'] = 'If you have <strong>already purchased</strong> a license and see this screen, please contact your Account Manager for assistance.';
$string['support_text9'] = 'Need predictive models, notifications, and intervention tracking?';
$string['support_text10'] = 'Switch to <a href="{$a->intelliboard_pro_link}"><strong>IntelliBoard Pro</strong></a>';
$string['support_text11'] = '<a href="{$a->intelliboard_pro_onepager}">Click here</a> to download the IntelliBoard Pro one-pager.';
$string['enable_vendor_frontpage_course'] = 'Enable the frontpage course in the reports for vendors';
$string['pagelayout'] = 'Theme page layout';
