<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This plugin provides access to Moodle data in form of analytics and reports in real time.
 *
 *
 * @package    local_intelliboard
 * @copyright  2017 IntelliBoard, Inc
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @website    http://intelliboard.net/
 */

$string['a0'] = 'コンピテンシーダッシュボード';
$string['a1'] = 'コンピテンシー';
$string['a10'] = '登録された学習者';
$string['a11'] = 'コースに割り当てられたコンピテンシーのリスト';
$string['a12'] = '学習者のステータス';
$string['a13'] = 'コンピテンシー名';
$string['a14'] = '作成済み';
$string['a15'] = '割り当て済み';
$string['a16'] = '指示された熟達';
$string['a17'] = '評価';
$string['a18'] = 'コンピテンシー能力';
$string['a19'] = 'コンピテンシー評価日付';
$string['a2'] = '熟達';
$string['a20'] = 'コンピテンシー・レター';
$string['a21'] = '活動が割り当てられました';
$string['a22'] = '熟達：達成済み';
$string['a23'] = '能力：評価済み';
$string['a24'] = '＃エビデンス';
$string['a25'] = '完了した学習者';
$string['a26'] = 'この表には、コースに割り当てられたコンピテンシーの数、評価された（熟練しているかどうかにかかわらず）学習者、およびコンピテンシーに熟達した学習者が表示されます。';
$string['a27'] = '不足';
$string['a28'] = '詳細';
$string['a29'] = 'コンピテンシーダッシュボードを有効にする';
$string['a3'] = '割り当てられた活動';
$string['a30'] = 'コンピテンシーレポートを有効にする';
$string['a31'] = 'フレームワーク';
$string['a32'] = '学習計画';
$string['a33'] = '評価済、熟達';
$string['a34'] = '評価済、熟達していない';
$string['a35'] = '未評価';
$string['a36'] = 'コンピテンシー概要';
$string['a37'] = 'コンピテンシーが作成されていません。システム管理者に連絡してください。';
$string['a38'] = 'コンピテンシーにリンクされたコース';
$string['a39'] = 'コンピテンシーの合計';
$string['a4'] = '熟達度';
$string['a40'] = 'リンクされたコース';
$string['a5'] = '評価されたコンピテンシー';
$string['a6'] = '# エビデンス';
$string['a7'] = '評価された学習者';
$string['a8'] = '進捗状況';
$string['a9'] = '熟達した学習者';
$string['account'] = '購読情報';
$string['actions'] = 'アクション';
$string['active'] = 'アクティブ';
$string['activities'] = '活動';
$string['activities_resources'] = '活動/リソース';
$string['activity'] = '活動';
$string['activity_grades'] = '活動成績';
$string['activity_name'] = '活動名';
$string['activity_participation'] = '活動参加';
$string['activity_progress'] = '活動の進捗状況';
$string['adm_dshb_adm_dashb_totals'] = '合計';
$string['adm_dshb_course_enrollments_types'] = 'コース登録種別';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'ユーザー登録、セッション、活動完了レベル';
$string['adm_dshb_user_enrol_with_compl_overview'] = '修了を伴うコース登録の概要';
$string['adm_dshb_user_map'] = 'ユーザーマップ';
$string['adm_dshb_user_site_summary_details'] = 'ユーザーサイトの概要の詳細';
$string['admin_dashboard'] = '管理ダッシュボード';
$string['adm_dshb_report_user_status'] = 'Report User status';
$string['adm_dshb_report_activity_stats_summary'] = 'Report Activity Stats Summary';
$string['adm_dshb_report_quiz_activity_detail'] = 'Report Quiz Activity Detail';
$string['adv_settings'] = '詳細設定';
$string['ajax'] = '頻度';
$string['ajax_desc'] = 'セッションをAJAX経由で保存しています。 0 - AJAX無効（秒）';
$string['all_courses'] = 'すべてのコース';
$string['all_data'] = 'すべてのデータ';
$string['all_modules'] = 'すべてのモジュール';
$string['allmod'] = 'すべての活動';
$string['analityc_3_name'] = '小テストの概要と質問の詳細';
$string['analytics'] = '分析';
$string['answers'] = '回答';
$string['api'] = '代替API';
$string['api_desc'] = '代替APIサーバを使用する（ファイアウォールのブロックを避けるため）';
$string['assignment_name'] = '課題名';
$string['assignments'] = '課題';
$string['attendance'] = '出席';
$string['attendanceapibase'] = '出席APIベースパス';
$string['attendanceapikey'] = '出席APIキー';
$string['attendanceapisecret'] = '出席APIのシークレット';
$string['attendanceconsumerkey'] = '出席コンシュマーキー';
$string['attendancesharedsecret'] = '共有シークレット';
$string['attendancetoolurl'] = 'ツールのURL';
$string['average_grade'] = '平均評価';
$string['avg_time_spent_per_stud'] = '学生ごとの平均滞在時間';
$string['avg_visits_per_stud'] = '学生あたりの平均訪問数';
$string['bb_col_api_endpoint'] = 'BlackBoard Collaborate API endpoint';
$string['bb_col_consumer_key'] = 'BlackBoard Collaborate consumer key';
$string['local_intelliboard_bb_collaborate_session_tracking_started'] = 'Started tracking of BB collaborate session';
$string['local_intelliboard_bb_collaborate_session_tracking_finished'] = 'Finished tracking of BB collaborate session';
$string['local_intelliboard_bb_collaborate_api_request_finished'] = 'Finished API request to BB collaborate';
$string['bb_col_meetings'] = 'BlackBoard Collaborate meetings';
$string['bb_col_secret'] = 'BlackBoard Collaborate secret';
$string['bbbapiendpoint'] = 'BBB API endpoint';
$string['bbbmeetings'] = 'BigBlueButton meetings';
$string['bbbserversecret'] = 'BBB server secret';
$string['billingcycles'] = 'Billing cycles';
$string['cachedef_bb_collaborate_access_token'] = 'BB collaborate access token';
$string['cancel_subscription'] = 'サブスクリプションをキャンセル';
$string['canceled'] = 'キャンセル';
$string['categories'] = 'カテゴリ';
$string['category'] = 'カテゴリ';
$string['check_active_meetings'] = 'Check active meetings';
$string['cipherlist'] = 'CURLOPT SSL CIPHER LIST';
$string['cipherlist_desc'] = 'Specify ciphers to use for TLS';
$string['class_average'] = '学習者平均';
$string['click_link_below_support_pages'] = 'インテリボードのサポートページにアクセスするには、以下のリンクをクリックしてください:';
$string['close'] = '閉じる';
$string['cohorts'] = 'コーホート';
$string['completed'] = '完了';
$string['completed_activities'] = '完了した活動';
$string['completed_activities_resources'] = '完了した活動/リソース';
$string['completed_activities_resourses'] = '完了した活動/リソース';
$string['completed_courses'] = '完了したコース';
$string['completed_on'] = '{$a}で完了しました';
$string['completion'] = '完了';
$string['completion_is_not_enabled'] = 'このコースの修了は有効ではありません。';
$string['completion_status'] = '完了ステータス';
$string['completions'] = '活動完了ステータス';
$string['completions_completed'] = '完了ステータス（完了）';
$string['completions_desc'] = '1）ユーザはこの活動を完了しました。学習者が合格したか不合格かは特定されていません。<br>2）ユーザーは、合格点を超える評定でこの活動を完了しました。<br>3）ユーザーはこの活動を完了しましたが、評定は合格点よりも低いです。';
$string['completions_fail'] = '完了ステータス（不合格）';
$string['completions_pass'] = '完了ステータス（合格）';
$string['cor_incor_answers'] = '正しい/間違った回答';
$string['correct'] = '修正する';
$string['correct_number'] = '修正する {$a}';
$string['correlations'] = '相関';
$string['course'] = 'コース';
$string['course_activities'] = 'コース活動を有効にする';
$string['course_category'] = 'コースカテゴリ';
$string['course_chart'] = 'コースチャートを有効にする';
$string['course_completion_status'] = 'コース修了ステータス';
$string['course_completions'] = 'コースの完了';
$string['course_enrollment_types'] = 'コース登録タイプ';
$string['course_enrollments_with_completion_overview'] = '修了を伴うコース登録の概要';
$string['course_grade'] = 'コース評定';
$string['course_max_grade'] = 'コースの最大評定';
$string['course_name'] = 'コース名';
$string['course_name_a'] = 'コース: {$a}';
$string['course_overview'] = 'コース概要';
$string['course_progress'] = 'コースの進捗状況';
$string['course_start_date'] = 'コース開始日';
$string['course_started'] = 'コースの開始';
$string['course_success'] = 'コースの成果';
$string['courseaverage'] = 'Course Average';
$string['courses'] = 'コース';
$string['courses_avg_grade'] = 'コース平均評定';
$string['courses_in_progress'] = 'コースは進行中です';
$string['courses_sum_grade'] = 'コース合計評定';
$string['coursessessions'] = 'コースセッション';
$string['coursessessionspage'] = 'コースセッションページ';
$string['created'] = '作成した';
$string['criteria_all_courses'] = '以下のすべてのコースを完了する必要があります';
$string['criteria_any_course'] = '次のいずれかのコースを完了する必要があります';
$string['criteria_method'] = '基準方法';
$string['csv'] = 'CSV';
$string['current_grade'] = '現在の成績';
$string['customod'] = 'カスタム活動';
$string['daily'] = '日別';
$string['dashboard'] = 'ダッシュボード';
$string['dashboard_settings'] = 'ダッシュボードの設定';
$string['date_format'] = '日付形式';
$string['debug'] = 'CURLリクエストをデバッグする';
$string['delete_message'] = 'SQLレポートを削除しますか？';
$string['details'] = '詳細';
$string['disable_time_and_visits_users_overview'] = 'ユーザー概要での滞在時間と訪問回数を無効にする';
$string['disabled'] = '無効';
$string['done'] = '完了！';
$string['downloadinvoice'] = '請求書をダウンロードする';
$string['due_date'] = '期日';
$string['enable_badges_report'] = '「バッジ」レポートを有効にする';
$string['enable_bb_col_debug'] = 'Enable BlackBoard';
$string['enable_bb_col_meetings'] = 'Enable BlackBoard';
$string['enable_time_and_visits_users_overview'] = 'ユーザー概要で訪問時間と訪問回数を有効にする';
$string['enableattendance'] = 'Enable attendance';
$string['enablebbbdebug'] = 'BigBlueButton debug mode';
$string['enablebbbmeetings'] = 'Enable monitoring of BigBlueButton meetings';
$string['enabled'] = '有効なトラッキング';
$string['enabled_desc'] = 'トラッキングを有効にする';
$string['enablesyncattendance'] = 'Enable BB Collaborate sessions synchronization with InAttendance';
$string['enrolled'] = '登録済み';
$string['enrolled_completed'] = '登録: {$a->courses}, 完了: {$a->completed_courses}';
$string['enrolled_completed_learners'] = '登録された/完了した学習者';
$string['enrolled_date'] = '登録日時';
$string['enrolled_users_completed'] = '登録ユーザ: {$a->users}, 完了: {$a->completed}';
$string['enrollments'] = '登録';
$string['enrolment_method'] = '登録方法';
$string['enter_course_and_quiz'] = 'コースと小テストを選択してください。';
$string['enter_quiz'] = '小テストを選択してください。';
$string['excel'] = 'エクセル';
$string['expired'] = '期限切れ';
$string['failed'] = '失敗しました';
$string['failed_on'] = '{$a}で完了（失敗）';
$string['filter_dates'] = '日付のフィルタリング:';
$string['filter_last_year'] = '時間フィルター:昨年';
$string['filter_this_year'] = '時間フィルタ:今年';
$string['filter1'] = '削除されたユーザー';
$string['filter1_desc'] = '削除されたユーザーを表示する';
$string['filter2'] = '休止されたユーザー';
$string['filter2_desc'] = '休止したユーザを表示する';
$string['filter3'] = 'ゲストユーザ';
$string['filter3_desc'] = '[ゲスト]ユーザーをレポートに表示する';
$string['filter4'] = 'コースフィルタ';
$string['filter4_desc'] = '非表示コースを表示する';
$string['filter5'] = '登録メソッドフィルタ';
$string['filter5_desc'] = 'アクティブでない登録方法を表示してください';
$string['filter6'] = 'ユーザ登録フィルタ';
$string['filter6_desc'] = '登録ステータスがアクティブでないユーザーを表示してください。';
$string['filter7'] = '活動/リソースフィルタ';
$string['filter7_desc'] = '非表示活動/リソースを表示する';
$string['filter8'] = '登録ユーザフィルタ';
$string['filter8_desc'] = '登録ユーザのみ表示する（推奨しません）';
$string['filters'] = 'ダッシュボードフィルタ';
$string['firstname_lastname'] = '{First Name} {Last Name}';
$string['grade'] = '評定';
$string['grade_activities_overview'] = '評定推移の概要';
$string['graded'] = '評定';
$string['grades'] = '評定';
$string['grades_alt_text'] = 'ナビゲーションメニューの代替テキスト';
$string['grid_view'] = 'グリッドビュー';
$string['group_aggregation'] = 'グループ集約';
$string['help'] = 'ヘルプが必要ですか？';
$string['ianalytics'] = 'IntelliBoard 分析';
$string['import'] = 'インポート';
$string['importing_logs'] = 'ログをインポートしています';
$string['importing_totals'] = '合計のインポート';
$string['in1'] = '概要';
$string['in10'] = 'イベント利用率';
$string['in11'] = '学習者の進捗状況';
$string['in12'] = '評定進度';
$string['in13'] = '時間の消費（％）';
$string['in14'] = '％進捗状況';
$string['in15'] = '学習者の完了';
$string['in16'] = '最後のアクセス';
$string['in17'] = '合計所要時間';
$string['in18'] = '総訪問数';
$string['in19'] = '評定平均';
$string['in2'] = '現在の進捗状況';
$string['in20'] = '学習者に戻る';
$string['in201'] = '活動に戻る';
$string['in21'] = 'コース平均評定';
$string['in22'] = '有効';
$string['in23'] = '表示する学習者がいません。';
$string['in24'] = 'モジュール';
$string['in25'] = '合格評定';
$string['in26'] = '学習者の関与';
$string['in27'] = '総学習者';
$string['in28'] = '平均所要時間';
$string['in29'] = '有効な生徒';
$string['in3'] = 'トータルコース';
$string['in30'] = 'アクティブでない学生';
$string['in31'] = 'アクティビティ利用率';
$string['in32'] = '選択した期間内の平均時間';
$string['in33'] = 'トピックの利用率';
$string['in34'] = '学生評定進度';
$string['in4'] = '総学習者';
$string['in5'] = '合計コースの成績';
$string['in6'] = '学習者は完了しました';
$string['in7'] = '学習者が未了です';
$string['in8'] = '学習者の平均評定';
$string['in9'] = '相関';
$string['inactivity'] = '非アクティブ';
$string['inactivity_desc'] = 'ユーザーの非アクティブ時間（秒）';
$string['incomplete'] = '不完全です';
$string['incorrect'] = '間違っています';
$string['incorrect_number'] = '誤った{$a}';
$string['inprogress'] = '進行中';
$string['instructor_course_shortname'] = 'コースのフルネームではなくコースのショートネームを表示';
$string['instructor_course_visibility'] = '[講師]の非表示/停止中のコースを表示';
$string['instructor_custom_groups'] = '教師ーカスタムグループ';
$string['instructor_hide_need_help'] = '「ヘルプが必要」ボタンを隠す';
$string['instructor_mode'] = '[講師]が利用できるすべてのコースを表示';
$string['instructor_mode_access'] = '[更新]権限を持つ[教師]が利用できるすべてのコースを表示する';
$string['instructor_redirect'] = '教師のリダイレクト';
$string['intelliboard_logs'] = 'インテリボードのログ';
$string['intelliBoard_migration_tool'] = 'インテリボード移行ツール';
$string['intelliBoard_migration_tool_info'] = 'インテリボード移行ツールは履歴データをMoodleログテーブルから新しいフォーマットに移行するために使用されます。 Moodleのログ保存手順は変更されませんのでご注意ください。履歴データを新しい形式に移行すると、利用時間や訪問数などの履歴値がインテリボード.netでプレビューできます。';
$string['intelliboard_start_tracking'] = 'インテリボードのスタートトラッキング';
$string['intelliboard_totals'] = 'インテリボード合計';
$string['intelliboard_tracking'] = 'インテリボードのトラッキング';
$string['intelliboard:attendanceadmin'] = '出席管理者';
$string['intelliboard:competency'] = 'インテリボード [コンピテンシー]';
$string['intelliboard:instructors'] = 'インテリボード [教師]';
$string['intelliboard:manage'] = 'インテリボード [管理]';
$string['intelliboard:students'] = 'インテリボード [学習者]';
$string['intelliboard:view'] = 'インテリボード [ビュー]';
$string['intelliboard:browseallcohorts'] = 'Browse All Cohorts';
$string['intelliboardaccess'] = 'このページを表示する権限がありません。管理者に連絡してください。';
$string['intelliboardnet'] = 'インテリボード.net';
$string['intelliboardroot'] = 'インテリボード';
$string['intellicart'] = 'IntelliCart integration';
$string['intellicart_desc'] = 'Allow students to see IntelliCart reports.';
$string['intellicart_student_integration'] = 'Integration with Student Dashboard';
$string['intellicart_instructor_integration'] = 'Integration with Instructor Dashboard';
$string['intellicart_app_reports_integration'] = 'Integration with IntelliBoard Reports';
$string['issuer'] = 'Issuer';
$string['items_per_query'] = 'クエリごとのアイテム';
$string['key'] = 'Key';
$string['last_access_on_course'] = 'コースへの最後のアクセス:{$a}';
$string['last_day'] = '日';
$string['last_hour'] = '時間';
$string['last_month'] = '先月';
$string['last_quarter'] = '前四半期';
$string['last_semester'] = '前学期';
$string['last_week'] = '先週';
$string['last_year'] = '去年';
$string['lastname_firstname'] = '{Last Name} {First Name}';
$string['learner_name'] = '学習者名';
$string['learner_tf_last_week'] = '時間フィルター：先週';
$string['learners'] = '学習者';
$string['learners_enrolled'] = '学習者の登録';
$string['learners_enrolled_period'] = '選択した期間内に登録した学習者';
$string['learning'] = '学習';
$string['learning_progress'] = '学習の進捗状況';
$string['letter'] = 'レター';
$string['list_view'] = 'リストビュー';
$string['load'] = 'パフォーマンス';
$string['loading'] = '読み込み中...';
$string['loading2'] = 'しばらくお待ちください...';
$string['log_values_include'] = 'ログ値には、各ユーザーの1日あたりのログが含まれます。';
$string['logs'] = 'マイグレーションツール';
$string['logs_to_process'] = '処理するログ{$a}';
$string['messageprovider:intelliboard_notification'] = 'インテリボード通知';
$string['messages'] = 'メッセージ';
$string['modulename'] = 'モジュール名';
$string['modules'] = 'モジュール';
$string['monitors'] = 'モニター';
$string['monitorselect'] = 'App.IntelliBoard.netから少なくとも1台のモニタを選択してください。 Monitorsをクリックし、次にモニタ設定をクリックし、 「Moodleで表示」で選択してください。';
$string['monthly'] = '月別';
$string['moodle'] = 'Moodle';
$string['moodle_logs'] = 'Moodleログ';
$string['more_courses'] = 'その他のコース';
$string['more_users'] = '他のユーザー';
$string['my_course_average_all'] = '私のコース平均（全コース）';
$string['mygrade'] = 'マイグレード';
$string['myorders'] = '注文';
$string['myprogress'] = '私の評定の進捗';
$string['myseats'] = '座席数';
$string['mysubscriptions'] = 'サブスクリプション';
$string['mywaitlist'] = 'キャンセル待ち';
$string['n1'] = '概要[学習者の進捗状況]';
$string['n10'] = '教師ダッシュボード';
$string['n101'] = '教師ダッシュボードを有効にする';
$string['n11'] = 'ナビゲーションメニューの代替テキスト';
$string['n12'] = '概要[コース概要]';
$string['n13'] = '総学習者';
$string['n14'] = 'ウィジェット:学習者の関与';
$string['n15'] = 'ウィジェット:活動利用率';
$string['n16'] = 'ウィジェット:トピックの利用率';
$string['n17'] = '分析ページ';
$string['n18'] = 'ウィジェット:学習者評定状況';
$string['n2'] = '概要[評定]';
$string['n3'] = '概要[活動の進捗状況]';
$string['n4'] = '概要[合計]';
$string['n5'] = '現在の進捗状況';
$string['n6'] = 'ウィジェット:相関';
$string['n7'] = 'ウィジェット:イベント利用率';
$string['n8'] = 'コースページ';
$string['n9'] = 'レポートページ';
$string['name'] = '名前';
$string['names_order'] = '名前順';
$string['no_competency'] = 'Moodleサイトでコンピテンシーを有効にしていないようです。';
$string['no_data'] = 'データなし';
$string['no_data_notification'] = '[日付]の新しいデータはありません。';
$string['not_quiz'] = '選択したコースに作成された小テストはありません。';
$string['notstarted'] = '始まっていない';
$string['number_of_sessions'] = 'セッション数';
$string['number_this_week'] = '{$a} 今週';
$string['number_today'] = '{$a} 今日';
$string['numberofseats'] = 'Number of seats';
$string['ok'] = 'OK';
$string['overall_course_average'] = '全コース平均（すべての学習者;すべてのコース）';
$string['participation'] = '参加';
$string['passed'] = '合格';
$string['passed_on'] = '{$a}で完了（パス）';
$string['passing_score_for'] = '{$a}の合格点';
$string['pdf'] = 'PDF';
$string['percentage_completed_learners'] = 'Percentage of Completed Learners';
$string['please_wait_or_cancel'] = '続行するか、<a href="{$a}">キャンセル</a>してください。';
$string['pluginname'] = 'インテリボード.netプラグイン';
$string['powered_by'] = 'Powered by <a href="https://intelliboard.net/"> インテリボード.net </a>';
$string['price'] = '価格';
$string['privacy:metadata:local_intelliboard_assign'] = 'Intelliboard assigns-subaccounts table';
$string['privacy:metadata:local_intelliboard_assign:instance'] = '接続されたMoodleインスタンスID';
$string['privacy:metadata:local_intelliboard_assign:rel'] = 'Relのレコードタイプ';
$string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'レコードのタイムスタンプ';
$string['privacy:metadata:local_intelliboard_assign:type'] = 'Moodleインスタンスのタイプ';
$string['privacy:metadata:local_intelliboard_assign:userid'] = 'ユーザーID：レコード';
$string['privacy:metadata:local_intelliboard_att_sync'] = '同期されたセッションのリスト';
$string['privacy:metadata:local_intelliboard_att_sync:data'] = '追加の同期：データ';
$string['privacy:metadata:local_intelliboard_att_sync:id'] = '同期ログ：ID';
$string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'MoodleセッションID';
$string['privacy:metadata:local_intelliboard_att_sync:type'] = 'セッションの種類';
$string['privacy:metadata:local_intelliboard_bb_partic'] = '共同セッションの参加者リスト';
$string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'ユーザー名';
$string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'セッションに費やした時間';
$string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'ユーザーID（Moodle）';
$string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'セッションへの最初の参加';
$string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'セッション参加のID';
$string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'Last leave from session';
$string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'セッションへの再参加の数';
$string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'セッション：ロール';
$string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'セッションUUID';
$string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'User UUID (BlackBoard Collaborate service)';
$string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'List of tracked sessions';
$string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = '追跡ログのID';
$string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'セッションUUID';
$string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = '時間を追跡する';
$string['privacy:metadata:local_intelliboard_bbb_atten'] = 'BigBlueButtonミーティングの参加者に関するログ';
$string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'ユーザーが会議に接続した時間';
$string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'ユーザーが会議から切断した時間';
$string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = '会議出席者の氏名';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = '参加者がマイクを接続しました';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = '参加者がウェブカメラを接続しました';
$string['privacy:metadata:local_intelliboard_bbb_atten:id'] = '参加者ID';
$string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = '参加者にはマイクやウェブカメラが接続されていません';
$string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = '出席者はプレゼンターです';
$string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = '会議ID（テーブルlocal_intelliboard_bbb_meetのID）';
$string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = '会議ID（BigBlueButtonサーバーのID）';
$string['privacy:metadata:local_intelliboard_bbb_atten:role'] = '会議出席者のロール';
$string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'ユーザーID（テーブル「user」の行）';
$string['privacy:metadata:local_intelliboard_bbb_meet'] = 'BigBlueButtonミーティングに関するログ';
$string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = '参加者が会議に参加するために必要なパスワード';
$string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'テーブルbigbluebuttonbnの行ID';
$string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'コースモジュールID';
$string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'コースID';
$string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = '作成日（文字列）';
$string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = '作成時間（タイムスタンプ）';
$string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = '参加者が通常の電話を使用して呼び出すことができるダイヤルアクセス番号。';
$string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = '会議時間';
$string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = '会議の終了時間';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = '会議は強制的に終了しました';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = '会議に参加したユーザー';
$string['privacy:metadata:local_intelliboard_bbb_meet:id'] = '会議ログのID';
$string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = '内部（BBBサーバー内）ミーティングID';
$string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'リスナーの数';
$string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = '参加者の最大数';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'ミーティングID';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = '会議名';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'モデレーターの数';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = 'モデレーターが会議に参加するため、または特定の管理アクションに必要なパスワード';
$string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = '所有者ID（会議を作成したユーザー）';
$string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = '参加者数';
$string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = '会議が記録されます';
$string['privacy:metadata:local_intelliboard_bbb_meet:running'] = '会議のステータス（アクティブ|停止）';
$string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = '会議の開始時間';
$string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'ビデオカメラが接続されている参加者の数';
$string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = '音声ブリッジの内線番号（電話システムに接続されている場合に使用）';
$string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'マイクを接続した参加者の数';
$string['privacy:metadata:local_intelliboard_details'] = 'Intelliboard alt/logs/by-hour table';
$string['privacy:metadata:local_intelliboard_details:logid'] = 'テーブルID';
$string['privacy:metadata:local_intelliboard_details:timepoint'] = '時間';
$string['privacy:metadata:local_intelliboard_details:timespend'] = '1時間あたりに費やされた時間。';
$string['privacy:metadata:local_intelliboard_details:visits'] = '1日あたりの回数：訪問回数、マウスクリック';
$string['privacy:metadata:local_intelliboard_logs'] = 'Intelliboard alt/logs/by-day table';
$string['privacy:metadata:local_intelliboard_logs:timepoint'] = '特定のタイムスタンプ';
$string['privacy:metadata:local_intelliboard_logs:timespend'] = '1日あたり費やされた時間';
$string['privacy:metadata:local_intelliboard_logs:trackid'] = 'テーブルのID [local_intelliboard_logs]';
$string['privacy:metadata:local_intelliboard_logs:visits'] = '1日あたりの回数：訪問回数、マウスクリック';
$string['privacy:metadata:local_intelliboard_ntf'] = 'Intelliboard通知メインテーブル';
$string['privacy:metadata:local_intelliboard_ntf_hst'] = 'Intelliboardの通知履歴テーブル';
$string['privacy:metadata:local_intelliboard_ntf_hst:email'] = '通知履歴メール';
$string['privacy:metadata:local_intelliboard_ntf_hst:id'] = '通知履歴ID';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = '通知ID';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = '通知名';
$string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = '通知履歴のタイムスタンプ';
$string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = '通知外部アプリケーションID';
$string['privacy:metadata:local_intelliboard_ntf_pms'] = 'Intelliboard notifications dynamic params table';
$string['privacy:metadata:local_intelliboard_ntf:attachment'] = '通知添付ファイル';
$string['privacy:metadata:local_intelliboard_ntf:cc'] = '通知メール';
$string['privacy:metadata:local_intelliboard_ntf:email'] = '通知メール';
$string['privacy:metadata:local_intelliboard_ntf:externalid'] = '通知外部ID';
$string['privacy:metadata:local_intelliboard_ntf:id'] = '通知ID';
$string['privacy:metadata:local_intelliboard_ntf:message'] = '通知メッセージ';
$string['privacy:metadata:local_intelliboard_ntf:state'] = '通知ステータス';
$string['privacy:metadata:local_intelliboard_ntf:subject'] = '通知対象';
$string['privacy:metadata:local_intelliboard_ntf:tags'] = '通知タグ';
$string['privacy:metadata:local_intelliboard_ntf:type'] = '通知タイプ';
$string['privacy:metadata:local_intelliboard_ntf:userid'] = '通知外部アプリケーションID';
$string['privacy:metadata:local_intelliboard_reports'] = 'IntelliboardカスタムSQLレポートテーブル';
$string['privacy:metadata:local_intelliboard_reports:name'] = 'カスタムレポートの名前';
$string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'BASE64エンコードSQLコード';
$string['privacy:metadata:local_intelliboard_reports:status'] = 'レポートのステータス-有効/無効';
$string['privacy:metadata:local_intelliboard_reports:timecreated'] = '作成時間';
$string['privacy:metadata:local_intelliboard_totals'] = 'Intelliboard alt/logs/total table';
$string['privacy:metadata:local_intelliboard_totals:courses'] = 'Moodleのトータルコース';
$string['privacy:metadata:local_intelliboard_totals:sessions'] = 'Moodleのユーザセッションの総数';
$string['privacy:metadata:local_intelliboard_totals:timepoint'] = '特定のタイムスタンプ';
$string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Moodleの全ユーザが費やした総時間';
$string['privacy:metadata:local_intelliboard_totals:visits'] = 'Moodle全訪問者の総訪問数';
$string['privacy:metadata:local_intelliboard_tracking'] = 'Intelliboard alt/logs/all-time table';
$string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'ユーザーが訪れたコースID';
$string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'ユーザーの最初のアクセス';
$string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'ユーザーの最終アクセス';
$string['privacy:metadata:local_intelliboard_tracking:page'] = 'ページタイプ[コース、モジュール、プロフィール、サイト]';
$string['privacy:metadata:local_intelliboard_tracking:param'] = 'ページIDのタイプ';
$string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'ユーザーがページに表示するタイムペイン';
$string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'ユーザーのブラウザタイプ';
$string['privacy:metadata:local_intelliboard_tracking:userid'] = 'MoodleページにアクセスしたユーザーID';
$string['privacy:metadata:local_intelliboard_tracking:userip'] = 'ユーザーの最後のIPアドレス';
$string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'ユーザーブラウザ言語';
$string['privacy:metadata:local_intelliboard_tracking:useros'] = 'ユーザーオペレーティングシステム';
$string['privacy:metadata:local_intelliboard_tracking:visits'] = 'ユーザーがページにアクセスしました';
$string['process'] = '処理する';
$string['product'] = '製品';
$string['progress'] = '進捗状況';
$string['ques_breakdown'] = '質問の内訳';
$string['quiz_finished'] = '小テストが終了しました';
$string['quiz_grades'] = '小テスト評定';
$string['quiz_name'] = '小テスト名';
$string['quiz_name_a'] = '小テスト: {$a}';
$string['quizzes'] = '小テスト';
$string['recurringperiod'] = '繰り返し期間';
$string['registered'] = '登録済み';
$string['registrations'] = '登録';
$string['remove_message'] = 'SQLレポートは削除されました';
$string['report'] = 'レポート';
$string['reports'] = 'レポート';
$string['reportselect'] = 'App.IntelliBoard.netから少なくとも1つのレポートを選択してください。レポートをクリックしてから、レポート設定をクリックし、「Moodleで表示」で選択してください。';
$string['return_to_courses'] = 'コースに戻る';
$string['return_to_grades'] = '評定に戻る';
$string['return_to_home'] = 'HOMEに帰る';
$string['return_to_sessions'] = 'セッションに戻る';
$string['role1'] = '第1のロール';
$string['role2'] = '第2のロール';
$string['s25'] = '活動に費やされた時間';
$string['s45'] = '活動';
$string['s46'] = '実施中学習者の割合';
$string['s47'] = 'トピック';
$string['s48'] = 'トピックに費やした時間';
$string['save'] = '保存';
$string['scale_percentage'] = 'パーセンテージ';
$string['scale_percentage_round'] = 'パーセンテージラウンド';
$string['scale_raw'] = '尺度を無効にする';
$string['scale_real'] = '代わりに真の評定を表示する';
$string['scale_total'] = '合計評定';
$string['scale_value'] = '値';
$string['scales'] = 'カスタム尺度を有効にする';
$string['scalesettings'] = 'カスタム尺度を有効にする';
$string['score'] = '評定';
$string['seatnumber'] = '座席数';
$string['seatscode'] = '座席コード';
$string['seatsused'] = '使用済み';
$string['section'] = 'セクション';
$string['sections'] = 'セクション';
$string['select'] = '選択';
$string['select_course'] = 'コースを選択';
$string['select_date'] = '日付の選択';
$string['select_manager_role'] = 'マネージャーのロールを選択してください';
$string['select_quiz'] = '小テストを選択';
$string['select_user'] = 'ユーザーを選択';
$string['selectall'] = 'すべて選択';
$string['server'] = 'インテリボードサーバー';
$string['server_au'] = 'インテリボードオーストラリア';
$string['server_eu'] = 'インテリボードヨーロッパ';
$string['server_usa'] = 'インテリボード USA';
$string['session_name'] = 'セッション名';
$string['session_time'] = 'セッション時間';
$string['settings'] = '設定';
$string['show_dashboard_tab'] = 'ダッシュボードタブを表示';
$string['showing_1_to_10'] = '1〜10を表示';
$string['sizemode'] = 'サイズモード：大（> 5,000ユーザー）';
$string['sqlreport'] = 'SQLレポート';
$string['sqlreportactive'] = '有効化';
$string['sqlreportcode'] = 'SQL';
$string['sqlreportcreate'] = 'レポートを作成する';
$string['sqlreportdate'] = '作成日時';
$string['sqlreportinactive'] = '非アクティブ化';
$string['sqlreportname'] = 'レポート名';
$string['sqlreports'] = 'SQLレポート';
$string['sslversion'] = 'CURLOPT SSLVERSION';
$string['sslversion_desc'] = 'パラメータとしてlongを渡し、使用するSSL / TLSバージョンのバージョン範囲を制御します';
$string['sso'] = 'SSOリンク';
$string['sso_desc'] = 'インテリボード.netへのSSOリンク';
$string['ssodomain'] = 'サブドメインSSO';
$string['ssodomain_desc'] = '分離されたサーバー/アカウントを持つシングルサインオン';
$string['ssomenu'] = 'SSOメニュー項目';
$string['ssomenu_desc'] = 'ナビゲーションメニューのSSOリンク（管理者のみ）';
$string['status'] = 'ステータス';
$string['student_course_visibility'] = '[学生]の非表示/停止中のコースを表示';
$string['student_grades'] = '学生の評定';
$string['student_redirect'] = '学生のリダイレクト';
$string['subscriptiondate'] = 'サブスクリプション日付';
$string['success_message'] = 'SQLレポートが保存されました';
$string['support'] = 'サポート';
$string['support_close'] = '閉じる';
$string['support_demo'] = 'デモを予約する';
$string['support_info1'] = '<a target=\'_blank\' href=\'https://intelliboard.net/events\'>ウェビナー</a>に参加して、IntelliBoard 5.0のレポートと分析のツアーをご覧ください。';
$string['support_info2'] = '<a target=\'_blank\' href=\'https://intelliboard.net/events\'>ウェビナー</a>に参加するか、独自に個人デモをスケジュールしてください。 ワールドクラスのサポートとサービスにより、LMSをまったく新しい視点で見ることができます。';
$string['support_page'] = 'サポートページ';
$string['support_terms'] = 'All rights reserved.';
$string['support_text1'] = 'All your Moodle data: easy, shareable, understandable, and attractive. IntelliBoard is a Moodle plugin that puts <strong>120+</strong> reports and monitors into your hands.';
$string['support_text2'] = 'All your Moodle data: easy, shareable, understandable, and attractive. IntelliBoard is your Moodle reporting and analytics solution, giving you 120+ reports and analytics to help inform your educational business decisions.';
$string['support_trial'] = '試用を開始';
$string['suspended'] = '停止中';
$string['sync_data_with_attendance'] = 'データを出席者と同期する';
$string['t01'] = '時間フィルタ:先月';
$string['t02'] = '時間フィルタ:最後の四半期';
$string['t03'] = '時間フィルタ:Last Semester';
$string['t04'] = '[ヘッダー]を有効にしました。';
$string['t05'] = '[ヘッダー]進行中のコースを有効にする';
$string['t06'] = '[ヘッダー]コース平均を有効にします。評定';
$string['t07'] = '[ヘッダー]メッセージを有効にします。';
$string['t08'] = '[ヘッダー]コース合計を有効にします。評定';
$string['t09'] = '教員は自分の学習者を見ることができます。';
$string['t1'] = '学習者ダッシュボードを有効にする';
$string['t10'] = '[小テスト]ウィジェットを有効にする';
$string['t11'] = '[コース進捗状況]ウィジェットを有効にする';
$string['t12'] = '[活動参加]ウィジェットを有効にする';
$string['t13'] = '[学習]ウィジェットを有効にする';
$string['t14'] = '[コースの完了]ウィジェットを有効にする';
$string['t15'] = '[相関]ウィジェットを有効にする';
$string['t16'] = 'コース教師を有効にする';
$string['t17'] = 'コースカテゴリを有効にする';
$string['t18'] = 'コースの完了を有効にする';
$string['t19'] = 'コースの評定を有効にする';
$string['t2'] = 'ダッシュボードを有効にする';
$string['t20'] = 'コースの平均を有効にする';
$string['t21'] = 'コース時間を有効にする';
$string['t22'] = 'コース開始日を有効にする';
$string['t23'] = '[コース開始日]列を有効にする';
$string['t24'] = '[登録された日付]列を有効にする';
$string['t25'] = '[進捗状況]列を有効にする';
$string['t26'] = '[レター]列を有効にする';
$string['t27'] = '[完了した活動]列を有効にする';
$string['t28'] = '[評定]列を有効にする';
$string['t29'] = '[受講完了ステータス]列を有効にする';
$string['t3'] = 'コースを有効にする';
$string['t30'] = '[活動評定]列を有効にする';
$string['t31'] = '[課題] [評定]ウィジェット列を有効にする';
$string['t32'] = '[予定] [期日]ウィジェット列を有効にします';
$string['t33'] = '[小テスト] [評定]ウィジェット列を有効にする';
$string['t34'] = '[小テスト] [期日]ウィジェット列を有効にする';
$string['t35'] = '[コース進捗] [進度]ウィジェット列を有効にします。';
$string['t36'] = '[コース進捗状況] [グレード]ウィジェット列を有効にする';
$string['t37'] = '[コース進捗状況] [登録済み]ウィジェット列を有効にする';
$string['t38'] = 'コースの進捗状況を有効にする[完了]ウィジェット列';
$string['t39'] = '[進捗状況] [ゴール評定]オプションを有効にする';
$string['t4'] = '評定を有効にする';
$string['t40'] = '[進捗状況] [学習者平均]オプションを有効にする';
$string['t41'] = '[活動評定ヘッダー]を有効にします。';
$string['t42'] = '[活動評定ヘッダー]を有効にしてください。';
$string['t43'] = '[活動評定]を有効にしてください';
$string['t44'] = '[活動評定] 評定列を有効にします。';
$string['t45'] = '[活動評定] 評定列を有効にします。';
$string['t46'] = '[活動評定]を有効にしました';
$string['t47'] = 'コース[グリッド]背景色';
$string['t48'] = 'レポートを有効にする';
$string['t49'] = 'レポートフィルタ列';
$string['t5'] = '[活動の進捗状況]グラフを有効にする';
$string['t50'] = '教師のロール';
$string['t51'] = '学習者のロー';
$string['t52'] = '[コース完了] [カテゴリー]ウィジェット行を有効にします';
$string['t53'] = '[活動の完了状況]チャートの平均線で有効にする';
$string['t6'] = '[コースの完了状況]グラフを有効にする';
$string['t7'] = '[私のコース平均]を有効にする';
$string['t8'] = '[全コース平均]を有効にする';
$string['t9'] = '[課題]ウィジェットを有効にする';
$string['table_set_iag'] = '教師テーブル「活動評定」';
$string['table_set_iag_c1'] = '活動名';
$string['table_set_iag_c2'] = 'タイプ';
$string['table_set_iag_c3'] = '完了した学習者';
$string['table_set_iag_c4'] = '評定平均';
$string['table_set_iag_c5'] = '訪問数';
$string['table_set_iag_c6'] = '利用時間';
$string['table_set_iag_c7'] = '行動';
$string['table_set_iag1'] = '教師テーブル「活動評定」Instructor Courses > Activities > Grades';
$string['table_set_iag1_c1'] = '学習者名';
$string['table_set_iag1_c2'] = '電子メールアドレス';
$string['table_set_iag1_c3'] = 'ステータス';
$string['table_set_iag1_c4'] = '評定';
$string['table_set_iag1_c5'] = '評定済';
$string['table_set_iag1_c6'] = '訪問数';
$string['table_set_iag1_c7'] = '利用時間';
$string['table_set_icg'] = '教師用テーブル「コースの評定」Instructor Courses';
$string['table_set_icg_c1'] = 'コース名';
$string['table_set_icg_c11'] = 'アクション-活動';
$string['table_set_icg_c12'] = 'アクション–学習者';
$string['table_set_icg_c2'] = '略称';
$string['table_set_icg_c3'] = 'カテゴリー';
$string['table_set_icg_c4'] = '登録済/完了済の学習者';
$string['table_set_icg_c5'] = 'コース平均評定';
$string['table_set_icg_c6'] = 'セクション';
$string['table_set_icg_c7'] = '活動/リソース';
$string['table_set_icg_c8'] = '訪問数';
$string['table_set_icg_c9'] = '使用時間';
$string['table_set_ilg'] = '教師用テーブル「学習者の評定」
Instructor Courses > Learners';
$string['table_set_ilg_c1'] = '学習者名';
$string['table_set_ilg_c10'] = '行動';
$string['table_set_ilg_c2'] = '電子メールアドレス';
$string['table_set_ilg_c3'] = '登録済み';
$string['table_set_ilg_c4'] = '最終アクセス';
$string['table_set_ilg_c5'] = 'ステータス';
$string['table_set_ilg_c6'] = '評定';
$string['table_set_ilg_c7'] = '完了した活動/リソース';
$string['table_set_ilg_c8'] = '訪問数';
$string['table_set_ilg_c9'] = '利用時間';
$string['table_set_ilg1'] = '教師用テーブル「学習者の評定」Instructor Courses > Learners > Grades';
$string['table_set_ilg1_c1'] = '活動名';
$string['table_set_ilg1_c2'] = 'タイプ';
$string['table_set_ilg1_c3'] = '評定';
$string['table_set_ilg1_c4'] = '評定済';
$string['table_set_ilg1_c5'] = 'ステータス';
$string['table_set_ilg1_c6'] = '訪問数';
$string['table_set_ilg1_c7'] = '利用時間';
$string['te1'] = 'Eメール';
$string['te1_desc'] = 'インテリボード.net購読で使用される電子メールを入力してください。アクティブなサブスクリプションがない場合は、<a target="_blank" href="https://intelliboard.net"> インテリボード.net </a>に登録してください。学習者とインストラクターのダッシュボードには、レベル4以上のサブスクリプションが用意されています。';
$string['te12'] = '名';
$string['te13'] = '姓';
$string['teacher'] = '教師';
$string['tex1'] = 'IntelliBoard 学習者ダッシュボードは有効になっていません。';
$string['this_year'] = '今年';
$string['time'] = '時刻';
$string['time_1'] = '午前';
$string['time_2'] = '午後';
$string['time_3'] = '夕方';
$string['time_4'] = '時間外';
$string['time_period_due'] = '期間（期日）';
$string['time_spent'] = '利用時間';
$string['timespent'] = '------ 利用時間 ----';
$string['tls12'] = 'TLS v1.2';
$string['tls12_desc'] = '詳細設定:TLS v1.2';
$string['topics'] = 'トピック';
$string['total'] = '合計';
$string['total_activities_resources'] = '総活動/リソース';
$string['total_numbers'] = '日: {$a->timepoint}, セッション: {$a->sessions}, 訪問数: {$a->visits}, 利用時間: {$a->timespend}';
$string['total_numbers2'] = 'ユーザ: {$a->userid}, ページ: {$a->page}, Param:{$a->param}, 訪問数: {$a->visits}, 利用時間: {$a->timespend}';
$string['total_numbers3'] = '----日: {$a->timecreated}, トラックID: {$a->trackid}, 訪問数: {$a->visits}, 利用時間: {$a->timespend}';
$string['total_time_spent_enrolled_learners'] = '登録された学習者がコースに費やした合計時間';
$string['total_values_include'] = '合計値にはユニークセッション、コース、訪問、時間が含まれます。';
$string['total_visits_enrolled_learners'] = '登録された学習者のコース訪問総数';
$string['totara'] = 'Totara';
$string['trackadmin'] = 'トラッキング管理者';
$string['trackadmin_desc'] = 'トラッキング管理者';
$string['trackdetails'] = 'Track Time by User - Hourly';
$string['tracking'] = 'セッショントラッキング';
$string['tracking_title'] = '時間トラッキング';
$string['tracklogs'] = 'ユーザーごとの時間の追跡-毎日';
$string['trackmedia'] = 'HTML5メディアを追跡する';
$string['trackmedia_desc'] = 'HTML5ビデオとオーディオを追跡する';
$string['tracktotals'] = '集計時間-毎日';
$string['ts1'] = '学習者ダッシュボード';
$string['ts2'] = '学習者ダッシュボードページ';
$string['ts3'] = '学習者ダッシュボードコース';
$string['ts4'] = '学習者のダッシュボード評定';
$string['ts5'] = '学習者ダッシュボードレポート';
$string['type'] = 'タイプ';
$string['type_here'] = 'ここに入力してください...';
$string['used'] = 'Used';
$string['user_enrollments_sessions_completion'] = 'ユーザー登録、セッション、活動完了レベル';
$string['user_enrolments'] = 'ユーザー登録';
$string['user_grade_avg'] = '{$a->user} 評定: {$a->grade}, 評定平均: {$a->avg_grade_site})';
$string['user_map'] = 'ユーザーマップ';
$string['user_site_summary_detail'] = 'ユーザーサイトの概要の詳細';
$string['user_time_avg'] = '{$a->user} 利用時間: {$a->timespend}, 利用時間平均: {$a->avg_timespend_site}';
$string['user_visit_avg'] = '{$a->user} 訪問: {$a->visits}, 訪問数平均: {$a->avg_visits_site}';
$string['username'] = 'ユーザー名';
$string['users'] = 'ユーザー';
$string['users_activity'] = 'ユーザーの活動';
$string['users_overview'] = 'ユーザー概要';
$string['verifyhost'] = 'CURLOPT SSL VERIFYHOST';
$string['verifyhost_desc'] = 'This option determines whether libcurl verifies that the server cert is for the server it is known as.';
$string['verifypeer'] = 'CURLOPT SSL VERIFYPEER';
$string['verifypeer_desc'] = 'This option determines whether curl verifies the authenticity of the peer\'s certificate.';
$string['view_course_details'] = 'コースの詳細を表示する';
$string['viewed'] = '表示済';
$string['visits'] = '訪問数';
$string['weekday_0'] = '月曜';
$string['weekday_1'] = '火曜';
$string['weekday_2'] = '水曜';
$string['weekday_3'] = '木曜';
$string['weekday_4'] = '金曜';
$string['weekday_5'] = '土曜';
$string['weekday_6'] = '日曜';
$string['weekly'] = '週別';
$string['widget_name27'] = '累積登録';
$string['widget_name28'] = 'エンゲージメント';
$string['widget_name29'] = 'ユニークログイン';
$string['widget_name30'] = 'コース別登録者';
$string['widget_name31'] = '登録者と管理者が取得します';
$string['x_completions'] = '{$a} 完了';
$string['you_have_certificates'] = 'あなたは {$a} 修了証を持っています。';
$string['debug_desc'] = "";

$string['instructor_show_suspended_enrollments'] = "Show suspended enrollments";
$string['instructor_hide_suspended_enrollments'] = 'Hide suspended enrollments';
$string['check_active_bb_col_meetings'] = "Check active BlackBoard Collaborate meeting";
$string['learner_menu'] = "Show Learner Dashboard in Navigation Block menu only for enrolled learners";
$string['learning_plan_filter'] = "Learning Plan Filter";
$string['learning_plan_viewer_role'] = " Learning Plan Viewer role";
#new strings
$string['intelliboard_reports'] = 'IntelliBoard Reports';
$string['n19'] = 'Course Navigation Link for Reports';
$string['t54'] = 'Enable [Activity Grades] Time Spent column';
$string['all_cohorts'] = 'All cohorts';
$string['privacy_shield_policy'] = 'Data Processing Addendum';
$string['privacy_policy'] = 'Privacy Policy';
$string['confirm_and_sign_up'] = 'Confirm and Sign Up';
$string['term_of_use'] = 'Terms Of Use';
$string['setup'] = 'Connect Now';
$string['protocol'] = 'Protocol';
$string['rest'] = 'REST';
$string['soap'] = 'SOAP';
$string['next'] = 'Next';
$string['terms_msg'] = 'By checking this box you confirm that you have read and agree to our Terms of Use.';
$string['privacy_msg'] = 'By checking this box you confirm that you have read and agree to our Privacy Policy.';
$string['shield_msg'] = 'By checking this box you confirm that you have read and agree to our Data Processing Addendum.';
$string['enable_webservice'] = 'Enable web services';
$string['you_need_to_enable_at_least_one_protocol'] = 'You need to enable at least one protocol';
$string['invalid_user'] = 'Invalid user';
$string['sign_in'] = 'Sign in';
$string['email'] = 'Email';
$string['password'] = 'Password';
$string['all_fields_required'] = 'All fields required';
$string['server_error'] = 'Server error';
$string['country'] = 'Country';
$string['please_accept_terms_and_conditions'] = 'Please accept terms and conditions';
$string['congratulations_intb_register'] = 'Congratulations';
$string['congratulations_intb_register_msg'] = 'Thank you for starting your 15 day free trial with IntelliBoard!  Please check your email to confirm your IntelliBoard account.  To begin, utilize the Single Sign On (SSO) Link, if enabled from Site Administration > IntelliBoard or sign in <a href="https://app.intelliboard.net/signin">here</a>.  The SSO Link reads as “INTELLIBOARD.NET” and is in the top right corner of the Dashboard. For questions, please contact Support@IntelliBoard.net';
$string['sign_up'] = 'Sign Up';
$string['sign_in'] = 'Sign In';
$string['intelliboard_settings'] = 'IntelliBoard settings';
$string['moodle_settings'] = 'Moodle Settings';
$string['email_is_required'] = 'Email is required';
$string['invalid_email'] = 'Invalid Email';
$string['intelliboard_terms'] = 'IntelliBoard Agreements';
$string['authentication'] = 'Account Creation';
$string['intb_settings_descr'] = "IntelliBoard requires one main, unique subscription email.  Please enter the email you wish to use as your subscription email below.  The email must be double verified through an email confirmation prior to use.  For questions, please contact <a href='mailto:Support@IntelliBoard.net'>Support@IntelliBoard.net</a>. For a full listing of IntelliBoard Settings, go to Site Administration > Plugins > Local Plugins > IntelliBoard";
$string['hosting_provider'] = 'Hosting Provider';
$string['self_hosted'] = 'Self-Hosted';

// date formats
$string['mysqlweek'] = '%Y, week %v';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlyear'] = '%Y';
$string['mysqlmonth'] = '%c';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlquarter'] = 'quarter';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';

$string['postgreweek'] = 'YYYY, "week" WW';
$string['postgremonthyear'] = 'Month YYYY';
$string['postgreyear'] = 'YYYY';
$string['postgremonth'] = 'MM';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgrequarter'] = 'quarter';
$string['postgredayshortmonthyear'] = 'DD Mon, YYYY';
$string['postgretimedate'] = 'HH12:MIAM, DD Mon YYYY';
$string['postgredaymonth'] = 'DD Mon YYYY';
$string['postgremonthyearday'] = 'Month YYYY, DD';
$string['postgrequarteryear'] = 'Q YYYY';
$string['postgremonthdayyear'] = 'MM/DD/YYYY';
$string['postgretimemonthdayyear'] = 'HH24 MM/DD/YYYY';

// new strings
$string['report1_name'] = 'User Status';
$string['report2_name'] = 'Course Stats';
$string['report3_name'] = 'Activity Stats Summary';
$string['report45_name'] = 'Quiz Activity Detail';
$string['report_activity_stats_summary'] = 'Activity Stats Summary';
$string['report_user_profile_information'] = 'User Profile Information';
$string['course_name'] = 'Course Name';
$string['course_short_name'] = 'Course Short Name';
$string['course_idnumber'] = 'ID Number';
$string['course_status'] = 'Status';
$string['number_of_learners'] = '# of Enrolled User(s)';
$string['number_of_modules'] = '# of Activity(ies)';
$string['number_of_completed_learners'] = '# of Completed User(s)';
$string['number_of_visits'] = 'Visit(s)';
$string['num_completed_activity'] = '# of Users Who Completed This Activity';
$string['total_time_spent'] = 'Total Time Spent';
$string['date_created'] = 'Date Created';
$string['initial_reports'] = 'Initial Reports';
$string['avg_score'] = 'Average Score';
$string['first_access'] = 'First Access';
$string['completion_not_enabled'] = 'Completion Not Enabled';
$string['first_name'] = 'First Name';
$string['last_name'] = 'Last Name';
$string['num_attempts'] = '# of Attempts';
$string['highest_grade'] = 'Highest Grade';
$string['lowest_grade'] = 'Lowest Grade';
$string['initial_reports_warning'] = 'To email, schedule, and further personalize these reports, click <a href="{$a}">Contact Us</a>.';
$string['last_access'] = 'Last Access';
$string['enrolment_expiration'] = 'Enrolment Expiration';
$string['id_number'] = 'ID Number';
$string['telephone1'] = 'Telephone 1';
$string['telephone2'] = 'Telephone 2';
$string['institution'] = 'Institution';
$string['department'] = 'Department';
$string['address'] = 'Address';
$string['city'] = 'City/Town';
$string['enroled_on'] = 'Enrollment Date';

$string['dashboard_link'] = 'Click to view Analytics';
$string['support_connect'] = 'Click the report buttons within the rectangle below. Get a glimpse into the power of IntelliBoard: 1 button access to your LMS insights. Want more? Click "Click to view Analytics". Still want more? <a href="{$a->connect_link}">Contact Us</a> in the top right, or anywhere you see the link.';
$string['support_text3'] = 'Thank you for installing IntelliBoard Lite!';
$string['support_text4'] = 'Meet an easy-to-use reporting and visualization platform that will help you achieve your retention, engagement, and compliance goals.';
$string['support_text6'] = 'Need more info? Click any of the blue buttons to connect with us.';

$string['web_services_descr'] = 'IntelliBoard requires Web services to be enabled. Web services enables other systems (e.g., IntelliBoard) to access this LMS system and preform operations.  For security purposes, this should be disabled when not in use.   For additional review, go to Site Administration > Advanced features > Web services';
$string['protocol_descr'] = 'IntelliBoard requires either REST or SOAP Protocol to be enabled.  For security purposes, only protocols that are in use should be enabled.  For additional review, go to Site Administration > Plugins > Web services > Manage protocols';
$string['authorized_user_descr'] = 'IntelliBoard requires an Authorized user.  The Authorized user will likely be a Site Administrator and must have privileges to manage web services, protocols and tokens.  For additional review, go to Site Administration > Plugins > Web services > External Services > IntelliBoard service > Authorized user';
$string['email_subscr'] = 'Subscription email';
$string['protocols_descr'] = 'IntelliBoard requires either REST or SOAP Protocol to be enabled.  For security purposes, only protocols that are in use should be enabled.  For additional review, go to Site Administration > Plugins > Web services > Manage protocols';
$string['enable_time_tracking'] = 'Enable Time Tracking';
$string['enable_time_tracking_descr'] = 'Enable Time Tracking for additional insights on user access, visits and time spent. IntelliBoard provides additional insights on time tracking separately from the Moodle time spent tables.';
$string['enable_sso'] = 'Enable Single Sign On (SSO) Link';
$string['enable_sso_descr'] = 'Enable Single Sign On Link for one click access for Site Administrators into the IntelliBoard SuperAdmin access on app.IntelliBoard.net';
$string['join_a_webinar'] = 'Join a Webinar';
$string['review_support_doc'] = 'Review Support Documentation';
$string['setup_subheading'] = 'Connect to experience the power of your data. No credit card. No obligation. Just 15 free days of data bliss.';

$string['instructor_courses_table_name'] = 'Course Grades';
$string['instructor_courses_table_name_learner'] = 'Course {$a->course}, Learner {$a->learner}, Grades';
$string['instructor_courses_table_name_activity'] = 'Course {$a->course}, Activity {$a->name}, Grades';
$string['instructor_courses_table_name_learners'] = 'Course {$a->fullname}, Learners';
$string['instructor_courses_table_name_activities'] = 'Course {$a->fullname}, Activities';

$string['successfull_connected'] = 'Sucessfully connected';
$string['not_connected'] = 'Not connected';

$string['transcripts'] = 'Transcripts';
$string['enable_transcripts'] = 'Enable Transcripts';
$string['closed'] = 'Closed';
$string['synctranscriptstask'] = 'Sync Transcripts Task';
$string['transcriptssyncrecordsnum'] = 'Transcripts Processing Size';
$string['transcriptssyncrecordsnum_desc'] = 'The number of users enrollments records which will be processed at once';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'Transcripts courses records';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'User ID';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'User email';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'User first name';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'User last name';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'Transcripts user enroll ID';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'Enroll record ID';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'Enroll method';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'Course ID';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = 'Course full name';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'Enrollment Date';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'Unenrollment Date';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'Completion Date';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'Transcript Status';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'Grade Item ID';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = 'Grade Grade ID';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'Max Grade';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'Min Grade';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'Final Grade';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'Formatted Grade';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'User Roles';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'User Groups';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'Timestamp when record created';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'Timestamp when record was updated last time';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'Transcripts courses records';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'Transcripts user enroll ID';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'Course ID';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'User ID';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'Course Module ID';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'Module ID';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Activity Name';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Module Type';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Start Date';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Completion Date';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Status';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'Grade Item ID';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = 'Grade Grade ID';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'Max Grade';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'Min Grade';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Final Grade';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'Formatted Grade';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'Timestamp when record created';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'Timestamp when record was updated last time';
$string['goal_grade'] = 'Goal Grade';
$string['importtrackingtask'] = 'Import Tracking Task';
$string['compresstracking'] = 'Compress Tracking';
$string['compresstracking_desc'] = 'Write Time Tracking data to file and transfer data to database with cron job (default: every 15 minutes)';
$string['cachedef_instructor_course_data'] = 'Cache for course data';
$string['cachedef_reports_list'] = 'Cache for reports list';
$string['do_not_use_compresstracking'] = 'Do not use Compress Tracking';
$string['cache_compresstracking'] = 'Save to Moodle Cache';
$string['file_compresstracking'] = 'Save to MoodleData';
$string['cachedef_tracking'] = 'Intelliboard Tracking data';
$string['cachedef_track_config'] = 'Intelliboard Tracking total data';
$string['coursecontainer_filter'] = 'Enable course container filter';
$string['enableexportcustomfont'] = '日本/中国互換フォント';
$string['all_selected'] = 'すべて選択';
$string['custommenuitem'] = 'Display in Custom Menu';
$string['support_text7'] = 'To get started with <strong>IntelliBoard Lite</strong>, please <a href="{$a->meeting_link}">schedule a consultation</a> with one of our learning analytics experts.';
$string['support_text8'] = 'If you have <strong>already purchased</strong> a license and see this screen, please contact your Account Manager for assistance.';
$string['support_text9'] = 'Need predictive models, notifications, and intervention tracking?';
$string['support_text10'] = 'Switch to <a href="{$a->intelliboard_pro_link}"><strong>IntelliBoard Pro</strong></a>';
$string['support_text11'] = '<a href="{$a->intelliboard_pro_onepager}">Click here</a> to download the IntelliBoard Pro one-pager.';
$string['enable_vendor_frontpage_course'] = 'Enable the frontpage course in the reports for vendors';
$string['pagelayout'] = 'Theme page layout';
