<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
/**
 * This plugin provides access to Moodle data in form of analytics and reports in real time.
 *
 *
 * @package    local_intelliboard
 * @copyright  2017 IntelliBoard, Inc
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @website    http://intelliboard.net/
 */
 $string['pluginname'] = 'IntelliBoard.net Plugin';
 $string['tracking_title'] = 'Rastreio de Tempo';
 $string['tracking'] = 'Rastreio de Sessão';
 $string['dashboard'] = 'Painel';
 $string['settings'] = 'Configurações';
 $string['adv_settings'] = 'Configurações Avançadas';
 $string['intelliboardroot'] = 'IntelliBoard';
 $string['report'] = 'Relatório';
 $string['reports'] = 'Relatórios';
 $string['learners'] = 'Estudantes';
 $string['courses'] = 'Disciplinas';
 $string['load'] = 'Desempenho';
 $string['inactivity'] = 'Inatividade';
 $string['inactivity_desc'] = 'Tem de Inatividade do usuário (em segundos)';
 $string['ajax'] = 'Frequência';
 $string['ajax_desc'] = 'Session storing frequency via AJAX. 0 - AJAX disabled (in seconds)';
 $string['enabled'] = 'Rastreamento Ativado';
 $string['enabled_desc'] = 'Ativar Rastreio';
 $string['trackadmin'] = 'Administradores do Rastreio';
 $string['logs'] = 'Ferramenta de Migração';
 $string['trackadmin_desc'] = 'Enable tracking for admin users (not recommended)';
 $string['intelliboard:instructors'] = 'IntelliBoard [instrutor]';
 $string['intelliboard:students'] = 'IntelliBoard [estudante]';
 $string['intelliboard:view'] = 'IntelliBoard [ver]';
 $string['intelliboard:manage'] = 'IntelliBoard [gerir]';
 $string['intelliboard:competency'] = 'IntelliBoard [competências]';
$string['intelliboard:browseallcohorts'] = 'IntelliBoard [Browse All Cohorts]';
 $string['tls12'] = 'TLS v1.2';
 $string['tls12_desc'] = 'Configurações Avançadas: TLS v1.2';
 $string['sso'] = 'SSO link';
 $string['sso_desc'] = 'SSO Link to IntelliBoard.net';
 $string['ssomenu'] = 'SSO menu item';
 $string['ssomenu_desc'] = 'SSO Link no menu de navegação (para não-estudantes / não-instrutores)';
 $string['api'] = 'Alternative API';
 $string['api_desc'] = 'Use um servidor de API alternativo (para evitar o bloqueio de firewall)';
 $string['server'] = 'Servidor IntelliBoard';
 $string['server_usa'] = 'IntelliBoard EUA';
 $string['server_au'] = 'IntelliBoard Australia';
 $string['server_eu'] = 'IntelliBoard Europa';
 $string['filters'] = 'Filtros do Painel';
 $string['filter1'] = 'Usuários Excluídos';
 $string['filter2'] = 'Usuários Suspensos';
 $string['filter3'] = 'Visitante';
 $string['filter4'] = 'Filtro de Disciplinas';
 $string['filter5'] = 'Filtro de método de inscrição';
 $string['filter6'] = 'Filtro de inscrição do usuário';
 $string['filter7'] = 'Activities/Resourses filter';
 $string['filter8'] = 'Filtro de usuários cadastrados';
 $string['filter1_desc'] = 'Mostrar usuários excluídos';
 $string['filter2_desc'] = 'Mostrar usuários suspensos';
 $string['filter3_desc'] = 'Mostrar o usuário [guest] nos relatórios';
 $string['filter4_desc'] = 'Mostrar Disciplinas não visíveis';
 $string['filter5_desc'] = 'Mostrar métodos de inscrição inativos';
 $string['filter6_desc'] = 'Mostrar usuários com status de inscrição inativo';
 $string['filter7_desc'] = 'Mostrar atividades / recursos não visíveis';
 $string['filter8_desc'] = 'Mostrar apenas usuários inscritos (não recomendado)';
 $string['intelliboardaccess'] = 'Você não tem permissão para ver esta página. Entre em contato com seu administrador para obter assistência.';
 $string['tex1'] = 'O Painel do Estudante IntelliBoard não está ativado.';
 $string['account'] = 'Informações sobre assinatura';
 $string['te12'] = 'Nome';
 $string['te13'] = 'Sobrenome';
 $string['te1'] = 'Email';
 $string['te1_desc'] = 'Digite o e-mail usado com a assinatura do IntelliBoard.net. Se você não possui uma assinatura ativa, registre-se em <a target="_blank" href="https://intelliboard.net"> IntelliBoard.net </a>. Os Painéis do Estudante e Instrutor estão disponíveis com a assinatura Nível 4 e superior.';
 $string['n1'] = 'Visão Geral [Learner Progress]';
 $string['n2'] = 'Visão Geral [Grade Progress]';
 $string['n3'] = 'Visão Geral [Activity Progress]';
 $string['n12'] = 'Visão Geral [Course Overview]';
 $string['n4'] = 'Visão Geral [Totals]';
 $string['n5'] = 'Progresso atual';
 $string['n13'] = 'Total de Estudantes';
 $string['n6'] = 'Widget: Correlações';
 $string['n14'] = 'Widget: Envolvimento do Estudante';
 $string['n18'] = 'Widget: Evolução da nota do estudante';
 $string['n7'] = 'Widget: Utilização de Eventos';
 $string['n15'] = 'Widget: Utilização da atividade';
 $string['n16'] = 'Widget: Utilização de tópicos';
 $string['n8'] = 'Página de Disciplinas';
 $string['n9'] = 'Página de relatórios';
 $string['n10'] = 'Painel do Instrutor';
 $string['n101'] = 'Ativar o Painel do Instrutor';
 $string['n11'] = 'Texto alternativo para o menu de navegação';
 $string['ts1'] = 'Painel do Estudante';
 $string['ts2'] = 'Página do Painel do Estudante';
 $string['ts3'] = 'Disciplinas do Painel do Estudante';
 $string['ts4'] = 'Notas do Painel do Estudante';
 $string['ts5'] = 'Relatórios do Painel do Estudante';
 $string['learner_tf_last_week'] = 'Filtro de tempo: Últimos 7 dias';
 $string['t01'] = 'Filtro de tempo: Últimos 30 dias';
 $string['t02'] = 'Filtro de tempo: Últimos 3 meses';
 $string['t03'] = 'Filtro de tempo: Últimos 6 meses';
 $string['t04'] = 'Ativar [header] Disciplinas concluídas';
 $string['t05'] = 'Ativar [header] Disciplinas em andamento';
 $string['t06'] = 'Ativar [header] Nota média de Disciplinas';
 $string['t07'] = 'Ativar [header] Menssagens';
 $string['t08'] = 'Ativar [header] Nota resumida das Disciplinas';
 $string['t09'] = 'O instrutor pode ver seus próprios alunos';
 $string['t1'] = 'Ativar Painel do Estudante';
 $string['t2'] = 'Ativar Painel';
 $string['t3'] = 'Ativar Disciplinas';
 $string['t4'] = 'Ativar Notas';
 $string['t48'] = 'Ativar Relatórios';
 $string['t5'] = 'Ativar [Activity progress] gráfico';
 $string['t53'] = 'Ativar no [Activity progress] linha média do gráfico';
 $string['t6'] = 'Ativar [Course progress] gráfico';
 $string['t7'] = 'Ativar [My course average]';
 $string['t8'] = 'Ativar [Overall course average]';
 $string['t9'] = 'Ativar [Assignments] widget';
 $string['t10'] = 'Ativar [Quizzes] widget';
 $string['t11'] = 'Ativar [Course Progress] widget';
 $string['t12'] = 'Ativar [Activity participation] widget';
 $string['t13'] = 'Ativar [Learning] widget';
 $string['t14'] = 'Ativar [Course success] widget';
 $string['t15'] = 'Ativar [Correlations] widget';
 $string['t16'] = 'Ativar Professor da Disciplina';
 $string['t17'] = 'Ativar Categoria da Disciplina';
 $string['t18'] = 'Ativar Conclusão da Disciplina';
 $string['t19'] = 'Ativar Nota da Disciplina';
 $string['t20'] = 'Ativar Média da turma';
 $string['t21'] = 'Ativar tempo dispensado na Disciplina';
 $string['t22'] = 'Ativar data de inscrição na Disciplina';
 $string['t23'] = 'Ativar [Course start date] coluna';
 $string['t24'] = 'Ativar [Enrolled date] coluna';
 $string['t25'] = 'Ativar [Progress] coluna';
 $string['t26'] = 'Ativar [Letter] coluna';
 $string['t27'] = 'Ativar [Completed Activities] coluna';
 $string['t28'] = 'Ativar [Grade] coluna';
 $string['t29'] = 'Ativar [Course Completion Status] coluna';
 $string['t30'] = 'Ativar [Activity Grades] coluna';
 $string['t31'] = 'Ativar [Assignments][Grade] widget coluna';
 $string['t32'] = 'Ativar [Assignments][Due Date] widget coluna';
 $string['t33'] = 'Ativar [Quizzes][Grade] widget coluna';
 $string['t34'] = 'Ativar [Quizzes][Due Date] widget coluna';
 $string['t35'] = 'Ativar [Course Progress][Progress] widget coluna';
 $string['t36'] = 'Ativar [Course Progress][Grade] widget coluna';
 $string['t37'] = 'Ativar [Course Progress][Enrolled] widget coluna';
 $string['t38'] = 'Ativar [Course Progress][Completed] widget coluna';
 $string['t52'] = 'Ativar [Course Progress][Category] widget linhas';
 $string['t39'] = 'Ativar [Progress][Goal Grade] opção';
 $string['t40'] = 'Ativar [Progress][Class Avg.] opção';
 $string['t41'] = 'Ativar [Activity Grades header] Concluído em';
 $string['t42'] = 'Ativar [Activity Grades header] Último acesso a Disciplina';
 $string['t43'] = 'Ativar [Activity Grades] Coluna Tipo';
 $string['t44'] = 'Ativar [Activity Grades] Coluna Nota';
 $string['t45'] = 'Ativar [Activity Grades] Coluna Nota';
 $string['t46'] = 'Ativar [Activity Grades] Coluna Conclusão';
 $string['t47'] = 'Disciplinas [grid] Cor de Fundo';
 $string['t49'] = 'Colunas de filtro de relatório';
 $string['t50'] = 'Função Professor';
 $string['t51'] = 'Função Estudante';
 $string['current_grade'] = 'nota atual';
 $string['average_grade'] = 'nota média';
 $string['type_here'] = 'Escreva aqui...';
 $string['enrolled_date'] = 'Data de Inscrição';
 $string['teacher'] = 'Professor';
 $string['category'] = 'Categoria';
 $string['current_grade'] = 'Nota Atual';
 $string['completion'] = 'Conclusão';
 $string['class_average'] = 'Média da Turma';
 $string['time_spent'] = 'Tempo dispensado';
 $string['completed_on'] = 'Concluído em {$a}';
 $string['passed_on'] = 'Concluído (pass) en {$a}';
 $string['failed_on'] = 'Concluído (fail) en {$a}';
 $string['last_access_on_course'] = 'Último acesso a Disciplina: {$a}';
 $string['you_have_certificates'] = 'Você tem {$a} certificados';
 $string['close'] = 'Fechar';
 $string['view_course_details'] = 'Ver detalhes da Disciplina';
 $string['incomplete'] = 'Incompleto';
 $string['return_to_grades'] = 'Voltar a notas';
 $string['grade'] = 'Nota';
 $string['last_week'] = 'Últimos 7 dias';
 $string['last_month'] = 'Últimos 30 dias';
 $string['last_quarter'] = 'Últimos 3 meses';
 $string['last_semester'] = 'Últimos 6 meses';
 $string['activity_progress'] = 'Progresso da Atividade';
 $string['course_progress'] = 'Progresso da Disciplina';
 $string['my_course_average_all'] = 'Minha média da Disciplina (Todas as Disciplinas)';
 $string['overall_course_average'] = 'média geral da Disciplina (todos os alunos; todas as Disciplinas)';
 $string['assignments'] = 'Atribuições';
 $string['quizzes'] = 'Quizzes';
 $string['assignment_name'] = 'Nome da atribuição';
 $string['due_date'] = 'Data limite';
 $string['no_data'] = 'Nenhum dado';
 $string['quiz_name'] = 'Nome do Quiz';
 $string['all_courses'] = 'Todas as Disciplina';
 $string['time_period_due'] = 'Período de tempo (data limite)';
 $string['all_data'] = 'Todos os dados';
 $string['progress'] = 'Progresso';
 $string['enrolled'] = 'Inscritos';
 $string['completed'] = 'Concluído';
 $string['activity_participation'] = 'Participação na Atividade';
 $string['learning'] = 'Estudante';
 $string['course_success'] = 'Sucesso na Disciplina';
 $string['correlations'] = 'Correlações';
 $string['course_start_date'] = 'Data de início da Disciplina';
 $string['letter'] = 'Letra';
 $string['completed_activities'] = 'Atividades concluídas';
 $string['score'] = 'Nota';
 $string['course_completion_status'] = 'Status de conclusão da Disciplina';
 $string['activity_grades'] = 'Notas da Atividade';
 $string['completion_is_not_enabled'] = 'A conclusão não está ativada para esta Disciplina';
 $string['activities'] = 'Atividades';
 $string['activity_name'] = 'Nome da Atividade';
 $string['type'] = 'Tipo';
 $string['graded'] = 'Nota atribuída';
 $string['passed'] = 'Aprovado';
 $string['failed'] = 'Reprovado';
 $string['completed_courses'] = 'Disciplinas concluídas';
 $string['courses_in_progress'] = 'Disciplinas em Progresso';
 $string['courses_avg_grade'] = 'Nota média das Disciplinas';
 $string['courses_sum_grade'] = 'Resumo de Notas da Disciplina pela Escala de Valor';
 $string['grades'] = 'Notas';
 $string['messages'] = 'Menssagens';
 $string['x_completions'] = '{$a} Conclusões';
 $string['completion_status'] = 'Estado de Conclusão';
 $string['users_activity'] = 'Atividade do Usuário';
 $string['daily'] = 'Últimos 10 dias';
 $string['weekly'] = 'Últimos 90 dias';
 $string['monthly'] = 'Últimos 365 dias';
 $string['number_of_sessions'] = 'Número de Sessões';
 $string['number_today'] = '{$a} Hoje';
 $string['number_this_week'] = '{$a} Nessa semana';
 $string['course_completions'] = 'Conclusão de Disciplinas';
 $string['user_enrolments'] = 'Inscrições do utilizador';
 $string['users'] = 'Utilizadores';
 $string['modules'] = 'Módulos';
 $string['categories'] = 'Categorias';
 $string['total'] = 'Total';
 $string['users_overview'] = 'Visão geral do utilizador';
 $string['enable_time_and_visits_users_overview'] = 'Ativar o tempo dispensado e as visitas na visão geral do utilizador';
 $string['disable_time_and_visits_users_overview'] = 'Desativar o tempo dispensado e as visitas na visão geral do utilizador';
 $string['loading'] = 'Carregando...';
 $string['loading2'] = 'Por favor espere, carregando...';
 $string['enrollments'] = 'Inscrições';
 $string['registrations'] = 'Registros';
 $string['participation'] = 'Participação';
 $string['time'] = 'Tempo';
 $string['enrolment_method'] = 'Método de Inscrição';
 $string['intelliBoard_migration_tool'] = 'Ferramenta de Migração do IntelliBoard';
 $string['importing_totals'] = 'Importando totais';
 $string['total_numbers'] = 'Data: {$a->timepoint}, Sessões: {$a->sessions}, Visitas: {$a->visits},  Tempo passado: {$a->timespend}';
 $string['total_numbers2'] = 'Utilizador: {$a->userid}, Página: {$a->page}, Parâmetro:{$a->param}, Visitas: {$a->visits},  Tempo passado: {$a->timespend}';
 $string['total_numbers3'] = '----Data: {$a->timecreated}, Rastreio da ID: {$a->trackid}, Visitas: {$a->visits},  Tempo passado: {$a->timespend}';
 $string['logs_to_process'] = 'Registros para processar {$a}';
 $string['please_wait_or_cancel'] = 'Por favor espere para continuar ou <a href="{$a}">Cancel</a>';
 $string['done'] = 'Pronto!';
 $string['return_to_home'] = 'Voltar para Página Inicial';
 $string['importing_logs'] = 'Importando registros';
 $string['intelliBoard_migration_tool_info'] = 'A ferramenta de migração do IntelliBoard é usada para migrar o historial de dados da tabela de registros do Moodle para um novo formato. Por favor, note que o procedimento de armazenamento de registros do Moodle não será alterado. Depois que os dados históricos forem migrados para o novo formato, os valores históricos como Tempo Dispensado e \ Visitas estarão disponíveis para visualização no IntelliBoard.net.';
 $string['moodle_logs'] = 'Registros do Moodle';
 $string['intelliboard_tracking'] = 'Rastreio IntelliBoard';
 $string['intelliboard_logs'] = 'Registros IntelliBoard';
 $string['intelliboard_totals'] = 'Totais IntelliBoard';
 $string['intelliboard_start_tracking'] = 'Inciar Rastreio IntelliBoard';
 $string['total_values_include'] = 'Valores Totais incluem sessões exclusivas, Disciplinas, visitas, tempo dispensado.';
 $string['items_per_query'] = 'Itens por consulta';
 $string['import'] = 'Importar';
 $string['log_values_include'] = 'Valores de login incluem login por cada usuário diariamente.';
 $string['powered_by'] = 'Distribuído por <a href="https://intelliboard.net/">IntelliBoard.net</a>';
 $string['intelliboardnet'] = 'IntelliBoard.net';
 $string['visits'] = 'Visitas';
 $string['registered'] = 'Registrado';
 $string['disabled'] = 'Desativado';
 $string['enrolled_completed'] = 'Inscrito: {$a->courses}, Concluído: {$a->completed_courses}';
 $string['enrolled_users_completed'] = 'Utilizadores inscritos: {$a->users}, Concluído: {$a->completed}';
 $string['user_grade_avg'] = '{$a->user} nota: {$a->grade}, Nota média: {$a->avg_grade_site})';
 $string['user_visit_avg'] = '{$a->user} visitas: {$a->visits}, Número médio de Visitas: {$a->avg_visits_site}';
 $string['user_time_avg'] = '{$a->user} tempo: {$a->timespend}, Tempo médio: {$a->avg_timespend_site}';
 $string['more_users'] = 'Mais utilizadores';
 $string['more_courses'] = 'Mais Disciplinas';
 $string['showing_1_to_10'] = 'Mostrando de 1 a 10';
 $string['course_grade'] = 'Nota da Disciplina';
 $string['completed_activities_resourses'] = 'Atividades/Recursos concluídos';
 $string['save'] = 'Salvar';
 $string['help'] = 'Precisa de ajuda?';
 $string['in1'] = 'Visão Geral';
 $string['in2'] = 'Progresso Atual';
 $string['in3'] = 'Total de Disciplinas';
 $string['in4'] = 'Total de Estudantes';
 $string['in5'] = 'Total de Notas em Disciplinas';
 $string['in6'] = 'Estudantes Completos';
 $string['in7'] = 'Learners Incompletos';
 $string['in8'] = 'Nota Média do Estudante';
 $string['in9'] = 'Correlações';
 $string['in10'] = 'Utilização do Evento';
 $string['in11'] = 'Progresso do Estudante';
 $string['in12'] = 'Evolução da Nota';
 $string['in13'] = 'Tempo Dispensado (%)';
 $string['in14'] = '% Progresso';
 $string['in15'] = 'Conclusões do Estudante';
 $string['in16'] = 'Último Acesso';
 $string['in17'] = 'Total de tempo dispensado';
 $string['in18'] = 'Total de visitas';
 $string['in19'] = 'Nota Média';
 $string['in20'] = 'Voltar a Estudantes';
 $string['in201'] = 'Voltar a Atividades';
 $string['in21'] = 'Nota Média da Disciplina';
 $string['in22'] = 'Ativado';
 $string['in23'] = 'Você não tem alunos para exibir.';
 $string['in24'] = 'Módulo';
 $string['in25'] = 'Nota Mínima';
 $string['in26'] = 'Envolvimento do Estudante';
 $string['in34'] = 'Evolução da Nota do Estudante';
 $string['in27'] = 'Total de Estudantes';
 $string['in28'] = 'Tempo Médio Dispensado';
 $string['in29'] = 'Estudantes Ativos';
 $string['in30'] = 'Estudantes Inativos';
 $string['in31'] = 'Utilização da atividade';
 $string['in32'] = 'Tempo médio no período selecionado';
 $string['in33'] = 'Utilização do Tópico';
 $string['status'] = 'Estado';
 $string['course_category'] = 'Categoria da Disciplina';
 $string['course_started'] = 'Disciplina Iniciada';
 $string['total_time_spent_enrolled_learners'] = 'Tempo total Dispensado por alunos inscritos na Disciplina';
 $string['total_visits_enrolled_learners'] = 'Total de Visitas de Alunos Inscritos na Disciplina';
 $string['learners_enrolled'] = 'Estudantes Inscritos';
 $string['learners_enrolled_period'] = 'Alunos matriculados no período selecionado';
 $string['learning_progress'] = 'Progresso do Aluno';
 $string['sections'] = 'Seções';
 $string['section'] = 'Seção';
 $string['total_activities_resources'] = 'Total de Atividades/Recursos';
 $string['completions'] = 'Conclusões';
 $string['return_to_courses'] = 'Voltar a Disciplinas';
 $string['click_link_below_support_pages'] = 'Clique no link abaixo para acessar as páginas de suporte do IntelliBoard:';
 $string['support'] = 'Suporte';
 $string['course_name'] = 'Nome da Disciplina';
 $string['enrolled_completed_learners'] = 'Alunos matriculados/concluídos';
 $string['activities_resources'] = 'Atividades/Recursos';
 $string['actions'] = 'Ações';
 $string['learner_name'] = 'Nome do Estudante';
 $string['completed_activities_resources'] = 'Atividades/Recursos concluídos';
 $string['filter_dates'] = 'Filtrar datas:';
 $string['select_date'] = 'Selecionar data';
 $string['select'] = 'Selecionar';
 $string['selectall'] = 'Selecionar TUDO';
 $string['ok'] = 'OK';
 $string['moodle'] = 'Moodle';
 $string['totara'] = 'Totara';
 $string['monitors'] = 'Indicadores';
 $string['cohorts'] = 'Agrupamentos';
 $string['course_overview'] = 'Visão Geral da Disciplina';
 $string['topics'] = 'Tópicos';
 $string['a31'] = 'Quadros';
 $string['a32'] = 'Plano de Ensino';
 $string['a33'] = 'Classificado, Apto';
 $string['a34'] = 'Classificado, Inapto';
 $string['a35'] = 'Não classificado';
 $string['a36'] = 'Visão Geral de Competências';
 $string['a37'] = 'Competência não foi criada. Entre em contato com o administrador do sistema.';
 $string['a38'] = 'Disciplinas Vinculadas a Competências';
 $string['a39'] = 'Total de Competências';
 $string['a40'] = 'Disciplinas Vinculadas';
 $string['no_competency'] = 'Parece que você não tem competências habilitadas em seu site Moodle.';
 $string['scalesettings'] = 'Configurações de escala';
 $string['scales'] = 'Ativar escala personalizada';
 $string['scale_raw'] = 'Desativar escala';
 $string['scale_real'] = 'Mostrar nota real em vez de porcentagem';
 $string['scale_total'] = 'Nota Total';
 $string['scale_value'] = 'Valor';
 $string['scale_percentage'] = 'Porcentagem';
 $string['a0'] = 'Visão Geral de Competências';
 $string['a1'] = 'Competências';
 $string['a2'] = 'Proficiência';
 $string['a3'] = 'Atividades Atribuídas';
 $string['a4'] = 'Evolução da Proficiência';
 $string['a5'] = 'Competências Avaliadas';
 $string['a6'] = '# Evidências';
 $string['a7'] = 'Estudantes avaliados';
 $string['a8'] = 'Progresso';
 $string['a9'] = 'Estudantes Aptos';
 $string['a10'] = 'Estudantes inscritos';
 $string['a11'] = 'Lista de competências atribuídas a Disciplina';
 $string['a12'] = 'Estado do Estudante';
 $string['a13'] = 'Nome da Competência';
 $string['a14'] = 'Criado em';
 $string['a15'] = 'Atribuído em';
 $string['a16'] = 'Apto indicado';
 $string['a17'] = 'Avaliação';
 $string['a18'] = 'Apto em Competências';
 $string['a19'] = 'Data de classificação da competência';
 $string['a20'] = 'Avaliador da competência';
 $string['a21'] = 'Atividades Atribuídas';
 $string['a22'] = 'Proficiência alcançada';
 $string['a23'] = 'Competências Avaliadas';
 $string['a24'] = '# Evidências';
 $string['a25'] = 'Estudantes concluídos';
 $string['a27'] = ' fora de ';
 $string['a28'] = 'Detalhes';
 $string['a29'] = 'Ativar Visão Geral de Competências';
 $string['a30'] = 'Ativar Relatórios de Competências';
 $string['a26'] = 'Esta tabela exibe o número de competências atribuídas a uma Disciplina, alunos que foram classificados (sejam aptos ou não) e alunos que foram designados aptos na competência.';
 $string['s25'] = 'Tempo dispensado na Atividade';
 $string['s45'] = 'Atividade';
 $string['s46'] = 'Porcentagem de estudantes tentando';
 $string['s47'] = 'Tópico';
 $string['s48'] = 'Tempo passado no tópico';
 $string['completions'] = 'Status de conclusão da atividade';
 $string['completions_completed'] = 'Status de conclusão (concluído)';
 $string['completions_pass'] = 'Status de conclusão (aprovado)';
 $string['completions_fail'] = 'Status de conclusão (reprovado)';
 $string['completions_desc'] = '1) O usuário concluiu esta atividade. Não é especificado se aprovou ou reprovou. <br>
 2) O usuário concluiu essa atividade com uma nota acima da nota mínima para aprovar. <br>
 3) O usuário concluiu essa atividade, mas a sua nota é inferior à nota mínima para aprovar.';
 $string['widget_name27'] = "Inscrições cumulativas";
 $string['widget_name28'] = "Envolvimento";
 $string['widget_name29'] = "Logins exclusivos";
 $string['widget_name30'] = "Inscrições por Disciplina";
 $string['widget_name31'] = "Registradores & Supervisor";
 $string['role1'] = "Primeira função";
 $string['role2'] = "Segunda função";
 $string['select_course'] = "Selecionar Disciplina";
 $string['select_quiz'] = "Selecionar quiz";
 $string['not_quiz'] = "Ops, parece que você não tem nenhum teste criado para a Disciplina selecionada.";
 $string['enter_course_and_quiz'] = "Por favor, selecione a sua Disciplina e Teste.";
 $string['enter_quiz'] = "Por favor selecione o seu quiz.";
 $string['analityc_3_name'] = "Visão Geral do Quiz & Detalhe da Questão";
 $string['course_name_a'] = 'Disciplina: {$a}';
 $string['quiz_name_a'] = 'Quiz: {$a}';
 $string['cor_incor_answers'] = 'Respostas Correto/Incorreto';
 $string['quiz_finished'] = 'Quiz Finalizado';
 $string['quiz_grades'] = 'Notas do Quiz';
 $string['correct_number'] = 'Correto {$a}';
 $string['incorrect_number'] = 'Incorreto {$a}';
 $string['correct'] = 'Correto';
 $string['incorrect'] = 'Incorreto';
 $string['weekday_0'] = "Segunda-Feira";
 $string['weekday_1'] = "Terça-Feira";
 $string['weekday_2'] = "Quarta-Feira";
 $string['weekday_3'] = "Quinta-Feira";
 $string['weekday_4'] = "Sexta-Feira";
 $string['weekday_5'] = "Sábado";
 $string['weekday_6'] = "Domingo";
 $string['time_1'] = "Manhã";
 $string['time_2'] = "Tarde";
 $string['time_3'] = "Noite";
 $string['time_4'] = "Fora de Hora";
 $string['passing_score_for'] = 'Nota mínima para aprovar {$a}';
 $string['name'] = 'Nome';
 $string['answers'] = 'Respostas';
 $string['ques_breakdown'] = 'Discrição da Pergunta';
 $string['n17'] = 'Página de Analítica';
 $string['analytics'] = 'Analítica';
 $string['pdf'] = 'PDF';
 $string['csv'] = 'CSV';
 $string['excel'] = 'Excel';
 $string['grades_alt_text'] = 'Texto alternativo para o menu de navegação';
 $string['course_chart'] = 'Ativar gráfico da Disciplina';
 $string['course_activities'] = 'Ativar atividades da Disciplina';
 $string['filter_this_year'] = 'Filtro de tempo: este ano';
 $string['filter_last_year'] = 'Filtro de tempo: ano passado';
 $string['this_year'] = 'Este ano';
 $string['last_year'] = 'Ano passado';
 $string['reportselect'] = 'Por favor, selecione pelo menos um relatório da App.IntelliBoard.net. Clique em um Relatório, depois em Configurações do Relatório e selecione-o em "Visivel no Moodle".';
 $string['monitorselect'] = 'Por favor, selecione pelo menos um monitor da App.IntelliBoard.net. Clique em Monitores, depois em Configurações de monitores e selecione-o em "Visivel no Moodle".';
 $string['select_user'] = 'Selecionar Utilizador';
 $string['course_max_grade'] = 'Nota máxima da Disciplina';
 $string['no_data_notification'] = 'Não há novos dados para [date]';
 $string['last_hour'] = 'hora';
 $string['last_day'] = 'dia';
 $string['privacy:metadata:local_intelliboard_assign'] = 'Tabela de subcontas atribuídas à Intelliboard';
 $string['privacy:metadata:local_intelliboard_details'] = 'Tabela Intelliboard alt/logs/por hora';
 $string['privacy:metadata:local_intelliboard_logs'] = 'Tabela Intelliboard alt/logs/por dia';
 $string['privacy:metadata:local_intelliboard_totals'] = 'Tabela Total Intelliboard alt / logs ';
 $string['privacy:metadata:local_intelliboard_tracking'] = 'Tabela de todo-o-tempo Intelliboard alt/logs ';
 $string['privacy:metadata:local_intelliboard_reports'] = 'Tabela de relatórios SQL personalizados Intelliboard';
 $string['privacy:metadata:local_intelliboard_ntf'] = 'Tabela principal de notificações do Intelliboard';
 $string['privacy:metadata:local_intelliboard_ntf_hst'] = 'Tabela de histórico de notificações do Intelliboard';
 $string['privacy:metadata:local_intelliboard_ntf_pms'] = 'Tabela de parâmetros dinâmicos de notificações Intelliboard';
 $string['privacy:metadata:local_intelliboard_assign:userid'] = 'ID do USUÁRIO do registro';
 $string['privacy:metadata:local_intelliboard_assign:rel'] = 'Tipo de registro';
 $string['privacy:metadata:local_intelliboard_assign:type'] = 'Tipo de instância do Moodle';
 $string['privacy:metadata:local_intelliboard_assign:instance'] = 'ID de Instância do Moodle Conectado';
 $string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'Registro de data e hora';
 $string['privacy:metadata:local_intelliboard_reports:status'] = 'Status do relatório - ativado / desativado';
 $string['privacy:metadata:local_intelliboard_reports:name'] = 'Nome do relatório personalizado';
 $string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'Código SQL codificado em BASE64';
 $string['privacy:metadata:local_intelliboard_reports:timecreated'] = 'Tempo de criação';
 $string['privacy:metadata:local_intelliboard_details:logid'] = 'ID da tabela [local_intelliboard_logs]';
 $string['privacy:metadata:local_intelliboard_details:visits'] = 'O número de visitas, cliques do mouse, por dia';
 $string['privacy:metadata:local_intelliboard_details:timespend'] = 'A quantidade de tempo dispensado por hora';
 $string['privacy:metadata:local_intelliboard_details:timepoint'] = 'A hora';
 $string['privacy:metadata:local_intelliboard_logs:trackid'] = 'O ID da tabela [local_intelliboard_tracking]';
 $string['privacy:metadata:local_intelliboard_logs:visits'] = 'Visitas, cliques do mouse, por dia';
 $string['privacy:metadata:local_intelliboard_logs:timespend'] = 'Tempo Dispensado, por dia';
 $string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'Registro do dia no ano';
 $string['privacy:metadata:local_intelliboard_totals:sessions'] = 'Número Total de Sessões de Utilizadores no Moodle';
 $string['privacy:metadata:local_intelliboard_totals:courses'] = 'Total de Disciplinas no Moodle';
 $string['privacy:metadata:local_intelliboard_totals:visits'] = 'Total de visitas de todos os usuários no Moodle';
 $string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Tempo total dispensado por usuários no Moodle';
 $string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'Registro do dia no ano';
 $string['privacy:metadata:local_intelliboard_tracking:userid'] = 'ID de utilizador que visita a página do Moodle.';
 $string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'ID da Disciplina que o utilizador visita';
 $string['privacy:metadata:local_intelliboard_tracking:page'] = 'Tipo de página [course,module,profile,site]';
 $string['privacy:metadata:local_intelliboard_tracking:param'] = 'Tipo de ID de página';
 $string['privacy:metadata:local_intelliboard_tracking:visits'] = 'Visitas de usuários na página';
 $string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'Tempo Dispensado pelo utilizador na página';
 $string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'Primeiro acesso dos utilizadores';
 $string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'Último acesso dos usuários';
 $string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'Tipo de Navegador dos Usuários';
 $string['privacy:metadata:local_intelliboard_tracking:useros'] = 'Sistema Operacional dos Usuários';
 $string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'Língua do navegador dos Usuários';
 $string['privacy:metadata:local_intelliboard_tracking:userip'] = 'Último endereço IP dos usuários';
 $string['privacy:metadata:local_intelliboard_ntf:id'] = 'ID de notificação';
 $string['privacy:metadata:local_intelliboard_ntf:type'] = 'Tipo de notificação';
 $string['privacy:metadata:local_intelliboard_ntf:externalid'] = 'Notificação de ID externo';
 $string['privacy:metadata:local_intelliboard_ntf:userid'] = 'Notificação de App ID externo';
 $string['privacy:metadata:local_intelliboard_ntf:email'] = 'Email de notificação';
 $string['privacy:metadata:local_intelliboard_ntf:cc'] = 'CC de notificação';
 $string['privacy:metadata:local_intelliboard_ntf:subject'] = 'Assunto de notificação';
 $string['privacy:metadata:local_intelliboard_ntf:message'] = 'Mensagem de notificação';
 $string['privacy:metadata:local_intelliboard_ntf:state'] = 'Estado de notificação';
 $string['privacy:metadata:local_intelliboard_ntf:attachment'] = 'Anexos de notificação';
 $string['privacy:metadata:local_intelliboard_ntf:tags'] = 'Tags de notificação';
 $string['privacy:metadata:local_intelliboard_ntf_hst:id'] = 'Histórico de ID de notificação';
 $string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = 'ID de notificação';
 $string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = 'Notificação de App ID externo';
 $string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = 'Nome da notificação';
 $string['privacy:metadata:local_intelliboard_ntf_hst:email'] = 'Email do histórico de notificações';
 $string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = 'Registro do histórico de notificações';
 $string['select_manager_role'] = 'Selecione a função de gestor';
 $string['group_aggregation'] = 'Agregação de grupo';
 $string['ssodomain'] = 'Subdomínio SSO';
 $string['ssodomain_desc'] = 'Logon único (SSO) com separados servidor/conta';
 $string['instructor_redirect'] = 'Redirecionamento do instrutor';
 $string['student_redirect'] = 'Redirecionamento do Estudante';
 $string['myorders'] = 'Ordens';
 $string['myseats'] = 'Lugares';
 $string['mywaitlist'] = 'Lista de Espera';
 $string['mysubscriptions'] = 'Inscrições';
 $string['seatscode'] = 'Código do Lugar';
 $string['numberofseats'] = 'Número de lugares';
 $string['downloadinvoice'] = 'Fazer download da fatura';
 $string['product'] = 'Produto';
 $string['key'] = 'Chave';
 $string['created'] = 'Criado';
 $string['seatnumber'] = 'Número de lugares';
 $string['seatsused'] = 'Lugar ocupado';
 $string['details'] = 'Detalhes';
 $string['username'] = 'Nome do utilizador';
 $string['used'] = 'Ocupado';
 $string['status'] = 'Status';
 $string['subscriptiondate'] = 'Data de Inscrição';
 $string['price'] = 'Preço';
 $string['recurringperiod'] = 'Período Recorrente';
 $string['billingcycles'] = 'Ciclos de faturamento';
 $string['active'] = 'Ativo';
 $string['suspended'] = 'Suspenso';
 $string['canceled'] = 'Cancelado';
 $string['expired'] = 'Expirado';
 $string['process'] = 'Processo';
 $string['cancel_subscription'] = 'Cancelar assinatura';
 $string['sqlreport'] = 'Relatório do SQL';
 $string['sqlreportcreate'] = 'Criar Relatório';
 $string['sqlreports'] = 'Relatórios do SQL';
 $string['sqlreportname'] = 'Nome do Relatório';
 $string['sqlreportcode'] = 'SQL';
 $string['sqlreportdate'] = 'Criado em';
 $string['sqlreportactive'] = 'Ativado';
 $string['sqlreportinactive'] = 'Desativado';
 $string['remove_message'] = 'Relatório do SQL foi excluído';
 $string['delete_message'] = 'Excluir Relatório do SQL?';
 $string['success_message'] = 'Relatório do SQL foi salvo';
 $string['scale_percentage_round'] = 'Rodada de porcentagem';
 // BigBlueButton meetings
 $string['bbbapiendpoint'] = 'Ponto final da API BBB';
 $string['bbbserversecret'] = 'Segredo do servidor BBB';
 $string['check_active_meetings'] = 'Verifique as reuniões ativas';
 $string['bbbmeetings'] = 'Reuniões BigBlueButton';
 $string['enablebbbmeetings'] = 'Ativar o monitoramento de reuniões do BigBlueButton';
 $string['privacy:metadata:local_intelliboard_bbb_meet'] = 'Registro sobre as reuniões do BigBlueButton';
 $string['privacy:metadata:local_intelliboard_bbb_meet:id'] = 'ID do registro de reunião';
 $string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = 'Nome da Reunião';
 $string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'ID da Reunião';
 $string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = 'ID de reunião interna (no servidor BBB)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = 'Criar hora (registro)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = 'Criar data (string)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = 'O número de ramal de voz (use se estiver conectado ao sistema de telefone)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = 'O número de acesso para o qual os participantes podem ligar usando o telefone.';
 $string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = 'A senha que será necessária para que os participantes enrem na reunião';
 $string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = 'A senha que será necessária para que os moderadores entrem na reunião ou para determinadas ações administrativas';
 $string['privacy:metadata:local_intelliboard_bbb_meet:running'] = 'Status da reunião (ativo | parado)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = 'Duração da reunião';
 $string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = 'Atenção. Usuários entraram na reunião';
 $string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = 'Atenção. A reunião será gravada';
 $string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = 'Atenção. A reunião foi interrompida';
 $string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = 'Hora de Início da Reunião';
 $string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = 'End time of meeting';
 $string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = 'Número de participantes';
 $string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'Número de ouvintes';
 $string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'Número de participantes com o microfone conectado';
 $string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'Número de participantes com a câmera ligada';
 $string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = 'Número máximo de participantes';
 $string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'Número de Moderadores';
 $string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'ID da Disciplina';
 $string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'ID do módulo de Disciplinas';
 $string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'ID da linha na tabela bigbluebuttonbn';
 $string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = 'ID do proprietário (usuário que criou a reunião)';
 $string['privacy:metadata:local_intelliboard_bbb_atten'] = 'Registros sobre os participantes das reuniões do BigBlueButton';
 $string['privacy:metadata:local_intelliboard_bbb_atten:id'] = 'ID do participante';
 $string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'ID do usuário (linha na tabela "usuário")';
 $string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = 'Nome completo do participante da reunião';
 $string['privacy:metadata:local_intelliboard_bbb_atten:role'] = 'Papel do participante de reunião';
 $string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = 'Atenção. O participante é o apresentador';
 $string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = 'Atenção. O participante não tem microfone ou webcam conectado';
 $string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = 'Atenção. O participante conectou o microfone';
 $string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = 'Atenção. O participante conectou a webcam';
 $string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = 'ID da reunião (ID no servidor BigBlueButton)';
 $string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = 'ID da reunião (ID na tabela local_intelliboard_bbb_meet)';
 $string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'Hora quando o usuário se conectou a reunião';
 $string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'Hora quando o usuário se desconectou da reunião';

 $string['privacy:metadata:local_intelliboard_bb_partic'] = 'Lista de participantes na sessão collaborate';
 $string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'ID da participação na sessão';
 $string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'UUID da Sessão';
 $string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'User UUID (BlackBoard Collaborate service)';
 $string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'ID de Usuário (Moodle)';
 $string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'Papel na sessão';
 $string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'Nome de Usuário';
 $string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'Primeiro acesso a sessão';
 $string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'Último saindo da sessão';
 $string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'Tempo dispensado na sessão';
 $string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'Número de participantes na sessão';

 $string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'Lista de sessões rastreadas';
 $string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'ID do log do rastreamento';
 $string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'Session UUID';
 $string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = 'Tempo de rastreamento';

 $string['privacy:metadata:local_intelliboard_att_sync'] = 'Lista de sessões sincronizadas';
 $string['privacy:metadata:local_intelliboard_att_sync:id'] = 'ID do log de sincronização';
 $string['privacy:metadata:local_intelliboard_att_sync:type'] = 'Tipo de Sessão';
 $string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'ID da sessão do Moodle';
 $string['privacy:metadata:local_intelliboard_att_sync:data'] = 'Dados de sincronização adicionais';

 $string['messageprovider:intelliboard_notification'] = "Notificação Intelliboard";
 $string['verifypeer'] = "CURLOPT SSL VERIFYPEER";
 $string['verifypeer_desc'] = "Esta opção determina se o curl verifica a autenticidade do certificado do mesmo.";
 $string['verifyhost'] = "CURLOPT SSL VERIFYHOST";
 $string['verifyhost_desc'] = "Esta opção determina se o libcurl verifica se o certificado do servidor é para o servidor que é conhecido como.";
 $string['cipherlist'] = "CURLOPT SSL CIPHER LIST";
 $string['cipherlist_desc'] = "Especifique as cifras a serem usadas para o TLS";
 $string['sslversion'] = "CURLOPT SSLVERSION";
 $string['sslversion_desc'] = "Passar um longo como parâmetro para controlar qual o intervalo de versões de versões SSL / TLS para uso";
 $string['debug'] = "Debug CURL requests";
 $string['debug_desc'] = "";
 /* IntelliCart */
 $string['intellicart'] = "Integração IntelliCart";
 $string['intellicart_desc'] = "Permita que os alunos vejam os relatórios do IntelliCart.";
 $string['coursessessionspage'] = "Página de Sessões de Disciplinas";
 $string['coursessessions'] = "Sessões de Disciplinas";
 $string['session_name'] = "Nome da sessão";
 $string['session_time'] = "Tempo de sessão";
 $string['return_to_sessions'] = "Voltar para Sessões";
 $string['intellicart_student_integration'] = 'Integration with Student Dashboard';
 $string['intellicart_instructor_integration'] = 'Integration with Instructor Dashboard';
 $string['intellicart_app_reports_integration'] = 'Integration with IntelliBoard Reports';
 /* IntelliCart END*/
 $string['allmod'] = "Todas as atividades";
 $string['customod'] = "Atividades personalizadas";
 $string['timespent'] = "------ Tempo Dispensado ----";
 $string['inprogress'] = "Em progresso";
 $string['notstarted'] = "Não iniciado";
 $string['modulename'] = "Nome do módulo";
 $string['viewed'] = "Visto";
 $string['course'] = "Disciplina";
 $string['courseaverage'] = "Média da Disciplina";
 $string['mygrade'] = "Minha Nota";
 $string['myprogress'] = "Progresso da minha nota";
 $string['instructor_course_shortname'] = "Mostrar nome abreviado da Disciplina em vez do nome completo da Disciplina";
 $string['trackmedia'] = "Acompanhar mídia HTML5";
 $string['trackmedia_desc'] = "Acompanhe vídeo e áudio em HTML5";
 $string['ianalytics'] = 'Analítica IntelliBoard';

 $string['instructor_course_visibility'] = 'Mostrar disciplinas ocultas / suspensas para [instructor]';
 $string['instructor_mode'] = 'Mostrar todas as disciplinas disponíveis para [instructor]';
 $string['instructor_mode_access'] = 'Mostrar todas as disciplinas disponíveis para [instructor] com permissões [update]';
 $string['student_course_visibility'] = 'Mostrar disciplinas ocultas/suspensas para [student]';


 $string['support_text1'] = "Todos os seus dados do Moodle: fáceis, compartilháveis, compreensíveis e atraentes. O IntelliBoard é um plugin do Moodle que coloca <strong>120+</strong> relatórios e monitores nas suas mãos.";
 $string['support_text2'] = "Todos os seus dados do Moodle: fáceis, compartilháveis, compreensíveis e atraentes. O IntelliBoard é a sua solução de relatórios e análises do Moodle, oferecendo mais de 120 relatórios e análises para ajudar a informar suas decisões de negócios educacionais.";
 $string['support_info1'] = "Você pode se juntar aos nossos <a target='_blank' href='https://intelliboard.net/events'>Webinars</a> enquanto nós o levamos a um passeio pelos relatórios e análises do IntelliBoard 5.0!";
 $string['support_info2'] = "Junte-se aos nossos <a target='_blank' href='https://intelliboard.net/events'>Webinars</a>, ou agende um tour pessoal de seus próprios dados. Com nosso suporte e serviços a nível global, você verá seu LMS sob um prisma totalmente novo.";
 $string['support_terms'] = "Todos os direitos reservados.";
 $string['support_page'] = "Página de Suporte";
 $string['support_demo'] = "Agende uma demonstração em Português";
 $string['support_trial'] = "Comece um teste";
 $string['support_close'] = "Fechar";

 $string['instructor_custom_groups'] = "Grupos personalizados do instrutor";
 $string['instructor_show_suspended_enrollments'] = 'Show suspended enrollments';
 $string['instructor_hide_suspended_enrollments'] = 'Hide suspended enrollments';

 // settings of tables
 $string['show_dashboard_tab'] = 'Mostrar aba da dashboard';
 $string['table_set_icg'] = 'Tabela do instrutor "Notas da Disciplina"';
 $string['table_set_icg_c1'] = 'Nome da Disciplina';
 $string['table_set_icg_c2'] = 'Nome curto da Disciplina';
 $string['table_set_icg_c3'] = 'Categoria';
 $string['table_set_icg_c4'] = 'Alunos inscritos / que concluíram';
 $string['table_set_icg_c5'] = 'Nota média da Disciplina';
 $string['table_set_icg_c6'] = 'Sessões';
 $string['table_set_icg_c7'] = 'Atividades/Recursos';
 $string['table_set_icg_c8'] = 'Visitas';
 $string['table_set_icg_c9'] = 'Tempo Dispensado';
 $string['table_set_icg_c11'] = 'Ações – Atividades';
 $string['table_set_icg_c12'] = 'Ações – Estudante';
 $string['percentage_completed_learners'] = 'Porcentagem de estudantes que concluíram';
 $string['avg_visits_per_stud'] = 'Número médio de visitas por estudante';
 $string['avg_time_spent_per_stud'] = 'Tempo médio dispensado por estudante';

 $string['table_set_ilg'] = 'Tabela do instrutor "Notas dos alunos"';
 $string['table_set_ilg_c1'] = 'Nome do Estudante';
 $string['table_set_ilg_c2'] = 'Email';
 $string['table_set_ilg_c3'] = 'Inscrito';
 $string['table_set_ilg_c4'] = 'Último Acesso';
 $string['table_set_ilg_c5'] = 'Status';
 $string['table_set_ilg_c6'] = 'Nota';
 $string['table_set_ilg_c7'] = 'Atividades/Recursos concluídos';
 $string['table_set_ilg_c8'] = 'Visitas';
 $string['table_set_ilg_c9'] = 'Tempo Dispensado';
 $string['table_set_ilg_c10'] = 'Ações';

 $string['table_set_ilg1'] = 'Tabela do instrutor "Notas dos alunos"';
 $string['table_set_ilg1_c1'] = 'Nome da Atividade';
 $string['table_set_ilg1_c2'] = 'Tipo';
 $string['table_set_ilg1_c3'] = 'Nota';
 $string['table_set_ilg1_c4'] = 'Classificado';
 $string['table_set_ilg1_c5'] = 'Status';
 $string['table_set_ilg1_c6'] = 'Visitas';
 $string['table_set_ilg1_c7'] = 'Tempo Dispensado';

 $string['table_set_iag'] = 'Tabela do instrutor "Notas de atividades"';
 $string['table_set_iag_c1'] = 'Nome da Atividade';
 $string['table_set_iag_c2'] = 'Tipo';
 $string['table_set_iag_c3'] = 'Estudantes que concluíram';
 $string['table_set_iag_c4'] = 'Nota média';
 $string['table_set_iag_c5'] = 'Visitas';
 $string['table_set_iag_c6'] = 'Tempo Dispensado';
 $string['table_set_iag_c7'] = 'Ações';

 $string['table_set_iag1'] = 'Tabela do instrutor "Notas de atividades"';
 $string['table_set_iag1_c1'] = 'Nome do Estudante';
 $string['table_set_iag1_c2'] = 'Email';
 $string['table_set_iag1_c3'] = 'Status';
 $string['table_set_iag1_c4'] = 'Nota';
 $string['table_set_iag1_c5'] = 'Classificação';
 $string['table_set_iag1_c6'] = 'Visitas';
 $string['table_set_iag1_c7'] = 'Tempo Dispensado';
 $string['grade_activities_overview'] = 'Visão geral das Atividades Classificadas';
 $string['activity'] = 'Atividades';
 $string['date_format'] = 'Formato da data';
 $string['user_enrollments_sessions_completion'] = 'Níveis de atividade de inscrição, sessão e andamento';
 $string['user_site_summary_detail'] = 'Resumo detalhado de uso do site';
 $string['course_enrollment_types'] = 'Tipos de inscrição na Disciplina';
 $string['user_map'] = 'Mapa de usuários';
 $string['course_enrollments_with_completion_overview'] = 'Inscrição em Disciplinas com visão geral de conclusão';
$string['intelliboard:attendanceadmin'] = "Attendance Admin";
$string['enablebbbdebug'] = "BigBlueButton debug mode";
$string['student_grades'] = "Student grades";
$string['grid_view'] = "Grid view";
$string['list_view'] = "List view";
$string['all_modules'] = 'All modules';

 /* Attendance */
 $string['attendance'] = 'Frequência';
 $string['enableattendance'] = 'Ativar Frequência';
 $string['attendancetoolurl'] = 'URL da funcionalidade';
 $string['attendanceconsumerkey'] = 'Chave do Consumidor';
 $string['attendancesharedsecret'] = 'Segredo Compartilhado';
 $string['sync_data_with_attendance'] = 'Sincronizar dados com Frequência';
 $string['attendanceapibase'] = 'Frequência caminho base do API';
 $string['attendanceapikey'] = 'Frequência chave API';
 $string['attendanceapisecret'] = 'Segredo API da Frequência';
 $string['enablesyncattendance'] = 'Ativar sessões do BB Collaborate sincronizando com InAttendance';

 /* BlackBoard Collaborate and InAttendance */
 $string['bb_col_meetings'] = 'Reuniões BlackBoard Collaborate';
 $string['enable_bb_col_debug'] = 'Ativar BlackBoard Collaborate debug';
 $string['bb_col_api_endpoint'] = 'BlackBoard Collaborate API endpoint';
 $string['bb_col_consumer_key'] = 'BlackBoard Collaborate chave do consumidor';
 $string['bb_col_secret'] = 'Segredo do BlackBoard Collaborate';
 $string['enable_bb_col_meetings'] = 'Ativar reuniões do BlackBoard Collaborate';
 $string['check_active_bb_col_meetings'] = 'Check active BlackBoard Collaborate meeting';
 $string['local_intelliboard_bb_collaborate_session_tracking_started'] = 'Started tracking of BB collaborate session';
 $string['local_intelliboard_bb_collaborate_session_tracking_finished'] = 'Finished tracking of BB collaborate session';
 $string['local_intelliboard_bb_collaborate_api_request_finished'] = 'Finished API request to BB collaborate';

/* Admin dashboard */
$string['admin_dashboard'] = 'Admin dashboard';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'User Enrollment, Session, Completion Activity Levels';
$string['adm_dshb_adm_dashb_totals'] = 'Totals';
$string['adm_dshb_user_site_summary_details'] = 'User Site Summary Detail';
$string['adm_dshb_course_enrollments_types'] = 'Course Enrollment Types';
$string['adm_dshb_user_map'] = 'User Map';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'Course Enrollments with Completion Overview';
$string['adm_dshb_report_user_status'] = 'Report User status';
$string['adm_dshb_report_activity_stats_summary'] = 'Report Activity Stats Summary';
$string['adm_dshb_report_quiz_activity_detail'] = 'Report Quiz Activity Detail';

$string['instructor_hide_need_help'] = 'Hide "Need help" button';
$string['names_order'] = 'Names order';
$string['firstname_lastname'] = '{First Name} {Last Name}';
$string['lastname_firstname'] = '{Last Name} {First Name}';
$string['issuer'] = 'Issuer';
$string['criteria_method'] = 'Criteria method';
$string['criteria_all_courses'] = 'All of the following courses have to be completed';
$string['criteria_any_course'] = 'Any of the following courses have to be completed';
$string['dashboard_settings'] = 'Dashboard settings';

$string['tracklogs'] = 'Track Time by User - Daily';
$string['trackdetails'] = 'Track Time by User - Hourly';
$string['tracktotals'] = 'Track Time Aggregate - Daily';

$string['enable_badges_report'] = 'Enable "Badges" report';
$string['sizemode'] = 'Size Mode: Large ( > 5,000 Users)';
$string['cachedef_bb_collaborate_access_token'] = 'BB collaborate access token';

$string['learner_menu'] = 'Mostrar link no menu Bloco de Navegação apenas se os alunos estiverem matriculados em alguns cursos';
#new strings
$string['intelliboard_reports'] = 'IntelliBoard Reports';
$string['n19'] = 'Course Navigation Link for Reports';
$string['t54'] = 'Enable [Activity Grades] Time Spent column';
$string['all_cohorts'] = 'All cohorts';
$string['privacy_shield_policy'] = 'Data Processing Addendum';
$string['privacy_policy'] = 'Privacy Policy';
$string['confirm_and_sign_up'] = 'Confirm and Sign Up';
$string['term_of_use'] = 'Terms Of Use';
$string['setup'] = 'Connect Now';
$string['protocol'] = 'Protocol';
$string['rest'] = 'REST';
$string['soap'] = 'SOAP';
$string['next'] = 'Next';
$string['terms_msg'] = 'By checking this box you confirm that you have read and agree to our Terms of Use.';
$string['privacy_msg'] = 'By checking this box you confirm that you have read and agree to our Privacy Policy.';
$string['shield_msg'] = 'By checking this box you confirm that you have read and agree to our Data Processing Addendum.';
$string['enable_webservice'] = 'Enable web services';
$string['you_need_to_enable_at_least_one_protocol'] = 'You need to enable at least one protocol';
$string['invalid_user'] = 'Invalid user';
$string['sign_in'] = 'Sign in';
$string['email'] = 'Email';
$string['password'] = 'Password';
$string['all_fields_required'] = 'All fields required';
$string['server_error'] = 'Server error';
$string['country'] = 'Country';
$string['please_accept_terms_and_conditions'] = 'Please accept terms and conditions';
$string['congratulations_intb_register'] = 'Congratulations';
$string['congratulations_intb_register_msg'] = 'Thank you for starting your 15 day free trial with IntelliBoard!  Please check your email to confirm your IntelliBoard account.  To begin, utilize the Single Sign On (SSO) Link, if enabled from Site Administration > IntelliBoard or sign in <a href="https://app.intelliboard.net/signin">here</a>.  The SSO Link reads as “INTELLIBOARD.NET” and is in the top right corner of the Dashboard. For questions, please contact Support@IntelliBoard.net';
$string['sign_up'] = 'Sign Up';
$string['sign_in'] = 'Sign In';
$string['intelliboard_settings'] = 'IntelliBoard settings';
$string['moodle_settings'] = 'Moodle Settings';
$string['email_is_required'] = 'Email is required';
$string['invalid_email'] = 'Invalid Email';
$string['intelliboard_terms'] = 'IntelliBoard Agreements';
$string['authentication'] = 'Account Creation';
$string['intb_settings_descr'] = "IntelliBoard requires one main, unique subscription email.  Please enter the email you wish to use as your subscription email below.  The email must be double verified through an email confirmation prior to use.  For questions, please contact <a href='mailto:Support@IntelliBoard.net'>Support@IntelliBoard.net</a>. For a full listing of IntelliBoard Settings, go to Site Administration > Plugins > Local Plugins > IntelliBoard";
$string['hosting_provider'] = 'Hosting Provider';
$string['self_hosted'] = 'Self-Hosted';

// date formats
$string['mysqlweek'] = '%Y, week %v';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlyear'] = '%Y';
$string['mysqlmonth'] = '%c';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlquarter'] = 'quarter';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';

$string['postgreweek'] = 'YYYY, "week" WW';
$string['postgremonthyear'] = 'Month YYYY';
$string['postgreyear'] = 'YYYY';
$string['postgremonth'] = 'MM';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgrequarter'] = 'quarter';
$string['postgredayshortmonthyear'] = 'DD Mon, YYYY';
$string['postgretimedate'] = 'HH12:MIAM, DD Mon YYYY';
$string['postgredaymonth'] = 'DD Mon YYYY';
$string['postgremonthyearday'] = 'Month YYYY, DD';
$string['postgrequarteryear'] = 'Q YYYY';
$string['postgremonthdayyear'] = 'MM/DD/YYYY';
$string['postgretimemonthdayyear'] = 'HH24 MM/DD/YYYY';

// new strings
$string['report1_name'] = 'User Status';
$string['report2_name'] = 'Course Stats';
$string['report3_name'] = 'Activity Stats Summary';
$string['report45_name'] = 'Quiz Activity Detail';
$string['report_activity_stats_summary'] = 'Activity Stats Summary';
$string['report_user_profile_information'] = 'User Profile Information';
$string['course_name'] = 'Course Name';
$string['course_short_name'] = 'Course Short Name';
$string['course_idnumber'] = 'ID Number';
$string['course_status'] = 'Status';
$string['number_of_learners'] = '# of Enrolled User(s)';
$string['number_of_modules'] = '# of Activity(ies)';
$string['number_of_completed_learners'] = '# of Completed User(s)';
$string['number_of_visits'] = 'Visit(s)';
$string['num_completed_activity'] = '# of Users Who Completed This Activity';
$string['total_time_spent'] = 'Total Time Spent';
$string['date_created'] = 'Date Created';
$string['initial_reports'] = 'Initial Reports';
$string['avg_score'] = 'Average Score';
$string['first_access'] = 'First Access';
$string['completion_not_enabled'] = 'Completion Not Enabled';
$string['first_name'] = 'First Name';
$string['last_name'] = 'Last Name';
$string['num_attempts'] = '# of Attempts';
$string['highest_grade'] = 'Highest Grade';
$string['lowest_grade'] = 'Lowest Grade';
$string['initial_reports_warning'] = 'To email, schedule, and further personalize these reports, click <a href="{$a}">Contact Us</a>.';
$string['last_access'] = 'Last Access';
$string['enrolment_expiration'] = 'Enrolment Expiration';
$string['id_number'] = 'ID Number';
$string['telephone1'] = 'Telephone 1';
$string['telephone2'] = 'Telephone 2';
$string['institution'] = 'Institution';
$string['department'] = 'Department';
$string['address'] = 'Address';
$string['city'] = 'City/Town';
$string['enroled_on'] = 'Enrollment Date';

$string['dashboard_link'] = 'Click to view Analytics';
$string['support_connect'] = 'Click the report buttons within the rectangle below. Get a glimpse into the power of IntelliBoard: 1 button access to your LMS insights. Want more? Click "Click to view Analytics". Still want more? <a href="{$a->connect_link}">Contact Us</a> in the top right, or anywhere you see the link.';
$string['support_text3'] = 'Thank you for installing IntelliBoard Lite!';
$string['support_text4'] = 'Meet an easy-to-use reporting and visualization platform that will help you achieve your retention, engagement, and compliance goals.';
$string['support_text6'] = 'Need more info? Click any of the blue buttons to connect with us.';

$string['web_services_descr'] = 'IntelliBoard requires Web services to be enabled. Web services enables other systems (e.g., IntelliBoard) to access this LMS system and preform operations.  For security purposes, this should be disabled when not in use.   For additional review, go to Site Administration > Advanced features > Web services';
$string['protocol_descr'] = 'IntelliBoard requires either REST or SOAP Protocol to be enabled.  For security purposes, only protocols that are in use should be enabled.  For additional review, go to Site Administration > Plugins > Web services > Manage protocols';
$string['authorized_user_descr'] = 'IntelliBoard requires an Authorized user.  The Authorized user will likely be a Site Administrator and must have privileges to manage web services, protocols and tokens.  For additional review, go to Site Administration > Plugins > Web services > External Services > IntelliBoard service > Authorized user';
$string['email_subscr'] = 'Subscription email';
$string['protocols_descr'] = 'IntelliBoard requires either REST or SOAP Protocol to be enabled.  For security purposes, only protocols that are in use should be enabled.  For additional review, go to Site Administration > Plugins > Web services > Manage protocols';
$string['enable_time_tracking'] = 'Enable Time Tracking';
$string['enable_time_tracking_descr'] = 'Enable Time Tracking for additional insights on user access, visits and time spent. IntelliBoard provides additional insights on time tracking separately from the Moodle time spent tables.';
$string['enable_sso'] = 'Enable Single Sign On (SSO) Link';
$string['enable_sso_descr'] = 'Enable Single Sign On Link for one click access for Site Administrators into the IntelliBoard SuperAdmin access on app.IntelliBoard.net';
$string['join_a_webinar'] = 'Join a Webinar';
$string['review_support_doc'] = 'Review Support Documentation';
$string['setup_subheading'] = 'Connect to experience the power of your data. No credit card. No obligation. Just 15 free days of data bliss.';

$string['instructor_courses_table_name'] = 'Course Grades';
$string['instructor_courses_table_name_learner'] = 'Course {$a->course}, Learner {$a->learner}, Grades';
$string['instructor_courses_table_name_activity'] = 'Course {$a->course}, Activity {$a->name}, Grades';
$string['instructor_courses_table_name_learners'] = 'Course {$a->fullname}, Learners';
$string['instructor_courses_table_name_activities'] = 'Course {$a->fullname}, Activities';

$string['successfull_connected'] = 'Sucessfully connected';
$string['not_connected'] = 'Not connected';

$string['transcripts'] = 'Transcripts';
$string['enable_transcripts'] = 'Enable Transcripts';
$string['closed'] = 'Closed';
$string['synctranscriptstask'] = 'Sync Transcripts Task';
$string['transcriptssyncrecordsnum'] = 'Transcripts Processing Size';
$string['transcriptssyncrecordsnum_desc'] = 'The number of users enrollments records which will be processed at once';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'Transcripts courses records';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'User ID';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'User email';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'User first name';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'User last name';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'Transcripts user enroll ID';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'Enroll record ID';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'Enroll method';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'Course ID';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = 'Course full name';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'Enrollment Date';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'Unenrollment Date';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'Completion Date';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'Transcript Status';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'Grade Item ID';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = 'Grade Grade ID';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'Max Grade';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'Min Grade';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'Final Grade';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'Formatted Grade';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'User Roles';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'User Groups';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'Timestamp when record created';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'Timestamp when record was updated last time';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'Transcripts courses records';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'Transcripts user enroll ID';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'Course ID';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'User ID';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'Course Module ID';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'Module ID';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Activity Name';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Module Type';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Start Date';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Completion Date';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Status';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'Grade Item ID';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = 'Grade Grade ID';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'Max Grade';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'Min Grade';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Final Grade';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'Formatted Grade';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'Timestamp when record created';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'Timestamp when record was updated last time';
$string['goal_grade'] = 'Goal Grade';
$string['importtrackingtask'] = 'Import Tracking Task';
$string['compresstracking'] = 'Compress Tracking';
$string['compresstracking_desc'] = 'Write Time Tracking data to file and transfer data to database with cron job (default: every 15 minutes)';
$string['cachedef_instructor_course_data'] = 'Cache for course data';
$string['cachedef_reports_list'] = 'Cache for reports list';
$string['do_not_use_compresstracking'] = 'Do not use Compress Tracking';
$string['cache_compresstracking'] = 'Save to Moodle Cache';
$string['file_compresstracking'] = 'Save to MoodleData';
$string['cachedef_tracking'] = 'Intelliboard Tracking data';
$string['cachedef_track_config'] = 'Intelliboard Tracking total data';
$string['coursecontainer_filter'] = 'Enable course container filter';
$string['enableexportcustomfont'] = 'Fonte compatível com japonês/China';
$string['all_selected'] = 'Tudo selecionado';
$string['custommenuitem'] = 'Display in Custom Menu';
$string['support_text7'] = 'To get started with <strong>IntelliBoard Lite</strong>, please <a href="{$a->meeting_link}">schedule a consultation</a> with one of our learning analytics experts.';
$string['support_text8'] = 'If you have <strong>already purchased</strong> a license and see this screen, please contact your Account Manager for assistance.';
$string['support_text9'] = 'Need predictive models, notifications, and intervention tracking?';
$string['support_text10'] = 'Switch to <a href="{$a->intelliboard_pro_link}"><strong>IntelliBoard Pro</strong></a>';
$string['support_text11'] = '<a href="{$a->intelliboard_pro_onepager}">Click here</a> to download the IntelliBoard Pro one-pager.';
$string['enable_vendor_frontpage_course'] = 'Enable the frontpage course in the reports for vendors';
$string['pagelayout'] = 'Theme page layout';
