<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This plugin provides access to Moodle data in form of analytics and reports in real time.
 *
 *
 * @package    local_intelliboard
 * @copyright  2017 IntelliBoard, Inc
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @website    http://intelliboard.net/
 */

$string['pluginname'] = 'Plugin IntelliBoard.net';
$string['tracking_title'] = 'Urmărirea Timpului';
$string['tracking'] = 'Urmărirea Sesiunii';
$string['dashboard'] = 'Tablou de bord';
$string['settings'] = 'Setări';
$string['adv_settings'] = 'Setări Avansate';
$string['intelliboardroot'] = 'IntelliBoard';
$string['intelliboard_reports'] = 'Rapoarte IntelliBoard';
$string['report'] = 'Raport';
$string['reports'] = 'Rapoarte';
$string['learners'] = 'Cursanți';
$string['courses'] = 'Cursuri';
$string['load'] = 'Performanță';
$string['inactivity'] = 'Inactivitate';
$string['inactivity_desc'] = 'Timp de inactivitate a utilizatorului (în secunde)';
$string['ajax'] = 'Frecvență';
$string['ajax_desc'] = 'Frecvența de stocare a sesiunii prin AJAX. 0 - AJAX dezactivat (în secunde)';
$string['enabled'] = 'Urmărire Activată';
$string['enabled_desc'] = 'Activare Urmărire';
$string['trackadmin'] = 'Urmărire Administatori';
$string['logs'] = 'Instrument de Migrare';
$string['trackadmin_desc'] = 'Activați Urmărirea Timpului pentru Administratori (nu este recomandat)';
$string['intelliboard:instructors'] = 'IntelliBoard [instructor]';
$string['intelliboard:students'] = 'IntelliBoard [student]';
$string['intelliboard:view'] = 'IntelliBoard [view]';
$string['intelliboard:manage'] = 'IntelliBoard [manage]';
$string['intelliboard:competency'] = 'IntelliBoard [competency]';
$string['intelliboard:attendanceadmin'] = 'Administrator de prezență';
$string['intelliboard:browseallcohorts'] = 'IntelliBoard [Browse All Cohorts]';
$string['tls12'] = 'TLS v1.2';
$string['tls12_desc'] = 'Setări avansate: TLS v1.2';
$string['sso'] = 'Legătură SSO';
$string['sso_desc'] = 'Legătură SSO la IntelliBoard.net';
$string['ssomenu'] = 'Element de meniu SSO';
$string['ssomenu_desc'] = 'Legătură SSO în meniul Bloc-ului de Navigare (pentru non-cursanți/non-instructori)';
$string['api'] = 'Alternativă API';
$string['api_desc'] = 'Utilizați server API alternativ (pentru a evita blocarea firewall-ului)';
$string['server'] = 'Server IntelliBoard';
$string['server_usa'] = 'IntelliBoard SUA';
$string['server_au'] = 'IntelliBoard Australia';
$string['server_eu'] = 'IntelliBoard Europa';
$string['show_dashboard_tab'] = 'Pagina Tablou de bord';
$string['filters'] = 'Filtre Tablou de bord';
$string['filter1'] = 'Utilizatori șterși';
$string['filter2'] = 'Utilizatori suspendați';
$string['filter3'] = 'Utilizator Guest';
$string['filter4'] = 'Filtru curs';
$string['filter5'] = 'Filtru metodă de înscriere';
$string['filter6'] = 'Filtru de înscriere utilizator';
$string['filter7'] = 'Filtru Activități/Resurse';
$string['filter8'] = 'Filtrul pentru utilizatorii înscriși';
$string['filter1_desc'] = 'Afișați utilizatorii șterși';
$string['filter2_desc'] = 'Afișați utilizatorii suspendați';
$string['filter3_desc'] = 'Afișați utilizatorul [guest] în rapoarte';
$string['filter4_desc'] = 'Afișați cursurile ascunse';
$string['filter5_desc'] = 'Afișați metodele de înscriere neactive';
$string['filter6_desc'] = 'Afișați utilizatorii cu starea de înscriere neactivă';
$string['filter7_desc'] = 'Afișați Activități/Resurse nevizibile';
$string['filter8_desc'] = 'Afișați numai utilizatorii înscriși (nu este recomandat)';
$string['intelliboardaccess'] = 'Nu aveți permisiunea să vizualizați această pagină. Vă rugăm să contactați Administratorul pentru asistență.';
$string['tex1'] = 'Tabloul de bord IntelliBoard pentru Cursant nu este activat.';
$string['account'] = 'Informații despre Abonament';
$string['te12'] = 'Nume';
$string['te13'] = 'Prenume';
$string['te1'] = 'Email';
$string['te1_desc'] = 'Introduceți adresa de e-mail utilizată cu abonamentul IntelliBoard.net. Dacă nu aveți un abonament activ, vă rugăm să vă înregistrați la <a target="_blank" href="https://intelliboard.net"> IntelliBoard.net </a>. Tabloul de bord pentru cursanți și instructori este disponibil cu un abonament de nivelul 4 sau unul superior.';
$string['n1'] = 'Prezentare generală [Learner Progress]';
$string['n2'] = 'Prezentare generală [Grade Progress]';
$string['n3'] = 'Prezentare generală [Activity Progress]';
$string['n12'] = 'Prezentare generală [Course Overview]';
$string['n4'] = 'Prezentare generală [Totals]';
$string['n5'] = 'Progres Actual';
$string['n13'] = 'Total Studenți';
$string['n6'] = 'Widget: Corelații';
$string['n14'] = 'Widget: Angajamentul Cursantului';
$string['n18'] = 'Widget: Progres Notă Student';
$string['n7'] = 'Widget: Utilizarea Evenimentelor';
$string['n15'] = 'Widget: Utilizarea Activității';
$string['n16'] = 'Widget: Utilizarea Topicului';
$string['n8'] = 'Pagina de Cursuri';
$string['n9'] = 'Pagina de Rapoarte';
$string['n19'] = 'Link de Navigare Curs pentru Rapoarte';
$string['n10'] = 'Instructor Tablou de bord';
$string['n101'] = 'Activați Instructor Tablou de bord';
$string['n11'] = 'Text alternativ pentru meniul Bloc-ului de Navigare';
$string['ts1'] = 'Tabloul de bord al Cursantului';
$string['ts2'] = 'Pagina cu Tabloul de bord al Cursantului';
$string['ts3'] = 'Cursuri Tablou de bord al Cursantului';
$string['ts4'] = 'Note Tablou de bord al Cursantului ';
$string['ts5'] = 'Rapoarte Tablou de bord al Cursantului';
$string['learner_tf_last_week'] = 'Filtru de timp: 7 zile';
$string['t01'] = 'Filtru de timp: Ultimele 30 de zile';
$string['t02'] = 'Filtru de timp: Ultimele 3 Luni';
$string['t03'] = 'Filtru de timp: Ultimele 6 Luni';
$string['t04'] = 'Activați [header] Cursurile finalizate';
$string['t05'] = 'Activați [header] Cursuri în progres';
$string['t06'] = 'Activați [header] Cursuri notă medie';
$string['t07'] = 'Activați [header] Mesaje';
$string['t08'] = 'Activați [header] Cursuri rezumatul notelor';
$string['t09'] = 'Instructorul poate vedea proprii studenți';
$string['t1'] = 'Activați Tabloul de bord al Cursantului';
$string['t2'] = 'Activați Tabloul de bord';
$string['t3'] = 'Activați Cursurile';
$string['t4'] = 'Activați Notele';
$string['t48'] = 'Activați Rapoartele';
$string['t5'] = 'Activați graficul [Activity progress]';
$string['t53'] = 'Activați linia medie pe grafic pentru [Activity progress]';
$string['t6'] = 'Activați graficul [Course progress]';
$string['t7'] = 'Activați [My course average]';
$string['t8'] = 'Activați [Overall course average]';
$string['t9'] = 'Activați widgetul [Assignments]';
$string['t10'] = 'Activați widgetul [Quizzes]';
$string['t11'] = 'Activați widget-ul [Course Progress]';
$string['t12'] = 'Activați widgetul [Activity participation]';
$string['t13'] = 'Activați widgetul [Learning]';
$string['t14'] = 'Activați widgetul [Course success]';
$string['t15'] = 'Activați widgetul [Correlations]';
$string['t16'] = 'Activați profesorul de curs';
$string['t17'] = 'Activați categoria de cursuri';
$string['t18'] = 'Activați finalizarea cursului';
$string['t19'] = 'Activați nota cursului';
$string['t20'] = 'Activați media clasei de curs';
$string['t21'] = 'Activați timpul petrecut la curs';
$string['t22'] = 'Activați data de începere a cursului';
$string['t23'] = 'Activați coloana [Course start date]';
$string['t24'] = 'Activați coloana [Enrolled date]';
$string['t25'] = 'Activați coloana [Progress]';
$string['t26'] = 'Activați coloana [Letter]';
$string['t27'] = 'Activați coloana [Completed Activities]';
$string['t28'] = 'Activați coloana [Grade]';
$string['t29'] = 'Activați coloana [Course Completion Status]';
$string['t30'] = 'Activați coloana [Activity Grades]';
$string['t31'] = 'Activați coloana widgetului [Assignments][Grade]';
$string['t32'] = 'Activați coloana widgetului [Assignments][Due Date]';
$string['t33'] = 'Activați coloana widget [Quizzes][Grade]';
$string['t34'] = 'Activați coloana widget [Quizzes][Due Date]';
$string['t35'] = 'Activați coloana widgetului [Course Progress][Progress]';
$string['t36'] = 'Activați coloana widgetului [Course Progress][Grade]';
$string['t37'] = 'Activați coloana widgetului [Course Progress][Enrolled]';
$string['t38'] = 'Activați coloana widgetului [Course Progress][Completed]';
$string['t52'] = 'Activați coloana widgetului [Course Progress][Category]';
$string['t39'] = 'Activați opțiunea [Progress][Goal Grade]';
$string['t40'] = 'Activați opțiunea [Progress][Class Avg.]';
$string['t41'] = 'Activați [Activity Grades header] Finalizat la';
$string['t42'] = 'Activați [Activity Grades header] Ultima accesare a cursului';
$string['t43'] = 'Activați coloana Tip pentru [Activity Grades]';
$string['t44'] = 'Activați coloana Notă pentru [[Activity Grades]';
$string['t45'] = 'Activați coloana Notat pentru [Activity Grades]';
$string['t46'] = 'Activați coloana Completat pentru [Activity Grades]';
$string['t54'] = 'Activați coloana Timp Petrecut pentru [Activity Grades]';
$string['t47'] = 'Culoare fundal pentru Cursuri [grid]';
$string['t49'] = 'Coloane filtre Raport';
$string['t50'] = 'Roluri Profesor';
$string['t51'] = 'Roluri Student';
$string['current_grade'] = 'nota actuală';
$string['average_grade'] = 'nota medie';
$string['type_here'] = 'Tastați aici...';
$string['enrolled_date'] = 'Data înscrierii';
$string['teacher'] = 'Profesor';
$string['category'] = 'Categorie';
$string['current_grade'] = 'Nota actuală';
$string['completion'] = 'Completare';
$string['class_average'] = 'Media clasei';
$string['time_spent'] = 'Timp Petrecut';
$string['completed_on'] = 'Completat pe {$a}';
$string['passed_on'] = 'Completat (trecut) pe {$a}';
$string['failed_on'] = 'Completat (eșuat) pe {$a}';
$string['last_access_on_course'] = 'Ultimul acces pe curs: {$a}';
$string['you_have_certificates'] = 'Aveți {$a} certificate';
$string['close'] = 'Închide';
$string['view_course_details'] = 'Vizualizați detaliile cursului';
$string['incomplete'] = 'Incomplet';
$string['return_to_grades'] = 'Reveniți la Note';
$string['grade'] = 'Notă';
$string['last_week'] = 'Ultimele 7 Zile';
$string['last_month'] = 'Ultimele 30 Zile';
$string['last_quarter'] = 'Ultimele 3 Luni';
$string['last_semester'] = 'Ultimele 6 Luni';
$string['all_time'] = 'Tot timpul';
$string['activity_progress'] = 'Progresul activității';
$string['course_progress'] = 'Progres curs';
$string['my_course_average_all'] = 'media cursului meu (toate cursurile)';
$string['overall_course_average'] = 'media generală a cursului (toți cursanții; toate cursurile)';
$string['assignments'] = 'Sarcini de lucru';
$string['quizzes'] = 'Teste';
$string['assignment_name'] = 'Nume Sarcină de lucru';
$string['due_date'] = 'Data Scadentă';
$string['no_data'] = 'Fără date';
$string['quiz_name'] = 'Nume Test';
$string['all_courses'] = 'Toate cursurile';
$string['time_period_due'] = 'Perioada de timp (Data Scadenței)';
$string['all_data'] = 'Toate datele';
$string['progress'] = 'Progres';
$string['enrolled'] = 'Înscris';
$string['completed'] = 'Completat';
$string['activity_participation'] = 'Participare activitate';
$string['learning'] = 'Învățare';
$string['course_success'] = 'Succes Curs';
$string['correlations'] = 'Corelații';
$string['course_start_date'] = 'Data de începere a cursului';
$string['letter'] = 'Scrisoare';
$string['completed_activities'] = 'Activități Finalizate';
$string['score'] = 'Notă';
$string['course_completion_status'] = 'Starea Finalizării Cursului';
$string['activity_grades'] = 'Note Activități';
$string['completion_is_not_enabled'] = 'Finalizarea nu este activată pentru acest curs';
$string['activities'] = 'Activități';
$string['activity_name'] = 'Nume Activitate';
$string['type'] = 'Tip';
$string['graded'] = 'Notat';
$string['passed'] = 'Trecut';
$string['failed'] = 'Eșuat';
$string['completed_courses'] = 'Cursuri completate';
$string['courses_in_progress'] = 'Cursuri în progres';
$string['courses_avg_grade'] = 'Cursuri cu nota medie';
$string['courses_sum_grade'] = 'Cursuri cu Rezumat Note după Valoarea Scalară a Notei';
$string['grades'] = 'Note';
$string['messages'] = 'Mesaje';
$string['x_completions'] = '{$a} Finalizări';
$string['completion_status'] = 'Starea finalizării';
$string['users_activity'] = 'Activitatea utilizatorilor';
$string['daily'] = 'Ultimele 10 Zile';
$string['weekly'] = 'Ultimele 90 Zile';
$string['monthly'] = 'Ultimele 365 Zile';
$string['number_of_sessions'] = 'Numărul de sesiuni';
$string['number_today'] = '{$a} astăzi';
$string['number_this_week'] = '{$a} săptămâna asta';
$string['course_completions'] = 'Cursuri finalizate';
$string['user_enrolments'] = 'Înscrieri utilizatori';
$string['users'] = 'Utilizatori';
$string['modules'] = 'Module';
$string['categories'] = 'Categorii';
$string['total'] = 'Total';
$string['users_overview'] = 'Prezentare generală a utilizatorilor';
$string['enable_time_and_visits_users_overview'] = 'Activați timpul petrecut și vizitele în Prezentarea generală a utilizatorilor';
$string['disable_time_and_visits_users_overview'] = 'Dezactivați timpul petrecut și vizitele în Prezentarea generală a utilizatorilor';
$string['loading'] = 'Încărcare...';
$string['loading2'] = 'Încărcare, vă rugăm așteptați...';
$string['enrollments'] = 'Înrolări';
$string['registrations'] = 'Înregistrări';
$string['participation'] = 'Participare';
$string['time'] = 'Timp';
$string['enrolment_method'] = 'Metodă de înscriere';
$string['intelliBoard_migration_tool'] = 'Instrument de Migrare IntelliBoard';
$string['importing_totals'] = 'Importul totalurilor';
$string['total_numbers'] = 'Dată: {$a->timepoint}, Sesiuni: {$a->sessions}, Vizite: {$a->visits},  Timp Petrecut: {$a->timespend}';
$string['total_numbers2'] = 'UTILIZATOR: {$a->userid}, Pagină: {$a->page}, Parametru:{$a->param}, Vizite: {$a->visits},  Timp Petrecut: {$a->timespend}';
$string['total_numbers3'] = '----Dată: {$a->timecreated}, ID Urmărire: {$a->trackid}, Vizite: {$a->visits},  Timp Petrecut: {$a->timespend}';
$string['logs_to_process'] = 'Jurnale de procesat {$a}';
$string['please_wait_or_cancel'] = 'Vă rugăm să așteptați pentru a continua sau <a href="{$a}">Anulare</a>';
$string['done'] = 'Terminat!';
$string['return_to_home'] = 'Reveniți la pagina principală';
$string['importing_logs'] = 'Importare jurnale';
$string['intelliBoard_migration_tool_info'] = 'Instrumentul de migrare IntelliBoard este utilizat pentru a migra datele istorice din tabelul de jurnale Moodle într-un format nou. Vă rugăm să rețineți, procedura de stocare a jurnalelor Moodle nu se va modifica. Odată ce datele istorice au migrat în noul format, valorile istorice precum \'Timp petrecut\' și \'Vizite\' vor fi disponibile pentru previzualizare pe IntelliBoard.net.';
$string['moodle_logs'] = 'Jurnale Moodle';
$string['intelliboard_tracking'] = 'Urmărire IntelliBoard';
$string['intelliboard_logs'] = 'Jurnale IntelliBoard';
$string['intelliboard_totals'] = 'Totaluri IntelliBoard';
$string['intelliboard_start_tracking'] = 'Pornire urmărire IntelliBoard';
$string['total_values_include'] = 'Valorile totale includ sesiuni unice, cursuri, vizite, timp petrecut.';
$string['items_per_query'] = 'Elemente pe interogare';
$string['import'] = 'Import';
$string['log_values_include'] = 'Valorile jurnalului includ jurnale pentru fiecare utilizator per zi.';
$string['powered_by'] = 'Powered by <a href="https://intelliboard.net/">IntelliBoard.net</a>';
$string['intelliboardnet'] = 'IntelliBoard.net';
$string['visits'] = 'Vizite';
$string['registered'] = 'Înregistrate';
$string['disabled'] = 'Dezactivat';
$string['enrolled_completed'] = 'Înscris: {$a->courses}, Finalizate: {$a->completed_courses}';
$string['enrolled_users_completed'] = 'Utilizaotori înscriși: {$a->users}, Finalizate: {$a->completed}';
$string['user_grade_avg'] = '{$a->user} note: {$a->grade}, Nota medie: {$a->avg_grade_site})';
$string['user_visit_avg'] = '{$a->user} vizite: {$a->visits}, Vizite în medie: {$a->avg_visits_site}';
$string['user_time_avg'] = '{$a->user} timp: {$a->timespend}, Timp mediu: {$a->avg_timespend_site}';
$string['more_users'] = 'Mai mulți utilizatori';
$string['more_courses'] = 'Mai multe cursuri';
$string['showing_1_to_10'] = 'Afișare de la 1 la 10';
$string['course_grade'] = 'Notă Curs';
$string['completed_activities_resourses'] = 'Activități/Resurse Finalizate';
$string['save'] = 'Salvează';
$string['help'] = 'Ai nevoie de ajutor?';
$string['in1'] = 'Prezentare generală';
$string['in2'] = 'Progres Actual';
$string['in3'] = 'Total Cursuri';
$string['in4'] = 'Total Cursanți';
$string['in5'] = 'Total Note Cursuri';
$string['in6'] = 'Finalizări Cursanți';
$string['in7'] = 'Cursanți fără Finalizări';
$string['in8'] = 'Nota medie Cursanți';
$string['in9'] = 'Corelații';
$string['in10'] = 'Utilizarea Evenimentelor';
$string['in11'] = 'Progres Cursanți';
$string['in12'] = 'Progres Note';
$string['in13'] = 'Timp Petrecut (%)';
$string['in14'] = '% Progres';
$string['in15'] = 'Finalizările Cursantului';
$string['in16'] = 'Ultima Accesare';
$string['in17'] = 'Timp Total Petrecut';
$string['in18'] = 'Vizite Totale';
$string['in19'] = 'Nota Medie';
$string['in20'] = 'Reveniți la Cursanți';
$string['in201'] = 'Reveniți la Activități';
$string['in21'] = 'Nota Medie Curs';
$string['in22'] = 'Activat';
$string['in23'] = 'Nu aveți cursanți de afișat.';
$string['in24'] = 'Module';
$string['in25'] = 'Nota de Trecere';
$string['in26'] = 'Angajamentul Cursantului';
$string['in34'] = 'Progres Notă Student';
$string['in27'] = 'Total Studenți';
$string['in28'] = 'Media Timpului Petrecut';
$string['in29'] = 'Studenți Activi';
$string['in30'] = 'Studenți Inactivi';
$string['in31'] = 'Utilizarea Activității';
$string['in32'] = 'Timpul mediu în perioada selectată';
$string['in33'] = 'Utilizarea Topicului';
$string['status'] = 'Stare';
$string['course_category'] = 'Categorie Curs';
$string['course_started'] = 'Cursuri Începute';
$string['total_time_spent_enrolled_learners'] = 'Timp Total Petrecut de Cursanții Înscriși la Curs';
$string['total_visits_enrolled_learners'] = 'Vizite Totale ai cursanților înscriși la curs';
$string['learners_enrolled'] = 'Cursanți Înscriși';
$string['learners_enrolled_period'] = 'Cursanți înscriși în perioada selectată';
$string['learning_progress'] = 'Progres Cursanți';
$string['sections'] = 'Secțiuni';
$string['section'] = 'Secțiune';
$string['total_activities_resources'] = 'Total Activități/Resurse';
$string['completions'] = 'Finalizări';
$string['return_to_courses'] = 'Reveniți la Cursuri';
$string['click_link_below_support_pages'] = 'Faceți clic pe linkul de mai jos pentru a accesa paginile de asistență IntelliBoard:';
$string['support'] = 'Suport';
$string['course_name'] = 'Nume Curs';
$string['enrolled_completed_learners'] = 'Cursanți Înscriși/Completați';
$string['activities_resources'] = 'Activități/Resurse';
$string['actions'] = 'Acțiuni';
$string['learner_name'] = 'Nume Cursant';
$string['completed_activities_resources'] = 'Activități/Resurse Completate';
$string['filter_dates'] = 'Filtre date:';
$string['select_date'] = 'Selectează Dată';
$string['select'] = 'Selectează';
$string['selectall'] = 'Selectează Tot';
$string['ok'] = 'OK';
$string['moodle'] = 'Moodle';
$string['totara'] = 'Totara';
$string['monitors'] = 'Monitorizări';
$string['cohorts'] = 'Cohorte';
$string['course_overview'] = 'Course Overview';
$string['topics'] = 'Topicuri';
$string['a31'] = 'Cadre';
$string['a32'] = 'Planuri de Învățare';
$string['a33'] = 'Evaluat, Competent';
$string['a34'] = 'Evaluat, nu este Competent';
$string['a35'] = 'Neevaluat';
$string['a36'] = 'Prezentare Generală a Competențelor';
$string['a37'] = 'O competență nu a fost creată. Vă rugăm să contactați Administratorul de Sistem.';
$string['a38'] = 'Cursuri Legate de Competențe';
$string['a39'] = 'Totaluri Competențe';
$string['a40'] = 'Cursuri Legate';
$string['no_competency'] = 'Se pare că nu aveți competențe activate pe site-ul dvs. Moodle.';
$string['scalesettings'] = 'Setări de scalare';
$string['scales'] = 'Activați scala personalizată';
$string['scale_raw'] = 'Dezactivați scala';
$string['scale_real'] = 'Afișați nota reală în loc de procentaj';
$string['scale_total'] = 'Total Notă';
$string['scale_value'] = 'Valoare';
$string['scale_percentage'] = 'Procentaj';
$string['a0'] = 'Tablou de bord Competențe';
$string['a1'] = 'Competențe';
$string['a2'] = 'Experiență';
$string['a3'] = 'Activități Alocate';
$string['a4'] = 'Progres Experiență';
$string['a5'] = 'Competențe Evaluate';
$string['a6'] = '# Dovezi';
$string['a7'] = 'Cursanți Evaluați';
$string['a8'] = 'Progres';
$string['a9'] = 'Cursanți Competenți';
$string['a10'] = 'Cursanți Înscriși';
$string['a11'] = 'Lista competențelor atribuite cursului';
$string['a12'] = 'Stare Cursant';
$string['a13'] = 'Nume Competență';
$string['a14'] = 'Creeat În';
$string['a15'] = 'Alocat În';
$string['a16'] = 'Competență Indicată';
$string['a17'] = 'Evaluare';
$string['a18'] = 'Competențe Experte';
$string['a19'] = 'Data Evaluării Competenței';
$string['a20'] = 'Evaluator de Competențe';
$string['a21'] = 'Activități Alocate';
$string['a22'] = 'Experiență Realizată';
$string['a23'] = 'Competențe Evaluate';
$string['a24'] = '# Evidențe';
$string['a25'] = 'Cursanți Completați';
$string['a27'] = ' din ';
$string['a28'] = 'Detalii';
$string['a29'] = 'Activați Tablou de bord Competențe';
$string['a30'] = 'Activați Rapoarte Competențe';
$string['a26'] = 'Acest tabel afișează numărul de competențe atribuite unui curs, cursanții care au fost evaluați (fie că sunt competenți sau nu) și cursanții care au fost desemnați competenți în competență.';
$string['s25'] = 'Timp petrecut în activitate';
$string['s45'] = 'Activitate';
$string['s46'] = 'Procentul studenților care încearcă';
$string['s47'] = 'Topic';
$string['s48'] = 'Timp petrecut în topic';
$string['completions'] = 'Stare finalizare activitate';
$string['completions_completed'] = 'Stare finalizare (completat)';
$string['completions_pass'] = 'Stare finalizare (trecut)';
$string['completions_fail'] = 'Stare finalizare (eșuat)';
$string['completions_desc'] = '1) Utilizatorul a finalizat această activitate. Nu se specifică dacă au trecut sau nu. <br>
2) Utilizatorul a finalizat această activitate cu o notă peste nota de promovare. <br>
3) Utilizatorul a finalizat această activitate, dar nota este mai mică decât nota de promovare.';
$string['widget_name27'] = "Înscrieri Cumulative";
$string['widget_name28'] = "Angajament";
$string['widget_name29'] = "Conectări Unice";
$string['widget_name30'] = "Înscrieri în Curs";
$string['widget_name31'] = "Registre & Supraveghere preluate";
$string['role1'] = "Primul Rol";
$string['role2'] = "Al doilea Rol";
$string['select_course'] = "Selectează curs";
$string['select_quiz'] = "Selectează test";
$string['not_quiz'] = "Hopa, se pare că nu aveți teste create pentru cursul selectat.";
$string['enter_course_and_quiz'] = "Vă rugăm să selectați cursul și testul.";
$string['enter_quiz'] = "Vă rugăm să selectați testul.";
$string['analityc_3_name'] = "Prezentare generală a chestionarului și detaliile întrebărilor";
$string['course_name_a'] = 'Curs: {$a}';
$string['quiz_name_a'] = 'Test: {$a}';
$string['cor_incor_answers'] = 'Răspunsuri Corecte/Incorecte';
$string['quiz_finished'] = 'Test finalizat';
$string['quiz_grades'] = 'Note test';
$string['correct_number'] = 'Corect {$a}';
$string['incorrect_number'] = 'Incorect {$a}';
$string['correct'] = 'Corect';
$string['incorrect'] = 'Incorect';
$string['weekday_0'] = "Luni";
$string['weekday_1'] = "Marți";
$string['weekday_2'] = "Miercuri";
$string['weekday_3'] = "Joi";
$string['weekday_4'] = "Vineri";
$string['weekday_5'] = "Sâmbătă";
$string['weekday_6'] = "Duminică";
$string['time_1'] = "Dimineață";
$string['time_2'] = "După amiază";
$string['time_3'] = "Seara";
$string['time_4'] = "Ore libere";
$string['passing_score_for'] = 'Nota de trecere pentru {$a}';
$string['name'] = 'Nume';
$string['answers'] = 'Răspunsuri';
$string['ques_breakdown'] = 'Defalcarea întrebărilor';
$string['n17'] = 'Pagină Analize';
$string['analytics'] = 'Analize';
$string['pdf'] = 'PDF';
$string['csv'] = 'CSV';
$string['excel'] = 'Excel';
$string['grades_alt_text'] = 'Text alternativ pentru meniul de navigare';
$string['course_chart'] = 'Activați diagrama cursului';
$string['course_activities'] = 'Activați activitățile de curs';
$string['filter_this_year'] = 'Filtru de timp: Anul Acesta';
$string['filter_last_year'] = 'Filtru de timp: Anul Trecut';
$string['filter_all_time'] = 'Filtru de timp: Tot Timpul';
$string['this_year'] = 'Anul Acesta';
$string['last_year'] = 'Anul Trecut';
$string['reportselect'] = 'Vă rugăm să selectați cel puțin un raport din App.IntelliBoard.net. Faceți clic pe un raport, apoi pe Setările Raportului și selectați-l în „Vizibil în Moodle”.';
$string['monitorselect'] = 'Vă rugăm să selectați cel puțin un monitor din App.IntelliBoard.net. Faceți clic pe Monitorizări, apoi pe Setări Monitorizăre și selectați-l în „Vizibil în Moodle”.';
$string['select_user'] = 'Selectează utilizator';
$string['course_max_grade'] = 'Nota maximă a cursului';
$string['no_data_notification'] = 'Nu există date noi pentru [date]';
$string['last_hour'] = 'oră';
$string['last_day'] = 'zi';
$string['privacy:metadata:local_intelliboard_assign'] = 'Tabel Intelliboard cu subaconturi alocate';
$string['privacy:metadata:local_intelliboard_details'] = 'Tabel Intelliboard cu alt/logs/by-hour';
$string['privacy:metadata:local_intelliboard_logs'] = 'Tabel Intelliboard cu alt/logs/by-day';
$string['privacy:metadata:local_intelliboard_totals'] = 'Tabel Intelliboard cu alt/logs/total';
$string['privacy:metadata:local_intelliboard_tracking'] = 'Tabel Intelliboard cu alt/logs/all-time';
$string['privacy:metadata:local_intelliboard_reports'] = 'Tabel Intelliboard cu rapoarte personalizate prin sql';
$string['privacy:metadata:local_intelliboard_ntf'] = 'Tabel Intelliboard cu notificări principale';
$string['privacy:metadata:local_intelliboard_ntf_hst'] = 'Tabel Intelliboard cu istoricul notificărilor';
$string['privacy:metadata:local_intelliboard_ntf_pms'] = 'Tabel Intelliboard cu notificări parametrici dinamice';
$string['privacy:metadata:local_intelliboard_assign:userid'] = 'ID UTILIZATOR al înregistrării';
$string['privacy:metadata:local_intelliboard_assign:rel'] = 'Tip Rel al înregistrării';
$string['privacy:metadata:local_intelliboard_assign:type'] = 'Tip Instanță Moodle';
$string['privacy:metadata:local_intelliboard_assign:instance'] = 'ID-ul Instanței Moodle Conectat';
$string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'Înregistrări Marcaje de timp';
$string['privacy:metadata:local_intelliboard_reports:status'] = 'Starea raportului - activat/neactivat';
$string['privacy:metadata:local_intelliboard_reports:name'] = 'Numele raportului personalizat';
$string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'Cod SQL codat BASE64';
$string['privacy:metadata:local_intelliboard_reports:timecreated'] = 'Timpul creației';
$string['privacy:metadata:local_intelliboard_details:logid'] = 'ID Tabel [local_intelliboard_logs]';
$string['privacy:metadata:local_intelliboard_details:visits'] = 'Numărul de vizite, clicuri de mouse, pe zi';
$string['privacy:metadata:local_intelliboard_details:timespend'] = 'Cantitatea de timp petrecut pe oră';
$string['privacy:metadata:local_intelliboard_details:timepoint'] = 'Ora';
$string['privacy:metadata:local_intelliboard_logs:trackid'] = 'ID-ul tabelului [local_intelliboard_tracking]';
$string['privacy:metadata:local_intelliboard_logs:visits'] = 'Vizite, clicuri de mouse, pe zi';
$string['privacy:metadata:local_intelliboard_logs:timespend'] = 'Timpul petrecut, pe zi';
$string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'Timpul petrecut al zilei din an';
$string['privacy:metadata:local_intelliboard_totals:sessions'] = 'Numărul total de sesiuni de utilizator în Moodle';
$string['privacy:metadata:local_intelliboard_totals:courses'] = 'Total Cursuri în Moodle';
$string['privacy:metadata:local_intelliboard_totals:visits'] = 'Vizite totale al tuturor utilizatorilor din Moodle';
$string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Timpul Total al Utilizatorilor petrecuți în Moodle';
$string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'Timpul petrecut al zilei din an';
$string['privacy:metadata:local_intelliboard_tracking:userid'] = 'ID Utilizator care vizitează pagina Moodle.';
$string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'ID-ul cursului pe care îl Vizitează Utilizatorul';
$string['privacy:metadata:local_intelliboard_tracking:page'] = 'Tip Pagină [course,module,profile,site]';
$string['privacy:metadata:local_intelliboard_tracking:param'] = 'Tip Pagină ID';
$string['privacy:metadata:local_intelliboard_tracking:visits'] = 'Vizitele Utilizatorilor pe o pagină';
$string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'Timpul petrecut al utilizatorului pe o pagină';
$string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'Primul Acces al Utilizatorilor';
$string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'Ultimul Acces al Utilizatorilor';
$string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'Tipul de Browser al Utilizatorilor';
$string['privacy:metadata:local_intelliboard_tracking:useros'] = 'Sistemul de Operare al Utilizatorilor';
$string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'Limba Browser-ului Utilizatorilor';
$string['privacy:metadata:local_intelliboard_tracking:userip'] = 'Ultima adresă IP a utilizatorilor';
$string['privacy:metadata:local_intelliboard_ntf:id'] = 'ID Notificare';
$string['privacy:metadata:local_intelliboard_ntf:type'] = 'Tip Notificare';
$string['privacy:metadata:local_intelliboard_ntf:externalid'] = 'Notificare ExternalNID';
$string['privacy:metadata:local_intelliboard_ntf:userid'] = 'Notificare ExternalAppID';
$string['privacy:metadata:local_intelliboard_ntf:email'] = 'E-mail Notificare';
$string['privacy:metadata:local_intelliboard_ntf:cc'] = 'CC Notificare';
$string['privacy:metadata:local_intelliboard_ntf:subject'] = 'Subiect Notificare';
$string['privacy:metadata:local_intelliboard_ntf:message'] = 'Mesaj Notificare';
$string['privacy:metadata:local_intelliboard_ntf:state'] = 'Stare Notificare';
$string['privacy:metadata:local_intelliboard_ntf:attachment'] = 'Atașament Notificare';
$string['privacy:metadata:local_intelliboard_ntf:tags'] = 'Tag-uri Notificare';
$string['privacy:metadata:local_intelliboard_ntf_hst:id'] = 'ID istoric Notificări';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = 'ID Notificări';
$string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = 'Notificare ExternalAppID';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = 'Nume Notificare';
$string['privacy:metadata:local_intelliboard_ntf_hst:email'] = 'E-mail istoric notificări';
$string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = 'Notificări istoric timp petrecut';
$string['select_manager_role'] = 'Selectează rol manager';
$string['group_aggregation'] = 'Agregarea grupului';
$string['ssodomain'] = 'Subdomeniu SSO';
$string['ssodomain_desc'] = 'Single Sign On cu Server/Cont separat';
$string['instructor_redirect'] = 'Redirecționarea instructorului';
$string['student_redirect'] = 'Redirecționarea studentului';
$string['myorders'] = 'Comenzi';
$string['myseats'] = 'Scaune';
$string['mywaitlist'] = 'Lista de așteptare';
$string['mysubscriptions'] = 'Abonamente';
$string['seatscode'] = 'Cod scaune';
$string['numberofseats'] = 'număr de locuri';
$string['downloadinvoice'] = 'Descărcați factura';
$string['product'] = 'Produs';
$string['key'] = 'Cheie';
$string['created'] = 'Creat';
$string['seatnumber'] = 'Număr scaune';
$string['seatsused'] = 'Scaun folosit';
$string['details'] = 'Detalii';
$string['username'] = 'Nume de utilizator';
$string['used'] = 'Folosit';
$string['status'] = 'Stare';
$string['subscriptiondate'] = 'Data abonamentului';
$string['price'] = 'Preț';
$string['recurringperiod'] = 'Perioada recurentă';
$string['billingcycles'] = 'Cicluri de facturare';
$string['active'] = 'Activ';
$string['suspended'] = 'Suspendat';
$string['canceled'] = 'Anulat';
$string['expired'] = 'Expirat';
$string['process'] = 'Procesat';
$string['cancel_subscription'] = 'Anulează abonarea';
$string['sqlreport'] = 'Raport SQL';
$string['sqlreportcreate'] = 'Creează raport';
$string['sqlreports'] = 'Rapoarte SQL';
$string['sqlreportname'] = 'Nume Raport';
$string['sqlreportcode'] = 'SQL';
$string['sqlreportdate'] = 'Creat În';
$string['sqlreportactive'] = 'Activat';
$string['sqlreportinactive'] = 'Dezactivat';
$string['remove_message'] = 'Raportul SQL a fost șters';
$string['delete_message'] = 'Ștergeți raportul SQL?';
$string['success_message'] = 'Raportul SQL a fost salvat';
$string['scale_percentage_round'] = 'Procentaj rotund';
$string['instructor_show_suspended_enrollments'] = 'Afișați înscrierile suspendate';
$string['instructor_hide_suspended_enrollments'] = 'Hide suspended enrollments';
// BigBlueButton meetings
$string['bbbapiendpoint'] = 'BBB API endpoint';
$string['bbbserversecret'] = 'BBB server secret';
$string['check_active_meetings'] = 'Verificați întâlnirile active';
$string['bbbmeetings'] = 'Întâlniri BigBlueButton';
$string['enablebbbmeetings'] = 'Activați monitorizarea întâlnirilor BigBlueButton';
$string['enablebbbdebug'] = 'Modul de depanare BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_meet'] = 'Jurnal despre întâlnirile BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_meet:id'] = 'ID-ul jurnalului întâlnirii';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = 'Numele întâlnirii';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'ID-ul întâlnirii';
$string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = 'ID de întâlnire intern (pe server BBB)';
$string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = 'Crearea timpului (timestamp)';
$string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = 'Creeaza o dată (string)';
$string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = 'Numărul de extensie pentru podul vocal (utilizați dacă este conectat la sistemul de telefonie)';
$string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = 'Numărul de acces pentru apelare pe care participanții îl pot apela folosind telefonul obișnuit.';
$string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = 'Parola care va fi necesară pentru ca participanții să se alăture întâlnirii';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = 'Parola care va fi necesară pentru ca moderatorii să se alăture întâlnirii sau pentru anumite acțiuni administrative';
$string['privacy:metadata:local_intelliboard_bbb_meet:running'] = 'Starea întâlnirii (activ|oprit)';
$string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = 'Durata întâlnirii';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = 'Steag. Utilizatorii s-au alăturat întâlnirii';
$string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = 'Steag. Întâlnirea va fi înregistrată';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = 'Steag. Întâlnirea a fost încheiată cu forța';
$string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = 'Ora de începere a întâlnirii';
$string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = 'Ora de încheiere a întâlnirii';
$string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = 'Numărul de participanți';
$string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'Numărul de ascultători';
$string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'Numărul de participanți cu microfon conectat';
$string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'Numărul de participanți cu camera video conectată';
$string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = 'Numărul maxim de participanți';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'Numărul de moderatori';
$string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'ID Curs';
$string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'ID-ul modulului de Curs';
$string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'ID-ul Rândului în tabelul bigbluebuttonbn';
$string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = 'ID proprietar (utilizatorul care a creat întâlnirea)';
$string['privacy:metadata:local_intelliboard_bbb_atten'] = 'Jurnal despre participanții la întâlnirile BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_atten:id'] = 'ID participant';
$string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'ID utilizator (rând în tabelul "user")';
$string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = 'Numele complet al participantului la întâlnire';
$string['privacy:metadata:local_intelliboard_bbb_atten:role'] = 'Rolul participanților la întâlnire';
$string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = 'Steag. Participantul este prezentator';
$string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = 'Steag. Participantul nu are microfon sau cameră web conectat';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = 'Steag. Participantul are microfon conectat';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = 'Steag. Participantul are camera web conectată';
$string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = 'ID întâlnire (ID în serverul BigBlueButton)';
$string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = 'ID întâlnire (ID în tabelul local_intelliboard_bbb_meet)';
$string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'Ora când utilizatorul s-a conectat la întâlnire';
$string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'Ora când utilizatorul s-a deconectat de la întâlnire';
$string['messageprovider:intelliboard_notification'] = "Notificare Intelliboard";
$string['privacy:metadata:local_intelliboard_bb_partic'] = 'Lista participanților la sesiunea de colaborare';
$string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'ID-ul participării la sesiune';
$string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'Sesiune UUID';
$string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'Utilizator UUID (Serviciu de Colaborare cu Blackboard)';
$string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'ID Utilizator (Moodle)';
$string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'Rol sesiune';
$string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'Nume utilizator';
$string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'Primul alăturat la sesiune';
$string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'Ultimul care a părăsit sesiunea';
$string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'Timp petrecut la sesiune';
$string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'Numărul de reînscrieri la sesiune';
$string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'Lista sesiunilor urmărite';
$string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'ID-ul jurnalului de urmărire';
$string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'Sesiune UUID';
$string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = 'Timp urmărit';
$string['privacy:metadata:local_intelliboard_att_sync'] = 'Lista sesiunilor sincronizate';
$string['privacy:metadata:local_intelliboard_att_sync:id'] = 'ID-ul jurnalului de sincronizare';
$string['privacy:metadata:local_intelliboard_att_sync:type'] = 'Tip sesiune';
$string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'ID sesiune Moodle';
$string['privacy:metadata:local_intelliboard_att_sync:data'] = 'Date de sincronizare suplimentare';
$string['verifypeer'] = "CURLOPT SSL VERIFYPEER";
$string['verifypeer_desc'] = "Această opțiune determină dacă cURL-ul verifică autenticitatea certificatului din cealaltă parte a SSL.";
$string['verifyhost'] = "CURLOPT SSL VERIFYHOST";
$string['verifyhost_desc'] = "Această opțiune determină dacă libcurl verifică dacă certificatul de server este pentru serverul pe care îl cunoaște.";
$string['cipherlist'] = "CURLOPT SSL CIPHER LIST";
$string['cipherlist_desc'] = "Specificați cifrele de utilizat pentru TLS";
$string['sslversion'] = "CURLOPT SSLVERSION";
$string['sslversion_desc'] = "Treceți un parametru lung pentru a controla ce gamă de versiuni să utilizați la versiunile pentru SSL/TLS";
$string['debug'] = "Depanarea cererilor cURL";
$string['debug_desc'] = "";
/* IntelliCart */
$string['intellicart'] = "Integrare IntelliCart";
$string['intellicart_desc'] = "Permiteți studenților să vadă rapoartele IntelliCart.";
$string['coursessessionspage'] = "Pagina cu Sesiunile Cursurilor";
$string['coursessessions'] = "Sesiunile Cursurilor";
$string['session_name'] = "Numele Sesiunii";
$string['session_time'] = "Timpul Sesiunii";
$string['return_to_sessions'] = "Reveniți la Sesiuni";
$string['intellicart_student_integration'] = 'Integrare cu tabloul de bord al Studentului';
$string['intellicart_instructor_integration'] = 'Integrare cu tabloul de bord al Instructorului';
$string['intellicart_app_reports_integration'] = 'Integrare cu Rapoartele IntelliBoard';
/* IntelliCart END*/
$string['allmod'] = "Toate activitățile";
$string['customod'] = "Activități personalizate";
$string['timespent'] = "------ Timp Petrecut ----";
$string['inprogress'] = "În progres";
$string['notstarted'] = "Neînceput";
$string['modulename'] = "Nume modul";
$string['viewed'] = "Vizualizat";
$string['course'] = "Curs";
$string['courseaverage'] = "Medie Curs";
$string['mygrade'] = "Nota mea";
$string['myprogress'] = "Progresul notei mele";
$string['instructor_course_shortname'] = "Afișați numele scurt al cursului în loc la numele complet al cursului";
$string['trackmedia'] = "Urmăriți media HTML5";
$string['trackmedia_desc'] = "Urmăriți video și audio HTML5";
$string['ianalytics'] = 'Analize IntelliBoard';
$string['instructor_course_visibility'] = 'Afișați cursurile ascunse/suspendate pentru [instructor]';
$string['instructor_mode'] = 'Afișați toate cursurile disponibile pentru [instructor]';
$string['instructor_mode_access'] = 'Afișați toate cursurile disponibile pentru [instructor] cu [update] permisiuni';
$string['student_course_visibility'] = 'Afișați cursurile ascunse/suspendate pentru [student]';
$string['support_text1'] = "Toate datele Moodle: ușor, partajabil, ușor de înțeles și atractiv. IntelliBoard este un plugin Moodle care îți pune în mână <strong>120+</strong> rapoarte și monitorizări.";
$string['support_text2'] = "Toate datele Moodle: ușor, partajabil, ușor de înțeles și atractiv. IntelliBoard este soluția dvs. de raportare și analiză Moodle, oferindu-vă peste 120+ de rapoarte și analize pentru a vă ajuta să vă informați deciziile de afaceri educaționale.";
$string['support_info1'] = "Vă puteți alătura <a target='_blank' href='https://intelliboard.net/events'>Webinarii</a> în timp ce vă ducem într-un tur prin raportarea și analiza IntelliBoard 5.0!";
$string['support_info2'] = "Alăturați-vă <a target='_blank' href='https://intelliboard.net/events'>Webinariilor</a> noastre sau programați un tur personal al propriilor date. Cu asistența și serviciul nostru de clasă mondială, veți vedea LMS într-o lumină complet nouă.";
$string['support_terms'] = "Toate drepturile rezervate.";
$string['support_page'] = "Revizuirea Documentației";
$string['support_demo'] = "Programați o Demonstrație";
$string['support_trial'] = "Conectați-vă și faceți Upgrade";
$string['support_close'] = "Închide";
$string['instructor_custom_groups'] = "Grupuri personalizate de instructori";
// settings of tables
$string['table_set_icg'] = 'Cursuri Instructor';
$string['table_set_icg_c1'] = 'Nume Curs';
$string['table_set_icg_c2'] = 'Nume Scurt';
$string['table_set_icg_c3'] = 'Categorie';
$string['table_set_icg_c4'] = 'Cursanți Înscriși/Completați';
$string['table_set_icg_c5'] = 'Nota medie a cursului';
$string['table_set_icg_c6'] = 'Secțiuni';
$string['table_set_icg_c7'] = 'Activități/Resurse';
$string['table_set_icg_c8'] = 'Vizite';
$string['table_set_icg_c9'] = 'Timp Petrecut';
$string['table_set_icg_c11'] = 'Acțiuni – Activități';
$string['table_set_icg_c12'] = 'Acțiuni – Cursanți';
$string['percentage_completed_learners'] = 'Procentajul Cursanților Completați';
$string['avg_visits_per_stud'] = 'Vizite Medii per Student';
$string['avg_time_spent_per_stud'] = 'Timp Mediu Petrecut per Student';
$string['table_set_ilg'] = 'Cursuri Instructor > Cursanți';
$string['table_set_ilg_c1'] = 'Nume Cursant';
$string['table_set_ilg_c2'] = 'Adresă de E-mail';
$string['table_set_ilg_c3'] = 'Înscris';
$string['table_set_ilg_c4'] = 'Ultima Accesare';
$string['table_set_ilg_c5'] = 'Stare';
$string['table_set_ilg_c6'] = 'Notă';
$string['table_set_ilg_c7'] = 'Activități/Resurse Completate';
$string['table_set_ilg_c8'] = 'Vizite';
$string['table_set_ilg_c9'] = 'Timp Petrecut';
$string['table_set_ilg_c10'] = 'Acțiuni';
$string['table_set_ilg1'] = 'Cursuri Instructor > Cursanți > Note';
$string['table_set_ilg1_c1'] = 'Nume activitate';
$string['table_set_ilg1_c2'] = 'Tip';
$string['table_set_ilg1_c3'] = 'Notă';
$string['table_set_ilg1_c4'] = 'Notat';
$string['table_set_ilg1_c5'] = 'Stare';
$string['table_set_ilg1_c6'] = 'Vizite';
$string['table_set_ilg1_c7'] = 'Timp Petrecut';
$string['table_set_iag'] = 'Curs Instructor > Activități';
$string['table_set_iag_c1'] = 'Nume activitate';
$string['table_set_iag_c2'] = 'Tip';
$string['table_set_iag_c3'] = 'Cursanți Completați';
$string['table_set_iag_c4'] = 'Nota Medie';
$string['table_set_iag_c5'] = 'Vizite';
$string['table_set_iag_c6'] = 'Timp Petrecut';
$string['table_set_iag_c7'] = 'Acțiuni';
$string['table_set_iag1'] = 'Cursuri Instructor > Activități > Note';
$string['table_set_iag1_c1'] = 'Nume Cursant';
$string['table_set_iag1_c2'] = 'Adresă de E-mail';
$string['table_set_iag1_c3'] = 'Stare';
$string['table_set_iag1_c4'] = 'Notă';
$string['table_set_iag1_c5'] = 'Notat';
$string['table_set_iag1_c6'] = 'Vizite';
$string['table_set_iag1_c7'] = 'Timp Petrecut';
$string['student_grades'] = 'Notele Studentului';
$string['grid_view'] = 'Vizualizare Grilă';
$string['list_view'] = 'Vizualizare Listă';
$string['grade_activities_overview'] = 'Prezentare Generală a Activităților Notate';
$string['activity'] = 'Activitate';
$string['date_format'] = 'Format dată';
$string['user_enrollments_sessions_completion'] = 'Înscriere utilizator, Sesiune, Niveluri de Activitate de Finalizare';
$string['user_site_summary_detail'] = 'Detalii Rezumat Sit al Utilizatorului';
$string['course_enrollment_types'] = 'Tipuri de Înscriere la Curs';
$string['user_map'] = 'Harta Utilizatorului';
$string['course_enrollments_with_completion_overview'] = 'Înscrieri la Curs cu Prezentare Generală de Finalizare';
$string['all_modules'] = 'Toate modulele';

/* Attendance */
$string['attendance'] = 'Attendance';
$string['enableattendance'] = 'Permiteți Attendance';
$string['attendancetoolurl'] = 'Instrument URL';
$string['attendanceconsumerkey'] = 'Cheia consumatorului';
$string['attendancesharedsecret'] = 'Secret împărtășit';
$string['sync_data_with_attendance'] = 'Sincronizați datele cu Attendance';
$string['attendanceapibase'] = 'Calea de bază a API-ului Attendance';
$string['attendanceapikey'] = 'Cheie API al Attendance';
$string['attendanceapisecret'] = 'Secretul Attendance API';
$string['enablesyncattendance'] = 'Activați sincronizarea sesiunilor BB Collaborate cu InAttendance';
/* BlackBoard Collaborate and InAttendance */
$string['bb_col_meetings'] = 'Întâlniri BlackBoard Collaborate';
$string['enable_bb_col_debug'] = 'Activați depanarea la Blackboard Collaborate';
$string['bb_col_api_endpoint'] = 'Punct final API Blackboard Collaborate';
$string['bb_col_consumer_key'] = 'Cheia consumatorului pentru BlackBoard Collaborate';
$string['bb_col_secret'] = 'BlackBoard Collaborate secret';
$string['enable_bb_col_meetings'] = 'Activați întâlnirile prin BlackBoard Collaborate';
$string['check_active_bb_col_meetings'] = 'Verificați întâlnirile active prin Blackboard Collaborate';
$string['local_intelliboard_bb_collaborate_session_tracking_started'] = 'A început urmărirea sesiunii de colaborare BB';
$string['local_intelliboard_bb_collaborate_session_tracking_finished'] = 'Finalizarea urmăririi sesiunii de colaborare BB';
$string['local_intelliboard_bb_collaborate_api_request_finished'] = 'Cerere API finalizată pentru colaborarea BB';

/* Admin dashboard */
$string['admin_dashboard'] = 'Tablou de bord Administrator';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'Înscriere Utilizator, Sesiune, Niveluri de Activitate de Finalizare';
$string['adm_dshb_adm_dashb_totals'] = 'Totaluri';
$string['adm_dshb_user_site_summary_details'] = 'Detalii Rezumat Sit al Utilizatorului';
$string['adm_dshb_course_enrollments_types'] = 'Tipuri de Înscriere la Curs';
$string['adm_dshb_user_map'] = 'Harta Utilizatorului';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'Înscrieri la Curs cu Prezentare Generală de Finalizare';
$string['adm_dshb_report_user_status'] = 'Report User status';
$string['adm_dshb_report_activity_stats_summary'] = 'Report Activity Stats Summary';
$string['adm_dshb_report_quiz_activity_detail'] = 'Report Quiz Activity Detail';

$string['instructor_hide_need_help'] = 'Ascundeți butonul „Ai nevoie de ajutor?”';
$string['names_order'] = 'Ordinea numelor';
$string['firstname_lastname'] = '{First Name} {Last Name}';
$string['lastname_firstname'] = '{Last Name} {First Name}';
$string['issuer'] = 'Emitent';
$string['criteria_method'] = 'Metoda criteriilor';
$string['criteria_all_courses'] = 'Toate cursurile următoare trebuiesc finalizate';
$string['criteria_any_course'] = 'Oricare dintre următoarele cursuri trebuiesc finalizate';
$string['dashboard_settings'] = 'Setări Tablou de bord';


$string['tracklogs'] = 'Urmăriți Timpul de către Utilizator - Zilnic';
$string['trackdetails'] = 'Urmăriți Timpul de către Utilizator - La fiecare oră';
$string['tracktotals'] = 'Urmăriți Timpul Agregat - Zilnic';

$string['enable_badges_report'] = 'Activați raportul „Insigne”';
$string['sizemode'] = 'Mod Dimensiune: Larg ( > 5,000 Utilizatori)';
$string['cachedef_bb_collaborate_access_token'] = 'Token de acces BB Collaborate';


$string['learner_menu'] = 'Afișați „Tabloul de bord pentru Cursanți” în meniul Bloc-ului de Navigare numai pentru cursanții înscriși';
$string['learning_plan_filter'] = 'Filtrul Planului de Învățare';
$string['learning_plan_viewer_role'] = 'Rolul „Vizualizarea Planului de Învățare”';
$string['all_cohorts'] = 'Toate cohortele';
$string['privacy_shield_policy'] = 'Procesarea Datelor Addendum';
$string['privacy_policy'] = 'Politica de Confidențialitate';
$string['confirm_and_sign_up'] = 'Confirmați și Înscrieți-vă';
$string['term_of_use'] = 'Termeni de Utilizare';
$string['setup'] = 'Conectează-te Acum';
$string['protocol'] = 'Protocol';
$string['rest'] = 'REST';
$string['soap'] = 'SOAP';
$string['next'] = 'Următorul';
$string['terms_msg'] = 'Bifând această casetă confirmați că ați citit și sunteți de acord cu Termenii noștri de Utilizare.';
$string['privacy_msg'] = 'Bifând această casetă confirmați că ați citit și sunteți de acord cu Politica noastră de Confidențialitate.';
$string['shield_msg'] = 'Bifând această casetă confirmați că ați citit și sunteți de acord cu Addendum-ul nostru privind Prelucrarea Datelor.';
$string['enable_webservice'] = 'Activați serviciile web';
$string['you_need_to_enable_at_least_one_protocol'] = 'Trebuie să activați cel puțin un protocol';
$string['invalid_user'] = 'Utilizator invalid';
$string['sign_in'] = 'Loghează-te';
$string['email'] = 'Email';
$string['password'] = 'Parola';
$string['all_fields_required'] = 'Toate câmpurile sunt necesare';
$string['server_error'] = 'Hopa! S-a întâmplat ceva neașteptat. Vă rugăm să ne contactați la support@intelliboard.net';
$string['country'] = 'Țară';
$string['please_accept_terms_and_conditions'] = 'Vă rugăm să acceptați termenii și condițiile';
$string['congratulations_intb_register'] = 'Felicitări';
$string['congratulations_intb_register_msg'] = 'Vă mulțumim că ați început încercarea gratuită de 15 zile cu IntelliBoard! Vă rugăm să vă verificați e-mailul pentru a vă confirma contul IntelliBoard. Pentru început, utilizați linkul Single Sign On (SSO), dacă este activat din Administrarea Site-ului > IntelliBoard sau conectați-vă <a href="https://app.intelliboard.net/signin">aici</a>. Link-ul SSO citește „INTELLIBOARD.NET” și se află în colțul din dreapta sus al Tabloului de bord. Pentru întrebări, vă rugăm să ne contactați la Support@IntelliBoard.net.';
$string['sign_up'] = 'Inscrie-te';
$string['sign_in'] = 'Loghează-te';
$string['intelliboard_settings'] = 'Setări IntelliBoard';
$string['moodle_settings'] = 'Setări Moodle';
$string['email_is_required'] = 'Email-ul este necesar';
$string['invalid_email'] = 'Email invalid';
$string['intelliboard_terms'] = 'Acorduri IntelliBoard';
$string['authentication'] = 'Crearea Contului';
$string['intb_settings_descr'] = "IntelliBoard necesită un e-mail de abonament principal, unic. Vă rugăm să introduceți mai jos e-mailul pe care doriți să îl utilizați ca e-mail de abonament. E-mailul trebuie verificat dublu printr-o confirmare prin e-mail înainte de utilizare. Pentru întrebări, vă rugăm să ne contactați la <a href='mailto:Support@IntelliBoard.net'>Support@IntelliBoard.net</a>. Pentru o listă completă a setărilor IntelliBoard, accesați Administrarea Site-ului > Plugin-uri > Plugin-uri locale > IntelliBoard";
$string['hosting_provider'] = 'Furnizor de Găzduire';
$string['self_hosted'] = 'Găzduit de Sine';

// date formats
$string['mysqlweek'] = '%Y, săptămâna %v';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlyear'] = '%Y';
$string['mysqlmonth'] = '%c';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlquarter'] = 'sfert';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';

$string['postgreweek'] = 'AAAA, "săptămâna" SS';
$string['postgremonthyear'] = 'Luna AAAA';
$string['postgreyear'] = 'AAAA';
$string['postgremonth'] = 'LL';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgrequarter'] = 'sfert';
$string['postgredayshortmonthyear'] = 'ZZ Luna, AAAA';
$string['postgretimedate'] = 'HH12:MI AM, ZZ Luna AAAA';
$string['postgredaymonth'] = 'ZZ Luna AAAA';
$string['postgremonthyearday'] = 'Luna AAAA, ZZ';
$string['postgrequarteryear'] = 'Q AAAA';
$string['postgremonthdayyear'] = 'LL/ZZ/AAAA';
$string['postgretimemonthdayyear'] = 'HH24 LL/ZZ/AAAA';

// new strings
$string['report1_name'] = 'Stare Utilizator';
$string['report2_name'] = 'Statistici de Curs';
$string['report3_name'] = 'Rezumatul Statisticilor de Activitate';
$string['report45_name'] = 'Detalii despre Activitățile de Test';
$string['report_activity_stats_summary'] = 'Rezumatul Statisticilor de Activitate';
$string['report_user_profile_information'] = 'Informații Profil Utilizator';
$string['course_name'] = 'Nume Curs';
$string['course_short_name'] = 'Numele Scurt al Cursului';
$string['course_idnumber'] = 'Număr ID';
$string['course_status'] = 'Stare';
$string['number_of_learners'] = '# de Utilizator(i) Înrolați';
$string['number_of_modules'] = '# de Activitate(ăți)';
$string['number_of_completed_learners'] = '# de Utilizator(i) Completați';
$string['number_of_visits'] = 'Vizită(e)';
$string['num_completed_activity'] = '# de Utilizatori Care Au Completat Această Activitate';
$string['total_time_spent'] = 'Timp Total Petrecut';
$string['date_created'] = 'Data Creării';
$string['initial_reports'] = 'Rapoarte Inițiale';
$string['avg_score'] = 'Scor Mediu';
$string['first_access'] = 'Primul Acces';
$string['completion_not_enabled'] = 'Finalizarea Nu Este Activată';
$string['first_name'] = 'Prenume';
$string['last_name'] = 'Nume';
$string['num_attempts'] = '# de Încercări';
$string['highest_grade'] = 'Nota cea mai mare';
$string['lowest_grade'] = 'Nota cea mai mică';
$string['initial_reports_warning'] = 'Pentru a trimite prin e-mail, programa și personaliza în continuare aceste rapoarte, dați clic pe „<a href="{$a}">Conectați-vă și faceți Upgrade</a>”.';
$string['last_access'] = 'Ultimul Acces';
$string['enrolment_expiration'] = 'Expirarea Înscrierii';
$string['id_number'] = 'Număr ID';
$string['telephone1'] = 'Telefon 1';
$string['telephone2'] = 'Telefon 2';
$string['institution'] = 'Instituţie';
$string['department'] = 'Departament';
$string['address'] = 'Adresă';
$string['city'] = 'Oraș';
$string['enroled_on'] = 'Data Înscrierii';

$string['dashboard_link'] = 'Faceți clic pentru a vedea Analiticile';
$string['support_connect'] = 'Faceți clic pe butoanele de raportare din dreptunghiul de mai jos. Aruncați o privire asupra puterii IntelliBoard: acces cu 1 buton la informațiile dvs. LMS. Vreți mai mult? Faceți clic pe „Faceți clic pentru a vizualiza Analiticile”. Vreți și mai mult? <a href="{$a-> connect_link}">„Conectare și Upgrade”</a> în colțul din dreapta sus sau oriunde vedeți linkul.';
$string['support_text3'] = 'Thank you for installing IntelliBoard Lite!';
$string['support_text4'] = 'Meet an easy-to-use reporting and visualization platform that will help you achieve your retention, engagement, and compliance goals.';
$string['support_text6'] = 'Aveți nevoie de mai multe informații? Faceți clic pe oricare dintre butoanele albastre pentru a vă conecta.';

$string['web_services_descr'] = 'IntelliBoard necesită activarea serviciilor web. Serviciile web permit altor sisteme (de exemplu, IntelliBoard) să acceseze acest sistem LMS și să preforme operațiunile. Din motive de securitate, acest lucru ar trebui să fie dezactivat atunci când nu este utilizat. Pentru o examinare suplimentară, accesați Administrarea Site-ului > Funcții avansate > Servicii web';
$string['protocol_descr'] = 'IntelliBoard necesită ca Protocolul REST sau SOAP să fie activat. Din motive de securitate, ar trebui activate numai protocoalele utilizate. Pentru o examinare suplimentară, accesați Administrarea Site-ului > Plugin-uri > Servicii web > Gestionați protocoalele';
$string['authorized_user_descr'] = 'IntelliBoard necesită un utilizator Autorizat. Utilizatorul Autorizat va fi probabil un Administrator de Site și trebuie să aibă privilegii pentru a gestiona servicii web, protocoale și token-uri. Pentru o revizuire suplimentară, accesați Administrarea Site-ului > Pluginuri > Servicii web > Servicii externe > Serviciu IntelliBoard > Utilizator Autorizat';
$string['email_subscr'] = 'E-mail de abonament';
$string['protocols_descr'] = 'IntelliBoard necesită ca Protocolul REST sau SOAP Protocol să fie activat. Din motive de securitate, ar trebui activate numai protocoalele utilizate. Pentru o examinare suplimentară, accesați Administrarea Site-ului > Plugin-uri > Servicii web > Gestionați protocoalele';
$string['enable_time_tracking'] = 'Activați Urmărirea Timpului';
$string['enable_time_tracking_descr'] = 'Activați urmărirea timpului pentru informații suplimentare privind accesul utilizatorilor, vizitele și timpul petrecut. IntelliBoard oferă informații suplimentare despre urmărirea timpului separat de tabelele de timp petrecut ale Moodle.';
$string['enable_sso'] = 'Activați link-ul Single Sign On (SSO)';
$string['enable_sso_descr'] = 'Activați link-ul Single Sign On pentru accesul cu un singur clic pentru Administratorii Site-ului în accesul IntelliBoard SuperAdmin de pe aplicație.';
$string['join_a_webinar'] = 'Alăturăte unui Webinar';
$string['review_support_doc'] = 'Consultați Documentația de Asistență';
$string['setup_subheading'] = 'Conectați-vă pentru a experimenta puterea datelor dvs. Fără card de credit. Fără obligații. Doar 15 zile gratuite de fericire a datelor.';

$string['instructor_courses_table_name'] = 'Note Curs';
$string['instructor_courses_table_name_learner'] = 'Curs {$a->course}, Cursant {$a->learner}, Note';
$string['instructor_courses_table_name_activity'] = 'Curs {$a->course}, Activitate {$a->name}, Note';
$string['instructor_courses_table_name_learners'] = 'Curs {$a->fullname}, Cursanți';
$string['instructor_courses_table_name_activities'] = 'Curs {$a->fullname}, Activități';

$string['successfull_connected'] = 'Conectat cu Succes';
$string['not_connected'] = 'Nu sunteți conectat';

$string['transcripts'] = 'Transcrieri';
$string['enable_transcripts'] = 'Activați Transcrierile';
$string['closed'] = 'Închis';
$string['synctranscriptstask'] = 'Sincronizare Sarcini Transcrieri';
$string['transcriptssyncrecordsnum'] = 'Dimensiunea Procesării Transcrierilor';
$string['transcriptssyncrecordsnum_desc'] = 'Numărul de înregistrări ale utilizatorilor înrolați care vor fi procesate simultan';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'Transcrieri înregistrări cursuri';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'ID Utilizator';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'Email utilizator';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'Prenume utilizator';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'Nume utilizator';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'Transcrie ID-ul utilizatorului înscris';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'Înscrieți ID-ul înregistrării';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'Metodă înscriere';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'ID Curs';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = 'Nume Curs complet';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'Data Înscrierii';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'Data Revocării Înscrierii';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'Data Finalizării';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'Stare Transcrieri';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'ID articol Notă';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = 'ID Notă';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'Nota Max';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'Nota Min';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'Nota Finală';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'Nota Formatată';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'Roluri Utilizator';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'Grupuri Utilizator';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'Marcaj de timp la crearea înregistrării';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'Marcaj de timp când înregistrarea a fost actualizată ultima dată';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'Transcrieri înregistrări cursuri';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'Transcrie ID-ul utilizatorului înscris';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'ID Curs';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'ID Utilizator';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'ID Modul Curs';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'ID Modul';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Nume Activitate';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Tip Modul';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Data de început';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Data finalizării';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Stare';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'ID articol Notă';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = 'ID Notă';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'Nota Max';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'Nota Min';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Nota Finală';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'Nota Formatată';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'Marcaj de timp la crearea înregistrării';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'Marcaj de timp când înregistrarea a fost actualizată ultima dată';
$string['goal_grade'] = 'Nota Țintă';
$string['importtrackingtask'] = 'Importați Sarcina de Urmărire';
$string['compresstracking'] = 'Comprimă Urmărirea';
$string['compresstracking_desc'] = 'Scrieți date de Urmărire a Timpului în fișier sau redis și transferați date în baza de date cu job cron (implicit: la fiecare 15 minute)';
$string['cachedef_instructor_course_data'] = 'Cache pentru datele cursului';
$string['cachedef_reports_list'] = 'Cache pentru lista de rapoarte';
$string['do_not_use_compresstracking'] = 'Nu utilizatți Comprimă Urmărirea';
$string['cache_compresstracking'] = 'Salvați în memoria Cache Moodle';
$string['file_compresstracking'] = 'Salvați în MoodleData';
$string['cachedef_tracking'] = 'Date de Urmărire Intelliboard';
$string['cachedef_track_config'] = 'Urmărirea datelor totale al Intelliboard';
$string['coursecontainer_filter'] = 'Enable course container filter';
$string['enableexportcustomfont'] = 'Font compatibil japonez/China';
$string['all_selected'] = 'Toate selectate';
$string['custommenuitem'] = 'Display in Custom Menu';
$string['support_text7'] = 'To get started with <strong>IntelliBoard Lite</strong>, please <a href="{$a->meeting_link}">schedule a consultation</a> with one of our learning analytics experts.';
$string['support_text8'] = 'If you have <strong>already purchased</strong> a license and see this screen, please contact your Account Manager for assistance.';
$string['support_text9'] = 'Need predictive models, notifications, and intervention tracking?';
$string['support_text10'] = 'Switch to <a href="{$a->intelliboard_pro_link}"><strong>IntelliBoard Pro</strong></a>';
$string['support_text11'] = '<a href="{$a->intelliboard_pro_onepager}">Click here</a> to download the IntelliBoard Pro one-pager.';
$string['enable_vendor_frontpage_course'] = 'Enable the frontpage course in the reports for vendors';
$string['pagelayout'] = 'Theme page layout';
