<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * English language strings
 *
 * @package    local_courseflowtool
 * @copyright  2025 Jeremie Choquette
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['pluginname'] = 'CourseFlow Tool';
$string['courseflowtool:view'] = 'View CourseFlow tool plugin';
$string['courseflowtool_test'] = 'Test CourseFlow tool plugin';

// import_tool.php
$string['general_instructions'] = 'To import from CourseFlow, navigate to your course in CourseFlow, then click the \'...\' in the top bar. Click \'Moodle Plugin\', then either generate an import URL or generate JSON code. Paste the result in the corresponding box below then click the import button.';
$string['import_json'] = 'Import from JSON';
$string['import_json_instructions'] = 'Copy and paste the JSON code generated by CourseFlow here';
$string['json_import_title'] = 'Import CourseFlow JSON';
$string['jsoninput_placeholder'] = 'Paste your JSON here...';
$string['jsoninput_button'] = 'Import from JSON';
$string['json_process_error'] = 'Error processing JSON';
$string['usecourseflowstyle'] = 'Use CourseFlow styling for imported lessons';
$string['associateoutcomes'] = 'Associate outcomes with lessons (may create many grade items)';
$string['url_input_label'] = 'Import from URL';
$string['import_url_instructions'] = 'Copy and paste the URL generated by CourseFlow here';
$string['urlinput_button'] = 'Import from URL';
$string['import_options'] = 'Options';
$string['open_help_page'] = 'Open Help Page';

// process_json.php
$string['json_process_invalid'] = 'Invalid JSON data.';
$string['json_process_decode_error'] = 'Error decoding JSON.';

// preview_import.php
$string['preview_title'] = 'Preview CourseFlow Import';
$string['section'] = "Section";
$string['lesson'] = "Lesson";
$string['outcome'] = "Outcome";
$string['sections'] = "Sections";
$string['lessons'] = "Lessons";
$string['outcomes'] = "Outcomes";
$string['label_overwrite'] = 'Overwrite existing topic label (if applicable)';
$string['confirm_import'] = 'Confirm and Import';
$string['no_data_preview'] = 'No data to preview. Please go back and upload JSON first.';
$string['returntocourse'] = 'Return to course';
$string['select_all'] = 'Select/Deselect All';

// finalize_import.php

$string['no_data'] = 'No data found in session.';
$string['error'] = 'Error';
$string['error_finalize'] = 'Error finalizing import';
$string['import_success'] = 'Import completed successfully! Created';

// privacy/provider.php

$string['privacy:metadata'] = 'No data tied to a specific user is stored. Settings are tied to the Moodle course and its CourseFlow origin course, but not to an individual user. Data input by the user is stored only temporarily during the construction of Moodle objects. It is also not tied to a specific user in any way.';

// db/caches.php
$string['cachedef_courseflow_import_data'] = 'CourseFlow Tool import data';

// help page
$string['help_title'] = 'CourseFlow Tool Help';
$string['help_intro'] = 'This tool allows you to import structured JSON data from CourseFlow into your Moodle course, creating lessons and outcomes automatically. CourseFlow is a free course and program design tool available at ';
$string['help_step1_title'] = 'Step 1: Generate Your Data in CourseFlow';
$string['help_courseflow'] = 'To begin, create your course in CourseFlow as normal. Then while viewing your course click the (...) button in the top left of the page and select "Moodle Plugin". This will bring you to the page where you can set up your course to export to Moodle. There are two ways to export to Moodle. The first is to generate JSON code which can be pasted into the CourseFlow Tool Plugin. This code must be generated every time you make changes in CourseFlow, but can be done while keeping your course entirely private. The alternative is to generate an import URL. This requires you to have generated a public link to your workflow (allowing anyone with the link to view it). Then, in the Moodle Plugin menu, you\'ll see an import URL which the plugin can use to automatically fetch the data from CourseFlow.';
$string['help_intro_image_alt'] = 'CourseFlow Moodle Plugin menu';

$string['help_step2_title'] = 'Step 2: Import Your Data';
$string['help_step2-1_desc'] = 'Navigate to the CourseFlow Tool plugin to begin the import process. This can be found in the navigation block under your course administration settings.';
$string['help_step2-1_image_alt'] = 'The course navigation block';
$string['help_step2-2_desc'] = 'You can either paste the raw JSON data or provide your URL in the appropriate text field, the click the corresponding import button. If you provide a URL, the plugin will remember this URL for you and you will not need to provide it again if you want to re-import or update the data.';
$string['help_step2-2_image_alt'] = 'Provide JSON or URL screen';

$string['help_options_desc'] = 'You can optionally enable CourseFlow styling and control whether outcomes are associated with grade items. ';
$string['help_option_styling'] = 'Enable CourseFlow styling for imported lessons. This will change the way the imported lessons appear to look more like CourseFlow nodes. It will not alter the appearance of lessons created through other means. If you want to change this in the future, simply rerun the import and the associations will be added or removed as desired.';
$string['help_option_outcomes'] = 'Associate outcomes with lessons. Moodle allows outcomes to be associated with lessons, however when this is done a grade item is created for each association. By default, the plugin will not associate the outcomes with lessons in order to avoid cluttering the gradebook, though the outcomes will still appear on the main page of the lesson. If you want to change this in the future, simply rerun the import and the associations will be added or removed as desired.';


$string['help_step3_title'] = 'Step 3: Preview Your Import';
$string['help_step3_desc'] = 'A preview of all lessons and outcomes will be shown. You can toggle selections for import if there are parts of the course you do not want to import. When you are finished, click \'Confirm and Import\' at the top of the preview. The CourseFlow Tool plugin stores the ids of all the lessons and outcomes it generates and their corresponding values in the CourseFlow database. If you import the same course twice, it will update the existing lessons and outcomes instead of importing them again. Note that in order to avoid accidental deletion of your data, it will not delete any lessons or outcomes that are missing in the new import. Removing outcomes from lessons may, however, remove grade items created from the association of the outcome with that lesson which can result in the loss of data you have entered for that grade item. This only applies if you have selected the optional setting to associate outcomes with lessons.';
$string['help_step3_image_alt'] = 'Preview of lessons and outcomes';

$string['help_confirm_title'] = 'Step 4: Final Confirmation';
$string['help_confirm_desc'] = 'The plugin should now confirm the number of sections, lessons, and outcomes it has generated. You may continue to your course page.';

