/**
 * IDE Control
 *
 * @copyright 2017 Juan Carlos Rodríguez-del-Pino
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @author Juan Carlos Rodríguez-del-Pino <jcrodriguez@dis.ulpgc.es>
 */
define("mod_vpl/vplide",["jquery","jqueryui","core/url","mod_vpl/vplutil","mod_vpl/vplui","mod_vpl/vplidefile","mod_vpl/vplidebutton","mod_vpl/vplterminal","mod_vpl/vplvnc"],(function($,jqui,coreURL,VPLUtil,VPLUI,VPLFile,VPLIDEButtons,VPLTerminal,VPLVNCClient){if(void 0!==VPLIDE)return VPLIDE;var vplIdeInstance,VPLIDE=function(rootId,options){var fileManager,adjustTabsTitles,autoResizeTab,showErrorMessage,updateMenu,executionActions,self=this,minNumberOfFiles=options.minfiles||0,maxNumberOfFiles=options.maxfiles||0,restrictedEdit=options.restrictededitor||options.example,readOnly=options.example,readOnlyFiles=options.readOnlyFiles,isTeacher=options.isTeacher,fullScreen=!1,scrollBarWidth=VPLUI.scrollBarWidth(),str=VPLUtil.str,rootObj=$("#"+rootId);if($("head").append('<meta name="viewport" content="initial-scale=1">').append('<meta name="viewport" width="device-width">').append('<link rel="stylesheet" href="'+coreURL.relativeUrl("/mod/vpl/editor/VPLIDE.css")+'"/>'),"object"!=typeof rootObj)throw new Error("VPL: constructor tag_id not found");var activateModification,optionsToCheck={new:!0,rename:!0,delete:!0,save:!0,run:!0,edit:!0,debug:!0,evaluate:!0,import:!0,resetfiles:!0,sort:!0,multidelete:!0,showparentfiles:!0,acetheme:!0,console:!0,comments:!0};void 0===options.loadajaxurl&&(options.loadajaxurl=options.ajaxurl),activateModification=minNumberOfFiles<maxNumberOfFiles,options.new=activateModification,options.rename=activateModification,options.delete=activateModification,options.comments=options.comments&&!options.example,options.acetheme=!0,options.sort=maxNumberOfFiles-minNumberOfFiles>=2,options.multidelete=options.sort,options.import=!restrictedEdit;var isOptionAllowed=function(op){return!optionsToCheck[op]||options[op]};function dragoverHandler(e){e.originalEvent.dataTransfer.dropEffect=restrictedEdit?"none":"copy",e.preventDefault()}function dropHandler(e){if(restrictedEdit)return e.stopImmediatePropagation(),!1;for(var droppedFiles=[],listDroppedFiles=function(entry){let path=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"";return new Promise((function(resolve){if(entry.isFile)entry.file((function(file){var fullName=path+file.name;Object.defineProperty(file,"name",{get:function(){return fullName}}),droppedFiles.push(file),resolve()}));else if(entry.isDirectory){entry.createReader().readEntries((function(entries){for(var dirPromises=[],i=0;i<entries.length;i++)dirPromises.push(listDroppedFiles(entries[i],path+entry.name+"/"));Promise.all(dirPromises).then(resolve).catch((function(err){VPLUtil.log("Error reading directory entries: "+err)}))}))}else resolve()}))},dt=e.originalEvent.dataTransfer,promises=[],i=0;i<dt.items.length;i++){var entry=dt.items[i].webkitGetAsEntry();if(entry)(entry.isFile||entry.isDirectory)&&promises.push(listDroppedFiles(entry));else{const file=dt.items[i].getAsFile();file&&(entry={isFile:!0,isDirectory:!1,file:function(callback){callback(file)}},promises.push(listDroppedFiles(entry)))}}return dt.files.length>0&&(Promise.all(promises).then((function(){VPLUI.readSelectedFiles(droppedFiles,(function(file){return fileManager.addFile(file,!0,updateMenu,showErrorMessage)}),(function(){fileManager.fileListVisibleIfNeeded()}))})).catch((function(err){VPLUtil.log("Error processing dropped files: "+err)})),e.stopImmediatePropagation(),!1)}function restrictedPaste(e){return!restrictedEdit||(e.stopPropagation(),!1)}options.console=isOptionAllowed("run")||isOptionAllowed("debug"),void 0===options.fontSize&&(options.fontSize=12),options.fontSize=parseInt(options.fontSize),rootObj.on("drop",dropHandler),rootObj.on("dragover",dragoverHandler);var menu=$("#vpl_menu"),menuButtons=new VPLIDEButtons(menu,isOptionAllowed),tr=$("#vpl_tr"),fileListContainer=$("#vpl_filelist"),fileList=$("#vpl_filelist_header"),fileListContent=$("#vpl_filelist_content"),tabsUl=$("#vpl_tabs_ul"),tabs=$("#vpl_tabs"),resultContainer=$("#vpl_results"),result=$("#vpl_results_accordion"),renameDiretoryAction=VPLUtil.doNothing;fileListContainer.vplMinWidth=80,resultContainer.vplMinWidth=100,this.updateEvaluationNumber=function(res){if(void 0!==res.nevaluations){var text=res.nevaluations;void 0!==res.reductionbyevaluation&&res.reductionbyevaluation>""&&0!=res.reductionbyevaluation&&(0!=res.freeevaluations&&(text=text+"/"+res.freeevaluations),text=text+" -"+res.reductionbyevaluation),menuButtons.setExtracontent("evaluate",text)}},this.lastResult=null,this.getTerminal=function(){return terminal},this.setResultGrade=function(content,raw){var titleclass="vpl_ide_accordion_t_grade";if(0==result.find(".vpl_ide_accordion_c_grade").length&&(result.append('<div class="'+titleclass+'"></div>'),result.append('<div class="vpl_ide_accordion_c_grade"></div>')),void 0===raw)return result.find("h4."+titleclass).length>0;var titleTag=result.find("."+titleclass);return content>""?(titleTag.replaceWith('<h4 class="'+titleclass+'">'+content+"</h4>"),!0):(titleTag.replaceWith('<div class="'+titleclass+'"></div>'),!1)},this.setResultTab=function(name,content,raw){var titleclass="vpl_ide_accordion_t_"+name,contentclass="vpl_ide_accordion_c_"+name;if(0==result.find("."+contentclass).length&&(result.append('<div class="'+titleclass+'"></div>'),result.append('<div class="'+contentclass+'"></div>')),void 0===raw)return result.find("h4."+titleclass).length>0;var titleTag=result.find("."+titleclass),contentTag=result.find("."+contentclass),HTMLcontent=$("<div>"+content+"</div>");return HTMLcontent.find("h4").replaceWith((function(){return $("<h5>").append($(this).contents())})),contentTag.html()==HTMLcontent.html()?content>"":content>""?(titleTag.replaceWith('<h4 class="'+titleclass+'">'+str(name)+"</h4>"),contentTag.replaceWith('<div class="ui-widget '+contentclass+'">'+HTMLcontent.html()+"</div>"),!0):(titleTag.replaceWith('<div class="'+titleclass+'"></div>'),contentTag.replaceWith('<div class="'+contentclass+'"></div>'),!1)},this.applyMathJax=function(){if("object"==typeof window.MathJax)try{let math=result.find(".vpl_ide_accordion_c_description")[0];math&&(window.MathJax.Hub&&window.MathJax.Hub.Queue?window.MathJax.Hub.Queue(["Typeset",window.MathJax.Hub,math]):window.MathJax.startup&&window.MathJax.startup.promise&&(window.MathJax.startup.promise=window.MathJax.startup.promise.then((()=>window.MathJax.typesetPromise([math]))).catch((e=>{VPLUtil.log("MathJax error"+e)}))))}catch(e){VPLUtil.log("MathJax error"+e)}},this.setResult=function(res,go){self.updateEvaluationNumber(res);var i,files=fileManager.getFiles(),fileNames=[];for(i=0;i<files.length;i++)fileNames[i]=files[i].getFileName(),files[i].clearAnnotations();var hasContent,gradeShow,formated,show=!1,grade=VPLUtil.sanitizeText(res.grade);if(gradeShow=self.setResultGrade(grade,res.grade),show=show||gradeShow,hasContent=self.setResultTab("variables",res.variables,res.variables),show=show||hasContent,formated=VPLUtil.processResult(res.compilation,fileNames,files,!0,!1),hasContent=self.setResultTab("compilation",formated,res.compilation),show=show||hasContent,formated=VPLUtil.processResult(res.evaluation,fileNames,files,!1,!1),hasContent=self.setResultTab("comments",formated,res.evaluation),show=show||hasContent,formated=VPLUtil.sanitizeText(res.execution),hasContent=self.setResultTab("execution",formated,res.execution),show=show||hasContent,(hasContent=self.setResultTab("description",window.VPLDescription,window.VPLDescription))&&self.applyMathJax(),show=show||hasContent){for(resultContainer.show(),resultContainer.vplVisible=!0,result.accordion("refresh"),result.accordion("option","active",gradeShow?1:0),i=0;i<files.length;i++)for(var anot=files[i].getAnnotations(),j=0;j<anot.length;j++)if(go||"error"==anot[j].type){fileManager.gotoFile(i,anot[j].row+1);break}$("#vpl_ide_shrightpanel").show()}else resultContainer.hide(),resultContainer.vplVisible=!1,$("#vpl_ide_shrightpanel").hide();VPLUtil.delay("autoResizeTab",autoResizeTab),VPLUtil.delay("fixAccordion",(function(){result.accordion("option","active",gradeShow?1:0)}))},result.accordion({heightStyle:"fill",header:"h4",animate:!1,beforeActivate:function(event,ui){return!("newHeader"in ui)||!ui.newHeader.hasClass("vpl_ide_accordion_t_grade")}}),resultContainer.width(2*resultContainer.vplMinWidth),result.on("click","a",(function(event){fileManager.gotoFileLink(event.currentTarget)&&event.preventDefault()})),resultContainer.vplVisible=!1,resultContainer.hide(),fileListContainer.addClass("ui-tabs ui-widget ui-widget-content ui-corner-all"),fileList.text(str("filelist")),fileList.html(VPLUI.iconFolder()+fileList.html()),fileList.addClass("ui-widget-header ui-button-text-only ui-corner-all"),fileListContent.addClass("ui-widget ui-corner-all"),fileListContainer.width(2*fileListContainer.vplMinWidth),fileListContainer.on("click","a",(function(event){event.preventDefault(),fileManager.gotoFileLink(event.currentTarget)})),fileListContainer.vplVisible=!1,fileListContainer.hide();var tabsAir=!1;function getTabsAir(){return!1===tabsAir&&(tabsAir=(tabs.outerWidth(!0)-tabs.width())/2),tabsAir}function resizeTabWidth(e,ui){var maxWidth,diffLeft=ui.position.left-ui.originalPosition.left;if(0!==diffLeft)maxWidth=tabs.width()+fileListContainer.width()-fileListContainer.vplMinWidth,tabs.resizable("option","maxWidth",maxWidth),fileListContainer.width(fileListContainer.vplOriginalWidth+diffLeft);else{maxWidth=tabs.width()+resultContainer.width()-resultContainer.vplMinWidth,tabs.resizable("option","maxWidth",maxWidth);var diffWidth=ui.size.width-ui.originalSize.width;resultContainer.width(resultContainer.vplOriginalWidth-diffWidth)}fileManager.currentFile("adjustSize")}var resizableOptions={containment:"parent",resize:resizeTabWidth,start:function(){$(window).off("resize",autoResizeTab),tabs.resizable("option","minWidth",100),resultContainer.vplVisible&&(resultContainer.vplOriginalWidth=resultContainer.width()),fileListContainer.vplVisible&&(fileListContainer.vplOriginalWidth=fileListContainer.width())},stop:function(e,ui){resizeTabWidth(0,ui),tabs.resizable("option","maxWidth",1e5),tabs.resizable("option","minWidth",0),autoResizeTab(),$(window).on("resize",autoResizeTab)},handles:""};function focusCurrentFile(){fileManager.currentFile("focus")}tabs.resizable(resizableOptions),adjustTabsTitles=function(center){var newWidth=tabs.width(),tabsUlWidth=0;tabsUl.width(1e5);var last=tabsUl.children("li:visible").last();if(last.length){var parentScrollLeft=tabsUl.parent().scrollLeft();tabsUlWidth=parentScrollLeft+last.position().left+last.width()+tabsAir,tabsUl.width(tabsUlWidth);var file=fileManager.currentFile();if(file&&center){var fileTab=$(file.getTabNameId()),scroll=parentScrollLeft+fileTab.position().left;(scroll-=(newWidth-fileTab.outerWidth())/2)<0&&(scroll=0),tabsUl.parent().finish().animate({scrollLeft:scroll},"slow")}}tabsUlWidth<newWidth&&tabsUl.width("")},autoResizeTab=function(){var index,oldWidth=tabs.width(),newWidth=menu.width(),planb=!1;if(index=0,index+=fileListContainer.vplVisible?1:0,index+=resultContainer.vplVisible?2:0,tabs.resizable("destroy"),resizableOptions.handles=["e","w","e","e, w"][index],resizableOptions.disable=0===index,tabs.resizable(resizableOptions),tr.width(menu.outerWidth()),fileListContainer.vplVisible){var left=fileListContainer.outerWidth()+tabsAir;oldWidth+=left,left>=100?(newWidth-=left,tabs.css("left",left)):planb=!0}else tabs.css("left",0);if(resultContainer.vplVisible){var right=resultContainer.outerWidth()+tabsAir;oldWidth+=right,(newWidth-=right)<100&&(planb=!0)}if(planb){var rel=menu.width()/oldWidth,wfl=0;fileListContainer.vplVisible&&(wfl=fileListContainer.width()*rel,fileListContainer.width(wfl-tabsAir),wfl+=tabsAir,tabs.css("left",wfl)),tabs.width(tabs.width()*rel),resultContainer.vplVisible&&resultContainer.width(menu.width()-(wfl+tabs.width()+tabsAir))}else tabs.width(newWidth);adjustTabsTitles(!0),function(){var newHeight=$(window).outerHeight();(newHeight-=menu.offset().top+menu.height()+(fullScreen?getTabsAir():20))<250&&(newHeight=250),tr.height(newHeight);var panelHeight=newHeight-3*getTabsAir();tabs.height(panelHeight),resultContainer.vplVisible&&(resultContainer.height(panelHeight+getTabsAir()),result.accordion("refresh")),fileListContainer.vplVisible&&(fileListContent.height(panelHeight-(fileList.outerHeight()+getTabsAir())),fileListContainer.height(panelHeight))}(),fileManager.currentFile("adjustSize")};var dialogbaseOptions=$.extend({},{close:focusCurrentFile},VPLUI.dialogbaseOptions);function showMessage(message,options){return VPLUI.showMessage(message,$.extend({},dialogbaseOptions,options))}showErrorMessage=function(message){return VPLUI.showErrorMessage(message,{close:focusCurrentFile})};var dialogNew=$("#vpl_ide_dialog_new");function newFileHandler(event){if("click"!=event.type&&("keypress"!=event.type||13!=event.keyCode))return!0;dialogNew.dialog("close");var file={name:$("#vpl_ide_input_newfilename").val(),contents:"",encoding:0},newfile=fileManager.addFile(file,!1,updateMenu,showErrorMessage);return!!newfile&&(fileManager.open(newfile),tabs.tabs("option","active",fileManager.getTabPos(newfile.getId())),newfile.focus(),!0)}var dialogButtons={};dialogButtons[str("ok")]=newFileHandler,dialogButtons[str("cancel")]=function(){$(this).dialog("close")},dialogNew.find("input").on("keypress",newFileHandler),dialogNew.dialog($.extend({},dialogbaseOptions,{title:str("create_new_file"),buttons:dialogButtons})),VPLUI.setDialogTitleIcon(dialogNew,"new");var dialogRename=$("#vpl_ide_dialog_rename");function renameHandler(event){("click"==event.type||"keypress"==event.type&&13==event.keyCode)&&(dialogRename.dialog("close"),fileManager.renameFile(fileManager.currentFile("getFileName"),$("#vpl_ide_input_renamefilename").val(),showErrorMessage),event.preventDefault())}dialogRename.find("input").on("keypress",renameHandler),dialogButtons[str("ok")]=renameHandler,dialogRename.dialog($.extend({},dialogbaseOptions,{open:function(){$("#vpl_ide_input_renamefilename").val(fileManager.currentFile("getFileName"))},title:str("rename_file"),buttons:dialogButtons})),VPLUI.setDialogTitleIcon(dialogRename,"rename");var dialogRenameDirectory=$("#vpl_ide_dialog_renamedir");function renameDirectoryHandler(event){("click"==event.type||"keypress"==event.type&&13==event.keyCode)&&(dialogRenameDirectory.dialog("close"),fileManager.renameDirectory($("#vpl_ide_input_olddirectoryname").val(),$("#vpl_ide_input_renamedirectory").val(),showErrorMessage),event.preventDefault())}dialogRenameDirectory.find("input").on("keypress",renameDirectoryHandler),dialogButtons[str("ok")]=renameDirectoryHandler,dialogRenameDirectory.dialog($.extend({},dialogbaseOptions,{title:str("rename_directory"),buttons:dialogButtons})),VPLUI.setDialogTitleIcon(dialogRenameDirectory,"filelist"),renameDiretoryAction=function(event){if(event.target.hasAttribute("data-dirname")){var dirname=event.target.getAttribute("data-dirname");$("#vpl_ide_input_olddirectoryname").val(dirname),$("#vpl_ide_input_renamedirectory").val(dirname),dialogRenameDirectory.dialog("open")}};var dialogComments=$("#vpl_ide_dialog_comments"),oldStudentComments="";dialogButtons[str("ok")]=function(){oldStudentComments!=$("#vpl_ide_input_comments").val()&&fileManager.setModified(),$(this).dialog("close")},dialogComments.dialog($.extend({},dialogbaseOptions,{open:function(){oldStudentComments=$("#vpl_ide_input_comments").val()},title:str("comments"),width:"40em",buttons:dialogButtons})),VPLUI.setDialogTitleIcon(dialogComments,"comments"),$("#vpl_ide_input_comments").width("30em");var aboutDialog=$("#vpl_ide_dialog_about"),OKButtons={};OKButtons[str("ok")]=function(){$(this).dialog("close")};var shortcutDialog=$("#vpl_ide_dialog_shortcuts");shortcutDialog.dialog($.extend({},dialogbaseOptions,{open:function(){var html=menuButtons.getShortcuts(fileManager.currentFile("getEditor"));$("#vpl_ide_dialog_shortcuts").html(html)},title:str("shortcuts"),width:400,height:300,buttons:OKButtons})),shortcutDialog.dialog("option","height",300),VPLUI.setDialogTitleIcon(shortcutDialog,"shortcuts"),OKButtons[str("shortcuts")]=function(){$(this).dialog("close"),shortcutDialog.dialog("open")},aboutDialog.dialog($.extend({},dialogbaseOptions,{open:function(){var html=menuButtons.getShortcuts(fileManager.currentFile("getEditor"));aboutDialog.next().find("button").filter((function(){return $(this).text()==str("shortcuts")})).button(""!=html?"enable":"disable")},title:str("about"),width:400,height:300,buttons:OKButtons})),aboutDialog.dialog("option","height",300),VPLUI.setDialogTitleIcon(aboutDialog,"about");var dialogSort=$("#vpl_ide_dialog_sort"),dialogSortButtons={};dialogSortButtons[str("ok")]=function(){var files=fileManager.getFiles(),regNoNumber=/[^\d]*/,sorted=[],i=0,newOrder=$("#vpl_sort_list li");if(newOrder.length==files.length){for(newOrder.each((function(){var orig=parseInt(this.id.replace(regNoNumber,""));sorted.push(files[orig])})),i=0;i<newOrder.length;i++)files[i]=sorted[i];fileManager.setModified(),$(this).dialog("close")}},dialogSortButtons[str("cancel")]=function(){$(this).dialog("close")},dialogSort.dialog($.extend({},dialogbaseOptions,{title:str("sort"),buttons:dialogSortButtons,open:function(){var list=$("#vpl_sort_list");list.html("");for(var files=fileManager.getFiles(),i=0;i<files.length;i++){var file=$('<li id="vpl_fsort_'+i+'"class="ui-widget-content"></li>');files[i].getId()<minNumberOfFiles&&file.addClass("ui-state-disabled"),file.text(i+1+"-"+files[i].getFileName()),list.append(file)}list.sortable({items:"li:not(.ui-state-disabled)",placeholder:"ui-state-highlight",start:function(event,ui){ui.item.addClass("ui-state-highlight")},stop:function(event,ui){ui.item.removeClass("ui-state-highlight")}}),list.disableSelection()},maxHeight:400})),VPLUI.setDialogTitleIcon(dialogSort,"sort");var dialogMultidelete=$("#vpl_ide_dialog_multidelete"),dialogMultideleteButtons={};dialogMultideleteButtons[str("selectall")]=function(){$(this).find("input").prop("checked",!0)},dialogMultideleteButtons[str("deselectall")]=function(){$(this).find("input").prop("checked",!1)},dialogMultideleteButtons[str("deleteselected")]=function(){var files=fileManager.getFiles(),toDeleteList=[];$("#vpl_multidelete_list label").each((function(){var label=$(this);if(label.find("input").prop("checked")){var id=label.data("fileid");toDeleteList.push(files[id].getFileName())}}));for(var i=0;i<toDeleteList.length;i++)fileManager.deleteFile(toDeleteList[i],showErrorMessage);VPLUtil.delay("updateMenu",updateMenu),VPLUtil.delay("updateFileList",fileManager.updateFileList),$(this).dialog("close")},dialogMultideleteButtons[str("cancel")]=function(){$(this).dialog("close")},dialogMultidelete.dialog($.extend({},dialogbaseOptions,{title:str("multidelete"),buttons:dialogMultideleteButtons,open:function(){var list=$("#vpl_multidelete_list");list.html("");for(var files=fileManager.getFiles(),i=minNumberOfFiles;i<files.length;i++){var name=VPLUtil.sanitizeText(files[i].getFileName()),file=$('<label><input type="checkbox"> '+name+"</label>");file.data("fileid",i),list.append(file),list.append("<br>")}list.find("label").button()},maxHeight:400,maxWidth:400})),VPLUI.setDialogTitleIcon(dialogMultidelete,"multidelete");var dialogFontsize=$("#vpl_ide_dialog_fontsize"),fontsizeSlider=$("#vpl_ide_dialog_fontsize .vpl_fontsize_slider"),dialogFontFizeButtons={};dialogFontFizeButtons[str("ok")]=function(){var value=fontsizeSlider.slider("value");fileManager.setFontSize(value),$(this).dialog("close"),VPLUtil.setUserPreferences({fontSize:value})},dialogFontFizeButtons[str("cancel")]=function(){fileManager.setFontSize(fontsizeSlider.data("vpl_fontsize")),$(this).dialog("close")},dialogFontFizeButtons[str("reset")]=function(){fontsizeSlider.slider("value",12)},dialogFontsize.dialog($.extend({},dialogbaseOptions,{title:str("fontsize"),buttons:dialogFontFizeButtons,open:function(){fontsizeSlider.data("vpl_fontsize",fileManager.getFontSize()),fontsizeSlider.slider("value",fileManager.getFontSize())}})),fontsizeSlider.slider({min:1,max:48,change:function(){var value=fontsizeSlider.slider("value");fileManager.setFontSize(value),dialogFontsize.find(".vpl_fontsize_slider_value").text(value)}}),VPLUI.setDialogTitleIcon(dialogFontsize,"fontsize");var dialogAceTheme=$("#vpl_ide_dialog_acetheme"),acethemeSelect=$("#vpl_ide_dialog_acetheme select"),dialogAceThemeButtons={};dialogAceThemeButtons[str("ok")]=function(){fileManager.setTheme(acethemeSelect.val()),$(this).dialog("close"),VPLUtil.setUserPreferences({aceTheme:acethemeSelect.val()})},dialogAceThemeButtons[str("cancel")]=function(){fileManager.setTheme(acethemeSelect.data("acetheme")),$(this).dialog("close")},dialogAceThemeButtons[str("reset")]=function(){acethemeSelect.val(acethemeSelect.data("acetheme")),fileManager.setTheme(acethemeSelect.val())},dialogAceTheme.dialog($.extend({},dialogbaseOptions,{title:str("theme"),buttons:dialogAceThemeButtons,modal:!1,open:function(){acethemeSelect.data("acetheme",fileManager.getTheme()),acethemeSelect.val(fileManager.getTheme())}})),acethemeSelect.on("change",(function(){fileManager.setTheme(acethemeSelect.val())})),VPLUI.setDialogTitleIcon(dialogAceTheme,"theme");var terminal=new VPLTerminal("vpl_dialog_terminal","vpl_terminal",str),VNCClient=new VPLVNCClient("vpl_dialog_vnc",str),lastConsole=terminal,fileSelect=$("#vpl_ide_input_file");function resetFiles(){VPLUI.requestAction("resetfiles","",{},options.ajaxurl).done((function(response){var files=response.files;for(var fileName in files)files.hasOwnProperty(fileName)&&fileManager.addFile(files[fileName],!0,VPLUtil.doNothing,showErrorMessage);fileManager.fileListVisibleIfNeeded(),VPLUtil.delay("updateMenu",updateMenu)})).fail(showErrorMessage)}fileSelect.on("change",(function(){VPLUI.readSelectedFiles(this.files,(function(file){return fileManager.addFile(file,!0,updateMenu,showErrorMessage)}),(function(){fileManager.fileListVisibleIfNeeded()}))})),menuButtons.add({name:"filelist",originalAction:function(){fileManager.fileListVisible(!fileManager.isFileListVisible()),VPLUtil.delay("updateMenu",updateMenu),VPLUtil.delay("autoResizeTab",autoResizeTab),VPLUtil.delay("updateFileList",fileManager.updateFileList)},bindKey:{win:"Ctrl-L",mac:"Ctrl-L"}}),menuButtons.add({name:"new",originalAction:function(){fileManager.length()<maxNumberOfFiles&&dialogNew.dialog("open")},bindKey:{win:"Alt-N",mac:"Option-N"}}),menuButtons.add({name:"rename",originalAction:function(){var file=fileManager.currentFile();file&&file.getId()>=minNumberOfFiles&&dialogRename.dialog("open")},bindKey:{win:"Ctrl-R",mac:"Ctrl-R"}}),menuButtons.add({name:"delete",originalAction:function(){var file=fileManager.currentFile();if(file){var filename=file.getFileName();showMessage(str("delete_file_fq",filename),{ok:function(){fileManager.deleteFile(filename,showErrorMessage)},title:str("delete_file_q"),icon:"trash"})}},bindKey:{win:"Ctrl-D",mac:"Ctrl-D"}}),menuButtons.add({name:"close",originalAction:function(){var file=fileManager.currentFile();file&&fileManager.closeFile(file)},bindKey:{win:"Alt-W",mac:"Option-W"}}),menuButtons.add({name:"import",originalAction:function(){fileSelect.val(""),fileSelect.trigger("click")},bindKey:{win:"Ctrl-I",mac:"Ctrl-I"}}),menuButtons.add({name:"sort",originalAction:function(){dialogSort.dialog("open")},bindKey:{win:"Ctrl-O",mac:"Ctrl-O"}}),menuButtons.add({name:"multidelete",originalAction:function(){dialogMultidelete.dialog("open")}}),menuButtons.add({name:"showparentfiles",originalAction:function(){openpopup(null,{url:options.showparentfilesurl,options:"width="+Math.max(screen.availWidth/2,780)+",height="+screen.availHeight+",left="+screen.availWidth/4})}}),menuButtons.add({name:"fontsize",originalAction:function(){dialogFontsize.dialog("open")}}),menuButtons.add({name:"theme",originalAction:function(){dialogAceTheme.dialog("open")}}),menuButtons.add({name:"print",originalAction:function(){window.print()},bindKey:{win:"Alt-P",mac:"Command-P"}}),menuButtons.add({name:"undo",originalAction:function(){fileManager.currentFile("undo")}}),menuButtons.add({name:"redo",originalAction:function(){fileManager.currentFile("redo")}}),menuButtons.add({name:"select_all",editorName:"selectall",originalAction:function(){fileManager.currentFile("selectAll")}}),menuButtons.add({name:"find",originalAction:function(){fileManager.currentFile("find")}}),menuButtons.add({name:"find_replace",editorName:"replace",originalAction:function(){fileManager.currentFile("replace")}}),menuButtons.add({name:"next",editorName:"findnext",originalAction:function(){fileManager.currentFile("next")}}),menuButtons.add({name:"fullscreen",originalAction:function(){fullScreen?(rootObj.removeClass("vpl_ide_root_fullscreen"),$("body").removeClass("vpl_body_fullscreen"),menuButtons.setText("fullscreen","fullscreen"),$("#vpl_ide_user").hide(),fullScreen=!1):($("body").addClass("vpl_body_fullscreen").scrollTop(0),rootObj.addClass("vpl_ide_root_fullscreen"),menuButtons.setText("fullscreen","regularscreen"),options.username&&$("#vpl_ide_user").show(),fullScreen=!0),focusCurrentFile(),setTimeout(autoResizeTab,10)},bindKey:{win:"Alt-F",mac:"Ctrl-F"}}),menuButtons.add({name:"download",originalAction:function(){window.location=options.download}}),menuButtons.add({name:"resetfiles",originalAction:function(){showMessage(str("sureresetfiles"),{title:str("resetfiles"),ok:resetFiles,icon:"resetfiles"})}});var noconfirmation=!1;function executionRequest(action,acting,data){data||(data={}),lastConsole.isConnected()||VPLUI.requestAction(action,"",data,options.ajaxurl).done((function(response){VPLUI.webSocketMonitor(response,action,acting,executionActions)})).fail(showErrorMessage)}function runAction(){executionRequest("run","running",{XGEOMETRY:VNCClient.getCanvasSize(),currentFileName:fileManager.getCurrentFileName()})}function debugAction(){executionRequest("debug","debugging",{XGEOMETRY:VNCClient.getCanvasSize(),currentFileName:fileManager.getCurrentFileName()})}function evaluateAction(){executionRequest("evaluate","evaluating")}menuButtons.add({name:"save",originalAction:function(){var data={files:fileManager.getFilesToSave(),comments:$("#vpl_ide_input_comments").val(),version:noconfirmation?-1:fileManager.getVersion()};JSON.stringify(data).length>options.postMaxSize?showErrorMessage(str("maxpostsizeexceeded")):function doSave(){VPLUI.requestAction("save","saving",data,options.ajaxurl).done((function(response){if(response.requestsconfirmation&&!noconfirmation){var $checkbox,donotshowagain='<input type="checkbox" id="vpl_donotshowagain" class="align-text-bottom mr-1 mt-3"><label for="vpl_donotshowagain">'+str("donotshowagain")+"</label>";showMessage(response.question+"<br>"+donotshowagain,{title:str("saving"),icon:"alert",yes:function(){1==$checkbox.length&&$checkbox.prop("checked")&&(noconfirmation=!0),data.version=0,doSave()}}),$checkbox=$("#vpl_donotshowagain")}else fileManager.resetModified(),fileManager.setVersion(response.version),menuButtons.setTimeLeft(response),VPLUtil.delay("updateMenu",updateMenu),VPLUI.monitorRunning()&&(data.processid=VPLUtil.getProcessId(),VPLUI.requestAction("update","updating",data,options.ajaxurl))})).fail(showErrorMessage)}()},bindKey:{win:"Ctrl-S",mac:"Command-S"}}),menuButtons.add({name:"run",originalAction:function(){executionActions.setLastAction(runAction),runAction()},bindKey:{win:"Ctrl-F11",mac:"Command-U"}}),menuButtons.add({name:"debug",originalAction:function(){executionActions.setLastAction(debugAction),debugAction()},bindKey:{win:"Alt-F11",mac:"Option-U"}}),menuButtons.add({name:"evaluate",originalAction:function(){executionActions.setLastAction(evaluateAction),evaluateAction()},bindKey:{win:"Shift-F11",mac:"Command-Option-U"}}),menuButtons.add({name:"comments",originalAction:function(){dialogComments.dialog("open")}}),menuButtons.add({name:"console",originalAction:function(){lastConsole.isOpen()?lastConsole.close():lastConsole.show()}}),menuButtons.add({name:"user"}),menuButtons.add({name:"about",originalAction:function(){aboutDialog.dialog("open")}}),menuButtons.add({name:"timeleft",originalAction:function(){menuButtons.toggleTimeLeft()}}),menuButtons.add({name:"more",originalAction:function(){var tag=$("#vpl_ide_menuextra");tag.is(":visible")?(menuButtons.setText("more","more",VPLUtil.str("more")),tag.hide()):(menuButtons.setText("more","less",VPLUtil.str("less")),tag.show()),VPLUtil.delay("updateMenu",updateMenu),VPLUtil.delay("autoResizeTab",autoResizeTab)}}),menuButtons.add({name:"shrightpanel",icon:"close-rightpanel",originalAction:function(){resultContainer.vplVisible?(resultContainer.hide(),resultContainer.vplVisible=!1,menuButtons.setText("shrightpanel","open-rightpanel",VPLUtil.str("shrightpanel"))):(menuButtons.setText("shrightpanel","close-rightpanel",VPLUtil.str("shrightpanel")),resultContainer.show(),resultContainer.vplVisible=!0),VPLUtil.delay("autoResizeTab",autoResizeTab)},bindKey:{win:"Ctrl-M",mac:"Ctrl-M"}});tr.append('<span style="position:absolute;right:0;top:60px;z-index:100;margin:3px">'+menuButtons.getHTML("shrightpanel")+"</span>");var rightPanelButton=$("#vpl_ide_shrightpanel");menuButtons.setText("shrightpanel","close-rightpanel",VPLUtil.str("shrightpanel")),rightPanelButton.button(),rightPanelButton.css("padding","0"),$("#vpl_ide_shrightpanel.ui-button-text").css("padding","0"),rightPanelButton.on("click",(function(){menuButtons.launchAction("shrightpanel")})),rightPanelButton.hide(),menu.addClass("ui-widget-header ui-corner-all");var menuHtml="";menuHtml+=menuButtons.getHTML("more"),menuHtml+=menuButtons.getHTML("save"),menuHtml+="<span id='vpl_ide_mexecution'>",menuHtml+=menuButtons.getHTML("run"),menuHtml+=menuButtons.getHTML("debug"),menuHtml+=menuButtons.getHTML("evaluate"),menuHtml+=menuButtons.getHTML("comments"),menuHtml+=menuButtons.getHTML("console"),menuHtml+="</span> ",menuHtml+="<span id='vpl_ide_menuextra'>",menuHtml+="<span id='vpl_ide_file'>",menuHtml+=menuButtons.getHTML("filelist"),menuHtml+=menuButtons.getHTML("new"),menuHtml+=menuButtons.getHTML("rename"),menuHtml+=menuButtons.getHTML("delete"),menuHtml+=menuButtons.getHTML("import"),menuHtml+=menuButtons.getHTML("download"),menuHtml+=menuButtons.getHTML("resetfiles"),menuHtml+=menuButtons.getHTML("sort"),menuHtml+=menuButtons.getHTML("multidelete"),menuHtml+=menuButtons.getHTML("showparentfiles"),menuHtml+=menuButtons.getHTML("fontsize"),menuHtml+=menuButtons.getHTML("theme"),menuHtml+="</span> ",menuHtml+="<span id='vpl_ide_edit'>",menuHtml+=menuButtons.getHTML("undo"),menuHtml+=menuButtons.getHTML("redo"),menuHtml+=menuButtons.getHTML("select_all"),menuHtml+=menuButtons.getHTML("find"),menuHtml+=menuButtons.getHTML("find_replace"),menuHtml+=menuButtons.getHTML("next"),menuHtml+="</span> ",menuHtml+="</span> ",menuHtml+=menuButtons.getHTML("fullscreen")+" ",menuHtml+=menuButtons.getHTML("about")+" ",menuHtml+=menuButtons.getHTML("user")+" ",menuHtml+=menuButtons.getHTML("timeleft"),menuHtml+='<div class="clearfix"></div>',menu.append(menuHtml),$("#vpl_ide_more").button(),$("#vpl_ide_save").button(),$("#vpl_ide_menuextra").hide(),$("#vpl_ide_file").controlgroup(),$("#vpl_ide_edit").controlgroup(),$("#vpl_ide_mexecution").controlgroup(),$("#vpl_ide_fullscreen").button(),$("#vpl_ide_acetheme").button(),$("#vpl_ide_about").button(),$("#vpl_ide_user").button().css("float","right").hide(),$("#vpl_ide_timeleft").button().css("float","right").hide(),$("#vpl_menu .ui-button").css("padding","6px"),$("#vpl_menu .ui-button-text").css("padding","0");for(var alwaysActive=["filelist","more","fullscreen","about","resetfiles","download","comments","console","import","fontsize","timeleft"],i=0;i<alwaysActive.length;i++)menuButtons.enable(alwaysActive[i],!0);menuButtons.setExtracontent("user",options.username),menuButtons.setTimeLeft(options),updateMenu=function(){var i,file=fileManager.currentFile(),nfiles=fileManager.length();nfiles?tabs.show():tabs.hide(),fileManager.isFileListVisible()?menuButtons.setText("filelist","filelistclose",VPLUtil.str("filelist")):menuButtons.setText("filelist","filelist",VPLUtil.str("filelist"));var modified=fileManager.isModified();menuButtons.enable("save",modified);var sel,running=VPLUI.monitorRunning();if(running?menuButtons.setText("run","running"):menuButtons.setText("run","run"),menuButtons.enable("run",!running&&(!modified||options.example)&&isOptionAllowed("run")),menuButtons.enable("debug",!running&&(!modified||options.example)&&isOptionAllowed("debug")),menuButtons.enable("evaluate",!running&&(!modified||options.example)&&isOptionAllowed("evaluate")),menuButtons.enable("download",!modified),menuButtons.enable("new",nfiles<maxNumberOfFiles),menuButtons.enable("sort",nfiles-minNumberOfFiles>1),menuButtons.enable("multidelete",nfiles-minNumberOfFiles>1),menuButtons.enable("showparentfiles",!modified),menuButtons.enable("theme",!0),file&&0!==nfiles)menuButtons.enable("rename",file.getId()>=minNumberOfFiles&&0!==nfiles),menuButtons.enable("delete",file.getId()>=minNumberOfFiles&&0!==nfiles),menuButtons.enable("undo",file.hasUndo()),menuButtons.enable("redo",file.hasRedo()),menuButtons.enable("select_all",file.hasSelectAll()),menuButtons.enable("find",file.hasFind()),menuButtons.enable("find_replace",file.hasFindReplace()),menuButtons.enable("next",file.hasNext()),VPLUtil.delay("updateFileList",fileManager.updateFileList);else for(sel=["rename","delete","undo","redo","select_all","find","find_replace","next"],i=0;i<sel.length;i++)menuButtons.enable(sel[i],!1)},executionActions={open:updateMenu,close:updateMenu,getConsole:function(){return lastConsole},setResult:self.setResult,ajaxurl:options.ajaxurl,run:function(content,coninfo,ws){var parsed=/^([^:]*):?(.*)/.exec(content),type=VPLUtil.sanitizeText(parsed[1]);if("terminal"==type||"webterminal"==type){if(lastConsole&&lastConsole.isOpen()&&lastConsole.close(),lastConsole=terminal,terminal.connect(coninfo.executionURL,(function(){ws.close(),focusCurrentFile()})),"webterminal"==type){var URLfavicon=(coninfo.secure?"https":"http")+"://"+coninfo.server+":"+coninfo.portToUse;URLfavicon+="/favicon.ico";var imgFavicon=$("<img>");imgFavicon.attr("src",URLfavicon),imgFavicon.attr("style","display:none"),$("body").append(imgFavicon)}}else if("vnc"==type)lastConsole&&lastConsole.isOpen()&&lastConsole.close(),lastConsole=VNCClient,VNCClient.connect(coninfo.secure,coninfo.server,coninfo.portToUse,coninfo.VNCpassword,coninfo.executionPath,(function(){ws.close(),focusCurrentFile()}));else if("browser"==type){var URL=(coninfo.secure?"https":"http")+"://"+coninfo.server+":"+coninfo.portToUse+"/";URL+=VPLUtil.sanitizeText(parsed[2])+"/httpPassthrough",isTeacher&&(URL+="?private");var message='<a href="'+URL+'" target="_blank">';showMessage(message+=VPLUtil.str("open")+"</a>",{width:200,icon:"run",title:VPLUtil.str("run")})}else VPLUtil.log("Type of run error "+content,!0)},lastAction:!1,getLastAction:function(){var ret=this.lastAction;return this.lastAction=!1,ret},setLastAction:function(action){this.lastAction=action}},tabs.on("tabsactivate",(function(){fileManager.currentFile("focus"),VPLUtil.delay("updateMenu",updateMenu),VPLUtil.delay("autoResizeTab",autoResizeTab)}));var jw=$(window);jw.on("resize",autoResizeTab),options.example||jw.on("beforeunload",(function(){if(fileManager.isModified())return str("changesNotSaved")})),fileManager=new function(){var tabsUl=$("#vpl_tabs_ul");$("#vpl_tabs").tabs();var version,tabs=$("#vpl_tabs").tabs("widget"),files=[],openFiles=[],modified=!0,self=this;function fileNameIncluded(name){for(var checkName=name.toLowerCase()+"/",i=0;i<files.length;i++){var nameMod=files[i].getFileName().toLowerCase()+"/";if(0===nameMod.indexOf(checkName)||0===checkName.indexOf(nameMod))return!0}return!1}function twoBlockly(oldname,newname){if(VPLUtil.isBlockly(oldname))return!1;if(VPLUtil.isBlockly(newname))for(var i=0;i<files.length;i++)if(VPLUtil.isBlockly(files[i].getFileName()))return!0;return!1}self.setVersion=function(v){version=v},self.getVersion=function(){return version},this.updateFileList=function(){self.generateFileList()},this.fileNameExists=function(name){for(var checkName=name.toLowerCase(),i=0;i<files.length;i++)if(files[i].getFileName().toLowerCase()==checkName)return i;return-1},this.restrictedPaste=restrictedPaste,this.dropHandler=dropHandler,this.dragoverHandler=dragoverHandler,this.readOnly=readOnly,this.readOnlyFiles=readOnlyFiles,this.restrictedEdit=restrictedEdit,this.adjustTabsTitles=adjustTabsTitles,this.minNumberOfFiles=minNumberOfFiles,this.scrollBarWidth=scrollBarWidth;var localClipboard="";this.setClipboard=function(t){localClipboard=t},this.getClipboard=function(){return localClipboard},this.getTabPos=function(fileId){for(var i=0;i<openFiles.length;i++)if(openFiles[i].getId()==fileId)return i;return openFiles.length},this.getTheme=function(){return options.theme},this.setTheme=function(theme){options.theme=theme;for(var i=0;i<files.length;i++)files[i].setTheme(theme)},this.addTab=function(fid){var hlink='<a href="#vpl_file'+fid+'"></a>';tabsUl.append('<li id="vpl_tab_name'+fid+'">'+hlink+"</li>"),tabs.append('<div id="vpl_file'+fid+'" class="vpl_ide_file"></div>')},this.removeTab=function(fid){tabsUl.find("#vpl_tab_name"+fid).remove(),tabs.find("#vpl_file"+fid).remove()},this.isReadOnly=function(fileName){return this.readOnly||-1!=this.readOnlyFiles.indexOf(fileName)},this.open=function(pos){var file;if(!(file="object"==typeof pos?pos:files[pos]).isOpen()){var fid=file.getId();self.addTab(fid),openFiles.push(file),menuButtons.setGetkeys(file.open()),tabs.tabs("refresh"),adjustTabsTitles(!1),VPLUtil.delay("updateFileList",self.updateFileList),VPLUtil.delay("updateMenu",updateMenu)}},this.closeFile=function(file){if(file.isOpen()){var pos,fid=file.getId();file.close(),VPLUI.hideIDEStatus(),self.removeTab(fid);var ptab=self.getTabPos(fid);return openFiles.splice(ptab,1),tabs.tabs("refresh"),adjustTabsTitles(!1),self.fileListVisible(!0),VPLUtil.delay("updateFileList",self.updateFileList),VPLUtil.delay("adjustTabsTitles",adjustTabsTitles,!1),openFiles.length==ptab&&ptab--,ptab>=0&&openFiles.length>ptab?(pos=self.getFilePosById(openFiles[ptab].getId()),void self.gotoFile(pos,"c")):void 0}},this.isClosed=function(pos){return!files[pos].isOpen()},this.fileListVisible=function(b){b!==fileListContainer.vplVisible&&(b?VPLUtil.delay("fileListVisible",(function(){fileListContainer.vplVisible=!0,self.updateFileList(),fileListContainer.show(),autoResizeTab()})):VPLUtil.delay("fileListVisible",(function(){fileListContainer.vplVisible=!1,fileListContainer.hide(),autoResizeTab()})))},this.isFileListVisible=function(){return fileListContainer.vplVisible},this.fileListVisibleIfNeeded=function(){if(!this.isFileListVisible())for(var i=0;i<files.length;i++)if(!files[i].isOpen())return void this.fileListVisible(!0)},this.setFontSize=function(size){options.fontSize=size;for(var i=0;i<files.length;i++)files[i].setFontSize(size);terminal.setFontSize(size)},this.getFontSize=function(){return options.fontSize},this.addFile=function(file,replace,ok,showError){if("string"!=typeof file.name||!VPLUtil.validPath(file.name))return showError(str("incorrect_file_name")+"\n("+file.name+")"),!1;!0!==replace&&(replace=!1);var pos=this.fileNameExists(file.name);if(-1!=pos)return replace&&!files[pos].isReadOnly()?(files[pos].setContent(file.contents),self.setModified(),ok(),VPLUtil.delay("updateFileList",self.updateFileList),file):(showError(str("filenotadded",file.name)),!1);if(fileNameIncluded(file.name)||twoBlockly("",file.name))return showError(str("filenotadded",file.name)),!1;if(files.length>=maxNumberOfFiles)return showError(str("maxfilesexceeded")+"\n("+maxNumberOfFiles+")"),!1;var fid=VPLUtil.getUniqueId(),newfile=new VPLFile(fid,file.name,file.contents,this,vplIdeInstance);return 1==file.encoding?newfile.extendToBinary():VPLUtil.isBlockly(file.name)?newfile.extendToBlockly():newfile.extendToCodeEditor(),newfile.setFileName(file.name),files.push(newfile),self.setModified(),files.length>5&&self.fileListVisible(!0),ok(),newfile},this.renameFile=function(oldname,newname,showError){var pos=this.fileNameExists(oldname);try{if(-1==pos)throw new Error("Internal error: File name not found");if(files[pos].getId()<this.minNumberOfFiles)throw new Error("Internal error: Renaming requested filename");if(files[pos].getFileName()==newname)return!0;if(!VPLUtil.validPath(newname)||fileNameIncluded(newname)||twoBlockly(oldname,newname))throw str("incorrect_file_name");if(VPLUtil.isBinary(oldname)&&VPLUtil.fileExtension(oldname)!=VPLUtil.fileExtension(newname))throw str("incorrect_file_name");if(VPLUtil.isBlockly(oldname)!=VPLUtil.isBlockly(newname)){if(files[pos].getContent()>"")showMessage(str("delete_file_fq",oldname),{ok:function(){var file={name:newname,contents:"",encoding:0};fileManager.deleteFile(oldname,showError),fileManager.addFile(file,!1,updateMenu,showErrorMessage)&&fileManager.gotoFileName(newname)}});else{var file={name:newname,contents:"",encoding:0};fileManager.deleteFile(oldname,showError),fileManager.addFile(file,!1,updateMenu,showError)&&fileManager.gotoFileName(newname)}return!0}files[pos].setFileName(newname)}catch(e){return showError(str("filenotrenamed",oldname)+"\n"+e),!1}return self.setModified(),adjustTabsTitles(!1),VPLUtil.delay("updateFileList",self.updateFileList),!0},this.directoryExists=function(dirName){for(var checkName=dirName.toLowerCase()+"/",i=0;i<files.length;i++)if(files[i].getFileName().toLowerCase().startsWith(checkName))return!0;return!1},this.renameDirectory=function(oldName,newName,showError){if(oldName==newName)return!1;try{if(!this.directoryExists(oldName))throw new Error("Trying to rename a directory that doesn't exist: "+oldName);if(!VPLUtil.validPath(newName+"/file.txt"))throw str("incorrect_directory_name");var i,oldNameLength=oldName.length+1,checkDirName=oldName.toLowerCase()+"/",newFileNames=[];for(i=0;i<files.length;i++){var fileName=files[i].getFileName();if(fileName.toLowerCase().startsWith(checkDirName)){if(files[i].getId()<this.minNumberOfFiles)throw str("incorrect_file_name");newFileNames[i]=newName+"/"+fileName.substr(oldNameLength)}}if(this.directoryExists(newName)){var oldNames=[];for(i=0;i<files.length;i++)oldNames[files[i].getFileName().toLowerCase()]=!0;for(i=0;i<files.length;i++)if(newFileNames[i]&&oldNames[newFileNames[i].toLowerCase()])throw str("incorrect_file_name")}for(i=0;i<newFileNames.length;i++)newFileNames[i]&&files[i].setFileName(newFileNames[i])}catch(e){return showError(str("directory_not_renamed",oldName)+"\n"+e),!1}return self.setModified(),adjustTabsTitles(!1),VPLUtil.delay("updateFileList",self.updateFileList),!0},this.deleteFile=function(name,showError){var pos=this.fileNameExists(name);return-1==pos||files[pos].getId()<minNumberOfFiles?(showError(str("filenotdeleted",name)),!1):(this.setModified(),this.closeFile(files[pos]),files.splice(pos,1),0==openFiles.length&&VPLUI.hideIDEStatus(),VPLUtil.delay("updateFileList",self.updateFileList),!0)},this.currentFile=function(){var id=tabs.tabs("option","active");if(id in openFiles){var file=openFiles[id];if(0===arguments.length)return file;var action=arguments[0];if("function"==typeof file[action]){var fun=file[action],args=Array.prototype.slice(arguments);return args.shift(),fun.apply(file,args)}}return!1},this.getCurrentFileName=function(){var currentFileName="",currentFile=fileManager.currentFile();return currentFile&&(currentFileName=currentFile.name),currentFileName},this.currentPos=function(){return tabs.tabs("option","active")},this.getFileTab=function(id){for(var i=0;i<openFiles.length;i++)if(openFiles[i].getId()==id)return i;return-1},this.getFilePosById=function(id){for(var i=0;i<files.length;i++)if(files[i].getId()==id)return i;return-1},this.gotoFile=function(pos,l){var file=files[pos];self.open(file),tabs.tabs("option","active",self.getFileTab(file.getId())),"c"!==l&&file.gotoLine(parseInt(l,10)),file.focus()},this.gotoFileLink=function(a){var tag=$(a),fname=tag.data("file"),fpos=-1;if((fpos=fname>""?this.fileNameExists(fname):self.getFilePosById(tag.data("fileid")))>=0){var line=tag.data("line");return void 0===line&&(line="c"),self.gotoFile(fpos,line),!0}return!1},this.gotoFileName=function(fname,line){var fpos=this.fileNameExists(fname);return fpos>=0&&(void 0===line&&(line="c"),self.gotoFile(fpos,line),!0)},this.getFilesToSave=function(){for(var ret=[],i=0;i<files.length;i++){var file={};file.name=files[i].getFileName(),file.contents=files[i].getContent(),file.encoding=files[i].isBinary()?1:0,ret.push(file)}return ret},this.resetModified=function(){modified=!1;for(var i=0;i<files.length;i++)files[i].resetModified();VPLUtil.delay("updateMenu",updateMenu),VPLUtil.delay("updateFileList",self.updateFileList)},this.setModified=function(){modified=!0,VPLUtil.delay("updateFileList",self.updateFileList),VPLUtil.delay("updateMenu",updateMenu)},this.isModified=function(){return modified},this.length=function(){return files.length},this.clearAnnotations=function(){for(var i=0;i<files.length;i++)files[i].clearAnnotations()},this.getFile=function(i){return files[i]},this.getFiles=function(){return files},this.getDirectoryStructure=function(){var structure={isDir:!0,content:{},path:""};function addFilePath(i){for(var file=files[i],path=file.getFileName().split("/"),curdir=structure,pathdir="",p=0;p<path.length;p++){var part=path[p];p==path.length-1?curdir.content[part]={isDir:!1,content:file,pos:i}:(pathdir+=part,curdir.content[part]||(curdir.content[part]={isDir:!0,content:{},path:pathdir}),pathdir+="/",curdir=curdir.content[part])}}for(var i in files)files.hasOwnProperty(i)&&addFilePath(i);return structure},this.generateFileList=function(){if(self.isFileListVisible()){var lines=[],html="";!function lister(dir,indent,lines){var name,fd,sname,attrs,dirline,file,path,line;for(name in dir.content){if(dir.content.hasOwnProperty(name))if((fd=dir.content[name]).isDir)attrs='href="#" data-dirname="'+VPLUtil.sanitizeText(fd.path)+'" ',sname=VPLUtil.sanitizeText(name),dirline=indent,dirline+=VPLUI.iconFolder()+"<a "+attrs+">"+sname+"</a>",lines.push(dirline),lister(fd,indent+'<span class="vpl_ide_dirindent"></span>',lines);else file=fd.content,sname=VPLUtil.sanitizeText(name),path=VPLUtil.sanitizeText(file.getFileName()),file.isOpen()&&(sname="<b>"+sname+"</b>"),line="<a "+(attrs='href="#" data-fileid="'+file.getId()+'" title="'+path+'"')+">"+sname+"</a>",file.isModified()&&(line=VPLUI.iconModified()+line),file.isReadOnly()?line+=VPLUI.iconReadOnly():file.getId()<minNumberOfFiles&&(line+=VPLUI.iconRequired()),lines.push(indent+line)}}(self.getDirectoryStructure(),"",lines);for(var i=0;i<lines.length;i++)html+=lines[i]+"<br>";fileListContent.html("<div>"+html+"</div>")}},tabsUl.on("click","span.vpl_ide_closeicon",(function(){fileManager.closeFile(fileManager.currentFile())})),tabsUl.on("dblclick","span.vpl_ide_closeicon",menuButtons.getAction("delete")),tabsUl.on("dblclick","a",menuButtons.getAction("rename")),fileListContent.on("dblclick","a[data-fileid]",menuButtons.getAction("rename")),fileListContent.on("dblclick","a[data-dirname]",renameDiretoryAction)},autoResizeTab(),function(){var oldMenuWidth=menu.width();function checkMenuWidth(){var newMenuWidth=menu.width();oldMenuWidth!=newMenuWidth&&(oldMenuWidth=newMenuWidth,autoResizeTab())}checkMenuWidth(),setInterval(checkMenuWidth,1e3)}(),fileManager.resetModified(),VPLUI.requestAction("load","loading",options,options.loadajaxurl).done((function(response){for(var allOK=!0,files=response.files,showFileList=!1,i=0;i<files.length;i++){var file=files[i],r=fileManager.addFile(file,!1,updateMenu,showErrorMessage);r?(r.resetModified(),i<minNumberOfFiles||files.length<=5?fileManager.open(r):showFileList=!0):allOK=!1}tabs.tabs("option","active",0),response.compilationexecution&&self.setResult(response.compilationexecution,!1),menuButtons.setTimeLeft(response),response.comments>""&&$("#vpl_ide_input_comments").val(response.comments),allOK?fileManager.resetModified():fileManager.setModified(),0===fileManager.length()&&maxNumberOfFiles>0?menuButtons.getAction("new")():options.saved||fileManager.setModified(),fileManager.setFontSize(options.fontSize),fileManager.setVersion(response.version),fileManager.fileListVisible(showFileList),VPLUtil.afterAll("AfterLoadFiles",(function(){if(updateMenu(),autoResizeTab(),adjustTabsTitles(!0),fileManager.length()>0){var file=fileManager.getFiles()[0];file.open(),file.focus()}}))})).fail(showErrorMessage)};return window.VPLIDE=VPLIDE,{init:function(rootId,options){vplIdeInstance=new VPLIDE(rootId,options)}}}));

//# sourceMappingURL=vplide.min.js.map