/**
 * Tools for the VPL IDE
 *
 * @copyright 2016 Juan Carlos Rodríguez-del-Pino
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @author Juan Carlos Rodríguez-del-Pino <jcrodriguez@dis.ulpgc.es>
 */
define("mod_vpl/vplui",["jquery","jqueryui","mod_vpl/vplutil"],(function($,jqui,VPLUtil){var menuIcons,VPLUI={};return VPLUI.scrollBarWidth=function(){var parent,child,width;return width=(child=(parent=$('<div style="width:50px;height:50px;overflow:auto"><div/></div>').appendTo("body")).children()).innerWidth()-child.height(99).innerWidth(),parent.remove(),width},VPLUI.readZipFile=function(data,save,progressBar,end){if(end||(end=VPLUtil.doNothing),"undefined"!=typeof JUnzip){var ab=VPLUtil.ArrayBuffer2String(data),unzipper=new JUnzip(ab);if(!unzipper.isZipFile())return VPLUtil.log("Not a ZIP file"),void end();unzipper.readEntries();var out=unzipper.entries.length;!function process(i){if(i>=out||progressBar.isClosed())end();else{var data,entry=unzipper.entries[i],fileName=entry.fileName;if(fileName.match(/\/$/))process(i+1);else{progressBar.processFile(fileName);var uncompressed="";if(0===entry.compressionMethod?uncompressed=entry.data:8===entry.compressionMethod&&(uncompressed=JSInflate.inflate(entry.data)),VPLUtil.isBinary(fileName))save({name:fileName,contents:btoa(uncompressed),encoding:1}),process(i+1);else{data=VPLUtil.String2ArrayBuffer(uncompressed);var blob=new Blob([data],{type:"text/plain"}),fr=new FileReader;fr.onload=function(e){save({name:fileName,contents:e.target.result,encoding:0}),process(i+1)},fr.onerror=function(e){VPLUtil.log(e),process((i=out)+1)},fr.readAsText(blob)}}}}(0)}else VPLUtil.loadScript(["/zip/inflate.js","/zip/unzip.js"],(function(){VPLUI.readZipFile(data,save,progressBar,end)}))},VPLUI.readSelectedFiles=function(filesToRead,save,end){var pb=new VPLUI.progressBar("import","import"),errorsMessages="";end||(end=VPLUtil.doNothing),pb.processFile=function(name){pb.setLabel(name)},function readSecuencial(sec){if(sec>=filesToRead.length||pb.isClosed())return end(),pb.close(),void(errorsMessages>""&&VPLUI.showErrorMessage(errorsMessages));var f=filesToRead[sec];pb.processFile(f.name);var binary=VPLUtil.isBinary(f.name),reader=new FileReader,ext=VPLUtil.fileExtension(f.name).toLowerCase();reader.onload=function(e){if(binary)if("zip"==ext)try{return void VPLUI.readZipFile(e.target.result,save,pb,(function(){readSecuencial(sec+1)}))}catch(ex){VPLUI.showErrorMessage(ex+" : "+f.name)}else{var data=VPLUtil.dataFromURLData(e.target.result);save({name:f.name,contents:data,encoding:1})}else save({name:f.name,contents:e.target.result,encoding:0});readSecuencial(sec+1)},reader.onerror=function(e){errorsMessages+='Error "'+e.target.error+'" reading '+f.name+"\n",readSecuencial(sec+1)},binary?"zip"==ext?reader.readAsArrayBuffer(f):reader.readAsDataURL(f):reader.readAsText(f)}(0)},VPLUI.dialogbaseOptions={minWidth:200,autoOpen:!1,width:"auto",closeText:VPLUtil.str("cancel"),modal:!0,classes:{"ui-dialog":"vpl_ide vpl_ide_dialog"}},VPLUI.iconModified=function(){var html='<span title="'+VPLUtil.str("modified")+'" class="vpl_ide_charicon">';return html+='<i class="fa fa-star"></i></span> '},VPLUI.iconDelete=function(){var html=' <span title="'+VPLUtil.str("delete")+'" class="vpl_ide_charicon vpl_ide_delicon">';return html+='<i class="fa fa-trash"></i></span> '},VPLUI.iconClose=function(){var html=' <span title="'+VPLUtil.str("closebuttontitle");return html+='" class="vpl_ide_charicon vpl_ide_closeicon"><i class="fa fa-remove"></i></span> '},VPLUI.iconRequired=function(){var html=' <span title="'+VPLUtil.str("required")+'" class="vpl_ide_charicon">';return html+='<i class="fa fa-shield"></i></span> '},VPLUI.iconReadOnly=function(){var html=' <span title="'+VPLUtil.str("readOnly")+'" class="vpl_ide_charicon">';return html+='<i class="fa fa-lock"></i></span> '},VPLUI.iconFolder=function(){return'<i class="fa fa-folder-open-o"></i>'},menuIcons={filelist:"folder-open-o",filelistclose:"folder-o",new:"file-code-o",rename:"pencil",delete:"trash",multidelete:"trash|list",showparentfiles:"eye|files-o",close:"remove",comments:"commenting",import:"upload",print:"print",edit:"edit",undo:"undo",redo:"repeat",select_all:"location-arrow",find:"search",find_replace:"exchange",next:"search-plus",resetfiles:"refresh",download:"download",fullscreen:"expand",regularscreen:"compress",save:"save",shortcuts:"flash",sort:"list-ol",run:"rocket",running:"rocket fa-spin",debug:"bug",evaluate:"check-square-o",console:"terminal",about:"question",info:"info-circle",alert:"warning",trash:"trash",retrieve:"download",spinner:"refresh fa-spin",keyboard:"keyboard-o",clipboard:"clipboard",timeleft:"clock-o",copy:"copy",paste:"paste",more:"plus-square",less:"minus-square",resize:"arrows-alt",graphic:"picture-o",send:"send",theme:"paint-brush",user:"user",fontsize:"text-height","close-rightpanel":"caret-square-o-right","open-rightpanel":"caret-square-o-left"},VPLUI.genIcon=function(icon,size){if(!menuIcons[icon])return"";var classes="fa fa-";classes+=size||"lg";for(var icons=menuIcons[icon].split("|"),ret="",i=0;i<icons.length;i++)ret+="<i class='"+classes+" fa-"+icons[i]+"'></i>";return ret},VPLUI.setTitleBar=function(dialog,type,icon,buttons,handler){var title=$(dialog).parent().find("span.ui-dialog-title");function genButton(e){var html="<a id='vpl_"+type+"_"+e+"' href='#' title='"+VPLUtil.str(e)+"'>";return html+=VPLUI.genIcon(e,"fw")+"</a>"}var html=VPLUI.genIcon(icon);html+=" <span class='"+type+"-title-buttons'></span>",html+="<span class='"+type+"-title-text'></span>",title.html(html);var titleButtons=title.find("span."+type+"-title-buttons"),titleText=title.find("span."+type+"-title-text");html="";for(var i=0;i<buttons.length;i++)html+=genButton(buttons[i]);titleButtons.html(html);for(var ih=0;ih<handler.length;ih++){var button=title.find("#vpl_"+type+"_"+buttons[ih]);button.button().click(handler[ih]),button.css("padding","1px 3px")}return titleButtons.on("focus","*",(function(){$(this).blur()})),titleText},VPLUI.setDialogTitleIcon=function(dialog,icon){var title=$(dialog).parent().find("span.ui-dialog-title");title.html(VPLUI.genIcon(icon)+" "+title.html())},VPLUI.progressBar=function(title,message,onUserClose){var sppiner='<div class="vpl_ide_progressbaricon">'+VPLUI.genIcon("spinner")+"</div>",dialog=$('<div class="vpl_ide_dialog" style="display:none;">'+(' <div class="vpl_ide_progressbar">'+sppiner+'<span class="vpl_ide_progressbarlabel"></span></div>')+"</div>");$("body").append(dialog);var label=dialog.find(".vpl_ide_progressbar").find(".vpl_ide_progressbarlabel");dialog.dialog({title:VPLUtil.str(title),resizable:!1,autoOpen:!1,width:200,height:20,minHeight:20,modal:!0,classes:{"ui-dialog":"vpl_ide vpl_ide_dialog"},close:function(event){dialog&&(onUserClose&&event.originalEvent&&onUserClose(),onUserClose=!1)}}),this.setLabel=function(t,icon){dialog&&(label.text(t),icon&&label.html(VPLUI.genIcon(icon)+" "+label.html()))},this.close=function(){dialog&&(dialog.dialog("destroy"),$(dialog).remove(),dialog=!1)},this.isClosed=function(){return!1===dialog};var titleTag=dialog.siblings().find(".ui-dialog-title");titleTag.html(VPLUI.genIcon(title)+" "+titleTag.html()),this.setLabel(VPLUtil.str(message)),dialog.dialog("open"),dialog.dialog("option","height","auto")},VPLUI.showMessage=function(message,initialoptions){var options=$.extend({},VPLUI.dialogbaseOptions,initialoptions),messageDialog=$('<div class="vpl_ide_dialog" style="display:none"></div>'),icon="",contents=' <span class="dmessage">'+message.replace(/\n/g,"<br>")+"</span>";messageDialog.html(contents),void 0===options.icon?icon="info":(icon=options.icon,delete options.icon),options.title||(options.title=VPLUtil.str("warning")),$("body").append(messageDialog);var messageButtons={};"function"==typeof initialoptions.ok?(messageButtons[VPLUtil.str("ok")]=function(){$(this).dialog("close"),initialoptions.ok()},messageButtons[VPLUtil.str("cancel")]=function(){$(this).dialog("close")},delete options.ok):"function"==typeof initialoptions.yes&&(messageButtons[VPLUtil.str("yes")]=function(){$(this).dialog("close"),initialoptions.yes()},messageButtons[VPLUtil.str("no")]=function(){$(this).dialog("close")},delete options.yes),"function"==typeof initialoptions.stop&&(messageButtons[VPLUtil.str("stop")]=function(){$(this).dialog("close"),initialoptions.stop()},delete options.stop),"function"==typeof initialoptions.next&&(messageButtons[VPLUtil.str("next")]=function(){$(this).dialog("close"),initialoptions.next()},delete options.next),options.close=function(){$(this).remove(),initialoptions.close&&initialoptions.close()},options.buttons=messageButtons,messageDialog.dialog(options);var titleTag=messageDialog.siblings().find(".ui-dialog-title");return titleTag.html(VPLUI.genIcon(icon)+" "+titleTag.html()),messageDialog.setMessage=function(men){$(messageDialog).find(".dmessage").html(men.replace(/\n/g,"<br>"))},messageDialog.dialog("open"),messageDialog},VPLUI.showErrorMessage=function(message,options){var currentOptions=$.extend({},VPLUI.dialogbaseOptions,{title:VPLUtil.str("error"),icon:"alert"});return options&&(currentOptions=$.extend(currentOptions,options)),VPLUI.showMessage(message,currentOptions)},VPLUI.requestAction=function(action,title,data,URL,noDialog){var deferred=$.Deferred(),request=null,xhr=!1,apb=!1;return noDialog||(""===title&&(title="connecting"),apb=new VPLUI.progressBar(action,title,(function(){4!=request.readyState&&xhr&&xhr.abort&&xhr.abort()}))),request=$.ajax({beforeSend:function(jqXHR){return xhr=jqXHR,!0},async:!0,type:"POST",url:URL+action,data:JSON.stringify(data),contentType:"application/json; charset=utf-8",dataType:"json"}).always((function(){noDialog||apb.close()})).done((function(response){response.success?deferred.resolve(response.response):deferred.reject(response.error)})).fail((function(jqXHR,textStatus,errorThrown){var message=VPLUtil.str("connection_fail")+": "+textStatus;window.VPLDebugMode&&null!=errorThrown.message&&(message+=": "+errorThrown.message),VPLUtil.log(message),deferred.reject(message)})),deferred},VPLUI.clickServer=function(e){var left=screen.width/2-275,top=screen.height/2-225;try{var features="toolbar=no, location=no, directories=no, status=no, menubar=no";if(features+=", resizable=yes, scrollbars=yes, copyhistory=no, width=550",features+=", height=450, top="+top+", left="+left,!window.open($(this).attr("href"),"_blank",features))return!0}catch(ex){return VPLUtil.log(ex),!0}return e.preventDefault(),$(this).parent().hide(),!1},VPLUI.acceptCertificates=function(servers,getLastAction){if(servers.length>0){var i,html=VPLUtil.str("acceptcertificatesnote");for(i in html+="<ol>",servers)if(servers.hasOwnProperty(i)){var n=1+i;html+='<li><a href="'+servers[i]+'" target="_blank">Server ',html+=n+"</a></li>"}html+="</ol>";var m=VPLUI.showMessage(html,{ok:function(){var action=getLastAction();action&&action()},icon:"unlocked",title:VPLUtil.str("acceptcertificates")});$(m).find("a").on("click keypress",VPLUI.clickServer)}else VPLUtil.log("servers.length == 0"),VPLUI.showErrorMessage(VPLUtil.str("connection_fail"))},VPLUI.monitorRunning=VPLUtil.returnFalse,VPLUI.webSocketMonitor=function(coninfo,title,running,externalActions){VPLUtil.setProtocol(coninfo),VPLUtil.setProcessId(coninfo.processid);var ws=null,pb=null,deferred=$.Deferred(),defail=function(m){deferred.reject(m),null!==ws&&ws.close()},delegated=!1,messageActions={message:function(content){var parsed=/^([^:]*):?([^]*)/.exec(content),state=VPLUtil.sanitizeText(parsed[1]),detail=VPLUtil.sanitizeText(parsed[2]);"running"==state&&(state=running);var text=VPLUtil.str(state);detail>""&&(text+=": "+detail),null===pb||pb.isClosed()?externalActions.getConsole&&externalActions.getConsole().isOpen()?externalActions.getConsole().setMessage(text):VPLUtil.log("Error: no dialogo. Message not shown: "+text):pb.setLabel(text)},compilation:function(content){externalActions.setResult&&externalActions.setResult({compilation:content},!1)},retrieve:function(){var data={processid:coninfo.processid};pb.close(),delegated=!0,VPLUI.requestAction("retrieve","",data,externalActions.ajaxurl).done((function(response){deferred.resolve(),externalActions.setResult&&externalActions.setResult(response,!0)})).fail(defail)},run:function(content){pb.close(),externalActions.run(content,coninfo,ws)},close:function(){VPLUtil.log("ws close message from jail"),ws.close();var data={processid:coninfo.processid};VPLUI.requestAction("cancel","",data,externalActions.ajaxurl,!0)}};try{if(!VPLUtil.supportWebSocket())return VPLUtil.log("ws not available"),deferred.reject(VPLUtil.str("browserupdate")),deferred;ws=new WebSocket(coninfo.monitorURL)}catch(e){return VPLUtil.log("ws new say "+e),deferred.reject(e.message),deferred}return pb=new VPLUI.progressBar(title,"connecting",(function(){deferred.reject("Stopped by user"),ws.close()})),ws.notOpen=!0,ws.onopen=function(){ws.notOpen=!1,pb.setLabel(VPLUtil.str("connected")),externalActions.open&&externalActions.open()},ws.onerror=function(event){VPLUtil.log("ws error "+event),pb.close(),coninfo.secure&&ws.notOpen?VPLUI.requestAction("getjails","retrieve",{},externalActions.ajaxurl).done((function(response){VPLUI.acceptCertificates(response.servers,(function(){return externalActions.getLastAction()}))})).fail(defail):deferred.reject(VPLUtil.str("connection_fail")),externalActions.close&&VPLUtil.delay("externalActions.close",externalActions.close)},ws.onclose=function(){externalActions.getConsole&&externalActions.getConsole().disconnect(),ws.notOpen||(pb.close(),delegated||"rejected"==deferred.state()||deferred.resolve()),externalActions.close&&externalActions.close()},ws.onmessage=function(event){var message=/^([^:]+):([^]*)/.exec(event.data);if(null!==message){var action=message[1],content=message[2];messageActions[action]&&messageActions[action](content)}else pb.setLabel(VPLUtil.str("error")+": "+event.data)},VPLUI.monitorRunning=function(){return null!==ws&&ws.readyState!=WebSocket.CLOSED},deferred},VPLUI.hideIDEStatus=function(){VPLUtil.delay("updateIDEStatus",(function(){$(".vpl_ide_status").hide()}))},VPLUI.showIDEStatus=function(status){VPLUtil.delay("updateIDEStatus",(function(){$(".vpl_ide_status").text(status),$(".vpl_ide_status").show()}))},VPLUtil.init=VPLUtil.doNothing,window.VPLUI=VPLUI,VPLUI}));

//# sourceMappingURL=vplui.min.js.map