/**
 * VNC client control
 *
 * @copyright 2014 Juan Carlos Rodríguez-del-Pino
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @author Juan Carlos Rodríguez-del-Pino <jcrodriguez@dis.ulpgc.es>
 */
define("mod_vpl/vplvnc",["jquery","jqueryui","mod_vpl/vplutil","mod_vpl/vplui","mod_vpl/vplclipboard","core/log"],(function($,jqui,VPLUtil,VPLUI,VPLClipboard,console){return function(VNCDialogId,str){window.INCLUDE_URI=VPLUtil.options.scriptPath+"/noVNC/include/","undefined"==typeof Util&&VPLUtil.loadScript(["/noVNC/include/util.js"],(function(){VPLUtil.log("/noVNC/include/util.js loaded",!0),Util.load_scripts(["webutil.js","base64.js","websock.js","des.js","keysymdef.js","keyboard.js","input.js","display.js","jsunzip.js","rfb.js","keysym.js"])}));var rfb,clipboard,titleText,self=this,title="",message="",lastState="",VNCDialog=$("#"+VNCDialogId),canvas=$("#"+VNCDialogId+" canvas"),onCloseAction=VPLUtil.doNothing,needResize=!0,inputarea=window.document.createElement("input");function keyboardButton(){$(inputarea).is(":focus")?inputarea.blur():inputarea.focus()}function receiveClipboard(rfb,text){clipboard.setEntry1(text)}function openClipboard(){clipboard.show()}function getFocus(){self.isConnected()&&rfb.get_keyboard().set_focused(!0)}function lostFocus(){self.isConnected()&&rfb.get_keyboard().set_focused(!1)}inputarea.style.position="absolute",inputarea.style.left="0px",inputarea.style.top="-10000px",inputarea.style.width="1em",inputarea.style.height="1ex",inputarea.style.opacity="0",inputarea.style.backgroundColor="transparent",inputarea.style.borderStyle="none",inputarea.style.outlineStyle="none",inputarea.autocapitalize="off",inputarea.autocomplete="off",inputarea.autocorrect="off",inputarea.wrap="off",inputarea.spellcheck="false",VNCDialog.append(inputarea);var HTMLUpdateClipboard=VPLUI.genIcon("copy","sw")+" "+str("copy"),HTMLPaste=VPLUI.genIcon("paste","sw")+" "+str("paste");function controlDialogSize(){var bw=$("html").width(),bh=$(window).height();VNCDialog.width()>bw&&(needResize=!0,VNCDialog.dialog("option","width",bw)),VNCDialog.parent().height()>bh&&(needResize=!0,VNCDialog.dialog("option","height",bh-VNCDialog.prev().outerHeight()))}function updateState(rfb,state,oldstate,msg){switch(lastState=state,state){case"normal":self.setMessage(""),self.setTitle(str("connected"));break;case"disconnect":case"disconnected":self.setTitle(str("connection_closed"));break;case"failed":self.setTitle(str("connection_fail")),console.log("VNC client: "+msg);break;default:self.setMessage(""),self.setTitle(str("connecting"))}}function round(v){return v<100&&(v=100),2*Math.floor(v/2)}clipboard=new VPLClipboard("vpl_dialog_vnc_clipboard",HTMLUpdateClipboard,(function(){clipboard.setEntry1(clipboard.getEntry1()),document.execCommand("copy")}),HTMLPaste,(function(){self.isConnected()&&rfb.clipboardPasteFrom(clipboard.getEntry2())}),lostFocus),canvas.on("click",(function(e){e.target==canvas[0]?getFocus():lostFocus()})),this.displayResize=function(){if(self.isConnected()){var w=VNCDialog.width(),h=VNCDialog.height();self.setCanvasSize(w,h),rfb.get_display().viewportChange(0,0,w,h)}},VNCDialog.dialog({closeOnEscape:!1,autoOpen:!1,modal:!0,width:"auto",height:"auto",classes:{"ui-dialog":"vpl_ide vpl_vnc"},create:function(){titleText=VPLUI.setTitleBar(VNCDialog,"vnc","graphic",["clipboard","keyboard"],[openClipboard,keyboardButton])},dragStop:controlDialogSize,focus:getFocus,open:controlDialogSize,beforeClose:function(){if(needResize){var w=VNCDialog.width(),h=VNCDialog.height();needResize=!1,self.setCanvasSize(w,h)}},close:function(){self.disconnect()},resizeStop:function(){controlDialogSize(),needResize=!0}}),VNCDialog.css("padding","1px"),VNCDialog.parent().css("z-index",2e3),this.updateTitle=function(){var text=title;""!==message&&(text+=" ("+message+")"),titleText.text(str("console")+": "+text)},this.setTitle=function(t){title=t,this.updateTitle()},this.setMessage=function(t){message=t,this.updateTitle()},this.connect=function(secure,host,port,password,path,onClose){clipboard.setEntry1(""),onCloseAction=onClose,self.show();var target=$("#"+VNCDialogId+" canvas")[0];rfb||(rfb=new RFB({target:target,encrypt:secure,repeaterID:"",true_color:!0,local_cursor:!0,shared:!1,view_only:!1,onUpdateState:updateState,onPasswordRequired:null,onClipboard:receiveClipboard})).set_local_cursor(rfb.get_display().get_cursor_uri()),port||(port=secure?443:80),rfb.connect(host,port,password,path)},this.isOpen=function(){return VNCDialog.dialog("isOpen")},this.close=function(){VNCDialog.dialog("close")},this.isConnected=function(){return rfb&&"disconnected"!=lastState},this.disconnect=function(){rfb&&rfb.disconnect(),onCloseAction(),clipboard.hide()},this.getCanvasSize=function(){return canvas.width()+"x"+canvas.height()},this.setCanvasSize=function(w,h){canvas.width(round(w)),canvas.height(round(h))},this.show=function(){VNCDialog.dialog("open"),VNCDialog.width("auto"),VNCDialog.height("auto")},self.setCanvasSize($(window).width()-150,$(window).height()-150)}}));

//# sourceMappingURL=vplvnc.min.js.map