<?php
// This file is part of VPL for Moodle - http://vpl.dis.ulpgc.es/
//
// VPL for Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// VPL for Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VPL for Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Brazilian Portuguese language strings for the VPL module.
 *
 * @author Gabriel P. Silva UFRJ
 * @copyright 2018 Gabriel P. Silva UFRJ
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @var array $string
 * @package mod_vpl
 */

$string['VPL_COMPILATIONFAILED'] = 'A compilação ou preparação da execução falhou';
$string['about'] = 'Sobre';
$string['acceptcertificates'] = 'Aceitar certificados auto assinados';
$string['acceptcertificates_description'] = 'Se seus servidores de execução NÃO estão usando certificados auto assinados desmarque';
$string['acceptcertificatesnote'] = '<p>Você está usando uma conexão segura.<p/>
<p>Para usar uma conexão encriptada com os servidores de execução, você deve aceitar seus certificados de segurança.</p>
<p>Se não quiser aceitar os certificados ou tiver problemas com este processo, pode
tentar usar uma conexão http (não encriptada) ou outro navegador.</p>
<p>Por favor, clique nos seguintes links (servidor #) e aceite os certificados oferecidos.</p>';
$string['addfile'] = 'Adicionar arquivo';
$string['advanced'] = 'Avançado';
$string['allfiles'] = 'Todos os arquivos';
$string['allsubmissions'] = 'Todas as submissões';
$string['always_use_ws'] = 'Sempre usar protocolo websocket sem encriptação (ws)';
$string['always_use_wss'] = 'Sempre usar o protocolo websocket encriptado (wss)';
$string['anyfile'] = 'Qualquer arquivo';
$string['attemptnumber'] = 'Tentativa número {$a}';
$string['automaticevaluation'] = 'Avaliação automática';
$string['automaticgrading'] = 'Pontuação automática';
$string['averageperiods'] = 'Periodos médio {$a}';
$string['averagetime'] = 'Tempo médio {$a}';
$string['basedon'] = 'Baseado em';
$string['basic'] = 'Básico';
$string['binaryfile'] = 'Arquivo binário';
$string['browserupdate'] = 'Atualize seu navegador para a última versão<br />ou use outro que suporte Websocket';
$string['calculate'] = 'Calcular';
$string['changesNotSaved'] = 'As mudanças não foram salvas';
$string['check_jail_servers'] = 'Verifique os servidores de execução';
$string['check_jail_servers_help'] = '<p>Esta página verifica e mostra o estado dos servidores de execução usados para esta atividade.</p>';
$string['clipboard'] = 'Área de transferência';
$string['closed'] = 'Fechado';
$string['comments'] = 'Comentários';
$string['compilation'] = 'Compilação';
$string['connected'] = "conectado";
$string['connecting'] = "conectando";
$string['connection_closed'] = "conexão terminada";
$string['connection_fail'] = "conexão falhou";
$string['console'] = 'Console';
$string['copy'] = 'Copiar';
$string['create_new_file'] = 'Cria um novo arquivo para editar';
$string['currentstatus'] = 'Estado atual';
$string['cut'] = 'Cortar';
$string['datesubmitted'] = 'Submetido em';
$string['debug'] = 'Depurar';
$string['debugging'] = 'Depurando';
$string['defaultexefilesize'] = 'Máximo tamanho de um arquivo em execução por padrão';
$string['defaultexememory'] = 'Máximo de memória usada por padrão';
$string['defaultexeprocesses'] = 'Máximo número de processos por padrão';
$string['defaultexetime'] = 'Máximo tempo de execução por padrão';
$string['defaultfilesize'] = 'Máximo tamanho de cada arquivo de submissão por padrão';
$string['defaultresourcelimits'] = 'Limite de recursos de execução por padrão';
$string['delete'] = 'Apagar';
$string['delete_file'] = 'Apagar arquivo';
$string['delete_file_fq'] = "Confirma a deleção do arquivo?'{\$a}'?";
$string['delete_file_q'] = 'Apagar o arquivo?';
$string['deleteallsubmissions'] = 'Apagar todas as submissões';
$string['depends_on_https'] = 'Usar wss ou ws dependendo do uso de http ou https';
$string['description'] = 'Descrição';
$string['diff'] = 'diff';
$string['discard_submission_period'] = 'Período de descarte de submissões';
$string['discard_submission_period_description'] = 'Para cada estudante e tarefa, o sistema procura descartar as submissões mantendo a última e pelo menos uma submissão por periodo';
$string['download'] = 'Baixar';
$string['downloadallsubmissions'] = 'Baixar todas as submissões';
$string['duedate'] = 'Data de entrega';
$string['edit'] = 'Editar';
$string['editing'] = 'Editando';
$string['evaluate'] = 'Avaliar';
$string['evaluateonsubmission'] = 'Avaliar apenas na submissão';
$string['evaluating'] = "Avaliando";
$string['evaluation'] = 'Avaliação';
$string['examples'] = 'Exemplos';
$string['execution'] = 'execução';
$string['executionfiles'] = 'Arquivos de execução';
$string['executionfiles_help'] = '<h2>Introdução</h2>
<p>Aquí se definem os arquivos necessários para a execução, depuração ou avaliação de uma submissão.
Isto inclui arquivos de script, programas de teste e arquivos de dados.</p>
<h2>Script padrão para executar ou depurar</h2>
<p>Se não forem definidos os scripts de execução ou depuração,
o sistema deduz a linguagem utilizada segundo a extensão dos arquivos submetidos
e usar um script pré-definido. A seguinte tabela mostra as linguagens suportadas, as extensões de arquivos usadas, os script disponíveis, o compilador/interpretador e depurador usado e finalmente um comentário sobre uso da linguagem.</p>
<table>
<tr><th>Linguagem</th>
<th>Extensões</th>
<th>Executar</th>
<th>Depurar</th>
<th>Compilador/ interpretador<br>depurador</th>
<th>Comentário</th>
</tr>
<tr>
<td>Ada</td><td>ada, adb, ads</td><td>X</td><td>X</td><td>gnat (Ada 2005)/gdb</td><td>Usa o primeiro arquivo como principal</td>
</tr>
<tr>
<td>C</td><td>c</td><td>X</td><td>X</td><td>gcc C99/gdb</td><td>Compila todos os arquivos fonte</td>
</tr>
<tr>
<td>C++</td><td>cpp, C</td><td>X</td><td>X</td><td>g++/gdb</td><td>Compila todos os arquivos fonte</td>
</tr>
<tr>
<td>C#</td><td>cs</td><td>X</td><td>X</td><td>gmcs+mono/mdb</td><td>Compila todos os arquivos fonte</td>
</tr>
<tr>
<td>Fortran</td><td>f, f77</td><td>X</td><td>X</td><td>gfortran/gdb</td><td>Compila todos os arquivos fonte</td>
</tr>
<tr>
<td>Haskell</td><td>hs</td><td>X</td><td></td><td>hugs</td><td>Executa o primeiro arquivo</td>
</tr>
<tr>
<td>Java</td><td>java</td><td>X</td><td>X</td><td>javac+java/jdb</td><td>Compila todos os arquivos fonte.<br />Localiza a classe com main</td>
</tr>
<tr>
<td>Matlab/Octave</td><td>m</td><td>X</td><td>-</td><td>matlab, octave</td><td>Executa o primeiro arquivo.<br>Use vpl_replot depois de depurar.</td>
</tr>
<tr>
<td>Pascal</td><td>pas, p</td><td>X</td><td>X</td><td>fpc o gpc/gdb</td><td>Compila o primeiro arquivo (fpc) ou compila todos os arquivos fonte.(gpc)</td>
</tr>
<tr>
<td>Perl</td><td>perl, prl</td><td>X</td><td>X</td><td>perl</td><td>Executa o primeiro arquivo.</td>
</tr>
<tr>
<td>PHP</td><td>php</td><td>X</td><td>-</td><td>php5</td><td>Executa o primeiro arquivo</td>
</tr>
<tr>
<td>Prolog</td><td>pl, pro</td><td>X</td><td>-</td><td>swipl</td><td>Executa o primeiro arquivo</td>
</tr>
<tr>
<td>Python</td><td>py</td><td>X</td><td>X</td><td>python</td><td>Executa o primeiro arquivo</td>
</tr>
<tr>
<td>Ruby</td><td>rb</td><td>X</td><td>X</td><td>ruby</td><td>Executa o primeiro arquivo</td>
</tr>
<tr>
<td>Scheme</td><td>scm, s</td><td>X</td><td>-</td><td>mzscheme</td><td>Executa o primeiro arquivo</td>
</tr>
<tr>
<td>Shell script</td><td>sh</td><td>X</td><td>-</td><td>bash</td><td>Executa o primeiro arquivo</td>
</tr>
<tr>
<td>SQL</td><td>sql</td><td>X</td><td>-</td><td>sqlite3</td><td>Executa todos os  arquivos fonte.<br />Primeiro os definidos nos arquivos de execução</td>
</tr>
<tr>
<td>VHDL</td><td>vhd, vhdl</td><td>X</td><td>-</td><td>ghdl</td><td>Compila todos os arquivos fonte, o primeiro ou deve ter o método Main.</td>
</tr>
</table>
<h2>Avaliação automática</h2>
<p>Se quiser usar as características de avaliação automática de programas do VPL, deve-se editar o arquivo "vpl_evaluate.cases".
Este arquivo tem o seguinte formato:</p>
<ul>
<li>"<b>case</b> = Descrição do caso": Opcional. Estabelece o inicio de um caso de teste.</li>
<li>"<b>input</b> = texto": pode ocupar várias linhas. Finaliza quando se introduz outra instrução.</li>
<li>"<b>output</b> = texto": pode ocupar várias linhas.  Finaliza com outra instrução. Um caso de teste pode ter várias saídas válidas. Existem três tipos de saídas: só números, texto e texto exato:
 <ul>
 <li><b>números</b>: Se escrevem só números. Só são verificados os número da saída, o resto do texto é ignorado. Os números reais são verificados com certa tolerância</li>
 <li><b>texto</b>: Só são verificadas palavras, a comparação é insensível a maiúsculas e o resto dos caracteres são ignorados.</li>
 <li><b>texto exato</b>: O texto se escreve entre aspas.</li>
 </ul>
 </li>
<li>"<b>grade reduction</b> = [valor|percentual%]" : Por padrão quando se produz um erro se desconta um valor padrão (variação_nota/número de casos) da nota máxima, mas com esta instrução se pode mudar o desconto por outro valor ou porcentagem.
</li>
 </ul>
<h2>Uso Geral</h2>
<p>Aqui são definidos os arquivos necessários para preparar a execução, depuração ou avaliação de uma submissão. Isto inclui arquivos de "script", arquivos de testes de programas e arquivos de dados.</p>
<p>Pode-se adicionar um novo arquivo escrevendo seu nome na caixa "Adicionar arquivo" e clicando em seguida o botão "Adicionar arquivo".</p>
<p>Pode-se carregar um arquivo existente usando o controle "Carregar arquivo".</p>
<p>Todos os arquivos que são adicionados ou carregados podem ser editados, e todos, exceto os arquivos de "script" mencionados a seguir, podem ser renomeados.</p>
<p>Devem existir três arquivos de "script" para preparar cada uma das tres ações possíveis. Estes arquivos tem nomes pré-definidos: <b>vpl_run.sh</b> (execução), <b>vpl_debug.sh</b>, (depuração) e <b>vpl_evaluate.sh</b>, (avaliação)</p>
<p>A execução de qualquer desses "scripts" deve gerar um arquivo denominado <b>vpl_execution</b>. Este arquivo deve conter código binário executável, ou um "script" que comece por ""#!/bin/sh". A não geração deste arquivo impossibilita a execução da ação selecionada.</p>
<p>Se a atividade se baseia em outra, os arquivos da atividade base são anexados automaticamente. Os conteúdos dos arquivos <b>vpl_run.sh, vpl_debug.sh e vpl_evaluate.sh</b> se concatenam para toda a cadeia de atividades em que se baseiam até a atual.</p>
<p>Finalmente, o arquivo <b>vpl_environment.sh</b> é adicionado automaticamente, o qual contém informação sobre a submissão, que se gerencia mediante as variáveis:</p>
<ul><li>LANG: a linguagem empregada.</li>
<li>LC_ALL: o mesmo valor que LANG.</li>
<li>VPL_MAXTIME: tempo máximo de execução em segundos.</li>
<li>VPL_FILEBASEURL: URL para acessar os arquivos do curso.</li>
<li>VPL_SUBFILE#: cada nome dos arquivos entregues pelo aluno. # vai de 0 a número de arquivos entregados.</li>
<li>VPL_SUBFILES: lista de todos os arquivos entregues.</li>
<li>VPL_VARIATION+id: onde id é a ordem de variação começando por 0 e o valor é o valor da variação.<br></li>
</ul>
Se a ação solicitada é &quot;avaliação&quot; se anexam as seguintes variáveis:
<ul>
	<li>VPL_MAXTIME: máximo tempo de execução em segundos.</li>
	<li>VPL_MAXMEMORY: máxima memória utilizável em bytes.</li>
	<li>VPL_MAXFILESIZE: tamanho máximo em bytes de um arquivo.</li>
	<li>VPL_MAXPROCESSES: número máximo de processos que se podem executar simultaneamente.</li>
	<Li>VPL_FILEBASEURL: URL para os arquivos do curso.</Li>
	<li>VPL_GRADEMIN: nota mínima para esta atividade.</li>
	<li>VPL_GRADEMAX: nota máxima para esta atividade.</li>
</ul>

<h2>Códigos de resultado de avaliação</h2>
<p>A saída da avaliação é processada para extrair, se for possível, comentários sobre a avaliação e a nota proposta.
Os comentários podem ser feitos de duas formas: com um comentário de linha definido com uma linha que começa por \'Comment :=&gt;&gt;\' ou
com comentários em blocos que começam com uma linha que contém únicamente \'&lt;|--\' e termina em uma linha que contém únicamente \'--|&gt;\'.
A pontuação se toma da última linha que começa por \'Grade :=&gt;&gt;\'.
</p>';
$string['executionoptions'] = 'Opções de execução';
$string['executionoptions_help'] = '<p>Nesta página são definidas as diferentes opções de execução</p>
<ul>
<li><b>Baseado em</b>: permite definir outra instância de VPL da qual se tomam diversas características:
<ul><li>Arquivos de execução (os arquivos de "script" pré-definidos são concatenados)</li>
<li>Limites dos recursos de execução.</li>
<li>Variações, que se concatenam gerando variações múltiplas.</li>
<li>Tamanho máximo de cada arquivo a ser carregado com a submissão</li>
</ul>
</li>
<li><b>Executar, Depurar e Avaliar</b>: definem se pode-se usar a opção correspondente durante a edição da submissão. Isto só afeta aos estudantes, os usuários com capacidade de pontuação podem usar estas opções em qualquer caso.</li>
<li><b>Avaliar ao submeter</b>: ao carregar os arquivos se inicia o processo de avaliação automaticamente.</li>
<li><b>Pontuação automática</b>: se o resultado da avaliação contém códigos de nota automática estes se tornam a nota definitiva.</li>
</ul>';
$string['file'] = 'Arquivo';
$string['fileNotChanged'] = 'O arquivo não foi modificado';
$string['file_name'] = 'Nome do arquivo';
$string['fileadded'] = "O arquivo '{\$a}' foi adiconado";
$string['filedeleted'] = "O arquivo '{\$a}' foi apagado";
$string['filelist'] = "Lista de arquivos";
$string['filenotadded'] = 'O arquivo não foi adicionado';
$string['filenotdeleted'] = 'O arquivo \'{$a}\' NÃO foi apagado';
$string['filenotrenamed'] = 'O arquivo \'{$a}\' NÃO foi renomeado';
$string['filerenamed'] = "O arquivo '{\$a->from}' foi renomeado para '{\$a->to}'";
$string['filesChangedNotSaved'] = "Arquivos foram modificados mas não salvos";
$string['filesNotChanged'] = 'Arquivos não foram modificados';
$string['filestoscan'] = 'Arquivos a processar';
$string['fileupdated'] = "O arquivo '{\$a}' foi atualizado";
$string['find'] = "Localizar";
$string['find_replace'] = 'Localizar/Substituir';
$string['fulldescription'] = 'Descrição completa';
$string['fulldescription_help'] = '<p>Escreva aqui a descrição completa da tarefa a se realizar no laboratório de programação.</p>
<p>Caso não se escreva nada, seerá mostrado em seu lugar a descrição curta.</p>
<p>Se deseja realizar uma avaliação automática, é aconselhável que a especificação das interfaces seja o mais detalhada possível e que não tenha ambiguidades.</p>';
$string['fullscreen'] = 'Maximizar janela';
$string['getjails'] = 'Obtendo servidores de execução';
$string['gradeandnext'] = 'Pontuar & Seguir';
$string['graded'] = 'Avaliadas';
$string['gradedbyuser'] = 'Avaliadas pelo usuário';
$string['gradedon'] = "Avaliada em";
$string['gradedonby'] = 'Avaliada em {$a->date} por {$a->gradername}';
$string['gradenotremoved'] = 'A pontuação NÃO foi eliminada. Verificar a configuração de atividade em pontuações.';
$string['gradenotsaved'] = 'A pontuação NÃO foi salva. Verificar a configuração de atividade em pontuações.';
$string['gradeoptions'] = 'Opções de avaliação';
$string['grader'] = "Avaliada por";
$string['gradercomments'] = 'Comentários da avaliação';
$string['graderemoved'] = 'A avaliação foi removida';
$string['groupwork'] = 'Em grupo';
$string['inconsistentgroup'] = 'Você não é membro de nenhum grupo (0 ou > 1)';
$string['incorrect_file_name'] = 'Nome de arquivo incorreto';
$string['individualwork'] = 'Individual';
$string['instanceselection'] = 'Seleção de VPL';
$string['isexample'] = 'Esta atividade serve como exemplo';
$string['jail_servers'] = 'Lista servidores de execução';
$string['jail_servers_config'] = "Configuração dos servidores de execução";
$string['jail_servers_description'] = "Escreva um servidor por linha";
$string['joinedfiles'] = 'Arquivos selecionados agrupados';
$string['keepfiles'] = "Arquivos a manter enquanto se executa";
$string['keepfiles_help'] = '<p>Por razões de segurança, os arquivos anexados em "Arquivos de execução", são apagaos antes de se executar o arquivo vpl_execution.</p>
<p>Se for necessário que algum destes arquivos permaneça na fase de execução,
por exemplo, para usá-lo como dados de entrada dos testes, marque-os nesta página</p>';
$string['keyboard'] = 'Teclado';
$string['lasterror'] = 'Informa o último erro';
$string['lasterrordate'] = 'Data do último erro';
$string['listofcomments'] = 'Lista de comentários';
$string['listsimilarity'] = 'Lista de similaridades encontradas';
$string['listwatermarks'] = 'Lista marcas dágua';
$string['load'] = 'Carregar';
$string['loading'] = 'Carregando';
$string['local_jail_servers'] = 'Servidores de execução locais';
$string['local_jail_servers_help'] = '<p>Aqui se definem os servidores de execução locais para esta atividade e aquelas que se baseiam nela.</p>
<p>Escreva uma URL completa de servidor em cada linha. Podem-se introduzir linhas em branco e comentários començando a linha por "#".</p>
<p>Se deseja impedir que esta atividade e as que se baseiam nela de usarem outros servidores, deve-se adicionar ao final uma linha que contenha "end_of_jails".
</p>';
$string['manualgrading'] = 'Avaliação manual';
$string['maxexefilesize'] = 'Máximo tamanho de um arquivo em execução';
$string['maxexememory'] = 'Máxima memória usada';
$string['maxexeprocesses'] = 'Máximo número de processos';
$string['maxexetime'] = 'Máximo tempo de execução';
$string['maxfiles'] = 'Número máximo de arquivos';
$string['maxfilesexceeded'] = 'Excedido o número máximo de arquivos';
$string['maxfilesize'] = 'Tamanho máximo de arquivo';
$string['maxfilesizeexceeded'] = 'Excedido o tamanho máximo de arquivo';
$string['maximumperiod'] = 'Periodo máximo {$a}';
$string['maxresourcelimits'] = 'Límites máximos de recursos de execução';
$string['maxsimilarityoutput'] = 'Máximo de saída por similaridade';
$string['menucheck_jail_servers'] = 'Verifica servidores de execução';
$string['menuexecutionfiles'] = 'Arquivos de execução';
$string['menuexecutionoptions'] = 'Opções';
$string['menukeepfiles'] = "Arquivos a manter";
$string['menulocal_jail_servers'] = 'Servidores de execução locais';
$string['menuresourcelimits'] = 'Limites de recursos';
$string['minsimlevel'] = 'Nivel de similaridade mínima a exibir';
$string['moduleconfigtitle'] = 'Configuração do módulo VPL';
$string['modulename'] = 'Laboratório virtual de programação';
$string['modulename_help'] = '<p>O VPL permite a gestão de práticas de programação tendo como características mais destacadas:
<ul>
<li>Possibilidade de editar o código fonte no navegador.</li>
<li>Possibilidade de executar as práticas de forma interativa a partir do navegador.</li>
<li>Possibilidade de executar testes que revisem as práticas.</li>
<li>Busca de similaridade entre práticas para o controle de plágio.</li>
<li>Restrições de entrega de práticas que limitam o "copia e cola" de código externo.</li>
</ul></p>
<p><a href="http://vpl.dis.ulpgc.es">Página oficial do Virtual Programming Lab</a></p>';
$string['modulename_link'] = 'mod/vpl/view';
$string['modulenameplural'] = 'Laboratórios virtuais de programação';
$string['new'] = 'Novo';
$string['new_file_name'] = 'Nome do arquivo novo';
$string['next'] = 'Próximo';
$string['nojailavailable'] = 'Não há servidor de execução disponível';
$string['noright'] = 'Você não tem permissão de acesso';
$string['nosubmission'] = 'Não há submissão';
$string['notexecuted'] = 'Não executado';
$string['notgraded'] = 'Não avaliadas';
$string['notsaved'] = 'Não salvo';
$string['novpls'] = 'Não existe laboratório de programação definido';
$string['nowatermark'] = 'Marcas dágua próprias {$a}';
$string['nsubmissions'] = '{$a} submissões';
$string['numcluster'] = 'Grupo {$a}';
$string['open'] = 'Aberto';
$string['opnotallowfromclient'] = 'Ação não permitida desta máquina';
$string['options'] = 'Opções';
$string['optionsnotsaved'] = "Opções não salvas";
$string['optionssaved'] = "Opções salvas";
$string['origin'] = 'Origem';
$string['othersources'] = 'Outras fontes a usar';
$string['outofmemory'] = 'Memória esgotada';
$string['paste'] = 'Colar';
$string['pluginadministration'] = 'Administração de VPL';
$string['pluginname'] = 'Laboratorio virtual de programação';
$string['previoussubmissionslist'] = 'Lista submissões anteriores';
$string['print'] = 'Imprimir';
$string['proposedgrade'] = 'Nota proposta: {$a}';
$string['proxy'] = 'proxy';
$string['proxy_description'] = 'Proxy do Moodle para os servidores de execução';
$string['redo'] = 'Refazer';
$string['regularscreen'] = 'Janela normal';
$string['removegrade'] = 'Apaga pontuação';
$string['rename'] = 'Renomear';
$string['rename_file'] = 'Renomear arquivo';
$string['replace_find'] = 'Substituir/Localizar';
$string['requestedfiles'] = 'Arquivos solicitados';
$string['requestedfiles_help'] = '<p>Aquí se fixam nomes e conteúdo inicial para os arquivos requeridos.</p>
<p>Se não se definem nomes para o número máximo de arquivos estabelecido na definição básica da atividade, os arquivos para os que não se haja estabelecido nomes são opcionais e podem ter qualquer nome.</p>
<p>Ademais, podem-se establecer conteúdos para os arquivos requeridos, de forma que seus conteúdos estarão disponíveis a primeira vez que o arquivo for aberto usando o editor, se não se for realizada uma submissão prévia.</p>';
$string['requirednet'] = 'Submissões restritas à rede';
$string['requiredpassword'] = 'É necessário uma senha';
$string['resetfiles'] = 'Reiniciar arquivos';
$string['resetvpl'] = 'Reiniciar {$a}';
$string['resourcelimits'] = 'Límites de recursos de execução';
$string['resourcelimits_help'] = '<p>Podem-se estabelecer limites máximos para o tempo de execução, a memória usada, o tamanho dos arquivos gerados durante a execução e o número de processos simultâneos.</p>
<p>Estes limites se aplicam ao executar os arquivos de "script" <b> vpl_run.sh, vpl_debug.sh e vpl_evaluate.sh</b>, e o arquivo <b>vpl_execution</b> gerado por eles.</p>
<p>Se a atividade está baseada em outra, os limites estabelecidos podem ser limitados pelos valores estabelecidos naquela e em outras tarefas na qual a mesma se baseia, além do que for estabelecido na configuração global do módulo.</p>';
$string['restrictededitor'] = "Desativar o carregamento de arquivos, copiar e colar conteúdo externo";
$string['retrieve'] = 'Recupera resultados';
$string['run'] = 'Executar';
$string['running'] = "Executando";
$string['save'] = 'Salvar';
$string['savecontinue'] = 'Salvar e continuar';
$string['saved'] = 'Salvo';
$string['savedfile'] = "O arquivo '{\$a}' foi salvo";
$string['saveoptions'] = 'Opções de salvamento';
$string['saving'] = "Salvando";
$string['scanactivity'] = 'Atividade';
$string['scandirectory'] = 'Diretório';
$string['scanningdir'] = 'Examinando o diretório ...';
$string['scanoptions'] = 'Opções de busca';
$string['scanother'] = 'Buscar similaridade em outros fontes';
$string['scanzipfile'] = 'Arquivo zip';
$string['select_all'] = 'Selecionar tudo';
$string['server'] = 'Servidor';
$string['serverexecutionerror'] = 'Erro no servidor de execução';
$string['shortcuts'] = 'Atalhos de teclado';
$string['shortdescription'] = 'Descrição curta';
$string['similarity'] = 'Similaridade';
$string['similarto'] = 'Similar a';
$string['startdate'] = 'Disponível em';
$string['submission'] = 'Submissão';
$string['submissionperiod'] = 'Período de submissão';
$string['submissionrestrictions'] = 'Restrições de submissão';
$string['submissions'] = 'Submissões';
$string['submissionselection'] = 'Seleção de submissões';
$string['submissionslist'] = 'Lista de submissões';
$string['submissionview'] = 'Ver submissão';
$string['submittedby'] = 'Submetido por {$a}';
$string['submittedon'] = 'Submetido em';
$string['submittedonp'] = 'Submetido em {$a}';
$string['sureresetfiles'] = 'Quer descartar todo seu trabalho e restaurar os arquivos ao seu estado original?';
$string['test'] = 'Testar atividade';
$string['testcases'] = 'Casos de teste';
$string['testcases_help'] = '<p>Para usar as caracteristicas de avaliação automática de programas no VPL, deve-se editar o arquivo "vpl_evaluate.cases".
Este arquivo tem o seguinte formato:
<ul>
<li>"<b>case</b> = Descrição do caso": Opcional. Estabelece o inicio de um caso de teste.</li>
<li>"<b>input</b> = texto": pode ocupar várias linhas. Finaliza quando se introduz outra instrução.</li>
<li>"<b>output</b> = texto": pode ocupar várias linhas.  Finaliza com outra instrução. Um caso de teste pode ter várias saídas válidas. Existem três tipos de saídas: só números, texto e texto exato:
<ul>
 <li><b>números</b>: Se escrevem só números. Só são verificados os número da saída, o resto do texto é ignorado. Os números reais são verificados com certa tolerância</li>
 <li><b>texto</b>: Só são verificadas palavras, a comparação é insensível a maiúsculas e o resto dos caracteres são ignorados.</li>
 <li><b>texto exato</b>: O texto se escreve entre aspas.</li>
 </ul>
 </li>
<li>"<b>grade reduction</b> = [valor|percentual%]" : Por padrão quando se produz um erro se desconta um valor padrão (variação_nota/número de casos) da nota máxima, mas com esta instrução se pode mudar o desconto por outro valor ou porcentagem.
</li>
 </ul>';
$string['timeleft'] = 'Tempo restante';
$string['timelimited'] = 'Limitado por tempo';
$string['timeout'] = 'Tempo esgotado';
$string['timeunlimited'] = 'Sem limite de tempo';
$string['totalnumberoferrors'] = 'Erros';
$string['undo'] = 'Desfazer';
$string['unexpected_file_name'] = "Nome de arquivo incorreto: era esperado '{\$a->expected}' e foi encontrado '{\$a->found}'";
$string['unzipping'] = 'Descompactando ...';
$string['uploadfile'] = 'Carregar arquivo';
$string['usevariations'] = 'Usar variações';
$string['usewatermarks'] = 'Usar marcas dágua';
$string['usewatermarks_description'] = 'Anexar marcas dágua aos arquivos dos estudantes (só em linguagens suportadas)';
$string['variation_n'] = 'Variação {$a}';
$string['variation_n_i'] = 'Variação {$a->number}: {$a->identification}';
$string['variation_options'] = 'Opções de variação';
$string['variations'] = 'Variações';
$string['variations_help'] = '<p>Podem-se definir variações para as atividades. As variações são atribuídas de forma aleatória aos estudantes.</p>
<p>Nesta página pode-se indicar se a atividade tem variações, dar um título ao conjunto de variações, e anexar as variações desejadas.</p>
<p>Cada variação tem um código de identificação e uma descrição. O identificador é usado no arquivo <b>vpl_enviroment.sh</b> para passar a
variação atribuída ao estudante e aos "scripts". A descrição, com formato HTML, é exibida aos estudantes aos quais a variação
correspondente foi atribuída.</p>';
$string['variations_unused'] = 'Esta atividade tem variações, mas estão desativadas';
$string['variationtitle'] = 'Título da variação';
$string['varidentification'] = 'Identificação';
$string['visiblegrade'] = 'Mostrar avaliação';
$string['vpl'] = 'Laboratório virtual de programação';
$string['vpl:addinstance'] = 'Anexar novas atividades VPL';
$string['vpl:grade'] = 'Avaliar uma submissão';
$string['vpl:manage'] = 'Gerenciar um vpl';
$string['vpl:setjails'] = 'Estabelece servidores de execução para instâncias reais de VPL';
$string['vpl:similarity'] = 'Buscar similaridades entre submissões';
$string['vpl:submit'] = 'Fazer submissões';
$string['vpl:view'] = 'Ver a descripção completa de um vpl';
$string['vpl_debug.sh'] = "Prepara a depuração do programa";
$string['vpl_evaluate.cases'] = 'Descrever aqui os casos de teste para avaliar automaticamente o programa';
$string['vpl_evaluate.sh'] = "Avaliar o programa";
$string['vpl_run.sh'] = "Prepara a execução do programa";
$string['websocket_protocol'] = 'Protocolo WebSocket';
$string['websocket_protocol_description'] = 'Tipo de protocolo WebSocket (ws:// or wss://) a ser usado pelo navegador ao se conectar ao servidor de execução.';
$string['workingperiods'] = 'Periodos de trabalho';
$string['worktype'] = 'Tipo de trabalho';
