<?php
// This file is part of VPL for Moodle - http://vpl.dis.ulpgc.es/
//
// VPL for Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// VPL for Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VPL for Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * VPL Syntaxhighlighters for binary files
 *
 * @package mod_vpl
 * @copyright 2014 Juan Carlos Rodríguez-del-Pino
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @author Juan Carlos Rodríguez-del-Pino <jcrodriguez@dis.ulpgc.es>
 */

defined('MOODLE_INTERNAL') || die();

require_once(dirname ( __FILE__ ) . '/sh_base.class.php');

/**
 * VPL Syntaxhighlighters for binary files
 *
 * This class is used to print the content of a binary file.
 */
class vpl_sh_binary extends vpl_sh_base {
    /**
     * This method prints the content of a binary file.
     *
     * @param string $name name of the file
     * @param string $data content of the file (ignored for binary files)
     * @return void
     */
    public function print_file($name, $data) {
        echo "<h4>" . s( $name ) . '</h4>';
        echo get_string( 'binaryfile', VPL );
    }
}
