define("tiny_codepro/ui",["exports","./modal","core/modal_events","./preferences","./options","./commands"],(function(_exports,_modal,_modal_events,_preferences,_options,_commands){var obj;
/**
   * Tiny CodePro plugin.
   *
   * @module      tiny_codepro/plugin
   * @copyright   2023 Josep Mulet Pol <pep.mulet@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.requireCm6Pro=_exports.displayDialogue=void 0,_modal_events=(obj=_modal_events)&&obj.__esModule?obj:{default:obj};let modal=null,codeEditorInstance=null;const toggleClasses=function(el,classList){const cl=el.classList;classList.forEach((className=>{cl.toggle(className)}))};let isLoading=!1;_exports.displayDialogue=async(editor,initialHTML)=>{if(isLoading)return;null===modal&&(isLoading=!0,modal=await createDialogue(editor),isLoading=!1);if(modal.footer.find("button.btn[data-action]").off("click.codepro").on("click.codepro",(evt=>{var _codeEditorInstance2;if(evt.target.classList.contains("btn-primary")){var _codeEditorInstance;const updatedCode=null===(_codeEditorInstance=codeEditorInstance)||void 0===_codeEditorInstance?void 0:_codeEditorInstance.getValue({source_view:!0});editor.setContent(updatedCode??"")}modal.hide(),null===(_codeEditorInstance2=codeEditorInstance)||void 0===_codeEditorInstance2||_codeEditorInstance2.setValue()})),_commands.blackboard.state){var _codeEditorInstance3;null===(_codeEditorInstance3=codeEditorInstance)||void 0===_codeEditorInstance3||_codeEditorInstance3.setState(_commands.blackboard.state),_commands.blackboard.state=null}else{var _codeEditorInstance5;let html;if(initialHTML)html=initialHTML;else{const syncCaret=(0,_options.isSyncCaret)(editor);let markerNode;if(syncCaret){markerNode=document.createElement("SPAN"),markerNode.innerHTML="&nbsp;",markerNode.classList.add("CmCaReT");editor.selection.getStart().append(markerNode)}var _codeEditorInstance4;if(html=editor.getContent({source_view:!0}),syncCaret&&(html=html.replace(/<span\s+class="CmCaReT"([^>]*)>([^<]*)<\/span>/gm,String.fromCharCode(0)),markerNode.remove()),(0,_options.isAutoFormatHTML)(editor))html=null===(_codeEditorInstance4=codeEditorInstance)||void 0===_codeEditorInstance4?void 0:_codeEditorInstance4.prettifyCode(html)}null===(_codeEditorInstance5=codeEditorInstance)||void 0===_codeEditorInstance5||_codeEditorInstance5.setValue(html)}modal.show(),setTimeout((()=>{var _codeEditorInstance6;return null===(_codeEditorInstance6=codeEditorInstance)||void 0===_codeEditorInstance6?void 0:_codeEditorInstance6.focus()}),500)};const requireCm6Pro=()=>new Promise((resolve=>{require(["tiny_codepro/cm6pro-lazy"],(CodeProEditor=>{resolve(CodeProEditor)}))}));_exports.requireCm6Pro=requireCm6Pro;const createDialogue=async editor=>{const canUserSwitchUI=((0,_options.getDefaultUI)(editor)??"dialog").startsWith("user:"),data={elementid:Math.random().toString(32).substring(2),canUserSwitchUI:canUserSwitchUI},modal=await(0,_modal.createModal)({templateContext:data});modal.getRoot().find(".modal-dialog.modal-lg").addClass("tiny_codepro-dlg"),modal.getRoot().off("keydown"),modal.getRoot().on(_modal_events.default.outsideClick,(evt=>{evt.preventDefault()})),modal.body.css("overflow-y","overlay"),modal.header.css("height","61.46px"),modal.header.css("padding","1rem 1rem");const CodeProEditor=await requireCm6Pro(),targetElem=modal.body.find(".tiny_codepro-editor-area")[0];codeEditorInstance=new CodeProEditor(targetElem),modal.footer.find("button.btn.btn-light").on("click",(evt=>{evt.preventDefault();const ds=evt.currentTarget.dataset,icon=evt.currentTarget.querySelector("i.fa"),$dlgElem=modal.getRoot().find('[role="document"], [data-region="modal"]');if(ds.fs)"false"===ds.fs?(ds.fs="true",modal.header.hide(),$dlgElem.removeClass("modal-dialog modal-lg modal-dialog-scrollable"),$dlgElem.addClass("tiny_codepro-fullscreen")):(ds.fs="false",modal.header.show(),$dlgElem.removeClass("tiny_codepro-fullscreen"),$dlgElem.addClass("modal-dialog modal-lg modal-dialog-scrollable")),(0,_preferences.setPref)("fs",ds.fs,!0);else if(ds.theme)"light"===ds.theme?(ds.theme="dark",codeEditorInstance.setTheme("dark"),$dlgElem.addClass("tiny_codepro-dark")):(ds.theme="light",codeEditorInstance.setTheme("light"),$dlgElem.removeClass("tiny_codepro-dark")),toggleClasses(icon,["fa-sun-o","fa-moon-o"]),(0,_preferences.setPref)("theme",ds.theme,!0);else if(ds.wrap){var _codeEditorInstance7,_codeEditorInstance8;if("true"===ds.wrap)ds.wrap=!1,null===(_codeEditorInstance7=codeEditorInstance)||void 0===_codeEditorInstance7||_codeEditorInstance7.setLineWrapping(!1);else ds.wrap=!0,null===(_codeEditorInstance8=codeEditorInstance)||void 0===_codeEditorInstance8||_codeEditorInstance8.setLineWrapping(!0);(0,_preferences.setPref)("wrap",ds.wrap,!0),toggleClasses(icon,["fa-exchange","fa-long-arrow-right"])}else if(void 0!==ds.prettify){var _codeEditorInstance9;null===(_codeEditorInstance9=codeEditorInstance)||void 0===_codeEditorInstance9||_codeEditorInstance9.prettify()}else void 0!==ds.view&&(_commands.blackboard.state=codeEditorInstance.getState(),modal.hide(),editor.execCommand("ToggleView",!1,"codepro"),(0,_preferences.setPref)("view","panel",!0))})),modal.getRoot().on(_modal_events.default.hidden,(()=>{var _codeEditorInstance10;null===(_codeEditorInstance10=codeEditorInstance)||void 0===_codeEditorInstance10||_codeEditorInstance10.setValue()}));const currentTheme=(0,_preferences.getPref)("theme","light"),currentWrap=(0,_preferences.getPref)("wrap","false"),currentFs=(0,_preferences.getPref)("fs","false");return"light"!==currentTheme&&modal.footer.find("button.btn.btn-light[data-theme]").click(),"true"===currentWrap&&modal.footer.find("button.btn.btn-light[data-wrap]").click(),"true"===currentFs&&modal.footer.find("button.btn.btn-light[data-fs]").click(),modal}}));

//# sourceMappingURL=ui.min.js.map