define("tiny_codepro/view",["exports","./ui","./preferences","./options","./commands"],(function(_exports,_ui,_preferences,_options,_commands){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.createView=
/**
   * Tiny CodePro plugin.
   *
   * @module      tiny_codepro/plugin
   * @copyright   2023 Josep Mulet Pol <pep.mulet@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
function(editor,translations){const[opendialogStr,fullscreenStr,themesStr,linewrapStr,prettifyStr]=translations;let codeEditorInstance;editor.ui.registry.addIcon("tiny_codepro-tinymce",'<svg xmlns="http://www.w3.org/2000/svg" height="21" width="21" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 940.6 959.5"><path d="M621.6 0c159.9.9 317.9 133.8 317.9 327.5 0 0 1 49.2 1.1 108.8v24.9c0 11.2-.1 22.5-.2 33.8l-.2 16.9c-.7 47.6-2.4 91.9-5.8 114.9-22.2 148-132.7 250.2-285 276.2-137.3 26.8-218.7 42.3-245 47.5-11.3 2.4-61.1 9-82.7 9C154.3 959.5 2.4 834.1 0 632v-33.3l.1-5.7v-12.4c0-21.8.1-48.5.2-76l.1-16.5c.2-52.5.7-104.9 1.5-129C7.6 211.6 109.6 92.4 303.8 54.2L551.1 6.1C573.7 1.9 598.6 0 621.6 0z" fill="#0c132c"/><path d="M733.5 538.7l-150.4 29.2v147l-376.2 73V421.2l150.4-29.1v219.6l225.8-43.8V348.3l-225.8 43.8V245l376.2-73z" fill="#fff" fill-rule="evenodd"/></svg>'),editor.ui.registry.addIcon("tiny_codepro-sun",'<svg xmlns="http://www.w3.org/2000/svg" height="21" width="21" viewBox="0 0 512 512"><path d="M256 160c-52.9 0-96 43.1-96 96s43.1 96 96 96 96-43.1 96-96-43.1-96-96-96zm246.4 80.5l-94.7-47.3 33.5-100.4c4.5-13.6-8.4-26.5-21.9-21.9l-100.4 33.5-47.4-94.8c-6.4-12.8-24.6-12.8-31 0l-47.3 94.7L92.7 70.8c-13.6-4.5-26.5 8.4-21.9 21.9l33.5 100.4-94.7 47.4c-12.8 6.4-12.8 24.6 0 31l94.7 47.3-33.5 100.5c-4.5 13.6 8.4 26.5 21.9 21.9l100.4-33.5 47.3 94.7c6.4 12.8 24.6 12.8 31 0l47.3-94.7 100.4 33.5c13.6 4.5 26.5-8.4 21.9-21.9l-33.5-100.4 94.7-47.3c13-6.5 13-24.7 .2-31.1zm-155.9 106c-49.9 49.9-131.1 49.9-181 0-49.9-49.9-49.9-131.1 0-181 49.9-49.9 131.1-49.9 181 0 49.9 49.9 49.9 131.1 0 181z"/></svg>'),editor.ui.registry.addIcon("tiny_codepro-moon",'<svg xmlns="http://www.w3.org/2000/svg" height="21" width="21" viewBox="0 0 512 512"><path d="M283.2 512c79 0 151.1-35.9 198.9-94.8 7.1-8.7-.6-21.4-11.6-19.4-124.2 23.7-238.3-71.6-238.3-197 0-72.2 38.7-138.6 101.5-174.4 9.7-5.5 7.3-20.2-3.8-22.2A258.2 258.2 0 0 0 283.2 0c-141.3 0-256 114.5-256 256 0 141.3 114.5 256 256 256z"/></svg></svg>'),editor.ui.registry.addIcon("tiny_codepro-magic",'<svg xmlns="http://www.w3.org/2000/svg" height="21" width="21" viewBox="0 0 512 512"><path d="M224 96l16-32 32-16-32-16-16-32-16 32-32 16 32 16 16 32zM80 160l26.7-53.3L160 80l-53.3-26.7L80 0 53.3 53.3 0 80l53.3 26.7L80 160zm352 128l-26.7 53.3L352 368l53.3 26.7L432 448l26.7-53.3L512 368l-53.3-26.7L432 288zm70.6-193.8L417.8 9.4C411.5 3.1 403.3 0 395.2 0c-8.2 0-16.4 3.1-22.6 9.4L9.4 372.5c-12.5 12.5-12.5 32.8 0 45.3l84.9 84.9c6.3 6.3 14.4 9.4 22.6 9.4 8.2 0 16.4-3.1 22.6-9.4l363.1-363.2c12.5-12.5 12.5-32.8 0-45.2zM359.5 203.5l-50.9-50.9 86.6-86.6 50.9 50.9-86.6 86.6z"/></svg>'),editor.ui.registry.addIcon("tiny_codepro-exchange",'<svg xmlns="http://www.w3.org/2000/svg" height="21" width="21" viewBox="0 0 512 512"><path d="M0 168v-16c0-13.3 10.7-24 24-24h360V80c0-21.4 25.9-32 41-17l80 80c9.4 9.4 9.4 24.6 0 33.9l-80 80C410 272 384 261.5 384 240v-48H24c-13.3 0-24-10.7-24-24zm488 152H128v-48c0-21.3-25.9-32.1-41-17l-80 80c-9.4 9.4-9.4 24.6 0 33.9l80 80C102.1 464 128 453.4 128 432v-48h360c13.3 0 24-10.7 24-24v-16c0-13.3-10.7-24-24-24z"/></svg>'),editor.ui.registry.addIcon("tiny_codepro-arrowright",'<svg xmlns="http://www.w3.org/2000/svg" height="21" width="21" viewBox="0 0 512 512"><path d="M313.9 216H12c-6.6 0-12 5.4-12 12v56c0 6.6 5.4 12 12 12h301.9v46.1c0 21.4 25.9 32.1 41 17l86.1-86.1c9.4-9.4 9.4-24.6 0-33.9l-86.1-86.1c-15.1-15.1-41-4.4-41 17V216z"/></svg>'),editor.ui.registry.addIcon("tiny_codepro-eye",'<svg xmlns="http://www.w3.org/2000/svg" height="21" width="21" viewBox="0 0 560 512"><path d="M572.5 241.4C518.3 135.6 410.9 64 288 64S57.7 135.6 3.5 241.4a32.4 32.4 0 0 0 0 29.2C57.7 376.4 165.1 448 288 448s230.3-71.6 284.5-177.4a32.4 32.4 0 0 0 0-29.2zM288 400a144 144 0 1 1 144-144 143.9 143.9 0 0 1 -144 144zm0-240a95.3 95.3 0 0 0 -25.3 3.8 47.9 47.9 0 0 1 -66.9 66.9A95.8 95.8 0 1 0 288 160z"/></svg>');const saveAction=()=>{if(codeEditorInstance){const codeContent=codeEditorInstance.getValue();console.log("Autosave"),editor.setContent(codeContent)}},buttons=[{type:"button",text:" ",icon:"fullscreen",tooltip:fullscreenStr,onAction:()=>{editor.execCommand("mceFullScreen")}},{type:"togglebutton",text:" ",icon:"tiny_codepro-sun",tooltip:themesStr,onAction:api=>{if(!codeEditorInstance)return;const isDark=api.isActive();api.setActive(!isDark),api.setIcon(isDark?"tiny_codepro-sun":"tiny_codepro-moon");const theme=isDark?"light":"dark";codeEditorInstance.setTheme(theme),(0,_preferences.setPref)("theme",theme,!0)},onSetup:api=>{const isDark="dark"===(0,_preferences.getPref)("theme","light");api.setActive(isDark),api.setIcon(isDark?"tiny_codepro-sun":"tiny_codepro-moon")}},{type:"togglebutton",text:" ",icon:"tiny_codepro-exchange",tooltip:linewrapStr,onAction:api=>{if(!codeEditorInstance)return;const isWrap=api.isActive();api.setActive(isWrap),api.setIcon(isWrap?"tiny_codepro-exchange":"tiny_codepro-arrowright"),codeEditorInstance.setLineWrapping(isWrap),(0,_preferences.setPref)("wrap",isWrap+"",!0)},onSetup:api=>{const isWrap="true"===(0,_preferences.getPref)("wrap","false");api.setActive(isWrap),api.setIcon(isWrap?"tiny_codepro-arrowright":"tiny_codepro-exchange")}},{type:"button",text:" ",icon:"tiny_codepro-magic",tooltip:prettifyStr,onAction:()=>{var _codeEditorInstance;null===(_codeEditorInstance=codeEditorInstance)||void 0===_codeEditorInstance||_codeEditorInstance.prettify()}},{type:"button",text:" tinyMCE",icon:"tiny_codepro-tinymce",buttonType:"primary",onAction:()=>{saveAction(),editor.execCommand("ToggleView",!1,"codepro")}}],defaultUI=(0,_options.getDefaultUI)(editor)??"dialog";defaultUI.startsWith("user:")&&buttons.unshift({type:"button",text:" ",icon:"tiny_codepro-eye",tooltip:opendialogStr,onAction:()=>{_commands.blackboard.state=codeEditorInstance.getState(),editor.execCommand("ToggleView",!1,"codepro"),(0,_ui.displayDialogue)(editor),(0,_preferences.setPref)("view","dialog",!0)}});return{buttons:buttons,onShow:async api=>{if(!codeEditorInstance){const container=api.getContainer();container.classList.add("tiny_codepro-view__pane");const shadowRoot=container.attachShadow({mode:"open"}),cmElement=document.createElement("DIV");cmElement.classList.add("tiny_codepro-container");const shadowStyles=document.createElement("style");shadowStyles.textContent="\n                .tiny_codepro-container {\n                    height: 100%;\n                }\n                .cm-editor.cm-focused {\n                    outline: none!important;\n                }\n                .cm-editor {\n                    height: 100%;\n                }",shadowRoot.appendChild(shadowStyles),shadowRoot.appendChild(cmElement);const CodeProEditor=await(0,_ui.requireCm6Pro)();codeEditorInstance=new CodeProEditor(cmElement,{changesListener:saveAction})}if(_commands.blackboard.state)codeEditorInstance.setState(_commands.blackboard.state),_commands.blackboard.state=null;else{var _codeEditorInstance3;const syncCaret=(0,_options.isSyncCaret)(editor);let markerNode;if(syncCaret){markerNode=document.createElement("SPAN"),markerNode.innerHTML="&nbsp;",markerNode.classList.add("CmCaReT");editor.selection.getStart().append(markerNode)}let html=editor.getContent({source_view:!0});var _codeEditorInstance2;if(syncCaret&&(html=html.replace(/<span\s+class="CmCaReT"([^>]*)>([^<]*)<\/span>/gm,String.fromCharCode(0)),markerNode.remove()),(0,_options.isAutoFormatHTML)(editor))html=null===(_codeEditorInstance2=codeEditorInstance)||void 0===_codeEditorInstance2?void 0:_codeEditorInstance2.prettifyCode(html);null===(_codeEditorInstance3=codeEditorInstance)||void 0===_codeEditorInstance3||_codeEditorInstance3.setValue(html)}},onHide:()=>{}}}}));

//# sourceMappingURL=view.min.js.map