define("tiny_codepro/viewpanel",["exports","./options","./viewmanager"],(function(_exports,_options,_viewmanager){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.ViewPanelManager=void 0;
/**
   * Tiny CodePro plugin.
   *
   * @module      tiny_codepro/plugin
   * @copyright   2023-2025 Josep Mulet Pol <pep.mulet@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const activeViewPanels=new Map;let submitListenerAction=null;class ViewPanelManager extends _viewmanager.ViewManager{constructor(editor,opts){super(editor,opts),this.translations=this.opts.translations??[],this.isViewCreated=!1}_tShow(){this.editor.execCommand("ToggleView",!1,"codepro")}_tClose(){this.editor.execCommand("ToggleView",!1,"codepro")}_tDestroy(){activeViewPanels.delete(this.editor.id)}_tAdjustOptions(options){var _this$editor$containe;options.changesListener=()=>{this.pendingChanges=!0};(null===(_this$editor$containe=this.editor.container.closest("form"))||void 0===_this$editor$containe?void 0:_this$editor$containe.querySelector('[type="submit"]'))||(options.onblur=()=>{this.pendingChanges&&this._quickSave()});(0,_options.isFullscreen)(this.editor)||(options.lineWrapping=!0)}async _tCreate(){if(this.isViewCreated)return;this.isViewCreated=!0,this._registerIcons();const viewSpec=this._createViewSpec();this.editor.ui.registry.addView("codepro",viewSpec)}_createUI(api){const container=api.getContainer();container.classList.add("tiny_codepro-view__pane");const shadowRoot=container.attachShadow({mode:"open"}),shadowStyles=document.createElement("style");shadowStyles.textContent="\n        .cm-editor.cm-focused {\n            border-color: #86b7fe;\n            outline: 0!important;\n            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);\n            border-radius: 4px;\n        }\n        .cm-editor {\n            height: 100%;\n            width: 100%;\n        }\n        .cm-scroller {\n            overscroll-behavior: contain;\n        }\n        .tiny_codepro-loader {\n            position: absolute;\n            z-index: 100;\n            top: 50%;\n            left: 50%;\n            width: 16px;\n            height: 16px;\n            border-radius: 50%;\n            background-color: #999;\n            box-shadow: 32px 0 #999, -32px 0 #999;\n            animation: tiny_codepro-flash 0.5s ease-out infinite alternate;\n        }\n        @keyframes tiny_codepro-flash {\n            0% {\n            background-color: #FFF2;\n            box-shadow: 32px 0 #FFF2, -32px 0 #999;\n            }\n            50% {\n            background-color: #999;\n            box-shadow: 32px 0 #FFF2, -32px 0 #FFF2;\n            }\n            100% {\n            background-color: #FFF2;\n            box-shadow: 32px 0 #999, -32px 0 #FFF2;\n            }\n        }\n        @media only screen and (max-width: 767px) {\n            .cm-gutters.cm-minimap-gutter {\n                display: none!important;\n            }\n        }",shadowRoot.appendChild(shadowStyles),this.codeEditorElement=shadowRoot}_setButtonsState(){const{btnDescreaseFontsize:btnDescreaseFontsize,btnIncreaseFontsize:btnIncreaseFontsize,btnTheme:btnTheme,btnAccept:btnAccept}=this.domElements;btnDescreaseFontsize.style.marginRight="0",btnIncreaseFontsize.style.marginLeft="0";const isDark="dark"===this.preferencesSrv.get("theme","light");_viewmanager.ViewManager.safeInnerHTML(btnTheme,"span",isDark?_viewmanager.ViewManager.icons.moon:_viewmanager.ViewManager.icons.sun),isDark?this.parentContainer.classList.add("tiny_codepro-dark"):this.parentContainer.classList.remove("tiny_codepro-dark");const btnAcceptSvg=null==btnAccept?void 0:btnAccept.querySelector("svg");btnAcceptSvg&&(btnAcceptSvg.style.marginRight="5px"),(0,_options.isFullscreen)(this.editor)?(this.domElements.btnWrap.style.display="initial",this.parentContainer&&(this.parentContainer.style.height="")):(this.domElements.btnWrap.style.display="none",this.parentContainer&&(this.parentContainer.style.height="350px"))}_createViewSpec(){return{buttons:this._createButtons(),onShow:async api=>{var _this$parentContainer;const docHead=await this.loadDocInfo();if(activeViewPanels.set(this.editor.id,this),!this.codeEditorElement){this._createUI(api);const submitButtons=document.querySelectorAll('button[type="submit"],input[type="submit"]');submitButtons.length&&!submitListenerAction&&(submitListenerAction=()=>{try{Array.from(activeViewPanels.values()).filter((vp=>vp.pendingChanges)).forEach((viewPanel=>viewPanel._quickSave())),submitButtons.forEach((btn=>btn.removeEventListener("click",submitListenerAction)))}catch(ex){console.error(ex)}},submitButtons.forEach((btn=>btn.addEventListener("click",submitListenerAction))))}const container=api.getContainer();this.parentContainer=container.parentElement;const headerButtonElements=(null===(_this$parentContainer=this.parentContainer)||void 0===_this$parentContainer?void 0:_this$parentContainer.querySelectorAll(".tox-view__header button"))??[],buttonsArray=Array.from(headerButtonElements),bLen=buttonsArray.length;this.domElements={root:this.parentContainer,btnDescreaseFontsize:buttonsArray[bLen-6],btnIncreaseFontsize:buttonsArray[bLen-5],btnTheme:buttonsArray[bLen-4],btnWrap:buttonsArray[bLen-3],btnPrettify:buttonsArray[bLen-2],btnAccept:buttonsArray[bLen-1]},this._setButtonsState(),this._showSpinner(this.codeEditorElement),await this.attachCodeEditor(this.codeEditorElement,docHead),this._hideSpinner(this.codeEditorElement)},onHide:()=>{this.parentContainer&&(this.parentContainer.style.height="")}}}_registerIcons(){Object.keys(_viewmanager.ViewManager.icons).forEach((key=>{this.editor.ui.registry.addIcon(`tiny_codepro-${key}`,_viewmanager.ViewManager.icons[key])}))}_createButtons(){const[opendialogStr,fullscreenStr,themesStr,linewrapStr,prettifyStr,decreaseFontsizeStr,increaseFontsizeStr]=this.translations,buttons=[{type:"button",text:" ",icon:"tiny_codepro-fullscreen",tooltip:fullscreenStr,onAction:()=>{!(0,_options.isFullscreen)(this.editor)?(this.domElements.btnWrap.style.display="initial",this.parentContainer&&(this.parentContainer.style.height="")):(this.domElements.btnWrap.style.display="none",this.parentContainer&&(this.parentContainer.style.height="350px"),this.codeEditor.config.lineWrapping||this.toggleLineWrapping(!1)),this.editor.execCommand("mceFullScreen")}},{type:"button",text:"",icon:"tiny_codepro-decreasefontsize",tooltip:decreaseFontsizeStr,onAction:this.decreaseFontsize.bind(this)},{type:"button",text:"",icon:"tiny_codepro-increasefontsize",tooltip:increaseFontsizeStr,onAction:this.increaseFontsize.bind(this)},{type:"button",text:" ",icon:"tiny_codepro-sun",tooltip:themesStr,onAction:this.toggleTheme.bind(this)},{type:"button",text:" ",icon:"tiny_codepro-exchange",tooltip:linewrapStr,onAction:this.toggleLineWrapping.bind(this)},{type:"button",text:" ",icon:"tiny_codepro-magic",tooltip:prettifyStr,onAction:()=>this.prettify(this.domElements.btnPrettify)},{type:"button",text:" tinyMCE",icon:"tiny_codepro-tinymce",buttonType:"primary",onAction:this.accept.bind(this)}];return((0,_options.getDefaultUI)(this.editor)??"dialog").startsWith("user:")&&buttons.unshift({type:"button",text:" ",icon:"tiny_codepro-eye",tooltip:opendialogStr,onAction:this.switchViews.bind(this)}),buttons}}_exports.ViewPanelManager=ViewPanelManager}));

//# sourceMappingURL=viewpanel.min.js.map