define("tiny_widgethub/controller/form_ctrl",["exports","../service/file_service","../service/template_service","../service/userstorage_service","../util","jquery"],(function(_exports,_file_service,_template_service,_userstorage_service,_util,_jquery){var obj;
/**
   * Tiny WidgetHub plugin.
   *
   * @module      tiny_widgethub/plugin
   * @copyright   2024 Josep Mulet Pol <pep.mulet@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.Templates=_exports.FormCtrl=void 0,_exports.getFormCtrl=function(editor){let instance=formCtrlInstances.get(editor);instance||(instance=new FormCtrl(editor,(0,_userstorage_service.getUserStorage)(editor),(0,_template_service.getTemplateSrv)(),(0,_file_service.getFileSrv)(editor),_jquery.default),formCtrlInstances.set(editor,instance));return instance},_jquery=(obj=_jquery)&&obj.__esModule?obj:{default:obj};const questionPopover='{{#tooltip}}<a href="javascript:void(0)" data-toggle="popover" data-trigger="hover" data-content="{{tooltip}}" data-bs-toggle="popover" data-bs-trigger="hover" data-bs-content="{{tooltip}}"><i class="fa fas fa-question-circle text-info"></i></a>{{/tooltip}}',Templates={TEXTFIELDTEMPLATE:`<div id="{{elementid}}" class="form-group row mx-1{{#hidden}} d-none{{/hidden}}"><label class="col-sm-5 col-form-label" for="{{elementid}}_ftmpl" title="{{varname}}">{{vartitle}} ${questionPopover}</label>\n   <div class="col-sm-7"><input type="text" id="{{elementid}}_ftmpl" class="form-control" name="{{varname}}" {{#disabled}}disabled{{/disabled}} value="{{defaultvalue}}"/></div>\n   </div>`,IMAGETEMPLATE:`<div id="{{elementid}}" class="form-group row mx-1{{#hidden}} d-none{{/hidden}}"><label class="col-sm-5 col-form-label" for="{{elementid}}_ftmpl" title="{{varname}}">{{vartitle}} ${questionPopover}</label>\n   <div class="col-sm-7">\n   <input type="text" id="{{elementid}}_ftmpl" class="form-control d-inline-block w-75" name="{{varname}}" {{#disabled}}disabled{{/disabled}} value="{{defaultvalue}}"/>\n   <button class="whb-image-picker btn btn-sm btn-secondary d-inline-block" title="Search"><i class="fas fa fa-search"></i></button>\n   </div>\n   </div>`,NUMERICTEMPLATE:`<div id="{{elementid}}" class="form-group row mx-1{{#hidden}} d-none{{/hidden}}"><label class="col-sm-5 col-form-label"  for="{{elementid}}_fntmpl" title="{{varname}}">{{vartitle}} ${questionPopover}</label>\n   <div class="col-sm-7"><input type="number" id="{{elementid}}_fntmpl" class="form-control" name="{{varname}}" {{{minMax}}} {{#disabled}}disabled{{/disabled}} value="{{defaultvalue}}"/></div>\n   </div>`,COLORTEMPLATE:`<div id="{{elementid}}" class="form-group row mx-1{{#hidden}} d-none{{/hidden}}"><label class="col-sm-5 col-form-label"  for="{{elementid}}_fntmpl" title="{{varname}}">{{vartitle}} ${questionPopover}</label>\n   <div class="col-sm-7">\n   <span class="w-50 tiny_widgethub-pattern">\n      <input type="color" id="{{elementid}}_fctmpl" name="{{varname}}" {{#disabled}}disabled{{/disabled}} value="{{defaultvalue}}"/>\n   </span>\n   <input type="range" id="{{elementid}}_fcatmpl" title="Opacity" name="{{varname}}_alpha" {{#disabled}}disabled{{/disabled}} value="{{defaultvalueAlpha}}" min="0" max="1" step="0.01"/>\n   </div></div>`,TEXTAREATEMPLATE:`<div id="{{elementid}}" class="form-group{{#hidden}} d-none{{/hidden}}"><label for="{{elementid}}_tatmpl" title="{{varname}}">{{vartitle}} ${questionPopover}</label>\n   <textarea id="{{elementid}}_tatmpl" rows="3" class="form-control" name="{{varname}}" {{#disabled}}disabled{{/disabled}} {{#tooltip}}title="{{tooltip}}"{{/tooltip}}>{{defaultvalue}}</textarea>\n   </div>`,CHECKBOXTEMPLATE:`<div id="{{elementid}}" class="form-group w-75 m-2{{#hidden}} d-none{{/hidden}}">\n   <label>\n   <input title="{{varname}}" id="{{elementid}}_cbtmpl" {{#disabled}}disabled{{/disabled}} type="checkbox" name="{{varname}}" value="{{defaultvalue}}" {{#defaultvalue}}checked{{/defaultvalue}}/></span>\n   {{vartitle}}</label> <span>&nbsp;&nbsp;  ${questionPopover}</span>\n   </div>`,SELECTTEMPLATE:`<div id="{{elementid}}" class="form-group row mx-1{{#hidden}} d-none{{/hidden}}">\n   <label class="col-sm-5 col-form-label" for="{{elementid}}_stmpl" title="{{varname}}">{{vartitle}} ${questionPopover}</label>\n   <div class="col-sm-7">\n   <select id="{{elementid}}_stmpl" class="form-control" name="{{varname}}" {{#disabled}}disabled{{/disabled}} {{#tooltip}}title="{{tooltip}}"{{/tooltip}}>\n   {{#options}}\n   <option value="{{optionValue}}"{{#selected}} selected{{/selected}}>{{optionLabel}}</option>\n   {{/options}}\n   </select>\n   </div>\n   </div>`,AUTOCOMPLETETEMPLATE:`<div id="{{elementid}}" class="form-group row mx-1{{#hidden}} d-none{{/hidden}}"><label class="col-sm-5 col-form-label" for="{{elementid}}_ftmpl" title="{{varname}}">{{vartitle}} ${questionPopover}</label>\n   <div class="col-sm-7"><input type="text" list="{{elementid}}_aclist" id="{{elementid}}_actmpl" class="form-control" name="{{varname}}" {{#disabled}}disabled{{/disabled}} value="{{defaultvalue}}" autocomplete="off"/>\n   <datalist id="{{elementid}}_aclist">\n   {{#options}}\n   <option value="{{optionValue}}"/>\n   {{/options}}\n   </datalist>\n   </div>\n   </div>`};_exports.Templates=Templates;class FormCtrl{constructor(editor,userStorage,templateSrv,fileSrv,jQuery){this.editor=editor,this.storage=userStorage,this.templateSrv=templateSrv,this.fileSrv=fileSrv,this.jQuery=jQuery}createContext(widget){const mustSaveAll=this.storage.getFromLocal("saveall",!1),saveAllData=this.storage.getFromLocal("saveall_data",{}),values=this.storage.getFromLocal("values",{}),defaults=widget.defaults,controls=widget.parameters.map((param=>this.createControlHTML(this.editor.id,param,(param=>{const sname=widget.key,pname=param.name;let currentval=defaults[pname];var _saveAllData$sname;return pname.startsWith("_")&&values[pname]&&(currentval=values[pname]),mustSaveAll&&null!==((null===(_saveAllData$sname=saveAllData[sname])||void 0===_saveAllData$sname?void 0:_saveAllData$sname[pname])??null)&&(currentval=saveAllData[sname][pname]),currentval})(param))));return{idtabpane:(0,_util.genID)(),selectmode:this.editor.selection.getContent().trim().length>0,name:widget.name,instructions:widget.instructions,filter:widget.isFilter(),controls:controls}}createControlHTML(hostId,param,defaultValue){let markup="";const pname=(0,_util.cleanParameterName)(param.name),generalCtx={elementid:hostId+"_"+pname,varname:pname,vartitle:param.title,defaultvalue:defaultValue,tooltip:param.tip||param.tooltip,disabled:!1===param.editable,hidden:!0===param.hidden};if("textarea"===param.type)markup=this.templateSrv.renderMustache(Templates.TEXTAREATEMPLATE,generalCtx);else if("numeric"===param.type){let minMax="";param.min&&(minMax+=`min="${param.min}"`),param.max&&(minMax+=` max="${param.max}"`),markup=this.templateSrv.renderMustache(Templates.NUMERICTEMPLATE,{minMax:minMax,...generalCtx})}else if("checkbox"===param.type)markup=this.templateSrv.renderMustache(Templates.CHECKBOXTEMPLATE,generalCtx);else if("select"===param.type||"autocomplete"===param.type){const options=(param.options??[]).map((opt=>{let label,value;return"string"==typeof opt?(label=(0,_util.capitalize)(opt),value=opt):(label=opt.l,value=opt.v),{optionLabel:label,optionValue:value,selected:value===defaultValue}})),tmpl="select"===param.type?Templates.SELECTTEMPLATE:Templates.AUTOCOMPLETETEMPLATE;markup=this.templateSrv.renderMustache(tmpl,{options:options,...generalCtx})}else if("color"===param.type){const[hex,alpha]=(0,_util.toHexAlphaColor)(generalCtx.defaultvalue);generalCtx.defaultvalue=hex,generalCtx.defaultvalueAlpha=alpha,markup=this.templateSrv.renderMustache(Templates.COLORTEMPLATE,generalCtx)}else markup="image"===param.type?this.templateSrv.renderMustache(Templates.IMAGETEMPLATE,generalCtx):this.templateSrv.renderMustache(Templates.TEXTFIELDTEMPLATE,generalCtx);return markup}extractFormParameters(widget,form,doStore){const ctx={},toPersist={},defaults=widget.defaults;if(widget.parameters.forEach((param=>{const pname=param.name,cleanPname=(0,_util.cleanParameterName)(pname),$elem=form.find(`[name="${cleanPname}"]`);if(!$elem.length)return void(ctx[pname]=defaults[pname]);let value=$elem.val()??"";if("INPUT"===$elem.prop("tagName")&&"checkbox"===$elem.attr("type"))value=$elem.is(":checked");else if("INPUT"===$elem.prop("tagName")&&"number"===$elem.attr("type"))value=value.indexOf(".")>=0?parseFloat(value):parseInt(value);else if("INPUT"===$elem.prop("tagName")&&"color"===$elem.attr("type")){const alpha=form.find(`[name="${cleanPname}_alpha"]`).val()??1;value=(0,_util.toRgba)(value,+alpha)}param.transform&&(value=(0,_util.stream)(param.transform).reduce(value)),ctx[pname]=value,pname.trim().startsWith("_")&&(toPersist[pname]=value)})),doStore&&this.storage){Object.keys(toPersist).length&&this.storage.setToLocal("values",toPersist,!0);if(this.storage.getFromLocal("saveall",!1)){const previousAllData=this.storage.getFromLocal("saveall_data",{});previousAllData[widget.name]={...ctx},this.storage.setToLocal("saveall_data",previousAllData,!0)}}return ctx}attachPickers(body){const canShowFilePicker=void 0!==this.fileSrv.getImagePicker(),picker=body.find("button.whb-image-picker").prop("disabled",!canShowFilePicker);canShowFilePicker&&picker.on("click",(async evt=>{evt.preventDefault();try{const params=await this.fileSrv.displayImagePicker();null!=params&&params.url&&this.jQuery(evt.currentTarget).parent().find("input").val(params.url)}catch(ex){console.error(ex)}})),body.find('input[type="color"]').each(((_,e)=>{const $inputColor=this.jQuery(e),name=$inputColor.attr("name")??"",$inputRange=body.find(`input[name="${name}_alpha"]`),opacity=$inputRange.val()??1;$inputColor.css("opacity",""+opacity),$inputRange.on("change",(()=>{const opacity=$inputRange.val()??1;$inputColor.css("opacity",""+opacity)}))}))}applyFieldWatchers($formElem,defaultsData,widget,selectmode){const watchedvars=[],updatableComponents=[],regex=/\{{2}([^}]*)\}{2}/gm;for(let indx=0,len=widget.parameters.length;indx<len;indx++){const varobj=widget.parameters[indx];if(varobj.when){const condition=varobj.when,t=varobj.type,control=$formElem.find(`[name="${(0,_util.cleanParameterName)(varobj.name)}"]`);if(!control.length||!t)continue;updatableComponents.push({condition:condition.replace(/[{}]{2}/g,""),component:control,indx:indx,type:t});const varsInvolved=condition.match(regex);null==varsInvolved||varsInvolved.forEach((evar=>{evar=evar.replace(/[{}]*/g,"").trim(),watchedvars.indexOf(evar)<0&&null!==(defaultsData[evar]??null)&&watchedvars.push(evar)}))}watchedvars.push(varobj.name)}const doUpdateVisibilities=()=>{updatableComponents.forEach((cc=>{const newVariables=this.extractFormParameters(widget,$formElem,!1);newVariables.SELECT_MODE=selectmode;const showme=(0,_util.evalInContext)(newVariables,cc.condition);let theComponent=cc.component;theComponent&&(theComponent=theComponent.closest(".form-group"),theComponent.attr("data-amagat")||(showme?theComponent.show():theComponent.hide()))}))};widget.parameters.forEach((varobj=>{const control=$formElem.find(`[name="${(0,_util.cleanParameterName)(varobj.name)}"]`);if(watchedvars.indexOf(varobj.name)<0||!control[0])return;let evtName="change";"textfield"!==varobj.type&&"textarea"!==varobj.type||(evtName="keyup"),control.on(evtName,(()=>{doUpdateVisibilities()}))})),doUpdateVisibilities()}}_exports.FormCtrl=FormCtrl;const formCtrlInstances=new Map}));

//# sourceMappingURL=form_ctrl.min.js.map