define("tiny_widgethub/controller/widgetpicker_ctrl",["exports","core/str","../controller/widgetparams_ctrl","../options","../service/modal_service","../service/template_service","../service/userstorage_service","../util"],(function(_exports,_str,_widgetparams_ctrl,_options,_modal_service,_template_service,_userstorage_service,_util){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.WidgetPickerCtrl=void 0,_exports.getWidgetPickCtrl=function(editor){let instance=widgetPickerCtrlInstances.get(editor);instance||(instance=new WidgetPickerCtrl(editor,(0,_options.getEditorOptions)(editor),(0,_widgetparams_ctrl.getWidgetParamsFactory)(editor),(0,_modal_service.getModalSrv)(),(0,_template_service.getTemplateSrv)(),(0,_userstorage_service.getUserStorage)(editor)),widgetPickerCtrlInstances.set(editor,instance));return instance},_exports.setVisibility=void 0;
/**
   * Tiny WidgetHub plugin.
   *
   * @module      tiny_widgethub/plugin
   * @copyright   2024 Josep Mulet Pol <pep.mulet@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const setVisibility=function(el,visible){el&&(visible?el.classList.remove("d-none"):el.classList.add("d-none"))};_exports.setVisibility=setVisibility;class WidgetPickerCtrl{modal;constructor(editor,editorOptions,widgetParamsFactory,modalSrv,templateSrv,userStorage){this.editor=editor,this.editorOptions=editorOptions,this.widgetParamsFactory=widgetParamsFactory,this.modalSrv=modalSrv,this.templateSrv=templateSrv,this.storage=userStorage,this.scrollPos=0}isSelectMode(){return this.editor.selection.getContent().trim().length>0}setWidgetButtonsVisibility(bodyForm,searchtext){let numshown=0;const selectmode=this.isSelectMode();return bodyForm.find(".tiny_widgethub-btn-group").each(((i,el)=>{let visible=!selectmode||selectmode&&"true"===el.dataset.selectable;const el2=el.querySelector("button");visible=visible&&null!==el2&&(""===searchtext.trim()||(0,_util.searchComp)(el2.textContent??"",searchtext)||(0,_util.searchComp)(el2.dataset.title??"",searchtext)),setVisibility(el,visible),visible&&numshown++})),numshown}onSearchKeyup(){const searchtext=this.modal.body.find("input").val()??"";this.storage.setToSession("searchtext",searchtext,!0);const numshown=this.setWidgetButtonsVisibility(this.modal.body,searchtext);setVisibility(this.modal.body.find(".tiny_widgethub-emptylist")[0],0==numshown);this.modal.body.find(".tiny_widgethub-category").each(((_,el)=>{const count=el.querySelectorAll(".tiny_widgethub-btn-group:not(.d-none)").length;setVisibility(el,count>0)}))}async onMouseEnterButton(evt){var _evt$target,_evt$target$closest,_evt$target$closest$d;const widget=this.editorOptions.widgetDict[(null===(_evt$target=evt.target)||void 0===_evt$target||null===(_evt$target$closest=_evt$target.closest(".tiny_widgethub-btn-group"))||void 0===_evt$target$closest||null===(_evt$target$closest$d=_evt$target$closest.dataset)||void 0===_evt$target$closest$d?void 0:_evt$target$closest$d.key)??""];if(!widget||widget.isFilter())return;let html=widget._preview;html||(html=await this.generatePreview(widget),widget._preview=html),this.modal.body.find("div.tiny_widgethub-preview").html(html).css("display","block")}async createModal(){var _this$modal$header$;const searchtext=this.storage.getFromSession("searchtext",""),data={...this.getPickTemplateContext(),searchtext:searchtext};this.modal=await this.modalSrv.create("picker",data);const blinkElem=document.createElement("SPAN");blinkElem.classList.add("tiny_widgethub-blink","d-none");const selectModeStr=await(0,_str.get_string)("selectmode","tiny_widgethub");blinkElem.innerHTML=`<span class="twh-icon">\n        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M48 115.8C38.2 107 32 94.2 32 80c0-26.5 21.5-48 48-48c14.2 0 27 6.2 35.8 16l344.4 0c8.8-9.8 21.6-16 35.8-16c26.5 0 48 21.5 48 48c0 14.2-6.2 27-16 35.8l0 280.4c9.8 8.8 16 21.6 16 35.8c0 26.5-21.5 48-48 48c-14.2 0-27-6.2-35.8-16l-344.4 0c-8.8 9.8-21.6 16-35.8 16c-26.5 0-48-21.5-48-48c0-14.2 6.2-27 16-35.8l0-280.4zM125.3 96c-4.8 13.6-15.6 24.4-29.3 29.3l0 261.5c13.6 4.8 24.4 15.6 29.3 29.3l325.5 0c4.8-13.6 15.6-24.4 29.3-29.3l0-261.5c-13.6-4.8-24.4-15.6-29.3-29.3L125.3 96zm2.7 64c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-96zM256 320l32 0c35.3 0 64-28.7 64-64l0-32 64 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-32z"/></svg>\n        </span> ${selectModeStr}`,null===(_this$modal$header$=this.modal.header[0])||void 0===_this$modal$header$||_this$modal$header$.append(blinkElem);try{this.modal.body.find(".tiny_widgethub-categorycontainer").scrollspy("refresh")}catch(ex){console.error("Problem setting scrollspy",ex)}let timerEnter=null,timerOut=null;const widgetSearchElem=this.modal.body.find("input");widgetSearchElem.val(searchtext);const debouncedKeyup=(0,_util.debounce)(this.onSearchKeyup.bind(this),800);widgetSearchElem.on("keyup",debouncedKeyup),this.modal.body.find(`#widget-clearfilter-btn${data.rid}`).on("click",(()=>{debouncedKeyup.clear(),widgetSearchElem.val(""),widgetSearchElem.trigger("focus"),this.onSearchKeyup()})),this.modal.body.find("div.tiny_widgethub-categorycontainer, div.tiny_widgethub-recent").on("click",(event=>{timerEnter&&(clearTimeout(timerEnter),timerEnter=null),this.modal.body.find("div.tiny_widgethub-preview").css("display","none"),this.handlePickModalClick(event)}));this.modal.body.find(".tiny_widgethub-btn-group > button").on("mouseenter",(evt=>{clearTimeout(timerOut),timerOut=null,timerEnter=setTimeout((()=>{this.onMouseEnterButton(evt)}),500)})).on("mouseout",(evt=>{const movedFrom=evt.target,movedTo=evt.relatedTarget;if(movedFrom.classList.contains("tiny_widgethub-btn")&&movedTo.classList.contains("tiny_widgethub-btn")){var _movedFrom$parentElem,_movedFrom$parentElem2,_movedTo$parentElemen,_movedTo$parentElemen2;const key1=null==movedFrom||null===(_movedFrom$parentElem=movedFrom.parentElement)||void 0===_movedFrom$parentElem||null===(_movedFrom$parentElem2=_movedFrom$parentElem.dataset)||void 0===_movedFrom$parentElem2?void 0:_movedFrom$parentElem2.key,key2=null==movedTo||null===(_movedTo$parentElemen=movedTo.parentElement)||void 0===_movedTo$parentElemen||null===(_movedTo$parentElemen2=_movedTo$parentElemen.dataset)||void 0===_movedTo$parentElemen2?void 0:_movedTo$parentElemen2.key;if(null!=key1&&key1==key2)return}clearTimeout(timerEnter),timerEnter=null,timerOut=setTimeout((()=>{this.modal.body.find("div.tiny_widgethub-preview").html("").css("display","none")}),500)}));const scrollPane=this.modal.body.find(".tiny_widgethub-categorycontainer");scrollPane.on("scroll",(0,_util.debounce)((()=>{this.scrollPos=Math.round(scrollPane.scrollTop()??0)}),100))}async handleAction(){if(this.storage.loadStore(),this.modal){const widgetDict=this.editorOptions.widgetDict,html=this.storage.getRecentUsed().filter((r=>void 0!==widgetDict[r.key])).map((r=>`<a href="javascript:void(0)" data-key="${r.key}" data-insert="recent"><span class="badge badge-secondary">${widgetDict[r.key].name}</span></a>`)).join("\n");this.modal.body.find(".tiny_widgethub-recent").html(html)}else await this.createModal();this.onSearchKeyup();this.isSelectMode()?this.modal.header.find("span.tiny_widgethub-blink").removeClass("d-none"):this.modal.header.find("span.tiny_widgethub-blink").addClass("d-none"),this.modal.show(),setTimeout((()=>{var _this$modal;null!==(_this$modal=this.modal)&&void 0!==_this$modal&&_this$modal.body&&(this.scrollPos>0&&this.modal.body.find(".tiny_widgethub-categorycontainer").scrollTop(this.scrollPos),this.modal.body.find("input").trigger("focus"))}),200)}show(){var _this$modal2;null===(_this$modal2=this.modal)||void 0===_this$modal2||_this$modal2.show()}generatePreview(widget){const toInterpolate={...widget.defaults},engine=widget.prop("engine");return this.templateSrv.render(widget.template??"",toInterpolate,widget.I18n,engine)}getPickTemplateContext(){const categoryOrderMap={};(0,_options.getGlobalConfig)(this.editor,"category.order","").split(",").forEach((item=>{const itemOrder=item.split(":");2===itemOrder.length&&(categoryOrderMap[itemOrder[0].trim().toLocaleUpperCase()]=itemOrder[1].trim())}));const snptDict=this.editorOptions.widgetDict,allButtons=Object.values(snptDict),autoFilters=this.storage.getFromLocal("startup.filters","").split(",").map((f=>f.trim())),categories={};allButtons.forEach((btn=>{const isFilter=btn.isFilter(),catName=(btn.category??"MISC").toUpperCase();let found=categories[catName];if(!found){const color=(0,_util.hashCode)(catName)%360;let sat="30%";catName.toLowerCase().startsWith("obsolet")&&(sat="0%"),found={name:catName,order:categoryOrderMap[catName]??catName,hidden:!1,color:color+", "+sat,buttons:[]},categories[catName]=found}found.buttons.push({hidden:!1,category:catName,widgetindex:btn.id,widgetkey:btn.key,widgetname:btn.name,widgetorder:btn.prop("order")??btn.name??btn.key??"",widgettitle:btn.name+" "+catName,iconname:"fa fas fa-eye",disabled:!btn.isUsableInScope(),selectable:null!=btn.insertquery,isfilter:isFilter,filterset:isFilter&&autoFilters.includes(btn.key)})}));const categoriesList=Object.values(categories);categoriesList.sort(((a,b)=>(a.order+"").localeCompare(b.order+""))),categoriesList.forEach((cat=>{cat.buttons.sort(((a,b)=>(a.widgetorder+"").localeCompare(b.widgetorder+""))),cat.hidden=0==cat.buttons.filter((btn=>!btn.hidden)).length}));const recentList=this.storage.getRecentUsed().filter((recent=>{const key=recent.key,widget=snptDict[key];if(null==widget||!widget.isUsableInScope())return!1;const selectable=void 0!==widget.insertquery,isSelection=this.isSelectMode();return key.length>0&&(!isSelection||isSelection&&selectable)})).map((recent=>{const key=recent.key,snpt=snptDict[key];return snpt?{key:key,name:snpt.name}:{key:key,name:""}}));return{rid:(0,_util.genID)(),selectmode:this.isSelectMode(),elementid:this.editor.id,categories:categoriesList,recent:recentList}}async handlePickModalClick(event){var _button$dataset,_button$dataset2;const target=event.target;if(!target)return;const buttonWrapper=target.closest("[data-key]");let widget=null;if(buttonWrapper){var _buttonWrapper$datase;const selectedButton=null==buttonWrapper||null===(_buttonWrapper$datase=buttonWrapper.dataset)||void 0===_buttonWrapper$datase?void 0:_buttonWrapper$datase.key;selectedButton&&(widget=this.editorOptions.widgetDict[selectedButton])}if(!widget)return;const button=target.closest("button.tiny_widgethub-btn");if(null!=button&&null!==(_button$dataset=button.dataset)&&void 0!==_button$dataset&&_button$dataset.auto){const isSet="true"!==button.dataset.auto;button.dataset.auto=isSet+"",(0,_util.toggleClass)(button,"tiny_widgethub-btn-primary","tiny_widgethub-btn-outline-primary");const key=widget.key,autoFilters=new Set(this.storage.getFromLocal("startup.filters","").split(""));return isSet?autoFilters.add(key):autoFilters.delete(key),void this.storage.setToLocal("startup.filters",[...autoFilters].join(","),!0)}const aRecent=target.closest("a[data-key]");let ctx;var _this$storage$getRece;aRecent&&(ctx=null===(_this$storage$getRece=this.storage.getRecentUsed().filter((e=>e.key===widget.key))[0])||void 0===_this$storage$getRece?void 0:_this$storage$getRece.p);let confirmMsg=null;widget.isUsableInScope()||(confirmMsg=await(0,_str.get_string)("confirmusage","tiny_widgethub"));const forceInsert=null!==aRecent||"true"===(null==button||null===(_button$dataset2=button.dataset)||void 0===_button$dataset2?void 0:_button$dataset2.insert);confirmMsg?this.editor.windowManager.confirm(confirmMsg,(state=>{state&&this.handlePickModalAction(widget,forceInsert,ctx)})):this.handlePickModalAction(widget,forceInsert,ctx)}handlePickModalAction(widget,forceInsert,ctx){var _this$modal3;null===(_this$modal3=this.modal)||void 0===_this$modal3||_this$modal3.hide();const paramsController=this.widgetParamsFactory(widget);paramsController.parentCtrl=this,forceInsert||0===(widget.parameters??[]).length&&!widget.instructions?paramsController.insertWidget(ctx??{}):paramsController.handleAction()}}_exports.WidgetPickerCtrl=WidgetPickerCtrl;const widgetPickerCtrlInstances=new Map}));

//# sourceMappingURL=widgetpicker_ctrl.min.js.map