define("tiny_widgethub/libs/js_yaml-lazy",["exports"],(function(_exports){
/**
   * Tiny WidgetHub plugin.
   *
   * @module      tiny_widgethub/plugin
   * @copyright   2024 Josep Mulet Pol <pep.mulet@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
/* ! js-yaml 4.1.0 https://github.com/nodeca/js-yaml @license MIT */
function isNothing(subject){return null==subject}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.types=_exports.safeLoadAll=_exports.safeLoad=_exports.safeDump=_exports.loadAll=_exports.load=_exports.dump=_exports.default=_exports.YAMLException=_exports.Type=_exports.Schema=_exports.JSON_SCHEMA=_exports.FAILSAFE_SCHEMA=_exports.DEFAULT_SCHEMA=_exports.CORE_SCHEMA=void 0;let common={isNothing:isNothing,isObject:function(subject){return"object"==typeof subject&&null!==subject},toArray:function(sequence){return Array.isArray(sequence)?sequence:isNothing(sequence)?[]:[sequence]},repeat:function(string,count){let cycle,result="";for(cycle=0;cycle<count;cycle+=1)result+=string;return result},isNegativeZero:function(number){return 0===number&&Number.NEGATIVE_INFINITY===1/number},extend:function(target,source){let index,length,key,sourceKeys;if(source)for(sourceKeys=Object.keys(source),index=0,length=sourceKeys.length;index<length;index+=1)key=sourceKeys[index],target[key]=source[key];return target}};function formatError(exception,compact){let where="",message=exception.reason||"(unknown reason)";return exception.mark?(exception.mark.name&&(where+='in "'+exception.mark.name+'" '),where+="("+(exception.mark.line+1)+":"+(exception.mark.column+1)+")",!compact&&exception.mark.widget&&(where+="\n\n"+exception.mark.widget),message+" "+where):message}function YAMLException$1(reason,mark){Error.call(this),this.name="YAMLException",this.reason=reason,this.mark=mark,this.message=formatError(this,!1),Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):this.stack=(new Error).stack||""}YAMLException$1.prototype=Object.create(Error.prototype),YAMLException$1.prototype.constructor=YAMLException$1,YAMLException$1.prototype.toString=function(compact){return this.name+": "+formatError(this,compact)};let exception=YAMLException$1;function getLine(buffer,lineStart,lineEnd,position,maxLineLength){let head="",tail="",maxHalfLength=Math.floor(maxLineLength/2)-1;return position-lineStart>maxHalfLength&&(head=" ... ",lineStart=position-maxHalfLength+head.length),lineEnd-position>maxHalfLength&&(tail=" ...",lineEnd=position+maxHalfLength-tail.length),{str:head+buffer.slice(lineStart,lineEnd).replace(/\t/g,"→")+tail,pos:position-lineStart+head.length}}function padStart(string,max){return common.repeat(" ",max-string.length)+string}let widget=function(mark,options){if(options=Object.create(options||null),!mark.buffer)return null;options.maxLength||(options.maxLength=79),"number"!=typeof options.indent&&(options.indent=1),"number"!=typeof options.linesBefore&&(options.linesBefore=3),"number"!=typeof options.linesAfter&&(options.linesAfter=2);let match,re=/\r?\n|\r|\0/g,lineStarts=[0],lineEnds=[],foundLineNo=-1;for(;match=re.exec(mark.buffer);)lineEnds.push(match.index),lineStarts.push(match.index+match[0].length),mark.position<=match.index&&foundLineNo<0&&(foundLineNo=lineStarts.length-2);foundLineNo<0&&(foundLineNo=lineStarts.length-1);let i,line,result="",lineNoLength=Math.min(mark.line+options.linesAfter,lineEnds.length).toString().length,maxLineLength=options.maxLength-(options.indent+lineNoLength+3);for(i=1;i<=options.linesBefore&&!(foundLineNo-i<0);i++)line=getLine(mark.buffer,lineStarts[foundLineNo-i],lineEnds[foundLineNo-i],mark.position-(lineStarts[foundLineNo]-lineStarts[foundLineNo-i]),maxLineLength),result=common.repeat(" ",options.indent)+padStart((mark.line-i+1).toString(),lineNoLength)+" | "+line.str+"\n"+result;for(line=getLine(mark.buffer,lineStarts[foundLineNo],lineEnds[foundLineNo],mark.position,maxLineLength),result+=common.repeat(" ",options.indent)+padStart((mark.line+1).toString(),lineNoLength)+" | "+line.str+"\n",result+=common.repeat("-",options.indent+lineNoLength+3+line.pos)+"^\n",i=1;i<=options.linesAfter&&!(foundLineNo+i>=lineEnds.length);i++)line=getLine(mark.buffer,lineStarts[foundLineNo+i],lineEnds[foundLineNo+i],mark.position-(lineStarts[foundLineNo]-lineStarts[foundLineNo+i]),maxLineLength),result+=common.repeat(" ",options.indent)+padStart((mark.line+i+1).toString(),lineNoLength)+" | "+line.str+"\n";return result.replace(/\n$/,"")},TYPE_CONSTRUCTOR_OPTIONS=["kind","multi","resolve","construct","instanceOf","predicate","represent","representName","defaultStyle","styleAliases"],YAML_NODE_KINDS=["scalar","sequence","mapping"];let type=function(tag,options){if(options=options||{},Object.keys(options).forEach((function(name){if(-1===TYPE_CONSTRUCTOR_OPTIONS.indexOf(name))throw new exception('Unknown option "'+name+'" is met in definition of "'+tag+'" YAML type.')})),this.options=options,this.tag=tag,this.kind=options.kind||null,this.resolve=options.resolve||function(){return!0},this.construct=options.construct||function(data){return data},this.instanceOf=options.instanceOf||null,this.predicate=options.predicate||null,this.represent=options.represent||null,this.representName=options.representName||null,this.defaultStyle=options.defaultStyle||null,this.multi=options.multi||!1,this.styleAliases=function(map){let result={};return null!==map&&Object.keys(map).forEach((function(style){map[style].forEach((function(alias){result[String(alias)]=style}))})),result}(options.styleAliases||null),-1===YAML_NODE_KINDS.indexOf(this.kind))throw new exception('Unknown kind "'+this.kind+'" is specified for "'+tag+'" YAML type.')};function compileList(schema,name){let result=[];return schema[name].forEach((function(currentType){let newIndex=result.length;result.forEach((function(previousType,previousIndex){previousType.tag===currentType.tag&&previousType.kind===currentType.kind&&previousType.multi===currentType.multi&&(newIndex=previousIndex)})),result[newIndex]=currentType})),result}function Schema$1(definition){return this.extend(definition)}Schema$1.prototype.extend=function(definition){let implicit=[],explicit=[];if(definition instanceof type)explicit.push(definition);else if(Array.isArray(definition))explicit=explicit.concat(definition);else{if(!definition||!Array.isArray(definition.implicit)&&!Array.isArray(definition.explicit))throw new exception("Schema.extend argument should be a Type, [ Type ], or a schema definition ({ implicit: [...], explicit: [...] })");definition.implicit&&(implicit=implicit.concat(definition.implicit)),definition.explicit&&(explicit=explicit.concat(definition.explicit))}implicit.forEach((function(type$1){if(!(type$1 instanceof type))throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");if(type$1.loadKind&&"scalar"!==type$1.loadKind)throw new exception("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");if(type$1.multi)throw new exception("There is a multi type in the implicit list of a schema. Multi tags can only be listed as explicit.")})),explicit.forEach((function(type$1){if(!(type$1 instanceof type))throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.")}));let result=Object.create(Schema$1.prototype);return result.implicit=(this.implicit||[]).concat(implicit),result.explicit=(this.explicit||[]).concat(explicit),result.compiledImplicit=compileList(result,"implicit"),result.compiledExplicit=compileList(result,"explicit"),result.compiledTypeMap=function(){let index,length,result={scalar:{},sequence:{},mapping:{},fallback:{},multi:{scalar:[],sequence:[],mapping:[],fallback:[]}};function collectType(type){type.multi?(result.multi[type.kind].push(type),result.multi.fallback.push(type)):result[type.kind][type.tag]=result.fallback[type.tag]=type}for(index=0,length=arguments.length;index<length;index+=1)arguments[index].forEach(collectType);return result}(result.compiledImplicit,result.compiledExplicit),result};let schema=Schema$1,str=new type("tag:yaml.org,2002:str",{kind:"scalar",construct:function(data){return null!==data?data:""}}),seq=new type("tag:yaml.org,2002:seq",{kind:"sequence",construct:function(data){return null!==data?data:[]}}),map=new type("tag:yaml.org,2002:map",{kind:"mapping",construct:function(data){return null!==data?data:{}}}),failsafe=new schema({explicit:[str,seq,map]});let _null=new type("tag:yaml.org,2002:null",{kind:"scalar",resolve:function(data){if(null===data)return!0;let max=data.length;return 1===max&&"~"===data||4===max&&("null"===data||"Null"===data||"NULL"===data)},construct:function(){return null},predicate:function(object){return null===object},represent:{canonical:function(){return"~"},lowercase:function(){return"null"},uppercase:function(){return"NULL"},camelcase:function(){return"Null"},empty:function(){return""}},defaultStyle:"lowercase"});let bool=new type("tag:yaml.org,2002:bool",{kind:"scalar",resolve:function(data){if(null===data)return!1;let max=data.length;return 4===max&&("true"===data||"True"===data||"TRUE"===data)||5===max&&("false"===data||"False"===data||"FALSE"===data)},construct:function(data){return"true"===data||"True"===data||"TRUE"===data},predicate:function(object){return"[object Boolean]"===Object.prototype.toString.call(object)},represent:{lowercase:function(object){return object?"true":"false"},uppercase:function(object){return object?"TRUE":"FALSE"},camelcase:function(object){return object?"True":"False"}},defaultStyle:"lowercase"});function isOctCode(c){return 48<=c&&c<=55}function isDecCode(c){return 48<=c&&c<=57}let int=new type("tag:yaml.org,2002:int",{kind:"scalar",resolve:function(data){if(null===data)return!1;let ch,max=data.length,index=0,hasDigits=!1;if(!max)return!1;if(ch=data[index],"-"!==ch&&"+"!==ch||(ch=data[++index]),"0"===ch){if(index+1===max)return!0;if(ch=data[++index],"b"===ch){for(index++;index<max;index++)if(ch=data[index],"_"!==ch){if("0"!==ch&&"1"!==ch)return!1;hasDigits=!0}return hasDigits&&"_"!==ch}if("x"===ch){for(index++;index<max;index++)if(ch=data[index],"_"!==ch){if(!(48<=(c=data.charCodeAt(index))&&c<=57||65<=c&&c<=70||97<=c&&c<=102))return!1;hasDigits=!0}return hasDigits&&"_"!==ch}if("o"===ch){for(index++;index<max;index++)if(ch=data[index],"_"!==ch){if(!isOctCode(data.charCodeAt(index)))return!1;hasDigits=!0}return hasDigits&&"_"!==ch}}var c;if("_"===ch)return!1;for(;index<max;index++)if(ch=data[index],"_"!==ch){if(!isDecCode(data.charCodeAt(index)))return!1;hasDigits=!0}return!(!hasDigits||"_"===ch)},construct:function(data){let ch,value=data,sign=1;if(-1!==value.indexOf("_")&&(value=value.replace(/_/g,"")),ch=value[0],"-"!==ch&&"+"!==ch||("-"===ch&&(sign=-1),value=value.slice(1),ch=value[0]),"0"===value)return 0;if("0"===ch){if("b"===value[1])return sign*parseInt(value.slice(2),2);if("x"===value[1])return sign*parseInt(value.slice(2),16);if("o"===value[1])return sign*parseInt(value.slice(2),8)}return sign*parseInt(value,10)},predicate:function(object){return"[object Number]"===Object.prototype.toString.call(object)&&object%1==0&&!common.isNegativeZero(object)},represent:{binary:function(obj){return obj>=0?"0b"+obj.toString(2):"-0b"+obj.toString(2).slice(1)},octal:function(obj){return obj>=0?"0o"+obj.toString(8):"-0o"+obj.toString(8).slice(1)},decimal:function(obj){return obj.toString(10)},hexadecimal:function(obj){return obj>=0?"0x"+obj.toString(16).toUpperCase():"-0x"+obj.toString(16).toUpperCase().slice(1)}},defaultStyle:"decimal",styleAliases:{binary:[2,"bin"],octal:[8,"oct"],decimal:[10,"dec"],hexadecimal:[16,"hex"]}}),YAML_FLOAT_PATTERN=new RegExp("^(?:[-+]?(?:[0-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");let SCIENTIFIC_WITHOUT_DOT=/^[-+]?[0-9]+e/;let float=new type("tag:yaml.org,2002:float",{kind:"scalar",resolve:function(data){return null!==data&&!(!YAML_FLOAT_PATTERN.test(data)||"_"===data[data.length-1])},construct:function(data){let value,sign;return value=data.replace(/_/g,"").toLowerCase(),sign="-"===value[0]?-1:1,"+-".indexOf(value[0])>=0&&(value=value.slice(1)),".inf"===value?1===sign?Number.POSITIVE_INFINITY:Number.NEGATIVE_INFINITY:".nan"===value?NaN:sign*parseFloat(value,10)},predicate:function(object){return"[object Number]"===Object.prototype.toString.call(object)&&(object%1!=0||common.isNegativeZero(object))},represent:function(object,style){let res;if(isNaN(object))switch(style){case"lowercase":return".nan";case"uppercase":return".NAN";case"camelcase":return".NaN"}else if(Number.POSITIVE_INFINITY===object)switch(style){case"lowercase":return".inf";case"uppercase":return".INF";case"camelcase":return".Inf"}else if(Number.NEGATIVE_INFINITY===object)switch(style){case"lowercase":return"-.inf";case"uppercase":return"-.INF";case"camelcase":return"-.Inf"}else if(common.isNegativeZero(object))return"-0.0";return res=object.toString(10),SCIENTIFIC_WITHOUT_DOT.test(res)?res.replace("e",".e"):res},defaultStyle:"lowercase"}),json=failsafe.extend({implicit:[_null,bool,int,float]}),core=json,YAML_DATE_REGEXP=new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])$"),YAML_TIMESTAMP_REGEXP=new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?$");let timestamp=new type("tag:yaml.org,2002:timestamp",{kind:"scalar",resolve:function(data){return null!==data&&(null!==YAML_DATE_REGEXP.exec(data)||null!==YAML_TIMESTAMP_REGEXP.exec(data))},construct:function(data){let match,year,month,day,hour,minute,second,tz_hour,tz_minute,date,fraction=0,delta=null;if(match=YAML_DATE_REGEXP.exec(data),null===match&&(match=YAML_TIMESTAMP_REGEXP.exec(data)),null===match)throw new Error("Date resolve error");if(year=+match[1],month=+match[2]-1,day=+match[3],!match[4])return new Date(Date.UTC(year,month,day));if(hour=+match[4],minute=+match[5],second=+match[6],match[7]){for(fraction=match[7].slice(0,3);fraction.length<3;)fraction+="0";fraction=+fraction}return match[9]&&(tz_hour=+match[10],tz_minute=+(match[11]||0),delta=6e4*(60*tz_hour+tz_minute),"-"===match[9]&&(delta=-delta)),date=new Date(Date.UTC(year,month,day,hour,minute,second,fraction)),delta&&date.setTime(date.getTime()-delta),date},instanceOf:Date,represent:function(object){return object.toISOString()}});let merge=new type("tag:yaml.org,2002:merge",{kind:"scalar",resolve:function(data){return"<<"===data||null===data}}),BASE64_MAP="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";let binary=new type("tag:yaml.org,2002:binary",{kind:"scalar",resolve:function(data){if(null===data)return!1;let code,idx,bitlen=0,max=data.length,map=BASE64_MAP;for(idx=0;idx<max;idx++)if(code=map.indexOf(data.charAt(idx)),!(code>64)){if(code<0)return!1;bitlen+=6}return bitlen%8==0},construct:function(data){let idx,tailbits,input=data.replace(/[\r\n=]/g,""),max=input.length,map=BASE64_MAP,bits=0,result=[];for(idx=0;idx<max;idx++)idx%4==0&&idx&&(result.push(bits>>16&255),result.push(bits>>8&255),result.push(255&bits)),bits=bits<<6|map.indexOf(input.charAt(idx));return tailbits=max%4*6,0===tailbits?(result.push(bits>>16&255),result.push(bits>>8&255),result.push(255&bits)):18===tailbits?(result.push(bits>>10&255),result.push(bits>>2&255)):12===tailbits&&result.push(bits>>4&255),new Uint8Array(result)},predicate:function(obj){return"[object Uint8Array]"===Object.prototype.toString.call(obj)},represent:function(object){let idx,tail,result="",bits=0,max=object.length,map=BASE64_MAP;for(idx=0;idx<max;idx++)idx%3==0&&idx&&(result+=map[bits>>18&63],result+=map[bits>>12&63],result+=map[bits>>6&63],result+=map[63&bits]),bits=(bits<<8)+object[idx];return tail=max%3,0===tail?(result+=map[bits>>18&63],result+=map[bits>>12&63],result+=map[bits>>6&63],result+=map[63&bits]):2===tail?(result+=map[bits>>10&63],result+=map[bits>>4&63],result+=map[bits<<2&63],result+=map[64]):1===tail&&(result+=map[bits>>2&63],result+=map[bits<<4&63],result+=map[64],result+=map[64]),result}}),_hasOwnProperty$3=Object.prototype.hasOwnProperty,_toString$2=Object.prototype.toString;let omap=new type("tag:yaml.org,2002:omap",{kind:"sequence",resolve:function(data){if(null===data)return!0;let index,length,pair,pairKey,pairHasKey,objectKeys=[],object=data;for(index=0,length=object.length;index<length;index+=1){if(pair=object[index],pairHasKey=!1,"[object Object]"!==_toString$2.call(pair))return!1;for(pairKey in pair)if(_hasOwnProperty$3.call(pair,pairKey)){if(pairHasKey)return!1;pairHasKey=!0}if(!pairHasKey)return!1;if(-1!==objectKeys.indexOf(pairKey))return!1;objectKeys.push(pairKey)}return!0},construct:function(data){return null!==data?data:[]}}),_toString$1=Object.prototype.toString;let pairs=new type("tag:yaml.org,2002:pairs",{kind:"sequence",resolve:function(data){if(null===data)return!0;let index,length,pair,keys,result,object=data;for(result=new Array(object.length),index=0,length=object.length;index<length;index+=1){if(pair=object[index],"[object Object]"!==_toString$1.call(pair))return!1;if(keys=Object.keys(pair),1!==keys.length)return!1;result[index]=[keys[0],pair[keys[0]]]}return!0},construct:function(data){if(null===data)return[];let index,length,pair,keys,result,object=data;for(result=new Array(object.length),index=0,length=object.length;index<length;index+=1)pair=object[index],keys=Object.keys(pair),result[index]=[keys[0],pair[keys[0]]];return result}}),_hasOwnProperty$2=Object.prototype.hasOwnProperty;let set=new type("tag:yaml.org,2002:set",{kind:"mapping",resolve:function(data){if(null===data)return!0;let key,object=data;for(key in object)if(_hasOwnProperty$2.call(object,key)&&null!==object[key])return!1;return!0},construct:function(data){return null!==data?data:{}}}),_default=core.extend({implicit:[timestamp,merge],explicit:[binary,omap,pairs,set]}),_hasOwnProperty$1=Object.prototype.hasOwnProperty,PATTERN_NON_PRINTABLE=/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/,PATTERN_NON_ASCII_LINE_BREAKS=/[\x85\u2028\u2029]/,PATTERN_FLOW_INDICATORS=/[,\[\]\{\}]/,PATTERN_TAG_HANDLE=/^(?:!|!!|![a-z\-]+!)$/i,PATTERN_TAG_URI=/^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;function _class(obj){return Object.prototype.toString.call(obj)}function is_EOL(c){return 10===c||13===c}function is_WHITE_SPACE(c){return 9===c||32===c}function is_WS_OR_EOL(c){return 9===c||32===c||10===c||13===c}function is_FLOW_INDICATOR(c){return 44===c||91===c||93===c||123===c||125===c}function fromHexCode(c){let lc;return 48<=c&&c<=57?c-48:(lc=32|c,97<=lc&&lc<=102?lc-97+10:-1)}function simpleEscapeSequence(c){return 48===c?"\0":97===c?"":98===c?"\b":116===c||9===c?"\t":110===c?"\n":118===c?"\v":102===c?"\f":114===c?"\r":101===c?"":32===c?" ":34===c?'"':47===c?"/":92===c?"\\":78===c?"":95===c?" ":76===c?"\u2028":80===c?"\u2029":""}function charFromCodepoint(c){return c<=65535?String.fromCharCode(c):String.fromCharCode(55296+(c-65536>>10),56320+(c-65536&1023))}let simpleEscapeCheck=new Array(256),simpleEscapeMap=new Array(256);for(let i=0;i<256;i++)simpleEscapeCheck[i]=simpleEscapeSequence(i)?1:0,simpleEscapeMap[i]=simpleEscapeSequence(i);function State$1(input,options){this.input=input,this.filename=options.filename||null,this.schema=options.schema||_default,this.onWarning=options.onWarning||null,this.legacy=options.legacy||!1,this.json=options.json||!1,this.listener=options.listener||null,this.implicitTypes=this.schema.compiledImplicit,this.typeMap=this.schema.compiledTypeMap,this.length=input.length,this.position=0,this.line=0,this.lineStart=0,this.lineIndent=0,this.firstTabInLine=-1,this.documents=[]}function generateError(state,message){let mark={name:state.filename,buffer:state.input.slice(0,-1),position:state.position,line:state.line,column:state.position-state.lineStart};return mark.widget=widget(mark),new exception(message,mark)}function throwError(state,message){throw generateError(state,message)}function throwWarning(state,message){state.onWarning&&state.onWarning.call(null,generateError(state,message))}let directiveHandlers={YAML:function(state,name,args){let match,major,minor;null!==state.version&&throwError(state,"duplication of %YAML directive"),1!==args.length&&throwError(state,"YAML directive accepts exactly one argument"),match=/^([0-9]+)\.([0-9]+)$/.exec(args[0]),null===match&&throwError(state,"ill-formed argument of the YAML directive"),major=parseInt(match[1],10),minor=parseInt(match[2],10),1!==major&&throwError(state,"unacceptable YAML version of the document"),state.version=args[0],state.checkLineBreaks=minor<2,1!==minor&&2!==minor&&throwWarning(state,"unsupported YAML version of the document")},TAG:function(state,name,args){let handle,prefix;2!==args.length&&throwError(state,"TAG directive accepts exactly two arguments"),handle=args[0],prefix=args[1],PATTERN_TAG_HANDLE.test(handle)||throwError(state,"ill-formed tag handle (first argument) of the TAG directive"),_hasOwnProperty$1.call(state.tagMap,handle)&&throwError(state,'there is a previously declared suffix for "'+handle+'" tag handle'),PATTERN_TAG_URI.test(prefix)||throwError(state,"ill-formed tag prefix (second argument) of the TAG directive");try{prefix=decodeURIComponent(prefix)}catch(err){throwError(state,"tag prefix is malformed: "+prefix)}state.tagMap[handle]=prefix}};function captureSegment(state,start,end,checkJson){let _position,_length,_character,_result;if(start<end){if(_result=state.input.slice(start,end),checkJson)for(_position=0,_length=_result.length;_position<_length;_position+=1)_character=_result.charCodeAt(_position),9===_character||32<=_character&&_character<=1114111||throwError(state,"expected valid JSON character");else PATTERN_NON_PRINTABLE.test(_result)&&throwError(state,"the stream contains non-printable characters");state.result+=_result}}function mergeMappings(state,destination,source,overridableKeys){let sourceKeys,key,index,quantity;for(common.isObject(source)||throwError(state,"cannot merge mappings; the provided source object is unacceptable"),sourceKeys=Object.keys(source),index=0,quantity=sourceKeys.length;index<quantity;index+=1)key=sourceKeys[index],_hasOwnProperty$1.call(destination,key)||(destination[key]=source[key],overridableKeys[key]=!0)}function storeMappingPair(state,_result,overridableKeys,keyTag,keyNode,valueNode,startLine,startLineStart,startPos){let index,quantity;if(Array.isArray(keyNode))for(index=0,quantity=(keyNode=Array.prototype.slice.call(keyNode)).length;index<quantity;index+=1)Array.isArray(keyNode[index])&&throwError(state,"nested arrays are not supported inside keys"),"object"==typeof keyNode&&"[object Object]"===_class(keyNode[index])&&(keyNode[index]="[object Object]");if("object"==typeof keyNode&&"[object Object]"===_class(keyNode)&&(keyNode="[object Object]"),keyNode=String(keyNode),null===_result&&(_result={}),"tag:yaml.org,2002:merge"===keyTag)if(Array.isArray(valueNode))for(index=0,quantity=valueNode.length;index<quantity;index+=1)mergeMappings(state,_result,valueNode[index],overridableKeys);else mergeMappings(state,_result,valueNode,overridableKeys);else state.json||_hasOwnProperty$1.call(overridableKeys,keyNode)||!_hasOwnProperty$1.call(_result,keyNode)||(state.line=startLine||state.line,state.lineStart=startLineStart||state.lineStart,state.position=startPos||state.position,throwError(state,"duplicated mapping key")),"__proto__"===keyNode?Object.defineProperty(_result,keyNode,{configurable:!0,enumerable:!0,writable:!0,value:valueNode}):_result[keyNode]=valueNode,delete overridableKeys[keyNode];return _result}function readLineBreak(state){let ch;ch=state.input.charCodeAt(state.position),10===ch?state.position++:13===ch?(state.position++,10===state.input.charCodeAt(state.position)&&state.position++):throwError(state,"a line break is expected"),state.line+=1,state.lineStart=state.position,state.firstTabInLine=-1}function skipSeparationSpace(state,allowComments,checkIndent){let lineBreaks=0,ch=state.input.charCodeAt(state.position);for(;0!==ch;){for(;is_WHITE_SPACE(ch);)9===ch&&-1===state.firstTabInLine&&(state.firstTabInLine=state.position),ch=state.input.charCodeAt(++state.position);if(allowComments&&35===ch)do{ch=state.input.charCodeAt(++state.position)}while(10!==ch&&13!==ch&&0!==ch);if(!is_EOL(ch))break;for(readLineBreak(state),ch=state.input.charCodeAt(state.position),lineBreaks++,state.lineIndent=0;32===ch;)state.lineIndent++,ch=state.input.charCodeAt(++state.position)}return-1!==checkIndent&&0!==lineBreaks&&state.lineIndent<checkIndent&&throwWarning(state,"deficient indentation"),lineBreaks}function testDocumentSeparator(state){let ch,_position=state.position;return ch=state.input.charCodeAt(_position),!(45!==ch&&46!==ch||ch!==state.input.charCodeAt(_position+1)||ch!==state.input.charCodeAt(_position+2)||(_position+=3,ch=state.input.charCodeAt(_position),0!==ch&&!is_WS_OR_EOL(ch)))}function writeFoldedLines(state,count){1===count?state.result+=" ":count>1&&(state.result+=common.repeat("\n",count-1))}function readBlockSequence(state,nodeIndent){let _line,following,ch,_tag=state.tag,_anchor=state.anchor,_result=[],detected=!1;if(-1!==state.firstTabInLine)return!1;for(null!==state.anchor&&(state.anchorMap[state.anchor]=_result),ch=state.input.charCodeAt(state.position);0!==ch&&(-1!==state.firstTabInLine&&(state.position=state.firstTabInLine,throwError(state,"tab characters must not be used in indentation")),45===ch)&&(following=state.input.charCodeAt(state.position+1),is_WS_OR_EOL(following));)if(detected=!0,state.position++,skipSeparationSpace(state,!0,-1)&&state.lineIndent<=nodeIndent)_result.push(null),ch=state.input.charCodeAt(state.position);else if(_line=state.line,composeNode(state,nodeIndent,3,!1,!0),_result.push(state.result),skipSeparationSpace(state,!0,-1),ch=state.input.charCodeAt(state.position),(state.line===_line||state.lineIndent>nodeIndent)&&0!==ch)throwError(state,"bad indentation of a sequence entry");else if(state.lineIndent<nodeIndent)break;return!!detected&&(state.tag=_tag,state.anchor=_anchor,state.kind="sequence",state.result=_result,!0)}function readTagProperty(state){let _position,tagHandle,tagName,ch,isVerbatim=!1,isNamed=!1;if(ch=state.input.charCodeAt(state.position),33!==ch)return!1;if(null!==state.tag&&throwError(state,"duplication of a tag property"),ch=state.input.charCodeAt(++state.position),60===ch?(isVerbatim=!0,ch=state.input.charCodeAt(++state.position)):33===ch?(isNamed=!0,tagHandle="!!",ch=state.input.charCodeAt(++state.position)):tagHandle="!",_position=state.position,isVerbatim){do{ch=state.input.charCodeAt(++state.position)}while(0!==ch&&62!==ch);state.position<state.length?(tagName=state.input.slice(_position,state.position),ch=state.input.charCodeAt(++state.position)):throwError(state,"unexpected end of the stream within a verbatim tag")}else{for(;0!==ch&&!is_WS_OR_EOL(ch);)33===ch&&(isNamed?throwError(state,"tag suffix cannot contain exclamation marks"):(tagHandle=state.input.slice(_position-1,state.position+1),PATTERN_TAG_HANDLE.test(tagHandle)||throwError(state,"named tag handle cannot contain such characters"),isNamed=!0,_position=state.position+1)),ch=state.input.charCodeAt(++state.position);tagName=state.input.slice(_position,state.position),PATTERN_FLOW_INDICATORS.test(tagName)&&throwError(state,"tag suffix cannot contain flow indicator characters")}tagName&&!PATTERN_TAG_URI.test(tagName)&&throwError(state,"tag name cannot contain such characters: "+tagName);try{tagName=decodeURIComponent(tagName)}catch(err){throwError(state,"tag name is malformed: "+tagName)}return isVerbatim?state.tag=tagName:_hasOwnProperty$1.call(state.tagMap,tagHandle)?state.tag=state.tagMap[tagHandle]+tagName:"!"===tagHandle?state.tag="!"+tagName:"!!"===tagHandle?state.tag="tag:yaml.org,2002:"+tagName:throwError(state,'undeclared tag handle "'+tagHandle+'"'),!0}function readAnchorProperty(state){let _position,ch;if(ch=state.input.charCodeAt(state.position),38!==ch)return!1;for(null!==state.anchor&&throwError(state,"duplication of an anchor property"),ch=state.input.charCodeAt(++state.position),_position=state.position;0!==ch&&!is_WS_OR_EOL(ch)&&!is_FLOW_INDICATOR(ch);)ch=state.input.charCodeAt(++state.position);return state.position===_position&&throwError(state,"name of an anchor node must contain at least one character"),state.anchor=state.input.slice(_position,state.position),!0}function composeNode(state,parentIndent,nodeContext,allowToSeek,allowCompact){let allowBlockStyles,allowBlockScalars,allowBlockCollections,typeIndex,typeQuantity,typeList,type,flowIndent,blockIndent,indentStatus=1,atNewLine=!1,hasContent=!1;if(null!==state.listener&&state.listener("open",state),state.tag=null,state.anchor=null,state.kind=null,state.result=null,allowBlockStyles=allowBlockScalars=allowBlockCollections=4===nodeContext||3===nodeContext,allowToSeek&&skipSeparationSpace(state,!0,-1)&&(atNewLine=!0,state.lineIndent>parentIndent?indentStatus=1:state.lineIndent===parentIndent?indentStatus=0:state.lineIndent<parentIndent&&(indentStatus=-1)),1===indentStatus)for(;readTagProperty(state)||readAnchorProperty(state);)skipSeparationSpace(state,!0,-1)?(atNewLine=!0,allowBlockCollections=allowBlockStyles,state.lineIndent>parentIndent?indentStatus=1:state.lineIndent===parentIndent?indentStatus=0:state.lineIndent<parentIndent&&(indentStatus=-1)):allowBlockCollections=!1;if(allowBlockCollections&&(allowBlockCollections=atNewLine||allowCompact),1!==indentStatus&&4!==nodeContext||(flowIndent=1===nodeContext||2===nodeContext?parentIndent:parentIndent+1,blockIndent=state.position-state.lineStart,1===indentStatus?allowBlockCollections&&(readBlockSequence(state,blockIndent)||function(state,nodeIndent,flowIndent){let following,allowCompact,_line,_keyLine,_keyLineStart,_keyPos,ch,_tag=state.tag,_anchor=state.anchor,_result={},overridableKeys=Object.create(null),keyTag=null,keyNode=null,valueNode=null,atExplicitKey=!1,detected=!1;if(-1!==state.firstTabInLine)return!1;for(null!==state.anchor&&(state.anchorMap[state.anchor]=_result),ch=state.input.charCodeAt(state.position);0!==ch;){if(atExplicitKey||-1===state.firstTabInLine||(state.position=state.firstTabInLine,throwError(state,"tab characters must not be used in indentation")),following=state.input.charCodeAt(state.position+1),_line=state.line,63!==ch&&58!==ch||!is_WS_OR_EOL(following)){if(_keyLine=state.line,_keyLineStart=state.lineStart,_keyPos=state.position,!composeNode(state,flowIndent,2,!1,!0))break;if(state.line===_line){for(ch=state.input.charCodeAt(state.position);is_WHITE_SPACE(ch);)ch=state.input.charCodeAt(++state.position);if(58===ch)ch=state.input.charCodeAt(++state.position),is_WS_OR_EOL(ch)||throwError(state,"a whitespace character is expected after the key-value separator within a block mapping"),atExplicitKey&&(storeMappingPair(state,_result,overridableKeys,keyTag,keyNode,null,_keyLine,_keyLineStart,_keyPos),keyTag=keyNode=valueNode=null),detected=!0,atExplicitKey=!1,allowCompact=!1,keyTag=state.tag,keyNode=state.result;else{if(!detected)return state.tag=_tag,state.anchor=_anchor,!0;throwError(state,"can not read an implicit mapping pair; a colon is missed")}}else{if(!detected)return state.tag=_tag,state.anchor=_anchor,!0;throwError(state,"can not read a block mapping entry; a multiline key may not be an implicit key")}}else 63===ch?(atExplicitKey&&(storeMappingPair(state,_result,overridableKeys,keyTag,keyNode,null,_keyLine,_keyLineStart,_keyPos),keyTag=keyNode=valueNode=null),detected=!0,atExplicitKey=!0,allowCompact=!0):atExplicitKey?(atExplicitKey=!1,allowCompact=!0):throwError(state,"incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line"),state.position+=1,ch=following;if((state.line===_line||state.lineIndent>nodeIndent)&&(atExplicitKey&&(_keyLine=state.line,_keyLineStart=state.lineStart,_keyPos=state.position),composeNode(state,nodeIndent,4,!0,allowCompact)&&(atExplicitKey?keyNode=state.result:valueNode=state.result),atExplicitKey||(storeMappingPair(state,_result,overridableKeys,keyTag,keyNode,valueNode,_keyLine,_keyLineStart,_keyPos),keyTag=keyNode=valueNode=null),skipSeparationSpace(state,!0,-1),ch=state.input.charCodeAt(state.position)),(state.line===_line||state.lineIndent>nodeIndent)&&0!==ch)throwError(state,"bad indentation of a mapping entry");else if(state.lineIndent<nodeIndent)break}return atExplicitKey&&storeMappingPair(state,_result,overridableKeys,keyTag,keyNode,null,_keyLine,_keyLineStart,_keyPos),detected&&(state.tag=_tag,state.anchor=_anchor,state.kind="mapping",state.result=_result),detected}(state,blockIndent,flowIndent))||function(state,nodeIndent){let _line,_lineStart,_pos,_result,following,terminator,isPair,isExplicitPair,isMapping,keyNode,keyTag,valueNode,ch,readNext=!0,_tag=state.tag,_anchor=state.anchor,overridableKeys=Object.create(null);if(ch=state.input.charCodeAt(state.position),91===ch)terminator=93,isMapping=!1,_result=[];else{if(123!==ch)return!1;terminator=125,isMapping=!0,_result={}}for(null!==state.anchor&&(state.anchorMap[state.anchor]=_result),ch=state.input.charCodeAt(++state.position);0!==ch;){if(skipSeparationSpace(state,!0,nodeIndent),ch=state.input.charCodeAt(state.position),ch===terminator)return state.position++,state.tag=_tag,state.anchor=_anchor,state.kind=isMapping?"mapping":"sequence",state.result=_result,!0;readNext?44===ch&&throwError(state,"expected the node content, but found ','"):throwError(state,"missed comma between flow collection entries"),keyTag=keyNode=valueNode=null,isPair=isExplicitPair=!1,63===ch&&(following=state.input.charCodeAt(state.position+1),is_WS_OR_EOL(following)&&(isPair=isExplicitPair=!0,state.position++,skipSeparationSpace(state,!0,nodeIndent))),_line=state.line,_lineStart=state.lineStart,_pos=state.position,composeNode(state,nodeIndent,1,!1,!0),keyTag=state.tag,keyNode=state.result,skipSeparationSpace(state,!0,nodeIndent),ch=state.input.charCodeAt(state.position),!isExplicitPair&&state.line!==_line||58!==ch||(isPair=!0,ch=state.input.charCodeAt(++state.position),skipSeparationSpace(state,!0,nodeIndent),composeNode(state,nodeIndent,1,!1,!0),valueNode=state.result),isMapping?storeMappingPair(state,_result,overridableKeys,keyTag,keyNode,valueNode,_line,_lineStart,_pos):isPair?_result.push(storeMappingPair(state,null,overridableKeys,keyTag,keyNode,valueNode,_line,_lineStart,_pos)):_result.push(keyNode),skipSeparationSpace(state,!0,nodeIndent),ch=state.input.charCodeAt(state.position),44===ch?(readNext=!0,ch=state.input.charCodeAt(++state.position)):readNext=!1}throwError(state,"unexpected end of the stream within a flow collection")}(state,flowIndent)?hasContent=!0:(allowBlockScalars&&function(state,nodeIndent){let captureStart,folding,tmp,ch,chomping=1,didReadContent=!1,detectedIndent=!1,textIndent=nodeIndent,emptyLines=0,atMoreIndented=!1;if(ch=state.input.charCodeAt(state.position),124===ch)folding=!1;else{if(62!==ch)return!1;folding=!0}for(state.kind="scalar",state.result="";0!==ch;)if(ch=state.input.charCodeAt(++state.position),43===ch||45===ch)1===chomping?chomping=43===ch?3:2:throwError(state,"repeat of a chomping mode identifier");else{if(!((tmp=48<=(c=ch)&&c<=57?c-48:-1)>=0))break;0===tmp?throwError(state,"bad explicit indentation width of a block scalar; it cannot be less than one"):detectedIndent?throwError(state,"repeat of an indentation width identifier"):(textIndent=nodeIndent+tmp-1,detectedIndent=!0)}var c;if(is_WHITE_SPACE(ch)){do{ch=state.input.charCodeAt(++state.position)}while(is_WHITE_SPACE(ch));if(35===ch)do{ch=state.input.charCodeAt(++state.position)}while(!is_EOL(ch)&&0!==ch)}for(;0!==ch;){for(readLineBreak(state),state.lineIndent=0,ch=state.input.charCodeAt(state.position);(!detectedIndent||state.lineIndent<textIndent)&&32===ch;)state.lineIndent++,ch=state.input.charCodeAt(++state.position);if(!detectedIndent&&state.lineIndent>textIndent&&(textIndent=state.lineIndent),is_EOL(ch))emptyLines++;else{if(state.lineIndent<textIndent){3===chomping?state.result+=common.repeat("\n",didReadContent?1+emptyLines:emptyLines):1===chomping&&didReadContent&&(state.result+="\n");break}for(folding?is_WHITE_SPACE(ch)?(atMoreIndented=!0,state.result+=common.repeat("\n",didReadContent?1+emptyLines:emptyLines)):atMoreIndented?(atMoreIndented=!1,state.result+=common.repeat("\n",emptyLines+1)):0===emptyLines?didReadContent&&(state.result+=" "):state.result+=common.repeat("\n",emptyLines):state.result+=common.repeat("\n",didReadContent?1+emptyLines:emptyLines),didReadContent=!0,detectedIndent=!0,emptyLines=0,captureStart=state.position;!is_EOL(ch)&&0!==ch;)ch=state.input.charCodeAt(++state.position);captureSegment(state,captureStart,state.position,!1)}}return!0}(state,flowIndent)||function(state,nodeIndent){let ch,captureStart,captureEnd;if(ch=state.input.charCodeAt(state.position),39!==ch)return!1;for(state.kind="scalar",state.result="",state.position++,captureStart=captureEnd=state.position;0!==(ch=state.input.charCodeAt(state.position));)if(39===ch){if(captureSegment(state,captureStart,state.position,!0),ch=state.input.charCodeAt(++state.position),39!==ch)return!0;captureStart=state.position,state.position++,captureEnd=state.position}else is_EOL(ch)?(captureSegment(state,captureStart,captureEnd,!0),writeFoldedLines(state,skipSeparationSpace(state,!1,nodeIndent)),captureStart=captureEnd=state.position):state.position===state.lineStart&&testDocumentSeparator(state)?throwError(state,"unexpected end of the document within a single quoted scalar"):(state.position++,captureEnd=state.position);throwError(state,"unexpected end of the stream within a single quoted scalar")}(state,flowIndent)||function(state,nodeIndent){let captureStart,captureEnd,hexLength,hexResult,tmp,ch;if(ch=state.input.charCodeAt(state.position),34!==ch)return!1;for(state.kind="scalar",state.result="",state.position++,captureStart=captureEnd=state.position;0!==(ch=state.input.charCodeAt(state.position));){if(34===ch)return captureSegment(state,captureStart,state.position,!0),state.position++,!0;if(92===ch){if(captureSegment(state,captureStart,state.position,!0),ch=state.input.charCodeAt(++state.position),is_EOL(ch))skipSeparationSpace(state,!1,nodeIndent);else if(ch<256&&simpleEscapeCheck[ch])state.result+=simpleEscapeMap[ch],state.position++;else if((tmp=120===(c=ch)?2:117===c?4:85===c?8:0)>0){for(hexLength=tmp,hexResult=0;hexLength>0;hexLength--)ch=state.input.charCodeAt(++state.position),(tmp=fromHexCode(ch))>=0?hexResult=(hexResult<<4)+tmp:throwError(state,"expected hexadecimal character");state.result+=charFromCodepoint(hexResult),state.position++}else throwError(state,"unknown escape sequence");captureStart=captureEnd=state.position}else is_EOL(ch)?(captureSegment(state,captureStart,captureEnd,!0),writeFoldedLines(state,skipSeparationSpace(state,!1,nodeIndent)),captureStart=captureEnd=state.position):state.position===state.lineStart&&testDocumentSeparator(state)?throwError(state,"unexpected end of the document within a double quoted scalar"):(state.position++,captureEnd=state.position)}var c;throwError(state,"unexpected end of the stream within a double quoted scalar")}(state,flowIndent)?hasContent=!0:!function(state){let _position,alias,ch;if(ch=state.input.charCodeAt(state.position),42!==ch)return!1;for(ch=state.input.charCodeAt(++state.position),_position=state.position;0!==ch&&!is_WS_OR_EOL(ch)&&!is_FLOW_INDICATOR(ch);)ch=state.input.charCodeAt(++state.position);return state.position===_position&&throwError(state,"name of an alias node must contain at least one character"),alias=state.input.slice(_position,state.position),_hasOwnProperty$1.call(state.anchorMap,alias)||throwError(state,'unidentified alias "'+alias+'"'),state.result=state.anchorMap[alias],skipSeparationSpace(state,!0,-1),!0}(state)?function(state,nodeIndent,withinFlowCollection){let preceding,following,captureStart,captureEnd,hasPendingContent,_line,_lineStart,_lineIndent,ch,_kind=state.kind,_result=state.result;if(ch=state.input.charCodeAt(state.position),is_WS_OR_EOL(ch)||is_FLOW_INDICATOR(ch)||35===ch||38===ch||42===ch||33===ch||124===ch||62===ch||39===ch||34===ch||37===ch||64===ch||96===ch)return!1;if((63===ch||45===ch)&&(following=state.input.charCodeAt(state.position+1),is_WS_OR_EOL(following)||withinFlowCollection&&is_FLOW_INDICATOR(following)))return!1;for(state.kind="scalar",state.result="",captureStart=captureEnd=state.position,hasPendingContent=!1;0!==ch;){if(58===ch){if(following=state.input.charCodeAt(state.position+1),is_WS_OR_EOL(following)||withinFlowCollection&&is_FLOW_INDICATOR(following))break}else if(35===ch){if(preceding=state.input.charCodeAt(state.position-1),is_WS_OR_EOL(preceding))break}else{if(state.position===state.lineStart&&testDocumentSeparator(state)||withinFlowCollection&&is_FLOW_INDICATOR(ch))break;if(is_EOL(ch)){if(_line=state.line,_lineStart=state.lineStart,_lineIndent=state.lineIndent,skipSeparationSpace(state,!1,-1),state.lineIndent>=nodeIndent){hasPendingContent=!0,ch=state.input.charCodeAt(state.position);continue}state.position=captureEnd,state.line=_line,state.lineStart=_lineStart,state.lineIndent=_lineIndent;break}}hasPendingContent&&(captureSegment(state,captureStart,captureEnd,!1),writeFoldedLines(state,state.line-_line),captureStart=captureEnd=state.position,hasPendingContent=!1),is_WHITE_SPACE(ch)||(captureEnd=state.position+1),ch=state.input.charCodeAt(++state.position)}return captureSegment(state,captureStart,captureEnd,!1),!!state.result||(state.kind=_kind,state.result=_result,!1)}(state,flowIndent,1===nodeContext)&&(hasContent=!0,null===state.tag&&(state.tag="?")):(hasContent=!0,null===state.tag&&null===state.anchor||throwError(state,"alias node should not have any properties")),null!==state.anchor&&(state.anchorMap[state.anchor]=state.result)):0===indentStatus&&(hasContent=allowBlockCollections&&readBlockSequence(state,blockIndent))),null===state.tag)null!==state.anchor&&(state.anchorMap[state.anchor]=state.result);else if("?"===state.tag){for(null!==state.result&&"scalar"!==state.kind&&throwError(state,'unacceptable node kind for !<?> tag; it should be "scalar", not "'+state.kind+'"'),typeIndex=0,typeQuantity=state.implicitTypes.length;typeIndex<typeQuantity;typeIndex+=1)if(type=state.implicitTypes[typeIndex],type.resolve(state.result)){state.result=type.construct(state.result),state.tag=type.tag,null!==state.anchor&&(state.anchorMap[state.anchor]=state.result);break}}else if("!"!==state.tag){if(_hasOwnProperty$1.call(state.typeMap[state.kind||"fallback"],state.tag))type=state.typeMap[state.kind||"fallback"][state.tag];else for(type=null,typeList=state.typeMap.multi[state.kind||"fallback"],typeIndex=0,typeQuantity=typeList.length;typeIndex<typeQuantity;typeIndex+=1)if(state.tag.slice(0,typeList[typeIndex].tag.length)===typeList[typeIndex].tag){type=typeList[typeIndex];break}type||throwError(state,"unknown tag !<"+state.tag+">"),null!==state.result&&type.kind!==state.kind&&throwError(state,"unacceptable node kind for !<"+state.tag+'> tag; it should be "'+type.kind+'", not "'+state.kind+'"'),type.resolve(state.result,state.tag)?(state.result=type.construct(state.result,state.tag),null!==state.anchor&&(state.anchorMap[state.anchor]=state.result)):throwError(state,"cannot resolve a node with !<"+state.tag+"> explicit tag")}return null!==state.listener&&state.listener("close",state),null!==state.tag||null!==state.anchor||hasContent}function readDocument(state){let _position,directiveName,directiveArgs,ch,documentStart=state.position,hasDirectives=!1;for(state.version=null,state.checkLineBreaks=state.legacy,state.tagMap=Object.create(null),state.anchorMap=Object.create(null);0!==(ch=state.input.charCodeAt(state.position))&&(skipSeparationSpace(state,!0,-1),ch=state.input.charCodeAt(state.position),!(state.lineIndent>0||37!==ch));){for(hasDirectives=!0,ch=state.input.charCodeAt(++state.position),_position=state.position;0!==ch&&!is_WS_OR_EOL(ch);)ch=state.input.charCodeAt(++state.position);for(directiveName=state.input.slice(_position,state.position),directiveArgs=[],directiveName.length<1&&throwError(state,"directive name must not be less than one character in length");0!==ch;){for(;is_WHITE_SPACE(ch);)ch=state.input.charCodeAt(++state.position);if(35===ch){do{ch=state.input.charCodeAt(++state.position)}while(0!==ch&&!is_EOL(ch));break}if(is_EOL(ch))break;for(_position=state.position;0!==ch&&!is_WS_OR_EOL(ch);)ch=state.input.charCodeAt(++state.position);directiveArgs.push(state.input.slice(_position,state.position))}0!==ch&&readLineBreak(state),_hasOwnProperty$1.call(directiveHandlers,directiveName)?directiveHandlers[directiveName](state,directiveName,directiveArgs):throwWarning(state,'unknown document directive "'+directiveName+'"')}skipSeparationSpace(state,!0,-1),0===state.lineIndent&&45===state.input.charCodeAt(state.position)&&45===state.input.charCodeAt(state.position+1)&&45===state.input.charCodeAt(state.position+2)?(state.position+=3,skipSeparationSpace(state,!0,-1)):hasDirectives&&throwError(state,"directives end mark is expected"),composeNode(state,state.lineIndent-1,4,!1,!0),skipSeparationSpace(state,!0,-1),state.checkLineBreaks&&PATTERN_NON_ASCII_LINE_BREAKS.test(state.input.slice(documentStart,state.position))&&throwWarning(state,"non-ASCII line breaks are interpreted as content"),state.documents.push(state.result),state.position===state.lineStart&&testDocumentSeparator(state)?46===state.input.charCodeAt(state.position)&&(state.position+=3,skipSeparationSpace(state,!0,-1)):state.position<state.length-1&&throwError(state,"end of the stream or a document separator is expected")}function loadDocuments(input,options){options=options||{},0!==(input=String(input)).length&&(10!==input.charCodeAt(input.length-1)&&13!==input.charCodeAt(input.length-1)&&(input+="\n"),65279===input.charCodeAt(0)&&(input=input.slice(1)));let state=new State$1(input,options),nullpos=input.indexOf("\0");for(-1!==nullpos&&(state.position=nullpos,throwError(state,"null byte is not allowed in input")),state.input+="\0";32===state.input.charCodeAt(state.position);)state.lineIndent+=1,state.position+=1;for(;state.position<state.length-1;)readDocument(state);return state.documents}let loader={loadAll:function(input,iterator,options){null!==iterator&&"object"==typeof iterator&&void 0===options&&(options=iterator,iterator=null);let documents=loadDocuments(input,options);if("function"!=typeof iterator)return documents;for(let index=0,length=documents.length;index<length;index+=1)iterator(documents[index])},load:function(input,options){let documents=loadDocuments(input,options);if(0!==documents.length){if(1===documents.length)return documents[0];throw new exception("expected a single document in the stream, but found more")}}},_toString=Object.prototype.toString,_hasOwnProperty=Object.prototype.hasOwnProperty,ESCAPE_SEQUENCES={0:"\\0",7:"\\a",8:"\\b",9:"\\t",10:"\\n",11:"\\v",12:"\\f",13:"\\r",27:"\\e",34:'\\"',92:"\\\\",133:"\\N",160:"\\_",8232:"\\L",8233:"\\P"},DEPRECATED_BOOLEANS_SYNTAX=["y","Y","yes","Yes","YES","on","On","ON","n","N","no","No","NO","off","Off","OFF"],DEPRECATED_BASE60_SYNTAX=/^[-+]?[0-9_]+(?::[0-9_]+)+(?:\.[0-9_]*)?$/;function encodeHex(character){let string,handle,length;if(string=character.toString(16).toUpperCase(),character<=255)handle="x",length=2;else if(character<=65535)handle="u",length=4;else{if(!(character<=4294967295))throw new exception("code point within a string may not be greater than 0xFFFFFFFF");handle="U",length=8}return"\\"+handle+common.repeat("0",length-string.length)+string}function State(options){this.schema=options.schema||_default,this.indent=Math.max(1,options.indent||2),this.noArrayIndent=options.noArrayIndent||!1,this.skipInvalid=options.skipInvalid||!1,this.flowLevel=common.isNothing(options.flowLevel)?-1:options.flowLevel,this.styleMap=function(schema,map){let result,keys,index,length,tag,style,type;if(null===map)return{};for(result={},keys=Object.keys(map),index=0,length=keys.length;index<length;index+=1)tag=keys[index],style=String(map[tag]),"!!"===tag.slice(0,2)&&(tag="tag:yaml.org,2002:"+tag.slice(2)),type=schema.compiledTypeMap.fallback[tag],type&&_hasOwnProperty.call(type.styleAliases,style)&&(style=type.styleAliases[style]),result[tag]=style;return result}(this.schema,options.styles||null),this.sortKeys=options.sortKeys||!1,this.lineWidth=options.lineWidth||80,this.noRefs=options.noRefs||!1,this.noCompatMode=options.noCompatMode||!1,this.condenseFlow=options.condenseFlow||!1,this.quotingType='"'===options.quotingType?2:1,this.forceQuotes=options.forceQuotes||!1,this.replacer="function"==typeof options.replacer?options.replacer:null,this.implicitTypes=this.schema.compiledImplicit,this.explicitTypes=this.schema.compiledExplicit,this.tag=null,this.result="",this.duplicates=[],this.usedDuplicates=null}function indentString(string,spaces){let line,ind=common.repeat(" ",spaces),position=0,next=-1,result="",length=string.length;for(;position<length;)next=string.indexOf("\n",position),-1===next?(line=string.slice(position),position=length):(line=string.slice(position,next+1),position=next+1),line.length&&"\n"!==line&&(result+=ind),result+=line;return result}function generateNextLine(state,level){return"\n"+common.repeat(" ",state.indent*level)}function isWhitespace(c){return 32===c||9===c}function isPrintable(c){return 32<=c&&c<=126||161<=c&&c<=55295&&8232!==c&&8233!==c||57344<=c&&c<=65533&&65279!==c||65536<=c&&c<=1114111}function isNsCharOrWhitespace(c){return isPrintable(c)&&65279!==c&&13!==c&&10!==c}function isPlainSafe(c,prev,inblock){let cIsNsCharOrWhitespace=isNsCharOrWhitespace(c),cIsNsChar=cIsNsCharOrWhitespace&&!isWhitespace(c);return(inblock?cIsNsCharOrWhitespace:cIsNsCharOrWhitespace&&44!==c&&91!==c&&93!==c&&123!==c&&125!==c)&&35!==c&&!(58===prev&&!cIsNsChar)||isNsCharOrWhitespace(prev)&&!isWhitespace(prev)&&35===c||58===prev&&cIsNsChar}function codePointAt(string,pos){let second,first=string.charCodeAt(pos);return first>=55296&&first<=56319&&pos+1<string.length&&(second=string.charCodeAt(pos+1),second>=56320&&second<=57343)?1024*(first-55296)+second-56320+65536:first}function needIndentIndicator(string){return/^\n* /.test(string)}function chooseScalarStyle(string,singleLineOnly,indentPerLevel,lineWidth,testAmbiguousType,quotingType,forceQuotes,inblock){let i,char=0,prevChar=null,hasLineBreak=!1,hasFoldableLine=!1,shouldTrackWidth=-1!==lineWidth,previousLineBreak=-1,plain=isPrintable(c=codePointAt(string,0))&&65279!==c&&!isWhitespace(c)&&45!==c&&63!==c&&58!==c&&44!==c&&91!==c&&93!==c&&123!==c&&125!==c&&35!==c&&38!==c&&42!==c&&33!==c&&124!==c&&61!==c&&62!==c&&39!==c&&34!==c&&37!==c&&64!==c&&96!==c&&function(c){return!isWhitespace(c)&&58!==c}(codePointAt(string,string.length-1));var c;if(singleLineOnly||forceQuotes)for(i=0;i<string.length;char>=65536?i+=2:i++){if(char=codePointAt(string,i),!isPrintable(char))return 5;plain=plain&&isPlainSafe(char,prevChar,inblock),prevChar=char}else{for(i=0;i<string.length;char>=65536?i+=2:i++){if(char=codePointAt(string,i),10===char)hasLineBreak=!0,shouldTrackWidth&&(hasFoldableLine=hasFoldableLine||i-previousLineBreak-1>lineWidth&&" "!==string[previousLineBreak+1],previousLineBreak=i);else if(!isPrintable(char))return 5;plain=plain&&isPlainSafe(char,prevChar,inblock),prevChar=char}hasFoldableLine=hasFoldableLine||shouldTrackWidth&&i-previousLineBreak-1>lineWidth&&" "!==string[previousLineBreak+1]}return hasLineBreak||hasFoldableLine?indentPerLevel>9&&needIndentIndicator(string)?5:forceQuotes?2===quotingType?5:2:hasFoldableLine?4:3:!plain||forceQuotes||testAmbiguousType(string)?2===quotingType?5:2:1}function writeScalar(state,string,level,iskey,inblock){state.dump=function(){if(0===string.length)return 2===state.quotingType?'""':"''";if(!state.noCompatMode&&(-1!==DEPRECATED_BOOLEANS_SYNTAX.indexOf(string)||DEPRECATED_BASE60_SYNTAX.test(string)))return 2===state.quotingType?'"'+string+'"':"'"+string+"'";let indent=state.indent*Math.max(1,level),lineWidth=-1===state.lineWidth?-1:Math.max(Math.min(state.lineWidth,40),state.lineWidth-indent),singleLineOnly=iskey||state.flowLevel>-1&&level>=state.flowLevel;switch(chooseScalarStyle(string,singleLineOnly,state.indent,lineWidth,(function(string){return function(state,str){let index,length,type;for(index=0,length=state.implicitTypes.length;index<length;index+=1)if(type=state.implicitTypes[index],type.resolve(str))return!0;return!1}(state,string)}),state.quotingType,state.forceQuotes&&!iskey,inblock)){case 1:return string;case 2:return"'"+string.replace(/'/g,"''")+"'";case 3:return"|"+blockHeader(string,state.indent)+dropEndingNewline(indentString(string,indent));case 4:return">"+blockHeader(string,state.indent)+dropEndingNewline(indentString(function(string,width){let moreIndented,match,lineRe=/(\n+)([^\n]*)/g,result=function(){let nextLF=string.indexOf("\n");return nextLF=-1!==nextLF?nextLF:string.length,lineRe.lastIndex=nextLF,foldLine(string.slice(0,nextLF),width)}(),prevMoreIndented="\n"===string[0]||" "===string[0];for(;match=lineRe.exec(string);){let prefix=match[1],line=match[2];moreIndented=" "===line[0],result+=prefix+(prevMoreIndented||moreIndented||""===line?"":"\n")+foldLine(line,width),prevMoreIndented=moreIndented}return result}(string,lineWidth),indent));case 5:return'"'+function(string){let escapeSeq,result="",char=0;for(let i=0;i<string.length;char>=65536?i+=2:i++)char=codePointAt(string,i),escapeSeq=ESCAPE_SEQUENCES[char],!escapeSeq&&isPrintable(char)?(result+=string[i],char>=65536&&(result+=string[i+1])):result+=escapeSeq||encodeHex(char);return result}(string)+'"';default:throw new exception("impossible error: invalid scalar style")}}()}function blockHeader(string,indentPerLevel){let indentIndicator=needIndentIndicator(string)?String(indentPerLevel):"",clip="\n"===string[string.length-1];return indentIndicator+(clip&&("\n"===string[string.length-2]||"\n"===string)?"+":clip?"":"-")+"\n"}function dropEndingNewline(string){return"\n"===string[string.length-1]?string.slice(0,-1):string}function foldLine(line,width){if(""===line||" "===line[0])return line;let match,end,breakRe=/ [^ ]/g,start=0,curr=0,next=0,result="";for(;match=breakRe.exec(line);)next=match.index,next-start>width&&(end=curr>start?curr:next,result+="\n"+line.slice(start,end),start=end+1),curr=next;return result+="\n",line.length-start>width&&curr>start?result+=line.slice(start,curr)+"\n"+line.slice(curr+1):result+=line.slice(start),result.slice(1)}function writeBlockSequence(state,level,object,compact){let index,length,value,_result="",_tag=state.tag;for(index=0,length=object.length;index<length;index+=1)value=object[index],state.replacer&&(value=state.replacer.call(object,String(index),value)),(writeNode(state,level+1,value,!0,!0,!1,!0)||void 0===value&&writeNode(state,level+1,null,!0,!0,!1,!0))&&(compact&&""===_result||(_result+=generateNextLine(state,level)),state.dump&&10===state.dump.charCodeAt(0)?_result+="-":_result+="- ",_result+=state.dump);state.tag=_tag,state.dump=_result||"[]"}function detectType(state,object,explicit){let _result,typeList,index,length,type,style;for(typeList=explicit?state.explicitTypes:state.implicitTypes,index=0,length=typeList.length;index<length;index+=1)if(type=typeList[index],(type.instanceOf||type.predicate)&&(!type.instanceOf||"object"==typeof object&&object instanceof type.instanceOf)&&(!type.predicate||type.predicate(object))){if(explicit?type.multi&&type.representName?state.tag=type.representName(object):state.tag=type.tag:state.tag="?",type.represent){if(style=state.styleMap[type.tag]||type.defaultStyle,"[object Function]"===_toString.call(type.represent))_result=type.represent(object,style);else{if(!_hasOwnProperty.call(type.represent,style))throw new exception("!<"+type.tag+'> tag resolver accepts not "'+style+'" style');_result=type.represent[style](object,style)}state.dump=_result}return!0}return!1}function writeNode(state,level,object,block,compact,iskey,isblockseq){state.tag=null,state.dump=object,detectType(state,object,!1)||detectType(state,object,!0);let tagStr,type=_toString.call(state.dump),inblock=block;block&&(block=state.flowLevel<0||state.flowLevel>level);let duplicateIndex,duplicate,objectOrArray="[object Object]"===type||"[object Array]"===type;if(objectOrArray&&(duplicateIndex=state.duplicates.indexOf(object),duplicate=-1!==duplicateIndex),(null!==state.tag&&"?"!==state.tag||duplicate||2!==state.indent&&level>0)&&(compact=!1),duplicate&&state.usedDuplicates[duplicateIndex])state.dump="*ref_"+duplicateIndex;else{if(objectOrArray&&duplicate&&!state.usedDuplicates[duplicateIndex]&&(state.usedDuplicates[duplicateIndex]=!0),"[object Object]"===type)block&&0!==Object.keys(state.dump).length?(!function(state,level,object,compact){let index,length,objectKey,objectValue,explicitPair,pairBuffer,_result="",_tag=state.tag,objectKeyList=Object.keys(object);if(!0===state.sortKeys)objectKeyList.sort();else if("function"==typeof state.sortKeys)objectKeyList.sort(state.sortKeys);else if(state.sortKeys)throw new exception("sortKeys must be a boolean or a function");for(index=0,length=objectKeyList.length;index<length;index+=1)pairBuffer="",compact&&""===_result||(pairBuffer+=generateNextLine(state,level)),objectKey=objectKeyList[index],objectValue=object[objectKey],state.replacer&&(objectValue=state.replacer.call(object,objectKey,objectValue)),writeNode(state,level+1,objectKey,!0,!0,!0)&&(explicitPair=null!==state.tag&&"?"!==state.tag||state.dump&&state.dump.length>1024,explicitPair&&(state.dump&&10===state.dump.charCodeAt(0)?pairBuffer+="?":pairBuffer+="? "),pairBuffer+=state.dump,explicitPair&&(pairBuffer+=generateNextLine(state,level)),writeNode(state,level+1,objectValue,!0,explicitPair)&&(state.dump&&10===state.dump.charCodeAt(0)?pairBuffer+=":":pairBuffer+=": ",pairBuffer+=state.dump,_result+=pairBuffer));state.tag=_tag,state.dump=_result||"{}"}(state,level,state.dump,compact),duplicate&&(state.dump="&ref_"+duplicateIndex+state.dump)):(!function(state,level,object){let index,length,objectKey,objectValue,pairBuffer,_result="",_tag=state.tag,objectKeyList=Object.keys(object);for(index=0,length=objectKeyList.length;index<length;index+=1)pairBuffer="",""!==_result&&(pairBuffer+=", "),state.condenseFlow&&(pairBuffer+='"'),objectKey=objectKeyList[index],objectValue=object[objectKey],state.replacer&&(objectValue=state.replacer.call(object,objectKey,objectValue)),writeNode(state,level,objectKey,!1,!1)&&(state.dump.length>1024&&(pairBuffer+="? "),pairBuffer+=state.dump+(state.condenseFlow?'"':"")+":"+(state.condenseFlow?"":" "),writeNode(state,level,objectValue,!1,!1)&&(pairBuffer+=state.dump,_result+=pairBuffer));state.tag=_tag,state.dump="{"+_result+"}"}(state,level,state.dump),duplicate&&(state.dump="&ref_"+duplicateIndex+" "+state.dump));else if("[object Array]"===type)block&&0!==state.dump.length?(state.noArrayIndent&&!isblockseq&&level>0?writeBlockSequence(state,level-1,state.dump,compact):writeBlockSequence(state,level,state.dump,compact),duplicate&&(state.dump="&ref_"+duplicateIndex+state.dump)):(!function(state,level,object){let index,length,value,_result="",_tag=state.tag;for(index=0,length=object.length;index<length;index+=1)value=object[index],state.replacer&&(value=state.replacer.call(object,String(index),value)),(writeNode(state,level,value,!1,!1)||void 0===value&&writeNode(state,level,null,!1,!1))&&(""!==_result&&(_result+=","+(state.condenseFlow?"":" ")),_result+=state.dump);state.tag=_tag,state.dump="["+_result+"]"}(state,level,state.dump),duplicate&&(state.dump="&ref_"+duplicateIndex+" "+state.dump));else{if("[object String]"!==type){if("[object Undefined]"===type)return!1;if(state.skipInvalid)return!1;throw new exception("unacceptable kind of an object to dump "+type)}"?"!==state.tag&&writeScalar(state,state.dump,level,iskey,inblock)}null!==state.tag&&"?"!==state.tag&&(tagStr=encodeURI("!"===state.tag[0]?state.tag.slice(1):state.tag).replace(/!/g,"%21"),tagStr="!"===state.tag[0]?"!"+tagStr:"tag:yaml.org,2002:"===tagStr.slice(0,18)?"!!"+tagStr.slice(18):"!<"+tagStr+">",state.dump=tagStr+" "+state.dump)}return!0}function getDuplicateReferences(object,state){let index,length,objects=[],duplicatesIndexes=[];for(inspectNode(object,objects,duplicatesIndexes),index=0,length=duplicatesIndexes.length;index<length;index+=1)state.duplicates.push(objects[duplicatesIndexes[index]]);state.usedDuplicates=new Array(length)}function inspectNode(object,objects,duplicatesIndexes){let objectKeyList,index,length;if(null!==object&&"object"==typeof object)if(index=objects.indexOf(object),-1!==index)-1===duplicatesIndexes.indexOf(index)&&duplicatesIndexes.push(index);else if(objects.push(object),Array.isArray(object))for(index=0,length=object.length;index<length;index+=1)inspectNode(object[index],objects,duplicatesIndexes);else for(objectKeyList=Object.keys(object),index=0,length=objectKeyList.length;index<length;index+=1)inspectNode(object[objectKeyList[index]],objects,duplicatesIndexes)}let dumper={dump:function(input,options){let state=new State(options=options||{});state.noRefs||getDuplicateReferences(input,state);let value=input;return state.replacer&&(value=state.replacer.call({"":value},"",value)),writeNode(state,0,value,!0,!0)?state.dump+"\n":""}};function renamed(from,to){return function(){throw new Error("Function yaml."+from+" is removed in js-yaml 4. Use yaml."+to+" instead, which is now safe by default.")}}const Type=type;_exports.Type=Type;const Schema=schema;_exports.Schema=Schema;const FAILSAFE_SCHEMA=failsafe;_exports.FAILSAFE_SCHEMA=FAILSAFE_SCHEMA;const JSON_SCHEMA=json;_exports.JSON_SCHEMA=JSON_SCHEMA;const CORE_SCHEMA=core;_exports.CORE_SCHEMA=CORE_SCHEMA;const DEFAULT_SCHEMA=_default;_exports.DEFAULT_SCHEMA=DEFAULT_SCHEMA;const load=loader.load;_exports.load=load;const loadAll=loader.loadAll;_exports.loadAll=loadAll;const dump=dumper.dump;_exports.dump=dump;const YAMLException=exception;_exports.YAMLException=YAMLException;const types={binary:binary,float:float,map:map,null:_null,pairs:pairs,set:set,timestamp:timestamp,bool:bool,int:int,merge:merge,omap:omap,seq:seq,str:str};_exports.types=types;const safeLoad=renamed("safeLoad","load");_exports.safeLoad=safeLoad;const safeLoadAll=renamed("safeLoadAll","loadAll");_exports.safeLoadAll=safeLoadAll;const safeDump=renamed("safeDump","dump");_exports.safeDump=safeDump;var _default2={Type:Type,Schema:Schema,FAILSAFE_SCHEMA:FAILSAFE_SCHEMA,JSON_SCHEMA:JSON_SCHEMA,CORE_SCHEMA:CORE_SCHEMA,DEFAULT_SCHEMA:DEFAULT_SCHEMA,load:load,loadAll:loadAll,dump:dump,YAMLException:YAMLException,types:types,safeLoad:safeLoad,safeLoadAll:safeLoadAll,safeDump:safeDump};return _exports.default=_default2,_exports.default}));

//# sourceMappingURL=js_yaml-lazy.min.js.map