define("tiny_widgethub/libs/yaml-lazy",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.Scalar=void 0,_exports.parse=function(src,reviver,options){let _reviver;"function"==typeof reviver?_reviver=reviver:void 0===options&&reviver&&"object"==typeof reviver&&(options=reviver);const doc=function(source){let options=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{lineCounter:lineCounter,prettyErrors:prettyErrors}=parseOptions(options),parser=new Parser(null==lineCounter?void 0:lineCounter.addNewLine),composer=new Composer(options);let doc=null;for(const _doc of composer.compose(parser.parse(source),!0,source.length))if(doc){if("silent"!==doc.options.logLevel){doc.errors.push(new YAMLParseError(_doc.range.slice(0,2),"MULTIPLE_DOCS","Source contains multiple documents; please use YAML.parseAllDocuments()"));break}}else doc=_doc;prettyErrors&&lineCounter&&(doc.errors.forEach(prettifyError(source,lineCounter)),doc.warnings.forEach(prettifyError(source,lineCounter)));return doc}(src,options);if(!doc)return null;if(doc.warnings.forEach((warning=>warn(doc.options.logLevel,warning))),doc.errors.length>0){if("silent"!==doc.options.logLevel)throw doc.errors[0];doc.errors=[]}return doc.toJS(Object.assign({reviver:_reviver},options))},_exports.stringify=function(value,replacer,options){let _replacer=null;"function"==typeof replacer||Array.isArray(replacer)?_replacer=replacer:void 0===options&&replacer&&(options=replacer);"string"==typeof options&&(options=options.length);if("number"==typeof options){const indent=Math.round(options);options=indent<1?void 0:indent>8?{indent:8}:{indent:indent}}if(void 0===value){const{keepUndefined:keepUndefined}=options??replacer??{};if(!keepUndefined)return}return isDocument(value)&&!_replacer?value.toString(options):new Document(value,_replacer,options).toString(options)};const ALIAS=Symbol.for("yaml.alias"),DOC=Symbol.for("yaml.document"),MAP=Symbol.for("yaml.map"),PAIR=Symbol.for("yaml.pair"),SCALAR$1=Symbol.for("yaml.scalar"),SEQ=Symbol.for("yaml.seq"),NODE_TYPE=Symbol.for("yaml.node.type"),isAlias=node=>!!node&&"object"==typeof node&&node[NODE_TYPE]===ALIAS,isDocument=node=>!!node&&"object"==typeof node&&node[NODE_TYPE]===DOC,isMap=node=>!!node&&"object"==typeof node&&node[NODE_TYPE]===MAP,isPair=node=>!!node&&"object"==typeof node&&node[NODE_TYPE]===PAIR,isScalar=node=>!!node&&"object"==typeof node&&node[NODE_TYPE]===SCALAR$1,isSeq=node=>!!node&&"object"==typeof node&&node[NODE_TYPE]===SEQ;function isCollection(node){if(node&&"object"==typeof node)switch(node[NODE_TYPE]){case MAP:case SEQ:return!0}return!1}function isNode(node){if(node&&"object"==typeof node)switch(node[NODE_TYPE]){case ALIAS:case MAP:case SCALAR$1:case SEQ:return!0}return!1}const hasAnchor=node=>(isScalar(node)||isCollection(node))&&!!node.anchor,BREAK=Symbol("break visit"),SKIP=Symbol("skip children"),REMOVE=Symbol("remove node");function visit(node,visitor){const visitor_=function(visitor){if("object"==typeof visitor&&(visitor.Collection||visitor.Node||visitor.Value))return Object.assign({Alias:visitor.Node,Map:visitor.Node,Scalar:visitor.Node,Seq:visitor.Node},visitor.Value&&{Map:visitor.Value,Scalar:visitor.Value,Seq:visitor.Value},visitor.Collection&&{Map:visitor.Collection,Seq:visitor.Collection},visitor);return visitor}(visitor);if(isDocument(node)){visit_(null,node.contents,visitor_,Object.freeze([node]))===REMOVE&&(node.contents=null)}else visit_(null,node,visitor_,Object.freeze([]))}function visit_(key,node,visitor,path){const ctrl=function(key,node,visitor,path){var _visitor$Map,_visitor$Seq,_visitor$Pair,_visitor$Scalar,_visitor$Alias;return"function"==typeof visitor?visitor(key,node,path):isMap(node)?null===(_visitor$Map=visitor.Map)||void 0===_visitor$Map?void 0:_visitor$Map.call(visitor,key,node,path):isSeq(node)?null===(_visitor$Seq=visitor.Seq)||void 0===_visitor$Seq?void 0:_visitor$Seq.call(visitor,key,node,path):isPair(node)?null===(_visitor$Pair=visitor.Pair)||void 0===_visitor$Pair?void 0:_visitor$Pair.call(visitor,key,node,path):isScalar(node)?null===(_visitor$Scalar=visitor.Scalar)||void 0===_visitor$Scalar?void 0:_visitor$Scalar.call(visitor,key,node,path):isAlias(node)?null===(_visitor$Alias=visitor.Alias)||void 0===_visitor$Alias?void 0:_visitor$Alias.call(visitor,key,node,path):void 0}(key,node,visitor,path);if(isNode(ctrl)||isPair(ctrl))return function(key,path,node){const parent=path[path.length-1];if(isCollection(parent))parent.items[key]=node;else if(isPair(parent))"key"===key?parent.key=node:parent.value=node;else{if(!isDocument(parent)){const pt=isAlias(parent)?"alias":"scalar";throw new Error(`Cannot replace node with ${pt} parent`)}parent.contents=node}}(key,path,ctrl),visit_(key,ctrl,visitor,path);if("symbol"!=typeof ctrl)if(isCollection(node)){path=Object.freeze(path.concat(node));for(let i=0;i<node.items.length;++i){const ci=visit_(i,node.items[i],visitor,path);if("number"==typeof ci)i=ci-1;else{if(ci===BREAK)return BREAK;ci===REMOVE&&(node.items.splice(i,1),i-=1)}}}else if(isPair(node)){path=Object.freeze(path.concat(node));const ck=visit_("key",node.key,visitor,path);if(ck===BREAK)return BREAK;ck===REMOVE&&(node.key=null);const cv=visit_("value",node.value,visitor,path);if(cv===BREAK)return BREAK;cv===REMOVE&&(node.value=null)}return ctrl}visit.BREAK=BREAK,visit.SKIP=SKIP,visit.REMOVE=REMOVE;const escapeChars={"!":"%21",",":"%2C","[":"%5B","]":"%5D","{":"%7B","}":"%7D"};class Directives{constructor(yaml,tags){this.docStart=null,this.docEnd=!1,this.yaml=Object.assign({},Directives.defaultYaml,yaml),this.tags=Object.assign({},Directives.defaultTags,tags)}clone(){const copy=new Directives(this.yaml,this.tags);return copy.docStart=this.docStart,copy}atDocument(){const res=new Directives(this.yaml,this.tags);switch(this.yaml.version){case"1.1":this.atNextDocument=!0;break;case"1.2":this.atNextDocument=!1,this.yaml={explicit:Directives.defaultYaml.explicit,version:"1.2"},this.tags=Object.assign({},Directives.defaultTags)}return res}add(line,onError){this.atNextDocument&&(this.yaml={explicit:Directives.defaultYaml.explicit,version:"1.1"},this.tags=Object.assign({},Directives.defaultTags),this.atNextDocument=!1);const parts=line.trim().split(/[ \t]+/),name=parts.shift();switch(name){case"%TAG":{if(2!==parts.length&&(onError(0,"%TAG directive should contain exactly two parts"),parts.length<2))return!1;const[handle,prefix]=parts;return this.tags[handle]=prefix,!0}case"%YAML":{if(this.yaml.explicit=!0,1!==parts.length)return onError(0,"%YAML directive should contain exactly one part"),!1;const[version]=parts;if("1.1"===version||"1.2"===version)return this.yaml.version=version,!0;return onError(6,`Unsupported YAML version ${version}`,/^\d+\.\d+$/.test(version)),!1}default:return onError(0,`Unknown directive ${name}`,!0),!1}}tagName(source,onError){if("!"===source)return"!";if("!"!==source[0])return onError(`Not a valid tag: ${source}`),null;if("<"===source[1]){const verbatim=source.slice(2,-1);return"!"===verbatim||"!!"===verbatim?(onError(`Verbatim tags aren't resolved, so ${source} is invalid.`),null):(">"!==source[source.length-1]&&onError("Verbatim tags must end with a >"),verbatim)}const[,handle,suffix]=source.match(/^(.*!)([^!]*)$/s);suffix||onError(`The ${source} tag has no suffix`);const prefix=this.tags[handle];if(prefix)try{return prefix+decodeURIComponent(suffix)}catch(error){return onError(String(error)),null}return"!"===handle?source:(onError(`Could not resolve tag: ${source}`),null)}tagString(tag){for(const[handle,prefix]of Object.entries(this.tags))if(tag.startsWith(prefix))return handle+tag.substring(prefix.length).replace(/[!,[\]{}]/g,(ch=>escapeChars[ch]));return"!"===tag[0]?tag:`!<${tag}>`}toString(doc){const lines=this.yaml.explicit?[`%YAML ${this.yaml.version||"1.2"}`]:[],tagEntries=Object.entries(this.tags);let tagNames;if(doc&&tagEntries.length>0&&isNode(doc.contents)){const tags={};visit(doc.contents,((_key,node)=>{isNode(node)&&node.tag&&(tags[node.tag]=!0)})),tagNames=Object.keys(tags)}else tagNames=[];for(const[handle,prefix]of tagEntries)"!!"===handle&&"tag:yaml.org,2002:"===prefix||doc&&!tagNames.some((tn=>tn.startsWith(prefix)))||lines.push(`%TAG ${handle} ${prefix}`);return lines.join("\n")}}function anchorIsValid(anchor){if(/[\x00-\x19\s,[\]{}]/.test(anchor)){const sa=JSON.stringify(anchor);throw new Error(`Anchor must not contain whitespace or control characters: ${sa}`)}return!0}function anchorNames(root){const anchors=new Set;return visit(root,{Value(_key,node){node.anchor&&anchors.add(node.anchor)}}),anchors}function findNewAnchor(prefix,exclude){for(let i=1;;++i){const name=`${prefix}${i}`;if(!exclude.has(name))return name}}function applyReviver(reviver,obj,key,val){if(val&&"object"==typeof val)if(Array.isArray(val))for(let i=0,len=val.length;i<len;++i){const v0=val[i],v1=applyReviver(reviver,val,String(i),v0);void 0===v1?delete val[i]:v1!==v0&&(val[i]=v1)}else if(val instanceof Map)for(const k of Array.from(val.keys())){const v0=val.get(k),v1=applyReviver(reviver,val,k,v0);void 0===v1?val.delete(k):v1!==v0&&val.set(k,v1)}else if(val instanceof Set)for(const v0 of Array.from(val)){const v1=applyReviver(reviver,val,v0,v0);void 0===v1?val.delete(v0):v1!==v0&&(val.delete(v0),val.add(v1))}else for(const[k,v0]of Object.entries(val)){const v1=applyReviver(reviver,val,k,v0);void 0===v1?delete val[k]:v1!==v0&&(val[k]=v1)}return reviver.call(obj,key,val)}function toJS(value,arg,ctx){if(Array.isArray(value))return value.map(((v,i)=>toJS(v,String(i),ctx)));if(value&&"function"==typeof value.toJSON){if(!ctx||!hasAnchor(value))return value.toJSON(arg,ctx);const data={aliasCount:0,count:1,res:void 0};ctx.anchors.set(value,data),ctx.onCreate=res=>{data.res=res,delete ctx.onCreate};const res=value.toJSON(arg,ctx);return ctx.onCreate&&ctx.onCreate(res),res}return"bigint"!=typeof value||null!=ctx&&ctx.keep?value:Number(value)}Directives.defaultYaml={explicit:!1,version:"1.2"},Directives.defaultTags={"!!":"tag:yaml.org,2002:"};class NodeBase{constructor(type){Object.defineProperty(this,NODE_TYPE,{value:type})}clone(){const copy=Object.create(Object.getPrototypeOf(this),Object.getOwnPropertyDescriptors(this));return this.range&&(copy.range=this.range.slice()),copy}toJS(doc){let{mapAsMap:mapAsMap,maxAliasCount:maxAliasCount,onAnchor:onAnchor,reviver:reviver}=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isDocument(doc))throw new TypeError("A document argument is required");const ctx={anchors:new Map,doc:doc,keep:!0,mapAsMap:!0===mapAsMap,mapKeyWarned:!1,maxAliasCount:"number"==typeof maxAliasCount?maxAliasCount:100},res=toJS(this,"",ctx);if("function"==typeof onAnchor)for(const{count:count,res:res}of ctx.anchors.values())onAnchor(res,count);return"function"==typeof reviver?applyReviver(reviver,{"":res},"",res):res}}class Alias extends NodeBase{constructor(source){super(ALIAS),this.source=source,Object.defineProperty(this,"tag",{set(){throw new Error("Alias nodes cannot have tags")}})}resolve(doc,ctx){let nodes,found;null!=ctx&&ctx.aliasResolveCache?nodes=ctx.aliasResolveCache:(nodes=[],visit(doc,{Node:(_key,node)=>{(isAlias(node)||hasAnchor(node))&&nodes.push(node)}}),ctx&&(ctx.aliasResolveCache=nodes));for(const node of nodes){if(node===this)break;node.anchor===this.source&&(found=node)}return found}toJSON(_arg,ctx){if(!ctx)return{source:this.source};const{anchors:anchors,doc:doc,maxAliasCount:maxAliasCount}=ctx,source=this.resolve(doc,ctx);if(!source){const msg=`Unresolved alias (the anchor must be set before the alias): ${this.source}`;throw new ReferenceError(msg)}let data=anchors.get(source);if(data||(toJS(source,null,ctx),data=anchors.get(source)),!data||void 0===data.res){throw new ReferenceError("This should not happen: Alias anchor was not resolved?")}if(maxAliasCount>=0&&(data.count+=1,0===data.aliasCount&&(data.aliasCount=getAliasCount(doc,source,anchors)),data.count*data.aliasCount>maxAliasCount)){throw new ReferenceError("Excessive alias count indicates a resource exhaustion attack")}return data.res}toString(ctx,_onComment,_onChompKeep){const src=`*${this.source}`;if(ctx){if(anchorIsValid(this.source),ctx.options.verifyAliasOrder&&!ctx.anchors.has(this.source)){const msg=`Unresolved alias (the anchor must be set before the alias): ${this.source}`;throw new Error(msg)}if(ctx.implicitKey)return`${src} `}return src}}function getAliasCount(doc,node,anchors){if(isAlias(node)){const source=node.resolve(doc),anchor=anchors&&source&&anchors.get(source);return anchor?anchor.count*anchor.aliasCount:0}if(isCollection(node)){let count=0;for(const item of node.items){const c=getAliasCount(doc,item,anchors);c>count&&(count=c)}return count}if(isPair(node)){const kc=getAliasCount(doc,node.key,anchors),vc=getAliasCount(doc,node.value,anchors);return Math.max(kc,vc)}return 1}const isScalarValue=value=>!value||"function"!=typeof value&&"object"!=typeof value;class Scalar extends NodeBase{constructor(value){super(SCALAR$1),this.value=value}toJSON(arg,ctx){return null!=ctx&&ctx.keep?this.value:toJS(this.value,arg,ctx)}toString(){return String(this.value)}}_exports.Scalar=Scalar,Scalar.BLOCK_FOLDED="BLOCK_FOLDED",Scalar.BLOCK_LITERAL="BLOCK_LITERAL",Scalar.PLAIN="PLAIN",Scalar.QUOTE_DOUBLE="QUOTE_DOUBLE",Scalar.QUOTE_SINGLE="QUOTE_SINGLE";function createNode(value,tagName,ctx){var _tagName,_tagObj,_tagObj2,_tagObj2$nodeClass;if(isDocument(value)&&(value=value.contents),isNode(value))return value;if(isPair(value)){var _ctx$schema$MAP$creat,_ctx$schema$MAP;const map=null===(_ctx$schema$MAP$creat=(_ctx$schema$MAP=ctx.schema[MAP]).createNode)||void 0===_ctx$schema$MAP$creat?void 0:_ctx$schema$MAP$creat.call(_ctx$schema$MAP,ctx.schema,null,ctx);return map.items.push(value),map}(value instanceof String||value instanceof Number||value instanceof Boolean||"undefined"!=typeof BigInt&&value instanceof BigInt)&&(value=value.valueOf());const{aliasDuplicateObjects:aliasDuplicateObjects,onAnchor:onAnchor,onTagObj:onTagObj,schema:schema,sourceObjects:sourceObjects}=ctx;let ref;if(aliasDuplicateObjects&&value&&"object"==typeof value){if(ref=sourceObjects.get(value),ref)return ref.anchor??(ref.anchor=onAnchor(value)),new Alias(ref.anchor);ref={anchor:null,node:null},sourceObjects.set(value,ref)}null!==(_tagName=tagName)&&void 0!==_tagName&&_tagName.startsWith("!!")&&(tagName="tag:yaml.org,2002:"+tagName.slice(2));let tagObj=function(value,tagName,tags){if(tagName){const match=tags.filter((t=>t.tag===tagName)),tagObj=match.find((t=>!t.format))??match[0];if(!tagObj)throw new Error(`Tag ${tagName} not found`);return tagObj}return tags.find((t=>{var _t$identify;return(null===(_t$identify=t.identify)||void 0===_t$identify?void 0:_t$identify.call(t,value))&&!t.format}))}(value,tagName,schema.tags);if(!tagObj){if(value&&"function"==typeof value.toJSON&&(value=value.toJSON()),!value||"object"!=typeof value){const node=new Scalar(value);return ref&&(ref.node=node),node}tagObj=value instanceof Map?schema[MAP]:Symbol.iterator in Object(value)?schema[SEQ]:schema[MAP]}onTagObj&&(onTagObj(tagObj),delete ctx.onTagObj);const node=null!==(_tagObj=tagObj)&&void 0!==_tagObj&&_tagObj.createNode?tagObj.createNode(ctx.schema,value,ctx):"function"==typeof(null===(_tagObj2=tagObj)||void 0===_tagObj2||null===(_tagObj2$nodeClass=_tagObj2.nodeClass)||void 0===_tagObj2$nodeClass?void 0:_tagObj2$nodeClass.from)?tagObj.nodeClass.from(ctx.schema,value,ctx):new Scalar(value);return tagName?node.tag=tagName:tagObj.default||(node.tag=tagObj.tag),ref&&(ref.node=node),node}function collectionFromPath(schema,path,value){let v=value;for(let i=path.length-1;i>=0;--i){const k=path[i];if("number"==typeof k&&Number.isInteger(k)&&k>=0){const a=[];a[k]=v,v=a}else v=new Map([[k,v]])}return createNode(v,void 0,{aliasDuplicateObjects:!1,keepUndefined:!1,onAnchor:()=>{throw new Error("This should not happen, please report a bug.")},schema:schema,sourceObjects:new Map})}const isEmptyPath=path=>null==path||"object"==typeof path&&!!path[Symbol.iterator]().next().done;class Collection extends NodeBase{constructor(type,schema){super(type),Object.defineProperty(this,"schema",{value:schema,configurable:!0,enumerable:!1,writable:!0})}clone(schema){const copy=Object.create(Object.getPrototypeOf(this),Object.getOwnPropertyDescriptors(this));return schema&&(copy.schema=schema),copy.items=copy.items.map((it=>isNode(it)||isPair(it)?it.clone(schema):it)),this.range&&(copy.range=this.range.slice()),copy}addIn(path,value){if(isEmptyPath(path))this.add(value);else{const[key,...rest]=path,node=this.get(key,!0);if(isCollection(node))node.addIn(rest,value);else{if(void 0!==node||!this.schema)throw new Error(`Expected YAML collection at ${key}. Remaining path: ${rest}`);this.set(key,collectionFromPath(this.schema,rest,value))}}}deleteIn(path){const[key,...rest]=path;if(0===rest.length)return this.delete(key);const node=this.get(key,!0);if(isCollection(node))return node.deleteIn(rest);throw new Error(`Expected YAML collection at ${key}. Remaining path: ${rest}`)}getIn(path,keepScalar){const[key,...rest]=path,node=this.get(key,!0);return 0===rest.length?!keepScalar&&isScalar(node)?node.value:node:isCollection(node)?node.getIn(rest,keepScalar):void 0}hasAllNullValues(allowScalar){return this.items.every((node=>{if(!isPair(node))return!1;const n=node.value;return null==n||allowScalar&&isScalar(n)&&null==n.value&&!n.commentBefore&&!n.comment&&!n.tag}))}hasIn(path){const[key,...rest]=path;if(0===rest.length)return this.has(key);const node=this.get(key,!0);return!!isCollection(node)&&node.hasIn(rest)}setIn(path,value){const[key,...rest]=path;if(0===rest.length)this.set(key,value);else{const node=this.get(key,!0);if(isCollection(node))node.setIn(rest,value);else{if(void 0!==node||!this.schema)throw new Error(`Expected YAML collection at ${key}. Remaining path: ${rest}`);this.set(key,collectionFromPath(this.schema,rest,value))}}}}const stringifyComment=str=>str.replace(/^(?!$)(?: $)?/gm,"#");function indentComment(comment,indent){return/^\n+$/.test(comment)?comment.substring(1):indent?comment.replace(/^(?! *$)/gm,indent):comment}const lineComment=(str,indent,comment)=>str.endsWith("\n")?indentComment(comment,indent):comment.includes("\n")?"\n"+indentComment(comment,indent):(str.endsWith(" ")?"":" ")+comment;function foldFlowLines(text,indent){let mode=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"flow",{indentAtStart:indentAtStart,lineWidth:lineWidth=80,minContentWidth:minContentWidth=20,onFold:onFold,onOverflow:onOverflow}=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};if(!lineWidth||lineWidth<0)return text;lineWidth<minContentWidth&&(minContentWidth=0);const endStep=Math.max(1+minContentWidth,1+lineWidth-indent.length);if(text.length<=endStep)return text;const folds=[],escapedFolds={};let split,prev,end=lineWidth-indent.length;"number"==typeof indentAtStart&&(indentAtStart>lineWidth-Math.max(2,minContentWidth)?folds.push(0):end=lineWidth-indentAtStart);let ch,overflow=!1,i=-1,escStart=-1,escEnd=-1;for("block"===mode&&(i=consumeMoreIndentedLines(text,i,indent.length),-1!==i&&(end=i+endStep));ch=text[i+=1];){if("quoted"===mode&&"\\"===ch){switch(escStart=i,text[i+1]){case"x":i+=3;break;case"u":i+=5;break;case"U":i+=9;break;default:i+=1}escEnd=i}if("\n"===ch)"block"===mode&&(i=consumeMoreIndentedLines(text,i,indent.length)),end=i+indent.length+endStep,split=void 0;else{if(" "===ch&&prev&&" "!==prev&&"\n"!==prev&&"\t"!==prev){const next=text[i+1];next&&" "!==next&&"\n"!==next&&"\t"!==next&&(split=i)}if(i>=end)if(split)folds.push(split),end=split+endStep,split=void 0;else if("quoted"===mode){for(;" "===prev||"\t"===prev;)prev=ch,ch=text[i+=1],overflow=!0;const j=i>escEnd+1?i-2:escStart-1;if(escapedFolds[j])return text;folds.push(j),escapedFolds[j]=!0,end=j+endStep,split=void 0}else overflow=!0}prev=ch}if(overflow&&onOverflow&&onOverflow(),0===folds.length)return text;onFold&&onFold();let res=text.slice(0,folds[0]);for(let i=0;i<folds.length;++i){const fold=folds[i],end=folds[i+1]||text.length;0===fold?res=`\n${indent}${text.slice(0,end)}`:("quoted"===mode&&escapedFolds[fold]&&(res+=`${text[fold]}\\`),res+=`\n${indent}${text.slice(fold+1,end)}`)}return res}function consumeMoreIndentedLines(text,i,indent){let end=i,start=i+1,ch=text[start];for(;" "===ch||"\t"===ch;)if(i<start+indent)ch=text[++i];else{do{ch=text[++i]}while(ch&&"\n"!==ch);end=i,start=i+1,ch=text[start]}return end}const getFoldOptions=(ctx,isBlock)=>({indentAtStart:isBlock?ctx.indent.length:ctx.indentAtStart,lineWidth:ctx.options.lineWidth,minContentWidth:ctx.options.minContentWidth}),containsDocumentMarker=str=>/^(%|---|\.\.\.)/m.test(str);function doubleQuotedString(value,ctx){const json=JSON.stringify(value);if(ctx.options.doubleQuotedAsJSON)return json;const{implicitKey:implicitKey}=ctx,minMultiLineLength=ctx.options.doubleQuotedMinMultiLineLength,indent=ctx.indent||(containsDocumentMarker(value)?"  ":"");let str="",start=0;for(let i=0,ch=json[i];ch;ch=json[++i])if(" "===ch&&"\\"===json[i+1]&&"n"===json[i+2]&&(str+=json.slice(start,i)+"\\ ",i+=1,start=i,ch="\\"),"\\"===ch)switch(json[i+1]){case"u":{str+=json.slice(start,i);const code=json.substr(i+2,4);switch(code){case"0000":str+="\\0";break;case"0007":str+="\\a";break;case"000b":str+="\\v";break;case"001b":str+="\\e";break;case"0085":str+="\\N";break;case"00a0":str+="\\_";break;case"2028":str+="\\L";break;case"2029":str+="\\P";break;default:"00"===code.substr(0,2)?str+="\\x"+code.substr(2):str+=json.substr(i,6)}i+=5,start=i+1}break;case"n":if(implicitKey||'"'===json[i+2]||json.length<minMultiLineLength)i+=1;else{for(str+=json.slice(start,i)+"\n\n";"\\"===json[i+2]&&"n"===json[i+3]&&'"'!==json[i+4];)str+="\n",i+=2;str+=indent," "===json[i+2]&&(str+="\\"),i+=1,start=i+1}break;default:i+=1}return str=start?str+json.slice(start):json,implicitKey?str:foldFlowLines(str,indent,"quoted",getFoldOptions(ctx,!1))}function singleQuotedString(value,ctx){if(!1===ctx.options.singleQuote||ctx.implicitKey&&value.includes("\n")||/[ \t]\n|\n[ \t]/.test(value))return doubleQuotedString(value,ctx);const indent=ctx.indent||(containsDocumentMarker(value)?"  ":""),res="'"+value.replace(/'/g,"''").replace(/\n+/g,`$&\n${indent}`)+"'";return ctx.implicitKey?res:foldFlowLines(res,indent,"flow",getFoldOptions(ctx,!1))}function quotedString(value,ctx){const{singleQuote:singleQuote}=ctx.options;let qs;if(!1===singleQuote)qs=doubleQuotedString;else{const hasDouble=value.includes('"'),hasSingle=value.includes("'");qs=hasDouble&&!hasSingle?singleQuotedString:hasSingle&&!hasDouble?doubleQuotedString:singleQuote?singleQuotedString:doubleQuotedString}return qs(value,ctx)}let blockEndNewlines;try{blockEndNewlines=new RegExp("(^|(?<!\n))\n+(?!\n|$)","g")}catch{blockEndNewlines=/\n+(?!\n|$)/g}function blockString(_ref,ctx,onComment,onChompKeep){let{comment:comment,type:type,value:value}=_ref;const{blockQuote:blockQuote,commentString:commentString,lineWidth:lineWidth}=ctx.options;if(!blockQuote||/\n[\t ]+$/.test(value)||/^\s*$/.test(value))return quotedString(value,ctx);const indent=ctx.indent||(ctx.forceBlockIndent||containsDocumentMarker(value)?"  ":""),literal="literal"===blockQuote||"folded"!==blockQuote&&type!==Scalar.BLOCK_FOLDED&&(type===Scalar.BLOCK_LITERAL||!function(str,lineWidth,indentLength){if(!lineWidth||lineWidth<0)return!1;const limit=lineWidth-indentLength,strLen=str.length;if(strLen<=limit)return!1;for(let i=0,start=0;i<strLen;++i)if("\n"===str[i]){if(i-start>limit)return!0;if(start=i+1,strLen-start<=limit)return!1}return!0}(value,lineWidth,indent.length));if(!value)return literal?"|\n":">\n";let chomp,endStart;for(endStart=value.length;endStart>0;--endStart){const ch=value[endStart-1];if("\n"!==ch&&"\t"!==ch&&" "!==ch)break}let end=value.substring(endStart);const endNlPos=end.indexOf("\n");-1===endNlPos?chomp="-":value===end||endNlPos!==end.length-1?(chomp="+",onChompKeep&&onChompKeep()):chomp="",end&&(value=value.slice(0,-end.length),"\n"===end[end.length-1]&&(end=end.slice(0,-1)),end=end.replace(blockEndNewlines,`$&${indent}`));let startEnd,startWithSpace=!1,startNlPos=-1;for(startEnd=0;startEnd<value.length;++startEnd){const ch=value[startEnd];if(" "===ch)startWithSpace=!0;else{if("\n"!==ch)break;startNlPos=startEnd}}let start=value.substring(0,startNlPos<startEnd?startNlPos+1:startEnd);start&&(value=value.substring(start.length),start=start.replace(/\n+/g,`$&${indent}`));let header=(startWithSpace?indent?"2":"1":"")+chomp;if(comment&&(header+=" "+commentString(comment.replace(/ ?[\r\n]+/g," ")),onComment&&onComment()),!literal){const foldedValue=value.replace(/\n+/g,"\n$&").replace(/(?:^|\n)([\t ].*)(?:([\n\t ]*)\n(?![\n\t ]))?/g,"$1$2").replace(/\n+/g,`$&${indent}`);let literalFallback=!1;const foldOptions=getFoldOptions(ctx,!0);"folded"!==blockQuote&&type!==Scalar.BLOCK_FOLDED&&(foldOptions.onOverflow=()=>{literalFallback=!0});const body=foldFlowLines(`${start}${foldedValue}${end}`,indent,"block",foldOptions);if(!literalFallback)return`>${header}\n${indent}${body}`}return value=value.replace(/\n+/g,`$&${indent}`),`|${header}\n${indent}${start}${value}${end}`}function stringifyString(item,ctx,onComment,onChompKeep){const{implicitKey:implicitKey,inFlow:inFlow}=ctx,ss="string"==typeof item.value?item:Object.assign({},item,{value:String(item.value)});let{type:type}=item;type!==Scalar.QUOTE_DOUBLE&&/[\x00-\x08\x0b-\x1f\x7f-\x9f\u{D800}-\u{DFFF}]/u.test(ss.value)&&(type=Scalar.QUOTE_DOUBLE);const _stringify=_type=>{switch(_type){case Scalar.BLOCK_FOLDED:case Scalar.BLOCK_LITERAL:return implicitKey||inFlow?quotedString(ss.value,ctx):blockString(ss,ctx,onComment,onChompKeep);case Scalar.QUOTE_DOUBLE:return doubleQuotedString(ss.value,ctx);case Scalar.QUOTE_SINGLE:return singleQuotedString(ss.value,ctx);case Scalar.PLAIN:return function(item,ctx,onComment,onChompKeep){const{type:type,value:value}=item,{actualString:actualString,implicitKey:implicitKey,indent:indent,indentStep:indentStep,inFlow:inFlow}=ctx;if(implicitKey&&value.includes("\n")||inFlow&&/[[\]{},]/.test(value))return quotedString(value,ctx);if(/^[\n\t ,[\]{}#&*!|>'"%@`]|^[?-]$|^[?-][ \t]|[\n:][ \t]|[ \t]\n|[\n\t ]#|[\n\t :]$/.test(value))return implicitKey||inFlow||!value.includes("\n")?quotedString(value,ctx):blockString(item,ctx,onComment,onChompKeep);if(!implicitKey&&!inFlow&&type!==Scalar.PLAIN&&value.includes("\n"))return blockString(item,ctx,onComment,onChompKeep);if(containsDocumentMarker(value)){if(""===indent)return ctx.forceBlockIndent=!0,blockString(item,ctx,onComment,onChompKeep);if(implicitKey&&indent===indentStep)return quotedString(value,ctx)}const str=value.replace(/\n+/g,`$&\n${indent}`);if(actualString){const test=tag=>{var _tag$test;return tag.default&&"tag:yaml.org,2002:str"!==tag.tag&&(null===(_tag$test=tag.test)||void 0===_tag$test?void 0:_tag$test.test(str))},{compat:compat,tags:tags}=ctx.doc.schema;if(tags.some(test)||null!=compat&&compat.some(test))return quotedString(value,ctx)}return implicitKey?str:foldFlowLines(str,indent,"flow",getFoldOptions(ctx,!1))}(ss,ctx,onComment,onChompKeep);default:return null}};let res=_stringify(type);if(null===res){const{defaultKeyType:defaultKeyType,defaultStringType:defaultStringType}=ctx.options,t=implicitKey&&defaultKeyType||defaultStringType;if(res=_stringify(t),null===res)throw new Error(`Unsupported default string type ${t}`)}return res}function createStringifyContext(doc,options){const opt=Object.assign({blockQuote:!0,commentString:stringifyComment,defaultKeyType:null,defaultStringType:"PLAIN",directives:null,doubleQuotedAsJSON:!1,doubleQuotedMinMultiLineLength:40,falseStr:"false",flowCollectionPadding:!0,indentSeq:!0,lineWidth:80,minContentWidth:20,nullStr:"null",simpleKeys:!1,singleQuote:null,trueStr:"true",verifyAliasOrder:!0},doc.schema.toStringOptions,options);let inFlow;switch(opt.collectionStyle){case"block":inFlow=!1;break;case"flow":inFlow=!0;break;default:inFlow=null}return{anchors:new Set,doc:doc,flowCollectionPadding:opt.flowCollectionPadding?" ":"",indent:"",indentStep:"number"==typeof opt.indent?" ".repeat(opt.indent):"  ",inFlow:inFlow,options:opt}}function stringify$1(item,ctx,onComment,onChompKeep){if(isPair(item))return item.toString(ctx,onComment,onChompKeep);if(isAlias(item)){var _ctx$resolvedAliases;if(ctx.doc.directives)return item.toString(ctx);if(null!==(_ctx$resolvedAliases=ctx.resolvedAliases)&&void 0!==_ctx$resolvedAliases&&_ctx$resolvedAliases.has(item))throw new TypeError("Cannot stringify circular structure without alias nodes");ctx.resolvedAliases?ctx.resolvedAliases.add(item):ctx.resolvedAliases=new Set([item]),item=item.resolve(ctx.doc)}let tagObj;const node=isNode(item)?item:ctx.doc.createNode(item,{onTagObj:o=>tagObj=o});tagObj??(tagObj=function(tags,item){if(item.tag){const match=tags.filter((t=>t.tag===item.tag));if(match.length>0)return match.find((t=>t.format===item.format))??match[0]}let tagObj,obj;if(isScalar(item)){obj=item.value;let match=tags.filter((t=>{var _t$identify2;return null===(_t$identify2=t.identify)||void 0===_t$identify2?void 0:_t$identify2.call(t,obj)}));if(match.length>1){const testMatch=match.filter((t=>t.test));testMatch.length>0&&(match=testMatch)}tagObj=match.find((t=>t.format===item.format))??match.find((t=>!t.format))}else obj=item,tagObj=tags.find((t=>t.nodeClass&&obj instanceof t.nodeClass));if(!tagObj){var _obj,_obj$constructor;const name=(null===(_obj=obj)||void 0===_obj||null===(_obj$constructor=_obj.constructor)||void 0===_obj$constructor?void 0:_obj$constructor.name)??(null===obj?"null":typeof obj);throw new Error(`Tag not resolved for ${name} value`)}return tagObj}(ctx.doc.schema.tags,node));const props=function(node,tagObj,_ref2){let{anchors:anchors,doc:doc}=_ref2;if(!doc.directives)return"";const props=[],anchor=(isScalar(node)||isCollection(node))&&node.anchor;anchor&&anchorIsValid(anchor)&&(anchors.add(anchor),props.push(`&${anchor}`));const tag=node.tag??(tagObj.default?null:tagObj.tag);return tag&&props.push(doc.directives.tagString(tag)),props.join(" ")}(node,tagObj,ctx);props.length>0&&(ctx.indentAtStart=(ctx.indentAtStart??0)+props.length+1);const str="function"==typeof tagObj.stringify?tagObj.stringify(node,ctx,onComment,onChompKeep):isScalar(node)?stringifyString(node,ctx,onComment,onChompKeep):node.toString(ctx,onComment,onChompKeep);return props?isScalar(node)||"{"===str[0]||"["===str[0]?`${props} ${str}`:`${props}\n${ctx.indent}${str}`:str}function warn(logLevel,warning){"debug"!==logLevel&&"warn"!==logLevel||console.warn(warning)}const merge={identify:value=>"<<"===value||"symbol"==typeof value&&"<<"===value.description,default:"key",tag:"tag:yaml.org,2002:merge",test:/^<<$/,resolve:()=>Object.assign(new Scalar(Symbol("<<")),{addToJSMap:addMergeToJSMap}),stringify:()=>"<<"};function addMergeToJSMap(ctx,map,value){if(value=ctx&&isAlias(value)?value.resolve(ctx.doc):value,isSeq(value))for(const it of value.items)mergeValue(ctx,map,it);else if(Array.isArray(value))for(const it of value)mergeValue(ctx,map,it);else mergeValue(ctx,map,value)}function mergeValue(ctx,map,value){const source=ctx&&isAlias(value)?value.resolve(ctx.doc):value;if(!isMap(source))throw new Error("Merge sources must be maps or map aliases");const srcMap=source.toJSON(null,ctx,Map);for(const[key,value]of srcMap)map instanceof Map?map.has(key)||map.set(key,value):map instanceof Set?map.add(key):Object.prototype.hasOwnProperty.call(map,key)||Object.defineProperty(map,key,{value:value,writable:!0,enumerable:!0,configurable:!0});return map}function addPairToJSMap(ctx,map,_ref4){let{key:key,value:value}=_ref4;if(isNode(key)&&key.addToJSMap)key.addToJSMap(ctx,map,value);else if(((ctx,key)=>(merge.identify(key)||isScalar(key)&&(!key.type||key.type===Scalar.PLAIN)&&merge.identify(key.value))&&(null==ctx?void 0:ctx.doc.schema.tags.some((tag=>tag.tag===merge.tag&&tag.default))))(ctx,key))addMergeToJSMap(ctx,map,value);else{const jsKey=toJS(key,"",ctx);if(map instanceof Map)map.set(jsKey,toJS(value,jsKey,ctx));else if(map instanceof Set)map.add(jsKey);else{const stringKey=function(key,jsKey,ctx){if(null===jsKey)return"";if("object"!=typeof jsKey)return String(jsKey);if(isNode(key)&&null!=ctx&&ctx.doc){const strCtx=createStringifyContext(ctx.doc,{});strCtx.anchors=new Set;for(const node of ctx.anchors.keys())strCtx.anchors.add(node.anchor);strCtx.inFlow=!0,strCtx.inStringifyKey=!0;const strKey=key.toString(strCtx);if(!ctx.mapKeyWarned){let jsonStr=JSON.stringify(strKey);jsonStr.length>40&&(jsonStr=jsonStr.substring(0,36)+'..."'),warn(ctx.doc.options.logLevel,`Keys with collection values will be stringified due to JS Object restrictions: ${jsonStr}. Set mapAsMap: true to use object keys.`),ctx.mapKeyWarned=!0}return strKey}return JSON.stringify(jsKey)}(key,jsKey,ctx),jsValue=toJS(value,stringKey,ctx);stringKey in map?Object.defineProperty(map,stringKey,{value:jsValue,writable:!0,enumerable:!0,configurable:!0}):map[stringKey]=jsValue}}return map}function createPair(key,value,ctx){const k=createNode(key,void 0,ctx),v=createNode(value,void 0,ctx);return new Pair(k,v)}class Pair{constructor(key){let value=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;Object.defineProperty(this,NODE_TYPE,{value:PAIR}),this.key=key,this.value=value}clone(schema){let{key:key,value:value}=this;return isNode(key)&&(key=key.clone(schema)),isNode(value)&&(value=value.clone(schema)),new Pair(key,value)}toJSON(_,ctx){return addPairToJSMap(ctx,null!=ctx&&ctx.mapAsMap?new Map:{},this)}toString(ctx,onComment,onChompKeep){return null!=ctx&&ctx.doc?function(_ref3,ctx,onComment,onChompKeep){let{key:key,value:value}=_ref3;const{allNullValues:allNullValues,doc:doc,indent:indent,indentStep:indentStep,options:{commentString:commentString,indentSeq:indentSeq,simpleKeys:simpleKeys}}=ctx;let keyComment=isNode(key)&&key.comment||null;if(simpleKeys){if(keyComment)throw new Error("With simple keys, key nodes cannot have comments");if(isCollection(key)||!isNode(key)&&"object"==typeof key)throw new Error("With simple keys, collection cannot be used as a key value")}let explicitKey=!simpleKeys&&(!key||keyComment&&null==value&&!ctx.inFlow||isCollection(key)||(isScalar(key)?key.type===Scalar.BLOCK_FOLDED||key.type===Scalar.BLOCK_LITERAL:"object"==typeof key));ctx=Object.assign({},ctx,{allNullValues:!1,implicitKey:!explicitKey&&(simpleKeys||!allNullValues),indent:indent+indentStep});let vsb,vcb,valueComment,keyCommentDone=!1,chompKeep=!1,str=stringify$1(key,ctx,(()=>keyCommentDone=!0),(()=>chompKeep=!0));if(!explicitKey&&!ctx.inFlow&&str.length>1024){if(simpleKeys)throw new Error("With simple keys, single line scalar must not span more than 1024 characters");explicitKey=!0}if(ctx.inFlow){if(allNullValues||null==value)return keyCommentDone&&onComment&&onComment(),""===str?"?":explicitKey?`? ${str}`:str}else if(allNullValues&&!simpleKeys||null==value&&explicitKey)return str=`? ${str}`,keyComment&&!keyCommentDone?str+=lineComment(str,ctx.indent,commentString(keyComment)):chompKeep&&onChompKeep&&onChompKeep(),str;keyCommentDone&&(keyComment=null),explicitKey?(keyComment&&(str+=lineComment(str,ctx.indent,commentString(keyComment))),str=`? ${str}\n${indent}:`):(str=`${str}:`,keyComment&&(str+=lineComment(str,ctx.indent,commentString(keyComment)))),isNode(value)?(vsb=!!value.spaceBefore,vcb=value.commentBefore,valueComment=value.comment):(vsb=!1,vcb=null,valueComment=null,value&&"object"==typeof value&&(value=doc.createNode(value))),ctx.implicitKey=!1,explicitKey||keyComment||!isScalar(value)||(ctx.indentAtStart=str.length+1),chompKeep=!1,indentSeq||!(indentStep.length>=2)||ctx.inFlow||explicitKey||!isSeq(value)||value.flow||value.tag||value.anchor||(ctx.indent=ctx.indent.substring(2));let valueCommentDone=!1;const valueStr=stringify$1(value,ctx,(()=>valueCommentDone=!0),(()=>chompKeep=!0));let ws=" ";if(keyComment||vsb||vcb)ws=vsb?"\n":"",vcb&&(ws+=`\n${indentComment(commentString(vcb),ctx.indent)}`),""!==valueStr||ctx.inFlow?ws+=`\n${ctx.indent}`:"\n"===ws&&(ws="\n\n");else if(!explicitKey&&isCollection(value)){const vs0=valueStr[0],nl0=valueStr.indexOf("\n"),hasNewline=-1!==nl0,flow=ctx.inFlow??value.flow??0===value.items.length;if(hasNewline||!flow){let hasPropsLine=!1;if(hasNewline&&("&"===vs0||"!"===vs0)){let sp0=valueStr.indexOf(" ");"&"===vs0&&-1!==sp0&&sp0<nl0&&"!"===valueStr[sp0+1]&&(sp0=valueStr.indexOf(" ",sp0+1)),(-1===sp0||nl0<sp0)&&(hasPropsLine=!0)}hasPropsLine||(ws=`\n${ctx.indent}`)}}else""!==valueStr&&"\n"!==valueStr[0]||(ws="");return str+=ws+valueStr,ctx.inFlow?valueCommentDone&&onComment&&onComment():valueComment&&!valueCommentDone?str+=lineComment(str,ctx.indent,commentString(valueComment)):chompKeep&&onChompKeep&&onChompKeep(),str}(this,ctx,onComment,onChompKeep):JSON.stringify(this)}}function stringifyCollection(collection,ctx,options){return(ctx.inFlow??collection.flow?stringifyFlowCollection:stringifyBlockCollection)(collection,ctx,options)}function stringifyBlockCollection(_ref5,ctx,_ref6){let{comment:comment,items:items}=_ref5,{blockItemPrefix:blockItemPrefix,flowChars:flowChars,itemIndent:itemIndent,onChompKeep:onChompKeep,onComment:onComment}=_ref6;const{indent:indent,options:{commentString:commentString}}=ctx,itemCtx=Object.assign({},ctx,{indent:itemIndent,type:null});let chompKeep=!1;const lines=[];for(let i=0;i<items.length;++i){const item=items[i];let comment=null;if(isNode(item))!chompKeep&&item.spaceBefore&&lines.push(""),addCommentBefore(ctx,lines,item.commentBefore,chompKeep),item.comment&&(comment=item.comment);else if(isPair(item)){const ik=isNode(item.key)?item.key:null;ik&&(!chompKeep&&ik.spaceBefore&&lines.push(""),addCommentBefore(ctx,lines,ik.commentBefore,chompKeep))}chompKeep=!1;let str=stringify$1(item,itemCtx,(()=>comment=null),(()=>chompKeep=!0));comment&&(str+=lineComment(str,itemIndent,commentString(comment))),chompKeep&&comment&&(chompKeep=!1),lines.push(blockItemPrefix+str)}let str;if(0===lines.length)str=flowChars.start+flowChars.end;else{str=lines[0];for(let i=1;i<lines.length;++i){const line=lines[i];str+=line?`\n${indent}${line}`:"\n"}}return comment?(str+="\n"+indentComment(commentString(comment),indent),onComment&&onComment()):chompKeep&&onChompKeep&&onChompKeep(),str}function stringifyFlowCollection(_ref7,ctx,_ref8){let{items:items}=_ref7,{flowChars:flowChars,itemIndent:itemIndent}=_ref8;const{indent:indent,indentStep:indentStep,flowCollectionPadding:fcPadding,options:{commentString:commentString}}=ctx;itemIndent+=indentStep;const itemCtx=Object.assign({},ctx,{indent:itemIndent,inFlow:!0,type:null});let reqNewline=!1,linesAtValue=0;const lines=[];for(let i=0;i<items.length;++i){const item=items[i];let comment=null;if(isNode(item))item.spaceBefore&&lines.push(""),addCommentBefore(ctx,lines,item.commentBefore,!1),item.comment&&(comment=item.comment);else if(isPair(item)){const ik=isNode(item.key)?item.key:null;ik&&(ik.spaceBefore&&lines.push(""),addCommentBefore(ctx,lines,ik.commentBefore,!1),ik.comment&&(reqNewline=!0));const iv=isNode(item.value)?item.value:null;iv?(iv.comment&&(comment=iv.comment),iv.commentBefore&&(reqNewline=!0)):null==item.value&&null!=ik&&ik.comment&&(comment=ik.comment)}comment&&(reqNewline=!0);let str=stringify$1(item,itemCtx,(()=>comment=null));i<items.length-1&&(str+=","),comment&&(str+=lineComment(str,itemIndent,commentString(comment))),!reqNewline&&(lines.length>linesAtValue||str.includes("\n"))&&(reqNewline=!0),lines.push(str),linesAtValue=lines.length}const{start:start,end:end}=flowChars;if(0===lines.length)return start+end;if(!reqNewline){const len=lines.reduce(((sum,line)=>sum+line.length+2),2);reqNewline=ctx.options.lineWidth>0&&len>ctx.options.lineWidth}if(reqNewline){let str=start;for(const line of lines)str+=line?`\n${indentStep}${indent}${line}`:"\n";return`${str}\n${indent}${end}`}return`${start}${fcPadding}${lines.join(" ")}${fcPadding}${end}`}function addCommentBefore(_ref9,lines,comment,chompKeep){let{indent:indent,options:{commentString:commentString}}=_ref9;if(comment&&chompKeep&&(comment=comment.replace(/^\n+/,"")),comment){const ic=indentComment(commentString(comment),indent);lines.push(ic.trimStart())}}function findPair(items,key){const k=isScalar(key)?key.value:key;for(const it of items)if(isPair(it)){if(it.key===key||it.key===k)return it;if(isScalar(it.key)&&it.key.value===k)return it}}class YAMLMap extends Collection{static get tagName(){return"tag:yaml.org,2002:map"}constructor(schema){super(MAP,schema),this.items=[]}static from(schema,obj,ctx){const{keepUndefined:keepUndefined,replacer:replacer}=ctx,map=new this(schema),add=(key,value)=>{if("function"==typeof replacer)value=replacer.call(obj,key,value);else if(Array.isArray(replacer)&&!replacer.includes(key))return;(void 0!==value||keepUndefined)&&map.items.push(createPair(key,value,ctx))};if(obj instanceof Map)for(const[key,value]of obj)add(key,value);else if(obj&&"object"==typeof obj)for(const key of Object.keys(obj))add(key,obj[key]);return"function"==typeof schema.sortMapEntries&&map.items.sort(schema.sortMapEntries),map}add(pair,overwrite){var _this$schema;let _pair;_pair=isPair(pair)?pair:pair&&"object"==typeof pair&&"key"in pair?new Pair(pair.key,pair.value):new Pair(pair,null==pair?void 0:pair.value);const prev=findPair(this.items,_pair.key),sortEntries=null===(_this$schema=this.schema)||void 0===_this$schema?void 0:_this$schema.sortMapEntries;if(prev){if(!overwrite)throw new Error(`Key ${_pair.key} already set`);isScalar(prev.value)&&isScalarValue(_pair.value)?prev.value.value=_pair.value:prev.value=_pair.value}else if(sortEntries){const i=this.items.findIndex((item=>sortEntries(_pair,item)<0));-1===i?this.items.push(_pair):this.items.splice(i,0,_pair)}else this.items.push(_pair)}delete(key){const it=findPair(this.items,key);if(!it)return!1;return this.items.splice(this.items.indexOf(it),1).length>0}get(key,keepScalar){const it=findPair(this.items,key),node=null==it?void 0:it.value;return(!keepScalar&&isScalar(node)?node.value:node)??void 0}has(key){return!!findPair(this.items,key)}set(key,value){this.add(new Pair(key,value),!0)}toJSON(_,ctx,Type){const map=Type?new Type:null!=ctx&&ctx.mapAsMap?new Map:{};null!=ctx&&ctx.onCreate&&ctx.onCreate(map);for(const item of this.items)addPairToJSMap(ctx,map,item);return map}toString(ctx,onComment,onChompKeep){if(!ctx)return JSON.stringify(this);for(const item of this.items)if(!isPair(item))throw new Error(`Map items must all be pairs; found ${JSON.stringify(item)} instead`);return!ctx.allNullValues&&this.hasAllNullValues(!1)&&(ctx=Object.assign({},ctx,{allNullValues:!0})),stringifyCollection(this,ctx,{blockItemPrefix:"",flowChars:{start:"{",end:"}"},itemIndent:ctx.indent||"",onChompKeep:onChompKeep,onComment:onComment})}}const map={collection:"map",default:!0,nodeClass:YAMLMap,tag:"tag:yaml.org,2002:map",resolve:(map,onError)=>(isMap(map)||onError("Expected a mapping for this tag"),map),createNode:(schema,obj,ctx)=>YAMLMap.from(schema,obj,ctx)};class YAMLSeq extends Collection{static get tagName(){return"tag:yaml.org,2002:seq"}constructor(schema){super(SEQ,schema),this.items=[]}add(value){this.items.push(value)}delete(key){const idx=asItemIndex(key);if("number"!=typeof idx)return!1;return this.items.splice(idx,1).length>0}get(key,keepScalar){const idx=asItemIndex(key);if("number"!=typeof idx)return;const it=this.items[idx];return!keepScalar&&isScalar(it)?it.value:it}has(key){const idx=asItemIndex(key);return"number"==typeof idx&&idx<this.items.length}set(key,value){const idx=asItemIndex(key);if("number"!=typeof idx)throw new Error(`Expected a valid index, not ${key}.`);const prev=this.items[idx];isScalar(prev)&&isScalarValue(value)?prev.value=value:this.items[idx]=value}toJSON(_,ctx){const seq=[];null!=ctx&&ctx.onCreate&&ctx.onCreate(seq);let i=0;for(const item of this.items)seq.push(toJS(item,String(i++),ctx));return seq}toString(ctx,onComment,onChompKeep){return ctx?stringifyCollection(this,ctx,{blockItemPrefix:"- ",flowChars:{start:"[",end:"]"},itemIndent:(ctx.indent||"")+"  ",onChompKeep:onChompKeep,onComment:onComment}):JSON.stringify(this)}static from(schema,obj,ctx){const{replacer:replacer}=ctx,seq=new this(schema);if(obj&&Symbol.iterator in Object(obj)){let i=0;for(let it of obj){if("function"==typeof replacer){const key=obj instanceof Set?it:String(i++);it=replacer.call(obj,key,it)}seq.items.push(createNode(it,void 0,ctx))}}return seq}}function asItemIndex(key){let idx=isScalar(key)?key.value:key;return idx&&"string"==typeof idx&&(idx=Number(idx)),"number"==typeof idx&&Number.isInteger(idx)&&idx>=0?idx:null}const seq={collection:"seq",default:!0,nodeClass:YAMLSeq,tag:"tag:yaml.org,2002:seq",resolve:(seq,onError)=>(isSeq(seq)||onError("Expected a sequence for this tag"),seq),createNode:(schema,obj,ctx)=>YAMLSeq.from(schema,obj,ctx)},string={identify:value=>"string"==typeof value,default:!0,tag:"tag:yaml.org,2002:str",resolve:str=>str,stringify:(item,ctx,onComment,onChompKeep)=>stringifyString(item,ctx=Object.assign({actualString:!0},ctx),onComment,onChompKeep)},nullTag={identify:value=>null==value,createNode:()=>new Scalar(null),default:!0,tag:"tag:yaml.org,2002:null",test:/^(?:~|[Nn]ull|NULL)?$/,resolve:()=>new Scalar(null),stringify:(_ref10,ctx)=>{let{source:source}=_ref10;return"string"==typeof source&&nullTag.test.test(source)?source:ctx.options.nullStr}},boolTag={identify:value=>"boolean"==typeof value,default:!0,tag:"tag:yaml.org,2002:bool",test:/^(?:[Tt]rue|TRUE|[Ff]alse|FALSE)$/,resolve:str=>new Scalar("t"===str[0]||"T"===str[0]),stringify(_ref11,ctx){let{source:source,value:value}=_ref11;if(source&&boolTag.test.test(source)){if(value===("t"===source[0]||"T"===source[0]))return source}return value?ctx.options.trueStr:ctx.options.falseStr}};function stringifyNumber(_ref12){let{format:format,minFractionDigits:minFractionDigits,tag:tag,value:value}=_ref12;if("bigint"==typeof value)return String(value);const num="number"==typeof value?value:Number(value);if(!isFinite(num))return isNaN(num)?".nan":num<0?"-.inf":".inf";let n=JSON.stringify(value);if(!format&&minFractionDigits&&(!tag||"tag:yaml.org,2002:float"===tag)&&/^\d/.test(n)){let i=n.indexOf(".");i<0&&(i=n.length,n+=".");let d=minFractionDigits-(n.length-i-1);for(;d-- >0;)n+="0"}return n}const floatNaN$1={identify:value=>"number"==typeof value,default:!0,tag:"tag:yaml.org,2002:float",test:/^(?:[-+]?\.(?:inf|Inf|INF)|\.nan|\.NaN|\.NAN)$/,resolve:str=>"nan"===str.slice(-3).toLowerCase()?NaN:"-"===str[0]?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,stringify:stringifyNumber},floatExp$1={identify:value=>"number"==typeof value,default:!0,tag:"tag:yaml.org,2002:float",format:"EXP",test:/^[-+]?(?:\.[0-9]+|[0-9]+(?:\.[0-9]*)?)[eE][-+]?[0-9]+$/,resolve:str=>parseFloat(str),stringify(node){const num=Number(node.value);return isFinite(num)?num.toExponential():stringifyNumber(node)}},float$1={identify:value=>"number"==typeof value,default:!0,tag:"tag:yaml.org,2002:float",test:/^[-+]?(?:\.[0-9]+|[0-9]+\.[0-9]*)$/,resolve(str){const node=new Scalar(parseFloat(str)),dot=str.indexOf(".");return-1!==dot&&"0"===str[str.length-1]&&(node.minFractionDigits=str.length-dot-1),node},stringify:stringifyNumber},intIdentify$2=value=>"bigint"==typeof value||Number.isInteger(value),intResolve$1=(str,offset,radix,_ref13)=>{let{intAsBigInt:intAsBigInt}=_ref13;return intAsBigInt?BigInt(str):parseInt(str.substring(offset),radix)};function intStringify$1(node,radix,prefix){const{value:value}=node;return intIdentify$2(value)&&value>=0?prefix+value.toString(radix):stringifyNumber(node)}const intOct$1={identify:value=>intIdentify$2(value)&&value>=0,default:!0,tag:"tag:yaml.org,2002:int",format:"OCT",test:/^0o[0-7]+$/,resolve:(str,_onError,opt)=>intResolve$1(str,2,8,opt),stringify:node=>intStringify$1(node,8,"0o")},int$1={identify:intIdentify$2,default:!0,tag:"tag:yaml.org,2002:int",test:/^[-+]?[0-9]+$/,resolve:(str,_onError,opt)=>intResolve$1(str,0,10,opt),stringify:stringifyNumber},intHex$1={identify:value=>intIdentify$2(value)&&value>=0,default:!0,tag:"tag:yaml.org,2002:int",format:"HEX",test:/^0x[0-9a-fA-F]+$/,resolve:(str,_onError,opt)=>intResolve$1(str,2,16,opt),stringify:node=>intStringify$1(node,16,"0x")},schema$2=[map,seq,string,nullTag,boolTag,intOct$1,int$1,intHex$1,floatNaN$1,floatExp$1,float$1];function intIdentify$1(value){return"bigint"==typeof value||Number.isInteger(value)}const stringifyJSON=_ref14=>{let{value:value}=_ref14;return JSON.stringify(value)},schema$1=[map,seq].concat([{identify:value=>"string"==typeof value,default:!0,tag:"tag:yaml.org,2002:str",resolve:str=>str,stringify:stringifyJSON},{identify:value=>null==value,createNode:()=>new Scalar(null),default:!0,tag:"tag:yaml.org,2002:null",test:/^null$/,resolve:()=>null,stringify:stringifyJSON},{identify:value=>"boolean"==typeof value,default:!0,tag:"tag:yaml.org,2002:bool",test:/^true$|^false$/,resolve:str=>"true"===str,stringify:stringifyJSON},{identify:intIdentify$1,default:!0,tag:"tag:yaml.org,2002:int",test:/^-?(?:0|[1-9][0-9]*)$/,resolve:(str,_onError,_ref15)=>{let{intAsBigInt:intAsBigInt}=_ref15;return intAsBigInt?BigInt(str):parseInt(str,10)},stringify:_ref16=>{let{value:value}=_ref16;return intIdentify$1(value)?value.toString():JSON.stringify(value)}},{identify:value=>"number"==typeof value,default:!0,tag:"tag:yaml.org,2002:float",test:/^-?(?:0|[1-9][0-9]*)(?:\.[0-9]*)?(?:[eE][-+]?[0-9]+)?$/,resolve:str=>parseFloat(str),stringify:stringifyJSON}],{default:!0,tag:"",test:/^/,resolve:(str,onError)=>(onError(`Unresolved plain scalar ${JSON.stringify(str)}`),str)}),binary={identify:value=>value instanceof Uint8Array,default:!1,tag:"tag:yaml.org,2002:binary",resolve(src,onError){if("function"==typeof atob){const str=atob(src.replace(/[\n\r]/g,"")),buffer=new Uint8Array(str.length);for(let i=0;i<str.length;++i)buffer[i]=str.charCodeAt(i);return buffer}return onError("This environment does not support reading binary tags; either Buffer or atob is required"),src},stringify(_ref17,ctx,onComment,onChompKeep){let{comment:comment,type:type,value:value}=_ref17;if(!value)return"";const buf=value;let str;if("function"!=typeof btoa)throw new Error("This environment does not support writing binary tags; either Buffer or btoa is required");{let s="";for(let i=0;i<buf.length;++i)s+=String.fromCharCode(buf[i]);str=btoa(s)}if(type??(type=Scalar.BLOCK_LITERAL),type!==Scalar.QUOTE_DOUBLE){const lineWidth=Math.max(ctx.options.lineWidth-ctx.indent.length,ctx.options.minContentWidth),n=Math.ceil(str.length/lineWidth),lines=new Array(n);for(let i=0,o=0;i<n;++i,o+=lineWidth)lines[i]=str.substr(o,lineWidth);str=lines.join(type===Scalar.BLOCK_LITERAL?"\n":" ")}return stringifyString({comment:comment,type:type,value:str},ctx,onComment,onChompKeep)}};function resolvePairs(seq,onError){if(isSeq(seq))for(let i=0;i<seq.items.length;++i){let item=seq.items[i];if(!isPair(item)){if(isMap(item)){item.items.length>1&&onError("Each pair must have its own sequence indicator");const pair=item.items[0]||new Pair(new Scalar(null));if(item.commentBefore&&(pair.key.commentBefore=pair.key.commentBefore?`${item.commentBefore}\n${pair.key.commentBefore}`:item.commentBefore),item.comment){const cn=pair.value??pair.key;cn.comment=cn.comment?`${item.comment}\n${cn.comment}`:item.comment}item=pair}seq.items[i]=isPair(item)?item:new Pair(item)}}else onError("Expected a sequence for this tag");return seq}function createPairs(schema,iterable,ctx){const{replacer:replacer}=ctx,pairs=new YAMLSeq(schema);pairs.tag="tag:yaml.org,2002:pairs";let i=0;if(iterable&&Symbol.iterator in Object(iterable))for(let it of iterable){let key,value;if("function"==typeof replacer&&(it=replacer.call(iterable,String(i++),it)),Array.isArray(it)){if(2!==it.length)throw new TypeError(`Expected [key, value] tuple: ${it}`);key=it[0],value=it[1]}else if(it&&it instanceof Object){const keys=Object.keys(it);if(1!==keys.length)throw new TypeError(`Expected tuple with one key, not ${keys.length} keys`);key=keys[0],value=it[key]}else key=it;pairs.items.push(createPair(key,value,ctx))}return pairs}const pairs={collection:"seq",default:!1,tag:"tag:yaml.org,2002:pairs",resolve:resolvePairs,createNode:createPairs};class YAMLOMap extends YAMLSeq{constructor(){super(),this.add=YAMLMap.prototype.add.bind(this),this.delete=YAMLMap.prototype.delete.bind(this),this.get=YAMLMap.prototype.get.bind(this),this.has=YAMLMap.prototype.has.bind(this),this.set=YAMLMap.prototype.set.bind(this),this.tag=YAMLOMap.tag}toJSON(_,ctx){if(!ctx)return super.toJSON(_);const map=new Map;null!=ctx&&ctx.onCreate&&ctx.onCreate(map);for(const pair of this.items){let key,value;if(isPair(pair)?(key=toJS(pair.key,"",ctx),value=toJS(pair.value,key,ctx)):key=toJS(pair,"",ctx),map.has(key))throw new Error("Ordered maps must not include duplicate keys");map.set(key,value)}return map}static from(schema,iterable,ctx){const pairs=createPairs(schema,iterable,ctx),omap=new this;return omap.items=pairs.items,omap}}YAMLOMap.tag="tag:yaml.org,2002:omap";const omap={collection:"seq",identify:value=>value instanceof Map,nodeClass:YAMLOMap,default:!1,tag:"tag:yaml.org,2002:omap",resolve(seq,onError){const pairs=resolvePairs(seq,onError),seenKeys=[];for(const{key:key}of pairs.items)isScalar(key)&&(seenKeys.includes(key.value)?onError(`Ordered maps must not include duplicate keys: ${key.value}`):seenKeys.push(key.value));return Object.assign(new YAMLOMap,pairs)},createNode:(schema,iterable,ctx)=>YAMLOMap.from(schema,iterable,ctx)};function boolStringify(_ref18,ctx){let{value:value,source:source}=_ref18;return source&&(value?trueTag:falseTag).test.test(source)?source:value?ctx.options.trueStr:ctx.options.falseStr}const trueTag={identify:value=>!0===value,default:!0,tag:"tag:yaml.org,2002:bool",test:/^(?:Y|y|[Yy]es|YES|[Tt]rue|TRUE|[Oo]n|ON)$/,resolve:()=>new Scalar(!0),stringify:boolStringify},falseTag={identify:value=>!1===value,default:!0,tag:"tag:yaml.org,2002:bool",test:/^(?:N|n|[Nn]o|NO|[Ff]alse|FALSE|[Oo]ff|OFF)$/,resolve:()=>new Scalar(!1),stringify:boolStringify},floatNaN={identify:value=>"number"==typeof value,default:!0,tag:"tag:yaml.org,2002:float",test:/^(?:[-+]?\.(?:inf|Inf|INF)|\.nan|\.NaN|\.NAN)$/,resolve:str=>"nan"===str.slice(-3).toLowerCase()?NaN:"-"===str[0]?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,stringify:stringifyNumber},floatExp={identify:value=>"number"==typeof value,default:!0,tag:"tag:yaml.org,2002:float",format:"EXP",test:/^[-+]?(?:[0-9][0-9_]*)?(?:\.[0-9_]*)?[eE][-+]?[0-9]+$/,resolve:str=>parseFloat(str.replace(/_/g,"")),stringify(node){const num=Number(node.value);return isFinite(num)?num.toExponential():stringifyNumber(node)}},float={identify:value=>"number"==typeof value,default:!0,tag:"tag:yaml.org,2002:float",test:/^[-+]?(?:[0-9][0-9_]*)?\.[0-9_]*$/,resolve(str){const node=new Scalar(parseFloat(str.replace(/_/g,""))),dot=str.indexOf(".");if(-1!==dot){const f=str.substring(dot+1).replace(/_/g,"");"0"===f[f.length-1]&&(node.minFractionDigits=f.length)}return node},stringify:stringifyNumber},intIdentify=value=>"bigint"==typeof value||Number.isInteger(value);function intResolve(str,offset,radix,_ref19){let{intAsBigInt:intAsBigInt}=_ref19;const sign=str[0];if("-"!==sign&&"+"!==sign||(offset+=1),str=str.substring(offset).replace(/_/g,""),intAsBigInt){switch(radix){case 2:str=`0b${str}`;break;case 8:str=`0o${str}`;break;case 16:str=`0x${str}`}const n=BigInt(str);return"-"===sign?BigInt(-1)*n:n}const n=parseInt(str,radix);return"-"===sign?-1*n:n}function intStringify(node,radix,prefix){const{value:value}=node;if(intIdentify(value)){const str=value.toString(radix);return value<0?"-"+prefix+str.substr(1):prefix+str}return stringifyNumber(node)}const intBin={identify:intIdentify,default:!0,tag:"tag:yaml.org,2002:int",format:"BIN",test:/^[-+]?0b[0-1_]+$/,resolve:(str,_onError,opt)=>intResolve(str,2,2,opt),stringify:node=>intStringify(node,2,"0b")},intOct={identify:intIdentify,default:!0,tag:"tag:yaml.org,2002:int",format:"OCT",test:/^[-+]?0[0-7_]+$/,resolve:(str,_onError,opt)=>intResolve(str,1,8,opt),stringify:node=>intStringify(node,8,"0")},int={identify:intIdentify,default:!0,tag:"tag:yaml.org,2002:int",test:/^[-+]?[0-9][0-9_]*$/,resolve:(str,_onError,opt)=>intResolve(str,0,10,opt),stringify:stringifyNumber},intHex={identify:intIdentify,default:!0,tag:"tag:yaml.org,2002:int",format:"HEX",test:/^[-+]?0x[0-9a-fA-F_]+$/,resolve:(str,_onError,opt)=>intResolve(str,2,16,opt),stringify:node=>intStringify(node,16,"0x")};class YAMLSet extends YAMLMap{constructor(schema){super(schema),this.tag=YAMLSet.tag}add(key){let pair;pair=isPair(key)?key:key&&"object"==typeof key&&"key"in key&&"value"in key&&null===key.value?new Pair(key.key,null):new Pair(key,null);findPair(this.items,pair.key)||this.items.push(pair)}get(key,keepPair){const pair=findPair(this.items,key);return!keepPair&&isPair(pair)?isScalar(pair.key)?pair.key.value:pair.key:pair}set(key,value){if("boolean"!=typeof value)throw new Error("Expected boolean value for set(key, value) in a YAML set, not "+typeof value);const prev=findPair(this.items,key);prev&&!value?this.items.splice(this.items.indexOf(prev),1):!prev&&value&&this.items.push(new Pair(key))}toJSON(_,ctx){return super.toJSON(_,ctx,Set)}toString(ctx,onComment,onChompKeep){if(!ctx)return JSON.stringify(this);if(this.hasAllNullValues(!0))return super.toString(Object.assign({},ctx,{allNullValues:!0}),onComment,onChompKeep);throw new Error("Set items must all have null values")}static from(schema,iterable,ctx){const{replacer:replacer}=ctx,set=new this(schema);if(iterable&&Symbol.iterator in Object(iterable))for(let value of iterable)"function"==typeof replacer&&(value=replacer.call(iterable,value,value)),set.items.push(createPair(value,null,ctx));return set}}YAMLSet.tag="tag:yaml.org,2002:set";const set={collection:"map",identify:value=>value instanceof Set,nodeClass:YAMLSet,default:!1,tag:"tag:yaml.org,2002:set",createNode:(schema,iterable,ctx)=>YAMLSet.from(schema,iterable,ctx),resolve(map,onError){if(isMap(map)){if(map.hasAllNullValues(!0))return Object.assign(new YAMLSet,map);onError("Set items must all have null values")}else onError("Expected a mapping for this tag");return map}};function parseSexagesimal(str,asBigInt){const sign=str[0],parts="-"===sign||"+"===sign?str.substring(1):str,num=n=>asBigInt?BigInt(n):Number(n),res=parts.replace(/_/g,"").split(":").reduce(((res,p)=>res*num(60)+num(p)),num(0));return"-"===sign?num(-1)*res:res}function stringifySexagesimal(node){let{value:value}=node,num=n=>n;if("bigint"==typeof value)num=n=>BigInt(n);else if(isNaN(value)||!isFinite(value))return stringifyNumber(node);let sign="";value<0&&(sign="-",value*=num(-1));const _60=num(60),parts=[value%_60];return value<60?parts.unshift(0):(value=(value-parts[0])/_60,parts.unshift(value%_60),value>=60&&(value=(value-parts[0])/_60,parts.unshift(value))),sign+parts.map((n=>String(n).padStart(2,"0"))).join(":").replace(/000000\d*$/,"")}const intTime={identify:value=>"bigint"==typeof value||Number.isInteger(value),default:!0,tag:"tag:yaml.org,2002:int",format:"TIME",test:/^[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+$/,resolve:(str,_onError,_ref20)=>{let{intAsBigInt:intAsBigInt}=_ref20;return parseSexagesimal(str,intAsBigInt)},stringify:stringifySexagesimal},floatTime={identify:value=>"number"==typeof value,default:!0,tag:"tag:yaml.org,2002:float",format:"TIME",test:/^[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\.[0-9_]*$/,resolve:str=>parseSexagesimal(str,!1),stringify:stringifySexagesimal},timestamp={identify:value=>value instanceof Date,default:!0,tag:"tag:yaml.org,2002:timestamp",test:RegExp("^([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})(?:(?:t|T|[ \\t]+)([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2}(\\.[0-9]+)?)(?:[ \\t]*(Z|[-+][012]?[0-9](?::[0-9]{2})?))?)?$"),resolve(str){const match=str.match(timestamp.test);if(!match)throw new Error("!!timestamp expects a date, starting with yyyy-mm-dd");const[,year,month,day,hour,minute,second]=match.map(Number),millisec=match[7]?Number((match[7]+"00").substr(1,3)):0;let date=Date.UTC(year,month-1,day,hour||0,minute||0,second||0,millisec);const tz=match[8];if(tz&&"Z"!==tz){let d=parseSexagesimal(tz,!1);Math.abs(d)<30&&(d*=60),date-=6e4*d}return new Date(date)},stringify:_ref21=>{let{value:value}=_ref21;return(null==value?void 0:value.toISOString().replace(/(T00:00:00)?\.000Z$/,""))??""}},schema=[map,seq,string,nullTag,trueTag,falseTag,intBin,intOct,int,intHex,floatNaN,floatExp,float,binary,merge,omap,pairs,set,intTime,floatTime,timestamp],schemas=new Map([["core",schema$2],["failsafe",[map,seq,string]],["json",schema$1],["yaml11",schema],["yaml-1.1",schema]]),tagsByName={binary:binary,bool:boolTag,float:float$1,floatExp:floatExp$1,floatNaN:floatNaN$1,floatTime:floatTime,int:int$1,intHex:intHex$1,intOct:intOct$1,intTime:intTime,map:map,merge:merge,null:nullTag,omap:omap,pairs:pairs,seq:seq,set:set,timestamp:timestamp},coreKnownTags={"tag:yaml.org,2002:binary":binary,"tag:yaml.org,2002:merge":merge,"tag:yaml.org,2002:omap":omap,"tag:yaml.org,2002:pairs":pairs,"tag:yaml.org,2002:set":set,"tag:yaml.org,2002:timestamp":timestamp};function getTags(customTags,schemaName,addMergeTag){const schemaTags=schemas.get(schemaName);if(schemaTags&&!customTags)return addMergeTag&&!schemaTags.includes(merge)?schemaTags.concat(merge):schemaTags.slice();let tags=schemaTags;if(!tags){if(!Array.isArray(customTags)){const keys=Array.from(schemas.keys()).filter((key=>"yaml11"!==key)).map((key=>JSON.stringify(key))).join(", ");throw new Error(`Unknown schema "${schemaName}"; use one of ${keys} or define customTags array`)}tags=[]}if(Array.isArray(customTags))for(const tag of customTags)tags=tags.concat(tag);else"function"==typeof customTags&&(tags=customTags(tags.slice()));return addMergeTag&&(tags=tags.concat(merge)),tags.reduce(((tags,tag)=>{const tagObj="string"==typeof tag?tagsByName[tag]:tag;if(!tagObj){const tagName=JSON.stringify(tag),keys=Object.keys(tagsByName).map((key=>JSON.stringify(key))).join(", ");throw new Error(`Unknown custom tag ${tagName}; use one of ${keys}`)}return tags.includes(tagObj)||tags.push(tagObj),tags}),[])}const sortMapEntriesByKey=(a,b)=>a.key<b.key?-1:a.key>b.key?1:0;class Schema{constructor(_ref22){let{compat:compat,customTags:customTags,merge:merge,resolveKnownTags:resolveKnownTags,schema:schema,sortMapEntries:sortMapEntries,toStringDefaults:toStringDefaults}=_ref22;this.compat=Array.isArray(compat)?getTags(compat,"compat"):compat?getTags(null,compat):null,this.name="string"==typeof schema&&schema||"core",this.knownTags=resolveKnownTags?coreKnownTags:{},this.tags=getTags(customTags,this.name,merge),this.toStringOptions=toStringDefaults??null,Object.defineProperty(this,MAP,{value:map}),Object.defineProperty(this,SCALAR$1,{value:string}),Object.defineProperty(this,SEQ,{value:seq}),this.sortMapEntries="function"==typeof sortMapEntries?sortMapEntries:!0===sortMapEntries?sortMapEntriesByKey:null}clone(){const copy=Object.create(Schema.prototype,Object.getOwnPropertyDescriptors(this));return copy.tags=this.tags.slice(),copy}}class Document{constructor(value,replacer,options){var _options;this.commentBefore=null,this.comment=null,this.errors=[],this.warnings=[],Object.defineProperty(this,NODE_TYPE,{value:DOC});let _replacer=null;"function"==typeof replacer||Array.isArray(replacer)?_replacer=replacer:void 0===options&&replacer&&(options=replacer,replacer=void 0);const opt=Object.assign({intAsBigInt:!1,keepSourceTokens:!1,logLevel:"warn",prettyErrors:!0,strict:!0,stringKeys:!1,uniqueKeys:!0,version:"1.2"},options);this.options=opt;let{version:version}=opt;null!==(_options=options)&&void 0!==_options&&_options._directives?(this.directives=options._directives.atDocument(),this.directives.yaml.explicit&&(version=this.directives.yaml.version)):this.directives=new Directives({version:version}),this.setSchema(version,options),this.contents=void 0===value?null:this.createNode(value,_replacer,options)}clone(){const copy=Object.create(Document.prototype,{[NODE_TYPE]:{value:DOC}});return copy.commentBefore=this.commentBefore,copy.comment=this.comment,copy.errors=this.errors.slice(),copy.warnings=this.warnings.slice(),copy.options=Object.assign({},this.options),this.directives&&(copy.directives=this.directives.clone()),copy.schema=this.schema.clone(),copy.contents=isNode(this.contents)?this.contents.clone(copy.schema):this.contents,this.range&&(copy.range=this.range.slice()),copy}add(value){assertCollection(this.contents)&&this.contents.add(value)}addIn(path,value){assertCollection(this.contents)&&this.contents.addIn(path,value)}createAlias(node,name){if(!node.anchor){const prev=anchorNames(this);node.anchor=!name||prev.has(name)?findNewAnchor(name||"a",prev):name}return new Alias(node.anchor)}createNode(value,replacer,options){let _replacer;if("function"==typeof replacer)value=replacer.call({"":value},"",value),_replacer=replacer;else if(Array.isArray(replacer)){const keyToStr=v=>"number"==typeof v||v instanceof String||v instanceof Number,asStr=replacer.filter(keyToStr).map(String);asStr.length>0&&(replacer=replacer.concat(asStr)),_replacer=replacer}else void 0===options&&replacer&&(options=replacer,replacer=void 0);const{aliasDuplicateObjects:aliasDuplicateObjects,anchorPrefix:anchorPrefix,flow:flow,keepUndefined:keepUndefined,onTagObj:onTagObj,tag:tag}=options??{},{onAnchor:onAnchor,setAnchors:setAnchors,sourceObjects:sourceObjects}=function(doc,prefix){const aliasObjects=[],sourceObjects=new Map;let prevAnchors=null;return{onAnchor:source=>{aliasObjects.push(source),prevAnchors??(prevAnchors=anchorNames(doc));const anchor=findNewAnchor(prefix,prevAnchors);return prevAnchors.add(anchor),anchor},setAnchors:()=>{for(const source of aliasObjects){const ref=sourceObjects.get(source);if("object"!=typeof ref||!ref.anchor||!isScalar(ref.node)&&!isCollection(ref.node)){const error=new Error("Failed to resolve repeated object (this should not happen)");throw error.source=source,error}ref.node.anchor=ref.anchor}},sourceObjects:sourceObjects}}(this,anchorPrefix||"a"),node=createNode(value,tag,{aliasDuplicateObjects:aliasDuplicateObjects??!0,keepUndefined:keepUndefined??!1,onAnchor:onAnchor,onTagObj:onTagObj,replacer:_replacer,schema:this.schema,sourceObjects:sourceObjects});return flow&&isCollection(node)&&(node.flow=!0),setAnchors(),node}createPair(key,value){let options=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const k=this.createNode(key,null,options),v=this.createNode(value,null,options);return new Pair(k,v)}delete(key){return!!assertCollection(this.contents)&&this.contents.delete(key)}deleteIn(path){return isEmptyPath(path)?null!=this.contents&&(this.contents=null,!0):!!assertCollection(this.contents)&&this.contents.deleteIn(path)}get(key,keepScalar){return isCollection(this.contents)?this.contents.get(key,keepScalar):void 0}getIn(path,keepScalar){return isEmptyPath(path)?!keepScalar&&isScalar(this.contents)?this.contents.value:this.contents:isCollection(this.contents)?this.contents.getIn(path,keepScalar):void 0}has(key){return!!isCollection(this.contents)&&this.contents.has(key)}hasIn(path){return isEmptyPath(path)?void 0!==this.contents:!!isCollection(this.contents)&&this.contents.hasIn(path)}set(key,value){null==this.contents?this.contents=collectionFromPath(this.schema,[key],value):assertCollection(this.contents)&&this.contents.set(key,value)}setIn(path,value){isEmptyPath(path)?this.contents=value:null==this.contents?this.contents=collectionFromPath(this.schema,Array.from(path),value):assertCollection(this.contents)&&this.contents.setIn(path,value)}setSchema(version){let opt,options=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};switch("number"==typeof version&&(version=String(version)),version){case"1.1":this.directives?this.directives.yaml.version="1.1":this.directives=new Directives({version:"1.1"}),opt={resolveKnownTags:!1,schema:"yaml-1.1"};break;case"1.2":case"next":this.directives?this.directives.yaml.version=version:this.directives=new Directives({version:version}),opt={resolveKnownTags:!0,schema:"core"};break;case null:this.directives&&delete this.directives,opt=null;break;default:{const sv=JSON.stringify(version);throw new Error(`Expected '1.1', '1.2' or null as first argument, but found: ${sv}`)}}if(options.schema instanceof Object)this.schema=options.schema;else{if(!opt)throw new Error("With a null YAML version, the { schema: Schema } option is required");this.schema=new Schema(Object.assign(opt,options))}}toJS(){let{json:json,jsonArg:jsonArg,mapAsMap:mapAsMap,maxAliasCount:maxAliasCount,onAnchor:onAnchor,reviver:reviver}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const ctx={anchors:new Map,doc:this,keep:!json,mapAsMap:!0===mapAsMap,mapKeyWarned:!1,maxAliasCount:"number"==typeof maxAliasCount?maxAliasCount:100},res=toJS(this.contents,jsonArg??"",ctx);if("function"==typeof onAnchor)for(const{count:count,res:res}of ctx.anchors.values())onAnchor(res,count);return"function"==typeof reviver?applyReviver(reviver,{"":res},"",res):res}toJSON(jsonArg,onAnchor){return this.toJS({json:!0,jsonArg:jsonArg,mapAsMap:!1,onAnchor:onAnchor})}toString(){let options=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if(this.errors.length>0)throw new Error("Document with errors cannot be stringified");if("indent"in options&&(!Number.isInteger(options.indent)||Number(options.indent)<=0)){const s=JSON.stringify(options.indent);throw new Error(`"indent" option must be a positive integer, not ${s}`)}return function(doc,options){var _doc$directives;const lines=[];let hasDirectives=!0===options.directives;if(!1!==options.directives&&doc.directives){const dir=doc.directives.toString(doc);dir?(lines.push(dir),hasDirectives=!0):doc.directives.docStart&&(hasDirectives=!0)}hasDirectives&&lines.push("---");const ctx=createStringifyContext(doc,options),{commentString:commentString}=ctx.options;if(doc.commentBefore){1!==lines.length&&lines.unshift("");const cs=commentString(doc.commentBefore);lines.unshift(indentComment(cs,""))}let chompKeep=!1,contentComment=null;if(doc.contents){if(isNode(doc.contents)){if(doc.contents.spaceBefore&&hasDirectives&&lines.push(""),doc.contents.commentBefore){const cs=commentString(doc.contents.commentBefore);lines.push(indentComment(cs,""))}ctx.forceBlockIndent=!!doc.comment,contentComment=doc.contents.comment}const onChompKeep=contentComment?void 0:()=>chompKeep=!0;let body=stringify$1(doc.contents,ctx,(()=>contentComment=null),onChompKeep);contentComment&&(body+=lineComment(body,"",commentString(contentComment))),"|"!==body[0]&&">"!==body[0]||"---"!==lines[lines.length-1]?lines.push(body):lines[lines.length-1]=`--- ${body}`}else lines.push(stringify$1(doc.contents,ctx));if(null!==(_doc$directives=doc.directives)&&void 0!==_doc$directives&&_doc$directives.docEnd)if(doc.comment){const cs=commentString(doc.comment);cs.includes("\n")?(lines.push("..."),lines.push(indentComment(cs,""))):lines.push(`... ${cs}`)}else lines.push("...");else{let dc=doc.comment;dc&&chompKeep&&(dc=dc.replace(/^\n+/,"")),dc&&(chompKeep&&!contentComment||""===lines[lines.length-1]||lines.push(""),lines.push(indentComment(commentString(dc),"")))}return lines.join("\n")+"\n"}(this,options)}}function assertCollection(contents){if(isCollection(contents))return!0;throw new Error("Expected a YAML collection as document contents")}class YAMLError extends Error{constructor(name,pos,code,message){super(),this.name=name,this.code=code,this.message=message,this.pos=pos}}class YAMLParseError extends YAMLError{constructor(pos,code,message){super("YAMLParseError",pos,code,message)}}class YAMLWarning extends YAMLError{constructor(pos,code,message){super("YAMLWarning",pos,code,message)}}const prettifyError=(src,lc)=>error=>{if(-1===error.pos[0])return;error.linePos=error.pos.map((pos=>lc.linePos(pos)));const{line:line,col:col}=error.linePos[0];error.message+=` at line ${line}, column ${col}`;let ci=col-1,lineStr=src.substring(lc.lineStarts[line-1],lc.lineStarts[line]).replace(/[\n\r]+$/,"");if(ci>=60&&lineStr.length>80){const trimStart=Math.min(ci-39,lineStr.length-79);lineStr="…"+lineStr.substring(trimStart),ci-=trimStart-1}if(lineStr.length>80&&(lineStr=lineStr.substring(0,79)+"…"),line>1&&/^ *$/.test(lineStr.substring(0,ci))){let prev=src.substring(lc.lineStarts[line-2],lc.lineStarts[line-1]);prev.length>80&&(prev=prev.substring(0,79)+"…\n"),lineStr=prev+lineStr}if(/[^ ]/.test(lineStr)){let count=1;const end=error.linePos[1];end&&end.line===line&&end.col>col&&(count=Math.max(1,Math.min(end.col-col,80-ci)));const pointer=" ".repeat(ci)+"^".repeat(count);error.message+=`:\n\n${lineStr}\n${pointer}\n`}};function resolveProps(tokens,_ref23){let{flow:flow,indicator:indicator,next:next,offset:offset,onError:onError,parentIndent:parentIndent,startOnNewline:startOnNewline}=_ref23,spaceBefore=!1,atNewline=startOnNewline,hasSpace=startOnNewline,comment="",commentSep="",hasNewline=!1,reqSpace=!1,tab=null,anchor=null,tag=null,newlineAfterProp=null,comma=null,found=null,start=null;for(const token of tokens)switch(reqSpace&&("space"!==token.type&&"newline"!==token.type&&"comma"!==token.type&&onError(token.offset,"MISSING_CHAR","Tags and anchors must be separated from the next token by white space"),reqSpace=!1),tab&&(atNewline&&"comment"!==token.type&&"newline"!==token.type&&onError(tab,"TAB_AS_INDENT","Tabs are not allowed as indentation"),tab=null),token.type){case"space":flow||"doc-start"===indicator&&"flow-collection"===(null==next?void 0:next.type)||!token.source.includes("\t")||(tab=token),hasSpace=!0;break;case"comment":{hasSpace||onError(token,"MISSING_CHAR","Comments must be separated from other tokens by white space characters");const cb=token.source.substring(1)||" ";comment?comment+=commentSep+cb:comment=cb,commentSep="",atNewline=!1;break}case"newline":atNewline?comment?comment+=token.source:found&&"seq-item-ind"===indicator||(spaceBefore=!0):commentSep+=token.source,atNewline=!0,hasNewline=!0,(anchor||tag)&&(newlineAfterProp=token),hasSpace=!0;break;case"anchor":anchor&&onError(token,"MULTIPLE_ANCHORS","A node can have at most one anchor"),token.source.endsWith(":")&&onError(token.offset+token.source.length-1,"BAD_ALIAS","Anchor ending in : is ambiguous",!0),anchor=token,start??(start=token.offset),atNewline=!1,hasSpace=!1,reqSpace=!0;break;case"tag":tag&&onError(token,"MULTIPLE_TAGS","A node can have at most one tag"),tag=token,start??(start=token.offset),atNewline=!1,hasSpace=!1,reqSpace=!0;break;case indicator:(anchor||tag)&&onError(token,"BAD_PROP_ORDER",`Anchors and tags must be after the ${token.source} indicator`),found&&onError(token,"UNEXPECTED_TOKEN",`Unexpected ${token.source} in ${flow??"collection"}`),found=token,atNewline="seq-item-ind"===indicator||"explicit-key-ind"===indicator,hasSpace=!1;break;case"comma":if(flow){comma&&onError(token,"UNEXPECTED_TOKEN",`Unexpected , in ${flow}`),comma=token,atNewline=!1,hasSpace=!1;break}default:onError(token,"UNEXPECTED_TOKEN",`Unexpected ${token.type} token`),atNewline=!1,hasSpace=!1}const last=tokens[tokens.length-1],end=last?last.offset+last.source.length:offset;return reqSpace&&next&&"space"!==next.type&&"newline"!==next.type&&"comma"!==next.type&&("scalar"!==next.type||""!==next.source)&&onError(next.offset,"MISSING_CHAR","Tags and anchors must be separated from the next token by white space"),tab&&(atNewline&&tab.indent<=parentIndent||"block-map"===(null==next?void 0:next.type)||"block-seq"===(null==next?void 0:next.type))&&onError(tab,"TAB_AS_INDENT","Tabs are not allowed as indentation"),{comma:comma,found:found,spaceBefore:spaceBefore,comment:comment,hasNewline:hasNewline,anchor:anchor,tag:tag,newlineAfterProp:newlineAfterProp,end:end,start:start??end}}function containsNewline(key){if(!key)return null;switch(key.type){case"alias":case"scalar":case"double-quoted-scalar":case"single-quoted-scalar":if(key.source.includes("\n"))return!0;if(key.end)for(const st of key.end)if("newline"===st.type)return!0;return!1;case"flow-collection":for(const it of key.items){for(const st of it.start)if("newline"===st.type)return!0;if(it.sep)for(const st of it.sep)if("newline"===st.type)return!0;if(containsNewline(it.key)||containsNewline(it.value))return!0}return!1;default:return!0}}function flowIndentCheck(indent,fc,onError){if("flow-collection"===(null==fc?void 0:fc.type)){const end=fc.end[0];if(end.indent===indent&&("]"===end.source||"}"===end.source)&&containsNewline(fc)){onError(end,"BAD_INDENT","Flow end indicator should be more indented than parent",!0)}}}function mapIncludes(ctx,items,search){const{uniqueKeys:uniqueKeys}=ctx.options;if(!1===uniqueKeys)return!1;const isEqual="function"==typeof uniqueKeys?uniqueKeys:(a,b)=>a===b||isScalar(a)&&isScalar(b)&&a.value===b.value;return items.some((pair=>isEqual(pair.key,search)))}const startColMsg="All mapping items must start at the same column";function resolveEnd(end,offset,reqSpace,onError){let comment="";if(end){let hasSpace=!1,sep="";for(const token of end){const{source:source,type:type}=token;switch(type){case"space":hasSpace=!0;break;case"comment":{reqSpace&&!hasSpace&&onError(token,"MISSING_CHAR","Comments must be separated from other tokens by white space characters");const cb=source.substring(1)||" ";comment?comment+=sep+cb:comment=cb,sep="";break}case"newline":comment&&(sep+=source),hasSpace=!0;break;default:onError(token,"UNEXPECTED_TOKEN",`Unexpected ${type} at node end`)}offset+=source.length}}return{comment:comment,offset:offset}}const blockMsg="Block collections are not allowed within flow collections",isBlock=token=>token&&("block-map"===token.type||"block-seq"===token.type);function resolveCollection(CN,ctx,token,onError,tagName,tag){const coll="block-map"===token.type?function(_ref24,ctx,bm,onError,tag){let{composeNode:composeNode,composeEmptyNode:composeEmptyNode}=_ref24;const map=new((null==tag?void 0:tag.nodeClass)??YAMLMap)(ctx.schema);ctx.atRoot&&(ctx.atRoot=!1);let offset=bm.offset,commentEnd=null;for(const collItem of bm.items){var _keyProps$found;const{start:start,key:key,sep:sep,value:value}=collItem,keyProps=resolveProps(start,{indicator:"explicit-key-ind",next:key??(null==sep?void 0:sep[0]),offset:offset,onError:onError,parentIndent:bm.indent,startOnNewline:!0}),implicitKey=!keyProps.found;if(implicitKey){if(key&&("block-seq"===key.type?onError(offset,"BLOCK_AS_IMPLICIT_KEY","A block sequence may not be used as an implicit map key"):"indent"in key&&key.indent!==bm.indent&&onError(offset,"BAD_INDENT",startColMsg)),!keyProps.anchor&&!keyProps.tag&&!sep){commentEnd=keyProps.end,keyProps.comment&&(map.comment?map.comment+="\n"+keyProps.comment:map.comment=keyProps.comment);continue}(keyProps.newlineAfterProp||containsNewline(key))&&onError(key??start[start.length-1],"MULTILINE_IMPLICIT_KEY","Implicit keys need to be on a single line")}else(null===(_keyProps$found=keyProps.found)||void 0===_keyProps$found?void 0:_keyProps$found.indent)!==bm.indent&&onError(offset,"BAD_INDENT",startColMsg);ctx.atKey=!0;const keyStart=keyProps.end,keyNode=key?composeNode(ctx,key,keyProps,onError):composeEmptyNode(ctx,keyStart,start,null,keyProps,onError);ctx.schema.compat&&flowIndentCheck(bm.indent,key,onError),ctx.atKey=!1,mapIncludes(ctx,map.items,keyNode)&&onError(keyStart,"DUPLICATE_KEY","Map keys must be unique");const valueProps=resolveProps(sep??[],{indicator:"map-value-ind",next:value,offset:keyNode.range[2],onError:onError,parentIndent:bm.indent,startOnNewline:!key||"block-scalar"===key.type});if(offset=valueProps.end,valueProps.found){implicitKey&&("block-map"!==(null==value?void 0:value.type)||valueProps.hasNewline||onError(offset,"BLOCK_AS_IMPLICIT_KEY","Nested mappings are not allowed in compact mappings"),ctx.options.strict&&keyProps.start<valueProps.found.offset-1024&&onError(keyNode.range,"KEY_OVER_1024_CHARS","The : indicator must be at most 1024 chars after the start of an implicit block mapping key"));const valueNode=value?composeNode(ctx,value,valueProps,onError):composeEmptyNode(ctx,offset,sep,null,valueProps,onError);ctx.schema.compat&&flowIndentCheck(bm.indent,value,onError),offset=valueNode.range[2];const pair=new Pair(keyNode,valueNode);ctx.options.keepSourceTokens&&(pair.srcToken=collItem),map.items.push(pair)}else{implicitKey&&onError(keyNode.range,"MISSING_CHAR","Implicit map keys need to be followed by map values"),valueProps.comment&&(keyNode.comment?keyNode.comment+="\n"+valueProps.comment:keyNode.comment=valueProps.comment);const pair=new Pair(keyNode);ctx.options.keepSourceTokens&&(pair.srcToken=collItem),map.items.push(pair)}}return commentEnd&&commentEnd<offset&&onError(commentEnd,"IMPOSSIBLE","Map comment with trailing content"),map.range=[bm.offset,offset,commentEnd??offset],map}(CN,ctx,token,onError,tag):"block-seq"===token.type?function(_ref25,ctx,bs,onError,tag){let{composeNode:composeNode,composeEmptyNode:composeEmptyNode}=_ref25;const seq=new((null==tag?void 0:tag.nodeClass)??YAMLSeq)(ctx.schema);ctx.atRoot&&(ctx.atRoot=!1),ctx.atKey&&(ctx.atKey=!1);let offset=bs.offset,commentEnd=null;for(const{start:start,value:value}of bs.items){const props=resolveProps(start,{indicator:"seq-item-ind",next:value,offset:offset,onError:onError,parentIndent:bs.indent,startOnNewline:!0});if(!props.found){if(!(props.anchor||props.tag||value)){commentEnd=props.end,props.comment&&(seq.comment=props.comment);continue}value&&"block-seq"===value.type?onError(props.end,"BAD_INDENT","All sequence items must start at the same column"):onError(offset,"MISSING_CHAR","Sequence item without - indicator")}const node=value?composeNode(ctx,value,props,onError):composeEmptyNode(ctx,props.end,start,null,props,onError);ctx.schema.compat&&flowIndentCheck(bs.indent,value,onError),offset=node.range[2],seq.items.push(node)}return seq.range=[bs.offset,offset,commentEnd??offset],seq}(CN,ctx,token,onError,tag):function(_ref26,ctx,fc,onError,tag){let{composeNode:composeNode,composeEmptyNode:composeEmptyNode}=_ref26;const isMap="{"===fc.start.source,fcName=isMap?"flow map":"flow sequence",coll=new((null==tag?void 0:tag.nodeClass)??(isMap?YAMLMap:YAMLSeq))(ctx.schema);coll.flow=!0;const atRoot=ctx.atRoot;atRoot&&(ctx.atRoot=!1),ctx.atKey&&(ctx.atKey=!1);let offset=fc.offset+fc.start.source.length;for(let i=0;i<fc.items.length;++i){const collItem=fc.items[i],{start:start,key:key,sep:sep,value:value}=collItem,props=resolveProps(start,{flow:fcName,indicator:"explicit-key-ind",next:key??(null==sep?void 0:sep[0]),offset:offset,onError:onError,parentIndent:fc.indent,startOnNewline:!1});if(!props.found){if(!(props.anchor||props.tag||sep||value)){0===i&&props.comma?onError(props.comma,"UNEXPECTED_TOKEN",`Unexpected , in ${fcName}`):i<fc.items.length-1&&onError(props.start,"UNEXPECTED_TOKEN",`Unexpected empty item in ${fcName}`),props.comment&&(coll.comment?coll.comment+="\n"+props.comment:coll.comment=props.comment),offset=props.end;continue}!isMap&&ctx.options.strict&&containsNewline(key)&&onError(key,"MULTILINE_IMPLICIT_KEY","Implicit keys of flow sequence pairs need to be on a single line")}if(0===i)props.comma&&onError(props.comma,"UNEXPECTED_TOKEN",`Unexpected , in ${fcName}`);else if(props.comma||onError(props.start,"MISSING_CHAR",`Missing , between ${fcName} items`),props.comment){let prevItemComment="";loop:for(const st of start)switch(st.type){case"comma":case"space":break;case"comment":prevItemComment=st.source.substring(1);break loop;default:break loop}if(prevItemComment){let prev=coll.items[coll.items.length-1];isPair(prev)&&(prev=prev.value??prev.key),prev.comment?prev.comment+="\n"+prevItemComment:prev.comment=prevItemComment,props.comment=props.comment.substring(prevItemComment.length+1)}}if(isMap||sep||props.found){ctx.atKey=!0;const keyStart=props.end,keyNode=key?composeNode(ctx,key,props,onError):composeEmptyNode(ctx,keyStart,start,null,props,onError);isBlock(key)&&onError(keyNode.range,"BLOCK_IN_FLOW",blockMsg),ctx.atKey=!1;const valueProps=resolveProps(sep??[],{flow:fcName,indicator:"map-value-ind",next:value,offset:keyNode.range[2],onError:onError,parentIndent:fc.indent,startOnNewline:!1});if(valueProps.found){if(!isMap&&!props.found&&ctx.options.strict){if(sep)for(const st of sep){if(st===valueProps.found)break;if("newline"===st.type){onError(st,"MULTILINE_IMPLICIT_KEY","Implicit keys of flow sequence pairs need to be on a single line");break}}props.start<valueProps.found.offset-1024&&onError(valueProps.found,"KEY_OVER_1024_CHARS","The : indicator must be at most 1024 chars after the start of an implicit flow sequence key")}}else value&&("source"in value&&value.source&&":"===value.source[0]?onError(value,"MISSING_CHAR",`Missing space after : in ${fcName}`):onError(valueProps.start,"MISSING_CHAR",`Missing , or : between ${fcName} items`));const valueNode=value?composeNode(ctx,value,valueProps,onError):valueProps.found?composeEmptyNode(ctx,valueProps.end,sep,null,valueProps,onError):null;valueNode?isBlock(value)&&onError(valueNode.range,"BLOCK_IN_FLOW",blockMsg):valueProps.comment&&(keyNode.comment?keyNode.comment+="\n"+valueProps.comment:keyNode.comment=valueProps.comment);const pair=new Pair(keyNode,valueNode);if(ctx.options.keepSourceTokens&&(pair.srcToken=collItem),isMap){const map=coll;mapIncludes(ctx,map.items,keyNode)&&onError(keyStart,"DUPLICATE_KEY","Map keys must be unique"),map.items.push(pair)}else{const map=new YAMLMap(ctx.schema);map.flow=!0,map.items.push(pair);const endRange=(valueNode??keyNode).range;map.range=[keyNode.range[0],endRange[1],endRange[2]],coll.items.push(map)}offset=valueNode?valueNode.range[2]:valueProps.end}else{const valueNode=value?composeNode(ctx,value,props,onError):composeEmptyNode(ctx,props.end,sep,null,props,onError);coll.items.push(valueNode),offset=valueNode.range[2],isBlock(value)&&onError(valueNode.range,"BLOCK_IN_FLOW",blockMsg)}}const expectedEnd=isMap?"}":"]",[ce,...ee]=fc.end;let cePos=offset;if(ce&&ce.source===expectedEnd)cePos=ce.offset+ce.source.length;else{const name=fcName[0].toUpperCase()+fcName.substring(1);onError(offset,atRoot?"MISSING_CHAR":"BAD_INDENT",atRoot?`${name} must end with a ${expectedEnd}`:`${name} in block collection must be sufficiently indented and end with a ${expectedEnd}`),ce&&1!==ce.source.length&&ee.unshift(ce)}if(ee.length>0){const end=resolveEnd(ee,cePos,ctx.options.strict,onError);end.comment&&(coll.comment?coll.comment+="\n"+end.comment:coll.comment=end.comment),coll.range=[fc.offset,cePos,end.offset]}else coll.range=[fc.offset,cePos,cePos];return coll}(CN,ctx,token,onError,tag),Coll=coll.constructor;return"!"===tagName||tagName===Coll.tagName?(coll.tag=Coll.tagName,coll):(tagName&&(coll.tag=tagName),coll)}function resolveBlockScalar(ctx,scalar,onError){const start=scalar.offset,header=function(_ref27,strict,onError){let{offset:offset,props:props}=_ref27;if("block-scalar-header"!==props[0].type)return onError(props[0],"IMPOSSIBLE","Block scalar header not found"),null;const{source:source}=props[0],mode=source[0];let indent=0,chomp="",error=-1;for(let i=1;i<source.length;++i){const ch=source[i];if(chomp||"-"!==ch&&"+"!==ch){const n=Number(ch);!indent&&n?indent=n:-1===error&&(error=offset+i)}else chomp=ch}-1!==error&&onError(error,"UNEXPECTED_TOKEN",`Block scalar header includes extra characters: ${source}`);let hasSpace=!1,comment="",length=source.length;for(let i=1;i<props.length;++i){const token=props[i];switch(token.type){case"space":hasSpace=!0;case"newline":length+=token.source.length;break;case"comment":if(strict&&!hasSpace){onError(token,"MISSING_CHAR","Comments must be separated from other tokens by white space characters")}length+=token.source.length,comment=token.source.substring(1);break;case"error":onError(token,"UNEXPECTED_TOKEN",token.message),length+=token.source.length;break;default:{onError(token,"UNEXPECTED_TOKEN",`Unexpected token in block scalar header: ${token.type}`);const ts=token.source;ts&&"string"==typeof ts&&(length+=ts.length)}}}return{mode:mode,indent:indent,chomp:chomp,comment:comment,length:length}}(scalar,ctx.options.strict,onError);if(!header)return{value:"",type:null,comment:"",range:[start,start,start]};const type=">"===header.mode?Scalar.BLOCK_FOLDED:Scalar.BLOCK_LITERAL,lines=scalar.source?function(source){const split=source.split(/\n( *)/),first=split[0],m=first.match(/^( *)/),lines=[null!=m&&m[1]?[m[1],first.slice(m[1].length)]:["",first]];for(let i=1;i<split.length;i+=2)lines.push([split[i],split[i+1]]);return lines}(scalar.source):[];let chompStart=lines.length;for(let i=lines.length-1;i>=0;--i){const content=lines[i][1];if(""!==content&&"\r"!==content)break;chompStart=i}if(0===chompStart){const value="+"===header.chomp&&lines.length>0?"\n".repeat(Math.max(1,lines.length-1)):"";let end=start+header.length;return scalar.source&&(end+=scalar.source.length),{value:value,type:type,comment:header.comment,range:[start,end,end]}}let trimIndent=scalar.indent+header.indent,offset=scalar.offset+header.length,contentStart=0;for(let i=0;i<chompStart;++i){const[indent,content]=lines[i];if(""!==content&&"\r"!==content){if(indent.length<trimIndent){const message="Block scalars with more-indented leading empty lines must use an explicit indentation indicator";onError(offset+indent.length,"MISSING_CHAR",message)}if(0===header.indent&&(trimIndent=indent.length),contentStart=i,0===trimIndent&&!ctx.atRoot){onError(offset,"BAD_INDENT","Block scalar values in collections must be indented")}break}0===header.indent&&indent.length>trimIndent&&(trimIndent=indent.length),offset+=indent.length+content.length+1}for(let i=lines.length-1;i>=chompStart;--i)lines[i][0].length>trimIndent&&(chompStart=i+1);let value="",sep="",prevMoreIndented=!1;for(let i=0;i<contentStart;++i)value+=lines[i][0].slice(trimIndent)+"\n";for(let i=contentStart;i<chompStart;++i){let[indent,content]=lines[i];offset+=indent.length+content.length+1;const crlf="\r"===content[content.length-1];if(crlf&&(content=content.slice(0,-1)),content&&indent.length<trimIndent){const message=`Block scalar lines must not be less indented than their ${header.indent?"explicit indentation indicator":"first line"}`;onError(offset-content.length-(crlf?2:1),"BAD_INDENT",message),indent=""}type===Scalar.BLOCK_LITERAL?(value+=sep+indent.slice(trimIndent)+content,sep="\n"):indent.length>trimIndent||"\t"===content[0]?(" "===sep?sep="\n":prevMoreIndented||"\n"!==sep||(sep="\n\n"),value+=sep+indent.slice(trimIndent)+content,sep="\n",prevMoreIndented=!0):""===content?"\n"===sep?value+="\n":sep="\n":(value+=sep+content,sep=" ",prevMoreIndented=!1)}switch(header.chomp){case"-":break;case"+":for(let i=chompStart;i<lines.length;++i)value+="\n"+lines[i][0].slice(trimIndent);"\n"!==value[value.length-1]&&(value+="\n");break;default:value+="\n"}const end=start+header.length+scalar.source.length;return{value:value,type:type,comment:header.comment,range:[start,end,end]}}function resolveFlowScalar(scalar,strict,onError){const{offset:offset,type:type,source:source,end:end}=scalar;let _type,value;const _onError=(rel,code,msg)=>onError(offset+rel,code,msg);switch(type){case"scalar":_type=Scalar.PLAIN,value=function(source,onError){let badChar="";switch(source[0]){case"\t":badChar="a tab character";break;case",":badChar="flow indicator character ,";break;case"%":badChar="directive indicator character %";break;case"|":case">":badChar=`block scalar indicator ${source[0]}`;break;case"@":case"`":badChar=`reserved character ${source[0]}`}badChar&&onError(0,"BAD_SCALAR_START",`Plain value cannot start with ${badChar}`);return foldLines(source)}(source,_onError);break;case"single-quoted-scalar":_type=Scalar.QUOTE_SINGLE,value=function(source,onError){"'"===source[source.length-1]&&1!==source.length||onError(source.length,"MISSING_CHAR","Missing closing 'quote");return foldLines(source.slice(1,-1)).replace(/''/g,"'")}(source,_onError);break;case"double-quoted-scalar":_type=Scalar.QUOTE_DOUBLE,value=function(source,onError){let res="";for(let i=1;i<source.length-1;++i){const ch=source[i];if("\r"!==ch||"\n"!==source[i+1])if("\n"===ch){const{fold:fold,offset:offset}=foldNewline(source,i);res+=fold,i=offset}else if("\\"===ch){let next=source[++i];const cc=escapeCodes[next];if(cc)res+=cc;else if("\n"===next)for(next=source[i+1];" "===next||"\t"===next;)next=source[1+ ++i];else if("\r"===next&&"\n"===source[i+1])for(next=source[1+ ++i];" "===next||"\t"===next;)next=source[1+ ++i];else if("x"===next||"u"===next||"U"===next){const length={x:2,u:4,U:8}[next];res+=parseCharCode(source,i+1,length,onError),i+=length}else{const raw=source.substr(i-1,2);onError(i-1,"BAD_DQ_ESCAPE",`Invalid escape sequence ${raw}`),res+=raw}}else if(" "===ch||"\t"===ch){const wsStart=i;let next=source[i+1];for(;" "===next||"\t"===next;)next=source[1+ ++i];"\n"===next||"\r"===next&&"\n"===source[i+2]||(res+=i>wsStart?source.slice(wsStart,i+1):ch)}else res+=ch}'"'===source[source.length-1]&&1!==source.length||onError(source.length,"MISSING_CHAR",'Missing closing "quote');return res}(source,_onError);break;default:return onError(scalar,"UNEXPECTED_TOKEN",`Expected a flow scalar value, but found: ${type}`),{value:"",type:null,comment:"",range:[offset,offset+source.length,offset+source.length]}}const valueEnd=offset+source.length,re=resolveEnd(end,valueEnd,strict,onError);return{value:value,type:_type,comment:re.comment,range:[offset,valueEnd,re.offset]}}function foldLines(source){var _match;let first,line;try{first=new RegExp("(.*?)(?<![ \t])[ \t]*\r?\n","sy"),line=new RegExp("[ \t]*(.*?)(?:(?<![ \t])[ \t]*)?\r?\n","sy")}catch{first=/(.*?)[ \t]*\r?\n/ys,line=/[ \t]*(.*?)[ \t]*\r?\n/ys}let match=first.exec(source);if(!match)return source;let res=match[1],sep=" ",pos=first.lastIndex;for(line.lastIndex=pos;match=line.exec(source);)""===match[1]?"\n"===sep?res+=sep:sep="\n":(res+=sep+match[1],sep=" "),pos=line.lastIndex;const last=/[ \t]*(.*)/ys;return last.lastIndex=pos,match=last.exec(source),res+sep+((null===(_match=match)||void 0===_match?void 0:_match[1])??"")}function foldNewline(source,offset){let fold="",ch=source[offset+1];for(;!(" "!==ch&&"\t"!==ch&&"\n"!==ch&&"\r"!==ch||"\r"===ch&&"\n"!==source[offset+2]);)"\n"===ch&&(fold+="\n"),ch=source[(offset+=1)+1];return fold||(fold=" "),{fold:fold,offset:offset}}const escapeCodes={0:"\0",a:"",b:"\b",e:"",f:"\f",n:"\n",r:"\r",t:"\t",v:"\v",N:"",_:" ",L:"\u2028",P:"\u2029"," ":" ",'"':'"',"/":"/","\\":"\\","\t":"\t"};function parseCharCode(source,offset,length,onError){const cc=source.substr(offset,length),code=cc.length===length&&/^[0-9a-fA-F]+$/.test(cc)?parseInt(cc,16):NaN;if(isNaN(code)){const raw=source.substr(offset-2,length+2);return onError(offset-2,"BAD_DQ_ESCAPE",`Invalid escape sequence ${raw}`),raw}return String.fromCodePoint(code)}function composeScalar(ctx,token,tagToken,onError){const{value:value,type:type,comment:comment,range:range}="block-scalar"===token.type?resolveBlockScalar(ctx,token,onError):resolveFlowScalar(token,ctx.options.strict,onError),tagName=tagToken?ctx.directives.tagName(tagToken.source,(msg=>onError(tagToken,"TAG_RESOLVE_FAILED",msg))):null;let tag,scalar;tag=ctx.options.stringKeys&&ctx.atKey?ctx.schema[SCALAR$1]:tagName?function(schema,value,tagName,tagToken,onError){if("!"===tagName)return schema[SCALAR$1];const matchWithTest=[];for(const tag of schema.tags)if(!tag.collection&&tag.tag===tagName){if(!tag.default||!tag.test)return tag;matchWithTest.push(tag)}for(const tag of matchWithTest){var _tag$test2;if(null!==(_tag$test2=tag.test)&&void 0!==_tag$test2&&_tag$test2.test(value))return tag}const kt=schema.knownTags[tagName];if(kt&&!kt.collection)return schema.tags.push(Object.assign({},kt,{default:!1,test:void 0})),kt;return onError(tagToken,"TAG_RESOLVE_FAILED",`Unresolved tag: ${tagName}`,"tag:yaml.org,2002:str"!==tagName),schema[SCALAR$1]}(ctx.schema,value,tagName,tagToken,onError):"scalar"===token.type?function(_ref28,value,token,onError){let{atKey:atKey,directives:directives,schema:schema}=_ref28;const tag=schema.tags.find((tag=>{var _tag$test3;return(!0===tag.default||atKey&&"key"===tag.default)&&(null===(_tag$test3=tag.test)||void 0===_tag$test3?void 0:_tag$test3.test(value))}))||schema[SCALAR$1];if(schema.compat){const compat=schema.compat.find((tag=>{var _tag$test4;return tag.default&&(null===(_tag$test4=tag.test)||void 0===_tag$test4?void 0:_tag$test4.test(value))}))??schema[SCALAR$1];if(tag.tag!==compat.tag){onError(token,"TAG_RESOLVE_FAILED",`Value may be parsed as either ${directives.tagString(tag.tag)} or ${directives.tagString(compat.tag)}`,!0)}}return tag}(ctx,value,token,onError):ctx.schema[SCALAR$1];try{const res=tag.resolve(value,(msg=>onError(tagToken??token,"TAG_RESOLVE_FAILED",msg)),ctx.options);scalar=isScalar(res)?res:new Scalar(res)}catch(error){const msg=error instanceof Error?error.message:String(error);onError(tagToken??token,"TAG_RESOLVE_FAILED",msg),scalar=new Scalar(value)}return scalar.range=range,scalar.source=value,type&&(scalar.type=type),tagName&&(scalar.tag=tagName),tag.format&&(scalar.format=tag.format),comment&&(scalar.comment=comment),scalar}function emptyScalarPosition(offset,before,pos){if(before){pos??(pos=before.length);for(let i=pos-1;i>=0;--i){let st=before[i];switch(st.type){case"space":case"comment":case"newline":offset-=st.source.length;continue}for(st=before[++i];"space"===(null===(_st=st)||void 0===_st?void 0:_st.type);){var _st;offset+=st.source.length,st=before[++i]}break}}return offset}const CN={composeNode:composeNode,composeEmptyNode:composeEmptyNode};function composeNode(ctx,token,props,onError){const atKey=ctx.atKey,{spaceBefore:spaceBefore,comment:comment,anchor:anchor,tag:tag}=props;let node,isSrcToken=!0;switch(token.type){case"alias":node=function(_ref30,_ref31,onError){let{options:options}=_ref30,{offset:offset,source:source,end:end}=_ref31;const alias=new Alias(source.substring(1));""===alias.source&&onError(offset,"BAD_ALIAS","Alias cannot be an empty string");alias.source.endsWith(":")&&onError(offset+source.length-1,"BAD_ALIAS","Alias ending in : is ambiguous",!0);const valueEnd=offset+source.length,re=resolveEnd(end,valueEnd,options.strict,onError);alias.range=[offset,valueEnd,re.offset],re.comment&&(alias.comment=re.comment);return alias}(ctx,token,onError),(anchor||tag)&&onError(token,"ALIAS_PROPS","An alias node must not specify any properties");break;case"scalar":case"single-quoted-scalar":case"double-quoted-scalar":case"block-scalar":node=composeScalar(ctx,token,tag,onError),anchor&&(node.anchor=anchor.source.substring(1));break;case"block-map":case"block-seq":case"flow-collection":node=function(CN,ctx,token,props,onError){var _tag$resolve,_tag,_tag2;const tagToken=props.tag,tagName=tagToken?ctx.directives.tagName(tagToken.source,(msg=>onError(tagToken,"TAG_RESOLVE_FAILED",msg))):null;if("block-seq"===token.type){const{anchor:anchor,newlineAfterProp:nl}=props,lastProp=anchor&&tagToken?anchor.offset>tagToken.offset?anchor:tagToken:anchor??tagToken;lastProp&&(!nl||nl.offset<lastProp.offset)&&onError(lastProp,"MISSING_CHAR","Missing newline after block sequence props")}const expType="block-map"===token.type?"map":"block-seq"===token.type?"seq":"{"===token.start.source?"map":"seq";if(!tagToken||!tagName||"!"===tagName||tagName===YAMLMap.tagName&&"map"===expType||tagName===YAMLSeq.tagName&&"seq"===expType)return resolveCollection(CN,ctx,token,onError,tagName);let tag=ctx.schema.tags.find((t=>t.tag===tagName&&t.collection===expType));if(!tag){const kt=ctx.schema.knownTags[tagName];if(!kt||kt.collection!==expType)return kt?onError(tagToken,"BAD_COLLECTION_TYPE",`${kt.tag} used for ${expType} collection, but expects ${kt.collection??"scalar"}`,!0):onError(tagToken,"TAG_RESOLVE_FAILED",`Unresolved tag: ${tagName}`,!0),resolveCollection(CN,ctx,token,onError,tagName);ctx.schema.tags.push(Object.assign({},kt,{default:!1})),tag=kt}const coll=resolveCollection(CN,ctx,token,onError,tagName,tag),res=(null===(_tag$resolve=(_tag=tag).resolve)||void 0===_tag$resolve?void 0:_tag$resolve.call(_tag,coll,(msg=>onError(tagToken,"TAG_RESOLVE_FAILED",msg)),ctx.options))??coll,node=isNode(res)?res:new Scalar(res);return node.range=coll.range,node.tag=tagName,null!==(_tag2=tag)&&void 0!==_tag2&&_tag2.format&&(node.format=tag.format),node}(CN,ctx,token,props,onError),anchor&&(node.anchor=anchor.source.substring(1));break;default:onError(token,"UNEXPECTED_TOKEN","error"===token.type?token.message:`Unsupported token (type: ${token.type})`),node=composeEmptyNode(ctx,token.offset,void 0,null,props,onError),isSrcToken=!1}if(anchor&&""===node.anchor&&onError(anchor,"BAD_ALIAS","Anchor cannot be an empty string"),atKey&&ctx.options.stringKeys&&(!isScalar(node)||"string"!=typeof node.value||node.tag&&"tag:yaml.org,2002:str"!==node.tag)){onError(tag??token,"NON_STRING_KEY","With stringKeys, all keys must be strings")}return spaceBefore&&(node.spaceBefore=!0),comment&&("scalar"===token.type&&""===token.source?node.comment=comment:node.commentBefore=comment),ctx.options.keepSourceTokens&&isSrcToken&&(node.srcToken=token),node}function composeEmptyNode(ctx,offset,before,pos,_ref29,onError){let{spaceBefore:spaceBefore,comment:comment,anchor:anchor,tag:tag,end:end}=_ref29;const node=composeScalar(ctx,{type:"scalar",offset:emptyScalarPosition(offset,before,pos),indent:-1,source:""},tag,onError);return anchor&&(node.anchor=anchor.source.substring(1),""===node.anchor&&onError(anchor,"BAD_ALIAS","Anchor cannot be an empty string")),spaceBefore&&(node.spaceBefore=!0),comment&&(node.comment=comment,node.range[2]=end),node}function getErrorPos(src){if("number"==typeof src)return[src,src+1];if(Array.isArray(src))return 2===src.length?src:[src[0],src[1]];const{offset:offset,source:source}=src;return[offset,offset+("string"==typeof source?source.length:1)]}function parsePrelude(prelude){var _prelude;let comment="",atComment=!1,afterEmptyLine=!1;for(let i=0;i<prelude.length;++i){const source=prelude[i];switch(source[0]){case"#":comment+=(""===comment?"":afterEmptyLine?"\n\n":"\n")+(source.substring(1)||" "),atComment=!0,afterEmptyLine=!1;break;case"%":"#"!==(null===(_prelude=prelude[i+1])||void 0===_prelude?void 0:_prelude[0])&&(i+=1),atComment=!1;break;default:atComment||(afterEmptyLine=!0),atComment=!1}}return{comment:comment,afterEmptyLine:afterEmptyLine}}class Composer{constructor(){let options=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.doc=null,this.atDirectives=!1,this.prelude=[],this.errors=[],this.warnings=[],this.onError=(source,code,message,warning)=>{const pos=getErrorPos(source);warning?this.warnings.push(new YAMLWarning(pos,code,message)):this.errors.push(new YAMLParseError(pos,code,message))},this.directives=new Directives({version:options.version||"1.2"}),this.options=options}decorate(doc,afterDoc){const{comment:comment,afterEmptyLine:afterEmptyLine}=parsePrelude(this.prelude);if(comment){const dc=doc.contents;if(afterDoc)doc.comment=doc.comment?`${doc.comment}\n${comment}`:comment;else if(afterEmptyLine||doc.directives.docStart||!dc)doc.commentBefore=comment;else if(isCollection(dc)&&!dc.flow&&dc.items.length>0){let it=dc.items[0];isPair(it)&&(it=it.key);const cb=it.commentBefore;it.commentBefore=cb?`${comment}\n${cb}`:comment}else{const cb=dc.commentBefore;dc.commentBefore=cb?`${comment}\n${cb}`:comment}}afterDoc?(Array.prototype.push.apply(doc.errors,this.errors),Array.prototype.push.apply(doc.warnings,this.warnings)):(doc.errors=this.errors,doc.warnings=this.warnings),this.prelude=[],this.errors=[],this.warnings=[]}streamInfo(){return{comment:parsePrelude(this.prelude).comment,directives:this.directives,errors:this.errors,warnings:this.warnings}}*compose(tokens){let forceDoc=arguments.length>1&&void 0!==arguments[1]&&arguments[1],endOffset=arguments.length>2&&void 0!==arguments[2]?arguments[2]:-1;for(const token of tokens)yield*this.next(token);yield*this.end(forceDoc,endOffset)}*next(token){switch(token.type){case"directive":this.directives.add(token.source,((offset,message,warning)=>{const pos=getErrorPos(token);pos[0]+=offset,this.onError(pos,"BAD_DIRECTIVE",message,warning)})),this.prelude.push(token.source),this.atDirectives=!0;break;case"document":{const doc=function(options,directives,_ref32,onError){let{offset:offset,start:start,value:value,end:end}=_ref32;const opts=Object.assign({_directives:directives},options),doc=new Document(void 0,opts),ctx={atKey:!1,atRoot:!0,directives:doc.directives,options:doc.options,schema:doc.schema},props=resolveProps(start,{indicator:"doc-start",next:value??(null==end?void 0:end[0]),offset:offset,onError:onError,parentIndent:0,startOnNewline:!0});props.found&&(doc.directives.docStart=!0,!value||"block-map"!==value.type&&"block-seq"!==value.type||props.hasNewline||onError(props.end,"MISSING_CHAR","Block collection cannot start on same line with directives-end marker")),doc.contents=value?composeNode(ctx,value,props,onError):composeEmptyNode(ctx,props.end,start,null,props,onError);const contentEnd=doc.contents.range[2],re=resolveEnd(end,contentEnd,!1,onError);return re.comment&&(doc.comment=re.comment),doc.range=[offset,contentEnd,re.offset],doc}(this.options,this.directives,token,this.onError);this.atDirectives&&!doc.directives.docStart&&this.onError(token,"MISSING_CHAR","Missing directives-end/doc-start indicator line"),this.decorate(doc,!1),this.doc&&(yield this.doc),this.doc=doc,this.atDirectives=!1;break}case"byte-order-mark":case"space":break;case"comment":case"newline":this.prelude.push(token.source);break;case"error":{const msg=token.source?`${token.message}: ${JSON.stringify(token.source)}`:token.message,error=new YAMLParseError(getErrorPos(token),"UNEXPECTED_TOKEN",msg);this.atDirectives||!this.doc?this.errors.push(error):this.doc.errors.push(error);break}case"doc-end":{if(!this.doc){const msg="Unexpected doc-end without preceding document";this.errors.push(new YAMLParseError(getErrorPos(token),"UNEXPECTED_TOKEN",msg));break}this.doc.directives.docEnd=!0;const end=resolveEnd(token.end,token.offset+token.source.length,this.doc.options.strict,this.onError);if(this.decorate(this.doc,!0),end.comment){const dc=this.doc.comment;this.doc.comment=dc?`${dc}\n${end.comment}`:end.comment}this.doc.range[2]=end.offset;break}default:this.errors.push(new YAMLParseError(getErrorPos(token),"UNEXPECTED_TOKEN",`Unsupported token ${token.type}`))}}*end(){let forceDoc=arguments.length>0&&void 0!==arguments[0]&&arguments[0],endOffset=arguments.length>1&&void 0!==arguments[1]?arguments[1]:-1;if(this.doc)this.decorate(this.doc,!0),yield this.doc,this.doc=null;else if(forceDoc){const opts=Object.assign({_directives:this.directives},this.options),doc=new Document(void 0,opts);this.atDirectives&&this.onError(endOffset,"MISSING_CHAR","Missing directives-end indicator line"),doc.range=[0,endOffset,endOffset],this.decorate(doc,!1),yield doc}}}function isEmpty(ch){switch(ch){case void 0:case" ":case"\n":case"\r":case"\t":return!0;default:return!1}}const hexDigits=new Set("0123456789ABCDEFabcdef"),tagChars=new Set("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-#;/?:@&=+$_.!~*'()"),flowIndicatorChars=new Set(",[]{}"),invalidAnchorChars=new Set(" ,[]{}\n\r\t"),isNotAnchorChar=ch=>!ch||invalidAnchorChars.has(ch);class Lexer{constructor(){this.atEnd=!1,this.blockScalarIndent=-1,this.blockScalarKeep=!1,this.buffer="",this.flowKey=!1,this.flowLevel=0,this.indentNext=0,this.indentValue=0,this.lineEndPos=null,this.next=null,this.pos=0}*lex(source){let incomplete=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(source){if("string"!=typeof source)throw TypeError("source is not a string");this.buffer=this.buffer?this.buffer+source:source,this.lineEndPos=null}this.atEnd=!incomplete;let next=this.next??"stream";for(;next&&(incomplete||this.hasChars(1));)next=yield*this.parseNext(next)}atLineEnd(){let i=this.pos,ch=this.buffer[i];for(;" "===ch||"\t"===ch;)ch=this.buffer[++i];return!ch||"#"===ch||"\n"===ch||"\r"===ch&&"\n"===this.buffer[i+1]}charAt(n){return this.buffer[this.pos+n]}continueScalar(offset){let ch=this.buffer[offset];if(this.indentNext>0){let indent=0;for(;" "===ch;)ch=this.buffer[++indent+offset];if("\r"===ch){const next=this.buffer[indent+offset+1];if("\n"===next||!next&&!this.atEnd)return offset+indent+1}return"\n"===ch||indent>=this.indentNext||!ch&&!this.atEnd?offset+indent:-1}if("-"===ch||"."===ch){const dt=this.buffer.substr(offset,3);if(("---"===dt||"..."===dt)&&isEmpty(this.buffer[offset+3]))return-1}return offset}getLine(){let end=this.lineEndPos;return("number"!=typeof end||-1!==end&&end<this.pos)&&(end=this.buffer.indexOf("\n",this.pos),this.lineEndPos=end),-1===end?this.atEnd?this.buffer.substring(this.pos):null:("\r"===this.buffer[end-1]&&(end-=1),this.buffer.substring(this.pos,end))}hasChars(n){return this.pos+n<=this.buffer.length}setNext(state){return this.buffer=this.buffer.substring(this.pos),this.pos=0,this.lineEndPos=null,this.next=state,null}peek(n){return this.buffer.substr(this.pos,n)}*parseNext(next){switch(next){case"stream":return yield*this.parseStream();case"line-start":return yield*this.parseLineStart();case"block-start":return yield*this.parseBlockStart();case"doc":return yield*this.parseDocument();case"flow":return yield*this.parseFlowCollection();case"quoted-scalar":return yield*this.parseQuotedScalar();case"block-scalar":return yield*this.parseBlockScalar();case"plain-scalar":return yield*this.parsePlainScalar()}}*parseStream(){let line=this.getLine();if(null===line)return this.setNext("stream");if("\ufeff"===line[0]&&(yield*this.pushCount(1),line=line.substring(1)),"%"===line[0]){let dirEnd=line.length,cs=line.indexOf("#");for(;-1!==cs;){const ch=line[cs-1];if(" "===ch||"\t"===ch){dirEnd=cs-1;break}cs=line.indexOf("#",cs+1)}for(;;){const ch=line[dirEnd-1];if(" "!==ch&&"\t"!==ch)break;dirEnd-=1}const n=(yield*this.pushCount(dirEnd))+(yield*this.pushSpaces(!0));return yield*this.pushCount(line.length-n),this.pushNewline(),"stream"}if(this.atLineEnd()){const sp=yield*this.pushSpaces(!0);return yield*this.pushCount(line.length-sp),yield*this.pushNewline(),"stream"}return yield"",yield*this.parseLineStart()}*parseLineStart(){const ch=this.charAt(0);if(!ch&&!this.atEnd)return this.setNext("line-start");if("-"===ch||"."===ch){if(!this.atEnd&&!this.hasChars(4))return this.setNext("line-start");const s=this.peek(3);if(("---"===s||"..."===s)&&isEmpty(this.charAt(3)))return yield*this.pushCount(3),this.indentValue=0,this.indentNext=0,"---"===s?"doc":"stream"}return this.indentValue=yield*this.pushSpaces(!1),this.indentNext>this.indentValue&&!isEmpty(this.charAt(1))&&(this.indentNext=this.indentValue),yield*this.parseBlockStart()}*parseBlockStart(){const[ch0,ch1]=this.peek(2);if(!ch1&&!this.atEnd)return this.setNext("block-start");if(("-"===ch0||"?"===ch0||":"===ch0)&&isEmpty(ch1)){const n=(yield*this.pushCount(1))+(yield*this.pushSpaces(!0));return this.indentNext=this.indentValue+1,this.indentValue+=n,yield*this.parseBlockStart()}return"doc"}*parseDocument(){yield*this.pushSpaces(!0);const line=this.getLine();if(null===line)return this.setNext("doc");let n=yield*this.pushIndicators();switch(line[n]){case"#":yield*this.pushCount(line.length-n);case void 0:return yield*this.pushNewline(),yield*this.parseLineStart();case"{":case"[":return yield*this.pushCount(1),this.flowKey=!1,this.flowLevel=1,"flow";case"}":case"]":return yield*this.pushCount(1),"doc";case"*":return yield*this.pushUntil(isNotAnchorChar),"doc";case'"':case"'":return yield*this.parseQuotedScalar();case"|":case">":return n+=(yield*this.parseBlockScalarHeader()),n+=(yield*this.pushSpaces(!0)),yield*this.pushCount(line.length-n),yield*this.pushNewline(),yield*this.parseBlockScalar();default:return yield*this.parsePlainScalar()}}*parseFlowCollection(){let nl,sp,indent=-1;do{nl=yield*this.pushNewline(),nl>0?(sp=yield*this.pushSpaces(!1),this.indentValue=indent=sp):sp=0,sp+=(yield*this.pushSpaces(!0))}while(nl+sp>0);const line=this.getLine();if(null===line)return this.setNext("flow");if(-1!==indent&&indent<this.indentNext&&"#"!==line[0]||0===indent&&(line.startsWith("---")||line.startsWith("..."))&&isEmpty(line[3])){if(!(indent===this.indentNext-1&&1===this.flowLevel&&("]"===line[0]||"}"===line[0])))return this.flowLevel=0,yield"",yield*this.parseLineStart()}let n=0;for(;","===line[n];)n+=(yield*this.pushCount(1)),n+=(yield*this.pushSpaces(!0)),this.flowKey=!1;switch(n+=(yield*this.pushIndicators()),line[n]){case void 0:return"flow";case"#":return yield*this.pushCount(line.length-n),"flow";case"{":case"[":return yield*this.pushCount(1),this.flowKey=!1,this.flowLevel+=1,"flow";case"}":case"]":return yield*this.pushCount(1),this.flowKey=!0,this.flowLevel-=1,this.flowLevel?"flow":"doc";case"*":return yield*this.pushUntil(isNotAnchorChar),"flow";case'"':case"'":return this.flowKey=!0,yield*this.parseQuotedScalar();case":":{const next=this.charAt(1);if(this.flowKey||isEmpty(next)||","===next)return this.flowKey=!1,yield*this.pushCount(1),yield*this.pushSpaces(!0),"flow"}default:return this.flowKey=!1,yield*this.parsePlainScalar()}}*parseQuotedScalar(){const quote=this.charAt(0);let end=this.buffer.indexOf(quote,this.pos+1);if("'"===quote)for(;-1!==end&&"'"===this.buffer[end+1];)end=this.buffer.indexOf("'",end+2);else for(;-1!==end;){let n=0;for(;"\\"===this.buffer[end-1-n];)n+=1;if(n%2==0)break;end=this.buffer.indexOf('"',end+1)}const qb=this.buffer.substring(0,end);let nl=qb.indexOf("\n",this.pos);if(-1!==nl){for(;-1!==nl;){const cs=this.continueScalar(nl+1);if(-1===cs)break;nl=qb.indexOf("\n",cs)}-1!==nl&&(end=nl-("\r"===qb[nl-1]?2:1))}if(-1===end){if(!this.atEnd)return this.setNext("quoted-scalar");end=this.buffer.length}return yield*this.pushToIndex(end+1,!1),this.flowLevel?"flow":"doc"}*parseBlockScalarHeader(){this.blockScalarIndent=-1,this.blockScalarKeep=!1;let i=this.pos;for(;;){const ch=this.buffer[++i];if("+"===ch)this.blockScalarKeep=!0;else if(ch>"0"&&ch<="9")this.blockScalarIndent=Number(ch)-1;else if("-"!==ch)break}return yield*this.pushUntil((ch=>isEmpty(ch)||"#"===ch))}*parseBlockScalar(){let ch,nl=this.pos-1,indent=0;loop:for(let i=this.pos;ch=this.buffer[i];++i)switch(ch){case" ":indent+=1;break;case"\n":nl=i,indent=0;break;case"\r":{const next=this.buffer[i+1];if(!next&&!this.atEnd)return this.setNext("block-scalar");if("\n"===next)break}default:break loop}if(!ch&&!this.atEnd)return this.setNext("block-scalar");if(indent>=this.indentNext){-1===this.blockScalarIndent?this.indentNext=indent:this.indentNext=this.blockScalarIndent+(0===this.indentNext?1:this.indentNext);do{const cs=this.continueScalar(nl+1);if(-1===cs)break;nl=this.buffer.indexOf("\n",cs)}while(-1!==nl);if(-1===nl){if(!this.atEnd)return this.setNext("block-scalar");nl=this.buffer.length}}let i=nl+1;for(ch=this.buffer[i];" "===ch;)ch=this.buffer[++i];if("\t"===ch){for(;"\t"===ch||" "===ch||"\r"===ch||"\n"===ch;)ch=this.buffer[++i];nl=i-1}else if(!this.blockScalarKeep)for(;;){let i=nl-1,ch=this.buffer[i];"\r"===ch&&(ch=this.buffer[--i]);const lastChar=i;for(;" "===ch;)ch=this.buffer[--i];if(!("\n"===ch&&i>=this.pos&&i+1+indent>lastChar))break;nl=i}return yield"",yield*this.pushToIndex(nl+1,!0),yield*this.parseLineStart()}*parsePlainScalar(){const inFlow=this.flowLevel>0;let ch,end=this.pos-1,i=this.pos-1;for(;ch=this.buffer[++i];)if(":"===ch){const next=this.buffer[i+1];if(isEmpty(next)||inFlow&&flowIndicatorChars.has(next))break;end=i}else if(isEmpty(ch)){let next=this.buffer[i+1];if("\r"===ch&&("\n"===next?(i+=1,ch="\n",next=this.buffer[i+1]):end=i),"#"===next||inFlow&&flowIndicatorChars.has(next))break;if("\n"===ch){const cs=this.continueScalar(i+1);if(-1===cs)break;i=Math.max(i,cs-2)}}else{if(inFlow&&flowIndicatorChars.has(ch))break;end=i}return ch||this.atEnd?(yield"",yield*this.pushToIndex(end+1,!0),inFlow?"flow":"doc"):this.setNext("plain-scalar")}*pushCount(n){return n>0?(yield this.buffer.substr(this.pos,n),this.pos+=n,n):0}*pushToIndex(i,allowEmpty){const s=this.buffer.slice(this.pos,i);return s?(yield s,this.pos+=s.length,s.length):(allowEmpty&&(yield""),0)}*pushIndicators(){switch(this.charAt(0)){case"!":return(yield*this.pushTag())+(yield*this.pushSpaces(!0))+(yield*this.pushIndicators());case"&":return(yield*this.pushUntil(isNotAnchorChar))+(yield*this.pushSpaces(!0))+(yield*this.pushIndicators());case"-":case"?":case":":{const inFlow=this.flowLevel>0,ch1=this.charAt(1);if(isEmpty(ch1)||inFlow&&flowIndicatorChars.has(ch1))return inFlow?this.flowKey&&(this.flowKey=!1):this.indentNext=this.indentValue+1,(yield*this.pushCount(1))+(yield*this.pushSpaces(!0))+(yield*this.pushIndicators())}}return 0}*pushTag(){if("<"===this.charAt(1)){let i=this.pos+2,ch=this.buffer[i];for(;!isEmpty(ch)&&">"!==ch;)ch=this.buffer[++i];return yield*this.pushToIndex(">"===ch?i+1:i,!1)}{let i=this.pos+1,ch=this.buffer[i];for(;ch;)if(tagChars.has(ch))ch=this.buffer[++i];else{if("%"!==ch||!hexDigits.has(this.buffer[i+1])||!hexDigits.has(this.buffer[i+2]))break;ch=this.buffer[i+=3]}return yield*this.pushToIndex(i,!1)}}*pushNewline(){const ch=this.buffer[this.pos];return"\n"===ch?yield*this.pushCount(1):"\r"===ch&&"\n"===this.charAt(1)?yield*this.pushCount(2):0}*pushSpaces(allowTabs){let ch,i=this.pos-1;do{ch=this.buffer[++i]}while(" "===ch||allowTabs&&"\t"===ch);const n=i-this.pos;return n>0&&(yield this.buffer.substr(this.pos,n),this.pos=i),n}*pushUntil(test){let i=this.pos,ch=this.buffer[i];for(;!test(ch);)ch=this.buffer[++i];return yield*this.pushToIndex(i,!1)}}class LineCounter{constructor(){this.lineStarts=[],this.addNewLine=offset=>this.lineStarts.push(offset),this.linePos=offset=>{let low=0,high=this.lineStarts.length;for(;low<high;){const mid=low+high>>1;this.lineStarts[mid]<offset?low=mid+1:high=mid}if(this.lineStarts[low]===offset)return{line:low+1,col:1};if(0===low)return{line:0,col:offset};return{line:low,col:offset-this.lineStarts[low-1]+1}}}}function includesToken(list,type){for(let i=0;i<list.length;++i)if(list[i].type===type)return!0;return!1}function findNonEmptyIndex(list){for(let i=0;i<list.length;++i)switch(list[i].type){case"space":case"comment":case"newline":break;default:return i}return-1}function isFlowToken(token){switch(null==token?void 0:token.type){case"alias":case"scalar":case"single-quoted-scalar":case"double-quoted-scalar":case"flow-collection":return!0;default:return!1}}function getPrevProps(parent){switch(parent.type){case"document":return parent.start;case"block-map":{const it=parent.items[parent.items.length-1];return it.sep??it.start}case"block-seq":return parent.items[parent.items.length-1].start;default:return[]}}function getFirstKeyStartProps(prev){if(0===prev.length)return[];let i=prev.length;loop:for(;--i>=0;)switch(prev[i].type){case"doc-start":case"explicit-key-ind":case"map-value-ind":case"seq-item-ind":case"newline":break loop}for(;"space"===(null===(_prev$i=prev[++i])||void 0===_prev$i?void 0:_prev$i.type);)var _prev$i;return prev.splice(i,prev.length)}function fixFlowSeqItems(fc){if("flow-seq-start"===fc.start.type)for(const it of fc.items)!it.sep||it.value||includesToken(it.start,"explicit-key-ind")||includesToken(it.sep,"map-value-ind")||(it.key&&(it.value=it.key),delete it.key,isFlowToken(it.value)?it.value.end?Array.prototype.push.apply(it.value.end,it.sep):it.value.end=it.sep:Array.prototype.push.apply(it.start,it.sep),delete it.sep)}class Parser{constructor(onNewLine){this.atNewLine=!0,this.atScalar=!1,this.indent=0,this.offset=0,this.onKeyLine=!1,this.stack=[],this.source="",this.type="",this.lexer=new Lexer,this.onNewLine=onNewLine}*parse(source){let incomplete=arguments.length>1&&void 0!==arguments[1]&&arguments[1];this.onNewLine&&0===this.offset&&this.onNewLine(0);for(const lexeme of this.lexer.lex(source,incomplete))yield*this.next(lexeme);incomplete||(yield*this.end())}*next(source){if(this.source=source,this.atScalar)return this.atScalar=!1,yield*this.step(),void(this.offset+=source.length);const type=function(source){switch(source){case"\ufeff":return"byte-order-mark";case"":return"doc-mode";case"":return"flow-error-end";case"":return"scalar";case"---":return"doc-start";case"...":return"doc-end";case"":case"\n":case"\r\n":return"newline";case"-":return"seq-item-ind";case"?":return"explicit-key-ind";case":":return"map-value-ind";case"{":return"flow-map-start";case"}":return"flow-map-end";case"[":return"flow-seq-start";case"]":return"flow-seq-end";case",":return"comma"}switch(source[0]){case" ":case"\t":return"space";case"#":return"comment";case"%":return"directive-line";case"*":return"alias";case"&":return"anchor";case"!":return"tag";case"'":return"single-quoted-scalar";case'"':return"double-quoted-scalar";case"|":case">":return"block-scalar-header"}return null}(source);if(type)if("scalar"===type)this.atNewLine=!1,this.atScalar=!0,this.type="scalar";else{switch(this.type=type,yield*this.step(),type){case"newline":this.atNewLine=!0,this.indent=0,this.onNewLine&&this.onNewLine(this.offset+source.length);break;case"space":this.atNewLine&&" "===source[0]&&(this.indent+=source.length);break;case"explicit-key-ind":case"map-value-ind":case"seq-item-ind":this.atNewLine&&(this.indent+=source.length);break;case"doc-mode":case"flow-error-end":return;default:this.atNewLine=!1}this.offset+=source.length}else{const message=`Not a YAML token: ${source}`;yield*this.pop({type:"error",offset:this.offset,message:message,source:source}),this.offset+=source.length}}*end(){for(;this.stack.length>0;)yield*this.pop()}get sourceToken(){return{type:this.type,offset:this.offset,indent:this.indent,source:this.source}}*step(){const top=this.peek(1);if("doc-end"!==this.type||top&&"doc-end"===top.type){if(!top)return yield*this.stream();switch(top.type){case"document":return yield*this.document(top);case"alias":case"scalar":case"single-quoted-scalar":case"double-quoted-scalar":return yield*this.scalar(top);case"block-scalar":return yield*this.blockScalar(top);case"block-map":return yield*this.blockMap(top);case"block-seq":return yield*this.blockSequence(top);case"flow-collection":return yield*this.flowCollection(top);case"doc-end":return yield*this.documentEnd(top)}yield*this.pop()}else{for(;this.stack.length>0;)yield*this.pop();this.stack.push({type:"doc-end",offset:this.offset,source:this.source})}}peek(n){return this.stack[this.stack.length-n]}*pop(error){const token=error??this.stack.pop();if(token)if(0===this.stack.length)yield token;else{const top=this.peek(1);switch("block-scalar"===token.type?token.indent="indent"in top?top.indent:0:"flow-collection"===token.type&&"document"===top.type&&(token.indent=0),"flow-collection"===token.type&&fixFlowSeqItems(token),top.type){case"document":top.value=token;break;case"block-scalar":top.props.push(token);break;case"block-map":{const it=top.items[top.items.length-1];if(it.value)return top.items.push({start:[],key:token,sep:[]}),void(this.onKeyLine=!0);if(!it.sep)return Object.assign(it,{key:token,sep:[]}),void(this.onKeyLine=!it.explicitKey);it.value=token;break}case"block-seq":{const it=top.items[top.items.length-1];it.value?top.items.push({start:[],value:token}):it.value=token;break}case"flow-collection":{const it=top.items[top.items.length-1];return void(!it||it.value?top.items.push({start:[],key:token,sep:[]}):it.sep?it.value=token:Object.assign(it,{key:token,sep:[]}))}default:yield*this.pop(),yield*this.pop(token)}if(!("document"!==top.type&&"block-map"!==top.type&&"block-seq"!==top.type||"block-map"!==token.type&&"block-seq"!==token.type)){const last=token.items[token.items.length-1];last&&!last.sep&&!last.value&&last.start.length>0&&-1===findNonEmptyIndex(last.start)&&(0===token.indent||last.start.every((st=>"comment"!==st.type||st.indent<token.indent)))&&("document"===top.type?top.end=last.start:top.items.push({start:last.start}),token.items.splice(-1,1))}}else{const message="Tried to pop an empty stack";yield{type:"error",offset:this.offset,source:"",message:message}}}*stream(){switch(this.type){case"directive-line":return void(yield{type:"directive",offset:this.offset,source:this.source});case"byte-order-mark":case"space":case"comment":case"newline":return void(yield this.sourceToken);case"doc-mode":case"doc-start":{const doc={type:"document",offset:this.offset,start:[]};return"doc-start"===this.type&&doc.start.push(this.sourceToken),void this.stack.push(doc)}}yield{type:"error",offset:this.offset,message:`Unexpected ${this.type} token in YAML stream`,source:this.source}}*document(doc){if(doc.value)return yield*this.lineEnd(doc);switch(this.type){case"doc-start":return void(-1!==findNonEmptyIndex(doc.start)?(yield*this.pop(),yield*this.step()):doc.start.push(this.sourceToken));case"anchor":case"tag":case"space":case"comment":case"newline":return void doc.start.push(this.sourceToken)}const bv=this.startBlockValue(doc);bv?this.stack.push(bv):yield{type:"error",offset:this.offset,message:`Unexpected ${this.type} token in YAML document`,source:this.source}}*scalar(scalar){if("map-value-ind"===this.type){const start=getFirstKeyStartProps(getPrevProps(this.peek(2)));let sep;scalar.end?(sep=scalar.end,sep.push(this.sourceToken),delete scalar.end):sep=[this.sourceToken];const map={type:"block-map",offset:scalar.offset,indent:scalar.indent,items:[{start:start,key:scalar,sep:sep}]};this.onKeyLine=!0,this.stack[this.stack.length-1]=map}else yield*this.lineEnd(scalar)}*blockScalar(scalar){switch(this.type){case"space":case"comment":case"newline":return void scalar.props.push(this.sourceToken);case"scalar":if(scalar.source=this.source,this.atNewLine=!0,this.indent=0,this.onNewLine){let nl=this.source.indexOf("\n")+1;for(;0!==nl;)this.onNewLine(this.offset+nl),nl=this.source.indexOf("\n",nl)+1}yield*this.pop();break;default:yield*this.pop(),yield*this.step()}}*blockMap(map){const it=map.items[map.items.length-1];switch(this.type){case"newline":if(this.onKeyLine=!1,it.value){const end="end"in it.value?it.value.end:void 0,last=Array.isArray(end)?end[end.length-1]:void 0;"comment"===(null==last?void 0:last.type)?null==end||end.push(this.sourceToken):map.items.push({start:[this.sourceToken]})}else it.sep?it.sep.push(this.sourceToken):it.start.push(this.sourceToken);return;case"space":case"comment":if(it.value)map.items.push({start:[this.sourceToken]});else if(it.sep)it.sep.push(this.sourceToken);else{if(this.atIndentedComment(it.start,map.indent)){var _prev$value;const prev=map.items[map.items.length-2],end=null==prev||null===(_prev$value=prev.value)||void 0===_prev$value?void 0:_prev$value.end;if(Array.isArray(end))return Array.prototype.push.apply(end,it.start),end.push(this.sourceToken),void map.items.pop()}it.start.push(this.sourceToken)}return}if(this.indent>=map.indent){const atMapIndent=!this.onKeyLine&&this.indent===map.indent,atNextItem=atMapIndent&&(it.sep||it.explicitKey)&&"seq-item-ind"!==this.type;let start=[];if(atNextItem&&it.sep&&!it.value){const nl=[];for(let i=0;i<it.sep.length;++i){const st=it.sep[i];switch(st.type){case"newline":nl.push(i);break;case"space":break;case"comment":st.indent>map.indent&&(nl.length=0);break;default:nl.length=0}}nl.length>=2&&(start=it.sep.splice(nl[1]))}switch(this.type){case"anchor":case"tag":return void(atNextItem||it.value?(start.push(this.sourceToken),map.items.push({start:start}),this.onKeyLine=!0):it.sep?it.sep.push(this.sourceToken):it.start.push(this.sourceToken));case"explicit-key-ind":return it.sep||it.explicitKey?atNextItem||it.value?(start.push(this.sourceToken),map.items.push({start:start,explicitKey:!0})):this.stack.push({type:"block-map",offset:this.offset,indent:this.indent,items:[{start:[this.sourceToken],explicitKey:!0}]}):(it.start.push(this.sourceToken),it.explicitKey=!0),void(this.onKeyLine=!0);case"map-value-ind":if(it.explicitKey)if(it.sep)if(it.value)map.items.push({start:[],key:null,sep:[this.sourceToken]});else if(includesToken(it.sep,"map-value-ind"))this.stack.push({type:"block-map",offset:this.offset,indent:this.indent,items:[{start:start,key:null,sep:[this.sourceToken]}]});else if(isFlowToken(it.key)&&!includesToken(it.sep,"newline")){const start=getFirstKeyStartProps(it.start),key=it.key,sep=it.sep;sep.push(this.sourceToken),delete it.key,delete it.sep,this.stack.push({type:"block-map",offset:this.offset,indent:this.indent,items:[{start:start,key:key,sep:sep}]})}else start.length>0?it.sep=it.sep.concat(start,this.sourceToken):it.sep.push(this.sourceToken);else if(includesToken(it.start,"newline"))Object.assign(it,{key:null,sep:[this.sourceToken]});else{const start=getFirstKeyStartProps(it.start);this.stack.push({type:"block-map",offset:this.offset,indent:this.indent,items:[{start:start,key:null,sep:[this.sourceToken]}]})}else it.sep?it.value||atNextItem?map.items.push({start:start,key:null,sep:[this.sourceToken]}):includesToken(it.sep,"map-value-ind")?this.stack.push({type:"block-map",offset:this.offset,indent:this.indent,items:[{start:[],key:null,sep:[this.sourceToken]}]}):it.sep.push(this.sourceToken):Object.assign(it,{key:null,sep:[this.sourceToken]});return void(this.onKeyLine=!0);case"alias":case"scalar":case"single-quoted-scalar":case"double-quoted-scalar":{const fs=this.flowScalar(this.type);return void(atNextItem||it.value?(map.items.push({start:start,key:fs,sep:[]}),this.onKeyLine=!0):it.sep?this.stack.push(fs):(Object.assign(it,{key:fs,sep:[]}),this.onKeyLine=!0))}default:{const bv=this.startBlockValue(map);if(bv){if("block-seq"===bv.type){if(!it.explicitKey&&it.sep&&!includesToken(it.sep,"newline"))return void(yield*this.pop({type:"error",offset:this.offset,message:"Unexpected block-seq-ind on same line with key",source:this.source}))}else atMapIndent&&map.items.push({start:start});return void this.stack.push(bv)}}}}yield*this.pop(),yield*this.step()}*blockSequence(seq){const it=seq.items[seq.items.length-1];switch(this.type){case"newline":if(it.value){const end="end"in it.value?it.value.end:void 0,last=Array.isArray(end)?end[end.length-1]:void 0;"comment"===(null==last?void 0:last.type)?null==end||end.push(this.sourceToken):seq.items.push({start:[this.sourceToken]})}else it.start.push(this.sourceToken);return;case"space":case"comment":if(it.value)seq.items.push({start:[this.sourceToken]});else{if(this.atIndentedComment(it.start,seq.indent)){var _prev$value2;const prev=seq.items[seq.items.length-2],end=null==prev||null===(_prev$value2=prev.value)||void 0===_prev$value2?void 0:_prev$value2.end;if(Array.isArray(end))return Array.prototype.push.apply(end,it.start),end.push(this.sourceToken),void seq.items.pop()}it.start.push(this.sourceToken)}return;case"anchor":case"tag":if(it.value||this.indent<=seq.indent)break;return void it.start.push(this.sourceToken);case"seq-item-ind":if(this.indent!==seq.indent)break;return void(it.value||includesToken(it.start,"seq-item-ind")?seq.items.push({start:[this.sourceToken]}):it.start.push(this.sourceToken))}if(this.indent>seq.indent){const bv=this.startBlockValue(seq);if(bv)return void this.stack.push(bv)}yield*this.pop(),yield*this.step()}*flowCollection(fc){const it=fc.items[fc.items.length-1];if("flow-error-end"===this.type){let top;do{yield*this.pop(),top=this.peek(1)}while(top&&"flow-collection"===top.type)}else if(0===fc.end.length){switch(this.type){case"comma":case"explicit-key-ind":return void(!it||it.sep?fc.items.push({start:[this.sourceToken]}):it.start.push(this.sourceToken));case"map-value-ind":return void(!it||it.value?fc.items.push({start:[],key:null,sep:[this.sourceToken]}):it.sep?it.sep.push(this.sourceToken):Object.assign(it,{key:null,sep:[this.sourceToken]}));case"space":case"comment":case"newline":case"anchor":case"tag":return void(!it||it.value?fc.items.push({start:[this.sourceToken]}):it.sep?it.sep.push(this.sourceToken):it.start.push(this.sourceToken));case"alias":case"scalar":case"single-quoted-scalar":case"double-quoted-scalar":{const fs=this.flowScalar(this.type);return void(!it||it.value?fc.items.push({start:[],key:fs,sep:[]}):it.sep?this.stack.push(fs):Object.assign(it,{key:fs,sep:[]}))}case"flow-map-end":case"flow-seq-end":return void fc.end.push(this.sourceToken)}const bv=this.startBlockValue(fc);bv?this.stack.push(bv):(yield*this.pop(),yield*this.step())}else{const parent=this.peek(2);if("block-map"===parent.type&&("map-value-ind"===this.type&&parent.indent===fc.indent||"newline"===this.type&&!parent.items[parent.items.length-1].sep))yield*this.pop(),yield*this.step();else if("map-value-ind"===this.type&&"flow-collection"!==parent.type){const start=getFirstKeyStartProps(getPrevProps(parent));fixFlowSeqItems(fc);const sep=fc.end.splice(1,fc.end.length);sep.push(this.sourceToken);const map={type:"block-map",offset:fc.offset,indent:fc.indent,items:[{start:start,key:fc,sep:sep}]};this.onKeyLine=!0,this.stack[this.stack.length-1]=map}else yield*this.lineEnd(fc)}}flowScalar(type){if(this.onNewLine){let nl=this.source.indexOf("\n")+1;for(;0!==nl;)this.onNewLine(this.offset+nl),nl=this.source.indexOf("\n",nl)+1}return{type:type,offset:this.offset,indent:this.indent,source:this.source}}startBlockValue(parent){switch(this.type){case"alias":case"scalar":case"single-quoted-scalar":case"double-quoted-scalar":return this.flowScalar(this.type);case"block-scalar-header":return{type:"block-scalar",offset:this.offset,indent:this.indent,props:[this.sourceToken],source:""};case"flow-map-start":case"flow-seq-start":return{type:"flow-collection",offset:this.offset,indent:this.indent,start:this.sourceToken,items:[],end:[]};case"seq-item-ind":return{type:"block-seq",offset:this.offset,indent:this.indent,items:[{start:[this.sourceToken]}]};case"explicit-key-ind":{this.onKeyLine=!0;const start=getFirstKeyStartProps(getPrevProps(parent));return start.push(this.sourceToken),{type:"block-map",offset:this.offset,indent:this.indent,items:[{start:start,explicitKey:!0}]}}case"map-value-ind":{this.onKeyLine=!0;const start=getFirstKeyStartProps(getPrevProps(parent));return{type:"block-map",offset:this.offset,indent:this.indent,items:[{start:start,key:null,sep:[this.sourceToken]}]}}}return null}atIndentedComment(start,indent){return"comment"===this.type&&(!(this.indent<=indent)&&start.every((st=>"newline"===st.type||"space"===st.type)))}*documentEnd(docEnd){"doc-mode"!==this.type&&(docEnd.end?docEnd.end.push(this.sourceToken):docEnd.end=[this.sourceToken],"newline"===this.type&&(yield*this.pop()))}*lineEnd(token){switch(this.type){case"comma":case"doc-start":case"doc-end":case"flow-seq-end":case"flow-map-end":case"map-value-ind":yield*this.pop(),yield*this.step();break;case"newline":this.onKeyLine=!1;default:token.end?token.end.push(this.sourceToken):token.end=[this.sourceToken],"newline"===this.type&&(yield*this.pop())}}}function parseOptions(options){const prettyErrors=!1!==options.prettyErrors;return{lineCounter:options.lineCounter||prettyErrors&&new LineCounter||null,prettyErrors:prettyErrors}}}));

//# sourceMappingURL=yaml-lazy.min.js.map