define("tiny_widgethub/util",["exports"],(function(_exports){function evalInContext(ctx,expr,keepFns){const listArgs=[],listVals=[];ctx&&Object.keys(ctx).forEach((key=>{(keepFns||"function"!=typeof ctx[key])&&(listArgs.push(key),listVals.push(ctx[key]))})),listArgs.push("expr"),listArgs.push("return eval(expr)"),listVals.push(expr);return new Function(...listArgs)(...listVals)}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.addBaseToUrl=function(base,url){if((url=(url||"").trim()).toLowerCase().startsWith("http"))return url;return pathJoin(base,url)},_exports.applyWidgetFilterFactory=function(editor,coreStr){return async(widgetTemplate,silent,mergevars)=>{const translations=await coreStr.get_strings([{key:"filterres",component:"tiny_widgethub"},{key:"nochanges",component:"tiny_widgethub"}]),userWidgetFilter=createFilterFunction(widgetTemplate);if(!userWidgetFilter)return editor.notificationManager.open({text:translations[0]+": Invalid filter",type:"danger",timeout:4e3}),!1;const handleFilterResult=function(res){const out=res[0];let msg=res[1];null!=out?"string"==typeof out?(editor.setContent(out),editor.notificationManager.open({text:translations[0]+": "+msg,type:"success",timeout:5e3})):!0===out?editor.notificationManager.open({text:translations[0]+": "+msg,type:"success",timeout:5e3}):!1!==out||silent||editor.notificationManager.open({text:translations[1],type:"info",timeout:5e3}):silent||editor.notificationManager.open({text:translations[1],type:"info",timeout:5e3})},filteredResult=userWidgetFilter(editor.getContent(),editor,mergevars);return null!=filteredResult&&"object"==typeof filteredResult&&"then"in filteredResult?filteredResult.then(handleFilterResult).catch((err=>console.error(err))):handleFilterResult(filteredResult||[null,translations[1]]),!0}},_exports.capitalize=void 0,_exports.cleanParameterName=function(name){return name.replace(/\$/g,"_")},_exports.convertInt=function(str,def){if(str&&"number"==typeof str)return Math.floor(str);if(!str||!(str+"").trim()||!RegExp(/^\s*[+-]?\d+(\.\d*)?\s*$/).exec(str+""))return def;try{const val=parseInt(str+"");if(!isNaN(val))return val}catch(ex){}return def},_exports.createBinding=void 0,_exports.createFilterFunction=createFilterFunction,_exports.debounce=function(cb){let delay=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1e3,timeoutId=null;const debounced=function(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];timeoutId&&window.clearTimeout(timeoutId),timeoutId=window.setTimeout((()=>{cb(...args)}),delay)};return debounced.clear=()=>{timeoutId&&(window.clearTimeout(timeoutId),timeoutId=null)},debounced},_exports.evalInContext=evalInContext,_exports.findVariableByName=function(varname,listVars){if(!listVars)return null;let found=null;const len=listVars.length;let k=0;for(;k<len&&!found;)listVars[k].name===varname&&(found=listVars[k]),k++;return found},_exports.genID=
/**
   * Tiny WidgetHub plugin.
   *
   * @module      tiny_widgethub/plugin
   * @copyright   2024 Josep Mulet Pol <pep.mulet@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
function(){return"g"+Math.random().toString(32).substring(2)},_exports.hashCode=function(s){let h=0;const l=(s=s||"").length;let i=0;if(l>0)for(;i<l;)h=(h<<6)+(s.charCodeAt(i)-65|0),i++;return Math.abs(h)},_exports.pathJoin=pathJoin,_exports.performCasting=void 0,_exports.searchComp=function(str1,needle){return str1=(str1||"").trim().toLowerCase(),needle=(needle||"").trim().toLowerCase(),str1=str1.replace(/[àáâãäå]/,"a").replace(/[èéêë]/,"e").replace(/[ìíîï]/,"i").replace(/[òóôö]/,"o").replace(/[ùúüû]/,"u").replace(/ç/,"c").replace(/·/,""),needle=needle.replace(/[àáâãäå]/,"a").replace(/[èéêë]/,"e").replace(/[ìíîï]/,"i").replace(/[òóôö]/,"o").replace(/[ùúüû]/,"u").replace(/ç/,"c").replace(/·/,""),str1.indexOf(needle)>=0},_exports.stream=function(transformStr){return new Builder(transformStr)},_exports.toHexAlphaColor=function(color){color=(color||"#000000").trim().toLowerCase();let alpha=1;if(color.startsWith("#")&&9===color.length)alpha=parseInt("0x"+color.substring(7))/255,color=color.substring(0,7);else if(color.startsWith("rgb")){const sep=color.indexOf(",")>-1?",":" ",a=color.replace(/[^\d,]/g,"").split(sep);color="#"+((1<<24)+(+a[0]<<16)+(+a[1]<<8)+ +a[2]).toString(16).slice(1),4===a.length&&(alpha=+a[3],alpha>1&&(alpha*=.01))}return[color,alpha]},_exports.toRgba=function(hex,alpha){hex=(hex||"#000000").trim().toLowerCase();let alpha2=alpha??1;alpha2>1&&(alpha2*=.01);0!==alpha2&&1!==alpha2&&(alpha2=alpha2.toFixed(2));const result=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})/i.exec(hex);let r=0,g=0,b=0;result&&(r=parseInt(result[1],16),g=parseInt(result[2],16),b=parseInt(result[3],16));if(1===alpha)return`rgb(${r},${g},${b})`;return`rgba(${r},${g},${b},${alpha2})`},_exports.toggleClass=function(elem){const classList=elem.classList;for(var _len2=arguments.length,classNames=new Array(_len2>1?_len2-1:0),_key2=1;_key2<_len2;_key2++)classNames[_key2-1]=arguments[_key2];classNames.forEach((name=>{classList.contains(name)?classList.remove(name):classList.add(name)}))};const Transformers={toUpperCase:function(txt){return(txt+"").toUpperCase()},toLowerCase:function(txt){return(txt+"").toLowerCase()},trim:function(txt){return(txt+"").trim()},ytId:function(txt){const r=(txt||"").match(/^.*(?:(?:youtu\.be\/|v\/|vi\/|u\/\w\/|embed\/|shorts\/)|(?:(?:watch)?\?v(?:i)?=|&v(?:i)?=))([^#&?]*).*/);return null!=r&&r.length?r[1]:txt},vimeoId:function(txt){const match=new RegExp(/^.*(vimeo\.com\/)((channels\/[A-z]+\/)|(groups\/[A-z]+\/videos\/))?(\d+)/).exec(txt||"");return null!=match&&match[5]?match[5]:txt},serveGDrive:function(txt){const res=(txt+"").match(/https:\/\/drive.google.com\/file\/d\/([a-zA-Z0-9_]+)\//);if(null!=res&&res.length){return"https://docs.google.com/uc?export=open&id="+res[1]}return txt},removeHTML:function(txt){return(txt||"").replace(/<[^>]*>?/gm,"")},escapeHTML:function(txt){return(txt||"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")},encodeHTML:function(txt){return encodeURIComponent(txt||"")},escapeQuotes:function(txt){return(txt||"").replace(/"/gm,"'")}};class Builder{transSeq;constructor(transformStr){const parts=transformStr.split("|");this.transSeq=[];for(let j=0,lenj=parts.length;j<lenj;j++){const prts=parts[j].trim(),transfunc=Transformers[prts];null!=transfunc?this.transSeq.push(transfunc):console.error("Cannot find transformer named "+prts)}}reduce(text){for(let j=0,lenj=this.transSeq.length;j<lenj;j++){text=(0,this.transSeq[j])(text)}return text}}function createFilterFunction(filterCode){let userWidgetFilter=null;try{userWidgetFilter=new Function("text","editor","opts",filterCode)}catch(ex){userWidgetFilter=null,console.error(ex)}return userWidgetFilter}function pathJoin(a,b){return a=(a||"").trim(),b=(b||"").trim(),a.endsWith("/")||(a+="/"),b.startsWith("/")&&(b=b.substring(1)),a+b}const performCasting=function(value,type){if(!type||typeof value===type)return value;switch(type){case"boolean":value=1===value||"1"===value||!0===value||"true"===value;break;case"number":try{let parsed;parsed=(value+"").indexOf(".")<0?parseInt(value):parseFloat(value),isNaN(parsed)?(value=0,console.error(`Error parsing number ${value}`)):value=parsed}catch(ex){value=0,console.error(`Error parsing number ${value}`)}break;case"string":"object"==typeof value?value=JSON.stringify(value):value+="";break;default:console.error(`Fail to cast ${value} to ${type}`)}return value};_exports.performCasting=performCasting;const xor=function(a,b){return!a!=!b},replaceStrPart=function(str,match,replacement){if(!match.indices)return console.error("RegExp match does not include indices"),str;const[a,b]=match.indices[1];return str.substring(0,a)+replacement+str.substring(b)},getValueFromRegex=function(regexExpr,replacement){let capturingGroupCount=0;return regexExpr.replace(/\((?!\?:).*?\)/g,(()=>(capturingGroupCount++,1===capturingGroupCount?replacement+"":"")))},bindingFactory=function($e){const methods={hasClass:(className,query,neg)=>{let elem=$e;return query&&(elem=$e.find(query)),{getValue:()=>{const res=xor(neg,elem.hasClass(className));return Boolean(res)},setValue:bool=>{xor(neg,bool)?elem.addClass(className):elem.removeClass(className)}}},notHasClass:(className,query)=>methods.hasClass(className,query,!0),classRegex:(classExpr,query,castTo)=>{let elem=$e;return query&&(elem=$e.find(query)),{getValue:()=>{let ret="";const classes=(elem.attr("class")??"").split(" ");for(const clazz of classes){const match=new RegExp(classExpr).exec(clazz);if(null!=match&&match[1]&&"string"==typeof match[1]){ret=match[1];break}}return performCasting(ret,castTo)},setValue:val=>{var _elem$attr;const cl=(null===(_elem$attr=elem.attr("class"))||void 0===_elem$attr?void 0:_elem$attr.split(/\s+/))??[];let found=!1;if(cl.forEach((c=>{const match=new RegExp(classExpr,"d").exec(c);if(null===match)return;found=!0,elem.removeClass(c);const newCls=replaceStrPart(c,match,val+"");elem.addClass(newCls)})),!found){const newCls=getValueFromRegex(classExpr,val+"");elem.addClass(newCls)}}}},attr:(attrName,query,castTo)=>{let elem=$e;return query&&(elem=$e.find(query)),{getValue:()=>{let attrValue=elem.attr(attrName);return attrName.indexOf("-bs-")>0&&(attrValue=attrValue??elem.attr(attrName.replace("-bs-","-"))),performCasting(attrValue,castTo)},setValue:val=>{"boolean"==typeof val&&(val=val?1:0);const attrVal=val+"";elem.attr(attrName,attrVal),attrName.indexOf("-bs-")>0&&elem.attr(attrName.replace("-bs-","-"),attrVal),"href"!==attrName&&"src"!==attrName||elem.attr("data-mce-"+attrName,attrVal)}}},attrBS:(attrName,query,castTo,version)=>{let elem=$e;return query&&(elem=$e.find(query)),{getValue:()=>{let p1="",p2="bs-";5===version&&(p1=p2,p2="");let value=elem.attr("data-"+p1+attrName);return void 0===value&&(value=elem.attr("data-"+p2+attrName)),performCasting(value||"",castTo)},setValue:val=>{"boolean"==typeof val&&(val=val?1:0);const attrVal=val+"";elem.attr("data-bs-"+attrName,attrVal),5===version?elem.removeAttr("data-"+attrName):elem.attr("data-"+attrName,attrVal)}}},hasAttr:(attr,query,neg)=>{let elem=$e;query&&(elem=$e.find(query));const parts=attr.split("="),attrName=parts[0].trim();let attrValue="";return parts.length>1&&(attrValue=parts[1].trim()),{getValue:()=>{let found=null!=elem.attr(attrName);return attrValue&&(found=found&&elem.attr(attrName)===attrValue),xor(neg,found)},setValue:bool=>{xor(neg,bool)?(elem.attr(attrName,attrValue||""),"href"!==attrName&&"src"!==attrName||elem.attr("data-mce-"+attrName,attrValue+"")):(elem.removeAttr(attrName),"href"!==attrName&&"src"!==attrName||elem.removeAttr("data-mce-"+attrName))}}},hasAttrBS:(attr,query,neg,version)=>{let elem=$e;query&&(elem=$e.find(query));const parts=attr.split("="),attrName=parts[0].trim();let attrValue="";parts.length>1&&(attrValue=parts[1].trim());const getValuePrefix=prefix=>{let found=null!=elem.attr(prefix+attrName);return attrValue&&(found=found&&elem.attr(prefix+attrName)===attrValue),xor(neg,found)};return{getValue:()=>{let p1="data-",p2="data-bs-";return 5===version&&(p2=p1,p1="data-bs-"),getValuePrefix(p1)||getValuePrefix(p2)},setValue:bool=>{xor(neg,bool)?(elem.attr("data-bs-"+attrName,attrValue||""),5===version?elem.removeAttr("data-"+attrName):elem.attr("data-"+attrName,attrValue||"")):(elem.removeAttr("data-"+attrName),elem.removeAttr("data-bs-"+attrName))}}},notHasAttr:(attr,query)=>methods.hasAttr(attr,query,!0),attrRegex:function(attr,query,castTo){let elem=$e;query&&(elem=$e.find(query));const parts=attr.split("="),attrName=parts[0].trim();let attrValue="";return parts.length>1&&(attrValue=parts[1].trim()),{getValue(){if(null!=elem.attr(attrName)){var _elem$attr2;const match=null===(_elem$attr2=elem.attr(attrName))||void 0===_elem$attr2?void 0:_elem$attr2.match(attrValue);return null!=match&&match[1]&&"string"==typeof match[1]?performCasting(match[1],castTo):""}return null},setValue(val){const oldValue=elem.attr(attrName)??"",match=new RegExp(attrValue,"d").exec(oldValue);let newValue;newValue=match?replaceStrPart(oldValue,match,val+""):getValueFromRegex(attrValue,val+""),elem.attr(attrName,newValue),"href"!==attrName&&"src"!==attrName||elem.attr("data-mce-"+attrName,newValue+"")}}},hasStyle:function(sty,query,neg){let elem=$e;query&&(elem=$e.find(query));const parts=sty.split(":");let styValue,styName=parts[0].trim();return parts.length>1&&(styValue=parts[1].trim()),{getValue(){const pValue=elem.prop("style").getPropertyValue(styName);return xor(void 0===styValue?""!==pValue:pValue===styValue,neg)},setValue(bool){if(xor(bool,neg))elem.css(styName,styValue??"");else{elem.prop("style").removeProperty(styName)}elem.attr("data-mce-style",elem[0].style.cssText)}}},notHasStyle:(sty,query)=>methods.hasStyle(sty,query,!0),styleRegex:function(attr,query,castTo){let elem=$e;query&&(elem=$e.find(query));const parts=attr.split(":"),styName=parts[0].trim();let styValue="";return parts.length>1&&(styValue=parts[1].trim()),{getValue(){const st=elem.prop("style"),currentVal=null==st?void 0:st.getPropertyValue(styName);if(currentVal){if(!styValue)return performCasting(currentVal,castTo);{const match=new RegExp(styValue).exec(currentVal);if(null!=match&&match[1]&&"string"==typeof match[1])return performCasting(match[1],castTo)}}return performCasting("",castTo)},setValue(val){let newValue;if(styValue)if((styName.includes("width")||styName.includes("height"))&&parseFloat(val+"")<=0)newValue="";else{const oldValue=elem.prop("style").getPropertyValue(styName)??"";if(oldValue){const match=new RegExp(styValue,"d").exec(oldValue);newValue=replaceStrPart(oldValue,match,val+"")}else newValue=styValue.replace("(.*)",val+"")}else newValue=val+"";elem.css(styName,newValue),elem.attr("data-mce-style",elem[0].style.cssText)}}}};return methods};_exports.createBinding=(definition,elem,castTo)=>{let bindFn=null;return"string"==typeof definition?evalInContext({...bindingFactory(elem)},definition,!0):(bindFn={getValue:()=>{let v=evalInContext({elem:elem},`(${definition.get})(elem)`);return castTo&&(v=performCasting(v,castTo)),v},setValue:v=>evalInContext({elem:elem,v:v},`(${definition.set})(elem, v)`)},bindFn)};_exports.capitalize=s=>s&&s[0].toUpperCase()+s.slice(1)||""}));

//# sourceMappingURL=util.min.js.map