define("tiny_widgethub/widget_settings",["exports","jquery","./libs/ymleditor-lazy","./libs/yaml-lazy","core/str","./service/template_service","./options","./common"],(function(_exports,_jquery,_ymleditorLazy,_yamlLazy,_str,_template_service,_options,_common){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Tiny WidgetHub plugin.
   *
   * @module      tiny_widgethub/plugin
   * @copyright   2024 Josep Mulet Pol <pep.mulet@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */function needsBlock(str){return"string"==typeof str&&str.includes("\n")}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_ymleditorLazy=_interopRequireDefault(_ymleditorLazy),_common=_interopRequireDefault(_common);const{component:component}=_common.default,templateSrv=(0,_template_service.getTemplateSrv)();function replacePlaceholders(str){for(var _len=arguments.length,comodins=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++)comodins[_key-1]=arguments[_key];return str.replace(/@(\d+)/g,((match,index)=>{const i=parseInt(index,10);return void 0!==comodins[i-1]?comodins[i-1]:match}))}var _default={getAreas:function(id){return{$ymlArea:(0,_jquery.default)(`#id_s_${component}_defyml_${id}`),$jsonArea:(0,_jquery.default)(`#id_s_${component}_def_${id}`),$partialInput:(0,_jquery.default)(`#id_s_${component}_partials_${id}`)}},updateYaml:function(id,codeProEditor){const{$jsonArea:$jsonArea}=this.getAreas(id),json=(($jsonArea.val()??"")+"").trim();if(json)try{const _obj=JSON.parse(json),blockKeys={template:"BLOCK_LITERAL",filter:"BLOCK_LITERAL",instructions:"BLOCK_FOLDED"};for(const[key,style]of Object.entries(blockKeys))if(needsBlock(_obj[key])){const scalar=new _yamlLazy.Scalar(_obj[key]);scalar.type=style,"BLOCK_FOLDED"===style&&(scalar.chomping="CLIP"),_obj[key]=scalar}if(Array.isArray(_obj.parameters))for(const param of _obj.parameters)param.bind&&"object"==typeof param.bind&&["get","set"].forEach((key=>{needsBlock(param.bind[key])&&(param.bind[key]=new _yamlLazy.Scalar(param.bind[key]),param.bind[key].type="BLOCK_LITERAL")}));const yml=(0,_yamlLazy.stringify)(_obj,{indent:2});codeProEditor.setValue(yml)}catch(ex){console.error(ex),$jsonArea.val(""),codeProEditor.setValue("")}else id?codeProEditor.setValue(""):codeProEditor.setValue("key: username_sample-key\nname: Minimal sample widget\ncategory: Examples\ntemplate: |\n  <p><br></p>\n  <p>Write your template {{greeting}}</p>\n  <p><br></p>\nparameters:\n  - name: greeting\n    value: Hello world!\nauthor: Your name <email@site.com>\nversion: 1.0.0")},validate:async function(yml,opts,partials){const validation={msg:"",html:"",json:void 0};try{var _jsonObj,_jsonObj2;let jsonObj;try{jsonObj=(0,_yamlLazy.parse)(yml)}catch(ex){return validation.msg=await(0,_str.get_string)("erryaml",component)+":: "+ex,validation}if(validation.json=JSON.stringify(jsonObj,null,0),null!==(_jsonObj=jsonObj)&&void 0!==_jsonObj&&_jsonObj.key){if("partials"===jsonObj.key)return validation;"partials"!==jsonObj.key&&(jsonObj.name?jsonObj.template||jsonObj.filter?jsonObj.template&&jsonObj.filter?validation.msg+=await(0,_str.get_string)("errpropincompatible",component,"'template' & 'filter'")+" ":jsonObj.author&&jsonObj.version||(validation.msg+=await(0,_str.get_string)("errproprequired",component,"'author' & 'version'")+" "):validation.msg+=await(0,_str.get_string)("errproprequired",component,"'template' | 'filter'")+" ":validation.msg+=await(0,_str.get_string)("errproprequired",component,"'name'")+" ")}else validation.msg=await(0,_str.get_string)("errproprequired",component,"'key'")+" ";if(0===opts.id&&null!==(_jsonObj2=jsonObj)&&void 0!==_jsonObj2&&_jsonObj2.key){(opts.keys||[]).includes(jsonObj.key)&&(validation.msg+=await(0,_str.get_string)("errkeyinuse",component,jsonObj.key)+" ")}if((0,_options.applyPartials)(jsonObj,partials),jsonObj.template){var _jsonObj3,_jsonObj4;const stack=function(input){const withoutEJS=input.replace(/<%[\s\S]*?%>/g,""),selfClosing=new Set(["area","base","br","col","embed","hr","img","input","link","meta","source","track","wbr"]),tagRegex=/<\/?([a-zA-Z][a-zA-Z0-9]*)\b[^>]*>/g,stack=[];let match;for(;null!==(match=tagRegex.exec(withoutEJS));){const fullTag=match[0],tagName=match[1].toLowerCase(),isClosing=fullTag.startsWith("</");if(!selfClosing.has(tagName)&&!fullTag.endsWith("/>"))if(isClosing){if(0===stack.length||stack.pop()!==tagName)return 0===stack.length&&stack.push(tagName),stack}else stack.push(tagName)}return stack}(jsonObj.template);if(stack.length>0)return validation.msg+=await(0,_str.get_string)("errunbalancedhtml",component)+": "+stack,validation;const translations=(null===(_jsonObj3=jsonObj)||void 0===_jsonObj3?void 0:_jsonObj3.I18n)??{},ctx={};(jsonObj.parameters??[]).forEach((param=>{ctx[param.name]=param.value}));const engine=null===(_jsonObj4=jsonObj)||void 0===_jsonObj4?void 0:_jsonObj4.engine;try{var _jsonObj5;const html=await templateSrv.render((null===(_jsonObj5=jsonObj)||void 0===_jsonObj5?void 0:_jsonObj5.template)||"",ctx,translations,engine);validation.html=html}catch(ex0){validation.msg=await(0,_str.get_string)("errpreview",component)+":: "+ex0}}if(jsonObj.parameters){const errStr1=await(0,_str.get_string)("errparamtype",component),errStr2=await(0,_str.get_string)("errparamvalue",component);jsonObj.parameters.filter((p=>"select"===p.type||"autocomplete"===p.type||p.options)).forEach((p=>{if(p.options&&Array.isArray(p.options)){if("select"===p.type){const options=p.options.map((o=>"string"==typeof o?o:o.v));if(!p.value||options.indexOf(p.value)<0)return void(validation.msg+=replacePlaceholders(errStr2,p.name+".value","in options"))}}else validation.msg+=replacePlaceholders(errStr1,p.name+".options","Array")}))}}catch(ex){validation.msg=await(0,_str.get_string)("errunexpected",component)+":: "+ex}return validation},init:async function(opts){const{$ymlArea:$ymlArea,$jsonArea:$jsonArea,$partialInput:$partialInput}=this.getAreas(opts.id);$ymlArea.css({border:"1px solid gray"}),$ymlArea.addClass(component+"-loader");const i18n=await(0,_str.get_strings)([{key:"confirmdelete",component:component},{key:"delete",component:component},{key:"preview",component:component},{key:"savechanges",component:component}]),[confirmdeleteStr,deleteStr,previewStr,savechangesStr]=i18n,partials=JSON.parse($partialInput.val()||"{}");$jsonArea.css("display","none");const $target=$jsonArea.parent(),$form=$jsonArea.closest("form");$form.find('button[type="submit"], input[type="submit"]').hide();const $formButtons=(0,_jquery.default)(`<div class="row"><div class="form-buttons offset-sm-3 col-sm-3">\n            <button type="button" class="btn btn-primary form-submit">${savechangesStr}</button></div></div>`);$form.append($formButtons);const $saveBtn=$formButtons.find("button"),$previewPanel=(0,_jquery.default)(`<div id="${component}_pp_${opts.id}" class="${component}-previewpanel d-none"></div>`);$target.append($previewPanel);const $previewBtn=(0,_jquery.default)(`<button type="button" class="btn btn-secondary m-1">\n            <i class="fas fa fa-magnifying-glass"></i> ${previewStr}</button>`);if($previewBtn.on("click",(async()=>{const yml=ymleditor.getValue(),validation=await this.validate(yml,opts,partials);validation.json&&"partials"===JSON.parse(validation.json).key||(validation.msg?alert(validation.msg):validation.html&&($previewPanel.removeClass("d-none"),$jsonArea.trigger("focusin"),$jsonArea.val(validation.json??""),$jsonArea.trigger("change"),$previewPanel.html(validation.html)))})),$target.append($previewBtn),opts.id>0){const $deleteBtn=(0,_jquery.default)(`<button type="button" class="btn btn-outline-danger m-1">\n                <i class="fas fa fa-trash"></i> ${deleteStr}</button>`);$deleteBtn.on("click",(async()=>{confirm(confirmdeleteStr)&&($jsonArea.trigger("focusin"),$jsonArea.val(""),$jsonArea.trigger("change"),$ymlArea.val(""),$previewPanel.html(""),$form.trigger("submit"))})),$target.append($deleteBtn)}const ymleditor=new _ymleditorLazy.default($ymlArea[0]);$saveBtn.on("click",(async()=>{const yml=ymleditor.getValue(),validation=await this.validate(yml,opts,partials);validation.msg?alert(validation.msg):($jsonArea.trigger("focusin"),$jsonArea.val((validation.json??"")+" "),$jsonArea.trigger("change"),$form.trigger("submit"))})),this.updateYaml(opts.id,ymleditor),$ymlArea.removeClass(component+"-loader")}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=widget_settings.min.js.map