define("tiny_widgethub/libs/ejs-lazy",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;
/**
   * Tiny WidgetHub plugin.
   * An adaptation of the EJS templating engine as AMD module.
   *
   * @module      tiny_widgethub/plugin
   * @copyright   2024 Josep Mulet Pol <pep.mulet@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const utils={};!function(mod){const regExpChars=/[|\\{}()[\]^$+*?.]/g,hasOwnProperty=Object.prototype.hasOwnProperty,hasOwn=function(obj,key){return hasOwnProperty.apply(obj,[key])};mod.escapeRegExpChars=function(string){return string?String(string).replace(regExpChars,"\\$&"):""};const _ENCODE_HTML_RULES={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&#34;","'":"&#39;"},_MATCH_HTML=/[&<>'"]/g;function encode_char(c){return _ENCODE_HTML_RULES[c]||c}function escapeXMLToString(){return Function.prototype.toString.call(this)+';\nvar _ENCODE_HTML_RULES = {\n      "&": "&amp;"\n    , "<": "&lt;"\n    , ">": "&gt;"\n    , \'"\': "&#34;"\n    , "\'": "&#39;"\n    }\n  , _MATCH_HTML = /[&<>\'"]/g;\nfunction encode_char(c) {\n  return _ENCODE_HTML_RULES[c] || c;\n};\n'}mod.escapeXML=function(markup){return null==markup?"":String(markup).replace(_MATCH_HTML,encode_char)};try{"function"==typeof Object.defineProperty?Object.defineProperty(mod.escapeXML,"toString",{value:escapeXMLToString}):mod.escapeXML.toString=escapeXMLToString}catch(err){console.warn("Unable to set escapeXML.toString (is the Function prototype frozen?)")}mod.shallowCopy=function(to,from){if(from=from||{},null!=to)for(let p in from)hasOwn(from,p)&&"__proto__"!==p&&"constructor"!==p&&(to[p]=from[p]);return to},mod.shallowCopyFromList=function(to,from,list){if(list=list||[],from=from||{},null!=to)for(let i=0;i<list.length;i++){const p=list[i];if(void 0!==from[p]){if(!hasOwn(from,p))continue;if("__proto__"===p||"constructor"===p)continue;to[p]=from[p]}}return to},mod.cache={_data:{},set:function(key,val){this._data[key]=val},get:function(key){return this._data[key]},remove:function(key){delete this._data[key]},reset:function(){this._data={}}},mod.hyphenToCamel=function(str){return str.replace(/-[a-z]/g,(function(match){return match[1].toUpperCase()}))},mod.createNullProtoObjWherePossible="function"==typeof Object.create?function(){return Object.create(null)}:{__proto__:null}instanceof Object?function(){return{}}:function(){return{__proto__:null}},mod.hasOwnOnlyObject=function(obj){const o=mod.createNullProtoObjWherePossible();for(let p in obj)hasOwn(obj,p)&&(o[p]=obj[p]);return o}}(utils);
/**
   * @file Embedded JavaScript templating engine. {@link http://ejs.co}
   * @author Matthew Eernisse <mde@fleegix.org>
   * @author Tiancheng "Timothy" Gu <timothygu99@gmail.com>
   * @project EJS
   * @license {@link http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0}
   */
const EJS={},path={};let scopeOptionWarned=!1;const _OPTS_PASSABLE_WITH_DATA=["delimiter","scope","context","debug","compileDebug","client","_with","rmWhitespace","strict","filename","async"],_JS_IDENTIFIER=/^[a-zA-Z_$][0-9a-zA-Z_$]*$/;function handleCache(options,template){let func;const filename=options.filename,hasTemplate=arguments.length>1;if(!hasTemplate)throw new Error("Internal EJS error: a template must be provided");if(options.cache){if(!filename)throw new Error("cache option requires a filename");if(func=EJS.cache.get(filename),func)return func}return func=EJS.compile(template,options),options.cache&&EJS.cache.set(filename,func),func}function rethrow(err,str,flnm,lineno,esc){const lines=str.split("\n"),start=Math.max(lineno-3,0),end=Math.min(lines.length,lineno+3),filename=esc(flnm),context=lines.slice(start,end).map((function(line,i){const curr=i+start+1;return(curr==lineno?" >> ":"    ")+curr+"| "+line})).join("\n");throw err.path=filename,err.message=(filename||"ejs")+":"+lineno+"\n"+context+"\n\n"+err.message,err}function stripSemi(str){return str.replace(/;(\s*$)/,"$1")}function Template(text,optsParam){const opts=utils.hasOwnOnlyObject(optsParam),options=utils.createNullProtoObjWherePossible();this.templateText=text,this.mode=null,this.truncate=!1,this.currentLine=1,this.source="",options.client=opts.client||!1,options.escapeFunction=opts.escape||opts.escapeFunction||utils.escapeXML,options.compileDebug=!1!==opts.compileDebug,options.debug=!!opts.debug,options.filename=opts.filename,options.openDelimiter=opts.openDelimiter||EJS.openDelimiter||"<",options.closeDelimiter=opts.closeDelimiter||EJS.closeDelimiter||">",options.delimiter=opts.delimiter||EJS.delimiter||"%",options.strict=opts.strict||!1,options.context=opts.context,options.cache=opts.cache||!1,options.rmWhitespace=opts.rmWhitespace,options.root=opts.root,options.includer=opts.includer,options.outputFunctionName=opts.outputFunctionName,options.localsName=opts.localsName||EJS.localsName||"locals",options.views=opts.views,options.async=opts.async,options.destructuredLocals=opts.destructuredLocals,options.legacyInclude=void 0===opts.legacyInclude||!!opts.legacyInclude,options.strict?options._with=!1:options._with=void 0===opts._with||opts._with,this.opts=options,this.regex=this.createRegex()}EJS.cache=utils.cache,EJS.localsName="locals",EJS.promiseImpl=new Function("return this;")().Promise,EJS.compile=function(template,opts){let templ;return null!=opts&&opts.scope&&(scopeOptionWarned||(console.warn("`scope` option is deprecated and will be removed in EJS 3"),scopeOptionWarned=!0),opts.context||(opts.context=opts.scope),delete opts.scope),templ=new Template(template,opts),templ.compile()},EJS.render=function(template,d,o){const data=d||utils.createNullProtoObjWherePossible(),opts=o||utils.createNullProtoObjWherePossible();return 2==arguments.length&&utils.shallowCopyFromList(opts,data,_OPTS_PASSABLE_WITH_DATA),handleCache(opts,template)(data)},EJS.Template=Template,EJS.clearCache=function(){EJS.cache.reset()},Template.modes={EVAL:"eval",ESCAPED:"escaped",RAW:"raw",COMMENT:"comment",LITERAL:"literal"},Template.prototype={createRegex:function(){let str="(<%%|%%>|<%=|<%-|<%_|<%#|<%|%>|-%>|_%>)";const delim=utils.escapeRegExpChars(this.opts.delimiter),open=utils.escapeRegExpChars(this.opts.openDelimiter),close=utils.escapeRegExpChars(this.opts.closeDelimiter);return str=str.replace(/%/g,delim).replace(/</g,open).replace(/>/g,close),new RegExp(str)},compile:function(){let src,fn;const opts=this.opts;let prepended="",appended="";const escapeFn=opts.escapeFunction;let Ctor;const sanitizedFilename=opts.filename?JSON.stringify(opts.filename):"undefined";if(!this.source){var _opts$destructuredLoc;if(this.generateSource(),prepended+='  var __output = "";\n  function __append(s) { if (s !== undefined && s !== null) __output += s }\n',opts.outputFunctionName){if(!_JS_IDENTIFIER.test(opts.outputFunctionName))throw new Error("outputFunctionName is not a valid JS identifier.");prepended+="  var "+opts.outputFunctionName+" = __append;\n"}if(opts.localsName&&!_JS_IDENTIFIER.test(opts.localsName))throw new Error("localsName is not a valid JS identifier.");if(null!==(_opts$destructuredLoc=opts.destructuredLocals)&&void 0!==_opts$destructuredLoc&&_opts$destructuredLoc.length){let destructuring="  var __locals = ("+opts.localsName+" || {}),\n";for(let i=0;i<opts.destructuredLocals.length;i++){const name=opts.destructuredLocals[i];if(!_JS_IDENTIFIER.test(name))throw new Error("destructuredLocals["+i+"] is not a valid JS identifier.");i>0&&(destructuring+=",\n  "),destructuring+=name+" = __locals."+name}prepended+=destructuring+";\n"}!1!==opts._with&&(prepended+="  with ("+opts.localsName+" || {}) {\n",appended+="  }\n"),appended+="  return __output;\n",this.source=prepended+this.source+appended}src=opts.compileDebug?"var __line = 1\n  , __lines = "+JSON.stringify(this.templateText)+"\n  , __filename = "+sanitizedFilename+";\ntry {\n"+this.source+"} catch (e) {\n  rethrow(e, __lines, __filename, __line, escapeFn);\n}\n":this.source,opts.client&&(src="escapeFn = escapeFn || "+escapeFn.toString()+";\n"+src,opts.compileDebug&&(src="rethrow = rethrow || "+rethrow.toString()+";\n"+src)),opts.strict&&(src='"use strict";\n'+src),opts.debug&&console.log(src),opts.compileDebug&&opts.filename&&(src=src+"\n//# sourceURL="+sanitizedFilename+"\n");try{if(opts.async)try{Ctor=new Function("return (async function(){}).constructor;")()}catch(e){throw e instanceof SyntaxError?new Error("This environment does not support async/await"):e}else Ctor=Function;fn=new Ctor(opts.localsName+", escapeFn, include, rethrow",src)}catch(e){throw e instanceof SyntaxError&&(opts.filename&&(e.message+=" in "+opts.filename),e.message+=" while compiling ejs\n\n",e.message+="If the above error is not helpful, you may want to try EJS-Lint:\n",e.message+="https://github.com/RyanZim/EJS-Lint",opts.async||(e.message+="\n",e.message+="Or, if you meant to create an async function, pass `async: true` as an option.")),e}const returnedFn=opts.client?fn:function(data){return fn.apply(opts.context,[data||utils.createNullProtoObjWherePossible(),escapeFn,function(path,includeData){let d=utils.shallowCopy(utils.createNullProtoObjWherePossible(),data);return includeData&&(d=utils.shallowCopy(d,includeData)),function(path,options){const opts=utils.shallowCopy(utils.createNullProtoObjWherePossible(),options);if(opts.filename=path+"/"+options.filename,"function"==typeof options.includer){const includerResult=options.includer(path,opts.filename);if(includerResult&&(includerResult.filename&&(opts.filename=includerResult.filename),includerResult.template))return handleCache(opts,includerResult.template)}return handleCache(opts)}(path,opts)(d)},rethrow])};if(opts.filename&&"function"==typeof Object.defineProperty){const filename=opts.filename,basename=path.basename(filename,path.extname(filename));try{Object.defineProperty(returnedFn,"name",{value:basename,writable:!1,enumerable:!1,configurable:!0})}catch(e){}}return returnedFn},generateSource:function(){this.opts.rmWhitespace&&(this.templateText=this.templateText.replace(/[\r\n]+/g,"\n").replace(/^\s+|\s+$/gm,"")),this.templateText=this.templateText.replace(/[ \t]*<%_/gm,"<%_").replace(/_%>[ \t]*/gm,"_%>");const self=this,matches=this.parseTemplateText(),d=this.opts.delimiter,o=this.opts.openDelimiter,c=this.opts.closeDelimiter;null!=matches&&matches.length&&matches.forEach((function(line,index){let closing;if(line.startsWith(o+d)&&!line.startsWith(o+d+d)&&(closing=matches[index+2],closing!=d+c&&closing!="-"+d+c&&closing!="_"+d+c))throw new Error('Could not find matching close tag for "'+line+'".');self.scanLine(line)}))},parseTemplateText:function(){let str=this.templateText;const pat=this.regex;let result=pat.exec(str);const arr=[];let firstPos;for(;result;)firstPos=result.index,0!==firstPos&&(arr.push(str.substring(0,firstPos)),str=str.slice(firstPos)),arr.push(result[0]),str=str.slice(result[0].length),result=pat.exec(str);return str&&arr.push(str),arr},_addOutput:function(line){if(this.truncate&&(line=line.replace(/^(?:\r\n|\r|\n)/,""),this.truncate=!1),!line)return line;line=(line=(line=(line=line.replace(/\\/g,"\\\\")).replace(/\n/g,"\\n")).replace(/\r/g,"\\r")).replace(/"/g,'\\"'),this.source+='    ; __append("'+line+'")\n'},scanLine:function(line){const d=this.opts.delimiter,o=this.opts.openDelimiter,c=this.opts.closeDelimiter;let newLineCount=0;switch(newLineCount=line.split("\n").length-1,line){case o+d:case o+d+"_":this.mode=Template.modes.EVAL;break;case o+d+"=":this.mode=Template.modes.ESCAPED;break;case o+d+"-":this.mode=Template.modes.RAW;break;case o+d+"#":this.mode=Template.modes.COMMENT;break;case o+d+d:this.mode=Template.modes.LITERAL,this.source+='    ; __append("'+line.replace(o+d+d,o+d)+'")\n';break;case d+d+c:this.mode=Template.modes.LITERAL,this.source+='    ; __append("'+line.replace(d+d+c,d+c)+'")\n';break;case d+c:case"-"+d+c:case"_"+d+c:this.mode==Template.modes.LITERAL&&this._addOutput(line),this.mode=null,this.truncate=0===line.indexOf("-")||0===line.indexOf("_");break;default:if(this.mode){switch(this.mode){case Template.modes.EVAL:case Template.modes.ESCAPED:case Template.modes.RAW:line.lastIndexOf("//")>line.lastIndexOf("\n")&&(line+="\n")}switch(this.mode){case Template.modes.EVAL:this.source+="    ; "+line+"\n";break;case Template.modes.ESCAPED:this.source+="    ; __append(escapeFn("+stripSemi(line)+"))\n";break;case Template.modes.RAW:this.source+="    ; __append("+stripSemi(line)+")\n";break;case Template.modes.COMMENT:break;case Template.modes.LITERAL:this._addOutput(line)}}else this._addOutput(line)}this.opts.compileDebug&&newLineCount&&(this.currentLine+=newLineCount,this.source+="    ; __line = "+this.currentLine+"\n")}},EJS.escapeXML=utils.escapeXML,EJS.VERSION="3.1.10",EJS.name="ejs";var _default=EJS;return _exports.default=_default,_exports.default}));

//# sourceMappingURL=ejs-lazy.min.js.map