<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This is a comment for translators.
 * AMOS: Strings beginning with "bs..." and "ib..." are used only during the installation or update process.
 * Once widget definitions are stored in the database, they retain the site's default language that was set
 * during installation.
 *
 * Tiny WidgetHub plugin version details.
 *
 * @package     tiny_widgethub
 * @copyright   2024 Josep Mulet <pep.mulet@gmail.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
$string['accept'] = 'Accept';
$string['additionalcss'] = 'Additional CSS for the editor iframe';
$string['bsalert_closable_title'] = 'Closable';
$string['bsalert_name'] = 'Alert container';
$string['bsalert_severity_title'] = 'Type of alert';
$string['bsbadge_name'] = 'Badge';
$string['bsbadge_pill_title'] = 'Make badge rounded';
$string['bsbadge_severity_title'] = 'Type of badge';
$string['bscardgroup_cardtitle'] = 'Card title';
$string['bscardgroup_instructions'] = 'Use card groups to render cards as a single, attached element with equal width and height columns.';
$string['bscardgroup_name'] = 'Card group';
$string['bscardgroup_number'] = 'Number of cards';
$string['bscarousel_imgs'] = 'Images';
$string['bscarousel_name'] = 'Carousel';
$string['bscarousel_slide'] = 'Slide';
$string['bscarousel_usecaptions'] = 'Include image captions?';
$string['bscollapsible_indp'] = 'Independent collapsibles?';
$string['bscollapsible_indp_tip'] = 'When this options is checked, several cards can be expanded simultaneously';
$string['bscollapsible_label'] = 'Label';
$string['bscollapsible_name'] = 'Collapsible';
$string['bscollapsible_number'] = 'Number of collapsibles';
$string['bscolumns_instructions'] = 'Adds a responsive two columns layout';
$string['bscolumns_name'] = 'Responsive columns';
$string['bscolumns_width'] = 'Width of the first column';
$string['bscolumns_width_tip'] = 'The remaining space is assigned to the second column';
$string['bsfigure_caption'] = 'Figure: A caption for the above image.';
$string['bsfigure_instructions'] = 'Documentation and examples for displaying related images and text with the figure component in Bootstrap.';
$string['bsfigure_name'] = 'Figure';
$string['bsimageoverlay_img'] = 'Background image';
$string['bsimageoverlay_instructions'] = 'Turn an image into a card background and overlay your card\'s text.';
$string['bsimageoverlay_name'] = 'Image overlay';
$string['bslistgroup_badges'] = 'Include badges?';
$string['bslistgroup_instructions'] = 'The most basic list group is an unordered list with list items and the proper classes.';
$string['bslistgroup_name'] = 'List group';
$string['bslistgroup_number'] = 'Number of items';
$string['bspopover_anotation'] = 'Content of popover';
$string['bspopover_anotation_tip'] = 'You can write basic HTML content';
$string['bspopover_instructions'] = 'Add a popover annotation to a word/s. It is activated when the mouse is clicked.';
$string['bspopover_placement'] = 'Popover placement';
$string['bspopover_title'] = 'Title of popover';
$string['bspopover_title_tip'] = 'This parameter is optional. If you add it, the title will appear above the balloon';
$string['bspopover_word'] = 'Word';
$string['bspopover_word_tip'] = 'When you click on this word, the balloon will appear';
$string['bstable_borders'] = 'Show borders';
$string['bstable_cell'] = 'Cell';
$string['bstable_foot'] = 'Foot';
$string['bstable_footer'] = 'Include footer';
$string['bstable_headers'] = 'Include headers';
$string['bstable_hover'] = 'Highlight row on mouse over';
$string['bstable_instructions'] = 'Create a table with n rows and m columns';
$string['bstable_name'] = 'Bootstrap table';
$string['bstable_ncols'] = 'Number of columns';
$string['bstable_nrows'] = 'Number of rows';
$string['bstable_responsive'] = 'Responsive behaviour';
$string['bstable_stripes'] = 'Show stripes';
$string['bstable_stripes_tip'] = 'Odd rows will be rendered with gray background';
$string['bstable_table'] = 'Table';
$string['bstable_title'] = 'Title';
$string['bstabs_effect'] = 'Transition effect';
$string['bstabs_instructions'] = 'Create a tab menu. You can define the number of tabs (<b>at least 2</b>).';
$string['bstabs_name'] = 'Tabs menu';
$string['bstabs_optionsfade'] = 'Fade';
$string['bstabs_optionsnone'] = 'None';
$string['bstabs_tabs'] = 'Number of tabs';
$string['bstabs_tabs_tip'] = 'An excessive number of tabs can cause visualization problems on mobile devices.';
$string['cancel'] = 'Cancel';
$string['cfg'] = 'Additional settings';
$string['configuration'] = 'Configuration';
$string['confirmdelete'] = 'Do you want to delete this widget?';
$string['confirmusage'] = 'This widget is not suitable for the current page. Do you want to continue?';
$string['createwidget'] = 'Create new widget';
$string['def'] = 'Yml definition';
$string['def_desc'] = 'Yaml definition of the widget';
$string['delete'] = 'Delete';
$string['dialogtitle'] = 'Select a widget';
$string['directinsert'] = 'Insert directly';
$string['edit'] = 'Edit';
$string['emptylist'] = 'No widgets have been found for the search criteria';
$string['errkeyinuse'] = 'Key {$a} is already in use. Please rename it';
$string['errparamtype'] = 'Parameter @1 must be of type @2';
$string['errparamvalue'] = 'Parameter @1 must have a value @2';
$string['errpreview'] = 'An error occurred while rendering the preview';
$string['errpropincompatible'] = 'The properties {$a} cannot be used simultaneously';
$string['errproprequired'] = 'The properties {$a} are required';
$string['errunbalancedhtml'] = 'Unbalanced HTML tags in the template';
$string['errunexpected'] = 'Unexpected error';
$string['errversionmismatch'] = 'Widget requires at least release {$a->required}. Installed {$a->installed}.';
$string['erryaml'] = 'Yaml syntax error';
$string['filterres'] = 'Result of the filter';
$string['generalsettings'] = 'General settings';
$string['helplinktext'] = 'WidgetHub';
$string['ibcolors_background'] = 'Background color';
$string['ibcolors_category'] = 'Styles';
$string['ibcolors_front'] = 'Foreground color';
$string['ibcolors_name'] = 'Foreground and background colors';
$string['ibcolors_sample'] = 'Sample text';
$string['ibfragment_instructions'] = 'Use this component to insert a text excerpt from a book. If you want to reduce the width, you can set a maximum width, e.g., 400px.';
$string['ibfragment_lang'] = 'Language';
$string['ibfragment_maxwidth'] = 'Maximum width (px)';
$string['ibfragment_maxwidth_tip'] = 'For example, 500. If you don\'t want to limit the width, leave it as 0.';
$string['ibfragment_name'] = 'Text snippet';
$string['ibfragment_notranslate'] = 'Prevent translation by Google';
$string['ibiframe_code'] = 'HTML Code';
$string['ibiframe_instructions'] = 'This snippet allows you to insert the HTML code for an iFrame at a specific point in the document.';
$string['ibiframe_name'] = 'Insert iFrame/HTML';
$string['ibimgbg_category'] = 'Image';
$string['ibimgbg_instructions'] = 'It allows you to create a header with an image that fills the background of a container.';
$string['ibimgbg_name'] = 'Text onto image background';
$string['ibimgbg_url'] = 'Image URL';
$string['ibimgbg_url_tip'] = 'You can also upload an image to your course and link it here.';
$string['ibquote_author'] = 'Author of the quote';
$string['ibquote_instructions'] = 'Use this snippet to quote a famous (short) phrase by an author.';
$string['ibquote_name'] = 'Quote';
$string['ibquote_notranslate'] = 'Prevent translation by Google';
$string['ibsection_instructions'] = 'Create a section within a page or a Moodle book. The title should not end with a period.';
$string['ibsection_name'] = 'Page Section';
$string['ibsection_title'] = 'Section title';
$string['ibtime_hours'] = 'Hours';
$string['ibtime_instructions'] = 'This snippet is used to recommend a minimum dedication time for a resource. Preferably use multiples of 15 for the minutes.';
$string['ibtime_min'] = 'Minutes';
$string['ibtime_min_tip'] = 'Preferably round to multiples of 10 minutes';
$string['ibtime_name'] = 'Dedication Time';
$string['ibtime_title'] = 'Description';
$string['ibtime_title_tip'] = 'This message will appear as a tooltip';
$string['ibtime_title_value'] = 'Minimum recommended dedication time for this page.';
$string['ibvgdrive_category'] = 'Video';
$string['ibvgdrive_iframecode'] = 'Iframe code';
$string['ibvgdrive_iframecode_tip'] = 'Paste the iframe code you obtained from sharing on Drive.';
$string['ibvgdrive_instructions'] = 'Embed a video that the user has previously shared from its Google Drive. Enter the iframe share code and optionally a title.';
$string['ibvgdrive_name'] = 'Video Google Drive';
$string['ibvgdrive_title_value'] = 'Write a title';
$string['ibvimeo_startsec'] = 'Start playback at seconds';
$string['ibvimeo_startsec_tip'] = 'Set to 0 to start from the beginning of the video.';
$string['ibvimeo_vimeoid'] = 'Video URL or ID';
$string['ibvimeo_vimeoid_tip'] = 'You can enter the full URL or just the numeric video ID.';
$string['ibwc_instructions'] = 'This is an example widget that shows how to integrate javascript.';
$string['ibwc_name'] = 'Show the number of words';
$string['ibyoutube_endsec'] = 'End playback at second';
$string['ibyoutube_endsec_tip'] = 'Keep this at 0 if you want the video to play until the end';
$string['ibyoutube_instructions'] = 'Embed a YouTube video responsively on the page. Enter the YouTube video ID and optionally a title. You can trim a part of the video with the start and end parameters given in seconds.';
$string['ibyoutube_ytid_tip'] = 'You can paste the full URL or just the YouTube video ID';
$string['insert'] = 'Insert';
$string['invalidfilter'] = 'Invalid filter. Please check the configuration';
$string['key'] = 'Key';
$string['misc'] = 'Others';
$string['moveafter'] = 'Move after';
$string['movebefore'] = 'Move before';
$string['movedown'] = 'Move down';
$string['moveup'] = 'Move up';
$string['name'] = 'Name';
$string['nochanges'] = 'The filter has applied no changes';
$string['pluginname'] = 'WidgetHub';
$string['preview'] = 'Preview';
$string['printable'] = 'Printable';
$string['privacy:metadata'] = 'This plugin does not store personal data.';
$string['properties'] = 'Properties';
$string['recents'] = 'Recent';
$string['remove'] = 'Remove';
$string['rmfilter'] = 'Clear search filter';
$string['savechanges'] = 'Save changes';
$string['saverequired'] = 'Some widgets have been optimized. Please save changes.';
$string['selectmode'] = 'Selection mode';
$string['settings'] = 'WidgetHub component';
$string['sharecss'] = 'Share the site CSS within the editor\'s iframe';
$string['unwrap'] = 'Unwrap';
$string['viewplugin'] = 'View widgethub plugin';
$string['widget'] = 'Widget';
$string['widgethub:use'] = 'View plugin';
$string['widgethub:viewplugin'] = 'View plugin';
$string['widgets'] = 'Widgets';
$string['wsearch'] = 'Search widgets ...';
