/**
 * Handles the dashboard interactions for tutor follow-up data.
 *
 * @module     tool_tutor_follow/div2
 * @package    tool_tutor_follow
 * @copyright  2025 Jhon Rangel Ardila
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_tutor_follow/div2",["jquery","core/ajax","core/notification","tool_tutor_follow/charts","core/str","core/yui","core_form/modalform"],(function($,ajax,notification,chartModule,Str,Y,ModalForm){return{init:function(){$(".more-info").click(async function(event){const number=event.currentTarget.id,options={methodname:"tool_tutor_follow_get_data_course_for_user",args:{id:number}},response=await ajax.call([options])[0],userObject=JSON.parse(response);this.executeStudentGraph(userObject,number)}.bind(this))},executeStudentGraph:async function(obj,idnumber){$(".data-body").empty();const results=await Str.get_strings([{key:"close",component:"tool_tutor_follow"},{key:"distributionstudents",component:"tool_tutor_follow"},{key:"number",component:"tool_tutor_follow"},{key:"shortname",component:"tool_tutor_follow"},{key:"course",component:"tool_tutor_follow"},{key:"studentscount",component:"tool_tutor_follow"},{key:"students",component:"tool_tutor_follow"}]),[closeText,distributionText,numberText,shortnameText,courseText,studentsCountText,studentsText]=results;$(".data-body").append(`\n                <div class="w-100 align-items-end">\n                    <div type="button" class="btn btn-danger btn-close-students">\n                        <i class="fas fa-times"></i> ${closeText}\n                    </div>\n                </div>`);let chart=$(`\n                <h4 class="text-primary">${distributionText} ${obj.firstname} ${obj.lastname}</h4>\n                <div class="container">\n                    <canvas id="firstchart"></canvas>\n                </div>`);$(".data-body").append(chart);const fullnames=obj.cursos.map((course=>course.fullname)),students=obj.cursos.map((course=>course.students)),shortnames=obj.cursos.map((course=>course.shortname)),chartData={type:"pie",series:[{label:studentsText,labels:fullnames,values:students,colors:[],axes:{x:null,y:null},smooth:null}],labels:fullnames,title:`${obj.firstname} ${obj.lastname}`,axes:{x:[],y:[]},config_colorset:null,doughnut:null};chartModule.print_chart(chartData,"firstchart");const numeros=Array.from({length:fullnames.length},((v,k)=>k+1));chartModule.print_table_data(".data-body",[numberText,shortnameText,courseText,studentsCountText],[numeros,shortnames,fullnames,students]),$(".btn-close-students").click(function(event){this.calification_btn(event)}.bind(this))},calification_btn:function(e){$(".data-body").fadeOut(400,(function(){$(this).empty().fadeIn(400)}))}}}));

//# sourceMappingURL=div2.min.js.map