/* Version 0.92 */
/*
    Copyright 2008-2011
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with JSXGraph.  If not, see <http://www.gnu.org/licenses/>.
*/
    var JXG={};(function(){var d,e;JXG.countDrawings=0;JXG.countTime=0;JXG.require=function(f){};JXG.rendererFiles=[];JXG.rendererFiles.svg="SVGRenderer";JXG.rendererFiles.vml="VMLRenderer";JXG.rendererFiles.canvas="CanvasRenderer";JXG.baseFiles=null;JXG.requirePath="";for(d=0;d<document.getElementsByTagName("script").length;d++){e=document.getElementsByTagName("script")[d];if(e.src&&e.src.match(/loadjsxgraphInOneFile\.js(\?.*)?$/)){JXG.requirePath=e.src.replace(/loadjsxgraphInOneFile\.js(\?.*)?$/,"")}}JXG.serverBase=JXG.requirePath+"server/"})();JXG.extend=function(d,j,f,i){var h,g;f=f||false;i=i||false;for(h in j){if(!f||(f&&j.hasOwnProperty(h))){if(i){g=h.toLowerCase()}else{g=h}d[g]=j[h]}}};JXG.shortcut=function(e,d){return function(){return e[d].apply(this,arguments)}};JXG.extend(JXG,{supportsVML:function(){return !!document.namespaces},supportsSVG:function(){return document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1")},supportsCanvas:function(){return !!document.createElement("canvas").getContext},isAndroid:function(){return navigator.userAgent.toLowerCase().search("android")>-1},isWebkitAndroid:function(){return this.isAndroid()&&navigator.userAgent.search(" AppleWebKit/")>-1},getReference:function(e,d){if(typeof(d)=="string"){if(JXG.exists(e.objects[d])){d=e.objects[d]}else{if(JXG.exists(e.elementsByName[d])){d=e.elementsByName[d]}else{if(JXG.exists(e.groups[d])){d=e.groups[d]}}}}return d},getRef:JXG.shortcut(JXG,"getReference"),isString:function(d){return typeof d==="string"},isNumber:function(d){return typeof d==="number"},isFunction:function(d){return typeof d==="function"},isArray:function(d){return d!==null&&typeof d==="object"&&"splice" in d&&"join" in d},isPoint:function(d){if(typeof d=="object"){return(d.elementClass==JXG.OBJECT_CLASS_POINT)}return false},exists:(function(d){return function(e){return !(e===d||e===null)}})(),str2Bool:function(d){if(!JXG.exists(d)){return true}if(typeof d=="boolean"){return d}return(d.toLowerCase()=="true")},_board:function(e,d){return JXG.JSXGraph.initBoard(e,d)},createEvalFunction:function(e,j,k){var g=[],d,h;for(d=0;d<k;d++){if(typeof j[d]=="string"){h=JXG.GeonextParser.geonext2JS(j[d],e);h=h.replace(/this\.board\./g,"board.");g[d]=new Function("","return "+(h)+";")}}return function(i){var f=j[i];if(typeof f=="string"){return g[i]()}else{if(typeof f=="function"){return f()}else{if(typeof f=="number"){return f}}}return 0}},createFunction:function(e,f,g,h){var d;if((h==null||h)&&JXG.isString(e)){d=JXG.GeonextParser.geonext2JS(e,f);return new Function(g,"return "+d+";")}else{if(JXG.isFunction(e)){return e}else{if(JXG.isNumber(e)){return function(){return e}}else{if(JXG.isString(e)){return function(){return e}}}}}return null},checkParents:function(f,o,n){var g,e,d,l,p=[],m=o.slice(0),h=function(j,i){var k=(typeof j).toLowerCase();if(k==="number"){return i&&((i.type&&i.type===j)||(i.elementClass&&i.elementClass===j))}else{switch(j.toLowerCase()){case"string":case"object":case"function":case"number":return(typeof i).toLowerCase()===j.toLowerCase();break;case"array":return JXG.isArray(i);break}}return false};for(g=0;g<n.length;g++){for(e=0;e<n[g].length&&o.length>=n[g].length;e++){d=0;while(d<m.length&&!h(n[g][e],m[d])){d++}if(d<m.length){p.push(m.splice(l-d-1,1)[0])}}if(m.length){m=o.slice(0);p=[]}else{return p}}},readOption:function(d,f,e){var g=d.elements[e];if(JXG.exists(d[f][e])){g=d[f][e]}return g},checkAttributes:function(d,f){var e;if(!JXG.exists(d)){d={}}for(e in f){if(!JXG.exists(d[e])){d[e]=f[e]}}return d},copyAttributes:function(f,g){var e,h,d,k,j;e=this.deepCopy(g.elements,null,true);d=arguments.length;if(d<4&&this.exists(arguments[2])&&this.exists(g.layer[arguments[2]])){e.layer=g.layer[arguments[2]]}k=g;j=true;for(h=2;h<d;h++){if(JXG.exists(k[arguments[h]])){k=k[arguments[h]]}else{j=false;break}}if(j){e=this.deepCopy(e,k,true)}k=f;j=true;for(h=3;h<d;h++){if(JXG.exists(k[arguments[h]])){k=k[arguments[h]]}else{j=false;break}}if(j){this.extend(e,k,null,true)}return e},getDimensions:function(i){var h,k,f,l,j,e,d,g;h=document.getElementById(i);if(!JXG.exists(h)){throw new Error("\nJSXGraph: HTML container element '"+(i)+"' not found.")}k=h.style.display;if(k!="none"&&k!=null){return{width:h.offsetWidth,height:h.offsetHeight}}f=h.style;l=f.visibility;j=f.position;e=f.display;f.visibility="hidden";f.position="absolute";f.display="block";d=h.clientWidth;g=h.clientHeight;f.display=e;f.position=j;f.visibility=l;return{width:d,height:g}},addEvent:function(g,f,e,d){d["x_internal"+f]=function(){return e.apply(d,arguments)};if(JXG.exists(g.addEventListener)){g.addEventListener(f,d["x_internal"+f],false)}else{g.attachEvent("on"+f,d["x_internal"+f])}},removeEvent:function(i,g,f,d){try{if(JXG.exists(i.addEventListener)){i.removeEventListener(g,d["x_internal"+g],false)}else{i.detachEvent("on"+g,d["x_internal"+g])}}catch(h){JXG.debug("JSXGraph: Can't remove event listener on"+g+": "+d["x_internal"+g])}},bind:function(e,d){return function(){return e.apply(d,arguments)}},getPosition:function(g,f){var d=0,h=0;if(!g){g=window.event}if(JXG.exists(f)){g=g.targetTouches[f]}if(g.pageX||g.pageY){d=g.pageX;h=g.pageY}else{if(g.clientX||g.clientY){d=g.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;h=g.clientY+document.body.scrollTop+document.documentElement.scrollTop}}return[d,h]},getOffset:function(g){var h=g,f=g,d=h.offsetLeft-h.scrollLeft,e=h.offsetTop-h.scrollTop;while(h=h.offsetParent){d+=h.offsetLeft;e+=h.offsetTop;if(h.offsetParent){d+=h.clientLeft-h.scrollLeft;e+=h.clientTop-h.scrollTop}f=f.parentNode;while(f!=h){d+=f.clientLeft-f.scrollLeft;e+=f.clientTop-f.scrollTop;f=f.parentNode}}return[d,e]},getStyle:function(e,d){return e.style[d]},keys:function(d,e){var f=[],g;for(g in d){if(e){if(d.hasOwnProperty(g)){f.push(g)}}else{f.push(g)}}return f},escapeHTML:function(d){return d.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")},unescapeHTML:function(d){return d.replace(/<\/?[^>]+>/gi,"").replace(/&amp;/g,"&").replace(/&lt;/g,"<").replace(/&gt;/g,">")},clone:function(e){var d={};d.prototype=e;return d},cloneAndCopy:function(g,f){var d=function(){},e;d.prototype=g;for(e in f){d[e]=f[e]}return d},deepCopy:function(k,h,g){var m,e,l,d,f;g=g||false;if(typeof k!=="object"||k==null){return k}if(this.isArray(k)){m=[];for(e=0;e<k.length;e++){l=k[e];if(typeof l=="object"){m[e]=this.deepCopy(l)}else{m[e]=l}}}else{m={};for(e in k){f=g?e.toLowerCase():e;l=k[e];if(typeof l=="object"){m[f]=this.deepCopy(l)}else{m[f]=l}}for(e in h){f=g?e.toLowerCase():e;l=h[e];if(typeof l=="object"){if(JXG.isArray(l)||!JXG.exists(m[f])){m[f]=this.deepCopy(l)}else{m[f]=this.deepCopy(m[f],l,g)}}else{m[f]=l}}}return m},toJSON:function(j){var f;if(window.JSON&&window.JSON.stringify){try{f=JSON.stringify(j);return f}catch(h){}}switch(typeof j){case"object":if(j){var g=[];if(j instanceof Array){for(var d=0;d<j.length;d++){g.push(JXG.toJSON(j[d]))}return"["+g.join(",")+"]"}else{for(var k in j){g.push('"'+k+'":'+JXG.toJSON(j[k]))}return"{"+g.join(",")+"}"}}else{return"null"}case"string":return'"'+j.replace(/(["'])/g,"\\$1")+'"';case"number":case"boolean":return new String(j)}},capitalize:function(d){return d.charAt(0).toUpperCase()+d.substring(1).toLowerCase()},timedChunk:function(e,g,f,h){var d=e.concat();setTimeout(function(){var i=+new Date();do{g.call(f,d.shift())}while(d.length>0&&(+new Date()-i<300));if(d.length>0){setTimeout(arguments.callee,1)}else{h(e)}},1)},trimNumber:function(d){d=d.replace(/^0+/,"");d=d.replace(/0+$/,"");if(d[d.length-1]=="."||d[d.length-1]==","){d=d.slice(0,-1)}if(d[0]=="."||d[0]==","){d="0"+d}return d},trim:function(d){d=d.replace(/^w+/,"");d=d.replace(/w+$/,"");return d},evaluate:function(d){if(JXG.isFunction(d)){return d()}else{return d}},debug:function(e){var d;for(d=0;d<arguments.length;d++){e=arguments[d];if(window.console&&console.log){if(typeof e==="string"){e=e.replace(/<\S[^><]*>/g,"")}console.log(e)}else{if(document.getElementById("debug")){document.getElementById("debug").innerHTML+=e+"<br/>"}}}}});JXG.addEvent(window,"load",function(){var h=document.getElementsByTagName("script"),n,l,k,e,m,f,p,o,g,d;for(l=0;l<h.length;l++){n=h[l].getAttribute("type",false);if(!JXG.exists(n)){continue}if(n.toLowerCase()==="text/jessiescript"||n.toLowerCase==="jessiescript"){f=h[l].getAttribute("width",false)||"500px";p=h[l].getAttribute("height",false)||"500px";o=h[l].getAttribute("boundingbox",false)||"-5, 5, 5, -5";o=o.split(",");if(o.length!==4){o=[-5,5,5,-5]}else{for(k=0;k<o.length;k++){o[k]=parseFloat(o[k])}}g=JXG.str2Bool(h[l].getAttribute("axis",false)||"false");d=JXG.str2Bool(h[l].getAttribute("grid",false)||"false");e=document.createElement("div");e.setAttribute("id","jessiescript_autgen_jxg_"+l);e.setAttribute("style","width:"+f+"; height:"+p+"; float:left");e.setAttribute("class","jxgbox");document.body.insertBefore(e,h[l]);m=JXG.JSXGraph.initBoard("jessiescript_autgen_jxg_"+l,{boundingbox:o,keepaspectratio:true,grid:d,axis:g});m.construct(h[l].innerHTML)}}},window);JXG.Math=(function(e,d,f){var g=function(i){var h,j;if(i.memo){return i.memo}h={};j=Array.prototype.join;return(i.memo=function(){var k=j.call(arguments);return(h[k]!==f)?h[k]:h[k]=i.apply(this,arguments)})};return{eps:0.000001,vector:function(l,k){var j,h;k=k||0;j=new Array(d.ceil(l));for(h=0;h<l;h++){j[h]=k}return j},matrix:function(q,h,p){var o,l,k;p=p||0;h=h||q;o=new Array(d.ceil(q));for(l=0;l<q;l++){o[l]=new Array(d.ceil(h));for(k=0;k<h;k++){o[l][k]=p}}return o},identity:function(l,h){var k,j;if((h===f)&&(typeof h!=="number")){h=l}k=this.matrix(l,h);for(j=0;j<d.min(l,h);j++){k[j][j]=1}return k},frustum:function(i,m,h,k,p,o){var j=e.Math.matrix(4,4);j[0][0]=(p*2)/(m-i);j[0][1]=0;j[0][2]=(m+i)/(m-i);j[0][3]=0;j[1][0]=0;j[1][1]=(p*2)/(k-h);j[1][2]=(k+h)/(k-h);j[1][3]=0;j[2][0]=0;j[2][1]=0;j[2][2]=-(o+p)/(o-p);j[2][3]=-(o*p*2)/(o-p);j[3][0]=0;j[3][1]=0;j[3][2]=-1;j[3][3]=0;return j},projection:function(h,j,m,l){var i=m*d.tan(h/2),k=i*j;return this.frustum(-k,k,-i,i,m,l)},matVecMult:function(q,p){var h=q.length,t=p.length,o=[],l,r,j;if(t===3){for(l=0;l<h;l++){o[l]=q[l][0]*p[0]+q[l][1]*p[1]+q[l][2]*p[2]}}else{for(l=0;l<h;l++){r=0;for(j=0;j<t;j++){r+=q[l][j]*p[j]}o[l]=r}}return o},matMatMult:function(l,h){var p=l.length,o=p>0?h[0].length:0,v=h.length,u=this.matrix(p,o),t,r,w,q;for(t=0;t<p;t++){for(r=0;r<o;r++){w=0;for(q=0;q<v;q++){w+=l[t][q]*h[q][r]}u[t][r]=w}}return u},transpose:function(q){var l,o,k,h,p;h=q.length;p=q.length>0?q[0].length:0;l=this.matrix(p,h);for(o=0;o<p;o++){for(k=0;k<h;k++){l[o][k]=q[k][o]}}return l},inverse:function(x){var u,t,q,z,y,h,w,o=x.length,m=[],l=[],v=[];for(u=0;u<o;u++){m[u]=[];for(t=0;t<o;t++){m[u][t]=x[u][t]}l[u]=u}for(t=0;t<o;t++){y=d.abs(m[t][t]);h=t;for(u=t+1;u<o;u++){if(d.abs(m[u][t])>y){y=d.abs(m[u][t]);h=u}}if(y<=e.Math.eps){return false}if(h>t){for(q=0;q<o;q++){w=m[t][q];m[t][q]=m[h][q];m[h][q]=w}w=l[t];l[t]=l[h];l[h]=w}z=1/m[t][t];for(u=0;u<o;u++){m[u][t]*=z}m[t][t]=z;for(q=0;q<o;q++){if(q!=t){for(u=0;u<o;u++){if(u!=t){m[u][q]-=m[u][t]*m[t][q]}}m[t][q]=-z*m[t][q]}}}for(u=0;u<o;u++){for(q=0;q<o;q++){v[l[q]]=m[u][q]}for(q=0;q<o;q++){m[u][q]=v[q]}}return m},innerProduct:function(j,h,m){var k,l=0;if((m===f)||(typeof m!=="number")){m=j.length}for(k=0;k<m;k++){l+=j[k]*h[k]}return l},crossProduct:function(i,h){return[i[1]*h[2]-i[2]*h[1],i[2]*h[0]-i[0]*h[2],i[0]*h[1]-i[1]*h[0]]},factorial:g(function(h){if(h<0){return NaN}h=d.floor(h);if(h===0||h===1){return 1}return h*arguments.callee(h-1)}),binomial:g(function(m,j){var h,l;if(j>m||j<0){return NaN}j=d.floor(j);m=d.floor(m);if(j===0||j===m){return 1}h=1;for(l=0;l<j;l++){h*=(m-l);h/=(l+1)}return h}),cosh:function(h){return(d.exp(h)+d.exp(-h))*0.5},sinh:function(h){return(d.exp(h)-d.exp(-h))*0.5},pow:function(i,h){if(i===0){if(h===0){return 1}else{return 0}}if(d.floor(h)===h){return d.pow(i,h)}else{if(i>0){return d.exp(h*d.log(d.abs(i)))}else{return NaN}}},squampow:function(j,i){var h;if(d.floor(i)===i){h=1;if(i<0){j=1/j;i*=-1}while(i!=0){if(i&1){h*=j}i>>=1;j*=j}return h}else{return this.pow(j,i)}},normalize:function(j){var h=2*j[3],k=j[4]/(h),l,i;j[5]=k;j[6]=-j[1]/h;j[7]=-j[2]/h;if(k===Infinity||isNaN(k)){l=d.sqrt(j[1]*j[1]+j[2]*j[2]);j[0]/=l;j[1]/=l;j[2]/=l;j[3]=0;j[4]=1}else{if(d.abs(k)>=1){j[0]=(j[6]*j[6]+j[7]*j[7]-k*k)/(2*k);j[1]=-j[6]/k;j[2]=-j[7]/k;j[3]=1/(2*k);j[4]=1}else{i=(k<=0)?(-1):(1);j[0]=i*(j[6]*j[6]+j[7]*j[7]-k*k)*0.5;j[1]=-i*j[6];j[2]=-i*j[7];j[3]=i/2;j[4]=i*k}}return j},toGL:function(h){var k,n,l;if(typeof Float32Array!=="undefined"){k=new Float32Array(16)}else{k=new Array(16)}if(h.length!==4&&h[0].length!==4){return k}for(n=0;n<4;n++){for(l=0;l<4;l++){k[n+4*l]=h[n][l]}}return k}}})(JXG,Math);JXG.Math.Numerics=(function(e,d){var f={rk4:{s:4,A:[[0,0,0,0],[0.5,0,0,0],[0,0.5,0,0],[0,0,1,0]],b:[1/6,1/3,1/3,1/6],c:[0,0.5,0.5,1]},heun:{s:2,A:[[0,0],[1,0]],b:[0.5,0.5],c:[0,1]},euler:{s:1,A:[[0]],b:[1],c:[0]}};return{Gauss:function(g,r){var t=e.Math.eps,h=g.length>0?g[0].length:0,p,s,q,o,m,l=function(u,n){var k=this[u];this[u]=this[n];this[n]=k};if((h!==r.length)||(h!==g.length)){throw new Error("JXG.Math.Numerics.Gauss: Dimensions don't match. A must be a square matrix and b must be of the same length as A.")}p=new Array(h);s=r.slice(0,h);for(q=0;q<h;q++){p[q]=g[q].slice(0,h)}for(o=0;o<h;o++){for(q=h-1;q>o;q--){if(d.abs(p[q][o])>t){if(d.abs(p[o][o])<t){l.apply(p,[q,o]);l.apply(s,[q,o])}else{p[q][o]/=p[o][o];s[q]-=p[q][o]*s[o];for(m=o+1;m<h;m++){p[q][m]-=p[q][o]*p[o][m]}}}}if(d.abs(p[o][o])<t){throw new Error("JXG.Math.Numerics.Gauss(): The given matrix seems to be singular.")}}this.backwardSolve(p,s,true);return s},backwardSolve:function(q,k,p){var h,g,r,o,l;if(p){h=k}else{h=k.slice(0,k.length)}g=q.length;r=q.length>0?q[0].length:0;for(o=g-1;o>=0;o--){for(l=r-1;l>o;l--){h[o]-=q[o][l]*h[l]}h[o]/=q[o][o]}return h},gaussBareiss:function(u){var l,r,x,o,m,g,h,q,v,w=e.Math.eps;h=u.length;if(h<=0){return 0}if(u[0].length<h){h=u[0].length}q=new Array(h);for(o=0;o<h;o++){q[o]=u[o].slice(0,h)}r=1;x=1;for(l=0;l<h-1;l++){g=q[l][l];if(d.abs(g)<w){for(o=0;o<h;o++){if(d.abs(q[o][l])>=w){break}}if(o==h){return 0}for(m=l;m<h;m++){v=q[o][m];q[o][m]=q[l][m];q[l][m]=v}x=-x;g=q[l][l]}for(o=l+1;o<h;o++){for(m=l+1;m<h;m++){v=g*q[o][m]-q[o][l]*q[l][m];q[o][m]=v/r}}r=g}return x*q[h-1][h-1]},det:function(g){return this.gaussBareiss(g)},Jacobi:function(y){var r,p,o,g,s,x,w,z=e.Math.eps,v=0,u,q,l=y.length,m=[[0,0,0],[0,0,0],[0,0,0]],h=[[0,0,0],[0,0,0],[0,0,0]],t=0;for(r=0;r<l;r++){for(p=0;p<l;p++){m[r][p]=0;h[r][p]=y[r][p];v+=d.abs(h[r][p])}m[r][r]=1}if(l==1){return[h,m]}if(v<=0){return[h,m]}v/=(l*l);do{u=0;q=0;for(p=1;p<l;p++){for(r=0;r<p;r++){g=d.abs(h[r][p]);if(g>q){q=g}u+=g;if(g>=z){g=d.atan2(2*h[r][p],h[r][r]-h[p][p])*0.5;s=d.sin(g);x=d.cos(g);for(o=0;o<l;o++){w=h[o][r];h[o][r]=x*w+s*h[o][p];h[o][p]=-s*w+x*h[o][p];w=m[o][r];m[o][r]=x*w+s*m[o][p];m[o][p]=-s*w+x*m[o][p]}h[r][r]=x*h[r][r]+s*h[p][r];h[p][p]=-s*h[r][p]+x*h[p][p];h[r][p]=0;for(o=0;o<l;o++){h[r][o]=h[o][r];h[p][o]=h[o][p]}}}}t++}while(d.abs(u)/v>z&&t<2000);return[h,m]},NewtonCotes:function(g,k,h){var l=0,p=h&&typeof h.number_of_nodes==="number"?h.number_of_nodes:28,n={trapez:true,simpson:true,milne:true},q=h&&h.integration_type&&n.hasOwnProperty(h.integration_type)&&n[h.integration_type]?h.integration_type:"milne",o=(g[1]-g[0])/p,m,j,r;switch(q){case"trapez":l=(k(g[0])+k(g[1]))*0.5;m=g[0];for(j=0;j<p-1;j++){m+=o;l+=k(m)}l*=o;break;case"simpson":if(p%2>0){throw new Error("JSXGraph:  INT_SIMPSON requires config.number_of_nodes dividable by 2.")}r=p/2;l=k(g[0])+k(g[1]);m=g[0];for(j=0;j<r-1;j++){m+=2*o;l+=2*k(m)}m=g[0]-o;for(j=0;j<r;j++){m+=2*o;l+=4*k(m)}l*=o/3;break;default:if(p%4>0){throw new Error("JSXGraph: Error in INT_MILNE: config.number_of_nodes must be a multiple of 4")}r=p*0.25;l=7*(k(g[0])+k(g[1]));m=g[0];for(j=0;j<r-1;j++){m+=4*o;l+=14*k(m)}m=g[0]-3*o;for(j=0;j<r;j++){m+=4*o;l+=32*(k(m)+k(m+2*o))}m=g[0]-2*o;for(j=0;j<r;j++){m+=4*o;l+=12*k(m)}l*=2*o/45}return l},I:function(g,h){return this.NewtonCotes(g,h,{number_of_nodes:16,integration_type:"milne"})},Newton:function(o,g,j){var k=0,m=e.Math.eps,n=o.apply(j,[g]),l=1,p;if(e.isArray(g)){g=g[0]}while(k<50&&d.abs(n)>m){p=this.D(o,j)(g);l+=2;if(d.abs(p)>m){g-=n/p}else{g+=(d.random()*0.2-1)}n=o.apply(j,[g]);l++;k++}return g},root:function(i,g,h){return this.fzero(i,g,h)},Neville:function(k){var h=[],g=function(l){return function(v,m){var o,u,w,x=e.Math.binomial,r=k.length,n=r-1,p=0,q=0;if(!m){w=1;for(o=0;o<r;o++){h[o]=x(n,o)*w;w*=(-1)}}u=v;for(o=0;o<r;o++){if(u===0){return k[o][l]()}else{w=h[o]/u;u--;p+=k[o][l]()*w;q+=w}}return p/q}},j=g("X"),i=g("Y");return[j,i,0,function(){return k.length-1}]},splineDef:function(r,q){var g=d.min(r.length,q.length),j,m,h,o=[],p=[],k=[],u=[],s=[],t=[];if(g===2){return[0,0]}for(m=0;m<g;m++){j={X:r[m],Y:q[m]};k.push(j)}k.sort(function(l,i){return l.X-i.X});for(m=0;m<g;m++){r[m]=k[m].X;q[m]=k[m].Y}for(m=0;m<g-1;m++){u.push(r[m+1]-r[m])}for(m=0;m<g-2;m++){s.push(6*(q[m+2]-q[m+1])/(u[m+1])-6*(q[m+1]-q[m])/(u[m]))}o.push(2*(u[0]+u[1]));p.push(s[0]);for(m=0;m<g-3;m++){h=u[m+1]/o[m];o.push(2*(u[m+1]+u[m+2])-h*u[m+1]);p.push(s[m+1]-h*p[m])}t[g-3]=p[g-3]/o[g-3];for(m=g-4;m>=0;m--){t[m]=(p[m]-(u[m+1]*t[m+1]))/o[m]}for(m=g-3;m>=0;m--){t[m+1]=t[m]}t[0]=0;t[g-1]=0;return t},splineEval:function(h,w,u,A){var k=d.min(w.length,u.length),o=1,m=false,z=[],q,p,v,t,s,r,g;if(e.isArray(h)){o=h.length;m=true}else{h=[h]}for(q=0;q<o;q++){if((h[q]<w[0])||(w[q]>w[k-1])){return NaN}for(p=1;p<k;p++){if(h[q]<=w[p]){break}}p--;v=u[p];t=(u[p+1]-u[p])/(w[p+1]-w[p])-(w[p+1]-w[p])/6*(A[p+1]+2*A[p]);s=A[p]/2;r=(A[p+1]-A[p])/(6*(w[p+1]-w[p]));g=h[q]-w[p];z.push(v+(t+(s+r*g)*g)*g)}if(m){return z}else{return z[0]}},generatePolynomialTerm:function(g,m,h,j){var l=[],k;for(k=m;k>=0;k--){l=l.concat(["(",g[k].toPrecision(j),")"]);if(k>1){l=l.concat(["*",h,"<sup>",k,"<","/sup> + "])}else{if(k===1){l=l.concat(["*",h," + "])}}}return l.join("")},lagrangePolynomial:function(i){var g=[],h=function(v,l){var o,m,r,u,w,p=0,q=0,t,n;r=i.length;if(!l){for(o=0;o<r;o++){g[o]=1;u=i[o].X();for(m=0;m<r;m++){if(m!=o){g[o]*=(u-i[m].X())}}g[o]=1/g[o]}t=[];for(n=0;n<r;n++){t.push([1])}}for(o=0;o<r;o++){u=i[o].X();if(v===u){return i[o].Y()}else{w=g[o]/(v-u);q+=w;p+=w*i[o].Y()}}return p/q};h.getTerm=function(){return""};return h},regressionPolynomial:function(k,o,n){var g,h,m,l,i,p,j="";if(e.isPoint(k)&&typeof k.Value=="function"){h=function(){return k.Value()}}else{if(e.isFunction(k)){h=k}else{if(e.isNumber(k)){h=function(){return k}}else{throw new Error("JSXGraph: Can't create regressionPolynomial from degree of type'"+(typeof k)+"'.")}}}if(arguments.length==3&&e.isArray(o)&&e.isArray(n)){i=0}else{if(arguments.length==2&&e.isArray(o)&&o.length>0&&e.isPoint(o[0])){i=1}else{throw new Error("JSXGraph: Can't create regressionPolynomial. Wrong parameters.")}}p=function(E,q){var u,t,A,w,D,r,C,F,z,v=o.length;z=d.floor(h());if(!q){if(i===1){m=[];l=[];for(u=0;u<v;u++){m[u]=o[u].X();l[u]=o[u].Y()}}if(i===0){m=[];l=[];for(u=0;u<v;u++){if(e.isFunction(o[u])){m.push(o[u]())}else{m.push(o[u])}if(e.isFunction(n[u])){l.push(n[u]())}else{l.push(n[u])}}}A=[];for(t=0;t<v;t++){A.push([1])}for(u=1;u<=z;u++){for(t=0;t<v;t++){A[t][u]=A[t][u-1]*m[t]}}D=l;w=e.Math.transpose(A);r=e.Math.matMatMult(w,A);C=e.Math.matVecMult(w,D);g=e.Math.Numerics.Gauss(r,C);j=e.Math.Numerics.generatePolynomialTerm(g,z,"x",3)}F=g[z];for(u=z-1;u>=0;u--){F=(F*E+g[u])}return F};p.getTerm=function(){return j};return p},bezier:function(i){var g,h=function(j){return function(l,k){var o=d.floor(l)*3,n=l%1,m=1-n;if(!k){g=d.floor(i.length/3)}if(l<0){return i[0][j]()}if(l>=g){return i[i.length-1][j]()}if(isNaN(l)){return NaN}return m*m*(m*i[o][j]()+3*n*i[o+1][j]())+(3*m*i[o+2][j]()+n*i[o+3][j]())*n*n}};return[h("X"),h("Y"),0,function(){return d.floor(i.length/3)}]},bspline:function(j,g){var k,m=[],l=function(r,o){var p,q=[];for(p=0;p<r+o+1;p++){if(p<o){q[p]=0}else{if(p<=r){q[p]=p-o+1}else{q[p]=r-o+2}}}return q},i=function(y,A,o,p,z){var r,q,w,v,x,u=[];if(A[z]<=y&&y<A[z+1]){u[z]=1}else{u[z]=0}for(r=2;r<=p;r++){for(q=z-r+1;q<=z;q++){if(q<=z-r+1||q<0){w=0}else{w=u[q]}if(q>=z){v=0}else{v=u[q+1]}x=A[q+r-1]-A[q];if(x==0){u[q]=0}else{u[q]=(y-A[q])/x*w}x=A[q+r]-A[q+1];if(x!=0){u[q]+=(A[q+r]-y)/x*v}}}return u},h=function(n){return function(u,p){var o=j.length,x,r,v,w=o-1,q=g;if(w<=0){return NaN}if(w+2<=q){q=w+1}if(u<=0){return j[0][n]()}if(u>=w-q+2){return j[w][n]()}k=l(w,q);v=d.floor(u)+q-1;m=i(u,k,w,q,v);x=0;for(r=v-q+1;r<=v;r++){if(r<o&&r>=0){x+=j[r][n]()*m[r]}}return x}};return[h("X"),h("Y"),0,function(){return j.length-1}]},D:function(j,k){var i=0.00001,g=1/(i*2);if(arguments.length==1||(arguments.length>1&&!e.exists(arguments[1]))){return function(h,l){return(j(h+i,l)-j(h-i,l))*g}}else{return function(h,l){return(j.apply(k,[h+i,l])-j.apply(k,[h-i,l]))*g}}},riemann:function(r,m,s,k,o){var l=[],z=[],q,p=0,w,v=k,t,h,u,g;m=d.floor(m);l[p]=v;z[p]=0;if(m>0){w=(o-k)/m;g=w*0.01;for(q=0;q<m;q++){if(s==="right"){t=r(v+w)}else{if(s==="middle"){t=r(v+w*0.5)}else{if((s==="left")||(s==="trapezodial")){t=r(v)}else{if(s==="lower"){t=r(v);for(h=v+g;h<=v+w;h+=g){u=r(h);if(u<t){t=u}}}else{t=r(v);for(h=v+g;h<=v+w;h+=g){u=r(h);if(u>t){t=u}}}}}}p++;l[p]=v;z[p]=t;p++;v+=w;if(s==="trapezodial"){t=r(v)}l[p]=v;z[p]=t;p++;l[p]=v;z[p]=0}}return[l,z]},riemannsum:function(o,k,q,j,l){var p=0,m,u,t=j,r,h,s,g;k=d.floor(k);if(k>0){u=(l-j)/k;g=u*0.01;for(m=0;m<k;m++){if(q==="right"){r=o(t+u)}else{if(q==="middle"){r=o(t+u*0.5)}else{if(q==="trapezodial"){r=0.5*(o(t+u)+o(t))}else{if(q==="left"){r=o(t)}else{if(q==="lower"){r=o(t);for(h=t+g;h<=t+u;h+=g){s=o(h);if(s<r){r=s}}}else{r=o(t);for(h=t+g;h<=t+u;h+=g){s=o(h);if(s>r){r=s}}}}}}}p+=u*r;t+=u}}return p},rungeKutta:function(g,G,o,m,F){var p=[],n=[],E=(o[1]-o[0])/m,u=o[0],H,D,C,A,z,B=G.length,v,q=[],w=0;if(e.isString(g)){g=f[g]||f.euler}v=g.s;for(H=0;H<B;H++){p[H]=G[H]}for(D=0;D<m;D++){q[w]=[];for(H=0;H<B;H++){q[w][H]=p[H]}w++;A=[];for(C=0;C<v;C++){for(H=0;H<B;H++){n[H]=0}for(z=0;z<C;z++){for(H=0;H<B;H++){n[H]+=(g.A[C][z])*E*A[z][H]}}for(H=0;H<B;H++){n[H]+=p[H]}A.push(F(u+g.c[C]*E,n))}for(H=0;H<B;H++){n[H]=0}for(z=0;z<v;z++){for(H=0;H<B;H++){n[H]+=g.b[z]*A[z][H]}}for(H=0;H<B;H++){p[H]=p[H]+E*n[H]}u+=E}return q},maxIterationsRoot:80,maxIterationsMinimize:500,fzero:function(F,G,L){var y=e.Math.eps,g=this.maxIterationsRoot,x=0,A=0,o=y,J,I,H,z,w,v,K,j,C,D,n,h,B,E,t,r,m,l,s,k;if(e.isArray(G)){if(G.length<2){throw new Error("JXG.Math.Numerics.fzero: length of array x0 has to be at least two.")}J=G[0];z=F.apply(L,[J]);A++;I=G[1];w=F.apply(L,[I]);A++}else{J=G;z=F.apply(L,[J]);A++;if(J==0){K=1}else{K=J}j=[0.9*K,1.1*K,K-1,K+1,0.5*K,1.5*K,-K,2*K,-10*K,10*K];D=j.length;for(C=0;C<D;C++){I=j[C];w=F.apply(L,[I]);A++;if(z*w<=0){break}}if(I<J){n=J;J=I;I=n;h=z;z=w;w=h}}if(z*w>0){if(e.isArray(G)){return this.fminbr(F,[J,I],L)}else{return this.Newton(F,J,L)}}H=J;v=z;while(x<g){B=I-J;if(d.abs(v)<d.abs(w)){J=I;I=H;H=J;z=w;w=v;v=z}E=2*o*d.abs(I)+y*0.5;m=(H-I)*0.5;if(d.abs(m)<=E&&d.abs(w)<=o){return I}if(d.abs(B)>=E&&d.abs(z)>d.abs(w)){s=H-I;if(J==H){l=w/z;t=s*l;r=1-l}else{r=z/v;l=w/v;k=w/z;t=k*(s*r*(r-l)-(I-J)*(l-1));r=(r-1)*(l-1)*(k-1)}if(t>0){r=-r}else{t=-t}if(t<(0.75*s*r-d.abs(E*r)*0.5)&&t<d.abs(B*r*0.5)){m=t/r}}if(d.abs(m)<E){if(m>0){m=E}else{m=-E}}J=I;z=w;I+=m;w=F.apply(L,[I]);A++;if((w>0&&v>0)||(w<0&&v<0)){H=J;v=z}x++}return I},fminbr:function(G,H,L){var K,I,l,o,n,h,j,i,y=(3-d.sqrt(5))*0.5,D=e.Math.eps,A=d.sqrt(e.Math.eps),g=this.maxIterationsMinimize,C=0,u,J,F,m,B,z,s,k,E=0;if(!e.isArray(H)||H.length<2){throw new Error("JXG.Math.Numerics.fminbr: length of array x0 has to be at least two.")}K=H[0];I=H[1];o=K+y*(I-K);j=G.apply(L,[o]);E++;l=o;n=o;h=j;i=j;while(C<g){u=I-K;J=(K+I)*0.5;F=A*d.abs(l)+D/3;if(d.abs(l-J)+u*0.5<=2*F){return l}m=y*(l<J?I-l:K-l);if(d.abs(l-n)>=F){s=(l-n)*(h-j);z=(l-o)*(h-i);B=(l-o)*z-(l-n)*s;z=2*(z-s);if(z>0){B=-B}else{z=-z}if(d.abs(B)<d.abs(m*z)&&B>z*(K-l+2*F)&&B<z*(I-l-2*F)){m=B/z}}if(d.abs(m)<F){if(m>0){m=F}else{m=-F}}s=l+m;k=G.apply(L,[s]);E++;if(k<=h){if(s<l){I=l}else{K=l}o=n;n=l;l=s;j=i;i=h;h=k}else{if(s<l){K=s}else{I=s}if(k<=i||n==l){o=n;n=s;j=i;i=k}else{if(k<=j||o==l||o==n){o=s;j=k}}}C++}return l},reuleauxPolygon:function(i,j){var m=d.PI*2,h=m/j,l=(j-1)/2,k,n=0,g=function(p,o){return function(r,u){if(!u){n=i[0].Dist(i[l]);k=e.Math.Geometry.rad([i[0].X()+1,i[0].Y()],i[0],i[(l)%j])}var s=(r%m+m)%m;var q=d.floor(s/h)%j;if(isNaN(q)){return q}s=s*0.5+q*h*0.5+k;return i[q][p]()+n*d[o](s)}};return[g("X","cos"),g("Y","sin"),0,d.PI*2]},RamerDouglasPeuker:function(p,h){var m=[],o,l,g,j=function(u,t,s,q,r){var k=n(u,t,s);if(k[0]>q){j(u,t,k[1],q,r);j(u,k[1],s,q,r)}else{r.push(u[s])}},n=function(E,v,u){var y=0,w=v,x,t,F,D,C,s,B,r,z,A,q;if(u-v<2){return[-1,0]}F=E[v].scrCoords;D=E[u].scrCoords;if(isNaN(F[1]+F[2]+D[1]+D[2])){return[NaN,u]}for(t=v+1;t<u;t++){C=E[t].scrCoords;s=C[1]-F[1];B=C[2]-F[2];r=D[1]-F[1];z=D[2]-F[2];A=r*r+z*z;if(A>=e.Math.eps){q=(s*r+B*z)/A;if(q<0){q=0}else{if(q>1){q=1}}s=s-q*r;B=B-q*z;x=s*s+B*B}else{q=0;x=s*s+B*B}if(x>y){y=x;w=t}}return[d.sqrt(y),w]};g=p.length;o=0;while(o<g&&isNaN(p[o].scrCoords[1]+p[o].scrCoords[2])){o++}l=g-1;while(l>o&&isNaN(p[l].scrCoords[1]+p[l].scrCoords[2])){l--}if(!(o>l||o==g)){m[0]=p[o];j(p,o,l,h,m)}return m}}})(JXG,Math);JXG.Math.Statistics={sum:function(e){var g,d=e.length,f=0;for(g=0;g<d;g++){f+=e[g]}return f},prod:function(e){var g,d=e.length,f=1;for(g=0;g<d;g++){f*=e[g]}return f},mean:function(d){if(d.length>0){return this.sum(d)/d.length}else{return 0}},median:function(e){var f,d;if(e.length>0){f=e.slice(0);f.sort(function(h,g){return h-g});d=f.length;if(d%2==1){return f[parseInt(d*0.5)]}else{return(f[d*0.5-1]+f[d*0.5])*0.5}}else{return 0}},variance:function(f){var e,h,g,d=f.length;if(d>1){e=this.mean(f);h=0;for(g=0;g<d;g++){h+=(f[g]-e)*(f[g]-e)}return h/(f.length-1)}else{return 0}},sd:function(d){return Math.sqrt(this.variance(d))},weightedMean:function(d,e){if(d.length!=e.length){throw new Error("JSXGraph error (Math.Statistics.weightedMean): Array dimension mismatch.")}if(d.length>0){return this.mean(this.multiply(d,e))}else{return 0}},max:function(d){return Math.max.apply(this,d)},min:function(d){return Math.min.apply(this,d)},range:function(d){return[this.min(d),this.max(d)]},abs:function(e){var g,d,f;if(JXG.isArray(e)){d=e.length;f=[];for(g=0;g<d;g++){f[g]=Math.abs(e[g])}}else{if(JXG.isNumber(e)){f=Math.abs(e)}else{throw new Error("JSXGraph Error (Math.Statistics.abs): Invalid input.")}}return f},add:function(f,e){var h,d,g=[];if(JXG.isArray(f)&&JXG.isNumber(e)){d=f.length;for(h=0;h<d;h++){g[h]=f[h]+e}}else{if(JXG.isNumber(f)&&JXG.isArray(e)){d=e.length;for(h=0;h<d;h++){g[h]=f+e[h]}}else{if(JXG.isArray(f)&&JXG.isArray(e)){d=Math.min(f.length,e.length);for(h=0;h<d;h++){g[h]=f[h]+e[h]}}else{if(JXG.isNumber(f)&&JXG.isNumber(e)){g=f+e}else{throw new Error("JSXGraph Error (Math.Statistics.add): Invalid input.")}}}}return g},div:function(f,e){var h,d,g=[];if(JXG.isArray(f)&&JXG.isNumber(e)){d=f.length;for(h=0;h<d;h++){g[h]=f[h]/e}}else{if(JXG.isNumber(f)&&JXG.isArray(e)){d=e.length;for(h=0;h<d;h++){g[h]=f/e[h]}}else{if(JXG.isArray(f)&&JXG.isArray(e)){d=Math.min(f.length,e.length);for(h=0;h<d;h++){g[h]=f[h]/e[h]}}else{if(JXG.isNumber(f)&&JXG.isNumber(e)){g=f/e}else{throw new Error("JSXGraph Error (Math.Statistics.div): Invalid input.")}}}}return g},divide:JXG.shortcut(JXG.Math.Statistics,"div"),mod:function(f,e){var h,d,g=[];if(JXG.isArray(f)&&JXG.isNumber(e)){d=f.length;for(h=0;h<d;h++){g[h]=f[h]%e}}else{if(JXG.isNumber(f)&&JXG.isArray(e)){d=e.length;for(h=0;h<d;h++){g[h]=f%e[h]}}else{if(JXG.isArray(f)&&JXG.isArray(e)){d=Math.min(f.length,e.length);for(h=0;h<d;h++){g[h]=f[h]%e[h]}}else{if(JXG.isNumber(f)&&JXG.isNumber(e)){g=f%e}else{throw new Error("JSXGraph Error (Math.Statistics.mod): Invalid input.")}}}}return g},multiply:function(f,e){var h,d,g=[];if(JXG.isArray(f)&&JXG.isNumber(e)){d=f.length;for(h=0;h<d;h++){g[h]=f[h]*e}}else{if(JXG.isNumber(f)&&JXG.isArray(e)){d=e.length;for(h=0;h<d;h++){g[h]=f*e[h]}}else{if(JXG.isArray(f)&&JXG.isArray(e)){d=Math.min(f.length,e.length);for(h=0;h<d;h++){g[h]=f[h]*e[h]}}else{if(JXG.isNumber(f)&&JXG.isNumber(e)){g=f*e}else{throw new Error("JSXGraph Error (Math.Statistics.mod): Invalid input.")}}}}return g},subtract:function(f,e){var h,d,g=[];if(JXG.isArray(f)&&JXG.isNumber(e)){d=f.length;for(h=0;h<d;h++){g[h]=f[h]-e}}else{if(JXG.isNumber(f)&&JXG.isArray(e)){d=e.length;for(h=0;h<d;h++){g[h]=f-e[h]}}else{if(JXG.isArray(f)&&JXG.isArray(e)){d=Math.min(f.length,e.length);for(h=0;h<d;h++){g[h]=f[h]-e[h]}}else{if(JXG.isNumber(f)&&JXG.isNumber(e)){g=f-e}else{throw new Error("JSXGraph Error (Math.Statistics.mod): Invalid input.")}}}}return g}};JXG.Math.Symbolic=function(d,e){return{generateSymbolicCoordinatesPartial:function(o,j,i,g){var f=function(k){var q;if(g==="underscore"){q=""+i+"_{"+k+"}"}else{if(g=="brace"){q=""+i+"["+k+"]"}else{q=""+i+""+k}}return q},m=j.ancestors,l=0,n,p,h;o.listOfFreePoints=[];o.listOfDependantPoints=[];for(p in m){n=0;if(d.isPoint(m[p])){for(h in m[p].ancestors){n++}if(n===0){m[p].symbolic.x=m[p].coords.usrCoords[1];m[p].symbolic.y=m[p].coords.usrCoords[2];o.listOfFreePoints.push(m[p])}else{l++;m[p].symbolic.x=f(l);l++;m[p].symbolic.y=f(l);o.listOfDependantPoints.push(m[p])}}}if(d.isPoint(j)){j.symbolic.x="x";j.symbolic.y="y"}return l},clearSymbolicCoordinates:function(g){var f=function(j){var i,h=(j&&j.length)||0;for(i=0;i<h;i++){if(d.isPoint(j[i])){j[i].symbolic.x="";j[i].symbolic.y=""}}};f(g.listOfFreePoints);f(g.listOfDependantPoints);delete (g.listOfFreePoints);delete (g.listOfDependantPoints)},generatePolynomials:function(n,h,j){var m=h.ancestors,o,l=[],q=[],p,f,g;if(j){this.generateSymbolicCoordinatesPartial(n,h,"u","brace")}m[h.id]=h;for(p in m){o=0;l=[];if(d.isPoint(m[p])){for(f in m[p].ancestors){o++}if(o>0){l=m[p].generatePolynomial();for(g=0;g<l.length;g++){q.push(l[g])}}}}if(j){this.clearSymbolicCoordinates(n)}return q},geometricLocusByGroebnerBase:function(n,z){var l=this.generateSymbolicCoordinatesPartial(n,z,"u","brace"),m,h,q,f={},v=new d.Coords(d.COORDS_BY_USR,[0,0],n),t=new d.Coords(d.COORDS_BY_USR,[n.canvasWidth,n.canvasHeight],n),k,j,C,F=1,u=0,r=0,o=0,D,w,E,p,y,A,g,B=function(G,H){var s;for(s=0;s<H.length;s++){if(H[s].id===G){return true}}return false},x=n.options.locus;if(d.Server.modules.geoloci===e){d.Server.loadModule("geoloci")}if(d.Server.modules.geoloci===e){throw new Error("JSXGraph: Unable to load JXG.Server module 'geoloci.py'.")}p=v.usrCoords[1];y=t.usrCoords[1];A=t.usrCoords[2];g=v.usrCoords[2];if(x.translateToOrigin&&(n.listOfFreePoints.length>0)){if((x.toOrigin!==e)&&(x.toOrigin!=null)&&B(x.toOrigin.id,n.listOfFreePoints)){k=x.toOrigin}else{k=n.listOfFreePoints[0]}u=k.symbolic.x;r=k.symbolic.y;for(C=0;C<n.listOfFreePoints.length;C++){n.listOfFreePoints[C].symbolic.x-=u;n.listOfFreePoints[C].symbolic.y-=r}p-=u;y-=u;A-=r;g-=r;if(x.translateTo10&&(n.listOfFreePoints.length>1)){if((x.to10!==e)&&(x.to10!=null)&&(x.to10.id!=x.toOrigin.id)&&B(x.to10.id,n.listOfFreePoints)){j=x.to10}else{if(n.listOfFreePoints[0].id==k.id){j=n.listOfFreePoints[1]}else{j=n.listOfFreePoints[0]}}o=d.Math.Geometry.rad([1,0],[0,0],[j.symbolic.x,j.symbolic.y]);D=Math.cos(-o);w=Math.sin(-o);for(C=0;C<n.listOfFreePoints.length;C++){E=n.listOfFreePoints[C].symbolic.x;n.listOfFreePoints[C].symbolic.x=D*n.listOfFreePoints[C].symbolic.x-w*n.listOfFreePoints[C].symbolic.y;n.listOfFreePoints[C].symbolic.y=w*E+D*n.listOfFreePoints[C].symbolic.y}j.symbolic.y=0;E=p;p=D*p-w*A;A=w*E+D*A;E=y;y=D*y-w*g;g=w*E+D*g;if(x.stretch&&(Math.abs(j.symbolic.x)>d.Math.eps)){F=j.symbolic.x;for(C=0;C<n.listOfFreePoints.length;C++){n.listOfFreePoints[C].symbolic.x/=F;n.listOfFreePoints[C].symbolic.y/=F}for(C in n.objects){if((n.objects[C].elementClass==d.OBJECT_CLASS_CIRCLE)&&(n.objects[C].method=="pointRadius")){f[C]=n.objects[C].radius;n.objects[C].radius/=F}}p/=F;y/=F;A/=F;g/=F;j.symbolic.x=1}}for(C=0;C<n.listOfFreePoints.length;C++){E=n.listOfFreePoints[C].symbolic.x;if(Math.abs(E)<d.Math.eps){n.listOfFreePoints[C].symbolic.x=0}if(Math.abs(E-Math.round(E))<d.Math.eps){n.listOfFreePoints[C].symbolic.x=Math.round(E)}E=n.listOfFreePoints[C].symbolic.y;if(Math.abs(E)<d.Math.eps){n.listOfFreePoints[C].symbolic.y=0}if(Math.abs(E-Math.round(E))<d.Math.eps){n.listOfFreePoints[C].symbolic.y=Math.round(E)}}}m=this.generatePolynomials(n,z);h=m.join(",");this.cbp=function(i){q=i};this.cb=d.bind(this.cbp,this);d.Server.modules.geoloci.lociCoCoA(p,y,A,g,l,h,F,o,u,r,this.cb,true);this.clearSymbolicCoordinates(n);for(C in f){n.objects[C].radius=f[C]}return q}}}(JXG);JXG.Math.Geometry={angle:function(f,e,d){var i=[],h=[],g=[],k,j,m,l;if(f.coords==null){i[0]=f[0];i[1]=f[1]}else{i[0]=f.coords.usrCoords[1];i[1]=f.coords.usrCoords[2]}if(e.coords==null){h[0]=e[0];h[1]=e[1]}else{h[0]=e.coords.usrCoords[1];h[1]=e.coords.usrCoords[2]}if(d.coords==null){g[0]=d[0];g[1]=d[1]}else{g[0]=d.coords.usrCoords[1];g[1]=d.coords.usrCoords[2]}k=i[0]-h[0];j=i[1]-h[1];m=g[0]-h[0];l=g[1]-h[1];return Math.atan2(k*l-j*m,k*m+j*l)},trueAngle:function(d,f,e){return this.rad(d,f,e)*57.29577951308232},rad:function(g,f,e){var d,m,l,k,i,h,j;if(g.coords==null){d=g[0];m=g[1]}else{d=g.coords.usrCoords[1];m=g.coords.usrCoords[2]}if(f.coords==null){l=f[0];k=f[1]}else{l=f.coords.usrCoords[1];k=f.coords.usrCoords[2]}if(e.coords==null){i=e[0];h=e[1]}else{i=e.coords.usrCoords[1];h=e.coords.usrCoords[2]}j=Math.atan2(h-k,i-l)-Math.atan2(m-k,d-l);if(j<0){j+=6.283185307179586}return j},angleBisector:function(i,h,f,l){var g=i.coords.usrCoords,o=h.coords.usrCoords,j=f.coords.usrCoords,p=g[1]-o[1],n=g[2]-o[2],m=Math.sqrt(p*p+n*n),e,q,k;if(!JXG.exists(l)){l=i.board}p/=m;n/=m;e=Math.acos(p);if(n<0){e*=-1}if(e<0){e+=2*Math.PI}p=j[1]-o[1];n=j[2]-o[2];m=Math.sqrt(p*p+n*n);p/=m;n/=m;q=Math.acos(p);if(n<0){q*=-1}if(q<0){q+=2*Math.PI}k=(e+q)*0.5;if(e>q){k+=Math.PI}p=Math.cos(k)+o[1];n=Math.sin(k)+o[2];return new JXG.Coords(JXG.COORDS_BY_USER,[p,n],l)},reflection:function(o,l,f){var h=l.coords.usrCoords,p=o.point1.coords.usrCoords,g=o.point2.coords.usrCoords,e,k,d,i,m,j,n;if(!JXG.exists(f)){f=l.board}m=g[1]-p[1];j=g[2]-p[2];e=h[1]-p[1];k=h[2]-p[2];n=(m*k-j*e)/(m*m+j*j);d=h[1]+2*n*j;i=h[2]-2*n*m;return new JXG.Coords(JXG.COORDS_BY_USER,[d,i],f)},rotation:function(d,n,h,i){var k=n.coords.usrCoords,e=d.coords.usrCoords,g,m,j,o,f,l;if(!JXG.exists(i)){i=n.board}g=k[1]-e[1];m=k[2]-e[2];j=Math.cos(h);o=Math.sin(h);f=g*j-m*o+e[1];l=g*o+m*j+e[2];return new JXG.Coords(JXG.COORDS_BY_USER,[f,l],i)},perpendicular:function(q,o,i){var h=q.point1.coords.usrCoords,g=q.point2.coords.usrCoords,e=o.coords.usrCoords,m,l,k,p,j,f,d,n;if(!JXG.exists(i)){i=o.board}if(o==q.point1){m=h[1]+g[2]-h[2];l=h[2]-g[1]+h[1];k=true}else{if(o==q.point2){m=g[1]+h[2]-g[2];l=g[2]-h[1]+g[1];k=false}else{if(((Math.abs(h[1]-g[1])>JXG.Math.eps)&&(Math.abs(e[2]-(h[2]-g[2])*(e[1]-h[1])/(h[1]-g[1])-h[2])<JXG.Math.eps))||((Math.abs(h[1]-g[1])<=JXG.Math.eps)&&(Math.abs(h[1]-e[1])<JXG.Math.eps))){m=e[1]+g[2]-e[2];l=e[2]-g[1]+e[1];k=true;if(Math.abs(m-e[1])<JXG.Math.eps&&Math.abs(l-e[2])<JXG.Math.eps){m=e[1]+h[2]-e[2];l=e[2]-h[1]+e[1];k=false}}else{p=h[2]-g[2];j=h[1]-g[1];f=g[1]*p-g[2]*j;d=e[1]*j+e[2]*p;n=p*p+j*j;if(Math.abs(n)<JXG.Math.eps){n=JXG.Math.eps}m=(f*p+d*j)/n;l=(d*p-f*j)/n;k=true}}}return[new JXG.Coords(JXG.COORDS_BY_USER,[m,l],i),k]},circumcenterMidpoint:function(k,i,h,g){var f=k.coords.usrCoords,e=i.coords.usrCoords,d=h.coords.usrCoords,o,n,m,l,j;if(!JXG.exists(g)){g=k.board}o=((f[1]-e[1])*(f[1]+e[1])+(f[2]-e[2])*(f[2]+e[2]))*0.5;n=((e[1]-d[1])*(e[1]+d[1])+(e[2]-d[2])*(e[2]+d[2]))*0.5;m=(f[1]-e[1])*(e[2]-d[2])-(e[1]-d[1])*(f[2]-e[2]);if(Math.abs(m)<JXG.Math.eps){m=JXG.Math.eps}l=(o*(e[2]-d[2])-n*(f[2]-e[2]))/m;j=(n*(f[1]-e[1])-o*(e[1]-d[1]))/m;return new JXG.Coords(JXG.COORDS_BY_USER,[l,j],g)},distance:function(h,g){var f=0,e,d;if(h.length!=g.length){return NaN}d=h.length;for(e=0;e<d;e++){f+=(h[e]-g[e])*(h[e]-g[e])}return Math.sqrt(f)},affineDistance:function(f,e){var g;if(f.length!=e.length){return NaN}g=this.distance(f,e);if(g>JXG.Math.eps&&(Math.abs(f[0])<JXG.Math.eps||Math.abs(e[0])<JXG.Math.eps)){return Infinity}else{return g}},calcStraight:function(g,p,o){var e,d,m,k,q,f,n,u,l,h,t,r;q=g.visProp.straightfirst;f=g.visProp.straightlast;if(Math.abs(p.scrCoords[0])<JXG.Math.eps){q=true}if(Math.abs(o.scrCoords[0])<JXG.Math.eps){f=true}if(!q&&!f){return}n=[];n[0]=g.stdform[0]-g.stdform[1]*g.board.origin.scrCoords[1]/g.board.unitX+g.stdform[2]*g.board.origin.scrCoords[2]/g.board.unitY;n[1]=g.stdform[1]/g.board.unitX;n[2]=g.stdform[2]/(-g.board.unitY);if(isNaN(n[0]+n[1]+n[2])){return}u=[];u[0]=JXG.Math.crossProduct(n,[0,0,1]);u[1]=JXG.Math.crossProduct(n,[0,1,0]);u[2]=JXG.Math.crossProduct(n,[-g.board.canvasHeight,0,1]);u[3]=JXG.Math.crossProduct(n,[-g.board.canvasWidth,1,0]);for(l=0;l<4;l++){if(Math.abs(u[l][0])>JXG.Math.eps){for(h=2;h>0;h--){u[l][h]/=u[l][0]}u[l][0]=1}}e=false;d=false;if(!q&&p.scrCoords[1]>=0&&p.scrCoords[1]<=g.board.canvasWidth&&p.scrCoords[2]>=0&&p.scrCoords[2]<=g.board.canvasHeight){e=true}if(!f&&o.scrCoords[1]>=0&&o.scrCoords[1]<=g.board.canvasWidth&&o.scrCoords[2]>=0&&o.scrCoords[2]<=g.board.canvasHeight){d=true}if(Math.abs(u[1][0])<JXG.Math.eps){m=u[0];k=u[2]}else{if(Math.abs(u[0][0])<JXG.Math.eps){m=u[1];k=u[3]}else{if(u[1][2]<0){m=u[0];if(u[3][2]>g.board.canvasHeight){k=u[2]}else{k=u[3]}}else{if(u[1][2]>g.board.canvasHeight){m=u[2];if(u[3][2]<0){k=u[0]}else{k=u[3]}}else{m=u[1];if(u[3][2]<0){k=u[0]}else{if(u[3][2]>g.board.canvasHeight){k=u[2]}else{k=u[3]}}}}}}m=new JXG.Coords(JXG.COORDS_BY_SCREEN,m.slice(1),g.board);k=new JXG.Coords(JXG.COORDS_BY_SCREEN,k.slice(1),g.board);if(!e&&!d){if(!q&&f&&!this.isSameDirection(p,o,m)&&!this.isSameDirection(p,o,k)){return}else{if(q&&!f&&!this.isSameDirection(o,p,m)&&!this.isSameDirection(o,p,k)){return}}}if(!e){if(!d){if(this.isSameDir(p,o,m,k)){t=m;r=k}else{r=m;t=k}}else{if(this.isSameDir(p,o,m,k)){t=m}else{t=k}}}else{if(!d){if(this.isSameDir(p,o,m,k)){r=k}else{r=m}}}if(t){p.setCoordinates(JXG.COORDS_BY_USER,t.usrCoords.slice(1))}if(r){o.setCoordinates(JXG.COORDS_BY_USER,r.usrCoords.slice(1))}},isSameDir:function(j,i,f,e){var d=i.usrCoords[1]-j.usrCoords[1],k=i.usrCoords[2]-j.usrCoords[2],h=e.usrCoords[1]-f.usrCoords[1],g=e.usrCoords[2]-f.usrCoords[2];if(d*h+k*g>=0){return true}else{return false}},isSameDirection:function(k,h,f){var e,d,j,i,g=false;e=h.usrCoords[1]-k.usrCoords[1];d=h.usrCoords[2]-k.usrCoords[2];j=f.usrCoords[1]-k.usrCoords[1];i=f.usrCoords[2]-k.usrCoords[2];if(Math.abs(e)<JXG.Math.eps){e=0}if(Math.abs(d)<JXG.Math.eps){d=0}if(Math.abs(j)<JXG.Math.eps){j=0}if(Math.abs(i)<JXG.Math.eps){i=0}if(e>=0&&j>=0){if((d>=0&&i>=0)||(d<=0&&i<=0)){g=true}}else{if(e<=0&&j<=0){if((d>=0&&i>=0)||(d<=0&&i<=0)){g=true}}}return g},intersectLineLine:function(o,n,j){var i=o.point1.coords.usrCoords,g=o.point2.coords.usrCoords,f=n.point1.coords.usrCoords,d=n.point2.coords.usrCoords,h,e,m,l,k;if(!JXG.exists(j)){j=o.board}h=i[1]*g[2]-i[2]*g[1];e=f[1]*d[2]-f[2]*d[1];m=(g[2]-i[2])*(f[1]-d[1])-(i[1]-g[1])*(d[2]-f[2]);if(Math.abs(m)<JXG.Math.eps){m=JXG.Math.eps}l=(h*(f[1]-d[1])-e*(i[1]-g[1]))/m;k=(e*(g[2]-i[2])-h*(d[2]-f[2]))/m;return new JXG.Coords(JXG.COORDS_BY_USER,[l,k],j)},intersectCircleLine:function(k,u,m){var J=u.point1.coords.usrCoords,H=u.point2.coords.usrCoords,g=k.midpoint.coords.usrCoords,B,e,I,G,z,E,C,n,A,v,j,i,D,q,o,f,t,p,F;if(!JXG.exists(m)){m=u.board}B=u.point1.Dist(u.point2);if(B>0){e=k.midpoint.Dist(u.point1);I=k.midpoint.Dist(u.point2);G=((e*e)+(B*B)-(I*I))/(2*B);z=(e*e)-(G*G);z=(z<0)?0:z;E=Math.sqrt(z);C=k.Radius();n=Math.sqrt((C*C)-E*E);A=H[1]-J[1];v=H[2]-J[2];j=g[1]+(E/B)*v;i=g[2]-(E/B)*A;e=(H[1]*v)-(H[2]*A);I=(j*A)+(i*v);D=(v*v)+(A*A);if(Math.abs(D)<JXG.Math.eps){D=JXG.Math.eps}q=((e*v)+(I*A))/D;o=((I*v)-(e*A))/D;f=n/B;t=new JXG.Coords(JXG.COORDS_BY_USER,[q+f*A,o+f*v],m);p=new JXG.Coords(JXG.COORDS_BY_USER,[q-f*A,o-f*v],m);F=k.midpoint.coords.distance(JXG.COORDS_BY_USER,t);if((C<(F-1))||isNaN(F)){return[0]}else{return[2,t,p]}}return[0]},intersectCircleCircle:function(l,k,n){var e={},i=l.Radius(),g=k.Radius(),f=l.midpoint.coords.usrCoords,d=k.midpoint.coords.usrCoords,p,j,t,r,q,o,m;if(!JXG.exists(n)){n=l.board}p=i+g;j=Math.abs(i-g);t=l.midpoint.coords.distance(JXG.COORDS_BY_USER,k.midpoint.coords);if(t>p){return[0]}else{if(t<j){return[0]}else{if(t!=0){e[0]=1;r=d[1]-f[1];q=d[2]-f[2];o=(t*t-g*g+i*i)/(2*t);m=Math.sqrt(i*i-o*o);e[1]=new JXG.Coords(JXG.COORDS_BY_USER,[f[1]+(o/t)*r+(m/t)*q,f[2]+(o/t)*q-(m/t)*r],n);e[2]=new JXG.Coords(JXG.COORDS_BY_USER,[f[1]+(o/t)*r-(m/t)*q,f[2]+(o/t)*q+(m/t)*r],n)}else{return[0]}return e}}},meet:function(g,e,f,h){var d=JXG.Math.eps;if(Math.abs(g[3])<d&&Math.abs(e[3])<d){return this.meetLineLine(g,e,f,h)}else{if(Math.abs(g[3])>=d&&Math.abs(e[3])<d){return this.meetLineCircle(e,g,f,h)}else{if(Math.abs(g[3])<d&&Math.abs(e[3])>=d){return this.meetLineCircle(g,e,f,h)}else{return this.meetCircleCircle(g,e,f,h)}}}},meetLineLine:function(e,d,f,h){var g=JXG.Math.crossProduct(e,d);if(Math.abs(g[0])>JXG.Math.eps){g[1]/=g[0];g[2]/=g[0];g[0]=1}return new JXG.Coords(JXG.COORDS_BY_USER,g,h)},meetLineCircle:function(j,e,o,p){var u,s,r,q,l,h,g,f,m,v;if(e[4]<JXG.Math.eps){return new JXG.Coords(JXG.COORDS_BY_USER,e.slice(6,8),p)}r=e[0];s=e.slice(1,3);u=e[3];q=j[0];l=j.slice(1,3);h=u;g=(s[0]*l[1]-s[1]*l[0]);f=u*q*q-(s[0]*l[0]+s[1]*l[1])*q+r;m=g*g-4*h*f;if(m>=0){m=Math.sqrt(m);v=[(-g+m)/(2*h),(-g-m)/(2*h)];return((o==0)?new JXG.Coords(JXG.COORDS_BY_USER,[-v[0]*(-l[1])-q*l[0],-v[0]*l[0]-q*l[1]],p):new JXG.Coords(JXG.COORDS_BY_USER,[-v[1]*(-l[1])-q*l[0],-v[1]*l[0]-q*l[1]],p))}else{return new JXG.Coords(JXG.COORDS_BY_USER,[0,0,0],p)}},meetCircleCircle:function(f,d,e,g){var h;if(f[4]<JXG.Math.eps){if(Math.abs(this.distance(f.slice(6,2),d.slice(6,8))-d[4])<JXG.Math.eps){return new JXG.Coords(JXG.COORDS_BY_USER,f.slice(6,8),g)}else{return new JXG.Coords(JXG.COORDS_BY_USER,[0,0,0],g)}}if(d[4]<JXG.Math.eps){if(Math.abs(this.distance(d.slice(6,2),f.slice(6,8))-f[4])<JXG.Math.eps){return new JXG.Coords(JXG.COORDS_BY_USER,d.slice(6,8),g)}else{return new JXG.Coords(JXG.COORDS_BY_USER,[0,0,0],g)}}h=[d[3]*f[0]-f[3]*d[0],d[3]*f[1]-f[3]*d[1],d[3]*f[2]-f[3]*d[2],0,1,Infinity,Infinity,Infinity];h=JXG.Math.normalize(h);return this.meetLineCircle(h,f,e,g)},meetCurveCurve:function(r,q,h,k,m){var l=0,o,n,z,x,v,u,g,t,s,p,y,w,j,i;if(!JXG.exists(m)){m=r.board}if(arguments.callee.t1memo){o=arguments.callee.t1memo;n=arguments.callee.t2memo}else{o=h;n=k}t=r.X(o)-q.X(n);s=r.Y(o)-q.Y(n);p=t*t+s*s;y=r.board.D(r.X,r);w=q.board.D(q.X,q);j=r.board.D(r.Y,r);i=q.board.D(q.Y,q);while(p>JXG.Math.eps&&l<10){z=y(o);x=-w(n);v=j(o);u=-i(n);g=z*u-x*v;o-=(u*t-x*s)/g;n-=(z*s-v*t)/g;t=r.X(o)-q.X(n);s=r.Y(o)-q.Y(n);p=t*t+s*s;l++}arguments.callee.t1memo=o;arguments.callee.t2memo=n;if(Math.abs(o)<Math.abs(n)){return(new JXG.Coords(JXG.COORDS_BY_USER,[r.X(o),r.Y(o)],m))}else{return(new JXG.Coords(JXG.COORDS_BY_USER,[q.X(n),q.Y(n)],m))}},meetCurveLine:function(r,q,e,j){var o,l,s,g,p,h,k,w,u,v,n,m,f,d;if(!JXG.exists(j)){j=r.board}for(s=0;s<=1;s++){if(arguments[s].elementClass==JXG.OBJECT_CLASS_CURVE){g=arguments[s]}else{if(arguments[s].elementClass==JXG.OBJECT_CLASS_LINE){p=arguments[s]}else{throw new Error("JSXGraph: Can't call meetCurveLine with parent class "+(arguments[s].elementClass)+".")}}}h=function(i){return p.stdform[0]+p.stdform[1]*g.X(i)+p.stdform[2]*g.Y(i)};if(arguments.callee.t1memo){n=arguments.callee.t1memo;o=JXG.Math.Numerics.root(h,n)}else{n=g.minX();m=g.maxX();o=JXG.Math.Numerics.root(h,[n,m])}arguments.callee.t1memo=o;f=g.X(o);d=g.Y(o);if(e==1){if(arguments.callee.t2memo){n=arguments.callee.t2memo;l=JXG.Math.Numerics.root(h,n)}if(!(Math.abs(l-o)>0.1&&Math.abs(f-g.X(l))>0.1&&Math.abs(d-g.Y(l))>0.1)){u=20;v=(g.maxX()-g.minX())/u;w=g.minX();for(s=0;s<u;s++){l=JXG.Math.Numerics.root(h,[w,w+v]);if(Math.abs(l-o)>0.1&&Math.abs(f-g.X(l))>0.1&&Math.abs(d-g.Y(l))>0.1){break}w+=v}}o=l;arguments.callee.t2memo=o}if(Math.abs(h(o))>JXG.Math.eps){k=0}else{k=1}return(new JXG.Coords(JXG.COORDS_BY_USER,[k,g.X(o),g.Y(o)],j))},projectPointToCircle:function(l,d,f){var i=l.coords.distance(JXG.COORDS_BY_USER,d.midpoint.coords),e=l.coords.usrCoords,g=d.midpoint.coords.usrCoords,k,j,h;if(!JXG.exists(f)){f=l.board}if(Math.abs(i)<JXG.Math.eps){i=JXG.Math.eps}h=d.Radius()/i;k=g[1]+h*(e[1]-g[1]);j=g[2]+h*(e[2]-g[2]);return new JXG.Coords(JXG.COORDS_BY_USER,[k,j],f)},projectPointToLine:function(d,e,g){var f=[0,e.stdform[1],e.stdform[2]];if(!JXG.exists(g)){g=d.board}f=JXG.Math.crossProduct(f,d.coords.usrCoords);return this.meetLineLine(f,e.stdform,0,g)},projectPointToCurve:function(f,i,h){if(!JXG.exists(h)){h=f.board}var e=f.X(),j=f.Y(),g=f.position||0,d=this.projectCoordsToCurve(e,j,g,i,h);f.position=d[1];return d[0]},projectCoordsToCurve:function(n,l,p,q,h){var B,z,e,w,d,k,u,A,r,g,s,o=1000000,m,E,C,f,D,v;if(!JXG.exists(h)){h=q.board}if(q.visProp.curvetype=="parameter"||q.visProp.curvetype=="polar"){m=function(x){var j=n-q.X(x),i=l-q.Y(x);return j*j+i*i};f=m(p);v=20;D=(q.maxX()-q.minX())/v;E=q.minX();for(s=0;s<v;s++){C=m(E);if(C<f){p=E;f=C}E+=D}p=JXG.Math.Numerics.root(JXG.Math.Numerics.D(m),p);if(p<q.minX()){p=q.maxX()+p-q.minX()}if(p>q.maxX()){p=q.minX()+p-q.maxX()}B=new JXG.Coords(JXG.COORDS_BY_USER,[q.X(p),q.Y(p)],h)}else{if(q.visProp.curvetype=="plot"){A=o;for(u=0;u<q.numberPoints;u++){z=n-q.X(u);e=l-q.Y(u);r=Math.sqrt(z*z+e*e);if(r<A){A=r;p=u}if(u==q.numberPoints-1){continue}w=q.X(u+1)-q.X(u);d=q.Y(u+1)-q.Y(u);k=w*w+d*d;if(k>=JXG.Math.eps){g=(z*w+e*d)/k;r=Math.sqrt(z*z+e*e-g*(z*w+e*d))}else{g=0;r=Math.sqrt(z*z+e*e)}if(g>=0&&g<=1&&r<A){p=u+g;A=r}}u=Math.floor(p);g=p-u;if(u<q.numberPoints-1){n=g*q.X(u+1)+(1-g)*q.X(u);l=g*q.Y(u+1)+(1-g)*q.Y(u)}else{n=q.X(u);l=q.Y(u)}B=new JXG.Coords(JXG.COORDS_BY_USER,[n,l],h)}else{p=n;n=p;l=q.Y(p);B=new JXG.Coords(JXG.COORDS_BY_USER,[n,l],h)}}return[q.updateTransform(B),p]},projectPointToTurtle:function(o,r,k){var q,s,n,m,f,p=0,j=0,g=1000000,l,d,e,h=r.objects.length;if(!JXG.exists(k)){k=o.board}for(f=0;f<h;f++){d=r.objects[f];if(d.elementClass==JXG.OBJECT_CLASS_CURVE){q=this.projectPointToCurve(o,d);l=this.distance(q.usrCoords,o.coords.usrCoords);if(l<g){n=q.usrCoords[1];m=q.usrCoords[2];s=o.position;g=l;e=d;j=p}p+=d.numberPoints}}q=new JXG.Coords(JXG.COORDS_BY_USER,[n,m],k);o.position=s+j;return e.updateTransform(q)}};JXG.Complex=function(d,e){this.isComplex=true;if(typeof d=="undefined"){d=0}if(typeof e=="undefined"){e=0}if(d.isComplex){e=d.imaginary;d=d.real}this.real=d;this.imaginary=e;this.absval=0;this.angle=0};JXG.extend(JXG.Complex.prototype,{toString:function(){return""+this.real+" + "+this.imaginary+"i"},add:function(d){if(typeof d=="number"){this.real+=d}else{this.real+=d.real;this.imaginary+=d.imaginary}},sub:function(d){if(typeof d=="number"){this.real-=d}else{this.real-=d.real;this.imaginary-=d.imaginary}},mult:function(f){var e,d;if(typeof f=="number"){this.real*=f;this.imaginary*=f}else{e=this.real;d=this.imaginary;this.real=e*f.real-d*f.imaginary;this.imaginary=e*f.imaginary+d*f.real}},div:function(g){var e,d,f;if(typeof g=="number"){if(Math.abs(g)<Math.eps){this.real=Infinity;this.imaginary=Infinity;return}this.real/=g;this.imaginary/=g}else{if((Math.abs(g.real)<Math.eps)&&(Math.abs(g.imaginary)<Math.eps)){this.real=Infinity;this.imaginary=Infinity;return}e=g.real*g.real+g.imaginary*g.imaginary;f=this.real;d=this.imaginary;this.real=(f*g.real+d*g.imaginary)/e;this.imaginary=(d*g.real-f*g.imaginary)/e}},conj:function(){this.imaginary*=-1}});JXG.C={};JXG.C.add=function(e,d){var f=new JXG.Complex(e);f.add(d);return f};JXG.C.sub=function(e,d){var f=new JXG.Complex(e);f.sub(d);return f};JXG.C.mult=function(e,d){var f=new JXG.Complex(e);f.mult(d);return f};JXG.C.div=function(e,d){var f=new JXG.Complex(e);f.div(d);return f};JXG.C.conj=function(d){var e=new JXG.Complex(d);e.conj();return e};JXG.C.abs=function(d){var e=new JXG.Complex(d);e.conj();e.mult(d);return Math.sqrt(e.real)};JXG.AbstractRenderer=function(){this.vOffsetText=3;this.enhancedRendering=true;this.container=null;this.type=""};JXG.extend(JXG.AbstractRenderer.prototype,{_updateVisual:function(e,g,f){var d;if(f||this.enhancedRendering){g=g||{};if(!e.visProp.draft){if(!g.stroke){this.setObjectStrokeWidth(e,e.visProp.strokewidth);this.setObjectStrokeColor(e,e.visProp.strokecolor,e.visProp.strokeopacity)}if(!g.fill){this.setObjectFillColor(e,e.visProp.fillcolor,e.visProp.fillopacity)}if(!g.dash){this.setDashStyle(e,e.visProp)}if(!g.shadow){this.setShadow(e)}if(!g.gradient){this.setShadow(e)}}else{this.setDraft(e)}}},drawPoint:function(e){var d,f=JXG.Point.prototype.normalizeFace.call(this,e.visProp.face);if(f==="o"){d="ellipse"}else{if(f==="[]"){d="rect"}else{d="path"}}this.appendChildPrim(this.createPrim(d,e.id),e.visProp.layer);this.appendNodesToElement(e,d);this._updateVisual(e,{dash:true,shadow:true},true);this.updatePoint(e)},updatePoint:function(e){var d=e.visProp.size,f=JXG.Point.prototype.normalizeFace.call(this,e.visProp.face);if(!isNaN(e.coords.scrCoords[2]+e.coords.scrCoords[1])){this._updateVisual(e,{dash:false,shadow:false});d*=((!e.board||!e.board.options.point.zoom)?1:Math.sqrt(e.board.zoomX*e.board.zoomY));if(f==="o"){this.updateEllipsePrim(e.rendNode,e.coords.scrCoords[1],e.coords.scrCoords[2],d+1,d+1)}else{if(f==="[]"){this.updateRectPrim(e.rendNode,e.coords.scrCoords[1]-d,e.coords.scrCoords[2]-d,d*2,d*2)}else{this.updatePathPrim(e.rendNode,this.updatePathStringPoint(e,d,f),e.board)}}this.setShadow(e)}},changePointStyle:function(d){var e=this.getElementById(d.id);if(JXG.exists(e)){this.remove(e)}this.drawPoint(d);JXG.clearVisPropOld(d);if(!d.visProp.visible){this.hide(d)}if(d.visProp.draft){this.setDraft(d)}},drawLine:function(d){this.appendChildPrim(this.createPrim("line",d.id),d.visProp.layer);this.appendNodesToElement(d,"lines");this.updateLine(d)},updateLine:function(f){var e=new JXG.Coords(JXG.COORDS_BY_USER,f.point1.coords.usrCoords,f.board),d=new JXG.Coords(JXG.COORDS_BY_USER,f.point2.coords.usrCoords,f.board);JXG.Math.Geometry.calcStraight(f,e,d);this.updateLinePrim(f.rendNode,e.scrCoords[1],e.scrCoords[2],d.scrCoords[1],d.scrCoords[2],f.board);this.makeArrows(f);this._updateVisual(f,{fill:true})},drawTicks:function(d){var e=this.createPrim("path",d.id);this.appendChildPrim(e,d.visProp.layer);this.appendNodesToElement(d,"path")},updateTicks:function(d,g,e,h,f){},drawCurve:function(d){this.appendChildPrim(this.createPrim("path",d.id),d.visProp.layer);this.appendNodesToElement(d,"path");this._updateVisual(d,{shadow:true},true);this.updateCurve(d)},updateCurve:function(d){this._updateVisual(d);this.updatePathPrim(d.rendNode,this.updatePathStringPrim(d),d.board);this.makeArrows(d)},drawEllipse:function(d){this.appendChildPrim(this.createPrim("ellipse",d.id),d.visProp.layer);this.appendNodesToElement(d,"ellipse");this.updateEllipse(d)},updateEllipse:function(e){this._updateVisual(e);var d=e.Radius();if(d>0&&!isNaN(d+e.midpoint.coords.scrCoords[1]+e.midpoint.coords.scrCoords[2])&&d*e.board.unitX<20000){this.updateEllipsePrim(e.rendNode,e.midpoint.coords.scrCoords[1],e.midpoint.coords.scrCoords[2],(d*e.board.unitX),(d*e.board.unitY))}},drawPolygon:function(d){this.appendChildPrim(this.createPrim("polygon",d.id),d.visProp.layer);this.appendNodesToElement(d,"polygon");this.updatePolygon(d)},updatePolygon:function(d){this._updateVisual(d,{stroke:true,dash:true});this.updatePolygonPrim(d.rendNode,d)},displayCopyright:function(d,e){},drawInternalText:function(d){},updateInternalText:function(d){},drawText:function(d){var e;if(d.visProp.display==="html"){e=this.container.ownerDocument.createElement("div");e.style.position="absolute";e.className="JXGtext";e.style.zIndex="10";this.container.appendChild(e);e.setAttribute("id",this.container.id+"_"+d.id)}else{e=this.drawInternalText(d)}d.rendNode=e;d.htmlStr="";this.updateText(d)},updateText:function(d){var e=d.plaintext;if(d.visProp.visible){this.updateTextStyle(d);if(d.visProp.display==="html"){if(!isNaN(d.coords.scrCoords[1]+d.coords.scrCoords[2])){d.rendNode.style.left=parseInt(d.coords.scrCoords[1])+"px";d.rendNode.style.top=parseInt(d.coords.scrCoords[2]-parseInt(d.visProp.fontsize)+this.vOffsetText)+"px"}if(d.htmlStr!==e){d.rendNode.innerHTML=e;d.htmlStr=e;if(d.visProp.useasciimathml){AMprocessNode(d.rendNode,false)}if(d.visProp.usemathjax){MathJax.Hub.Typeset(d.rendNode)}}this.transformImage(d,d.transformations)}else{this.updateInternalText(d)}}},updateTextStyle:function(f){var d=JXG.evaluate(f.visProp.fontsize);if(f.visProp.display==="html"||this.type!="canvas"){try{f.rendNode.style.fontSize=d+"px"}catch(g){f.rendNode.style.fontSize=d}}this.setObjectStrokeColor(f,f.visProp.strokecolor,f.visProp.strokeopacity)},drawImage:function(d){},updateImage:function(d){this.updateRectPrim(d.rendNode,d.coords.scrCoords[1],d.coords.scrCoords[2]-d.size[1],d.size[0],d.size[1]);this.updateImageURL(d);this.transformImage(d,d.transformations);this._updateVisual(d,{stroke:true,dash:true},true)},joinTransforms:function(n,o){var k=[[1,0,0],[0,1,0],[0,0,1]],g=n.board.origin.scrCoords[1],f=n.board.origin.scrCoords[2],e=n.board.unitX,d=n.board.unitY,r=[[1,0,0],[-g,1,0],[-f,0,1]],q=[[1,0,0],[0,1/e,0],[0,0,-1/d]],h=[[1,0,0],[0,e,0],[0,0,-d]],j=[[1,0,0],[g,1,0],[f,0,1]],l,p=o.length;for(l=0;l<p;l++){k=JXG.Math.matMatMult(r,k);k=JXG.Math.matMatMult(q,k);k=JXG.Math.matMatMult(o[l].matrix,k);k=JXG.Math.matMatMult(h,k);k=JXG.Math.matMatMult(j,k)}return k},transformImage:function(e,d){},updateImageURL:function(d){},appendChildPrim:function(d,e){},appendNodesToElement:function(d,e){},createPrim:function(d,e){return null},remove:function(d){},makeArrows:function(d){},updateEllipsePrim:function(e,d,h,g,f){},updateLinePrim:function(i,e,d,g,f,h){},updatePathPrim:function(f,d,e){},updatePathStringPoint:function(e,d,f){},updatePathStringPrim:function(d){},updatePolygonPrim:function(e,d){},updateRectPrim:function(g,d,i,e,f){},setPropertyPrim:function(e,d,f){},show:function(d){},hide:function(d){},setBuffering:function(e,d){},setDashStyle:function(d){},setDraft:function(d){if(!d.visProp.draft){return}var e=d.board.options.elements.draft.color,f=d.board.options.elements.draft.opacity;if(d.type===JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(d,e,f)}else{if(d.elementClass===JXG.OBJECT_CLASS_POINT){this.setObjectFillColor(d,e,f)}else{this.setObjectFillColor(d,"none",0)}this.setObjectStrokeColor(d,e,f);this.setObjectStrokeWidth(d,d.board.options.elements.draft.strokeWidth)}},removeDraft:function(d){if(d.type===JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(d,d.visProp.fillcolor,d.visProp.fillopacity)}else{if(d.type===JXG.OBJECT_CLASS_POINT){this.setObjectFillColor(d,d.visProp.fillcolor,d.visProp.fillopacity)}this.setObjectStrokeColor(d,d.visProp.strokecolor,d.visProp.strokeopacity);this.setObjectStrokeWidth(d,d.visProp.strokewidth)}},setGradient:function(d){},updateGradient:function(d){},setObjectFillColor:function(f,d,e){},setObjectStrokeColor:function(f,d,e){},setObjectStrokeWidth:function(d,e){},setShadow:function(d){},highlight:function(e){var d,f=e.visProp;if(!f.draft){if(e.type===JXG.OBJECT_CLASS_POINT){this.setObjectStrokeColor(e,f.highlightstrokecolor,f.highlightstrokeopacity);this.setObjectFillColor(e,f.highlightstrokecolor,f.highlightstrokeopacity)}else{if(e.type===JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(e,f.highlightfillcolor,f.highlightfillopacity);for(d=0;d<e.borders.length;d++){this.setObjectStrokeColor(e.borders[d],e.borders[d].visProp.highlightstrokecolor,e.borders[d].visProp.highlightstrokeopacity)}}else{this.setObjectStrokeColor(e,f.highlightstrokecolor,f.highlightstrokeopacity);this.setObjectFillColor(e,f.highlightfillcolor,f.highlightfillopacity)}}if(f.highlightstrokewidth){this.setObjectStrokeWidth(e,f.highlightstrokewidth)}}return this},noHighlight:function(e){var d,f=e.visProp;if(!e.visProp.draft){if(e.type===JXG.OBJECT_CLASS_POINT){this.setObjectStrokeColor(e,f.strokecolor,f.strokeopacity);this.setObjectFillColor(e,f.strokecolor,f.strokeopacity)}else{if(e.type===JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(e,f.fillcolor,f.fillopacity);for(d=0;d<e.borders.length;d++){this.setObjectStrokeColor(e.borders[d],e.borders[d].visProp.strokecolor,e.borders[d].visProp.strokeopacity)}}else{this.setObjectStrokeColor(e,f.strokecolor,f.strokeopacity);this.setObjectFillColor(e,f.fillcolor,f.fillopacity)}}this.setObjectStrokeWidth(e,f.strokewidth)}return this},suspendRedraw:function(){},unsuspendRedraw:function(){},drawZoomBar:function(e){var g,f,d=function(h,j){var i;i=g.createElement("span");f.appendChild(i);i.appendChild(document.createTextNode(h));JXG.addEvent(i,"click",j,e)};g=e.containerObj.ownerDocument;f=g.createElement("div");f.setAttribute("id",e.containerObj.id+"_navigationbar");f.style.color=e.options.navbar.strokeColor;f.style.backgroundColor=e.options.navbar.fillColor;f.style.padding=e.options.navbar.padding;f.style.position=e.options.navbar.position;f.style.fontSize=e.options.navbar.fontSize;f.style.cursor=e.options.navbar.cursor;f.style.zIndex=e.options.navbar.zIndex;e.containerObj.appendChild(f);f.style.right=e.options.navbar.right;f.style.bottom=e.options.navbar.bottom;d("\u00A0\u2013\u00A0",e.zoomOut);d("\u00A0o\u00A0",e.zoom100);d("\u00A0+\u00A0",e.zoomIn);d("\u00A0\u2190\u00A0",e.clickLeftArrow);d("\u00A0\u2193\u00A0",e.clickUpArrow);d("\u00A0\u2191\u00A0",e.clickDownArrow);d("\u00A0\u2192\u00A0",e.clickRightArrow)},getElementById:function(d){return document.getElementById(this.container.id+"_"+d)},resize:function(d,e){}});JXG.FileReader=new function(){this.parseFileContent=function(d,g,i,f){if(!JXG.exists(f)){f=true}this.request=false;var h;try{this.request=new XMLHttpRequest();if(i.toLowerCase()=="raw"){this.request.overrideMimeType("text/plain; charset=iso-8859-1")}else{this.request.overrideMimeType("text/xml; charset=iso-8859-1")}}catch(h){try{this.request=new ActiveXObject("Msxml2.XMLHTTP")}catch(h){try{this.request=new ActiveXObject("Microsoft.XMLHTTP")}catch(h){this.request=false}}}if(!this.request){alert("AJAX not activated!");return}this.request.open("GET",d,f);if(i.toLowerCase()=="raw"){this.cbp=function(){var e=this.request;if(e.readyState==4){g(e.responseText)}}}else{this.cbp=function(){var e=this.request;if(e.readyState==4){var j="";if(typeof e.responseStream!="undefined"&&(e.responseText.slice(0,2)=="PK"||JXG.Util.asciiCharCodeAt(e.responseText.slice(0,1),0)==31)){j=JXG.Util.Base64.decode(BinFileReader(e))}else{j=e.responseText}this.parseString(j,g,i,false)}}}this.cb=JXG.bind(this.cbp,this);this.request.onreadystatechange=this.cb;try{this.request.send(null)}catch(h){throw new Error("JSXGraph: problems opening "+d+" !")}};this.cleanWhitespace=function(d){var e=d.firstChild;while(e!=null){if(e.nodeType==3&&!/\S/.test(e.nodeValue)){d.removeChild(e)}else{if(e.nodeType==1){this.cleanWhitespace(e)}}e=e.nextSibling}};this.stringToXMLTree=function(e){if(typeof DOMParser=="undefined"){DOMParser=function(){};DOMParser.prototype.parseFromString=function(h,i){if(typeof ActiveXObject!="undefined"){var g=new ActiveXObject("MSXML.DomDocument");g.loadXML(h);return g}}}var f=new DOMParser();var d=f.parseFromString(e,"text/xml");this.cleanWhitespace(d);return d};this.parseString=function(h,f,i,e){var d,g;if(i.toLowerCase()=="cdy"||i.toLowerCase()=="cinderella"){if(e){h=JXG.Util.Base64.decode(h)}h=JXG.CinderellaReader.readCinderella(h,f);f.xmlString=h;return}if(i.toLowerCase()=="tracenpoche"){f.xmlString=JXG.TracenpocheReader.readTracenpoche(h,f);return}if(i.toLowerCase()=="graph"){h=JXG.GraphReader.readGraph(h,f,false);return}if(i.toLowerCase()=="digraph"){h=JXG.GraphReader.readGraph(h,f,true);return}if(i.toLowerCase()=="geonext"){h=JXG.GeonextReader.prepareString(h)}if(i.toLowerCase()=="geogebra"){e=h.slice(0,2)!=="PK";h=JXG.GeogebraReader.prepareString(h,e)}if(i.toLowerCase()=="intergeo"){if(e){h=JXG.Util.Base64.decode(h)}h=JXG.IntergeoReader.prepareString(h)}f.xmlString=h;d=this.stringToXMLTree(h);this.readElements(d,f,i)};this.readElements=function(d,e,f){if(f.toLowerCase()=="geonext"){e.suspendUpdate();if(d.getElementsByTagName("GEONEXT").length!=0){JXG.GeonextReader.readGeonext(d,e)}e.unsuspendUpdate()}else{if(d.getElementsByTagName("geogebra").length!=0){JXG.GeogebraReader.readGeogebra(d,e)}else{if(f.toLowerCase()=="intergeo"){JXG.IntergeoReader.readIntergeo(d,e)}}}}};if(/msie/i.test(navigator.userAgent)&&!/opera/i.test(navigator.userAgent)){document.write('<script type="text/vbscript">\nFunction Base64Encode(inData)\n  Const Base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"\n  Dim cOut, sOut, I\n  For I = 1 To LenB(inData) Step 3\n    Dim nGroup, pOut, sGroup\n    nGroup = &H10000 * AscB(MidB(inData, I, 1)) + _\n      &H100 * MyASC(MidB(inData, I + 1, 1)) + MyASC(MidB(inData, I + 2, 1))\n    nGroup = Oct(nGroup)\n    nGroup = String(8 - Len(nGroup), "0") & nGroup\n    pOut = Mid(Base64, CLng("&o" & Mid(nGroup, 1, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 3, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 5, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 7, 2)) + 1, 1)\n    sOut = sOut + pOut\n  Next\n  Select Case LenB(inData) Mod 3\n    Case 1: \'8 bit final\n      sOut = Left(sOut, Len(sOut) - 2) + "=="\n    Case 2: \'16 bit final\n      sOut = Left(sOut, Len(sOut) - 1) + "="\n  End Select\n  Base64Encode = sOut\nEnd Function\n\nFunction MyASC(OneChar)\n  If OneChar = "" Then MyASC = 0 Else MyASC = AscB(OneChar)\nEnd Function\n\nFunction BinFileReader(xhr)\n    Dim byteString\n    Dim b64String\n    Dim i\n    byteString = xhr.responseBody\n    ReDim byteArray(LenB(byteString))\n    For i = 1 To LenB(byteString)\n        byteArray(i-1) = AscB(MidB(byteString, i, 1))\n    Next\n    b64String = Base64Encode(byteString)\n    BinFileReader = b64String\nEnd Function\n<\/script>\n')}JXG.GeonextParser={};JXG.GeonextParser.replacePow=function(f){var k,n,l,j,m,g,d,e,h,q,o;f=f.replace(/(\s*)\^(\s*)/g,"^");h=f.indexOf("^");while(h>=0){e=f.slice(0,h);q=f.slice(h+1);if(e.charAt(e.length-1)==")"){k=1;n=e.length-2;while(n>=0&&k>0){l=e.charAt(n);if(l==")"){k++}else{if(l=="("){k--}}n--}if(k==0){j="";g=e.substring(0,n+1);d=n;while(d>=0&&g.substr(d,1).match(/([\w\.]+)/)){j=RegExp.$1+j;d--}j+=e.substring(n+1,e.length);j=j.replace(/([\(\)\+\*\%\^\-\/\]\[])/g,"\\$1")}else{throw new Error("JSXGraph: Missing '(' in expression")}}else{j="[\\w\\.]+"}if(q.match(/^([\w\.]*\()/)){k=1;n=RegExp.$1.length;while(n<q.length&&k>0){l=q.charAt(n);if(l==")"){k--}else{if(l=="("){k++}}n++}if(k==0){m=q.substring(0,n);m=m.replace(/([\(\)\+\*\%\^\-\/\[\]])/g,"\\$1")}else{throw new Error("JSXGraph: Missing ')' in expression")}}else{m="[\\w\\.]+"}o=new RegExp("("+j+")\\^("+m+")");f=f.replace(o,"JXG.Math.pow($1,$2)");h=f.indexOf("^")}return f};JXG.GeonextParser.replaceIf=function(e){var r="",f,q,h=null,d=null,l=null,g,p,j,m,k,n,o;g=e.indexOf("If(");if(g<0){return e}e=e.replace(/""/g,"0");while(g>=0){f=e.slice(0,g);q=e.slice(g+3);j=1;p=0;m=-1;k=-1;while(p<q.length&&j>0){n=q.charAt(p);if(n==")"){j--}else{if(n=="("){j++}else{if(n==","&&j==1){if(m<0){m=p}else{k=p}}}}p++}o=q.slice(0,p-1);q=q.slice(p);if(m<0){return""}if(k<0){return""}h=o.slice(0,m);d=o.slice(m+1,k);l=o.slice(k+1);h=this.replaceIf(h);d=this.replaceIf(d);l=this.replaceIf(l);r+=f+"(("+h+")?("+d+"):("+l+"))";e=q;h=null;d=null;g=e.indexOf("If(")}r+=q;return r};JXG.GeonextParser.replaceSub=function(f){if(f.indexOf){}else{return f}var e=f.indexOf("_{"),d;while(e>=0){f=f.substr(0,e)+f.substr(e).replace(/_\{/,"<sub>");d=f.substr(e).indexOf("}");if(d>=0){f=f.substr(0,d)+f.substr(d).replace(/\}/,"</sub>")}e=f.indexOf("_{")}e=f.indexOf("_");while(e>=0){f=f.substr(0,e)+f.substr(e).replace(/_(.?)/,"<sub>$1</sub>");e=f.indexOf("_")}return f};JXG.GeonextParser.replaceSup=function(f){if(f.indexOf){}else{return f}var e=f.indexOf("^{"),d;while(e>=0){f=f.substr(0,e)+f.substr(e).replace(/\^\{/,"<sup>");d=f.substr(e).indexOf("}");if(d>=0){f=f.substr(0,d)+f.substr(d).replace(/\}/,"</sup>")}e=f.indexOf("^{")}e=f.indexOf("^");while(e>=0){f=f.substr(0,e)+f.substr(e).replace(/\^(.?)/,"<sup>$1</sup>");e=f.indexOf("^")}return f};JXG.GeonextParser.replaceNameById=function(g,j){var l=0,d,k,h,f,e=["X","Y","L","V"];for(f=0;f<e.length;f++){l=g.indexOf(e[f]+"(");while(l>=0){if(l>=0){d=g.indexOf(")",l+2);if(d>=0){k=g.slice(l+2,d);k=k.replace(/\\(['"])?/g,"$1");h=j.elementsByName[k];g=g.slice(0,l+2)+h.id+g.slice(d)}}d=g.indexOf(")",l+2);l=g.indexOf(e[f]+"(",d)}}l=g.indexOf("Dist(");while(l>=0){if(l>=0){d=g.indexOf(",",l+5);if(d>=0){k=g.slice(l+5,d);k=k.replace(/\\(['"])?/g,"$1");h=j.elementsByName[k];g=g.slice(0,l+5)+h.id+g.slice(d)}}d=g.indexOf(",",l+5);l=g.indexOf(",",d);d=g.indexOf(")",l+1);if(d>=0){k=g.slice(l+1,d);k=k.replace(/\\(['"])?/g,"$1");h=j.elementsByName[k];g=g.slice(0,l+1)+h.id+g.slice(d)}d=g.indexOf(")",l+1);l=g.indexOf("Dist(",d)}e=["Deg","Rad"];for(f=0;f<e.length;f++){l=g.indexOf(e[f]+"(");while(l>=0){if(l>=0){d=g.indexOf(",",l+4);if(d>=0){k=g.slice(l+4,d);k=k.replace(/\\(['"])?/g,"$1");h=j.elementsByName[k];g=g.slice(0,l+4)+h.id+g.slice(d)}}d=g.indexOf(",",l+4);l=g.indexOf(",",d);d=g.indexOf(",",l+1);if(d>=0){k=g.slice(l+1,d);k=k.replace(/\\(['"])?/g,"$1");h=j.elementsByName[k];g=g.slice(0,l+1)+h.id+g.slice(d)}d=g.indexOf(",",l+1);l=g.indexOf(",",d);d=g.indexOf(")",l+1);if(d>=0){k=g.slice(l+1,d);k=k.replace(/\\(['"])?/g,"$1");h=j.elementsByName[k];g=g.slice(0,l+1)+h.id+g.slice(d)}d=g.indexOf(")",l+1);l=g.indexOf(e[f]+"(",d)}}return g};JXG.GeonextParser.replaceIdByObj=function(d){var e=/(X|Y|L)\(([\w_]+)\)/g;d=d.replace(e,'this.board.objects["$2"].$1()');e=/(V)\(([\w_]+)\)/g;d=d.replace(e,'this.board.objects["$2"].Value()');e=/(Dist)\(([\w_]+),([\w_]+)\)/g;d=d.replace(e,'this.board.objects["$2"].Dist(this.board.objects["$3"])');e=/(Deg)\(([\w_]+),([ \w\[\w_]+),([\w_]+)\)/g;d=d.replace(e,'JXG.Math.Geometry.trueAngle(this.board.objects["$2"],this.board.objects["$3"],this.board.objects["$4"])');e=/Rad\(([\w_]+),([\w_]+),([\w_]+)\)/g;d=d.replace(e,'JXG.Math.Geometry.rad(this.board.objects["$1"],this.board.objects["$2"],this.board.objects["$3"])');return d};JXG.GeonextParser.geonext2JS=function(e,g){var h,f,d,k=["Abs","ACos","ASin","ATan","Ceil","Cos","Exp","Factorial","Floor","Log","Max","Min","Random","Round","Sin","Sqrt","Tan","Trunc"],j=["Math.abs","Math.acos","Math.asin","Math.atan","Math.ceil","Math.cos","Math.exp","JXG.Math.factorial","Math.floor","Math.log","Math.max","Math.min","Math.random","this.board.round","Math.sin","Math.sqrt","Math.tan","Math.ceil"];e=e.replace(/&lt;/g,"<");e=e.replace(/&gt;/g,">");e=e.replace(/&amp;/g,"&");f=e;f=this.replaceNameById(f,g);f=this.replaceIf(f);f=this.replacePow(f);f=this.replaceIdByObj(f);for(d=0;d<k.length;d++){h=new RegExp(["(\\W|^)(",k[d],")"].join(""),"ig");f=f.replace(h,["$1",j[d]].join(""))}f=f.replace(/True/g,"true");f=f.replace(/False/g,"false");f=f.replace(/fasle/g,"false");f=f.replace(/Pi/g,"Math.PI");return f};JXG.GeonextParser.findDependencies=function(h,e,g){if(typeof g=="undefined"){g=h.board}var i=g.elementsByName,f,j,d;for(f in i){if(f!=h.name){if(i[f].type==JXG.OBJECT_TYPE_TEXT){if(!i[f].visProp.islabel){d=f.replace(/\[/g,"\\[");d=d.replace(/\]/g,"\\]");j=new RegExp("\\(([\\w\\[\\]'_ ]+,)*("+d+")(,[\\w\\[\\]'_ ]+)*\\)","g");if(e.search(j)>=0){i[f].addChild(h)}}}else{d=f.replace(/\[/g,"\\[");d=d.replace(/\]/g,"\\]");j=new RegExp("\\(([\\w\\[\\]'_ ]+,)*("+d+")(,[\\w\\[\\]'_ ]+)*\\)","g");if(e.search(j)>=0){i[f].addChild(h)}}}}};JXG.Board=function(d,i,e,n,m,l,k,j,f,g,h){this.BOARD_MODE_NONE=0;this.BOARD_MODE_DRAG=1;this.BOARD_MODE_MOVE_ORIGIN=2;this.BOARD_QUALITY_LOW=1;this.BOARD_QUALITY_HIGH=2;this.BOARD_MODE_CONSTRUCT=16;this.CONSTRUCTION_TYPE_POINT=1129599060;this.CONSTRUCTION_TYPE_CIRCLE=1129595724;this.CONSTRUCTION_TYPE_LINE=1129598030;this.CONSTRUCTION_TYPE_GLIDER=1129596740;this.CONSTRUCTION_TYPE_MIDPOINT=1129598288;this.CONSTRUCTION_TYPE_PERPENDICULAR=1129599044;this.CONSTRUCTION_TYPE_PARALLEL=1129599052;this.CONSTRUCTION_TYPE_INTERSECTION=1129597267;this.container=d;this.containerObj=document.getElementById(this.container);if(this.containerObj==null){throw new Error("\nJSXGraph: HTML container element '"+(d)+"' not found.")}this.renderer=i;this.grids=[];this.options=JXG.deepCopy(JXG.Options);this.dimension=2;this.origin={};this.origin.usrCoords=[1,0,0];this.origin.scrCoords=[1,n[0],n[1]];this.zoomX=m;this.zoomY=l;this.unitX=k*this.zoomX;this.unitY=j*this.zoomY;this.canvasWidth=f;this.canvasHeight=g;if(JXG.exists(e)&&e!==""&&!JXG.exists(document.getElementById(e))){this.id=e}else{this.id=this.generateId()}this.hooks=[];this.dependentBoards=[];this.objects={};this.groups={};this.animationObjects={};this.highlightedObjects={};this.numObjects=0;this.elementsByName={};this.mode=this.BOARD_MODE_NONE;this.updateQuality=this.BOARD_QUALITY_HIGH;this.isSuspendedRedraw=false;this.calculateSnapSizes();this.drag_dx=0;this.drag_dy=0;this.mouse=null;this.touches=[];this.xmlString="";this.cPos=[];this.touchMoveLast=0;this.showCopyright=false;if((h!=null&&h)||(h==null&&this.options.showCopyright)){this.showCopyright=true;this.renderer.displayCopyright(JXG.JSXGraph.licenseText,this.options.text.fontSize)}this.needsFullUpdate=false;this.reducedUpdate=false;this.currentCBDef="none";this.geonextCompatibilityMode=false;if(this.options.text.useASCIIMathML&&translateASCIIMath){init()}else{this.options.text.useASCIIMathML=false}this.addEventHandlers()};JXG.extend(JXG.Board.prototype,{generateName:function(f){if(f.type==JXG.OBJECT_TYPE_TICKS){return""}var l,h=3,e="",m="",n=[],d="",k,g;if(f.elementClass==JXG.OBJECT_CLASS_POINT){l=["","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"]}else{l=["","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"]}switch(f.type){case JXG.OBJECT_TYPE_POLYGON:e="P_{";m="}";break;case JXG.OBJECT_TYPE_CIRCLE:e="k_{";m="}";break;case JXG.OBJECT_TYPE_ANGLE:e="W_{";m="}";break;default:if(f.elementClass!=JXG.OBJECT_CLASS_POINT&&f.elementClass!=JXG.OBJECT_CLASS_LINE){e="s_{";m="}"}}for(k=0;k<h;k++){n[k]=0}while(n[h-1]<l.length){for(n[0]=1;n[0]<l.length;n[0]++){d=e;for(k=h;k>0;k--){d+=l[n[k-1]]}if(this.elementsByName[d+m]==null){return d+m}}n[0]=l.length;for(k=1;k<h;k++){if(n[k-1]==l.length){n[k-1]=1;n[k]++}}}return""},generateId:function(){var d=1;while(JXG.JSXGraph.boards["jxgBoard"+d]!=null){d=Math.round(Math.random()*65535)}return("jxgBoard"+d)},setId:function(g,f){var e=this.numObjects++,d=g.id;if(d==""||!JXG.exists(d)){d=this.id+f+e}g.id=d;this.objects[d]=g;return d},finalizeAdding:function(d){if(!d.visProp.visible){this.renderer.hide(d)}},finalizeLabel:function(d){if(d.hasLabel&&!d.label.content.visProp.islabel&&!d.label.content.visProp.visible){this.renderer.hide(d.label.content)}},getCoordsTopLeftCorner:function(){var e=this.containerObj,d=JXG.getOffset(e),f;if(this.mode===JXG.BOARD_MODE_DRAG||this.mode===JXG.BOARD_MODE_MOVE_ORIGIN){return this.cPos}f=parseInt(JXG.getStyle(e,"borderLeftWidth"));if(isNaN(f)){f=0}d[0]+=f;f=parseInt(JXG.getStyle(e,"borderTopWidth"));if(isNaN(f)){f=0}d[1]+=f;f=parseInt(JXG.getStyle(e,"paddingLeft"));if(isNaN(f)){f=0}d[0]+=f;f=parseInt(JXG.getStyle(e,"paddingTop"));if(isNaN(f)){f=0}d[1]+=f;this.cPos=d;return d},getMousePosition:function(h,f){var g=this.getCoordsTopLeftCorner(),d;d=JXG.getPosition(h,f);return[d[0]-g[0],d[1]-g[1]]},initMoveOrigin:function(d,e){this.drag_dx=d-this.origin.scrCoords[1];this.drag_dy=e-this.origin.scrCoords[2];this.mode=this.BOARD_MODE_MOVE_ORIGIN},initMoveObject:function(e,l){var k,g,j=[],d,f,h;this.mode=this.BOARD_MODE_DRAG;for(g in this.objects){k=this.objects[g];if((this.geonextCompatibilityMode&&(k.elementClass==JXG.OBJECT_CLASS_POINT||k.type==JXG.OBJECT_TYPE_TEXT)||!this.geonextCompatibilityMode)&&k.isDraggable&&k.visProp.visible&&(!k.visProp.fixed)&&(!k.visProp.frozen)&&JXG.exists(k.hasPoint)&&k.hasPoint(e,l)){h=false;if(!JXG.isPoint(k)){d=j.length;for(f=0;f<d;f++){if(JXG.exists(k.ancestors[j[f].id])){h=true;break}}}if(!h){j.push(k)}}}return j},moveObject:function(d,i,h){var e=new JXG.Coords(JXG.COORDS_BY_SCREEN,this.getScrCoordsOfMouse(d,i),this),f=h.obj,g;if(f.type!=JXG.OBJECT_TYPE_GLIDER){if(!isNaN(h.targets[0].Xprev+h.targets[0].Yprev)){f.setPositionDirectly(JXG.COORDS_BY_SCREEN,e.scrCoords[1],e.scrCoords[2],h.targets[0].Xprev,h.targets[0].Yprev)}h.targets[0].Xprev=e.scrCoords[1];h.targets[0].Yprev=e.scrCoords[2];this.update(f)}else{if(f.type==JXG.OBJECT_TYPE_GLIDER){g=f.coords;f.setPositionDirectly(JXG.COORDS_BY_USER,e.usrCoords[1],e.usrCoords[2]);if(f.slideObject.type==JXG.OBJECT_TYPE_CIRCLE){f.coords=JXG.Math.Geometry.projectPointToCircle(f,f.slideObject,this)}else{if(f.slideObject.elementClass==JXG.OBJECT_CLASS_LINE){f.coords=JXG.Math.Geometry.projectPointToLine(f,f.slideObject,this)}}if(f.group.length!=0){f.group[f.group.length-1].dX=f.coords.scrCoords[1]-g.scrCoords[1];f.group[f.group.length-1].dY=f.coords.scrCoords[2]-g.scrCoords[2];f.group[f.group.length-1].update(this)}else{this.update(f)}}}this.updateInfobox(f)},highlightElements:function(d,g){var e,f;for(e in this.objects){f=this.objects[e];if(JXG.exists(f.hasPoint)&&f.visProp.visible&&f.hasPoint(d,g)){this.updateInfobox(f);if(this.highlightedObjects[e]==null){this.highlightedObjects[e]=f;f.highlight()}}}},addEventHandlers:function(){JXG.addEvent(this.containerObj,"mousedown",this.mouseDownListener,this);JXG.addEvent(this.containerObj,"mousemove",this.mouseMoveListener,this);JXG.addEvent(document,"mouseup",this.mouseUpListener,this);JXG.addEvent(this.containerObj,"touchstart",this.touchStartListener,this);JXG.addEvent(this.containerObj,"touchmove",this.touchMoveListener,this);JXG.addEvent(this.containerObj,"touchend",this.touchEndListener,this);JXG.addEvent(this.containerObj,"mousewheel",this.mouseWheelListener,this);JXG.addEvent(this.containerObj,"DOMMouseScroll",this.mouseWheelListener,this);this.containerObj.oncontextmenu=function(d){if(JXG.exists(d)){d.preventDefault()}return false}},removeEventHandlers:function(){JXG.removeEvent(this.containerObj,"mousedown",this.mouseDownListener,this);JXG.removeEvent(this.containerObj,"mousemove",this.mouseMoveListener,this);JXG.removeEvent(document,"mouseup",this.mouseUpListener,this);JXG.removeEvent(this.containerObj,"touchstart",this.touchStartListener,this);JXG.removeEvent(this.containerObj,"touchmove",this.touchMoveListener,this);JXG.removeEvent(this.containerObj,"touchend",this.touchEndListener,this);JXG.removeEvent(this.containerObj,"mousewheel",this.mouseWheelListener,this);JXG.removeEvent(this.containerObj,"DOMMouseScroll",this.mouseWheelListener,this)},clickLeftArrow:function(){this.moveOrigin(this.origin.scrCoords[1]+this.canvasWidth*0.1,this.origin.scrCoords[2]);return this},clickRightArrow:function(){this.moveOrigin(this.origin.scrCoords[1]-this.canvasWidth*0.1,this.origin.scrCoords[2]);return this},clickUpArrow:function(){this.moveOrigin(this.origin.scrCoords[1],this.origin.scrCoords[2]+this.canvasHeight*0.1);return this},clickDownArrow:function(){this.moveOrigin(this.origin.scrCoords[1],this.origin.scrCoords[2]-this.canvasHeight*0.1);return this},touchStartListener:function(m){var h,k,d,f,o=this.options.precision.touch,n=false,l=[],g;m.preventDefault();m.stopPropagation();this.updateHooks("mousedown",m);if((this.mode===this.BOARD_MODE_NONE)&&(m.targetTouches.length==2)&&(JXG.Math.Geometry.distance([m.targetTouches[0].screenX,m.targetTouches[0].screenY],[m.targetTouches[1].screenX,m.targetTouches[1].screenY])<80)){k=this.getMousePosition(m,0);this.initMoveOrigin(k[0],k[1]);return}this.options.precision.hasPoint=this.options.precision.touch;for(h=0;h<this.touches.length;h++){l[h]=this.touches[h]}this.touches.length=0;for(h=0;h<m.targetTouches.length;h++){for(f=0;f<l.length;f++){if(Math.abs(Math.pow(m.targetTouches[h].screenX-l[f].targets[0].X,2)+Math.pow(m.targetTouches[h].screenY-l[f].targets[0].Y,2))<o*o){this.touches.push({obj:l[f].obj,targets:[{num:h,X:m.targetTouches[h].screenX,Y:m.targetTouches[h].screenY,Xprev:NaN,Yprev:NaN}]});n=true;break}}if(!n){k=this.getMousePosition(m,h);d=this.initMoveObject(k[0],k[1]);if(d.length!=0){if(this.options.takeFirst){g=d[0]}else{g=d[d.length-1]}this.touches.push({obj:g,targets:[{num:h,X:m.targetTouches[h].screenX,Y:m.targetTouches[h].screenY,Xprev:NaN,Yprev:NaN}]})}}n=false}if(JXG.isWebkitAndroid()){var e=new Date();this.touchMoveLast=e.getTime()-200}this.options.precision.hasPoint=this.options.precision.mouse},touchMoveListener:function(d){var f,e,h;d.preventDefault();d.stopPropagation();if(JXG.isWebkitAndroid()){var g=new Date();g=g.getTime();if(g-this.touchMoveLast<80){this.updateQuality=this.BOARD_QUALITY_HIGH;return}else{this.touchMoveLast=g}}this.updateHooks("mousemove",d,this.mode);if(this.mode!=this.BOARD_MODE_DRAG){this.renderer.hide(this.infobox)}this.options.precision.hasPoint=this.options.precision.touch;if(this.mode==this.BOARD_MODE_MOVE_ORIGIN){h=this.getMousePosition(d,0);this.moveOrigin(h[0],h[1])}else{if(this.mode==this.BOARD_MODE_DRAG){for(f=0;f<this.touches.length;f++){this.touches[f].targets[0].X=d.targetTouches[this.touches[f].targets[0].num].screenX;this.touches[f].targets[0].Y=d.targetTouches[this.touches[f].targets[0].num].screenY;h=this.getMousePosition(d,this.touches[f].targets[0].num);this.moveObject(h[0],h[1],this.touches[f])}}else{for(f=0;f<d.targetTouches.length;f++){h=this.getMousePosition(d,f);this.highlightElements(h[0],h[1])}}}if(this.mode!=this.BOARD_MODE_DRAG){this.renderer.hide(this.infobox)}this.options.precision.hasPoint=this.options.precision.mouse},touchEndListener:function(e){var g,f,d=this.options.precision.touch,k=false,h=[];this.updateHooks("mouseup",e);if(e.targetTouches.length>0){for(g=0;g<this.touches.length;g++){h[g]=this.touches[g]}this.touches.length=0;for(g=0;g<e.targetTouches.length;g++){for(f=0;f<h.length;f++){if(Math.abs(Math.pow(e.targetTouches[g].screenX-h[f].targets[0].X,2)+Math.pow(e.targetTouches[g].screenY-h[f].targets[0].Y,2))<d*d){this.touches.push({obj:h[f].obj,targets:[{num:g,X:e.targetTouches[g].screenX,Y:e.targetTouches[g].screenY,Xprev:NaN,Yprev:NaN}]});break}}}}else{this.updateQuality=this.BOARD_QUALITY_HIGH;this.mode=this.BOARD_MODE_NONE;if(this.mode!==this.BOARD_MODE_MOVE_ORIGIN){this.update()}this.touches.length=0}},mouseDownListener:function(e){var f,d;this.updateHooks("mousedown",e);if(document.selection&&typeof document.selection.empty=="function"){document.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}f=this.getMousePosition(e);if(e.shiftKey){this.initMoveOrigin(f[0],f[1]);return false}if(this.mode==this.BOARD_MODE_CONSTRUCT){return false}d=this.initMoveObject(f[0],f[1]);if(d.length==0){this.mode=this.BOARD_MODE_NONE;return true}else{this.mouse={obj:null,targets:[{X:f[0],Y:f[1],Xprev:NaN,Yprev:NaN}]};if(this.options.takeFirst){this.mouse.obj=d[0]}else{this.mouse.obj=d[d.length-1]}if(e&&e.preventDefault){e.preventDefault()}else{window.event.returnValue=false}}return false},mouseUpListener:function(d){this.updateHooks("mouseup",d);this.updateQuality=this.BOARD_QUALITY_HIGH;this.mode=this.BOARD_MODE_NONE;if(this.mode!==this.BOARD_MODE_MOVE_ORIGIN){this.update()}this.mouse=null},mouseMoveListener:function(d,e){var f;this.updateHooks("mousemove",d,this.mode);e=0;f=this.getMousePosition(d);this.updateQuality=this.BOARD_QUALITY_LOW;this.dehighlightAll();if(this.mode!=this.BOARD_MODE_DRAG){this.renderer.hide(this.infobox)}if(this.mode==this.BOARD_MODE_MOVE_ORIGIN){this.moveOrigin(f[0]-this.drag_dx,f[1]-this.drag_dy)}else{if(this.mode==this.BOARD_MODE_DRAG){this.moveObject(f[0],f[1],this.mouse)}else{this.highlightElements(f[0],f[1])}}this.updateQuality=this.BOARD_QUALITY_HIGH},mouseWheelListener:function(d){d=d?d:window.event;var e=d.detail?d.detail*(-1):d.wheelDelta/40,f=new JXG.Coords(JXG.COORDS_BY_SCREEN,this.getMousePosition(d),this);if(e>0){this.zoomIn(f.usrCoords[1],f.usrCoords[2])}else{this.zoomOut(f.usrCoords[1],f.usrCoords[2])}d.preventDefault();return false},updateInfobox:function(e){var d,h,f,g;if(!e.visProp.showinfobox){return this}if(e.elementClass==JXG.OBJECT_CLASS_POINT){f=e.coords.usrCoords[1];g=e.coords.usrCoords[2];this.infobox.setCoords(f+this.infobox.distanceX/(this.unitX),g+this.infobox.distanceY/(this.unitY));if(typeof(e.infoboxText)!="string"){d=Math.abs(f);if(d>0.1){d=f.toFixed(2)}else{if(d>=0.01){d=f.toFixed(4)}else{if(d>=0.0001){d=f.toFixed(6)}else{d=f}}}h=Math.abs(g);if(h>0.1){h=g.toFixed(2)}else{if(h>=0.01){h=g.toFixed(4)}else{if(h>=0.0001){h=g.toFixed(6)}else{h=g}}}this.highlightInfobox(d,h,e)}else{this.highlightCustomInfobox(e.infoboxText,e)}this.renderer.show(this.infobox);this.renderer.updateText(this.infobox)}return this},highlightCustomInfobox:function(d){this.infobox.setText('<span style="color:#bbbbbb;">'+d+"</span>");return this},highlightInfobox:function(d,e){this.highlightCustomInfobox("("+d+", "+e+")");return this},dehighlightAll:function(){var e,f,d=false;for(e in this.highlightedObjects){f=this.highlightedObjects[e];f.noHighlight();delete (this.highlightedObjects[e]);d=true}if(this.options.renderer=="canvas"&&d){this.prepareUpdate();this.renderer.suspendRedraw(this);this.updateRenderer();this.renderer.unsuspendRedraw()}return this},getScrCoordsOfMouse:function(d,f){if(this.options.grid.snapToGrid){var e=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d,f],this);e.setCoordinates(JXG.COORDS_BY_USER,[Math.round((e.usrCoords[1])*this.options.grid.snapSizeX)/this.options.grid.snapSizeX,Math.round((e.usrCoords[2])*this.options.grid.snapSizeY)/this.options.grid.snapSizeY]);return[e.scrCoords[1],e.scrCoords[2]]}else{return[d,f]}},getUsrCoordsOfMouse:function(h){var f=this.getCoordsTopLeftCorner(),e=JXG.getPosition(h),d=e[0]-f[0],i=e[1]-f[1],g=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d,i],this);if(this.options.grid.snapToGrid){g.setCoordinates(JXG.COORDS_BY_USER,[Math.round((g.usrCoords[1])*this.options.grid.snapSizeX)/this.options.grid.snapSizeX,Math.round((g.usrCoords[2])*this.options.grid.snapSizeY)/this.options.grid.snapSizeY])}return[g.usrCoords[1],g.usrCoords[2]]},getAllUnderMouse:function(e){var d=this.getAllObjectsUnderMouse();d.push(this.getUsrCoordsOfMouse(e));return d},getAllObjectsUnderMouse:function(j){var i=this.getCoordsTopLeftCorner(),d=JXG.getPosition(j),f=d[0]-i[0],e=d[1]-i[1],g=[];for(var h in this.objects){if(this.objects[h].visProp.visible&&this.objects[h].hasPoint&&this.objects[h].hasPoint(f,e)){g.push(this.objects[h])}}return g},moveOrigin:function(d,g){var f,e;if(JXG.exists(d)&&JXG.exists(g)){this.origin.scrCoords[1]=d;this.origin.scrCoords[2]=g}for(e in this.objects){f=this.objects[e];if(!f.visProp.frozen&&(f.elementClass==JXG.OBJECT_CLASS_POINT||f.elementClass==JXG.OBJECT_CLASS_CURVE||f.type==JXG.OBJECT_TYPE_AXIS||f.type==JXG.OBJECT_TYPE_TEXT)){if(f.elementClass!=JXG.OBJECT_CLASS_CURVE&&f.type!=JXG.OBJECT_TYPE_AXIS){f.coords.usr2screen()}}}this.clearTraces();this.fullUpdate();return this},addConditions:function(o){var e="var el, x, y, c, rgbo;\n",n=o.indexOf("<data>"),l=o.indexOf("</data>"),k,h,g,q,d,f;if(n<0){return}while(n>=0){k=o.slice(n+6,l);h=k.indexOf("=");g=k.slice(0,h);q=k.slice(h+1);h=g.indexOf(".");d=g.slice(0,h);f=this.elementsByName[JXG.unescapeHTML(d)];var p=g.slice(h+1).replace(/\s+/g,"").toLowerCase();q=JXG.GeonextParser.geonext2JS(q,this);q=q.replace(/this\.board\./g,"this.");if(!JXG.exists(this.elementsByName[d])){JXG.debug("debug conditions: |"+d+"| undefined")}e+='el = this.objects["'+f.id+'"];\n';switch(p){case"x":e+="var y=el.coords.usrCoords[2];\n";e+="el.setPositionDirectly(JXG.COORDS_BY_USER,"+(q)+",y);\n";e+="el.prepareUpdate().update();\n";break;case"y":e+="var x=el.coords.usrCoords[1];\n";e+="el.coords=new JXG.Coords(JXG.COORDS_BY_USER,[x,"+(q)+"],this);\n";e+="el.setPositionDirectly(JXG.COORDS_BY_USER,x,"+(q)+");\n";e+="el.prepareUpdate().update();\n";break;case"visible":e+="var c="+(q)+";\n";e+="el.visProp.visible = c;\n";e+="if (c) {el.showElement();} else {el.hideElement();}\n";break;case"position":e+="el.position = "+(q)+";\n";e+="el.prepareUpdate().update(true);\n";break;case"stroke":e+="rgbo = JXG.rgba2rgbo("+(q)+");\n";e+="el.visProp.strokecolor = rgbo[0];\n";e+="el.visProp.strokeopacity = rgbo[1];\n";break;case"style":e+="el.setStyle("+(q)+");\n";break;case"strokewidth":e+="el.strokeWidth = "+(q)+";\n";break;case"fill":e+="var rgbo = JXG.rgba2rgbo("+(q)+");\n";e+="el.visProp.fillcolor = rgbo[0];\n";e+="el.visProp.fillopacity = rgbo[1];\n";break;case"label":break;default:JXG.debug("property '"+p+"' in conditions not yet implemented:"+q);break}o=o.slice(l+7);n=o.indexOf("<data>");l=o.indexOf("</data>")}e+="this.prepareUpdate().updateElements();\n";e+="return true;\n";this.updateConditions=new Function(e);this.updateConditions()},updateConditions:function(){return false},calculateSnapSizes:function(){var f=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this),e=new JXG.Coords(JXG.COORDS_BY_USER,[this.options.grid.gridX,this.options.grid.gridY],this),d=f.scrCoords[1]-e.scrCoords[1],g=f.scrCoords[2]-e.scrCoords[2];this.options.grid.snapSizeX=this.options.grid.gridX;while(Math.abs(d)>25){this.options.grid.snapSizeX*=2;d/=2}this.options.grid.snapSizeY=this.options.grid.gridY;while(Math.abs(g)>25){this.options.grid.snapSizeY*=2;g/=2}return this},applyZoom:function(){var e,d;for(d in this.objects){e=this.objects[d];if(!e.visProp.frozen&&(e.elementClass==JXG.OBJECT_CLASS_POINT||e.elementClass==JXG.OBJECT_CLASS_CURVE||e.type==JXG.OBJECT_TYPE_AXIS||e.type==JXG.OBJECT_TYPE_TEXT)){if(e.elementClass!=JXG.OBJECT_CLASS_CURVE&&e.type!=JXG.OBJECT_TYPE_AXIS){e.coords.usr2screen()}}}this.calculateSnapSizes();this.clearTraces();this.fullUpdate();return this},zoomIn:function(l,j){var g=this.getBoundingBox(),k=this.options.zoom.factorX,i=this.options.zoom.factorY,e=(g[2]-g[0])*(1-1/k),d=(g[1]-g[3])*(1-1/i),f=0.5,h=0.5;if(typeof l==="number"&&typeof j==="number"){f=(l-g[0])/(g[2]-g[0]);h=(g[1]-j)/(g[1]-g[3])}this.setBoundingBox([g[0]+e*f,g[1]-d*h,g[2]-e*(1-f),g[3]+d*(1-h)],false);this.zoomX*=k;this.zoomY*=i;this.applyZoom();return this},zoomOut:function(l,j){var g=this.getBoundingBox(),k=this.options.zoom.factorX,i=this.options.zoom.factorY,e=(g[2]-g[0])*(1-k),d=(g[1]-g[3])*(1-i),f=0.5,h=0.5;if(typeof l==="number"&&typeof j==="number"){f=(l-g[0])/(g[2]-g[0]);h=(g[1]-j)/(g[1]-g[3])}this.setBoundingBox([g[0]+e*f,g[1]-d*h,g[2]-e*(1-f),g[3]+d*(1-h)],false);this.zoomX/=k;this.zoomY/=i;this.applyZoom();return this},zoom100:function(){var f=this.getBoundingBox(),e=(f[2]-f[0])*(1-this.zoomX)*0.5,d=(f[1]-f[3])*(1-this.zoomY)*0.5;this.setBoundingBox([f[0]+e,f[1]-d,f[2]-e,f[3]+d],false);this.zoomX=1;this.zoomY=1;this.applyZoom();return this},zoomAllPoints:function(){var d=0,j=0,k=0,i=0,h,g,f,e;for(h in this.objects){if(JXG.isPoint(this.objects[h])&&this.objects[h].visProp.visible){if(this.objects[h].coords.usrCoords[1]<d){d=this.objects[h].coords.usrCoords[1]}else{if(this.objects[h].coords.usrCoords[1]>j){j=this.objects[h].coords.usrCoords[1]}}if(this.objects[h].coords.usrCoords[2]>i){i=this.objects[h].coords.usrCoords[2]}else{if(this.objects[h].coords.usrCoords[2]<k){k=this.objects[h].coords.usrCoords[2]}}}}g=50;f=g/(this.unitX);e=g/(this.unitY);this.zoomX=1;this.zoomY=1;this.setBoundingBox([d-f,i+e,j+f,k-e],true);this.applyZoom();return this},zoomElements:function(l){var h,g,m,k,f=[0,0,0,0],d=[1,-1,-1,1];if(!JXG.isArray(l)||l.length===0){return this}for(h=0;h<l.length;h++){m=JXG.getRef(this,l[h]);k=m.bounds();if(JXG.isArray(k)){if(JXG.isArray(f)){for(g=0;g<4;g++){if(d[g]*k[g]<d[g]*f[g]){f[g]=k[g]}}}else{f=k}}}if(JXG.isArray(f)){for(g=0;g<4;g++){f[g]-=d[g]}this.zoomX=1;this.zoomY=1;this.setBoundingBox(f,true)}return this},removeObject:function(d){var g,f;if(JXG.isArray(d)){for(f=0;f<d.length;f++){this.removeObject(d[f])}}d=JXG.getReference(this,d);if(!JXG.exists(d)){return this}try{for(g in d.childElements){d.childElements[g].board.removeObject(d.childElements[g])}for(g in this.objects){if(JXG.exists(this.objects[g].childElements)){delete (this.objects[g].childElements[d.id])}}delete (this.objects[d.id]);delete (this.elementsByName[d.name]);if(JXG.exists(d.remove)){d.remove()}}catch(h){JXG.debug(d.id+": Could not be removed, JS says:\n\n"+h)}return this},removeAncestors:function(d){for(var e in d.ancestors){this.removeAncestors(d.ancestors[e])}this.removeObject(d);return this},initGeonextBoard:function(){var h,g,f,e,d;h=this.create("point",[0,0],{id:this.id+"g00e0",name:"Ursprung",withLabel:false,visible:false,fixed:true});g=this.create("point",[1,0],{id:this.id+"gX0e0",name:"Punkt_1_0",withLabel:false,visible:false,fixed:true});f=this.create("point",[0,1],{id:this.id+"gY0e0",name:"Punkt_0_1",withLabel:false,visible:false,fixed:true});e=this.create("line",[h,g],{id:this.id+"gXLe0",name:"X-Achse",withLabel:false,visible:false});d=this.create("line",[h,f],{id:this.id+"gYLe0",name:"Y-Achse",withLabel:false,visible:false});return this},initInfobox:function(){this.infobox=this.create("text",[0,0,"0,0"],{id:this.id+"_infobox",display:"html"});this.infobox.distanceX=-20;this.infobox.distanceY=25;this.renderer.hide(this.infobox);return this},resizeContainer:function(d,e){this.canvasWidth=parseFloat(d);this.canvasHeight=parseFloat(e);this.containerObj.style.width=(this.canvasWidth)+"px";this.containerObj.style.height=(this.canvasHeight)+"px";this.renderer.resize(this.canvasWidth,this.canvasHeight);return this},showDependencies:function(){var g,e,j,h,d;e="<p>\n";for(g in this.objects){d=0;for(j in this.objects[g].childElements){d++}if(d>=0){e+="<b>"+this.objects[g].id+":</b> "}for(j in this.objects[g].childElements){e+=this.objects[g].childElements[j].id+"("+this.objects[g].childElements[j].name+"), "}e+="<p>\n"}e+="</p>\n";h=window.open();h.document.open();h.document.write(e);h.document.close();return this},showXML:function(){var d=window.open("");d.document.open();d.document.write("<pre>"+JXG.escapeHTML(this.xmlString)+"</pre>");d.document.close();return this},prepareUpdate:function(){var d,e;for(d in this.objects){e=this.objects[d];if(!this.needsFullUpdate&&!e.needsRegularUpdate){continue}e.needsUpdate=true}return this},updateElements:function(e){var d,f;e=JXG.getRef(this,e);for(d in this.objects){f=this.objects[d];if(e==null||f.id!=e.id){f.update(true)}else{f.update(false)}}return this},updateRenderer:function(e){var d,f;if(this.options.renderer=="canvas"){this.updateRendererCanvas(e)}else{for(d in this.objects){f=this.objects[d];f.updateRenderer()}}return this},updateRendererCanvas:function(h){var d,l,g,f=this.options.layer,k=this.options.layer.numlayers,m=Number.NEGATIVE_INFINITY,j,e;for(g=0;g<k;g++){j=Number.POSITIVE_INFINITY;for(e in f){if(f[e]>m&&f[e]<j){j=f[e]}}m=j;for(d in this.objects){l=this.objects[d];if(l.visProp.layer===j){l.prepareUpdate().updateRenderer()}}}return this},addHook:function(f,d,e){if(!JXG.exists(d)){d="update"}e=e||this;this.hooks.push({fn:f,mode:d,context:e});if(d=="update"){f.apply(e,[this])}return(this.hooks.length-1)},removeHook:function(d){this.hooks[d]=null;return this},updateHooks:function(d){var f,e=arguments.length>1?Array.prototype.slice.call(arguments,1):[];if(!JXG.exists(d)){d="update"}for(f=0;f<this.hooks.length;f++){if((this.hooks[f]!=null)&&(this.hooks[f].mode==d)){this.hooks[f].fn.apply(this.hooks[f].context,e)}}return this},addChild:function(d){this.dependentBoards.push(d);this.update();return this},removeChild:function(e){var d;for(d=this.dependentBoards.length-1;d>=0;d--){if(this.dependentBoards[d]==e){this.dependentBoards.splice(d,1)}}return this},update:function(g){var f,e,h,d;if(this.isSuspendedUpdate){return this}this.prepareUpdate(g).updateElements(g).updateConditions();this.renderer.suspendRedraw(this);this.updateRenderer(g);this.renderer.unsuspendRedraw();this.updateHooks();e=this.dependentBoards.length;for(f=0;f<e;f++){h=this.dependentBoards[f].id;d=JXG.JSXGraph.boards[h];if(d!=this){d.updateQuality=this.updateQuality;d.prepareUpdate().updateElements().updateConditions();d.renderer.suspendRedraw();d.updateRenderer();d.renderer.unsuspendRedraw();d.updateHooks()}}return this},fullUpdate:function(){this.needsFullUpdate=true;this.update();this.needsFullUpdate=false;return this},addGrid:function(){this.create("grid",[]);return this},removeGrids:function(){var d;for(d=0;d<this.grids.length;d++){this.removeObject(this.grids[d])}this.grids.length=0;this.update();return this},create:function(e,f,d){var j,g,h;e=e.toLowerCase();if(!JXG.exists(f)){f=[]}if(!JXG.exists(d)){d={}}for(g=0;g<f.length;g++){if(e!="text"||g!=2){f[g]=JXG.getReference(this,f[g])}}if(JXG.JSXGraph.elements[e]!=null){if(typeof JXG.JSXGraph.elements[e]=="function"){j=JXG.JSXGraph.elements[e](this,f,d)}else{j=JXG.JSXGraph.elements[e].creator(this,f,d)}}else{throw new Error("JSXGraph: JXG.createElement: Unknown element type given: "+e)}if(!JXG.exists(j)){JXG.debug("JSXGraph: JXG.createElement: failure creating "+e);return j}if(j.prepareUpdate&&j.update&&j.updateRenderer){j.prepareUpdate().update().updateRenderer()}return j},createElement:JXG.shortcut(JXG.Board.prototype,"create"),clearTraces:function(){var d;for(d in this.objects){if(this.objects[d].visProp.trace){this.objects[d].clearTrace()}}this.numTraces=0;return this},suspendUpdate:function(){this.isSuspendedUpdate=true;return this},unsuspendUpdate:function(){this.isSuspendedUpdate=false;this.update();return this},setBoundingBox:function(i,e){if(!JXG.isArray(i)){return this}var f,d,g=JXG.getDimensions(this.container);this.canvasWidth=parseInt(g.width);this.canvasHeight=parseInt(g.height);d=this.canvasWidth;f=this.canvasHeight;if(e){this.unitX=d/(i[2]-i[0]);this.unitY=f/(i[1]-i[3]);if(this.unitX<this.unitY){this.unitY=this.unitX}else{this.unitX=this.unitY}}else{this.unitX=d/(i[2]-i[0]);this.unitY=f/(i[1]-i[3])}this.moveOrigin(-this.unitX*i[0],this.unitY*i[1]);return this},getBoundingBox:function(){var e=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this),d=new JXG.Coords(JXG.COORDS_BY_SCREEN,[this.canvasWidth,this.canvasHeight],this);return[e.usrCoords[1],e.usrCoords[2],d.usrCoords[1],d.usrCoords[2]]},addAnimation:function(d){this.animationObjects[d.id]=d;if(!this.animationIntervalCode){this.animationIntervalCode=window.setInterval("JXG.JSXGraph.boards['"+this.id+"'].animate();",35)}return this},stopAllAnimation:function(){var d;for(d in this.animationObjects){if(this.animationObjects[d]===null){continue}this.animationObjects[d]=null;delete (this.animationObjects[d])}window.clearInterval(this.animationIntervalCode);delete (this.animationIntervalCode);return this},animate:function(){var j=0,g,f,l,d,e,k,i=null,h;for(g in this.animationObjects){if(this.animationObjects[g]===null){continue}j++;f=this.animationObjects[g];if(f.animationPath){if(JXG.isFunction(f.animationPath)){l=f.animationPath(new Date().getTime()-f.animationStart)}else{l=f.animationPath.pop()}if((!JXG.exists(l))||(!JXG.isArray(l)&&isNaN(l))){delete (f.animationPath)}else{f.setPositionDirectly(JXG.COORDS_BY_USER,l[0],l[1]);f.prepareUpdate().update().updateRenderer();i=f}}if(f.animationData){k=0;for(d in f.animationData){e=f.animationData[d].pop();if(!JXG.exists(e)){delete (f.animationData[e])}else{k++;f.setProperty(d+":"+e)}}if(k==0){delete (f.animationData)}}if(!JXG.exists(f.animationData)&&!JXG.exists(f.animationPath)){this.animationObjects[g]=null;delete (this.animationObjects[g]);if(JXG.exists(f.animationCallback)){h=f.animationCallback;f.animationCallback=null;h()}}}if(j==0){window.clearInterval(this.animationIntervalCode);delete (this.animationIntervalCode)}else{this.update(i)}return this},emulateColorblindness:function(d){var f,g,h=this;if(!JXG.exists(d)){d="none"}if(this.currentCBDef==d){return this}for(f in h.objects){g=h.objects[f];if(d!="none"){if(this.currentCBDef=="none"){g.visPropOriginal={strokecolor:g.visProp.strokecolor,fillcolor:g.visProp.fillcolor,highlightstrokecolor:g.visProp.highlightstrokecolor,highlightfillcolor:g.visProp.highlightfillcolor}}g.setProperty({strokecolor:JXG.rgb2cb(g.visPropOriginal.strokecolor,d),fillcolor:JXG.rgb2cb(g.visPropOriginal.fillcolor,d),highlightstrokecolor:JXG.rgb2cb(g.visPropOriginal.highlightstrokecolor,d),highlightfillcolor:JXG.rgb2cb(g.visPropOriginal.highlightfillcolor,d)})}else{if(JXG.exists(g.visPropOriginal)){JXG.extend(g.visProp,g.visPropOriginal)}}}this.currentCBDef=d;this.update();return this},getPartialConstruction:function(d){var f,e;for(e=1;e<arguments.length;e++){f.push(arguments[e])}},createRoulette:function(h,g,l,i,k,e,j){var f=this;var d=function(){var s=0,w=0,v=0,u=l,t=JXG.Math.Numerics.root(function(E){var G=h.X(u),F=h.Y(u),D=g.X(E),C=g.Y(E);return(G-D)*(G-D)+(F-C)*(F-C)},[0,Math.PI*2]),p=0,m=0,z,A=f.create("transform",[function(){return s}],{type:"rotate"}),o=f.create("transform",[function(){return s},function(){return h.X(u)},function(){return h.Y(u)}],{type:"rotate"}),r=f.create("transform",[function(){return w},function(){return v}],{type:"translate"}),x=function(L,N,M){var K=JXG.Math.Numerics.D(L.X)(N),E=JXG.Math.Numerics.D(L.Y)(N),J=JXG.Math.Numerics.D(L.X)(M),D=JXG.Math.Numerics.D(L.Y)(M),G=JXG.Math.Numerics.D(L.X)((N+M)*0.5),I=JXG.Math.Numerics.D(L.Y)((N+M)*0.5),H=Math.sqrt(K*K+E*E),F=Math.sqrt(J*J+D*D),C=Math.sqrt(G*G+I*I);return(H+4*C+F)*(M-N)/6},B=function(C){return z-x(g,t,C)},y=Math.PI/18,n=y*9,q=null;this.rolling=function(){p=u+k*i;z=x(h,u,p);m=JXG.Math.Numerics.root(B,t);var D=new JXG.Complex(h.X(p),h.Y(p));var E=new JXG.Complex(g.X(m),g.Y(m));var F=new JXG.Complex(JXG.Math.Numerics.D(h.X)(p),JXG.Math.Numerics.D(h.Y)(p));var C=new JXG.Complex(JXG.Math.Numerics.D(g.X)(m),JXG.Math.Numerics.D(g.Y)(m));var G=JXG.C.div(F,C);s=Math.atan2(G.imaginary,G.real);G.div(JXG.C.abs(G));G.mult(E);w=D.real-G.real;v=D.imaginary-G.imaginary;if(s<-y&&s>-n){s=-y;o.applyOnce(j)}else{if(s>y&&s<n){s=y;o.applyOnce(j)}else{A.applyOnce(j);r.applyOnce(j);u=p;t=m}}f.update()};this.start=function(){if(e>0){q=setInterval(this.rolling,e)}return this};this.stop=function(){clearInterval(q);return this};return this};return new d()}});JXG.Options={showCopyright:true,showNavigation:true,takeSizeFromFile:false,renderer:"svg",takeFirst:false,zoom:{factorX:1.25,factorY:1.25},navbar:{strokeColor:"#aaaaaa",fillColor:"#f5f5f5",padding:"2px",position:"absolute",fontSize:"10px",cursor:"pointer",zIndex:"100",right:"5px",bottom:"5px"},elements:{strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",fillColor:"red",highlightFillColor:"none",strokeOpacity:1,highlightStrokeOpacity:1,fillOpacity:1,highlightFillOpacity:1,strokeWidth:2,highlightStrokeWidth:2,fixed:false,frozen:false,withLabel:false,visible:true,layer:0,dash:0,shadow:false,trace:false,needsRegularUpdate:true,draft:{draft:false,strokeColor:"#565656",fillColor:"#565656",strokeOpacity:0.8,fillOpacity:0.8,strokeWidth:1}},ticks:{drawLabels:false,drawZero:false,insertTicks:false,minTicksDistance:50,minorHeight:4,majorHeight:10,minorTicks:4,ticksDistance:1,strokeOpacity:1,strokeWidth:1,strokeColor:"black",highlightStrokeColor:"#888888"},precision:{touch:30,mouse:4,epsilon:0.0001,hasPoint:4},layer:{numlayers:20,text:9,point:9,arc:8,line:7,circle:6,curve:5,polygon:3,sector:3,angle:3,integral:3,axis:2,grid:1,image:0,trace:0},angle:{withLabel:true,radius:1,fillColor:"#FF7F00",highlightFillColor:"#FF7F00",strokeColor:"#FF7F00",textColor:"#0000FF",fillOpacity:0.3,highlightFillOpacity:0.3,point:{withLabel:false,visible:false,name:""},dot:{visible:false,strokeColor:"none",fillColor:"black",size:2,face:"o",withLabel:false,name:""}},arc:{firstArrow:false,lastArrow:false,fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",useDirection:false,center:{visible:false,withLabel:false,fixed:false,name:""}},axis:{needsRegularUpdate:false,strokeWidth:1,strokeColor:"#666666",highlightStrokeWidth:1,highlightStrokeColor:"#888888",withTicks:true,straightFirst:true,straightLast:true,lastArrow:true,withLabel:false,ticks:{needsRegularUpdate:false,strokeWidth:1,strokeColor:"#666666",highlightStrokeColor:"#888888",drawLabels:true,drawZero:true,insertTicks:true,minTicksDistance:50,minorHeight:4,majorHeight:-1,minorTicks:4,ticksDistance:1,strokeOpacity:0.25},point1:{needsRegularUpdate:false},point2:{needsRegularUpdate:false}},bisector:{strokeColor:"#000000",point:{visible:false,fixed:false,withLabel:false,name:""}},bisectorlines:{line1:{strokeColor:"red"},line2:{strokeColor:"black"}},chart:{chartStyle:"line",colors:["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#C3D9FF","#4096EE","#008C00"],highlightcolors:null,fillcolor:null,highlightonsector:false,highlightbysize:false},circle:{fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",center:{visible:false,withLabel:false,fixed:false,name:""}},circumcircle:{fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",point:{visible:false,fixed:false,withLabel:false,name:""}},circumcirclesector:{useDirection:true,fillColor:"#00FF00",highlightFillColor:"#00FF00",fillOpacity:0.3,highlightFillOpacity:0.3,strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",point:{visible:false,fixed:false,withLabel:false,name:""}},conic:{fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",foci:{fixed:false,visible:false,withLabel:false,name:""}},curve:{strokeWidth:1,strokeColor:"#0000ff",fillColor:"none",curveType:null,RDPsmoothing:false,numberPointsHigh:1600,numberPointsLow:400,doAdvancedPlot:true},grid:{needsRegularUpdate:false,hasGrid:false,gridX:1,gridY:1,strokeColor:"#C0C0C0",strokeOpacity:"0.5",strokeWidth:1,dash:2,snapToGrid:false,snapSizeX:2,snapSizeY:2},image:{imageString:null,fillOpacity:1},incircle:{fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",point:{visible:false,fixed:false,withLabel:false,name:""}},integral:{withLabel:true,strokeWidth:0,strokeOpacity:0,start:{visible:true},startproject:{visible:false,fixed:false,withLabel:false,name:""},end:{visible:true},endproject:{visible:false,fixed:false,withLabel:false,name:""},text:{fontSize:20}},legend:{style:"vertical",labels:["1","2","3","4","5","6","7","8"],colors:["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#C3D9FF","#4096EE","#008C00"]},line:{firstArrow:false,lastArrow:false,straightFirst:true,straightLast:true,fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#888888",withTicks:false,point1:{visible:false,withLabel:false,fixed:false,name:""},point2:{visible:false,withLabel:false,fixed:false,name:""},ticks:{drawLabels:true,drawZero:false,insertTicks:false,minTicksDistance:50,maxTicksDistance:300,minorHeight:4,majorHeight:-1,minorTicks:4,defaultDistance:1,strokeOpacity:0.3},labelOffsets:[10,10]},locus:{translateToOrigin:false,translateTo10:false,stretch:false,toOrigin:null,to10:null},parallel:{strokeColor:"#000000",point:{visible:false,fixed:true,withLabel:false,name:""}},perpendicular:{strokeColor:"#000000",straightFirst:false,straightLast:false,point:{visible:false,fixed:true,withLabel:false,name:""}},point:{withLabel:true,style:5,face:"o",size:3,fillColor:"#ff0000",highlightFillColor:"#EEEEEE",strokeWidth:2,strokeColor:"#ff0000",highlightStrokeColor:"#C3D9FF",zoom:false,showInfobox:true,draft:false},polygon:{fillColor:"#00FF00",highlightFillColor:"#00FF00",fillOpacity:0.3,highlightFillOpacity:0.3,withLines:true,lines:{withLabel:false,strokeWidth:1,highlightStrokeWidth:1,layer:5},points:{withLabel:true,strokeColor:"#ff0000",fillColor:"#ff0000",fixed:true}},riemannsum:{withLabel:false,fillOpacity:0.3,fillColor:"#ffff00"},sector:{fillColor:"#00FF00",highlightFillColor:"#00FF00",fillOpacity:0.3,highlightFillOpacity:0.3},slider:{snapWidth:-1,precision:2,firstArrow:false,lastArrow:false,withTicks:true,withLabel:true,point1:{needsRegularUpdate:false,showInfobox:false,withLabel:false,visible:false,fixed:true,name:""},point2:{needsRegularUpdate:false,showInfobox:false,withLabel:false,visible:false,fixed:true,name:""},glider:{showInfobox:false,name:"",withLabel:false,visible:true,strokeColor:"#000000",highlightStrokeColor:"#888888",fillColor:"#ffffff",highlightFillColor:"none",size:6},segment1:{needsRegularUpdate:false,name:"",strokeWidth:1,strokeColor:"#000000",highlightStrokeColor:"#888888"},ticks:{needsRegularUpdate:false,drawLabels:false,drawZero:true,insertTicks:true,minorHeight:4,majorHeight:10,minorTicks:0,defaultDistance:1,strokeOpacity:1,strokeWidth:1,strokeColor:"#000000"},segment2:{strokeWidth:3,name:"",strokeColor:"#000000",highlightStrokeColor:"#888888"},text:{strokeColor:"#000000"}},text:{fontSize:12,digits:2,isLabel:false,strokeColor:"#000000",useASCIIMathML:false,useMathJax:false,display:"html",withLabel:false},shortcuts:{color:["strokeColor","fillColor"],opacity:["strokeOpacity","fillOpacity"],highlightColor:["highlightStrokeColor","highlightFillColor"],highlightOpacity:["highlightStrokeOpacity","highlightFillOpacity"],strokeWidth:["strokeWidth","highlightStrokeWidth"]}};JXG.Validator=(function(){var h=function(i){return/^[0-9]+px$/.test(i)},k=function(i){return(i in {html:0,internal:0})},l=function(i){return JXG.isString(i)},j=function(i){return JXG.exists(JXG.Point.prototype.normalizeFace.call(this,i))},n=function(i){return(Math.abs(i-Math.round(i))<JXG.Math.eps)},o=function(i){return n(i)&&i>0},g=function(i){return i.length>=2&&n(i[0])&&n(i[1])},d=function(i){return(i in {vml:0,svg:0,canvas:0})},f,m={},e={color:l,defaultDistance:JXG.isNumber,display:k,doAdvancedPlot:false,draft:false,drawLabels:false,drawZero:false,face:j,factor:JXG.isNumber,fillColor:l,fillOpacity:JXG.isNumber,firstArrow:false,fontSize:n,dash:n,gridX:JXG.isNumber,gridY:JXG.isNumber,hasGrid:false,highlightFillColor:l,highlightFillOpacity:JXG.isNumber,highlightStrokeColor:l,highlightStrokeOpacity:JXG.isNumber,insertTicks:false,labelOffsets:g,lastArrow:false,majorHeight:n,maxTicksDistance:o,minorHeight:n,minorTicks:o,minTicksDistance:o,numberPointsHigh:o,numberPointsLow:o,opacity:JXG.isNumber,radius:JXG.isNumber,RDPsmoothing:false,renderer:d,right:h,showCopyright:false,showInfobox:false,showNavigation:false,size:n,snapSizeX:JXG.isNumber,snapSizeY:JXG.isNumber,snapWidth:JXG.isNumber,snapToGrid:false,straightFirst:false,straightLast:false,stretch:false,strokeColor:l,strokeOpacity:JXG.isNumber,strokeWidth:n,takeFirst:false,takeSizeFromFile:false,textColor:l,to10:false,toOrigin:false,translateTo10:false,translateToOrigin:false,useASCIIMathML:false,useDirection:false,useMathJax:false,withLabel:false,withTicks:false,zoom:false};for(f in e){m[f.toLowerCase()]=e[f]}return m})();JXG.useStandardOptions=function(h){var j=JXG.Options,g=h.hasGrid,f,e,i,d;h.options.grid.hasGrid=j.grid.hasGrid;h.options.grid.gridX=j.grid.gridX;h.options.grid.gridY=j.grid.gridY;h.options.grid.gridColor=j.grid.gridColor;h.options.grid.gridOpacity=j.grid.gridOpacity;h.options.grid.gridDash=j.grid.gridDash;h.options.grid.snapToGrid=j.grid.snapToGrid;h.options.grid.snapSizeX=j.grid.SnapSizeX;h.options.grid.snapSizeY=j.grid.SnapSizeY;h.takeSizeFromFile=j.takeSizeFromFile;d=function(k,l){k.visProp.fillcolor=l.fillColor;k.visProp.highlightfillcolor=l.highlightFillColor;k.visProp.strokecolor=l.strokeColor;k.visProp.highlightstrokecolor=l.highlightStrokeColor};for(f in h.objects){i=h.objects[f];if(i.elementClass==JXG.OBJECT_CLASS_POINT){d(i,j.point)}else{if(i.elementClass==JXG.OBJECT_CLASS_LINE){d(i,j.line);for(e in i.ticks){e.majorTicks=j.line.ticks.majorTicks;e.minTicksDistance=j.line.ticks.minTicksDistance;e.visProp.minorheight=j.line.ticks.minorHeight;e.visProp.majorheight=j.line.ticks.majorHeight}}else{if(i.elementClass==JXG.OBJECT_CLASS_CIRCLE){d(i,j.circle)}else{if(i.type==JXG.OBJECT_TYPE_ANGLE){d(i,j.angle)}else{if(i.type==JXG.OBJECT_TYPE_ARC){d(i,j.arc)}else{if(i.type==JXG.OBJECT_TYPE_POLYGON){d(i,j.polygon)}else{if(i.type==JXG.OBJECT_TYPE_CONIC){d(i,j.conic)}else{if(i.type==JXG.OBJECT_TYPE_CURVE){d(i,j.curve)}else{if(i.type==JXG.OBJECT_TYPE_SECTOR){i.arc.visProp.fillcolor=j.sector.fillColor;i.arc.visProp.highlightfillcolor=j.sector.highlightFillColor;i.arc.visProp.fillopacity=j.sector.fillOpacity;i.arc.visProp.highlightfillopacity=j.sector.highlightFillOpacity}}}}}}}}}}h.fullUpdate();if(g&&!h.hasGrid){h.removeGrids(h)}else{if(!g&&h.hasGrid){h.create("grid",[])}}};JXG.useBlackWhiteOptions=function(d){var e=JXG.Options;e.point.fillColor=JXG.rgb2bw(e.point.fillColor);e.point.highlightFillColor=JXG.rgb2bw(e.point.highlightFillColor);e.point.strokeColor=JXG.rgb2bw(e.point.strokeColor);e.point.highlightStrokeColor=JXG.rgb2bw(e.point.highlightStrokeColor);e.line.fillColor=JXG.rgb2bw(e.line.fillColor);e.line.highlightFillColor=JXG.rgb2bw(e.line.highlightFillColor);e.line.strokeColor=JXG.rgb2bw(e.line.strokeColor);e.line.highlightStrokeColor=JXG.rgb2bw(e.line.highlightStrokeColor);e.circle.fillColor=JXG.rgb2bw(e.circle.fillColor);e.circle.highlightFillColor=JXG.rgb2bw(e.circle.highlightFillColor);e.circle.strokeColor=JXG.rgb2bw(e.circle.strokeColor);e.circle.highlightStrokeColor=JXG.rgb2bw(e.circle.highlightStrokeColor);e.arc.fillColor=JXG.rgb2bw(e.arc.fillColor);e.arc.highlightFillColor=JXG.rgb2bw(e.arc.highlightFillColor);e.arc.strokeColor=JXG.rgb2bw(e.arc.strokeColor);e.arc.highlightStrokeColor=JXG.rgb2bw(e.arc.highlightStrokeColor);e.polygon.fillColor=JXG.rgb2bw(e.polygon.fillColor);e.polygon.highlightFillColor=JXG.rgb2bw(e.polygon.highlightFillColor);e.sector.fillColor=JXG.rgb2bw(e.sector.fillColor);e.sector.highlightFillColor=JXG.rgb2bw(e.sector.highlightFillColor);e.curve.strokeColor=JXG.rgb2bw(e.curve.strokeColor);e.grid.gridColor=JXG.rgb2bw(e.grid.gridColor);JXG.useStandardOptions(d)};JXG.JSXGraph={licenseText:"JSXGraph v0.92 Copyright (C) see http://jsxgraph.org",boards:{},elements:{},rendererType:(function(){var f,d;if(JXG.supportsSVG()){JXG.Options.renderer="svg"}else{if(JXG.supportsVML()){JXG.Options.renderer="vml";function e(){document.body.scrollLeft;document.body.scrollTop}document.onmousemove=e}else{JXG.Options.renderer="canvas"}}d=JXG.rendererFiles[JXG.Options.renderer].split(",");for(f=0;f<d.length;f++){(function(g){JXG.require(JXG.requirePath+g+".js")})(d[f])}return JXG.Options.renderer})(),initBoard:function(g,e){var l,u,t,o,m,q,f,d,s,r,p,n,k,i,j;d=JXG.getDimensions(g);if(typeof e=="undefined"){e={}}if(typeof e.boundingbox!="undefined"){s=e.boundingbox;q=parseInt(d.width);f=parseInt(d.height);if(e.keepaspectratio){o=q/(s[2]-s[0]);m=f/(-s[3]+s[1]);if(o<m){m=o}else{o=m}}else{o=q/(s[2]-s[0]);m=f/(-s[3]+s[1])}u=-o*s[0];t=m*s[1]}else{u=((typeof e.originX)=="undefined"?150:e.originX);t=((typeof e.originY)=="undefined"?150:e.originY);o=((typeof e.unitX)=="undefined"?50:e.unitX);m=((typeof e.unitY)=="undefined"?50:e.unitY)}r=((typeof e.zoom)=="undefined"?1:e.zoom);p=r*((typeof e.zoomX)=="undefined"?1:e.zoomX);n=r*((typeof e.zoomY)=="undefined"?1:e.zoomY);k=((typeof e.showCopyright)=="undefined"?JXG.Options.showCopyright:e.showCopyright);if(JXG.Options.renderer=="svg"){l=new JXG.SVGRenderer(document.getElementById(g))}else{if(JXG.Options.renderer=="vml"){l=new JXG.VMLRenderer(document.getElementById(g))}else{if(JXG.Options.renderer=="silverlight"){l=new JXG.SilverlightRenderer(document.getElementById(g),d.width,d.height)}else{l=new JXG.CanvasRenderer(document.getElementById(g))}}}j=new JXG.Board(g,l,"",[u,t],p,n,o,m,d.width,d.height,k);this.boards[j.id]=j;j.keepaspectratio=e.keepaspectratio;j.suspendUpdate();j.initInfobox();if(e.axis){j.defaultAxes={};j.defaultAxes.x=j.create("axis",[[0,0],[1,0]],{ticks:{drawZero:true}});j.defaultAxes.y=j.create("axis",[[0,0],[0,1]],{ticks:{drawZero:false}})}if(e.grid){j.create("grid",[])}if(typeof e.shownavigation!="undefined"){e.showNavigation=e.shownavigation}i=((typeof e.showNavigation)=="undefined"?j.options.showNavigation:e.showNavigation);if(i){j.renderer.drawZoomBar(j)}j.unsuspendUpdate();return j},loadBoardFromFile:function(g,d,i){var h,e,f;if(JXG.Options.renderer=="svg"){h=new JXG.SVGRenderer(document.getElementById(g))}else{if(JXG.Options.renderer=="vml"){h=new JXG.VMLRenderer(document.getElementById(g))}else{if(JXG.Options.renderer=="silverlight"){h=new JXG.SilverlightRenderer(document.getElementById(g),f.width,f.height)}else{h=new JXG.CanvasRenderer(document.getElementById(g))}}}f=JXG.getDimensions(g);e=new JXG.Board(g,h,"",[150,150],1,1,50,50,f.width,f.height);e.initInfobox();JXG.FileReader.parseFileContent(d,e,i);if(e.options.showNavigation){e.renderer.drawZoomBar(e)}this.boards[e.id]=e;return e},loadBoardFromString:function(g,d,i){var h,f,e;if(JXG.Options.renderer=="svg"){h=new JXG.SVGRenderer(document.getElementById(g))}else{if(JXG.Options.renderer=="vml"){h=new JXG.VMLRenderer(document.getElementById(g))}else{if(JXG.Options.renderer=="silverlight"){h=new JXG.SilverlightRenderer(document.getElementById(g),f.width,f.height)}else{h=new JXG.CanvasRenderer(document.getElementById(g))}}}f=JXG.getDimensions(g);e=new JXG.Board(g,h,"",[150,150],1,1,50,50,f.width,f.height);e.initInfobox();JXG.FileReader.parseString(d,e,i,true);if(e.options.showNavigation){e.renderer.drawZoomBar(e)}this.boards[e.id]=e;return e},freeBoard:function(f){var e,d;if(typeof(f)=="string"){f=this.boards[f]}f.removeEventHandlers();for(e in f.objects){f.removeObject(f.objects[e])}for(d=0;d<f.containerObj.childNodes.length;d++){f.containerObj.removeChild(f.containerObj.childNodes[d])}for(e in f.objects){delete (f.objects[e])}delete (f.renderer);delete (f.algebra);delete (this.boards[f.id])},registerElement:function(d,e){d=d.toLowerCase();this.elements[d]=e;if(JXG.Board.prototype["_"+d]){throw new Error("JSXGraph: Can't create wrapper method in JXG.Board because member '_"+d+"' already exists'")}JXG.Board.prototype["_"+d]=function(g,f){return this.create(d,g,f)}},unregisterElement:function(d){delete (this.elements[d.toLowerCase()]);delete (JXG.Board.prototype["_"+d.toLowerCase()])}};JXG.OBJECT_TYPE_ARC=1330921795;JXG.OBJECT_TYPE_ARROW=1330921815;JXG.OBJECT_TYPE_AXIS=1330921816;JXG.OBJECT_TYPE_AXISPOINT=83181904;JXG.OBJECT_TYPE_TICKS=1330926680;JXG.OBJECT_TYPE_CIRCLE=1330922316;JXG.OBJECT_TYPE_CONIC=1330922319;JXG.OBJECT_TYPE_CURVE=1330923344;JXG.OBJECT_TYPE_GLIDER=1330923340;JXG.OBJECT_TYPE_IMAGE=1330926157;JXG.OBJECT_TYPE_LINE=1330924622;JXG.OBJECT_TYPE_POINT=1330925652;JXG.OBJECT_TYPE_SLIDER=1330926404;JXG.OBJECT_TYPE_CAS=1330922320;JXG.OBJECT_TYPE_POLYGON=1330925657;JXG.OBJECT_TYPE_SECTOR=1330926403;JXG.OBJECT_TYPE_TEXT=1330926661;JXG.OBJECT_TYPE_ANGLE=1330921799;JXG.OBJECT_TYPE_INTERSECTION=1330926158;JXG.OBJECT_TYPE_TURTLE=5198933;JXG.OBJECT_TYPE_VECTOR=1330927188;JXG.OBJECT_CLASS_POINT=1;JXG.OBJECT_CLASS_LINE=2;JXG.OBJECT_CLASS_CIRCLE=3;JXG.OBJECT_CLASS_CURVE=4;JXG.OBJECT_CLASS_AREA=5;JXG.OBJECT_CLASS_OTHER=6;JXG.GeometryElement=function(h,d,g,i){var e,f;this.needsUpdate=true;this.isDraggable=false;this.isReal=true;this.childElements={};this.hasLabel=false;this.notExistingParents={};this.traces={};this.numTraces=0;this.transformations=[];this.baseElement=null;this.descendants={};this.ancestors={};this.symbolic={};this.stdform=[1,0,0,0,1,1,0,0];this.quadraticform=[[1,0,0],[0,1,0],[0,0,1]];if(arguments.length>0){this.board=h;this.type=g;this.elementClass=i||JXG.OBJECT_CLASS_OTHER;this.id=d.id;e=d.name;if(!JXG.exists(e)){e=this.board.generateName(this)}this.board.elementsByName[e]=this;this.name=e;this.needsRegularUpdate=d.needsregularupdate;this.visProp={};JXG.clearVisPropOld(this);d=this.resolveShortcuts(d);for(f in d){this._set(f,d[f])}this.visProp.draft=d.draft&&d.draft.draft;this.visProp.gradientangle="270";this.visProp.gradientsecondopacity=this.visProp.fillopacity;this.visProp.gradientpositionx=0.5;this.visProp.gradientpositiony=0.5}};JXG.extend(JXG.GeometryElement.prototype,{addChild:function(f){var e,d;this.childElements[f.id]=f;this.addDescendants(f);f.ancestors[this.id]=this;for(e in this.descendants){this.descendants[e].ancestors[this.id]=this;for(d in this.ancestors){this.descendants[e].ancestors[this.ancestors[d].id]=this.ancestors[d]}}for(e in this.ancestors){for(d in this.descendants){this.ancestors[e].descendants[this.descendants[d].id]=this.descendants[d]}}return this},addDescendants:function(e){var d;this.descendants[e.id]=e;for(d in e.childElements){this.addDescendants(e.childElements[d])}return this},countChildren:function(){var g,e=0,f;f=this.childElements;for(g in f){if(f.hasOwnProperty(g)&&g.indexOf("Label")<0){e++}}return e},draggable:function(){if(this.isDraggable&&!this.visProp.fixed&&!this.visProp.frozen&&this.type!=JXG.OBJECT_TYPE_GLIDER&&this.countChildren()<=1){return true}else{return false}},generatePolynomial:function(){return[]},animate:function(g,f,o){o=o||{};var d,e,j=35,k=Math.ceil(f/(j*1)),h,m=this;this.animationData={};var n=function(v,u,s){var t,r,q,p,i;t=JXG.rgb2hsv(v);r=JXG.rgb2hsv(u);q=(r[0]-t[0])/(1*k);p=(r[1]-t[1])/(1*k);i=(r[2]-t[2])/(1*k);m.animationData[s]=new Array(k);for(h=0;h<k;h++){m.animationData[s][k-h-1]=JXG.hsv2rgb(t[0]+(h+1)*q,t[1]+(h+1)*p,t[2]+(h+1)*i)}},l=function(r,i,q){r=parseFloat(r);i=parseFloat(i);if(isNaN(r)||isNaN(i)){return}var p=(i-r)/(1*k);m.animationData[q]=new Array(k);for(h=0;h<k;h++){m.animationData[q][k-h-1]=r+(h+1)*p}};for(d in g){e=d.toLowerCase();switch(e){case"strokecolor":case"fillcolor":n(this.visProp[e],g[d],e);break;case"strokeopacity":case"strokewidth":case"fillopacity":l(this.visProp[e],g[d],e);break}}this.animationCallback=o.callback;this.board.addAnimation(this);return this},update:function(){if(this.visProp.trace){this.cloneToBackground(true)}return this},updateRenderer:function(){return this},hideElement:function(){this.visProp.visible=false;this.board.renderer.hide(this);if(this.label!=null&&this.hasLabel){this.label.hiddenByParent=true;if(this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}return this},showElement:function(){this.visProp.visible=true;this.board.renderer.show(this);if(this.label!=null&&this.hasLabel&&this.label.hiddenByParent){this.label.hiddenByParent=false;if(this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}return this},_set:function(e,d){e=e.toLocaleLowerCase();if(this.visProp.hasOwnProperty(e)&&e.indexOf("color")>=0&&JXG.isString(d)&&d.length==9&&d.charAt(0)==="#"){d=JXG.rgba2rgbo(d);this.visProp[e]=d[0];this.visProp[e.replace("color","opacity")]=d[1]}else{this.visProp[e]=d}},resolveShortcuts:function(f){var e,d;for(e in JXG.Options.shortcuts){if(JXG.exists(f[e])){for(d=0;d<JXG.Options.shortcuts[e].length;d++){if(!JXG.exists(f[JXG.Options.shortcuts[e][d]])){f[JXG.Options.shortcuts[e][d]]=f[e]}}}}return f},setAttribute:JXG.shortcut(JXG.GeometryElement.prototype,"setProperty"),setProperty:function(){var h,g,j,d,e,k,f={};for(h=0;h<arguments.length;h++){d=arguments[h];if(JXG.isString(d)){k=d.split(":");f[JXG.trim(k[0])]=JXG.trim(k[1])}else{if(!JXG.isArray(d)){JXG.extend(f,d)}else{f[d[0]]=d[1]}}}f=this.resolveShortcuts(f);for(h in f){g=h.replace(/\s+/g,"").toLowerCase();j=f[h];switch(g){case"name":delete this.board.elementsByName[this.name];this.name=j;this.board.elementsByName[this.name]=this;break;case"needsregularupdate":this.needsRegularUpdate=!(j=="false"||j==false);this.board.renderer.setBuffering(this,this.needsRegularUpdate?"auto":"static");break;case"labelcolor":j=JXG.rgba2rgbo(j);e=j[1];j=j[0];if(e==0){if(this.label!=null&&this.hasLabel){this.label.content.hideElement()}}if(this.label!=null&&this.hasLabel){this.label.color=j;this.board.renderer.setObjectStrokeColor(this.label.content,j,e)}if(this.type==JXG.OBJECT_TYPE_TEXT){this.visProp.strokecolor=j;this.visProp.strokeopacity=e;this.board.renderer.setObjectStrokeColor(this,this.visProp.strokecolor,this.visProp.strokeopacity)}break;case"infoboxtext":if(typeof(j)=="string"){this.infoboxText=j}else{this.infoboxText=false}break;case"visible":if(j=="false"||j==false){this.visProp.visible=false;this.hideElement()}else{if(j=="true"||j==true){this.visProp.visible=true;this.showElement()}}break;case"face":if(this.elementClass==JXG.OBJECT_CLASS_POINT){this.visProp.face=j;this.board.renderer.changePointStyle(this)}break;case"gradient":this.visProp.gradient=j;this.board.renderer.setGradient(this);break;case"gradientsecondcolor":j=JXG.rgba2rgbo(j);this.visProp.gradientsecondcolor=j[1];this.visProp.gradientsecondopacity=j[0];this.board.renderer.updateGradient(this);break;case"gradientsecondopacity":this.visProp.gradientsecondopacity=j;this.board.renderer.updateGradient(this);break;case"withlabel":this.visProp.withlabel=j;if(!j){if(JXG.exists(this.label)&&this.hasLabel){this.label.content.hideElement()}}else{if(this.label!=null&&this.hasLabel){if(this.visProp.visible){this.label.content.showElement()}}else{this.createLabel();if(!this.visProp.visible){this.label.content.hideElement()}}}this.hasLabel=j;break;default:if(JXG.exists(this.visProp[g])&&(!JXG.Validator[g]||(JXG.Validator[g]&&JXG.Validator[g](j)))){j=j.toLowerCase&&j.toLowerCase()==="false"?false:j;this._set(g,j)}break}}this.board.update(this);return this},getAttribute:JXG.shortcut(JXG.GeometryElement.prototype,"getProperty"),getProperty:function(e){var d;e=e.toLowerCase();switch(e){case"needsregularupdate":d=this.needsRegularUpdate;break;case"labelcolor":d=this.label.color;break;case"infoboxtext":d=this.infoboxText;break;case"withlabel":d=this.hasLabel;break;default:d=this.visProp[e];break}return d},setDash:function(d){this.setProperty({dash:d});return this},prepareUpdate:function(){this.needsUpdate=true;return this},remove:function(){this.board.renderer.remove(this.board.renderer.getElementById(this.id));if(this.hasLabel){this.board.renderer.remove(this.board.renderer.getElementById(this.label.content.id))}return this},getTextAnchor:function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)},getLabelAnchor:function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)},setStraight:function(d,e){return this},setArrow:function(e,d){this.visProp.firstarrow=e;this.visProp.lastarrow=d;this.prepareUpdate().update();return this},createGradient:function(){if(this.visProp.gradient==="linear"||this.visProp.gradient==="radial"){this.board.renderer.setGradient(this)}},createLabel:function(d){if(!JXG.exists(d)){d=[10,10]}this.nameHTML=JXG.GeonextParser.replaceSup(JXG.GeonextParser.replaceSub(this.name));this.label={};if(this.visProp.withlabel){this.label.relativeCoords=d;this.label.content=JXG.createText(this.board,[this.label.relativeCoords[0],-this.label.relativeCoords[1],this.nameHTML],{anchor:this,id:this.id+"Label",isLabel:true,visible:this.visProp.visible,strokeColor:this.visProp.labelcolor||this.board.options.text.strokeColor});this.label.color=this.label.content.visProp.strokecolor;if(!this.visProp.visible){this.label.hiddenByParent=true;this.label.content.visProp.visible=false}this.hasLabel=true}return this},highlight:function(){this.board.renderer.highlight(this);return this},noHighlight:function(){this.board.renderer.noHighlight(this);return this},clearTrace:function(){var d;for(d in this.traces){this.board.renderer.remove(this.traces[d])}this.numTraces=0;return this},cloneToBackground:function(){return this},bounds:function(){},normalize:function(){this.stdform=JXG.Math.normalize(this.stdform);return this},toJSON:function(){var e='{"name":'+this.name;e+=', "id":'+this.id;var f=[];for(var d in this.visProp){if(this.visProp[d]!=null){f.push('"'+d+'":'+this.visProp[d])}}e+=', "visProp":{'+f.toString()+"}";e+="}";return e},highlightStrokeColor:function(d){this.setProperty({highlightStrokeColor:d});return this},strokeColor:function(d){this.setProperty({strokeColor:d});return this},strokeWidth:function(d){this.setProperty({strokeWidth:d});return this},fillColor:function(d){this.setProperty({fillColor:d});return this},highlightFillColor:function(d){this.setProperty({highlightFillColor:d});return this},labelColor:function(d){this.setProperty({labelColor:d});return this},dash:function(e){this.setProperty({dash:e});return this},visible:function(d){this.setProperty({visible:d});return this},shadow:function(d){this.setProperty({shadow:d});return this}});JXG.clearVisPropOld=function(d){d.visPropOld={strokecolor:"",strokeopacity:"",strokewidth:"",fillcolor:"",fillopacity:"",shadow:false,firstarrow:false,lastarrow:false}};JXG.COORDS_BY_USER=1;JXG.COORDS_BY_SCREEN=2;JXG.Coords=function(f,e,d){this.board=d;this.usrCoords=[];this.scrCoords=[];this.setCoordinates(f,e)};JXG.extend(JXG.Coords.prototype,{normalizeUsrCoords:function(){var d=JXG.Math.eps;if(Math.abs(this.usrCoords[0])>d){this.usrCoords[1]/=this.usrCoords[0];this.usrCoords[2]/=this.usrCoords[0];this.usrCoords[0]=1}},usr2screen:function(h){var g=Math.round,d=this.board,f=this.usrCoords,e=d.origin.scrCoords;if(h===null||h){this.scrCoords[0]=g(f[0]);this.scrCoords[1]=g(f[0]*e[1]+f[1]*d.unitX);this.scrCoords[2]=g(f[0]*e[2]-f[2]*d.unitY)}else{this.scrCoords[0]=f[0];this.scrCoords[1]=f[0]*e[1]+f[1]*d.unitX;this.scrCoords[2]=f[0]*e[2]-f[2]*d.unitY}},screen2usr:function(){var f=this.board.origin.scrCoords,e=this.scrCoords,d=this.board;this.usrCoords[0]=1;this.usrCoords[1]=(e[1]-f[1])/d.unitX;this.usrCoords[2]=(f[2]-e[2])/d.unitY},distance:function(e,j){var g=0,k,d=this.usrCoords,i=this.scrCoords,h;if(e===JXG.COORDS_BY_USER){k=j.usrCoords;h=d[0]-k[0];g=h*h;h=d[1]-k[1];g+=h*h;h=d[2]-k[2];g+=h*h}else{k=j.scrCoords;h=i[0]-k[0];g=h*h;h=i[1]-k[1];g+=h*h;h=i[2]-k[2];g+=h*h}return Math.sqrt(g)},setCoordinates:function(e,h,f){var d=this.usrCoords,g=this.scrCoords;if(e===JXG.COORDS_BY_USER){if(h.length===2){d[0]=1;d[1]=h[0];d[2]=h[1]}else{d[0]=h[0];d[1]=h[1];d[2]=h[2];this.normalizeUsrCoords()}this.usr2screen(f)}else{g[1]=h[0];g[2]=h[1];this.screen2usr()}}});JXG.Point=function(e,f,d){this.constructor(e,d,JXG.OBJECT_TYPE_POINT,JXG.OBJECT_CLASS_POINT);if(f==null){f=[0,0]}this.coords=new JXG.Coords(JXG.COORDS_BY_USER,f,this.board);this.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,f,this.board);this.position=null;this.onPolygon=false;this.slideObject=null;this.group=[];this.id=this.board.setId(this,"P");this.board.renderer.drawPoint(this);this.board.finalizeAdding(this);this.createLabel()};JXG.Point.prototype=new JXG.GeometryElement();JXG.extend(JXG.Point.prototype,{hasPoint:function(e,g){var d=this.coords.scrCoords,f;f=parseFloat(this.visProp.size);if(f<this.board.options.precision.hasPoint){f=this.board.options.precision.hasPoint}return((Math.abs(d[1]-e)<f+2)&&(Math.abs(d[2]-g))<f+2)},updateConstraint:function(){return this},update:function(h){var j,g,l,m,r,e,k,q,f,p,n,s,o,d;if(!this.needsUpdate){return this}if(typeof h=="undefined"){h=false}if(this.visProp.trace){this.cloneToBackground(true)}if(this.type==JXG.OBJECT_TYPE_GLIDER){if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CIRCLE){if(h){this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.slideObject.midpoint.X()+Math.cos(this.position),this.slideObject.midpoint.Y()+Math.sin(this.position)]);this.coords=JXG.Math.Geometry.projectPointToCircle(this,this.slideObject,this.board)}else{this.coords=JXG.Math.Geometry.projectPointToCircle(this,this.slideObject,this.board);this.position=JXG.Math.Geometry.rad([this.slideObject.midpoint.X()+1,this.slideObject.midpoint.Y()],this.slideObject.midpoint,this)}}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_LINE){this.coords=JXG.Math.Geometry.projectPointToLine(this,this.slideObject,this.board);g=this.slideObject.point1.coords;l=this.slideObject.point2.coords;if(h){if(Math.abs(g.usrCoords[0])>=JXG.Math.eps&&Math.abs(l.usrCoords[0])>=JXG.Math.eps){this.coords.setCoordinates(JXG.COORDS_BY_USER,[g.usrCoords[1]+this.position*(l.usrCoords[1]-g.usrCoords[1]),g.usrCoords[2]+this.position*(l.usrCoords[2]-g.usrCoords[2])])}}else{m=1;r=g.distance(JXG.COORDS_BY_USER,this.coords);e=g.distance(JXG.COORDS_BY_USER,l);k=l.distance(JXG.COORDS_BY_USER,this.coords);if(((r>e)||(k>e))&&(r<k)){m=-1}this.position=m*r/e;if(this.visProp.snapwidth>0&&Math.abs(this._smax-this._smin)>=JXG.Math.eps){if(this.position<0){this.position=0}if(this.position>1){this.position=1}q=this.position*(this._smax-this._smin)+this._smin;q=Math.round(q/this.visProp.snapwidth)*this.visProp.snapwidth;this.position=(q-this._smin)/(this._smax-this._smin);this.update(true)}}f=this.slideObject.point1.coords.scrCoords;p=this.slideObject.point2.coords.scrCoords;if(this.slideObject.getSlope()==0){j=1}else{j=2}n=this.coords.scrCoords[j];if(!this.slideObject.visProp.straightfirst){if(f[j]<p[j]){if(n<f[j]){this.coords=this.slideObject.point1.coords;this.position=0}}else{if(f[j]>p[j]){if(n>f[j]){this.coords=this.slideObject.point1.coords;this.position=0}}}}if(!this.slideObject.visProp.straightlast){if(f[j]<p[j]){if(n>p[j]){this.coords=this.slideObject.point2.coords;this.position=1}}else{if(f[j]>p[j]){if(n<p[j]){this.coords=this.slideObject.point2.coords;this.position=1}}}}if(this.onPolygon){s=this.slideObject.point1.coords;o=this.slideObject.point2.coords;if(Math.abs(this.coords.scrCoords[1]-s.scrCoords[1])<this.board.options.precision.hasPoint&&Math.abs(this.coords.scrCoords[2]-s.scrCoords[2])<this.board.options.precision.hasPoint){d=this.slideObject.parentPolygon;for(j=0;j<d.borders.length;j++){if(this.slideObject==d.borders[j]){this.slideObject=d.borders[(j-1+d.borders.length)%d.borders.length];break}}}else{if(Math.abs(this.coords.scrCoords[1]-o.scrCoords[1])<this.board.options.precision.hasPoint&&Math.abs(this.coords.scrCoords[2]-o.scrCoords[2])<this.board.options.precision.hasPoint){d=this.slideObject.parentPolygon;for(j=0;j<d.borders.length;j++){if(this.slideObject==d.borders[j]){this.slideObject=d.borders[(j+1+d.borders.length)%d.borders.length];break}}}}}}else{if(this.slideObject.type==JXG.OBJECT_TYPE_TURTLE){this.updateConstraint();this.coords=JXG.Math.Geometry.projectPointToTurtle(this,this.slideObject,this.board)}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CURVE){this.updateConstraint();this.coords=JXG.Math.Geometry.projectPointToCurve(this,this.slideObject,this.board)}}}}}if(this.type==JXG.OBJECT_TYPE_CAS){this.updateConstraint()}this.updateTransform();return this},updateRenderer:function(){if(!this.needsUpdate){return this}if(this.visProp.visible){var d=this.isReal;this.isReal=(!isNaN(this.coords.usrCoords[1]+this.coords.usrCoords[2]));this.isReal=(Math.abs(this.coords.usrCoords[0])>JXG.Math.eps)?this.isReal:false;if(this.isReal){if(d!=this.isReal){this.board.renderer.show(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}this.board.renderer.updatePoint(this)}else{if(d!=this.isReal){this.board.renderer.hide(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}}}if(this.hasLabel&&this.visProp.visible&&this.label.content&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}this.needsUpdate=false;return this},X:function(){return this.coords.usrCoords[1]},Y:function(){return this.coords.usrCoords[2]},Z:function(){return this.coords.usrCoords[0]},XEval:function(){return this.coords.usrCoords[1]},YEval:function(){return this.coords.usrCoords[2]},ZEval:function(){return this.coords.usrCoords[0]},bounds:function(){return this.coords.usrCoords.slice(1).concat(this.coords.usrCoords.slice(1))},Dist:function(e){var g,i=e.coords.usrCoords,d=this.coords.usrCoords,h;h=d[0]-i[0];g=h*h;h=d[1]-i[1];g+=h*h;h=d[2]-i[2];g+=h*h;return Math.sqrt(g)},setPositionDirectly:function(d,k,h){var g,n,m,f,e,j=this.coords,l;this.coords=new JXG.Coords(d,[k,h],this.board);if(this.group.length!=0){n=this.coords.usrCoords[1]-j.usrCoords[1];m=this.coords.usrCoords[2]-j.usrCoords[2];for(g=0;g<this.group.length;g++){for(f in this.group[g].objects){e=this.group[g].objects[f];e.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,[e.initialCoords.usrCoords[1]+n,e.initialCoords.usrCoords[2]+m],this.board)}}this.group[this.group.length-1].dX=this.coords.scrCoords[1]-j.scrCoords[1];this.group[this.group.length-1].dY=this.coords.scrCoords[2]-j.scrCoords[2];this.group[this.group.length-1].update(this)}else{for(g=this.transformations.length-1;g>=0;g--){if(d==JXG.COORDS_BY_SCREEN){l=(new JXG.Coords(d,[k,h],this.board)).usrCoords}else{l=[1,k,h]}this.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,JXG.Math.matVecMult(JXG.Math.inverse(this.transformations[g].matrix),l),this.board)}this.update()}return this},setPositionByTransform:function(g,d,f){var e=this.board.create("transform",[d,f],{type:"translate"});if(this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix){this.transformations[this.transformations.length-1].melt(e)}else{this.addTransform(this,e)}if(this.group.length==0){this.update()}return this},setPosition:function(f,d,e){this.setPositionDirectly(f,d,e);return this},makeGlider:function(d){this.slideObject=JXG.getReference(this.board,d);this.type=JXG.OBJECT_TYPE_GLIDER;this.visProp.snapwidth=-1;this.slideObject.addChild(this);this.isDraggable=true;this.generatePolynomial=function(){return this.slideObject.generatePolynomial(this)};return this},addConstraint:function(h){this.type=JXG.OBJECT_TYPE_CAS;var j=this.board.elementsByName;var k=[];var d;this.isDraggable=false;for(var g=0;g<h.length;g++){var e=h[g];if(typeof e=="string"){var f=JXG.GeonextParser.geonext2JS(e,this.board);k[g]=new Function("","return "+f+";")}else{if(typeof e=="function"){k[g]=e}else{if(typeof e=="number"){k[g]=function(i){return function(){return i}}(e)}else{if(typeof e=="object"&&typeof e.Value=="function"){k[g]=(function(i){return function(){return i.Value()}})(e)}}}}}if(h.length==1){this.updateConstraint=function(){var i=k[0]();if(JXG.isArray(i)){this.coords.setCoordinates(JXG.COORDS_BY_USER,i)}else{this.coords=i}}}else{if(h.length==2){this.XEval=k[0];this.YEval=k[1];d="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.XEval(),this.YEval()]);";this.updateConstraint=new Function("",d)}else{this.ZEval=k[0];this.XEval=k[1];this.YEval=k[2];d="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.ZEval(),this.XEval(),this.YEval()]);";this.updateConstraint=new Function("",d)}}return this},updateTransform:function(){if(this.transformations.length==0||this.baseElement==null){return}var e,d;if(this===this.baseElement){e=this.transformations[0].apply(this.baseElement,"self")}else{e=this.transformations[0].apply(this.baseElement)}this.coords.setCoordinates(JXG.COORDS_BY_USER,e);for(d=1;d<this.transformations.length;d++){this.coords.setCoordinates(JXG.COORDS_BY_USER,this.transformations[d].apply(this))}return this},addTransform:function(g,e){var h,f,d;if(this.transformations.length==0){this.baseElement=g}if(JXG.isArray(e)){h=e}else{h=[e]}d=h.length;for(f=0;f<d;f++){this.transformations.push(h[f])}return this},startAnimation:function(d,e){if((this.type==JXG.OBJECT_TYPE_GLIDER)&&(typeof this.intervalCode=="undefined")){this.intervalCode=window.setInterval("JXG.JSXGraph.boards['"+this.board.id+"'].objects['"+this.id+"']._anim("+d+", "+e+")",250);if(typeof this.intervalCount=="undefined"){this.intervalCount=0}}return this},stopAnimation:function(){if(typeof this.intervalCode!="undefined"){window.clearInterval(this.intervalCode);delete (this.intervalCode)}return this},moveAlong:function(m,e,n){n=n||{};var l=[],h=35,j=function(p,o){return function(){return m[p][o]}},d=[],g,f,k=e/h;if(JXG.isArray(m)){for(g=0;g<m.length;g++){if(JXG.isPoint(m[g])){d[g]=m[g]}else{d[g]={elementClass:JXG.OBJECT_CLASS_POINT,X:j(g,0),Y:j(g,1)}}}e=e||0;if(e===0){this.setPosition(JXG.COORDS_BY_USER,d[d.length-1].X(),d[d.length-1].Y());return this.board.update(this)}f=JXG.Math.Numerics.Neville(d);for(g=0;g<k;g++){l[g]=[];l[g][0]=f[0]((k-g)/k*f[3]());l[g][1]=f[1]((k-g)/k*f[3]())}this.animationPath=l}else{if(JXG.isFunction(m)){this.animationPath=m;this.animationStart=new Date().getTime()}}this.animationCallback=n.callback;this.board.addAnimation(this);return this},moveTo:function(k,f,p){if(typeof f=="undefined"||f==0){this.setPosition(JXG.COORDS_BY_USER,k[0],k[1]);return this.board.update(this)}p=p||{};var l=35,m=Math.ceil(f/(l*1)),n=new Array(m+1),e=this.coords.usrCoords[1],d=this.coords.usrCoords[2],h=(k[0]-e),g=(k[1]-d),j,o=function(q){if(p.effect&&p.effect=="<>"){return Math.pow(Math.sin((q/(m*1))*Math.PI/2),2)}return q/m};if(Math.abs(h)<JXG.Math.eps&&Math.abs(g)<JXG.Math.eps){return this}for(j=m;j>=0;j--){n[m-j]=[e+h*o(j),d+g*o(j)]}this.animationPath=n;this.animationCallback=p.callback;this.board.addAnimation(this);return this},visit:function(m,f,r){if(typeof r=="number"){r={repeat:r}}else{r=r||{};if(typeof r.repeat=="undefined"){r.repeat=1}}var n=35,o=Math.ceil(f/(n*1)),p=new Array(repeat*(o+1)),e=this.coords.usrCoords[1],d=this.coords.usrCoords[2],k=(m[0]-e),g=(m[1]-d),l,h,q=function(j){if(r.effect&&r.effect=="<>"){return Math.pow(Math.sin((j/(o*1))*Math.PI/2),2)}return j/o};for(h=0;h<r.repeat;h++){for(l=o;l>=0;l--){p[h*(o+1)+o-l]=[e+k*q(l),d+g*q(l)]}}this.animationPath=p;this.animationCallback=r.callback;this.board.addAnimation(this);return this},_anim:function(n,i){var e,l,j,h,g,f,m=1,d,k;this.intervalCount++;if(this.intervalCount>i){this.intervalCount=0}if(this.slideObject.elementClass==JXG.OBJECT_CLASS_LINE){e=this.slideObject.point1.coords.distance(JXG.COORDS_BY_SCREEN,this.slideObject.point2.coords);l=this.slideObject.getSlope();if(l!="INF"){g=Math.atan(l);j=Math.round((this.intervalCount/i)*e*Math.cos(g));h=Math.round((this.intervalCount/i)*e*Math.sin(g))}else{j=0;h=Math.round((this.intervalCount/i)*e)}if(n<0){f=this.slideObject.point2;if(this.slideObject.point2.coords.scrCoords[1]-this.slideObject.point1.coords.scrCoords[1]>0){m=-1}else{if(this.slideObject.point2.coords.scrCoords[1]-this.slideObject.point1.coords.scrCoords[1]==0){if(this.slideObject.point2.coords.scrCoords[2]-this.slideObject.point1.coords.scrCoords[2]>0){m=-1}}}}else{f=this.slideObject.point1;if(this.slideObject.point1.coords.scrCoords[1]-this.slideObject.point2.coords.scrCoords[1]>0){m=-1}else{if(this.slideObject.point1.coords.scrCoords[1]-this.slideObject.point2.coords.scrCoords[1]==0){if(this.slideObject.point1.coords.scrCoords[2]-this.slideObject.point2.coords.scrCoords[2]>0){m=-1}}}}this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[f.coords.scrCoords[1]+m*j,f.coords.scrCoords[2]+m*h])}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CURVE){if(n>0){d=Math.round(this.intervalCount/i*this.board.canvasWidth)}else{d=Math.round((i-this.intervalCount)/i*this.board.canvasWidth)}this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[d,0]);this.coords=JXG.Math.Geometry.projectPointToCurve(this,this.slideObject,this.board)}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CIRCLE){if(n<0){g=this.intervalCount/i*2*Math.PI}else{g=(i-this.intervalCount)/i*2*Math.PI}k=this.slideObject.Radius();this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.slideObject.midpoint.coords.usrCoords[1]+k*Math.cos(g),this.slideObject.midpoint.coords.usrCoords[2]+k*Math.sin(g)])}}}this.board.update(this);return this},setStyle:function(d){var e=["cross","cross","cross","circle","circle","circle","circle","square","square","square","plus","plus","plus"],f=[2,3,4,1,2,3,4,2,3,4,2,3,4];this.visProp.face=e[d];this.visProp.size=f[d];this.board.renderer.changePointStyle(this);return this},normalizeFace:function(d){var e={cross:"x",x:"x",circle:"o",o:"o",square:"[]","[]":"[]",plus:"+","+":"+",diamond:"<>","<>":"<>",triangleup:"^",a:"^","^":"^",triangledown:"v",v:"v",triangleleft:"<","<":"<",triangleright:">",">":">"};return e[d]},remove:function(){if(this.hasLabel){this.board.renderer.remove(this.board.renderer.getElementById(this.label.content.id))}this.board.renderer.remove(this.board.renderer.getElementById(this.id))},getTextAnchor:function(){return this.coords},getLabelAnchor:function(){return this.coords},face:function(d){this.setProperty({face:d})},size:function(d){this.setProperty({size:d})},cloneToBackground:function(){var d={};d.id=this.id+"T"+this.numTraces;this.numTraces++;d.coords=this.coords;d.visProp=this.visProp;d.visProp.layer=this.board.options.layer.trace;d.elementClass=JXG.OBJECT_CLASS_POINT;d.board=this.board;JXG.clearVisPropOld(d);this.board.renderer.drawPoint(d);this.traces[d.id]=d.rendNode;return this}});JXG.createPoint=function(l,h,g){var k,f=false,j,e,d;d=JXG.copyAttributes(g,l.options,"point");for(j=0;j<h.length;j++){if(typeof h[j]=="function"||typeof h[j]=="string"){f=true}}if(!f){if((JXG.isNumber(h[0]))&&(JXG.isNumber(h[1]))){k=new JXG.Point(l,h,d);if(JXG.exists(d.slideobject)){k.makeGlider(d.slideobject)}else{k.baseElement=k}k.isDraggable=true}else{if((typeof h[0]=="object")&&(typeof h[1]=="object")){k=new JXG.Point(l,[0,0],d);k.addTransform(h[0],h[1]);k.isDraggable=false}else{throw new Error("JSXGraph: Can't create point with parent types '"+(typeof h[0])+"' and '"+(typeof h[1])+"'.\nPossible parent types: [x,y], [z,x,y], [point,transformation]")}}}else{k=new JXG.Point(l,[NaN,NaN],d);k.addConstraint(h)}return k};JXG.createGlider=function(h,f,e){var g,d=JXG.copyAttributes(e,h.options,"point");if(f.length===1){g=h.create("point",[0,0],d)}else{g=h.create("point",f.slice(0,2),d)}g.makeGlider(f[f.length-1]);return g};JXG.createIntersectionPoint=function(g,e,d){var f;if(e.length>=3){if(e.length==3){e.push(null)}f=g.create("point",[g.intersection(e[0],e[1],e[2],e[3])],d)}e[0].addChild(f);e[1].addChild(f);f.generatePolynomial=function(){var h=e[0].generatePolynomial(f);var i=e[1].generatePolynomial(f);if((h.length==0)||(i.length==0)){return[]}else{return[h[0],i[0]]}};return f};JXG.createOtherIntersectionPoint=function(g,e,d){var f;if(e.length!=3||!JXG.isPoint(e[2])||(e[0].elementClass!=JXG.OBJECT_CLASS_LINE&&e[0].elementClass!=JXG.OBJECT_CLASS_CIRCLE)||(e[1].elementClass!=JXG.OBJECT_CLASS_LINE&&e[1].elementClass!=JXG.OBJECT_CLASS_CIRCLE)){throw new Error("JSXGraph: Can't create 'other intersection point' with parent types '"+(typeof e[0])+"',  '"+(typeof e[1])+"'and  '"+(typeof e[2])+"'.\nPossible parent types: [circle|line,circle|line,point]")}else{f=g.create("point",[g.otherIntersection(e[0],e[1],e[2])],d)}e[0].addChild(f);e[1].addChild(f);f.generatePolynomial=function(){var h=e[0].generatePolynomial(f);var i=e[1].generatePolynomial(f);if((h.length==0)||(i.length==0)){return[]}else{return[h[0],i[0]]}};return f};JXG.JSXGraph.registerElement("point",JXG.createPoint);JXG.JSXGraph.registerElement("glider",JXG.createGlider);JXG.JSXGraph.registerElement("intersection",JXG.createIntersectionPoint);JXG.JSXGraph.registerElement("otherintersection",JXG.createOtherIntersectionPoint);JXG.Line=function(e,g,f,d){this.constructor(e,d,JXG.OBJECT_TYPE_LINE,JXG.OBJECT_CLASS_LINE);this.point1=JXG.getReference(this.board,g);this.point2=JXG.getReference(this.board,f);this.ticks=[];this.defaultTicks=null;this.parentPolygon=null;this.labelOffsets=[].concat(d.labeloffsets);this.labelOffsets[0]=Math.abs(this.labelOffsets[0]);this.labelOffsets[1]=Math.abs(this.labelOffsets[1]);this.id=this.board.setId(this,"L");this.board.renderer.drawLine(this);this.board.finalizeAdding(this);this.createLabel();this.point1.addChild(this);this.point2.addChild(this);this.updateStdform()};JXG.Line.prototype=new JXG.GeometryElement;JXG.extend(JXG.Line.prototype,{hasPoint:function(l,j){var h=[],q,o=[1,l,j],m=[],r,f,k,e,n,p,g,d;h[0]=this.stdform[0]-this.stdform[1]*this.board.origin.scrCoords[1]/this.board.unitX+this.stdform[2]*this.board.origin.scrCoords[2]/this.board.unitY;h[1]=this.stdform[1]/this.board.unitX;h[2]=this.stdform[2]/(-this.board.unitY);var m=[0,h[1],h[2]];m=JXG.Math.crossProduct(m,o);m=JXG.Math.crossProduct(m,h);m[1]/=m[0];m[2]/=m[0];m[0]=1;q=(o[0]-m[0])*(o[0]-m[0])+(o[1]-m[1])*(o[1]-m[1])+(o[2]-m[2])*(o[2]-m[2]);if(isNaN(q)||q>this.board.options.precision.hasPoint*this.board.options.precision.hasPoint){return false}if(this.visProp.straightfirst&&this.visProp.straightlast){return true}else{e=this.point1.coords.scrCoords;n=this.point2.coords.scrCoords;d=(n[1]-e[1])*(n[1]-e[1])+(n[2]-e[2])*(n[2]-e[2]);p=(m[1]-e[1])*(m[1]-e[1])+(m[2]-e[2])*(m[2]-e[2]);g=(m[1]-n[1])*(m[1]-n[1])+(m[2]-n[2])*(m[2]-n[2]);if((p>d)||(g>d)){if(p<g){if(!this.visProp.straightfirst){return false}}else{if(!this.visProp.straightlast){return false}}}return true}},update:function(){var d,e,f;if(this.needsUpdate){if(this.constrained){if(typeof this.funps!="undefined"){e=this.funps();this.point1=e[0];this.point2=e[1]}else{this.point1=this.funp1();this.point2=this.funp2()}}this.updateStdform();if(this.visProp.trace){this.cloneToBackground(true)}}return this},updateStdform:function(){var d=JXG.Math.crossProduct(this.point1.coords.usrCoords,this.point2.coords.usrCoords);this.stdform[0]=d[0];this.stdform[1]=d[1];this.stdform[2]=d[2];this.stdform[3]=0;this.normalize()},updateRenderer:function(){var d,e;if(this.needsUpdate&&this.visProp.visible){d=this.isReal;this.isReal=(!isNaN(this.point1.coords.usrCoords[1]+this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[1]+this.point2.coords.usrCoords[2])&&(JXG.Math.innerProduct(this.stdform,this.stdform,3)>=JXG.Math.eps*JXG.Math.eps));if(this.isReal){if(d!=this.isReal){this.board.renderer.show(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}this.board.renderer.updateLine(this)}else{if(d!=this.isReal){this.board.renderer.hide(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}}this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}return this},generatePolynomial:function(h){var g=this.point1.symbolic.x,f=this.point1.symbolic.y,j=this.point2.symbolic.x,i=this.point2.symbolic.y,e=h.symbolic.x,d=h.symbolic.y;return[["(",f,")*(",e,")-(",f,")*(",j,")+(",d,")*(",j,")-(",g,")*(",d,")+(",g,")*(",i,")-(",e,")*(",i,")"].join("")]},getRise:function(){if(Math.abs(this.stdform[2])>=JXG.Math.eps){return -this.stdform[0]/this.stdform[2]}else{return Infinity}},getSlope:function(){if(Math.abs(this.stdform[2])>=JXG.Math.eps){return -this.stdform[1]/this.stdform[2]}else{return Infinity}},getAngle:function(){var d=Math.atan2(this.point2.Y()-this.point1.Y(),this.point2.X()-this.point1.X());return d},setStraight:function(d,e){this.visProp.straightfirst=d;this.visProp.straightlast=e;this.board.renderer.updateLine(this);return this},getTextAnchor:function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0.5*(this.point2.X()+this.point1.X()),0.5*(this.point2.Y()+this.point1.Y())],this.board)},setLabelRelativeCoords:function(d){if(JXG.exists(this.label.content)){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d[0],-d[1]],this.board)}},getLabelAnchor:function(){var h,f,e,g,d,i=this.labelOffsets[0],j=this.labelOffsets[1];if(!this.visProp.straightfirst&&!this.visProp.straightlast){this.setLabelRelativeCoords(this.labelOffsets);return new JXG.Coords(JXG.COORDS_BY_USER,[this.point2.X()-0.5*(this.point2.X()-this.point1.X()),this.point2.Y()-0.5*(this.point2.Y()-this.point1.Y())],this.board)}else{f=new JXG.Coords(JXG.COORDS_BY_USER,this.point1.coords.usrCoords,this.board);e=new JXG.Coords(JXG.COORDS_BY_USER,this.point2.coords.usrCoords,this.board);JXG.Math.Geometry.calcStraight(this,f,e);if(!this.visProp.straightfirst||this.type==JXG.OBJECT_TYPE_AXIS){h=e}else{h=f}if(this.label.content!=null){g=[0,0];d=this.getSlope();if(h.scrCoords[2]==0){if(d==Infinity){g=[i,-j]}else{if(d>=0){g=[i,-j]}else{g=[-i,-j]}}}else{if(h.scrCoords[2]==this.board.canvasHeight){if(d==Infinity){g=[i,j]}else{if(d>=0){g=[-i,j]}else{g=[i,j]}}}}if(h.scrCoords[1]==0){if(d==Infinity){g=[i,j]}else{if(d>=0){g=[i,-j]}else{g=[i,j]}}}else{if(h.scrCoords[1]==this.board.canvasWidth){if(d==Infinity){g=[-i,j]}else{if(d>=0){g=[-i,j]}else{g=[-i,-j]}}}}this.setLabelRelativeCoords(g)}return h}},cloneToBackground:function(e){var h={},f,d,g;h.id=this.id+"T"+this.numTraces;h.elementClass=JXG.OBJECT_CLASS_LINE;this.numTraces++;h.point1=this.point1;h.point2=this.point2;h.stdform=this.stdform;h.board=this.board;h.visProp=this.visProp;h.visProp.layer=this.board.options.layer.trace;JXG.clearVisPropOld(h);d=this.getSlope();f=this.getRise();h.getSlope=function(){return d};h.getRise=function(){return f};g=this.board.renderer.enhancedRendering;this.board.renderer.enhancedRendering=true;this.board.renderer.drawLine(h);this.board.renderer.enhancedRendering=g;this.traces[h.id]=h.rendNode;delete h},addTransform:function(d){var f,e;if(JXG.isArray(d)){f=d}else{f=[d]}for(e=0;e<f.length;e++){this.point1.transformations.push(f[e]);this.point2.transformations.push(f[e])}},setPosition:function(g,d,f){var e=this.board.create("transform",[d,f],{type:"translate"});if(this.point1.transformations.length>0&&this.point1.transformations[this.point1.transformations.length-1].isNumericMatrix){this.point1.transformations[this.point1.transformations.length-1].melt(e)}else{this.point1.addTransform(this.point1,e)}if(this.point2.transformations.length>0&&this.point2.transformations[this.point2.transformations.length-1].isNumericMatrix){this.point2.transformations[this.point2.transformations.length-1].melt(e)}else{this.point2.addTransform(this.point2,e)}},setPositionDirectly:function(d,k,j,f,e){var m=k-f,l=j-e,h,g,i;if(!this.point1.draggable()||!this.point2.draggable()){return this}i=this.point1.coords;if(d==JXG.COORDS_BY_SCREEN){h=i.scrCoords[1]+m;g=i.scrCoords[2]+l}else{h=i.usrCoords[1]+m;g=i.usrCoords[2]+l}this.point1.setPositionDirectly(d,h,g);i=this.point2.coords;if(d==JXG.COORDS_BY_SCREEN){h=i.scrCoords[1]+m;g=i.scrCoords[2]+l}else{h=i.usrCoords[1]+m;g=i.usrCoords[2]+l}this.point2.setPositionDirectly(d,h,g);this.update();return this},X:function(i){var l=this.stdform[1],k=this.stdform[2],j=this.stdform[0],g,f,d,e,h;i*=Math.PI;g=l*Math.cos(i)+k*Math.sin(i);f=j;d=Math.sqrt(g*g+f*f);e=-f/d;h=g/d;if(Math.abs(h)<JXG.Math.eps){h=1}return e*Math.cos(i)/h},Y:function(i){var l=this.stdform[1],k=this.stdform[2],j=this.stdform[0],g,f,d,e,h;i*=Math.PI;g=l*Math.cos(i)+k*Math.sin(i);f=j;d=Math.sqrt(g*g+f*f);e=-f/d;h=g/d;if(Math.abs(h)<JXG.Math.eps){h=1}return e*Math.sin(i)/h},Z:function(h){var f=this.stdform[1],e=this.stdform[2],k=this.stdform[0],d,j,g,i;h*=Math.PI;d=f*Math.cos(h)+e*Math.sin(h);j=k;g=Math.sqrt(d*d+j*j);i=d/g;if(Math.abs(i)>=JXG.Math.eps){return 1}else{return 0}},L:function(){return this.point1.Dist(this.point2)},minX:function(){return 0},maxX:function(){return 1},bounds:function(){var d=this.point1.coords.usrCoords,e=this.point2.coords.usrCoords;return[Math.min(d[1],e[1]),Math.max(d[2],e[2]),Math.max(d[1],e[1]),Math.min(d[2],e[2])]},addTicks:function(d){if(d.id==""||typeof d.id=="undefined"){d.id=this.id+"_ticks_"+(this.ticks.length+1)}this.board.renderer.drawTicks(d);this.ticks.push(d);return d.id},removeAllTicks:function(){var e,d;for(d=this.ticks.length;d>0;d--){this.removeTicks(this.ticks[d-1])}this.ticks=new Array();this.board.update()},removeTicks:function(f){var e,d;if(this.defaultTicks!=null&&this.defaultTicks==f){this.defaultTicks=null}for(e=this.ticks.length;e>0;e--){if(this.ticks[e-1]==f){this.board.removeObject(this.ticks[e-1]);for(d=0;d<this.ticks[e-1].ticks.length;d++){if(this.ticks[e-1].labels[d]!=null){this.board.removeObject(this.ticks[e-1].labels[d])}}delete (this.ticks[e-1]);break}}}});JXG.createLine=function(k,n,h){var f,p,o,j,l,m=[],g=false,e;if(n.length==2){if(JXG.isArray(n[0])&&n[0].length>1){l=JXG.copyAttributes(h,k.options,"line","point1");p=k.create("point",n[0],l)}else{if(JXG.isString(n[0])||n[0].elementClass==JXG.OBJECT_CLASS_POINT){p=JXG.getReference(k,n[0])}else{if((typeof n[0]=="function")&&(n[0]().elementClass==JXG.OBJECT_CLASS_POINT)){p=n[0]();g=true}else{throw new Error("JSXGraph: Can't create line with parent types '"+(typeof n[0])+"' and '"+(typeof n[1])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]")}}}if(JXG.isArray(n[1])&&n[1].length>1){l=JXG.copyAttributes(h,k.options,"line","point2");o=k.create("point",n[1],l)}else{if(JXG.isString(n[1])||n[1].elementClass==JXG.OBJECT_CLASS_POINT){o=JXG.getReference(k,n[1])}else{if((typeof n[1]=="function")&&(n[1]().elementClass==JXG.OBJECT_CLASS_POINT)){o=n[1]();g=true}else{throw new Error("JSXGraph: Can't create line with parent types '"+(typeof n[0])+"' and '"+(typeof n[1])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]")}}}l=JXG.copyAttributes(h,k.options,"line");f=new JXG.Line(k,p,o,l);if(g){f.constrained=true;f.funp1=n[0];f.funp2=n[1]}else{f.isDraggable=true}}else{if(n.length==3){e=true;for(j=0;j<3;j++){if(typeof n[j]=="number"){m[j]=function(i){return function(){return i}}(n[j])}else{if(typeof n[j]=="function"){m[j]=n[j];e=false}else{throw new Error("JSXGraph: Can't create line with parent types '"+(typeof n[0])+"' and '"+(typeof n[1])+"' and '"+(typeof n[2])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]")}}}l=JXG.copyAttributes(h,k.options,"line","point1");if(e){p=k.create("point",[m[2]()*m[2]()+m[1]()*m[1](),m[2]()-m[1]()*m[0]()+m[2](),-m[1]()-m[2]()*m[0]()-m[1]()],l)}else{p=k.create("point",[function(){return(0+m[2]()*m[2]()+m[1]()*m[1]())*0.5},function(){return(m[2]()-m[1]()*m[0]()+m[2]())*0.5},function(){return(-m[1]()-m[2]()*m[0]()-m[1]())*0.5}],l)}l=JXG.copyAttributes(h,k.options,"line","point2");if(e){o=k.create("point",[m[2]()*m[2]()+m[1]()*m[1](),-m[1]()*m[0]()+m[2](),-m[2]()*m[0]()-m[1]()],l)}else{o=k.create("point",[function(){return m[2]()*m[2]()+m[1]()*m[1]()},function(){return -m[1]()*m[0]()+m[2]()},function(){return -m[2]()*m[0]()-m[1]()}],l)}p.prepareUpdate().update();o.prepareUpdate().update();l=JXG.copyAttributes(h,k.options,"line");f=new JXG.Line(k,p,o,l);f.isDraggable=e}else{if((n.length==1)&&(typeof n[0]=="function")&&(n[0]().length==2)&&(n[0]()[0].elementClass==JXG.OBJECT_CLASS_POINT)&&(n[0]()[1].elementClass==JXG.OBJECT_CLASS_POINT)){var d=n[0]();l=JXG.copyAttributes(h,k.options,"line");f=new JXG.Line(k,d[0],d[1],l);f.constrained=true;f.funps=n[0]}else{throw new Error("JSXGraph: Can't create line with parent types '"+(typeof n[0])+"' and '"+(typeof n[1])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]")}}}return f};JXG.JSXGraph.registerElement("line",JXG.createLine);JXG.createSegment=function(f,e,d){d.straightFirst=false;d.straightLast=false;return f.create("line",e,d)};JXG.JSXGraph.registerElement("segment",JXG.createSegment);JXG.createArrow=function(g,e,d){var f;f=g.create("line",e,d).setStraight(false,false);f.setArrow(false,true);f.type=JXG.OBJECT_TYPE_VECTOR;return f};JXG.JSXGraph.registerElement("arrow",JXG.createArrow);JXG.createAxis=function(i,f,e){var d,h,j;if((JXG.isArray(f[0])||JXG.isPoint(f[0]))&&(JXG.isArray(f[1])||JXG.isPoint(f[1]))){d=JXG.copyAttributes(e,i.options,"axis");h=i.create("line",f,d);h.type=JXG.OBJECT_TYPE_AXIS;for(var g in h.ancestors){h.ancestors[g].type=JXG.OBJECT_TYPE_AXISPOINT}d=JXG.copyAttributes(e,i.options,"axis","ticks");if(JXG.exists(d.ticksdistance)){j=d.ticksdistance}else{if(JXG.isArray(d.ticks)){j=d.ticks}else{j=1}}h.defaultTicks=i.create("ticks",[h,j],d)}else{throw new Error("JSXGraph: Can't create point with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]]")}return h};JXG.JSXGraph.registerElement("axis",JXG.createAxis);JXG.createTangent=function(o,r,k){var d,q,m,n,l,h,e,s,t,u;if(r.length==1){d=r[0];q=d.slideObject}else{if(r.length==2){if(JXG.isPoint(r[0])){d=r[0];q=r[1]}else{if(JXG.isPoint(r[1])){q=r[0];d=r[1]}else{throw new Error("JSXGraph: Can't create tangent with parent types '"+(typeof r[0])+"' and '"+(typeof r[1])+"'.\nPossible parent types: [glider], [point,line|curve|circle|conic]")}}}else{throw new Error("JSXGraph: Can't create tangent with parent types '"+(typeof r[0])+"' and '"+(typeof r[1])+"'.\nPossible parent types: [glider], [point,line|curve|circle|conic]")}}if(q.elementClass==JXG.OBJECT_CLASS_LINE){u=o.create("line",[q.point1,q.point2],k)}else{if(q.elementClass==JXG.OBJECT_CLASS_CURVE&&!(q.type==JXG.OBJECT_TYPE_CONIC)){if(q.visProp.curvetype!="plot"){m=q.X;n=q.Y;u=o.create("line",[function(){return -d.X()*o.D(n)(d.position)+d.Y()*o.D(m)(d.position)},function(){return o.D(n)(d.position)},function(){return -o.D(m)(d.position)}],k);d.addChild(u);u.glider=d}else{u=o.create("line",[function(){l=Math.floor(d.position);if(l==q.numberPoints-1){l--}if(l<0){return 1}return q.Y(l)*q.X(l+1)-q.X(l)*q.Y(l+1)},function(){l=Math.floor(d.position);if(l==q.numberPoints-1){l--}if(l<0){return 0}return q.Y(l+1)-q.Y(l)},function(){l=Math.floor(d.position);if(l==q.numberPoints-1){l--}if(l<0){return 0}return q.X(l)-q.X(l+1)}],k);d.addChild(u);u.glider=d}}else{if(q.type==JXG.OBJECT_TYPE_TURTLE){u=o.create("line",[function(){l=Math.floor(d.position);for(h=0;h<q.objects.length;h++){e=q.objects[h];if(e.type==JXG.OBJECT_TYPE_CURVE){if(l<e.numberPoints){break}l-=e.numberPoints}}if(l==e.numberPoints-1){l--}if(l<0){return 1}return e.Y(l)*e.X(l+1)-e.X(l)*e.Y(l+1)},function(){l=Math.floor(d.position);for(h=0;h<q.objects.length;h++){e=q.objects[h];if(e.type==JXG.OBJECT_TYPE_CURVE){if(l<e.numberPoints){break}l-=e.numberPoints}}if(l==e.numberPoints-1){l--}if(l<0){return 0}return e.Y(l+1)-e.Y(l)},function(){l=Math.floor(d.position);for(h=0;h<q.objects.length;h++){e=q.objects[h];if(e.type==JXG.OBJECT_TYPE_CURVE){if(l<e.numberPoints){break}l-=e.numberPoints}}if(l==e.numberPoints-1){l--}if(l<0){return 0}return e.X(l)-e.X(l+1)}],k);d.addChild(u);u.glider=d}else{if(q.elementClass==JXG.OBJECT_CLASS_CIRCLE||q.type==JXG.OBJECT_TYPE_CONIC){u=o.create("line",[function(){return JXG.Math.matVecMult(q.quadraticform,d.coords.usrCoords)[0]},function(){return JXG.Math.matVecMult(q.quadraticform,d.coords.usrCoords)[1]},function(){return JXG.Math.matVecMult(q.quadraticform,d.coords.usrCoords)[2]}],k);d.addChild(u);u.glider=d}}}}return u};JXG.JSXGraph.registerElement("tangent",JXG.createTangent);JXG.JSXGraph.registerElement("polar",JXG.createTangent);JXG.Group=function(h,l,d){var j,g,e,k,f;this.board=h;this.objects={};j=this.board.numObjects;this.board.numObjects++;if((l=="")||!JXG.exists(l)){this.id=this.board.id+"Group"+j}else{this.id=l}this.board.groups[this.id]=this;this.type=JXG.OBJECT_TYPE_POINT;this.elementClass=JXG.OBJECT_CLASS_POINT;if((d=="")||!JXG.exists(d)){this.name="group_"+this.board.generateName(this)}else{this.name=d}delete (this.type);if((arguments.length==4)&&(JXG.isArray(arguments[3]))){g=arguments[3]}else{g=[];for(e=3;e<arguments.length;e++){g.push(arguments[e])}}for(e=0;e<g.length;e++){k=JXG.getReference(this.board,g[e]);if((!k.visProp.fixed)&&((k.type==JXG.OBJECT_TYPE_POINT)||(k.type==JXG.OBJECT_TYPE_GLIDER))){if(k.group.length!=0){this.addGroup(k.group[k.group.length-1])}else{this.addPoint(k)}}}for(f in this.objects){this.objects[f].group.push(this)}this.dX=0;this.dY=0};JXG.extend(JXG.Group.prototype,{ungroup:function(){var d;for(d in this.objects){if(this.objects[d].group[this.objects[d].group.length-1]==this){this.objects[d].group.pop()}delete (this.objects[d])}},update:function(d){var f=null,e;for(e in this.objects){f=this.objects[e];if(f.id!=d.id){f.coords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[f.coords.scrCoords[1]+this.dX,f.coords.scrCoords[2]+this.dY],f.board)}}for(e in this.objects){if(JXG.exists(this.board.objects[e])){this.objects[e].update(false)}else{delete (this.objects[e])}}return this},addPoint:function(d){this.objects[d.id]=d},addPoints:function(d){var e;for(e in d){this.objects[e.id]=e}},addGroup:function(e){var d;for(d in e.objects){this.addPoint(e.objects[d])}}});JXG.createGroup=function(f,e,d){return new JXG.Group(f,d.id,d.name,e)};JXG.JSXGraph.registerElement("group",JXG.createGroup);JXG.Circle=function(g,h,f,e,d){this.constructor(g,d,JXG.OBJECT_TYPE_CIRCLE,JXG.OBJECT_CLASS_CIRCLE);this.method=h;this.midpoint=JXG.getReference(this.board,f);this.point2=null;this.radius=0;this.line=null;this.circle=null;if(h=="twoPoints"){this.point2=JXG.getReference(g,e);this.radius=this.Radius()}else{if(h=="pointRadius"){this.generateTerm(e);this.updateRadius()}else{if(h=="pointLine"){this.line=JXG.getReference(g,e);this.radius=this.line.point1.coords.distance(JXG.COORDS_BY_USER,this.line.point2.coords)}else{if(h=="pointCircle"){this.circle=JXG.getReference(g,e);this.radius=this.circle.Radius()}}}}this.id=this.board.setId(this,"C");this.board.renderer.drawEllipse(this);this.board.finalizeAdding(this);this.createGradient();this.createLabel();this.midpoint.addChild(this);if(h=="pointRadius"){this.notifyParents(e)}else{if(h=="pointLine"){this.line.addChild(this)}else{if(h=="pointCircle"){this.circle.addChild(this)}else{if(h=="twoPoints"){this.point2.addChild(this)}}}}};JXG.Circle.prototype=new JXG.GeometryElement;JXG.extend(JXG.Circle.prototype,{hasPoint:function(d,j){var e=this.board.options.precision.hasPoint/(this.board.unitX),g=this.midpoint.coords.usrCoords,h=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d,j],this.board),f=this.Radius();var i=Math.sqrt((g[1]-h.usrCoords[1])*(g[1]-h.usrCoords[1])+(g[2]-h.usrCoords[2])*(g[2]-h.usrCoords[2]));return(Math.abs(i-f)<e)},generatePolynomial:function(j){var h=this.midpoint.symbolic.x;var g=this.midpoint.symbolic.y;var f=j.symbolic.x;var e=j.symbolic.y;var d=this.generateRadiusSquared();if(d==""){return[]}var i="(("+f+")-("+h+"))^2 + (("+e+")-("+g+"))^2 - ("+d+")";return[i]},generateRadiusSquared:function(){var e="";if(this.method=="twoPoints"){var g=this.midpoint.symbolic.x;var f=this.midpoint.symbolic.y;var i=this.point2.symbolic.x;var h=this.point2.symbolic.y;e="(("+i+")-("+g+"))^2 + (("+h+")-("+f+"))^2"}else{if(this.method=="pointRadius"){if(typeof(this.radius)=="number"){e=""+this.radius*this.radius}}else{if(this.method=="pointLine"){var i=this.line.point1.symbolic.x;var h=this.line.point1.symbolic.y;var d=this.line.point2.symbolic.x;var j=this.line.point2.symbolic.y;e="(("+i+")-("+d+"))^2 + (("+h+")-("+j+"))^2"}else{if(this.method=="pointCircle"){e=this.circle.Radius()}}}}return e},update:function(){if(this.needsUpdate){if(this.visProp.trace){this.cloneToBackground(true)}if(this.method=="pointLine"){this.radius=this.line.point1.coords.distance(JXG.COORDS_BY_USER,this.line.point2.coords)}else{if(this.method=="pointCircle"){this.radius=this.circle.Radius()}else{if(this.method=="pointRadius"){this.radius=this.updateRadius()}}}this.updateStdform();this.updateQuadraticform()}return this},updateQuadraticform:function(){var d=this.midpoint,g=d.X(),f=d.Y(),e=this.Radius();this.quadraticform=[[g*g+f*f-e*e,-g,-f],[-g,1,0],[-f,0,1]]},updateStdform:function(){this.stdform[3]=0.5;this.stdform[4]=this.Radius();this.stdform[1]=-this.midpoint.coords.usrCoords[1];this.stdform[2]=-this.midpoint.coords.usrCoords[2];this.normalize()},updateRenderer:function(){if(this.needsUpdate&&this.visProp.visible){var d=this.isReal;this.isReal=(isNaN(this.midpoint.coords.usrCoords[1]+this.midpoint.coords.usrCoords[2]+this.Radius()))?false:true;if(this.isReal){if(d!=this.isReal){this.board.renderer.show(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}this.board.renderer.updateEllipse(this)}else{if(d!=this.isReal){this.board.renderer.hide(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}}this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}},generateTerm:function(e){if(typeof e=="string"){var f=this.board.elementsByName;var d=JXG.GeonextParser.geonext2JS(e+"",this.board);this.updateRadius=new Function("return "+d+";")}else{if(typeof e=="number"){this.updateRadius=function(){return e}}else{this.updateRadius=e}}},notifyParents:function(e){var d=null;var f=this.board.elementsByName;if(typeof e=="string"){JXG.GeonextParser.findDependencies(this,e+"",this.board)}},Radius:function(){if(this.method=="twoPoints"){return(Math.sqrt(Math.pow(this.midpoint.coords.usrCoords[1]-this.point2.coords.usrCoords[1],2)+Math.pow(this.midpoint.coords.usrCoords[2]-this.point2.coords.usrCoords[2],2)))}else{if(this.method=="pointLine"||this.method=="pointCircle"){return this.radius}else{if(this.method=="pointRadius"){return this.updateRadius()}}}},getRadius:function(){return this.Radius()},getTextAnchor:function(){return this.midpoint.coords},getLabelAnchor:function(){if(this.method=="twoPoints"){var e=this.midpoint.coords.usrCoords[1]-this.point2.coords.usrCoords[1];var d=this.midpoint.coords.usrCoords[2]-this.point2.coords.usrCoords[2];return new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1]+e,this.midpoint.coords.usrCoords[2]+d],this.board)}else{if(this.method=="pointLine"||this.method=="pointCircle"||this.method=="pointRadius"){return new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1]-this.Radius(),this.midpoint.coords.usrCoords[2]],this.board)}}},cloneToBackground:function(d){var g={},e,f;g.id=this.id+"T"+this.numTraces;g.elementClass=JXG.OBJECT_CLASS_CIRCLE;this.numTraces++;g.midpoint={};g.midpoint.coords=this.midpoint.coords;e=this.Radius();g.Radius=function(){return e};g.getRadius=function(){return e};g.board=this.board;g.visProp=this.visProp;g.visProp.layer=this.board.options.layer.trace;JXG.clearVisPropOld(g);f=this.board.renderer.enhancedRendering;this.board.renderer.enhancedRendering=true;this.board.renderer.drawEllipse(g);this.board.renderer.enhancedRendering=f;this.traces[g.id]=g.rendNode},addTransform:function(d){var f;if(JXG.isArray(d)){f=d}else{f=[d]}for(var e=0;e<f.length;e++){this.midpoint.transformations.push(f[e]);if(this.method=="twoPoints"){this.point2.transformations.push(f[e])}}},setPosition:function(g,d,f){var e=this.board.create("transform",[d,f],{type:"translate"});this.addTransform(e);return this},setPositionDirectly:function(d,j,i,f,e){var l=j-f,k=i-e,h,g;if(!this.midpoint.draggable()){return this}if(this.method=="twoPoints"&&!this.point2.draggable()){return this}if(d==JXG.COORDS_BY_SCREEN){h=this.midpoint.coords.scrCoords[1]+l;g=this.midpoint.coords.scrCoords[2]+k}else{h=this.midpoint.coords.usrCoords[1]+l;g=this.midpoint.coords.usrCoords[2]+k}this.midpoint.setPositionDirectly(d,h,g);if(this.method=="twoPoints"){if(d==JXG.COORDS_BY_SCREEN){h=this.point2.coords.scrCoords[1]+l;g=this.point2.coords.scrCoords[2]+k}else{h=this.point2.coords.usrCoords[1]+l;g=this.point2.coords.usrCoords[2]+k}this.point2.setPositionDirectly(d,h,g)}this.update();return this},X:function(d){d*=2*Math.PI;return this.Radius()*Math.cos(d)+this.midpoint.coords.usrCoords[1]},Y:function(d){d*=2*Math.PI;return this.Radius()*Math.sin(d)+this.midpoint.coords.usrCoords[2]},minX:function(){return 0},maxX:function(){return 1},Area:function(){var d=this.Radius();return d*d*Math.PI},bounds:function(){var d=this.midpoint.coords.usrCoords,e=this.Radius();return[d[1]-e,d[2]+e,d[1]+e,d[2]-e]}});JXG.createCircle=function(k,f,e){var j,l,h,d,g=true;l=[];for(h=0;h<f.length;h++){if(JXG.isPoint(f[h])){l[h]=f[h]}else{if(f[h].length>1){d=JXG.copyAttributes(e,k.options,"circle","center");l[h]=k.create("point",f[h],d)}else{l[h]=f[h]}}}d=JXG.copyAttributes(e,k.options,"circle");if(f.length==2&&JXG.isPoint(l[0])&&JXG.isPoint(l[1])){j=new JXG.Circle(k,"twoPoints",l[0],l[1],d)}else{if((JXG.isNumber(l[0])||JXG.isFunction(l[0])||JXG.isString(l[0]))&&JXG.isPoint(l[1])){j=new JXG.Circle(k,"pointRadius",l[1],l[0],d)}else{if((JXG.isNumber(l[1])||JXG.isFunction(l[1])||JXG.isString(l[1]))&&JXG.isPoint(l[0])){j=new JXG.Circle(k,"pointRadius",l[0],l[1],d)}else{if((l[0].elementClass==JXG.OBJECT_CLASS_CIRCLE)&&JXG.isPoint(l[1])){j=new JXG.Circle(k,"pointCircle",l[1],l[0],d)}else{if((l[1].elementClass==JXG.OBJECT_CLASS_CIRCLE)&&JXG.isPoint(l[0])){j=new JXG.Circle(k,"pointCircle",l[0],l[1],d)}else{if((l[0].elementClass==JXG.OBJECT_CLASS_LINE)&&JXG.isPoint(l[1])){j=new JXG.Circle(k,"pointLine",l[1],l[0],d)}else{if((l[1].elementClass==JXG.OBJECT_CLASS_LINE)&&JXG.isPoint(l[0])){j=new JXG.Circle(k,"pointLine",l[0],l[1],d)}else{if(f.length==3&&JXG.isPoint(l[0])&&JXG.isPoint(l[1])&&JXG.isPoint(l[2])){j=JXG.createCircumcircle(k,l,e);j.midpoint.setProperty({visible:false});g=false}else{throw new Error("JSXGraph: Can't create circle with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"'.\nPossible parent types: [point,point], [point,number], [point,function], [point,circle], [point,point,point]")}}}}}}}}j.isDraggable=g;return j};JXG.JSXGraph.registerElement("circle",JXG.createCircle);JXG.createEllipse=function(n,p,h){var r=[],e,d,k,l,j=JXG.copyAttributes(h,n.options,"conic","foci"),m=JXG.copyAttributes(h,n.options,"conic");for(k=0;k<2;k++){if(p[k].length>1){r[k]=n.create("point",p[k],j)}else{if(JXG.isPoint(p[k])){r[k]=JXG.getReference(n,p[k])}else{if((typeof p[k]=="function")&&(p[k]().elementClass===JXG.OBJECT_CLASS_POINT)){r[k]=p[k]()}else{if(JXG.isString(p[k])){r[k]=JXG.getReference(n,p[k])}else{throw new Error("JSXGraph: Can't create Ellipse with parent types '"+(typeof p[0])+"' and '"+(typeof p[1])+"'.\nPossible parent types: [point,point,point], [point,point,number|function]")}}}}}if(JXG.isNumber(p[2])){d=JXG.createFunction(p[2],n)}else{if((typeof p[2]=="function")&&(JXG.isNumber(p[2]()))){d=p[2]}else{if(JXG.isPoint(p[2])){e=JXG.getReference(n,p[2])}else{if(p[2].length>1){e=n.create("point",p[2],j)}else{if((typeof p[2]=="function")&&(p[2]().elementClass==JXG.OBJECT_CLASS_POINT)){e=p[2]()}else{if(JXG.isString(p[2])){e=JXG.getReference(n,p[2])}else{throw new Error("JSXGraph: Can't create Ellipse with parent types '"+(typeof p[0])+"' and '"+(typeof p[1])+"' and '"+(typeof p[2])+"'.\nPossible parent types: [point,point,point], [point,point,number|function]")}}}}d=function(){return e.Dist(r[0])+e.Dist(r[1])}}}if(typeof p[4]=="undefined"){p[4]=1.0001*Math.PI}if(typeof p[3]=="undefined"){p[3]=-1.0001*Math.PI}var o=n.create("point",[function(){return(r[0].X()+r[1].X())*0.5},function(){return(r[0].Y()+r[1].Y())*0.5}],j);var q=function(){var i=r[0].X(),z=r[0].Y(),w=r[1].X(),v=r[1].Y(),y,x,u;var t=(w-i>0)?1:-1;if(Math.abs(w-i)>1e-7){y=Math.atan2(v-z,w-i)+((t<0)?Math.PI:0)}else{y=((v-z>0)?0.5:-0.5)*Math.PI}x=Math.cos(y);u=Math.sin(y);var s=[[1,0,0],[o.X(),x,-u],[o.Y(),u,x]];return s};var f=n.create("curve",[function(i){return 0},function(i){return 0},p[3],p[4]],m);var g=function(u,s){var y=d()*0.5,i=y*y,t=r[1].Dist(r[0])*0.5,v=i-t*t,x=Math.sqrt(v),w=[[1,0,0],[0,1,0],[0,0,1]],A,z;if(!s){l=q();A=o.X();z=o.Y();w[0][0]=l[0][0];w[0][1]=0;w[0][2]=0;w[1][0]=A*(1-l[1][1])+z*l[1][2];w[1][1]=l[1][1];w[1][2]=l[2][1];w[2][0]=z*(1-l[1][1])-A*l[1][2];w[2][1]=l[1][2];w[2][2]=l[2][2];f.quadraticform=JXG.Math.matMatMult(JXG.Math.transpose(w),JXG.Math.matMatMult([[-1+A*A/(y*y)+z*z/v,-A/i,-A/v],[-A/i,1/i,0],[-z/v,0,1/v]],w))}return JXG.Math.matVecMult(l,[1,y*Math.cos(u),x*Math.sin(u)])};f.X=function(i,s){return g(i,s)[1]};f.Y=function(i,s){return g(i,s)[2]};f.midpoint=o;f.type=JXG.OBJECT_TYPE_CONIC;return f};JXG.createHyperbola=function(n,p,h){var r=[],e,d,k,l,j=JXG.copyAttributes(h,n.options,"conic","foci"),m=JXG.copyAttributes(h,n.options,"conic");for(k=0;k<2;k++){if(p[k].length>1){r[k]=n.create("point",p[k],attr_focu)}else{if(JXG.isPoint(p[k])){r[k]=JXG.getReference(n,p[k])}else{if((typeof p[k]=="function")&&(p[k]().elementClass==JXG.OBJECT_CLASS_POINT)){r[k]=p[k]()}else{if(JXG.isString(p[k])){r[k]=JXG.getReference(n,p[k])}else{throw new Error("JSXGraph: Can't create Hyperbola with parent types '"+(typeof p[0])+"' and '"+(typeof p[1])+"'.\nPossible parent types: [point,point,point], [point,point,number|function]")}}}}}if(JXG.isNumber(p[2])){d=JXG.createFunction(p[2],n)}else{if((typeof p[2]=="function")&&(JXG.isNumber(p[2]()))){d=p[2]}else{if(JXG.isPoint(p[2])){e=JXG.getReference(n,p[2])}else{if(p[2].length>1){e=n.create("point",p[2],j)}else{if((typeof p[2]=="function")&&(p[2]().elementClass==JXG.OBJECT_CLASS_POINT)){e=p[2]()}else{if(JXG.isString(p[2])){e=JXG.getReference(n,p[2])}else{throw new Error("JSXGraph: Can't create Hyperbola with parent types '"+(typeof p[0])+"' and '"+(typeof p[1])+"' and '"+(typeof p[2])+"'.\nPossible parent types: [point,point,point], [point,point,number|function]")}}}}d=function(){return e.Dist(r[0])-e.Dist(r[1])}}}if(typeof p[4]=="undefined"){p[4]=1.0001*Math.PI}if(typeof p[3]=="undefined"){p[3]=-1.0001*Math.PI}var o=n.create("point",[function(){return(r[0].X()+r[1].X())*0.5},function(){return(r[0].Y()+r[1].Y())*0.5}],j);var q=function(){var t=r[0].X(),s=r[0].Y(),x=r[1].X(),v=r[1].Y(),u;var w=(x-t>0)?1:-1;if(Math.abs(x-t)>1e-7){u=Math.atan2(v-s,x-t)+((w<0)?Math.PI:0)}else{u=((v-s>0)?0.5:-0.5)*Math.PI}var i=[[1,0,0],[o.X(),Math.cos(u),-Math.sin(u)],[o.Y(),Math.sin(u),Math.cos(u)]];return i};var f=n.create("curve",[function(i){return 0},function(i){return 0},p[3],p[4]],m);var g=function(u,s){var y=d()*0.5,i=y*y,t=r[1].Dist(r[0])*0.5,x=Math.sqrt(-y*y+t*t),v=x*x,w=[[1,0,0],[0,1,0],[0,0,1]],A,z;if(!s){l=q();A=o.X();z=o.Y();w[0][0]=l[0][0];w[0][1]=0;w[0][2]=0;w[1][0]=A*(1-l[1][1])+z*l[1][2];w[1][1]=l[1][1];w[1][2]=l[2][1];w[2][0]=z*(1-l[1][1])-A*l[1][2];w[2][1]=l[1][2];w[2][2]=l[2][2];f.quadraticform=JXG.Math.matMatMult(JXG.Math.transpose(w),JXG.Math.matMatMult([[-1+A*A/i+z*z/v,-A/i,z/v],[-A/i,1/i,0],[z/v,0,-1/v]],w))}return JXG.Math.matVecMult(l,[1,y/Math.cos(u),x*Math.tan(u)])};f.X=function(i,s){return g(i,s)[1]};f.Y=function(i,s){return g(i,s)[2]};f.midpoint=o;f.type=JXG.OBJECT_TYPE_CONIC;return f};JXG.createParabola=function(m,o,g){var k=o[0],e=o[1],i,h=JXG.copyAttributes(g,m.options,"conic","foci"),j=JXG.copyAttributes(g,m.options,"conic");if(o[0].length>1){k=m.create("point",o[0],h)}else{if(JXG.isPoint(o[0])){k=JXG.getReference(m,o[0])}else{if((typeof o[0]=="function")&&(o[0]().elementClass==JXG.OBJECT_CLASS_POINT)){k=o[0]()}else{if(JXG.isString(o[0])){k=JXG.getReference(m,o[0])}else{throw new Error("JSXGraph: Can't create Parabola with parent types '"+(typeof o[0])+"' and '"+(typeof o[1])+"'.\nPossible parent types: [point,line]")}}}}if(typeof o[3]=="undefined"){o[3]=10}if(typeof o[2]=="undefined"){o[2]=-10}var n=m.create("point",[function(){var l=[0,e.stdform[1],e.stdform[2]];l=JXG.Math.crossProduct(l,k.coords.usrCoords);return JXG.Math.Geometry.meetLineLine(l,e.stdform,0,m).usrCoords}],h);var p=function(){var r=Math.atan(e.getSlope()),q=(n.X()+k.X())*0.5,s=(n.Y()+k.Y())*0.5;r+=(k.Y()-n.Y()<0||(k.Y()==n.Y()&&k.X()>n.X()))?Math.PI:0;var l=[[1,0,0],[q*(1-Math.cos(r))+s*Math.sin(r),Math.cos(r),-Math.sin(r)],[s*(1-Math.cos(r))-q*Math.sin(r),Math.sin(r),Math.cos(r)]];return l};var d=m.create("curve",[function(l){return 0},function(l){return 0},o[2],o[3]],j);var f=function(s,u){var v=n.Dist(k)*0.5,r=[[1,0,0],[0,1,0],[0,0,1]],q=(n.X()+k.X())*0.5,l=(n.Y()+k.Y())*0.5;if(!u){i=p();r[0][0]=i[0][0];r[0][1]=0;r[0][2]=0;r[1][0]=q*(1-i[1][1])+l*i[1][2];r[1][1]=i[1][1];r[1][2]=i[2][1];r[2][0]=l*(1-i[1][1])-q*i[1][2];r[2][1]=i[1][2];r[2][2]=i[2][2];d.quadraticform=JXG.Math.matMatMult(JXG.Math.transpose(r),JXG.Math.matMatMult([[-l*4*v-q*q,q,2*v],[q,-1,0],[2*v,0,0]],r))}return JXG.Math.matVecMult(i,[1,s+q,s*s/(v*4)+l])};d.X=function(l,q){return f(l,q)[1]};d.Y=function(l,q){return f(l,q)[2]};d.type=JXG.OBJECT_TYPE_CONIC;return d};JXG.createConic=function(e,w,g){var j=[[1,0,0],[0,1,0],[0,0,1]],B,z,y,x,f=[[1,0,0],[0,1,0],[0,0,1]],o,n,t=[],u,r,A,m=[],s=JXG.copyAttributes(g,e.options,"conic","foci"),q=JXG.copyAttributes(g,e.options,"conic");if(w.length==5){A=true}else{if(w.length==6){A=false}else{throw new Error("JSXGraph: Can't create generic Conic with "+parent.length+" parameters.")}}if(A){for(u=0;u<5;u++){if(w[u].length>1){t[u]=e.create("point",w[u],s)}else{if(JXG.isPoint(w[u])){t[u]=JXG.getReference(e,w[u])}else{if((typeof w[u]=="function")&&(w[u]().elementClass==JXG.OBJECT_CLASS_POINT)){t[u]=w[u]()}else{if(JXG.isString(w[u])){t[u]=JXG.getReference(e,w[u])}else{throw new Error("JSXGraph: Can't create Conic section with parent types '"+(typeof w[u])+"'.\nPossible parent types: [point,point,point,point,point], [a00,a11,a22,a01,a02,a12]")}}}}}}else{r=[[0,0,0],[0,0,0],[0,0,0]];r[0][0]=(JXG.isFunction(w[2]))?function(){return w[2]()}:function(){return w[2]};r[0][1]=(JXG.isFunction(w[4]))?function(){return w[4]()}:function(){return w[4]};r[0][2]=(JXG.isFunction(w[5]))?function(){return w[5]()}:function(){return w[5]};r[1][1]=(JXG.isFunction(w[0]))?function(){return w[0]()}:function(){return w[0]};r[1][2]=(JXG.isFunction(w[3]))?function(){return w[3]()}:function(){return w[3]};r[2][2]=(JXG.isFunction(w[1]))?function(){return w[1]()}:function(){return w[1]}}var h=function(p){var D,C;for(D=0;D<3;D++){for(C=D;C<3;C++){p[D][C]+=p[C][D]}}for(D=0;D<3;D++){for(C=0;C<D;C++){p[D][C]=p[C][D]}}return p};var l=function(C,p){var F,D,E=[[0,0,0],[0,0,0],[0,0,0]];for(F=0;F<3;F++){for(D=0;D<3;D++){E[F][D]=C[F]*p[D]}}return h(E)};var v=function(F,D,E){var I,J,C,K=[[0,0,0],[0,0,0],[0,0,0]],H,G;C=JXG.Math.matVecMult(D,E);I=JXG.Math.innerProduct(E,C);C=JXG.Math.matVecMult(F,E);J=JXG.Math.innerProduct(E,C);for(H=0;H<3;H++){for(G=0;G<3;G++){K[H][G]=I*F[H][G]-J*D[H][G]}}return K};var k=e.create("curve",[function(i){return 0},function(i){return 0},0,2*Math.PI],q);var d=function(F,G){var E,D,p,C;if(!G){if(A){for(E=0;E<5;E++){m[E]=t[E].coords.usrCoords}o=l(JXG.Math.crossProduct(m[0],m[1]),JXG.Math.crossProduct(m[2],m[3]));n=l(JXG.Math.crossProduct(m[0],m[2]),JXG.Math.crossProduct(m[1],m[3]));f=v(o,n,m[4])}else{for(E=0;E<3;E++){for(D=E;D<3;D++){f[E][D]=r[E][D]();if(D>E){f[D][E]=f[E][D]}}}}k.quadraticform=f;B=JXG.Math.Numerics.Jacobi(f);if(B[0][0][0]<0){B[0][0][0]*=(-1);B[0][1][1]*=(-1);B[0][2][2]*=(-1)}for(E=0;E<3;E++){p=0;for(D=0;D<3;D++){p+=B[1][D][E]*B[1][D][E]}p=Math.sqrt(p);for(D=0;D<3;D++){}}j=B[1];x=Math.sqrt(Math.abs(B[0][0][0]));z=Math.sqrt(Math.abs(B[0][1][1]));y=Math.sqrt(Math.abs(B[0][2][2]))}if(B[0][1][1]<=0&&B[0][2][2]<=0){C=JXG.Math.matVecMult(j,[1/x,Math.cos(F)/z,Math.sin(F)/y])}else{if(B[0][1][1]<=0&&B[0][2][2]>0){C=JXG.Math.matVecMult(j,[Math.cos(F)/x,1/z,Math.sin(F)/y])}else{if(B[0][2][2]<0){C=JXG.Math.matVecMult(j,[Math.sin(F)/x,Math.cos(F)/z,1/y])}}}C[1]/=C[0];C[2]/=C[0];C[0]=1;return C};k.X=function(i,p){return d(i,p)[1]};k.Y=function(i,p){return d(i,p)[2]};k.midpoint=e.create("point",[function(){var i=k.quadraticform;return[i[1][1]*i[2][2]-i[1][2]*i[1][2],i[1][2]*i[0][2]-i[2][2]*i[0][1],i[0][1]*i[1][2]-i[1][1]*i[0][2]]}],s);k.type=JXG.OBJECT_TYPE_CONIC;return k};JXG.JSXGraph.registerElement("ellipse",JXG.createEllipse);JXG.JSXGraph.registerElement("hyperbola",JXG.createHyperbola);JXG.JSXGraph.registerElement("parabola",JXG.createParabola);JXG.JSXGraph.registerElement("conic",JXG.createConic);JXG.Polygon=function(h,f,e){this.constructor(h,e,JXG.OBJECT_TYPE_POLYGON,JXG.OBJECT_CLASS_AREA);var g,k,d,j=JXG.copyAttributes(e,h.options,"polygon","lines");this.withLines=e.withlines;this.vertices=[];for(g=0;g<f.length;g++){k=JXG.getRef(this.board,f[g]);this.vertices[g]=k}if(this.vertices[this.vertices.length-1]!=this.vertices[0]){this.vertices.push(this.vertices[0])}this.borders=[];if(this.withLines){for(g=0;g<this.vertices.length-1;g++){j.id=j.ids&&j.ids[g];j.strokecolor=JXG.isArray(j.colors)&&j.colors[g%j.colors.length]||j.strokecolor;if(j.strokecolor===false){j.strokecolor="none"}d=JXG.createSegment(h,[this.vertices[g],this.vertices[g+1]],j);this.borders[g]=d;d.parentPolygon=this}}for(g=0;g<this.vertices.length-1;g++){k=JXG.getReference(this.board,this.vertices[g]);k.addChild(this)}this.createLabel([0,0]);this.id=this.board.setId(this,"Py");this.board.renderer.drawPolygon(this);this.board.finalizeAdding(this)};JXG.Polygon.prototype=new JXG.GeometryElement;JXG.extend(JXG.Polygon.prototype,{hasPoint:function(d,h){var f,e,g=false;for(f=0,e=this.vertices.length-2;f<this.vertices.length-1;e=f++){if(((this.vertices[f].coords.scrCoords[2]>h)!=(this.vertices[e].coords.scrCoords[2]>h))&&(d<(this.vertices[e].coords.scrCoords[1]-this.vertices[f].coords.scrCoords[1])*(h-this.vertices[f].coords.scrCoords[2])/(this.vertices[e].coords.scrCoords[2]-this.vertices[f].coords.scrCoords[2])+this.vertices[f].coords.scrCoords[1])){g=!g}}return g},updateRenderer:function(){if(this.needsUpdate){this.board.renderer.updatePolygon(this);this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible){this.label.content.update();this.board.renderer.updateText(this.label.content)}},getTextAnchor:function(){var f=this.vertices[0].X(),e=this.vertices[0].Y(),d=f,h=e,g;for(g=0;g<this.vertices.length;g++){if(this.vertices[g].X()<f){f=this.vertices[g].X()}if(this.vertices[g].X()>d){d=this.vertices[g].X()}if(this.vertices[g].Y()>e){e=this.vertices[g].Y()}if(this.vertices[g].Y()<h){h=this.vertices[g].Y()}}return new JXG.Coords(JXG.COORDS_BY_USER,[(f+d)*0.5,(e+h)*0.5],this.board)},getLabelAnchor:JXG.shortcut(JXG.Polygon.prototype,"getTextAnchor"),cloneToBackground:function(){var e={},d;e.id=this.id+"T"+this.numTraces;this.numTraces++;e.vertices=this.vertices;e.visProp=this.visProp;e.visProp.layer=this.board.options.layer.trace;e.board=this.board;JXG.clearVisPropOld(e);d=this.board.renderer.enhancedRendering;this.board.renderer.enhancedRendering=true;this.board.renderer.drawPolygon(e);this.board.renderer.enhancedRendering=d;this.traces[e.id]=e.rendNode},hideElement:function(){var d;this.visProp.visible=false;this.board.renderer.hide(this);for(d=0;d<this.borders.length;d++){this.borders[d].hideElement()}if(this.hasLabel&&JXG.exists(this.label)){this.label.hiddenByParent=true;if(this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}},showElement:function(){var d;this.visProp.visible=true;this.board.renderer.show(this);for(d=0;d<this.borders.length;d++){this.borders[d].showElement()}if(this.hasLabel&&JXG.exists(this.label)){if(this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}},Area:function(){var e=0,d;for(d=0;d<this.vertices.length-1;d++){e+=(this.vertices[d].X()*this.vertices[d+1].Y()-this.vertices[d+1].X()*this.vertices[d].Y())}e/=2;return Math.abs(e)},remove:function(){var d;for(d=0;d<this.borders.length;d++){this.borders[d].remove()}this.board.renderer.remove(this.rendNode)}});JXG.createPolygon=function(j,f,e){var h,g,d=JXG.copyAttributes(e,j.options,"polygon");for(g=0;g<f.length;g++){f[g]=JXG.getReference(j,f[g]);if(!JXG.isPoint(f[g])){throw new Error("JSXGraph: Can't create polygon with parent types other than 'point'.")}}h=new JXG.Polygon(j,f,d);return h};JXG.createRegularPolygon=function(m,r,h){var f,j,g,d=[],e,q,k,o,l;if(JXG.isNumber(r[r.length-1])&&r.length!=3){throw new Error("JSXGraph: A regular polygon needs two point and a number as input.")}k=r.length;g=r[k-1];if((!JXG.isNumber(g)&&!JXG.isPoint(JXG.getReference(m,g)))||g<3){throw new Error("JSXGraph: The third parameter has to be number greater than 2 or a point.")}if(JXG.isPoint(JXG.getReference(m,g))){g=k;o=true}else{k--;o=false}for(j=0;j<k;j++){r[j]=JXG.getReference(m,r[j]);if(!JXG.isPoint(r[j])){throw new Error("JSXGraph: Can't create regular polygon if the first two parameters aren't points.")}}d[0]=r[0];d[1]=r[1];l=JXG.copyAttributes(h,m.options,"polygon","points");for(j=2;j<g;j++){e=m.create("transform",[Math.PI*(2-(g-2)/g),d[j-1]],{type:"rotate"});if(o){d[j]=r[j];d[j].addTransform(r[j-2],e)}else{d[j]=m.create("point",[d[j-2],e],l)}}l=JXG.copyAttributes(h,m.options,"polygon");f=m.create("polygon",d,l);return f};JXG.JSXGraph.registerElement("polygon",JXG.createPolygon);JXG.JSXGraph.registerElement("regularpolygon",JXG.createRegularPolygon);JXG.Curve=function(f,e,d){this.constructor(f,d,JXG.OBJECT_TYPE_CURVE,JXG.OBJECT_CLASS_CURVE);this.points=[];this.doAdvancedPlot=d.doadvancedplot;this.numberPointsHigh=d.numberpointshigh;this.numberPointsLow=d.numberpointslow;this.numberPoints=this.numberPointsHigh;this.dataX=null;this.dataY=null;if(e[0]!=null){this.varname=e[0]}else{this.varname="x"}this.xterm=e[1];this.yterm=e[2];this.generateTerm(this.varname,this.xterm,this.yterm,e[3],e[4]);this.updateCurve();this.id=this.board.setId(this,"G");this.board.renderer.drawCurve(this);this.board.finalizeAdding(this);this.createGradient();this.createLabel();if(typeof this.xterm=="string"){this.notifyParents(this.xterm)}if(typeof this.yterm=="string"){this.notifyParents(this.yterm)}};JXG.Curve.prototype=new JXG.GeometryElement;JXG.extend(JXG.Curve.prototype,{minX:function(){if(this.visProp.curvetype=="polar"){return 0}else{var d=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board);return d.usrCoords[1]}},maxX:function(){var d;if(this.visProp.curvetype=="polar"){return 2*Math.PI}else{d=new JXG.Coords(JXG.COORDS_BY_SCREEN,[this.board.canvasWidth,0],this.board);return d.usrCoords[1]}},hasPoint:function(r,q){var s,A=Infinity,I,m,C,B,v,u,w,f,J,z,o,G,l,F,h,n,p,E=this.numberPointsLow,H=(this.maxX()-this.minX())/E,e=this.board.options.precision.hasPoint/this.board.unitX,g,D,k=true;e=e*e;g=new JXG.Coords(JXG.COORDS_BY_SCREEN,[r,q],this.board);r=g.usrCoords[1];q=g.usrCoords[2];if(this.visProp.curvetype=="parameter"||this.visProp.curvetype=="polar"||this.visProp.curvetype=="functiongraph"){D=this.transformations.length;for(C=0,s=this.minX();C<E;C++){v=this.X(s,k);u=this.Y(s,k);for(B=0;B<D;B++){m=this.transformations[B];m.update();I=JXG.Math.matVecMult(m.matrix,[1,v,u]);v=I[1];u=I[2]}A=(r-v)*(r-v)+(q-u)*(q-u);if(A<e){return true}s+=H}}else{if(this.visProp.curvetype=="plot"){D=this.numberPoints;for(C=0;C<D-1;C++){w=this.X(C);f=this.X(C+1);J=this.Y(C);z=this.Y(C+1);F=f-w;h=z-J;G=r-w;l=q-J;p=F*F+h*h;if(p>=JXG.Math.eps){n=G*F+l*h;o=n/p;A=G*G+l*l-o*n}else{o=0;A=G*G+l*l}if(o>=0&&o<=1&&A<e){return true}}return false}}return(A<e)},allocatePoints:function(){var e,d;d=this.numberPoints;if(this.points.length<this.numberPoints){for(e=this.points.length;e<d;e++){this.points[e]=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)}}},update:function(){if(this.needsUpdate){if(this.visProp.trace){this.cloneToBackground(true)}this.updateCurve()}return this},updateRenderer:function(){if(this.needsUpdate){this.board.renderer.updateCurve(this);this.needsUpdate=false;if(this.hasLabel&&this.label.content.visProp.visible){this.label.content.update();this.board.renderer.updateText(this.label.content)}}return this},updateDataArray:function(){return this},updateCurve:function(){var e,f,k,d,j,g,h=false;this.updateDataArray();f=this.minX();k=this.maxX();if(this.dataX!=null){this.numberPoints=this.dataX.length;e=this.numberPoints;this.allocatePoints();for(g=0;g<e;g++){d=g;if(this.dataY!=null){j=g}else{j=this.X(d)}this.points[g].setCoordinates(JXG.COORDS_BY_USER,[this.X(d,h),this.Y(j,h)],false);this.updateTransform(this.points[g]);h=true}}else{if(this.doAdvancedPlot){this.updateParametricCurve(f,k,e)}else{if(this.board.updateQuality==this.board.BOARD_QUALITY_HIGH){this.numberPoints=this.numberPointsHigh}else{this.numberPoints=this.numberPointsLow}e=this.numberPoints;this.allocatePoints();this.updateParametricCurveNaive(f,k,e)}}return this},updateParametricCurveNaive:function(f,k,e){var h,g,j=false,d=(k-f)/e;for(h=0;h<e;h++){g=f+h*d;this.points[h].setCoordinates(JXG.COORDS_BY_USER,[this.X(g,j),this.Y(g,j)],false);this.updateTransform(this.points[h]);j=true}return this},updateParametricCurve:function(E,e){var v,p,o,g=false,z=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board),n,m,B,f,q,G,F,s,k,w=[],h=[],D=[],A=[],r=false,u=0,C,l=function(K,J,L){var t=L[1]-K[1],I=L[2]-K[2],j=J[0]-K[1],y=J[1]-K[2],H=j*j+y*y,i,x;if(H>=JXG.Math.eps){i=(t*j+I*y)/H;if(i>0){if(i<=1){t-=i*j;I-=i*y}else{t-=j;I-=y}}}x=t*t+I*I;return Math.sqrt(x)};if(this.board.updateQuality==this.board.BOARD_QUALITY_LOW){F=15;s=10;k=10}else{F=21;s=0.7;k=0.7}A[0]=e-E;for(v=1;v<F;v++){A[v]=A[v-1]*0.5}v=1;w[0]=1;h[0]=0;p=E;z.setCoordinates(JXG.COORDS_BY_USER,[this.X(p,g),this.Y(p,g)],false);g=true;B=z.scrCoords[1];f=z.scrCoords[2];o=p;p=e;z.setCoordinates(JXG.COORDS_BY_USER,[this.X(p,g),this.Y(p,g)],false);n=z.scrCoords[1];m=z.scrCoords[2];D[0]=[n,m];q=1;G=0;this.points=[];this.points[u++]=new JXG.Coords(JXG.COORDS_BY_SCREEN,[B,f],this.board);do{r=this.isDistOK(n-B,m-f,s,k)||this.isSegmentOutside(B,f,n,m);while(G<F&&(!r||G<3)&&(this.isSegmentDefined(B,f,n,m)||G<=7)){w[q]=v;h[q]=G;D[q]=[n,m];q++;v=2*v-1;G++;p=E+v*A[G];z.setCoordinates(JXG.COORDS_BY_USER,[this.X(p,g),this.Y(p,g)],false);n=z.scrCoords[1];m=z.scrCoords[2];r=this.isDistOK(n-B,m-f,s,k)||this.isSegmentOutside(B,f,n,m)}if(u>1){C=l(this.points[u-2].scrCoords,[n,m],this.points[u-1].scrCoords);if(C<0.015){u--}}this.points[u]=new JXG.Coords(JXG.COORDS_BY_SCREEN,[n,m],this.board);this.updateTransform(this.points[u]);u++;B=n;f=m;o=p;q--;n=D[q][0];m=D[q][1];G=h[q]+1;v=w[q]*2}while(q>0&&u<500000);this.numberPoints=this.points.length;return this},isSegmentOutside:function(e,g,d,f){if(g<0&&f<0){return true}else{if(g>this.board.canvasHeight&&f>this.board.canvasHeight){return true}else{if(e<0&&d<0){return true}else{if(e>this.board.canvasWidth&&d>this.board.canvasWidth){return true}}}}return false},isDistOK:function(f,d,g,e){if(isNaN(f+d)){return false}return(Math.abs(f)<e&&Math.abs(d)<e)},isSegmentDefined:function(e,g,d,f){return !(isNaN(e+g)&&isNaN(d+f))},updateTransform:function(g){var f,h,e,d=this.transformations.length;if(d==0){return g}for(e=0;e<d;e++){f=this.transformations[e];f.update();h=JXG.Math.matVecMult(f.matrix,g.usrCoords);g.setCoordinates(JXG.COORDS_BY_USER,[h[1],h[2]])}return g},addTransform:function(e){var g,f,d;g=JXG.isArray(e)?e:[e];d=g.length;for(f=0;f<d;f++){this.transformations.push(g[f])}return this},setPosition:function(g,d,f){var e=this.board.create("transform",[d,f],{type:"translate"});if(this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix){this.transformations[this.transformations.length-1].melt(e)}else{this.addTransform(e)}return this},generateTerm:function(e,i,f,d,j){var h,g;if(JXG.isArray(i)){this.dataX=i;this.X=function(m){var l=parseInt(Math.floor(m)),k,n;if(m<0){l=0}else{if(m>this.dataX.length-2){l=this.dataX.length-2}}if(l==m){return this.dataX[l]}else{k=this.dataX[l];n=this.dataX[l+1];return k+(n-k)*(m-l)}};this.visProp.curvetype="plot";this.numberPoints=this.dataX.length}else{this.X=JXG.createFunction(i,this.board,e);if(JXG.isString(i)){this.visProp.curvetype="functiongraph"}else{if(JXG.isFunction(i)||JXG.isNumber(i)){this.visProp.curvetype="parameter"}}}if(JXG.isArray(f)){this.dataY=f;this.Y=function(m){var l=parseInt(Math.floor(m)),k,n;if(m<0){l=0}else{if(m>this.dataY.length-2){l=this.dataY.length-2}}if(l==m){if(JXG.isFunction(this.dataY[l])){return this.dataY[l]()}else{return this.dataY[l]}}else{if(JXG.isFunction(this.dataY[l])){k=this.dataY[l]()}else{k=this.dataY[l]}if(JXG.isFunction(this.dataY[l+1])){n=this.dataY[l+1]()}else{n=this.dataY[l+1]}return k+(n-k)*(m-l)}}}else{this.Y=JXG.createFunction(f,this.board,e)}if(JXG.isFunction(i)&&JXG.isArray(f)){h=JXG.createFunction(f[0],this.board,"");g=JXG.createFunction(f[1],this.board,"");this.X=function(k){return(i)(k)*Math.cos(k)+h()};this.Y=function(k){return(i)(k)*Math.sin(k)+g()};this.visProp.curvetype="polar"}if(d!=null){this.minX=JXG.createFunction(d,this.board,"")}if(j!=null){this.maxX=JXG.createFunction(j,this.board,"")}},notifyParents:function(d){JXG.GeonextParser.findDependencies(this,d,this.board)},getLabelAnchor:function(){var d=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,this.board.canvasHeight*0.5],this.board);d=JXG.Math.Geometry.projectCoordsToCurve(d.usrCoords[1],d.usrCoords[2],0,this,this.board)[0];return d},cloneToBackground:function(){var e={},d;e.id=this.id+"T"+this.numTraces;e.elementClass=JXG.OBJECT_CLASS_CURVE;this.numTraces++;e.points=this.points.slice(0);e.numberPoints=this.numberPoints;e.board=this.board;e.visProp=this.visProp;e.visProp.layer=this.board.options.layer.trace;e.visProp.curvetype=this.visProp.curvetype;JXG.clearVisPropOld(e);d=this.board.renderer.enhancedRendering;this.board.renderer.enhancedRendering=true;this.board.renderer.drawCurve(e);this.board.renderer.enhancedRendering=d;this.traces[e.id]=e.rendNode},bounds:function(){var m=this.numberPointsLow,k=(this.maxX()-this.minX())/m,f,e,q,p,l,h,o,n,g=[this.minX(),0,this.maxX(),0];if(this.visProp.curvetype=="parameter"||this.visProp.curvetype=="polar"||this.visProp.curvetype=="functiongraph"){h=this.transformations.length;p=this.minX();for(f=0;f<m;f++){o=this.X(p,true);n=this.Y(p,true);for(e=0;e<h;e++){q=this.transformations[e];q.update();l=JXG.Math.matVecMult(q.matrix,[1,o,n]);o=l[1];n=l[2]}if(g[1]<n){g[1]=n}if(g[3]>n){g[3]=n}p+=k}}else{if(this.visProp.curvetype=="plot"){h=this.numberPoints;for(f=0;f<h;f++){n=this.Y(f);if(g[1]<n){g[1]=n}if(g[3]>n){g[3]=n}}}}return g}});JXG.createCurve=function(g,f,e){var d=JXG.copyAttributes(e,g.options,"curve");return new JXG.Curve(g,["x"].concat(f),d)};JXG.JSXGraph.registerElement("curve",JXG.createCurve);JXG.createFunctiongraph=function(h,f,e){var d,g=["x","x"].concat(f);d=JXG.copyAttributes(e,h.options,"curve");d.curvetype="functiongraph";return new JXG.Curve(h,g,d)};JXG.JSXGraph.registerElement("functiongraph",JXG.createFunctiongraph);JXG.JSXGraph.registerElement("plot",JXG.createFunctiongraph);JXG.createSpline=function(f,e,d){var g;g=function(){var j,h=[],k=[];var i=function(o,n){var m,l;if(!n){h=[];k=[];if(e.length==2&&JXG.isArray(e[0])&&JXG.isArray(e[1])&&e[0].length==e[1].length){for(m=0;m<e[0].length;m++){if(typeof e[0][m]=="function"){h.push(e[0][m]())}else{h.push(e[0][m])}if(typeof e[1][m]=="function"){k.push(e[1][m]())}else{k.push(e[1][m])}}}else{for(m=0;m<e.length;m++){if(JXG.isPoint(e[m])){h.push(e[m].X());k.push(e[m].Y())}else{if(JXG.isArray(e[m])&&e[m].length==2){for(m=0;m<e.length;m++){if(typeof e[m][0]=="function"){h.push(e[m][0]())}else{h.push(e[m][0])}if(typeof e[m][1]=="function"){k.push(e[m][1]())}else{k.push(e[m][1])}}}}}}j=JXG.Math.Numerics.splineDef(h,k)}return JXG.Math.Numerics.splineEval(o,h,k,j)};return i};return f.create("curve",["x",g()],d)};JXG.JSXGraph.registerElement("spline",JXG.createSpline);JXG.createRiemannsum=function(i,m,e){var d,l,g,j,k,h;h=JXG.copyAttributes(e,i.options,"riemannsum");h.curvetype="plot";g=m[0];d=JXG.createFunction(m[1],i,"");if(d==null){throw new Error("JSXGraph: JXG.createRiemannsum: argument '2' n has to be number or function.\nPossible parent types: [function,n:number|function,type,start:number|function,end:number|function]")}l=JXG.createFunction(m[2],i,"",false);if(l==null){throw new Error("JSXGraph: JXG.createRiemannsum: argument 3 'type' has to be string or function.\nPossible parent types: [function,n:number|function,type,start:number|function,end:number|function]")}j=[[0],[0]].concat(m.slice(3));k=i.create("curve",j,h);k.updateDataArray=function(){var f=JXG.Math.Numerics.riemann(g,d(),l(),this.minX(),this.maxX());this.dataX=f[0];this.dataY=f[1]};return k};JXG.JSXGraph.registerElement("riemannsum",JXG.createRiemannsum);JXG.createArc=function(h,f,e){var g,d;if(!(f=JXG.checkParents("arc",f,[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT],[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]))){throw new Error("JSXGraph: Can't create Arc with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"' and '"+(typeof f[2])+"'.\nPossible parent types: [point,point,point]")}d=JXG.copyAttributes(e,h.options,"arc");g=h.create("curve",[[0],[0]],d);g.type=JXG.OBJECT_TYPE_ARC;g.midpoint=JXG.getReference(h,f[0]);g.radiuspoint=JXG.getReference(h,f[1]);g.point2=g.radiuspoint;g.anglepoint=JXG.getReference(h,f[2]);g.point3=g.anglepoint;g.midpoint.addChild(g);g.radiuspoint.addChild(g);g.anglepoint.addChild(g);g.useDirection=d.usedirection;g.updateDataArray=function(){var u=this.radiuspoint,t=this.midpoint,s=this.anglepoint,F,m,H,z,j=JXG.Math.Geometry.rad(u,t,s),D,w=Math.ceil(j/Math.PI*90)+1,G=j/w,p=t.X(),o=t.Y(),q,l,k,r,E;if(this.useDirection){k=f[1].coords.usrCoords;r=f[3].coords.usrCoords;E=f[2].coords.usrCoords;l=(k[1]-E[1])*(k[2]-r[2])-(k[2]-E[2])*(k[1]-r[1]);if(l<0){this.radiuspoint=f[1];this.anglepoint=f[2]}else{this.radiuspoint=f[2];this.anglepoint=f[1]}}this.dataX=[u.X()];this.dataY=[u.Y()];for(F=G,D=1;D<=w;D++,F+=G){m=Math.cos(F);H=Math.sin(F);z=[[1,0,0],[p*(1-m)+o*H,m,-H],[o*(1-m)-p*H,H,m]];q=JXG.Math.matVecMult(z,u.coords.usrCoords);this.dataX.push(q[1]/q[0]);this.dataY.push(q[2]/q[0])}this.updateStdform();this.updateQuadraticform()};g.Radius=function(){return this.radiuspoint.Dist(this.midpoint)};g.getRadius=function(){return this.Radius()};g.hasPoint=function(i,p){var k=this.board.options.precision.hasPoint/(this.board.unitX),o=new JXG.Coords(JXG.COORDS_BY_SCREEN,[i,p],this.board),l=this.Radius(),n=this.midpoint.coords.distance(JXG.COORDS_BY_USER,o),j=(Math.abs(n-l)<k),m;if(j){m=JXG.Math.Geometry.rad(this.radiuspoint,this.midpoint,o.usrCoords.slice(1));if(m>JXG.Math.Geometry.rad(this.radiuspoint,this.midpoint,this.anglepoint)){j=false}}return j};g.hasPointSector=function(i,o){var n=new JXG.Coords(JXG.COORDS_BY_SCREEN,[i,o],this.board),k=this.Radius(),m=this.midpoint.coords.distance(JXG.COORDS_BY_USER,n),j=(m<k),l;if(j){l=JXG.Math.Geometry.rad(this.radiuspoint,this.midpoint,n.usrCoords.slice(1));if(l>JXG.Math.Geometry.rad(this.radiuspoint,this.midpoint,this.anglepoint)){j=false}}return j};g.getTextAnchor=function(){return this.midpoint.coords};g.getLabelAnchor=function(){var k=JXG.Math.Geometry.rad(this.radiuspoint,this.midpoint,this.anglepoint),s=10/(this.board.unitX),q=10/(this.board.unitY),o=this.point2.coords.usrCoords,i=this.midpoint.coords.usrCoords,j=o[1]-i[1],r=o[2]-i[2],p,m,l,n;if(this.label.content!=null){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board)}p=new JXG.Coords(JXG.COORDS_BY_USER,[i[1]+Math.cos(k*0.5)*j-Math.sin(k*0.5)*r,i[2]+Math.sin(k*0.5)*j+Math.cos(k*0.5)*r],this.board);m=p.usrCoords[1]-i[1];l=p.usrCoords[2]-i[2];n=Math.sqrt(m*m+l*l);m=m*(n+s)/n;l=l*(n+q)/n;return new JXG.Coords(JXG.COORDS_BY_USER,[i[1]+m,i[2]+l],this.board)};g.updateQuadraticform=function(){var i=this.midpoint,l=i.X(),k=i.Y(),j=this.Radius();this.quadraticform=[[l*l+k*k-j*j,-l,-k],[-l,1,0],[-k,0,1]]};g.updateStdform=function(){this.stdform[3]=0.5;this.stdform[4]=this.Radius();this.stdform[1]=-this.midpoint.coords.usrCoords[1];this.stdform[2]=-this.midpoint.coords.usrCoords[2];this.normalize()};g.prepareUpdate().update();return g};JXG.JSXGraph.registerElement("arc",JXG.createArc);JXG.createSemicircle=function(h,f,e){var g,i,d;if((JXG.isPoint(f[0]))&&(JXG.isPoint(f[1]))){d=JXG.copyAttributes(e,h.options,"circle","center");i=h.create("midpoint",[f[0],f[1]],d);d=JXG.copyAttributes(e,h.options,"circle");g=h.create("arc",[i,f[1],f[0]],d);g.midpoint=i}else{throw new Error("JSXGraph: Can't create Semicircle with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"'.\nPossible parent types: [point,point]")}return g};JXG.JSXGraph.registerElement("semicircle",JXG.createSemicircle);JXG.createCircumcircleArc=function(h,f,e){var g,i,d;if((JXG.isPoint(f[0]))&&(JXG.isPoint(f[1]))&&(JXG.isPoint(f[2]))){d=JXG.copyAttributes(e,h.options,"arc","center");i=h.create("circumcirclemidpoint",[f[0],f[1],f[2]],d);d=JXG.copyAttributes(e,h.options,"arc");d.usedirection=true;g=h.create("arc",[i,f[0],f[2],f[1]],d);g.midpoint=i}else{throw new Error("JSXGraph: create Circumcircle Arc with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"' and '"+(typeof f[2])+"'.\nPossible parent types: [point,point,point]")}return g};JXG.JSXGraph.registerElement("circumcirclearc",JXG.createCircumcircleArc);JXG.createSector=function(h,f,e){var g,d;if(!(JXG.isPoint(f[0])&&JXG.isPoint(f[1])&&JXG.isPoint(f[2]))){throw new Error("JSXGraph: Can't create Sector with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"' and '"+(typeof f[2])+"'.")}d=JXG.copyAttributes(e,h.options,"sector");g=h.create("curve",[[0],[0]],d);g.type=JXG.OBJECT_TYPE_SECTOR;g.point1=JXG.getReference(h,f[0]);g.point2=JXG.getReference(h,f[1]);g.point3=JXG.getReference(h,f[2]);g.point1.addChild(g);g.point2.addChild(g);g.point3.addChild(g);g.useDirection=e.usedirection;g.updateDataArray=function(){var u=this.point2,t=this.point1,s=this.point3,F,m,H,z,j=JXG.Math.Geometry.rad(u,t,s),D,w=Math.ceil(j/Math.PI*90)+1,G=j/w,p=t.X(),o=t.Y(),q,l,k,r,E;if(this.useDirection){k=f[1].coords.usrCoords,r=f[3].coords.usrCoords,E=f[2].coords.usrCoords;l=(k[1]-E[1])*(k[2]-r[2])-(k[2]-E[2])*(k[1]-r[1]);if(l<0){this.point2=f[1];this.point3=f[2]}else{this.point2=f[2];this.point3=f[1]}}this.dataX=[t.X(),u.X()];this.dataY=[t.Y(),u.Y()];for(F=G,D=1;D<=w;D++,F+=G){m=Math.cos(F);H=Math.sin(F);z=[[1,0,0],[p*(1-m)+o*H,m,-H],[o*(1-m)-p*H,H,m]];q=JXG.Math.matVecMult(z,u.coords.usrCoords);this.dataX.push(q[1]/q[0]);this.dataY.push(q[2]/q[0])}this.dataX.push(t.X());this.dataY.push(t.Y())};g.Radius=function(){return this.point2.Dist(this.point1)};g.getRadius=function(){return this.Radius()};g.hasPointSector=function(i,o){var n=new JXG.Coords(JXG.COORDS_BY_SCREEN,[i,o],this.board),k=this.Radius(),m=this.point1.coords.distance(JXG.COORDS_BY_USER,n),j=(m<k),l;if(j){l=JXG.Math.Geometry.rad(this.point2,this.point1,n.usrCoords.slice(1));if(l>JXG.Math.Geometry.rad(this.point2,this.point1,this.point3)){j=false}}return j};g.getTextAnchor=function(){return this.point1.coords};g.getLabelAnchor=function(){var k=JXG.Math.Geometry.rad(this.point2,this.point1,this.point3),s=10/(this.board.unitX),q=10/(this.board.unitY),o=this.point2.coords.usrCoords,i=this.point1.coords.usrCoords,j=o[1]-i[1],r=o[2]-i[2],p,m,l,n;if(this.label.content!=null){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board)}p=new JXG.Coords(JXG.COORDS_BY_USER,[i[1]+Math.cos(k*0.5)*j-Math.sin(k*0.5)*r,i[2]+Math.sin(k*0.5)*j+Math.cos(k*0.5)*r],this.board);m=p.usrCoords[1]-i[1];l=p.usrCoords[2]-i[2];n=Math.sqrt(m*m+l*l);m=m*(n+s)/n;l=l*(n+q)/n;return new JXG.Coords(JXG.COORDS_BY_USER,[i[1]+m,i[2]+l],this.board)};g.prepareUpdate().update();return g};JXG.JSXGraph.registerElement("sector",JXG.createSector);JXG.createCircumcircleSector=function(h,f,e){var g,i,d;if((JXG.isPoint(f[0]))&&(JXG.isPoint(f[1]))&&(JXG.isPoint(f[2]))){d=JXG.copyAttributes(e,h.options,"circumcirclesector","point");i=h.create("circumcirclemidpoint",[f[0],f[1],f[2]],d);d=JXG.copyAttributes(e,h.options,"circumcirclesector");g=h.create("sector",[i,f[0],f[2],f[1]],d)}else{throw new Error("JSXGraph: Can't create circumcircle sector with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"' and '"+(typeof f[2])+"'.")}return g};JXG.JSXGraph.registerElement("circumcirclesector",JXG.createCircumcircleSector);JXG.createAngle=function(m,r,k){var f,e,t,n,q=["&alpha;","&beta;","&gamma;","&delta;","&epsilon;","&zeta;","&eta","&theta;","&iota;","&kappa;","&lambda;","&mu;","&nu;","&xi;","&omicron;","&pi;","&rho;","&sigmaf;","&sigma;","&tau;","&upsilon;","&phi;","&chi;","&psi;","&omega;"],l=0,h,o,g,s,u,d;if((JXG.isPoint(r[0]))&&(JXG.isPoint(r[1]))&&(JXG.isPoint(r[2]))){t=k.text;if(t==""){while(l<q.length){h=l;o=q[l];for(f in m.objects){if(m.objects[f].type==JXG.OBJECT_TYPE_ANGLE){if(m.objects[f].text==o){l++;break}}}if(l==h){t=o;l=q.length+1}}if(l==q.length){g="&alpha;_{";s="}";u=false;h=0;while(!u){for(f in m.objects){if(m.objects[f].type==JXG.OBJECT_TYPE_ANGLE){if(m.objects[f].text==(g+h+s)){u=true;break}}}if(u){u=false}else{u=true;t=(g+h+s)}}}}n=JXG.copyAttributes(k,m.options,"angle","point");e=m.create("point",[function(){var i=r[0],v=r[1],j=n.radius,p=v.Dist(i);return[v.X()+(i.X()-v.X())*j/p,v.Y()+(i.Y()-v.Y())*j/p]}],n);n=JXG.copyAttributes(k,m.options,"angle");f=m.create("sector",[r[1],e,r[2]],n);f.radiuspoint=e;d=JXG.copyAttributes(k,m.options,"angle","dot");f.dot=m.create("point",[function(){if(JXG.exists(f.dot)&&f.dot.visProp.visible===false){return[0,0]}var j=e.coords.usrCoords,i=m.create("transform",[-r[1].X(),-r[1].Y()],{type:"translate"});i.melt(m.create("transform",[0.5,0.5],{type:"scale"}));i.melt(m.create("transform",[JXG.Math.Geometry.rad(r[0],r[1],r[2])/2,0,0],{type:"rotate"}));i.melt(m.create("transform",[r[1].X(),r[1].Y()],{type:"translate"}));i.update();return JXG.Math.matVecMult(i.matrix,j)}],d);for(l=0;l<3;l++){JXG.getRef(m,r[l]).addChild(e);JXG.getRef(m,r[l]).addChild(f.dot)}f.type=JXG.OBJECT_TYPE_ANGLE;if(f.visProp.withlabel){f.label.content.setText(t);f.label.content.setProperty({fontSize:f.visProp.fontsize,strokeColor:f.visProp.textcolor})}JXG.getRef(m,r[0]).addChild(f);f.getLabelAnchor=function(){var p=JXG.Math.Geometry.rad(this.point2,this.point1,this.point3),C=10/(this.board.unitX),A=10/(this.board.unitY),y=this.point2.coords.usrCoords,i=this.point1.coords.usrCoords,j=y[1]-i[1],B=y[2]-i[2],z,w,v,x;if(this.label.content!=null){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board)}z=new JXG.Coords(JXG.COORDS_BY_USER,[i[1]+Math.cos(p*0.5*1.125)*j-Math.sin(p*0.5*1.125)*B,i[2]+Math.sin(p*0.5*1.125)*j+Math.cos(p*0.5*1.125)*B],this.board);w=z.usrCoords[1]-i[1];v=z.usrCoords[2]-i[2];x=Math.sqrt(w*w+v*v);w=w*(x+C)/x;v=v*(x+A)/x;return new JXG.Coords(JXG.COORDS_BY_USER,[i[1]+w,i[2]+v],this.board)}}else{throw new Error("JSXGraph: Can't create angle with parent types '"+(typeof r[0])+"' and '"+(typeof r[1])+"' and '"+(typeof r[2])+"'.")}return f};JXG.JSXGraph.registerElement("angle",JXG.createAngle);JXG.Composition=function(h){var g=["setProperty","prepareUpdate","updateRenderer","update","highlight","noHighlight"],d=function(e){return function(){var j;for(j in f.elements){if(JXG.exists(f.elements[j][e])){f.elements[j][e].apply(f.elements[j],arguments)}}return f}},f=this,i;for(i=0;i<g.length;i++){this[g[i]]=d(g[i])}this.elements={};for(i in h){if(h.hasOwnProperty(i)){this.add(i,h[i])}}};JXG.extend(JXG.Composition.prototype,{add:function(e,d){if(!JXG.exists(this[e])&&JXG.exists(d)){if(JXG.exists(d.id)){this.elements[d.id]=d}else{this.elements[e]=d}this[e]=d;return true}return false},remove:function(g){var d=false,f;for(f in this.elements){if(this.elements[f].id===this[g].id){d=true;break}}if(d){delete this.elements[this[g].id];delete this[g]}return d}});JXG.createPerpendicularPoint=function(h,f,e){var d,i,g;if(JXG.isPoint(f[0])&&f[1].elementClass==JXG.OBJECT_CLASS_LINE){i=f[0];d=f[1]}else{if(JXG.isPoint(f[1])&&f[0].elementClass==JXG.OBJECT_CLASS_LINE){i=f[1];d=f[0]}else{throw new Error("JSXGraph: Can't create perpendicular point with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"'.\nPossible parent types: [point,line]")}}g=h.create("point",[function(){return JXG.Math.Geometry.perpendicular(d,i,h)[0]}],e);i.addChild(g);d.addChild(g);g.update();g.generatePolynomial=function(){var k=d.point1.symbolic.x;var j=d.point1.symbolic.y;var q=d.point2.symbolic.x;var p=d.point2.symbolic.y;var s=i.symbolic.x;var r=i.symbolic.y;var n=g.symbolic.x;var l=g.symbolic.y;var o="("+j+")*("+n+")-("+j+")*("+q+")+("+l+")*("+q+")-("+k+")*("+l+")+("+k+")*("+p+")-("+n+")*("+p+")";var m="("+r+")*("+j+")-("+r+")*("+p+")-("+l+")*("+j+")+("+l+")*("+p+")+("+s+")*("+k+")-("+s+")*("+q+")-("+n+")*("+k+")+("+n+")*("+q+")";return[o,m]};return g};JXG.createPerpendicular=function(j,h,g){var k,e,f,i,d;h[0]=JXG.getReference(j,h[0]);h[1]=JXG.getReference(j,h[1]);if(JXG.isPoint(h[0])&&h[1].elementClass==JXG.OBJECT_CLASS_LINE){e=h[1];k=h[0]}else{if(JXG.isPoint(h[1])&&h[0].elementClass==JXG.OBJECT_CLASS_LINE){e=h[0];k=h[1]}else{throw new Error("JSXGraph: Can't create perpendicular with parent types '"+(typeof h[0])+"' and '"+(typeof h[1])+"'.\nPossible parent types: [line,point]")}}d=JXG.copyAttributes(g,j.options,"perpendicular","point");i=JXG.createPerpendicularPoint(j,[e,k],d);if(!JXG.exists(g.layer)){g.layer=j.options.layer.line}d=JXG.copyAttributes(g,j.options,"perpendicular");f=JXG.createLine(j,[function(){return(JXG.Math.Geometry.perpendicular(e,k,j)[1]?[i,k]:[k,i])}],d);f.perpendicularpoint=i;return f};JXG.createMidpoint=function(i,g,f){var e,d,h;if(g.length==2&&JXG.isPoint(g[0])&&JXG.isPoint(g[1])){e=g[0];d=g[1]}else{if(g.length==1&&g[0].elementClass==JXG.OBJECT_CLASS_LINE){e=g[0].point1;d=g[0].point2}else{throw new Error("JSXGraph: Can't create midpoint.\nPossible parent types: [point,point], [line]")}}h=i.create("point",[function(){return(e.coords.usrCoords[1]+d.coords.usrCoords[1])/2},function(){return(e.coords.usrCoords[2]+d.coords.usrCoords[2])/2}],f);e.addChild(h);d.addChild(h);h.prepareUpdate().update();h.generatePolynomial=function(){var l=e.symbolic.x;var k=e.symbolic.y;var n=d.symbolic.x;var m=d.symbolic.y;var p=h.symbolic.x;var o=h.symbolic.y;var j="("+k+")*("+p+")-("+k+")*("+n+")+("+o+")*("+n+")-("+l+")*("+o+")+("+l+")*("+m+")-("+p+")*("+m+")";var q="("+l+")^2 - 2*("+l+")*("+p+")+("+k+")^2-2*("+k+")*("+o+")-("+n+")^2+2*("+n+")*("+p+")-("+m+")^2+2*("+m+")*("+o+")";return[j,q]};return h};JXG.createParallelPoint=function(h,g,f){var e,d,j,i;if(g.length==3&&g[0].elementClass==JXG.OBJECT_CLASS_POINT&&g[1].elementClass==JXG.OBJECT_CLASS_POINT&&g[2].elementClass==JXG.OBJECT_CLASS_POINT){e=g[0];d=g[1];j=g[2]}else{if(g[0].elementClass==JXG.OBJECT_CLASS_POINT&&g[1].elementClass==JXG.OBJECT_CLASS_LINE){j=g[0];e=g[1].point1;d=g[1].point2}else{if(g[1].elementClass==JXG.OBJECT_CLASS_POINT&&g[0].elementClass==JXG.OBJECT_CLASS_LINE){j=g[1];e=g[0].point1;d=g[0].point2}else{throw new Error("JSXGraph: Can't create parallel point with parent types '"+(typeof g[0])+"', '"+(typeof g[1])+"' and '"+(typeof g[2])+"'.\nPossible parent types: [line,point], [point,point,point]")}}}i=h.create("point",[function(){return j.coords.usrCoords[1]+d.coords.usrCoords[1]-e.coords.usrCoords[1]},function(){return j.coords.usrCoords[2]+d.coords.usrCoords[2]-e.coords.usrCoords[2]}],f);e.addChild(i);d.addChild(i);j.addChild(i);i.prepareUpdate().update();i.generatePolynomial=function(){var l=e.symbolic.x;var k=e.symbolic.y;var t=d.symbolic.x;var s=d.symbolic.y;var n=j.symbolic.x;var m=j.symbolic.y;var q=i.symbolic.x;var o=i.symbolic.y;var r="("+s+")*("+q+")-("+s+")*("+n+")-("+k+")*("+q+")+("+k+")*("+n+")-("+o+")*("+t+")+("+o+")*("+l+")+("+m+")*("+t+")-("+m+")*("+l+")";var p="("+o+")*("+l+")-("+o+")*("+n+")-("+s+")*("+l+")+("+s+")*("+n+")-("+q+")*("+k+")+("+q+")*("+m+")+("+t+")*("+k+")-("+t+")*("+m+")";return[r,p]};return i};JXG.createParallel=function(j,h,g){var l,f,i,d;try{d=JXG.copyAttributes(g,j.options,"parallel","point");f=JXG.createParallelPoint(j,h,d)}catch(k){throw new Error("JSXGraph: Can't create parallel with parent types '"+(typeof h[0])+"' and '"+(typeof h[1])+"'.\nPossible parent types: [line,point], [point,point,point]")}l=null;if(h.length==3){l=h[2]}else{if(h[0].elementClass==JXG.OBJECT_CLASS_POINT){l=h[0]}else{if(h[1].elementClass==JXG.OBJECT_CLASS_POINT){l=h[1]}}}if(!JXG.exists(g.layer)){g.layer=j.options.layer.line}d=JXG.copyAttributes(g,j.options,"parallel");i=j.create("line",[l,f],d);i.parallelpoint=f;return i};JXG.createArrowParallel=function(g,f,d){try{return JXG.createParallel(g,f,d).setStraight(false,false).setArrow(false,true)}catch(h){throw new Error("JSXGraph: Can't create arrowparallel with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"'.\nPossible parent types: [line,point], [point,point,point]")}};JXG.createNormal=function(h,e,d){var k;var l;if(e.length==1){k=e[0];l=k.slideObject}else{if(e.length==2){if(JXG.isPoint(e[0])){k=e[0];l=e[1]}else{if(JXG.isPoint(e[1])){l=e[0];k=e[1]}else{throw new Error("JSXGraph: Can't create normal with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.\nPossible parent types: [point,line], [point,circle], [glider]")}}}else{throw new Error("JSXGraph: Can't create normal with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.\nPossible parent types: [point,line], [point,circle], [glider]")}}if(l.elementClass==JXG.OBJECT_CLASS_LINE){return h.create("line",[function(){return l.stdform[1]*k.Y()-l.stdform[2]*k.X()},function(){return l.stdform[2]*k.Z()},function(){return -l.stdform[1]*k.Z()}],d)}else{if(l.elementClass==JXG.OBJECT_CLASS_CIRCLE){return h.create("line",[l.midpoint,k],d)}else{if(l.elementClass==JXG.OBJECT_CLASS_CURVE){if(l.visProp.curvetype!="plot"){var i=l.X;var j=l.Y;return h.create("line",[function(){return -k.X()*h.D(i)(k.position)-k.Y()*h.D(j)(k.position)},function(){return h.D(i)(k.position)},function(){return h.D(j)(k.position)}],d)}else{return h.create("line",[function(){var g=Math.floor(k.position);var f=k.position-g;if(g==l.numberPoints-1){g--;f=1}if(g<0){return 1}return(l.Y(g)+f*(l.Y(g+1)-l.Y(g)))*(l.Y(g)-l.Y(g+1))-(l.X(g)+f*(l.X(g+1)-l.X(g)))*(l.X(g+1)-l.X(g))},function(){var f=Math.floor(k.position);if(f==l.numberPoints-1){f--}if(f<0){return 0}return l.X(f+1)-l.X(f)},function(){var f=Math.floor(k.position);if(f==l.numberPoints-1){f--}if(f<0){return 0}return l.Y(f+1)-l.Y(f)}],d)}}else{if(l.type==JXG.OBJECT_TYPE_TURTLE){return h.create("line",[function(){var m=Math.floor(k.position);var f=k.position-m;var n,g;for(g=0;g<l.objects.length;g++){n=l.objects[g];if(n.type==JXG.OBJECT_TYPE_CURVE){if(m<n.numberPoints){break}m-=n.numberPoints}}if(m==n.numberPoints-1){m--;f=1}if(m<0){return 1}return(n.Y(m)+f*(n.Y(m+1)-n.Y(m)))*(n.Y(m)-n.Y(m+1))-(n.X(m)+f*(n.X(m+1)-n.X(m)))*(n.X(m+1)-n.X(m))},function(){var g=Math.floor(k.position);var m,f;for(f=0;f<l.objects.length;f++){m=l.objects[f];if(m.type==JXG.OBJECT_TYPE_CURVE){if(g<m.numberPoints){break}g-=m.numberPoints}}if(g==m.numberPoints-1){g--}if(g<0){return 0}return m.X(g+1)-m.X(g)},function(){var g=Math.floor(k.position);var m,f;for(f=0;f<l.objects.length;f++){m=l.objects[f];if(m.type==JXG.OBJECT_TYPE_CURVE){if(g<m.numberPoints){break}g-=m.numberPoints}}if(g==m.numberPoints-1){g--}if(g<0){return 0}return m.Y(g+1)-m.Y(g)}],d)}else{throw new Error("JSXGraph: Can't create normal with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.\nPossible parent types: [point,line], [point,circle], [glider]")}}}}};JXG.createBisector=function(j,g,f){var k,e,h,d;if(g[0].elementClass==JXG.OBJECT_CLASS_POINT&&g[1].elementClass==JXG.OBJECT_CLASS_POINT&&g[2].elementClass==JXG.OBJECT_CLASS_POINT){d=JXG.copyAttributes(f,j.options,"bisector","point");k=j.create("point",[function(){return JXG.Math.Geometry.angleBisector(g[0],g[1],g[2],j)}],d);for(h=0;h<3;h++){g[h].addChild(k)}if(!JXG.exists(f.layer)){f.layer=j.options.layer.line}d=JXG.copyAttributes(f,j.options,"bisector");e=JXG.createLine(j,[g[1],k],d);return e}else{throw new Error("JSXGraph: Can't create angle bisector with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"'.\nPossible parent types: [point,point,point]")}};JXG.createAngularBisectorsOfTwoLines=function(i,k,g){var f=JXG.getReference(i,k[0]),e=JXG.getReference(i,k[1]),d,l,j,h;if(f.elementClass!=JXG.OBJECT_CLASS_LINE||e.elementClass!=JXG.OBJECT_CLASS_LINE){throw new Error("JSXGraph: Can't create angle bisectors of two lines with parent types '"+(typeof k[0])+"' and '"+(typeof k[1])+"'.\nPossible parent types: [line,line]")}if(!JXG.exists(g.layer)){g.layer=i.options.layer.line}j=JXG.copyAttributes(g,i.options,"bisectorlines","line1");d=i.create("line",[function(){var n=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);var m=Math.sqrt(e.stdform[1]*e.stdform[1]+e.stdform[2]*e.stdform[2]);return f.stdform[0]/n-e.stdform[0]/m},function(){var n=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);var m=Math.sqrt(e.stdform[1]*e.stdform[1]+e.stdform[2]*e.stdform[2]);return f.stdform[1]/n-e.stdform[1]/m},function(){var n=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);var m=Math.sqrt(e.stdform[1]*e.stdform[1]+e.stdform[2]*e.stdform[2]);return f.stdform[2]/n-e.stdform[2]/m}],j);if(!JXG.exists(g.layer)){g.layer=i.options.layer.line}j=JXG.copyAttributes(g,i.options,"bisectorlines","line2");l=i.create("line",[function(){var n=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);var m=Math.sqrt(e.stdform[1]*e.stdform[1]+e.stdform[2]*e.stdform[2]);return f.stdform[0]/n+e.stdform[0]/m},function(){var n=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);var m=Math.sqrt(e.stdform[1]*e.stdform[1]+e.stdform[2]*e.stdform[2]);return f.stdform[1]/n+e.stdform[1]/m},function(){var n=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);var m=Math.sqrt(e.stdform[1]*e.stdform[1]+e.stdform[2]*e.stdform[2]);return f.stdform[2]/n+e.stdform[2]/m}],j);h=new JXG.Composition({line1:d,line2:l});return h};JXG.createCircumcircleMidpoint=function(g,e,d){var h,f;if(e[0].elementClass==JXG.OBJECT_CLASS_POINT&&e[1].elementClass==JXG.OBJECT_CLASS_POINT&&e[2].elementClass==JXG.OBJECT_CLASS_POINT){h=JXG.createPoint(g,[function(){return JXG.Math.Geometry.circumcenterMidpoint(e[0],e[1],e[2],g)}],d);for(f=0;f<3;f++){e[f].addChild(h)}h.generatePolynomial=function(){var j=a.symbolic.x;var i=a.symbolic.y;var r=b.symbolic.x;var q=b.symbolic.y;var l=c.symbolic.x;var k=c.symbolic.y;var o=h.symbolic.x;var m=h.symbolic.y;var p=["((",o,")-(",j,"))^2+((",m,")-(",i,"))^2-((",o,")-(",r,"))^2-((",m,")-(",q,"))^2"].join("");var n=["((",o,")-(",j,"))^2+((",m,")-(",i,"))^2-((",o,")-(",l,"))^2-((",m,")-(",k,"))^2"].join("");return[p,n]};return h}else{throw new Error("JSXGraph: Can't create circumcircle midpoint with parent types '"+(typeof e[0])+"', '"+(typeof e[1])+"' and '"+(typeof e[2])+"'.\nPossible parent types: [point,point,point]")}};JXG.createIncenter=function(i,l,h){var f,k,j,g,e,d;if(l.length>=3&&JXG.isPoint(l[0])&&JXG.isPoint(l[1])&&JXG.isPoint(l[2])){g=l[0];e=l[1];d=l[2];f=i.create("point",[function(){var n,m,o;n=Math.sqrt((e.X()-d.X())*(e.X()-d.X())+(e.Y()-d.Y())*(e.Y()-d.Y()));m=Math.sqrt((g.X()-d.X())*(g.X()-d.X())+(g.Y()-d.Y())*(g.Y()-d.Y()));o=Math.sqrt((e.X()-g.X())*(e.X()-g.X())+(e.Y()-g.Y())*(e.Y()-g.Y()));return new JXG.Coords(JXG.COORDS_BY_USER,[(n*g.X()+m*e.X()+o*d.X())/(n+m+o),(n*g.Y()+m*e.Y()+o*d.Y())/(n+m+o)],i)}],h)}else{throw new Error("JSXGraph: Can't create incenter with parent types '"+(typeof l[0])+"', '"+(typeof l[1])+"' and '"+(typeof l[2])+"'.\nPossible parent types: [point,point,point]")}return f};JXG.createCircumcircle=function(i,h,f){var k,l,d,g;try{d=JXG.copyAttributes(f,i.options,"circumcircle","point");k=JXG.createCircumcircleMidpoint(i,h,d);if(!JXG.exists(f.layer)){f.layer=i.options.layer.circle}d=JXG.copyAttributes(f,i.options,"circumcircle");l=JXG.createCircle(i,[k,h[0]],d)}catch(j){throw new Error("JSXGraph: Can't create circumcircle with parent types '"+(typeof h[0])+"', '"+(typeof h[1])+"' and '"+(typeof h[2])+"'.\nPossible parent types: [point,point,point]")}return l};JXG.createIncircle=function(i,h,f){var k,l,d,g;try{d=JXG.copyAttributes(f,i.options,"incircle","point");k=JXG.createIncenter(i,h,d);if(!JXG.exists(f.layer)){f.layer=i.options.layer.circle}d=JXG.copyAttributes(f,i.options,"incircle");l=JXG.createCircle(i,[k,function(){var m=Math.sqrt((h[1].X()-h[2].X())*(h[1].X()-h[2].X())+(h[1].Y()-h[2].Y())*(h[1].Y()-h[2].Y())),e=Math.sqrt((h[0].X()-h[2].X())*(h[0].X()-h[2].X())+(h[0].Y()-h[2].Y())*(h[0].Y()-h[2].Y())),o=Math.sqrt((h[1].X()-h[0].X())*(h[1].X()-h[0].X())+(h[1].Y()-h[0].Y())*(h[1].Y()-h[0].Y())),n=(m+e+o)/2;return Math.sqrt(((n-m)*(n-e)*(n-o))/n)}],d)}catch(j){throw new Error("JSXGraph: Can't create circumcircle with parent types '"+(typeof h[0])+"', '"+(typeof h[1])+"' and '"+(typeof h[2])+"'.\nPossible parent types: [point,point,point]")}return l};JXG.createReflection=function(g,f,e){var d,i,h;if(f[0].elementClass==JXG.OBJECT_CLASS_POINT&&f[1].elementClass==JXG.OBJECT_CLASS_LINE){i=f[0];d=f[1]}else{if(f[1].elementClass==JXG.OBJECT_CLASS_POINT&&f[0].elementClass==JXG.OBJECT_CLASS_LINE){i=f[1];d=f[0]}else{throw new Error("JSXGraph: Can't create reflection point with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"'.\nPossible parent types: [line,point]")}}h=JXG.createPoint(g,[function(){return JXG.Math.Geometry.reflection(d,i,g)}],e);i.addChild(h);d.addChild(h);h.prepareUpdate().update();h.generatePolynomial=function(){var k=d.point1.symbolic.x;var j=d.point1.symbolic.y;var q=d.point2.symbolic.x;var p=d.point2.symbolic.y;var s=i.symbolic.x;var r=i.symbolic.y;var m=h.symbolic.x;var l=h.symbolic.y;var o=["((",l,")-(",r,"))*((",j,")-(",p,"))+((",k,")-(",q,"))*((",m,")-(",s,"))"].join("");var n=["((",m,")-(",k,"))^2+((",l,")-(",j,"))^2-((",s,")-(",k,"))^2-((",r,")-(",j,"))^2"].join("");return[o,n]};return h};JXG.createMirrorPoint=function(f,h,d){var g,e;if(JXG.isPoint(h[0])&&JXG.isPoint(h[1])){g=JXG.createPoint(f,[function(){return JXG.Math.Geometry.rotation(h[0],h[1],Math.PI,f)}],d);for(e=0;e<2;e++){h[e].addChild(g)}}else{throw new Error("JSXGraph: Can't create mirror point with parent types '"+(typeof h[0])+"' and '"+(typeof h[1])+"'.\nPossible parent types: [point,point]")}g.prepareUpdate().update();return g};JXG.createIntegral=function(i,x,m){var w,r,u,g=0,f=0,e,d,l,k,q=1,v,n,h,y,j,o,s;if(JXG.isArray(x[0])&&x[1].elementClass==JXG.OBJECT_CLASS_CURVE){w=x[0];r=x[1]}else{if(JXG.isArray(x[1])&&x[0].elementClass==JXG.OBJECT_CLASS_CURVE){w=x[1];r=x[0]}else{throw new Error("JSXGraph: Can't create integral with parent types '"+(typeof x[0])+"' and '"+(typeof x[1])+"'.\nPossible parent types: [[number|function,number|function],curve]")}}g=w[0];f=w[1];if(JXG.isFunction(g)){e=g;d=function(){return r.yterm(e())};g=e()}else{e=g;d=r.yterm(g)}if(JXG.isFunction(g)){l=f;k=function(){return r.yterm(l())};f=l()}else{l=f;k=r.yterm(f)}if(f<g){q=-1}u=JXG.copyAttributes(m,i.options,"integral","start");v=i.create("glider",[e,d,r],u);if(JXG.isFunction(e)){v.hideElement()}u=JXG.copyAttributes(m,i.options,"integral","startproject");n=i.create("point",[function(){return v.X()},0],u);u=JXG.copyAttributes(m,i.options,"integral","end");h=i.create("glider",[l,k,r],u);if(JXG.isFunction(l)){h.hideElement()}u=JXG.copyAttributes(m,i.options,"integral","endproject");y=i.create("point",[function(){return h.X()},0],u);u=JXG.copyAttributes(m,i.options,"integral");if(u.withLabel!==false){u=JXG.copyAttributes(m,i.options,"integral","text");j=JXG.Math.Numerics.I([g,f],r.yterm);o=i.create("text",[function(){return h.X()+0.2},function(){return h.Y()-0.8},function(){var p=JXG.Math.Numerics.I([n.X(),y.X()],r.yterm);return"&int; = "+(p).toFixed(4)}],u);v.addChild(o);h.addChild(o)}u=JXG.copyAttributes(m,i.options,"integral");s=i.create("curve",[[0],[0]],u);s.updateDataArray=function(){var p,B,z,A,t;if(n.X()<y.X()){A=n.X();t=y.X()}else{A=y.X();t=n.X()}p=[A,A];B=[0,r.yterm(A)];for(z=0;z<r.numberPoints;z++){if((A<=r.points[z].usrCoords[1])&&(r.points[z].usrCoords[1]<=t)){p.push(r.points[z].usrCoords[1]);B.push(r.points[z].usrCoords[2])}}p.push(t);B.push(r.yterm(t));p.push(t);B.push(0);p.push(A);B.push(0);this.dataX=p;this.dataY=B};v.addChild(s);h.addChild(s);s.baseLeft=n;s.baseRight=y;s.curveLeft=v;s.curveRight=h;s.label={content:o};return s};JXG.createLocus=function(f,e,d){var h,g;if(JXG.isArray(e)&&e.length==1&&e[0].elementClass==JXG.OBJECT_CLASS_POINT){g=e[0]}else{throw new Error("JSXGraph: Can't create locus with parent of type other than point.\nPossible parent types: [point]")}h=f.create("curve",[[null],[null]],d);h.dontCallServer=false;h.updateDataArray=function(){if(h.board.mode>0){return}var j=JXG.Math.Symbolic.generatePolynomials(f,g,true).join("|");if(j===h.spe){return}h.spe=j;var i=function(m,o,l,n){h.dataX=m;h.dataY=o;h.eq=l;h.ctime=n;h.generatePolynomial=(function(p){return function(r){var q="("+r.symbolic.x+")",u="("+r.symbolic.y+")",t=[],s;for(s=0;s<p.length;s++){t[s]=p[s].replace(/\*\*/g,"^").replace(/x/g,q).replace(/y/g,u)}return t}})(l)},k=JXG.Math.Symbolic.geometricLocusByGroebnerBase(f,g,i);i(k.datax,k.datay,k.polynomial,k.exectime)};return h};JXG.createGrid=function(g,f,e){var h,d;d=JXG.copyAttributes(e,g.options,"grid");h=g.create("curve",[[null],[null]],d);if(g.options.grid.dash){h.setProperty({dash:2})}h.updateDataArray=function(){var j=g.options.grid.gridX,n=g.options.grid.gridY,m=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],g),l=new JXG.Coords(JXG.COORDS_BY_SCREEN,[g.canvasWidth,g.canvasHeight],g),k;g.options.grid.hasGrid=true;m.setCoordinates(JXG.COORDS_BY_USER,[Math.floor(m.usrCoords[1]/j)*j,Math.ceil(m.usrCoords[2]/n)*n]);l.setCoordinates(JXG.COORDS_BY_USER,[Math.ceil(l.usrCoords[1]/j)*j,Math.floor(l.usrCoords[2]/n)*n]);h.dataX=[];h.dataY=[];for(k=m.usrCoords[2];k>l.usrCoords[2]-n;k-=n){h.dataX.push(m.usrCoords[1],l.usrCoords[1],NaN);h.dataY.push(k,k,NaN)}for(k=m.usrCoords[1];k<l.usrCoords[1]+j;k+=j){h.dataX.push(k,k,NaN);h.dataY.push(m.usrCoords[2],l.usrCoords[2],NaN)}};h.hasPoint=function(){return false};g.grids.push(h);return h};JXG.JSXGraph.registerElement("arrowparallel",JXG.createArrowParallel);JXG.JSXGraph.registerElement("bisector",JXG.createBisector);JXG.JSXGraph.registerElement("bisectorlines",JXG.createAngularBisectorsOfTwoLines);JXG.JSXGraph.registerElement("circumcircle",JXG.createCircumcircle);JXG.JSXGraph.registerElement("circumcirclemidpoint",JXG.createCircumcircleMidpoint);JXG.JSXGraph.registerElement("circumcenter",JXG.createCircumcircleMidpoint);JXG.JSXGraph.registerElement("incenter",JXG.createIncenter);JXG.JSXGraph.registerElement("incircle",JXG.createIncircle);JXG.JSXGraph.registerElement("integral",JXG.createIntegral);JXG.JSXGraph.registerElement("midpoint",JXG.createMidpoint);JXG.JSXGraph.registerElement("mirrorpoint",JXG.createMirrorPoint);JXG.JSXGraph.registerElement("normal",JXG.createNormal);JXG.JSXGraph.registerElement("parallel",JXG.createParallel);JXG.JSXGraph.registerElement("parallelpoint",JXG.createParallelPoint);JXG.JSXGraph.registerElement("perpendicular",JXG.createPerpendicular);JXG.JSXGraph.registerElement("perpendicularpoint",JXG.createPerpendicularPoint);JXG.JSXGraph.registerElement("reflection",JXG.createReflection);JXG.JSXGraph.registerElement("locus",JXG.createLocus);JXG.JSXGraph.registerElement("grid",JXG.createGrid);JXG.Text=function(g,h,i,e){this.constructor(g,e,JXG.OBJECT_TYPE_TEXT,JXG.OBJECT_CLASS_OTHER);this.content=h;this.plaintext="";if((this.element=JXG.getRef(this.board,e.anchor))){var f;if(this.visProp.islabel){f=this.element.getLabelAnchor();this.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[parseFloat(i[0]),parseFloat(i[1])],this.board)}else{f=this.element.getTextAnchor();this.relativeCoords=new JXG.Coords(JXG.COORDS_BY_USER,[parseFloat(i[0]),parseFloat(i[1])],this.board)}this.element.addChild(this);this.coords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[this.relativeCoords.scrCoords[1]+f.scrCoords[1],this.relativeCoords.scrCoords[2]+f.scrCoords[2]],this.board);this.isDraggable=true}else{if(!JXG.isFunction(i[0])&&!JXG.isFunction(i[1])){this.isDraggable=true}this.X=JXG.createFunction(i[0],this.board,"");this.Y=JXG.createFunction(i[1],this.board,"");this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.X(),this.Y()],this.board);var d="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.X(),this.Y()]);";this.updateCoords=new Function("",d)}if(typeof this.content==="function"){this.updateText=function(){this.plaintext=this.content()}}else{if(JXG.isNumber(this.content)){this.content=(this.content).toFixed(this.visProp.digits)}else{if(this.visProp.useasciimathml){this.content="'`"+this.content+"`'"}else{this.content=this.generateTerm(this.content)}}this.updateText=new Function("this.plaintext = "+this.content+";")}this.updateText();this.id=this.board.setId(this,"T");this.board.renderer.drawText(this);if(!this.visProp.visible){this.board.renderer.hide(this)}if(typeof this.content==="string"){this.notifyParents(this.content)}this.size=[1,1];return this};JXG.Text.prototype=new JXG.GeometryElement();JXG.extend(JXG.Text.prototype,{hasPoint:function(d,h){var f=d-this.coords.scrCoords[1],e=this.coords.scrCoords[2]-h,g=this.board.options.precision.hasPoint;if(f>=-g&&f<=2*g&&e>=-g&&e<=2*g){return true}else{return false}},setText:function(d){if(typeof d==="function"){this.updateText=function(){this.plaintext=d()}}else{if(JXG.isNumber(d)){this.content=(d).toFixed(this.visProp.digits)}else{if(this.visProp.useasciimathml){this.content="'`"+d+"`'"}else{this.content=this.generateTerm(d)}}this.updateText=new Function("this.plaintext = "+this.content+";")}this.updateText();this.updateSize();return this},updateSize:function(){if(this.display=="html"&&this.board.renderer.type!="vml"){this.size=[this.rendNode.offsetWidth,this.rendNode.offsetHeight]}else{if(this.display=="internal"&&this.board.renderer.type=="svg"){this.size=[this.rendNode.getBBox().width,this.rendNode.getBBox().height]}else{if(this.board.renderer.type=="vml"||(this.display=="internal"&&this.board.renderer.type=="canvas")){this.size=[parseFloat(this.visProp.fontsize)*this.plaintext.length*0.45,parseFloat(this.visProp.fontsize)*0.9]}}}},getSize:function(){return this.size},setCoords:function(d,e){this.X=function(){return d};this.Y=function(){return e};this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[d,e],this.board);return this},update:function(){var d;if(this.needsUpdate){if(this.relativeCoords){if(this.visProp.islabel){d=this.element.getLabelAnchor();this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[this.relativeCoords.scrCoords[1]+d.scrCoords[1],this.relativeCoords.scrCoords[2]+d.scrCoords[2]])}else{d=this.element.getTextAnchor();this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.relativeCoords.usrCoords[1]+d.usrCoords[1],this.relativeCoords.usrCoords[2]+d.usrCoords[2]])}}else{this.updateCoords()}this.updateText();this.updateSize();this.updateTransform()}return this},updateRenderer:function(){if(this.needsUpdate){this.board.renderer.updateText(this);this.needsUpdate=false}return this},updateTransform:function(){if(this.transformations.length==0){return}for(var d=0;d<this.transformations.length;d++){this.transformations[d].update()}},generateTerm:function(h){var g,k='""',f;h=h||"";h=h.replace(/\r/g,"");h=h.replace(/\n/g,"");h=h.replace(/\"/g,'\\"');h=h.replace(/\'/g,"\\'");h=h.replace(/&amp;arc;/g,"&ang;");h=h.replace(/<arc\s*\/>/g,"&ang;");h=h.replace(/<sqrt\s*\/>/g,"&radic;");var e;e=h.indexOf("<value>");var d=h.indexOf("</value>");if(e>=0){while(e>=0){k+=' + "'+JXG.GeonextParser.replaceSub(JXG.GeonextParser.replaceSup(h.slice(0,e)))+'"';f=h.slice(e+7,d);g=JXG.GeonextParser.geonext2JS(f,this.board);g=g.replace(/\\"/g,'"');g=g.replace(/\\'/g,"'");if(g.indexOf("toFixed")<0){if(JXG.isNumber((JXG.bind(new Function("return "+g+";"),this))())){k+="+("+g+").toFixed("+(this.visProp.digits)+")"}else{k+="+("+g+")"}}else{k+="+("+g+")"}h=h.slice(d+8);e=h.indexOf("<value>");d=h.indexOf("</value>")}}k+=' + "'+JXG.GeonextParser.replaceSub(JXG.GeonextParser.replaceSup(h))+'"';k=k.replace(/<overline>/g,"<span style=text-decoration:overline>");k=k.replace(/<\/overline>/g,"</span>");k=k.replace(/<arrow>/g,"<span style=text-decoration:overline>");k=k.replace(/<\/arrow>/g,"</span>");k=k.replace(/&amp;/g,"&");return k},notifyParents:function(f){var e=null;do{var d=/<value>([\w\s\*\/\^\-\+\(\)\[\],<>=!]+)<\/value>/;e=d.exec(f);if(e!=null){JXG.GeonextParser.findDependencies(this,e[1],this.board);f=f.substr(e.index);f=f.replace(d,"")}}while(e!=null);return this},bounds:function(){var d=this.coords.usrCoords;return this.visProp.islabel?[0,0,0,0]:[d[1],d[2]+this.size[1],d[1]+this.size[0],d[2]]},setPositionDirectly:function(d,k,h,g,f){var e,n,m,l,j;if(this.relativeCoords){if(this.visProp.islabel){if(d==JXG.COORDS_BY_USER){j=new JXG.Coords(JXG.COORDS_BY_USER,[g,f],this.board);l=new JXG.Coords(JXG.COORDS_BY_USER,[k,h],this.board);n=l.scrCoords[1]-j.scrCoords[1];m=l.scrCoords[2]-j.scrCoords[2]}else{n=k-g;m=h-f}this.relativeCoords.scrCoords[1]+=n;this.relativeCoords.scrCoords[2]+=m}else{if(d==JXG.COORDS_BY_SCREEN){j=new JXG.Coords(JXG.COORDS_BY_SCREEN,[g,f],this.board);l=new JXG.Coords(JXG.COORDS_BY_SCREEN,[k,h],this.board);n=l.usrCoords[1]-j.usrCoords[1];m=l.usrCoords[2]-j.usrCoords[2]}else{n=k-g;m=h-f}this.relativeCoords.usrCoords[1]+=n;this.relativeCoords.usrCoords[2]+=m}}else{if(d==JXG.COORDS_BY_SCREEN){l=new JXG.Coords(JXG.COORDS_BY_SCREEN,[k,h],this.board);k=l.usrCoords[1];h=l.usrCoords[2]}this.X=JXG.createFunction(k,this.board,"");this.Y=JXG.createFunction(h,this.board,"")}return this}});JXG.createText=function(g,f,e){var d;d=JXG.copyAttributes(e,g.options,"text");d.anchor=d.parent||d.anchor;return new JXG.Text(g,f[f.length-1],f,d)};JXG.JSXGraph.registerElement("text",JXG.createText);JXG.Image=function(g,e,h,f,d){this.constructor(g,d,JXG.OBJECT_TYPE_IMAGE,JXG.OBJECT_CLASS_OTHER);this.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,h,this.board);if(!JXG.isFunction(h[0])&&!JXG.isFunction(h[1])){this.isDraggable=true}this.X=JXG.createFunction(h[0],this.board,"");this.Y=JXG.createFunction(h[1],this.board,"");this.W=JXG.createFunction(f[0],this.board,"");this.H=JXG.createFunction(f[1],this.board,"");this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.X(),this.Y()],this.board);this.updateCoords=new Function("","this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.X(),this.Y()]);");this.updateSize=new Function("","this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.W(),this.H()]);");this.usrSize=[this.W(),this.H()];this.size=[this.usrSize[0]*g.unitX,this.usrSize[1]*g.unitY];this.url=e;this.parent=JXG.getRef(d.anchor);this.id=this.board.setId(this,"Im");this.board.renderer.drawImage(this);if(!this.visProp.visible){this.board.renderer.hide(this)}};JXG.Image.prototype=new JXG.GeometryElement;JXG.extend(JXG.Image.prototype,{hasPoint:function(d,h){var f=d-this.coords.scrCoords[1],e=this.coords.scrCoords[2]-h,g=this.board.options.precision.hasPoint;if(f>=-g&&f<=2*g&&e>=-g&&e<=g){return true}else{return false}},update:function(){if(this.needsUpdate){this.updateCoords();this.usrSize=[this.W(),this.H()];this.size=[this.usrSize[0]*this.board.unitX,this.usrSize[1]*this.board.unitY];this.updateTransform()}return this},updateRenderer:function(){if(this.needsUpdate){this.board.renderer.updateImage(this);this.needsUpdate=false}return this},updateTransform:function(){if(this.transformations.length==0){return}for(var d=0;d<this.transformations.length;d++){this.transformations[d].update()}},addTransform:function(d){if(JXG.isArray(d)){for(var e=0;e<d.length;e++){this.transformations.push(d[e])}}else{this.transformations.push(d)}},setPositionDirectly:function(k,d,j,h,g){var i,f,e;if(k==JXG.COORDS_BY_SCREEN){i=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d,j],this.board);d=i.usrCoords[1];j=i.usrCoords[2]}this.X=JXG.createFunction(d,this.board,"");this.Y=JXG.createFunction(j,this.board,"");return this}});JXG.createImage=function(h,g,e){var f,d;d=JXG.copyAttributes(e,h.options,"image");return new JXG.Image(h,g[0],g[1],g[2],d)};JXG.JSXGraph.registerElement("image",JXG.createImage);JXG.createSlider=function(o,A,p){var j,i,z,k,B,q,f,e,y,C,l,h,g,d,x,v,r,m,u,s,w;j=A[0];i=A[1];z=A[2][0];k=A[2][1];B=A[2][2];q=B-z;w=JXG.copyAttributes(p,o.options,"slider");u=w.withticks;m=w.withlabel;s=w.snapwidth;precision=w.precision;w=JXG.copyAttributes(p,o.options,"slider","point1");f=o.create("point",j,w);w=JXG.copyAttributes(p,o.options,"slider","point2");e=o.create("point",i,w);o.create("group",[f,e]);w=JXG.copyAttributes(p,o.options,"slider","segment1");y=o.create("segment",[f,e],w);y.updateStdform();if(u){w=JXG.copyAttributes(p,o.options,"slider","ticks");C=2;l=o.create("ticks",[y,e.Dist(f)/C],w)}h=j[0]+(i[0]-j[0])*(k-z)/(B-z);g=j[1]+(i[1]-j[1])*(k-z)/(B-z);w=JXG.copyAttributes(p,o.options,"slider","glider");if(p.name&&p.name!=""){w.name=p.name}d=o.create("glider",[h,g,y],w);d.setProperty({snapwidth:s});w=JXG.copyAttributes(p,o.options,"slider","segment2");x=o.create("segment",[f,d],w);d.Value=function(){return this.position*q+z};d._smax=B;d._smin=z;if(m){if(p.name&&p.name!=""){v=p.name+" = "}else{v=""}w=JXG.copyAttributes(p,o.options,"slider","text");r=o.create("text",[function(){return(e.X()-f.X())*0.05+e.X()},function(){return(e.Y()-f.Y())*0.05+e.Y()},function(){return v+(d.Value()).toFixed(precision)}],w);d.text=r}d.point1=f;d.point2=e;d.baseline=y;d.highline=x;if(u){d.ticks=l}d.remove=function(){if(m){o.removeObject(r)}o.removeObject(x);if(u){y.removeTicks(l)}o.removeObject(y);o.removeObject(e);o.removeObject(f);JXG.Point.prototype.remove.call(d)};return d};JXG.JSXGraph.registerElement("slider",JXG.createSlider);JXG.Chart=function(h,l,e){this.constructor(h,e);var m,k,f,j,d,g;if(!JXG.isArray(l)||l.length===0){throw new Error("JSXGraph: Can't create a chart without data")}this.elements=[];if(JXG.isNumber(l[0])){k=l;m=[];for(f=0;f<k.length;f++){m[f]=f+1}}else{if(l.length===1&&JXG.isArray(l[0])){k=l[0];m=[];g=JXG.evaluate(k).length;for(f=0;f<g;f++){m[f]=f+1}}else{if(l.length===2){g=Math.min(l[0].length,l[1].length);m=l[0].slice(0,g);k=l[1].slice(0,g)}}}if(JXG.isArray(k)&&k.length===0){throw new Error("JSXGraph: Can't create charts without data.")}d=e.chartstyle.replace(/ /g,"").split(",");for(f=0;f<d.length;f++){switch(d[f]){case"bar":j=this.drawBar(h,m,k,e);break;case"line":j=this.drawLine(h,m,k,e);break;case"fit":j=this.drawFit(h,m,k,e);break;case"spline":j=this.drawSpline(h,m,k,e);break;case"pie":j=this.drawPie(h,k,e);break;case"point":j=this.drawPoints(h,m,k,e);break;case"radar":j=this.drawRadar(h,l,e);break}this.elements.push(j)}this.id=this.board.setId(this,"Chart");return this.elements};JXG.Chart.prototype=new JXG.GeometryElement;JXG.extend(JXG.Chart.prototype,{drawLine:function(f,d,g,e){e.fillcolor="none";e.highlightfillcolor="none";return f.create("curve",[d,g],e)},drawSpline:function(f,d,g,e){e.fillColor="none";e.highlightfillcolor="none";return f.create("spline",[d,g],e)},drawFit:function(f,d,h,e){var g=e.degree;g=(!JXG.exists(g)||parseInt(g)==NaN||parseInt(g)<1)?1:parseInt(g),e.fillcolor="none";e.highlightfillcolor="none";return f.create("functiongraph",[JXG.Math.Numerics.regressionPolynomial(g,d,h)],e)},drawBar:function(e,l,h,f){var u,g=[],r,t,d,q,n,o,m,k,v,j,s=[],z={fixed:true,withLabel:false,visible:false,name:""};if(!JXG.exists(f.fillopacity)){f.fillopacity=0.6}if(f&&f.width){n=f.width}else{if(l.length<=1){n=1}else{n=l[1]-l[0];for(u=1;u<l.length-1;u++){n=(l[u+1]-l[u]<n)?l[u+1]-l[u]:n}}n*=0.8}t=f.fillcolor;d=parseFloat(e.options.text.fontSize);for(u=0;u<l.length;u++){if(isNaN(JXG.evaluate(l[u]))||isNaN(h[u])){}if(JXG.isFunction(l[u])){o=function(){return l[u]()-n*0.5};m=function(){return l[u]()};k=function(){return l[u]()+n*0.5}}else{o=l[u]-n*0.5;m=l[u];k=l[u]+n*0.5}v=h[u];if(f.dir=="horizontal"){s[0]=e.create("point",[0,o],z);s[1]=e.create("point",[v,o],z);s[2]=e.create("point",[v,k],z);s[3]=e.create("point",[0,k],z);if(JXG.exists(f.labels)&&JXG.exists(f.labels[u])){r=f.labels[u].toString().length;r=2*r*d/e.unitX;if(v>=0){v+=d*0.5/e.unitX}else{v-=d*r/e.unitX}m-=d*0.2/e.unitY;q=e.create("text",[v,m,f.labels[u]],f)}}else{s[0]=e.create("point",[o,0],z);s[1]=e.create("point",[o,v],z);s[2]=e.create("point",[k,v],z);s[3]=e.create("point",[k,0],z);if(JXG.exists(f.labels)&&JXG.exists(f.labels[u])){r=f.labels[u].toString().length;r=0.6*r*d/e.unitX;if(v>=0){v+=d*0.5/e.unitY}else{v-=d*1/e.unitY}q=e.create("text",[m-r*0.5,v,f.labels[u]],f)}}f.withlines=false;if(JXG.exists(f.colors)&&JXG.isArray(f.colors)){j=f.colors;f.fillcolor=j[u%j.length]}g[u]=e.create("polygon",s,f);if(JXG.exists(f.labels)&&JXG.exists(f.labels[u])){g[u].text=q}}return g},drawPoints:function(j,d,k,f){var g,h=[],e=f.infoboxarray;f.fixed=true;f.name="";for(g=0;g<d.length;g++){f.infoboxtext=e?e[g%e.length]:false;h[g]=j.create("point",[d[g],k[g]],f)}return h},drawPie:function(q,t,k){var l,g=[],h=[],x=JXG.Math.Statistics.sum(t),v=k.colors,m=k.highlightcolors,f=k.labels,e=k.radius||4,n=e,u=k.center||[0,0],w=u[0],o=u[1],d,j={fixed:true,withLabel:false,visible:false,name:""};if(!JXG.isArray(f)){f=[];for(l=0;l<t.length;l++){f[l]=""}}if(!JXG.isFunction(e)){n=function(){return e}}k.highlightonsector=k.highlightonsector||false;k.straightfirst=false;k.straightlast=false;d=q.create("point",[w,o],j);g[0]=q.create("point",[function(){return n()+w},function(){return o}],j);for(l=0;l<t.length;l++){g[l+1]=q.create("point",[(function(i){return function(){var z,y=0,r,p;for(r=0;r<=i;r++){y+=parseFloat(JXG.evaluate(t[r]))}z=y;for(r=i+1;r<t.length;r++){z+=parseFloat(JXG.evaluate(t[r]))}p=(z!=0)?(2*Math.PI*y/z):0;return n()*Math.cos(p)+w}})(l),(function(i){return function(){var z,y=0,r,p;for(r=0;r<=i;r++){y+=parseFloat(JXG.evaluate(t[r]))}z=y;for(r=i+1;r<t.length;r++){z+=parseFloat(JXG.evaluate(t[r]))}p=(z!=0)?(2*Math.PI*y/z):0;return n()*Math.sin(p)+o}})(l)],j);k.name=f[l];k.withlabel=k.name!="";k.fillcolor=v&&v[l%v.length];k.labelcolor=v&&v[l%v.length];k.highlightfillcolor=m&&m[l%m.length];h[l]=q.create("sector",[d,g[l],g[l+1]],k);if(k.highlightonsector){h[l].hasPoint=h[l].hasPointSector}if(k.highlightbysize){h[l].highlight=function(){this.board.renderer.highlight(this);var p=-this.point1.coords.usrCoords[1]+this.point2.coords.usrCoords[1],i=-this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[2];if(this.label.content!=null){this.label.content.rendNode.style.fontSize=(2*this.board.options.text.fontSize)+"px"}this.point2.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.point1.coords.usrCoords[1]+p*1.1,this.point1.coords.usrCoords[2]+i*1.1],this.board);this.prepareUpdate().update().updateRenderer()};h[l].noHighlight=function(){this.board.renderer.noHighlight(this);var p=-this.point1.coords.usrCoords[1]+this.point2.coords.usrCoords[1],i=-this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[2];if(this.label.content!=null){this.label.content.rendNode.style.fontSize=(this.board.options.text.fontSize)+"px"}this.point2.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.point1.coords.usrCoords[1]+p/1.1,this.point1.coords.usrCoords[2]+i/1.1],this.board);this.prepareUpdate().update().updateRenderer()}}}return{sectors:h,points:g,midpoint:d}},drawRadar:function(n,P,K){var Y,W,Z,M,ab,F,B=P.length,J,s,f,L,C,y,D,A,g,X,u,r,v,O,w,U,Q,E,d,m,e,T,l,N,q,S,ae,x,k,o,H,R,ad,z,h;if(B<=0){JXG.debug("No data");return}Z=K.paramarray;if(!JXG.exists(Z)){JXG.debug("Need paramArray attribute");return}M=Z.length;if(M<=1){JXG.debug("Need more than 1 param");return}for(Y=0;Y<B;Y++){if(M!=P[Y].length){JXG.debug("Use data length equal to number of params ("+P[Y].length+" != "+M+")");return}}ab=new Array(M);F=new Array(M);for(W=0;W<M;W++){ab[W]=P[0][W];F[W]=ab[W]}for(Y=1;Y<B;Y++){for(W=0;W<M;W++){if(P[Y][W]>ab[W]){ab[W]=P[Y][W]}if(P[Y][W]<F[W]){F[W]=P[Y][W]}}}J=new Array(B);s=new Array(B);for(Y=0;Y<B;Y++){J[Y]="";s[Y]=[]}f=new Array(M);L=new Array(M);C=K.startshiftratio||0;y=K.endshiftratio||0;for(Y=0;Y<M;Y++){f[Y]=(ab[Y]-F[Y])*C;L[Y]=(ab[Y]-F[Y])*y}D=K.startshiftarray||f;A=K.endshiftarray||L;g=K.startarray||F;if(JXG.exists(K.start)){for(Y=0;Y<M;Y++){g[Y]=K.start}}X=K.endarray||ab;if(JXG.exists(K.end)){for(Y=0;Y<M;Y++){X[Y]=K.end}}if(D.length!=M){JXG.debug("Start shifts length is not equal to number of parameters");return}if(A.length!=M){JXG.debug("End shifts length is not equal to number of parameters");return}if(g.length!=M){JXG.debug("Starts length is not equal to number of parameters");return}if(X.length!=M){JXG.debug("Ends length is not equal to number of parameters");return}u=K.labelarray||J;r=K.colors;v=K.highlightcolors;O=K.radius||10;w={};if(!JXG.exists(K.highlightonsector)){K.highlightonsector=false}w.name=K.name;w.id=K.id;w.strokewidth=K.strokewidth||1;w.polystrokewidth=K.polystrokewidth||2*w.strokewidth;w.strokecolor=K.strokecolor||"black";w.straightfirst=false;w.straightlast=false;w.fillcolor=K.fillcolor||"#FFFF88";w.fillopacity=K.fillopacity||0.4;w.highlightfillcolor=K.highlightfillcolor||"#FF7400";w.highlightstrokecolor=K.highlightstrokecolor||"black";w.gradient=K.gradient||"none";U=K.center||[0,0];Q=U[0];E=U[1];d=n.create("point",[Q,E],{name:"",fixed:true,withlabel:false,visible:false});m=Math.PI/2-Math.PI/M;if(K.startangle||K.startangle===0){m=K.startangle}e=m;T=[];l=[];var V=function(){var j,i,t,p,af=[].concat(this.labelOffsets);j=this.point1.X();i=this.point2.X();t=this.point1.Y();p=this.point2.Y();if(i<j){af[0]=-af[0]}if(p<t){af[1]=-af[1]}this.setLabelRelativeCoords(af);return new JXG.Coords(JXG.COORDS_BY_USER,[this.point2.X(),this.point2.Y()],this.board)};var I=function(ah,p){var j;var ag;var af;j=n.create("transform",[-(g[p]-D[p]),0],{type:"translate"});ag=n.create("transform",[O/((X[p]+A[p])-(g[p]-D[p])),1],{type:"scale"});j.melt(ag);af=n.create("transform",[ah],{type:"rotate"});j.melt(af);return j};for(Y=0;Y<M;Y++){e+=2*Math.PI/M;q=O*Math.cos(e)+Q;S=O*Math.sin(e)+E;T[Y]=n.create("point",[q,S],{name:"",fixed:true,withlabel:false,visible:false});l[Y]=n.create("line",[d,T[Y]],{name:Z[Y],strokeColor:w.strokecolor,strokeWidth:w.strokewidth,strokeOpacity:1,straightFirst:false,straightLast:false,withLabel:true,highlightStrokeColor:w.highlightstrokecolor});l[Y].getLabelAnchor=V;N=I(e,Y);for(W=0;W<P.length;W++){var ac=P[W][Y];s[W][Y]=n.create("point",[ac,0],{name:"",fixed:true,withlabel:false,visible:false});s[W][Y].addTransform(s[W][Y],N)}}ae=new Array(B);for(Y=0;Y<B;Y++){w.labelcolor=r&&r[Y%r.length];w.strokecolor=r&&r[Y%r.length];w.fillcolor=r&&r[Y%r.length];ae[Y]=n.create("polygon",s[Y],{withLines:true,withLabel:false,fillColor:w.fillcolor,fillOpacity:w.fillopacity});for(W=0;W<M;W++){ae[Y].borders[W].setProperty("strokecolor:"+r[Y%r.length]);ae[Y].borders[W].setProperty("strokewidth:"+w.polystrokewidth)}}x=K.legendposition||"none";switch(x){case"right":var G=K.legendleftoffset||2;var aa=K.legendtopoffset||1;this.legend=n.create("legend",[Q+O+G,E+O-aa],{labelArray:u,colorArray:r});break;case"none":break;default:JXG.debug("Unknown legend position")}k=[];if(K.showcircles!=false){o=[];for(Y=0;Y<6;Y++){o[Y]=20*Y}o[0]="0";H=K.circlelabelarray||o;R=H.length;if(R<2){alert("Too less circles");return}ad=[];z=m+Math.PI/M;N=I(z,0);w.fillcolor="none";w.highlightfillcolor="none";w.strokecolor=K.strokecolor||"black";w.strokewidth=K.circlestrokewidth||0.5;h=(X[0]-g[0])/(R-1);for(Y=0;Y<R;Y++){ad[Y]=n.create("point",[g[0]+Y*h,0],{name:H[Y],size:0,withLabel:true,visible:true});ad[Y].addTransform(ad[Y],N);k[Y]=n.create("circle",[d,ad[Y]],w)}}this.rendNode=ae[0].rendNode;return{circles:k,lines:l,points:s,midpoint:d,polygons:ae}},updateRenderer:function(){return this},update:function(){if(this.needsUpdate){this.updateDataArray()}return this},updateDataArray:function(){}});JXG.createChart=function(g,u,h){if((u.length==1)&&(typeof u[0]=="string")){var t=document.getElementById(u[0]),A,f,q,p,e,s=[],l,k,z,y,B,n,d,o,v,r,m;if(JXG.exists(t)){m=JXG.copyAttributes(h,g.options,"chart");t=(new JXG.DataSource()).loadFromTable(u[0],m.withheaders,m.withheaders);A=t.data;e=t.columnHeaders;f=t.rowHeaders;y=m.width;B=m.name;n=m.strokecolor;d=m.fillcolor;o=m.highlightstrokecolor;v=m.highlightfillcolor;g.suspendUpdate();r=A.length;z=[];if(m.rows&&JXG.isArray(m.rows)){for(q=0;q<r;q++){for(p=0;p<m.rows.length;p++){if((m.rows[p]==q)||(m.withheaders&&m.rows[p]==f[q])){z.push(A[q]);break}}}}else{z=A}r=z.length;for(q=0;q<r;q++){k=[];if(m.chartstyle&&m.chartstyle.indexOf("bar")!=-1){if(y){l=y}else{l=0.8}k.push(1-l/2+(q+0.5)*l/(1*r));for(p=1;p<z[q].length;p++){k.push(k[p-1]+1)}m.width=l/(1*r)}if(B&&B.length==r){m.name=B[q]}else{if(m.withheaders){m.name=e[q]}}if(n&&n.length==r){m.strokecolor=n[q]}else{m.strokecolor=JXG.hsv2rgb(((q+1)/(1*r))*360,0.9,0.6)}if(d&&d.length==r){m.fillcolor=d[q]}else{m.fillcolor=JXG.hsv2rgb(((q+1)/(1*r))*360,0.9,1)}if(o&&o.length==r){m.highlightstrokecolor=o[q]}else{m.highlightstrokecolor=JXG.hsv2rgb(((q+1)/(1*r))*360,0.9,1)}if(v&&v.length==r){m.highlightfillcolor=v[q]}else{m.highlightfillcolor=JXG.hsv2rgb(((q+1)/(1*r))*360,0.9,0.6)}if(m.chartstyle&&m.chartstyle.indexOf("bar")!=-1){s.push(new JXG.Chart(g,[k,z[q]],m))}else{s.push(new JXG.Chart(g,[z[q]],m))}}g.unsuspendUpdate()}return s}else{m=JXG.copyAttributes(h,g.options,"chart");return new JXG.Chart(g,u,m)}};JXG.JSXGraph.registerElement("chart",JXG.createChart);JXG.Legend=function(f,g,e){var d;this.constructor();d=JXG.copyAttributes(e,f.options,"legend");this.board=f;this.coords=new JXG.Coords(JXG.COORDS_BY_USER,g,this.board);this.myAtts={};this.label_array=d.labelarray||d.labels;this.color_array=d.colorarray||d.colors;this.lines=[];this.myAtts.strokewidth=d.strokewidth||5;this.myAtts.straightfirst=false;this.myAtts.straightlast=false;this.myAtts.withlabel=true;this.style=d.legendstyle||d.style;switch(this.style){case"vertical":this.drawVerticalLegend(f,d);break;default:throw new Error("JSXGraph: Unknown legend style: "+this.style);break}};JXG.Legend.prototype=new JXG.GeometryElement;JXG.Legend.prototype.drawVerticalLegend=function(h,f){var e=f.linelength||1,d=(f.rowheight||20)/this.board.unitY,g;for(g=0;g<this.label_array.length;g++){this.myAtts.strokecolor=this.color_array[g];this.myAtts.highlightstrokecolor=this.color_array[g];this.myAtts.name=this.label_array[g];this.myAtts.labeloffsets=[10,0];this.lines[g]=h.create("line",[[this.coords.usrCoords[1],this.coords.usrCoords[2]-g*d],[this.coords.usrCoords[1]+e,this.coords.usrCoords[2]-g*d]],this.myAtts);this.lines[g].getLabelAnchor=function(){this.setLabelRelativeCoords(this.labelOffsets);return new JXG.Coords(JXG.COORDS_BY_USER,[this.point2.X(),this.point2.Y()],this.board)}}};JXG.createLegend=function(f,e,d){var g=[0,0];if(JXG.exists(e)){if(e.length==2){g=e}}return new JXG.Legend(f,g,d)};JXG.JSXGraph.registerElement("legend",JXG.createLegend);JXG.Transformation=function(e,d,f){this.elementClass=JXG.OBJECT_CLASS_OTHER;this.matrix=[[1,0,0],[0,1,0],[0,0,1]];this.board=e;this.isNumericMatrix=false;this.setMatrix(e,d,f)};JXG.Transformation.prototype={};JXG.extend(JXG.Transformation.prototype,{update:function(){return this},setMatrix:function(f,e,g){var d;this.isNumericMatrix=true;for(d=0;d<g.length;d++){if(typeof g[d]!="number"){this.isNumericMatrix=false;break}}if(e=="translate"){this.evalParam=JXG.createEvalFunction(f,g,2);this.update=function(){this.matrix[1][0]=this.evalParam(0);this.matrix[2][0]=this.evalParam(1)}}else{if(e=="scale"){this.evalParam=JXG.createEvalFunction(f,g,2);this.update=function(){this.matrix[1][1]=this.evalParam(0);this.matrix[2][2]=this.evalParam(1)}}else{if(e=="reflect"){if(g.length<4){g[0]=JXG.getReference(f,g[0])}if(g.length==2){g[1]=JXG.getReference(f,g[1])}if(g.length==4){this.evalParam=JXG.createEvalFunction(f,g,4)}this.update=function(){var h,l,i,k,j;if(g.length==1){h=g[0].point2.X()-g[0].point1.X();l=g[0].point2.Y()-g[0].point1.Y();i=g[0].point1.X();k=g[0].point1.Y()}else{if(g.length==2){h=g[1].X()-g[0].X();l=g[1].Y()-g[0].Y();i=g[0].X();k=g[0].Y()}else{if(g.length==4){h=this.evalParam(2)-this.evalParam(0);l=this.evalParam(3)-this.evalParam(1);i=this.evalParam(0);k=this.evalParam(1)}}}j=h*h+l*l;this.matrix[1][1]=(h*h-l*l)/j;this.matrix[1][2]=2*h*l/j;this.matrix[2][1]=2*h*l/j;this.matrix[2][2]=(-h*h+l*l)/j;this.matrix[1][0]=i*(1-this.matrix[1][1])-k*this.matrix[1][2];this.matrix[2][0]=k*(1-this.matrix[2][2])-i*this.matrix[2][1]}}else{if(e=="rotate"){if(g.length==3){this.evalParam=JXG.createEvalFunction(f,g,3)}else{if(g.length<=2){this.evalParam=JXG.createEvalFunction(f,g,1);if(g.length==2){g[1]=JXG.getReference(f,g[1])}}}this.update=function(){var j=this.evalParam(0),h,l,k=Math.cos(j),i=Math.sin(j);this.matrix[1][1]=k;this.matrix[1][2]=-i;this.matrix[2][1]=i;this.matrix[2][2]=k;if(g.length>1){if(g.length==3){h=this.evalParam(1);l=this.evalParam(2)}else{h=g[1].X();l=g[1].Y()}this.matrix[1][0]=h*(1-k)+l*i;this.matrix[2][0]=l*(1-k)-h*i}}}else{if(e=="shear"){this.evalParam=JXG.createEvalFunction(f,g,1);this.update=function(){var h=this.evalParam(0);this.matrix[1][1]=Math.tan(h)}}else{if(e=="generic"){this.evalParam=JXG.createEvalFunction(f,g,9);this.update=function(){this.matrix[0][0]=this.evalParam(0);this.matrix[0][1]=this.evalParam(1);this.matrix[0][2]=this.evalParam(2);this.matrix[1][0]=this.evalParam(3);this.matrix[1][1]=this.evalParam(4);this.matrix[1][2]=this.evalParam(5);this.matrix[2][0]=this.evalParam(6);this.matrix[2][1]=this.evalParam(7);this.matrix[2][2]=this.evalParam(8)}}}}}}}},apply:function(d){this.update();if(arguments[1]!=null){return JXG.Math.matVecMult(this.matrix,d.initialCoords.usrCoords)}else{return JXG.Math.matVecMult(this.matrix,d.coords.usrCoords)}},applyOnce:function(f){var g,d,e;if(!JXG.isArray(f)){this.update();g=JXG.Math.matVecMult(this.matrix,f.coords.usrCoords);f.coords.setCoordinates(JXG.COORDS_BY_USER,[g[1],g[2]])}else{d=f.length;for(e=0;e<d;e++){this.update();g=JXG.Math.matVecMult(this.matrix,f[e].coords.usrCoords);f[e].coords.setCoordinates(JXG.COORDS_BY_USER,[g[1],g[2]])}}},bindTo:function(f){var e,d;if(JXG.isArray(f)){d=f.length;for(e=0;e<d;e++){f[e].transformations.push(this)}}else{f.transformations.push(this)}},setProperty:function(d){},melt:function(m){var l=[],h,d,g,e,n,f;d=m.matrix.length;g=this.matrix[0].length;for(h=0;h<d;h++){l[h]=[]}this.update();m.update();for(h=0;h<d;h++){for(f=0;f<g;f++){n=0;for(e=0;e<d;e++){n+=m.matrix[h][e]*this.matrix[e][f]}l[h][f]=n}}this.update=function(){var i=this.matrix.length,j=this.matrix[0].length;for(h=0;h<i;h++){for(f=0;f<j;f++){this.matrix[h][f]=l[h][f]}}};return true}});JXG.createTransform=function(d,f,e){return new JXG.Transformation(d,e.type,f)};JXG.JSXGraph.registerElement("transform",JXG.createTransform);JXG.Turtle=function(h,g,e){this.constructor(h,e,JXG.OBJECT_TYPE_TURTLE,JXG.OBJECT_CLASS_OTHER);var d,i,f;this.turtleIsHidden=false;this.board=h;this.attributes=JXG.checkAttributes(e,{withLabel:false,layer:null});this.attributes.straightFirst=false;this.attributes.straightLast=false;d=0;i=0;f=90;if(g.length!=0){if(g.length==3){d=g[0];i=g[1];f=g[2]}else{if(g.length==2){if(JXG.isArray(g[0])){d=g[0][0];i=g[0][1];f=g[1]}else{d=g[0];i=g[1]}}else{d=g[0][0];i=g[0][1]}}}this.init(d,i,f);return this};JXG.Turtle.prototype=new JXG.GeometryElement;JXG.extend(JXG.Turtle.prototype,{init:function(d,g,f){this.arrowLen=20/Math.sqrt(this.board.unitX*this.board.unitX+this.board.unitY*this.board.unitY);this.pos=[d,g];this.isPenDown=true;this.dir=90;this.stack=[];this.objects=[];this.attributes.curveType="plot";this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);this.turtle=this.board.create("point",this.pos,{fixed:true,name:" ",visible:false,withLabel:false});this.objects.push(this.turtle);this.turtle2=this.board.create("point",[this.pos[0],this.pos[1]+this.arrowLen],{fixed:true,name:" ",visible:false,withLabel:false});this.objects.push(this.turtle2);var e=this.attributes.strokeWidth||this.attributes.strokewidth||2;this.arrow=this.board.create("line",[this.turtle,this.turtle2],{strokeColor:"#ff0000",straightFirst:false,straightLast:false,strokeWidth:e,withLabel:false,lastArrow:true});this.objects.push(this.arrow);this.right(90-f);this.board.update()},forward:function(d){if(d===0){return this}var f=d*Math.cos(this.dir*Math.PI/180),e=d*Math.sin(this.dir*Math.PI/180);if(!this.turtleIsHidden){var g=this.board.create("transform",[f,e],{type:"translate"});g.applyOnce(this.turtle);g.applyOnce(this.turtle2)}if(this.isPenDown){if(this.curve.dataX.length>=8192){this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve)}}this.pos[0]+=f;this.pos[1]+=e;if(this.isPenDown){this.curve.dataX.push(this.pos[0]);this.curve.dataY.push(this.pos[1])}this.board.update();return this},back:function(d){return this.forward(-d)},right:function(e){this.dir-=e;this.dir%=360;if(!this.turtleIsHidden){var d=this.board.create("transform",[-e*Math.PI/180,this.turtle],{type:"rotate"});d.applyOnce(this.turtle2)}this.board.update();return this},left:function(d){return this.right(-d)},penUp:function(){this.isPenDown=false;return this},penDown:function(){this.isPenDown=true;this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this},clean:function(){for(var d=0;d<this.objects.length;d++){var e=this.objects[d];if(e.type==JXG.OBJECT_TYPE_CURVE){this.board.removeObject(e.id);this.objects.splice(d,1)}}this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);this.board.update();return this},clearScreen:function(){for(var d=0;d<this.objects.length;d++){var e=this.objects[d];this.board.removeObject(e.id)}this.init(0,0,90);return this},setPos:function(d,f){if(JXG.isArray(d)){this.pos=d}else{this.pos=[d,f]}if(!this.turtleIsHidden){this.turtle.setPositionDirectly(JXG.COORDS_BY_USER,d,f);this.turtle2.setPositionDirectly(JXG.COORDS_BY_USER,d,f+this.arrowLen);var e=this.board.create("transform",[-(this.dir-90)*Math.PI/180,this.turtle],{type:"rotate"});e.applyOnce(this.turtle2)}this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);this.board.update();return this},setPenSize:function(d){this.attributes.strokeWidth=d;this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this},setPenColor:function(d){this.attributes.strokeColor=d;this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this},setHighlightPenColor:function(d){this.attributes.highlightStrokeColor=d;this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this},setProperty:function(){var h;var d;var f,g;var e;for(f=0;f<arguments.length;f++){d=arguments[f];if(typeof d=="string"){h=d.split(":")}else{if(!JXG.isArray(d)){for(var e in d){this.setProperty([e,d[e]])}return this}else{h=d}}this.attributes[h[0]]=h[1]}for(f=0;f<this.objects.length;f++){g=this.objects[f];if(g.type==JXG.OBJECT_TYPE_CURVE){g.setProperty(this.attributes)}}return this},showTurtle:function(){this.turtleIsHidden=false;this.arrow.setProperty("visible:true");this.setPos(this.pos[0],this.pos[1]);this.board.update();return this},hideTurtle:function(){this.turtleIsHidden=true;this.arrow.setProperty("visible:false");this.setPos(this.pos[0],this.pos[1]);this.board.update();return this},home:function(){this.pos=[0,0];this.setPos(this.pos[0],this.pos[1]);return this},pushTurtle:function(){this.stack.push([this.pos[0],this.pos[1],this.dir]);return this},popTurtle:function(){var d=this.stack.pop();this.pos[0]=d[0];this.pos[1]=d[1];this.dir=d[2];this.setPos(this.pos[0],this.pos[1]);return this},lookTo:function(h){if(JXG.isArray(h)){var e=this.pos[0];var d=this.pos[1];var i=h[0];var g=h[1];var f;f=Math.atan2(g-d,i-e);this.right(this.dir-(f*180/Math.PI))}else{if(JXG.isNumber(h)){this.right(this.dir-(h))}}return this},moveTo:function(g){if(JXG.isArray(g)){var e=g[0]-this.pos[0];var d=g[1]-this.pos[1];if(!this.turtleIsHidden){var f=this.board.create("transform",[e,d],{type:"translate"});f.applyOnce(this.turtle);f.applyOnce(this.turtle2)}if(this.isPenDown){if(this.curve.dataX.length>=8192){this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve)}}this.pos[0]=g[0];this.pos[1]=g[1];if(this.isPenDown){this.curve.dataX.push(this.pos[0]);this.curve.dataY.push(this.pos[1])}this.board.update()}return this},fd:function(d){return this.forward(d)},bk:function(d){return this.back(d)},lt:function(d){return this.left(d)},rt:function(d){return this.right(d)},pu:function(){return this.penUp()},pd:function(){return this.penDown()},ht:function(){return this.hideTurtle()},st:function(){return this.showTurtle()},cs:function(){return this.clearScreen()},push:function(){return this.pushTurtle()},pop:function(){return this.popTurtle()},X:function(d){return this.pos[0]},Y:function(d){return this.pos[1]},hasPoint:function(d,g){var e,f;for(e=0;e<this.objects.length;e++){f=this.objects[e];if(f.type==JXG.OBJECT_TYPE_CURVE){if(f.hasPoint(d,g)){return true}}}return false}});JXG.createTurtle=function(f,e,d){e=e||[];return new JXG.Turtle(f,e,d)};JXG.JSXGraph.registerElement("turtle",JXG.createTurtle);JXG.rgbParser=function(){if(arguments.length==0){return[0,0,0]}if(arguments.length>=3){arguments[0]=[arguments[0],arguments[1],arguments[2]];arguments.length=1}var n=arguments[0];if(JXG.isArray(n)){var e=false,j;for(j=0;j<3;j++){e|=/\./.test(arguments[0][j].toString())}for(j=0;j<3;j++){e&=(arguments[0][j]>=0)&(arguments[0][j]<=1)}if(e){return[Math.ceil(arguments[0][0]*255),Math.ceil(arguments[0][1]*255),Math.ceil(arguments[0][2]*255)]}else{arguments[0].length=3;return arguments[0]}}else{if(typeof arguments[0]=="string"){n=arguments[0]}}var d,l,o;if(n.charAt(0)=="#"){n=n.substr(1,6)}n=n.replace(/ /g,"");n=n.toLowerCase();var h={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"};for(var p in h){if(n==p){n=h[p]}}var m=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,example:["rgb(123, 234, 45)","rgb(255,234,245)"],process:function(g){return[parseInt(g[1]),parseInt(g[2]),parseInt(g[3])]}},{re:/^(\w{2})(\w{2})(\w{2})$/,example:["#00ff00","336699"],process:function(g){return[parseInt(g[1],16),parseInt(g[2],16),parseInt(g[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,example:["#fb0","f0f"],process:function(g){return[parseInt(g[1]+g[1],16),parseInt(g[2]+g[2],16),parseInt(g[3]+g[3],16)]}}];for(var j=0;j<m.length;j++){var s=m[j].re,f=m[j].process,q=s.exec(n),k;if(q){k=f(q);d=k[0];l=k[1];o=k[2]}}d=(d<0||isNaN(d))?0:((d>255)?255:d);l=(l<0||isNaN(l))?0:((l>255)?255:l);o=(o<0||isNaN(o))?0:((o>255)?255:o);return[d,l,o]};JXG.rgb2css=function(){var f,e,d;f=JXG.rgbParser.apply(JXG.rgbParser,arguments);e=f[1];d=f[2];f=f[0];return"rgb("+f+", "+e+", "+d+")"};JXG.rgb2hex=function(){var f,e,d;f=JXG.rgbParser.apply(JXG.rgbParser,arguments);e=f[1];d=f[2];f=f[0];f=f.toString(16);e=e.toString(16);d=d.toString(16);if(f.length==1){f="0"+f}if(e.length==1){e="0"+e}if(d.length==1){d="0"+d}return"#"+f+e+d};JXG.hsv2rgb=function(o,k,j){var l,r,g,n,m,h,e,d,s;o=((o%360)+360)%360;if(k==0){if(isNaN(o)||o<JXG.Math.eps){l=j;r=j;g=j}else{return"#ffffff"}}else{if(o>=360){h=0}else{h=o}h=h/60;m=Math.floor(h);n=h-m;e=j*(1-k);d=j*(1-(k*n));s=j*(1-(k*(1-n)));switch(m){case 0:l=j;r=s;g=e;break;case 1:l=d;r=j;g=e;break;case 2:l=e;r=j;g=s;break;case 3:l=e;r=d;g=j;break;case 4:l=s;r=e;g=j;break;case 5:l=j;r=e;g=d;break}}l=Math.round(l*255).toString(16);l=(l.length==2)?l:((l.length==1)?"0"+l:"00");r=Math.round(r*255).toString(16);r=(r.length==2)?r:((r.length==1)?"0"+r:"00");g=Math.round(g*255).toString(16);g=(g.length==2)?g:((g.length==1)?"0"+g:"00");return["#",l,r,g].join("")};JXG.rgb2hsv=function(){var d,m,p,n,e,i,f,q,l,u,t,o,j,k;d=JXG.rgbParser.apply(JXG.rgbParser,arguments);m=d[1];p=d[2];d=d[0];k=JXG.Math.Statistics;n=d/255;e=m/255;i=p/255;o=k.max([d,m,p]);j=k.min([d,m,p]);f=o/255;q=j/255;t=f;u=0;if(t>0){u=(t-q)/(t*1)}l=1/(f-q);if(u>0){if(o==d){l=(e-i)*l}else{if(o==m){l=2+(i-n)*l}else{l=4+(n-e)*l}}}l*=60;if(l<0){l+=360}if(o==j){l=0}return[l,u,t]};JXG.rgb2LMS=function(){var n,k,e,f,d,j,i,h=[[0.05059983,0.08585369,0.0095242],[0.01893033,0.08925308,0.01370054],[0.00292202,0.00975732,0.07145979]];n=JXG.rgbParser.apply(JXG.rgbParser,arguments);k=n[1];e=n[2];n=n[0];n=Math.pow(n,0.476190476);k=Math.pow(k,0.476190476);e=Math.pow(e,0.476190476);f=n*h[0][0]+k*h[0][1]+e*h[0][2];d=n*h[1][0]+k*h[1][1]+e*h[1][2];j=n*h[2][0]+k*h[2][1]+e*h[2][2];i=[f,d,j];i.l=f;i.m=d;i.s=j;return i};JXG.LMS2rgb=function(f,e,o){var d,h,j,i,k=[[30.830854,-29.832659,1.610474],[-6.481468,17.715578,-2.532642],[-0.37569,-1.199062,14.273846]];d=f*k[0][0]+e*k[0][1]+o*k[0][2];h=f*k[1][0]+e*k[1][1]+o*k[1][2];j=f*k[2][0]+e*k[2][1]+o*k[2][2];var n=function(l){var m=127,g=64;while(g>0){if(Math.pow(m,0.476190476)>l){m-=g}else{if(Math.pow(m+1,0.476190476)>l){return m}m+=g}g/=2}if(m==254&&13.994955247<l){return 255}return m};d=n(d);h=n(h);j=n(j);i=[d,h,j];i.r=d;i.g=h;i.b=j;return i};JXG.rgba2rgbo=function(e){var d;if(e.length==9&&e.charAt(0)=="#"){d=parseInt(e.substr(7,2).toUpperCase(),16)/255;e=e.substr(0,7)}else{d=1}return[e,d]};JXG.rgb2bw=function(f){if(f=="none"){return f}var e,h="0123456789ABCDEF",g,d;d=JXG.rgbParser(f);e=0.3*d[0]+0.59*d[1]+0.11*d[2];g=h.charAt((e>>4)&15)+h.charAt(e&15);f="#"+g+""+g+""+g;return f};JXG.rgb2cb=function(i,p){if(i=="none"){return i}var r,h,g,v,q,n,f,u,k,e,t,j,o;q=JXG.rgb2LMS(i);h=q.l;g=q.m;v=q.s;p=p.toLowerCase();switch(p){case"protanopia":f=-0.06150039994295001;u=0.08277001656812001;k=-0.013200141220000003;e=0.05858939668799999;t=-0.07934519995360001;j=0.013289415272000003;o=0.6903216543277437;n=v/g;if(n<o){h=-(u*g+k*v)/f}else{h=-(t*g+j*v)/e}break;case"tritanopia":f=-0.00058973116217;u=0.007690316482;k=-0.01011703519052;e=0.025495080838999994;t=-0.0422740347;j=0.017005316784;o=0.8349489908460004;n=g/h;if(n<o){v=-(f*h+u*g)/k}else{v=-(e*h+t*g)/j}break;default:f=-0.06150039994295001;u=0.08277001656812001;k=-0.013200141220000003;e=0.05858939668799999;t=-0.07934519995360001;j=0.013289415272000003;o=0.5763833686400911;n=v/h;if(n<o){g=-(f*h+k*v)/u}else{g=-(e*h+j*v)/t}break}r=JXG.LMS2rgb(h,g,v);var d="0123456789ABCDEF";n=d.charAt((r.r>>4)&15)+d.charAt(r.r&15);i="#"+n;n=d.charAt((r.g>>4)&15)+d.charAt(r.g&15);i+=n;n=d.charAt((r.b>>4)&15)+d.charAt(r.b&15);i+=n;return i};JXG.extend(JXG.Board.prototype,{angle:function(d,f,e){return JXG.Math.Geometry.angle(d,f,e)},rad:function(d,f,e){return JXG.Math.Geometry.rad(d,f,e)},distance:function(e,d){return JXG.Math.Geometry.distance(e,d)},pow:function(e,d){return JXG.Math.pow(e,d)},round:function(d,e){return(d).toFixed(e)},cosh:function(d){return JXG.Math.cosh(d)},sinh:function(d){return JXG.Math.sinh(d)},sgn:function(d){return(d==0?0:d/(Math.abs(d)))},D:function(d,e){return JXG.Math.Numerics.D(d,e)},I:function(d,e){return JXG.Math.Numerics.I(d,e)},root:function(e,d,g){return JXG.Math.Numerics.root(e,d,g)},lagrangePolynomial:function(d){return JXG.Math.Numerics.lagrangePolynomial(d)},neville:function(d){return JXG.Math.Numerics.Neville(d)},riemannsum:function(g,i,e,h,d){return JXG.Math.Numerics.riemannsum(g,i,e,h,d)},abs:Math.abs,acos:Math.acos,asin:Math.asin,atan:Math.atan,ceil:Math.ceil,cos:Math.cos,exp:Math.exp,floor:Math.floor,log:Math.log,max:Math.max,min:Math.min,random:Math.random,sin:Math.sin,sqrt:Math.sqrt,tan:Math.tan,trunc:Math.ceil,factorial:function(d){return JXG.Math.factorial(d)},binomial:function(e,d){return JXG.Math.binomial(e,d)},getElement:function(d){return JXG.getReference(this,d)},intersectionOptions:["point",[[JXG.OBJECT_CLASS_LINE,JXG.OBJECT_CLASS_LINE],[JXG.OBJECT_CLASS_LINE,JXG.OBJECT_CLASS_CIRCLE],[JXG.OBJECT_CLASS_CIRCLE,JXG.OBJECT_CLASS_CIRCLE]]],intersection:function(g,e,f,d){g=JXG.getReference(this,g);e=JXG.getReference(this,e);if(g.elementClass==JXG.OBJECT_CLASS_CURVE&&e.elementClass==JXG.OBJECT_CLASS_CURVE){return function(){return JXG.Math.Geometry.meetCurveCurve(g,e,f,d,g.board)}}else{if((g.type==JXG.OBJECT_TYPE_ARC&&e.elementClass==JXG.OBJECT_CLASS_LINE)||(e.type==JXG.OBJECT_TYPE_ARC&&g.elementClass==JXG.OBJECT_CLASS_LINE)){return function(){return JXG.Math.Geometry.meet(g.stdform,e.stdform,f,g.board)}}else{if((g.elementClass==JXG.OBJECT_CLASS_CURVE&&e.elementClass==JXG.OBJECT_CLASS_LINE)||(e.elementClass==JXG.OBJECT_CLASS_CURVE&&g.elementClass==JXG.OBJECT_CLASS_LINE)){return function(){return JXG.Math.Geometry.meetCurveLine(g,e,f,g.board)}}else{return function(){return JXG.Math.Geometry.meet(g.stdform,e.stdform,f,g.board)}}}}},intersectionFunc:function(g,e,f,d){return this.intersection(g,e,f,d)},otherIntersection:function(e,d,f){e=JXG.getReference(this,e);d=JXG.getReference(this,d);return function(){var g=JXG.Math.Geometry.meet(e.stdform,d.stdform,0,e.board);if(Math.abs(f.X()-g.usrCoords[1])>JXG.Math.eps||Math.abs(f.Y()-g.usrCoords[2])>JXG.Math.eps||Math.abs(f.Z()-g.usrCoords[0])>JXG.Math.eps){return g}else{return JXG.Math.Geometry.meet(e.stdform,d.stdform,1,e.board)}}},pointFunc:function(){return[null]},pointOptions:["point",[[JXG.OBJECT_CLASS_POINT]]],lineFunc:function(){return arguments},lineOptions:["line",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],linesegmentFunc:function(){return arguments},linesegmentOptions:["line",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],linesegmentAtts:{straightFirst:false,straightLast:false},arrowFunc:function(){return arguments},arrowOptions:["arrow",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],circleFunc:function(){return arguments},circleOptions:["circle",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT],[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE],[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_CIRCLE]]],arrowparallelOptions:["arrowparallel",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]],arrowparallelFunc:function(){return arguments},bisectorOptions:["bisector",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],bisectorFunc:function(){return arguments},circumcircleOptions:["circumcircle",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],circumcircleFunc:function(){return arguments},circumcirclemidpointOptions:["circumcirclemidpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],circumcirclemidpointFunc:function(){return arguments},integralOptions:["integral",[[]]],integralFunc:function(){return arguments},midpointOptions:["midpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT],[JXG.OBJECT_CLASS_LINE]]],midpointFunc:function(){return arguments},mirrorpointOptions:["mirrorpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],mirrorpointFunc:function(){return arguments},normalOptions:["normal",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]],normalFunc:function(){return arguments},parallelOptions:["parallel",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]],parallelFunc:function(){return arguments},parallelpointOptions:["parallelpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],parallelpointFunc:function(){return arguments},perpendicularOptions:["perpendicular",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]],perpendicularFunc:function(){return arguments},perpendicularpointOptions:["perpendicularpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]],perpendicularpointFunc:function(){return arguments},reflectionOptions:["reflection",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]],reflectionFunc:function(){return arguments}});JXG.Point.prototype.setPositionX=function(f,d){var e=(f==JXG.COORDS_BY_USER)?this.coords.usrCoords[2]:this.coords.scrCoords[2];this.setPosition(f,d,e)};JXG.Point.prototype.setPositionY=function(f,e){var d=(f==JXG.COORDS_BY_USER)?this.coords.usrCoords[1]:this.coords.scrCoords[1];this.setPosition(f,d,e)};JXG.Ticks=function(d,f,e){this.constructor(d.board,e,JXG.OBJECT_TYPE_TICKS,JXG.OBJECT_CLASS_OTHER);this.line=d;this.board=this.line.board;this.ticksFunction=null;this.fixedTicks=null;this.equidistant=false;if(JXG.isFunction(f)){this.ticksFunction=f;throw new Error("Function arguments are no longer supported.")}else{if(JXG.isArray(f)){this.fixedTicks=f}else{if(Math.abs(f)<JXG.Math.eps){f=e.defaultdistance}this.ticksFunction=function(g){return f};this.equidistant=true}}this.minTicksDistance=e.minticksdistance;this.maxTicksDistance=e.maxticksdistance;this.labels=[];this.id=this.line.addTicks(this);this.board.setId(this,"Ti")};JXG.Ticks.prototype=new JXG.GeometryElement();JXG.extend(JXG.Ticks.prototype,{hasPoint:function(d,e){return false},calculateTicksCoordinates:function(){if(this.visProp.minorheight<0){this.visProp.minorheight=2*(this.board.canvasWidth+this.board.canvasHeight)}if(this.visProp.majorheight<0){this.visProp.majorheight=2*(this.board.canvasWidth+this.board.canvasHeight)}var h=this.line.point1,e=this.line.point2,x=h.coords.distance(JXG.COORDS_BY_USER,e.coords),K=(e.coords.usrCoords[1]-h.coords.usrCoords[1])/x,I=(e.coords.usrCoords[2]-h.coords.usrCoords[2])/x,p=h.coords.distance(JXG.COORDS_BY_SCREEN,new JXG.Coords(JXG.COORDS_BY_USER,[h.coords.usrCoords[1]+K,h.coords.usrCoords[2]+I],this.board)),E=(this.equidistant?this.ticksFunction(1):1),A=5,q,n,H,k,B,d,D,w,u=function(R,i,O,N,Q){var P,M;if(!N){return null}P=R.toString();if(Math.abs(R)<JXG.Math.eps){P="0"}if(P.length>5||P.indexOf("e")!=-1){P=R.toPrecision(3).toString()}if(P.indexOf(".")>-1){P=P.replace(/0+$/,"");P=P.replace(/\.$/,"")}M=JXG.createText(O,[i.usrCoords[1],i.usrCoords[2],P],{id:Q+D+"Label",isLabel:true,layer:O.options.layer.line,highlightStrokeColor:O.options.text.strokeColor,highlightStrokeWidth:O.options.text.strokeWidth,highlightStrokeOpacity:O.options.text.strokeOpacity});M.isDraggable=false;M.distanceX=4;M.distanceY=-parseInt(M.visProp.fontsize)+3;M.setCoords(i.usrCoords[1]+M.distanceX/(O.unitX),i.usrCoords[2]+M.distanceY/(O.unitY));M.visProp.visible=N;M.prepareUpdate().update().updateRenderer();return M},l=function(i){return Math.ceil(i/E)*E},y=JXG.Math.eps,t=-this.line.getSlope(),v=this.visProp.majorheight/2,j=this.visProp.minorheight/2,J=0,g=0,z=0,C=0;if(Math.abs(t)<y){J=0;g=v;z=0;C=j}else{if((Math.abs(t)>1/y)||(isNaN(t))){J=v;g=0;z=j;C=0}else{J=-v/Math.sqrt(1/(t*t)+1);g=J/t;z=-j/Math.sqrt(1/(t*t)+1);C=z/t}}this.removeTickLabels();this.ticks=new Array();this.labels=new Array();q=new JXG.Coords(JXG.COORDS_BY_USER,[h.coords.usrCoords[1],h.coords.usrCoords[2]],this.board);n=new JXG.Coords(JXG.COORDS_BY_USER,[e.coords.usrCoords[1],e.coords.usrCoords[2]],this.board);JXG.Math.Geometry.calcStraight(this.line,q,n);if(!this.equidistant){var s=h.coords.usrCoords[1]-q.usrCoords[1],o=h.coords.usrCoords[2]-q.usrCoords[2],L=Math.sqrt(s*s+o*o),m=h.coords.usrCoords[1]-n.usrCoords[1],r=h.coords.usrCoords[2]-n.usrCoords[2],f=Math.sqrt(m*m+r*r),G=0,F=0;for(D=0;D<this.fixedTicks.length;D++){if((-L<=this.fixedTicks[D])&&(this.fixedTicks[D]<=f)){if(this.fixedTicks[D]<0){G=Math.abs(s)*this.fixedTicks[D]/L;F=Math.abs(o)*this.fixedTicks[D]/L}else{G=Math.abs(m)*this.fixedTicks[D]/f;F=Math.abs(r)*this.fixedTicks[D]/f}B=new JXG.Coords(JXG.COORDS_BY_USER,[h.coords.usrCoords[1]+G,h.coords.usrCoords[2]+F],this.board);this.ticks.push(B);this.ticks[this.ticks.length-1].major=true;this.labels.push(u(this.fixedTicks[D],B,this.board,this.visProp.drawlabels,this.id))}}this.dxMaj=J;this.dyMaj=g;this.dxMin=z;this.dyMin=C;return}if(this.visProp.insertticks&&this.minTicksDistance>JXG.Math.eps){while(p>4*this.minTicksDistance){E/=10;p=h.coords.distance(JXG.COORDS_BY_SCREEN,new JXG.Coords(JXG.COORDS_BY_USER,[h.coords.usrCoords[1]+K*E,h.coords.usrCoords[2]+I*E],this.board))}while(p<this.minTicksDistance){E*=A;A=(A==5?2:5);p=h.coords.distance(JXG.COORDS_BY_SCREEN,new JXG.Coords(JXG.COORDS_BY_USER,[h.coords.usrCoords[1]+K*E,h.coords.usrCoords[2]+I*E],this.board))}}if(JXG.Math.Geometry.isSameDirection(h.coords,q,n)){H=h.coords.distance(JXG.COORDS_BY_USER,q);k=h.coords.distance(JXG.COORDS_BY_USER,n);if(JXG.Math.Geometry.isSameDirection(h.coords,e.coords,q)){if(this.line.visProp.straightfirst){H-=2*E}}else{k=-1*k;H=-1*H;if(this.line.visProp.straightfirst){H-=2*E}}if(H>k){D=H;H=k;k=D}H=l(H);if(this.line.visProp.straightlast){k+=2*E}}else{if(!this.line.visProp.straightfirst){H=0}else{H=-l(h.coords.distance(JXG.COORDS_BY_USER,q))}if(!this.line.visProp.straightlast){k=x}else{k=h.coords.distance(JXG.COORDS_BY_USER,n)}}d=new JXG.Coords(JXG.COORDS_BY_USER,[h.coords.usrCoords[1]+H*K,h.coords.usrCoords[2]+H*I],this.board);B=new JXG.Coords(JXG.COORDS_BY_USER,[h.coords.usrCoords[1]+H*K,h.coords.usrCoords[2]+H*I],this.board);K/=this.visProp.minorticks+1;I/=this.visProp.minorticks+1;D=0;w=H;while(d.distance(JXG.COORDS_BY_USER,B)<Math.abs(k-H)+JXG.Math.eps){if(D%(this.visProp.minorticks+1)===0){B.major=true;this.labels.push(u(w,B,this.board,this.visProp.drawlabels,this.id));w+=E}else{B.major=false;this.labels.push(null)}D++;this.ticks.push(B);B=new JXG.Coords(JXG.COORDS_BY_USER,[B.usrCoords[1]+K*E,B.usrCoords[2]+I*E],this.board);if(!this.visProp.drawzero&&B.distance(JXG.COORDS_BY_USER,h.coords)<=JXG.Math.eps){D++;w+=E;B=new JXG.Coords(JXG.COORDS_BY_USER,[B.usrCoords[1]+K*E,B.usrCoords[2]+I*E],this.board)}}this.dxMaj=J;this.dyMaj=g;this.dxMin=z;this.dyMin=C},removeTickLabels:function(){var d;if(this.ticks!=null){if((this.board.needsFullUpdate||this.needsRegularUpdate)&&!(this.board.options.renderer=="canvas"&&this.board.options.text.display=="internal")){for(d=0;d<this.ticks.length;d++){if(this.labels[d]!=null&&this.labels[d].visProp.visible){this.board.removeObject(this.labels[d])}}}}},update:function(){if(this.needsUpdate){this.calculateTicksCoordinates()}return this},updateRenderer:function(){if(this.needsUpdate){if(this.ticks){this.board.renderer.updateTicks(this,this.dxMaj,this.dyMaj,this.dxMin,this.dyMin)}this.needsUpdate=false}return this},hideElement:function(){var d;this.visProp.visible=false;this.board.renderer.hide(this);for(d=0;d<this.labels.length;d++){if(JXG.exists(this.labels[d])){this.labels[d].hideElement()}}return this},showElement:function(){var d;this.visProp.visible=true;this.board.renderer.show(this);for(d=0;d<this.labels.length;d++){if(JXG.exists(this.labels[d])){this.labels[d].showElement()}}return this}});JXG.createTicks=function(h,f,e){var g,i,d=JXG.copyAttributes(e,h.options,"ticks");if(f.length<2){i=e.ticksDistance}else{i=f[1]}if((f[0].elementClass==JXG.OBJECT_CLASS_LINE)&&(JXG.isFunction(f[1])||JXG.isArray(f[1])||JXG.isNumber(f[1]))){g=new JXG.Ticks(f[0],i,d)}else{throw new Error("JSXGraph: Can't create Ticks with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"'.")}return g};JXG.JSXGraph.registerElement("ticks",JXG.createTicks);JXG.Util={};JXG.Util.Unzip=function(T){var p=[],G="",E=false,B,H=0,Q=[],t,k=new Array(32768),Y=0,L=false,V,I,X=[0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253,3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243,11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251,7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247,15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255],ab=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],S=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,99,99],M=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577],A=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],q=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],x=T,e=0,j=0,ac=1,d=0,aa=256,i=[],m;function g(){d+=8;if(e<x.length){return x[e++]}else{return -1}}function r(){ac=1}function W(){var ae;d++;ae=(ac&1);ac>>=1;if(ac==0){ac=g();ae=(ac&1);ac=(ac>>1)|128}return ae}function U(ae){var ag=0,af=ae;while(af--){ag=(ag<<1)|W()}if(ae){ag=X[ag]>>(8-ae)}return ag}function f(){Y=0}function y(ae){I++;k[Y++]=ae;p.push(String.fromCharCode(ae));if(Y==32768){Y=0}}function o(){this.b0=0;this.b1=0;this.jump=null;this.jumppos=-1}var h=288;var w=new Array(h);var O=new Array(32);var J=0;var Z=null;var s=null;var N=new Array(64);var K=new Array(64);var z=0;var D=new Array(17);D[0]=0;var P;var v;function l(){while(1){if(D[z]>=v){return -1}if(P[D[z]]==z){return D[z]++}D[z]++}}function F(){var af=Z[J];var ae;if(E){document.write("<br>len:"+z+" treepos:"+J)}if(z==17){return -1}J++;z++;ae=l();if(E){document.write("<br>IsPat "+ae)}if(ae>=0){af.b0=ae;if(E){document.write("<br>b0 "+af.b0)}}else{af.b0=32768;if(E){document.write("<br>b0 "+af.b0)}if(F()){return -1}}ae=l();if(ae>=0){af.b1=ae;if(E){document.write("<br>b1 "+af.b1)}af.jump=null}else{af.b1=32768;if(E){document.write("<br>b1 "+af.b1)}af.jump=Z[J];af.jumppos=J;if(F()){return -1}}z--;return 0}function n(ai,ag,aj,af){var ah;if(E){document.write("currentTree "+ai+" numval "+ag+" lengths "+aj+" show "+af)}Z=ai;J=0;P=aj;v=ag;for(ah=0;ah<17;ah++){D[ah]=0}z=0;if(F()){if(E){alert("invalid huffman tree\n")}return -1}if(E){document.write("<br>Tree: "+Z.length);for(var ae=0;ae<32;ae++){document.write("Places["+ae+"].b0="+Z[ae].b0+"<br>");document.write("Places["+ae+"].b1="+Z[ae].b1+"<br>")}}return 0}function C(ah){var af,ag,aj=0,ai=ah[aj],ae;while(1){ae=W();if(E){document.write("b="+ae)}if(ae){if(!(ai.b1&32768)){if(E){document.write("ret1")}return ai.b1}ai=ai.jump;af=ah.length;for(ag=0;ag<af;ag++){if(ah[ag]===ai){aj=ag;break}}}else{if(!(ai.b0&32768)){if(E){document.write("ret2")}return ai.b0}aj++;ai=ah[aj]}}if(E){document.write("ret3")}return -1}function ad(){var ai,av,af,at,au;do{ai=W();af=U(2);switch(af){case 0:if(E){alert("Stored\n")}break;case 1:if(E){alert("Fixed Huffman codes\n")}break;case 2:if(E){alert("Dynamic Huffman codes\n")}break;case 3:if(E){alert("Reserved block type!!\n")}break;default:if(E){alert("Unexpected value %d!\n",af)}break}if(af==0){var aq,ae;r();aq=g();aq|=(g()<<8);ae=g();ae|=(g()<<8);if(((aq^~ae)&65535)){document.write("BlockLen checksum mismatch\n")}while(aq--){av=g();y(av)}}else{if(af==1){var ar;while(1){ar=(X[U(7)]>>1);if(ar>23){ar=(ar<<1)|W();if(ar>199){ar-=128;ar=(ar<<1)|W()}else{ar-=48;if(ar>143){ar=ar+136}}}else{ar+=256}if(ar<256){y(ar)}else{if(ar==256){break}else{var au,an;ar-=256+1;au=U(S[ar])+ab[ar];ar=X[U(5)]>>3;if(A[ar]>8){an=U(8);an|=(U(A[ar]-8)<<8)}else{an=U(A[ar])}an+=M[ar];for(ar=0;ar<au;ar++){var av=k[(Y-an)&32767];y(av)}}}}}else{if(af==2){var ar,ao,ag,al,am;var ak=new Array(288+32);ag=257+U(5);al=1+U(5);am=4+U(4);for(ar=0;ar<19;ar++){ak[ar]=0}for(ar=0;ar<am;ar++){ak[q[ar]]=U(3)}au=O.length;for(at=0;at<au;at++){O[at]=new o()}if(n(O,19,ak,0)){f();return 1}if(E){document.write("<br>distanceTree");for(var aw=0;aw<O.length;aw++){document.write("<br>"+O[aw].b0+" "+O[aw].b1+" "+O[aw].jump+" "+O[aw].jumppos)}}ao=ag+al;at=0;var ah=-1;if(E){document.write("<br>n="+ao+" bits: "+d+"<br>")}while(at<ao){ah++;ar=C(O);if(E){document.write("<br>"+ah+" i:"+at+" decode: "+ar+"    bits "+d+"<br>")}if(ar<16){ak[at++]=ar}else{if(ar==16){var ap;ar=3+U(2);if(at+ar>ao){f();return 1}ap=at?ak[at-1]:0;while(ar--){ak[at++]=ap}}else{if(ar==17){ar=3+U(3)}else{ar=11+U(7)}if(at+ar>ao){f();return 1}while(ar--){ak[at++]=0}}}}au=w.length;for(at=0;at<au;at++){w[at]=new o()}if(n(w,ag,ak,0)){f();return 1}au=w.length;for(at=0;at<au;at++){O[at]=new o()}var aj=new Array();for(at=ag;at<ak.length;at++){aj[at-ag]=ak[at]}if(n(O,al,aj,0)){f();return 1}if(E){document.write("<br>literalTree")}while(1){ar=C(w);if(ar>=256){var au,an;ar-=256;if(ar==0){break}ar--;au=U(S[ar])+ab[ar];ar=C(O);if(A[ar]>8){an=U(8);an|=(U(A[ar]-8)<<8)}else{an=U(A[ar])}an+=M[ar];while(au--){var av=k[(Y-an)&32767];y(av)}}else{y(ar)}}}}}}while(!ai);f();r();return 0}JXG.Util.Unzip.prototype.unzipFile=function(ae){var af;this.unzip();for(af=0;af<Q.length;af++){if(Q[af][1]==ae){return Q[af][0]}}};JXG.Util.Unzip.prototype.unzip=function(){if(E){alert(x)}u();return Q};function u(){if(E){alert("NEXTFILE")}p=[];var ai=[];L=false;ai[0]=g();ai[1]=g();if(E){alert("type: "+ai[0]+" "+ai[1])}if(ai[0]==parseInt("78",16)&&ai[1]==parseInt("da",16)){if(E){alert("GEONExT-GZIP")}ad();if(E){alert(p.join(""))}Q[H]=new Array(2);Q[H][0]=p.join("");Q[H][1]="geonext.gxt";H++}if(ai[0]==parseInt("1f",16)&&ai[1]==parseInt("8b",16)){if(E){alert("GZIP")}R();if(E){alert(p.join(""))}Q[H]=new Array(2);Q[H][0]=p.join("");Q[H][1]="file";H++}if(ai[0]==parseInt("50",16)&&ai[1]==parseInt("4b",16)){L=true;ai[2]=g();ai[3]=g();if(ai[2]==parseInt("3",16)&&ai[3]==parseInt("4",16)){ai[0]=g();ai[1]=g();if(E){alert("ZIP-Version: "+ai[1]+" "+ai[0]/10+"."+ai[0]%10)}B=g();B|=(g()<<8);if(E){alert("gpflags: "+B)}var ae=g();ae|=(g()<<8);if(E){alert("method: "+ae)}g();g();g();g();var aj=g();aj|=(g()<<8);aj|=(g()<<16);aj|=(g()<<24);var ah=g();ah|=(g()<<8);ah|=(g()<<16);ah|=(g()<<24);var am=g();am|=(g()<<8);am|=(g()<<16);am|=(g()<<24);if(E){alert("local CRC: "+aj+"\nlocal Size: "+am+"\nlocal CompSize: "+ah)}var af=g();af|=(g()<<8);var al=g();al|=(g()<<8);if(E){alert("filelen "+af)}ag=0;i=[];while(af--){var ak=g();if(ak=="/"|ak==":"){ag=0}else{if(ag<aa-1){i[ag++]=String.fromCharCode(ak)}}}if(E){alert("nameBuf: "+i)}if(!m){m=i}var ag=0;while(ag<al){ak=g();ag++}V=4294967295;I=0;if(am=0&&fileOut.charAt(m.length-1)=="/"){if(E){alert("skipdir")}}if(ae==8){ad();if(E){alert(p.join(""))}Q[H]=new Array(2);Q[H][0]=p.join("");Q[H][1]=i.join("");H++}R()}}}function R(){var aj,ag=[],ah,af,ai,ae,ak;if((B&8)){ag[0]=g();ag[1]=g();ag[2]=g();ag[3]=g();if(ag[0]==parseInt("50",16)&&ag[1]==parseInt("4b",16)&&ag[2]==parseInt("07",16)&&ag[3]==parseInt("08",16)){aj=g();aj|=(g()<<8);aj|=(g()<<16);aj|=(g()<<24)}else{aj=ag[0]|(ag[1]<<8)|(ag[2]<<16)|(ag[3]<<24)}ah=g();ah|=(g()<<8);ah|=(g()<<16);ah|=(g()<<24);af=g();af|=(g()<<8);af|=(g()<<16);af|=(g()<<24);if(E){alert("CRC:")}}if(L){u()}ag[0]=g();if(ag[0]!=8){if(E){alert("Unknown compression method!")}return 0}B=g();if(E){if((B&~(parseInt("1f",16)))){alert("Unknown flags set!")}}g();g();g();g();g();ai=g();if((B&4)){ag[0]=g();ag[2]=g();z=ag[0]+256*ag[1];if(E){alert("Extra field size: "+z)}for(ae=0;ae<z;ae++){g()}}if((B&8)){ae=0;i=[];while(ak=g()){if(ak=="7"||ak==":"){ae=0}if(ae<aa-1){i[ae++]=ak}}if(E){alert("original file name: "+i)}}if((B&16)){while(ak=g()){}}if((B&2)){g();g()}ad();aj=g();aj|=(g()<<8);aj|=(g()<<16);aj|=(g()<<24);af=g();af|=(g()<<8);af|=(g()<<16);af|=(g()<<24);if(L){u()}}};JXG.Util.Base64={_keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",encode:function(f){var d=[],n,l,j,m,k,h,g,e=0;f=JXG.Util.Base64._utf8_encode(f);while(e<f.length){n=f.charCodeAt(e++);l=f.charCodeAt(e++);j=f.charCodeAt(e++);m=n>>2;k=((n&3)<<4)|(l>>4);h=((l&15)<<2)|(j>>6);g=j&63;if(isNaN(l)){h=g=64}else{if(isNaN(j)){g=64}}d.push([this._keyStr.charAt(m),this._keyStr.charAt(k),this._keyStr.charAt(h),this._keyStr.charAt(g)].join(""))}return d.join("")},decode:function(g,f){var d=[],o,m,k,n,l,j,h,e=0;g=g.replace(/[^A-Za-z0-9\+\/\=]/g,"");while(e<g.length){n=this._keyStr.indexOf(g.charAt(e++));l=this._keyStr.indexOf(g.charAt(e++));j=this._keyStr.indexOf(g.charAt(e++));h=this._keyStr.indexOf(g.charAt(e++));o=(n<<2)|(l>>4);m=((l&15)<<4)|(j>>2);k=((j&3)<<6)|h;d.push(String.fromCharCode(o));if(j!=64){d.push(String.fromCharCode(m))}if(h!=64){d.push(String.fromCharCode(k))}}d=d.join("");if(f){d=JXG.Util.Base64._utf8_decode(d)}return d},_utf8_encode:function(e){e=e.replace(/\r\n/g,"\n");var d="";for(var g=0;g<e.length;g++){var f=e.charCodeAt(g);if(f<128){d+=String.fromCharCode(f)}else{if((f>127)&&(f<2048)){d+=String.fromCharCode((f>>6)|192);d+=String.fromCharCode((f&63)|128)}else{d+=String.fromCharCode((f>>12)|224);d+=String.fromCharCode(((f>>6)&63)|128);d+=String.fromCharCode((f&63)|128)}}}return d},_utf8_decode:function(d){var f=[],h=0,j=0,g=0,e=0;while(h<d.length){j=d.charCodeAt(h);if(j<128){f.push(String.fromCharCode(j));h++}else{if((j>191)&&(j<224)){g=d.charCodeAt(h+1);f.push(String.fromCharCode(((j&31)<<6)|(g&63)));h+=2}else{g=d.charCodeAt(h+1);e=d.charCodeAt(h+2);f.push(String.fromCharCode(((j&15)<<12)|((g&63)<<6)|(e&63)));h+=3}}}return f.join("")},_destrip:function(j,g){var e=[],h,f,d=[];if(g==null){g=76}j.replace(/ /g,"");h=j.length/g;for(f=0;f<h;f++){e[f]=j.substr(f*g,g)}if(h!=j.length/g){e[e.length]=j.substr(h*g,j.length-(h*g))}for(f=0;f<e.length;f++){d.push(e[f])}return d.join("\n")},decodeAsArray:function(e){var g=this.decode(e),d=[],f;for(f=0;f<g.length;f++){d[f]=g.charCodeAt(f)}return d},decodeGEONExT:function(d){return decodeAsArray(destrip(d),false)}};JXG.Util.asciiCharCodeAt=function(e,d){var f=e.charCodeAt(d);if(f>255){switch(f){case 8364:f=128;break;case 8218:f=130;break;case 402:f=131;break;case 8222:f=132;break;case 8230:f=133;break;case 8224:f=134;break;case 8225:f=135;break;case 710:f=136;break;case 8240:f=137;break;case 352:f=138;break;case 8249:f=139;break;case 338:f=140;break;case 381:f=142;break;case 8216:f=145;break;case 8217:f=146;break;case 8220:f=147;break;case 8221:f=148;break;case 8226:f=149;break;case 8211:f=150;break;case 8212:f=151;break;case 732:f=152;break;case 8482:f=153;break;case 353:f=154;break;case 8250:f=155;break;case 339:f=156;break;case 382:f=158;break;case 376:f=159;break;default:break}}return f};JXG.Util.utf8Decode=function(d){var f=[];var h=0;var k=0,j=0,g=0,e;if(!JXG.exists(d)){return""}while(h<d.length){k=d.charCodeAt(h);if(k<128){f.push(String.fromCharCode(k));h++}else{if((k>191)&&(k<224)){g=d.charCodeAt(h+1);f.push(String.fromCharCode(((k&31)<<6)|(g&63)));h+=2}else{g=d.charCodeAt(h+1);e=d.charCodeAt(h+2);f.push(String.fromCharCode(((k&15)<<12)|((g&63)<<6)|(e&63)));h+=3}}}return f.join("")};JXG.Util.genUUID=function(){var h="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split(""),f=new Array(36),e=0,g;for(var d=0;d<36;d++){if(d==8||d==13||d==18||d==23){f[d]="-"}else{if(d==14){f[d]="4"}else{if(e<=2){e=33554432+(Math.random()*16777216)|0}g=e&15;e=e>>4;f[d]=h[(d==19)?(g&3)|8:g]}}}return f.join("")};JXG.PsTricks={convert:function(g){var h=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],g),j=new JXG.Coords(JXG.COORDS_BY_SCREEN,[g.canvasWidth,g.canvasHeight],g),e,f,d=[];d.push("\\begin{pspicture*}("+h.usrCoords[1]+","+j.usrCoords[2]+")("+j.usrCoords[1]+","+h.usrCoords[2]+")\n");for(e in g.objects){f=g.objects[e];if(f.visProp.visible){switch(f.elementClass){case JXG.OBJECT_CLASS_CIRCLE:d.push(this.addCircle(f));break;case JXG.OBJECT_CLASS_LINE:d.push(this.addLine(f));break;case JXG.OBJECT_CLASS_POINT:d.push(this.addPoint(f));break;default:switch(f.type){case JXG.OBJECT_TYPE_ARC:d.push(this.addArc(f));break;case JXG.OBJECT_TYPE_SECTOR:d.push(this.addArc(f));d.push(this.addSector(f));break;case JXG.OBJECT_TYPE_POLYGON:d.push(this.addPolygon(f));break;case JXG.OBJECT_TYPE_ANGLE:d.push(this.addAngle(f));break}break}}}d.push("\\end{pspicture*}");return d.join("\n")},setArrows:function(e){var d="";if(e.visProp.firstarrow&&e.visProp.lastarrow){d="{<->}"}else{if(e.visProp.firstarrow){d="{<-}"}else{if(e.visProp.lastarrow){d="{->}"}}}return d},drawWedge:function(f,g,h,e,j,i){var d="";if(f!="none"&&g>0){d+="\\pswedge[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(f)+", opacity="+g.toFixed(5)+"]";d+="("+h.join(",")+"){"+e+"}{"+j+"}{"+i+"}\n"}return d},addPoint:function(f){var d="\\psdot[linecolor="+this.parseColor(f.visProp.strokecolor)+",dotstyle=",g=f.normalizeFace(f.visProp.face)||"o",e=f.visProp.size>4?4:f.visProp.size,h=[0,0,"2pt 2","5pt 2","5pt 3"];if(g=="x"){d+="x, dotsize="+h[e]}else{if(g=="o"){d+="*, dotsize=";if(e==1){d+="2pt 2"}else{if(e==2){d+="4pt 2"}else{if(e==3){d+="6pt 2"}else{if(e==4){d+="6pt 3"}}}}}else{if(g=="[]"){d+="square*, dotsize="+h[e]}else{if(g=="+"){d+="+, dotsize="+h[e]}}}}d+="]("+f.coords.usrCoords.slice(1).join(",")+")\n";d+="\\rput("+(f.coords.usrCoords[1]+15/f.board.unitY)+","+(f.coords.usrCoords[2]+15/f.board.unitY)+"){\\small $"+f.name+"$}\n";return d},addLine:function(g){var f=new JXG.Coords(JXG.COORDS_BY_USER,g.point1.coords.usrCoords,g.board),e=new JXG.Coords(JXG.COORDS_BY_USER,g.point2.coords.usrCoords,g.board),d="\\psline[linecolor="+this.parseColor(g.visProp.strokecolor)+", linewidth="+g.visProp.strokewidth+"px]";if(g.visProp.straightfirst||g.visProp.straightlast){JXG.Math.Geometry.calcStraight(g,f,e)}d+=this.setArrows(g);d+="("+f.usrCoords.slice(1).join(",")+")("+e.usrCoords.slice(2).join(",")+")\n";return d},addCircle:function(f){var e=f.Radius(),d="\\pscircle[linecolor="+this.parseColor(f.visProp.strokecolor)+", linewidth="+f.visProp.strokewidth+"px";if(f.visProp.fillcolor!="none"&&f.visProp.fillopacity!=0){d+=", fillstyle=solid, fillcolor="+this.parseColor(f.visProp.fillcolor)+", opacity="+f.visProp.fillopacity.toFixed(5)}d+="]("+f.midpoint.coords.usrCoords.slice(1).join("1")+"){"+e+"}\n";return d},addPolygon:function(f){var d="\\pspolygon[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(f.visProp.fillcolor)+", opacity="+f.visProp.fillopacity.toFixed(5)+"]",e;for(e=0;e<f.vertices.length;e++){d+="("+f.vertices[e].coords.usrCoords.slice(1).join(",")+")"}d+="\n";return d},addArc:function(f){var e=f.Radius(),h={coords:new JXG.Coords(JXG.COORDS_BY_USER,[f.board.canvasWidth/(f.board.unitY),f.midpoint.coords.usrCoords[2]],f.board)},g=JXG.Math.Geometry.trueAngle(h,f.midpoint,f.point2).toFixed(4),i=JXG.Math.Geometry.trueAngle(h,f.midpoint,f.point3).toFixed(4),d="\\psarc[linecolor="+this.parseColor(f.visProp.strokecolor)+", linewidth="+f.visProp.strokewidth+"px]";d+=this.setArrows(f);d+="("+f.midpoint.coords.usrCoords.slice(1).join(",")+"){"+e+"}{"+g+"}{"+i+"}\n";return d},addSector:function(e){var d=e.Radius(),g={coords:new JXG.Coords(JXG.COORDS_BY_USER,[e.board.canvasWidth/(e.board.unitY),e.midpoint.coords.usrCoords[2]],e.board)},f=JXG.Math.Geometry.trueAngle(g,e.midpoint,e.point2).toFixed(4),h=JXG.Math.Geometry.trueAngle(g,e.midpoint,e.point3).toFixed(4);return this.drawWedge(e.visProp.fillcolor,e.visProp.fillopacity,e.midpoint.coords.usrCoords.slice(1),d,f,h)},addAngle:function(f){var e=f.radius,h={coords:new JXG.Coords(JXG.COORDS_BY_USER,[f.board.canvasWidth/(f.board.unitY),f.point2.coords.usrCoords[2]],f.board)},g=JXG.Math.Geometry.trueAngle(h,f.point2,f.point1).toFixed(4),i=JXG.Math.Geometry.trueAngle(h,f.point2,f.point3).toFixed(4),d;d=this.drawWedge(f.visProp.fillcolor,f.visProp.fillopacity,f.point2.coords.usrCoords.slice(1),e,g,i);d+="\\psarc[linecolor="+this.parseColor(f.visProp.strokecolor)+", linewidth="+f.visProp.strokewidth+"px]";d+="("+f.point2.coords.usrCoords.slice(1).join(",")+"){"+e+"}{"+g+"}{"+i+"}\n";return d},parseColor:function(e){var d=JXG.rgbParser(e);return"{[rgb]{"+d[0]/255+","+d[1]/255+","+d[2]/255+"}}"}};JXG.Server=function(){};JXG.Server.modules=function(){};JXG.Server.runningCalls={};JXG.Server.handleError=function(d){alert("error occured, server says: "+d.message)};JXG.Server.callServer=function(h,o,i,m){var n,e,l,g,d,j,f;m=m||false;g="";for(f in i){g+="&"+escape(f)+"="+escape(i[f])}j=JXG.toJSON(i);do{d=h+Math.floor(Math.random()*4096)}while(typeof this.runningCalls[d]!="undefined");this.runningCalls[d]={action:h};if(typeof i.module!="undefined"){this.runningCalls[d].module=i.module}n=JXG.serverBase+"JXGServer.py";e="action="+escape(h)+"&id="+d+"&dataJSON="+escape(JXG.Util.Base64.encode(j));this.cbp=function(u){var w,q,r,t,v,k,s,p;w=(new JXG.Util.Unzip(JXG.Util.Base64.decodeAsArray(u))).unzip();if(JXG.isArray(w)&&w.length>0){w=w[0][0]}if(typeof w!="string"){return}q=window.JSON&&window.JSON.parse?window.JSON.parse(w):(new Function("return "+w))();if(q.type=="error"){this.handleError(q)}else{if(q.type=="response"){k=q.id;for(s=0;s<q.fields.length;s++){r=q.fields[s];t=r.namespace+(typeof((new Function("return "+r.namespace))())=="object"?".":".prototype.")+r.name+" = "+r.value;(new Function(t))()}for(s=0;s<q.handler.length;s++){r=q.handler[s];v=[];for(p=0;p<r.parameters.length;p++){v[p]='"'+r.parameters[p]+'": '+r.parameters[p]}t="if(typeof JXG.Server.modules."+this.runningCalls[k].module+' == "undefined")JXG.Server.modules.'+this.runningCalls[k].module+" = {};";t+="JXG.Server.modules."+this.runningCalls[k].module+"."+r.name+"_cb = "+r.callback+";";t+="JXG.Server.modules."+this.runningCalls[k].module+"."+r.name+" = function ("+r.parameters.join(",")+', __JXGSERVER_CB__, __JXGSERVER_SYNC) {if(typeof __JXGSERVER_CB__ == "undefined") __JXGSERVER_CB__ = JXG.Server.modules.'+this.runningCalls[k].module+"."+r.name+"_cb;var __JXGSERVER_PAR__ = {"+v.join(",")+', "module": "'+this.runningCalls[k].module+'", "handler": "'+r.name+'" };JXG.Server.callServer("exec", __JXGSERVER_CB__, __JXGSERVER_PAR__, __JXGSERVER_SYNC);};';(new Function(t))()}delete this.runningCalls[k];o(q.data)}}};this.cb=JXG.bind(this.cbp,this);if(window.XMLHttpRequest){l=new XMLHttpRequest();l.overrideMimeType("text/plain; charset=iso-8859-1")}else{l=new ActiveXObject("Microsoft.XMLHTTP")}if(l){l.open("POST",n,!m);l.setRequestHeader("Content-type","application/x-www-form-urlencoded");if(!m){l.onreadystatechange=(function(k){return function(){switch(l.readyState){case 4:if(l.status!=200){}else{k(l.responseText)}break;default:return false;break}}})(this.cb)}l.send(e);if(m){this.cb(l.responseText)}}else{return false}};JXG.Server.loadModule_cb=function(e){var d;for(d=0;d<e.length;d++){alert(e[d].name+": "+e[d].value)}};JXG.Server.loadModule=function(d){return JXG.Server.callServer("load",JXG.Server.loadModule_cb,{module:d},true)};JXG.Server.load=JXG.Server.loadModule;JXG.DataSource=function(){this.data=[];this.columnHeaders=[];this.rowHeaders=[];return this};JXG.extend(JXG.DataSource.prototype,{loadFromArray:function(h,k,g){var f,e,d;if(typeof k=="undefined"){k=false}if(typeof g=="undefined"){g=false}if(JXG.isArray(k)){this.columnHeaders=k;k=false}if(JXG.isArray(g)){this.rowHeaders=g;g=false}this.data=[];if(k){this.columnHeaders=[]}if(g){this.rowHeaders=[]}if(typeof h!="undefined"){this.data=new Array(h.length);for(f=0;f<h.length;f++){this.data[f]=new Array(h[f].length);for(e=0;e<h[f].length;e++){d=h[f][e];if(""+parseFloat(d)==d){this.data[f][e]=parseFloat(d)}else{if(d!="-"){this.data[f][e]=d}else{this.data[f][e]=NaN}}}}if(k){this.columnHeaders=this.data[0].slice(1);this.data=this.data.slice(1)}if(g){this.rowHeaders=new Array();for(f=0;f<this.data.length;f++){this.rowHeaders.push(this.data[f][0]);this.data[f]=this.data[f].slice(1)}}}return this},loadFromTable:function(m,f,k){var n,h,g,e,l,d;if(typeof f=="undefined"){f=false}if(typeof k=="undefined"){k=false}if(JXG.isArray(f)){this.columnHeaders=f;f=false}if(JXG.isArray(k)){this.rowHeaders=k;k=false}this.data=[];if(f){this.columnHeaders=[]}if(k){this.rowHeaders=[]}m=document.getElementById(m);if(typeof m!="undefined"){n=m.getElementsByTagName("tr");this.data=new Array(n.length);for(h=0;h<n.length;h++){e=n[h].getElementsByTagName("td");this.data[h]=new Array(e.length);for(g=0;g<e.length;g++){l=e[g].innerHTML;if(""+parseFloat(l)==l){this.data[h][g]=parseFloat(l)}else{if(l!="-"){this.data[h][g]=l}else{this.data[h][g]=NaN}}}}if(f){this.columnHeaders=this.data[0].slice(1);this.data=this.data.slice(1)}if(k){this.rowHeaders=new Array();for(h=0;h<this.data.length;h++){this.rowHeaders.push(this.data[h][0]);this.data[h]=this.data[h].slice(1)}}}return this},addColumn:function(d,f,e){},addRow:function(d,f,e){},getColumn:function(e){var d=new Array(this.data.length),f;if(typeof e=="string"){for(f=0;f<this.columnHeaders.length;f++){if(e==this.columnHeaders[f]){e=f;break}}}for(f=0;f<this.data.length;f++){if(this.data[f].length>e){d[f]=parseFloat(this.data[f][e])}}return d},getRow:function(f){var d,e;if(typeof f=="string"){for(e=0;e<this.rowHeaders.length;e++){if(f==this.rowHeaders[e]){f=e;break}}}d=new Array(this.data[f].length);for(e=0;e<this.data[f].length;e++){d[e]=this.data[f][e]}return d}});JXG.Board.prototype.construct=function(d,x,G,B,m){var r,C,A,s={},t,g,v,h,e,F,o,z,y,E,D,u,n,f,w,p,q;if(!JXG.exists(x)){x="normal"}else{D=[]}s.lines=[];s.circles=[];s.points=[];s.intersections=[];s.angles=[];s.macros=[];s.functions=[];s.texts=[];s.polygons=[];if(d.search(/\{/)!=-1){F=d.match(/\{/);F=F.length;y=0;for(A=0;A<F;A++){z=d.slice(y).search(/\{/);n=d.slice(z);n=n.slice(0,n.search(/\}/)+1);n=n.replace(/;/g,"?");d=d.slice(0,z)+n+d.slice(z+n.length);y=z+1}}r=d.split(";");for(C=0;C<r.length;C++){r[C]=r[C].replace(/^\s+/,"").replace(/\s+$/,"");if(r[C].search(/\{/)!=-1){r[C]=r[C].replace(/\?/g,";")}if(r[C].search(/Macro/)!=-1){this.addMacro(r[C])}else{if(r[C].length>0){f=false;if(r[C].search(/=/)!=-1){t=r[C].split("=");p=t[1];p=p.replace(/^\s+/,"").replace(/\s+$/,"");if(t[0].search(/\./)!=-1){f=true;t=t[0].split(".");w=t[t.length-1];w=w.replace(/^\s+/,"").replace(/\s+$/,"");t.pop();t=t.join(".");if(x=="macro"){for(A=0;A<G.length;A++){if(t==G[A]){t=B[A]}}}JXG.getReference(this,t).setProperty(w+":"+p)}}if(!f){if(r[C].search(/=/)!=-1){t=r[C].split("=");r[C]=t[1].replace(/^\s+/,"");t=t[0].replace(/\s+$/,"")}else{t=""}q={};u=true;while(u){if(r[C].search(/(.*)draft$/)!=-1){q.draft=true;r[C]=RegExp.$1;r[C]=r[C].replace(/\s+$/,"")}if(r[C].search(/(.*)invisible$/)!=-1){q.visible=false;r[C]=RegExp.$1;r[C]=r[C].replace(/\s+$/,"")}if(r[C].search(/(.*)nolabel$/)!=-1){q.withLabel=false;r[C]=RegExp.$1;r[C]=r[C].replace(/\s+$/,"")}if(r[C].search(/nolabel|invisible|draft/)==-1){u=false}}o=true;if(this.definedMacros){for(A=0;A<this.definedMacros.macros.length;A++){E=new RegExp("^"+this.definedMacros.macros[A][0]+"\\s*\\(");if(r[C].search(E)!=-1){o=false;r[C].match(/\((.*)\)/);F=RegExp.$1;F=F.split(",");for(z=0;z<F.length;z++){F[z].match(/\s*(\S*)\s*/);F[z]=RegExp.$1}s[t]=this.construct(this.definedMacros.macros[A][2],"macro",this.definedMacros.macros[A][1],F,t);s.macros.push(s[t]);break}}}if(o){if(r[C].search(/^[\[\]].*[\[\]]$/)!=-1){r[C].match(/([\[\]])(.*)([\[\]])/);q.straightFirst=(RegExp.$1!="[");q.straightLast=(RegExp.$3=="[");g=(RegExp.$2).replace(/^\s+/,"").replace(/\s+$/,"");if(g.search(/ /)!=-1){g.match(/(\S*) +(\S*)/);g=[];g[0]=RegExp.$1;g[1]=RegExp.$2}if(t!=""){if(!JXG.exists(q.withLabel)){q.withLabel=true}q.name=t;if(x=="macro"){D.push(t)}}if(x=="macro"){if(m!=""){for(A=0;A<D.length;A++){if(g[0]==D[A]){g[0]=m+"."+g[0]}if(g[1]==D[A]){g[1]=m+"."+g[1]}}}for(A=0;A<G.length;A++){if(g[0]==G[A]){g=[B[A],g[1]]}if(g[1]==G[A]){g=[g[0],B[A]]}}if(m!=""){q.id=m+"."+t}}if(typeof g=="string"){g=[JXG.getReference(this,g.charAt(0)),JXG.getReference(this,g.charAt(1))]}else{g=[JXG.getReference(this,g[0]),JXG.getReference(this,g[1])]}s.lines.push(this.create("line",g,q));if(t!=""){s[t]=s.lines[s.lines.length-1]}}else{if(r[C].search(/k\s*\(.*/)!=-1){r[C].match(/k\s*\(\s*(\S.*\S|\S)\s*,\s*(\S.*\S|\S)\s*\)/);g=[];g[0]=RegExp.$1;g[1]=RegExp.$2;for(A=0;A<=1;A++){if(g[A].search(/[\[\]]/)!=-1){g[A].match(/^[\[\]]\s*(\S.*\S)\s*[\[\]]$/);g[A]=RegExp.$1;if(g[A].search(/ /)!=-1){g[A].match(/(\S*) +(\S*)/);g[A]=[];g[A][0]=RegExp.$1;g[A][1]=RegExp.$2}if(x=="macro"){if(m!=""){for(z=0;z<D.length;z++){if(g[A][0]==D[z]){g[A][0]=m+"."+g[A][0]}if(g[A][1]==D[z]){g[A][1]=m+"."+g[A][1]}}}for(z=0;z<G.length;z++){if(g[A][0]==G[z]){g[A]=[B[z],g[A][1]]}if(g[A][1]==G[z]){g[A]=[g[A][0],B[z]]}}}if(typeof g[A]=="string"){g[A]=(function(j,i){return function(){return JXG.getReference(i,j.charAt(0)).Dist(JXG.getReference(i,j.charAt(1)))}})(g[A],this)}else{g[A]=(function(j,i){return function(){return JXG.getReference(i,j[0]).Dist(JXG.getReference(i,j[1]))}})(g[A],this)}}else{if(g[A].search(/[0-9\.\s]+/)!=-1){g[A]=1*g[A]}else{if(x=="macro"){if(m!=""){for(z=0;z<D.length;z++){if(g[A]==D[z]){g[A]=m+"."+D[z]}}}for(z=0;z<G.length;z++){if(g[A]==G[z]){g[A]=B[z]}}}g[A]=JXG.getReference(this,g[A])}}}if(t!=""){if(!JXG.exists(q.withLabel)){q.withLabel=true}q.name=t;if(x=="macro"){if(m!=""){q.id=m+"."+t}D.push(t)}}s.circles.push(this.create("circle",g,q));if(t!=""){s[t]=s.circles[s.circles.length-1]}}else{if(r[C].search(/^[A-Z]+.*\(\s*[0-9\.\-]+\s*[,\|]\s*[0-9\.\-]+\s*\)/)!=-1&&r[C].search(/Macro\((.*)\)/)==-1){r[C].match(/^([A-Z]+\S*)\s*\(\s*(.*)\s*[,\|]\s*(.*)\s*\)$/);t=RegExp.$1;q.name=t;if(x=="macro"){if(m!=""){q.id=m+"."+t}D.push(t)}s.points.push(this.create("point",[1*RegExp.$2,1*RegExp.$3],q));s[t]=s.points[s.points.length-1]}else{if(r[C].search(/^[A-Z]+.*\(.+(([,\|]\s*[0-9\.\-]+\s*){2})?/)!=-1&&r[C].search(/Macro\((.*)\)/)==-1){r[C].match(/([A-Z]+.*)\((.*)\)/);t=RegExp.$1;g=RegExp.$2;t=t.replace(/^\s+/,"").replace(/\s+$/,"");g=g.replace(/^\s+/,"").replace(/\s+$/,"");if(g.search(/[,\|]/)!=-1){g.match(/(\S*)\s*[,\|]\s*([0-9\.]+)\s*[,\|]\s*([0-9\.]+)\s*/);g=[];g[0]=RegExp.$1;g[1]=1*RegExp.$2;g[2]=1*RegExp.$3}else{v=g;g=[];g[0]=v;g[1]=0;g[2]=0}q.name=t;if(x=="macro"){if(m!=""){for(z=0;z<D.length;z++){if(g[0]==D[z]){g[0]=m+"."+D[z]}}}for(z=0;z<G.length;z++){if(g[0]==G[z]){g[0]=B[z]}}if(m!=""){q.id=m+"."+t}D.push(t)}s.points.push(this.create("glider",[g[1],g[2],JXG.getReference(this,g[0])],q));s[t]=s.points[s.points.length-1]}else{if(r[C].search(/&/)!=-1){r[C].match(/(.*)&(.*)/);g=[];g[0]=RegExp.$1;g[1]=RegExp.$2;g[0]=g[0].replace(/\s+$/,"");g[1]=g[1].replace(/^\s+/,"");if(x=="macro"){for(A=0;A<=1;A++){if(m!=""){for(z=0;z<D.length;z++){if(g[A]==D[z]){g[A]=m+"."+D[z]}}}for(z=0;z<G.length;z++){if(g[A]==G[z]){g[A]=B[z]}}}}g[0]=JXG.getReference(this,g[0]);g[1]=JXG.getReference(this,g[1]);if((g[0].elementClass==JXG.OBJECT_CLASS_LINE||g[0].elementClass==JXG.OBJECT_CLASS_CURVE)&&(g[1].elementClass==JXG.OBJECT_CLASS_LINE||g[1].elementClass==JXG.OBJECT_CLASS_CURVE)){if(t!=""){q.name=t;if(x=="macro"){if(m!=""){q.id=m+"."+t}D.push(t)}}v=this.create("intersection",[g[0],g[1],0],q);s.intersections.push(v);if(t!=""){s[q.name]=v}}else{if(t!=""){q.name=t+"_1";if(x=="macro"){if(m!=""){q.id=m+"."+t+"_1"}D.push(t+"_1")}}v=this.create("intersection",[g[0],g[1],0],q);s.intersections.push(v);if(t!=""){s[q.name]=v}if(t!=""){q.name=t+"_2";if(x=="macro"){if(m!=""){q.id=m+"."+t+"_2"}D.push(t+"_2")}}v=this.create("intersection",[g[0],g[1],1],q);s.intersections.push(v);if(t!=""){s[q.name]=v}}}else{if(r[C].search(/\|[\|_]\s*\(/)!=-1){r[C].match(/\|([\|_])\s*\(\s*(\S*)\s*,\s*(\S*)\s*\)/);h=RegExp.$1;if(h=="|"){h="parallel"}else{h="normal"}g=[];g[0]=RegExp.$2;g[1]=RegExp.$3;if(x=="macro"){for(A=0;A<=1;A++){if(m!=""){for(z=0;z<D.length;z++){if(g[A]==D[z]){g[A]=m+"."+D[z]}}}for(z=0;z<G.length;z++){if(g[A]==G[z]){g[A]=B[z]}}}}if(t!=""){q.name=t;if(!JXG.exists(q.withLabel)){q.withLabel=true}if(x=="macro"){if(m!=""){q.id=m+"."+t}D.push(t)}}s.lines.push(this.create(h,[JXG.getReference(this,g[0]),JXG.getReference(this,g[1])],q));if(t!=""){s[t]=s.lines[s.lines.length-1]}}else{if(r[C].search(/^</)!=-1){r[C].match(/<\s*\(\s*(\S*)\s*,\s*(\S*)\s*,\s*(\S*)\s*\)/);g=[];g[0]=RegExp.$1;g[1]=RegExp.$2;g[2]=RegExp.$3;if(x=="macro"){for(A=0;A<=2;A++){if(m!=""){for(z=0;z<D.length;z++){if(g[A]==D[z]){g[A]=m+"."+D[z]}}}for(z=0;z<G.length;z++){if(g[A]==G[z]){g[A]=B[z]}}}}if(t==""){s.lines.push(this.create("angle",[JXG.getReference(this,g[0]),JXG.getReference(this,g[1]),JXG.getReference(this,g[2])],q))}else{e=["alpha","beta","gamma","delta","epsilon","zeta","eta","theta","iota","kappa","lambda","mu","nu","xi","omicron","pi","rho","sigmaf","sigma","tau","upsilon","phi","chi","psi","omega"];h="";for(A=0;A<e.length;A++){if(t==e[A]){q.text="&"+t+";";q.name="&"+t+";";h="greek";break}else{if(A==e.length-1){q.text=t;q.name=t}}}if(!JXG.exists(q.withLabel)){q.withLabel=true}if(x=="macro"){if(m!=""){q.id=m+"."+t}D.push(t)}s.angles.push(this.create("angle",[JXG.getReference(this,g[0]),JXG.getReference(this,g[1]),JXG.getReference(this,g[2])],q));s[t]=s.angles[s.angles.length-1]}}else{if(r[C].search(/([0-9]+)\/([0-9]+)\(\s*(\S*)\s*,\s*(\S*)\s*\)/)!=-1){g=[];g[0]=1*(RegExp.$1)/(1*(RegExp.$2));g[1]=RegExp.$3;g[2]=RegExp.$4;if(x=="macro"){for(A=1;A<=2;A++){if(m!=""){for(z=0;z<D.length;z++){if(g[A]==D[z]){g[A]=m+"."+D[z]}}}for(z=0;z<G.length;z++){if(g[A]==G[z]){g[A]=B[z]}}}}g[1]=JXG.getReference(this,RegExp.$3);g[2]=JXG.getReference(this,RegExp.$4);v=[];v[0]=(function(j,i){return function(){return(1-j[0])*j[1].coords.usrCoords[1]+j[0]*j[2].coords.usrCoords[1]}})(g,this);v[1]=(function(j,i){return function(){return(1-j[0])*j[1].coords.usrCoords[2]+j[0]*j[2].coords.usrCoords[2]}})(g,this);if(t!=""){q.name=t;if(x=="macro"){if(m!=""){q.id=m+"."+t}D.push(t)}}s.points.push(this.create("point",[v[0],v[1]],q));if(t!=""){s[t]=s.points[s.points.length-1]}}else{if(r[C].search(/(\S*)\s*:\s*(.*)/)!=-1){t=RegExp.$1;F=JXG.GeonextParser.geonext2JS(RegExp.$2,this);g=[new Function("x","var y = "+F+"; return y;")];q.name=t;s.functions.push(this.create("functiongraph",g,q));s[t]=s.functions[s.functions.length-1]}else{if(r[C].search(/#(.*)\(\s*([0-9])\s*[,|]\s*([0-9])\s*\)/)!=-1){g=[];g[0]=RegExp.$1;g[1]=1*RegExp.$2;g[2]=1*RegExp.$3;g[0]=g[0].replace(/^\s+/,"").replace(/\s+$/,"");s.texts.push(this.create("text",[g[1],g[2],g[0]],q))}else{if(r[C].search(/(\S*)\s*\[(.*)\]/)!=-1){q.name=RegExp.$1;if(!JXG.exists(q.withLabel)){q.withLabel=true}g=RegExp.$2;g=g.split(",");for(A=0;A<g.length;A++){g[A]=g[A].replace(/^\s+/,"").replace(/\s+$/,"");if(x=="macro"){if(m!=""){for(z=0;z<D.length;z++){if(g[A]==D[z]){g[A]=m+"."+D[z]}}}for(z=0;z<G.length;z++){if(g[A]==G[z]){g[A]=B[z]}}}g[A]=JXG.getReference(this,g[A])}s.polygons.push(this.create("polygon",g,q));s[q.name]=s.polygons[s.polygons.length-1]}}}}}}}}}}}}}}}}this.update();return s};JXG.Board.prototype.addMacro=function(f){var h,d,e="",g;f.match(/(.*)\{(.*)\}/);h=RegExp.$1;d=RegExp.$2;if(h.search(/=/)!=-1){h.match(/\s*(\S*)\s*=.*/);e=RegExp.$1;h=(h.split("="))[1]}h.match(/Macro\((.*)\)/);h=RegExp.$1;h=h.split(",");for(g=0;g<h.length;g++){h[g].match(/\s*(\S*)\s*/);h[g]=RegExp.$1}if(this.definedMacros==null){this.definedMacros={};this.definedMacros.macros=[]}this.definedMacros.macros.push([e,h,d]);if(e!=""){this.definedMacros.defName=this.definedMacros.macros[this.definedMacros.macros.length-1]}};JXG.SVGRenderer=function(d){var e;this.type="svg";this.svgRoot=null;this.svgNamespace="http://www.w3.org/2000/svg";this.xlinkNamespace="http://www.w3.org/1999/xlink";this.container=d;this.container.style.MozUserSelect="none";this.container.style.overflow="hidden";if(this.container.style.position===""){this.container.style.position="relative"}this.svgRoot=this.container.ownerDocument.createElementNS(this.svgNamespace,"svg");this.svgRoot.style.overflow="hidden";this.svgRoot.style.width=this.container.style.width;this.svgRoot.style.height=this.container.style.height;this.container.appendChild(this.svgRoot);this.defs=this.container.ownerDocument.createElementNS(this.svgNamespace,"defs");this.svgRoot.appendChild(this.defs);this.filter=this.container.ownerDocument.createElementNS(this.svgNamespace,"filter");this.filter.setAttributeNS(null,"id",this.container.id+"_f1");this.filter.setAttributeNS(null,"width","300%");this.filter.setAttributeNS(null,"height","300%");this.filter.setAttributeNS(null,"filterUnits","userSpaceOnUse");this.feOffset=this.container.ownerDocument.createElementNS(this.svgNamespace,"feOffset");this.feOffset.setAttributeNS(null,"result","offOut");this.feOffset.setAttributeNS(null,"in","SourceAlpha");this.feOffset.setAttributeNS(null,"dx","5");this.feOffset.setAttributeNS(null,"dy","5");this.filter.appendChild(this.feOffset);this.feGaussianBlur=this.container.ownerDocument.createElementNS(this.svgNamespace,"feGaussianBlur");this.feGaussianBlur.setAttributeNS(null,"result","blurOut");this.feGaussianBlur.setAttributeNS(null,"in","offOut");this.feGaussianBlur.setAttributeNS(null,"stdDeviation","3");this.filter.appendChild(this.feGaussianBlur);this.feBlend=this.container.ownerDocument.createElementNS(this.svgNamespace,"feBlend");this.feBlend.setAttributeNS(null,"in","SourceGraphic");this.feBlend.setAttributeNS(null,"in2","blurOut");this.feBlend.setAttributeNS(null,"mode","normal");this.filter.appendChild(this.feBlend);this.defs.appendChild(this.filter);this.layer=[];for(e=0;e<JXG.Options.layer.numlayers;e++){this.layer[e]=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.layer[e])}this.dashArray=["2, 2","5, 5","10, 10","20, 20","20, 10, 10, 10","20, 5, 10, 5"]};JXG.SVGRenderer.prototype=new JXG.AbstractRenderer();JXG.extend(JXG.SVGRenderer.prototype,{_createArrowHead:function(f,h){var g=f.id+"Triangle",e,d;if(JXG.exists(h)){g+=h}e=this.createPrim("marker",g);e.setAttributeNS(null,"viewBox","0 0 10 6");e.setAttributeNS(null,"refY","3");e.setAttributeNS(null,"markerUnits","userSpaceOnUse");e.setAttributeNS(null,"markerHeight","12");e.setAttributeNS(null,"markerWidth","10");e.setAttributeNS(null,"orient","auto");e.setAttributeNS(null,"stroke",f.visProp.strokecolor);e.setAttributeNS(null,"stroke-opacity",f.visProp.strokeopacity);e.setAttributeNS(null,"fill",f.visProp.strokecolor);e.setAttributeNS(null,"fill-opacity",f.visProp.strokeopacity);d=this.container.ownerDocument.createElementNS(this.svgNamespace,"path");if(h==="End"){e.setAttributeNS(null,"refX","0");d.setAttributeNS(null,"d","M 0 3 L 10 6 L 10 0 z")}else{e.setAttributeNS(null,"refX","10");d.setAttributeNS(null,"d","M 0 0 L 10 3 L 0 6 z")}e.appendChild(d);return e},_setArrowAtts:function(f,d,e){if(f){f.setAttributeNS(null,"stroke",d);f.setAttributeNS(null,"stroke-opacity",e);f.setAttributeNS(null,"fill",d);f.setAttributeNS(null,"fill-opacity",e)}},updateTicks:function(g,h,d,k,e){var j="",l,n,f,m=g.ticks.length;for(l=0;l<m;l++){n=g.ticks[l].scrCoords;if(g.ticks[l].major){if((g.board.needsFullUpdate||g.needsRegularUpdate)&&g.labels[l]&&g.labels[l].visProp.visible){this.updateText(g.labels[l])}j+="M "+(n[1]+h)+" "+(n[2]-d)+" L "+(n[1]-h)+" "+(n[2]+d)+" "}else{j+="M "+(n[1]+k)+" "+(n[2]-e)+" L "+(n[1]-k)+" "+(n[2]+e)+" "}}f=this.getElementById(g.id);if(!JXG.exists(f)){f=this.createPrim("path",g.id);this.appendChildPrim(f,g.visProp.layer);this.appendNodesToElement(g,"path")}f.setAttributeNS(null,"stroke",g.visProp.strokecolor);f.setAttributeNS(null,"stroke-opacity",g.visProp.strokeopacity);f.setAttributeNS(null,"stroke-width",g.visProp.strokewidth);this.updatePathPrim(f,j,g.board)},displayCopyright:function(f,g){var e=this.createPrim("text","licenseText"),d;e.setAttributeNS(null,"x","20px");e.setAttributeNS(null,"y",(2+g)+"px");e.setAttributeNS(null,"style","font-family:Arial,Helvetica,sans-serif; font-size:"+g+"px; fill:#356AA0;  opacity:0.3;");d=document.createTextNode(f);e.appendChild(d);this.appendChildPrim(e,0)},drawInternalText:function(d){var e=this.createPrim("text",d.id);e.setAttributeNS(null,"class","JXGtext");d.rendNodeText=document.createTextNode("");e.appendChild(d.rendNodeText);this.appendChildPrim(e,9);return e},updateInternalText:function(d){var e=d.plaintext;if(!isNaN(d.coords.scrCoords[1]+d.coords.scrCoords[2])){d.rendNode.setAttributeNS(null,"x",d.coords.scrCoords[1]+"px");d.rendNode.setAttributeNS(null,"y",(d.coords.scrCoords[2]+this.vOffsetText*0.5)+"px")}if(d.htmlStr!==e){d.rendNodeText.data=e;d.htmlStr=e}this.transformImage(d,d.transformations)},drawImage:function(d){var e=this.createPrim("image",d.id);e.setAttributeNS(null,"preserveAspectRatio","none");this.appendChildPrim(e,d.visProp.layer);d.rendNode=e;this.updateImage(d)},transformImage:function(h,f){var i=h.rendNode,e,j="",g,d=f.length;if(d>0){e=this.joinTransforms(h,f);g=[e[1][1],e[2][1],e[1][2],e[2][2],e[1][0],e[2][0]].join(",");j+=" matrix("+g+") ";i.setAttributeNS(null,"transform",j)}},updateImageURL:function(e){var d=JXG.evaluate(e.url);e.rendNode.setAttributeNS(this.xlinkNamespace,"xlink:href",d)},appendChildPrim:function(d,e){if(!JXG.exists(e)){e=0}else{if(e>=JXG.Options.layer.numlayers){e=JXG.Options.layer.numlayers-1}}this.layer[e].appendChild(d)},appendNodesToElement:function(d){d.rendNode=this.getElementById(d.id)},createPrim:function(d,f){var e=this.container.ownerDocument.createElementNS(this.svgNamespace,d);e.setAttributeNS(null,"id",this.container.id+"_"+f);e.style.position="absolute";if(d==="path"){e.setAttributeNS(null,"stroke-linecap","butt");e.setAttributeNS(null,"stroke-linejoin","round")}return e},remove:function(d){if(JXG.exists(d)&&JXG.exists(d.parentNode)){d.parentNode.removeChild(d)}},makeArrows:function(e){var d;if(e.visPropOld.firstarrow===e.visProp.firstarrow&&e.visPropOld.lastarrow===e.visProp.lastarrow){return}if(e.visProp.firstarrow){d=e.rendNodeTriangleStart;if(!JXG.exists(d)){d=this._createArrowHead(e,"End");this.defs.appendChild(d);e.rendNodeTriangleStart=d;e.rendNode.setAttributeNS(null,"marker-start","url(#"+this.container.id+"_"+e.id+"TriangleEnd)")}}else{d=e.rendNodeTriangleStart;if(JXG.exists(d)){this.remove(d)}}if(e.visProp.lastarrow){d=e.rendNodeTriangleEnd;if(!JXG.exists(d)){d=this._createArrowHead(e,"Start");this.defs.appendChild(d);e.rendNodeTriangleEnd=d;e.rendNode.setAttributeNS(null,"marker-end","url(#"+this.container.id+"_"+e.id+"TriangleStart)")}}else{d=e.rendNodeTriangleEnd;if(JXG.exists(d)){this.remove(d)}}e.visPropOld.firstarrow=e.visProp.firstarrow;e.visPropOld.lastarrow=e.visProp.lastarrow},updateEllipsePrim:function(e,d,h,g,f){e.setAttributeNS(null,"cx",d);e.setAttributeNS(null,"cy",h);e.setAttributeNS(null,"rx",g);e.setAttributeNS(null,"ry",f)},updateLinePrim:function(h,e,d,g,f){if(!isNaN(e+d+g+f)){h.setAttributeNS(null,"x1",e);h.setAttributeNS(null,"y1",d);h.setAttributeNS(null,"x2",g);h.setAttributeNS(null,"y2",f)}},updatePathPrim:function(d,e){if(e==""){e="M 0 0"}d.setAttributeNS(null,"d",e)},updatePathStringPoint:function(h,e,g){var f="",j=h.coords.scrCoords,i=e*Math.sqrt(3)*0.5,d=e*0.5;if(g==="x"){f=" M "+(j[1]-e)+" "+(j[2]-e)+" L "+(j[1]+e)+" "+(j[2]+e)+" M "+(j[1]+e)+" "+(j[2]-e)+" L "+(j[1]-e)+" "+(j[2]+e)}else{if(g==="+"){f=" M "+(j[1]-e)+" "+(j[2])+" L "+(j[1]+e)+" "+(j[2])+" M "+(j[1])+" "+(j[2]-e)+" L "+(j[1])+" "+(j[2]+e)}else{if(g==="<>"){f=" M "+(j[1]-e)+" "+(j[2])+" L "+(j[1])+" "+(j[2]+e)+" L "+(j[1]+e)+" "+(j[2])+" L "+(j[1])+" "+(j[2]-e)+" Z "}else{if(g==="^"){f=" M "+(j[1])+" "+(j[2]-e)+" L "+(j[1]-i)+" "+(j[2]+d)+" L "+(j[1]+i)+" "+(j[2]+d)+" Z "}else{if(g==="v"){f=" M "+(j[1])+" "+(j[2]+e)+" L "+(j[1]-i)+" "+(j[2]-d)+" L "+(j[1]+i)+" "+(j[2]-d)+" Z "}else{if(g===">"){f=" M "+(j[1]+e)+" "+(j[2])+" L "+(j[1]-d)+" "+(j[2]-i)+" L "+(j[1]-d)+" "+(j[2]+i)+" Z "}else{if(g==="<"){f=" M "+(j[1]-e)+" "+(j[2])+" L "+(j[1]+d)+" "+(j[2]-i)+" L "+(j[1]+d)+" "+(j[2]+i)+" Z "}}}}}}}return f},updatePathStringPrim:function(d){var f=" M ",g=" L ",e=f,n=5000,j="",h,l,m=(d.visProp.curvetype!=="plot"),k;if(d.numberPoints<=0){return""}if(m&&d.board.options.curve.RDPsmoothing){d.points=JXG.Math.Numerics.RamerDouglasPeuker(d.points,0.5)}k=Math.min(d.points.length,d.numberPoints);for(h=0;h<k;h++){l=d.points[h].scrCoords;if(isNaN(l[1])||isNaN(l[2])){e=f}else{if(l[1]>n){l[1]=n}else{if(l[1]<-n){l[1]=-n}}if(l[2]>n){l[2]=n}else{if(l[2]<-n){l[2]=-n}}j+=[e,l[1]," ",l[2]].join("");e=g}}return j},updatePolygonPrim:function(h,g){var j="",e,f,d=g.vertices.length;h.setAttributeNS(null,"stroke","none");for(f=0;f<d-1;f++){e=g.vertices[f].coords.scrCoords;j=j+e[1]+","+e[2];if(f<d-2){j+=" "}}if(j.indexOf("NaN")==-1){h.setAttributeNS(null,"points",j)}},updateRectPrim:function(g,d,i,e,f){g.setAttributeNS(null,"x",d);g.setAttributeNS(null,"y",i);g.setAttributeNS(null,"width",e);g.setAttributeNS(null,"height",f)},setPropertyPrim:function(e,d,f){if(d==="stroked"){return}e.setAttributeNS(null,d,f)},show:function(d){var e;if(d&&d.rendNode){e=d.rendNode;e.setAttributeNS(null,"display","inline");e.style.visibility="inherit"}},hide:function(d){var e;if(d&&d.rendNode){e=d.rendNode;e.setAttributeNS(null,"display","none");e.style.visibility="hidden"}},setBuffering:function(e,d){e.rendNode.setAttribute("buffered-rendering",d)},setDashStyle:function(d){var f=d.visProp.dash,e=d.rendNode;if(d.visProp.dash>0){e.setAttributeNS(null,"stroke-dasharray",this.dashArray[f-1])}else{if(e.hasAttributeNS(null,"stroke-dasharray")){e.removeAttributeNS(null,"stroke-dasharray")}}},setGradient:function(f){var n=f.rendNode,g,i,h,m,l,e,d,k,j;i=JXG.evaluate(f.visProp.fillopacity);i=(i>0)?i:0;g=JXG.evaluate(f.visProp.fillcolor);if(f.visProp.gradient==="linear"){h=this.createPrim("linearGradient",f.id+"_gradient");e="0%";d="100%";k="0%";j="0%";h.setAttributeNS(null,"x1",e);h.setAttributeNS(null,"x2",d);h.setAttributeNS(null,"y1",k);h.setAttributeNS(null,"y2",j);m=this.createPrim("stop",f.id+"_gradient1");m.setAttributeNS(null,"offset","0%");m.setAttributeNS(null,"style","stop-color:"+g+";stop-opacity:"+i);l=this.createPrim("stop",f.id+"_gradient2");l.setAttributeNS(null,"offset","100%");l.setAttributeNS(null,"style","stop-color:"+f.visProp.gradientsecondcolor+";stop-opacity:"+f.visProp.gradientsecondopacity);h.appendChild(m);h.appendChild(l);this.defs.appendChild(h);n.setAttributeNS(null,"style","fill:url(#"+this.container.id+"_"+f.id+"_gradient)");f.gradNode1=m;f.gradNode2=l}else{if(f.visProp.gradient==="radial"){h=this.createPrim("radialGradient",f.id+"_gradient");h.setAttributeNS(null,"cx","50%");h.setAttributeNS(null,"cy","50%");h.setAttributeNS(null,"r","50%");h.setAttributeNS(null,"fx",f.visProp.gradientpositionx*100+"%");h.setAttributeNS(null,"fy",f.visProp.gradientpositiony*100+"%");m=this.createPrim("stop",f.id+"_gradient1");m.setAttributeNS(null,"offset","0%");m.setAttributeNS(null,"style","stop-color:"+f.visProp.gradientsecondcolor+";stop-opacity:"+f.visProp.gradientsecondopacity);l=this.createPrim("stop",f.id+"_gradient2");l.setAttributeNS(null,"offset","100%");l.setAttributeNS(null,"style","stop-color:"+g+";stop-opacity:"+i);h.appendChild(m);h.appendChild(l);this.defs.appendChild(h);n.setAttributeNS(null,"style","fill:url(#"+this.container.id+"_"+f.id+"_gradient)");f.gradNode1=m;f.gradNode2=l}else{n.removeAttributeNS(null,"style")}}},updateGradient:function(g){var e=g.gradNode1,d=g.gradNode2,f,h;if(!JXG.exists(e)||!JXG.exists(d)){return}h=JXG.evaluate(g.visProp.fillopacity);h=(h>0)?h:0;f=JXG.evaluate(g.visProp.fillcolor);if(g.visProp.gradient==="linear"){e.setAttributeNS(null,"style","stop-color:"+f+";stop-opacity:"+h);d.setAttributeNS(null,"style","stop-color:"+g.visProp.gradientsecondcolor+";stop-opacity:"+g.visProp.gradientsecondopacity)}else{if(g.visProp.gradient==="radial"){e.setAttributeNS(null,"style","stop-color:"+g.visProp.gradientsecondcolor+";stop-opacity:"+g.visProp.gradientsecondopacity);d.setAttributeNS(null,"style","stop-color:"+f+";stop-opacity:"+h)}}},setObjectFillColor:function(e,h,j){var f,g=JXG.evaluate(h),k,l,d=JXG.evaluate(j),i;d=(d>0)?d:0;if(e.visPropOld.fillcolor===g&&e.visPropOld.fillopacity===d){return}if(g!==false){if(g.length!=9){k=g;i=d}else{l=JXG.rgba2rgbo(g);k=l[0];i=d*l[1]}f=e.rendNode;f.setAttributeNS(null,"fill",k);if(e.type===JXG.OBJECT_TYPE_IMAGE){f.setAttributeNS(null,"opacity",i)}else{f.setAttributeNS(null,"fill-opacity",i)}if(JXG.exists(e.visProp.gradient)){this.updateGradient(e)}}e.visPropOld.fillcolor=g;e.visPropOld.fillopacity=d},setObjectStrokeColor:function(e,h,i){var g=JXG.evaluate(h),k,l,d=JXG.evaluate(i),j,f;d=(d>0)?d:0;if(e.visPropOld.strokecolor===g&&e.visPropOld.strokeopacity===d){return}if(g!==false){if(g.length!=9){k=g;j=d}else{l=JXG.rgba2rgbo(g);k=l[0];j=d*l[1]}f=e.rendNode;if(e.type===JXG.OBJECT_TYPE_TEXT){if(e.visProp.display==="html"){f.style.color=k}else{f.setAttributeNS(null,"style","fill:"+k)}f.style.opacity=j}else{f.setAttributeNS(null,"stroke",k);f.setAttributeNS(null,"stroke-opacity",j)}if(e.type===JXG.OBJECT_TYPE_ARROW){this._setArrowAtts(e.rendNodeTriangle,k,j)}else{if(e.elementClass===JXG.OBJECT_CLASS_CURVE||e.elementClass===JXG.OBJECT_CLASS_LINE){if(e.visProp.firstarrow){this._setArrowAtts(e.rendNodeTriangleStart,k,j)}if(e.visProp.lastarrow){this._setArrowAtts(e.rendNodeTriangleEnd,k,j)}}}}e.visPropOld.strokecolor=g;e.visPropOld.strokeopacity=d},setObjectStrokeWidth:function(f,e){var d=JXG.evaluate(e),g;if(f.visPropOld.strokewidth===d){return}g=f.rendNode;this.setPropertyPrim(g,"stroked","true");if(JXG.exists(d)){this.setPropertyPrim(g,"stroke-width",d+"px")}f.visPropOld.strokewidth=d},setShadow:function(d){if(d.visPropOld.shadow===d.visProp.shadow){return}if(JXG.exists(d.rendNode)){if(d.visProp.shadow){d.rendNode.setAttributeNS(null,"filter","url(#"+this.container.id+"_f1)")}else{d.rendNode.removeAttributeNS(null,"filter")}}d.visPropOld.shadow=d.visProp.shadow},suspendRedraw:function(){},unsuspendRedraw:function(){},resize:function(d,e){this.svgRoot.style.width=parseFloat(d)+"px";this.svgRoot.style.height=parseFloat(e)+"px"}});JXG.VMLRenderer=function(d){this.type="vml";this.container=d;this.container.style.overflow="hidden";this.container.onselectstart=function(){return false};this.resolution=10;if(!JXG.exists(JXG.vmlStylesheet)){d.ownerDocument.namespaces.add("jxgvml","urn:schemas-microsoft-com:vml");JXG.vmlStylesheet=this.container.ownerDocument.createStyleSheet();JXG.vmlStylesheet.addRule(".jxgvml","behavior:url(#default#VML)")}try{!d.ownerDocument.namespaces.jxgvml&&d.ownerDocument.namespaces.add("jxgvml","urn:schemas-microsoft-com:vml");this.createNode=function(e){return d.ownerDocument.createElement("<jxgvml:"+e+' class="jxgvml">')}}catch(f){this.createNode=function(e){return d.ownerDocument.createElement("<"+e+' xmlns="urn:schemas-microsoft.com:vml" class="jxgvml">')}}this.dashArray=["Solid","1 1","ShortDash","Dash","LongDash","ShortDashDot","LongDashDot"]};JXG.VMLRenderer.prototype=new JXG.AbstractRenderer();JXG.extend(JXG.VMLRenderer.prototype,{_setAttr:function(g,f,i,d){try{if(document.documentMode===8){g[f]=i}else{g.setAttribute(f,i,d)}}catch(h){JXG.debug(g.id+" "+f+" "+i+"<br>\n")}},updateTicks:function(h,j,e,k,g){var f=[],l,m,n,o,d=this.resolution;m=h.ticks.length;for(l=0;l<m;l++){n=h.ticks[l].scrCoords;if(h.ticks[l].major){if((h.board.needsFullUpdate||h.needsRegularUpdate)&&h.labels[l]&&h.labels[l].visProp.visible){this.updateText(h.labels[l])}f.push(" m "+Math.round(d*(n[1]+j))+", "+Math.round(d*(n[2]-e))+" l "+Math.round(d*(n[1]-j))+", "+Math.round(d*(n[2]+e))+" ")}else{f.push(" m "+Math.round(d*(n[1]+k))+", "+Math.round(d*(n[2]-g))+" l "+Math.round(d*(n[1]-k))+", "+Math.round(d*(n[2]+g))+" ")}}if(!JXG.exists(h)){o=this.createPrim("path",h.id);this.appendChildPrim(o,h.visProp.layer);this.appendNodesToElement(h,"path")}this._setAttr(h.rendNode,"stroked","true");this._setAttr(h.rendNode,"strokecolor",h.visProp.strokecolor,1);this._setAttr(h.rendNode,"strokeweight",h.visProp.strokewidth);this._setAttr(h.rendNodeStroke,"opacity",(h.visProp.strokeopacity*100)+"%");this.updatePathPrim(h.rendNode,f,h.board)},displayCopyright:function(f,g){var e,d;e=this.createNode("textbox");e.style.position="absolute";this._setAttr(e,"id",this.container.id+"_licenseText");e.style.left=20;e.style.top=2;e.style.fontSize=g;e.style.color="#356AA0";e.style.fontFamily="Arial,Helvetica,sans-serif";this._setAttr(e,"opacity","30%");e.style.filter="alpha(opacity = 30)";d=document.createTextNode(f);e.appendChild(d);this.appendChildPrim(e,0)},drawInternalText:function(d){var e;e=this.createNode("textbox");e.style.position="absolute";if(document.documentMode===8){e.setAttribute("class","JXGtext")}else{e.setAttribute(document.all?"className":"class","JXGtext")}d.rendNodeText=document.createTextNode("");e.appendChild(d.rendNodeText);this.appendChildPrim(e,9);return e},updateInternalText:function(d){var e=d.plaintext;if(!isNaN(d.coords.scrCoords[1]+d.coords.scrCoords[2])){d.rendNode.style.left=parseInt(d.coords.scrCoords[1])+"px";d.rendNode.style.top=parseInt(d.coords.scrCoords[2]-parseInt(d.visProp.fontsize)+this.vOffsetText)+"px"}if(d.htmlStr!==e){d.rendNodeText.data=e;d.htmlStr=e}this.transformImage(d,d.transformations)},drawImage:function(d){var e;e=this.container.ownerDocument.createElement("img");e.style.position="absolute";this._setAttr(e,"id",this.container.id+"_"+d.id);this.container.appendChild(e);this.appendChildPrim(e,d.visProp.layer);e.style.filter=e.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand')";d.rendNode=e;this.updateImage(d)},transformImage:function(g,r){var j=g.rendNode,k,f=[],u,o=r.length,e,d,l,h,n,q;if(g.type===JXG.OBJECT_TYPE_TEXT){g.updateSize()}if(o>0){q=g.rendNode.style.filter.toString();if(!q.match(/DXImageTransform/)){j.style.filter=j.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand') "+q}k=this.joinTransforms(g,r);f[0]=JXG.Math.matVecMult(k,g.coords.scrCoords);f[0][1]/=f[0][0];f[0][2]/=f[0][0];f[1]=JXG.Math.matVecMult(k,[1,g.coords.scrCoords[1]+g.size[0],g.coords.scrCoords[2]]);f[1][1]/=f[1][0];f[1][2]/=f[1][0];f[2]=JXG.Math.matVecMult(k,[1,g.coords.scrCoords[1]+g.size[0],g.coords.scrCoords[2]-g.size[1]]);f[2][1]/=f[2][0];f[2][2]/=f[2][0];f[3]=JXG.Math.matVecMult(k,[1,g.coords.scrCoords[1],g.coords.scrCoords[2]-g.size[1]]);f[3][1]/=f[3][0];f[3][2]/=f[3][0];e=f[0][1];l=f[0][1];d=f[0][2];h=f[0][2];for(n=1;n<4;n++){e=Math.max(e,f[n][1]);l=Math.min(l,f[n][1]);d=Math.max(d,f[n][2]);h=Math.min(h,f[n][2])}j.style.left=parseInt(l)+"px";j.style.top=parseInt(h)+"px";j.filters.item(0).M11=k[1][1];j.filters.item(0).M12=k[1][2];j.filters.item(0).M21=k[2][1];j.filters.item(0).M22=k[2][2]}},updateImageURL:function(e){var d=JXG.evaluate(e.url);this._setAttr(e.rendNode,"src",d)},appendChildPrim:function(d,e){if(!JXG.exists(e)){e=0}d.style.zIndex=e;this.container.appendChild(d)},appendNodesToElement:function(d,e){if(e==="shape"||e==="path"||e==="polygon"){d.rendNodePath=this.getElementById(d.id+"_path")}d.rendNodeFill=this.getElementById(d.id+"_fill");d.rendNodeStroke=this.getElementById(d.id+"_stroke");d.rendNodeShadow=this.getElementById(d.id+"_shadow");d.rendNode=this.getElementById(d.id)},createPrim:function(e,j){var f,d=this.createNode("fill"),i=this.createNode("stroke"),h=this.createNode("shadow"),g;this._setAttr(d,"id",this.container.id+"_"+j+"_fill");this._setAttr(i,"id",this.container.id+"_"+j+"_stroke");this._setAttr(h,"id",this.container.id+"_"+j+"_shadow");if(e==="circle"||e==="ellipse"){f=this.createNode("oval");f.appendChild(d);f.appendChild(i);f.appendChild(h)}else{if(e==="polygon"||e==="path"||e==="shape"||e==="line"){f=this.createNode("shape");f.appendChild(d);f.appendChild(i);f.appendChild(h);g=this.createNode("path");this._setAttr(g,"id",this.container.id+"_"+j+"_path");f.appendChild(g)}else{f=this.createNode(e);f.appendChild(d);f.appendChild(i);f.appendChild(h)}}f.style.position="absolute";f.style.left="0px";f.style.top="0px";this._setAttr(f,"id",this.container.id+"_"+j);return f},remove:function(d){if(JXG.exists(d)){d.removeNode(true)}},makeArrows:function(e){var d;if(e.visPropOld.firstarrow===e.visProp.firstarrow&&e.visPropOld.lastarrow===e.visProp.lastarrow){return}if(e.visProp.firstarrow){d=e.rendNodeStroke;this._setAttr(d,"startarrow","block");this._setAttr(d,"startarrowlength","long")}else{d=e.rendNodeStroke;if(JXG.exists(d)){this._setAttr(d,"startarrow","none")}}if(e.visProp.lastarrow){d=e.rendNodeStroke;this._setAttr(d,"id",this.container.id+"_"+e.id+"stroke");this._setAttr(d,"endarrow","block");this._setAttr(d,"endarrowlength","long")}else{d=e.rendNodeStroke;if(JXG.exists(d)){this._setAttr(d,"endarrow","none")}}e.visPropOld.firstarrow=e.visProp.firstarrow;e.visPropOld.lastarrow=e.visProp.lastarrow},updateEllipsePrim:function(e,d,h,g,f){e.style.left=parseInt(d-g)+"px";e.style.top=parseInt(h-f)+"px";e.style.width=parseInt(g*2)+"px";e.style.height=parseInt(f*2)+"px"},updateLinePrim:function(k,e,d,g,f,i){var h,j=this.resolution;if(!isNaN(e+d+g+f)){h=["m ",parseInt(j*e),", ",parseInt(j*d)," l ",parseInt(j*g),", ",parseInt(j*f)];this.updatePathPrim(k,h,i)}},updatePathPrim:function(f,g,e){var d=e.canvasWidth,h=e.canvasHeight;if(g.length<=0){g=["m 0,0"]}f.style.width=d;f.style.height=h;this._setAttr(f,"coordsize",[parseInt(this.resolution*d),parseInt(this.resolution*h)].join(","));this._setAttr(f,"path",g.join(""))},updatePathStringPoint:function(e,k,h){var j=[],f=Math.round,g=e.coords.scrCoords,i=k*Math.sqrt(3)*0.5,l=k*0.5,d=this.resolution;if(h==="x"){j.push([" m ",f(d*(g[1]-k)),", ",f(d*(g[2]-k))," l ",f(d*(g[1]+k)),", ",f(d*(g[2]+k))," m ",f(d*(g[1]+k)),", ",f(d*(g[2]-k))," l ",f(d*(g[1]-k)),", ",f(d*(g[2]+k))].join(""))}else{if(h==="+"){j.push([" m ",f(d*(g[1]-k)),", ",f(d*(g[2]))," l ",f(d*(g[1]+k)),", ",f(d*(g[2]))," m ",f(d*(g[1])),", ",f(d*(g[2]-k))," l ",f(d*(g[1])),", ",f(d*(g[2]+k))].join(""))}else{if(h==="<>"){j.push([" m ",f(d*(g[1]-k)),", ",f(d*(g[2]))," l ",f(d*(g[1])),", ",f(d*(g[2]+k))," l ",f(d*(g[1]+k)),", ",f(d*(g[2]))," l ",f(d*(g[1])),", ",f(d*(g[2]-k))," x e "].join(""))}else{if(h==="^"){j.push([" m ",f(d*(g[1])),", ",f(d*(g[2]-k))," l ",f(d*(g[1]-i)),", ",f(d*(g[2]+l))," l ",f(d*(g[1]+i)),", ",f(d*(g[2]+l))," x e "].join(""))}else{if(h==="v"){j.push([" m ",f(d*(g[1])),", ",f(d*(g[2]+k))," l ",f(d*(g[1]-i)),", ",f(d*(g[2]-l))," l ",f(d*(g[1]+i)),", ",f(d*(g[2]-l))," x e "].join(""))}else{if(h===">"){j.push([" m ",f(d*(g[1]+k)),", ",f(d*(g[2]))," l ",f(d*(g[1]-l)),", ",f(d*(g[2]-i))," l ",f(d*(g[1]-l)),", ",f(d*(g[2]+i))," l ",f(d*(g[1]+k)),", ",f(d*(g[2]))].join(""))}else{if(h==="<"){j.push([" m ",f(d*(g[1]-k)),", ",f(d*(g[2]))," l ",f(d*(g[1]+l)),", ",f(d*(g[2]-i))," l ",f(d*(g[1]+l)),", ",f(d*(g[2]+i))," x e "].join(""))}}}}}}}return j},updatePathStringPrim:function(e){var l=[],k,n,d=this.resolution,j=Math.round,g=" m ",h=" l ",f=g,o=(e.visProp.curvetype!=="plot"),m=Math.min(e.numberPoints,8192);if(e.numberPoints<=0){return""}if(o&&e.board.options.curve.RDPsmoothing){e.points=JXG.Math.Numerics.RamerDouglasPeuker(e.points,1)}m=Math.min(m,e.points.length);for(k=0;k<m;k++){n=e.points[k].scrCoords;if(isNaN(n[1])||isNaN(n[2])){f=g}else{if(n[1]>20000){n[1]=20000}else{if(n[1]<-20000){n[1]=-20000}}if(n[2]>20000){n[2]=20000}else{if(n[2]<-20000){n[2]=-20000}}l.push([f,j(d*n[1]),", ",j(d*n[2])].join(""));f=h}}l.push(" e");return l},updatePolygonPrim:function(h,f){var e,d=f.vertices.length,g=this.resolution,j,k=[];this._setAttr(h,"stroked","false");j=f.vertices[0].coords.scrCoords;if(isNaN(j[1]+j[2])){return}k.push(["m ",parseInt(g*j[1]),",",parseInt(g*j[2])," l "].join(""));for(e=1;e<d-1;e++){j=f.vertices[e].coords.scrCoords;if(isNaN(j[1]+j[2])){return}k.push(parseInt(g*j[1])+","+parseInt(g*j[2]));if(e<d-2){k.push(", ")}}k.push(" x e");this.updatePathPrim(h,k,f.board)},updateRectPrim:function(g,d,i,e,f){g.style.left=parseInt(d)+"px";g.style.top=parseInt(i)+"px";if(e>=0){g.style.width=e+"px"}if(f>=0){g.style.height=f+"px"}},setPropertyPrim:function(g,f,h){var e="",d;switch(f){case"stroke":e="strokecolor";break;case"stroke-width":e="strokeweight";break;case"stroke-dasharray":e="dashstyle";break}if(e!==""){d=JXG.evaluate(h);this._setAttr(g,e,d)}},show:function(d){if(d&&d.rendNode){d.rendNode.style.visibility="inherit"}},hide:function(d){if(d&&d.rendNode){d.rendNode.style.visibility="hidden"}},setDashStyle:function(e,d){var f;if(d.dash>=0){f=e.rendNodeStroke;this._setAttr(f,"dashstyle",this.dashArray[d.dash])}},setGradient:function(e){var d=e.rendNodeFill;if(e.visProp.gradient==="linear"){this._setAttr(d,"type","gradient");this._setAttr(d,"color2",e.visProp.gradientsecondcolor);this._setAttr(d,"opacity2",e.visProp.gradientsecondopacity);this._setAttr(d,"angle",e.visProp.gradientangle)}else{if(e.visProp.gradient==="radial"){this._setAttr(d,"type","gradientradial");this._setAttr(d,"color2",e.visProp.gradientsecondcolor);this._setAttr(d,"opacity2",e.visProp.gradientsecondopacity);this._setAttr(d,"focusposition",e.visProp.gradientpositionx*100+"%,"+e.visProp.gradientpositiony*100+"%");this._setAttr(d,"focussize","0,0")}else{this._setAttr(d,"type","solid")}}},setObjectFillColor:function(e,h,i){var g=JXG.evaluate(h),k,l,d=JXG.evaluate(i),j,f=e.rendNode,m;d=(d>0)?d:0;if(e.visPropOld.fillcolor===g&&e.visPropOld.fillopacity===d){return}if(g.length!=9){k=g;j=d}else{l=JXG.rgba2rgbo(g);k=l[0];j=d*l[1]}if(k==="none"||k===false){this._setAttr(e.rendNode,"filled","false")}else{this._setAttr(e.rendNode,"filled","true");this._setAttr(e.rendNode,"fillcolor",k);if(JXG.exists(j)&&e.rendNodeFill){this._setAttr(e.rendNodeFill,"opacity",(j*100)+"%")}}if(e.type===JXG.OBJECT_TYPE_IMAGE){m=e.rendNode.style.filter.toString();if(m.match(/alpha/)){e.rendNode.style.filter=m.replace(/alpha\(opacity *= *[0-9\.]+\)/,"alpha(opacity = "+(j*100)+")")}else{e.rendNode.style.filter+=" alpha(opacity = "+(j*100)+")"}}e.visPropOld.fillcolor=g;e.visPropOld.fillopacity=d},setObjectStrokeColor:function(f,i,j){var h=JXG.evaluate(i),l,m,e=JXG.evaluate(j),k,g=f.rendNode,d;e=(e>0)?e:0;if(f.visPropOld.strokecolor===h&&f.visPropOld.strokeopacity===e){return}if(h.length!=9){l=h;k=e}else{m=JXG.rgba2rgbo(h);l=m[0];k=e*m[1]}if(f.type===JXG.OBJECT_TYPE_TEXT){k=Math.round(k*100);g.style.filter=" alpha(opacity = "+k+")";g.style.color=l}else{if(l!==false){this._setAttr(g,"stroked","true");this._setAttr(g,"strokecolor",l)}d=f.rendNodeStroke;if(JXG.exists(k)){this._setAttr(d,"opacity",(k*100)+"%")}}f.visPropOld.strokecolor=h;f.visPropOld.strokeopacity=e},setObjectStrokeWidth:function(f,e){var d=JXG.evaluate(e),g;if(f.visPropOld.strokewidth===d){return}g=f.rendNode;this.setPropertyPrim(g,"stroked","true");if(JXG.exists(d)){this.setPropertyPrim(g,"stroke-width",d)}f.visPropOld.strokewidth=d},setShadow:function(d){var e=d.rendNodeShadow;if(!e||d.visPropOld.shadow===d.visProp.shadow){return}if(d.visProp.shadow){this._setAttr(e,"On","True");this._setAttr(e,"Offset","3pt,3pt");this._setAttr(e,"Opacity","60%");this._setAttr(e,"Color","#aaaaaa")}else{this._setAttr(e,"On","False")}d.visPropOld.shadow=d.visProp.shadow},suspendRedraw:function(){this.container.style.display="none"},unsuspendRedraw:function(){this.container.style.display=""}});JXG.CanvasRenderer=function(d){var e;this.type="canvas";this.canvasRoot=null;this.suspendHandle=null;this.canvasId=JXG.Util.genUUID();this.canvasNamespace=null;this.container=d;this.container.style.MozUserSelect="none";this.container.style.overflow="hidden";if(this.container.style.position===""){this.container.style.position="relative"}this.container.innerHTML=['<canvas id="',this.canvasId,'" width="',this.container.style.width,'" height="',this.container.style.height,'"><',"/canvas>"].join("");this.canvasRoot=document.getElementById(this.canvasId);this.context=this.canvasRoot.getContext("2d");this.dashArray=[[2,2],[5,5],[10,10],[20,20],[20,10,10,10],[20,5,10,5]]};JXG.CanvasRenderer.prototype=new JXG.AbstractRenderer();JXG.extend(JXG.CanvasRenderer.prototype,{_drawFilledPolygon:function(e){var g,d=e.length,f=this.context;if(d>0){f.beginPath();f.moveTo(e[0][0],e[0][1]);for(g=0;g<d;g++){if(g>0){f.lineTo(e[g][0],e[g][1])}}f.lineTo(e[0][0],e[0][1]);f.fill()}},_fill:function(e){var d=this.context;d.save();if(this._setColor(e,"fill")){d.fill()}d.restore()},_rotatePoint:function(e,d,f){return[(d*Math.cos(e))-(f*Math.sin(e)),(d*Math.sin(e))+(f*Math.cos(e))]},_rotateShape:function(e,g){var f,h=[],d=e.length;if(d<=0){return e}for(f=0;f<d;f++){h.push(this._rotatePoint(g,e[f][0],e[f][1]))}return h},_setColor:function(i,m,d){var j=true,g=false,p=i.visProp,e,h,n,l,f,k;m=m||"stroke";d=d||m;if(!JXG.exists(i.board)||!JXG.exists(i.board.highlightedObjects)){g=true}if(!g&&JXG.exists(i.board.highlightedObjects[i.id])){e="highlight"}else{e=""}h=JXG.evaluate(p[e+m+"color"]);if(h!=="none"&&h!==false){f=JXG.evaluate(p[e+m+"opacity"]);f=(f>0)?f:0;if(h.length!=9){l=h;k=f}else{n=JXG.rgba2rgbo(h);l=n[0];k=f*n[1]}this.context.globalAlpha=k;this.context[d+"Style"]=l}else{j=false}if(m==="stroke"){this.context.lineWidth=parseFloat(p.strokewidth)}return j},_stroke:function(e){var d=this.context;d.save();if(e.visProp.dash>0){}else{this.context.lineDashArray=[]}if(this._setColor(e,"stroke")){d.stroke()}d.restore()},_translateShape:function(f,e,j){var g,h=[],d=f.length;if(d<=0){return f}for(g=0;g<d;g++){h.push([f[g][0]+e,f[g][1]+j])}return h},drawPoint:function(i){var j=i.visProp.face,h=i.visProp.size,l=i.coords.scrCoords,k=h*Math.sqrt(3)*0.5,d=h*0.5,e=parseFloat(i.visProp.strokewidth)/2,g=this.context;if(h<=0||!i.visProp.visible){return}switch(j){case"cross":case"x":g.beginPath();g.moveTo(l[1]-h,l[2]-h);g.lineTo(l[1]+h,l[2]+h);g.moveTo(l[1]+h,l[2]-h);g.lineTo(l[1]-h,l[2]+h);g.closePath();this._stroke(i);break;case"circle":case"o":g.beginPath();g.arc(l[1],l[2],h+1+e,0,2*Math.PI,false);g.closePath();this._fill(i);this._stroke(i);break;case"square":case"[]":if(h<=0){break}g.save();if(this._setColor(i,"stroke","fill")){g.fillRect(l[1]-h-e,l[2]-h-e,h*2+3*e,h*2+3*e)}g.restore();g.save();this._setColor(i,"fill");g.fillRect(l[1]-h+e,l[2]-h+e,h*2-e,h*2-e);g.restore();break;case"plus":case"+":g.beginPath();g.moveTo(l[1]-h,l[2]);g.lineTo(l[1]+h,l[2]);g.moveTo(l[1],l[2]-h);g.lineTo(l[1],l[2]+h);g.closePath();this._stroke(i);break;case"diamond":case"<>":g.beginPath();g.moveTo(l[1]-h,l[2]);g.lineTo(l[1],l[2]+h);g.lineTo(l[1]+h,l[2]);g.lineTo(l[1],l[2]-h);g.closePath();this._fill(i);this._stroke(i);break;case"triangleup":case"a":case"^":g.beginPath();g.moveTo(l[1],l[2]-h);g.lineTo(l[1]-k,l[2]+d);g.lineTo(l[1]+k,l[2]+d);g.closePath();this._fill(i);this._stroke(i);break;case"triangledown":case"v":g.beginPath();g.moveTo(l[1],l[2]+h);g.lineTo(l[1]-k,l[2]-d);g.lineTo(l[1]+k,l[2]-d);g.closePath();this._fill(i);this._stroke(i);break;case"triangleleft":case"<":g.beginPath();g.moveTo(l[1]-h,l[2]);g.lineTo(l[1]+d,l[2]-k);g.lineTo(l[1]+d,l[2]+k);g.closePath();this.fill(i);this._stroke(i);break;case"triangleright":case">":g.beginPath();g.moveTo(l[1]+h,l[2]);g.lineTo(l[1]-d,l[2]-k);g.lineTo(l[1]-d,l[2]+k);g.closePath();this._fill(i);this._stroke(i);break}},updatePoint:function(d){this.drawPoint(d)},drawLine:function(d){var f=new JXG.Coords(JXG.COORDS_BY_USER,d.point1.coords.usrCoords,d.board),e=new JXG.Coords(JXG.COORDS_BY_USER,d.point2.coords.usrCoords,d.board);JXG.Math.Geometry.calcStraight(d,f,e);this.context.beginPath();this.context.moveTo(f.scrCoords[1],f.scrCoords[2]);this.context.lineTo(e.scrCoords[1],e.scrCoords[2]);this._stroke(d);this.makeArrows(d,f,e)},updateLine:function(d){this.drawLine(d)},drawTicks:function(){},updateTicks:function(g,h,e,j,f){var k,m,l=g.ticks.length,d=this.context;d.beginPath();for(k=0;k<l;k++){m=g.ticks[k].scrCoords;if(g.ticks[k].major){if(g.labels[k]&&(g.board.needsFullUpdate||g.needsRegularUpdate||g.labels[k].visProp.display==="internal")&&g.labels[k].visProp.visible){this.updateText(g.labels[k])}d.moveTo(m[1]+h,m[2]-e);d.lineTo(m[1]-h,m[2]+e)}else{d.moveTo(m[1]+j,m[2]-f);d.lineTo(m[1]-j,m[2]+f)}}this._stroke(g)},drawCurve:function(d){this.updatePathStringPrim(d)},updateCurve:function(d){this.drawCurve(d)},drawEllipse:function(f){var e=f.midpoint.coords.scrCoords[1],d=f.midpoint.coords.scrCoords[2],n=f.board.unitX,m=f.board.unitY,t=2*f.Radius(),s=2*f.Radius(),q=t*n,l=s*m,i=e-q/2,h=d-l/2,u=(q/2)*0.5522848,r=(l/2)*0.5522848,p=i+q,o=h+l,k=i+q/2,j=h+l/2,g=this.context;if(t>0&&s>0&&!isNaN(e+d)){g.beginPath();g.moveTo(i,j);g.bezierCurveTo(i,j-r,k-u,h,k,h);g.bezierCurveTo(k+u,h,p,j-r,p,j);g.bezierCurveTo(p,j+r,k+u,o,k,o);g.bezierCurveTo(k-u,o,i,j+r,i,j);g.closePath();this._fill(f);this._stroke(f)}},updateEllipse:function(d){return this.drawEllipse(d)},displayCopyright:function(f,e){var d=this.context;d.save();d.font=e+"px Arial";d.fillStyle="#aaa";d.lineWidth=0.5;d.fillText(f,10,2+e);d.restore()},drawInternalText:function(f){var d,e=this.context;e.save();if(this._setColor(f,"stroke","fill")&&!isNaN(f.coords.scrCoords[1]+f.coords.scrCoords[2])){if(f.visProp.fontsize){if(typeof f.visProp.fontsize==="function"){d=f.visProp.fontsize();e.font=(d>0?d:0)+"px Arial"}else{e.font=(f.visProp.fontsize)+"px Arial"}}this.transformImage(f,f.transformations);e.fillText(f.plaintext,f.coords.scrCoords[1],f.coords.scrCoords[2])}e.restore();return null},updateInternalText:function(d){this.drawInternalText(d)},setObjectStrokeColor:function(e,h,i){var g=JXG.evaluate(h),k,l,d=JXG.evaluate(i),j,f;d=(d>0)?d:0;if(e.visPropOld.strokecolor===g&&e.visPropOld.strokeopacity===d){return}if(g!==false){if(g.length!=9){k=g;j=d}else{l=JXG.rgba2rgbo(g);k=l[0];j=d*l[1]}f=e.rendNode;if(e.type===JXG.OBJECT_TYPE_TEXT&&e.visProp.display==="html"){f.style.color=k;f.style.opacity=j}}e.visPropOld.strokecolor=g;e.visPropOld.strokeopacity=d},drawImage:function(d){d.rendNode=new Image();d._src="";this.updateImage(d)},updateImage:function(e){var d=this.context,f=JXG.evaluate(e.visProp.fillopacity),g=JXG.bind(function(){e.imgIsLoaded=true;if(e.size[0]<=0||e.size[1]<=0){return}d.save();d.globalAlpha=f;this.transformImage(e,e.transformations);d.drawImage(e.rendNode,e.coords.scrCoords[1],e.coords.scrCoords[2]-e.size[1],e.size[0],e.size[1]);d.restore()},this);if(this.updateImageURL(e)){e.rendNode.onload=g}else{if(e.imgIsLoaded){g()}}},transformImage:function(h,g){var e,d=g.length,f=this.context;if(d>0){e=this.joinTransforms(h,g);if(Math.abs(JXG.Math.Numerics.det(e))>=JXG.Math.eps){f.transform(e[1][1],e[2][1],e[1][2],e[2][2],e[1][0],e[2][0])}}},updateImageURL:function(e){var d;d=JXG.evaluate(e.url);if(e._src!==d){e.imgIsLoaded=false;e.rendNode.src=d;e._src=d;return true}return false},remove:function(d){if(JXG.exists(d)&&JXG.exists(d.parentNode)){d.parentNode.removeChild(d)}},makeArrows:function(h,l,j){var f=[[2,0],[-10,-4],[-10,4]],n=[[-2,0],[10,-4],[10,4]],g,m,d,k,i,e=this.context;if(h.visProp.strokecolor!=="none"&&(h.visProp.lastarrow||h.visProp.firstarrow)){if(h.elementClass===JXG.OBJECT_CLASS_LINE){g=l.scrCoords[1];m=l.scrCoords[2];d=j.scrCoords[1];k=j.scrCoords[2]}else{return}e.save();if(this._setColor(h,"stroke","fill")){i=Math.atan2(k-m,d-g);if(h.visProp.lastarrow){this._drawFilledPolygon(this._translateShape(this._rotateShape(f,i),d,k))}if(h.visProp.firstarrow){this._drawFilledPolygon(this._translateShape(this._rotateShape(n,i),g,m))}}e.restore()}},updatePathStringPrim:function(e){var g="M",h="L",f=g,n=5000,j,l,m=(e.visProp.curvetype!=="plot"),k,d=this.context;if(e.numberPoints<=0){return}if(m&&e.board.options.curve.RDPsmoothing){e.points=JXG.Math.Numerics.RamerDouglasPeuker(e.points,0.5)}k=Math.min(e.points.length,e.numberPoints);d.beginPath();for(j=0;j<k;j++){l=e.points[j].scrCoords;if(isNaN(l[1])||isNaN(l[2])){f=g}else{if(l[1]>n){l[1]=n}else{if(l[1]<-n){l[1]=-n}}if(l[2]>n){l[2]=n}else{if(l[2]<-n){l[2]=-n}}if(f==="M"){d.moveTo(l[1],l[2])}else{d.lineTo(l[1],l[2])}f=h}}this._fill(e);this._stroke(e)},updatePolygonPrim:function(j,h){var e,g,d=h.vertices.length,f=this.context;if(d<=0){return}f.beginPath();e=h.vertices[0].coords.scrCoords;f.moveTo(e[1],e[2]);for(g=1;g<d;g++){e=h.vertices[g].coords.scrCoords;f.lineTo(e[1],e[2])}f.closePath();this._fill(h)},show:function(d){if(JXG.exists(d.rendNode)){d.rendNode.style.visibility="inherit"}},hide:function(d){if(JXG.exists(d.rendNode)){d.rendNode.style.visibility="hidden"}},setGradient:function(e){var d,f;f=JXG.evaluate(e.visProp.fillopacity);f=(f>0)?f:0;d=JXG.evaluate(e.visProp.fillcolor)},setShadow:function(d){if(d.visPropOld.shadow===d.visProp.shadow){return}d.visPropOld.shadow=d.visProp.shadow},highlight:function(d){d.board.prepareUpdate();d.board.renderer.suspendRedraw(d.board);d.board.updateRenderer();d.board.renderer.unsuspendRedraw();return this},noHighlight:function(d){d.board.prepareUpdate();d.board.renderer.suspendRedraw(d.board);d.board.updateRenderer();d.board.renderer.unsuspendRedraw();return this},suspendRedraw:function(d){this.context.save();this.context.clearRect(0,0,this.canvasRoot.width,this.canvasRoot.height);if(d&&d.showCopyright){this.displayCopyright(JXG.JSXGraph.licenseText,12)}},unsuspendRedraw:function(){this.context.restore()},resize:function(d,e){this.canvasRoot.style.width=parseFloat(d)+"px";this.canvasRoot.style.height=parseFloat(e)+"px"}});