/*
    JSXGraph 1.9.1

    Copyright 2008-2024
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Andreas Walter,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <https://www.gnu.org/licenses/>
    and <https://opensource.org/licenses/MIT/>.
*/

/**
 * UTF-8 Decoder by Bjoern Hoehrmann
 *
 * Copyright (c) 2008-2009 Bjoern Hoehrmann <bjoern@hoehrmann.de>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this
 * software and associated documentation files (the "Software"), to deal in the Software
 * without restriction, including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
!function(t,e){"object"==typeof exports&&"object"==typeof module?module.exports=e():"function"==typeof define&&define.amd?define([],e):"object"==typeof exports?exports.JXG=e():t.JXG=e()}("undefined"!=typeof self?self:this,(function(){return function(){"use strict";var __webpack_modules__={561:function(t,e,i){var s,r=i(443),o="1.9.1";s={version:o,licenseText:"JSXGraph v1.9.1 Copyright (C) see https://jsxgraph.org",COORDS_BY_USER:1,COORDS_BY_SCREEN:2,OBJECT_TYPE_ARC:1,OBJECT_TYPE_ARROW:2,OBJECT_TYPE_AXIS:3,OBJECT_TYPE_AXISPOINT:4,OBJECT_TYPE_TICKS:5,OBJECT_TYPE_CIRCLE:6,OBJECT_TYPE_CONIC:7,OBJECT_TYPE_CURVE:8,OBJECT_TYPE_GLIDER:9,OBJECT_TYPE_IMAGE:10,OBJECT_TYPE_LINE:11,OBJECT_TYPE_POINT:12,OBJECT_TYPE_SLIDER:13,OBJECT_TYPE_CAS:14,OBJECT_TYPE_GXTCAS:15,OBJECT_TYPE_POLYGON:16,OBJECT_TYPE_SECTOR:17,OBJECT_TYPE_TEXT:18,OBJECT_TYPE_ANGLE:19,OBJECT_TYPE_INTERSECTION:20,OBJECT_TYPE_TURTLE:21,OBJECT_TYPE_VECTOR:22,OBJECT_TYPE_OPROJECT:23,OBJECT_TYPE_GRID:24,OBJECT_TYPE_TANGENT:25,OBJECT_TYPE_HTMLSLIDER:26,OBJECT_TYPE_CHECKBOX:27,OBJECT_TYPE_INPUT:28,OBJECT_TYPE_BUTTON:29,OBJECT_TYPE_TRANSFORMATION:30,OBJECT_TYPE_FOREIGNOBJECT:31,OBJECT_TYPE_VIEW3D:32,OBJECT_TYPE_POINT3D:33,OBJECT_TYPE_LINE3D:34,OBJECT_TYPE_PLANE3D:35,OBJECT_TYPE_CURVE3D:36,OBJECT_TYPE_SURFACE3D:37,OBJECT_TYPE_MEASUREMENT:38,OBJECT_TYPE_INTERSECTION_LINE3D:39,OBJECT_TYPE_SPHERE3D:40,OBJECT_TYPE_CIRCLE3D:41,OBJECT_TYPE_INTERSECTION_CIRCLE3D:42,OBJECT_CLASS_POINT:1,OBJECT_CLASS_LINE:2,OBJECT_CLASS_CIRCLE:3,OBJECT_CLASS_CURVE:4,OBJECT_CLASS_AREA:5,OBJECT_CLASS_OTHER:6,OBJECT_CLASS_TEXT:7,OBJECT_CLASS_3D:8},r.A.extendConstants(r.A,s),e.A=s},904:function(t,e,i){var s=i(443),r=i(561),o=i(454),n=i(188),a=i(477);s.A.Coords=function(t,e,i,s){this.board=i,this.usrCoords=[],this.scrCoords=[],this.emitter=!n.A.exists(s)||s,this.emitter&&o.A.eventify(this),this.setCoordinates(t,e,!1,!0)},s.A.extend(s.A.Coords.prototype,{normalizeUsrCoords:function(){Math.abs(this.usrCoords[0])>a.A.eps&&(this.usrCoords[1]/=this.usrCoords[0],this.usrCoords[2]/=this.usrCoords[0],this.usrCoords[0]=1)},usr2screen:function(t){var e=Math.round,i=this.board,s=this.usrCoords,r=i.origin.scrCoords;!0===t?(this.scrCoords[0]=e(s[0]),this.scrCoords[1]=e(s[0]*r[1]+s[1]*i.unitX),this.scrCoords[2]=e(s[0]*r[2]-s[2]*i.unitY)):(this.scrCoords[0]=s[0],this.scrCoords[1]=s[0]*r[1]+s[1]*i.unitX,this.scrCoords[2]=s[0]*r[2]-s[2]*i.unitY)},screen2usr:function(){var t=this.board.origin.scrCoords,e=this.scrCoords,i=this.board;this.usrCoords[0]=1,this.usrCoords[1]=(e[1]-t[1])/i.unitX,this.usrCoords[2]=(t[2]-e[2])/i.unitY},distance:function(t,e){var i,s,o=this.usrCoords,n=this.scrCoords;return t===r.A.COORDS_BY_USER?(i=e.usrCoords,(s=o[0]-i[0])*s>a.A.eps*a.A.eps?Number.POSITIVE_INFINITY:a.A.hypot(o[1]-i[1],o[2]-i[2])):(i=e.scrCoords,a.A.hypot(n[1]-i[1],n[2]-i[2]))},setCoordinates:function(t,e,i,s){var o=this.usrCoords,n=this.scrCoords,a=[o[0],o[1],o[2]],l=[n[0],n[1],n[2]];return t===r.A.COORDS_BY_USER?(2===e.length?(o[0]=1,o[1]=e[0],o[2]=e[1]):(o[0]=e[0],o[1]=e[1],o[2]=e[2],this.normalizeUsrCoords()),this.usr2screen(i)):(2===e.length?(n[1]=e[0],n[2]=e[1]):(n[1]=e[1],n[2]=e[2]),this.screen2usr()),!this.emitter||s||l[1]===n[1]&&l[2]===n[2]||this.triggerEventHandlers(["update"],[a,l]),this},copy:function(t,e){return void 0===e&&(e=0),this[t].slice(e)},isReal:function(){return!isNaN(this.usrCoords[1]+this.usrCoords[2])&&Math.abs(this.usrCoords[0])>a.A.eps},__evt__update:function(t,e){},__evt:function(){}}),e.A=s.A.Coords},102:function(t,e,i){var s=i(443),r=i(477),o=i(571),n=i(171),a=i(588),l=i(904),h=i(561),u=i(188);s.A.CoordsElement=function(t,e){var i;for(u.A.exists(t)||(t=[1,0,0]),i=0;i<t.length;++i)t[i]=parseFloat(t[i]);this.coords=new l.A(h.A.COORDS_BY_USER,t,this.board),this.initialCoords=new l.A(h.A.COORDS_BY_USER,t,this.board),this.position=null,this.isConstrained=!1,this.onPolygon=!1,this.slideObject=null,this.slideObjects=[],this.needsUpdateFromParent=!0,this.groups=[],this.Xjc=null,this.Yjc=null,this.methodMap=u.A.deepCopy(this.methodMap,{move:"moveTo",moveTo:"moveTo",moveAlong:"moveAlong",visit:"visit",glide:"makeGlider",makeGlider:"makeGlider",intersect:"makeIntersection",makeIntersection:"makeIntersection",X:"X",Y:"Y",Coords:"Coords",free:"free",setPosition:"setGliderPosition",setGliderPosition:"setGliderPosition",addConstraint:"addConstraint",dist:"Dist",Dist:"Dist",onPolygon:"onPolygon",startAnimation:"startAnimation",stopAnimation:"stopAnimation"}),u.A.exists(this.element)&&this.addAnchor(t,e),this.isDraggable=!0},s.A.extend(s.A.CoordsElement.prototype,{updateConstraint:function(){return this},updateCoords:function(t){return this.needsUpdate?(u.A.exists(t)||(t=!1),u.A.evaluate(this.visProp.frozen)||this.updateConstraint(),this.type===h.A.OBJECT_TYPE_GLIDER&&(this.isConstrained&&(t=!1),t?this.updateGliderFromParent():this.updateGlider()),this.updateTransform(t),this):this},updateGlider:function(){var t,e,i,s,n,a,c,d,p,_,f,A,g,m,y,b,v,C,P,x,E=2*Math.PI,O=!1,S=this.slideObject,M=[];if(this.needsUpdateFromParent=!1,S.elementClass===h.A.OBJECT_CLASS_CIRCLE)u.A.evaluate(this.visProp.isgeonext)&&(E=1),m=o.A.projectPointToCircle(this,S,this.board),y=o.A.rad([S.center.X()+1,S.center.Y()],S.center,this)/E;else if(S.elementClass===h.A.OBJECT_CLASS_LINE){if(this.onPolygon){if(s=S.point1.coords.usrCoords,e=(n=S.point2.coords.usrCoords)[t=1]-s[t],Math.abs(e)<r.A.eps&&(e=n[t=2]-s[t]),c=(o.A.projectPointToLine(this,S,this.board).usrCoords[t]-s[t])/e,a=S.parentPolygon,c<0){for(t=0;t<a.borders.length;t++)if(S===a.borders[t]){S=a.borders[(t-1+a.borders.length)%a.borders.length];break}}else if(c>1)for(t=0;t<a.borders.length;t++)if(S===a.borders[t]){S=a.borders[(t+1+a.borders.length)%a.borders.length];break}S.id!==this.slideObject.id&&(this.slideObject=S)}s=S.point1.coords,n=S.point2.coords,(e=s.distance(h.A.COORDS_BY_USER,n))<r.A.eps?(m=s,O=!0,y=0):(m=o.A.projectPointToLine(this,S,this.board),s=s.usrCoords.slice(0),n=n.usrCoords.slice(0),Math.abs(n[0])<r.A.eps?(e=n[t=1],Math.abs(e)<r.A.eps&&(e=n[t=2]),y=((e=(m.usrCoords[t]-s[t])/e)>=0?1:-1)*(e=Math.abs(e))/(e+1)):Math.abs(s[0])<r.A.eps?(e=s[t=1],Math.abs(e)<r.A.eps&&(e=s[t=2]),y=(e=(m.usrCoords[t]-n[t])/e)<0?(1-2*e)/(1-e):1/(e+1)):(e=n[t=1]-s[t],Math.abs(e)<r.A.eps&&(e=n[t=2]-s[t]),y=(m.usrCoords[t]-s[t])/e)),null!==(v=this.findClosestSnapValue(y))?(y=(u.A.evaluate(this.visProp.snapvalues)[v]-this._smin)/(this._smax-this._smin),this.update(!0)):(b=u.A.evaluate(this.visProp.snapwidth),u.A.evaluate(b)>0&&Math.abs(this._smax-this._smin)>=r.A.eps&&(i=(y=Math.max(Math.min(y,1),0))*(this._smax-this._smin)+this._smin,y=((i=Math.round(i/b)*b)-this._smin)/(this._smax-this._smin),this.update(!0))),s=S.point1.coords,!u.A.evaluate(S.visProp.straightfirst)&&Math.abs(s.usrCoords[0])>r.A.eps&&y<0&&(m=s,O=!0,y=0),n=S.point2.coords,!u.A.evaluate(S.visProp.straightlast)&&Math.abs(n.usrCoords[0])>r.A.eps&&y>1&&(m=n,O=!0,y=1)}else if(S.type===h.A.OBJECT_TYPE_TURTLE)this.updateConstraint(),m=(C=o.A.projectPointToTurtle(this,S,this.board))[0],y=C[1];else if(S.elementClass===h.A.OBJECT_CLASS_CURVE)if(S.type===h.A.OBJECT_TYPE_ARC||S.type===h.A.OBJECT_TYPE_SECTOR)m=o.A.projectPointToCircle(this,S,this.board),d=o.A.rad(S.radiuspoint,S.center,this),p=0,_=o.A.rad(S.radiuspoint,S.center,S.anglepoint),y=d,("minor"===(b=u.A.evaluate(S.visProp.selection))&&_>Math.PI||"major"===b&&_<Math.PI)&&(p=_,_=2*Math.PI),(d<p||d>_)&&(y=_,(d<p&&d>.5*p||d>_&&d>.5*_+Math.PI)&&(y=p),this.needsUpdateFromParent=!0,this.updateGliderFromParent()),E=_-p,this.visProp.isgeonext&&(E=1),Math.abs(E)>r.A.eps&&(y/=E);else if(this.updateConstraint(),S.transformations.length>0){for(x=!1,(C=S.getTransformationSource())[0]&&(x=C[0],M.push(S),M.push(C[1]));C[0]&&u.A.exists(C[1]._transformationSource);)C=C[1].getTransformationSource(),M.push(C[1]);if(P=this.coords.usrCoords,x){for(t=0;t<M.length;t++)M[t].updateTransformMatrix(),g=r.A.inverse(M[t].transformMat),P=r.A.matVecMult(g,P);for(f=new l.A(h.A.COORDS_BY_USER,P,this.board).usrCoords,P=(A=o.A.projectCoordsToCurve(f[1],f[2],this.position||0,M[M.length-1],this.board))[0].usrCoords,t=M.length-2;t>=0;t--)P=r.A.matVecMult(M[t].transformMat,P);A[0]=new l.A(h.A.COORDS_BY_USER,P,this.board)}else S.updateTransformMatrix(),g=r.A.inverse(S.transformMat),P=r.A.matVecMult(g,P),f=new l.A(h.A.COORDS_BY_USER,P,this.board).usrCoords,A=o.A.projectCoordsToCurve(f[1],f[2],this.position||0,S,this.board);m=A[0],y=A[1]}else m=(C=o.A.projectPointToCurve(this,S,this.board))[0],y=C[1];else u.A.isPoint(S)&&(m=o.A.projectPointToPoint(this,S,this.board),y=this.position);this.coords.setCoordinates(h.A.COORDS_BY_USER,m.usrCoords,O),this.position=y},findClosestSnapValue:function(t){var e,i,s,o,n=null;if(s=u.A.evaluate(this.visProp.snapvalues),o=u.A.evaluate(this.visProp.snapvaluedistance),u.A.isArray(s)&&Math.abs(this._smax-this._smin)>=r.A.eps&&o>0)for(e=0;e<s.length;e++)(i=Math.abs(t*(this._smax-this._smin)+this._smin-s[e]))<o&&(o=i,n=e);return n},updateGliderFromParent:function(){var t,e,i,s,n,a,c,d,p,_,f,A,g=this.slideObject,m=[],y=2*Math.PI;if(this.needsUpdateFromParent){if(g.elementClass===h.A.OBJECT_CLASS_CIRCLE)i=g.Radius(),u.A.evaluate(this.visProp.isgeonext)&&(y=1),n=[g.center.X()+i*Math.cos(this.position*y),g.center.Y()+i*Math.sin(this.position*y)];else if(g.elementClass===h.A.OBJECT_CLASS_LINE)t=g.point1.coords.usrCoords,e=g.point2.coords.usrCoords,0===t[0]&&0===t[1]&&0===t[2]||0===e[0]&&0===e[1]&&0===e[2]?n=[0,0,0]:Math.abs(e[0])<r.A.eps?(s=Math.min(Math.abs(this.position),1-r.A.eps),s/=1-s,this.position<0&&(s=-s),n=[t[0]+s*e[0],t[1]+s*e[1],t[2]+s*e[2]]):Math.abs(t[0])<r.A.eps?(s=Math.max(this.position,r.A.eps),s=(s=Math.min(s,2-r.A.eps))>1?(s-1)/(s-2):(1-s)/s,n=[e[0]+s*t[0],e[1]+s*t[1],e[2]+s*t[2]]):(s=this.position,n=[t[0]+s*(e[0]-t[0]),t[1]+s*(e[1]-t[1]),t[2]+s*(e[2]-t[2])]);else if(g.type===h.A.OBJECT_TYPE_TURTLE)this.coords.setCoordinates(h.A.COORDS_BY_USER,[g.Z(this.position),g.X(this.position),g.Y(this.position)]),this.updateConstraint(),n=o.A.projectPointToTurtle(this,g,this.board)[0].usrCoords;else if(g.elementClass===h.A.OBJECT_CLASS_CURVE){for(d=!1,(a=g.getTransformationSource())[0]&&(d=a[0],m.push(g),m.push(a[1]));a[0]&&u.A.exists(a[1]._transformationSource);)a=a[1].getTransformationSource(),m.push(a[1]);if(d?this.coords.setCoordinates(h.A.COORDS_BY_USER,[m[m.length-1].Z(this.position),m[m.length-1].X(this.position),m[m.length-1].Y(this.position)]):this.coords.setCoordinates(h.A.COORDS_BY_USER,[g.Z(this.position),g.X(this.position),g.Y(this.position)]),g.type===h.A.OBJECT_TYPE_ARC||g.type===h.A.OBJECT_TYPE_SECTOR)p=o.A.rad([g.center.X()+1,g.center.Y()],g.center,g.radiuspoint),_=0,A=o.A.rad(g.radiuspoint,g.center,g.anglepoint),("minor"===g.visProp.selection&&A>Math.PI||"major"===g.visProp.selection&&A<Math.PI)&&(_=A,A=2*Math.PI),y=A-_,u.A.evaluate(this.visProp.isgeonext)&&(y=1),((f=this.position*y)<_||f>A)&&(((f=A)<_&&f>.5*_||f>A&&f>.5*A+Math.PI)&&(f=_),this.position=f,Math.abs(y)>r.A.eps&&(this.position/=y)),i=g.Radius(),n=[g.center.X()+i*Math.cos(this.position*y+p),g.center.Y()+i*Math.sin(this.position*y+p)];else if(this.updateConstraint(),d)for(n=o.A.projectPointToCurve(this,m[m.length-1],this.board)[0].usrCoords,c=m.length-2;c>=0;c--)n=new l.A(h.A.COORDS_BY_USER,r.A.matVecMult(m[c].transformMat,n),this.board).usrCoords;else n=o.A.projectPointToCurve(this,g,this.board)[0].usrCoords}else u.A.isPoint(g)&&(n=o.A.projectPointToPoint(this,g,this.board).usrCoords);this.coords.setCoordinates(h.A.COORDS_BY_USER,n,!1)}else this.needsUpdateFromParent=!0},updateRendererGeneric:function(t){return this.needsUpdate&&this.board.renderer?(this.visPropCalc.visible&&(this.isReal=!isNaN(this.coords.usrCoords[1]+this.coords.usrCoords[2]),this.isReal=Math.abs(this.coords.usrCoords[0])>r.A.eps&&this.isReal,this.isReal||this.updateVisibility(!1)),this.visPropCalc.visible&&this.board.renderer[t](this),this.hasLabel&&this.visPropCalc.visible&&this.label&&this.label.visPropCalc.visible&&this.isReal&&(this.label.update(),this.board.renderer.updateText(this.label)),this.setDisplayRendNode(),this.needsUpdate=!1,this):this},X:function(){return this.coords.usrCoords[1]},Y:function(){return this.coords.usrCoords[2]},Z:function(){return this.coords.usrCoords[0]},Coords:function(t){return t?this.coords.usrCoords.slice():this.coords.usrCoords.slice(1)},XEval:function(){return this.coords.usrCoords[1]},YEval:function(){return this.coords.usrCoords[2]},ZEval:function(){return this.coords.usrCoords[0]},Dist:function(t){return this.isReal&&t.isReal?this.coords.distance(h.A.COORDS_BY_USER,t.coords):NaN},snapToGrid:function(t){return this.handleSnapToGrid(t)},handleSnapToPoints:function(t){var e,i,s,r,n,a,l,c,d=0,p=1/0,_=null,f=u.A.evaluate(this.visProp.ignoredsnaptopoints),A=!1;if(r=this.board.objectsList.length,f&&(l=f.length),u.A.evaluate(this.visProp.snaptopoints)||t){for(n=u.A.evaluate(this.visProp.attractorunit),a=u.A.evaluate(this.visProp.attractordistance),e=0;e<r;e++){if(i=this.board.objectsList[e],f){for(A=!1,c=0;c<l;c++)if(i===this.board.select(f[c])){A=!0;break}if(A)continue}u.A.isPoint(i)&&i!==this&&i.visPropCalc.visible&&(s=o.A.projectPointToPoint(this,i,this.board),(d="screen"===n?s.distance(h.A.COORDS_BY_SCREEN,this.coords):s.distance(h.A.COORDS_BY_USER,this.coords))<a&&d<p&&(p=d,_=s))}null!==_&&this.coords.setCoordinates(h.A.COORDS_BY_USER,_.usrCoords)}return this},snapToPoints:function(t){return this.handleSnapToPoints(t)},handleAttractors:function(){var t,e,i,s,r=0,n=u.A.evaluate(this.visProp.attractorunit),a=u.A.evaluate(this.visProp.attractordistance),c=u.A.evaluate(this.visProp.snatchdistance),d=u.A.evaluate(this.visProp.attractors),p=d.length;if(0!==a){for(t=0;t<p;t++)if(e=this.board.select(d[t]),u.A.exists(e)&&e!==this){if(u.A.isPoint(e)?i=o.A.projectPointToPoint(this,e,this.board):e.elementClass===h.A.OBJECT_CLASS_LINE?(s=o.A.projectCoordsToSegment(this.coords.usrCoords,e.point1.coords.usrCoords,e.point2.coords.usrCoords),i=!u.A.evaluate(e.visProp.straightfirst)&&s[1]<0?e.point1.coords:!u.A.evaluate(e.visProp.straightlast)&&s[1]>1?e.point2.coords:new l.A(h.A.COORDS_BY_USER,s[0],this.board)):e.elementClass===h.A.OBJECT_CLASS_CIRCLE?i=o.A.projectPointToCircle(this,e,this.board):e.elementClass===h.A.OBJECT_CLASS_CURVE?i=o.A.projectPointToCurve(this,e,this.board)[0]:e.type===h.A.OBJECT_TYPE_TURTLE?i=o.A.projectPointToTurtle(this,e,this.board)[0]:e.type===h.A.OBJECT_TYPE_POLYGON&&(i=new l.A(h.A.COORDS_BY_USER,o.A.projectCoordsToPolygon(this.coords.usrCoords,e),this.board)),(r="screen"===n?i.distance(h.A.COORDS_BY_SCREEN,this.coords):i.distance(h.A.COORDS_BY_USER,this.coords))<a){this.type===h.A.OBJECT_TYPE_GLIDER&&(e===this.slideObject||this.slideObject&&this.onPolygon&&this.slideObject.parentPolygon===e)||this.makeGlider(e);break}r>=c&&(e===this.slideObject||this.slideObject&&this.onPolygon&&this.slideObject.parentPolygon===e)&&this.popSlideObject()}return this}},setPositionDirectly:function(t,e){var i,s,o,n,c=this.coords;if(this.relativeCoords)return s=new l.A(t,e,this.board),u.A.evaluate(this.visProp.islabel)?(o=a.A.subtract(s.scrCoords,c.scrCoords),this.relativeCoords.scrCoords[1]+=o[1],this.relativeCoords.scrCoords[2]+=o[2]):(o=a.A.subtract(s.usrCoords,c.usrCoords),this.relativeCoords.usrCoords[1]+=o[1],this.relativeCoords.usrCoords[2]+=o[2]),this;for(this.coords.setCoordinates(t,e),this.handleSnapToGrid(),this.handleSnapToPoints(),this.handleAttractors(),i=this.transformations.length-1;i>=0;i--)t===h.A.COORDS_BY_SCREEN?n=new l.A(t,e,this.board).usrCoords:(2===e.length&&(e=[1].concat(e)),n=e),this.initialCoords.setCoordinates(h.A.COORDS_BY_USER,r.A.matVecMult(r.A.inverse(this.transformations[i].matrix),n));return this.prepareUpdate().update(),this.board.isSuspendedUpdate&&this.type===h.A.OBJECT_TYPE_GLIDER&&this.updateGlider(),this},setPositionByTransform:function(t,e){var i;return e=new l.A(t,e,this.board),i=this.board.create("transform",e.usrCoords.slice(1),{type:"translate"}),this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix?this.transformations[this.transformations.length-1].melt(i):this.addTransform(this,i),this.prepareUpdate().update(),this},setPosition:function(t,e){return this.setPositionDirectly(t,e)},setGliderPosition:function(t){return this.type===h.A.OBJECT_TYPE_GLIDER&&(this.position=t,this.board.update()),this},makeGlider:function(t){var e,i,r,o=this.board.select(t),n=!1;if(o.type===h.A.OBJECT_TYPE_POLYGON){for(e=Number.MAX_VALUE,i=0;i<o.borders.length;i++)(r=s.A.Math.Geometry.distPointLine(this.coords.usrCoords,o.borders[i].stdform))<e&&(e=r,t=o.borders[i]);o=this.board.select(t),n=!0}if(!u.A.exists(o))throw new Error("JSXGraph: slide object undefined.");if(o.type===h.A.OBJECT_TYPE_TICKS)throw new Error("JSXGraph: gliders on ticks are not possible.");return this.slideObject=this.board.select(t),this.slideObjects.push(this.slideObject),this.addParents(t),this.type=h.A.OBJECT_TYPE_GLIDER,this.elType="glider",this.visProp.snapwidth=-1,this.slideObject.addChild(this),this.isDraggable=!0,this.onPolygon=n,this.generatePolynomial=function(){return this.slideObject.generatePolynomial(this)},this.updateGlider(),this.needsUpdateFromParent=!0,this.updateGliderFromParent(),this},popSlideObject:function(){this.slideObjects.length>0&&(this.slideObjects.pop(),this.slideObject.removeChild(this),0===this.slideObjects.length?(this.type=this._org_type,this.type===h.A.OBJECT_TYPE_POINT?this.elType="point":this.elementClass===h.A.OBJECT_CLASS_TEXT?this.elType="text":this.type===h.A.OBJECT_TYPE_IMAGE?this.elType="image":this.type===h.A.OBJECT_TYPE_FOREIGNOBJECT&&(this.elType="foreignobject"),this.slideObject=null):this.slideObject=this.slideObjects[this.slideObjects.length-1])},free:function(){var t,e;if(this.type!==h.A.OBJECT_TYPE_GLIDER){if(this.transformations.length=0,delete this.updateConstraint,this.isConstrained=!1,this.isDraggable)return;this.isDraggable=!0,this.elementClass===h.A.OBJECT_CLASS_POINT&&(this.type=h.A.OBJECT_TYPE_POINT,this.elType="point"),this.XEval=function(){return this.coords.usrCoords[1]},this.YEval=function(){return this.coords.usrCoords[2]},this.ZEval=function(){return this.coords.usrCoords[0]},this.Xjc=null,this.Yjc=null}for(t in this.board.objects)this.board.objects.hasOwnProperty(t)&&(e=this.board.objects[t]).descendants&&(delete e.descendants[this.id],delete e.childElements[this.id],this.hasLabel&&(delete e.descendants[this.label.id],delete e.childElements[this.label.id]));this.ancestors={},this.parents=[],this.slideObject=null,this.slideObjects=[],this.elementClass===h.A.OBJECT_CLASS_POINT?(this.type=h.A.OBJECT_TYPE_POINT,this.elType="point"):this.elementClass===h.A.OBJECT_CLASS_TEXT?(this.type=this._org_type,this.elType="text"):this.elementClass===h.A.OBJECT_CLASS_OTHER&&(this.type=this._org_type,this.elType="image")},addConstraint:function(t){var e,i,s=[],r=["X","Y"],o=function(t){return function(){return t}},n=function(t){return function(){return t.Value()}};for(this.elementClass===h.A.OBJECT_CLASS_POINT&&(this.type=h.A.OBJECT_TYPE_CAS),this.isDraggable=!1,e=0;e<t.length;e++)i=t[e],u.A.isString(i)?(s[e]=this.board.jc.snippet(i,!0,null,!0),this.addParentsFromJCFunctions([s[e]]),2===t.length&&(this[r[e]+"jc"]=t[e])):u.A.isFunction(i)?s[e]=i:u.A.isNumber(i)?s[e]=o(i):u.A.isObject(i)&&u.A.isFunction(i.Value)&&(s[e]=n(i)),s[e].origin=i;return 1===t.length?this.updateConstraint=function(){var t=s[0]();return u.A.isArray(t)?this.coords.setCoordinates(h.A.COORDS_BY_USER,t):this.coords=t,this}:2===t.length?(this.XEval=s[0],this.YEval=s[1],this.addParents([s[0].origin,s[1].origin]),this.updateConstraint=function(){return this.coords.setCoordinates(h.A.COORDS_BY_USER,[this.XEval(),this.YEval()]),this}):(this.ZEval=s[0],this.XEval=s[1],this.YEval=s[2],this.addParents([s[0].origin,s[1].origin,s[2].origin]),this.updateConstraint=function(){return this.coords.setCoordinates(h.A.COORDS_BY_USER,[this.ZEval(),this.XEval(),this.YEval()]),this}),this.isConstrained=!0,this.prepareUpdate().update(),this.board.isSuspendedUpdate||(this.updateVisibility().updateRenderer(),this.hasLabel&&this.label.fullUpdate()),this},addAnchor:function(t,e){this.relativeCoords=e?new l.A(h.A.COORDS_BY_SCREEN,t.slice(0,2),this.board):new l.A(h.A.COORDS_BY_USER,t,this.board),this.element.addChild(this),e&&this.addParents(this.element),this.XEval=function(){var t,e,i;return u.A.evaluate(this.visProp.islabel)?(i=u.A.evaluate(this.visProp.offset),t=parseFloat(i[0]),e=this.element.getLabelAnchor(),new l.A(h.A.COORDS_BY_SCREEN,[t+this.relativeCoords.scrCoords[1]+e.scrCoords[1],0],this.board).usrCoords[1]):(e=this.element.getTextAnchor(),this.relativeCoords.usrCoords[1]+e.usrCoords[1])},this.YEval=function(){var t,e,i;return u.A.evaluate(this.visProp.islabel)?(i=u.A.evaluate(this.visProp.offset),t=-parseFloat(i[1]),e=this.element.getLabelAnchor(),new l.A(h.A.COORDS_BY_SCREEN,[0,t+this.relativeCoords.scrCoords[2]+e.scrCoords[2]],this.board).usrCoords[2]):(e=this.element.getTextAnchor(),this.relativeCoords.usrCoords[2]+e.usrCoords[2])},this.ZEval=u.A.createFunction(1,this.board,""),this.updateConstraint=function(){this.coords.setCoordinates(h.A.COORDS_BY_USER,[this.ZEval(),this.XEval(),this.YEval()])},this.isConstrained=!0,this.updateConstraint()},updateTransform:function(t){var e;if(0===this.transformations.length)return this;for(e=0;e<this.transformations.length;e++)this.transformations[e].update();return this},addTransform:function(t,e){var i,s=u.A.isArray(e)?e:[e],r=s.length;for(0===this.transformations.length&&(this.baseElement=t),i=0;i<r;i++)this.transformations.push(s[i]);return this},startAnimation:function(t,e,i){var s=u.A.evaluate(t),r=u.A.evaluate(e),o=this;return i=u.A.evaluate(i)||250,this.type!==h.A.OBJECT_TYPE_GLIDER||u.A.exists(this.intervalCode)||(this.intervalCode=window.setInterval((function(){o._anim(s,r)}),i),u.A.exists(this.intervalCount)||(this.intervalCount=0)),this},stopAnimation:function(){return u.A.exists(this.intervalCode)&&(window.clearInterval(this.intervalCode),delete this.intervalCode),this},moveAlong:function(t,e,i){i=i||{};var s,r,o,a,l,c=[],d=[],p=e/this.board.attr.animationdelay,_=function(e,i){return function(){return t[e][i]}};if(u.A.isArray(t)){for(o=t.length,s=0;s<o;s++)u.A.isPoint(t[s])?d[s]=t[s]:d[s]={elementClass:h.A.OBJECT_CLASS_POINT,X:_(s,0),Y:_(s,1)};if(0===(e=e||0))return this.setPosition(h.A.COORDS_BY_USER,[d[d.length-1].X(),d[d.length-1].Y()]),this.board.update(this);if(!u.A.exists(i.interpolate)||i.interpolate)for(r=n.A.Neville(d),s=0;s<p;s++)c[s]=[],c[s][0]=r[0]((p-s)/p*r[3]()),c[s][1]=r[1]((p-s)/p*r[3]());else{for(o=t.length-1,s=0;s<p;++s)l=s/p*o-(a=Math.floor(s/p*o)),c[s]=[],c[s][0]=(1-l)*d[a].X()+l*d[a+1].X(),c[s][1]=(1-l)*d[a].Y()+l*d[a+1].Y();c.push([d[o].X(),d[o].Y()]),c.reverse()}this.animationPath=c}else u.A.isFunction(t)&&(this.animationPath=t,this.animationStart=(new Date).getTime());return this.animationCallback=i.callback,this.board.addAnimation(this),this},moveTo:function(t,e,i){i=i||{},t=new l.A(h.A.COORDS_BY_USER,t,this.board);var s,o=this.board.attr.animationdelay,n=Math.ceil(e/o),a=[],c=this.coords.usrCoords[1],d=this.coords.usrCoords[2],p=t.usrCoords[1]-c,_=t.usrCoords[2]-d,f=function(t){return i.effect&&"<>"===i.effect?Math.pow(Math.sin(t/n*Math.PI/2),2):t/n};if(!u.A.exists(e)||0===e||Math.abs(t.usrCoords[0]-this.coords.usrCoords[0])>r.A.eps)return this.setPosition(h.A.COORDS_BY_USER,t.usrCoords),this.board.update(this);if(!u.A.exists(i.callback)&&Math.abs(p)<r.A.eps&&Math.abs(_)<r.A.eps)return this;for(s=n;s>=0;s--)a[n-s]=[t.usrCoords[0],c+p*f(s),d+_*f(s)];return this.animationPath=a,this.animationCallback=i.callback,this.board.addAnimation(this),this},visit:function(t,e,i){t=new l.A(h.A.COORDS_BY_USER,t,this.board);var s,r,o,n=this.board.attr.animationdelay,a=[],c=this.coords.usrCoords[1],d=this.coords.usrCoords[2],p=t.usrCoords[1]-c,_=t.usrCoords[2]-d,f=function(t){var e=t<o/2?2*t/o:2*(o-t)/o;return i.effect&&"<>"===i.effect?Math.pow(Math.sin(e*Math.PI/2),2):e};for(u.A.isNumber(i)?i={repeat:i}:(i=i||{},u.A.exists(i.repeat)||(i.repeat=1)),o=Math.ceil(e/(n*i.repeat)),r=0;r<i.repeat;r++)for(s=o;s>=0;s--)a[r*(o+1)+o-s]=[t.usrCoords[0],c+p*f(s),d+_*f(s)];return this.animationPath=a,this.animationCallback=i.callback,this.board.addAnimation(this),this},_anim:function(t,e){var i,s,r,n,a,l,u,c,d;return this.intervalCount+=1,this.intervalCount>e&&(this.intervalCount=0),this.slideObject.elementClass===h.A.OBJECT_CLASS_LINE?(u=this.slideObject.point1.coords.scrCoords,c=this.slideObject.point2.coords.scrCoords,i=Math.round((c[1]-u[1])*this.intervalCount/e),s=Math.round((c[2]-u[2])*this.intervalCount/e),t>0?n=this.slideObject.point1:(n=this.slideObject.point2,i*=-1,s*=-1),this.coords.setCoordinates(h.A.COORDS_BY_SCREEN,[n.coords.scrCoords[1]+i,n.coords.scrCoords[2]+s])):this.slideObject.elementClass===h.A.OBJECT_CLASS_CURVE?(a=t>0?Math.round(this.intervalCount/e*this.board.canvasWidth):Math.round((e-this.intervalCount)/e*this.board.canvasWidth),this.coords.setCoordinates(h.A.COORDS_BY_SCREEN,[a,0]),d=o.A.projectPointToCurve(this,this.slideObject,this.board),this.coords=d[0],this.position=d[1]):this.slideObject.elementClass===h.A.OBJECT_CLASS_CIRCLE&&(r=2*Math.PI,r*=t<0?this.intervalCount/e:(e-this.intervalCount)/e,l=this.slideObject.Radius(),this.coords.setCoordinates(h.A.COORDS_BY_USER,[this.slideObject.center.coords.usrCoords[1]+l*Math.cos(r),this.slideObject.center.coords.usrCoords[2]+l*Math.sin(r)])),this.board.update(this),this},getTextAnchor:function(){return this.coords},getLabelAnchor:function(){return this.coords},getParents:function(){var t=[this.Z(),this.X(),this.Y()];return 0!==this.parents.length&&(t=this.parents),this.type===h.A.OBJECT_TYPE_GLIDER&&(t=[this.X(),this.Y(),this.slideObject.id]),t}}),s.A.CoordsElement.create=function(t,e,i,s,r,o){var n,a,l=!1;for(a=0;a<i.length;a++)(u.A.isFunction(i[a])||u.A.isString(i[a]))&&(l=!0);if(l)(n=new t(e,[0,0],s,r,o)).addConstraint(i);else if(u.A.isNumber(i[0])&&u.A.isNumber(i[1]))n=new t(e,i,s,r,o),u.A.exists(s.slideobject)?n.makeGlider(s.slideobject):n.baseElement=n,n.isDraggable=!0;else{if(!u.A.isObject(i[0])||!u.A.isTransformationOrArray(i[1]))return!1;(n=new t(e,[0,0],s,r,o)).addTransform(i[0],i[1]),n.isDraggable=!1}return n.handleSnapToGrid(),n.handleSnapToPoints(),n.handleAttractors(),n.addParents(i),n},e.A=s.A.CoordsElement},144:function(t,e,i){var s=i(443),r=i(561),o=i(904),n=i(477),a=i(588),l=i(378),h=i(454),u=i(873),c=i(188);s.A.GeometryElement=function(t,e,i,s){var o,n,a;if(this.needsUpdate=!0,this.isDraggable=!1,this.isReal=!0,this.childElements={},this.hasLabel=!1,this.highlighted=!1,this.notExistingParents={},this.traces={},this.numTraces=0,this.transformations=[],this.baseElement=null,this.descendants={},this.ancestors={},this.parents=[],this.symbolic={},this.rendNode=null,this.elType="",this.dump=!0,this.subs={},this.inherits=[],this._pos=-1,this.stdform=[1,0,0,0,1,1,0,0],this.methodMap={setLabel:"setLabel",label:"label",setName:"setName",getName:"getName",Name:"getName",addTransform:"addTransform",setProperty:"setAttribute",setAttribute:"setAttribute",addChild:"addChild",animate:"animate",on:"on",off:"off",trigger:"trigger",addTicks:"addTicks",removeTicks:"removeTicks",removeAllTicks:"removeAllTicks",Bounds:"bounds"},this.quadraticform=[[1,0,0],[0,1,0],[0,0,1]],this.visProp={},this.visPropCalc={visible:!1},h.A.eventify(this),this.mouseover=!1,this.lastDragTime=new Date,arguments.length>0){for(n in this.board=t,this.type=i,this._org_type=i,this.elementClass=s||r.A.OBJECT_CLASS_OTHER,this.id=e.id,o=e.name,c.A.exists(o)||(o=this.board.generateName(this)),""!==o&&(this.board.elementsByName[o]=this),this.name=o,this.needsRegularUpdate=e.needsregularupdate,c.A.clearVisPropOld(this),a=this.resolveShortcuts(e))a.hasOwnProperty(n)&&this._set(n,a[n]);this.visProp.draft=a.draft&&a.draft.draft}},s.A.extend(s.A.GeometryElement.prototype,{addChild:function(t){var e,i;for(e in this.childElements[t.id]=t,this.addDescendants(t),t.ancestors[this.id]=this,this.descendants)if(this.descendants.hasOwnProperty(e))for(i in this.descendants[e].ancestors[this.id]=this,this.ancestors)this.ancestors.hasOwnProperty(i)&&(this.descendants[e].ancestors[this.ancestors[i].id]=this.ancestors[i]);for(e in this.ancestors)if(this.ancestors.hasOwnProperty(e))for(i in this.descendants)this.descendants.hasOwnProperty(i)&&(this.ancestors[e].descendants[this.descendants[i].id]=this.descendants[i]);return this},addDescendants:function(t){var e;for(e in this.descendants[t.id]=t,t.childElements)t.childElements.hasOwnProperty(e)&&this.addDescendants(t.childElements[e]);return this},addParents:function(t){var e,i,s;for(i=(s=c.A.isArray(t)?t:arguments).length,e=0;e<i;++e)c.A.exists(s[e])&&(c.A.isId(this.board,s[e])?this.parents.push(s[e]):c.A.exists(s[e].id)&&this.parents.push(s[e].id));this.parents=c.A.uniqueArray(this.parents)},setParents:function(t){this.parents=[],this.addParents(t)},addParentsFromJCFunctions:function(t){var e,i,s;for(e=0;e<t.length;e++)for(i in t[e].deps)s=t[e].deps[i],this.addParents(s),s.addChild(this);return this},removeChild:function(t){return delete this.childElements[t.id],this.removeDescendants(t),delete t.ancestors[this.id],this},removeDescendants:function(t){var e;for(e in delete this.descendants[t.id],t.childElements)t.childElements.hasOwnProperty(e)&&this.removeDescendants(t.childElements[e]);return this},countChildren:function(){var t,e,i=0;for(t in e=this.childElements)e.hasOwnProperty(t)&&t.indexOf("Label")<0&&i++;return i},getName:function(){return this.name},addTransform:function(t){return this},draggable:function(){return this.isDraggable&&!c.A.evaluate(this.visProp.fixed)&&this.type!==r.A.OBJECT_TYPE_GLIDER},setPosition:function(t,e){var i,s,o,n,a=[];if(!c.A.exists(this.parents))return this;for(o=this.parents.length,s=0;s<o;++s)if(i=this.board.select(this.parents[s]),c.A.isPoint(i)){if(!i.draggable())return this;a.push(i)}for(3===e.length&&(e=e.slice(1)),n=this.board.create("transform",e,{type:"translate"}),(o=a.length)>0?n.applyOnce(a):this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix?this.transformations[this.transformations.length-1].melt(n):this.addTransform(n),s=0;s<o;++s)a[s].type===r.A.OBJECT_TYPE_GLIDER&&a[s].updateGlider();return this},setPositionDirectly:function(t,e,i){var s=new o.A(t,e,this.board,!1),n=new o.A(t,i,this.board,!1),l=a.A.subtract(s.usrCoords,n.usrCoords);return this.setPosition(r.A.COORDS_BY_USER,l),this},generatePolynomial:function(){return[]},animate:function(t,e,i){i=i||{};var s,r,o,n=this.board.attr.animationdelay,a=Math.ceil(e/n),l=this,h=function(t,e,i){var s,r,n,h,c;for(s=u.A.rgb2hsv(t),n=((r=u.A.rgb2hsv(e))[0]-s[0])/a,h=(r[1]-s[1])/a,c=(r[2]-s[2])/a,l.animationData[i]=[],o=0;o<a;o++)l.animationData[i][a-o-1]=u.A.hsv2rgb(s[0]+(o+1)*n,s[1]+(o+1)*h,s[2]+(o+1)*c)},d=function(t,e,i,s){var r,n;if(t=parseFloat(t),e=parseFloat(e),!isNaN(t)&&!isNaN(e))for(n=(e-t)/a,l.animationData[i]=[],o=0;o<a;o++)r=t+(o+1)*n,l.animationData[i][a-o-1]=s?Math.floor(r):r};for(s in this.animationData={},t)if(t.hasOwnProperty(s))switch(r=s.toLowerCase()){case"strokecolor":case"fillcolor":h(this.visProp[r],t[s],r);break;case"size":if(!c.A.isPoint(this))break;d(this.visProp[r],t[s],r,!0);break;case"strokeopacity":case"strokewidth":case"fillopacity":d(this.visProp[r],t[s],r,!1)}return this.animationCallback=i.callback,this.board.addAnimation(this),this},update:function(){return c.A.evaluate(this.visProp.trace)&&this.cloneToBackground(),this},updateRenderer:function(){return this},fullUpdate:function(t){return this.prepareUpdate().update().updateVisibility(t).updateRenderer()},setDisplayRendNode:function(t){var e,i,s,r,o;if(void 0===t&&(t=this.visPropCalc.visible),t===this.visPropOld.visible)return this;for(this.board.renderer.display(this,t),i=this.inherits.length,s=0;s<i;s++)if(o=this.inherits[s],c.A.isArray(o))for(r=o.length,e=0;e<r;e++)c.A.exists(o[e])&&c.A.exists(o[e].rendNode)&&"inherit"===c.A.evaluate(o[e].visProp.visible)&&o[e].setDisplayRendNode(t);else c.A.exists(o)&&c.A.exists(o.rendNode)&&"inherit"===c.A.evaluate(o.visProp.visible)&&o.setDisplayRendNode(t);return this.hasLabel&&c.A.exists(this.label)&&c.A.exists(this.label.rendNode)&&"inherit"===c.A.evaluate(this.label.visProp.visible)&&this.label.setDisplayRendNode(t),this},hide:function(){return this.setAttribute({visible:!1}),this},hideElement:function(){return this.hide(),this},show:function(){return this.setAttribute({visible:!0}),this},showElement:function(){return this.show(),this},updateVisibility:function(t){var e,i,s,r,o,n;if(this.needsUpdate){for(void 0!==t?this.visPropCalc.visible=t:(n=c.A.evaluate(this.visProp.visible),c.A.exists(this.hiddenByParent)&&this.hiddenByParent&&(n=!1),"inherit"!==n&&(this.visPropCalc.visible=n)),i=this.inherits.length,s=0;s<i;s++)if(o=this.inherits[s],c.A.isArray(o))for(r=o.length,e=0;e<r;e++)c.A.exists(o[e])&&"inherit"===c.A.evaluate(o[e].visProp.visible)&&o[e].prepareUpdate().updateVisibility(this.visPropCalc.visible);else c.A.exists(o)&&"inherit"===c.A.evaluate(o.visProp.visible)&&o.prepareUpdate().updateVisibility(this.visPropCalc.visible);c.A.exists(this.label)&&c.A.exists(this.label.visProp)&&c.A.evaluate(this.label.visProp.visible)&&this.label.prepareUpdate().updateVisibility(this.visPropCalc.visible)}return this},_set:function(t,e){var i;if(t=t.toLocaleLowerCase(),this.visProp.hasOwnProperty(t)&&t.indexOf("color")>=0&&c.A.isString(e)&&9===e.length&&"#"===e.charAt(0))e=u.A.rgba2rgbo(e),this.visProp[t]=e[0],this.visProp[t.replace("color","opacity")]=e[1];else if(null===e||!c.A.isObject(e)||c.A.exists(e.id)||c.A.exists(e.name))this.visProp[t]=e;else for(i in this.visProp[t]={},e)e.hasOwnProperty(i)&&(this.visProp[t][i.toLocaleLowerCase()]=e[i])},resolveShortcuts:function(t){var e,i,s,r=["traceattributes","traceAttributes"];for(e in l.A.shortcuts)if(l.A.shortcuts.hasOwnProperty(e)){if(c.A.exists(t[e]))for(i=0;i<l.A.shortcuts[e].length;i++)c.A.exists(t[l.A.shortcuts[e][i]])||(t[l.A.shortcuts[e][i]]=t[e]);for(s=0;s<r.length;s++)c.A.isObject(t[r[s]])&&(t[r[s]]=this.resolveShortcuts(t[r[s]]))}return t},setLabel:function(t){this.hasLabel||this.setAttribute({withlabel:!0}),this.setLabelText(t)},setLabelText:function(t){return c.A.exists(this.label)&&(t=t.replace(/</g,"&lt;").replace(/>/g,"&gt;"),this.label.setText(t)),this},setName:function(t){t=t.replace(/</g,"&lt;").replace(/>/g,"&gt;"),"slider"!==this.elType&&this.setLabelText(t),this.setAttribute({name:t})},setProperty:function(){s.A.deprecated("setProperty()","setAttribute()"),this.setAttribute.apply(this,arguments)},setAttribute:function(t){var e,i,o,n,a,l,h,d,p,_={};for(e=0;e<arguments.length;e++)l=arguments[e],c.A.isString(l)?(d=l.split(":"),_[c.A.trim(d[0])]=c.A.trim(d[1])):c.A.isArray(l)?_[l[0]]=l[1]:s.A.extend(_,l);for(e in _=this.resolveShortcuts(_))if(_.hasOwnProperty(e)){if(n=e.replace(/\s+/g,"").toLowerCase(),a=_[e],c.A.isObject(a)&&c.A.exists(this.visProp[n])){if(this.visProp[n]=c.A.merge(this.visProp[n],a),this.type===r.A.OBJECT_TYPE_TICKS&&c.A.exists(this.labels))for(o=this.labels.length,i=0;i<o;i++)this.labels[i].setAttribute(a);else if(c.A.exists(this[n]))if(c.A.isArray(this[n]))for(i=0;i<this[n].length;i++)this[n][i].setAttribute(a);else this[n].setAttribute(a);continue}switch(p=this.visProp[n],n){case"checked":c.A.exists(this.rendNodeTag)&&(this.rendNodeCheckbox.checked=!!a);break;case"disabled":c.A.exists(this.rendNodeTag)&&(this.rendNodeTag.disabled=!!a);break;case"face":c.A.isPoint(this)&&(this.visProp.face=a,this.board.renderer.changePointStyle(this));break;case"generatelabelvalue":this.type===r.A.OBJECT_TYPE_TICKS&&c.A.isFunction(a)&&(this.generateLabelValue=a);break;case"gradient":this.visProp.gradient=a,this.board.renderer.setGradient(this);break;case"gradientsecondcolor":a=u.A.rgba2rgbo(a),this.visProp.gradientsecondcolor=a[0],this.visProp.gradientsecondopacity=a[1],this.board.renderer.updateGradient(this);break;case"gradientsecondopacity":this.visProp.gradientsecondopacity=a,this.board.renderer.updateGradient(this);break;case"infoboxtext":c.A.isString(a)?this.infoboxText=a:this.infoboxText=!1;break;case"labelcolor":h=(a=u.A.rgba2rgbo(a))[1],a=a[0],0===h&&c.A.exists(this.label)&&this.hasLabel&&this.label.hideElement(),c.A.exists(this.label)&&this.hasLabel&&(this.label.visProp.strokecolor=a,this.board.renderer.setObjectStrokeColor(this.label,a,h)),this.elementClass===r.A.OBJECT_CLASS_TEXT&&(this.visProp.strokecolor=a,this.visProp.strokeopacity=h,this.board.renderer.setObjectStrokeColor(this,a,h));break;case"layer":this.board.renderer.setLayer(this,c.A.evaluate(a)),this._set(n,a);break;case"maxlength":c.A.exists(this.rendNodeTag)&&(this.rendNodeTag.maxlength=!!a);break;case"name":p=this.name,delete this.board.elementsByName[this.name],this.name=a,this.board.elementsByName[this.name]=this;break;case"needsregularupdate":this.needsRegularUpdate=!("false"===a||!1===a),this.board.renderer.setBuffering(this,this.needsRegularUpdate?"auto":"static");break;case"onpolygon":this.type===r.A.OBJECT_TYPE_GLIDER&&(this.onPolygon=!!a);break;case"radius":this.type!==r.A.OBJECT_TYPE_ANGLE&&this.type!==r.A.OBJECT_TYPE_SECTOR||this.setRadius(a);break;case"rotate":(this.elementClass===r.A.OBJECT_CLASS_TEXT&&"internal"===c.A.evaluate(this.visProp.display)||this.type===r.A.OBJECT_TYPE_IMAGE)&&this.addRotation(a);break;case"tabindex":c.A.exists(this.rendNode)&&(this.rendNode.setAttribute("tabindex",a),this._set(n,a));break;case"trace":"false"===a||!1===a?(this.clearTrace(),this.visProp.trace=!1):this.visProp.trace="pause"!==a;break;case"visible":this.visProp.visible="false"!==a&&("true"===a||a),this.setDisplayRendNode(c.A.evaluate(this.visProp.visible)),c.A.evaluate(this.visProp.visible)&&c.A.exists(this.updateSize)&&this.updateSize();break;case"withlabel":this.visProp.withlabel=a,c.A.evaluate(a)?(this.label||this.createLabel(),this.label.setAttribute({visible:"inherit"})):this.label&&this.hasLabel&&this.label.setAttribute({visible:!1}),this.hasLabel=a;break;case"straightfirst":case"straightlast":for(i in this._set(n,a),this.childElements)this.childElements.hasOwnProperty(i)&&"glider"===this.childElements[i].elType&&this.childElements[i].fullUpdate();break;default:c.A.exists(this.visProp[n])&&(!s.A.Validator[n]||s.A.Validator[n]&&s.A.Validator[n](a)||s.A.Validator[n]&&c.A.isFunction(a)&&s.A.Validator[n](a()))&&(a=(!a.toLowerCase||"false"!==a.toLowerCase())&&a,this._set(n,a))}this.triggerEventHandlers(["attribute:"+n],[p,a,this])}return this.triggerEventHandlers(["attribute"],[_,this]),c.A.evaluate(this.visProp.needsregularupdate)?this.board.update(this):this.board.fullUpdate(),this.elementClass===r.A.OBJECT_CLASS_TEXT&&this.updateSize(),this},getProperty:function(){s.A.deprecated("getProperty()","getAttribute()"),this.getProperty.apply(this,arguments)},getAttribute:function(t){var e;switch(t=t.toLowerCase()){case"needsregularupdate":e=this.needsRegularUpdate;break;case"labelcolor":e=this.label.visProp.strokecolor;break;case"infoboxtext":e=this.infoboxText;break;case"withlabel":e=this.hasLabel;break;default:e=this.visProp[t]}return e},setDash:function(t){return this.setAttribute({dash:t}),this},prepareUpdate:function(){return this.needsUpdate=!0,this},remove:function(){return this.board.renderer.remove(this.rendNode),this.hasLabel&&this.board.renderer.remove(this.board.renderer.getElementById(this.label.id)),this},getTextAnchor:function(){return new o.A(r.A.COORDS_BY_USER,[0,0],this.board)},getLabelAnchor:function(){return new o.A(r.A.COORDS_BY_USER,[0,0],this.board)},setArrow:function(t,e){return this.visProp.firstarrow=t,this.visProp.lastarrow=e,e&&(this.type=r.A.OBJECT_TYPE_VECTOR,this.elType="arrow"),this.prepareUpdate().update().updateVisibility().updateRenderer(),this},createGradient:function(){var t=c.A.evaluate(this.visProp.gradient);"linear"!==t&&"radial"!==t||this.board.renderer.setGradient(this)},createLabel:function(){var t,e=this;return s.A.elements.text?((t=c.A.deepCopy(this.visProp.label,null)).id=this.id+"Label",t.isLabel=!0,t.anchor=this,t.priv=this.visProp.priv,this.visProp.withlabel&&(this.label=s.A.elements.text(this.board,[0,0,function(){return c.A.isFunction(e.name)?e.name():e.name}],t),this.label.needsUpdate=!0,this.label.dump=!1,this.label.fullUpdate(),this.hasLabel=!0)):s.A.debug("JSXGraph: Can't create label: text element is not available. Make sure you include base/text"),this},highlight:function(t){return t=c.A.def(t,!1),!c.A.evaluate(this.visProp.highlight)||this.highlighted&&!t||(this.highlighted=!0,this.board.highlightedObjects[this.id]=this,this.board.renderer.highlight(this)),this},noHighlight:function(){return this.highlighted&&(this.highlighted=!1,delete this.board.highlightedObjects[this.id],this.board.renderer.noHighlight(this)),this},clearTrace:function(){var t;for(t in this.traces)this.traces.hasOwnProperty(t)&&this.board.renderer.remove(this.traces[t]);return this.numTraces=0,this},cloneToBackground:function(){return this},bounds:function(){return[0,0,0,0]},normalize:function(){return this.stdform=n.A.normalize(this.stdform),this},toJSON:function(){var t,e,i=['{"name":',this.name];for(e in i.push(', "id":'+this.id),t=[],this.visProp)this.visProp.hasOwnProperty(e)&&c.A.exists(this.visProp[e])&&t.push('"'+e+'":'+this.visProp[e]);return i.push(', "visProp":{'+t.toString()+"}"),i.push("}"),i.join("")},addRotation:function(t){var e,i,s,o,n,a=this;return this.elementClass!==r.A.OBJECT_CLASS_TEXT&&this.type!==r.A.OBJECT_TYPE_IMAGE||0===t||(e=this.board.create("transform",[function(){return-a.X()},function(){return-a.Y()}],{type:"translate"}),i=this.board.create("transform",[function(){return a.X()},function(){return a.Y()}],{type:"translate"}),s=this.board.create("transform",[function(){return a.board.unitX/a.board.unitY},function(){return 1}],{type:"scale"}),o=this.board.create("transform",[function(){return a.board.unitY/a.board.unitX},function(){return 1}],{type:"scale"}),n=this.board.create("transform",[function(){return c.A.evaluate(t)*Math.PI/180}],{type:"rotate"}),e.bindTo(this),s.bindTo(this),n.bindTo(this),o.bindTo(this),i.bindTo(this)),this},highlightStrokeColor:function(t){return s.A.deprecated("highlightStrokeColor()","setAttribute()"),this.setAttribute({highlightStrokeColor:t}),this},strokeColor:function(t){return s.A.deprecated("strokeColor()","setAttribute()"),this.setAttribute({strokeColor:t}),this},strokeWidth:function(t){return s.A.deprecated("strokeWidth()","setAttribute()"),this.setAttribute({strokeWidth:t}),this},fillColor:function(t){return s.A.deprecated("fillColor()","setAttribute()"),this.setAttribute({fillColor:t}),this},highlightFillColor:function(t){return s.A.deprecated("highlightFillColor()","setAttribute()"),this.setAttribute({highlightFillColor:t}),this},labelColor:function(t){return s.A.deprecated("labelColor()","setAttribute()"),this.setAttribute({labelColor:t}),this},dash:function(t){return s.A.deprecated("dash()","setAttribute()"),this.setAttribute({dash:t}),this},visible:function(t){return s.A.deprecated("visible()","setAttribute()"),this.setAttribute({visible:t}),this},shadow:function(t){return s.A.deprecated("shadow()","setAttribute()"),this.setAttribute({shadow:t}),this},getType:function(){return this.elType},getParents:function(){return c.A.isArray(this.parents)?this.parents:[]},snapToGrid:function(){return this},snapToPoints:function(){return this},getAttributes:function(){var t,e=c.A.deepCopy(this.visProp),i=[],s=i.length;for(e.id=this.id,e.name=this.name,t=0;t<s;t++)delete e[i[t]];return e},hasPoint:function(t,e){return!1},addTicks:function(t){return""!==t.id&&c.A.exists(t.id)||(t.id=this.id+"_ticks_"+(this.ticks.length+1)),this.board.renderer.drawTicks(t),this.ticks.push(t),t.id},removeAllTicks:function(){var t;if(c.A.exists(this.ticks)){for(t=this.ticks.length-1;t>=0;t--)this.removeTicks(this.ticks[t]);this.ticks=[],this.board.update()}},removeTicks:function(t){var e,i;if(c.A.exists(this.defaultTicks)&&this.defaultTicks===t&&(this.defaultTicks=null),c.A.exists(this.ticks))for(e=this.ticks.length-1;e>=0;e--)if(this.ticks[e]===t){if(this.board.removeObject(this.ticks[e]),this.ticks[e].ticks)for(i=0;i<this.ticks[e].ticks.length;i++)c.A.exists(this.ticks[e].labels[i])&&this.board.removeObject(this.ticks[e].labels[i]);delete this.ticks[e];break}},getSnapSizes:function(){var t,e,i;return t=c.A.evaluate(this.visProp.snapsizex),e=c.A.evaluate(this.visProp.snapsizey),t<=0&&this.board.defaultAxes&&this.board.defaultAxes.x.defaultTicks&&(t=(i=this.board.defaultAxes.x.defaultTicks).ticksDelta*(c.A.evaluate(i.visProp.minorticks)+1)),e<=0&&this.board.defaultAxes&&this.board.defaultAxes.y.defaultTicks&&(e=(i=this.board.defaultAxes.y.defaultTicks).ticksDelta*(c.A.evaluate(i.visProp.minorticks)+1)),[t,e]},handleSnapToGrid:function(t,e){var i,o,n,a,l,h,u,d,p,_,f,A=c.A.evaluate(this.visProp.attracttogrid),g=c.A.evaluate(this.visProp.attractorunit),m=c.A.evaluate(this.visProp.attractordistance);return!c.A.exists(this.coords)||c.A.evaluate(this.visProp.fixed)||(c.A.evaluate(this.visProp.snaptogrid)||A||!0===t)&&(i=this.coords.usrCoords[1],o=this.coords.usrCoords[2],_=(p=this.getSnapSizes())[0],f=p[1],_>0&&f>0&&(d=this.board.getBoundingBox(),n=Math.round(i/_)*_,a=Math.round(o/f)*f,l=new s.A.Coords(r.A.COORDS_BY_USER,[n,a],this.board),(!A||l.distance("screen"===g?r.A.COORDS_BY_SCREEN:r.A.COORDS_BY_USER,this.coords)<m)&&(i=n,o=a,e||(h=Math.min(d[0],d[2]),u=Math.max(d[0],d[2]),i<h&&i>h-_?i+=_:i>u&&i<u+_&&(i-=_),h=Math.min(d[1],d[3]),u=Math.max(d[1],d[3]),o<h&&o>h-f?o+=f:o>u&&o<u+f&&(o-=f)),this.coords.setCoordinates(r.A.COORDS_BY_USER,[i,o])))),this},getBoundingBox:function(){var t,e,i,s,o,n=[1/0,1/0,-1/0,-1/0];if(this.type===r.A.OBJECT_TYPE_POLYGON){if((e=this.vertices.length-1)<=0)return n;for(t=0;t<e;t++)i=this.vertices[t].X(),n[0]=i<n[0]?i:n[0],n[2]=i>n[2]?i:n[2],i=this.vertices[t].Y(),n[1]=i<n[1]?i:n[1],n[3]=i>n[3]?i:n[3]}else if(this.elementClass===r.A.OBJECT_CLASS_CIRCLE)s=this.center.X(),o=this.center.Y(),n=[s-this.radius,o+this.radius,s+this.radius,o-this.radius];else if(this.elementClass===r.A.OBJECT_CLASS_CURVE){if(0===(e=this.vertices.length))return n;for(t=0;t<e;t++)i=this.points[t].coords.usrCoords[1],n[0]=i<n[0]?i:n[0],n[2]=i>n[2]?i:n[2],i=this.points[t].coords.usrCoords[1],n[1]=i<n[1]?i:n[1],n[3]=i>n[3]?i:n[3]}return n},addEvent:s.A.shortcut(s.A.GeometryElement.prototype,"on"),removeEvent:s.A.shortcut(s.A.GeometryElement.prototype,"off"),formatNumberLocale:function(t,e){var i,s,r,o={},n={maximumfractiondigits:"maximumFractionDigits",minimumfractiondigits:"minimumFractionDigits",compactdisplay:"compactDisplay",currencydisplay:"currencyDisplay",currencysign:"currencySign",localematcher:"localeMatcher",numberingsystem:"numberingSystem",signdisplay:"signDisplay",unitdisplay:"unitDisplay",usegrouping:"useGrouping",roundingmode:"roundingMode",roundingpriority:"roundingPriority",roundingincrement:"roundingIncrement",trailingzerodisplay:"trailingZeroDisplay",minimumintegerdigits:"minimumIntegerDigits",minimumsignificantdigits:"minimumSignificantDigits",maximumsignificantdigits:"maximumSignificantDigits"};if(c.A.exists(Intl)&&this.useLocale()){for(r in i=c.A.evaluate(this.visProp.intl.locale)||c.A.evaluate(this.board.attr.intl.locale),s=c.A.evaluate(this.visProp.intl.options)||{})s.hasOwnProperty(r)&&(n.hasOwnProperty(r)?o[n[r]]=c.A.evaluate(s[r]):o[r]=c.A.evaluate(s[r]));return r="maximumfractiondigits",c.A.exists(s[r])||(o[n[r]]=e),Intl.NumberFormat(i,o).format(t)}return t},useLocale:function(){var t;return!(!c.A.exists(this.visProp.intl)||!c.A.exists(this.visProp.intl.enabled))&&(!0===(t=c.A.evaluate(this.visProp.intl.enabled))||"inherit"===t&&!0===c.A.evaluate(this.board.attr.intl.enabled))},__evt__over:function(t){},__evt__mouseover:function(t){},__evt__out:function(t){},__evt__mouseout:function(t){},__evt__move:function(t){},__evt__mousemove:function(t){},__evt__drag:function(t){},__evt__mousedrag:function(t){},__evt__pendrag:function(t){},__evt__touchdrag:function(t){},__evt__keydrag:function(t){},__evt__down:function(t){},__evt__mousedown:function(t){},__evt__pendown:function(t){},__evt__touchdown:function(t){},__evt__click:function(t){},__evt__dblclick:function(t){},__evt__mouseclick:function(t){},__evt__mousedblclick:function(t){},__evt__pointerclick:function(t){},__evt__pointerdblclick:function(t){},__evt__up:function(t){},__evt__mouseup:function(t){},__evt__penup:function(t){},__evt__touchup:function(t){},__evt__attribute:function(t,e){},__evt__attribute_:function(t,e,i){},__evt:function(){}}),e.A=s.A.GeometryElement},925:function(t,e,i){var s=i(443),r=i(561),o=i(144),n=i(86),a=i(133),l=i(188),h=i(477),u=i(102),c=function(){this._val=parseFloat(this.rendNodeRange.value),this.rendNodeOut.value=this.rendNodeRange.value,this.board.update()};s.A.Text=function(t,e,i,s){var o;this.constructor(t,i,r.A.OBJECT_TYPE_TEXT,r.A.OBJECT_CLASS_TEXT),this.element=this.board.select(i.anchor),this.coordsConstructor(e,l.A.evaluate(this.visProp.islabel)),this.content="",this.plaintext="",this.plaintextOld=null,this.orgText="",this.needsSizeUpdate=!1,this.hiddenByParent=!1,this.size=[1,1],this.id=this.board.setId(this,"T"),this.board.renderer.drawText(this),this.board.finalizeAdding(this),o=this.visProp.visible,this.visProp.visible=!0,this.setText(s),this.visProp.visible=o,l.A.isString(this.content)&&this.notifyParents(this.content),this.elType="text",this.methodMap=l.A.deepCopy(this.methodMap,{setText:"setTextJessieCode",move:"setCoords",Size:"getSize",setAutoPosition:"setAutoPosition"})},s.A.Text.prototype=new o.A,l.A.copyPrototypeMethods(s.A.Text,u.A,"coordsConstructor"),s.A.extend(s.A.Text.prototype,{hasPoint:function(t,e){var i,s,r,o,n,a,u,c;return l.A.isObject(l.A.evaluate(this.visProp.precision))?(u=this.board._inputDevice,c=l.A.evaluate(this.visProp.precision[u])):c=this.board.options.precision.hasPoint,this.transformations.length>0&&(t=(i=h.A.matVecMult(h.A.inverse(this.board.renderer.joinTransforms(this,this.transformations)),[1,t,e]))[1],e=i[2]),s=(i="right"===(n=this.getAnchorX())?this.coords.scrCoords[1]-this.size[0]:"middle"===n?this.coords.scrCoords[1]-.5*this.size[0]:this.coords.scrCoords[1])+this.size[0],r=(o="top"===(a=this.getAnchorY())?this.coords.scrCoords[2]+this.size[1]:"middle"===a?this.coords.scrCoords[2]+.5*this.size[1]:this.coords.scrCoords[2])-this.size[1],"all"===l.A.evaluate(this.visProp.dragarea)?t>=i-c&&t<s+c&&e>=r-c&&e<=o+c:e>=r-c&&e<=o+c&&(t>=i-c&&t<=i+2*c||t>=s-2*c&&t<=s+c)},_createFctUpdateText:function(t){var e,i,s,r,o,n,a=l.A.evaluate(this.visProp.parse),h=l.A.evaluate(this.visProp.usemathjax),u=l.A.evaluate(this.visProp.usekatex),c=!1;if(this.orgText=t,l.A.isFunction(t))this.updateText=function(){r=t().toString(),this.plaintext=!a||h||u?r:this.replaceSub(this.replaceSup(this.convertGeonextAndSketchometry2CSS(r,!1)))};else if(l.A.isNumber(t)&&l.A.evaluate(this.visProp.formatnumber)?l.A.evaluate(this.visProp.tofraction)?this.content=h?"\\("+l.A.toFraction(t,!0)+"\\)":l.A.toFraction(t,u):(s=l.A.evaluate(this.visProp.digits),this.useLocale()?this.content=this.formatNumberLocale(t,s):this.content=l.A.toFixed(t,s)):l.A.isString(t)&&a?(l.A.evaluate(this.visProp.useasciimathml)?this.content="'`"+t+"`'":h||u?(this.content=this.valueTagToJessieCode(t),l.A.isArray(this.content)||(this.content=this.content.replace(/\\/g,"\\\\"))):this.content=this.poorMansTeX(this.valueTagToJessieCode(t)),c=!0):this.content=t,c){if(l.A.isArray(this.content)){for(n=this,o=0;o<this.content.length;o++)if('"'!==this.content[o][0])for(i in this.content[o]=this.board.jc.snippet(this.content[o],!0,"",!1),this.content[o].deps)this.addParents(this.content[o].deps[i]),this.content[o].deps[i].addChild(this);e=function(){var t,e,i=l.A.evaluate(n.visProp.digits),s="";for(t=0;t<n.content.length;t++)l.A.isFunction(n.content[t])?(e=n.content[t](),e=n.useLocale()?n.formatNumberLocale(e,i):l.A.toFixed(e,i)):'"'===(e=n.content[t])[0]&&'"'===e[e.length-1]&&(e=e.slice(1,-1)),s+=e;return s}}else for(i in(e=this.board.jc.snippet(this.content,!0,"",!1)).deps)this.addParents(e.deps[i]),e.deps[i].addChild(this);this.updateText=function(){this.plaintext=this.unescapeTicks(e())}}else this.updateText=function(){this.plaintext=this.content}},_setText:function(t){return this._createFctUpdateText(t),this.updateText(),this.fullUpdate(),this.board.infobox&&this.id===this.board.infobox.id||this.updateSize(),this},setTextJessieCode:function(t){var e;return this.visProp.castext=t,e=l.A.isFunction(t)?function(){return l.A.sanitizeHTML(t())}:l.A.isNumber(t)?t:l.A.sanitizeHTML(t),this._setText(e)},setText:function(t){return this._setText(t)},updateSize:function(){var t,e,i,s=l.A.evaluate(this.visProp.display);return a.A.isBrowser&&"no"!==this.board.renderer.type?(i=this.rendNode,"html"===s||"vml"===this.board.renderer.type?l.A.exists(i.offsetWidth)?(e=this,window.setTimeout((function(){e.size=[i.offsetWidth,i.offsetHeight],e.needsUpdate=!0,e.updateRenderer()}),0)):this.size=this.crudeSizeEstimate():"internal"===s&&("svg"===this.board.renderer.type?(e=this,window.setTimeout((function(){try{t=i.getBBox(),e.size=[t.width,t.height],e.needsUpdate=!0,e.updateRenderer()}catch(t){}}),0)):"canvas"===this.board.renderer.type&&(this.size=this.crudeSizeEstimate())),this):this},crudeSizeEstimate:function(){var t=parseFloat(l.A.evaluate(this.visProp.fontsize));return[t*this.plaintext.length*.45,.9*t]},utf8_decode:function(t){return t.replace(/&#x(\w+);/g,(function(t,e){return String.fromCharCode(parseInt(e,16))}))},replaceSub:function(t){if(!t.indexOf)return t;for(var e,i=t.indexOf("_{");i>=0;)(e=(t=t.slice(0,i)+t.slice(i).replace(/_\{/,"<sub>")).indexOf("}",i+4))>=0&&(t=t.slice(0,e)+t.slice(e).replace(/\}/,"</sub>")),i=t.indexOf("_{");for(i=t.indexOf("_");i>=0;)i=(t=t.slice(0,i)+t.slice(i).replace(/_(.?)/,"<sub>$1</sub>")).indexOf("_");return t},replaceSup:function(t){if(!t.indexOf)return t;for(var e,i=t.indexOf("^{");i>=0;)(e=(t=t.slice(0,i)+t.slice(i).replace(/\^\{/,"<sup>")).indexOf("}",i+4))>=0&&(t=t.slice(0,e)+t.slice(e).replace(/\}/,"</sup>")),i=t.indexOf("^{");for(i=t.indexOf("^");i>=0;)i=(t=t.slice(0,i)+t.slice(i).replace(/\^(.?)/,"<sup>$1</sup>")).indexOf("^");return t},getSize:function(){return this.size},setCoords:function(t,e){var i,s,o;return l.A.isArray(t)&&t.length>1&&(e=t[1],t=t[0]),l.A.evaluate(this.visProp.islabel)&&l.A.exists(this.element)?(s=(t-(i=this.element.getLabelAnchor()).usrCoords[1])*this.board.unitX,o=-(e-i.usrCoords[2])*this.board.unitY,this.relativeCoords.setCoordinates(r.A.COORDS_BY_SCREEN,[s,o])):this.coords.setCoordinates(r.A.COORDS_BY_USER,[t,e]),this.fullUpdate(),this},update:function(t){return this.needsUpdate?(this.updateCoords(t),this.updateText(),"internal"===l.A.evaluate(this.visProp.display)&&l.A.isString(this.plaintext)&&(this.plaintext=this.utf8_decode(this.plaintext)),this.checkForSizeUpdate(),this.needsSizeUpdate&&this.updateSize(),this):this},checkForSizeUpdate:function(){this.board.infobox&&this.id===this.board.infobox.id?this.needsSizeUpdate=!1:(this.needsSizeUpdate=this.plaintextOld!==this.plaintext,this.needsSizeUpdate&&(this.plaintextOld=this.plaintext))},updateRenderer:function(){return l.A.evaluate(this.visProp.autoposition)&&this.setAutoPosition().updateConstraint(),this.updateRendererGeneric("updateText")},expandShortMath:function(t){return t.replace(/([)0-9.])\s*([(a-zA-Z_])/g,"$1*$2")},generateTerm:function(t,e,i){var s,r,o,a,h='""';if(o=(t=(t=(t=(t=(t=(t=(t=(t=(t=(t=(t=t||"").replace(/\r/g,"")).replace(/\n/g,"")).replace(/"/g,"'")).replace(/'/g,"\\'")).replace(/&amp;arc;/g,"&ang;")).replace(/<arc\s*\/>/g,"&ang;")).replace(/&lt;arc\s*\/&gt;/g,"&ang;")).replace(/&lt;sqrt\s*\/&gt;/g,"&radic;")).replace(/&lt;value&gt;/g,"<value>")).replace(/&lt;\/value&gt;/g,"</value>")).indexOf("<value>"),a=t.indexOf("</value>"),o>=0)for(;o>=0;)h+=' + "'+this.replaceSub(this.replaceSup(t.slice(0,o)))+'"',r=(r=t.slice(o+7,a)).replace(/\s+/g,""),!0===e&&(r=this.expandShortMath(r)),(s=(s=(s=i?r:n.A.geonext2JS(r,this.board)).replace(/\\"/g,"'")).replace(/\\'/g,"'")).indexOf("toFixed")<0&&l.A.isNumber(l.A.bind(this.board.jc.snippet(s,!0,"",!1),this)())?h+="+("+s+").toFixed("+l.A.evaluate(this.visProp.digits)+")":h+="+("+s+")",o=(t=t.slice(a+8)).indexOf("<value>"),a=t.indexOf("</value>");return h+=' + "'+this.replaceSub(this.replaceSup(t))+'"',h=(h=(h=this.convertGeonextAndSketchometry2CSS(h)).replace(/&amp;/g,"&")).replace(/"/g,"'")},valueTagToJessieCode:function(t){var e,i,s,r,o=[],n='"';if(s=(t=(t=(t=(t=(t=t||"").replace(/\r/g,"")).replace(/\n/g,"")).replace(/&lt;value&gt;/g,"<value>")).replace(/&lt;\/value&gt;/g,"</value>")).indexOf("<value>"),r=t.indexOf("</value>"),s>=0)for(;s>=0;)o.push(n+this.escapeTicks(t.slice(0,s))+n),i=(i=t.slice(s+7,r)).replace(/\s+/g,""),e=(e=i=this.expandShortMath(i)).replace(/\\"/g,"'").replace(/\\'/g,"'"),o.push("("+e+")"),s=(t=t.slice(r+8)).indexOf("<value>"),r=t.indexOf("</value>");for(o.push(n+this.escapeTicks(t)+n),s=0;s<o.length;s++)o[s]=o[s].replace(/&amp;/g,"&");return o},poorMansTeX:function(t){var e,i;if(l.A.isArray(t)){for(i=[],e=0;e<t.length;e++)i.push(this.poorMansTeX(t[e]));return i}return t=t.replace(/<arc\s*\/*>/g,"&ang;").replace(/&lt;arc\s*\/*&gt;/g,"&ang;").replace(/<sqrt\s*\/*>/g,"&radic;").replace(/&lt;sqrt\s*\/*&gt;/g,"&radic;"),this.convertGeonextAndSketchometry2CSS(this.replaceSub(this.replaceSup(t)),!0)},escapeTicks:function(t){return t.replace(/"/g,"%22").replace(/'/g,"%27")},unescapeTicks:function(t){return t.replace(/%22/g,'"').replace(/%27/g,"'")},convertGeonext2CSS:function(t){return l.A.isString(t)&&(t=(t=(t=(t=t.replace(/(<|&lt;)overline(>|&gt;)/g,"<span style=text-decoration:overline;>")).replace(/(<|&lt;)\/overline(>|&gt;)/g,"</span>")).replace(/(<|&lt;)arrow(>|&gt;)/g,"<span style=text-decoration:overline;>")).replace(/(<|&lt;)\/arrow(>|&gt;)/g,"</span>")),t},convertSketchometry2CSS:function(t,e){var i='<span class="sketcho sketcho-inherit sketcho-',s='"></span>';return l.A.isString(t)&&(e&&(i=this.escapeTicks(i),s=this.escapeTicks(s)),t=(t=t.replace(/(<|&lt;)sketchofont(>|&gt;)/g,i)).replace(/(<|&lt;)\/sketchofont(>|&gt;)/g,s)),t},convertGeonextAndSketchometry2CSS:function(t,e){return t=this.convertGeonext2CSS(t),t=this.convertSketchometry2CSS(t,e)},notifyParents:function(t){var e,i=null;t=(t=t.replace(/&lt;value&gt;/g,"<value>")).replace(/&lt;\/value&gt;/g,"</value>");do{null!==(i=(e=/<value>([\w\s*/^\-+()[\],<>=!]+)<\/value>/).exec(t))&&(n.A.findDependencies(this,i[1],this.board),t=(t=t.slice(i.index)).replace(e,""))}while(null!==i);return this},getParents:function(){var t;return t=void 0!==this.relativeCoords?[this.relativeCoords.usrCoords[1],this.relativeCoords.usrCoords[2],this.orgText]:[this.Z(),this.X(),this.Y(),this.orgText],0!==this.parents.length&&(t=this.parents),t},bounds:function(){var t=this.coords.usrCoords;return l.A.evaluate(this.visProp.islabel)||0===this.board.unitY||0===this.board.unitX?[0,0,0,0]:[t[1],t[2]+this.size[1]/this.board.unitY,t[1]+this.size[0]/this.board.unitX,t[2]]},getAnchorX:function(){var t=l.A.evaluate(this.visProp.anchorx);if("auto"===t)switch(this.visProp.position){case"top":case"bot":return"middle";case"rt":case"lrt":case"urt":return"left";default:return"right"}return t},getAnchorY:function(){var t=l.A.evaluate(this.visProp.anchory);if("auto"===t)switch(this.visProp.position){case"top":case"ulft":case"urt":return"bottom";case"bot":case"lrt":case"llft":return"top";default:return"middle"}return t},getNumberOfConflicts:function(t,e,i,s){var r,o,n,a,l=0;for(a=this.board.options.precision.hasPoint,this.board.options.precision.hasPoint=.25*(i+s),r=0,n=this.board.objectsList.length;r<n;r++)(o=this.board.objectsList[r]).visPropCalc.visible&&"axis"!==o.elType&&"ticks"!==o.elType&&o!==this.board.infobox&&o!==this&&o.hasPoint(t,e)&&l++;return this.board.options.precision.hasPoint=a,l},setAutoPosition:function(){var t,e,i,s,r,o,n,a,h,u,c,d,p,_,f,A,g,m=this.size[0],y=this.size[1],b={conflicts:1/0,angle:0,r:0},v=2*Math.PI/12;if(this===this.board.infobox||!this.visPropCalc.visible||!l.A.evaluate(this.visProp.islabel)||!this.element)return this;if(c=l.A.evaluate(this.visProp.offset),i=(r=this.element.getLabelAnchor()).scrCoords[1],s=r.scrCoords[2],_=c[0],f=c[1],0===(u=this.getNumberOfConflicts(i+_,s-f,m,y)))return this;for(d=l.A.evaluate(this.visProp.autopositionmindistance),a=l.A.evaluate(this.visProp.autopositionmaxdistance),h=.2*d,o=Math.atan2(f,_),b.conflicts=u,b.angle=o,b.r=d;b.conflicts>0&&d<=a;){for(p=1,n=o+v;p<12&&b.conflicts>0&&(t=i+d*(A=Math.cos(n)),e=s-d*(g=Math.sin(n)),(u=this.getNumberOfConflicts(t,e,m,y))<b.conflicts&&(b.conflicts=u,b.angle=n,b.r=d),0!==b.conflicts);p++)n+=v;d+=h}return d=b.r,A=Math.cos(b.angle),g=Math.sin(b.angle),this.visProp.offset=[d*A,d*g],this.visProp.anchorx=A<-.2?"right":A>.2?"left":"middle",this}}),s.A.createText=function(t,e,i){var r,o=l.A.copyAttributes(i,t.options,"text"),n=e.slice(0,-1),a=e[e.length-1];if(o.anchor=o.parent||o.anchor,!(r=u.A.create(s.A.Text,t,n,o,a)))throw new Error("JSXGraph: Can't create text with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [x,y], [z,x,y], [element,transformation]");return 0!==o.rotate&&r.addRotation(o.rotate),r},s.A.registerElement("text",s.A.createText),s.A.createHTMLSlider=function(t,e,i){var r,o,n=l.A.copyAttributes(i,t.options,"htmlslider");if(2!==e.length||2!==e[0].length||3!==e[1].length)throw new Error("JSXGraph: Can't create htmlslider with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parents are: [[x,y], [min, start, max]]");n.anchor=n.parent||n.anchor,n.fixed=n.fixed||!0,o=[e[0][0],e[0][1],'<form style="display:inline"><input type="range" /><span></span><input type="text" /></form>'],(r=s.A.createText(t,o,n)).type=l.A.OBJECT_TYPE_HTMLSLIDER,r.rendNodeForm=r.rendNode.childNodes[0],r.rendNodeRange=r.rendNodeForm.childNodes[0],r.rendNodeRange.min=e[1][0],r.rendNodeRange.max=e[1][2],r.rendNodeRange.step=n.step,r.rendNodeRange.value=e[1][1],r.rendNodeLabel=r.rendNodeForm.childNodes[1],r.rendNodeLabel.id=r.rendNode.id+"_label",n.withlabel&&(r.rendNodeLabel.innerHTML=r.name+"="),r.rendNodeOut=r.rendNodeForm.childNodes[2],r.rendNodeOut.value=e[1][1];try{r.rendNodeForm.id=r.rendNode.id+"_form",r.rendNodeRange.id=r.rendNode.id+"_range",r.rendNodeOut.id=r.rendNode.id+"_out"}catch(t){s.A.debug(t)}return r.rendNodeRange.style.width=n.widthrange+"px",r.rendNodeRange.style.verticalAlign="middle",r.rendNodeOut.style.width=n.widthout+"px",r._val=e[1][1],s.A.supportsVML()?a.A.addEvent(r.rendNodeForm,"change",c,r):a.A.addEvent(r.rendNodeForm,"input",c,r),r.Value=function(){return this._val},r},s.A.registerElement("htmlslider",s.A.createHTMLSlider),e.A=s.A.Text},443:function(t,e){var i={};try{"object"!=typeof JXG||JXG.extend||(i=JXG)}catch(t){}i.extend=function(t,e,i,s){var r;for(r in i=i||!1,s=s||!1,e)(!i||i&&e.hasOwnProperty(r))&&(t[s?r.toLowerCase():r]=e[r])},i.defineConstant=function(t,e,s,r){(r=r||!1)&&i.exists(t[e])||Object.defineProperty(t,e,{value:s,writable:!1,enumerable:!0,configurable:!1})},i.extendConstants=function(t,e,i,s){var r,o;for(r in i=i||!1,s=s||!1,e)(!i||i&&e.hasOwnProperty(r))&&(o=s?r.toUpperCase():r,this.defineConstant(t,o,e[r]))},i.extend(i,{boards:{},readers:{},elements:{},registerElement:function(t,e){t=t.toLowerCase(),this.elements[t]=e},registerReader:function(t,e){var i,s;for(i=0;i<e.length;i++)s=e[i].toLowerCase(),"function"!=typeof this.readers[s]&&(this.readers[s]=t)},shortcut:function(t,e){return function(){return t[e].apply(this,arguments)}},getRef:function(t,e){return i.deprecated("JXG.getRef()","Board.select()"),t.select(e)},getReference:function(t,e){return i.deprecated("JXG.getReference()","Board.select()"),t.select(e)},getBoardByContainerId:function(t){var e;for(e in JXG.boards)if(JXG.boards.hasOwnProperty(e)&&JXG.boards[e].container===t)return JXG.boards[e];return null},deprecated:function(t,e){var s=t+" is deprecated.";e&&(s+=" Please use "+e+" instead."),i.warn(s)},warn:function(t){"object"==typeof window&&window.console&&console.warn?console.warn("WARNING:",t):"object"==typeof document&&document.getElementById("warning")&&(document.getElementById("debug").innerHTML+="WARNING: "+t+"<br />")},debugInt:function(t){var e,i;for(e=0;e<arguments.length;e++)i=arguments[e],"object"==typeof window&&window.console&&console.log?console.log(i):"object"==typeof document&&document.getElementById("debug")&&(document.getElementById("debug").innerHTML+=i+"<br/>")},debugWST:function(t){var e=new Error;i.debugInt.apply(this,arguments),e&&e.stack&&(i.debugInt("stacktrace"),i.debugInt(e.stack.split("\n").slice(1).join("\n")))},debugLine:function(t){var e=new Error;i.debugInt.apply(this,arguments),e&&e.stack&&i.debugInt("Called from",e.stack.split("\n").slice(2,3).join("\n"))},debug:function(t){i.debugInt.apply(this,arguments)},themes:{}}),e.A=i},571:function(t,e,i){var s=i(443),r=i(561),o=i(904),n=i(477),a=i(171),l=i(188),h=i(713);n.A.Geometry={},s.A.extend(n.A.Geometry,{angle:function(t,e,i){var r,o,n,a,l=[],h=[],u=[];return s.A.deprecated("Geometry.angle()","Geometry.rad()"),t.coords?(l[0]=t.coords.usrCoords[1],l[1]=t.coords.usrCoords[2]):(l[0]=t[0],l[1]=t[1]),e.coords?(h[0]=e.coords.usrCoords[1],h[1]=e.coords.usrCoords[2]):(h[0]=e[0],h[1]=e[1]),i.coords?(u[0]=i.coords.usrCoords[1],u[1]=i.coords.usrCoords[2]):(u[0]=i[0],u[1]=i[1]),r=l[0]-h[0],o=l[1]-h[1],n=u[0]-h[0],a=u[1]-h[1],Math.atan2(r*a-o*n,r*n+o*a)},trueAngle:function(t,e,i){return 57.29577951308232*this.rad(t,e,i)},rad:function(t,e,i){var s,r,o,n,a,l,h;return t.coords?(s=t.coords.usrCoords[1],r=t.coords.usrCoords[2]):(s=t[0],r=t[1]),e.coords?(o=e.coords.usrCoords[1],n=e.coords.usrCoords[2]):(o=e[0],n=e[1]),i.coords?(a=i.coords.usrCoords[1],l=i.coords.usrCoords[2]):(a=i[0],l=i[1]),(h=Math.atan2(l-n,a-o)-Math.atan2(r-n,s-o))<0&&(h+=6.283185307179586),h},angleBisector:function(t,e,i,s){var n,a,h,u,c,d=t.coords.usrCoords,p=e.coords.usrCoords,_=i.coords.usrCoords;return l.A.exists(s)||(s=t.board),0===p[0]?new o.A(r.A.COORDS_BY_USER,[1,.5*(d[1]+_[1]),.5*(d[2]+_[2])],s):(u=d[1]-p[1],c=d[2]-p[2],n=Math.atan2(c,u),u=_[1]-p[1],c=_[2]-p[2],h=.5*(n+(a=Math.atan2(c,u))),n>a&&(h+=Math.PI),u=Math.cos(h)+p[1],c=Math.sin(h)+p[2],new o.A(r.A.COORDS_BY_USER,[1,u,c],s))},reflection:function(t,e,i){var s,n,a,h,u,c,d=e.coords.usrCoords,p=t.point1.coords.usrCoords,_=t.point2.coords.usrCoords;return l.A.exists(i)||(i=e.board),h=_[1]-p[1],u=_[2]-p[2],s=d[1]-p[1],c=(h*(d[2]-p[2])-u*s)/(h*h+u*u),n=d[1]+2*c*u,a=d[2]-2*c*h,new o.A(r.A.COORDS_BY_USER,[n,a],i)},rotation:function(t,e,i,s){var n,a,h,u,c,d,p=e.coords.usrCoords,_=t.coords.usrCoords;return l.A.exists(s)||(s=e.board),n=p[1]-_[1],a=p[2]-_[2],c=n*(h=Math.cos(i))-a*(u=Math.sin(i))+_[1],d=n*u+a*h+_[2],new o.A(r.A.COORDS_BY_USER,[c,d],s)},perpendicular:function(t,e,i){var s,a,h,u,c,d=t.point1.coords.usrCoords,p=t.point2.coords.usrCoords,_=e.coords.usrCoords;return l.A.exists(i)||(i=e.board),e===t.point1?(s=d[1]+p[2]-d[2],a=d[2]-p[1]+d[1],c=d[0]*p[0],Math.abs(c)<n.A.eps&&(s=p[2],a=-p[1]),u=[c,s,a],h=!0):e===t.point2?(s=p[1]+d[2]-p[2],a=p[2]-d[1]+p[1],c=d[0]*p[0],Math.abs(c)<n.A.eps&&(s=d[2],a=-d[1]),u=[c,s,a],h=!1):Math.abs(n.A.innerProduct(_,t.stdform,3))<n.A.eps?(s=_[1]+p[2]-_[2],a=_[2]-p[1]+_[1],c=p[0],Math.abs(c)<n.A.eps&&(s=p[2],a=-p[1]),h=!0,Math.abs(c)>n.A.eps&&Math.abs(s-_[1])<n.A.eps&&Math.abs(a-_[2])<n.A.eps&&(s=_[1]+d[2]-_[2],a=_[2]-d[1]+_[1],h=!1),u=[c,s,a]):(u=[0,t.stdform[1],t.stdform[2]],u=n.A.crossProduct(u,_),u=n.A.crossProduct(u,t.stdform),h=!0),[new o.A(r.A.COORDS_BY_USER,u,i),h]},circumcenterMidpoint:function(){s.A.deprecated("Geometry.circumcenterMidpoint()","Geometry.circumcenter()"),this.circumcenter.apply(this,arguments)},circumcenter:function(t,e,i,s){var a,h,u,c,d=t.coords.usrCoords,p=e.coords.usrCoords,_=i.coords.usrCoords;return l.A.exists(s)||(s=t.board),a=[p[0]-d[0],-p[2]+d[2],p[1]-d[1]],h=[.5*(d[0]+p[0]),.5*(d[1]+p[1]),.5*(d[2]+p[2])],u=n.A.crossProduct(a,h),a=[_[0]-p[0],-_[2]+p[2],_[1]-p[1]],h=[.5*(p[0]+_[0]),.5*(p[1]+_[1]),.5*(p[2]+_[2])],c=n.A.crossProduct(a,h),new o.A(r.A.COORDS_BY_USER,n.A.crossProduct(u,c),s)},distance:function(t,e,i){var s,r=0;for(i||(i=Math.min(t.length,e.length)),s=0;s<i;s++)r+=(t[s]-e[s])*(t[s]-e[s]);return Math.sqrt(r)},affineDistance:function(t,e,i){var s;return(s=this.distance(t,e,i))>n.A.eps&&(Math.abs(t[0])<n.A.eps||Math.abs(e[0])<n.A.eps)?1/0:s},affineRatio:function(t,e,i){var s;return l.A.exists(t.usrCoords)&&(t=t.usrCoords),l.A.exists(e.usrCoords)&&(e=e.usrCoords),l.A.exists(i.usrCoords)&&(i=i.usrCoords),s=e[1]-t[1],Math.abs(s)>n.A.eps?(i[1]-t[1])/s:(i[2]-t[2])/(e[2]-t[2])},sortVertices:function(t){for(var e,i=h.A.each(t,h.A.coordsArray),s=i.length,r=null;i[0][0]===i[s-1][0]&&i[0][1]===i[s-1][1]&&i[0][2]===i[s-1][2];)r=i.pop(),s--;return e=i[0],i.sort((function(t,i){return(t[2]===e[2]&&t[1]===e[1]?-1/0:Math.atan2(t[2]-e[2],t[1]-e[1]))-(i[2]===e[2]&&i[1]===e[1]?-1/0:Math.atan2(i[2]-e[2],i[1]-e[1]))})),null!==r&&i.push(r),i},signedTriangle:function(t,e,i){var s=h.A.coordsArray(t),r=h.A.coordsArray(e),o=h.A.coordsArray(i);return.5*((r[1]-s[1])*(o[2]-s[2])-(r[2]-s[2])*(o[1]-s[1]))},signedPolygon:function(t,e){var i,s,r=0,o=h.A.each(t,h.A.coordsArray);for(void 0===e&&(e=!0),e?o.unshift(o[o.length-1]):o=this.sortVertices(o),s=o.length,i=1;i<s;i++)r+=o[i-1][1]*o[i][2]-o[i][1]*o[i-1][2];return.5*r},GrahamScan:function(t){var e,i=1,s=h.A.each(t,h.A.coordsArray),r=s.length;for(r=(s=this.sortVertices(s)).length,e=2;e<r;e++){for(;this.signedTriangle(s[i-1],s[i],s[e])<=0;){if(i>1)i-=1;else if(e===r-1)break;e+=1}i+=1,s=l.A.swap(s,i,e)}return s.slice(0,i)},calcStraight:function(t,e,i,s){var o,a,h,u,c,d,p,_,f,A;if(l.A.exists(s)||(s=10),d=l.A.evaluate(t.visProp.straightfirst),p=l.A.evaluate(t.visProp.straightlast),Math.abs(e.scrCoords[0])<n.A.eps&&(d=!0),Math.abs(i.scrCoords[0])<n.A.eps&&(p=!0),(d||p)&&((_=[])[0]=t.stdform[0]-t.stdform[1]*t.board.origin.scrCoords[1]/t.board.unitX+t.stdform[2]*t.board.origin.scrCoords[2]/t.board.unitY,_[1]=t.stdform[1]/t.board.unitX,_[2]=-t.stdform[2]/t.board.unitY,!isNaN(_[0]+_[1]+_[2]))){if(!1,!1,o=!d&&Math.abs(e.usrCoords[0])>=n.A.eps&&e.scrCoords[1]>=0&&e.scrCoords[1]<=t.board.canvasWidth&&e.scrCoords[2]>=0&&e.scrCoords[2]<=t.board.canvasHeight,a=!p&&Math.abs(i.usrCoords[0])>=n.A.eps&&i.scrCoords[1]>=0&&i.scrCoords[1]<=t.board.canvasWidth&&i.scrCoords[2]>=0&&i.scrCoords[2]<=t.board.canvasHeight,u=(h=this.meetLineBoard(_,t.board,s))[0],c=h[1],!o&&!a){if(!d&&p&&!this.isSameDirection(e,i,u)&&!this.isSameDirection(e,i,c))return;if(d&&!p&&!this.isSameDirection(i,e,u)&&!this.isSameDirection(i,e,c))return}o?a||(A=this.isSameDir(e,i,u,c)?c:u):a?f=this.isSameDir(e,i,u,c)?u:c:this.isSameDir(e,i,u,c)?(f=u,A=c):(A=u,f=c),f&&e.setCoordinates(r.A.COORDS_BY_USER,f.usrCoords),A&&i.setCoordinates(r.A.COORDS_BY_USER,A.usrCoords)}},calcLineDelimitingPoints:function(t,e,i){var s,o,a,h,u,c,d,p,_,f,A;if(u=l.A.evaluate(t.visProp.straightfirst),c=l.A.evaluate(t.visProp.straightlast),Math.abs(e.scrCoords[0])<n.A.eps&&(u=!0),Math.abs(i.scrCoords[0])<n.A.eps&&(c=!0),(d=[])[0]=t.stdform[0]-t.stdform[1]*t.board.origin.scrCoords[1]/t.board.unitX+t.stdform[2]*t.board.origin.scrCoords[2]/t.board.unitY,d[1]=t.stdform[1]/t.board.unitX,d[2]=-t.stdform[2]/t.board.unitY,!isNaN(d[0]+d[1]+d[2])){if(f=!u,A=!c,o=t.board.getBoundingBox(),t.getSlope()>=0?(a=this.projectPointToLine({coords:{usrCoords:[1,o[2],o[1]]}},t,t.board),h=this.projectPointToLine({coords:{usrCoords:[1,o[0],o[3]]}},t,t.board)):(a=this.projectPointToLine({coords:{usrCoords:[1,o[0],o[1]]}},t,t.board),h=this.projectPointToLine({coords:{usrCoords:[1,o[2],o[3]]}},t,t.board)),!f&&!A){if(!u&&!c){if(s=e.distance(r.A.COORDS_BY_USER,i),Math.abs(e.distance(r.A.COORDS_BY_USER,a)+a.distance(r.A.COORDS_BY_USER,i)-s)>n.A.eps)return;if(Math.abs(e.distance(r.A.COORDS_BY_USER,h)+h.distance(r.A.COORDS_BY_USER,i)-s)>n.A.eps)return}if(!u&&c&&!this.isSameDirection(e,i,a)&&!this.isSameDirection(e,i,h))return;if(u&&!c&&!this.isSameDirection(i,e,a)&&!this.isSameDirection(i,e,h))return}f?A||(_=this.isSameDir(e,i,a,h)?h:a):A?p=this.isSameDir(e,i,a,h)?a:h:this.isSameDir(e,i,a,h)?(p=a,_=h):(_=a,p=h),p&&e.setCoordinates(r.A.COORDS_BY_USER,p.usrCoords),_&&i.setCoordinates(r.A.COORDS_BY_USER,_.usrCoords)}},calcLabelQuadrant:function(t){return t<0&&(t+=2*Math.PI),["rt","urt","top","ulft","lft","llft","lrt"][Math.floor((t+Math.PI/8)/(Math.PI/4))%8]},isSameDir:function(t,e,i,s){var r=e.usrCoords[1]-t.usrCoords[1],o=e.usrCoords[2]-t.usrCoords[2],a=s.usrCoords[1]-i.usrCoords[1],l=s.usrCoords[2]-i.usrCoords[2];return Math.abs(e.usrCoords[0])<n.A.eps&&(r=e.usrCoords[1],o=e.usrCoords[2]),Math.abs(t.usrCoords[0])<n.A.eps&&(r=-t.usrCoords[1],o=-t.usrCoords[2]),r*a+o*l>=0},isSameDirection:function(t,e,i){var s,r,o,a,l=!1;return s=e.usrCoords[1]-t.usrCoords[1],r=e.usrCoords[2]-t.usrCoords[2],o=i.usrCoords[1]-t.usrCoords[1],a=i.usrCoords[2]-t.usrCoords[2],Math.abs(s)<n.A.eps&&(s=0),Math.abs(r)<n.A.eps&&(r=0),Math.abs(o)<n.A.eps&&(o=0),Math.abs(a)<n.A.eps&&(a=0),(s>=0&&o>=0||s<=0&&o<=0)&&(l=r>=0&&a>=0||r<=0&&a<=0),l},det3p:function(t,e,i){return(t[1]-i[1])*(e[2]-i[2])-(e[1]-i[1])*(t[2]-i[2])},windingNumber:function(t,e,i){var s,r,o,a,h,u,c=0,d=e.length,p=t[1],_=t[2],f=0;if(0===d)return 0;if((i=i||!1)&&(f=1),isNaN(p)||isNaN(_))return 1;if(l.A.exists(e[0].coords)?(s=e[0].coords,r=e[d-1].coords):(s=e[0],r=e[d-1]),s.usrCoords[1]===p&&s.usrCoords[2]===_)return 1;for(u=0;u<d-f;u++)if(l.A.exists(e[u].coords)?(r=e[u].coords.usrCoords,o=e[(u+1)%d].coords.usrCoords):(r=e[u].usrCoords,o=e[(u+1)%d].usrCoords),!(0===r[0]||0===o[0]||isNaN(r[1])||isNaN(o[1])||isNaN(r[2])||isNaN(o[2]))){if(o[2]===_){if(o[1]===p)return 1;if(r[2]===_&&o[1]>p==r[1]<p)return 0}if(r[2]<_!=o[2]<_)if(h=2*(o[2]>r[2]?1:0)-1,r[1]>=p)if(o[1]>p)c+=h;else{if(0===(a=this.det3p(r,o,t)))return 0;a>0+n.A.eps==o[2]>r[2]&&(c+=h)}else o[1]>p&&(a=this.det3p(r,o,t))>0+n.A.eps==o[2]>r[2]&&(c+=h)}return c},pnpoly:function(t,e,i,s){var n,a,h,u,c,d,p,_,f=i,A=!1;for(s===r.A.COORDS_BY_USER?(d=(_=new o.A(r.A.COORDS_BY_USER,[t,e],this.board)).scrCoords[1],p=_.scrCoords[2]):(d=t,p=e),n=0,a=(c=i.length)-2;n<c-1;a=n++)h=l.A.exists(f[n].coords)?f[n].coords:f[n],u=l.A.exists(f[a].coords)?f[a].coords:f[a],h.scrCoords[2]>p!=u.scrCoords[2]>p&&d<(u.scrCoords[1]-h.scrCoords[1])*(p-h.scrCoords[2])/(u.scrCoords[2]-h.scrCoords[2])+h.scrCoords[1]&&(A=!A);return A},intersectionFunction:function(t,e,i,a,h,u){var c,d,p=this;return c=e.elementClass===r.A.OBJECT_CLASS_CURVE&&(e.type===r.A.OBJECT_TYPE_ARC||e.type===r.A.OBJECT_TYPE_SECTOR),d=i.elementClass===r.A.OBJECT_CLASS_CURVE&&(i.type===r.A.OBJECT_TYPE_ARC||i.type===r.A.OBJECT_TYPE_SECTOR),e.elementClass!==r.A.OBJECT_CLASS_CURVE&&i.elementClass!==r.A.OBJECT_CLASS_CURVE||e.elementClass!==r.A.OBJECT_CLASS_CURVE&&e.elementClass!==r.A.OBJECT_CLASS_CIRCLE||i.elementClass!==r.A.OBJECT_CLASS_CURVE&&i.elementClass!==r.A.OBJECT_CLASS_CIRCLE?e.elementClass===r.A.OBJECT_CLASS_CURVE&&!c&&i.elementClass===r.A.OBJECT_CLASS_LINE||i.elementClass===r.A.OBJECT_CLASS_CURVE&&!d&&e.elementClass===r.A.OBJECT_CLASS_LINE?function(){return p.meetCurveLine(e,i,a,e.board,l.A.evaluate(u))}:e.type===r.A.OBJECT_TYPE_POLYGON||i.type===r.A.OBJECT_TYPE_POLYGON?e.elementClass===r.A.OBJECT_CLASS_LINE?function(){var t,s=l.A.evaluate(e.visProp.straightfirst),r=l.A.evaluate(e.visProp.straightlast),o=l.A.evaluate(i.visProp.straightfirst),n=l.A.evaluate(i.visProp.straightlast);return t=!(l.A.evaluate(u)||s&&r&&o&&n),p.meetPolygonLine(i,e,a,e.board,t)}:i.elementClass===r.A.OBJECT_CLASS_LINE?function(){var t,s=l.A.evaluate(e.visProp.straightfirst),r=l.A.evaluate(e.visProp.straightlast),o=l.A.evaluate(i.visProp.straightfirst),n=l.A.evaluate(i.visProp.straightlast);return t=!(l.A.evaluate(u)||s&&r&&o&&n),p.meetPolygonLine(e,i,a,e.board,t)}:function(){return p.meetPathPath(e,i,a,e.board)}:e.elementClass===r.A.OBJECT_CLASS_LINE&&i.elementClass===r.A.OBJECT_CLASS_LINE?function(){var t,s,n=l.A.evaluate(e.visProp.straightfirst),h=l.A.evaluate(e.visProp.straightlast),c=l.A.evaluate(i.visProp.straightfirst),d=l.A.evaluate(i.visProp.straightlast);return l.A.evaluate(u)||n&&h&&c&&d?p.meet(e.stdform,i.stdform,a,e.board):(t=p.meetSegmentSegment(e.point1.coords.usrCoords,e.point2.coords.usrCoords,i.point1.coords.usrCoords,i.point2.coords.usrCoords),s=!n&&t[1]<0||!h&&t[1]>1||!c&&t[2]<0||!d&&t[2]>1?[0,NaN,NaN]:t[0],new o.A(r.A.COORDS_BY_USER,s,e.board))}:function(){var t,h,_,f=p.meet(e.stdform,i.stdform,a,e.board),A=!0;return l.A.evaluate(u)?f:(e.elementClass!==r.A.OBJECT_CLASS_LINE||(t=l.A.evaluate(e.visProp.straightfirst),h=l.A.evaluate(e.visProp.straightlast),t&&h||(_=p.affineRatio(e.point1.coords,e.point2.coords,f),!(!h&&_>1+n.A.eps||!t&&_<0-n.A.eps))))&&(i.elementClass!==r.A.OBJECT_CLASS_LINE||(t=l.A.evaluate(i.visProp.straightfirst),h=l.A.evaluate(i.visProp.straightlast),t&&h||(_=p.affineRatio(i.point1.coords,i.point2.coords,f),!(!h&&_>1+n.A.eps||!t&&_<0-n.A.eps))))?c&&((A=p.coordsOnArc(e,f))&&d&&(A=p.coordsOnArc(i,f)),!A)?new o.A(s.A.COORDS_BY_USER,[0,NaN,NaN],e.board):f:new o.A(s.A.COORDS_BY_USER,[0,NaN,NaN],e.board)}:function(){return p.meetCurveCurve(e,i,a,h,e.board)}},otherIntersectionFunction:function(t,e,i,o){var n,a,h,u=this;return a=t[0],h=t[1],n=a.board,function(){var t,c,d,p,_=e.length,f=l.A.evaluate(o);for(t=_;t>=0;t--){for(a.elementClass===r.A.OBJECT_CLASS_CIRCLE&&[r.A.OBJECT_CLASS_CIRCLE,r.A.OBJECT_CLASS_LINE].indexOf(h.elementClass)>=0?d=u.meet(a.stdform,h.stdform,t,n):a.elementClass===r.A.OBJECT_CLASS_CURVE&&[r.A.OBJECT_CLASS_CURVE,r.A.OBJECT_CLASS_CIRCLE].indexOf(h.elementClass)>=0?d=u.meetCurveCurve(a,h,t,0,n,"segment"):a.elementClass===r.A.OBJECT_CLASS_CURVE&&h.elementClass===r.A.OBJECT_CLASS_LINE&&(d=l.A.exists(a.dataX)?s.A.Math.Geometry.meetCurveLine(a,h,t,a.board,l.A.evaluate(i)):s.A.Math.Geometry.meetCurveLineContinuous(a,h,t,a.board)),p=!1,c=0;!p&&c<_;c++)d.distance(s.A.COORDS_BY_USER,e[c].coords)<f&&(p=!0);if(!p)return d}return d}},intersectionFunction3D:function(t,e,i,s){var o,n=this;return e.type===r.A.OBJECT_TYPE_PLANE3D?i.type===r.A.OBJECT_TYPE_PLANE3D?o=()=>t.intersectionPlanePlane(e,i)[s]:i.type===r.A.OBJECT_TYPE_SPHERE3D&&(o=n.meetPlaneSphere(e,i)):e.type===r.A.OBJECT_TYPE_SPHERE3D&&(i.type===r.A.OBJECT_TYPE_PLANE3D?o=n.meetPlaneSphere(i,e):i.type===r.A.OBJECT_TYPE_SPHERE3D&&(o=n.meetSphereSphere(e,i))),o},coordsOnArc:function(t,e){var i=this.rad(t.radiuspoint,t.center,e.usrCoords.slice(1)),s=0,r=this.rad(t.radiuspoint,t.center,t.anglepoint),o=l.A.evaluate(t.visProp.selection);return("minor"===o&&r>Math.PI||"major"===o&&r<Math.PI)&&(s=r,r=2*Math.PI),!(i<s||i>r)},meet:function(t,e,i,s){var r=n.A.eps;return Math.abs(t[3])<r&&Math.abs(e[3])<r?this.meetLineLine(t,e,i,s):Math.abs(t[3])>=r&&Math.abs(e[3])<r?this.meetLineCircle(e,t,i,s):Math.abs(t[3])<r&&Math.abs(e[3])>=r?this.meetLineCircle(t,e,i,s):this.meetCircleCircle(t,e,i,s)},meetLineBoard:function(t,e,i){var s,a,h,u,c=[];for(l.A.exists(i)||(i=0),c[0]=n.A.crossProduct(t,[i,0,1]),c[1]=n.A.crossProduct(t,[i,1,0]),c[2]=n.A.crossProduct(t,[-i-e.canvasHeight,0,1]),c[3]=n.A.crossProduct(t,[-i-e.canvasWidth,1,0]),h=0;h<4;h++)if(Math.abs(c[h][0])>n.A.eps){for(u=2;u>0;u--)c[h][u]/=c[h][0];c[h][0]=1}return Math.abs(c[1][0])<n.A.eps?(s=c[0],a=c[2]):Math.abs(c[0][0])<n.A.eps?(s=c[1],a=c[3]):c[1][2]<0?(s=c[0],a=c[3][2]>e.canvasHeight?c[2]:c[3]):c[1][2]>e.canvasHeight?(s=c[2],a=c[3][2]<0?c[0]:c[3]):(s=c[1],a=c[3][2]<0?c[0]:c[3][2]>e.canvasHeight?c[2]:c[3]),[new o.A(r.A.COORDS_BY_SCREEN,s.slice(1),e),new o.A(r.A.COORDS_BY_SCREEN,a.slice(1),e)]},meetLineLine:function(t,e,i,s){var a=isNaN(t[5]+e[5])?[0,0,0]:n.A.crossProduct(t,e);return Math.abs(a[0])<1e-14&&(a[0]=0),new o.A(r.A.COORDS_BY_USER,a,s)},meetLineCircle:function(t,e,i,s){var a,h,u,c,d,p,_,f,A;return e[4]<n.A.eps?Math.abs(n.A.innerProduct([1,e[6],e[7]],t,3))<n.A.eps?new o.A(r.A.COORDS_BY_USER,e.slice(6,8),s):new o.A(r.A.COORDS_BY_USER,[NaN,NaN],s):(u=e[0],h=e.slice(1,3),a=e[3],c=t[0],d=t.slice(1,3),p=a,(f=(_=h[0]*d[1]-h[1]*d[0])*_-4*p*(a*c*c-(h[0]*d[0]+h[1]*d[1])*c+u))>-n.A.eps*n.A.eps?(A=[(-_+(f=Math.sqrt(Math.abs(f))))/(2*p),(-_-f)/(2*p)],0===l.A.evaluate(i)?new o.A(r.A.COORDS_BY_USER,[-A[0]*-d[1]-c*d[0],-A[0]*d[0]-c*d[1]],s):new o.A(r.A.COORDS_BY_USER,[-A[1]*-d[1]-c*d[0],-A[1]*d[0]-c*d[1]],s)):new o.A(r.A.COORDS_BY_USER,[0,0,0],s))},meetCircleCircle:function(t,e,i,s){var a;return t[4]<n.A.eps?Math.abs(this.distance(t.slice(6,2),e.slice(6,8))-e[4])<n.A.eps?new o.A(r.A.COORDS_BY_USER,t.slice(6,8),s):new o.A(r.A.COORDS_BY_USER,[0,0,0],s):e[4]<n.A.eps?Math.abs(this.distance(e.slice(6,2),t.slice(6,8))-t[4])<n.A.eps?new o.A(r.A.COORDS_BY_USER,e.slice(6,8),s):new o.A(r.A.COORDS_BY_USER,[0,0,0],s):(a=[e[3]*t[0]-t[3]*e[0],e[3]*t[1]-t[3]*e[1],e[3]*t[2]-t[3]*e[2],0,1,1/0,1/0,1/0],a=n.A.normalize(a),this.meetLineCircle(a,t,i,s))},meetCurveCurve:function(t,e,i,s,n,h){var u;return u=l.A.exists(h)&&"newton"===h?a.A.generalizedNewton(t,e,l.A.evaluate(i),s):3===t.bezierDegree||3===e.bezierDegree?this.meetBezierCurveRedBlueSegments(t,e,i):this.meetCurveRedBlueSegments(t,e,i),new o.A(r.A.COORDS_BY_USER,u,n)},meetCurveLine:function(t,e,i,s,o){var n,a;return l.A.exists(s)||(s=t.board),t.elementClass===r.A.OBJECT_CLASS_CURVE?(n=t,a=e):(n=e,a=t),this.meetCurveLineDiscrete(n,a,i,s,!o)},meetCurveLineContinuous:function(t,e,i,s,l){var h,u,c,d,p,_,f,A,g,m,y,b,v,C=n.A.eps,P=n.A.eps;for(d=this.meetCurveLineDiscrete(t,e,i,s,l),p=d.usrCoords[1],_=d.usrCoords[2],h=function(e){var i,s;return e>t.maxX()||e<t.minX()?1/0:(i=t.X(e)-p)*i+(s=t.Y(e)-_)*s},u=function(i){var s=e.stdform[0]+e.stdform[1]*t.X(i)+e.stdform[2]*t.Y(i);return s*s},A=(t.maxX()-t.minX())/50,g=t.minX(),y=1e-4,m=NaN,b=0;b<50&&(c=a.A.root(h,[Math.max(g,t.minX()),Math.min(g+A,t.maxX())]),!((v=Math.abs(h(c)))<=y&&(m=c,(y=v)<C)));b++)g+=A;return c=m,v=u(c=a.A.root(u,[Math.max(c-A,t.minX()),Math.min(c+A,t.maxX())])),f=isNaN(v)||Math.abs(v)>P?0:1,new o.A(r.A.COORDS_BY_USER,[f,t.X(c),t.Y(c)],s)},meetCurveLineDiscrete:function(t,e,i,s,a){var h,u,c,d,p,_,f,A=l.A.evaluate(i),g=e.point1.coords.usrCoords,m=e.point2.coords.usrCoords,y=0,b=t.numberPoints,v=l.A.evaluate(e.visProp.straightfirst),C=l.A.evaluate(e.visProp.straightlast);for(_=new o.A(r.A.COORDS_BY_USER,[0,NaN,NaN],s),0===g[0]?g=[1,m[1]+e.stdform[2],m[2]-e.stdform[1]]:0===m[0]&&(m=[1,g[1]+e.stdform[2],g[2]-e.stdform[1]]),d=t.points[0].usrCoords,h=1;h<b;h+=t.bezierDegree)if(c=d.slice(0),d=t.points[h].usrCoords,this.distance(c,d)>n.A.eps)for(f=3===t.bezierDegree?this.meetBeziersegmentBeziersegment([t.points[h-1].usrCoords.slice(1),t.points[h].usrCoords.slice(1),t.points[h+1].usrCoords.slice(1),t.points[h+2].usrCoords.slice(1)],[g.slice(1),m.slice(1)],a):[this.meetSegmentSegment(c,d,g,m)],u=0;u<f.length;u++)if(0<=(p=f[u])[1]&&p[1]<=1){if(y===A)return a&&(!v&&p[2]<0||!C&&p[2]>1)?_:_=new o.A(r.A.COORDS_BY_USER,p[0],s);y+=1}return _},meetCurveRedBlueSegments:function(t,e,i){var s,r,o,n,a,h,u,c,d,p=l.A.evaluate(i),_=0,f=e.numberPoints,A=t.numberPoints;if(f<=1||A<=1)return[0,NaN,NaN];for(s=1;s<A;s++)for(o=t.points[s-1].usrCoords,n=t.points[s].usrCoords,c=Math.min(o[1],n[1]),d=Math.max(o[1],n[1]),h=e.points[0].usrCoords,r=1;r<f;r++)if(a=h,h=e.points[r].usrCoords,Math.min(a[1],h[1])<d&&Math.max(a[1],h[1])>c&&(u=this.meetSegmentSegment(o,n,a,h))[1]>=0&&u[2]>=0&&(u[1]<1&&u[2]<1||s===A-1&&1===u[1]||r===f-1&&1===u[2])){if(_===p)return u[0];_++}return[0,NaN,NaN]},meetSegmentSegment:function(t,e,i,s){var r,o,a,l=n.A.crossProduct(t,e),h=n.A.crossProduct(i,s),u=n.A.crossProduct(l,h);return Math.abs(u[0])<n.A.eps?[u,1/0,1/0]:(u[1]/=u[0],u[2]/=u[0],u[0]/=u[0],a=t[o=Math.abs(e[1]-e[0]*t[1])<n.A.eps?2:1]/t[0],r=(u[o]-a)/(0!==e[0]?e[o]/e[0]-a:e[o]),a=i[o=Math.abs(s[1]-s[0]*i[1])<n.A.eps?2:1]/i[0],[u,r,(u[o]-a)/(0!==s[0]?s[o]/s[0]-a:s[o])])},meetPathPath:function(t,e,i,a){var h,u,c,d,p=l.A.evaluate(i);return(c=(h=s.A.Math.Clip._getPath(t,a)).length)>0&&this.distance(h[0].coords.usrCoords,h[c-1].coords.usrCoords,3)<n.A.eps&&h.pop(),(c=(u=s.A.Math.Clip._getPath(e,a)).length)>0&&this.distance(u[0].coords.usrCoords,u[c-1].coords.usrCoords,3)<n.A.eps*n.A.eps&&u.pop(),i<0||s.A.Math.Clip.isEmptyCase(h,u,"intersection")?new o.A(r.A.COORDS_BY_USER,[0,0,0],a):(s.A.Math.Clip.makeDoublyLinkedList(h),s.A.Math.Clip.makeDoublyLinkedList(u),p<(d=s.A.Math.Clip.findIntersections(h,u,a)[0]).length?d[p].coords:new o.A(r.A.COORDS_BY_USER,[0,0,0],a))},meetPolygonLine:function(t,e,i,s,n){var a,h,u,c=l.A.evaluate(i),d=[0,0,0],p=t.borders.length,_=[];for(a=0;a<p;a++)u=t.borders[a],h=this.meetSegmentSegment(u.point1.coords.usrCoords,u.point2.coords.usrCoords,e.point1.coords.usrCoords,e.point2.coords.usrCoords),(!n||h[2]>=0&&h[2]<1)&&h[1]>=0&&h[1]<1&&_.push(h[0]);return c>=0&&c<_.length&&(d=_[c]),new o.A(r.A.COORDS_BY_USER,d,s)},meetPlaneSphere:function(t,e){var i=function(){return t.normal[0]*e.center.X()+t.normal[1]*e.center.Y()+t.normal[2]*e.center.Z()-t.d};return[[function(){return e.center.X()-i()*t.normal[0]},function(){return e.center.Y()-i()*t.normal[1]},function(){return e.center.Z()-i()*t.normal[2]}],[()=>t.normal[0],()=>t.normal[1],()=>t.normal[2]],function(){let t=e.Radius(),s=i();return Math.sqrt(t*t-s*s)}]},meetSphereSphere:function(t,e){var i=function(){let i=t.center.distance(e.center),s=t.Radius(),r=e.Radius();return(s-r)*(s+r)/(i*i)};return[[function(){let s=i();return.5*((1-s)*t.center.X()+(1+s)*e.center.X())},function(){let s=i();return.5*((1-s)*t.center.Y()+(1+s)*e.center.Y())},function(){let s=i();return.5*((1-s)*t.center.Z()+(1+s)*e.center.Z())}],[()=>e.center.X()-t.center.X(),()=>e.center.Y()-t.center.Y(),()=>e.center.Z()-t.center.Z()],function(){let s=t.center.distance(e.center),r=t.Radius(),o=e.Radius(),n=i(),a=.5*(r*r+o*o-.5*s*s*(1+n*n));return Math.sqrt(a)}]},_bezierSplit:function(t){var e,i,s,r,o,n;return e=[.5*(t[0][0]+t[1][0]),.5*(t[0][1]+t[1][1])],i=[.5*(t[1][0]+t[2][0]),.5*(t[1][1]+t[2][1])],s=[.5*(t[2][0]+t[3][0]),.5*(t[2][1]+t[3][1])],n=[.5*((r=[.5*(e[0]+i[0]),.5*(e[1]+i[1])])[0]+(o=[.5*(i[0]+s[0]),.5*(i[1]+s[1])])[0]),.5*(r[1]+o[1])],[[t[0],e,r,n],[n,o,s,t[3]]]},_bezierBbox:function(t){var e=[];return 4===t.length?(e[0]=Math.min(t[0][0],t[1][0],t[2][0],t[3][0]),e[1]=Math.max(t[0][1],t[1][1],t[2][1],t[3][1]),e[2]=Math.max(t[0][0],t[1][0],t[2][0],t[3][0]),e[3]=Math.min(t[0][1],t[1][1],t[2][1],t[3][1])):(e[0]=Math.min(t[0][0],t[1][0]),e[1]=Math.max(t[0][1],t[1][1]),e[2]=Math.max(t[0][0],t[1][0]),e[3]=Math.min(t[0][1],t[1][1])),e},_bezierOverlap:function(t,e){return t[2]>=e[0]&&t[0]<=e[2]&&t[1]>=e[3]&&t[3]<=e[1]},_bezierListConcat:function(t,e,i,s){var r,o=l.A.exists(s),n=0,a=e.length,h=t.length;for(h>0&&a>0&&(1===t[h-1][1]&&0===e[0][1]||o&&1===t[h-1][2]&&0===e[0][2])&&(n=1),r=n;r<a;r++)o&&(e[r][2]*=.5,e[r][2]+=s),e[r][1]*=.5,e[r][1]+=i,t.push(e[r])},_bezierMeetSubdivision:function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_,f=[];return r=this._bezierBbox(e),s=this._bezierBbox(t),this._bezierOverlap(r,s)?i<5?(l=(o=this._bezierSplit(t))[0],h=o[1],n=(o=this._bezierSplit(e))[0],a=o[1],this._bezierListConcat(f,this._bezierMeetSubdivision(l,n,i+1),0,0),this._bezierListConcat(f,this._bezierMeetSubdivision(l,a,i+1),0,.5),this._bezierListConcat(f,this._bezierMeetSubdivision(h,n,i+1),.5,0),this._bezierListConcat(f,this._bezierMeetSubdivision(h,a,i+1),.5,.5),f):(p=[1].concat(t[0]),_=[1].concat(t[3]),c=[1].concat(e[0]),d=[1].concat(e[3]),(u=this.meetSegmentSegment(p,_,c,d))[1]>=0&&u[2]>=0&&u[1]<=1&&u[2]<=1?[u]:[]):[]},_bezierLineMeetSubdivision:function(t,e,i,s){var r,o,n,a,l,h,u,c,d,p,_=[];return r=this._bezierBbox(e),o=this._bezierBbox(t),s&&!this._bezierOverlap(o,r)?[]:i<5?(a=(n=this._bezierSplit(t))[0],l=n[1],this._bezierListConcat(_,this._bezierLineMeetSubdivision(a,e,i+1),0),this._bezierListConcat(_,this._bezierLineMeetSubdivision(l,e,i+1),.5),_):(d=[1].concat(t[0]),p=[1].concat(t[3]),u=[1].concat(e[0]),c=[1].concat(e[1]),(h=this.meetSegmentSegment(d,p,u,c))[1]>=0&&h[1]<=1&&(!s||h[2]>=0&&h[2]<=1)?[h]:[])},meetBeziersegmentBeziersegment:function(t,e,i){var s,r,o;for((s=4===t.length&&4===e.length?this._bezierMeetSubdivision(t,e,0):this._bezierLineMeetSubdivision(t,e,0,i)).sort((function(t,e){return 1e7*(t[1]-e[1])+(t[2]-e[2])})),r=[],o=0;o<s.length;o++)0!==o&&s[o][1]===s[o-1][1]&&s[o][2]===s[o-1][2]||r.push(s[o]);return r},meetBezierCurveRedBlueSegments:function(t,e,i){var s,o,a,h,u,c,d,p,_,f,A,g,m,y=l.A.evaluate(i),b=0,v=0,C=[];if(e.numberPoints<e.bezierDegree+1||t.numberPoints<t.bezierDegree+1)return[0,NaN,NaN];for(1===t.bezierDegree&&3===e.bezierDegree&&(c=t,t=e,e=c),g=e.numberPoints-e.bezierDegree,m=t.numberPoints-t.bezierDegree,t.type===r.A.OBJECT_TYPE_SECTOR&&(b=3,m-=3),e.type===r.A.OBJECT_TYPE_SECTOR&&(v=3,g-=3),o=b;o<m;o+=t.bezierDegree)for(d=[(s=t.points)[o].usrCoords.slice(1),s[o+1].usrCoords.slice(1)],3===t.bezierDegree&&(d[2]=s[o+2].usrCoords.slice(1),d[3]=s[o+3].usrCoords.slice(1)),_=this._bezierBbox(d),a=v;a<g;a+=e.bezierDegree)if(p=[(s=e.points)[a].usrCoords.slice(1),s[a+1].usrCoords.slice(1)],3===e.bezierDegree&&(p[2]=s[a+2].usrCoords.slice(1),p[3]=s[a+3].usrCoords.slice(1)),f=this._bezierBbox(p),this._bezierOverlap(_,f)){if(0===(A=this.meetBeziersegmentBeziersegment(d,p)).length)continue;for(h=0;h<A.length;h++)(u=A[h])[1]<-n.A.eps||u[1]>1+n.A.eps||u[2]<-n.A.eps||u[2]>1+n.A.eps||C.push(u);if(C.length>y)return C[y][0]}return C.length>y?C[y][0]:[0,NaN,NaN]},bezierSegmentEval:function(t,e){var i,s,r,o=1-t;return s=0,r=0,s+=(i=o*o*o)*e[0][0],r+=i*e[0][1],s+=(i=3*t*o*o)*e[1][0],r+=i*e[1][1],s+=(i=3*t*t*o)*e[2][0],r+=i*e[2][1],[1,s+=(i=t*t*t)*e[3][0],r+=i*e[3][1]]},bezierArc:function(t,e,i,s,r){var o,a,h,u,c,d,p,_,f,A,g,m,y,b,v,C,P,x=.5*Math.PI,E=e[1],O=e[2],S=e[0],M=[],w=[];for(c=this.distance(e,t),E/=S,O/=S,d=this.rad(t.slice(1),e.slice(1),i.slice(1)),-1===r&&(d=2*Math.PI-d),(o=t)[1]/=o[0],o[2]/=o[0],o[0]/=o[0],u=o.slice(0),s?(M=[E,E+.333*(o[1]-E),E+.666*(o[1]-E),o[1]],w=[O,O+.333*(o[2]-O),O+.666*(o[2]-O),o[2]]):(M=[o[1]],w=[o[2]]);d>n.A.eps;)d>x?(p=x,d-=x):(p=d,d=0),P=[[1,0,0],[E*(1-(_=Math.cos(r*p)))+O*(f=Math.sin(r*p)),_,-f],[O*(1-_)-E*f,f,_]],u=[(v=n.A.matVecMult(P,o))[0]/v[0],v[1]/v[0],v[2]/v[0]],A=o[1]-E,g=o[2]-O,m=u[1]-E,y=u[2]-O,C=n.A.hypot(A+m,g+y),b=Math.abs(y-g)>n.A.eps?(A+m)*(c/C-.5)/(y-g)*8/3:(g+y)*(c/C-.5)/(A-m)*8/3,a=[1,o[1]-b*g,o[2]+b*A],h=[1,u[1]+b*y,u[2]-b*m],l.A.concat(M,[a[1],h[1],u[1]]),l.A.concat(w,[a[2],h[2],u[2]]),o=u.slice(0);return s&&(l.A.concat(M,[u[1]+.333*(E-u[1]),u[1]+.666*(E-u[1]),E]),l.A.concat(w,[u[2]+.333*(O-u[2]),u[2]+.666*(O-u[2]),O])),[M,w]},projectPointToCircle:function(t,e,i){var s,a,h,u,c,d=e.center.coords.usrCoords;return l.A.exists(i)||(i=t.board),l.A.isPoint(t)?(s=t.coords.distance(r.A.COORDS_BY_USER,e.center.coords),a=t.coords.usrCoords):(s=t.distance(r.A.COORDS_BY_USER,e.center.coords),a=t.usrCoords),Math.abs(s)<n.A.eps&&(s=n.A.eps),c=e.Radius()/s,h=d[1]+c*(a[1]-d[1]),u=d[2]+c*(a[2]-d[2]),new o.A(r.A.COORDS_BY_USER,[h,u],i)},projectPointToLine:function(t,e,i){var s,a=[0,e.stdform[1],e.stdform[2]];return l.A.exists(i)||(i=l.A.exists(t.coords)?t.board:e.board),s=l.A.exists(t.coords)?t.coords.usrCoords:t.usrCoords,a=n.A.crossProduct(a,s),new o.A(r.A.COORDS_BY_USER,n.A.crossProduct(a,e.stdform),i)},projectCoordsToSegment:function(t,e,i){var s,r=[i[1]-e[1],i[2]-e[2]],o=[t[1]-e[1],t[2]-e[2]];return Math.abs(r[0])<n.A.eps&&Math.abs(r[1])<n.A.eps?[e,0]:(s=n.A.innerProduct(o,r),[[1,(s/=n.A.innerProduct(r,r))*r[0]+e[1],s*r[1]+e[2]],s])},projectCoordsToBeziersegment:function(t,e,i){var r;return r=s.A.Math.Numerics.fminbr((function(s){var r=[1,e.X(i+s),e.Y(i+s)];return r[1]-=t[1],r[2]-=t[2],r[1]*r[1]+r[2]*r[2]}),[0,1]),[[1,e.X(r+i),e.Y(r+i)],r]},projectPointToCurve:function(t,e,i){l.A.exists(i)||(i=t.board);var s=t.X(),r=t.Y(),o=t.position||0;return this.projectCoordsToCurve(s,r,o,e,i)},projectCoordsToCurve:function(t,e,i,s,n){var h,u,c,d,p,_,f,A,g,m,y,b,v,C,P,x,E,O,S,M,w,T,N=Number.POSITIVE_INFINITY;if(l.A.exists(n)||(n=s.board),"plot"===l.A.evaluate(s.visProp.curvetype)){if(i=0,p=N,h=0===s.numberPoints?[0,1,1]:[s.Z(0),s.X(0),s.Y(0)],s.numberPoints>1)for(A=[1,t,e],3===s.bezierDegree?d=0:y=[s.Z(0),s.X(0),s.Y(0)],c=0;c<s.numberPoints-1;c++)3===s.bezierDegree?v=this.projectCoordsToBeziersegment(A,s,d):(b=[s.Z(c+1),s.X(c+1),s.Y(c+1)],v=this.projectCoordsToSegment(A,y,b)),f=v[1],g=v[0],0<=f&&f<=1?(_=this.distance(g,A),m=c+f):f<0?(g=y,_=this.distance(y,A),m=c):f>1&&c===s.numberPoints-2&&(g=b,_=this.distance(g,A),m=s.numberPoints-1),_<p&&(p=_,i=m,h=g),3===s.bezierDegree?(d++,c+=2):y=b;u=new o.A(r.A.COORDS_BY_USER,h,n)}else{for(C=function(i){var r,o;return i<s.minX()||i>s.maxX()?1/0:(r=t-s.X(i))*r+(o=e-s.Y(i))*o},E=C(i),w=s.minX(),O=((T=s.maxX())-w)/50,P=w,c=0;c<50;c++)((x=C(P))<E||E===1/0||isNaN(E))&&(i=P,E=x),P+=O;for(S=O,c=0;c<20&&isNaN(C(i-S));c++,S*=.5);for(isNaN(C(i-S))&&(S=0),M=O,c=0;c<20&&isNaN(C(i+M));c++,M*=.5);isNaN(C(i+M))&&(M=0),i=(i=(i=a.A.fminbr(C,[Math.max(i-S,w),Math.min(i+M,T)]))<w?w:i)>T?T:i,u=new o.A(r.A.COORDS_BY_USER,[s.X(i),s.Y(i)],n)}return[s.updateTransform(u),i]},projectCoordsToPolygon:function(t,e){var i,r,o,n,a,l=e.vertices.length,h=1/0;for(i=0;i<l-1;i++)0<=(o=s.A.Math.Geometry.projectCoordsToSegment(t,e.vertices[i].coords.usrCoords,e.vertices[i+1].coords.usrCoords))[1]&&o[1]<=1?(r=s.A.Math.Geometry.distance(o[0],t,3),n=o[0]):o[1]<0?(r=s.A.Math.Geometry.distance(e.vertices[i].coords.usrCoords,t,3),n=e.vertices[i].coords.usrCoords):(r=s.A.Math.Geometry.distance(e.vertices[i+1].coords.usrCoords,t,3),n=e.vertices[i+1].coords.usrCoords),r<h&&(a=n.slice(0),h=r);return a},projectPointToTurtle:function(t,e,i){var s,n,a,h,u,c,d,p,_,f,A=0,g=0,m=Number.POSITIVE_INFINITY,y=e.objects.length;for(l.A.exists(i)||(i=t.board),u=0;u<y;u++)(d=e.objects[u]).elementClass===r.A.OBJECT_CLASS_CURVE&&(s=(_=this.projectPointToCurve(t,d))[0],f=_[1],(c=this.distance(s.usrCoords,t.coords.usrCoords))<m&&(a=s.usrCoords[1],h=s.usrCoords[2],n=f,m=c,p=d,g=A),A+=d.numberPoints);return s=new o.A(r.A.COORDS_BY_USER,[a,h],i),[p.updateTransform(s),n+g]},projectPointToPoint:function(t,e){return e.coords},projectPointToBoard:function(t,e){var i,s,r,o=e||t.board,a=[[1,1,0,0,3,0,1],[-1,2,1,0,1,2,1],[-1,1,2,2,1,2,3],[1,2,3,0,3,2,3]],l=t.coords||t,h=o.getBoundingBox();for(i=0;i<4;i++)(r=a[i])[0]*l.usrCoords[r[1]]<r[0]*h[r[2]]&&((s=n.A.crossProduct([1,h[r[3]],h[r[4]]],[1,h[r[5]],h[r[6]]]))[3]=0,s=n.A.normalize(s),l=this.projectPointToLine({coords:l},{stdform:s},o));return l},projectCoordsToParametric:function(t,e,i){var s,r,o,a=i.length;return 1===a?s=.1*(e.range[1]-e.range[0]):2===a&&(s=.1*Math.min(e.range_u[1]-e.range_u[0],e.range_v[1]-e.range_v[0])),r=s/5e6,o=function(i,s,r,o){var n=t[0]-e.X.apply(null,r),a=t[1]-e.Y.apply(null,r),l=t[2]-e.Z.apply(null,r);return 1===i?(o[0]=r[0]-e.range[0],o[1]=-r[0]+e.range[1]):2===i&&(o[0]=r[0]-e.range_u[0],o[1]=-r[0]+e.range_u[1],o[2]=r[1]-e.range_v[0],o[3]=-r[1]+e.range_v[1]),n*n+a*a+l*l},n.A.Nlp.FindMinimum(o,a,2*a,i,s,r,0,200),[1,e.X.apply(null,i),e.Y.apply(null,i),e.Z.apply(null,i)]},projectScreenCoordsToParametric:function(t,e,i){var s,r,o,a=i.length;return 1===a?s=.1*(e.range[1]-e.range[0]):2===a&&(s=.1*Math.min(e.range_u[1]-e.range_u[0],e.range_v[1]-e.range_v[0])),r=s/5e6,o=function(i,s,r,o){var n=[1,e.X.apply(null,r),e.Y.apply(null,r),e.Z.apply(null,r)],a=e.view.project3DTo2D(n),l=t[0]-a[1],h=t[1]-a[2];return 1===i?(o[0]=r[0]-e.range[0],o[1]=-r[0]+e.range[1]):2===i&&(o[0]=r[0]-e.range_u[0],o[1]=-r[0]+e.range_u[1],o[2]=r[1]-e.range_v[0],o[3]=-r[1]+e.range_v[1]),l*l+h*h},n.A.Nlp.FindMinimum(o,a,2*a,i,s,r,0,200),[1,e.X.apply(null,i),e.Y.apply(null,i),e.Z.apply(null,i)]},distPointLine:function(t,e){var i,s=e[1],r=e[2],o=e[0];return Math.abs(s)+Math.abs(r)<n.A.eps?Number.POSITIVE_INFINITY:(i=s*t[1]+r*t[2]+o,s*=s,r*=r,Math.abs(i)/Math.sqrt(s+r))},distPointSegment:function(t,e,i){var s,r,o,a,l,h,u=n.A.eps*n.A.eps,c=1e6;return s=(s=t[1]-e[1])===1/0?c:s===-1/0?-c:s,r=(r=t[2]-e[2])===1/0?c:r===-1/0?-c:r,(l=(o=(o=i[1]-e[1])===1/0?c:o===-1/0?-c:o)*o+(a=(a=i[2]-e[2])===1/0?c:a===-1/0?-c:a)*a)>u&&((h=(s*o+r*a)/l)<0?h=0:h>1&&(h=1),s-=h*o,r-=h*a),n.A.hypot(s,r)},reuleauxPolygon:function(t,e){var i,s=2*Math.PI,r=s/e,o=(e-1)/2,a=0,l=function(l,h){return function(u,c){var d=(u%s+s)%s,p=Math.floor(d/r)%e;return c||(a=t[0].Dist(t[o]),i=n.A.Geometry.rad([t[0].X()+1,t[0].Y()],t[0],t[o%e])),isNaN(p)?p:(d=.5*d+p*r*.5+i,t[p][l]()+a*Math[h](d))}};return[l("X","cos"),l("Y","sin"),0,s]},meet3Planes:function(t,e,i,s,r,o){var a,l,h,u,c,d=[0,0,0];for(a=n.A.crossProduct(r,t),l=n.A.crossProduct(t,i),h=n.A.crossProduct(i,r),u=n.A.innerProduct(t,h,3),c=0;c<3;c++)d[c]=(e*h[c]+s*a[c]+o*l[c])/u;return d},meetPlanePlane:function(t,e,i,s){var r,o,a,h=[0,0,0],u=[0,0,0];for(r=0;r<3;r++)h[r]=l.A.evaluate(t[r]),u[r]=l.A.evaluate(e[r]);for(o=n.A.crossProduct(h,u),r=0;r<3;r++)h[r]=l.A.evaluate(i[r]),u[r]=l.A.evaluate(s[r]);return a=n.A.crossProduct(h,u),n.A.crossProduct(o,a)},project3DTo3DPlane:function(t,e,i){var s,r;return i=i||[0,0,0],s=n.A.norm(e),r=(n.A.innerProduct(t,e,3)-n.A.innerProduct(i,e,3))/s,n.A.axpy(-r,e,t)},getPlaneBounds:function(t,e,i,s,r){var o,n,l,h,u;return t[2]+e[0]!==0?(l=[[t[0],e[0]],[t[1],e[1]]],h=[s-i[0],s-i[1]],o=(u=a.A.Gauss(l,h))[0],n=u[1],h=[r-i[0],r-i[1]],[o,(u=a.A.Gauss(l,h))[0],n,u[1]]):null}}),e.A=n.A.Geometry},733:function(t,e,i){var s=i(443),r=i(477),o=i(188);s.A.Math.DoubleBits=function(){var t,e,i,s,r,o,n,a,l=new Float64Array(1),h=new Uint32Array(l.buffer);void 0!==Float64Array&&(l[0]=1,1072693248===h[1]?(t=function(t){return l[0]=t,[h[0],h[1]]},e=function(t,e){return h[0]=t,h[1]=e,l[0]},i=function(t){return l[0]=t,h[0]},s=function(t){return l[0]=t,h[1]},this.doubleBits=t,this.pack=e,this.lo=i,this.hi=s):1072693248===h[0]&&(r=function(t){return l[0]=t,[h[1],h[0]]},o=function(t,e){return h[1]=t,h[0]=e,l[0]},n=function(t){return l[0]=t,h[1]},a=function(t){return l[0]=t,h[0]},this.doubleBits=r,this.pack=o,this.lo=n,this.hi=a))},s.A.extend(s.A.Math.DoubleBits.prototype,{sign:function(t){return this.hi(t)>>>31},exponent:function(t){return(this.hi(t)<<1>>>21)-1023},fraction:function(t){var e=this.lo(t),i=this.hi(t),s=1048575&i;return 2146435072&i&&(s+=1<<20),[e,s]},denormalized:function(t){return!(2146435072&this.hi(t))}});var n=new s.A.Math.DoubleBits,a=function(t,e){if(void 0!==t&&void 0!==e){if(r.A.IntervalArithmetic.isInterval(t)){if(!r.A.IntervalArithmetic.isSingleton(t))throw new TypeError("JXG.Math.IntervalArithmetic: interval `lo` must be a singleton");this.lo=t.lo}else this.lo=t;if(r.A.IntervalArithmetic.isInterval(e)){if(!r.A.IntervalArithmetic.isSingleton(e))throw new TypeError("JXG.Math.IntervalArithmetic: interval `hi` must be a singleton");this.hi=e.hi}else this.hi=e}else{if(void 0!==t)return Array.isArray(t)?new a(t[0],t[1]):new a(t,t);this.lo=this.hi=0}};s.A.extend(a.prototype,{print:function(){console.log("[",this.lo,this.hi,"]")},set:function(t,e){return this.lo=t,this.hi=e,this},bounded:function(t,e){return this.set(r.A.IntervalArithmetic.prev(t),r.A.IntervalArithmetic.next(e))},boundedSingleton:function(t){return this.bounded(t,t)},assign:function(t,e){if("number"!=typeof t||"number"!=typeof e)throw new TypeError("JXG.Math.Interval#assign: arguments must be numbers");return isNaN(t)||isNaN(e)||t>e?this.setEmpty():this.set(t,e)},setEmpty:function(){return this.set(Number.POSITIVE_INFINITY,Number.NEGATIVE_INFINITY)},setWhole:function(){return this.set(Number.NEGATIVE_INFINITY,Number.POSITIVE_INFINITY)},open:function(t,e){return this.assign(r.A.IntervalArithmetic.next(t),r.A.IntervalArithmetic.prev(e))},halfOpenLeft:function(t,e){return this.assign(r.A.IntervalArithmetic.next(t),e)},halfOpenRight:function(t,e){return this.assign(t,r.A.IntervalArithmetic.prev(e))},toArray:function(){return[this.lo,this.hi]},clone:function(){return(new a).set(this.lo,this.hi)}}),s.A.Math.IntervalArithmetic={Interval:function(t,e){return new a(t,e)},isInterval:function(t){return null!==t&&"object"==typeof t&&"number"==typeof t.lo&&"number"==typeof t.hi},isSingleton:function(t){return t.lo===t.hi},add:function(t,e){return o.A.isNumber(t)&&(t=this.Interval(t)),o.A.isNumber(e)&&(e=this.Interval(e)),new a(this.addLo(t.lo,e.lo),this.addHi(t.hi,e.hi))},sub:function(t,e){return o.A.isNumber(t)&&(t=this.Interval(t)),o.A.isNumber(e)&&(e=this.Interval(e)),new a(this.subLo(t.lo,e.hi),this.subHi(t.hi,e.lo))},mul:function(t,e){var i,s,r,n,l;return o.A.isNumber(t)&&(t=this.Interval(t)),o.A.isNumber(e)&&(e=this.Interval(e)),this.isEmpty(t)||this.isEmpty(e)?this.EMPTY.clone():(i=t.lo,s=t.hi,r=e.lo,n=e.hi,l=new a,i<0?s>0?r<0?n>0?(l.lo=Math.min(this.mulLo(i,n),this.mulLo(s,r)),l.hi=Math.max(this.mulHi(i,r),this.mulHi(s,n))):(l.lo=this.mulLo(s,r),l.hi=this.mulHi(i,r)):n>0?(l.lo=this.mulLo(i,n),l.hi=this.mulHi(s,n)):(l.lo=0,l.hi=0):r<0?n>0?(l.lo=this.mulLo(i,n),l.hi=this.mulHi(i,r)):(l.lo=this.mulLo(s,n),l.hi=this.mulHi(i,r)):n>0?(l.lo=this.mulLo(i,n),l.hi=this.mulHi(s,r)):(l.lo=0,l.hi=0):s>0?r<0?n>0?(l.lo=this.mulLo(s,r),l.hi=this.mulHi(s,n)):(l.lo=this.mulLo(s,r),l.hi=this.mulHi(i,n)):n>0?(l.lo=this.mulLo(i,r),l.hi=this.mulHi(s,n)):(l.lo=0,l.hi=0):(l.lo=0,l.hi=0),l)},div:function(t,e){return o.A.isNumber(t)&&(t=this.Interval(t)),o.A.isNumber(e)&&(e=this.Interval(e)),this.isEmpty(t)||this.isEmpty(e)?this.EMPTY.clone():this.zeroIn(e)?0!==e.lo?0!==e.hi?this.divZero(t):this.divNegative(t,e.lo):0!==e.hi?this.divPositive(t,e.hi):this.EMPTY.clone():this.divNonZero(t,e)},positive:function(t){return new a(t.lo,t.hi)},negative:function(t){return o.A.isNumber(t)?new a(-t):new a(-t.hi,-t.lo)},isEmpty:function(t){return t.lo>t.hi},isWhole:function(t){return t.lo===-1/0&&t.hi===1/0},zeroIn:function(t){return this.hasValue(t,0)},hasValue:function(t,e){return!this.isEmpty(t)&&(t.lo<=e&&e<=t.hi)},hasInterval:function(t,e){return!!this.isEmpty(t)||!this.isEmpty(e)&&e.lo<=t.lo&&t.hi<=e.hi},intervalsOverlap:function(t,e){return!this.isEmpty(t)&&!this.isEmpty(e)&&(t.lo<=e.lo&&e.lo<=t.hi||e.lo<=t.lo&&t.lo<=e.hi)},divNonZero:function(t,e){var i=t.lo,s=t.hi,r=e.lo,o=e.hi,n=new a;return s<0?o<0?(n.lo=this.divLo(s,r),n.hi=this.divHi(i,o)):(n.lo=this.divLo(i,r),n.hi=this.divHi(s,o)):i<0?o<0?(n.lo=this.divLo(s,o),n.hi=this.divHi(i,o)):(n.lo=this.divLo(i,r),n.hi=this.divHi(s,r)):o<0?(n.lo=this.divLo(s,o),n.hi=this.divHi(i,r)):(n.lo=this.divLo(i,o),n.hi=this.divHi(s,r)),n},divPositive:function(t,e){return 0===t.lo&&0===t.hi?t:this.zeroIn(t)?this.WHOLE:t.hi<0?new a(Number.NEGATIVE_INFINITY,this.divHi(t.hi,e)):new a(this.divLo(t.lo,e),Number.POSITIVE_INFINITY)},divNegative:function(t,e){return 0===t.lo&&0===t.hi?t:this.zeroIn(t)?this.WHOLE:t.hi<0?new a(this.divLo(t.hi,e),Number.POSITIVE_INFINITY):new a(Number.NEGATIVE_INFINITY,this.divHi(t.lo,e))},divZero:function(t){return 0===t.lo&&0===t.hi?t:this.WHOLE},fmod:function(t,e){var i,s;return o.A.isNumber(t)&&(t=this.Interval(t)),o.A.isNumber(e)&&(e=this.Interval(e)),this.isEmpty(t)||this.isEmpty(e)?this.EMPTY.clone():(i=t.lo<0?e.lo:e.hi,s=(s=t.lo/i)<0?Math.ceil(s):Math.floor(s),this.sub(t,this.mul(e,new a(s))))},multiplicativeInverse:function(t){return o.A.isNumber(t)&&(t=this.Interval(t)),this.isEmpty(t)?this.EMPTY.clone():this.zeroIn(t)?0!==t.lo?0!==t.hi?this.WHOLE:new a(Number.NEGATIVE_INFINITY,this.divHi(1,t.lo)):0!==t.hi?new a(this.divLo(1,t.hi),Number.POSITIVE_INFINITY):this.EMPTY.clone():new a(this.divLo(1,t.hi),this.divHi(1,t.lo))},pow:function(t,e){var i,s;if(o.A.isNumber(t)&&(t=this.Interval(t)),this.isEmpty(t))return this.EMPTY.clone();if(this.isInterval(e)){if(!this.isSingleton(e))return this.EMPTY.clone();e=e.lo}return 0===e?0===t.lo&&0===t.hi?this.EMPTY.clone():this.ONE.clone():e<0?this.pow(this.multiplicativeInverse(t),-e):e%1==0?t.hi<0?(i=this.powLo(-t.hi,e),s=this.powHi(-t.lo,e),1&~e?new a(i,s):new a(-s,-i)):t.lo<0?1&~e?new a(0,this.powHi(Math.max(-t.lo,t.hi),e)):new a(-this.powLo(-t.lo,e),this.powHi(t.hi,e)):new a(this.powLo(t.lo,e),this.powHi(t.hi,e)):(console.warn("power is not an integer, you should use nth-root instead, returning an empty interval"),this.EMPTY.clone())},sqrt:function(t){return o.A.isNumber(t)&&(t=this.Interval(t)),this.nthRoot(t,2)},nthRoot:function(t,e){var i,s,r,n,l;if(o.A.isNumber(t)&&(t=this.Interval(t)),this.isEmpty(t)||e<0)return this.EMPTY.clone();if(this.isInterval(e)){if(!this.isSingleton(e))return this.EMPTY.clone();e=e.lo}return i=1/e,t.hi<0?e%1!=0||1&~e?this.EMPTY.clone():(s=this.powHi(-t.lo,i),r=this.powLo(-t.hi,i),new a(-s,-r)):t.lo<0?(n=this.powHi(t.hi,i),e%1!=0||1&~e?new a(0,n):(l=-this.powHi(-t.lo,i),new a(l,n))):new a(this.powLo(t.lo,i),this.powHi(t.hi,i))},exp:function(t){return o.A.isNumber(t)&&(t=this.Interval(t)),this.isEmpty(t)?this.EMPTY.clone():new a(this.expLo(t.lo),this.expHi(t.hi))},log:function(t){var e;return o.A.isNumber(t)&&(t=this.Interval(t)),this.isEmpty(t)?this.EMPTY.clone():(e=t.lo<=0?Number.NEGATIVE_INFINITY:this.logLo(t.lo),new a(e,this.logHi(t.hi)))},ln:function(t){return this.log(t)},log10:function(t){return this.isEmpty(t)?this.EMPTY.clone():this.div(this.log(t),this.log(new a(10,10)))},log2:function(t){return this.isEmpty(t)?this.EMPTY.clone():this.div(this.log(t),this.log(new a(2,2)))},hull:function(t,e){var i=this.isEmpty(t),s=this.isEmpty(e);return i&&s?this.EMPTY.clone():i?e.clone():s?t.clone():new a(Math.min(t.lo,e.lo),Math.max(t.hi,e.hi))},intersection:function(t,e){var i,s;return this.isEmpty(t)||this.isEmpty(e)?this.EMPTY.clone():(i=Math.max(t.lo,e.lo))<=(s=Math.min(t.hi,e.hi))?new a(i,s):this.EMPTY.clone()},union:function(t,e){if(!this.intervalsOverlap(t,e))throw new Error("Interval#unions do not overlap");return new a(Math.min(t.lo,e.lo),Math.max(t.hi,e.hi))},difference:function(t,e){if(this.isEmpty(t)||this.isWhole(e))return this.EMPTY.clone();if(this.intervalsOverlap(t,e)){if(t.lo<e.lo&&e.hi<t.hi)throw new Error("Interval.difference: difference creates multiple intervals");return e.lo<=t.lo&&e.hi===1/0||e.hi>=t.hi&&e.lo===-1/0?this.EMPTY.clone():e.lo<=t.lo?(new a).halfOpenLeft(e.hi,t.hi):(new a).halfOpenRight(t.lo,e.lo)}return t.clone()},width:function(t){return this.isEmpty(t)?0:this.subHi(t.hi,t.lo)},abs:function(t){return o.A.isNumber(t)&&(t=this.Interval(t)),this.isEmpty(t)?this.EMPTY.clone():t.lo>=0?t.clone():t.hi<=0?this.negative(t):new a(0,Math.max(-t.lo,t.hi))},max:function(t,e){var i=this.isEmpty(t),s=this.isEmpty(e);return i&&s?this.EMPTY.clone():i?e.clone():s?t.clone():new a(Math.max(t.lo,e.lo),Math.max(t.hi,e.hi))},min:function(t,e){var i=this.isEmpty(t),s=this.isEmpty(e);return i&&s?this.EMPTY.clone():i?e.clone():s?t.clone():new a(Math.min(t.lo,e.lo),Math.min(t.hi,e.hi))},onlyInfinity:function(t){return!isFinite(t.lo)&&t.lo===t.hi},_handleNegative:function(t){var e;return t.lo<0&&(t.lo===-1/0?(t.lo=0,t.hi=1/0):(e=Math.ceil(-t.lo/this.piTwiceLow),t.lo+=this.piTwiceLow*e,t.hi+=this.piTwiceLow*e)),t},cos:function(t){var e,i,s,r,o,n,l,h;return this.isEmpty(t)||this.onlyInfinity(t)?this.EMPTY.clone():(e=(new a).set(t.lo,t.hi),this._handleNegative(e),i=this.PI_TWICE,s=this.fmod(e,i),this.width(s)>=i.lo?new a(-1,1):s.lo>=this.piHigh?(r=this.cos(this.sub(s,this.PI)),this.negative(r)):(o=s.lo,n=s.hi,l=this.cosLo(n),h=this.cosHi(o),n<=this.piLow?new a(l,h):n<=i.lo?new a(-1,Math.max(l,h)):new a(-1,1)))},sin:function(t){return this.isEmpty(t)||this.onlyInfinity(t)?this.EMPTY.clone():this.cos(this.sub(t,this.PI_HALF))},tan:function(t){var e,i,s;return this.isEmpty(t)||this.onlyInfinity(t)?this.EMPTY.clone():(e=(new a).set(t.lo,t.hi),this._handleNegative(e),s=this.PI,(i=this.fmod(e,s)).lo>=this.piHalfLow&&(i=this.sub(i,s)),i.lo<=-this.piHalfLow||i.hi>=this.piHalfLow?this.WHOLE.clone():new a(this.tanLo(i.lo),this.tanHi(i.hi)))},asin:function(t){var e,i;return this.isEmpty(t)||t.hi<-1||t.lo>1?this.EMPTY.clone():(e=t.lo<=-1?-this.piHalfHigh:this.asinLo(t.lo),i=t.hi>=1?this.piHalfHigh:this.asinHi(t.hi),new a(e,i))},acos:function(t){var e,i;return this.isEmpty(t)||t.hi<-1||t.lo>1?this.EMPTY.clone():(e=t.hi>=1?0:this.acosLo(t.hi),i=t.lo<=-1?this.piHigh:this.acosHi(t.lo),new a(e,i))},acot:function(t){return this.isEmpty(t)?this.EMPTY.clone():new a(this.acotLo(t.lo),this.acotHi(t.hi))},atan:function(t){return this.isEmpty(t)?this.EMPTY.clone():new a(this.atanLo(t.lo),this.atanHi(t.hi))},sinh:function(t){return this.isEmpty(t)?this.EMPTY.clone():new a(this.sinhLo(t.lo),this.sinhHi(t.hi))},cosh:function(t){return this.isEmpty(t)?this.EMPTY.clone():t.hi<0?new a(this.coshLo(t.hi),this.coshHi(t.lo)):t.lo>=0?new a(this.coshLo(t.lo),this.coshHi(t.hi)):new a(1,this.coshHi(-t.lo>t.hi?t.lo:t.hi))},tanh:function(t){return this.isEmpty(t)?this.EMPTY.clone():new a(this.tanhLo(t.lo),this.tanhHi(t.hi))},equal:function(t,e){return this.isEmpty(t)?this.isEmpty(e):!this.isEmpty(e)&&t.lo===e.lo&&t.hi===e.hi},notEqual:function(t,e){return this.isEmpty(t)?!this.isEmpty(e):this.isEmpty(e)||t.hi<e.lo||t.lo>e.hi},lt:function(t,e){return o.A.isNumber(t)&&(t=this.Interval(t)),o.A.isNumber(e)&&(e=this.Interval(e)),!this.isEmpty(t)&&!this.isEmpty(e)&&t.hi<e.lo},gt:function(t,e){return o.A.isNumber(t)&&(t=this.Interval(t)),o.A.isNumber(e)&&(e=this.Interval(e)),!this.isEmpty(t)&&!this.isEmpty(e)&&t.lo>e.hi},leq:function(t,e){return o.A.isNumber(t)&&(t=this.Interval(t)),o.A.isNumber(e)&&(e=this.Interval(e)),!this.isEmpty(t)&&!this.isEmpty(e)&&t.hi<=e.lo},geq:function(t,e){return o.A.isNumber(t)&&(t=this.Interval(t)),o.A.isNumber(e)&&(e=this.Interval(e)),!this.isEmpty(t)&&!this.isEmpty(e)&&t.lo>=e.hi},piLow:3.141592653589793,piHigh:3.1415926535897936,piHalfLow:1.5707963267948966,piHalfHigh:1.5707963267948968,piTwiceLow:6.283185307179586,piTwiceHigh:6.283185307179587,identity:function(t){return t},_prev:function(t){return t===1/0?t:this.nextafter(t,-1/0)},_next:function(t){return t===-1/0?t:this.nextafter(t,1/0)},prev:function(t){return this._prev(t)},next:function(t){return this._next(t)},toInteger:function(t){return t<0?Math.ceil(t):Math.floor(t)},addLo:function(t,e){return this.prev(t+e)},addHi:function(t,e){return this.next(t+e)},subLo:function(t,e){return this.prev(t-e)},subHi:function(t,e){return this.next(t-e)},mulLo:function(t,e){return this.prev(t*e)},mulHi:function(t,e){return this.next(t*e)},divLo:function(t,e){return this.prev(t/e)},divHi:function(t,e){return this.next(t/e)},intLo:function(t){return this.toInteger(this.prev(t))},intHi:function(t){return this.toInteger(this.next(t))},logLo:function(t){return this.prev(Math.log(t))},logHi:function(t){return this.next(Math.log(t))},expLo:function(t){return this.prev(Math.exp(t))},expHi:function(t){return this.next(Math.exp(t))},sinLo:function(t){return this.prev(Math.sin(t))},sinHi:function(t){return this.next(Math.sin(t))},cosLo:function(t){return this.prev(Math.cos(t))},cosHi:function(t){return this.next(Math.cos(t))},tanLo:function(t){return this.prev(Math.tan(t))},tanHi:function(t){return this.next(Math.tan(t))},asinLo:function(t){return this.prev(Math.asin(t))},asinHi:function(t){return this.next(Math.asin(t))},acosLo:function(t){return this.prev(Math.acos(t))},acosHi:function(t){return this.next(Math.acos(t))},acotLo:function(t){return this.prev(r.A.acot(t))},acotHi:function(t){return this.next(r.A.acot(t))},atanLo:function(t){return this.prev(Math.atan(t))},atanHi:function(t){return this.next(Math.atan(t))},sinhLo:function(t){return this.prev(r.A.sinh(t))},sinhHi:function(t){return this.next(r.A.sinh(t))},coshLo:function(t){return this.prev(r.A.cosh(t))},coshHi:function(t){return this.next(r.A.cosh(t))},tanhLo:function(t){return this.prev(r.A.tanh(t))},tanhHi:function(t){return this.next(r.A.tanh(t))},sqrtLo:function(t){return this.prev(Math.sqrt(t))},sqrtHi:function(t){return this.next(Math.sqrt(t))},powLo:function(t,e){var i;if(e%1!=0)return this.prev(Math.pow(t,e));for(i=1&~e?1:t,e>>=1;e>0;)t=this.mulLo(t,t),1&~e||(i=this.mulLo(t,i)),e>>=1;return i},powHi:function(t,e){var i;if(e%1!=0)return this.next(Math.pow(t,e));for(i=1&~e?1:t,e>>=1;e>0;)t=this.mulHi(t,t),1&~e||(i=this.mulHi(t,i)),e>>=1;return i},disable:function(){this.next=this.prev=this.identity},enable:function(){this.prev=function(t){return this._prev(t)},this.next=function(t){return this._next(t)}},SMALLEST_DENORM:Math.pow(2,-1074),UINT_MAX:-1>>>0,nextafter:function(t,e){var i,s;return isNaN(t)||isNaN(e)?NaN:t===e?t:0===t?e<0?-this.SMALLEST_DENORM:this.SMALLEST_DENORM:(s=n.hi(t),i=n.lo(t),e>t==t>0?i===this.UINT_MAX?(s+=1,i=0):i+=1:0===i?(i=this.UINT_MAX,s-=1):i-=1,n.pack(i,s))}},s.A.Math.IntervalArithmetic.PI=new a(r.A.IntervalArithmetic.piLow,r.A.IntervalArithmetic.piHigh),s.A.Math.IntervalArithmetic.PI_HALF=new a(r.A.IntervalArithmetic.piHalfLow,r.A.IntervalArithmetic.piHalfHigh),s.A.Math.IntervalArithmetic.PI_TWICE=new a(r.A.IntervalArithmetic.piTwiceLow,r.A.IntervalArithmetic.piTwiceHigh),s.A.Math.IntervalArithmetic.ZERO=new a(0),s.A.Math.IntervalArithmetic.ONE=new a(1),s.A.Math.IntervalArithmetic.WHOLE=(new a).setWhole(),s.A.Math.IntervalArithmetic.EMPTY=(new a).setEmpty(),e.A=s.A.Math.IntervalArithmetic},477:function(t,e,i){var s,r=i(443),o=i(188),n=function(t){var e,i;return t.memo||(e={},i=Array.prototype.join,t.memo=function(){var r=i.call(arguments);return e[r]!==s?e[r]:e[r]=t.apply(this,arguments)}),t.memo};r.A.Math={eps:1e-6,relDif:function(t,e){var i=Math.abs(t),s=Math.abs(e);return 0===(s=Math.max(i,s))?0:Math.abs(t-e)/s},mod:function(t,e){return t-Math.floor(t/e)*e},vector:function(t,e){var i,s;for(e=e||0,i=[],s=0;s<t;s++)i[s]=e;return i},matrix:function(t,e,i){var s,r,o;for(i=i||0,e=e||t,s=[],r=0;r<t;r++)for(s[r]=[],o=0;o<e;o++)s[r][o]=i;return s},identity:function(t,e){var i,r;for(e===s&&"number"!=typeof e&&(e=t),i=this.matrix(t,e),r=0;r<Math.min(t,e);r++)i[r][r]=1;return i},frustum:function(t,e,i,s,r,o){var n=this.matrix(4,4);return n[0][0]=2*r/(e-t),n[0][1]=0,n[0][2]=(e+t)/(e-t),n[0][3]=0,n[1][0]=0,n[1][1]=2*r/(s-i),n[1][2]=(s+i)/(s-i),n[1][3]=0,n[2][0]=0,n[2][1]=0,n[2][2]=-(o+r)/(o-r),n[2][3]=-o*r*2/(o-r),n[3][0]=0,n[3][1]=0,n[3][2]=-1,n[3][3]=0,n},projection:function(t,e,i,s){var r=i*Math.tan(t/2),o=r*e;return this.frustum(-o,o,-r,r,i,s)},matVecMult:function(t,e){var i,s,r,o=t.length,n=e.length,a=[];if(3===n)for(i=0;i<o;i++)a[i]=t[i][0]*e[0]+t[i][1]*e[1]+t[i][2]*e[2];else for(i=0;i<o;i++){for(s=0,r=0;r<n;r++)s+=t[i][r]*e[r];a[i]=s}return a},matMatMult:function(t,e){var i,s,r,o,n=t.length,a=n>0?e[0].length:0,l=e.length,h=this.matrix(n,a);for(i=0;i<n;i++)for(s=0;s<a;s++){for(r=0,o=0;o<l;o++)r+=t[i][o]*e[o][s];h[i][s]=r}return h},transpose:function(t){var e,i,s,r,o;for(r=t.length,o=t.length>0?t[0].length:0,e=this.matrix(o,r),i=0;i<o;i++)for(s=0;s<r;s++)e[i][s]=t[s][i];return e},inverse:function(t){var e,i,s,r,o,n,a,l=t.length,h=[],u=[],c=[];for(e=0;e<l;e++){for(h[e]=[],i=0;i<l;i++)h[e][i]=t[e][i];u[e]=e}for(i=0;i<l;i++){for(o=Math.abs(h[i][i]),n=i,e=i+1;e<l;e++)Math.abs(h[e][i])>o&&(o=Math.abs(h[e][i]),n=e);if(o<=this.eps)return[];if(n>i){for(s=0;s<l;s++)a=h[i][s],h[i][s]=h[n][s],h[n][s]=a;a=u[i],u[i]=u[n],u[n]=a}for(r=1/h[i][i],e=0;e<l;e++)h[e][i]*=r;for(h[i][i]=r,s=0;s<l;s++)if(s!==i){for(e=0;e<l;e++)e!==i&&(h[e][s]-=h[e][i]*h[i][s]);h[i][s]=-r*h[i][s]}}for(e=0;e<l;e++){for(s=0;s<l;s++)c[u[s]]=h[e][s];for(s=0;s<l;s++)h[e][s]=c[s]}return h},innerProduct:function(t,e,i){var r,n=0;for(i!==s&&o.A.isNumber(i)||(i=t.length),r=0;r<i;r++)n+=t[r]*e[r];return n},crossProduct:function(t,e){return[t[1]*e[2]-t[2]*e[1],t[2]*e[0]-t[0]*e[2],t[0]*e[1]-t[1]*e[0]]},norm:function(t,e){var i,r=0;for(e!==s&&o.A.isNumber(e)||(e=t.length),i=0;i<e;i++)r+=t[i]*t[i];return Math.sqrt(r)},axpy:function(t,e,i){var s,r=e.length,o=[];for(s=0;s<r;s++)o[s]=t*e[s]+i[s];return o},factorial:n((function(t){return t<0?NaN:0===(t=Math.floor(t))||1===t?1:t*this.factorial(t-1)})),binomial:n((function(t,e){var i,s;if(e>t||e<0)return NaN;if(e=Math.round(e),t=Math.round(t),0===e||e===t)return 1;for(i=1,s=0;s<e;s++)i*=t-s,i/=s+1;return i})),cosh:Math.cosh||function(t){return.5*(Math.exp(t)+Math.exp(-t))},sinh:Math.sinh||function(t){return.5*(Math.exp(t)-Math.exp(-t))},acosh:Math.acosh||function(t){return Math.log(t+Math.sqrt(t*t-1))},asinh:Math.asinh||function(t){return t===-1/0?t:Math.log(t+Math.sqrt(t*t+1))},cot:function(t){return 1/Math.tan(t)},acot:function(t){return(t>=0?.5:-.5)*Math.PI-Math.atan(t)},nthroot:function(t,e){var i=1/e;return e<=0||Math.floor(e)!==e?NaN:0===t?0:t>0?Math.exp(i*Math.log(t)):e%2==1?-Math.exp(i*Math.log(-t)):NaN},cbrt:Math.cbrt||function(t){return this.nthroot(t,3)},pow:function(t,e){return 0===t?0===e?1:0:Math.floor(e)===e?Math.pow(t,e):t>0?Math.exp(e*Math.log(t)):NaN},ratpow:function(t,e,i){var s;return 0===e?1:0===i?NaN:(s=this.gcd(e,i),this.nthroot(this.pow(t,e/s),i/s))},log10:function(t){return Math.log(t)/Math.log(10)},log2:function(t){return Math.log(t)/Math.log(2)},log:function(t,e){return void 0!==e&&o.A.isNumber(e)?Math.log(t)/Math.log(e):Math.log(t)},sign:Math.sign||function(t){return 0===(t=+t)||isNaN(t)?t:t>0?1:-1},squampow:function(t,e){var i;if(Math.floor(e)===e){for(i=1,e<0&&(t=1/t,e*=-1);0!==e;)1&e&&(i*=t),e>>=1,t*=t;return i}return this.pow(t,e)},gcd:function(t,e){var i;if(t=Math.abs(t),e=Math.abs(e),!o.A.isNumber(t)||!o.A.isNumber(e))return NaN;for(e>t&&(i=t,t=e,e=i);;){if(0===(t%=e))return e;if(0===(e%=t))return t}},lcm:function(t,e){var i;return o.A.isNumber(t)&&o.A.isNumber(e)?0!==(i=t*e)?i/this.gcd(t,e):0:NaN},roundToStep:function(t,e,i,s){var n,a,l=t;if(!o.A.exists(e)&&!o.A.exists(i)&&!o.A.exists(s))return l;if(r.A.exists(s)&&(l=Math.min(l,s)),r.A.exists(i)&&(l=Math.max(l,i)),a=i||0,r.A.exists(e)){if(n=(l-a)/e,Number.isInteger(n))return l;l=a+(n=Math.round(n))*e}return r.A.exists(s)&&(l=Math.min(l,s)),r.A.exists(i)&&(l=Math.max(l,i)),l},erf:function(t){return this.ProbFuncs.erf(t)},erfc:function(t){return this.ProbFuncs.erfc(t)},erfi:function(t){return this.ProbFuncs.erfi(t)},ndtr:function(t){return this.ProbFuncs.ndtr(t)},ndtri:function(t){return this.ProbFuncs.ndtri(t)},hypot:function(){var t,e,i,s;for(e=arguments.length,t=0,s=0;t<e;t++)s+=(i=arguments[t])*i;return Math.sqrt(s)},hstep:function(t){return t>0?1:t<0?0:.5},gamma:function(t){var e,i,s,r,o,n=[1,676.5203681218851,-1259.1392167224028,771.3234287776531,-176.6150291621406,12.507343278686905,-.13857109526572012,9984369578019572e-21,1.5056327351493116e-7];if(t<.5)i=Math.PI/(Math.sin(Math.PI*t)*this.gamma(1-t));else{for(t-=1,e=n[0],o=n.length,r=1;r<o;r++)e+=n[r]/(t+r);s=t+7+.5,i=Math.sqrt(2*Math.PI)*Math.pow(s,t+.5)*Math.exp(-s)*e}return i},lt:function(t,e){return t<e},leq:function(t,e){return t<=e},gt:function(t,e){return t>e},geq:function(t,e){return t>=e},eq:function(t,e){return t===e},neq:function(t,e){return t!==e},and:function(t,e){return t&&e},not:function(t){return!t},or:function(t,e){return t||e},xor:function(t,e){return(t||e)&&!(t&&e)},decToFraction:function(t,e){var i,s,r,n,a,l,h,u,c,d=0;for(e=o.A.def(e,.001),s=(t=1e-12*Math.round(1e12*t))<0?-1:1,t=Math.abs(t),i=Math.floor(t),t-=Math.floor(t),l=1,n=a=r=0,c=0,h=u=1;t-Math.floor(t)>e&&d<20;)t=1/(t-r),n=l+(r=Math.floor(t))*a,h=c+r*u,l=a,c=u,a=n,u=h,d++;return[s,i,n,h]},normalize:function(t){var e,i,s=2*t[3],r=t[4]/s;return t[5]=r,t[6]=-t[1]/s,t[7]=-t[2]/s,isFinite(r)?Math.abs(r)>=1?(t[0]=(t[6]*t[6]+t[7]*t[7]-r*r)/(2*r),t[1]=-t[6]/r,t[2]=-t[7]/r,t[3]=1/(2*r),t[4]=1):(i=r<=0?-1:1,t[0]=i*(t[6]*t[6]+t[7]*t[7]-r*r)*.5,t[1]=-i*t[6],t[2]=-i*t[7],t[3]=i/2,t[4]=i*r):(e=this.hypot(t[1],t[2]),t[0]/=e,t[1]/=e,t[2]/=e,t[3]=0,t[4]=1),t},toGL:function(t){var e,i,s;if(e="function"==typeof Float32Array?new Float32Array(16):new Array(16),4!==t.length&&4!==t[0].length)return e;for(i=0;i<4;i++)for(s=0;s<4;s++)e[i+4*s]=t[i][s];return e},Vieta:function(t){var e,i,s,r=t.length,o=[];for(o=t.slice(),e=1;e<r;++e){for(s=o[e],o[e]*=o[e-1],i=e-1;i>=1;--i)o[i]+=o[i-1]*s;o[0]+=s}return o}},e.A=r.A.Math},171:function(t,e,i){var s=i(443),r=i(188),o=i(133),n=i(477),a={rk4:{s:4,A:[[0,0,0,0],[.5,0,0,0],[0,.5,0,0],[0,0,1,0]],b:[1/6,1/3,1/3,1/6],c:[0,.5,.5,1]},heun:{s:2,A:[[0,0],[1,0]],b:[.5,.5],c:[0,1]},euler:{s:1,A:[[0]],b:[1],c:[0]}};n.A.Numerics={Gauss:function(t,e){var i,s,o,a,l,h=n.A.eps,u=t.length>0?t[0].length:0;if(u!==e.length||u!==t.length)throw new Error("JXG.Math.Numerics.Gauss: Dimensions don't match. A must be a square matrix and b must be of the same length as A.");for(a=[],l=e.slice(0,u),i=0;i<u;i++)a[i]=t[i].slice(0,u);for(s=0;s<u;s++){for(i=u-1;i>s;i--)if(Math.abs(a[i][s])>h)if(Math.abs(a[s][s])<h)r.A.swap(a,i,s),r.A.swap(l,i,s);else for(a[i][s]/=a[s][s],l[i]-=a[i][s]*l[s],o=s+1;o<u;o++)a[i][o]-=a[i][s]*a[s][o];if(Math.abs(a[s][s])<h)throw new Error("JXG.Math.Numerics.Gauss(): The given matrix seems to be singular.")}return this.backwardSolve(a,l,!0),l},backwardSolve:function(t,e,i){var s,r,o,n,a;for(s=i?e:e.slice(0,e.length),r=t.length,o=t.length>0?t[0].length:0,n=r-1;n>=0;n--){for(a=o-1;a>n;a--)s[n]-=t[n][a]*s[a];s[n]/=t[n][n]}return s},gaussBareiss:function(t){var e,i,s,r,o,a,l,h,u,c=n.A.eps;if((l=t.length)<=0)return 0;for(t[0].length<l&&(l=t[0].length),h=[],r=0;r<l;r++)h[r]=t[r].slice(0,l);for(i=1,s=1,e=0;e<l-1;e++){if(a=h[e][e],Math.abs(a)<c){for(r=e+1;r<l&&!(Math.abs(h[r][e])>=c);r++);if(r===l)return 0;for(o=e;o<l;o++)u=h[r][o],h[r][o]=h[e][o],h[e][o]=u;s=-s,a=h[e][e]}for(r=e+1;r<l;r++)for(o=e+1;o<l;o++)u=a*h[r][o]-h[r][e]*h[e][o],h[r][o]=u/i;i=a}return s*h[l-1][l-1]},det:function(t){return 2===t.length&&2===t[0].length?t[0][0]*t[1][1]-t[1][0]*t[0][1]:this.gaussBareiss(t)},Jacobi:function(t){var e,i,s,r,o,a,l,h,u,c=n.A.eps*n.A.eps,d=0,p=t.length,_=[[0,0,0],[0,0,0],[0,0,0]],f=[[0,0,0],[0,0,0],[0,0,0]],A=0;for(e=0;e<p;e++){for(i=0;i<p;i++)_[e][i]=0,f[e][i]=t[e][i],d+=Math.abs(f[e][i]);_[e][e]=1}if(1===p)return[f,_];if(d<=0)return[f,_];d/=p*p;do{for(h=0,u=0,i=1;i<p;i++)for(e=0;e<i;e++)if((r=Math.abs(f[e][i]))>u&&(u=r),h+=r,r>=c){for(r=.5*Math.atan2(2*f[e][i],f[e][e]-f[i][i]),o=Math.sin(r),a=Math.cos(r),s=0;s<p;s++)l=f[s][e],f[s][e]=a*l+o*f[s][i],f[s][i]=-o*l+a*f[s][i],l=_[s][e],_[s][e]=a*l+o*_[s][i],_[s][i]=-o*l+a*_[s][i];for(f[e][e]=a*f[e][e]+o*f[i][e],f[i][i]=-o*f[e][i]+a*f[i][i],f[e][i]=0,s=0;s<p;s++)f[e][s]=f[s][e],f[i][s]=f[s][i]}A+=1}while(Math.abs(h)/d>c&&A<2e3);return[f,_]},NewtonCotes:function(t,e,i){var s,o,n,a=0,l=i&&r.A.isNumber(i.number_of_nodes)?i.number_of_nodes:28,h={trapez:!0,simpson:!0,milne:!0},u=i&&i.integration_type&&h.hasOwnProperty(i.integration_type)&&h[i.integration_type]?i.integration_type:"milne",c=(t[1]-t[0])/l;switch(u){case"trapez":for(a=.5*(e(t[0])+e(t[1])),s=t[0],o=0;o<l-1;o++)a+=e(s+=c);a*=c;break;case"simpson":if(l%2>0)throw new Error("JSXGraph:  INT_SIMPSON requires config.number_of_nodes dividable by 2.");for(n=l/2,a=e(t[0])+e(t[1]),s=t[0],o=0;o<n-1;o++)a+=2*e(s+=2*c);for(s=t[0]-c,o=0;o<n;o++)a+=4*e(s+=2*c);a*=c/3;break;default:if(l%4>0)throw new Error("JSXGraph: Error in INT_MILNE: config.number_of_nodes must be a multiple of 4");for(n=.25*l,a=7*(e(t[0])+e(t[1])),s=t[0],o=0;o<n-1;o++)a+=14*e(s+=4*c);for(s=t[0]-3*c,o=0;o<n;o++)a+=32*(e(s+=4*c)+e(s+2*c));for(s=t[0]-2*c,o=0;o<n;o++)a+=12*e(s+=4*c);a*=2*c/45}return a},Romberg:function(t,e,i){var s,o,n,a,l,h,u,c,d=[],p=0,_=1/0,f=i&&r.A.isNumber(i.max_iterations)?i.max_iterations:20,A=i&&r.A.isNumber(i.eps)?i.eps:i.eps||1e-7;for(s=t[0],n=(o=t[1])-s,l=1,d[0]=.5*n*(e(s)+e(o)),h=0;h<f;++h){for(a=0,n*=.5,l*=2,c=1,u=1;u<l;u+=2)a+=e(s+u*n);for(d[h+1]=.5*d[h]+a*n,p=d[h+1],u=h-1;u>=0;--u)c*=4,d[u]=d[u+1]+(d[u+1]-d[u])/(c-1),p=d[u];if(Math.abs(p-_)<A*Math.abs(p))break;_=p}return p},GaussLegendre:function(t,e,i){var s,o,n,a,l,h,u,c,d=0,p=[],_=[],f=i&&r.A.isNumber(i.n)?i.n:12;if(f>18&&(f=18),p[2]=[.5773502691896257],_[2]=[1],p[4]=[.33998104358485626,.8611363115940526],_[4]=[.6521451548625461,.34785484513745385],p[6]=[.2386191860831969,.6612093864662645,.932469514203152],_[6]=[.46791393457269104,.3607615730481386,.17132449237917036],p[8]=[.1834346424956498,.525532409916329,.7966664774136267,.9602898564975363],_[8]=[.362683783378362,.31370664587788727,.22238103445337448,.10122853629037626],p[10]=[.14887433898163122,.4333953941292472,.6794095682990244,.8650633666889845,.9739065285171717],_[10]=[.29552422471475287,.26926671930999635,.21908636251598204,.1494513491505806,.06667134430868814],p[12]=[.1252334085114689,.3678314989981802,.5873179542866175,.7699026741943047,.9041172563704749,.9815606342467192],_[12]=[.24914704581340277,.2334925365383548,.20316742672306592,.16007832854334622,.10693932599531843,.04717533638651183],p[14]=[.10805494870734367,.31911236892788974,.5152486363581541,.6872929048116855,.827201315069765,.9284348836635735,.9862838086968123],_[14]=[.2152638534631578,.2051984637212956,.18553839747793782,.15720316715819355,.12151857068790319,.08015808715976021,.03511946033175186],p[16]=[.09501250983763744,.2816035507792589,.45801677765722737,.6178762444026438,.755404408355003,.8656312023878318,.9445750230732326,.9894009349916499],_[16]=[.1894506104550685,.18260341504492358,.16915651939500254,.14959598881657674,.12462897125553388,.09515851168249279,.062253523938647894,.027152459411754096],p[18]=[.0847750130417353,.2518862256915055,.41175116146284263,.5597708310739475,.6916870430603532,.8037049589725231,.8926024664975557,.9558239495713977,.9915651684209309],_[18]=[.1691423829631436,.16427648374583273,.15468467512626524,.14064291467065065,.12255520671147846,.10094204410628717,.07642573025488905,.0497145488949698,.02161601352648331],p[3]=[0,.7745966692414834],_[3]=[.8888888888888888,.5555555555555556],p[5]=[0,.5384693101056831,.906179845938664],_[5]=[.5688888888888889,.47862867049936647,.23692688505618908],p[7]=[0,.4058451513773972,.7415311855993945,.9491079123427585],_[7]=[.4179591836734694,.3818300505051189,.27970539148927664,.1294849661688697],p[9]=[0,.3242534234038089,.6133714327005904,.8360311073266358,.9681602395076261],_[9]=[.3302393550012598,.31234707704000286,.26061069640293544,.1806481606948574,.08127438836157441],p[11]=[0,.26954315595234496,.5190961292068118,.7301520055740494,.8870625997680953,.978228658146057],_[11]=[.2729250867779006,.26280454451024665,.23319376459199048,.18629021092773426,.1255803694649046,.05566856711617366],p[13]=[0,.2304583159551348,.44849275103644687,.6423493394403402,.8015780907333099,.9175983992229779,.9841830547185881],_[13]=[.2325515532308739,.22628318026289723,.2078160475368885,.17814598076194574,.13887351021978725,.09212149983772845,.04048400476531588],p[15]=[0,.20119409399743451,.3941513470775634,.5709721726085388,.7244177313601701,.8482065834104272,.937273392400706,.9879925180204854],_[15]=[.2025782419255613,.19843148532711158,.1861610000155622,.16626920581699392,.13957067792615432,.10715922046717194,.07036604748810812,.03075324199611727],p[17]=[0,.17848418149584785,.3512317634538763,.5126905370864769,.6576711592166907,.7815140038968014,.8802391537269859,.9506755217687678,.9905754753144174],_[17]=[.17944647035620653,.17656270536699264,.16800410215645004,.15404576107681028,.13513636846852548,.11188384719340397,.08503614831717918,.0554595293739872,.02414830286854793],s=t[0],o=t[1],a=f+1>>1,u=p[f],c=_[f],h=.5*(o-s),l=.5*(o+s),!0&f)for(d=c[0]*e(l),n=1;n<a;++n)d+=c[n]*(e(l+h*u[n])+e(l-h*u[n]));else for(d=0,n=0;n<a;++n)d+=c[n]*(e(l+h*u[n])+e(l-h*u[n]));return h*d},_rescale_error:function(t,e,i){var s,r,o=2220446049250313e-31;return t=Math.abs(t),0!==i&&0!==t&&(t=(s=Math.pow(200*t/i,1.5))<1?i*s:i),e>20041683600089728e-310&&(r=50*o*e)>t&&(t=r),t},_gaussKronrod:function(t,e,i,s,r,o,n){var a,l,h,u,c,d,p,_,f,A,g,m=t[0],y=t[1],b=.5*(m+y),v=.5*(y-m),C=Math.abs(v),P=e(b),x=0,E=P*o[i-1],O=Math.abs(E),S=0,M=[],w=[];for(i%2==0&&(x=P*r[i/2-1]),a=Math.floor((i-1)/2),c=0;c<a;c++)A=(_=e(b-(p=v*s[d=2*c+1])))+(f=e(b+p)),M[d]=_,w[d]=f,x+=r[c]*A,E+=o[d]*A,O+=o[d]*(Math.abs(_)+Math.abs(f));for(a=Math.floor(i/2),c=0;c<a;c++)_=e(b-(p=v*s[g=2*c])),f=e(b+p),M[g]=_,w[g]=f,E+=o[g]*(_+f),O+=o[g]*(Math.abs(_)+Math.abs(f));for(h=.5*E,S=o[i-1]*Math.abs(P-h),c=0;c<i-1;c++)S+=o[c]*(Math.abs(M[c]-h)+Math.abs(w[c]-h));return u=(E-x)*v,O*=C,S*=C,l=E*=v,n.abserr=this._rescale_error(u,O,S),n.resabs=O,n.resasc=S,l},GaussKronrod15:function(t,e,i){return this._gaussKronrod(t,e,8,[.9914553711208126,.9491079123427585,.8648644233597691,.7415311855993945,.5860872354676911,.4058451513773972,.20778495500789848,0],[.1294849661688697,.27970539148927664,.3818300505051189,.4179591836734694],[.022935322010529224,.06309209262997856,.10479001032225019,.14065325971552592,.1690047266392679,.19035057806478542,.20443294007529889,.20948214108472782],i)},GaussKronrod21:function(t,e,i){return this._gaussKronrod(t,e,11,[.9956571630258081,.9739065285171717,.9301574913557082,.8650633666889845,.7808177265864169,.6794095682990244,.5627571346686047,.4333953941292472,.2943928627014602,.14887433898163122,0],[.06667134430868814,.1494513491505806,.21908636251598204,.26926671930999635,.29552422471475287],[.011694638867371874,.032558162307964725,.054755896574351995,.07503967481091996,.0931254545836976,.10938715880229764,.12349197626206584,.13470921731147334,.14277593857706009,.14773910490133849,.1494455540029169],i)},GaussKronrod31:function(t,e,i){return this._gaussKronrod(t,e,16,[.9980022986933971,.9879925180204854,.9677390756791391,.937273392400706,.8972645323440819,.8482065834104272,.790418501442466,.7244177313601701,.650996741297417,.5709721726085388,.4850818636402397,.3941513470775634,.29918000715316884,.20119409399743451,.1011420669187175,0],[.03075324199611727,.07036604748810812,.10715922046717194,.13957067792615432,.16626920581699392,.1861610000155622,.19843148532711158,.2025782419255613],[.005377479872923349,.015007947329316122,.02546084732671532,.03534636079137585,.04458975132476488,.05348152469092809,.06200956780067064,.06985412131872826,.07684968075772038,.08308050282313302,.08856444305621176,.09312659817082532,.09664272698362368,.09917359872179196,.10076984552387559,.10133000701479154],i)},_workspace:function(t,e){return{limit:e,size:0,nrmax:0,i:0,alist:[t[0]],blist:[t[1]],rlist:[0],elist:[0],order:[0],level:[0],qpsrt:function(){var t,e,i,s,r,o=this.size-1,n=this.limit,a=this.nrmax,l=this.order[a];if(o<2)return this.order[0]=0,this.order[1]=1,void(this.i=l);for(t=this.elist[l];a>0&&t>this.elist[this.order[a-1]];)this.order[a]=this.order[a-1],a--;for(r=o<n/2+2?o:n-o+1,i=a+1;i<r&&t<this.elist[this.order[i]];)this.order[i-1]=this.order[i],i++;for(this.order[i-1]=l,e=this.elist[o],s=r-1;s>i-2&&e>=this.elist[this.order[s]];)this.order[s+1]=this.order[s],s--;this.order[s+1]=o,l=this.order[a],this.i=l,this.nrmax=a},set_initial_result:function(t,e){this.size=1,this.rlist[0]=t,this.elist[0]=e},update:function(t,e,i,s,r,o,n,a){var l=this.i,h=this.size,u=this.level[this.i]+1;a>s?(this.alist[l]=r,this.rlist[l]=n,this.elist[l]=a,this.level[l]=u,this.alist[h]=t,this.blist[h]=e,this.rlist[h]=i,this.elist[h]=s,this.level[h]=u):(this.blist[l]=e,this.rlist[l]=i,this.elist[l]=s,this.level[l]=u,this.alist[h]=r,this.blist[h]=o,this.rlist[h]=n,this.elist[h]=a,this.level[h]=u),this.size++,u>this.maximum_level&&(this.maximum_level=u),this.qpsrt()},retrieve:function(){var t=this.i;return{a:this.alist[t],b:this.blist[t],r:this.rlist[t],e:this.elist[t]}},sum_results:function(){var t,e=this.size,i=0;for(t=0;t<e;t++)i+=this.rlist[t];return i},subinterval_too_small:function(t,e,i){var s=1.0000000000000222*(Math.abs(e)+22250738585072014e-321);return Math.abs(t)<=s&&Math.abs(i)<=s}}},Qag:function(t,e,i){var o,a,l,h,u,c,d,p,_,f,A,g,m,y,b,v,C,P,x=this._workspace(t,1e3),E=i&&r.A.isNumber(i.limit)?i.limit:15,O=i&&r.A.isNumber(i.epsrel)?i.epsrel:1e-7,S=i&&r.A.isNumber(i.epsabs)?i.epsabs:1e-7,M=i&&r.A.isFunction(i.q)?i.q:this.GaussKronrod15,w={},T=0,N=0,j=0,D=0,k=0,R=0,L=0,B=0,I=0,Y=0;if(E>x.limit&&s.A.warn("iteration limit exceeds available workspace"),S<=0&&(O<50*n.A.eps||O<5e-29)&&s.A.warn("tolerance cannot be acheived with given epsabs and epsrel"),l=M.apply(this,[t,e,w]),h=w.abserr,u=w.resabs,c=w.resasc,x.set_initial_result(l,h),d=Math.max(S,O*Math.abs(l)),h<=11102230246251565e-30*u&&h>d)return s.A.warn("cannot reach tolerance because of roundoff error on first attempt"),-1/0;if(h<=d&&h!==c||0===h)return l;if(1===E)return s.A.warn("a maximum of one iteration was insufficient"),-1/0;o=l,a=h,T=1;do{k=0,R=0,L=0,B=0,I=0,Y=0,g=(C=x.retrieve()).a,m=C.b,y=C.r,b=C.e,p=g,f=_=.5*(g+m),A=m,k=M.apply(this,[[p,_],e,w]),B=w.abserr,v=w.resasc,R=M.apply(this,[[f,A],e,w]),a+=(Y=B+(I=w.abserr))-b,o+=(L=k+R)-y,v!==B&&w.resasc!==I&&(P=y-L,Math.abs(P)<=1e-5*Math.abs(L)&&Y>=.99*b&&N++,T>=10&&Y>b&&j++),a>(d=Math.max(S,O*Math.abs(o)))&&((N>=6||j>=20)&&(D=2),x.subinterval_too_small(p,f,A)&&(D=3)),x.update(p,_,k,B,f,A,R,I),g=(C=x.retrieve()).a_i,m=C.b_i,y=C.r_i,b=C.e_i,T++}while(T<E&&!D&&a>d);return x.sum_results()},I:function(t,e){return this.Qag(t,e,{q:this.GaussKronrod15,limit:15,epsrel:1e-7,epsabs:1e-7})},Newton:function(t,e,i){var s,o=0,a=n.A.eps,l=t.apply(i,[e]);for(r.A.isArray(e)&&(e=e[0]);o<50&&Math.abs(l)>a;)s=this.D(t,i)(e),Math.abs(s)>a?e-=l/s:e+=.2*Math.random()-1,l=t.apply(i,[e]),o+=1;return e},root:function(t,e,i){return this.chandrupatla(t,e,i)},generalizedNewton:function(t,e,i,s){var r,o,a,l,h,u,c,d,p,_,f,A,g,m,y=0;for(this.generalizedNewton.t1memo?(r=this.generalizedNewton.t1memo,o=this.generalizedNewton.t2memo):(r=i,o=s),_=(d=t.X(r)-e.X(o))*d+(p=t.Y(r)-e.Y(o))*p,f=this.D(t.X,t),A=this.D(e.X,e),g=this.D(t.Y,t),m=this.D(e.Y,e);_>n.A.eps&&y<10;)a=f(r),l=-A(o),h=g(r),r-=((u=-m(o))*d-l*p)/(c=a*u-l*h),o-=(a*p-h*d)/c,_=(d=t.X(r)-e.X(o))*d+(p=t.Y(r)-e.Y(o))*p,y+=1;return this.generalizedNewton.t1memo=r,this.generalizedNewton.t2memo=o,Math.abs(r)<Math.abs(o)?[t.X(r),t.Y(r)]:[e.X(o),e.Y(o)]},Neville:function(t){var e=[],i=function(i){return function(s,r){var o,a,l,h=n.A.binomial,u=t.length,c=u-1,d=0,p=0;if(!r)for(l=1,o=0;o<u;o++)e[o]=h(c,o)*l,l*=-1;for(a=s,o=0;o<u;o++){if(0===a)return t[o][i]();l=e[o]/a,a-=1,d+=t[o][i]()*l,p+=l}return d/p}};return[i("X"),i("Y"),0,function(){return t.length-1}]},splineDef:function(t,e){var i,s,r,o=Math.min(t.length,e.length),n=[],a=[],l=[],h=[],u=[],c=[];if(2===o)return[0,0];for(s=0;s<o;s++)i={X:t[s],Y:e[s]},l.push(i);for(l.sort((function(t,e){return t.X-e.X})),s=0;s<o;s++)t[s]=l[s].X,e[s]=l[s].Y;for(s=0;s<o-1;s++)h.push(t[s+1]-t[s]);for(s=0;s<o-2;s++)u.push(6*(e[s+2]-e[s+1])/h[s+1]-6*(e[s+1]-e[s])/h[s]);for(n.push(2*(h[0]+h[1])),a.push(u[0]),s=0;s<o-3;s++)r=h[s+1]/n[s],n.push(2*(h[s+1]+h[s+2])-r*h[s+1]),a.push(u[s+1]-r*a[s]);for(c[o-3]=a[o-3]/n[o-3],s=o-4;s>=0;s--)c[s]=(a[s]-h[s+1]*c[s+1])/n[s];for(s=o-3;s>=0;s--)c[s+1]=c[s];return c[0]=0,c[o-1]=0,c},splineEval:function(t,e,i,s){var o,n,a,l,h,u,c,d=Math.min(e.length,i.length),p=1,_=!1,f=[];for(r.A.isArray(t)?(p=t.length,_=!0):t=[t],o=0;o<p;o++){if(t[o]<e[0]||e[o]>e[d-1])return NaN;for(n=1;n<d&&!(t[o]<=e[n]);n++);a=i[n-=1],l=(i[n+1]-i[n])/(e[n+1]-e[n])-(e[n+1]-e[n])/6*(s[n+1]+2*s[n]),h=s[n]/2,u=(s[n+1]-s[n])/(6*(e[n+1]-e[n])),c=t[o]-e[n],f.push(a+(l+(h+u*c)*c)*c)}return _?f:f[0]},generatePolynomialTerm:function(t,e,i,s){var o,n=[];for(o=e;o>=0;o--)r.A.concat(n,["(",t[o].toPrecision(s),")"]),o>1?r.A.concat(n,["*",i,"<sup>",o,"<","/sup> + "]):1===o&&r.A.concat(n,["*",i," + "]);return n.join("")},lagrangePolynomial:function(t){var e=[],i=this,s=function(i,s){var r,o,n,a,l=t.length,h=0,u=0;if(!s)for(r=0;r<l;r++){for(e[r]=1,n=t[r].X(),o=0;o<l;o++)o!==r&&(e[r]*=n-t[o].X());e[r]=1/e[r]}for(r=0;r<l;r++){if(i===(n=t[r].X()))return t[r].Y();u+=a=e[r]/(i-n),h+=a*t[r].Y()}return h/u};return s.getTerm=function(e,s,r){return i.lagrangePolynomialTerm(t,e,s,r)()},s.getCoefficients=function(){return i.lagrangePolynomialCoefficients(t)()},s},lagrangePolynomialTerm:function(t,e,i,r){var a=this;return function(){var l,h,u,c,d,p=t.length,_=!0;for(i=i||"x",void 0===r&&(r=" * "),h=p-1,l=a.lagrangePolynomialCoefficients(t)(),u="",c=0;c<l.length;c++)d=l[c],Math.abs(d)<n.A.eps||(s.A.exists(e)&&(d=o.A._round10(d,-e)),_?(u+=d>0?d:"-"+-d,_=!1):u+=d>0?" + "+d:" - "+-d,h-c>1?u+=r+i+"^"+(h-c):h-c==1&&(u+=r+i));return u}},lagrangePolynomialCoefficients:function(t){return function(){var e,i,s,r,o=t.length,a=[],l=[],h=[];for(i=0;i<o;i++)h[i]=0;for(e=0;e<o;e++){for(s=t[e].Y(),r=t[e].X(),a=[],i=0;i<o;i++)i!==e&&(s/=r-t[i].X(),a.push(t[i].X()));for(l=[1].concat(n.A.Vieta(a)),i=0;i<l.length;i++)h[i]+=(i%2==1?-1:1)*l[i]*s}return h}},_initCubicPoly:function(t,e,i,s){return[t,i,-3*t+3*e-2*i-s,2*t-2*e+i+s]},CardinalSpline:function(t,e,i){var s,o,a,l,h=[],u=this;return l=r.A.isFunction(e)?e:function(){return e},void 0===i&&(i="uniform"),o=function(e){return function(r,o){var c,d,p,_,f,A,g,m,y,b;if(t.length<2)return NaN;if(!o)for(a=l(),p={X:function(){return 2*t[0].X()-t[1].X()},Y:function(){return 2*t[0].Y()-t[1].Y()},Dist:function(t){var e=this.X()-t.X(),i=this.Y()-t.Y();return n.A.hypot(e,i)}},_={X:function(){return 2*t[t.length-1].X()-t[t.length-2].X()},Y:function(){return 2*t[t.length-1].Y()-t[t.length-2].Y()},Dist:function(t){var e=this.X()-t.X(),i=this.Y()-t.Y();return n.A.hypot(e,i)}},b=(s=[p].concat(t,[_])).length,h[e]=[],c=0;c<b-3;c++)"centripetal"===i?(g=s[c].Dist(s[c+1]),m=s[c+2].Dist(s[c+1]),y=s[c+3].Dist(s[c+2]),g=Math.sqrt(g),m=Math.sqrt(m),y=Math.sqrt(y),m<n.A.eps&&(m=1),g<n.A.eps&&(g=m),y<n.A.eps&&(y=m),f=(s[c+1][e]()-s[c][e]())/g-(s[c+2][e]()-s[c][e]())/(m+g)+(s[c+2][e]()-s[c+1][e]())/m,A=(s[c+2][e]()-s[c+1][e]())/m-(s[c+3][e]()-s[c+1][e]())/(y+m)+(s[c+3][e]()-s[c+2][e]())/y,f*=m,A*=m,h[e][c]=u._initCubicPoly(s[c+1][e](),s[c+2][e](),a*f,a*A)):h[e][c]=u._initCubicPoly(s[c+1][e](),s[c+2][e](),a*(s[c+2][e]()-s[c][e]()),a*(s[c+3][e]()-s[c+1][e]()));return isNaN(r)?NaN:(b=t.length,r<=0?t[0][e]():r>=b?t[b-1][e]():(c=Math.floor(r))===r?t[c][e]():(r-=c,void 0===(d=h[e][c])?NaN:((d[3]*r+d[2])*r+d[1])*r+d[0]))}},[o("X"),o("Y"),0,function(){return t.length-1}]},CatmullRomSpline:function(t,e){return this.CardinalSpline(t,.5,e)},regressionPolynomial:function(t,e,i){var s,o,a,l,h,u,c="";if(r.A.isPoint(t)&&r.A.isFunction(t.Value))o=function(){return t.Value()};else if(r.A.isFunction(t))o=t;else{if(!r.A.isNumber(t))throw new Error("JSXGraph: Can't create regressionPolynomial from degree of type'"+typeof t+"'.");o=function(){return t}}if(3===arguments.length&&r.A.isArray(e)&&r.A.isArray(i))h=0;else if(2===arguments.length&&r.A.isArray(e)&&e.length>0&&r.A.isPoint(e[0]))h=1;else{if(!(2===arguments.length&&r.A.isArray(e)&&e.length>0&&e[0].usrCoords&&e[0].scrCoords))throw new Error("JSXGraph: Can't create regressionPolynomial. Wrong parameters.");h=2}return(u=function(t,u){var d,p,_,f,A,g,m,y,b,v=e.length;if(b=Math.floor(o()),!u){if(1===h)for(a=[],l=[],d=0;d<v;d++)a[d]=e[d].X(),l[d]=e[d].Y();if(2===h)for(a=[],l=[],d=0;d<v;d++)a[d]=e[d].usrCoords[1],l[d]=e[d].usrCoords[2];if(0===h)for(a=[],l=[],d=0;d<v;d++)r.A.isFunction(e[d])?a.push(e[d]()):a.push(e[d]),r.A.isFunction(i[d])?l.push(i[d]()):l.push(i[d]);for(_=[],p=0;p<v;p++)_.push([1]);for(d=1;d<=b;d++)for(p=0;p<v;p++)_[p][d]=_[p][d-1]*a[p];A=l,f=n.A.transpose(_),g=n.A.matMatMult(f,_),m=n.A.matVecMult(f,A),s=n.A.Numerics.Gauss(g,m),c=n.A.Numerics.generatePolynomialTerm(s,b,"x",3)}for(y=s[b],d=b-1;d>=0;d--)y=y*t+s[d];return y}).getTerm=function(){return c},u},bezier:function(t){var e,i,s=function(s){return function(r,o){var n=3*Math.floor(r),a=r%1,l=1-a;return o||(i=3*Math.floor((t.length-1)/3),e=Math.floor(i/3)),r<0?t[0][s]():r>=e?t[i][s]():isNaN(r)?NaN:l*l*(l*t[n][s]()+3*a*t[n+1][s]())+(3*l*t[n+2][s]()+a*t[n+3][s]())*a*a}};return[s("X"),s("Y"),0,function(){return Math.floor(t.length/3)}]},bspline:function(t,e){var i,s=function(s){return function(r,o){var n,a,l,h,u=t.length,c=u-1,d=e;if(c<=0)return NaN;if(c+2<=d&&(d=c+1),r<=0)return t[0][s]();if(r>=c-d+2)return t[c][s]();for(l=Math.floor(r)+d-1,i=function(t,e){var i,s=[];for(i=0;i<t+e+1;i++)s[i]=i<e?0:i<=t?i-e+1:t-e+2;return s}(c,d),h=function(t,e,i,s){var r,o,n,a,l,h=[];for(e[s]<=t&&t<e[s+1]?h[s]=1:h[s]=0,r=2;r<=i;r++)for(o=s-r+1;o<=s;o++)n=o<=s-r+1||o<0?0:h[o],a=o>=s?0:h[o+1],l=e[o+r-1]-e[o],h[o]=0===l?0:(t-e[o])/l*n,0!=(l=e[o+r]-e[o+1])&&(h[o]+=(e[o+r]-t)/l*a);return h}(r,i,d,l),n=0,a=l-d+1;a<=l;a++)a<u&&a>=0&&(n+=t[a][s]()*h[a]);return n}};return[s("X"),s("Y"),0,function(){return t.length-1}]},D:function(t,e){return r.A.exists(e)?function(i,s){var r=1e-5;return(t.apply(e,[i+r,s])-t.apply(e,[i-r,s]))/2e-5}:function(e,i){var s=1e-5;return(t(e+s,i)-t(e-s,i))/2e-5}},_riemannValue:function(t,e,i,s){var r,o,n,a;if(s<0&&("trapezoidal"!==i&&(t+=s),s*=-1,"lower"===i?i="upper":"upper"===i&&(i="lower")),a=.01*s,"right"===i)r=e(t+s);else if("middle"===i)r=e(t+.5*s);else if("left"===i||"trapezoidal"===i)r=e(t);else if("lower"===i){for(r=e(t),n=t+a;n<=t+s;n+=a)(o=e(n))<r&&(r=o);(o=e(t+s))<r&&(r=o)}else if("upper"===i){for(r=e(t),n=t+a;n<=t+s;n+=a)(o=e(n))>r&&(r=o);(o=e(t+s))>r&&(r=o)}else r="random"===i?e(t+s*Math.random()):"simpson"===i?(e(t)+4*e(t+.5*s)+e(t+s))/6:e(t);return r},riemann:function(t,e,i,s,o){var n,a,l,h,u,c,d,p,_,f,A,g,m,y,b=[],v=[],C=s,P=0;if(r.A.isArray(t)?(y=t[0],m=t[1]):m=t,(e=Math.floor(e))<=0)return[b,v,P];for(a=(o-s)/e,n=0;n<e;n++){if("simpson"===i){for(P+=this._riemannValue(C,m,i,a)*a,A=.5*a,d=m(C),p=m(C+A),h=((_=m(C+2*A))+d-2*p)/(A*A)*.5,u=(_-d)/(2*A),c=p,l=0;l<30;l++)f=l*a/30-A,b.push(C+f+A),v.push(h*f*f+u*f+c);C+=a,g=_}else g=this._riemannValue(C,m,i,a),b.push(C),v.push(g),C+=a,"trapezoidal"===i?(P+=.5*(g+(_=m(C)))*a,g=_):P+=g*a,b.push(C),v.push(g);b.push(C),v.push(g)}for(n=0;n<e;n++){if("simpson"===i&&y){for(P-=this._riemannValue(C,y,i,-a)*a,A=.5*a,d=y(C),p=y(C-A),h=((_=y(C-2*A))+d-2*p)/(A*A)*.5,u=(_-d)/(2*A),c=p,l=0;l<30;l++)f=l*a/30-A,b.push(C-f-A),v.push(h*f*f+u*f+c);C-=a,g=_}else g=y?this._riemannValue(C,y,i,-a):0,b.push(C),v.push(g),C-=a,y&&("trapezoidal"===i?(P-=.5*(g+(_=y(C)))*a,g=_):P-=g*a);b.push(C),v.push(g),b.push(C),v.push(m(C))}return[b,v,P]},riemannsum:function(t,e,i,r,o){return s.A.deprecated("Numerics.riemannsum()","Numerics.riemann()[2]"),this.riemann(t,e,i,r,o)[2]},rungeKutta:function(t,e,i,s,o){var n,l,h,u,c,d,p=[],_=[],f=(i[1]-i[0])/s,A=i[0],g=e.length,m=[],y=0;for(r.A.isString(t)&&(t=a[t]||a.euler),d=t.s,p=e.slice(),l=0;l<=s;l++){for(m[y]=p.slice(),y++,u=[],h=0;h<d;h++){for(n=0;n<g;n++)_[n]=0;for(c=0;c<h;c++)for(n=0;n<g;n++)_[n]+=t.A[h][c]*f*u[c][n];for(n=0;n<g;n++)_[n]+=p[n];u.push(o(A+t.c[h]*f,_))}for(n=0;n<g;n++)_[n]=0;for(c=0;c<d;c++)for(n=0;n<g;n++)_[n]+=t.b[c]*u[c][n];for(n=0;n<g;n++)p[n]=p[n]+f*_[n];A+=f}return m},maxIterationsRoot:80,maxIterationsMinimize:500,findBracket:function(t,e,i){var s,o,n,a,l,h,u,c,d,p;if(r.A.isArray(e))return e;for(s=e,n=t.call(i,s),p=(a=[s-.1*(o=0===s?1:s),s+.1*o,s-1,s+1,s-.5*o,s+.5*o,s-.6*o,s+.6*o,s-1*o,s+1*o,s-2*o,s+2*o,s-5*o,s+5*o,s-10*o,s+10*o,s-50*o,s+50*o,s-100*o,s+100*o]).length,d=0;d<p&&(l=a[d],!(n*(h=t.call(i,l))<=0));d++);return l<s&&(u=s,s=l,l=u,c=n,n=h,h=c),[s,n,l,h]},fzero:function(t,e,i){var s,o,a,l,h,u,c,d,p,_,f,A,g,m,y,b=n.A.eps,v=this.maxIterationsRoot,C=0;if(r.A.isArray(e)){if(e.length<2)throw new Error("JXG.Math.Numerics.fzero: length of array x0 has to be at least two.");s=e[0],l=t.call(i,s),o=e[1],h=t.call(i,o)}else s=(c=this.findBracket(t,e,i))[0],l=c[1],o=c[2],h=c[3];if(Math.abs(l)<=b)return s;if(Math.abs(h)<=b)return o;if(l*h>0)return r.A.isArray(e)?this.fminbr(t,[s,o],i):this.Newton(t,s,i);for(a=s,u=l;C<v;){if(d=o-s,Math.abs(u)<Math.abs(h)&&(s=o,o=a,a=s,l=h,h=u,u=l),A=2*b*Math.abs(o)+.5*b,y=.5*(a-o),Math.abs(y)<=A||Math.abs(h)<=b)return o;Math.abs(d)>=A&&Math.abs(l)>Math.abs(h)&&(f=a-o,s===a?(g=f*(p=h/l),m=1-p):(g=(_=h/l)*(f*(m=l/u)*(m-(p=h/u))-(o-s)*(p-1)),m=(m-1)*(p-1)*(_-1)),g>0?m=-m:g=-g,g<.75*f*m-.5*Math.abs(A*m)&&g<Math.abs(d*m*.5)&&(y=g/m)),Math.abs(y)<A&&(y=y>0?A:-A),s=o,l=h,o+=y,((h=t.call(i,o))>0&&u>0||h<0&&u<0)&&(a=s,u=l),C++}return o},chandrupatla:function(t,e,i){var s,o,a,l,h,u,c,d,p,_,f,A,g,m,y,b,v,C,P,x,E=0,O=this.maxIterationsRoot,S=1+.001*Math.random(),M=.5*S,w=n.A.eps;if(r.A.isArray(e)){if(e.length<2)throw new Error("JXG.Math.Numerics.fzero: length of array x0 has to be at least two.");s=e[0],a=t.call(i,s),o=e[1],l=t.call(i,o)}else s=(h=this.findBracket(t,e,i))[0],a=h[1],o=h[2],l=h[3];if(a*l>0)return r.A.isArray(e)?this.fminbr(t,[s,o],i):this.Newton(t,s,i);u=s,c=o,_=a,f=l;do{if(p=u+M*(c-u),g=t.call(i,p),Math.sign(g)===Math.sign(_)?(d=u,u=p,A=_,_=g):(d=c,c=u,A=f,f=_),m=u=p,y=_=g,Math.abs(f)<Math.abs(_)&&(m=c,y=f),(b=(2*w*Math.abs(m)+5e-6)/Math.abs(c-u))>.5||0===y)break;v=(u-c)/(d-c),C=(_-f)/(A-f),P=1-Math.sqrt(1-v),x=Math.sqrt(v),(M=P<C&&C<x?_/(f-_)*(A/(f-A))+_/(A-_)*(f/(A-f))*((d-u)/(c-u)):.5*S)<b&&(M=b),M>1-b&&(M=1-b),E++}while(E<=O);return m},fminbr:function(t,e,i){var s,o,a,l,h,u,c,d,p,_,f,A,g,m,y,b,v=.5*(3-Math.sqrt(5)),C=n.A.eps,P=n.A.eps,x=this.maxIterationsMinimize,E=0;if(!r.A.isArray(e)||e.length<2)throw new Error("JXG.Math.Numerics.fminbr: length of array x0 has to be at least two.");for(a=l=(s=e[0])+v*((o=e[1])-s),h=l,u=c=t.call(i,l),d=c;E<x;){if(p=o-s,_=.5*(s+o),f=P*Math.abs(a)+C/3,Math.abs(a-_)+.5*p<=2*f)return a;A=v*(a<_?o-a:s-a),Math.abs(a-h)>=f&&(g=(a-l)*(m=(a-l)*(u-d))-(a-h)*(y=(a-h)*(u-c)),(m=2*(m-y))>0?g=-g:m=-m,Math.abs(g)<Math.abs(A*m)&&g>m*(s-a+2*f)&&g<m*(o-a-2*f)&&(A=g/m)),Math.abs(A)<f&&(A=A>0?f:-f),y=a+A,(b=t.call(i,y))<=u?(y<a?o=a:s=a,l=h,h=a,a=y,c=d,d=u,u=b):(y<a?s=y:o=y,b<=d||h===a?(l=h,h=y,c=d,d=b):(b<=c||l===a||l===h)&&(l=y,c=b)),E+=1}return a},glomin:function(t,e){var i,s,r,o,a,l,h,u,c,d,p,_,f,A,g,m,y,b,v,C,P,x,E,O,S,M,w,T,N=1e7,j=n.A.eps,D=n.A.eps*n.A.eps,k=n.A.eps*n.A.eps*n.A.eps;if(S=e[0],M=e[1],w=t(S)<t(M)?S:M,T=i=M,s=S,P=y=t(M),y<(m=v=t(S))?m=y:T=S,M<=S)return m;for(c=.5*(1+16*k)*N,u=3,o=s-(g=w<=S||M<=w?.5*(S+M):w),h=9/11,(b=t(g))<m&&(T=g,m=b);;){if(l=g-i,O=M-s,d=f=(a=s-i)*a*(x=v-b)-o*o*(E=v-y),p=_=2*(o*E-a*x),u<1e6||v<=m)for(;p*(f*(P-v)+O*p*(v-m+j))<O*c*f*(O*p-f)&&(C=t(r=s+f/p))<m&&(T=r,m=C),p=1,!(O<=(f=1e-5*(M-S)*(u=1611*u%1048576))););else for(p=1,f=1e-5*(M-S)*(u=1611*u%1048576);f<O;)p*(f*(P-v)+O*p*(v-m+j))<O*c*f*(O*p-f)&&(C=t(r=s+f/p))<m&&(T=r,m=C),p=1,f=1e-5*(M-S)*(u=1611*u%1048576);for(d=(h=.5*(1+h))*(d+2*(f=c*o*a*l)*(A=Math.sqrt((v-m+j)/c))),f=(f=-.5*(o+(x+2.01*D)/(o*c)))<A||o<0?s+A:s+f,r=0<d*(p+=.5*_)?s+d/p:f;(M<=(r=Math.max(r,f))?(r=M,C=P):C=t(r),C<m&&(T=r,m=C),o=r-s,!(r<=f))&&(d=2*(v-C)/(N*o),!((1+9*k)*o<=Math.abs(d)))&&!(.5*c*(o*o+d*d)<=v-m+(C-m)+2*j);)r=.5*(s+r),h*=.9;if(M<=r)break;i=g,g=s,s=r,y=b,b=v,v=C}return[T,m]},polzeros:function(t,e,i,r,o){var n,a,l,h=[],u=[],c=[],d=function(t,e,i){var r,o,n=t.length-1;if(i=i||!1)for(o=s.A.C.mult(n,t[n]),r=n-1;r>0;r--)o.mult(e),o.add(s.A.C.mult(t[r],r));else for(o=s.A.C.copy(t[n]),r=n-1;r>=0;r--)o.mult(e),o.add(t[r]);return o},p=function(t,e,i){var r,o,n=t.length-1;if(i=i||!1)for(o=s.A.C.mult(n,t[0]),r=n-1;r>0;r--)o.mult(e),o.add(s.A.C.mult(t[n-r],r));else for(o=s.A.C.copy(t[0]),r=n-1;r>=0;r--)o.mult(e),o.add(t[n-r]);return o},_=function(t,e){var i,s,r=t.length-1;for(s=t[r],i=r-1;i>=0;i--)s=s*e+t[i];return s};for(i=i||Number.EPSILON,r=r||30,a=t.length,s.A.isNumber(e)&&e>=0&&e<a-1&&(a=e+1),n=0;n<a;n++)h.push(new s.A.Complex(t[n]));for(n=0;n<a;n++)if(0!==h[n].real||0!==h[n].imaginary){l=n;break}for(n=0;n<l;n++)u.push(new s.A.Complex(0));for(n=(a=(h=h.slice(l)).length)-1;n>=0&&(0===h[n].real&&0===h[n].imaginary);n--)h.pop();if(0===(a=h.length))return[];if(o)for(n=0;n<a-1;n++)c.push(new s.A.Complex(o[n]));else c=function(t){var e,i,r,o,n=t.length-1,a=2*Math.PI/n,l=Math.PI/n*.5,h=[];for((r=s.A.C.mult(-1,t[n-1])).div(s.A.C.mult(n,t[n])),o=s.A.C.div(d(t,r),t[n]),0===(i=Math.pow(s.A.C.abs(o),1/n))&&(i=1),e=0;e<n;e++)t=new s.A.Complex(i*Math.cos(a*e+l),i*Math.sin(a*e+l)),h[e]=s.A.C.add(r,t);return h}(h);return function(t,e,i,r){var o,n,a,l,h,u,c,f,A,g=[],m=[],y=0,b=r.length;for(n=0;n<b;n++)g.push(!1);for(n=0;n<t.length;n++)m.push(s.A.C.abs(t[n])*(4*n+1));for(o=0;o<i&&y<b;o++)for(n=0;n<b;n++)if(!g[n])if(u=d(t,r[n]),h=s.A.C.abs(r[n]),s.A.C.abs(u)<e*_(m,h)){if(g[n]=!0,++y===b)break}else{for(h>1?(l=s.A.C.div(1,r[n]),(A=p(t,l,!0)).div(p(t,l)),A.mult(l),u=s.A.C.sub(b,A),u=s.A.C.div(r[n],u)):u.div(d(t,r[n],!0)),c=new s.A.Complex(0),a=0;a<b;a++)a!==n&&(f=s.A.C.sub(r[n],r[a]),f=s.A.C.div(1,f),c.add(f));c.mult(u),c=s.A.C.sub(1,c),u.div(c),r[n].sub(u)}return o}(h,i,r,c),(c=u.concat(c)).sort((function(t,e){return t.real<e.real?-1:t.real>e.real?1:0})),c},RamerDouglasPeucker:function(t,e){var i,s,r,o=[],a=[],l=function(t,e,i,s,r){var o=function(t,e,i){var s,r,o,a,l,h,u,c,d,p,_,f=n.A.eps*n.A.eps,A=1e4,g=0,m=e;if(i-e<2)return[-1,0];if(o=t[e].scrCoords,a=t[i].scrCoords,isNaN(o[1])||isNaN(o[2]))return[NaN,e];if(isNaN(a[1])||isNaN(a[2]))return[NaN,i];for(r=e+1;r<i;r++){if(l=t[r].scrCoords,isNaN(l[1])||isNaN(l[2]))return[NaN,r];h=(h=(h=l[1]-o[1])==1/0?A:h)===-1/0?-A:h,u=(u=(u=l[2]-o[2])==1/0?A:u)===-1/0?-A:u,(p=(c=(c=(c=a[1]-o[1])==1/0?A:c)===-1/0?-A:c)*c+(d=(d=(d=a[2]-o[2])==1/0?A:d)===-1/0?-A:d)*d)>f?((_=(h*c+u*d)/p)<0?_=0:_>1&&(_=1),s=(h-=_*c)*h+(u-=_*d)*u):(_=0,s=h*h+u*u),s>g&&(g=s,m=r)}return[Math.sqrt(g),m]}(t,e,i),a=o[1];if(isNaN(o[0])){l(t,e,a-1,s,r),r.push(t[a]);do{++a}while(a<=i&&isNaN(t[a].scrCoords[1]+t[a].scrCoords[2]));a<=i&&r.push(t[a]),l(t,a+1,i,s,r)}else o[0]>s?(l(t,e,a,s,r),l(t,a,i,s,r)):r.push(t[i])};for(r=t.length,i=0;;){for(;i<r&&isNaN(t[i].scrCoords[1]+t[i].scrCoords[2]);)i+=1;for(s=i+1;s<r&&!isNaN(t[s].scrCoords[1]+t[s].scrCoords[2]);)s+=1;if(s--,i<r&&s>i&&((a=[])[0]=t[i],l(t,i,s,e,a),o=o.concat(a)),i>=r)break;s<r-1&&o.push(t[s+1]),i=s+1}return o},RamerDouglasPeuker:function(t,e){return s.A.deprecated("Numerics.RamerDouglasPeuker()","Numerics.RamerDouglasPeucker()"),this.RamerDouglasPeucker(t,e)},Visvalingam:function(t,e){var i,r,o,n,a,l,h,u,c,d=[],p=[],_=[];if((r=t.length)<=2)return t;for(d[0]={used:!0,lft:null,node:null},a=0,i=1;i<r-1;i++)o=Math.abs(s.A.Math.Numerics.det([t[i-1].usrCoords,t[i].usrCoords,t[i+1].usrCoords])),isNaN(o)||(c={v:o,idx:i},p.push(c),d[i]={used:!0,lft:a,node:c},d[a].rt=i,a=i);for(d[r-1]={used:!0,rt:null,lft:a,node:null},d[a].rt=r-1,n=-1/0;p.length>e;)p.sort((function(t,e){return e.v-t.v})),d[i=p.pop().idx].used=!1,n=d[i].node.v,a=d[i].lft,l=d[i].rt,d[a].rt=l,d[l].lft=a,null!==(h=d[a].lft)&&(o=Math.abs(s.A.Math.Numerics.det([t[h].usrCoords,t[a].usrCoords,t[l].usrCoords])),d[a].node.v=o>=n?o:n),null!==(u=d[l].rt)&&(o=Math.abs(s.A.Math.Numerics.det([t[a].usrCoords,t[l].usrCoords,t[u].usrCoords])),d[l].node.v=o>=n?o:n);_=[t[i=0]];do{i=d[i].rt,_.push(t[i])}while(null!==d[i].rt);return _}},e.A=n.A.Numerics},588:function(t,e,i){var s=i(443),r=i(477),o=i(188);r.A.Statistics={sum:function(t){var e,i=t.length,s=0;for(e=0;e<i;e++)s+=t[e];return s},prod:function(t){var e,i=t.length,s=1;for(e=0;e<i;e++)s*=t[e];return s},mean:function(t){return t.length>0?this.sum(t)/t.length:0},median:function(t){var e,i;return t.length>0?(ArrayBuffer.isView(t)?(e=new Float64Array(t)).sort():(e=t.slice(0)).sort((function(t,e){return t-e})),1&(i=e.length)?e[parseInt(.5*i,10)]:.5*(e[.5*i-1]+e[.5*i])):0},percentile:function(t,e){var i,s,r,n,a,l=[];if(t.length>0){for(ArrayBuffer.isView(t)?(i=new Float64Array(t)).sort():(i=t.slice(0)).sort((function(t,e){return t-e})),s=i.length,n=o.A.isArray(e)?e:[e],r=0;r<n.length;r++)a=s*n[r]*.01,parseInt(a,10)===a?l.push(.5*(i[a-1]+i[a])):l.push(i[parseInt(a,10)]);return o.A.isArray(e)?l:l[0]}return 0},variance:function(t){var e,i,s,r=t.length;if(r>1){for(e=this.mean(t),i=0,s=0;s<r;s++)i+=(t[s]-e)*(t[s]-e);return i/(t.length-1)}return 0},sd:function(t){return Math.sqrt(this.variance(t))},weightedMean:function(t,e){if(t.length!==e.length)throw new Error("JSXGraph error (Math.Statistics.weightedMean): Array dimension mismatch.");return t.length>0?this.mean(this.multiply(t,e)):0},max:function(t){return Math.max.apply(this,t)},min:function(t){return Math.min.apply(this,t)},range:function(t){return[this.min(t),this.max(t)]},abs:function(t){var e,i,s;if(o.A.isArray(t))if(t.map)s=t.map(Math.abs);else for(i=t.length,s=[],e=0;e<i;e++)s[e]=Math.abs(t[e]);else s=ArrayBuffer.isView(t)?t.map(Math.abs):Math.abs(t);return s},add:function(t,e){var i,s,r=[];if(t=o.A.evalSlider(t),e=o.A.evalSlider(e),o.A.isArray(t)&&o.A.isNumber(e))for(s=t.length,i=0;i<s;i++)r[i]=t[i]+e;else if(o.A.isNumber(t)&&o.A.isArray(e))for(s=e.length,i=0;i<s;i++)r[i]=t+e[i];else if(o.A.isArray(t)&&o.A.isArray(e))for(s=Math.min(t.length,e.length),i=0;i<s;i++)r[i]=t[i]+e[i];else r=t+e;return r},div:function(t,e){var i,s,r=[];if(t=o.A.evalSlider(t),e=o.A.evalSlider(e),o.A.isArray(t)&&o.A.isNumber(e))for(s=t.length,i=0;i<s;i++)r[i]=t[i]/e;else if(o.A.isNumber(t)&&o.A.isArray(e))for(s=e.length,i=0;i<s;i++)r[i]=t/e[i];else if(o.A.isArray(t)&&o.A.isArray(e))for(s=Math.min(t.length,e.length),i=0;i<s;i++)r[i]=t[i]/e[i];else r=t/e;return r},divide:function(){s.A.deprecated("Statistics.divide()","Statistics.div()"),r.A.Statistics.div.apply(r.A.Statistics,arguments)},mod:function(t,e,i){var s,n,a=[],l=function(t,e){return t%e};if((i=o.A.def(i,!1))&&(l=r.A.mod),t=o.A.evalSlider(t),e=o.A.evalSlider(e),o.A.isArray(t)&&o.A.isNumber(e))for(n=t.length,s=0;s<n;s++)a[s]=l(t[s],e);else if(o.A.isNumber(t)&&o.A.isArray(e))for(n=e.length,s=0;s<n;s++)a[s]=l(t,e[s]);else if(o.A.isArray(t)&&o.A.isArray(e))for(n=Math.min(t.length,e.length),s=0;s<n;s++)a[s]=l(t[s],e[s]);else a=l(t,e);return a},multiply:function(t,e){var i,s,r=[];if(t=o.A.evalSlider(t),e=o.A.evalSlider(e),o.A.isArray(t)&&o.A.isNumber(e))for(s=t.length,i=0;i<s;i++)r[i]=t[i]*e;else if(o.A.isNumber(t)&&o.A.isArray(e))for(s=e.length,i=0;i<s;i++)r[i]=t*e[i];else if(o.A.isArray(t)&&o.A.isArray(e))for(s=Math.min(t.length,e.length),i=0;i<s;i++)r[i]=t[i]*e[i];else r=t*e;return r},subtract:function(t,e){var i,s,r=[];if(t=o.A.evalSlider(t),e=o.A.evalSlider(e),o.A.isArray(t)&&o.A.isNumber(e))for(s=t.length,i=0;i<s;i++)r[i]=t[i]-e;else if(o.A.isNumber(t)&&o.A.isArray(e))for(s=e.length,i=0;i<s;i++)r[i]=t-e[i];else if(o.A.isArray(t)&&o.A.isArray(e))for(s=Math.min(t.length,e.length),i=0;i<s;i++)r[i]=t[i]-e[i];else r=t-e;return r},TheilSenRegression:function(t){var e,i,s=[],o=[],n=[];for(e=0;e<t.length;e++){for(o.length=0,i=0;i<t.length;i++)Math.abs(t[i].usrCoords[1]-t[e].usrCoords[1])>r.A.eps&&(o[i]=(t[i].usrCoords[2]-t[e].usrCoords[2])/(t[i].usrCoords[1]-t[e].usrCoords[1]));s[e]=this.median(o),n.push(t[e].usrCoords[2]-s[e]*t[e].usrCoords[1])}return[this.median(n),this.median(s),-1]},generateGaussian:function(t,e){var i,s,r;if(this.hasSpare)return this.hasSpare=!1,this.spare*e+t;do{r=(i=2*Math.random()-1)*i+(s=2*Math.random()-1)*s}while(r>=1||0===r);return r=Math.sqrt(-2*Math.log(r)/r),this.spare=s*r,this.hasSpare=!0,t+e*i*r},randomNormal:function(t,e){return this.generateGaussian(t,e)},randomUniform:function(t,e){return Math.random()*(e-t)+t},randomExponential:function(t){var e;if(t<=0)return NaN;do{e=Math.random()}while(0===e);return-Math.log(e)/t},randomGamma:function(t,e,i){var s,r,o,n,a,l;if(t<=0)return NaN;if(e=e||1,i=i||0,1===t)return e*this.randomExponential(1)+i;if(t<1){a=Math.E/(t+Math.E);do{s=Math.random();do{r=Math.random()}while(0===r);s<a?(o=Math.pow(r,1/t),l=Math.exp(-o)):(o=1-Math.log(r),l=Math.pow(o,t-1)),s=Math.random()}while(s>=l);return e*o+i}do{n=Math.tan(Math.PI*Math.random()),(o=Math.sqrt(2*t-1)*n+t-1)>0&&(r=Math.random())}while(o<=0||r>(1+n*n)*Math.exp((t-1)*Math.log(o/(t-1))-Math.sqrt(2*t-1)*n));return e*o+i},randomBeta:function(t,e){var i;return t<=0||e<=0?NaN:(i=this.randomGamma(t))/(i+this.randomGamma(e))},randomChisquare:function(t){return t<=0?NaN:2*this.randomGamma(.5*t)},randomF:function(t,e){return t<=0||e<=0?NaN:this.randomChisquare(t)*e/(this.randomChisquare(e)*t)},randomT:function(t){var e,i;return t<=0?NaN:(e=this.randomNormal(0,1),i=this.randomChisquare(t),e/Math.sqrt(i/t))},randomBinomial:function(t,e){var i,s,r,o,n;if(e<0||e>1||t<0)return NaN;if(0===e)return 0;if(1===e)return t;if(0===t)return 0;if(1===t)return Math.random()<e?1:0;if(e>.5)return t-this.randomBinomial(t,1-e);if(t<100){if(i=-1,s=0,0===(r=Math.log(1-e)))return 0;do{i+=1,s+=Math.floor(Math.log(Math.random())/r)+1}while(s<t)}else n=t-(o=1+Math.floor(.5*t))+1,i=(i=this.randomBeta(o,n))>=e?this.randomBinomial(o-1,e/i):o+this.randomBinomial(n-1,(e-i)/(1-i));return i},randomGeometric:function(t){var e;return t<0||t>1?NaN:(e=Math.random(),Math.ceil(Math.log(e)/Math.log(1-t)))},randomPoisson:function(t){var e,i,s=Math.exp(-t),r=0,o=1;if(t<=0)return NaN;if(t<10){do{o*=Math.random(),r+=1}while(o>s);e=r-1}else r=Math.floor(7/8*t),e=(i=this.randomGamma(r))<t?r+this.randomPoisson(t-i):this.randomBinomial(r-1,t/i);return e},randomHypergeometric:function(t,e,i){var s,r,o,n=t+e-i,a=Math.min(t,e),l=a;if(t<1||e<1||i>t+e)return NaN;for(s=i;l*s>0;)r=Math.random(),l-=Math.floor(r+l/(n+s)),s-=1;return o=a-l,t<=e?o:i-o},histogram:function(t,e){var i,r,o,n,a,l,h,u,c,d=[],p=[];for(l=e.bins||10,!1===(u=e.range||!1)?(n=Math.min.apply(null,t),a=Math.max.apply(null,t)):(n=u[0],a=u[1]),h=l>0?(a-n)/(l-1):0,i=0;i<l;i++)d.push(0),p.push(n+i*h);for(r=t.length,i=0;i<r;i++)(o=Math.floor((t[i]-n)/h))>=0&&o<l&&(d[o]+=1);if(e.density)for(c=s.A.Math.Statistics.sum(d),i=0;i<l;i++)d[i]/=c;if(e.cumulative)for(i=1;i<l;i++)d[i]+=d[i-1];return[d,p]}},e.A=r.A.Statistics},378:function(t,e,i){var s=i(443),r=i(561),o=i(477),n=i(873),a=i(188);s.A.Options={jc:{enabled:!0,compile:!0},board:{animationDelay:35,axis:!1,boundingBox:[-5,5,5,-5],browserPan:!1,clickDelay:600,dblClickSuppressClick:!1,defaultAxes:{x:{name:"x",fixed:!0,ticks:{label:{visible:"inherit",anchorX:"middle",anchorY:"top",fontSize:12,offset:[0,-3]},tickEndings:[0,1],majorTickEndings:[1,1],drawZero:!1,needsRegularUpdate:!1,visible:"inherit"}},y:{name:"y",fixed:!0,ticks:{label:{visible:"inherit",anchorX:"right",anchorY:"middle",fontSize:12,offset:[-6,0]},tickEndings:[1,0],majorTickEndings:[1,1],drawZero:!1,needsRegularUpdate:!1,visible:"inherit"}}},description:"",document:!1,drag:{enabled:!0},fullscreen:{symbol:'<svg height="1em" width="1em" version="1.1" viewBox="10 10 18 18"><path fill="#666" d="m 10,16 2,0 0,-4 4,0 0,-2 L 10,10 l 0,6 0,0 z"></path><path fill="#666" d="m 20,10 0,2 4,0 0,4 2,0 L 26,10 l -6,0 0,0 z"></path><path fill="#666" d="m 24,24 -4,0 0,2 L 26,26 l 0,-6 -2,0 0,4 0,0 z"></path><path fill="#666" d="M 12,20 10,20 10,26 l 6,0 0,-2 -4,0 0,-4 0,0 z"></path></svg>',scale:.85,id:null},ignoreLabels:!0,intl:{enabled:!1},keepAspectRatio:!1,keyboard:{enabled:!0,dx:10,dy:10,panShift:!0,panCtrl:!1},logging:{enabled:!1},minimizeReflow:"none",maxBoundingBox:[-1/0,1/0,1/0,-1/0],maxFrameRate:40,maxNameLength:1,moveTarget:null,offsetX:0,offsetY:0,pan:{enabled:!0,needShift:!0,needTwoFingers:!1},registerEvents:!0,renderer:"auto",resize:{enabled:!0,throttle:10},screenshot:{scale:1,type:"png",symbol:"⌘",css:"background-color:#eeeeee; opacity:1.0; border:2px solid black; border-radius:10px; text-align:center",cssButton:"padding: 4px 10px; border: solid #356AA0 1px; border-radius: 5px; position: absolute; right: 2ex; top: 2ex; background-color: rgba(255, 255, 255, 0.3);"},selection:{enabled:!1,name:"selectionPolygon",needShift:!1,needCtrl:!0,fillColor:"#ffff00",visible:!1,withLines:!1,vertices:{visible:!1}},showClearTraces:!1,showCopyright:!0,showFullscreen:!1,showInfobox:!0,showNavigation:!0,showReload:!1,showScreenshot:!1,showZoom:!0,takeFirst:!1,takeSizeFromFile:!1,theme:"default",title:"",viewport:[0,0,0,0],zoom:{enabled:!0,factorX:1.25,factorY:1.25,wheel:!0,needShift:!0,center:"auto",min:1e-4,max:1e4,pinch:!0,pinchHorizontal:!0,pinchVertical:!0,pinchSensitivity:7},zoomX:1,zoomY:1},navbar:{strokeColor:"#333333",fillColor:"transparent",highlightFillColor:"#aaaaaa",padding:"2px",position:"absolute",fontSize:"14px",cursor:"pointer",zIndex:"100",right:"5px",bottom:"5px"},elements:{dash:0,dashScale:!1,draft:{draft:!1,strokeColor:"#565656",fillColor:"#565656",strokeOpacity:.8,fillOpacity:.8,strokeWidth:1},dragToTopOfLayer:!1,fillColor:n.A.palette.red,fillOpacity:1,fixed:!1,frozen:!1,gradient:null,gradientAngle:0,gradientCX:.5,gradientCY:.5,gradientEndOffset:1,gradientFX:.5,gradientFY:.5,gradientFR:0,gradientR:.5,gradientSecondColor:"#ffffff",gradientSecondOpacity:1,gradientStartOffset:0,highlight:!0,highlightFillColor:"none",highlightFillOpacity:1,highlightStrokeColor:"#c3d9ff",highlightStrokeOpacity:1,highlightStrokeWidth:2,isLabel:!1,layer:0,lineCap:"butt",needsRegularUpdate:!0,precision:"inherit",priv:!1,rotatable:!0,scalable:!0,shadow:{enabled:!1,color:[0,0,0],opacity:1,blur:3,blend:.1,offset:[5,5]},snapToGrid:!1,strokeColor:n.A.palette.blue,strokeOpacity:1,strokeWidth:2,tabindex:0,trace:!1,traceAttributes:{},transitionDuration:100,transitionProperties:["fill","fill-opacity","stroke","stroke-opacity","stroke-width"],visible:!0,viewport:"inherit",withLabel:!1},ticks:{generateLabelText:null,generateLabelValue:null,drawLabels:!1,label:{},beautifulScientificTickLabels:!1,useUnicodeMinus:!0,anchor:"left",drawZero:!1,insertTicks:!1,minTicksDistance:10,minorHeight:4,majorHeight:10,tickEndings:[1,1],majorTickEndings:[1,1],ignoreInfiniteTickEndings:!0,minorTicks:4,ticksPerLabel:!1,scale:1,scaleSymbol:"",labels:[],maxLabelLength:5,precision:3,digits:3,ticksDistance:1,face:"|",strokeOpacity:1,strokeWidth:1,strokeColor:"#000000",highlightStrokeColor:"#888888",fillColor:"none",highlightFillColor:"none",visible:"inherit",includeBoundaries:!1,type:"linear",intl:{enabled:"inherit",options:{}},minorTicksInArrow:!1,majorTicksInArrow:!0,labelInArrow:!0,minorTicksInMargin:!1,majorTicksInMargin:!0,labelInMargin:!0},hatch:{drawLabels:!1,drawZero:!0,majorHeight:20,anchor:"middle",face:"|",strokeWidth:2,strokeColor:n.A.palette.blue,ticksDistance:.2},precision:{touch:30,touchMax:100,mouse:4,pen:4,epsilon:1e-4,hasPoint:4},layer:{numlayers:20,unused9:19,unused8:18,unused7:17,unused6:16,unused5:15,unused4:14,unused3:13,unused2:12,unused1:11,unused0:10,text:9,point:9,glider:9,arc:8,line:7,circle:6,curve:5,turtle:5,polygon:3,sector:3,angle:3,integral:3,axis:2,ticks:2,grid:1,image:0,trace:0},angle:{withLabel:!0,radius:"auto",type:"sector",orthoType:"square",orthoSensitivity:1,fillColor:n.A.palette.orange,highlightFillColor:n.A.palette.orange,strokeColor:n.A.palette.orange,fillOpacity:.3,highlightFillOpacity:.3,radiuspoint:{withLabel:!1,visible:!1,name:""},pointsquare:{withLabel:!1,visible:!1,name:""},dot:{visible:!1,strokeColor:"none",fillColor:"#000000",size:2,face:"o",withLabel:!1,name:""},label:{position:"top",offset:[0,0],strokeColor:n.A.palette.blue},arc:{visible:!1,fillColor:"none"}},arc:{selection:"auto",hasInnerPoints:!1,label:{anchorX:"auto",anchorY:"auto"},firstArrow:!1,lastArrow:!1,fillColor:"none",highlightFillColor:"none",strokeColor:n.A.palette.blue,highlightStrokeColor:"#c3d9ff",useDirection:!1,center:{},radiusPoint:{},anglePoint:{}},arrow:{firstArrow:!1,lastArrow:{type:1,highlightSize:6,size:6}},arrowparallel:{firstArrow:!1,lastArrow:{type:1,highlightSize:6,size:6}},axis:{name:"",needsRegularUpdate:!1,strokeWidth:1,lastArrow:{type:1,highlightSize:8,size:8},strokeColor:"#666666",highlightStrokeWidth:1,highlightStrokeColor:"#888888",position:"static",anchor:"",anchorDist:"10%",ticksAutoPos:!1,ticksAutoPosThreshold:"5%",withTicks:!0,straightFirst:!0,straightLast:!0,margin:-4,withLabel:!1,scalable:!1,ticks:{label:{offset:[4,-9],parse:!1,needsRegularUpdate:!1,display:"internal",visible:"inherit",layer:9},visible:"inherit",needsRegularUpdate:!1,strokeWidth:1,strokeColor:"#666666",highlightStrokeColor:"#888888",drawLabels:!0,drawZero:!1,insertTicks:!0,minTicksDistance:5,minorHeight:10,majorHeight:-1,tickEndings:[0,1],majorTickEndings:[1,1],minorTicks:4,ticksDistance:1,strokeOpacity:.25},point1:{needsRegularUpdate:!1,visible:!1},point2:{needsRegularUpdate:!1,visible:!1},tabindex:-1,label:{position:"lft",offset:[10,10]}},bisector:{strokeColor:"#000000",point:{visible:!1,fixed:!1,withLabel:!1,name:""}},bisectorlines:{line1:{strokeColor:"#000000"},line2:{strokeColor:"#000000"}},boxplot:{dir:"vertical",smallWidth:.5,strokeWidth:2,strokeColor:n.A.palette.blue,fillColor:n.A.palette.blue,fillOpacity:.2,highlightStrokeWidth:2,highlightStrokeColor:n.A.palette.blue,highlightFillColor:n.A.palette.blue,highlightFillOpacity:.1},button:{disabled:!1,display:"html"},cardinalspline:{createPoints:!0,isArrayOfCoordinates:!0,points:{strokeOpacity:.05,fillOpacity:.05,highlightStrokeOpacity:1,highlightFillOpacity:1,withLabel:!1,name:"",fixed:!1}},chart:{chartStyle:"line",colors:["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#c3d9ff","#4096EE","#008C00"],highlightcolors:null,fillcolor:null,highlightonsector:!1,highlightbysize:!1,fillOpacity:.6,withLines:!1,label:{}},checkbox:{disabled:!1,checked:!1,display:"html"},circle:{hasInnerPoints:!1,fillColor:"none",highlightFillColor:"none",strokeColor:n.A.palette.blue,highlightStrokeColor:"#c3d9ff",center:{visible:!1,withLabel:!1,fixed:!1,fillColor:n.A.palette.red,strokeColor:n.A.palette.red,highlightFillColor:"#c3d9ff",highlightStrokeColor:"#c3d9ff",layer:9,name:""},point2:{fillColor:n.A.palette.red,strokeColor:n.A.palette.red,highlightFillColor:"#c3d9ff",highlightStrokeColor:"#c3d9ff",layer:9,visible:!1,withLabel:!1,fixed:!1,name:""},label:{position:"urt"}},circumcircle:{fillColor:"none",highlightFillColor:"none",strokeColor:n.A.palette.blue,highlightStrokeColor:"#c3d9ff",center:{visible:!1,fixed:!1,withLabel:!1,fillColor:n.A.palette.red,strokeColor:n.A.palette.red,highlightFillColor:"#c3d9ff",highlightStrokeColor:"#c3d9ff",name:""}},circumcirclearc:{fillColor:"none",highlightFillColor:"none",strokeColor:n.A.palette.blue,highlightStrokeColor:"#c3d9ff",center:{visible:!1,withLabel:!1,fixed:!1,name:""}},circumcirclesector:{useDirection:!0,fillColor:n.A.palette.yellow,highlightFillColor:n.A.palette.yellow,fillOpacity:.3,highlightFillOpacity:.3,strokeColor:n.A.palette.blue,highlightStrokeColor:"#c3d9ff",point:{visible:!1,fixed:!1,withLabel:!1,name:""}},comb:{frequency:.2,width:.4,angle:Math.PI/3,reverse:!1,point1:{visible:!1,withLabel:!1,fixed:!1,name:""},point2:{visible:!1,withLabel:!1,fixed:!1,name:""},strokeWidth:1,strokeColor:"#0000ff",fillColor:"none"},conic:{fillColor:"none",highlightFillColor:"none",strokeColor:n.A.palette.blue,highlightStrokeColor:"#c3d9ff",foci:{fixed:!1,visible:!1,withLabel:!1,name:""},center:{visible:!1,withLabel:!1,name:""},point:{withLabel:!1,name:""},line:{visible:!1}},curve:{strokeWidth:1,strokeColor:n.A.palette.blue,fillColor:"none",fixed:!0,curveType:null,doAdvancedPlot:!0,doAdvancedPlotOld:!1,firstArrow:!1,handDrawing:!1,label:{position:"lft"},lastArrow:!1,lineCap:"round",numberPointsHigh:1600,numberPointsLow:400,plotVersion:2,recursionDepthHigh:17,recursionDepthLow:15},foreignobject:{fixed:!0,visible:!0,needsRegularUpdate:!1,attractors:[]},functiongraph:{},glider:{label:{}},grid:{needsRegularUpdate:!1,hasGrid:!1,highlight:!1,gridX:null,gridY:null,majorStep:"auto",minorElements:0,forceSquare:!1,includeBoundaries:!1,size:void 0,face:void 0,margin:void 0,drawZero:void 0,polygonVertices:void 0,major:{size:5,face:"line",margin:0,drawZero:!0,polygonVertices:6},minor:{visible:"inherit",size:3,face:"point",margin:0,drawZero:!0,polygonVertices:6},snapToGrid:!1,strokeColor:"#c0c0c0",strokeWidth:1,strokeOpacity:.5,dash:0,theme:0,themes:[{},{forceSquare:"min",major:{face:"line"}},{major:{face:"line"},minor:{size:3,face:"point"},minorElements:"auto"},{major:{face:"line"},minor:{face:"line",strokeOpacity:.25},minorElements:"auto"},{major:{face:"line"},minor:{face:"+",size:"95%"},minorElements:"auto"},{major:{face:"+",size:10,strokeOpacity:1},minor:{face:"point",size:3},minorElements:"auto"},{major:{face:"circle",size:8,fillColor:"#c0c0c0"},minor:{face:"point",size:3},minorElements:"auto"}]},group:{needsRegularUpdate:!0},htmlslider:{widthRange:100,widthOut:34,step:.01,frozen:!0,isLabel:!1,strokeColor:"#000000",display:"html",anchorX:"left",anchorY:"middle",withLabel:!1},image:{imageString:null,fillOpacity:1,highlightFillOpacity:.6,cssClass:"JXGimage",highlightCssClass:"JXGimageHighlight",rotate:0,snapSizeX:1,snapSizeY:1,attractors:[]},implicitcurve:{margin:1,resolution_outer:5,resolution_inner:5,max_steps:1024,alpha_0:.05,tol_u0:o.A.eps,tol_newton:1e-7,tol_cusp:.05,tol_progress:1e-4,qdt_box:.2,kappa_0:.2,delta_0:.05,h_initial:.1,h_critical:.001,h_max:1,loop_dist:.09,loop_dir:.99,loop_detection:!0},incircle:{fillColor:"none",highlightFillColor:"none",strokeColor:n.A.palette.blue,highlightStrokeColor:"#c3d9ff",center:{visible:!1,fixed:!1,withLabel:!1,fillColor:n.A.palette.red,strokeColor:n.A.palette.red,highlightFillColor:"#c3d9ff",highlightStrokeColor:"#c3d9ff",name:""}},inequality:{fillColor:n.A.palette.red,fillOpacity:.2,strokeColor:"none",inverse:!1},infobox:{distanceX:-20,distanceY:25,intl:{enabled:"inherit",options:{}},fontSize:12,isLabel:!1,strokeColor:"#bbbbbb",display:"html",anchorX:"left",anchorY:"middle",cssClass:"JXGinfobox",rotate:0,visible:!0,parse:!1,transitionDuration:0,needsRegularUpdate:!1,tabindex:null,viewport:[0,0,0,0]},integral:{axis:"x",withLabel:!0,fixed:!0,strokeWidth:0,strokeOpacity:0,fillColor:n.A.palette.red,fillOpacity:.3,highlightFillColor:n.A.palette.red,highlightFillOpacity:.2,curveLeft:{visible:!0,withLabel:!1,color:n.A.palette.red,fillOpacity:.8,layer:9},baseLeft:{visible:!1,fixed:!1,withLabel:!1,name:""},curveRight:{visible:!0,withLabel:!1,color:n.A.palette.red,fillOpacity:.8,layer:9},baseRight:{visible:!1,fixed:!1,withLabel:!1,name:""},label:{fontSize:20,digits:4,intl:{enabled:!1,options:{}}}},input:{disabled:!1,maxlength:524288,display:"html"},intersection:{alwaysIntersect:!0},label:{visible:"inherit",strokeColor:"#000000",strokeOpacity:1,highlightStrokeOpacity:.666666,highlightStrokeColor:"#000000",fixed:!0,position:"urt",distance:1.5,offset:[10,10],autoPosition:!1,autoPositionMinDistance:12,autoPositionMaxDistance:28},legend:{style:"vertical",labels:["1","2","3","4","5","6","7","8"],colors:["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#c3d9ff","#4096EE","#008C00"],rowHeight:20,strokeWidth:5},line:{firstArrow:!1,lastArrow:!1,margin:0,straightFirst:!0,straightLast:!0,fillColor:"none",highlightFillColor:"none",strokeColor:n.A.palette.blue,highlightStrokeColor:"#c3d9ff",withTicks:!1,point1:{fillColor:n.A.palette.red,strokeColor:n.A.palette.red,highlightFillColor:"#c3d9ff",highlightStrokeColor:"#c3d9ff",layer:9,visible:!1,withLabel:!1,fixed:!1,name:""},point2:{fillColor:n.A.palette.red,strokeColor:n.A.palette.red,highlightFillColor:"#c3d9ff",highlightStrokeColor:"#c3d9ff",layer:9,visible:!1,withLabel:!1,fixed:!1,name:""},ticks:{drawLabels:!0,label:{offset:[4,-9]},drawZero:!1,insertTicks:!1,ticksDistance:1,minTicksDistance:50,minorHeight:4,majorHeight:-1,minorTicks:4,strokeOpacity:.3,visible:"inherit"},label:{position:"llft"},snapToGrid:!1,snapSizeX:1,snapSizeY:1,touchFirstPoint:!1,touchLastPoint:!1},locus:{translateToOrigin:!1,translateTo10:!1,stretch:!1,toOrigin:null,to10:null},measurement:{baseUnit:"",units:{},dim:null,showPrefix:!0,showSuffix:!0,prefix:"",suffix:"",formatPrefix:function(t){return t},formatSuffix:function(t){return t},formatCoords:function(t,e,i){return"("+t+", "+e+")"},formatDirection:function(t,e){return"("+t+", "+e+")"}},metapostspline:{createPoints:!0,isArrayOfCoordinates:!0,points:{strokeOpacity:.5,fillOpacity:.5,highlightStrokeOpacity:1,highlightFillOpacity:1,withLabel:!1,name:"",fixed:!1}},mirrorelement:{fixed:!0,point:{},center:{},type:"Euclidean"},nonreflexangle:{},normal:{strokeColor:"#000000",point:{visible:!1,fixed:!1,withLabel:!1,name:""}},orthogonalprojection:{},otherintersection:{alwaysIntersect:!0,precision:.001},parallel:{strokeColor:"#000000",point:{visible:!1,fixed:!1,withLabel:!1,name:""},label:{position:"llft"}},parallelogram:{parallelpoint:{withLabel:!1,name:""}},parallelpoint:{},perpendicular:{strokeColor:"#000000",straightFirst:!0,straightLast:!0},perpendicularsegment:{strokeColor:"#000000",straightFirst:!1,straightLast:!1,point:{visible:!1,fixed:!0,withLabel:!1,name:""}},point:{withLabel:!0,label:{},style:5,face:"o",size:3,sizeUnit:"screen",strokeWidth:2,transitionProperties:["fill","fill-opacity","stroke","stroke-opacity","stroke-width","width","height","rx","ry"],fillColor:n.A.palette.red,strokeColor:n.A.palette.red,highlightFillColor:"#c3d9ff",highlightStrokeColor:"#c3d9ff",zoom:!1,showInfobox:"inherit",infoboxDigits:"auto",draft:!1,attractors:[],attractorUnit:"user",attractorDistance:0,snatchDistance:0,snapToGrid:!1,attractToGrid:!1,snapSizeX:1,snapSizeY:1,snapToPoints:!1,ignoredSnapToPoints:[]},polygon:{hasInnerPoints:!1,fillColor:n.A.palette.yellow,highlightFillColor:n.A.palette.yellow,fillOpacity:.3,highlightFillOpacity:.2,withLines:!0,borders:{withLabel:!1,strokeWidth:1,highlightStrokeWidth:1,layer:5,label:{position:"top"},visible:"inherit"},highlightByStrokeWidth:!1,vertices:{layer:9,withLabel:!1,name:"",strokeColor:n.A.palette.red,fillColor:n.A.palette.red,fixed:!1,visible:"inherit"},label:{offset:[0,0]}},polygonalchain:{fillColor:"none",highlightFillColor:"none"},prescribedangle:{anglePoint:{size:2,visible:!1,withLabel:!1}},reflection:{fixed:!0,center:{},type:"Euclidean"},reflexangle:{},regularpolygon:{hasInnerPoints:!1,fillColor:n.A.palette.yellow,highlightFillColor:n.A.palette.yellow,fillOpacity:.3,highlightFillOpacity:.2,withLines:!0,borders:{withLabel:!1,strokeWidth:1,highlightStrokeWidth:1,layer:5,label:{position:"top"}},vertices:{layer:9,withLabel:!0,strokeColor:n.A.palette.red,fillColor:n.A.palette.red,fixed:!1},label:{offset:[0,0]}},riemannsum:{withLabel:!1,fillOpacity:.3,fillColor:n.A.palette.yellow},sector:{fillColor:n.A.palette.yellow,highlightFillColor:n.A.palette.yellow,fillOpacity:.3,highlightFillOpacity:.3,highlightOnSector:!1,highlightStrokeWidth:0,selection:"auto",arc:{visible:!1,fillColor:"none",withLabel:!1,name:"",center:{visible:!1,withLabel:!1,name:""},radiusPoint:{visible:!1,withLabel:!1,name:""},anglePoint:{visible:!1,withLabel:!1,name:""}},radiusPoint:{visible:!1,withLabel:!1},center:{visible:!1,withLabel:!1},anglePoint:{visible:!1,withLabel:!1},label:{offset:[0,0],anchorX:"auto",anchorY:"auto"}},segment:{label:{position:"top"}},semicircle:{center:{visible:!1,withLabel:!1,fixed:!1,fillColor:n.A.palette.red,strokeColor:n.A.palette.red,highlightFillColor:"#eeeeee",highlightStrokeColor:n.A.palette.red,name:""}},slider:{snapWidth:-1,snapValues:[],snapValueDistance:0,precision:2,digits:2,intl:{enabled:"inherit",options:{}},firstArrow:!1,lastArrow:!1,withTicks:!0,withLabel:!0,suffixLabel:null,unitLabel:null,postLabel:null,layer:9,showInfobox:!1,name:"",visible:!0,strokeColor:"#000000",highlightStrokeColor:"#888888",fillColor:"#ffffff",highlightFillColor:"none",size:6,point1:{needsRegularUpdate:!1,showInfobox:!1,withLabel:!1,visible:!1,fixed:!0,name:""},point2:{needsRegularUpdate:!1,showInfobox:!1,withLabel:!1,visible:!1,fixed:!0,name:""},baseline:{needsRegularUpdate:!1,visible:"inherit",fixed:!0,scalable:!1,tabindex:null,name:"",strokeWidth:1,strokeColor:"#000000",highlightStrokeColor:"#888888"},ticks:{needsRegularUpdate:!1,fixed:!0,drawLabels:!1,digits:2,includeBoundaries:!0,drawZero:!0,label:{offset:[-4,-14],display:"internal"},minTicksDistance:30,insertTicks:!0,ticksDistance:1,minorHeight:4,majorHeight:5,minorTicks:0,strokeOpacity:1,strokeWidth:1,tickEndings:[0,1],majortickEndings:[0,1],strokeColor:"#000000",visible:"inherit"},highline:{strokeWidth:3,visible:"inherit",fixed:!0,tabindex:null,name:"",strokeColor:"#000000",highlightStrokeColor:"#888888"},label:{visible:"inherit",strokeColor:"#000000"},moveOnUp:!0},slopefield:{strokeWidth:.5,highlightStrokeWidth:.5,highlightStrokeColor:n.A.palette.blue,highlightStrokeOpacity:.8,scale:1,arrowhead:{enabled:!1,size:5,angle:.125*Math.PI}},slopetriangle:{fillColor:n.A.palette.red,fillOpacity:.4,highlightFillColor:n.A.palette.red,highlightFillOpacity:.3,borders:{lastArrow:{type:1,size:6}},glider:{fixed:!0,visible:!1,withLabel:!1},baseline:{visible:!1,withLabel:!1,name:""},basepoint:{visible:!1,withLabel:!1,name:""},tangent:{visible:!1,withLabel:!1,name:""},toppoint:{visible:!1,withLabel:!1,name:""},label:{visible:!0,position:"first"}},smartlabelangle:{cssClass:"smart-label-solid smart-label-angle",highlightCssClass:"smart-label-solid smart-label-angle",anchorX:"left",anchorY:"middle",unit:"",prefix:"",suffix:"",measure:"deg",useMathJax:!0},smartlabelcircle:{cssClass:"smart-label-solid smart-label-circle",highlightCssClass:"smart-label-solid smart-label-circle",anchorX:"middle",useMathJax:!0,unit:"",prefix:"",suffix:"",measure:"radius"},smartlabelline:{cssClass:"smart-label-solid smart-label-line",highlightCssClass:"smart-label-solid smart-label-line",anchorX:"middle",useMathJax:!0,unit:"",measure:"length"},smartlabelpoint:{cssClass:"smart-label-solid smart-label-point",highlightCssClass:"smart-label-solid smart-label-point",anchorX:"middle",anchorY:"top",useMathJax:!0,dir:"row",unit:""},smartlabelpolygon:{cssClass:"smart-label-solid smart-label-polygon",highlightCssClass:"smart-label-solid smart-label-polygon",anchorX:"middle",useMathJax:!0,unit:"",measure:"area"},stepfunction:{},tangent:{},tapemeasure:{strokeColor:"#000000",strokeWidth:2,highlightStrokeColor:"#000000",withTicks:!0,withLabel:!0,rotate:0,precision:2,digits:2,point1:{visible:!0,strokeColor:"#000000",fillColor:"#ffffff",fillOpacity:0,highlightFillOpacity:.1,size:6,snapToPoints:!0,attractorUnit:"screen",attractorDistance:20,showInfobox:!1,withLabel:!1,name:""},point2:{visible:!0,strokeColor:"#000000",fillColor:"#ffffff",fillOpacity:0,highlightFillOpacity:.1,size:6,snapToPoints:!0,attractorUnit:"screen",attractorDistance:20,showInfobox:!1,withLabel:!1,name:""},ticks:{drawLabels:!1,drawZero:!0,insertTicks:!0,ticksDistance:.1,minorHeight:8,majorHeight:16,minorTicks:4,tickEndings:[0,1],majorTickEndings:[0,1],strokeOpacity:1,strokeWidth:1,strokeColor:"#000000",visible:"inherit",label:{anchorY:"top",anchorX:"middle",offset:[0,-10]}},label:{position:"top"}},text:{fontSize:12,fontUnit:"px",formatNumber:!1,digits:2,intl:{enabled:"inherit",options:{minimumFractionDigits:0,maximumFractionDigits:2}},parse:!0,useCaja:!1,isLabel:!1,strokeColor:"#000000",highlightStrokeColor:"#000000",highlightStrokeOpacity:.666666,cssDefaultStyle:"font-family: Arial, Helvetica, Geneva, sans-serif;",highlightCssDefaultStyle:"font-family: Arial, Helvetica, Geneva, sans-serif;",cssStyle:"",highlightCssStyle:"",transitionProperties:["color","opacity"],useASCIIMathML:!1,useMathJax:!1,useKatex:!1,katexMacros:{},toFraction:!1,display:"html",anchor:null,anchorX:"left",anchorY:"middle",cssClass:"JXGtext",highlightCssClass:"JXGtext",dragArea:"all",withLabel:!1,rotate:0,visible:!0,snapSizeX:1,snapSizeY:1,attractors:[]},tracecurve:{strokeColor:"#000000",fillColor:"none",numberPoints:100},turtle:{strokeWidth:1,fillColor:"none",strokeColor:"#000000",arrow:{strokeWidth:2,withLabel:!1,strokeColor:n.A.palette.red,lastArrow:!0}},vectorfield:{strokeWidth:.5,highlightStrokeWidth:.5,highlightStrokeColor:n.A.palette.blue,highlightStrokeOpacity:.8,scale:1,arrowhead:{enabled:!0,size:5,angle:.125*Math.PI}},shortcuts:{color:["strokeColor","fillColor"],opacity:["strokeOpacity","fillOpacity"],highlightColor:["highlightStrokeColor","highlightFillColor"],highlightOpacity:["highlightStrokeOpacity","highlightFillOpacity"],strokeWidth:["strokeWidth","highlightStrokeWidth"]}},s.A.Validator=function(){var t,e=function(t){return a.A.isString(t)},i=function(t){return Math.abs(t-Math.round(t))<o.A.eps},r=function(t){return i(t)&&t>0},n=function(t){return t>0},l=function(t){return t>=0},h={},u={attractorDistance:l,color:e,display:function(t){return"html"===t||"internal"===t},doAdvancedPlot:!1,draft:!1,drawLabels:!1,drawZero:!1,face:function(t){return a.A.exists(s.A.normalizePointFace(t))},factor:a.A.isNumber,fillColor:e,fillOpacity:a.A.isNumber,firstArrow:!1,fontSize:i,dash:i,gridX:a.A.isNumber,gridY:a.A.isNumber,hasGrid:!1,highlightFillColor:e,highlightFillOpacity:a.A.isNumber,highlightStrokeColor:e,highlightStrokeOpacity:a.A.isNumber,insertTicks:!1,lastArrow:!1,layer:function(t){return i(t)&&t>=0},majorHeight:i,minorHeight:i,minorTicks:l,minTicksDistance:r,numberPointsHigh:r,numberPointsLow:r,opacity:a.A.isNumber,radius:a.A.isNumber,RDPsmoothing:!1,renderer:function(t){return"vml"===t||"svg"===t||"canvas"===t||"no"===t},right:function(t){return/^[0-9]+px$/.test(t)},showCopyright:!1,showInfobox:!1,showNavigation:!1,size:l,snapSizeX:n,snapSizeY:n,snapWidth:a.A.isNumber,snapToGrid:!1,snatchDistance:l,straightFirst:!1,straightLast:!1,stretch:!1,strokeColor:e,strokeOpacity:a.A.isNumber,strokeWidth:l,takeFirst:!1,takeSizeFromFile:!1,to10:!1,toOrigin:!1,translateTo10:!1,translateToOrigin:!1,useASCIIMathML:!1,useDirection:!1,useMathJax:!1,withLabel:!1,withTicks:!1,zoom:!1};for(t in u)u.hasOwnProperty(t)&&(h[t.toLowerCase()]=u[t]);return h}(),s.A.normalizePointFace=function(t){return{cross:"x",x:"x",circle:"o",o:"o",square:"[]","[]":"[]",plus:"+","+":"+",divide:"|","|":"|",minus:"-","-":"-",diamond:"<>","<>":"<>",diamond2:"<<>>","<<>>":"<<>>",triangleup:"^",A:"^",a:"^","^":"^",triangledown:"v",v:"v",triangleleft:"<","<":"<",triangleright:">",">":">"}[t]},s.A.useStandardOptions=function(t){var e,i,o,n,a=s.A.Options,l=t.hasGrid;for(e in t.options.grid.hasGrid=a.grid.hasGrid,t.options.grid.gridX=a.grid.gridX,t.options.grid.gridY=a.grid.gridY,t.options.grid.gridColor=a.grid.gridColor,t.options.grid.gridOpacity=a.grid.gridOpacity,t.options.grid.gridDash=a.grid.gridDash,t.options.grid.snapToGrid=a.grid.snapToGrid,t.options.grid.snapSizeX=a.grid.SnapSizeX,t.options.grid.snapSizeY=a.grid.SnapSizeY,t.takeSizeFromFile=a.takeSizeFromFile,n=function(t,e){t.visProp.fillcolor=e.fillColor,t.visProp.highlightfillcolor=e.highlightFillColor,t.visProp.strokecolor=e.strokeColor,t.visProp.highlightstrokecolor=e.highlightStrokeColor},t.objects)if(t.objects.hasOwnProperty(e))if((o=t.objects[e]).elementClass===r.A.OBJECT_CLASS_POINT)n(o,a.point);else if(o.elementClass===r.A.OBJECT_CLASS_LINE)for(n(o,a.line),i=0;i<o.ticks.length;i++)o.ticks[i].majorTicks=a.line.ticks.majorTicks,o.ticks[i].minTicksDistance=a.line.ticks.minTicksDistance,o.ticks[i].visProp.minorheight=a.line.ticks.minorHeight,o.ticks[i].visProp.majorheight=a.line.ticks.majorHeight;else o.elementClass===r.A.OBJECT_CLASS_CIRCLE?n(o,a.circle):o.type===r.A.OBJECT_TYPE_ANGLE?n(o,a.angle):o.type===r.A.OBJECT_TYPE_ARC?n(o,a.arc):o.type===r.A.OBJECT_TYPE_POLYGON?n(o,a.polygon):o.type===r.A.OBJECT_TYPE_CONIC?n(o,a.conic):o.type===r.A.OBJECT_TYPE_CURVE?n(o,a.curve):o.type===r.A.OBJECT_TYPE_SECTOR&&(o.arc.visProp.fillcolor=a.sector.fillColor,o.arc.visProp.highlightfillcolor=a.sector.highlightFillColor,o.arc.visProp.fillopacity=a.sector.fillOpacity,o.arc.visProp.highlightfillopacity=a.sector.highlightFillOpacity);t.fullUpdate(),l&&!t.hasGrid?t.removeGrids(t):!l&&t.hasGrid&&t.create("grid",[])},s.A.useBlackWhiteOptions=function(t){var e=s.A.Options;e.point.fillColor=n.A.rgb2bw(e.point.fillColor),e.point.highlightFillColor=n.A.rgb2bw(e.point.highlightFillColor),e.point.strokeColor=n.A.rgb2bw(e.point.strokeColor),e.point.highlightStrokeColor=n.A.rgb2bw(e.point.highlightStrokeColor),e.line.fillColor=n.A.rgb2bw(e.line.fillColor),e.line.highlightFillColor=n.A.rgb2bw(e.line.highlightFillColor),e.line.strokeColor=n.A.rgb2bw(e.line.strokeColor),e.line.highlightStrokeColor=n.A.rgb2bw(e.line.highlightStrokeColor),e.circle.fillColor=n.A.rgb2bw(e.circle.fillColor),e.circle.highlightFillColor=n.A.rgb2bw(e.circle.highlightFillColor),e.circle.strokeColor=n.A.rgb2bw(e.circle.strokeColor),e.circle.highlightStrokeColor=n.A.rgb2bw(e.circle.highlightStrokeColor),e.arc.fillColor=n.A.rgb2bw(e.arc.fillColor),e.arc.highlightFillColor=n.A.rgb2bw(e.arc.highlightFillColor),e.arc.strokeColor=n.A.rgb2bw(e.arc.strokeColor),e.arc.highlightStrokeColor=n.A.rgb2bw(e.arc.highlightStrokeColor),e.polygon.fillColor=n.A.rgb2bw(e.polygon.fillColor),e.polygon.highlightFillColor=n.A.rgb2bw(e.polygon.highlightFillColor),e.sector.fillColor=n.A.rgb2bw(e.sector.fillColor),e.sector.highlightFillColor=n.A.rgb2bw(e.sector.highlightFillColor),e.curve.strokeColor=n.A.rgb2bw(e.curve.strokeColor),e.grid.gridColor=n.A.rgb2bw(e.grid.gridColor),s.A.useStandardOptions(t)},s.A.Options.normalizePointFace=s.A.normalizePointFace,e.A=s.A.Options},86:function(t,e,i){var s=i(443),r=i(561),o=i(188);s.A.GeonextParser={replacePow:function(t){var e,i,s,r,o,n,a,l,h,u,c,d;for(u=(t=t.replace(/(\s*)\^(\s*)/g,"^")).indexOf("^"),r=-1;u>=0&&u<t.length-1;){if(r===u)throw new Error("JSXGraph: Error while parsing expression '"+t+"'");if(r=u,h=t.slice(0,u),c=t.slice(u+1),")"===h.charAt(h.length-1)){for(e=1,i=h.length-2;i>=0&&e>0;)")"===(s=h.charAt(i))?e++:"("===s&&(e-=1),i-=1;if(0!==e)throw new Error("JSXGraph: Missing '(' in expression");for(o="",a=h.substring(0,i+1),l=i;l>=0&&a.slice(l,l+1).match(/([\w.]+)/);)o=RegExp.$1+o,l-=1;o=(o+=h.substring(i+1,h.length)).replace(/([()+*%^\-/\][])/g,"\\$1")}else o="[\\w\\.]+";if(c.match(/^([\w.]*\()/)){for(e=1,i=RegExp.$1.length;i<c.length&&e>0;)")"===(s=c.charAt(i))?e-=1:"("===s&&(e+=1),i+=1;if(0!==e)throw new Error("JSXGraph: Missing ')' in expression");n=(n=c.substring(0,i)).replace(/([()+*%^\-/[\]])/g,"\\$1")}else n="[\\w\\.]+";d=new RegExp("("+o+")\\^("+n+")"),u=(t=t.replace(d,"pow($1,$2)")).indexOf("^")}return t},replaceIf:function(t){var e,i,s,r,o,n,a,l,h,u="",c=null,d=null,p=null;if((s=t.indexOf("If("))<0)return t;for(t=t.replace(/""/g,"0");s>=0;){for(e=t.slice(0,s),i=t.slice(s+3),o=1,r=0,n=-1,a=-1;r<i.length&&o>0;)")"===(l=i.charAt(r))?o-=1:"("===l?o+=1:","===l&&1===o&&(n<0?n=r:a=r),r+=1;if(h=i.slice(0,r-1),i=i.slice(r),n<0)return"";if(a<0)return"";c=h.slice(0,n),d=h.slice(n+1,a),p=h.slice(a+1),u+=e+"(("+(c=this.replaceIf(c))+")?("+(d=this.replaceIf(d))+"):("+(p=this.replaceIf(p))+"))",c=null,d=null,s=(t=i).indexOf("If(")}return u+=i},replaceNameById:function(t,e,i){var s,r,o,n,a=0,l=["X","Y","L","V"],h=function(t){return i?"$('"+t+"')":t};for(n=0;n<l.length;n++)for(a=t.indexOf(l[n]+"(");a>=0;)a>=0&&(s=t.indexOf(")",a+2))>=0&&(r=(r=t.slice(a+2,s)).replace(/\\(['"])?/g,"$1"),(o=e.elementsByName[r])&&(t=t.slice(0,a+2)+(i?"$('":"")+h(o.id)+t.slice(s))),s=t.indexOf(")",a+2),a=t.indexOf(l[n]+"(",s);for(a=t.indexOf("Dist(");a>=0;)a>=0&&(s=t.indexOf(",",a+5))>=0&&(r=(r=t.slice(a+5,s)).replace(/\\(['"])?/g,"$1"),(o=e.elementsByName[r])&&(t=t.slice(0,a+5)+h(o.id)+t.slice(s))),s=t.indexOf(",",a+5),a=t.indexOf(",",s),(s=t.indexOf(")",a+1))>=0&&(r=(r=t.slice(a+1,s)).replace(/\\(['"])?/g,"$1"),(o=e.elementsByName[r])&&(t=t.slice(0,a+1)+h(o.id)+t.slice(s))),s=t.indexOf(")",a+1),a=t.indexOf("Dist(",s);for(l=["Deg","Rad"],n=0;n<l.length;n++)for(a=t.indexOf(l[n]+"(");a>=0;)a>=0&&(s=t.indexOf(",",a+4))>=0&&(r=(r=t.slice(a+4,s)).replace(/\\(['"])?/g,"$1"),(o=e.elementsByName[r])&&(t=t.slice(0,a+4)+h(o.id)+t.slice(s))),s=t.indexOf(",",a+4),a=t.indexOf(",",s),(s=t.indexOf(",",a+1))>=0&&(r=(r=t.slice(a+1,s)).replace(/\\(['"])?/g,"$1"),(o=e.elementsByName[r])&&(t=t.slice(0,a+1)+h(o.id)+t.slice(s))),s=t.indexOf(",",a+1),a=t.indexOf(",",s),(s=t.indexOf(")",a+1))>=0&&(r=(r=t.slice(a+1,s)).replace(/\\(['"])?/g,"$1"),(o=e.elementsByName[r])&&(t=t.slice(0,a+1)+h(o.id)+t.slice(s))),s=t.indexOf(")",a+1),a=t.indexOf(l[n]+"(",s);return t},replaceIdByObj:function(t){var e=/(X|Y|L)\(([\w_]+)\)/g;return t=t.replace(e,"$('$2').$1()"),e=/(V)\(([\w_]+)\)/g,t=t.replace(e,"$('$2').Value()"),e=/(Dist)\(([\w_]+),([\w_]+)\)/g,t=t.replace(e,"dist($('$2'), $('$3'))"),e=/(Deg)\(([\w_]+),([ \w[\w_]+),([\w_]+)\)/g,t=t.replace(e,"deg($('$2'),$('$3'),$('$4'))"),e=/Rad\(([\w_]+),([\w_]+),([\w_]+)\)/g,t=t.replace(e,"rad($('$1'),$('$2'),$('$3'))"),e=/N\((.+)\)/g,t=t.replace(e,"($1)")},geonext2JS:function(t,e){var i,s,r,o=["Abs","ACos","ASin","ATan","Ceil","Cos","Exp","Factorial","Floor","Log","Max","Min","Random","Round","Sin","Sqrt","Tan","Trunc"],n=["abs","acos","asin","atan","ceil","cos","exp","factorial","floor","log","max","min","random","round","sin","sqrt","tan","ceil"];for(s=t=(t=(t=t.replace(/&lt;/g,"<")).replace(/&gt;/g,">")).replace(/&amp;/g,"&"),s=this.replaceNameById(s,e),s=this.replaceIf(s),s=this.replacePow(s),s=this.replaceIdByObj(s),r=0;r<o.length;r++)i=new RegExp(["(\\W|^)(",o[r],")"].join(""),"ig"),s=s.replace(i,["$1",n[r]].join(""));return s=(s=(s=(s=(s=s.replace(/True/g,"true")).replace(/False/g,"false")).replace(/fasle/g,"false")).replace(/Pi/g,"PI")).replace(/"/g,"'")},findDependencies:function(t,e,i){var s,n,a,l;for(n in o.A.exists(i)||(i=t.board),s=i.elementsByName)s.hasOwnProperty(n)&&n!==t.name&&(s[n].elementClass===r.A.OBJECT_CLASS_TEXT&&o.A.evaluate(s[n].visProp.islabel)||(l=(l=n.replace(/\[/g,"\\[")).replace(/\]/g,"\\]"),a=new RegExp("\\(([\\w\\[\\]'_ ]+,)*("+l+")(,[\\w\\[\\]'_ ]+)*\\)","g"),e.search(a)>=0&&s[n].addChild(t)))},gxt2jc:function(t,e){var i;return i=t=(t=(t=t.replace(/&lt;/g,"<")).replace(/&gt;/g,">")).replace(/&amp;/g,"&"),i=(i=(i=(i=this.replaceNameById(i,e,!0)).replace(/True/g,"true")).replace(/False/g,"false")).replace(/fasle/g,"false")}},e.A=s.A.GeonextParser},428:function(__unused_webpack_module,__webpack_exports__,__webpack_require__){var _jxg_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(443),_base_constants_js__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(561),_base_text_js__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(925),_math_math_js__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(477),_math_ia_js__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(733),_math_geometry_js__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(571),_math_statistics_js__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(588),_utils_type_js__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(188),_utils_env_js__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(133);Object.create||(Object.create=function(t,e){if("object"!=typeof t&&"function"!=typeof t)throw new TypeError("Object prototype may only be an Object: "+t);if(null===t)throw new Error("This browser's implementation of Object.create is a shim and doesn't support 'null' as the first argument.");if(void 0!==e)throw new Error("This browser's implementation of Object.create is a shim and doesn't support a second argument.");function i(){}return i.prototype=t,new i});var priv={modules:{math:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A,"math/geometry":_math_geometry_js__WEBPACK_IMPORTED_MODULE_5__.A,"math/statistics":_math_statistics_js__WEBPACK_IMPORTED_MODULE_6__.A,"math/numerics":_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.Numerics}},r,_ccache;_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.JessieCode=function(t,e){this.scope={id:0,hasChild:!0,args:[],locals:{},context:null,previous:null},this.scopes=[],this.scopes.push(this.scope),this.dpstack=[[]],this.pscope=0,this.propstack=[{}],this.propscope=0,this.lhs=[],this.isLHS=!1,this.warnLog="jcwarn",this.$log=[],this.builtIn=this.defineBuiltIn(),this.operands=this.getPossibleOperands(),this.board=null,this.forceValueCall=!1,this.lineToElement={},this.parCurLine=1,this.parCurColumn=0,this.line=1,this.col=1,_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.CA&&(this.CA=new _jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.CA(this.node,this.createNode,this)),this.code="","string"==typeof t&&this.parse(t,e)},_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.extend(_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.JessieCode.prototype,{node:function(t,e,i){return{type:t,value:e,children:i}},createNode:function(t,e,i){var s,r=this.node(t,e,[]);for(s=2;s<arguments.length;s++)r.children.push(arguments[s]);return"node_const"===r.type&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(r.value)&&(r.isMath=!0),r.line=this.parCurLine,r.col=this.parCurColumn,r},pushScope:function(t){var e={args:t,locals:{},context:null,previous:this.scope};return this.scope.hasChild=!0,this.scope=e,e.id=this.scopes.push(e)-1,e},popScope:function(){var t=this.scope.previous;return this.scope=null!==t?t:this.scope,this.scope},getElementById:function(t){return this.board.objects[t]},log:function(){this.$log.push(arguments),"object"==typeof console&&console.log&&console.log.apply(console,arguments)},creator:(_ccache={},(r=function(t){var e,i;return"function"==typeof _ccache[this.board.id+t]?e=_ccache[this.board.id+t]:(i=this,(e=function(e,s){var r;return void 0===(r=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(s)?s:{}).name&&void 0===r.id&&(r.name=0!==i.lhs[i.scope.id]?i.lhs[i.scope.id]:""),i.board.create(t,e,r)}).creator=!0,_ccache[this.board.id+t]=e),e}).clearCache=function(){_ccache={}},r),letvar:function(t,e){this.builtIn[t]&&this._warn('"'+t+'" is a predefined value.'),this.scope.locals[t]=e},isLocalVariable:function(t){for(var e=this.scope;null!==e;){if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(e.locals[t]))return e;e=e.previous}return null},isParameter:function(t){for(var e=this.scope;null!==e;){if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.indexOf(e.args,t)>-1)return e;e=e.previous}return null},isCreator:function(t){return!!_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.elements[t]},isMathMethod:function(t){return"E"!==t&&!!Math[t]},isBuiltIn:function(t){return!!this.builtIn[t]},getvar:function(t,e,i){var s;if(e=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.def(e,!1),null!==(s=this.isLocalVariable(t)))return s.locals[t];if("$board"===t||"EULER"===t||"PI"===t)return this.builtIn[t];if(i){if(this.isBuiltIn(t))return this.builtIn[t];if(this.isMathMethod(t))return Math[t];if(this.isCreator(t))return this.creator(t)}return e||(s=this.board.select(t))===t?void 0:s},resolve:function(t){for(var e=this.scope;null!==e;){if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(e.locals[t]))return e.locals[t];e=e.previous}},getvarJS:function(t,e,i){var s,r="";return e=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.def(e,!1),i=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.def(i,!1),null!==this.isParameter(t)?t:null===this.isLocalVariable(t)||i?this.isCreator(t)?"(function () { var a = Array.prototype.slice.call(arguments, 0), props = "+(i?"a.pop()":"{}")+"; return $jc$.board.create.apply($jc$.board, ['"+t+"'].concat([a, props])); })":(i&&this._error("Syntax error (attribute values are allowed with element creators only)"),this.isBuiltIn(t)?(r=this.builtIn[t].src||this.builtIn[t],_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(r)||r.match(/board\.select/)?r:(t=r.split(".").pop(),_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(this.board.mathLib)&&null!==(s=new RegExp("^Math."+t)).exec(r)?r.replace(s,"$jc$.board.mathLib."+t):_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(this.board.mathLibJXG)&&null!==(s=new RegExp("^JXG.Math.")).exec(r)?r.replace(s,"$jc$.board.mathLibJXG."):r)):this.isMathMethod(t)?"$jc$.board.mathLib."+t:e?"":(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isId(this.board,t)?(r="$jc$.board.objects['"+t+"']","slider"===this.board.objects[t].elType&&(r+=".Value()")):_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isName(this.board,t)?(r="$jc$.board.elementsByName['"+t+"']","slider"===this.board.elementsByName[t].elType&&(r+=".Value()")):_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isGroup(this.board,t)&&(r="$jc$.board.groups['"+t+"']"),r)):"$jc$.resolve('"+t+"')"},makeMap:function(t){return t.isMap=!0,t},functionCodeJS:function(t){var e=t.children[0].join(", "),i="",s="";return"op_map"===t.value&&(i="{ return  ",s=" }"),"function ("+e+") {\nvar $oldscope$ = $jc$.scope;\n$jc$.scope = $jc$.scopes["+this.scope.id+"];\nvar r = (function () "+i+this.compile(t.children[1],!0)+s+")();\n$jc$.scope = $oldscope$;\nreturn r;\n}"},defineFunction:function(node){var fun,i,that=this,list=node.children[0],scope=this.pushScope(list),_that;if(this.board.options.jc.compile){for(this.isLHS=!1,i=0;i<list.length;i++)scope.locals[list[i]]=list[i];this.replaceNames(node.children[1]),fun=function(jc){var fun,str="var f = function($jc$) { return "+jc.functionCodeJS(node)+"}; f;";try{for(fun=eval(str)(jc),scope.argtypes=[],i=0;i<list.length;i++)scope.argtypes.push(that.resolveType(list[i],node));return fun}catch(t){return jc._warn("error compiling function\n\n"+str+"\n\n"+t.toString()),function(){}}}(this),this.popScope()}else fun=function(t,e,i){return function(){var s,r;for(r=e.scope,e.scope=e.scopes[i],s=0;s<t.length;s++)e.scope.locals[t[s]]=arguments[s];return s=e.execute(node.children[1]),e.scope=r,s}}(list,this,scope.id);return fun.node=node,fun.scope=scope,fun.toJS=fun.toString,fun.toString=(_that=this,function(){return _that.compile(_that.replaceIDs(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.deepCopy(node)))}),fun.deps={},this.collectDependencies(node.children[1],node.children[0],fun.deps),fun},mergeAttributes:function(t){var e,i={};for(e=0;e<arguments.length;e++)i=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.deepCopy(i,arguments[e],!0);return i},setProp:function(t,e,i){var s,r,o={};t.elementClass!==_base_constants_js__WEBPACK_IMPORTED_MODULE_1__.A.OBJECT_CLASS_POINT||"X"!==e&&"Y"!==e?t.elementClass!==_base_constants_js__WEBPACK_IMPORTED_MODULE_1__.A.OBJECT_CLASS_TEXT||"X"!==e&&"Y"!==e?t.type&&t.elementClass&&t.visProp?_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t[t.methodMap[e]])&&"function"!=typeof t[t.methodMap[e]]?t[t.methodMap[e]]=i:(o[e]=i,t.setAttribute(o)):t[e]=i:("number"==typeof i?t[e]=function(){return i}:"function"==typeof i?(t.isDraggable=!1,t[e]=i):"string"==typeof i&&(t.isDraggable=!1,t[e]=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.createFunction(i,this.board),t[e+"jc"]=i),t[e].origin=i,this.board.update()):(e=e.toLowerCase(),t.isDraggable&&"number"==typeof i?(s="x"===e?i:t.X(),r="y"===e?i:t.Y(),t.setPosition(_base_constants_js__WEBPACK_IMPORTED_MODULE_1__.A.COORDS_BY_USER,[s,r])):!t.isDraggable||"function"!=typeof i&&"string"!=typeof i?t.isDraggable||(s="x"===e?i:t.XEval.origin,r="y"===e?i:t.YEval.origin,t.addConstraint([s,r])):(s="x"===e?i:t.coords.usrCoords[1],r="y"===e?i:t.coords.usrCoords[2],t.addConstraint([s,r])),this.board.update())},_genericParse:function(t,e,i,s){var r,o,n,a,l=t.replace(/\r\n/g,"\n").split("\n"),h=[];s||(this.code+=t+"\n"),_base_text_js__WEBPACK_IMPORTED_MODULE_2__.A&&(o=_base_text_js__WEBPACK_IMPORTED_MODULE_2__.A.prototype.setText,_base_text_js__WEBPACK_IMPORTED_MODULE_2__.A.prototype.setText=_base_text_js__WEBPACK_IMPORTED_MODULE_2__.A.prototype.setTextJessieCode);try{for(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(i)||(i=!1),r=0;r<l.length;r++)i&&(l[r]=_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.GeonextParser.geonext2JS(l[r],this.board)),h.push(l[r]);switch(t=h.join("\n"),n=parser.parse(t),this.CA&&(n=this.CA.expandDerivatives(n,null,n),n=this.CA.removeTrivialNodes(n)),e){case"parse":a=this.execute(n);break;case"manipulate":a=this.compile(n);break;case"getAst":a=n;break;default:a=!1}}catch(t){throw t}finally{_base_text_js__WEBPACK_IMPORTED_MODULE_2__.A&&(_base_text_js__WEBPACK_IMPORTED_MODULE_2__.A.prototype.setText=o)}return a},parse:function(t,e,i){return this._genericParse(t,"parse",e,i)},manipulate:function(t,e,i){return this._genericParse(t,"manipulate",e,i)},getAST:function(t,e,i){return this._genericParse(t,"getAst",e,i)},snippet:function(t,e,i,s,r){var o;return e=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.def(e,!0),i=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.def(i,""),s=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.def(s,!1),this.forceValueCall=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.def(r,!0),o=(e?" function ("+i+") { return ":"")+t+(e?"; }":"")+";",this.parse(o,s,!0)},replaceIDs:function(t){var e,i;if(t.replaced&&(i=this.board.objects[t.children[1][0].value],_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(i)&&""!==i.name&&(t.type="node_var",t.value=i.name,t.children.length=0,delete t.replaced)),_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(t))for(e=0;e<t.length;e++)t[e]=this.replaceIDs(t[e]);if(t.children)for(e=t.children.length;e>0;e--)_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.children[e-1])&&(t.children[e-1]=this.replaceIDs(t.children[e-1]));return t},replaceNames:function(t,e){var i,s,r=!1;if(void 0!==e&&(r=e),s=t.value,"node_op"===t.type&&"op_lhs"===s&&1===t.children.length?this.isLHS=!0:"node_var"===t.type&&(this.isLHS?this.letvar(s,!0):!_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(this.getvar(s,!0))&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(this.board.elementsByName[s])&&(r&&"slider"!==this.board.elementsByName[s].elType&&(r=!1),t=this.createReplacementNode(t,r))),_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(t))for(i=0;i<t.length;i++)t[i]=this.replaceNames(t[i],r);if(t.children)for(this.forceValueCall&&("op_execfun"===t.value&&"V"!==t.children[0].value&&"$"!==t.children[0].value&&(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(Math[t.children[0].value])||_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A[t.children[0].value]))&&"node_var"===t.children[1][0].type||"op_return"===t.value&&1===t.children.length&&"node_var"===t.children[0].type)&&(r=!0),i=t.children.length;i>0;i--)_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.children[i-1])&&(t.children[i-1]=this.replaceNames(t.children[i-1],r));return"node_op"===t.type&&"op_lhs"===t.value&&1===t.children.length&&(this.isLHS=!1),t},createReplacementNode:function(t,e){var i=t.value,s=this.board.elementsByName[i];return(t=this.createNode("node_op","op_execfun",this.createNode("node_var",!0===e?"$value":"$"),[this.createNode("node_str",s.id)])).replaced=!0,t},collectDependencies:function(t,e,i){var s,r,o,n;if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(t))for(n=t.length,s=0;s<n;s++)this.collectDependencies(t[s],e,i);else if(r=t.value,"node_var"===t.type&&e.indexOf(r)<0&&(o=this.getvar(r))&&o.visProp&&o.elType&&o.elementClass&&o.id&&"slider"===o.elType&&(i[o.id]=o),"node_op"===t.type&&"op_execfun"===t.value&&t.children.length>1&&"$"===t.children[0].value&&t.children[1].length>0&&(i[o=t.children[1][0].value]=this.board.objects[o]),t.children)for(s=t.children.length;s>0;s--)_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.children[s-1])&&this.collectDependencies(t.children[s-1],e,i)},resolveProperty:function(t,e,i){return i=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.def(i,!1),t&&t.methodMap&&(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.subs)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.subs[e])?t=t.subs:_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.methodMap[e])?e=t.methodMap[e]:(t=t.visProp,e=e.toLowerCase())),_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isFunction(t)&&this._error("Accessing function properties is not allowed."),_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t)||this._error(t+" is not an object"),_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t[e])||this._error("unknown property "+e),i&&"function"==typeof t[e]?function(){return t[e].apply(t,arguments)}:t[e]},resolveType:function(t,e){var i,s;if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(e))for(i=0;i<e.length;i++)if("any"!==(s=this.resolveType(t,e[i])))return s;if("node_op"===e.type&&"op_execfun"===e.value&&"node_var"===e.children[0].type&&e.children[0].value===t)return"function";if("node_op"===e.type){for(i=0;i<e.children.length;i++)if("node_var"===e.children[0].type&&e.children[0].value===t&&("op_add"===e.value||"op_sub"===e.value||"op_mul"===e.value||"op_div"===e.value||"op_mod"===e.value||"op_exp"===e.value||"op_neg"===e.value))return"any";for(i=0;i<e.children.length;i++)if("any"!==(s=this.resolveType(t,e.children[i])))return s}return"any"},getLHS:function(t){var e;if("node_var"===t.type)e={o:this.scope.locals,what:t.value};else if("node_op"===t.type&&"op_property"===t.value)e={o:this.execute(t.children[0]),what:t.children[1]};else{if("node_op"!==t.type||"op_extvalue"!==t.value)throw new Error("Syntax error: Invalid left-hand side of assignment.");e={o:this.execute(t.children[0]),what:this.execute(t.children[1])}}return e},getLHSCompiler:function(t,e){var i;if("node_var"===t.type)i=t.value;else if("node_op"===t.type&&"op_property"===t.value)i=[this.compile(t.children[0],e),"'"+t.children[1]+"'"];else{if("node_op"!==t.type||"op_extvalue"!==t.value)throw new Error("Syntax error: Invalid left-hand side of assignment.");i=[this.compile(t.children[0],e),"node_const"===t.children[1].type?t.children[1].value:this.compile(t.children[1],e)]}return i},execute:function(t){var e,i,s,r,o,n,a,l,h,u,c=[];if(e=0,!t)return e;switch(this.line=t.line,this.col=t.col,t.type){case"node_op":switch(t.value){case"op_none":t.children[0]&&this.execute(t.children[0]),t.children[1]&&(e=this.execute(t.children[1]));break;case"op_assign":i=this.getLHS(t.children[0]),this.lhs[this.scope.id]=i.what,i.o.type&&i.o.elementClass&&i.o.methodMap&&"label"===i.what&&this._error("Left-hand side of assignment is read-only."),e=this.execute(t.children[1]),i.o!==this.scope.locals||_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(i.o)&&"number"==typeof i.what?this.setProp(i.o,i.what,e):this.letvar(i.what,e),this.lhs[this.scope.id]=0;break;case"op_if":this.execute(t.children[0])&&(e=this.execute(t.children[1]));break;case"op_conditional":case"op_if_else":e=this.execute(t.children[0])?this.execute(t.children[1]):this.execute(t.children[2]);break;case"op_while":for(;this.execute(t.children[0]);)this.execute(t.children[1]);break;case"op_do":do{this.execute(t.children[0])}while(this.execute(t.children[1]));break;case"op_for":for(this.execute(t.children[0]);this.execute(t.children[1]);this.execute(t.children[2]))this.execute(t.children[3]);break;case"op_proplst":t.children[0]&&this.execute(t.children[0]),t.children[1]&&this.execute(t.children[1]);break;case"op_emptyobject":e={};break;case"op_proplst_val":this.propstack.push({}),this.propscope++,this.execute(t.children[0]),e=this.propstack[this.propscope],this.propstack.pop(),this.propscope--;break;case"op_prop":this.propstack[this.propscope][t.children[0]]=this.execute(t.children[1]);break;case"op_array":for(e=[],o=t.children[0].length,s=0;s<o;s++)e.push(this.execute(t.children[0][s]));break;case"op_extvalue":e=this.execute(t.children[0]),e="number"==typeof(s=this.execute(t.children[1]))&&Math.abs(Math.round(s)-s)<_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.eps?e[s]:undefined;break;case"op_return":if(0!==this.scope)return this.execute(t.children[0]);this._error("Unexpected return.");break;case"op_map":t.children[1].isMath||"node_var"===t.children[1].type||this._error("execute: In a map only function calls and mathematical expressions are allowed."),(l=this.defineFunction(t)).isMap=!0,e=l;break;case"op_function":(l=this.defineFunction(t)).isMap=!1,e=l;break;case"op_execfun":if(this.dpstack.push([]),this.pscope++,n=t.children[1],_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.children[2]))if(t.children[3])for(a=t.children[2],h={},s=0;s<a.length;s++)h=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.deepCopy(h,this.execute(a[s]),!0);else h=this.execute(t.children[2]);for(t.children[0]._isFunctionName=!0,l=this.execute(t.children[0]),delete t.children[0]._isFunctionName,u=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(l)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(l.sc)?l.sc:this,!l.creator&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.children[2])&&this._error("Unexpected value. Only element creators are allowed to have a value after the function call."),s=0;s<n.length;s++)_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(l.scope)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(l.scope.argtypes)&&"function"===l.scope.argtypes[s]?(n[s]._isFunctionName=!0,c[s]=this.execute(n[s]),delete n[s]._isFunctionName):c[s]=this.execute(n[s]),this.dpstack[this.pscope].push({line:t.children[1][s].line,col:t.children[1][s].ecol});if("function"!=typeof l||l.creator)if("function"==typeof l&&l.creator){r=this.line;try{for((e=l(c,h)).jcLineStart=r,e.jcLineEnd=t.eline,s=r;s<=t.line;s++)this.lineToElement[s]=e;e.debugParents=this.dpstack[this.pscope]}catch(t){this._error(t.toString())}}else this._error("Function '"+l+"' is undefined.");else e=l.apply(u,c);this.dpstack.pop(),this.pscope--;break;case"op_property":r=this.execute(t.children[0]),i=t.children[1],e=this.resolveProperty(r,i,!1),_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(e)&&["number","string","boolean"].indexOf(typeof e)<0&&(e.sc=r);break;case"op_use":this._warn("Use of the 'use' operator is deprecated."),this.use(t.children[0].toString());break;case"op_delete":this._warn("Use of the 'delete' operator is deprecated. Please use the remove() function."),i=this.getvar(t.children[0]),e=this.del(i);break;case"op_eq":e=this.execute(t.children[0])==this.execute(t.children[1]);break;case"op_neq":e=this.execute(t.children[0])!=this.execute(t.children[1]);break;case"op_approx":e=Math.abs(this.execute(t.children[0])-this.execute(t.children[1]))<_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.eps;break;case"op_gt":e=this.execute(t.children[0])>this.execute(t.children[1]);break;case"op_lt":e=this.execute(t.children[0])<this.execute(t.children[1]);break;case"op_geq":e=this.execute(t.children[0])>=this.execute(t.children[1]);break;case"op_leq":e=this.execute(t.children[0])<=this.execute(t.children[1]);break;case"op_or":e=this.execute(t.children[0])||this.execute(t.children[1]);break;case"op_and":e=this.execute(t.children[0])&&this.execute(t.children[1]);break;case"op_not":e=!this.execute(t.children[0]);break;case"op_add":e=this.add(this.execute(t.children[0]),this.execute(t.children[1]));break;case"op_sub":e=this.sub(this.execute(t.children[0]),this.execute(t.children[1]));break;case"op_div":e=this.div(this.execute(t.children[0]),this.execute(t.children[1]));break;case"op_mod":e=this.mod(this.execute(t.children[0]),this.execute(t.children[1]),!0);break;case"op_mul":e=this.mul(this.execute(t.children[0]),this.execute(t.children[1]));break;case"op_exp":e=this.pow(this.execute(t.children[0]),this.execute(t.children[1]));break;case"op_neg":e=this.neg(this.execute(t.children[0]))}break;case"node_var":e=this.getvar(t.value,!1,t._isFunctionName);break;case"node_const":e=null===t.value?null:Number(t.value);break;case"node_const_bool":e=t.value;break;case"node_str":e=t.value.replace(/\\(.)/g,"$1")}return e},compile:function(t,e){var i,s,r,o="";if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(e)||(e=!1),!t)return o;switch(t.type){case"node_op":switch(t.value){case"op_none":t.children[0]&&(o=this.compile(t.children[0],e)),t.children[1]&&(o+=this.compile(t.children[1],e));break;case"op_assign":e?(i=this.getLHSCompiler(t.children[0],e),_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(i)?o="$jc$.setProp("+i[0]+", "+i[1]+", "+this.compile(t.children[1],e)+");\n":(this.isLocalVariable(i)!==this.scope&&(this.scope.locals[i]=!0),o="$jc$.scopes["+this.scope.id+"].locals['"+i+"'] = "+this.compile(t.children[1],e)+";\n")):o=(i=this.compile(t.children[0]))+" = "+this.compile(t.children[1],e)+";\n";break;case"op_if":o=" if ("+this.compile(t.children[0],e)+") "+this.compile(t.children[1],e);break;case"op_if_else":o=" if ("+this.compile(t.children[0],e)+")"+this.compile(t.children[1],e),o+=" else "+this.compile(t.children[2],e);break;case"op_conditional":o="(("+this.compile(t.children[0],e)+")?("+this.compile(t.children[1],e),o+="):("+this.compile(t.children[2],e)+"))";break;case"op_while":o=" while ("+this.compile(t.children[0],e)+") {\n"+this.compile(t.children[1],e)+"}\n";break;case"op_do":o=" do {\n"+this.compile(t.children[0],e)+"} while ("+this.compile(t.children[1],e)+");\n";break;case"op_for":o=" for ("+this.compile(t.children[0],e)+this.compile(t.children[1],e)+"; "+this.compile(t.children[2],e).slice(0,-2)+") {\n"+this.compile(t.children[3],e)+"\n}\n";break;case"op_proplst":t.children[0]&&(o=this.compile(t.children[0],e)+", "),o+=this.compile(t.children[1],e);break;case"op_prop":o=t.children[0]+": "+this.compile(t.children[1],e);break;case"op_emptyobject":o=e?"{}":"<< >>";break;case"op_proplst_val":o=this.compile(t.children[0],e);break;case"op_array":for(r=[],s=0;s<t.children[0].length;s++)r.push(this.compile(t.children[0][s],e));o="["+r.join(", ")+"]";break;case"op_extvalue":o=this.compile(t.children[0],e)+"["+this.compile(t.children[1],e)+"]";break;case"op_return":o=" return "+this.compile(t.children[0],e)+";\n";break;case"op_map":t.children[1].isMath||"node_var"===t.children[1].type||this._error("compile: In a map only function calls and mathematical expressions are allowed."),r=t.children[0],o=e?" $jc$.makeMap(function ("+r.join(", ")+") { return "+this.compile(t.children[1],e)+"; })":"map ("+r.join(", ")+") -> "+this.compile(t.children[1],e);break;case"op_function":r=t.children[0],this.pushScope(r),o=e?this.functionCodeJS(t):" function ("+r.join(", ")+") "+this.compile(t.children[1],e),this.popScope();break;case"op_execfunmath":console.log("op_execfunmath: TODO"),o="-1";break;case"op_execfun":if(t.children[2]){for(r=[],s=0;s<t.children[2].length;s++)r.push(this.compile(t.children[2][s],e));i=e?"$jc$.mergeAttributes("+r.join(", ")+")":r.join(", ")}for(t.children[0].withProps=!!t.children[2],r=[],s=0;s<t.children[1].length;s++)r.push(this.compile(t.children[1][s],e));o=this.compile(t.children[0],e)+"("+r.join(", ")+(t.children[2]&&e?", "+i:"")+")"+(t.children[2]&&!e?" "+i:""),e&&(o+="\n"),e&&"$"===t.children[0].value&&(o="$jc$.board.objects["+this.compile(t.children[1][0],e)+"]");break;case"op_property":o=e&&"X"!==t.children[1]&&"Y"!==t.children[1]?"$jc$.resolveProperty("+this.compile(t.children[0],e)+", '"+t.children[1]+"', true)":this.compile(t.children[0],e)+"."+t.children[1];break;case"op_use":this._warn("Use of the 'use' operator is deprecated."),o=e?"$jc$.use('":"use('",o+=t.children[0].toString()+"');";break;case"op_delete":this._warn("Use of the 'delete' operator is deprecated. Please use the remove() function."),o=e?"$jc$.del(":"remove(",o+=this.compile(t.children[0],e)+")";break;case"op_eq":o="("+this.compile(t.children[0],e)+" === "+this.compile(t.children[1],e)+")";break;case"op_neq":o="("+this.compile(t.children[0],e)+" !== "+this.compile(t.children[1],e)+")";break;case"op_approx":o="("+this.compile(t.children[0],e)+" ~= "+this.compile(t.children[1],e)+")";break;case"op_gt":o=e?"$jc$.gt("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" > "+this.compile(t.children[1],e)+")";break;case"op_lt":o=e?"$jc$.lt("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" < "+this.compile(t.children[1],e)+")";break;case"op_geq":o=e?"$jc$.geq("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" >= "+this.compile(t.children[1],e)+")";break;case"op_leq":o=e?"$jc$.leq("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" <= "+this.compile(t.children[1],e)+")";break;case"op_or":o="("+this.compile(t.children[0],e)+" || "+this.compile(t.children[1],e)+")";break;case"op_and":o="("+this.compile(t.children[0],e)+" && "+this.compile(t.children[1],e)+")";break;case"op_not":o="!("+this.compile(t.children[0],e)+")";break;case"op_add":o=e?"$jc$.add("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" + "+this.compile(t.children[1],e)+")";break;case"op_sub":o=e?"$jc$.sub("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" - "+this.compile(t.children[1],e)+")";break;case"op_div":o=e?"$jc$.div("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" / "+this.compile(t.children[1],e)+")";break;case"op_mod":o=e?"$jc$.mod("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+", true)":"("+this.compile(t.children[0],e)+" % "+this.compile(t.children[1],e)+")";break;case"op_mul":o=e?"$jc$.mul("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" * "+this.compile(t.children[1],e)+")";break;case"op_exp":o=e?"$jc$.pow("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+"^"+this.compile(t.children[1],e)+")";break;case"op_neg":o=e?"$jc$.neg("+this.compile(t.children[0],e)+")":"(-"+this.compile(t.children[0],e)+")"}break;case"node_var":o=e?this.getvarJS(t.value,!1,t.withProps):t.value;break;case"node_const":case"node_const_bool":o=t.value;break;case"node_str":o="'"+t.value+"'"}return t.needsBrackets&&(o="{\n"+o+" }\n"),t.needsAngleBrackets&&(o=e?"{\n"+o+" }\n":"<< "+o+" >>\n"),o},getName:function(t,e){var i="";return _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.getName)?(i=t.getName(),_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(i)&&""!==i||!e||(i=t.id)):e&&(i=t.id),i},X:function(t){return t.X()},Y:function(t){return t.Y()},V:function(t){return t.Value()},L:function(t){return t.L()},area:function(t){return _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.Area)||this._error("Error: Can't calculate area."),t.Area()},perimeter:function(t){return _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.Perimeter)||this._error("Error: Can't calculate perimeter."),t.Perimeter()},dist:function(t,e){return _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.Dist)||this._error("Error: Can't calculate distance."),t.Dist(e)},radius:function(t){return _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.Radius)||this._error("Error: Can't calculate radius."),t.Radius()},slope:function(t){return _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(t.Slope)||this._error("Error: Can't calculate slope."),t.Slope()},add:function(t,e){var i,s,r;if(t=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(t),e=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(e),_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(t)||_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(e))r=_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.add(t,e);else if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(e))for(s=Math.min(t.length,e.length),r=[],i=0;i<s;i++)r[i]=t[i]+e[i];else _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(e)?r=t+e:_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isString(t)||_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isString(e)?r=t.toString()+e.toString():this._error("Operation + not defined on operands "+typeof t+" and "+typeof e);return r},sub:function(t,e){var i,s,r;if(t=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(t),e=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(e),_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(t)||_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(e))r=_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.sub(t,e);else if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(e))for(s=Math.min(t.length,e.length),r=[],i=0;i<s;i++)r[i]=t[i]-e[i];else _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(e)?r=t-e:this._error("Operation - not defined on operands "+typeof t+" and "+typeof e);return r},neg:function(t){var e,i,s;if(t=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(t),_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(t))s=_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.negative(t);else if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(t))for(i=t.length,s=[],e=0;e<i;e++)s[e]=-t[e];else _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(t)?s=-t:this._error("Unary operation - not defined on operand "+typeof t);return s},mul:function(t,e){var i,s,r;if(t=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(t),e=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(e),_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(e)&&(i=t,e=t=e),_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(t)||_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(e))r=_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.mul(t,e);else if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(e))s=Math.min(t.length,e.length),r=_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.innerProduct(t,e,s);else if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(e))for(s=e.length,r=[],i=0;i<s;i++)r[i]=t*e[i];else _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(e)?r=t*e:this._error("Operation * not defined on operands "+typeof t+" and "+typeof e);return r},div:function(t,e){var i,s,r;if(t=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(t),e=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(e),_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(t)||_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(e))r=_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.div(t,e);else if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(e))for(s=t.length,r=[],i=0;i<s;i++)r[i]=t[i]/e;else _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(e)?r=t/e:this._error("Operation * not defined on operands "+typeof t+" and "+typeof e);return r},mod:function(t,e){var i,s,r;if(t=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(t),e=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(e),_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(t)||_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(e))return _math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.fmod(t,e);if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isArray(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(e))for(s=t.length,r=[],i=0;i<s;i++)r[i]=_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.mod(t[i],e,!0);else _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(t)&&_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.isNumber(e)?r=_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.mod(t,e,!0):this._error("Operation * not defined on operands "+typeof t+" and "+typeof e);return r},pow:function(t,e){return t=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(t),e=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.evalSlider(e),_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(t)||_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(e)?_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.pow(t,e):_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.pow(t,e)},lt:function(t,e){return _math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(t)||_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(e)?_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.lt(t,e):t<e},leq:function(t,e){return _math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(t)||_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(e)?_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.leq(t,e):t<=e},gt:function(t,e){return _math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(t)||_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(e)?_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.gt(t,e):t>e},geq:function(t,e){return _math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(t)||_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.isInterval(e)?_math_ia_js__WEBPACK_IMPORTED_MODULE_4__.A.geq(t,e):t>=e},randint:function(t,e,i){return _utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(i)||(i=1),Math.round(Math.random()*(e-t)/i)*i+t},DDD:function(t){console.log("Dummy derivative function. This should never appear!")},ifthen:function(t,e,i){return t?e:i},del:function(t){"object"==typeof t&&_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.exists(t.type)&&_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.exists(t.elementClass)&&this.board.removeObject(t)},eval:function(t){return _jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.evaluate(t)},use:function(t){var e,i,s=!1;if("string"==typeof t){for(e in _jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.boards)if(_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.boards.hasOwnProperty(e)&&_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.boards[e].container===t){i=_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.boards[e],s=!0;break}}else i=t,s=!0;s?(this.board=i,this.builtIn.$board=i,this.builtIn.$board.src="$jc$.board"):this._error("Board '"+t+"' not found!")},findSymbol:function(t,e){var i,s;for(s=-1===(e=_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.def(e,-1))?this.scope:this.scopes[e];null!==s;){for(i in s.locals)if(s.locals.hasOwnProperty(i)&&s.locals[i]===t)return[i,s];s=s.previous}return[]},importModule:function(t){return priv.modules[t.toLowerCase()]},defineBuiltIn:function(){var t=this,e={PI:Math.PI,EULER:Math.E,D:t.DDD,X:t.X,Y:t.Y,V:t.V,Value:t.V,L:t.L,Length:t.L,acosh:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.acosh,acot:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.acot,asinh:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.asinh,binomial:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.binomial,cbrt:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.cbrt,cosh:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.cosh,cot:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.cot,deg:_math_geometry_js__WEBPACK_IMPORTED_MODULE_5__.A.trueAngle,A:t.area,area:t.area,Area:t.area,perimeter:t.perimeter,Perimeter:t.perimeter,dist:t.dist,Dist:t.dist,R:t.radius,radius:t.radius,Radius:t.radius,erf:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.erf,erfc:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.erfc,erfi:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.erfi,factorial:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.factorial,gcd:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.gcd,lb:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.log2,lcm:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.lcm,ld:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.log2,lg:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.log10,ln:Math.log,log:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.log,log10:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.log10,log2:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.log2,ndtr:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.ndtr,ndtri:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.ndtri,nthroot:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.nthroot,pow:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.pow,rad:_math_geometry_js__WEBPACK_IMPORTED_MODULE_5__.A.rad,ratpow:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.ratpow,trunc:_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.trunc,sinh:_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A.sinh,slope:t.slope,Slope:t.slope,randint:t.randint,IfThen:t.ifthen,import:t.importModule,eval:t.eval,use:t.use,remove:t.del,$:t.getElementById,$value:function(e){return t.getElementById(e).Value()},getName:t.getName,name:t.getName,$board:t.board,$log:t.log};return e.rad.sc=_math_geometry_js__WEBPACK_IMPORTED_MODULE_5__.A,e.deg.sc=_math_geometry_js__WEBPACK_IMPORTED_MODULE_5__.A,e.factorial.sc=_math_math_js__WEBPACK_IMPORTED_MODULE_3__.A,e.X.src="$jc$.X",e.Y.src="$jc$.Y",e.V.src="$jc$.V",e.Value.src="$jc$.V",e.L.src="$jc$.L",e.Length.src="$jc$.L",e.acosh.src="JXG.Math.acosh",e.acot.src="JXG.Math.acot",e.asinh.src="JXG.Math.asinh",e.binomial.src="JXG.Math.binomial",e.cbrt.src="JXG.Math.cbrt",e.cot.src="JXG.Math.cot",e.cosh.src="JXG.Math.cosh",e.deg.src="JXG.Math.Geometry.trueAngle",e.erf.src="JXG.Math.erf",e.erfc.src="JXG.Math.erfc",e.erfi.src="JXG.Math.erfi",e.A.src="$jc$.area",e.area.src="$jc$.area",e.Area.src="$jc$.area",e.perimeter.src="$jc$.perimeter",e.Perimeter.src="$jc$.perimeter",e.dist.src="$jc$.dist",e.Dist.src="$jc$.dist",e.R.src="$jc$.radius",e.radius.src="$jc$.radius",e.Radius.src="$jc$.radius",e.factorial.src="JXG.Math.factorial",e.gcd.src="JXG.Math.gcd",e.lb.src="JXG.Math.log2",e.lcm.src="JXG.Math.lcm",e.ld.src="JXG.Math.log2",e.lg.src="JXG.Math.log10",e.ln.src="Math.log",e.log.src="JXG.Math.log",e.log10.src="JXG.Math.log10",e.log2.src="JXG.Math.log2",e.ndtr.src="JXG.Math.ndtr",e.ndtri.src="JXG.Math.ndtri",e.nthroot.src="JXG.Math.nthroot",e.pow.src="JXG.Math.pow",e.rad.src="JXG.Math.Geometry.rad",e.ratpow.src="JXG.Math.ratpow",e.trunc.src="JXG.trunc",e.sinh.src="JXG.Math.sinh",e.slope.src="$jc$.slope",e.Slope.src="$jc$.slope",e.randint.src="$jc$.randint",e.import.src="$jc$.importModule",e.eval.src="$jc$.eval",e.use.src="$jc$.use",e.remove.src="$jc$.del",e.IfThen.src="$jc$.ifthen",e.$.src="(function (n) { return $jc$.board.select(n); })",e.$value.src="(function (n) { return $jc$.board.select(n).Value(); })",e.getName.src="$jc$.getName",e.name.src="$jc$.getName",e.$board&&(e.$board.src="$jc$.board"),e.$log.src="$jc$.log",e=_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.merge(e,t._addedBuiltIn)},_addedBuiltIn:{},addBuiltIn:function(t,e){if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(this.builtIn)){if(_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(this.builtIn[t]))return;this.builtIn[t]=e,this.builtIn[t].src="$jc$."+t}_utils_type_js__WEBPACK_IMPORTED_MODULE_7__.A.exists(this._addedBuiltIn[t])||(this._addedBuiltIn[t]=e,this._addedBuiltIn[t].src="$jc$."+t,_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.JessieCode.prototype[t]=e)},getPossibleOperands:function(){var t,e,i,s,r,o,n,a,l,h,u,c,d,p,_=["E"],f=this.builtIn||this.defineBuiltIn(),A=Math;for(d=function(t,e){return t.toLowerCase().localeCompare(e.toLowerCase())},p=function(t,e){var i=null;if("jc"===e)i=f[t];else{if("Math"!==e)return;i=A[t]}if(!(_.indexOf(t)>=0))return _jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.isFunction(i)?{name:t,type:"function",numParams:i.length,origin:e}:_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.isNumber(i)?{name:t,type:"constant",value:i,origin:e}:void(t.startsWith("$")||void 0!==i&&console.error("undefined type",i))},t=Object.getOwnPropertyNames(f).sort(d),e=Object.getOwnPropertyNames(A).sort(d),i=[],s=0,r=0;s<t.length||r<e.length;)t[s]===e[r]?(o=p(e[r],"Math"),_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.exists(o)&&i.push(o),s++,r++):!_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.exists(e[r])||t[s].toLowerCase().localeCompare(e[r].toLowerCase())<0?(o=p(t[s],"jc"),_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.exists(o)&&i.push(o),s++):(o=p(e[r],"Math"),_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.exists(o)&&i.push(o),r++);for(l=[],h=[],u=[],c={},n=i.length,s=0;s<n;s++){switch((a=i[s]).type){case"function":l.push(a.name),"jc"===a.origin&&h.push(a.name);break;case"constant":u.push(a.name)}c[a.name]=a}return{all:c,list:i,functions:l,functions_jessiecode:h,constants:u}},_debug:function(t){"object"==typeof console?console.log(t):_utils_env_js__WEBPACK_IMPORTED_MODULE_8__.A.isBrowser&&document&&null!==document.getElementById("debug")&&(document.getElementById("debug").innerHTML+=t+"<br />")},_error:function(t){var e=new Error("Error("+this.line+"): "+t);throw e.line=this.line,e},_warn:function(t){"object"==typeof console?console.log("Warning("+this.line+"): "+t):_utils_env_js__WEBPACK_IMPORTED_MODULE_8__.A.isBrowser&&document&&null!==document.getElementById(this.warnLog)&&(document.getElementById(this.warnLog).innerHTML+="Warning("+this.line+"): "+t+"<br />")},_log:function(t){"object"!=typeof window&&"object"==typeof self&&self.postMessage?self.postMessage({type:"log",msg:"Log: "+t.toString()}):console.log("Log: ",arguments)}});var parser=function(){var t=function(t,e,i,s){for(i=i||{},s=t.length;s--;i[t[s]]=e);return i},e=[2,14],i=[1,13],s=[1,37],r=[1,14],o=[1,15],n=[1,21],a=[1,16],l=[1,17],h=[1,33],u=[1,18],c=[1,19],d=[1,12],p=[1,59],_=[1,60],f=[1,58],A=[1,46],g=[1,48],m=[1,49],y=[1,50],b=[1,51],v=[1,52],C=[1,53],P=[1,54],x=[1,45],E=[1,38],O=[1,39],S=[5,7,8,14,15,16,17,19,20,21,23,26,27,50,51,58,65,74,75,76,77,78,79,80,82,91,93],M=[5,7,8,12,14,15,16,17,19,20,21,23,26,27,50,51,58,65,74,75,76,77,78,79,80,82,91,93],w=[8,10,16,32,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,57,64,65,66,83,86],T=[2,48],N=[1,72],j=[10,16,32,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,57,66,83,86],D=[1,78],k=[8,10,16,32,34,35,37,41,42,43,45,46,47,48,50,51,53,54,55,57,64,65,66,83,86],R=[1,82],L=[8,10,16,32,34,35,37,39,45,46,47,48,50,51,53,54,55,57,64,65,66,83,86],B=[1,83],I=[1,84],Y=[1,85],X=[8,10,16,32,34,35,37,39,41,42,43,50,51,53,54,55,57,64,65,66,83,86],U=[1,89],F=[1,90],z=[1,91],J=[1,92],G=[1,97],W=[8,10,16,32,34,35,37,39,41,42,43,45,46,47,48,53,54,55,57,64,65,66,83,86],H=[1,103],V=[1,104],$=[8,10,16,32,34,35,37,39,41,42,43,45,46,47,48,50,51,57,64,65,66,83,86],K=[1,105],q=[1,106],Z=[1,107],Q=[1,126],tt=[1,139],et=[83,86],it=[1,150],st=[10,66,86],rt=[8,10,16,20,32,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,57,64,65,66,82,83,86],ot=[1,167],nt=[10,86],at={trace:function(){},yy:{},symbols_:{error:2,Program:3,StatementList:4,EOF:5,IfStatement:6,IF:7,"(":8,Expression:9,")":10,Statement:11,ELSE:12,LoopStatement:13,WHILE:14,FOR:15,";":16,DO:17,UnaryStatement:18,USE:19,IDENTIFIER:20,DELETE:21,ReturnStatement:22,RETURN:23,EmptyStatement:24,StatementBlock:25,"{":26,"}":27,ExpressionStatement:28,AssignmentExpression:29,ConditionalExpression:30,LeftHandSideExpression:31,"=":32,LogicalORExpression:33,"?":34,":":35,LogicalANDExpression:36,"||":37,EqualityExpression:38,"&&":39,RelationalExpression:40,"==":41,"!=":42,"~=":43,AdditiveExpression:44,"<":45,">":46,"<=":47,">=":48,MultiplicativeExpression:49,"+":50,"-":51,UnaryExpression:52,"*":53,"/":54,"%":55,ExponentExpression:56,"^":57,"!":58,MemberExpression:59,CallExpression:60,PrimaryExpression:61,FunctionExpression:62,MapExpression:63,".":64,"[":65,"]":66,BasicLiteral:67,ObjectLiteral:68,ArrayLiteral:69,NullLiteral:70,BooleanLiteral:71,StringLiteral:72,NumberLiteral:73,NULL:74,TRUE:75,FALSE:76,STRING:77,NUMBER:78,NAN:79,INFINITY:80,ElementList:81,"<<":82,">>":83,PropertyList:84,Property:85,",":86,PropertyName:87,Arguments:88,AttributeList:89,Attribute:90,FUNCTION:91,ParameterDefinitionList:92,MAP:93,"->":94,$accept:0,$end:1},terminals_:{2:"error",5:"EOF",7:"IF",8:"(",10:")",12:"ELSE",14:"WHILE",15:"FOR",16:";",17:"DO",19:"USE",20:"IDENTIFIER",21:"DELETE",23:"RETURN",26:"{",27:"}",32:"=",34:"?",35:":",37:"||",39:"&&",41:"==",42:"!=",43:"~=",45:"<",46:">",47:"<=",48:">=",50:"+",51:"-",53:"*",54:"/",55:"%",57:"^",58:"!",64:".",65:"[",66:"]",74:"NULL",75:"TRUE",76:"FALSE",77:"STRING",78:"NUMBER",79:"NAN",80:"INFINITY",82:"<<",83:">>",86:",",91:"FUNCTION",93:"MAP",94:"->"},productions_:[0,[3,2],[6,5],[6,7],[13,5],[13,9],[13,7],[18,2],[18,2],[22,2],[22,3],[24,1],[25,3],[4,2],[4,0],[11,1],[11,1],[11,1],[11,1],[11,1],[11,1],[11,1],[28,2],[9,1],[29,1],[29,3],[30,1],[30,5],[33,1],[33,3],[36,1],[36,3],[38,1],[38,3],[38,3],[38,3],[40,1],[40,3],[40,3],[40,3],[40,3],[44,1],[44,3],[44,3],[49,1],[49,3],[49,3],[49,3],[56,1],[56,3],[52,1],[52,2],[52,2],[52,2],[31,1],[31,1],[59,1],[59,1],[59,1],[59,3],[59,4],[61,1],[61,1],[61,1],[61,1],[61,3],[67,1],[67,1],[67,1],[67,1],[70,1],[71,1],[71,1],[72,1],[73,1],[73,1],[73,1],[69,2],[69,3],[68,2],[68,3],[84,1],[84,3],[85,3],[87,1],[87,1],[87,1],[60,2],[60,3],[60,2],[60,4],[60,3],[88,2],[88,3],[89,1],[89,3],[90,1],[90,1],[81,1],[81,3],[62,4],[62,5],[63,5],[63,6],[92,1],[92,3]],performAction:function(t,e,i,s,r,o,n){var a=o.length-1;switch(r){case 1:return o[a-1];case 2:this.$=lt.createNode(ht(n[a-4]),"node_op","op_if",o[a-2],o[a]);break;case 3:this.$=lt.createNode(ht(n[a-6]),"node_op","op_if_else",o[a-4],o[a-2],o[a]);break;case 4:this.$=lt.createNode(ht(n[a-4]),"node_op","op_while",o[a-2],o[a]);break;case 5:this.$=lt.createNode(ht(n[a-8]),"node_op","op_for",o[a-6],o[a-4],o[a-2],o[a]);break;case 6:this.$=lt.createNode(ht(n[a-6]),"node_op","op_do",o[a-5],o[a-2]);break;case 7:this.$=lt.createNode(ht(n[a-1]),"node_op","op_use",o[a]);break;case 8:this.$=lt.createNode(ht(n[a-1]),"node_op","op_delete",o[a]);break;case 9:this.$=lt.createNode(ht(n[a-1]),"node_op","op_return",void 0);break;case 10:this.$=lt.createNode(ht(n[a-2]),"node_op","op_return",o[a-1]);break;case 11:case 14:this.$=lt.createNode(ht(n[a]),"node_op","op_none");break;case 12:this.$=o[a-1],this.$.needsBrackets=!0;break;case 13:this.$=lt.createNode(ht(n[a-1]),"node_op","op_none",o[a-1],o[a]);break;case 15:case 16:case 17:case 18:case 19:case 20:case 21:case 23:case 24:case 26:case 28:case 30:case 32:case 36:case 41:case 44:case 48:case 50:case 52:case 54:case 55:case 56:case 58:case 62:case 81:case 84:case 85:case 86:this.$=o[a];break;case 22:case 65:case 93:this.$=o[a-1];break;case 25:this.$=lt.createNode(ht(n[a-2]),"node_op","op_assign",o[a-2],o[a]),this.$.isMath=!1;break;case 27:this.$=lt.createNode(ht(n[a-4]),"node_op","op_conditional",o[a-4],o[a-2],o[a]),this.$.isMath=!1;break;case 29:this.$=lt.createNode(ht(n[a-2]),"node_op","op_or",o[a-2],o[a]),this.$.isMath=!1;break;case 31:this.$=lt.createNode(ht(n[a-2]),"node_op","op_and",o[a-2],o[a]),this.$.isMath=!1;break;case 33:this.$=lt.createNode(ht(n[a-2]),"node_op","op_eq",o[a-2],o[a]),this.$.isMath=!1;break;case 34:this.$=lt.createNode(ht(n[a-2]),"node_op","op_neq",o[a-2],o[a]),this.$.isMath=!1;break;case 35:this.$=lt.createNode(ht(n[a-2]),"node_op","op_approx",o[a-2],o[a]),this.$.isMath=!1;break;case 37:this.$=lt.createNode(ht(n[a-2]),"node_op","op_lt",o[a-2],o[a]),this.$.isMath=!1;break;case 38:this.$=lt.createNode(ht(n[a-2]),"node_op","op_gt",o[a-2],o[a]),this.$.isMath=!1;break;case 39:this.$=lt.createNode(ht(n[a-2]),"node_op","op_leq",o[a-2],o[a]),this.$.isMath=!1;break;case 40:this.$=lt.createNode(ht(n[a-2]),"node_op","op_geq",o[a-2],o[a]),this.$.isMath=!1;break;case 42:this.$=lt.createNode(ht(n[a-2]),"node_op","op_add",o[a-2],o[a]),this.$.isMath=!0;break;case 43:this.$=lt.createNode(ht(n[a-2]),"node_op","op_sub",o[a-2],o[a]),this.$.isMath=!0;break;case 45:this.$=lt.createNode(ht(n[a-2]),"node_op","op_mul",o[a-2],o[a]),this.$.isMath=!0;break;case 46:this.$=lt.createNode(ht(n[a-2]),"node_op","op_div",o[a-2],o[a]),this.$.isMath=!0;break;case 47:this.$=lt.createNode(ht(n[a-2]),"node_op","op_mod",o[a-2],o[a]),this.$.isMath=!0;break;case 49:this.$=lt.createNode(ht(n[a-2]),"node_op","op_exp",o[a-2],o[a]),this.$.isMath=!0;break;case 51:this.$=lt.createNode(ht(n[a-1]),"node_op","op_not",o[a]),this.$.isMath=!1;break;case 53:this.$=lt.createNode(ht(n[a-1]),"node_op","op_neg",o[a]),this.$.isMath=!0;break;case 57:case 63:case 64:case 66:case 67:case 68:case 97:this.$=o[a],this.$.isMath=!1;break;case 59:case 91:this.$=lt.createNode(ht(n[a-2]),"node_op","op_property",o[a-2],o[a]),this.$.isMath=!0;break;case 60:case 90:this.$=lt.createNode(ht(n[a-3]),"node_op","op_extvalue",o[a-3],o[a-1]),this.$.isMath=!0;break;case 61:this.$=lt.createNode(ht(n[a]),"node_var",o[a]);break;case 69:this.$=o[a],this.$.isMath=!0;break;case 70:this.$=lt.createNode(ht(n[a]),"node_const",null);break;case 71:this.$=lt.createNode(ht(n[a]),"node_const_bool",!0);break;case 72:this.$=lt.createNode(ht(n[a]),"node_const_bool",!1);break;case 73:this.$=lt.createNode(ht(n[a]),"node_str",o[a].substring(1,o[a].length-1));break;case 74:this.$=lt.createNode(ht(n[a]),"node_const",parseFloat(o[a]));break;case 75:this.$=lt.createNode(ht(n[a]),"node_const",NaN);break;case 76:this.$=lt.createNode(ht(n[a]),"node_const",1/0);break;case 77:this.$=lt.createNode(ht(n[a-1]),"node_op","op_array",[]);break;case 78:this.$=lt.createNode(ht(n[a-2]),"node_op","op_array",o[a-1]);break;case 79:this.$=lt.createNode(ht(n[a-1]),"node_op","op_emptyobject",{}),this.$.needsAngleBrackets=!0;break;case 80:this.$=lt.createNode(ht(n[a-2]),"node_op","op_proplst_val",o[a-1]),this.$.needsAngleBrackets=!0;break;case 82:this.$=lt.createNode(ht(n[a-2]),"node_op","op_proplst",o[a-2],o[a]);break;case 83:this.$=lt.createNode(ht(n[a-2]),"node_op","op_prop",o[a-2],o[a]);break;case 87:case 89:this.$=lt.createNode(ht(n[a-1]),"node_op","op_execfun",o[a-1],o[a]),this.$.isMath=!0;break;case 88:this.$=lt.createNode(ht(n[a-2]),"node_op","op_execfun",o[a-2],o[a-1],o[a],!0),this.$.isMath=!1;break;case 92:this.$=[];break;case 94:case 98:case 104:this.$=[o[a]];break;case 95:case 99:case 105:this.$=o[a-2].concat(o[a]);break;case 96:this.$=lt.createNode(ht(n[a]),"node_var",o[a]),this.$.isMath=!0;break;case 100:this.$=lt.createNode(ht(n[a-3]),"node_op","op_function",[],o[a]),this.$.isMath=!1;break;case 101:this.$=lt.createNode(ht(n[a-4]),"node_op","op_function",o[a-2],o[a]),this.$.isMath=!1;break;case 102:this.$=lt.createNode(ht(n[a-4]),"node_op","op_map",[],o[a]);break;case 103:this.$=lt.createNode(ht(n[a-5]),"node_op","op_map",o[a-3],o[a])}},table:[t([5,7,8,14,15,16,17,19,20,21,23,26,50,51,58,65,74,75,76,77,78,79,80,82,91,93],e,{3:1,4:2}),{1:[3]},{5:[1,3],6:6,7:i,8:s,9:20,11:4,13:7,14:r,15:o,16:n,17:a,18:8,19:l,20:h,21:u,22:9,23:c,24:11,25:5,26:d,28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{1:[2,1]},t(S,[2,13]),t(M,[2,15]),t(M,[2,16]),t(M,[2,17]),t(M,[2,18]),t(M,[2,19]),t(M,[2,20]),t(M,[2,21]),t([7,8,14,15,16,17,19,20,21,23,26,27,50,51,58,65,74,75,76,77,78,79,80,82,91,93],e,{4:61}),{8:[1,62]},{8:[1,63]},{8:[1,64]},{6:6,7:i,8:s,9:20,11:65,13:7,14:r,15:o,16:n,17:a,18:8,19:l,20:h,21:u,22:9,23:c,24:11,25:5,26:d,28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{20:[1,66]},{20:[1,67]},{8:s,9:69,16:[1,68],20:h,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{16:[1,70]},t(M,[2,11]),t(w,[2,23]),t(w,[2,24]),t([8,10,16,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,64,65,66,83,86],T,{32:[1,71],57:N}),t([8,10,16,32,35,39,41,42,43,45,46,47,48,50,51,53,54,55,57,64,65,66,83,86],[2,26],{34:[1,73],37:[1,74]}),t(j,[2,54],{88:77,8:D,64:[1,75],65:[1,76]}),t(j,[2,55],{88:79,8:D,64:[1,81],65:[1,80]}),t(k,[2,28],{39:R}),t(w,[2,56]),t(w,[2,57]),t(w,[2,58]),t(L,[2,30],{41:B,42:I,43:Y}),t(w,[2,61]),t(w,[2,62]),t(w,[2,63]),t(w,[2,64]),{8:s,9:86,20:h,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:[1,87]},{8:[1,88]},t(X,[2,32],{45:U,46:F,47:z,48:J}),t(w,[2,66]),t(w,[2,67]),t(w,[2,68]),t(w,[2,69]),{20:G,72:98,73:99,77:b,78:v,79:C,80:P,83:[1,93],84:94,85:95,87:96},{8:s,20:h,29:102,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,66:[1,100],67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,81:101,82:x,91:E,93:O},t(W,[2,36],{50:H,51:V}),t(w,[2,70]),t(w,[2,71]),t(w,[2,72]),t(w,[2,73]),t(w,[2,74]),t(w,[2,75]),t(w,[2,76]),t($,[2,41],{53:K,54:q,55:Z}),t(w,[2,44]),t(w,[2,50]),{8:s,20:h,31:109,50:p,51:_,52:108,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,50:p,51:_,52:110,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,50:p,51:_,52:111,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{6:6,7:i,8:s,9:20,11:4,13:7,14:r,15:o,16:n,17:a,18:8,19:l,20:h,21:u,22:9,23:c,24:11,25:5,26:d,27:[1,112],28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,9:113,20:h,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,9:114,20:h,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,9:115,20:h,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{14:[1,116]},t(M,[2,7]),t(M,[2,8]),t(M,[2,9]),{16:[1,117]},t(M,[2,22]),{8:s,20:h,29:118,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,50:p,51:_,52:119,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,29:120,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,36:121,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{20:[1,122]},{8:s,9:123,20:h,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},t(w,[2,87],{89:124,90:125,68:127,20:Q,82:x}),{8:s,10:[1,128],20:h,29:102,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,81:129,82:x,91:E,93:O},t(w,[2,89]),{8:s,9:130,20:h,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{20:[1,131]},{8:s,20:h,31:109,38:132,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,40:133,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,40:134,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,40:135,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{10:[1,136]},{10:[1,137],20:tt,92:138},{10:[1,140],20:tt,92:141},{8:s,20:h,31:109,44:142,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,44:143,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,44:144,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,44:145,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},t(w,[2,79]),{83:[1,146],86:[1,147]},t(et,[2,81]),{35:[1,148]},{35:[2,84]},{35:[2,85]},{35:[2,86]},t(w,[2,77]),{66:[1,149],86:it},t(st,[2,98]),{8:s,20:h,31:109,49:151,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,49:152,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,50:p,51:_,52:153,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,50:p,51:_,52:154,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,31:109,50:p,51:_,52:155,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},t(w,[2,51]),t([8,10,16,32,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,64,65,66,83,86],T,{57:N}),t(w,[2,52]),t(w,[2,53]),t([5,7,8,10,12,14,15,16,17,19,20,21,23,26,27,32,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,57,58,64,65,66,74,75,76,77,78,79,80,82,83,86,91,93],[2,12]),{10:[1,156]},{10:[1,157]},{16:[1,158]},{8:[1,159]},t(M,[2,10]),t(w,[2,25]),t(w,[2,49]),{35:[1,160]},t(k,[2,29],{39:R}),t(w,[2,59]),{66:[1,161]},t([8,10,16,32,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,57,64,65,66,83],[2,88],{86:[1,162]}),t(w,[2,94]),t(w,[2,96]),t(w,[2,97]),t(rt,[2,92]),{10:[1,163],86:it},{66:[1,164]},t(w,[2,91]),t(L,[2,31],{41:B,42:I,43:Y}),t(X,[2,33],{45:U,46:F,47:z,48:J}),t(X,[2,34],{45:U,46:F,47:z,48:J}),t(X,[2,35],{45:U,46:F,47:z,48:J}),t(w,[2,65]),{25:165,26:d},{10:[1,166],86:ot},t(nt,[2,104]),{94:[1,168]},{10:[1,169],86:ot},t(W,[2,37],{50:H,51:V}),t(W,[2,38],{50:H,51:V}),t(W,[2,39],{50:H,51:V}),t(W,[2,40],{50:H,51:V}),t(w,[2,80]),{20:G,72:98,73:99,77:b,78:v,79:C,80:P,85:170,87:96},{8:s,20:h,29:171,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},t(w,[2,78]),{8:s,20:h,29:172,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},t($,[2,42],{53:K,54:q,55:Z}),t($,[2,43],{53:K,54:q,55:Z}),t(w,[2,45]),t(w,[2,46]),t(w,[2,47]),{6:6,7:i,8:s,9:20,11:173,13:7,14:r,15:o,16:n,17:a,18:8,19:l,20:h,21:u,22:9,23:c,24:11,25:5,26:d,28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{6:6,7:i,8:s,9:20,11:174,13:7,14:r,15:o,16:n,17:a,18:8,19:l,20:h,21:u,22:9,23:c,24:11,25:5,26:d,28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,9:175,20:h,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,9:176,20:h,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,20:h,29:177,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},t(w,[2,60]),{20:Q,68:127,82:x,90:178},t(rt,[2,93]),t(w,[2,90]),t(w,[2,100]),{25:179,26:d},{20:[1,180]},{8:s,9:181,20:h,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{94:[1,182]},t(et,[2,82]),t(et,[2,83]),t(st,[2,99]),t(S,[2,2],{12:[1,183]}),t(M,[2,4]),{16:[1,184]},{10:[1,185]},t(w,[2,27]),t(w,[2,95]),t(w,[2,101]),t(nt,[2,105]),t(w,[2,102]),{8:s,9:186,20:h,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{6:6,7:i,8:s,9:20,11:187,13:7,14:r,15:o,16:n,17:a,18:8,19:l,20:h,21:u,22:9,23:c,24:11,25:5,26:d,28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{8:s,9:188,20:h,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},{16:[1,189]},t(w,[2,103]),t(M,[2,3]),{10:[1,190]},t(M,[2,6]),{6:6,7:i,8:s,9:20,11:191,13:7,14:r,15:o,16:n,17:a,18:8,19:l,20:h,21:u,22:9,23:c,24:11,25:5,26:d,28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:_,52:56,56:57,58:f,59:26,60:27,61:29,62:30,63:31,65:A,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:g,75:m,76:y,77:b,78:v,79:C,80:P,82:x,91:E,93:O},t(M,[2,5])],defaultActions:{3:[2,1],97:[2,84],98:[2,85],99:[2,86]},parseError:function(t,e){if(!e.recoverable){var i=new Error(t);throw i.hash=e,i}this.trace(t)},parse:function(t){var e=this,i=[0],s=[null],r=[],o=this.table,n="",a=0,l=0,h=0,u=r.slice.call(arguments,1),c=Object.create(this.lexer),d={yy:{}};for(var p in this.yy)Object.prototype.hasOwnProperty.call(this.yy,p)&&(d.yy[p]=this.yy[p]);c.setInput(t,d.yy),d.yy.lexer=c,d.yy.parser=this,void 0===c.yylloc&&(c.yylloc={});var _=c.yylloc;r.push(_);var f=c.options&&c.options.ranges;"function"==typeof d.yy.parseError?this.parseError=d.yy.parseError:this.parseError=Object.getPrototypeOf(this).parseError;for(var A,g,m,y,b,v,C,P,x,E=function(){var t;return"number"!=typeof(t=c.lex()||1)&&(t=e.symbols_[t]||t),t},O={};;){if(m=i[i.length-1],this.defaultActions[m]?y=this.defaultActions[m]:(null==A&&(A=E()),y=o[m]&&o[m][A]),void 0===y||!y.length||!y[0]){var S="";for(v in x=[],o[m])this.terminals_[v]&&v>2&&x.push("'"+this.terminals_[v]+"'");S=c.showPosition?"Parse error on line "+(a+1)+":\n"+c.showPosition()+"\nExpecting "+x.join(", ")+", got '"+(this.terminals_[A]||A)+"'":"Parse error on line "+(a+1)+": Unexpected "+(1==A?"end of input":"'"+(this.terminals_[A]||A)+"'"),this.parseError(S,{text:c.match,token:this.terminals_[A]||A,line:c.yylineno,loc:_,expected:x})}if(y[0]instanceof Array&&y.length>1)throw new Error("Parse Error: multiple actions possible at state: "+m+", token: "+A);switch(y[0]){case 1:i.push(A),s.push(c.yytext),r.push(c.yylloc),i.push(y[1]),A=null,g?(A=g,g=null):(l=c.yyleng,n=c.yytext,a=c.yylineno,_=c.yylloc,h>0&&h--);break;case 2:if(C=this.productions_[y[1]][1],O.$=s[s.length-C],O._$={first_line:r[r.length-(C||1)].first_line,last_line:r[r.length-1].last_line,first_column:r[r.length-(C||1)].first_column,last_column:r[r.length-1].last_column},f&&(O._$.range=[r[r.length-(C||1)].range[0],r[r.length-1].range[1]]),void 0!==(b=this.performAction.apply(O,[n,l,a,d.yy,y[1],s,r].concat(u))))return b;C&&(i=i.slice(0,-1*C*2),s=s.slice(0,-1*C),r=r.slice(0,-1*C)),i.push(this.productions_[y[1]][0]),s.push(O.$),r.push(O._$),P=o[i[i.length-2]][i[i.length-1]],i.push(P);break;case 3:return!0}}return!0}},lt={node:function(t,e,i){return{type:t,value:e,children:i}},createNode:function(t,e,i,s){var r,o=this.node(e,i,[]);for(r=3;r<arguments.length;r++)o.children.push(arguments[r]);return o.line=t[0],o.col=t[1],o.eline=t[2],o.ecol=t[3],o}},ht=function(t){return[t.first_line,t.first_column,t.last_line,t.last_column]},ut=function(){var t={EOF:1,parseError:function(t,e){if(!this.yy.parser)throw new Error(t);this.yy.parser.parseError(t,e)},setInput:function(t,e){return this.yy=e||this.yy||{},this._input=t,this._more=this._backtrack=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this.options.ranges&&(this.yylloc.range=[0,0]),this.offset=0,this},input:function(){var t=this._input[0];return this.yytext+=t,this.yyleng++,this.offset++,this.match+=t,this.matched+=t,t.match(/(?:\r\n?|\n).*/g)?(this.yylineno++,this.yylloc.last_line++):this.yylloc.last_column++,this.options.ranges&&this.yylloc.range[1]++,this._input=this._input.slice(1),t},unput:function(t){var e=t.length,i=t.split(/(?:\r\n?|\n)/g);this._input=t+this._input,this.yytext=this.yytext.substr(0,this.yytext.length-e),this.offset-=e;var s=this.match.split(/(?:\r\n?|\n)/g);this.match=this.match.substr(0,this.match.length-1),this.matched=this.matched.substr(0,this.matched.length-1),i.length-1&&(this.yylineno-=i.length-1);var r=this.yylloc.range;return this.yylloc={first_line:this.yylloc.first_line,last_line:this.yylineno+1,first_column:this.yylloc.first_column,last_column:i?(i.length===s.length?this.yylloc.first_column:0)+s[s.length-i.length].length-i[0].length:this.yylloc.first_column-e},this.options.ranges&&(this.yylloc.range=[r[0],r[0]+this.yyleng-e]),this.yyleng=this.yytext.length,this},more:function(){return this._more=!0,this},reject:function(){return this.options.backtrack_lexer?(this._backtrack=!0,this):this.parseError("Lexical error on line "+(this.yylineno+1)+". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},less:function(t){this.unput(this.match.slice(t))},pastInput:function(){var t=this.matched.substr(0,this.matched.length-this.match.length);return(t.length>20?"...":"")+t.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var t=this.match;return t.length<20&&(t+=this._input.substr(0,20-t.length)),(t.substr(0,20)+(t.length>20?"...":"")).replace(/\n/g,"")},showPosition:function(){var t=this.pastInput(),e=new Array(t.length+1).join("-");return t+this.upcomingInput()+"\n"+e+"^"},test_match:function(t,e){var i,s,r;if(this.options.backtrack_lexer&&(r={yylineno:this.yylineno,yylloc:{first_line:this.yylloc.first_line,last_line:this.last_line,first_column:this.yylloc.first_column,last_column:this.yylloc.last_column},yytext:this.yytext,match:this.match,matches:this.matches,matched:this.matched,yyleng:this.yyleng,offset:this.offset,_more:this._more,_input:this._input,yy:this.yy,conditionStack:this.conditionStack.slice(0),done:this.done},this.options.ranges&&(r.yylloc.range=this.yylloc.range.slice(0))),(s=t[0].match(/(?:\r\n?|\n).*/g))&&(this.yylineno+=s.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:s?s[s.length-1].length-s[s.length-1].match(/\r?\n?/)[0].length:this.yylloc.last_column+t[0].length},this.yytext+=t[0],this.match+=t[0],this.matches=t,this.yyleng=this.yytext.length,this.options.ranges&&(this.yylloc.range=[this.offset,this.offset+=this.yyleng]),this._more=!1,this._backtrack=!1,this._input=this._input.slice(t[0].length),this.matched+=t[0],i=this.performAction.call(this,this.yy,this,e,this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),i)return i;if(this._backtrack){for(var o in r)this[o]=r[o];return!1}return!1},next:function(){if(this.done)return this.EOF;var t,e,i,s;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var r=this._currentRules(),o=0;o<r.length;o++)if((i=this._input.match(this.rules[r[o]]))&&(!e||i[0].length>e[0].length)){if(e=i,s=o,this.options.backtrack_lexer){if(!1!==(t=this.test_match(i,r[o])))return t;if(this._backtrack){e=!1;continue}return!1}if(!this.options.flex)break}return e?!1!==(t=this.test_match(e,r[s]))&&t:""===this._input?this.EOF:this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var t=this.next();return t||this.lex()},begin:function(t){this.conditionStack.push(t)},popState:function(){return this.conditionStack.length-1>0?this.conditionStack.pop():this.conditionStack[0]},_currentRules:function(){return this.conditionStack.length&&this.conditionStack[this.conditionStack.length-1]?this.conditions[this.conditionStack[this.conditionStack.length-1]].rules:this.conditions.INITIAL.rules},topState:function(t){return(t=this.conditionStack.length-1-Math.abs(t||0))>=0?this.conditionStack[t]:"INITIAL"},pushState:function(t){this.begin(t)},stateStackSize:function(){return this.conditionStack.length},options:{},performAction:function(t,e,i,s){switch(i){case 0:case 5:case 6:break;case 1:case 2:return 78;case 3:case 4:return 77;case 7:return 7;case 8:return 12;case 9:return 14;case 10:return 17;case 11:return 15;case 12:return 91;case 13:return 93;case 14:return 19;case 15:return 23;case 16:return 21;case 17:return 75;case 18:return 76;case 19:return 74;case 20:return 80;case 21:case 22:return 94;case 23:return 82;case 24:return 83;case 25:return 26;case 26:return 27;case 27:return 16;case 28:return"#";case 29:return 34;case 30:return 35;case 31:return 79;case 32:return 64;case 33:return 65;case 34:return 66;case 35:return 8;case 36:return 10;case 37:return 58;case 38:case 39:return 57;case 40:return 53;case 41:return 54;case 42:return 55;case 43:return 50;case 44:return 51;case 45:return 47;case 46:return 45;case 47:return 48;case 48:return 46;case 49:return 41;case 50:return 43;case 51:return 42;case 52:return 39;case 53:return 37;case 54:return 32;case 55:return 86;case 56:return 5;case 57:return 20;case 58:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:[0-9]+\.[0-9]*|[0-9]*\.[0-9]+\b)/,/^(?:[0-9]+)/,/^(?:"(\\["]|[^"])*")/,/^(?:'(\\[']|[^'])*')/,/^(?:\/\/.*)/,/^(?:\/\*(.|\n|\r)*?\*\/)/,/^(?:if\b)/,/^(?:else\b)/,/^(?:while\b)/,/^(?:do\b)/,/^(?:for\b)/,/^(?:function\b)/,/^(?:map\b)/,/^(?:use\b)/,/^(?:return\b)/,/^(?:delete\b)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:Infinity\b)/,/^(?:->)/,/^(?:=>)/,/^(?:<<)/,/^(?:>>)/,/^(?:\{)/,/^(?:\})/,/^(?:;)/,/^(?:#)/,/^(?:\?)/,/^(?::)/,/^(?:NaN\b)/,/^(?:\.)/,/^(?:\[)/,/^(?:\])/,/^(?:\()/,/^(?:\))/,/^(?:!)/,/^(?:\^)/,/^(?:\*\*)/,/^(?:\*)/,/^(?:\/)/,/^(?:%)/,/^(?:\+)/,/^(?:-)/,/^(?:<=)/,/^(?:<)/,/^(?:>=)/,/^(?:>)/,/^(?:==)/,/^(?:~=)/,/^(?:!=)/,/^(?:&&)/,/^(?:\|\|)/,/^(?:=)/,/^(?:,)/,/^(?:$)/,/^(?:[A-Za-z_\$][A-Za-z0-9_]*)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58],inclusive:!0}}};return t}();function ct(){this.yy={}}return at.lexer=ut,ct.prototype=at,at.Parser=ct,new ct}();parser.yy.parseError=parser.parseError,__webpack_exports__.A=_jxg_js__WEBPACK_IMPORTED_MODULE_0__.A.JessieCode},873:function(t,e,i){var s=i(443),r=i(188),o=i(477),n={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"},a=[{re:/^\s*rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([\d.]{1,3})\s*\)\s*$/,example:["rgba(123, 234, 45, 0.5)","rgba(255,234,245,1.0)"],process:function(t){return[parseInt(t[1],10),parseInt(t[2],10),parseInt(t[3],10)]}},{re:/^\s*rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)\s*$/,example:["rgb(123, 234, 45)","rgb(255,234,245)"],process:function(t){return[parseInt(t[1],10),parseInt(t[2],10),parseInt(t[3],10)]}},{re:/^(\w{2})(\w{2})(\w{2})$/,example:["#00ff00","336699"],process:function(t){return[parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,example:["#fb0","f0f"],process:function(t){return[parseInt(t[1]+t[1],16),parseInt(t[2]+t[2],16),parseInt(t[3]+t[3],16)]}}];s.A.rgbParser=function(t,e,i){var s,o,l,h,u,c,d,p,_,f,A=t;if(!r.A.exists(t))return[];if(r.A.exists(e)&&r.A.exists(i)&&(A=[t,e,i]),s=A,f=!1,r.A.isArray(s)){for(c=0;c<3;c++)f=f||/\./.test(A[c].toString());for(c=0;c<3;c++)f=f&&A[c]>=0&&A[c]<=1;return f?[Math.ceil(255*A[0]),Math.ceil(255*A[1]),Math.ceil(255*A[2])]:A}for("string"==typeof A&&(s=A),"#"===s.charAt(0)&&(s=s.slice(1,7)),s=s.replace(/ /g,"").toLowerCase(),s=n[s]||s,c=0;c<a.length;c++)l=a[c].re,h=a[c].process,(u=l.exec(s))&&(d=(o=h(u))[0],p=o[1],_=o[2]);return isNaN(d)||isNaN(p)||isNaN(_)?[]:[d=d<0||isNaN(d)?0:d>255?255:d,p=p<0||isNaN(p)?0:p>255?255:p,_=_<0||isNaN(_)?0:_>255?255:_]},s.A.isColor=function(t){var e=(new Option).style;return e.color=t,""!==e.color},s.A.rgb2css=function(t,e,i){var r;return"rgb("+(r=s.A.rgbParser(t,e,i))[0]+", "+r[1]+", "+r[2]+")"},s.A.rgb2hex=function(t,e,i){var r,o,n;return o=(r=s.A.rgbParser(t,e,i))[1],n=r[2],r=(r=r[0]).toString(16),o=o.toString(16),n=n.toString(16),1===r.length&&(r="0"+r),1===o.length&&(o="0"+o),1===n.length&&(n="0"+n),"#"+r+o+n},s.A.hex2rgb=function(t){return s.A.deprecated("JXG.hex2rgb()","JXG.rgb2css()"),s.A.rgb2css(t)},s.A.hsv2rgb=function(t,e,i){var s,r,n,a,l,h,u,c,d;if(t=(t%360+360)%360,0===e){if(!(isNaN(t)||t<o.A.eps))return"#ffffff";s=i,r=i,n=i}else switch(h=t>=360?0:t,u=i*(1-e),c=i*(1-e*(a=(h/=60)-(l=Math.floor(h)))),d=i*(1-e*(1-a)),l){case 0:s=i,r=d,n=u;break;case 1:s=c,r=i,n=u;break;case 2:s=u,r=i,n=d;break;case 3:s=u,r=c,n=i;break;case 4:s=d,r=u,n=i;break;case 5:s=i,r=u,n=c}return["#",s=2===(s=Math.round(255*s).toString(16)).length?s:1===s.length?"0"+s:"00",r=2===(r=Math.round(255*r).toString(16)).length?r:1===r.length?"0"+r:"00",n=2===(n=Math.round(255*n).toString(16)).length?n:1===n.length?"0"+n:"00"].join("")},s.A.rgb2hsv=function(t,e,i){var r,o,n,a,l,h,u,c,d,p,_,f,A;return o=(r=s.A.rgbParser(t,e,i))[1],n=r[2],a=(r=r[0])/255,l=o/255,h=n/255,f=Math.max(r,o,n),c=(A=Math.min(r,o,n))/255,p=0,(_=u=f/255)>0&&(p=(_-c)/_),d=1/(u-c),p>0&&(f===r?d*=l-h:d=f===o?2+(h-a)*d:4+(a-l)*d),(d*=60)<0&&(d+=360),f===A&&(d=0),[d,p,_]},s.A.rgb2LMS=function(t,e,i){var r,o,n,a,l,h,u,c=[[.05059983,.08585369,.0095242],[.01893033,.08925308,.01370054],[.00292202,.00975732,.07145979]];return o=(r=s.A.rgbParser(t,e,i))[1],n=r[2],r=r[0],r=Math.pow(r,.476190476),o=Math.pow(o,.476190476),n=Math.pow(n,.476190476),(u=[a=r*c[0][0]+o*c[0][1]+n*c[0][2],l=r*c[1][0]+o*c[1][1]+n*c[1][2],h=r*c[2][0]+o*c[2][1]+n*c[2][2]]).l=a,u.m=l,u.s=h,u},s.A.LMS2rgb=function(t,e,i){var s,r,o,n,a=[[30.830854,-29.832659,1.610474],[-6.481468,17.715578,-2.532642],[-.37569,-1.199062,14.273846]],l=function(t){for(var e=127,i=64;i>0;){if(Math.pow(e,.476190476)>t)e-=i;else{if(Math.pow(e+1,.476190476)>t)return e;e+=i}i/=2}return 254===e&&13.994955247<t?255:e};return s=t*a[0][0]+e*a[0][1]+i*a[0][2],r=t*a[1][0]+e*a[1][1]+i*a[1][2],o=t*a[2][0]+e*a[2][1]+i*a[2][2],(n=[s=l(s),r=l(r),o=l(o)]).r=s,n.g=r,n.b=o,n},s.A.rgba2rgbo=function(t){var e;return 9===t.length&&"#"===t.charAt(0)?(e=parseInt(t.slice(7,9).toUpperCase(),16)/255,t=t.slice(0,7)):e=1,[t,e]},s.A.rgbo2rgba=function(t,e){var i;return"none"===t||"transparent"===t?t:(1===(i=Math.round(255*e).toString(16)).length&&(i="0"+i),s.A.rgb2hex(t)+i)},s.A.rgb2bw=function(t){var e,i,r,o="0123456789ABCDEF";return"none"===t?t:(r=s.A.rgbParser(t),e=Math.floor(.3*r[0]+.59*r[1]+.11*r[2]),t="#"+(i=o.charAt(e>>4&15)+o.charAt(15&e))+i+i)},s.A.rgb2cb=function(t,e){var i,r,o,n,a,l,h,u,c,d,p,_="0123456789ABCDEF";if("none"===t)return t;switch(r=(a=s.A.rgb2LMS(t))[0],o=a[1],n=a[2],e=e.toLowerCase()){case"protanopia":l=-.06150039994295001,h=.08277001656812001,u=-.013200141220000003,c=.05858939668799999,d=-.07934519995360001,p=.013289415272000003,r=n/o<.6903216543277437?-(h*o+u*n)/l:-(d*o+p*n)/c;break;case"tritanopia":l=-.00058973116217,h=.007690316482,u=-.01011703519052,c=.025495080838999994,d=-.0422740347,p=.017005316784,n=o/r<.8349489908460004?-(l*r+h*o)/u:-(c*r+d*o)/p;break;default:l=-.06150039994295001,h=.08277001656812001,u=-.013200141220000003,c=.05858939668799999,d=-.07934519995360001,p=.013289415272000003,o=n/r<.5763833686400911?-(l*r+u*n)/h:-(c*r+p*n)/d}return i=s.A.LMS2rgb(r,o,n),t="#"+(_.charAt(i[0]>>4&15)+_.charAt(15&i[0])),t+=_.charAt(i[1]>>4&15)+_.charAt(15&i[1]),t+=_.charAt(i[2]>>4&15)+_.charAt(15&i[2])},s.A.shadeColor=function(t,e){var i=s.A.rgbParser(t),r=i[0],o=i[1],n=i[2];return r=(r=(r=parseInt(r+255*e))>0?r:0)<255?r:255,o=(o=(o=parseInt(o+255*e))>0?o:0)<255?o:255,n=(n=(n=parseInt(n+255*e))>0?n:0)<255?n:255,r=Math.round(r),o=Math.round(o),n=Math.round(n),s.A.rgb2hex([r,o,n])},s.A.lightenColor=function(t,e){return s.A.shadeColor(t,e)},s.A.darkenColor=function(t,e){return s.A.shadeColor(t,-1*e)},s.A.autoHighlight=function(t){var e=s.A.rgba2rgbo(t),i=e[0],r=e[1];return"#"===t.charAt(0)?(r*=r<.3?1.8:.4,s.A.rgbo2rgba(i,r)):t},s.A.contrast=function(t,e,i,r){var o,n,a,l,h;return e=e||"#000000",i=i||"#ffffff",r=r||7,o=s.A.rgbParser(t),n=s.A.rgbParser("#000000"),h=(a=.2126*Math.pow(o[0]/255,2.2)+.7152*Math.pow(o[1]/255,2.2)+.0722*Math.pow(o[2]/255,2.2))>(l=.2126*Math.pow(n[0]/255,2.2)+.7152*Math.pow(n[1]/255,2.2)+.0722*Math.pow(n[2]/255,2.2))?Math.floor((a+.05)/(l+.05)):Math.floor((l+.05)/(a+.05)),(h-=1)>r?e:i},s.A.setClassicColors=function(){s.A.Options.elements.strokeColor="blue",s.A.Options.elements.fillColor="red",s.A.Options.hatch.strokeColor="blue",s.A.Options.angle.fillColor="#ff7f00",s.A.Options.angle.highlightFillColor="#ff7f00",s.A.Options.angle.strokeColor="#ff7f00",s.A.Options.angle.label.strokeColor="blue",s.A.Options.arc.strokeColor="blue",s.A.Options.circle.center.fillColor="red",s.A.Options.circle.center.strokeColor="blue",s.A.Options.circumcircle.strokeColor="blue",s.A.Options.circumcircle.center.fillColor="red",s.A.Options.circumcircle.center.strokeColor="blue",s.A.Options.circumcirclearc.strokeColor="blue",s.A.Options.circumcirclesector.strokeColor="blue",s.A.Options.circumcirclesector.fillColor="green",s.A.Options.circumcirclesector.highlightFillColor="green",s.A.Options.conic.strokeColor="blue",s.A.Options.curve.strokeColor="blue",s.A.Options.incircle.strokeColor="blue",s.A.Options.incircle.center.fillColor="red",s.A.Options.incircle.center.strokeColor="blue",s.A.Options.inequality.fillColor="red",s.A.Options.integral.fillColor="red",s.A.Options.integral.curveLeft.color="red",s.A.Options.integral.curveRight.color="red",s.A.Options.line.strokeColor="blue",s.A.Options.point.fillColor="red",s.A.Options.point.strokeColor="red",s.A.Options.polygon.fillColor="green",s.A.Options.polygon.highlightFillColor="green",s.A.Options.polygon.vertices.strokeColor="red",s.A.Options.polygon.vertices.fillColor="red",s.A.Options.regularpolygon.fillColor="green",s.A.Options.regularpolygon.highlightFillColor="green",s.A.Options.regularpolygon.vertices.strokeColor="red",s.A.Options.regularpolygon.vertices.fillColor="red",s.A.Options.riemannsum.fillColor="yellow",s.A.Options.sector.fillColor="green",s.A.Options.sector.highlightFillColor="green",s.A.Options.semicircle.center.fillColor="red",s.A.Options.semicircle.center.strokeColor="blue",s.A.Options.slopetriangle.fillColor="red",s.A.Options.slopetriangle.highlightFillColor="red",s.A.Options.turtle.arrow.strokeColor="blue"},s.A.extend(s.A,{paletteWong:{black:"#000000",orange:"#E69F00",skyblue:"#56B4E9",bluishgreen:"#009E73",yellow:"#F0E442",darkblue:"#0072B2",vermillion:"#D55E00",reddishpurple:"#CC79A7",blue:"#0072B2",red:"#D55E00",green:"#009E73",purple:"#CC79A7",white:"#ffffff"}}),s.A.palette=s.A.paletteWong,e.A=s.A},133:function(t,e,i){var s=i(443),r=i(188);s.A.extendConstants(s.A,{}),s.A.extend(s.A,{isTouchEvent:function(t){return s.A.exists(t.touches)},isPointerEvent:function(t){return s.A.exists(t.pointerId)},isMouseEvent:function(t){return!s.A.isTouchEvent(t)&&!s.A.isPointerEvent(t)},getNumberOfTouchPoints:function(t){var e=-1;return s.A.isTouchEvent(t)&&(e=t.touches.length),e},isFirstTouch:function(t){var e=s.A.getNumberOfTouchPoints(t);return s.A.isPointerEvent(t)?t.isPrimary:1===e},isBrowser:"object"==typeof window&&"object"==typeof document,supportsES6:function(){try{return new Function("(a = 0) => a"),!0}catch(t){return!1}},supportsVML:function(){return this.isBrowser&&!!document.namespaces},supportsSVG:function(){return!!this.isBrowser&&(!!document.createElementNS&&!!document.createElementNS("http://www.w3.org/2000/svg","svg").createSVGRect)},supportsCanvas:function(){var t=!1;return this.isNode()&&(t=!0),t||this.isBrowser&&!!document.createElement("canvas").getContext},isNode:function(){return!this.isBrowser&&"undefined"!=typeof process&&-1!==process.release.name.search(/node|io.js/)},isWebWorker:function(){return!this.isBrowser&&"object"==typeof self&&"function"==typeof self.postMessage},supportsPointerEvents:function(){return!!(this.isBrowser&&window.navigator&&(window.PointerEvent||window.navigator.pointerEnabled||window.navigator.msPointerEnabled))},isTouchDevice:function(){return this.isBrowser&&void 0!==window.ontouchstart},isAndroid:function(){return r.A.exists(navigator)&&navigator.userAgent.toLowerCase().indexOf("android")>-1},isWebkitAndroid:function(){return this.isAndroid()&&navigator.userAgent.indexOf(" AppleWebKit/")>-1},isApple:function(){return r.A.exists(navigator)&&(navigator.userAgent.indexOf("iPad")>-1||navigator.userAgent.indexOf("iPhone")>-1)},isWebkitApple:function(){return this.isApple()&&navigator.userAgent.search(/Mobile\/[0-9A-Za-z.]*Safari/)>-1},isMetroApp:function(){return"object"==typeof window&&window.clientInformation&&window.clientInformation.appVersion&&window.clientInformation.appVersion.indexOf("MSAppHost")>-1},isMozilla:function(){return r.A.exists(navigator)&&navigator.userAgent.toLowerCase().indexOf("mozilla")>-1&&-1===navigator.userAgent.toLowerCase().indexOf("apple")},isFirefoxOS:function(){return r.A.exists(navigator)&&-1===navigator.userAgent.toLowerCase().indexOf("android")&&-1===navigator.userAgent.toLowerCase().indexOf("apple")&&navigator.userAgent.toLowerCase().indexOf("mobile")>-1&&navigator.userAgent.toLowerCase().indexOf("mozilla")>-1},isDesktop:function(){return!0},isMobile:function(){return!0},ieVersion:function(){var t,e,i=3;if("object"!=typeof document)return 0;e=(t=document.createElement("div")).getElementsByTagName("i");do{t.innerHTML="\x3c!--[if gt IE "+ ++i+"]><i></i><![endif]--\x3e"}while(e[0]);return i>4?i:void 0}(),getDimensions:function(t,e){var i,s,o,n,a,l,h,u,c,d=/\d+(\.\d*)?px/;if(!this.isBrowser||null===t)return{width:500,height:500};if(e=e||document,i=r.A.isString(t)?e.getElementById(t):t,!r.A.exists(i))throw new Error("\nJSXGraph: HTML container element '"+t+"' not found.");return"none"!==(s=i.style.display)&&null!==s?i.clientWidth>0&&i.clientHeight>0?{width:i.clientWidth,height:i.clientHeight}:(c=window.getComputedStyle?window.getComputedStyle(i):i.style,{width:d.test(c.width)?parseFloat(c.width):0,height:d.test(c.height)?parseFloat(c.height):0}):(n=(o=i.style).visibility,a=o.position,l=o.display,o.visibility="hidden",o.position="absolute",o.display="block",h=i.clientWidth,u=i.clientHeight,o.display=l,o.position=a,o.visibility=n,{width:h,height:u})},addEvent:function(t,e,i,s,o){var n=function(){return i.apply(s,arguments)};n.origin=i,"object"==typeof s&&r.A.exists(s.BOARD_MODE_NONE)&&(s["x_internal"+e]=s["x_internal"+e]||[],s["x_internal"+e].push(n)),r.A.exists(t)&&r.A.exists(t.addEventListener)&&(o=o||!1,t.addEventListener(e,n,o)),r.A.exists(t)&&r.A.exists(t.attachEvent)&&t.attachEvent("on"+e,n)},removeEvent:function(t,e,i,o){var n;if(r.A.exists(o))if(r.A.exists(o["x_internal"+e]))if(r.A.isArray(o["x_internal"+e]))if(-1!==(n=r.A.indexOf(o["x_internal"+e],i,"origin"))){try{r.A.exists(t)&&r.A.exists(t.removeEventListener)&&t.removeEventListener(e,o["x_internal"+e][n],!1),r.A.exists(t)&&r.A.exists(t.detachEvent)&&t.detachEvent("on"+e,o["x_internal"+e][n])}catch(t){s.A.debug("event not registered in browser: ("+e+" -- "+i+")")}o["x_internal"+e].splice(n,1)}else s.A.debug("removeEvent: no such event function in internal list: "+i);else s.A.debug("owner[x_internal + "+e+"] is not an array");else s.A.debug("no such type: "+e);else s.A.debug("no such owner")},removeAllEvents:function(t,e,i){var r;if(i["x_internal"+e]){for(r=i["x_internal"+e].length-1;r>=0;r--)s.A.removeEvent(t,e,i["x_internal"+e][r].origin,i);i["x_internal"+e].length>0&&s.A.debug("removeAllEvents: Not all events could be removed.")}},getPosition:function(t,e,i){var s,o,n,a=0,l=0;if(t||(t=window.event),i=i||document,n=t.touches,r.A.exists(n)&&0===n.length&&(n=t.changedTouches),r.A.exists(e)&&r.A.exists(n))if(-1===e){for(o=n.length,s=0;s<o;s++)if(n[s]){t=n[s];break}}else t=n[e];return t.clientX&&(a=t.clientX,l=t.clientY),[a,l]},getOffset:function(t){var e,i=t,s=t,r=i.offsetLeft-i.scrollLeft,o=i.offsetTop-i.scrollTop;for(r=(e=this.getCSSTransform([r,o],i))[0],o=e[1],i=i.offsetParent;i;){for(r+=i.offsetLeft,o+=i.offsetTop,i.offsetParent&&(r+=i.clientLeft-i.scrollLeft,o+=i.clientTop-i.scrollTop),r=(e=this.getCSSTransform([r,o],i))[0],o=e[1],s=s.parentNode;s!==i;)r+=s.clientLeft-s.scrollLeft,o+=s.clientTop-s.scrollTop,r=(e=this.getCSSTransform([r,o],s))[0],o=e[1],s=s.parentNode;i=i.offsetParent}return[r,o]},getStyle:function(t,e){var i,r=t.ownerDocument;return r.defaultView&&r.defaultView.getComputedStyle?i=r.defaultView.getComputedStyle(t,null).getPropertyValue(e):t.currentStyle&&s.A.ieVersion>=9?i=t.currentStyle[e]:t.style&&(e=e.replace(/-([a-z]|[0-9])/gi,(function(t,e){return e.toUpperCase()})),i=t.style[e]),i},getProp:function(t,e){var i=parseInt(this.getStyle(t,e),10);return isNaN(i)?0:i},getCSSTransform:function(t,e){var i,s,o,n,a,l,h,u=["transform","webkitTransform","MozTransform","msTransform","oTransform"];for(a=u.length,i=0,o="";i<a;i++)if(r.A.exists(e.style[u[i]])){o=e.style[u[i]];break}if(""!==o&&(n=o.indexOf("("))>0){for(a=o.length,s=0,l=(h=o.substring(n+1,a-1).split(",")).length;s<l;s++)h[s]=parseFloat(h[s]);0===o.indexOf("matrix")?(t[0]+=h[4],t[1]+=h[5]):0===o.indexOf("translateX")?t[0]+=h[0]:0===o.indexOf("translateY")?t[1]+=h[0]:0===o.indexOf("translate")&&(t[0]+=h[0],t[1]+=h[1])}return r.A.exists(e.style.zoom)&&""!==(o=e.style.zoom)&&(t[0]*=parseFloat(o),t[1]*=parseFloat(o)),t},getCSSTransformMatrix:function(t){var e,i,s,o,n,a,l,h,u=t.ownerDocument,c=["transform","webkitTransform","MozTransform","msTransform","oTransform"],d=[[1,0,0],[0,1,0],[0,0,1]];if(u.defaultView&&u.defaultView.getComputedStyle)s=(h=u.defaultView.getComputedStyle(t,null)).getPropertyValue("-webkit-transform")||h.getPropertyValue("-moz-transform")||h.getPropertyValue("-ms-transform")||h.getPropertyValue("-o-transform")||h.getPropertyValue("transform");else for(a=c.length,e=0,s="";e<a;e++)if(r.A.exists(t.style[c[e]])){s=t.style[c[e]];break}if(""!==s&&(n=s.indexOf("("))>0){for(a=s.length,i=0,l=(o=s.substring(n+1,a-1).split(",")).length;i<l;i++)o[i]=parseFloat(o[i]);0===s.indexOf("matrix")?d=[[1,0,0],[0,o[0],o[1]],[0,o[2],o[3]]]:0===s.indexOf("scaleX")?d[1][1]=o[0]:0===s.indexOf("scaleY")?d[2][2]=o[0]:0===s.indexOf("scale")&&(d[1][1]=o[0],d[2][2]=o[1])}return r.A.exists(t.style.zoom)&&""!==(s=t.style.zoom)&&(d[1][1]*=parseFloat(s),d[2][2]*=parseFloat(s)),d},timedChunk:function(t,e,i,s){var r=t.slice(),o=function(){var n=+new Date;do{e.call(i,r.shift())}while(r.length>0&&+new Date-n<300);r.length>0?window.setTimeout(o,1):s(t)};window.setTimeout(o,1)},scaleJSXGraphDiv:function(t,e,i,r){var o,n,a,l,h,u,c,d,p,_,f,A,g=r;for(n=(a=i.getElementById(t).getBoundingClientRect()).height,o=a.width,u=(d=i.getElementById(e))._cssFullscreenStore.w,f=(c=d._cssFullscreenStore.h)/u,u>o*g&&(c=(u=o*g)*f),c>n*g&&(u=(c=n*g)/f),l=u,p=f<n/o?o*g/u:n*g/c,_=.5*(n-(h=c)),A=0;A<4;A++)try{d.style.width=l+"px !important",d.style.height=h+"px !important",d.style.margin="0 auto",d.style.transform=d._cssFullscreenStore.transform+" matrix("+p+",0,0,"+p+",0,"+_+")";break}catch(t){s.A.debug("JXG.scaleJSXGraphDiv:\n"+t)}4===A&&s.A.debug("JXG.scaleJSXGraphDiv: Could not set any CSS property.")}}),e.A=s.A},454:function(t,e,i){var s=i(443),r=i(188);s.A.EventEmitter={eventHandlers:{},suspended:{},trigger:function(t,e){var i,s,r,o,n,a;for(n=t.length,s=0;s<n;s++)if(o=this.eventHandlers[t[s]],!this.suspended[t[s]]){if(this.suspended[t[s]]=!0,o)for(a=o.length,i=0;i<a;i++)(r=o[i]).handler.apply(r.context,e);this.suspended[t[s]]=!1}return this},on:function(t,e,i){return r.A.isArray(this.eventHandlers[t])||(this.eventHandlers[t]=[]),i=r.A.def(i,this),this.eventHandlers[t].push({handler:e,context:i}),this},off:function(t,e){var i;return t&&r.A.isArray(this.eventHandlers[t])?(e?((i=r.A.indexOf(this.eventHandlers[t],e,"handler"))>-1&&this.eventHandlers[t].splice(i,1),0===this.eventHandlers[t].length&&delete this.eventHandlers[t]):delete this.eventHandlers[t],this):this},eventify:function(t){t.eventHandlers={clicks:0},t.on=this.on,t.off=this.off,t.triggerEventHandlers=this.trigger,t.trigger=this.trigger,t.suspended={}}},e.A=s.A.EventEmitter},713:function(t,e,i){var s=i(443),r=i(188),o=i(561),n=i(904);s.A.Expect={each:function(t,e,i){var s,o,n=[];if(r.A.exists(t.length))for(o=t.length,s=0;s<o;s++)n.push(e.call(this,t[s],i));return n},coords:function(t,e){var i=t;return t&&t.elementClass===o.A.OBJECT_CLASS_POINT?i=t.coords:t.usrCoords&&t.scrCoords&&t.usr2screen&&(i=t),e&&(i=new n.A(o.A.COORDS_BY_USER,i.usrCoords,i.board)),i},coordsArray:function(t,e){var i;return(i=r.A.isArray(t)?t:this.coords(t).usrCoords).length<3&&i.unshift(1),e&&(i=[i[0],i[1],i[2]]),i}},e.A=s.A.Expect},188:function(t,e,i){var s=i(443),r=i(561),o=i(477);s.A.extend(s.A,{isBoard:function(t){return null!==t&&"object"==typeof t&&this.isNumber(t.BOARD_MODE_NONE)&&this.isObject(t.objects)&&this.isObject(t.jc)&&this.isFunction(t.update)&&!!t.containerObj&&this.isString(t.id)},isId:function(t,e){return"string"==typeof e&&!!t.objects[e]},isName:function(t,e){return"string"==typeof e&&!!t.elementsByName[e]},isGroup:function(t,e){return"string"==typeof e&&!!t.groups[e]},isString:function(t){return"string"==typeof t},isNumber:function(t,e,i){var s="number"==typeof t||"[Object Number]"===Object.prototype.toString.call(t);return i=void 0===i||i,(e=e||!1)&&(s=s||""+parseFloat(t)===t),i||(s=s&&!isNaN(t)),s},isFunction:function(t){return"function"==typeof t},isArray:function(t){return Array.isArray?Array.isArray(t):null!==t&&"object"==typeof t&&"function"==typeof t.splice&&"function"==typeof t.join},isObject:function(t){return"object"==typeof t&&!this.isArray(t)},isDocumentOrFragment:function(t){return this.isObject(t)&&(9===t.nodeType||11===t.nodeType)},isPoint:function(t){return!(null===t||"object"!=typeof t||!this.exists(t.elementClass))&&t.elementClass===r.A.OBJECT_CLASS_POINT},isPoint3D:function(t){return!(null===t||"object"!=typeof t||!this.exists(t.elType))&&"point3d"===t.elType},isPointType:function(t,e){var i,s;return!!this.isArray(e)||(!!(this.isFunction(e)&&(i=e(),this.isArray(i)&&i.length>1))||(s=t.select(e),this.isPoint(s)))},isPointType3D:function(t,e){var i,s;return!!(this.isArray(e)&&e.length>=3)||(!!(this.isFunction(e)&&(i=e(),this.isArray(i)&&i.length>=3))||(s=t.select(e),this.isPoint3D(s)))},isTransformationOrArray:function(t){if(null!==t){if(this.isArray(t)&&t.length>0)return this.isTransformationOrArray(t[0]);if("object"==typeof t)return t.type===r.A.OBJECT_TYPE_TRANSFORMATION}return!1},isEmpty:function(t){return 0===Object.keys(t).length},exists:function(t,e){var i=!(null==t||null===t);return(e=e||!1)?i&&""!==t:i},def:function(t,e){return this.exists(t)?t:e},str2Bool:function(t){return!this.exists(t)||("boolean"==typeof t?t:!!this.isString(t)&&"true"===t.toLowerCase())},cssParse:function(t){var e=t;return this.isString(e)?(e='{"'+(e=(e=(e=(e=e.replace(/\s*;\s*$/g,"")).replace(/\s*;\s*/g,'","')).replace(/\s*:\s*/g,'":"')).trim())+'"}',JSON.parse(e)):{}},cssStringify:function(t){var e,i,s="";if(!this.isObject(t))return"";for(e in t)t.hasOwnProperty(e)&&(i=t[e],(this.isString(i)||this.isNumber(i))&&(s+=e+":"+i+"; "));return s=s.trim()},createEvalFunction:function(t,e,i){var r,o,n,a=[],l={};for(o=0;o<i;o++)for(n in a[o]=s.A.createFunction(e[o],t),a[o].deps)l[n]=a[o].deps;return(r=function(t){return a[t]()}).deps=l,r},createFunction:function(t,e,i,s){var r=null;return this.isString(t)?r=e.jc.snippet(t,!0,i,!1):this.isFunction(t)?(r=t).deps={}:this.isNumber(t)&&((r=function(){return t}).deps={}),null!==r&&(r.origin=t),r},providePoints:function(t,e,i,s,r){var o,n,a,l,h,u=0,c=[];for(this.isArray(e)||(e=[e]),a=e.length,this.exists(r)&&(u=r.length),0===u&&(l=this.copyAttributes(i,t.options,s)),o=0;o<a;++o)if(u>0&&(n=Math.min(o,u-1),l=this.copyAttributes(i,t.options,s,r[n].toLowerCase())),this.isArray(e[o])&&e[o].length>1?(c.push(t.create("point",e[o],l)),c[c.length-1]._is_new=!0):this.isFunction(e[o])?(h=e[o](),this.isArray(h)&&h.length>1&&(c.push(t.create("point",[e[o]],l)),c[c.length-1]._is_new=!0)):c.push(t.select(e[o])),!this.isPoint(c[o]))return!1;return c},providePoints3D:function(t,e,i,s,r){var o,n,a,l,h,u=0,c=[];for(this.isArray(e)||(e=[e]),a=e.length,this.exists(r)&&(u=r.length),0===u&&(l=this.copyAttributes(i,t.board.options,s)),o=0;o<a;++o)if(u>0&&(n=Math.min(o,u-1),l=this.copyAttributes(i,t.board.options,s,r[n])),this.isArray(e[o])&&e[o].length>1?(c.push(t.create("point3d",e[o],l)),c[c.length-1]._is_new=!0):this.isFunction(e[o])?(h=e[o](),this.isArray(h)&&h.length>1&&(c.push(t.create("point3d",[e[o]],l)),c[c.length-1]._is_new=!0)):c.push(t.select(e[o])),!this.isPoint3D(c[o]))return!1;return c},bind:function(t,e){return function(){return t.apply(e,arguments)}},evaluate:function(t){return this.isFunction(t)?t():t},indexOf:function(t,e,i){var s,r=this.exists(i);if(Array.indexOf&&!r)return t.indexOf(e);for(s=0;s<t.length;s++)if(r&&t[s][i]===e||!r&&t[s]===e)return s;return-1},eliminateDuplicates:function(t){var e,i=t.length,s=[],r={};for(e=0;e<i;e++)r[t[e]]=0;for(e in r)r.hasOwnProperty(e)&&s.push(e);return s},swap:function(t,e,i){var s;return s=t[e],t[e]=t[i],t[i]=s,t},uniqueArray:function(t){var e,i,r,o=[];if(0===t.length)return[];for(e=0;e<t.length;e++)if(r=this.isArray(t[e]),this.exists(t[e]))for(i=e+1;i<t.length;i++)r&&s.A.cmpArrays(t[e],t[i])?t[e]=[]:r||t[e]!==t[i]||(t[e]="");else t[e]="";for(i=0,e=0;e<t.length;e++)(r=this.isArray(t[e]))||""===t[e]?r&&0!==t[e].length&&(o[i]=t[e].slice(0),i++):(o[i]=t[e],i++);return t=o,o},isInArray:function(t,e){return s.A.indexOf(t,e)>-1},coordsArrayToMatrix:function(t,e){var i,s=[],r=[];for(i=0;i<t.length;i++)e?(s.push(t[i].usrCoords[1]),r.push(t[i].usrCoords[2])):r.push([t[i].usrCoords[1],t[i].usrCoords[2]]);return e&&(r=[s,r]),r},cmpArrays:function(t,e){var i;if(t===e)return!0;if(t.length!==e.length)return!1;for(i=0;i<t.length;i++)if(this.isArray(t[i])&&this.isArray(e[i])){if(!this.cmpArrays(t[i],e[i]))return!1}else if(t[i]!==e[i])return!1;return!0},removeElementFromArray:function(t,e){var i;for(i=0;i<t.length;i++)if(t[i]===e)return t.splice(i,1),t;return t},trunc:function(t,e){return e=s.A.def(e,0),this.toFixed(t,e)},_decimalAdjust:function(t,e,i){return void 0===i||0==+i?Math[t](e):(e=+e,i=+i,isNaN(e)||"number"!=typeof i||i%1!=0?NaN:(e=e.toString().split("e"),+((e=(e=Math[t](+(e[0]+"e"+(e[1]?+e[1]-i:-i)))).toString().split("e"))[0]+"e"+(e[1]?+e[1]+i:i))))},_round10:function(t,e){return this._decimalAdjust("round",t,e)},_floor10:function(t,e){return this._decimalAdjust("floor",t,e)},_ceil10:function(t,e){return this._decimalAdjust("ceil",t,e)},toFixed:function(t,e){return this._round10(t,-e).toFixed(e)},autoDigits:function(t){var e=Math.abs(t);return e>=.1?this.toFixed(t,2):e>=.01?this.toFixed(t,4):e>=1e-4?this.toFixed(t,6):t},parseNumber:function(t,e,i){var s;return this.isString(t)&&t.indexOf("%")>-1?(s=t.replace(/\s+%\s+/,""),parseFloat(s)*e*.01):this.isString(t)&&t.indexOf("fr")>-1?(s=t.replace(/\s+fr\s+/,""),parseFloat(s)*e):this.isString(t)&&t.indexOf("px")>-1?(s=t.replace(/\s+px\s+/,""),s=parseFloat(s),this.isFunction(i)?i(s):this.isNumber(i)?s*i:s):parseFloat(t)},parsePosition:function(t){var e,i,s="",r="";if(""!==(t=t.trim()))for(e=t.split(/[ ,]+/),i=0;i<e.length;i++)"left"===e[i]||"right"===e[i]?s=e[i]:r=e[i];return{side:s,pos:r}},keys:function(t,e){var i,s=[];for(i in t)e?t.hasOwnProperty(i)&&s.push(i):s.push(i);return s},clone:function(t){var e={};return e.prototype=t,e},cloneAndCopy:function(t,e){var i,s=function(){};for(i in s.prototype=t,e)s[i]=e[i];return s},merge:function(t,e){var i,s,r,o;for(i in e)if(e.hasOwnProperty(i))if(r=e[i],this.isArray(r))for(t[i]||(t[i]=[]),s=0;s<r.length;s++)o=e[i][s],"object"==typeof e[i][s]?t[i][s]=this.merge(t[i][s],o):t[i][s]=e[i][s];else"object"==typeof r?(t[i]||(t[i]={}),t[i]=this.merge(t[i],r)):("boolean"==typeof t&&(t={}),t[i]=r);return t},deepCopy:function(t,e,i){var s,r,o,n;if(i=i||!1,"object"!=typeof t||null===t)return t;if(this.isArray(t))for(s=[],r=0;r<t.length;r++)null!==(o=t[r])&&"object"==typeof o?this.exists(o.board)?s[r]=o.id:s[r]=this.deepCopy(o,{},i):s[r]=o;else{for(r in s={},t)t.hasOwnProperty(r)&&(n=i?r.toLowerCase():r,null!==(o=t[r])&&"object"==typeof o?this.exists(o.board)?s[n]=o.id:s[n]=this.deepCopy(o,{},i):s[n]=o);for(r in e)e.hasOwnProperty(r)&&(n=i?r.toLowerCase():r,null!==(o=e[r])&&"object"==typeof o?this.isArray(o)||!this.exists(s[n])?s[n]=this.deepCopy(o,{},i):s[n]=this.deepCopy(s[n],o,i):s[n]=o)}return s},mergeAttr:function(t,e,i,s){var r,o,n;for(r in i=i||!0,s=s||!1,e)e.hasOwnProperty(r)&&(o=i?r.toLowerCase():r,n=e[r],!this.isObject(n)||null===n||this.isDocumentOrFragment(n)||this.exists(n.board)||"string"==typeof n.valueOf()?s&&!this.exists(n)||(t[o]=n):(void 0!==t[o]&&null!==t[o]&&this.isObject(t[o])||(t[o]={}),this.mergeAttr(t[o],n,i)))},keysToLowerCase:function(t){var e,i,s=Object.keys(t),r=s.length,o={};if("object"!=typeof t)return t;for(;r--;)e=s[r],t.hasOwnProperty(e)&&("object"!=typeof(i=t[e])||null===i||this.isArray(i)||this.exists(i.nodeType)||this.exists(i.board)?o[e.toLowerCase()]=i:o[e.toLowerCase()]=this.keysToLowerCase(i));return o},copyAttributes:function(t,e,i){var r,o,n,a,l;for(r=(n=arguments.length)<3||{circle:1,curve:1,foreignobject:1,image:1,line:1,point:1,polygon:1,text:1,ticks:1,integral:1}[i]?s.A.deepCopy(e.elements,null,!0):{},n<4&&this.exists(i)&&this.exists(e.layer[i])&&(r.layer=e.layer[i]),a=e,l=!0,o=2;o<n;o++){if(!this.exists(a[arguments[o]])){l=!1;break}a=a[arguments[o]]}for(l&&(r=s.A.deepCopy(r,a,!0)),a="object"==typeof t?this.keysToLowerCase(t):{},l=!0,o=3;o<n;o++){if(!this.exists(a[arguments[o]])){l=!1;break}a=a[arguments[o]]}if(l&&this.mergeAttr(r,a,!0),"board"===arguments[2])return r;for(a=e,l=!0,o=2;o<n;o++){if(!this.exists(a[arguments[o]])){l=!1;break}a=a[arguments[o]]}return l&&this.exists(a.label)&&(r.label=s.A.deepCopy(a.label,r.label,!0)),r.label=s.A.deepCopy(e.label,r.label,!0),r},copyPrototypeMethods:function(t,e,i){var s;for(s in t.prototype[i]=e.prototype.constructor,e.prototype)e.prototype.hasOwnProperty(s)&&(t.prototype[s]=e.prototype[s])},toJSON:function(t,e){var i,r,o,n;if(e=s.A.def(e,!1),void 0!==JSON&&JSON.stringify&&!e)try{return JSON.stringify(t)}catch(t){}switch(typeof t){case"object":if(t){if(i=[],this.isArray(t)){for(o=0;o<t.length;o++)i.push(s.A.toJSON(t[o],e));return"["+i.join(",")+"]"}for(r in t)if(t.hasOwnProperty(r)){try{n=s.A.toJSON(t[r],e)}catch(t){n=""}e?i.push(r+":"+n):i.push('"'+r+'":'+n)}return"{"+i.join(",")+"} "}return"null";case"string":return"'"+t.replace(/(["'])/g,"\\$1")+"'";case"number":case"boolean":return t.toString()}return"0"},clearVisPropOld:function(t){return t.visPropOld={cssclass:"",cssdefaultstyle:"",cssstyle:"",fillcolor:"",fillopacity:"",firstarrow:!1,fontsize:-1,lastarrow:!1,left:-1e5,linecap:"",shadow:!1,strokecolor:"",strokeopacity:"",strokewidth:"",tabindex:-1e5,transitionduration:0,top:-1e5,visible:null},t},isInObject:function(t,e){var i;for(i in t)if(t.hasOwnProperty(i)&&t[i]===e)return!0;return!1},escapeHTML:function(t){return t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")},unescapeHTML:function(t){return t.replace(/<\/?[^>]+>/gi,"").replace(/&amp;/g,"&").replace(/&lt;/g,"<").replace(/&gt;/g,">")},capitalize:function(t){return t.charAt(0).toUpperCase()+t.substring(1).toLowerCase()},trimNumber:function(t){return"."!==(t=(t=t.replace(/^0+/,"")).replace(/0+$/,""))[t.length-1]&&","!==t[t.length-1]||(t=t.slice(0,-1)),"."!==t[0]&&","!==t[0]||(t="0"+t),t},filterElements:function(t,e){var i,s,r,o,n,a,l,h=t.length,u=[];if("function"!=typeof e&&"object"!=typeof e)return u;for(i=0;i<h;i++){if(l=!0,r=t[i],"object"==typeof e){for(s in e)if(e.hasOwnProperty(s)&&(o=s.toLowerCase(),n="function"==typeof r[s]?r[s]():r[s],a=r.visProp&&"function"==typeof r.visProp[o]?r.visProp[o]():r.visProp&&r.visProp[o],!(l="function"==typeof e[s]?e[s](n)||e[s](a):n===e[s]||a===e[s])))break}else"function"==typeof e&&(l=e(r));l&&u.push(r)}return u},trim:function(t){return t.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")},toFraction:function(t,e,i){var s=o.A.decToFraction(t,i),r="";return 0===s[1]&&0===s[2]?r+="0":(s[0]<0&&(r+="-"),0===s[2]?r+=s[1]:1===s[2]&&1===s[3]||(0!==s[1]&&(r+=" "),r+=!0===e?"\\frac{"+s[2]+"}{"+s[3]+"}":s[2]+"/"+s[3])),r},concat:function(t,e){var i,s=e.length;for(i=0;i<s;i++)t.push(e[i]);return t},sanitizeHTML:function(t,e){return"function"==typeof html_sanitize&&e?html_sanitize(t,(function(){}),(function(t){return t})):(t&&"string"==typeof t&&(t=t.replace(/</g,"&lt;").replace(/>/g,"&gt;")),t)},evalSlider:function(t){return t&&t.type===r.A.OBJECT_TYPE_GLIDER&&"function"==typeof t.Value?t.Value():t},stack2jsxgraph:function(t){var e;return"["===(e=t.replace(/%pi/g,"PI").replace(/%e/g,"EULER").replace(/%phi/g,"1.618033988749895").replace(/%gamma/g,"0.5772156649015329").trim())[0]&&"]"===e[e.length-1]&&(e=e.slice(1,-1).split(/\s*,\s*/)),e}}),e.A=s.A}},__webpack_module_cache__={};function __webpack_require__(t){var e=__webpack_module_cache__[t];if(void 0!==e)return e.exports;var i=__webpack_module_cache__[t]={exports:{}};return __webpack_modules__[t](i,i.exports,__webpack_require__),i.exports}__webpack_require__.d=function(t,e){for(var i in e)__webpack_require__.o(e,i)&&!__webpack_require__.o(t,i)&&Object.defineProperty(t,i,{enumerable:!0,get:e[i]})},__webpack_require__.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)};var __webpack_exports__={};__webpack_require__.d(__webpack_exports__,{default:function(){return src}});var jxg=__webpack_require__(443),env=__webpack_require__(133),constants=__webpack_require__(561),utils_type=__webpack_require__(188);jxg.A.XML={cleanWhitespace:function(t){for(var e=t.firstChild;utils_type.A.exists(e);)3!==e.nodeType||/\S/.test(e.nodeValue)?1===e.nodeType&&this.cleanWhitespace(e):t.removeChild(e),e=e.nextSibling},parse:function(t){var e,i;return i="function"==typeof DOMParser||"object"==typeof DOMParser?DOMParser:function(){this.parseFromString=function(t){var e;return"function"==typeof ActiveXObject&&(e=new ActiveXObject("MSXML.DomDocument")).loadXML(t),e}},e=(new i).parseFromString(t,"text/xml"),this.cleanWhitespace(e),e}};var xml=jxg.A.XML,utils_event=__webpack_require__(454),expect=__webpack_require__(713),math=__webpack_require__(477);math.A.ProbFuncs={MAXNUM:17014118346046923e22,SQRTH:.7071067811865476,SQRT2:1.4142135623730951,MAXLOG:708.3964185322641,P:[2.461969814735305e-10,.5641895648310689,7.463210564422699,48.63719709856814,196.5208329560771,526.4451949954773,934.5285271719576,1027.5518868951572,557.5353353693994],Q:[13.228195115474499,86.70721408859897,354.9377788878199,975.7085017432055,1823.9091668790973,2246.3376081871097,1656.6630919416134,557.5353408177277],R:[.5641895835477551,1.275366707599781,5.019050422511805,6.160210979930536,7.4097426995044895,2.9788666537210022],S:[2.2605286322011726,9.396035249380015,12.048953980809666,17.08144507475659,9.608968090632859,3.369076451000815],T:[9.604973739870516,90.02601972038427,2232.005345946843,7003.325141128051,55592.30130103949],U:[33.56171416475031,521.3579497801527,4594.323829709801,22629.000061389095,49267.39426086359],M:128,MINV:.0078125,expx2:function(t,e){var i,s,r,o;return t=Math.abs(t),e<0&&(t=-t),i=(r=this.MINV*Math.floor(this.M*t+.5))*r,s=2*r*(o=t-r)+o*o,e<0&&(i=-i,s=-s),i+s>this.MAXLOG?1/0:i=Math.exp(i)*Math.exp(s)},polevl:function(t,e,i){var s,r;if(utils_type.A.exists(e.reduce))return e.reduce((function(e,i){return e*t+i}),0);for(r=0,s=0;r<=i;r++)s=s*t+e[r];return s},p1evl:function(t,e,i){var s,r;if(utils_type.A.exists(e.reduce))return e.reduce((function(e,i){return e*t+i}),1);for(r=0,s=1;r<i;r++)s=s*t+e[r];return s},ndtr:function(t){var e,i,s;return e=t*this.SQRTH,(s=Math.abs(e))<1?i=.5+.5*this.erf(e):(i=.5*this.erfce(s),s=this.expx2(t,-1),i*=Math.sqrt(s),e>0&&(i=1-i)),i},_underflow:function(t){return console.log("erfc","UNDERFLOW"),t<0?2:0},erfc:function(t){var e,i,s,r,o;return(s=t<0?-t:t)<1?1-this.erf(t):(o=-t*t)<-this.MAXLOG?this._underflow(t):(o=this.expx2(t,-1),s<8?(e=this.polevl(s,this.P,8),i=this.p1evl(s,this.Q,8)):(e=this.polevl(s,this.R,5),i=this.p1evl(s,this.S,6)),r=o*e/i,t<0&&(r=2-r),0===r?this._underflow(t):r)},erfce:function(t){var e,i;return t<8?(e=this.polevl(t,this.P,8),i=this.p1evl(t,this.Q,8)):(e=this.polevl(t,this.R,5),i=this.p1evl(t,this.S,6)),e/i},erf:function(t){var e;return Math.abs(t)>1?1-this.erfc(t):(e=t*t,t*this.polevl(e,this.T,4)/this.p1evl(e,this.U,5))},s2pi:2.5066282746310007,P0:[-59.96335010141079,98.00107541859997,-56.67628574690703,13.931260938727968,-1.2391658386738125],Q0:[1.9544885833814176,4.676279128988815,86.36024213908905,-225.46268785411937,200.26021238006066,-82.03722561683334,15.90562251262117,-1.1833162112133],P1:[4.0554489230596245,31.525109459989388,57.16281922464213,44.08050738932008,14.684956192885803,2.1866330685079025,-.1402560791713545,-.03504246268278482,-.0008574567851546854],Q1:[15.779988325646675,45.39076351288792,41.3172038254672,15.04253856929075,2.504649462083094,-.14218292285478779,-.03808064076915783,-.0009332594808954574],P2:[3.2377489177694603,6.915228890689842,3.9388102529247444,1.3330346081580755,.20148538954917908,.012371663481782003,.00030158155350823543,26580697468673755e-22,6.239745391849833e-9],Q2:[6.02427039364742,3.6798356385616087,1.3770209948908132,.21623699359449663,.013420400608854318,.00032801446468212774,28924786474538068e-22,6.790194080099813e-9],ndtri:function(t){var e,i,s,r,o;return t<=0?-1/0:t>=1?1/0:(o=1,(i=t)>.8646647167633873&&(i=1-i,o=0),i>.1353352832366127?(e=(i-=.5)+i*((r=i*i)*this.polevl(r,this.P0,4)/this.p1evl(r,this.Q0,8)),e*=this.s2pi):(s=1/(e=Math.sqrt(-2*Math.log(i))),e=e-Math.log(e)/e-(e<8?s*this.polevl(s,this.P1,8)/this.p1evl(s,this.Q1,8):s*this.polevl(s,this.P2,8)/this.p1evl(s,this.Q2,8)),0!==o&&(e=-e),e))},erfi:function(t){return this.ndtri(.5*(t+1))*this.SQRTH}};var probfuncs=math.A.ProbFuncs,ia=__webpack_require__(733);math.A.Extrapolate={upper:15,infty:1e4,wynnEps:function(t,e,i){var s,r,o,n,a;if(i[e]=t,0===e)a=t;else{for(o=0,s=e;s>0;s--)r=o,o=i[s-1],n=i[s]-o,Math.abs(n)<=1e-15?i[s-1]=1e20:i[s-1]=1*r+1/n;a=i[e%2]}return a},aitken:function(t,e,i){var s,r,o,n,a,l;if(i[e]=t,e<2)s=t;else{for(n=e/2,a=1;a<=n;a++)r=i[(l=e-2*a)+2]-2*i[l+1]+i[l],Math.abs(r)<1e-15?i[l]=1e20:(o=i[l]-i[l+1],i[l]-=o*o/r);s=i[e%2]}return s},brezinski:function(t,e,i){var s,r,o,n,a,l,h,u;if(i[e]=t,e<3)s=t;else{for(l=e/3,u=e,h=1;h<=l;h++)o=i[(u-=3)+1]-i[u],n=i[u+2]-i[u+1],r=(a=i[u+3]-i[u+2])*(n-o)-o*(a-n),Math.abs(r)<1e-15?i[u]=1e20:i[u]=i[u+1]-o*n*(a-n)/r;s=i[e%3]}return s},iteration:function(t,e,i,s,r){var o,n,a,l,h=NaN,u=[],c="finite",d=e;for(r=r||0,o=1;o<=this.upper;o++){if(n=i(t+(d=0===r?e/(o+1):.5*d),!0),a=this[s](n,o-1,u),isNaN(a)){c="NaN";break}if(0!==n&&a/n>this.infty){h=a,c="infinite";break}if(l=a-h,Math.abs(l)<1e-7)break;h=a}return[h,c,1-(o-1)/this.upper]},levin:function(t,e,i,s,r,o){var n,a,l,h;if(h=1/(s+e),r[e]=t/i,o[e]=1/i,e>0&&(r[e-1]=r[e]-r[e-1],o[e-1]=o[e]-o[e-1],e>1))for(l=(s+e-1)*h,n=2;n<=e;n++)a=(s+e-n)*Math.pow(l,n-2)*h,r[e-n]=r[e-n+1]-a*r[e-n],o[e-n]=o[e-n+1]-a*o[e-n],h*=l;return Math.abs(o[0])<1e-15?1e20:r[0]/o[0]},iteration_levin:function(t,e,i,s){var r,o,n,a,l,h,u,c=NaN,d=[],p=[],_="finite",f=e;for(s=s||0,a=i(t+e,!0),r=1;r<=this.upper;r++){if(l=(o=i(t+(f=0===s?e/(r+1):.5*f),!0))-a,u="u"===(Math.abs(l)<1?"u":"t")?(1+r)*l:l,a=o,h=(n=this.levin(o,r-1,u,1,d,p))-c,isNaN(n)){_="NaN";break}if(0!==o&&n/o>this.infty){c=n,_="infinite";break}if(Math.abs(h)<1e-7)break;c=n}return[c,_,1-(r-1)/this.upper]},limit:function(t,e,i){return this.iteration_levin(t,e,i,0)}};var extrapolate=math.A.Extrapolate,geometry=__webpack_require__(571);math.A.Quadtree=function(t,e,i){e=e||{capacity:10,pointType:"coords"},this.config={},this.config.capacity=e.capacity||10,this.config.pointType=e.pointType||"coords",this.points=[],this.xlb=t[0],this.xub=t[2],this.ylb=t[3],this.yub=t[1],this.parent=i||null,this.northWest=null,this.northEast=null,this.southEast=null,this.southWest=null},utils_type.A.extend(math.A.Quadtree.prototype,{contains:function(t,e){return this.xlb<t&&t<=this.xub&&this.ylb<e&&e<=this.yub},insert:function(t){switch(this.config.pointType){case"coords":if(!this.contains(t.usrCoords[1],t.usrCoords[2]))return!1;break;case"object":if(!this.contains(t.x,t.y))return!1}return this.points.length<this.config.capacity&&null===this.northWest?(this.points.push(t),!0):(null===this.northWest&&this.subdivide(),!!this.northWest.insert(t)||(!!this.northEast.insert(t)||(!!this.southEast.insert(t)||!!this.southWest.insert(t))))},subdivide:function(){var t=this.xlb+.5*(this.xub-this.xlb),e=this.ylb+.5*(this.yub-this.ylb);this.northWest=new math.A.Quadtree([this.xlb,this.yub,t,e],this.config,this),this.northEast=new math.A.Quadtree([t,this.yub,this.xub,e],this.config,this),this.southEast=new math.A.Quadtree([this.xlb,e,t,this.ylb],this.config,this),this.southWest=new math.A.Quadtree([t,e,this.xub,this.ylb],this.config,this)},_query:function(t,e){var i;if(this.contains(t,e)){if(null===this.northWest)return this;if(i=this.northWest._query(t,e))return i;if(i=this.northEast._query(t,e))return i;if(i=this.southEast._query(t,e))return i;if(i=this.southWest._query(t,e))return i}return!1},query:function(t,e){var i,s;return utils_type.A.exists(e)?(i=t,s=e):(i=t.usrCoords[1],s=t.usrCoords[2]),this._query(i,s)},hasPoint:function(t,e,i){var s,r,o;if(this.contains(t,e)){switch(o=this.points.length,this.config.pointType){case"coords":for(r=0;r<o;r++)if(geometry.A.distance([t,e],this.points[r].usrCoords.slice(1),2)<i)return!0;break;case"object":for(r=0;r<o;r++)if(geometry.A.distance([t,e],[this.points[r].x,this.points[r].y],2)<i)return!0}if(null===this.northWest)return!1;if(s=this.northWest.hasPoint(t,e,i))return s;if(s=this.northEast.hasPoint(t,e,i))return s;if(s=this.southEast.hasPoint(t,e,i))return s;if(s=this.southWest.hasPoint(t,e,i))return s}return!1},getAllPoints:function(){var t=[];return this.getAllPointsRecursive(t),t},getAllPointsRecursive(t){Array.prototype.push.apply(t,this.points.slice()),null!==this.northWest&&(this.northWest.getAllPointsRecursive(t),this.northEast.getAllPointsRecursive(t),this.southEast.getAllPointsRecursive(t),this.southWest.getAllPointsRecursive(t))}});var qdt=math.A.Quadtree;math.A.BoxQuadtree=function(t,e,i){var s,r,o,n;t--,this.depth=t,this.capacity=e,this.items=[],this.northWest=null,this.northEast=null,this.southEast=null,this.southWest=null,this.bbox=null,this.cx=null,this.cy=null,i&&(s=i[0],r=i[1],o=i[2],n=i[3],this.cx=.5*(s+o),this.cy=.5*(r+n),this.bbox=[s,r,o,n])},utils_type.A.extend(math.A.BoxQuadtree.prototype,{insert:function(t){var e,i,s,r,o,n,a,l,h,u,c,d=[],p=[],_=[],f=[];if(null===this.bbox){for(i=t.length,s=n=1/0,o=r=-1/0,e=0;e<t.length;e++)s=(a=t[e]).xlb<s?a.xlb:s,r=a.yub>r?a.yub:r,o=a.xub>o?a.xub:o,n=a.ylb<n?a.ylb:n;this.cx=.5*(s+o),this.cy=.5*(r+n),this.bbox=[s,r,o,n]}else s=this.bbox[0],r=this.bbox[1],o=this.bbox[2],n=this.bbox[3];if(0===this.depth||this.items.length+t.length<this.capacity)return this.items=this.items.concat(t),this;for(i=t.length,e=0;e<i;e++)l=(a=t[e]).xlb<=this.cx&&a.yub>this.cy,u=a.xlb<=this.cx&&a.ylb<=this.cy,h=a.xub>this.cx&&a.yub>this.cy,c=a.xub>this.cx&&a.ylb<=this.cy,l&&h&&c&&u?this.items.push(a):(l&&d.push(a),u&&_.push(a),h&&p.push(a),c&&f.push(a));return this.subdivide(d,_,p,f,s,r,o,n),this},insertItem:function(t){var e,i,s,r,o,n,a,l,h=[],u=[],c=[],d=[];return null===this.bbox?(e=r=1/0,s=i=-1/0,e=t.xlb<e?t.xlb:e,i=t.yub>i?t.yub:i,s=t.xub>s?t.xub:s,r=t.ylb<r?t.ylb:r,this.cx=.5*(e+s),this.cy=.5*(i+r),this.bbox=[e,i,s,r]):(e=this.bbox[0],i=this.bbox[1],s=this.bbox[2],r=this.bbox[3]),0===this.depth||this.items.length+1<this.capacity?(this.items.push(t),this):(o=t.xlb<=this.cx&&t.yub>this.cy,a=t.xlb<=this.cx&&t.ylb<=this.cy,n=t.xub>this.cx&&t.yub>this.cy,l=t.xub>this.cx&&t.ylb<=this.cy,o&&n&&l&&a?this.items.push(t):(o&&h.push(t),a&&c.push(t),n&&u.push(t),l&&d.push(t)),this.subdivide(h,c,u,d,e,i,s,r),this)},subdivide:function(t,e,i,s,r,o,n,a){return t.length>0&&(null===this.northWest&&(this.northWest=new JXG.Math.BoxQuadtree(this.depth,this.capacity,[r,o,this.cx,this.cy])),this.northWest.insert(t)),e.length>0&&(null===this.southWest&&(this.southWest=new JXG.Math.BoxQuadtree(this.depth,this.capacity,[r,this.cy,this.cx,a])),this.southWest.insert(e)),i.length>0&&(null===this.northEast&&(this.northEast=new JXG.Math.BoxQuadtree(this.depth,this.capacity,[this.cx,o,n,this.cy])),this.northEast.insert(i)),s.length>0&&(null===this.southEast&&(this.southEast=new JXG.Math.BoxQuadtree(this.depth,this.capacity,[this.cx,this.cy,n,a])),this.southEast.insert(s)),this},find:function(t){var e,i,s,r=[];for(i=this.items.length,e=0;e<i;e++)s=this.items[e],t[2]>=s.xlb&&t[0]<=s.xub&&t[3]<=s.yub&&t[1]>=s.ylb&&r.push(this.items[e]);return null!==this.northWest&&t[0]<=this.cx&t[1]>=this.cy&&utils_type.A.concat(r,this.northWest.find(t)),null!==this.southWest&&t[0]<=this.cx&t[3]<=this.cy&&utils_type.A.concat(r,this.southWest.find(t)),null!==this.northEast&&t[2]>=this.cx&t[1]>=this.cy&&utils_type.A.concat(r,this.northEast.find(t)),null!==this.southEast&&t[2]>=this.cx&t[3]<=this.cy&&utils_type.A.concat(r,this.southEast.find(t)),r},analyzeTree:function(){var t,e={number_items:this.items.length,depth:1};return null!==this.northWest&&(t=this.northWest.analyzeTree(),e.number_items+=t.number_items,e.depth=Math.max(e.depth,1+t.depth)),null!==this.southWest&&(t=this.southWest.analyzeTree(),e.number_items+=t.number_items,e.depth=Math.max(e.depth,1+t.depth)),null!==this.northEast&&(t=this.northEast.analyzeTree(),e.number_items+=t.number_items,e.depth=Math.max(e.depth,1+t.depth)),null!==this.southEast&&(t=this.southEast.analyzeTree(),e.number_items+=t.number_items,e.depth=Math.max(e.depth,1+t.depth)),e},plot:function(){var t,e=[],i=[];return e.push(this.bbox[0]),i.push(this.bbox[3]),e.push(this.bbox[2]),i.push(this.bbox[3]),e.push(this.bbox[2]),i.push(this.bbox[1]),e.push(this.bbox[0]),i.push(this.bbox[1]),e.push(this.bbox[0]),i.push(this.bbox[3]),e.push(NaN),i.push(NaN),null!==this.northWest&&(t=this.northWest.plot(),utils_type.A.concat(e,t[0]),utils_type.A.concat(i,t[1])),null!==this.northEast&&(t=this.northEast.plot(),utils_type.A.concat(e,t[0]),utils_type.A.concat(i,t[1])),null!==this.southEast&&(t=this.southEast.plot(),utils_type.A.concat(e,t[0]),utils_type.A.concat(i,t[1])),null!==this.southWest&&(t=this.southWest.plot(),utils_type.A.concat(e,t[0]),utils_type.A.concat(i,t[1])),[e,i]}});var bqdt=math.A.BoxQuadtree,numerics=__webpack_require__(171);jxg.A.Math.Nlp={arr:function(t){return new Float64Array(t)},arr2:function(t,e){for(var i=0,s=new Array(t);i<t;)s[i]=this.arr(e),i++;return s},arraycopy:function(t,e,i,s,r){for(var o=0;o<r;)i[o+s]=t[o+e],o++},lastNumberOfEvaluations:0,GetLastNumberOfEvaluations:function(){return this.lastNumberOfEvaluations},Normal:0,MaxIterationsReached:1,DivergingRoundingErrors:2,FindMinimum:function(t,e,i,s,r,o,n,a,l){var h,u,c=i+2,d=this.arr(e+1),p=this;return this.lastNumberOfEvaluations=0,l&&console.log("Experimental feature 'testForRoundingErrors' is activated."),d[0]=0,this.arraycopy(s,0,d,1,e),u=function(e,i,s,r){var o,n,a=p.arr(e);return p.lastNumberOfEvaluations=p.lastNumberOfEvaluations+1,p.arraycopy(s,1,a,0,e),o=p.arr(i),n=t(e,i,a,o),p.arraycopy(o,0,r,1,i),n},h=this.cobylb(u,e,i,c,d,r,o,n,a,l),this.arraycopy(d,1,s,0,e),h},cobylb:function(t,e,i,s,r,o,n,a,l,h){var u,c,d,p,_,f,A,g,m,y,b,v,C,P,x,E,O,S,M,w,T,N,j,D,k,R,L,B,I,Y=-1,X=0,U=0,F=e+1,z=i+1,J=o,G=0,W=!1,H=!1,V=0,$=0,K=0,q=this.arr(1+s),Z=this.arr2(1+e,1+F),Q=this.arr2(1+e,1+e),tt=this.arr2(1+s,1+F),et=this.arr2(1+e,1+z),it=this.arr(1+e),st=this.arr(1+e),rt=this.arr(1+e),ot=this.arr(1+e),nt=this.arr(1+e);for(a>=2&&console.log("The initial value of RHO is "+J+" and PARMU is set to zero."),g=0,f=1/J,c=1;c<=e;++c)Z[c][F]=r[c],Z[c][c]=J,Q[c][c]=f;m=F,y=!1;t:for(;;){if(g>=l&&g>0){Y=this.MaxIterationsReached;break t}for(++g,X=t(e,i,r,q),U=0,p=1;p<=i;++p)U=Math.max(U,-q[p]);if(g!==a-1&&3!==a||this.PrintIterationResult(g,X,U,r,e,a),q[z]=X,q[s]=U,b=!0,!y){for(b=!1,c=1;c<=s;++c)tt[c][m]=q[c];if(g<=F){if(m<=e)if(tt[z][F]<=X)r[m]=Z[m][F];else{for(Z[m][F]=r[m],p=1;p<=s;++p)tt[p][m]=tt[p][F],tt[p][F]=q[p];for(p=1;p<=m;++p){for(Z[m][p]=-J,f=0,c=p;c<=m;++c)f-=Q[c][p];Q[m][p]=f}}if(g<=e){r[m=g]+=J;continue t}}y=!0}e:for(;;){i:do{if(!b){for(v=tt[z][F]+G*tt[s][F],C=F,d=1;d<=e;++d)(f=tt[z][d]+G*tt[s][d])<v?(C=d,v=f):f===v&&0===G&&tt[s][d]<tt[s][C]&&(C=d);if(C<=e){for(c=1;c<=s;++c)f=tt[c][F],tt[c][F]=tt[c][C],tt[c][C]=f;for(c=1;c<=e;++c){for(f=Z[c][C],Z[c][C]=0,Z[c][F]+=f,A=0,p=1;p<=e;++p)Z[c][p]-=f,A-=Q[p][c];Q[C][c]=A}}if(P=0,h)for(c=1;c<=e;++c)for(d=1;d<=e;++d)f=this.DOT_PRODUCT_ROW_COL(Q,c,Z,d,1,e)-(c===d?1:0),P=Math.max(P,Math.abs(f));if(P>.1){Y=this.DivergingRoundingErrors;break t}for(p=1;p<=z;++p){for(q[p]=-tt[p][F],d=1;d<=e;++d)nt[d]=tt[p][d]+q[p];for(c=1;c<=e;++c)et[c][p]=(p===z?-1:1)*this.DOT_PRODUCT_ROW_COL(nt,-1,Q,c,1,e)}for(W=!0,V=.25*J,x=2.1*J,d=1;d<=e;++d){for(E=0,O=0,p=1;p<=e;++p)E+=Q[d][p]*Q[d][p],O+=Z[p][d]*Z[p][d];it[d]=1/Math.sqrt(E),st[d]=Math.sqrt(O),(it[d]<V||st[d]>x)&&(W=!1)}if(!y&&!W){for(m=0,f=x,d=1;d<=e;++d)st[d]>f&&(m=d,f=st[d]);if(0===m)for(d=1;d<=e;++d)it[d]<f&&(m=d,f=it[d]);for(f=.5*J*it[m],p=1;p<=e;++p)ot[p]=f*Q[m][p];for(S=0,M=0,u=0,p=1;p<=z;++p)u=this.DOT_PRODUCT_ROW_COL(ot,-1,et,p,1,e),p<z&&(f=tt[p][F],S=Math.max(S,-u-f),M=Math.max(M,u-f));for(w=G*(S-M)>2*u?-1:1,f=0,c=1;c<=e;++c)ot[c]=w*ot[c],Z[c][m]=ot[c],f+=Q[m][c]*ot[c];for(p=1;p<=e;++p)Q[m][p]/=f;for(d=1;d<=e;++d){if(d!==m)for(f=this.DOT_PRODUCT_ROW_COL(Q,d,ot,-1,1,e),p=1;p<=e;++p)Q[d][p]-=f*Q[m][p];r[d]=Z[d][F]+ot[d]}continue t}if(!(H=this.trstlp(e,i,et,q,J,ot))){for(f=0,p=1;p<=e;++p)f+=ot[p]*ot[p];if(f<.25*J*J){y=!0;break i}}for(u=0,T=0,q[z]=0,p=1;p<=z;++p)u=q[p]-this.DOT_PRODUCT_ROW_COL(ot,-1,et,p,1,e),p<z&&(T=Math.max(T,u));if(G<1.5*(N=($=tt[s][F]-T)>0?u/$:0))for(G=2*N,a>=2&&console.log("Increase in PARMU to "+G),j=tt[z][F]+G*tt[s][F],d=1;d<=e;++d)if((f=tt[z][d]+G*tt[s][d])<j||f===j&&0===G&&tt[s][d]<tt[s][F])continue e;for(K=G*$-u,p=1;p<=e;++p)r[p]=Z[p][F]+ot[p];y=!0;continue t}for(b=!1,D=tt[z][F]+G*tt[s][F]-(X+G*U),0===G&&X===tt[z][F]&&(K=$,D=tt[s][F]-U),k=D<=0?1:0,m=0,d=1;d<=e;++d)(f=Math.abs(this.DOT_PRODUCT_ROW_COL(Q,d,ot,-1,1,e)))>k&&(m=d,k=f),rt[d]=f*it[d];for(R=1.1*J,_=0,d=1;d<=e;++d)if(rt[d]>=V||rt[d]>=it[d]){if(f=st[d],D>0){for(f=0,p=1;p<=e;++p)f+=Math.pow(ot[p]-Z[p][d],2);f=Math.sqrt(f)}f>R&&(_=d,R=f)}if(_>0&&(m=_),0!==m){for(f=0,c=1;c<=e;++c)Z[c][m]=ot[c],f+=Q[m][c]*ot[c];for(p=1;p<=e;++p)Q[m][p]/=f;for(d=1;d<=e;++d)if(d!==m)for(f=this.DOT_PRODUCT_ROW_COL(Q,d,ot,-1,1,e),p=1;p<=e;++p)Q[d][p]-=f*Q[m][p];for(p=1;p<=s;++p)tt[p][m]=q[p];if(D>0&&D>=.1*K)continue e}}while(0);if(W){if(J<=n){Y=this.Normal;break t}if(L=0,B=0,(J*=.5)<=1.5*n&&(J=n),G>0){for(I=0,p=1;p<=z;++p){for(B=L=tt[p][F],c=1;c<=e;++c)L=Math.min(L,tt[p][c]),B=Math.max(B,tt[p][c]);p<=i&&L<.5*B&&(f=Math.max(B,0)-L,I=I<=0?f:Math.min(I,f))}0===I?G=0:B-L<G*I&&(G=(B-L)/I)}a>=2&&console.log("Reduction in RHO to "+J+"  and PARMU = "+G),2===a&&this.PrintIterationResult(g,tt[z][F],tt[s][F],this.COL(Z,F),e,a)}else y=!1}}switch(Y){case this.Normal:if(a>=1&&console.log("%nNormal return from subroutine COBYLA%n"),H)return a>=1&&this.PrintIterationResult(g,X,U,r,e,a),Y;break;case this.MaxIterationsReached:a>=1&&console.log("%nReturn from subroutine COBYLA because the MAXFUN limit has been reached.%n");break;case this.DivergingRoundingErrors:a>=1&&console.log("%nReturn from subroutine COBYLA because rounding errors are becoming damaging.%n")}for(p=1;p<=e;++p)r[p]=Z[p][F];return X=tt[z][F],U=tt[s][F],a>=1&&this.PrintIterationResult(g,X,U,r,e,a),Y},trstlp:function(t,e,i,s,r,o){var n,a,l,h,u,c,d,p,_,f,A,g,m,y,b,v,C,P,x,E,O,S,M,w,T,N,j,D,k,R,L,B,I,Y=0,X=0,U=0,F=this.arr2(1+t,1+t),z=this.arr(2+e),J=this.arr(2+e),G=this.arr(1+t),W=this.arr(1+t),H=this.arr(2+e),V=this.arr(2+e),$=e,K=0;for(l=1;l<=t;++l)F[l][l]=1,o[l]=0;if(n=0,a=0,e>=1){for(h=1;h<=e;++h)s[h]>a&&(a=s[h],n=h);for(h=1;h<=e;++h)V[h]=h,J[h]=a-s[h]}u=!0;do{t:for(;;){(!u||u&&0===a)&&(n=$=e+1,V[$]=$,J[$]=0),u=!1,c=0,d=0,p=0,_=0;e:do{if(f=$===e?a:-this.DOT_PRODUCT_ROW_COL(o,-1,i,$,1,t),0===d||f<c?(c=f,X=K,d=3):K>X?(X=K,d=3):--d,0===d)break t;if(A=0,n<=K){if(n<K){g=V[n],m=J[n],h=n;do{for(v=V[b=h+1],C=this.DOT_PRODUCT(this.PART(this.COL(F,h),1,t),this.PART(this.COL(i,v),1,t)),Y=math.A.hypot(C,z[b]),P=z[b]/Y,x=C/Y,z[b]=P*z[h],z[h]=Y,l=1;l<=t;++l)Y=P*F[l][b]+x*F[l][h],F[l][b]=P*F[l][h]-x*F[l][b],F[l][h]=Y;V[h]=v,J[h]=J[b],h=b}while(h<K);V[h]=g,J[h]=m}if(--K,$>e)for(Y=1/z[K],h=1;h<=t;++h)G[h]=Y*F[h][K];else for(Y=this.DOT_PRODUCT_ROW_COL(G,-1,F,K+1,1,t),h=1;h<=t;++h)G[h]-=Y*F[h][K+1]}else{for(v=V[n],h=1;h<=t;++h)W[h]=i[h][v];for(E=0,h=t;h>K;){for(C=0,O=0,l=1;l<=t;++l)C+=Y=F[l][h]*W[l],O+=Math.abs(Y);if(S=O+.1*Math.abs(C),M=O+.2*Math.abs(C),(O>=S||S>=M)&&(C=0),0===E)E=C;else for(b=h+1,P=C/(Y=math.A.hypot(C,E)),x=E/Y,E=Y,l=1;l<=t;++l)Y=P*F[l][h]+x*F[l][b],F[l][b]=P*F[l][b]-x*F[l][h],F[l][h]=Y;--h}if(0===E){A=-1,h=K;do{for(w=0,T=0,l=1;l<=t;++l)w+=Y=F[l][h]*W[l],T+=Math.abs(Y);if(S=T+.1*Math.abs(w),M=T+.2*Math.abs(w),T<S&&S<M){if((Y=w/z[h])>0&&V[h]<=e&&(I=J[h]/Y,(A<0||I<A)&&(A=I)),h>=2)for(N=V[h],l=1;l<=t;++l)W[l]-=Y*i[l][N];H[h]=Y}else H[h]=0}while(--h>0);if(A<0)break t;for(h=1;h<=K;++h)J[h]=Math.max(0,J[h]-A*H[h]);if(n<K){g=V[n],m=J[n],h=n;do{for(N=V[b=h+1],C=this.DOT_PRODUCT(this.PART(this.COL(F,h),1,t),this.PART(this.COL(i,N),1,t)),Y=math.A.hypot(C,z[b]),P=z[b]/Y,x=C/Y,z[b]=P*z[h],z[h]=Y,l=1;l<=t;++l)Y=P*F[l][b]+x*F[l][h],F[l][b]=P*F[l][h]-x*F[l][b],F[l][h]=Y;V[h]=N,J[h]=J[b],h=b}while(h<K);V[h]=g,J[h]=m}if(0===(Y=this.DOT_PRODUCT(this.PART(this.COL(F,K),1,t),this.PART(this.COL(i,v),1,t))))break t;z[K]=Y,J[n]=0,J[K]=A}else z[++K]=E,J[n]=J[K],J[K]=0;if(V[n]=V[K],V[K]=v,$>e&&v!==$){for(h=K-1,C=this.DOT_PRODUCT(this.PART(this.COL(F,h),1,t),this.PART(this.COL(i,v),1,t)),Y=math.A.hypot(C,z[K]),P=z[K]/Y,x=C/Y,z[K]=P*z[h],z[h]=Y,l=1;l<=t;++l)Y=P*F[l][K]+x*F[l][h],F[l][K]=P*F[l][h]-x*F[l][K],F[l][h]=Y;V[K]=V[h],V[h]=v,Y=J[h],J[h]=J[K],J[K]=Y}if($>e)for(Y=1/z[K],h=1;h<=t;++h)G[h]=Y*F[h][K];else for(v=V[K],Y=(this.DOT_PRODUCT_ROW_COL(G,-1,i,v,1,t)-1)/z[K],h=1;h<=t;++h)G[h]-=Y*F[h][K]}for(j=r*r,k=0,D=0,l=1;l<=t;++l)Math.abs(o[l])>=1e-6*r&&(j-=o[l]*o[l]),k+=o[l]*G[l],D+=G[l]*G[l];if(j<=0)break t;if(Y=Math.sqrt(D*j),Math.abs(k)>=1e-6*Y&&(Y=Math.sqrt(D*j+k*k)),p=_=j/(Y+k),$===e){if(M=p+.2*a,p>=(S=p+.1*a)||S>=M)break e;p=Math.min(p,a)}for(h=1;h<=t;++h)W[h]=o[h]+p*G[h];if($===e)for(U=a,a=0,h=1;h<=K;++h)Y=s[v=V[h]]-this.DOT_PRODUCT_ROW_COL(W,-1,i,v,1,t),a=Math.max(a,Y);h=K;do{for(R=0,L=0,l=1;l<=t;++l)R+=Y=F[l][h]*W[l],L+=Math.abs(Y);if(S=L+.1*Math.abs(R),M=L+.2*Math.abs(R),(L>=S||S>=M)&&(R=0),H[h]=R/z[h],h>=2)for(v=V[h],l=1;l<=t;++l)W[l]-=H[h]*i[l][v]}while(h-- >=2);for($>e&&(H[K]=Math.max(0,H[K])),h=1;h<=t;++h)W[h]=o[h]+p*G[h];if($>K)for(h=K+1;h<=$;++h){for(y=a-s[v=V[h]],B=a+Math.abs(s[v]),l=1;l<=t;++l)y+=Y=i[l][v]*W[l],B+=Math.abs(Y);S=B+.1*Math.abs(y),M=B+.2*Math.abs(y),(B>=S||S>=M)&&(y=0),H[h]=y}for(A=1,n=0,h=1;h<=$;++h)H[h]<0&&(Y=J[h]/(J[h]-H[h]))<A&&(A=Y,n=h);for(Y=1-A,h=1;h<=t;++h)o[h]=Y*o[h]+A*W[h];for(h=1;h<=$;++h)J[h]=Math.max(0,Y*J[h]+A*H[h]);$===e&&(a=U+A*(a-U))}while(n>0);if(p===_)return!0}}while($===e);return!1},PrintIterationResult:function(t,e,i,s,r,o){o>1&&console.log("NFVALS = "+t+"  F = "+e+"  MAXCV = "+i),o>1&&console.log("X = "+this.PART(s,1,r))},ROW:function(t,e){return t[e].slice()},COL:function(t,e){var i,s=t.length,r=[];for(i=0;i<s;++i)r[i]=t[i][e];return r},PART:function(t,e,i){return t.slice(e,i+1)},FORMAT:function(t){return t.join(",")},DOT_PRODUCT:function(t,e){var i,s=0,r=t.length;for(i=0;i<r;++i)s+=t[i]*e[i];return s},DOT_PRODUCT_ROW_COL:function(t,e,i,s,r,o){var n,a=0;if(-1===e)for(n=r;n<=o;++n)a+=t[n]*i[n][s];else if(-1===s)for(n=r;n<=o;++n)a+=t[e][n]*i[n];else for(n=r;n<=o;++n)a+=t[e][n]*i[n][s];return a}};var nlp=jxg.A.Math.Nlp,base_coords=__webpack_require__(904),statistics=__webpack_require__(588);math.A.Plot={checkReal:function(t){var e,i,s=!1,r=t.length;for(e=0;e<r;e++)if(i=t[e].usrCoords,!isNaN(i[1])&&!isNaN(i[2])&&Math.abs(i[0])>math.A.eps){s=!0;break}return s},updateParametricCurveNaive:function(t,e,i,s){var r,o,n=!1,a=(i-e)/s;for(r=0;r<s;r++)o=e+r*a,t.points[r].setCoordinates(constants.A.COORDS_BY_USER,[t.X(o,n),t.Y(o,n)],!1),t.points[r]._t=o,n=!0;return t},isSegmentOutside:function(t,e,i,s,r){return e<0&&s<0||e>r.canvasHeight&&s>r.canvasHeight||t<0&&i<0||t>r.canvasWidth&&i>r.canvasWidth},isDistOK:function(t,e,i,s){return Math.abs(t)<i&&Math.abs(e)<s&&!isNaN(t+e)},isSegmentDefined:function(t,e,i,s){return!(isNaN(t+e)&&isNaN(i+s))},updateParametricCurveOld:function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_=!1,f=new base_coords.A(constants.A.COORDS_BY_USER,[0,0],t.board,!1),A=[],g=[],m=[],y=[],b=!1,v=0,C=function(t,e,i){var s,r=i[1]-t[1],o=i[2]-t[2],n=e[0]-t[1],a=e[1]-t[2],l=n*n+a*a;return l>=math.A.eps&&(s=(r*n+o*a)/l)>0&&(s<=1?(r-=s*n,o-=s*a):(r-=n,o-=a)),math.A.hypot(r,o)};for(jxg.A.deprecated("Curve.updateParametricCurveOld()"),t.board.updateQuality===t.board.BOARD_QUALITY_LOW?(c=15,d=10,p=10):(c=21,d=.7,p=.7),y[0]=i-e,s=1;s<c;s++)y[s]=.5*y[s-1];s=1,A[0]=1,g[0]=0,r=e,f.setCoordinates(constants.A.COORDS_BY_USER,[t.X(r,_),t.Y(r,_)],!1),_=!0,a=f.scrCoords[1],l=f.scrCoords[2],r=i,f.setCoordinates(constants.A.COORDS_BY_USER,[t.X(r,_),t.Y(r,_)],!1),o=f.scrCoords[1],n=f.scrCoords[2],m[0]=[o,n],h=1,u=0,t.points=[],t.points[v++]=new base_coords.A(constants.A.COORDS_BY_SCREEN,[a,l],t.board,!1);do{for(b=this.isDistOK(o-a,n-l,d,p)||this.isSegmentOutside(a,l,o,n,t.board);u<c&&(!b||u<6)&&(u<=7||this.isSegmentDefined(a,l,o,n));)A[h]=s,g[h]=u,m[h]=[o,n],h+=1,r=e+(s=2*s-1)*y[++u],f.setCoordinates(constants.A.COORDS_BY_USER,[t.X(r,_),t.Y(r,_)],!1,!0),o=f.scrCoords[1],n=f.scrCoords[2],b=this.isDistOK(o-a,n-l,d,p)||this.isSegmentOutside(a,l,o,n,t.board);v>1&&C(t.points[v-2].scrCoords,[o,n],t.points[v-1].scrCoords)<.015&&(v-=1),t.points[v]=new base_coords.A(constants.A.COORDS_BY_SCREEN,[o,n],t.board,!1),t.points[v]._t=r,v+=1,a=o,l=n,o=m[h-=1][0],n=m[h][1],u=g[h]+1,s=2*A[h]}while(h>0&&v<5e5);return t.numberPoints=t.points.length,t},_insertPoint_v2:function(t,e,i){var s=!isNaN(this._lastCrds[1]+this._lastCrds[2]),r=!isNaN(e.scrCoords[1]+e.scrCoords[2]),o=t.board.canvasWidth,n=t.board.canvasHeight,a=500;(!(r=r&&e.scrCoords[1]>-500&&e.scrCoords[2]>-500&&e.scrCoords[1]<o+a&&e.scrCoords[2]<n+a)&&s||r&&(!s||Math.abs(e.scrCoords[1]-this._lastCrds[1])>.7||Math.abs(e.scrCoords[2]-this._lastCrds[2])>.7))&&(e._t=i,t.points.push(e),this._lastCrds=e.copy("scrCoords"))},neighborhood_isNaN_v2:function(t,e){var i,s,r=new base_coords.A(constants.A.COORDS_BY_USER,[0,0],t.board,!1);return i=e+math.A.eps,r.setCoordinates(constants.A.COORDS_BY_USER,[t.X(i,!0),t.Y(i,!0)],!1),s=r.usrCoords,!!(isNaN(s[1]+s[2])||(i=e-math.A.eps,r.setCoordinates(constants.A.COORDS_BY_USER,[t.X(i,!0),t.Y(i,!0)],!1),s=r.usrCoords,isNaN(s[1]+s[2])))},_borderCase:function(t,e,i,s,r,o,n,a){var l,h,u,c,d,p,_=null,f=!1;if(a<=1){if(h=new base_coords.A(constants.A.COORDS_BY_USER,[0,0],t.board,!1),isNaN(e[1]+e[2])&&!isNaN(s[1]+s[2])&&!this.neighborhood_isNaN_v2(t,r))return!1;if(isNaN(i[1]+i[2])&&!isNaN(s[1]+s[2])&&!this.neighborhood_isNaN_v2(t,o))return!1;if(isNaN(s[1]+s[2])&&(!isNaN(e[1]+e[2])||!isNaN(i[1]+i[2]))&&!this.neighborhood_isNaN_v2(t,n))return!1;c=0;do{if(isNaN(e[1]+e[2])&&!isNaN(s[1]+s[2]))d=r,p=n;else if(isNaN(i[1]+i[2])&&!isNaN(s[1]+s[2]))d=o,p=n;else if(isNaN(s[1]+s[2])&&!isNaN(i[1]+i[2]))d=n,p=o;else{if(!isNaN(s[1]+s[2])||isNaN(e[1]+e[2]))return!1;d=n,p=r}l=.5*(d+p),h.setCoordinates(constants.A.COORDS_BY_USER,[t.X(l,!0),t.Y(l,!0)],!1),u=h.usrCoords,(f=isNaN(u[1]+u[2]))?d=l:p=l,++c}while(f&&c<30);if(c<30&&(_=u.slice(),s=u.slice(),p=l),null!==_)return this._insertPoint_v2(t,new base_coords.A(constants.A.COORDS_BY_USER,_,t.board,!1)),!0}return!1},_plotRecursive_v2:function(t,e,i,s,r,o,n){var a,l,h,u,c,d=0,p=new base_coords.A(constants.A.COORDS_BY_USER,[0,0],t.board,!1);if(!(t.numberPoints>65536))return o<this.nanLevel&&this._isUndefined(t,e,i,s,r)||o<this.nanLevel&&this._isOutside(e,i,s,r,t.board)?this:(a=.5*(i+r),p.setCoordinates(constants.A.COORDS_BY_USER,[t.X(a,!0),t.Y(a,!0)],!1),l=p.scrCoords,this._borderCase(t,e,s,l,i,r,a,o)||(h=this._triangleDists(e,s,l),u=o<this.smoothLevel&&h[3]<n,c=o<=this.jumpLevel&&(isNaN(h[0])||isNaN(h[1])||isNaN(h[2]))||o<this.jumpLevel&&(h[2]>.99*h[0]||h[1]>.99*h[0]||h[0]===1/0||h[1]===1/0||h[2]===1/0),o<this.smoothLevel+2&&h[0]<.5*(h[1]+h[2])&&(d=0,u=!1),--o,c?this._insertPoint_v2(t,new base_coords.A(constants.A.COORDS_BY_SCREEN,[NaN,NaN],t.board,!1),a):o<=d||u?this._insertPoint_v2(t,p,a):(this._plotRecursive_v2(t,e,i,l,a,o,n),isNaN(p.scrCoords[1]+p.scrCoords[2])||this._insertPoint_v2(t,p,a),this._plotRecursive_v2(t,l,a,s,r,o,n))),this)},updateParametricCurve_v2:function(t,e,i){var s,r,o,n,a,l,h,u,c,d=!1,p=new base_coords.A(constants.A.COORDS_BY_USER,[0,0],t.board,!1),_=new base_coords.A(constants.A.COORDS_BY_USER,[0,0],t.board,!1);return t.board.updateQuality===t.board.BOARD_QUALITY_LOW?(a=utils_type.A.evaluate(t.visProp.recursiondepthlow)||13,l=2,this.smoothLevel=a-6,this.jumpLevel=3):(a=utils_type.A.evaluate(t.visProp.recursiondepthhigh)||17,l=2,this.smoothLevel=a-9,this.jumpLevel=2),this.nanLevel=a-4,t.points=[],"x"===this.xterm?(h=.3*((u=t.board.getBoundingBox())[2]-u[0]),s=Math.max(e,u[0]-h),r=Math.min(i,u[2]+h)):(s=e,r=i),p.setCoordinates(constants.A.COORDS_BY_USER,[t.X(s,d),t.Y(s,d)],!1),d=!0,_.setCoordinates(constants.A.COORDS_BY_USER,[t.X(r,d),t.Y(r,d)],!1),c=this._findStartPoint(t,p.scrCoords,s,_.scrCoords,r),p.setCoordinates(constants.A.COORDS_BY_SCREEN,c[0],!1),s=c[1],c=this._findStartPoint(t,_.scrCoords,r,p.scrCoords,s),_.setCoordinates(constants.A.COORDS_BY_SCREEN,c[0],!1),r=c[1],this._visibleArea=[s,r],o=p.copy("scrCoords"),n=_.copy("scrCoords"),p._t=s,t.points.push(p),this._lastCrds=p.copy("scrCoords"),this._plotRecursive_v2(t,o,s,n,r,a,l),_._t=r,t.points.push(_),t.numberPoints=t.points.length,t},_insertLimesPoint:function(t,e,i,s,r){var o,n,a;Math.abs(this._lastUsrCrds[1])===1/0&&Math.abs(r.left_x)===1/0||Math.abs(this._lastUsrCrds[2])===1/0&&Math.abs(r.left_y)===1/0||((o=new base_coords.A(constants.A.COORDS_BY_USER,[r.left_x,r.left_y],t.board))._t=i,t.points.push(o),isNaN(r.left_x)||isNaN(r.left_y)||isNaN(r.right_x)||isNaN(r.right_y)||!(Math.abs(r.left_x-r.right_x)>math.A.eps||Math.abs(r.left_y-r.right_y)>math.A.eps)||((n=new base_coords.A(constants.A.COORDS_BY_SCREEN,e,t.board))._t=i,t.points.push(n)),(a=new base_coords.A(constants.A.COORDS_BY_USER,[r.right_x,r.right_y],t.board))._t=i,t.points.push(a),this._lastScrCrds=a.copy("scrCoords"),this._lastUsrCrds=a.copy("usrCoords"))},_insertPoint:function(t,e,i,s,r){var o,n=!isNaN(this._lastScrCrds[1]+this._lastScrCrds[2]),a=!isNaN(e[1]+e[2]),l=t.board.canvasWidth,h=t.board.canvasHeight,u=500;utils_type.A.exists(r)?this._insertLimesPoint(t,e,i,s,r):(a=a&&e[1]>-500&&e[2]>-500&&e[1]<l+u&&e[2]<h+u,(n||a)&&(a&&n&&Math.abs(e[1]-this._lastScrCrds[1])<.8&&Math.abs(e[2]-this._lastScrCrds[2])<.8||Math.abs(e[1])===1/0&&Math.abs(this._lastUsrCrds[1])===1/0||Math.abs(e[2])===1/0&&Math.abs(this._lastUsrCrds[2])===1/0||((o=new base_coords.A(constants.A.COORDS_BY_SCREEN,e,t.board))._t=i,t.points.push(o),this._lastScrCrds=o.copy("scrCoords"),this._lastUsrCrds=o.copy("usrCoords"))))},_triangleDists:function(t,e,i){var s;return s=[t[0]*e[0],.5*(t[1]+e[1]),.5*(t[2]+e[2])],[geometry.A.distance(t,e,3),geometry.A.distance(t,i,3),geometry.A.distance(i,e,3),geometry.A.distance(i,s,3)]},_isUndefined:function(t,e,i,s,r){var o,n,a;if(!isNaN(e[1]+e[2])||!isNaN(s[1]+s[2]))return!1;for(a=new base_coords.A(constants.A.COORDS_BY_USER,[0,0],t.board,!1),n=0;n<20;++n)if(o=i+Math.random()*(r-i),a.setCoordinates(constants.A.COORDS_BY_USER,[t.X(o,!0),t.Y(o,!0)],!1),!isNaN(a.scrCoords[0]+a.scrCoords[1]+a.scrCoords[2]))return!1;return!0},_isOutside:function(t,e,i,s,r){var o=500,n=r.canvasWidth,a=r.canvasHeight;return!!(t[1]<-500&&i[1]<-500||t[2]<-500&&i[2]<-500||t[1]>n+o&&i[1]>n+o||t[2]>a+o&&i[2]>a+o)},_isOutsidePoint:function(t,e){var i=500,s=e.canvasWidth,r=e.canvasHeight;return!!(t[1]<-500||t[2]<-500||t[1]>s+i||t[2]>r+i)},_findStartPoint:function(t,e,i,s,r){return[e,i]},_getBorderPos:function(t,e,i,s,r,o,n){var a,l,h,u,c,d;if(l=new base_coords.A(constants.A.COORDS_BY_USER,[0,0],t.board,!1),u=0,isNaN(i[1]+i[2])&&!isNaN(r[1]+r[2]))d=e,c=s;else if(isNaN(n[1]+n[2])&&!isNaN(r[1]+r[2]))d=o,c=s;else if(isNaN(r[1]+r[2])&&!isNaN(n[1]+n[2]))d=s,c=o;else{if(!isNaN(r[1]+r[2])||isNaN(i[1]+i[2]))return!1;d=s,c=e}do{a=.5*(c+d),l.setCoordinates(constants.A.COORDS_BY_USER,[t.X(a,!0),t.Y(a,!0)],!1),h=l.usrCoords,isNaN(h[1]+h[2])?d=a:c=a,++u}while(u<30&&Math.abs(c-d)>math.A.eps);return a},_getCuspPos:function(t,e,i){var s=[t.X(e,!0),t.Y(e,!0)],r=[t.X(i,!0),t.Y(i,!0)];return numerics.A.fminbr((function(e){var i=[t.X(e,!0),t.Y(e,!0)];return-(math.A.hypot(s[0]-i[0],s[1]-i[1])+math.A.hypot(r[0]-i[0],r[1]-i[1]))}),[e,i],t)},_getJumpPos:function(t,e,i){return numerics.A.fminbr((function(e){var i=math.A.eps*math.A.eps,s=[t.X(e,!0),t.Y(e,!0)],r=[t.X(e+i,!0),t.Y(e+i,!0)];return-Math.abs((r[1]-s[1])/(r[0]-s[0]))}),[e,i],t)},_getLimits:function(t,e){var i,s,r,o,n,a=2/(t.maxX()-t.minX());return s=(i=extrapolate.limit(e,-a,t.X))[0],"infinite"===i[1]&&(s=Math.sign(s)*(1/0)),o=(i=extrapolate.limit(e,-a,t.Y))[0],"infinite"===i[1]&&(o=Math.sign(o)*(1/0)),r=(i=extrapolate.limit(e,a,t.X))[0],"infinite"===i[1]&&(r=Math.sign(r)*(1/0)),n=(i=extrapolate.limit(e,a,t.Y))[0],"infinite"===i[1]&&(n=Math.sign(n)*(1/0)),{left_x:s,left_y:o,right_x:r,right_y:n,t:e}},_getLimes:function(t,e,i,s,r,o,n,a,l){var h;return"border"===a?h=this._getBorderPos(t,e,i,s,r,o,n):"cusp"===a?h=this._getCuspPos(t,e,o):"jump"===a&&(h=this._getJumpPos(t,e,o)),this._getLimits(t,h)},_plotNonRecursive:function(t,e,i,s,r,o){var n,a,l,h,u,c,d,p,_,f,A,g=null,m=!1,y="",b=[],v=0;for(p=t.board.origin.scrCoords,b[v++]=[e,i,s,r,o,1/0];v>0;){if(e=(A=b[--v])[0],i=A[1],s=A[2],r=A[3],_=A[4],f=A[5],m=!1,y="",g=null,t.points.length>65536)return;if(_<this.nanLevel){if(this._isUndefined(t,e,i,s,r))continue;if(this._isOutside(e,i,s,r,t.board))continue}n=.5*(i+r),c=t.X(n,!0),d=t.Y(n,!0),a=[1,p[1]+c*t.board.unitX,p[2]-d*t.board.unitY],l=this._triangleDists(e,s,a),h=isNaN(e[1]+e[2]),u=isNaN(s[1]+s[2]),h&&!u||!h&&u?y="border":l[0]>.66*f||l[0]<this.cusp_threshold*(l[1]+l[2])||l[1]>5*l[2]||l[2]>5*l[1]?y="cusp":(l[2]>this.jump_threshold*l[0]||l[1]>this.jump_threshold*l[0]||l[0]===1/0||l[1]===1/0||l[2]===1/0)&&(y="jump"),m=""===y&&_<this.smoothLevel&&l[3]<this.smooth_threshold,_<this.testLevel&&!m&&(""===y?m=!0:g=this._getLimes(t,i,e,n,a,r,s,y,_)),null!==g?(a=[1,NaN,NaN],this._insertPoint(t,a,n,_,g)):_<=0||m?this._insertPoint(t,a,n,_,null):(b[v++]=[a,n,s,r,_-1,l[0]],b[v++]=[e,i,a,n,_-1,l[0]])}return this},updateParametricCurve_v3:function(t,e,i){var s,r,o,n,a,l,h,u,c=!1,d=new base_coords.A(constants.A.COORDS_BY_USER,[0,0],t.board,!1),p=new base_coords.A(constants.A.COORDS_BY_USER,[0,0],t.board,!1);return a=t.board.updateQuality===t.board.BOARD_QUALITY_LOW?utils_type.A.evaluate(t.visProp.recursiondepthlow)||14:utils_type.A.evaluate(t.visProp.recursiondepthhigh)||17,this.smoothLevel=7,this.nanLevel=a-4,this.testLevel=4,this.cusp_threshold=.5,this.jump_threshold=.99,this.smooth_threshold=2,t.points=[],"x"===t.xterm?(l=.3*((h=t.board.getBoundingBox())[2]-h[0]),s=Math.max(e,h[0]-l),r=Math.min(i,h[2]+l)):(s=e,r=i),d.setCoordinates(constants.A.COORDS_BY_USER,[t.X(s,c),t.Y(s,c)],!1),c=!0,p.setCoordinates(constants.A.COORDS_BY_USER,[t.X(r,c),t.Y(r,c)],!1),u=this._findStartPoint(t,d.scrCoords,s,p.scrCoords,r),d.setCoordinates(constants.A.COORDS_BY_SCREEN,u[0],!1),s=u[1],u=this._findStartPoint(t,p.scrCoords,r,d.scrCoords,s),p.setCoordinates(constants.A.COORDS_BY_SCREEN,u[0],!1),r=u[1],this._visibleArea=[s,r],o=d.copy("scrCoords"),n=p.copy("scrCoords"),d._t=s,t.points.push(d),this._lastScrCrds=d.copy("scrCoords"),this._lastUsrCrds=d.copy("usrCoords"),this._plotNonRecursive(t,o,s,n,r,a),p._t=r,t.points.push(p),t.numberPoints=t.points.length,t},_criticalInterval:function(t,e,i){var s,r,o,n,a,l,h,u=!1,c=-1/0,d=!1,p=!1,_=0,f=[],A=[],g=[];for(h=statistics.A.abs(t),(n=statistics.A.median(h))<1e-7?(n=1e-7,d=!0):n*=this.criticalThreshold,s=0;s<e;s++)h[s]>n?(g.push({i:s,v:t[s],group:_}),c=s,u||(u=!0)):u&&s>c+4&&(g.length>0&&f.push(g.slice(0)),g=[],u=!1,_++);for(u&&g.length>1&&f.push(g.slice(0)),d&&0===f.length&&(p=!0),r=0;r<f.length;r++)if(A[r]="point",!((o=f[r].length)<64)){for(l=0,a=Math.sign(f[r][0].v),s=1;s<o;s++)Math.sign(f[r][s].v)!==a&&(l++,a=Math.sign(f[r][s].v));6*l>o&&(A[r]="interval")}return{smooth:p,groups:f,types:A}},Component:function(){this.left_isNaN=!1,this.right_isNaN=!1,this.left_t=null,this.right_t=null,this.t_values=[],this.x_values=[],this.y_values=[],this.len=0},findComponents:function(t,e,i,s){var r,o,n,a,l,h,u=[],c=0,d=0,p=0,_=!1,f=!1;for(n=(i-e)/s,u[c]=new this.Component,h=u[c],r=0,o=e;r<=s;r++,o+=n)a=t.X(o,f),l=t.Y(o,f),isNaN(a)||isNaN(l)?++p>1&&_&&(h.right_isNaN=!0,h.right_t=o-n,h.len=d,_=!1,u[++c]=new this.Component,h=u[c],p=0):(_||(_=!0,d=0,p>0&&(h.left_t=o-n,h.left_isNaN=!0)),p=0,h.t_values[d]=o,h.x_values[d]=a,h.y_values[d]=l,d++),0===r&&(f=!0);return _?h.len=d:u.pop(),u},getPointType:function(t,e,i,s,r,o,n){var a=r[0],l=o[0],h=s.length,u={idx:e,t:i,x:a[e],y:l[e],type:"other"};return e<5?(u.type="borderleft",u.idx=0,u.t=s[0],u.x=a[0],u.y=l[0],u):e>n-6?(u.type="borderright",u.idx=h-1,u.t=s[h-1],u.x=a[h-1],u.y=l[h-1],u):u},newtonApprox:function(t,e,i,s,r){var o,n=0;for(o=s;o>0;o--)n=(n+r[o][t])*(e-(o-1)*i)/o;return n+r[0][t]},thiele:function(t,e,i,s,r){var o,n=0;for(o=r;o>1;o--)n=(t-i[s+o])/(e[o][s+1]-e[o-2][s+1]+n);return e[0][s+1]+(t-i[s+1])/(e[1][s+1]+n)},differenceMethodExperiments:function(t,e){var i,s,r,o,n,a,l,h,u,c,d,p=t.t_values,_=t.x_values,f=t.y_values,A=[],g=[],m=[],y=[],b=[],v=[],C=[],P=[],x=0,E=[];for(n=p[1]-p[0],b.push([]),v.push([]),C.push([]),P.push([]),r=f.length,i=0;i<r;i++)b[0][i]=_[i],v[0][i]=f[i],C[0][i]=_[i],P[0][i]=f[i];for(b.push([]),v.push([]),C.push([]),P.push([]),a=n,r=f.length-1,i=0;i<r;i++)A[i]=_[i+1]-_[i],g[i]=f[i+1]-f[i],m[i]=A[i],y[i]=g[i],b[1][i]=A[i],v[1][i]=g[i],C[1][i]=a/A[i],P[1][i]=a/g[i];for(r--,o=Math.min(8,f.length-1),s=1;s<o;s++){for(b.push([]),v.push([]),C.push([]),P.push([]),a*=n,i=0;i<r;i++)A[i]=A[i+1]-A[i],g[i]=g[i+1]-g[i],b[s+1][i]=A[i],v[s+1][i]=g[i],C[s+1][i]=a/(C[s][i+1]-C[s][i])+C[s-1][i+1],P[s+1][i]=a/(P[s][i+1]-P[s][i])+P[s-1][i+1];if(!1===(d=this._criticalPoints(g,r,s))){console.log("Polynomial of degree",s),d=[];break}if(d.length>0&&++x>1&&s%2==0)break;r--}for(i=0;i<d.length;i++){for(h=-1/0,u=0;u<d[i].length;u++)(c=Math.abs(d[i][u].v))>h&&(h=c,l=u);l=Math.floor(d[i][l].i+s/2),E.push(this.getPointType(e,l,p,_,f,m,y,r+1))}return[E,b,v,C,P]},getCenterOfCriticalInterval:function(t,e,i){var s,r,o,n,a,l=0,h=0,u=i[1]-i[0],c=[];for(s=-1/0,c=[],r=0;r<t.length;r++)(n=Math.abs(t[r].v))>s?(c=[r],s=n,o=r):s===n&&c.push(r);if(c.length>0&&(a=c.reduce((function(t,e){return t+e}),0)/c.length,o=Math.floor(a),a+=t[0].i),s<1/0){for(r=0;r<t.length;r++)l+=Math.abs(t[r].v)*t[r].i,h+=Math.abs(t[r].v);a=l/h}return a+=e/2,[t[o].i+e/2,a,i[Math.floor(a)]+u*(a-Math.floor(a))]},differenceMethod:function(t,e){var i,s,r,o,n,a,l,h,u,c,d=t.t_values,p=t.x_values,_=t.y_values,f=[],A=[],g=0,m=-1,y=-1,b=[],v=[];for(r=_.length,f.push(new Float64Array(p)),A.push(new Float64Array(_)),r--,o=Math.min(12,r),s=0;s<o&&(f.push(new Float64Array(r)),A.push(new Float64Array(r)),f[s+1]=f[s].map((function(t,e,i){return i[e+1]-t})),A[s+1]=A[s].map((function(t,e,i){return i[e+1]-t})),!0===(h=this._criticalInterval(A[s+1],r,s)).smooth&&(y=s,b=[]),l=this._criticalInterval(f[s+1],r,s),-1===m&&!0===l.smooth&&(m=s),!(y>=0));s++){if(h.groups.length>0&&++g>2&&(s+1)%2==0){b=h.groups,c=h.types;break}r--}for(i=0;i<b.length;i++)"interval"!==c[i]&&(a=this.getCenterOfCriticalInterval(b[i],s+1,d),h[0],n=Math.floor(a[1]),u=a[2],v.push(this.getPointType(e,n,u,d,f,A,r+1)));return[v,f,A,m,y]},_insertPoint_v4:function(t,e,i,s){var r,o,n,a=null;t.points.length>0&&(a=t.points[t.points.length-1].scrCoords),r=new base_coords.A(constants.A.COORDS_BY_USER,e,t.board),null!==a&&(o=r.scrCoords[1]-a[1])*o+(n=r.scrCoords[2]-a[2])*n<.8*.8||(r._t=i,t.points.push(r))},getInterval:function(t,e,i){var s,r;return ia.A.disable(),s=ia.A.Interval(e,i),t.board.mathLib=ia.A,t.board.mathLibJXG=ia.A,r=t.Y(s,!0),t.board.mathLib=Math,t.board.mathLibJXG=jxg.A.Math,r},sign:function(t){return t<0?-1:t>0?1:0},handleBorder:function(t,e,i,s,r){var o,n,a,l,h,u,c,d,p,_,f,A,g=i.idx;if(A=e.t_values[1]-e.t_values[0],"borderleft"===i.type?a=(n=o=e.left_isNaN?e.left_t:i.t-A)+A:"borderright"===i.type?n=(a=o=e.right_isNaN?e.right_t:i.t+A)-A:console.log("No bordercase!!!"),0!==(_=this.findComponents(t,n,a,32)).length){for("borderleft"===i.type&&(n=_[0].left_t,a=_[0].t_values[0],A=_[0].t_values[1]-_[0].t_values[0],o=n=null===n?a-A:n,l=this.getInterval(t,n,a),utils_type.A.isObject(l)&&(c=l.lo,d=l.hi,h=t.X(o,!0),u=r[1][g]<0?d:c,this._insertPoint_v4(t,[1,h,u],o))),f=_[0].t_values.length,p=0;p<f;p++)o=_[0].t_values[p],h=_[0].x_values[p],u=_[0].y_values[p],this._insertPoint_v4(t,[1,h,u],o);"borderright"===i.type&&(n=_[0].t_values[f-1],a=_[0].right_t,A=_[0].t_values[1]-_[0].t_values[0],o=a=null===a?n+A:a,l=this.getInterval(t,n,a),utils_type.A.isObject(l)&&(c=l.lo,d=l.hi,h=t.X(o,!0),u=r[1][g]>0?d:c,this._insertPoint_v4(t,[1,h,u],o)))}},_seconditeration_v4:function(t,e,i,s,r){var o,n,a,l,h,u,c,d,p,_,f,A,g;for(n=e.t_values[i.idx-2],a=e.t_values[i.idx+2],h=this.findComponents(t,n,a,64),c=0;c<h.length;c++){for(u=h[c],d=(l=this.differenceMethod(u,t))[0],_=l[1],f=l[2],A=0,p=0;p<=d.length;p++){for(g=p===d.length?u.len:d[p].idx,o=A;o<g;o++)isNaN(u.x_values[o])||isNaN(u.y_values[o])||this._insertPoint_v4(t,[1,u.x_values[o],u.y_values[o]],u.t_values[o]);p<d.length&&(this.handleSingularity(t,u,d[p],_,f),A=d[p].idx+1)}g=u.len,c<h.length-1&&this._insertPoint_v4(t,[1,NaN,NaN],u.right_t)}return this},_recurse_v4:function(t,e,i,s,r,o,n,a){var l,h,u=.5*(e+i),c=t.X(u,!0),d=t.Y(u,!0);0!==a?(l=(c-s)*t.board.unitX,h=(d-r)*t.board.unitY,math.A.hypot(l,h)>2?this._recurse_v4(t,e,u,s,r,c,d,a-1):this._insertPoint_v4(t,[1,c,d],u),l=(c-o)*t.board.unitX,h=(d-n)*t.board.unitY,math.A.hypot(l,h)>2?this._recurse_v4(t,u,i,c,d,o,n,a-1):this._insertPoint_v4(t,[1,c,d],u)):this._insertPoint_v4(t,[1,NaN,NaN],u)},handleSingularity:function(t,e,i,s,r){var o,n,a,l,h,u,c,d,p,_,f,A=i.idx,g=100;o=i.t,console.log("HandleSingularity at t =",o),n=e.t_values[A-5],a=e.t_values[A+5],l=this.getInterval(t,n,a),utils_type.A.isObject(l)?(d=l.lo,p=l.hi):r[0][A-1]<r[0][A+1]?(d=r[0][A-1],p=r[0][A+1]):(d=r[0][A+1],p=r[0][A-1]),c=t.X(o,!0),_=(r[0][A-3]-r[0][A-5])/(e.t_values[A-3]-e.t_values[A-5]),f=(r[0][A+3]-r[0][A+5])/(e.t_values[A+3]-e.t_values[A+5]),console.log(":::",_,f),_<-100?(this._insertPoint_v4(t,[1,c,d],o,!0),f<=g&&this._insertPoint_v4(t,[1,NaN,NaN],o)):_>g?(this._insertPoint_v4(t,[1,c,p],o),f>=-100&&this._insertPoint_v4(t,[1,NaN,NaN],o)):(d===-1/0&&(this._insertPoint_v4(t,[1,c,d],o,!0),this._insertPoint_v4(t,[1,NaN,NaN],o)),p===1/0&&(this._insertPoint_v4(t,[1,NaN,NaN],o),this._insertPoint_v4(t,[1,c,p],o,!0)),i.t<e.t_values[A]?(h=A-1,u=A):(h=A,u=A+1),n=e.t_values[h],a=e.t_values[u],this._recurse_v4(t,n,a,s[0][h],r[0][h],s[0][u],r[0][u],10)),f<-100?this._insertPoint_v4(t,[1,c,p],o):f>g&&this._insertPoint_v4(t,[1,c,d],o)},steps:1021,criticalThreshold:1e3,plot_v4:function(t,e,i,s){var r,o,n,a,l,h,u,c,d,p,_,f,A,g,m,y=(i-e)/s,b=function(e){return t.Y(e,!0)},v=function(e){return-t.Y(e,!0)},C=.5*y;for(n=this.findComponents(t,e,i,s),a=0;a<n.length;a++){for(l=n[a],h=(d=this.differenceMethod(l,t))[0],p=d[1],_=d[2],0!==h.length&&"borderleft"===h[0].type||h.unshift({idx:0,t:l.t_values[0],x:l.x_values[0],y:l.y_values[0],type:"borderleft"}),"borderright"!==h[h.length-1].type&&(o=l.t_values.length,h.push({idx:o-1,t:l.t_values[o-1],x:l.x_values[o-1],y:l.y_values[o-1],type:"borderright"})),c=0,u=0;u<=h.length;u++){for(o=u===h.length?l.len:h[u].idx-1,r=c;r<o-2;r++)this._insertPoint_v4(t,[1,l.x_values[r],l.y_values[r]],l.t_values[r]),r>=c+3&&r<o-3&&_.length>3&&Math.abs(_[2][r])>.2*Math.abs(_[0][r])&&(f=l.t_values[r],C=.25*y,m=this.getInterval(t,f,f+y),utils_type.A.isObject(m)?_[2][r]>0?this._insertPoint_v4(t,[1,f+C,m.lo],f+C):this._insertPoint_v4(t,[1,f+y-C,m.hi],f+y-C):(A=numerics.A.fminbr(b,[f,f+y]))<(g=numerics.A.fminbr(v,[f,f+y]))?(this._insertPoint_v4(t,[1,t.X(A,!0),t.Y(A,!0)],A),this._insertPoint_v4(t,[1,t.X(g,!0),t.Y(g,!0)],g)):(this._insertPoint_v4(t,[1,t.X(g,!0),t.Y(g,!0)],g),this._insertPoint_v4(t,[1,t.X(A,!0),t.Y(A,!0)],A)));u<h.length&&(r=h[u].idx,"borderleft"===h[u].type||"borderright"===h[u].type?this.handleBorder(t,l,h[u],p,_):this._seconditeration_v4(t,l,h[u],p,_),c=h[u].idx+1+1)}o=l.len,a<n.length-1&&this._insertPoint_v4(t,[1,NaN,NaN],l.right_t)}},updateParametricCurve_v4:function(t,e,i){var s,r,o,n;"x"===t.xterm?(o=.3*((n=t.board.getBoundingBox())[2]-n[0]),s=Math.max(e,n[0]-o),r=Math.min(i,n[2]+o)):(s=e,r=i),t.points=[],this.plot_v4(t,s,r,this.steps),t.numberPoints=t.points.length},updateParametricCurve:function(t,e,i){return this.updateParametricCurve_v2(t,e,i)}};var plot=math.A.Plot;math.A.ImplicitPlot=function(t,e,i,s,r){var o={resolution_out:5,resolution_in:5,max_steps:1024,alpha_0:.05,tol_u0:math.A.eps,tol_newton:1e-7,tol_cusp:.05,tol_progress:1e-4,qdt_box:.2,kappa_0:.2,delta_0:.05,h_initial:.1,h_critical:.001,h_max:1,loop_dist:.09,loop_dir:.99,loop_detection:!0,unitX:10,unitY:10};this.config=utils_type.A.merge(o,e),this.f=i,this.dfx=null,this.dfy=null,utils_type.A.isFunction(s)?this.dfx=s:this.dfx=function(t,e){var i=math.A.eps*math.A.eps;return.5*(this.f(t+i,e)-this.f(t-i,e))/i},utils_type.A.isFunction(r)?this.dfy=r:this.dfy=function(t,e){var i=math.A.eps*math.A.eps;return.5*(this.f(t,e+i)-this.f(t,e-i))/i},this.bbox=t,this.qdt=new bqdt(20,5,t),this.components=[]},utils_type.A.extend(math.A.ImplicitPlot.prototype,{plot:function(){var t,e,i,s,r,o,n,a=[],l=[],h=[],u=0,c=this,d=function(e){return c.f(t,e)},p=function(e){return-c.f(t,e)},_=function(t){return c.f(t,e)},f=function(t){return-c.f(t,e)};for(i=Math.min(this.bbox[0],this.bbox[2])-math.A.eps,s=Math.max(this.bbox[0],this.bbox[2]),r=Math.min(this.bbox[1],this.bbox[3])+math.A.eps,o=Math.max(this.bbox[1],this.bbox[3]),n=this.config.resolution_out/this.config.unitX,n*=1+math.A.eps,t=i;t<s;t+=n)!1!==(h=this.searchLine(d,p,t,[r,o],"vertical",u,a,l))&&(a=h[0],l=h[1],u=h[2]);for(n=this.config.resolution_out/this.config.unitY,n*=1+math.A.eps,e=r;e<o;e+=n)!1!==(h=this.searchLine(_,f,e,[i,s],"horizontal",u,a,l))&&(a=h[0],l=h[1],u=h[2]);return[a,l,u]},searchLine:function(t,e,i,s,r,o,n,a){var l,h,u,c,d,p,_,f,A,g,m,y,b,v,C=this.config.tol_u0,P=!1,x=s[0],E=s[1];if(d=t(l=numerics.A.fminbr(t,[x,E])),p=t(h=numerics.A.fminbr(e,[x,E])),d<C&&p>-C){if(_=l,l=Math.min(_,h),h=Math.max(_,h),c=t(u=numerics.A.fzero(t,[l,h])),Math.abs(c)>Math.max((p-d)*math.A.eps,.001))return!1;if("vertical"===r?(A=[1,i,u],v=this.config.resolution_in/this.config.unitY):(A=[1,u,i],v=this.config.resolution_in/this.config.unitX),v*=1+math.A.eps,this.curveContainsPoint(A,n,a,2*v,this.config.qdt_box))P;else if((y=this.traceComponent(A,1)).length>0){for(o>0&&(n.push(NaN),a.push(NaN)),b=n.length,m=y[0].length,g=1;g<m;g++)this.qdt.insertItem({xlb:Math.min(y[0][g-1],y[0][g]),xub:Math.max(y[0][g-1],y[0][g]),ylb:Math.min(y[1][g-1],y[1][g]),yub:Math.max(y[1][g-1],y[1][g]),idx1:b+g-1,idx2:b+g,comp:o});o++,utils_type.A.concat(n,y[0]),utils_type.A.concat(a,y[1])}return(f=u-.01*v)-x>v&&!1!==(y=this.searchLine(t,e,i,[x,f],r,o,n,a))&&(n=y[0],a=y[1],o=y[2]),E-(f=u+.01*v)>v&&!1!==(y=this.searchLine(t,e,i,[f,E],r,o,n,a))&&(n=y[0],a=y[1],o=y[2]),[n,a,o]}return!1},curveContainsPoint:function(t,e,i,s,r){var o,n,a,l=t[1],h=t[2];for(n=(a=this.qdt.find([l-r,h+r,l+r,h-r])).length,o=0;o<n;o++)if(geometry.A.distPointSegment(t,[1,e[a[o].idx1],i[a[o].idx1]],[1,e[a[o].idx2],i[a[o].idx2]])<s)return!0;return!1},traceComponent:function(t){var e=[],i=[],s=[];return 0===(s=this.tracing(t,1)).length||(e=s[0],i=s[1]),s[2]||0===(s=this.tracing(t,-1)).length||(e=s[0].reverse().concat(e.slice(1)),i=s[1].reverse().concat(i.slice(1))),e.length<6&&(e.push(e[e.length-1]),i.push(i[i.length-1])),[e,i]},tracing:function(t,e){var i,s,r,o,n,a,l,h,u,c,d,p,_,f,A,g,m,y=[],b=[],v=[],C=0,P=0,x=!1,E=!1,O=!1,S=this.config.kappa_0,M=this.config.delta_0,w=this.config.alpha_0,T=this.config.h_initial,N=this.config.max_steps,j=e,D=[],k=[],R=[];if(y=t.slice(1),D.push(y[0]),k.push(y[1]),!1===(i=this.tangent(y)))return[];this.dfx(y[0],y[1]),this.dfy(y[0],y[1]);do{if(!1===(i=this.tangent(y))){y=b.slice(),D.push(y[0]),k.push(y[1]);break}if(1===D.length)r=i.slice();else if(2===D.length)R.push(D.length-1);else if(E&&D.length>2&&!O){if(geometry.A.distPointSegment([1,y[0],y[1]],[1,D[0],k[0]],[1,D[1],k[1]])<this.config.loop_dist*T&&math.A.innerProduct(i,r,2)>this.config.loop_dir){y=t.slice(1),D.push(y[0]),k.push(y[1]),x=!0;break}if(this.config.loop_detection){for(f=D.length-1,A=Math.floor(math.A.log2(f)),g=0;g<=A&&!(geometry.A.distPointSegment([1,y[0],y[1]],[1,D[R[g]-1],k[R[g]-1]],[1,D[R[g]],k[R[g]]])<this.config.loop_dist*T&&(s=this.tangent([D[R[g]],k[R[g]]]),math.A.innerProduct(i,s,2)>this.config.loop_dir));g++);if(g<=A){x=!0;break}for(A=1,m=0,g=0;g<100&&(f+1)%A==0;g++)A*=2,m++;R[m]=f}}b[0]=y[0]+T*j*i[0],b[1]=y[1]+T*j*i[1],P=0;do{u=(o=[this.dfx(b[0],b[1]),this.dfy(b[0],b[1])])[0]*o[0]+o[1]*o[1],n=this.f(b[0],b[1])/u,v[0]=b[0]-o[0]*n,v[1]=b[1]-o[1]*n,0===P?l=Math.abs(n)*Math.sqrt(u):1===P&&(h=Math.abs(n)*Math.sqrt(u)),b[0]=v[0],b[1]=v[1],P++}while(P<20&&Math.abs(this.f(b[0],b[1]))>this.config.tol_newton);if(d=l,c=P>1?h/l:0,s=this.tangent(b),a=math.A.innerProduct(i,s,2),a=Math.max(-1,Math.min(1,a)),p=Math.acos(a),O=!1,geometry.A.distance(y,b,2)<this.config.tol_progress){y=b.slice(),D.push(y[0]),k.push(y[1]);break}if(a<0)if(T>this.config.h_critical);else{if(O=!0,!this.isBifurcation(y,this.config.tol_cusp)){y=b.slice(),D.push(y[0]),k.push(y[1]);break}j*=-1,p=0}if(!O&&(_=Math.max(Math.sqrt(c/S),Math.sqrt(d/M),p/w),isNaN(_)&&(_=1),T/=_=Math.max(Math.min(_,2),.5),T=Math.min(this.config.h_max,T),_>=2)){if(++C>=3*N)break;E=!1}else y=b.slice(),D.push(y[0]),k.push(y[1]),E=!0,C++}while(C<N&&y[0]>=this.bbox[0]&&y[1]<=this.bbox[1]&&y[0]<=this.bbox[2]&&y[1]>=this.bbox[3]);return[D,k,x]},isBifurcation:function(t,e){var i,s,r,o,n,a,l,h,u,c,d=math.A.eps*math.A.eps*100;return i=t[0],s=t[1],r=.5*(this.dfx(i+d,s)-this.dfx(i-d,s))/d,o=.5*(this.dfx(i,s+d)-this.dfx(i,s-d))/d,n=.5*(this.dfy(i+d,s)-this.dfy(i-d,s))/d,c=(l=r+(a=.5*(this.dfy(i,s+d)-this.dfy(i,s-d))/d))*l-4*(r*a-o*n),h=.5*(l+Math.sqrt(c)),u=.5*(l-Math.sqrt(c)),Math.abs(h)>e&&Math.abs(u)>e},handleCriticalPoint:function(t,e,i,s){var r,o=Math.atan2(s*e[1],s*e[0]);return r=numerics.A.root((function(e){var s=t[0]+i*Math.cos(e),r=t[1]+i*Math.sin(e);return this.f(s,r)}),o),[t[0]+i*Math.cos(r),t[1]+i*Math.sin(r)]},updateA:function(t,e,i){var s,r,o=[i[0]-e[0],i[1]-e[1]],n=this.f(i[0],i[1])-this.f(e[0],e[1]);return r=o[0]*o[0]+o[1]*o[1],s=n-(t[0]*o[0]+t[1]*o[1]),s/=r,t[0]+=s*o[0],t[1]+=s*o[1],t},tangent_A:function(t){var e=[-t[1],t[0]],i=math.A.norm(e,2);return math.A.eps,[e[0]/i,e[1]/i]},tangent:function(t){var e=[-this.dfy(t[0],t[1]),this.dfx(t[0],t[1])],i=math.A.norm(e,2);return!(i<math.A.eps*math.A.eps)&&[e[0]/i,e[1]/i]}});var implicitplot=math.A.ImplicitPlot;math.A.Metapost={MP_ENDPOINT:0,MP_EXPLICIT:1,MP_GIVEN:2,MP_CURL:3,MP_OPEN:4,MP_END_CYCLE:5,UNITY:1,FRACTION_ONE:1,FRACTION_THREE:3,ONE_EIGHTY_DEG:Math.PI,THREE_SIXTY_DEG:2*Math.PI,EPS_SQ:1e-5*1e-5,make_choices:function(t){var e,i,s,r,o,n,a,l,h,u,c,d,p,_,f;a=t[0];do{if(!a)break;n=a.next,a.rtype>this.MP_EXPLICIT&&(a.x-n.x)*(a.x-n.x)+(a.y-n.y)*(a.y-n.y)<this.EPS_SQ&&(a.rtype=this.MP_EXPLICIT,a.ltype===this.MP_OPEN&&(a.ltype=this.MP_CURL,a.set_left_curl(this.UNITY)),n.ltype=this.MP_EXPLICIT,n.rtype===this.MP_OPEN&&(n.rtype=this.MP_CURL,n.set_right_curl(this.UNITY)),a.rx=a.x,n.lx=a.x,a.ry=a.y,n.ly=a.y),a=n}while(a!==t[0]);for(i=t[0];i.ltype===this.MP_OPEN&&i.rtype===this.MP_OPEN;)if((i=i.next)===t[0]){i.ltype=this.MP_END_CYCLE;break}for(a=i;a;){if(n=a.next,a.rtype>=this.MP_GIVEN){for(;n.ltype===this.MP_OPEN&&n.rtype===this.MP_OPEN;)n=n.next;for(s=0,l=a,o=t.length,d=[],p=[],_=[],f=[null];u=l.next,d.push(u.x-l.x),p.push(u.y-l.y),_.push(this.mp_pyth_add(d[s],p[s])),s>0&&(c=p[s-1]/_[s-1],h=d[s-1]/_[s-1],f.push(Math.atan2(p[s]*h-d[s]*c,d[s]*h+p[s]*c))),s++,(l=u)===n&&(o=s),!(s>=o&&l.ltype!==this.MP_END_CYCLE););s===o?f.push(0):f.push(f[1]),n.ltype===this.MP_OPEN&&((r=n.rx-n.x)*r+(e=n.ry-n.y)*e<this.EPS_SQ?(n.ltype=this.MP_CURL,n.set_left_curl(this.UNITY)):(n.ltype=this.MP_GIVEN,n.set_left_given(Math.atan2(e,r)))),a.rtype===this.MP_OPEN&&a.ltype===this.MP_EXPLICIT&&((r=a.x-a.lx)*r+(e=a.y-a.ly)*e<this.EPS_SQ?(a.rtype=this.MP_CURL,a.set_right_curl(this.UNITY)):(a.rtype=this.MP_GIVEN,a.set_right_given(Math.atan2(e,r)))),this.mp_solve_choices(a,n,o,d,p,_,f)}else a.rtype===this.MP_ENDPOINT&&(a.rx=a.x,a.ry=a.y,n.lx=n.x,n.ly=n.y);if((a=n)===i)break}},mp_solve_choices:function(t,e,i,s,r,o,n){var a,l,h,u,c,d,p,_,f,A,g,m,y,b,v,C,P,x,E,O,S,M,w,T,N,j;for(c=o.length+1,A=new Array(c),f=new Array(c),h=new Array(c),v=new Array(c),N=0;N<c;N++)v[N]=h[N]=f[N]=A[N]=0;for(p=0,_=t,m=0;;){if(y=_.next,0===p)if(_.rtype===this.MP_GIVEN){if(y.ltype===this.MP_GIVEN)return a=Math.atan2(r[0],s[0]),O=(E=this.mp_n_sin_cos(t.right_given()-a))[0],S=E[1],w=(M=this.mp_n_sin_cos(e.left_given()-a))[0],T=M[1],void this.mp_set_controls(t,e,s[0],r[0],S,O,-T,w);h[0]=_.right_given()-Math.atan2(r[0],s[0]),h[0]=this.reduce_angle(h[0]),A[0]=0,f[0]=0}else if(_.rtype===this.MP_CURL){if(y.ltype===this.MP_CURL)return t.rtype=this.MP_EXPLICIT,e.ltype=this.MP_EXPLICIT,g=Math.abs(e.left_tension()),C=Math.abs(t.right_tension()),b=this.UNITY/(3*C),t.rx=t.x+s[0]*b,t.ry=t.y+r[0]*b,b=this.UNITY/(3*g),e.lx=e.x-s[0]*b,void(e.ly=e.y-r[0]*b);x=_.right_curl(),g=Math.abs(y.left_tension()),C=Math.abs(_.right_tension()),A[0]=this.mp_curl_ratio(x,C,g),h[0]=-n[1]*A[0],f[0]=0}else _.rtype===this.MP_OPEN&&(A[0]=0,h[0]=0,f[0]=this.FRACTION_ONE);else if(_.ltype===this.MP_END_CYCLE||_.ltype===this.MP_OPEN){if(a=this.UNITY/(3*Math.abs(m.right_tension())-this.UNITY),P=o[p]*(this.FRACTION_THREE-this.UNITY/Math.abs(m.right_tension())),u=this.UNITY/(3*Math.abs(y.left_tension())-this.UNITY),d=o[p-1]*(this.FRACTION_THREE-this.UNITY/Math.abs(y.left_tension())),P*=x=this.FRACTION_ONE-A[p-1]*a,(g=Math.abs(_.left_tension()))<(C=Math.abs(_.right_tension()))?P*=Math.pow(g/C,2):g>C&&(d*=Math.pow(C/g,2)),b=d/(d+P),A[p]=b*u,l=-n[p+1]*A[p],m.rtype===this.MP_CURL?(f[p]=0,h[p]=l-n[1]*(this.FRACTION_ONE-b)):(b=(this.FRACTION_ONE-b)/x,l-=n[p]*b,b*=a,h[p]=l-h[p-1]*b,f[p]=-f[p-1]*b),_.ltype===this.MP_END_CYCLE){for(a=0,u=this.FRACTION_ONE;0===(p-=1)&&(p=i),a=h[p]-a*A[p],u=f[p]-u*A[p],p!==i;);for(a/=this.FRACTION_ONE-u,v[i]=a,h[0]=a,j=1;j<i;j++)h[j]=h[j]+a*f[j];break}}else{if(_.ltype===this.MP_CURL){x=_.left_curl(),g=Math.abs(_.left_tension()),C=Math.abs(m.right_tension()),b=this.mp_curl_ratio(x,g,C),v[i]=-h[i-1]*b/(this.FRACTION_ONE-b*A[i-1]);break}if(_.ltype===this.MP_GIVEN){v[i]=_.left_given()-Math.atan2(r[i-1],s[i-1]),v[i]=this.reduce_angle(v[i]);break}}m=_,_=y,p+=1}for(p=i-1;p>-1;p--)v[p]=h[p]-v[p+1]*A[p];for(_=t,p=0;y=_.next,O=(E=this.mp_n_sin_cos(v[p]))[0],S=E[1],w=(M=this.mp_n_sin_cos(-n[p+1]-v[p+1]))[0],T=M[1],this.mp_set_controls(_,y,s[p],r[p],S,O,T,w),_=y,++p!==i;);},mp_n_sin_cos:function(t){return[Math.cos(t),Math.sin(t)]},mp_set_controls:function(t,e,i,s,r,o,n,a){var l,h,u,c,d;u=Math.abs(e.left_tension()),l=Math.abs(t.right_tension()),d=this.mp_velocity(r,o,n,a,l),h=this.mp_velocity(n,a,r,o,u),(t.right_tension()<0||e.left_tension()<0)&&(r>=0&&n>=0||r<=0&&n<=0)&&(c=Math.abs(r)*a+Math.abs(n)*o)>0&&(c*=1.00024414062,t.right_tension()<0&&this.mp_ab_vs_cd(Math.abs(n),this.FRACTION_ONE,d,c)<0&&(d=Math.abs(n)/c),e.left_tension()<0&&this.mp_ab_vs_cd(Math.abs(r),this.FRACTION_ONE,h,c)<0&&(h=Math.abs(r)/c)),t.rx=t.x+(i*o-s*r)*d,t.ry=t.y+(s*o+i*r)*d,e.lx=e.x-(i*a+s*n)*h,e.ly=e.y-(s*a-i*n)*h,t.rtype=this.MP_EXPLICIT,e.ltype=this.MP_EXPLICIT},mp_pyth_add:function(t,e){return math.A.hypot(t,e)},mp_curl_ratio:function(t,e,i){var s=1/e,r=1/i;return Math.min(4,((3-s)*s*s*t+r*r*r)/(s*s*s*t+(3-r)*r*r))},mp_ab_vs_cd:function(t,e,i,s){return t*e==i*s?0:t*e>i*s?1:-1},mp_velocity:function(t,e,i,s,r){return Math.min(4,(2+Math.sqrt(2)*(t-i/16)*(i-t/16)*(e-s))/(1.5*r*(2+(Math.sqrt(5)-1)*e+(3-Math.sqrt(5))*s)))},reduce_angle:function(t){return Math.abs(t)>this.ONE_EIGHTY_DEG&&(t>0?t-=this.THREE_SIXTY_DEG:t+=this.THREE_SIXTY_DEG),t},makeknots:function(t,e){var i,s,r=[];for(s=t.length,i=0;i<s;i++)r.push({x:t[i][0],y:t[i][1],ltype:this.MP_OPEN,rtype:this.MP_OPEN,lx:!1,rx:!1,ly:e,ry:e,left_curl:function(){return this.lx||0},right_curl:function(){return this.rx||0},left_tension:function(){return this.ly||1},right_tension:function(){return this.ry||1},set_right_curl:function(t){this.rx=t||0},set_left_curl:function(t){this.lx=t||0}});for(s=r.length,i=0;i<s;i++)r[i].next=r[i+1]||r[i],r[i].set_right_given=r[i].set_right_curl,r[i].set_left_given=r[i].set_left_curl,r[i].right_given=r[i].right_curl,r[i].left_given=r[i].left_curl;return r[s-1].next=r[0],r},curve:function(t,e){var i,s,r,o,n,a,l=!1,h=[],u=[];for(o in n=1,(e=e||{tension:1,direction:{},curl:{},isClosed:!1}).hasOwnProperty("tension")&&(n=utils_type.A.evaluate(e.tension)),s=(i=this.makeknots(t,n)).length,utils_type.A.exists(e.isClosed)&&utils_type.A.evaluate(e.isClosed)&&(l=!0),l||(i[0].ltype=this.MP_ENDPOINT,i[0].rtype=this.MP_CURL,i[s-1].rtype=this.MP_ENDPOINT,i[s-1].ltype=this.MP_CURL),e)if(e.hasOwnProperty(o)){if(r=parseInt(o,10),isNaN(r)||r<0||r>=s)continue;if(a=e[r],utils_type.A.exists(a.type)&&"curl"===a.type)n=utils_type.A.evaluate(a.curl),0===r?(i[r].rtype=this.MP_CURL,i[r].set_right_curl(n)):r===s-1?(i[r].ltype=this.MP_CURL,i[r].set_left_curl(n)):(i[r].ltype=this.MP_CURL,i[r].rtype=this.MP_CURL,i[r].lx=n,i[r].rx=n);utils_type.A.exists(a.direction)&&(n=utils_type.A.evaluate(a.direction),utils_type.A.isArray(n)?(!1!==n[0]&&(i[r].lx=n[0]*Math.PI/180,i[r].ltype=this.MP_GIVEN),!1!==n[1]&&(i[r].rx=n[1]*Math.PI/180,i[r].rtype=this.MP_GIVEN)):(i[r].lx=n*Math.PI/180,i[r].rx=n*Math.PI/180,i[r].ltype=i[r].rtype=this.MP_GIVEN)),utils_type.A.exists(a.tension)&&(n=utils_type.A.evaluate(a.tension),utils_type.A.isArray(n)?(!1!==n[0]&&(i[r].ly=utils_type.A.evaluate(n[0])),!1!==n[1]&&(i[r].ry=utils_type.A.evaluate(n[1]))):(i[r].ly=n,i[r].ry=n))}for(this.make_choices(i),r=0;r<s-1;r++)h.push(i[r].x),h.push(i[r].rx),h.push(i[r+1].lx),u.push(i[r].y),u.push(i[r].ry),u.push(i[r+1].ly);return h.push(i[s-1].x),u.push(i[s-1].y),l&&(h.push(i[s-1].rx),u.push(i[s-1].ry),h.push(i[0].lx),u.push(i[0].ly),h.push(i[0].x),u.push(i[0].y)),[h,u]}};var metapost=math.A.Metapost,bitReverse=[0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253,3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243,11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251,7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247,15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255],cplens=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],cplext=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,99,99],cpdist=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577],cpdext=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],border=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],NAMEMAX=256;jxg.A.Util=jxg.A.Util||{},jxg.A.Util.Unzip=function(t){var e,i,s,r,o=[],n=0,a=[],l=new Array(32768),h=0,u=!1,c=t.length,d=0,p=1,_=new Array(288),f=new Array(32),A=0,g=null,m=0,y=new Array(17),b=[];function v(){return d<c?t[d++]:-1}function C(){p=1}function P(){var t;try{t=1&p,0===(p>>=1)&&(t=1&(p=v()),p=p>>1|128)}catch(t){throw console.log("Probably problems on iOS7 with >>"),t}return t}function x(t){var e=0,i=t;try{for(;i--;)e=e<<1|P();t&&(e=bitReverse[e]>>8-t)}catch(t){throw console.log("Probably problems on iOS7 with >>"),t}return e}function E(){h=0}function O(t){l[h++]=t,o.push(String.fromCharCode(t)),32768===h&&(h=0)}function S(){this.b0=0,this.b1=0,this.jump=null,this.jumppos=-1}function M(){for(;;){if(y[m]>=r)return-1;if(s[y[m]]===m)return y[m]++;y[m]++}}function w(){var t,e=g[A];if(17===m)return-1;if(A++,m++,(t=M())>=0)e.b0=t;else if(e.b0=32768,w())return-1;if((t=M())>=0)e.b1=t,e.jump=null;else if(e.b1=32768,e.jump=g[A],e.jumppos=A,w())return-1;return m--,0}function T(t,e,i,o){var n;for(g=t,A=0,s=i,r=e,n=0;n<17;n++)y[n]=0;return m=0,w()?-1:0}function N(t){for(var e,i,s=0,r=t[s];;)if(P()){if(!(32768&r.b1))return r.b1;for(r=r.jump,e=t.length,i=0;i<e;i++)if(t[i]===r){s=i;break}}else{if(!(32768&r.b0))return r.b0;r=t[++s]}}function j(){var t,e,i,s,r,o,n,a,u,c,d,p,A,g,m;do{if(t=P(),0===(e=x(2)))for(C(),u=v(),u|=v()<<8,d=v(),65535&(u^~(d|=v()<<8))&&jxg.A.debug("BlockLen checksum mismatch\n");u--;)O(v());else if(1===e)for(;;)if((s=bitReverse[x(7)]>>1)>23?(s=s<<1|P())>199?s=(s-=128)<<1|P():(s-=48)>143&&(s+=136):s+=256,s<256)O(s);else{if(256===s)break;for(a=x(cplext[s-=257])+cplens[s],s=bitReverse[x(5)]>>3,cpdext[s]>8?(c=x(8),c|=x(cpdext[s]-8)<<8):c=x(cpdext[s]),c+=cpdist[s],s=0;s<a;s++)O(l[h-c&32767])}else if(2===e){for(o=new Array(320),A=257+x(5),g=1+x(5),m=4+x(4),s=0;s<19;s++)o[s]=0;for(s=0;s<m;s++)o[border[s]]=x(3);for(a=f.length,i=0;i<a;i++)f[i]=new S;if(T(f,19,o))return E(),1;for(p=A+g,i=0;i<p;)if((s=N(f))<16)o[i++]=s;else if(16===s){if(i+(s=3+x(2))>p)return E(),1;for(r=i?o[i-1]:0;s--;)o[i++]=r}else{if(i+(s=17===s?3+x(3):11+x(7))>p)return E(),1;for(;s--;)o[i++]=0}for(a=_.length,i=0;i<a;i++)_[i]=new S;if(T(_,A,o))return E(),1;for(a=_.length,i=0;i<a;i++)f[i]=new S;for(n=[],i=A;i<o.length;i++)n[i-A]=o[i];if(T(f,g,n))return E(),1;for(;;)if((s=N(_))>=256){if(0===(s-=256))break;for(a=x(cplext[s-=1])+cplens[s],s=N(f),cpdext[s]>8?(c=x(8),c|=x(cpdext[s]-8)<<8):c=x(cpdext[s]),c+=cpdist[s];a--;)O(l[h-c&32767])}else O(s)}}while(!t);return E(),C(),0}function D(){var t,s,r,l,h,c=[];try{if(o=[],u=!1,c[0]=v(),c[1]=v(),120===c[0]&&218===c[1]&&(j(),a[n]=[o.join(""),"geonext.gxt"],n++),31===c[0]&&139===c[1]&&(k(),a[n]=[o.join(""),"file"],n++),80===c[0]&&75===c[1]){if(u=!0,c[2]=v(),c[3]=v(),3===c[2]&&4===c[3]){for(c[0]=v(),c[1]=v(),e=v(),e|=v()<<8,h=v(),h|=v()<<8,v(),v(),v(),v(),v(),v()<<8,v()<<16,v()<<24,v(),v()<<8,v()<<16,v()<<24,v(),v()<<8,v()<<16,v()<<24,l=v(),l|=v()<<8,r=v(),r|=v()<<8,t=0,b=[];l--;)"/"===(s=v())|":"===s?t=0:t<NAMEMAX-1&&(b[t++]=String.fromCharCode(s));for(i||(i=b),t=0;t<r;)s=v(),t++;if(8===h&&(j(),a[n]=new Array(2),a[n][0]=o.join(""),a[n][1]=b.join(""),n++),k())return!1}return!0}}catch(t){throw console.log("Probably problems on iOS7 with >>"),t}return!1}function k(){var t,i,s=[];if(8&e&&(s[0]=v(),s[1]=v(),s[2]=v(),s[3]=v(),80===s[0]&&75===s[1]&&7===s[2]&&8===s[3]?(v(),v()<<8,v()<<16,v()<<24):s[0]|s[1]<<8|s[2]<<16|s[3]<<24,v(),v()<<8,v()<<16,v()<<24,v(),v()<<8,v()<<16,v()<<24),u&&D())return!1;if(s[0]=v(),8!==s[0])return!0;if(e=v(),v(),v(),v(),v(),v(),v(),4&e)for(s[0]=v(),s[2]=v(),m=s[0]+256*s[1],t=0;t<m;t++)v();if(8&e)for(t=0,b=[],i=v();i;)"7"!==i&&":"!==i||(t=0),t<NAMEMAX-1&&(b[t++]=i),i=v();if(16&e)for(i=v();i;)i=v();return 2&e&&(v(),v()),j(),v(),v()<<8,v()<<16,v()<<24,v(),v()<<8,v()<<16,v()<<24,u&&D(),!1}y[0]=0,jxg.A.Util.Unzip.prototype.unzipFile=function(t){var e;for(this.unzip(),e=0;e<a.length;e++)if(a[e][1]===t)return a[e][0];return""},jxg.A.Util.Unzip.prototype.unzip=function(){return D(),a}};var zip=jxg.A.Util,UTF8_ACCEPT=0,UTF8D=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,10,3,3,3,3,3,3,3,3,3,3,3,3,4,3,3,11,6,6,6,5,8,8,8,8,8,8,8,8,8,8,8,0,12,24,36,60,96,84,12,12,12,48,72,12,12,12,12,12,12,12,12,12,12,12,12,12,0,12,12,12,12,12,0,12,0,12,12,12,24,12,12,12,12,12,24,12,24,12,12,12,12,12,12,12,12,12,24,12,12,12,12,12,24,12,12,12,12,12,12,12,24,12,12,12,12,12,12,12,12,12,36,12,36,12,12,12,36,12,12,12,12,12,36,12,36,12,12,12,36,12,12,12,12,12,12,12,12,12,12];jxg.A.Util=jxg.A.Util||{},jxg.A.Util.UTF8={encode:function(t){var e,i,s="",r=t.length;if(t=t.replace(/\r\n/g,"\n"),"function"==typeof unescape&&"function"==typeof encodeURIComponent)return unescape(encodeURIComponent(t));for(e=0;e<r;e++)(i=t.charCodeAt(e))<128?s+=String.fromCharCode(i):i>127&&i<2048?(s+=String.fromCharCode(i>>6|192),s+=String.fromCharCode(63&i|128)):(s+=String.fromCharCode(i>>12|224),s+=String.fromCharCode(i>>6&63|128),s+=String.fromCharCode(63&i|128));return s},decode:function(t){var e,i,s,r=0,o=0,n=UTF8_ACCEPT,a=[],l=t.length,h=[];for(e=0;e<l;e++)i=t.charCodeAt(e),s=UTF8D[i],o=n!==UTF8_ACCEPT?63&i|o<<6:255>>s&i,(n=UTF8D[256+n+s])===UTF8_ACCEPT&&(o>65535?a.push(55232+(o>>10),56320+(1023&o)):a.push(o),++r%1e4==0&&(h.push(String.fromCharCode.apply(null,a)),a=[]));return h.push(String.fromCharCode.apply(null,a)),h.join("")},asciiCharCodeAt:function(t,e){var i=t.charCodeAt(e);if(i>255)switch(i){case 8364:i=128;break;case 8218:i=130;break;case 402:i=131;break;case 8222:i=132;break;case 8230:i=133;break;case 8224:i=134;break;case 8225:i=135;break;case 710:i=136;break;case 8240:i=137;break;case 352:i=138;break;case 8249:i=139;break;case 338:i=140;break;case 381:i=142;break;case 8216:i=145;break;case 8217:i=146;break;case 8220:i=147;break;case 8221:i=148;break;case 8226:i=149;break;case 8211:i=150;break;case 8212:i=151;break;case 732:i=152;break;case 8482:i=153;break;case 353:i=154;break;case 8250:i=155;break;case 339:i=156;break;case 382:i=158;break;case 376:i=159}return i}};var utils_encoding=jxg.A.Util.UTF8,alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",pad="=";jxg.A.Util=jxg.A.Util||{},jxg.A.Util.Base64={_getByte:function(t,e){return 255&t.charCodeAt(e)},_getIndex:function(t,e){return alphabet.indexOf(t.charAt(e))},encode:function(t){var e,i,s,r,o,n=[];for(r=(s=(o=utils_encoding.encode(t)).length)%3,e=0;e<s-r;e+=3)i=this._getByte(o,e)<<16|this._getByte(o,e+1)<<8|this._getByte(o,e+2),n.push(alphabet.charAt(i>>18),alphabet.charAt(i>>12&63),alphabet.charAt(i>>6&63),alphabet.charAt(63&i));switch(r){case 1:i=this._getByte(o,s-1),n.push(alphabet.charAt(i>>2),alphabet.charAt(i<<4&63),pad,pad);break;case 2:i=this._getByte(o,s-2)<<8|this._getByte(o,s-1),n.push(alphabet.charAt(i>>10),alphabet.charAt(i>>4&63),alphabet.charAt(i<<2&63),pad)}return n.join("")},decode:function(t,e){var i,s,r,o,n,a,l=[],h=[];if((r=(i=t.replace(/[^A-Za-z0-9+/=]/g,"")).length)%4!=0)throw new Error("JSXGraph/utils/base64: Can't decode string (invalid input length).");for(i.charAt(r-1)===pad&&(o=1,i.charAt(r-2)===pad&&(o=2),r-=4),s=0;s<r;s+=4)n=this._getIndex(i,s)<<18|this._getIndex(i,s+1)<<12|this._getIndex(i,s+2)<<6|this._getIndex(i,s+3),h.push(n>>16,n>>8&255,255&n),s%1e4==0&&(l.push(String.fromCharCode.apply(null,h)),h=[]);switch(o){case 1:n=this._getIndex(i,r)<<12|this._getIndex(i,r+1)<<6|this._getIndex(i,r+2),h.push(n>>10,n>>2&255);break;case 2:n=this._getIndex(i,s)<<6|this._getIndex(i,s+1),h.push(n>>4)}return l.push(String.fromCharCode.apply(null,h)),a=l.join(""),e&&(a=utils_encoding.decode(a)),a},decodeAsArray:function(t){var e,i=this.decode(t),s=[],r=i.length;for(e=0;e<r;e++)s[e]=i.charCodeAt(e);return s}};var base64=jxg.A.Util.Base64;jxg.A.Server={modules:{},runningCalls:{},handleError:function(t){jxg.A.debug("error occured, server says: "+t.message)},callServer:function(t,e,i,s){var r,o,n,a,l,h;s=s||!1,l=utils_type.A.toJSON(i);do{a=t+Math.floor(4096*Math.random())}while(utils_type.A.exists(this.runningCalls[a]));return this.runningCalls[a]={action:t},utils_type.A.exists(i.module)&&(this.runningCalls[a].module=i.module),r=jxg.A.serverBase+"JXGServer.py",o="action="+escape(t)+"&id="+a+"&dataJSON="+escape(base64.encode(l)),this.cbp=function(t){var i,s,r,o,n,a,l,h;if(i=new zip.Unzip(base64.decodeAsArray(t)).unzip(),utils_type.A.isArray(i)&&i.length>0&&(i=i[0][0]),utils_type.A.exists(i))if("error"===(s=window.JSON&&window.JSON.parse?window.JSON.parse(i):new Function("return "+i)()).type)this.handleError(s);else if("response"===s.type){for(a=s.id,l=0;l<s.fields.length;l++)o=(r=s.fields[l]).namespace+("object"==typeof new Function("return "+r.namespace)()?".":".prototype.")+r.name+" = "+r.value,new Function(o)();for(l=0;l<s.handler.length;l++){for(r=s.handler[l],n=[],h=0;h<r.parameters.length;h++)n[h]='"'+r.parameters[h]+'": '+r.parameters[h];o="if(typeof JXG.Server.modules."+this.runningCalls[a].module+' == "undefined")JXG.Server.modules.'+this.runningCalls[a].module+" = {};",o+="JXG.Server.modules."+this.runningCalls[a].module+"."+r.name+"_cb = "+r.callback+";",o+="JXG.Server.modules."+this.runningCalls[a].module+"."+r.name+" = function ("+r.parameters.join(",")+', __JXGSERVER_CB__, __JXGSERVER_SYNC) {if(typeof __JXGSERVER_CB__ == "undefined") __JXGSERVER_CB__ = JXG.Server.modules.'+this.runningCalls[a].module+"."+r.name+"_cb;var __JXGSERVER_PAR__ = {"+n.join(",")+', "module": "'+this.runningCalls[a].module+'", "handler": "'+r.name+'" };JXG.Server.callServer("exec", __JXGSERVER_CB__, __JXGSERVER_PAR__, __JXGSERVER_SYNC);};',new Function(o)()}delete this.runningCalls[a],e(s.data)}},this.cb=jxg.A.bind(this.cbp,this),window.XMLHttpRequest?(n=new XMLHttpRequest).overrideMimeType("text/plain; charset=iso-8859-1"):n=new ActiveXObject("Microsoft.XMLHTTP"),!(!n||(n.open("POST",r,!s),n.setRequestHeader("Content-type","application/x-www-form-urlencoded"),s||(n.onreadystatechange=(h=this.cb,function(){return 4===n.readyState&&200===n.status&&(h(n.responseText),!0)})),n.send(o),!s))&&(this.cb(n.responseText),!0)},loadModule_cb:function(t){var e;for(e=0;e<t.length;e++)jxg.A.debug(t[e].name+": "+t[e].value)},loadModule:function(t){return jxg.A.Server.callServer("load",jxg.A.Server.loadModule_cb,{module:t},!0)}},jxg.A.Server.load=jxg.A.Server.loadModule;var server=jxg.A.Server,undef;math.A.Symbolic={generateSymbolicCoordinatesPartial:function(t,e,i,s){var r,o,n,a=e.ancestors,l=0,h=function(t){return"underscore"===s?i+"_{"+t+"}":"brace"===s?i+"["+t+"]":i+t};for(o in t.listOfFreePoints=[],t.listOfDependantPoints=[],a)if(a.hasOwnProperty(o)&&(r=0,utils_type.A.isPoint(a[o]))){for(n in a[o].ancestors)a[o].ancestors.hasOwnProperty(n)&&r++;0===r?(a[o].symbolic.x=a[o].coords.usrCoords[1],a[o].symbolic.y=a[o].coords.usrCoords[2],t.listOfFreePoints.push(a[o])):(l+=1,a[o].symbolic.x=h(l),l+=1,a[o].symbolic.y=h(l),t.listOfDependantPoints.push(a[o]))}return utils_type.A.isPoint(e)&&(e.symbolic.x="x",e.symbolic.y="y"),l},clearSymbolicCoordinates:function(t){var e=function(t){var e,i=t&&t.length||0;for(e=0;e<i;e++)utils_type.A.isPoint(t[e])&&(t[e].symbolic.x="",t[e].symbolic.y="")};e(t.listOfFreePoints),e(t.listOfDependantPoints),delete t.listOfFreePoints,delete t.listOfDependantPoints},generatePolynomials:function(t,e,i){var s,r,o,n,a=e.ancestors,l=[],h=[];for(s in i&&this.generateSymbolicCoordinatesPartial(t,e,"u","brace"),a[e.id]=e,a)if(a.hasOwnProperty(s)&&(n=0,l=[],utils_type.A.isPoint(a[s]))){for(r in a[s].ancestors)a[s].ancestors.hasOwnProperty(r)&&n++;if(n>0)for(l=a[s].generatePolynomial(),o=0;o<l.length;o++)h.push(l[o])}return i&&this.clearSymbolicCoordinates(t),h},geometricLocusByGroebnerBase:function(t,e){var i,s,r,o,n,a,l,h,u,c,d,p,_=t.options.locus,f={},A=this.generateSymbolicCoordinatesPartial(t,e,"u","brace"),g=new base_coords.A(constants.A.COORDS_BY_USR,[0,0],t),m=new base_coords.A(constants.A.COORDS_BY_USR,[t.canvasWidth,t.canvasHeight],t),y=1,b=0,v=0,C=0;if(server.modules.geoloci===undef&&server.loadModule("geoloci"),server.modules.geoloci===undef)throw new Error("JSXGraph: Unable to load JXG.Server module 'geoloci.py'.");if(a=g.usrCoords[1],l=m.usrCoords[1],h=m.usrCoords[2],u=g.usrCoords[2],_.translateToOrigin&&t.listOfFreePoints.length>0){for(b=(r=_.toOrigin!==undef&&null!==_.toOrigin&&utils_type.A.isInArray(t.listOfFreePoints,_.toOrigin.id)?_.toOrigin:t.listOfFreePoints[0]).symbolic.x,v=r.symbolic.y,n=0;n<t.listOfFreePoints.length;n++)t.listOfFreePoints[n].symbolic.x-=b,t.listOfFreePoints[n].symbolic.y-=v;if(a-=b,l-=b,h-=v,u-=v,_.translateTo10&&t.listOfFreePoints.length>1){for(o=_.to10!==undef&&null!==_.to10&&_.to10.id!==_.toOrigin.id&&utils_type.A.isInArray(t.listOfFreePoints,_.to10.id)?_.to10:t.listOfFreePoints[0].id===r.id?t.listOfFreePoints[1]:t.listOfFreePoints[0],C=geometry.A.rad([1,0],[0,0],[o.symbolic.x,o.symbolic.y]),c=Math.cos(-C),d=Math.sin(-C),n=0;n<t.listOfFreePoints.length;n++)p=t.listOfFreePoints[n].symbolic.x,t.listOfFreePoints[n].symbolic.x=c*t.listOfFreePoints[n].symbolic.x-d*t.listOfFreePoints[n].symbolic.y,t.listOfFreePoints[n].symbolic.y=d*p+c*t.listOfFreePoints[n].symbolic.y;if(o.symbolic.y=0,p=a,a=c*a-d*h,h=d*p+c*h,p=l,l=c*l-d*u,u=d*p+c*u,_.stretch&&Math.abs(o.symbolic.x)>math.A.eps){for(y=o.symbolic.x,n=0;n<t.listOfFreePoints.length;n++)t.listOfFreePoints[n].symbolic.x/=y,t.listOfFreePoints[n].symbolic.y/=y;for(n=0;n<t.objectsList.length;n++)t.objectsList[n].elementClass===constants.A.OBJECT_CLASS_CIRCLE&&"pointRadius"===t.objectsList[n].method&&(f[n]=t.objectsList[n].radius,t.objectsList[n].radius/=y);a/=y,l/=y,h/=y,u/=y,o.symbolic.x=1}}for(n=0;n<t.listOfFreePoints.length;n++)p=t.listOfFreePoints[n].symbolic.x,Math.abs(p)<math.A.eps&&(t.listOfFreePoints[n].symbolic.x=0),Math.abs(p-Math.round(p))<math.A.eps&&(t.listOfFreePoints[n].symbolic.x=Math.round(p)),p=t.listOfFreePoints[n].symbolic.y,Math.abs(p)<math.A.eps&&(t.listOfFreePoints[n].symbolic.y=0),Math.abs(p-Math.round(p))<math.A.eps&&(t.listOfFreePoints[n].symbolic.y=Math.round(p))}for(n in i=this.generatePolynomials(t,e).join(","),this.cbp=function(t){s=t},this.cb=utils_type.A.bind(this.cbp,this),server.modules.geoloci.lociCoCoA(a,l,h,u,A,i,y,C,b,v,this.cb,!0),this.clearSymbolicCoordinates(t),f)f.hasOwnProperty(n)&&(t.objects[n].radius=f[n]);return s}};var symbolic=math.A.Symbolic;math.A.Clip={_isSeparator:function(t){return isNaN(t.coords.usrCoords[1])&&isNaN(t.coords.usrCoords[2])},makeDoublyLinkedList:function(t){var e,i=null,s=[],r=t.length;if(r>0)for(e=0;e<r;e++)this._isSeparator(t[e])?(t[e]._next=t[(e+1)%r],t[e]._prev=t[(r+e-1)%r]):(null===i&&(i=e,s.push(i)),this._isSeparator(t[(e+1)%r])||e===r-1?(t[e]._next=t[i],t[i]._prev=t[e],t[e]._end=!0,i=null):(t[e]._next=t[(e+1)%r],t[i]._prev=t[e]),this._isSeparator(t[(r+e-1)%r])||(t[e]._prev=t[(r+e-1)%r]));return s},Vertex:function(t,e,i,s,r,o){this.pos=e,this.intersection=!0,this.coords=t,this.elementClass=constants.A.OBJECT_CLASS_POINT,this.data={alpha:i,path:s,pathname:r,done:!1,type:o,idx:0},this.neighbour=null,this.entry_exit=!1},_addToList:function(t,e,i){var s=t.length,r=math.A.eps*math.A.eps;s>0&&Math.abs(t[s-1].coords.usrCoords[0]-e.usrCoords[0])<r&&Math.abs(t[s-1].coords.usrCoords[1]-e.usrCoords[1])<r&&Math.abs(t[s-1].coords.usrCoords[2]-e.usrCoords[2])<r||t.push({pos:i,intersection:!1,coords:e,elementClass:constants.A.OBJECT_CLASS_POINT})},sortIntersections:function(t){var e,i,s,r,o,n,a=[],l=t.length;for(e=0;e<l;e++)if(t[e].sort((function(t,e){return t.data.alpha>e.data.alpha?1:-1})),t[e].length>0){for(o=t[e].length-1,n=(r=(s=t[e][0]).data.path[s.pos])._next,e===l-1&&(r._end=!1),0===s.data.alpha&&"T"===s.data.type?(r.intersection=!0,r.data=s.data,r.neighbour=s.neighbour,r.neighbour.neighbour=r,r.entry_exit=!1,t[e][0]=r):(s._prev=r,s._prev._next=s),i=1;i<=o;i++)(s=t[e][i])._prev=t[e][i-1],s._prev._next=s;(s=t[e][o])._next=n,s._next._prev=s,e===l-1&&(s._end=!0),a=a.concat(t[e])}return a},_inbetween:function(t,e,i){var s,r=math.A.eps*math.A.eps,o=i[1]-e[1],n=i[2]-e[2],a=t[1]-e[1],l=t[2]-e[2];return 0===o&&0===n&&0===a&&0===l||(s=Math.abs(a)<r&&Math.abs(o)<r?l/n:a/o,Math.abs(s)<r&&(s=0),s)},_print_array:function(t){var e,i;for(e=0;e<t.length;e++)try{i="",t[e]._end&&(i=" end"),console.log(e,t[e].coords.usrCoords,t[e].data.type,"\t","prev",t[e]._prev.coords.usrCoords,"next",t[e]._next.coords.usrCoords+i)}catch(i){console.log(e,t[e].coords.usrCoords)}},_print_list:function(t){for(var e,i=0;i<100&&(e=t.data?t.data.alpha:"-",console.log("\t",t.coords.usrCoords,"\n\t\tis:",t.intersection,"end:",t._end,e,"\n\t\t-:",t._prev.coords.usrCoords,"\n\t\t+:",t._next.coords.usrCoords,"\n\t\tn:",t.intersection?t.neighbour.coords.usrCoords:"-"),!t._end);)t=t._next,i++},_noOverlap:function(t,e,i,s){var r,o,n,a,l,h=Math.sqrt(math.A.eps),u=!1;for(r=0;r<3;r++)if(o=Math.min(t[r],e[r]),n=Math.max(t[r],e[r]),a=Math.min(i[r],s[r]),l=Math.max(i[r],s[r]),n<a-h||o>l+h){u=!0;break}return u},findIntersections:function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_,f,A=[],g=100*math.A.eps,m=t.length,y=e.length,b=[],v=[],C=[],P=!1,x=!1,E=!1;for(r=0;r<y;r++)C.push([]);for(s=0;s<m;s++)if(v.push([]),this._isSeparator(t[s])||this._isSeparator(t[(s+1)%m]))P=!0;else{if(P&&s===m-1)break;for(n=t[s].coords.usrCoords,a=t[(s+1)%m].coords.usrCoords,r=0;r<y;r++)if(this._isSeparator(e[r])||this._isSeparator(e[(r+1)%y]))x=!0;else{if(x&&r===y-1)break;if(l=e[r].coords.usrCoords,h=e[(r+1)%y].coords.usrCoords,!this._noOverlap(n,a,l,h)&&(A=geometry.A.meetSegmentSegment(n,a,l,h),u=geometry.A.distance(n,a,3),c=geometry.A.distance(l,h,3),A[1]*u>-g&&A[1]<1-g/u&&A[2]*c>-g&&A[2]<1-g/c||A[1]===1/0&&A[2]===1/0&&math.A.norm(A[0],3)<g)){if(o=new base_coords.A(constants.A.COORDS_BY_USER,A[0],i),p="X",Math.abs(A[1])*u<g||Math.abs(A[2])*c<g)p="T",Math.abs(A[1])*u<g&&(A[1]=0),Math.abs(A[2])*c<g&&(A[2]=0),o=0===A[1]?new base_coords.A(constants.A.COORDS_BY_USER,n,i):new base_coords.A(constants.A.COORDS_BY_USER,l,i);else if(A[1]===1/0&&A[2]===1/0&&math.A.norm(A[0],3)<g){(d=this._inbetween(n,l,h))>=0&&d<1&&(p="T",o=new base_coords.A(constants.A.COORDS_BY_USER,n,i),A[1]=0,A[2]=d,_=new this.Vertex(o,s,A[1],t,"S",p),f=new this.Vertex(o,r,A[2],e,"C",p),_.neighbour=f,f.neighbour=_,v[s].push(_),C[r].push(f)),d=this._inbetween(l,n,a),geometry.A.distance(n,l,3)>g&&d>=0&&d<1&&(p="T",o=new base_coords.A(constants.A.COORDS_BY_USER,l,i),A[1]=d,A[2]=0,_=new this.Vertex(o,s,A[1],t,"S",p),f=new this.Vertex(o,r,A[2],e,"C",p),_.neighbour=f,f.neighbour=_,v[s].push(_),C[r].push(f));continue}E,_=new this.Vertex(o,s,A[1],t,"S",p),f=new this.Vertex(o,r,A[2],e,"C",p),_.neighbour=f,f.neighbour=_,v[s].push(_),C[r].push(f)}}}for(b=this.sortIntersections(v),s=0;s<b.length;s++)b[s].data.idx=s,b[s].neighbour.data.idx=s;return[b,this.sortIntersections(C)]},_getPosition:function(t,e,i,s){var r=geometry.A.det3p(t,e,i),o=geometry.A.det3p(t,i,s);return geometry.A.det3p(e,i,s)>=0?r>=0&&o>=0?"left":"right":r>=0||o>=0?"left":"right"},_classifyDegenerateIntersections:function(t){var e,i,s,r,o,n,a,l,h,u,c,d,p,_,f=!1;for(f,h=geometry.A.det3p,a=0,t._tours=0;;){if(t.intersection&&"T"===t.data.type&&(e=t._next.coords.usrCoords,i=t._prev.coords.usrCoords,geometry.A.distance(t.coords.usrCoords,e,3)<math.A.eps&&(e=t._next._next.coords.usrCoords),geometry.A.distance(t.coords.usrCoords,i,3)<math.A.eps&&(i=t._prev._prev.coords.usrCoords),r=(o=t.neighbour)._prev.coords.usrCoords,s=o._next.coords.usrCoords,geometry.A.distance(o.coords.usrCoords,s,3)<math.A.eps&&(s=o._next._next.coords.usrCoords),geometry.A.distance(o.coords.usrCoords,r,3)<math.A.eps&&(r=o._prev._prev.coords.usrCoords),c=h(t.coords.usrCoords,i,r),d=h(t.coords.usrCoords,e,s),p=h(t.coords.usrCoords,i,s),_=h(t.coords.usrCoords,e,r),0===c&&0===d&&0===p&&0===_&&(t.coords.usrCoords[1]*=1+Math.random()*math.A.eps,t.coords.usrCoords[2]*=1+Math.random()*math.A.eps,o.coords.usrCoords[1]=t.coords.usrCoords[1],o.coords.usrCoords[2]=t.coords.usrCoords[2],c=h(t.coords.usrCoords,i,r),d=h(t.coords.usrCoords,e,s),p=h(t.coords.usrCoords,i,s),_=h(t.coords.usrCoords,e,r)),u=!1,0===c?geometry.A.affineRatio(t.coords.usrCoords,i,r)<0&&(u=!0):0===d?geometry.A.affineRatio(t.coords.usrCoords,e,s)<0&&(u=!0):0===p?geometry.A.affineRatio(t.coords.usrCoords,i,s)>0&&(u=!0):0===_&&geometry.A.affineRatio(t.coords.usrCoords,e,r)>0&&(u=!0),u&&(l=r,r=s,s=l,l=c,c=p,p=l,l=d,d=_,_=l),utils_type.A.exists(t.delayedStatus)||(t.delayedStatus=[]),0===c&&0===d?t.delayedStatus=["on","on"]:0===c?(n=this._getPosition(e,r,o.coords.usrCoords,s),t.delayedStatus=["on",n]):0===d?(n=this._getPosition(i,r,o.coords.usrCoords,s),t.delayedStatus=[n,"on"]):0===t.delayedStatus.length&&(this._getPosition(i,r,o.coords.usrCoords,s)!==this._getPosition(e,r,o.coords.usrCoords,s)?t.data.type="X":t.data.type="B")),utils_type.A.exists(t._tours)&&t._tours++,t._tours>3||t._end||a>1e3){a>1e3&&console.log("Clipping: _classifyDegenerateIntersections exit"),utils_type.A.exists(t._tours)&&delete t._tours;break}t.intersection&&a++,t=t._next}},_handleIntersectionChains:function(t){var e,i=0,s="Null",r=!1,o=!1,n=!1;for(n;!0===t.intersection&&("T"===t.data.type&&("on"!==t.delayedStatus[0]&&"on"===t.delayedStatus[1]?(r=!0,e=t,s=t.delayedStatus[0]):r&&"on"===t.delayedStatus[0]&&"on"===t.delayedStatus[1]?t.data.type="B":r&&"on"===t.delayedStatus[0]&&"on"!==t.delayedStatus[1]&&(r=!1,s===t.delayedStatus[1]?(e.data.type="DB",t.data.type="DB"):(e.data.type="DX",t.data.type="DX"))),i++),t._end&&(o=!0),!o||r;){if(i>1e3){console.log("Warning: _handleIntersectionChains: intersection chain reached maximum numbers of iterations");break}t=t._next}},_handleFullyDegenerateCase:function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_,f,A,g=[t,e];for(o=0;o<2;o++){for(d=(s=g[o]).length,u=0,A=!0;u<d;u++)if(!s[u].intersection){A=!1;break}if(A)for(p=(r=g[(o+1)%2]).length,u=0;u<d;u++){for(a=s[u].coords.usrCoords,l=s[u]._next.coords.usrCoords,n=[.5*(a[0]+l[0]),.5*(a[1]+l[1]),.5*(a[2]+l[2])],c=0,_=!1;c<p;c++)if(Math.abs(geometry.A.det3p(r[c].coords.usrCoords,r[(c+1)%p].coords.usrCoords,n))<math.A.eps){_=!0;break}if(!_){h={pos:u,intersection:!1,coords:new base_coords.A(constants.A.COORDS_BY_USER,n,i),elementClass:constants.A.OBJECT_CLASS_POINT},f=s[u]._next,s[u]._next=h,h._prev=s[u],h._next=f,f._prev=h,s[u]._end&&(s[u]._end=!1,h._end=!0);break}}}},_getStatus:function(t,e){for(;t.intersection&&!t._end;)t=t._next;return[t,0===geometry.A.windingNumber(t.coords.usrCoords,e)?"entry":"exit"]},markEntryExit:function(t,e,i){var s,r,o,n,a,l,h,u=null,c=0;for(l=i.length,a=0;a<l;a++)for(h=i[a],this._classifyDegenerateIntersections(t[h]),this._handleIntersectionChains(t[h]),r=(n=this._getStatus(t[h],e))[0],s=n[1],r._starter=!0,o=0,u=null,c=0;!0===r.intersection&&("X"===r.data.type&&1===c&&(u.entry_exit=s,"exit"===s&&(u.data.type="X"),c=2),"X"!==r.data.type&&"DB"!==r.data.type||(r.entry_exit=s,s="entry"===s?"exit":"entry"),"DX"===r.data.type&&(0===c?(u=r,c=1):1===c?(r.entry_exit=s,u.entry_exit=s,"exit"===s?u.data.type="X":r.data.type="X",s="entry"===s?"exit":"entry",u=null,c=0):2===c&&(r.entry_exit=s,r.data.type="X",s="entry"===s?"exit":"entry",u=null,c=0))),r=r._next,!(utils_type.A.exists(r._starter)||o>1e4);)o++},_stayOnPath:function(t,e){var i=!0;return t.intersection&&"B"!==t.data.type&&(i=e===t.entry_exit),i},_addVertex:function(t,e,i){return isNaN(e.coords.usrCoords[1])||isNaN(e.coords.usrCoords[2])||t.push(e),e.intersection&&e.data.done?(i&&console.log("Add last intersection point",e.coords.usrCoords,"on",e.data.pathname,e.entry_exit,e.data.type),!0):(e.intersection&&(e.data.done=!0,i&&console.log("Add intersection point",e.coords.usrCoords,"on",e.data.pathname,e.entry_exit,e.data.type)),!1)},tracing:function(t,e,i){var s,r,o,n,a=0,l=1e4,h=0,u=[],c=!1,d=!1;for(d;h<e.length&&a<l;)if((o=e[h]).data.done||"X"!==o.data.type)h++;else{d,u.length>0&&u.push([NaN,NaN]),n=o.data.idx,s=t,c=this._addVertex(u,o,d),r=o.entry_exit;do{if(c)break;if("intersection"===i&&"entry"===o.entry_exit||"union"===i&&"exit"===o.entry_exit||"difference"===i&&s===t==("exit"===o.entry_exit)){d;do{if(o=o._next,c=this._addVertex(u,o,d))break}while(this._stayOnPath(o,r));a++}else{d;do{if(o=o._prev,c=this._addVertex(u,o,d))break}while(this._stayOnPath(o,r));a++}if(c)break;if(!o.neighbour)return console.log("Tracing: emergency break - no neighbour!!!!!!!!!!!!!!!!!",a),[[0],[0]];if((o=o.neighbour).data.done)break;o.data.done=!0,r=o.entry_exit,s=o.data.path}while(o.data.idx!==n&&a<l);a>=l&&console.log("Tracing: stopping an infinite loop!",a),h++}return this._getCoordsArrays(u,!1)},isEmptyCase:function(t,e,i){return"intersection"===i&&(0===t.length||0===e.length)||("union"===i&&0===t.length&&0===e.length||"difference"===i&&0===t.length)},_getCoordsArrays:function(t,e){var i,s=[],r=[],o=t.length;for(i=0;i<o;i++)t[i].coords?(s.push(t[i].coords.usrCoords[1]),r.push(t[i].coords.usrCoords[2])):(s.push(t[i][0]),r.push(t[i][1]));return e&&o>0&&(t[0].coords?(s.push(t[0].coords.usrCoords[1]),r.push(t[0].coords.usrCoords[2])):(s.push(t[0][0]),r.push(t[0][1]))),[s,r]},handleEmptyIntersection:function(t,e,i){var s,r,o=!1,n=[];if(0===t.length)return n="union"===i?e:[],this._getCoordsArrays(n,!0);if(0===e.length)return n="intersection"===i?[]:t,this._getCoordsArrays(n,!0);if(t.length>0)for(s=t[0];s.intersection&&!(s=s._next)._end;);if(e.length>0)for(r=e[0];r.intersection&&!(r=r._next)._end;);return 0===geometry.A.windingNumber(s.coords.usrCoords,e)?0!==geometry.A.windingNumber(r.coords.usrCoords,t)?("union"===i?(utils_type.A.concat(n,t),n.push(t[0])):"difference"===i&&(utils_type.A.concat(n,t),n.push(t[0]),geometry.A.signedPolygon(t)*geometry.A.signedPolygon(e)>0&&n.reverse(),n.push([NaN,NaN])),"difference"!==i&&"intersection"!==i||(utils_type.A.concat(n,e),n.push(e[0]),o=!1)):"difference"===i?(utils_type.A.concat(n,t),o=!0):"union"===i&&(utils_type.A.concat(n,t),n.push(t[0]),n.push([NaN,NaN]),utils_type.A.concat(n,e),n.push(e[0])):"intersection"===i?(utils_type.A.concat(n,t),o=!0):"union"===i&&(utils_type.A.concat(n,e),n.push(e[0])),this._getCoordsArrays(n,o)},_countCrossingIntersections:function(t){var e,i=t.length,s=0;for(e=0;e<i;e++)"X"===t[e].data.type&&s++;return s},_getPath:function(t,e){var i,s,r,o,n,a,l,h=[];if(t.elementClass!==constants.A.OBJECT_CLASS_CURVE||t.type!==constants.A.OBJECT_TYPE_ARC&&t.type!==constants.A.OBJECT_TYPE_SECTOR){if(t.elementClass===constants.A.OBJECT_CLASS_CURVE&&utils_type.A.exists(t.points))for(s=t.numberPoints,i=0;i<s;i++)this._addToList(h,t.points[i],i);else if(t.type===constants.A.OBJECT_TYPE_POLYGON)for(i=0;i<t.vertices.length;i++)this._addToList(h,t.vertices[i].coords,i);else if(t.elementClass===constants.A.OBJECT_CLASS_CIRCLE)for(l=359,r=t.Radius(),o=2*Math.PI/l,i=0;i<=l;i++)this._addToList(h,new base_coords.A(constants.A.COORDS_BY_USER,[t.center.coords.usrCoords[0],t.center.coords.usrCoords[1]+Math.cos(i*o)*r,t.center.coords.usrCoords[2]+Math.sin(i*o)*r],e),i);else if(utils_type.A.isArray(t))for(s=t.length,i=0;i<s;i++)utils_type.A.exists(t[i].coords)?this._addToList(h,t[i].coords,i):utils_type.A.isArray(t[i])?this._addToList(h,new base_coords.A(constants.A.COORDS_BY_USER,t[i],e),i):utils_type.A.exists(t[i].usrCoords)&&this._addToList(h,t[i],i)}else{for(n=geometry.A.rad(t.radiuspoint,t.center,t.anglepoint),l=Math.floor(180*n/Math.PI),r=t.Radius(),o=n/l,a=Math.atan2(t.radiuspoint.coords.usrCoords[2]-t.center.coords.usrCoords[2],t.radiuspoint.coords.usrCoords[1]-t.center.coords.usrCoords[1]),t.type===constants.A.OBJECT_TYPE_SECTOR&&this._addToList(h,t.center.coords,0),i=0;i<=l;i++)this._addToList(h,new base_coords.A(constants.A.COORDS_BY_USER,[t.center.coords.usrCoords[0],t.center.coords.usrCoords[1]+Math.cos(i*o+a)*r,t.center.coords.usrCoords[2]+Math.sin(i*o+a)*r],e),i+1);t.type===constants.A.OBJECT_TYPE_SECTOR&&this._addToList(h,t.center.coords,l+2)}return h},greinerHormann:function(t,e,i,s){var r,o,n,a,l=[],h=[];return(r=(l=this._getPath(t,s)).length)>0&&geometry.A.distance(l[0].coords.usrCoords,l[r-1].coords.usrCoords,3)<math.A.eps&&l.pop(),(r=(h=this._getPath(e,s)).length)>0&&geometry.A.distance(h[0].coords.usrCoords,h[r-1].coords.usrCoords,3)<math.A.eps*math.A.eps&&h.pop(),this.isEmptyCase(l,h,i)?[[],[]]:(n=this.makeDoublyLinkedList(l),a=this.makeDoublyLinkedList(h),o=this.findIntersections(l,h,s)[0],this._handleFullyDegenerateCase(l,h,s),this.markEntryExit(l,h,n),this.markEntryExit(h,l,a),0===this._countCrossingIntersections(o)?this.handleEmptyIntersection(l,h,i):this.tracing(l,o,i))},union:function(t,e,i){return this.greinerHormann(t,e,"union",i)},intersection:function(t,e,i){return this.greinerHormann(t,e,"intersection",i)},difference:function(t,e,i){return this.greinerHormann(t,e,"difference",i)}};var clip=math.A.Clip;math.A.Poly={},math.A.Poly.Ring=function(t){this.vars=t},jxg.A.extend(math.A.Poly.Ring.prototype,{}),math.A.Poly.Monomial=function(t,e,i){var s;if(!utils_type.A.exists(t))throw new Error("JSXGraph error: In JXG.Math.Poly.monomial missing parameter 'ring'.");for(utils_type.A.isArray(i)||(i=[]),s=(i=i.slice(0,t.vars.length)).length;s<t.vars.length;s++)i.push(0);this.ring=t,this.coefficient=e||0,this.exponents=utils_type.A.deepCopy(i)},jxg.A.extend(math.A.Poly.Monomial.prototype,{copy:function(){return new math.A.Poly.Monomial(this.ring,this.coefficient,this.exponents)},print:function(){var t,e=[];for(t=0;t<this.ring.vars.length;t++)e.push(this.ring.vars[t]+"^"+this.exponents[t]);return this.coefficient+"*"+e.join("*")}}),math.A.Poly.Polynomial=function(t,e){var i;if(!utils_type.A.exists(t))throw new Error("JSXGraph error: In JXG.Math.Poly.polynomial missing parameter 'ring'.");i=utils_type.A.exists(e)&&utils_type.A.isString(e)?void 0:[],this.ring=t,this.monomials=i},jxg.A.extend(math.A.Poly.Polynomial.prototype,{findSignature:function(t){var e;for(e=0;e<this.monomials.length;e++)if(utils_type.A.cmpArrays(this.monomials[e].exponents,t))return e;return-1},addSubMonomial:function(t,e){var i;(i=this.findSignature(t.exponents))>-1?this.monomials[i].coefficient+=e*t.coefficient:(t.coefficient*=e,this.monomials.push(t))},add:function(t){var e;if(!utils_type.A.exists(t)||t.ring!==this.ring)throw new Error("JSXGraph error: In JXG.Math.Poly.polynomial.add either summand is undefined or rings don't match.");if(utils_type.A.isArray(t.exponents))this.addSubMonomial(t,1);else for(e=0;e<t.monomials.length;e++)this.addSubMonomial(t.monomials[e],1)},sub:function(t){var e;if(!utils_type.A.exists(t)||t.ring!==this.ring)throw new Error("JSXGraph error: In JXG.Math.Poly.polynomial.sub either summand is undefined or rings don't match.");if(utils_type.A.isArray(t.exponents))this.addSubMonomial(t,-1);else for(e=0;e<t.monomials.length;e++)this.addSubMonomial(t.monomials[e],-1)},copy:function(){var t,e;for(e=new math.A.Poly.Polynomial(this.ring),t=0;t<this.monomials.length;t++)e.monomials.push(this.monomials[t].copy());return e},print:function(){var t,e=[];for(t=0;t<this.monomials.length;t++)e.push("("+this.monomials[t].print()+")");return e.join("+")}});var poly=math.A.Poly;jxg.A.Complex=function(t,e){this.isComplex=!0,t&&t.isComplex&&(e=t.imaginary,t=t.real),this.real=t||0,this.imaginary=e||0,this.absval=0,this.angle=0},jxg.A.extend(jxg.A.Complex.prototype,{toString:function(){return this.real+" + "+this.imaginary+"i"},add:function(t){return utils_type.A.isNumber(t)?this.real+=t:(this.real+=t.real,this.imaginary+=t.imaginary),this},sub:function(t){return utils_type.A.isNumber(t)?this.real-=t:(this.real-=t.real,this.imaginary-=t.imaginary),this},mult:function(t){var e,i;return utils_type.A.isNumber(t)?(this.real*=t,this.imaginary*=t):(e=this.real,i=this.imaginary,this.real=e*t.real-i*t.imaginary,this.imaginary=e*t.imaginary+i*t.real),this},div:function(t){var e,i,s;if(utils_type.A.isNumber(t)){if(Math.abs(t)<Math.eps)return this.real=1/0,this.imaginary=1/0,this;this.real/=t,this.imaginary/=t}else{if(Math.abs(t.real)<Math.eps&&Math.abs(t.imaginary)<Math.eps)return this.real=1/0,this.imaginary=1/0,this;e=t.real*t.real+t.imaginary*t.imaginary,s=this.real,i=this.imaginary,this.real=(s*t.real+i*t.imaginary)/e,this.imaginary=(i*t.real-s*t.imaginary)/e}return this},conj:function(){return this.imaginary*=-1,this}}),jxg.A.C={},jxg.A.C.add=function(t,e){var i=new jxg.A.Complex(t);return i.add(e),i},jxg.A.C.sub=function(t,e){var i=new jxg.A.Complex(t);return i.sub(e),i},jxg.A.C.mult=function(t,e){var i=new jxg.A.Complex(t);return i.mult(e),i},jxg.A.C.div=function(t,e){var i=new jxg.A.Complex(t);return i.div(e),i},jxg.A.C.conj=function(t){var e=new jxg.A.Complex(t);return e.conj(),e},jxg.A.C.abs=function(t){var e=new jxg.A.Complex(t);return e.conj(),e.mult(t),Math.sqrt(e.real)},jxg.A.C.copy=function(t){return new jxg.A.Complex(t)},jxg.A.Complex.C=jxg.A.C;var complex=jxg.A.Complex,src_options=__webpack_require__(378);jxg.A.AbstractRenderer=function(){this.vOffsetText=0,this.enhancedRendering=!0,this.container=null,this.type="",this.supportsForeignObject=!1,this.dashArray=[[2,2],[5,5],[10,10],[20,20],[20,10,10,10],[20,5,10,5],[0,5]]},jxg.A.extend(jxg.A.AbstractRenderer.prototype,{_updateVisual:function(t,e,i){(i||this.enhancedRendering)&&(e=e||{},this.setObjectViewport(t),this.setObjectTransition(t),utils_type.A.evaluate(t.visProp.draft)?this.setDraft(t):(e.stroke||(t.highlighted?(this.setObjectStrokeColor(t,t.visProp.highlightstrokecolor,t.visProp.highlightstrokeopacity),this.setObjectStrokeWidth(t,t.visProp.highlightstrokewidth)):(this.setObjectStrokeColor(t,t.visProp.strokecolor,t.visProp.strokeopacity),this.setObjectStrokeWidth(t,t.visProp.strokewidth))),e.fill||(t.highlighted?this.setObjectFillColor(t,t.visProp.highlightfillcolor,t.visProp.highlightfillopacity):this.setObjectFillColor(t,t.visProp.fillcolor,t.visProp.fillopacity)),e.dash||this.setDashStyle(t,t.visProp),e.shadow||this.setShadow(t),e.tabindex||this.setTabindex(t)))},_getHighlighted:function(t){var e=!1;return utils_type.A.exists(t.board)&&utils_type.A.exists(t.board.highlightedObjects)||(e=!0),!e&&utils_type.A.exists(t.board.highlightedObjects[t.id])?"highlight":""},drawPoint:function(t){var e,i=src_options.A.normalizePointFace(utils_type.A.evaluate(t.visProp.face));e="o"===i?"ellipse":"[]"===i?"rect":"path",t.rendNode=this.appendChildPrim(this.createPrim(e,t.id),utils_type.A.evaluate(t.visProp.layer)),this.appendNodesToElement(t,e),this._updateVisual(t,{dash:!0,shadow:!0},!0),this.updatePoint(t)},updatePoint:function(t){var e,i=utils_type.A.evaluate(t.visProp.size),s=src_options.A.normalizePointFace(utils_type.A.evaluate(t.visProp.face)),r=utils_type.A.evaluate(t.visProp.sizeunit),o=utils_type.A.evaluate(t.visProp.zoom);isNaN(t.coords.scrCoords[2]+t.coords.scrCoords[1])||("user"===r&&(i*=Math.sqrt(Math.abs(t.board.unitX*t.board.unitY))),e=0===(i*=t.board&&o?Math.sqrt(t.board.zoomX*t.board.zoomY):1)?0:i+1,"o"===s?this.updateEllipsePrim(t.rendNode,t.coords.scrCoords[1],t.coords.scrCoords[2],e,e):"[]"===s?this.updateRectPrim(t.rendNode,t.coords.scrCoords[1]-i,t.coords.scrCoords[2]-i,2*i,2*i):this.updatePathPrim(t.rendNode,this.updatePathStringPoint(t,i,s),t.board),this._updateVisual(t,{dash:!1,shadow:!1}),this.setShadow(t))},changePointStyle:function(t){var e=this.getElementById(t.id);utils_type.A.exists(e)&&this.remove(e),this.drawPoint(t),utils_type.A.clearVisPropOld(t),t.visPropCalc.visible||this.display(t,!1),utils_type.A.evaluate(t.visProp.draft)&&this.setDraft(t)},drawLine:function(t){t.rendNode=this.appendChildPrim(this.createPrim("line",t.id),utils_type.A.evaluate(t.visProp.layer)),this.appendNodesToElement(t,"lines"),this.updateLine(t)},updateLine:function(t){this._updateVisual(t),this.updatePathWithArrowHeads(t),this.setLineCap(t)},drawCurve:function(t){t.rendNode=this.appendChildPrim(this.createPrim("path",t.id),utils_type.A.evaluate(t.visProp.layer)),this.appendNodesToElement(t,"path"),this.updateCurve(t)},updateCurve:function(t){this._updateVisual(t),this.updatePathWithArrowHeads(t),this.setLineCap(t)},updatePathWithArrowHeads:function(t,e){var i,s,r=t.visProp,o=e?"highlight":"";i=e&&r.highlightstrokewidth?Math.max(utils_type.A.evaluate(r.highlightstrokewidth),utils_type.A.evaluate(r.strokewidth)):utils_type.A.evaluate(r.strokewidth),s=this.getArrowHeadData(t,i,o),this.makeArrows(t,s),t.elementClass===constants.A.OBJECT_CLASS_LINE?this.updateLineWithEndings(t,s):t.elementClass===constants.A.OBJECT_CLASS_CURVE&&this.updatePath(t),this.setArrowSize(t,s)},getArrowHeadData:function(t,e,i){var s,r,o,n,a=math.A.eps,l=0,h=0,u=0,c=0,d=utils_type.A.evaluate(t.visProp.firstarrow),p=utils_type.A.evaluate(t.visProp.lastarrow);return(d||p)&&(s=utils_type.A.exists(d.type)?utils_type.A.evaluate(d.type):t.elementClass===constants.A.OBJECT_CLASS_LINE?1:7,r=utils_type.A.exists(p.type)?utils_type.A.evaluate(p.type):t.elementClass===constants.A.OBJECT_CLASS_LINE?1:7,d&&(n=6,utils_type.A.exists(d.size)&&(n=utils_type.A.evaluate(d.size)),""!==i&&utils_type.A.exists(d[i+"size"])&&(n=utils_type.A.evaluate(d[i+"size"])),o=e*n,2===s?(o*=.5,a+=e*n):3===s?(o=e*n/3,a+=e):4===s||5===s||6===s?(o=e*n/1.5,a+=e*n):7===s?(o=0,n=10,a+=e):a+=e*n,l+=o,u=n),p&&(n=6,utils_type.A.exists(p.size)&&(n=utils_type.A.evaluate(p.size)),""!==i&&utils_type.A.exists(p[i+"size"])&&(n=utils_type.A.evaluate(p[i+"size"])),o=e*n,2===r?(o*=.5,a+=e*n):3===r?(o=e*n/3,a+=e):4===r||5===r||6===r?(o=e*n/1.5,a+=e*n):7===r?(o=0,n=10,a+=e):a+=e*n,h+=o,c=n)),t.visPropCalc.typeFirst=s,t.visPropCalc.typeLast=r,{evFirst:d,evLast:p,typeFirst:s,typeLast:r,offFirst:l,offLast:h,sizeFirst:u,sizeLast:c,showFirst:1,showLast:1,minLen:a,strokeWidth:e}},updateLineWithEndings:function(t,e){var i,s,r;return i=new base_coords.A(constants.A.COORDS_BY_USER,t.point1.coords.usrCoords,t.board),s=new base_coords.A(constants.A.COORDS_BY_USER,t.point2.coords.usrCoords,t.board),r=utils_type.A.evaluate(t.visProp.margin),geometry.A.calcStraight(t,i,s,r),this.handleTouchpoints(t,i,s,e),this.getPositionArrowHead(t,i,s,e),this.updateLinePrim(t.rendNode,i.scrCoords[1],i.scrCoords[2],s.scrCoords[1],s.scrCoords[2],t.board),this},updatePath:function(t){return utils_type.A.evaluate(t.visProp.handdrawing)?this.updatePathPrim(t.rendNode,this.updatePathStringBezierPrim(t),t.board):this.updatePathPrim(t.rendNode,this.updatePathStringPrim(t),t.board),this},getPositionArrowHead:function(t,e,i,s){var r,o,n,a,l;return(s.evFirst||s.evLast)&&(o=n=a=l=0,r=e.distance(constants.A.COORDS_BY_SCREEN,i),s.evFirst&&"vml"!==t.board.renderer.type&&(r>=s.minLen?(o=(i.scrCoords[1]-e.scrCoords[1])*s.offFirst/r,n=(i.scrCoords[2]-e.scrCoords[2])*s.offFirst/r):s.showFirst=0),s.evLast&&"vml"!==t.board.renderer.type&&(r>=s.minLen?(a=(i.scrCoords[1]-e.scrCoords[1])*s.offLast/r,l=(i.scrCoords[2]-e.scrCoords[2])*s.offLast/r):s.showLast=0),e.setCoordinates(constants.A.COORDS_BY_SCREEN,[e.scrCoords[1]+o,e.scrCoords[2]+n],!1,!0),i.setCoordinates(constants.A.COORDS_BY_SCREEN,[i.scrCoords[1]-a,i.scrCoords[2]-l],!1,!0)),this},handleTouchpoints:function(t,e,i,s){var r,o,n,a,l,h,u;return(s.evFirst||s.evLast)&&(n=a=l=h=u=0,r=utils_type.A.evaluate(t.point1.visProp.size)+utils_type.A.evaluate(t.point1.visProp.strokewidth),o=utils_type.A.evaluate(t.point2.visProp.size)+utils_type.A.evaluate(t.point2.visProp.strokewidth),s.evFirst&&utils_type.A.evaluate(t.visProp.touchfirstpoint)&&utils_type.A.evaluate(t.point1.visProp.visible)&&(n=e.distance(constants.A.COORDS_BY_SCREEN,i),a=(i.scrCoords[1]-e.scrCoords[1])*r/n,l=(i.scrCoords[2]-e.scrCoords[2])*r/n),s.evLast&&utils_type.A.evaluate(t.visProp.touchlastpoint)&&utils_type.A.evaluate(t.point2.visProp.visible)&&(n=e.distance(constants.A.COORDS_BY_SCREEN,i),h=(i.scrCoords[1]-e.scrCoords[1])*o/n,u=(i.scrCoords[2]-e.scrCoords[2])*o/n),e.setCoordinates(constants.A.COORDS_BY_SCREEN,[e.scrCoords[1]+a,e.scrCoords[2]+l],!1,!0),i.setCoordinates(constants.A.COORDS_BY_SCREEN,[i.scrCoords[1]-h,i.scrCoords[2]-u],!1,!0)),this},setArrowSize:function(t,e){return e.evFirst&&this._setArrowWidth(t.rendNodeTriangleStart,e.showFirst*e.strokeWidth,t.rendNode,e.sizeFirst),e.evLast&&this._setArrowWidth(t.rendNodeTriangleEnd,e.showLast*e.strokeWidth,t.rendNode,e.sizeLast),this},setLineCap:function(t){},drawTicks:function(t){t.rendNode=this.appendChildPrim(this.createPrim("path",t.id),utils_type.A.evaluate(t.visProp.layer)),this.appendNodesToElement(t,"path")},updateTicks:function(t){},drawEllipse:function(t){t.rendNode=this.appendChildPrim(this.createPrim("ellipse",t.id),utils_type.A.evaluate(t.visProp.layer)),this.appendNodesToElement(t,"ellipse"),this.updateEllipse(t)},updateEllipse:function(t){this._updateVisual(t);var e=t.Radius();Math.abs(t.center.coords.usrCoords[0])>math.A.eps&&!isNaN(e+t.center.coords.scrCoords[1]+t.center.coords.scrCoords[2])&&e*t.board.unitX<2e6&&this.updateEllipsePrim(t.rendNode,t.center.coords.scrCoords[1],t.center.coords.scrCoords[2],e*t.board.unitX,e*t.board.unitY),this.setLineCap(t)},drawPolygon:function(t){t.rendNode=this.appendChildPrim(this.createPrim("polygon",t.id),utils_type.A.evaluate(t.visProp.layer)),this.appendNodesToElement(t,"polygon"),this.updatePolygon(t)},updatePolygon:function(t){this._updateVisual(t,{stroke:!0,dash:!0}),this.updatePolygonPrim(t.rendNode,t)},displayCopyright:function(t,e){},drawInternalText:function(t){},updateInternalText:function(t){},drawText:function(t){var e,i,s,r;"html"===utils_type.A.evaluate(t.visProp.display)&&env.A.isBrowser&&"no"!==this.type?((e=this.container.ownerDocument.createElement("div")).style.position="absolute",e.className=utils_type.A.evaluate(t.visProp.cssclass),s=utils_type.A.evaluate(t.visProp.layer),utils_type.A.exists(s)||(s=0),i=""===this.container.style.zIndex?0:parseInt(this.container.style.zIndex,10),e.style.zIndex=i+s,this.container.appendChild(e),e.setAttribute("id",this.container.id+"_"+t.id)):e=this.drawInternalText(t),t.rendNode=e,t.htmlStr="",t.visProp.islabel&&utils_type.A.exists(t.visProp.anchor)?(r=utils_type.A.evaluate(t.visProp.anchor.visProp.visible),t.prepareUpdate().updateVisibility(r)):t.prepareUpdate().updateVisibility(),this.updateText(t)},updateText:function(t){var e,i,s,r,o,n,a,l,h,u,c,d=t.plaintext;if(t.visPropCalc.visible)if(this.updateTextStyle(t,!1),"html"===utils_type.A.evaluate(t.visProp.display)&&"no"!==this.type){if(isNaN(t.coords.scrCoords[1]+t.coords.scrCoords[2])||(i=t.coords.scrCoords[1],i=Math.abs(i)<1e6?i:1e6,"right"===(o=t.getAnchorX())?(e=t.board.canvasWidth-i,u="right"):"middle"===o?(e=i-.5*t.size[0],u="center"):(e=i,u="left"),t.visPropOld.left!==o+e&&("right"===o?(t.rendNode.style.right=e+"px",t.rendNode.style.left="auto"):(t.rendNode.style.left=e+"px",t.rendNode.style.right="auto"),t.visPropOld.left=o+e),i=t.coords.scrCoords[2]+this.vOffsetText,i=Math.abs(i)<1e6?i:1e6,"bottom"===(n=t.getAnchorY())?(e=t.board.canvasHeight-i,c="bottom"):"middle"===n?(e=i-.5*t.size[1],c="center"):(e=i,c="top"),t.visPropOld.top!==n+e&&("bottom"===n?(t.rendNode.style.top="auto",t.rendNode.style.bottom=e+"px"):(t.rendNode.style.bottom="auto",t.rendNode.style.top=e+"px"),t.visPropOld.top=n+e)),t.htmlStr!==d){try{t.type===utils_type.A.OBJECT_TYPE_BUTTON?t.rendNodeButton.innerHTML=d:t.type===utils_type.A.OBJECT_TYPE_CHECKBOX||t.type===utils_type.A.OBJECT_TYPE_INPUT?t.rendNodeLabel.innerHTML=d:t.rendNode.innerHTML=d}catch(e){s=t.rendNode.parentNode,t.rendNode.parentNode.removeChild(t.rendNode),t.rendNode.innerHTML=d,s.appendChild(t.rendNode)}if(t.htmlStr=d,utils_type.A.evaluate(t.visProp.usemathjax))try{MathJax.typeset?MathJax.typeset([t.rendNode]):MathJax.Hub.Queue(["Typeset",MathJax.Hub,t.rendNode])}catch(t){jxg.A.debug("MathJax (not yet) loaded")}else if(utils_type.A.evaluate(t.visProp.usekatex))try{(r=0===t.rendNode.innerHTML.indexOf("<span")&&t.rendNode.innerHTML.indexOf("<label")>0&&(t.rendNode.innerHTML.indexOf("<checkbox")>0||t.rendNode.innerHTML.indexOf("<input")>0)?t.rendNodeLabel:0===t.rendNode.innerHTML.indexOf("<button")?t.rendNodeButton:t.rendNode)&&katex.render(d,r,{macros:utils_type.A.evaluate(t.visProp.katexmacros),throwOnError:!1})}catch(t){jxg.A.debug("KaTeX not loaded (yet)")}else if(utils_type.A.evaluate(t.visProp.useasciimathml))try{AMprocessNode(t.rendNode,!1)}catch(t){jxg.A.debug("AsciiMathML not loaded (yet)")}}0!==(a=utils_type.A.evaluate(t.visProp.rotate))&&(a*=Math.PI/180,l=Math.cos(a),h=Math.sin(a),t.rendNode.style.transform="matrix("+[l,-1*h,h,l,0,0].join(",")+")",t.rendNode.style["transform-origin"]=u+" "+c),this.transformImage(t,t.transformations)}else this.updateInternalText(t)},_css2js:function(t){var e,i,s,r,o,n=[],a=utils_type.A.trim(t).replace(/;$/,"").split(";");for(i=a.length,e=0;e<i;++e)""!==utils_type.A.trim(a[e])&&(o=a[e].split(":"),s=utils_type.A.trim(o[0].replace(/-([a-z])/gi,(function(t,e){return e.toUpperCase()}))),r=utils_type.A.trim(o[1]),n.push({key:s,val:r}));return n},updateTextStyle:function(t,e){var i,s,r,o,n,a,l,h,u,c=t.visProp,d=env.A.isBrowser?c.display:"internal",p=["rendNode","rendNodeTag","rendNodeLabel"],_=p.length,f=utils_type.A.evaluate(c.fontunit),A=["cssdefaultstyle","cssstyle"],g=A.length;if(e?(r=c.highlightstrokecolor,s=c.highlightstrokeopacity,o=c.highlightcssclass):(r=c.strokecolor,s=c.strokeopacity,o=c.cssclass),"no"!==this.type&&("html"===d||"canvas"!==this.type)){for(h=0;h<g;h++)if(""!==(u=utils_type.A.evaluate(c[(e?"highlight":"")+A[h]]))&&t.visPropOld[A[h]]!==u){for(a=this._css2js(u),n=0;n<_;n++)if(utils_type.A.exists(t[p[n]]))for(l in a)a.hasOwnProperty(l)&&(t[p[n]].style[a[l].key]=a[l].val);t.visPropOld[A[h]]=u}if(i=utils_type.A.evaluate(c.fontsize),t.visPropOld.fontsize!==i){t.needsSizeUpdate=!0;try{for(n=0;n<_;n++)utils_type.A.exists(t[p[n]])&&(t[p[n]].style.fontSize=i+f)}catch(e){for(n=0;n<_;n++)utils_type.A.exists(t[p[n]])&&(t[p[n]].style.fontSize=i)}t.visPropOld.fontsize=i}}return this.setTabindex(t),this.setObjectTransition(t),"html"===d&&"no"!==this.type?(this.setObjectViewport(t,!0),t.visPropOld.cssclass!==o&&(t.rendNode.className=o,t.visPropOld.cssclass=o,t.needsSizeUpdate=!0),this.setObjectStrokeColor(t,r,s)):this.updateInternalTextStyle(t,r,s),this},updateInternalTextStyle:function(t,e,i){this.setObjectStrokeColor(t,e,i)},drawImage:function(t){},updateImage:function(t){this.updateRectPrim(t.rendNode,t.coords.scrCoords[1],t.coords.scrCoords[2]-t.size[1],t.size[0],t.size[1]),this.updateImageURL(t),this.transformImage(t,t.transformations),this._updateVisual(t,{stroke:!0,dash:!0},!0)},joinTransforms:function(t,e){var i,s=t.board.origin.scrCoords[1],r=t.board.origin.scrCoords[2],o=t.board.unitX,n=t.board.unitY,a=e.length,l=[[1,0,0],[-s/o,1/o,0],[r/n,0,-1/n]];for(i=0;i<a;i++)l=math.A.matMatMult(e[i].matrix,l);return l=math.A.matMatMult([[1,0,0],[s,o,0],[r,0,-n]],l)},transformImage:function(t,e){},updateImageURL:function(t){},updateImageStyle:function(t,e){t.rendNode.className=utils_type.A.evaluate(e?t.visProp.highlightcssclass:t.visProp.cssclass)},drawForeignObject:function(t){},updateForeignObject:function(t){},appendChildPrim:function(t,e){},appendNodesToElement:function(t,e){},createPrim:function(t,e){return null},remove:function(t){},makeArrows:function(t,e){},_setArrowWidth:function(t,e,i){},updateEllipsePrim:function(t,e,i,s,r){},updateLinePrim:function(t,e,i,s,r,o){},updatePathPrim:function(t,e,i){},updatePathStringPoint:function(t,e,i){},updatePathStringPrim:function(t){},updatePathStringBezierPrim:function(t){},updatePolygonPrim:function(t,e){},updateRectPrim:function(t,e,i,s,r){},setPropertyPrim:function(t,e,i){},setTabindex:function(t){var e;t.board.attr.keyboard.enabled&&utils_type.A.exists(t.rendNode)&&(e=utils_type.A.evaluate(t.visProp.tabindex),t.visPropCalc.visible&&!utils_type.A.evaluate(t.visProp.fixed)||(e=null),e!==t.visPropOld.tabindex&&(t.rendNode.setAttribute("tabindex",e),t.visPropOld.tabindex=e))},display:function(t,e){t&&(t.visPropOld.visible=e)},show:function(t){},hide:function(t){},setBuffering:function(t,e){},setDashStyle:function(t){},setDraft:function(t){if(utils_type.A.evaluate(t.visProp.draft)){var e=t.board.options.elements.draft.color,i=t.board.options.elements.draft.opacity;this.setObjectViewport(t),this.setObjectTransition(t),t.type===constants.A.OBJECT_TYPE_POLYGON?this.setObjectFillColor(t,e,i):(t.elementClass===constants.A.OBJECT_CLASS_POINT?this.setObjectFillColor(t,e,i):this.setObjectFillColor(t,"none",0),this.setObjectStrokeColor(t,e,i),this.setObjectStrokeWidth(t,t.board.options.elements.draft.strokeWidth))}},removeDraft:function(t){this.setObjectViewport(t),this.setObjectTransition(t),t.type===constants.A.OBJECT_TYPE_POLYGON?this.setObjectFillColor(t,t.visProp.fillcolor,t.visProp.fillopacity):(t.type===constants.A.OBJECT_CLASS_POINT&&this.setObjectFillColor(t,t.visProp.fillcolor,t.visProp.fillopacity),this.setObjectStrokeColor(t,t.visProp.strokecolor,t.visProp.strokeopacity),this.setObjectStrokeWidth(t,t.visProp.strokewidth))},setGradient:function(t){},updateGradient:function(t){},setObjectTransition:function(t,e){},setObjectViewport:function(t,e){},setObjectFillColor:function(t,e,i){},setObjectStrokeColor:function(t,e,i){},setObjectStrokeWidth:function(t,e){},setShadow:function(t){},highlight:function(t,e){var i,s,r,o=t.visProp;if(this.setObjectViewport(t),this.setObjectTransition(t),!o.draft){if(t.type===constants.A.OBJECT_TYPE_POLYGON)for(this.setObjectFillColor(t,o.highlightfillcolor,o.highlightfillopacity),s=utils_type.A.evaluate(o.highlightbystrokewidth),i=0;i<t.borders.length;i++)this.highlight(t.borders[i],!s);else t.elementClass===constants.A.OBJECT_CLASS_TEXT?this.updateTextStyle(t,!0):t.type===constants.A.OBJECT_TYPE_IMAGE?(this.updateImageStyle(t,!0),this.setObjectFillColor(t,o.highlightfillcolor,o.highlightfillopacity)):(this.setObjectStrokeColor(t,o.highlightstrokecolor,o.highlightstrokeopacity),this.setObjectFillColor(t,o.highlightfillcolor,o.highlightfillopacity));o.highlightstrokewidth&&!e&&(r=Math.max(utils_type.A.evaluate(o.highlightstrokewidth),utils_type.A.evaluate(o.strokewidth)),this.setObjectStrokeWidth(t,r),t.elementClass!==constants.A.OBJECT_CLASS_LINE&&t.elementClass!==constants.A.OBJECT_CLASS_CURVE||this.updatePathWithArrowHeads(t,!0))}return this},noHighlight:function(t){var e,i,s=t.visProp;if(this.setObjectViewport(t),this.setObjectTransition(t),!utils_type.A.evaluate(t.visProp.draft)){if(t.type===constants.A.OBJECT_TYPE_POLYGON)for(this.setObjectFillColor(t,s.fillcolor,s.fillopacity),e=0;e<t.borders.length;e++)this.noHighlight(t.borders[e]);else t.elementClass===constants.A.OBJECT_CLASS_TEXT?this.updateTextStyle(t,!1):t.type===constants.A.OBJECT_TYPE_IMAGE?(this.updateImageStyle(t,!1),this.setObjectFillColor(t,s.fillcolor,s.fillopacity)):(this.setObjectStrokeColor(t,s.strokecolor,s.strokeopacity),this.setObjectFillColor(t,s.fillcolor,s.fillopacity));i=utils_type.A.evaluate(s.strokewidth),this.setObjectStrokeWidth(t,i),t.elementClass!==constants.A.OBJECT_CLASS_LINE&&t.elementClass!==constants.A.OBJECT_CLASS_CURVE||this.updatePathWithArrowHeads(t,!1)}return this},suspendRedraw:function(){},unsuspendRedraw:function(){},drawNavigationBar:function(t,e){var i,s,r=function(t){t||(t=window.event),t.stopPropagation?t.stopPropagation():t.cancelBubble=!0},o=function(e,o,n,a){var l;n=n||"",(l=i.createElement("span")).innerHTML=e,l.style.paddingLeft="7px",l.style.paddingRight="7px",void 0!==l.classList&&(l.classList.add("JXG_navigation_button"),l.classList.add("JXG_navigation_button_"+a)),l.setAttribute("id",n+"_navigation_"+a),s.appendChild(l),env.A.addEvent(l,"click",(function(e){return utils_type.A.bind(o,t)(),!1}),t),env.A.addEvent(l,"pointerup",r,t),env.A.addEvent(l,"pointerdown",r,t),env.A.addEvent(l,"pointerleave",r,t),env.A.addEvent(l,"mouseup",r,t),env.A.addEvent(l,"mousedown",r,t),env.A.addEvent(l,"touchend",r,t),env.A.addEvent(l,"touchstart",r,t)};env.A.isBrowser&&"no"!==this.type&&(i=t.containerObj.ownerDocument,(s=i.createElement("div")).setAttribute("id",t.container+"_navigationbar"),s.style.color=e.strokecolor,s.style.backgroundColor=e.fillcolor,s.style.padding=e.padding,s.style.position=e.position,s.style.fontSize=e.fontsize,s.style.cursor=e.cursor,s.style.zIndex=e.zindex,t.containerObj.appendChild(s),s.style.right=e.right,s.style.bottom=e.bottom,void 0!==s.classList&&s.classList.add("JXG_navigation"),t.attr.showfullscreen&&o(t.attr.fullscreen.symbol,(function(){t.toFullscreen(t.attr.fullscreen.id)}),t.container,"fullscreen"),t.attr.showscreenshot&&o(t.attr.screenshot.symbol,(function(){window.setTimeout((function(){t.renderer.screenshot(t,"",!1)}),330)}),t.container,"screenshot"),t.attr.showreload&&o("↻",(function(){t.reload()}),t.container,"reload"),t.attr.showcleartraces&&o("⊗",(function(){t.clearTraces()}),t.container,"cleartraces"),t.attr.shownavigation&&(t.attr.showzoom&&(o("–",t.zoomOut,t.container,"out"),o("o",t.zoom100,t.container,"100"),o("+",t.zoomIn,t.container,"in")),o("←",t.clickLeftArrow,t.container,"left"),o("↓",t.clickUpArrow,t.container,"down"),o("↑",t.clickDownArrow,t.container,"up"),o("→",t.clickRightArrow,t.container,"right")))},getElementById:function(t){var e;return utils_type.A.exists(this.container)?(e=this.container.id+"_"+t,utils_type.A.exists(CSS)&&utils_type.A.exists(CSS.escape)&&(e=CSS.escape(e)),this.container.querySelector("#"+e)):""},removeToInsertLater:function(t){var e=t.parentNode,i=t.nextSibling;if(null!==e)return e.removeChild(t),function(){i?e.insertBefore(t,i):e.appendChild(t)}},resize:function(t,e){},createTouchpoints:function(t){},showTouchpoint:function(t){},hideTouchpoint:function(t){},updateTouchpoint:function(t,e){},dumpToDataURI:function(t){},dumpToCanvas:function(t,e,i,s){},screenshot:function(t){},setLayer:function(t,e){}});var renderer_abstract=jxg.A.AbstractRenderer;jxg.A.FileReader={handleRemoteFile:function(t,e,i,s,r,o){var n=!1;try{n=new XMLHttpRequest,"raw"===i.toLowerCase()?n.overrideMimeType("text/plain; charset="+r):n.overrideMimeType("text/xml; charset="+r)}catch(t){try{n=new ActiveXObject("Msxml2.XMLHTTP")}catch(t){try{n=new ActiveXObject("Microsoft.XMLHTTP")}catch(t){n=!1}}}if(n){n.open("GET",t,s),"raw"===i.toLowerCase()?this.cbp=function(){var t=n;4===t.readyState&&e(t.responseText)}:this.cbp=function(){var t=n,s="";4===t.readyState&&(s=!utils_type.A.exists(t.responseStream)||"PK"!==t.responseText.slice(0,2)&&31!==utils_encoding.asciiCharCodeAt(t.responseText.slice(0,1),0)?t.responseText:base64.decode(jxgBinFileReader(t)),this.parseString(s,e,i,o))},this.cb=utils_type.A.bind(this.cbp,this),n.onreadystatechange=this.cb;try{n.send(null)}catch(e){throw new Error("JSXGraph: A problem occurred while trying to read remote file '"+t+"'.")}}else jxg.A.debug("AJAX not activated!")},handleLocalFile:function(t,e,i,s,r,o){utils_type.A.exists(s)||(s=!0),"raw"===i.toLowerCase()?this.cbp=function(t){e(t.target.result)}:this.cbp=function(t){var s=t.target.result;this.parseString(s,e,i,o)},this.cb=utils_type.A.bind(this.cbp,this);var n=new FileReader;n.onload=this.cb,"raw"===i.toLowerCase()?n.readAsText(t):n.readAsText(t,r)},parseFileContent:function(t,e,i,s,r,o){utils_type.A.isString(t)||void 0===FileReader?this.handleRemoteFile(t,e,i,s,r,o):this.handleLocalFile(t,e,i,s,r,o)},parseString:function(t,e,i,s){var r;if(i=i.toLowerCase(),r=jxg.A.readers[i],utils_type.A.exists(r))new r(e,t).read();else if("jessiecode"!==i)throw new Error("JSXGraph: There is no reader available for '"+i+"'.");utils_type.A.isFunction(s)&&s(e)}},!env.A.isMetroApp()&&env.A.isBrowser&&"object"==typeof navigator&&/msie/i.test(navigator.userAgent)&&!/opera/i.test(navigator.userAgent)&&document&&document.write&&document.write('<script type="text/vbscript">\nFunction Base64Encode(inData)\n  Const Base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"\n  Dim cOut, sOut, I\n  For I = 1 To LenB(inData) Step 3\n    Dim nGroup, pOut, sGroup\n    nGroup = &H10000 * AscB(MidB(inData, I, 1)) + _\n      &H100 * MyASC(MidB(inData, I + 1, 1)) + MyASC(MidB(inData, I + 2, 1))\n    nGroup = Oct(nGroup)\n    nGroup = String(8 - Len(nGroup), "0") & nGroup\n    pOut = Mid(Base64, CLng("&o" & Mid(nGroup, 1, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 3, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 5, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 7, 2)) + 1, 1)\n    sOut = sOut + pOut\n  Next\n  Select Case LenB(inData) Mod 3\n    Case 1: \'8 bit final\n      sOut = Left(sOut, Len(sOut) - 2) + "=="\n    Case 2: \'16 bit final\n      sOut = Left(sOut, Len(sOut) - 1) + "="\n  End Select\n  Base64Encode = sOut\nEnd Function\n\nFunction MyASC(OneChar)\n  If OneChar = "" Then MyASC = 0 Else MyASC = AscB(OneChar)\nEnd Function\n\nFunction jxgBinFileReader(xhr)\n    Dim byteString\n    Dim b64String\n    Dim i\n    byteString = xhr.responseBody\n    ReDim byteArray(LenB(byteString))\n    For i = 1 To LenB(byteString)\n        byteArray(i-1) = AscB(MidB(byteString, i, 1))\n    Next\n    b64String = Base64Encode(byteString)\n    jxgBinFileReader = b64String\nEnd Function\n<\/script>\n');var reader_file=jxg.A.FileReader,geonext=__webpack_require__(86),jessiecode=__webpack_require__(428),utils_color=__webpack_require__(873);jxg.A.Composition=function(t){var e,i=this,s=["setAttribute","setParents","prepareUpdate","updateRenderer","update","fullUpdate","highlight","noHighlight"],r=function(t){return function(){var e;for(e in i.elements)i.elements.hasOwnProperty(e)&&utils_type.A.exists(i.elements[e][t])&&i.elements[e][t].apply(i.elements[e],arguments);return i}};for(e=0;e<s.length;e++)this[s[e]]=r(s[e]);for(e in this.elements={},this.objects=this.elements,this.elementsByName={},this.objectsList=[],this.groups={},this.methodMap={setAttribute:"setAttribute",setProperty:"setAttribute",setParents:"setParents",add:"add",remove:"remove",select:"select"},t)t.hasOwnProperty(e)&&this.add(e,t[e]);this.dump=!0,this.subs={}},jxg.A.extend(jxg.A.Composition.prototype,{add:function(t,e){return!(utils_type.A.exists(this[t])||!utils_type.A.exists(e))&&(utils_type.A.exists(e.id)?this.elements[e.id]=e:this.elements[t]=e,utils_type.A.exists(e.name)&&(this.elementsByName[e.name]=e),e.on("attribute:name",this.nameListener,this),this.objectsList.push(e),this[t]=e,this.methodMap[t]=e,!0)},remove:function(t){var e,i=!1;for(e in this.elements)if(this.elements.hasOwnProperty(e)&&this.elements[e].id===this[t].id){i=!0;break}return i&&(delete this.elements[this[t].id],delete this[t]),i},nameListener:function(t,e,i){delete this.elementsByName[t],this.elementsByName[e]=i},select:function(t){return utils_type.A.exists(jxg.A.Board)?jxg.A.Board.prototype.select.call(this,t):new jxg.A.Composition},getParents:function(){return this.parents},getType:function(){return this.elType},getAttributes:function(){var t,e={};for(t in this.subs)this.subs.hasOwnProperty(t)&&(e[t]=this.subs[t].visProp);return this.attr}});var composition=jxg.A.Composition;jxg.A.Board=function(t,e,i,s,r,o,n,a,l,h,u){if(this.BOARD_MODE_NONE=0,this.BOARD_MODE_DRAG=1,this.BOARD_MODE_MOVE_ORIGIN=2,this.BOARD_MODE_ZOOM=17,this.BOARD_QUALITY_LOW=1,this.BOARD_QUALITY_HIGH=2,utils_type.A.exists(u.document)&&!1!==u.document?this.document=u.document:env.A.isBrowser&&(this.document=document),this.container="",this.containerObj=null,utils_type.A.isString(t)?(this.container=t,this.containerObj=env.A.isBrowser?this.document.getElementById(this.container):null):env.A.isBrowser&&(this.containerObj=t,this.container=this.containerObj.getAttribute("id"),null===this.container&&(this.container="null"+parseInt(1e8*Math.random()).toString())),env.A.isBrowser&&"no"!==e.type&&null===this.containerObj)throw new Error('\nJSXGraph: HTML container element "'+t+'" not found.');this.renderer=e,this.grids=[],this.options=utils_type.A.deepCopy(src_options.A),this.attr=u,"default"!==this.attr.theme&&utils_type.A.exists(jxg.A.themes[this.attr.theme])&&utils_type.A.mergeAttr(this.options,jxg.A.themes[this.attr.theme],!0),this.dimension=2,this.jc=new jessiecode.A,this.jc.use(this),this.origin={},this.origin.usrCoords=[1,0,0],this.origin.scrCoords=[1,s[0],s[1]],this.zoomX=r,this.zoomY=o,this.unitX=n*this.zoomX,this.unitY=a*this.zoomY,this.keepaspectratio=!1,this.canvasWidth=l,this.canvasHeight=h,utils_type.A.exists(i)&&""!==i&&env.A.isBrowser&&!utils_type.A.exists(this.document.getElementById(i))?this.id=i:this.id=this.generateId(),utils_event.A.eventify(this),this.hooks=[],this.dependentBoards=[],this.inUpdate=!1,this.objects={},this.objectsList=[],this.groups={},this.animationObjects={},this.highlightedObjects={},this.numObjects=0,this.elementsByName={},this.mode=this.BOARD_MODE_NONE,this.updateQuality=this.BOARD_QUALITY_HIGH,this.isSuspendedRedraw=!1,this.calculateSnapSizes(),this.drag_dx=0,this.drag_dy=0,this.drag_position=[0,0],this.mouse={},this.touches=[],this.xmlString="",this.cPos=[],this.touchMoveLast=0,this.touchMoveLastId=1/0,this.positionAccessLast=0,this.downObjects=[],this.clickObjects={},this.focusObjects=[],this.attr.showcopyright&&this.renderer.displayCopyright(constants.A.licenseText,parseInt(this.options.text.fontSize,10)),this.needsFullUpdate=!1,this.reducedUpdate=!1,this.currentCBDef="none",this.geonextCompatibilityMode=!1,this.options.text.useASCIIMathML&&translateASCIIMath?init():this.options.text.useASCIIMathML=!1,this.hasMouseHandlers=!1,this.hasTouchHandlers=!1,this.hasPointerHandlers=!1,this.hasWheelHandlers=!1,this.hasMouseUp=!1,this.hasTouchEnd=!1,this.hasPointerUp=!1,this._drag_offset=[0,0],this._inputDevice="mouse",this._board_touches=[],this.selectingMode=!1,this.isSelecting=!1,this._isScrolling=!1,this._isResizing=!1,this.selectingBox=[[0,0],[0,0]],this.userLog=[],this.mathLib=Math,this.mathLibJXG=jxg.A.Math,!0===this.attr.registerevents?this.attr.registerevents={fullscreen:!0,keyboard:!0,pointer:!0,resize:!0,wheel:!0}:"object"==typeof this.attr.registerevents&&(utils_type.A.exists(this.attr.registerevents.fullscreen)||(this.attr.registerevents.fullscreen=!0),utils_type.A.exists(this.attr.registerevents.keyboard)||(this.attr.registerevents.keyboard=!0),utils_type.A.exists(this.attr.registerevents.pointer)||(this.attr.registerevents.pointer=!0),utils_type.A.exists(this.attr.registerevents.resize)||(this.attr.registerevents.resize=!0),utils_type.A.exists(this.attr.registerevents.wheel)||(this.attr.registerevents.wheel=!0)),!1!==this.attr.registerevents&&(this.attr.registerevents.fullscreen&&this.addFullscreenEventHandlers(),this.attr.registerevents.keyboard&&this.addKeyboardEventHandlers(),this.attr.registerevents.pointer&&this.addEventHandlers(),this.attr.registerevents.resize&&this.addResizeEventHandlers(),this.attr.registerevents.wheel&&this.addWheelEventHandlers()),this.methodMap={update:"update",fullUpdate:"fullUpdate",on:"on",off:"off",trigger:"trigger",setAttribute:"setAttribute",setBoundingBox:"setBoundingBox",setView:"setBoundingBox",getBoundingBox:"getBoundingBox",BoundingBox:"getBoundingBox",getView:"getBoundingBox",View:"getBoundingBox",migratePoint:"migratePoint",colorblind:"emulateColorblindness",suspendUpdate:"suspendUpdate",unsuspendUpdate:"unsuspendUpdate",clearTraces:"clearTraces",left:"clickLeftArrow",right:"clickRightArrow",up:"clickUpArrow",down:"clickDownArrow",zoomIn:"zoomIn",zoomOut:"zoomOut",zoom100:"zoom100",zoomElements:"zoomElements",remove:"removeObject",removeObject:"removeObject"}},jxg.A.extend(jxg.A.Board.prototype,{generateName:function(t){var e,i,s=this.attr.maxnamelength,r="",o="",n=[],a="";if(t.type===constants.A.OBJECT_TYPE_TICKS)return"";for(e=utils_type.A.isPoint(t)||utils_type.A.isPoint3D(t)?["","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"]:t.type===constants.A.OBJECT_TYPE_ANGLE?["","&alpha;","&beta;","&gamma;","&delta;","&epsilon;","&zeta;","&eta;","&theta;","&iota;","&kappa;","&lambda;","&mu;","&nu;","&xi;","&omicron;","&pi;","&rho;","&sigma;","&tau;","&upsilon;","&phi;","&chi;","&psi;","&omega;"]:["","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"],utils_type.A.isPoint(t)||t.elementClass===constants.A.OBJECT_CLASS_LINE||t.type===constants.A.OBJECT_TYPE_ANGLE||(r=t.type===constants.A.OBJECT_TYPE_POLYGON?"P_{":t.elementClass===constants.A.OBJECT_CLASS_CIRCLE?"k_{":t.elementClass===constants.A.OBJECT_CLASS_TEXT?"t_{":"s_{",o="}"),i=0;i<s;i++)n[i]=0;for(;n[s-1]<e.length;){for(n[0]=1;n[0]<e.length;n[0]++){for(a=r,i=s;i>0;i--)a+=e[n[i-1]];if(!utils_type.A.exists(this.elementsByName[a+o]))return a+o}for(n[0]=e.length,i=1;i<s;i++)n[i-1]===e.length&&(n[i-1]=1,n[i]+=1)}return""},generateId:function(){for(var t=1;utils_type.A.exists(jxg.A.boards["jxgBoard"+t]);)t=Math.round(65535*Math.random());return"jxgBoard"+t},setId:function(t,e){var i,s=this.numObjects,r=t.id;if(this.numObjects+=1,""===r||!utils_type.A.exists(r))for(r=this.id+e+s;utils_type.A.exists(this.objects[r]);)i=Math.round(65535*Math.random()),r=this.id+e+s+"-"+i;return t.id=r,this.objects[r]=t,t._pos=this.objectsList.length,this.objectsList[this.objectsList.length]=t,r},finalizeAdding:function(t){!1===utils_type.A.evaluate(t.visProp.visible)&&this.renderer.display(t,!1)},finalizeLabel:function(t){t.hasLabel&&!utils_type.A.evaluate(t.label.visProp.islabel)&&!1===utils_type.A.evaluate(t.label.visProp.visible)&&this.renderer.display(t.label,!1)},checkFrameRate:function(t){var e=!1,i=(new Date).getTime();return utils_type.A.exists(t.pointerId)&&this.touchMoveLastId!==t.pointerId&&(e=!0,this.touchMoveLastId=t.pointerId),!e&&(i-this.touchMoveLast)*this.attr.maxframerate>=1e3&&(e=!0),e&&(this.touchMoveLast=i),e},getCoordsTopLeftCorner:function(){var t,e,i,s,r,o=this.document.ownerDocument||this.document,n=o.documentElement||this.document.body.parentNode,a=o.body,l=this.containerObj;if(this.cPos.length>0&&(this.mode===this.BOARD_MODE_DRAG||this.mode===this.BOARD_MODE_MOVE_ORIGIN||(new Date).getTime()-this.positionAccessLast<1e3))return this.cPos;if(this.positionAccessLast=(new Date).getTime(),l.getBoundingClientRect){for(i=l.getBoundingClientRect(),s=1,r=l;r&&utils_type.A.exists(r.parentNode);)utils_type.A.exists(r.style)&&utils_type.A.exists(r.style.zoom)&&""!==r.style.zoom&&(s*=parseFloat(r.style.zoom)),r=r.parentNode;return(t=[i.left*s,i.top*s])[0]+=env.A.getProp(l,"border-left-width"),t[1]+=env.A.getProp(l,"border-top-width"),"vml"!==this.renderer.type&&(t[0]+=env.A.getProp(l,"padding-left"),t[1]+=env.A.getProp(l,"padding-top")),this.cPos=t.slice(),this.cPos}return t=env.A.getOffset(l),e=this.document.documentElement.ownerDocument,!this.containerObj.currentStyle&&e.defaultView&&(t[0]+=env.A.getProp(n,"margin-left"),t[1]+=env.A.getProp(n,"margin-top"),t[0]+=env.A.getProp(n,"border-left-width"),t[1]+=env.A.getProp(n,"border-top-width"),t[0]+=env.A.getProp(n,"padding-left"),t[1]+=env.A.getProp(n,"padding-top")),a&&(t[0]+=env.A.getProp(a,"left"),t[1]+=env.A.getProp(a,"top")),"object"==typeof google&&google.translate&&(t[0]+=10,t[1]+=25),t[0]+=env.A.getProp(l,"border-left-width"),t[1]+=env.A.getProp(l,"border-top-width"),"vml"!==this.renderer.type&&(t[0]+=env.A.getProp(l,"padding-left"),t[1]+=env.A.getProp(l,"padding-top")),t[0]+=this.attr.offsetx,t[1]+=this.attr.offsety,this.cPos=t.slice(),this.cPos},getPointLoc:function(t,e){var i,s,r,o;return i=this.getBoundingBox(),2===(s=t).length&&s.unshift(void 0),r=[0,0],o=e||0,utils_type.A.isNumber(o)&&(o=[o,o,o,o]),s[1]>i[2]-o[1]&&(r[0]=1),s[1]<i[0]+o[3]&&(r[0]=-1),s[2]>i[1]-o[0]&&(r[1]=1),s[2]<i[3]+o[2]&&(r[1]=-1),r},getLocationOrigin:function(t){return this.getPointLoc([0,0],t)},getMousePosition:function(t,e){var i,s,r=this.getCoordsTopLeftCorner();return i=env.A.getPosition(t,e,this.document),this.updateCSSTransforms(),s=[1,i[0]-r[0],i[1]-r[1]],(s=math.A.matVecMult(this.cssTransMat,s))[1]/=s[0],s[2]/=s[0],[s[1],s[2]]},initMoveOrigin:function(t,e){this.drag_dx=t-this.origin.scrCoords[1],this.drag_dy=e-this.origin.scrCoords[2],this.mode=this.BOARD_MODE_MOVE_ORIGIN,this.updateQuality=this.BOARD_QUALITY_LOW},initMoveObject:function(t,e,i,s){var r,o,n,a=[],l=[],h=this.objectsList.length,u={visProp:{layer:-1e4}};for(this._shiftKey=i.shiftKey,this._ctrlKey=i.ctrlKey,o=0;o<h;o++)n=(r=this.objectsList[o]).hasPoint&&r.hasPoint(t,e),r.visPropCalc.visible&&n&&(r.triggerEventHandlers([s+"down","down"],[i]),this.downObjects.push(r)),n&&r.isDraggable&&r.visPropCalc.visible&&(this.geonextCompatibilityMode&&(utils_type.A.isPoint(r)||r.elementClass===constants.A.OBJECT_CLASS_TEXT)||!this.geonextCompatibilityMode)&&!utils_type.A.evaluate(r.visProp.fixed)&&(r.visProp.layer>u.visProp.layer||r.visProp.layer===u.visProp.layer&&r.lastDragTime.getTime()>=u.lastDragTime.getTime())&&(this.attr.ignorelabels&&utils_type.A.exists(u.label)&&r===u.label||(u=r,a.push(u),utils_type.A.exists(u.coords)?l.push(statistics.A.subtract(u.coords.scrCoords.slice(1),[t,e])):l.push([0,0])));return this.attr.drag.enabled&&a.length>0&&(this.mode=this.BOARD_MODE_DRAG),this.attr.takefirst?(a.length=1,this._drag_offset=l[0]):(a=a.slice(-1),this._drag_offset=l[l.length-1]),this._drag_offset||(this._drag_offset=[0,0]),"svg"===this.renderer.type&&utils_type.A.exists(a[0])&&utils_type.A.evaluate(a[0].visProp.dragtotopoflayer)&&1===a.length&&utils_type.A.exists(a[0].rendNode)&&a[0].rendNode.parentNode.appendChild(a[0].rendNode),a.length>=1&&(a[0].highlight(!0),this.triggerEventHandlers(["mousehit","hit"],[i,a[0]])),a},moveObject:function(t,e,i,s,r){var o,n,a,l=new base_coords.A(constants.A.COORDS_BY_SCREEN,this.getScrCoordsOfMouse(t,e),this);i&&i.obj&&((o=i.obj).coords&&(n=o.coords.scrCoords.slice()),this.addLogEntry("drag",o,l.usrCoords.slice(1)),this.drag_position=[l.scrCoords[1],l.scrCoords[2]],this.drag_position=statistics.A.add(this.drag_position,this._drag_offset),this._shiftKey=s.shiftKey,this._ctrlKey=s.ctrlKey,utils_type.A.exists(o.coords)?o.setPositionDirectly(constants.A.COORDS_BY_SCREEN,this.drag_position):(this.displayInfobox(!1),isNaN(i.targets[0].Xprev+i.targets[0].Yprev)||o.setPositionDirectly(constants.A.COORDS_BY_SCREEN,[l.scrCoords[1],l.scrCoords[2]],[i.targets[0].Xprev,i.targets[0].Yprev]),i.targets[0].Xprev=l.scrCoords[1],i.targets[0].Yprev=l.scrCoords[2]),utils_type.A.exists(o.coords)&&(o.prepareUpdate().update(!1).updateRenderer(),this.updateInfobox(o),o.prepareUpdate().update(!0).updateRenderer()),o.coords&&(a=o.coords.scrCoords),o.coords&&n[1]===a[1]&&n[2]===a[2]||(o.triggerEventHandlers([r+"drag","drag"],[s]),this.update()),o.highlight(!0),this.triggerEventHandlers(["mousehit","hit"],[s,o]),o.lastDragTime=new Date)},twoFingerMove:function(t,e,i){var s;utils_type.A.exists(t)&&utils_type.A.exists(t.obj)&&((s=t.obj).elementClass===constants.A.OBJECT_CLASS_LINE||s.type===constants.A.OBJECT_TYPE_POLYGON?this.twoFingerTouchObject(t.targets,s,e):s.elementClass===constants.A.OBJECT_CLASS_CIRCLE&&this.twoFingerTouchCircle(t.targets,s,e),i&&s.triggerEventHandlers(["touchdrag","drag"],[i]))},getTwoFingerTransform(t,e,i,s){var r,o,n,a,l,h,u,c,d,p,_,f,A,g,m,y,b;return o=(r=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t.Xprev,t.Yprev],this).usrCoords)[1],n=r[2],a=(r=new base_coords.A(constants.A.COORDS_BY_SCREEN,[e.Xprev,e.Yprev],this).usrCoords)[1],l=r[2],c=(r=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t.X,t.Y],this).usrCoords)[1],d=r[2],g=((f=(p=(r=new base_coords.A(constants.A.COORDS_BY_SCREEN,[e.X,e.Y],this).usrCoords)[1])-c)*(h=a-o)+(A=(_=r[2])-d)*(u=l-n))/(y=h*h+u*u),m=(A*h-f*u)/y,i||(g/=b=math.A.hypot(g,m),m/=b),s||(m=0),[1,0,0,.5*(c+p-g*(o+a)+m*(n+l)),g,-m,.5*(d+_-m*(o+a)-g*(n+l)),m,g]},twoFingerTouchObject:function(t,e,i){var s,r,o,n,a,l,h=!1;if(utils_type.A.exists(t[0])&&utils_type.A.exists(t[1])&&!isNaN(t[0].Xprev+t[0].Yprev+t[1].Xprev+t[1].Yprev)){if(r=this.getTwoFingerTransform(t[0],t[1],utils_type.A.evaluate(e.visProp.scalable),utils_type.A.evaluate(e.visProp.rotatable)),(s=this.create("transform",r,{type:"generic"})).update(),e.elementClass===constants.A.OBJECT_CLASS_LINE)o=[],e.point1.draggable()&&o.push(e.point1),e.point2.draggable()&&o.push(e.point2),s.applyOnce(o);else if(e.type===constants.A.OBJECT_TYPE_POLYGON){for(a=e.vertices.length-1,l=e.visProp,h=utils_type.A.evaluate(l.snaptogrid)||utils_type.A.evaluate(l.snaptopoints),n=0;n<a&&!h;++n)l=e.vertices[n].visProp,h=(h=h||utils_type.A.evaluate(l.snaptogrid)||utils_type.A.evaluate(l.snaptopoints))||!e.vertices[n].draggable();if(!h){for(o=[],n=0;n<a;++n)e.vertices[n].draggable()&&o.push(e.vertices[n]);s.applyOnce(o)}}this.update(),e.highlight(!0)}},twoFingerTouchCircle:function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p;"pointCircle"!==e.method&&"pointLine"!==e.method&&utils_type.A.exists(t[0])&&utils_type.A.exists(t[1])&&!isNaN(t[0].Xprev+t[0].Yprev+t[1].Xprev+t[1].Yprev)&&(i===t[0].num?(s=t[1],r=t[0]):(s=t[0],r=t[1]),a=new base_coords.A(constants.A.COORDS_BY_SCREEN,[s.Xprev,s.Yprev],this).usrCoords,n=new base_coords.A(constants.A.COORDS_BY_SCREEN,[r.Xprev,r.Yprev],this).usrCoords,o=new base_coords.A(constants.A.COORDS_BY_SCREEN,[r.X,r.Y],this).usrCoords,h=geometry.A.rad(n.slice(1),a.slice(1),o.slice(1)),u=this.create("transform",[-a[1],-a[2]],{type:"translate"}),c=this.create("transform",[h],{type:"rotate"}),u.melt(c),utils_type.A.evaluate(e.visProp.scalable)&&(l=geometry.A.distance(a,o)/geometry.A.distance(a,n),d=this.create("transform",[l,l],{type:"scale"}),u.melt(d)),p=this.create("transform",[a[1],a[2]],{type:"translate"}),u.melt(p),e.center.draggable()&&u.applyOnce([e.center]),"twoPoints"===e.method?e.point2.draggable()&&u.applyOnce([e.point2]):"pointRadius"===e.method&&utils_type.A.isNumber(e.updateRadius.origin)&&e.setRadius(e.radius*l),this.update(e.center),e.highlight(!0))},highlightElements:function(t,e,i,s){var r,o,n,a={},l=this.objectsList.length;for(r=0;r<l;r++)n=(o=this.objectsList[r]).id,utils_type.A.exists(o.hasPoint)&&o.visPropCalc.visible&&o.hasPoint(t,e)&&(this.updateInfobox(o),utils_type.A.exists(this.highlightedObjects[n])||(a[n]=o,o.highlight(),this.triggerEventHandlers(["mousehit","hit"],[i,o,s])),o.mouseover?o.triggerEventHandlers(["mousemove","move"],[i]):(o.triggerEventHandlers(["mouseover","over"],[i]),o.mouseover=!0));for(r=0;r<l;r++)n=(o=this.objectsList[r]).id,o.mouseover&&(a[n]||(o.triggerEventHandlers(["mouseout","out"],[i]),o.mouseover=!1))},saveStartPos:function(t,e){var i,s,r=[];if(t.type===constants.A.OBJECT_TYPE_TICKS)r.push([1,NaN,NaN]);else if(t.elementClass===constants.A.OBJECT_CLASS_LINE)r.push(t.point1.coords.usrCoords),r.push(t.point2.coords.usrCoords);else if(t.elementClass===constants.A.OBJECT_CLASS_CIRCLE)r.push(t.center.coords.usrCoords),"twoPoints"===t.method&&r.push(t.point2.coords.usrCoords);else if(t.type===constants.A.OBJECT_TYPE_POLYGON)for(s=t.vertices.length-1,i=0;i<s;i++)r.push(t.vertices[i].coords.usrCoords);else if(t.type===constants.A.OBJECT_TYPE_SECTOR)r.push(t.point1.coords.usrCoords),r.push(t.point2.coords.usrCoords),r.push(t.point3.coords.usrCoords);else if(utils_type.A.isPoint(t)||t.type===constants.A.OBJECT_TYPE_GLIDER)r.push(t.coords.usrCoords);else if(t.elementClass===constants.A.OBJECT_CLASS_CURVE)t.points.length>0&&r.push(t.points[0].usrCoords);else try{r.push(t.coords.usrCoords)}catch(t){jxg.A.debug("JSXGraph+ saveStartPos: obj.coords.usrCoords not available: "+t)}for(s=r.length,i=0;i<s;i++)e.Zstart.push(r[i][0]),e.Xstart.push(r[i][1]),e.Ystart.push(r[i][2])},mouseOriginMoveStart:function(t){var e,i;return(e=this._isRequiredKeyPressed(t,"pan"))&&(i=this.getMousePosition(t),this.initMoveOrigin(i[0],i[1])),e},mouseOriginMove:function(t){var e,i=this.mode===this.BOARD_MODE_MOVE_ORIGIN;return i&&(e=this.getMousePosition(t),this.moveOrigin(e[0],e[1],!0)),i},touchStartMoveOriginOneFinger:function(t){var e,i,s=t.touches;return(e=this.attr.pan.enabled&&!this.attr.pan.needtwofingers&&1===s.length)&&(i=this.getMousePosition(t,0),this.initMoveOrigin(i[0],i[1])),e},touchOriginMove:function(t){var e,i=this.mode===this.BOARD_MODE_MOVE_ORIGIN;return i&&(e=this.getMousePosition(t,0),this.moveOrigin(e[0],e[1],!0)),i},originMoveEnd:function(){this.updateQuality=this.BOARD_QUALITY_HIGH,this.mode=this.BOARD_MODE_NONE},addEventHandlers:function(){env.A.supportsPointerEvents()?this.addPointerEventHandlers():(this.addMouseEventHandlers(),this.addTouchEventHandlers()),null!==this.containerObj&&(this.containerObj.oncontextmenu=function(t){return utils_type.A.exists(t)&&t.preventDefault(),!1})},addResizeEventHandlers:function(){if(env.A.isBrowser){try{this.startResizeObserver()}catch(t){env.A.addEvent(window,"resize",this.resizeListener,this),this.startIntersectionObserver()}env.A.addEvent(window,"scroll",this.scrollListener,this)}},removeEventHandlers:function(){this.removeMouseEventHandlers(),this.removeTouchEventHandlers(),this.removePointerEventHandlers(),this.removeFullscreenEventHandlers(),this.removeKeyboardEventHandlers(),env.A.isBrowser&&(utils_type.A.exists(this.resizeObserver)?this.stopResizeObserver():(env.A.removeEvent(window,"resize",this.resizeListener,this),this.stopIntersectionObserver()),env.A.removeEvent(window,"scroll",this.scrollListener,this))},addPointerEventHandlers:function(){if(!this.hasPointerHandlers&&env.A.isBrowser){var t=this.attr.movetarget||this.containerObj;window.navigator.msPointerEnabled?(env.A.addEvent(this.containerObj,"MSPointerDown",this.pointerDownListener,this),env.A.addEvent(t,"MSPointerMove",this.pointerMoveListener,this)):(env.A.addEvent(this.containerObj,"pointerdown",this.pointerDownListener,this),env.A.addEvent(t,"pointermove",this.pointerMoveListener,this),env.A.addEvent(t,"pointerleave",this.pointerLeaveListener,this),env.A.addEvent(t,"click",this.pointerClickListener,this),env.A.addEvent(t,"dblclick",this.pointerDblClickListener,this)),null!==this.containerObj&&(this.containerObj.style.touchAction="none"),this.hasPointerHandlers=!0}},addMouseEventHandlers:function(){if(!this.hasMouseHandlers&&env.A.isBrowser){var t=this.attr.movetarget||this.containerObj;env.A.addEvent(this.containerObj,"mousedown",this.mouseDownListener,this),env.A.addEvent(t,"mousemove",this.mouseMoveListener,this),env.A.addEvent(t,"click",this.mouseClickListener,this),env.A.addEvent(t,"dblclick",this.mouseDblClickListener,this),this.hasMouseHandlers=!0}},addTouchEventHandlers:function(t){if(!this.hasTouchHandlers&&env.A.isBrowser){var e=this.attr.movetarget||this.containerObj;env.A.addEvent(this.containerObj,"touchstart",this.touchStartListener,this),env.A.addEvent(e,"touchmove",this.touchMoveListener,this),this.hasTouchHandlers=!0}},addWheelEventHandlers:function(){!this.hasWheelHandlers&&env.A.isBrowser&&(env.A.addEvent(this.containerObj,"mousewheel",this.mouseWheelListener,this),env.A.addEvent(this.containerObj,"DOMMouseScroll",this.mouseWheelListener,this),this.hasWheelHandlers=!0)},addFullscreenEventHandlers:function(){var t,e=["fullscreenchange","mozfullscreenchange","webkitfullscreenchange","msfullscreenchange"],i=e.length;if(!this.hasFullscreenEventHandlers&&env.A.isBrowser){for(t=0;t<i;t++)env.A.addEvent(this.document,e[t],this.fullscreenListener,this);this.hasFullscreenEventHandlers=!0}},addKeyboardEventHandlers:function(){this.attr.keyboard.enabled&&!this.hasKeyboardHandlers&&env.A.isBrowser&&(env.A.addEvent(this.containerObj,"keydown",this.keyDownListener,this),env.A.addEvent(this.containerObj,"focusin",this.keyFocusInListener,this),env.A.addEvent(this.containerObj,"focusout",this.keyFocusOutListener,this),this.hasKeyboardHandlers=!0)},removeKeyboardEventHandlers:function(){this.hasKeyboardHandlers&&env.A.isBrowser&&(env.A.removeEvent(this.containerObj,"keydown",this.keyDownListener,this),env.A.removeEvent(this.containerObj,"focusin",this.keyFocusInListener,this),env.A.removeEvent(this.containerObj,"focusout",this.keyFocusOutListener,this),this.hasKeyboardHandlers=!1)},removeFullscreenEventHandlers:function(){var t,e=["fullscreenchange","mozfullscreenchange","webkitfullscreenchange","msfullscreenchange"],i=e.length;if(this.hasFullscreenEventHandlers&&env.A.isBrowser){for(t=0;t<i;t++)env.A.removeEvent(this.document,e[t],this.fullscreenListener,this);this.hasFullscreenEventHandlers=!1}},removePointerEventHandlers:function(){if(this.hasPointerHandlers&&env.A.isBrowser){var t=this.attr.movetarget||this.containerObj;window.navigator.msPointerEnabled?(env.A.removeEvent(this.containerObj,"MSPointerDown",this.pointerDownListener,this),env.A.removeEvent(t,"MSPointerMove",this.pointerMoveListener,this)):(env.A.removeEvent(this.containerObj,"pointerdown",this.pointerDownListener,this),env.A.removeEvent(t,"pointermove",this.pointerMoveListener,this),env.A.removeEvent(t,"pointerleave",this.pointerLeaveListener,this),env.A.removeEvent(t,"click",this.pointerClickListener,this),env.A.removeEvent(t,"dblclick",this.pointerDblClickListener,this)),this.hasWheelHandlers&&(env.A.removeEvent(this.containerObj,"mousewheel",this.mouseWheelListener,this),env.A.removeEvent(this.containerObj,"DOMMouseScroll",this.mouseWheelListener,this)),this.hasPointerUp&&(window.navigator.msPointerEnabled?env.A.removeEvent(this.document,"MSPointerUp",this.pointerUpListener,this):(env.A.removeEvent(this.document,"pointerup",this.pointerUpListener,this),env.A.removeEvent(this.document,"pointercancel",this.pointerUpListener,this)),this.hasPointerUp=!1),this.hasPointerHandlers=!1}},removeMouseEventHandlers:function(){if(this.hasMouseHandlers&&env.A.isBrowser){var t=this.attr.movetarget||this.containerObj;env.A.removeEvent(this.containerObj,"mousedown",this.mouseDownListener,this),env.A.removeEvent(t,"mousemove",this.mouseMoveListener,this),env.A.removeEvent(t,"click",this.mouseClickListener,this),env.A.removeEvent(t,"dblclick",this.mouseDblClickListener,this),this.hasMouseUp&&(env.A.removeEvent(this.document,"mouseup",this.mouseUpListener,this),this.hasMouseUp=!1),this.hasWheelHandlers&&(env.A.removeEvent(this.containerObj,"mousewheel",this.mouseWheelListener,this),env.A.removeEvent(this.containerObj,"DOMMouseScroll",this.mouseWheelListener,this)),this.hasMouseHandlers=!1}},removeTouchEventHandlers:function(){if(this.hasTouchHandlers&&env.A.isBrowser){var t=this.attr.movetarget||this.containerObj;env.A.removeEvent(this.containerObj,"touchstart",this.touchStartListener,this),env.A.removeEvent(t,"touchmove",this.touchMoveListener,this),this.hasTouchEnd&&(env.A.removeEvent(this.document,"touchend",this.touchEndListener,this),this.hasTouchEnd=!1),this.hasTouchHandlers=!1}},clickLeftArrow:function(){return this.moveOrigin(this.origin.scrCoords[1]+.1*this.canvasWidth,this.origin.scrCoords[2]),this},clickRightArrow:function(){return this.moveOrigin(this.origin.scrCoords[1]-.1*this.canvasWidth,this.origin.scrCoords[2]),this},clickUpArrow:function(){return this.moveOrigin(this.origin.scrCoords[1],this.origin.scrCoords[2]-.1*this.canvasHeight),this},clickDownArrow:function(){return this.moveOrigin(this.origin.scrCoords[1],this.origin.scrCoords[2]+.1*this.canvasHeight),this},gestureChangeListener:function(t){var e,i,s,r,o,n,a,l,h,u,c,d,p,_=!1,f=this.attr.zoom.factorx,A=this.attr.zoom.factory,g=!1;return this.mode!==this.BOARD_MODE_ZOOM||(t.preventDefault(),n=geometry.A.distance([t.touches[0].clientX,t.touches[0].clientY],[t.touches[1].clientX,t.touches[1].clientY],2),void 0===t.scale&&(t.scale=n/this.prevDist),!!utils_type.A.exists(this.prevCoords)&&(i=[t.touches[0].clientX-this.prevCoords[0][0],t.touches[0].clientY-this.prevCoords[0][1]],s=[t.touches[1].clientX-this.prevCoords[1][0],t.touches[1].clientY-this.prevCoords[1][1]],i[0]*i[0]+i[1]*i[1]<100&&s[0]*s[0]+s[1]*s[1]<100||(r=geometry.A.rad(i,[0,0],s),"pan"!==this.isPreviousGesture&&Math.abs(r)>.2*Math.PI&&Math.abs(r)<1.8*Math.PI&&(_=!0),"pan"===this.isPreviousGesture||_||(Math.abs(t.scale)<.77||Math.abs(t.scale)>1.3)&&(_=!0),o=t.scale/this.prevScale,this.prevScale=t.scale,this.prevCoords=[[t.touches[0].clientX,t.touches[0].clientY],[t.touches[1].clientX,t.touches[1].clientY]],e=new base_coords.A(constants.A.COORDS_BY_SCREEN,this.getMousePosition(t,0),this),this.attr.pan.enabled&&this.attr.pan.needtwofingers&&!_?(this.isPreviousGesture="pan",this.moveOrigin(e.scrCoords[1],e.scrCoords[2],!0)):this.attr.zoom.enabled&&Math.abs(o-1)<.5&&(g=!1,h=this.attr.zoom.center,(this.attr.zoom.pinchhorizontal||this.attr.zoom.pinchvertical)&&(u=Math.abs(t.touches[0].clientX-t.touches[1].clientX),c=Math.abs(t.touches[0].clientY-t.touches[1].clientY),a=Math.abs(Math.atan2(c,u)),l=Math.PI*this.attr.zoom.pinchsensitivity/90),!this.keepaspectratio&&this.attr.zoom.pinchhorizontal&&a<l?(this.attr.zoom.factorx=o,this.attr.zoom.factory=1,d=0,p=0,g=!0):!this.keepaspectratio&&this.attr.zoom.pinchvertical&&Math.abs(a-.5*Math.PI)<l?(this.attr.zoom.factorx=1,this.attr.zoom.factory=o,d=0,p=0,g=!0):this.attr.zoom.pinch&&(this.attr.zoom.factorx=o,this.attr.zoom.factory=o,d=e.usrCoords[1],p=e.usrCoords[2],g=!0),g&&("board"===h?this.zoomIn():this.zoomIn(d,p),this.attr.zoom.factorx=f,this.attr.zoom.factory=A))),!1))},gestureStartListener:function(t){var e;return t.preventDefault(),this.prevScale=1,this.prevDist=geometry.A.distance([t.touches[0].clientX,t.touches[0].clientY],[t.touches[1].clientX,t.touches[1].clientY],2),this.prevCoords=[[t.touches[0].clientX,t.touches[0].clientY],[t.touches[1].clientX,t.touches[1].clientY]],this.isPreviousGesture="none",e=this.getMousePosition(t,0),this.initMoveOrigin(e[0],e[1]),this.mode=this.BOARD_MODE_ZOOM,!1},_isRequiredKeyPressed:function(t,e){var i=this.attr[e];return!!i.enabled&&!(!(i.needshift&&t.shiftKey||!i.needshift&&!t.shiftKey)||!(i.needctrl&&t.ctrlKey||!i.needctrl&&!t.ctrlKey))},_isPointerRegistered:function(t){var e,i=this._board_touches.length;for(e=0;e<i;e++)if(this._board_touches[e].pointerId===t.pointerId)return!0;return!1},_pointerStorePosition:function(t){var e,i;for(e=0,i=!1;e<this._board_touches.length;e++)if(this._board_touches[e].pointerId===t.pointerId){this._board_touches[e].clientX=t.clientX,this._board_touches[e].clientY=t.clientY,i=!0;break}return!i&&this._board_touches.length<2&&this._board_touches.push({pointerId:t.pointerId,clientX:t.clientX,clientY:t.clientY}),this},_pointerRemoveTouches:function(t){var e;for(e=0;e<this._board_touches.length;e++)if(this._board_touches[e].pointerId===t.pointerId){this._board_touches.splice(e,1);break}return this},_pointerClearTouches:function(t){this._board_touches.length>0&&this.dehighlightAll(),this.updateQuality=this.BOARD_QUALITY_HIGH,this.mode=this.BOARD_MODE_NONE,this._board_touches=[],this.touches=[]},_getPointerInputDevice:function(t){if(env.A.isBrowser){if("touch"===t.pointerType||window.navigator.msMaxTouchPoints&&window.navigator.msMaxTouchPoints>1)return"touch";if("mouse"===t.pointerType)return"mouse";if("pen"===t.pointerType)return"pen"}return"mouse"},pointerDownListener:function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p;if(!e&&this._isPointerRegistered(t))return!1;if(null===utils_type.A.evaluate(this.attr.movetarget)&&utils_type.A.exists(t.target)&&utils_type.A.exists(t.target.releasePointerCapture)&&t.target.releasePointerCapture(t.pointerId),!e&&t.isPrimary,this.hasPointerUp||(window.navigator.msPointerEnabled?env.A.addEvent(this.document,"MSPointerUp",this.pointerUpListener,this):(env.A.addEvent(this.document,"pointerup",this.pointerUpListener,this),env.A.addEvent(this.document,"pointercancel",this.pointerUpListener,this)),this.hasPointerUp=!0),this.hasMouseHandlers&&this.removeMouseEventHandlers(),this.hasTouchHandlers&&this.removeTouchEventHandlers(),this.document.selection&&utils_type.A.isFunction(this.document.selection.empty))this.document.selection.empty();else if(window.getSelection&&(l=window.getSelection()).removeAllRanges)try{l.removeAllRanges()}catch(t){}if(this._inputDevice=this._getPointerInputDevice(t),u=this._inputDevice,this.options.precision.hasPoint=this.options.precision[u],n=this.getMousePosition(t),this._testForSelection(t),this.selectingMode)return this._startSelecting(n),void this.triggerEventHandlers(["touchstartselecting","pointerstartselecting","startselecting"],[t]);if(this.attr.drag.enabled&&e?(a=[e],this.mode=this.BOARD_MODE_DRAG):a=this.initMoveObject(n[0],n[1],t,u),h={num:t.pointerId,X:n[0],Y:n[1],Xprev:NaN,Yprev:NaN,Xstart:[],Ystart:[],Zstart:[]},a.length>0){for(d=a[a.length-1],c=!1,s=0;s<this.touches.length;s++)if(this.touches[s].obj===d){r=s,o=this.touches[s].targets.push(h)-1,c=!0;break}c||(o=0,r=this.touches.push({obj:d,targets:[h]})-1),this.dehighlightAll(),d.highlight(!0),this.saveStartPos(d,this.touches[r].targets[o]),t&&t.preventDefault&&!i&&t.preventDefault()}return this.touches.length>0&&!i&&(t.preventDefault(),t.stopPropagation()),!!env.A.isBrowser&&("touch"!==this._getPointerInputDevice(t)?this.mode===this.BOARD_MODE_NONE&&this.mouseOriginMoveStart(t):(this._pointerStorePosition(t),t.touches=this._board_touches,1===t.touches.length&&this.mode===this.BOARD_MODE_NONE&&this.touchStartMoveOriginOneFinger(t)||2!==t.touches.length||this.mode!==this.BOARD_MODE_NONE&&this.mode!==this.BOARD_MODE_MOVE_ORIGIN||(this.mode===this.BOARD_MODE_MOVE_ORIGIN&&this.originMoveEnd(),this.gestureStartListener(t))),p="none",this.mode!==this.BOARD_MODE_NONE||!utils_type.A.evaluate(this.attr.browserpan)||utils_type.A.evaluate(this.attr.pan.enabled)&&!utils_type.A.evaluate(this.attr.pan.needtwofingers)||(p="pan-x pan-y"),this.containerObj.style.touchAction=p,this.triggerEventHandlers(["touchstart","down","pointerdown","MSPointerDown"],[t]),!0)},_handleClicks:function(t,e){var i,s,r=this;if(this.selectingMode)t.stopPropagation();else{if(s=utils_type.A.evaluate(this.attr.clickdelay),utils_type.A.evaluate(this.attr.dblclicksuppressclick))this._preventSingleClick=!1,this._singleClickTimer=setTimeout((function(){if(!r._preventSingleClick)for(i in r.triggerEventHandlers(e,[t]),r.clickObjects)r.clickObjects.hasOwnProperty(i)&&(r.clickObjects[i].triggerEventHandlers(e,[t]),delete r.clickObjects[i])}),s);else{for(i in r.triggerEventHandlers(e,[t]),r.clickObjects)r.clickObjects.hasOwnProperty(i)&&r.clickObjects[i].triggerEventHandlers(e,[t]);setTimeout((function(){for(i in r.clickObjects)r.clickObjects.hasOwnProperty(i)&&delete r.clickObjects[i]}),s)}t.stopPropagation()}},_handleDblClicks:function(t,e){var i;if(this.selectingMode)t.stopPropagation();else{for(i in this._preventSingleClick=!0,clearTimeout(this._singleClickTimer),this.triggerEventHandlers(e,[t]),this.clickObjects)this.clickObjects.hasOwnProperty(i)&&(this.clickObjects[i].triggerEventHandlers(e,[t]),delete this.clickObjects[i]);t.stopPropagation()}},pointerClickListener:function(t){this._handleClicks(t,["click","pointerclick"])},pointerDblClickListener:function(t){this._handleDblClicks(t,["dblclick","pointerdblclick"])},mouseClickListener:function(t){this._handleClicks(t,["click","mouseclick"])},mouseDblClickListener:function(t){this._handleDblClicks(t,["dblclick","mousedblclick"])},pointerMoveListener:function(t){var e,i,s,r,o,n;if("touch"===this._getPointerInputDevice(t)&&!this._isPointerRegistered(t))return this.BOARD_MODE_NONE;if(!this.checkFrameRate(t))return!1;if(this.mode!==this.BOARD_MODE_DRAG&&(this.dehighlightAll(),this.displayInfobox(!1)),this.mode!==this.BOARD_MODE_NONE&&(t.preventDefault(),t.stopPropagation()),this.updateQuality=this.BOARD_QUALITY_LOW,this._inputDevice=this._getPointerInputDevice(t),n=this._inputDevice,this.options.precision.hasPoint=this.options.precision[n],r=.3333*this.options.precision.hasPoint,s=this.getMousePosition(t),null===utils_type.A.evaluate(this.attr.movetarget)&&s[0]<=r||s[1]<=r||s[0]>=this.canvasWidth-r||s[1]>=this.canvasHeight-r)return this.mode===this.BOARD_MODE_NONE;if(this.selectingMode)this._moveSelecting(s),this.triggerEventHandlers(["touchmoveselecting","moveselecting","pointermoveselecting"],[t,this.mode]);else if(!this.mouseOriginMove(t))if(this.mode===this.BOARD_MODE_DRAG){for(e=0;e<this.touches.length;e++)for(o=this.touches[e].targets,i=0;i<o.length;i++)if(o[i].num===t.pointerId){o[i].X=s[0],o[i].Y=s[1],1===o.length?this.moveObject(s[0],s[1],this.touches[e],t,n):2===o.length&&(this.twoFingerMove(this.touches[e],t.pointerId,t),o[i].Xprev=s[0],o[i].Yprev=s[1]);break}}else"touch"===this._getPointerInputDevice(t)&&(this._pointerStorePosition(t),2===this._board_touches.length&&(t.touches=this._board_touches,this.gestureChangeListener(t))),this.highlightElements(s[0],s[1],t,-1);return this.triggerEventHandlers(["pointermove","MSPointerMove","move"],[t,this.mode]),this.updateQuality=this.BOARD_QUALITY_HIGH,this.mode===this.BOARD_MODE_NONE},pointerUpListener:function(t){var e,i,s,r,o,n=!1;if(this.triggerEventHandlers(["touchend","up","pointerup","MSPointerUp"],[t]),this.displayInfobox(!1),t)for(e=0;e<this.touches.length;e++)for(o=this.touches[e].targets,i=0;i<o.length;i++)if(o[i].num===t.pointerId){o.splice(i,1),0===o.length&&this.touches.splice(e,1);break}if(this.originMoveEnd(),this.update(),this.selectingMode)this._stopSelecting(t),this.triggerEventHandlers(["touchstopselecting","pointerstopselecting","stopselecting"],[t]),this.stopSelectionMode();else for(e=this.downObjects.length-1;e>-1;e--){for(s=!1,i=0;i<this.touches.length;i++)this.touches[i].obj.id===this.downObjects[e].id&&(s=!0);s||(this.downObjects[e].triggerEventHandlers(["touchend","up","pointerup","MSPointerUp"],[t]),utils_type.A.exists(this.downObjects[e].coords)||(this.downObjects[e].snapToGrid(),this.downObjects[e].snapToPoints(),n=!0),r=this.downObjects[e].eventHandlers,(utils_type.A.exists(r.click)&&r.click.length>0||utils_type.A.exists(r.pointerclick)&&r.pointerclick.length>0||utils_type.A.exists(r.dblclick)&&r.dblclick.length>0||utils_type.A.exists(r.pointerdblclick)&&r.pointerdblclick.length>0)&&(this.clickObjects[this.downObjects[e].id]=this.downObjects[e]),this.downObjects.splice(e,1))}return this.hasPointerUp&&(window.navigator.msPointerEnabled?env.A.removeEvent(this.document,"MSPointerUp",this.pointerUpListener,this):(env.A.removeEvent(this.document,"pointerup",this.pointerUpListener,this),env.A.removeEvent(this.document,"pointercancel",this.pointerUpListener,this)),this.hasPointerUp=!1),this._pointerClearTouches(t.pointerId),"touch"!==this._getPointerInputDevice(t)&&this.dehighlightAll(),n&&this.update(),!0},pointerLeaveListener:function(t){return this.displayInfobox(!1),this.dehighlightAll(),!0},touchStartListener:function(t){var e,i,s,r,o,n,a,l,h,u,c=this.options.precision.touch,d=t.touches;for(this.hasTouchEnd||(env.A.addEvent(this.document,"touchend",this.touchEndListener,this),this.hasTouchEnd=!0),this.document.selection&&utils_type.A.isFunction(this.document.selection.empty)?this.document.selection.empty():window.getSelection&&window.getSelection().removeAllRanges(),this._inputDevice="touch",this.options.precision.hasPoint=this.options.precision.touch,e=0;e<d.length;e++)d[e].jxg_isused=!1;for(e=0;e<this.touches.length;e++)for(u=this.touches[e].targets,r=0;r<u.length;r++){u[r].num=-1,c=this.options.precision.touch;do{for(o=0;o<d.length;o++)if(Math.abs(Math.pow(d[o].screenX-u[r].X,2)+Math.pow(d[o].screenY-u[r].Y,2))<c*c){u[r].num=o,u[r].X=d[o].screenX,u[r].Y=d[o].screenY,d[o].jxg_isused=!0;break}c*=2}while(-1===u[r].num&&c<this.options.precision.touchMax);-1===u[r].num&&(jxg.A.debug("i couldn't find a targettouches for target no "+r+" on "+this.touches[e].obj.name+" ("+this.touches[e].obj.id+"). Removed the target."),jxg.A.debug("eps = "+c+", touchMax = "+src_options.A.precision.touchMax),u.splice(e,1))}for(e=0;e<d.length;e++)if(!d[e].jxg_isused){if(i=this.getMousePosition(t,e),this.selectingMode)return this._startSelecting(i),this.triggerEventHandlers(["touchstartselecting","startselecting"],[t]),t.preventDefault(),t.stopPropagation(),this.options.precision.hasPoint=this.options.precision.mouse,this.touches.length>0;if(0!==(s=this.initMoveObject(i[0],i[1],t,"touch")).length)if(n=s[s.length-1],h={num:e,X:d[e].screenX,Y:d[e].screenY,Xprev:NaN,Yprev:NaN,Xstart:[],Ystart:[],Zstart:[]},utils_type.A.isPoint(n)||n.elementClass===constants.A.OBJECT_CLASS_TEXT||n.type===constants.A.OBJECT_TYPE_TICKS||n.type===constants.A.OBJECT_TYPE_IMAGE)l=[h],this.saveStartPos(n,l[0]),this.touches.push({obj:n,targets:l}),n.highlight(!0);else if(n.elementClass===constants.A.OBJECT_CLASS_LINE||n.elementClass===constants.A.OBJECT_CLASS_CIRCLE||n.elementClass===constants.A.OBJECT_CLASS_CURVE||n.type===constants.A.OBJECT_TYPE_POLYGON){for(a=!1,r=0;r<this.touches.length;r++)n.id===this.touches[r].obj.id&&(a=!0,1===this.touches[r].targets.length&&(this.saveStartPos(n,h),this.touches[r].targets.push(h)),d[e].jxg_isused=!0);a||(l=[h],this.saveStartPos(n,l[0]),this.touches.push({obj:n,targets:l}),n.highlight(!0))}d[e].jxg_isused=!0}return this.touches.length>0&&(t.preventDefault(),t.stopPropagation()),1===d.length&&this.mode===this.BOARD_MODE_NONE&&this.touchStartMoveOriginOneFinger(t)||2!==d.length||this.mode!==this.BOARD_MODE_NONE&&this.mode!==this.BOARD_MODE_MOVE_ORIGIN||(this.mode===this.BOARD_MODE_MOVE_ORIGIN&&this.originMoveEnd(),this.gestureStartListener(t)),this.options.precision.hasPoint=this.options.precision.mouse,this.triggerEventHandlers(["touchstart","down"],[t]),!1},touchMoveListener:function(t){var e,i,s,r,o=t.touches;if(!this.checkFrameRate(t))return!1;if(this.mode!==this.BOARD_MODE_NONE&&(t.preventDefault(),t.stopPropagation()),this.mode!==this.BOARD_MODE_DRAG&&(this.dehighlightAll(),this.displayInfobox(!1)),this._inputDevice="touch",this.options.precision.hasPoint=this.options.precision.touch,this.updateQuality=this.BOARD_QUALITY_LOW,this.selectingMode){for(e=0;e<o.length;e++)if(!o[e].jxg_isused){i=this.getMousePosition(t,e),this._moveSelecting(i),this.triggerEventHandlers(["touchmoves","moveselecting"],[t,this.mode]);break}}else if(!this.touchOriginMove(t))if(this.mode===this.BOARD_MODE_DRAG){for(e=0;e<this.touches.length;e++)if(1===(r=this.touches[e].targets).length){if(o[r[0].num]){if((i=this.getMousePosition(t,r[0].num))[0]<0||i[0]>this.canvasWidth||i[1]<0||i[1]>this.canvasHeight)return;r[0].X=i[0],r[0].Y=i[1],this.moveObject(i[0],i[1],this.touches[e],t,"touch")}}else if(2===r.length&&r[0].num>-1&&r[1].num>-1&&o[r[0].num]&&o[r[1].num]){if(i=this.getMousePosition(t,r[0].num),s=this.getMousePosition(t,r[1].num),i[0]<0||i[0]>this.canvasWidth||i[1]<0||i[1]>this.canvasHeight||s[0]<0||s[0]>this.canvasWidth||s[1]<0||s[1]>this.canvasHeight)return;r[0].X=i[0],r[0].Y=i[1],r[1].X=s[0],r[1].Y=s[1],this.twoFingerMove(this.touches[e],r[0].num,t),r[0].Xprev=i[0],r[0].Yprev=i[1],r[1].Xprev=s[0],r[1].Yprev=s[1]}}else 2===o.length&&this.gestureChangeListener(t),i=this.getMousePosition(t,0),this.highlightElements(i[0],i[1],t,-1);return this.mode!==this.BOARD_MODE_DRAG&&this.displayInfobox(!1),this.triggerEventHandlers(["touchmove","move"],[t,this.mode]),this.options.precision.hasPoint=this.options.precision.mouse,this.updateQuality=this.BOARD_QUALITY_HIGH,this.mode===this.BOARD_MODE_NONE},touchEndListener:function(t){var e,i,s,r,o,n,a=this.options.precision.touch,l=[],h=t&&t.touches,u=!1;if(this.triggerEventHandlers(["touchend","up"],[t]),this.displayInfobox(!1),this.selectingMode)this._stopSelecting(t),this.triggerEventHandlers(["touchstopselecting","stopselecting"],[t]),this.stopSelectionMode();else if(h&&h.length>0){for(e=0;e<this.touches.length;e++)l[e]=this.touches[e];for(this.touches.length=0,e=0;e<h.length;e++)h[e].jxg_isused=!1;for(e=0;e<l.length;e++){for(r=!1,o=0,n=l[e].targets,i=0;i<n.length;i++)for(n[i].found=!1,s=0;s<h.length;s++)if(Math.abs(Math.pow(h[s].screenX-n[i].X,2)+Math.pow(h[s].screenY-n[i].Y,2))<a*a){n[i].found=!0,n[i].num=s,n[i].X=h[s].screenX,n[i].Y=h[s].screenY,o+=1;break}if(utils_type.A.isPoint(l[e].obj)?r=n[0]&&n[0].found:l[e].obj.elementClass===constants.A.OBJECT_CLASS_LINE?r=n[0]&&n[0].found||n[1]&&n[1].found:l[e].obj.elementClass===constants.A.OBJECT_CLASS_CIRCLE&&(r=1===o||3===o),r)for(this.touches.push({obj:l[e].obj,targets:[]}),i=0;i<n.length;i++)n[i].found&&this.touches[this.touches.length-1].targets.push({num:n[i].num,X:n[i].screenX,Y:n[i].screenY,Xprev:NaN,Yprev:NaN,Xstart:n[i].Xstart,Ystart:n[i].Ystart,Zstart:n[i].Zstart});else l[e].obj.noHighlight()}}else this.touches.length=0;for(e=this.downObjects.length-1;e>-1;e--){for(r=!1,i=0;i<this.touches.length;i++)this.touches[i].obj.id===this.downObjects[e].id&&(r=!0);r||(this.downObjects[e].triggerEventHandlers(["touchup","up"],[t]),utils_type.A.exists(this.downObjects[e].coords)||(this.downObjects[e].snapToGrid(),this.downObjects[e].snapToPoints(),u=!0),this.downObjects.splice(e,1))}return h&&0!==h.length||(this.hasTouchEnd&&(env.A.removeEvent(this.document,"touchend",this.touchEndListener,this),this.hasTouchEnd=!1),this.dehighlightAll(),this.updateQuality=this.BOARD_QUALITY_HIGH,this.originMoveEnd(),u&&this.update()),!0},mouseDownListener:function(t){var e,i,s;if(this.document.selection&&utils_type.A.isFunction(this.document.selection.empty)?this.document.selection.empty():window.getSelection&&window.getSelection().removeAllRanges(),!this.hasMouseUp)return env.A.addEvent(this.document,"mouseup",this.mouseUpListener,this),this.hasMouseUp=!0,this._inputDevice="mouse",this.options.precision.hasPoint=this.options.precision.mouse,e=this.getMousePosition(t),this._testForSelection(t),this.selectingMode?(this._startSelecting(e),void this.triggerEventHandlers(["mousestartselecting","startselecting"],[t])):(0===(i=this.initMoveObject(e[0],e[1],t,"mouse")).length?(this.mode=this.BOARD_MODE_NONE,s=!0):(this.mouse={obj:null,targets:[{X:e[0],Y:e[1],Xprev:NaN,Yprev:NaN}]},this.mouse.obj=i[i.length-1],this.dehighlightAll(),this.mouse.obj.highlight(!0),this.mouse.targets[0].Xstart=[],this.mouse.targets[0].Ystart=[],this.mouse.targets[0].Zstart=[],this.saveStartPos(this.mouse.obj,this.mouse.targets[0]),t&&t.preventDefault?t.preventDefault():window.event&&(window.event.returnValue=!1)),this.mode===this.BOARD_MODE_NONE&&(s=this.mouseOriginMoveStart(t)),this.triggerEventHandlers(["mousedown","down"],[t]),s)},mouseMoveListener:function(t){var e;if(!this.checkFrameRate(t))return!1;e=this.getMousePosition(t),this.updateQuality=this.BOARD_QUALITY_LOW,this.mode!==this.BOARD_MODE_DRAG&&(this.dehighlightAll(),this.displayInfobox(!1)),this.selectingMode?(this._moveSelecting(e),this.triggerEventHandlers(["mousemoveselecting","moveselecting"],[t,this.mode])):this.mouseOriginMove(t)||(this.mode===this.BOARD_MODE_DRAG?this.moveObject(e[0],e[1],this.mouse,t,"mouse"):this.highlightElements(e[0],e[1],t,-1),this.triggerEventHandlers(["mousemove","move"],[t,this.mode])),this.updateQuality=this.BOARD_QUALITY_HIGH},mouseUpListener:function(t){var e;if(!1===this.selectingMode&&this.triggerEventHandlers(["mouseup","up"],[t]),this.updateQuality=this.BOARD_QUALITY_HIGH,this.mouse&&this.mouse.obj&&(utils_type.A.exists(this.mouse.obj.coords)||(this.mouse.obj.snapToGrid(this.mouse.targets[0]),this.mouse.obj.snapToPoints())),this.originMoveEnd(),this.dehighlightAll(),this.update(),this.selectingMode)this._stopSelecting(t),this.triggerEventHandlers(["mousestopselecting","stopselecting"],[t]),this.stopSelectionMode();else for(e=0;e<this.downObjects.length;e++)this.downObjects[e].triggerEventHandlers(["mouseup","up"],[t]);this.downObjects.length=0,this.hasMouseUp&&(env.A.removeEvent(this.document,"mouseup",this.mouseUpListener,this),this.hasMouseUp=!1),this.mouse=null},mouseWheelListener:function(t){var e,i;return!(this.attr.zoom.enabled&&this.attr.zoom.wheel&&this._isRequiredKeyPressed(t,"zoom"))||(e=(t=t||window.event).detail?-t.detail:t.wheelDelta/40,i="board"===this.attr.zoom.center?[]:new base_coords.A(constants.A.COORDS_BY_SCREEN,this.getMousePosition(t),this).usrCoords,e>0?this.zoomIn(i[1],i[2]):this.zoomOut(i[1],i[2]),this.triggerEventHandlers(["mousewheel"],[t]),t.preventDefault(),!1)},keyDownListener:function(t){var e,i,s,r,o,n,a=t.target.id,l=0,h=0,u=utils_type.A.evaluate(this.attr.keyboard.dx)/this.unitX,c=utils_type.A.evaluate(this.attr.keyboard.dy)/this.unitY,d=!1,p=!0;return!(!this.attr.keyboard.enabled||""===a)&&((!(r=this.containerObj.shadowRoot||document).activeElement||"INPUT"!==(i=r.activeElement).tagName&&"textarea"!==i.tagName)&&(e=a.replace(this.containerObj.id+"_",""),i=this.select(e),utils_type.A.exists(i.coords)&&(n=i.coords.usrCoords.slice(1)),utils_type.A.evaluate(this.attr.keyboard.panshift)&&t.shiftKey||utils_type.A.evaluate(this.attr.keyboard.panctrl)&&t.ctrlKey?(!0===utils_type.A.evaluate(this.attr.zoom.enabled)&&(d=!0),38===t.keyCode?this.clickUpArrow():40===t.keyCode?this.clickDownArrow():37===t.keyCode?this.clickLeftArrow():39===t.keyCode?this.clickRightArrow():d&&171===t.keyCode?this.zoomIn():d&&173===t.keyCode?this.zoomOut():d&&79===t.keyCode?this.zoom100():p=!1):(utils_type.A.exists(i.visProp)&&(utils_type.A.exists(i.visProp.snaptogrid)&&i.visProp.snaptogrid&&utils_type.A.evaluate(i.visProp.snapsizex)&&utils_type.A.evaluate(i.visProp.snapsizey)?(u=l=(s=i.getSnapSizes())[0],c=h=s[1]):utils_type.A.exists(i.visProp.attracttogrid)&&i.visProp.attracttogrid&&utils_type.A.evaluate(i.visProp.attractordistance)&&utils_type.A.evaluate(i.visProp.attractorunit)&&(h=l=1.1*utils_type.A.evaluate(i.visProp.attractordistance),"screen"===utils_type.A.evaluate(i.visProp.attractorunit)&&(l/=this.unitX,h/=this.unitX),u=Math.max(l,u),c=Math.max(h,c))),38===t.keyCode?o=[0,c]:40===t.keyCode?o=[0,-c]:37===t.keyCode?o=[-u,0]:39===t.keyCode?o=[u,0]:p=!1,o&&i.isDraggable&&i.visPropCalc.visible&&(this.geonextCompatibilityMode&&(utils_type.A.isPoint(i)||i.elementClass===constants.A.OBJECT_CLASS_TEXT)||!this.geonextCompatibilityMode)&&!utils_type.A.evaluate(i.visProp.fixed)&&(this.mode=this.BOARD_MODE_DRAG,utils_type.A.exists(i.coords)&&(o[0]+=n[0],o[1]+=n[1]),utils_type.A.exists(i.coords)?(i.setPosition(jxg.A.COORDS_BY_USER,o),this.updateInfobox(i)):(this.displayInfobox(!1),i.setPositionDirectly(constants.A.COORDS_BY_USER,o,[0,0])),this.triggerEventHandlers(["keymove","move"],[t,this.mode]),i.triggerEventHandlers(["keydrag","drag"],[t]),this.mode=this.BOARD_MODE_NONE)),this.update(),p&&utils_type.A.exists(t.preventDefault)&&t.preventDefault(),p))},keyFocusInListener:function(t){var e,i,s=t.target.id;if(!this.attr.keyboard.enabled||""===s)return!1;e=s.replace(this.containerObj.id+"_",""),i=this.select(e),utils_type.A.exists(i.highlight)&&(i.highlight(!0),this.focusObjects=[e],i.triggerEventHandlers(["hit"],[t])),utils_type.A.exists(i.coords)&&this.updateInfobox(i)},keyFocusOutListener:function(t){if(!this.attr.keyboard.enabled)return!1;this.focusObjects=[],this.dehighlightAll(),this.displayInfobox(!1)},updateContainerDims:function(){var t,e,i,s,r,o;t=(i=this.containerObj.getBoundingClientRect()).width,e=i.height,window&&window.getComputedStyle&&(s=window.getComputedStyle(this.containerObj,null),r=parseFloat(s.getPropertyValue("border-left-width"))+parseFloat(s.getPropertyValue("border-right-width")),isNaN(r)||(t-=r),o=parseFloat(s.getPropertyValue("border-top-width"))+parseFloat(s.getPropertyValue("border-bottom-width")),isNaN(o)||(e-=o)),t<=0||e<=0||isNaN(t)||isNaN(e)||(isNaN(this.getBoundingBox()[0])&&this.setBoundingBox(this.attr.boundingbox,this.keepaspectratio,"keep"),utils_type.A.exists(this._prevDim)&&this._prevDim.w===t&&this._prevDim.h===e||(this.resizeContainer(t,e,!0),this._prevDim={w:t,h:e}))},startResizeObserver:function(){var t=this;env.A.isBrowser&&this.attr.resize&&this.attr.resize.enabled&&(this.resizeObserver=new ResizeObserver((function(e){t._isResizing||(t._isResizing=!0,window.setTimeout((function(){try{t.updateContainerDims()}catch(e){t.stopResizeObserver()}finally{t._isResizing=!1}}),t.attr.resize.throttle))})),this.resizeObserver.observe(this.containerObj))},stopResizeObserver:function(){env.A.isBrowser&&this.attr.resize&&this.attr.resize.enabled&&utils_type.A.exists(this.resizeObserver)&&this.resizeObserver.unobserve(this.containerObj)},resizeListener:function(){var t=this;env.A.isBrowser&&this.attr.resize&&this.attr.resize.enabled&&(this._isScrolling||this._isResizing||(this._isResizing=!0,window.setTimeout((function(){t.updateContainerDims(),t._isResizing=!1}),this.attr.resize.throttle)))},scrollListener:function(t){var e=this;env.A.isBrowser&&(this._isScrolling||(this._isScrolling=!0,window.setTimeout((function(){e._isScrolling=!1}),66)))},startIntersectionObserver:function(){var t=this;try{this.intersectionObserver=new IntersectionObserver((function(e){isNaN(t.getBoundingBox()[0])&&t.updateContainerDims()}),{root:null,rootMargin:"0px",threshold:.8}),this.intersectionObserver.observe(t.containerObj)}catch(t){jxg.A.debug("JSXGraph: IntersectionObserver not available in this browser.")}},stopIntersectionObserver:function(){utils_type.A.exists(this.intersectionObserver)&&this.intersectionObserver.unobserve(this.containerObj)},beforeprintListener:function(t){this.updateContainerDims()},initInfobox:function(t){var e=utils_type.A.copyAttributes(t,this.options,"infobox");return e.id=this.id+"_infobox",this.infobox=this.create("text",[0,0,"0,0"],e),this.infobox.dump=!1,this.displayInfobox(!1),this},updateInfobox:function(t){var e,i,s,r,o,n,a,l=utils_type.A.evaluate(t.visProp.showinfobox);return!utils_type.A.evaluate(this.attr.showinfobox)&&"inherit"===l||!l||utils_type.A.isPoint(t)&&(s=t.coords.usrCoords[1],r=t.coords.usrCoords[2],n=utils_type.A.evaluate(this.infobox.visProp.distancex),a=utils_type.A.evaluate(this.infobox.visProp.distancey),this.infobox.setCoords(s+n/this.unitX,r+a/this.unitY),o=utils_type.A.evaluate(t.visProp.infoboxdigits),"string"!=typeof t.infoboxText?("auto"===o?this.infobox.useLocale()?(e=this.infobox.formatNumberLocale(s),i=this.infobox.formatNumberLocale(r)):(e=utils_type.A.autoDigits(s),i=utils_type.A.autoDigits(r)):utils_type.A.isNumber(o)?this.infobox.useLocale()?(e=this.infobox.formatNumberLocale(s,o),i=this.infobox.formatNumberLocale(r,o)):(e=utils_type.A.toFixed(s,o),i=utils_type.A.toFixed(r,o)):(e=s,i=r),this.highlightInfobox(e,i,t)):this.highlightCustomInfobox(t.infoboxText,t),this.displayInfobox(!0)),this},displayInfobox:function(t){return!t&&this.focusObjects.length>0&&this.select(this.focusObjects[0]).elementClass===constants.A.OBJECT_CLASS_POINT||this.infobox.hiddenByParent===t&&(this.infobox.hiddenByParent=!t,this.infobox.prepareUpdate().updateVisibility(t).updateRenderer()),this},showInfobox:function(t){return this.displayInfobox(t)},highlightInfobox:function(t,e,i){return this.highlightCustomInfobox("("+t+", "+e+")",i),this},highlightCustomInfobox:function(t,e){return this.infobox.setText(t),this},dehighlightAll:function(){var t,e,i={},s=!1;for(t in this.highlightedObjects)this.highlightedObjects.hasOwnProperty(t)&&(e=this.highlightedObjects[t],this.focusObjects.indexOf(t)<0?((this.hasMouseHandlers||this.hasPointerHandlers)&&e.noHighlight(),s=!0):i[t]=e);return this.highlightedObjects=i,"canvas"===this.renderer.type&&s&&(this.prepareUpdate(),this.renderer.suspendRedraw(this),this.updateRenderer(),this.renderer.unsuspendRedraw()),this},getScrCoordsOfMouse:function(t,e){return[t,e]},getUsrCoordsOfMouse:function(t){var e=this.getCoordsTopLeftCorner(),i=env.A.getPosition(t,null,this.document),s=i[0]-e[0],r=i[1]-e[1];return new base_coords.A(constants.A.COORDS_BY_SCREEN,[s,r],this).usrCoords.slice(1)},getAllUnderMouse:function(t){var e=this.getAllObjectsUnderMouse(t);return e.push(this.getUsrCoordsOfMouse(t)),e},getAllObjectsUnderMouse:function(t){var e,i,s=this.getCoordsTopLeftCorner(),r=env.A.getPosition(t,null,this.document),o=r[0]-s[0],n=r[1]-s[1],a=[],l=this.objectsList.length;for(e=0;e<l;e++)(i=this.objectsList[e]).visPropCalc.visible&&i.hasPoint&&i.hasPoint(o,n)&&(a[a.length]=i);return a},updateCoords:function(){var t,e,i=this.objectsList.length;for(e=0;e<i;e++)t=this.objectsList[e],utils_type.A.exists(t.coords)&&(utils_type.A.evaluate(t.visProp.frozen)?t.is3D?t.element2D.coords.screen2usr():t.coords.screen2usr():t.is3D?t.element2D.coords.usr2screen():t.coords.usr2screen());return this},moveOrigin:function(t,e,i){var s,r,o,n;return utils_type.A.exists(t)&&utils_type.A.exists(e)&&(s=this.origin.scrCoords[1],r=this.origin.scrCoords[2],this.origin.scrCoords[1]=t,this.origin.scrCoords[2]=e,i&&(this.origin.scrCoords[1]-=this.drag_dx,this.origin.scrCoords[2]-=this.drag_dy),o=new base_coords.A(constants.A.COORDS_BY_SCREEN,[0,0],this).usrCoords,n=new base_coords.A(constants.A.COORDS_BY_SCREEN,[this.canvasWidth,this.canvasHeight],this).usrCoords,(o[1]<this.maxboundingbox[0]||o[2]>this.maxboundingbox[1]||n[1]>this.maxboundingbox[2]||n[2]<this.maxboundingbox[3])&&(this.origin.scrCoords[1]=s,this.origin.scrCoords[2]=r)),this.updateCoords().clearTraces().fullUpdate(),this.triggerEventHandlers(["boundingbox"]),this},addConditions:function(t){var e,i,s,r,o,n,a,l=[],h=t.indexOf("<data>"),u=t.indexOf("</data>"),c=function(t,e,i,s){return function(){var r,o;o=(r=t.select(e.id)).coords.usrCoords[s],2===s?r.setPositionDirectly(constants.A.COORDS_BY_USER,[i(),o]):r.setPositionDirectly(constants.A.COORDS_BY_USER,[o,i()]),r.prepareUpdate().update()}},d=function(t,e,i){return function(){var s,r;s=t.select(e.id),r=i(),s.setAttribute({visible:r})}},p=function(t,e,i,s){return function(){var r,o;r=t.select(e.id),o=i(),"strokewidth"===s?r.visProp.strokewidth=o:(o=utils_color.A.rgba2rgbo(o),r.visProp[s+"color"]=o[0],r.visProp[s+"opacity"]=o[1])}},_=function(t,e,i){return function(){t.select(e.id).position=i()}},f=function(t,e,i){return function(){t.select(e.id).setStyle(i())}};if(!(h<0)){for(;h>=0;){if(i=(e=t.slice(h+6,u)).indexOf("="),s=e.slice(0,i),r=e.slice(i+1),i=s.indexOf("."),o=s.slice(0,i),n=this.elementsByName[utils_type.A.unescapeHTML(o)],a=s.slice(i+1).replace(/\s+/g,"").toLowerCase(),r=utils_type.A.createFunction(r,this,"",!0),utils_type.A.exists(this.elementsByName[o]))switch(a){case"x":l.push(c(this,n,r,2));break;case"y":l.push(c(this,n,r,1));break;case"visible":l.push(d(this,n,r));break;case"position":l.push(_(this,n,r));break;case"stroke":l.push(p(this,n,r,"stroke"));break;case"style":l.push(f(this,n,r));break;case"strokewidth":l.push(p(this,n,r,"strokewidth"));break;case"fill":l.push(p(this,n,r,"fill"));break;case"label":break;default:jxg.A.debug('property "'+a+'" in conditions not yet implemented:'+r)}else jxg.A.debug("debug conditions: |"+o+"| undefined");h=(t=t.slice(u+7)).indexOf("<data>"),u=t.indexOf("</data>")}this.updateConditions=function(){var t;for(t=0;t<l.length;t++)l[t]();return this.prepareUpdate().updateElements(),!0},this.updateConditions()}},updateConditions:function(){return!1},calculateSnapSizes:function(){var t,e,i,s,r=this.getBoundingBox(),o=utils_type.A.evaluate(this.options.grid.majorStep),n=utils_type.A.evaluate(this.options.grid.gridX),a=utils_type.A.evaluate(this.options.grid.gridY);for(utils_type.A.isArray(o)||(o=[o,o]),o.length<2&&(o=[o[0],o[0]]),utils_type.A.exists(n)&&(o[0]=n),utils_type.A.exists(a)&&(o[1]=a),"auto"===o[0]?o[0]=1:o[0]=utils_type.A.parseNumber(o[0],Math.abs(r[1]-r[3]),1/this.unitX),"auto"===o[1]?o[1]=1:o[1]=utils_type.A.parseNumber(o[1],Math.abs(r[0]-r[2]),1/this.unitY),t=new base_coords.A(constants.A.COORDS_BY_USER,[0,0],this),e=new base_coords.A(constants.A.COORDS_BY_USER,[o[0],o[1]],this),i=t.scrCoords[1]-e.scrCoords[1],s=t.scrCoords[2]-e.scrCoords[2],this.options.grid.snapSizeX=o[0];Math.abs(i)>25;)this.options.grid.snapSizeX*=2,i/=2;for(this.options.grid.snapSizeY=o[1];Math.abs(s)>25;)this.options.grid.snapSizeY*=2,s/=2;return this},applyZoom:function(){return this.updateCoords().calculateSnapSizes().clearTraces().fullUpdate(),this},zoomIn:function(t,e){var i=this.getBoundingBox(),s=this.attr.zoom.factorx,r=this.attr.zoom.factory,o=(i[2]-i[0])*(1-1/s),n=(i[1]-i[3])*(1-1/r),a=.5,l=.5,h=this.attr.zoom.eps||this.attr.zoom.min||.001;return this.zoomX>this.attr.zoom.max&&s>1||this.zoomY>this.attr.zoom.max&&r>1||this.zoomX<h&&s<1||this.zoomY<h&&r<1?this:(utils_type.A.isNumber(t)&&utils_type.A.isNumber(e)&&(a=(t-i[0])/(i[2]-i[0]),l=(i[1]-e)/(i[1]-i[3])),this.setBoundingBox([i[0]+o*a,i[1]-n*l,i[2]-o*(1-a),i[3]+n*(1-l)],this.keepaspectratio,"update"),this.applyZoom())},zoomOut:function(t,e){var i=this.getBoundingBox(),s=this.attr.zoom.factorx,r=this.attr.zoom.factory,o=(i[2]-i[0])*(1-s),n=(i[1]-i[3])*(1-r),a=.5,l=.5,h=this.attr.zoom.eps||this.attr.zoom.min||.001;return this.zoomX<h||this.zoomY<h?this:(utils_type.A.isNumber(t)&&utils_type.A.isNumber(e)&&(a=(t-i[0])/(i[2]-i[0]),l=(i[1]-e)/(i[1]-i[3])),this.setBoundingBox([i[0]+o*a,i[1]-n*l,i[2]-o*(1-a),i[3]+n*(1-l)],this.keepaspectratio,"update"),this.applyZoom())},zoom100:function(){var t,e,i;return utils_type.A.exists(this.attr.boundingbox)?this.setBoundingBox(this.attr.boundingbox,this.keepaspectratio,"reset"):(e=((t=this.getBoundingBox())[2]-t[0])*(1-this.zoomX)*.5,i=(t[1]-t[3])*(1-this.zoomY)*.5,this.setBoundingBox([t[0]+e,t[1]-i,t[2]-e,t[3]+i],this.keepaspectratio,"reset")),this.applyZoom()},zoomAllPoints:function(){var t,e,i,s,r=0,o=0,n=0,a=0,l=this.objectsList.length;for(t=0;t<l;t++)s=this.objectsList[t],utils_type.A.isPoint(s)&&s.visPropCalc.visible&&(s.coords.usrCoords[1]<r?r=s.coords.usrCoords[1]:s.coords.usrCoords[1]>o&&(o=s.coords.usrCoords[1]),s.coords.usrCoords[2]>a?a=s.coords.usrCoords[2]:s.coords.usrCoords[2]<n&&(n=s.coords.usrCoords[2]));return e=50/this.unitX,i=50/this.unitY,this.setBoundingBox([r-e,a+i,o+e,n-i],this.keepaspectratio,"update"),this.applyZoom()},zoomElements:function(t){var e,i,s,r,o,n,a,l=[1/0,-1/0,-1/0,1/0];if(!utils_type.A.isArray(t)||0===t.length)return this;for(e=0;e<t.length;e++)i=this.select(t[e]).bounds(),utils_type.A.isArray(i)&&(i[0]<l[0]&&(l[0]=i[0]),i[1]>l[1]&&(l[1]=i[1]),i[2]>l[2]&&(l[2]=i[2]),i[3]<l[3]&&(l[3]=i[3]));return utils_type.A.isArray(l)&&(s=.5*(l[0]+l[2]),r=.5*(l[1]+l[3]),o=1.5*(l[2]-l[0])*.5,n=1.5*(l[1]-l[3])*.5,a=Math.max(o,n),this.setBoundingBox([s-a,r+a,s+a,r-a],this.keepaspectratio,"update")),this},setZoom:function(t,e){var i=this.attr.zoom.factorx,s=this.attr.zoom.factory;return this.attr.zoom.factorx=t/this.zoomX,this.attr.zoom.factory=e/this.zoomY,this.zoomIn(),this.attr.zoom.factorx=i,this.attr.zoom.factory=s,this},_removeObj:function(t,e){var i,s;if(utils_type.A.isArray(t)){for(s=0;s<t.length;s++)this._removeObj(t[s],e);return this}if(t=this.select(t),!utils_type.A.exists(t)||utils_type.A.isString(t))return this;try{for(i in t.childElements)t.childElements.hasOwnProperty(i)&&t.childElements[i].board._removeObj(t.childElements[i]);for(i in t.objects)t.objects.hasOwnProperty(i)&&t.objects[i].board._removeObj(t.objects[i]);if(e)for(i in this.objects)this.objects.hasOwnProperty(i)&&utils_type.A.exists(this.objects[i].childElements)&&utils_type.A.exists(this.objects[i].childElements.hasOwnProperty(t.id))&&(delete this.objects[i].childElements[t.id],delete this.objects[i].descendants[t.id]);else if(utils_type.A.exists(t.ancestors))for(i in t.ancestors)t.ancestors.hasOwnProperty(i)&&utils_type.A.exists(t.ancestors[i].childElements)&&utils_type.A.exists(t.ancestors[i].childElements.hasOwnProperty(t.id))&&(delete t.ancestors[i].childElements[t.id],delete t.ancestors[i].descendants[t.id]);if(t._pos>-1)for(this.objectsList.splice(t._pos,1),s=t._pos;s<this.objectsList.length;s++)this.objectsList[s]._pos--;else t.type!==constants.A.OBJECT_TYPE_TURTLE&&jxg.A.debug("Board.removeObject: object "+t.id+" not found in list.");delete this.objects[t.id],delete this.elementsByName[t.name],t.visProp&&utils_type.A.evaluate(t.visProp.trace)&&t.clearTrace(),utils_type.A.exists(t.remove)&&t.remove()}catch(e){jxg.A.debug(t.id+": Could not be removed: "+e)}return this},removeObject:function(t,e){var i;if(this.renderer.suspendRedraw(this),utils_type.A.isArray(t))for(i=0;i<t.length;i++)this._removeObj(t[i],e);else this._removeObj(t,e);return this.renderer.unsuspendRedraw(),this.update(),this},removeAncestors:function(t){var e;for(e in t.ancestors)t.ancestors.hasOwnProperty(e)&&this.removeAncestors(t.ancestors[e]);return this.removeObject(t),this},initGeonextBoard:function(){var t,e,i;return t=this.create("point",[0,0],{id:this.id+"g00e0",name:"Ursprung",withLabel:!1,visible:!1,fixed:!0}),e=this.create("point",[1,0],{id:this.id+"gX0e0",name:"Punkt_1_0",withLabel:!1,visible:!1,fixed:!0}),i=this.create("point",[0,1],{id:this.id+"gY0e0",name:"Punkt_0_1",withLabel:!1,visible:!1,fixed:!0}),this.create("line",[t,e],{id:this.id+"gXLe0",name:"X-Achse",withLabel:!1,visible:!1}),this.create("line",[t,i],{id:this.id+"gYLe0",name:"Y-Achse",withLabel:!1,visible:!1}),this},resizeContainer:function(t,e,i,s){var r,o,n,a,l;return o=this.canvasWidth,n=this.canvasHeight,s||(r=this.getBoundingBox()),this.canvasWidth=Math.max(parseFloat(t),math.A.eps),this.canvasHeight=Math.max(parseFloat(e),math.A.eps),i||(this.containerObj.style.width=this.canvasWidth+"px",this.containerObj.style.height=this.canvasHeight+"px"),this.renderer.resize(this.canvasWidth,this.canvasHeight),s?(a=(this.canvasWidth-o)/2,l=(this.canvasHeight-n)/2,this.moveOrigin(this.origin.scrCoords[1]+a,this.origin.scrCoords[2]+l)):this.setBoundingBox(r,this.keepaspectratio,"keep"),this},showDependencies:function(){var t,e,i,s,r;for(t in e="<p>\n",this.objects)if(this.objects.hasOwnProperty(t)){for(i in r=0,this.objects[t].childElements)this.objects[t].childElements.hasOwnProperty(i)&&(r+=1);for(i in r>=0&&(e+="<strong>"+this.objects[t].id+":</strong> "),this.objects[t].childElements)this.objects[t].childElements.hasOwnProperty(i)&&(e+=this.objects[t].childElements[i].id+"("+this.objects[t].childElements[i].name+"), ");e+="<p>\n"}return e+="</p>\n",(s=window.open()).document.open(),s.document.write(e),s.document.close(),this},showXML:function(){var t=window.open("");return t.document.open(),t.document.write("<pre>"+utils_type.A.escapeHTML(this.xmlString)+"</pre>"),t.document.close(),this},prepareUpdate:function(){var t,e,i=this.objectsList.length;for(t=0;t<i;t++)(e=this.objectsList[t]).needsUpdate=e.needsRegularUpdate||this.needsFullUpdate;for(t in this.groups)this.groups.hasOwnProperty(t)&&((e=this.groups[t]).needsUpdate=e.needsRegularUpdate||this.needsFullUpdate);return this},updateElements:function(t){var e,i;for(t=this.select(t),e=0;e<this.objectsList.length;e++)i=this.objectsList[e],this.needsFullUpdate&&i.elementClass===constants.A.OBJECT_CLASS_TEXT&&i.updateSize(),i.update(!utils_type.A.exists(t)||i.id!==t.id).updateVisibility();for(e in this.groups)this.groups.hasOwnProperty(e)&&this.groups[e].update(t);return this},updateRenderer:function(){var t,e=this.objectsList.length;if(this.renderer){if("canvas"===this.renderer.type)this.updateRendererCanvas();else for(t=0;t<e;t++)this.objectsList[t].updateRenderer();return this}},updateRendererCanvas:function(){var t,e,i,s,r,o=this.objectsList.length,n=this.options.layer,a=this.options.layer.numlayers,l=Number.NEGATIVE_INFINITY;for(i=0;i<a;i++){for(r in s=Number.POSITIVE_INFINITY,n)n.hasOwnProperty(r)&&n[r]>l&&n[r]<s&&(s=n[r]);for(l=s,t=0;t<o;t++)(e=this.objectsList[t]).visProp.layer===s&&e.prepareUpdate().updateRenderer()}return this},addHook:function(t,e,i){return jxg.A.deprecated("Board.addHook()","Board.on()"),e=utils_type.A.def(e,"update"),i=utils_type.A.def(i,this),this.hooks.push([e,t]),this.on(e,t,i),this.hooks.length-1},addEvent:jxg.A.shortcut(jxg.A.Board.prototype,"on"),removeHook:function(t){return jxg.A.deprecated("Board.removeHook()","Board.off()"),this.hooks[t]&&(this.off(this.hooks[t][0],this.hooks[t][1]),this.hooks[t]=null),this},removeEvent:jxg.A.shortcut(jxg.A.Board.prototype,"off"),updateHooks:function(t){var e=Array.prototype.slice.call(arguments,0);return jxg.A.deprecated("Board.updateHooks()","Board.triggerEventHandlers()"),e[0]=utils_type.A.def(e[0],"update"),this.triggerEventHandlers([e[0]],arguments),this},addChild:function(t){return utils_type.A.exists(t)&&utils_type.A.exists(t.containerObj)&&(this.dependentBoards.push(t),this.update()),this},removeChild:function(t){var e;for(e=this.dependentBoards.length-1;e>=0;e--)this.dependentBoards[e]===t&&this.dependentBoards.splice(e,1);return this},update:function(t){var e,i,s,r,o;if(this.inUpdate||this.isSuspendedUpdate)return this;for(this.inUpdate=!0,"all"===this.attr.minimizereflow&&this.containerObj&&"vml"!==this.renderer.type&&(o=this.document.activeElement,r=this.renderer.removeToInsertLater(this.containerObj)),"svg"===this.attr.minimizereflow&&"svg"===this.renderer.type&&(o=this.document.activeElement,r=this.renderer.removeToInsertLater(this.renderer.svgRoot)),this.prepareUpdate().updateElements(t).updateConditions(),this.renderer.suspendRedraw(this),this.updateRenderer(),this.renderer.unsuspendRedraw(),this.triggerEventHandlers(["update"],[]),r&&(r(),o.focus()),i=this.dependentBoards.length,e=0;e<i;e++)s=this.dependentBoards[e],utils_type.A.exists(s)&&s!==this&&(s.updateQuality=this.updateQuality,s.prepareUpdate().updateElements().updateConditions(),s.renderer.suspendRedraw(this),s.updateRenderer(),s.renderer.unsuspendRedraw(),s.triggerEventHandlers(["update"],[]));return this.inUpdate=!1,this},fullUpdate:function(){return this.needsFullUpdate=!0,this.update(),this.needsFullUpdate=!1,this},addGrid:function(){return this.create("grid",[]),this},removeGrids:function(){var t;for(t=0;t<this.grids.length;t++)this.removeObject(this.grids[t]);return this.grids.length=0,this.update(),this},create:function(t,e,i){var s,r;for(t=t.toLowerCase(),utils_type.A.exists(e)||(e=[]),utils_type.A.exists(i)||(i={}),r=0;r<e.length;r++)!utils_type.A.isString(e[r])||"text"===t&&2===r||"solidofrevolution3d"===t&&2===r||!("input"!==t&&"checkbox"!==t&&"button"!==t||2!==r&&3!==r)||"curve"===t||"functiongraph"===t||"implicitcurve"===t||(e[r]=this.select(e[r]));if(!utils_type.A.isFunction(jxg.A.elements[t]))throw new Error("JSXGraph: create: Unknown element type given: "+t);return s=jxg.A.elements[t](this,e,i),utils_type.A.exists(s)?(s.prepareUpdate&&s.update&&s.updateRenderer&&s.fullUpdate(),s):(jxg.A.debug("JSXGraph: create: failure creating "+t),s)},createElement:function(){return jxg.A.deprecated("Board.createElement()","Board.create()"),this.create.apply(this,arguments)},clearTraces:function(){var t;for(t=0;t<this.objectsList.length;t++)this.objectsList[t].clearTrace();return this.numTraces=0,this},suspendUpdate:function(){return this.inUpdate||(this.isSuspendedUpdate=!0),this},unsuspendUpdate:function(){return this.isSuspendedUpdate&&(this.isSuspendedUpdate=!1,this.fullUpdate()),this},setBoundingBox:function(t,e,i){var s,r,o,n,a,l,h,u,c,d=0,p=0,_=1,f=env.A.getDimensions(this.container,this.document);return utils_type.A.isArray(t)?(t[0]<this.maxboundingbox[0]||t[1]>this.maxboundingbox[1]||t[2]>this.maxboundingbox[2]||t[3]<this.maxboundingbox[3]||(utils_type.A.exists(i)||(i="reset"),o=this.unitX,n=this.unitY,this.canvasWidth=parseFloat(f.width),this.canvasHeight=parseFloat(f.height),r=this.canvasWidth,s=this.canvasHeight,e?(a=this.keepaspectratio?o/n:1,"keep"===i&&(_=this.zoomX/this.zoomY),u=o*(l=t[2]-t[0]),c=n*(h=t[1]-t[3]),r>=s?u>=c?(this.unitY=s/h,this.unitX=this.unitY*a):(this.unitY=s/Math.abs(l)*math.A.sign(h)/_,this.unitX=this.unitY*a):c>u?(this.unitX=r/l,this.unitY=this.unitX/a):(this.unitX=r/Math.abs(h)*math.A.sign(l)*_,this.unitY=this.unitX/a),d=.5*(r/this.unitX-l),p=.5*(s/this.unitY-h),this.keepaspectratio=!0):(this.unitX=r/(t[2]-t[0]),this.unitY=s/(t[1]-t[3]),this.keepaspectratio=!1),this.moveOrigin(-this.unitX*(t[0]-d),this.unitY*(t[1]+p)),"update"===i?(this.zoomX*=this.unitX/o,this.zoomY*=this.unitY/n):"reset"===i&&(this.zoomX=utils_type.A.exists(this.attr.zoomx)?this.attr.zoomx:1,this.zoomY=utils_type.A.exists(this.attr.zoomy)?this.attr.zoomy:1)),this):this},getBoundingBox:function(){var t=new base_coords.A(constants.A.COORDS_BY_SCREEN,[0,0],this).usrCoords,e=new base_coords.A(constants.A.COORDS_BY_SCREEN,[this.canvasWidth,this.canvasHeight],this).usrCoords;return[t[1],t[2],e[1],e[2]]},_set:function(t,e){t=t.toLocaleLowerCase(),null===e||!utils_type.A.isObject(e)||utils_type.A.exists(e.id)||utils_type.A.exists(e.name)?this.attr[t]=e:utils_type.A.mergeAttr(this.attr[t],e)},setAttribute:function(t){var e,i,s,r,o,n,a={};for(e=0;e<arguments.length;e++)i=arguments[e],utils_type.A.isString(i)?(s=i.split(":"),a[utils_type.A.trim(s[0])]=utils_type.A.trim(s[1])):utils_type.A.isArray(i)?a[i[0]]=i[1]:jxg.A.extend(a,i);for(e in a)if(a.hasOwnProperty(e)&&(r=e.replace(/\s+/g,"").toLowerCase(),o=a[e]),o=(!o.toLowerCase||"false"!==o.toLowerCase())&&o,this.attr[r]!==o)switch(r){case"axis":!1===o&&utils_type.A.exists(this.defaultAxes)&&(this.defaultAxes.x.setAttribute({visible:!1}),this.defaultAxes.y.setAttribute({visible:!1}));break;case"boundingbox":this.setBoundingBox(o,this.keepaspectratio),this._set(r,o);break;case"defaultaxes":utils_type.A.exists(this.defaultAxes.x)&&utils_type.A.exists(o.x)&&this.defaultAxes.x.setAttribute(o.x),utils_type.A.exists(this.defaultAxes.y)&&utils_type.A.exists(o.y)&&this.defaultAxes.y.setAttribute(o.y);break;case"description":this.document.getElementById(this.container+"_ARIAdescription").innerHTML=o,this._set(r,o);break;case"title":this.document.getElementById(this.container+"_ARIAlabel").innerHTML=o,this._set(r,o);break;case"keepaspectratio":this._set(r,o),this.setBoundingBox(this.getBoundingBox(),o,"keep");break;case"document":case"maxboundingbox":this[r]=o,this._set(r,o);break;case"zoomx":case"zoomy":this[r]=o,this._set(r,o),this.setZoom(this.attr.zoomx,this.attr.zoomy);break;case"registerevents":case"renderer":break;case"fullscreen":case"screenshot":(n=this.containerObj.ownerDocument.getElementById(this.container+"_navigation_"+r))&&utils_type.A.exists(o.symbol)&&(n.innerHTML=utils_type.A.evaluate(o.symbol)),this._set(r,o);break;case"selection":o.visible=!1,o.withLines=!1,o.vertices={visible:!1},this._set(r,o);break;case"showcopyright":"svg"===this.renderer.type&&((n=this.containerObj.ownerDocument.getElementById(this.renderer.uniqName("licenseText")))?n.style.display=utils_type.A.evaluate(o)?"inline":"none":utils_type.A.evaluate(o)&&this.renderer.displayCopyright(constants.A.licenseText,parseInt(this.options.text.fontSize,10)));default:utils_type.A.exists(this.attr[r])&&this._set(r,o)}return this.containerObj.ownerDocument.getElementById(this.container+"_navigationbar").remove(),this.renderer.drawNavigationBar(this,this.attr.navbar),this.triggerEventHandlers(["attribute"],[a,this]),this.fullUpdate(),this},addAnimation:function(t){var e=this;return this.animationObjects[t.id]=t,this.animationIntervalCode||(this.animationIntervalCode=window.setInterval((function(){e.animate()}),t.board.attr.animationdelay)),this},stopAllAnimation:function(){var t;for(t in this.animationObjects)this.animationObjects.hasOwnProperty(t)&&utils_type.A.exists(this.animationObjects[t])&&(this.animationObjects[t]=null,delete this.animationObjects[t]);return window.clearInterval(this.animationIntervalCode),delete this.animationIntervalCode,this},animate:function(){var t,e,i,s,r,o,n,a,l=0,h=null;for(e in this.animationObjects)if(this.animationObjects.hasOwnProperty(e)&&utils_type.A.exists(this.animationObjects[e])){if(l+=1,(i=this.animationObjects[e]).animationPath&&(s=utils_type.A.isFunction(i.animationPath)?i.animationPath((new Date).getTime()-i.animationStart):i.animationPath.pop(),!utils_type.A.exists(s)||!utils_type.A.isArray(s)&&isNaN(s)?delete i.animationPath:(i.setPositionDirectly(constants.A.COORDS_BY_USER,s),i.fullUpdate(),h=i)),i.animationData){for(r in n=0,i.animationData)i.animationData.hasOwnProperty(r)&&(o=i.animationData[r].pop(),utils_type.A.exists(o)?(n+=1,(t={})[r]=o,i.setAttribute(t)):delete i.animationData[o]);0===n&&delete i.animationData}utils_type.A.exists(i.animationData)||utils_type.A.exists(i.animationPath)||(this.animationObjects[e]=null,delete this.animationObjects[e],utils_type.A.exists(i.animationCallback)&&(a=i.animationCallback,i.animationCallback=null,a()))}return 0===l?(window.clearInterval(this.animationIntervalCode),delete this.animationIntervalCode):this.update(h),this},migratePoint:function(t,e,i){var s,r,o,n,a,l,h=!1;for(r in t=this.select(t),e=this.select(e),utils_type.A.exists(t.label)&&(l=t.label.id,h=!0,this.removeObject(t.label)),t.childElements)if(t.childElements.hasOwnProperty(r)){for(o in n=!1,s=t.childElements[r])s.hasOwnProperty(o)&&s[o]===t&&(s[o]=e,n=!0);for(n&&delete t.childElements[r],a=0;a<s.parents.length;a++)s.parents[a]===t.id&&(s.parents[a]=e.id);e.addChild(s)}return i&&(h&&(delete e.childElements[l],delete e.descendants[l]),e.label&&this.removeObject(e.label),delete this.elementsByName[e.name],e.name=t.name,h&&e.createLabel()),this.removeObject(t),utils_type.A.exists(e.name)&&""!==e.name&&(this.elementsByName[e.name]=e),this.fullUpdate(),this},emulateColorblindness:function(t){var e,i;if(utils_type.A.exists(t)||(t="none"),this.currentCBDef===t)return this;for(e in this.objects)this.objects.hasOwnProperty(e)&&(i=this.objects[e],"none"!==t?("none"===this.currentCBDef&&(i.visPropOriginal={strokecolor:i.visProp.strokecolor,fillcolor:i.visProp.fillcolor,highlightstrokecolor:i.visProp.highlightstrokecolor,highlightfillcolor:i.visProp.highlightfillcolor}),i.setAttribute({strokecolor:utils_color.A.rgb2cb(utils_type.A.evaluate(i.visPropOriginal.strokecolor),t),fillcolor:utils_color.A.rgb2cb(utils_type.A.evaluate(i.visPropOriginal.fillcolor),t),highlightstrokecolor:utils_color.A.rgb2cb(utils_type.A.evaluate(i.visPropOriginal.highlightstrokecolor),t),highlightfillcolor:utils_color.A.rgb2cb(utils_type.A.evaluate(i.visPropOriginal.highlightfillcolor),t)})):utils_type.A.exists(i.visPropOriginal)&&jxg.A.extend(i.visProp,i.visPropOriginal));return this.currentCBDef=t,this.update(),this},select:function(t,e){var i,s,r,o,n=t;if(null===n)return n;if(utils_type.A.isString(n)&&""!==n)utils_type.A.exists(this.objects[n])?n=this.objects[n]:utils_type.A.exists(this.elementsByName[n])?n=this.elementsByName[n]:utils_type.A.exists(this.groups[n])&&(n=this.groups[n]);else if(!e&&(utils_type.A.isFunction(n)||utils_type.A.isObject(n)&&!utils_type.A.isFunction(n.setAttribute))){for(s={},o=(i=utils_type.A.filterElements(this.objectsList,n)).length,r=0;r<o;r++)s[i[r].id]=i[r];n=new composition(s)}else utils_type.A.isObject(n)&&utils_type.A.exists(n.id)&&!utils_type.A.exists(this.objects[n.id])&&(n=null);return n},hasPoint:function(t,e){var i=t,s=e,r=this.getBoundingBox();return utils_type.A.exists(t)&&utils_type.A.isArray(t.usrCoords)&&(i=t.usrCoords[1],s=t.usrCoords[2]),!!(utils_type.A.isNumber(i)&&utils_type.A.isNumber(s)&&r[0]<i&&i<r[2]&&r[1]>s&&s>r[3])},updateCSSTransforms:function(){var t=this.containerObj,e=t,i=t;if(this.cssTransMat=env.A.getCSSTransformMatrix(e),utils_type.A.exists(e.getRootNode)){for(e=e.parentNode===e.getRootNode()?e.parentNode.host:e.parentNode;e;)this.cssTransMat=math.A.matMatMult(env.A.getCSSTransformMatrix(e),this.cssTransMat),e=e.parentNode===e.getRootNode()?e.parentNode.host:e.parentNode;this.cssTransMat=math.A.inverse(this.cssTransMat)}else{for(e=e.offsetParent;e;){for(this.cssTransMat=math.A.matMatMult(env.A.getCSSTransformMatrix(e),this.cssTransMat),i=i.parentNode;i!==e;)this.cssTransMat=math.A.matMatMult(env.A.getCSSTransformMatrix(e),this.cssTransMat),i=i.parentNode;e=e.offsetParent}this.cssTransMat=math.A.inverse(this.cssTransMat)}return this},startSelectionMode:function(){this.selectingMode=!0,this.selectionPolygon.setAttribute({visible:!0}),this.selectingBox=[[0,0],[0,0]],this._setSelectionPolygonFromBox(),this.selectionPolygon.fullUpdate()},stopSelectionMode:function(){return this.selectingMode=!1,this.selectionPolygon.setAttribute({visible:!1}),[this.selectionPolygon.vertices[0].coords,this.selectionPolygon.vertices[2].coords]},_startSelecting:function(t){this.isSelecting=!0,this.selectingBox=[[t[0],t[1]],[t[0],t[1]]],this._setSelectionPolygonFromBox()},_moveSelecting:function(t){this.isSelecting&&(this.selectingBox[1]=[t[0],t[1]],this._setSelectionPolygonFromBox(),this.selectionPolygon.fullUpdate())},_stopSelecting:function(t){var e=this.getMousePosition(t);this.isSelecting=!1,this.selectingBox[1]=[e[0],e[1]],this._setSelectionPolygonFromBox()},_setSelectionPolygonFromBox:function(){var t=this.selectingBox[0],e=this.selectingBox[1];this.selectionPolygon.vertices[0].setPositionDirectly(jxg.A.COORDS_BY_SCREEN,[t[0],t[1]]),this.selectionPolygon.vertices[1].setPositionDirectly(jxg.A.COORDS_BY_SCREEN,[t[0],e[1]]),this.selectionPolygon.vertices[2].setPositionDirectly(jxg.A.COORDS_BY_SCREEN,[e[0],e[1]]),this.selectionPolygon.vertices[3].setPositionDirectly(jxg.A.COORDS_BY_SCREEN,[e[0],t[1]])},_testForSelection:function(t){this._isRequiredKeyPressed(t,"selection")&&(utils_type.A.exists(this.selectionPolygon)||this._createSelectionPolygon(this.attr),this.startSelectionMode())},_createSelectionPolygon:function(t){var e;return utils_type.A.exists(this.selectionPolygon)||!0===(e=utils_type.A.copyAttributes(t,src_options.A,"board","selection")).enabled&&(this.selectionPolygon=this.create("polygon",[[0,0],[0,0],[0,0],[0,0]],e)),this},__evt__attribute:function(t){},__evt__down:function(t){},__evt__mousedown:function(t){},__evt__pendown:function(t){},__evt__pointerdown:function(t){},__evt__touchstart:function(t){},__evt__up:function(t){},__evt__mouseup:function(t){},__evt__pointerup:function(t){},__evt__touchend:function(t){},__evt__click:function(t){},__evt__dblclick:function(t){},__evt__mouseclick:function(t){},__evt__mousedblclick:function(t){},__evt__pointerclick:function(t){},__evt__pointerdblclick:function(t){},__evt__move:function(t,e){},__evt__mousemove:function(t,e){},__evt__penmove:function(t,e){},__evt__pointermove:function(t,e){},__evt__touchmove:function(t,e){},__evt__keymove:function(t,e){},__evt__hit:function(t,e,i){},__evt__mousehit:function(t,e,i){},__evt__update:function(){},__evt__boundingbox:function(){},__evt__startselecting:function(){},__evt__mousestartselecting:function(){},__evt__pointerstartselecting:function(){},__evt__touchstartselecting:function(){},__evt__stopselecting:function(){},__evt__mousestopselecting:function(){},__evt__pointerstopselecting:function(){},__evt__touchstopselecting:function(){},__evt__moveselecting:function(){},__evt__mousemoveselecting:function(){},__evt__pointermoveselecting:function(){},__evt__touchmoveselecting:function(){},__evt:function(){},toFullscreen:function(t){var e,i,s,r,o=this.document;return t=t||this.container,this._fullscreen_inner_id=t,s=o.getElementById(t),e="fullscreenwrap_"+t,utils_type.A.exists(s._cssFullscreenStore)||(r=this.containerObj.getBoundingClientRect(),s._cssFullscreenStore={w:r.width,h:r.height}),o.getElementById(e)?i=o.getElementById(e):((i=document.createElement("div")).classList.add("JXG_wrap_private"),i.setAttribute("id",e),s.parentNode.insertBefore(i,s),i.appendChild(s)),i.requestFullscreen=i.requestFullscreen||i.webkitRequestFullscreen||i.mozRequestFullScreen||i.msRequestFullscreen,null===(void 0!==o.fullscreenElement?o.fullscreenElement:void 0!==o.webkitFullscreenElement?o.webkitFullscreenElement:o.msFullscreenElement)?i.requestFullscreen&&(i.requestFullscreen(),this.startFullscreenResizeObserver(i)):(this.stopFullscreenResizeObserver(i),utils_type.A.exists(document.exitFullscreen)?document.exitFullscreen():utils_type.A.exists(document.webkitExitFullscreen)&&document.webkitExitFullscreen()),this},fullscreenListener:function(t){var e,i,s,r=this.document;e=this._fullscreen_inner_id,utils_type.A.exists(e)&&(s=void 0!==r.fullscreenElement?r.fullscreenElement:void 0!==r.webkitFullscreenElement?r.webkitFullscreenElement:r.msFullscreenElement,i=r.getElementById(e),s?(i._cssFullscreenStore.id=s.id,i._cssFullscreenStore.isFullscreen=!0,i._cssFullscreenStore.margin=i.style.margin,i._cssFullscreenStore.width=i.style.width,i._cssFullscreenStore.height=i.style.height,i._cssFullscreenStore.transform=i.style.transform,i.style.width=i._cssFullscreenStore.w+"px",i.style.height=i._cssFullscreenStore.h+"px",i.style.margin="",env.A.scaleJSXGraphDiv(s.id,e,r,utils_type.A.evaluate(this.attr.fullscreen.scale)),s=null):utils_type.A.exists(i._cssFullscreenStore)&&(i._cssFullscreenStore.isFullscreen=!1,i.style.margin=i._cssFullscreenStore.margin,i.style.width=i._cssFullscreenStore.width,i.style.height=i._cssFullscreenStore.height,i.style.transform=i._cssFullscreenStore.transform,i._cssFullscreenStore=null,i.parentElement.replaceWith(i)),this.updateCSSTransforms())},startFullscreenResizeObserver:function(t){var e=this;return env.A.isBrowser&&this.attr.resize&&this.attr.resize.enabled?(this.resizeObserver=new ResizeObserver((function(i){var s,r,o=e.document;e._isResizing||(e._isResizing=!0,window.setTimeout((function(){try{s=e._fullscreen_inner_id,null!==(r=void 0!==o.fullscreenElement?o.fullscreenElement:void 0!==o.webkitFullscreenElement?o.webkitFullscreenElement:o.msFullscreenElement)&&env.A.scaleJSXGraphDiv(r.id,s,o,utils_type.A.evaluate(e.attr.fullscreen.scale))}catch(i){e.stopFullscreenResizeObserver(t)}finally{e._isResizing=!1}}),e.attr.resize.throttle))})),this.resizeObserver.observe(t),this):this},stopFullscreenResizeObserver:function(t){return env.A.isBrowser&&this.attr.resize&&this.attr.resize.enabled?(utils_type.A.exists(this.resizeObserver)&&this.resizeObserver.unobserve(t),this):this},addLogEntry:function(t,e,i){var s,r,o=this.userLog.length-1;return utils_type.A.exists(e.elementClass)&&(r=e.id),utils_type.A.evaluate(this.attr.logging.enabled)&&(s=(new Date).getTime(),o>=0&&this.userLog[o].type===t&&this.userLog[o].id===r&&s-this.userLog[o].end<500?(this.userLog[o].end=s,this.userLog[o].endpos=i):this.userLog.push({type:t,id:r,start:s,startpos:i,end:s,endpos:i,bbox:this.getBoundingBox(),canvas:[this.canvasWidth,this.canvasHeight],zoom:[this.zoomX,this.zoomY]})),this},createRoulette:function(t,e,i,s,r,o,n){var a=this;return new function(){var l,h=0,u=0,c=0,d=i,p=numerics.A.root((function(i){var s=t.X(d),r=t.Y(d),o=e.X(i),n=e.Y(i);return(s-o)*(s-o)+(r-n)*(r-n)}),[0,2*Math.PI]),_=0,f=0,A=a.create("transform",[function(){return h}],{type:"rotate"}),g=a.create("transform",[function(){return h},function(){return t.X(d)},function(){return t.Y(d)}],{type:"rotate"}),m=a.create("transform",[function(){return u},function(){return c}],{type:"translate"}),y=function(t,e,i){var s=numerics.A.D(t.X)(e),r=numerics.A.D(t.Y)(e),o=numerics.A.D(t.X)(i),n=numerics.A.D(t.Y)(i),a=numerics.A.D(t.X)(.5*(e+i)),l=numerics.A.D(t.Y)(.5*(e+i)),h=math.A.hypot(s,r),u=math.A.hypot(o,n);return(h+4*math.A.hypot(a,l)+u)*(i-e)/6},b=function(t){return l-y(e,p,t)},v=Math.PI/18,C=9*v,P=null;return this.rolling=function(){var i,o,P,x,E;l=y(t,d,_=d+r*s),f=numerics.A.root(b,p),i=new complex(t.X(_),t.Y(_)),o=new complex(e.X(f),e.Y(f)),P=new complex(numerics.A.D(t.X)(_),numerics.A.D(t.Y)(_)),x=new complex(numerics.A.D(e.X)(f),numerics.A.D(e.Y)(f)),E=complex.C.div(P,x),h=Math.atan2(E.imaginary,E.real),E.div(complex.C.abs(E)),E.mult(o),u=i.real-E.real,c=i.imaginary-E.imaginary,h<-v&&h>-C?(h=-v,g.applyOnce(n)):h>v&&h<C?(h=v,g.applyOnce(n)):(A.applyOnce(n),m.applyOnce(n),d=_,p=f),a.update()},this.start=function(){return o>0&&(P=window.setInterval(this.rolling,o)),this},this.stop=function(){return window.clearInterval(P),this},this}}});var base_board=jxg.A.Board;jxg.A.SVGRenderer=function(t,e){var i;for(this.type="svg",this.isIE=-1!==navigator.appVersion.indexOf("MSIE")||navigator.userAgent.match(/Trident\//),this.svgRoot=null,this.svgNamespace="http://www.w3.org/2000/svg",this.xlinkNamespace="http://www.w3.org/1999/xlink",this.container=t,this.container.style.MozUserSelect="none",this.container.style.userSelect="none",this.container.style.overflow="hidden",""===this.container.style.position&&(this.container.style.position="relative"),this.svgRoot=this.container.ownerDocument.createElementNS(this.svgNamespace,"svg"),this.svgRoot.style.overflow="hidden",this.svgRoot.style.display="block",this.resize(e.width,e.height),this.container.appendChild(this.svgRoot),this.defs=this.container.ownerDocument.createElementNS(this.svgNamespace,"defs"),this.svgRoot.appendChild(this.defs),this.createShadowFilter=function(t,e,i,s,r,o){var n,a,l,h,u,c=this.container.ownerDocument.createElementNS(this.svgNamespace,"filter");return c.setAttributeNS(null,"id",t),c.setAttributeNS(null,"width","300%"),c.setAttributeNS(null,"height","300%"),c.setAttributeNS(null,"filterUnits","userSpaceOnUse"),(n=this.container.ownerDocument.createElementNS(this.svgNamespace,"feOffset")).setAttributeNS(null,"in","SourceGraphic"),n.setAttributeNS(null,"result","offOut"),n.setAttributeNS(null,"dx",o[0]),n.setAttributeNS(null,"dy",o[1]),c.appendChild(n),(a=this.container.ownerDocument.createElementNS(this.svgNamespace,"feColorMatrix")).setAttributeNS(null,"in","offOut"),a.setAttributeNS(null,"result","colorOut"),a.setAttributeNS(null,"type","matrix"),"none"===e||!utils_type.A.isArray(e)||e.length<3?a.setAttributeNS(null,"values","0.1 0 0 0 0  0 0.1 0 0 0  0 0 0.1 0 0  0 0 0 "+i+" 0"):(e[0]/=255,e[1]/=255,e[2]/=255,u=s+" 0 0 0 "+e[0]+"  0 "+s+" 0 0 "+e[1]+"  0 0 "+s+" 0 "+e[2]+"  0 0 0 "+i+" 0",a.setAttributeNS(null,"values",u)),c.appendChild(a),(l=this.container.ownerDocument.createElementNS(this.svgNamespace,"feGaussianBlur")).setAttributeNS(null,"in","colorOut"),l.setAttributeNS(null,"result","blurOut"),l.setAttributeNS(null,"stdDeviation",r),c.appendChild(l),(h=this.container.ownerDocument.createElementNS(this.svgNamespace,"feBlend")).setAttributeNS(null,"in","SourceGraphic"),h.setAttributeNS(null,"in2","blurOut"),h.setAttributeNS(null,"mode","normal"),c.appendChild(h),c},this.uniqName=function(){return this.container.id+"_"+Array.prototype.slice.call(arguments).join("_")},this.toStr=function(){var t=Array.prototype.slice.call(arguments).join("");return utils_type.A.exists(CSS)&&utils_type.A.exists(CSS.escape)&&(t=CSS.escape(t)),t},this.toURL=function(){return"url(#"+this.toStr.apply(this,arguments)+")"},this.defs.appendChild(this.createShadowFilter(this.uniqName("f1"),"none",1,.1,3,[5,5])),this.layer=[],i=0;i<src_options.A.layer.numlayers;i++)this.layer[i]=this.container.ownerDocument.createElementNS(this.svgNamespace,"g"),this.svgRoot.appendChild(this.layer[i]);try{this.foreignObjLayer=this.container.ownerDocument.createElementNS(this.svgNamespace,"foreignObject"),this.foreignObjLayer.setAttribute("display","none"),this.foreignObjLayer.setAttribute("x",0),this.foreignObjLayer.setAttribute("y",0),this.foreignObjLayer.setAttribute("width","100%"),this.foreignObjLayer.setAttribute("height","100%"),this.foreignObjLayer.setAttribute("id",this.uniqName("foreignObj")),this.svgRoot.appendChild(this.foreignObjLayer),this.supportsForeignObject=!0}catch(t){this.supportsForeignObject=!1}},jxg.A.SVGRenderer.prototype=new renderer_abstract,jxg.A.extend(jxg.A.SVGRenderer.prototype,{_createArrowHead:function(t,e,i){var s,r,o,n,a=t.id+"Triangle";return utils_type.A.exists(e)&&(a+=e),utils_type.A.exists(i)&&(a+=i),(s=this.createPrim("marker",a)).setAttributeNS(null,"stroke",utils_type.A.evaluate(t.visProp.strokecolor)),s.setAttributeNS(null,"stroke-opacity",utils_type.A.evaluate(t.visProp.strokeopacity)),s.setAttributeNS(null,"fill",utils_type.A.evaluate(t.visProp.strokecolor)),s.setAttributeNS(null,"fill-opacity",utils_type.A.evaluate(t.visProp.strokeopacity)),s.setAttributeNS(null,"stroke-width",0),s.setAttributeNS(null,"orient","auto"),s.setAttributeNS(null,"markerUnits","strokeWidth"),r=this.container.ownerDocument.createElementNS(this.svgNamespace,"path"),n=5,"Start"===e?(o=0,2===i?r.setAttributeNS(null,"d","M 10,0 L 0,5 L 10,10 L 5,5 z"):3===i?r.setAttributeNS(null,"d","M 0,0 L 3.33,0 L 3.33,10 L 0,10 z"):4===i?(n=3.31,r.setAttributeNS(null,"d","M 0.00,3.31 C 3.53,3.84 7.13,4.50 10.00,6.63 C 9.33,5.52 8.67,4.42 8.00,3.31 C 8.67,2.21 9.33,1.10 10.00,0.00 C 7.13,2.13 3.53,2.79 0.00,3.31")):5===i?(n=3.28,r.setAttributeNS(null,"d","M 0.00,3.28 C 3.39,4.19 6.81,5.07 10.00,6.55 C 9.38,5.56 9.00,4.44 9.00,3.28 C 9.00,2.11 9.38,0.99 10.00,0.00 C 6.81,1.49 3.39,2.37 0.00,3.28")):6===i?(n=2.84,r.setAttributeNS(null,"d","M 0.00,2.84 C 3.39,3.59 6.79,4.35 10.00,5.68 C 9.67,4.73 9.33,3.78 9.00,2.84 C 9.33,1.89 9.67,0.95 10.00,0.00 C 6.79,1.33 3.39,2.09 0.00,2.84")):7===i?(n=5.2,r.setAttributeNS(null,"d","M 0.00,5.20 C 4.04,5.20 7.99,6.92 10.00,10.39 M 10.00,0.00 C 7.99,3.47 4.04,5.20 0.00,5.20")):r.setAttributeNS(null,"d","M 10,0 L 0,5 L 10,10 z"),t.elementClass===constants.A.OBJECT_CLASS_LINE&&(o=2===i?4.9:3===i?3.3:4===i||5===i||6===i?6.66:7===i?0:10)):(o=10,2===i?r.setAttributeNS(null,"d","M 0,0 L 10,5 L 0,10 L 5,5 z"):3===i?(o=3.3,r.setAttributeNS(null,"d","M 0,0 L 3.33,0 L 3.33,10 L 0,10 z")):4===i?(n=3.31,r.setAttributeNS(null,"d","M 10.00,3.31 C 6.47,3.84 2.87,4.50 0.00,6.63 C 0.67,5.52 1.33,4.42 2.00,3.31 C 1.33,2.21 0.67,1.10 0.00,0.00 C 2.87,2.13 6.47,2.79 10.00,3.31")):5===i?(n=3.28,r.setAttributeNS(null,"d","M 10.00,3.28 C 6.61,4.19 3.19,5.07 0.00,6.55 C 0.62,5.56 1.00,4.44 1.00,3.28 C 1.00,2.11 0.62,0.99 0.00,0.00 C 3.19,1.49 6.61,2.37 10.00,3.28")):6===i?(n=2.84,r.setAttributeNS(null,"d","M 10.00,2.84 C 6.61,3.59 3.21,4.35 0.00,5.68 C 0.33,4.73 0.67,3.78 1.00,2.84 C 0.67,1.89 0.33,0.95 0.00,0.00 C 3.21,1.33 6.61,2.09 10.00,2.84")):7===i?(n=5.2,r.setAttributeNS(null,"d","M 10.00,5.20 C 5.96,5.20 2.01,6.92 0.00,10.39 M 0.00,0.00 C 2.01,3.47 5.96,5.20 10.00,5.20")):r.setAttributeNS(null,"d","M 0,0 L 10,5 L 0,10 z"),t.elementClass===constants.A.OBJECT_CLASS_LINE&&(o=2===i?5.1:3===i?.02:4===i||5===i||6===i?3.33:7===i?10:.05)),7===i&&(s.setAttributeNS(null,"fill","none"),s.setAttributeNS(null,"stroke-width",1)),s.setAttributeNS(null,"refY",n),s.setAttributeNS(null,"refX",o),s.appendChild(r),s},_setArrowColor:function(t,e,i,s,r){t&&(utils_type.A.isString(e)&&(7!==r?this._setAttribute((function(){t.setAttributeNS(null,"stroke",e),t.setAttributeNS(null,"fill",e),t.setAttributeNS(null,"stroke-opacity",i),t.setAttributeNS(null,"fill-opacity",i)}),s.visPropOld.fillcolor):this._setAttribute((function(){t.setAttributeNS(null,"fill","none"),t.setAttributeNS(null,"stroke",e),t.setAttributeNS(null,"stroke-opacity",i)}),s.visPropOld.fillcolor)),this.isIE&&s.rendNode.parentNode.insertBefore(s.rendNode,s.rendNode))},_setArrowWidth:function(t,e,i,s){var r,o;t&&(o=(r=e)*s,t.setAttributeNS(null,"viewBox","0 0 "+10*r+" "+10*r),t.setAttributeNS(null,"markerHeight",o),t.setAttributeNS(null,"markerWidth",o),t.setAttributeNS(null,"display","inherit"),this.isIE&&i.parentNode.insertBefore(i,i))},updateTicks:function(t){var e,i,s,r,o,n,a,l,h="",u=t.ticks.length,c=!0;for(e=0;e<u;e++){for(o=(s=t.ticks[e])[0],n=s[1],a=o.length,l=" M "+o[0]+" "+n[0],utils_type.A.isNumber(o[0])||(c=!1),i=1;c&&i<a;++i)utils_type.A.isNumber(o[i])?l+=" L "+o[i]+" "+n[i]:c=!1;c&&(h+=l)}r=t.rendNode,utils_type.A.exists(r)||(r=this.createPrim("path",t.id),this.appendChildPrim(r,utils_type.A.evaluate(t.visProp.layer)),t.rendNode=r),r.setAttributeNS(null,"stroke",utils_type.A.evaluate(t.visProp.strokecolor)),r.setAttributeNS(null,"fill","none"),r.setAttributeNS(null,"stroke-opacity",utils_type.A.evaluate(t.visProp.strokeopacity)),r.setAttributeNS(null,"stroke-width",utils_type.A.evaluate(t.visProp.strokewidth)),this.updatePathPrim(r,h,t.board),this.setObjectViewport(t)},displayCopyright:function(t,e){var i,s=this.createPrim("text","licenseText");s.setAttributeNS(null,"x","20px"),s.setAttributeNS(null,"y",2+e+"px"),s.setAttributeNS(null,"style","font-family:Arial,Helvetica,sans-serif; font-size:"+e+"px; fill:#356AA0;  opacity:0.3;"),i=this.container.ownerDocument.createTextNode(t),s.appendChild(i),this.appendChildPrim(s,0)},drawInternalText:function(t){var e=this.createPrim("text",t.id);return e.style.whiteSpace="nowrap",t.rendNodeText=this.container.ownerDocument.createTextNode(""),e.appendChild(t.rendNodeText),this.appendChildPrim(e,utils_type.A.evaluate(t.visProp.layer)),e},updateInternalText:function(t){var e,i=t.plaintext,s=t.getAnchorX(),r=t.getAnchorY();t.rendNode.getAttributeNS(null,"class")!==t.visProp.cssclass&&(t.rendNode.setAttributeNS(null,"class",utils_type.A.evaluate(t.visProp.cssclass)),t.needsSizeUpdate=!0),isNaN(t.coords.scrCoords[1]+t.coords.scrCoords[2])||(e=t.coords.scrCoords[1],t.visPropOld.left!==s+e&&(t.rendNode.setAttributeNS(null,"x",e+"px"),"left"===s?t.rendNode.setAttributeNS(null,"text-anchor","start"):"right"===s?t.rendNode.setAttributeNS(null,"text-anchor","end"):"middle"===s&&t.rendNode.setAttributeNS(null,"text-anchor","middle"),t.visPropOld.left=s+e),e=t.coords.scrCoords[2],t.visPropOld.top!==r+e&&(t.rendNode.setAttributeNS(null,"y",e+.5*this.vOffsetText+"px"),"bottom"===r?(t.rendNode.setAttributeNS(null,"dy","0"),t.rendNode.setAttributeNS(null,"dominant-baseline","auto")):"top"===r?(t.rendNode.setAttributeNS(null,"dy","1.6ex"),t.rendNode.setAttributeNS(null,"dominant-baseline","auto")):"middle"===r&&(t.rendNode.setAttributeNS(null,"dy","0.6ex"),t.rendNode.setAttributeNS(null,"dominant-baseline","auto")),t.visPropOld.top=r+e)),t.htmlStr!==i&&(t.rendNodeText.data=i,t.htmlStr=i),this.transformImage(t,t.transformations)},updateInternalTextStyle:function(t,e,i,s){this.setObjectViewport(t),this.setObjectFillColor(t,e,i)},drawImage:function(t){var e=this.createPrim("image",t.id);e.setAttributeNS(null,"preserveAspectRatio","none"),this.appendChildPrim(e,utils_type.A.evaluate(t.visProp.layer)),t.rendNode=e,this.updateImage(t)},transformImage:function(t,e){var i,s,r,o,n=t.rendNode,a="";if(e.length>0&&-1===(i=[(s=this.joinTransforms(t,e))[1][1],s[2][1],s[1][2],s[2][2],s[1][0],s[2][0]].join(",")).indexOf("NaN"))if(a+=" matrix("+i+") ",t.elementClass===constants.A.OBJECT_CLASS_TEXT&&"html"===t.visProp.display){switch(n.style.transform=a,r=-t.coords.scrCoords[1],o=-t.coords.scrCoords[2],utils_type.A.evaluate(t.visProp.anchorx)){case"right":r+=t.size[0];break;case"middle":r+=.5*t.size[0]}switch(utils_type.A.evaluate(t.visProp.anchory)){case"bottom":o+=t.size[1];break;case"middle":o+=.5*t.size[1]}n.style["transform-origin"]=r+"px "+o+"px"}else n.setAttributeNS(null,"transform",a)},updateImageURL:function(t){var e=utils_type.A.evaluate(t.url);return t._src!==e&&(t.imgIsLoaded=!1,t.rendNode.setAttributeNS(this.xlinkNamespace,"xlink:href",e),t._src=e,!0)},updateImageStyle:function(t,e){var i=utils_type.A.evaluate(e?t.visProp.highlightcssclass:t.visProp.cssclass);t.rendNode.setAttributeNS(null,"class",i)},drawForeignObject:function(t){t.rendNode=this.appendChildPrim(this.createPrim("foreignObject",t.id),utils_type.A.evaluate(t.visProp.layer)),this.appendNodesToElement(t,"foreignObject"),this.updateForeignObject(t)},updateForeignObject:function(t){t._useUserSize?t.rendNode.style.overflow="hidden":t.rendNode.style.overflow="visible",this.updateRectPrim(t.rendNode,t.coords.scrCoords[1],t.coords.scrCoords[2]-t.size[1],t.size[0],t.size[1]),t.rendNode.innerHTML=t.content,this._updateVisual(t,{stroke:!0,dash:!0},!0)},appendChildPrim:function(t,e){return utils_type.A.exists(e)?e>=src_options.A.layer.numlayers&&(e=src_options.A.layer.numlayers-1):e=0,this.layer[e].appendChild(t),t},createPrim:function(t,e){var i=this.container.ownerDocument.createElementNS(this.svgNamespace,t);return i.setAttributeNS(null,"id",this.uniqName(e)),i.style.position="absolute","path"===t&&(i.setAttributeNS(null,"stroke-linecap","round"),i.setAttributeNS(null,"stroke-linejoin","round"),i.setAttributeNS(null,"fill-rule","evenodd")),i},remove:function(t){utils_type.A.exists(t)&&utils_type.A.exists(t.parentNode)&&t.parentNode.removeChild(t)},setLayer:function(t,e){utils_type.A.exists(e)?e>=src_options.A.layer.numlayers&&(e=src_options.A.layer.numlayers-1):e=0,this.layer[e].appendChild(t.rendNode)},makeArrows:function(t,e){var i,s,r=e.evFirst,o=e.evLast;this.isIE&&t.visPropCalc.visible&&(r||o)?t.rendNode.parentNode.insertBefore(t.rendNode,t.rendNode):(i=t.rendNodeTriangleStart,r?(s=this.toStr(this.container.id,"_",t.id,"TriangleStart",e.typeFirst),utils_type.A.exists(i)&&i.id===s||(null===(i=this.container.ownerDocument.getElementById(s))&&(i=this._createArrowHead(t,"Start",e.typeFirst),this.defs.appendChild(i)),t.rendNodeTriangleStart=i,t.rendNode.setAttributeNS(null,"marker-start",this.toURL(s)))):utils_type.A.exists(i)&&(this.remove(i),t.rendNodeTriangleStart=null),i=t.rendNodeTriangleEnd,o?(s=this.toStr(this.container.id,"_",t.id,"TriangleEnd",e.typeLast),utils_type.A.exists(i)&&i.id===s||(null===(i=this.container.ownerDocument.getElementById(s))&&(i=this._createArrowHead(t,"End",e.typeLast),this.defs.appendChild(i)),t.rendNodeTriangleEnd=i,t.rendNode.setAttributeNS(null,"marker-end",this.toURL(s)))):utils_type.A.exists(i)&&(this.remove(i),t.rendNodeTriangleEnd=null))},updateEllipsePrim:function(t,e,i,s,r){var o;o=2e5,e=Math.abs(e)<o?e:o*e/Math.abs(e),i=Math.abs(i)<o?i:o*i/Math.abs(i),s=Math.abs(s)<o?s:o*s/Math.abs(s),r=Math.abs(r)<o?r:o*r/Math.abs(r),t.setAttributeNS(null,"cx",e),t.setAttributeNS(null,"cy",i),t.setAttributeNS(null,"rx",Math.abs(s)),t.setAttributeNS(null,"ry",Math.abs(r))},updateLinePrim:function(t,e,i,s,r){var o;o=2e5,isNaN(e+i+s+r)||(e=Math.abs(e)<o?e:o*e/Math.abs(e),i=Math.abs(i)<o?i:o*i/Math.abs(i),s=Math.abs(s)<o?s:o*s/Math.abs(s),r=Math.abs(r)<o?r:o*r/Math.abs(r),t.setAttributeNS(null,"x1",e),t.setAttributeNS(null,"y1",i),t.setAttributeNS(null,"x2",s),t.setAttributeNS(null,"y2",r))},updatePathPrim:function(t,e){""===e&&(e="M 0 0"),t.setAttributeNS(null,"d",e)},updatePathStringPoint:function(t,e,i){var s="",r=t.coords.scrCoords,o=e*Math.sqrt(3)*.5,n=.5*e;return"x"===i?s=" M "+(r[1]-e)+" "+(r[2]-e)+" L "+(r[1]+e)+" "+(r[2]+e)+" M "+(r[1]+e)+" "+(r[2]-e)+" L "+(r[1]-e)+" "+(r[2]+e):"+"===i?s=" M "+(r[1]-e)+" "+r[2]+" L "+(r[1]+e)+" "+r[2]+" M "+r[1]+" "+(r[2]-e)+" L "+r[1]+" "+(r[2]+e):"|"===i?s=" M "+r[1]+" "+(r[2]-e)+" L "+r[1]+" "+(r[2]+e):"-"===i?s=" M "+(r[1]-e)+" "+r[2]+" L "+(r[1]+e)+" "+r[2]:"<>"===i||"<<>>"===i?("<<>>"===i&&(e*=1.41),s=" M "+(r[1]-e)+" "+r[2]+" L "+r[1]+" "+(r[2]+e)+" L "+(r[1]+e)+" "+r[2]+" L "+r[1]+" "+(r[2]-e)+" Z "):"^"===i?s=" M "+r[1]+" "+(r[2]-e)+" L "+(r[1]-o)+" "+(r[2]+n)+" L "+(r[1]+o)+" "+(r[2]+n)+" Z ":"v"===i?s=" M "+r[1]+" "+(r[2]+e)+" L "+(r[1]-o)+" "+(r[2]-n)+" L "+(r[1]+o)+" "+(r[2]-n)+" Z ":">"===i?s=" M "+(r[1]+e)+" "+r[2]+" L "+(r[1]-n)+" "+(r[2]-o)+" L "+(r[1]-n)+" "+(r[2]+o)+" Z ":"<"===i&&(s=" M "+(r[1]-e)+" "+r[2]+" L "+(r[1]+n)+" "+(r[2]-o)+" L "+(r[1]+n)+" "+(r[2]+o)+" Z "),s},updatePathStringPrim:function(t){var e,i,s,r=" M ",o=r,n=5e3,a="";if(t.numberPoints<=0)return"";if(s=Math.min(t.points.length,t.numberPoints),1===t.bezierDegree)for(e=0;e<s;e++)i=t.points[e].scrCoords,isNaN(i[1])||isNaN(i[2])?o=r:(i[1]=Math.max(Math.min(i[1],n),-5e3),i[2]=Math.max(Math.min(i[2],n),-5e3),a+=o+i[1]+" "+i[2],o=" L ");else if(3===t.bezierDegree)for(e=0;e<s;)i=t.points[e].scrCoords,isNaN(i[1])||isNaN(i[2])?o=r:(a+=o+i[1]+" "+i[2]," C "===o&&(e+=1,a+=" "+(i=t.points[e].scrCoords)[1]+" "+i[2],e+=1,a+=" "+(i=t.points[e].scrCoords)[1]+" "+i[2]),o=" C "),e+=1;return a},updatePathStringBezierPrim:function(t){var e,i,s,r,o,n,a,l=" M ",h=l,u=5e3,c="",d=utils_type.A.evaluate(t.visProp.strokewidth),p="plot"!==utils_type.A.evaluate(t.visProp.curvetype);if(t.numberPoints<=0)return"";for(p&&t.board.options.curve.RDPsmoothing&&(t.points=numerics.A.RamerDouglasPeucker(t.points,.5)),a=Math.min(t.points.length,t.numberPoints),i=1;i<3;i++)for(h=l,e=0;e<a;e++)r=t.points[e].scrCoords,isNaN(r[1])||isNaN(r[2])?h=l:(r[1]=Math.max(Math.min(r[1],u),-5e3),r[2]=Math.max(Math.min(r[2],u),-5e3),h===l?c+=h+r[1]+" "+r[2]:(s=2*i,c+=[h,o+.333*(r[1]-o)+d*(s*Math.random()-i)," ",n+.333*(r[2]-n)+d*(s*Math.random()-i)," ",o+.666*(r[1]-o)+d*(s*Math.random()-i)," ",n+.666*(r[2]-n)+d*(s*Math.random()-i)," ",r[1]," ",r[2]].join("")),h=" C ",o=r[1],n=r[2]);return c},updatePolygonPrim:function(t,e){var i,s,r="",o=e.vertices.length;for(t.setAttributeNS(null,"stroke","none"),t.setAttributeNS(null,"fill-rule","evenodd"),"polygonalchain"===e.elType&&o++,i=0;i<o-1;i++){if(!e.vertices[i].isReal)return void t.setAttributeNS(null,"points","");r=r+(s=e.vertices[i].coords.scrCoords)[1]+","+s[2],i<o-2&&(r+=" ")}-1===r.indexOf("NaN")&&t.setAttributeNS(null,"points",r)},updateRectPrim:function(t,e,i,s,r){t.setAttributeNS(null,"x",e),t.setAttributeNS(null,"y",i),t.setAttributeNS(null,"width",s),t.setAttributeNS(null,"height",r)},setPropertyPrim:function(t,e,i){"stroked"!==e&&t.setAttributeNS(null,e,i)},display:function(t,e){var i;t&&t.rendNode&&(t.visPropOld.visible=e,i=t.rendNode,e?(i.setAttributeNS(null,"display","inline"),i.style.visibility="inherit"):(i.setAttributeNS(null,"display","none"),i.style.visibility="hidden"))},show:function(t){jxg.A.deprecated("Board.renderer.show()","Board.renderer.display()"),this.display(t,!0)},hide:function(t){jxg.A.deprecated("Board.renderer.hide()","Board.renderer.display()"),this.display(t,!1)},setBuffering:function(t,e){t.rendNode.setAttribute("buffered-rendering",e)},setDashStyle:function(t){var e=utils_type.A.evaluate(t.visProp.dash),i=utils_type.A.evaluate(t.visProp.dashscale)?.5*utils_type.A.evaluate(t.visProp.strokewidth):1,s=t.rendNode;e>0?s.setAttributeNS(null,"stroke-dasharray",this.dashArray[e-1].map((function(t){return t*i})).join(",")):s.hasAttributeNS(null,"stroke-dasharray")&&s.removeAttributeNS(null,"stroke-dasharray")},setGradient:function(t){var e,i,s,r=t.rendNode,o=utils_type.A.evaluate(t.visProp.gradient);"linear"===o||"radial"===o?(e=this.createPrim(o+"Gradient",t.id+"_gradient"),i=this.createPrim("stop",t.id+"_gradient1"),s=this.createPrim("stop",t.id+"_gradient2"),e.appendChild(i),e.appendChild(s),this.defs.appendChild(e),r.setAttributeNS(null,"style","fill:"+this.toURL(this.container.id+"_"+t.id+"_gradient")),t.gradNode1=i,t.gradNode2=s,t.gradNode=e):r.removeAttributeNS(null,"style")},updateGradientAngle:function(t,e){var i=1,s=Math.cos(e),r=Math.sin(e);Math.abs(s)>Math.abs(r)?i/=Math.abs(s):i/=Math.abs(r),s>=0?(t.setAttributeNS(null,"x1",0),t.setAttributeNS(null,"x2",s*i)):(t.setAttributeNS(null,"x1",-s*i),t.setAttributeNS(null,"x2",0)),r>=0?(t.setAttributeNS(null,"y1",0),t.setAttributeNS(null,"y2",r*i)):(t.setAttributeNS(null,"y1",-r*i),t.setAttributeNS(null,"y2",0))},updateGradientCircle:function(t,e,i,s,r,o,n){t.setAttributeNS(null,"cx",100*e+"%"),t.setAttributeNS(null,"cy",100*i+"%"),t.setAttributeNS(null,"r",100*s+"%"),t.setAttributeNS(null,"fx",100*r+"%"),t.setAttributeNS(null,"fy",100*o+"%"),t.setAttributeNS(null,"fr",100*n+"%")},updateGradient:function(t){var e,i,s=t.gradNode1,r=t.gradNode2,o=utils_type.A.evaluate(t.visProp.gradient);utils_type.A.exists(s)&&utils_type.A.exists(r)&&(i=(i=utils_type.A.evaluate(t.visProp.fillopacity))>0?i:0,e=utils_type.A.evaluate(t.visProp.fillcolor),s.setAttributeNS(null,"style","stop-color:"+e+";stop-opacity:"+i),r.setAttributeNS(null,"style","stop-color:"+utils_type.A.evaluate(t.visProp.gradientsecondcolor)+";stop-opacity:"+utils_type.A.evaluate(t.visProp.gradientsecondopacity)),s.setAttributeNS(null,"offset",100*utils_type.A.evaluate(t.visProp.gradientstartoffset)+"%"),r.setAttributeNS(null,"offset",100*utils_type.A.evaluate(t.visProp.gradientendoffset)+"%"),"linear"===o?this.updateGradientAngle(t.gradNode,utils_type.A.evaluate(t.visProp.gradientangle)):"radial"===o&&this.updateGradientCircle(t.gradNode,utils_type.A.evaluate(t.visProp.gradientcx),utils_type.A.evaluate(t.visProp.gradientcy),utils_type.A.evaluate(t.visProp.gradientr),utils_type.A.evaluate(t.visProp.gradientfx),utils_type.A.evaluate(t.visProp.gradientfy),utils_type.A.evaluate(t.visProp.gradientfr)))},setObjectTransition:function(t,e){var i,s,r,o=[],n=0,a=["rendNode","rendNodeTriangleStart","rendNodeTriangleEnd"];if(void 0===e&&(e=utils_type.A.evaluate(t.visProp.transitionduration)),i=utils_type.A.evaluate(t.visProp.transitionproperties),e!==t.visPropOld.transitionduration||i!==t.visPropOld.transitionproperties){for(utils_type.A.exists(i)&&(n=i.length),r=0;r<n;r++)o.push(i[r]+" "+e+"ms");for(s=o.join(", "),n=a.length,r=0;r<n;++r)t[a[r]]&&(t[a[r]].style.transition=s);t.visPropOld.transitionduration=e,t.visPropOld.transitionproperties=i}},setObjectViewport:function(t,e){var i,s,r,o,n,a,l,h,u,c=utils_type.A.evaluate(t.visProp.viewport),d=["rendNode"];for("inherit"===c&&(c=utils_type.A.evaluate(t.board.attr.viewport)),e&&(o=t.rendNode.getBoundingClientRect(),n=this.container.getBoundingClientRect(),l=parseFloat(c[1]),h=parseFloat(c[2]),u=parseFloat(c[3]),a=parseFloat(c[0]),utils_type.A.isString(c[1])&&c[1].indexOf("%")>0&&(l=n.height*l/100),utils_type.A.isString(c[2])&&c[2].indexOf("%")>0&&(h=n.width*h/100),utils_type.A.isString(c[3])&&c[3].indexOf("%")>0&&(u=n.height*u/100),utils_type.A.isString(c[0])&&c[0].indexOf("%")>0&&(a=n.width*a/100),l=parseFloat(n.top)-parseFloat(o.top)+l,h=parseFloat(o.right)-parseFloat(n.right)+h,u=parseFloat(o.bottom)-parseFloat(n.bottom)+u,c=[a=parseFloat(n.left)-parseFloat(o.left)+a,l,h,u]),i=["number"==typeof c[1]?c[1]+"px":c[1],"number"==typeof c[2]?c[2]+"px":c[2],"number"==typeof c[3]?c[3]+"px":c[3],"number"==typeof c[0]?c[0]+"px":c[0]].join(" "),r=d.length,s=0;s<r;++s)t[d[s]]&&(e?t[d[s]].style.clipPath="inset("+i+")":t[d[s]].setAttributeNS(null,"clip-path","view-box inset("+i+")"))},_setAttribute:function(t,e){""===e?t():window.setTimeout(t,1)},setObjectFillColor:function(t,e,i,s){var r,o,n,a,l=utils_type.A.evaluate(e),h=utils_type.A.evaluate(i),u=utils_type.A.evaluate(t.visProp.gradient);h=h>0?h:0,t.visPropOld.fillcolor===l&&t.visPropOld.fillopacity===h&&null===u||(utils_type.A.exists(l)&&!1!==l&&(9!==l.length?(o=l,a=h):(n=utils_color.A.rgba2rgbo(l),o=n[0],a=h*n[1]),r=void 0===s?t.rendNode:s,"none"!==o&&this._setAttribute((function(){r.setAttributeNS(null,"fill",o)}),t.visPropOld.fillcolor),t.type===jxg.A.OBJECT_TYPE_IMAGE?this._setAttribute((function(){r.setAttributeNS(null,"opacity",a)}),t.visPropOld.fillopacity):("none"===o?(a=0,r.setAttributeNS(null,"pointer-events","visibleStroke")):r.setAttributeNS(null,"pointer-events","visiblePainted"),this._setAttribute((function(){r.setAttributeNS(null,"fill-opacity",a)}),t.visPropOld.fillopacity)),"linear"!==u&&"radial"!==u||this.updateGradient(t)),t.visPropOld.fillcolor=l,t.visPropOld.fillopacity=h)},setObjectStrokeColor:function(t,e,i){var s,r,o,n,a=utils_type.A.evaluate(e),l=utils_type.A.evaluate(i);l=l>0?l:0,t.visPropOld.strokecolor===a&&t.visPropOld.strokeopacity===l||(utils_type.A.exists(a)&&!1!==a&&(9!==a.length?(s=a,o=l):(r=utils_color.A.rgba2rgbo(a),s=r[0],o=l*r[1]),n=t.rendNode,t.elementClass===constants.A.OBJECT_CLASS_TEXT?"html"===utils_type.A.evaluate(t.visProp.display)?this._setAttribute((function(){n.style.color=s,n.style.opacity=o}),t.visPropOld.strokecolor):this._setAttribute((function(){n.setAttributeNS(null,"style","fill:"+s),n.setAttributeNS(null,"style","fill-opacity:"+o)}),t.visPropOld.strokecolor):this._setAttribute((function(){n.setAttributeNS(null,"stroke",s),n.setAttributeNS(null,"stroke-opacity",o)}),t.visPropOld.strokecolor),t.elementClass!==constants.A.OBJECT_CLASS_CURVE&&t.elementClass!==constants.A.OBJECT_CLASS_LINE||(utils_type.A.evaluate(t.visProp.firstarrow)&&this._setArrowColor(t.rendNodeTriangleStart,s,o,t,t.visPropCalc.typeFirst),utils_type.A.evaluate(t.visProp.lastarrow)&&this._setArrowColor(t.rendNodeTriangleEnd,s,o,t,t.visPropCalc.typeLast))),t.visPropOld.strokecolor=a,t.visPropOld.strokeopacity=l)},setObjectStrokeWidth:function(t,e){var i,s=utils_type.A.evaluate(e);isNaN(s)||t.visPropOld.strokewidth===s||(i=t.rendNode,this.setPropertyPrim(i,"stroked","true"),utils_type.A.exists(s)&&this.setPropertyPrim(i,"stroke-width",s+"px"),t.visPropOld.strokewidth=s)},setLineCap:function(t){var e=utils_type.A.evaluate(t.visProp.linecap);void 0!==e&&""!==e&&t.visPropOld.linecap!==e&&utils_type.A.exists(t.rendNode)&&(this.setPropertyPrim(t.rendNode,"stroke-linecap",e),t.visPropOld.linecap=e)},setShadow:function(t){var e,i,s,r,o,n,a,l,h=utils_type.A.evaluate(t.visProp.shadow),u=!0,c=!1;(e=JSON.stringify(h))!==t.visPropOld.shadow&&("boolean"==typeof h?(u=!0,c=h,i="none",s=3,r=.1,o=[5,5],n=1):utils_type.A.evaluate(h.enabled)?(u=!1,c=!0,i=jxg.A.rgbParser(utils_type.A.evaluate(h.color)),s=utils_type.A.evaluate(h.blur),r=utils_type.A.evaluate(h.blend),o=utils_type.A.evaluate(h.offset),n=utils_type.A.evaluate(h.opacity)):c=!1,utils_type.A.exists(t.rendNode)&&(c?u?t.rendNode.setAttributeNS(null,"filter",this.toURL(this.container.id+"_f1")):((l=this.container.ownerDocument.getElementById(a))&&this.defs.removeChild(l),a=t.rendNode.id+"_f1",this.defs.appendChild(this.createShadowFilter(a,i,n,r,s,o)),t.rendNode.setAttributeNS(null,"filter",this.toURL(a))):t.rendNode.removeAttributeNS(null,"filter")),t.visPropOld.shadow=e)},suspendRedraw:function(){this.suspendHandle=this.svgRoot.suspendRedraw(1e4)},unsuspendRedraw:function(){this.svgRoot.unsuspendRedraw(this.suspendHandle)},resize:function(t,e){this.svgRoot.setAttribute("width",parseFloat(t)),this.svgRoot.setAttribute("height",parseFloat(e))},createTouchpoints:function(t){var e,i,s,r;for(this.touchpoints=[],e=0;e<t;e++)i="touchpoint1_"+e,r=this.createPrim("path",i),this.appendChildPrim(r,19),r.setAttributeNS(null,"d","M 0 0"),this.touchpoints.push(r),this.setPropertyPrim(r,"stroked","true"),this.setPropertyPrim(r,"stroke-width","1px"),r.setAttributeNS(null,"stroke","#000000"),r.setAttributeNS(null,"stroke-opacity",1),r.setAttributeNS(null,"display","none"),s="touchpoint2_"+e,r=this.createPrim("ellipse",s),this.appendChildPrim(r,19),this.updateEllipsePrim(r,0,0,0,0),this.touchpoints.push(r),this.setPropertyPrim(r,"stroked","true"),this.setPropertyPrim(r,"stroke-width","1px"),r.setAttributeNS(null,"stroke","#000000"),r.setAttributeNS(null,"stroke-opacity",1),r.setAttributeNS(null,"fill","#ffffff"),r.setAttributeNS(null,"fill-opacity",0),r.setAttributeNS(null,"display","none")},showTouchpoint:function(t){this.touchpoints&&t>=0&&2*t<this.touchpoints.length&&(this.touchpoints[2*t].setAttributeNS(null,"display","inline"),this.touchpoints[2*t+1].setAttributeNS(null,"display","inline"))},hideTouchpoint:function(t){this.touchpoints&&t>=0&&2*t<this.touchpoints.length&&(this.touchpoints[2*t].setAttributeNS(null,"display","none"),this.touchpoints[2*t+1].setAttributeNS(null,"display","none"))},updateTouchpoint:function(t,e){var i,s;this.touchpoints&&t>=0&&2*t<this.touchpoints.length&&(i=e[0],s=e[1],this.touchpoints[2*t].setAttributeNS(null,"d","M "+(i-37)+" "+s+" L "+(i+37)+" "+s+" M "+i+" "+(s-37)+" L "+i+" "+(s+37)),this.updateEllipsePrim(this.touchpoints[2*t+1],e[0],e[1],25,25))},_getValuesOfDOMElements:function(t){var e=[];if(1===t.nodeType)for(t=t.firstChild;t;)void 0!==t.id&&void 0!==t.value&&e.push([t.id,t.value]),utils_type.A.concat(e,this._getValuesOfDOMElements(t)),t=t.nextSibling;return e},_getImgDataURL:function(t){var e,i,s,r,o,n;if((i=(e=t.getElementsByTagName("image")).length)>0)for(s=document.createElement("canvas"),n=0;n<i;n++){e[n].setAttribute("crossorigin","anonymous"),r=s.getContext("2d"),s.width=e[n].getAttribute("width"),s.height=e[n].getAttribute("height");try{r.drawImage(e[n],0,0,s.width,s.height),o=s.toDataURL(),e[n].setAttribute("xlink:href",o)}catch(t){console.log("CORS problem! Image can not be used",t)}}return!0},dumpToDataURI:function(t){var e,i,s,r=this.svgRoot,o=window.btoa||base64.encode,n=[];if(this.container.hasChildNodes()&&utils_type.A.exists(this.foreignObjLayer)&&!t)for(this.foreignObjLayer.setAttribute("display","inline");r.nextSibling;)utils_type.A.concat(n,this._getValuesOfDOMElements(r.nextSibling)),this.foreignObjLayer.appendChild(r.nextSibling);if(this._getImgDataURL(r),r.setAttribute("xmlns","http://www.w3.org/2000/svg"),e=(new XMLSerializer).serializeToString(r),!0!==t)for(s=n.length,i=0;i<s;i++)e=e.replace('id="'+n[i][0]+'"','id="'+n[i][0]+'" value="'+n[i][1]+'"');if((e.match(/xmlns="http:\/\/www.w3.org\/2000\/svg"/g)||[]).length>1&&(e=e.replace(/xmlns="http:\/\/www.w3.org\/2000\/svg"/g,"")),e=(e=e.replace(/&nbsp;/g," ")).replace(/url\(&quot;(.*)&quot;\)/g,"url($1)"),utils_type.A.exists(this.foreignObjLayer)&&this.foreignObjLayer.hasChildNodes()){for(;this.foreignObjLayer.firstChild;)this.container.appendChild(this.foreignObjLayer.firstChild);this.foreignObjLayer.setAttribute("display","none")}return"data:image/svg+xml;base64,"+o(unescape(encodeURIComponent(e)))},dumpToCanvas:function(t,e,i,s){var r,o,n,a;return(n=this.container.ownerDocument.getElementById(t)).width=n.width,a=n.getContext("2d"),void 0!==e&&void 0!==i&&(n.style.width=parseFloat(e)+"px",n.style.height=parseFloat(i)+"px",n.setAttribute("width",parseFloat(e)),n.setAttribute("height",parseFloat(i))),o=new Image,r=this.dumpToDataURI(s),o.src=r,"Promise"in window?new Promise((function(t,s){try{o.onload=function(){a.drawImage(o,0,0,e,i),t()}}catch(t){s(t)}})):(o.onload=function(){window.setTimeout((function(){try{a.drawImage(o,0,0,e,i)}catch(t){console.log("screenshots not longer supported on IE")}}),200)},this)},screenshot:function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_,f=this.container.ownerDocument,A=this.container.parentNode,g=t.attr.screenshot,m=!1;return"no"===this.type||(h=g.scale*this.container.getBoundingClientRect().width,u=g.scale*this.container.getBoundingClientRect().height,void 0===e||""===e?(m=!0,(n=new Image).style.width=h+"px",n.style.height=u+"px"):(m=!1,n=f.getElementById(e)),m&&((s=f.createElement("div")).style.cssText=g.css,s.style.width=h+"px",s.style.height=u+"px",s.style.zIndex=this.container.style.zIndex+120,s.style.position="absolute",s.style.top=this.container.offsetTop+"px",s.style.left=this.container.offsetLeft+"px"),r=f.createElement("canvas"),o=Math.random().toString(36).slice(2,7),r.setAttribute("id",o),r.setAttribute("width",h),r.setAttribute("height",u),r.style.width=h+"px",r.style.height=h+"px",r.style.display="none",A.appendChild(r),m&&(a=f.createElement("span"),l=f.createTextNode("✖"),a.style.cssText=g.cssButton,a.appendChild(l),a.onclick=function(){s.parentNode.removeChild(s)},s.appendChild(n),s.appendChild(a),A.insertBefore(s,this.container.nextSibling)),c=f.getElementById(this.uniqName("navigationbar")),utils_type.A.exists(c)&&(d=c.style.display,c.style.display="none",p=this.removeToInsertLater(c)),_=function(){n.src=r.toDataURL("image/png"),A.removeChild(r)},"Promise"in window?this.dumpToCanvas(o,h,u,i).then(_):(this.dumpToCanvas(o,h,u,i),window.setTimeout(_,200)),utils_type.A.exists(c)&&(c.style.display=d,p())),this}});var svg=jxg.A.SVGRenderer;jxg.A.VMLRenderer=function(t){this.type="vml",this.container=t,this.container.style.overflow="hidden",""===this.container.style.position&&(this.container.style.position="relative"),this.container.onselectstart=function(){return!1},this.resolution=10,utils_type.A.exists(jxg.A.vmlStylesheet)||(t.ownerDocument.namespaces.add("jxgvml","urn:schemas-microsoft-com:vml"),jxg.A.vmlStylesheet=this.container.ownerDocument.createStyleSheet(),jxg.A.vmlStylesheet.addRule(".jxgvml","behavior:url(#default#VML)"));try{t.ownerDocument.namespaces.jxgvml||t.ownerDocument.namespaces.add("jxgvml","urn:schemas-microsoft-com:vml"),this.createNode=function(e){return t.ownerDocument.createElement("<jxgvml:"+e+' class="jxgvml">')}}catch(e){this.createNode=function(e){return t.ownerDocument.createElement("<"+e+' xmlns="urn:schemas-microsoft.com:vml" class="jxgvml">')}}this.dashArray=["Solid","1 1","ShortDash","Dash","LongDash","ShortDashDot","LongDashDot"]},jxg.A.VMLRenderer.prototype=new renderer_abstract,jxg.A.extend(jxg.A.VMLRenderer.prototype,{_setAttr:function(t,e,i,s){try{8===this.container.ownerDocument.documentMode?t[e]=i:t.setAttribute(e,i,s)}catch(t){jxg.A.debug("_setAttr: "+e+" "+i+"<br>\n")}},updateTicks:function(t){var e,i,s,r,o,n=this.resolution,a=[];for(i=t.ticks.length,e=0;e<i;e++)r=(s=t.ticks[e])[0],o=s[1],utils_type.A.isNumber(r[0])&&utils_type.A.isNumber(r[1])&&a.push(" m "+Math.round(n*r[0])+", "+Math.round(n*o[0])+" l "+Math.round(n*r[1])+", "+Math.round(n*o[1])+" ");utils_type.A.exists(t.rendNode)||(t.rendNode=this.createPrim("path",t.id),this.appendChildPrim(t.rendNode,utils_type.A.evaluate(t.visProp.layer))),this._setAttr(t.rendNode,"stroked","true"),this._setAttr(t.rendNode,"strokecolor",utils_type.A.evaluate(t.visProp.strokecolor),1),this._setAttr(t.rendNode,"strokeweight",utils_type.A.evaluate(t.visProp.strokewidth)),this._setAttr(t.rendNodeStroke,"opacity",100*utils_type.A.evaluate(t.visProp.strokeopacity)+"%"),this.updatePathPrim(t.rendNode,a,t.board)},displayCopyright:function(t,e){var i,s;(i=this.createNode("textbox")).style.position="absolute",this._setAttr(i,"id",this.container.id+"_licenseText"),i.style.left=20,i.style.top=2,i.style.fontSize=e,i.style.color="#356AA0",i.style.fontFamily="Arial,Helvetica,sans-serif",this._setAttr(i,"opacity","30%"),i.style.filter="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand', enabled = false) progid:DXImageTransform.Microsoft.Alpha(opacity = 30, enabled = true)",s=this.container.ownerDocument.createTextNode(t),i.appendChild(s),this.appendChildPrim(i,0)},drawInternalText:function(t){var e;return(e=this.createNode("textbox")).style.position="absolute",t.rendNodeText=this.container.ownerDocument.createTextNode(""),e.appendChild(t.rendNodeText),this.appendChildPrim(e,9),e.style.filter="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand', enabled = false) progid:DXImageTransform.Microsoft.Alpha(opacity = 100, enabled = false)",e},updateInternalText:function(t){var e,i,s,r,o,n,a=t.plaintext,l=this.joinTransforms(t,t.transformations),h=[0,0],u=t.rendNode,c=[],d=t.getAnchorX(),p=t.getAnchorY();if(!isNaN(t.coords.scrCoords[1]+t.coords.scrCoords[2])){for("right"===d?h[0]=1:"middle"===d&&(h[0]=.5),"bottom"===p?h[1]=1:"middle"===p&&(h[1]=.5),c[0]=math.A.matVecMult(l,[1,t.coords.scrCoords[1]-h[0]*t.size[0],t.coords.scrCoords[2]+(1-h[1])*t.size[1]+this.vOffsetText]),c[0][1]/=c[0][0],c[0][2]/=c[0][0],c[1]=math.A.matVecMult(l,[1,t.coords.scrCoords[1]+(1-h[0])*t.size[0],t.coords.scrCoords[2]+(1-h[1])*t.size[1]+this.vOffsetText]),c[1][1]/=c[1][0],c[1][2]/=c[1][0],c[2]=math.A.matVecMult(l,[1,t.coords.scrCoords[1]+(1-h[0])*t.size[0],t.coords.scrCoords[2]-h[1]*t.size[1]+this.vOffsetText]),c[2][1]/=c[2][0],c[2][2]/=c[2][0],c[3]=math.A.matVecMult(l,[1,t.coords.scrCoords[1]-h[0]*t.size[0],t.coords.scrCoords[2]-h[1]*t.size[1]+this.vOffsetText]),c[3][1]/=c[3][0],c[3][2]/=c[3][0],i=c[0][1],r=c[0][1],s=c[0][2],o=c[0][2],n=1;n<4;n++)i=Math.max(i,c[n][1]),r=Math.min(r,c[n][1]),s=Math.max(s,c[n][2]),o=Math.min(o,c[n][2]);e=1===h[0]?Math.floor(t.board.canvasWidth-i):Math.floor(r),t.visPropOld.left!==d+e&&(1===h[0]?(t.rendNode.style.right=e+"px",t.rendNode.style.left="auto"):(t.rendNode.style.left=e+"px",t.rendNode.style.right="auto"),t.visPropOld.left=d+e),e=1===h[1]?Math.floor(t.board.canvasHeight-s):Math.floor(o),t.visPropOld.top!==p+e&&(1===h[1]?(t.rendNode.style.bottom=e+"px",t.rendNode.style.top="auto"):(t.rendNode.style.top=e+"px",t.rendNode.style.bottom="auto"),t.visPropOld.top=p+e)}t.htmlStr!==a&&(t.rendNodeText.data=a,t.htmlStr=a),u.filters.item(0).M11=l[1][1],u.filters.item(0).M12=l[1][2],u.filters.item(0).M21=l[2][1],u.filters.item(0).M22=l[2][2],u.filters.item(0).enabled=!0},drawImage:function(t){var e;(e=this.container.ownerDocument.createElement("img")).style.position="absolute",this._setAttr(e,"id",this.container.id+"_"+t.id),this.container.appendChild(e),this.appendChildPrim(e,utils_type.A.evaluate(t.visProp.layer)),e.style.filter="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand') progid:DXImageTransform.Microsoft.Alpha(opacity = 100, enabled = false)",t.rendNode=e,this.updateImage(t)},transformImage:function(t,e){var i,s,r,o,n,a,l=t.rendNode,h=[];if(e.length>0){for(i=this.joinTransforms(t,e),h[0]=math.A.matVecMult(i,t.coords.scrCoords),h[0][1]/=h[0][0],h[0][2]/=h[0][0],h[1]=math.A.matVecMult(i,[1,t.coords.scrCoords[1]+t.size[0],t.coords.scrCoords[2]]),h[1][1]/=h[1][0],h[1][2]/=h[1][0],h[2]=math.A.matVecMult(i,[1,t.coords.scrCoords[1]+t.size[0],t.coords.scrCoords[2]-t.size[1]]),h[2][1]/=h[2][0],h[2][2]/=h[2][0],h[3]=math.A.matVecMult(i,[1,t.coords.scrCoords[1],t.coords.scrCoords[2]-t.size[1]]),h[3][1]/=h[3][0],h[3][2]/=h[3][0],s=h[0][1],o=h[0][1],r=h[0][2],n=h[0][2],a=1;a<4;a++)s=Math.max(s,h[a][1]),o=Math.min(o,h[a][1]),r=Math.max(r,h[a][2]),n=Math.min(n,h[a][2]);l.style.left=Math.floor(o)+"px",l.style.top=Math.floor(n)+"px",l.filters.item(0).M11=i[1][1],l.filters.item(0).M12=i[1][2],l.filters.item(0).M21=i[2][1],l.filters.item(0).M22=i[2][2],l.filters.item(0).enabled=!0}},updateImageURL:function(t){var e=utils_type.A.evaluate(t.url);this._setAttr(t.rendNode,"src",e)},appendChildPrim:function(t,e){return utils_type.A.exists(e)||(e=0),t.style.zIndex=e,this.container.appendChild(t),t},appendNodesToElement:function(t,e){"shape"!==e&&"path"!==e&&"polygon"!==e||(t.rendNodePath=this.getElementById(t.id+"_path")),t.rendNodeFill=this.getElementById(t.id+"_fill"),t.rendNodeStroke=this.getElementById(t.id+"_stroke"),t.rendNodeShadow=this.getElementById(t.id+"_shadow"),t.rendNode=this.getElementById(t.id)},createPrim:function(t,e){var i,s,r=this.createNode("fill"),o=this.createNode("stroke"),n=this.createNode("shadow");return this._setAttr(r,"id",this.container.id+"_"+e+"_fill"),this._setAttr(o,"id",this.container.id+"_"+e+"_stroke"),this._setAttr(n,"id",this.container.id+"_"+e+"_shadow"),"circle"===t||"ellipse"===t?((i=this.createNode("oval")).appendChild(r),i.appendChild(o),i.appendChild(n)):"polygon"===t||"path"===t||"shape"===t||"line"===t?((i=this.createNode("shape")).appendChild(r),i.appendChild(o),i.appendChild(n),s=this.createNode("path"),this._setAttr(s,"id",this.container.id+"_"+e+"_path"),i.appendChild(s)):((i=this.createNode(t)).appendChild(r),i.appendChild(o),i.appendChild(n)),i.style.position="absolute",i.style.left="0px",i.style.top="0px",this._setAttr(i,"id",this.container.id+"_"+e),i},remove:function(t){utils_type.A.exists(t)&&t.removeNode(!0)},makeArrows:function(t){var e,i=utils_type.A.evaluate(t.visProp.firstarrow),s=utils_type.A.evaluate(t.visProp.lastarrow);t.visPropOld.firstarrow===i&&t.visPropOld.lastarrow===s||(i?(e=t.rendNodeStroke,this._setAttr(e,"startarrow","block"),this._setAttr(e,"startarrowlength","long")):(e=t.rendNodeStroke,utils_type.A.exists(e)&&this._setAttr(e,"startarrow","none")),s?(e=t.rendNodeStroke,this._setAttr(e,"id",this.container.id+"_"+t.id+"stroke"),this._setAttr(e,"endarrow","block"),this._setAttr(e,"endarrowlength","long")):(e=t.rendNodeStroke,utils_type.A.exists(e)&&this._setAttr(e,"endarrow","none")),t.visPropOld.firstarrow=i,t.visPropOld.lastarrow=s)},updateEllipsePrim:function(t,e,i,s,r){t.style.left=Math.floor(e-s)+"px",t.style.top=Math.floor(i-r)+"px",t.style.width=Math.floor(2*Math.abs(s))+"px",t.style.height=Math.floor(2*Math.abs(r))+"px"},updateLinePrim:function(t,e,i,s,r,o){var n,a=this.resolution;isNaN(e+i+s+r)||(n=["m ",Math.floor(a*e),", ",Math.floor(a*i)," l ",Math.floor(a*s),", ",Math.floor(a*r)],this.updatePathPrim(t,n,o))},updatePathPrim:function(t,e,i){var s=i.canvasWidth,r=i.canvasHeight;e.length<=0&&(e=["m 0,0"]),t.style.width=s,t.style.height=r,this._setAttr(t,"coordsize",[Math.floor(this.resolution*s),Math.floor(this.resolution*r)].join(",")),this._setAttr(t,"path",e.join(""))},updatePathStringPoint:function(t,e,i){var s=[],r=Math.round,o=t.coords.scrCoords,n=e*Math.sqrt(3)*.5,a=.5*e,l=this.resolution;return"x"===i?s.push([" m ",r(l*(o[1]-e)),", ",r(l*(o[2]-e))," l ",r(l*(o[1]+e)),", ",r(l*(o[2]+e))," m ",r(l*(o[1]+e)),", ",r(l*(o[2]-e))," l ",r(l*(o[1]-e)),", ",r(l*(o[2]+e))].join("")):"+"===i?s.push([" m ",r(l*(o[1]-e)),", ",r(l*o[2])," l ",r(l*(o[1]+e)),", ",r(l*o[2])," m ",r(l*o[1]),", ",r(l*(o[2]-e))," l ",r(l*o[1]),", ",r(l*(o[2]+e))].join("")):"<>"===i||"<<>>"===i?("<<>>"===i&&(e*=1.41),s.push([" m ",r(l*(o[1]-e)),", ",r(l*o[2])," l ",r(l*o[1]),", ",r(l*(o[2]+e))," l ",r(l*(o[1]+e)),", ",r(l*o[2])," l ",r(l*o[1]),", ",r(l*(o[2]-e))," x e "].join(""))):"^"===i?s.push([" m ",r(l*o[1]),", ",r(l*(o[2]-e))," l ",r(l*(o[1]-n)),", ",r(l*(o[2]+a))," l ",r(l*(o[1]+n)),", ",r(l*(o[2]+a))," x e "].join("")):"v"===i?s.push([" m ",r(l*o[1]),", ",r(l*(o[2]+e))," l ",r(l*(o[1]-n)),", ",r(l*(o[2]-a))," l ",r(l*(o[1]+n)),", ",r(l*(o[2]-a))," x e "].join("")):">"===i?s.push([" m ",r(l*(o[1]+e)),", ",r(l*o[2])," l ",r(l*(o[1]-a)),", ",r(l*(o[2]-n))," l ",r(l*(o[1]-a)),", ",r(l*(o[2]+n))," l ",r(l*(o[1]+e)),", ",r(l*o[2])].join("")):"<"===i&&s.push([" m ",r(l*(o[1]-e)),", ",r(l*o[2])," l ",r(l*(o[1]+a)),", ",r(l*(o[2]-n))," l ",r(l*(o[1]+a)),", ",r(l*(o[2]+n))," x e "].join("")),s},updatePathStringPrim:function(t){var e,i,s=[],r=this.resolution,o=Math.round,n=" m ",a=n,l=Math.min(t.numberPoints,8192);if(t.numberPoints<=0)return"";if(l=Math.min(l,t.points.length),1===t.bezierDegree)for(e=0;e<l;e++)i=t.points[e].scrCoords,isNaN(i[1])||isNaN(i[2])?a=n:(i[1]>2e4?i[1]=2e4:i[1]<-2e4&&(i[1]=-2e4),i[2]>2e4?i[2]=2e4:i[2]<-2e4&&(i[2]=-2e4),s.push([a,o(r*i[1]),", ",o(r*i[2])].join("")),a=" l ");else if(3===t.bezierDegree)for(e=0;e<l;)i=t.points[e].scrCoords,isNaN(i[1])||isNaN(i[2])?a=n:(s.push([a,o(r*i[1]),", ",o(r*i[2])].join(""))," c "===a&&(e+=1,i=t.points[e].scrCoords,s.push([" ",o(r*i[1]),", ",o(r*i[2])].join("")),e+=1,i=t.points[e].scrCoords,s.push([" ",o(r*i[1]),", ",o(r*i[2])].join(""))),a=" c "),e+=1;return s.push(" e"),s},updatePathStringBezierPrim:function(t){var e,i,s,r,o,n,a=[],l=utils_type.A.evaluate(t.visProp.strokewidth),h=this.resolution,u=Math.round,c=" m ",d=c,p="plot"!==utils_type.A.evaluate(t.visProp.curvetype),_=Math.min(t.numberPoints,8192);if(t.numberPoints<=0)return"";for(p&&t.board.options.curve.RDPsmoothing&&(t.points=numerics.A.RamerDouglasPeucker(t.points,1)),_=Math.min(_,t.points.length),i=1;i<3;i++)for(d=c,e=0;e<_;e++)r=t.points[e].scrCoords,isNaN(r[1])||isNaN(r[2])?d=c:(r[1]>2e4?r[1]=2e4:r[1]<-2e4&&(r[1]=-2e4),r[2]>2e4?r[2]=2e4:r[2]<-2e4&&(r[2]=-2e4),d===c?a.push([d,u(h*r[1])," ",u(h*r[2])].join("")):(s=2*i,a.push([d,u(h*(o+.333*(r[1]-o)+l*(s*Math.random()-i)))," ",u(h*(n+.333*(r[2]-n)+l*(s*Math.random()-i)))," ",u(h*(o+.666*(r[1]-o)+l*(s*Math.random()-i)))," ",u(h*(n+.666*(r[2]-n)+l*(s*Math.random()-i)))," ",u(h*r[1])," ",u(h*r[2])].join(""))),d=" c ",o=r[1],n=r[2]);return a.push(" e"),a},updatePolygonPrim:function(t,e){var i,s,r=e.vertices.length,o=this.resolution,n=[];if(this._setAttr(t,"stroked","false"),s=e.vertices[0].coords.scrCoords,!isNaN(s[1]+s[2])){for(n.push(["m ",Math.floor(o*s[1]),",",Math.floor(o*s[2])," l "].join("")),i=1;i<r-1;i++){if(!e.vertices[i].isReal)return void this.updatePathPrim(t,"",e.board);if(s=e.vertices[i].coords.scrCoords,isNaN(s[1]+s[2]))return;n.push(Math.floor(o*s[1])+","+Math.floor(o*s[2])),i<r-2&&n.push(", ")}n.push(" x e"),this.updatePathPrim(t,n,e.board)}},updateRectPrim:function(t,e,i,s,r){t.style.left=Math.floor(e)+"px",t.style.top=Math.floor(i)+"px",s>=0&&(t.style.width=s+"px"),r>=0&&(t.style.height=r+"px")},setPropertyPrim:function(t,e,i){var s,r="";switch(e){case"stroke":r="strokecolor";break;case"stroke-width":r="strokeweight";break;case"stroke-dasharray":r="dashstyle"}""!==r&&(s=utils_type.A.evaluate(i),this._setAttr(t,r,s))},display:function(t,e){t&&t.rendNode&&(t.visPropOld.visible=e,t.rendNode.style.visibility=e?"inherit":"hidden")},show:function(t){jxg.A.deprecated("Board.renderer.show()","Board.renderer.display()"),t&&t.rendNode&&(t.rendNode.style.visibility="inherit")},hide:function(t){jxg.A.deprecated("Board.renderer.hide()","Board.renderer.display()"),t&&t.rendNode&&(t.rendNode.style.visibility="hidden")},setDashStyle:function(t,e){var i;e.dash>=0&&(i=t.rendNodeStroke,this._setAttr(i,"dashstyle",this.dashArray[e.dash]))},setGradient:function(t){var e=t.rendNodeFill,i=utils_type.A.evaluate(t.visProp.gradient);"linear"===i?(this._setAttr(e,"type","gradient"),this._setAttr(e,"color2",utils_type.A.evaluate(t.visProp.gradientsecondcolor)),this._setAttr(e,"opacity2",utils_type.A.evaluate(t.visProp.gradientsecondopacity)),this._setAttr(e,"angle",utils_type.A.evaluate(t.visProp.gradientangle))):"radial"===i?(this._setAttr(e,"type","gradientradial"),this._setAttr(e,"color2",utils_type.A.evaluate(t.visProp.gradientsecondcolor)),this._setAttr(e,"opacity2",utils_type.A.evaluate(t.visProp.gradientsecondopacity)),this._setAttr(e,"focusposition",100*utils_type.A.evaluate(t.visProp.gradientpositionx)+"%,"+100*utils_type.A.evaluate(t.visProp.gradientpositiony)+"%"),this._setAttr(e,"focussize","0,0")):this._setAttr(e,"type","solid")},setObjectFillColor:function(t,e,i){var s,r,o,n=utils_type.A.evaluate(e),a=utils_type.A.evaluate(i),l=t.rendNode;a=a>0?a:0,t.visPropOld.fillcolor===n&&t.visPropOld.fillopacity===a||(utils_type.A.exists(n)&&!1!==n&&(9!==n.length?(s=n,o=a):(s=(r=utils_color.A.rgba2rgbo(n))[0],o=a*r[1]),"none"===s||!1===s?this._setAttr(t.rendNode,"filled","false"):(this._setAttr(t.rendNode,"filled","true"),this._setAttr(t.rendNode,"fillcolor",s),utils_type.A.exists(o)&&t.rendNodeFill&&this._setAttr(t.rendNodeFill,"opacity",100*o+"%")),t.type===constants.A.OBJECT_TYPE_IMAGE&&l.filters.length>1&&(l.filters.item(1).opacity=Math.round(100*o),l.filters.item(1).enabled=!0)),t.visPropOld.fillcolor=n,t.visPropOld.fillopacity=a)},setObjectStrokeColor:function(t,e,i){var s,r,o,n,a=utils_type.A.evaluate(e),l=utils_type.A.evaluate(i),h=t.rendNode;l=l>0?l:0,t.visPropOld.strokecolor===a&&t.visPropOld.strokeopacity===l||(utils_type.A.exists(a)&&!1!==a&&(9!==a.length?(s=a,o=l):(s=(r=e.rgba2rgbo(a))[0],o=l*r[1]),t.elementClass===constants.A.OBJECT_CLASS_TEXT?(h.filters.length>1&&(h.filters.item(1).opacity=Math.round(100*o),h.filters.item(1).enabled=!0),h.style.color=s):(!1!==s&&(this._setAttr(h,"stroked","true"),this._setAttr(h,"strokecolor",s)),n=t.rendNodeStroke,utils_type.A.exists(o)&&t.type!==constants.A.OBJECT_TYPE_IMAGE&&this._setAttr(n,"opacity",100*o+"%"))),t.visPropOld.strokecolor=a,t.visPropOld.strokeopacity=l)},setObjectStrokeWidth:function(t,e){var i,s=utils_type.A.evaluate(e);isNaN(s)||t.visPropOld.strokewidth===s||(i=t.rendNode,this.setPropertyPrim(i,"stroked","true"),utils_type.A.exists(s)&&(this.setPropertyPrim(i,"stroke-width",s),0===s&&utils_type.A.exists(t.rendNodeStroke)&&this._setAttr(i,"stroked","false")),t.visPropOld.strokewidth=s)},setShadow:function(t){var e=t.rendNodeShadow,i=utils_type.A.evaluate(t.visProp.shadow);e&&t.visPropOld.shadow!==i&&(i?(this._setAttr(e,"On","True"),this._setAttr(e,"Offset","3pt,3pt"),this._setAttr(e,"Opacity","60%"),this._setAttr(e,"Color","#aaaaaa")):this._setAttr(e,"On","False"),t.visPropOld.shadow=i)},suspendRedraw:function(){this.container.style.display="none"},unsuspendRedraw:function(){this.container.style.display=""}});var vml=jxg.A.VMLRenderer,uuidCharsStr="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz",uuidChars=uuidCharsStr.split("");jxg.A.Util=jxg.A.Util||{},jxg.A.Util.genUUID=function(t){var e,i,s=[],r=0;for(""!==(t=t||"")&&"-"!==t.slice(t.length-1)&&(t+="-"),i=0;i<36;i++)8===i||13===i||18===i||23===i?s[i]="-":14===i?s[i]="4":(r<=2&&(r=33554432+16777216*Math.random()|0),e=15&r,r>>=4,s[i]=uuidChars[19===i?3&e|8:e]);return t+s.join("")};var uuid=jxg.A.Util;jxg.A.CanvasRenderer=function(t,e){if(this.type="canvas",this.canvasRoot=null,this.suspendHandle=null,this.canvasId=uuid.genUUID(),this.canvasNamespace=null,env.A.isBrowser)this.container=t,this.container.style.MozUserSelect="none",this.container.style.userSelect="none",this.container.style.overflow="hidden",""===this.container.style.position&&(this.container.style.position="relative"),this.container.innerHTML=['<canvas id="',this.canvasId,'" width="',e.width,'px" height="',e.height,'px"></canvas>'].join(""),this.canvasRoot=this.container.ownerDocument.getElementById(this.canvasId),this.canvasRoot.style.display="block",this.context=this.canvasRoot.getContext("2d");else if(env.A.isNode())try{this.canvasRoot=jxg.A.createCanvas(500,500),this.context=this.canvasRoot.getContext("2d")}catch(t){throw new Error('JXG.createCanvas not available.\nInstall the npm package `canvas`\nand call:\n    import { createCanvas } from "canvas.js";\n    JXG.createCanvas = createCanvas;\n')}},jxg.A.CanvasRenderer.prototype=new renderer_abstract,jxg.A.extend(jxg.A.CanvasRenderer.prototype,{_drawPolygon:function(t,e,i){var s,r=t.length,o=this.context;if(r>0){if(i&&(o.lineWidth=0),o.beginPath(),o.moveTo(t[0][0],t[0][1]),1===e)for(s=1;s<r;s++)o.lineTo(t[s][0],t[s][1]);else for(s=1;s<r;s+=3)o.bezierCurveTo(t[s][0],t[s][1],t[s+1][0],t[s+1][1],t[s+2][0],t[s+2][1]);i?(o.lineTo(t[0][0],t[0][1]),o.closePath(),o.fill("evenodd")):o.stroke()}},_fill:function(t){var e=this.context;e.save(),this._setColor(t,"fill")&&e.fill("evenodd"),e.restore()},_rotatePoint:function(t,e,i){return[e*Math.cos(t)-i*Math.sin(t),e*Math.sin(t)+i*Math.cos(t)]},_rotateShape:function(t,e){var i,s=[],r=t.length;if(r<=0)return t;for(i=0;i<r;i++)s.push(this._rotatePoint(e,t[i][0],t[i][1]));return s},updateGradientAngle:function(t,e){var i,s,r,o,n,a,l,h,u,c,d,p,_=1,f=Math.cos(-e),A=Math.sin(-e),g=t.getBoundingBox();return Math.abs(f)>Math.abs(A)?_/=Math.abs(f):_/=Math.abs(A),f>=0?(r=0,o=f*_):(r=-f*_,o=0),A>=0?(n=0,a=A*_):(n=-A*_,a=0),i=new base_coords.A(constants.A.COORDS_BY_USER,[g[0],g[1]],t.board),d=(s=new base_coords.A(constants.A.COORDS_BY_USER,[g[2],g[3]],t.board)).scrCoords[1]-i.scrCoords[1],p=s.scrCoords[2]-i.scrCoords[2],l=i.scrCoords[1]+d*r,u=i.scrCoords[2]+p*n,h=i.scrCoords[1]+d*o,c=i.scrCoords[2]+p*a,this.context.createLinearGradient(l,u,h,c)},updateGradientCircle:function(t,e,i,s,r,o,n){var a,l,h,u,c,d,p,_,f,A,g=t.getBoundingBox();return a=new base_coords.A(constants.A.COORDS_BY_USER,[g[0],g[1]],t.board),f=(l=new base_coords.A(constants.A.COORDS_BY_USER,[g[2],g[3]],t.board)).scrCoords[1]-a.scrCoords[1],A=a.scrCoords[2]-l.scrCoords[2],h=a.scrCoords[1]+f*e,u=l.scrCoords[2]+A*i,d=a.scrCoords[1]+f*r,p=l.scrCoords[2]+A*o,c=s*(f+A)*.5,_=n*(f+A)*.5,this.context.createRadialGradient(d,p,_,h,u,c)},updateGradient:function(t){var e,i,s=utils_type.A.evaluate(t.visProp.gradient);return e=utils_type.A.evaluate(t.visProp.fillcolor),"linear"===s?i=this.updateGradientAngle(t,utils_type.A.evaluate(t.visProp.gradientangle)):"radial"===s&&(i=this.updateGradientCircle(t,utils_type.A.evaluate(t.visProp.gradientcx),utils_type.A.evaluate(t.visProp.gradientcy),utils_type.A.evaluate(t.visProp.gradientr),utils_type.A.evaluate(t.visProp.gradientfx),utils_type.A.evaluate(t.visProp.gradientfy),utils_type.A.evaluate(t.visProp.gradientfr))),i.addColorStop(utils_type.A.evaluate(t.visProp.gradientstartoffset),e),i.addColorStop(utils_type.A.evaluate(t.visProp.gradientendoffset),utils_type.A.evaluate(t.visProp.gradientsecondcolor)),i},_setColor:function(t,e,i){var s,r,o,n,a,l,h,u,c=!0,d=t.visProp;return e=e||"stroke",i=i||e,s=this._getHighlighted(t),"linear"===(u=utils_type.A.evaluate(t.visProp.gradient))||"radial"===u?(this.context[i+"Style"]=this.updateGradient(t),c):("none"!==(o=utils_type.A.evaluate(d[s+e+"color"]))&&!1!==o?(l=(l=utils_type.A.evaluate(d[s+e+"opacity"]))>0?l:0,9!==o.length?(a=o,h=l):(a=(n=utils_color.A.rgba2rgbo(o))[0],h=l*n[1]),this.context.globalAlpha=h,this.context[i+"Style"]=a):c=!1,r=parseFloat(utils_type.A.evaluate(d[s+"strokewidth"])),"stroke"!==e||isNaN(r)||(0===r?this.context.globalAlpha=0:this.context.lineWidth=r),"stroke"===e&&void 0!==d.linecap&&""!==d.linecap&&(this.context.lineCap=d.linecap),c)},_stroke:function(t){var e=this.context,i=utils_type.A.evaluate(t.visProp.dash),s=utils_type.A.evaluate(t.visProp.dashscale)?.5*utils_type.A.evaluate(t.visProp.strokewidth):1;e.save(),i>0?e.setLineDash&&e.setLineDash(this.dashArray[i-1].map((function(t){return t*s}))):this.context.lineDashArray=[],this._setColor(t,"stroke")&&e.stroke(),e.restore()},_translateShape:function(t,e,i){var s,r=[],o=t.length;if(o<=0)return t;for(s=0;s<o;s++)r.push([t[s][0]+e,t[s][1]+i]);return r},drawPoint:function(t){var e=utils_type.A.evaluate(t.visProp.face),i=utils_type.A.evaluate(t.visProp.size),s=t.coords.scrCoords,r=i*Math.sqrt(3)*.5,o=.5*i,n=parseFloat(utils_type.A.evaluate(t.visProp.strokewidth))/2,a=this.context;if(t.visPropCalc.visible)switch(e){case"cross":case"x":a.beginPath(),a.moveTo(s[1]-i,s[2]-i),a.lineTo(s[1]+i,s[2]+i),a.moveTo(s[1]+i,s[2]-i),a.lineTo(s[1]-i,s[2]+i),a.lineCap="round",a.lineJoin="round",a.closePath(),this._stroke(t);break;case"circle":case"o":a.beginPath(),a.arc(s[1],s[2],i+1+n,0,2*Math.PI,!1),a.closePath(),this._fill(t),this._stroke(t);break;case"square":case"[]":if(i<=0)break;a.save(),this._setColor(t,"stroke","fill")&&a.fillRect(s[1]-i-n,s[2]-i-n,2*i+3*n,2*i+3*n),a.restore(),a.save(),this._setColor(t,"fill"),a.fillRect(s[1]-i+n,s[2]-i+n,2*i-n,2*i-n),a.restore();break;case"plus":case"+":a.beginPath(),a.moveTo(s[1]-i,s[2]),a.lineTo(s[1]+i,s[2]),a.moveTo(s[1],s[2]-i),a.lineTo(s[1],s[2]+i),a.lineCap="round",a.lineJoin="round",a.closePath(),this._stroke(t);break;case"divide":case"|":a.beginPath(),a.moveTo(s[1],s[2]-i),a.lineTo(s[1],s[2]+i),a.lineCap="round",a.lineJoin="round",a.closePath(),this._stroke(t);break;case"minus":case"-":a.beginPath(),a.moveTo(s[1]-i,s[2]),a.lineTo(s[1]+i,s[2]),a.lineCap="round",a.lineJoin="round",a.closePath(),this._stroke(t);break;case"diamond2":case"<<>>":i*=1.41;case"diamond":case"<>":a.beginPath(),a.moveTo(s[1]-i,s[2]),a.lineTo(s[1],s[2]+i),a.lineTo(s[1]+i,s[2]),a.lineTo(s[1],s[2]-i),a.closePath(),this._fill(t),this._stroke(t);break;case"triangleup":case"A":case"a":case"^":a.beginPath(),a.moveTo(s[1],s[2]-i),a.lineTo(s[1]-r,s[2]+o),a.lineTo(s[1]+r,s[2]+o),a.closePath(),this._fill(t),this._stroke(t);break;case"triangledown":case"v":a.beginPath(),a.moveTo(s[1],s[2]+i),a.lineTo(s[1]-r,s[2]-o),a.lineTo(s[1]+r,s[2]-o),a.closePath(),this._fill(t),this._stroke(t);break;case"triangleleft":case"<":a.beginPath(),a.moveTo(s[1]-i,s[2]),a.lineTo(s[1]+o,s[2]-r),a.lineTo(s[1]+o,s[2]+r),a.closePath(),this._fill(t),this._stroke(t);break;case"triangleright":case">":a.beginPath(),a.moveTo(s[1]+i,s[2]),a.lineTo(s[1]-o,s[2]-r),a.lineTo(s[1]-o,s[2]+r),a.closePath(),this._fill(t),this._stroke(t)}},updatePoint:function(t){this.drawPoint(t)},drawArrows:function(t,e,i,s,r){var o,n,a,l,h,u,c,d,p,_,f,A,g,m,y,b,v,C,P,x,E=this.context,O=1,S=1,M=1,w=r.evFirst,T=r.evLast;if("none"!==utils_type.A.evaluate(t.visProp.strokecolor)&&(w||T)){if(t.elementClass===constants.A.OBJECT_CLASS_LINE)o=e.scrCoords[1],n=e.scrCoords[2],a=i.scrCoords[1],l=i.scrCoords[2],P=x=Math.atan2(l-n,a-o);else{if(o=t.points[0].scrCoords[1],n=t.points[0].scrCoords[2],(C=t.points.length-1)<1)return;a=t.points[t.points.length-1].scrCoords[1],l=t.points[t.points.length-1].scrCoords[2],m=t.points[1].scrCoords[1]-t.points[0].scrCoords[1],y=t.points[1].scrCoords[2]-t.points[0].scrCoords[2],b=t.points[C].scrCoords[1]-t.points[C-1].scrCoords[1],v=t.points[C].scrCoords[2]-t.points[C-1].scrCoords[2],w&&(P=Math.atan2(y,m)),T&&(x=Math.atan2(v,b))}if(h=utils_type.A.evaluate(t.visProp[s+"strokewidth"]),w)if(u=h*r.sizeFirst,p=O=r.typeFirst,2===O)d=[[u,.5*-u],[0,0],[u,.5*u],[.5*u,0]];else if(3===O)d=[[u/3,.5*-u],[0,.5*-u],[0,.5*u],[u/3,.5*u]];else if(4===O)for(u/=10,S=3,g=(d=[[10,3.31],[6.47,3.84],[2.87,4.5],[0,6.63],[.67,5.52],[1.33,4.42],[2,3.31],[1.33,2.21],[.67,1.1],[0,0],[2.87,2.13],[6.47,2.79],[10,3.31]]).length,A=0;A<g;A++)d[A][0]*=-u,d[A][1]*=u,d[A][0]+=10*u,d[A][1]-=3.31*u;else if(5===O)for(u/=10,S=3,g=(d=[[10,3.28],[6.61,4.19],[3.19,5.07],[0,6.55],[.62,5.56],[1,4.44],[1,3.28],[1,2.11],[.62,.99],[0,0],[3.19,1.49],[6.61,2.37],[10,3.28]]).length,A=0;A<g;A++)d[A][0]*=-u,d[A][1]*=u,d[A][0]+=10*u,d[A][1]-=3.28*u;else if(6===O)for(u/=10,S=3,g=(d=[[10,2.84],[6.61,3.59],[3.21,4.35],[0,5.68],[.33,4.73],[.67,3.78],[1,2.84],[.67,1.89],[.33,.95],[0,0],[3.21,1.33],[6.61,2.09],[10,2.84]]).length,A=0;A<g;A++)d[A][0]*=-u,d[A][1]*=u,d[A][0]+=10*u,d[A][1]-=2.84*u;else if(7===O)for(u=h,S=3,g=(d=[[0,10.39],[2.01,6.92],[5.96,5.2],[10,5.2],[5.96,5.2],[2.01,3.47],[0,0]]).length,A=0;A<g;A++)d[A][0]*=-u,d[A][1]*=u,d[A][0]+=10*u,d[A][1]-=5.2*u;else d=[[u,.5*-u],[0,0],[u,.5*u]];if(T)if(u=h*r.sizeLast,_=O=r.typeLast,2===O)c=[[-u,.5*-u],[0,0],[-u,.5*u],[.5*-u,0]];else if(3===O)c=[[-u/3,.5*-u],[0,.5*-u],[0,.5*u],[-u/3,.5*u]];else if(4===O)for(u/=10,M=3,g=(c=[[10,3.31],[6.47,3.84],[2.87,4.5],[0,6.63],[.67,5.52],[1.33,4.42],[2,3.31],[1.33,2.21],[.67,1.1],[0,0],[2.87,2.13],[6.47,2.79],[10,3.31]]).length,A=0;A<g;A++)c[A][0]*=u,c[A][1]*=u,c[A][0]-=10*u,c[A][1]-=3.31*u;else if(5===O)for(u/=10,M=3,g=(c=[[10,3.28],[6.61,4.19],[3.19,5.07],[0,6.55],[.62,5.56],[1,4.44],[1,3.28],[1,2.11],[.62,.99],[0,0],[3.19,1.49],[6.61,2.37],[10,3.28]]).length,A=0;A<g;A++)c[A][0]*=u,c[A][1]*=u,c[A][0]-=10*u,c[A][1]-=3.28*u;else if(6===O)for(u/=10,M=3,g=(c=[[10,2.84],[6.61,3.59],[3.21,4.35],[0,5.68],[.33,4.73],[.67,3.78],[1,2.84],[.67,1.89],[.33,.95],[0,0],[3.21,1.33],[6.61,2.09],[10,2.84]]).length,A=0;A<g;A++)c[A][0]*=u,c[A][1]*=u,c[A][0]-=10*u,c[A][1]-=2.84*u;else if(7===O)for(u=h,M=3,g=(c=[[0,10.39],[2.01,6.92],[5.96,5.2],[10,5.2],[5.96,5.2],[2.01,3.47],[0,0]]).length,A=0;A<g;A++)c[A][0]*=u,c[A][1]*=u,c[A][0]-=10*u,c[A][1]-=5.2*u;else c=[[-u,.5*-u],[0,0],[-u,.5*u]];E.save(),this._setColor(t,"stroke","fill")&&(this._setColor(t,"stroke"),w&&(f=7!==p,this._drawPolygon(this._translateShape(this._rotateShape(d,P),o,n),S,f)),T&&(f=7!==_,this._drawPolygon(this._translateShape(this._rotateShape(c,x),a,l),M,f))),E.restore()}},drawLine:function(t){var e,i,s,r,o,n=new base_coords.A(constants.A.COORDS_BY_USER,t.point1.coords.usrCoords,t.board),a=new base_coords.A(constants.A.COORDS_BY_USER,t.point2.coords.usrCoords,t.board),l=null;t.visPropCalc.visible&&(s=this._getHighlighted(t),r=utils_type.A.evaluate(t.visProp[s+"strokewidth"]),((o=this.getArrowHeadData(t,r,s)).evFirst||o.evLast)&&(l=-4),geometry.A.calcStraight(t,n,a,l),this.handleTouchpoints(t,n,a,o),e=new base_coords.A(constants.A.COORDS_BY_USER,n.usrCoords,t.board),i=new base_coords.A(constants.A.COORDS_BY_USER,a.usrCoords,t.board),this.getPositionArrowHead(t,n,a,o),this.context.beginPath(),this.context.moveTo(n.scrCoords[1],n.scrCoords[2]),this.context.lineTo(a.scrCoords[1],a.scrCoords[2]),this._stroke(t),(o.evFirst||o.evLast)&&this.drawArrows(t,e,i,s,o))},updateLine:function(t){this.drawLine(t)},drawTicks:function(){},updateTicks:function(t){var e,i,s,r,o,n,a=t.ticks.length,l=this.context;for(l.beginPath(),e=0;e<a;e++)for(s=(i=t.ticks[e])[0],r=i[1],o=s.length,l.moveTo(s[0],r[0]),n=1;n<o;++n)l.lineTo(s[n],r[n]);l.lineCap="round",this._stroke(t)},drawCurve:function(t){var e,i,s;utils_type.A.evaluate(t.visProp.handdrawing)?this.updatePathStringBezierPrim(t):this.updatePathStringPrim(t),t.numberPoints>1&&(e=this._getHighlighted(t),i=utils_type.A.evaluate(t.visProp[e+"strokewidth"]),((s=this.getArrowHeadData(t,i,e)).evFirst||s.evLast)&&this.drawArrows(t,null,null,e,s))},updateCurve:function(t){this.drawCurve(t)},drawEllipse:function(t){var e=t.center.coords.scrCoords[1],i=t.center.coords.scrCoords[2],s=t.board.unitX,r=t.board.unitY,o=2*t.Radius(),n=2*t.Radius(),a=o*s,l=n*r,h=e-a/2,u=i-l/2,c=a/2*.5522848,d=l/2*.5522848,p=h+a,_=u+l,f=h+a/2,A=u+l/2,g=this.context;o>0&&n>0&&!isNaN(e+i)&&(g.beginPath(),g.moveTo(h,A),g.bezierCurveTo(h,A-d,f-c,u,f,u),g.bezierCurveTo(f+c,u,p,A-d,p,A),g.bezierCurveTo(p,A+d,f+c,_,f,_),g.bezierCurveTo(f-c,_,h,A+d,h,A),g.closePath(),this._fill(t),this._stroke(t))},updateEllipse:function(t){return this.drawEllipse(t)},displayCopyright:function(t,e){var i=this.context;i.save(),i.font=e+"px Arial",i.fillStyle="#aaa",i.lineWidth=.5,i.fillText(t,10,2+e),i.restore()},drawInternalText:function(t){var e=utils_type.A.evaluate(t.visProp.fontsize),i=utils_type.A.evaluate(t.visProp.fontunit),s=t.getAnchorX(),r=t.getAnchorY(),o=this.context;return o.save(),this._setColor(t,"stroke","fill")&&!isNaN(t.coords.scrCoords[1]+t.coords.scrCoords[2])&&(o.font=(e>0?e:0)+i+" Arial",this.transformImage(t,t.transformations),"left"===s?o.textAlign="left":"right"===s?o.textAlign="right":"middle"===s&&(o.textAlign="center"),"bottom"===r?o.textBaseline="bottom":"top"===r?o.textBaseline="top":"middle"===r&&(o.textBaseline="middle"),o.fillText(t.plaintext,t.coords.scrCoords[1],t.coords.scrCoords[2])),o.restore(),null},updateInternalText:function(t){this.drawInternalText(t)},setObjectStrokeColor:function(t,e,i){var s,r,o,n,a=utils_type.A.evaluate(e),l=utils_type.A.evaluate(i);l=l>0?l:0,t.visPropOld.strokecolor===a&&t.visPropOld.strokeopacity===l||(utils_type.A.exists(a)&&!1!==a&&(9!==a.length?(s=a,o=l):(s=(r=utils_color.A.rgba2rgbo(a))[0],o=l*r[1]),n=t.rendNode,t.elementClass===constants.A.OBJECT_CLASS_TEXT&&"html"===utils_type.A.evaluate(t.visProp.display)&&(n.style.color=s,n.style.opacity=o)),t.visPropOld.strokecolor=a,t.visPropOld.strokeopacity=l)},drawImage:function(t){t.rendNode=new Image,t._src="",this.updateImage(t)},updateImage:function(t){var e=this.context,i=utils_type.A.evaluate(t.visProp.fillopacity),s=utils_type.A.bind((function(){t.imgIsLoaded=!0,t.size[0]<=0||t.size[1]<=0||(e.save(),e.globalAlpha=i,this.transformImage(t,t.transformations),e.drawImage(t.rendNode,t.coords.scrCoords[1],t.coords.scrCoords[2]-t.size[1],t.size[0],t.size[1]),e.restore())}),this);this.updateImageURL(t)?t.rendNode.onload=s:t.imgIsLoaded&&s()},transformImage:function(t,e){var i,s,r,o,n,a=e.length,l=this.context;if(a>0)if(i=this.joinTransforms(t,e),t.elementClass===constants.A.OBJECT_CLASS_TEXT&&"html"===t.visProp.display){if(-1===(s=" matrix("+[i[1][1],i[2][1],i[1][2],i[2][2],i[1][0],i[2][0]].join(",")+") ").indexOf("NaN")){switch((n=t.rendNode).style.transform=s,r=-t.coords.scrCoords[1],o=-t.coords.scrCoords[2],utils_type.A.evaluate(t.visProp.anchorx)){case"right":r+=t.size[0];break;case"middle":r+=.5*t.size[0]}switch(utils_type.A.evaluate(t.visProp.anchory)){case"bottom":o+=t.size[1];break;case"middle":o+=.5*t.size[1]}n.style["transform-origin"]=r+"px "+o+"px"}}else Math.abs(numerics.A.det(i))>=math.A.eps&&l.transform(i[1][1],i[2][1],i[1][2],i[2][2],i[1][0],i[2][0])},updateImageURL:function(t){var e;return e=utils_type.A.evaluate(t.url),t._src!==e&&(t.imgIsLoaded=!1,t.rendNode.src=e,t._src=e,!0)},remove:function(t){utils_type.A.exists(t)&&utils_type.A.exists(t.parentNode)&&t.parentNode.removeChild(t)},updatePathStringPrim:function(t){var e,i,s,r,o,n="M",a=n,l=5e3,h=this.context;if(!(t.numberPoints<=0)){if(o=Math.min(t.points.length,t.numberPoints),h.beginPath(),1===t.bezierDegree)for(e=0;e<o;e++)i=t.points[e].scrCoords,isNaN(i[1])||isNaN(i[2])?a=n:(i[1]>l?i[1]=l:i[1]<-5e3&&(i[1]=-5e3),i[2]>l?i[2]=l:i[2]<-5e3&&(i[2]=-5e3),a===n?h.moveTo(i[1],i[2]):h.lineTo(i[1],i[2]),a="L");else if(3===t.bezierDegree)for(e=0;e<o;)i=t.points[e].scrCoords,isNaN(i[1])||isNaN(i[2])?a=n:(a===n?h.moveTo(i[1],i[2]):(e+=1,s=t.points[e].scrCoords,e+=1,r=t.points[e].scrCoords,h.bezierCurveTo(i[1],i[2],s[1],s[2],r[1],r[2])),a="C"),e+=1;h.lineCap="round",this._fill(t),this._stroke(t)}},updatePathStringBezierPrim:function(t){var e,i,s,r,o,n,a,l="M",h=l,u=5e3,c=utils_type.A.evaluate(t.visProp.strokewidth),d="plot"!==utils_type.A.evaluate(t.visProp.curvetype),p=this.context;if(!(t.numberPoints<=0)){for(d&&t.board.options.curve.RDPsmoothing&&(t.points=numerics.A.RamerDouglasPeucker(t.points,.5)),a=Math.min(t.points.length,t.numberPoints),p.beginPath(),i=1;i<3;i++)for(h=l,e=0;e<a;e++)r=t.points[e].scrCoords,isNaN(r[1])||isNaN(r[2])?h=l:(r[1]>u?r[1]=u:r[1]<-5e3&&(r[1]=-5e3),r[2]>u?r[2]=u:r[2]<-5e3&&(r[2]=-5e3),h===l?p.moveTo(r[1],r[2]):(s=2*i,p.bezierCurveTo(o+.333*(r[1]-o)+c*(s*Math.random()-i),n+.333*(r[2]-n)+c*(s*Math.random()-i),o+.666*(r[1]-o)+c*(s*Math.random()-i),n+.666*(r[2]-n)+c*(s*Math.random()-i),r[1],r[2])),h="C",o=r[1],n=r[2]);p.lineCap="round",this._fill(t),this._stroke(t)}},updatePolygonPrim:function(t,e){var i,s,r,o=e.vertices.length,n=this.context,a=!0;if(!(o<=0)&&e.visPropCalc.visible){for("polygonalchain"===e.elType&&o++,n.beginPath(),s=0;!e.vertices[s].isReal&&s<o-1;)s++,a=!1;for(i=e.vertices[s].coords.scrCoords,n.moveTo(i[1],i[2]),r=s;r<o-1;r++)e.vertices[r].isReal||(a=!1),i=e.vertices[r].coords.scrCoords,n.lineTo(i[1],i[2]);n.closePath(),a&&this._fill(e)}},display:function(t,e){t&&t.rendNode&&(t.visPropOld.visible=e,t.rendNode.style.visibility=e?"inherit":"hidden")},show:function(t){jxg.A.deprecated("Board.renderer.show()","Board.renderer.display()"),utils_type.A.exists(t.rendNode)&&(t.rendNode.style.visibility="inherit")},hide:function(t){jxg.A.deprecated("Board.renderer.hide()","Board.renderer.display()"),utils_type.A.exists(t.rendNode)&&(t.rendNode.style.visibility="hidden")},setGradient:function(t){},setShadow:function(t){t.visPropOld.shadow!==t.visProp.shadow&&(t.visPropOld.shadow=t.visProp.shadow)},highlight:function(t){return t.elementClass===constants.A.OBJECT_CLASS_TEXT&&"html"===utils_type.A.evaluate(t.visProp.display)?this.updateTextStyle(t,!0):(t.board.prepareUpdate(),t.board.renderer.suspendRedraw(t.board),t.board.updateRenderer(),t.board.renderer.unsuspendRedraw()),this},noHighlight:function(t){return t.elementClass===constants.A.OBJECT_CLASS_TEXT&&"html"===utils_type.A.evaluate(t.visProp.display)?this.updateTextStyle(t,!1):(t.board.prepareUpdate(),t.board.renderer.suspendRedraw(t.board),t.board.updateRenderer(),t.board.renderer.unsuspendRedraw()),this},suspendRedraw:function(t){this.context.save(),this.context.clearRect(0,0,this.canvasRoot.width,this.canvasRoot.height),t&&t.attr.showcopyright&&this.displayCopyright(jxg.A.licenseText,12)},unsuspendRedraw:function(){this.context.restore()},resize:function(t,e){this.container?(this.canvasRoot.style.width=parseFloat(t)+"px",this.canvasRoot.style.height=parseFloat(e)+"px",this.canvasRoot.setAttribute("width",2*parseFloat(t)+"px"),this.canvasRoot.setAttribute("height",2*parseFloat(e)+"px")):(this.canvasRoot.width=2*parseFloat(t),this.canvasRoot.height=2*parseFloat(e)),this.context=this.canvasRoot.getContext("2d"),this.context.scale(2,2)},removeToInsertLater:function(){return function(){}}});var canvas=jxg.A.CanvasRenderer;jxg.A.NoRenderer=function(){this.enhancedRendering=!1,this.type="no"},jxg.A.extend(jxg.A.NoRenderer.prototype,{drawPoint:function(t){},updatePoint:function(t){},changePointStyle:function(t){},drawLine:function(t){},updateLine:function(t){},drawTicks:function(t){},updateTicks:function(t){},drawCurve:function(t){},updateCurve:function(t){},drawEllipse:function(t){},updateEllipse:function(t){},drawPolygon:function(t){},updatePolygon:function(t){},displayCopyright:function(t,e){},drawInternalText:function(t){},updateInternalText:function(t){},drawText:function(t){},updateText:function(t){},updateTextStyle:function(t,e){},updateInternalTextStyle:function(t,e,i){},drawImage:function(t){},updateImage:function(t){},transformImage:function(t,e){},updateImageURL:function(t){},appendChildPrim:function(t,e){},appendNodesToElement:function(t,e){},createPrim:function(t,e){return null},remove:function(t){},makeArrows:function(t){},updateEllipsePrim:function(t,e,i,s,r){},updateLinePrim:function(t,e,i,s,r,o){},updatePathPrim:function(t,e,i){},updatePathStringPoint:function(t,e,i){},updatePathStringPrim:function(t){},updatePathStringBezierPrim:function(t){},updatePolygonPrim:function(t,e){},updateRectPrim:function(t,e,i,s,r){},setPropertyPrim:function(t,e,i){},display:function(t,e){t&&(t.visPropOld.visible=e)},show:function(t){},hide:function(t){},setBuffering:function(t,e){},setDashStyle:function(t){},setDraft:function(t){},removeDraft:function(t){},setGradient:function(t){},updateGradient:function(t){},setObjectTransition:function(t,e){},setObjectFillColor:function(t,e,i){},setObjectStrokeColor:function(t,e,i){},setObjectStrokeWidth:function(t,e){},setShadow:function(t){},highlight:function(t){},noHighlight:function(t){},suspendRedraw:function(){},unsuspendRedraw:function(){},drawNavigationBar:function(t){},getElementById:function(t){return null},resize:function(t,e){},removeToInsertLater:function(){return function(){}}}),jxg.A.NoRenderer.prototype=new renderer_abstract;var no=jxg.A.NoRenderer;jxg.A.JSXGraph={rendererType:(src_options.A.board.renderer="no",env.A.supportsVML()&&(src_options.A.board.renderer="vml",document.onmousemove=function(){var t;return document.body&&(t=document.body.scrollLeft,t+=document.body.scrollTop),t}),env.A.supportsCanvas()&&(src_options.A.board.renderer="canvas"),env.A.supportsSVG()&&(src_options.A.board.renderer="svg"),env.A.isNode()&&env.A.supportsCanvas()&&(src_options.A.board.renderer="canvas"),(env.A.isNode()||"no"===src_options.A.renderer)&&(src_options.A.text.display="internal",src_options.A.infobox.display="internal"),src_options.A.board.renderer),initRenderer:function(t,e,i,s){var r;if(utils_type.A.exists(i)&&!1!==i||"object"!=typeof document||(i=document),"object"==typeof i&&null!==t)for(r=utils_type.A.isString(t)?i.getElementById(t):t;r.firstChild;)r.removeChild(r.firstChild);else r=t;return void 0!==s&&"auto"!==s||(s=this.rendererType),"svg"===s?new svg(r,e):"vml"===s?new vml(r):"canvas"===s?new canvas(r,e):new no},_setAttributes:function(t,e){var i,s,r=utils_type.A.copyAttributes(t,e,"board"),o=["drag","fullscreen","intl","keyboard","logging","navbar","pan","resize","screenshot","selection","zoom"],n=o.length;for(i=0;i<n;i++)r[s=o[i]]=utils_type.A.copyAttributes(r,e,"board",s);return r.movetarget=t.moveTarget||t.movetarget||e.board.moveTarget,r},_fillBoard:function(t,e,i){t.initInfobox(e.infobox),t.maxboundingbox=e.maxboundingbox,t.resizeContainer(i.width,i.height,!0,!0),t._createSelectionPolygon(e),t.renderer.drawNavigationBar(t,e.navbar),jxg.A.boards[t.id]=t},_setARIA:function(t,e){var i,s,r,o,n,a,l=e.document;if("object"!=typeof l){if(!env.A.isBrowser)return;l=document}i=(s=utils_type.A.isString(t)?l.getElementById(t):t).ownerDocument,o=s.parentNode,n=t+"_ARIAlabel",a=t+"_ARIAdescription",(r=i.createElement("div")).innerHTML=e.title,r.setAttribute("id",n),r.style.display="none",o.insertBefore(r,s),(r=i.createElement("div")).innerHTML=e.description,r.setAttribute("id",a),r.style.display="none",o.insertBefore(r,s),s.setAttribute("aria-labelledby",n),s.setAttribute("aria-describedby",a)},_removeARIANodes:function(t){var e,i,s;"object"==typeof(s=t.document||document)&&(i=t.containerObj.getAttribute("aria-labelledby"),(e=s.getElementById(i))&&e.parentNode&&e.parentNode.removeChild(e),i=t.containerObj.getAttribute("aria-describedby"),(e=s.getElementById(i))&&e.parentNode&&e.parentNode.removeChild(e))},initBoard:function(t,e){var i,s,r,o,n,a,l,h,u,c,d,p,_,f,A,g=0,m=0,y={};return"default"!==(e=e||{}).theme&&utils_type.A.exists(jxg.A.themes[e.theme])&&(y=jxg.A.themes[e.theme]),f=utils_type.A.deepCopy(src_options.A,y,!0),c=this._setAttributes(e,f),h=env.A.getDimensions(t,c.document),c.unitx||c.unity?(i=utils_type.A.def(c.originx,150),s=utils_type.A.def(c.originy,150),r=utils_type.A.def(c.unitx,50),o=utils_type.A.def(c.unity,50)):((u=c.boundingbox)[0]<c.maxboundingbox[0]&&(u[0]=c.maxboundingbox[0]),u[1]>c.maxboundingbox[1]&&(u[1]=c.maxboundingbox[1]),u[2]>c.maxboundingbox[2]&&(u[2]=c.maxboundingbox[2]),u[3]<c.maxboundingbox[3]&&(u[3]=c.maxboundingbox[3]),n=Math.max(parseInt(h.width,10),math.A.eps),a=Math.max(parseInt(h.height,10),math.A.eps),utils_type.A.exists(u)&&c.keepaspectratio?(r=n/(u[2]-u[0]),o=a/(u[1]-u[3]),Math.abs(r)<Math.abs(o)?m=.5*(a/(o=Math.abs(r)*o/Math.abs(o))-(u[1]-u[3])):g=.5*(n/(r=Math.abs(o)*r/Math.abs(r))-(u[2]-u[0]))):(r=n/(u[2]-u[0]),o=a/(u[1]-u[3])),i=-r*(u[0]-g),s=o*(u[1]+m)),l=this.initRenderer(t,h,c.document,c.renderer),this._setARIA(t,c),(A=new base_board(t,l,c.id,[i,s],c.zoomx,c.zoomy,r,o,h.width,h.height,c)).keepaspectratio=c.keepaspectratio,this._fillBoard(A,c,h),A.suspendUpdate(),(c=A.attr).axis&&(d="object"==typeof c.axis?c.axis:{},p=utils_type.A.deepCopy(f.board.defaultaxes.x,d),_=utils_type.A.deepCopy(f.board.defaultaxes.y,d),c.defaultaxes.x&&(p=utils_type.A.deepCopy(p,c.defaultaxes.x)),c.defaultaxes.y&&(_=utils_type.A.deepCopy(_,c.defaultaxes.y)),A.defaultAxes={},A.defaultAxes.x=A.create("axis",[[0,0],[1,0]],p),A.defaultAxes.y=A.create("axis",[[0,0],[0,1]],_)),c.grid&&A.create("grid",[],"object"==typeof c.grid?c.grid:{}),A.unsuspendUpdate(),A},loadBoardFromFile:function(t,e,i,s,r){var o,n,a,l,h;return s=s||{},o=this._setAttributes(s),l=env.A.getDimensions(t,o.document),n=this.initRenderer(t,l,o.document,o.renderer),this._setARIA(t,o),a=new base_board(t,n,"",[150,150],1,1,50,50,l.width,l.height,o),this._fillBoard(a,o,l),h=o.encoding||"iso-8859-1",reader_file.parseFileContent(e,a,i,!0,h,r),a},loadBoardFromString:function(t,e,i,s,r){var o,n,a,l;return s=s||{},o=this._setAttributes(s),l=env.A.getDimensions(t,o.document),n=this.initRenderer(t,l,o.document,o.renderer),this._setARIA(t,o),a=new base_board(t,n,"",[150,150],1,1,50,50,l.width,l.height,o),this._fillBoard(a,o,l),reader_file.parseString(e,a,i,!0,r),a},freeBoard:function(t){var e;for(e in"string"==typeof t&&(t=jxg.A.boards[t]),this._removeARIANodes(t),t.removeEventHandlers(),t.suspendUpdate(),t.objects)t.objects.hasOwnProperty(e)&&t.objects[e].remove();for(;t.containerObj.firstChild;)t.containerObj.removeChild(t.containerObj.firstChild);for(e in t.objects)t.objects.hasOwnProperty(e)&&delete t.objects[e];delete t.renderer,t.jc.creator.clearCache(),delete t.jc,delete jxg.A.boards[t.id]},registerElement:function(t,e){jxg.A.deprecated("JXG.JSXGraph.registerElement()","JXG.registerElement()"),jxg.A.registerElement(t,e)}},env.A.isBrowser&&"object"==typeof window&&"object"==typeof document&&env.A.addEvent(window,"load",(function(){var t,e,i,s,r,o,n,a,l,h,u,c,d,p,_,f,A,g,m=!1,y=document.getElementsByTagName("script"),b=function(t,e,i){var s=jxg.A.JSXGraph.initBoard(r,{boundingbox:i,keepaspectratio:!0,grid:_,axis:p,showReload:!0});if(e.toLowerCase().indexOf("script")>-1)s.construct(t);else try{s.jc.parse(t)}catch(t){jxg.A.debug(t)}return s},v=function(t,e,i,s){return function(){var r;jxg.A.JSXGraph.freeBoard(t),(r=b(e,i,s)).reload=v(r,e,i,s)}};for(e=0;e<y.length;e++)if(t=y[e].getAttribute("type",!1),utils_type.A.exists(t)&&("text/jessiescript"===t.toLowerCase()||"jessiescript"===t.toLowerCase()||"text/jessiecode"===t.toLowerCase()||"jessiecode"===t.toLowerCase())){if(c=y[e].getAttribute("class",!1)||"",a=y[e].getAttribute("width",!1)||"",l=y[e].getAttribute("height",!1)||"",h=y[e].getAttribute("maxwidth",!1)||"100%",u=y[e].getAttribute("aspectratio",!1)||"1/1",d=y[e].getAttribute("boundingbox",!1)||"-5, 5, 5, -5",r=y[e].getAttribute("container",!1),A=y[e].getAttribute("src",!1),4!==(d=d.split(",")).length)d=[-5,5,5,-5];else for(i=0;i<d.length;i++)d[i]=parseFloat(d[i]);if(p=utils_type.A.str2Bool(y[e].getAttribute("axis",!1)||"false"),_=utils_type.A.str2Bool(y[e].getAttribute("grid",!1)||"false"),utils_type.A.exists(r))s=document.getElementById(r);else{r="jessiescript_autgen_jxg_"+e,(s=document.createElement("div")).setAttribute("id",r),n=""!==a?"width:"+a+";":"",n+=""!==l?"height:"+l+";":"",n+=""!==h?"max-width:"+h+";":"",n+=""!==u?"aspect-ratio:"+u+";":"",s.setAttribute("style",n),s.setAttribute("class","jxgbox "+c);try{document.body.insertBefore(s,y[e])}catch(t){"object"==typeof jQuery&&jQuery(s).insertBefore(y[e])}}f="",utils_type.A.exists(A)?(m=!0,(g=new XMLHttpRequest).open("GET",A),g.overrideMimeType("text/plain; charset=x-user-defined"),g.addEventListener("load",(function(){if(!(this.status<400))throw new Error("\nJSXGraph: failed to load file",A,":",this.responseText);f=this.responseText+"\n"+f,(o=b(f,t,d)).reload=v(o,f,t,d)})),g.addEventListener("error",(function(t){throw new Error("\nJSXGraph: failed to load file",A,":",t)})),g.send()):m=!1,document.getElementById(r)?(f=(f=y[e].innerHTML).replace(/<!\[CDATA\[/g,"").replace(/\]\]>/g,""),y[e].innerHTML=f,m||((o=b(f,t,d)).reload=v(o,f,t,d))):jxg.A.debug("JSXGraph: Apparently the div injection failed. Can't create a board, sorry.")}}),window);var jsxgraph=jxg.A.JSXGraph,base_element=__webpack_require__(144),coordselement=__webpack_require__(102);jxg.A.Point=function(t,e,i){this.constructor(t,i,constants.A.OBJECT_TYPE_POINT,constants.A.OBJECT_CLASS_POINT),this.element=this.board.select(i.anchor),this.coordsConstructor(e),this.elType="point",this.id=this.board.setId(this,"P"),this.board.renderer.drawPoint(this),this.board.finalizeAdding(this),this.createGradient(),this.createLabel()},jxg.A.Point.prototype=new base_element.A,utils_type.A.copyPrototypeMethods(jxg.A.Point,coordselement.A,"coordsConstructor"),jxg.A.extend(jxg.A.Point.prototype,{hasPoint:function(t,e){var i,s,r,o=this.coords.scrCoords,n=utils_type.A.evaluate(this.visProp.sizeunit);return utils_type.A.isObject(utils_type.A.evaluate(this.visProp.precision))?(r=this.board._inputDevice,s=utils_type.A.evaluate(this.visProp.precision[r])):s=this.board.options.precision.hasPoint,i=parseFloat(utils_type.A.evaluate(this.visProp.size)),"user"===n&&(i*=Math.sqrt(Math.abs(this.board.unitX*this.board.unitY))),(i+=.5*parseFloat(utils_type.A.evaluate(this.visProp.strokewidth)))<s&&(i=s),Math.abs(o[1]-t)<i+2&&Math.abs(o[2]-e)<i+2},update:function(t){return this.needsUpdate?(this.updateCoords(t),utils_type.A.evaluate(this.visProp.trace)&&this.cloneToBackground(!0),this):this},updateTransform:function(t){var e,i;if(0===this.transformations.length||null===this.baseElement)return this;for(this===this.baseElement?(e=this.transformations[0].apply(this.baseElement,"self"),this.coords.setCoordinates(constants.A.COORDS_BY_USER,e)):e=this.transformations[0].apply(this.baseElement),this.coords.setCoordinates(constants.A.COORDS_BY_USER,e),i=1;i<this.transformations.length;i++)this.coords.setCoordinates(constants.A.COORDS_BY_USER,this.transformations[i].apply(this));return this},updateRenderer:function(){return this.updateRendererGeneric("updatePoint"),this},bounds:function(){return this.coords.usrCoords.slice(1).concat(this.coords.usrCoords.slice(1))},makeIntersection:function(t,e,i,s){var r;t=this.board.select(t),e=this.board.select(e),r=geometry.A.intersectionFunction(this.board,t,e,i,s,this.visProp.alwaysintersect),this.addConstraint([r]);try{t.addChild(this),e.addChild(this)}catch(i){throw new Error("JSXGraph: Can't create 'intersection' with parent types '"+typeof t+"' and '"+typeof e+"'.")}this.type=constants.A.OBJECT_TYPE_INTERSECTION,this.elType="intersection",this.parents=[t.id,e.id,i,s],this.generatePolynomial=function(){var i=t.generatePolynomial(this),s=e.generatePolynomial(this);return 0===i.length||0===s.length?[]:[i[0],s[0]]},this.prepareUpdate().update()},setStyle:function(t){return this.visProp.face=["cross","cross","cross","circle","circle","circle","circle","square","square","square","plus","plus","plus"][t],this.visProp.size=[2,3,4,1,2,3,4,2,3,4,2,3,4][t],this.board.renderer.changePointStyle(this),this},normalizeFace:function(t){return jxg.A.deprecated("Point.normalizeFace()","JXG.normalizePointFace()"),src_options.A.normalizePointFace(t)},face:function(t){jxg.A.deprecated("Point.face()","Point.setAttribute()"),this.setAttribute({face:t})},size:function(t){jxg.A.deprecated("Point.size()","Point.setAttribute()"),this.setAttribute({size:t})},isOn:function(t,e){var i,s;return e=e||math.A.eps,utils_type.A.isPoint(t)?this.Dist(t)<e:t.elementClass===constants.A.OBJECT_CLASS_LINE?("segment"!==t.elType||utils_type.A.evaluate(this.visProp.alwaysintersect)||(i=jxg.A.Math.Geometry.projectCoordsToSegment(this.coords.usrCoords,t.point1.coords.usrCoords,t.point2.coords.usrCoords))[1]>=0&&i[1]<=1)&&geometry.A.distPointLine(this.coords.usrCoords,t.stdform)<e:t.elementClass===constants.A.OBJECT_CLASS_CIRCLE?utils_type.A.evaluate(t.visProp.hasinnerpoints)?this.Dist(t.center)<t.Radius()+e:Math.abs(this.Dist(t.center)-t.Radius())<e:t.elementClass===constants.A.OBJECT_CLASS_CURVE?(s=geometry.A.projectPointToCurve(this,t,this.board)[0],geometry.A.distance(this.coords.usrCoords,s.usrCoords,3)<e):t.type===constants.A.OBJECT_TYPE_POLYGON?!(!utils_type.A.evaluate(t.visProp.hasinnerpoints)||!t.pnpoly(this.coords.usrCoords[1],this.coords.usrCoords[2],jxg.A.COORDS_BY_USER))||(i=geometry.A.projectCoordsToPolygon(this.coords.usrCoords,t),geometry.A.distance(this.coords.usrCoords,i,3)<e):t.type===constants.A.OBJECT_TYPE_TURTLE&&(s=geometry.A.projectPointToTurtle(this,t,this.board),geometry.A.distance(this.coords.usrCoords,s.usrCoords,3)<e)},cloneToBackground:function(){var t={};return t.id=this.id+"T"+this.numTraces,this.numTraces+=1,t.coords=this.coords,t.visProp=utils_type.A.deepCopy(this.visProp,this.visProp.traceattributes,!0),t.visProp.layer=this.board.options.layer.trace,t.elementClass=constants.A.OBJECT_CLASS_POINT,t.board=this.board,utils_type.A.clearVisPropOld(t),t.visPropCalc={visible:utils_type.A.evaluate(t.visProp.visible)},this.board.renderer.drawPoint(t),this.traces[t.id]=t.rendNode,this}}),jxg.A.createPoint=function(t,e,i){var s,r;if(r=utils_type.A.copyAttributes(i,t.options,"point"),!(s=coordselement.A.create(jxg.A.Point,t,e,r)))throw new Error("JSXGraph: Can't create point with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [x,y], [z,x,y], [element,transformation]");return s},jxg.A.createGlider=function(t,e,i){var s,r,o=utils_type.A.copyAttributes(i,t.options,"glider");return r=1===e.length?[0,0]:e.slice(0,2),(s=t.create("point",r,o)).makeGlider(e[e.length-1]),s},jxg.A.createIntersectionPoint=function(t,e,i){var s,r,o,n,a,l,h=utils_type.A.copyAttributes(i,t.options,"intersection");e.push(0,0),r=t.select(e[0]),o=t.select(e[1]),a=e[2]||0,l=e[3]||0,s=t.create("point",[0,0,0],h),n=geometry.A.intersectionFunction(t,r,o,a,l,s.visProp.alwaysintersect),s.addConstraint([n]);try{r.addChild(s),o.addChild(s)}catch(t){throw new Error("JSXGraph: Can't create 'intersection' with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.")}return s.type=constants.A.OBJECT_TYPE_INTERSECTION,s.elType="intersection",s.setParents([r.id,o.id]),s.intersectionNumbers=[a,l],s.getParents=function(){return this.parents.concat(this.intersectionNumbers)},s.generatePolynomial=function(){var t=r.generatePolynomial(s),e=o.generatePolynomial(s);return 0===t.length||0===e.length?[]:[t[0],e[0]]},s},jxg.A.createOtherIntersectionPoint=function(t,e,i){var s,r,o,n,a,l,h,u=!0,c=utils_type.A.copyAttributes(i,t.options,"otherintersection");if(3!==e.length)u=!1;else{for(r=t.select(e[0]),o=t.select(e[1]),a=utils_type.A.isArray(e[2])?e[2]:[e[2]],n=0;n<a.length;n++)if(a[n]=t.select(a[n]),!utils_type.A.isPoint(a[n])){u=!1;break}u&&((h=[r,o]).sort((function(t,e){return e.elementClass-t.elementClass})),([constants.A.OBJECT_CLASS_CIRCLE,constants.A.OBJECT_CLASS_CURVE].indexOf(h[0].elementClass)<0||[constants.A.OBJECT_CLASS_CIRCLE,constants.A.OBJECT_CLASS_CURVE,constants.A.OBJECT_CLASS_LINE].indexOf(h[1].elementClass)<0)&&(u=!1))}if(!u)throw new Error("JSXGraph: Can't create 'other intersection point' with parent types '"+typeof e[0]+"',  '"+typeof e[1]+"'and  '"+typeof e[2]+"'.\nPossible parent types: [circle|curve|line,circle|curve|line, point], not two lines");return s=t.create("point",[0,0,0],c),l=geometry.A.otherIntersectionFunction(h,a,s.visProp.alwaysintersect,s.visProp.precision),s.addConstraint([l]),s.type=constants.A.OBJECT_TYPE_INTERSECTION,s.elType="otherintersection",s.setParents([r.id,o.id]),s.addParents(a),r.addChild(s),o.addChild(s),r.elementClass===constants.A.OBJECT_CLASS_CIRCLE&&(s.generatePolynomial=function(){var t=r.generatePolynomial(s),e=o.generatePolynomial(s);return 0===t.length||0===e.length?[]:[t[0],e[0]]}),s},jxg.A.createPolePoint=function(t,e,i){var s,r,o,n,a,l,h;if(e.length>1&&(n=e[0].type===constants.A.OBJECT_TYPE_CONIC||e[0].elementClass===constants.A.OBJECT_CLASS_CIRCLE,a=e[1].type===constants.A.OBJECT_TYPE_CONIC||e[1].elementClass===constants.A.OBJECT_CLASS_CIRCLE,l=e[0].elementClass===constants.A.OBJECT_CLASS_LINE,h=e[1].elementClass===constants.A.OBJECT_CLASS_LINE),2!==e.length||!(n&&h||l&&a))throw new Error("JSXGraph: Can't create 'pole point' with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent type: [conic|circle,line], [line,conic|circle]");return h?(r=t.select(e[0]),o=t.select(e[1])):(r=t.select(e[1]),o=t.select(e[0])),(s=t.create("point",[function(){var t=r.quadraticform,e=o.stdform.slice(0,3);return[jxg.A.Math.Numerics.det([e,t[1],t[2]]),jxg.A.Math.Numerics.det([t[0],e,t[2]]),jxg.A.Math.Numerics.det([t[0],t[1],e])]}],i)).elType="polepoint",s.setParents([r.id,o.id]),r.addChild(s),o.addChild(s),s},jxg.A.registerElement("point",jxg.A.createPoint),jxg.A.registerElement("glider",jxg.A.createGlider),jxg.A.registerElement("intersection",jxg.A.createIntersectionPoint),jxg.A.registerElement("otherintersection",jxg.A.createOtherIntersectionPoint),jxg.A.registerElement("polepoint",jxg.A.createPolePoint);var point=jxg.A.Point;jxg.A.Line=function(t,e,i,s){this.constructor(t,s,constants.A.OBJECT_TYPE_LINE,constants.A.OBJECT_CLASS_LINE),this.point1=this.board.select(e),this.point2=this.board.select(i),this.ticks=[],this.defaultTicks=null,this.parentPolygon=null,this.id=this.board.setId(this,"L"),this.board.renderer.drawLine(this),this.board.finalizeAdding(this),this.elType="line",this.point1._is_new?(this.addChild(this.point1),delete this.point1._is_new):this.point1.addChild(this),this.point2._is_new?(this.addChild(this.point2),delete this.point2._is_new):this.point2.addChild(this),this.inherits.push(this.point1,this.point2),this.updateStdform(),this.createLabel(),this.methodMap=jxg.A.deepCopy(this.methodMap,{point1:"point1",point2:"point2",getSlope:"Slope",Slope:"Slope",Direction:"Direction",getRise:"getRise",Rise:"getRise",getYIntersect:"getRise",YIntersect:"getRise",getAngle:"getAngle",Angle:"getAngle",L:"L",length:"L",setFixedLength:"setFixedLength",setStraight:"setStraight"})},jxg.A.Line.prototype=new base_element.A,jxg.A.extend(jxg.A.Line.prototype,{hasPoint:function(t,e){var i,s,r,o,n,a,l,h,u,c=[],d=[1,t,e],p=utils_type.A.evaluate(this.visProp.strokewidth);return utils_type.A.isObject(utils_type.A.evaluate(this.visProp.precision))?(u=this.board._inputDevice,h=utils_type.A.evaluate(this.visProp.precision[u])):h=this.board.options.precision.hasPoint,h+=.5*p,c[0]=this.stdform[0]-this.stdform[1]*this.board.origin.scrCoords[1]/this.board.unitX+this.stdform[2]*this.board.origin.scrCoords[2]/this.board.unitY,c[1]=this.stdform[1]/this.board.unitX,c[2]=this.stdform[2]/-this.board.unitY,i=geometry.A.distPointLine(d,c),!(isNaN(i)||i>h)&&(!(!utils_type.A.evaluate(this.visProp.straightfirst)||!utils_type.A.evaluate(this.visProp.straightlast))||(r=this.point1.coords,o=this.point2.coords,s=[0,c[1],c[2]],s=math.A.crossProduct(s,d),(s=math.A.crossProduct(s,c))[1]/=s[0],s[2]/=s[0],s[0]=1,s=new base_coords.A(constants.A.COORDS_BY_SCREEN,s.slice(1),this.board).usrCoords,n=r.distance(constants.A.COORDS_BY_USER,o),r=r.usrCoords.slice(0),o=o.usrCoords.slice(0),n<math.A.eps?a=0:(n===Number.POSITIVE_INFINITY&&(n=1/math.A.eps,Math.abs(o[0])<math.A.eps?(n/=geometry.A.distance([0,0,0],o),o=[1,r[1]+o[1]*n,r[2]+o[2]*n]):(n/=geometry.A.distance([0,0,0],r),r=[1,o[1]+r[1]*n,o[2]+r[2]*n])),n=o[l=1]-r[l],Math.abs(n)<math.A.eps&&(n=o[l=2]-r[l]),a=(s[l]-r[l])/n),!(!utils_type.A.evaluate(this.visProp.straightfirst)&&a<0)&&!(!utils_type.A.evaluate(this.visProp.straightlast)&&a>1)))},update:function(){var t;return this.needsUpdate?(this.constrained&&(utils_type.A.isFunction(this.funps)?(t=this.funps())&&t.length&&2===t.length&&(this.point1=t[0],this.point2=t[1]):(utils_type.A.isFunction(this.funp1)&&(t=this.funp1(),utils_type.A.isPoint(t)?this.point1=t:t&&t.length&&2===t.length&&this.point1.setPositionDirectly(constants.A.COORDS_BY_USER,t)),utils_type.A.isFunction(this.funp2)&&(t=this.funp2(),utils_type.A.isPoint(t)?this.point2=t:t&&t.length&&2===t.length&&this.point2.setPositionDirectly(constants.A.COORDS_BY_USER,t)))),this.updateSegmentFixedLength(),this.updateStdform(),utils_type.A.evaluate(this.visProp.trace)&&this.cloneToBackground(!0),this):this},updateSegmentFixedLength:function(){var t,e,i,s,r,o,n,a;return this.hasFixedLength?(t=this.point1.Dist(this.point2),e=Math.abs(this.fixedLength()),i=this.fixedLengthOldCoords[0].distance(constants.A.COORDS_BY_USER,this.point1.coords),s=this.fixedLengthOldCoords[1].distance(constants.A.COORDS_BY_USER,this.point2.coords),(i>math.A.eps||s>math.A.eps||t!==e)&&(r=this.point1.isDraggable&&this.point1.type!==constants.A.OBJECT_TYPE_GLIDER&&!utils_type.A.evaluate(this.point1.visProp.fixed),o=this.point2.isDraggable&&this.point2.type!==constants.A.OBJECT_TYPE_GLIDER&&!utils_type.A.evaluate(this.point2.visProp.fixed),t>math.A.eps?i>s&&o||i<=s&&o&&!r?(this.point2.setPositionDirectly(constants.A.COORDS_BY_USER,[this.point1.X()+(this.point2.X()-this.point1.X())*e/t,this.point1.Y()+(this.point2.Y()-this.point1.Y())*e/t]),this.point2.fullUpdate()):(i<=s&&r||i>s&&r&&!o)&&(this.point1.setPositionDirectly(constants.A.COORDS_BY_USER,[this.point2.X()+(this.point1.X()-this.point2.X())*e/t,this.point2.Y()+(this.point1.Y()-this.point2.Y())*e/t]),this.point1.fullUpdate()):(n=Math.random()-.5,a=Math.random()-.5,t=math.A.hypot(n,a),o?(this.point2.setPositionDirectly(constants.A.COORDS_BY_USER,[this.point1.X()+n*e/t,this.point1.Y()+a*e/t]),this.point2.fullUpdate()):r&&(this.point1.setPositionDirectly(constants.A.COORDS_BY_USER,[this.point2.X()+n*e/t,this.point2.Y()+a*e/t]),this.point1.fullUpdate())),this.fixedLengthOldCoords[0].setCoordinates(constants.A.COORDS_BY_USER,this.point1.coords.usrCoords),this.fixedLengthOldCoords[1].setCoordinates(constants.A.COORDS_BY_USER,this.point2.coords.usrCoords)),this):this},updateStdform:function(){var t=math.A.crossProduct(this.point1.coords.usrCoords,this.point2.coords.usrCoords);this.stdform[0]=t[0],this.stdform[1]=t[1],this.stdform[2]=t[2],this.stdform[3]=0,this.normalize()},updateRenderer:function(){return this.needsUpdate?(this.visPropCalc.visible&&(this.isReal=!isNaN(this.point1.coords.usrCoords[1]+this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[1]+this.point2.coords.usrCoords[2])&&math.A.innerProduct(this.stdform,this.stdform,3)>=math.A.eps*math.A.eps,this.isReal||this.updateVisibility(!1)),this.visPropCalc.visible&&this.board.renderer.updateLine(this),this.hasLabel&&this.visPropCalc.visible&&this.label&&this.label.visPropCalc.visible&&this.isReal&&(this.label.update(),this.board.renderer.updateText(this.label)),this.setDisplayRendNode(),this.needsUpdate=!1,this):this},generatePolynomial:function(t){var e=this.point1.symbolic.x,i=this.point1.symbolic.y,s=this.point2.symbolic.x,r=this.point2.symbolic.y,o=t.symbolic.x,n=t.symbolic.y;return[["(",i,")*(",o,")-(",i,")*(",s,")+(",n,")*(",s,")-(",e,")*(",n,")+(",e,")*(",r,")-(",o,")*(",r,")"].join("")]},getRise:function(){return Math.abs(this.stdform[2])>=math.A.eps?-this.stdform[0]/this.stdform[2]:1/0},Slope:function(){return Math.abs(this.stdform[2])>=math.A.eps?-this.stdform[1]/this.stdform[2]:1/0},getSlope:function(){return this.Slope()},getAngle:function(){return Math.atan2(-this.stdform[1],this.stdform[2])},Direction:function(){var t=this.point1.coords.usrCoords,e=this.point2.coords.usrCoords;return 0===e[0]&&0!==t[0]?e.slice(1):0===t[0]&&0!==e[0]?[-t[1],-t[2]]:[e[1]-t[1],e[2]-t[2]]},isVertical:function(){var t=this.Direction();return 0===t[0]&&0!==t[1]},isHorizontal:function(){var t=this.Direction();return 0===t[1]&&0!==t[0]},setStraight:function(t,e){return this.visProp.straightfirst=t,this.visProp.straightlast=e,this.board.renderer.updateLine(this),this},getTextAnchor:function(){return new base_coords.A(constants.A.COORDS_BY_USER,[.5*(this.point2.X()+this.point1.X()),.5*(this.point2.Y()+this.point1.Y())],this.board)},setLabelRelativeCoords:function(t){utils_type.A.exists(this.label)&&(this.label.relativeCoords=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t[0],-t[1]],this.board))},getLabelAnchor:function(){var t,e,i,s,r,o,n,a,l=1.5,h=0,u=new base_coords.A(constants.A.COORDS_BY_USER,this.point1.coords.usrCoords,this.board),c=new base_coords.A(constants.A.COORDS_BY_USER,this.point2.coords.usrCoords,this.board),d=utils_type.A.evaluate(this.visProp.straightfirst),p=utils_type.A.evaluate(this.visProp.straightlast);if((d||p)&&geometry.A.calcStraight(this,u,c,0),u=u.scrCoords,c=c.scrCoords,!utils_type.A.exists(this.label))return new base_coords.A(constants.A.COORDS_BY_SCREEN,[NaN,NaN],this.board);if(i=utils_type.A.evaluate(this.label.visProp.position),!utils_type.A.isString(i))return new base_coords.A(constants.A.COORDS_BY_SCREEN,[NaN,NaN],this.board);if(i.indexOf("right")<0&&i.indexOf("left")<0)switch(i){case"last":t=c[1],e=c[2];break;case"first":t=u[1],e=u[2];break;case"lft":case"llft":case"ulft":u[1]<=c[1]?(t=u[1],e=u[2]):(t=c[1],e=c[2]);break;case"rt":case"lrt":case"urt":u[1]>c[1]?(t=u[1],e=u[2]):(t=c[1],e=c[2]);break;default:t=.5*(u[1]+c[1]),e=.5*(u[2]+c[2])}else s=utils_type.A.parsePosition(i),r=utils_type.A.parseNumber(s.pos,1,1),o=c[1]-u[1],n=c[2]-u[2],a=math.A.hypot(o,n),s.pos.indexOf("px")>=0||s.pos.indexOf("fr")>=0||s.pos.indexOf("%")>=0?(s.pos.indexOf("px")>=0&&(r/=a),t=u[1]+r*o,e=u[2]+r*n):(t=u[1]+r*this.board.unitX*o/a,e=u[2]+r*this.board.unitY*n/a),"left"===s.side?o*=-1:n*=-1,utils_type.A.exists(this.label)&&(l=.5*utils_type.A.evaluate(this.label.visProp.distance)/a),t+=n*this.label.size[0]*l,e+=o*this.label.size[1]*l;return(d||p)&&(utils_type.A.exists(this.label)&&(h=utils_type.A.evaluate(this.label.visProp.fontsize)),Math.abs(t)<math.A.eps?t=h:this.board.canvasWidth+math.A.eps>t&&t>this.board.canvasWidth-h-math.A.eps&&(t=this.board.canvasWidth-h),math.A.eps+h>e&&e>-math.A.eps?e=h:this.board.canvasHeight+math.A.eps>e&&e>this.board.canvasHeight-h-math.A.eps&&(e=this.board.canvasHeight-h)),new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board)},cloneToBackground:function(){var t,e,i,s={};return s.id=this.id+"T"+this.numTraces,s.elementClass=constants.A.OBJECT_CLASS_LINE,this.numTraces++,s.point1=this.point1,s.point2=this.point2,s.stdform=this.stdform,s.board=this.board,s.visProp=utils_type.A.deepCopy(this.visProp,this.visProp.traceattributes,!0),s.visProp.layer=this.board.options.layer.trace,utils_type.A.clearVisPropOld(s),s.visPropCalc={visible:utils_type.A.evaluate(s.visProp.visible)},e=this.getSlope(),t=this.getRise(),s.getSlope=function(){return e},s.getRise=function(){return t},i=this.board.renderer.enhancedRendering,this.board.renderer.enhancedRendering=!0,this.board.renderer.drawLine(s),this.board.renderer.enhancedRendering=i,this.traces[s.id]=s.rendNode,this},addTransform:function(t){var e,i=utils_type.A.isArray(t)?t:[t],s=i.length;for(e=0;e<s;e++)this.point1.transformations.push(i[e]),this.point2.transformations.push(i[e]);return this},snapToGrid:function(t){var e,i,s,r,o,n,a,l;return utils_type.A.evaluate(this.visProp.snaptogrid)?this.parents.length<3?(this.point1.handleSnapToGrid(!0,!0),this.point2.handleSnapToGrid(!0,!0)):utils_type.A.exists(t)&&(a=utils_type.A.evaluate(this.visProp.snapsizex),l=utils_type.A.evaluate(this.visProp.snapsizey),o=(e=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t.Xprev,t.Yprev],this.board)).usrCoords[1],n=e.usrCoords[2],a<=0&&this.board.defaultAxes&&this.board.defaultAxes.x.defaultTicks&&(a=(r=this.board.defaultAxes.x.defaultTicks).ticksDelta*(utils_type.A.evaluate(r.visProp.minorticks)+1)),l<=0&&this.board.defaultAxes&&this.board.defaultAxes.y.defaultTicks&&(l=(r=this.board.defaultAxes.y.defaultTicks).ticksDelta*(utils_type.A.evaluate(r.visProp.minorticks)+1)),a>0&&l>0&&(i=geometry.A.projectPointToLine({coords:e},this,this.board),s=statistics.A.subtract([1,Math.round(o/a)*a,Math.round(n/l)*l],i.usrCoords),this.board.create("transform",s.slice(1),{type:"translate"}).applyOnce([this.point1,this.point2]))):(this.point1.handleSnapToGrid(!1,!0),this.point2.handleSnapToGrid(!1,!0)),this},snapToPoints:function(){var t=utils_type.A.evaluate(this.visProp.snaptopoints);return this.parents.length<3&&(this.point1.handleSnapToPoints(t),this.point2.handleSnapToPoints(t)),this},X:function(t){var e,i=this.stdform[2];return e=Math.abs(this.point1.coords.usrCoords[0])>math.A.eps?this.point1.coords.usrCoords[1]:this.point2.coords.usrCoords[1],t=2*(t-.5),(1-Math.abs(t))*e-t*i},Y:function(t){var e,i=this.stdform[1];return e=Math.abs(this.point1.coords.usrCoords[0])>math.A.eps?this.point1.coords.usrCoords[2]:this.point2.coords.usrCoords[2],t=2*(t-.5),(1-Math.abs(t))*e+t*i},Z:function(t){var e=Math.abs(this.point1.coords.usrCoords[0])>math.A.eps?this.point1.coords.usrCoords[0]:this.point2.coords.usrCoords[0];return t=2*(t-.5),(1-Math.abs(t))*e},L:function(){return this.point1.Dist(this.point2)},setFixedLength:function(t){return this.hasFixedLength?(this.fixedLength=utils_type.A.createFunction(t,this.board),this.board.update(),this):this},minX:function(){return 0},maxX:function(){return 1},bounds:function(){var t=this.point1.coords.usrCoords,e=this.point2.coords.usrCoords;return[Math.min(t[1],e[1]),Math.max(t[2],e[2]),Math.max(t[1],e[1]),Math.min(t[2],e[2])]},remove:function(){this.removeAllTicks(),base_element.A.prototype.remove.call(this)}}),jxg.A.createLine=function(t,e,i){var s,r,o,n,a,l,h,u=[],c=!1,d=!1;if(2===e.length){if(l=utils_type.A.copyAttributes(i,t.options,"line","point1"),utils_type.A.isArray(e[0])&&e[0].length>1)o=t.create("point",e[0],l);else if(utils_type.A.isString(e[0])||utils_type.A.isPoint(e[0]))o=t.select(e[0]);else if(utils_type.A.isFunction(e[0])&&utils_type.A.isPoint(e[0]()))o=e[0](),d=!0;else if(utils_type.A.isFunction(e[0])&&e[0]().length&&e[0]().length>=2)o=jxg.A.createPoint(t,e[0](),l),d=!0;else{if(!utils_type.A.isObject(e[0])||!utils_type.A.isTransformationOrArray(e[1]))throw new Error("JSXGraph: Can't create line with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]");c=!0,o=t.create("point",[e[0].point1,e[1]],l)}if(l=utils_type.A.copyAttributes(i,t.options,"line","point2"),c)n=t.create("point",[e[0].point2,e[1]],l);else if(utils_type.A.isArray(e[1])&&e[1].length>1)n=t.create("point",e[1],l);else if(utils_type.A.isString(e[1])||utils_type.A.isPoint(e[1]))n=t.select(e[1]);else if(utils_type.A.isFunction(e[1])&&utils_type.A.isPoint(e[1]()))n=e[1](),d=!0;else{if(!(utils_type.A.isFunction(e[1])&&e[1]().length&&e[1]().length>=2))throw new Error("JSXGraph: Can't create line with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]");n=jxg.A.createPoint(t,e[1](),l),d=!0}l=utils_type.A.copyAttributes(i,t.options,"line"),r=new jxg.A.Line(t,o,n,l),d?(r.constrained=!0,r.funp1=e[0],r.funp2=e[1]):c||(r.isDraggable=!0),r.setParents([o.id,n.id])}else if(3===e.length){for(h=!0,a=0;a<3;a++)if(utils_type.A.isNumber(e[a]))u[a]=utils_type.A.createFunction(e[a]);else{if(!utils_type.A.isFunction(e[a]))throw new Error("JSXGraph: Can't create line with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]");u[a]=e[a],h=!1}l=utils_type.A.copyAttributes(i,t.options,"line","point1"),o=h?t.create("point",[u[2]()*u[2]()+u[1]()*u[1](),u[2]()-u[1]()*u[0]()+u[2](),-u[1]()-u[2]()*u[0]()-u[1]()],l):t.create("point",[function(){return.5*(u[2]()*u[2]()+u[1]()*u[1]())},function(){return.5*(u[2]()-u[1]()*u[0]()+u[2]())},function(){return.5*(-u[1]()-u[2]()*u[0]()-u[1]())}],l),l=utils_type.A.copyAttributes(i,t.options,"line","point2"),n=h?t.create("point",[u[2]()*u[2]()+u[1]()*u[1](),-u[1]()*u[0]()+u[2](),-u[2]()*u[0]()-u[1]()],l):t.create("point",[function(){return u[2]()*u[2]()+u[1]()*u[1]()},function(){return-u[1]()*u[0]()+u[2]()},function(){return-u[2]()*u[0]()-u[1]()}],l),o.prepareUpdate().update(),n.prepareUpdate().update(),l=utils_type.A.copyAttributes(i,t.options,"line"),(r=new jxg.A.Line(t,o,n,l)).isDraggable=h,r.setParents([o,n])}else if(1===e.length&&utils_type.A.isFunction(e[0])&&2===e[0]().length&&utils_type.A.isPoint(e[0]()[0])&&utils_type.A.isPoint(e[0]()[1]))s=e[0](),l=utils_type.A.copyAttributes(i,t.options,"line"),(r=new jxg.A.Line(t,s[0],s[1],l)).constrained=!0,r.funps=e[0],r.setParents(s);else{if(!(1===e.length&&utils_type.A.isFunction(e[0])&&3===e[0]().length&&utils_type.A.isNumber(e[0]()[0])&&utils_type.A.isNumber(e[0]()[1])&&utils_type.A.isNumber(e[0]()[2])))throw new Error("JSXGraph: Can't create line with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]");s=e[0],l=utils_type.A.copyAttributes(i,t.options,"line","point1"),o=t.create("point",[function(){var t=s();return[.5*(t[2]*t[2]+t[1]*t[1]),.5*(t[2]-t[1]*t[0]+t[2]),.5*(-t[1]-t[2]*t[0]-t[1])]}],l),l=utils_type.A.copyAttributes(i,t.options,"line","point2"),n=t.create("point",[function(){var t=s();return[t[2]*t[2]+t[1]*t[1],-t[1]*t[0]+t[2],-t[2]*t[0]-t[1]]}],l),l=utils_type.A.copyAttributes(i,t.options,"line"),(r=new jxg.A.Line(t,o,n,l)).constrained=!0,r.funps=e[0],r.setParents([o,n])}return r},jxg.A.registerElement("line",jxg.A.createLine),jxg.A.createSegment=function(t,e,i){var s,r;if(i.straightFirst=!1,i.straightLast=!1,r=utils_type.A.copyAttributes(i,t.options,"segment"),s=t.create("line",e.slice(0,2),r),3===e.length){if(s.hasFixedLength=!0,utils_type.A.isNumber(e[2]))s.fixedLength=function(){return e[2]};else{if(!utils_type.A.isFunction(e[2]))throw new Error("JSXGraph: Can't create segment with third parent type '"+typeof e[2]+"'.\nPossible third parent types: number or function");s.fixedLength=utils_type.A.createFunction(e[2],this.board)}s.getParents=function(){return this.parents.concat(this.fixedLength())},s.fixedLengthOldCoords=[],s.fixedLengthOldCoords[0]=new base_coords.A(constants.A.COORDS_BY_USER,s.point1.coords.usrCoords.slice(1,3),t),s.fixedLengthOldCoords[1]=new base_coords.A(constants.A.COORDS_BY_USER,s.point2.coords.usrCoords.slice(1,3),t)}return s.elType="segment",s},jxg.A.registerElement("segment",jxg.A.createSegment),jxg.A.createArrow=function(t,e,i){var s,r;return i.straightFirst=!1,i.straightLast=!1,r=utils_type.A.copyAttributes(i,t.options,"arrow"),(s=t.create("line",e,r)).type=constants.A.OBJECT_TYPE_VECTOR,s.elType="arrow",s},jxg.A.registerElement("arrow",jxg.A.createArrow),jxg.A.createAxis=function(t,e,i){var s,r,o,n;r=utils_type.A.copyAttributes(i,t.options,"axis");try{s=t.create("line",e,r)}catch(t){throw new Error("JSXGraph: Can't create axis with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]]")}for(o in s.type=constants.A.OBJECT_TYPE_AXIS,s.isDraggable=!1,s.point1.isDraggable=!1,s.point2.isDraggable=!1,s._point1UsrCoordsOrg=s.point1.coords.usrCoords.slice(),s._point2UsrCoordsOrg=s.point2.coords.usrCoords.slice(),s.ancestors)s.ancestors.hasOwnProperty(o)&&(s.ancestors[o].type=constants.A.OBJECT_TYPE_AXISPOINT);return n=utils_type.A.exists(r.ticks.ticksdistance)?r.ticks.ticksdistance:utils_type.A.isArray(r.ticks.ticks)?r.ticks.ticks:1,s.defaultTicks=t.create("ticks",[s,n],r.ticks),s.defaultTicks.dump=!1,s.elType="axis",s.subs={ticks:s.defaultTicks},s.inherits.push(s.defaultTicks),s.update=function(){var t,e,i,r,o,n,a,l,h,u,c,d,p,_,f,A,g,m,y;if(t=this.board.getBoundingBox(),e=utils_type.A.evaluate(this.visProp.position),r=this.Direction(),o=this.isHorizontal(),n=this.isVertical(),a=utils_type.A.evaluate(this.visProp.ticksautopos),l=utils_type.A.evaluate(this.visProp.ticksautoposthreshold),l=o?utils_type.A.parseNumber(l,Math.abs(t[1]-t[3]),1/this.board.unitX)*this.board.unitX:n?utils_type.A.parseNumber(l,Math.abs(t[1]-t[3]),1/this.board.unitY)*this.board.unitY:utils_type.A.parseNumber(l,1,1),c=(u=utils_type.A.evaluate(this.visProp.anchor)).indexOf("left")>-1,d=u.indexOf("right")>-1,p=utils_type.A.evaluate(this.visProp.anchordist),p=o?utils_type.A.parseNumber(p,Math.abs(t[1]-t[3]),1/this.board.unitX):n?utils_type.A.parseNumber(p,Math.abs(t[0]-t[2]),1/this.board.unitY):0,A=this.board.getPointLoc(this._point1UsrCoordsOrg,p),_=this.point1.coords.usrCoords.slice(),f=this.point2.coords.usrCoords.slice(),"static"===e||!n&&!o||("fixed"===e?(o&&(r[0]>0&&d||r[0]<0&&c?(_[2]=t[3]+p,f[2]=t[3]+p):r[0]>0&&c||r[0]<0&&d?(_[2]=t[1]-p,f[2]=t[1]-p):(_=this._point1UsrCoordsOrg.slice(),f=this._point2UsrCoordsOrg.slice())),n&&(r[1]>0&&c||r[1]<0&&d?(_[1]=t[0]+p,f[1]=t[0]+p):r[1]>0&&d||r[1]<0&&c?(_[1]=t[2]-p,f[1]=t[2]-p):(_=this._point1UsrCoordsOrg.slice(),f=this._point2UsrCoordsOrg.slice()))):"sticky"===e&&(o&&(A[1]<0&&(r[0]>0&&d||r[0]<0&&c)?(_[2]=t[3]+p,f[2]=t[3]+p):A[1]>0&&(r[0]>0&&c||r[0]<0&&d)?(_[2]=t[1]-p,f[2]=t[1]-p):(_=this._point1UsrCoordsOrg.slice(),f=this._point2UsrCoordsOrg.slice())),n&&(A[0]<0&&(r[1]>0&&c||r[1]<0&&d)?(_[1]=t[0]+p,f[1]=t[0]+p):A[0]>0&&(r[1]>0&&d||r[1]<0&&c)?(_[1]=t[2]-p,f[1]=t[2]-p):(_=this._point1UsrCoordsOrg.slice(),f=this._point2UsrCoordsOrg.slice())))),this.point1.setPositionDirectly(jxg.A.COORDS_BY_USER,_),this.point2.setPositionDirectly(jxg.A.COORDS_BY_USER,f),g=this.defaultTicks.visProp.label,a&&(o||n)){if(utils_type.A.exists(g._anchorx_org)||(g._anchorx_org=utils_type.A.def(g.anchorx,this.board.options.text.anchorX)),utils_type.A.exists(g._anchory_org)||(g._anchory_org=utils_type.A.def(g.anchory,this.board.options.text.anchorY)),utils_type.A.exists(g._offset_org)||(g._offset_org=g.offset.slice()),y=g.offset,o){for(h=s.point1.coords.scrCoords[2]-.5*this.board.canvasHeight,m=g.anchory,h<0&&Math.abs(h)>l?"bottom"===g._side&&("top"===g.anchory&&(m="bottom"),y[1]*=-1,g._side="top"):h>0&&Math.abs(h)>l?"top"===g._side&&("bottom"===g.anchory&&(m="top"),y[1]*=-1,g._side="bottom"):(m=g._anchory_org,y=g._offset_org.slice(),"top"===m?g._side="bottom":"bottom"===m?g._side="top":y[1]<0?g._side="bottom":g._side="top"),i=0;i<s.defaultTicks.labels.length;i++)this.defaultTicks.labels[i].visProp.anchory=m;g.anchory=m}else if(n){for((h=s.point1.coords.scrCoords[1]-.5*this.board.canvasWidth)<0&&Math.abs(h)>l?"right"===g._side&&("left"===g.anchorx&&(m="right"),y[0]*=-1,g._side="left"):h>0&&Math.abs(h)>l?"left"===g._side&&("right"===g.anchorx&&(m="left"),y[0]*=-1,g._side="right"):(m=g._anchorx_org,y=g._offset_org.slice(),"left"===m?g._side="right":"right"===m||y[0]<0?g._side="left":g._side="right"),i=0;i<s.defaultTicks.labels.length;i++)this.defaultTicks.labels[i].visProp.anchorx=m;g.anchorx=m}g.offset=y}else delete g._anchorx_org,delete g._anchory_org,delete g._offset_org;return jxg.A.Line.prototype.update.call(this),this.defaultTicks.needsUpdate=!0,this},s},jxg.A.registerElement("axis",jxg.A.createAxis),jxg.A.createTangent=function(t,e,i){var s,r,o,n,a,l,h;if(1===e.length)s=e[0],r=s.slideObject;else{if(2!==e.length)throw new Error("JSXGraph: Can't create tangent with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [glider], [point,line|curve|circle|conic]");if(utils_type.A.isPoint(e[0]))s=e[0],r=e[1];else{if(!utils_type.A.isPoint(e[1]))throw new Error("JSXGraph: Can't create tangent with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [glider], [point,line|curve|circle|conic]");r=e[0],s=e[1]}}if(l=utils_type.A.copyAttributes(i,t.options,"tangent"),r.elementClass===constants.A.OBJECT_CLASS_LINE?(a=t.create("line",[r.point1,r.point2],l)).glider=s:r.elementClass===constants.A.OBJECT_CLASS_CURVE&&r.type!==constants.A.OBJECT_TYPE_CONIC?"plot"!==utils_type.A.evaluate(r.visProp.curvetype)?(a=t.create("line",[function(){var t=r.X,e=r.Y;return-s.X()*numerics.A.D(e)(s.position)+s.Y()*numerics.A.D(t)(s.position)},function(){return numerics.A.D(r.Y)(s.position)},function(){return-numerics.A.D(r.X)(s.position)}],l),s.addChild(a),a.glider=s):(h=function(t,e,i){var r,o,n,a,l,h,u,c,d,p,_,f,A=Math.floor(t);if(1===e.bezierDegree)A===e.numberPoints-1&&A--;else{if(3!==e.bezierDegree)return 0;n=(t*((f="sector"===e.elType?(_=e.points.slice(3,e.numberPoints-3)).length:(_=e.points).length)-1)-(A=3*Math.floor(t*(f-1)/3)))/3,A>=f-1&&(A=f-4,n=1)}if(A<0)return 1;switch(1===e.bezierDegree?(r=e.points[A].usrCoords,o=e.points[A+1].usrCoords):(a=_[A].usrCoords,l=_[A+1].usrCoords,h=_[A+2].usrCoords,u=_[A+3].usrCoords,c=(1-n)*(1-n)*(l[1]-a[1])+2*(1-n)*n*(h[1]-l[1])+n*n*(u[1]-h[1]),d=(1-n)*(1-n)*(l[2]-a[2])+2*(1-n)*n*(h[2]-l[2])+n*n*(u[2]-h[2]),c/=p=math.A.hypot(c,d),d/=p,o=[1,(r=s.coords.usrCoords)[1]+c,r[2]+d]),i){case 0:return r[2]*o[1]-r[1]*o[2];case 1:return o[2]-r[2];case 2:return r[1]-o[1]}return 0},a=t.create("line",[function(){return h(s.position,r,0)},function(){return h(s.position,r,1)},function(){return h(s.position,r,2)}],l),s.addChild(a),a.glider=s):r.type===constants.A.OBJECT_TYPE_TURTLE?(a=t.create("line",[function(){var t=Math.floor(s.position);for(o=0;o<r.objects.length;o++)if((n=r.objects[o]).type===constants.A.OBJECT_TYPE_CURVE){if(t<n.numberPoints)break;t-=n.numberPoints}return t===n.numberPoints-1&&t--,t<0?1:n.Y(t)*n.X(t+1)-n.X(t)*n.Y(t+1)},function(){var t=Math.floor(s.position);for(o=0;o<r.objects.length;o++)if((n=r.objects[o]).type===constants.A.OBJECT_TYPE_CURVE){if(t<n.numberPoints)break;t-=n.numberPoints}return t===n.numberPoints-1&&t--,t<0?0:n.Y(t+1)-n.Y(t)},function(){var t=Math.floor(s.position);for(o=0;o<r.objects.length;o++)if((n=r.objects[o]).type===constants.A.OBJECT_TYPE_CURVE){if(t<n.numberPoints)break;t-=n.numberPoints}return t===n.numberPoints-1&&t--,t<0?0:n.X(t)-n.X(t+1)}],l),s.addChild(a),a.glider=s):r.elementClass!==constants.A.OBJECT_CLASS_CIRCLE&&r.type!==constants.A.OBJECT_TYPE_CONIC||(a=t.create("line",[function(){return math.A.matVecMult(r.quadraticform,s.coords.usrCoords)[0]},function(){return math.A.matVecMult(r.quadraticform,s.coords.usrCoords)[1]},function(){return math.A.matVecMult(r.quadraticform,s.coords.usrCoords)[2]}],l),s.addChild(a),a.glider=s),!utils_type.A.exists(a))throw new Error("JSXGraph: Couldn't create tangent with the given parents.");return a.elType="tangent",a.type=constants.A.OBJECT_TYPE_TANGENT,a.setParents(e),a},jxg.A.createRadicalAxis=function(t,e,i){var s,r,o;if(2!==e.length||e[0].elementClass!==constants.A.OBJECT_CLASS_CIRCLE||e[1].elementClass!==constants.A.OBJECT_CLASS_CIRCLE)throw new Error("JSXGraph: Can't create 'radical axis' with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent type: [circle,circle]");return r=t.select(e[0]),o=t.select(e[1]),(s=t.create("line",[function(){var t=r.stdform,e=o.stdform;return math.A.matVecMult(math.A.transpose([t.slice(0,3),e.slice(0,3)]),[e[3],-t[3]])}],i)).elType="radicalaxis",s.setParents([r.id,o.id]),r.addChild(s),o.addChild(s),s},jxg.A.createPolarLine=function(t,e,i){var s,r,o,n,a,l,h;if(e.length>1&&(n=e[0].type===constants.A.OBJECT_TYPE_CONIC||e[0].elementClass===constants.A.OBJECT_CLASS_CIRCLE,a=e[1].type===constants.A.OBJECT_TYPE_CONIC||e[1].elementClass===constants.A.OBJECT_CLASS_CIRCLE,l=utils_type.A.isPoint(e[0]),h=utils_type.A.isPoint(e[1])),2!==e.length||!(n&&h||l&&a))throw new Error("JSXGraph: Can't create 'polar line' with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent type: [conic|circle,point], [point,conic|circle]");return h?(r=t.select(e[0]),o=t.select(e[1])):(r=t.select(e[1]),o=t.select(e[0])),(s=t.create("tangent",[r,o],i)).elType="polarline",s},jxg.A.registerElement("tangent",jxg.A.createTangent),jxg.A.registerElement("polar",jxg.A.createTangent),jxg.A.registerElement("radicalaxis",jxg.A.createRadicalAxis),jxg.A.registerElement("polarline",jxg.A.createPolarLine);var line=jxg.A.Line;jxg.A.Group=function(t,e,i,s,r){var o,n,a,l;for(this.board=t,this.objects={},o=this.board.numObjects,this.board.numObjects+=1,""!==e&&utils_type.A.exists(e)?this.id=e:this.id=this.board.id+"Group"+o,this.board.groups[this.id]=this,this.type=constants.A.OBJECT_TYPE_POINT,this.elementClass=constants.A.OBJECT_CLASS_POINT,""!==i&&utils_type.A.exists(i)?this.name=i:this.name="group_"+this.board.generateName(this),delete this.type,this.coords={},this.needsRegularUpdate=r.needsregularupdate,this.rotationCenter="centroid",this.scaleCenter=null,this.rotationPoints=[],this.translationPoints=[],this.scalePoints=[],this.scaleDirections={},this.parents=[],n=utils_type.A.isArray(s)?s:Array.prototype.slice.call(arguments,3),a=0;a<n.length;a++)l=this.board.select(n[a]),!utils_type.A.evaluate(l.visProp.fixed)&&utils_type.A.exists(l.coords)&&this.addPoint(l);this.methodMap={ungroup:"ungroup",add:"addPoint",addPoint:"addPoint",addPoints:"addPoints",addGroup:"addGroup",remove:"removePoint",removePoint:"removePoint",setAttribute:"setAttribute",setProperty:"setAttribute"}},jxg.A.extend(jxg.A.Group.prototype,{ungroup:function(){var t,e,i;for(t in this.objects)this.objects.hasOwnProperty(t)&&(e=this.objects[t].point,utils_type.A.isArray(e.groups)&&(i=utils_type.A.indexOf(e.groups,this.id))>=0&&delete e.groups[i]);return this.objects={},this},addParents:function(t){var e,i,s;for(i=(s=utils_type.A.isArray(t)?t:arguments).length,e=0;e<i;++e)utils_type.A.isId(this.board,s[e])?this.parents.push(s[e]):utils_type.A.exists(s[e].id)&&this.parents.push(s[e].id);this.parents=utils_type.A.uniqueArray(this.parents)},setParents:function(t){return this.parents=[],this.addParents(t),this},getParents:function(){return utils_type.A.isArray(this.parents)?this.parents:[]},_updateCoordsCache:function(t){var e;""!==t&&utils_type.A.exists(this.objects[t])&&(e=this.objects[t].point,this.coords[e.id]={usrCoords:e.coords.usrCoords.slice(0)})},update:function(){var t,e,i,s,r,o,n,a,l,h,u=null;if(!this.needsUpdate)return this;if("nothing"===(t=this._update_find_drag_type()).action)return this._updateCoordsCache(t.id),this;if(u=this.objects[t.id].point,"translation"===t.action)l=[u.coords.usrCoords[1]-this.coords[t.id].usrCoords[1],u.coords.usrCoords[2]-this.coords[t.id].usrCoords[2]];else if("rotation"===t.action||"scaling"===t.action){if(i="rotation"===t.action?"rotationCenter":"scaleCenter",utils_type.A.isPoint(this[i]))h=this[i].coords.usrCoords.slice(1);else if("centroid"===this[i])h=this._update_centroid_center();else if(utils_type.A.isArray(this[i]))h=this[i];else{if(!utils_type.A.isFunction(this[i]))return this;h=this[i]()}if("rotation"===t.action)a=geometry.A.rad(this.coords[t.id].usrCoords.slice(1),h,this.objects[t.id].point),(l=this.board.create("transform",[a,h[0],h[1]],{type:"rotate"})).update();else{if("scaling"!==t.action)return this;if(r=geometry.A.distance(this.coords[t.id].usrCoords.slice(1),h),Math.abs(r)<math.A.eps)return this;r=geometry.A.distance(u.coords.usrCoords.slice(1),h)/r,o=this.scaleDirections[t.id].indexOf("x")>=0?r:1,n=this.scaleDirections[t.id].indexOf("y")>=0?r:1,(l=this.board.create("transform",[1,0,0,h[0]*(1-o),o,0,h[1]*(1-n),0,n],{type:"generic"})).update()}}for(e in this._update_apply_transformation(t,l),this.needsUpdate=!1,this.objects)if(this.objects.hasOwnProperty(e))for(s in this.objects[e].descendants)this.objects[e].descendants.hasOwnProperty(s)&&(this.objects[e].descendants.needsUpdate=this.objects[e].descendants.needsRegularUpdate||this.board.needsFullUpdate);for(e in this.board.updateElements(t),this.objects)this.objects.hasOwnProperty(e)&&this._updateCoordsCache(e);return this},_update_find_drag_type:function(){var t,e,i,s="nothing",r=[];for(t in this.objects)this.objects.hasOwnProperty(t)&&(e=this.objects[t].point).coords.distance(constants.A.COORDS_BY_USER,this.coords[t])>math.A.eps&&r.push(e.id);return 0===r.length?{action:s,id:"",changed:r}:(i=r[0],e=this.objects[i].point,r.length>1?s="translation":utils_type.A.isInArray(this.rotationPoints,e)&&utils_type.A.exists(this.rotationCenter)?s="rotation":utils_type.A.isInArray(this.scalePoints,e)&&utils_type.A.exists(this.scaleCenter)?s="scaling":utils_type.A.isInArray(this.translationPoints,e)&&(s="translation"),{action:s,id:i,changed:r})},_update_centroid_center:function(){var t,e,i;for(i in t=[0,0],e=0,this.coords)this.coords.hasOwnProperty(i)&&(t[0]+=this.coords[i].usrCoords[1],t[1]+=this.coords[i].usrCoords[2],++e);return e>0&&(t[0]/=e,t[1]/=e),t},_update_apply_transformation:function(t,e){var i,s;for(i in this.objects)this.objects.hasOwnProperty(i)&&(utils_type.A.exists(this.board.objects[i])?(s=this.objects[i].point).id!==t.id?"translation"===t.action?utils_type.A.isInArray(t.changed,s.id)||s.coords.setCoordinates(constants.A.COORDS_BY_USER,[this.coords[i].usrCoords[1]+e[0],this.coords[i].usrCoords[2]+e[1]]):"rotation"!==t.action&&"scaling"!==t.action||e.applyOnce([s]):"rotation"!==t.action&&"scaling"!==t.action||s.coords.setCoordinates(constants.A.COORDS_BY_USER,math.A.matVecMult(e.matrix,this.coords[s.id].usrCoords)):delete this.objects[i])},addPoint:function(t){return this.objects[t.id]={point:this.board.select(t)},this._updateCoordsCache(t.id),this.translationPoints.push(t),t.groups.push(this.id),t.groups=utils_type.A.uniqueArray(t.groups),this},addPoints:function(t){var e;for(e=0;e<t.length;e++)this.addPoint(t[e]);return this},addGroup:function(t){var e;for(e in t.objects)t.objects.hasOwnProperty(e)&&this.addPoint(t.objects[e].point);return this},removePoint:function(t){return delete this.objects[t.id],this},setRotationCenter:function(t){return this.rotationCenter=t,this},setRotationPoints:function(t){return this._setActionPoints("rotation",t)},addRotationPoint:function(t){return this._addActionPoint("rotation",t)},removeRotationPoint:function(t){return this._removeActionPoint("rotation",t)},setTranslationPoints:function(t){return this._setActionPoints("translation",t)},addTranslationPoint:function(t){return this._addActionPoint("translation",t)},removeTranslationPoint:function(t){return this._removeActionPoint("translation",t)},setScaleCenter:function(t){return this.scaleCenter=t,this},setScalePoints:function(t,e){var i,s,r;for(r=(i=utils_type.A.isArray(t)?t:arguments).length,s=0;s<r;++s)this.scaleDirections[this.board.select(i[s]).id]=e||"xy";return this._setActionPoints("scale",t)},addScalePoint:function(t,e){return this._addActionPoint("scale",t),this.scaleDirections[this.board.select(t).id]=e||"xy",this},removeScalePoint:function(t){return this._removeActionPoint("scale",t)},_setActionPoints:function(t,e){var i,s,r;for(r=(i=utils_type.A.isArray(e)?e:arguments).length,this[t+"Points"]=[],s=0;s<r;++s)this._addActionPoint(t,i[s]);return this},_addActionPoint:function(t,e){return this[t+"Points"].push(this.board.select(e)),this},_removeActionPoint:function(t,e){var i=this[t+"Points"].indexOf(this.board.select(e));return i>-1&&this[t+"Points"].splice(i,1),this},setProperty:function(){jxg.A.deprecated("Group.setProperty","Group.setAttribute()"),this.setAttribute.apply(this,arguments)},setAttribute:function(){var t;for(t in this.objects)this.objects.hasOwnProperty(t)&&this.objects[t].point.setAttribute.apply(this.objects[t].point,arguments);return this}}),jxg.A.createGroup=function(t,e,i){var s=utils_type.A.copyAttributes(i,t.options,"group"),r=new jxg.A.Group(t,s.id,s.name,e,s);return r.elType="group",r.setParents(e),r},jxg.A.registerElement("group",jxg.A.createGroup);var group=jxg.A.Group;jxg.A.Circle=function(t,e,i,s,r){this.constructor(t,r,constants.A.OBJECT_TYPE_CIRCLE,constants.A.OBJECT_CLASS_CIRCLE),this.method=e,this.midpoint=this.board.select(i),this.center=this.board.select(i),this.point2=null,this.radius=0,this.line=null,this.circle=null,this.points=[],"twoPoints"===e?(this.point2=t.select(s),this.radius=this.Radius()):"pointRadius"===e?(this.gxtterm=s,this.updateRadius=utils_type.A.createFunction(s,this.board),this.updateRadius(),this.addParentsFromJCFunctions([this.updateRadius])):"pointLine"===e?(this.line=t.select(s),this.radius=this.line.point1.coords.distance(constants.A.COORDS_BY_USER,this.line.point2.coords)):"pointCircle"===e&&(this.circle=t.select(s),this.radius=this.circle.Radius()),this.id=this.board.setId(this,"C"),this.board.renderer.drawEllipse(this),this.board.finalizeAdding(this),this.createGradient(),this.elType="circle",this.createLabel(),utils_type.A.exists(this.center._is_new)?(this.addChild(this.center),delete this.center._is_new):this.center.addChild(this),"pointRadius"===e?this.notifyParents(s):"pointLine"===e?this.line.addChild(this):"pointCircle"===e?this.circle.addChild(this):"twoPoints"===e&&(utils_type.A.exists(this.point2._is_new)?(this.addChild(this.point2),delete this.point2._is_new):this.point2.addChild(this)),this.methodMap=utils_type.A.deepCopy(this.methodMap,{setRadius:"setRadius",getRadius:"getRadius",Area:"Area",area:"Area",Perimeter:"Perimeter",Circumference:"Perimeter",radius:"Radius",Radius:"Radius",Diameter:"Diameter",center:"center",line:"line",point2:"point2"})},jxg.A.Circle.prototype=new base_element.A,jxg.A.extend(jxg.A.Circle.prototype,{hasPoint:function(t,e){var i,s,r,o,n,a=this.center.coords.usrCoords,l=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board),h=this.Radius();return utils_type.A.isObject(utils_type.A.evaluate(this.visProp.precision))?(s=this.board._inputDevice,i=utils_type.A.evaluate(this.visProp.precision[s])):i=this.board.options.precision.hasPoint,r=a[1]-l.usrCoords[1],o=a[2]-l.usrCoords[2],n=math.A.hypot(r,o),i+=.5*utils_type.A.evaluate(this.visProp.strokewidth),i/=Math.sqrt(Math.abs(this.board.unitX*this.board.unitY)),utils_type.A.evaluate(this.visProp.hasinnerpoints)?n<h+i:Math.abs(n-h)<i},generatePolynomial:function(t){var e=this.center.symbolic.x,i=this.center.symbolic.y,s=t.symbolic.x,r=t.symbolic.y,o=this.generateRadiusSquared();return""===o?[]:["(("+s+")-("+e+"))^2 + (("+r+")-("+i+"))^2 - ("+o+")"]},generateRadiusSquared:function(){var t,e,i,s,r="";return"twoPoints"===this.method?(t=this.center.symbolic.x,e=this.center.symbolic.y,r="(("+(i=this.point2.symbolic.x)+")-("+t+"))^2 + (("+(s=this.point2.symbolic.y)+")-("+e+"))^2"):"pointRadius"===this.method?utils_type.A.isNumber(this.radius)&&(r=(this.radius*this.radius).toString()):"pointLine"===this.method?(i=this.line.point1.symbolic.x,s=this.line.point1.symbolic.y,r="(("+i+")-("+this.line.point2.symbolic.x+"))^2 + (("+s+")-("+this.line.point2.symbolic.y+"))^2"):"pointCircle"===this.method&&(r=this.circle.Radius()),r},update:function(){var t,e,i,s,r,o;if(this.needsUpdate)for(utils_type.A.evaluate(this.visProp.trace)&&this.cloneToBackground(!0),"pointLine"===this.method?this.radius=this.line.point1.coords.distance(constants.A.COORDS_BY_USER,this.line.point2.coords):"pointCircle"===this.method?this.radius=this.circle.Radius():"pointRadius"===this.method&&(this.radius=this.updateRadius()),this.radius=Math.abs(this.radius),this.updateStdform(),this.updateQuadraticform(),i=this.center.coords.usrCoords[0],t=this.center.coords.usrCoords[1]/i,e=this.center.coords.usrCoords[2]/i,i/=i,s=this.Radius(),r=.551915024494,this.numberPoints=13,this.dataX=[t+s,t+s,t+s*r,t,t-s*r,t-s,t-s,t-s,t-s*r,t,t+s*r,t+s,t+s],this.dataY=[e,e+s*r,e+s,e+s,e+s,e+s*r,e,e-s*r,e-s,e-s,e-s,e-s*r,e],this.bezierDegree=3,o=0;o<this.numberPoints;o++)this.points[o]=new base_coords.A(constants.A.COORDS_BY_USER,[this.dataX[o],this.dataY[o]],this.board);return this},updateQuadraticform:function(){var t=this.center,e=t.X(),i=t.Y(),s=this.Radius();this.quadraticform=[[e*e+i*i-s*s,-e,-i],[-e,1,0],[-i,0,1]]},updateStdform:function(){this.stdform[3]=.5,this.stdform[4]=this.Radius(),this.stdform[1]=-this.center.coords.usrCoords[1],this.stdform[2]=-this.center.coords.usrCoords[2],isFinite(this.stdform[4])||(this.stdform[0]=utils_type.A.exists(this.point2)?-(this.stdform[1]*this.point2.coords.usrCoords[1]+this.stdform[2]*this.point2.coords.usrCoords[2]):0),this.normalize()},updateRenderer:function(){return this.needsUpdate?(this.visPropCalc.visible&&(this.isReal=!isNaN(this.center.coords.usrCoords[1]+this.center.coords.usrCoords[2]+this.Radius())&&this.center.isReal,this.isReal||this.updateVisibility(!1)),this.visPropCalc.visible&&this.board.renderer.updateEllipse(this),this.hasLabel&&this.visPropCalc.visible&&this.label&&this.label.visPropCalc.visible&&this.isReal&&(this.label.update(),this.board.renderer.updateText(this.label)),this.setDisplayRendNode(),this.needsUpdate=!1,this):this},notifyParents:function(t){utils_type.A.isString(t)&&geonext.A.findDependencies(this,t,this.board)},setRadius:function(t){return this.updateRadius=utils_type.A.createFunction(t,this.board),this.addParentsFromJCFunctions([this.updateRadius]),this.board.update(),this},Radius:function(t){return utils_type.A.exists(t)?(this.setRadius(t),this.Radius()):"twoPoints"===this.method?utils_type.A.cmpArrays(this.point2.coords.usrCoords,[0,0,0])||utils_type.A.cmpArrays(this.center.coords.usrCoords,[0,0,0])?NaN:this.center.Dist(this.point2):"pointLine"===this.method||"pointCircle"===this.method?this.radius:"pointRadius"===this.method?Math.abs(this.updateRadius()):NaN},Diameter:function(){return 2*this.Radius()},getRadius:function(){return jxg.A.deprecated("Circle.getRadius()","Circle.Radius()"),this.Radius()},getTextAnchor:function(){return this.center.coords},getLabelAnchor:function(){var t,e,i,s,r,o,n=1.5,a=this.Radius(),l=this.center.coords.usrCoords,h=.7071067811865;if(!utils_type.A.exists(this.label))return new base_coords.A(constants.A.COORDS_BY_SCREEN,[NaN,NaN],this.board);if(i=utils_type.A.evaluate(this.label.visProp.position),!utils_type.A.isString(i))return new base_coords.A(constants.A.COORDS_BY_SCREEN,[NaN,NaN],this.board);if(!(i.indexOf("right")<0&&i.indexOf("left")<0))return l=this.center.coords.scrCoords,s=utils_type.A.parsePosition(i),r=utils_type.A.parseNumber(s.pos,2*Math.PI,1),s.pos.indexOf("fr")<0&&s.pos.indexOf("%")<0&&(s.pos.indexOf("px")>=0?r=0:r*=Math.PI/180),o=1,"left"===s.side&&(o=-1),utils_type.A.exists(this.label)&&(n=.5*o*utils_type.A.evaluate(this.label.visProp.distance)),t=l[1]+(a*this.board.unitX+this.label.size[0]*n)*Math.cos(r),e=l[2]-(a*this.board.unitY+this.label.size[1]*n)*Math.sin(r),new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board);switch(utils_type.A.evaluate(this.visProp.label.position)){case"lft":t=l[1]-a,e=l[2];break;case"llft":t=l[1]-h*a,e=l[2]-h*a;break;case"rt":t=l[1]+a,e=l[2];break;case"lrt":t=l[1]+h*a,e=l[2]-h*a;break;case"urt":t=l[1]+h*a,e=l[2]+h*a;break;case"top":t=l[1],e=l[2]+a;break;case"bot":t=l[1],e=l[2]-a;break;default:t=l[1]-h*a,e=l[2]+h*a}return new base_coords.A(constants.A.COORDS_BY_USER,[t,e],this.board)},cloneToBackground:function(){var t,e=this.Radius(),i={id:this.id+"T"+this.numTraces,elementClass:constants.A.OBJECT_CLASS_CIRCLE,center:{coords:this.center.coords},Radius:function(){return e},getRadius:function(){return e},board:this.board,visProp:utils_type.A.deepCopy(this.visProp,this.visProp.traceattributes,!0)};return i.visProp.layer=this.board.options.layer.trace,this.numTraces++,utils_type.A.clearVisPropOld(i),i.visPropCalc={visible:utils_type.A.evaluate(i.visProp.visible)},t=this.board.renderer.enhancedRendering,this.board.renderer.enhancedRendering=!0,this.board.renderer.drawEllipse(i),this.board.renderer.enhancedRendering=t,this.traces[i.id]=i.rendNode,this},addTransform:function(t){var e,i=utils_type.A.isArray(t)?t:[t],s=i.length;for(e=0;e<s;e++)this.center.transformations.push(i[e]),"twoPoints"===this.method&&this.point2.transformations.push(i[e]);return this},snapToGrid:function(){var t=utils_type.A.evaluate(this.visProp.snaptogrid);return this.center.handleSnapToGrid(t,!0),"twoPoints"===this.method&&this.point2.handleSnapToGrid(t,!0),this},snapToPoints:function(){var t=utils_type.A.evaluate(this.visProp.snaptopoints);return this.center.handleSnapToPoints(t),"twoPoints"===this.method&&this.point2.handleSnapToPoints(t),this},X:function(t){return this.Radius()*Math.cos(2*t*Math.PI)+this.center.coords.usrCoords[1]},Y:function(t){return this.Radius()*Math.sin(2*t*Math.PI)+this.center.coords.usrCoords[2]},Z:function(t){return 1},minX:function(){return 0},maxX:function(){return 1},Area:function(){var t=this.Radius();return t*t*Math.PI},Perimeter:function(){return 2*this.Radius()*Math.PI},bounds:function(){var t=this.center.coords.usrCoords,e=this.Radius();return[t[1]-e,t[2]+e,t[1]+e,t[2]-e]},getParents:function(){return 1===this.parents.length?this.parents.concat(this.radius):this.parents}}),jxg.A.createCircle=function(t,e,i){var s,r,o,n,a,l=["center","point2"];if(r=[],a=t.select(e[0]),utils_type.A.isObject(a)&&a.elementClass===constants.A.OBJECT_CLASS_CIRCLE&&utils_type.A.isTransformationOrArray(e[1]))return n=utils_type.A.copyAttributes(i,t.options,"circle"),(s=jxg.A.createEllipse(t,[a.center,a.center,function(){return 2*a.Radius()}],n)).addTransform(e[1]),s;for(o=0;o<e.length;o++)if(utils_type.A.isPointType(t,e[o])){if(e.length<3?r.push(utils_type.A.providePoints(t,[e[o]],i,"circle",[l[o]])[0]):r.push(utils_type.A.providePoints(t,[e[o]],i,"point")[0]),!1===r[r.length-1])throw new Error("JSXGraph: Can't create circle from this type. Please provide a point type.")}else r.push(e[o]);if(n=utils_type.A.copyAttributes(i,t.options,"circle"),2===r.length&&utils_type.A.isPoint(r[0])&&utils_type.A.isPoint(r[1]))s=new jxg.A.Circle(t,"twoPoints",r[0],r[1],n);else if((utils_type.A.isNumber(r[0])||utils_type.A.isFunction(r[0])||utils_type.A.isString(r[0]))&&utils_type.A.isPoint(r[1]))s=new jxg.A.Circle(t,"pointRadius",r[1],r[0],n);else if((utils_type.A.isNumber(r[1])||utils_type.A.isFunction(r[1])||utils_type.A.isString(r[1]))&&utils_type.A.isPoint(r[0]))s=new jxg.A.Circle(t,"pointRadius",r[0],r[1],n);else if(r[0].elementClass===constants.A.OBJECT_CLASS_CIRCLE&&utils_type.A.isPoint(r[1]))s=new jxg.A.Circle(t,"pointCircle",r[1],r[0],n);else if(r[1].elementClass===constants.A.OBJECT_CLASS_CIRCLE&&utils_type.A.isPoint(r[0]))s=new jxg.A.Circle(t,"pointCircle",r[0],r[1],n);else if(r[0].elementClass===constants.A.OBJECT_CLASS_LINE&&utils_type.A.isPoint(r[1]))s=new jxg.A.Circle(t,"pointLine",r[1],r[0],n);else if(r[1].elementClass===constants.A.OBJECT_CLASS_LINE&&utils_type.A.isPoint(r[0]))s=new jxg.A.Circle(t,"pointLine",r[0],r[1],n);else{if(!(3===e.length&&utils_type.A.isPoint(r[0])&&utils_type.A.isPoint(r[1])&&utils_type.A.isPoint(r[2])))throw new Error("JSXGraph: Can't create circle with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point], [point,number], [point,function], [point,circle], [point,point,point], [circle,transformation]");if(!jxg.A.elements.circumcircle)throw new Error("JSXGraph: Can't create circle with three points. Please include the circumcircle element (element/composition).");s=jxg.A.elements.circumcircle(t,r,n)}for(s.isDraggable=!0,s.setParents(r),s.elType="circle",o=0;o<r.length;o++)utils_type.A.isPoint(r[o])&&s.inherits.push(r[o]);return s},jxg.A.registerElement("circle",jxg.A.createCircle);var circle=jxg.A.Circle;jxg.A.createEllipse=function(t,e,i){var s,r,o,n,a,l,h,u=[],c=utils_type.A.copyAttributes(i,t.options,"conic","foci"),d=utils_type.A.copyAttributes(i,t.options,"conic","center"),p=utils_type.A.copyAttributes(i,t.options,"conic");for(l=0;l<2;l++)if(e[l].length>1)u[l]=t.create("point",e[l],c);else if(utils_type.A.isPoint(e[l]))u[l]=t.select(e[l]);else if(utils_type.A.isFunction(e[l])&&utils_type.A.isPoint(e[l]()))u[l]=e[l]();else{if(!utils_type.A.isString(e[l]))throw new Error("JSXGraph: Can't create Ellipse with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point,point], [point,point,number|function]");u[l]=t.select(e[l])}if(utils_type.A.isNumber(e[2]))a=utils_type.A.createFunction(e[2],t);else if(utils_type.A.isFunction(e[2])&&utils_type.A.isNumber(e[2]()))a=e[2];else{if(utils_type.A.isPoint(e[2]))n=t.select(e[2]);else if(e[2].length>1)n=t.create("point",e[2],c);else if(utils_type.A.isFunction(e[2])&&utils_type.A.isPoint(e[2]()))n=e[2]();else{if(!utils_type.A.isString(e[2]))throw new Error("JSXGraph: Can't create Ellipse with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point], [point,point,number|function]");n=t.select(e[2])}a=function(){return n.Dist(u[0])+n.Dist(u[1])}}for(utils_type.A.exists(e[4])||(e[4]=2*Math.PI),utils_type.A.exists(e[3])||(e[3]=0),o=t.create("point",[function(){return.5*(u[0].X()+u[1].X())},function(){return.5*(u[0].Y()+u[1].Y())}],d),(r=t.create("curve",[function(t){return 0},function(t){return 0},e[3],e[4]],p)).majorAxis=a,h=r.hasPoint,s=function(t,e){var i,s,o,n,l,h,c,d,p;e||(s=(i=a())*i,o=u[0].X(),n=u[0].Y(),c=o-(l=u[1].X()),d=n-(h=u[1].Y()),p=(s-o*o-n*n+l*l+h*h)/(2*i),r.quadraticform=[[p*p-l*l-h*h,p*c/i+l,p*d/i+h],[p*c/i+l,c*c/s-1,c*d/s],[p*d/i+h,c*d/s,d*d/s-1]])},r.X=function(t,e){var i=a(),r=u[1].Dist(u[0]),o=.5*(r*r-i*i)/(r*Math.cos(t)-i),n=Math.atan2(u[1].Y()-u[0].Y(),u[1].X()-u[0].X());return e||s(0,e),u[0].X()+Math.cos(n+t)*o},r.Y=function(t,e){var i=a(),s=u[1].Dist(u[0]),r=.5*(s*s-i*i)/(s*Math.cos(t)-i),o=Math.atan2(u[1].Y()-u[0].Y(),u[1].X()-u[0].X());return u[0].Y()+Math.sin(o+t)*r},r.midpoint=r.center=o,r.type=constants.A.OBJECT_TYPE_CONIC,r.subs={center:r.center},r.inherits.push(r.center,u[0],u[1]),utils_type.A.isPoint(n)&&r.inherits.push(n),r.hasPoint=function(t,e){var i,s,r,o;return utils_type.A.evaluate(this.visProp.hasinnerpoints)?(i=u[0].coords,s=u[1].coords,r=this.majorAxis(),(o=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board)).distance(constants.A.COORDS_BY_USER,i)+o.distance(constants.A.COORDS_BY_USER,s)<=r):h.apply(this,arguments)},o.addChild(r),l=0;l<2;l++)utils_type.A.isPoint(u[l])&&u[l].addChild(r);return utils_type.A.isPoint(n)&&n.addChild(r),r.setParents(e),r},jxg.A.createHyperbola=function(t,e,i){var s,r,o,n,a,l,h=[],u=utils_type.A.copyAttributes(i,t.options,"conic","foci"),c=utils_type.A.copyAttributes(i,t.options,"conic","center"),d=utils_type.A.copyAttributes(i,t.options,"conic");for(l=0;l<2;l++)if(e[l].length>1)h[l]=t.create("point",e[l],u);else if(utils_type.A.isPoint(e[l]))h[l]=t.select(e[l]);else if(utils_type.A.isFunction(e[l])&&utils_type.A.isPoint(e[l]()))h[l]=e[l]();else{if(!utils_type.A.isString(e[l]))throw new Error("JSXGraph: Can't create Hyperbola with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point,point], [point,point,number|function]");h[l]=t.select(e[l])}if(utils_type.A.isNumber(e[2]))a=utils_type.A.createFunction(e[2],t);else if(utils_type.A.isFunction(e[2])&&utils_type.A.isNumber(e[2]()))a=e[2];else{if(utils_type.A.isPoint(e[2]))n=t.select(e[2]);else if(e[2].length>1)n=t.create("point",e[2],u);else if(utils_type.A.isFunction(e[2])&&utils_type.A.isPoint(e[2]()))n=e[2]();else{if(!utils_type.A.isString(e[2]))throw new Error("JSXGraph: Can't create Hyperbola with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point], [point,point,number|function]");n=t.select(e[2])}a=function(){return n.Dist(h[0])-n.Dist(h[1])}}for(utils_type.A.exists(e[4])||(e[4]=1.0001*Math.PI),utils_type.A.exists(e[3])||(e[3]=-1.0001*Math.PI),o=t.create("point",[function(){return.5*(h[0].X()+h[1].X())},function(){return.5*(h[0].Y()+h[1].Y())}],c),(r=t.create("curve",[function(t){return 0},function(t){return 0},e[3],e[4]],d)).majorAxis=a,s=function(t,e){var i,s,o,n,l,u,c,d,p;e||(s=(i=a())*i,o=h[0].X(),n=h[0].Y(),c=o-(l=h[1].X()),d=n-(u=h[1].Y()),p=(s-o*o-n*n+l*l+u*u)/(2*i),r.quadraticform=[[p*p-l*l-u*u,p*c/i+l,p*d/i+u],[p*c/i+l,c*c/s-1,c*d/s],[p*d/i+u,c*d/s,d*d/s-1]])},r.X=function(t,e){var i=a(),r=h[1].Dist(h[0]),o=.5*(r*r-i*i)/(r*Math.cos(t)+i),n=Math.atan2(h[1].Y()-h[0].Y(),h[1].X()-h[0].X());return e||s(0,e),h[0].X()+Math.cos(n+t)*o},r.Y=function(t,e){var i=a(),s=h[1].Dist(h[0]),r=.5*(s*s-i*i)/(s*Math.cos(t)+i),o=Math.atan2(h[1].Y()-h[0].Y(),h[1].X()-h[0].X());return h[0].Y()+Math.sin(o+t)*r},r.midpoint=r.center=o,r.subs={center:r.center},r.inherits.push(r.center,h[0],h[1]),utils_type.A.isPoint(n)&&r.inherits.push(n),r.type=constants.A.OBJECT_TYPE_CONIC,o.addChild(r),l=0;l<2;l++)utils_type.A.isPoint(h[l])&&h[l].addChild(r);return utils_type.A.isPoint(n)&&n.addChild(r),r.setParents(e),r},jxg.A.createParabola=function(t,e,i){var s,r,o,n,a=e[0],l=e[1],h=utils_type.A.copyAttributes(i,t.options,"conic","foci"),u=utils_type.A.copyAttributes(i,t.options,"conic","center"),c=utils_type.A.copyAttributes(i,t.options,"conic");if(e[0].length>1)a=t.create("point",e[0],h);else if(utils_type.A.isPoint(e[0]))a=t.select(e[0]);else if(utils_type.A.isFunction(e[0])&&utils_type.A.isPoint(e[0]()))a=e[0]();else{if(!utils_type.A.isString(e[0]))throw new Error("JSXGraph: Can't create Parabola with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,line]");a=t.select(e[0])}return utils_type.A.isArray(l)&&2===l.length&&(n=utils_type.A.copyAttributes(i,t.options,"conic","line"),l=t.create("line",l,n)),utils_type.A.exists(e[3])||(e[3]=2*Math.PI),utils_type.A.exists(e[2])||(e[2]=0),o=t.create("point",[function(){return geometry.A.projectPointToLine(a,l,t).usrCoords}],u),(r=t.create("curve",[function(t){return 0},function(t){return 0},e[2],e[3]],c)).midpoint=r.center=o,r.subs={center:r.center},r.inherits.push(r.center),s=function(t,e){var i,s,o,n,h,u;e||(i=l.stdform[1],s=l.stdform[2],o=l.stdform[0],n=i*i+s*s,h=a.X(),u=a.Y(),r.quadraticform=[[o*o-n*(h*h+u*u),o*i+n*h,o*s+n*u],[o*i+n*h,-s*s,i*s],[o*s+n*u,i*s,-i*i]])},r.X=function(t,e){var i,r=l.getAngle(),o=geometry.A.distPointLine(a.coords.usrCoords,l.stdform),n=l.point1.coords.usrCoords,h=l.point2.coords.usrCoords,u=a.coords.usrCoords;return 0===n[0]?n=[1,h[1]+l.stdform[2],h[2]-l.stdform[1]]:0===h[0]&&(h=[1,n[1]+l.stdform[2],n[2]-l.stdform[1]]),i=((h[1]-n[1])*(u[2]-n[2])-(h[2]-n[2])*(u[1]-n[1])>=0?1:-1)*o/(1-Math.sin(t)),e||s(0,e),a.X()+Math.cos(t+r)*i},r.Y=function(t,e){var i,s=l.getAngle(),r=geometry.A.distPointLine(a.coords.usrCoords,l.stdform),o=l.point1.coords.usrCoords,n=l.point2.coords.usrCoords,h=a.coords.usrCoords;return 0===o[0]?o=[1,n[1]+l.stdform[2],n[2]-l.stdform[1]]:0===n[0]&&(n=[1,o[1]+l.stdform[2],o[2]-l.stdform[1]]),i=((n[1]-o[1])*(h[2]-o[2])-(n[2]-o[2])*(h[1]-o[1])>=0?1:-1)*r/(1-Math.sin(t)),a.Y()+Math.sin(t+s)*i},r.type=constants.A.OBJECT_TYPE_CONIC,o.addChild(r),utils_type.A.isPoint(a)&&(a.addChild(r),r.inherits.push(a)),l.addChild(r),r.setParents(e),r},jxg.A.createConic=function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_,f,A,g=[[1,0,0],[0,1,0],[0,0,1]],m=[[1,0,0],[0,1,0],[0,0,1]],y=[],b=[],v=utils_type.A.copyAttributes(i,t.options,"conic","point"),C=utils_type.A.copyAttributes(i,t.options,"conic","center"),P=utils_type.A.copyAttributes(i,t.options,"conic");if(5===e.length)A=!0;else{if(6!==e.length)throw new Error("JSXGraph: Can't create generic Conic with "+e.length+" parameters.");A=!1}if(A)for(_=0;_<5;_++)if(e[_].length>1)y[_]=t.create("point",e[_],v);else if(utils_type.A.isPoint(e[_]))y[_]=t.select(e[_]);else if(utils_type.A.isFunction(e[_])&&utils_type.A.isPoint(e[_]()))y[_]=e[_]();else{if(!utils_type.A.isString(e[_]))throw new Error("JSXGraph: Can't create Conic section with parent types '"+typeof e[_]+"'.\nPossible parent types: [point,point,point,point,point], [a00,a11,a22,a01,a02,a12]");y[_]=t.select(e[_])}else(f=[[0,0,0],[0,0,0],[0,0,0]])[0][0]=utils_type.A.isFunction(e[2])?function(){return e[2]()}:function(){return e[2]},f[0][1]=utils_type.A.isFunction(e[4])?function(){return e[4]()}:function(){return e[4]},f[0][2]=utils_type.A.isFunction(e[5])?function(){return e[5]()}:function(){return e[5]},f[1][1]=utils_type.A.isFunction(e[0])?function(){return e[0]()}:function(){return e[0]},f[1][2]=utils_type.A.isFunction(e[3])?function(){return e[3]()}:function(){return e[3]},f[2][2]=utils_type.A.isFunction(e[1])?function(){return e[1]()}:function(){return e[1]};if(a=function(t){var e,i;for(e=0;e<3;e++)for(i=e;i<3;i++)t[e][i]+=t[i][e];for(e=0;e<3;e++)for(i=0;i<e;i++)t[e][i]=t[i][e];return t},n=function(t,e){var i,s,r=[[0,0,0],[0,0,0],[0,0,0]];for(i=0;i<3;i++)for(s=0;s<3;s++)r[i][s]=t[i]*e[s];return a(r)},o=function(t,e,i){var s,r,o,n,a,l=[[0,0,0],[0,0,0],[0,0,0]];for(a=math.A.matVecMult(e,i),o=math.A.innerProduct(i,a),a=math.A.matVecMult(t,i),n=math.A.innerProduct(i,a),s=0;s<3;s++)for(r=0;r<3;r++)l[s][r]=o*t[s][r]-n*e[s][r];return l},r=t.create("curve",[function(t){return 0},function(t){return 0},0,2*Math.PI],P),s=function(t,e){var i,s,a;if(!e){if(A){for(i=0;i<5;i++)b[i]=y[i].coords.usrCoords;d=n(math.A.crossProduct(b[0],b[1]),math.A.crossProduct(b[2],b[3])),p=n(math.A.crossProduct(b[0],b[2]),math.A.crossProduct(b[1],b[3])),m=o(d,p,b[4])}else for(i=0;i<3;i++)for(s=i;s<3;s++)m[i][s]=f[i][s](),s>i&&(m[s][i]=m[i][s]);r.quadraticform=m,(l=numerics.A.Jacobi(m))[0][0][0]<0&&(l[0][0][0]*=-1,l[0][1][1]*=-1,l[0][2][2]*=-1),g=l[1],c=Math.sqrt(Math.abs(l[0][0][0])),h=Math.sqrt(Math.abs(l[0][1][1])),u=Math.sqrt(Math.abs(l[0][2][2]))}return l[0][1][1]<=0&&l[0][2][2]<=0?a=math.A.matVecMult(g,[1/c,Math.cos(t)/h,Math.sin(t)/u]):l[0][1][1]<=0&&l[0][2][2]>0?a=math.A.matVecMult(g,[Math.cos(t)/c,1/h,Math.sin(t)/u]):l[0][2][2]<0&&(a=math.A.matVecMult(g,[Math.sin(t)/c,Math.cos(t)/h,1/u])),utils_type.A.exists(a)?(a[1]/=a[0],a[2]/=a[0],a[0]=1):a=[1,NaN,NaN],a},r.X=function(t,e){return s(t,e)[1]},r.Y=function(t,e){return s(t,e)[2]},r.midpoint=t.create("point",[function(){var t=r.quadraticform;return[t[1][1]*t[2][2]-t[1][2]*t[1][2],t[1][2]*t[0][2]-t[2][2]*t[0][1],t[0][1]*t[1][2]-t[1][1]*t[0][2]]}],C),r.type=constants.A.OBJECT_TYPE_CONIC,r.center=r.midpoint,r.subs={center:r.center},r.inherits.push(r.center),r.inherits=r.inherits.concat(y),A){for(_=0;_<5;_++)utils_type.A.isPoint(y[_])&&y[_].addChild(r);r.setParents(e)}return r.addChild(r.center),r},jxg.A.registerElement("ellipse",jxg.A.createEllipse),jxg.A.registerElement("hyperbola",jxg.A.createHyperbola),jxg.A.registerElement("parabola",jxg.A.createParabola),jxg.A.registerElement("conic",jxg.A.createConic),jxg.A.Polygon=function(t,e,i){this.constructor(t,i,constants.A.OBJECT_TYPE_POLYGON,constants.A.OBJECT_CLASS_AREA);var s,r,o,n,a,l=utils_type.A.copyAttributes(i,t.options,"polygon","borders");for(this.withLines=i.withlines,this.attr_line=l,this.vertices=[],s=0;s<e.length;s++)this.vertices[s]=this.board.select(e[s]),this.vertices[s]._is_new&&(delete this.vertices[s]._is_new,this.vertices[s]._is_new_pol=!0);if(this.vertices.length>0&&this.vertices[this.vertices.length-1].id!==this.vertices[0].id&&this.vertices.push(this.vertices[0]),this.borders=[],this.withLines)for(o=this.vertices.length-1,n=0;n<o;n++)s=(n+1)%o,l.id=l.ids&&l.ids[s],l.name=l.names&&l.names[s],l.strokecolor=utils_type.A.isArray(l.colors)&&l.colors[s%l.colors.length]||l.strokecolor,l.visible=utils_type.A.exists(i.borders.visible)?i.borders.visible:i.visible,!1===l.strokecolor&&(l.strokecolor="none"),(r=t.create("segment",[this.vertices[s],this.vertices[s+1]],l)).dump=!1,this.borders[s]=r,r.parentPolygon=this,this.addChild(r);for(this.inherits.push(this.vertices,this.borders),this.id=this.board.setId(this,"Py"),s=0;s<this.vertices.length-1;s++)a=this.board.select(this.vertices[s]),utils_type.A.exists(a._is_new_pol)?(this.addChild(a),delete a._is_new_pol):a.addChild(this);this.board.renderer.drawPolygon(this),this.board.finalizeAdding(this),this.createGradient(),this.elType="polygon",this.createLabel(),this.methodMap=jxg.A.deepCopy(this.methodMap,{borders:"borders",vertices:"vertices",A:"Area",Area:"Area",Perimeter:"Perimeter",L:"Perimeter",boundingBox:"bounds",BoundingBox:"bounds",addPoints:"addPoints",insertPoints:"insertPoints",removePoints:"removePoints",Intersect:"intersect"})},jxg.A.Polygon.prototype=new base_element.A,jxg.A.extend(jxg.A.Polygon.prototype,{pnpoly:function(t,e,i){return geometry.A.pnpoly(t,e,this.vertices,i)},hasPoint:function(t,e){var i,s;if(utils_type.A.evaluate(this.visProp.hasinnerpoints)&&this.pnpoly(t,e))return!0;for(s=this.borders.length,i=0;i<s;i++)if(this.borders[i].hasPoint(t,e))return!0;return!1},updateRenderer:function(){var t,e;if(!this.needsUpdate)return this;if(this.visPropCalc.visible){for(e=this.vertices.length-("polygonalchain"===this.elType?0:1),this.isReal=!0,t=0;t<e;++t)if(!this.vertices[t].isReal){this.isReal=!1;break}if(!this.isReal)for(t in this.updateVisibility(!1),this.childElements)this.childElements.hasOwnProperty(t)&&this.childElements[t].setDisplayRendNode(!1)}return this.visPropCalc.visible&&this.board.renderer.updatePolygon(this),this.hasLabel&&this.visPropCalc.visible&&this.label&&this.label.visPropCalc.visible&&this.isReal&&(this.label.update(),this.board.renderer.updateText(this.label)),this.setDisplayRendNode(),this.needsUpdate=!1,this},getTextAnchor:function(){var t,e,i,s,r;if(0===this.vertices.length)return new base_coords.A(constants.A.COORDS_BY_USER,[1,0,0],this.board);for(i=t=this.vertices[0].X(),s=e=this.vertices[0].Y(),r=0;r<this.vertices.length;r++)this.vertices[r].X()<t&&(t=this.vertices[r].X()),this.vertices[r].X()>i&&(i=this.vertices[r].X()),this.vertices[r].Y()>e&&(e=this.vertices[r].Y()),this.vertices[r].Y()<s&&(s=this.vertices[r].Y());return new base_coords.A(constants.A.COORDS_BY_USER,[.5*(t+i),.5*(e+s)],this.board)},getLabelAnchor:jxg.A.shortcut(jxg.A.Polygon.prototype,"getTextAnchor"),cloneToBackground:function(){var t,e={};return e.id=this.id+"T"+this.numTraces,this.numTraces++,e.vertices=this.vertices,e.visProp=utils_type.A.deepCopy(this.visProp,this.visProp.traceattributes,!0),e.visProp.layer=this.board.options.layer.trace,e.board=this.board,utils_type.A.clearVisPropOld(e),e.visPropCalc={visible:utils_type.A.evaluate(e.visProp.visible)},t=this.board.renderer.enhancedRendering,this.board.renderer.enhancedRendering=!0,this.board.renderer.drawPolygon(e),this.board.renderer.enhancedRendering=t,this.traces[e.id]=e.rendNode,this},hideElement:function(t){var e;if(jxg.A.deprecated("Element.hideElement()","Element.setDisplayRendNode()"),this.visPropCalc.visible=!1,this.board.renderer.display(this,!1),!t)for(e=0;e<this.borders.length;e++)this.borders[e].hideElement();this.hasLabel&&utils_type.A.exists(this.label)&&(this.label.hiddenByParent=!0,this.label.visPropCalc.visible&&this.label.hideElement())},showElement:function(t){var e;if(jxg.A.deprecated("Element.showElement()","Element.setDisplayRendNode()"),this.visPropCalc.visible=!0,this.board.renderer.display(this,!0),!t)for(e=0;e<this.borders.length;e++)this.borders[e].showElement().updateRenderer();return utils_type.A.exists(this.label)&&this.hasLabel&&this.label.hiddenByParent&&(this.label.hiddenByParent=!1,this.label.visPropCalc.visible||this.label.showElement().updateRenderer()),this},Area:function(){return Math.abs(geometry.A.signedPolygon(this.vertices,!0))},Perimeter:function(){var t,e=this.vertices.length,i=0;for(t=1;t<e;++t)i+=this.vertices[t].Dist(this.vertices[t-1]);return i},L:function(){return this.Perimeter()},boundingBox:function(){var t,e,i=[0,0,0,0],s=this.vertices.length-1;if(0===s)return i;for(i[0]=this.vertices[0].X(),i[2]=i[0],i[1]=this.vertices[0].Y(),i[3]=i[1],t=1;t<s;++t)(e=this.vertices[t].X())<i[0]?i[0]=e:e>i[2]&&(i[2]=e),(e=this.vertices[t].Y())>i[1]?i[1]=e:e<i[3]&&(i[3]=e);return i},bounds:function(){return this.boundingBox()},remove:function(){var t;for(t=0;t<this.borders.length;t++)this.board.removeObject(this.borders[t]);base_element.A.prototype.remove.call(this)},findPoint:function(t){var e;if(!utils_type.A.isPoint(t))return-1;for(e=0;e<this.vertices.length;e++)if(this.vertices[e].id===t.id)return e;return-1},addPoints:function(t){var e,i=Array.prototype.slice.call(arguments);return e="polygonalchain"===this.elType?this.vertices.length-1:this.vertices.length-2,this.insertPoints.apply(this,[e].concat(i))},insertPoints:function(t,e){var i,s,r,o,n;if(0===arguments.length)return this;if(r=this.vertices.length-1,"polygon"===this.elType&&r--,t<-1||t>r)return this;for(s=arguments.length-1,i=1;i<s+1;i++)(n=utils_type.A.providePoints(this.board,[arguments[i]],{},"polygon",["vertices"])[0])._is_new&&(this.addChild(n),delete n._is_new),this.vertices.splice(t+i,0,n);if(this.withLines)for(o=t+1,"polygon"===this.elType?t<0?(this.vertices[this.vertices.length-1]=this.vertices[0],this.borders[this.borders.length-1].point2=this.vertices[this.vertices.length-1]):this.borders[t].point2=this.vertices[o]:t>=0&&(t<this.borders.length?this.borders[t].point2=this.vertices[o]:o=t),i=o;i<o+s;i++)this.borders.splice(i,0,this.board.create("segment",[this.vertices[i],this.vertices[i+1]],this.attr_line));return this.inherits=[],this.inherits.push(this.vertices,this.borders),this.board.update(),this},removePoints:function(t){var e,i,s,r,o=[],n=[],a=[],l=[];for("polygon"===this.elType&&(r=this.vertices.pop()),e=0;e<arguments.length;e++)s=arguments[e],utils_type.A.isPoint(s)&&(s=this.findPoint(s)),utils_type.A.isNumber(s)&&s>-1&&s<this.vertices.length&&-1===utils_type.A.indexOf(a,s)&&a.push(s);if(0===a.length)return"polygon"===this.elType&&this.vertices.push(r),this;for(e=0;e<a.length;e++)this.vertices[a[e]].removeChild(this);for(a=a.sort(),o=this.vertices.slice(),n=this.borders.slice(),this.withLines&&l.push([a[a.length-1]]),e=a.length-1;e>-1;e--)o[a[e]]=-1,this.withLines&&a.length>1&&a[e]-1>a[e-1]&&(l[l.length-1][1]=a[e],l.push([a[e-1]]));for(this.withLines&&(l[l.length-1][1]=a[0]),this.vertices=[],e=0;e<o.length;e++)utils_type.A.isPoint(o[e])&&this.vertices.push(o[e]);if("polygon"===this.elType&&this.vertices.length>1&&this.vertices[this.vertices.length-1].id!==this.vertices[0].id&&this.vertices.push(this.vertices[0]),this.withLines){for(e=0;e<l.length;e++){for(i=l[e][1]-1;i<l[e][0]+1;i++)i<0?"polygon"===this.elType&&(this.board.removeObject(this.borders[n.length-1]),n[n.length-1]=-1):i<n.length&&(this.board.removeObject(this.borders[i]),n[i]=-1);0!==l[e][1]&&l[e][0]!==o.length-1&&(n[l[e][0]-1]=this.board.create("segment",[o[l[e][1]-1],o[l[e][0]+1]],this.attr_line))}for(this.borders=[],e=0;e<n.length;e++)-1!==n[e]&&this.borders.push(n[e]);"polygon"===this.elType&&this.vertices.length>2&&(l[0][1]===this.vertices.length-1||0===l[l.length-1][1])&&this.borders.push(this.board.create("segment",[this.vertices[this.vertices.length-2],this.vertices[0]],this.attr_line))}return this.inherits=[],this.inherits.push(this.vertices,this.borders),this.board.update(),this},getParents:function(){return this.setParents(this.vertices),this.parents},getAttributes:function(){var t,e=base_element.A.prototype.getAttributes.call(this);if(this.withLines)for(e.lines=e.lines||{},e.lines.ids=[],e.lines.colors=[],t=0;t<this.borders.length;t++)e.lines.ids.push(this.borders[t].id),e.lines.colors.push(this.borders[t].visProp.strokecolor);return e},snapToGrid:function(){var t,e;for(e=!!utils_type.A.evaluate(this.visProp.snaptogrid),t=0;t<this.vertices.length;t++)this.vertices[t].handleSnapToGrid(e,!0)},setPositionDirectly:function(t,e,i){var s,r,o,n=new base_coords.A(t,e,this.board),a=new base_coords.A(t,i,this.board);for(o=this.vertices.length-1,r=0;r<o;r++)if(!this.vertices[r].draggable())return this;return s=statistics.A.subtract(n.usrCoords,a.usrCoords),this.board.create("transform",s.slice(1),{type:"translate"}).applyOnce(this.vertices.slice(0,-1)),this},sutherlandHodgman:function(t){var e,i,s,r,o,n,a,l=jxg.A.Math.Geometry.sortVertices(this.vertices),h=jxg.A.Math.Geometry.sortVertices(t.vertices),u=l.length-1,c=h.length-1,d=[],p=function(t,e,i){return(e[1]-t[1])*(i[2]-t[2])-(e[2]-t[2])*(i[1]-t[1])>=0};for(s=0;s<c;s++)d.push(h[s]);for(s=0;s<u;s++)for(i=d.slice(0),d=[],o=i[(e=i.length)-1],r=0;r<e;r++)n=i[r],p(l[s],l[s+1],n)?(p(l[s],l[s+1],o)||((a=jxg.A.Math.Geometry.meetSegmentSegment(o,n,l[s],l[s+1]))[0][1]/=a[0][0],a[0][2]/=a[0][0],a[0][0]=1,d.push(a[0])),d.push(n)):p(l[s],l[s+1],o)&&((a=jxg.A.Math.Geometry.meetSegmentSegment(o,n,l[s],l[s+1]))[0][1]/=a[0][0],a[0][2]/=a[0][0],a[0][0]=1,d.push(a[0])),o=n;return d},intersect:function(t){return this.sutherlandHodgman(t)}}),jxg.A.createPolygon=function(t,e,i){var s,r,o,n,a,l,h=[],u=!1;if(utils_type.A.copyAttributes(i,t.options,"polygon"),null===(n=t.select(e[0]))&&(n=e[0]),utils_type.A.isObject(n)&&n.type===constants.A.OBJECT_TYPE_POLYGON&&utils_type.A.isTransformationOrArray(e[1]))for(u=!0,o=n.vertices.length-1,l=utils_type.A.copyAttributes(i,t.options,"polygon","vertices"),r=0;r<o;r++)l.withlabel&&(l.name=""===n.vertices[r].name?"":n.vertices[r].name+"'"),h.push(t.create("point",[n.vertices[r],e[1]],l));else if(!1===(h=utils_type.A.providePoints(t,e,i,"polygon",["vertices"])))throw new Error("JSXGraph: Can't create polygon / polygonalchain with parent types other than 'point' and 'coordinate arrays' or a function returning an array of coordinates. Alternatively, a polygon and a transformation can be supplied");if(a=utils_type.A.copyAttributes(i,t.options,"polygon"),(s=new jxg.A.Polygon(t,h,a)).isDraggable=!0,u)for(s.prepareUpdate().update().updateVisibility().updateRenderer(),o=n.vertices.length-1,r=0;r<o;r++)h[r].prepareUpdate().update().updateVisibility().updateRenderer();return s},jxg.A.createRegularPolygon=function(t,e,i){var s,r,o,n,a,l,h,u=[];if(o=e[(a=e.length)-1],utils_type.A.isNumber(o)&&(3!==e.length||o<3))throw new Error("JSXGraph: A regular polygon needs two point types and a number > 2 as input.");if(utils_type.A.isNumber(t.select(o))?(a--,l=!1):(o=a,l=!0),!1===(u=utils_type.A.providePoints(t,e.slice(0,a),i,"regularpolygon",["vertices"])))throw new Error("JSXGraph: Can't create regular polygon with parent types other than 'point' and 'coordinate arrays' or a function returning an array of coordinates");for(h=utils_type.A.copyAttributes(i,t.options,"regularpolygon","vertices"),r=2;r<o;r++)n=t.create("transform",[Math.PI*(2-(o-2)/o),u[r-1]],{type:"rotate"}),l?(u[r].addTransform(u[r-2],n),u[r].fullUpdate()):(utils_type.A.isArray(h.ids)&&h.ids.length>=o-2&&(h.id=h.ids[r-2]),u[r]=t.create("point",[u[r-2],n],h),u[r].type=constants.A.OBJECT_TYPE_CAS,u[r].isDraggable=!0,u[r].visProp.fixed=!1);return h=utils_type.A.copyAttributes(i,t.options,"regularpolygon"),(s=t.create("polygon",u,h)).elType="regularpolygon",s},jxg.A.createPolygonalChain=function(t,e,i){var s,r;return s=utils_type.A.copyAttributes(i,t.options,"polygonalchain"),(r=t.create("polygon",e,s)).elType="polygonalchain",r.vertices.pop(),t.removeObject(r.borders[r.borders.length-1]),r.borders.pop(),r},jxg.A.createParallelogram=function(t,e,i){var s,r,o,n,a;if(!1===(o=utils_type.A.providePoints(t,e,i,"polygon",["vertices"]))||o.length<3)throw new Error("JSXGraph: Can't create parallelogram with parent types other than 'point' and 'coordinate arrays' or a function returning an array of coordinates.");return a=utils_type.A.copyAttributes(i,t.options,"parallelogram",["parallelpoint"]),r=t.create("parallelpoint",o,a),n=utils_type.A.copyAttributes(i,t.options,"parallelogram"),(s=t.create("polygon",[o[0],o[1],r,o[2]],n)).elType="parallelogram",s.parallelPoint=r,s.isDraggable=!0,r.isDraggable=!0,r.visProp.fixed=!1,s},jxg.A.registerElement("polygon",jxg.A.createPolygon),jxg.A.registerElement("regularpolygon",jxg.A.createRegularPolygon),jxg.A.registerElement("polygonalchain",jxg.A.createPolygonalChain),jxg.A.registerElement("parallelogram",jxg.A.createParallelogram);var polygon=jxg.A.Polygon;jxg.A.Curve=function(t,e,i){this.constructor(t,i,constants.A.OBJECT_TYPE_CURVE,constants.A.OBJECT_CLASS_CURVE),this.points=[],this.numberPoints=utils_type.A.evaluate(this.visProp.numberpointshigh),this.bezierDegree=1,this.dataX=null,this.dataY=null,this.ticks=[],this.qdt=null,utils_type.A.exists(e[0])?this.varname=e[0]:this.varname="x",this.xterm=e[1],this.yterm=e[2],this.generateTerm(this.varname,this.xterm,this.yterm,e[3],e[4]),this.updateCurve(),this.id=this.board.setId(this,"G"),this.board.renderer.drawCurve(this),this.board.finalizeAdding(this),this.createGradient(),this.elType="curve",this.createLabel(),utils_type.A.isString(this.xterm)&&this.notifyParents(this.xterm),utils_type.A.isString(this.yterm)&&this.notifyParents(this.yterm),this.methodMap=utils_type.A.deepCopy(this.methodMap,{generateTerm:"generateTerm",setTerm:"generateTerm",move:"moveTo",moveTo:"moveTo",MinX:"minX",MaxX:"maxX"})},jxg.A.Curve.prototype=new base_element.A,jxg.A.extend(jxg.A.Curve.prototype,{minX:function(){return"polar"===utils_type.A.evaluate(this.visProp.curvetype)?0:new base_coords.A(constants.A.COORDS_BY_SCREEN,[.1*-this.board.canvasWidth,0],this.board,!1).usrCoords[1]},maxX:function(){return"polar"===utils_type.A.evaluate(this.visProp.curvetype)?2*Math.PI:new base_coords.A(constants.A.COORDS_BY_SCREEN,[1.1*this.board.canvasWidth,0],this.board,!1).usrCoords[1]},X:function(t){return NaN},Y:function(t){return NaN},Z:function(t){return 1},hasPoint:function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_,f,A,g,m,y=[],b=utils_type.A.evaluate(this.visProp.numberpointslow),v=(this.maxX()-this.minX())/b,C=1/0,P=!0;if(utils_type.A.isObject(utils_type.A.evaluate(this.visProp.precision))?(_=this.board._inputDevice,p=utils_type.A.evaluate(this.visProp.precision[_])):p=this.board.options.precision.hasPoint,t=(l=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board,!1)).usrCoords[1],e=l.usrCoords[2],1===this.bezierDegree&&utils_type.A.evaluate(this.visProp.hasinnerpoints)&&0!==geometry.A.windingNumber([1,t,e],this.points,!0))return!0;if(p+=.5*utils_type.A.evaluate(this.visProp.strokewidth),p*=p,f=this.board.unitX*this.board.unitX,A=this.board.unitY*this.board.unitY,m=this.minX(),this.maxX(),utils_type.A.exists(this._visibleArea)&&(m=this._visibleArea[0],v=(this._visibleArea[1]-m)/b),"parameter"===(g=utils_type.A.evaluate(this.visProp.curvetype))||"polar"===g)for(this.transformations.length>0&&(this.updateTransformMatrix(),u=math.A.inverse(this.transformMat),t=(r=math.A.matVecMult(u,[1,t,e]))[1],e=r[2]),o=0,s=m;o<b;o++){if((C=(t-(n=this.X(s,P)))*(t-n)*f+(e-(a=this.Y(s,P)))*(e-a)*A)<=p)return!0;s+=v}else if("plot"===g||"functiongraph"===g){for((!utils_type.A.exists(i)||i<0)&&(i=0),utils_type.A.exists(this.qdt)&&utils_type.A.evaluate(this.visProp.useqdt)&&3!==this.bezierDegree?h=(c=(d=this.qdt.query(new base_coords.A(constants.A.COORDS_BY_USER,[t,e],this.board))).points).length:(c=this.points,h=this.numberPoints-1),o=i;o<h;o++)if(3===this.bezierDegree?y=geometry.A.projectCoordsToBeziersegment([1,t,e],this,o):d?(c[o].prev&&(y=geometry.A.projectCoordsToSegment([1,t,e],c[o].prev.usrCoords,c[o].usrCoords)),c[o].next&&c[o+1]!==c[o].next&&(y=geometry.A.projectCoordsToSegment([1,t,e],c[o].usrCoords,c[o].next.usrCoords))):y=geometry.A.projectCoordsToSegment([1,t,e],c[o].usrCoords,c[o+1].usrCoords),y[1]>=0&&y[1]<=1&&(t-y[0][1])*(t-y[0][1])*f+(e-y[0][2])*(e-y[0][2])*A<=p)return!0;return!1}return C<p},allocatePoints:function(){var t,e;if(e=this.numberPoints,this.points.length<this.numberPoints)for(t=this.points.length;t<e;t++)this.points[t]=new base_coords.A(constants.A.COORDS_BY_USER,[0,0],this.board,!1)},update:function(){return this.needsUpdate&&(utils_type.A.evaluate(this.visProp.trace)&&this.cloneToBackground(!0),this.updateCurve()),this},updateRenderer:function(){return this.needsUpdate?(this.visPropCalc.visible&&(this.isReal=plot.checkReal(this.points),this.isReal||this.updateVisibility(!1)),this.visPropCalc.visible&&this.board.renderer.updateCurve(this),this.hasLabel&&this.visPropCalc.visible&&this.label&&this.label.visPropCalc.visible&&this.isReal&&(this.label.update(),this.board.renderer.updateText(this.label)),this.setDisplayRendNode(),this.needsUpdate=!1,this):this},updateDataArray:function(){},updateCurve:function(){var t,e,i,s,r,o,n=this.visProp.plotversion,a=!1;if(this.updateTransformMatrix(),this.updateDataArray(),i=this.minX(),s=this.maxX(),utils_type.A.exists(this.dataX))for(this.numberPoints=this.dataX.length,e=this.numberPoints,this.allocatePoints(),t=0;t<e;t++)r=t,utils_type.A.exists(this.dataY)?(o=t,this.points[t].setCoordinates(constants.A.COORDS_BY_USER,[this.dataX[t],this.dataY[t]],!1)):(o=this.X(r),this.points[t].setCoordinates(constants.A.COORDS_BY_USER,[this.dataX[t],this.Y(o,a)],!1)),this.points[t]._t=t,a=!0;else if(utils_type.A.evaluate(this.visProp.doadvancedplot)?1===n||utils_type.A.evaluate(this.visProp.doadvancedplotold)?plot.updateParametricCurveOld(this,i,s):2===n?plot.updateParametricCurve_v2(this,i,s):3===n?plot.updateParametricCurve_v3(this,i,s):4===n?plot.updateParametricCurve_v4(this,i,s):plot.updateParametricCurve_v2(this,i,s):(this.board.updateQuality===this.board.BOARD_QUALITY_HIGH?this.numberPoints=utils_type.A.evaluate(this.visProp.numberpointshigh):this.numberPoints=utils_type.A.evaluate(this.visProp.numberpointslow),this.allocatePoints(),plot.updateParametricCurveNaive(this,i,s,this.numberPoints)),e=this.numberPoints,utils_type.A.evaluate(this.visProp.useqdt)&&this.board.updateQuality===this.board.BOARD_QUALITY_HIGH)for(this.qdt=new qdt(this.board.getBoundingBox()),t=0;t<this.points.length;t++)this.qdt.insert(this.points[t]),t>0&&(this.points[t].prev=this.points[t-1]),t<e-1&&(this.points[t].next=this.points[t+1]);for("plot"!==utils_type.A.evaluate(this.visProp.curvetype)&&utils_type.A.evaluate(this.visProp.rdpsmoothing)&&(this.points=numerics.A.RamerDouglasPeucker(this.points,.2),this.numberPoints=this.points.length),e=this.numberPoints,t=0;t<e;t++)this.updateTransform(this.points[t]);return this},updateTransformMatrix:function(){var t,e,i=this.transformations.length;for(this.transformMat=[[1,0,0],[0,1,0],[0,0,1]],e=0;e<i;e++)(t=this.transformations[e]).update(),this.transformMat=math.A.matMatMult(t.matrix,this.transformMat);return this},updateTransform:function(t){var e;return this.transformations.length>0&&(e=math.A.matVecMult(this.transformMat,t.usrCoords),t.setCoordinates(constants.A.COORDS_BY_USER,e,!1,!0)),t},addTransform:function(t){var e,i=utils_type.A.isArray(t)?t:[t],s=i.length;for(e=0;e<s;e++)this.transformations.push(i[e]);return this},interpolationFunctionFromArray:function(t){var e="data"+t,i=this;return function(t,s){var r,o,n,a,l=i[e],h=l.length,u=[];if(isNaN(t))return NaN;if(t<0)return utils_type.A.isFunction(l[0])?l[0]():l[0];if(3===i.bezierDegree){if(t>=(h-1)/3)return utils_type.A.isFunction(l[l.length-1])?l[l.length-1]():l[l.length-1];for(r=3*Math.floor(t),a=1-(n=t%1),o=0;o<4;o++)utils_type.A.isFunction(l[r+o])?u[o]=l[r+o]():u[o]=l[r+o];return a*a*(a*u[0]+3*n*u[1])+(3*a*u[2]+n*u[3])*n*n}if((r=t>h-2?h-2:parseInt(Math.floor(t),10))===t)return utils_type.A.isFunction(l[r])?l[r]():l[r];for(o=0;o<2;o++)utils_type.A.isFunction(l[r+o])?u[o]=l[r+o]():u[o]=l[r+o];return u[0]+(u[1]-u[0])*(t-r)}},generateTerm:function(t,e,i,s,r){var o,n;utils_type.A.isArray(e)?(this.dataX=e,this.numberPoints=this.dataX.length,this.X=this.interpolationFunctionFromArray.apply(this,["X"]),this.visProp.curvetype="plot",this.isDraggable=!0):(this.X=utils_type.A.createFunction(e,this.board,t),utils_type.A.isString(e)?this.visProp.curvetype="functiongraph":(utils_type.A.isFunction(e)||utils_type.A.isNumber(e))&&(this.visProp.curvetype="parameter"),this.isDraggable=!0),utils_type.A.isArray(i)?(this.dataY=i,this.Y=this.interpolationFunctionFromArray.apply(this,["Y"])):this.Y=utils_type.A.createFunction(i,this.board,t),utils_type.A.isFunction(e)&&utils_type.A.isArray(i)&&(o=utils_type.A.createFunction(i[0],this.board,""),n=utils_type.A.createFunction(i[1],this.board,""),this.X=function(t){return e(t)*Math.cos(t)+o()},this.X.deps=o.deps,this.Y=function(t){return e(t)*Math.sin(t)+n()},this.Y.deps=n.deps,this.visProp.curvetype="polar"),utils_type.A.exists(s)?this.minX=utils_type.A.createFunction(s,this.board,""):delete this.minX,utils_type.A.exists(r)?this.maxX=utils_type.A.createFunction(r,this.board,""):delete this.maxX,this.addParentsFromJCFunctions([this.X,this.Y,this.minX,this.maxX])},notifyParents:function(t){var e,i,s,r=!1;for(e in s={xterm:1,yterm:1})if(s.hasOwnProperty(e)&&this.hasOwnProperty(e)&&this[e].origin)for(i in r=!0,this[e].origin.deps)this[e].origin.deps.hasOwnProperty(i)&&this[e].origin.deps[i].addChild(this);r||geonext.A.findDependencies(this,t,this.board)},getLabelAnchor:function(){var t,e,i,s,r,o,n,a,l,h,u,c=1.5,d=.05*this.board.canvasWidth,p=.05*this.board.canvasHeight,_=.95*this.board.canvasWidth,f=.95*this.board.canvasHeight;if(!utils_type.A.exists(this.label))return new base_coords.A(constants.A.COORDS_BY_SCREEN,[NaN,NaN],this.board);if(i=utils_type.A.evaluate(this.label.visProp.position),!utils_type.A.isString(i))return new base_coords.A(constants.A.COORDS_BY_SCREEN,[NaN,NaN],this.board);if(!(i.indexOf("right")<0&&i.indexOf("left")<0))return s=utils_type.A.parsePosition(i),r=utils_type.A.parseNumber(s.pos,this.maxX()-this.minX(),1),s.pos.indexOf("fr")<0&&s.pos.indexOf("%")<0&&(r=0),n=this.minX()+r,t=this.X(n),e=this.Y(n),u=new base_coords.A(constants.A.COORDS_BY_USER,[t,e],this.board).scrCoords,o=math.A.eps,n<this.minX()+o?(a=(this.X(n+o)-this.X(n))/o,l=(this.Y(n+o)-this.Y(n))/o):n>this.maxX()-o?(a=(this.X(n)-this.X(n-o))/o,l=(this.Y(n)-this.Y(n-o))/o):(a=.5*(this.X(n+o)-this.X(n-o))/o,l=.5*(this.Y(n+o)-this.Y(n-o))/o),h=math.A.hypot(a,l),"left"===s.side?l*=-1:a*=-1,utils_type.A.exists(this.label)&&(c=.5*utils_type.A.evaluate(this.label.visProp.distance)/h),t=u[1]+l*this.label.size[0]*c,e=u[2]-a*this.label.size[1]*c,new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board);switch(utils_type.A.evaluate(this.visProp.label.position)){case"ulft":t=d,e=p;break;case"llft":t=d,e=f;break;case"rt":t=_,e=.5*f;break;case"lrt":t=_,e=f;break;case"urt":t=_,e=p;break;case"top":t=.5*_,e=p;break;case"bot":t=.5*_,e=f;break;default:t=d,e=.5*f}return u=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board,!1),geometry.A.projectCoordsToCurve(u.usrCoords[1],u.usrCoords[2],0,this,this.board)[0]},cloneToBackground:function(){var t,e={id:this.id+"T"+this.numTraces,elementClass:constants.A.OBJECT_CLASS_CURVE,points:this.points.slice(0),bezierDegree:this.bezierDegree,numberPoints:this.numberPoints,board:this.board,visProp:utils_type.A.deepCopy(this.visProp,this.visProp.traceattributes,!0)};return e.visProp.layer=this.board.options.layer.trace,e.visProp.curvetype=this.visProp.curvetype,this.numTraces++,utils_type.A.clearVisPropOld(e),e.visPropCalc={visible:utils_type.A.evaluate(e.visProp.visible)},t=this.board.renderer.enhancedRendering,this.board.renderer.enhancedRendering=!0,this.board.renderer.drawCurve(e),this.board.renderer.enhancedRendering=t,this.traces[e.id]=e.rendNode,this},bounds:function(){var t,e,i,s=1/0,r=-1/0,o=1/0,n=-1/0,a=this.points.length;if(3===this.bezierDegree){for(t=0;t<a;t++)this.points[t].X=utils_type.A.bind((function(){return this.usrCoords[1]}),this.points[t]),this.points[t].Y=utils_type.A.bind((function(){return this.usrCoords[2]}),this.points[t]);return i=(e=numerics.A.bezier(this.points))[3](),s=numerics.A.fminbr((function(t){return e[0](t)}),[0,i]),r=numerics.A.fminbr((function(t){return-e[0](t)}),[0,i]),o=numerics.A.fminbr((function(t){return e[1](t)}),[0,i]),n=numerics.A.fminbr((function(t){return-e[1](t)}),[0,i]),s=e[0](s),r=e[0](r),o=e[1](o),[s,n=e[1](n),r,o]}for(t=0;t<a;t++)s>this.points[t].usrCoords[1]&&(s=this.points[t].usrCoords[1]),r<this.points[t].usrCoords[1]&&(r=this.points[t].usrCoords[1]),o>this.points[t].usrCoords[2]&&(o=this.points[t].usrCoords[2]),n<this.points[t].usrCoords[2]&&(n=this.points[t].usrCoords[2]);return[s,n,r,o]},getParents:function(){var t=[this.xterm,this.yterm,this.minX(),this.maxX()];return 0!==this.parents.length&&(t=this.parents),t},moveTo:function(t){var e,i=[];return this.points.length>0&&!utils_type.A.evaluate(this.visProp.fixed)&&(e=this.points[0],i=3===t.length?[t[0]-e.usrCoords[0],t[1]-e.usrCoords[1],t[2]-e.usrCoords[2]]:[t[0]-e.usrCoords[1],t[1]-e.usrCoords[2]],this.setPosition(constants.A.COORDS_BY_USER,i)),this},getTransformationSource:function(){var t,e;return utils_type.A.exists(this._transformationSource)&&(e=this._transformationSource).elementClass===constants.A.OBJECT_CLASS_CURVE&&(t=!0),[t,e]}}),jxg.A.createCurve=function(t,e,i){var s,r,o=utils_type.A.copyAttributes(i,t.options,"curve");return s=t.select(e[0],!0),utils_type.A.isTransformationOrArray(e[1])&&utils_type.A.isObject(s)&&(s.type===constants.A.OBJECT_TYPE_CURVE||s.type===constants.A.OBJECT_TYPE_ANGLE||s.type===constants.A.OBJECT_TYPE_ARC||s.type===constants.A.OBJECT_TYPE_CONIC||s.type===constants.A.OBJECT_TYPE_SECTOR)?(s.type===constants.A.OBJECT_TYPE_SECTOR?o=utils_type.A.copyAttributes(i,t.options,"sector"):s.type===constants.A.OBJECT_TYPE_ARC?o=utils_type.A.copyAttributes(i,t.options,"arc"):s.type===constants.A.OBJECT_TYPE_ANGLE?(utils_type.A.exists(i.withLabel)||(i.withLabel=!1),o=utils_type.A.copyAttributes(i,t.options,"angle")):o=utils_type.A.copyAttributes(i,t.options,"curve"),o=utils_type.A.copyAttributes(o,t.options,"curve"),(r=new jxg.A.Curve(t,["x",[],[]],o)).updateDataArray=function(){var t,e=s.numberPoints;for(this.bezierDegree=s.bezierDegree,this.dataX=[],this.dataY=[],t=0;t<e;t++)this.dataX.push(s.points[t].usrCoords[1]),this.dataY.push(s.points[t].usrCoords[2]);return this},r.addTransform(e[1]),s.addChild(r),r.setParents([s]),r._transformationSource=s,r):(o=utils_type.A.copyAttributes(i,t.options,"curve"),new jxg.A.Curve(t,["x"].concat(e),o))},jxg.A.registerElement("curve",jxg.A.createCurve),jxg.A.createFunctiongraph=function(t,e,i){var s,r=["x","x"].concat(e);return s=utils_type.A.copyAttributes(i,t.options,"functiongraph"),(s=utils_type.A.copyAttributes(s,t.options,"curve")).curvetype="functiongraph",new jxg.A.Curve(t,r,s)},jxg.A.registerElement("functiongraph",jxg.A.createFunctiongraph),jxg.A.registerElement("plot",jxg.A.createFunctiongraph),jxg.A.createSpline=function(t,e,i){var s,r,o;return r=function(){var t,i=[],s=[];return[function(r,o){var n,a,l;if(!o){if(i=[],s=[],2===e.length&&utils_type.A.isArray(e[0])&&utils_type.A.isArray(e[1])&&e[0].length===e[1].length)for(n=0;n<e[0].length;n++)utils_type.A.isFunction(e[0][n])?i.push(e[0][n]()):i.push(e[0][n]),utils_type.A.isFunction(e[1][n])?s.push(e[1][n]()):s.push(e[1][n]);else for(n=0;n<e.length;n++)if(utils_type.A.isPoint(e[n]))i.push(e[n].X()),s.push(e[n].Y());else if(utils_type.A.isArray(e[n])&&2===e[n].length)for(a=0;a<e.length;a++)utils_type.A.isFunction(e[a][0])?i.push(e[a][0]()):i.push(e[a][0]),utils_type.A.isFunction(e[a][1])?s.push(e[a][1]()):s.push(e[a][1]);else utils_type.A.isFunction(e[n])&&2===e[n]().length&&(l=e[n](),i.push(l[0]),s.push(l[1]));t=numerics.A.splineDef(i,s)}return numerics.A.splineEval(r,i,s,t)},function(){return i[0]},function(){return i[i.length-1]}]},(i=utils_type.A.copyAttributes(i,t.options,"curve")).curvetype="functiongraph",o=r(),(s=new jxg.A.Curve(t,["x","x",o[0],o[1],o[2]],i)).setParents(e),s.elType="spline",s},jxg.A.registerElement("spline",jxg.A.createSpline),jxg.A.createCardinalSpline=function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p="\nPossible parent types: [points:array, tau:number|function, type:string]";if(!utils_type.A.exists(e[0])||!utils_type.A.isArray(e[0]))throw new Error("JSXGraph: JXG.createCardinalSpline: argument 1 'points' has to be array of points or coordinate pairs"+p);if(!utils_type.A.exists(e[1])||!utils_type.A.isNumber(e[1])&&!utils_type.A.isFunction(e[1]))throw new Error("JSXGraph: JXG.createCardinalSpline: argument 2 'tau' has to be number between [0,1] or function'"+p);if(!utils_type.A.exists(e[2])||!utils_type.A.isString(e[2]))throw new Error("JSXGraph: JXG.createCardinalSpline: argument 3 'type' has to be string 'uniform' or 'centripetal'"+p);if(i=utils_type.A.copyAttributes(i,t.options,"curve"),(i=utils_type.A.copyAttributes(i,t.options,"cardinalspline")).curvetype="parameter",l=e[0],h=[],!i.isarrayofcoordinates&&2===l.length&&utils_type.A.isArray(l[0])&&utils_type.A.isArray(l[1])&&l[0].length===l[1].length)for(u=0;u<l[0].length;u++)h[u]=[],utils_type.A.isFunction(l[0][u])?h[u].push(l[0][u]()):h[u].push(l[0][u]),utils_type.A.isFunction(l[1][u])?h[u].push(l[1][u]()):h[u].push(l[1][u]);else for(u=0;u<l.length;u++)utils_type.A.isString(l[u])?h.push(t.select(l[u])):utils_type.A.isPoint(l[u])?h.push(l[u]):utils_type.A.isArray(l[u])&&2===l[u].length?(h[u]=[],utils_type.A.isFunction(l[u][0])?h[u].push(l[u][0]()):h[u].push(l[u][0]),utils_type.A.isFunction(l[u][1])?h[u].push(l[u][1]()):h[u].push(l[u][1])):utils_type.A.isFunction(l[u])&&2===l[u]().length&&h.push(e[u]());if(!0===i.createpoints)o=utils_type.A.providePoints(t,h,i,"cardinalspline",["points"]);else for(o=[],r=function(t){return{X:function(){return h[t][0]},Y:function(){return h[t][1]},Dist:function(t){var e=this.X()-t.X(),i=this.Y()-t.Y();return math.A.hypot(e,i)}}},u=0;u<h.length;u++)utils_type.A.isPoint(h[u])?o.push(h[u]):o.push(r(u));for(n=e[1],a=e[2],d=["x"].concat(numerics.A.CardinalSpline(o,n,a)),s=new jxg.A.Curve(t,d,i),c=o.length,s.setParents(o),u=0;u<c;u++)l=o[u],utils_type.A.isPoint(l)&&(utils_type.A.exists(l._is_new)?(s.addChild(l),delete l._is_new):l.addChild(s));return s.elType="cardinalspline",s},jxg.A.registerElement("cardinalspline",jxg.A.createCardinalSpline),jxg.A.createMetapostSpline=function(t,e,i){var s,r,o,n,a,l,h,u,c="\nPossible parent types: [points:array, controls:object";if(!utils_type.A.exists(e[0])||!utils_type.A.isArray(e[0]))throw new Error("JSXGraph: JXG.createMetapostSpline: argument 1 'points' has to be array of points or coordinate pairs"+c);if(!utils_type.A.exists(e[1])||!utils_type.A.isObject(e[1]))throw new Error("JSXGraph: JXG.createMetapostSpline: argument 2 'controls' has to be a JavaScript object'"+c);if(i=utils_type.A.copyAttributes(i,t.options,"curve"),(i=utils_type.A.copyAttributes(i,t.options,"metapostspline")).curvetype="parameter",a=e[0],l=[],!i.isarrayofcoordinates&&2===a.length&&utils_type.A.isArray(a[0])&&utils_type.A.isArray(a[1])&&a[0].length===a[1].length)for(h=0;h<a[0].length;h++)l[h]=[],utils_type.A.isFunction(a[0][h])?l[h].push(a[0][h]()):l[h].push(a[0][h]),utils_type.A.isFunction(a[1][h])?l[h].push(a[1][h]()):l[h].push(a[1][h]);else for(h=0;h<a.length;h++)utils_type.A.isString(a[h])?l.push(t.select(a[h])):utils_type.A.isPoint(a[h])?l.push(a[h]):utils_type.A.isArray(a[h])&&2===a[h].length?(l[h]=[],utils_type.A.isFunction(a[h][0])?l[h].push(a[h][0]()):l[h].push(a[h][0]),utils_type.A.isFunction(a[h][1])?l[h].push(a[h][1]()):l[h].push(a[h][1])):utils_type.A.isFunction(a[h])&&2===a[h]().length&&l.push(e[h]());if(!0===i.createpoints)o=utils_type.A.providePoints(t,l,i,"metapostspline",["points"]);else for(o=[],r=function(t){return{X:function(){return l[t][0]},Y:function(){return l[t][1]}}},h=0;h<l.length;h++)utils_type.A.isPoint(l[h])?o.push(l[h]):o.push(r);for(n=e[1],(s=new jxg.A.Curve(t,["t",[],[],0,a.length-1],i)).updateDataArray=function(){var t,e,i=o.length,s=[];for(e=0;e<i;e++)s.push([o[e].X(),o[e].Y()]);t=metapost.curve(s,n),this.dataX=t[0],this.dataY=t[1]},s.bezierDegree=3,u=o.length,s.setParents(o),h=0;h<u;h++)utils_type.A.isPoint(o[h])&&o[h].addChild(s);return s.elType="metapostspline",s},jxg.A.registerElement("metapostspline",jxg.A.createMetapostSpline),jxg.A.createRiemannsum=function(t,e,i){var s,r,o,n,a,l;if((l=utils_type.A.copyAttributes(i,t.options,"riemannsum")).curvetype="plot",o=e[0],s=utils_type.A.createFunction(e[1],t,""),!utils_type.A.exists(s))throw new Error("JSXGraph: JXG.createRiemannsum: argument '2' n has to be number or function.\nPossible parent types: [function,n:number|function,type,start:number|function,end:number|function]");if("string"==typeof e[2]&&(e[2]="'"+e[2]+"'"),r=utils_type.A.createFunction(e[2],t,""),!utils_type.A.exists(r))throw new Error("JSXGraph: JXG.createRiemannsum: argument 3 'type' has to be string or function.\nPossible parent types: [function,n:number|function,type,start:number|function,end:number|function]");return n=[[0],[0]].concat(e.slice(3)),(a=t.create("curve",n,l)).sum=0,a.Value=function(){return this.sum},a.updateDataArray=function(){var t=numerics.A.riemann(o,s(),r(),this.minX(),this.maxX());this.dataX=t[0],this.dataY=t[1],this.sum=t[2]},a.addParentsFromJCFunctions([s,r]),a},jxg.A.registerElement("riemannsum",jxg.A.createRiemannsum),jxg.A.createTracecurve=function(t,e,i){var s,r,o,n;if(2!==e.length)throw new Error("JSXGraph: Can't create trace curve with given parent'\nPossible parent types: [glider, point]");if(r=t.select(e[0]),o=t.select(e[1]),r.type!==constants.A.OBJECT_TYPE_GLIDER||!utils_type.A.isPoint(o))throw new Error("JSXGraph: Can't create trace curve with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [glider, point]");return(n=utils_type.A.copyAttributes(i,t.options,"tracecurve")).curvetype="plot",(s=t.create("curve",[[0],[0]],n)).updateDataArray=function(){var t,e,i,s,a,l,h,u,c,d=n.numberpoints,p=r.position,_=r.slideObject,f=_.minX();for(e=(_.maxX()-f)/d,this.dataX=[],this.dataY=[],_.elementClass!==constants.A.OBJECT_CLASS_CURVE&&d++,t=0;t<d;t++){for(s in i=f+t*e,l=_.X(i)/_.Z(i),h=_.Y(i)/_.Z(i),r.setPositionDirectly(constants.A.COORDS_BY_USER,[l,h]),u=!1,this.board.objects)if(this.board.objects.hasOwnProperty(s)&&((a=this.board.objects[s])===r&&(u=!0),u&&a.needsRegularUpdate&&(c=a.visProp.trace,a.visProp.trace=!1,a.needsUpdate=!0,a.update(!0),a.visProp.trace=c,a===o)))break;this.dataX[t]=o.X(),this.dataY[t]=o.Y()}for(s in r.position=p,u=!1,this.board.objects)if(this.board.objects.hasOwnProperty(s)&&((a=this.board.objects[s])===r&&(u=!0),u&&a.needsRegularUpdate&&(c=a.visProp.trace,a.visProp.trace=!1,a.needsUpdate=!0,a.update(!0),a.visProp.trace=c,a===o)))break},s},jxg.A.registerElement("tracecurve",jxg.A.createTracecurve),jxg.A.createStepfunction=function(t,e,i){var s,r;if(2!==e.length)throw new Error("JSXGraph: Can't create step function with given parent'\nPossible parent types: [array, array|function]");return r=utils_type.A.copyAttributes(i,t.options,"stepfunction"),(s=t.create("curve",e,r)).updateDataArray=function(){var t,e=0,i=this.xterm.length;if(this.dataX=[],this.dataY=[],0!==i)for(this.dataX[e]=this.xterm[0],this.dataY[e]=this.yterm[0],++e,t=1;t<i;++t)this.dataX[e]=this.xterm[t],this.dataY[e]=this.dataY[e-1],++e,this.dataX[e]=this.xterm[t],this.dataY[e]=this.yterm[t],++e},s},jxg.A.registerElement("stepfunction",jxg.A.createStepfunction),jxg.A.createDerivative=function(t,e,i){var s,r,o,n,a;if(1!==e.length&&e[0].class!==constants.A.OBJECT_CLASS_CURVE)throw new Error("JSXGraph: Can't create derivative curve with given parent'\nPossible parent types: [curve]");return a=utils_type.A.copyAttributes(i,t.options,"curve"),r=e[0],o=numerics.A.D(r.X),n=numerics.A.D(r.Y),(s=t.create("curve",[function(t){return r.X(t)},function(t){return n(t)/o(t)},r.minX(),r.maxX()],a)).setParents(r),s},jxg.A.registerElement("derivative",jxg.A.createDerivative),jxg.A.createCurveIntersection=function(t,e,i){var s;if(2!==e.length)throw new Error("JSXGraph: Can't create curve intersection with given parent'\nPossible parent types: [array, array|function]");return(s=t.create("curve",[[],[]],i)).updateDataArray=function(){var t=clip.intersection(e[0],e[1],this.board);this.dataX=t[0],this.dataY=t[1]},s},jxg.A.createCurveUnion=function(t,e,i){var s;if(2!==e.length)throw new Error("JSXGraph: Can't create curve union with given parent'\nPossible parent types: [array, array|function]");return(s=t.create("curve",[[],[]],i)).updateDataArray=function(){var t=clip.union(e[0],e[1],this.board);this.dataX=t[0],this.dataY=t[1]},s},jxg.A.createCurveDifference=function(t,e,i){var s;if(2!==e.length)throw new Error("JSXGraph: Can't create curve difference with given parent'\nPossible parent types: [array, array|function]");return(s=t.create("curve",[[],[]],i)).updateDataArray=function(){var t=clip.difference(e[0],e[1],this.board);this.dataX=t[0],this.dataY=t[1]},s},jxg.A.registerElement("curvedifference",jxg.A.createCurveDifference),jxg.A.registerElement("curveintersection",jxg.A.createCurveIntersection),jxg.A.registerElement("curveunion",jxg.A.createCurveUnion),jxg.A.createBoxPlot=function(t,e,i){var s,r,o,n=utils_type.A.copyAttributes(i,t.options,"boxplot");if(3!==e.length)throw new Error("JSXGraph: Can't create box plot with given parent'\nPossible parent types: [array, number|function, number|function] containing quantiles, axis, width");if(e[0].length<5)throw new Error("JSXGraph: Can't create box plot with given parent[0]'\nparent[0] has to contain at least 5 quantiles.");for(s=t.create("curve",[[],[]],n),o=e[0].length,s.Q=[],r=0;r<o;r++)s.Q[r]=utils_type.A.createFunction(e[0][r],t);return s.x=utils_type.A.createFunction(e[1],t),s.w=utils_type.A.createFunction(e[2],t),s.updateDataArray=function(){var t,e,i,s,r,o,n,a,l;n=utils_type.A.evaluate(this.visProp.smallwidth),a=utils_type.A.evaluate(this.visProp.dir),i=(l=this.x())-.5*this.w(),s=l-.5*this.w()*n,r=l+.5*this.w(),t=[l,s,o=l+.5*this.w()*n,l,l,i,i,r,r,l,NaN,i,r,NaN,l,l,s,o,l],e=[this.Q[0](),this.Q[0](),this.Q[0](),this.Q[0](),this.Q[1](),this.Q[1](),this.Q[3](),this.Q[3](),this.Q[1](),this.Q[1](),NaN,this.Q[2](),this.Q[2](),NaN,this.Q[3](),this.Q[4](),this.Q[4](),this.Q[4](),this.Q[4]()],"vertical"===a?(this.dataX=t,this.dataY=e):(this.dataX=e,this.dataY=t)},s.addParentsFromJCFunctions([s.Q,s.x,s.w]),s},jxg.A.registerElement("boxplot",jxg.A.createBoxPlot),jxg.A.createImplicitCurve=function(t,e,i){var s,r;if(1!==e.length&&3!==e.length)throw new Error("JSXGraph: Can't create curve implicitCurve with given parent'\nPossible parent types: [f] or [f, dfx, dfy]\nwith functions f, dfx, dfy");return r=utils_type.A.copyAttributes(i,t.options,"implicitcurve"),(s=t.create("curve",[[],[]],r)).f=utils_type.A.createFunction(e[0],t,"x, y"),s.dfx=utils_type.A.createFunction(e[1],t,"x, y"),s.dfy=utils_type.A.createFunction(e[2],t,"x, y"),s.updateDataArray=function(){var t,e,i,s=this.board.getBoundingBox(),r=utils_type.A.evaluate(this.visProp.margin);s[0]-=r,s[1]+=r,s[2]+=r,s[3]-=r,e={resolution_out:Math.max(.01,utils_type.A.evaluate(this.visProp.resolution_outer)),resolution_in:Math.max(.01,utils_type.A.evaluate(this.visProp.resolution_inner)),max_steps:utils_type.A.evaluate(this.visProp.max_steps),alpha_0:utils_type.A.evaluate(this.visProp.alpha_0),tol_u0:utils_type.A.evaluate(this.visProp.tol_u0),tol_newton:utils_type.A.evaluate(this.visProp.tol_newton),tol_cusp:utils_type.A.evaluate(this.visProp.tol_cusp),tol_progress:utils_type.A.evaluate(this.visProp.tol_progress),qdt_box:utils_type.A.evaluate(this.visProp.qdt_box),kappa_0:utils_type.A.evaluate(this.visProp.kappa_0),delta_0:utils_type.A.evaluate(this.visProp.delta_0),h_initial:utils_type.A.evaluate(this.visProp.h_initial),h_critical:utils_type.A.evaluate(this.visProp.h_critical),h_max:utils_type.A.evaluate(this.visProp.h_max),loop_dist:utils_type.A.evaluate(this.visProp.loop_dist),loop_dir:utils_type.A.evaluate(this.visProp.loop_dir),loop_detection:utils_type.A.evaluate(this.visProp.loop_detection),unitX:this.board.unitX,unitY:this.board.unitY},this.dataX=[],this.dataY=[],t=new implicitplot(s,e,this.f,this.dfx,this.dfy),this.qdt=t.qdt,i=t.plot(),this.dataX=i[0],this.dataY=i[1]},s.elType="implicitcurve",s},jxg.A.registerElement("implicitcurve",jxg.A.createImplicitCurve);var curve=jxg.A.Curve;jxg.A.createArc=function(t,e,i){var s,r,o;if(!1===(o=utils_type.A.providePoints(t,e,i,"arc",["center","radiuspoint","anglepoint"]))||o.length<3)throw new Error("JSXGraph: Can't create Arc with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point], [arc, transformation]");return r=utils_type.A.copyAttributes(i,t.options,"arc"),(s=t.create("curve",[[0],[0]],r)).elType="arc",s.setParents(o),s.type=constants.A.OBJECT_TYPE_ARC,s.center=o[0],s.radiuspoint=o[1],s.point2=s.radiuspoint,s.anglepoint=o[2],s.point3=s.anglepoint,utils_type.A.exists(s.center._is_new)?(s.addChild(s.center),delete s.center._is_new):s.center.addChild(s),utils_type.A.exists(s.radiuspoint._is_new)?(s.addChild(s.radiuspoint),delete s.radiuspoint._is_new):s.radiuspoint.addChild(s),utils_type.A.exists(s.anglepoint._is_new)?(s.addChild(s.anglepoint),delete s.anglepoint._is_new):s.anglepoint.addChild(s),s.useDirection=r.usedirection,s.updateDataArray=function(){var t,e,i,s,r,n=1,a=this.radiuspoint,l=this.center,h=this.anglepoint,u=utils_type.A.evaluate(this.visProp.selection);e=geometry.A.rad(a,l,h),("minor"===u&&e>Math.PI||"major"===u&&e<Math.PI)&&(n=-1),this.useDirection&&(i=o[1].coords.usrCoords,s=o[3].coords.usrCoords,r=o[2].coords.usrCoords,(i[1]-r[1])*(i[2]-s[2])-(i[2]-r[2])*(i[1]-s[1])<0?(this.radiuspoint=o[1],this.anglepoint=o[2]):(this.radiuspoint=o[2],this.anglepoint=o[1])),a=a.coords.usrCoords,l=l.coords.usrCoords,h=h.coords.usrCoords,t=geometry.A.bezierArc(a,l,h,!1,n),this.dataX=t[0],this.dataY=t[1],this.bezierDegree=3,this.updateStdform(),this.updateQuadraticform()},s.Radius=function(){return this.radiuspoint.Dist(this.center)},s.getRadius=function(){return jxg.A.deprecated("Arc.getRadius()","Arc.Radius()"),this.Radius()},s.Value=function(t,e){var i;return e=e||geometry.A.rad(this.radiuspoint,this.center,this.anglepoint),""===(t=(t=t||"length").toLocaleLowerCase())||0===t.indexOf("len")?i=e*this.Radius():0===t.indexOf("rad")?i=e:0===t.indexOf("deg")?i=180*e/Math.PI:0===t.indexOf("sem")?i=e/Math.PI:0===t.indexOf("cir")&&(i=.5*e/Math.PI),i},s.L=function(){return this.Value("length")},s.hasPoint=function(t,e){var i,s,r,o,n,a,l,h=this.Radius();return utils_type.A.evaluate(this.visProp.hasinnerpoints)?this.hasPointSector(t,e):(utils_type.A.isObject(utils_type.A.evaluate(this.visProp.precision))?(l=this.board._inputDevice,a=utils_type.A.evaluate(this.visProp.precision[l])):a=this.board.options.precision.hasPoint,a/=Math.min(Math.abs(this.board.unitX),Math.abs(this.board.unitY)),s=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board),this.transformations.length>0&&(this.updateTransformMatrix(),o=math.A.inverse(this.transformMat),n=math.A.matVecMult(o,s.usrCoords),s=new base_coords.A(constants.A.COORDS_BY_USER,n,this.board)),i=this.center.coords.distance(constants.A.COORDS_BY_USER,s),(r=Math.abs(i-h)<a)&&(r=geometry.A.coordsOnArc(this,s)),r)},s.hasPointSector=function(t,e){var i=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board),s=this.Radius(),r=this.center.coords.distance(constants.A.COORDS_BY_USER,i)<s;return r&&(r=geometry.A.coordsOnArc(this,i)),r},s.getTextAnchor=function(){return this.center.coords},s.getLabelAnchor=function(){var t,e,i,s,r,o=geometry.A.rad(this.radiuspoint,this.center,this.anglepoint),n=10/this.board.unitX,a=10/this.board.unitY,l=this.point2.coords.usrCoords,h=this.center.coords.usrCoords,u=l[1]-h[1],c=l[2]-h[2],d=utils_type.A.evaluate(this.visProp.selection),p=this.label?this.label.visProp:this.visProp.label;return("minor"===d&&o>Math.PI||"major"===d&&o<Math.PI)&&(o=-(2*Math.PI-o)),i=(t=new base_coords.A(constants.A.COORDS_BY_USER,[h[1]+Math.cos(.5*o)*u-Math.sin(.5*o)*c,h[2]+Math.sin(.5*o)*u+Math.cos(.5*o)*c],this.board)).usrCoords[1]-h[1],s=t.usrCoords[2]-h[2],i=i*((r=math.A.hypot(i,s))+n)/r,s=s*(r+a)/r,e=[h[1]+i,h[2]+s],p.position=geometry.A.calcLabelQuadrant(geometry.A.rad([1,0],[0,0],e)),new base_coords.A(constants.A.COORDS_BY_USER,e,this.board)},s.updateQuadraticform=circle.prototype.updateQuadraticform,s.updateStdform=circle.prototype.updateStdform,s.methodMap=jxg.A.deepCopy(s.methodMap,{getRadius:"getRadius",radius:"Radius",Radius:"Radius",center:"center",radiuspoint:"radiuspoint",anglepoint:"anglepoint",Value:"Value",L:"L"}),s.prepareUpdate().update(),s},jxg.A.registerElement("arc",jxg.A.createArc),jxg.A.createSemicircle=function(t,e,i){var s,r,o,n;if(!1===(n=utils_type.A.providePoints(t,e,i,"point"))||2!==n.length)throw new Error("JSXGraph: Can't create Semicircle with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point]");return o=utils_type.A.copyAttributes(i,t.options,"semicircle","center"),(r=t.create("midpoint",n,o)).dump=!1,o=utils_type.A.copyAttributes(i,t.options,"semicircle"),(s=t.create("arc",[r,n[1],n[0]],o)).elType="semicircle",s.setParents([n[0].id,n[1].id]),s.subs={midpoint:r},s.inherits.push(r),s.midpoint=s.center=r,s},jxg.A.registerElement("semicircle",jxg.A.createSemicircle),jxg.A.createCircumcircleArc=function(t,e,i){var s,r,o,n;if(!1===(n=utils_type.A.providePoints(t,e,i,"point"))||3!==n.length)throw new Error("JSXGraph: create Circumcircle Arc with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point]");return o=utils_type.A.copyAttributes(i,t.options,"circumcirclearc","center"),(r=t.create("circumcenter",n,o)).dump=!1,(o=utils_type.A.copyAttributes(i,t.options,"circumcirclearc")).usedirection=!0,(s=t.create("arc",[r,n[0],n[2],n[1]],o)).elType="circumcirclearc",s.setParents([n[0].id,n[1].id,n[2].id]),s.subs={center:r},s.inherits.push(r),s.center=r,s},jxg.A.registerElement("circumcirclearc",jxg.A.createCircumcircleArc),jxg.A.createMinorArc=function(t,e,i){return i.selection="minor",jxg.A.createArc(t,e,i)},jxg.A.registerElement("minorarc",jxg.A.createMinorArc),jxg.A.createMajorArc=function(t,e,i){return i.selection="major",jxg.A.createArc(t,e,i)},jxg.A.registerElement("majorarc",jxg.A.createMajorArc),jxg.A.createSector=function(t,e,i){var s,r,o,n,a,l,h="invalid";if(e[0].elementClass===constants.A.OBJECT_CLASS_LINE&&e[1].elementClass===constants.A.OBJECT_CLASS_LINE&&(utils_type.A.isArray(e[2])||utils_type.A.isNumber(e[2]))&&(utils_type.A.isArray(e[3])||utils_type.A.isNumber(e[3]))&&(utils_type.A.isNumber(e[4])||utils_type.A.isFunction(e[4])||utils_type.A.isString(e[4])))h="2lines";else{if(!1===(l=utils_type.A.providePoints(t,e,i,"sector",["center","radiusPoint","anglePoint"])))throw new Error("JSXGraph: Can't create Sector with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"' and '"+typeof e[2]+"'.");h="3points"}if(r=utils_type.A.copyAttributes(i,t.options,"sector"),(s=t.create("curve",[[0],[0]],r)).type=constants.A.OBJECT_TYPE_SECTOR,s.elType="sector",s.autoRadius=function(){var t=20/s.board.unitX,e=1/0,i=50/s.board.unitX;return utils_type.A.isPoint(s.center)&&(e=.3333*s.center.Dist(s.point2)),Math.max(t,Math.min(e,i))},"2lines"===h)s.Radius=function(){var t=utils_type.A.evaluate(e[4]);return"auto"===t?this.autoRadius():t},s.line1=t.select(e[0]),s.line2=t.select(e[1]),s.line1.addChild(s),s.line2.addChild(s),s.setParents(e),s.point1={visProp:{}},s.point2={visProp:{}},s.point3={visProp:{}},n=geometry.A.meetLineLine(s.line1.stdform,s.line2.stdform,0,t),utils_type.A.isArray(e[2])?(2===e[2].length&&(e[2]=[1].concat(e[2])),a=geometry.A.projectPointToLine({coords:{usrCoords:e[2]}},s.line1,t),a=statistics.A.subtract(a.usrCoords,n.usrCoords),s.direction1=math.A.innerProduct(a,[0,s.line1.stdform[2],-s.line1.stdform[1]],3)>=0?1:-1):s.direction1=e[2]>=0?1:-1,utils_type.A.isArray(e[3])?(2===e[3].length&&(e[3]=[1].concat(e[3])),a=geometry.A.projectPointToLine({coords:{usrCoords:e[3]}},s.line2,t),a=statistics.A.subtract(a.usrCoords,n.usrCoords),s.direction2=math.A.innerProduct(a,[0,s.line2.stdform[2],-s.line2.stdform[1]],3)>=0?1:-1):s.direction2=e[3]>=0?1:-1,s.methodMap=jxg.A.deepCopy(s.methodMap,{arc:"arc",center:"center",line1:"line1",line2:"line2"}),s.updateDataArray=function(){var t,e,i,r,o,n,a=[0,0,0];if(e=this.line1,i=this.line2,a=math.A.crossProduct(e.stdform,i.stdform),Math.abs(a[0])>math.A.eps*math.A.eps&&(a[1]/=a[0],a[2]/=a[0],a[0]/=a[0]),t=this.direction1*this.Radius(),r=statistics.A.add(a,[0,t*e.stdform[2],-t*e.stdform[1]]),t=this.direction2*this.Radius(),o=statistics.A.add(a,[0,t*i.stdform[2],-t*i.stdform[1]]),this.point2.coords=new base_coords.A(constants.A.COORDS_BY_USER,r,s.board),this.point1.coords=new base_coords.A(constants.A.COORDS_BY_USER,a,s.board),this.point3.coords=new base_coords.A(constants.A.COORDS_BY_USER,o,s.board),Math.abs(r[0])<math.A.eps||Math.abs(a[0])<math.A.eps||Math.abs(o[0])<math.A.eps)return this.dataX=[NaN],void(this.dataY=[NaN]);n=geometry.A.bezierArc(r,a,o,!0,1),this.dataX=n[0],this.dataY=n[1],this.bezierDegree=3};else if("3points"===h){for(s.point1=l[0],s.point2=l[1],s.point3=l[2],o=0;o<3;o++)utils_type.A.exists(l[o]._is_new)?(s.addChild(l[o]),delete l[o]._is_new):l[o].addChild(s);s.useDirection=i.usedirection,s.setParents(l),utils_type.A.exists(l[3])&&(s.point4=l[3],s.point4.addChild(s)),s.methodMap=jxg.A.deepCopy(s.methodMap,{arc:"arc",center:"center",radiuspoint:"radiuspoint",anglepoint:"anglepoint"}),s.updateDataArray=function(){var t,e,i,s,r,o=this.point2,n=this.point1,a=this.point3,l=1,h=utils_type.A.evaluate(this.visProp.selection);if(!o.isReal||!n.isReal||!a.isReal)return this.dataX=[NaN],void(this.dataY=[NaN]);r=geometry.A.rad(o,n,a),("minor"===h&&r>Math.PI||"major"===h&&r<Math.PI)&&(l=-1),this.useDirection&&utils_type.A.exists(this.point4)&&(e=this.point2.coords.usrCoords,i=this.point4.coords.usrCoords,s=this.point3.coords.usrCoords,(e[1]-s[1])*(e[2]-i[2])-(e[2]-s[2])*(e[1]-i[1])>=0&&(a=this.point2,o=this.point3)),o=o.coords.usrCoords,n=n.coords.usrCoords,a=a.coords.usrCoords,t=geometry.A.bezierArc(o,n,a,!0,l),this.dataX=t[0],this.dataY=t[1],this.bezierDegree=3},s.Radius=function(){return this.point2.Dist(this.point1)}}return s.center=s.point1,s.radiuspoint=s.point2,s.anglepoint=s.point3,r=utils_type.A.copyAttributes(i,t.options,"arc"),(r=utils_type.A.copyAttributes(r,t.options,"sector","arc")).withLabel=!1,r.selection=s.visProp.selection,r.name+="_arc","2lines"===h?(s.updateDataArray(),s.arc=t.create("arc",[function(){return s.point1.coords.usrCoords},function(){var t=s.point2.coords.distance(constants.A.COORDS_BY_USER,s.point1.coords);return 0===t?[s.point1.coords.usrCoords[1],s.point1.coords.usrCoords[2]]:[s.point1.coords.usrCoords[1]+s.Radius()*(s.point2.coords.usrCoords[1]-s.point1.coords.usrCoords[1])/t,s.point1.coords.usrCoords[2]+s.Radius()*(s.point2.coords.usrCoords[2]-s.point1.coords.usrCoords[2])/t]},function(){return s.point3.coords.usrCoords}],r)):s.arc=t.create("arc",[s.point1,function(){var t=s.point2.Dist(s.point1);return 0===t?[s.point1.X(),s.point1.Y()]:[s.point1.X()+s.Radius()*(s.point2.X()-s.point1.X())/t,s.point1.Y()+s.Radius()*(s.point2.Y()-s.point1.Y())/t]},s.point3],r),s.addChild(s.arc),s.hasPointCurve=function(t,e){var i,s,r,o,n,a,l=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board),h=this.Radius(),u=this.center.coords.distance(constants.A.COORDS_BY_USER,l),c=utils_type.A.evaluate(this.visProp.selection);return utils_type.A.isObject(utils_type.A.evaluate(this.visProp.precision))?(n=this.board._inputDevice,o=utils_type.A.evaluate(this.visProp.precision[n])):o=this.board.options.precision.hasPoint,o/=Math.min(Math.abs(this.board.unitX),Math.abs(this.board.unitY)),(a=Math.abs(u-h)<o)&&(i=geometry.A.rad(this.point2,this.center,l.usrCoords.slice(1)),s=0,r=geometry.A.rad(this.point2,this.center,this.point3),("minor"===c&&r>Math.PI||"major"===c&&r<Math.PI)&&(s=r,r=2*Math.PI),(i<s||i>r)&&(a=!1)),a},s.hasPointSector=function(t,e){var i,s,r,o=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board),n=this.Radius(),a=this.point1.coords.distance(constants.A.COORDS_BY_USER,o)<n,l=utils_type.A.evaluate(this.visProp.selection);return a&&(i=geometry.A.rad(this.radiuspoint,this.center,o.usrCoords.slice(1)),s=0,r=geometry.A.rad(this.radiuspoint,this.center,this.anglepoint),("minor"===l&&r>Math.PI||"major"===l&&r<Math.PI)&&(s=r,r=2*Math.PI),(i<s||i>r)&&(a=!1)),a},s.hasPoint=function(t,e){return utils_type.A.evaluate(this.visProp.highlightonsector)||utils_type.A.evaluate(this.visProp.hasinnerpoints)?this.hasPointSector(t,e):this.hasPointCurve(t,e)},s.getTextAnchor=function(){return this.point1.coords},s.getLabelAnchor=function(){var t,e,i,s,r,o=geometry.A.rad(this.point2,this.point1,this.point3),n=13/this.board.unitX,a=13/this.board.unitY,l=this.point2.coords.usrCoords,h=this.point1.coords.usrCoords,u=l[1]-h[1],c=l[2]-h[2],d=utils_type.A.evaluate(this.visProp.selection),p=this.label?this.label.visProp:this.visProp.label;return("minor"===d&&o>Math.PI||"major"===d&&o<Math.PI)&&(o=-(2*Math.PI-o)),i=(t=new base_coords.A(constants.A.COORDS_BY_USER,[h[1]+Math.cos(.5*o)*u-Math.sin(.5*o)*c,h[2]+Math.sin(.5*o)*u+Math.cos(.5*o)*c],this.board)).usrCoords[1]-h[1],s=t.usrCoords[2]-h[2],i=i*((r=math.A.hypot(i,s))+n)/r,s=s*(r+a)/r,e=[h[1]+i,h[2]+s],p.position=geometry.A.calcLabelQuadrant(geometry.A.rad([1,0],[0,0],e)),new base_coords.A(constants.A.COORDS_BY_USER,e,this.board)},s.setRadius=function(t){var e=utils_type.A.evaluate(t);"undefined"!==("auto"===t||"auto"===e?"auto":utils_type.A.isNumber(t)?"number":utils_type.A.isFunction(t)&&!utils_type.A.isString(e)?"function":"undefined")&&(this.visProp.radius=t),s.Radius=function(){var e=utils_type.A.evaluate(t);return"auto"===e?this.autoRadius():e}},s.getRadius=function(){return jxg.A.deprecated("Sector.getRadius()","Sector.Radius()"),this.Radius()},s.Value=function(t){return this.arc.Value(t)},s.L=function(){return this.arc.L()},s.Area=function(){var t=this.Radius();return.5*t*t*this.Value("radians")},s.Perimeter=function(){return this.L()+2*this.Radius()},"3points"===h&&(s.setPositionDirectly=function(t,e,i){var r,o=new base_coords.A(t,e,this.board),n=new base_coords.A(t,i,this.board);return s.point1.draggable()&&s.point2.draggable()&&s.point3.draggable()?(r=statistics.A.subtract(o.usrCoords,n.usrCoords),this.board.create("transform",r.slice(1),{type:"translate"}).applyOnce([s.point1,s.point2,s.point3]),this):this}),s.methodMap=jxg.A.deepCopy(s.methodMap,{radius:"Radius",Radius:"Radius",getRadius:"Radius",setRadius:"setRadius",Value:"Value",L:"L",Area:"Area",Perimeter:"Perimeter"}),s},jxg.A.registerElement("sector",jxg.A.createSector),jxg.A.createCircumcircleSector=function(t,e,i){var s,r,o,n;if(!1===(n=utils_type.A.providePoints(t,e,i,"point")))throw new Error("JSXGraph: Can't create circumcircle sector with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"' and '"+typeof e[2]+"'.");return(r=t.create("circumcenter",n.slice(0,3),o)).dump=!1,o=utils_type.A.copyAttributes(i,t.options,"circumcirclesector"),(s=t.create("sector",[r,n[0],n[2],n[1]],o)).elType="circumcirclesector",s.setParents(n),s.center=r,s.subs={center:r},s},jxg.A.registerElement("circumcirclesector",jxg.A.createCircumcircleSector),jxg.A.createMinorSector=function(t,e,i){return i.selection="minor",jxg.A.createSector(t,e,i)},jxg.A.registerElement("minorsector",jxg.A.createMinorSector),jxg.A.createMajorSector=function(t,e,i){return i.selection="major",jxg.A.createSector(t,e,i)},jxg.A.registerElement("majorsector",jxg.A.createMajorSector),jxg.A.createAngle=function(t,e,i){var s,r,o,n,a,l,h="invalid";if(e[0].elementClass===constants.A.OBJECT_CLASS_LINE&&e[1].elementClass===constants.A.OBJECT_CLASS_LINE&&(utils_type.A.isArray(e[2])||utils_type.A.isNumber(e[2]))&&(utils_type.A.isArray(e[3])||utils_type.A.isNumber(e[3])))h="2lines";else{if(o={name:""},!1===(l=utils_type.A.providePoints(t,e,o,"point")))throw new Error("JSXGraph: Can't create angle with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"' and '"+typeof e[2]+"'.");h="3points"}if(o=utils_type.A.copyAttributes(i,t.options,"angle"),utils_type.A.exists(o.name)&&""!==o.name||(o.name=t.generateName({type:constants.A.OBJECT_TYPE_ANGLE})),r=utils_type.A.exists(o.radius)?o.radius:0,t.suspendUpdate(),"2lines"===h?(e.push(r),(s=t.create("sector",e,o)).updateDataArraySector=s.updateDataArray,s.setAngle=function(t){},s.free=function(t){}):((s=t.create("sector",[l[1],l[0],l[2]],o)).arc.visProp.priv=!0,s.point=s.point2=s.radiuspoint=l[0],s.pointsquare=s.point3=s.anglepoint=l[2],s.Radius=function(){var t=utils_type.A.evaluate(r);return"auto"===t?s.autoRadius():t},s.updateDataArraySector=function(){var t,e,i=this.point2,s=this.point1,r=this.point3,o=this.Radius(),n=s.Dist(i),a=1,l=utils_type.A.evaluate(this.visProp.selection);e=geometry.A.rad(i,s,r),("minor"===l&&e>Math.PI||"major"===l&&e<Math.PI)&&(a=-1),i=i.coords.usrCoords,s=s.coords.usrCoords,r=r.coords.usrCoords,i=[1,s[1]+(i[1]-s[1])*o/n,s[2]+(i[2]-s[2])*o/n],r=[1,s[1]+(r[1]-s[1])*o/n,s[2]+(r[2]-s[2])*o/n],t=geometry.A.bezierArc(i,s,r,!0,a),this.dataX=t[0],this.dataY=t[1],this.bezierDegree=3},s.setAngle=function(t){var e,i,s,r=this.anglepoint,o=this.radiuspoint;return r.draggable()&&(e=this.board.create("transform",[t,this.center],{type:"rotate"}),r.addTransform(o,e),e.update(),r.moveTo(math.A.matVecMult(e.matrix,o.coords.usrCoords)),s=utils_type.A.isFunction(t)?function(){return 2*Math.PI-t()}:function(){return 2*Math.PI-t},i=this.board.create("transform",[s,this.center],{type:"rotate"}),r.coords.on("update",(function(){i.update(),o.moveTo(math.A.matVecMult(i.matrix,r.coords.usrCoords))})),r.setParents(o),this.hasFixedAngle=!0),this},s.free=function(){var t=this.anglepoint;return t.transformations.length>0&&(t.transformations.pop(),t.isDraggable=!0,t.parents=[],t.coords.off("update")),this.hasFixedAngle=!1,this},s.setParents(l)),utils_type.A.exists(s.visProp.text)&&s.label.setText(utils_type.A.evaluate(s.visProp.text)),s.elType="angle",s.type=constants.A.OBJECT_TYPE_ANGLE,s.subs={},s.updateDataArraySquare=function(){var t,e,i,s,r,o,n,a,l=this.Radius();"2lines"===h&&this.updateDataArraySector(),t=this.point2,e=this.point1,i=this.point3,t=t.coords.usrCoords,e=e.coords.usrCoords,i=i.coords.usrCoords,s=geometry.A.distance(t,e,3),r=geometry.A.distance(i,e,3),t=[1,e[1]+(t[1]-e[1])*l/s,e[2]+(t[2]-e[2])*l/s],i=[1,e[1]+(i[1]-e[1])*l/r,e[2]+(i[2]-e[2])*l/r],o=math.A.crossProduct(i,e),n=[-t[1]*o[1]-t[2]*o[2],t[0]*o[1],t[0]*o[2]],o=math.A.crossProduct(t,e),a=[-i[1]*o[1]-i[2]*o[2],i[0]*o[1],i[0]*o[2]],(o=math.A.crossProduct(n,a))[1]/=o[0],o[2]/=o[0],this.dataX=[e[1],t[1],o[1],i[1],e[1]],this.dataY=[e[2],t[2],o[2],i[2],e[2]],this.bezierDegree=1},s.updateDataArrayNone=function(){this.dataX=[NaN],this.dataY=[NaN],this.bezierDegree=1},s.updateDataArray=function(){var t=utils_type.A.evaluate(this.visProp.type),e=geometry.A.trueAngle(this.point2,this.point1,this.point3),i=utils_type.A.evaluate(this.visProp.selection);("minor"===i&&e>180||"major"===i&&e<180)&&(e=360-e),Math.abs(e-90)<utils_type.A.evaluate(this.visProp.orthosensitivity)+math.A.eps&&(t=utils_type.A.evaluate(this.visProp.orthotype)),"none"===t?this.updateDataArrayNone():"square"===t?this.updateDataArraySquare():"sector"===t?this.updateDataArraySector():"sectordot"===t&&(this.updateDataArraySector(),this.dot.visProp.visible||this.dot.setAttribute({visible:!0})),(!this.visProp.visible||"sectordot"!==t&&this.dot.visProp.visible)&&this.dot.setAttribute({visible:!1})},n=utils_type.A.copyAttributes(i,t.options,"angle","dot"),s.dot=t.create("point",[function(){var t,e,i,r,o,n,a,l,h;return utils_type.A.exists(s.dot)&&!s.dot.visProp.visible?[0,0]:(t=s.point2.coords.usrCoords,e=s.point1.coords.usrCoords,i=s.Radius(),r=geometry.A.distance(t,e,3),o=geometry.A.rad(s.point2,s.point1,s.point3),("minor"===(h=utils_type.A.evaluate(s.visProp.selection))&&o>Math.PI||"major"===h&&o<Math.PI)&&(o=-(2*Math.PI-o)),o*=.5,n=Math.cos(o),a=Math.sin(o),t=[1,e[1]+(t[1]-e[1])*i/r,e[2]+(t[2]-e[2])*i/r],l=[[1,0,0],[e[1]-.5*e[1]*n+.5*e[2]*a,.5*n,.5*-a],[e[2]-.5*e[1]*a-.5*e[2]*n,.5*a,.5*n]],math.A.matVecMult(l,t))}],n),s.dot.dump=!1,s.subs.dot=s.dot,"2lines"===h)for(a=0;a<2;a++)t.select(e[a]).addChild(s.dot);else for(a=0;a<3;a++)t.select(l[a]).addChild(s.dot);return t.unsuspendUpdate(),s.Value=function(t){return""===(t=t||"radians")&&(t="radians"),s.arc.Value(t)},s.getLabelAnchor=function(){var t,e,i,r,o,n,a,l,h,u=12,c=utils_type.A.evaluate(s.visProp.selection),d=this.label?this.label.visProp:this.visProp.label;return utils_type.A.exists(this.label)&&utils_type.A.exists(this.label.visProp.fontsize)&&(u=utils_type.A.evaluate(this.label.visProp.fontsize)),u/=this.board.unitX,e=s.point2.coords.usrCoords,i=s.point1.coords.usrCoords,r=s.Radius(),o=geometry.A.distance(e,i,3),n=geometry.A.rad(s.point2,s.point1,s.point3),("minor"===c&&n>Math.PI||"major"===c&&n<Math.PI)&&(n=-(2*Math.PI-n)),n*=.5,a=Math.cos(n),l=Math.sin(n),e=[1,i[1]+(e[1]-i[1])*r/o,i[2]+(e[2]-i[2])*r/o],h=[[1,0,0],[i[1]-.5*i[1]*a+.5*i[2]*l,.5*a,.5*-l],[i[2]-.5*i[1]*l-.5*i[2]*a,.5*l,.5*a]],(t=math.A.matVecMult(h,e))[1]/=t[0],t[2]/=t[0],t[0]/=t[0],o=geometry.A.distance(t,i,3),t=[t[0],i[1]+(t[1]-i[1])*(r+u)/o,i[2]+(t[2]-i[2])*(r+u)/o],d.position=geometry.A.calcLabelQuadrant(geometry.A.rad([1,0],[0,0],t)),new base_coords.A(constants.A.COORDS_BY_USER,t,this.board)},s.methodMap=utils_type.A.deepCopy(s.methodMap,{setAngle:"setAngle",Value:"Value",free:"free"}),s},jxg.A.registerElement("angle",jxg.A.createAngle),jxg.A.createNonreflexAngle=function(t,e,i){var s;return i.selection="minor",i=utils_type.A.copyAttributes(i,t.options,"nonreflexangle"),(s=jxg.A.createAngle(t,e,i)).Value=function(t){var e=geometry.A.rad(this.point2,this.point1,this.point3);return""===(t=t||"radians")&&(t="radians"),e=e<Math.PI?e:2*Math.PI-e,this.arc.Value(t,e)},s},jxg.A.registerElement("nonreflexangle",jxg.A.createNonreflexAngle),jxg.A.createReflexAngle=function(t,e,i){var s;return i.selection="major",i=utils_type.A.copyAttributes(i,t.options,"reflexangle"),(s=jxg.A.createAngle(t,e,i)).Value=function(t){var e=geometry.A.rad(this.point2,this.point1,this.point3);return""===(t=t||"radians")&&(t="radians"),e=e>=Math.PI?e:2*Math.PI-e,this.arc.Value(t,e)},s},jxg.A.registerElement("reflexangle",jxg.A.createReflexAngle),jxg.A.createOrthogonalProjection=function(t,e,i){var s,r,o,n;if(e[0]=t.select(e[0]),e[1]=t.select(e[1]),utils_type.A.isPointType(t,e[0])&&e[1].elementClass===constants.A.OBJECT_CLASS_LINE)r=utils_type.A.providePoints(t,[e[0]],i,"point")[0],s=e[1];else{if(!utils_type.A.isPointType(t,e[1])||e[0].elementClass!==constants.A.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create perpendicular point with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,line]");r=utils_type.A.providePoints(t,[e[1]],i,"point")[0],s=e[0]}return n=utils_type.A.copyAttributes(i,t.options,"orthogonalprojection"),o=t.create("point",[function(){return geometry.A.projectPointToLine(r,s,t)}],n),utils_type.A.exists(r._is_new)?(o.addChild(r),delete r._is_new):r.addChild(o),s.addChild(o),o.elType="orthogonalprojection",o.setParents([r.id,o.id]),o.update(),o.generatePolynomial=function(){var t=s.point1.symbolic.x,e=s.point1.symbolic.y,i=s.point2.symbolic.x,n=s.point2.symbolic.y,a=r.symbolic.x,l=r.symbolic.y,h=o.symbolic.x,u=o.symbolic.y;return["("+e+")*("+h+")-("+e+")*("+i+")+("+u+")*("+i+")-("+t+")*("+u+")+("+t+")*("+n+")-("+h+")*("+n+")","("+l+")*("+e+")-("+l+")*("+n+")-("+u+")*("+e+")+("+u+")*("+n+")+("+a+")*("+t+")-("+a+")*("+i+")-("+h+")*("+t+")+("+h+")*("+i+")"]},o},jxg.A.createPerpendicular=function(t,e,i){var s,r,o,n;if(e[0]=t.select(e[0]),e[1]=t.select(e[1]),utils_type.A.isPointType(t,e[0])&&e[1].elementClass===constants.A.OBJECT_CLASS_LINE)r=e[1],s=utils_type.A.providePoints(t,[e[0]],i,"point")[0];else{if(!utils_type.A.isPointType(t,e[1])||e[0].elementClass!==constants.A.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create perpendicular with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [line,point]");r=e[0],s=utils_type.A.providePoints(t,[e[1]],i,"point")[0]}return n=utils_type.A.copyAttributes(i,t.options,"perpendicular"),(o=jxg.A.createLine(t,[function(){return r.stdform[2]*s.X()-r.stdform[1]*s.Y()},function(){return-r.stdform[2]*s.Z()},function(){return r.stdform[1]*s.Z()}],n)).elType="perpendicular",o.setParents([r.id,s.id]),utils_type.A.exists(s._is_new)?(o.addChild(s),delete s._is_new):s.addChild(o),r.addChild(o),o},jxg.A.createPerpendicularPoint=function(t,e,i){var s,r,o;if(e[0]=t.select(e[0]),e[1]=t.select(e[1]),utils_type.A.isPointType(t,e[0])&&e[1].elementClass===constants.A.OBJECT_CLASS_LINE)r=utils_type.A.providePoints(t,[e[0]],i,"point")[0],s=e[1];else{if(!utils_type.A.isPointType(t,e[1])||e[0].elementClass!==constants.A.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create perpendicular point with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,line]");r=utils_type.A.providePoints(t,[e[1]],i,"point")[0],s=e[0]}return o=t.create("point",[function(){return geometry.A.perpendicular(s,r,t)[0]}],i),utils_type.A.exists(r._is_new)?(o.addChild(r),delete r._is_new):r.addChild(o),s.addChild(o),o.elType="perpendicularpoint",o.setParents([r.id,s.id]),o.update(),o.generatePolynomial=function(){var t=s.point1.symbolic.x,e=s.point1.symbolic.y,i=s.point2.symbolic.x,n=s.point2.symbolic.y,a=r.symbolic.x,l=r.symbolic.y,h=o.symbolic.x,u=o.symbolic.y;return["("+e+")*("+h+")-("+e+")*("+i+")+("+u+")*("+i+")-("+t+")*("+u+")+("+t+")*("+n+")-("+h+")*("+n+")","("+l+")*("+e+")-("+l+")*("+n+")-("+u+")*("+e+")+("+u+")*("+n+")+("+a+")*("+t+")-("+a+")*("+i+")-("+h+")*("+t+")+("+h+")*("+i+")"]},o},jxg.A.createPerpendicularSegment=function(t,e,i){var s,r,o,n,a;if(e[0]=t.select(e[0]),e[1]=t.select(e[1]),utils_type.A.isPointType(t,e[0])&&e[1].elementClass===constants.A.OBJECT_CLASS_LINE)r=e[1],s=utils_type.A.providePoints(t,[e[0]],i,"point")[0];else{if(!utils_type.A.isPointType(t,e[1])||e[0].elementClass!==constants.A.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create perpendicular with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [line,point]");r=e[0],s=utils_type.A.providePoints(t,[e[1]],i,"point")[0]}return a=utils_type.A.copyAttributes(i,t.options,"perpendicularsegment","point"),(n=jxg.A.createPerpendicularPoint(t,[r,s],a)).dump=!1,utils_type.A.exists(i.layer)||(i.layer=t.options.layer.line),a=utils_type.A.copyAttributes(i,t.options,"perpendicularsegment"),(o=jxg.A.createLine(t,[function(){return geometry.A.perpendicular(r,s,t)[1]?[n,s]:[s,n]}],a)).point=n,utils_type.A.exists(s._is_new)?(o.addChild(s),delete s._is_new):s.addChild(o),r.addChild(o),o.elType="perpendicularsegment",o.setParents([s.id,r.id]),o.subs={point:n},o.inherits.push(n),o},jxg.A.createMidpoint=function(t,e,i){var s,r,o,n,a;for(n=0;n<e.length;++n)e[n]=t.select(e[n]);if(2===e.length&&utils_type.A.isPointType(t,e[0])&&utils_type.A.isPointType(t,e[1]))e=utils_type.A.providePoints(t,e,i,"point"),s=e[0],r=e[1];else{if(1!==e.length||e[0].elementClass!==constants.A.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create midpoint.\nPossible parent types: [point,point], [line]");s=e[0].point1,r=e[0].point2}return a=utils_type.A.copyAttributes(i,t.options,"midpoint"),o=t.create("point",[function(){var t=s.coords.usrCoords[1]+r.coords.usrCoords[1];return isNaN(t)||Math.abs(s.coords.usrCoords[0])<math.A.eps||Math.abs(r.coords.usrCoords[0])<math.A.eps?NaN:.5*t},function(){var t=s.coords.usrCoords[2]+r.coords.usrCoords[2];return isNaN(t)||Math.abs(s.coords.usrCoords[0])<math.A.eps||Math.abs(r.coords.usrCoords[0])<math.A.eps?NaN:.5*t}],a),utils_type.A.exists(s._is_new)?(o.addChild(s),delete s._is_new):s.addChild(o),utils_type.A.exists(r._is_new)?(o.addChild(r),delete r._is_new):r.addChild(o),o.elType="midpoint",o.setParents([s.id,r.id]),o.prepareUpdate().update(),o.generatePolynomial=function(){var t=s.symbolic.x,e=s.symbolic.y,i=r.symbolic.x,n=r.symbolic.y,a=o.symbolic.x,l=o.symbolic.y;return["("+e+")*("+a+")-("+e+")*("+i+")+("+l+")*("+i+")-("+t+")*("+l+")+("+t+")*("+n+")-("+a+")*("+n+")","("+t+")^2 - 2*("+t+")*("+a+")+("+e+")^2-2*("+e+")*("+l+")-("+i+")^2+2*("+i+")*("+a+")-("+n+")^2+2*("+n+")*("+l+")"]},o},jxg.A.createParallelPoint=function(t,e,i){var s,r,o,n,a,l;for(a=0;a<e.length;++a)e[a]=t.select(e[a]);if(3===e.length&&utils_type.A.isPointType(t,e[0])&&utils_type.A.isPointType(t,e[1])&&utils_type.A.isPointType(t,e[2]))e=utils_type.A.providePoints(t,e,i,"point"),s=e[0],r=e[1],o=e[2];else if(utils_type.A.isPointType(t,e[0])&&e[1].elementClass===constants.A.OBJECT_CLASS_LINE)o=utils_type.A.providePoints(t,[e[0]],i,"point")[0],s=e[1].point1,r=e[1].point2;else{if(!utils_type.A.isPointType(t,e[1])||e[0].elementClass!==constants.A.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create parallel point with parent types '"+typeof e[0]+"', '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [line,point], [point,point,point]");o=utils_type.A.providePoints(t,[e[1]],i,"point")[0],s=e[0].point1,r=e[0].point2}return l=utils_type.A.copyAttributes(i,t.options,"parallelpoint"),n=t.create("point",[function(){return o.coords.usrCoords[1]+r.coords.usrCoords[1]-s.coords.usrCoords[1]},function(){return o.coords.usrCoords[2]+r.coords.usrCoords[2]-s.coords.usrCoords[2]}],l),utils_type.A.exists(s._is_new)?(n.addChild(s),delete s._is_new):s.addChild(n),utils_type.A.exists(r._is_new)?(n.addChild(r),delete r._is_new):r.addChild(n),utils_type.A.exists(o._is_new)?(n.addChild(o),delete o._is_new):o.addChild(n),n.elType="parallelpoint",n.setParents([s.id,r.id,o.id]),n.prepareUpdate().update(),n.generatePolynomial=function(){var t=s.symbolic.x,e=s.symbolic.y,i=r.symbolic.x,a=r.symbolic.y,l=o.symbolic.x,h=o.symbolic.y,u=n.symbolic.x,c=n.symbolic.y;return["("+a+")*("+u+")-("+a+")*("+l+")-("+e+")*("+u+")+("+e+")*("+l+")-("+c+")*("+i+")+("+c+")*("+t+")+("+h+")*("+i+")-("+h+")*("+t+")","("+c+")*("+t+")-("+c+")*("+l+")-("+a+")*("+t+")+("+a+")*("+l+")-("+u+")*("+e+")+("+u+")*("+h+")+("+i+")*("+e+")-("+i+")*("+h+")"]},n},jxg.A.createParallel=function(t,e,i){var s,r,o,n,a,l,h=1;for(a=0;a<e.length;++a)e[a]=t.select(e[a]);return s=null,3===e.length?(s=(e=utils_type.A.providePoints(t,e,i,"point"))[2],h=0):utils_type.A.isPointType(t,e[0])?(s=utils_type.A.providePoints(t,[e[0]],i,"point")[0],n=function(){return e[1].stdform}):utils_type.A.isPointType(t,e[1])&&(s=utils_type.A.providePoints(t,[e[1]],i,"point")[0],n=function(){return e[0].stdform}),utils_type.A.exists(i.layer)||(i.layer=t.options.layer.line),l=utils_type.A.copyAttributes(i,t.options,"parallel","point"),(r=1===h?t.create("point",[function(){return math.A.crossProduct([1,0,0],n())}],l):t.create("parallelpoint",e,l)).isDraggable=!0,l=utils_type.A.copyAttributes(i,t.options,"parallel"),(o=t.create("line",[s,r],l)).elType="parallel",o.subs={point:r},o.inherits.push(r),o.setParents([e[0].id,e[1].id]),3===e.length&&o.addParents(e[2].id),o.point=r,o},jxg.A.createArrowParallel=function(t,e,i){var s,r;try{return!1===(r=utils_type.A.copyAttributes(i,t.options,"arrowparallel")).lastArrow&&(r.lastArrow=!0),(s=jxg.A.createParallel(t,e,r).setAttribute({straightFirst:!1,straightLast:!1})).type=constants.A.OBJECT_TYPE_VECTOR,s.elType="arrowparallel",s}catch(t){throw new Error("JSXGraph: Can't create arrowparallel with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [line,point], [point,point,point]")}},jxg.A.createNormal=function(t,e,i){var s,r,o,n,a,l,h,u,c;for(n=0;n<e.length;++n)e[n]=t.select(e[n]);if(1===e.length)s=e[0],r=s.slideObject;else{if(2!==e.length)throw new Error("JSXGraph: Can't create normal with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,line], [point,circle], [glider]");if(utils_type.A.isPointType(t,e[0]))s=utils_type.A.providePoints(t,[e[0]],i,"point")[0],r=e[1];else{if(!utils_type.A.isPointType(t,e[1]))throw new Error("JSXGraph: Can't create normal with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,line], [point,circle], [glider]");r=e[0],s=utils_type.A.providePoints(t,[e[1]],i,"point")[0]}}if(h=utils_type.A.copyAttributes(i,t.options,"normal"),r.elementClass===constants.A.OBJECT_CLASS_LINE)c=utils_type.A.copyAttributes(i,t.options,"normal","point"),u=t.create("point",[function(){var t=math.A.crossProduct([1,0,0],r.stdform);return[t[0],-t[2],t[1]]}],c),u.isDraggable=!0,(o=t.create("line",[s,u],h)).point=u,o.subs={point:u},o.inherits.push(u);else if(r.elementClass===constants.A.OBJECT_CLASS_CIRCLE)o=t.create("line",[r.midpoint,s],h);else if(r.elementClass===constants.A.OBJECT_CLASS_CURVE)"plot"!==utils_type.A.evaluate(r.visProp.curvetype)?(a=r.X,l=r.Y,o=t.create("line",[function(){return-s.X()*numerics.A.D(a)(s.position)-s.Y()*numerics.A.D(l)(s.position)},function(){return numerics.A.D(a)(s.position)},function(){return numerics.A.D(l)(s.position)}],h)):o=t.create("line",[function(){var t,e,i,o,n,a,l,h,u,c,d=Math.floor(s.position),p=s.position-d;if(1===r.bezierdegree)d===r.numberPoints-1&&(d-=1,p=1);else{if(3!==r.bezierDegree)return 0;d=3*Math.floor(s.position*(r.numberPoints-1)/3),i=(s.position*(r.numberPoints-1)-d)/3,d>=r.numberPoints-1&&(d=r.numberPoints-4,i=1)}return d<0?1:1===r.bezierDegree?(r.Y(d)+p*(r.Y(d+1)-r.Y(d)))*(r.Y(d)-r.Y(d+1))-(r.X(d)+p*(r.X(d+1)-r.X(d)))*(r.X(d+1)-r.X(d)):(o=r.points[d].usrCoords,n=r.points[d+1].usrCoords,a=r.points[d+2].usrCoords,l=r.points[d+3].usrCoords,h=(1-i)*(1-i)*(n[1]-o[1])+2*(1-i)*i*(a[1]-n[1])+i*i*(l[1]-a[1]),u=(1-i)*(1-i)*(n[2]-o[2])+2*(1-i)*i*(a[2]-n[2])+i*i*(l[2]-a[2]),h/=c=math.A.hypot(h,u),u/=c,e=[1,(t=s.coords.usrCoords)[1]-u,t[2]+h],t[2]*e[1]-t[1]*e[2])},function(){var t,e,i,o,n,a,l,h,u,c=Math.floor(s.position);if(1===r.bezierdegree)c===r.numberPoints-1&&(c-=1);else{if(3!==r.bezierDegree)return 0;c=3*Math.floor(s.position*(r.numberPoints-1)/3),e=(s.position*(r.numberPoints-1)-c)/3,c>=r.numberPoints-1&&(c=r.numberPoints-4,e=1)}return c<0?0:1===r.bezierDegree?r.X(c+1)-r.X(c):(i=r.points[c].usrCoords,o=r.points[c+1].usrCoords,n=r.points[c+2].usrCoords,a=r.points[c+3].usrCoords,l=(1-e)*(1-e)*(o[1]-i[1])+2*(1-e)*e*(n[1]-o[1])+e*e*(a[1]-n[1]),h=(1-e)*(1-e)*(o[2]-i[2])+2*(1-e)*e*(n[2]-o[2])+e*e*(a[2]-n[2]),l/=u=math.A.hypot(l,h),h/=u,[1,(t=s.coords.usrCoords)[1]-h,t[2]+l][2]-t[2])},function(){var t,e,i,o,n,a,l,h,u,c,d=Math.floor(s.position);if(1===r.bezierdegree)d===r.numberPoints-1&&(d-=1);else{if(3!==r.bezierDegree)return 0;d=3*Math.floor(s.position*(r.numberPoints-1)/3),i=(s.position*(r.numberPoints-1)-d)/3,d>=r.numberPoints-1&&(d=r.numberPoints-4,i=1)}return d<0?0:1===r.bezierDegree?r.Y(d+1)-r.Y(d):(o=r.points[d].usrCoords,n=r.points[d+1].usrCoords,a=r.points[d+2].usrCoords,l=r.points[d+3].usrCoords,h=(1-i)*(1-i)*(n[1]-o[1])+2*(1-i)*i*(a[1]-n[1])+i*i*(l[1]-a[1]),u=(1-i)*(1-i)*(n[2]-o[2])+2*(1-i)*i*(a[2]-n[2])+i*i*(l[2]-a[2]),h/=c=math.A.hypot(h,u),u/=c,e=[1,(t=s.coords.usrCoords)[1]-u,t[2]+h],t[1]-e[1])}],h);else{if(r.type!==constants.A.OBJECT_TYPE_TURTLE)throw new Error("JSXGraph: Can't create normal with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,line], [point,circle], [glider]");o=t.create("line",[function(){var t,e,i=Math.floor(s.position),o=s.position-i;for(e=0;e<r.objects.length;e++)if((t=r.objects[e]).type===constants.A.OBJECT_TYPE_CURVE){if(i<t.numberPoints)break;i-=t.numberPoints}return i===t.numberPoints-1&&(i-=1,o=1),i<0?1:(t.Y(i)+o*(t.Y(i+1)-t.Y(i)))*(t.Y(i)-t.Y(i+1))-(t.X(i)+o*(t.X(i+1)-t.X(i)))*(t.X(i+1)-t.X(i))},function(){var t,e,i=Math.floor(s.position);for(e=0;e<r.objects.length;e++)if((t=r.objects[e]).type===constants.A.OBJECT_TYPE_CURVE){if(i<t.numberPoints)break;i-=t.numberPoints}return i===t.numberPoints-1&&(i-=1),i<0?0:t.X(i+1)-t.X(i)},function(){var t,e,i=Math.floor(s.position);for(e=0;e<r.objects.length;e++)if((t=r.objects[e]).type===constants.A.OBJECT_TYPE_CURVE){if(i<t.numberPoints)break;i-=t.numberPoints}return i===t.numberPoints-1&&(i-=1),i<0?0:t.Y(i+1)-t.Y(i)}],h)}return o.elType="normal",o.setParents(e),utils_type.A.exists(s._is_new)?(o.addChild(s),delete s._is_new):s.addChild(o),r.addChild(o),o},jxg.A.createBisector=function(t,e,i){var s,r,o,n;if(e=utils_type.A.providePoints(t,e,i,"point"),utils_type.A.isPoint(e[0])&&utils_type.A.isPoint(e[1])&&utils_type.A.isPoint(e[2])){for((n=utils_type.A.copyAttributes(i,t.options,"bisector","point")).snapToGrid=!1,(s=t.create("point",[function(){return geometry.A.angleBisector(e[0],e[1],e[2],t)}],n)).dump=!1,o=0;o<3;o++)utils_type.A.exists(e[o]._is_new)?(s.addChild(e[o]),delete e[o]._is_new):e[o].addChild(s);return utils_type.A.exists(i.layer)||(i.layer=t.options.layer.line),n=utils_type.A.copyAttributes(i,t.options,"bisector"),(r=jxg.A.createLine(t,[e[1],s],n)).point=s,r.elType="bisector",r.setParents(e),r.subs={point:s},r.inherits.push(s),r}throw new Error("JSXGraph: Can't create angle bisector with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point,point]")},jxg.A.createAngularBisectorsOfTwoLines=function(t,e,i){var s,r,o,n,a=t.select(e[0]),l=t.select(e[1]);if(a.elementClass!==constants.A.OBJECT_CLASS_LINE||l.elementClass!==constants.A.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create angle bisectors of two lines with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [line,line]");return utils_type.A.exists(i.layer)||(i.layer=t.options.layer.line),o=utils_type.A.copyAttributes(i,t.options,"bisectorlines","line1"),s=t.create("line",[function(){var t=math.A.hypot(a.stdform[1],a.stdform[2]),e=math.A.hypot(l.stdform[1],l.stdform[2]);return a.stdform[0]/t-l.stdform[0]/e},function(){var t=math.A.hypot(a.stdform[1],a.stdform[2]),e=math.A.hypot(l.stdform[1],l.stdform[2]);return a.stdform[1]/t-l.stdform[1]/e},function(){var t=math.A.hypot(a.stdform[1],a.stdform[2]),e=math.A.hypot(l.stdform[1],l.stdform[2]);return a.stdform[2]/t-l.stdform[2]/e}],o),utils_type.A.exists(i.layer)||(i.layer=t.options.layer.line),o=utils_type.A.copyAttributes(i,t.options,"bisectorlines","line2"),r=t.create("line",[function(){var t=math.A.hypot(a.stdform[1],a.stdform[2]),e=math.A.hypot(l.stdform[1],l.stdform[2]);return a.stdform[0]/t+l.stdform[0]/e},function(){var t=math.A.hypot(a.stdform[1],a.stdform[2]),e=math.A.hypot(l.stdform[1],l.stdform[2]);return a.stdform[1]/t+l.stdform[1]/e},function(){var t=math.A.hypot(a.stdform[1],a.stdform[2]),e=math.A.hypot(l.stdform[1],l.stdform[2]);return a.stdform[2]/t+l.stdform[2]/e}],o),n=new composition({line1:s,line2:r}),s.dump=!1,r.dump=!1,n.elType="bisectorlines",n.setParents([a.id,l.id]),n.subs={line1:s,line2:r},n},jxg.A.createCircumcenter=function(t,e,i){var s,r,o,n,a;if(e=utils_type.A.providePoints(t,e,i,"point"),utils_type.A.isPoint(e[0])&&utils_type.A.isPoint(e[1])&&utils_type.A.isPoint(e[2])){for(o=e[0],n=e[1],a=e[2],s=jxg.A.createPoint(t,[function(){return geometry.A.circumcenter(o,n,a,t)}],i),r=0;r<3;r++)utils_type.A.exists(e[r]._is_new)?(s.addChild(e[r]),delete e[r]._is_new):e[r].addChild(s);return s.elType="circumcenter",s.setParents(e),s.generatePolynomial=function(){var t=o.symbolic.x,e=o.symbolic.y,i=n.symbolic.x,r=n.symbolic.y,l=a.symbolic.x,h=a.symbolic.y,u=s.symbolic.x,c=s.symbolic.y;return[["((",u,")-(",t,"))^2+((",c,")-(",e,"))^2-((",u,")-(",i,"))^2-((",c,")-(",r,"))^2"].join(""),["((",u,")-(",t,"))^2+((",c,")-(",e,"))^2-((",u,")-(",l,"))^2-((",c,")-(",h,"))^2"].join("")]},s}throw new Error("JSXGraph: Can't create circumcircle midpoint with parent types '"+typeof e[0]+"', '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point]")},jxg.A.createIncenter=function(t,e,i){var s,r,o,n,a;if(!((e=utils_type.A.providePoints(t,e,i,"point")).length>=3&&utils_type.A.isPoint(e[0])&&utils_type.A.isPoint(e[1])&&utils_type.A.isPoint(e[2])))throw new Error("JSXGraph: Can't create incenter with parent types '"+typeof e[0]+"', '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point]");for(r=e[0],o=e[1],n=e[2],s=t.create("point",[function(){var e,i,s;return e=math.A.hypot(o.X()-n.X(),o.Y()-n.Y()),i=math.A.hypot(r.X()-n.X(),r.Y()-n.Y()),s=math.A.hypot(o.X()-r.X(),o.Y()-r.Y()),new base_coords.A(constants.A.COORDS_BY_USER,[(e*r.X()+i*o.X()+s*n.X())/(e+i+s),(e*r.Y()+i*o.Y()+s*n.Y())/(e+i+s)],t)}],i),a=0;a<3;a++)utils_type.A.exists(e[a]._is_new)?(s.addChild(e[a]),delete e[a]._is_new):e[a].addChild(s);return s.elType="incenter",s.setParents(e),s},jxg.A.createCircumcircle=function(t,e,i){var s,r,o,n;if(!1===(e=utils_type.A.providePoints(t,e,i,"point")))throw new Error("JSXGraph: Can't create circumcircle with parent types '"+typeof e[0]+"', '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point]");try{for(o=utils_type.A.copyAttributes(i,t.options,"circumcircle","center"),(s=jxg.A.createCircumcenter(t,e,o)).dump=!1,utils_type.A.exists(i.layer)||(i.layer=t.options.layer.circle),o=utils_type.A.copyAttributes(i,t.options,"circumcircle"),(r=jxg.A.createCircle(t,[s,e[0]],o)).elType="circumcircle",r.setParents(e),r.subs={center:s},r.inherits.push(r),n=0;n<3;n++)utils_type.A.exists(e[n]._is_new)?(r.addChild(e[n]),delete e[n]._is_new):e[n].addChild(r)}catch(t){throw new Error("JSXGraph: Can't create circumcircle with parent types '"+typeof e[0]+"', '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point]")}return r},jxg.A.createIncircle=function(t,e,i){var s,r,o,n;if(!1===(e=utils_type.A.providePoints(t,e,i,"point")))throw new Error("JSXGraph: Can't create circumcircle with parent types '"+typeof e[0]+"', '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point]");try{for(n=utils_type.A.copyAttributes(i,t.options,"incircle","center"),(r=jxg.A.createIncenter(t,e,n)).dump=!1,utils_type.A.exists(i.layer)||(i.layer=t.options.layer.circle),n=utils_type.A.copyAttributes(i,t.options,"incircle"),(o=jxg.A.createCircle(t,[r,function(){var t=math.A.hypot(e[1].X()-e[2].X(),e[1].Y()-e[2].Y()),i=math.A.hypot(e[0].X()-e[2].X(),e[0].Y()-e[2].Y()),s=math.A.hypot(e[1].X()-e[0].X(),e[1].Y()-e[0].Y()),r=(t+i+s)/2;return Math.sqrt((r-t)*(r-i)*(r-s)/r)}],n)).elType="incircle",o.setParents(e),s=0;s<3;s++)utils_type.A.exists(e[s]._is_new)?(o.addChild(e[s]),delete e[s]._is_new):e[s].addChild(o);o.center=r,o.subs={center:o.center},o.inherits.push(r)}catch(t){throw new Error("JSXGraph: Can't create circumcircle with parent types '"+typeof e[0]+"', '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point]")}return o},jxg.A.createReflection=function(t,e,i){var s,r,o,n,a,l,h,u,c="\nPossible parent types: [point|line|curve|polygon|circle|arc|sector, line]";for(l=0;l<e.length;++l)e[l]=t.select(e[l]);if(h=utils_type.A.copyAttributes(i,t.options,"reflection"),utils_type.A.isPoint(e[0]))r=utils_type.A.providePoints(t,[e[0]],u)[0];else{if(e[0].elementClass!==constants.A.OBJECT_CLASS_CURVE&&e[0].elementClass!==constants.A.OBJECT_CLASS_LINE&&e[0].type!==constants.A.OBJECT_TYPE_POLYGON&&e[0].elementClass!==constants.A.OBJECT_CLASS_CIRCLE)throw new Error("JSXGraph: Can't create reflection element with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'."+c);r=e[0]}if(e[1].elementClass!==constants.A.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create reflected element with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'."+c);if(s=e[1],a=jxg.A.createTransform(t,[s],{type:"reflect"}),utils_type.A.isPoint(r))o=jxg.A.createPoint(t,[r,a],h);else if(r.elementClass===constants.A.OBJECT_CLASS_CURVE)o=jxg.A.createCurve(t,[r,a],h);else if(r.elementClass===constants.A.OBJECT_CLASS_LINE)o=jxg.A.createLine(t,[r,a],h);else if(r.type===constants.A.OBJECT_TYPE_POLYGON)o=jxg.A.createPolygon(t,[r,a],h);else{if(r.elementClass!==constants.A.OBJECT_CLASS_CIRCLE)throw new Error("JSXGraph: Can't create reflected element with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'."+c);"euclidean"===h.type.toLowerCase()?(u=utils_type.A.copyAttributes(i,t.options,"reflection","center"),(n=jxg.A.createPoint(t,[r.center,a],u)).prepareUpdate().update().updateVisibility(utils_type.A.evaluate(n.visProp.visible)).updateRenderer(),o=jxg.A.createCircle(t,[n,function(){return r.Radius()}],h)):o=jxg.A.createCircle(t,[r,a],h)}return utils_type.A.exists(r._is_new)&&(o.addChild(r),delete r._is_new),s.addChild(o),o.elType="reflection",o.addParents(s),o.prepareUpdate().update(),utils_type.A.isPoint(o)&&(o.generatePolynomial=function(){var t=s.point1.symbolic.x,e=s.point1.symbolic.y,i=s.point2.symbolic.x,n=s.point2.symbolic.y,a=r.symbolic.x,l=r.symbolic.y,h=o.symbolic.x,u=o.symbolic.y;return[["((",u,")-(",l,"))*((",e,")-(",n,"))+((",t,")-(",i,"))*((",h,")-(",a,"))"].join(""),["((",h,")-(",t,"))^2+((",u,")-(",e,"))^2-((",a,")-(",t,"))^2-((",l,")-(",e,"))^2"].join("")]}),o},jxg.A.createMirrorElement=function(t,e,i){var s,r,o,n,a,l,h,u,c="\nPossible parent types: [point|line|curve|polygon|circle|arc|sector, point]";for(r=0;r<e.length;++r)e[r]=t.select(e[r]);if(h=utils_type.A.copyAttributes(i,t.options,"mirrorelement"),utils_type.A.isPoint(e[0]))s=utils_type.A.providePoints(t,[e[0]],h)[0];else{if(e[0].elementClass!==constants.A.OBJECT_CLASS_CURVE&&e[0].elementClass!==constants.A.OBJECT_CLASS_LINE&&e[0].type!==constants.A.OBJECT_TYPE_POLYGON&&e[0].elementClass!==constants.A.OBJECT_CLASS_CIRCLE)throw new Error("JSXGraph: Can't create mirror element with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'."+c);s=e[0]}if(!utils_type.A.isPoint(e[1]))throw new Error("JSXGraph: Can't create mirror element with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'."+c);if(u=utils_type.A.copyAttributes(i,t.options,"mirrorelement","point"),o=utils_type.A.providePoints(t,[e[1]],u)[0],l=jxg.A.createTransform(t,[Math.PI,o],{type:"rotate"}),utils_type.A.isPoint(s))n=jxg.A.createPoint(t,[s,l],h);else if(s.elementClass===constants.A.OBJECT_CLASS_CURVE)n=jxg.A.createCurve(t,[s,l],h);else if(s.elementClass===constants.A.OBJECT_CLASS_LINE)n=jxg.A.createLine(t,[s,l],h);else if(s.type===constants.A.OBJECT_TYPE_POLYGON)n=jxg.A.createPolygon(t,[s,l],h);else{if(s.elementClass!==constants.A.OBJECT_CLASS_CIRCLE)throw new Error("JSXGraph: Can't create mirror element with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'."+c);"euclidean"===h.type.toLowerCase()?(u=utils_type.A.copyAttributes(i,t.options,"mirrorelement","center"),(a=jxg.A.createPoint(t,[s.center,l],u)).prepareUpdate().update().updateVisibility(utils_type.A.evaluate(a.visProp.visible)).updateRenderer(),n=jxg.A.createCircle(t,[a,function(){return s.Radius()}],h)):n=jxg.A.createCircle(t,[s,l],h)}return utils_type.A.exists(s._is_new)&&(n.addChild(s),delete s._is_new),o.addChild(n),n.elType="mirrorelement",n.addParents(o),n.prepareUpdate().update(),n},jxg.A.createMirrorPoint=function(t,e,i){var s=jxg.A.createMirrorElement(t,e,i);return s.elType="mirrorpoint",s},jxg.A.createIntegral=function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_,f,A,g,m=null;if(utils_type.A.isArray(e[0])&&e[1].elementClass===constants.A.OBJECT_CLASS_CURVE)s=e[0],r=e[1];else{if(!utils_type.A.isArray(e[1])||e[0].elementClass!==constants.A.OBJECT_CLASS_CURVE)throw new Error("JSXGraph: Can't create integral with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [[number|function,number|function],curve]");s=e[1],r=e[0]}return(o=utils_type.A.copyAttributes(i,t.options,"integral")).withLabel=!1,g=t.create("curve",[[0],[0]],o),n=s[0],a=s[1],utils_type.A.isFunction(n)?(h=function(){return r.Y(l())},n=(l=n)()):(l=n,h=r.Y(n)),utils_type.A.isFunction(a)?(c=function(){return r.Y(u())},a=(u=a)()):(u=a,c=r.Y(a)),o=utils_type.A.copyAttributes(i,t.options,"integral","curveLeft"),d=t.create("glider",[l,h,r],o),utils_type.A.isFunction(l)&&d.hideElement(),o=utils_type.A.copyAttributes(i,t.options,"integral","baseLeft"),p=t.create("point",[function(){return"y"===utils_type.A.evaluate(g.visProp.axis)?0:d.X()},function(){return"y"===utils_type.A.evaluate(g.visProp.axis)?d.Y():0}],o),o=utils_type.A.copyAttributes(i,t.options,"integral","curveRight"),_=t.create("glider",[u,c,r],o),utils_type.A.isFunction(u)&&_.hideElement(),o=utils_type.A.copyAttributes(i,t.options,"integral","baseRight"),f=t.create("point",[function(){return"y"===utils_type.A.evaluate(g.visProp.axis)?0:_.X()},function(){return"y"===utils_type.A.evaluate(g.visProp.axis)?_.Y():0}],o),!1!==(o=utils_type.A.copyAttributes(i,t.options,"integral")).withlabel&&"y"!==o.axis&&(o=utils_type.A.copyAttributes(i,t.options,"integral","label"),o=utils_type.A.copyAttributes(o,t.options,"label"),A=function(){var t=numerics.A.NewtonCotes([p.X(),f.X()],r.Y),e=utils_type.A.evaluate(m.visProp.digits);return"&int; = "+(m.useLocale()?m.formatNumberLocale(t,e):utils_type.A.toFixed(t,e))},(m=t.create("text",[function(){var t=new base_coords.A(constants.A.COORDS_BY_SCREEN,[utils_type.A.evaluate(this.visProp.offset[0])+this.board.origin.scrCoords[1],0],this.board,!1),e=this.board.getBoundingBox(),i=.1*(e[2]-e[0]),s=_.X();return s<e[0]?s=e[0]+i:s>e[2]&&(s=e[2]-i),s+t.usrCoords[1]},function(){var t=new base_coords.A(constants.A.COORDS_BY_SCREEN,[0,utils_type.A.evaluate(this.visProp.offset[1])+this.board.origin.scrCoords[2]],this.board,!1),e=this.board.getBoundingBox(),i=.1*(e[1]-e[3]),s=_.Y();return s>e[1]?s=e[1]-i:s<e[3]&&(s=e[3]+i),s+t.usrCoords[2]},""],o)).setText(A),m.dump=!1,d.addChild(m),_.addChild(m)),d.dump=!1,p.dump=!1,_.dump=!1,f.dump=!1,g.elType="integral",g.setParents([r.id,s]),g.subs={curveLeft:d,baseLeft:p,curveRight:_,baseRight:f},g.inherits.push(d,p,_,f),o.withLabel&&(g.subs.label=m,g.inherits.push(m)),g.Value=function(){return numerics.A.I([p.X(),f.X()],r.Y)},g.updateDataArray=function(){var t,e,i,s,o,n,a,l,h;if("y"===utils_type.A.evaluate(this.visProp.axis)){for(d.Y()<_.Y()?(n=d.X(),l=d.Y(),a=_.X(),h=_.Y()):(n=_.X(),l=_.Y(),a=d.X(),h=d.Y()),s=Math.min(n,a),o=Math.max(n,a),t=[0,n],e=[l,l],i=0;i<r.numberPoints;i++)l<=r.points[i].usrCoords[2]&&s<=r.points[i].usrCoords[1]&&r.points[i].usrCoords[2]<=h&&r.points[i].usrCoords[1]<=o&&(t.push(r.points[i].usrCoords[1]),e.push(r.points[i].usrCoords[2]));t.push(a),e.push(h),t.push(0),e.push(h),t.push(0),e.push(l)}else{for(p.X()<f.X()?(s=p.X(),o=f.X()):(s=f.X(),o=p.X()),t=[s,s],e=[0,r.Y(s)],i=0;i<r.numberPoints;i++)s<=r.points[i].usrCoords[1]&&r.points[i].usrCoords[1]<=o&&(t.push(r.points[i].usrCoords[1]),e.push(r.points[i].usrCoords[2]));t.push(o),e.push(r.Y(o)),t.push(o),e.push(0),t.push(s),e.push(0)}this.dataX=t,this.dataY=e},d.addChild(g),_.addChild(g),p.addChild(g),f.addChild(g),g.baseLeft=p,g.baseRight=f,g.curveLeft=d,g.curveRight=_,g.methodMap=jxg.A.deepCopy(g.methodMap,{curveLeft:"curveLeft",baseLeft:"baseLeft",curveRight:"curveRight",baseRight:"baseRight",Value:"Value"}),g.label=m,g},jxg.A.createInequality=function(t,e,i){var s,r,o;if(o=utils_type.A.copyAttributes(i,t.options,"inequality"),e[0].elementClass===constants.A.OBJECT_CLASS_LINE)(r=t.create("curve",[[],[]],o)).hasPoint=function(){return!1},r.updateDataArray=function(){var i,s,r,o=t.getBoundingBox(),n=utils_type.A.evaluate(this.visProp.inverse),a=n?-1:1,l=1.5*Math.max(o[2]-o[0],o[1]-o[3]),h={coords:{usrCoords:[1,.5*(o[0]+o[2]),n?o[1]:o[3]]}},u=e[0].stdform.slice(1),c=u;r=1.5*Math.max(geometry.A.perpendicular(e[0],h,t)[0].distance(constants.A.COORDS_BY_USER,h.coords),l),r*=a,h={coords:{usrCoords:[1,.5*(o[0]+o[2]),.5*(o[1]+o[3])]}},i=[1,(h=Math.abs(math.A.innerProduct(h.coords.usrCoords,e[0].stdform,3))>=math.A.eps?geometry.A.perpendicular(e[0],h,t)[0].usrCoords:h.coords.usrCoords)[1]+u[1]*l,h[2]-u[0]*l],s=[1,h[1]-c[1]*l,h[2]+c[0]*l],this.dataX=[i[1],i[1]+u[0]*r,s[1]+c[0]*r,s[1],i[1]],this.dataY=[i[2],i[2]+u[1]*r,s[2]+c[1]*r,s[2],i[2]]};else if(e[0].elementClass===constants.A.OBJECT_CLASS_CURVE&&"functiongraph"===e[0].visProp.curvetype)(r=t.create("curve",[[],[]],o)).updateDataArray=function(){var t,i,s,r,o,n,a,l,h,u=this.board.getBoundingBox(),c=[],d=e[0].minX(),p=e[0].maxX(),_=.3*(u[1]-u[3]);if(t=utils_type.A.evaluate(this.visProp.inverse)?1:3,this.dataX=[],this.dataY=[],0!==(r=e[0].points.length))for(u[1]+=_,u[3]-=_,s=-1;s<r-1;){for(o=s+1,i=r;o<r;o++)if(e[0].points[o].isReal()){i=o;break}if(i>=r)break;for(o=i,s=r-1;o<r-1;o++)if(!e[0].points[o+1].isReal()){s=o;break}for(l=e[0].points[i].usrCoords[1],h=e[0].points[s].usrCoords[1],n=u[0]<d?d:u[0],a=u[2]>p?p:u[2],n=0===i?n:Math.max(n,l),a=s===r-1?a:Math.min(a,h),a=s===r-1?p:h,(c=[]).push([1,n=0===i?d:l,u[t]]),c.push([1,n,e[0].points[i].usrCoords[2]]),o=i;o<=s;o++)c.push(e[0].points[o].usrCoords);for(c.push([1,a,e[0].points[s].usrCoords[2]]),c.push([1,a,u[t]]),c.push(c[0]),o=0;o<c.length;o++)this.dataX.push(c[o][1]),this.dataY.push(c[o][2]);s<r-1&&(this.dataX.push(NaN),this.dataY.push(NaN))}},r.hasPoint=function(){return!1};else if(s=utils_type.A.createFunction(e[0]),r.addParentsFromJCFunctions([s]),!utils_type.A.exists(s))throw new Error("JSXGraph: Can't create area with the given parents.\nPossible parent types: [line], [function]");return r.addParents(e[0]),r},jxg.A.registerElement("arrowparallel",jxg.A.createArrowParallel),jxg.A.registerElement("bisector",jxg.A.createBisector),jxg.A.registerElement("bisectorlines",jxg.A.createAngularBisectorsOfTwoLines),jxg.A.registerElement("msector",jxg.A.createMsector),jxg.A.registerElement("circumcircle",jxg.A.createCircumcircle),jxg.A.registerElement("circumcirclemidpoint",jxg.A.createCircumcenter),jxg.A.registerElement("circumcenter",jxg.A.createCircumcenter),jxg.A.registerElement("incenter",jxg.A.createIncenter),jxg.A.registerElement("incircle",jxg.A.createIncircle),jxg.A.registerElement("integral",jxg.A.createIntegral),jxg.A.registerElement("midpoint",jxg.A.createMidpoint),jxg.A.registerElement("mirrorelement",jxg.A.createMirrorElement),jxg.A.registerElement("mirrorpoint",jxg.A.createMirrorPoint),jxg.A.registerElement("normal",jxg.A.createNormal),jxg.A.registerElement("orthogonalprojection",jxg.A.createOrthogonalProjection),jxg.A.registerElement("parallel",jxg.A.createParallel),jxg.A.registerElement("parallelpoint",jxg.A.createParallelPoint),jxg.A.registerElement("perpendicular",jxg.A.createPerpendicular),jxg.A.registerElement("perpendicularpoint",jxg.A.createPerpendicularPoint),jxg.A.registerElement("perpendicularsegment",jxg.A.createPerpendicularSegment),jxg.A.registerElement("reflection",jxg.A.createReflection),jxg.A.registerElement("inequality",jxg.A.createInequality),jxg.A.createGrid=function(t,e,i){const s=math.A.eps,r=5e3;var o,n,a,l,h,u,c,d,p=[],_=[];if((a=e).length>2||a.length>=1&&"axis"!==a[0].elType||a.length>=2&&"axis"!==a[1].elType)throw new Error("JSXGraph: Can't create 'grid' with parent type '"+e[0].elType+"'. Possible parent types: [axis,axis]");return!utils_type.A.exists(a[0])&&utils_type.A.exists(t.defaultAxes)&&(a[0]=t.defaultAxes.x),!utils_type.A.exists(a[1])&&utils_type.A.exists(t.defaultAxes)&&(a[1]=t.defaultAxes.y),d=function(t,e,i,s,r,o,n){var a,l,h,u,c,d,p;switch(t.toLowerCase()){case".":case"point":return e.visProp.linecap="round",e.visProp.strokewidth=r*e.board.unitX+o*e.board.unitY,[[i,i,NaN],[s,s,NaN]];case"o":case"circle":return e.visProp.linecap="square",e.bezierDegree=3,[[i+r,i+r,i+(l=4*Math.tan(Math.PI/8)/3)*r,i,i-l*r,i-r,i-r,i-r,i-l*r,i,i+l*r,i+r,i+r,NaN],[s,s+l*o,s+o,s+o,s+o,s+l*o,s,s-l*o,s-o,s-o,s-o,s-l*o,s,NaN]];case"regpol":case"regularpolygon":for(e.visProp.linecap="round",u=utils_type.A.evaluate(e.visProp.polygonvertices),c=[[],[]],a=0;a<=2*Math.PI;a+=2*Math.PI/u)c[0].push(i-r*Math.sin(a)),c[1].push(s-o*Math.cos(a));return c[0].push(NaN),c[1].push(NaN),c;case"[]":case"square":return e.visProp.linecap="square",[[i-r,i+r,i+r,i-r,i-r,NaN],[s+o,s+o,s-o,s-o,s+o,NaN]];case"<>":case"diamond":return e.visProp.linecap="square",[[i,i+r,i,i-r,i,NaN],[s+o,s,s-o,s,s+o,NaN]];case"<<>>":case"diamond2":return e.visProp.linecap="square",[[i,i+(d=r*Math.sqrt(2)),i,i-d,i,NaN],[s+(p=o*Math.sqrt(2)),s,s-p,s,s+p,NaN]];case"x":case"cross":return[[i-r,i+r,NaN,i-r,i+r,NaN],[s+o,s-o,NaN,s-o,s+o,NaN]];case"+":case"plus":return[[i-r,i+r,NaN,i,i,NaN],[s,s,NaN,s-o,s+o,NaN]];case"-":case"minus":return[[i-r,i+r,NaN],[s,s,NaN]];case"|":case"divide":return[[i,i,NaN],[s-o,s+o,NaN]];case"^":case"a":case"A":case"triangleup":return[[i-r,i,i+r,NaN],[s-o,s,s-o,NaN]];case"v":case"triangledown":return[[i-r,i,i+r,NaN],[s+o,s,s+o,NaN]];case"<":case"triangleleft":return[[i+r,i,i+r,NaN],[s+o,s,s-o,NaN]];case">":case"triangleright":return[[i-r,i,i-r,NaN],[s+o,s,s-o,NaN]];case"line":return h=utils_type.A.evaluate(e.visProp.margin),[[i,i,NaN,n[0]-h/e.board.unitX,n[2]+h/e.board.unitX,NaN],[n[1]+h/e.board.unitY,n[3]-h/e.board.unitY,NaN,s,s,NaN]];default:return[[],[]]}},l=utils_type.A.copyAttributes(i,t.options,"grid"),utils_type.A.mergeAttr(l,l.themes[l.theme],!1),h={},utils_type.A.mergeAttr(h,l,!0,!0),utils_type.A.mergeAttr(h,l.major,!0,!0),(o=t.create("curve",[[null],[null]],h)).elType="grid",o.type=constants.A.OBJECT_TYPE_GRID,u={},utils_type.A.mergeAttr(u,l,!0,!0),utils_type.A.mergeAttr(u,l.minor,!0,!0),u.id===h.id&&(u.id=o.id+"_minor"),u.name===h.name&&(u.name=o.name+"_minor"),(n=t.create("curve",[[null],[null]],u)).elType="grid",n.type=constants.A.OBJECT_TYPE_GRID,o.minorGrid=n,n.majorGrid=o,o.hasPoint=function(){return!1},n.hasPoint=function(){return!1},o.inherits.push(n),o.updateDataArray=function(){var t,e,i,n,l,h,u,f,A=this.board.getBoundingBox(),g=utils_type.A.evaluate(this.visProp.gridx),m=utils_type.A.evaluate(this.visProp.gridy),y=utils_type.A.evaluate(this.visProp.face),b=utils_type.A.evaluate(this.visProp.drawzero),v=!0===b||utils_type.A.isObject(b)&&!0===utils_type.A.evaluate(b.origin),C=!0===b||utils_type.A.isObject(b)&&!0===utils_type.A.evaluate(b.x),P=!0===b||utils_type.A.isObject(b)&&!0===utils_type.A.evaluate(b.y),x=utils_type.A.evaluate(this.visProp.includeboundaries),E=utils_type.A.evaluate(this.visProp.forcesquare);if(this.dataX=[],this.dataY=[],c=utils_type.A.evaluate(this.visProp.majorstep),utils_type.A.isArray(c)||(c=[c,c]),c.length<2&&(c=[c[0],c[0]]),utils_type.A.exists(g)&&(jxg.A.deprecated("gridX","majorStep"),c[0]=g),utils_type.A.exists(m)&&(jxg.A.deprecated("gridY","majorStep"),c[1]=m),"auto"===c[0]?(f=Math.pow(10,Math.floor(Math.log(50/this.board.unitX)/Math.LN10)),c[0]=f,utils_type.A.exists(a[0])&&(c[0]=a[0].ticks[0].getDistanceMajorTicks())):c[0]=utils_type.A.parseNumber(c[0],Math.abs(A[1]-A[3]),1/this.board.unitX),"auto"===c[1]?(f=Math.pow(10,Math.floor(Math.log(50/this.board.unitY)/Math.LN10)),c[1]=f,utils_type.A.exists(a[1])&&(c[1]=a[1].ticks[0].getDistanceMajorTicks())):c[1]=utils_type.A.parseNumber(c[1],Math.abs(A[0]-A[2]),1/this.board.unitY),"min"===E||!0===E?c[0]*this.board.unitX<=c[1]*this.board.unitY?c[1]=c[0]/this.board.unitY*this.board.unitX:c[0]=c[1]/this.board.unitX*this.board.unitY:"max"===E&&(c[0]*this.board.unitX<=c[1]*this.board.unitY?c[0]=c[1]/this.board.unitX*this.board.unitY:c[1]=c[0]/this.board.unitY*this.board.unitX),p=utils_type.A.evaluate(this.visProp.size),utils_type.A.isArray(p)||(p=[p,p]),p.length<2&&(p=[p[0],p[0]]),utils_type.A.isNumber(p[0],!0)&&(p[0]=p[0]+"px"),utils_type.A.isNumber(p[1],!0)&&(p[1]=p[1]+"px"),p[0]=utils_type.A.parseNumber(p[0],c[0],1/this.board.unitX),p[1]=utils_type.A.parseNumber(p[1],c[1],1/this.board.unitY),_[0]=p[0]/2,_[1]=p[1]/2,t=math.A.roundToStep(A[0],c[0]),e=math.A.roundToStep(A[1],c[1]),u=isFinite(t)&&isFinite(e)&&isFinite(A[2])&&isFinite(A[3])&&Math.abs(A[2])<Math.abs(c[0]*r)&&Math.abs(A[3])<Math.abs(c[1]*r),"line"===y.toLowerCase()){for(l=utils_type.A.evaluate(o.visProp.margin),n=e;u&&n>=A[3];n-=c[1])!v&&Math.abs(n)<s||!P&&Math.abs(n)<s||!x&&(n<=A[3]+_[1]||n>=A[1]-_[1])||(h=[[A[0]-l/o.board.unitX,A[2]+l/o.board.unitX,NaN],[n,n,NaN]],utils_type.A.concat(this.dataX,h[0]),utils_type.A.concat(this.dataY,h[1]));for(i=t;u&&i<=A[2];i+=c[0])!v&&Math.abs(i)<s||!C&&Math.abs(i)<s||!x&&(i<=A[0]+_[0]||i>=A[2]-_[0])||(h=[[i,i,NaN],[A[1]+l/o.board.unitY,A[3]-l/o.board.unitY,NaN]],utils_type.A.concat(this.dataX,h[0]),utils_type.A.concat(this.dataY,h[1]))}else for(n=e;u&&n>=A[3];n-=c[1])for(i=t;u&&i<=A[2];i+=c[0])!v&&Math.abs(n)<s&&Math.abs(i)<s||!C&&Math.abs(n)<s&&Math.abs(i)>=s||!P&&Math.abs(i)<s&&Math.abs(n)>=s||!x&&(i<=A[0]+_[0]||i>=A[2]-_[0]||n<=A[3]+_[1]||n>=A[1]-_[1])||(h=d(y,o,i,n,_[0],_[1],A),utils_type.A.concat(this.dataX,h[0]),utils_type.A.concat(this.dataY,h[1]))},n.updateDataArray=function(){var t,e,i,o,l,h,u,p,f,A,g,m,y,b,v,C,P,x,E,O=this.board.getBoundingBox(),S=[],M=[],w=utils_type.A.evaluate(this.visProp.minorelements),T=utils_type.A.evaluate(this.visProp.size),N=utils_type.A.evaluate(this.visProp.face),j=utils_type.A.evaluate(this.visProp.drawzero),D=!0===j||utils_type.A.isObject(j)&&!0===utils_type.A.evaluate(j.x),k=!0===j||utils_type.A.isObject(j)&&!0===utils_type.A.evaluate(j.y),R=utils_type.A.evaluate(this.majorGrid.visProp.face),L=utils_type.A.evaluate(this.majorGrid.visProp.drawzero),B=!0===L||utils_type.A.isObject(L)&&!0===utils_type.A.evaluate(L.origin),I=!0===L||utils_type.A.isObject(L)&&!0===utils_type.A.evaluate(L.x),Y=!0===L||utils_type.A.isObject(L)&&!0===utils_type.A.evaluate(L.y),X=utils_type.A.evaluate(this.visProp.includeboundaries);if(this.dataX=[],this.dataY=[],utils_type.A.isArray(w)||(w=[w,w]),w.length<2&&(w=[w[0],w[0]]),utils_type.A.isNumber(w[0],!0)?w[0]=parseFloat(w[0]):(w[0]=3,utils_type.A.exists(a[0])&&(w[0]=utils_type.A.evaluate(a[0].getAttribute("ticks").minorticks))),S[0]=c[0]/(w[0]+1),utils_type.A.isNumber(w[1],!0)?w[1]=parseFloat(w[1]):(w[1]=3,utils_type.A.exists(a[1])&&(w[1]=utils_type.A.evaluate(a[1].getAttribute("ticks").minorticks))),S[1]=c[1]/(w[1]+1),utils_type.A.isArray(T)||(T=[T,T]),T.length<2&&(T=[T[0],T[0]]),utils_type.A.isNumber(T[0],!0)&&(T[0]=T[0]+"px"),utils_type.A.isNumber(T[1],!0)&&(T[1]=T[1]+"px"),T[0]=utils_type.A.parseNumber(T[0],S[0],1/this.board.unitX),T[1]=utils_type.A.parseNumber(T[1],S[1],1/this.board.unitY),M[0]=.5*T[0],M[1]=.5*T[1],t=math.A.roundToStep(O[0],S[0]),e=math.A.roundToStep(O[1],S[1]),u=isFinite(t)&&isFinite(e)&&isFinite(O[2])&&isFinite(O[3])&&Math.abs(O[2])<=Math.abs(S[0]*r)&&Math.abs(O[3])<Math.abs(S[1]*r),"line"!==N.toLowerCase())for(o=e;u&&o>=O[3];o-=S[1])for(i=t;u&&i<=O[2];i+=S[0]){if(p=math.A.roundToStep(Math.abs(i),c[0]),p=Math.abs(p-Math.abs(i)),f=c[0]-p,A=math.A.roundToStep(Math.abs(o),c[1]),A=Math.abs(A-Math.abs(o)),g=c[1]-A,"line"===R){if(p-M[0]-_[0]<s||f-M[0]-_[0]<s||A-M[1]-_[1]<s||g-M[1]-_[1]<s)continue}else if((p-M[0]-_[0]<s||f-M[0]-_[0]<s)&&(A-M[1]-_[1]<s||g-M[1]-_[1]<s)&&(B||_[1]-Math.abs(o)+M[1]<s||_[0]-Math.abs(i)+M[0]<s)&&(I||_[1]-Math.abs(o)+M[1]<s||_[0]+Math.abs(i)-M[0]<s)&&(Y||_[0]-Math.abs(i)+M[0]<s||_[1]+Math.abs(o)-M[1]<s))continue;!k&&Math.abs(i)<s||!D&&Math.abs(o)<s||(m=Math.abs(O[0]%c[0]),y=Math.abs(O[1]%c[1]),b=Math.abs(O[2]%c[0]),v=Math.abs(O[3]%c[1]),C=c[0]-m,P=c[1]-y,x=c[0]-b,E=c[1]-v,!X&&(i-M[0]-O[0]-_[0]+C<s&&C-_[0]<s||i-M[0]-O[0]-_[0]-m<s&&m-_[0]<s||-i-M[0]+O[2]-_[0]+x<s&&x-_[0]<s||-i-M[0]+O[2]-_[0]-b<s&&b-_[0]<s||-o-M[1]+O[1]-_[1]+P<s&&P-_[1]<s||-o-M[1]+O[1]-_[1]-y<s&&y-_[1]<s||o-M[1]-O[3]-_[1]+E<s&&E-_[1]<s||o-M[1]-O[3]-_[1]-v<s&&v-_[1]<s||-o-M[1]+O[1]<s||i-M[0]-O[0]<s||o-M[1]-O[3]<s||-i-M[0]+O[2]<s)||(h=d(N,n,i,o,M[0],M[1],O),utils_type.A.concat(this.dataX,h[0]),utils_type.A.concat(this.dataY,h[1])))}else{for(l=utils_type.A.evaluate(n.visProp.margin),o=e;u&&o>=O[3];o-=S[1]){if(A=math.A.roundToStep(Math.abs(o),c[1]),A=Math.abs(A-Math.abs(o)),g=c[1]-A,"line"===R){if(A-M[1]-_[1]<s||g-M[1]-_[1]<s)continue}else if((A-M[1]-_[1]<s||g-M[1]-_[1]<s)&&(B||_[1]-Math.abs(o)+M[1]<s)&&(I||_[1]-Math.abs(o)+M[1]<s)&&(Y||_[1]+Math.abs(o)-M[1]<s))continue;!D&&Math.abs(o)<s||(m=Math.abs(O[0]%c[0]),y=Math.abs(O[1]%c[1]),b=Math.abs(O[2]%c[0]),v=Math.abs(O[3]%c[1]),C=c[0]-m,P=c[1]-y,x=c[0]-b,E=c[1]-v,!X&&(-o-M[1]+O[1]-_[1]+P<s&&P-_[1]<s||-o-M[1]+O[1]-_[1]-y<s&&y-_[1]<s||o-M[1]-O[3]-_[1]+E<s&&E-_[1]<s||o-M[1]-O[3]-_[1]-v<s&&v-_[1]<s||-o-M[1]+O[1]<s||o-M[1]-O[3]<s)||(h=[[O[0]-l/n.board.unitX,O[2]+l/n.board.unitX,NaN],[o,o,NaN]],utils_type.A.concat(this.dataX,h[0]),utils_type.A.concat(this.dataY,h[1])))}for(i=t;u&&i<=O[2];i+=S[0]){if(p=math.A.roundToStep(Math.abs(i),c[0]),p=Math.abs(p-Math.abs(i)),f=c[0]-p,"line"===R){if(p-M[0]-_[0]<s||f-M[0]-_[0]<s)continue}else if((p-M[0]-_[0]<s||f-M[0]-_[0]<s)&&(B||_[0]-Math.abs(i)+M[0]<s)&&(I||_[0]+Math.abs(i)-M[0]<s)&&(Y||_[0]-Math.abs(i)+M[0]<s))continue;!k&&Math.abs(i)<s||(m=Math.abs(O[0]%c[0]),y=Math.abs(O[1]%c[1]),b=Math.abs(O[2]%c[0]),v=Math.abs(O[3]%c[1]),C=c[0]-m,P=c[1]-y,x=c[0]-b,E=c[1]-v,!X&&(i-M[0]-O[0]-_[0]+C<s&&C-_[0]<s||i-M[0]-O[0]-_[0]-m<s&&m-_[0]<s||-i-M[0]+O[2]-_[0]+x<s&&x-_[0]<s||-i-M[0]+O[2]-_[0]-b<s&&b-_[0]<s||i-M[0]-O[0]<s||-i-M[0]+O[2]<s)||(h=[[i,i,NaN],[O[1]+l/n.board.unitY,O[3]-l/n.board.unitY,NaN]],utils_type.A.concat(this.dataX,h[0]),utils_type.A.concat(this.dataY,h[1])))}}},t.grids.push(o),t.grids.push(n),o},jxg.A.registerElement("grid",jxg.A.createGrid),jxg.A.createLocus=function(t,e,i){var s,r;if(!utils_type.A.isArray(e)||1!==e.length||!utils_type.A.isPoint(e[0]))throw new Error("JSXGraph: Can't create locus with parent of type other than point.\nPossible parent types: [point]");return r=e[0],(s=t.create("curve",[[null],[null]],i)).dontCallServer=!1,s.elType="locus",s.setParents([r.id]),s.updateDataArray=function(){var e,i,o;s.board.mode>0||(e=symbolic.generatePolynomials(t,r,!0).join("|"))!==s.spe&&(s.spe=e,i=function(t,e,i,r){var o;s.dataX=t,s.dataY=e,s.eq=i,s.ctime=r,s.generatePolynomial=(o=i,function(t){var e,i="("+t.symbolic.x+")",s="("+t.symbolic.y+")",r=[];for(e=0;e<o.length;e++)r[e]=o[e].replace(/\*\*/g,"^").replace(/x/g,i).replace(/y/g,s);return r})},i((o=symbolic.geometricLocusByGroebnerBase(t,r,i)).datax,o.datay,o.polynomial,o.exectime))},s},jxg.A.registerElement("locus",jxg.A.createLocus);var base_text=__webpack_require__(925);jxg.A.Image=function(t,e,i,s,r){this.constructor(t,i,constants.A.OBJECT_TYPE_IMAGE,constants.A.OBJECT_CLASS_OTHER),this.element=this.board.select(i.anchor),this.coordsConstructor(e),this.W=utils_type.A.createFunction(r[0],this.board,""),this.H=utils_type.A.createFunction(r[1],this.board,""),this.addParentsFromJCFunctions([this.W,this.H]),this.usrSize=[this.W(),this.H()],this.size=[Math.abs(this.usrSize[0]*t.unitX),Math.abs(this.usrSize[1]*t.unitY)],this.url=s,this.elType="image",this.span=[this.coords.usrCoords.slice(0),[this.coords.usrCoords[0],this.W(),0],[this.coords.usrCoords[0],0,this.H()]],this.id=this.board.setId(this,"Im"),this.board.renderer.drawImage(this),this.board.finalizeAdding(this),this.methodMap=jxg.A.deepCopy(this.methodMap,{addTransformation:"addTransform",trans:"addTransform",W:"W",Width:"W",H:"H",Height:"H",setSize:"setSize"})},jxg.A.Image.prototype=new base_element.A,utils_type.A.copyPrototypeMethods(jxg.A.Image,coordselement.A,"coordsConstructor"),jxg.A.extend(jxg.A.Image.prototype,{hasPoint:function(t,e){var i,s,r,o,n,a,l,h,u,c=this.transformations.length;return utils_type.A.isObject(utils_type.A.evaluate(this.visProp.precision))?(o=this.board._inputDevice,n=utils_type.A.evaluate(this.visProp.precision[o])):n=this.board.options.precision.hasPoint,0===c?(i=t-this.coords.scrCoords[1],s=this.coords.scrCoords[2]-e,i>=-(r=n)&&i-this.size[0]<=r&&s>=-r&&s-this.size[1]<=r):(l=[(a=(a=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board)).usrCoords)[0]-this.span[0][0],a[1]-this.span[0][1],a[2]-this.span[0][2]],0<=(h=(u=math.A.innerProduct)(l,this.span[1]))&&h<=u(this.span[1],this.span[1])&&0<=(h=u(l,this.span[2]))&&h<=u(this.span[2],this.span[2]))},update:function(t){return this.needsUpdate?(this.updateCoords(t),this.updateSize(),this.updateSpan(),this):this},updateRenderer:function(){return this.updateRendererGeneric("updateImage")},updateSize:function(){return this.usrSize=[this.W(),this.H()],this.size=[Math.abs(this.usrSize[0]*this.board.unitX),Math.abs(this.usrSize[1]*this.board.unitY)],this},updateSpan:function(){var t,e,i=this.transformations.length,s=[];if(0===i)this.span=[[this.Z(),this.X(),this.Y()],[this.Z(),this.W(),0],[this.Z(),0,this.H()]];else{for(s[0]=[this.Z(),this.X(),this.Y()],s[1]=[this.Z(),this.X()+this.W(),this.Y()],s[2]=[this.Z(),this.X(),this.Y()+this.H()],t=0;t<i;t++)for(e=0;e<3;e++)s[e]=math.A.matVecMult(this.transformations[t].matrix,s[e]);for(e=0;e<3;e++)s[e][1]/=s[e][0],s[e][2]/=s[e][0],s[e][0]/=s[e][0];for(e=1;e<3;e++)s[e][0]-=s[0][0],s[e][1]-=s[0][1],s[e][2]-=s[0][2];this.span=s}return this},addTransform:function(t){var e;if(utils_type.A.isArray(t))for(e=0;e<t.length;e++)this.transformations.push(t[e]);else this.transformations.push(t);return this},getParents:function(){var t=[this.url,[this.Z(),this.X(),this.Y()],this.usrSize];return 0!==this.parents.length&&(t=this.parents),t},setSize:function(t,e){return this.W=utils_type.A.createFunction(t,this.board,""),this.H=utils_type.A.createFunction(e,this.board,""),this.addParentsFromJCFunctions([this.W,this.H]),this},W:function(){},H:function(){}}),jxg.A.createImage=function(t,e,i){var s,r,o=e[0],n=e[1],a=e[2];if(s=utils_type.A.copyAttributes(i,t.options,"image"),!(r=coordselement.A.create(jxg.A.Image,t,n,s,o,a)))throw new Error("JSXGraph: Can't create image with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [x,y], [z,x,y], [element,transformation]");return 0!==s.rotate&&r.addRotation(s.rotate),r},jxg.A.registerElement("image",jxg.A.createImage);var base_image=jxg.A.Image;jxg.A.createSlider=function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_,f,A,g,m,y,b,v,C,P,x,E;return y=(E=utils_type.A.copyAttributes(i,t.options,"slider")).withticks,m=E.withlabel,C=E.snapwidth,b=E.snapvalues,v=E.snapvaluedistance,h=t.create("point",e[0],E.point1),u=t.create("point",e[1],E.point2),(d=t.create("segment",[h,u],E.baseline)).updateStdform(),s=h.coords.usrCoords.slice(1),r=u.coords.usrCoords.slice(1),o=e[2][0],n=e[2][1],a=e[2][2],l=a-o,x=-1===(P=utils_type.A.evaluate(C))?n:Math.round(n/P)*P,A=s[0]+(r[0]-s[0])*(x-o)/(a-o),g=s[1]+(r[1]-s[1])*(x-o)/(a-o),E.withlabel=!1,(c=t.create("glider",[A,g,d],E)).setAttribute({snapwidth:C,snapvalues:b,snapvaluedistance:v}),p=t.create("segment",[h,c],E.highline),c.Value=function(){var t=this._smax-this._smin,e=utils_type.A.evaluate(this.visProp.snapwidth);return-1===e?this.position*t+this._smin:Math.round((this.position*t+this._smin)/e)*e},c.methodMap=utils_type.A.deepCopy(c.methodMap,{Value:"Value",setValue:"setValue",smax:"_smax",smin:"_smin",setMax:"setMax",setMin:"setMin",point1:"point1",point2:"point2",baseline:"baseline",highline:"highline",ticks:"ticks",label:"label"}),c._smax=a,c._smin=o,c.setMax=function(t){return this._smax=t,this},c.setValue=function(t){var e=this._smax-this._smin;return Math.abs(e)>math.A.eps?this.position=(t-this._smin)/e:this.position=0,this.position=Math.max(0,Math.min(1,this.position)),this},c.setMin=function(t){return this._smin=t,this},m&&(f=t.create("text",[function(){return.05*(u.X()-h.X())+u.X()},function(){return.05*(u.Y()-h.Y())+u.Y()},function(){var t,e=utils_type.A.evaluate(c.visProp.digits),i=utils_type.A.evaluate(c.visProp.suffixlabel),s=utils_type.A.evaluate(c.visProp.unitlabel),r=utils_type.A.evaluate(c.visProp.postlabel);return 2===e&&2!==utils_type.A.evaluate(c.visProp.precision)&&(e=utils_type.A.evaluate(c.visProp.precision)),t=null!==i?i:c.name&&""!==c.name?c.name+" = ":"",c.useLocale()?t+=c.formatNumberLocale(c.Value(),e):t+=utils_type.A.toFixed(c.Value(),e),null!==s&&(t+=s),null!==r&&(t+=r),t}],E.label),c.label=f,c.visProp.withlabel=!0,c.hasLabel=!0),c.point1=h,c.point2=u,c.baseline=d,c.highline=p,y&&(utils_type.A.exists(E.generatelabeltext)||(E.ticks.generateLabelText=function(t,e,i){var s=c.point1.Dist(c.point2),r=c._smin,o=c._smax,n=this.getDistanceFromZero(e,t)*(o-r)/s+r;return s<math.A.eps||Math.abs(n)<math.A.eps?"0":this.formatLabelText(n)}),_=t.create("ticks",[c.baseline,c.point1.Dist(h)/2,function(t){var e=c.point1.Dist(c.point2),i=c.point1.coords.distance(constants.A.COORDS_BY_USER,t);return e<math.A.eps?0:i/e*l+o}],E.ticks),c.ticks=_),c.remove=function(){m&&t.removeObject(f),t.removeObject(p),t.removeObject(d),t.removeObject(u),t.removeObject(h),point.prototype.remove.call(c)},h.dump=!1,u.dump=!1,d.dump=!1,p.dump=!1,m&&(f.dump=!1),c.elType="slider",c.parents=e,c.subs={point1:h,point2:u,baseLine:d,highLine:p},c.inherits.push(h,u,d,p),y&&(_.dump=!1,c.subs.ticks=_,c.inherits.push(_)),c.getParents=function(){return[this.point1.coords.usrCoords.slice(1),this.point2.coords.usrCoords.slice(1),[this._smin,this.position*(this._smax-this._smin)+this._smin,this._smax]]},c.baseline.on("up",(function(t){var e,i;utils_type.A.evaluate(c.visProp.moveonup)&&!utils_type.A.evaluate(c.visProp.fixed)&&(e=d.board.getMousePosition(t,0),i=new base_coords.A(constants.A.COORDS_BY_SCREEN,e,this.board),c.moveTo([i.usrCoords[1],i.usrCoords[2]]),c.triggerEventHandlers(["drag"],[t]))})),c.prepareUpdate().update(),t.isSuspendedUpdate||(c.updateVisibility().updateRenderer(),c.baseline.updateVisibility().updateRenderer(),c.highline.updateVisibility().updateRenderer(),y&&c.ticks.updateVisibility().updateRenderer()),c},jxg.A.registerElement("slider",jxg.A.createSlider),jxg.A.PrefixParser={parse:function(t,e){var i,s,r,o,n,a;if(utils_type.A.isNumber(t)||utils_type.A.isString(t))return t;if(!utils_type.A.isArray(t)||t.length<2)throw new Error("prefixParser.parse: term is not an array, number or string");if(i=t[0],r=t.length,"execute"===e)if(utils_type.A.isInArray(["+","-","*","/"],i))for(o=this.parse(t[1],e),s=2;s<r;s++)switch(a=this.parse(t[s],e),i){case"+":o+=a;break;case"-":o-=a;break;case"*":o*=a;break;case"/":o/=a}else if("exec"===i){for(n=t[1],a=[],s=2;s<r;s++)a.push(this.parse(t[s],e));if(utils_type.A.exists(Math[n]))o=Math[n].apply(this,a);else{if(!utils_type.A.exists(math.A[n]))throw new Error("PrefixParser.parse: "+n+" is not allowed");o=math.A[n].apply(this,a)}}else{if("V"===(n=t[0])&&(n="Value"),!utils_type.A.exists(t[1][n]))throw new Error("PrefixParser.parse: "+n+" is not a method of "+t[1]);for(a=[],s=2;s<r;s++)a.push(this.parse(t[s],e));o=t[1][n].apply(t[1],a)}return o},dimension:function(t){var e,i,s,r,o,n,a,l;if(utils_type.A.isNumber(t))return 0;if(!utils_type.A.isArray(t)||t.length<2)throw new Error("PrefixParser.dimension: term is not an array");if(e=t[0],s=t.length,utils_type.A.isInArray(["+","-","*","/"],e))for(r=this.dimension(t[1]),i=2;i<s;i++)switch(a=this.dimension(t[i]),e){case"+":case"-":a!==r&&(r=NaN);break;case"*":r+=a;break;case"/":r-=a}else if("exec"===e)t[2].type===utils_type.A.OBJECT_TYPE_MEASUREMENT?(r=t[2].Dimension(),utils_type.A.exists(t[2].visProp.dim)&&null!==(n=utils_type.A.evaluate(t[2].visProp.dim))&&(r=n)):r=0;else switch(o=t[0]){case"L":case"Length":case"Perimeter":case"Radius":case"R":r=1;break;case"Area":case"A":r=2;break;default:t[1].type===utils_type.A.OBJECT_TYPE_MEASUREMENT?(r=t[1].Dimension(),utils_type.A.exists(t[1].visProp.dim)&&null!==(n=utils_type.A.evaluate(t[1].visProp.dim))&&(r=n)):(r=0,"Value"!==o&&"V"!==o||[constants.A.OBJECT_TYPE_ARC,constants.A.OBJECT_TYPE_SECTOR,constants.A.OBJECT_TYPE_ANGLE].indexOf(t[1].type)>=0&&(l="",3===t.length&&utils_type.A.isString(t[2])&&(l=t[2].toLowerCase()),r=""===l?t[1].type===constants.A.OBJECT_TYPE_ANGLE?0:1:0===l.indexOf("len")?1:0))}return r},toPrefix:function(t){var e,i,s,r;if(utils_type.A.isNumber(t))return t;if(!utils_type.A.isArray(t)||t.length<2)throw new Error("PrefixParser.toPrefix: term is not an array");for(e=t[0],s=t.length,r=[e],i=1;i<s;i++)utils_type.A.isInArray(["+","-","*","/"],e)?r.push(this.toPrefix(t[i])):"V"===e&&t[i].type===utils_type.A.OBJECT_TYPE_MEASUREMENT?r=t[i].toPrefix():"exec"===e?1===i?r.push(t[i]):r.push(this.toPrefix(t[i])):r=[e,t[i].id];return r},getParents:function(t){var e,i,s,r;if(utils_type.A.isNumber(t))return[];if(!utils_type.A.isArray(t)||t.length<2)throw new Error("PrefixParser.getParents: term is not an array");for(e=t[0],s=t.length,r=[],i=1;i<s;i++)utils_type.A.isInArray(["+","-","*","/"],e)?utils_type.A.concat(r,this.getParents(t[i])):"V"===e&&t[i].type===utils_type.A.OBJECT_TYPE_MEASUREMENT?utils_type.A.concat(r,t[i].getParents()):"exec"===e?i>1&&utils_type.A.concat(r,this.getParents(t[i])):r.push(t[i]);return r}};var prefix=jxg.A.PrefixParser;jxg.A.createTapemeasure=function(t,e,i){var s,r,o,n,a,l,h,u,c,d;return s=e[0],r=e[1],o=utils_type.A.copyAttributes(i,t.options,"tapemeasure","point1"),h=t.create("point",s,o),o=utils_type.A.copyAttributes(i,t.options,"tapemeasure","point2"),u=t.create("point",r,o),h.setAttribute({ignoredSnapToPoints:[u.id]}),u.setAttribute({ignoredSnapToPoints:[h.id]}),o=utils_type.A.copyAttributes(i,t.options,"tapemeasure"),n=o.withticks,a=o.withlabel,2===o.digits&&2!==o.precision&&o.precision,a&&(o.withlabel=!0),l=t.create("segment",[h,u],o),a&&(c=i.name&&""!==i.name?i.name+" = ":"",l.label.setText((function(){var t=utils_type.A.evaluate(l.label.visProp.digits);return l.label.useLocale()?c+l.label.formatNumberLocale(h.Dist(u),t):c+utils_type.A.toFixed(h.Dist(u),t)}))),n&&(o=utils_type.A.copyAttributes(i,t.options,"tapemeasure","ticks"),d=t.create("ticks",[l,.1],o),l.inherits.push(d)),l.remove=function(){n&&l.removeTicks(d),t.removeObject(u),t.removeObject(h),base_element.A.prototype.remove.call(this)},l.Value=function(){return h.Dist(u)},h.dump=!1,u.dump=!1,l.elType="tapemeasure",l.getParents=function(){return[[h.X(),h.Y()],[u.X(),u.Y()]]},l.subs={point1:h,point2:u},n&&(d.dump=!1),l.methodMap=jxg.A.deepCopy(l.methodMap,{Value:"Value"}),l.prepareUpdate().update(),t.isSuspendedUpdate||(l.updateVisibility().updateRenderer(),l.point1.updateVisibility().updateRenderer(),l.point2.updateVisibility().updateRenderer()),l},jxg.A.registerElement("tapemeasure",jxg.A.createTapemeasure),jxg.A.createMeasurement=function(t,e,i){var s,r,o,n,a,l;for(r=utils_type.A.copyAttributes(i,t.options,"measurement"),o=e[0],n=e[1],a=e[2],(s=t.create("text",[o,n,""],r)).type=utils_type.A.OBJECT_TYPE_MEASUREMENT,s.elType="measurement",s.Value=function(){return prefix.parse(a,"execute")},s.Dimension=function(){var t=utils_type.A.evaluate(s.visProp.dim);return null!==t?t:prefix.dimension(a)},s.Unit=function(){var t="",e=utils_type.A.evaluate(s.visProp.units),i=s.Dimension();return utils_type.A.isObject(e)&&utils_type.A.exists(e[i])&&!1!==e[i]?t=utils_type.A.evaluate(e[i]):utils_type.A.isObject(e)&&utils_type.A.exists(e["dim"+i])&&!1!==e["dim"+i]?t=utils_type.A.evaluate(e["dim"+i]):(t=utils_type.A.evaluate(s.visProp.baseunit),0===i?t="":i>1&&""!==t&&(t=t+"^{"+i+"}")),t},s.getTerm=function(){return a},s.getMethod=function(){var t=a[0];return"V"===t&&(t="Value"),t},s.toPrefix=function(){return prefix.toPrefix(a)},s.getParents=function(){return prefix.getParents(a)},s.addParents(s.getParents()),l=0;l<s.parents.length;l++)t.select(s.parents[l]).addChild(s);return s.setText((function(){var t,e="",i="",r=s.Dimension(),o=utils_type.A.evaluate(s.visProp.digits),n=s.Unit(),a=s.Value();if(utils_type.A.evaluate(s.visProp.showprefix)&&(e=s.visProp.formatprefix.apply(s,[utils_type.A.evaluate(s.visProp.prefix)])),utils_type.A.evaluate(s.visProp.showsuffix)&&(i=s.visProp.formatsuffix.apply(s,[utils_type.A.evaluate(s.visProp.suffix)])),utils_type.A.isNumber(a))"none"===o||(a="auto"===o?s.useLocale()?s.formatNumberLocale(a):utils_type.A.autoDigits(a):s.useLocale()?s.formatNumberLocale(a,o):utils_type.A.toFixed(a,o));else if(utils_type.A.isArray(a))for(t=0;t<a.length;t++)utils_type.A.isNumber(a[t])&&("none"===o||("auto"===o?s.useLocale()?a[t]=s.formatNumberLocale(a[t]):a[t]=utils_type.A.autoDigits(a[t]):s.useLocale()?a[t]=s.formatNumberLocale(a[t],o):a[t]=utils_type.A.toFixed(a[t],o)));return"coords"===r&&utils_type.A.isArray(a)&&(2===a.length&&a.unshift(void 0),a=s.visProp.formatcoords.apply(s,[a[1],a[2],a[0]])),"direction"===r&&utils_type.A.isArray(a)&&(2===a.length&&a.unshift(void 0),a=s.visProp.formatdirection.apply(s,[a[1],a[2]])),utils_type.A.isString(r)?e+a+i:isNaN(r)?e+"NaN"+i:e+a+n+i})),s.methodMap=utils_type.A.deepCopy(s.methodMap,{Value:"Value",Dimension:"Dimension",Unit:"Unit",getTerm:"getTerm",Term:"getTerm",getMethod:"getMethod",Method:"getMethod",getParents:"getParents",Parents:"getParents"}),s},jxg.A.registerElement("measurement",jxg.A.createMeasurement),jxg.A.DataSource=function(){return this.data=[],this.columnHeaders=[],this.rowHeaders=[],this},jxg.A.extend(jxg.A.DataSource.prototype,{loadFromArray:function(t,e,i){var s,r,o;if(utils_type.A.isArray(e)&&(this.columnHeaders=e,e=!1),utils_type.A.isArray(i)&&(this.rowHeaders=i,i=!1),this.data=[],e&&(this.columnHeaders=[]),i&&(this.rowHeaders=[]),utils_type.A.exists(t)){for(this.data=[],s=0;s<t.length;s++)for(this.data[s]=[],r=0;r<t[s].length;r++)o=t[s][r],parseFloat(o).toString()===o?this.data[s][r]=parseFloat(o):this.data[s][r]="-"!==o?o:NaN;if(e&&(this.columnHeaders=this.data[0].slice(1),this.data=this.data.slice(1)),i)for(this.rowHeaders=[],s=0;s<this.data.length;s++)this.rowHeaders.push(this.data[s][0]),this.data[s]=this.data[s].slice(1)}return this},loadFromTable:function(t,e,i){var s,r,o,n,a;if(utils_type.A.isArray(e)&&(this.columnHeaders=e,e=!1),utils_type.A.isArray(i)&&(this.rowHeaders=i,i=!1),this.data=[],e&&(this.columnHeaders=[]),i&&(this.rowHeaders=[]),t=document.getElementById(t),utils_type.A.exists(t)){for(s=t.getElementsByTagName("tr"),this.data=[],r=0;r<s.length;r++)for(n=s[r].getElementsByTagName("td"),this.data[r]=[],o=0;o<n.length;o++)a=n[o].innerHTML,parseFloat(a).toString()===a?this.data[r][o]=parseFloat(a):this.data[r][o]="-"!==a?a:NaN;if(e&&(this.columnHeaders=this.data[0].slice(1),this.data=this.data.slice(1)),i)for(this.rowHeaders=[],r=0;r<this.data.length;r++)this.rowHeaders.push(this.data[r][0]),this.data[r]=this.data[r].slice(1)}return this},addColumn:function(t,e,i){throw new Error("not implemented")},addRow:function(t,e,i){throw new Error("not implemented")},getColumn:function(t){var e,i=[];if(utils_type.A.isString(t))for(e=0;e<this.columnHeaders.length;e++)if(t===this.columnHeaders[e]){t=e;break}for(e=0;e<this.data.length;e++)this.data[e].length>t&&(i[e]=parseFloat(this.data[e][t]));return i},getRow:function(t){var e,i;if(utils_type.A.isString(t))for(i=0;i<this.rowHeaders.length;i++)if(t===this.rowHeaders[i]){t=i;break}for(e=[],i=0;i<this.data[t].length;i++)e[i]=this.data[t][i];return e}});var datasource=jxg.A.DataSource;jxg.A.Chart=function(t,e,i){var s,r,o,n,a,l;if(this.constructor(t,i),!utils_type.A.isArray(e)||0===e.length)throw new Error("JSXGraph: Can't create a chart without data");if(this.elements=[],utils_type.A.isNumber(e[0]))for(r=e,s=[],o=0;o<r.length;o++)s[o]=o+1;else if(1===e.length&&utils_type.A.isArray(e[0]))for(r=e[0],s=[],l=utils_type.A.evaluate(r).length,o=0;o<l;o++)s[o]=o+1;else 2===e.length&&(l=Math.min(e[0].length,e[1].length),s=e[0].slice(0,l),r=e[1].slice(0,l));if(utils_type.A.isArray(r)&&0===r.length)throw new Error("JSXGraph: Can't create charts without data.");for(a=i.chartstyle.replace(/ /g,"").split(","),o=0;o<a.length;o++){switch(a[o]){case"bar":n=this.drawBar(t,s,r,i);break;case"line":n=this.drawLine(t,s,r,i);break;case"fit":n=this.drawFit(t,s,r,i);break;case"spline":n=this.drawSpline(t,s,r,i);break;case"pie":n=this.drawPie(t,r,i);break;case"point":n=this.drawPoints(t,s,r,i);break;case"radar":n=this.drawRadar(t,e,i)}this.elements.push(n)}return this.id=this.board.setId(this,"Chart"),this.elements},jxg.A.Chart.prototype=new base_element.A,jxg.A.extend(jxg.A.Chart.prototype,{drawLine:function(t,e,i,s){return s.fillcolor="none",s.highlightfillcolor="none",t.create("curve",[e,i],s)},drawSpline:function(t,e,i,s){return s.fillColor="none",s.highlightfillcolor="none",t.create("spline",[e,i],s)},drawFit:function(t,e,i,s){var r=s.degree;return r=Math.max(parseInt(r,10),1)||1,s.fillcolor="none",s.highlightfillcolor="none",t.create("functiongraph",[numerics.A.regressionPolynomial(r,e,i)],s)},drawBar:function(t,e,i,s){var r,o,n,a,l,h,u,c,d,p,_=[],f=[],A=function(t,i){return function(){return e[t]()-i*n}},g={fixed:!0,withLabel:!1,visible:!1,name:""};if((d=utils_type.A.copyAttributes(s,t.options,"chart"))&&d.width)n=d.width;else{if(e.length<=1)n=1;else for(n=e[1]-e[0],r=1;r<e.length-1;r++)n=e[r+1]-e[r]<n?e[r+1]-e[r]:n;n*=.8}for(p=utils_type.A.copyAttributes(s,t.options,"chart","label"),r=0;r<e.length;r++)utils_type.A.isFunction(e[r])?(a=A(r,-.5),l=A(r,0),h=A(r,.5)):(a=e[r]-.5*n,l=e[r],h=e[r]+.5*n),u=utils_type.A.isFunction(i[r])?i[r]():i[r],u=i[r],"horizontal"===d.dir?(f[0]=t.create("point",[0,a],g),f[1]=t.create("point",[u,a],g),f[2]=t.create("point",[u,h],g),f[3]=t.create("point",[0,h],g),utils_type.A.exists(d.labels)&&utils_type.A.exists(d.labels[r])&&(p.anchorY="middle",(o=t.create("text",[u,l,d.labels[r]],p)).visProp.anchorx=function(t){return function(){return t.X()>=0?"left":"right"}}(o))):(f[0]=t.create("point",[a,0],g),f[1]=t.create("point",[a,u],g),f[2]=t.create("point",[h,u],g),f[3]=t.create("point",[h,0],g),utils_type.A.exists(d.labels)&&utils_type.A.exists(d.labels[r])&&(p.anchorX="middle",(o=t.create("text",[l,u,d.labels[r]],p)).visProp.anchory=function(t){return function(){return t.Y()>=0?"bottom":"top"}}(o))),utils_type.A.isArray(d.colors)&&(c=d.colors,d.fillcolor=c[r%c.length]),_[r]=t.create("polygon",f,d),utils_type.A.exists(d.labels)&&utils_type.A.exists(d.labels[r])&&(_[r].text=o);return _},drawPoints:function(t,e,i,s){var r,o=[],n=s.infoboxarray;for(s.fixed=!0,s.name="",r=0;r<e.length;r++)s.infoboxtext=!!n&&n[r%n.length],o[r]=t.create("point",[e[r],i[r]],s);return o},drawPie:function(t,e,i){var s,r,o=[],n=[],a=i.colors,l=i.highlightcolors,h=i.labels,u=i.radius||4,c=u,d=i.center||[0,0],p=d[0],_=d[1],f=function(t,i,s){return function(){var r,o,n,a=0;for(o=0;o<=t;o++)a+=parseFloat(utils_type.A.evaluate(e[o]));for(r=a,o=t+1;o<e.length;o++)r+=parseFloat(utils_type.A.evaluate(e[o]));return n=0!==r?2*Math.PI*a/r:0,c()*Math[i](n)+s}},A=function(t,e){var i=-this.point1.coords.usrCoords[1]+this.point2.coords.usrCoords[1],s=-this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[2];utils_type.A.exists(this.label)&&(this.label.rendNode.style.fontSize=e*utils_type.A.evaluate(this.label.visProp.fontsize)+"px",this.label.fullUpdate()),this.point2.coords=new base_coords.A(constants.A.COORDS_BY_USER,[this.point1.coords.usrCoords[1]+i*t,this.point1.coords.usrCoords[2]+s*t],this.board),this.fullUpdate()},g=function(){this.highlighted||(this.highlighted=!0,this.board.highlightedObjects[this.id]=this,this.board.renderer.highlight(this),A.call(this,1.1,2))},m=function(){this.highlighted&&(this.highlighted=!1,this.board.renderer.noHighlight(this),A.call(this,.9090909,1))},y={fixed:!0,withLabel:!1,visible:!1,name:""};if(!utils_type.A.isArray(h))for(h=[],s=0;s<e.length;s++)h[s]="";for(utils_type.A.isFunction(u)||(c=function(){return u}),i.highlightonsector=i.highlightonsector||!1,i.straightfirst=!1,i.straightlast=!1,r=t.create("point",[p,_],y),o[0]=t.create("point",[function(){return c()+p},function(){return _}],y),s=0;s<e.length;s++)o[s+1]=t.create("point",[f(s,"cos",p),f(s,"sin",_)],y),i.name=h[s],i.withlabel=""!==i.name,i.fillcolor=a&&a[s%a.length],i.labelcolor=a&&a[s%a.length],i.highlightfillcolor=l&&l[s%l.length],n[s]=t.create("sector",[r,o[s],o[s+1]],i),i.highlightonsector&&(n[s].hasPoint=n[s].hasPointSector),i.highlightbysize&&(n[s].highlight=g,n[s].noHighlight=m);return{sectors:n,points:o,midpoint:r}},drawRadar:function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_,f,A,g,m,y,b,v,C,P,x,E,O,S,M,w,T,N,j,D,k,R,L,B,I,Y,X,U,F,z,J,G=e.length,W=function(){var t,e,i,s,r=utils_type.A.evaluate(this.visProp.label.offset).slice(0);return t=this.point1.X(),e=this.point2.X(),i=this.point1.Y(),s=this.point2.Y(),e<t&&(r[0]=-r[0]),s<i&&(r[1]=-r[1]),this.setLabelRelativeCoords(r),new base_coords.A(constants.A.COORDS_BY_USER,[this.point2.X(),this.point2.Y()],this.board)},H=function(e,i){var s,r,o;return s=t.create("transform",[-(g[i]-f[i]),0],{type:"translate"}),r=t.create("transform",[v/(m[i]+A[i]-(g[i]-f[i])),1],{type:"scale"}),s.melt(r),o=t.create("transform",[e],{type:"rotate"}),s.melt(o),s};if(G<=0)throw new Error("JSXGraph radar chart: no data");if(o=i.paramarray,!utils_type.A.exists(o))throw new Error("JSXGraph radar chart: need paramArray attribute");if((n=o.length)<=1)throw new Error("JSXGraph radar chart: need more than one param in paramArray");for(s=0;s<G;s++)if(n!==e[s].length)throw new Error("JSXGraph radar chart: use data length equal to number of params ("+e[s].length+" != "+n+")");for(a=[],l=[],r=0;r<n;r++)a[r]=e[0][r],l[r]=a[r];for(s=1;s<G;s++)for(r=0;r<n;r++)e[s][r]>a[r]&&(a[r]=e[s][r]),e[s][r]<l[r]&&(l[r]=e[s][r]);for(h=[],u=[],s=0;s<G;s++)h[s]="",u[s]=[];for(c=[],d=[],p=i.startshiftratio||0,_=i.endshiftratio||0,s=0;s<n;s++)c[s]=(a[s]-l[s])*p,d[s]=(a[s]-l[s])*_;if(f=i.startshiftarray||c,A=i.endshiftarray||d,g=i.startarray||l,utils_type.A.exists(i.start))for(s=0;s<n;s++)g[s]=i.start;if(m=i.endarray||a,utils_type.A.exists(i.end))for(s=0;s<n;s++)m[s]=i.end;if(f.length!==n)throw new Error("JSXGraph radar chart: start shifts length is not equal to number of parameters");if(A.length!==n)throw new Error("JSXGraph radar chart: end shifts length is not equal to number of parameters");if(g.length!==n)throw new Error("JSXGraph radar chart: starts length is not equal to number of parameters");if(m.length!==n)throw new Error("JSXGraph radar chart: snds length is not equal to number of parameters");for(y=i.labelarray||h,b=i.colors,v=i.radius||10,z=i.strokewidth||1,utils_type.A.exists(i.highlightonsector)||(i.highlightonsector=!1),C={name:i.name,id:i.id,strokewidth:z,polystrokewidth:i.polystrokewidth||z,strokecolor:i.strokecolor||"black",straightfirst:!1,straightlast:!1,fillcolor:i.fillColor||"#FFFF88",fillopacity:i.fillOpacity||.4,highlightfillcolor:i.highlightFillColor||"#FF7400",highlightstrokecolor:i.highlightStrokeColor||"black",gradient:i.gradient||"none"},x=(P=i.center||[0,0])[0],E=P[1],O=t.create("point",[x,E],{name:"",fixed:!0,withlabel:!1,visible:!1}),Math.PI/2-Math.PI/n,M=S=i.startangle||0,w=[],T=[],s=0;s<n;s++)for(M+=2*Math.PI/n,j=v*Math.cos(M)+x,D=v*Math.sin(M)+E,w[s]=t.create("point",[j,D],{name:"",fixed:!0,withlabel:!1,visible:!1}),T[s]=t.create("line",[O,w[s]],{name:o[s],strokeColor:C.strokecolor,strokeWidth:C.strokewidth,strokeOpacity:1,straightFirst:!1,straightLast:!1,withLabel:!0,highlightStrokeColor:C.highlightstrokecolor}),T[s].getLabelAnchor=W,N=H(M,s),r=0;r<e.length;r++)J=e[r][s],u[r][s]=t.create("point",[J,0],{name:"",fixed:!0,withlabel:!1,visible:!1}),u[r][s].addTransform(u[r][s],N);for(k=[],s=0;s<G;s++)for(C.labelcolor=b&&b[s%b.length],C.strokecolor=b&&b[s%b.length],C.fillcolor=b&&b[s%b.length],k[s]=t.create("polygon",u[s],{withLines:!0,withLabel:!1,fillColor:C.fillcolor,fillOpacity:C.fillopacity,highlightFillColor:C.highlightfillcolor}),r=0;r<n;r++)k[s].borders[r].setAttribute("strokecolor:"+b[s%b.length]),k[s].borders[r].setAttribute("strokewidth:"+C.polystrokewidth);switch(i.legendposition||"none"){case"right":L=i.legendleftoffset||2,B=i.legendtopoffset||1,this.legend=t.create("legend",[x+v+L,E+v-B],{labels:y,colors:b});break;case"none":break;default:jxg.A.debug("Unknown legend position")}if(R=[],i.showcircles){for(I=[],s=0;s<6;s++)I[s]=20*s;if(I[0]="0",(X=(Y=i.circlelabelarray||I).length)<2)throw new Error("JSXGraph radar chart: too less circles in circleLabelArray");for(U=[],N=H(S+Math.PI/n,0),C.fillcolor="none",C.highlightfillcolor="none",C.strokecolor=i.strokecolor||"black",C.strokewidth=i.circlestrokewidth||.5,C.layer=0,F=(m[0]-g[0])/(X-1),s=0;s<X;s++)U[s]=t.create("point",[g[0]+s*F,0],{name:Y[s],size:0,fixed:!0,withLabel:!0,visible:!0}),U[s].addTransform(U[s],N),R[s]=t.create("circle",[O,U[s]],C)}return this.rendNode=k[0].rendNode,{circles:R,lines:T,points:u,midpoint:O,polygons:k}},updateRenderer:function(){return this},update:function(){return this.needsUpdate&&this.updateDataArray(),this},updateDataArray:function(){return this}}),jxg.A.createChart=function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_,f,A,g,m,y=[],b=env.A.isBrowser?t.document.getElementById(e[0]):null;if(1===e.length&&utils_type.A.isString(e[0])){if(utils_type.A.exists(b)){if(c=utils_type.A.copyAttributes(i,t.options,"chart"),s=(b=(new datasource).loadFromTable(e[0],c.withheaders,c.withheaders)).data,a=b.columnHeaders,r=b.rowHeaders,d=c.width,p=c.name,_=c.strokecolor,f=c.fillcolor,A=c.highlightstrokecolor,g=c.highlightfillcolor,t.suspendUpdate(),m=s.length,u=[],c.rows&&utils_type.A.isArray(c.rows)){for(o=0;o<m;o++)for(n=0;n<c.rows.length;n++)if(c.rows[n]===o||c.withheaders&&c.rows[n]===r[o]){u.push(s[o]);break}}else u=s;for(m=u.length,o=0;o<m;o++){if(h=[],c.chartstyle&&-1!==c.chartstyle.indexOf("bar")){for(l=d||.8,h.push(1-l/2+(o+.5)*l/m),n=1;n<u[o].length;n++)h.push(h[n-1]+1);c.width=l/m}p&&p.length===m?c.name=p[o]:c.withheaders&&(c.name=a[o]),_&&_.length===m?c.strokecolor=_[o]:c.strokecolor=utils_color.A.hsv2rgb((o+1)/m*360,.9,.6),f&&f.length===m?c.fillcolor=f[o]:c.fillcolor=utils_color.A.hsv2rgb((o+1)/m*360,.9,1),A&&A.length===m?c.highlightstrokecolor=A[o]:c.highlightstrokecolor=utils_color.A.hsv2rgb((o+1)/m*360,.9,1),g&&g.length===m?c.highlightfillcolor=g[o]:c.highlightfillcolor=utils_color.A.hsv2rgb((o+1)/m*360,.9,.6),c.chartstyle&&-1!==c.chartstyle.indexOf("bar")?y.push(new jxg.A.Chart(t,[h,u[o]],c)):y.push(new jxg.A.Chart(t,[u[o]],c))}t.unsuspendUpdate()}return y}return c=utils_type.A.copyAttributes(i,t.options,"chart"),new jxg.A.Chart(t,e,c)},jxg.A.registerElement("chart",jxg.A.createChart),jxg.A.Legend=function(t,e,i){var s;if(this.constructor(),s=utils_type.A.copyAttributes(i,t.options,"legend"),this.board=t,this.coords=new base_coords.A(constants.A.COORDS_BY_USER,e,this.board),this.myAtts={},this.label_array=s.labelarray||s.labels,this.color_array=s.colorarray||s.colors,this.lines=[],this.myAtts.strokewidth=s.strokewidth||5,this.myAtts.straightfirst=!1,this.myAtts.straightlast=!1,this.myAtts.withlabel=!0,this.myAtts.fixed=!0,this.style=s.legendstyle||s.style,"vertical"!==this.style)throw new Error("JSXGraph: Unknown legend style: "+this.style);this.drawVerticalLegend(t,s)},jxg.A.Legend.prototype=new base_element.A,jxg.A.Legend.prototype.drawVerticalLegend=function(t,e){var i,s=e.linelength||1,r=(e.rowheight||20)/this.board.unitY,o=function(){return this.setLabelRelativeCoords(this.visProp.label.offset),new base_coords.A(constants.A.COORDS_BY_USER,[this.point2.X(),this.point2.Y()],this.board)};for(i=0;i<this.label_array.length;i++)this.myAtts.name=this.label_array[i],this.myAtts.strokecolor=this.color_array[i%this.color_array.length],this.myAtts.highlightstrokecolor=this.color_array[i%this.color_array.length],this.myAtts.label={offset:[10,0],strokeColor:this.color_array[i%this.color_array.length],strokeWidth:this.myAtts.strokewidth},this.lines[i]=t.create("line",[[this.coords.usrCoords[1],this.coords.usrCoords[2]-i*r],[this.coords.usrCoords[1]+s,this.coords.usrCoords[2]-i*r]],this.myAtts),this.lines[i].getLabelAnchor=o,this.lines[i].prepareUpdate().update().updateVisibility(utils_type.A.evaluate(this.lines[i].visProp.visible)).updateRenderer()},jxg.A.createLegend=function(t,e,i){var s=[0,0];if(!utils_type.A.exists(e)||2!==e.length)throw new Error("JSXGraph: Legend element needs two numbers as parameters");return s=e,new jxg.A.Legend(t,s,i)},jxg.A.registerElement("legend",jxg.A.createLegend);var chart={Chart:jxg.A.Chart,Legend:jxg.A.Legend};jxg.A.Transformation=function(t,e,i){this.elementClass=constants.A.OBJECT_CLASS_OTHER,this.type=constants.A.OBJECT_TYPE_TRANSFORMATION,this.matrix=[[1,0,0],[0,1,0],[0,0,1]],this.board=t,this.isNumericMatrix=!1,this.setMatrix(t,e,i),this.methodMap={apply:"apply",applyOnce:"applyOnce",bindTo:"bindTo",bind:"bindTo",melt:"melt"}},jxg.A.Transformation.prototype={},jxg.A.extend(jxg.A.Transformation.prototype,{update:function(){return this},setMatrix:function(t,e,i){var s;for(this.isNumericMatrix=!0,s=0;s<i.length;s++)if("number"!=typeof i[s]){this.isNumericMatrix=!1;break}if("translate"===e){if(2!==i.length)throw new Error("JSXGraph: translate transformation needs 2 parameters.");this.evalParam=utils_type.A.createEvalFunction(t,i,2),this.update=function(){this.matrix[1][0]=this.evalParam(0),this.matrix[2][0]=this.evalParam(1)}}else if("scale"===e){if(2!==i.length)throw new Error("JSXGraph: scale transformation needs 2 parameters.");this.evalParam=utils_type.A.createEvalFunction(t,i,2),this.update=function(){this.matrix[1][1]=this.evalParam(0),this.matrix[2][2]=this.evalParam(1)}}else if("reflect"===e)i.length<4&&(i[0]=t.select(i[0])),2===i.length&&(i[1]=t.select(i[1])),4===i.length&&(this.evalParam=utils_type.A.createEvalFunction(t,i,4)),this.update=function(){var t,e,s,r,o,n,a,l;1===i.length?a=i[0].stdform:2===i.length?a=math.A.crossProduct(i[1].coords.usrCoords,i[0].coords.usrCoords):4===i.length&&(a=math.A.crossProduct([1,this.evalParam(2),this.evalParam(3)],[1,this.evalParam(0),this.evalParam(1)])),t=a[1],e=a[2],n=(l=[-(s=a[0])*t,-s*e,t*t+e*e])[2],r=l[0]/l[2],o=l[1]/l[2],t=-a[2],e=a[1],this.matrix[1][1]=(t*t-e*e)/n,this.matrix[1][2]=2*t*e/n,this.matrix[2][1]=this.matrix[1][2],this.matrix[2][2]=-this.matrix[1][1],this.matrix[1][0]=r*(1-this.matrix[1][1])-o*this.matrix[1][2],this.matrix[2][0]=o*(1-this.matrix[2][2])-r*this.matrix[2][1]};else if("rotate"===e)3===i.length?this.evalParam=utils_type.A.createEvalFunction(t,i,3):i.length>0&&i.length<=2&&(this.evalParam=utils_type.A.createEvalFunction(t,i,1),2!==i.length||utils_type.A.isArray(i[1])||(i[1]=t.select(i[1]))),this.update=function(){var t,e,s=this.evalParam(0),r=Math.cos(s),o=Math.sin(s);this.matrix[1][1]=r,this.matrix[1][2]=-o,this.matrix[2][1]=o,this.matrix[2][2]=r,i.length>1&&(3===i.length?(t=this.evalParam(1),e=this.evalParam(2)):utils_type.A.isArray(i[1])?(t=i[1][0],e=i[1][1]):(t=i[1].X(),e=i[1].Y()),this.matrix[1][0]=t*(1-r)+e*o,this.matrix[2][0]=e*(1-r)-t*o)};else if("shear"===e){if(2!==i.length)throw new Error("JSXGraph: shear transformation needs 2 parameters.");this.evalParam=utils_type.A.createEvalFunction(t,i,2),this.update=function(){this.matrix[1][2]=this.evalParam(0),this.matrix[2][1]=this.evalParam(1)}}else if("generic"===e){if(9!==i.length)throw new Error("JSXGraph: generic transformation needs 9 parameters.");this.evalParam=utils_type.A.createEvalFunction(t,i,9),this.update=function(){this.matrix[0][0]=this.evalParam(0),this.matrix[0][1]=this.evalParam(1),this.matrix[0][2]=this.evalParam(2),this.matrix[1][0]=this.evalParam(3),this.matrix[1][1]=this.evalParam(4),this.matrix[1][2]=this.evalParam(5),this.matrix[2][0]=this.evalParam(6),this.matrix[2][1]=this.evalParam(7),this.matrix[2][2]=this.evalParam(8)}}},apply:function(t,e){return this.update(),utils_type.A.exists(e)?math.A.matVecMult(this.matrix,t.initialCoords.usrCoords):math.A.matVecMult(this.matrix,t.coords.usrCoords)},applyOnce:function(t){var e,i,s;for(utils_type.A.isArray(t)||(t=[t]),i=t.length,s=0;s<i;s++)this.update(),e=math.A.matVecMult(this.matrix,t[s].coords.usrCoords),t[s].coords.setCoordinates(constants.A.COORDS_BY_USER,e)},bindTo:function(t){var e,i;if(utils_type.A.isArray(t))for(i=t.length,e=0;e<i;e++)t[e].transformations.push(this);else t.transformations.push(this)},setProperty:function(t){jxg.A.deprecated("Transformation.setProperty()","Transformation.setAttribute()")},setAttribute:function(t){},melt:function(t){var e,i,s,r,o,n,a=[];for(i=t.matrix.length,s=this.matrix[0].length,e=0;e<i;e++)a[e]=[];for(this.update(),t.update(),e=0;e<i;e++)for(n=0;n<s;n++){for(o=0,r=0;r<i;r++)o+=t.matrix[e][r]*this.matrix[r][n];a[e][n]=o}return this.update=function(){var t=this.matrix.length,i=this.matrix[0].length;for(e=0;e<t;e++)for(n=0;n<i;n++)this.matrix[e][n]=a[e][n]},this},getParents:function(){var t=[[].concat.apply([],this.matrix)];return 0!==this.parents.length&&(t=this.parents),t}}),jxg.A.createTransform=function(t,e,i){return new jxg.A.Transformation(t,i.type,e)},jxg.A.registerElement("transform",jxg.A.createTransform);var transformation=jxg.A.Transformation;jxg.A.Turtle=function(t,e,i){var s,r,o;return this.constructor(t,i,constants.A.OBJECT_TYPE_TURTLE,constants.A.OBJECT_CLASS_OTHER),this.turtleIsHidden=!1,this.board=t,this.visProp.curveType="plot",this._attributes=utils_type.A.copyAttributes(this.visProp,t.options,"turtle"),delete this._attributes.id,s=0,r=0,o=90,0!==e.length&&(3===e.length?(s=e[0],r=e[1],o=e[2]):2===e.length?utils_type.A.isArray(e[0])?(s=e[0][0],r=e[0][1],o=e[1]):(s=e[0],r=e[1]):(s=e[0][0],r=e[0][1])),this.init(s,r,o),this.methodMap=utils_type.A.deepCopy(this.methodMap,{forward:"forward",fd:"forward",back:"back",bk:"back",right:"right",rt:"right",left:"left",lt:"left",penUp:"penUp",pu:"penUp",up:"penUp",penDown:"penDown",pd:"penDown",down:"penDown",clearScreen:"clearScreen",cs:"clearScreen",clean:"clean",setPos:"setPos",home:"home",hideTurtle:"hideTurtle",ht:"hideTurtle",hide:"hideTurtle",showTurtle:"showTurtle",st:"showTurtle",show:"showTurtle",penSize:"setPenSize",setPenSize:"setPenSize",penColor:"setPenColor",setPenColor:"setPenColor",highlightPenColor:"setHighlightPenColor",setHighlightPenColor:"setHighlightPenColor",getPenColor:"getPenColor",Color:"getPenColor",getHighlightPenColor:"getHighlightPenColor",HighlightColor:"getHighlightPenColor",getPenSize:"getPenSize",Size:"getPenSize",pushTurtle:"pushTurtle",push:"pushTurtle",popTurtle:"popTurtle",pop:"popTurtle",lookTo:"lookTo",pos:"pos",Pos:"pos",moveTo:"moveTo",X:"X",Y:"Y"}),this},jxg.A.Turtle.prototype=new base_element.A,jxg.A.extend(jxg.A.Turtle.prototype,{init:function(t,e,i){var s={fixed:!0,name:"",visible:!1,withLabel:!1};this.arrowLen=20/math.A.hypot(this.board.unitX,this.board.unitY),this.pos=[t,e],this.isPenDown=!0,this.dir=90,this.stack=[],this.objects=[],this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes),this.objects.push(this.curve),this.turtle=this.board.create("point",this.pos,s),this.objects.push(this.turtle),this.turtle2=this.board.create("point",[this.pos[0],this.pos[1]+this.arrowLen],s),this.objects.push(this.turtle2),this.visProp.arrow.lastArrow=!0,this.visProp.arrow.straightFirst=!1,this.visProp.arrow.straightLast=!1,this.arrow=this.board.create("line",[this.turtle,this.turtle2],this.visProp.arrow),this.objects.push(this.arrow),this.subs={arrow:this.arrow},this.inherits.push(this.arrow),this.right(90-i),this.board.update()},forward:function(t){if(0===t)return this;var e,i=t*Math.cos(this.dir*Math.PI/180),s=t*Math.sin(this.dir*Math.PI/180);return this.turtleIsHidden||((e=this.board.create("transform",[i,s],{type:"translate"})).applyOnce(this.turtle),e.applyOnce(this.turtle2)),this.isPenDown&&this.curve.dataX.length>=8192&&(this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes),this.objects.push(this.curve)),this.pos[0]+=i,this.pos[1]+=s,this.isPenDown&&(this.curve.dataX.push(this.pos[0]),this.curve.dataY.push(this.pos[1])),this.board.update(),this},back:function(t){return this.forward(-t)},right:function(t){(this.dir-=t,this.dir%=360,this.turtleIsHidden)||this.board.create("transform",[-t*Math.PI/180,this.turtle],{type:"rotate"}).applyOnce(this.turtle2);return this.board.update(),this},left:function(t){return this.right(-t)},penUp:function(){return this.isPenDown=!1,this},penDown:function(){return this.isPenDown=!0,this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes),this.objects.push(this.curve),this},clean:function(){var t,e;for(t=0;t<this.objects.length;t++)(e=this.objects[t]).type===constants.A.OBJECT_TYPE_CURVE&&(this.board.removeObject(e),this.objects.splice(t,1));return this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes),this.objects.push(this.curve),this.board.update(),this},clearScreen:function(){var t,e,i=this.objects.length;for(t=0;t<i;t++)e=this.objects[t],this.board.removeObject(e);return this.init(0,0,90),this},setPos:function(t,e){return utils_type.A.isArray(t)?this.pos=t:this.pos=[t,e],this.turtleIsHidden||(this.turtle.setPositionDirectly(constants.A.COORDS_BY_USER,[t,e]),this.turtle2.setPositionDirectly(constants.A.COORDS_BY_USER,[t,e+this.arrowLen]),this.board.create("transform",[-(this.dir-90)*Math.PI/180,this.turtle],{type:"rotate"}).applyOnce(this.turtle2)),this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes),this.objects.push(this.curve),this.board.update(),this},setPenSize:function(t){return this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.copyAttr("strokeWidth",t)),this.objects.push(this.curve),this},setPenColor:function(t){return this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.copyAttr("strokeColor",t)),this.objects.push(this.curve),this},getPenAttribute:function(t){var e,i=this.objects.length;return e=4===i?0:i-1,utils_type.A.evaluate(this.objects[e].visProp[t])},getPenSize:function(){return this.getPenAttribute("strokewidth")},getPenColor:function(){return this.getPenAttribute("strokecolor")},getHighlightPenColor:function(){return this.getPenAttribute("highlightstrokecolor")},setHighlightPenColor:function(t){return this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.copyAttr("highlightStrokeColor",t)),this.objects.push(this.curve),this},setAttribute:function(t){var e,i,s,r=this.objects.length;for(e=0;e<r;e++)(i=this.objects[e]).type===constants.A.OBJECT_TYPE_CURVE&&i.setAttribute(t);return s=this.visProp.id,this.visProp=utils_type.A.deepCopy(this.curve.visProp),this.visProp.id=s,this._attributes=utils_type.A.deepCopy(this.visProp),delete this._attributes.id,this},copyAttr:function(t,e){return this._attributes[t.toLowerCase()]=e,this._attributes},showTurtle:function(){return this.turtleIsHidden=!1,this.arrow.setAttribute({visible:!0}),this.visProp.arrow.visible=!1,this.setPos(this.pos[0],this.pos[1]),this.board.update(),this},hideTurtle:function(){return this.turtleIsHidden=!0,this.arrow.setAttribute({visible:!1}),this.visProp.arrow.visible=!1,this.board.update(),this},home:function(){return this.pos=[0,0],this.setPos(this.pos[0],this.pos[1]),this},pushTurtle:function(){return this.stack.push([this.pos[0],this.pos[1],this.dir]),this},popTurtle:function(){var t=this.stack.pop();return this.pos[0]=t[0],this.pos[1]=t[1],this.dir=t[2],this.setPos(this.pos[0],this.pos[1]),this},lookTo:function(t){var e,i,s,r,o;return utils_type.A.isArray(t)?(e=this.pos[0],i=this.pos[1],s=t[0],r=t[1],o=Math.atan2(r-i,s-e),this.right(this.dir-180*o/Math.PI)):utils_type.A.isNumber(t)&&this.right(this.dir-t),this},moveTo:function(t){var e,i,s;return utils_type.A.isArray(t)&&(e=t[0]-this.pos[0],i=t[1]-this.pos[1],this.turtleIsHidden||((s=this.board.create("transform",[e,i],{type:"translate"})).applyOnce(this.turtle),s.applyOnce(this.turtle2)),this.isPenDown&&this.curve.dataX.length>=8192&&(this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes),this.objects.push(this.curve)),this.pos[0]=t[0],this.pos[1]=t[1],this.isPenDown&&(this.curve.dataX.push(this.pos[0]),this.curve.dataY.push(this.pos[1])),this.board.update()),this},fd:function(t){return this.forward(t)},bk:function(t){return this.back(t)},lt:function(t){return this.left(t)},rt:function(t){return this.right(t)},pu:function(){return this.penUp()},pd:function(){return this.penDown()},ht:function(){return this.hideTurtle()},st:function(){return this.showTurtle()},cs:function(){return this.clearScreen()},push:function(){return this.pushTurtle()},pop:function(){return this.popTurtle()},evalAt:function(t,e){var i,s,r,o,n=this.objects.length;for(i=0,s=0;i<n;i++)if((r=this.objects[i]).elementClass===constants.A.OBJECT_CLASS_CURVE){if(s<=t&&t<s+r.numberPoints)return o=t-s,r[e](o);s+=r.numberPoints}return this[e]()},X:function(t){return utils_type.A.exists(t)?this.evalAt(t,"X"):this.pos[0]},Y:function(t){return utils_type.A.exists(t)?this.evalAt(t,"Y"):this.pos[1]},Z:function(t){return 1},minX:function(){return 0},maxX:function(){var t,e=this.objects.length,i=0;for(t=0;t<e;t++)this.objects[t].elementClass===constants.A.OBJECT_CLASS_CURVE&&(i+=this.objects[t].numberPoints);return i},hasPoint:function(t,e){var i,s;for(i=0;i<this.objects.length;i++)if((s=this.objects[i]).type===constants.A.OBJECT_TYPE_CURVE&&s.hasPoint(t,e))return!0;return!1}}),jxg.A.createTurtle=function(t,e,i){var s;return e=e||[],s=utils_type.A.copyAttributes(i,t.options,"turtle"),new jxg.A.Turtle(t,e,s)},jxg.A.registerElement("turtle",jxg.A.createTurtle);var turtle=jxg.A.Turtle;jxg.A.Ticks=function(t,e,i){if(this.constructor(t.board,i,constants.A.OBJECT_TYPE_TICKS,constants.A.OBJECT_CLASS_OTHER),this.line=t,this.board=this.line.board,this.fixedTicks=null,this.equidistant=!1,this.labelsData=[],utils_type.A.isFunction(e))throw this.ticksFunction=e,new Error("Function arguments are no longer supported.");utils_type.A.isArray(e)?this.fixedTicks=e:this.equidistant=!0,this.ticks=[],this.labels=[],this.labelCounter=0,this.id=this.line.addTicks(this),this.elType="ticks",this.inherits.push(this.labels),this.board.setId(this,"Ti")},jxg.A.Ticks.prototype=new base_element.A,jxg.A.extend(jxg.A.Ticks.prototype,{hasPoint:function(t,e){var i,s,r,o,n=this.ticks&&this.ticks.length||0;if(utils_type.A.isObject(utils_type.A.evaluate(this.visProp.precision))?(o=this.board._inputDevice,r=utils_type.A.evaluate(this.visProp.precision[o])):r=this.board.options.precision.hasPoint,r+=.5*utils_type.A.evaluate(this.visProp.strokewidth),!utils_type.A.evaluate(this.line.visProp.scalable)||this.line.elementClass===constants.A.OBJECT_CLASS_CURVE)return!1;if(0!==this.line.stdform[1]&&0!==this.line.stdform[2]&&this.line.type!==constants.A.OBJECT_TYPE_AXIS)return!1;for(i=0;i<n;i++)if((s=this.ticks[i])[2]&&!(0===this.line.stdform[1]&&Math.abs(s[0][0]-this.line.point1.coords.scrCoords[1])<math.A.eps||0===this.line.stdform[2]&&Math.abs(s[1][0]-this.line.point1.coords.scrCoords[2])<math.A.eps)&&(Math.abs(s[0][0]-s[0][1])>=1||Math.abs(s[1][0]-s[1][1])>=1))if(0===this.line.stdform[1]){if(Math.abs(e-this.line.point1.coords.scrCoords[2])<2*r&&s[0][0]-r<t&&t<s[0][1]+r)return!0}else if(0===this.line.stdform[2]&&Math.abs(t-this.line.point1.coords.scrCoords[1])<2*r&&s[1][0]-r<e&&e<s[1][1]+r)return!0;return!1},setPositionDirectly:function(t,e,i){var s,r,o=new base_coords.A(t,e,this.board),n=new base_coords.A(t,i,this.board),a=this.board.getBoundingBox();return this.line.type===constants.A.OBJECT_TYPE_AXIS&&utils_type.A.evaluate(this.line.visProp.scalable)?(Math.abs(this.line.stdform[1])<math.A.eps&&Math.abs(o.usrCoords[1]*n.usrCoords[1])>math.A.eps?(s=n.usrCoords[1]/o.usrCoords[1],a[0]*=s,a[2]*=s,this.board.setBoundingBox(a,this.board.keepaspectratio,"update")):Math.abs(this.line.stdform[2])<math.A.eps&&Math.abs(o.usrCoords[2]*n.usrCoords[2])>math.A.eps&&(r=n.usrCoords[2]/o.usrCoords[2],a[3]*=r,a[1]*=r,this.board.setBoundingBox(a,this.board.keepaspectratio,"update")),this):this},calculateTicksCoordinates:function(){var t,e,i,s;if(!(this.line.elementClass===constants.A.OBJECT_CLASS_LINE&&(this.setTicksSizeVariables(),Math.abs(this.dx)<math.A.eps&&Math.abs(this.dy)<math.A.eps)))return t=this.getZeroCoordinates(),e=this.line.elementClass===constants.A.OBJECT_CLASS_LINE?this.getLowerAndUpperBounds(t,"ticksdistance"):{lower:this.line.minX(),upper:this.line.maxX(),a1:0,a2:0,m1:0,m2:0},"polar"===utils_type.A.evaluate(this.visProp.type)&&(s=this.board.getBoundingBox(),i=Math.max(math.A.hypot(s[0],s[1]),math.A.hypot(s[2],s[3])),e.upper=i),this.ticks=[],this.labelsData=[],this.equidistant?this.generateEquidistantTicks(t,e):this.generateFixedTicks(t,e),this},setTicksSizeVariables:function(t){var e,i,s,r,o=.5*utils_type.A.evaluate(this.visProp.majorheight),n=.5*utils_type.A.evaluate(this.visProp.minorheight);utils_type.A.exists(t)?(i=this.line.minX(),s=this.line.maxX(),(r=this.line.points.length)<2?(this.dxMaj=0,this.dyMaj=0):math.A.relDif(t,i)<math.A.eps?(this.dxMaj=this.line.points[0].usrCoords[2]-this.line.points[1].usrCoords[2],this.dyMaj=this.line.points[1].usrCoords[1]-this.line.points[0].usrCoords[1]):math.A.relDif(t,s)<math.A.eps?(this.dxMaj=this.line.points[r-2].usrCoords[2]-this.line.points[r-1].usrCoords[2],this.dyMaj=this.line.points[r-1].usrCoords[1]-this.line.points[r-2].usrCoords[1]):(this.dxMaj=-numerics.A.D(this.line.Y)(t),this.dyMaj=numerics.A.D(this.line.X)(t))):(this.dxMaj=this.line.stdform[1],this.dyMaj=this.line.stdform[2]),this.dxMin=this.dxMaj,this.dyMin=this.dyMaj,this.dx=this.dxMaj,this.dy=this.dyMaj,e=math.A.hypot(this.dxMaj*this.board.unitX,this.dyMaj*this.board.unitY),this.dxMaj*=o/e*this.board.unitX,this.dyMaj*=o/e*this.board.unitY,this.dxMin*=n/e*this.board.unitX,this.dyMin*=n/e*this.board.unitY,this.minStyle=utils_type.A.evaluate(this.visProp.minorheight)<0?"infinite":"finite",this.majStyle=utils_type.A.evaluate(this.visProp.majorheight)<0?"infinite":"finite"},getZeroCoordinates:function(){var t,e,i,s,r,o,n,a,l=utils_type.A.evaluate(this.visProp.anchor);return this.line.elementClass===constants.A.OBJECT_CLASS_LINE?this.line.type===constants.A.OBJECT_TYPE_AXIS?geometry.A.projectPointToLine({coords:{usrCoords:[1,0,0]}},this.line,this.board):(i=this.line.point1.coords.usrCoords[0],t=this.line.point1.coords.usrCoords[1],e=this.line.point1.coords.usrCoords[2],o=this.line.point2.coords.usrCoords[0],s=this.line.point2.coords.usrCoords[1],r=this.line.point2.coords.usrCoords[2],"right"===l?this.line.point2.coords:"middle"===l?new base_coords.A(constants.A.COORDS_BY_USER,[.5*(i+o),.5*(t+s),.5*(e+r)],this.board):utils_type.A.isNumber(l)?new base_coords.A(constants.A.COORDS_BY_USER,[i+(o-i)*l,t+(s-t)*l,e+(r-e)*l],this.board):this.line.point1.coords):(n=this.line.minX(),a=this.line.maxX(),"right"===l?a:"middle"===l?.5*(n+a):utils_type.A.isNumber(l)?n*(1-l)+a*l:n)},getLowerAndUpperBounds:function(t,e){var i,s,r,o,n,a,l,h,u,c,d,p,_,f,A,g=10*math.A.eps,m=utils_type.A.evaluate(this.line.visProp.straightfirst),y=utils_type.A.evaluate(this.line.visProp.straightlast),b=utils_type.A.evaluate(this.visProp.includeboundaries);return this.line.elementClass===constants.A.OBJECT_CLASS_CURVE?{lower:this.line.minX(),upper:this.line.maxX()}:(n=new base_coords.A(constants.A.COORDS_BY_USER,this.line.point1.coords.usrCoords,this.board),a=new base_coords.A(constants.A.COORDS_BY_USER,this.line.point2.coords.usrCoords,this.board),l=Math.abs(n.usrCoords[0])>=math.A.eps&&n.scrCoords[1]>=0&&n.scrCoords[1]<=this.board.canvasWidth&&n.scrCoords[2]>=0&&n.scrCoords[2]<=this.board.canvasHeight,h=Math.abs(a.usrCoords[0])>=math.A.eps&&a.scrCoords[1]>=0&&a.scrCoords[1]<=this.board.canvasWidth&&a.scrCoords[2]>=0&&a.scrCoords[2]<=this.board.canvasHeight,utils_type.A.exists(e)&&"ticksdistance"===e?(geometry.A.calcStraight(this.line,n,a,0),f=this.getDistanceFromZero(t,n),A=this.getDistanceFromZero(t,a),geometry.A.calcStraight(this.line,n,a,utils_type.A.evaluate(this.line.visProp.margin)),f=this.getDistanceFromZero(t,n)-f,A=this.getDistanceFromZero(t,a).m2):geometry.A.calcLineDelimitingPoints(this.line,n,a),r=utils_type.A.evaluate(this.line.visProp.firstarrow),o=utils_type.A.evaluate(this.line.visProp.lastarrow),p=this.getDistanceFromZero(t,n),_=this.getDistanceFromZero(t,a),(r||o)&&(d=this.board.renderer.getArrowHeadData(this.line,utils_type.A.evaluate(this.line.visProp.strokewidth),""),this.board.renderer.getPositionArrowHead(this.line,n,a,d)),(u=this.getDistanceFromZero(t,n))<(c=this.getDistanceFromZero(t,a))?(i=u,s=c,m||!l||b||(i+=g),y||!h||b||(s-=g)):c<u?(i=c,s=u,y||!h||b||(i+=g),m||!l||b||(s-=g)):(i=0,s=0),{lower:i,upper:s,a1:p=u-p,a2:_=u-_,m1:f,m2:A})},getDistanceFromZero:function(t,e){var i,s,r,o,n;return i=this.line.point1.coords,s=this.line.point2.coords,n=t.distance(constants.A.COORDS_BY_USER,e),r=[s.usrCoords[0]-i.usrCoords[0],s.usrCoords[1]-i.usrCoords[1],s.usrCoords[2]-i.usrCoords[2]],o=[e.usrCoords[0]-t.usrCoords[0],e.usrCoords[1]-t.usrCoords[1],e.usrCoords[2]-t.usrCoords[2]],math.A.innerProduct(r,o,3)<0&&(n*=-1),n},generateEquidistantTicks:function(t,e){var i,s,r,o=math.A.eps,n=utils_type.A.evaluate(this.visProp.minorticks);if(r=this.getDistanceMajorTicks(),this.line.elementClass===constants.A.OBJECT_CLASS_LINE&&(s=this.getXandYdeltas()),r*=utils_type.A.evaluate(this.visProp.scale),r/=n+1,this.ticksDelta=r,!(r<math.A.eps)){for(i=0,utils_type.A.evaluate(this.visProp.drawzero)||(i=r);i<=e.upper+o&&(i>=e.lower-o&&this.processTickPosition(t,i,r,s),i+=r,!(e.upper-i>1e4*r)););for(i=-r;i>=e.lower-o&&(i<=e.upper+o&&this.processTickPosition(t,i,r,s),!((i-=r)-e.lower>1e4*r)););}},getDistanceMajorTicks:function(){var t,e,i,s,r,o,n,a;return utils_type.A.evaluate(this.visProp.insertticks)?(o=((i=this.getLowerAndUpperBounds(this.getZeroCoordinates(),"")).upper-i.lower)/6/(r=utils_type.A.evaluate(this.visProp.scale)),n=utils_type.A.evaluate(this.visProp.minticksdistance)/r,a=utils_type.A.evaluate(this.visProp.minorticks),(s=this.getXandYdeltas()).x*=this.board.unitX,s.y*=this.board.unitY,n/=math.A.hypot(s.x,s.y),n*=a+1,2*(t=Math.pow(10,Math.floor(Math.log(n)/Math.LN10)))>=n?t*=2:5*t>=n&&(t*=5),5*(e=Math.pow(10,Math.floor(Math.log(o)/Math.LN10)))<o?e*=5:2*e<o&&(e*=2),t=Math.max(t,e)):utils_type.A.evaluate(this.visProp.ticksdistance)},processTickPosition:function(t,e,i,s){var r,o,n,a,l,h=utils_type.A.evaluate(this.visProp.ticksperlabel),u=null;this.line.elementClass===constants.A.OBJECT_CLASS_LINE?(r=t.usrCoords[1]+e*s.x,o=t.usrCoords[2]+e*s.y):(r=this.line.X(t+e),o=this.line.Y(t+e)),n=new base_coords.A(constants.A.COORDS_BY_USER,[r,o],this.board),this.line.elementClass===constants.A.OBJECT_CLASS_CURVE&&(u=t+e,this.setTicksSizeVariables(u)),n.major=Math.round(e/i)%(utils_type.A.evaluate(this.visProp.minorticks)+1)==0,h||(h=utils_type.A.evaluate(this.visProp.minorticks)+1),l=Math.round(e/i)%h==0,3===(a=this.createTickPath(n,n.major)).length&&(this.ticks.push(a),l&&utils_type.A.evaluate(this.visProp.drawlabels)?this.labelsData.push(this.generateLabelData(this.generateLabelText(n,t,u),n,this.ticks.length)):this.labelsData.push(null))},generateFixedTicks:function(t,e){var i,s,r,o,n,a,l,h,u=math.A.eps,c=utils_type.A.isArray(this.visProp.labels),d=utils_type.A.evaluate(this.visProp.drawlabels);for(this.line.elementClass===constants.A.OBJECT_CLASS_LINE&&(h=this.getXandYdeltas()),r=0;r<this.fixedTicks.length;r++)this.line.elementClass===constants.A.OBJECT_CLASS_LINE?(l=this.fixedTicks[r],n=t.usrCoords[1]+l*h.x,a=t.usrCoords[2]+l*h.y):(l=t+this.fixedTicks[r],n=this.line.X(l),a=this.line.Y(l)),i=new base_coords.A(constants.A.COORDS_BY_USER,[n,a],this.board),this.line.elementClass===constants.A.OBJECT_CLASS_CURVE&&this.setTicksSizeVariables(l),3===(o=this.createTickPath(i,!0)).length&&l>=e.lower-u&&l<=e.upper+u&&(this.ticks.push(o),d&&(c||utils_type.A.exists(this.visProp.labels[r]))?(s=c?utils_type.A.evaluate(this.visProp.labels[r]):l,this.labelsData.push(this.generateLabelData(this.generateLabelText(i,t,s),i,r))):this.labelsData.push(null))},getXandYdeltas:function(){var t,e,i=this.line.point1.Dist(this.line.point2);return t=this.line.point1.coords.usrCoords,{x:((e=this.line.point2.coords.usrCoords)[1]-t[1])/i,y:(e[2]-t[2])/i}},_isInsideCanvas:function(t,e,i){var s=this.board.canvasWidth,r=this.board.canvasHeight;return void 0===i&&(i=0),t[0]>=i&&t[0]<=s-i&&e[0]>=i&&e[0]<=r-i||t[1]>=i&&t[1]<=s-i&&e[1]>=i&&e[1]<=r-i},createTickPath:function(t,e){var i,s,r,o,n,a,l,h,u,c,d,p,_,f,A,g,m,y=[-2e6,-2e6],b=[-2e6,-2e6];if(i=t.scrCoords,e?(o=this.dxMaj,n=this.dyMaj,u=this.majStyle,A=utils_type.A.evaluate(this.visProp.majortickendings[0])>0,g=utils_type.A.evaluate(this.visProp.majortickendings[1])>0):(o=this.dxMin,n=this.dyMin,u=this.minStyle,A=utils_type.A.evaluate(this.visProp.tickendings[0])>0,g=utils_type.A.evaluate(this.visProp.tickendings[1])>0),s=[-n*i[1]-o*i[2],n,o],e&&"polar"===utils_type.A.evaluate(this.visProp.type)){if(p=this.board.getBoundingBox(),f=(_=2*Math.PI)/180,i=t.usrCoords,(d=math.A.hypot(i[1],i[2]))<Math.max(math.A.hypot(p[0],p[1]),math.A.hypot(p[2],p[3]))){for(y=[],b=[],c=0;c<=_;c+=f)y.push(this.board.origin.scrCoords[1]+d*Math.cos(c)*this.board.unitX),b.push(this.board.origin.scrCoords[2]+d*Math.sin(c)*this.board.unitY);return[y,b,e]}}else{if("infinite"===u){if(utils_type.A.evaluate(this.visProp.ignoreinfinitetickendings)&&(A=g=!0),r=geometry.A.meetLineBoard(s,this.board),A&&g)y[0]=r[0].scrCoords[1],y[1]=r[1].scrCoords[1],b[0]=r[0].scrCoords[2],b[1]=r[1].scrCoords[2];else if((m=[math.A.innerProduct(r[0].usrCoords.slice(1,3),this.line.stdform.slice(1,3))+this.line.stdform[0],math.A.innerProduct(r[1].usrCoords.slice(1,3),this.line.stdform.slice(1,3))+this.line.stdform[0]])[0]<m[1]&&(r.reverse(),m.reverse()),A){if(m[0]<0)return[];m[1]<0?(y[0]=r[0].scrCoords[1],b[0]=r[0].scrCoords[2],y[1]=i[1],b[1]=i[2]):(y[0]=r[0].scrCoords[1],b[0]=r[0].scrCoords[2],y[1]=r[1].scrCoords[1],b[1]=r[1].scrCoords[2])}else if(g){if(m[1]>0)return[];m[0]>0?(y[0]=i[1],b[0]=i[2],y[1]=r[1].scrCoords[1],b[1]=r[1].scrCoords[2]):(y[0]=r[0].scrCoords[1],b[0]=r[0].scrCoords[2],y[1]=r[1].scrCoords[1],b[1]=r[1].scrCoords[2])}}else h=">"===utils_type.A.evaluate(this.visProp.face)?Math.PI/4:"<"===utils_type.A.evaluate(this.visProp.face)?-Math.PI/4:0,a=Math.cos(h)*o-Math.sin(h)*n,l=Math.sin(h)*o+Math.cos(h)*n,y[0]=i[1]+a*A,b[0]=i[2]-l*A,y[1]=i[1],b[1]=i[2],h=-h,a=Math.cos(h)*o-Math.sin(h)*n,l=Math.sin(h)*o+Math.cos(h)*n,y[2]=i[1]-a*g,b[2]=i[2]+l*g;if(this._isInsideCanvas(y,b))return[y,b,e]}return[]},formatLabelText:function(t){var e,i,s=utils_type.A.evaluate(this.visProp.label.usemathjax),r=utils_type.A.evaluate(this.visProp.label.usekatex),o=utils_type.A.evaluate(this.visProp.scalesymbol);return utils_type.A.isNumber(t)?(utils_type.A.evaluate(this.visProp.label.tofraction)?e=s?"\\("+utils_type.A.toFraction(t,!0)+"\\)":utils_type.A.toFraction(t,r):(i=utils_type.A.evaluate(this.visProp.digits),this.useLocale()?e=this.formatNumberLocale(t,i):((e=(Math.round(1e11*t)/1e11).toString()).length>utils_type.A.evaluate(this.visProp.maxlabellength)||-1!==e.indexOf("e"))&&(3!==utils_type.A.evaluate(this.visProp.precision)&&3===i&&(i=utils_type.A.evaluate(this.visProp.precision)),e=t.toExponential(i).toString())),utils_type.A.evaluate(this.visProp.beautifulscientificticklabels)&&(e=this.beautifyScientificNotationLabel(e)),e.indexOf(".")>-1&&-1===e.indexOf("e")&&(e=(e=e.replace(/0+$/,"")).replace(/\.$/,""))):e=t.toString(),o.length>0&&("1"===e?e=o:"-1"===e?e="-"+o:"0"!==e&&(e+=o)),utils_type.A.evaluate(this.visProp.useunicodeminus)&&(e=e.replace(/-/g,"−")),e},beautifyScientificNotationLabel:function(t){return-1===t.indexOf("e")?t:(parseFloat(t.substring(0,t.indexOf("e")))+t.substring(t.indexOf("e"))).replace(/e(.*)$/g,(function(t,e){var i="•10";return i+=e.replace(/-/g,"⁻").replace(/\+/g,"").replace(/0/g,"⁰").replace(/1/g,"¹").replace(/2/g,"²").replace(/3/g,"³").replace(/4/g,"⁴").replace(/5/g,"⁵").replace(/6/g,"⁶").replace(/7/g,"⁷").replace(/8/g,"⁸").replace(/9/g,"⁹")}))},generateLabelText:function(t,e,i){var s;if(!utils_type.A.exists(i)){if(s=this.getDistanceFromZero(e,t),Math.abs(s)<math.A.eps)return"0";i=s/utils_type.A.evaluate(this.visProp.scale)}return this.formatLabelText(i)},generateLabelData:function(t,e,i){var s,r,o,n;return n=utils_type.A.evaluate(this.visProp.label.fontsize),s=[e.scrCoords[1],e.scrCoords[1]],r=[e.scrCoords[2],e.scrCoords[2]],o=void 0===n?12:n,o*=.5,this._isInsideCanvas(s,r,o)?(s=utils_type.A.evaluate(this.visProp.label.offset[0]),r=utils_type.A.evaluate(this.visProp.label.offset[1]),{x:e.usrCoords[1]+s/this.board.unitX,y:e.usrCoords[2]+r/this.board.unitY,t:t,i:i}):null},update:function(){return this.needsUpdate&&0!==this.board.canvasWidth&&0!==this.board.canvasHeight&&this.calculateTicksCoordinates(),this},updateRenderer:function(){return this.needsUpdate?(this.visPropCalc.visible&&this.board.renderer.updateTicks(this),this.updateRendererLabels(),this.setDisplayRendNode(),this.needsUpdate=!1,this):this},updateRendererLabels:function(){var t,e,i,s,r,o,n,a;for(i=this.labelsData.length,s=this.labels.length,t=0,e=0;t<i;t++)null!==this.labelsData[t]&&(n=this.labelsData[t],e<s?((o=this.labels[e]).setText(n.t),o.setCoords(n.x,n.y),e++):(this.labelCounter+=1,r={isLabel:!0,layer:this.board.options.layer.line,highlightStrokeColor:this.board.options.text.strokeColor,highlightStrokeWidth:this.board.options.text.strokeWidth,highlightStrokeOpacity:this.board.options.text.strokeOpacity,priv:this.visProp.priv},(r=utils_type.A.deepCopy(r,this.visProp.label)).id=this.id+n.i+"Label"+this.labelCounter,o=jxg.A.createText(this.board,[n.x,n.y,n.t],r),this.addChild(o),o.setParents(this),o.isDraggable=!1,o.dump=!1,this.labels.push(o)),"inherit"===(a=utils_type.A.evaluate(this.visProp.label.visible))&&(a=this.visPropCalc.visible),o.prepareUpdate().updateVisibility(a).updateRenderer(),o.distanceX=utils_type.A.evaluate(this.visProp.label.offset[0]),o.distanceY=utils_type.A.evaluate(this.visProp.label.offset[1]));for(e=i=e;e<s;e++)this.board.renderer.display(this.labels[e],!1),this.labels[e].visProp.visible=this.labels[e].visPropCalc.visible=!1;return this},hideElement:function(){var t;for(jxg.A.deprecated("Element.hideElement()","Element.setDisplayRendNode()"),this.visPropCalc.visible=!1,this.board.renderer.display(this,!1),t=0;t<this.labels.length;t++)utils_type.A.exists(this.labels[t])&&this.labels[t].hideElement();return this},showElement:function(){var t;for(jxg.A.deprecated("Element.showElement()","Element.setDisplayRendNode()"),this.visPropCalc.visible=!0,this.board.renderer.display(this,!1),t=0;t<this.labels.length;t++)utils_type.A.exists(this.labels[t])&&this.labels[t].showElement();return this}}),jxg.A.createTicks=function(t,e,i){var s,r,o=utils_type.A.copyAttributes(i,t.options,"ticks");if(r=e.length<2?o.ticksdistance:e[1],e[0].elementClass!==constants.A.OBJECT_CLASS_LINE&&e[0].elementClass!==constants.A.OBJECT_CLASS_CURVE)throw new Error("JSXGraph: Can't create Ticks with parent types '"+typeof e[0]+"'.");return s=new jxg.A.Ticks(e[0],r,o),utils_type.A.isFunction(o.generatelabelvalue)&&(s.generateLabelText=o.generatelabelvalue),utils_type.A.isFunction(o.generatelabeltext)&&(s.generateLabelText=o.generatelabeltext),s.setParents(e[0]),s.isDraggable=!0,s.fullUpdate(e[0].visPropCalc.visible),s},jxg.A.createHatchmark=function(t,e,i){var s,r,o,n,a,l=[],h=utils_type.A.copyAttributes(i,t.options,"hatch");if(e[0].elementClass!==constants.A.OBJECT_CLASS_LINE&&e[0].elementClass!==constants.A.OBJECT_CLASS_CURVE||"number"!=typeof e[1])throw new Error("JSXGraph: Can't create Hatch mark with parent types '"+typeof e[0]+"' and '"+typeof e[1]+" and ''"+typeof e[2]+"'.");for(o=.5*-(((s=e[1])-1)*(n=h.ticksdistance)),r=0;r<s;r++)l[r]=o+r*n;return(a=t.create("ticks",[e[0],l],h)).elType="hatch",e[0].inherits.push(a),a},jxg.A.registerElement("ticks",jxg.A.createTicks),jxg.A.registerElement("hash",jxg.A.createHatchmark),jxg.A.registerElement("hatch",jxg.A.createHatchmark);var ticks=jxg.A.Ticks;jxg.A.CA=function(t,e,i){this.node=t,this.createNode=e,this.parser=i},jxg.A.extend(jxg.A.CA.prototype,{findMapNode:function(t,e){var i,s,r;if("op_assign"===e.value&&e.children[0].value===t)return e.children[1];if(e.children)for(s=e.children.length,i=0;i<s;++i)if(null!==(r=this.findMapNode(t,e.children[i])))return r;return null},setMath:function(t){var e,i;if(("node_op"!=t.type||"op_add"!=t.value&&"op_sub"!=t.value&&"op_mul"!=t.value&&"op_div"!=t.value&&"op_neg"!=t.value&&"op_execfun"!=t.value&&"op_exp"!=t.value)&&"node_var"!=t.type&&"node_const"!=t.type||(t.isMath=!0),t.children)for(i=t.children.length,e=0;e<i;++e)this.setMath(t.children[e])},deriveElementary:function(t,e){var i,s=t.children[0].value,r=t.children[1];switch(s){case"abs":i=this.createNode("node_op","op_div",r[0],this.createNode("node_op","op_execfun",this.createNode("node_var","sqrt"),[this.createNode("node_op","op_mul",utils_type.A.deepCopy(r[0]),utils_type.A.deepCopy(r[0]))]));break;case"sqrt":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_mul",this.createNode("node_const",2),this.createNode(t.type,t.value,utils_type.A.deepCopy(t.children[0]),utils_type.A.deepCopy(t.children[1]))));break;case"sin":i=this.createNode("node_op","op_execfun",this.createNode("node_var","cos"),utils_type.A.deepCopy(r));break;case"cos":i=this.createNode("node_op","op_neg",this.createNode("node_op","op_execfun",this.createNode("node_var","sin"),utils_type.A.deepCopy(r)));break;case"tan":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_exp",this.createNode("node_op","op_execfun",this.createNode("node_var","cos"),utils_type.A.deepCopy(r)),this.createNode("node_const",2)));break;case"cot":i=this.createNode("node_op","op_neg",this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_exp",this.createNode("node_op","op_execfun",this.createNode("node_var","sin"),utils_type.A.deepCopy(r)),this.createNode("node_const",2))));break;case"exp":i=this.createNode(t.type,t.value,utils_type.A.deepCopy(t.children[0]),utils_type.A.deepCopy(t.children[1]));break;case"pow":i=this.createNode("node_op","op_mul",this.createNode("node_op","op_execfun",utils_type.A.deepCopy(t.children[0]),utils_type.A.deepCopy(t.children[1])),this.createNode("node_op","op_add",this.createNode("node_op","op_mul",this.derivative(t.children[1][0],e),this.createNode("node_op","op_div",utils_type.A.deepCopy(t.children[1][1]),utils_type.A.deepCopy(t.children[1][0]))),this.createNode("node_op","op_mul",this.derivative(t.children[1][1],e),this.createNode("node_op","op_execfun",this.createNode("node_var","log"),[utils_type.A.deepCopy(t.children[1][0])]))));break;case"log":case"ln":i=this.createNode("node_op","op_div",this.createNode("node_const",1),utils_type.A.deepCopy(r[0]));break;case"log2":case"lb":case"ld":i=this.createNode("node_op","op_mul",this.createNode("node_op","op_div",this.createNode("node_const",1),utils_type.A.deepCopy(r[0])),this.createNode("node_const",1.4426950408889634));break;case"log10":case"lg":i=this.createNode("node_op","op_mul",this.createNode("node_op","op_div",this.createNode("node_const",1),utils_type.A.deepCopy(r[0])),this.createNode("node_const",.43429448190325176));break;case"asin":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_execfun",this.createNode("node_var","sqrt"),[this.createNode("node_op","op_sub",this.createNode("node_const",1),this.createNode("node_op","op_mul",utils_type.A.deepCopy(r[0]),utils_type.A.deepCopy(r[0])))]));break;case"acos":i=this.createNode("node_op","op_neg",this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_execfun",this.createNode("node_var","sqrt"),[this.createNode("node_op","op_sub",this.createNode("node_const",1),this.createNode("node_op","op_mul",utils_type.A.deepCopy(r[0]),utils_type.A.deepCopy(r[0])))])));break;case"atan":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_add",this.createNode("node_const",1),this.createNode("node_op","op_mul",utils_type.A.deepCopy(r[0]),utils_type.A.deepCopy(r[0]))));break;case"acot":i=this.createNode("node_op","op_neg",this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_add",this.createNode("node_const",1),this.createNode("node_op","op_mul",utils_type.A.deepCopy(r[0]),utils_type.A.deepCopy(r[0])))));break;case"sinh":i=this.createNode("node_op","op_execfun",this.createNode("node_var","cosh"),[utils_type.A.deepCopy(r[0])]);break;case"cosh":i=this.createNode("node_op","op_execfun",this.createNode("node_var","sinh"),[utils_type.A.deepCopy(r[0])]);break;case"tanh":i=this.createNode("node_op","op_sub",this.createNode("node_const",1),this.createNode("node_op","op_exp",this.createNode("node_op","op_execfun",this.createNode("node_var","tanh"),[utils_type.A.deepCopy(r[0])]),this.createNode("node_const",2)));break;case"asinh":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_execfun",this.createNode("node_var","sqrt"),[this.createNode("node_op","op_add",this.createNode("node_op","op_mul",utils_type.A.deepCopy(r[0]),utils_type.A.deepCopy(r[0])),this.createNode("node_const",1))]));break;case"acosh":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_execfun",this.createNode("node_var","sqrt"),[this.createNode("node_op","op_sub",this.createNode("node_op","op_mul",utils_type.A.deepCopy(r[0]),utils_type.A.deepCopy(r[0])),this.createNode("node_const",1))]));break;case"atanh":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_sub",this.createNode("node_const",1),this.createNode("node_op","op_mul",utils_type.A.deepCopy(r[0]),utils_type.A.deepCopy(r[0]))));break;default:throw i=this.createNode("node_const",0),console.log('Derivative of "'+s+'" not yet implemented'),new Error("Error("+this.line+"): ")}return i},derivative:function(t,e){var i;switch(t.type){case"node_op":switch(t.value){case"op_execfun":i="pow"==t.children[0].value?this.deriveElementary(t,e):0===t.children[1].length?this.createNode("node_const",0):this.createNode("node_op","op_mul",this.deriveElementary(t,e),this.derivative(t.children[1][0],e));break;case"op_div":i=this.createNode("node_op","op_div",this.createNode("node_op","op_sub",this.createNode("node_op","op_mul",this.derivative(t.children[0],e),utils_type.A.deepCopy(t.children[1])),this.createNode("node_op","op_mul",utils_type.A.deepCopy(t.children[0]),this.derivative(t.children[1],e))),this.createNode("node_op","op_mul",utils_type.A.deepCopy(t.children[1]),utils_type.A.deepCopy(t.children[1])));break;case"op_mul":i=this.createNode("node_op","op_add",this.createNode("node_op","op_mul",utils_type.A.deepCopy(t.children[0]),this.derivative(t.children[1],e)),this.createNode("node_op","op_mul",this.derivative(t.children[0],e),utils_type.A.deepCopy(t.children[1])));break;case"op_neg":i=this.createNode("node_op","op_neg",this.derivative(t.children[0],e));break;case"op_add":case"op_sub":i=this.createNode("node_op",t.value,this.derivative(t.children[0],e),this.derivative(t.children[1],e));break;case"op_exp":i=this.createNode("node_op","op_mul",utils_type.A.deepCopy(t),this.createNode("node_op","op_add",this.createNode("node_op","op_mul",this.derivative(t.children[0],e),this.createNode("node_op","op_div",utils_type.A.deepCopy(t.children[1]),utils_type.A.deepCopy(t.children[0]))),this.createNode("node_op","op_mul",this.derivative(t.children[1],e),this.createNode("node_op","op_execfun",this.createNode("node_var","log"),[utils_type.A.deepCopy(t.children[0])]))))}break;case"node_var":i=t.value===e?this.createNode("node_const",1):this.createNode("node_const",0);break;case"node_const":i=this.createNode("node_const",0)}return i},expandDerivatives:function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_;if(!t)return 0;for(this.line=t.line,this.col=t.col,s=t.children.length,r=0;r<s;++r)if(t.children[r]&&t.children[r].type)t.children[r]=this.expandDerivatives(t.children[r],t,i);else if(utils_type.A.isArray(t.children[r]))for(o=0;o<t.children[r].length;++o)t.children[r][o]&&t.children[r][o].type&&(t.children[r][o]=this.expandDerivatives(t.children[r][o],t,i));if("node_op"===t.type)if("op_execfun"===t.value)if(t.children[0]&&"D"===t.children[0].value){if(_=!1,"node_var"==t.children[1][0].type&&(u=t.children[1][0].value,null!==(n=this.findMapNode(u,i))&&(_=!0)),_?(d=n.children[0],c=t.children[1].length>=2?t.children[1][1].value:n.children[0][0],a=n.children[1]):(a=t.children[1][0],d=["x"],c=t.children[1].length>=2?t.children[1][1].value:"x"),h=a,(p=t.children[1].length>=3?t.children[1][2].value:1)>=1)for(;p>=1;)h=this.derivative(h,c),h=this.removeTrivialNodes(h),p--;l="node_op"==e.type&&"op_assign"==e.value?this.createNode("node_op","op_map",d,h):h,this.setMath(l),t.type=l.type,t.value=l.value,l.children.length>0&&(t.children[0]=l.children[0]),l.children.length>1&&(t.children[1]=l.children[1])}return t},removeTrivialNodes:function(t){var e,i,s,r,o;if(utils_type.A.isArray(t))for(i=t.length,e=0;e<i;++e)t[e]=this.removeTrivialNodes(t[e]);if("node_op"!=t.type||!t.children)return t;for(i=t.children.length,e=0;e<i;++e){this.mayNotBeSimplified=!1;do{t.children[e]=this.removeTrivialNodes(t.children[e])}while(this.mayNotBeSimplified)}switch(t.value){case"op_map":if(s=t.children[0],"node_var"==(r=t.children[1]).type)for(e=0;e<s.length;++e)if(s[e]==r.value){r.isMath=!0;break}break;case"op_add":if(s=t.children[0],r=t.children[1],"node_const"==s.type&&0===s.value)return r;if("node_const"==r.type&&0===r.value)return s;if("node_const"==s.type&&"node_const"==r.type)return s.value+=r.value,s;break;case"op_mul":if(s=t.children[0],r=t.children[1],"node_const"==s.type&&1==s.value)return r;if("node_const"==r.type&&1==r.value)return s;if("node_const"==s.type&&0===s.value)return s;if("node_const"==r.type&&0===r.value)return r;if("node_const"==r.type&&0===r.value)return r;if("node_op"==s.type&&"op_neg"==s.value&&"node_op"==r.type&&"op_neg"==r.value)return t.children=[s.children[0],r.children[0]],this.mayNotBeSimplified=!0,t;if("op_neg"==s.value&&"op_neg"!=r.value)return t.type="node_op",t.value="op_neg",t.children=[this.createNode("node_op","op_mul",s.children[0],r)],this.mayNotBeSimplified=!0,t;if("op_neg"!=s.value&&"op_neg"==r.value)return t.type="node_op",t.value="op_neg",t.children=[this.createNode("node_op","op_mul",s,r.children[0])],this.mayNotBeSimplified=!0,t;if("op_div"==s.value&&"node_const"==s.children[0].type&&1==s.children[0].value)return t.type="node_op",t.value="op_div",t.children=[r,s.children[1]],this.mayNotBeSimplified=!0,t;if("op_div"==r.value&&"node_const"==r.children[0].type&&1==r.children[0].value)return t.type="node_op",t.value="op_div",t.children=[s,r.children[1]],this.mayNotBeSimplified=!0,t;if("node_const"!=s.type&&"node_const"==r.type)return t.children=[r,s],this.mayNotBeSimplified=!0,t;if("node_const"!=s.type&&"node_op"==r.type&&"op_neg"==r.value&&"node_const"==r.children[0].type)return t.children=[r,s],this.mayNotBeSimplified=!0,t;if("node_op"==s.type&&"op_execfun"!=s.value&&("node_var"==r.type||"node_op"==r.type&&"op_execfun"==r.value))return t.children=[r,s],this.mayNotBeSimplified=!0,t;if("node_op"!=s.type&&"node_op"==r.type&&"op_neg"==r.value&&"node_var"==r.children[0].type)return t.children=[r,s],this.mayNotBeSimplified=!0,t;if("node_const"!=s.type&&"node_op"==r.type&&("op_mul"==r.value||"op_div"==r.value)&&"node_const"==r.children[0].type)return o=r.children[0],r.children[0]=s,t.children=[o,r],this.mayNotBeSimplified=!0,t;if("node_const"!=r.type&&"node_op"==s.type&&"op_mul"==s.value&&"node_const"==s.children[0].type)return t.children=[s.children[0],this.createNode("node_op","op_mul",s.children[1],r)],this.mayNotBeSimplified=!0,t;if("node_const"==s.type&&"node_const"==r.type)return s.value*=r.value,s;if("node_const"==s.type&&"node_op"==r.type&&("op_mul"==r.value||"op_div"==r.value)&&"node_const"==r.children[0].type)return r.children[0].value*=s.value,r;if(s.hash=this.parser.compile(s),r.hash=this.parser.compile(r),s.hash===r.hash)return t.value="op_exp",t.children[1]=this.createNode("node_const",2),t;if("node_const"==s.type&&"node_op"==r.type&&("op_mul"==r.value||"op_div"==r.value)&&"node_const"==r.children[0].type)return r.children[0].value*=s.value,r;if("node_op"==r.type&&"op_exp"==r.value&&(s.hash||(s.hash=this.parser.compile(s)),r.children[0].hash||(r.children[0].hash=this.parser.compile(r.children[0])),s.hash===r.children[0].hash))return r.children[1]=this.createNode("node_op","op_add",r.children[1],this.createNode("node_const",1)),this.mayNotBeSimplified=!0,r;if("node_op"==s.type&&"op_exp"==s.value&&"node_op"==r.type&&"op_exp"==r.value&&(s.children[0].hash=this.parser.compile(s.children[0]),r.children[0].hash=this.parser.compile(r.children[0]),s.children[0].hash===r.children[0].hash))return s.children[1]=this.createNode("node_op","op_add",s.children[1],r.children[1]),this.mayNotBeSimplified=!0,s;break;case"op_sub":if(s=t.children[0],r=t.children[1],"node_const"==s.type&&0===s.value)return t.value="op_neg",t.children[0]=r,t;if("node_const"==r.type&&0===r.value)return s;if("node_const"==s.type&&"node_const"==r.type&&s.value==r.value)return this.createNode("node_const",0);if("node_var"==s.type&&"node_var"==r.type&&s.value==r.value)return this.createNode("node_const",0);if("node_const"==s.type&&"node_const"==r.type)return s.value-=r.value,s;if("node_op"==s.type&&"op_mul"==s.value&&"node_op"==r.type&&"op_mul"==r.value&&(s.children[1].hash=this.parser.compile(s.children[1]),r.children[1].hash=this.parser.compile(r.children[1]),s.children[1].hash===r.children[1].hash))return t.value="op_mul",t.children=[this.createNode("node_op","op_sub",s.children[0],r.children[0]),s.children[1]],this.mayNotBeSimplified=!0,t;if("node_op"==s.type&&"op_mul"==s.value&&(s.children[1].hash=this.parser.compile(s.children[1]),r.hash=this.parser.compile(r),s.children[1].hash===r.hash))return t.value="op_mul",t.children=[this.createNode("node_op","op_sub",s.children[0],this.createNode("node_const",1)),r],this.mayNotBeSimplified=!0,t;if("node_op"==r.type&&"op_mul"==r.value&&(r.children[1].hash=this.parser.compile(r.children[1]),s.hash=this.parser.compile(s),r.children[1].hash===s.hash))return t.value="op_mul",t.children=[this.createNode("node_op","op_sub",this.createNode("node_const",1),r.children[0]),s],this.mayNotBeSimplified=!0,t;break;case"op_neg":if("node_const"==(s=t.children[0]).type&&0===s.value)return s;if("node_op"==s.type&&"op_neg"==s.value)return s.children[0];break;case"op_div":if(s=t.children[0],r=t.children[1],"node_const"==s.type&&"node_const"==r.type&&s.value==r.value&&0!==s.value)return s.value=1,s;if("node_const"==s.type&&0===s.value&&"node_const"==r.type&&0!==r.value)return s.value=0,s;if("node_const"==s.type&&0===s.value&&("node_op"==r.type||"node_var"==r.type))return t.type="node_const",t.value=0,t;if("node_var"==s.type&&"node_var"==r.type&&s.value==r.value)return this.createNode("node_const",1);if("node_const"==s.type&&0!==s.value&&"node_const"==r.type&&0===r.value)return s.value>0?s.value=1/0:s.value=-1/0,s;if("node_op"==s.type&&"op_neg"==s.value&&"node_op"==r.type&&"op_neg"==r.value)return t.children=[s.children[0],r.children[0]],this.mayNotBeSimplified=!0,t;if("op_neg"==s.value&&"op_neg"!=r.value)return t.type="node_op",t.value="op_neg",t.children=[this.createNode("node_op","op_div",s.children[0],r)],this.mayNotBeSimplified=!0,t;if("op_neg"!=s.value&&"op_neg"==r.value)return t.type="node_op",t.value="op_neg",t.children=[this.createNode("node_op","op_div",s,r.children[0])],this.mayNotBeSimplified=!0,t;if("node_op"==s.type&&"op_exp"==s.value&&(r.hash||(r.hash=this.parser.compile(r)),s.children[0].hash||(s.children[0].hash=this.parser.compile(s.children[0])),r.hash===s.children[0].hash))return s.children[1]=this.createNode("node_op","op_sub",s.children[1],this.createNode("node_const",1)),this.mayNotBeSimplified=!0,s;if("node_const"!=r.type&&"node_op"==s.type&&"op_mul"==s.value&&"node_const"==s.children[0].type)return t.value="op_mul",t.children=[s.children[0],this.createNode("node_op","op_div",s.children[1],r)],this.mayNotBeSimplified=!0,t;if("node_op"==s.type&&"op_exp"==s.value&&"node_op"==r.type&&"op_exp"==r.value&&(s.children[0].hash=this.parser.compile(s.children[0]),r.children[0].hash=this.parser.compile(r.children[0]),s.children[0].hash===r.children[0].hash))return s.children[1]=this.createNode("node_op","op_sub",s.children[1],r.children[1]),this.mayNotBeSimplified=!0,s;break;case"op_exp":if(s=t.children[0],"node_const"==(r=t.children[1]).type&&0===r.value)return r.value=1,r;if("node_const"==r.type&&1==r.value)return s;if("node_const"==s.type&&1==s.value)return s;if("node_const"==s.type&&0===s.value&&"node_const"==r.type&&0!==r.value)return s;if("node_op"==s.type&&"op_exp"==s.value)return t.children=[s.children[0],this.createNode("node_op","op_mul",s.children[1],r)],t}switch(t.value){case"op_add":if(s=t.children[0],r=t.children[1],"node_const"==s.type&&"node_const"==r.type&&s.value==r.value)return s.value+=r.value,s;if("node_var"==s.type&&"node_var"==r.type&&s.value==r.value)return t.children[0]=this.createNode("node_const",2),t.value="op_mul",t;if("node_op"==s.type&&"op_neg"==s.value)return t.value="op_sub",t.children[0]=r,t.children[1]=s.children[0],this.mayNotBeSimplified=!0,t;if("node_op"==r.type&&"op_neg"==r.value)return t.value="op_sub",t.children[1]=r.children[0],this.mayNotBeSimplified=!0,t;if("node_op"==s.type&&"op_mul"==s.value&&"node_op"==r.type&&"op_mul"==r.value&&(s.children[1].hash=this.parser.compile(s.children[1]),r.children[1].hash=this.parser.compile(r.children[1]),s.children[1].hash===r.children[1].hash))return t.value="op_mul",t.children=[this.createNode("node_op","op_add",s.children[0],r.children[0]),s.children[1]],this.mayNotBeSimplified=!0,t;if("node_op"==s.type&&"op_mul"==s.value&&(s.children[1].hash=this.parser.compile(s.children[1]),r.hash=this.parser.compile(r),s.children[1].hash===r.hash))return t.value="op_mul",t.children=[this.createNode("node_op","op_add",s.children[0],this.createNode("node_const",1)),r],this.mayNotBeSimplified=!0,t;if("node_op"==r.type&&"op_mul"==r.value&&(r.children[1].hash=this.parser.compile(r.children[1]),s.hash=this.parser.compile(s),r.children[1].hash===s.hash))return t.value="op_mul",t.children=[this.createNode("node_op","op_add",this.createNode("node_const",1),r.children[0]),s],this.mayNotBeSimplified=!0,t;break;case"op_sub":if(s=t.children[0],"node_op"==(r=t.children[1]).type&&"op_neg"==r.value)return t.value="op_add",t.children[1]=r.children[0],this.mayNotBeSimplified=!0,t;break;case"op_execfun":return this.simplifyElementary(t)}return t},simplifyElementary:function(t){var e=t.children[0].value,i=t.children[1];if(0==i.length)return t;switch(e){case"sin":case"tan":if("node_const"==i[0].type&&0===i[0].value)return t.type="node_const",t.value=0,t;if("node_var"==i[0].type&&"PI"==i[0].value)return t.type="node_const",t.value=0,t;if("node_op"==i[0].type&&"op_mul"==i[0].value&&"node_const"==i[0].children[0].type&&i[0].children[0].value%1==0&&"node_var"==i[0].children[1].type&&"PI"==i[0].children[1].value)return t.type="node_const",t.value=0,t;break;case"cos":if("node_const"==i[0].type&&0===i[0].value)return t.type="node_const",t.value=1,t;if("node_var"==i[0].type&&"PI"==i[0].value)return t.type="node_op",t.value="op_neg",t.children=[this.createNode("node_const",1)],t;break;case"exp":if("node_const"==i[0].type&&0===i[0].value)return t.type="node_const",t.value=1,t;break;case"pow":if("node_const"==i[1].type&&0===i[1].value)return t.type="node_const",t.value=1,t}return t}});var ca=jxg.A.CA;jxg.A.Dump={addMarkers:function(t,e,i){var s,r,o;for(s in utils_type.A.isArray(e)||(e=[e]),utils_type.A.isArray(i)||(i=[i]),r=Math.min(e.length,i.length),e.length=r,i.length=r,t.objects)if(t.objects.hasOwnProperty(s))for(o=0;o<r;o++)t.objects[s][e[o]]=i[o]},deleteMarkers:function(t,e){var i,s,r;for(i in utils_type.A.isArray(e)||(e=[e]),s=e.length,e.length=s,t.objects)if(t.objects.hasOwnProperty(i))for(r=0;r<s;r++)delete t.objects[i][e[r]]},str:function(t){return"string"==typeof t&&"function"!==t.slice(0,7)&&(t='"'+t+'"'),t},minimizeObject:function(t,e){var i,s,r,o={},n=utils_type.A.deepCopy(t),a=[];for(r=1;r<arguments.length;r++)a.push(arguments[r]);for(o=utils_type.A.deepCopy(o,jxg.A.Options.elements,!0),r=a.length;r>0;r--)o=utils_type.A.deepCopy(o,a[r-1],!0);for(i in o)o.hasOwnProperty(i)&&(s=i.toLowerCase(),"object"!=typeof o[i]&&o[i]===n[s]&&delete n[s]);return n},prepareAttributes:function(t,e){var i,s;for(s in i=this.minimizeObject(e.getAttributes(),jxg.A.Options[e.elType]),e.subs)e.subs.hasOwnProperty(s)&&(i[s]=this.minimizeObject(e.subs[s].getAttributes(),jxg.A.Options[e.elType][s],jxg.A.Options[e.subs[s].elType]),i[s].id=e.subs[s].id,i[s].name=e.subs[s].name);return i.id=e.id,i.name=e.name,i},setBoundingBox:function(t,e,i){return t.push({obj:i,method:"setBoundingBox",params:[e.getBoundingBox(),e.keepaspectratio]}),t},dump:function(t){var e,i,s,r,o=[],n=[],a=t.objectsList.length;for(this.addMarkers(t,"dumped",!1),e=0;e<a;e++)if(s={},!(i=t.objectsList[e]).dumped&&i.dump){for(s.type=i.getType(),s.parents=i.getParents().slice(),"point"===s.type&&1===s.parents[0]&&(s.parents=s.parents.slice(1)),r=0;r<s.parents.length;r++)utils_type.A.isString(s.parents[r])&&"'"!==s.parents[r][0]&&'"'!==s.parents[r][0]?s.parents[r]='"'+s.parents[r]+'"':utils_type.A.isArray(s.parents[r])&&(s.parents[r]="["+s.parents[r].toString()+"]");s.attributes=this.prepareAttributes(t,i),"glider"===s.type&&i.onPolygon&&o.push({obj:i.id,prop:"onPolygon",val:!0}),n.push(s)}return this.deleteMarkers(t,"dumped"),{elements:n,props:o,methods:[]}},arrayToParamStr:function(t,e){var i,s=[];for(i=0;i<t.length;i++)s.push(e.call(this,t[i]));return s.join(", ")},toJCAN:function(t){var e,i,s;switch(typeof t){case"object":if(t){if(i=[],utils_type.A.isArray(t)){for(e=0;e<t.length;e++)i.push(this.toJCAN(t[e]));return"["+i.join(",")+"]"}for(s in t)t.hasOwnProperty(s)&&i.push(s+": "+this.toJCAN(t[s]));return"<<"+i.join(", ")+">> "}return"null";case"string":return"'"+t.replace(/\\/g,"\\\\").replace(/(["'])/g,"\\$1")+"'";case"number":case"boolean":return t.toString();case"null":return"null"}},toJessie:function(t){var e,i,s,r=this.dump(t),o=[];for(r.methods=this.setBoundingBox(r.methods,t,"$board"),i=r.elements,e=0;e<i.length;e++)i[e].attributes.name.length>0&&o.push("// "+i[e].attributes.name),o.push("s"+e+" = "+i[e].type+"("+i[e].parents.join(", ")+") "+this.toJCAN(i[e].attributes).replace(/\n/,"\\n")+";"),"axis"===i[e].type&&(s=i[e].attributes.id,null===t.objects[s].defaultTicks&&o.push("s"+e+".removeAllTicks();")),o.push("");for(e=0;e<r.methods.length;e++)o.push(r.methods[e].obj+"."+r.methods[e].method+"("+this.arrayToParamStr(r.methods[e].params,this.toJCAN)+");"),o.push("");for(e=0;e<r.props.length;e++)o.push(r.props[e].obj+"."+r.props[e].prop+" = "+this.toJCAN(r.props[e].val)+";"),o.push("");return o.join("\n")},toJavaScript:function(t){var e,i,s,r=this.dump(t),o=[];for(r.methods=this.setBoundingBox(r.methods,t,"board"),i=r.elements,e=0;e<i.length;e++)o.push('board.create("'+i[e].type+'", ['+i[e].parents.join(", ")+"], "+utils_type.A.toJSON(i[e].attributes)+");"),"axis"===i[e].type&&(s=i[e].attributes.id,null===t.objects[s].defaultTicks&&o.push('board.objects["'+s+'"].removeTicks(board.objects["'+s+'"].defaultTicks);'));for(e=0;e<r.methods.length;e++)o.push(r.methods[e].obj+"."+r.methods[e].method+"("+this.arrayToParamStr(r.methods[e].params,utils_type.A.toJSON)+");"),o.push("");for(e=0;e<r.props.length;e++)o.push(r.props[e].obj+"."+r.props[e].prop+" = "+utils_type.A.toJSON(r.props[e].val)+";"),o.push("");return o.join("\n")}};var dump=jxg.A.Dump;jxg.A.createComb=function(t,e,i){var s,r,o,n,a;if(2!==e.length)throw a=e.map((function(t){return"'"+typeof t+"'"})),new Error("JSXGraph: Can't create comb with parent types "+a.join(", ")+".\nPossible parent types: [point,point], [[x1,y1],[x2,y2]]");if(utils_type.A.isArray(e[0])&&e[0].length>1)n=utils_type.A.copyAttributes(i,t.options,"comb","point1"),s=t.create("point",e[0],n);else if(utils_type.A.isString(e[0])||utils_type.A.isPoint(e[0]))s=t.select(e[0]);else if(utils_type.A.isFunction(e[0])&&utils_type.A.isPoint(e[0]()))s=e[0]();else{if(!(utils_type.A.isFunction(e[0])&&e[0]().length&&e[0]().length>=2))throw new Error("JSXGraph: Can't create comb with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]]");n=utils_type.A.copyAttributes(i,t.options,"comb","point1"),s=jxg.A.createPoint(t,e[0](),n)}if(utils_type.A.isArray(e[1])&&e[1].length>1)n=utils_type.A.copyAttributes(i,t.options,"comb","point2"),r=t.create("point",e[1],n);else if(utils_type.A.isString(e[1])||utils_type.A.isPoint(e[1]))r=t.select(e[1]);else if(utils_type.A.isFunction(e[1])&&utils_type.A.isPoint(e[1]()))r=e[1]();else{if(!(utils_type.A.isFunction(e[1])&&e[1]().length&&e[1]().length>=2))throw new Error("JSXGraph: Can't create comb with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]]");n=utils_type.A.copyAttributes(i,t.options,"comb","point2"),r=jxg.A.createPoint(t,e[1](),n)}return n=utils_type.A.copyAttributes(i,t.options,"comb"),(o=t.create("curve",[[0],[0]],n)).updateDataArray=function(){var t,e,i,n,a,l,h,u,c,d,p=0,_=s.Dist(r),f=s,A=r;for(u=utils_type.A.evaluate(o.visProp.frequency),c=-utils_type.A.evaluate(o.visProp.angle),d=utils_type.A.evaluate(o.visProp.width),utils_type.A.evaluate(o.visProp.reverse)&&(f=r,A=s,c=-c),t=Math.cos(c),e=Math.sin(c),i=(A.X()-f.X())/_,n=(A.Y()-f.Y())/_,t*=d/Math.abs(e),e*=d/Math.abs(e),this.dataX=[],this.dataY=[];p<_;)a=f.X()+i*p,l=f.Y()+n*p,e*=h=Math.min(t,_-p)/Math.abs(t),t*=h,this.dataX.push(a),this.dataY.push(l),this.dataX.push(a+i*t+n*e),this.dataY.push(l-i*e+n*t),this.dataX.push(NaN),this.dataY.push(NaN),p+=u},o},jxg.A.registerElement("comb",jxg.A.createComb);var priv={removeSlopeTriangle:function(){polygon.prototype.remove.call(this),this.board.removeObject(this.toppoint),this.board.removeObject(this.glider),this.board.removeObject(this.baseline),this.board.removeObject(this.basepoint),this.board.removeObject(this.label),this._isPrivateTangent&&this.board.removeObject(this.tangent)},Value:function(){return this.tangent.getSlope()},Direction:function(){return this.tangent.Direction()}};jxg.A.createSlopeTriangle=function(t,e,i){var s,r,o,n,a,l,h,u,c,d=!1;if(1===e.length&&e[0].type===constants.A.OBJECT_TYPE_TANGENT)r=e[0],o=r.glider;else if(1===e.length&&e[0].type===constants.A.OBJECT_TYPE_GLIDER)o=e[0],c=utils_type.A.copyAttributes(i,t.options,"slopetriangle","tangent"),r=t.create("tangent",[o],c),d=!0;else{if(2!==e.length||e[0].elementClass!==constants.A.OBJECT_CLASS_LINE||!utils_type.A.isPoint(e[1]))throw new Error("JSXGraph: Can't create slope triangle with parent types '"+typeof e[0]+"'.");r=e[0],o=e[1]}return c=utils_type.A.copyAttributes(i,t.options,"slopetriangle","basepoint"),h=t.create("point",[function(){return[o.X()+1,o.Y()]}],c),c=utils_type.A.copyAttributes(i,t.options,"slopetriangle","baseline"),l=t.create("line",[o,h],c),c=utils_type.A.copyAttributes(i,t.options,"slopetriangle","glider"),n=t.create("glider",[o.X()+1,o.Y(),l],c),c=utils_type.A.copyAttributes(i,t.options,"slopetriangle","toppoint"),a=t.create("point",[function(){return[n.X(),n.Y()+(n.X()-o.X())*r.getSlope()]}],c),c=utils_type.A.copyAttributes(i,t.options,"slopetriangle"),(s=t.create("polygon",[o,n,a],c)).Value=priv.Value,s.Direction=priv.Direction,s.tangent=r,s._isPrivateTangent=d,s.borders[2].setArrow(!1,!1),c=utils_type.A.copyAttributes(i,t.options,"slopetriangle","label"),(c=utils_type.A.copyAttributes(c,t.options,"label")).isLabel=!0,c.anchor=s.borders[1],c.priv=s.borders[1].visProp.priv,c.id=s.borders[1].id+"Label",(u=t.create("text",[0,0,function(){return""}],c)).needsUpdate=!0,u.dump=!1,s.borders[1].label=u,s.borders[1].hasLabel=!0,s.borders[1].visProp.withlabel=!0,u._setText((function(){var t=utils_type.A.evaluate(u.visProp.digits);return u.useLocale()?u.formatNumberLocale(s.Value(),t):utils_type.A.toFixed(s.Value(),t)})),u.fullUpdate(),s.glider=n,s.basepoint=h,s.baseline=l,s.toppoint=a,s.label=u,s.subs={glider:n,basePoint:h,baseLine:l,topPoint:a,label:u},s.inherits.push(n,h,l,a,u),s.methodMap=jxg.A.deepCopy(s.methodMap,{tangent:"tangent",glider:"glider",basepoint:"basepoint",baseline:"baseline",toppoint:"toppoint",label:"label",Value:"Value",V:"Value",Direction:"Direction"}),s.remove=priv.removeSlopeTriangle,s},jxg.A.registerElement("slopetriangle",jxg.A.createSlopeTriangle);var checkbox_priv={CheckboxChangeEventHandler:function(){this._value=this.rendNodeCheckbox.checked,this.board.update()}};jxg.A.createCheckbox=function(t,e,i){var s,r,o=utils_type.A.copyAttributes(i,t.options,"checkbox");return r=[e[0],e[1],'<span style="display:inline"><input type="checkbox" /><label for=""></label></span>'],(s=t.create("text",r,o)).type=utils_type.A.OBJECT_TYPE_CHECKBOX,s.rendNodeCheckbox=s.rendNode.childNodes[0].childNodes[0],s.rendNodeLabel=s.rendNode.childNodes[0].childNodes[1],s.rendNodeTag=s.rendNodeCheckbox,s.rendNodeTag.disabled=!!o.disabled,s.rendNodeCheckbox.id=s.rendNode.id+"_checkbox",s.rendNodeLabel.id=s.rendNode.id+"_label",s.rendNodeLabel.setAttribute("for",s.rendNodeCheckbox.id),s.setText(e[2]),s.visPropOld.fontsize="0px",t.renderer.updateTextStyle(s,!1),s.rendNodeCheckbox.checked=o.checked,s._value=o.checked,s.Value=function(){return this._value},s.update=function(){return this.needsUpdate&&(jxg.A.Text.prototype.update.call(this),this._value=this.rendNodeCheckbox.checked),this},env.A.addEvent(s.rendNodeCheckbox,"change",checkbox_priv.CheckboxChangeEventHandler,s),s},jxg.A.registerElement("checkbox",jxg.A.createCheckbox);var input_priv={InputInputEventHandler:function(t){this._value=this.rendNodeInput.value,this.board.update()}};jxg.A.createInput=function(t,e,i){var s,r,o=utils_type.A.copyAttributes(i,t.options,"input");return r=[e[0],e[1],'<span style="display:inline; white-space:nowrap; padding:0px;"><span></span><input type="text" maxlength="'+o.maxlength+'" style="width:100%"/></span>'],(s=t.create("text",r,o)).type=utils_type.A.OBJECT_TYPE_INPUT,s.rendNodeLabel=s.rendNode.childNodes[0].childNodes[0],s.rendNodeInput=s.rendNode.childNodes[0].childNodes[1],s.rendNodeInput.value=e[2],s.rendNodeTag=s.rendNodeInput,s.rendNodeTag.disabled=!!o.disabled,s.rendNodeLabel.id=s.rendNode.id+"_label",s.rendNodeInput.id=s.rendNode.id+"_input",s.setText(e[3]),s._value=e[2],s.update=function(){return this.needsUpdate&&(jxg.A.Text.prototype.update.call(this),this._value=this.rendNodeInput.value),this},s.Value=function(){return this._value},s.set=function(t){return this._value=t,this.rendNodeInput.value=t,this},env.A.addEvent(s.rendNodeInput,"input",input_priv.InputInputEventHandler,s),env.A.addEvent(s.rendNodeInput,"mousedown",(function(t){utils_type.A.exists(t.stopPropagation)&&t.stopPropagation()}),s),env.A.addEvent(s.rendNodeInput,"touchstart",(function(t){utils_type.A.exists(t.stopPropagation)&&t.stopPropagation()}),s),env.A.addEvent(s.rendNodeInput,"pointerdown",(function(t){utils_type.A.exists(t.stopPropagation)&&t.stopPropagation()}),s),s.visPropOld.fontsize="0px",t.renderer.updateTextStyle(s,!1),s},jxg.A.registerElement("input",jxg.A.createInput);var button_priv={ButtonClickEventHandler:function(){this._handler&&this._handler(),this.board.update()}};jxg.A.createButton=function(t,e,i){var s,r,o=utils_type.A.copyAttributes(i,t.options,"button");return r=[e[0],e[1],'<button type="button" style="width:100%;"></button>'],(s=t.create("text",r,o)).type=utils_type.A.OBJECT_TYPE_BUTTON,s.rendNodeButton=s.rendNode.childNodes[0],s.rendNodeButton.id=s.rendNode.id+"_button",s.rendNodeTag=s.rendNodeButton,s.rendNodeTag.disabled=!!o.disabled,s.setText(e[2]),s.visPropOld.fontsize="0px",t.renderer.updateTextStyle(s,!1),e[3]&&(utils_type.A.isString(e[3])?(s._jc=new jxg.A.JessieCode,s._jc.use(t),s._handler=function(){s._jc.parse(e[3])}):s._handler=e[3]),env.A.addEvent(s.rendNodeButton,"click",button_priv.ButtonClickEventHandler,s),env.A.addEvent(s.rendNodeButton,"mousedown",(function(t){utils_type.A.exists(t.stopPropagation)&&t.stopPropagation()}),s),env.A.addEvent(s.rendNodeButton,"touchstart",(function(t){utils_type.A.exists(t.stopPropagation)&&t.stopPropagation()}),s),env.A.addEvent(s.rendNodeButton,"pointerdown",(function(t){utils_type.A.exists(t.stopPropagation)&&t.stopPropagation()}),s),s},jxg.A.registerElement("button",jxg.A.createButton),jxg.A.createVectorField=function(t,e,i){var s,r;if(!(e.length>=3&&(utils_type.A.isArray(e[0])||utils_type.A.isFunction(e[0])||utils_type.A.isString(e[0]))&&utils_type.A.isArray(e[1])&&3===e[1].length&&utils_type.A.isArray(e[2])&&3===e[2].length))throw new Error("JSXGraph: Can't create vector field with parent types '"+typeof e[0]+"', '"+typeof e[1]+"', '"+typeof e[2]+"'.");return r=utils_type.A.copyAttributes(i,t.options,"vectorfield"),(s=t.create("curve",[[],[]],r)).elType="vectorfield",s.setF=function(t,e){var i,r;return utils_type.A.isArray(t)?(i=utils_type.A.createFunction(t[0],this.board,e),r=utils_type.A.createFunction(t[1],this.board,e),this.F=function(t,e){return[i(t,e),r(t,e)]}):this.F=utils_type.A.createFunction(t,s.board,e),this},s.setF(e[0],"x, y"),s.xData=e[1],s.yData=e[2],s.updateDataArray=function(){var e,i,s,r,o,n,a,l,h,u,c,d,p=utils_type.A.evaluate(this.visProp.scale),_=utils_type.A.evaluate(this.xData[0]),f=utils_type.A.evaluate(this.xData[1]),A=(utils_type.A.evaluate(this.xData[2])-_)/f,g=utils_type.A.evaluate(this.yData[0]),m=utils_type.A.evaluate(this.yData[1]),y=(utils_type.A.evaluate(this.yData[2])-g)/m,b=utils_type.A.evaluate(this.visProp.arrowhead.enabled);for(b&&(u=(h=utils_type.A.evaluate(this.visProp.arrowhead.size))/t.unitX,c=h/t.unitY,d=utils_type.A.evaluate(this.visProp.arrowhead.angle)),this.dataX=[],this.dataY=[],s=0,e=_;s<=f;e+=A,s++)for(r=0,i=g;r<=m;i+=y,r++)(o=this.F(e,i))[0]*=p,o[1]*=p,utils_type.A.concat(this.dataX,[e,e+o[0],NaN]),utils_type.A.concat(this.dataY,[i,i+o[1],NaN]),b&&Math.abs(o[0])+Math.abs(o[1])>0&&(a=(n=Math.atan2(o[1],o[0]))+d,l=n-d,utils_type.A.concat(this.dataX,[e+o[0]-Math.cos(a)*u,e+o[0],e+o[0]-Math.cos(l)*u,NaN]),utils_type.A.concat(this.dataY,[i+o[1]-Math.sin(a)*c,i+o[1],i+o[1]-Math.sin(l)*c,NaN]))},s.methodMap=utils_type.A.deepCopy(s.methodMap,{setF:"setF"}),s},jxg.A.registerElement("vectorfield",jxg.A.createVectorField),jxg.A.createSlopeField=function(t,e,i){var s,r,o;if(!(e.length>=3&&(utils_type.A.isFunction(e[0])||utils_type.A.isString(e[0]))&&utils_type.A.isArray(e[1])&&3===e[1].length&&utils_type.A.isArray(e[2])&&3===e[2].length))throw new Error("JSXGraph: Can't create slope field with parent types '"+typeof e[0]+"', '"+typeof e[1]+"', '"+typeof e[2]+"'.");return r=utils_type.A.createFunction(e[0],t,"x, y"),e[0]=function(t,e){var i=r(t,e),s=Math.sqrt(1+i*i);return[1/s,i/s]},o=utils_type.A.copyAttributes(i,t.options,"slopefield"),(s=t.create("vectorfield",e,o)).elType="slopefield",s.setF=function(t,e){var i=utils_type.A.createFunction(t,s.board,e);this.F=function(t,e){var s=i(t,e),r=Math.sqrt(1+s*s);return[1/r,s/r]}},s.methodMap=utils_type.A.deepCopy(s.methodMap,{setF:"setF"}),s},jxg.A.registerElement("slopefield",jxg.A.createSlopeField),jxg.A.createSmartLabel=function(t,e,i){var s,r,o,n,a,l;if(0===e.length||[constants.A.OBJECT_CLASS_POINT,constants.A.OBJECT_CLASS_LINE,constants.A.OBJECT_CLASS_CIRCLE].indexOf(e[0].elementClass)<0&&[constants.A.OBJECT_TYPE_POLYGON,constants.A.OBJECT_TYPE_ANGLE].indexOf(e[0].type)<0)throw new Error("JSXGraph: Can't create smartlabel with parent types '"+typeof e[0]+"', '"+typeof e[1]+"'.");return o=e[0],n=e[1]||"",o.elementClass===constants.A.OBJECT_CLASS_POINT?r=utils_type.A.copyAttributes(i,t.options,"smartlabelpoint"):o.elementClass===constants.A.OBJECT_CLASS_LINE?((r=utils_type.A.copyAttributes(i,t.options,"smartlabelline")).rotate=function(){return 180*Math.atan(o.getSlope())/Math.PI},r.visible=function(){return!(o.L()<1.5)}):o.elementClass===constants.A.OBJECT_CLASS_CIRCLE?(r=utils_type.A.copyAttributes(i,t.options,"smartlabelcircle")).visible=function(){return!(o.Radius()<1.5)}:o.type===constants.A.OBJECT_TYPE_POLYGON?r=utils_type.A.copyAttributes(i,t.options,"smartlabelpolygon"):o.type===constants.A.OBJECT_TYPE_ANGLE&&((r=utils_type.A.copyAttributes(i,t.options,"smartlabelangle")).rotate=function(){var t=o.center.coords.usrCoords,e=o.getLabelAnchor().usrCoords,i=180*Math.atan2(e[2]-t[2],e[1]-t[1])/Math.PI;return i>90&&i<270?i+180:i},r.anchorX=function(){var t=o.center.coords.usrCoords,e=o.getLabelAnchor().usrCoords,i=180*Math.atan2(e[2]-t[2],e[1]-t[1])/Math.PI;return i>90&&i<270?"right":"left"}),a=function(t,e,i,s){var r;switch(s){case"length":r=function(){return e.L()};break;case"slope":r=function(){return e.Slope()};break;case"area":r=function(){return e.Area()};break;case"radius":r=function(){return e.Radius()};break;case"perimeter":r=function(){return e.Perimeter()};break;case"rad":r=function(){return e.Value()};break;case"deg":r=function(){return 180*e.Value()/Math.PI};break;default:r=function(){return 0}}return function(){var e,i="",s=utils_type.A.evaluate(n),o=utils_type.A.evaluate(t.visProp.digits),a=utils_type.A.evaluate(t.visProp.unit),l=utils_type.A.evaluate(t.visProp.prefix),h=utils_type.A.evaluate(t.visProp.suffix),u=utils_type.A.evaluate(t.visProp.usemathjax)||utils_type.A.evaluate(t.visProp.usekatex);return""===s?(e=t.useLocale()?t.formatNumberLocale(r(),o):utils_type.A.toFixed(r(),o),i=u?["\\(",l,e,"\\,",a,h,"\\)"].join(""):[l,e,a,h].join("")):i=s,i}},o.elementClass===constants.A.OBJECT_CLASS_POINT?(s=t.create("text",[function(){return o.X()},function(){return o.Y()},""],r),l=function(){var t,e,i="",r=utils_type.A.evaluate(n),a=utils_type.A.evaluate(s.visProp.digits),l=utils_type.A.evaluate(s.visProp.unit),h=utils_type.A.evaluate(s.visProp.prefix),u=utils_type.A.evaluate(s.visProp.suffix),c=utils_type.A.evaluate(s.visProp.dir),d=utils_type.A.evaluate(s.visProp.usemathjax)||utils_type.A.evaluate(s.visProp.usekatex);return s.useLocale()?(t=s.formatNumberLocale(o.X(),a),e=s.formatNumberLocale(o.Y(),a)):(t=utils_type.A.toFixed(o.X(),a),e=utils_type.A.toFixed(o.Y(),a)),""===r?"row"===c?i=d?["\\(",h,t,"\\,",l," / ",e,"\\,",l,u,"\\)"].join(""):[h,t," ",l," / ",e," ",l,u].join(""):0===c.indexOf("col")&&(i=d?["\\(",h,"\\left(\\array{",t,"\\,",l,"\\\\ ",e,"\\,",l,"}\\right)",u,"\\)"].join(""):[h,t," ",l,"<br/>",e," ",l,u].join("")):i=r,i}):o.elementClass===constants.A.OBJECT_CLASS_LINE?"length"===r.measure?l=a(s=t.create("text",[function(){return.5*(o.point1.X()+o.point2.X())},function(){return.5*(o.point1.Y()+o.point2.Y())},""],r),o,0,"length"):"slope"===r.measure&&(l=a(s=t.create("text",[function(){return.25*o.point1.X()+.75*o.point2.X()},function(){return.25*o.point1.Y()+.75*o.point2.Y()},""],r),o,0,"slope")):o.elementClass===constants.A.OBJECT_CLASS_CIRCLE?"radius"===r.measure?l=a(s=t.create("text",[function(){return o.center.X()+.5*o.Radius()},function(){return o.center.Y()},""],r),o,0,"radius"):"area"===r.measure?l=a(s=t.create("text",[function(){return o.center.X()},function(){return o.center.Y()+.5*o.Radius()},""],r),o,0,"area"):"circumference"!==r.measure&&"perimeter"!==r.measure||(l=a(s=t.create("text",[function(){return o.getLabelAnchor()},""],r),o,0,"perimeter")):o.type===constants.A.OBJECT_TYPE_POLYGON?"area"===r.measure?l=a(s=t.create("text",[function(){return o.getTextAnchor()},""],r),o,0,"area"):"perimeter"===r.measure&&(l=a(s=t.create("text",[function(){var t=o.borders.length-1;return t>=0?[.5*(o.borders[t].point1.X()+o.borders[t].point2.X()),.5*(o.borders[t].point1.Y()+o.borders[t].point2.Y())]:o.getTextAnchor()},""],r),o,0,"perimeter")):o.type===constants.A.OBJECT_TYPE_ANGLE&&(l=a(s=t.create("text",[function(){return o.getLabelAnchor()},""],r),o,0,r.measure)),utils_type.A.exists(s)&&(s.setText(l),o.addChild(s),s.setParents([o])),s},jxg.A.registerElement("smartlabel",jxg.A.createSmartLabel),jxg.A.ForeignObject=function(t,e,i,s,r){this.constructor(t,i,constants.A.OBJECT_TYPE_FOREIGNOBJECT,constants.A.OBJECT_CLASS_OTHER),this.element=this.board.select(i.anchor),this.coordsConstructor(e),this._useUserSize=!1,this.size=[1,1],utils_type.A.exists(r)&&r.length>0&&(this._useUserSize=!0,this.W=utils_type.A.createFunction(r[0],this.board,""),this.H=utils_type.A.createFunction(r[1],this.board,""),this.addParentsFromJCFunctions([this.W,this.H]),this.usrSize=[this.W(),this.H()]),this.content=s,this.elType="foreignobject",this.id=this.board.setId(this,"Im"),this.board.renderer.drawForeignObject(this),this.board.finalizeAdding(this),this.methodMap=jxg.A.deepCopy(this.methodMap,{addTransformation:"addTransform",trans:"addTransform",W:"W",Width:"W",H:"H",Height:"H"})},jxg.A.ForeignObject.prototype=new base_element.A,utils_type.A.copyPrototypeMethods(jxg.A.ForeignObject,coordselement.A,"coordsConstructor"),jxg.A.extend(jxg.A.ForeignObject.prototype,{hasPoint:function(t,e){var i,s,r,o,n,a,l,h,u,c=this.transformations.length;return utils_type.A.isObject(utils_type.A.evaluate(this.visProp.precision))?(o=this.board._inputDevice,n=utils_type.A.evaluate(this.visProp.precision[o])):n=this.board.options.precision.hasPoint,0===c?(i=t-this.coords.scrCoords[1],s=this.coords.scrCoords[2]-e,i>=-(r=n)&&i-this.size[0]<=r&&s>=-r&&s-this.size[1]<=r):(l=[(a=(a=new base_coords.A(constants.A.COORDS_BY_SCREEN,[t,e],this.board)).usrCoords)[0]-this.span[0][0],a[1]-this.span[0][1],a[2]-this.span[0][2]],0<=(h=(u=math.A.innerProduct)(l,this.span[1]))&&h<=u(this.span[1],this.span[1])&&0<=(h=u(l,this.span[2]))&&h<=u(this.span[2],this.span[2]))},update:function(t){return this.needsUpdate?(this.updateCoords(t),this.updateSize(),this):this},updateRenderer:function(){return this.updateRendererGeneric("updateForeignObject")},updateSize:function(){var t=[0,0];return this._useUserSize?(this.usrSize=[this.W(),this.H()],this.size=[Math.abs(this.usrSize[0]*this.board.unitX),Math.abs(this.usrSize[1]*this.board.unitY)]):this.rendNode.hasChildNodes()&&(t=this.rendNode.childNodes[0].getBoundingClientRect(),this.size=[t.width,t.height]),this},updateSpan:function(){var t,e,i=this.transformations.length,s=[];if(0===i)this.span=[[this.Z(),this.X(),this.Y()],[this.Z(),this.W(),0],[this.Z(),0,this.H()]];else{for(s[0]=[this.Z(),this.X(),this.Y()],s[1]=[this.Z(),this.X()+this.W(),this.Y()],s[2]=[this.Z(),this.X(),this.Y()+this.H()],t=0;t<i;t++)for(e=0;e<3;e++)s[e]=math.A.matVecMult(this.transformations[t].matrix,s[e]);for(e=0;e<3;e++)s[e][1]/=s[e][0],s[e][2]/=s[e][0],s[e][0]/=s[e][0];for(e=1;e<3;e++)s[e][0]-=s[0][0],s[e][1]-=s[0][1],s[e][2]-=s[0][2];this.span=s}return this},addTransform:function(t){var e;if(utils_type.A.isArray(t))for(e=0;e<t.length;e++)this.transformations.push(t[e]);else this.transformations.push(t);return this},getParents:function(){var t=[this.url,[this.Z(),this.X(),this.Y()],this.usrSize];return 0!==this.parents.length&&(t=this.parents),t},setSize:function(t,e){return this.W=utils_type.A.createFunction(t,this.board,""),this.H=utils_type.A.createFunction(e,this.board,""),this._useUserSize=!0,this.addParentsFromJCFunctions([this.W,this.H]),this},W:function(){},H:function(){}}),jxg.A.createForeignObject=function(t,e,i){var s,r,o=e[0],n=e[1],a=[];if(e.length>=2&&(a=e[2]),s=utils_type.A.copyAttributes(i,t.options,"foreignobject"),!(r=coordselement.A.create(jxg.A.ForeignObject,t,n,s,o,a)))throw new Error("JSXGraph: Can't create foreignObject with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [string, [x, y], [w, h]], [string, [x, y]], [element,transformation]");return r},jxg.A.registerElement("foreignobject",jxg.A.createForeignObject),jxg.A.registerElement("fo",jxg.A.createForeignObject);var foreignobject=jxg.A.ForeignObject;jxg.A.extend(src_options.A,{axes3d:{axesPosition:"center",xAxis:{visible:!0,point2:{name:"x"}},yAxis:{visible:!0,point2:{name:"y"}},zAxis:{visible:!0,point2:{name:"z"}},xPlaneRear:{visible:!0,layer:0,mesh3d:{layer:1}},yPlaneRear:{visible:!0,layer:0,mesh3d:{layer:1}},zPlaneRear:{visible:!0,layer:0,mesh3d:{layer:1}},xPlaneFront:{visible:!1,layer:0,mesh3d:{layer:1}},yPlaneFront:{visible:!1,layer:0,mesh3d:{layer:1}},zPlaneFront:{visible:!1,layer:0,mesh3d:{layer:1}},xPlaneRearYAxis:{visible:"inherit",strokeColor:"#888888",strokeWidth:1},xPlaneRearZAxis:{visible:"inherit",strokeColor:"#888888",strokeWidth:1},xPlaneFrontYAxis:{visible:"inherit",strokeColor:"#888888",strokeWidth:1},xPlaneFrontZAxis:{visible:"inherit",strokeColor:"#888888",strokeWidth:1},yPlaneRearXAxis:{visible:"inherit",strokeColor:"#888888",strokeWidth:1},yPlaneRearZAxis:{visible:"inherit",strokeColor:"#888888",strokeWidth:1},yPlaneFrontXAxis:{visible:"inherit",strokeColor:"#888888",strokeWidth:1},yPlaneFrontZAxis:{visible:"inherit",strokeColor:"#888888",strokeWidth:1},zPlaneRearXAxis:{visible:"inherit",strokeColor:"#888888",strokeWidth:1},zPlaneRearYAxis:{visible:"inherit",strokeColor:"#888888",strokeWidth:1},zPlaneFrontXAxis:{visible:"inherit",strokeColor:"#888888",strokeWidth:1},zPlaneFrontYAxis:{visible:"inherit",strokeColor:"#888888",strokeWidth:1}},axis3d:{highlight:!1,fixed:!0,strokecolor:"black",strokeWidth:1,tabindex:null,point1:{visible:!1,name:""},point2:{visible:!1,name:"",label:{visible:!0}}},curve3d:{highlight:!1,tabindex:-1,strokeWidth:1,numberPointsHigh:200},intersectionline3d:{point1:{visible:!1,name:""},point2:{visible:!1,name:""}},line3d:{strokeWidth:1,strokeColor:"black",fixed:!0,tabindex:null,gradient:"linear",gradientSecondColor:"#ffffff",point:{visible:!1,name:""},point1:{visible:!1,name:""},point2:{visible:!1,name:""}},mesh3d:{strokeWidth:1,strokeColor:"#9a9a9a",strokeOpacity:.6,highlight:!1,fillColor:"#9a9a9a",fillOpacity:.1,tabindex:null,visible:"inherit"},plane3d:{strokeWidth:0,strokeColor:"black",strokeOpacity:1,highlight:!1,tabindex:null,gradient:"linear",gradientSecondColor:"#ffffff",gradientAngle:Math.PI,fillColor:"#a7a7a7",fillOpacity:.6,point:{visible:!1,name:"",fixed:!0}},point3d:{infoboxDigits:"auto",strokeWidth:0,gradient:"radial",gradientSecondColor:"#555555",fillColor:"yellow",highlightStrokeColor:"#555555"},polygon3d:{highlight:!1,tabindex:-1,strokeWidth:1,fillColor:"none"},sphere3d:{highlight:!1,strokeWidth:1,strokeColor:"#00ff80",fillColor:"white",gradient:"radial",gradientSecondColor:"#00ff80",gradientFX:.7,gradientFY:.3,fillOpacity:.4},surface3d:{highlight:!1,tabindex:-1,strokeWidth:1,stepsU:30,stepsV:30},vectorfield3d:{scale:1,arrowhead:{enabled:!0,size:5,angle:.125*Math.PI}},view3d:{needsRegularUpdate:!0,projection:"parallel",verticalDrag:{enabled:!0,key:"shift"},az:{pointer:{enabled:!0,speed:1,outside:!0,button:-1,key:"none"},keyboard:{enabled:!0,step:10,key:"ctrl"},continuous:!0,slider:{visible:!0,style:6,point1:{frozen:!0},point2:{frozen:!0},min:0,max:2*Math.PI,start:1}},el:{pointer:{enabled:!0,speed:1,outside:!0,button:-1,key:"none"},keyboard:{enabled:!0,step:10,key:"ctrl"},continuous:!0,slider:{visible:!0,style:6,point1:{frozen:!0},point2:{frozen:!0},min:0,max:2*Math.PI,start:.3}},trackball:{enabled:!1,outside:!0,button:-1,key:"none"},r:"auto",fov:.4*Math.PI,values:[[0,1.57],[.78,.62],[0,0],[5.49,.62],[4.71,0],[3.93,.62],[3.14,0],[2.36,.62],[1.57,1.57]],_currentView:-1}});var options3d=jxg.A.Options;jxg.A.View3D=function(t,e,i){this.constructor(t,i,constants.A.OBJECT_TYPE_VIEW3D,constants.A.OBJECT_CLASS_3D),this.objects={},this.elementsByName={},this.defaultAxes=null,this.matrix3D=[[1,0,0,0],[0,1,0,0],[0,0,1,0]],this.cameraTransform=[],this.llftCorner=e[0],this.size=e[1],this.bbox3D=e[2],this.r=-1,this.focalDist=-1,this.projectionType="parallel",this.timeoutAzimuth=null,this.id=this.board.setId(this,"V"),this.board.finalizeAdding(this),this.elType="view3d",this.methodMap=utils_type.A.deepCopy(this.methodMap,{})},jxg.A.View3D.prototype=new base_element.A,jxg.A.extend(jxg.A.View3D.prototype,{create:function(t,e,i){var s=[];return t.indexOf("3d")>0&&s.push(this),this.board.create(t,s.concat(e),i)},select:function(t,e){var i,s,r,o,n=t;if(null===n)return n;if(utils_type.A.isString(n)&&""!==n)utils_type.A.exists(this.objects[n])?n=this.objects[n]:utils_type.A.exists(this.elementsByName[n])&&(n=this.elementsByName[n]);else if(!e&&(utils_type.A.isFunction(n)||utils_type.A.isObject(n)&&!utils_type.A.isFunction(n.setAttribute))){for(s={},o=(i=utils_type.A.filterElements(this.objectsList,n)).length,r=0;r<o;r++)s[i[r].id]=i[r];n=new composition(s)}else utils_type.A.isObject(n)&&utils_type.A.exists(n.id)&&!utils_type.A.exists(this.objects[n.id])&&(n=null);return n},updateParallelProjection:function(){var t,e,i,s,r=[[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]];return i=this.el_slide.Value(),t=this.r,e=this.az_slide.Value(),s=t*Math.sin(i),r[1][1]=t*Math.cos(e),r[1][2]=-t*Math.sin(e),r[1][3]=0,r[2][1]=s*Math.sin(e),r[2][2]=s*Math.cos(e),r[2][3]=Math.cos(i),r[3][1]=t*Math.cos(i)*Math.sin(e),r[3][2]=t*Math.cos(i)*Math.cos(e),r[3][3]=-Math.sin(i),r},_projectToSphere:function(t,e,i){var s,r=math.A.hypot(e,i);return r<.7071067811865475*t?Math.sqrt(t*t-r*r):(s=t/1.414213562373095)*s/r},updateProjectionTrackball:function(t){var e,i,s,r,o,n,a,l,h,u,c,d,p=100,_=[[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]];return utils_type.A.exists(this._trackball)?((e=this._trackball.dx)*e+(i=this._trackball.dy)*i>math.A.eps&&(p=.25*(this.size[0]*this.board.unitX+this.size[1]*this.board.unitY),o=this._trackball.x,n=this._trackball.y,r=[this._projectToSphere(p,o,n),o,n],o-=e,n-=i,s=[this._projectToSphere(p,o,n),o,n],d=math.A.crossProduct(r,s),h=math.A.hypot(d[0],d[1],d[2]),d[0]/=-h,d[1]/=-h,d[2]/=h,l=(l=(l=geometry.A.distance(r,s,3)/(2*p))>1?1:l)<-1?-1:l,a=2*Math.asin(l),l=1-(u=Math.cos(a)),c=Math.sin(a),_[1][1]=u+d[0]*d[0]*l,_[2][1]=d[0]*d[1]*l-d[2]*c,_[3][1]=d[0]*d[2]*l+d[1]*c,_[1][2]=d[1]*d[0]*l+d[2]*c,_[2][2]=u+d[1]*d[1]*l,_[3][2]=d[1]*d[2]*l-d[0]*c,_[1][3]=d[2]*d[0]*l-d[1]*c,_[2][3]=d[2]*d[1]*l+d[0]*c,_[3][3]=u+d[2]*d[2]*l,null!==t&&(_[1][0]=t[0]-_[1][1]*t[0]-_[1][2]*t[0]-_[1][3]*t[0],_[2][0]=t[1]-_[2][1]*t[1]-_[2][2]*t[1]-_[2][3]*t[1],_[3][0]=t[2]-_[3][1]*t[2]-_[3][2]*t[2]-_[3][3]*t[2])),_=math.A.matMatMult(this.matrix3DRot,_)):this.matrix3DRot},_updateCentralProjection:function(){var t,e,i,s,r,o,n,a,l,h,u,c,d,p=[.5*(this.bbox3D[0][0]+this.bbox3D[0][1]),.5*(this.bbox3D[1][0]+this.bbox3D[1][1]),.5*(this.bbox3D[2][0]+this.bbox3D[2][1])];return d=function(t,e,i){return[i*Math.cos(t)*Math.cos(e),-i*Math.sin(t)*Math.cos(e),i*Math.sin(e)]},i=this.az_slide.Value()+3*Math.PI*.5,e=this.el_slide.Value(),"auto"===(t=utils_type.A.evaluate(this.visProp.r))&&(t=1.01*math.A.hypot(this.bbox3D[0][0]-this.bbox3D[0][1],this.bbox3D[1][0]-this.bbox3D[1][1],this.bbox3D[2][0]-this.bbox3D[2][1])),s=d(i,e+Math.PI/2,1),u=[(h=d(i,e,t))[0],h[1],h[2]],h[0]+=p[0],h[1]+=p[1],h[2]+=p[2],l=math.A.norm(u,3),r=[u[0]/l,u[1]/l,u[2]/l],l=math.A.norm(s,3),a=[s[0]/l,s[1]/l,s[2]/l],o=math.A.crossProduct(a,r),n=math.A.crossProduct(r,o),a=math.A.matVecMult([o,n,r],h),this.cameraTransform=[[1,0,0,0],[-a[0],o[0],o[1],o[2]],[-a[1],n[0],n[1],n[2]],[-a[2],r[0],r[1],r[2]]],this.focalDist=1/Math.tan(.5*utils_type.A.evaluate(this.visProp.fov)),c=[[0,0,0,-1],[0,this.focalDist,0,0],[0,0,this.focalDist,0],[320/-12,0,0,28/-12]],math.A.matMatMult(c,this.cameraTransform)},update:function(){var t,e,i,s,r,o=null,n=!1;if(!utils_type.A.exists(this.el_slide)||!utils_type.A.exists(this.az_slide)||!this.needsUpdate)return this;if(t=[[1,0,0],[0,1,0],[0,0,1]],this.projectionType=utils_type.A.evaluate(this.visProp.projection).toLowerCase(),utils_type.A.evaluate(this.visProp.trackball.enabled)&&utils_type.A.exists(this.matrix3DRot)&&(this._hasMoveTrackball&&("central"===this.projectionType&&(o=[.5*(this.bbox3D[0][0]+this.bbox3D[0][1]),.5*(this.bbox3D[1][0]+this.bbox3D[1][1]),.5*(this.bbox3D[2][0]+this.bbox3D[2][1])]),this.matrix3DRot=this.updateProjectionTrackball(o)),n=!0),"central"===this.projectionType)i=.8,t[1][1]=this.size[0]/i,t[2][2]=this.size[1]/i,t[1][0]=this.llftCorner[0]+.5*t[1][1]*i,t[2][0]=this.llftCorner[1]+.5*t[2][2]*i,this.viewPortTransform=t,n||(this.matrix3DRot=this._updateCentralProjection()),this.matrix3D=this.matrix3DRot.slice();else e=[[1,0,0,0],[-.5*(this.bbox3D[0][0]+this.bbox3D[0][1]),1,0,0],[-.5*(this.bbox3D[1][0]+this.bbox3D[1][1]),0,1,0],[-.5*(this.bbox3D[2][0]+this.bbox3D[2][1]),0,0,1]],s=this.bbox3D[0][1]-this.bbox3D[0][0],r=this.bbox3D[1][1]-this.bbox3D[1][0],t[1][1]=this.size[0]/s,t[2][2]=this.size[1]/r,t[1][0]=this.llftCorner[0]+.5*t[1][1]*s,t[2][0]=this.llftCorner[1]+.5*t[2][2]*r,n||(this.matrix3DRot=this.updateParallelProjection()),this.matrix3D=math.A.matMatMult(t,math.A.matMatMult(this.matrix3DRot,e).slice(0,3));return this},updateRenderer:function(){return this.needsUpdate=!1,this},removeObject:function(t,e){var i;if(utils_type.A.isArray(t)){for(i=0;i<t.length;i++)this.removeObject(t[i]);return this}if(t=this.select(t),!utils_type.A.exists(t)||utils_type.A.isString(t))return this;try{delete this.objects[t.id]}catch(e){jxg.A.debug("View3D "+t.id+": Could not be removed: "+e)}return this.board.removeObject(t,e),this},worldToView:function(t,e=!0){var i,s=math.A.matVecMult(this.cameraTransform,t);if(s[3]-=s[0]*this.focalDist,e)return s;for(i=1;i<4;i++)s[i]/=s[0];return s.slice(1,4)},project3DTo2D:function(t,e,i){var s,r;return 3===arguments.length?s=[1,t,e,i]:3===t.length?(s=t.slice()).unshift(1):s=t,r=math.A.matVecMult(this.matrix3D,s),"central"===this.projectionType?(r[1]/=r[0],r[2]/=r[0],r[3]/=r[0],r[0]/=r[0],math.A.matVecMult(this.viewPortTransform,r.slice(0,3))):r},_getW0:function(t,e,i){var s,r=math.A.inverse(t),o=r[0][0]+e[1]*r[0][1]+e[2]*r[0][2],n=r[3][0]+e[1]*r[3][1]+e[2]*r[3][2];return s=i*r[0][3]-r[3][3],[1/((n*r[0][3]-o*r[3][3])/s),(n-o*i)/s]},project2DTo3DPlane:function(t,e,i){var s,r,o,n,a,l,h,u,c=e.slice(1);if(i=i||[1,0,0,0],n=math.A.norm(c,3),o=math.A.innerProduct(i.slice(1),c,3)/n,"parallel"===this.projectionType){(s=this.matrix3D.slice(0,3)).push([0,c[0],c[1],c[2]]),(r=t.coords.usrCoords.slice()).push(o);try{1===s[2][3]&&(s[2][1]=s[2][2]=.001*math.A.eps),a=math.A.Numerics.Gauss(s,r)}catch(t){a=[0,NaN,NaN,NaN]}}else{s=this.matrix3DRot,r=t.coords.usrCoords.slice(),l=math.A.Numerics.Gauss(this.viewPortTransform,r),h=(u=this._getW0(s,l,o))[0],r=[l[0]*h,l[1]*h,l[2]*h,u[1]*h];try{1===s[2][3]&&(s[2][1]=s[2][2]=.001*math.A.eps),(a=math.A.Numerics.Gauss(s,r))[1]/=a[0],a[2]/=a[0],a[3]/=a[0],a[0]/=a[0]}catch(t){a=[0,NaN,NaN,NaN]}}return a},project2DTo3DVertical:function(t,e){var i=this.matrix3D[2],s=i[3],r=t.coords.usrCoords[2];return r-=i[0]*e[0]+i[1]*e[1]+i[2]*e[2],Math.abs(s)<math.A.eps?e:e.slice(0,3).concat([r/s])},project3DToCube:function(t){var e=this.bbox3D;return t[1]<e[0][0]&&(t[1]=e[0][0]),t[1]>e[0][1]&&(t[1]=e[0][1]),t[2]<e[1][0]&&(t[2]=e[1][0]),t[2]>e[1][1]&&(t[2]=e[1][1]),t[3]<e[2][0]&&(t[3]=e[2][0]),t[3]>e[2][1]&&(t[3]=e[2][1]),t},intersectionLineCube:function(t,e,i){var s,r,o,n;for(s=i,r=0;r<3;r++)0!==e[r]&&(o=(this.bbox3D[r][0]-t[r])/e[r],n=(this.bbox3D[r][1]-t[r])/e[r],s=i<0?Math.max(s,Math.min(o,n)):Math.min(s,Math.max(o,n)));return s},isInCube:function(t){return t[0]>this.bbox3D[0][0]-math.A.eps&&t[0]<this.bbox3D[0][1]+math.A.eps&&t[1]>this.bbox3D[1][0]-math.A.eps&&t[1]<this.bbox3D[1][1]+math.A.eps&&t[2]>this.bbox3D[2][0]-math.A.eps&&t[2]<this.bbox3D[2][1]+math.A.eps},intersectionPlanePlane:function(t,e,i){var s,r,o,n,a=[[],[]];return i=i||e.d,s=math.A.Geometry.meet3Planes(t.normal,t.d,e.normal,i,math.A.crossProduct(t.normal,e.normal),0),r=math.A.Geometry.meetPlanePlane(t.vec1,t.vec2,e.vec1,e.vec2),o=this.intersectionLineCube(s,r,1/0),n=math.A.axpy(o,r,s),this.isInCube(n)&&(a[0]=n),o=this.intersectionLineCube(s,r,-1/0),n=math.A.axpy(o,r,s),this.isInCube(n)&&(a[1]=n),a},getMesh:function(t,e,i){var s,r,o,n,a,l,h,u=[0,0,0],c=e[2],d=i[2],p=[],_=[];for(l=(utils_type.A.evaluate(e[1])-utils_type.A.evaluate(e[0]))/c,h=(utils_type.A.evaluate(i[1])-utils_type.A.evaluate(i[0]))/d,s=0;s<=c;s++){for(o=e[0]+l*s,r=0;r<=d;r++)n=i[0]+h*r,u=utils_type.A.isFunction(t)?t(o,n):[t[0](o,n),t[1](o,n),t[2](o,n)],a=this.project3DTo2D(u),p.push(a[1]),_.push(a[2]);p.push(NaN),_.push(NaN)}for(r=0;r<=d;r++){for(n=i[0]+h*r,s=0;s<=c;s++)o=e[0]+l*s,u=utils_type.A.isFunction(t)?t(o,n):[t[0](o,n),t[1](o,n),t[2](o,n)],a=this.project3DTo2D(u),p.push(a[1]),_.push(a[2]);p.push(NaN),_.push(NaN)}return[p,_]},animateAzimuth:function(){var t=this.az_slide._smin,e=this.az_slide._smax-t,i=this.az_slide.Value()+.1;this.az_slide.position=(i-t)/e,this.az_slide.position>1&&(this.az_slide.position=0),this.board.update(),this.timeoutAzimuth=setTimeout(function(){this.animateAzimuth()}.bind(this),200)},stopAzimuth:function(){clearTimeout(this.timeoutAzimuth),this.timeoutAzimuth=null},isVerticalDrag:function(){var t=this.board;return!!utils_type.A.evaluate(this.visProp.verticaldrag.enabled)&&t["_"+utils_type.A.evaluate(this.visProp.verticaldrag.key)+"Key"]},setView:function(t,e,i){return i=i||this.r,this.az_slide.setValue(t),this.el_slide.setValue(e),this.r=i,this.board.update(),this},nextView:function(){var t=utils_type.A.evaluate(this.visProp.values),e=this.visProp._currentview;return e=(e+1)%t.length,this.setCurrentView(e),this},previousView:function(){var t=utils_type.A.evaluate(this.visProp.values),e=this.visProp._currentview;return e=(e+t.length-1)%t.length,this.setCurrentView(e),this},setCurrentView:function(t){var e=utils_type.A.evaluate(this.visProp.values);return(t<0||t>=e.length)&&(t=(t%e.length+e.length)%e.length),this.setView(e[t][0],e[t][1],e[t][2]),this.visProp._currentview=t,this},_azEventHandler:function(t){var e=this.az_slide._smax,i=this.az_slide._smin,s=(e-i)/this.board.canvasWidth*utils_type.A.evaluate(this.visProp.az.pointer.speed),r=t.movementX,o=this.az_slide.Value(),n=this.el_slide.Value();return this.board.mode===this.board.BOARD_MODE_DRAG||(utils_type.A.evaluate(this.visProp.az.keyboard.enabled)&&("ArrowRight"===t.key?o+=utils_type.A.evaluate(this.visProp.az.keyboard.step)*Math.PI/180:"ArrowLeft"===t.key&&(o-=utils_type.A.evaluate(this.visProp.az.keyboard.step)*Math.PI/180)),utils_type.A.evaluate(this.visProp.az.pointer.enabled)&&0!==r&&null==t.key&&(o+=r*s),utils_type.A.evaluate(this.visProp.az.continuous)?o=(o+e)%e:o>0?o=Math.min(e,o):o<0&&(o=Math.max(i,o)),this.setView(o,n)),this},_elEventHandler:function(t){var e=this.el_slide._smax,i=this.el_slide._smin,s=(e-i)/this.board.canvasHeight*utils_type.A.evaluate(this.visProp.el.pointer.speed),r=t.movementY,o=this.az_slide.Value(),n=this.el_slide.Value();return this.board.mode===this.board.BOARD_MODE_DRAG||(utils_type.A.evaluate(this.visProp.el.keyboard.enabled)&&("ArrowUp"===t.key?n-=utils_type.A.evaluate(this.visProp.el.keyboard.step)*Math.PI/180:"ArrowDown"===t.key&&(n+=utils_type.A.evaluate(this.visProp.el.keyboard.step)*Math.PI/180)),utils_type.A.evaluate(this.visProp.el.pointer.enabled)&&0!==r&&null==t.key&&(n+=r*s),utils_type.A.evaluate(this.visProp.el.continuous)?n=(n+e)%e:n>0?n=Math.min(e,n):n<0&&(n=Math.max(i,n)),this.setView(o,n)),this},_trackballHandler:function(t){var e,i,s,r=this.board.getMousePosition(t);return s=new base_coords.A(constants.A.COORDS_BY_USER,[this.llftCorner[0]+.5*this.size[0],this.llftCorner[1]+.5*this.size[1]],this.board),e=r[0]-s.scrCoords[1],i=r[1]-s.scrCoords[2],this._trackball={dx:t.movementX,dy:t.movementY,x:e,y:i},this.board.update(),this},pointerDownHandler:function(t){var e,i,s;this._hasMoveAz=!1,this._hasMoveEl=!1,this._hasMoveTrackball=!1,this.board.mode===this.board.BOARD_MODE_NONE&&(utils_type.A.evaluate(this.visProp.trackball.enabled)?(e=utils_type.A.evaluate(this.visProp.trackball.button),i=utils_type.A.evaluate(this.visProp.trackball.key),-1!==e&&e!==t.button||!("none"===i||i.indexOf("shift")>-1&&t.shiftKey||i.indexOf("ctrl")>-1&&t.ctrlKey)||(s=utils_type.A.evaluate(this.visProp.trackball.outside)?document:this.board.containerObj,env.A.addEvent(s,"pointermove",this._trackballHandler,this),this._hasMoveTrackball=!0)):(utils_type.A.evaluate(this.visProp.az.pointer.enabled)&&(e=utils_type.A.evaluate(this.visProp.az.pointer.button),i=utils_type.A.evaluate(this.visProp.az.pointer.key),-1!==e&&e!==t.button||!("none"===i||i.indexOf("shift")>-1&&t.shiftKey||i.indexOf("ctrl")>-1&&t.ctrlKey)||(s=utils_type.A.evaluate(this.visProp.az.pointer.outside)?document:this.board.containerObj,env.A.addEvent(s,"pointermove",this._azEventHandler,this),this._hasMoveAz=!0)),utils_type.A.evaluate(this.visProp.el.pointer.enabled)&&(e=utils_type.A.evaluate(this.visProp.el.pointer.button),i=utils_type.A.evaluate(this.visProp.el.pointer.key),-1!==e&&e!==t.button||!("none"===i||i.indexOf("shift")>-1&&t.shiftKey||i.indexOf("ctrl")>-1&&t.ctrlKey)||(s=utils_type.A.evaluate(this.visProp.el.pointer.outside)?document:this.board.containerObj,env.A.addEvent(s,"pointermove",this._elEventHandler,this),this._hasMoveEl=!0))),env.A.addEvent(document,"pointerup",this.pointerUpHandler,this))},pointerUpHandler:function(t){var e;this._hasMoveAz&&(e=utils_type.A.evaluate(this.visProp.az.pointer.outside)?document:this.board.containerObj,env.A.removeEvent(e,"pointermove",this._azEventHandler,this),this._hasMoveAz=!1),this._hasMoveEl&&(e=utils_type.A.evaluate(this.visProp.el.pointer.outside)?document:this.board.containerObj,env.A.removeEvent(e,"pointermove",this._elEventHandler,this),this._hasMoveEl=!1),this._hasMoveTrackball&&(e=utils_type.A.evaluate(this.visProp.az.pointer.outside)?document:this.board.containerObj,env.A.removeEvent(e,"pointermove",this._trackballHandler,this),this._hasMoveTrackball=!1),env.A.removeEvent(document,"pointerup",this.pointerUpHandler,this)}}),jxg.A.createView3D=function(t,e,i){var s,r,o,n,a,l,h,u,c=e[0],d=e[1];return r=utils_type.A.copyAttributes(i,t.options,"view3d"),(s=new jxg.A.View3D(t,e,r)).defaultAxes=s.create("axes3d",e,i),a=c[0],l=c[1],h=d[0],u=d[1],(o=utils_type.A.copyAttributes(i,t.options,"view3d","az","slider")).name="az",(n=utils_type.A.copyAttributes(i,t.options,"view3d","el","slider")).name="el",s.az_slide=t.create("slider",[[a-1,l-2],[a+h+1,l-2],[utils_type.A.evaluate(o.min),utils_type.A.evaluate(o.start),utils_type.A.evaluate(o.max)]],o),s.el_slide=t.create("slider",[[a-1,l],[a-1,l+u],[utils_type.A.evaluate(n.min),utils_type.A.evaluate(n.start),utils_type.A.evaluate(n.max)]],n),s.board.highlightInfobox=function(t,e,i){var r,o,n,a,l,h,u='<span style="color:black; font-size:200%">⇄ &nbsp;</span>',c=i.board,d=null;for(s.isVerticalDrag()&&(u='<span style="color:black; font-size:200%">⇅ &nbsp;</span>'),o=0;o<i.parents.length&&!(d=c.objects[i.parents[o]]).is3D;o++);if(d){if(a=[1,0,0,d.coords[3]],s._w0=math.A.innerProduct(s.matrix3D[0],a,4),n=s.project2DTo3DPlane(d.element2D,[1,0,0,1],a),!s.isInCube(n))return void s.board.highlightCustomInfobox("",d);r=utils_type.A.evaluate(d.visProp.infoboxdigits),h=s.board.infobox,l="auto"===r?h.useLocale()?[u,"(",h.formatNumberLocale(d.X())," | ",h.formatNumberLocale(d.Y())," | ",h.formatNumberLocale(d.Z()),")"]:[u,"(",utils_type.A.autoDigits(d.X())," | ",utils_type.A.autoDigits(d.Y())," | ",utils_type.A.autoDigits(d.Z()),")"]:h.useLocale()?[u,"(",h.formatNumberLocale(d.X(),r)," | ",h.formatNumberLocale(d.Y(),r)," | ",h.formatNumberLocale(d.Z(),r),")"]:[u,"(",utils_type.A.toFixed(d.X(),r)," | ",utils_type.A.toFixed(d.Y(),r)," | ",utils_type.A.toFixed(d.Z(),r),")"],s.board.highlightCustomInfobox(l.join(""),d)}else s.board.highlightCustomInfobox("("+t+", "+e+")",i)},s.BOARD_MODE_NONE=0,env.A.addEvent(t.containerObj,"keydown",(function(t){var e,i=!1;!utils_type.A.evaluate(s.visProp.el.keyboard.enabled)||"ArrowUp"!==t.key&&"ArrowDown"!==t.key||("none"===(e=utils_type.A.evaluate(s.visProp.el.keyboard.key))||e.indexOf("shift")>-1&&t.shiftKey||e.indexOf("ctrl")>-1&&t.ctrlKey)&&(s._elEventHandler(t),i=!0),!utils_type.A.evaluate(s.visProp.el.keyboard.enabled)||"ArrowLeft"!==t.key&&"ArrowRight"!==t.key||("none"===(e=utils_type.A.evaluate(s.visProp.az.keyboard.key))||e.indexOf("shift")>-1&&t.shiftKey||e.indexOf("ctrl")>-1&&t.ctrlKey)&&(s._azEventHandler(t),i=!0),"PageUp"===t.key?(s.nextView(),i=!0):"PageDown"===t.key&&(s.previousView(),i=!0),i&&t.preventDefault()}),s),env.A.addEvent(t.containerObj,"pointerdown",s.pointerDownHandler,s),s.board.update(),s},jxg.A.registerElement("view3d",jxg.A.createView3D);var view3d=jxg.A.View3D;jxg.A.GeometryElement3D=function(t,e){this.elType=e,this.id=this.board.setId(this,e),this.view=t,this.element2D=null,this.is3D=!0,this.view.objects[this.id]=this,""!==this.name&&(this.view.elementsByName[this.name]=this)},jxg.A.extend(jxg.A.GeometryElement3D.prototype,{setAttr2D:function(t){var e=t;return e.name=this.name,e},setAttribute:function(t){var e,i,s,r,o,n={};for(e=0;e<arguments.length;e++)r=arguments[e],utils_type.A.isString(r)?(o=r.split(":"),n[utils_type.A.trim(o[0])]=utils_type.A.trim(o[1])):utils_type.A.isArray(r)?n[r[0]]=r[1]:jxg.A.extend(n,r);for(e in n)if(n.hasOwnProperty(e))switch(i=e.replace(/\s+/g,"").toLowerCase(),s=n[e],i){case"numberpointshigh":case"stepsu":case"stepsv":utils_type.A.exists(this.visProp[i])&&(!jxg.A.Validator[i]||jxg.A.Validator[i]&&jxg.A.Validator[i](s)||jxg.A.Validator[i]&&utils_type.A.isFunction(s)&&jxg.A.Validator[i](s()))&&(s=(!s.toLowerCase||"false"!==s.toLowerCase())&&s,this._set(i,s));break;default:utils_type.A.exists(this.element2D)&&this.element2D.setAttribute(n)}},getAttribute:function(t){var e;switch(t=t.toLowerCase()){case"numberpointshigh":case"stepsu":case"stepsv":e=this.visProp[t];break;default:utils_type.A.exists(this.element2D)&&(e=this.element2D.getAttribute(t))}return e},getAttributes:function(){var t,e,i={},s=["numberpointshigh","stepsu","stepsv"],r=s.length;for(utils_type.A.exists(this.element2D)&&(i=utils_type.A.merge(this.element2D.getAttributes())),t=0;t<r;t++)e=s[t],utils_type.A.exists(this.visProp[e])&&(i[e]=this.visProp[e]);return i},remove:function(){}});var element3d=jxg.A.GeometryElement3D;jxg.A.createAxes3D=function(t,e,i){var s,r,o,n,a,l,h,u,c,d,p,_,f,A,g,m,y,b=e[0],v=["x","y","z"],C="Axis",P=["Rear","Front"],x=[0,0,0],E=[0,0,0],O={};if(utils_type.A.exists(b.bbox3D))for(s=0;s<v.length;s++)x[s]=b.bbox3D[s][0],E[s]=b.bbox3D[s][1];else for(s=0;s<v.length;s++)x[s]=e[1][s],E[s]=e[2][1];for(h=(l=utils_type.A.copyAttributes(i,t.options,"axes3d")).axesposition,s=0;s<v.length;s++)g=(u=v[s])+C,"center"===h?(c=[0,0,0],(d=[0,0,0])[s]=E[s],O[g]=b.create("axis3d",[c,d],l[g.toLowerCase()])):(g+="Border",c=x.slice(),d=E.slice(),2===s?(c[1]=E[1],d[0]=x[0]):(c[s]=E[s],d[2]=x[2]),d[s]=E[s],l[g.toLowerCase()].lastArrow=!1,O[g]=b.create("axis3d",[c,d],l[g.toLowerCase()]),y={visible:!0,minorTicks:0,tickEndings:[0,1],drawLabels:!1},2===s&&(y.tickEndings=[1,0]),O[g+"Ticks"]=b.create("ticks",[O[g],1],y));for(O.O=b.create("intersection",[O[v[0]+C],O[v[1]+C]],{name:"",visible:!1,withLabel:!1}),s=0;s<v.length;s++)for(n=(s+1)%3,a=(s+2)%3,u=v[s],r=0;r<P.length;r++)(c=[0,0,0])[s]=0===r?x[s]:E[s],_=[0,0,0],(p=[0,0,0])[n]=1,_[a]=1,f=[x[n],E[n]],A=[x[a],E[a]],g=u+"Plane"+P[r],l=utils_type.A.copyAttributes(i,t.options,"axes3d",g),O[g]=b.create("plane3d",[c,p,_,f,A],l),O[g].elType="axisplane3d";for(s=0;s<v.length;s++)for(u=v[s],r=0;r<P.length;r++)for(o=1;o<=2;o++)g=u+"Plane"+P[r]+v[n=(s+o)%3].toUpperCase()+"Axis",m=u+"Plane"+P[r],(c=[0,0,0])[s]=(d=[0,0,0])[s]=0===r?x[s]:E[s],c[n]=x[n],d[n]=E[n],l=utils_type.A.copyAttributes(i,t.options,"axes3d",g),O[g]=b.create("axis3d",[c,d],l),O[m].addChild(O[g]),O[m].element2D.inherits.push(O[g]);return O},jxg.A.registerElement("axes3d",jxg.A.createAxes3D),jxg.A.createAxis3D=function(t,e,i){var s,r,o,n,a,l,h=e[0],u=e[1],c=e[2];return s=utils_type.A.copyAttributes(i.point1,t.options,"axis3d","point1"),r=h.create("point",[(n=u[0],a=u[1],l=u[2],function(){return h.project3DTo2D(n,a,l)[1]}),function(t,e,i){return function(){return h.project3DTo2D(t,e,i)[2]}}(u[0],u[1],u[2])],s),s=utils_type.A.copyAttributes(i.point2,t.options,"axis3d","point2"),o=h.create("point",[function(t,e,i){return function(){return h.project3DTo2D(t,e,i)[1]}}(c[0],c[1],c[2]),function(t,e,i){return function(){return h.project3DTo2D(t,e,i)[2]}}(c[0],c[1],c[2])],s),s=utils_type.A.copyAttributes(i,t.options,"axis3d"),h.create("arrow",[r,o],s)},jxg.A.registerElement("axis3d",jxg.A.createAxis3D),jxg.A.createMesh3D=function(t,e,i){var s,r=e[0],o=e[1],n=e[2],a=e[3],l=e[4],h=e[5];return(s=r.create("curve",[[],[]],i)).updateDataArray=function(){var t,e,i,s,u=a[0],c=a[1],d=h[0],p=h[1],_=[0,0,0],f=[0,0,0],A=[0,0,0];if(this.dataX=[],this.dataY=[],utils_type.A.isFunction(o))A=o().slice(1);else for(s=0;s<3;s++)A[s]=utils_type.A.evaluate(o[s]);for(s=0;s<3;s++)_[s]=utils_type.A.evaluate(n[s]),f[s]=utils_type.A.evaluate(l[s]);for(t=jxg.A.Math.norm(_,3),e=jxg.A.Math.norm(f,3),s=0;s<3;s++)_[s]/=t,f[s]/=e;i=r.getMesh([function(t,e){return A[0]+t*_[0]+e*f[0]},function(t,e){return A[1]+t*_[1]+e*f[1]},function(t,e){return A[2]+t*_[2]+e*f[2]}],[Math.ceil(u),Math.floor(c),(Math.ceil(c)-Math.floor(u))/1],[Math.ceil(d),Math.floor(p),(Math.ceil(p)-Math.floor(d))/1]),this.dataX=i[0],this.dataY=i[1]},s},jxg.A.registerElement("mesh3d",jxg.A.createMesh3D),jxg.A.Circle3D=function(t,e,i,s,r){this.constructor(t.board,r,constants.A.OBJECT_TYPE_CIRCLE3D,constants.A.OBJECT_CLASS_3D),this.constructor3D(t,"circle3d"),this.center=this.board.select(e),this.normal=[0,0,0],this.curve,this.frame1,this.frame2,this.updateNormal=function(){var t,e;for(t=0;t<3;t++)this.normal[t]=utils_type.A.evaluate(i[t]);if(e=math.A.norm(this.normal),Math.abs(e)>math.A.eps)for(t=0;t<3;t++)this.normal[t]/=e},utils_type.A.exists(this.center._is_new)?(this.addChild(this.center),delete this.center._is_new):this.center.addChild(this),this.updateRadius=utils_type.A.createFunction(s,this.board),this.addParentsFromJCFunctions([this.updateRadius]),this.updateNormal();this.frame1=math.A.crossProduct(this.normal,[1,0,0]);var o=math.A.crossProduct(this.normal,[-.5,.8660254037844386,0]);math.A.norm(o)>math.A.norm(this.frame1)&&(this.frame1=o),this.frame2=math.A.crossProduct(this.normal,this.frame1),this.normalizeFrame(),this.curve=t.create("curve3d",[t=>this.center.X()+this.Radius()*(Math.cos(t)*this.frame1[0]+Math.sin(t)*this.frame2[0]),t=>this.center.Y()+this.Radius()*(Math.cos(t)*this.frame1[1]+Math.sin(t)*this.frame2[1]),t=>this.center.Z()+this.Radius()*(Math.cos(t)*this.frame1[2]+Math.sin(t)*this.frame2[2]),[0,2*Math.PI]],r)},jxg.A.Circle3D.prototype=new jxg.A.GeometryElement,utils_type.A.copyPrototypeMethods(jxg.A.Circle3D,jxg.A.GeometryElement3D,"constructor3D"),jxg.A.extend(jxg.A.Circle3D.prototype,{update:function(){return this.updateNormal(),this.updateFrame(),this.curve.visProp.visible=!isNaN(this.Radius()),this},updateRenderer:function(){return this.needsUpdate=!1,this},setRadius:function(t){return this.updateRadius=utils_type.A.createFunction(t,this.board),this.addParentsFromJCFunctions([this.updateRadius]),this.board.update(),this},Radius:function(t){return utils_type.A.exists(t)?(this.setRadius(t),this.Radius()):Math.abs(this.updateRadius())},normalizeFrame:function(){var t,e=math.A.norm(this.frame1),i=math.A.norm(this.frame2);for(t=0;t<3;t++)this.frame1[t]/=e,this.frame2[t]/=i},updateFrame:function(){this.frame1=math.A.crossProduct(this.frame2,this.normal),this.frame2=math.A.crossProduct(this.normal,this.frame1),this.normalizeFrame()},projectCoords:function(t,e){return this.curve.projectCoords(t,e)},projectScreenCoords:function(t,e){return this.curve.projectScreenCoords(t,e)}}),jxg.A.createCircle3D=function(t,e,i){var s,r=e[0],o=utils_type.A.copyAttributes(i,t.options,"circle3d"),n=utils_type.A.providePoints3D(r,[e[1]],i,"line3d",["point"])[0],a=e[2],l=e[3];return(s=new jxg.A.Circle3D(r,n,a,l,o)).center.addChild(s),s.addChild(s.curve),s.update(),s},jxg.A.registerElement("circle3d",jxg.A.createCircle3D),jxg.A.createIntersectionCircle3D=function(t,e,i){var s,r,o,n=e[0],a=e[1],l=e[2],h=utils_type.A.copyAttributes(i,t.options,"intersectioncircle3d");o=geometry.A.intersectionFunction3D(n,a,l),r=n.create("point3d",o[0],{visible:!1}),s=n.create("circle3d",[r,o[1],o[2]],h);try{a.addChild(s),l.addChild(s)}catch(t){throw new Error("JSXGraph: Can't create 'intersection' with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.")}return s.type=constants.A.OBJECT_TYPE_INTERSECTION_CIRCLE3D,s.elType="intersectioncircle3d",s.setParents([a.id,l.id]),s},jxg.A.registerElement("intersectioncircle3d",jxg.A.createIntersectionCircle3D),jxg.A.Point3D=function(t,e,i,s){this.constructor(t.board,s,constants.A.OBJECT_TYPE_POINT3D,constants.A.OBJECT_CLASS_3D),this.constructor3D(t,"point3d"),this.board.finalizeAdding(this),this.coords=[0,0,0,0],this.F=e,this.slide=i,this.X=function(){return this.coords[1]},this.Y=function(){return this.coords[2]},this.Z=function(){return this.coords[3]},this._params=[],this._c2d=null,this.methodMap=utils_type.A.deepCopy(this.methodMap,{})},jxg.A.Point3D.prototype=new jxg.A.GeometryElement,utils_type.A.copyPrototypeMethods(jxg.A.Point3D,jxg.A.GeometryElement3D,"constructor3D"),jxg.A.extend(jxg.A.Point3D.prototype,{updateCoords:function(){var t;if(utils_type.A.isFunction(this.F))this.coords=utils_type.A.evaluate(this.F),this.coords.unshift(1);else for(this.coords[0]=1,t=0;t<3;t++)utils_type.A.isFunction(this.F[t])&&(this.coords[t+1]=utils_type.A.evaluate(this.F[t]));return this},initCoords:function(){var t;if(utils_type.A.isFunction(this.F))this.coords=utils_type.A.evaluate(this.F),this.coords.unshift(1);else for(this.coords[0]=1,t=0;t<3;t++)this.coords[t+1]=utils_type.A.evaluate(this.F[t]);return this},normalizeCoords:function(){return Math.abs(this.coords[0])>math.A.eps&&(this.coords[1]/=this.coords[0],this.coords[2]/=this.coords[0],this.coords[3]/=this.coords[0],this.coords[0]=1),this},setPosition:function(t,e){var i=this.coords;return 3===t.length?(i[0]=1,i[1]=t[0],i[2]=t[1],i[3]=t[2]):(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=t[2],this.normalizeCoords()),this},update:function(t){var e,i;return this.element2D.draggable()&&0!==geometry.A.distance(this._c2d,this.element2D.coords.usrCoords)?this.slide?(this.coords=this.slide.projectScreenCoords([this.element2D.X(),this.element2D.Y()],this._params),this.element2D.coords.setCoordinates(constants.A.COORDS_BY_USER,this.view.project3DTo2D(this.coords))):(this.view.isVerticalDrag()?e=this.view.project2DTo3DVertical(this.element2D,this.coords):(i=[1,0,0,this.coords[3]],e=this.view.project2DTo3DPlane(this.element2D,[1,0,0,1],i)),0!==e[0]&&(this.coords=this.view.project3DToCube(e))):(this.updateCoords(),this.slide&&(this.coords=this.slide.projectCoords([this.X(),this.Y(),this.Z()],this._params)),this.element2D.coords.setCoordinates(constants.A.COORDS_BY_USER,this.view.project3DTo2D([1,this.X(),this.Y(),this.Z()]))),this._c2d=this.element2D.coords.usrCoords.slice(),this},updateRenderer:function(){return this.needsUpdate=!1,this},isIllDefined:function(){return utils_type.A.cmpArrays(this.coords,[0,0,0,0])},distance:function(t){var e=math.A.eps*math.A.eps,i=this.coords,s=t.coords;return i[0]*i[0]>e&&s[0]*s[0]>e?math.A.hypot(s[1]-i[1],s[2]-i[2],s[3]-i[3]):Number.POSITIVE_INFINITY},__evt__update3D:function(t){}}),jxg.A.createPoint3D=function(t,e,i){var s,r,o,n,a,l=e[0];if(o=e.length>2&&utils_type.A.exists(e[e.length-1].is3D)?e.pop():null,2===e.length)r=e[1];else{if(4!==e.length)throw new Error("JSXGraph: Can't create point3d with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [[x,y,z]], [x,y,z]");r=e.slice(1)}return s=utils_type.A.copyAttributes(i,t.options,"point3d"),(a=new jxg.A.Point3D(l,r,o,s)).initCoords(),n=l.project3DTo2D(a.coords),s=a.setAttr2D(s),a.element2D=l.create("point",n,s),a.addChild(a.element2D),a.inherits.push(a.element2D),a.element2D.setParents(a),a.slide&&(a.slide.addChild(a),a.setParents(a.slide)),a._c2d=a.element2D.coords.usrCoords.slice(),a},jxg.A.registerElement("point3d",jxg.A.createPoint3D),jxg.A.Curve3D=function(t,e,i,s,r,o,n){this.constructor(t.board,n,constants.A.OBJECT_TYPE_CURVE3D,constants.A.OBJECT_CLASS_3D),this.constructor3D(t,"curve3d"),this.board.finalizeAdding(this),this.F=e,this.X=i,this.Y=s,this.Z=r,this.dataX=null,this.dataY=null,this.dataZ=null,null!==this.F&&(this.X=function(t){return this.F(t)[0]},this.Y=function(t){return this.F(t)[1]},this.Z=function(t){return this.F(t)[2]}),this.range=o,this.methodMap=utils_type.A.deepCopy(this.methodMap,{})},jxg.A.Curve3D.prototype=new jxg.A.GeometryElement,utils_type.A.copyPrototypeMethods(jxg.A.Curve3D,jxg.A.GeometryElement3D,"constructor3D"),jxg.A.extend(jxg.A.Curve3D.prototype,{updateDataArray2D:function(){var t,e,i,s,r,o,n,a,l,h=utils_type.A.evaluate(this.visProp.numberpointshigh),u=[0,0,0];if(n=[],a=[],utils_type.A.exists(this.dataX))for(h=this.dataX.length,o=0;o<h;o++)u=[this.dataX[o],this.dataY[o],this.dataZ[o]],r=this.view.project3DTo2D(u),n.push(r[1]),a.push(r[2]);else if(utils_type.A.isArray(this.X))for(h=this.X.length,o=0;o<h;o++)u=[this.X[o],this.Y[o],this.Z[o]],r=this.view.project3DTo2D(u),n.push(r[1]),a.push(r[2]);else for(t=utils_type.A.evaluate(this.range),e=utils_type.A.evaluate(t[0]),s=((i=utils_type.A.evaluate(t[1]))-e)/(h-1),l=0,o=e;l<h&&o<=i;l++,o+=s)u=null!==this.F?this.F(o):[this.X(o),this.Y(o),this.Z(o)],r=this.view.project3DTo2D(u),n.push(r[1]),a.push(r[2]);return{X:n,Y:a}},updateDataArray:function(){},update:function(){return this.updateDataArray(),this},updateRenderer:function(){return this.needsUpdate=!1,this},initParamsIfNeeded:function(t){0===t.length&&t.unshift(.5*(this.range[0]+this.range[1]))},projectCoords:function(t,e){return this.initParamsIfNeeded(e),geometry.A.projectCoordsToParametric(t,this,e)},projectScreenCoords:function(t,e){return this.initParamsIfNeeded(e),geometry.A.projectScreenCoordsToParametric(t,this,e)}}),jxg.A.createCurve3D=function(t,e,i){var s,r,o,n,a,l,h,u=e[0];return 3===e.length?(s=e[1],a=e[2],r=null,o=null,n=null):(r=e[1],o=e[2],n=e[3],a=e[4],s=null),l=utils_type.A.copyAttributes(i,t.options,"curve3d"),l=(h=new jxg.A.Curve3D(u,s,r,o,n,a,l)).setAttr2D(l),h.element2D=u.create("curve",[[],[]],l),h.element2D.updateDataArray=function(){var t=h.updateDataArray2D();this.dataX=t.X,this.dataY=t.Y},h.addChild(h.element2D),h.inherits.push(h.element2D),h.element2D.setParents(h),h.element2D.prepareUpdate().update(),t.isSuspendedUpdate||h.element2D.updateVisibility().updateRenderer(),h},jxg.A.registerElement("curve3d",jxg.A.createCurve3D),jxg.A.createVectorfield3D=function(t,e,i){var s,r,o=e[0];if(!(e.length>=5&&(utils_type.A.isArray(e[1])||utils_type.A.isFunction(e[0])||utils_type.A.isString(e[0]))&&utils_type.A.isArray(e[2])&&3===e[1].length&&utils_type.A.isArray(e[3])&&3===e[2].length&&utils_type.A.isArray(e[4])&&3===e[3].length))throw new Error("JSXGraph: Can't create vector field 3D with parent types '"+typeof e[0]+"', '"+typeof e[1]+"', '"+typeof e[2]+"'.'"+typeof e[1]+"', ");return r=utils_type.A.copyAttributes(i,t.options,"vectorfield3d"),(s=o.create("curve3d",[[],[],[]],r)).setF=function(t,e){var i,r,o;return utils_type.A.isArray(t)?(i=utils_type.A.createFunction(t[0],this.board,e),r=utils_type.A.createFunction(t[1],this.board,e),o=utils_type.A.createFunction(t[2],this.board,e),this.F=function(t,e,s){return[i(t,e,s),r(t,e,s),o(t,e,s)]}):this.F=utils_type.A.createFunction(t,s.board,e),this},s.setF(e[1],"x, y, z"),s.xData=e[2],s.yData=e[3],s.zData=e[4],s.updateDataArray=function(){var e,i,s,r,o,n,a,l,h,u,c,d,p,_,f,A,g,m=utils_type.A.evaluate(this.visProp.scale),y=[utils_type.A.evaluate(this.xData[0]),utils_type.A.evaluate(this.yData[0]),utils_type.A.evaluate(this.zData[0])],b=[utils_type.A.evaluate(this.xData[1]),utils_type.A.evaluate(this.yData[1]),utils_type.A.evaluate(this.zData[1])],v=[utils_type.A.evaluate(this.xData[2]),utils_type.A.evaluate(this.yData[2]),utils_type.A.evaluate(this.zData[2])],C=[(v[0]-y[0])/b[0],(v[1]-y[1])/b[1],(v[2]-y[2])/b[2]],P=utils_type.A.evaluate(this.visProp.arrowhead.enabled);for(P&&(p=utils_type.A.evaluate(this.visProp.arrowhead.size),g=utils_type.A.evaluate(this.visProp.arrowhead.angle),_=p/t.unitX,f=p/t.unitY,A=p/Math.sqrt(t.unitX*t.unitY)),this.dataX=[],this.dataY=[],this.dataZ=[],i=0,n=y[0];i<=b[0];n+=C[0],i++)for(s=0,a=y[1];s<=b[1];a+=C[1],s++)for(e=0,l=y[2];e<=b[2];l+=C[2],e++)r=this.F(n,a,l),(o=math.A.norm(r))<Number.EPSILON||(r[0]*=m,r[1]*=m,r[2]*=m,utils_type.A.concat(this.dataX,[n,n+r[0],NaN]),utils_type.A.concat(this.dataY,[a,a+r[1],NaN]),utils_type.A.concat(this.dataZ,[l,l+r[2],NaN]),P&&(o*=m,h=Math.atan2(r[1],r[0]),u=(d=Math.asin(r[2]/o))-g,c=d+g,utils_type.A.concat(this.dataX,[n+r[0]-_*Math.cos(h)*Math.cos(u),n+r[0],n+r[0]-_*Math.cos(h)*Math.cos(c),NaN]),utils_type.A.concat(this.dataY,[a+r[1]-f*Math.sin(h)*Math.cos(u),a+r[1],a+r[1]-f*Math.sin(h)*Math.cos(c),NaN]),utils_type.A.concat(this.dataZ,[l+r[2]-A*Math.sin(c),l+r[2],l+r[2]-A*Math.sin(u),NaN])))},s.methodMap=utils_type.A.deepCopy(s.methodMap,{setF:"setF"}),s},jxg.A.registerElement("vectorfield3D",jxg.A.createVectorfield3D),jxg.A.Line3D=function(t,e,i,s,r){this.constructor(t.board,r,constants.A.OBJECT_TYPE_LINE3D,constants.A.OBJECT_CLASS_3D),this.constructor3D(t,"line3d"),this.board.finalizeAdding(this),this.point=e,this.direction=i,this.range=s||[-1/0,1/0],this.point1=null,this.point2=null,this.methodMap=utils_type.A.deepCopy(this.methodMap,{})},jxg.A.Line3D.prototype=new jxg.A.GeometryElement,utils_type.A.copyPrototypeMethods(jxg.A.Line3D,jxg.A.GeometryElement3D,"constructor3D"),jxg.A.extend(jxg.A.Line3D.prototype,{getPointCoords:function(t){var e,i,s,r=[];if(e=[this.point.X(),this.point.Y(),this.point.Z()],utils_type.A.isFunction(this.direction))r=this.direction();else for(i=1;i<4;i++)r.push(utils_type.A.evaluate(this.direction[i]));return s=utils_type.A.evaluate(t),t=this.view.intersectionLineCube(e,r,s),[e[0]+r[0]*t,e[1]+r[1]*t,e[2]+r[2]*t]},update:function(){return this},updateRenderer:function(){return this.needsUpdate=!1,this},projectCoords:function(t){var e,i=this.getPointCoords(0),s=this.getPointCoords(1),r=[s[0]-i[0],s[1]-i[1],s[2]-i[2]],o=[t[0]-i[0],t[1]-i[1],t[2]-i[2]],n=math.A.innerProduct(o,r)/math.A.innerProduct(r,r),a=Math.min(Math.max(n,this.range[0]),this.range[1]);return(e=this.getPointCoords(a).slice()).unshift(1),e},projectScreenCoords:function(t){var e,i,s,r=this.getPointCoords(0),o=this.getPointCoords(1),n=this.view.project3DTo2D(r).slice(1,3),a=this.view.project3DTo2D(o).slice(1,3),l=[a[0]-n[0],a[1]-n[1]],h=math.A.innerProduct(l,l),u=[t[0]-n[0],t[1]-n[1]],c=math.A.innerProduct(u,l)/h;if("central"===this.view.projectionType){const t=this.getPointCoords(.5),i=this.view.project3DTo2D(t).slice(1,3),s=[i[0]-n[0],i[1]-n[1]],r=math.A.innerProduct(s,l)/h;e=(1-r)*c/((1-2*r)*c+r)}else e=c;return i=Math.min(Math.max(e,this.range[0]),this.range[1]),(s=this.getPointCoords(i).slice()).unshift(1),s}}),jxg.A.createLine3D=function(t,e,i){var s,r,o,n,a,l,h,u,c,d=e[0];return s=utils_type.A.copyAttributes(i,t.options,"line3d"),utils_type.A.isPoint3D(e[2])||3===e.length&&(utils_type.A.isArray(e[2])||utils_type.A.isFunction(e[2]))?(l=utils_type.A.providePoints3D(d,[e[1]],i,"line3d",["point1"])[0],h=utils_type.A.providePoints3D(d,[e[2]],i,"line3d",["point2"])[0],n=function(){return[h.X()-l.X(),h.Y()-l.Y(),h.Z()-l.Z()]},a=[0,1],c=new jxg.A.Line3D(d,l,n,a,s),(u=utils_type.A.providePoints3D(d,[[0,0,0],[0,0,0]],{visible:!1},"line3d",["point1","point2"]))[0].F=function(){var t=0;return utils_type.A.evaluate(c.visProp.straightfirst)&&(t=-1/0),c.getPointCoords(t)},u[1].F=function(){var t=1;return utils_type.A.evaluate(c.visProp.straightlast)&&(t=1/0),c.getPointCoords(t)},u[0].prepareUpdate().update(),u[1].prepareUpdate().update(),(s=c.setAttr2D(s)).straightfirst=!1,s.straightlast=!1,c.element2D=d.create("segment",[u[0].element2D,u[1].element2D],s),c.endpoints=u,c.addChild(u[0]),c.addChild(u[1]),c.setParents(u)):(o=utils_type.A.providePoints3D(d,[e[1]],i,"line3d",["point"])[0],utils_type.A.isFunction(e[2])?n=e[2]:3===e[2].length?n=[1].concat(e[2]):4===e[2].length&&(n=e[2]),a=e[3],r=utils_type.A.providePoints3D(d,[[0,0,0],[0,0,0]],i,"line3d",["point1","point2"]),c=new jxg.A.Line3D(d,o,n,a,s),r[0].F=function(){return c.getPointCoords(utils_type.A.evaluate(c.range[0]))},r[0].prepareUpdate().update(),l=r[0],r[1].F=function(){return c.getPointCoords(utils_type.A.evaluate(c.range[1]))},r[1].prepareUpdate().update(),h=r[1],(s=c.setAttr2D(s)).straightfirst=!1,s.straightlast=!1,c.element2D=d.create("segment",[l.element2D,h.element2D],s),c.endpoints=r),c.addChild(c.element2D),c.inherits.push(c.element2D),c.element2D.setParents(c),c.point1=l,c.point2=h,c.point1._is_new?(c.addChild(c.point1),delete c.point1._is_new):c.point1.addChild(c),c.point2._is_new?(c.addChild(c.point2),delete c.point2._is_new):c.point2.addChild(c),utils_type.A.exists(o)&&(o._is_new?(c.addChild(o),delete o._is_new):o.addChild(c)),c.update(),c.element2D.prepareUpdate().update().updateRenderer(),c},jxg.A.registerElement("line3d",jxg.A.createLine3D),jxg.A.Plane3D=function(t,e,i,s,r,o,n){this.constructor(t.board,n,constants.A.OBJECT_TYPE_PLANE3D,constants.A.OBJECT_CLASS_3D),this.constructor3D(t,"plane3d"),this.board.finalizeAdding(this),this.point=e,this.direction1=i,this.direction2=r,this.range1=s||[-1/0,1/0],this.range2=o||[-1/0,1/0],this.vec1=[0,0,0],this.vec2=[0,0,0],this.grid=null,this.normal=[0,0,0],this.d=0,this.updateNormal(),this.methodMap=utils_type.A.deepCopy(this.methodMap,{})},jxg.A.Plane3D.prototype=new jxg.A.GeometryElement,utils_type.A.copyPrototypeMethods(jxg.A.Plane3D,jxg.A.GeometryElement3D,"constructor3D"),jxg.A.extend(jxg.A.Plane3D.prototype,{updateNormal:function(){var t,e;for(t=0;t<3;t++)this.vec1[t]=utils_type.A.evaluate(this.direction1[t]),this.vec2[t]=utils_type.A.evaluate(this.direction2[t]);if(this.normal=math.A.crossProduct(this.vec1,this.vec2),e=math.A.norm(this.normal),Math.abs(e)>math.A.eps)for(t=0;t<3;t++)this.normal[t]/=e;return this.d=math.A.innerProduct(this.point.coords.slice(1),this.normal,3),this},updateDataArray:function(){var t,e,i,s,r,o,n,a,l,h,u,c,d,p,_=["xPlaneRear","yPlaneRear","zPlaneRear"],f=[],A=[0,0,0],g=[0,0,0],m=[0,0,0],y=[0,0,0],b=this.view;if(this.dataX=[],this.dataY=[],this.updateNormal(),"axisplane3d"!==this.elType&&b.defaultAxes&&utils_type.A.evaluate(this.range1[0])===-1/0&&utils_type.A.evaluate(this.range1[1])===1/0&&utils_type.A.evaluate(this.range2[0])===-1/0&&utils_type.A.evaluate(this.range2[1])===1/0){for(h=0;h<_.length;h++){if(3===(y=b.intersectionPlanePlane(this,b.defaultAxes[_[h]]))[0].length&&3===y[1].length){for(l=0;l<f.length&&!(geometry.A.distance(y[0],f[l][0],3)<math.A.eps&&geometry.A.distance(y[1],f[l][1],3)<math.A.eps||geometry.A.distance(y[0],f[l][1],3)<math.A.eps&&geometry.A.distance(y[1],f[l][0],3)<math.A.eps);l++);l===f.length&&f.push(y.slice())}if((y=[0,0,0])[h]=b.bbox3D[h][1],a=math.A.innerProduct(y,b.defaultAxes[_[h]].normal,3),3===(y=b.intersectionPlanePlane(this,b.defaultAxes[_[h]],a))[0].length&&3===y[1].length){for(l=0;l<f.length&&!(geometry.A.distance(y[0],f[l][0],3)<math.A.eps&&geometry.A.distance(y[1],f[l][1],3)<math.A.eps||geometry.A.distance(y[0],f[l][1],3)<math.A.eps&&geometry.A.distance(y[1],f[l][0],3)<math.A.eps);l++);l===f.length&&f.push(y.slice())}}d=0,l=0;do{for(3===(y=f[d][l]).length&&(r=b.project3DTo2D(y),this.dataX.push(r[1]),this.dataY.push(r[2])),l=(l+1)%2,y=f[d][l],p=d,h=0;h<f.length;h++){if(h!==d&&geometry.A.distance(y,f[h][0])<math.A.eps){d=h,l=0;break}if(h!==d&&geometry.A.distance(y,f[h][1])<math.A.eps){d=h,l=1;break}}if(d===p){console.log("Error: update plane3d: did not find next",d);break}}while(0!==d);r=b.project3DTo2D(f[0][0]),this.dataX.push(r[1]),this.dataY.push(r[2])}else{for(t=utils_type.A.evaluate(this.range1[0]),e=utils_type.A.evaluate(this.range1[1]),i=utils_type.A.evaluate(this.range2[0]),s=utils_type.A.evaluate(this.range2[1]),m=this.point.coords.slice(1),A=this.vec1.slice(),g=this.vec2.slice(),o=math.A.norm(A,3),n=math.A.norm(g,3),l=0;l<3;l++)A[l]/=o,g[l]/=n;for(h=0;h<4;h++){switch(h){case 0:u=t,c=i;break;case 1:u=e,c=i;break;case 2:u=e,c=s;break;case 3:u=t,c=s}for(l=0;l<3;l++)y[l]=m[l]+u*A[l]+c*g[l];r=b.project3DTo2D(y),this.dataX.push(r[1]),this.dataY.push(r[2])}this.dataX.push(this.dataX[0]),this.dataY.push(this.dataY[0])}return{X:this.dataX,Y:this.dataY}},update:function(){return this},updateRenderer:function(){return this.needsUpdate=!1,this}}),jxg.A.createPlane3D=function(t,e,i){var s,r,o,n,a=e[0],l=e[2],h=e[3],u=e[4]||[-1/0,1/0],c=e[5]||[-1/0,1/0];return r=utils_type.A.providePoints3D(a,[e[1]],i,"plane3d",["point"])[0],s=utils_type.A.copyAttributes(i,t.options,"plane3d"),o=new jxg.A.Plane3D(a,r,l,u,h,c,s),r.addChild(o),s=o.setAttr2D(s),o.element2D=a.create("curve",[[],[]],s),o.element2D.updateDataArray=function(){var t=o.updateDataArray();this.dataX=t.X,this.dataY=t.Y},o.addChild(o.element2D),o.inherits.push(o.element2D),o.element2D.setParents(o),s=utils_type.A.copyAttributes(i.mesh3d,t.options,"mesh3d"),Math.abs(o.range1[0])!==1/0&&Math.abs(o.range1[1])!==1/0&&Math.abs(o.range2[0])!==1/0&&Math.abs(o.range2[1])!==1/0&&(n=a.create("mesh3d",[function(){return r.coords},l,u,h,c],s),o.grid=n,o.addChild(n),o.inherits.push(n),n.setParents(o)),o.element2D.prepareUpdate().update(),t.isSuspendedUpdate||o.element2D.updateVisibility().updateRenderer(),o},jxg.A.registerElement("plane3d",jxg.A.createPlane3D),jxg.A.createIntersectionLine3D=function(t,e,i){var s,r,o,n=e[0],a=e[1],l=e[2],h=utils_type.A.copyAttributes(i,t.options,"intersectionline3d"),u=[];for(r=0;r<2;r++)o=geometry.A.intersectionFunction3D(n,a,l,r),u[r]=n.create("point3d",o,h["point"+(r+1)]);s=n.create("line3d",u,h);try{a.addChild(s),l.addChild(s)}catch(t){throw new Error("JSXGraph: Can't create 'intersection' with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.")}return s.type=constants.A.OBJECT_TYPE_INTERSECTION_LINE3D,s.elType="intersectionline3d",s.setParents([a.id,l.id]),s},jxg.A.registerElement("intersectionline3d",jxg.A.createIntersectionLine3D),jxg.A.Polygon3D=function(t,e,i){var s;for(this.constructor(t.board,i,constants.A.OBJECT_TYPE_POLYGON3D,constants.A.OBJECT_CLASS_3D),this.constructor3D(t,"polygon3d"),this.board.finalizeAdding(this),this.vertices=[],s=0;s<e.length;s++)this.vertices[s]=this.board.select(e[s]),this.vertices[s]._is_new&&(delete this.vertices[s]._is_new,this.vertices[s]._is_new_pol=!0)},jxg.A.Polygon3D.prototype=new jxg.A.GeometryElement,utils_type.A.copyPrototypeMethods(jxg.A.Polygon3D,jxg.A.GeometryElement3D,"constructor3D"),jxg.A.extend(jxg.A.Polygon3D.prototype,{update:function(){return this},updateRenderer:function(){return this.needsUpdate=!1,this}}),jxg.A.createPolygon3D=function(t,e,i){var s,r,o,n,a,l,h=e[0],u=[],c=[],d=!1;if(a=utils_type.A.copyAttributes(i,t.options,"polygon3d"),null===(n=t.select(e[1]))&&(n=e[1]),utils_type.A.isObject(n)&&n.type===constants.A.OBJECT_TYPE_POLYGON3D&&utils_type.A.isTransformationOrArray(e[2]))for(d=!0,o=n.vertices.length-1,l=utils_type.A.copyAttributes(i,t.options,"polygon3d","vertices"),r=0;r<o;r++)l.withlabel&&(l.name=""===n.vertices[r].name?"":n.vertices[r].name+"'"),u.push(t.create("point3d",[n.vertices[r],e[2]],l));else if(!1===(u=utils_type.A.providePoints3D(h,e.slice(1),i,"polygon3d",["vertices"])))throw new Error("JSXGraph: Can't create polygon3d with parent types other than 'point' and 'coordinate arrays' or a function returning an array of coordinates. Alternatively, a polygon3d and a transformation can be supplied");for((s=new jxg.A.Polygon3D(h,u,a)).isDraggable=!0,a=s.setAttr2D(a),r=0;r<u.length;r++)c.push(u[r].element2D);if(s.element2D=t.create("polygon",c,a),s.addChild(s.element2D),s.inherits.push(s.element2D),s.element2D.setParents(s),d)for(s.prepareUpdate().update().updateVisibility().updateRenderer(),o=n.vertices.length-1,r=0;r<o;r++)u[r].prepareUpdate().update().updateVisibility().updateRenderer();return s},jxg.A.registerElement("polygon3d",jxg.A.createPolygon3D),jxg.A.Sphere3D=function(t,e,i,s,r){this.constructor(t.board,r,constants.A.OBJECT_TYPE_SPHERE3D,constants.A.OBJECT_CLASS_3D),this.constructor3D(t,"sphere3d"),this.board.finalizeAdding(this),this.method=e,this.center=this.board.select(i),this.point2=null,this.points=[],this.element2D=null,this.aux2D=[],this.projectionType=t.projectionType,"twoPoints"===e?(this.point2=this.board.select(s),this.radius=this.Radius()):"pointRadius"===e&&(this.updateRadius=utils_type.A.createFunction(s,this.board),this.updateRadius(),this.addParentsFromJCFunctions([this.updateRadius])),utils_type.A.exists(this.center._is_new)?(this.addChild(this.center),delete this.center._is_new):this.center.addChild(this),"twoPoints"===e&&(utils_type.A.exists(this.point2._is_new)?(this.addChild(this.point2),delete this.point2._is_new):this.point2.addChild(this)),this.methodMap=utils_type.A.deepCopy(this.methodMap,{center:"center",point2:"point2",Radius:"Radius"})},jxg.A.Sphere3D.prototype=new jxg.A.GeometryElement,utils_type.A.copyPrototypeMethods(jxg.A.Sphere3D,jxg.A.GeometryElement3D,"constructor3D"),jxg.A.extend(jxg.A.Sphere3D.prototype,{update:function(){return this.projectionType!==this.view.projectionType&&this.rebuildProjection(),this},updateRenderer:function(){return this.needsUpdate=!1,this},setRadius:function(t){return this.updateRadius=utils_type.A.createFunction(t,this.board),this.addParentsFromJCFunctions([this.updateRadius]),this.board.update(),this},Radius:function(t){return utils_type.A.exists(t)?(this.setRadius(t),this.Radius()):"twoPoints"===this.method?this.center.isIllDefined()||this.point2.isIllDefined()?NaN:this.center.distance(this.point2):"pointRadius"===this.method?Math.abs(this.updateRadius()):NaN},focusFn:function(t){const e=this;return function(){const i=e.view.cameraTransform[3],s=e.Radius();return e.view.project3DTo2D([e.center.X()+t*s*i[1],e.center.Y()+t*s*i[2],e.center.Z()+t*s*i[3]]).slice(1,3)}},innerVertexFn:function(){const t=this;return function(){const e=t.view,i=e.worldToView(t.center.coords,!1),s=Math.sqrt(i[0]*i[0]+i[1]*i[1]),r=e.cameraTransform,o=[-(i[0]*r[1][1]+i[1]*r[2][1])/s,-(i[0]*r[1][2]+i[1]*r[2][2])/s,-(i[0]*r[1][3]+i[1]*r[2][3])/s],n=t.Radius(),a=Math.atan(-s/i[2])+Math.acos(n/math.A.norm(i)),l=Math.cos(a),h=Math.sin(a);return e.project3DTo2D([t.center.X()+n*(h*o[0]+l*r[3][1]),t.center.Y()+n*(h*o[1]+l*r[3][2]),t.center.Z()+n*(h*o[2]+l*r[3][3])])}},buildCentralProjection:function(){const t=this.view,e={visible:!1,withLabel:!1},i=t.create("point",this.focusFn(-1),e),s=t.create("point",this.focusFn(1),e),r=t.create("point",this.innerVertexFn(t),e);this.aux2D=[i,s,r],this.element2D=t.create("ellipse",this.aux2D,this.visProp)},buildParallelProjection:function(){const t=this;this.aux2D=[],this.element2D=this.view.create("circle",[function(){const e=[1,t.center.X(),t.center.Y(),t.center.Z()];return t.view.project3DTo2D(e)},function(){const e=t.view.bbox3D[0][1]-t.view.bbox3D[0][0];return t.Radius()*t.view.size[0]/e}],this.visProp)},rebuildProjection:function(){if(this.element2D){this.view.board.removeObject(this.element2D);for(let t in this.aux2D)this.view.board.removeObject(this.aux2D[t])}this.projectionType=this.view.projectionType,"central"===this.projectionType?this.buildCentralProjection():this.buildParallelProjection(),this.addChild(this.element2D),this.inherits.push(this.element2D)}}),jxg.A.createSphere3D=function(t,e,i){var s,r,o,n,a,l,h=e[0];for(s=utils_type.A.copyAttributes(i,t.options,"sphere3d"),r=[],l=1;l<e.length;l++)if(utils_type.A.isPointType3D(t,e[l])){if(o=0===r.length?"center":"point",!1===(n=utils_type.A.providePoints3D(h,[e[l]],i,"sphere3d",[o])[0]))throw new Error("JSXGraph: Can't create sphere3d from this type. Please provide a point type.");r.push(n)}else r.push(e[l]);if(utils_type.A.isPoint3D(r[0])&&utils_type.A.isPoint3D(r[1]))a=new jxg.A.Sphere3D(h,"twoPoints",r[0],r[1],s);else if((utils_type.A.isNumber(r[0])||utils_type.A.isFunction(r[0])||utils_type.A.isString(r[0]))&&utils_type.A.isPoint3D(r[1]))a=new jxg.A.Sphere3D(h,"pointRadius",r[1],r[0],s);else{if(!(utils_type.A.isNumber(r[1])||utils_type.A.isFunction(r[1])||utils_type.A.isString(r[1]))||!utils_type.A.isPoint3D(r[0]))throw new Error("JSXGraph: Can't create sphere3d with parent types '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point], [point,number], [point,function]");a=new jxg.A.Sphere3D(h,"pointRadius",r[0],r[1],s)}return a.rebuildProjection(),a.element2D.prepareUpdate().update().updateRenderer(),a},jxg.A.registerElement("sphere3d",jxg.A.createSphere3D),jxg.A.Surface3D=function(t,e,i,s,r,o,n,a){this.constructor(t.board,a,constants.A.OBJECT_TYPE_SURFACE3D,constants.A.OBJECT_CLASS_3D),this.constructor3D(t,"surface3d"),this.board.finalizeAdding(this),this.F=e,this.X=i,this.Y=s,this.Z=r,null!==this.F&&(this.X=function(t,e){return this.F(t,e)[0]},this.Y=function(t,e){return this.F(t,e)[1]},this.Z=function(t,e){return this.F(t,e)[2]}),this.range_u=o,this.range_v=n,this.methodMap=utils_type.A.deepCopy(this.methodMap,{})},jxg.A.Surface3D.prototype=new jxg.A.GeometryElement,utils_type.A.copyPrototypeMethods(jxg.A.Surface3D,jxg.A.GeometryElement3D,"constructor3D"),jxg.A.extend(jxg.A.Surface3D.prototype,{updateDataArray:function(){var t,e,i=utils_type.A.evaluate(this.visProp.stepsu),s=utils_type.A.evaluate(this.visProp.stepsv),r=utils_type.A.evaluate(this.range_u),o=utils_type.A.evaluate(this.range_v);return t=null!==this.F?this.F:[this.X,this.Y,this.Z],r.push(i),o.push(s),{X:(e=this.view.getMesh(t,r,o))[0],Y:e[1]}},update:function(){return this},updateRenderer:function(){return this.needsUpdate=!1,this},initParamsIfNeeded:function(t){0===t.length&&t.unshift(.5*(this.range_u[0]+this.range_u[1]),.5*(this.range_v[0]+this.range_v[1]))},projectCoords:function(t,e){return this.initParamsIfNeeded(e),geometry.A.projectCoordsToParametric(t,this,e)},projectScreenCoords:function(t,e){return this.initParamsIfNeeded(e),geometry.A.projectScreenCoordsToParametric(t,this,e)}}),jxg.A.createParametricSurface3D=function(t,e,i){var s,r,o,n,a,l,h,u,c=e[0];return 4===e.length?(s=e[1],a=e[2],l=e[3],r=null,o=null,n=null):(r=e[1],o=e[2],n=e[3],a=e[4],l=e[5],s=null),h=utils_type.A.copyAttributes(i,t.options,"surface3d"),h=(u=new jxg.A.Surface3D(c,s,r,o,n,a,l,h)).setAttr2D(h),u.element2D=c.create("curve",[[],[]],h),u.element2D.updateDataArray=function(){var t=u.updateDataArray();this.dataX=t.X,this.dataY=t.Y},u.addChild(u.element2D),u.inherits.push(u.element2D),u.element2D.setParents(u),u.element2D.prepareUpdate().update(),t.isSuspendedUpdate||u.element2D.updateVisibility().updateRenderer(),u},jxg.A.registerElement("parametricsurface3d",jxg.A.createParametricSurface3D),jxg.A.createFunctiongraph3D=function(t,e,i){var s=e[0],r=e[1],o=e[2],n=e[3];return s.create("parametricsurface3d",[function(t,e){return t},function(t,e){return e},r,o,n],i)},jxg.A.registerElement("functiongraph3d",jxg.A.createFunctiongraph3D);let size=.75,color="#000";jxg.A.themes.mono_thin={board:{showInfobox:!1,showCopyright:!0,defaultAxes:{x:{ticks:{minorTicks:0,majorHeight:10,majorTickEndings:[1,0]}},y:{ticks:{minorTicks:0,majorHeight:10,majorTickEndings:[0,1]}}}},navbar:{strokeColor:"#bbb",fillColor:"none"},elements:{strokeColor:color,highlightStrokeColor:color,fillColor:"none",highlightFillColor:"none",strokeOpacity:.6,highlightStrokeOpacity:1},angle:{strokeColor:color,fillColor:"#aaaaaa55",fillOpacity:.3,highlightFillColor:"#aaaaaa33",highlightFillOpacity:.3,label:{strokeColor:color}},arc:{strokeColor:color,strokeWidth:size,highlightStrokeColor:color,highlightStrokeWidth:size},axis:{},boxplot:{strokeWidth:size,strokeColor:color,fillColor:color,fillOpacity:.2,highlightStrokeWidth:size,highlightStrokeColor:color,highlightFillColor:color,highlightFillOpacity:.1},circle:{strokeWidth:size,highlightStrokeWidth:1.5*size,strokeColor:color,highlightFillColor:"none",highlightStrokeColor:color,center:{size:size,fillColor:color,strokeColor:color,highlightStrokeWidth:4*size,highlightFillColor:color,highlightStrokeColor:color},point2:{size:size,fillColor:color,strokeColor:color,highlightStrokeWidth:4*size,highlightFillColor:color,highlightStrokeColor:color}},circumcircle:{strokeWidth:size,highlightStrokeWidth:1.5*size,strokeColor:color,highlightFillColor:"none",highlightStrokeColor:color,center:{size:size,fillColor:color,strokeColor:color,highlightStrokeWidth:4*size,highlightFillColor:color,highlightStrokeColor:color}},circumcirclearc:{strokeColor:color,strokeWidth:size,highlightStrokeColor:color,highlightStrokeWidth:size},circumcirclesector:{strokeColor:color,fillColor:"#aaaaaa55",fillOpacity:.3,highlightFillColor:"#aaaaaa33",highlightFillOpacity:.3},comb:{strokeColor:color,strokeWidth:size},conic:{strokeWidth:size,highlightStrokeWidth:1.5*size,strokeColor:color,highlightStrokeColor:color,fillColor:"none",highlightFillColor:"none"},curve:{strokeColor:color,strokeWidth:size,highlightStrokeColor:color,highlightStrokeWidth:size},grid:{strokeWidth:size},hatch:{strokeColor:color,strokeWidth:size},incircle:{strokeWidth:size,highlightStrokeWidth:1.5*size,strokeColor:color,highlightFillColor:"none",highlightStrokeColor:color,center:{size:size,fillColor:color,strokeColor:color,highlightStrokeWidth:4*size,highlightFillColor:color,highlightStrokeColor:color}},inequality:{fillColor:"#aaaaaa55",fillOpacity:.2},label:{strokeColor:color},line:{strokeColor:color,strokeWidth:size,highlightStrokeColor:color,highlightStrokeWidth:size,point1:{size:size,fillColor:color,strokeColor:color,highlightStrokeWidth:4*size,highlightFillColor:color,highlightStrokeColor:color},point2:{size:size,fillColor:color,strokeColor:color,highlightStrokeWidth:4*size,highlightFillColor:color,highlightStrokeColor:color}},normal:{strokeColor:color},parallel:{strokeColor:color},perpendicular:{strokeColor:color},perpendicularsegment:{strokeColor:color},point:{size:size,fillColor:color,strokeColor:color,highlightStrokeWidth:4*size,highlightFillColor:color,highlightStrokeColor:color},polygon:{fillColor:"#aaaaaa55",highlightFillColor:"#aaaaaa33",fillOpacity:.3,highlightFillOpacity:.3,vertices:{size:size,fillColor:color,strokeColor:color,highlightStrokeWidth:4*size,highlightFillColor:color,highlightStrokeColor:color},borders:{strokeColor:color,strokeWidth:size,highlightStrokeColor:color,highlightStrokeWidth:size}},sector:{strokeColor:color,fillColor:"#aaaaaa55",fillOpacity:.3,highlightFillColor:"#aaaaaa33",highlightFillOpacity:.3},semicircle:{center:{size:size,fillColor:color,strokeColor:color,highlightStrokeWidth:4*size,highlightFillColor:color,highlightStrokeColor:color}},slider:{size:size,fillColor:color,strokeColor:color,highlightStrokeWidth:4*size,highlightFillColor:color,highlightStrokeColor:color,baseline:{strokeWidth:size,strokeColor:color,highlightStrokeColor:color},label:{strokeColor:color},highline:{strokeWidth:3*size,name:"",strokeColor:color,highlightStrokeColor:color},ticks:{strokeColor:color}},slopefield:{strokeWidth:.75*size,highlightStrokeWidth:size,highlightStrokeColor:color,highlightStrokeOpacity:.8},tapemeasure:{strokeColor:color,strokeWidth:size,highlightStrokeColor:color,highlightStrokeWidth:size,point1:{size:size,fillColor:color,strokeColor:color,highlightStrokeWidth:4*size,highlightFillColor:color,highlightStrokeColor:color},point2:{size:size,fillColor:color,strokeColor:color,highlightStrokeWidth:4*size,highlightFillColor:color,highlightStrokeColor:color},ticks:{strokeWidth:size}},text:{strokeColor:color},tracecurve:{strokeColor:color},turtle:{strokeWidth:size,strokeColor:color,arrow:{strokeWidth:2*size,strokeColor:"#aaaaaa55"}},vectorfield:{strokeWidth:.75*size,highlightStrokeWidth:size,highlightStrokeColor:color,highlightStrokeOpacity:.8}};var mono_thin=null;const COORDS_BY_SCREEN=jxg.A.COORDS_BY_SCREEN,COORDS_BY_USER=jxg.A.COORDS_BY_USER,Dump=jxg.A.Dump,Expect=jxg.A.Expect,JSXGraph=jxg.A.JSXGraph,Mat=jxg.A.Math,Options=jxg.A.Options,boards=jxg.A.boards,src_elements=jxg.A.elements,palette=jxg.A.palette,paletteWong=jxg.A.paletteWong,Board=jxg.A.Board,Chart=jxg.A.Chart,Circle=jxg.A.Circle,Complex=jxg.A.Complex,Composition=jxg.A.Composition,Coords=jxg.A.Coords,CoordsElement=jxg.A.CoordsElement,Curve=jxg.A.Curve,GeometryElement=jxg.A.GeometryElement,Group=jxg.A.Group,src_Image=jxg.A.Image,JessieCode=jxg.A.JessieCode,Prefix=jxg.A.PrefixParser,Line=jxg.A.Line,Point=jxg.A.Point,Polygon=jxg.A.Polygon,Text=jxg.A.Text,Ticks=jxg.A.Ticks,Transformation=jxg.A.Transformation,Turtle=jxg.A.Turtle,View3D=jxg.A.View3D,LMS2rgb=jxg.A.LMS2rgb,addEvent=jxg.A.addEvent,autoDigits=jxg.A.autoDigits,autoHighlight=jxg.A.autoHighlight,bind=jxg.A.bind,capitalize=jxg.A.capitalize,clearVisPropOld=jxg.A.clearVisPropOld,clone=jxg.A.clone,cloneAndCopy=jxg.A.cloneAndCopy,cmpArrays=jxg.A.cmpArrays,coordsArrayToMatrix=jxg.A.coordsArrayToMatrix,copyAttributes=jxg.A.copyAttributes,createEvalFunction=jxg.A.createEvalFunction,createFunction=jxg.A.createFunction,createHTMLSlider=jxg.A.createHTMLSlider,darkenColor=jxg.A.darkenColor,debug=jxg.A.debug,debugInt=jxg.A.debugInt,debugLine=jxg.A.debugLine,debugWST=jxg.A.debugWST,deepCopy=jxg.A.deepCopy,def=jxg.A.def,deprecated=jxg.A.deprecated,eliminateDuplicates=jxg.A.eliminateDuplicates,escapeHTML=jxg.A.escapeHTML,evalSlider=jxg.A.evalSlider,evaluate=jxg.A.evaluate,filterElements=jxg.A.filterElements,getBoardByContainerId=jxg.A.getBoardByContainerId,getCSSTransformMatrix=jxg.A.getCSSTransformMatrix,getCSSTransform=jxg.A.getCSSTransform,getDimensions=jxg.A.getDimensions,getOffset=jxg.A.getOffset,getPosition=jxg.A.getPosition,getProp=jxg.A.getProp,hex2rgb=jxg.A.hex2rgb,hsv2rgb=jxg.A.hsv2rgb,isAndroid=jxg.A.isAndroid,isApple=jxg.A.isApple,isArray=jxg.A.isArray,isDesktop=jxg.A.isDesktop,isInArray=jxg.A.isInArray,isInObject=jxg.A.isInObject,isMetroApp=jxg.A.isMetroApp,isMobile=jxg.A.isMobile,isMozilla=jxg.A.isMozilla,isBoard=jxg.A.isBoard,isName=jxg.A.isName,isNode=jxg.A.isNode,isNumber=jxg.A.isNumber,isObject=jxg.A.isObject,isPoint=jxg.A.isPoint,isPoint3D=jxg.A.isPoint3D,isPointType=jxg.A.isPointType,isPointType3D=jxg.A.isPointType3D,isString=jxg.A.isString,isTouchDevice=jxg.A.isTouchDevice,isTransformationOrArray=jxg.A.isTransformationOrArray,isWebWorker=jxg.A.isWebWorker,isWebkitAndroid=jxg.A.isWebkitAndroid,isWebkitApple=jxg.A.isWebkitApple,keys=jxg.A.keys,lightenColor=jxg.A.lightenColor,merge=jxg.A.merge,normalizePointFace=jxg.A.normalizePointFace,providePoints=jxg.A.providePoints,registerElement=jxg.A.registerElement,registerReader=jxg.A.registerReader,removeAllEvents=jxg.A.removeAllEvents,removeElementFromArray=jxg.A.removeElementFromArray,removeEvent=jxg.A.removeEvent,rgb2LMS=jxg.A.rgb2LMS,rgb2bw=jxg.A.rgb2bw,rgb2cb=jxg.A.rgb2cb,rgb2css=jxg.A.rgb2css,rgb2hex=jxg.A.rgb2hex,rgb2hsv=jxg.A.rgb2hsv,rgbParser=jxg.A.rgbParser,rgb2rgbo=jxg.A.rgba2rgbo,rgb2rgba=jxg.A.rgbo2rgba,sanitizeHTML=jxg.A.sanitizeHTML,shortcut=jxg.A.shortcut,strBool=jxg.A.str2Bool,supportsCanvas=jxg.A.supportsCanvas,supportsPointerEvents=jxg.A.supportsPointerEvents,supportsSVG=jxg.A.supportsSVG,supportsVML=jxg.A.supportsVML,swap=jxg.A.swap,timeChunk=jxg.A.timedChunk,toFixed=jxg.A.toFixed,toFullscreen=jxg.A.toFullscreen,toJSON=jxg.A.toJSON,trim=jxg.A.trim,trimNumber=jxg.A.trimNumber,truncate=jxg.A.truncate,unescapeHTML=jxg.A.unescapeHTML,uniqueArray=jxg.A.uniqueArray,useBlackWhiteOptions=jxg.A.useBlackWhiteOptions,useStandardOptions=jxg.A.useStandardOptions,warn=jxg.A.warn;env.A.isBrowser?window.JXG=jxg.A:env.A.isWebWorker()&&(self.JXG=jxg.A);var src=jxg.A;return __webpack_exports__=__webpack_exports__.default,__webpack_exports__}()}));