<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * English language pack for availability_treasurehunt
 *
 * @package    availability_treasurehunt
 * @category   string
 * @copyright  2025 Juan Pablo de Castro <juan.pablo.de.castro@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['condition_type'] = 'Condition type';
$string['current_stage'] = 'At specific stage';
$string['description'] = 'Restrict access based on progress in Treasurehunt activities';
$string['error_selectstage'] = 'You must select a stage';
$string['error_selecttreasurehunt'] = 'You must select a Treasurehunt activity';
$string['error_setcondition'] = 'You must set a condition';
$string['full_completion'] = 'Fully completed';
$string['minimum_stages'] = 'Minimum stages';
$string['minimum_time'] = 'Minimum time (minutes)';
$string['missing_stage'] = 'Stage not found';
$string['missing_treasurehunt'] = 'Treasurehunt activity not found';
$string['pluginname'] = 'Restriction by Treasurehunt';
$string['privacy:no_user_data'] = 'The Treasurehunt availability condition does not store any personal data.';
$string['requires_completion'] = 'Requires Treasurehunt completion';
$string['requires_current_stage'] = 'Requires being at stage number {$a->position} of "{$a->roadname}"';
$string['requires_stages'] = 'Requires {$a} completed stages';
$string['requires_time'] = 'Requires {$a} minutes of game time';
$string['requires_treasurehunt'] = 'Requires progress in Treasurehunt';
$string['returnlinktext'] = 'Once finished this, you may want to return to <a href="{$a->returnlink}"><img src="{$a->icon}" alt="Treasurehunt icon"/>Treasurehunt "{$a->treasurehuntname}"</a> activity.';
$string['select_stage'] = 'Select stage';
$string['select_treasurehunt'] = 'Select Treasurehunt';
$string['stage'] = 'Stage';
$string['stages_completed'] = 'Stages completed';
$string['time_played'] = 'Time played (minutes)';
$string['title'] = 'Treasurehunt';
