# Introduction

### Welcome to the Treasurehunt activity for Moodle!

>First off, thank you for considering contributing to Treasurehunt. It's people like you that make Treasurehunt such a great tool.

[source: [Treasurehunt](https://github.com/juacas/Treasurehunt/CONTRIBUTING.md)]

### Please read this guidelines.

Following these guidelines helps to communicate that you respect the time of the developers managing and developing this open source project. In return, they should reciprocate that respect in addressing your issue, assessing changes, and helping you finalize your pull requests.

### What to contribute

Treasurehunt is an open source project and we love to receive contributions from our community — you! There are many ways to contribute, from writing tutorials or blog posts, improving the documentation, submitting bug reports and feature requests or writing code which can be incorporated into Treasurehunt itself.

## About to create a new Github Issue?

We appreciate that. But before you do, please learn our basic rules:

* This is not a support forum. If you have a question, please go to [Moodle forum](https://moodle.org/mod/forum/discuss.php?d=354875).
* Do you have an idea for a new feature? Then don't expect it to be implemented unless you or someone else sends a [pull request](https://help.github.com/articles/using-pull-requests). You might be better to start a discussion on [Moodle forum](https://moodle.org/mod/forum/discuss.php?d=354875).
* Reporting a bug? Please tell us:
  * which version of Moodle you're using
  * which version of smart phone or portable device you're using.
  * How to reproduce it. Bugs with a failing test in a [pull request](https://help.github.com/articles/using-pull-requests) get fixed much quicker. Some bugs may never be fixed.
* Want to paste some code or output? Put \`\`\` on a line above and below your code/output. See [GFM](https://help.github.com/articles/github-flavored-markdown)'s *Fenced Code Blocks* for details.
* We love [pull requests](https://help.github.com/articles/using-pull-requests). But if you don't have a test to go with it we probably won't merge it.

Please, don't use the issue tracker for [support questions]. Check whether [Moodle Forum](https://moodle.org/mod/forum/discuss.php?d=354875) can help with your issue. If your problem is not strictly Treasurehunt specific, general Javascript and PHP communities are generally more active. Stack Overflow is also worth considering.

# Ground Rules
### Set expectations for behavior (yours, and theirs).


> Responsibilities
* Ensure cross-platform compatibility for every change that's accepted. Windows, Mac, Debian & Ubuntu Linux, MySQL, PostgreSQL, etc.
* Create issues for any major changes and enhancements that you wish to make. Discuss things transparently and get community feedback.
* Don't add any classes to the codebase unless absolutely needed. Err on the side of using functions.
* Keep feature versions as small as possible, preferably one new feature per version.

# Your First Contribution
Unsure where to begin contributing to Treasurehunt?
Here are a couple of friendly tutorials you can include: http://makeapullrequest.com/ and http://www.firsttimersonly.com/

Working on your first Pull Request? 
>You can learn how from this *free* series, [How to Contribute to an Open Source Project on GitHub](https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github).

>At this point, you're ready to make your changes! Feel free to ask for help; everyone is a beginner at first :smile_cat:

>If a maintainer asks you to "rebase" your PR, they're saying that a lot of code has changed, and that you need to update your branch so it's easier to merge.

# Getting started

For something that is bigger than a one or two line fix:

1. Create your own fork of the code
2. Do the changes in your fork
3. If you like the change and think the project could use it:
    * Be sure you have followed the code style for the project.
    * Send a pull request indicating that you donate your contribution and adhere to the LICENSE terms of the project.

### If you have a different process for small or "obvious" fixes, let them know.
> Small contributions such as fixing spelling errors, where the content is small enough to not be considered intellectual property, can be submitted by a contributor as a patch, without a CLA.
>As a rule of thumb, changes are obvious fixes if they do not introduce any new functionality or creative thinking. As long as the change does not affect functionality, some likely examples include the following:
* Spelling / grammar fixes
* Typo correction, white space and formatting changes
* Comment clean up
* Bug fixes that change default return values or error codes stored in constants
* Adding logging messages or debugging output
* Changes to ‘metadata’ files like Gemfile, .gitignore, build scripts, etc.
* Moving source files from one directory or package to another

# How to report a bug
### security disclosures first!
If you find a security vulnerability, do NOT open an issue. Email jpdecastro@tel.uva.es instead.
Any security issues should be submitted directly to jpdecastro@tel.uva.es
In order to determine whether you are dealing with a security issue, ask yourself these two questions:
* Can I access something that's not mine, or something I shouldn't have access to?
* Can I disable something for other people?

> If the answer to either of those two questions are "yes", then you're probably dealing with a security issue. Note that even if you answer "no" to both questions, you may still be dealing with a security issue, so if you're unsure, just email us at jpdecastro@tel.uva.es.

### How to file a bug report.
When filing an issue, make sure to answer these five questions:

1. What version of Moodle are you using (Moodle version)?
2. What operating system and processor architecture are you using?
3. What did you do?
4. What did you expect to see?
5. What did you see instead?

# How to suggest a feature or enhancement
If you find yourself wishing for a feature that doesn't exist in Treasurehunt, you are probably not alone. There are bound to be others out there with similar needs. Many of the features that Treasurehunt has today have been added because our users saw the need. Open an issue on our issues list on GitHub which describes the feature you would like to see, why you need it, and how it should work.

# Community
You can contact with the core team on https://moodle.org/mod/forum/discuss.php?d=354875.
