<?php
// This file is part of Treasurehunt for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'treasurehunt', language 'en'
 *
 * @package   mod_treasurehunt
 * @copyright 2016 onwards Adrian Rodriguez Fernandez <huorwhisp@gmail.com>, Juan Pablo de Castro <jpdecastro@tel.uva.es>
 * @author Sp Zoupanos <szoupi@gmail.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
defined('MOODLE_INTERNAL') || die();
$string['activitytoend'] = 'Ολοκληρώστε την επιλεγμένη δραστηριότητα πριν';
$string['activitytoend_help'] = 'Η επιλεγμένη δραστηριότητα πρέπει να ολοκληρωθεί πριν εμφανιστεί η τρέχουσα ένδειξη.
Για να εμφανιστούν οι δραστηριότητες του μαθήματος στον κατάλογο πρέπει να ενεργοποιηθεί η ολοκλήρωση δραστηριότητα στη
ρυθμίσεις του Moodle, στο μάθημα και στην ίδια τη δραστηριότητα.';
$string['activitytoendovercome'] = 'Activity \'<strong>{$a}</strong>\' overcome';
$string['activitytoendwarning'] = 'Θα πρέπει πρώτα να ολοκληρώσετε την δραστηριότητα για να λύσετε';
$string['actnotavailableyet'] = 'Η δραστηριότητα δεν είναι ακόμα διαθέσιμη';
$string['add'] = 'Προσθέστε';
$string['addingroad'] = 'Adding road';
$string['addingstage'] = 'Προστίθεται στάδιο';
$string['addroad_tour'] = 'Προσθέστε μία ή περισσότερες διαδρομές που θα ακολουθήσουν οι συμμετέχοντες.';
$string['addsimplequestion'] = 'Προσθέστε απλή ερώτηση';
$string['addsimplequestion_help'] = 'Προσθέτει μια απλή ερώτηση προτού εμφανίσει την ένδειξη για αυτό το στάδιο';
$string['addstage_tour'] = 'Κάθε διαδρομή πρέπει να έχει δύο ή περισσότερα στάδια. Κάθε στάδιο δίνει ένα στοιχείο για να ανακαλύψετε το επόμενο.';
$string['aerialmap'] = 'Δορυφόρος';
$string['aerialview'] = 'Δορυφόρος';
$string['allowattemptsfromdate'] = 'Επιτρέπονται προσπάθειες από';
$string['allowattemptsfromdate_help'] = 'Εάν είναι ενεργοποιημένo, οι συμμετέχοντες δεν θα μπορούν να παίξουν πριν από αυτή την ημερομηνία.
Αν είναι απενεργοποιημένο, οι συμμετέχοντες θα μπορούν να ξεκινήσουν αμέσως το παιχνίδι.';
$string['alwaysshowdescription'] = 'Η περιγραφή να φαίνεται πάντα';
$string['alwaysshowdescription_help'] = 'Εάν είναι απενεργοποιημένο, η παραπάνω Περιγραφή για το κυνήγι θησαυρού θα γίνει ορατή μόνο στους συμμετέχοντες
στην "Επιτρέπονται προσπάθειες από" ημερομηνία.';
$string['answerwarning'] = 'Πρέπει πρώτα να απαντήσετε στην ερώτηση';
$string['areyousure'] = 'Είστε σίγουρος;';
$string['attempt'] = 'Προσπάθεια';
$string['attempthistory'] = 'Ιστορικό προσπαθειών';
$string['attemptsdeleted'] = 'Οι προσπάθειες για το κυνήγι θησαυρού διαγράφηκαν';
$string['autolocate_tour'] = 'Κατά τη διάρκεια του παιχνιδιού, μπορείτε να τοποθετήσετε τον εαυτό σας γεωγραφικά χρησιμοποιώντας το GPS της συσκευής σας με αυτό το κουμπί. Παραχωρήστε δικαιώματα χρήσης "τοποθεσίας" όταν σας ζητηθεί.';
$string['availability'] = 'Διαθεσιμότητα';
$string['back'] = 'Πίσω';
$string['backtocourse'] = 'Επιστροφή στο μάθημα';
$string['baselayers'] = 'Βασικά στρώματα';
$string['basemaps'] = 'Βασικοί χάρτες';
$string['cancel'] = 'Άκυρο';
$string['changetogroupmode'] = 'Η λειτουργία παιχνιδιού έχει αλλάξει σε Παιχνίδι με Ομάδες';
$string['changetoindividualmode'] = 'Η λειτουργία παιχνιδιού έχει αλλάξει σε Ατομικό Παιχνίδι';
$string['changetoplaywithmove'] = 'Η λειτουργία παιχνιδιού έχει αλλάξει σε Δυναμικό Παιχνίδι';
$string['changetoplaywithoutmoving'] = 'Η λειτουργία παιχνιδιού έχει αλλάξει σε Στατικό Παιχνίδι';
$string['cleartreasurehunt'] = 'Επαναφορά δεδομένων για το Κυνήγι Θησαυρού';
$string['cleartreasurehunt_done'] = 'Πραγματοποιήθηκε επαναφορά δραστηριότητας. Όλες οι δραστηριότητες των συμμετεχόντων έχουν διαγραφεί.';
$string['cleartreasurehuntconfirm'] = 'ΠΡΟΣΟΧΗ με αυτή την ενέργεια. Όλες οι καταγεγραμμένες δραστηριότητες θα διαγραφούν εάν συνεχίσετε. Συνήθως η ενέργεια αυτή είναι απαραίτητη μόνο εάν πρέπει να αλλάξετε τον αριθμό των διαδρομών ή των σταδίων, αλλά η δραστηριότητα είναι μπλοκαρισμένη, επειδή κάποιος έχει αρχίσει να παίζει το παιχνίδι.';
$string['configintro'] = 'Οι τιμές που εισάγετε εδώ ορίζουν τις προεπιλεγμένες τιμές που χρησιμοποιούνται στη φόρμα ρυθμίσεων όταν
δημιουργήστε ένα νέο κυνήγι θησαυρού.';
$string['configmaximumgrade'] = 'Ο προκαθορισμένος βαθμός από τον οποίο προκύπτει αναλογικά ο βαθμός για το Κυνήγι Θησαυρού.';
$string['confirm'] = 'Επιβεβαίωση';
$string['confirmdeletestage'] = 'Το στάδιο διαγράφηκε επιτυχώς';
$string['continue'] = 'Συνέχεια';
$string['correctanswer'] = 'Σωστή απάντηση.';
$string['cutoffdate'] = 'Ημερομηνία λήξης προθεσμίας';
$string['cutoffdate_help'] = 'Αν οριστεί, το Κυνήγι Θησαυρού δεν δέχεται προσπάθειες μετά από αυτή την ημερομηνία χωρίς επέκταση.';
$string['cutoffdatefromdatevalidation'] = 'Η ημερομηνία λήξης προθεσμίας πρέπει να είναι μεταγενέστερη της ημερομηνίας Επιτρέπονται Υποβολές από .';
$string['discoveredlocation'] = 'Discovered location';
$string['donetutorial'] = 'Τέλος';
$string['editend_tour'] = 'Απολαύστε τη δημιουργία συναρπαστικών παιχνίδιών για τους χρήστες σας!';
$string['editingroad'] = 'Γίνεται επεγεργασία της διαδρομής';
$string['editingstage'] = 'Γίνεται επεξεργασία του σταδίου';
$string['editingtreasurehunt'] = 'Γίνεται επεγεργασία του Κυνηγιού Θησαυρού';
$string['edition'] = 'Πίνακας έκδοσης';
$string['edition_help'] = 'Για να ενεργοποιήσετε τη δημιουργία γεωμετρίας και τον πίνακα έκδοσης πρέπει να επιλέξετε τη διαδρομή που θέλετε να επεξεργαστείτε';
$string['editroad'] = 'Επεξεργασία διαδρομής';
$string['editstage'] = 'Επεξεργασία Σταδίου';
$string['edittreasurehunt'] = 'Τροποποίηση διαδρομής και σταδίων';
$string['errcorrectanswers'] = 'Πρέπει να επιλέξετε μια σωστή απάντηση';
$string['errcorrectsetanswerblank'] = 'Η σωστή απάντηση έχει οριστεί, αλλά η απάντηση είναι κενή';
$string['erremptystage'] = 'Όλα τα στάδια πρέπει να έχουν τουλάχιστον μία γεωμετρία έτσι ώστε η διαδρομή να είναι έγκυρη';
$string['errnocorrectanswers'] = 'Πρέπει να υπάρχει μόνο μία σωστή απάντηση';
$string['errnumeric'] = 'Πρέπει να εισαγάγετε έναν έγκυρο δεκαδικό αριθμό';
$string['error'] = 'Σφάλμα';
$string['errpenalizationexceed'] = 'Η ποινή δεν μπορεί να είναι μεγαλύτερη από 100';
$string['errpenalizationfall'] = 'Η ποινή δεν μπορεί να είναι μικρότερη από 0';
$string['errsendinganswer'] = 'Τροποποιήθηκαν τα δεδομένα της διαδρομής ενώ στέλνατε την απάντηση, προσπαθήστε ξανά';
$string['errsendinglocation'] = 'Τροποποιήθηκαν τα δεδομένα της διαδρομής καθώς στέλνατε την τοποθεσία, προσπαθήστε ξανά';
$string['errvalidroad'] = 'Πρέπει να υπάρχουν τουλάχιστον δύο στάδια που να έχουν τουλάχιστον μία γεωμετρία ώστε η διαδρομή να είναι έγκυρη';
$string['eventattemptsubmitted'] = 'Η προσπάθεια υποβλήθηκε';
$string['eventroadcreated'] = 'Η διαδρομή δημιουργήθηκε';
$string['eventroaddeleted'] = 'Η διαδρομή διαγράφηκε';
$string['eventroadupdated'] = 'Η διαδρομή ενημερώθηκε';
$string['eventstagecreated'] = 'Το στάδιο δημιουργήθηκε';
$string['eventstagedeleted'] = 'Το στάδιο διαγράφηκε';
$string['eventstageupdated'] = 'Το στάδιο ενημερώθηκε';
$string['exit'] = 'Επιστροφή στο μάθημα';
$string['failedlocation'] = 'Αποτυχημένη τοποθεσία';
$string['faillocation'] = 'Δεν είναι το σωστό μέρος';
$string['gamemode'] = 'Λειτουργία παιχνιδιού';
$string['gamemodeinfo'] = 'Λειτουργία παιχνιδιού: {$a}';
$string['gameupdatetime'] = 'Χρόνος ενημέρωσης παιχνιδιού';
$string['gameupdatetime_help'] = 'Χρονικό διάστημα σε δευτερόλεπτα που μεσολαβεί μεταξύ μίας ενημέρωσης παιχνιδιού από τον ένα χρήστη στον άλλο.
Όσο μεγαλύτερo είναι, τόσο λιγότερα αιτήματα ενημέρωσης απαιτούνται να γίνουν, αλλά χρειάζεται περισσότερο χρόνο για να αναφερθεί πιθανή αλλαγή.
Πρέπει να είναι μεγαλύτερο από 0 δευτερόλεπτα, αλλά ο χρόνος θα είναι εξ ορισμού προκαθορισμένος.';
$string['geolocation_needed'] = 'Για να παίξετε αυτό το παιχνίδι, απαιτείται η γεωγραφική σας θέση. <p>Για να την ενεργοποιήσετε, μεταβείτε στον φυλλομετρητή  σας Ρυθμίσεις->Ρυθμίσεις τοποθεσίας->Τοποθεσία και καταργήστε την εξαίρεση για αυτόν τον ιστότοπο.<p>Ανανεώστε αυτή τη σελίδα και απαντήστε  "YES" όταν το πρόγραμμα περιήγησης σας ρωτήσει εάν θέλετε να μοιραστείτε την τοποθεσία σας.';
$string['geolocation_needed_title'] = 'Αυτή η εφαρμογή χρειάζεται γεωγραφική θέση.';
$string['grade_explaination_fromabsolutetime'] = '{$a->rawscore}-{$a->penalization}%: Τελειώσατε το κυνήγι στις {$a->yourtime}. Ο καλύτερος χρόνος ήταν στις {$a->besttime}. Έχετε ποινή {$a->penalization}% λόγω {$a->nolocationsfailed} λανθασμένων τοποθεσιών, και {$a->noanswersfailed} εσφαλμένων απαντήσεων.';
$string['grade_explaination_fromposition'] = '{$a->rawscore}-{$a->penalization}%: Ανακαλύψατε  {$a->nosuccessfulstages} στάδια στη θέση {$a->position}. Έχετε ποινή {$a->penalization}% λόγω {$a->nolocationsfailed} λανθασμένων τοποθεσιών, και {$a->noanswersfailed} εσφαλμένων απαντήσεων.';
$string['grade_explaination_fromstages'] = '{$a->rawscore}-{$a->penalization}%: Ανακαλύψατε {$a->nosuccessfulstages} από {$a->nostages} στάδια. Έχετε ποινή {$a->penalization}% λόγω {$a->nolocationsfailed} λανθασμένων τοποθεσιών, και {$a->noanswersfailed} εσφαλμένων απαντήσεων.';
$string['grade_explaination_fromtime'] = '{$a->rawscore}-{$a->penalization}%: Απαιτείται {$a->yourtime} να ολοκληρώσετε το κυνήγι. Ο καλύτερος χρόνος ήταν {$a->besttime}. Έχετε ποινή {$a->penalization}% λόγω {$a->nolocationsfailed} λανθασμένων τοποθεσιών, και {$a->noanswersfailed} εσφαλμένων απαντήσεων.';
$string['grade_explaination_temporary'] = 'Hμιτελές κυνήγι, λαμβάνετε το 50% της βαθμολογίας από τα στάδια: {$a->rawscore}-{$a->penalization}%: Ανακαλύψατε {$a->nosuccessfulstages} από {$a->nostages} στάδια. Έχετε ποινή {$a->penalization}% λόγω {$a->nolocationsfailed} λανθασμένων τοποθεσιών, και {$a->noanswersfailed} εσφαλμένων απαντήσεων.';
$string['gradefromabsolutetime'] = 'Βαθμός από τη διάρκεια του κυνηγιού';
$string['gradefromposition'] = 'Βαθμός από τοποθεσίες';
$string['gradefromstages'] = 'Βαθμός από στάδια';
$string['gradefromtime'] = 'Βαθμός από το χρόνο τερματισμού';
$string['grademethod'] = 'Μέθοδος βαθμολόγησης';
$string['grademethod_help'] = '<p><b>Βαθμός από στάδια</b></p>
<p>Κάθε παίκτης (ή ομάδα) βαθμολογείται ανάλογα με τον αριθμό των σταδίων που επιλύονται,
100% όταν μία διαδρομή ολοκληρώθηκε και 0% όταν κανένα στάδιο δεν επιλύθηκε .</p>
<p><b>Βαθμός από τη διάρκεια του κυνηγιού</b><p>
<p>Ο παίχτης που ολοκληρώνει τη διαδρομή σε λιγότερο χρόνο, κερδίζει το παιχνίδι και σημειώνει τον καλύτερο χρόνο.
Ο χρόνος μετράται από τη στιγμή που το πρώτο στάδιο της διαδρομής ξεκλειδώνεται.
Αυτό σημαίνει ότι οι συμμετέχοντες μπορούν να παίξουν σε διαφορετικές στιγμές.
Ο βαθμός υπολογίζεται με παρεμβολή του χρόνου ολοκλήρωσης του κυνηγιού, όπου το 50% της καλύτερης βαθμολογίας λαμβάνεται ως ο χειρότερος καταληκτικός χρόνος
και το 100% της καλύτερης βαθμολογίας ως ο καλύτερος χρόνος. Οι παίχτες που δεν ολοκλήρωσαν
το κυνήγι λαμβάνουν βαθμό κάτω από 50 ο οποίος υπολογίζεται μόνο από τον αριθμό των σταδίων που επιλύθηκαν.</p>
<p><b>Βαθμός από την ώρα τερματισμού</b></p>
<p>Ο παίχτης που τελειώνει πρώτος είναι ο νικητής του κυνηγιού.
Θεωρείται ότι κάθε παίχτης παίζει ταυτόχρονα.
Ο βαθμός υπολογίζεται με παρεμβολή του χρόνου ολοκλήρωσης του κυνηγιού, όπου το 50% του καλύτερου χρονου λαμβάνεται ως ο χειρότερος καταληκτικός χρόνος
και το 100% του καλύτερου χρόνου ως ο καλύτερος χρόνος. Οι παίχτες που δεν ολοκλήρωσαν
το κυνήγι λαμβάνουν βαθμό κάτω από 50 ο οποίος υπολογίζεται μόνο από τον αριθμό των σταδίων που επιλύθηκαν.</p>
<p><b>Βαθμός από κατάταξη</b></p>
<p>Ο βαθμός υπολογίζεται με παρεμβολή της θέσης στην κατάταξη,
όπου 100% είναι το σκορ του πρώτου παίχτη και 50% του τελευταίου.
Οι παίχτες που δεν ολοκλήρωσαν το κυνήγι λαμβάνουν βαθμό κάτω από 50 ο οποίος υπολογίζεται
μόνο από τον αριθμό των σταδίων που επιλύθηκαν.</p>';
$string['grademethodinfo'] = 'Μέθοδος βαθμολόγησης: {$a->type}. Ποινή τοποθεσίας: {$a->gradepenlocation}%. Ποινή απάντησης: {$a->gradepenanswer}%';
$string['gradepenanswer'] = 'Ποινή λόγω εσφαλμένης απάντησης';
$string['gradepenlocation'] = 'Ποινή λόγω εσφαλμένης τοποθεσίας';
$string['gradepenlocation_help'] = 'Η ποινή εκφράζεται σε % του βαθμού.
Πχ, αν η ποινή είναι 5.4, ο βαθμός ενός παίχτη με 3 αποτυχίες θα έχει ποινή
16.2%, δηλαδή θα λάβει 83.8% του βαθμού του υπολογιζόμενου με τα υπόλοιπα κριτήρια.';
$string['gradesdeleted'] = 'Οι βαθμοί για το κυνήγι θησαυρού διαγράφηκαν';
$string['gradingsummary'] = 'Περίληψη βαθμολογίας';
$string['group'] = 'Ομάδα';
$string['groupactivityovercome'] = 'Δραστηριότητα που ολοκληρώθηκε με επιτυχία από το {$a->user} για το στάδιο {$a->position} στις: {$a->date}';
$string['groupid'] = 'Ομάδα που έχει ανατεθεί στη διαδρομή';
$string['groupid_help'] = 'Τα μέλη αυτής της ομάδας έχουν συσχετισθεί με αυτή τη διαδρομή κατά την έναρξη του παιχνιδιού.
Αν υπάρχει μόνο μία διαδρομή και η επιλεγμένη τιμή είναι "none", όλοι οι συμμετέχοντες στη δραστηριότητα θα παίξουν για αυτό';
$string['groupingid'] = 'Ομαδοποίηση που έχει συσχετισθεί με τη διαδρομή';
$string['groupingid_help'] = 'Ομάδες σε αυτήν την ομαδοποίηση έχουν συσχετισθεί με αυτη τη διαδρομή κατά την έναρξη του παιχνιδιού';
$string['groupinvalidroad'] = '{$a} έχει συσχετισθεί με μη έγκυρη διαδρομή.';
$string['grouplocationfailed'] = 'Εσφαλμένη τοποθεσία από τον παιχτη {$a->user} στο στάδιο {$a->position} στις: {$a->date}';
$string['grouplocationovercome'] = 'Επιτυχής τοποθεσία από τον παιχτη {$a->user} στο στάδιο {$a->position} στις: {$a->date}';
$string['groupmode'] = 'Οι παίχτες παίζουν σε ομάδες';
$string['groupmode_help'] = 'Αν είναι  ενεργοποιημένο οι μαθητές θα χωριστούν σε ομάδες με βάση τις ρυθμίσειω των ομάδων του κυνηγιού.
Ένα ομαδικό παιχνίδι θα μοιραστεί μεταξύ των μελών της ομάδας και θα ενημερώνονται για τις αλλαγές του παιχνιδιού.';
$string['groupmultipleroads'] = '{$a} έχει περισσότερες από μία διαδρομές ανατεθειμένες.';
$string['groupquestionfailed'] = 'Εσφαλμένη απάντηση από τον {$a->user} στην ερώτηση του σταδίου {$a->position} στις: {$a->date}';
$string['groupquestionovercome'] = 'Επιτυχής απάντηση από τον {$a->user} στην ερώτηση του σταδίου {$a->position} στις: {$a->date}';
$string['groups'] = 'Ομάδες';
$string['groupstageovercome'] = 'Το στάδιο {$a->position} ολοκληρώθηκε από τον  {$a->user} στις: {$a->date}';
$string['hello'] = 'Χαίρετε';
$string['history'] = 'Ιστορικό';
$string['huntcompleted'] = 'Έχετε ήδη ολοκληρώσει αυτό το κυνήγι θησαυρού';
$string['incorrectanswer'] = 'Λανθασμένη απάντηση.';
$string['info'] = 'Πληροφορίες';
$string['infovalidatelocation'] = 'Επικυρώστε την τοποθεσία για αυτό το σταδίο';
$string['invalidassignedroad'] = 'Η ανατεθειμένη διαδρομή δεν είναι επικυρωμένη';
$string['invalroadid'] = 'Η διαδρομή δεν είναι επικυρωμένη';
$string['lastsuccessfulstage_tour'] = 'Σε αυτόν τον πίνακα μπορείτε να διαπιστώσετε το τελευταίο σας επιτυχημένο στάδιο. Μπορεί να είναι το δικό σας ή της ομάδας σας.';
$string['layers'] = 'Επίπεδα';
$string['loading'] = 'Φόρτωση';
$string['lockedaclue'] = 'Πρέπει να εκτελέσετε τη δραστηριότητα \'<strong>{$a}</strong>\' για να ξεκλειδώσετε την ένδειξη';
$string['lockedaqclue'] = 'Πρέπει να εκτελέσετε τη δραστηριότητα \'<strong>{$a}</strong>\' και να απαντήσετε σωστά στην παρακάτω
ερώτηση για να ξεκλειδώσετε την ένδειξη';
$string['lockedclue'] = 'Κλειδωμένο στοιχείο';
$string['lockedqclue'] = 'να απαντήσετε σωστά στην παρακάτω ερώτηση για να ξεκλειδώσετε την ένδειξη';
$string['locktimeediting'] = 'Κλείδωμα επεξεργασίας χρόνου';
$string['locktimeediting_help'] = 'Ο χρόνος σε δευτερόλεπτα για τον οποίο ο χρήστης μπορεί να επεξεργαστεί μία περίπτωση χωρίς να γίνει ανανέωση του κλείδωματος.
Όσο πιο μεγάλη η τιμή, τόσο λιγότερα αιτήματα για ανανέωση κλειδώματος χρειάζεται να γίνουν, αλλά η σελίδα επεξεργασίας θα είναι κλειδωμένη για περισσότερο χρόνο, από τι στιγμή που ο χρήστης θα τελειώσει
Πρέπει να είναι μεγαλύτερο από 5 δευτερόλεπτα, αλλά ο χρόνος θα οριστεί από προεπιλογή.';
$string['map_tour'] = 'Στον χάρτη αυτό μπορείτε να διαχειριστείτε όλα τα στοιχεία ενός ευχάριστου παιχνιδιού με γεωχωρικά δεδομένα!';
$string['mapplay_tour'] = 'Σε αυτό το χάρτη μπορείτε να δείτε όλες τις προσπάθειες αυτού του γεωχωρικού παιχνιδιού! Τα ολοκληρωμένα στάδια σημειώνονται με <img src="pix/success_mark.png" width="28"/> και τα αποτυχημένα στάδια με <img src="pix/failure_mark.png" width="28"/>';
$string['mapplaymobile_tour'] = 'Σε αυτό το χάρτη μπορείτε να δείτε όλες τις προσπάθειες αυτού του γεωχωρικού παιχνιδιού! Τα ολοκληρωμένα στάδια σημειώνονται με <img src="{$a->successurl}" width="28"/> και τα αποτυχημένα στάδια με <img src="{$a->failureurl}" width="28"/>';
$string['mapview'] = 'Προβολή χάρτη';
$string['modify'] = 'Τροποποίηση';
$string['modulename'] = 'Κυνήγι θησαυρού';
$string['modulename_help'] = 'Αυτή η ενότητα θα χρησιμοποιηθεί για την πραγματοποίηση μιας δραστηριότητας με γεωγραφικά δεδομένα';
$string['modulenameplural'] = 'Κυνήγι Θησαυρού';
$string['movingplay'] = 'Παιχνίδι με κίνηση';
$string['multiplegroupingsplay'] = 'Your group has assigned more than one road, so you can not play the activity.';
$string['multiplegroupsplay'] = 'Έχουν ανατεθεί στην ομάδα σας περισσότερες της μίας διαδρομές, επομένως δεν μπορείτε να συμμετάσχετε στη δραστηριότητα.';
$string['multiplegroupssameroadplay'] = 'Ανήκετε σε περισσότερες από μία ομάδες στις οποίες έχει ανατεθεί η ίδια διαδρομή, έτσι δεν μπορείτε να παίξετε τη δραστηριότητα.';
$string['multipleteamsplay'] = 'Ανήκετε σε περισσότερες από μία ομάδες, έτσι δεν μπορείτε να παίξετε τη δραστηριότητα.';
$string['mustanswerquestion'] = 'Πρέπει να απαντήσετε σωστά στην ερώτηση πριν συνεχίσετε';
$string['mustcompleteactivity'] = 'Πρέπει να ολοκληρώσετε τη δραστηριότητα πριν συνεχίσετε';
$string['mustcompleteboth'] = 'Πρέπει να απαντήσετε σωστά στην ερώτηση και να ολοκληρώσετε τη δραστηριότητα πριν συνεχίσετε';
$string['nextstep'] = 'Επόμενο';
$string['noanswerselected'] = 'Πρέπει να επιλέξετε μια απάντηση';
$string['noattempts'] = 'Δεν έχετε κάνει καμία προσπάθεια';
$string['noexsitsstage'] = 'Δεν υπάρχει στάδιο με αριθμό {$a} στη βάση δεδομένων. Ξαναφορτώστε (reload) τη σελίδα';
$string['nogroupassigned'] = 'Καμία ομάδα δεν έχει συσχετισθεί σε αυτή τη διαδρομή';
$string['nogroupingplay'] = 'Δεν έχετε συσχετίσει τη διαδρομή με κάποια ομάδα, έτσι δεν μπορείτε να εκτελέσετε τη δραστηριότητα.';
$string['nogroupplay'] = 'Δεν έχετε προσθέσει διαδρομή, έτσι δεν μπορείτε να εκτελέσετε τη δραστηριότητα.';
$string['nogrouproad'] = '{$a} δεν είναι συσχετισμένο με κάποια διαδρομή.';
$string['nomarks'] = 'Πρώτα σημειώστε στο χάρτη το επιθυμητό σημείο. Τοποθετήστε το <img src="pix/my_location.png" width="28"/>';
$string['nomarksmobile'] = 'Πρώτα σημειώστε στο χάρτη το επιθυμητό σημείο.';
$string['noresults'] = 'Δεν βρέθηκαν αποτελέσματα.';
$string['noroads'] = 'Δεν έχουν προστεθεί ακόμα διαδρομές';
$string['notchangeorderstage'] = 'Δεν μπορείτε να αλλάξετε τη σειρά των σταδίων, εφόσον έχουν ήδη γίνει προσπάθειες στη διαδρομή';
$string['notcreatestage'] = 'Έχουν ήδη γίνει προσπάθειες σε αυτόν τον δρόμο, οπότε δεν μπορείτε να προσθέσετε περισσότερα στάδια';
$string['notdeletestage'] = 'Έχουν ήδη γίνει προσπάθειες σε αυτόν τον δρόμο, οπότε δεν μπορείτε να διαγράψετε κανένα στάδιο';
$string['noteam'] = 'Δεν είναι μέλος κάποιας ομάδας';
$string['notreasurehunts'] = 'Δεν υπάρχει κυνήγι θησαυρού σε αυτό το μάθημα';
$string['nouserassigned'] = 'Δεν έχει συσχετισθεί χρήστης σε αυτή τη διαδρομή';
$string['nouserattempts'] = '{$a} δεν έχει κάνει κάποια προσπάθεια';
$string['nouserroad'] = '{$a} δεν έχει συσχετισθεί με κάποια διαδρομή .';
$string['nousersprogress'] = 'Κανένας χρήστης / ομάδα δεν έχει σημειώσει πρόοδο σε αυτή τη διαδρομή.';
$string['outoftime'] = 'Τέλος χρόνου';
$string['overcomefirststage'] = 'Για να ανακαλύψετε το πρώτο στάδιο θα πρέπει να ξεκινήσετε από τη σημειωμένη περιοχή στο χάρτη';
$string['overlaylayers'] = 'Επικάλυψη επιπέδων';
$string['play'] = 'Παίξτε';
$string['playend_tour'] = 'Απολαύστε το Κηνύγι του Θησαυρού με τους φίλους σας!';
$string['playstagewithoutmoving'] = 'Ανακαλύψτε το στάδιο, χωρίς να κινηθείτε';
$string['playstagewithoutmoving_help'] = 'Εάν αυτή η επιλογή είναι ενεργοποιημένη, οι μαθητές μπορούν να ανακαλύψουν αυτό το στάδιο χωρίς να μετακινηθούν σε οποιοδήποτε μέρος.
Για να γίνει αυτό, κάθε φορά που ο παίχτης κάνει ένα απλό κλικ στο χάρτη δημιουργείται ένα σημάδι, σβήνοντας το προηγούμενο
αν υπάρχει, υποδεικνύοντας το τελευταίο επιθυμητό σημείο. Με την ολοκλήρωση του σταδίου, το παιχνίδι θα αλλάξει στις προεπιλεγμένες
ρυθμίσεις της δραστηριότητας';
$string['playstagewithqr'] = 'Ανακαλύψτε το στάδιο διαβάζοντας αυτό το QR κείμενο';
$string['playstagewithqr_help'] = 'Εάν αυτή η επιλογή είναι ενεργοποιημένη, οι μαθητές μπορούν να ανακαλύψουν αυτό το στάδιο σαρώνοντας έναν κώδικα QR που είναι διαθέσιμος σε εκείνη την τοποθεσία.';
$string['playwithoutmoving'] = 'Παίξτε χωρίς μετακίνηση';
$string['playwithoutmoving_help'] = 'Αν αυτή η επιλογή είναι ενεργοποιημένη, οι παίχτες μπορούν να παίξουν από τους υπολογιστές τους χωρίς να μετακινηθούν
σε μέρη. Για να γίνει αυτό, κάθε φορά που ο παίχτης κάνει ένα απλό κλικ στο χάρτη, δημιουργείται ένα σημάδι, σβήνοντας το προηγούμενο
αν υπάρχει, υποδεικνύοντας το τελευταίο επιθυμητό σημείο.';
$string['pluginadministration'] = 'Διαχείριση Κυνήγι Θησαυρού';
$string['pluginname'] = 'Κυνήγι Θησαυρού';
$string['prevstep'] = 'Προηγούμενο';
$string['qrreaded'] = 'Ο κωδικός QR διαβάστηκε:';
$string['question'] = 'Ερώτηση';
$string['remove'] = 'Διαγραφή';
$string['remove_tour'] = 'Μπορείτε να διαγράψετε τμήματα από τη γεωμετρικά δεδομένα των τοποθεσιών. Απλά επιλέξτε ένα πολύγωνο και, στη συνέχεια, πατήστε αυτό το κουμπί.';
$string['removealltreasurehuntattempts'] = 'Διαγράψτε όλες τις προσπάθειες για το κυνήγι θησαυρού';
$string['removedactivitytoend'] = 'Η δραστηριότητα ολοκλήρωσης έχει καταργηθεί';
$string['removedquestion'] = 'Η ερώτηση έχει καταργηθεί';
$string['removeroadwarning'] = 'Εάν καταργήσετε τη διαδρομή, όλα τα σχετικά στάδια θα καταργηθούν και δεν μπορείτε πλέον να τα επαναφέρετε';
$string['removewarning'] = 'Εάν το καταργήσετε, δεν θα μπορείτε να το ανακτήσετε';
$string['restrictionsdiscoverstage'] = 'Περιορισμοί στην ανακάλυψη σταδίου';
$string['reviewofplay'] = 'Ανασκόπηση του παιχνιδιού';
$string['road'] = 'Διαδρομή';
$string['roadended'] = 'Η διαδρομή ολοκληρώθηκε! Συγχαρητήρια! Έχετε ολοκληρώσει το κυνήγι του θησαυρού. Μπορείτε να ελέγξετε το ιστορικό σας στο χάρτη.';
$string['roadmap'] = 'Διαδρομή';
$string['roadname'] = 'Όνομα Διαδρομής';
$string['roads_tour'] = 'Σε αυτή την περιοχή θα βρείτε τις διαφορετικές διαδρομές του παιχνιδιού σας. Επιλέξτε μία από αυτές για να επεξεργαστείτε τα στάδια.';
$string['roadview'] = 'Διαδρομή';
$string['save'] = 'Save';
$string['save_tour'] = 'Αφού σχεδιάσετε τις τοποθεσίες σας, μην ξεχάσετε να αποθηκεύσετε τις αλλαγές σας.';
$string['saveemptyridle'] = 'Όλα τα τροποποιημένα στάδια πρέπει να έχουν γεωμετρία πριν από την αποθήκευση';
$string['savewarning'] = 'Δεν έχετε αποθηκεύσει τις αλλαγές.';
$string['scanQR_generatebutton'] = 'Δημιουργία QRCode';
$string['scanQR_scanbutton'] = 'Σάρωση QRCode';
$string['search'] = 'Αναζήτηση';
$string['searching'] = 'Γίνεται αναζήτηση';
$string['searchlocation'] = 'Αναζήτηση τοποθεσίας';
$string['searchlocation_tour'] = 'Με αυτήν την περιοχή αναζήτησης μπορείτε να βρείτε το δρόμο σας γρήγορα';
$string['send'] = 'Send';
$string['sendlocationcontent'] = 'Αυτή η ενέργεια δεν μπορεί να ανακληθεί.';
$string['sendlocationtitle'] = 'Είστε βέβαιοι ότι θέλετε να στείλετε αυτήν την τοποθεσία;';
$string['skiptutorial'] = 'Έξοδος';
$string['stage'] = 'Στάδιο';
$string['stageclue'] = 'Στοιχείο για να εντοπίσετε το επόμενο στάδιο';
$string['stageclue_help'] = 'Εδώ θα πρέπει να περιγράψετε το στοιχείο - ένδειξη για να φτάσετε στην επόμενη τοποθεσία.
Σε περίπτωση που πρόκειται για το τελευταίο στάδιο, πρέπει να αφήσετε ένα μήνυμα επισημαίνοντας ότι το κυνήγι του θησαυρού ολοκληρώθηκε.';
$string['stagename'] = 'Ονομασία Σταδίου';
$string['stageovercome'] = 'Υπέρβαση Σταδίου';
$string['stages'] = 'Στάδια';
$string['stages_tour'] = 'Σε αυτή την περιοχή θα βρείτε τα στάδια της επιλεγμένης διαδρομής. Επιλέξτε έκαστο στάδιο αν θέλετε να κάνετε μεγέθυνση της τοποθεσίας των σταδίων πάνω στο χάρτη.';
$string['start'] = 'Εκκίνηση';
$string['startfromhere'] = 'Μπορείτε να ξεκινήσετε μόνο από εδώ';
$string['state'] = 'Κατάσταση';
$string['successlocation'] = 'Είναι το σωστό μέρος!';
$string['timeexceeded'] = 'Έχετε υπερβεί το χρονικό όριο για τη δραστηριότητα. Αυτή η προβολή χρησιμεύει μόνο για την επισκόπηση του παιχνιδιού';
$string['totalprogress'] = 'Συνολική πρόοδος';
$string['totaltime'] = 'Συνολικός χρόνος';
$string['trackusers'] = 'Παρακολούθηση πορείας';
$string['trackusers_help'] = 'Καταχωρίστε τις διαδρομές που πραγματοποιήθηκαν στους χρήστες κατά τη διάρκεια του παιχνιδιού.';
$string['trackviewer'] = 'Track Viewer';
$string['treasurehunt'] = 'Κυνήγι θησαυρού';
$string['treasurehunt:addinstance'] = 'Προσθέστε νέο Κυνήγι θησαυρού';
$string['treasurehunt:addroad'] = 'Προσθήκη διαδρομής';
$string['treasurehunt:addstage'] = 'Προσθήκη σταδίου';
$string['treasurehunt:editroad'] = 'Επεξεργασία διαδρομής';
$string['treasurehunt:editstage'] = 'Επεξεργασία σταδίου';
$string['treasurehunt:managetreasure'] = 'Διαχειριστείτε το κυνήγι θησαυρού';
$string['treasurehunt:managetreasurehunt'] = 'Διαχειριστείτε το κυνήγι θησαυρού';
$string['treasurehunt:play'] = 'Παίξτε';
$string['treasurehunt:view'] = 'Προβολή κυνήγι θησαυρού';
$string['treasurehunt:viewusershistoricalattempts'] = 'Δείτε το ιστορικό προσπαθείών των χρηστών';
$string['treasurehuntclosed'] = 'Αυτό το κυνήγι του θησαυρού έκλεισε στις {$a}';
$string['treasurehuntcloses'] = 'Το κυνήγι του θησαυρού κλείνει';
$string['treasurehuntcloseson'] = 'Αυτό το κυνήγι του θησαυρού θα κλείσει στις {$a}';
$string['treasurehuntislocked'] = '{$a} επεξεργάζεται αυτό το κυνήγι θησαυρού αυτή τη στιγμή. Προσπαθήστε να το επεξεργαστείτε σε λίγα λεπτά.';
$string['treasurehuntname'] = 'Κυνήγι θησαυρού\'s name';
$string['treasurehuntnotavailable'] = 'Το κυνήγι του θησαυρού δεν θα είναι διαθέσιμο μέχρι {$a}';
$string['treasurehuntopenedon'] = 'Αυτό το κυνήγι του θησαυρού άνοιξε στις {$a}';
$string['treasurehuntopens'] = 'Το Κυνήγι θησαυρού ανοίγει';
$string['updates'] = 'Ενημερώσεις';
$string['updatetimes'] = 'Χρόνος ενημέρωσης';
$string['user'] = 'Χρήστης';
$string['useractivityovercome'] = 'Η δραστηριότητα ολοκληρώθηκε με επιτυχία για το στάδιο {$a->position} στις: {$a->date}';
$string['userattempthistory'] = 'Ιστορικό προσπαθειών {$a}';
$string['userinvalidroad'] = '{$a} είναι συσχετισμένος με μη έγκυρη διαδρομή.';
$string['userlocationfailed'] = 'Αποτυχημένη τοποθεσία σταδίου{$a->position} στις: {$a->date}';
$string['userlocationovercome'] = 'Επιτυχημένη τοποθεσία σταδίου {$a->position} στις: {$a->date}';
$string['usermultipleroads'] = '{$a} έχει περισσότερους από έναν δρόμους συσχετισμένους.';
$string['usermultiplesameroad'] = '{$a} ανήκει σε περισσότερες από μία ομάδες που σχετίζονται με την ίδια διαδρομή.';
$string['userprogress'] = 'Η πρόοδος του χρήστη ενημερώθηκε με επιτυχία';
$string['userquestionfailed'] = 'Εσφαλμένη απάντηση στο ερώτημα του σταδίου {$a->position} στις: {$a->date}';
$string['userquestionovercome'] = 'Επιτυχημένη απάντηση στο ερώτημα του σταδίου  {$a->position} on the date: {$a->date}';
$string['usersprogress'] = 'Πρόοδος χρηστών';
$string['usersprogress_help'] = 'Δείχνει την πρόοδο των σταδίων κάθε μαθητή / ομάδας σύμφωνα με τα χρώματα:
<p>Το χρώμα <b> πράσινο </b> δείχνει ότι το στάδιο έχει ολοκληρωθεί χωρίς αποτυχίες.</p>
<p>Το χρώμα <b> κίτρινο </b> δείχνει ότι το στάδιο έχει ολοκληρωθεί με αποτυχίες.</p>
<p>Το χρώμα <b> κόκκινο </b> δείχνει ότι το στάδιο δεν έχει ολοκληρωθεί και έχουν πραγματοποιηθεί αποτυχίες.</p>
<p>Το χρώμα <b> γκρι </b> δείχνει ότι το στάδιο δεν έχει ολοκληρωθεί και δεν έχουν πραγματοποιηθεί αποτυχίες.</p>';
$string['userstageovercome'] = 'Το στάδιο {$a->position} ολοκληρώθηκε στις: {$a->date}';
$string['validatelocation'] = 'Επικύρωση τοποθεσίας';
$string['validatelocation_tour'] = 'Όταν είστε σίγουροι για τη τοποθεσία ενός σταδίου, πρέπει να καταχωρήσετε τη θέση σας ώστε να ελέγξετε αν είστε σωστοί.';
$string['validateqr'] = 'Σάρωση QR';
$string['warmatchanswer'] = 'Η απάντηση δεν ταιριάζει με την ερώτηση';
$string['warnqrscanner'] = '<table><tr><td> Αυτό το κυνήγι θησαυρού περιλαμβάνει {$a} στάδια με QRCodes.
Βεβαιωθείτε ότι η συσκευή σας μπορεί να σαρώσει κωδικούς από το πρόγραμμα περιήγησης ιστού. Μια προβολή της κάμεράς σας θα πρέπει να εμφανίζεται παρακάτω. Προσπαθήστε να διαβάσετε οποιοδήποτε QRcode
σαν αυτό.</td><td> <a href="pix/qr.png">
 <img src="pix/qr.png" align="top" width="100"></a></td></tr></table>';
$string['warnqrscannersuccess'] = 'Αυτό το κυνήγι θησαυρού περιλαμβάνει {$a} στάδια με QRCodes.
Φαίνεται ότι έχετε περάσει μια δοκιμή QR με αυτήν τη συσκευή.';
$string['warnusersgroup'] = 'Οι παρακάτω χρήστες ανήκουν σε περισσότερες από μία ομάδες: {$a}, οπότε δεν μπορούν να συμμετάσχουν στη δραστηριότητα.';
$string['warnusersgrouping'] = 'Οι ακόλουθες ομάδες ανήκουν σε περισσότερες από μία ομαδοποιήσεις: {$a}, οπότε δεν μπορούν να συμμετάσχουν στη δραστηριότητα.';
$string['warnusersoutside'] = 'Οι παρακάτω χρήστες δεν ανήκουν σε καμία ομάδα/ομάδοποίηση: {$a}, οπότε δεν μπορούν να συμμετάσχουν στη δραστηριότητα.';
$string['welcome_edit_tour'] = 'Καλώς ήλθατε στη σελίδα διαχείρισης για το Κυνήγι Θησαυρού. ';
$string['welcome_play_tour'] = 'Καλώς ήλθατε στην οθόνη για το παιχνιδι Κυνήγι Θησαυρού. Αυτό είναι το βασικό περιβάλλον εργασίας για να ερευνήσετε, να κυνηγήσετε και να βρειτε το θησαυρό.';
