define("mod_treasurehunt/viewgpx",["exports","jquery","mod_treasurehunt/ol","mod_treasurehunt/ol3-layerswitcher","core/str"],(function(_exports,_jquery,_ol,_ol3Layerswitcher,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * @module  mod_treasurehunt/viewgpx
   * @package
   * @copyright 2016 onwards Adrian Rodriguez Fernandez <huorwhisp@gmail.com>, Juan Pablo de Castro <jpdecastro@tel.uva.es>
   * @author Adrian Rodriguez <huorwhisp@gmail.com>
   * @author Juan Pablo de Castro <jpdecastro@tel.uva.es>
   * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_ol=_interopRequireDefault(_ol);let init={refreshTracksInterval:30,refreshCounter:0,addgpxlayer:function(map,cmid,treasurehuntid,strings,user,trackgroupname){var trackgroup=function(map,trackgroupname){var layergroup=null;map.getLayers().forEach((function(layer){layer.get("title")==trackgroupname&&(layergroup=layer)})),layergroup||(layergroup=new _ol.default.layer.Group({title:trackgroupname,layers:[]}),map.addLayer(layergroup));return layergroup}(map,trackgroupname);return load_gpx([user],cmid,map,trackgroup,null),trackgroup},creategpxviewer:function(cmid,treasurehuntid,users,custommapconfig,refreshinterval){var terms=["aerialmap","roadmap","basemaps","searchlocation","trackviewer","pegmanlabel"],stringsqueried=terms.map((function(term){return{key:term,component:"treasurehunt"}}));this.refreshTracksInterval=refreshinterval,"global"==users&&(users=window.users_param),(0,_str.get_strings)(stringsqueried).then((function(strings){for(var i18n=[],i=0;i<terms.length;i++)i18n[terms[i]]=strings[i];if(null!=custommapconfig&&null!==custommapconfig.custombackgroundurl){var img=new Image;img.addEventListener("load",(function(){custommapconfig.imgwidth=this.naturalWidth,custommapconfig.imgheight=this.naturalHeight,initcreategpxviewer(cmid,treasurehuntid,i18n,users,custommapconfig)})),img.src=custommapconfig.custombackgroundurl}else initcreategpxviewer(cmid,treasurehuntid,i18n,users,custommapconfig)}))},createCoordsOverlay:function(){let selector=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"#mappage",cssurl=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"css/ol-popup.css",label=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"";(0,_jquery.default)("<link>").appendTo("head").attr({type:"text/css",rel:"stylesheet",href:cssurl});var popupmarker=(0,_jquery.default)('<div id="popupmarker" class="ol-popup"><a href="#" id="popup-closer" class="ol-popup-closer"></a><div id="popup-content"></div></div>');(0,_jquery.default)(selector).append(popupmarker);var container=(0,_jquery.default)("#popupmarker"),closer=(0,_jquery.default)("#popup-closer"),containernode=container.get(0),timeouthandler=null,createlink=createPegmanLink,overlay=new _ol.default.Overlay({element:containernode,autoPan:!0,autoPanAnimation:{duration:250}});return closer.click((function(){return overlay.setPosition(void 0),clearTimeout(timeouthandler),closer.blur(),(0,_jquery.default)("#popup-content").html(""),!1})),_ol.default.events.listen(overlay,_ol.default.Object.getChangeEventType(_ol.default.Overlay.Property.POSITION),(()=>{var latlon=overlay.getPosition();if(clearTimeout(timeouthandler),latlon){var pegmanlink=createlink(latlon,overlay.getMap(),label);(0,_jquery.default)("#popup-content").html(pegmanlink),timeouthandler=setTimeout((()=>{(0,_jquery.default)("#popup-closer").trigger("click")}),2e3)}}),overlay),container.hover((function(){clearTimeout(timeouthandler)})),overlay}};var _default=init;function initcreategpxviewer(cmid,treasurehuntid,strings,users,custommapconfig){var custombaselayer=null;if(null!=custommapconfig){if(null!==custommapconfig.custombackgroundurl){var customimageextent=function(custommapconfig,mapprojection){let referencetocenter=arguments.length>2&&void 0!==arguments[2]&&arguments[2];var customimageextent=_ol.default.proj.transformExtent(custommapconfig.bbox,"EPSG:4326",mapprojection);if(1==custommapconfig.preserveaspectratio){var bboxheight=customimageextent[3]-customimageextent[1],centerwidth=(customimageextent[2]+customimageextent[0])/2,centerheight=(customimageextent[3]+customimageextent[1])/2,ratiorealmap=Math.round(bboxheight/custommapconfig.imgheight),adjwidth=Math.round(custommapconfig.imgwidth*ratiorealmap),adjheight=Math.round(custommapconfig.imgheight*ratiorealmap);customimageextent=referencetocenter?[centerwidth-adjwidth/2,centerheight-adjheight/2,centerwidth+adjwidth/2,centerheight+adjheight/2]:[customimageextent[0],customimageextent[1],customimageextent[0]+adjwidth,customimageextent[1]+adjheight]}return customimageextent}(custommapconfig,"EPSG:3857",!1);custombaselayer=new _ol.default.layer.Image({title:custommapconfig.layername,type:custommapconfig.layertype,source:new _ol.default.source.ImageStatic({url:custommapconfig.custombackgroundurl,imageExtent:customimageextent}),opacity:1})}else if(null!==custommapconfig.wmsurl){let options={type:custommapconfig.layertype,title:custommapconfig.layername,name:custommapconfig.layername};if("wms"===custommapconfig.layerservicetype?options.source=new _ol.default.source.TileWMS({url:custommapconfig.wmsurl,params:custommapconfig.wmsparams}):"tiled"===custommapconfig.layerservicetype?options.source=new _ol.default.source.XYZ({url:custommapconfig.wmsurl}):"arcgis"===custommapconfig.layerservicetype&&(options.source=new _ol.default.source.TileArcGISRest({url:custommapconfig.wmsurl})),custommapconfig.bbox[0]&&custommapconfig.bbox[1]&&custommapconfig.bbox[2]&&custommapconfig.bbox[3]){let customwmsextent=_ol.default.proj.transformExtent(custommapconfig.bbox,"EPSG:4326","EPSG:3857");options.extent=customwmsextent}(custombaselayer=new _ol.default.layer.Tile(options)).set("name",custommapconfig.layername)}custommapconfig.geographic}var basemaps=new _ol.default.layer.Group({title:strings.basemaps,layers:[new _ol.default.layer.Tile({title:strings.aerialmap,type:"base",visible:!1,source:new _ol.default.source.BingMaps({key:"AmC3DXdnK5sXC_Yp_pOLqssFSaplBbvN68jnwKTEM3CSn2t6G5PGTbYN3wzxE5BR",imagerySet:"AerialWithLabels",maxZoom:19})}),new _ol.default.layer.Tile({title:strings.roadmap,type:"base",visible:!0,source:new _ol.default.source.OSM})]});null!==custombaselayer&&(custommapconfig.onlybase&&basemaps.getLayers().clear(),basemaps.getLayers().push(custombaselayer));var tracks=new _ol.default.layer.Group({title:strings.trackviewer,layers:[]}),heatmap=new _ol.default.layer.Heatmap({title:"Heatmap",source:new _ol.default.source.Vector({url:"gpx.php?id="+cmid+"&userid=24",format:new _ol.default.format.GPX}),blur:20,radius:10}),layerSwitcher=new _ol.default.control.LayerSwitcher,map=new _ol.default.Map({layers:[basemaps,tracks,heatmap],renderer:"canvas",target:document.getElementById("mapgpx"),view:new _ol.default.View({center:[0,0],zoom:2,minZoom:2}),controls:_ol.default.control.defaults().extend([layerSwitcher])});layerSwitcher.showPanel();var selectSingleClick=new _ol.default.interaction.Select({style:function(feature){return trackStyleFunction(feature,selectSingleClick.getLayer(feature).iconurl,!0)}});map.addInteraction(selectSingleClick),load_gpx(users,cmid,map,tracks,layerSwitcher);var popup=new _ol.default.Overlay({element:document.getElementById("info")});function displayFeatureInfo(pixel,themap,coordinates,label){var features=[],msg="";if(themap.forEachFeatureAtPixel(pixel,(function(feature){features.push(feature)})),features.length>0){var i,ii,info=[];for(i=0,ii=features.length;i<ii;++i)info.push(features[i].get("desc"));msg=info.join(", ")||"(unknown)",map.getTarget().style.cursor="pointer"}else msg=createPegmanLink(coordinates,map,label),map.getTarget().style.cursor="";return msg}map.addOverlay(popup),map.on("pointermove",(function(evt){evt.dragging})),map.on("click",(function(evt){!function(evt){var element=popup.getElement(),coordinate=evt.coordinate;(0,_jquery.default)(element).popover("dispose"),popup.setPosition(coordinate),(0,_jquery.default)(element).popover({placement:"top",animation:!1,html:!0,content:displayFeatureInfo(map.getEventPixel(evt.originalEvent),map,coordinate,strings.pegmanlabel)}),(0,_jquery.default)(element).popover("show")}(evt)}));var interval=null;(0,_jquery.default)("#refreshtracks").change((function(){(0,_jquery.default)(this).is(":checked")?(this.refreshCounter=0,(0,_jquery.default)("#timecircle").show(),interval=setInterval(function(){(0,_jquery.default)("#timecircle").text(this.refreshTracksInterval-this.refreshCounter++%this.refreshTracksInterval)}.bind(this),1e3)):((0,_jquery.default)("#timecircle").hide(),clearInterval(interval))}))}function flyTo(map,point,extent){var view=map.getView();extent?view.fit(extent,{duration:700}):view.animate({zoom:19,center:point,duration:700})}function load_gpx(users,cmid,map,tracksGroup,layerSwitcher){var max_extent=null;users.forEach((function(user){var gpxsource=new _ol.default.source.Vector({url:"gpx.php?id="+cmid+"&userid="+user.id,format:new _ol.default.format.GPX}),a=user.pic.indexOf('<img src="')+10,b=user.pic.indexOf('"',a),iconurl=user.pic.substring(a,b),vector=new _ol.default.layer.Vector({source:gpxsource,title:user.pic+""+user.fullname+"</img>",style:function(feature){return trackStyleFunction(feature,iconurl,!1)}});vector.iconurl=iconurl,setInterval((function(){(0,_jquery.default)("#refreshtracks").is(":checked")&&(this.refreshCounter=0,gpxsource.clear(),gpxsource.refresh())}),1e3*this.refreshTracksInterval),vector.on("change:visible",(function(){if(this.getVisible()){var extent=this.getSource().getExtent();null!==(extent=function(extent){if(!(extent instanceof Array)||4!=extent.length)return null;if(extent[0]===1/0||extent[1]===1/0||extent[2]===1/0||extent[3]===1/0)return null;return extent}(extent))&&flyTo(map,null,extent)}})),gpxsource.on("change",(function(){if(!(0,_jquery.default)("#refreshtracks").is(":checked")){var extent=gpxsource.getExtent();null===max_extent?max_extent=extent:(max_extent[0]=Math.min(max_extent[0],extent[0]),max_extent[1]=Math.min(max_extent[1],extent[1]),max_extent[2]=Math.max(max_extent[2],extent[2]),max_extent[3]=Math.max(max_extent[3],extent[3])),flyTo(map,null,max_extent)}}),this),tracksGroup.getLayers().push(vector),layerSwitcher&&layerSwitcher.renderPanel()}))}function trackStyleFunction(feature,icon,selected){var styles=[new _ol.default.style.Style({stroke:new _ol.default.style.Stroke({color:"rgba(255,255,255,0.8)",width:6+2*selected}),zIndex:1+4*selected}),new _ol.default.style.Style({stroke:new _ol.default.style.Stroke({color:"#ff0000",width:1+selected,lineDash:[10,8]}),fill:new _ol.default.style.Fill({color:"rgba(255,0,0,0.5)"}),zIndex:2+4*selected}),new _ol.default.style.Style({image:new _ol.default.style.Circle({radius:3+2*selected,stroke:new _ol.default.style.Stroke({color:"white",width:1+selected}),fill:new _ol.default.style.Fill({color:"red"})}),geometry:function(feature){var coordinates=feature.getGeometry().getCoordinates()[0];return new _ol.default.geom.MultiPoint(coordinates)},zIndex:3+4*selected})],coord=feature.getGeometry().getLastCoordinate();return styles.push(new _ol.default.style.Style({geometry:new _ol.default.geom.Point(coord),image:new _ol.default.style.Icon({src:icon,anchor:[.75,.5],rotateWithView:!1}),zIndex:4+4*selected})),styles}function createPegmanLink(coordinate,map,label){var latlon=_ol.default.proj.toLonLat(coordinate,map.getView().getProjection()),hdms=_ol.default.coordinate.toStringHDMS(latlon);return hdms=hdms.replace(/(\d+)° (\d+)′ (\d+)″ ([NS]) (\d+)° (\d+)′ (\d+)″ ([EW])/,"$1°$2′$3″$4 $5°$6′$7″$8"),'<a target="street" href="http://maps.google.com/?cbll='+latlon[1]+","+latlon[0]+'&cbp=12,20.09,,0,5&layer=c"><img src="pix/my_location.png" width="16" />'+label+"<br/></a><code>"+hdms+"</code>"}return _exports.default=_default,_exports.default}));

//# sourceMappingURL=viewgpx.min.js.map