/**
 * QR scanner integration using vue-qrcode-reader.
 *
 * @package
 * @copyright 2018-2025 Juan Pablo de Castro <jpdecastro@tel.uva.es>
 * @author Juan Pablo de Castro <jpdecastro@tel.uva.es>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_treasurehunt/webqr",["jquery","core/notification","core/str"],(function($,notification,str){var cameraIndex=-1,vueApp=null,scannerapp=null,qrReaderConstraints=[];function isVueQRAvailable(){return"undefined"!=typeof window&&window.Vue&&window.VueQrcodeReader}function loadQRWithVue(scancallback,reportcallback){var container=document.getElementById("previewQRdiv");if(!container)return console.error("previewQRvideo element not found for Vue QR mount"),reportcallback({code:0,name:"DomMissing"}),!1;var Vue=window.Vue,VueQrcodeReader=window.VueQrcodeReader;VueQrcodeReader.setZXingModuleOverrides({locateFile:()=>"./js/zxing_reader.wasm",instantiateWasm:(imports,successCallback)=>(fetch("./js/zxing_reader.wasm",{mode:"no-cors",credentials:"omit"}).then((response=>{if(console.log("response",response),!response.ok&&"opaque"!==response.type)throw new Error(`Failed to fetch wasm: ${response.statusText||"CORS error"}`);return response.arrayBuffer()})).then((buffer=>WebAssembly.instantiate(buffer,imports))).then((output=>{console.log("WASM loaded"),successCallback(output.instance)})).catch((error=>{console.error("WASM error:",error)})),{})}),scannerapp=Vue.createApp({data:function(){return{selectedDevice:null,currentCameraIndex:0,constraint:null,isLoading:!0,error:null}},template:'\n                <div style="position: relative; width: 100%; height: 100%;">\n                    <qrcode-stream\n                        v-if="!error && constraint"\n                        :constraints="constraint"\n                        @detect="onDecode"\n                        @init="onInit"\n                        @error="onError"\n                        @camera-on="initCameras"\n                        :track="paintCenterText"\n                        style="width: 100%; height: 100%;"\n                    />\n                    <div v-if="isLoading"\nstyle="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);">\n                        Loading camera...\n                    </div>\n<div v-if="error" style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); color: red;">\n                        {{ error }}\n                    </div>\n                </div>\n            ',mounted:function(){this.constraint={facingMode:"environment"}},methods:{initCameras:function(){if(this.isLoading=!1,0==qrReaderConstraints.length){var self=this;(navigator.mediaDevices&&navigator.mediaDevices.enumerateDevices?navigator.mediaDevices.enumerateDevices().then((function(devices){return devices.filter((function(d){return"videoinput"===d.kind&&-1==d.label.indexOf("OBS")})).map((function(d,i){return{id:d.deviceId,name:d.label||"Camera "+(i+1)}}))})).catch((function(){return[]})):Promise.resolve([])).then((function(devices){if(qrReaderConstraints.push({name:"Environment Camera",constraint:{facingMode:"environment"}}),qrReaderConstraints.push({name:"User Camera",constraint:{facingMode:"user"}}),devices.length>0){for(var backCameraIndex=-1,i=0;i<devices.length;i++){if(devices[i].name&&-1!==devices[i].name.toLowerCase().indexOf("back")){backCameraIndex=i;break}qrReaderConstraints.push({name:devices[i].name,constraint:{deviceId:devices[i].id}})}var initialIndex=-1!==backCameraIndex?backCameraIndex:0;self.constraint=qrReaderConstraints[0].constraint,self.currentCameraIndex=initialIndex,cameraIndex=initialIndex,self.isLoading=!1,reportcallback({cameraIndex:initialIndex,cameras:qrReaderConstraints})}else self.error="No cameras found",reportcallback({code:0,name:"NoCameras"})})).catch((function(err){self.error="Failed to enumerate cameras",console.error("Camera enumeration error:",err),reportcallback(err)}))}},onDecode:function(content){scancallback(content[0].rawValue)},onError:function(err){let errorvalue=err.name+": ";"NotAllowedError"===err.name?errorvalue+="you need to grant camera access permission":"NotFoundError"===err.name?errorvalue+="no camera on this device":"NotSupportedError"===err.name?errorvalue+="secure context required (HTTPS, localhost)":"NotReadableError"===err.name?errorvalue+="is the camera already in use?":"OverconstrainedError"===err.name?errorvalue+="installed cameras are not suitable":"StreamApiNotSupportedError"===err.name?errorvalue+="Stream API is not supported in this browser":"InsecureContextError"===err.name?errorvalue+="Camera access is only permitted in secure context. Use HTTPS or localhost rather than HTTP.":errorvalue+=err.message,err.code=0,err.messagetext=errorvalue,reportcallback(err)},switchCamera:function(deviceIndex){qrReaderConstraints[deviceIndex]?(this.constraint=qrReaderConstraints[deviceIndex].constraint,this.currentCameraIndex=deviceIndex,cameraIndex=deviceIndex,reportcallback({cameraIndex:deviceIndex,cameras:qrReaderConstraints})):reportcallback({code:0,name:"InvalidCameraIndex",message:"Invalid camera index: "+deviceIndex})},paintBoundingBox:function(detectedCodes,ctx){for(const detectedCode of detectedCodes){const{boundingBox:{x:x,y:y,width:width,height:height}}=detectedCode;ctx.lineWidth=2,ctx.strokeStyle="#007bff",ctx.strokeRect(x,y,width,height)}},paintOutline:function(detectedCodes,ctx){for(const detectedCode of detectedCodes){const[firstPoint,...otherPoints]=detectedCode.cornerPoints;ctx.strokeStyle="red",ctx.beginPath(),ctx.moveTo(firstPoint.x,firstPoint.y);for(const{x:x,y:y}of otherPoints)ctx.lineTo(x,y);ctx.lineTo(firstPoint.x,firstPoint.y),ctx.closePath(),ctx.stroke()}},paintCenterText:function(detectedCodes,ctx){this.paintOutline(detectedCodes,ctx);for(const detectedCode of detectedCodes){const{boundingBox:boundingBox,rawValue:rawValue}=detectedCode,centerX=boundingBox.x+boundingBox.width/2,centerY=boundingBox.y+boundingBox.height/2,fontSize=Math.max(12,50*boundingBox.width/ctx.canvas.width);ctx.font=`bold ${fontSize}px sans-serif`,ctx.textAlign="center",ctx.lineWidth=3,ctx.strokeStyle="#35495e",ctx.strokeText(detectedCode.rawValue,centerX,centerY),ctx.fillStyle="#5cb984",ctx.fillText(rawValue,centerX,centerY)}}},components:{"qrcode-stream":VueQrcodeReader.QrcodeStream}});try{return vueApp=scannerapp.mount(container),console.debug("Loaded Vue QR app successfully"),!0}catch(e){return console.error("Failed to mount Vue QR component",e),container.innerHTML="",!1}}var webqr={setup:function(){isVueQRAvailable()||console.warn("Vue or vue-qrcode-reader not available. QR scanning will not work.")},enableTest:function(successString){var cook={};document.cookie.split(";").forEach((function(x){var arr=x.split("=");arr[1]&&(cook[arr[0].trim()]=arr[1].trim())})),"Done"!=cook.QRScanPassed?($("#idbuttonnextcam").click((()=>this.setnextwebcam(this.reportTestForm.bind(this)))),this.loadQR(this.handleScanTest.bind(this,successString),this.reportTestForm.bind(this))):$("#QRStatusDiv").html(successString)},reportTestForm:function(info){if("string"==typeof info)$("#QRvalue").text(info),$("#previewQR").hide();else if("object"==typeof info)if("NotAllowedError"==info.name||0==info.code)notification.addNotification({message:$("#errorQR").text()+"<p>("+info.messagetext+")</p>",type:"error"}),$("#previewQR").hide(),$("#QRStatusDiv").hide();else{let cam=info.cameraIndex;info.cameras&&info.cameras[cam]&&null!==info.cameras[cam].name&&$("#QRvalue").text(info.cameras[cam].name),$("#previewQR").show();let nextcamera=this.getnextwebCamIndex();nextcamera!=cam?(info.cameras[nextcamera]&&null!==info.cameras[nextcamera].name&&$("#idbuttonnextcam").text("Change to "+webqr.getCamName(nextcamera)),$("#idbuttonnextcam").show()):$("#idbuttonnextcam").hide()}},enableEditForm:function(){$("#id_generateQR").click(this.handleGenerateQR.bind(this)),$("#id_stopQR").click(this.handleStopQR.bind(this)),$("#id_scanQR").click(this.handleScanEditStage.bind(this)),$("#idbuttonnextcam").click((()=>this.setnextwebcam(this.reportEditForm.bind(this))))},handleGenerateQR:function(){var val=$("#id_qrtext").val();if(""!=val){var qrurl="https://quickchart.io/qr?size=500&text="+encodeURIComponent(val);$("#outQRCode").text(""),$("#outQRCode").prepend($("<img>",{id:"theQRImg",src:qrurl,width:"150px",align:"left",title:val}))}else $("#QRStatusDiv").text("Enter text in QRText field.");return!1},handleStopQR:function(){return this.unloadQR(),$("#QRvalue").text(""),$("#previewQR").hide(),$("#id_stopQR").hide(),$("#id_scanQR").show(),!1},handleScanTest:function(successString,value){document.cookie="QRScanPassed = Done",this.unloadQR((function(){$("#QRStatusDiv").html(successString+" - "+value)}))},handleScanEditStage:function(){return this.loadQR(function(value){$("#id_qrtext").val(value)}.bind(this),this.reportEditForm.bind(this)),$("#previewQR").show(),$("#previewQRdiv").show(),$("#id_stopQR").show(),$("#id_scanQR").hide(),!1},reportEditForm:function(info){if("string"==typeof info)$("#QRvalue").text(info),$("#id_stopQR").hide(),$("#id_scanQR").show(),$("#previewQRdiv").hide(),$("#idbuttonnextcam").hide();else if("object"==typeof info)if(0==info.code)str.get_string("warnqrscannererror","treasurehunt","").then((msg=>{notification.addNotification({message:msg+"<p>"+info.messagetext+"</p>",type:"error"})}));else if(void 0!==info.cameraIndex){let camIndex=info.cameraIndex;$("#QRvalue").text(camIndex+":"+info.cameras[camIndex].name);let nextcameraIndex=this.getnextwebCamIndex();nextcameraIndex!=camIndex?($("#idbuttonnextcam").text("Change to "+info.cameras[nextcameraIndex].name),$("#idbuttonnextcam").show()):$("#idbuttonnextcam").hide()}},unloadQR:function(errorcallback){if(scannerapp){try{scannerapp.unmount()}catch(e){console.warn("Error unmounting Vue QR app",e)}scannerapp=null}console.debug("Vue QR app unloaded"),cameraIndex=-1,$("#previewQR").hide(),"function"==typeof errorcallback&&errorcallback("")},loadQR:function(scancallback,reportcallback){if(!isVueQRAvailable())return console.error("Vue or vue-qrcode-reader not available"),void reportcallback({code:0,name:"VueNotAvailable",message:"Vue or vue-qrcode-reader library not loaded"});loadQRWithVue(scancallback,reportcallback)||reportcallback({code:0,name:"VueMountFailed",message:"Failed to mount Vue QR component"})},getnextwebCamIndex:function(){return-1===cameraIndex?0:(cameraIndex+1)%qrReaderConstraints.length},getCamName:function(index){return qrReaderConstraints[index]?qrReaderConstraints[index].name:"Unknown Camera"},setnextwebcam:function(reportcallback){let nextcameraindex=this.getnextwebCamIndex();if(cameraIndex!=nextcameraindex)try{this.selectCamera(nextcameraindex,reportcallback)}catch(e){console.error(e),reportcallback(e)}},selectCamera:function(nextcameraindex,reportcallback){vueApp&&vueApp.switchCamera?vueApp.switchCamera(nextcameraindex):(console.warn("Vue app or switchCamera method not available"),reportcallback({code:0,name:"VueNotInitialized",message:"Error: Vue component not properly initialized"}))}};return webqr}));

//# sourceMappingURL=webqr.min.js.map