(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(typeof self !== 'undefined' ? self : this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 201);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(3);
var core = __webpack_require__(26);
var hide = __webpack_require__(17);
var redefine = __webpack_require__(18);
var ctx = __webpack_require__(27);
var PROTOTYPE = 'prototype';

var $export = function (type, name, source) {
  var IS_FORCED = type & $export.F;
  var IS_GLOBAL = type & $export.G;
  var IS_STATIC = type & $export.S;
  var IS_PROTO = type & $export.P;
  var IS_BIND = type & $export.B;
  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] || (global[name] = {}) : (global[name] || {})[PROTOTYPE];
  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
  var expProto = exports[PROTOTYPE] || (exports[PROTOTYPE] = {});
  var key, own, out, exp;
  if (IS_GLOBAL) source = name;
  for (key in source) {
    // contains in native
    own = !IS_FORCED && target && target[key] !== undefined;
    // export native or passed
    out = (own ? target : source)[key];
    // bind timers to global for call from export context
    exp = IS_BIND && own ? ctx(out, global) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
    // extend global
    if (target) redefine(target, key, out, type & $export.U);
    // export
    if (exports[key] != out) hide(exports, key, exp);
    if (IS_PROTO && expProto[key] != out) expProto[key] = out;
  }
};
global.core = core;
// type bitmap
$export.F = 1;   // forced
$export.G = 2;   // global
$export.S = 4;   // static
$export.P = 8;   // proto
$export.B = 16;  // bind
$export.W = 32;  // wrap
$export.U = 64;  // safe
$export.R = 128; // real proto method for `library`
module.exports = $export;


/***/ }),
/* 1 */
/***/ (function(module, exports) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(5);
module.exports = function (it) {
  if (!isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};


/***/ }),
/* 3 */
/***/ (function(module, exports) {

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self
  // eslint-disable-next-line no-new-func
  : Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef


/***/ }),
/* 4 */
/***/ (function(module, exports) {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (e) {
    return true;
  }
};


/***/ }),
/* 5 */
/***/ (function(module, exports) {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

/* eslint-disable node/no-deprecated-api */
var buffer = __webpack_require__(8)
var Buffer = buffer.Buffer

// alternative to using Object.keys for old browsers
function copyProps (src, dst) {
  for (var key in src) {
    dst[key] = src[key]
  }
}
if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
  module.exports = buffer
} else {
  // Copy properties from require('buffer')
  copyProps(buffer, exports)
  exports.Buffer = SafeBuffer
}

function SafeBuffer (arg, encodingOrOffset, length) {
  return Buffer(arg, encodingOrOffset, length)
}

// Copy static methods from Buffer
copyProps(Buffer, SafeBuffer)

SafeBuffer.from = function (arg, encodingOrOffset, length) {
  if (typeof arg === 'number') {
    throw new TypeError('Argument must not be a number')
  }
  return Buffer(arg, encodingOrOffset, length)
}

SafeBuffer.alloc = function (size, fill, encoding) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  var buf = Buffer(size)
  if (fill !== undefined) {
    if (typeof encoding === 'string') {
      buf.fill(fill, encoding)
    } else {
      buf.fill(fill)
    }
  } else {
    buf.fill(0)
  }
  return buf
}

SafeBuffer.allocUnsafe = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  return Buffer(size)
}

SafeBuffer.allocUnsafeSlow = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  return buffer.SlowBuffer(size)
}


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

var store = __webpack_require__(70)('wks');
var uid = __webpack_require__(44);
var Symbol = __webpack_require__(3).Symbol;
var USE_SYMBOL = typeof Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] =
    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
};

$exports.store = store;


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */



var base64 = __webpack_require__(414)
var ieee754 = __webpack_require__(415)
var isArray = __webpack_require__(416)

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Use Object implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * Due to various browser bugs, sometimes the Object implementation will be used even
 * when the browser supports typed arrays.
 *
 * Note:
 *
 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
 *
 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
 *
 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
 *     incorrect length in some situations.

 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
 * get the Object implementation, which is slower but behaves correctly.
 */
Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
  ? global.TYPED_ARRAY_SUPPORT
  : typedArraySupport()

/*
 * Export kMaxLength after typed array support is determined.
 */
exports.kMaxLength = kMaxLength()

function typedArraySupport () {
  try {
    var arr = new Uint8Array(1)
    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
    return arr.foo() === 42 && // typed array instances can be augmented
        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
  } catch (e) {
    return false
  }
}

function kMaxLength () {
  return Buffer.TYPED_ARRAY_SUPPORT
    ? 0x7fffffff
    : 0x3fffffff
}

function createBuffer (that, length) {
  if (kMaxLength() < length) {
    throw new RangeError('Invalid typed array length')
  }
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = new Uint8Array(length)
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    if (that === null) {
      that = new Buffer(length)
    }
    that.length = length
  }

  return that
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
    return new Buffer(arg, encodingOrOffset, length)
  }

  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new Error(
        'If encoding is specified then the first argument must be a string'
      )
    }
    return allocUnsafe(this, arg)
  }
  return from(this, arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

// TODO: Legacy, not needed anymore. Remove in next major version.
Buffer._augment = function (arr) {
  arr.__proto__ = Buffer.prototype
  return arr
}

function from (that, value, encodingOrOffset, length) {
  if (typeof value === 'number') {
    throw new TypeError('"value" argument must not be a number')
  }

  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
    return fromArrayBuffer(that, value, encodingOrOffset, length)
  }

  if (typeof value === 'string') {
    return fromString(that, value, encodingOrOffset)
  }

  return fromObject(that, value)
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(null, value, encodingOrOffset, length)
}

if (Buffer.TYPED_ARRAY_SUPPORT) {
  Buffer.prototype.__proto__ = Uint8Array.prototype
  Buffer.__proto__ = Uint8Array
  if (typeof Symbol !== 'undefined' && Symbol.species &&
      Buffer[Symbol.species] === Buffer) {
    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
    Object.defineProperty(Buffer, Symbol.species, {
      value: null,
      configurable: true
    })
  }
}

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be a number')
  } else if (size < 0) {
    throw new RangeError('"size" argument must not be negative')
  }
}

function alloc (that, size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(that, size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(that, size).fill(fill, encoding)
      : createBuffer(that, size).fill(fill)
  }
  return createBuffer(that, size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(null, size, fill, encoding)
}

function allocUnsafe (that, size) {
  assertSize(size)
  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) {
    for (var i = 0; i < size; ++i) {
      that[i] = 0
    }
  }
  return that
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(null, size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(null, size)
}

function fromString (that, string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('"encoding" must be a valid string encoding')
  }

  var length = byteLength(string, encoding) | 0
  that = createBuffer(that, length)

  var actual = that.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    that = that.slice(0, actual)
  }

  return that
}

function fromArrayLike (that, array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  that = createBuffer(that, length)
  for (var i = 0; i < length; i += 1) {
    that[i] = array[i] & 255
  }
  return that
}

function fromArrayBuffer (that, array, byteOffset, length) {
  array.byteLength // this throws if `array` is not a valid ArrayBuffer

  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('\'offset\' is out of bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('\'length\' is out of bounds')
  }

  if (byteOffset === undefined && length === undefined) {
    array = new Uint8Array(array)
  } else if (length === undefined) {
    array = new Uint8Array(array, byteOffset)
  } else {
    array = new Uint8Array(array, byteOffset, length)
  }

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = array
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    that = fromArrayLike(that, array)
  }
  return that
}

function fromObject (that, obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    that = createBuffer(that, len)

    if (that.length === 0) {
      return that
    }

    obj.copy(that, 0, 0, len)
    return that
  }

  if (obj) {
    if ((typeof ArrayBuffer !== 'undefined' &&
        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
      if (typeof obj.length !== 'number' || isnan(obj.length)) {
        return createBuffer(that, 0)
      }
      return fromArrayLike(that, obj)
    }

    if (obj.type === 'Buffer' && isArray(obj.data)) {
      return fromArrayLike(that, obj.data)
    }
  }

  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
}

function checked (length) {
  // Note: cannot use `length < kMaxLength()` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= kMaxLength()) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return !!(b != null && b._isBuffer)
}

Buffer.compare = function compare (a, b) {
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError('Arguments must be Buffers')
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos)
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    string = '' + string
  }

  var len = string.length
  if (len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
      case undefined:
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) return utf8ToBytes(string).length // assume utf8
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
// Buffer instances.
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  var length = this.length | 0
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  var str = ''
  var max = exports.INSPECT_MAX_BYTES
  if (this.length > 0) {
    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
    if (this.length > max) str += ' ... '
  }
  return '<Buffer ' + str + '>'
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (!Buffer.isBuffer(target)) {
    throw new TypeError('Argument must be a Buffer')
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  var x = thisEnd - thisStart
  var y = end - start
  var len = Math.min(x, y)

  var thisCopy = this.slice(thisStart, thisEnd)
  var targetCopy = target.slice(start, end)

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset  // Coerce to Number.
  if (isNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (Buffer.TYPED_ARRAY_SUPPORT &&
        typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1
  var arrLength = arr.length
  var valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i
  if (dir) {
    var foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      var found = true
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  var remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  // must be an even number of digits
  var strLen = string.length
  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

  if (length > strLen / 2) {
    length = strLen / 2
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16)
    if (isNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset | 0
    if (isFinite(length)) {
      length = length | 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  // legacy write(string, encoding, offset, length) - remove in v0.13
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  var res = []

  var i = start
  while (i < end) {
    var firstByte = buf[i]
    var codePoint = null
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
      : (firstByte > 0xBF) ? 2
      : 1

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = ''
  var i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  var out = ''
  for (var i = start; i < end; ++i) {
    out += toHex(buf[i])
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end)
  var res = ''
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  var newBuf
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    newBuf = this.subarray(start, end)
    newBuf.__proto__ = Buffer.prototype
  } else {
    var sliceLen = end - start
    newBuf = new Buffer(sliceLen, undefined)
    for (var i = 0; i < sliceLen; ++i) {
      newBuf[i] = this[i + start]
    }
  }

  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }

  return val
}

Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length)
  }

  var val = this[offset + --byteLength]
  var mul = 1
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul
  }

  return val
}

Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  return this[offset]
}

Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return this[offset] | (this[offset + 1] << 8)
}

Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return (this[offset] << 8) | this[offset + 1]
}

Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
}

Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
}

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var i = byteLength
  var mul = 1
  var val = this[offset + --i]
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
}

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset] | (this[offset + 1] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset + 1] | (this[offset] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
}

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
}

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, true, 23, 4)
}

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, false, 23, 4)
}

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, true, 52, 8)
}

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, false, 52, 8)
}

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var mul = 1
  var i = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var i = byteLength - 1
  var mul = 1
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  this[offset] = (value & 0xff)
  return offset + 1
}

function objectWriteUInt16 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
      (littleEndian ? i : 1 - i) * 8
  }
}

Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

function objectWriteUInt32 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffffffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
  }
}

Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset + 3] = (value >>> 24)
    this[offset + 2] = (value >>> 16)
    this[offset + 1] = (value >>> 8)
    this[offset] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = 0
  var mul = 1
  var sub = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = byteLength - 1
  var mul = 1
  var sub = 0
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  if (value < 0) value = 0xff + value + 1
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
    this[offset + 2] = (value >>> 16)
    this[offset + 3] = (value >>> 24)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (value < 0) value = 0xffffffff + value + 1
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4)
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
}

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
}

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8)
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
}

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
}

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!start) start = 0
  if (!end && end !== 0) end = this.length
  if (targetStart >= target.length) targetStart = target.length
  if (!targetStart) targetStart = 0
  if (end > 0 && end < start) end = start

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  var len = end - start
  var i

  if (this === target && start < targetStart && targetStart < end) {
    // descending copy from end
    for (i = len - 1; i >= 0; --i) {
      target[i + targetStart] = this[i + start]
    }
  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
    // ascending copy from start
    for (i = 0; i < len; ++i) {
      target[i + targetStart] = this[i + start]
    }
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, start + len),
      targetStart
    )
  }

  return len
}

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start
      start = 0
      end = this.length
    } else if (typeof end === 'string') {
      encoding = end
      end = this.length
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0)
      if (code < 256) {
        val = code
      }
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
  } else if (typeof val === 'number') {
    val = val & 255
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0
  end = end === undefined ? this.length : end >>> 0

  if (!val) val = 0

  var i
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val
    }
  } else {
    var bytes = Buffer.isBuffer(val)
      ? val
      : utf8ToBytes(new Buffer(val, encoding).toString())
    var len = bytes.length
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len]
    }
  }

  return this
}

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g

function base64clean (str) {
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '='
  }
  return str
}

function stringtrim (str) {
  if (str.trim) return str.trim()
  return str.replace(/^\s+|\s+$/g, '')
}

function toHex (n) {
  if (n < 16) return '0' + n.toString(16)
  return n.toString(16)
}

function utf8ToBytes (string, units) {
  units = units || Infinity
  var codePoint
  var length = string.length
  var leadSurrogate = null
  var bytes = []

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i)

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        }

        // valid lead
        leadSurrogate = codePoint

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
        leadSurrogate = codePoint
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
    }

    leadSurrogate = null

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint)
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF)
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i)
    hi = c >> 8
    lo = c % 256
    byteArray.push(lo)
    byteArray.push(hi)
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i]
  }
  return i
}

function isnan (val) {
  return val !== val // eslint-disable-line no-self-compare
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(15)))

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

// Thank's IE8 for his funny defineProperty
module.exports = !__webpack_require__(4)(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

var anObject = __webpack_require__(2);
var IE8_DOM_DEFINE = __webpack_require__(128);
var toPrimitive = __webpack_require__(31);
var dP = Object.defineProperty;

exports.f = __webpack_require__(9) ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return dP(O, P, Attributes);
  } catch (e) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.15 ToLength
var toInteger = __webpack_require__(33);
var min = Math.min;
module.exports = function (it) {
  return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
};


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {(function (module, exports) {
  'use strict';

  // Utils
  function assert (val, msg) {
    if (!val) throw new Error(msg || 'Assertion failed');
  }

  // Could use `inherits` module, but don't want to move from single file
  // architecture yet.
  function inherits (ctor, superCtor) {
    ctor.super_ = superCtor;
    var TempCtor = function () {};
    TempCtor.prototype = superCtor.prototype;
    ctor.prototype = new TempCtor();
    ctor.prototype.constructor = ctor;
  }

  // BN

  function BN (number, base, endian) {
    if (BN.isBN(number)) {
      return number;
    }

    this.negative = 0;
    this.words = null;
    this.length = 0;

    // Reduction context
    this.red = null;

    if (number !== null) {
      if (base === 'le' || base === 'be') {
        endian = base;
        base = 10;
      }

      this._init(number || 0, base || 10, endian || 'be');
    }
  }
  if (typeof module === 'object') {
    module.exports = BN;
  } else {
    exports.BN = BN;
  }

  BN.BN = BN;
  BN.wordSize = 26;

  var Buffer;
  try {
    Buffer = __webpack_require__(455).Buffer;
  } catch (e) {
  }

  BN.isBN = function isBN (num) {
    if (num instanceof BN) {
      return true;
    }

    return num !== null && typeof num === 'object' &&
      num.constructor.wordSize === BN.wordSize && Array.isArray(num.words);
  };

  BN.max = function max (left, right) {
    if (left.cmp(right) > 0) return left;
    return right;
  };

  BN.min = function min (left, right) {
    if (left.cmp(right) < 0) return left;
    return right;
  };

  BN.prototype._init = function init (number, base, endian) {
    if (typeof number === 'number') {
      return this._initNumber(number, base, endian);
    }

    if (typeof number === 'object') {
      return this._initArray(number, base, endian);
    }

    if (base === 'hex') {
      base = 16;
    }
    assert(base === (base | 0) && base >= 2 && base <= 36);

    number = number.toString().replace(/\s+/g, '');
    var start = 0;
    if (number[0] === '-') {
      start++;
    }

    if (base === 16) {
      this._parseHex(number, start);
    } else {
      this._parseBase(number, base, start);
    }

    if (number[0] === '-') {
      this.negative = 1;
    }

    this.strip();

    if (endian !== 'le') return;

    this._initArray(this.toArray(), base, endian);
  };

  BN.prototype._initNumber = function _initNumber (number, base, endian) {
    if (number < 0) {
      this.negative = 1;
      number = -number;
    }
    if (number < 0x4000000) {
      this.words = [ number & 0x3ffffff ];
      this.length = 1;
    } else if (number < 0x10000000000000) {
      this.words = [
        number & 0x3ffffff,
        (number / 0x4000000) & 0x3ffffff
      ];
      this.length = 2;
    } else {
      assert(number < 0x20000000000000); // 2 ^ 53 (unsafe)
      this.words = [
        number & 0x3ffffff,
        (number / 0x4000000) & 0x3ffffff,
        1
      ];
      this.length = 3;
    }

    if (endian !== 'le') return;

    // Reverse the bytes
    this._initArray(this.toArray(), base, endian);
  };

  BN.prototype._initArray = function _initArray (number, base, endian) {
    // Perhaps a Uint8Array
    assert(typeof number.length === 'number');
    if (number.length <= 0) {
      this.words = [ 0 ];
      this.length = 1;
      return this;
    }

    this.length = Math.ceil(number.length / 3);
    this.words = new Array(this.length);
    for (var i = 0; i < this.length; i++) {
      this.words[i] = 0;
    }

    var j, w;
    var off = 0;
    if (endian === 'be') {
      for (i = number.length - 1, j = 0; i >= 0; i -= 3) {
        w = number[i] | (number[i - 1] << 8) | (number[i - 2] << 16);
        this.words[j] |= (w << off) & 0x3ffffff;
        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;
        off += 24;
        if (off >= 26) {
          off -= 26;
          j++;
        }
      }
    } else if (endian === 'le') {
      for (i = 0, j = 0; i < number.length; i += 3) {
        w = number[i] | (number[i + 1] << 8) | (number[i + 2] << 16);
        this.words[j] |= (w << off) & 0x3ffffff;
        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;
        off += 24;
        if (off >= 26) {
          off -= 26;
          j++;
        }
      }
    }
    return this.strip();
  };

  function parseHex (str, start, end) {
    var r = 0;
    var len = Math.min(str.length, end);
    for (var i = start; i < len; i++) {
      var c = str.charCodeAt(i) - 48;

      r <<= 4;

      // 'a' - 'f'
      if (c >= 49 && c <= 54) {
        r |= c - 49 + 0xa;

      // 'A' - 'F'
      } else if (c >= 17 && c <= 22) {
        r |= c - 17 + 0xa;

      // '0' - '9'
      } else {
        r |= c & 0xf;
      }
    }
    return r;
  }

  BN.prototype._parseHex = function _parseHex (number, start) {
    // Create possibly bigger array to ensure that it fits the number
    this.length = Math.ceil((number.length - start) / 6);
    this.words = new Array(this.length);
    for (var i = 0; i < this.length; i++) {
      this.words[i] = 0;
    }

    var j, w;
    // Scan 24-bit chunks and add them to the number
    var off = 0;
    for (i = number.length - 6, j = 0; i >= start; i -= 6) {
      w = parseHex(number, i, i + 6);
      this.words[j] |= (w << off) & 0x3ffffff;
      // NOTE: `0x3fffff` is intentional here, 26bits max shift + 24bit hex limb
      this.words[j + 1] |= w >>> (26 - off) & 0x3fffff;
      off += 24;
      if (off >= 26) {
        off -= 26;
        j++;
      }
    }
    if (i + 6 !== start) {
      w = parseHex(number, start, i + 6);
      this.words[j] |= (w << off) & 0x3ffffff;
      this.words[j + 1] |= w >>> (26 - off) & 0x3fffff;
    }
    this.strip();
  };

  function parseBase (str, start, end, mul) {
    var r = 0;
    var len = Math.min(str.length, end);
    for (var i = start; i < len; i++) {
      var c = str.charCodeAt(i) - 48;

      r *= mul;

      // 'a'
      if (c >= 49) {
        r += c - 49 + 0xa;

      // 'A'
      } else if (c >= 17) {
        r += c - 17 + 0xa;

      // '0' - '9'
      } else {
        r += c;
      }
    }
    return r;
  }

  BN.prototype._parseBase = function _parseBase (number, base, start) {
    // Initialize as zero
    this.words = [ 0 ];
    this.length = 1;

    // Find length of limb in base
    for (var limbLen = 0, limbPow = 1; limbPow <= 0x3ffffff; limbPow *= base) {
      limbLen++;
    }
    limbLen--;
    limbPow = (limbPow / base) | 0;

    var total = number.length - start;
    var mod = total % limbLen;
    var end = Math.min(total, total - mod) + start;

    var word = 0;
    for (var i = start; i < end; i += limbLen) {
      word = parseBase(number, i, i + limbLen, base);

      this.imuln(limbPow);
      if (this.words[0] + word < 0x4000000) {
        this.words[0] += word;
      } else {
        this._iaddn(word);
      }
    }

    if (mod !== 0) {
      var pow = 1;
      word = parseBase(number, i, number.length, base);

      for (i = 0; i < mod; i++) {
        pow *= base;
      }

      this.imuln(pow);
      if (this.words[0] + word < 0x4000000) {
        this.words[0] += word;
      } else {
        this._iaddn(word);
      }
    }
  };

  BN.prototype.copy = function copy (dest) {
    dest.words = new Array(this.length);
    for (var i = 0; i < this.length; i++) {
      dest.words[i] = this.words[i];
    }
    dest.length = this.length;
    dest.negative = this.negative;
    dest.red = this.red;
  };

  BN.prototype.clone = function clone () {
    var r = new BN(null);
    this.copy(r);
    return r;
  };

  BN.prototype._expand = function _expand (size) {
    while (this.length < size) {
      this.words[this.length++] = 0;
    }
    return this;
  };

  // Remove leading `0` from `this`
  BN.prototype.strip = function strip () {
    while (this.length > 1 && this.words[this.length - 1] === 0) {
      this.length--;
    }
    return this._normSign();
  };

  BN.prototype._normSign = function _normSign () {
    // -0 = 0
    if (this.length === 1 && this.words[0] === 0) {
      this.negative = 0;
    }
    return this;
  };

  BN.prototype.inspect = function inspect () {
    return (this.red ? '<BN-R: ' : '<BN: ') + this.toString(16) + '>';
  };

  /*

  var zeros = [];
  var groupSizes = [];
  var groupBases = [];

  var s = '';
  var i = -1;
  while (++i < BN.wordSize) {
    zeros[i] = s;
    s += '0';
  }
  groupSizes[0] = 0;
  groupSizes[1] = 0;
  groupBases[0] = 0;
  groupBases[1] = 0;
  var base = 2 - 1;
  while (++base < 36 + 1) {
    var groupSize = 0;
    var groupBase = 1;
    while (groupBase < (1 << BN.wordSize) / base) {
      groupBase *= base;
      groupSize += 1;
    }
    groupSizes[base] = groupSize;
    groupBases[base] = groupBase;
  }

  */

  var zeros = [
    '',
    '0',
    '00',
    '000',
    '0000',
    '00000',
    '000000',
    '0000000',
    '00000000',
    '000000000',
    '0000000000',
    '00000000000',
    '000000000000',
    '0000000000000',
    '00000000000000',
    '000000000000000',
    '0000000000000000',
    '00000000000000000',
    '000000000000000000',
    '0000000000000000000',
    '00000000000000000000',
    '000000000000000000000',
    '0000000000000000000000',
    '00000000000000000000000',
    '000000000000000000000000',
    '0000000000000000000000000'
  ];

  var groupSizes = [
    0, 0,
    25, 16, 12, 11, 10, 9, 8,
    8, 7, 7, 7, 7, 6, 6,
    6, 6, 6, 6, 6, 5, 5,
    5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5
  ];

  var groupBases = [
    0, 0,
    33554432, 43046721, 16777216, 48828125, 60466176, 40353607, 16777216,
    43046721, 10000000, 19487171, 35831808, 62748517, 7529536, 11390625,
    16777216, 24137569, 34012224, 47045881, 64000000, 4084101, 5153632,
    6436343, 7962624, 9765625, 11881376, 14348907, 17210368, 20511149,
    24300000, 28629151, 33554432, 39135393, 45435424, 52521875, 60466176
  ];

  BN.prototype.toString = function toString (base, padding) {
    base = base || 10;
    padding = padding | 0 || 1;

    var out;
    if (base === 16 || base === 'hex') {
      out = '';
      var off = 0;
      var carry = 0;
      for (var i = 0; i < this.length; i++) {
        var w = this.words[i];
        var word = (((w << off) | carry) & 0xffffff).toString(16);
        carry = (w >>> (24 - off)) & 0xffffff;
        if (carry !== 0 || i !== this.length - 1) {
          out = zeros[6 - word.length] + word + out;
        } else {
          out = word + out;
        }
        off += 2;
        if (off >= 26) {
          off -= 26;
          i--;
        }
      }
      if (carry !== 0) {
        out = carry.toString(16) + out;
      }
      while (out.length % padding !== 0) {
        out = '0' + out;
      }
      if (this.negative !== 0) {
        out = '-' + out;
      }
      return out;
    }

    if (base === (base | 0) && base >= 2 && base <= 36) {
      // var groupSize = Math.floor(BN.wordSize * Math.LN2 / Math.log(base));
      var groupSize = groupSizes[base];
      // var groupBase = Math.pow(base, groupSize);
      var groupBase = groupBases[base];
      out = '';
      var c = this.clone();
      c.negative = 0;
      while (!c.isZero()) {
        var r = c.modn(groupBase).toString(base);
        c = c.idivn(groupBase);

        if (!c.isZero()) {
          out = zeros[groupSize - r.length] + r + out;
        } else {
          out = r + out;
        }
      }
      if (this.isZero()) {
        out = '0' + out;
      }
      while (out.length % padding !== 0) {
        out = '0' + out;
      }
      if (this.negative !== 0) {
        out = '-' + out;
      }
      return out;
    }

    assert(false, 'Base should be between 2 and 36');
  };

  BN.prototype.toNumber = function toNumber () {
    var ret = this.words[0];
    if (this.length === 2) {
      ret += this.words[1] * 0x4000000;
    } else if (this.length === 3 && this.words[2] === 0x01) {
      // NOTE: at this stage it is known that the top bit is set
      ret += 0x10000000000000 + (this.words[1] * 0x4000000);
    } else if (this.length > 2) {
      assert(false, 'Number can only safely store up to 53 bits');
    }
    return (this.negative !== 0) ? -ret : ret;
  };

  BN.prototype.toJSON = function toJSON () {
    return this.toString(16);
  };

  BN.prototype.toBuffer = function toBuffer (endian, length) {
    assert(typeof Buffer !== 'undefined');
    return this.toArrayLike(Buffer, endian, length);
  };

  BN.prototype.toArray = function toArray (endian, length) {
    return this.toArrayLike(Array, endian, length);
  };

  BN.prototype.toArrayLike = function toArrayLike (ArrayType, endian, length) {
    var byteLength = this.byteLength();
    var reqLength = length || Math.max(1, byteLength);
    assert(byteLength <= reqLength, 'byte array longer than desired length');
    assert(reqLength > 0, 'Requested array length <= 0');

    this.strip();
    var littleEndian = endian === 'le';
    var res = new ArrayType(reqLength);

    var b, i;
    var q = this.clone();
    if (!littleEndian) {
      // Assume big-endian
      for (i = 0; i < reqLength - byteLength; i++) {
        res[i] = 0;
      }

      for (i = 0; !q.isZero(); i++) {
        b = q.andln(0xff);
        q.iushrn(8);

        res[reqLength - i - 1] = b;
      }
    } else {
      for (i = 0; !q.isZero(); i++) {
        b = q.andln(0xff);
        q.iushrn(8);

        res[i] = b;
      }

      for (; i < reqLength; i++) {
        res[i] = 0;
      }
    }

    return res;
  };

  if (Math.clz32) {
    BN.prototype._countBits = function _countBits (w) {
      return 32 - Math.clz32(w);
    };
  } else {
    BN.prototype._countBits = function _countBits (w) {
      var t = w;
      var r = 0;
      if (t >= 0x1000) {
        r += 13;
        t >>>= 13;
      }
      if (t >= 0x40) {
        r += 7;
        t >>>= 7;
      }
      if (t >= 0x8) {
        r += 4;
        t >>>= 4;
      }
      if (t >= 0x02) {
        r += 2;
        t >>>= 2;
      }
      return r + t;
    };
  }

  BN.prototype._zeroBits = function _zeroBits (w) {
    // Short-cut
    if (w === 0) return 26;

    var t = w;
    var r = 0;
    if ((t & 0x1fff) === 0) {
      r += 13;
      t >>>= 13;
    }
    if ((t & 0x7f) === 0) {
      r += 7;
      t >>>= 7;
    }
    if ((t & 0xf) === 0) {
      r += 4;
      t >>>= 4;
    }
    if ((t & 0x3) === 0) {
      r += 2;
      t >>>= 2;
    }
    if ((t & 0x1) === 0) {
      r++;
    }
    return r;
  };

  // Return number of used bits in a BN
  BN.prototype.bitLength = function bitLength () {
    var w = this.words[this.length - 1];
    var hi = this._countBits(w);
    return (this.length - 1) * 26 + hi;
  };

  function toBitArray (num) {
    var w = new Array(num.bitLength());

    for (var bit = 0; bit < w.length; bit++) {
      var off = (bit / 26) | 0;
      var wbit = bit % 26;

      w[bit] = (num.words[off] & (1 << wbit)) >>> wbit;
    }

    return w;
  }

  // Number of trailing zero bits
  BN.prototype.zeroBits = function zeroBits () {
    if (this.isZero()) return 0;

    var r = 0;
    for (var i = 0; i < this.length; i++) {
      var b = this._zeroBits(this.words[i]);
      r += b;
      if (b !== 26) break;
    }
    return r;
  };

  BN.prototype.byteLength = function byteLength () {
    return Math.ceil(this.bitLength() / 8);
  };

  BN.prototype.toTwos = function toTwos (width) {
    if (this.negative !== 0) {
      return this.abs().inotn(width).iaddn(1);
    }
    return this.clone();
  };

  BN.prototype.fromTwos = function fromTwos (width) {
    if (this.testn(width - 1)) {
      return this.notn(width).iaddn(1).ineg();
    }
    return this.clone();
  };

  BN.prototype.isNeg = function isNeg () {
    return this.negative !== 0;
  };

  // Return negative clone of `this`
  BN.prototype.neg = function neg () {
    return this.clone().ineg();
  };

  BN.prototype.ineg = function ineg () {
    if (!this.isZero()) {
      this.negative ^= 1;
    }

    return this;
  };

  // Or `num` with `this` in-place
  BN.prototype.iuor = function iuor (num) {
    while (this.length < num.length) {
      this.words[this.length++] = 0;
    }

    for (var i = 0; i < num.length; i++) {
      this.words[i] = this.words[i] | num.words[i];
    }

    return this.strip();
  };

  BN.prototype.ior = function ior (num) {
    assert((this.negative | num.negative) === 0);
    return this.iuor(num);
  };

  // Or `num` with `this`
  BN.prototype.or = function or (num) {
    if (this.length > num.length) return this.clone().ior(num);
    return num.clone().ior(this);
  };

  BN.prototype.uor = function uor (num) {
    if (this.length > num.length) return this.clone().iuor(num);
    return num.clone().iuor(this);
  };

  // And `num` with `this` in-place
  BN.prototype.iuand = function iuand (num) {
    // b = min-length(num, this)
    var b;
    if (this.length > num.length) {
      b = num;
    } else {
      b = this;
    }

    for (var i = 0; i < b.length; i++) {
      this.words[i] = this.words[i] & num.words[i];
    }

    this.length = b.length;

    return this.strip();
  };

  BN.prototype.iand = function iand (num) {
    assert((this.negative | num.negative) === 0);
    return this.iuand(num);
  };

  // And `num` with `this`
  BN.prototype.and = function and (num) {
    if (this.length > num.length) return this.clone().iand(num);
    return num.clone().iand(this);
  };

  BN.prototype.uand = function uand (num) {
    if (this.length > num.length) return this.clone().iuand(num);
    return num.clone().iuand(this);
  };

  // Xor `num` with `this` in-place
  BN.prototype.iuxor = function iuxor (num) {
    // a.length > b.length
    var a;
    var b;
    if (this.length > num.length) {
      a = this;
      b = num;
    } else {
      a = num;
      b = this;
    }

    for (var i = 0; i < b.length; i++) {
      this.words[i] = a.words[i] ^ b.words[i];
    }

    if (this !== a) {
      for (; i < a.length; i++) {
        this.words[i] = a.words[i];
      }
    }

    this.length = a.length;

    return this.strip();
  };

  BN.prototype.ixor = function ixor (num) {
    assert((this.negative | num.negative) === 0);
    return this.iuxor(num);
  };

  // Xor `num` with `this`
  BN.prototype.xor = function xor (num) {
    if (this.length > num.length) return this.clone().ixor(num);
    return num.clone().ixor(this);
  };

  BN.prototype.uxor = function uxor (num) {
    if (this.length > num.length) return this.clone().iuxor(num);
    return num.clone().iuxor(this);
  };

  // Not ``this`` with ``width`` bitwidth
  BN.prototype.inotn = function inotn (width) {
    assert(typeof width === 'number' && width >= 0);

    var bytesNeeded = Math.ceil(width / 26) | 0;
    var bitsLeft = width % 26;

    // Extend the buffer with leading zeroes
    this._expand(bytesNeeded);

    if (bitsLeft > 0) {
      bytesNeeded--;
    }

    // Handle complete words
    for (var i = 0; i < bytesNeeded; i++) {
      this.words[i] = ~this.words[i] & 0x3ffffff;
    }

    // Handle the residue
    if (bitsLeft > 0) {
      this.words[i] = ~this.words[i] & (0x3ffffff >> (26 - bitsLeft));
    }

    // And remove leading zeroes
    return this.strip();
  };

  BN.prototype.notn = function notn (width) {
    return this.clone().inotn(width);
  };

  // Set `bit` of `this`
  BN.prototype.setn = function setn (bit, val) {
    assert(typeof bit === 'number' && bit >= 0);

    var off = (bit / 26) | 0;
    var wbit = bit % 26;

    this._expand(off + 1);

    if (val) {
      this.words[off] = this.words[off] | (1 << wbit);
    } else {
      this.words[off] = this.words[off] & ~(1 << wbit);
    }

    return this.strip();
  };

  // Add `num` to `this` in-place
  BN.prototype.iadd = function iadd (num) {
    var r;

    // negative + positive
    if (this.negative !== 0 && num.negative === 0) {
      this.negative = 0;
      r = this.isub(num);
      this.negative ^= 1;
      return this._normSign();

    // positive + negative
    } else if (this.negative === 0 && num.negative !== 0) {
      num.negative = 0;
      r = this.isub(num);
      num.negative = 1;
      return r._normSign();
    }

    // a.length > b.length
    var a, b;
    if (this.length > num.length) {
      a = this;
      b = num;
    } else {
      a = num;
      b = this;
    }

    var carry = 0;
    for (var i = 0; i < b.length; i++) {
      r = (a.words[i] | 0) + (b.words[i] | 0) + carry;
      this.words[i] = r & 0x3ffffff;
      carry = r >>> 26;
    }
    for (; carry !== 0 && i < a.length; i++) {
      r = (a.words[i] | 0) + carry;
      this.words[i] = r & 0x3ffffff;
      carry = r >>> 26;
    }

    this.length = a.length;
    if (carry !== 0) {
      this.words[this.length] = carry;
      this.length++;
    // Copy the rest of the words
    } else if (a !== this) {
      for (; i < a.length; i++) {
        this.words[i] = a.words[i];
      }
    }

    return this;
  };

  // Add `num` to `this`
  BN.prototype.add = function add (num) {
    var res;
    if (num.negative !== 0 && this.negative === 0) {
      num.negative = 0;
      res = this.sub(num);
      num.negative ^= 1;
      return res;
    } else if (num.negative === 0 && this.negative !== 0) {
      this.negative = 0;
      res = num.sub(this);
      this.negative = 1;
      return res;
    }

    if (this.length > num.length) return this.clone().iadd(num);

    return num.clone().iadd(this);
  };

  // Subtract `num` from `this` in-place
  BN.prototype.isub = function isub (num) {
    // this - (-num) = this + num
    if (num.negative !== 0) {
      num.negative = 0;
      var r = this.iadd(num);
      num.negative = 1;
      return r._normSign();

    // -this - num = -(this + num)
    } else if (this.negative !== 0) {
      this.negative = 0;
      this.iadd(num);
      this.negative = 1;
      return this._normSign();
    }

    // At this point both numbers are positive
    var cmp = this.cmp(num);

    // Optimization - zeroify
    if (cmp === 0) {
      this.negative = 0;
      this.length = 1;
      this.words[0] = 0;
      return this;
    }

    // a > b
    var a, b;
    if (cmp > 0) {
      a = this;
      b = num;
    } else {
      a = num;
      b = this;
    }

    var carry = 0;
    for (var i = 0; i < b.length; i++) {
      r = (a.words[i] | 0) - (b.words[i] | 0) + carry;
      carry = r >> 26;
      this.words[i] = r & 0x3ffffff;
    }
    for (; carry !== 0 && i < a.length; i++) {
      r = (a.words[i] | 0) + carry;
      carry = r >> 26;
      this.words[i] = r & 0x3ffffff;
    }

    // Copy rest of the words
    if (carry === 0 && i < a.length && a !== this) {
      for (; i < a.length; i++) {
        this.words[i] = a.words[i];
      }
    }

    this.length = Math.max(this.length, i);

    if (a !== this) {
      this.negative = 1;
    }

    return this.strip();
  };

  // Subtract `num` from `this`
  BN.prototype.sub = function sub (num) {
    return this.clone().isub(num);
  };

  function smallMulTo (self, num, out) {
    out.negative = num.negative ^ self.negative;
    var len = (self.length + num.length) | 0;
    out.length = len;
    len = (len - 1) | 0;

    // Peel one iteration (compiler can't do it, because of code complexity)
    var a = self.words[0] | 0;
    var b = num.words[0] | 0;
    var r = a * b;

    var lo = r & 0x3ffffff;
    var carry = (r / 0x4000000) | 0;
    out.words[0] = lo;

    for (var k = 1; k < len; k++) {
      // Sum all words with the same `i + j = k` and accumulate `ncarry`,
      // note that ncarry could be >= 0x3ffffff
      var ncarry = carry >>> 26;
      var rword = carry & 0x3ffffff;
      var maxJ = Math.min(k, num.length - 1);
      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {
        var i = (k - j) | 0;
        a = self.words[i] | 0;
        b = num.words[j] | 0;
        r = a * b + rword;
        ncarry += (r / 0x4000000) | 0;
        rword = r & 0x3ffffff;
      }
      out.words[k] = rword | 0;
      carry = ncarry | 0;
    }
    if (carry !== 0) {
      out.words[k] = carry | 0;
    } else {
      out.length--;
    }

    return out.strip();
  }

  // TODO(indutny): it may be reasonable to omit it for users who don't need
  // to work with 256-bit numbers, otherwise it gives 20% improvement for 256-bit
  // multiplication (like elliptic secp256k1).
  var comb10MulTo = function comb10MulTo (self, num, out) {
    var a = self.words;
    var b = num.words;
    var o = out.words;
    var c = 0;
    var lo;
    var mid;
    var hi;
    var a0 = a[0] | 0;
    var al0 = a0 & 0x1fff;
    var ah0 = a0 >>> 13;
    var a1 = a[1] | 0;
    var al1 = a1 & 0x1fff;
    var ah1 = a1 >>> 13;
    var a2 = a[2] | 0;
    var al2 = a2 & 0x1fff;
    var ah2 = a2 >>> 13;
    var a3 = a[3] | 0;
    var al3 = a3 & 0x1fff;
    var ah3 = a3 >>> 13;
    var a4 = a[4] | 0;
    var al4 = a4 & 0x1fff;
    var ah4 = a4 >>> 13;
    var a5 = a[5] | 0;
    var al5 = a5 & 0x1fff;
    var ah5 = a5 >>> 13;
    var a6 = a[6] | 0;
    var al6 = a6 & 0x1fff;
    var ah6 = a6 >>> 13;
    var a7 = a[7] | 0;
    var al7 = a7 & 0x1fff;
    var ah7 = a7 >>> 13;
    var a8 = a[8] | 0;
    var al8 = a8 & 0x1fff;
    var ah8 = a8 >>> 13;
    var a9 = a[9] | 0;
    var al9 = a9 & 0x1fff;
    var ah9 = a9 >>> 13;
    var b0 = b[0] | 0;
    var bl0 = b0 & 0x1fff;
    var bh0 = b0 >>> 13;
    var b1 = b[1] | 0;
    var bl1 = b1 & 0x1fff;
    var bh1 = b1 >>> 13;
    var b2 = b[2] | 0;
    var bl2 = b2 & 0x1fff;
    var bh2 = b2 >>> 13;
    var b3 = b[3] | 0;
    var bl3 = b3 & 0x1fff;
    var bh3 = b3 >>> 13;
    var b4 = b[4] | 0;
    var bl4 = b4 & 0x1fff;
    var bh4 = b4 >>> 13;
    var b5 = b[5] | 0;
    var bl5 = b5 & 0x1fff;
    var bh5 = b5 >>> 13;
    var b6 = b[6] | 0;
    var bl6 = b6 & 0x1fff;
    var bh6 = b6 >>> 13;
    var b7 = b[7] | 0;
    var bl7 = b7 & 0x1fff;
    var bh7 = b7 >>> 13;
    var b8 = b[8] | 0;
    var bl8 = b8 & 0x1fff;
    var bh8 = b8 >>> 13;
    var b9 = b[9] | 0;
    var bl9 = b9 & 0x1fff;
    var bh9 = b9 >>> 13;

    out.negative = self.negative ^ num.negative;
    out.length = 19;
    /* k = 0 */
    lo = Math.imul(al0, bl0);
    mid = Math.imul(al0, bh0);
    mid = (mid + Math.imul(ah0, bl0)) | 0;
    hi = Math.imul(ah0, bh0);
    var w0 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w0 >>> 26)) | 0;
    w0 &= 0x3ffffff;
    /* k = 1 */
    lo = Math.imul(al1, bl0);
    mid = Math.imul(al1, bh0);
    mid = (mid + Math.imul(ah1, bl0)) | 0;
    hi = Math.imul(ah1, bh0);
    lo = (lo + Math.imul(al0, bl1)) | 0;
    mid = (mid + Math.imul(al0, bh1)) | 0;
    mid = (mid + Math.imul(ah0, bl1)) | 0;
    hi = (hi + Math.imul(ah0, bh1)) | 0;
    var w1 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w1 >>> 26)) | 0;
    w1 &= 0x3ffffff;
    /* k = 2 */
    lo = Math.imul(al2, bl0);
    mid = Math.imul(al2, bh0);
    mid = (mid + Math.imul(ah2, bl0)) | 0;
    hi = Math.imul(ah2, bh0);
    lo = (lo + Math.imul(al1, bl1)) | 0;
    mid = (mid + Math.imul(al1, bh1)) | 0;
    mid = (mid + Math.imul(ah1, bl1)) | 0;
    hi = (hi + Math.imul(ah1, bh1)) | 0;
    lo = (lo + Math.imul(al0, bl2)) | 0;
    mid = (mid + Math.imul(al0, bh2)) | 0;
    mid = (mid + Math.imul(ah0, bl2)) | 0;
    hi = (hi + Math.imul(ah0, bh2)) | 0;
    var w2 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w2 >>> 26)) | 0;
    w2 &= 0x3ffffff;
    /* k = 3 */
    lo = Math.imul(al3, bl0);
    mid = Math.imul(al3, bh0);
    mid = (mid + Math.imul(ah3, bl0)) | 0;
    hi = Math.imul(ah3, bh0);
    lo = (lo + Math.imul(al2, bl1)) | 0;
    mid = (mid + Math.imul(al2, bh1)) | 0;
    mid = (mid + Math.imul(ah2, bl1)) | 0;
    hi = (hi + Math.imul(ah2, bh1)) | 0;
    lo = (lo + Math.imul(al1, bl2)) | 0;
    mid = (mid + Math.imul(al1, bh2)) | 0;
    mid = (mid + Math.imul(ah1, bl2)) | 0;
    hi = (hi + Math.imul(ah1, bh2)) | 0;
    lo = (lo + Math.imul(al0, bl3)) | 0;
    mid = (mid + Math.imul(al0, bh3)) | 0;
    mid = (mid + Math.imul(ah0, bl3)) | 0;
    hi = (hi + Math.imul(ah0, bh3)) | 0;
    var w3 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w3 >>> 26)) | 0;
    w3 &= 0x3ffffff;
    /* k = 4 */
    lo = Math.imul(al4, bl0);
    mid = Math.imul(al4, bh0);
    mid = (mid + Math.imul(ah4, bl0)) | 0;
    hi = Math.imul(ah4, bh0);
    lo = (lo + Math.imul(al3, bl1)) | 0;
    mid = (mid + Math.imul(al3, bh1)) | 0;
    mid = (mid + Math.imul(ah3, bl1)) | 0;
    hi = (hi + Math.imul(ah3, bh1)) | 0;
    lo = (lo + Math.imul(al2, bl2)) | 0;
    mid = (mid + Math.imul(al2, bh2)) | 0;
    mid = (mid + Math.imul(ah2, bl2)) | 0;
    hi = (hi + Math.imul(ah2, bh2)) | 0;
    lo = (lo + Math.imul(al1, bl3)) | 0;
    mid = (mid + Math.imul(al1, bh3)) | 0;
    mid = (mid + Math.imul(ah1, bl3)) | 0;
    hi = (hi + Math.imul(ah1, bh3)) | 0;
    lo = (lo + Math.imul(al0, bl4)) | 0;
    mid = (mid + Math.imul(al0, bh4)) | 0;
    mid = (mid + Math.imul(ah0, bl4)) | 0;
    hi = (hi + Math.imul(ah0, bh4)) | 0;
    var w4 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w4 >>> 26)) | 0;
    w4 &= 0x3ffffff;
    /* k = 5 */
    lo = Math.imul(al5, bl0);
    mid = Math.imul(al5, bh0);
    mid = (mid + Math.imul(ah5, bl0)) | 0;
    hi = Math.imul(ah5, bh0);
    lo = (lo + Math.imul(al4, bl1)) | 0;
    mid = (mid + Math.imul(al4, bh1)) | 0;
    mid = (mid + Math.imul(ah4, bl1)) | 0;
    hi = (hi + Math.imul(ah4, bh1)) | 0;
    lo = (lo + Math.imul(al3, bl2)) | 0;
    mid = (mid + Math.imul(al3, bh2)) | 0;
    mid = (mid + Math.imul(ah3, bl2)) | 0;
    hi = (hi + Math.imul(ah3, bh2)) | 0;
    lo = (lo + Math.imul(al2, bl3)) | 0;
    mid = (mid + Math.imul(al2, bh3)) | 0;
    mid = (mid + Math.imul(ah2, bl3)) | 0;
    hi = (hi + Math.imul(ah2, bh3)) | 0;
    lo = (lo + Math.imul(al1, bl4)) | 0;
    mid = (mid + Math.imul(al1, bh4)) | 0;
    mid = (mid + Math.imul(ah1, bl4)) | 0;
    hi = (hi + Math.imul(ah1, bh4)) | 0;
    lo = (lo + Math.imul(al0, bl5)) | 0;
    mid = (mid + Math.imul(al0, bh5)) | 0;
    mid = (mid + Math.imul(ah0, bl5)) | 0;
    hi = (hi + Math.imul(ah0, bh5)) | 0;
    var w5 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w5 >>> 26)) | 0;
    w5 &= 0x3ffffff;
    /* k = 6 */
    lo = Math.imul(al6, bl0);
    mid = Math.imul(al6, bh0);
    mid = (mid + Math.imul(ah6, bl0)) | 0;
    hi = Math.imul(ah6, bh0);
    lo = (lo + Math.imul(al5, bl1)) | 0;
    mid = (mid + Math.imul(al5, bh1)) | 0;
    mid = (mid + Math.imul(ah5, bl1)) | 0;
    hi = (hi + Math.imul(ah5, bh1)) | 0;
    lo = (lo + Math.imul(al4, bl2)) | 0;
    mid = (mid + Math.imul(al4, bh2)) | 0;
    mid = (mid + Math.imul(ah4, bl2)) | 0;
    hi = (hi + Math.imul(ah4, bh2)) | 0;
    lo = (lo + Math.imul(al3, bl3)) | 0;
    mid = (mid + Math.imul(al3, bh3)) | 0;
    mid = (mid + Math.imul(ah3, bl3)) | 0;
    hi = (hi + Math.imul(ah3, bh3)) | 0;
    lo = (lo + Math.imul(al2, bl4)) | 0;
    mid = (mid + Math.imul(al2, bh4)) | 0;
    mid = (mid + Math.imul(ah2, bl4)) | 0;
    hi = (hi + Math.imul(ah2, bh4)) | 0;
    lo = (lo + Math.imul(al1, bl5)) | 0;
    mid = (mid + Math.imul(al1, bh5)) | 0;
    mid = (mid + Math.imul(ah1, bl5)) | 0;
    hi = (hi + Math.imul(ah1, bh5)) | 0;
    lo = (lo + Math.imul(al0, bl6)) | 0;
    mid = (mid + Math.imul(al0, bh6)) | 0;
    mid = (mid + Math.imul(ah0, bl6)) | 0;
    hi = (hi + Math.imul(ah0, bh6)) | 0;
    var w6 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w6 >>> 26)) | 0;
    w6 &= 0x3ffffff;
    /* k = 7 */
    lo = Math.imul(al7, bl0);
    mid = Math.imul(al7, bh0);
    mid = (mid + Math.imul(ah7, bl0)) | 0;
    hi = Math.imul(ah7, bh0);
    lo = (lo + Math.imul(al6, bl1)) | 0;
    mid = (mid + Math.imul(al6, bh1)) | 0;
    mid = (mid + Math.imul(ah6, bl1)) | 0;
    hi = (hi + Math.imul(ah6, bh1)) | 0;
    lo = (lo + Math.imul(al5, bl2)) | 0;
    mid = (mid + Math.imul(al5, bh2)) | 0;
    mid = (mid + Math.imul(ah5, bl2)) | 0;
    hi = (hi + Math.imul(ah5, bh2)) | 0;
    lo = (lo + Math.imul(al4, bl3)) | 0;
    mid = (mid + Math.imul(al4, bh3)) | 0;
    mid = (mid + Math.imul(ah4, bl3)) | 0;
    hi = (hi + Math.imul(ah4, bh3)) | 0;
    lo = (lo + Math.imul(al3, bl4)) | 0;
    mid = (mid + Math.imul(al3, bh4)) | 0;
    mid = (mid + Math.imul(ah3, bl4)) | 0;
    hi = (hi + Math.imul(ah3, bh4)) | 0;
    lo = (lo + Math.imul(al2, bl5)) | 0;
    mid = (mid + Math.imul(al2, bh5)) | 0;
    mid = (mid + Math.imul(ah2, bl5)) | 0;
    hi = (hi + Math.imul(ah2, bh5)) | 0;
    lo = (lo + Math.imul(al1, bl6)) | 0;
    mid = (mid + Math.imul(al1, bh6)) | 0;
    mid = (mid + Math.imul(ah1, bl6)) | 0;
    hi = (hi + Math.imul(ah1, bh6)) | 0;
    lo = (lo + Math.imul(al0, bl7)) | 0;
    mid = (mid + Math.imul(al0, bh7)) | 0;
    mid = (mid + Math.imul(ah0, bl7)) | 0;
    hi = (hi + Math.imul(ah0, bh7)) | 0;
    var w7 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w7 >>> 26)) | 0;
    w7 &= 0x3ffffff;
    /* k = 8 */
    lo = Math.imul(al8, bl0);
    mid = Math.imul(al8, bh0);
    mid = (mid + Math.imul(ah8, bl0)) | 0;
    hi = Math.imul(ah8, bh0);
    lo = (lo + Math.imul(al7, bl1)) | 0;
    mid = (mid + Math.imul(al7, bh1)) | 0;
    mid = (mid + Math.imul(ah7, bl1)) | 0;
    hi = (hi + Math.imul(ah7, bh1)) | 0;
    lo = (lo + Math.imul(al6, bl2)) | 0;
    mid = (mid + Math.imul(al6, bh2)) | 0;
    mid = (mid + Math.imul(ah6, bl2)) | 0;
    hi = (hi + Math.imul(ah6, bh2)) | 0;
    lo = (lo + Math.imul(al5, bl3)) | 0;
    mid = (mid + Math.imul(al5, bh3)) | 0;
    mid = (mid + Math.imul(ah5, bl3)) | 0;
    hi = (hi + Math.imul(ah5, bh3)) | 0;
    lo = (lo + Math.imul(al4, bl4)) | 0;
    mid = (mid + Math.imul(al4, bh4)) | 0;
    mid = (mid + Math.imul(ah4, bl4)) | 0;
    hi = (hi + Math.imul(ah4, bh4)) | 0;
    lo = (lo + Math.imul(al3, bl5)) | 0;
    mid = (mid + Math.imul(al3, bh5)) | 0;
    mid = (mid + Math.imul(ah3, bl5)) | 0;
    hi = (hi + Math.imul(ah3, bh5)) | 0;
    lo = (lo + Math.imul(al2, bl6)) | 0;
    mid = (mid + Math.imul(al2, bh6)) | 0;
    mid = (mid + Math.imul(ah2, bl6)) | 0;
    hi = (hi + Math.imul(ah2, bh6)) | 0;
    lo = (lo + Math.imul(al1, bl7)) | 0;
    mid = (mid + Math.imul(al1, bh7)) | 0;
    mid = (mid + Math.imul(ah1, bl7)) | 0;
    hi = (hi + Math.imul(ah1, bh7)) | 0;
    lo = (lo + Math.imul(al0, bl8)) | 0;
    mid = (mid + Math.imul(al0, bh8)) | 0;
    mid = (mid + Math.imul(ah0, bl8)) | 0;
    hi = (hi + Math.imul(ah0, bh8)) | 0;
    var w8 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w8 >>> 26)) | 0;
    w8 &= 0x3ffffff;
    /* k = 9 */
    lo = Math.imul(al9, bl0);
    mid = Math.imul(al9, bh0);
    mid = (mid + Math.imul(ah9, bl0)) | 0;
    hi = Math.imul(ah9, bh0);
    lo = (lo + Math.imul(al8, bl1)) | 0;
    mid = (mid + Math.imul(al8, bh1)) | 0;
    mid = (mid + Math.imul(ah8, bl1)) | 0;
    hi = (hi + Math.imul(ah8, bh1)) | 0;
    lo = (lo + Math.imul(al7, bl2)) | 0;
    mid = (mid + Math.imul(al7, bh2)) | 0;
    mid = (mid + Math.imul(ah7, bl2)) | 0;
    hi = (hi + Math.imul(ah7, bh2)) | 0;
    lo = (lo + Math.imul(al6, bl3)) | 0;
    mid = (mid + Math.imul(al6, bh3)) | 0;
    mid = (mid + Math.imul(ah6, bl3)) | 0;
    hi = (hi + Math.imul(ah6, bh3)) | 0;
    lo = (lo + Math.imul(al5, bl4)) | 0;
    mid = (mid + Math.imul(al5, bh4)) | 0;
    mid = (mid + Math.imul(ah5, bl4)) | 0;
    hi = (hi + Math.imul(ah5, bh4)) | 0;
    lo = (lo + Math.imul(al4, bl5)) | 0;
    mid = (mid + Math.imul(al4, bh5)) | 0;
    mid = (mid + Math.imul(ah4, bl5)) | 0;
    hi = (hi + Math.imul(ah4, bh5)) | 0;
    lo = (lo + Math.imul(al3, bl6)) | 0;
    mid = (mid + Math.imul(al3, bh6)) | 0;
    mid = (mid + Math.imul(ah3, bl6)) | 0;
    hi = (hi + Math.imul(ah3, bh6)) | 0;
    lo = (lo + Math.imul(al2, bl7)) | 0;
    mid = (mid + Math.imul(al2, bh7)) | 0;
    mid = (mid + Math.imul(ah2, bl7)) | 0;
    hi = (hi + Math.imul(ah2, bh7)) | 0;
    lo = (lo + Math.imul(al1, bl8)) | 0;
    mid = (mid + Math.imul(al1, bh8)) | 0;
    mid = (mid + Math.imul(ah1, bl8)) | 0;
    hi = (hi + Math.imul(ah1, bh8)) | 0;
    lo = (lo + Math.imul(al0, bl9)) | 0;
    mid = (mid + Math.imul(al0, bh9)) | 0;
    mid = (mid + Math.imul(ah0, bl9)) | 0;
    hi = (hi + Math.imul(ah0, bh9)) | 0;
    var w9 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w9 >>> 26)) | 0;
    w9 &= 0x3ffffff;
    /* k = 10 */
    lo = Math.imul(al9, bl1);
    mid = Math.imul(al9, bh1);
    mid = (mid + Math.imul(ah9, bl1)) | 0;
    hi = Math.imul(ah9, bh1);
    lo = (lo + Math.imul(al8, bl2)) | 0;
    mid = (mid + Math.imul(al8, bh2)) | 0;
    mid = (mid + Math.imul(ah8, bl2)) | 0;
    hi = (hi + Math.imul(ah8, bh2)) | 0;
    lo = (lo + Math.imul(al7, bl3)) | 0;
    mid = (mid + Math.imul(al7, bh3)) | 0;
    mid = (mid + Math.imul(ah7, bl3)) | 0;
    hi = (hi + Math.imul(ah7, bh3)) | 0;
    lo = (lo + Math.imul(al6, bl4)) | 0;
    mid = (mid + Math.imul(al6, bh4)) | 0;
    mid = (mid + Math.imul(ah6, bl4)) | 0;
    hi = (hi + Math.imul(ah6, bh4)) | 0;
    lo = (lo + Math.imul(al5, bl5)) | 0;
    mid = (mid + Math.imul(al5, bh5)) | 0;
    mid = (mid + Math.imul(ah5, bl5)) | 0;
    hi = (hi + Math.imul(ah5, bh5)) | 0;
    lo = (lo + Math.imul(al4, bl6)) | 0;
    mid = (mid + Math.imul(al4, bh6)) | 0;
    mid = (mid + Math.imul(ah4, bl6)) | 0;
    hi = (hi + Math.imul(ah4, bh6)) | 0;
    lo = (lo + Math.imul(al3, bl7)) | 0;
    mid = (mid + Math.imul(al3, bh7)) | 0;
    mid = (mid + Math.imul(ah3, bl7)) | 0;
    hi = (hi + Math.imul(ah3, bh7)) | 0;
    lo = (lo + Math.imul(al2, bl8)) | 0;
    mid = (mid + Math.imul(al2, bh8)) | 0;
    mid = (mid + Math.imul(ah2, bl8)) | 0;
    hi = (hi + Math.imul(ah2, bh8)) | 0;
    lo = (lo + Math.imul(al1, bl9)) | 0;
    mid = (mid + Math.imul(al1, bh9)) | 0;
    mid = (mid + Math.imul(ah1, bl9)) | 0;
    hi = (hi + Math.imul(ah1, bh9)) | 0;
    var w10 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w10 >>> 26)) | 0;
    w10 &= 0x3ffffff;
    /* k = 11 */
    lo = Math.imul(al9, bl2);
    mid = Math.imul(al9, bh2);
    mid = (mid + Math.imul(ah9, bl2)) | 0;
    hi = Math.imul(ah9, bh2);
    lo = (lo + Math.imul(al8, bl3)) | 0;
    mid = (mid + Math.imul(al8, bh3)) | 0;
    mid = (mid + Math.imul(ah8, bl3)) | 0;
    hi = (hi + Math.imul(ah8, bh3)) | 0;
    lo = (lo + Math.imul(al7, bl4)) | 0;
    mid = (mid + Math.imul(al7, bh4)) | 0;
    mid = (mid + Math.imul(ah7, bl4)) | 0;
    hi = (hi + Math.imul(ah7, bh4)) | 0;
    lo = (lo + Math.imul(al6, bl5)) | 0;
    mid = (mid + Math.imul(al6, bh5)) | 0;
    mid = (mid + Math.imul(ah6, bl5)) | 0;
    hi = (hi + Math.imul(ah6, bh5)) | 0;
    lo = (lo + Math.imul(al5, bl6)) | 0;
    mid = (mid + Math.imul(al5, bh6)) | 0;
    mid = (mid + Math.imul(ah5, bl6)) | 0;
    hi = (hi + Math.imul(ah5, bh6)) | 0;
    lo = (lo + Math.imul(al4, bl7)) | 0;
    mid = (mid + Math.imul(al4, bh7)) | 0;
    mid = (mid + Math.imul(ah4, bl7)) | 0;
    hi = (hi + Math.imul(ah4, bh7)) | 0;
    lo = (lo + Math.imul(al3, bl8)) | 0;
    mid = (mid + Math.imul(al3, bh8)) | 0;
    mid = (mid + Math.imul(ah3, bl8)) | 0;
    hi = (hi + Math.imul(ah3, bh8)) | 0;
    lo = (lo + Math.imul(al2, bl9)) | 0;
    mid = (mid + Math.imul(al2, bh9)) | 0;
    mid = (mid + Math.imul(ah2, bl9)) | 0;
    hi = (hi + Math.imul(ah2, bh9)) | 0;
    var w11 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w11 >>> 26)) | 0;
    w11 &= 0x3ffffff;
    /* k = 12 */
    lo = Math.imul(al9, bl3);
    mid = Math.imul(al9, bh3);
    mid = (mid + Math.imul(ah9, bl3)) | 0;
    hi = Math.imul(ah9, bh3);
    lo = (lo + Math.imul(al8, bl4)) | 0;
    mid = (mid + Math.imul(al8, bh4)) | 0;
    mid = (mid + Math.imul(ah8, bl4)) | 0;
    hi = (hi + Math.imul(ah8, bh4)) | 0;
    lo = (lo + Math.imul(al7, bl5)) | 0;
    mid = (mid + Math.imul(al7, bh5)) | 0;
    mid = (mid + Math.imul(ah7, bl5)) | 0;
    hi = (hi + Math.imul(ah7, bh5)) | 0;
    lo = (lo + Math.imul(al6, bl6)) | 0;
    mid = (mid + Math.imul(al6, bh6)) | 0;
    mid = (mid + Math.imul(ah6, bl6)) | 0;
    hi = (hi + Math.imul(ah6, bh6)) | 0;
    lo = (lo + Math.imul(al5, bl7)) | 0;
    mid = (mid + Math.imul(al5, bh7)) | 0;
    mid = (mid + Math.imul(ah5, bl7)) | 0;
    hi = (hi + Math.imul(ah5, bh7)) | 0;
    lo = (lo + Math.imul(al4, bl8)) | 0;
    mid = (mid + Math.imul(al4, bh8)) | 0;
    mid = (mid + Math.imul(ah4, bl8)) | 0;
    hi = (hi + Math.imul(ah4, bh8)) | 0;
    lo = (lo + Math.imul(al3, bl9)) | 0;
    mid = (mid + Math.imul(al3, bh9)) | 0;
    mid = (mid + Math.imul(ah3, bl9)) | 0;
    hi = (hi + Math.imul(ah3, bh9)) | 0;
    var w12 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w12 >>> 26)) | 0;
    w12 &= 0x3ffffff;
    /* k = 13 */
    lo = Math.imul(al9, bl4);
    mid = Math.imul(al9, bh4);
    mid = (mid + Math.imul(ah9, bl4)) | 0;
    hi = Math.imul(ah9, bh4);
    lo = (lo + Math.imul(al8, bl5)) | 0;
    mid = (mid + Math.imul(al8, bh5)) | 0;
    mid = (mid + Math.imul(ah8, bl5)) | 0;
    hi = (hi + Math.imul(ah8, bh5)) | 0;
    lo = (lo + Math.imul(al7, bl6)) | 0;
    mid = (mid + Math.imul(al7, bh6)) | 0;
    mid = (mid + Math.imul(ah7, bl6)) | 0;
    hi = (hi + Math.imul(ah7, bh6)) | 0;
    lo = (lo + Math.imul(al6, bl7)) | 0;
    mid = (mid + Math.imul(al6, bh7)) | 0;
    mid = (mid + Math.imul(ah6, bl7)) | 0;
    hi = (hi + Math.imul(ah6, bh7)) | 0;
    lo = (lo + Math.imul(al5, bl8)) | 0;
    mid = (mid + Math.imul(al5, bh8)) | 0;
    mid = (mid + Math.imul(ah5, bl8)) | 0;
    hi = (hi + Math.imul(ah5, bh8)) | 0;
    lo = (lo + Math.imul(al4, bl9)) | 0;
    mid = (mid + Math.imul(al4, bh9)) | 0;
    mid = (mid + Math.imul(ah4, bl9)) | 0;
    hi = (hi + Math.imul(ah4, bh9)) | 0;
    var w13 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w13 >>> 26)) | 0;
    w13 &= 0x3ffffff;
    /* k = 14 */
    lo = Math.imul(al9, bl5);
    mid = Math.imul(al9, bh5);
    mid = (mid + Math.imul(ah9, bl5)) | 0;
    hi = Math.imul(ah9, bh5);
    lo = (lo + Math.imul(al8, bl6)) | 0;
    mid = (mid + Math.imul(al8, bh6)) | 0;
    mid = (mid + Math.imul(ah8, bl6)) | 0;
    hi = (hi + Math.imul(ah8, bh6)) | 0;
    lo = (lo + Math.imul(al7, bl7)) | 0;
    mid = (mid + Math.imul(al7, bh7)) | 0;
    mid = (mid + Math.imul(ah7, bl7)) | 0;
    hi = (hi + Math.imul(ah7, bh7)) | 0;
    lo = (lo + Math.imul(al6, bl8)) | 0;
    mid = (mid + Math.imul(al6, bh8)) | 0;
    mid = (mid + Math.imul(ah6, bl8)) | 0;
    hi = (hi + Math.imul(ah6, bh8)) | 0;
    lo = (lo + Math.imul(al5, bl9)) | 0;
    mid = (mid + Math.imul(al5, bh9)) | 0;
    mid = (mid + Math.imul(ah5, bl9)) | 0;
    hi = (hi + Math.imul(ah5, bh9)) | 0;
    var w14 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w14 >>> 26)) | 0;
    w14 &= 0x3ffffff;
    /* k = 15 */
    lo = Math.imul(al9, bl6);
    mid = Math.imul(al9, bh6);
    mid = (mid + Math.imul(ah9, bl6)) | 0;
    hi = Math.imul(ah9, bh6);
    lo = (lo + Math.imul(al8, bl7)) | 0;
    mid = (mid + Math.imul(al8, bh7)) | 0;
    mid = (mid + Math.imul(ah8, bl7)) | 0;
    hi = (hi + Math.imul(ah8, bh7)) | 0;
    lo = (lo + Math.imul(al7, bl8)) | 0;
    mid = (mid + Math.imul(al7, bh8)) | 0;
    mid = (mid + Math.imul(ah7, bl8)) | 0;
    hi = (hi + Math.imul(ah7, bh8)) | 0;
    lo = (lo + Math.imul(al6, bl9)) | 0;
    mid = (mid + Math.imul(al6, bh9)) | 0;
    mid = (mid + Math.imul(ah6, bl9)) | 0;
    hi = (hi + Math.imul(ah6, bh9)) | 0;
    var w15 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w15 >>> 26)) | 0;
    w15 &= 0x3ffffff;
    /* k = 16 */
    lo = Math.imul(al9, bl7);
    mid = Math.imul(al9, bh7);
    mid = (mid + Math.imul(ah9, bl7)) | 0;
    hi = Math.imul(ah9, bh7);
    lo = (lo + Math.imul(al8, bl8)) | 0;
    mid = (mid + Math.imul(al8, bh8)) | 0;
    mid = (mid + Math.imul(ah8, bl8)) | 0;
    hi = (hi + Math.imul(ah8, bh8)) | 0;
    lo = (lo + Math.imul(al7, bl9)) | 0;
    mid = (mid + Math.imul(al7, bh9)) | 0;
    mid = (mid + Math.imul(ah7, bl9)) | 0;
    hi = (hi + Math.imul(ah7, bh9)) | 0;
    var w16 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w16 >>> 26)) | 0;
    w16 &= 0x3ffffff;
    /* k = 17 */
    lo = Math.imul(al9, bl8);
    mid = Math.imul(al9, bh8);
    mid = (mid + Math.imul(ah9, bl8)) | 0;
    hi = Math.imul(ah9, bh8);
    lo = (lo + Math.imul(al8, bl9)) | 0;
    mid = (mid + Math.imul(al8, bh9)) | 0;
    mid = (mid + Math.imul(ah8, bl9)) | 0;
    hi = (hi + Math.imul(ah8, bh9)) | 0;
    var w17 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w17 >>> 26)) | 0;
    w17 &= 0x3ffffff;
    /* k = 18 */
    lo = Math.imul(al9, bl9);
    mid = Math.imul(al9, bh9);
    mid = (mid + Math.imul(ah9, bl9)) | 0;
    hi = Math.imul(ah9, bh9);
    var w18 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w18 >>> 26)) | 0;
    w18 &= 0x3ffffff;
    o[0] = w0;
    o[1] = w1;
    o[2] = w2;
    o[3] = w3;
    o[4] = w4;
    o[5] = w5;
    o[6] = w6;
    o[7] = w7;
    o[8] = w8;
    o[9] = w9;
    o[10] = w10;
    o[11] = w11;
    o[12] = w12;
    o[13] = w13;
    o[14] = w14;
    o[15] = w15;
    o[16] = w16;
    o[17] = w17;
    o[18] = w18;
    if (c !== 0) {
      o[19] = c;
      out.length++;
    }
    return out;
  };

  // Polyfill comb
  if (!Math.imul) {
    comb10MulTo = smallMulTo;
  }

  function bigMulTo (self, num, out) {
    out.negative = num.negative ^ self.negative;
    out.length = self.length + num.length;

    var carry = 0;
    var hncarry = 0;
    for (var k = 0; k < out.length - 1; k++) {
      // Sum all words with the same `i + j = k` and accumulate `ncarry`,
      // note that ncarry could be >= 0x3ffffff
      var ncarry = hncarry;
      hncarry = 0;
      var rword = carry & 0x3ffffff;
      var maxJ = Math.min(k, num.length - 1);
      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {
        var i = k - j;
        var a = self.words[i] | 0;
        var b = num.words[j] | 0;
        var r = a * b;

        var lo = r & 0x3ffffff;
        ncarry = (ncarry + ((r / 0x4000000) | 0)) | 0;
        lo = (lo + rword) | 0;
        rword = lo & 0x3ffffff;
        ncarry = (ncarry + (lo >>> 26)) | 0;

        hncarry += ncarry >>> 26;
        ncarry &= 0x3ffffff;
      }
      out.words[k] = rword;
      carry = ncarry;
      ncarry = hncarry;
    }
    if (carry !== 0) {
      out.words[k] = carry;
    } else {
      out.length--;
    }

    return out.strip();
  }

  function jumboMulTo (self, num, out) {
    var fftm = new FFTM();
    return fftm.mulp(self, num, out);
  }

  BN.prototype.mulTo = function mulTo (num, out) {
    var res;
    var len = this.length + num.length;
    if (this.length === 10 && num.length === 10) {
      res = comb10MulTo(this, num, out);
    } else if (len < 63) {
      res = smallMulTo(this, num, out);
    } else if (len < 1024) {
      res = bigMulTo(this, num, out);
    } else {
      res = jumboMulTo(this, num, out);
    }

    return res;
  };

  // Cooley-Tukey algorithm for FFT
  // slightly revisited to rely on looping instead of recursion

  function FFTM (x, y) {
    this.x = x;
    this.y = y;
  }

  FFTM.prototype.makeRBT = function makeRBT (N) {
    var t = new Array(N);
    var l = BN.prototype._countBits(N) - 1;
    for (var i = 0; i < N; i++) {
      t[i] = this.revBin(i, l, N);
    }

    return t;
  };

  // Returns binary-reversed representation of `x`
  FFTM.prototype.revBin = function revBin (x, l, N) {
    if (x === 0 || x === N - 1) return x;

    var rb = 0;
    for (var i = 0; i < l; i++) {
      rb |= (x & 1) << (l - i - 1);
      x >>= 1;
    }

    return rb;
  };

  // Performs "tweedling" phase, therefore 'emulating'
  // behaviour of the recursive algorithm
  FFTM.prototype.permute = function permute (rbt, rws, iws, rtws, itws, N) {
    for (var i = 0; i < N; i++) {
      rtws[i] = rws[rbt[i]];
      itws[i] = iws[rbt[i]];
    }
  };

  FFTM.prototype.transform = function transform (rws, iws, rtws, itws, N, rbt) {
    this.permute(rbt, rws, iws, rtws, itws, N);

    for (var s = 1; s < N; s <<= 1) {
      var l = s << 1;

      var rtwdf = Math.cos(2 * Math.PI / l);
      var itwdf = Math.sin(2 * Math.PI / l);

      for (var p = 0; p < N; p += l) {
        var rtwdf_ = rtwdf;
        var itwdf_ = itwdf;

        for (var j = 0; j < s; j++) {
          var re = rtws[p + j];
          var ie = itws[p + j];

          var ro = rtws[p + j + s];
          var io = itws[p + j + s];

          var rx = rtwdf_ * ro - itwdf_ * io;

          io = rtwdf_ * io + itwdf_ * ro;
          ro = rx;

          rtws[p + j] = re + ro;
          itws[p + j] = ie + io;

          rtws[p + j + s] = re - ro;
          itws[p + j + s] = ie - io;

          /* jshint maxdepth : false */
          if (j !== l) {
            rx = rtwdf * rtwdf_ - itwdf * itwdf_;

            itwdf_ = rtwdf * itwdf_ + itwdf * rtwdf_;
            rtwdf_ = rx;
          }
        }
      }
    }
  };

  FFTM.prototype.guessLen13b = function guessLen13b (n, m) {
    var N = Math.max(m, n) | 1;
    var odd = N & 1;
    var i = 0;
    for (N = N / 2 | 0; N; N = N >>> 1) {
      i++;
    }

    return 1 << i + 1 + odd;
  };

  FFTM.prototype.conjugate = function conjugate (rws, iws, N) {
    if (N <= 1) return;

    for (var i = 0; i < N / 2; i++) {
      var t = rws[i];

      rws[i] = rws[N - i - 1];
      rws[N - i - 1] = t;

      t = iws[i];

      iws[i] = -iws[N - i - 1];
      iws[N - i - 1] = -t;
    }
  };

  FFTM.prototype.normalize13b = function normalize13b (ws, N) {
    var carry = 0;
    for (var i = 0; i < N / 2; i++) {
      var w = Math.round(ws[2 * i + 1] / N) * 0x2000 +
        Math.round(ws[2 * i] / N) +
        carry;

      ws[i] = w & 0x3ffffff;

      if (w < 0x4000000) {
        carry = 0;
      } else {
        carry = w / 0x4000000 | 0;
      }
    }

    return ws;
  };

  FFTM.prototype.convert13b = function convert13b (ws, len, rws, N) {
    var carry = 0;
    for (var i = 0; i < len; i++) {
      carry = carry + (ws[i] | 0);

      rws[2 * i] = carry & 0x1fff; carry = carry >>> 13;
      rws[2 * i + 1] = carry & 0x1fff; carry = carry >>> 13;
    }

    // Pad with zeroes
    for (i = 2 * len; i < N; ++i) {
      rws[i] = 0;
    }

    assert(carry === 0);
    assert((carry & ~0x1fff) === 0);
  };

  FFTM.prototype.stub = function stub (N) {
    var ph = new Array(N);
    for (var i = 0; i < N; i++) {
      ph[i] = 0;
    }

    return ph;
  };

  FFTM.prototype.mulp = function mulp (x, y, out) {
    var N = 2 * this.guessLen13b(x.length, y.length);

    var rbt = this.makeRBT(N);

    var _ = this.stub(N);

    var rws = new Array(N);
    var rwst = new Array(N);
    var iwst = new Array(N);

    var nrws = new Array(N);
    var nrwst = new Array(N);
    var niwst = new Array(N);

    var rmws = out.words;
    rmws.length = N;

    this.convert13b(x.words, x.length, rws, N);
    this.convert13b(y.words, y.length, nrws, N);

    this.transform(rws, _, rwst, iwst, N, rbt);
    this.transform(nrws, _, nrwst, niwst, N, rbt);

    for (var i = 0; i < N; i++) {
      var rx = rwst[i] * nrwst[i] - iwst[i] * niwst[i];
      iwst[i] = rwst[i] * niwst[i] + iwst[i] * nrwst[i];
      rwst[i] = rx;
    }

    this.conjugate(rwst, iwst, N);
    this.transform(rwst, iwst, rmws, _, N, rbt);
    this.conjugate(rmws, _, N);
    this.normalize13b(rmws, N);

    out.negative = x.negative ^ y.negative;
    out.length = x.length + y.length;
    return out.strip();
  };

  // Multiply `this` by `num`
  BN.prototype.mul = function mul (num) {
    var out = new BN(null);
    out.words = new Array(this.length + num.length);
    return this.mulTo(num, out);
  };

  // Multiply employing FFT
  BN.prototype.mulf = function mulf (num) {
    var out = new BN(null);
    out.words = new Array(this.length + num.length);
    return jumboMulTo(this, num, out);
  };

  // In-place Multiplication
  BN.prototype.imul = function imul (num) {
    return this.clone().mulTo(num, this);
  };

  BN.prototype.imuln = function imuln (num) {
    assert(typeof num === 'number');
    assert(num < 0x4000000);

    // Carry
    var carry = 0;
    for (var i = 0; i < this.length; i++) {
      var w = (this.words[i] | 0) * num;
      var lo = (w & 0x3ffffff) + (carry & 0x3ffffff);
      carry >>= 26;
      carry += (w / 0x4000000) | 0;
      // NOTE: lo is 27bit maximum
      carry += lo >>> 26;
      this.words[i] = lo & 0x3ffffff;
    }

    if (carry !== 0) {
      this.words[i] = carry;
      this.length++;
    }

    return this;
  };

  BN.prototype.muln = function muln (num) {
    return this.clone().imuln(num);
  };

  // `this` * `this`
  BN.prototype.sqr = function sqr () {
    return this.mul(this);
  };

  // `this` * `this` in-place
  BN.prototype.isqr = function isqr () {
    return this.imul(this.clone());
  };

  // Math.pow(`this`, `num`)
  BN.prototype.pow = function pow (num) {
    var w = toBitArray(num);
    if (w.length === 0) return new BN(1);

    // Skip leading zeroes
    var res = this;
    for (var i = 0; i < w.length; i++, res = res.sqr()) {
      if (w[i] !== 0) break;
    }

    if (++i < w.length) {
      for (var q = res.sqr(); i < w.length; i++, q = q.sqr()) {
        if (w[i] === 0) continue;

        res = res.mul(q);
      }
    }

    return res;
  };

  // Shift-left in-place
  BN.prototype.iushln = function iushln (bits) {
    assert(typeof bits === 'number' && bits >= 0);
    var r = bits % 26;
    var s = (bits - r) / 26;
    var carryMask = (0x3ffffff >>> (26 - r)) << (26 - r);
    var i;

    if (r !== 0) {
      var carry = 0;

      for (i = 0; i < this.length; i++) {
        var newCarry = this.words[i] & carryMask;
        var c = ((this.words[i] | 0) - newCarry) << r;
        this.words[i] = c | carry;
        carry = newCarry >>> (26 - r);
      }

      if (carry) {
        this.words[i] = carry;
        this.length++;
      }
    }

    if (s !== 0) {
      for (i = this.length - 1; i >= 0; i--) {
        this.words[i + s] = this.words[i];
      }

      for (i = 0; i < s; i++) {
        this.words[i] = 0;
      }

      this.length += s;
    }

    return this.strip();
  };

  BN.prototype.ishln = function ishln (bits) {
    // TODO(indutny): implement me
    assert(this.negative === 0);
    return this.iushln(bits);
  };

  // Shift-right in-place
  // NOTE: `hint` is a lowest bit before trailing zeroes
  // NOTE: if `extended` is present - it will be filled with destroyed bits
  BN.prototype.iushrn = function iushrn (bits, hint, extended) {
    assert(typeof bits === 'number' && bits >= 0);
    var h;
    if (hint) {
      h = (hint - (hint % 26)) / 26;
    } else {
      h = 0;
    }

    var r = bits % 26;
    var s = Math.min((bits - r) / 26, this.length);
    var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);
    var maskedWords = extended;

    h -= s;
    h = Math.max(0, h);

    // Extended mode, copy masked part
    if (maskedWords) {
      for (var i = 0; i < s; i++) {
        maskedWords.words[i] = this.words[i];
      }
      maskedWords.length = s;
    }

    if (s === 0) {
      // No-op, we should not move anything at all
    } else if (this.length > s) {
      this.length -= s;
      for (i = 0; i < this.length; i++) {
        this.words[i] = this.words[i + s];
      }
    } else {
      this.words[0] = 0;
      this.length = 1;
    }

    var carry = 0;
    for (i = this.length - 1; i >= 0 && (carry !== 0 || i >= h); i--) {
      var word = this.words[i] | 0;
      this.words[i] = (carry << (26 - r)) | (word >>> r);
      carry = word & mask;
    }

    // Push carried bits as a mask
    if (maskedWords && carry !== 0) {
      maskedWords.words[maskedWords.length++] = carry;
    }

    if (this.length === 0) {
      this.words[0] = 0;
      this.length = 1;
    }

    return this.strip();
  };

  BN.prototype.ishrn = function ishrn (bits, hint, extended) {
    // TODO(indutny): implement me
    assert(this.negative === 0);
    return this.iushrn(bits, hint, extended);
  };

  // Shift-left
  BN.prototype.shln = function shln (bits) {
    return this.clone().ishln(bits);
  };

  BN.prototype.ushln = function ushln (bits) {
    return this.clone().iushln(bits);
  };

  // Shift-right
  BN.prototype.shrn = function shrn (bits) {
    return this.clone().ishrn(bits);
  };

  BN.prototype.ushrn = function ushrn (bits) {
    return this.clone().iushrn(bits);
  };

  // Test if n bit is set
  BN.prototype.testn = function testn (bit) {
    assert(typeof bit === 'number' && bit >= 0);
    var r = bit % 26;
    var s = (bit - r) / 26;
    var q = 1 << r;

    // Fast case: bit is much higher than all existing words
    if (this.length <= s) return false;

    // Check bit and return
    var w = this.words[s];

    return !!(w & q);
  };

  // Return only lowers bits of number (in-place)
  BN.prototype.imaskn = function imaskn (bits) {
    assert(typeof bits === 'number' && bits >= 0);
    var r = bits % 26;
    var s = (bits - r) / 26;

    assert(this.negative === 0, 'imaskn works only with positive numbers');

    if (this.length <= s) {
      return this;
    }

    if (r !== 0) {
      s++;
    }
    this.length = Math.min(s, this.length);

    if (r !== 0) {
      var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);
      this.words[this.length - 1] &= mask;
    }

    return this.strip();
  };

  // Return only lowers bits of number
  BN.prototype.maskn = function maskn (bits) {
    return this.clone().imaskn(bits);
  };

  // Add plain number `num` to `this`
  BN.prototype.iaddn = function iaddn (num) {
    assert(typeof num === 'number');
    assert(num < 0x4000000);
    if (num < 0) return this.isubn(-num);

    // Possible sign change
    if (this.negative !== 0) {
      if (this.length === 1 && (this.words[0] | 0) < num) {
        this.words[0] = num - (this.words[0] | 0);
        this.negative = 0;
        return this;
      }

      this.negative = 0;
      this.isubn(num);
      this.negative = 1;
      return this;
    }

    // Add without checks
    return this._iaddn(num);
  };

  BN.prototype._iaddn = function _iaddn (num) {
    this.words[0] += num;

    // Carry
    for (var i = 0; i < this.length && this.words[i] >= 0x4000000; i++) {
      this.words[i] -= 0x4000000;
      if (i === this.length - 1) {
        this.words[i + 1] = 1;
      } else {
        this.words[i + 1]++;
      }
    }
    this.length = Math.max(this.length, i + 1);

    return this;
  };

  // Subtract plain number `num` from `this`
  BN.prototype.isubn = function isubn (num) {
    assert(typeof num === 'number');
    assert(num < 0x4000000);
    if (num < 0) return this.iaddn(-num);

    if (this.negative !== 0) {
      this.negative = 0;
      this.iaddn(num);
      this.negative = 1;
      return this;
    }

    this.words[0] -= num;

    if (this.length === 1 && this.words[0] < 0) {
      this.words[0] = -this.words[0];
      this.negative = 1;
    } else {
      // Carry
      for (var i = 0; i < this.length && this.words[i] < 0; i++) {
        this.words[i] += 0x4000000;
        this.words[i + 1] -= 1;
      }
    }

    return this.strip();
  };

  BN.prototype.addn = function addn (num) {
    return this.clone().iaddn(num);
  };

  BN.prototype.subn = function subn (num) {
    return this.clone().isubn(num);
  };

  BN.prototype.iabs = function iabs () {
    this.negative = 0;

    return this;
  };

  BN.prototype.abs = function abs () {
    return this.clone().iabs();
  };

  BN.prototype._ishlnsubmul = function _ishlnsubmul (num, mul, shift) {
    var len = num.length + shift;
    var i;

    this._expand(len);

    var w;
    var carry = 0;
    for (i = 0; i < num.length; i++) {
      w = (this.words[i + shift] | 0) + carry;
      var right = (num.words[i] | 0) * mul;
      w -= right & 0x3ffffff;
      carry = (w >> 26) - ((right / 0x4000000) | 0);
      this.words[i + shift] = w & 0x3ffffff;
    }
    for (; i < this.length - shift; i++) {
      w = (this.words[i + shift] | 0) + carry;
      carry = w >> 26;
      this.words[i + shift] = w & 0x3ffffff;
    }

    if (carry === 0) return this.strip();

    // Subtraction overflow
    assert(carry === -1);
    carry = 0;
    for (i = 0; i < this.length; i++) {
      w = -(this.words[i] | 0) + carry;
      carry = w >> 26;
      this.words[i] = w & 0x3ffffff;
    }
    this.negative = 1;

    return this.strip();
  };

  BN.prototype._wordDiv = function _wordDiv (num, mode) {
    var shift = this.length - num.length;

    var a = this.clone();
    var b = num;

    // Normalize
    var bhi = b.words[b.length - 1] | 0;
    var bhiBits = this._countBits(bhi);
    shift = 26 - bhiBits;
    if (shift !== 0) {
      b = b.ushln(shift);
      a.iushln(shift);
      bhi = b.words[b.length - 1] | 0;
    }

    // Initialize quotient
    var m = a.length - b.length;
    var q;

    if (mode !== 'mod') {
      q = new BN(null);
      q.length = m + 1;
      q.words = new Array(q.length);
      for (var i = 0; i < q.length; i++) {
        q.words[i] = 0;
      }
    }

    var diff = a.clone()._ishlnsubmul(b, 1, m);
    if (diff.negative === 0) {
      a = diff;
      if (q) {
        q.words[m] = 1;
      }
    }

    for (var j = m - 1; j >= 0; j--) {
      var qj = (a.words[b.length + j] | 0) * 0x4000000 +
        (a.words[b.length + j - 1] | 0);

      // NOTE: (qj / bhi) is (0x3ffffff * 0x4000000 + 0x3ffffff) / 0x2000000 max
      // (0x7ffffff)
      qj = Math.min((qj / bhi) | 0, 0x3ffffff);

      a._ishlnsubmul(b, qj, j);
      while (a.negative !== 0) {
        qj--;
        a.negative = 0;
        a._ishlnsubmul(b, 1, j);
        if (!a.isZero()) {
          a.negative ^= 1;
        }
      }
      if (q) {
        q.words[j] = qj;
      }
    }
    if (q) {
      q.strip();
    }
    a.strip();

    // Denormalize
    if (mode !== 'div' && shift !== 0) {
      a.iushrn(shift);
    }

    return {
      div: q || null,
      mod: a
    };
  };

  // NOTE: 1) `mode` can be set to `mod` to request mod only,
  //       to `div` to request div only, or be absent to
  //       request both div & mod
  //       2) `positive` is true if unsigned mod is requested
  BN.prototype.divmod = function divmod (num, mode, positive) {
    assert(!num.isZero());

    if (this.isZero()) {
      return {
        div: new BN(0),
        mod: new BN(0)
      };
    }

    var div, mod, res;
    if (this.negative !== 0 && num.negative === 0) {
      res = this.neg().divmod(num, mode);

      if (mode !== 'mod') {
        div = res.div.neg();
      }

      if (mode !== 'div') {
        mod = res.mod.neg();
        if (positive && mod.negative !== 0) {
          mod.iadd(num);
        }
      }

      return {
        div: div,
        mod: mod
      };
    }

    if (this.negative === 0 && num.negative !== 0) {
      res = this.divmod(num.neg(), mode);

      if (mode !== 'mod') {
        div = res.div.neg();
      }

      return {
        div: div,
        mod: res.mod
      };
    }

    if ((this.negative & num.negative) !== 0) {
      res = this.neg().divmod(num.neg(), mode);

      if (mode !== 'div') {
        mod = res.mod.neg();
        if (positive && mod.negative !== 0) {
          mod.isub(num);
        }
      }

      return {
        div: res.div,
        mod: mod
      };
    }

    // Both numbers are positive at this point

    // Strip both numbers to approximate shift value
    if (num.length > this.length || this.cmp(num) < 0) {
      return {
        div: new BN(0),
        mod: this
      };
    }

    // Very short reduction
    if (num.length === 1) {
      if (mode === 'div') {
        return {
          div: this.divn(num.words[0]),
          mod: null
        };
      }

      if (mode === 'mod') {
        return {
          div: null,
          mod: new BN(this.modn(num.words[0]))
        };
      }

      return {
        div: this.divn(num.words[0]),
        mod: new BN(this.modn(num.words[0]))
      };
    }

    return this._wordDiv(num, mode);
  };

  // Find `this` / `num`
  BN.prototype.div = function div (num) {
    return this.divmod(num, 'div', false).div;
  };

  // Find `this` % `num`
  BN.prototype.mod = function mod (num) {
    return this.divmod(num, 'mod', false).mod;
  };

  BN.prototype.umod = function umod (num) {
    return this.divmod(num, 'mod', true).mod;
  };

  // Find Round(`this` / `num`)
  BN.prototype.divRound = function divRound (num) {
    var dm = this.divmod(num);

    // Fast case - exact division
    if (dm.mod.isZero()) return dm.div;

    var mod = dm.div.negative !== 0 ? dm.mod.isub(num) : dm.mod;

    var half = num.ushrn(1);
    var r2 = num.andln(1);
    var cmp = mod.cmp(half);

    // Round down
    if (cmp < 0 || r2 === 1 && cmp === 0) return dm.div;

    // Round up
    return dm.div.negative !== 0 ? dm.div.isubn(1) : dm.div.iaddn(1);
  };

  BN.prototype.modn = function modn (num) {
    assert(num <= 0x3ffffff);
    var p = (1 << 26) % num;

    var acc = 0;
    for (var i = this.length - 1; i >= 0; i--) {
      acc = (p * acc + (this.words[i] | 0)) % num;
    }

    return acc;
  };

  // In-place division by number
  BN.prototype.idivn = function idivn (num) {
    assert(num <= 0x3ffffff);

    var carry = 0;
    for (var i = this.length - 1; i >= 0; i--) {
      var w = (this.words[i] | 0) + carry * 0x4000000;
      this.words[i] = (w / num) | 0;
      carry = w % num;
    }

    return this.strip();
  };

  BN.prototype.divn = function divn (num) {
    return this.clone().idivn(num);
  };

  BN.prototype.egcd = function egcd (p) {
    assert(p.negative === 0);
    assert(!p.isZero());

    var x = this;
    var y = p.clone();

    if (x.negative !== 0) {
      x = x.umod(p);
    } else {
      x = x.clone();
    }

    // A * x + B * y = x
    var A = new BN(1);
    var B = new BN(0);

    // C * x + D * y = y
    var C = new BN(0);
    var D = new BN(1);

    var g = 0;

    while (x.isEven() && y.isEven()) {
      x.iushrn(1);
      y.iushrn(1);
      ++g;
    }

    var yp = y.clone();
    var xp = x.clone();

    while (!x.isZero()) {
      for (var i = 0, im = 1; (x.words[0] & im) === 0 && i < 26; ++i, im <<= 1);
      if (i > 0) {
        x.iushrn(i);
        while (i-- > 0) {
          if (A.isOdd() || B.isOdd()) {
            A.iadd(yp);
            B.isub(xp);
          }

          A.iushrn(1);
          B.iushrn(1);
        }
      }

      for (var j = 0, jm = 1; (y.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);
      if (j > 0) {
        y.iushrn(j);
        while (j-- > 0) {
          if (C.isOdd() || D.isOdd()) {
            C.iadd(yp);
            D.isub(xp);
          }

          C.iushrn(1);
          D.iushrn(1);
        }
      }

      if (x.cmp(y) >= 0) {
        x.isub(y);
        A.isub(C);
        B.isub(D);
      } else {
        y.isub(x);
        C.isub(A);
        D.isub(B);
      }
    }

    return {
      a: C,
      b: D,
      gcd: y.iushln(g)
    };
  };

  // This is reduced incarnation of the binary EEA
  // above, designated to invert members of the
  // _prime_ fields F(p) at a maximal speed
  BN.prototype._invmp = function _invmp (p) {
    assert(p.negative === 0);
    assert(!p.isZero());

    var a = this;
    var b = p.clone();

    if (a.negative !== 0) {
      a = a.umod(p);
    } else {
      a = a.clone();
    }

    var x1 = new BN(1);
    var x2 = new BN(0);

    var delta = b.clone();

    while (a.cmpn(1) > 0 && b.cmpn(1) > 0) {
      for (var i = 0, im = 1; (a.words[0] & im) === 0 && i < 26; ++i, im <<= 1);
      if (i > 0) {
        a.iushrn(i);
        while (i-- > 0) {
          if (x1.isOdd()) {
            x1.iadd(delta);
          }

          x1.iushrn(1);
        }
      }

      for (var j = 0, jm = 1; (b.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);
      if (j > 0) {
        b.iushrn(j);
        while (j-- > 0) {
          if (x2.isOdd()) {
            x2.iadd(delta);
          }

          x2.iushrn(1);
        }
      }

      if (a.cmp(b) >= 0) {
        a.isub(b);
        x1.isub(x2);
      } else {
        b.isub(a);
        x2.isub(x1);
      }
    }

    var res;
    if (a.cmpn(1) === 0) {
      res = x1;
    } else {
      res = x2;
    }

    if (res.cmpn(0) < 0) {
      res.iadd(p);
    }

    return res;
  };

  BN.prototype.gcd = function gcd (num) {
    if (this.isZero()) return num.abs();
    if (num.isZero()) return this.abs();

    var a = this.clone();
    var b = num.clone();
    a.negative = 0;
    b.negative = 0;

    // Remove common factor of two
    for (var shift = 0; a.isEven() && b.isEven(); shift++) {
      a.iushrn(1);
      b.iushrn(1);
    }

    do {
      while (a.isEven()) {
        a.iushrn(1);
      }
      while (b.isEven()) {
        b.iushrn(1);
      }

      var r = a.cmp(b);
      if (r < 0) {
        // Swap `a` and `b` to make `a` always bigger than `b`
        var t = a;
        a = b;
        b = t;
      } else if (r === 0 || b.cmpn(1) === 0) {
        break;
      }

      a.isub(b);
    } while (true);

    return b.iushln(shift);
  };

  // Invert number in the field F(num)
  BN.prototype.invm = function invm (num) {
    return this.egcd(num).a.umod(num);
  };

  BN.prototype.isEven = function isEven () {
    return (this.words[0] & 1) === 0;
  };

  BN.prototype.isOdd = function isOdd () {
    return (this.words[0] & 1) === 1;
  };

  // And first word and num
  BN.prototype.andln = function andln (num) {
    return this.words[0] & num;
  };

  // Increment at the bit position in-line
  BN.prototype.bincn = function bincn (bit) {
    assert(typeof bit === 'number');
    var r = bit % 26;
    var s = (bit - r) / 26;
    var q = 1 << r;

    // Fast case: bit is much higher than all existing words
    if (this.length <= s) {
      this._expand(s + 1);
      this.words[s] |= q;
      return this;
    }

    // Add bit and propagate, if needed
    var carry = q;
    for (var i = s; carry !== 0 && i < this.length; i++) {
      var w = this.words[i] | 0;
      w += carry;
      carry = w >>> 26;
      w &= 0x3ffffff;
      this.words[i] = w;
    }
    if (carry !== 0) {
      this.words[i] = carry;
      this.length++;
    }
    return this;
  };

  BN.prototype.isZero = function isZero () {
    return this.length === 1 && this.words[0] === 0;
  };

  BN.prototype.cmpn = function cmpn (num) {
    var negative = num < 0;

    if (this.negative !== 0 && !negative) return -1;
    if (this.negative === 0 && negative) return 1;

    this.strip();

    var res;
    if (this.length > 1) {
      res = 1;
    } else {
      if (negative) {
        num = -num;
      }

      assert(num <= 0x3ffffff, 'Number is too big');

      var w = this.words[0] | 0;
      res = w === num ? 0 : w < num ? -1 : 1;
    }
    if (this.negative !== 0) return -res | 0;
    return res;
  };

  // Compare two numbers and return:
  // 1 - if `this` > `num`
  // 0 - if `this` == `num`
  // -1 - if `this` < `num`
  BN.prototype.cmp = function cmp (num) {
    if (this.negative !== 0 && num.negative === 0) return -1;
    if (this.negative === 0 && num.negative !== 0) return 1;

    var res = this.ucmp(num);
    if (this.negative !== 0) return -res | 0;
    return res;
  };

  // Unsigned comparison
  BN.prototype.ucmp = function ucmp (num) {
    // At this point both numbers have the same sign
    if (this.length > num.length) return 1;
    if (this.length < num.length) return -1;

    var res = 0;
    for (var i = this.length - 1; i >= 0; i--) {
      var a = this.words[i] | 0;
      var b = num.words[i] | 0;

      if (a === b) continue;
      if (a < b) {
        res = -1;
      } else if (a > b) {
        res = 1;
      }
      break;
    }
    return res;
  };

  BN.prototype.gtn = function gtn (num) {
    return this.cmpn(num) === 1;
  };

  BN.prototype.gt = function gt (num) {
    return this.cmp(num) === 1;
  };

  BN.prototype.gten = function gten (num) {
    return this.cmpn(num) >= 0;
  };

  BN.prototype.gte = function gte (num) {
    return this.cmp(num) >= 0;
  };

  BN.prototype.ltn = function ltn (num) {
    return this.cmpn(num) === -1;
  };

  BN.prototype.lt = function lt (num) {
    return this.cmp(num) === -1;
  };

  BN.prototype.lten = function lten (num) {
    return this.cmpn(num) <= 0;
  };

  BN.prototype.lte = function lte (num) {
    return this.cmp(num) <= 0;
  };

  BN.prototype.eqn = function eqn (num) {
    return this.cmpn(num) === 0;
  };

  BN.prototype.eq = function eq (num) {
    return this.cmp(num) === 0;
  };

  //
  // A reduce context, could be using montgomery or something better, depending
  // on the `m` itself.
  //
  BN.red = function red (num) {
    return new Red(num);
  };

  BN.prototype.toRed = function toRed (ctx) {
    assert(!this.red, 'Already a number in reduction context');
    assert(this.negative === 0, 'red works only with positives');
    return ctx.convertTo(this)._forceRed(ctx);
  };

  BN.prototype.fromRed = function fromRed () {
    assert(this.red, 'fromRed works only with numbers in reduction context');
    return this.red.convertFrom(this);
  };

  BN.prototype._forceRed = function _forceRed (ctx) {
    this.red = ctx;
    return this;
  };

  BN.prototype.forceRed = function forceRed (ctx) {
    assert(!this.red, 'Already a number in reduction context');
    return this._forceRed(ctx);
  };

  BN.prototype.redAdd = function redAdd (num) {
    assert(this.red, 'redAdd works only with red numbers');
    return this.red.add(this, num);
  };

  BN.prototype.redIAdd = function redIAdd (num) {
    assert(this.red, 'redIAdd works only with red numbers');
    return this.red.iadd(this, num);
  };

  BN.prototype.redSub = function redSub (num) {
    assert(this.red, 'redSub works only with red numbers');
    return this.red.sub(this, num);
  };

  BN.prototype.redISub = function redISub (num) {
    assert(this.red, 'redISub works only with red numbers');
    return this.red.isub(this, num);
  };

  BN.prototype.redShl = function redShl (num) {
    assert(this.red, 'redShl works only with red numbers');
    return this.red.shl(this, num);
  };

  BN.prototype.redMul = function redMul (num) {
    assert(this.red, 'redMul works only with red numbers');
    this.red._verify2(this, num);
    return this.red.mul(this, num);
  };

  BN.prototype.redIMul = function redIMul (num) {
    assert(this.red, 'redMul works only with red numbers');
    this.red._verify2(this, num);
    return this.red.imul(this, num);
  };

  BN.prototype.redSqr = function redSqr () {
    assert(this.red, 'redSqr works only with red numbers');
    this.red._verify1(this);
    return this.red.sqr(this);
  };

  BN.prototype.redISqr = function redISqr () {
    assert(this.red, 'redISqr works only with red numbers');
    this.red._verify1(this);
    return this.red.isqr(this);
  };

  // Square root over p
  BN.prototype.redSqrt = function redSqrt () {
    assert(this.red, 'redSqrt works only with red numbers');
    this.red._verify1(this);
    return this.red.sqrt(this);
  };

  BN.prototype.redInvm = function redInvm () {
    assert(this.red, 'redInvm works only with red numbers');
    this.red._verify1(this);
    return this.red.invm(this);
  };

  // Return negative clone of `this` % `red modulo`
  BN.prototype.redNeg = function redNeg () {
    assert(this.red, 'redNeg works only with red numbers');
    this.red._verify1(this);
    return this.red.neg(this);
  };

  BN.prototype.redPow = function redPow (num) {
    assert(this.red && !num.red, 'redPow(normalNum)');
    this.red._verify1(this);
    return this.red.pow(this, num);
  };

  // Prime numbers with efficient reduction
  var primes = {
    k256: null,
    p224: null,
    p192: null,
    p25519: null
  };

  // Pseudo-Mersenne prime
  function MPrime (name, p) {
    // P = 2 ^ N - K
    this.name = name;
    this.p = new BN(p, 16);
    this.n = this.p.bitLength();
    this.k = new BN(1).iushln(this.n).isub(this.p);

    this.tmp = this._tmp();
  }

  MPrime.prototype._tmp = function _tmp () {
    var tmp = new BN(null);
    tmp.words = new Array(Math.ceil(this.n / 13));
    return tmp;
  };

  MPrime.prototype.ireduce = function ireduce (num) {
    // Assumes that `num` is less than `P^2`
    // num = HI * (2 ^ N - K) + HI * K + LO = HI * K + LO (mod P)
    var r = num;
    var rlen;

    do {
      this.split(r, this.tmp);
      r = this.imulK(r);
      r = r.iadd(this.tmp);
      rlen = r.bitLength();
    } while (rlen > this.n);

    var cmp = rlen < this.n ? -1 : r.ucmp(this.p);
    if (cmp === 0) {
      r.words[0] = 0;
      r.length = 1;
    } else if (cmp > 0) {
      r.isub(this.p);
    } else {
      r.strip();
    }

    return r;
  };

  MPrime.prototype.split = function split (input, out) {
    input.iushrn(this.n, 0, out);
  };

  MPrime.prototype.imulK = function imulK (num) {
    return num.imul(this.k);
  };

  function K256 () {
    MPrime.call(
      this,
      'k256',
      'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f');
  }
  inherits(K256, MPrime);

  K256.prototype.split = function split (input, output) {
    // 256 = 9 * 26 + 22
    var mask = 0x3fffff;

    var outLen = Math.min(input.length, 9);
    for (var i = 0; i < outLen; i++) {
      output.words[i] = input.words[i];
    }
    output.length = outLen;

    if (input.length <= 9) {
      input.words[0] = 0;
      input.length = 1;
      return;
    }

    // Shift by 9 limbs
    var prev = input.words[9];
    output.words[output.length++] = prev & mask;

    for (i = 10; i < input.length; i++) {
      var next = input.words[i] | 0;
      input.words[i - 10] = ((next & mask) << 4) | (prev >>> 22);
      prev = next;
    }
    prev >>>= 22;
    input.words[i - 10] = prev;
    if (prev === 0 && input.length > 10) {
      input.length -= 10;
    } else {
      input.length -= 9;
    }
  };

  K256.prototype.imulK = function imulK (num) {
    // K = 0x1000003d1 = [ 0x40, 0x3d1 ]
    num.words[num.length] = 0;
    num.words[num.length + 1] = 0;
    num.length += 2;

    // bounded at: 0x40 * 0x3ffffff + 0x3d0 = 0x100000390
    var lo = 0;
    for (var i = 0; i < num.length; i++) {
      var w = num.words[i] | 0;
      lo += w * 0x3d1;
      num.words[i] = lo & 0x3ffffff;
      lo = w * 0x40 + ((lo / 0x4000000) | 0);
    }

    // Fast length reduction
    if (num.words[num.length - 1] === 0) {
      num.length--;
      if (num.words[num.length - 1] === 0) {
        num.length--;
      }
    }
    return num;
  };

  function P224 () {
    MPrime.call(
      this,
      'p224',
      'ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001');
  }
  inherits(P224, MPrime);

  function P192 () {
    MPrime.call(
      this,
      'p192',
      'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff');
  }
  inherits(P192, MPrime);

  function P25519 () {
    // 2 ^ 255 - 19
    MPrime.call(
      this,
      '25519',
      '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed');
  }
  inherits(P25519, MPrime);

  P25519.prototype.imulK = function imulK (num) {
    // K = 0x13
    var carry = 0;
    for (var i = 0; i < num.length; i++) {
      var hi = (num.words[i] | 0) * 0x13 + carry;
      var lo = hi & 0x3ffffff;
      hi >>>= 26;

      num.words[i] = lo;
      carry = hi;
    }
    if (carry !== 0) {
      num.words[num.length++] = carry;
    }
    return num;
  };

  // Exported mostly for testing purposes, use plain name instead
  BN._prime = function prime (name) {
    // Cached version of prime
    if (primes[name]) return primes[name];

    var prime;
    if (name === 'k256') {
      prime = new K256();
    } else if (name === 'p224') {
      prime = new P224();
    } else if (name === 'p192') {
      prime = new P192();
    } else if (name === 'p25519') {
      prime = new P25519();
    } else {
      throw new Error('Unknown prime ' + name);
    }
    primes[name] = prime;

    return prime;
  };

  //
  // Base reduction engine
  //
  function Red (m) {
    if (typeof m === 'string') {
      var prime = BN._prime(m);
      this.m = prime.p;
      this.prime = prime;
    } else {
      assert(m.gtn(1), 'modulus must be greater than 1');
      this.m = m;
      this.prime = null;
    }
  }

  Red.prototype._verify1 = function _verify1 (a) {
    assert(a.negative === 0, 'red works only with positives');
    assert(a.red, 'red works only with red numbers');
  };

  Red.prototype._verify2 = function _verify2 (a, b) {
    assert((a.negative | b.negative) === 0, 'red works only with positives');
    assert(a.red && a.red === b.red,
      'red works only with red numbers');
  };

  Red.prototype.imod = function imod (a) {
    if (this.prime) return this.prime.ireduce(a)._forceRed(this);
    return a.umod(this.m)._forceRed(this);
  };

  Red.prototype.neg = function neg (a) {
    if (a.isZero()) {
      return a.clone();
    }

    return this.m.sub(a)._forceRed(this);
  };

  Red.prototype.add = function add (a, b) {
    this._verify2(a, b);

    var res = a.add(b);
    if (res.cmp(this.m) >= 0) {
      res.isub(this.m);
    }
    return res._forceRed(this);
  };

  Red.prototype.iadd = function iadd (a, b) {
    this._verify2(a, b);

    var res = a.iadd(b);
    if (res.cmp(this.m) >= 0) {
      res.isub(this.m);
    }
    return res;
  };

  Red.prototype.sub = function sub (a, b) {
    this._verify2(a, b);

    var res = a.sub(b);
    if (res.cmpn(0) < 0) {
      res.iadd(this.m);
    }
    return res._forceRed(this);
  };

  Red.prototype.isub = function isub (a, b) {
    this._verify2(a, b);

    var res = a.isub(b);
    if (res.cmpn(0) < 0) {
      res.iadd(this.m);
    }
    return res;
  };

  Red.prototype.shl = function shl (a, num) {
    this._verify1(a);
    return this.imod(a.ushln(num));
  };

  Red.prototype.imul = function imul (a, b) {
    this._verify2(a, b);
    return this.imod(a.imul(b));
  };

  Red.prototype.mul = function mul (a, b) {
    this._verify2(a, b);
    return this.imod(a.mul(b));
  };

  Red.prototype.isqr = function isqr (a) {
    return this.imul(a, a.clone());
  };

  Red.prototype.sqr = function sqr (a) {
    return this.mul(a, a);
  };

  Red.prototype.sqrt = function sqrt (a) {
    if (a.isZero()) return a.clone();

    var mod3 = this.m.andln(3);
    assert(mod3 % 2 === 1);

    // Fast case
    if (mod3 === 3) {
      var pow = this.m.add(new BN(1)).iushrn(2);
      return this.pow(a, pow);
    }

    // Tonelli-Shanks algorithm (Totally unoptimized and slow)
    //
    // Find Q and S, that Q * 2 ^ S = (P - 1)
    var q = this.m.subn(1);
    var s = 0;
    while (!q.isZero() && q.andln(1) === 0) {
      s++;
      q.iushrn(1);
    }
    assert(!q.isZero());

    var one = new BN(1).toRed(this);
    var nOne = one.redNeg();

    // Find quadratic non-residue
    // NOTE: Max is such because of generalized Riemann hypothesis.
    var lpow = this.m.subn(1).iushrn(1);
    var z = this.m.bitLength();
    z = new BN(2 * z * z).toRed(this);

    while (this.pow(z, lpow).cmp(nOne) !== 0) {
      z.redIAdd(nOne);
    }

    var c = this.pow(z, q);
    var r = this.pow(a, q.addn(1).iushrn(1));
    var t = this.pow(a, q);
    var m = s;
    while (t.cmp(one) !== 0) {
      var tmp = t;
      for (var i = 0; tmp.cmp(one) !== 0; i++) {
        tmp = tmp.redSqr();
      }
      assert(i < m);
      var b = this.pow(c, new BN(1).iushln(m - i - 1));

      r = r.redMul(b);
      c = b.redSqr();
      t = t.redMul(c);
      m = i;
    }

    return r;
  };

  Red.prototype.invm = function invm (a) {
    var inv = a._invmp(this.m);
    if (inv.negative !== 0) {
      inv.negative = 0;
      return this.imod(inv).redNeg();
    } else {
      return this.imod(inv);
    }
  };

  Red.prototype.pow = function pow (a, num) {
    if (num.isZero()) return new BN(1).toRed(this);
    if (num.cmpn(1) === 0) return a.clone();

    var windowSize = 4;
    var wnd = new Array(1 << windowSize);
    wnd[0] = new BN(1).toRed(this);
    wnd[1] = a;
    for (var i = 2; i < wnd.length; i++) {
      wnd[i] = this.mul(wnd[i - 1], a);
    }

    var res = wnd[0];
    var current = 0;
    var currentLen = 0;
    var start = num.bitLength() % 26;
    if (start === 0) {
      start = 26;
    }

    for (i = num.length - 1; i >= 0; i--) {
      var word = num.words[i];
      for (var j = start - 1; j >= 0; j--) {
        var bit = (word >> j) & 1;
        if (res !== wnd[0]) {
          res = this.sqr(res);
        }

        if (bit === 0 && current === 0) {
          currentLen = 0;
          continue;
        }

        current <<= 1;
        current |= bit;
        currentLen++;
        if (currentLen !== windowSize && (i !== 0 || j !== 0)) continue;

        res = this.mul(res, wnd[current]);
        currentLen = 0;
        current = 0;
      }
      start = 26;
    }

    return res;
  };

  Red.prototype.convertTo = function convertTo (num) {
    var r = num.umod(this.m);

    return r === num ? r.clone() : r;
  };

  Red.prototype.convertFrom = function convertFrom (num) {
    var res = num.clone();
    res.red = null;
    return res;
  };

  //
  // Montgomery method engine
  //

  BN.mont = function mont (num) {
    return new Mont(num);
  };

  function Mont (m) {
    Red.call(this, m);

    this.shift = this.m.bitLength();
    if (this.shift % 26 !== 0) {
      this.shift += 26 - (this.shift % 26);
    }

    this.r = new BN(1).iushln(this.shift);
    this.r2 = this.imod(this.r.sqr());
    this.rinv = this.r._invmp(this.m);

    this.minv = this.rinv.mul(this.r).isubn(1).div(this.m);
    this.minv = this.minv.umod(this.r);
    this.minv = this.r.sub(this.minv);
  }
  inherits(Mont, Red);

  Mont.prototype.convertTo = function convertTo (num) {
    return this.imod(num.ushln(this.shift));
  };

  Mont.prototype.convertFrom = function convertFrom (num) {
    var r = this.imod(num.mul(this.rinv));
    r.red = null;
    return r;
  };

  Mont.prototype.imul = function imul (a, b) {
    if (a.isZero() || b.isZero()) {
      a.words[0] = 0;
      a.length = 1;
      return a;
    }

    var t = a.imul(b);
    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
    var u = t.isub(c).iushrn(this.shift);
    var res = u;

    if (u.cmp(this.m) >= 0) {
      res = u.isub(this.m);
    } else if (u.cmpn(0) < 0) {
      res = u.iadd(this.m);
    }

    return res._forceRed(this);
  };

  Mont.prototype.mul = function mul (a, b) {
    if (a.isZero() || b.isZero()) return new BN(0)._forceRed(this);

    var t = a.mul(b);
    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
    var u = t.isub(c).iushrn(this.shift);
    var res = u;
    if (u.cmp(this.m) >= 0) {
      res = u.isub(this.m);
    } else if (u.cmpn(0) < 0) {
      res = u.iadd(this.m);
    }

    return res._forceRed(this);
  };

  Mont.prototype.invm = function invm (a) {
    // (AR)^-1 * R^2 = (A^-1 * R^-1) * R^2 = A^-1 * R
    var res = this.imod(a._invmp(this.m).mul(this.r2));
    return res._forceRed(this);
  };
})(typeof module === 'undefined' || module, this);

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(185)(module)))

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.13 ToObject(argument)
var defined = __webpack_require__(32);
module.exports = function (it) {
  return Object(defined(it));
};


/***/ }),
/* 14 */
/***/ (function(module, exports) {

module.exports = function (it) {
  if (typeof it != 'function') throw TypeError(it + ' is not a function!');
  return it;
};


/***/ }),
/* 15 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var elliptic = exports;

elliptic.version = __webpack_require__(461).version;
elliptic.utils = __webpack_require__(462);
elliptic.rand = __webpack_require__(187);
elliptic.curve = __webpack_require__(88);
elliptic.curves = __webpack_require__(467);

// Protocols
elliptic.ec = __webpack_require__(475);
elliptic.eddsa = __webpack_require__(479);


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(10);
var createDesc = __webpack_require__(43);
module.exports = __webpack_require__(9) ? function (object, key, value) {
  return dP.f(object, key, createDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(3);
var hide = __webpack_require__(17);
var has = __webpack_require__(20);
var SRC = __webpack_require__(44)('src');
var TO_STRING = 'toString';
var $toString = Function[TO_STRING];
var TPL = ('' + $toString).split(TO_STRING);

__webpack_require__(26).inspectSource = function (it) {
  return $toString.call(it);
};

(module.exports = function (O, key, val, safe) {
  var isFunction = typeof val == 'function';
  if (isFunction) has(val, 'name') || hide(val, 'name', key);
  if (O[key] === val) return;
  if (isFunction) has(val, SRC) || hide(val, SRC, O[key] ? '' + O[key] : TPL.join(String(key)));
  if (O === global) {
    O[key] = val;
  } else if (!safe) {
    delete O[key];
    hide(O, key, val);
  } else if (O[key]) {
    O[key] = val;
  } else {
    hide(O, key, val);
  }
// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
})(Function.prototype, TO_STRING, function toString() {
  return typeof this == 'function' && this[SRC] || $toString.call(this);
});


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

var $export = __webpack_require__(0);
var fails = __webpack_require__(4);
var defined = __webpack_require__(32);
var quot = /"/g;
// B.2.3.2.1 CreateHTML(string, tag, attribute, value)
var createHTML = function (string, tag, attribute, value) {
  var S = String(defined(string));
  var p1 = '<' + tag;
  if (attribute !== '') p1 += ' ' + attribute + '="' + String(value).replace(quot, '&quot;') + '"';
  return p1 + '>' + S + '</' + tag + '>';
};
module.exports = function (NAME, exec) {
  var O = {};
  O[NAME] = exec(createHTML);
  $export($export.P + $export.F * fails(function () {
    var test = ''[NAME]('"');
    return test !== test.toLowerCase() || test.split('"').length > 3;
  }), 'String', O);
};


/***/ }),
/* 20 */
/***/ (function(module, exports) {

var hasOwnProperty = {}.hasOwnProperty;
module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

// to indexed object, toObject with fallback for non-array-like ES3 strings
var IObject = __webpack_require__(60);
var defined = __webpack_require__(32);
module.exports = function (it) {
  return IObject(defined(it));
};


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

var pIE = __webpack_require__(61);
var createDesc = __webpack_require__(43);
var toIObject = __webpack_require__(21);
var toPrimitive = __webpack_require__(31);
var has = __webpack_require__(20);
var IE8_DOM_DEFINE = __webpack_require__(128);
var gOPD = Object.getOwnPropertyDescriptor;

exports.f = __webpack_require__(9) ? gOPD : function getOwnPropertyDescriptor(O, P) {
  O = toIObject(O);
  P = toPrimitive(P, true);
  if (IE8_DOM_DEFINE) try {
    return gOPD(O, P);
  } catch (e) { /* empty */ }
  if (has(O, P)) return createDesc(!pIE.f.call(O, P), O[P]);
};


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)
var has = __webpack_require__(20);
var toObject = __webpack_require__(13);
var IE_PROTO = __webpack_require__(92)('IE_PROTO');
var ObjectProto = Object.prototype;

module.exports = Object.getPrototypeOf || function (O) {
  O = toObject(O);
  if (has(O, IE_PROTO)) return O[IE_PROTO];
  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
    return O.constructor.prototype;
  } return O instanceof Object ? ObjectProto : null;
};


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */


var logDisabled_ = true;

// Utility methods.
var utils = {
  disableLog: function(bool) {
    if (typeof bool !== 'boolean') {
      return new Error('Argument type: ' + typeof bool +
          '. Please use a boolean.');
    }
    logDisabled_ = bool;
    return (bool) ? 'adapter.js logging disabled' :
        'adapter.js logging enabled';
  },

  log: function() {
    if (typeof window === 'object') {
      if (logDisabled_) {
        return;
      }
      if (typeof console !== 'undefined' && typeof console.log === 'function') {
        console.log.apply(console, arguments);
      }
    }
  },

  /**
   * Extract browser version out of the provided user agent string.
   *
   * @param {!string} uastring userAgent string.
   * @param {!string} expr Regular expression used as match criteria.
   * @param {!number} pos position in the version string to be returned.
   * @return {!number} browser version.
   */
  extractVersion: function(uastring, expr, pos) {
    var match = uastring.match(expr);
    return match && match.length >= pos && parseInt(match[pos], 10);
  },

  /**
   * Browser detector.
   *
   * @return {object} result containing browser, version and minVersion
   *     properties.
   */
  detectBrowser: function() {
    // Returned result object.
    var result = {};
    result.browser = null;
    result.version = null;
    result.minVersion = null;

    // Fail early if it's not a browser
    if (typeof window === 'undefined' || !window.navigator) {
      result.browser = 'Not a browser.';
      return result;
    }

    // Firefox.
    if (navigator.mozGetUserMedia) {
      result.browser = 'firefox';
      result.version = this.extractVersion(navigator.userAgent,
          /Firefox\/([0-9]+)\./, 1);
      result.minVersion = 31;

    // all webkit-based browsers
    } else if (navigator.webkitGetUserMedia) {
      // Chrome, Chromium, Webview, Opera, all use the chrome shim for now
      if (window.webkitRTCPeerConnection) {
        result.browser = 'chrome';
        result.version = this.extractVersion(navigator.userAgent,
          /Chrom(e|ium)\/([0-9]+)\./, 2);
        result.minVersion = 38;

      // Safari or unknown webkit-based
      // for the time being Safari has support for MediaStreams but not webRTC
      } else {
        // Safari UA substrings of interest for reference:
        // - webkit version:           AppleWebKit/602.1.25 (also used in Op,Cr)
        // - safari UI version:        Version/9.0.3 (unique to Safari)
        // - safari UI webkit version: Safari/601.4.4 (also used in Op,Cr)
        //
        // if the webkit version and safari UI webkit versions are equals,
        // ... this is a stable version.
        //
        // only the internal webkit version is important today to know if
        // media streams are supported
        //
        if (navigator.userAgent.match(/Version\/(\d+).(\d+)/)) {
          result.browser = 'safari';
          result.version = this.extractVersion(navigator.userAgent,
            /AppleWebKit\/([0-9]+)\./, 1);
          result.minVersion = 602;

        // unknown webkit-based browser
        } else {
          result.browser = 'Unsupported webkit-based browser ' +
              'with GUM support but no WebRTC support.';
          return result;
        }
      }

    // Edge.
    } else if (navigator.mediaDevices &&
        navigator.userAgent.match(/Edge\/(\d+).(\d+)$/)) {
      result.browser = 'edge';
      result.version = this.extractVersion(navigator.userAgent,
          /Edge\/(\d+).(\d+)$/, 2);
      result.minVersion = 10547;

    // Default fallthrough: not supported.
    } else {
      result.browser = 'Not a supported browser.';
      return result;
    }

    // Warn if version is less than minVersion.
    if (result.version < result.minVersion) {
      utils.log('Browser: ' + result.browser + ' Version: ' + result.version +
          ' < minimum supported version: ' + result.minVersion +
          '\n some things might not work!');
    }

    return result;
  }
};

// Export.
module.exports = {
  log: utils.log,
  disableLog: utils.disableLog,
  browserDetails: utils.detectBrowser(),
  extractVersion: utils.extractVersion
};


/***/ }),
/* 25 */
/***/ (function(module, exports) {

module.exports = assert;

function assert(val, msg) {
  if (!val)
    throw new Error(msg || 'Assertion failed');
}

assert.equal = function assertEqual(l, r, msg) {
  if (l != r)
    throw new Error(msg || ('Assertion failed: ' + l + ' != ' + r));
};


/***/ }),
/* 26 */
/***/ (function(module, exports) {

var core = module.exports = { version: '2.5.7' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

// optional / simple context binding
var aFunction = __webpack_require__(14);
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),
/* 28 */
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var fails = __webpack_require__(4);

module.exports = function (method, arg) {
  return !!method && fails(function () {
    // eslint-disable-next-line no-useless-call
    arg ? method.call(null, function () { /* empty */ }, 1) : method.call(null);
  });
};


/***/ }),
/* 30 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.1 ToPrimitive(input [, PreferredType])
var isObject = __webpack_require__(5);
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (it, S) {
  if (!isObject(it)) return it;
  var fn, val;
  if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
  if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  throw TypeError("Can't convert object to primitive value");
};


/***/ }),
/* 32 */
/***/ (function(module, exports) {

// 7.2.1 RequireObjectCoercible(argument)
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on  " + it);
  return it;
};


/***/ }),
/* 33 */
/***/ (function(module, exports) {

// 7.1.4 ToInteger
var ceil = Math.ceil;
var floor = Math.floor;
module.exports = function (it) {
  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
};


/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

// most Object methods by ES6 should accept primitives
var $export = __webpack_require__(0);
var core = __webpack_require__(26);
var fails = __webpack_require__(4);
module.exports = function (KEY, exec) {
  var fn = (core.Object || {})[KEY] || Object[KEY];
  var exp = {};
  exp[KEY] = exec(fn);
  $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);
};


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

// 0 -> Array#forEach
// 1 -> Array#map
// 2 -> Array#filter
// 3 -> Array#some
// 4 -> Array#every
// 5 -> Array#find
// 6 -> Array#findIndex
var ctx = __webpack_require__(27);
var IObject = __webpack_require__(60);
var toObject = __webpack_require__(13);
var toLength = __webpack_require__(11);
var asc = __webpack_require__(109);
module.exports = function (TYPE, $create) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  var create = $create || asc;
  return function ($this, callbackfn, that) {
    var O = toObject($this);
    var self = IObject(O);
    var f = ctx(callbackfn, that, 3);
    var length = toLength(self.length);
    var index = 0;
    var result = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
    var val, res;
    for (;length > index; index++) if (NO_HOLES || index in self) {
      val = self[index];
      res = f(val, index, O);
      if (TYPE) {
        if (IS_MAP) result[index] = res;   // map
        else if (res) switch (TYPE) {
          case 3: return true;             // some
          case 5: return val;              // find
          case 6: return index;            // findIndex
          case 2: result.push(val);        // filter
        } else if (IS_EVERY) return false; // every
      }
    }
    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : result;
  };
};


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var assert = __webpack_require__(25);
var inherits = __webpack_require__(1);

exports.inherits = inherits;

function toArray(msg, enc) {
  if (Array.isArray(msg))
    return msg.slice();
  if (!msg)
    return [];
  var res = [];
  if (typeof msg === 'string') {
    if (!enc) {
      for (var i = 0; i < msg.length; i++) {
        var c = msg.charCodeAt(i);
        var hi = c >> 8;
        var lo = c & 0xff;
        if (hi)
          res.push(hi, lo);
        else
          res.push(lo);
      }
    } else if (enc === 'hex') {
      msg = msg.replace(/[^a-z0-9]+/ig, '');
      if (msg.length % 2 !== 0)
        msg = '0' + msg;
      for (i = 0; i < msg.length; i += 2)
        res.push(parseInt(msg[i] + msg[i + 1], 16));
    }
  } else {
    for (i = 0; i < msg.length; i++)
      res[i] = msg[i] | 0;
  }
  return res;
}
exports.toArray = toArray;

function toHex(msg) {
  var res = '';
  for (var i = 0; i < msg.length; i++)
    res += zero2(msg[i].toString(16));
  return res;
}
exports.toHex = toHex;

function htonl(w) {
  var res = (w >>> 24) |
            ((w >>> 8) & 0xff00) |
            ((w << 8) & 0xff0000) |
            ((w & 0xff) << 24);
  return res >>> 0;
}
exports.htonl = htonl;

function toHex32(msg, endian) {
  var res = '';
  for (var i = 0; i < msg.length; i++) {
    var w = msg[i];
    if (endian === 'little')
      w = htonl(w);
    res += zero8(w.toString(16));
  }
  return res;
}
exports.toHex32 = toHex32;

function zero2(word) {
  if (word.length === 1)
    return '0' + word;
  else
    return word;
}
exports.zero2 = zero2;

function zero8(word) {
  if (word.length === 7)
    return '0' + word;
  else if (word.length === 6)
    return '00' + word;
  else if (word.length === 5)
    return '000' + word;
  else if (word.length === 4)
    return '0000' + word;
  else if (word.length === 3)
    return '00000' + word;
  else if (word.length === 2)
    return '000000' + word;
  else if (word.length === 1)
    return '0000000' + word;
  else
    return word;
}
exports.zero8 = zero8;

function join32(msg, start, end, endian) {
  var len = end - start;
  assert(len % 4 === 0);
  var res = new Array(len / 4);
  for (var i = 0, k = start; i < res.length; i++, k += 4) {
    var w;
    if (endian === 'big')
      w = (msg[k] << 24) | (msg[k + 1] << 16) | (msg[k + 2] << 8) | msg[k + 3];
    else
      w = (msg[k + 3] << 24) | (msg[k + 2] << 16) | (msg[k + 1] << 8) | msg[k];
    res[i] = w >>> 0;
  }
  return res;
}
exports.join32 = join32;

function split32(msg, endian) {
  var res = new Array(msg.length * 4);
  for (var i = 0, k = 0; i < msg.length; i++, k += 4) {
    var m = msg[i];
    if (endian === 'big') {
      res[k] = m >>> 24;
      res[k + 1] = (m >>> 16) & 0xff;
      res[k + 2] = (m >>> 8) & 0xff;
      res[k + 3] = m & 0xff;
    } else {
      res[k + 3] = m >>> 24;
      res[k + 2] = (m >>> 16) & 0xff;
      res[k + 1] = (m >>> 8) & 0xff;
      res[k] = m & 0xff;
    }
  }
  return res;
}
exports.split32 = split32;

function rotr32(w, b) {
  return (w >>> b) | (w << (32 - b));
}
exports.rotr32 = rotr32;

function rotl32(w, b) {
  return (w << b) | (w >>> (32 - b));
}
exports.rotl32 = rotl32;

function sum32(a, b) {
  return (a + b) >>> 0;
}
exports.sum32 = sum32;

function sum32_3(a, b, c) {
  return (a + b + c) >>> 0;
}
exports.sum32_3 = sum32_3;

function sum32_4(a, b, c, d) {
  return (a + b + c + d) >>> 0;
}
exports.sum32_4 = sum32_4;

function sum32_5(a, b, c, d, e) {
  return (a + b + c + d + e) >>> 0;
}
exports.sum32_5 = sum32_5;

function sum64(buf, pos, ah, al) {
  var bh = buf[pos];
  var bl = buf[pos + 1];

  var lo = (al + bl) >>> 0;
  var hi = (lo < al ? 1 : 0) + ah + bh;
  buf[pos] = hi >>> 0;
  buf[pos + 1] = lo;
}
exports.sum64 = sum64;

function sum64_hi(ah, al, bh, bl) {
  var lo = (al + bl) >>> 0;
  var hi = (lo < al ? 1 : 0) + ah + bh;
  return hi >>> 0;
}
exports.sum64_hi = sum64_hi;

function sum64_lo(ah, al, bh, bl) {
  var lo = al + bl;
  return lo >>> 0;
}
exports.sum64_lo = sum64_lo;

function sum64_4_hi(ah, al, bh, bl, ch, cl, dh, dl) {
  var carry = 0;
  var lo = al;
  lo = (lo + bl) >>> 0;
  carry += lo < al ? 1 : 0;
  lo = (lo + cl) >>> 0;
  carry += lo < cl ? 1 : 0;
  lo = (lo + dl) >>> 0;
  carry += lo < dl ? 1 : 0;

  var hi = ah + bh + ch + dh + carry;
  return hi >>> 0;
}
exports.sum64_4_hi = sum64_4_hi;

function sum64_4_lo(ah, al, bh, bl, ch, cl, dh, dl) {
  var lo = al + bl + cl + dl;
  return lo >>> 0;
}
exports.sum64_4_lo = sum64_4_lo;

function sum64_5_hi(ah, al, bh, bl, ch, cl, dh, dl, eh, el) {
  var carry = 0;
  var lo = al;
  lo = (lo + bl) >>> 0;
  carry += lo < al ? 1 : 0;
  lo = (lo + cl) >>> 0;
  carry += lo < cl ? 1 : 0;
  lo = (lo + dl) >>> 0;
  carry += lo < dl ? 1 : 0;
  lo = (lo + el) >>> 0;
  carry += lo < el ? 1 : 0;

  var hi = ah + bh + ch + dh + eh + carry;
  return hi >>> 0;
}
exports.sum64_5_hi = sum64_5_hi;

function sum64_5_lo(ah, al, bh, bl, ch, cl, dh, dl, eh, el) {
  var lo = al + bl + cl + dl + el;

  return lo >>> 0;
}
exports.sum64_5_lo = sum64_5_lo;

function rotr64_hi(ah, al, num) {
  var r = (al << (32 - num)) | (ah >>> num);
  return r >>> 0;
}
exports.rotr64_hi = rotr64_hi;

function rotr64_lo(ah, al, num) {
  var r = (ah << (32 - num)) | (al >>> num);
  return r >>> 0;
}
exports.rotr64_lo = rotr64_lo;

function shr64_hi(ah, al, num) {
  return ah >>> num;
}
exports.shr64_hi = shr64_hi;

function shr64_lo(ah, al, num) {
  var r = (ah << (32 - num)) | (al >>> num);
  return r >>> 0;
}
exports.shr64_lo = shr64_lo;


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

if (__webpack_require__(9)) {
  var LIBRARY = __webpack_require__(40);
  var global = __webpack_require__(3);
  var fails = __webpack_require__(4);
  var $export = __webpack_require__(0);
  var $typed = __webpack_require__(81);
  var $buffer = __webpack_require__(115);
  var ctx = __webpack_require__(27);
  var anInstance = __webpack_require__(50);
  var propertyDesc = __webpack_require__(43);
  var hide = __webpack_require__(17);
  var redefineAll = __webpack_require__(52);
  var toInteger = __webpack_require__(33);
  var toLength = __webpack_require__(11);
  var toIndex = __webpack_require__(154);
  var toAbsoluteIndex = __webpack_require__(46);
  var toPrimitive = __webpack_require__(31);
  var has = __webpack_require__(20);
  var classof = __webpack_require__(62);
  var isObject = __webpack_require__(5);
  var toObject = __webpack_require__(13);
  var isArrayIter = __webpack_require__(106);
  var create = __webpack_require__(47);
  var getPrototypeOf = __webpack_require__(23);
  var gOPN = __webpack_require__(48).f;
  var getIterFn = __webpack_require__(108);
  var uid = __webpack_require__(44);
  var wks = __webpack_require__(7);
  var createArrayMethod = __webpack_require__(35);
  var createArrayIncludes = __webpack_require__(71);
  var speciesConstructor = __webpack_require__(78);
  var ArrayIterators = __webpack_require__(111);
  var Iterators = __webpack_require__(56);
  var $iterDetect = __webpack_require__(75);
  var setSpecies = __webpack_require__(49);
  var arrayFill = __webpack_require__(110);
  var arrayCopyWithin = __webpack_require__(144);
  var $DP = __webpack_require__(10);
  var $GOPD = __webpack_require__(22);
  var dP = $DP.f;
  var gOPD = $GOPD.f;
  var RangeError = global.RangeError;
  var TypeError = global.TypeError;
  var Uint8Array = global.Uint8Array;
  var ARRAY_BUFFER = 'ArrayBuffer';
  var SHARED_BUFFER = 'Shared' + ARRAY_BUFFER;
  var BYTES_PER_ELEMENT = 'BYTES_PER_ELEMENT';
  var PROTOTYPE = 'prototype';
  var ArrayProto = Array[PROTOTYPE];
  var $ArrayBuffer = $buffer.ArrayBuffer;
  var $DataView = $buffer.DataView;
  var arrayForEach = createArrayMethod(0);
  var arrayFilter = createArrayMethod(2);
  var arraySome = createArrayMethod(3);
  var arrayEvery = createArrayMethod(4);
  var arrayFind = createArrayMethod(5);
  var arrayFindIndex = createArrayMethod(6);
  var arrayIncludes = createArrayIncludes(true);
  var arrayIndexOf = createArrayIncludes(false);
  var arrayValues = ArrayIterators.values;
  var arrayKeys = ArrayIterators.keys;
  var arrayEntries = ArrayIterators.entries;
  var arrayLastIndexOf = ArrayProto.lastIndexOf;
  var arrayReduce = ArrayProto.reduce;
  var arrayReduceRight = ArrayProto.reduceRight;
  var arrayJoin = ArrayProto.join;
  var arraySort = ArrayProto.sort;
  var arraySlice = ArrayProto.slice;
  var arrayToString = ArrayProto.toString;
  var arrayToLocaleString = ArrayProto.toLocaleString;
  var ITERATOR = wks('iterator');
  var TAG = wks('toStringTag');
  var TYPED_CONSTRUCTOR = uid('typed_constructor');
  var DEF_CONSTRUCTOR = uid('def_constructor');
  var ALL_CONSTRUCTORS = $typed.CONSTR;
  var TYPED_ARRAY = $typed.TYPED;
  var VIEW = $typed.VIEW;
  var WRONG_LENGTH = 'Wrong length!';

  var $map = createArrayMethod(1, function (O, length) {
    return allocate(speciesConstructor(O, O[DEF_CONSTRUCTOR]), length);
  });

  var LITTLE_ENDIAN = fails(function () {
    // eslint-disable-next-line no-undef
    return new Uint8Array(new Uint16Array([1]).buffer)[0] === 1;
  });

  var FORCED_SET = !!Uint8Array && !!Uint8Array[PROTOTYPE].set && fails(function () {
    new Uint8Array(1).set({});
  });

  var toOffset = function (it, BYTES) {
    var offset = toInteger(it);
    if (offset < 0 || offset % BYTES) throw RangeError('Wrong offset!');
    return offset;
  };

  var validate = function (it) {
    if (isObject(it) && TYPED_ARRAY in it) return it;
    throw TypeError(it + ' is not a typed array!');
  };

  var allocate = function (C, length) {
    if (!(isObject(C) && TYPED_CONSTRUCTOR in C)) {
      throw TypeError('It is not a typed array constructor!');
    } return new C(length);
  };

  var speciesFromList = function (O, list) {
    return fromList(speciesConstructor(O, O[DEF_CONSTRUCTOR]), list);
  };

  var fromList = function (C, list) {
    var index = 0;
    var length = list.length;
    var result = allocate(C, length);
    while (length > index) result[index] = list[index++];
    return result;
  };

  var addGetter = function (it, key, internal) {
    dP(it, key, { get: function () { return this._d[internal]; } });
  };

  var $from = function from(source /* , mapfn, thisArg */) {
    var O = toObject(source);
    var aLen = arguments.length;
    var mapfn = aLen > 1 ? arguments[1] : undefined;
    var mapping = mapfn !== undefined;
    var iterFn = getIterFn(O);
    var i, length, values, result, step, iterator;
    if (iterFn != undefined && !isArrayIter(iterFn)) {
      for (iterator = iterFn.call(O), values = [], i = 0; !(step = iterator.next()).done; i++) {
        values.push(step.value);
      } O = values;
    }
    if (mapping && aLen > 2) mapfn = ctx(mapfn, arguments[2], 2);
    for (i = 0, length = toLength(O.length), result = allocate(this, length); length > i; i++) {
      result[i] = mapping ? mapfn(O[i], i) : O[i];
    }
    return result;
  };

  var $of = function of(/* ...items */) {
    var index = 0;
    var length = arguments.length;
    var result = allocate(this, length);
    while (length > index) result[index] = arguments[index++];
    return result;
  };

  // iOS Safari 6.x fails here
  var TO_LOCALE_BUG = !!Uint8Array && fails(function () { arrayToLocaleString.call(new Uint8Array(1)); });

  var $toLocaleString = function toLocaleString() {
    return arrayToLocaleString.apply(TO_LOCALE_BUG ? arraySlice.call(validate(this)) : validate(this), arguments);
  };

  var proto = {
    copyWithin: function copyWithin(target, start /* , end */) {
      return arrayCopyWithin.call(validate(this), target, start, arguments.length > 2 ? arguments[2] : undefined);
    },
    every: function every(callbackfn /* , thisArg */) {
      return arrayEvery(validate(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
    },
    fill: function fill(value /* , start, end */) { // eslint-disable-line no-unused-vars
      return arrayFill.apply(validate(this), arguments);
    },
    filter: function filter(callbackfn /* , thisArg */) {
      return speciesFromList(this, arrayFilter(validate(this), callbackfn,
        arguments.length > 1 ? arguments[1] : undefined));
    },
    find: function find(predicate /* , thisArg */) {
      return arrayFind(validate(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
    },
    findIndex: function findIndex(predicate /* , thisArg */) {
      return arrayFindIndex(validate(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
    },
    forEach: function forEach(callbackfn /* , thisArg */) {
      arrayForEach(validate(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
    },
    indexOf: function indexOf(searchElement /* , fromIndex */) {
      return arrayIndexOf(validate(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
    },
    includes: function includes(searchElement /* , fromIndex */) {
      return arrayIncludes(validate(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
    },
    join: function join(separator) { // eslint-disable-line no-unused-vars
      return arrayJoin.apply(validate(this), arguments);
    },
    lastIndexOf: function lastIndexOf(searchElement /* , fromIndex */) { // eslint-disable-line no-unused-vars
      return arrayLastIndexOf.apply(validate(this), arguments);
    },
    map: function map(mapfn /* , thisArg */) {
      return $map(validate(this), mapfn, arguments.length > 1 ? arguments[1] : undefined);
    },
    reduce: function reduce(callbackfn /* , initialValue */) { // eslint-disable-line no-unused-vars
      return arrayReduce.apply(validate(this), arguments);
    },
    reduceRight: function reduceRight(callbackfn /* , initialValue */) { // eslint-disable-line no-unused-vars
      return arrayReduceRight.apply(validate(this), arguments);
    },
    reverse: function reverse() {
      var that = this;
      var length = validate(that).length;
      var middle = Math.floor(length / 2);
      var index = 0;
      var value;
      while (index < middle) {
        value = that[index];
        that[index++] = that[--length];
        that[length] = value;
      } return that;
    },
    some: function some(callbackfn /* , thisArg */) {
      return arraySome(validate(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
    },
    sort: function sort(comparefn) {
      return arraySort.call(validate(this), comparefn);
    },
    subarray: function subarray(begin, end) {
      var O = validate(this);
      var length = O.length;
      var $begin = toAbsoluteIndex(begin, length);
      return new (speciesConstructor(O, O[DEF_CONSTRUCTOR]))(
        O.buffer,
        O.byteOffset + $begin * O.BYTES_PER_ELEMENT,
        toLength((end === undefined ? length : toAbsoluteIndex(end, length)) - $begin)
      );
    }
  };

  var $slice = function slice(start, end) {
    return speciesFromList(this, arraySlice.call(validate(this), start, end));
  };

  var $set = function set(arrayLike /* , offset */) {
    validate(this);
    var offset = toOffset(arguments[1], 1);
    var length = this.length;
    var src = toObject(arrayLike);
    var len = toLength(src.length);
    var index = 0;
    if (len + offset > length) throw RangeError(WRONG_LENGTH);
    while (index < len) this[offset + index] = src[index++];
  };

  var $iterators = {
    entries: function entries() {
      return arrayEntries.call(validate(this));
    },
    keys: function keys() {
      return arrayKeys.call(validate(this));
    },
    values: function values() {
      return arrayValues.call(validate(this));
    }
  };

  var isTAIndex = function (target, key) {
    return isObject(target)
      && target[TYPED_ARRAY]
      && typeof key != 'symbol'
      && key in target
      && String(+key) == String(key);
  };
  var $getDesc = function getOwnPropertyDescriptor(target, key) {
    return isTAIndex(target, key = toPrimitive(key, true))
      ? propertyDesc(2, target[key])
      : gOPD(target, key);
  };
  var $setDesc = function defineProperty(target, key, desc) {
    if (isTAIndex(target, key = toPrimitive(key, true))
      && isObject(desc)
      && has(desc, 'value')
      && !has(desc, 'get')
      && !has(desc, 'set')
      // TODO: add validation descriptor w/o calling accessors
      && !desc.configurable
      && (!has(desc, 'writable') || desc.writable)
      && (!has(desc, 'enumerable') || desc.enumerable)
    ) {
      target[key] = desc.value;
      return target;
    } return dP(target, key, desc);
  };

  if (!ALL_CONSTRUCTORS) {
    $GOPD.f = $getDesc;
    $DP.f = $setDesc;
  }

  $export($export.S + $export.F * !ALL_CONSTRUCTORS, 'Object', {
    getOwnPropertyDescriptor: $getDesc,
    defineProperty: $setDesc
  });

  if (fails(function () { arrayToString.call({}); })) {
    arrayToString = arrayToLocaleString = function toString() {
      return arrayJoin.call(this);
    };
  }

  var $TypedArrayPrototype$ = redefineAll({}, proto);
  redefineAll($TypedArrayPrototype$, $iterators);
  hide($TypedArrayPrototype$, ITERATOR, $iterators.values);
  redefineAll($TypedArrayPrototype$, {
    slice: $slice,
    set: $set,
    constructor: function () { /* noop */ },
    toString: arrayToString,
    toLocaleString: $toLocaleString
  });
  addGetter($TypedArrayPrototype$, 'buffer', 'b');
  addGetter($TypedArrayPrototype$, 'byteOffset', 'o');
  addGetter($TypedArrayPrototype$, 'byteLength', 'l');
  addGetter($TypedArrayPrototype$, 'length', 'e');
  dP($TypedArrayPrototype$, TAG, {
    get: function () { return this[TYPED_ARRAY]; }
  });

  // eslint-disable-next-line max-statements
  module.exports = function (KEY, BYTES, wrapper, CLAMPED) {
    CLAMPED = !!CLAMPED;
    var NAME = KEY + (CLAMPED ? 'Clamped' : '') + 'Array';
    var GETTER = 'get' + KEY;
    var SETTER = 'set' + KEY;
    var TypedArray = global[NAME];
    var Base = TypedArray || {};
    var TAC = TypedArray && getPrototypeOf(TypedArray);
    var FORCED = !TypedArray || !$typed.ABV;
    var O = {};
    var TypedArrayPrototype = TypedArray && TypedArray[PROTOTYPE];
    var getter = function (that, index) {
      var data = that._d;
      return data.v[GETTER](index * BYTES + data.o, LITTLE_ENDIAN);
    };
    var setter = function (that, index, value) {
      var data = that._d;
      if (CLAMPED) value = (value = Math.round(value)) < 0 ? 0 : value > 0xff ? 0xff : value & 0xff;
      data.v[SETTER](index * BYTES + data.o, value, LITTLE_ENDIAN);
    };
    var addElement = function (that, index) {
      dP(that, index, {
        get: function () {
          return getter(this, index);
        },
        set: function (value) {
          return setter(this, index, value);
        },
        enumerable: true
      });
    };
    if (FORCED) {
      TypedArray = wrapper(function (that, data, $offset, $length) {
        anInstance(that, TypedArray, NAME, '_d');
        var index = 0;
        var offset = 0;
        var buffer, byteLength, length, klass;
        if (!isObject(data)) {
          length = toIndex(data);
          byteLength = length * BYTES;
          buffer = new $ArrayBuffer(byteLength);
        } else if (data instanceof $ArrayBuffer || (klass = classof(data)) == ARRAY_BUFFER || klass == SHARED_BUFFER) {
          buffer = data;
          offset = toOffset($offset, BYTES);
          var $len = data.byteLength;
          if ($length === undefined) {
            if ($len % BYTES) throw RangeError(WRONG_LENGTH);
            byteLength = $len - offset;
            if (byteLength < 0) throw RangeError(WRONG_LENGTH);
          } else {
            byteLength = toLength($length) * BYTES;
            if (byteLength + offset > $len) throw RangeError(WRONG_LENGTH);
          }
          length = byteLength / BYTES;
        } else if (TYPED_ARRAY in data) {
          return fromList(TypedArray, data);
        } else {
          return $from.call(TypedArray, data);
        }
        hide(that, '_d', {
          b: buffer,
          o: offset,
          l: byteLength,
          e: length,
          v: new $DataView(buffer)
        });
        while (index < length) addElement(that, index++);
      });
      TypedArrayPrototype = TypedArray[PROTOTYPE] = create($TypedArrayPrototype$);
      hide(TypedArrayPrototype, 'constructor', TypedArray);
    } else if (!fails(function () {
      TypedArray(1);
    }) || !fails(function () {
      new TypedArray(-1); // eslint-disable-line no-new
    }) || !$iterDetect(function (iter) {
      new TypedArray(); // eslint-disable-line no-new
      new TypedArray(null); // eslint-disable-line no-new
      new TypedArray(1.5); // eslint-disable-line no-new
      new TypedArray(iter); // eslint-disable-line no-new
    }, true)) {
      TypedArray = wrapper(function (that, data, $offset, $length) {
        anInstance(that, TypedArray, NAME);
        var klass;
        // `ws` module bug, temporarily remove validation length for Uint8Array
        // https://github.com/websockets/ws/pull/645
        if (!isObject(data)) return new Base(toIndex(data));
        if (data instanceof $ArrayBuffer || (klass = classof(data)) == ARRAY_BUFFER || klass == SHARED_BUFFER) {
          return $length !== undefined
            ? new Base(data, toOffset($offset, BYTES), $length)
            : $offset !== undefined
              ? new Base(data, toOffset($offset, BYTES))
              : new Base(data);
        }
        if (TYPED_ARRAY in data) return fromList(TypedArray, data);
        return $from.call(TypedArray, data);
      });
      arrayForEach(TAC !== Function.prototype ? gOPN(Base).concat(gOPN(TAC)) : gOPN(Base), function (key) {
        if (!(key in TypedArray)) hide(TypedArray, key, Base[key]);
      });
      TypedArray[PROTOTYPE] = TypedArrayPrototype;
      if (!LIBRARY) TypedArrayPrototype.constructor = TypedArray;
    }
    var $nativeIterator = TypedArrayPrototype[ITERATOR];
    var CORRECT_ITER_NAME = !!$nativeIterator
      && ($nativeIterator.name == 'values' || $nativeIterator.name == undefined);
    var $iterator = $iterators.values;
    hide(TypedArray, TYPED_CONSTRUCTOR, true);
    hide(TypedArrayPrototype, TYPED_ARRAY, NAME);
    hide(TypedArrayPrototype, VIEW, true);
    hide(TypedArrayPrototype, DEF_CONSTRUCTOR, TypedArray);

    if (CLAMPED ? new TypedArray(1)[TAG] != NAME : !(TAG in TypedArrayPrototype)) {
      dP(TypedArrayPrototype, TAG, {
        get: function () { return NAME; }
      });
    }

    O[NAME] = TypedArray;

    $export($export.G + $export.W + $export.F * (TypedArray != Base), O);

    $export($export.S, NAME, {
      BYTES_PER_ELEMENT: BYTES
    });

    $export($export.S + $export.F * fails(function () { Base.of.call(TypedArray, 1); }), NAME, {
      from: $from,
      of: $of
    });

    if (!(BYTES_PER_ELEMENT in TypedArrayPrototype)) hide(TypedArrayPrototype, BYTES_PER_ELEMENT, BYTES);

    $export($export.P, NAME, proto);

    setSpecies(NAME);

    $export($export.P + $export.F * FORCED_SET, NAME, { set: $set });

    $export($export.P + $export.F * !CORRECT_ITER_NAME, NAME, $iterators);

    if (!LIBRARY && TypedArrayPrototype.toString != arrayToString) TypedArrayPrototype.toString = arrayToString;

    $export($export.P + $export.F * fails(function () {
      new TypedArray(1).slice();
    }), NAME, { slice: $slice });

    $export($export.P + $export.F * (fails(function () {
      return [1, 2].toLocaleString() != new TypedArray([1, 2]).toLocaleString();
    }) || !fails(function () {
      TypedArrayPrototype.toLocaleString.call([1, 2]);
    })), NAME, { toLocaleString: $toLocaleString });

    Iterators[NAME] = CORRECT_ITER_NAME ? $nativeIterator : $iterator;
    if (!LIBRARY && !CORRECT_ITER_NAME) hide(TypedArrayPrototype, ITERATOR, $iterator);
  };
} else module.exports = function () { /* empty */ };


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

var Map = __webpack_require__(149);
var $export = __webpack_require__(0);
var shared = __webpack_require__(70)('metadata');
var store = shared.store || (shared.store = new (__webpack_require__(152))());

var getOrCreateMetadataMap = function (target, targetKey, create) {
  var targetMetadata = store.get(target);
  if (!targetMetadata) {
    if (!create) return undefined;
    store.set(target, targetMetadata = new Map());
  }
  var keyMetadata = targetMetadata.get(targetKey);
  if (!keyMetadata) {
    if (!create) return undefined;
    targetMetadata.set(targetKey, keyMetadata = new Map());
  } return keyMetadata;
};
var ordinaryHasOwnMetadata = function (MetadataKey, O, P) {
  var metadataMap = getOrCreateMetadataMap(O, P, false);
  return metadataMap === undefined ? false : metadataMap.has(MetadataKey);
};
var ordinaryGetOwnMetadata = function (MetadataKey, O, P) {
  var metadataMap = getOrCreateMetadataMap(O, P, false);
  return metadataMap === undefined ? undefined : metadataMap.get(MetadataKey);
};
var ordinaryDefineOwnMetadata = function (MetadataKey, MetadataValue, O, P) {
  getOrCreateMetadataMap(O, P, true).set(MetadataKey, MetadataValue);
};
var ordinaryOwnMetadataKeys = function (target, targetKey) {
  var metadataMap = getOrCreateMetadataMap(target, targetKey, false);
  var keys = [];
  if (metadataMap) metadataMap.forEach(function (_, key) { keys.push(key); });
  return keys;
};
var toMetaKey = function (it) {
  return it === undefined || typeof it == 'symbol' ? it : String(it);
};
var exp = function (O) {
  $export($export.S, 'Reflect', O);
};

module.exports = {
  store: store,
  map: getOrCreateMetadataMap,
  has: ordinaryHasOwnMetadata,
  get: ordinaryGetOwnMetadata,
  set: ordinaryDefineOwnMetadata,
  keys: ordinaryOwnMetadataKeys,
  key: toMetaKey,
  exp: exp
};


/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

var META = __webpack_require__(44)('meta');
var isObject = __webpack_require__(5);
var has = __webpack_require__(20);
var setDesc = __webpack_require__(10).f;
var id = 0;
var isExtensible = Object.isExtensible || function () {
  return true;
};
var FREEZE = !__webpack_require__(4)(function () {
  return isExtensible(Object.preventExtensions({}));
});
var setMeta = function (it) {
  setDesc(it, META, { value: {
    i: 'O' + ++id, // object ID
    w: {}          // weak collections IDs
  } });
};
var fastKey = function (it, create) {
  // return primitive with prefix
  if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return 'F';
    // not necessary to add metadata
    if (!create) return 'E';
    // add missing metadata
    setMeta(it);
  // return object ID
  } return it[META].i;
};
var getWeak = function (it, create) {
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return true;
    // not necessary to add metadata
    if (!create) return false;
    // add missing metadata
    setMeta(it);
  // return hash weak collections IDs
  } return it[META].w;
};
// add metadata on freeze-family methods calling
var onFreeze = function (it) {
  if (FREEZE && meta.NEED && isExtensible(it) && !has(it, META)) setMeta(it);
  return it;
};
var meta = module.exports = {
  KEY: META,
  NEED: false,
  fastKey: fastKey,
  getWeak: getWeak,
  onFreeze: onFreeze
};


/***/ }),
/* 40 */
/***/ (function(module, exports) {

module.exports = false;


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

// 22.1.3.31 Array.prototype[@@unscopables]
var UNSCOPABLES = __webpack_require__(7)('unscopables');
var ArrayProto = Array.prototype;
if (ArrayProto[UNSCOPABLES] == undefined) __webpack_require__(17)(ArrayProto, UNSCOPABLES, {});
module.exports = function (key) {
  ArrayProto[UNSCOPABLES][key] = true;
};


/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

var Buffer = __webpack_require__(6).Buffer
var Transform = __webpack_require__(117).Transform
var StringDecoder = __webpack_require__(120).StringDecoder
var inherits = __webpack_require__(1)

function CipherBase (hashMode) {
  Transform.call(this)
  this.hashMode = typeof hashMode === 'string'
  if (this.hashMode) {
    this[hashMode] = this._finalOrDigest
  } else {
    this.final = this._finalOrDigest
  }
  if (this._final) {
    this.__final = this._final
    this._final = null
  }
  this._decoder = null
  this._encoding = null
}
inherits(CipherBase, Transform)

CipherBase.prototype.update = function (data, inputEnc, outputEnc) {
  if (typeof data === 'string') {
    data = Buffer.from(data, inputEnc)
  }

  var outData = this._update(data)
  if (this.hashMode) return this

  if (outputEnc) {
    outData = this._toString(outData, outputEnc)
  }

  return outData
}

CipherBase.prototype.setAutoPadding = function () {}
CipherBase.prototype.getAuthTag = function () {
  throw new Error('trying to get auth tag in unsupported state')
}

CipherBase.prototype.setAuthTag = function () {
  throw new Error('trying to set auth tag in unsupported state')
}

CipherBase.prototype.setAAD = function () {
  throw new Error('trying to set aad in unsupported state')
}

CipherBase.prototype._transform = function (data, _, next) {
  var err
  try {
    if (this.hashMode) {
      this._update(data)
    } else {
      this.push(this._update(data))
    }
  } catch (e) {
    err = e
  } finally {
    next(err)
  }
}
CipherBase.prototype._flush = function (done) {
  var err
  try {
    this.push(this.__final())
  } catch (e) {
    err = e
  }

  done(err)
}
CipherBase.prototype._finalOrDigest = function (outputEnc) {
  var outData = this.__final() || Buffer.alloc(0)
  if (outputEnc) {
    outData = this._toString(outData, outputEnc, true)
  }
  return outData
}

CipherBase.prototype._toString = function (value, enc, fin) {
  if (!this._decoder) {
    this._decoder = new StringDecoder(enc)
    this._encoding = enc
  }

  if (this._encoding !== enc) throw new Error('can\'t switch encodings')

  var out = this._decoder.write(value)
  if (fin) {
    out += this._decoder.end()
  }

  return out
}

module.exports = CipherBase


/***/ }),
/* 43 */
/***/ (function(module, exports) {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),
/* 44 */
/***/ (function(module, exports) {

var id = 0;
var px = Math.random();
module.exports = function (key) {
  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
};


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.14 / 15.2.3.14 Object.keys(O)
var $keys = __webpack_require__(130);
var enumBugKeys = __webpack_require__(93);

module.exports = Object.keys || function keys(O) {
  return $keys(O, enumBugKeys);
};


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(33);
var max = Math.max;
var min = Math.min;
module.exports = function (index, length) {
  index = toInteger(index);
  return index < 0 ? max(index + length, 0) : min(index, length);
};


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
var anObject = __webpack_require__(2);
var dPs = __webpack_require__(131);
var enumBugKeys = __webpack_require__(93);
var IE_PROTO = __webpack_require__(92)('IE_PROTO');
var Empty = function () { /* empty */ };
var PROTOTYPE = 'prototype';

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var createDict = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = __webpack_require__(90)('iframe');
  var i = enumBugKeys.length;
  var lt = '<';
  var gt = '>';
  var iframeDocument;
  iframe.style.display = 'none';
  __webpack_require__(94).appendChild(iframe);
  iframe.src = 'javascript:'; // eslint-disable-line no-script-url
  // createDict = iframe.contentWindow.Object;
  // html.removeChild(iframe);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
  iframeDocument.close();
  createDict = iframeDocument.F;
  while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];
  return createDict();
};

module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    Empty[PROTOTYPE] = anObject(O);
    result = new Empty();
    Empty[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = createDict();
  return Properties === undefined ? result : dPs(result, Properties);
};


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)
var $keys = __webpack_require__(130);
var hiddenKeys = __webpack_require__(93).concat('length', 'prototype');

exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return $keys(O, hiddenKeys);
};


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var global = __webpack_require__(3);
var dP = __webpack_require__(10);
var DESCRIPTORS = __webpack_require__(9);
var SPECIES = __webpack_require__(7)('species');

module.exports = function (KEY) {
  var C = global[KEY];
  if (DESCRIPTORS && C && !C[SPECIES]) dP.f(C, SPECIES, {
    configurable: true,
    get: function () { return this; }
  });
};


/***/ }),
/* 50 */
/***/ (function(module, exports) {

module.exports = function (it, Constructor, name, forbiddenField) {
  if (!(it instanceof Constructor) || (forbiddenField !== undefined && forbiddenField in it)) {
    throw TypeError(name + ': incorrect invocation!');
  } return it;
};


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

var ctx = __webpack_require__(27);
var call = __webpack_require__(142);
var isArrayIter = __webpack_require__(106);
var anObject = __webpack_require__(2);
var toLength = __webpack_require__(11);
var getIterFn = __webpack_require__(108);
var BREAK = {};
var RETURN = {};
var exports = module.exports = function (iterable, entries, fn, that, ITERATOR) {
  var iterFn = ITERATOR ? function () { return iterable; } : getIterFn(iterable);
  var f = ctx(fn, that, entries ? 2 : 1);
  var index = 0;
  var length, step, iterator, result;
  if (typeof iterFn != 'function') throw TypeError(iterable + ' is not iterable!');
  // fast case for arrays with default iterator
  if (isArrayIter(iterFn)) for (length = toLength(iterable.length); length > index; index++) {
    result = entries ? f(anObject(step = iterable[index])[0], step[1]) : f(iterable[index]);
    if (result === BREAK || result === RETURN) return result;
  } else for (iterator = iterFn.call(iterable); !(step = iterator.next()).done;) {
    result = call(iterator, f, step.value, entries);
    if (result === BREAK || result === RETURN) return result;
  }
};
exports.BREAK = BREAK;
exports.RETURN = RETURN;


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

var redefine = __webpack_require__(18);
module.exports = function (target, src, safe) {
  for (var key in src) redefine(target, key, src[key], safe);
  return target;
};


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a duplex stream is just a stream that is both readable and writable.
// Since JS doesn't have multiple prototypal inheritance, this class
// prototypally inherits from Readable, and then parasitically from
// Writable.



/*<replacement>*/

var pna = __webpack_require__(85);
/*</replacement>*/

/*<replacement>*/
var objectKeys = Object.keys || function (obj) {
  var keys = [];
  for (var key in obj) {
    keys.push(key);
  }return keys;
};
/*</replacement>*/

module.exports = Duplex;

/*<replacement>*/
var util = __webpack_require__(65);
util.inherits = __webpack_require__(1);
/*</replacement>*/

var Readable = __webpack_require__(166);
var Writable = __webpack_require__(119);

util.inherits(Duplex, Readable);

{
  // avoid scope creep, the keys array can then be collected
  var keys = objectKeys(Writable.prototype);
  for (var v = 0; v < keys.length; v++) {
    var method = keys[v];
    if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
  }
}

function Duplex(options) {
  if (!(this instanceof Duplex)) return new Duplex(options);

  Readable.call(this, options);
  Writable.call(this, options);

  if (options && options.readable === false) this.readable = false;

  if (options && options.writable === false) this.writable = false;

  this.allowHalfOpen = true;
  if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;

  this.once('end', onend);
}

Object.defineProperty(Duplex.prototype, 'writableHighWaterMark', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function () {
    return this._writableState.highWaterMark;
  }
});

// the no-half-open enforcer
function onend() {
  // if we allow half-open state, or if the writable side ended,
  // then we're ok.
  if (this.allowHalfOpen || this._writableState.ended) return;

  // no more data can be written.
  // But allow more writes to happen in this tick.
  pna.nextTick(onEndNT, this);
}

function onEndNT(self) {
  self.end();
}

Object.defineProperty(Duplex.prototype, 'destroyed', {
  get: function () {
    if (this._readableState === undefined || this._writableState === undefined) {
      return false;
    }
    return this._readableState.destroyed && this._writableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (this._readableState === undefined || this._writableState === undefined) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._readableState.destroyed = value;
    this._writableState.destroyed = value;
  }
});

Duplex.prototype._destroy = function (err, cb) {
  this.push(null);
  this.end();

  pna.nextTick(cb, err);
};

/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

var def = __webpack_require__(10).f;
var has = __webpack_require__(20);
var TAG = __webpack_require__(7)('toStringTag');

module.exports = function (it, tag, stat) {
  if (it && !has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });
};


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

var $export = __webpack_require__(0);
var defined = __webpack_require__(32);
var fails = __webpack_require__(4);
var spaces = __webpack_require__(96);
var space = '[' + spaces + ']';
var non = '\u200b\u0085';
var ltrim = RegExp('^' + space + space + '*');
var rtrim = RegExp(space + space + '*$');

var exporter = function (KEY, exec, ALIAS) {
  var exp = {};
  var FORCE = fails(function () {
    return !!spaces[KEY]() || non[KEY]() != non;
  });
  var fn = exp[KEY] = FORCE ? exec(trim) : spaces[KEY];
  if (ALIAS) exp[ALIAS] = fn;
  $export($export.P + $export.F * FORCE, 'String', exp);
};

// 1 -> String#trimLeft
// 2 -> String#trimRight
// 3 -> String#trim
var trim = exporter.trim = function (string, TYPE) {
  string = String(defined(string));
  if (TYPE & 1) string = string.replace(ltrim, '');
  if (TYPE & 2) string = string.replace(rtrim, '');
  return string;
};

module.exports = exporter;


/***/ }),
/* 56 */
/***/ (function(module, exports) {

module.exports = {};


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(5);
module.exports = function (it, TYPE) {
  if (!isObject(it) || it._t !== TYPE) throw TypeError('Incompatible receiver, ' + TYPE + ' required!');
  return it;
};


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global, process) {

function oldBrowser () {
  throw new Error('Secure random number generation is not supported by this browser.\nUse Chrome, Firefox or Internet Explorer 11')
}

var Buffer = __webpack_require__(6).Buffer
var crypto = global.crypto || global.msCrypto

if (crypto && crypto.getRandomValues) {
  module.exports = randomBytes
} else {
  module.exports = oldBrowser
}

function randomBytes (size, cb) {
  // phantomjs needs to throw
  if (size > 65536) throw new Error('requested too many random bytes')
  // in case browserify  isn't using the Uint8Array version
  var rawBytes = new global.Uint8Array(size)

  // This will not work in older browsers.
  // See https://developer.mozilla.org/en-US/docs/Web/API/window.crypto.getRandomValues
  if (size > 0) {  // getRandomValues fails on IE if size == 0
    crypto.getRandomValues(rawBytes)
  }

  // XXX: phantomjs doesn't like a buffer being passed here
  var bytes = Buffer.from(rawBytes.buffer)

  if (typeof cb === 'function') {
    return process.nextTick(function () {
      cb(null, bytes)
    })
  }

  return bytes
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(15), __webpack_require__(30)))

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

var Buffer = __webpack_require__(6).Buffer

// prototype class for hash functions
function Hash (blockSize, finalSize) {
  this._block = Buffer.alloc(blockSize)
  this._finalSize = finalSize
  this._blockSize = blockSize
  this._len = 0
}

Hash.prototype.update = function (data, enc) {
  if (typeof data === 'string') {
    enc = enc || 'utf8'
    data = Buffer.from(data, enc)
  }

  var block = this._block
  var blockSize = this._blockSize
  var length = data.length
  var accum = this._len

  for (var offset = 0; offset < length;) {
    var assigned = accum % blockSize
    var remainder = Math.min(length - offset, blockSize - assigned)

    for (var i = 0; i < remainder; i++) {
      block[assigned + i] = data[offset + i]
    }

    accum += remainder
    offset += remainder

    if ((accum % blockSize) === 0) {
      this._update(block)
    }
  }

  this._len += length
  return this
}

Hash.prototype.digest = function (enc) {
  var rem = this._len % this._blockSize

  this._block[rem] = 0x80

  // zero (rem + 1) trailing bits, where (rem + 1) is the smallest
  // non-negative solution to the equation (length + 1 + (rem + 1)) === finalSize mod blockSize
  this._block.fill(0, rem + 1)

  if (rem >= this._finalSize) {
    this._update(this._block)
    this._block.fill(0)
  }

  var bits = this._len * 8

  // uint32
  if (bits <= 0xffffffff) {
    this._block.writeUInt32BE(bits, this._blockSize - 4)

  // uint64
  } else {
    var lowBits = (bits & 0xffffffff) >>> 0
    var highBits = (bits - lowBits) / 0x100000000

    this._block.writeUInt32BE(highBits, this._blockSize - 8)
    this._block.writeUInt32BE(lowBits, this._blockSize - 4)
  }

  this._update(this._block)
  var hash = this._hash()

  return enc ? hash.toString(enc) : hash
}

Hash.prototype._update = function () {
  throw new Error('_update must be implemented by subclass')
}

module.exports = Hash


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var cof = __webpack_require__(28);
// eslint-disable-next-line no-prototype-builtins
module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
  return cof(it) == 'String' ? it.split('') : Object(it);
};


/***/ }),
/* 61 */
/***/ (function(module, exports) {

exports.f = {}.propertyIsEnumerable;


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

// getting tag from 19.1.3.6 Object.prototype.toString()
var cof = __webpack_require__(28);
var TAG = __webpack_require__(7)('toStringTag');
// ES3 wrong here
var ARG = cof(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (e) { /* empty */ }
};

module.exports = function (it) {
  var O, T, B;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (T = tryGet(O = Object(it), TAG)) == 'string' ? T
    // builtinTag case
    : ARG ? cof(O)
    // ES3 arguments fallback
    : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
};


/***/ }),
/* 63 */
/***/ (function(module, exports) {

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

function EventEmitter() {
  this._events = this._events || {};
  this._maxListeners = this._maxListeners || undefined;
}
module.exports = EventEmitter;

// Backwards-compat with node 0.10.x
EventEmitter.EventEmitter = EventEmitter;

EventEmitter.prototype._events = undefined;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
EventEmitter.defaultMaxListeners = 10;

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function(n) {
  if (!isNumber(n) || n < 0 || isNaN(n))
    throw TypeError('n must be a positive number');
  this._maxListeners = n;
  return this;
};

EventEmitter.prototype.emit = function(type) {
  var er, handler, len, args, i, listeners;

  if (!this._events)
    this._events = {};

  // If there is no 'error' event listener then throw.
  if (type === 'error') {
    if (!this._events.error ||
        (isObject(this._events.error) && !this._events.error.length)) {
      er = arguments[1];
      if (er instanceof Error) {
        throw er; // Unhandled 'error' event
      } else {
        // At least give some kind of context to the user
        var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
        err.context = er;
        throw err;
      }
    }
  }

  handler = this._events[type];

  if (isUndefined(handler))
    return false;

  if (isFunction(handler)) {
    switch (arguments.length) {
      // fast cases
      case 1:
        handler.call(this);
        break;
      case 2:
        handler.call(this, arguments[1]);
        break;
      case 3:
        handler.call(this, arguments[1], arguments[2]);
        break;
      // slower
      default:
        args = Array.prototype.slice.call(arguments, 1);
        handler.apply(this, args);
    }
  } else if (isObject(handler)) {
    args = Array.prototype.slice.call(arguments, 1);
    listeners = handler.slice();
    len = listeners.length;
    for (i = 0; i < len; i++)
      listeners[i].apply(this, args);
  }

  return true;
};

EventEmitter.prototype.addListener = function(type, listener) {
  var m;

  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  if (!this._events)
    this._events = {};

  // To avoid recursion in the case that type === "newListener"! Before
  // adding it to the listeners, first emit "newListener".
  if (this._events.newListener)
    this.emit('newListener', type,
              isFunction(listener.listener) ?
              listener.listener : listener);

  if (!this._events[type])
    // Optimize the case of one listener. Don't need the extra array object.
    this._events[type] = listener;
  else if (isObject(this._events[type]))
    // If we've already got an array, just append.
    this._events[type].push(listener);
  else
    // Adding the second element, need to change to array.
    this._events[type] = [this._events[type], listener];

  // Check for listener leak
  if (isObject(this._events[type]) && !this._events[type].warned) {
    if (!isUndefined(this._maxListeners)) {
      m = this._maxListeners;
    } else {
      m = EventEmitter.defaultMaxListeners;
    }

    if (m && m > 0 && this._events[type].length > m) {
      this._events[type].warned = true;
      console.error('(node) warning: possible EventEmitter memory ' +
                    'leak detected. %d listeners added. ' +
                    'Use emitter.setMaxListeners() to increase limit.',
                    this._events[type].length);
      if (typeof console.trace === 'function') {
        // not supported in IE 10
        console.trace();
      }
    }
  }

  return this;
};

EventEmitter.prototype.on = EventEmitter.prototype.addListener;

EventEmitter.prototype.once = function(type, listener) {
  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  var fired = false;

  function g() {
    this.removeListener(type, g);

    if (!fired) {
      fired = true;
      listener.apply(this, arguments);
    }
  }

  g.listener = listener;
  this.on(type, g);

  return this;
};

// emits a 'removeListener' event iff the listener was removed
EventEmitter.prototype.removeListener = function(type, listener) {
  var list, position, length, i;

  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  if (!this._events || !this._events[type])
    return this;

  list = this._events[type];
  length = list.length;
  position = -1;

  if (list === listener ||
      (isFunction(list.listener) && list.listener === listener)) {
    delete this._events[type];
    if (this._events.removeListener)
      this.emit('removeListener', type, listener);

  } else if (isObject(list)) {
    for (i = length; i-- > 0;) {
      if (list[i] === listener ||
          (list[i].listener && list[i].listener === listener)) {
        position = i;
        break;
      }
    }

    if (position < 0)
      return this;

    if (list.length === 1) {
      list.length = 0;
      delete this._events[type];
    } else {
      list.splice(position, 1);
    }

    if (this._events.removeListener)
      this.emit('removeListener', type, listener);
  }

  return this;
};

EventEmitter.prototype.removeAllListeners = function(type) {
  var key, listeners;

  if (!this._events)
    return this;

  // not listening for removeListener, no need to emit
  if (!this._events.removeListener) {
    if (arguments.length === 0)
      this._events = {};
    else if (this._events[type])
      delete this._events[type];
    return this;
  }

  // emit removeListener for all listeners on all events
  if (arguments.length === 0) {
    for (key in this._events) {
      if (key === 'removeListener') continue;
      this.removeAllListeners(key);
    }
    this.removeAllListeners('removeListener');
    this._events = {};
    return this;
  }

  listeners = this._events[type];

  if (isFunction(listeners)) {
    this.removeListener(type, listeners);
  } else if (listeners) {
    // LIFO order
    while (listeners.length)
      this.removeListener(type, listeners[listeners.length - 1]);
  }
  delete this._events[type];

  return this;
};

EventEmitter.prototype.listeners = function(type) {
  var ret;
  if (!this._events || !this._events[type])
    ret = [];
  else if (isFunction(this._events[type]))
    ret = [this._events[type]];
  else
    ret = this._events[type].slice();
  return ret;
};

EventEmitter.prototype.listenerCount = function(type) {
  if (this._events) {
    var evlistener = this._events[type];

    if (isFunction(evlistener))
      return 1;
    else if (evlistener)
      return evlistener.length;
  }
  return 0;
};

EventEmitter.listenerCount = function(emitter, type) {
  return emitter.listenerCount(type);
};

function isFunction(arg) {
  return typeof arg === 'function';
}

function isNumber(arg) {
  return typeof arg === 'number';
}

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}

function isUndefined(arg) {
  return arg === void 0;
}


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var inherits = __webpack_require__(1)
var MD5 = __webpack_require__(116)
var RIPEMD160 = __webpack_require__(121)
var sha = __webpack_require__(122)
var Base = __webpack_require__(42)

function Hash (hash) {
  Base.call(this, 'digest')

  this._hash = hash
}

inherits(Hash, Base)

Hash.prototype._update = function (data) {
  this._hash.update(data)
}

Hash.prototype._final = function () {
  return this._hash.digest()
}

module.exports = function createHash (alg) {
  alg = alg.toLowerCase()
  if (alg === 'md5') return new MD5()
  if (alg === 'rmd160' || alg === 'ripemd160') return new RIPEMD160()

  return new Hash(sha(alg))
}


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.

function isArray(arg) {
  if (Array.isArray) {
    return Array.isArray(arg);
  }
  return objectToString(arg) === '[object Array]';
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return objectToString(d) === '[object Date]';
}
exports.isDate = isDate;

function isError(e) {
  return (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = Buffer.isBuffer;

function objectToString(o) {
  return Object.prototype.toString.call(o);
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(8).Buffer))

/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {module.exports = function xor (a, b) {
  var length = Math.min(a.length, b.length)
  var buffer = new Buffer(length)

  for (var i = 0; i < length; ++i) {
    buffer[i] = a[i] ^ b[i]
  }

  return buffer
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(8).Buffer))

/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(36);
var assert = __webpack_require__(25);

function BlockHash() {
  this.pending = null;
  this.pendingTotal = 0;
  this.blockSize = this.constructor.blockSize;
  this.outSize = this.constructor.outSize;
  this.hmacStrength = this.constructor.hmacStrength;
  this.padLength = this.constructor.padLength / 8;
  this.endian = 'big';

  this._delta8 = this.blockSize / 8;
  this._delta32 = this.blockSize / 32;
}
exports.BlockHash = BlockHash;

BlockHash.prototype.update = function update(msg, enc) {
  // Convert message to array, pad it, and join into 32bit blocks
  msg = utils.toArray(msg, enc);
  if (!this.pending)
    this.pending = msg;
  else
    this.pending = this.pending.concat(msg);
  this.pendingTotal += msg.length;

  // Enough data, try updating
  if (this.pending.length >= this._delta8) {
    msg = this.pending;

    // Process pending data in blocks
    var r = msg.length % this._delta8;
    this.pending = msg.slice(msg.length - r, msg.length);
    if (this.pending.length === 0)
      this.pending = null;

    msg = utils.join32(msg, 0, msg.length - r, this.endian);
    for (var i = 0; i < msg.length; i += this._delta32)
      this._update(msg, i, i + this._delta32);
  }

  return this;
};

BlockHash.prototype.digest = function digest(enc) {
  this.update(this._pad());
  assert(this.pending === null);

  return this._digest(enc);
};

BlockHash.prototype._pad = function pad() {
  var len = this.pendingTotal;
  var bytes = this._delta8;
  var k = bytes - ((len + this.padLength) % bytes);
  var res = new Array(k + this.padLength);
  res[0] = 0x80;
  for (var i = 1; i < k; i++)
    res[i] = 0;

  // Append length
  len <<= 3;
  if (this.endian === 'big') {
    for (var t = 8; t < this.padLength; t++)
      res[i++] = 0;

    res[i++] = 0;
    res[i++] = 0;
    res[i++] = 0;
    res[i++] = 0;
    res[i++] = (len >>> 24) & 0xff;
    res[i++] = (len >>> 16) & 0xff;
    res[i++] = (len >>> 8) & 0xff;
    res[i++] = len & 0xff;
  } else {
    res[i++] = len & 0xff;
    res[i++] = (len >>> 8) & 0xff;
    res[i++] = (len >>> 16) & 0xff;
    res[i++] = (len >>> 24) & 0xff;
    res[i++] = 0;
    res[i++] = 0;
    res[i++] = 0;
    res[i++] = 0;

    for (t = 8; t < this.padLength; t++)
      res[i++] = 0;
  }

  return res;
};


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

var asn1 = exports;

asn1.bignum = __webpack_require__(12);

asn1.define = __webpack_require__(483).define;
asn1.base = __webpack_require__(69);
asn1.constants = __webpack_require__(193);
asn1.decoders = __webpack_require__(489);
asn1.encoders = __webpack_require__(491);


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

var base = exports;

base.Reporter = __webpack_require__(486).Reporter;
base.DecoderBuffer = __webpack_require__(192).DecoderBuffer;
base.EncoderBuffer = __webpack_require__(192).EncoderBuffer;
base.Node = __webpack_require__(487);


/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

var core = __webpack_require__(26);
var global = __webpack_require__(3);
var SHARED = '__core-js_shared__';
var store = global[SHARED] || (global[SHARED] = {});

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: core.version,
  mode: __webpack_require__(40) ? 'pure' : 'global',
  copyright: '© 2018 Denis Pushkarev (zloirock.ru)'
});


/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

// false -> Array#indexOf
// true  -> Array#includes
var toIObject = __webpack_require__(21);
var toLength = __webpack_require__(11);
var toAbsoluteIndex = __webpack_require__(46);
module.exports = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIObject($this);
    var length = toLength(O.length);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) if (IS_INCLUDES || index in O) {
      if (O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};


/***/ }),
/* 72 */
/***/ (function(module, exports) {

exports.f = Object.getOwnPropertySymbols;


/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

// 7.2.2 IsArray(argument)
var cof = __webpack_require__(28);
module.exports = Array.isArray || function isArray(arg) {
  return cof(arg) == 'Array';
};


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

// 7.2.8 IsRegExp(argument)
var isObject = __webpack_require__(5);
var cof = __webpack_require__(28);
var MATCH = __webpack_require__(7)('match');
module.exports = function (it) {
  var isRegExp;
  return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : cof(it) == 'RegExp');
};


/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

var ITERATOR = __webpack_require__(7)('iterator');
var SAFE_CLOSING = false;

try {
  var riter = [7][ITERATOR]();
  riter['return'] = function () { SAFE_CLOSING = true; };
  // eslint-disable-next-line no-throw-literal
  Array.from(riter, function () { throw 2; });
} catch (e) { /* empty */ }

module.exports = function (exec, skipClosing) {
  if (!skipClosing && !SAFE_CLOSING) return false;
  var safe = false;
  try {
    var arr = [7];
    var iter = arr[ITERATOR]();
    iter.next = function () { return { done: safe = true }; };
    arr[ITERATOR] = function () { return iter; };
    exec(arr);
  } catch (e) { /* empty */ }
  return safe;
};


/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// 21.2.5.3 get RegExp.prototype.flags
var anObject = __webpack_require__(2);
module.exports = function () {
  var that = anObject(this);
  var result = '';
  if (that.global) result += 'g';
  if (that.ignoreCase) result += 'i';
  if (that.multiline) result += 'm';
  if (that.unicode) result += 'u';
  if (that.sticky) result += 'y';
  return result;
};


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var hide = __webpack_require__(17);
var redefine = __webpack_require__(18);
var fails = __webpack_require__(4);
var defined = __webpack_require__(32);
var wks = __webpack_require__(7);

module.exports = function (KEY, length, exec) {
  var SYMBOL = wks(KEY);
  var fns = exec(defined, SYMBOL, ''[KEY]);
  var strfn = fns[0];
  var rxfn = fns[1];
  if (fails(function () {
    var O = {};
    O[SYMBOL] = function () { return 7; };
    return ''[KEY](O) != 7;
  })) {
    redefine(String.prototype, KEY, strfn);
    hide(RegExp.prototype, SYMBOL, length == 2
      // 21.2.5.8 RegExp.prototype[@@replace](string, replaceValue)
      // 21.2.5.11 RegExp.prototype[@@split](string, limit)
      ? function (string, arg) { return rxfn.call(string, this, arg); }
      // 21.2.5.6 RegExp.prototype[@@match](string)
      // 21.2.5.9 RegExp.prototype[@@search](string)
      : function (string) { return rxfn.call(string, this); }
    );
  }
};


/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

// 7.3.20 SpeciesConstructor(O, defaultConstructor)
var anObject = __webpack_require__(2);
var aFunction = __webpack_require__(14);
var SPECIES = __webpack_require__(7)('species');
module.exports = function (O, D) {
  var C = anObject(O).constructor;
  var S;
  return C === undefined || (S = anObject(C)[SPECIES]) == undefined ? D : aFunction(S);
};


/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(3);
var navigator = global.navigator;

module.exports = navigator && navigator.userAgent || '';


/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var global = __webpack_require__(3);
var $export = __webpack_require__(0);
var redefine = __webpack_require__(18);
var redefineAll = __webpack_require__(52);
var meta = __webpack_require__(39);
var forOf = __webpack_require__(51);
var anInstance = __webpack_require__(50);
var isObject = __webpack_require__(5);
var fails = __webpack_require__(4);
var $iterDetect = __webpack_require__(75);
var setToStringTag = __webpack_require__(54);
var inheritIfRequired = __webpack_require__(97);

module.exports = function (NAME, wrapper, methods, common, IS_MAP, IS_WEAK) {
  var Base = global[NAME];
  var C = Base;
  var ADDER = IS_MAP ? 'set' : 'add';
  var proto = C && C.prototype;
  var O = {};
  var fixMethod = function (KEY) {
    var fn = proto[KEY];
    redefine(proto, KEY,
      KEY == 'delete' ? function (a) {
        return IS_WEAK && !isObject(a) ? false : fn.call(this, a === 0 ? 0 : a);
      } : KEY == 'has' ? function has(a) {
        return IS_WEAK && !isObject(a) ? false : fn.call(this, a === 0 ? 0 : a);
      } : KEY == 'get' ? function get(a) {
        return IS_WEAK && !isObject(a) ? undefined : fn.call(this, a === 0 ? 0 : a);
      } : KEY == 'add' ? function add(a) { fn.call(this, a === 0 ? 0 : a); return this; }
        : function set(a, b) { fn.call(this, a === 0 ? 0 : a, b); return this; }
    );
  };
  if (typeof C != 'function' || !(IS_WEAK || proto.forEach && !fails(function () {
    new C().entries().next();
  }))) {
    // create collection constructor
    C = common.getConstructor(wrapper, NAME, IS_MAP, ADDER);
    redefineAll(C.prototype, methods);
    meta.NEED = true;
  } else {
    var instance = new C();
    // early implementations not supports chaining
    var HASNT_CHAINING = instance[ADDER](IS_WEAK ? {} : -0, 1) != instance;
    // V8 ~  Chromium 40- weak-collections throws on primitives, but should return false
    var THROWS_ON_PRIMITIVES = fails(function () { instance.has(1); });
    // most early implementations doesn't supports iterables, most modern - not close it correctly
    var ACCEPT_ITERABLES = $iterDetect(function (iter) { new C(iter); }); // eslint-disable-line no-new
    // for early implementations -0 and +0 not the same
    var BUGGY_ZERO = !IS_WEAK && fails(function () {
      // V8 ~ Chromium 42- fails only with 5+ elements
      var $instance = new C();
      var index = 5;
      while (index--) $instance[ADDER](index, index);
      return !$instance.has(-0);
    });
    if (!ACCEPT_ITERABLES) {
      C = wrapper(function (target, iterable) {
        anInstance(target, C, NAME);
        var that = inheritIfRequired(new Base(), target, C);
        if (iterable != undefined) forOf(iterable, IS_MAP, that[ADDER], that);
        return that;
      });
      C.prototype = proto;
      proto.constructor = C;
    }
    if (THROWS_ON_PRIMITIVES || BUGGY_ZERO) {
      fixMethod('delete');
      fixMethod('has');
      IS_MAP && fixMethod('get');
    }
    if (BUGGY_ZERO || HASNT_CHAINING) fixMethod(ADDER);
    // weak collections should not contains .clear method
    if (IS_WEAK && proto.clear) delete proto.clear;
  }

  setToStringTag(C, NAME);

  O[NAME] = C;
  $export($export.G + $export.W + $export.F * (C != Base), O);

  if (!IS_WEAK) common.setStrong(C, NAME, IS_MAP);

  return C;
};


/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(3);
var hide = __webpack_require__(17);
var uid = __webpack_require__(44);
var TYPED = uid('typed_array');
var VIEW = uid('view');
var ABV = !!(global.ArrayBuffer && global.DataView);
var CONSTR = ABV;
var i = 0;
var l = 9;
var Typed;

var TypedArrayConstructors = (
  'Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array'
).split(',');

while (i < l) {
  if (Typed = global[TypedArrayConstructors[i++]]) {
    hide(Typed.prototype, TYPED, true);
    hide(Typed.prototype, VIEW, true);
  } else CONSTR = false;
}

module.exports = {
  ABV: ABV,
  CONSTR: CONSTR,
  TYPED: TYPED,
  VIEW: VIEW
};


/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// Forced replacement prototype accessors methods
module.exports = __webpack_require__(40) || !__webpack_require__(4)(function () {
  var K = Math.random();
  // In FF throws only define methods
  // eslint-disable-next-line no-undef, no-useless-call
  __defineSetter__.call(null, K, function () { /* empty */ });
  delete __webpack_require__(3)[K];
});


/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// https://tc39.github.io/proposal-setmap-offrom/
var $export = __webpack_require__(0);

module.exports = function (COLLECTION) {
  $export($export.S, COLLECTION, { of: function of() {
    var length = arguments.length;
    var A = new Array(length);
    while (length--) A[length] = arguments[length];
    return new this(A);
  } });
};


/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// https://tc39.github.io/proposal-setmap-offrom/
var $export = __webpack_require__(0);
var aFunction = __webpack_require__(14);
var ctx = __webpack_require__(27);
var forOf = __webpack_require__(51);

module.exports = function (COLLECTION) {
  $export($export.S, COLLECTION, { from: function from(source /* , mapFn, thisArg */) {
    var mapFn = arguments[1];
    var mapping, A, n, cb;
    aFunction(this);
    mapping = mapFn !== undefined;
    if (mapping) aFunction(mapFn);
    if (source == undefined) return new this();
    A = [];
    if (mapping) {
      n = 0;
      cb = ctx(mapFn, arguments[2], 2);
      forOf(source, false, function (nextItem) {
        A.push(cb(nextItem, n++));
      });
    } else {
      forOf(source, false, A.push, A);
    }
    return new this(A);
  } });
};


/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

if (!process.version ||
    process.version.indexOf('v0.') === 0 ||
    process.version.indexOf('v1.') === 0 && process.version.indexOf('v1.8.') !== 0) {
  module.exports = { nextTick: nextTick };
} else {
  module.exports = process
}

function nextTick(fn, arg1, arg2, arg3) {
  if (typeof fn !== 'function') {
    throw new TypeError('"callback" argument must be a function');
  }
  var len = arguments.length;
  var args, i;
  switch (len) {
  case 0:
  case 1:
    return process.nextTick(fn);
  case 2:
    return process.nextTick(function afterTickOne() {
      fn.call(null, arg1);
    });
  case 3:
    return process.nextTick(function afterTickTwo() {
      fn.call(null, arg1, arg2);
    });
  case 4:
    return process.nextTick(function afterTickThree() {
      fn.call(null, arg1, arg2, arg3);
    });
  default:
    args = new Array(len - 1);
    i = 0;
    while (i < args.length) {
      args[i++] = arguments[i];
    }
    return process.nextTick(function afterTick() {
      fn.apply(null, args);
    });
  }
}


/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(30)))

/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

// based on the aes implimentation in triple sec
// https://github.com/keybase/triplesec
// which is in turn based on the one from crypto-js
// https://code.google.com/p/crypto-js/

var Buffer = __webpack_require__(6).Buffer

function asUInt32Array (buf) {
  if (!Buffer.isBuffer(buf)) buf = Buffer.from(buf)

  var len = (buf.length / 4) | 0
  var out = new Array(len)

  for (var i = 0; i < len; i++) {
    out[i] = buf.readUInt32BE(i * 4)
  }

  return out
}

function scrubVec (v) {
  for (var i = 0; i < v.length; v++) {
    v[i] = 0
  }
}

function cryptBlock (M, keySchedule, SUB_MIX, SBOX, nRounds) {
  var SUB_MIX0 = SUB_MIX[0]
  var SUB_MIX1 = SUB_MIX[1]
  var SUB_MIX2 = SUB_MIX[2]
  var SUB_MIX3 = SUB_MIX[3]

  var s0 = M[0] ^ keySchedule[0]
  var s1 = M[1] ^ keySchedule[1]
  var s2 = M[2] ^ keySchedule[2]
  var s3 = M[3] ^ keySchedule[3]
  var t0, t1, t2, t3
  var ksRow = 4

  for (var round = 1; round < nRounds; round++) {
    t0 = SUB_MIX0[s0 >>> 24] ^ SUB_MIX1[(s1 >>> 16) & 0xff] ^ SUB_MIX2[(s2 >>> 8) & 0xff] ^ SUB_MIX3[s3 & 0xff] ^ keySchedule[ksRow++]
    t1 = SUB_MIX0[s1 >>> 24] ^ SUB_MIX1[(s2 >>> 16) & 0xff] ^ SUB_MIX2[(s3 >>> 8) & 0xff] ^ SUB_MIX3[s0 & 0xff] ^ keySchedule[ksRow++]
    t2 = SUB_MIX0[s2 >>> 24] ^ SUB_MIX1[(s3 >>> 16) & 0xff] ^ SUB_MIX2[(s0 >>> 8) & 0xff] ^ SUB_MIX3[s1 & 0xff] ^ keySchedule[ksRow++]
    t3 = SUB_MIX0[s3 >>> 24] ^ SUB_MIX1[(s0 >>> 16) & 0xff] ^ SUB_MIX2[(s1 >>> 8) & 0xff] ^ SUB_MIX3[s2 & 0xff] ^ keySchedule[ksRow++]
    s0 = t0
    s1 = t1
    s2 = t2
    s3 = t3
  }

  t0 = ((SBOX[s0 >>> 24] << 24) | (SBOX[(s1 >>> 16) & 0xff] << 16) | (SBOX[(s2 >>> 8) & 0xff] << 8) | SBOX[s3 & 0xff]) ^ keySchedule[ksRow++]
  t1 = ((SBOX[s1 >>> 24] << 24) | (SBOX[(s2 >>> 16) & 0xff] << 16) | (SBOX[(s3 >>> 8) & 0xff] << 8) | SBOX[s0 & 0xff]) ^ keySchedule[ksRow++]
  t2 = ((SBOX[s2 >>> 24] << 24) | (SBOX[(s3 >>> 16) & 0xff] << 16) | (SBOX[(s0 >>> 8) & 0xff] << 8) | SBOX[s1 & 0xff]) ^ keySchedule[ksRow++]
  t3 = ((SBOX[s3 >>> 24] << 24) | (SBOX[(s0 >>> 16) & 0xff] << 16) | (SBOX[(s1 >>> 8) & 0xff] << 8) | SBOX[s2 & 0xff]) ^ keySchedule[ksRow++]
  t0 = t0 >>> 0
  t1 = t1 >>> 0
  t2 = t2 >>> 0
  t3 = t3 >>> 0

  return [t0, t1, t2, t3]
}

// AES constants
var RCON = [0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1b, 0x36]
var G = (function () {
  // Compute double table
  var d = new Array(256)
  for (var j = 0; j < 256; j++) {
    if (j < 128) {
      d[j] = j << 1
    } else {
      d[j] = (j << 1) ^ 0x11b
    }
  }

  var SBOX = []
  var INV_SBOX = []
  var SUB_MIX = [[], [], [], []]
  var INV_SUB_MIX = [[], [], [], []]

  // Walk GF(2^8)
  var x = 0
  var xi = 0
  for (var i = 0; i < 256; ++i) {
    // Compute sbox
    var sx = xi ^ (xi << 1) ^ (xi << 2) ^ (xi << 3) ^ (xi << 4)
    sx = (sx >>> 8) ^ (sx & 0xff) ^ 0x63
    SBOX[x] = sx
    INV_SBOX[sx] = x

    // Compute multiplication
    var x2 = d[x]
    var x4 = d[x2]
    var x8 = d[x4]

    // Compute sub bytes, mix columns tables
    var t = (d[sx] * 0x101) ^ (sx * 0x1010100)
    SUB_MIX[0][x] = (t << 24) | (t >>> 8)
    SUB_MIX[1][x] = (t << 16) | (t >>> 16)
    SUB_MIX[2][x] = (t << 8) | (t >>> 24)
    SUB_MIX[3][x] = t

    // Compute inv sub bytes, inv mix columns tables
    t = (x8 * 0x1010101) ^ (x4 * 0x10001) ^ (x2 * 0x101) ^ (x * 0x1010100)
    INV_SUB_MIX[0][sx] = (t << 24) | (t >>> 8)
    INV_SUB_MIX[1][sx] = (t << 16) | (t >>> 16)
    INV_SUB_MIX[2][sx] = (t << 8) | (t >>> 24)
    INV_SUB_MIX[3][sx] = t

    if (x === 0) {
      x = xi = 1
    } else {
      x = x2 ^ d[d[d[x8 ^ x2]]]
      xi ^= d[d[xi]]
    }
  }

  return {
    SBOX: SBOX,
    INV_SBOX: INV_SBOX,
    SUB_MIX: SUB_MIX,
    INV_SUB_MIX: INV_SUB_MIX
  }
})()

function AES (key) {
  this._key = asUInt32Array(key)
  this._reset()
}

AES.blockSize = 4 * 4
AES.keySize = 256 / 8
AES.prototype.blockSize = AES.blockSize
AES.prototype.keySize = AES.keySize
AES.prototype._reset = function () {
  var keyWords = this._key
  var keySize = keyWords.length
  var nRounds = keySize + 6
  var ksRows = (nRounds + 1) * 4

  var keySchedule = []
  for (var k = 0; k < keySize; k++) {
    keySchedule[k] = keyWords[k]
  }

  for (k = keySize; k < ksRows; k++) {
    var t = keySchedule[k - 1]

    if (k % keySize === 0) {
      t = (t << 8) | (t >>> 24)
      t =
        (G.SBOX[t >>> 24] << 24) |
        (G.SBOX[(t >>> 16) & 0xff] << 16) |
        (G.SBOX[(t >>> 8) & 0xff] << 8) |
        (G.SBOX[t & 0xff])

      t ^= RCON[(k / keySize) | 0] << 24
    } else if (keySize > 6 && k % keySize === 4) {
      t =
        (G.SBOX[t >>> 24] << 24) |
        (G.SBOX[(t >>> 16) & 0xff] << 16) |
        (G.SBOX[(t >>> 8) & 0xff] << 8) |
        (G.SBOX[t & 0xff])
    }

    keySchedule[k] = keySchedule[k - keySize] ^ t
  }

  var invKeySchedule = []
  for (var ik = 0; ik < ksRows; ik++) {
    var ksR = ksRows - ik
    var tt = keySchedule[ksR - (ik % 4 ? 0 : 4)]

    if (ik < 4 || ksR <= 4) {
      invKeySchedule[ik] = tt
    } else {
      invKeySchedule[ik] =
        G.INV_SUB_MIX[0][G.SBOX[tt >>> 24]] ^
        G.INV_SUB_MIX[1][G.SBOX[(tt >>> 16) & 0xff]] ^
        G.INV_SUB_MIX[2][G.SBOX[(tt >>> 8) & 0xff]] ^
        G.INV_SUB_MIX[3][G.SBOX[tt & 0xff]]
    }
  }

  this._nRounds = nRounds
  this._keySchedule = keySchedule
  this._invKeySchedule = invKeySchedule
}

AES.prototype.encryptBlockRaw = function (M) {
  M = asUInt32Array(M)
  return cryptBlock(M, this._keySchedule, G.SUB_MIX, G.SBOX, this._nRounds)
}

AES.prototype.encryptBlock = function (M) {
  var out = this.encryptBlockRaw(M)
  var buf = Buffer.allocUnsafe(16)
  buf.writeUInt32BE(out[0], 0)
  buf.writeUInt32BE(out[1], 4)
  buf.writeUInt32BE(out[2], 8)
  buf.writeUInt32BE(out[3], 12)
  return buf
}

AES.prototype.decryptBlock = function (M) {
  M = asUInt32Array(M)

  // swap
  var m1 = M[1]
  M[1] = M[3]
  M[3] = m1

  var out = cryptBlock(M, this._invKeySchedule, G.INV_SUB_MIX, G.INV_SBOX, this._nRounds)
  var buf = Buffer.allocUnsafe(16)
  buf.writeUInt32BE(out[0], 0)
  buf.writeUInt32BE(out[3], 4)
  buf.writeUInt32BE(out[2], 8)
  buf.writeUInt32BE(out[1], 12)
  return buf
}

AES.prototype.scrub = function () {
  scrubVec(this._keySchedule)
  scrubVec(this._invKeySchedule)
  scrubVec(this._key)
}

module.exports.AES = AES


/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

var Buffer = __webpack_require__(6).Buffer
var MD5 = __webpack_require__(116)

/* eslint-disable camelcase */
function EVP_BytesToKey (password, salt, keyBits, ivLen) {
  if (!Buffer.isBuffer(password)) password = Buffer.from(password, 'binary')
  if (salt) {
    if (!Buffer.isBuffer(salt)) salt = Buffer.from(salt, 'binary')
    if (salt.length !== 8) throw new RangeError('salt should be Buffer with 8 byte length')
  }

  var keyLen = keyBits / 8
  var key = Buffer.alloc(keyLen)
  var iv = Buffer.alloc(ivLen || 0)
  var tmp = Buffer.alloc(0)

  while (keyLen > 0 || ivLen > 0) {
    var hash = new MD5()
    hash.update(tmp)
    hash.update(password)
    if (salt) hash.update(salt)
    tmp = hash.digest()

    var used = 0

    if (keyLen > 0) {
      var keyStart = key.length - keyLen
      used = Math.min(keyLen, tmp.length)
      tmp.copy(key, keyStart, 0, used)
      keyLen -= used
    }

    if (used < tmp.length && ivLen > 0) {
      var ivStart = iv.length - ivLen
      var length = Math.min(ivLen, tmp.length - used)
      tmp.copy(iv, ivStart, used, used + length)
      ivLen -= length
    }
  }

  tmp.fill(0)
  return { key: key, iv: iv }
}

module.exports = EVP_BytesToKey


/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var curve = exports;

curve.base = __webpack_require__(463);
curve.short = __webpack_require__(464);
curve.mont = __webpack_require__(465);
curve.edwards = __webpack_require__(466);


/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {var asn1 = __webpack_require__(482)
var aesid = __webpack_require__(494)
var fixProc = __webpack_require__(495)
var ciphers = __webpack_require__(124)
var compat = __webpack_require__(175)
module.exports = parseKeys

function parseKeys (buffer) {
  var password
  if (typeof buffer === 'object' && !Buffer.isBuffer(buffer)) {
    password = buffer.passphrase
    buffer = buffer.key
  }
  if (typeof buffer === 'string') {
    buffer = new Buffer(buffer)
  }

  var stripped = fixProc(buffer, password)

  var type = stripped.tag
  var data = stripped.data
  var subtype, ndata
  switch (type) {
    case 'CERTIFICATE':
      ndata = asn1.certificate.decode(data, 'der').tbsCertificate.subjectPublicKeyInfo
      // falls through
    case 'PUBLIC KEY':
      if (!ndata) {
        ndata = asn1.PublicKey.decode(data, 'der')
      }
      subtype = ndata.algorithm.algorithm.join('.')
      switch (subtype) {
        case '1.2.840.113549.1.1.1':
          return asn1.RSAPublicKey.decode(ndata.subjectPublicKey.data, 'der')
        case '1.2.840.10045.2.1':
          ndata.subjectPrivateKey = ndata.subjectPublicKey
          return {
            type: 'ec',
            data: ndata
          }
        case '1.2.840.10040.4.1':
          ndata.algorithm.params.pub_key = asn1.DSAparam.decode(ndata.subjectPublicKey.data, 'der')
          return {
            type: 'dsa',
            data: ndata.algorithm.params
          }
        default: throw new Error('unknown key id ' + subtype)
      }
      throw new Error('unknown key type ' + type)
    case 'ENCRYPTED PRIVATE KEY':
      data = asn1.EncryptedPrivateKey.decode(data, 'der')
      data = decrypt(data, password)
      // falls through
    case 'PRIVATE KEY':
      ndata = asn1.PrivateKey.decode(data, 'der')
      subtype = ndata.algorithm.algorithm.join('.')
      switch (subtype) {
        case '1.2.840.113549.1.1.1':
          return asn1.RSAPrivateKey.decode(ndata.subjectPrivateKey, 'der')
        case '1.2.840.10045.2.1':
          return {
            curve: ndata.algorithm.curve,
            privateKey: asn1.ECPrivateKey.decode(ndata.subjectPrivateKey, 'der').privateKey
          }
        case '1.2.840.10040.4.1':
          ndata.algorithm.params.priv_key = asn1.DSAparam.decode(ndata.subjectPrivateKey, 'der')
          return {
            type: 'dsa',
            params: ndata.algorithm.params
          }
        default: throw new Error('unknown key id ' + subtype)
      }
      throw new Error('unknown key type ' + type)
    case 'RSA PUBLIC KEY':
      return asn1.RSAPublicKey.decode(data, 'der')
    case 'RSA PRIVATE KEY':
      return asn1.RSAPrivateKey.decode(data, 'der')
    case 'DSA PRIVATE KEY':
      return {
        type: 'dsa',
        params: asn1.DSAPrivateKey.decode(data, 'der')
      }
    case 'EC PRIVATE KEY':
      data = asn1.ECPrivateKey.decode(data, 'der')
      return {
        curve: data.parameters.value,
        privateKey: data.privateKey
      }
    default: throw new Error('unknown key type ' + type)
  }
}
parseKeys.signature = asn1.signature
function decrypt (data, password) {
  var salt = data.algorithm.decrypt.kde.kdeparams.salt
  var iters = parseInt(data.algorithm.decrypt.kde.kdeparams.iters.toString(), 10)
  var algo = aesid[data.algorithm.decrypt.cipher.algo.join('.')]
  var iv = data.algorithm.decrypt.cipher.iv
  var cipherText = data.subjectPrivateKey
  var keylen = parseInt(algo.split('-')[1], 10) / 8
  var key = compat.pbkdf2Sync(password, salt, iters, keylen)
  var cipher = ciphers.createDecipheriv(algo, key, iv)
  var out = []
  out.push(cipher.update(cipherText))
  out.push(cipher.final())
  return Buffer.concat(out)
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(8).Buffer))

/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(5);
var document = __webpack_require__(3).document;
// typeof document.createElement is 'object' in old IE
var is = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
  return is ? document.createElement(it) : {};
};


/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(3);
var core = __webpack_require__(26);
var LIBRARY = __webpack_require__(40);
var wksExt = __webpack_require__(129);
var defineProperty = __webpack_require__(10).f;
module.exports = function (name) {
  var $Symbol = core.Symbol || (core.Symbol = LIBRARY ? {} : global.Symbol || {});
  if (name.charAt(0) != '_' && !(name in $Symbol)) defineProperty($Symbol, name, { value: wksExt.f(name) });
};


/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

var shared = __webpack_require__(70)('keys');
var uid = __webpack_require__(44);
module.exports = function (key) {
  return shared[key] || (shared[key] = uid(key));
};


/***/ }),
/* 93 */
/***/ (function(module, exports) {

// IE 8- don't enum bug keys
module.exports = (
  'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
).split(',');


/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

var document = __webpack_require__(3).document;
module.exports = document && document.documentElement;


/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

// Works with __proto__ only. Old v8 can't work with null proto objects.
/* eslint-disable no-proto */
var isObject = __webpack_require__(5);
var anObject = __webpack_require__(2);
var check = function (O, proto) {
  anObject(O);
  if (!isObject(proto) && proto !== null) throw TypeError(proto + ": can't set as prototype!");
};
module.exports = {
  set: Object.setPrototypeOf || ('__proto__' in {} ? // eslint-disable-line
    function (test, buggy, set) {
      try {
        set = __webpack_require__(27)(Function.call, __webpack_require__(22).f(Object.prototype, '__proto__').set, 2);
        set(test, []);
        buggy = !(test instanceof Array);
      } catch (e) { buggy = true; }
      return function setPrototypeOf(O, proto) {
        check(O, proto);
        if (buggy) O.__proto__ = proto;
        else set(O, proto);
        return O;
      };
    }({}, false) : undefined),
  check: check
};


/***/ }),
/* 96 */
/***/ (function(module, exports) {

module.exports = '\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003' +
  '\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';


/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(5);
var setPrototypeOf = __webpack_require__(95).set;
module.exports = function (that, target, C) {
  var S = target.constructor;
  var P;
  if (S !== C && typeof S == 'function' && (P = S.prototype) !== C.prototype && isObject(P) && setPrototypeOf) {
    setPrototypeOf(that, P);
  } return that;
};


/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var toInteger = __webpack_require__(33);
var defined = __webpack_require__(32);

module.exports = function repeat(count) {
  var str = String(defined(this));
  var res = '';
  var n = toInteger(count);
  if (n < 0 || n == Infinity) throw RangeError("Count can't be negative");
  for (;n > 0; (n >>>= 1) && (str += str)) if (n & 1) res += str;
  return res;
};


/***/ }),
/* 99 */
/***/ (function(module, exports) {

// 20.2.2.28 Math.sign(x)
module.exports = Math.sign || function sign(x) {
  // eslint-disable-next-line no-self-compare
  return (x = +x) == 0 || x != x ? x : x < 0 ? -1 : 1;
};


/***/ }),
/* 100 */
/***/ (function(module, exports) {

// 20.2.2.14 Math.expm1(x)
var $expm1 = Math.expm1;
module.exports = (!$expm1
  // Old FF bug
  || $expm1(10) > 22025.465794806719 || $expm1(10) < 22025.4657948067165168
  // Tor Browser bug
  || $expm1(-2e-17) != -2e-17
) ? function expm1(x) {
  return (x = +x) == 0 ? x : x > -1e-6 && x < 1e-6 ? x + x * x / 2 : Math.exp(x) - 1;
} : $expm1;


/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(33);
var defined = __webpack_require__(32);
// true  -> String#at
// false -> String#codePointAt
module.exports = function (TO_STRING) {
  return function (that, pos) {
    var s = String(defined(that));
    var i = toInteger(pos);
    var l = s.length;
    var a, b;
    if (i < 0 || i >= l) return TO_STRING ? '' : undefined;
    a = s.charCodeAt(i);
    return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
      ? TO_STRING ? s.charAt(i) : a
      : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
  };
};


/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var LIBRARY = __webpack_require__(40);
var $export = __webpack_require__(0);
var redefine = __webpack_require__(18);
var hide = __webpack_require__(17);
var Iterators = __webpack_require__(56);
var $iterCreate = __webpack_require__(103);
var setToStringTag = __webpack_require__(54);
var getPrototypeOf = __webpack_require__(23);
var ITERATOR = __webpack_require__(7)('iterator');
var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
var FF_ITERATOR = '@@iterator';
var KEYS = 'keys';
var VALUES = 'values';

var returnThis = function () { return this; };

module.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
  $iterCreate(Constructor, NAME, next);
  var getMethod = function (kind) {
    if (!BUGGY && kind in proto) return proto[kind];
    switch (kind) {
      case KEYS: return function keys() { return new Constructor(this, kind); };
      case VALUES: return function values() { return new Constructor(this, kind); };
    } return function entries() { return new Constructor(this, kind); };
  };
  var TAG = NAME + ' Iterator';
  var DEF_VALUES = DEFAULT == VALUES;
  var VALUES_BUG = false;
  var proto = Base.prototype;
  var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
  var $default = $native || getMethod(DEFAULT);
  var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
  var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
  var methods, key, IteratorPrototype;
  // Fix native
  if ($anyNative) {
    IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));
    if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
      // Set @@toStringTag to native iterators
      setToStringTag(IteratorPrototype, TAG, true);
      // fix for some old engines
      if (!LIBRARY && typeof IteratorPrototype[ITERATOR] != 'function') hide(IteratorPrototype, ITERATOR, returnThis);
    }
  }
  // fix Array#{values, @@iterator}.name in V8 / FF
  if (DEF_VALUES && $native && $native.name !== VALUES) {
    VALUES_BUG = true;
    $default = function values() { return $native.call(this); };
  }
  // Define iterator
  if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
    hide(proto, ITERATOR, $default);
  }
  // Plug for library
  Iterators[NAME] = $default;
  Iterators[TAG] = returnThis;
  if (DEFAULT) {
    methods = {
      values: DEF_VALUES ? $default : getMethod(VALUES),
      keys: IS_SET ? $default : getMethod(KEYS),
      entries: $entries
    };
    if (FORCED) for (key in methods) {
      if (!(key in proto)) redefine(proto, key, methods[key]);
    } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
  }
  return methods;
};


/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var create = __webpack_require__(47);
var descriptor = __webpack_require__(43);
var setToStringTag = __webpack_require__(54);
var IteratorPrototype = {};

// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
__webpack_require__(17)(IteratorPrototype, __webpack_require__(7)('iterator'), function () { return this; });

module.exports = function (Constructor, NAME, next) {
  Constructor.prototype = create(IteratorPrototype, { next: descriptor(1, next) });
  setToStringTag(Constructor, NAME + ' Iterator');
};


/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

// helper for String#{startsWith, endsWith, includes}
var isRegExp = __webpack_require__(74);
var defined = __webpack_require__(32);

module.exports = function (that, searchString, NAME) {
  if (isRegExp(searchString)) throw TypeError('String#' + NAME + " doesn't accept regex!");
  return String(defined(that));
};


/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

var MATCH = __webpack_require__(7)('match');
module.exports = function (KEY) {
  var re = /./;
  try {
    '/./'[KEY](re);
  } catch (e) {
    try {
      re[MATCH] = false;
      return !'/./'[KEY](re);
    } catch (f) { /* empty */ }
  } return true;
};


/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

// check on default Array iterator
var Iterators = __webpack_require__(56);
var ITERATOR = __webpack_require__(7)('iterator');
var ArrayProto = Array.prototype;

module.exports = function (it) {
  return it !== undefined && (Iterators.Array === it || ArrayProto[ITERATOR] === it);
};


/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $defineProperty = __webpack_require__(10);
var createDesc = __webpack_require__(43);

module.exports = function (object, index, value) {
  if (index in object) $defineProperty.f(object, index, createDesc(0, value));
  else object[index] = value;
};


/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

var classof = __webpack_require__(62);
var ITERATOR = __webpack_require__(7)('iterator');
var Iterators = __webpack_require__(56);
module.exports = __webpack_require__(26).getIteratorMethod = function (it) {
  if (it != undefined) return it[ITERATOR]
    || it['@@iterator']
    || Iterators[classof(it)];
};


/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

// 9.4.2.3 ArraySpeciesCreate(originalArray, length)
var speciesConstructor = __webpack_require__(294);

module.exports = function (original, length) {
  return new (speciesConstructor(original))(length);
};


/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// 22.1.3.6 Array.prototype.fill(value, start = 0, end = this.length)

var toObject = __webpack_require__(13);
var toAbsoluteIndex = __webpack_require__(46);
var toLength = __webpack_require__(11);
module.exports = function fill(value /* , start = 0, end = @length */) {
  var O = toObject(this);
  var length = toLength(O.length);
  var aLen = arguments.length;
  var index = toAbsoluteIndex(aLen > 1 ? arguments[1] : undefined, length);
  var end = aLen > 2 ? arguments[2] : undefined;
  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);
  while (endPos > index) O[index++] = value;
  return O;
};


/***/ }),
/* 111 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var addToUnscopables = __webpack_require__(41);
var step = __webpack_require__(145);
var Iterators = __webpack_require__(56);
var toIObject = __webpack_require__(21);

// 22.1.3.4 Array.prototype.entries()
// 22.1.3.13 Array.prototype.keys()
// 22.1.3.29 Array.prototype.values()
// 22.1.3.30 Array.prototype[@@iterator]()
module.exports = __webpack_require__(102)(Array, 'Array', function (iterated, kind) {
  this._t = toIObject(iterated); // target
  this._i = 0;                   // next index
  this._k = kind;                // kind
// 22.1.5.2.1 %ArrayIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var kind = this._k;
  var index = this._i++;
  if (!O || index >= O.length) {
    this._t = undefined;
    return step(1);
  }
  if (kind == 'keys') return step(0, index);
  if (kind == 'values') return step(0, O[index]);
  return step(0, [index, O[index]]);
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)
Iterators.Arguments = Iterators.Array;

addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');


/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

var ctx = __webpack_require__(27);
var invoke = __webpack_require__(135);
var html = __webpack_require__(94);
var cel = __webpack_require__(90);
var global = __webpack_require__(3);
var process = global.process;
var setTask = global.setImmediate;
var clearTask = global.clearImmediate;
var MessageChannel = global.MessageChannel;
var Dispatch = global.Dispatch;
var counter = 0;
var queue = {};
var ONREADYSTATECHANGE = 'onreadystatechange';
var defer, channel, port;
var run = function () {
  var id = +this;
  // eslint-disable-next-line no-prototype-builtins
  if (queue.hasOwnProperty(id)) {
    var fn = queue[id];
    delete queue[id];
    fn();
  }
};
var listener = function (event) {
  run.call(event.data);
};
// Node.js 0.9+ & IE10+ has setImmediate, otherwise:
if (!setTask || !clearTask) {
  setTask = function setImmediate(fn) {
    var args = [];
    var i = 1;
    while (arguments.length > i) args.push(arguments[i++]);
    queue[++counter] = function () {
      // eslint-disable-next-line no-new-func
      invoke(typeof fn == 'function' ? fn : Function(fn), args);
    };
    defer(counter);
    return counter;
  };
  clearTask = function clearImmediate(id) {
    delete queue[id];
  };
  // Node.js 0.8-
  if (__webpack_require__(28)(process) == 'process') {
    defer = function (id) {
      process.nextTick(ctx(run, id, 1));
    };
  // Sphere (JS game engine) Dispatch API
  } else if (Dispatch && Dispatch.now) {
    defer = function (id) {
      Dispatch.now(ctx(run, id, 1));
    };
  // Browsers with MessageChannel, includes WebWorkers
  } else if (MessageChannel) {
    channel = new MessageChannel();
    port = channel.port2;
    channel.port1.onmessage = listener;
    defer = ctx(port.postMessage, port, 1);
  // Browsers with postMessage, skip WebWorkers
  // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
  } else if (global.addEventListener && typeof postMessage == 'function' && !global.importScripts) {
    defer = function (id) {
      global.postMessage(id + '', '*');
    };
    global.addEventListener('message', listener, false);
  // IE8-
  } else if (ONREADYSTATECHANGE in cel('script')) {
    defer = function (id) {
      html.appendChild(cel('script'))[ONREADYSTATECHANGE] = function () {
        html.removeChild(this);
        run.call(id);
      };
    };
  // Rest old browsers
  } else {
    defer = function (id) {
      setTimeout(ctx(run, id, 1), 0);
    };
  }
}
module.exports = {
  set: setTask,
  clear: clearTask
};


/***/ }),
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(3);
var macrotask = __webpack_require__(112).set;
var Observer = global.MutationObserver || global.WebKitMutationObserver;
var process = global.process;
var Promise = global.Promise;
var isNode = __webpack_require__(28)(process) == 'process';

module.exports = function () {
  var head, last, notify;

  var flush = function () {
    var parent, fn;
    if (isNode && (parent = process.domain)) parent.exit();
    while (head) {
      fn = head.fn;
      head = head.next;
      try {
        fn();
      } catch (e) {
        if (head) notify();
        else last = undefined;
        throw e;
      }
    } last = undefined;
    if (parent) parent.enter();
  };

  // Node.js
  if (isNode) {
    notify = function () {
      process.nextTick(flush);
    };
  // browsers with MutationObserver, except iOS Safari - https://github.com/zloirock/core-js/issues/339
  } else if (Observer && !(global.navigator && global.navigator.standalone)) {
    var toggle = true;
    var node = document.createTextNode('');
    new Observer(flush).observe(node, { characterData: true }); // eslint-disable-line no-new
    notify = function () {
      node.data = toggle = !toggle;
    };
  // environments with maybe non-completely correct, but existent Promise
  } else if (Promise && Promise.resolve) {
    // Promise.resolve without an argument throws an error in LG WebOS 2
    var promise = Promise.resolve(undefined);
    notify = function () {
      promise.then(flush);
    };
  // for other environments - macrotask based on:
  // - setImmediate
  // - MessageChannel
  // - window.postMessag
  // - onreadystatechange
  // - setTimeout
  } else {
    notify = function () {
      // strange IE + webpack dev server bug - use .call(global)
      macrotask.call(global, flush);
    };
  }

  return function (fn) {
    var task = { fn: fn, next: undefined };
    if (last) last.next = task;
    if (!head) {
      head = task;
      notify();
    } last = task;
  };
};


/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// 25.4.1.5 NewPromiseCapability(C)
var aFunction = __webpack_require__(14);

function PromiseCapability(C) {
  var resolve, reject;
  this.promise = new C(function ($$resolve, $$reject) {
    if (resolve !== undefined || reject !== undefined) throw TypeError('Bad Promise constructor');
    resolve = $$resolve;
    reject = $$reject;
  });
  this.resolve = aFunction(resolve);
  this.reject = aFunction(reject);
}

module.exports.f = function (C) {
  return new PromiseCapability(C);
};


/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var global = __webpack_require__(3);
var DESCRIPTORS = __webpack_require__(9);
var LIBRARY = __webpack_require__(40);
var $typed = __webpack_require__(81);
var hide = __webpack_require__(17);
var redefineAll = __webpack_require__(52);
var fails = __webpack_require__(4);
var anInstance = __webpack_require__(50);
var toInteger = __webpack_require__(33);
var toLength = __webpack_require__(11);
var toIndex = __webpack_require__(154);
var gOPN = __webpack_require__(48).f;
var dP = __webpack_require__(10).f;
var arrayFill = __webpack_require__(110);
var setToStringTag = __webpack_require__(54);
var ARRAY_BUFFER = 'ArrayBuffer';
var DATA_VIEW = 'DataView';
var PROTOTYPE = 'prototype';
var WRONG_LENGTH = 'Wrong length!';
var WRONG_INDEX = 'Wrong index!';
var $ArrayBuffer = global[ARRAY_BUFFER];
var $DataView = global[DATA_VIEW];
var Math = global.Math;
var RangeError = global.RangeError;
// eslint-disable-next-line no-shadow-restricted-names
var Infinity = global.Infinity;
var BaseBuffer = $ArrayBuffer;
var abs = Math.abs;
var pow = Math.pow;
var floor = Math.floor;
var log = Math.log;
var LN2 = Math.LN2;
var BUFFER = 'buffer';
var BYTE_LENGTH = 'byteLength';
var BYTE_OFFSET = 'byteOffset';
var $BUFFER = DESCRIPTORS ? '_b' : BUFFER;
var $LENGTH = DESCRIPTORS ? '_l' : BYTE_LENGTH;
var $OFFSET = DESCRIPTORS ? '_o' : BYTE_OFFSET;

// IEEE754 conversions based on https://github.com/feross/ieee754
function packIEEE754(value, mLen, nBytes) {
  var buffer = new Array(nBytes);
  var eLen = nBytes * 8 - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var rt = mLen === 23 ? pow(2, -24) - pow(2, -77) : 0;
  var i = 0;
  var s = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
  var e, m, c;
  value = abs(value);
  // eslint-disable-next-line no-self-compare
  if (value != value || value === Infinity) {
    // eslint-disable-next-line no-self-compare
    m = value != value ? 1 : 0;
    e = eMax;
  } else {
    e = floor(log(value) / LN2);
    if (value * (c = pow(2, -e)) < 1) {
      e--;
      c *= 2;
    }
    if (e + eBias >= 1) {
      value += rt / c;
    } else {
      value += rt * pow(2, 1 - eBias);
    }
    if (value * c >= 2) {
      e++;
      c /= 2;
    }
    if (e + eBias >= eMax) {
      m = 0;
      e = eMax;
    } else if (e + eBias >= 1) {
      m = (value * c - 1) * pow(2, mLen);
      e = e + eBias;
    } else {
      m = value * pow(2, eBias - 1) * pow(2, mLen);
      e = 0;
    }
  }
  for (; mLen >= 8; buffer[i++] = m & 255, m /= 256, mLen -= 8);
  e = e << mLen | m;
  eLen += mLen;
  for (; eLen > 0; buffer[i++] = e & 255, e /= 256, eLen -= 8);
  buffer[--i] |= s * 128;
  return buffer;
}
function unpackIEEE754(buffer, mLen, nBytes) {
  var eLen = nBytes * 8 - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var nBits = eLen - 7;
  var i = nBytes - 1;
  var s = buffer[i--];
  var e = s & 127;
  var m;
  s >>= 7;
  for (; nBits > 0; e = e * 256 + buffer[i], i--, nBits -= 8);
  m = e & (1 << -nBits) - 1;
  e >>= -nBits;
  nBits += mLen;
  for (; nBits > 0; m = m * 256 + buffer[i], i--, nBits -= 8);
  if (e === 0) {
    e = 1 - eBias;
  } else if (e === eMax) {
    return m ? NaN : s ? -Infinity : Infinity;
  } else {
    m = m + pow(2, mLen);
    e = e - eBias;
  } return (s ? -1 : 1) * m * pow(2, e - mLen);
}

function unpackI32(bytes) {
  return bytes[3] << 24 | bytes[2] << 16 | bytes[1] << 8 | bytes[0];
}
function packI8(it) {
  return [it & 0xff];
}
function packI16(it) {
  return [it & 0xff, it >> 8 & 0xff];
}
function packI32(it) {
  return [it & 0xff, it >> 8 & 0xff, it >> 16 & 0xff, it >> 24 & 0xff];
}
function packF64(it) {
  return packIEEE754(it, 52, 8);
}
function packF32(it) {
  return packIEEE754(it, 23, 4);
}

function addGetter(C, key, internal) {
  dP(C[PROTOTYPE], key, { get: function () { return this[internal]; } });
}

function get(view, bytes, index, isLittleEndian) {
  var numIndex = +index;
  var intIndex = toIndex(numIndex);
  if (intIndex + bytes > view[$LENGTH]) throw RangeError(WRONG_INDEX);
  var store = view[$BUFFER]._b;
  var start = intIndex + view[$OFFSET];
  var pack = store.slice(start, start + bytes);
  return isLittleEndian ? pack : pack.reverse();
}
function set(view, bytes, index, conversion, value, isLittleEndian) {
  var numIndex = +index;
  var intIndex = toIndex(numIndex);
  if (intIndex + bytes > view[$LENGTH]) throw RangeError(WRONG_INDEX);
  var store = view[$BUFFER]._b;
  var start = intIndex + view[$OFFSET];
  var pack = conversion(+value);
  for (var i = 0; i < bytes; i++) store[start + i] = pack[isLittleEndian ? i : bytes - i - 1];
}

if (!$typed.ABV) {
  $ArrayBuffer = function ArrayBuffer(length) {
    anInstance(this, $ArrayBuffer, ARRAY_BUFFER);
    var byteLength = toIndex(length);
    this._b = arrayFill.call(new Array(byteLength), 0);
    this[$LENGTH] = byteLength;
  };

  $DataView = function DataView(buffer, byteOffset, byteLength) {
    anInstance(this, $DataView, DATA_VIEW);
    anInstance(buffer, $ArrayBuffer, DATA_VIEW);
    var bufferLength = buffer[$LENGTH];
    var offset = toInteger(byteOffset);
    if (offset < 0 || offset > bufferLength) throw RangeError('Wrong offset!');
    byteLength = byteLength === undefined ? bufferLength - offset : toLength(byteLength);
    if (offset + byteLength > bufferLength) throw RangeError(WRONG_LENGTH);
    this[$BUFFER] = buffer;
    this[$OFFSET] = offset;
    this[$LENGTH] = byteLength;
  };

  if (DESCRIPTORS) {
    addGetter($ArrayBuffer, BYTE_LENGTH, '_l');
    addGetter($DataView, BUFFER, '_b');
    addGetter($DataView, BYTE_LENGTH, '_l');
    addGetter($DataView, BYTE_OFFSET, '_o');
  }

  redefineAll($DataView[PROTOTYPE], {
    getInt8: function getInt8(byteOffset) {
      return get(this, 1, byteOffset)[0] << 24 >> 24;
    },
    getUint8: function getUint8(byteOffset) {
      return get(this, 1, byteOffset)[0];
    },
    getInt16: function getInt16(byteOffset /* , littleEndian */) {
      var bytes = get(this, 2, byteOffset, arguments[1]);
      return (bytes[1] << 8 | bytes[0]) << 16 >> 16;
    },
    getUint16: function getUint16(byteOffset /* , littleEndian */) {
      var bytes = get(this, 2, byteOffset, arguments[1]);
      return bytes[1] << 8 | bytes[0];
    },
    getInt32: function getInt32(byteOffset /* , littleEndian */) {
      return unpackI32(get(this, 4, byteOffset, arguments[1]));
    },
    getUint32: function getUint32(byteOffset /* , littleEndian */) {
      return unpackI32(get(this, 4, byteOffset, arguments[1])) >>> 0;
    },
    getFloat32: function getFloat32(byteOffset /* , littleEndian */) {
      return unpackIEEE754(get(this, 4, byteOffset, arguments[1]), 23, 4);
    },
    getFloat64: function getFloat64(byteOffset /* , littleEndian */) {
      return unpackIEEE754(get(this, 8, byteOffset, arguments[1]), 52, 8);
    },
    setInt8: function setInt8(byteOffset, value) {
      set(this, 1, byteOffset, packI8, value);
    },
    setUint8: function setUint8(byteOffset, value) {
      set(this, 1, byteOffset, packI8, value);
    },
    setInt16: function setInt16(byteOffset, value /* , littleEndian */) {
      set(this, 2, byteOffset, packI16, value, arguments[2]);
    },
    setUint16: function setUint16(byteOffset, value /* , littleEndian */) {
      set(this, 2, byteOffset, packI16, value, arguments[2]);
    },
    setInt32: function setInt32(byteOffset, value /* , littleEndian */) {
      set(this, 4, byteOffset, packI32, value, arguments[2]);
    },
    setUint32: function setUint32(byteOffset, value /* , littleEndian */) {
      set(this, 4, byteOffset, packI32, value, arguments[2]);
    },
    setFloat32: function setFloat32(byteOffset, value /* , littleEndian */) {
      set(this, 4, byteOffset, packF32, value, arguments[2]);
    },
    setFloat64: function setFloat64(byteOffset, value /* , littleEndian */) {
      set(this, 8, byteOffset, packF64, value, arguments[2]);
    }
  });
} else {
  if (!fails(function () {
    $ArrayBuffer(1);
  }) || !fails(function () {
    new $ArrayBuffer(-1); // eslint-disable-line no-new
  }) || fails(function () {
    new $ArrayBuffer(); // eslint-disable-line no-new
    new $ArrayBuffer(1.5); // eslint-disable-line no-new
    new $ArrayBuffer(NaN); // eslint-disable-line no-new
    return $ArrayBuffer.name != ARRAY_BUFFER;
  })) {
    $ArrayBuffer = function ArrayBuffer(length) {
      anInstance(this, $ArrayBuffer);
      return new BaseBuffer(toIndex(length));
    };
    var ArrayBufferProto = $ArrayBuffer[PROTOTYPE] = BaseBuffer[PROTOTYPE];
    for (var keys = gOPN(BaseBuffer), j = 0, key; keys.length > j;) {
      if (!((key = keys[j++]) in $ArrayBuffer)) hide($ArrayBuffer, key, BaseBuffer[key]);
    }
    if (!LIBRARY) ArrayBufferProto.constructor = $ArrayBuffer;
  }
  // iOS Safari 7.x bug
  var view = new $DataView(new $ArrayBuffer(2));
  var $setInt8 = $DataView[PROTOTYPE].setInt8;
  view.setInt8(0, 2147483648);
  view.setInt8(1, 2147483649);
  if (view.getInt8(0) || !view.getInt8(1)) redefineAll($DataView[PROTOTYPE], {
    setInt8: function setInt8(byteOffset, value) {
      $setInt8.call(this, byteOffset, value << 24 >> 24);
    },
    setUint8: function setUint8(byteOffset, value) {
      $setInt8.call(this, byteOffset, value << 24 >> 24);
    }
  }, true);
}
setToStringTag($ArrayBuffer, ARRAY_BUFFER);
setToStringTag($DataView, DATA_VIEW);
hide($DataView[PROTOTYPE], $typed.VIEW, true);
exports[ARRAY_BUFFER] = $ArrayBuffer;
exports[DATA_VIEW] = $DataView;


/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Buffer) {
var inherits = __webpack_require__(1)
var HashBase = __webpack_require__(165)

var ARRAY16 = new Array(16)

function MD5 () {
  HashBase.call(this, 64)

  // state
  this._a = 0x67452301
  this._b = 0xefcdab89
  this._c = 0x98badcfe
  this._d = 0x10325476
}

inherits(MD5, HashBase)

MD5.prototype._update = function () {
  var M = ARRAY16
  for (var i = 0; i < 16; ++i) M[i] = this._block.readInt32LE(i * 4)

  var a = this._a
  var b = this._b
  var c = this._c
  var d = this._d

  a = fnF(a, b, c, d, M[0], 0xd76aa478, 7)
  d = fnF(d, a, b, c, M[1], 0xe8c7b756, 12)
  c = fnF(c, d, a, b, M[2], 0x242070db, 17)
  b = fnF(b, c, d, a, M[3], 0xc1bdceee, 22)
  a = fnF(a, b, c, d, M[4], 0xf57c0faf, 7)
  d = fnF(d, a, b, c, M[5], 0x4787c62a, 12)
  c = fnF(c, d, a, b, M[6], 0xa8304613, 17)
  b = fnF(b, c, d, a, M[7], 0xfd469501, 22)
  a = fnF(a, b, c, d, M[8], 0x698098d8, 7)
  d = fnF(d, a, b, c, M[9], 0x8b44f7af, 12)
  c = fnF(c, d, a, b, M[10], 0xffff5bb1, 17)
  b = fnF(b, c, d, a, M[11], 0x895cd7be, 22)
  a = fnF(a, b, c, d, M[12], 0x6b901122, 7)
  d = fnF(d, a, b, c, M[13], 0xfd987193, 12)
  c = fnF(c, d, a, b, M[14], 0xa679438e, 17)
  b = fnF(b, c, d, a, M[15], 0x49b40821, 22)

  a = fnG(a, b, c, d, M[1], 0xf61e2562, 5)
  d = fnG(d, a, b, c, M[6], 0xc040b340, 9)
  c = fnG(c, d, a, b, M[11], 0x265e5a51, 14)
  b = fnG(b, c, d, a, M[0], 0xe9b6c7aa, 20)
  a = fnG(a, b, c, d, M[5], 0xd62f105d, 5)
  d = fnG(d, a, b, c, M[10], 0x02441453, 9)
  c = fnG(c, d, a, b, M[15], 0xd8a1e681, 14)
  b = fnG(b, c, d, a, M[4], 0xe7d3fbc8, 20)
  a = fnG(a, b, c, d, M[9], 0x21e1cde6, 5)
  d = fnG(d, a, b, c, M[14], 0xc33707d6, 9)
  c = fnG(c, d, a, b, M[3], 0xf4d50d87, 14)
  b = fnG(b, c, d, a, M[8], 0x455a14ed, 20)
  a = fnG(a, b, c, d, M[13], 0xa9e3e905, 5)
  d = fnG(d, a, b, c, M[2], 0xfcefa3f8, 9)
  c = fnG(c, d, a, b, M[7], 0x676f02d9, 14)
  b = fnG(b, c, d, a, M[12], 0x8d2a4c8a, 20)

  a = fnH(a, b, c, d, M[5], 0xfffa3942, 4)
  d = fnH(d, a, b, c, M[8], 0x8771f681, 11)
  c = fnH(c, d, a, b, M[11], 0x6d9d6122, 16)
  b = fnH(b, c, d, a, M[14], 0xfde5380c, 23)
  a = fnH(a, b, c, d, M[1], 0xa4beea44, 4)
  d = fnH(d, a, b, c, M[4], 0x4bdecfa9, 11)
  c = fnH(c, d, a, b, M[7], 0xf6bb4b60, 16)
  b = fnH(b, c, d, a, M[10], 0xbebfbc70, 23)
  a = fnH(a, b, c, d, M[13], 0x289b7ec6, 4)
  d = fnH(d, a, b, c, M[0], 0xeaa127fa, 11)
  c = fnH(c, d, a, b, M[3], 0xd4ef3085, 16)
  b = fnH(b, c, d, a, M[6], 0x04881d05, 23)
  a = fnH(a, b, c, d, M[9], 0xd9d4d039, 4)
  d = fnH(d, a, b, c, M[12], 0xe6db99e5, 11)
  c = fnH(c, d, a, b, M[15], 0x1fa27cf8, 16)
  b = fnH(b, c, d, a, M[2], 0xc4ac5665, 23)

  a = fnI(a, b, c, d, M[0], 0xf4292244, 6)
  d = fnI(d, a, b, c, M[7], 0x432aff97, 10)
  c = fnI(c, d, a, b, M[14], 0xab9423a7, 15)
  b = fnI(b, c, d, a, M[5], 0xfc93a039, 21)
  a = fnI(a, b, c, d, M[12], 0x655b59c3, 6)
  d = fnI(d, a, b, c, M[3], 0x8f0ccc92, 10)
  c = fnI(c, d, a, b, M[10], 0xffeff47d, 15)
  b = fnI(b, c, d, a, M[1], 0x85845dd1, 21)
  a = fnI(a, b, c, d, M[8], 0x6fa87e4f, 6)
  d = fnI(d, a, b, c, M[15], 0xfe2ce6e0, 10)
  c = fnI(c, d, a, b, M[6], 0xa3014314, 15)
  b = fnI(b, c, d, a, M[13], 0x4e0811a1, 21)
  a = fnI(a, b, c, d, M[4], 0xf7537e82, 6)
  d = fnI(d, a, b, c, M[11], 0xbd3af235, 10)
  c = fnI(c, d, a, b, M[2], 0x2ad7d2bb, 15)
  b = fnI(b, c, d, a, M[9], 0xeb86d391, 21)

  this._a = (this._a + a) | 0
  this._b = (this._b + b) | 0
  this._c = (this._c + c) | 0
  this._d = (this._d + d) | 0
}

MD5.prototype._digest = function () {
  // create padding and handle blocks
  this._block[this._blockOffset++] = 0x80
  if (this._blockOffset > 56) {
    this._block.fill(0, this._blockOffset, 64)
    this._update()
    this._blockOffset = 0
  }

  this._block.fill(0, this._blockOffset, 56)
  this._block.writeUInt32LE(this._length[0], 56)
  this._block.writeUInt32LE(this._length[1], 60)
  this._update()

  // produce result
  var buffer = new Buffer(16)
  buffer.writeInt32LE(this._a, 0)
  buffer.writeInt32LE(this._b, 4)
  buffer.writeInt32LE(this._c, 8)
  buffer.writeInt32LE(this._d, 12)
  return buffer
}

function rotl (x, n) {
  return (x << n) | (x >>> (32 - n))
}

function fnF (a, b, c, d, m, k, s) {
  return (rotl((a + ((b & c) | ((~b) & d)) + m + k) | 0, s) + b) | 0
}

function fnG (a, b, c, d, m, k, s) {
  return (rotl((a + ((b & d) | (c & (~d))) + m + k) | 0, s) + b) | 0
}

function fnH (a, b, c, d, m, k, s) {
  return (rotl((a + (b ^ c ^ d) + m + k) | 0, s) + b) | 0
}

function fnI (a, b, c, d, m, k, s) {
  return (rotl((a + ((c ^ (b | (~d)))) + m + k) | 0, s) + b) | 0
}

module.exports = MD5

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(8).Buffer))

/***/ }),
/* 117 */
/***/ (function(module, exports, __webpack_require__) {

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

module.exports = Stream;

var EE = __webpack_require__(63).EventEmitter;
var inherits = __webpack_require__(1);

inherits(Stream, EE);
Stream.Readable = __webpack_require__(118);
Stream.Writable = __webpack_require__(426);
Stream.Duplex = __webpack_require__(427);
Stream.Transform = __webpack_require__(428);
Stream.PassThrough = __webpack_require__(429);

// Backwards-compat with node 0.4.x
Stream.Stream = Stream;



// old-style streams.  Note that the pipe method (the only relevant
// part of this class) is overridden in the Readable class.

function Stream() {
  EE.call(this);
}

Stream.prototype.pipe = function(dest, options) {
  var source = this;

  function ondata(chunk) {
    if (dest.writable) {
      if (false === dest.write(chunk) && source.pause) {
        source.pause();
      }
    }
  }

  source.on('data', ondata);

  function ondrain() {
    if (source.readable && source.resume) {
      source.resume();
    }
  }

  dest.on('drain', ondrain);

  // If the 'end' option is not supplied, dest.end() will be called when
  // source gets the 'end' or 'close' events.  Only dest.end() once.
  if (!dest._isStdio && (!options || options.end !== false)) {
    source.on('end', onend);
    source.on('close', onclose);
  }

  var didOnEnd = false;
  function onend() {
    if (didOnEnd) return;
    didOnEnd = true;

    dest.end();
  }


  function onclose() {
    if (didOnEnd) return;
    didOnEnd = true;

    if (typeof dest.destroy === 'function') dest.destroy();
  }

  // don't leave dangling pipes when there are errors.
  function onerror(er) {
    cleanup();
    if (EE.listenerCount(this, 'error') === 0) {
      throw er; // Unhandled stream error in pipe.
    }
  }

  source.on('error', onerror);
  dest.on('error', onerror);

  // remove all the event listeners that were added.
  function cleanup() {
    source.removeListener('data', ondata);
    dest.removeListener('drain', ondrain);

    source.removeListener('end', onend);
    source.removeListener('close', onclose);

    source.removeListener('error', onerror);
    dest.removeListener('error', onerror);

    source.removeListener('end', cleanup);
    source.removeListener('close', cleanup);

    dest.removeListener('close', cleanup);
  }

  source.on('end', cleanup);
  source.on('close', cleanup);

  dest.on('close', cleanup);

  dest.emit('pipe', source);

  // Allow for unix-like usage: A.pipe(B).pipe(C)
  return dest;
};


/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(166);
exports.Stream = exports;
exports.Readable = exports;
exports.Writable = __webpack_require__(119);
exports.Duplex = __webpack_require__(53);
exports.Transform = __webpack_require__(169);
exports.PassThrough = __webpack_require__(425);


/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process, setImmediate, global) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// A bit simpler than readable streams.
// Implement an async ._write(chunk, encoding, cb), and it'll handle all
// the drain event emission and buffering.



/*<replacement>*/

var pna = __webpack_require__(85);
/*</replacement>*/

module.exports = Writable;

/* <replacement> */
function WriteReq(chunk, encoding, cb) {
  this.chunk = chunk;
  this.encoding = encoding;
  this.callback = cb;
  this.next = null;
}

// It seems a linked list but it is not
// there will be only 2 of these for each stream
function CorkedRequest(state) {
  var _this = this;

  this.next = null;
  this.entry = null;
  this.finish = function () {
    onCorkedFinish(_this, state);
  };
}
/* </replacement> */

/*<replacement>*/
var asyncWrite = !process.browser && ['v0.10', 'v0.9.'].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : pna.nextTick;
/*</replacement>*/

/*<replacement>*/
var Duplex;
/*</replacement>*/

Writable.WritableState = WritableState;

/*<replacement>*/
var util = __webpack_require__(65);
util.inherits = __webpack_require__(1);
/*</replacement>*/

/*<replacement>*/
var internalUtil = {
  deprecate: __webpack_require__(424)
};
/*</replacement>*/

/*<replacement>*/
var Stream = __webpack_require__(167);
/*</replacement>*/

/*<replacement>*/

var Buffer = __webpack_require__(6).Buffer;
var OurUint8Array = global.Uint8Array || function () {};
function _uint8ArrayToBuffer(chunk) {
  return Buffer.from(chunk);
}
function _isUint8Array(obj) {
  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
}

/*</replacement>*/

var destroyImpl = __webpack_require__(168);

util.inherits(Writable, Stream);

function nop() {}

function WritableState(options, stream) {
  Duplex = Duplex || __webpack_require__(53);

  options = options || {};

  // Duplex streams are both readable and writable, but share
  // the same options object.
  // However, some cases require setting options to different
  // values for the readable and the writable sides of the duplex stream.
  // These options can be provided separately as readableXXX and writableXXX.
  var isDuplex = stream instanceof Duplex;

  // object stream flag to indicate whether or not this stream
  // contains buffers or objects.
  this.objectMode = !!options.objectMode;

  if (isDuplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

  // the point at which write() starts returning false
  // Note: 0 is a valid value, means that we always return false if
  // the entire buffer is not flushed immediately on write()
  var hwm = options.highWaterMark;
  var writableHwm = options.writableHighWaterMark;
  var defaultHwm = this.objectMode ? 16 : 16 * 1024;

  if (hwm || hwm === 0) this.highWaterMark = hwm;else if (isDuplex && (writableHwm || writableHwm === 0)) this.highWaterMark = writableHwm;else this.highWaterMark = defaultHwm;

  // cast to ints.
  this.highWaterMark = Math.floor(this.highWaterMark);

  // if _final has been called
  this.finalCalled = false;

  // drain event flag.
  this.needDrain = false;
  // at the start of calling end()
  this.ending = false;
  // when end() has been called, and returned
  this.ended = false;
  // when 'finish' is emitted
  this.finished = false;

  // has it been destroyed
  this.destroyed = false;

  // should we decode strings into buffers before passing to _write?
  // this is here so that some node-core streams can optimize string
  // handling at a lower level.
  var noDecode = options.decodeStrings === false;
  this.decodeStrings = !noDecode;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // not an actual buffer we keep track of, but a measurement
  // of how much we're waiting to get pushed to some underlying
  // socket or file.
  this.length = 0;

  // a flag to see when we're in the middle of a write.
  this.writing = false;

  // when true all writes will be buffered until .uncork() call
  this.corked = 0;

  // a flag to be able to tell if the onwrite cb is called immediately,
  // or on a later tick.  We set this to true at first, because any
  // actions that shouldn't happen until "later" should generally also
  // not happen before the first write call.
  this.sync = true;

  // a flag to know if we're processing previously buffered items, which
  // may call the _write() callback in the same tick, so that we don't
  // end up in an overlapped onwrite situation.
  this.bufferProcessing = false;

  // the callback that's passed to _write(chunk,cb)
  this.onwrite = function (er) {
    onwrite(stream, er);
  };

  // the callback that the user supplies to write(chunk,encoding,cb)
  this.writecb = null;

  // the amount that is being written when _write is called.
  this.writelen = 0;

  this.bufferedRequest = null;
  this.lastBufferedRequest = null;

  // number of pending user-supplied write callbacks
  // this must be 0 before 'finish' can be emitted
  this.pendingcb = 0;

  // emit prefinish if the only thing we're waiting for is _write cbs
  // This is relevant for synchronous Transform streams
  this.prefinished = false;

  // True if the error was already emitted and should not be thrown again
  this.errorEmitted = false;

  // count buffered requests
  this.bufferedRequestCount = 0;

  // allocate the first CorkedRequest, there is always
  // one allocated and free to use, and we maintain at most two
  this.corkedRequestsFree = new CorkedRequest(this);
}

WritableState.prototype.getBuffer = function getBuffer() {
  var current = this.bufferedRequest;
  var out = [];
  while (current) {
    out.push(current);
    current = current.next;
  }
  return out;
};

(function () {
  try {
    Object.defineProperty(WritableState.prototype, 'buffer', {
      get: internalUtil.deprecate(function () {
        return this.getBuffer();
      }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.', 'DEP0003')
    });
  } catch (_) {}
})();

// Test _writableState for inheritance to account for Duplex streams,
// whose prototype chain only points to Readable.
var realHasInstance;
if (typeof Symbol === 'function' && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === 'function') {
  realHasInstance = Function.prototype[Symbol.hasInstance];
  Object.defineProperty(Writable, Symbol.hasInstance, {
    value: function (object) {
      if (realHasInstance.call(this, object)) return true;
      if (this !== Writable) return false;

      return object && object._writableState instanceof WritableState;
    }
  });
} else {
  realHasInstance = function (object) {
    return object instanceof this;
  };
}

function Writable(options) {
  Duplex = Duplex || __webpack_require__(53);

  // Writable ctor is applied to Duplexes, too.
  // `realHasInstance` is necessary because using plain `instanceof`
  // would return false, as no `_writableState` property is attached.

  // Trying to use the custom `instanceof` for Writable here will also break the
  // Node.js LazyTransform implementation, which has a non-trivial getter for
  // `_writableState` that would lead to infinite recursion.
  if (!realHasInstance.call(Writable, this) && !(this instanceof Duplex)) {
    return new Writable(options);
  }

  this._writableState = new WritableState(options, this);

  // legacy.
  this.writable = true;

  if (options) {
    if (typeof options.write === 'function') this._write = options.write;

    if (typeof options.writev === 'function') this._writev = options.writev;

    if (typeof options.destroy === 'function') this._destroy = options.destroy;

    if (typeof options.final === 'function') this._final = options.final;
  }

  Stream.call(this);
}

// Otherwise people can pipe Writable streams, which is just wrong.
Writable.prototype.pipe = function () {
  this.emit('error', new Error('Cannot pipe, not readable'));
};

function writeAfterEnd(stream, cb) {
  var er = new Error('write after end');
  // TODO: defer error events consistently everywhere, not just the cb
  stream.emit('error', er);
  pna.nextTick(cb, er);
}

// Checks that a user-supplied chunk is valid, especially for the particular
// mode the stream is in. Currently this means that `null` is never accepted
// and undefined/non-string values are only allowed in object mode.
function validChunk(stream, state, chunk, cb) {
  var valid = true;
  var er = false;

  if (chunk === null) {
    er = new TypeError('May not write null values to stream');
  } else if (typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
    er = new TypeError('Invalid non-string/buffer chunk');
  }
  if (er) {
    stream.emit('error', er);
    pna.nextTick(cb, er);
    valid = false;
  }
  return valid;
}

Writable.prototype.write = function (chunk, encoding, cb) {
  var state = this._writableState;
  var ret = false;
  var isBuf = !state.objectMode && _isUint8Array(chunk);

  if (isBuf && !Buffer.isBuffer(chunk)) {
    chunk = _uint8ArrayToBuffer(chunk);
  }

  if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }

  if (isBuf) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;

  if (typeof cb !== 'function') cb = nop;

  if (state.ended) writeAfterEnd(this, cb);else if (isBuf || validChunk(this, state, chunk, cb)) {
    state.pendingcb++;
    ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
  }

  return ret;
};

Writable.prototype.cork = function () {
  var state = this._writableState;

  state.corked++;
};

Writable.prototype.uncork = function () {
  var state = this._writableState;

  if (state.corked) {
    state.corked--;

    if (!state.writing && !state.corked && !state.finished && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
  }
};

Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
  // node::ParseEncoding() requires lower case.
  if (typeof encoding === 'string') encoding = encoding.toLowerCase();
  if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new TypeError('Unknown encoding: ' + encoding);
  this._writableState.defaultEncoding = encoding;
  return this;
};

function decodeChunk(state, chunk, encoding) {
  if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
    chunk = Buffer.from(chunk, encoding);
  }
  return chunk;
}

Object.defineProperty(Writable.prototype, 'writableHighWaterMark', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function () {
    return this._writableState.highWaterMark;
  }
});

// if we're already writing something, then just put this
// in the queue, and wait our turn.  Otherwise, call _write
// If we return false, then we need a drain event, so set that flag.
function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
  if (!isBuf) {
    var newChunk = decodeChunk(state, chunk, encoding);
    if (chunk !== newChunk) {
      isBuf = true;
      encoding = 'buffer';
      chunk = newChunk;
    }
  }
  var len = state.objectMode ? 1 : chunk.length;

  state.length += len;

  var ret = state.length < state.highWaterMark;
  // we must ensure that previous needDrain will not be reset to false.
  if (!ret) state.needDrain = true;

  if (state.writing || state.corked) {
    var last = state.lastBufferedRequest;
    state.lastBufferedRequest = {
      chunk: chunk,
      encoding: encoding,
      isBuf: isBuf,
      callback: cb,
      next: null
    };
    if (last) {
      last.next = state.lastBufferedRequest;
    } else {
      state.bufferedRequest = state.lastBufferedRequest;
    }
    state.bufferedRequestCount += 1;
  } else {
    doWrite(stream, state, false, len, chunk, encoding, cb);
  }

  return ret;
}

function doWrite(stream, state, writev, len, chunk, encoding, cb) {
  state.writelen = len;
  state.writecb = cb;
  state.writing = true;
  state.sync = true;
  if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
  state.sync = false;
}

function onwriteError(stream, state, sync, er, cb) {
  --state.pendingcb;

  if (sync) {
    // defer the callback if we are being called synchronously
    // to avoid piling up things on the stack
    pna.nextTick(cb, er);
    // this can emit finish, and it will always happen
    // after error
    pna.nextTick(finishMaybe, stream, state);
    stream._writableState.errorEmitted = true;
    stream.emit('error', er);
  } else {
    // the caller expect this to happen before if
    // it is async
    cb(er);
    stream._writableState.errorEmitted = true;
    stream.emit('error', er);
    // this can emit finish, but finish must
    // always follow error
    finishMaybe(stream, state);
  }
}

function onwriteStateUpdate(state) {
  state.writing = false;
  state.writecb = null;
  state.length -= state.writelen;
  state.writelen = 0;
}

function onwrite(stream, er) {
  var state = stream._writableState;
  var sync = state.sync;
  var cb = state.writecb;

  onwriteStateUpdate(state);

  if (er) onwriteError(stream, state, sync, er, cb);else {
    // Check if we're actually ready to finish, but don't emit yet
    var finished = needFinish(state);

    if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
      clearBuffer(stream, state);
    }

    if (sync) {
      /*<replacement>*/
      asyncWrite(afterWrite, stream, state, finished, cb);
      /*</replacement>*/
    } else {
      afterWrite(stream, state, finished, cb);
    }
  }
}

function afterWrite(stream, state, finished, cb) {
  if (!finished) onwriteDrain(stream, state);
  state.pendingcb--;
  cb();
  finishMaybe(stream, state);
}

// Must force callback to be called on nextTick, so that we don't
// emit 'drain' before the write() consumer gets the 'false' return
// value, and has a chance to attach a 'drain' listener.
function onwriteDrain(stream, state) {
  if (state.length === 0 && state.needDrain) {
    state.needDrain = false;
    stream.emit('drain');
  }
}

// if there's something in the buffer waiting, then process it
function clearBuffer(stream, state) {
  state.bufferProcessing = true;
  var entry = state.bufferedRequest;

  if (stream._writev && entry && entry.next) {
    // Fast case, write everything using _writev()
    var l = state.bufferedRequestCount;
    var buffer = new Array(l);
    var holder = state.corkedRequestsFree;
    holder.entry = entry;

    var count = 0;
    var allBuffers = true;
    while (entry) {
      buffer[count] = entry;
      if (!entry.isBuf) allBuffers = false;
      entry = entry.next;
      count += 1;
    }
    buffer.allBuffers = allBuffers;

    doWrite(stream, state, true, state.length, buffer, '', holder.finish);

    // doWrite is almost always async, defer these to save a bit of time
    // as the hot path ends with doWrite
    state.pendingcb++;
    state.lastBufferedRequest = null;
    if (holder.next) {
      state.corkedRequestsFree = holder.next;
      holder.next = null;
    } else {
      state.corkedRequestsFree = new CorkedRequest(state);
    }
    state.bufferedRequestCount = 0;
  } else {
    // Slow case, write chunks one-by-one
    while (entry) {
      var chunk = entry.chunk;
      var encoding = entry.encoding;
      var cb = entry.callback;
      var len = state.objectMode ? 1 : chunk.length;

      doWrite(stream, state, false, len, chunk, encoding, cb);
      entry = entry.next;
      state.bufferedRequestCount--;
      // if we didn't call the onwrite immediately, then
      // it means that we need to wait until it does.
      // also, that means that the chunk and cb are currently
      // being processed, so move the buffer counter past them.
      if (state.writing) {
        break;
      }
    }

    if (entry === null) state.lastBufferedRequest = null;
  }

  state.bufferedRequest = entry;
  state.bufferProcessing = false;
}

Writable.prototype._write = function (chunk, encoding, cb) {
  cb(new Error('_write() is not implemented'));
};

Writable.prototype._writev = null;

Writable.prototype.end = function (chunk, encoding, cb) {
  var state = this._writableState;

  if (typeof chunk === 'function') {
    cb = chunk;
    chunk = null;
    encoding = null;
  } else if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }

  if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

  // .end() fully uncorks
  if (state.corked) {
    state.corked = 1;
    this.uncork();
  }

  // ignore unnecessary end() calls.
  if (!state.ending && !state.finished) endWritable(this, state, cb);
};

function needFinish(state) {
  return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
}
function callFinal(stream, state) {
  stream._final(function (err) {
    state.pendingcb--;
    if (err) {
      stream.emit('error', err);
    }
    state.prefinished = true;
    stream.emit('prefinish');
    finishMaybe(stream, state);
  });
}
function prefinish(stream, state) {
  if (!state.prefinished && !state.finalCalled) {
    if (typeof stream._final === 'function') {
      state.pendingcb++;
      state.finalCalled = true;
      pna.nextTick(callFinal, stream, state);
    } else {
      state.prefinished = true;
      stream.emit('prefinish');
    }
  }
}

function finishMaybe(stream, state) {
  var need = needFinish(state);
  if (need) {
    prefinish(stream, state);
    if (state.pendingcb === 0) {
      state.finished = true;
      stream.emit('finish');
    }
  }
  return need;
}

function endWritable(stream, state, cb) {
  state.ending = true;
  finishMaybe(stream, state);
  if (cb) {
    if (state.finished) pna.nextTick(cb);else stream.once('finish', cb);
  }
  state.ended = true;
  stream.writable = false;
}

function onCorkedFinish(corkReq, state, err) {
  var entry = corkReq.entry;
  corkReq.entry = null;
  while (entry) {
    var cb = entry.callback;
    state.pendingcb--;
    cb(err);
    entry = entry.next;
  }
  if (state.corkedRequestsFree) {
    state.corkedRequestsFree.next = corkReq;
  } else {
    state.corkedRequestsFree = corkReq;
  }
}

Object.defineProperty(Writable.prototype, 'destroyed', {
  get: function () {
    if (this._writableState === undefined) {
      return false;
    }
    return this._writableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (!this._writableState) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._writableState.destroyed = value;
  }
});

Writable.prototype.destroy = destroyImpl.destroy;
Writable.prototype._undestroy = destroyImpl.undestroy;
Writable.prototype._destroy = function (err, cb) {
  this.end();
  cb(err);
};
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(30), __webpack_require__(422).setImmediate, __webpack_require__(15)))

/***/ }),
/* 120 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



/*<replacement>*/

var Buffer = __webpack_require__(6).Buffer;
/*</replacement>*/

var isEncoding = Buffer.isEncoding || function (encoding) {
  encoding = '' + encoding;
  switch (encoding && encoding.toLowerCase()) {
    case 'hex':case 'utf8':case 'utf-8':case 'ascii':case 'binary':case 'base64':case 'ucs2':case 'ucs-2':case 'utf16le':case 'utf-16le':case 'raw':
      return true;
    default:
      return false;
  }
};

function _normalizeEncoding(enc) {
  if (!enc) return 'utf8';
  var retried;
  while (true) {
    switch (enc) {
      case 'utf8':
      case 'utf-8':
        return 'utf8';
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return 'utf16le';
      case 'latin1':
      case 'binary':
        return 'latin1';
      case 'base64':
      case 'ascii':
      case 'hex':
        return enc;
      default:
        if (retried) return; // undefined
        enc = ('' + enc).toLowerCase();
        retried = true;
    }
  }
};

// Do not cache `Buffer.isEncoding` when checking encoding names as some
// modules monkey-patch it to support additional encodings
function normalizeEncoding(enc) {
  var nenc = _normalizeEncoding(enc);
  if (typeof nenc !== 'string' && (Buffer.isEncoding === isEncoding || !isEncoding(enc))) throw new Error('Unknown encoding: ' + enc);
  return nenc || enc;
}

// StringDecoder provides an interface for efficiently splitting a series of
// buffers into a series of JS strings without breaking apart multi-byte
// characters.
exports.StringDecoder = StringDecoder;
function StringDecoder(encoding) {
  this.encoding = normalizeEncoding(encoding);
  var nb;
  switch (this.encoding) {
    case 'utf16le':
      this.text = utf16Text;
      this.end = utf16End;
      nb = 4;
      break;
    case 'utf8':
      this.fillLast = utf8FillLast;
      nb = 4;
      break;
    case 'base64':
      this.text = base64Text;
      this.end = base64End;
      nb = 3;
      break;
    default:
      this.write = simpleWrite;
      this.end = simpleEnd;
      return;
  }
  this.lastNeed = 0;
  this.lastTotal = 0;
  this.lastChar = Buffer.allocUnsafe(nb);
}

StringDecoder.prototype.write = function (buf) {
  if (buf.length === 0) return '';
  var r;
  var i;
  if (this.lastNeed) {
    r = this.fillLast(buf);
    if (r === undefined) return '';
    i = this.lastNeed;
    this.lastNeed = 0;
  } else {
    i = 0;
  }
  if (i < buf.length) return r ? r + this.text(buf, i) : this.text(buf, i);
  return r || '';
};

StringDecoder.prototype.end = utf8End;

// Returns only complete characters in a Buffer
StringDecoder.prototype.text = utf8Text;

// Attempts to complete a partial non-UTF-8 character using bytes from a Buffer
StringDecoder.prototype.fillLast = function (buf) {
  if (this.lastNeed <= buf.length) {
    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
  }
  buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
  this.lastNeed -= buf.length;
};

// Checks the type of a UTF-8 byte, whether it's ASCII, a leading byte, or a
// continuation byte. If an invalid byte is detected, -2 is returned.
function utf8CheckByte(byte) {
  if (byte <= 0x7F) return 0;else if (byte >> 5 === 0x06) return 2;else if (byte >> 4 === 0x0E) return 3;else if (byte >> 3 === 0x1E) return 4;
  return byte >> 6 === 0x02 ? -1 : -2;
}

// Checks at most 3 bytes at the end of a Buffer in order to detect an
// incomplete multi-byte UTF-8 character. The total number of bytes (2, 3, or 4)
// needed to complete the UTF-8 character (if applicable) are returned.
function utf8CheckIncomplete(self, buf, i) {
  var j = buf.length - 1;
  if (j < i) return 0;
  var nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) self.lastNeed = nb - 1;
    return nb;
  }
  if (--j < i || nb === -2) return 0;
  nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) self.lastNeed = nb - 2;
    return nb;
  }
  if (--j < i || nb === -2) return 0;
  nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) {
      if (nb === 2) nb = 0;else self.lastNeed = nb - 3;
    }
    return nb;
  }
  return 0;
}

// Validates as many continuation bytes for a multi-byte UTF-8 character as
// needed or are available. If we see a non-continuation byte where we expect
// one, we "replace" the validated continuation bytes we've seen so far with
// a single UTF-8 replacement character ('\ufffd'), to match v8's UTF-8 decoding
// behavior. The continuation byte check is included three times in the case
// where all of the continuation bytes for a character exist in the same buffer.
// It is also done this way as a slight performance increase instead of using a
// loop.
function utf8CheckExtraBytes(self, buf, p) {
  if ((buf[0] & 0xC0) !== 0x80) {
    self.lastNeed = 0;
    return '\ufffd';
  }
  if (self.lastNeed > 1 && buf.length > 1) {
    if ((buf[1] & 0xC0) !== 0x80) {
      self.lastNeed = 1;
      return '\ufffd';
    }
    if (self.lastNeed > 2 && buf.length > 2) {
      if ((buf[2] & 0xC0) !== 0x80) {
        self.lastNeed = 2;
        return '\ufffd';
      }
    }
  }
}

// Attempts to complete a multi-byte UTF-8 character using bytes from a Buffer.
function utf8FillLast(buf) {
  var p = this.lastTotal - this.lastNeed;
  var r = utf8CheckExtraBytes(this, buf, p);
  if (r !== undefined) return r;
  if (this.lastNeed <= buf.length) {
    buf.copy(this.lastChar, p, 0, this.lastNeed);
    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
  }
  buf.copy(this.lastChar, p, 0, buf.length);
  this.lastNeed -= buf.length;
}

// Returns all complete UTF-8 characters in a Buffer. If the Buffer ended on a
// partial character, the character's bytes are buffered until the required
// number of bytes are available.
function utf8Text(buf, i) {
  var total = utf8CheckIncomplete(this, buf, i);
  if (!this.lastNeed) return buf.toString('utf8', i);
  this.lastTotal = total;
  var end = buf.length - (total - this.lastNeed);
  buf.copy(this.lastChar, 0, end);
  return buf.toString('utf8', i, end);
}

// For UTF-8, a replacement character is added when ending on a partial
// character.
function utf8End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) return r + '\ufffd';
  return r;
}

// UTF-16LE typically needs two bytes per character, but even if we have an even
// number of bytes available, we need to check if we end on a leading/high
// surrogate. In that case, we need to wait for the next two bytes in order to
// decode the last character properly.
function utf16Text(buf, i) {
  if ((buf.length - i) % 2 === 0) {
    var r = buf.toString('utf16le', i);
    if (r) {
      var c = r.charCodeAt(r.length - 1);
      if (c >= 0xD800 && c <= 0xDBFF) {
        this.lastNeed = 2;
        this.lastTotal = 4;
        this.lastChar[0] = buf[buf.length - 2];
        this.lastChar[1] = buf[buf.length - 1];
        return r.slice(0, -1);
      }
    }
    return r;
  }
  this.lastNeed = 1;
  this.lastTotal = 2;
  this.lastChar[0] = buf[buf.length - 1];
  return buf.toString('utf16le', i, buf.length - 1);
}

// For UTF-16LE we do not explicitly append special replacement characters if we
// end on a partial character, we simply let v8 handle that.
function utf16End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) {
    var end = this.lastTotal - this.lastNeed;
    return r + this.lastChar.toString('utf16le', 0, end);
  }
  return r;
}

function base64Text(buf, i) {
  var n = (buf.length - i) % 3;
  if (n === 0) return buf.toString('base64', i);
  this.lastNeed = 3 - n;
  this.lastTotal = 3;
  if (n === 1) {
    this.lastChar[0] = buf[buf.length - 1];
  } else {
    this.lastChar[0] = buf[buf.length - 2];
    this.lastChar[1] = buf[buf.length - 1];
  }
  return buf.toString('base64', i, buf.length - n);
}

function base64End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) return r + this.lastChar.toString('base64', 0, 3 - this.lastNeed);
  return r;
}

// Pass bytes on through for single-byte encodings (e.g. ascii, latin1, hex)
function simpleWrite(buf) {
  return buf.toString(this.encoding);
}

function simpleEnd(buf) {
  return buf && buf.length ? this.write(buf) : '';
}

/***/ }),
/* 121 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var Buffer = __webpack_require__(8).Buffer
var inherits = __webpack_require__(1)
var HashBase = __webpack_require__(165)

var ARRAY16 = new Array(16)

var zl = [
  0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
  7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8,
  3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12,
  1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2,
  4, 0, 5, 9, 7, 12, 2, 10, 14, 1, 3, 8, 11, 6, 15, 13
]

var zr = [
  5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12,
  6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2,
  15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13,
  8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14,
  12, 15, 10, 4, 1, 5, 8, 7, 6, 2, 13, 14, 0, 3, 9, 11
]

var sl = [
  11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8,
  7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12,
  11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5,
  11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12,
  9, 15, 5, 11, 6, 8, 13, 12, 5, 12, 13, 14, 11, 8, 5, 6
]

var sr = [
  8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6,
  9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11,
  9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5,
  15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8,
  8, 5, 12, 9, 12, 5, 14, 6, 8, 13, 6, 5, 15, 13, 11, 11
]

var hl = [0x00000000, 0x5a827999, 0x6ed9eba1, 0x8f1bbcdc, 0xa953fd4e]
var hr = [0x50a28be6, 0x5c4dd124, 0x6d703ef3, 0x7a6d76e9, 0x00000000]

function RIPEMD160 () {
  HashBase.call(this, 64)

  // state
  this._a = 0x67452301
  this._b = 0xefcdab89
  this._c = 0x98badcfe
  this._d = 0x10325476
  this._e = 0xc3d2e1f0
}

inherits(RIPEMD160, HashBase)

RIPEMD160.prototype._update = function () {
  var words = ARRAY16
  for (var j = 0; j < 16; ++j) words[j] = this._block.readInt32LE(j * 4)

  var al = this._a | 0
  var bl = this._b | 0
  var cl = this._c | 0
  var dl = this._d | 0
  var el = this._e | 0

  var ar = this._a | 0
  var br = this._b | 0
  var cr = this._c | 0
  var dr = this._d | 0
  var er = this._e | 0

  // computation
  for (var i = 0; i < 80; i += 1) {
    var tl
    var tr
    if (i < 16) {
      tl = fn1(al, bl, cl, dl, el, words[zl[i]], hl[0], sl[i])
      tr = fn5(ar, br, cr, dr, er, words[zr[i]], hr[0], sr[i])
    } else if (i < 32) {
      tl = fn2(al, bl, cl, dl, el, words[zl[i]], hl[1], sl[i])
      tr = fn4(ar, br, cr, dr, er, words[zr[i]], hr[1], sr[i])
    } else if (i < 48) {
      tl = fn3(al, bl, cl, dl, el, words[zl[i]], hl[2], sl[i])
      tr = fn3(ar, br, cr, dr, er, words[zr[i]], hr[2], sr[i])
    } else if (i < 64) {
      tl = fn4(al, bl, cl, dl, el, words[zl[i]], hl[3], sl[i])
      tr = fn2(ar, br, cr, dr, er, words[zr[i]], hr[3], sr[i])
    } else { // if (i<80) {
      tl = fn5(al, bl, cl, dl, el, words[zl[i]], hl[4], sl[i])
      tr = fn1(ar, br, cr, dr, er, words[zr[i]], hr[4], sr[i])
    }

    al = el
    el = dl
    dl = rotl(cl, 10)
    cl = bl
    bl = tl

    ar = er
    er = dr
    dr = rotl(cr, 10)
    cr = br
    br = tr
  }

  // update state
  var t = (this._b + cl + dr) | 0
  this._b = (this._c + dl + er) | 0
  this._c = (this._d + el + ar) | 0
  this._d = (this._e + al + br) | 0
  this._e = (this._a + bl + cr) | 0
  this._a = t
}

RIPEMD160.prototype._digest = function () {
  // create padding and handle blocks
  this._block[this._blockOffset++] = 0x80
  if (this._blockOffset > 56) {
    this._block.fill(0, this._blockOffset, 64)
    this._update()
    this._blockOffset = 0
  }

  this._block.fill(0, this._blockOffset, 56)
  this._block.writeUInt32LE(this._length[0], 56)
  this._block.writeUInt32LE(this._length[1], 60)
  this._update()

  // produce result
  var buffer = Buffer.alloc ? Buffer.alloc(20) : new Buffer(20)
  buffer.writeInt32LE(this._a, 0)
  buffer.writeInt32LE(this._b, 4)
  buffer.writeInt32LE(this._c, 8)
  buffer.writeInt32LE(this._d, 12)
  buffer.writeInt32LE(this._e, 16)
  return buffer
}

function rotl (x, n) {
  return (x << n) | (x >>> (32 - n))
}

function fn1 (a, b, c, d, e, m, k, s) {
  return (rotl((a + (b ^ c ^ d) + m + k) | 0, s) + e) | 0
}

function fn2 (a, b, c, d, e, m, k, s) {
  return (rotl((a + ((b & c) | ((~b) & d)) + m + k) | 0, s) + e) | 0
}

function fn3 (a, b, c, d, e, m, k, s) {
  return (rotl((a + ((b | (~c)) ^ d) + m + k) | 0, s) + e) | 0
}

function fn4 (a, b, c, d, e, m, k, s) {
  return (rotl((a + ((b & d) | (c & (~d))) + m + k) | 0, s) + e) | 0
}

function fn5 (a, b, c, d, e, m, k, s) {
  return (rotl((a + (b ^ (c | (~d))) + m + k) | 0, s) + e) | 0
}

module.exports = RIPEMD160


/***/ }),
/* 122 */
/***/ (function(module, exports, __webpack_require__) {

var exports = module.exports = function SHA (algorithm) {
  algorithm = algorithm.toLowerCase()

  var Algorithm = exports[algorithm]
  if (!Algorithm) throw new Error(algorithm + ' is not supported (we accept pull requests)')

  return new Algorithm()
}

exports.sha = __webpack_require__(430)
exports.sha1 = __webpack_require__(431)
exports.sha224 = __webpack_require__(432)
exports.sha256 = __webpack_require__(170)
exports.sha384 = __webpack_require__(433)
exports.sha512 = __webpack_require__(171)


/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.utils = __webpack_require__(439);
exports.Cipher = __webpack_require__(440);
exports.DES = __webpack_require__(441);
exports.CBC = __webpack_require__(442);
exports.EDE = __webpack_require__(443);


/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

var ciphers = __webpack_require__(444)
var deciphers = __webpack_require__(452)
var modes = __webpack_require__(181)

function getCiphers () {
  return Object.keys(modes)
}

exports.createCipher = exports.Cipher = ciphers.createCipher
exports.createCipheriv = exports.Cipheriv = ciphers.createCipheriv
exports.createDecipher = exports.Decipher = deciphers.createDecipher
exports.createDecipheriv = exports.Decipheriv = deciphers.createDecipheriv
exports.listCiphers = exports.getCiphers = getCiphers


/***/ }),
/* 125 */
/***/ (function(module, exports, __webpack_require__) {

var modeModules = {
  ECB: __webpack_require__(445),
  CBC: __webpack_require__(446),
  CFB: __webpack_require__(447),
  CFB8: __webpack_require__(448),
  CFB1: __webpack_require__(449),
  OFB: __webpack_require__(450),
  CTR: __webpack_require__(179),
  GCM: __webpack_require__(179)
}

var modes = __webpack_require__(181)

for (var key in modes) {
  modes[key].module = modeModules[modes[key].mode]
}

module.exports = modes


/***/ }),
/* 126 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {var bn = __webpack_require__(12);
var randomBytes = __webpack_require__(58);
module.exports = crt;
function blind(priv) {
  var r = getr(priv);
  var blinder = r.toRed(bn.mont(priv.modulus))
  .redPow(new bn(priv.publicExponent)).fromRed();
  return {
    blinder: blinder,
    unblinder:r.invm(priv.modulus)
  };
}
function crt(msg, priv) {
  var blinds = blind(priv);
  var len = priv.modulus.byteLength();
  var mod = bn.mont(priv.modulus);
  var blinded = new bn(msg).mul(blinds.blinder).umod(priv.modulus);
  var c1 = blinded.toRed(bn.mont(priv.prime1));
  var c2 = blinded.toRed(bn.mont(priv.prime2));
  var qinv = priv.coefficient;
  var p = priv.prime1;
  var q = priv.prime2;
  var m1 = c1.redPow(priv.exponent1);
  var m2 = c2.redPow(priv.exponent2);
  m1 = m1.fromRed();
  m2 = m2.fromRed();
  var h = m1.isub(m2).imul(qinv).umod(p);
  h.imul(q);
  m2.iadd(h);
  return new Buffer(m2.imul(blinds.unblinder).umod(priv.modulus).toArray(false, len));
}
crt.getr = getr;
function getr(priv) {
  var len = priv.modulus.byteLength();
  var r = new bn(randomBytes(len));
  while (r.cmp(priv.modulus) >=  0 || !r.umod(priv.prime1) || !r.umod(priv.prime2)) {
    r = new bn(randomBytes(len));
  }
  return r;
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(8).Buffer))

/***/ }),
/* 127 */
/***/ (function(module, exports, __webpack_require__) {

var hash = exports;

hash.utils = __webpack_require__(36);
hash.common = __webpack_require__(67);
hash.sha = __webpack_require__(468);
hash.ripemd = __webpack_require__(472);
hash.hmac = __webpack_require__(473);

// Proxy hash functions to the main object
hash.sha1 = hash.sha.sha1;
hash.sha256 = hash.sha.sha256;
hash.sha224 = hash.sha.sha224;
hash.sha384 = hash.sha.sha384;
hash.sha512 = hash.sha.sha512;
hash.ripemd160 = hash.ripemd.ripemd160;


/***/ }),
/* 128 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = !__webpack_require__(9) && !__webpack_require__(4)(function () {
  return Object.defineProperty(__webpack_require__(90)('div'), 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 129 */
/***/ (function(module, exports, __webpack_require__) {

exports.f = __webpack_require__(7);


/***/ }),
/* 130 */
/***/ (function(module, exports, __webpack_require__) {

var has = __webpack_require__(20);
var toIObject = __webpack_require__(21);
var arrayIndexOf = __webpack_require__(71)(false);
var IE_PROTO = __webpack_require__(92)('IE_PROTO');

module.exports = function (object, names) {
  var O = toIObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (has(O, key = names[i++])) {
    ~arrayIndexOf(result, key) || result.push(key);
  }
  return result;
};


/***/ }),
/* 131 */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(10);
var anObject = __webpack_require__(2);
var getKeys = __webpack_require__(45);

module.exports = __webpack_require__(9) ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject(O);
  var keys = getKeys(Properties);
  var length = keys.length;
  var i = 0;
  var P;
  while (length > i) dP.f(O, P = keys[i++], Properties[P]);
  return O;
};


/***/ }),
/* 132 */
/***/ (function(module, exports, __webpack_require__) {

// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
var toIObject = __webpack_require__(21);
var gOPN = __webpack_require__(48).f;
var toString = {}.toString;

var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
  ? Object.getOwnPropertyNames(window) : [];

var getWindowNames = function (it) {
  try {
    return gOPN(it);
  } catch (e) {
    return windowNames.slice();
  }
};

module.exports.f = function getOwnPropertyNames(it) {
  return windowNames && toString.call(it) == '[object Window]' ? getWindowNames(it) : gOPN(toIObject(it));
};


/***/ }),
/* 133 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// 19.1.2.1 Object.assign(target, source, ...)
var getKeys = __webpack_require__(45);
var gOPS = __webpack_require__(72);
var pIE = __webpack_require__(61);
var toObject = __webpack_require__(13);
var IObject = __webpack_require__(60);
var $assign = Object.assign;

// should work with symbols and should have deterministic property order (V8 bug)
module.exports = !$assign || __webpack_require__(4)(function () {
  var A = {};
  var B = {};
  // eslint-disable-next-line no-undef
  var S = Symbol();
  var K = 'abcdefghijklmnopqrst';
  A[S] = 7;
  K.split('').forEach(function (k) { B[k] = k; });
  return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars
  var T = toObject(target);
  var aLen = arguments.length;
  var index = 1;
  var getSymbols = gOPS.f;
  var isEnum = pIE.f;
  while (aLen > index) {
    var S = IObject(arguments[index++]);
    var keys = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) if (isEnum.call(S, key = keys[j++])) T[key] = S[key];
  } return T;
} : $assign;


/***/ }),
/* 134 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var aFunction = __webpack_require__(14);
var isObject = __webpack_require__(5);
var invoke = __webpack_require__(135);
var arraySlice = [].slice;
var factories = {};

var construct = function (F, len, args) {
  if (!(len in factories)) {
    for (var n = [], i = 0; i < len; i++) n[i] = 'a[' + i + ']';
    // eslint-disable-next-line no-new-func
    factories[len] = Function('F,a', 'return new F(' + n.join(',') + ')');
  } return factories[len](F, args);
};

module.exports = Function.bind || function bind(that /* , ...args */) {
  var fn = aFunction(this);
  var partArgs = arraySlice.call(arguments, 1);
  var bound = function (/* args... */) {
    var args = partArgs.concat(arraySlice.call(arguments));
    return this instanceof bound ? construct(fn, args.length, args) : invoke(fn, args, that);
  };
  if (isObject(fn.prototype)) bound.prototype = fn.prototype;
  return bound;
};


/***/ }),
/* 135 */
/***/ (function(module, exports) {

// fast apply, http://jsperf.lnkit.com/fast-apply/5
module.exports = function (fn, args, that) {
  var un = that === undefined;
  switch (args.length) {
    case 0: return un ? fn()
                      : fn.call(that);
    case 1: return un ? fn(args[0])
                      : fn.call(that, args[0]);
    case 2: return un ? fn(args[0], args[1])
                      : fn.call(that, args[0], args[1]);
    case 3: return un ? fn(args[0], args[1], args[2])
                      : fn.call(that, args[0], args[1], args[2]);
    case 4: return un ? fn(args[0], args[1], args[2], args[3])
                      : fn.call(that, args[0], args[1], args[2], args[3]);
  } return fn.apply(that, args);
};


/***/ }),
/* 136 */
/***/ (function(module, exports, __webpack_require__) {

var $parseInt = __webpack_require__(3).parseInt;
var $trim = __webpack_require__(55).trim;
var ws = __webpack_require__(96);
var hex = /^[-+]?0[xX]/;

module.exports = $parseInt(ws + '08') !== 8 || $parseInt(ws + '0x16') !== 22 ? function parseInt(str, radix) {
  var string = $trim(String(str), 3);
  return $parseInt(string, (radix >>> 0) || (hex.test(string) ? 16 : 10));
} : $parseInt;


/***/ }),
/* 137 */
/***/ (function(module, exports, __webpack_require__) {

var $parseFloat = __webpack_require__(3).parseFloat;
var $trim = __webpack_require__(55).trim;

module.exports = 1 / $parseFloat(__webpack_require__(96) + '-0') !== -Infinity ? function parseFloat(str) {
  var string = $trim(String(str), 3);
  var result = $parseFloat(string);
  return result === 0 && string.charAt(0) == '-' ? -0 : result;
} : $parseFloat;


/***/ }),
/* 138 */
/***/ (function(module, exports, __webpack_require__) {

var cof = __webpack_require__(28);
module.exports = function (it, msg) {
  if (typeof it != 'number' && cof(it) != 'Number') throw TypeError(msg);
  return +it;
};


/***/ }),
/* 139 */
/***/ (function(module, exports, __webpack_require__) {

// 20.1.2.3 Number.isInteger(number)
var isObject = __webpack_require__(5);
var floor = Math.floor;
module.exports = function isInteger(it) {
  return !isObject(it) && isFinite(it) && floor(it) === it;
};


/***/ }),
/* 140 */
/***/ (function(module, exports) {

// 20.2.2.20 Math.log1p(x)
module.exports = Math.log1p || function log1p(x) {
  return (x = +x) > -1e-8 && x < 1e-8 ? x - x * x / 2 : Math.log(1 + x);
};


/***/ }),
/* 141 */
/***/ (function(module, exports, __webpack_require__) {

// 20.2.2.16 Math.fround(x)
var sign = __webpack_require__(99);
var pow = Math.pow;
var EPSILON = pow(2, -52);
var EPSILON32 = pow(2, -23);
var MAX32 = pow(2, 127) * (2 - EPSILON32);
var MIN32 = pow(2, -126);

var roundTiesToEven = function (n) {
  return n + 1 / EPSILON - 1 / EPSILON;
};

module.exports = Math.fround || function fround(x) {
  var $abs = Math.abs(x);
  var $sign = sign(x);
  var a, result;
  if ($abs < MIN32) return $sign * roundTiesToEven($abs / MIN32 / EPSILON32) * MIN32 * EPSILON32;
  a = (1 + EPSILON32 / EPSILON) * $abs;
  result = a - (a - $abs);
  // eslint-disable-next-line no-self-compare
  if (result > MAX32 || result != result) return $sign * Infinity;
  return $sign * result;
};


/***/ }),
/* 142 */
/***/ (function(module, exports, __webpack_require__) {

// call something on iterator step with safe closing on error
var anObject = __webpack_require__(2);
module.exports = function (iterator, fn, value, entries) {
  try {
    return entries ? fn(anObject(value)[0], value[1]) : fn(value);
  // 7.4.6 IteratorClose(iterator, completion)
  } catch (e) {
    var ret = iterator['return'];
    if (ret !== undefined) anObject(ret.call(iterator));
    throw e;
  }
};


/***/ }),
/* 143 */
/***/ (function(module, exports, __webpack_require__) {

var aFunction = __webpack_require__(14);
var toObject = __webpack_require__(13);
var IObject = __webpack_require__(60);
var toLength = __webpack_require__(11);

module.exports = function (that, callbackfn, aLen, memo, isRight) {
  aFunction(callbackfn);
  var O = toObject(that);
  var self = IObject(O);
  var length = toLength(O.length);
  var index = isRight ? length - 1 : 0;
  var i = isRight ? -1 : 1;
  if (aLen < 2) for (;;) {
    if (index in self) {
      memo = self[index];
      index += i;
      break;
    }
    index += i;
    if (isRight ? index < 0 : length <= index) {
      throw TypeError('Reduce of empty array with no initial value');
    }
  }
  for (;isRight ? index >= 0 : length > index; index += i) if (index in self) {
    memo = callbackfn(memo, self[index], index, O);
  }
  return memo;
};


/***/ }),
/* 144 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// 22.1.3.3 Array.prototype.copyWithin(target, start, end = this.length)

var toObject = __webpack_require__(13);
var toAbsoluteIndex = __webpack_require__(46);
var toLength = __webpack_require__(11);

module.exports = [].copyWithin || function copyWithin(target /* = 0 */, start /* = 0, end = @length */) {
  var O = toObject(this);
  var len = toLength(O.length);
  var to = toAbsoluteIndex(target, len);
  var from = toAbsoluteIndex(start, len);
  var end = arguments.length > 2 ? arguments[2] : undefined;
  var count = Math.min((end === undefined ? len : toAbsoluteIndex(end, len)) - from, len - to);
  var inc = 1;
  if (from < to && to < from + count) {
    inc = -1;
    from += count - 1;
    to += count - 1;
  }
  while (count-- > 0) {
    if (from in O) O[to] = O[from];
    else delete O[to];
    to += inc;
    from += inc;
  } return O;
};


/***/ }),
/* 145 */
/***/ (function(module, exports) {

module.exports = function (done, value) {
  return { value: value, done: !!done };
};


/***/ }),
/* 146 */
/***/ (function(module, exports, __webpack_require__) {

// 21.2.5.3 get RegExp.prototype.flags()
if (__webpack_require__(9) && /./g.flags != 'g') __webpack_require__(10).f(RegExp.prototype, 'flags', {
  configurable: true,
  get: __webpack_require__(76)
});


/***/ }),
/* 147 */
/***/ (function(module, exports) {

module.exports = function (exec) {
  try {
    return { e: false, v: exec() };
  } catch (e) {
    return { e: true, v: e };
  }
};


/***/ }),
/* 148 */
/***/ (function(module, exports, __webpack_require__) {

var anObject = __webpack_require__(2);
var isObject = __webpack_require__(5);
var newPromiseCapability = __webpack_require__(114);

module.exports = function (C, x) {
  anObject(C);
  if (isObject(x) && x.constructor === C) return x;
  var promiseCapability = newPromiseCapability.f(C);
  var resolve = promiseCapability.resolve;
  resolve(x);
  return promiseCapability.promise;
};


/***/ }),
/* 149 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var strong = __webpack_require__(150);
var validate = __webpack_require__(57);
var MAP = 'Map';

// 23.1 Map Objects
module.exports = __webpack_require__(80)(MAP, function (get) {
  return function Map() { return get(this, arguments.length > 0 ? arguments[0] : undefined); };
}, {
  // 23.1.3.6 Map.prototype.get(key)
  get: function get(key) {
    var entry = strong.getEntry(validate(this, MAP), key);
    return entry && entry.v;
  },
  // 23.1.3.9 Map.prototype.set(key, value)
  set: function set(key, value) {
    return strong.def(validate(this, MAP), key === 0 ? 0 : key, value);
  }
}, strong, true);


/***/ }),
/* 150 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var dP = __webpack_require__(10).f;
var create = __webpack_require__(47);
var redefineAll = __webpack_require__(52);
var ctx = __webpack_require__(27);
var anInstance = __webpack_require__(50);
var forOf = __webpack_require__(51);
var $iterDefine = __webpack_require__(102);
var step = __webpack_require__(145);
var setSpecies = __webpack_require__(49);
var DESCRIPTORS = __webpack_require__(9);
var fastKey = __webpack_require__(39).fastKey;
var validate = __webpack_require__(57);
var SIZE = DESCRIPTORS ? '_s' : 'size';

var getEntry = function (that, key) {
  // fast case
  var index = fastKey(key);
  var entry;
  if (index !== 'F') return that._i[index];
  // frozen object case
  for (entry = that._f; entry; entry = entry.n) {
    if (entry.k == key) return entry;
  }
};

module.exports = {
  getConstructor: function (wrapper, NAME, IS_MAP, ADDER) {
    var C = wrapper(function (that, iterable) {
      anInstance(that, C, NAME, '_i');
      that._t = NAME;         // collection type
      that._i = create(null); // index
      that._f = undefined;    // first entry
      that._l = undefined;    // last entry
      that[SIZE] = 0;         // size
      if (iterable != undefined) forOf(iterable, IS_MAP, that[ADDER], that);
    });
    redefineAll(C.prototype, {
      // 23.1.3.1 Map.prototype.clear()
      // 23.2.3.2 Set.prototype.clear()
      clear: function clear() {
        for (var that = validate(this, NAME), data = that._i, entry = that._f; entry; entry = entry.n) {
          entry.r = true;
          if (entry.p) entry.p = entry.p.n = undefined;
          delete data[entry.i];
        }
        that._f = that._l = undefined;
        that[SIZE] = 0;
      },
      // 23.1.3.3 Map.prototype.delete(key)
      // 23.2.3.4 Set.prototype.delete(value)
      'delete': function (key) {
        var that = validate(this, NAME);
        var entry = getEntry(that, key);
        if (entry) {
          var next = entry.n;
          var prev = entry.p;
          delete that._i[entry.i];
          entry.r = true;
          if (prev) prev.n = next;
          if (next) next.p = prev;
          if (that._f == entry) that._f = next;
          if (that._l == entry) that._l = prev;
          that[SIZE]--;
        } return !!entry;
      },
      // 23.2.3.6 Set.prototype.forEach(callbackfn, thisArg = undefined)
      // 23.1.3.5 Map.prototype.forEach(callbackfn, thisArg = undefined)
      forEach: function forEach(callbackfn /* , that = undefined */) {
        validate(this, NAME);
        var f = ctx(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
        var entry;
        while (entry = entry ? entry.n : this._f) {
          f(entry.v, entry.k, this);
          // revert to the last existing entry
          while (entry && entry.r) entry = entry.p;
        }
      },
      // 23.1.3.7 Map.prototype.has(key)
      // 23.2.3.7 Set.prototype.has(value)
      has: function has(key) {
        return !!getEntry(validate(this, NAME), key);
      }
    });
    if (DESCRIPTORS) dP(C.prototype, 'size', {
      get: function () {
        return validate(this, NAME)[SIZE];
      }
    });
    return C;
  },
  def: function (that, key, value) {
    var entry = getEntry(that, key);
    var prev, index;
    // change existing entry
    if (entry) {
      entry.v = value;
    // create new entry
    } else {
      that._l = entry = {
        i: index = fastKey(key, true), // <- index
        k: key,                        // <- key
        v: value,                      // <- value
        p: prev = that._l,             // <- previous entry
        n: undefined,                  // <- next entry
        r: false                       // <- removed
      };
      if (!that._f) that._f = entry;
      if (prev) prev.n = entry;
      that[SIZE]++;
      // add to index
      if (index !== 'F') that._i[index] = entry;
    } return that;
  },
  getEntry: getEntry,
  setStrong: function (C, NAME, IS_MAP) {
    // add .keys, .values, .entries, [@@iterator]
    // 23.1.3.4, 23.1.3.8, 23.1.3.11, 23.1.3.12, 23.2.3.5, 23.2.3.8, 23.2.3.10, 23.2.3.11
    $iterDefine(C, NAME, function (iterated, kind) {
      this._t = validate(iterated, NAME); // target
      this._k = kind;                     // kind
      this._l = undefined;                // previous
    }, function () {
      var that = this;
      var kind = that._k;
      var entry = that._l;
      // revert to the last existing entry
      while (entry && entry.r) entry = entry.p;
      // get next entry
      if (!that._t || !(that._l = entry = entry ? entry.n : that._t._f)) {
        // or finish the iteration
        that._t = undefined;
        return step(1);
      }
      // return step by kind
      if (kind == 'keys') return step(0, entry.k);
      if (kind == 'values') return step(0, entry.v);
      return step(0, [entry.k, entry.v]);
    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);

    // add [@@species], 23.1.2.2, 23.2.2.2
    setSpecies(NAME);
  }
};


/***/ }),
/* 151 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var strong = __webpack_require__(150);
var validate = __webpack_require__(57);
var SET = 'Set';

// 23.2 Set Objects
module.exports = __webpack_require__(80)(SET, function (get) {
  return function Set() { return get(this, arguments.length > 0 ? arguments[0] : undefined); };
}, {
  // 23.2.3.1 Set.prototype.add(value)
  add: function add(value) {
    return strong.def(validate(this, SET), value = value === 0 ? 0 : value, value);
  }
}, strong);


/***/ }),
/* 152 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var each = __webpack_require__(35)(0);
var redefine = __webpack_require__(18);
var meta = __webpack_require__(39);
var assign = __webpack_require__(133);
var weak = __webpack_require__(153);
var isObject = __webpack_require__(5);
var fails = __webpack_require__(4);
var validate = __webpack_require__(57);
var WEAK_MAP = 'WeakMap';
var getWeak = meta.getWeak;
var isExtensible = Object.isExtensible;
var uncaughtFrozenStore = weak.ufstore;
var tmp = {};
var InternalMap;

var wrapper = function (get) {
  return function WeakMap() {
    return get(this, arguments.length > 0 ? arguments[0] : undefined);
  };
};

var methods = {
  // 23.3.3.3 WeakMap.prototype.get(key)
  get: function get(key) {
    if (isObject(key)) {
      var data = getWeak(key);
      if (data === true) return uncaughtFrozenStore(validate(this, WEAK_MAP)).get(key);
      return data ? data[this._i] : undefined;
    }
  },
  // 23.3.3.5 WeakMap.prototype.set(key, value)
  set: function set(key, value) {
    return weak.def(validate(this, WEAK_MAP), key, value);
  }
};

// 23.3 WeakMap Objects
var $WeakMap = module.exports = __webpack_require__(80)(WEAK_MAP, wrapper, methods, weak, true, true);

// IE11 WeakMap frozen keys fix
if (fails(function () { return new $WeakMap().set((Object.freeze || Object)(tmp), 7).get(tmp) != 7; })) {
  InternalMap = weak.getConstructor(wrapper, WEAK_MAP);
  assign(InternalMap.prototype, methods);
  meta.NEED = true;
  each(['delete', 'has', 'get', 'set'], function (key) {
    var proto = $WeakMap.prototype;
    var method = proto[key];
    redefine(proto, key, function (a, b) {
      // store frozen objects on internal weakmap shim
      if (isObject(a) && !isExtensible(a)) {
        if (!this._f) this._f = new InternalMap();
        var result = this._f[key](a, b);
        return key == 'set' ? this : result;
      // store all the rest on native weakmap
      } return method.call(this, a, b);
    });
  });
}


/***/ }),
/* 153 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var redefineAll = __webpack_require__(52);
var getWeak = __webpack_require__(39).getWeak;
var anObject = __webpack_require__(2);
var isObject = __webpack_require__(5);
var anInstance = __webpack_require__(50);
var forOf = __webpack_require__(51);
var createArrayMethod = __webpack_require__(35);
var $has = __webpack_require__(20);
var validate = __webpack_require__(57);
var arrayFind = createArrayMethod(5);
var arrayFindIndex = createArrayMethod(6);
var id = 0;

// fallback for uncaught frozen keys
var uncaughtFrozenStore = function (that) {
  return that._l || (that._l = new UncaughtFrozenStore());
};
var UncaughtFrozenStore = function () {
  this.a = [];
};
var findUncaughtFrozen = function (store, key) {
  return arrayFind(store.a, function (it) {
    return it[0] === key;
  });
};
UncaughtFrozenStore.prototype = {
  get: function (key) {
    var entry = findUncaughtFrozen(this, key);
    if (entry) return entry[1];
  },
  has: function (key) {
    return !!findUncaughtFrozen(this, key);
  },
  set: function (key, value) {
    var entry = findUncaughtFrozen(this, key);
    if (entry) entry[1] = value;
    else this.a.push([key, value]);
  },
  'delete': function (key) {
    var index = arrayFindIndex(this.a, function (it) {
      return it[0] === key;
    });
    if (~index) this.a.splice(index, 1);
    return !!~index;
  }
};

module.exports = {
  getConstructor: function (wrapper, NAME, IS_MAP, ADDER) {
    var C = wrapper(function (that, iterable) {
      anInstance(that, C, NAME, '_i');
      that._t = NAME;      // collection type
      that._i = id++;      // collection id
      that._l = undefined; // leak store for uncaught frozen objects
      if (iterable != undefined) forOf(iterable, IS_MAP, that[ADDER], that);
    });
    redefineAll(C.prototype, {
      // 23.3.3.2 WeakMap.prototype.delete(key)
      // 23.4.3.3 WeakSet.prototype.delete(value)
      'delete': function (key) {
        if (!isObject(key)) return false;
        var data = getWeak(key);
        if (data === true) return uncaughtFrozenStore(validate(this, NAME))['delete'](key);
        return data && $has(data, this._i) && delete data[this._i];
      },
      // 23.3.3.4 WeakMap.prototype.has(key)
      // 23.4.3.4 WeakSet.prototype.has(value)
      has: function has(key) {
        if (!isObject(key)) return false;
        var data = getWeak(key);
        if (data === true) return uncaughtFrozenStore(validate(this, NAME)).has(key);
        return data && $has(data, this._i);
      }
    });
    return C;
  },
  def: function (that, key, value) {
    var data = getWeak(anObject(key), true);
    if (data === true) uncaughtFrozenStore(that).set(key, value);
    else data[that._i] = value;
    return that;
  },
  ufstore: uncaughtFrozenStore
};


/***/ }),
/* 154 */
/***/ (function(module, exports, __webpack_require__) {

// https://tc39.github.io/ecma262/#sec-toindex
var toInteger = __webpack_require__(33);
var toLength = __webpack_require__(11);
module.exports = function (it) {
  if (it === undefined) return 0;
  var number = toInteger(it);
  var length = toLength(number);
  if (number !== length) throw RangeError('Wrong length!');
  return length;
};


/***/ }),
/* 155 */
/***/ (function(module, exports, __webpack_require__) {

// all object keys, includes non-enumerable and symbols
var gOPN = __webpack_require__(48);
var gOPS = __webpack_require__(72);
var anObject = __webpack_require__(2);
var Reflect = __webpack_require__(3).Reflect;
module.exports = Reflect && Reflect.ownKeys || function ownKeys(it) {
  var keys = gOPN.f(anObject(it));
  var getSymbols = gOPS.f;
  return getSymbols ? keys.concat(getSymbols(it)) : keys;
};


/***/ }),
/* 156 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// https://tc39.github.io/proposal-flatMap/#sec-FlattenIntoArray
var isArray = __webpack_require__(73);
var isObject = __webpack_require__(5);
var toLength = __webpack_require__(11);
var ctx = __webpack_require__(27);
var IS_CONCAT_SPREADABLE = __webpack_require__(7)('isConcatSpreadable');

function flattenIntoArray(target, original, source, sourceLen, start, depth, mapper, thisArg) {
  var targetIndex = start;
  var sourceIndex = 0;
  var mapFn = mapper ? ctx(mapper, thisArg, 3) : false;
  var element, spreadable;

  while (sourceIndex < sourceLen) {
    if (sourceIndex in source) {
      element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];

      spreadable = false;
      if (isObject(element)) {
        spreadable = element[IS_CONCAT_SPREADABLE];
        spreadable = spreadable !== undefined ? !!spreadable : isArray(element);
      }

      if (spreadable && depth > 0) {
        targetIndex = flattenIntoArray(target, original, element, toLength(element.length), targetIndex, depth - 1) - 1;
      } else {
        if (targetIndex >= 0x1fffffffffffff) throw TypeError();
        target[targetIndex] = element;
      }

      targetIndex++;
    }
    sourceIndex++;
  }
  return targetIndex;
}

module.exports = flattenIntoArray;


/***/ }),
/* 157 */
/***/ (function(module, exports, __webpack_require__) {

// https://github.com/tc39/proposal-string-pad-start-end
var toLength = __webpack_require__(11);
var repeat = __webpack_require__(98);
var defined = __webpack_require__(32);

module.exports = function (that, maxLength, fillString, left) {
  var S = String(defined(that));
  var stringLength = S.length;
  var fillStr = fillString === undefined ? ' ' : String(fillString);
  var intMaxLength = toLength(maxLength);
  if (intMaxLength <= stringLength || fillStr == '') return S;
  var fillLen = intMaxLength - stringLength;
  var stringFiller = repeat.call(fillStr, Math.ceil(fillLen / fillStr.length));
  if (stringFiller.length > fillLen) stringFiller = stringFiller.slice(0, fillLen);
  return left ? stringFiller + S : S + stringFiller;
};


/***/ }),
/* 158 */
/***/ (function(module, exports, __webpack_require__) {

var getKeys = __webpack_require__(45);
var toIObject = __webpack_require__(21);
var isEnum = __webpack_require__(61).f;
module.exports = function (isEntries) {
  return function (it) {
    var O = toIObject(it);
    var keys = getKeys(O);
    var length = keys.length;
    var i = 0;
    var result = [];
    var key;
    while (length > i) if (isEnum.call(O, key = keys[i++])) {
      result.push(isEntries ? [key, O[key]] : O[key]);
    } return result;
  };
};


/***/ }),
/* 159 */
/***/ (function(module, exports, __webpack_require__) {

// https://github.com/DavidBruant/Map-Set.prototype.toJSON
var classof = __webpack_require__(62);
var from = __webpack_require__(160);
module.exports = function (NAME) {
  return function toJSON() {
    if (classof(this) != NAME) throw TypeError(NAME + "#toJSON isn't generic");
    return from(this);
  };
};


/***/ }),
/* 160 */
/***/ (function(module, exports, __webpack_require__) {

var forOf = __webpack_require__(51);

module.exports = function (iter, ITERATOR) {
  var result = [];
  forOf(iter, false, result.push, result, ITERATOR);
  return result;
};


/***/ }),
/* 161 */
/***/ (function(module, exports) {

// https://rwaldron.github.io/proposal-math-extensions/
module.exports = Math.scale || function scale(x, inLow, inHigh, outLow, outHigh) {
  if (
    arguments.length === 0
      // eslint-disable-next-line no-self-compare
      || x != x
      // eslint-disable-next-line no-self-compare
      || inLow != inLow
      // eslint-disable-next-line no-self-compare
      || inHigh != inHigh
      // eslint-disable-next-line no-self-compare
      || outLow != outLow
      // eslint-disable-next-line no-self-compare
      || outHigh != outHigh
  ) return NaN;
  if (x === Infinity || x === -Infinity) return x;
  return (x - inLow) * (outHigh - outLow) / (inHigh - inLow) + outLow;
};


/***/ }),
/* 162 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(process, __dirname, Buffer) {module.exports = function(Module) {
  Module = Module || {};

var Module;if(!Module)Module=(typeof ZXing!=="undefined"?ZXing:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_NODE=typeof process==="object"&&"function"==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=__webpack_require__(163);var nodePath=__webpack_require__(164);Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(true){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){DYNAMICTOP=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};var sourceRegex=/^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){funcstr+="var stack = "+JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"="+convertCode.returnValue+";"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){funcstr+=JSsource["stackRestore"].body.replace("()","(stack)")+";"}funcstr+="return ret})";return eval(funcstr)}}))();Module["ccall"]=ccall;Module["cwrap"]=cwrap;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(typeof _sbrk!=="undefined"&&!_sbrk.called||!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<2)return 0;maxBytesToWrite-=2;var startPtr=outPtr;var numCharsToWrite=maxBytesToWrite<str.length*2?maxBytesToWrite/2:str.length;for(var i=0;i<numCharsToWrite;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr>>1]=codeUnit;outPtr+=2}HEAP16[outPtr>>1]=0;return outPtr-startPtr}Module["stringToUTF16"]=stringToUTF16;function lengthBytesUTF16(str){return str.length*2}Module["lengthBytesUTF16"]=lengthBytesUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<4)return 0;var startPtr=outPtr;var endPtr=startPtr+maxBytesToWrite-4;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++i);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr>>2]=codeUnit;outPtr+=4;if(outPtr+4>endPtr)break}HEAP32[outPtr>>2]=0;return outPtr-startPtr}Module["stringToUTF32"]=stringToUTF32;function lengthBytesUTF32(str){var len=0;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343)++i;len+=4}return len}Module["lengthBytesUTF32"]=lengthBytesUTF32;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}var parsed=func;try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}parsed=parse()}catch(e){parsed+="?"}if(parsed.indexOf("?")>=0&&!hasLibcxxabi){Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")}return parsed}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;var PAGE_SIZE=4096;function alignMemoryPage(x){if(x%4096>0){x+=4096-x%4096}return x}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which adjusts the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function enlargeMemory(){abortOnCannotGrowMemory()}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||16777216;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer;buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var ASM_CONSTS=[];STATIC_BASE=8;STATICTOP=STATIC_BASE+62208;__ATINIT__.push({func:(function(){__GLOBAL__sub_I_zxing_js_cpp()})},{func:(function(){__GLOBAL__sub_I_CharacterSetECI_cpp()})},{func:(function(){__GLOBAL__sub_I_GlobalHistogramBinarizer_cpp()})},{func:(function(){__GLOBAL__sub_I_GenericGF_cpp()})},{func:(function(){__GLOBAL__sub_I_Version_cpp()})},{func:(function(){__GLOBAL__sub_I_DecodeHints_cpp()})},{func:(function(){__GLOBAL__sub_I_Code39Reader_cpp()})},{func:(function(){__GLOBAL__sub_I_Code93Reader_cpp()})},{func:(function(){__GLOBAL__sub_I_ITFReader_cpp()})},{func:(function(){__GLOBAL__sub_I_UPCEANReader_cpp()})},{func:(function(){__GLOBAL__sub_I_UPCEReader_cpp()})},{func:(function(){__GLOBAL__sub_I_DecodedBitStreamParser_cpp()})},{func:(function(){__GLOBAL__sub_I_ModulusGF_cpp()})},{func:(function(){__GLOBAL__sub_I_LinesSampler_cpp()})},{func:(function(){__GLOBAL__sub_I_DataMask_cpp()})},{func:(function(){__GLOBAL__sub_I_Mode_cpp()})},{func:(function(){__GLOBAL__sub_I_ErrorCorrectionLevel_cpp()})},{func:(function(){__GLOBAL__sub_I_Version_cpp733()})},{func:(function(){__GLOBAL__sub_I_bind_cpp()})});allocate([4,138,0,0,254,176,0,0,0,7,0,0,0,0,0,0,4,138,0,0,228,176,0,0,8,0,0,0,0,0,0,0,4,138,0,0,17,177,0,0,96,1,0,0,0,0,0,0,220,137,0,0,58,177,0,0,4,138,0,0,37,177,0,0,56,0,0,0,0,0,0,0,4,138,0,0,75,177,0,0,56,0,0,0,0,0,0,0,4,138,0,0,93,177,0,0,56,0,0,0,0,0,0,0,4,138,0,0,140,177,0,0,40,3,0,0,0,0,0,0,4,138,0,0,168,177,0,0,56,0,0,0,0,0,0,0,4,138,0,0,187,177,0,0,56,0,0,0,0,0,0,0,4,138,0,0,210,177,0,0,24,0,0,0,0,0,0,0,4,138,0,0,238,177,0,0,56,0,0,0,0,0,0,0,4,138,0,0,0,178,0,0,56,0,0,0,0,0,0,0,4,138,0,0,20,178,0,0,128,0,0,0,0,0,0,0,4,138,0,0,56,178,0,0,208,0,0,0,0,0,0,0,4,138,0,0,82,178,0,0,8,0,0,0,0,0,0,0,4,138,0,0,117,178,0,0,8,0,0,0,0,0,0,0,4,138,0,0,148,178,0,0,40,3,0,0,0,0,0,0,4,138,0,0,70,179,0,0,56,0,0,0,0,0,0,0,4,138,0,0,100,179,0,0,56,0,0,0,0,0,0,0,4,138,0,0,129,179,0,0,24,0,0,0,0,0,0,0,4,138,0,0,155,179,0,0,96,1,0,0,0,0,0,0,4,138,0,0,189,179,0,0,56,0,0,0,0,0,0,0,4,138,0,0,215,179,0,0,128,1,0,0,0,0,0,0,4,138,0,0,4,180,0,0,56,0,0,0,0,0,0,0,4,138,0,0,42,180,0,0,248,2,0,0,0,0,0,0,44,138,0,0,72,180,0,0,0,0,0,0,1,0,0,0,144,3,0,0,0,4,0,0,44,138,0,0,113,180,0,0,1,0,0,0,2,0,0,0,8,3,0,0,2,0,0,0,128,1,0,0,2,12,0,0,4,138,0,0,147,180,0,0,40,3,0,0,0,0,0,0,4,138,0,0,175,180,0,0,120,2,0,0,0,0,0,0,4,138,0,0,204,180,0,0,120,2,0,0,0,0,0,0,4,138,0,0,233,180,0,0,120,2,0,0,0,0,0,0,4,138,0,0,5,181,0,0,120,2,0,0,0,0,0,0,4,138,0,0,33,181,0,0,152,2,0,0,0,0,0,0,4,138,0,0,60,181,0,0,152,2,0,0,0,0,0,0,4,138,0,0,86,181,0,0,120,2,0,0,0,0,0,0,4,138,0,0,110,181,0,0,120,2,0,0,0,0,0,0,4,138,0,0,147,181,0,0,120,2,0,0,0,0,0,0,4,138,0,0,186,181,0,0,40,3,0,0,0,0,0,0,4,138,0,0,212,181,0,0,152,2,0,0,0,0,0,0,4,138,0,0,238,181,0,0,120,2,0,0,0,0,0,0,4,138,0,0,10,182,0,0,152,2,0,0,0,0,0,0,4,138,0,0,90,182,0,0,56,0,0,0,0,0,0,0,4,138,0,0,130,182,0,0,40,3,0,0,0,0,0,0,4,138,0,0,160,182,0,0,56,0,0,0,0,0,0,0,4,138,0,0,230,182,0,0,56,0,0,0,0,0,0,0,4,138,0,0,14,183,0,0,56,0,0,0,0,0,0,0,4,138,0,0,39,183,0,0,40,3,0,0,0,0,0,0,4,138,0,0,69,183,0,0,56,0,0,0,0,0,0,0,4,138,0,0,93,183,0,0,56,0,0,0,0,0,0,0,4,138,0,0,109,183,0,0,56,0,0,0,0,0,0,0,4,138,0,0,125,183,0,0,56,0,0,0,0,0,0,0,4,138,0,0,98,206,0,0,24,0,0,0,0,0,0,0,4,138,0,0,89,202,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,138,0,0,235,200,0,0,0,0,0,0,240,0,0,0,220,137,0,0,98,198,0,0,4,138,0,0,32,199,0,0,56,0,0,0,0,0,0,0,4,138,0,0,67,199,0,0,56,0,0,0,0,0,0,0,4,138,0,0,102,199,0,0,72,3,0,0,0,0,0,0,4,138,0,0,133,199,0,0,72,3,0,0,0,0,0,0,4,138,0,0,167,199,0,0,56,0,0,0,0,0,0,0,4,138,0,0,200,199,0,0,216,2,0,0,0,0,0,0,4,138,0,0,229,199,0,0,216,2,0,0,0,0,0,0,4,138,0,0,2,200,0,0,216,2,0,0,0,0,0,0,4,138,0,0,31,200,0,0,216,2,0,0,0,0,0,0,4,138,0,0,60,200,0,0,216,2,0,0,0,0,0,0,4,138,0,0,89,200,0,0,216,2,0,0,0,0,0,0,4,138,0,0,118,200,0,0,216,2,0,0,0,0,0,0,4,138,0,0,147,200,0,0,216,2,0,0,0,0,0,0,4,138,0,0,176,200,0,0,56,0,0,0,0,0,0,0,4,138,0,0,202,200,0,0,56,0,0,0,0,0,0,0,4,138,0,0,15,201,0,0,56,0,0,0,0,0,0,0,4,138,0,0,59,201,0,0,56,0,0,0,0,0,0,0,4,138,0,0,91,201,0,0,56,0,0,0,0,0,0,0,4,138,0,0,120,201,0,0,56,0,0,0,0,0,0,0,4,138,0,0,161,201,0,0,72,3,0,0,0,0,0,0,4,138,0,0,192,201,0,0,56,0,0,0,0,0,0,0,4,138,0,0,241,201,0,0,56,0,0,0,0,0,0,0,4,138,0,0,4,202,0,0,56,0,0,0,0,0,0,0,4,138,0,0,35,202,0,0,56,0,0,0,0,0,0,0,4,138,0,0,73,202,0,0,56,0,0,0,0,0,0,0,4,138,0,0,121,202,0,0,56,0,0,0,0,0,0,0,4,138,0,0,145,202,0,0,56,0,0,0,0,0,0,0,4,138,0,0,164,202,0,0,56,0,0,0,0,0,0,0,4,138,0,0,195,202,0,0,56,0,0,0,0,0,0,0,4,138,0,0,220,202,0,0,56,0,0,0,0,0,0,0,4,138,0,0,248,202,0,0,56,0,0,0,0,0,0,0,4,138,0,0,16,203,0,0,56,0,0,0,0,0,0,0,4,138,0,0,75,205,0,0,72,8,0,0,0,0,0,0,4,138,0,0,141,205,0,0,80,8,0,0,0,0,0,0,4,138,0,0,250,205,0,0,56,0,0,0,0,0,0,0,4,138,0,0,15,206,0,0,56,0,0,0,0,0,0,0,4,138,0,0,33,206,0,0,56,0,0,0,0,0,0,0,4,138,0,0,77,206,0,0,56,0,0,0,0,0,0,0,4,138,0,0,126,206,0,0,56,0,0,0,0,0,0,0,4,138,0,0,190,207,0,0,56,0,0,0,0,0,0,0,4,138,0,0,213,207,0,0,56,0,0,0,0,0,0,0,4,138,0,0,237,207,0,0,88,5,0,0,0,0,0,0,44,138,0,0,207,213,0,0,0,0,0,0,1,0,0,0,232,6,0,0,0,0,0,0,44,138,0,0,144,213,0,0,0,0,0,0,1,0,0,0,232,6,0,0,0,0,0,0,44,138,0,0,43,213,0,0,0,0,0,0,1,0,0,0,232,6,0,0,0,0,0,0,220,137,0,0,24,213,0,0,220,137,0,0,249,212,0,0,220,137,0,0,32,212,0,0,220,137,0,0,1,212,0,0,220,137,0,0,226,211,0,0,220,137,0,0,195,211,0,0,220,137,0,0,164,211,0,0,220,137,0,0,63,212,0,0,220,137,0,0,94,212,0,0,220,137,0,0,125,212,0,0,220,137,0,0,156,212,0,0,220,137,0,0,187,212,0,0,220,137,0,0,218,212,0,0,220,137,0,0,106,213,0,0,4,138,0,0,14,214,0,0,0,7,0,0,0,0,0,0,220,137,0,0,27,214,0,0,4,138,0,0,40,214,0,0,0,7,0,0,0,0,0,0,220,137,0,0,58,214,0,0,4,138,0,0,71,214,0,0,0,7,0,0,0,0,0,0,4,138,0,0,83,214,0,0,24,7,0,0,0,0,0,0,4,138,0,0,116,214,0,0,48,7,0,0,0,0,0,0,4,138,0,0,186,214,0,0,48,7,0,0,0,0,0,0,4,138,0,0,150,214,0,0,80,7,0,0,0,0,0,0,4,138,0,0,220,214,0,0,48,7,0,0,0,0,0,0,192,137,0,0,122,207,0,0,192,137,0,0,4,215,0,0,192,137,0,0,84,207,0,0,192,137,0,0,86,207,0,0,84,138,0,0,7,215,0,0,1,0,0,0,152,7,0,0,192,137,0,0,96,207,0,0,192,137,0,0,82,207,0,0,192,137,0,0,116,207,0,0,192,137,0,0,118,207,0,0,192,137,0,0,98,207,0,0,192,137,0,0,100,207,0,0,192,137,0,0,68,239,0,0,192,137,0,0,104,207,0,0,192,137,0,0,92,207,0,0,192,137,0,0,88,207,0,0,4,138,0,0,11,215,0,0,64,7,0,0,0,0,0,0,4,138,0,0,48,215,0,0,64,7,0,0,0,0,0,0,4,138,0,0,192,232,0,0,120,15,0,0,0,0,0,0,220,137,0,0,218,232,0,0,4,138,0,0,236,232,0,0,48,8,0,0,0,0,0,0,220,137,0,0,22,233,0,0,44,138,0,0,71,233,0,0,0,0,0,0,1,0,0,0,56,8,0,0,3,244,255,255,4,138,0,0,118,233,0,0,144,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,138,0,0,242,233,0,0,112,15,0,0,0,0,0,0,44,138,0,0,8,234,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,160,14,0,0,2,0,0,0,44,138,0,0,26,234,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,168,14,0,0,2,0,0,0,44,138,0,0,60,234,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,168,14,0,0,2,0,0,0,44,138,0,0,95,234,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,168,14,0,0,2,0,0,0,4,138,0,0,130,234,0,0,240,8,0,0,0,0,0,0,4,138,0,0,164,234,0,0,240,8,0,0,0,0,0,0,44,138,0,0,199,234,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,168,14,0,0,2,0,0,0,4,138,0,0,233,234,0,0,128,8,0,0,0,0,0,0,4,138,0,0,255,234,0,0,128,8,0,0,0,0,0,0,4,138,0,0,19,235,0,0,128,8,0,0,0,0,0,0,44,138,0,0,39,235,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,160,14,0,0,2,0,0,0,4,138,0,0,57,235,0,0,128,8,0,0,0,0,0,0,4,138,0,0,78,235,0,0,128,8,0,0,0,0,0,0,44,138,0,0,99,235,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,176,14,0,0,0,0,0,0,44,138,0,0,167,235,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,200,14,0,0,0,0,0,0,44,138,0,0,235,235,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,224,14,0,0,0,0,0,0,44,138,0,0,47,236,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,248,14,0,0,0,0,0,0,44,138,0,0,115,236,0,0,0,0,0,0,3,0,0,0,128,8,0,0,2,0,0,0,16,15,0,0,2,0,0,0,24,15,0,0,0,8,0,0,44,138,0,0,184,236,0,0,0,0,0,0,3,0,0,0,128,8,0,0,2,0,0,0,16,15,0,0,2,0,0,0,32,15,0,0,0,8,0,0,44,138,0,0,253,236,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,40,15,0,0,0,8,0,0,44,138,0,0,66,237,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,40,15,0,0,0,8,0,0,44,138,0,0,135,237,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,48,15,0,0,2,0,0,0,44,138,0,0,163,237,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,48,15,0,0,2,0,0,0,44,138,0,0,191,237,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,48,15,0,0,2,0,0,0,44,138,0,0,219,237,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,48,15,0,0,2,0,0,0,44,138,0,0,247,237,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,56,15,0,0,0,0,0,0,44,138,0,0,61,238,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,64,15,0,0,0,0,0,0,44,138,0,0,131,238,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,72,15,0,0,0,0,0,0,44,138,0,0,201,238,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,80,15,0,0,0,0,0,0,44,138,0,0,15,239,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,88,15,0,0,2,0,0,0,44,138,0,0,36,239,0,0,0,0,0,0,2,0,0,0,128,8,0,0,2,0,0,0,88,15,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,137,0,0,128,242,0,0,220,137,0,0,105,242,0,0,44,138,0,0,83,242,0,0,0,0,0,0,1,0,0,0,104,15,0,0,0,0,0,0,44,138,0,0,36,242,0,0,0,0,0,0,1,0,0,0,104,15,0,0,0,0,0,0,44,138,0,0,14,242,0,0,0,0,0,0,1,0,0,0,96,15,0,0,0,0,0,0,44,138,0,0,223,241,0,0,0,0,0,0,1,0,0,0,96,15,0,0,0,0,0,0,220,137,0,0,204,241,0,0,220,137,0,0,170,241,0,0,220,137,0,0,136,241,0,0,220,137,0,0,115,241,0,0,220,137,0,0,94,241,0,0,220,137,0,0,69,241,0,0,220,137,0,0,44,241,0,0,220,137,0,0,19,241,0,0,220,137,0,0,250,240,0,0,220,137,0,0,226,240,0,0,220,137,0,0,245,241,0,0,220,137,0,0,58,242,0,0,220,137,0,0,149,242,0,0,4,138,0,0,174,242,0,0,8,7,0,0,0,0,0,0,220,137,0,0,197,242,0,0,4,138,0,0,222,242,0,0,136,15,0,0,0,0,0,0,0,0,0,0,40,0,0,0,42,0,0,0,43,0,0,0,42,0,0,0,42,0,0,0,42,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,44,0,0,0,45,0,0,0,0,0,0,0,80,0,0,0,46,0,0,0,47,0,0,0,0,0,0,0,96,0,0,0,48,0,0,0,49,0,0,0,0,0,0,0,112,0,0,0,50,0,0,0,51,0,0,0,42,0,0,0,42,0,0,0,0,0,0,0,128,0,0,0,52,0,0,0,53,0,0,0,42,0,0,0,42,0,0,0,42,0,0,0,0,0,0,0,144,0,0,0,54,0,0,0,55,0,0,0,0,0,0,0,160,0,0,0,56,0,0,0,57,0,0,0,46,0,0,0,0,0,0,0,176,0,0,0,58,0,0,0,59,0,0,0,0,0,0,0,192,0,0,0,60,0,0,0,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,0,0,1,0,0,0,0,0,0,0,208,0,0,0,62,0,0,0,63,0,0,0,43,0,0,0,47,0,0,0,43,0,0,0,0,0,0,0,224,0,0,0,64,0,0,0,65,0,0,0,43,0,0,0,48,0,0,0,44,0,0,0,0,0,0,0,240,0,0,0,66,0,0,0,67,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,68,0,0,0,69,0,0,0,46,0,0,0,94,203,0,0,0,0,0,0,16,1,0,0,70,0,0,0,71,0,0,0,45,0,0,0,44,0,0,0,0,0,0,0,32,1,0,0,72,0,0,0,73,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,1,0,0,74,0,0,0,75,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,1,0,0,76,0,0,0,77,0,0,0,46,0,0,0,0,0,0,0,80,1,0,0,78,0,0,0,79,0,0,0,43,0,0,0,43,0,0,0,49,0,0,0,43,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,0,0,0,0,96,1,0,0,80,0,0,0,81,0,0,0,42,0,0,0,42,0,0,0,42,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,0,0,0,0,112,1,0,0,82,0,0,0,83,0,0,0,42,0,0,0,44,0,0,0,0,0,0,0,144,1,0,0,84,0,0,0,85,0,0,0,42,0,0,0,43,0,0,0,0,0,0,0,160,1,0,0,86,0,0,0,87,0,0,0,44,0,0,0,0,0,0,0,184,1,0,0,88,0,0,0,89,0,0,0,45,0,0,0,45,0,0,0,45,0,0,0,244,255,255,255,184,1,0,0,90,0,0,0,91,0,0,0,42,0,0,0,46,0,0,0,0,0,0,0,216,1,0,0,92,0,0,0,93,0,0,0,46,0,0,0,46,0,0,0,0,0,0,0,232,1,0,0,94,0,0,0,95,0,0,0,45,0,0,0,47,0,0,0,48,0,0,0,0,0,0,0,248,1,0,0,96,0,0,0,97,0,0,0,45,0,0,0,47,0,0,0,49,0,0,0,0,0,0,0,8,2,0,0,98,0,0,0,99,0,0,0,45,0,0,0,47,0,0,0,50,0,0,0,0,0,0,0,24,2,0,0,100,0,0,0,101,0,0,0,45,0,0,0,47,0,0,0,51,0,0,0,0,0,0,0,40,2,0,0,102,0,0,0,103,0,0,0,45,0,0,0,47,0,0,0,52,0,0,0,47,0,0,0,42,0,0,0,43,0,0,0,47,0,0,0,53,0,0,0,0,0,0,0,56,2,0,0,104,0,0,0,105,0,0,0,45,0,0,0,47,0,0,0,52,0,0,0,47,0,0,0,44,0,0,0,43,0,0,0,47,0,0,0,54,0,0,0,0,0,0,0,72,2,0,0,106,0,0,0,107,0,0,0,45,0,0,0,47,0,0,0,53,0,0,0,0,0,0,0,88,2,0,0,108,0,0,0,109,0,0,0,45,0,0,0,47,0,0,0,54,0,0,0,0,0,0,0,104,2,0,0,110,0,0,0,111,0,0,0,45,0,0,0,47,0,0,0,55,0,0,0,0,0,0,0,120,2,0,0,112,0,0,0,113,0,0,0,45,0,0,0,47,0,0,0,42,0,0,0,0,0,0,0,136,2,0,0,114,0,0,0,115,0,0,0,45,0,0,0,56,0,0,0,57,0,0,0,47,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,2,0,0,116,0,0,0,117,0,0,0,45,0,0,0,47,0,0,0,52,0,0,0,47,0,0,0,42,0,0,0,43,0,0,0,47,0,0,0,42,0,0,0,0,0,0,0,168,2,0,0,118,0,0,0,119,0,0,0,45,0,0,0,47,0,0,0,52,0,0,0,48,0,0,0,47,0,0,0,43,0,0,0,48,0,0,0,56,0,0,0,227,10,0,0,94,2,1,0,122,2,1,0,158,2,1,0,188,2,1,0,242,2,1,0,244,2,1,0,46,3,1,0,78,3,1,0,92,3,1,0,150,3,1,0,166,3,1,0,172,3,1,0,34,4,1,0,40,4,1,0,54,4,1,0,66,4,1,0,68,4,1,0,72,4,1,0,80,4,1,0,94,4,1,0,102,4,1,0,108,4,1,0,122,4,1,0,130,4,1,0,158,4,1,0,160,4,1,0,188,4,1,0,198,4,1,0,216,4,1,0,238,4,1,0,242,4,1,0,244,4,1,0,4,5,1,0,8,5,1,0,16,5,1,0,30,5,1,0,32,5,1,0,60,5,1,0,64,5,1,0,120,5,1,0,134,5,1,0,140,5,1,0,152,5,1,0,176,5,1,0,190,5,1,0,206,5,1,0,220,5,1,0,226,5,1,0,228,5,1,0,232,5,1,0,246,5,1,0,46,6,1,0,78,6,1,0,92,6,1,0,142,6,1,0,156,6,1,0,184,6,1,0,222,6,1,0,250,6,1,0,22,7,1,0,38,7,1,0,44,7,1,0,70,7,1,0,76,7,1,0,88,7,1,0,110,7,1,0,146,7,1,0,148,7,1,0,162,7,1,0,164,7,1,0,168,7,1,0,182,7,1,0,34,8,1,0,40,8,1,0,66,8,1,0,72,8,1,0,80,8,1,0,94,8,1,0,102,8,1,0,108,8,1,0,122,8,1,0,130,8,1,0,132,8,1,0,144,8,1,0,158,8,1,0,160,8,1,0,188,8,1,0,198,8,1,0,204,8,1,0,216,8,1,0,238,8,1,0,242,8,1,0,244,8,1,0,2,9,1,0,8,9,1,0,30,9,1,0,32,9,1,0,60,9,1,0,64,9,1,0,120,9,1,0,134,9,1,0,152,9,1,0,176,9,1,0,190,9,1,0,206,9,1,0,220,9,1,0,226,9,1,0,228,9,1,0,232,9,1,0,246,9,1,0,8,10,1,0,16,10,1,0,30,10,1,0,32,10,1,0,60,10,1,0,64,10,1,0,120,10,1,0,240,10,1,0,6,11,1,0,12,11,1,0,24,11,1,0,48,11,1,0,62,11,1,0,96,11,1,0,124,11,1,0,142,11,1,0,156,11,1,0,184,11,1,0,194,11,1,0,196,11,1,0,200,11,1,0,208,11,1,0,222,11,1,0,230,11,1,0,236,11,1,0,46,12,1,0,78,12,1,0,92,12,1,0,98,12,1,0,100,12,1,0,104,12,1,0,118,12,1,0,142,12,1,0,156,12,1,0,184,12,1,0,194,12,1,0,196,12,1,0,200,12,1,0,208,12,1,0,222,12,1,0,230,12,1,0,236,12,1,0,250,12,1,0,14,13,1,0,28,13,1,0,56,13,1,0,112,13,1,0,126,13,1,0,130,13,1,0,132,13,1,0,136,13,1,0,144,13,1,0,158,13,1,0,160,13,1,0,188,13,1,0,198,13,1,0,204,13,1,0,216,13,1,0,238,13,1,0,242,13,1,0,244,13,1,0,22,14,1,0,38,14,1,0,44,14,1,0,70,14,1,0,88,14,1,0,110,14,1,0,134,14,1,0,140,14,1,0,152,14,1,0,176,14,1,0,190,14,1,0,206,14,1,0,220,14,1,0,10,15,1,0,18,15,1,0,20,15,1,0,34,15,1,0,40,15,1,0,54,15,1,0,66,15,1,0,68,15,1,0,72,15,1,0,80,15,1,0,94,15,1,0,102,15,1,0,108,15,1,0,178,15,1,0,180,15,1,0,34,16,1,0,40,16,1,0,66,16,1,0,72,16,1,0,80,16,1,0,94,16,1,0,122,16,1,0,130,16,1,0,132,16,1,0,144,16,1,0,158,16,1,0,160,16,1,0,188,16,1,0,198,16,1,0,204,16,1,0,216,16,1,0,238,16,1,0,242,16,1,0,244,16,1,0,2,17,1,0,30,17,1,0,32,17,1,0,60,17,1,0,64,17,1,0,120,17,1,0,134,17,1,0,152,17,1,0,176,17,1,0,190,17,1,0,206,17,1,0,220,17,1,0,226,17,1,0,228,17,1,0,232,17,1,0,246,17,1,0,8,18,1,0,30,18,1,0,32,18,1,0,120,18,1,0,240,18,1,0,12,19,1,0,48,19,1,0,62,19,1,0,96,19,1,0,124,19,1,0,142,19,1,0,156,19,1,0,184,19,1,0,194,19,1,0,200,19,1,0,208,19,1,0,222,19,1,0,230,19,1,0,236,19,1,0,8,20,1,0,16,20,1,0,30,20,1,0,32,20,1,0,60,20,1,0,64,20,1,0,120,20,1,0,240,20,1,0,224,21,1,0,12,22,1,0,24,22,1,0,48,22,1,0,62,22,1,0,96,22,1,0,124,22,1,0,192,22,1,0,248,22,1,0,28,23,1,0,56,23,1,0,112,23,1,0,126,23,1,0,130,23,1,0,132,23,1,0,136,23,1,0,144,23,1,0,158,23,1,0,160,23,1,0,188,23,1,0,198,23,1,0,204,23,1,0,216,23,1,0,238,23,1,0,46,24,1,0,52,24,1,0,78,24,1,0,92,24,1,0,98,24,1,0,100,24,1,0,104,24,1,0,118,24,1,0,142,24,1,0,156,24,1,0,184,24,1,0,194,24,1,0,200,24,1,0,208,24,1,0,222,24,1,0,230,24,1,0,236,24,1,0,250,24,1,0,14,25,1,0,28,25,1,0,56,25,1,0,112,25,1,0,126,25,1,0,130,25,1,0,132,25,1,0,144,25,1,0,158,25,1,0,160,25,1,0,188,25,1,0,198,25,1,0,204,25,1,0,216,25,1,0,238,25,1,0,242,25,1,0,244,25,1,0,14,26,1,0,28,26,1,0,56,26,1,0,112,26,1,0,126,26,1,0,224,26,1,0,252,26,1,0,8,27,1,0,16,27,1,0,30,27,1,0,32,27,1,0,60,27,1,0,64,27,1,0,120,27,1,0,140,27,1,0,152,27,1,0,176,27,1,0,190,27,1,0,206,27,1,0,220,27,1,0,226,27,1,0,228,27,1,0,232,27,1,0,246,27,1,0,22,28,1,0,38,28,1,0,44,28,1,0,70,28,1,0,76,28,1,0,88,28,1,0,110,28,1,0,134,28,1,0,152,28,1,0,176,28,1,0,190,28,1,0,206,28,1,0,220,28,1,0,226,28,1,0,228,28,1,0,232,28,1,0,246,28,1,0,6,29,1,0,12,29,1,0,24,29,1,0,48,29,1,0,62,29,1,0,96,29,1,0,124,29,1,0,142,29,1,0,156,29,1,0,184,29,1,0,196,29,1,0,200,29,1,0,208,29,1,0,222,29,1,0,230,29,1,0,236,29,1,0,250,29,1,0,10,30,1,0,18,30,1,0,20,30,1,0,34,30,1,0,36,30,1,0,40,30,1,0,54,30,1,0,66,30,1,0,68,30,1,0,80,30,1,0,94,30,1,0,102,30,1,0,108,30,1,0,130,30,1,0,132,30,1,0,136,30,1,0,144,30,1,0,158,30,1,0,160,30,1,0,188,30,1,0,198,30,1,0,204,30,1,0,216,30,1,0,238,30,1,0,26,31,1,0,46,31,1,0,50,31,1,0,52,31,1,0,78,31,1,0,92,31,1,0,98,31,1,0,100,31,1,0,104,31,1,0,118,31,1,0,72,32,1,0,94,32,1,0,130,32,1,0,132,32,1,0,144,32,1,0,158,32,1,0,160,32,1,0,188,32,1,0,216,32,1,0,242,32,1,0,244,32,1,0,8,33,1,0,30,33,1,0,32,33,1,0,60,33,1,0,64,33,1,0,120,33,1,0,134,33,1,0,152,33,1,0,176,33,1,0,190,33,1,0,226,33,1,0,228,33,1,0,232,33,1,0,246,33,1,0,4,34,1,0,16,34,1,0,30,34,1,0,32,34,1,0,120,34,1,0,240,34,1,0,6,35,1,0,12,35,1,0,48,35,1,0,62,35,1,0,96,35,1,0,124,35,1,0,142,35,1,0,156,35,1,0,184,35,1,0,194,35,1,0,200,35,1,0,208,35,1,0,230,35,1,0,236,35,1,0,30,36,1,0,32,36,1,0,60,36,1,0,240,36,1,0,224,37,1,0,24,38,1,0,62,38,1,0,96,38,1,0,124,38,1,0,192,38,1,0,248,38,1,0,56,39,1,0,112,39,1,0,126,39,1,0,130,39,1,0,132,39,1,0,144,39,1,0,158,39,1,0,160,39,1,0,188,39,1,0,198,39,1,0,204,39,1,0,216,39,1,0,238,39,1,0,32,40,1,0,60,40,1,0,64,40,1,0,120,40,1,0,240,40,1,0,224,41,1,0,192,43,1,0,24,44,1,0,48,44,1,0,62,44,1,0,96,44,1,0,124,44,1,0,192,44,1,0,248,44,1,0,240,45,1,0,28,46,1,0,56,46,1,0,112,46,1,0,126,46,1,0,224,46,1,0,252,46,1,0,4,47,1,0,8,47,1,0,16,47,1,0,32,47,1,0,60,47,1,0,64,47,1,0,120,47,1,0,134,47,1,0,140,47,1,0,152,47,1,0,176,47,1,0,190,47,1,0,206,47,1,0,220,47,1,0,46,48,1,0,78,48,1,0,92,48,1,0,98,48,1,0,104,48,1,0,142,48,1,0,156,48,1,0,184,48,1,0,194,48,1,0,200,48,1,0,208,48,1,0,222,48,1,0,236,48,1,0,250,48,1,0,14,49,1,0,56,49,1,0,112,49,1,0,126,49,1,0,130,49,1,0,132,49,1,0,144,49,1,0,158,49,1,0,160,49,1,0,188,49,1,0,198,49,1,0,204,49,1,0,216,49,1,0,242,49,1,0,244,49,1,0,14,50,1,0,28,50,1,0,112,50,1,0,126,50,1,0,224,50,1,0,252,50,1,0,8,51,1,0,30,51,1,0,32,51,1,0,60,51,1,0,64,51,1,0,120,51,1,0,134,51,1,0,152,51,1,0,176,51,1,0,190,51,1,0,206,51,1,0,220,51,1,0,226,51,1,0,228,51,1,0,232,51,1,0,246,51,1,0,14,52,1,0,28,52,1,0,56,52,1,0,112,52,1,0,126,52,1,0,224,52,1,0,252,52,1,0,192,53,1,0,248,53,1,0,8,54,1,0,16,54,1,0,30,54,1,0,32,54,1,0,60,54,1,0,64,54,1,0,120,54,1,0,240,54,1,0,12,55,1,0,24,55,1,0,48,55,1,0,62,55,1,0,96,55,1,0,124,55,1,0,156,55,1,0,184,55,1,0,194,55,1,0,196,55,1,0,200,55,1,0,208,55,1,0,222,55,1,0,230,55,1,0,236,55,1,0,22,56,1,0,38,56,1,0,44,56,1,0,70,56,1,0,76,56,1,0,88,56,1,0,110,56,1,0,116,56,1,0,134,56,1,0,152,56,1,0,176,56,1,0,190,56,1,0,206,56,1,0,220,56,1,0,226,56,1,0,228,56,1,0,232,56,1,0,6,57,1,0,12,57,1,0,48,57,1,0,62,57,1,0,96,57,1,0,124,57,1,0,142,57,1,0,156,57,1,0,184,57,1,0,200,57,1,0,208,57,1,0,222,57,1,0,230,57,1,0,236,57,1,0,250,57,1,0,6,58,1,0,12,58,1,0,24,58,1,0,48,58,1,0,62,58,1,0,96,58,1,0,124,58,1,0,192,58,1,0,248,58,1,0,14,59,1,0,28,59,1,0,56,59,1,0,112,59,1,0,126,59,1,0,136,59,1,0,144,59,1,0,158,59,1,0,160,59,1,0,188,59,1,0,204,59,1,0,216,59,1,0,238,59,1,0,242,59,1,0,244,59,1,0,18,60,1,0,20,60,1,0,34,60,1,0,36,60,1,0,40,60,1,0,54,60,1,0,66,60,1,0,72,60,1,0,80,60,1,0,94,60,1,0,102,60,1,0,108,60,1,0,130,60,1,0,132,60,1,0,144,60,1,0,158,60,1,0,160,60,1,0,188,60,1,0,198,60,1,0,204,60,1,0,216,60,1,0,238,60,1,0,2,61,1,0,4,61,1,0,8,61,1,0,16,61,1,0,30,61,1,0,32,61,1,0,60,61,1,0,64,61,1,0,120,61,1,0,134,61,1,0,140,61,1,0,152,61,1,0,176,61,1,0,190,61,1,0,206,61,1,0,220,61,1,0,228,61,1,0,232,61,1,0,246,61,1,0,26,62,1,0,46,62,1,0,50,62,1,0,52,62,1,0,78,62,1,0,92,62,1,0,98,62,1,0,100,62,1,0,104,62,1,0,118,62,1,0,142,62,1,0,156,62,1,0,184,62,1,0,194,62,1,0,196,62,1,0,200,62,1,0,208,62,1,0,222,62,1,0,230,62,1,0,236,62,1,0,38,63,1,0,44,63,1,0,58,63,1,0,70,63,1,0,76,63,1,0,88,63,1,0,110,63,1,0,114,63,1,0,116,63,1,0,130,64,1,0,158,64,1,0,160,64,1,0,188,64,1,0,4,65,1,0,8,65,1,0,16,65,1,0,30,65,1,0,32,65,1,0,60,65,1,0,64,65,1,0,120,65,1,0,140,65,1,0,152,65,1,0,176,65,1,0,190,65,1,0,226,65,1,0,228,65,1,0,232,65,1,0,8,66,1,0,16,66,1,0,30,66,1,0,32,66,1,0,60,66,1,0,64,66,1,0,120,66,1,0,240,66,1,0,6,67,1,0,12,67,1,0,24,67,1,0,48,67,1,0,62,67,1,0,96,67,1,0,124,67,1,0,142,67,1,0,194,67,1,0,196,67,1,0,200,67,1,0,208,67,1,0,230,67,1,0,236,67,1,0,8,68,1,0,16,68,1,0,30,68,1,0,32,68,1,0,60,68,1,0,64,68,1,0,120,68,1,0,240,68,1,0,224,69,1,0,12,70,1,0,24,70,1,0,48,70,1,0,62,70,1,0,96,70,1,0,124,70,1,0,192,70,1,0,248,70,1,0,28,71,1,0,56,71,1,0,112,71,1,0,126,71,1,0,130,71,1,0,132,71,1,0,136,71,1,0,144,71,1,0,160,71,1,0,188,71,1,0,198,71,1,0,204,71,1,0,216,71,1,0,238,71,1,0,16,72,1,0,32,72,1,0,60,72,1,0,64,72,1,0,120,72,1,0,240,72,1,0,224,73,1,0,192,75,1,0,48,76,1,0,62,76,1,0,96,76,1,0,124,76,1,0,192,76,1,0,248,76,1,0,240,77,1,0,56,78,1,0,112,78,1,0,126,78,1,0,224,78,1,0,252,78,1,0,4,79,1,0,8,79,1,0,16,79,1,0,30,79,1,0,32,79,1,0,60,79,1,0,64,79,1,0,120,79,1,0,134,79,1,0,140,79,1,0,152,79,1,0,176,79,1,0,206,79,1,0,220,79,1,0,32,80,1,0,64,80,1,0,120,80,1,0,240,80,1,0,224,81,1,0,192,83,1,0,96,88,1,0,124,88,1,0,192,88,1,0,248,88,1,0,240,89,1,0,224,91,1,0,112,92,1,0,126,92,1,0,224,92,1,0,252,92,1,0,192,93,1,0,248,93,1,0,8,94,1,0,16,94,1,0,32,94,1,0,64,94,1,0,120,94,1,0,240,94,1,0,12,95,1,0,24,95,1,0,48,95,1,0,96,95,1,0,124,95,1,0,142,95,1,0,156,95,1,0,184,95,1,0,78,96,1,0,92,96,1,0,142,96,1,0,156,96,1,0,184,96,1,0,194,96,1,0,196,96,1,0,200,96,1,0,222,96,1,0,14,97,1,0,28,97,1,0,56,97,1,0,112,97,1,0,126,97,1,0,132,97,1,0,136,97,1,0,144,97,1,0,158,97,1,0,160,97,1,0,188,97,1,0,198,97,1,0,204,97,1,0,216,97,1,0,242,97,1,0,244,97,1,0,14,98,1,0,28,98,1,0,56,98,1,0,112,98,1,0,126,98,1,0,224,98,1,0,252,98,1,0,4,99,1,0,8,99,1,0,16,99,1,0,30,99,1,0,32,99,1,0,60,99,1,0,64,99,1,0,120,99,1,0,134,99,1,0,140,99,1,0,152,99,1,0,176,99,1,0,190,99,1,0,206,99,1,0,220,99,1,0,226,99,1,0,228,99,1,0,232,99,1,0,246,99,1,0,14,100,1,0,28,100,1,0,56,100,1,0,112,100,1,0,126,100,1,0,224,100,1,0,252,100,1,0,192,101,1,0,248,101,1,0,16,102,1,0,30,102,1,0,32,102,1,0,60,102,1,0,64,102,1,0,120,102,1,0,240,102,1,0,24,103,1,0,48,103,1,0,62,103,1,0,96,103,1,0,124,103,1,0,142,103,1,0,156,103,1,0,184,103,1,0,194,103,1,0,196,103,1,0,200,103,1,0,208,103,1,0,222,103,1,0,230,103,1,0,236,103,1,0,28,104,1,0,56,104,1,0,112,104,1,0,224,104,1,0,252,104,1,0,192,105,1,0,248,105,1,0,240,107,1,0,16,108,1,0,30,108,1,0,32,108,1,0,60,108,1,0,64,108,1,0,120,108,1,0,240,108,1,0,224,109,1,0,24,110,1,0,48,110,1,0,62,110,1,0,96,110,1,0,124,110,1,0,192,110,1,0,248,110,1,0,28,111,1,0,56,111,1,0,112,111,1,0,126,111,1,0,132,111,1,0,136,111,1,0,144,111,1,0,158,111,1,0,160,111,1,0,188,111,1,0,198,111,1,0,204,111,1,0,216,111,1,0,38,112,1,0,44,112,1,0,70,112,1,0,76,112,1,0,88,112,1,0,110,112,1,0,134,112,1,0,140,112,1,0,152,112,1,0,176,112,1,0,190,112,1,0,206,112,1,0,220,112,1,0,232,112,1,0,6,113,1,0,12,113,1,0,24,113,1,0,48,113,1,0,62,113,1,0,96,113,1,0,124,113,1,0,142,113,1,0,156,113,1,0,184,113,1,0,194,113,1,0,196,113,1,0,200,113,1,0,208,113,1,0,222,113,1,0,230,113,1,0,236,113,1,0,250,113,1,0,6,114,1,0,12,114,1,0,24,114,1,0,48,114,1,0,62,114,1,0,96,114,1,0,124,114,1,0,192,114,1,0,248,114,1,0,14,115,1,0,28,115,1,0,56,115,1,0,112,115,1,0,126,115,1,0,136,115,1,0,144,115,1,0,158,115,1,0,160,115,1,0,188,115,1,0,204,115,1,0,216,115,1,0,238,115,1,0,242,115,1,0,244,115,1,0,12,116,1,0,24,116,1,0,48,116,1,0,62,116,1,0,96,116,1,0,124,116,1,0,192,116,1,0,248,116,1,0,240,117,1,0,14,118,1,0,28,118,1,0,56,118,1,0,112,118,1,0,126,118,1,0,224,118,1,0,252,118,1,0,8,119,1,0,16,119,1,0,30,119,1,0,32,119,1,0,60,119,1,0,64,119,1,0,120,119,1,0,152,119,1,0,176,119,1,0,190,119,1,0,220,119,1,0,226,119,1,0,228,119,1,0,232,119,1,0,34,120,1,0,36,120,1,0,40,120,1,0,54,120,1,0,66,120,1,0,68,120,1,0,72,120,1,0,80,120,1,0,94,120,1,0,102,120,1,0,108,120,1,0,130,120,1,0,132,120,1,0,136,120,1,0,144,120,1,0,158,120,1,0,160,120,1,0,188,120,1,0,198,120,1,0,204,120,1,0,216,120,1,0,238,120,1,0,242,120,1,0,244,120,1,0,2,121,1,0,4,121,1,0,8,121,1,0,16,121,1,0,30,121,1,0,32,121,1,0,60,121,1,0,64,121,1,0,120,121,1,0,134,121,1,0,140,121,1,0,152,121,1,0,176,121,1,0,190,121,1,0,206,121,1,0,220,121,1,0,226,121,1,0,228,121,1,0,232,121,1,0,246,121,1,0,4,122,1,0,8,122,1,0,16,122,1,0,30,122,1,0,32,122,1,0,60,122,1,0,64,122,1,0,120,122,1,0,240,122,1,0,6,123,1,0,12,123,1,0,24,123,1,0,48,123,1,0,62,123,1,0,96,123,1,0,124,123,1,0,142,123,1,0,156,123,1,0,184,123,1,0,196,123,1,0,200,123,1,0,208,123,1,0,222,123,1,0,230,123,1,0,236,123,1,0,46,124,1,0,50,124,1,0,52,124,1,0,78,124,1,0,92,124,1,0,98,124,1,0,100,124,1,0,104,124,1,0,118,124,1,0,142,124,1,0,156,124,1,0,184,124,1,0,194,124,1,0,196,124,1,0,200,124,1,0,208,124,1,0,222,124,1,0,230,124,1,0,236,124,1,0,14,125,1,0,28,125,1,0,56,125,1,0,112,125,1,0,130,125,1,0,132,125,1,0,136,125,1,0,144,125,1,0,158,125,1,0,160,125,1,0,188,125,1,0,198,125,1,0,204,125,1,0,216,125,1,0,238,125,1,0,38,126,1,0,44,126,1,0,58,126,1,0,70,126,1,0,76,126,1,0,88,126,1,0,110,126,1,0,114,126,1,0,116,126,1,0,134,126,1,0,140,126,1,0,152,126,1,0,176,126,1,0,206,126,1,0,220,126,1,0,226,126,1,0,228,126,1,0,232,126,1,0,246,126,1,0,58,129,1,0,114,129,1,0,116,129,1,0,22,130,1,0,38,130,1,0,58,130,1,0,76,130,1,0,88,130,1,0,110,130,1,0,114,130,1,0,116,130,1,0,152,130,1,0,190,130,1,0,226,130,1,0,228,130,1,0,232,130,1,0,246,130,1,0,94,131,1,0,122,131,1,0,174,131,1,0,214,131,1,0,22,132,1,0,38,132,1,0,44,132,1,0,58,132,1,0,70,132,1,0,88,132,1,0,110,132,1,0,114,132,1,0,116,132,1,0,134,132,1,0,176,132,1,0,190,132,1,0,206,132,1,0,220,132,1,0,226,132,1,0,228,132,1,0,232,132,1,0,246,132,1,0,6,133,1,0,12,133,1,0,24,133,1,0,48,133,1,0,62,133,1,0,96,133,1,0,124,133,1,0,142,133,1,0,156,133,1,0,184,133,1,0,194,133,1,0,196,133,1,0,200,133,1,0,208,133,1,0,222,133,1],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([230,133,1,0,236,133,1,0,250,133,1,0,18,134,1,0,20,134,1,0,34,134,1,0,40,134,1,0,54,134,1,0,66,134,1,0,80,134,1,0,94,134,1,0,122,134,1,0,130,134,1,0,132,134,1,0,136,134,1,0,144,134,1,0,158,134,1,0,160,134,1,0,188,134,1,0,198,134,1,0,204,134,1,0,216,134,1,0,238,134,1,0,242,134,1,0,244,134,1,0,46,135,1,0,78,135,1,0,92,135,1,0,150,135,1,0,166,135,1,0,172,135,1,0,210,135,1,0,212,135,1,0,38,136,1,0,44,136,1,0,58,136,1,0,70,136,1,0,76,136,1,0,88,136,1,0,110,136,1,0,114,136,1,0,116,136,1,0,134,136,1,0,152,136,1,0,176,136,1,0,190,136,1,0,206,136,1,0,220,136,1,0,226,136,1,0,228,136,1,0,232,136,1,0,246,136,1,0,12,137,1,0,48,137,1,0,62,137,1,0,96,137,1,0,124,137,1,0,142,137,1,0,184,137,1,0,194,137,1,0,200,137,1,0,208,137,1,0,222,137,1,0,230,137,1,0,236,137,1,0,250,137,1,0,24,138,1,0,48,138,1,0,62,138,1,0,96,138,1,0,124,138,1,0,192,138,1,0,248,138,1,0,28,139,1,0,56,139,1,0,112,139,1,0,126,139,1,0,130,139,1,0,132,139,1,0,136,139,1,0,144,139,1,0,158,139,1,0,160,139,1,0,188,139,1,0,198,139,1,0,204,139,1,0,216,139,1,0,238,139,1,0,242,139,1,0,244,139,1,0,34,140,1,0,36,140,1,0,40,140,1,0,54,140,1,0,66,140,1,0,72,140,1,0,80,140,1,0,94,140,1,0,102,140,1,0,122,140,1,0,130,140,1,0,132,140,1,0,144,140,1,0,158,140,1,0,160,140,1,0,188,140,1,0,204,140,1,0,242,140,1,0,244,140,1,0,4,141,1,0,8,141,1,0,16,141,1,0,30,141,1,0,32,141,1,0,60,141,1,0,64,141,1,0,120,141,1,0,134,141,1,0,152,141,1,0,206,141,1,0,226,141,1,0,228,141,1,0,232,141,1,0,46,142,1,0,50,142,1,0,52,142,1,0,78,142,1,0,92,142,1,0,98,142,1,0,100,142,1,0,104,142,1,0,142,142,1,0,156,142,1,0,184,142,1,0,194,142,1,0,196,142,1,0,200,142,1,0,208,142,1,0,250,142,1,0,22,143,1,0,38,143,1,0,44,143,1,0,70,143,1,0,76,143,1,0,88,143,1,0,110,143,1,0,138,143,1,0,146,143,1,0,148,143,1,0,162,143,1,0,164,143,1,0,168,143,1,0,182,143,1,0,44,144,1,0,58,144,1,0,70,144,1,0,76,144,1,0,88,144,1,0,114,144,1,0,116,144,1,0,134,144,1,0,152,144,1,0,176,144,1,0,190,144,1,0,206,144,1,0,220,144,1,0,226,144,1,0,232,144,1,0,246,144,1,0,6,145,1,0,12,145,1,0,48,145,1,0,62,145,1,0,96,145,1,0,124,145,1,0,142,145,1,0,156,145,1,0,184,145,1,0,194,145,1,0,200,145,1,0,208,145,1,0,222,145,1,0,230,145,1,0,236,145,1,0,250,145,1,0,24,146,1,0,62,146,1,0,96,146,1,0,124,146,1,0,192,146,1,0,248,146,1,0,56,147,1,0,112,147,1,0,126,147,1,0,130,147,1,0,132,147,1,0,144,147,1,0,158,147,1,0,160,147,1,0,188,147,1,0,198,147,1,0,204,147,1,0,216,147,1,0,238,147,1,0,242,147,1,0,244,147,1,0,48,148,1,0,62,148,1,0,96,148,1,0,124,148,1,0,192,148,1,0,248,148,1,0,240,149,1,0,56,150,1,0,112,150,1,0,126,150,1,0,224,150,1,0,252,150,1,0,2,151,1,0,4,151,1,0,8,151,1,0,16,151,1,0,32,151,1,0,60,151,1,0,64,151,1,0,120,151,1,0,134,151,1,0,140,151,1,0,152,151,1,0,176,151,1,0,190,151,1,0,206,151,1,0,220,151,1,0,226,151,1,0,228,151,1,0,232,151,1,0,34,152,1,0,36,152,1,0,66,152,1,0,72,152,1,0,80,152,1,0,94,152,1,0,102,152,1,0,122,152,1,0,130,152,1,0,132,152,1,0,144,152,1,0,158,152,1,0,160,152,1,0,188,152,1,0,204,152,1,0,242,152,1,0,244,152,1,0,2,153,1,0,8,153,1,0,30,153,1,0,32,153,1,0,60,153,1,0,64,153,1,0,120,153,1,0,134,153,1,0,152,153,1,0,206,153,1,0,226,153,1,0,228,153,1,0,232,153,1,0,8,154,1,0,16,154,1,0,30,154,1,0,32,154,1,0,60,154,1,0,64,154,1,0,120,154,1,0,240,154,1,0,24,155,1,0,62,155,1,0,96,155,1,0,156,155,1,0,194,155,1,0,196,155,1,0,200,155,1,0,208,155,1,0,230,155,1,0,46,156,1,0,52,156,1,0,78,156,1,0,92,156,1,0,98,156,1,0,100,156,1,0,104,156,1,0,142,156,1,0,156,156,1,0,184,156,1,0,194,156,1,0,200,156,1,0,208,156,1,0,230,156,1,0,250,156,1,0,14,157,1,0,28,157,1,0,56,157,1,0,112,157,1,0,126,157,1,0,130,157,1,0,132,157,1,0,136,157,1,0,144,157,1,0,160,157,1,0,204,157,1,0,242,157,1,0,244,157,1,0,22,158,1,0,38,158,1,0,44,158,1,0,70,158,1,0,76,158,1,0,88,158,1,0,116,158,1,0,134,158,1,0,140,158,1,0,152,158,1,0,176,158,1,0,190,158,1,0,206,158,1,0,226,158,1,0,228,158,1,0,232,158,1,0,10,159,1,0,18,159,1,0,20,159,1,0,34,159,1,0,36,159,1,0,40,159,1,0,66,159,1,0,68,159,1,0,72,159,1,0,80,159,1,0,94,159,1,0,108,159,1,0,154,159,1,0,174,159,1,0,178,159,1,0,180,159,1,0,70,160,1,0,76,160,1,0,114,160,1,0,116,160,1,0,134,160,1,0,140,160,1,0,152,160,1,0,176,160,1,0,190,160,1,0,226,160,1,0,228,160,1,0,232,160,1,0,246,160,1,0,6,161,1,0,12,161,1,0,24,161,1,0,48,161,1,0,62,161,1,0,96,161,1,0,124,161,1,0,142,161,1,0,156,161,1,0,184,161,1,0,194,161,1,0,196,161,1,0,200,161,1,0,208,161,1,0,222,161,1,0,230,161,1,0,236,161,1,0,24,162,1,0,48,162,1,0,62,162,1,0,96,162,1,0,124,162,1,0,192,162,1,0,248,162,1,0,28,163,1,0,56,163,1,0,112,163,1,0,126,163,1,0,130,163,1,0,132,163,1,0,136,163,1,0,144,163,1,0,158,163,1,0,160,163,1,0,188,163,1,0,198,163,1,0,204,163,1,0,216,163,1,0,238,163,1,0,242,163,1,0,244,163,1,0,24,164,1,0,48,164,1,0,62,164,1,0,96,164,1,0,124,164,1,0,192,164,1,0,248,164,1,0,240,165,1,0,28,166,1,0,56,166,1,0,112,166,1,0,126,166,1,0,224,166,1,0,252,166,1,0,2,167,1,0,4,167,1,0,8,167,1,0,16,167,1,0,30,167,1,0,32,167,1,0,60,167,1,0,64,167,1,0,120,167,1,0,134,167,1,0,140,167,1,0,152,167,1,0,176,167,1,0,190,167,1,0,206,167,1,0,220,167,1,0,226,167,1,0,228,167,1,0,232,167,1,0,48,168,1,0,96,168,1,0,124,168,1,0,192,168,1,0,248,168,1,0,240,169,1,0,224,171,1,0,112,172,1,0,126,172,1,0,224,172,1,0,252,172,1,0,192,173,1,0,248,173,1,0,4,174,1,0,8,174,1,0,16,174,1,0,32,174,1,0,60,174,1,0,64,174,1,0,120,174,1,0,240,174,1,0,6,175,1,0,12,175,1,0,24,175,1,0,48,175,1,0,62,175,1,0,96,175,1,0,124,175,1,0,142,175,1,0,156,175,1,0,184,175,1,0,196,175,1,0,200,175,1,0,208,175,1,0,222,175,1,0,66,176,1,0,94,176,1,0,122,176,1,0,130,176,1,0,132,176,1,0,136,176,1,0,144,176,1,0,158,176,1,0,160,176,1,0,188,176,1,0,204,176,1,0,242,176,1,0,244,176,1,0,2,177,1,0,4,177,1,0,8,177,1,0,16,177,1,0,30,177,1,0,32,177,1,0,60,177,1,0,64,177,1,0,120,177,1,0,134,177,1,0,152,177,1,0,206,177,1,0,226,177,1,0,228,177,1,0,232,177,1,0,4,178,1,0,8,178,1,0,16,178,1,0,30,178,1,0,32,178,1,0,60,178,1,0,64,178,1,0,120,178,1,0,240,178,1,0,12,179,1,0,62,179,1,0,96,179,1,0,156,179,1,0,194,179,1,0,196,179,1,0,200,179,1,0,208,179,1,0,230,179,1,0,16,180,1,0,30,180,1,0,32,180,1,0,60,180,1,0,64,180,1,0,120,180,1,0,240,180,1,0,224,181,1,0,24,182,1,0,96,182,1,0,124,182,1,0,192,182,1,0,56,183,1,0,130,183,1,0,132,183,1,0,136,183,1,0,144,183,1,0,158,183,1,0,160,183,1,0,204,183,1,0,46,184,1,0,78,184,1,0,92,184,1,0,142,184,1,0,156,184,1,0,184,184,1,0,194,184,1,0,196,184,1,0,200,184,1,0,208,184,1,0,230,184,1,0,250,184,1,0,14,185,1,0,28,185,1,0,56,185,1,0,112,185,1,0,126,185,1,0,130,185,1,0,132,185,1,0,136,185,1,0,144,185,1,0,158,185,1,0,160,185,1,0,204,185,1,0,242,185,1,0,244,185,1,0,14,186,1,0,28,186,1,0,56,186,1,0,112,186,1,0,126,186,1,0,224,186,1,0,252,186,1,0,8,187,1,0,16,187,1,0,32,187,1,0,60,187,1,0,64,187,1,0,152,187,1,0,206,187,1,0,226,187,1,0,228,187,1,0,232,187,1,0,22,188,1,0,38,188,1,0,44,188,1,0,70,188,1,0,76,188,1,0,88,188,1,0,114,188,1,0,116,188,1,0,134,188,1,0,140,188,1,0,152,188,1,0,176,188,1,0,190,188,1,0,206,188,1,0,226,188,1,0,228,188,1,0,232,188,1,0,6,189,1,0,12,189,1,0,24,189,1,0,48,189,1,0,62,189,1,0,96,189,1,0,124,189,1,0,156,189,1,0,194,189,1,0,196,189,1,0,200,189,1,0,208,189,1,0,230,189,1,0,250,189,1,0,18,190,1,0,20,190,1,0,34,190,1,0,36,190,1,0,40,190,1,0,66,190,1,0,68,190,1,0,72,190,1,0,80,190,1,0,94,190,1,0,102,190,1,0,130,190,1,0,132,190,1,0,136,190,1,0,144,190,1,0,158,190,1,0,160,190,1,0,188,190,1,0,204,190,1,0,244,190,1,0,26,191,1,0,46,191,1,0,50,191,1,0,52,191,1,0,78,191,1,0,92,191,1,0,98,191,1,0,100,191,1,0,104,191,1,0,154,192,1,0,178,192,1,0,180,192,1,0,26,193,1,0,50,193,1,0,52,193,1,0,98,193,1,0,100,193,1,0,104,193,1,0,118,193,1,0,186,193,1,0,26,194,1,0,50,194,1,0,52,194,1,0,78,194,1,0,92,194,1,0,98,194,1,0,100,194,1,0,104,194,1,0,118,194,1,0,142,194,1,0,194,194,1,0,196,194,1,0,200,194,1,0,208,194,1,0,222,194,1,0,230,194,1,0,236,194,1,0,250,194,1,0,22,195,1,0,38,195,1,0,58,195,1,0,70,195,1,0,76,195,1,0,114,195,1,0,116,195,1,0,26,196,1,0,46,196,1,0,50,196,1,0,52,196,1,0,78,196,1,0,92,196,1,0,98,196,1,0,100,196,1,0,104,196,1,0,118,196,1,0,142,196,1,0,156,196,1,0,184,196,1,0,194,196,1,0,200,196,1,0,208,196,1,0,222,196,1,0,230,196,1,0,236,196,1,0,250,196,1,0,28,197,1,0,56,197,1,0,112,197,1,0,126,197,1,0,130,197,1,0,132,197,1,0,136,197,1,0,144,197,1,0,158,197,1,0,160,197,1,0,188,197,1,0,198,197,1,0,204,197,1,0,216,197,1,0,238,197,1,0,242,197,1,0,244,197,1,0,22,198,1,0,38,198,1,0,44,198,1,0,58,198,1,0,70,198,1,0,76,198,1,0,88,198,1,0,110,198,1,0,114,198,1,0,116,198,1,0,134,198,1,0,140,198,1,0,152,198,1,0,176,198,1,0,190,198,1,0,206,198,1,0,220,198,1,0,226,198,1,0,228,198,1,0,232,198,1,0,18,199,1,0,20,199,1,0,34,199,1,0,40,199,1,0,54,199,1,0,66,199,1,0,68,199,1,0,72,199,1,0,80,199,1,0,94,199,1,0,102,199,1,0,108,199,1,0,122,199,1,0,174,199,1,0,214,199,1,0,234,199,1,0,26,200,1,0,46,200,1,0,50,200,1,0,52,200,1,0,78,200,1,0,92,200,1,0,98,200,1,0,100,200,1,0,104,200,1,0,118,200,1,0,142,200,1,0,156,200,1,0,184,200,1,0,194,200,1,0,200,200,1,0,208,200,1,0,222,200,1,0,230,200,1,0,236,200,1,0,250,200,1,0,14,201,1,0,56,201,1,0,112,201,1,0,126,201,1,0,130,201,1,0,132,201,1,0,144,201,1,0,158,201,1,0,160,201,1,0,188,201,1,0,198,201,1,0,204,201,1,0,216,201,1,0,238,201,1,0,242,201,1,0,244,201,1,0,56,202,1,0,112,202,1,0,126,202,1,0,224,202,1,0,252,202,1,0,2,203,1,0,4,203,1,0,8,203,1,0,16,203,1,0,32,203,1,0,60,203,1,0,64,203,1,0,120,203,1,0,134,203,1,0,140,203,1,0,152,203,1,0,176,203,1,0,190,203,1,0,206,203,1,0,220,203,1,0,226,203,1,0,228,203,1,0,232,203,1,0,246,203,1,0,22,204,1,0,38,204,1,0,44,204,1,0,58,204,1,0,70,204,1,0,88,204,1,0,114,204,1,0,116,204,1,0,134,204,1,0,176,204,1,0,190,204,1,0,206,204,1,0,226,204,1,0,228,204,1,0,232,204,1,0,6,205,1,0,12,205,1,0,24,205,1,0,48,205,1,0,62,205,1,0,96,205,1,0,124,205,1,0,156,205,1,0,194,205,1,0,196,205,1,0,200,205,1,0,208,205,1,0,222,205,1,0,230,205,1,0,250,205,1,0,34,206,1,0,40,206,1,0,66,206,1,0,80,206,1,0,94,206,1,0,102,206,1,0,122,206,1,0,130,206,1,0,132,206,1,0,136,206,1,0,144,206,1,0,158,206,1,0,160,206,1,0,188,206,1,0,204,206,1,0,242,206,1,0,244,206,1,0,46,207,1,0,50,207,1,0,52,207,1,0,78,207,1,0,92,207,1,0,98,207,1,0,100,207,1,0,104,207,1,0,150,207,1,0,166,207,1,0,172,207,1,0,202,207,1,0,210,207,1,0,212,207,1,0,46,208,1,0,50,208,1,0,52,208,1,0,78,208,1,0,92,208,1,0,98,208,1,0,100,208,1,0,104,208,1,0,118,208,1,0,142,208,1,0,156,208,1,0,184,208,1,0,194,208,1,0,196,208,1,0,200,208,1,0,208,208,1,0,222,208,1,0,230,208,1,0,236,208,1,0,250,208,1,0,28,209,1,0,56,209,1,0,112,209,1,0,126,209,1,0,130,209,1,0,132,209,1,0,136,209,1,0,144,209,1,0,158,209,1,0,160,209,1,0,188,209,1,0,198,209,1,0,204,209,1,0,216,209,1,0,238,209,1,0,242,209,1,0,244,209,1,0,28,210,1,0,56,210,1,0,112,210,1,0,126,210,1,0,224,210,1,0,252,210,1,0,2,211,1,0,4,211,1,0,8,211,1,0,16,211,1,0,30,211,1,0,32,211,1,0,60,211,1,0,64,211,1,0,120,211,1,0,134,211,1,0,140,211,1,0,152,211,1,0,176,211,1,0,190,211,1,0,206,211,1,0,220,211,1,0,226,211,1,0,228,211,1,0,232,211,1,0,246,211,1,0,112,212,1,0,126,212,1,0,224,212,1,0,252,212,1,0,192,213,1,0,248,213,1,0,4,214,1,0,8,214,1,0,16,214,1,0,32,214,1,0,64,214,1,0,120,214,1,0,240,214,1,0,6,215,1,0,12,215,1,0,24,215,1,0,48,215,1,0,62,215,1,0,96,215,1,0,124,215,1,0,142,215,1,0,156,215,1,0,184,215,1,0,194,215,1,0,196,215,1,0,200,215,1,0,208,215,1,0,222,215,1,0,230,215,1,0,236,215,1,0,38,216,1,0,44,216,1,0,58,216,1,0,70,216,1,0,76,216,1,0,88,216,1,0,114,216,1,0,116,216,1,0,134,216,1,0,140,216,1,0,152,216,1,0,176,216,1,0,190,216,1,0,206,216,1,0,226,216,1,0,228,216,1,0,232,216,1,0,246,216,1,0,12,217,1,0,24,217,1,0,48,217,1,0,62,217,1,0,96,217,1,0,124,217,1,0,156,217,1,0,194,217,1,0,196,217,1,0,200,217,1,0,208,217,1,0,230,217,1,0,250,217,1,0,12,218,1,0,24,218,1,0,48,218,1,0,62,218,1,0,96,218,1,0,124,218,1,0,192,218,1,0,248,218,1,0,56,219,1,0,130,219,1,0,132,219,1,0,136,219,1,0,144,219,1,0,158,219,1,0,160,219,1,0,204,219,1,0,242,219,1,0,244,219,1,0,34,220,1,0,66,220,1,0,68,220,1,0,72,220,1,0,80,220,1,0,94,220,1,0,102,220,1,0,122,220,1,0,130,220,1,0,132,220,1,0,136,220,1,0,144,220,1,0,158,220,1,0,160,220,1,0,188,220,1,0,204,220,1,0,242,220,1,0,244,220,1,0,4,221,1,0,8,221,1,0,16,221,1,0,30,221,1,0,32,221,1,0,60,221,1,0,64,221,1,0,120,221,1,0,134,221,1,0,152,221,1,0,206,221,1,0,226,221,1,0,228,221,1,0,232,221,1,0,46,222,1,0,50,222,1,0,52,222,1,0,78,222,1,0,92,222,1,0,98,222,1,0,100,222,1,0,104,222,1,0,142,222,1,0,156,222,1,0,184,222,1,0,194,222,1,0,196,222,1,0,200,222,1,0,208,222,1,0,230,222,1,0,250,222,1,0,22,223,1,0,38,223,1,0,44,223,1,0,70,223,1,0,76,223,1,0,88,223,1,0,114,223,1,0,116,223,1,0,138,223,1,0,146,223,1,0,148,223,1,0,162,223,1,0,164,223,1,0,168,223,1,0,138,224,1,0,146,224,1,0,148,224,1,0,162,224,1,0,164,224,1,0,168,224,1,0,182,224,1,0,218,224,1,0,10,225,1,0,18,225,1,0,20,225,1,0,34,225,1,0,36,225,1,0,40,225,1,0,54,225,1,0,66,225,1,0,68,225,1,0,72,225,1,0,80,225,1,0,102,225,1,0,108,225,1,0,122,225,1,0,154,225,1,0,178,225,1,0,180,225,1,0,10,226,1,0,18,226,1,0,20,226,1,0,34,226,1,0,36,226,1,0,40,226,1,0,54,226,1,0,66,226,1,0,72,226,1,0,80,226,1,0,94,226,1,0,102,226,1,0,108,226,1,0,122,226,1,0,130,226,1,0,132,226,1,0,136,226,1,0,144,226,1,0,160,226,1,0,188,226,1,0,198,226,1,0,204,226,1,0,216,226,1,0,238,226,1,0,242,226,1,0,244,226,1,0,26,227,1,0,50,227,1,0,52,227,1,0,92,227,1,0,98,227,1,0,100,227,1,0,104,227,1,0,186,227,1,0,10,228,1,0,18,228,1,0,20,228,1,0,34,228,1,0,40,228,1,0,54,228,1,0,66,228,1,0,72,228,1,0,80,228,1,0,94,228,1,0,102,228,1,0,108,228,1,0,122,228,1,0,130,228,1,0,132,228,1,0,144,228,1,0,158,228,1,0,160,228,1,0,188,228,1,0,198,228,1,0,204,228,1,0,216,228,1,0,238,228,1,0,242,228,1,0,244,228,1,0,2,229,1,0,4,229,1,0,8,229,1,0,16,229,1,0,30,229,1,0,32,229,1,0,60,229,1,0,64,229,1,0,120,229,1,0,134,229,1,0,140,229,1,0,152,229,1,0,176,229,1,0,190,229,1,0,206,229,1,0,220,229,1,0,226,229,1,0,228,229,1,0,232,229,1,0,246,229,1,0,26,230,1,0,46,230,1,0,50,230,1,0,52,230,1,0,78,230,1,0,92,230,1,0,98,230,1,0,104,230,1,0,142,230,1,0,156,230,1,0,184,230,1,0,194,230,1,0,196,230,1,0,200,230,1,0,208,230,1,0,230,230,1,0,250,230,1,0,22,231,1,0,38,231,1,0,44,231,1,0,58,231,1,0,70,231,1,0,76,231,1,0,88,231,1,0,114,231,1,0,116,231,1,0,146,231,1,0,148,231,1,0,162,231,1,0,164,231,1,0,168,231,1,0,182,231,1,0,18,232,1,0,20,232,1,0,34,232,1,0,36,232,1,0,40,232,1,0,54,232,1,0,66,232,1,0,68,232,1,0,72,232,1,0,80,232,1,0,94,232,1,0,102,232,1,0,108,232,1,0,122,232,1,0,130,232,1,0,132,232,1,0,136,232,1,0,144,232,1,0,158,232,1,0,160,232,1,0,188,232,1,0,198,232,1,0,204,232,1,0,216,232,1,0,238,232,1,0,242,232,1,0,244,232,1,0,2,233,1,0,4,233,1,0,8,233,1,0,16,233,1,0,32,233,1,0,60,233,1,0,64,233,1,0,120,233,1,0,134,233,1,0,140,233,1,0,152,233,1,0,176,233,1,0,190,233,1,0,206,233,1,0,220,233,1,0,226,233,1,0,228,233,1,0,232,233,1,0,246,233,1,0,4,234,1,0,8,234,1,0,16,234,1,0,32,234,1,0,64,234,1,0,120,234,1,0,240,234,1,0,6,235,1,0,12,235,1,0,24,235,1,0,48,235,1,0,62,235,1,0,96,235,1,0,124,235,1,0,142,235,1,0,156,235,1,0,184,235,1,0,194,235,1,0,196,235,1,0,200,235,1,0,208,235,1,0,222,235,1,0,230,235,1,0,236,235,1,0,26,236,1,0,46,236,1,0,50,236,1,0,52,236,1,0,78,236,1,0,92,236,1,0,98,236,1,0,100,236,1,0,104,236,1,0,142,236,1,0,156,236,1,0,184,236,1,0,194,236,1,0,196,236,1,0,200,236,1,0,208,236,1,0,230,236,1,0,250,236,1,0,14,237,1,0,28,237,1,0,56,237,1,0,112,237,1,0,126,237,1,0,130,237,1,0,132,237,1,0,136,237,1,0,144,237,1,0,158,237,1,0,160,237,1,0,204,237,1,0,242,237,1,0,244,237,1,0,22,238,1,0,38,238,1,0,44,238,1,0,58,238,1,0,70,238,1,0,76,238,1,0,88,238,1,0,110,238,1,0,114,238,1,0,116,238,1,0,134,238,1,0,140,238,1,0,152,238,1,0,176,238,1,0,190,238,1,0,206,238,1,0,220,238,1,0,226,238,1,0,228,238,1,0,232,238,1,0,18,239,1,0,34,239,1,0,36,239,1,0,40,239,1,0,54,239,1,0,66,239,1,0,68,239,1,0,72,239,1,0,80,239,1,0,94,239,1,0,102,239,1,0,108,239,1,0,122,239,1,0,174,239,1,0,178,239,1,0,180,239,1,0,214,239,1,0,150,240,1,0,166,240,1,0,172,240,1,0,186,240,1,0,202,240,1,0,210,240,1,0,212,240,1,0,22,241,1,0,38,241,1,0,44,241,1,0,58,241,1,0,70,241,1,0,76,241,1,0,88,241,1,0,110,241,1,0,114,241,1,0,116,241,1,0,138,241,1,0,146,241,1,0,148,241,1,0,162,241,1,0,164,241,1,0,168,241,1,0,218,241,1,0,22,242,1,0,38,242,1,0,44,242,1,0,58,242,1,0,70,242,1,0,88,242,1,0,110,242,1,0,114,242,1,0,116,242,1,0,134,242,1,0,140,242,1,0,152,242,1,0,176,242,1,0,190,242,1,0,206,242,1,0,220,242,1,0,226,242,1,0,228,242,1,0,232,242,1,0,246,242,1,0,10,243,1,0,18,243,1,0,20,243,1,0,34,243,1,0,40,243,1,0,66,243,1,0,68,243,1,0,72,243,1,0,80,243,1,0,94,243,1,0,102,243,1,0,122,243,1,0,154,243,1,0,174,243,1,0,178,243,1,0,180,243,1,0,22,244,1,0,38,244,1,0,44,244,1,0,58,244,1,0,70,244,1,0,76,244,1,0,88,244,1,0,110,244,1,0,114,244,1,0,116,244,1,0,134,244,1,0,140,244,1,0,152,244,1,0,176,244,1,0,190,244,1,0,206,244,1,0,220,244,1,0,226,244,1,0,228,244,1,0,232,244,1,0,246,244,1,0,6,245,1,0,12,245,1,0,24,245,1,0,48,245,1,0,62,245,1,0,96,245,1,0,124,245,1,0,142,245,1,0,156,245,1,0,184,245,1,0,194,245,1,0,196,245,1,0,200,245,1,0,208,245,1,0,222,245,1,0,230,245,1,0,236,245,1,0,250,245,1,0,10,246,1,0,18,246,1,0,20,246,1,0,34,246,1,0,36,246,1,0,40,246,1,0,54,246,1,0,66,246,1,0,68,246,1,0,72,246,1,0,80,246,1,0,94,246,1,0,102,246,1,0,122,246,1,0,130,246,1,0,132,246,1,0,136,246,1,0,144,246,1,0,158,246,1,0,160,246,1,0,188,246,1,0,204,246,1,0,242,246,1,0,244,246,1,0,26,247,1,0,46,247,1,0,50,247,1,0,52,247,1,0,78,247,1,0,92,247,1,0,98,247,1,0,100,247,1,0,104,247,1,0,118,247,1,0,150,247,1,0,166,247,1,0,172,247,1,0,186,247,1,0,210,247,1,0,212,247,1,0,154,248,1,0,174,248,1,0,178,248,1,0,180,248,1,0,214,248,1,0,234,248,1,0,26,249,1,0,46,249,1,0,50,249,1,0,52,249,1,0,78,249,1,0,92,249,1,0,98,249,1,0,100,249,1,0,104,249,1,0,118,249,1,0,150,249,1,0,166,249,1,0,172,249,1,0,186,249,1,0,202,249,1,0,210,249,1,0,212,249,1,0,26,250,1,0,46,250,1,0,50,250,1,0,52,250,1,0,78,250,1,0,92,250,1,0,98,250,1,0,100,250,1,0,104,250,1,0,118,250,1,0,142,250,1,0,156,250,1,0,184,250,1,0,194,250,1,0,196,250,1,0,200,250,1,0,208,250,1,0,222,250,1,0,230,250,1,0,236,250,1,0,22,251,1,0,38,251,1,0,44,251,1,0,58,251,1,0,70,251,1,0,76,251,1,0,88,251,1,0,110,251,1,0,114,251,1,0,116,251,1,0,138,251,1,0,146,251,1,0,148,251,1,0,162,251,1,0,164,251,1,0,168,251,1,0,182,251,1,0,218,251,1,0,67,10,0,0,27,7,0,0,62,10,0,0,61,10,0,0,21,7,0,0,20,7,0,0,169,10,0,0,164,10,0,0,163,10,0,0,219,10,0,0,214,10,0,0,213,10,0,0,134,3,0,0,128,3,0,0,140,3,0,0,100,3,0,0,97,3,0,0,93,3,0,0,91,3,0,0,207,9,0,0,105,3,0,0,103,3,0,0,244,6,0,0,67,3,0,0,189,9,0,0,57,3,0,0,187,9,0,0,74,3,0,0,69,3,0,0,76,3,0,0,228,6,0,0,226,6,0,0,43,3,0,0,42,3,0,0,41,3,0,0,179,9,0,0,39,3,0,0,178,9,0,0,38,3,0,0,176,9,0,0,47,3,0,0,46,3,0,0,45,3,0,0,44,3,0,0,180,9,0,0,49,3,0,0,48,3,0,0,209,6,0,0,208,6,0,0,206,6,0,0,210,6,0,0,95,10,0,0,77,10,0,0,75,10,0,0,66,10,0,0,65,10,0,0,63,10,0,0,68,10,0,0,28,7,0,0,192,10,0,0,179,10,0,0,177,10,0,0,168,10,0,0,167,10,0,0,165,10,0,0,170,10,0,0,225,10,0,0,223,10,0,0,218,10,0,0,217,10,0,0,215,10,0,0,220,10,0,0,19,3,0,0,13,3,0,0,235,2,0,0,227,2,0,0,224,2,0,0,109,9,0,0,242,2,0,0,240,2,0,0,183,6,0,0,180,2,0,0,177,2,0,0,169,2,0,0,67,9,0,0,166,2,0,0,65,9,0,0,188,2,0,0,185,2,0,0,182,2,0,0,191,2,0,0,152,6,0,0,150,6,0,0,130,2,0,0,126,2,0,0,39,9,0,0,119,2,0,0,37,9,0,0,115,2,0,0,34,9,0,0,139,2,0,0,134,2,0,0,131,2,0,0,41,9,0,0,142,2,0,0,140,2,0,0,116,6,0,0,114,6,0,0,111,6,0,0,118,6,0,0,89,2,0,0,87,2,0,0,18,9,0,0,84,2,0,0,17,9,0,0,82,2,0,0,15,9,0,0,13,9,0,0,99,2,0,0,98,2,0,0,96,2,0,0,94,2,0,0,20,9,0,0,91,2,0,0,19,9,0,0,103,2,0,0,102,2,0,0,100,2,0,0,81,6,0,0,80,6,0,0,78,6,0,0,76,6,0,0,104,2,0,0,83,6,0,0,82,6,0,0,15,10,0,0,234,9,0,0,232,9,0,0,137,3,0,0,133,3,0,0,130,3,0,0,141,3,0,0,205,9,0,0,203,9,0,0,200,9,0,0,102,3,0,0,99,3,0,0,96,3,0,0,92,3,0,0,208,9,0,0,107,3,0,0,104,3,0,0,245,6,0,0,186,9,0,0,185,9,0,0,183,9,0,0,181,9,0,0,212,6,0,0,68,3,0,0,66,3,0,0,64,3,0,0,62,3,0,0,190,9,0,0,59,3,0,0,188,9,0,0,75,3,0,0,73,3,0,0,71,3,0,0,77,3,0,0,229,6,0,0,227,6,0,0,141,10,0,0,116,10,0,0,114,10,0,0,93,10,0,0,88,10,0,0,96,10,0,0,74,10,0,0,73,10,0,0,71,10,0,0,69,10,0,0,29,7,0,0,78,10,0,0,76,10,0,0,210,10,0,0,203,10,0,0,201,10,0,0,190,10,0,0,185,10,0,0,193,10,0,0,176,10,0,0,175,10,0,0,173,10,0,0,171,10,0,0,56,7,0,0,180,10,0,0,178,10,0,0,226,10,0,0,224,10,0,0,79,2,0,0,76,2,0,0,64,2,0,0,57,2,0,0,54,2,0,0,248,8,0,0,54,6,0,0,25,2,0,0,22,2,0,0,14,2,0,0,228,8,0,0,10,2,0,0,226,8,0,0,33,2,0,0,30,2,0,0,27,2,0,0,36,2,0,0,36,6,0,0,34,6,0,0,225,1,0,0,197,8,0,0,210,1,0,0,194,8,0,0,206,1,0,0,191,8,0,0,236,1,0,0,229,1,0,0,226,1,0,0,201,8,0,0,240,1,0,0,238,1,0,0,254,5,0,0,251,5,0,0,248,5,0,0,2,6,0,0,157,1,0,0,148,8,0,0,150,1,0,0,143,8,0,0,140,8,0,0,169,1,0,0,163,1,0,0,154,8,0,0,159,1,0,0,151,8,0,0,176,1,0,0,174,1,0,0,171,1,0,0,192,5,0,0,187,5,0,0,184,5,0,0,177,1,0,0,196,5,0,0,194,5,0,0,112,1,0,0,111,1,0,0,112,8,0,0,109,1,0,0,111,8,0,0,106,1,0,0,109,8,0,0,107,8,0,0,104,8,0,0,122,1,0,0,121,1,0,0,119,1,0,0,118,8,0,0,116,1,0,0,117,8,0,0,113,1,0,0,114,8,0,0,127,1,0,0,125,1,0,0,123,1,0,0,120,8,0,0,139,5,0,0,138,5,0,0,136,5,0,0,134,5,0,0,129,1,0,0,131,5,0,0,128,1,0,0,143,5,0,0,142,5,0,0,140,5,0,0,144,5,0,0,157,9,0,0,34,3,0,0,137,9,0,0,135,9,0,0,22,3,0,0,18,3,0,0,15,3,0,0,26,3,0,0,105,9,0,0,102,9,0,0,99,9,0,0,238,2,0,0,230,2,0,0,226,2,0,0,110,9,0,0,244,2,0,0,241,2,0,0,184,6,0,0,63,9,0,0,61,9,0,0,58,9,0,0,55,9,0,0,127,6,0,0,181,2,0,0,179,2,0,0,172,2,0,0,69,9,0,0,168,2,0,0,66,9,0,0,190,2,0,0,187,2,0,0,184,2,0,0,192,2,0,0,154,6,0,0,151,6,0,0,33,9,0,0,32,9,0,0,30,9,0,0,28,9,0,0,88,6,0,0,25,9,0,0,86,6,0,0,128,2,0,0,125,2,0,0,40,9,0,0,122,2,0,0,38,9,0,0,118,2,0,0,36,9,0,0,138,2,0,0,136,2,0,0,133,2,0,0,42,9,0,0,143,2,0,0,141,2,0,0,117,6,0,0,115,6,0,0,113,6,0,0,119,6,0,0,52,10,0,0,37,10,0,0,35,10,0,0,11,10,0,0,8,10,0,0,5,10,0,0,16,10,0,0,230,9,0,0,225,9,0,0,222,9,0,0,251,6,0,0,236,9,0,0,233,9,0,0,139,3,0,0,136,3,0,0,132,3,0,0,142,3,0,0,199,9,0,0,198,9,0,0,196,9,0,0,194,9,0,0,232,6,0,0,191,9,0,0,231,6,0,0,206,9,0,0,204,9,0,0,202,9,0,0,101,3,0,0,98,3,0,0,95,3,0,0,209,9,0,0,108,3,0,0,106,3,0,0,246,6,0,0,160,10,0,0,153,10,0,0,151,10,0,0,137,10,0,0,134,10,0,0,131,10,0,0,142,10,0,0,112,10,0,0,110,10,0,0,104,10,0,0,36,7,0,0,118,10,0,0,115,10,0,0,87,10,0,0,86,10,0,0,84,10,0,0,82,10,0,0,31,7,0,0,79,10,0,0,30,7,0,0,94,10,0,0,92,10,0,0,90,10,0,0,97,10,0,0,211,10,0,0,63,7,0,0,205,10,0,0,202,10,0,0,58,7,0,0,57,7,0,0,191,10,0,0,189,10,0,0,187,10,0,0,194,10,0,0,97,1,0,0,100,8,0,0,88,1,0,0,86,1,0,0,80,1,0,0,94,8,0,0,76,1,0,0,92,8,0,0,89,1,0,0,95,5,0,0,93,5,0,0,50,1,0,0,82,8,0,0,43,1,0,0,80,8,0,0,39,1,0,0,77,8,0,0,63,1,0,0,58,1,0,0,55,1,0,0,84,8,0,0,74,5,0,0,72,5,0,0,69,5,0,0,76,5,0,0,6,1,0,0,1,1,0,0,53,8,0,0,253,0,0,0,48,8,0,0,45,8,0,0,18,1,0,0,17,1,0,0,11,1,0,0,59,8,0,0,7,1,0,0,56,8,0,0,24,1,0,0,22,1,0,0,19,1,0,0,36,5,0,0,31,5,0,0,28,5,0,0,40,5,0,0,38,5,0,0,4,8,0,0,202,0,0,0,2,8,0,0,252,7,0,0,248,7,0,0,219,0,0,0,15,8,0,0,212,0,0,0,12,8,0,0,208,0,0,0,7,8,0,0,224,0,0,0,221,0,0,0,18,8,0,0,236,4,0,0,234,4,0,0,228,4,0,0,231,0,0,0,224,4,0,0,229,0,0,0,242,4,0,0,240,4,0,0,237,4,0,0,244,4,0,0,155,0,0,0,206,7,0,0,153,0,0,0,204,7,0,0,202,7,0,0,199,7,0,0,196,7,0,0,165,0,0,0,164,0,0,0,215,7,0,0,162,0,0,0,214,7,0,0,159,0,0,0,211,7,0,0,208,7,0,0,172,0,0,0,171,0,0,0,169,0,0,0,220,7,0,0,166,0,0,0,218,7,0,0,162,4,0,0,160,4,0,0,158,4,0,0,155,4,0,0,175,0,0,0,152,4,0,0,173,0,0,0,168,4,0,0,167,4,0,0,165,4,0,0,163,4,0,0,176,0,0,0,170,4,0,0,169,4,0,0,9,9,0,0,3,9,0,0,1,9,0,0,80,2,0,0,77,2,0,0,246,8,0,0,244,8,0,0,241,8,0,0,66,2,0,0,60,2,0,0,56,2,0,0,249,8,0,0,68,2,0,0,55,6,0,0,224,8,0,0,219,8,0,0,216,8,0,0,11,6,0,0,26,2,0,0,24,2,0,0,17,2,0,0,230,8,0,0,13,2,0,0,227,8,0,0,35,2,0,0,32,2,0,0,29,2,0,0,38,6,0,0,35,6,0,0,189,8,0,0,187,8,0,0,181,8,0,0,213,5,0,0,177,8,0,0,209,5,0,0,222,1,0,0,199,8,0,0,214,1,0,0,196,8,0,0,209,1,0,0,193,8,0,0,237,1,0,0,232,1,0,0,228,1,0,0,202,8,0,0,242,1,0,0,239,1,0,0,0,6,0,0,253,5,0,0,250,5,0,0,3,6,0,0,139,8,0,0,138,8,0,0,136,8,0,0,134,8,0,0,152,5,0,0,131,8,0,0,150,5,0,0,128,8,0,0,147,5,0,0,158,1,0,0,156,1,0,0,149,8,0,0,153,1,0,0,147,8,0,0,149,1,0,0,145,8,0,0,142,8,0,0,170,1,0,0,168,1,0,0,165,1,0,0,155,8,0,0,162,1,0,0,153,8,0,0,175,1,0,0,173,1,0,0,193,5,0,0,191,5,0,0,189,5,0,0,186,5,0,0,178,1,0,0,197,5,0,0,195,5,0,0,174,9,0,0,168,9,0,0,166,9,0,0,155,9,0,0,153,9,0,0,150,9,0,0,158,9,0,0,35,3,0,0,133,9,0,0,128,9,0,0,125,9,0,0,190,6,0,0,139,9,0,0,136,9,0,0,24,3,0,0,21,3,0,0,17,3,0,0,97,9,0,0,95,9,0,0,89,9,0,0,166,6,0,0,85,9,0,0,163,6,0,0,107,9,0,0,104,9,0,0,101,9,0,0,233,2,0,0,229,2,0,0,111,9,0,0,246,2,0,0,243,2,0,0,185,6,0,0,54,9,0,0,53,9,0,0,51,9,0,0,49,9,0,0,125,6,0,0,46,9,0,0,124,6,0,0,43,9,0,0,121,6,0,0,64,9,0,0,62,9,0,0,60,9,0,0,57,9,0,0,130,6,0,0,178,2,0,0,175,2,0,0,70,9,0,0,171,2,0,0,68,9,0,0,189,2,0,0,186,2,0,0,193,2,0,0,155,6,0,0,153,6,0,0,59,10,0,0,57,10,0,0,50,10,0,0,48,10,0,0,45,10,0,0,53,10,0,0,33,10,0,0,28,10,0,0,25,10,0,0,11,7,0,0,39,10,0,0,36,10,0,0,3,10,0,0,1,10,0,0,251,9,0,0,5,7,0,0,247,9,0,0,3,7,0,0,13,10,0,0,10,10,0,0,7,10,0,0,17,10,0,0,221,9,0,0,220,9,0,0,218,9,0,0,216,9,0,0,250,6,0,0,213,9,0,0,249,6,0,0,210,9,0,0,247,6,0,0,231,9,0,0,229,9,0,0,227,9,0,0,224,9,0,0,252,6,0,0,237,9,0,0,235,9,0,0,138,3,0,0,135,3,0,0,143,3,0,0,161,10,0,0,52,7,0,0,155,10,0,0,152,10,0,0,46,7,0,0,44,7,0,0,139,10,0,0,136,10,0,0,133,10,0,0,143,10,0,0,35,7,0,0,34,7,0,0,32,7,0,0,113,10,0,0,111,10,0,0,109,10,0,0,106,10,0,0,37,7,0,0,119,10,0,0,117,10,0,0,66,7,0,0,65,7,0,0,212,10,0,0,62,7,0,0,61,7,0,0,59,7,0,0,64,7,0,0,206,10,0,0,204,10,0,0,143,0,0,0,195,7,0,0,139,0,0,0,194,7,0,0,135,0,0,0,133,0,0,0,131,0,0,0,192,7,0,0,128,0,0,0,191,7,0,0,125,0,0,0,189,7,0,0,138,0,0,0,137,0,0,0,136,0,0,0,193,7,0,0,109,4,0,0,108,4,0,0,106,4,0,0,112,0,0,0,110,0,0,0,182,7,0,0,107,0,0,0,181,7,0,0,104,0,0,0,179,7,0,0,177,7,0,0,122,0,0,0,121,0,0,0,119,0,0,0,117,0,0,0,185,7,0,0,114,0,0,0,184,7,0,0,124,0,0,0,91,4,0,0,90,4,0,0,88,4,0,0,86,4,0,0,93,4,0,0,92,4,0,0,84,0,0,0,83,0,0,0,161,7,0,0,81,0,0,0,160,7,0,0,78,0,0,0,158,7,0,0,156,7,0,0,153,7,0,0,94,0,0,0,93,0,0,0,91,0,0,0,167,7,0,0,88,0,0,0,166,7,0,0,85,0,0,0,163,7,0,0,99,0,0,0,97,0,0,0,95,0,0,0,169,7,0,0,62,4,0,0,61,4,0,0,59,4,0,0,57,4,0,0,54,4,0,0,100,0,0,0,66,4,0,0,65,4,0,0,63,4,0,0,67,4,0,0,49,0,0,0,47,0,0,0,125,7,0,0,44,0,0,0,123,7,0,0,121,7,0,0,118,7,0,0,115,7,0,0,59,0,0,0,134,7,0,0,56,0,0,0,133,7,0,0,53,0,0,0,130,7,0,0,127,7,0,0,66,0,0,0,64,0,0,0,139,7,0,0,61,0,0,0,137,7,0,0,18,4,0,0,16,4,0,0,14,4,0,0,71,0,0,0,11,4,0,0,70,0,0,0,8,4,0,0,68,0,0,0,24,4,0,0,23,4,0,0,21,4,0,0,19,4,0,0,26,4,0,0,25,4,0,0,12,0,0,0,10,0,0,0,77,7,0,0,75,7,0,0,72,7,0,0,69,7,0,0,21,0,0,0,88,7,0,0,19,0,0,0,85,7,0,0,82,7,0,0,79,7,0,0,28,0,0,0,96,7,0,0,25,0,0,0,94,7,0,0,22,0,0,0,91,7,0,0,214,3,0,0,212,3,0,0,209,3,0,0,206,3,0,0,32,0,0,0,30,0,0,0,223,3,0,0,221,3,0,0,219,3,0,0,216,3,0,0,34,0,0,0,227,3,0,0,226,3,0,0,224,3,0,0,103,8,0,0,102,8,0,0,99,8,0,0,98,8,0,0,96,8,0,0,100,1,0,0,99,1,0,0,98,1,0,0,101,8,0,0,91,8,0,0,90,8,0,0,88,8,0,0,86,8,0,0,79,5,0,0,87,1,0,0,85,1,0,0,82,1,0,0,95,8,0,0,79,1,0,0,93,8,0,0,92,1,0,0,91,1,0,0,90,1,0,0,96,5,0,0,94,5,0,0,76,8,0,0,75,8,0,0,73,8,0,0,71,8,0,0,46,5,0,0,68,8,0,0,44,5,0,0,54,1,0,0,52,1,0,0,49,1,0,0,83,8,0,0,46,1,0,0,81,8,0,0,42,1,0,0,79,8,0,0,64,1,0,0,62,1,0,0,60,1,0,0,57,1,0,0,85,8,0,0,66,1,0,0,65,1,0,0,75,5,0,0,73,5,0,0,71,5,0,0,77,5,0,0,44,8,0,0,43,8,0,0,41,8,0,0,39,8,0,0,252,4,0,0,36,8,0,0,250,4,0,0,33,8,0,0,247,4,0,0,3,1,0,0,54,8,0,0,0,1,0,0,52,8,0,0,252,0,0,0,50,8,0,0,47,8,0,0,16,1,0,0,13,1,0,0,60,8,0,0,10,1,0,0,58,8,0,0,25,1,0,0,23,1,0,0,21,1,0,0,37,5,0,0,35,5,0,0,33,5,0,0,30,5,0,0,26,1,0,0,41,5,0,0,39,5,0,0,247,7,0,0,245,7,0,0,243,7,0,0,240,7,0,0,179,4,0,0,237,7,0,0,176,4,0,0,173,4,0,0,207,0,0,0,5,8,0,0,205,0,0,0,3,8,0,0,201,0,0,0,1,8,0,0,254,7,0,0,251,7,0,0,220,0,0,0,218,0,0,0,16,8,0,0,215,0,0,0,14,8,0,0,211,0,0,0,11,8,0,0,228,0,0,0,226,0,0,0,223,0,0,0,21,8,0,0,235,4,0,0,233,4,0,0,230,4,0,0,232,0,0,0,227,4,0,0,230,0,0,0,243,4,0,0,241,4,0,0,239,4,0,0,12,9,0,0,11,9,0,0,8,9,0,0,7,9,0,0,5,9,0,0,10,9,0,0,0,9,0,0,255,8,0,0,253,8,0,0,251,8,0,0,57,6,0,0,4,9,0,0,2,9,0,0,78,2,0,0,240,8,0,0,239,8,0,0,237,8,0,0,235,8,0,0,42,6,0,0,232,8,0,0,41,6,0,0,247,8,0,0,245,8,0,0,243,8,0,0,67,2,0,0,65,2,0,0,62,2,0,0,59,2,0,0,250,8,0,0,70,2,0,0,69,2,0,0,56,6,0,0,215,8,0,0,214,8,0,0,212,8],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+10240);allocate([210,8,0,0,9,6,0,0,207,8,0,0,8,6,0,0,204,8,0,0,5,6,0,0,225,8,0,0,223,8,0,0,221,8,0,0,218,8,0,0,14,6,0,0,23,2,0,0,20,2,0,0,231,8,0,0,16,2,0,0,229,8,0,0,34,2,0,0,31,2,0,0,37,2,0,0,39,6,0,0,37,6,0,0,176,8,0,0,174,8,0,0,172,8,0,0,206,5,0,0,169,8,0,0,205,5,0,0,166,8,0,0,202,5,0,0,199,5,0,0,190,8,0,0,188,8,0,0,186,8,0,0,183,8,0,0,216,5,0,0,180,8,0,0,212,5,0,0,224,1,0,0,221,1,0,0,200,8,0,0,217,1,0,0,198,8,0,0,213,1,0,0,195,8,0,0,234,1,0,0,231,1,0,0,203,8,0,0,241,1,0,0,1,6,0,0,255,5,0,0,252,5,0,0,173,9,0,0,172,9,0,0,170,9,0,0,175,9,0,0,165,9,0,0,164,9,0,0,162,9,0,0,160,9,0,0,194,6,0,0,169,9,0,0,167,9,0,0,149,9,0,0,148,9,0,0,146,9,0,0,144,9,0,0,193,6,0,0,141,9,0,0,192,6,0,0,156,9,0,0,154,9,0,0,152,9,0,0,159,9,0,0,37,3,0,0,36,3,0,0,124,9,0,0,123,9,0,0,121,9,0,0,119,9,0,0,189,6,0,0,116,9,0,0,188,6,0,0,113,9,0,0,186,6,0,0,134,9,0,0,132,9,0,0,130,9,0,0,127,9,0,0,191,6,0,0,140,9,0,0,138,9,0,0,25,3,0,0,23,3,0,0,20,3,0,0,27,3,0,0,84,9,0,0,82,9,0,0,80,9,0,0,161,6,0,0,77,9,0,0,160,6,0,0,74,9,0,0,158,6,0,0,156,6,0,0,98,9,0,0,96,9,0,0,94,9,0,0,91,9,0,0,167,6,0,0,88,9,0,0,165,6,0,0,108,9,0,0,106,9,0,0,103,9,0,0,239,2,0,0,236,2,0,0,232,2,0,0,112,9,0,0,247,2,0,0,245,2,0,0,15,7,0,0,60,10,0,0,58,10,0,0,14,7,0,0,13,7,0,0,51,10,0,0,49,10,0,0,47,10,0,0,54,10,0,0,10,7,0,0,9,7,0,0,7,7,0,0,34,10,0,0,32,10,0,0,30,10,0,0,27,10,0,0,12,7,0,0,40,10,0,0,38,10,0,0,2,7,0,0,1,7,0,0,255,6,0,0,253,6,0,0,4,10,0,0,2,10,0,0,0,10,0,0,253,9,0,0,6,7,0,0,250,9,0,0,4,7,0,0,14,10,0,0,12,10,0,0,9,10,0,0,18,10,0,0,55,7,0,0,54,7,0,0,162,10,0,0,51,7,0,0,50,7,0,0,48,7,0,0,53,7,0,0,156,10,0,0,154,10,0,0,43,7,0,0,42,7,0,0,40,7,0,0,38,7,0,0,47,7,0,0,45,7,0,0,140,10,0,0,138,10,0,0,135,10,0,0,144,10,0,0,25,7,0,0,19,7,0,0,18,7,0,0,129,3,0,0,94,3,0,0,241,6,0,0,61,3,0,0,58,3,0,0,70,3,0,0,224,6,0,0,222,6,0,0,40,3,0,0,177,9,0,0,205,6,0,0,204,6,0,0,202,6,0,0,207,6,0,0,64,10,0,0,26,7,0,0,166,10,0,0,216,10,0,0,14,3,0,0,228,2,0,0,225,2,0,0,179,6,0,0,174,2,0,0,167,2,0,0,183,2,0,0,146,6,0,0,144,6,0,0,127,2,0,0,116,2,0,0,35,9,0,0,135,2,0,0,132,2,0,0,109,6,0,0,107,6,0,0,104,6,0,0,112,6,0,0,90,2,0,0,88,2,0,0,85,2,0,0,83,2,0,0,16,9,0,0,81,2,0,0,14,9,0,0,97,2,0,0,95,2,0,0,92,2,0,0,75,6,0,0,74,6,0,0,72,6,0,0,70,6,0,0,101,2,0,0,79,6,0,0,77,6,0,0,24,9,0,0,158,3,0,0,156,3,0,0,124,3,0,0,118,3,0,0,131,3,0,0,89,3,0,0,82,3,0,0,201,9,0,0,242,6,0,0,56,3,0,0,55,3,0,0,53,3,0,0,51,3,0,0,184,9,0,0,50,3,0,0,182,9,0,0,65,3,0,0,63,3,0,0,60,3,0,0,72,3,0,0,225,6,0,0,223,6,0,0,89,10,0,0,72,10,0,0,70,10,0,0,186,10,0,0,174,10,0,0,172,10,0,0,222,10,0,0,221,10,0,0,58,2,0,0,55,2,0,0,51,6,0,0,19,2,0,0,15,2,0,0,11,2,0,0,28,2,0,0,30,6,0,0,28,6,0,0,220,1,0,0,211,1,0,0,207,1,0,0,192,8,0,0,230,1,0,0,227,1,0,0,244,5,0,0,241,5,0,0,238,5,0,0,249,5,0,0,155,1,0,0,147,1,0,0,144,8,0,0,143,1,0,0,141,8,0,0,167,1,0,0,160,1,0,0,182,5,0,0,177,5,0,0,174,5,0,0,172,1,0,0,188,5,0,0,185,5,0,0,162,8,0,0,110,1,0,0,107,1,0,0,110,8,0,0,104,1,0,0,108,8,0,0,101,1,0,0,105,8,0,0,120,1,0,0,117,1,0,0,114,1,0,0,115,8,0,0,130,5,0,0,129,5,0,0,127,5,0,0,125,5,0,0,126,1,0,0,122,5,0,0,124,1,0,0,137,5,0,0,135,5,0,0,132,5,0,0,141,5,0,0,127,8,0,0,126,8,0,0,9,3,0,0,6,3,0,0,3,3,0,0,16,3,0,0,220,2,0,0,213,2,0,0,210,2,0,0,100,9,0,0,231,2,0,0,180,6,0,0,164,2,0,0,162,2,0,0,156,2,0,0,59,9,0,0,153,2,0,0,56,9,0,0,173,2,0,0,148,6,0,0,145,6,0,0,114,2,0,0,112,2,0,0,110,2,0,0,31,9,0,0,108,2,0,0,29,9,0,0,105,2,0,0,26,9,0,0,129,2,0,0,123,2,0,0,137,2,0,0,110,6,0,0,108,6,0,0,106,6,0,0,6,10,0,0,160,3,0,0,157,3,0,0,226,9,0,0,223,9,0,0,126,3,0,0,123,3,0,0,120,3,0,0,197,9,0,0,195,9,0,0,192,9,0,0,90,3,0,0,88,3,0,0,86,3,0,0,83,3,0,0,243,6,0,0,132,10,0,0,108,10,0,0,105,10,0,0,85,10,0,0,83,10,0,0,80,10,0,0,91,10,0,0,208,10,0,0,199,10,0,0,197,10,0,0,184,10,0,0,183,10,0,0,181,10,0,0,188,10,0,0,96,1,0,0,102,5,0,0,84,1,0,0,81,1,0,0,77,1,0,0,91,5,0,0,89,5,0,0,51,1,0,0,44,1,0,0,40,1,0,0,78,8,0,0,59,1,0,0,56,1,0,0,67,5,0,0,62,5,0,0,70,5,0,0,5,1,0,0,2,1,0,0,250,0,0,0,49,8,0,0,246,0,0,0,46,8,0,0,15,1,0,0,12,1,0,0,8,1,0,0,26,5,0,0,21,5,0,0,18,5,0,0,20,1,0,0,32,5,0,0,29,5,0,0,67,8,0,0,203,0,0,0,0,8,0,0,195,0,0,0,253,7,0,0,191,0,0,0,249,7,0,0,213,0,0,0,209,0,0,0,8,8,0,0,222,4,0,0,220,4,0,0,214,4,0,0,225,0,0,0,210,4,0,0,222,0,0,0,232,4,0,0,229,4,0,0,225,4,0,0,238,4,0,0,32,8,0,0,31,8,0,0,154,0,0,0,205,7,0,0,150,0,0,0,203,7,0,0,147,0,0,0,200,7,0,0,197,7,0,0,163,0,0,0,160,0,0,0,212,7,0,0,156,0,0,0,209,7,0,0,151,4,0,0,150,4,0,0,148,4,0,0,146,4,0,0,143,4,0,0,170,0,0,0,140,4,0,0,167,0,0,0,161,4,0,0,159,4,0,0,156,4,0,0,153,4,0,0,174,0,0,0,166,4,0,0,164,4,0,0,233,7,0,0,232,7,0,0,230,7,0,0,75,2,0,0,74,2,0,0,52,2,0,0,47,2,0,0,44,2,0,0,242,8,0,0,61,2,0,0,52,6,0,0,8,2,0,0,6,2,0,0,0,2,0,0,220,8,0,0,252,1,0,0,217,8,0,0,18,2,0,0,32,6,0,0,29,6,0,0,205,1,0,0,201,1,0,0,185,8,0,0,194,1,0,0,182,8,0,0,190,1,0,0,178,8,0,0,223,1,0,0,215,1,0,0,233,1,0,0,246,5,0,0,243,5,0,0,240,5,0,0,141,1,0,0,139,1,0,0,137,8,0,0,136,1,0,0,135,8,0,0,133,1,0,0,132,8,0,0,129,8,0,0,154,1,0,0,146,8,0,0,146,1,0,0,166,1,0,0,183,5,0,0,181,5,0,0,179,5,0,0,176,5,0,0,190,5,0,0,151,9,0,0,31,3,0,0,129,9,0,0,126,9,0,0,11,3,0,0,8,3,0,0,5,3,0,0,93,9,0,0,90,9,0,0,86,9,0,0,222,2,0,0,216,2,0,0,212,2,0,0,234,2,0,0,181,6,0,0,52,9,0,0,50,9,0,0,47,9,0,0,44,9,0,0,122,6,0,0,165,2,0,0,163,2,0,0,161,2,0,0,158,2,0,0,155,2,0,0,176,2,0,0,149,6,0,0,147,6,0,0,46,10,0,0,29,10,0,0,26,10,0,0,255,9,0,0,252,9,0,0,248,9,0,0,159,3,0,0,219,9,0,0,217,9,0,0,214,9,0,0,211,9,0,0,248,6,0,0,228,9,0,0,127,3,0,0,125,3,0,0,122,3,0,0,158,10,0,0,149,10,0,0,147,10,0,0,129,10,0,0,127,10,0,0,124,10,0,0,103,10,0,0,102,10,0,0,100,10,0,0,98,10,0,0,33,7,0,0,107,10,0,0,209,10,0,0,60,7,0,0,200,10,0,0,198,10,0,0,142,0,0,0,141,0,0,0,115,4,0,0,114,4,0,0,134,0,0,0,132,0,0,0,129,0,0,0,126,0,0,0,190,7,0,0,105,4,0,0,104,4,0,0,102,4,0,0,107,4,0,0,113,0,0,0,111,0,0,0,108,0,0,0,105,0,0,0,180,7,0,0,101,0,0,0,178,7,0,0,120,0,0,0,118,0,0,0,115,0,0,0,85,4,0,0,84,4,0,0,82,4,0,0,80,4,0,0,123,0,0,0,89,4,0,0,87,4,0,0,82,0,0,0,79,0,0,0,159,7,0,0,75,0,0,0,157,7,0,0,72,0,0,0,154,7,0,0,92,0,0,0,89,0,0,0,86,0,0,0,164,7,0,0,53,4,0,0,52,4,0,0,50,4,0,0,48,4,0,0,98,0,0,0,45,4,0,0,96,0,0,0,60,4,0,0,58,4,0,0,55,4,0,0,64,4,0,0,176,7,0,0,175,7,0,0,48,0,0,0,45,0,0,0,124,7,0,0,42,0,0,0,122,7,0,0,39,0,0,0,119,7,0,0,116,7,0,0,60,0,0,0,57,0,0,0,54,0,0,0,131,7,0,0,50,0,0,0,128,7,0,0,7,4,0,0,6,4,0,0,4,4,0,0,2,4,0,0,67,0,0,0,255,3,0,0,65,0,0,0,252,3,0,0,62,0,0,0,17,4,0,0,15,4,0,0,12,4,0,0,9,4,0,0,69,0,0,0,22,4,0,0,20,4,0,0,152,7,0,0,151,7,0,0,149,7,0,0,11,0,0,0,9,0,0,0,76,7,0,0,7,0,0,0,73,7,0,0,70,7,0,0,67,7,0,0,20,0,0,0,86,7,0,0,16,0,0,0,83,7,0,0,13,0,0,0,80,7,0,0,202,3,0,0,200,3,0,0,198,3,0,0,195,3,0,0,29,0,0,0,192,3,0,0,26,0,0,0,23,0,0,0,215,3,0,0,213,3,0,0,210,3,0,0,207,3,0,0,33,0,0,0,203,3,0,0,31,0,0,0,222,3,0,0,220,3,0,0,217,3,0,0,114,7,0,0,112,7,0,0,110,7,0,0,225,3,0,0,95,1,0,0,97,8,0,0,103,5,0,0,75,1,0,0,74,1,0,0,72,1,0,0,70,1,0,0,89,8,0,0,67,1,0,0,87,8,0,0,83,1,0,0,92,5,0,0,90,5,0,0,38,1,0,0,37,1,0,0,35,1,0,0,33,1,0,0,74,8,0,0,30,1,0,0,72,8,0,0,27,1,0,0,69,8,0,0,53,1,0,0,47,1,0,0,61,1,0,0,68,5,0,0,66,5,0,0,64,5,0,0,245,0,0,0,244,0,0,0,242,0,0,0,42,8,0,0,239,0,0,0,40,8,0,0,236,0,0,0,37,8,0,0,34,8,0,0,4,1,0,0,51,8,0,0,249,0,0,0,14,1,0,0,27,5,0,0,25,5,0,0,23,5,0,0,20,5,0,0,34,5,0,0,189,0,0,0,246,7,0,0,186,0,0,0,244,7,0,0,183,0,0,0,241,7,0,0,238,7,0,0,234,7,0,0,206,0,0,0,198,0,0,0,255,7,0,0,194,0,0,0,216,0,0,0,223,4,0,0,221,4,0,0,219,4,0,0,216,4,0,0,227,0,0,0,213,4,0,0,231,4,0,0,6,9,0,0,254,8,0,0,252,8,0,0,238,8,0,0,236,8,0,0,233,8,0,0,53,2,0,0,51,2,0,0,49,2,0,0,46,2,0,0,63,2,0,0,53,6,0,0,213,8,0,0,211,8,0,0,208,8,0,0,205,8,0,0,6,6,0,0,9,2,0,0,7,2,0,0,5,2,0,0,2,2,0,0,222,8,0,0,255,1,0,0,21,2,0,0,33,6,0,0,31,6,0,0,175,8,0,0,173,8,0,0,170,8,0,0,167,8,0,0,203,5,0,0,163,8,0,0,200,5,0,0,203,1,0,0,200,1,0,0,197,1,0,0,184,8,0,0,193,1,0,0,218,1,0,0,235,1,0,0,247,5,0,0,245,5,0,0,242,5,0,0,171,9,0,0,163,9,0,0,161,9,0,0,147,9,0,0,145,9,0,0,142,9,0,0,33,3,0,0,32,3,0,0,122,9,0,0,120,9,0,0,117,9,0,0,114,9,0,0,187,6,0,0,131,9,0,0,12,3,0,0,10,3,0,0,7,3,0,0,83,9,0,0,81,9,0,0,78,9,0,0,75,9,0,0,159,6,0,0,71,9,0,0,157,6,0,0,92,9,0,0,223,2,0,0,221,2,0,0,218,2,0,0,215,2,0,0,237,2,0,0,182,6,0,0,56,10,0,0,55,10,0,0,44,10,0,0,43,10,0,0,41,10,0,0,24,10,0,0,23,10,0,0,21,10,0,0,19,10,0,0,8,7,0,0,31,10,0,0,246,9,0,0,245,9,0,0,243,9,0,0,241,9,0,0,0,7,0,0,238,9,0,0,254,6,0,0,254,9,0,0,161,3,0,0,159,10,0,0,49,7,0,0,150,10,0,0,148,10,0,0,41,7,0,0,39,7,0,0,130,10,0,0,128,10,0,0,126,10,0,0,23,7,0,0,17,7,0,0,16,7,0,0,238,6,0,0,220,6,0,0,218,6,0,0,201,6,0,0,200,6,0,0,198,6,0,0,203,6,0,0,24,7,0,0,175,6,0,0,140,6,0,0,138,6,0,0,121,2,0,0,117,2,0,0,102,6,0,0,100,6,0,0,97,6,0,0,105,6,0,0,86,2,0,0,69,6,0,0,68,6,0,0,66,6,0,0,64,6,0,0,93,2,0,0,73,6,0,0,71,6,0,0,23,9,0,0,119,3,0,0,85,3,0,0,239,6,0,0,54,3,0,0,52,3,0,0,221,6,0,0,219,6,0,0,48,6,0,0,12,2,0,0,24,6,0,0,22,6,0,0,212,1,0,0,208,1,0,0,234,5,0,0,231,5,0,0,228,5,0,0,239,5,0,0,152,1,0,0,148,1,0,0,144,1,0,0,172,5,0,0,167,5,0,0,164,5,0,0,161,1,0,0,178,5,0,0,175,5,0,0,160,8,0,0,108,1,0,0,105,1,0,0,102,1,0,0,106,8,0,0,121,5,0,0,120,5,0,0,118,5,0,0,116,5,0,0,118,1,0,0,113,5,0,0,115,1,0,0,128,5,0,0,126,5,0,0,123,5,0,0,133,5,0,0,125,8,0,0,124,8,0,0,4,3,0,0,214,2,0,0,211,2,0,0,176,6,0,0,160,2,0,0,157,2,0,0,154,2,0,0,170,2,0,0,142,6,0,0,139,6,0,0,113,2,0,0,111,2,0,0,109,2,0,0,106,2,0,0,27,9,0,0,124,2,0,0,120,2,0,0,103,6,0,0,101,6,0,0,99,6,0,0,152,3,0,0,150,3,0,0,116,3,0,0,112,3,0,0,121,3,0,0,81,3,0,0,80,3,0,0,79,3,0,0,78,3,0,0,193,9,0,0,87,3,0,0,84,3,0,0,240,6,0,0,81,10,0,0,182,10,0,0,227,10,0,0,100,5,0,0,78,1,0,0,87,5,0,0,85,5,0,0,45,1,0,0,41,1,0,0,60,5,0,0,58,5,0,0,55,5,0,0,63,5,0,0,255,0,0,0,251,0,0,0,247,0,0,0,16,5,0,0,11,5,0,0,8,5,0,0,9,1,0,0,22,5,0,0,19,5,0,0,65,8,0,0,204,0,0,0,196,0,0,0,192,0,0,0,250,7,0,0,208,4,0,0,206,4,0,0,200,4,0,0,214,0,0,0,196,4,0,0,210,0,0,0,218,4,0,0,215,4,0,0,211,4,0,0,226,4,0,0,29,8,0,0,27,8,0,0,151,0,0,0,148,0,0,0,201,7,0,0,144,0,0,0,198,7,0,0,139,4,0,0,138,4,0,0,136,4,0,0,134,4,0,0,131,4,0,0,161,0,0,0,128,4,0,0,157,0,0,0,149,4,0,0,147,4,0,0,144,4,0,0,141,4,0,0,168,0,0,0,157,4,0,0,154,4,0,0,229,7,0,0,228,7,0,0,226,7,0,0,231,7,0,0,73,2,0,0,48,2,0,0,45,2,0,0,49,6,0,0,4,2,0,0,253,1,0,0,26,6,0,0,23,6,0,0,202,1,0,0,191,1,0,0,179,8,0,0,216,1,0,0,236,5,0,0,233,5,0,0,230,5,0,0,142,1,0,0,140,1,0,0,137,1,0,0,134,1,0,0,133,8,0,0,130,1,0,0,130,8,0,0,151,1,0,0,173,5,0,0,171,5,0,0,169,5,0,0,166,5,0,0,164,1,0,0,180,5,0,0,161,8,0,0,1,3,0,0,252,2,0,0,208,2,0,0,200,2,0,0,87,9,0,0,217,2,0,0,177,6,0,0,152,2,0,0,151,2,0,0,149,2,0,0,147,2,0,0,48,9,0,0,144,2,0,0,45,9,0,0,159,2,0,0,143,6,0,0,141,6,0,0,249,9,0,0,154,3,0,0,151,3,0,0,215,9,0,0,212,9,0,0,117,3,0,0,115,3,0,0,113,3,0,0,125,10,0,0,101,10,0,0,99,10,0,0,207,10,0,0,196,10,0,0,195,10,0,0,140,0,0,0,113,4,0,0,112,4,0,0,130,0,0,0,127,0,0,0,101,4,0,0,100,4,0,0,98,4,0,0,103,4,0,0,109,0,0,0,106,0,0,0,102,0,0,0,79,4,0,0,78,4,0,0,76,4,0,0,74,4,0,0,116,0,0,0,83,4,0,0,81,4,0,0,188,7,0,0,80,0,0,0,76,0,0,0,73,0,0,0,155,7,0,0,44,4,0,0,43,4,0,0,41,4,0,0,39,4,0,0,90,0,0,0,36,4,0,0,87,0,0,0,51,4,0,0,49,4,0,0,46,4,0,0,56,4,0,0,174,7,0,0,173,7,0,0,46,0,0,0,43,0,0,0,40,0,0,0,120,7,0,0,36,0,0,0,117,7,0,0,251,3,0,0,250,3,0,0,248,3,0,0,246,3,0,0,58,0,0,0,243,3,0,0,55,0,0,0,240,3,0,0,51,0,0,0,5,4,0,0,3,4,0,0,0,4,0,0,253,3,0,0,63,0,0,0,13,4,0,0,10,4,0,0,148,7,0,0,147,7,0,0,145,7,0,0,150,7,0,0,8,0,0,0,74,7,0,0,4,0,0,0,71,7,0,0,1,0,0,0,68,7,0,0,188,3,0,0,186,3,0,0,184,3,0,0,181,3,0,0,178,3,0,0,17,0,0,0,14,0,0,0,201,3,0,0,199,3,0,0,196,3,0,0,193,3,0,0,27,0,0,0,189,3,0,0,24,0,0,0,211,3,0,0,208,3,0,0,204,3,0,0,109,7,0,0,108,7,0,0,106,7,0,0,104,7,0,0,218,3,0,0,113,7,0,0,111,7,0,0,94,1,0,0,93,1,0,0,101,5,0,0,73,1,0,0,71,1,0,0,68,1,0,0,88,5,0,0,86,5,0,0,36,1,0,0,34,1,0,0,31,1,0,0,28,1,0,0,70,8,0,0,48,1,0,0,61,5,0,0,59,5,0,0,57,5,0,0,65,5,0,0,243,0,0,0,240,0,0,0,237,0,0,0,38,8,0,0,233,0,0,0,35,8,0,0,254,0,0,0,17,5,0,0,15,5,0,0,13,5,0,0,10,5,0,0,24,5,0,0,66,8,0,0,190,0,0,0,187,0,0,0,184,0,0,0,242,7,0,0,180,0,0,0,239,7,0,0,177,0,0,0,235,7,0,0,199,0,0,0,209,4,0,0,207,4,0,0,205,4,0,0,202,4,0,0,217,0,0,0,199,4,0,0,217,4,0,0,30,8,0,0,28,8,0,0,72,2,0,0,43,2,0,0,42,2,0,0,40,2,0,0,38,2,0,0,234,8,0,0,50,2,0,0,50,6,0,0,251,1,0,0,250,1,0,0,248,1,0,0,246,1,0,0,209,8,0,0,243,1,0,0,206,8,0,0,3,2,0,0,27,6,0,0,25,6,0,0,189,1,0,0,187,1,0,0,185,1,0,0,171,8,0,0,182,1,0,0,168,8,0,0,179,1,0,0,164,8,0,0,204,1,0,0,198,1,0,0,219,1,0,0,237,5,0,0,235,5,0,0,232,5,0,0,143,9,0,0,30,3,0,0,29,3,0,0,118,9,0,0,115,9,0,0,2,3,0,0,0,3,0,0,254,2,0,0,79,9,0,0,76,9,0,0,72,9,0,0,209,2,0,0,207,2,0,0,205,2,0,0,202,2,0,0,219,2,0,0,178,6,0,0,42,10,0,0,22,10,0,0,20,10,0,0,244,9,0,0,242,9,0,0,239,9,0,0,155,3,0,0,153,3,0,0,157,10,0,0,146,10,0,0,145,10,0,0,123,10,0,0,122,10,0,0,120,10,0,0,235,6,0,0,216,6,0,0,214,6,0,0,197,6,0,0,196,6,0,0,195,6,0,0,199,6,0,0,22,7,0,0,171,6,0,0,134,6,0,0,132,6,0,0,95,6,0,0,93,6,0,0,90,6,0,0,98,6,0,0,63,6,0,0,62,6,0,0,60,6,0,0,58,6,0,0,67,6,0,0,65,6,0,0,22,9,0,0,236,6,0,0,217,6,0,0,215,6,0,0,45,6,0,0,18,6,0,0,16,6,0,0,224,5,0,0,221,5,0,0,218,5,0,0,229,5,0,0,162,5,0,0,157,5,0,0,154,5,0,0,145,1,0,0,168,5,0,0,165,5,0,0,158,8,0,0,112,5,0,0,111,5,0,0,109,5,0,0,107,5,0,0,104,5,0,0,103,1,0,0,119,5,0,0,117,5,0,0,114,5,0,0,124,5,0,0,123,8,0,0,122,8,0,0,172,6,0,0,136,6,0,0,133,6,0,0,107,2,0,0,96,6,0,0,94,6,0,0,92,6,0,0,237,6,0,0,98,5,0,0,83,5,0,0,81,5,0,0,53,5,0,0,48,5,0,0,56,5,0,0,6,5,0,0,1,5,0,0,254,4,0,0,248,0,0,0,12,5,0,0,9,5,0,0,63,8,0,0,194,4,0,0,192,4,0,0,186,4,0,0,197,0,0,0,182,4,0,0,193,0,0,0,204,4,0,0,201,4,0,0,197,4,0,0,212,4,0,0,25,8,0,0,23,8,0,0,127,4,0,0,126,4,0,0,124,4,0,0,122,4,0,0,152,0,0,0,119,4,0,0,149,0,0,0,116,4,0,0,145,0,0,0,137,4,0,0,135,4,0,0,132,4,0,0,129,4,0,0,158,0,0,0,145,4,0,0,142,4,0,0,225,7,0,0,224,7,0,0,222,7,0,0,227,7,0,0,46,6,0,0,254,1,0,0,20,6,0,0,17,6,0,0,196,1,0,0,192,1,0,0,226,5,0,0,220,5,0,0,138,1,0,0,135,1,0,0,131,1,0,0,163,5,0,0,161,5,0,0,159,5,0,0,156,5,0,0,170,5,0,0,159,8,0,0,253,2,0,0,204,2,0,0,201,2,0,0,173,6,0,0,150,2,0,0,148,2,0,0,145,2,0,0,137,6,0,0,135,6,0,0,148,3,0,0,146,3,0,0,111,3,0,0,110,3,0,0,109,3,0,0,114,3,0,0,111,4,0,0,110,4,0,0,97,4,0,0,96,4,0,0,94,4,0,0,99,4,0,0,73,4,0,0,72,4,0,0,70,4,0,0,68,4,0,0,103,0,0,0,77,4,0,0,75,4,0,0,187,7,0,0,35,4,0,0,34,4,0,0,32,4,0,0,30,4,0,0,77,0,0,0,27,4,0,0,74,0,0,0,42,4,0,0,40,4,0,0,37,4,0,0,47,4,0,0,172,7,0,0,171,7,0,0,239,3,0,0,238,3,0,0,236,3,0,0,234,3,0,0,231,3,0,0,41,0,0,0,228,3,0,0,37,0,0,0,249,3,0,0,247,3,0,0,244,3,0,0,241,3,0,0,52,0,0,0,1,4,0,0,254,3,0,0,144,7,0,0,143,7,0,0,141,7,0,0,146,7,0,0,174,3,0,0,172,3,0,0,170,3,0,0,167,3,0,0,164,3,0,0,5,0,0,0,2,0,0,0,187,3,0,0,185,3,0,0,182,3,0,0,179,3,0,0,18,0,0,0,175,3,0,0,15,0,0,0,197,3,0,0,194,3,0,0,190,3,0,0,103,7,0,0,102,7,0,0,100,7,0,0,98,7,0,0,205,3,0,0,107,7,0,0,105,7,0,0,99,5,0,0,69,1,0,0,84,5,0,0,82,5,0,0,32,1,0,0,29,1,0,0,54,5,0,0,52,5,0,0,50,5,0,0,241,0,0,0,238,0,0,0,234,0,0,0,7,5,0,0,5,5,0,0,3,5,0,0,0,5,0,0,14,5,0,0,64,8,0,0,188,0,0,0,185,0,0,0,181,0,0,0,178,0,0,0,236,7,0,0,195,4,0,0,193,4,0,0,191,4,0,0,188,4,0,0,200,0,0,0,185,4,0,0,203,4,0,0,26,8,0,0,24,8,0,0,71,2,0,0,41,2,0,0,39,2,0,0,47,6,0,0,249,1,0,0,247,1,0,0,244,1,0,0,1,2,0,0,21,6,0,0,19,6,0,0,188,1,0,0,186,1,0,0,183,1,0,0,180,1,0,0,165,8,0,0,199,1,0,0,195,1,0,0,227,5,0,0,225,5,0,0,222,5,0,0,28,3,0,0,251,2,0,0,250,2,0,0,248,2,0,0,255,2,0,0,199,2,0,0,198,2,0,0,196,2,0,0,194,2,0,0,73,9,0,0,206,2,0,0,203,2,0,0,174,6,0,0,240,9,0,0,149,3,0,0,147,3,0,0,121,10,0,0,91,6,0,0,61,6,0,0,59,6,0,0,21,9,0,0,233,6,0,0,213,6,0,0,211,6,0,0,219,5,0,0,158,5,0,0,155,5,0,0,156,8,0,0,110,5,0,0,108,5,0,0,105,5,0,0,115,5,0,0,121,8,0,0,119,8,0,0,168,6,0,0,129,6,0,0,126,6,0,0,89,6,0,0,87,6,0,0,84,6,0,0,234,6,0,0,49,5,0,0,2,5,0,0,255,4,0,0,61,8,0,0,190,4,0,0,183,4,0,0,198,4,0,0,20,8,0,0,17,8,0,0,125,4,0,0,123,4,0,0,120,4,0,0,117,4,0,0,146,0,0,0,133,4,0,0,130,4,0,0,221,7,0,0,219,7,0,0,216,7,0,0,223,7,0,0,43,6,0,0,13,6,0,0,10,6,0,0,215,5,0,0,207,5,0,0,153,5,0,0,151,5,0,0,148,5,0,0,145,5,0,0,132,1,0,0,160,5,0,0,157,8,0,0,169,6,0,0,146,2,0,0,131,6,0,0,128,6,0,0,95,4,0,0,71,4,0,0,69,4,0,0,186,7,0,0,33,4,0,0,31,4,0,0,28,4,0,0,38,4,0,0,170,7,0,0,168,7,0,0,237,3,0,0,235,3,0,0,232,3,0,0,229,3,0,0,38,0,0,0,245,3,0,0,242,3,0,0,140,7,0,0,138,7,0,0,135,7,0,0,142,7,0,0,173,3,0,0,171,3,0,0,168,3,0,0,165,3,0,0,6,0,0,0,162,3,0,0,3,0,0,0,183,3,0,0,180,3,0,0,176,3,0,0,97,7,0,0,95,7,0,0,92,7,0,0,89,7,0,0,191,3,0,0,101,7,0,0,99,7,0,0,35,0,0,0,97,5,0,0,80,5,0,0,78,5,0,0,47,5,0,0,45,5,0,0,42,5,0,0,51,5,0,0,253,4,0,0,251,4,0,0,248,4,0,0,245,4,0,0,235,0,0,0,4,5,0,0,62,8,0,0,181,4,0,0,180,4,0,0,177,4,0,0,174,4,0,0,182,0,0,0,171,4,0,0,179,0,0,0,189,4,0,0,22,8,0,0,19,8,0,0,44,6,0,0,245,1,0,0,15,6,0,0,12,6,0,0,184,1,0,0,181,1,0,0,217,5,0,0,214,5,0,0,210,5,0,0,223,5,0,0,249,2,0,0,197,2,0,0,195,2,0,0,170,6,0,0,145,3,0,0,144,3,0,0,150,8,0,0,106,5,0,0,116,8,0,0,113,8,0,0,85,6,0,0,230,6,0,0,55,8,0,0,184,4,0,0,10,8,0,0,6,8,0,0,121,4,0,0,118,4,0,0,213,7,0,0,210,7,0,0,207,7,0,0,217,7,0,0,208,5,0,0,149,5,0,0,146,5,0,0,152,8,0,0,162,6,0,0,123,6,0,0,120,6,0,0,183,7,0,0,29,4,0,0,165,7,0,0,162,7,0,0,233,3,0,0,230,3,0,0,132,7,0,0,129,7,0,0,126,7,0,0,136,7,0,0,169,3,0,0,166,3,0,0,163,3,0,0,87,7,0,0,84,7,0,0,81,7,0,0,78,7,0,0,177,3,0,0,93,7,0,0,90,7,0,0,43,5,0,0,249,4,0,0,246,4,0,0,57,8,0,0,178,4,0,0,175,4,0,0,172,4,0,0,187,4,0,0,13,8,0,0,9,8,0,0,40,6,0,0,7,6,0,0,4,6,0,0,204,5,0,0,201,5,0,0,198,5,0,0,211,5,0,0,164,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,2,0,0,120,0,0,0,121,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,8,0,0,0,7,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,2,0,0,122,0,0,0,123,0,0,0,45,0,0,0,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,2,0,0,124,0,0,0,125,0,0,0,0,0,0,0,248,2,0,0,126,0,0,0,127,0,0,0,42,0,0,0,2,0,0,0,3,0,0,0,57,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,109,0,0,208,109,0,0,12,110,0,0,248,109,0,0,18,84,0,0,18,84,0,0,0,0,0,0,37,81,0,0,1,0,0,0,124,94,0,0,2,0,0,0,75,91,0,0,3,0,0,0,249,69,0,0,4,0,0,0,206,64,0,0,5,0,0,0,151,79,0,0,6,0,0,0,160,74,0,0,7,0,0,0,196,119,0,0,8,0,0,0,243,114,0,0,9,0,0,0,170,125,0,0,10,0,0,0,157,120,0,0,11,0,0,0,47,102,0,0,12,0,0,0,24,99,0,0,13,0,0,0,65,108,0,0,14,0,0,0,118,105,0,0,15,0,0,0,137,22,0,0,16,0,0,0,190,19,0,0,17,0,0,0,231,28,0,0,18,0,0,0,208,25,0,0,19,0,0,0,98,7,0,0,20,0,0,0,85,2,0,0,21,0,0,0,12,13,0,0,22,0,0,0,59,8,0,0,23,0,0,0,95,53,0,0,24,0,0,0,104,48,0,0,25,0,0,0,49,63,0,0,26,0,0,0,6,58,0,0,27,0,0,0,180,36,0,0,28,0,0,0,131,33,0,0,29,0,0,0,218,46,0,0,30,0,0,0,237,43,0,0,31,0,0,0,32,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,0,0,0,0,8,3,0,0,128,0,0,0,129,0,0,0,45,0,0,0,45,0,0,0,148,124,0,0,188,133,0,0,153,154,0,0,211,164,0,0,246,187,0,0,98,199,0,0,71,216,0,0,13,230,0,0,40,249,0,0,120,11,1,0,93,20,1,0,23,42,1,0,50,53,1,0,166,73,1,0,131,86,1,0,201,104,1,0,236,119,1,0,196,142,1,0,225,145,1,0,171,175,1,0,142,176,1,0,26,204,1,0,63,211,1,0,117,237,1,0,80,242,1,0,213,9,2,0,240,22,2,0,186,40,2,0,159,55,2,0,11,75,2,0,46,84,2,0,100,106,2,0,65,117,2,0,105,140,2,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,3,0,0,130,0,0,0,131,0,0,0,0,0,0,0,56,3,0,0,132,0,0,0,133,0,0,0,0,0,0,0,72,3,0,0,134,0,0,0,135,0,0,0,42,0,0,0,43,0,0,0,0,0,0,0,40,6,0,0,136,0,0,0,137,0,0,0,0,0,0,0,24,6,0,0,138,0,0,0,139,0,0,0,0,0,0,0,8,6,0,0,140,0,0,0,141,0,0,0,159,206,0,0,167,206,0,0,148,207,0,0,150,207,0,0,60,239,0,0,152,207,0,0,154,207,0,0,156,207,0,0,158,207,0,0,21,208,0,0,160,207,0,0,162,207,0,0,164,207,0,0,74,239,0,0,17,208,0,0,166,207,0,0,168,207,0,0,170,207,0,0,19,208,0,0,172,207,0,0,174,207,0,0,176,207,0,0,178,207,0,0,180,207,0,0,182,207,0,0,184,207,0,0,186,207,0,0,188,207,0,0,58,207,0,0,132,207,0,0,140,207,0,0,74,207,0,0,159,206,0,0,167,206,0,0,82,207,0,0,84,207,0,0,86,207,0,0,88,207,0,0,90,207,0,0,92,207,0,0,94,207,0,0,96,207,0,0,98,207,0,0,100,207,0,0,102,207,0,0,68,239,0,0,104,207,0,0,106,207,0,0,108,207,0,0,110,207,0,0,112,207,0,0,114,207,0,0,116,207,0,0,118,207,0,0,120,207,0,0,122,207,0,0,124,207,0,0,126,207,0,0,128,207,0,0,130,207,0,0,199,206,0,0,132,207,0,0,140,207,0,0,74,207,0,0,159,206,0,0,167,206,0,0,8,207,0,0,10,207,0,0,12,207,0,0,14,207,0,0,16,207,0,0,18,207,0,0,20,207,0,0,22,207,0,0,24,207,0,0,26,207,0,0,28,207,0,0,30,207,0,0,207,206,0,0,32,207,0,0,34,207,0,0,36,207,0,0,38,207,0,0,40,207,0,0,42,207,0,0,44,207,0,0,46,207,0,0,48,207,0,0,50,207,0,0,52,207,0,0,54,207,0,0,56,207,0,0,58,207,0,0,191,206,0,0,66,207,0,0,74,207,0,0,73,239,0,0,207,206,0,0,209,206,0,0,212,206,0,0,215,206,0,0,245,242,0,0,218,206,0,0,220,206,0,0,222,206,0,0,224,206,0,0,226,206,0,0,228,206,0,0,230,206,0,0,232,206,0,0,234,206,0,0,236,206,0,0,238,206,0,0,189,206,0,0,240,206,0,0,190,232,0,0,242,206,0,0,244,206,0,0,246,206,0,0,248,206,0,0,250,206,0,0,252,206,0,0,254,206,0,0,0,207,0,0,2,207,0,0,4,207,0,0,6,207,0,0,191,206,0,0,159,206,0,0,167,206,0,0,169,206,0,0,171,206,0,0,173,206,0,0,175,206,0,0,177,206,0,0,179,206,0,0,181,206,0,0,183,206,0,0,185,206,0,0,187,206,0,0,189,206,0,0,190,232,0,0,191,206,0,0,199,206,0,0,0,0,0,0,104,0,0,0,240,0,0,0,152,1,0,0,96,2,0,0,0,0,0,0,17,0,0,0,40,0,0,0,51,0,0,0,76,0,0,0,0,0,0,0,128,0,0,0,32,1,0,0,224,1,0,0,192,2,0,0,192,3,0,0,224,4,0,0,32,6,0,0,128,7,0,0,0,9,0,0,160,10,0,0,96,12,0,0,64,14,0,0,64,16,0,0,96,18,0,0,160,20,0,0,0,23,0,0,128,25,0,0,32,28,0,0,224,30,0,0,192,33,0,0,192,36,0,0,224,39,0,0,32,43,0,0,128,46,0,0,0,50,0,0,160,53,0,0,96,57,0,0,64,61,0,0,64,65,0,0,96,69,0,0,160,73,0,0,0,78,0,0,0,0,0,0,21,0,0,0,48,0,0,0,60,0,0,0,88,0,0,0,120,0,0,0,156,0,0,0,196,0,0,0,240,0,0,0,230,0,0,0,16,1,0,0,60,1,0,0,108,1,0,0,160,1,0,0,214,1,0,0,16,2,0,0,76,2,0,0,140,2,0,0,208,2,0,0,22,3,0,0,96,3,0,0,172,3,0,0,252,3,0,0,152,3,0,0,224,3,0,0,42,4,0,0,120,4,0,0,200,4,0,0,26,5,0,0,112,5,0,0,200,5,0,0,34,6,0,0,128,6,0,0,0,0,0,0,248,5,0,0,142,0,0,0,143,0,0,0,0,0,0,0,232,5,0,0,144,0,0,0,145,0,0,0,0,0,0,0,24,0,0,0,146,0,0,0,147,0,0,0,46,0,0,0,0,0,0,0,216,5,0,0,148,0,0,0,149,0,0,0,0,0,0,0,184,5,0,0,150,0,0,0,151,0,0,0,56,0,0,0,0,0,0,0,80,8,0,0,152,0,0,0,153,0,0,0,200,255,255,255,200,255,255,255,80,8,0,0,154,0,0,0,155,0,0,0,56,0,0,0,0,0,0,0,168,5,0,0,156,0,0,0,157,0,0,0,200,255,255,255,200,255,255,255,168,5,0,0,158,0,0,0,159,0,0,0,0,0,0,0,152,5,0,0,160,0,0,0,161,0,0,0,44,0,0,0,59,0,0,0,42,0,0,0,49,0,0,0,57,0,0,0,58,0,0,0,60,0,0,0,59,0,0,0,60,0,0,0,49,0,0,0,61,0,0,0,50,0,0,0,136,116,0,0,96,116,0,0,116,116,0,0,156,116,0,0,0,0,0,0,2,0,0,0,255,255,255,255,69,205,0,0,0,0,0,0,1,0,0,0,3,0,0,0,255,255,255,255,48,205,0,0,58,205,0,0,0,0,0,0,4,0,0,0,255,255,255,255,27,205,0,0,37,205,0,0,0,0,0,0,5,0,0,0,255,255,255,255,6,205,0,0,16,205,0,0,0,0,0,0,6,0,0,0,255,255,255,255,241,204,0,0,251,204,0,0,0,0,0,0,7,0,0,0,255,255,255,255,220,204,0,0,230,204,0,0,0,0,0,0,8,0,0,0,255,255,255,255,199,204,0,0,209,204,0,0,0,0,0,0,9,0,0,0,255,255,255,255,178,204,0,0,188,204,0,0,0,0,0,0,10,0,0,0,255,255,255,255,157,204,0,0,167,204,0,0,0,0,0,0,11,0,0,0,255,255,255,255,136,204,0,0,146,204,0,0,0,0,0,0,12,0,0,0,255,255,255,255,113,204,0,0,124,204,0,0,0,0,0,0,13,0,0,0,255,255,255,255,90,204,0,0,101,204,0,0,0,0,0,0,15,0,0,0,255,255,255,255,67,204,0,0,78,204,0,0,0,0,0,0,16,0,0,0,255,255,255,255,44,204,0,0,55,204,0,0,0,0,0,0,17,0,0,0,255,255,255,255,21,204,0,0,32,204,0,0,0,0,0,0,18,0,0,0,255,255,255,255,254,203,0,0,9,204,0,0,0,0,0,0,20,0,0,0,255,255,255,255,239,203,0,0,244,203,0,0,0,0,0,0,21,0,0,0,255,255,255,255,219,203,0,0,226,203,0,0,0,0,0,0,22,0,0,0,255,255,255,255,199,203,0,0,206,203,0,0,0,0,0,0,23,0,0,0,255,255,255,255,179,203,0,0,186,203,0,0,0,0,0,0,24,0,0,0,255,255,255,255,159,203,0,0,166,203,0,0,0,0,0,0,25,0,0,0,255,255,255,255,120,203,0,0,139,203,0,0,148,203,0,0,0,0,0,0,26,0,0,0,255,255,255,255,109,203,0,0,114,203,0,0,0,0,0,0,27,0,0,0,170,0,0,0,255,255,255,255,94,203,0,0,100,203,0,0,0,0,0,0,28,0,0,0,255,255,255,255,89,203,0,0,0,0,0,0,29,0,0,0,255,255,255,255,63,203,0,0,71,203,0,0,78,203,0,0,85,203,0,0,0,0,0,0,30,0,0,0,255,255,255,255,49,203,0,0,56,203,0,0,0,0,0,0,0,0,0,0,136,5,0,0,144,0,0,0,162,0,0,0,0,0,0,0,120,5,0,0,163,0,0,0,164,0,0,0,0,0,0,0,104,5,0,0,165,0,0,0,166,0,0,0,0,0,0,0,88,3,0,0,146,0,0,0,167,0,0,0,46,0,0,0,0,0,0,0,88,5,0,0,136,0,0,0,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,5,0,0,144,0,0,0,169,0,0,0,0,0,0,0,56,5,0,0,170,0,0,0,171,0,0,0,0,0,0,0,40,5,0,0,172,0,0,0,173,0,0,0,0,0,0,0,104,3,0,0,146,0,0,0,174,0,0,0,46,0,0,0,0,0,0,0,24,5,0,0,175,0,0,0,176,0,0,0,0,0,0,0,8,5,0,0,177,0,0,0,178,0,0,0,0,0,0,0,248,4,0,0,179,0,0,0,180,0,0,0,0,0,0,0,216,4,0,0,181,0,0,0,182],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+20480);allocate([3,0,0,0,6,0,0,0,9,0,0,0,96,0,0,0,18,0,0,0,66,0,0,0,33,0,0,0,36,0,0,0,48,0,0,0,72,0,0,0,12,0,0,0,24,0,0,0,69,0,0,0,81,0,0,0,84,0,0,0,21,0,0,0,26,0,0,0,41,0,0,0,11,0,0,0,14,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,4,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,0,0,0,33,1,0,0,97,0,0,0,96,1,0,0,49,0,0,0,48,1,0,0,112,0,0,0,37,0,0,0,36,1,0,0,100,0,0,0,9,1,0,0,73,0,0,0,72,1,0,0,25,0,0,0,24,1,0,0,88,0,0,0,13,0,0,0,12,1,0,0,76,0,0,0,28,0,0,0,3,1,0,0,67,0,0,0,66,1,0,0,19,0,0,0,18,1,0,0,82,0,0,0,7,0,0,0,6,1,0,0,70,0,0,0,22,0,0,0,129,1,0,0,193,0,0,0,192,1,0,0,145,0,0,0,144,1,0,0,208,0,0,0,133,0,0,0,132,1,0,0,196,0,0,0,148,0,0,0,168,0,0,0,162,0,0,0,138,0,0,0,42,0,0,0,0,0,0,0,20,1,0,0,72,1,0,0,68,1,0,0,66,1,0,0,40,1,0,0,36,1,0,0,34,1,0,0,80,1,0,0,18,1,0,0,10,1,0,0,168,1,0,0,164,1,0,0,162,1,0,0,148,1,0,0,146,1,0,0,138,1,0,0,104,1,0,0,100,1,0,0,98,1,0,0,52,1,0,0,26,1,0,0,88,1,0,0,76,1,0,0,70,1,0,0,44,1,0,0,22,1,0,0,180,1,0,0,178,1,0,0,172,1,0,0,166,1,0,0,150,1,0,0,154,1,0,0,108,1,0,0,102,1,0,0,54,1,0,0,58,1,0,0,46,1,0,0,212,1,0,0,210,1,0,0,202,1,0,0,110,1,0,0,118,1,0,0,174,1,0,0,38,1,0,0,218,1,0,0,214,1,0,0,50,1,0,0,94,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,13,0,0,0,14,0,0,0,19,0,0,0,25,0,0,0,28,0,0,0,21,0,0,0,22,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,0,0,0,0,200,4,0,0,134,0,0,0,183,0,0,0,42,0,0,0,43,0,0,0,56,0,0,0,52,0,0,0,50,0,0,0,49,0,0,0,44,0,0,0,38,0,0,0,35,0,0,0,42,0,0,0,41,0,0,0,37,0,0,0,7,0,0,0,11,0,0,0,13,0,0,0,14,0,0,0,19,0,0,0,25,0,0,0,28,0,0,0,21,0,0,0,22,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,4,0,0,184,0,0,0,185,0,0,0,0,0,0,0,136,4,0,0,144,0,0,0,186,0,0,0,0,0,0,0,120,4,0,0,187,0,0,0,188,0,0,0,0,0,0,0,104,4,0,0,189,0,0,0,190,0,0,0,0,0,0,0,88,4,0,0,191,0,0,0,192,0,0,0,62,0,0,0,0,0,0,0,72,4,0,0,191,0,0,0,193,0,0,0,63,0,0,0,0,0,0,0,56,4,0,0,191,0,0,0,194,0,0,0,64,0,0,0,0,0,0,0,40,4,0,0,191,0,0,0,195,0,0,0,65,0,0,0,0,0,0,0,24,4,0,0,191,0,0,0,196,0,0,0,66,0,0,0,0,0,0,0,8,4,0,0,191,0,0,0,197,0,0,0,67,0,0,0,0,0,0,0,248,3,0,0,191,0,0,0,198,0,0,0,68,0,0,0,0,0,0,0,232,3,0,0,191,0,0,0,199,0,0,0,69,0,0,0,0,0,0,0,200,3,0,0,134,0,0,0,200,0,0,0,42,0,0,0,43,0,0,0,0,0,0,0,184,3,0,0,134,0,0,0,201,0,0,0,42,0,0,0,43,0,0,0,0,0,0,0,168,3,0,0,202,0,0,0,203,0,0,0,0,0,0,0,152,3,0,0,144,0,0,0,204,0,0,0,0,0,0,0,0,0,0,0,216,3,0,0,205,0,0,0,206,0,0,0,0,0,0,0,152,4,0,0,207,0,0,0,208,0,0,0,0,0,0,0,168,4,0,0,209,0,0,0,210,0,0,0,0,0,0,0,8,0,0,0,146,0,0,0,211,0,0,0,46,0,0,0,0,0,0,0,232,4,0,0,212,0,0,0,213,0,0,0,0,0,0,0,200,5,0,0,214,0,0,0,215,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,48,0,0,0,44,0,0,0,24,0,0,0,20,0,0,0,18,0,0,0,16,0,0,0,14,0,0,0,12,0,0,0,10,0,0,0,8,0,0,0,6,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,43,0,0,0,0,0,0,0,240,6,0,0,216,0,0,0,217,0,0,0,61,0,0,0,0,0,0,0,0,0,0,0,8,7,0,0,218,0,0,0,219,0,0,0,62,0,0,0,0,0,0,0,32,7,0,0,220,0,0,0,221,0,0,0,63,0,0,0,0,0,0,0,112,7,0,0,222,0,0,0,223,0,0,0,224,0,0,0,225,0,0,0,70,0,0,0,0,0,0,0,64,7,0,0,222,0,0,0,226,0,0,0,224,0,0,0,225,0,0,0,71,0,0,0,43,0,0,0,42,0,0,0,50,0,0,0,0,0,0,0,0,8,0,0,222,0,0,0,227,0,0,0,224,0,0,0,225,0,0,0,71,0,0,0,44,0,0,0,43,0,0,0,51,0,0,0,0,0,0,0,16,8,0,0,222,0,0,0,228,0,0,0,224,0,0,0,225,0,0,0,71,0,0,0,45,0,0,0,44,0,0,0,52,0,0,0,0,0,0,0,96,7,0,0,222,0,0,0,229,0,0,0,224,0,0,0,225,0,0,0,72,0,0,0,0,0,0,0,0,0,0,0,20,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,192,3,0,0,192,4,0,0,192,5,0,0,192,6,0,0,192,7,0,0,192,8,0,0,192,9,0,0,192,10,0,0,192,11,0,0,192,12,0,0,192,13,0,0,192,14,0,0,192,15,0,0,192,16,0,0,192,17,0,0,192,18,0,0,192,19,0,0,192,20,0,0,192,21,0,0,192,22,0,0,192,23,0,0,192,24,0,0,192,25,0,0,192,26,0,0,192,27,0,0,192,28,0,0,192,29,0,0,192,30,0,0,192,31,0,0,192,0,0,0,179,1,0,0,195,2,0,0,195,3,0,0,195,4,0,0,195,5,0,0,195,6,0,0,195,7,0,0,195,8,0,0,195,9,0,0,195,10,0,0,195,11,0,0,195,12,0,0,195,13,0,0,211,14,0,0,195,15,0,0,195,0,0,12,187,1,0,12,195,2,0,12,195,3,0,12,195,4,0,12,211,28,140,0,0,140,140,0,0,228,174,0,0,252,148,0,0,252,142,0,0,0,0,0,0,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,0,0,0,75,0,0,0,170,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,0,0,0,75,0,0,0,162,226,0,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,81,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,88,0,0,0,89,0,0,0,90,0,0,0,91,0,0,0,92,0,0,0,93,0,0,0,94,0,0,0,95,0,0,0,96,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,81,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,88,0,0,0,89,0,0,0,90,0,0,0,123,0,0,0,124,0,0,0,125,0,0,0,126,0,0,0,127],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+30728);allocate([1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,97,0,0,0,98,0,0,0,99,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,103,0,0,0,104,0,0,0,105,0,0,0,106,0,0,0,107,0,0,0,108,0,0,0,109,0,0,0,110,0,0,0,111,0,0,0,112,0,0,0,113,0,0,0,114,0,0,0,115,0,0,0,116,0,0,0,117,0,0,0,118,0,0,0,119,0,0,0,120,0,0,0,121,0,0,0,122,0,0,0,91,0,0,0,92,0,0,0,93,0,0,0,94,0,0,0,95,0,0,0,96,0,0,0,97,0,0,0,98,0,0,0,99,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,103,0,0,0,104,0,0,0,105,0,0,0,106,0,0,0,107,0,0,0,108,0,0,0,109,0,0,0,110,0,0,0,111,0,0,0,112,0,0,0,113,0,0,0,114,0,0,0,115,0,0,0,116,0,0,0,117,0,0,0,118,0,0,0,119,0,0,0,120,0,0,0,121,0,0,0,122,0,0,0,123,0,0,0,124,0,0,0,125,0,0,0,126,0,0,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,8,0,0,230,0,0,0,231,0,0,0,44,0,0,0,59,0,0,0,46,0,0,0,53,0,0,0,57,0,0,0,58,0,0,0,60,0,0,0,65,0,0,0,60,0,0,0,51,0,0,0,61,0,0,0,52,0,0,0,0,0,0,0,32,8,0,0,232,0,0,0,233,0,0,0,62,0,0,0,0,0,0,0,48,8,0,0,234,0,0,0,235,0,0,0,0,0,0,0,104,8,0,0,236,0,0,0,237,0,0,0,66,0,0,0,45,0,0,0,77,0,0,0,78,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,96,9,0,0,238,0,0,0,239,0,0,0,240,0,0,0,44,0,0,0,54,0,0,0,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,9,0,0,241,0,0,0,242,0,0,0,240,0,0,0,45,0,0,0,55,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,9,0,0,243,0,0,0,244,0,0,0,240,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,9,0,0,245,0,0,0,246,0,0,0,240,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,247,0,0,0,248,0,0,0,240,0,0,0,46,0,0,0,47,0,0,0,65,0,0,0,48,0,0,0,66,0,0,0,42,0,0,0,43,0,0,0,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,10,0,0,249,0,0,0,250,0,0,0,240,0,0,0,50,0,0,0,51,0,0,0,67,0,0,0,52,0,0,0,68,0,0,0,44,0,0,0,45,0,0,0,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,10,0,0,251,0,0,0,252,0,0,0,240,0,0,0,67,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,42,0,0,0,248,255,255,255,64,10,0,0,68,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,10,0,0,253,0,0,0,254,0,0,0,240,0,0,0,75,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,43,0,0,0,248,255,255,255,104,10,0,0,76,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,81,0,0,0,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,10,0,0,255,0,0,0,0,1,0,0,240,0,0,0,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,10,0,0,1,1,0,0,2,1,0,0,240,0,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,10,0,0,3,1,0,0,4,1,0,0,240,0,0,0,83,0,0,0,84,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,85,0,0,0,49,0,0,0,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,10,0,0,5,1,0,0,6,1,0,0,240,0,0,0,86,0,0,0,87,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,88,0,0,0,55,0,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,11,0,0,7,1,0,0,8,1,0,0,240,0,0,0,89,0,0,0,90,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,91,0,0,0,61,0,0,0,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,11,0,0,9,1,0,0,10,1,0,0,240,0,0,0,92,0,0,0,93,0,0,0,63,0,0,0,64,0,0,0,65,0,0,0,66,0,0,0,94,0,0,0,67,0,0,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,11,0,0,11,1,0,0,12,1,0,0,240,0,0,0,45,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,11,0,0,13,1,0,0,14,1,0,0,240,0,0,0,47,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,11,0,0,15,1,0,0,16,1,0,0,240,0,0,0,42,0,0,0,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,11,0,0,17,1,0,0,18,1,0,0,240,0,0,0,43,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,11,0,0,19,1,0,0,20,1,0,0,240,0,0,0,81,0,0,0,47,0,0,0,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,11,0,0,21,1,0,0,22,1,0,0,240,0,0,0,82,0,0,0,48,0,0,0,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,9,0,0,23,1,0,0,24,1,0,0,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,9,0,0,25,1,0,0,26,1,0,0,240,0,0,0,53,0,0,0,83,0,0,0,54,0,0,0,84,0,0,0,55,0,0,0,48,0,0,0,85,0,0,0,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,9,0,0,27,1,0,0,28,1,0,0,240,0,0,0,44,0,0,0,45,0,0,0,55,0,0,0,95,0,0,0,96,0,0,0,56,0,0,0,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,9,0,0,29,1,0,0,30,1,0,0,240,0,0,0,98,0,0,0,99,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,0,0,0,0,176,9,0,0,31,1,0,0,32,1,0,0,240,0,0,0,100,0,0,0,101,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,0,0,0,0,128,8,0,0,33,1,0,0,34,1,0,0,240,0,0,0,0,0,0,0,144,8,0,0,33,1,0,0,35,1,0,0,240,0,0,0,86,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,56,0,0,0,87,0,0,0,57,0,0,0,88,0,0,0,58,0,0,0,52,0,0,0,89,0,0,0,57,0,0,0,0,0,0,0,176,8,0,0,33,1,0,0,36,1,0,0,240,0,0,0,46,0,0,0,47,0,0,0,58,0,0,0,102,0,0,0,103,0,0,0,59,0,0,0,104,0,0,0,0,0,0,0,208,8,0,0,33,1,0,0,37,1,0,0,240,0,0,0,48,0,0,0,49,0,0,0,60,0,0,0,105,0,0,0,106,0,0,0,61,0,0,0,107,0,0,0,0,0,0,0,240,8,0,0,33,1,0,0,38,1,0,0,240,0,0,0,50,0,0,0,51,0,0,0,62,0,0,0,108,0,0,0,109,0,0,0,63,0,0,0,110,0,0,0,0,0,0,0,16,9,0,0,33,1,0,0,39,1,0,0,240,0,0,0,50,0,0,0,51,0,0,0,62,0,0,0,108,0,0,0,109,0,0,0,63,0,0,0,110,0,0,0,0,0,0,0,32,9,0,0,33,1,0,0,40,1,0,0,240,0,0,0,50,0,0,0,51,0,0,0,62,0,0,0,108,0,0,0,109,0,0,0,63,0,0,0,110,0,0,0,0,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,37,0,0,0,89,0,0,0,45,0,0,0,37,0,0,0,109,0,0,0,45,0,0,0,37,0,0,0,100,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,0,0,0,114,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,102,0,0,0,97,0,0,0,108,0,0,0,115,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,110,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,114,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,117,0,0,0,114,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,114,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,99,0,0,0,104,0,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,105,0,0,0,108,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,101,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,121,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,117,0,0,0,115,0,0,0,116,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,116,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,111,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,77,0,0,0,0,0,0,0,80,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,97,0,0,0,32,0,0,0,37,0,0,0,98,0,0,0,32,0,0,0,37,0,0,0,100,0,0,0,32,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,15,0,0,41,1,0,0,42,1,0,0,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,3,32,2,32,2,32,2,32,2,32,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,96,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,8,216,8,216,8,216,8,216,8,216,8,216,8,216,8,216,8,216,8,216,4,192,4,192,4,192,4,192,4,192,4,192,4,192,8,213,8,213,8,213,8,213,8,213,8,213,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,4,192,4,192,4,192,4,192,4,192,4,192,8,214,8,214,8,214,8,214,8,214,8,214,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,4,192,4,192,4,192,4,192,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,53,122,120,105,110,103,49,53,82,101,97,100,101,114,69,120,99,101,112,116,105,111,110,69,0,78,53,122,120,105,110,103,57,69,120,99,101,112,116,105,111,110,69,0,49,55,73,109,97,103,101,82,101,97,100,101,114,83,111,117,114,99,101,0,78,53,122,120,105,110,103,56,65,114,114,97,121,82,101,102,73,99,69,69,0,78,53,122,120,105,110,103,55,67,111,117,110,116,101,100,69,0,78,53,122,120,105,110,103,53,65,114,114,97,121,73,99,69,69,0,78,53,122,120,105,110,103,56,65,114,114,97,121,82,101,102,73,78,83,95,51,82,101,102,73,78,83,95,49,49,82,101,115,117,108,116,80,111,105,110,116,69,69,69,69,69,0,78,53,122,120,105,110,103,53,97,122,116,101,99,49,49,65,122,116,101,99,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,57,66,105,110,97,114,105,122,101,114,69,0,78,53,122,120,105,110,103,49,50,66,105,110,97,114,121,66,105,116,109,97,112,69,0,78,53,122,120,105,110,103,49,55,67,104,101,99,107,115,117,109,69,120,99,101,112,116,105,111,110,69,0,78,53,122,120,105,110,103,56,66,105,116,65,114,114,97,121,69,0,78,53,122,120,105,110,103,57,66,105,116,77,97,116,114,105,120,69,0,0,78,53,122,120,105,110,103,50,52,71,108,111,98,97,108,72,105,115,116,111,103,114,97,109,66,105,110,97,114,105,122,101,114,69,0,0,78,53,122,120,105,110,103,49,53,72,121,98,114,105,100,66,105,110,97,114,105,122,101,114,69,0,78,53,122,120,105,110,103,50,52,73,108,108,101,103,97,108,65,114,103,117,109,101,110,116,69,120,99,101,112,116,105,111,110,69,0,78,53,122,120,105,110,103,50,48,82,101,101,100,83,111,108,111,109,111,110,69,120,99,101,112,116,105,111,110,69,0,78,53,122,120,105,110,103,49,48,100,97,116,97,109,97,116,114,105,120,49,54,68,97,116,97,77,97,116,114,105,120,82,101,97,100,101,114,69,0,42,42,42,32,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,58,59,60,61,62,63,64,91,92,93,94,95,42,42,42,32,48,49,50,51,52,53,54,55,56,57,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,39,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,123,124,125,126,127,78,53,122,120,105,110,103,49,48,100,97,116,97,109,97,116,114,105,120,56,68,101,116,101,99,116,111,114,69,0,78,53,122,120,105,110,103,49,48,100,97,116,97,109,97,116,114,105,120,55,86,101,114,115,105,111,110,69,0,78,53,122,120,105,110,103,49,53,70,111,114,109,97,116,69,120,99,101,112,116,105,111,110,69,0,78,53,122,120,105,110,103,50,51,73,110,118,101,114,116,101,100,76,117,109,105,110,97,110,99,101,83,111,117,114,99,101,69,0,78,53,122,120,105,110,103,49,53,76,117,109,105,110,97,110,99,101,83,111,117,114,99,101,69,0,78,53,122,120,105,110,103,53,109,117,108,116,105,50,56,71,101,110,101,114,105,99,77,117,108,116,105,112,108,101,66,97,114,99,111,100,101,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,53,109,117,108,116,105,50,49,77,117,108,116,105,112,108,101,66,97,114,99,111,100,101,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,53,109,117,108,116,105,49,51,77,117,108,116,105,68,101,116,101,99,116,111,114,69,0,78,53,122,120,105,110,103,53,109,117,108,116,105,50,52,77,117,108,116,105,70,105,110,100,101,114,80,97,116,116,101,114,110,70,105,110,100,101,114,69,0,78,53,122,120,105,110,103,53,109,117,108,116,105,49,55,81,82,67,111,100,101,77,117,108,116,105,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,49,55,77,117,108,116,105,70,111,114,109,97,116,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,49,51,67,111,100,97,66,97,114,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,49,51,67,111,100,101,49,50,56,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,49,50,67,111,100,101,51,57,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,49,50,67,111,100,101,57,51,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,49,49,69,65,78,49,51,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,49,48,69,65,78,56,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,57,73,84,70,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,50,49,77,117,108,116,105,70,111,114,109,97,116,79,110,101,68,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,50,51,77,117,108,116,105,70,111,114,109,97,116,85,80,67,69,65,78,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,49,48,79,110,101,68,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,49,48,85,80,67,65,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,49,50,85,80,67,69,65,78,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,49,48,85,80,67,69,82,101,97,100,101,114,69,0,59,60,62,64,91,92,125,95,96,126,33,13,9,44,58,10,45,46,36,47,34,124,42,40,41,63,123,125,39,48,49,50,51,52,53,54,55,56,57,38,13,9,44,58,35,45,46,36,47,43,37,42,61,94,78,53,122,120,105,110,103,54,112,100,102,52,49,55,55,100,101,99,111,100,101,114,50,101,99,49,49,77,111,100,117,108,117,115,80,111,108,121,69,0,78,53,122,120,105,110,103,54,112,100,102,52,49,55,49,50,80,68,70,52,49,55,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,56,68,97,116,97,77,97,115,107,69,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,32,36,37,42,43,45,46,47,58,78,53,122,120,105,110,103,54,113,114,99,111,100,101,50,50,65,108,105,103,110,109,101,110,116,80,97,116,116,101,114,110,70,105,110,100,101,114,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,56,68,101,116,101,99,116,111,114,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,50,81,82,67,111,100,101,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,55,86,101,114,115,105,111,110,69,0,78,53,122,120,105,110,103,54,82,101,97,100,101,114,69,0,78,53,122,120,105,110,103,54,82,101,115,117,108,116,69,0,78,53,122,120,105,110,103,49,49,82,101,115,117,108,116,80,111,105,110,116,69,0,100,97,116,97,32,105,115,32,116,111,111,32,108,111,110,103,0,114,115,32,100,101,99,111,100,105,110,103,32,102,97,105,108,101,100,0,98,105,116,32,119,97,115,32,110,111,116,32,105,110,118,101,114,116,101,100,0,105,110,118,97,108,105,100,32,105,110,112,117,116,32,100,97,116,97,0,67,84,82,76,95,0,101,110,99,111,117,110,116,101,114,101,100,32,119,114,111,110,103,32,98,117,108,108,115,101,121,101,32,114,105,110,103,32,99,111,117,110,116,0,98,117,108,108,115,101,121,101,32,101,120,116,101,110,100,115,32,111,118,101,114,32,105,109,97,103,101,32,98,111,117,110,100,115,0,99,111,117,108,100,32,110,111,116,32,100,101,116,101,114,109,105,110,101,32,111,114,105,101,110,116,97,116,105,111,110,0,109,97,116,114,105,120,32,101,120,116,101,110,100,115,32,111,118,101,114,32,105,109,97,103,101,32,98,111,117,110,100,115,0,102,97,105,108,101,100,32,116,111,32,100,101,99,111,100,101,32,112,97,114,97,109,101,116,101,114,32,100,97,116,97,0,76,101,102,116,32,97,110,100,32,116,111,112,32,109,117,115,116,32,98,101,32,110,111,110,110,101,103,97,116,105,118,101,0,72,101,105,103,104,116,32,97,110,100,32,119,105,100,116,104,32,109,117,115,116,32,98,101,32,97,116,32,108,101,97,115,116,32,49,0,84,104,101,32,114,101,103,105,111,110,32,109,117,115,116,32,102,105,116,32,105,110,115,105,100,101,32,116,104,101,32,109,97,116,114,105,120,0,73,110,118,97,108,105,100,32,100,105,109,101,110,115,105,111,110,115,32,87,104,105,116,101,82,101,99,116,97,110,103,108,101,68,101,116,101,99,116,111,114,0,122,32,61,61,32,78,85,76,76,0,116,32,61,61,32,78,85,76,76,0,120,32,61,61,32,78,85,76,76,0,121,32,61,61,32,78,85,76,76,0,78,111,32,98,108,97,99,107,32,112,111,105,110,116,32,102,111,117,110,100,32,111,110,32,98,111,114,100,101,114,0,84,114,97,110,115,102,111,114,109,101,100,32,112,111,105,110,116,32,111,117,116,32,111,102,32,98,111,117,110,100,115,32,97,116,32,0,68,101,103,114,101,101,32,109,117,115,116,32,98,101,32,110,111,110,45,110,101,103,97,116,105,118,101,0,99,97,110,110,111,116,32,103,105,118,101,32,108,111,103,40,48,41,0,67,97,110,110,111,116,32,99,97,108,99,117,108,97,116,101,32,116,104,101,32,105,110,118,101,114,115,101,32,111,102,32,48,0,110,101,101,100,32,99,111,101,102,102,105,99,105,101,110,116,115,0,71,101,110,101,114,105,99,71,70,80,111,108,121,115,32,100,111,32,110,111,116,32,104,97,118,101,32,115,97,109,101,32,71,101,110,101,114,105,99,71,70,32,102,105,101,108,100,0,100,101,103,114,101,101,32,109,117,115,116,32,110,111,116,32,98,101,32,108,101,115,115,32,116,104,101,110,32,48,0,66,97,100,32,101,114,114,111,114,32,108,111,99,97,116,105,111,110,0,114,95,123,105,45,49,125,32,119,97,115,32,122,101,114,111,0,68,105,118,105,115,105,111,110,32,97,108,103,111,114,105,116,104,109,32,102,97,105,108,101,100,32,116,111,32,114,101,100,117,99,101,32,112,111,108,121,110,111,109,105,97,108,63,0,115,105,103,109,97,84,105,108,100,101,40,48,41,32,119,97,115,32,122,101,114,111,0,69,114,114,111,114,32,108,111,99,97,116,111,114,32,100,101,103,114,101,101,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,110,117,109,98,101,114,32,111,102,32,114,111,111,116,115,0,83,72,73,70,84,95,74,73,83,0,73,83,79,56,56,53,57,45,49,0,68,105,109,101,110,115,105,111,110,32,109,117,115,116,32,98,101,32,101,118,101,110,44,32,62,32,56,32,60,32,49,52,52,0,67,111,117,108,100,110,39,116,32,100,101,99,111,100,101,32,118,101,114,115,105,111,110,0,68,105,109,101,110,115,105,111,110,32,111,102,32,98,105,116,77,97,116,114,105,120,32,109,117,115,116,32,109,97,116,99,104,32,116,104,101,32,118,101,114,115,105,111,110,32,115,105,122,101,0,85,110,115,117,112,112,111,114,116,101,100,32,109,111,100,101,32,105,110,100,105,99,97,116,111,114,0,78,111,116,32,101,110,111,117,103,104,32,98,105,116,115,32,116,111,32,100,101,99,111,100,101,0,91,41,62,82,83,48,53,71,83,0,82,83,69,79,84,0,91,41,62,82,83,48,54,71,83,0,78,111,116,32,116,111,32,98,101,32,117,115,101,100,32,105,110,32,65,83,67,73,73,32,101,110,99,111,100,97,116,105,111,110,0,100,101,99,111,100,101,67,52,48,83,101,103,109,101,110,116,58,32,85,112,112,101,114,32,83,104,105,102,116,0,100,101,99,111,100,101,67,52,48,83,101,103,109,101,110,116,58,32,110,111,32,99,97,115,101,0,100,101,99,111,100,101,84,101,120,116,83,101,103,109,101,110,116,58,32,85,112,112,101,114,32,83,104,105,102,116,0,100,101,99,111,100,101,84,101,120,116,83,101,103,109,101,110,116,58,32,110,111,32,99,97,115,101,0,100,101,99,111,100,101,65,110,115,105,88,49,50,83,101,103,109,101,110,116,58,32,110,111,32,99,97,115,101,0,78,101,103,97,116,105,118,101,65,114,114,97,121,83,105,122,101,69,120,99,101,112,116,105,111,110,0,98,121,116,101,83,101,103,109,101,110,116,115,0,78,117,109,98,101,114,32,111,102,32,114,111,119,115,32,97,110,100,32,99,111,108,117,109,110,115,32,109,117,115,116,32,98,101,32,101,118,101,110,0,69,114,114,111,114,32,118,101,114,115,105,111,110,32,110,111,116,32,102,111,117,110,100,0,85,110,114,101,99,111,103,110,105,122,100,32,98,97,114,99,111,100,101,32,102,111,114,109,97,116,0,84,104,105,115,32,108,117,109,105,110,97,110,99,101,32,115,111,117,114,99,101,32,100,111,101,115],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+38136);allocate([32,110,111,116,32,115,117,112,112,111,114,116,32,99,114,111,112,112,105,110,103,46,0,84,104,105,115,32,108,117,109,105,110,97,110,99,101,32,115,111,117,114,99,101,32,100,111,101,115,32,110,111,116,32,115,117,112,112,111,114,116,32,114,111,116,97,116,105,111,110,46,0,78,111,32,99,111,100,101,32,100,101,116,101,99,116,101,100,0,48,49,50,51,52,53,54,55,56,57,45,36,58,47,46,43,65,66,67,68,0,65,66,67,68,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,45,46,32,42,36,47,43,37,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,45,46,32,36,47,43,37,97,98,99,100,42,0,48,48,48,48,0,48,48,48,48,48,0,66,105,116,77,97,116,114,105,120,80,97,114,115,101,114,58,58,114,101,97,100,67,111,100,101,119,111,114,100,115,40,80,68,70,41,58,32,84,111,111,32,109,97,110,121,32,114,111,119,115,33,0,66,105,116,77,97,116,114,105,120,80,97,114,115,101,114,58,58,112,114,111,99,101,115,115,82,111,119,40,80,68,70,52,49,55,41,58,32,101,114,97,115,101,67,111,117,110,116,32,116,111,111,32,98,105,103,33,0,66,105,116,77,97,116,114,105,120,80,97,114,115,101,114,58,58,112,114,111,99,101,115,115,82,111,119,40,80,68,70,52,49,55,41,58,32,99,111,100,101,119,111,114,100,115,32,105,110,100,101,120,32,111,117,116,32,111,102,32,98,111,117,110,100,46,0,66,105,116,77,97,116,114,105,120,80,97,114,115,101,114,58,58,116,114,105,109,65,114,114,97,121,58,32,110,101,103,97,116,105,118,101,32,115,105,122,101,33,0,68,101,99,111,100,101,100,66,105,116,83,116,114,101,97,109,80,97,114,115,101,114,58,58,100,101,99,111,100,101,66,97,115,101,57,48,48,116,111,66,97,115,101,49,48,58,32,83,116,114,105,110,103,32,100,111,101,115,32,110,111,116,32,98,101,103,105,110,32,119,105,116,104,32,49,0,80,68,70,58,68,101,99,111,100,101,114,58,100,101,99,111,100,101,58,32,99,97,110,110,111,116,32,114,101,97,100,32,99,111,100,101,119,111,114,100,115,0,80,68,70,58,68,101,99,111,100,101,114,58,99,111,114,114,101,99,116,69,114,114,111,114,115,58,32,84,111,111,32,109,97,110,121,32,101,114,114,111,114,115,32,111,114,32,69,67,32,67,111,100,101,119,111,114,100,115,32,99,111,114,114,117,112,116,101,100,0,80,68,70,58,68,101,99,111,100,101,114,58,99,111,114,114,101,99,116,69,114,114,111,114,115,58,32,69,114,114,111,114,32,99,111,114,114,101,99,116,105,111,110,32,100,105,100,32,110,111,116,32,115,117,99,99,101,101,100,33,0,80,68,70,58,68,101,99,111,100,101,114,58,118,101,114,105,102,121,67,111,100,101,119,111,114,100,67,111,117,110,116,58,32,99,111,100,101,119,111,114,100,32,97,114,114,97,121,32,116,111,111,32,115,109,97,108,108,33,0,80,68,70,58,68,101,99,111,100,101,114,58,118,101,114,105,102,121,67,111,100,101,119,111,114,100,67,111,117,110,116,58,32,98,97,100,32,99,111,100,101,119,111,114,100,32,110,117,109,98,101,114,32,100,101,115,99,114,105,112,116,111,114,33,0,80,68,70,58,68,101,99,111,100,101,114,58,118,101,114,105,102,121,67,111,100,101,119,111,114,100,67,111,117,110,116,58,32,98,97,100,32,101,114,114,111,114,32,99,111,114,114,101,99,116,105,111,110,32,99,119,32,110,117,109,98,101,114,33,0,66,97,100,32,101,114,114,111,114,32,108,111,99,97,116,105,111,110,33,0,69,117,99,108,105,100,101,97,110,32,97,108,103,111,114,105,116,104,109,32,97,108,114,101,97,100,121,32,116,101,114,109,105,110,97,116,101,100,63,0,115,105,103,109,97,84,105,108,100,101,32,61,32,48,33,0,69,114,114,111,114,32,110,117,109,98,101,114,32,105,110,99,111,110,115,105,115,116,101,110,99,121,33,0,109,111,110,111,109,105,97,108,58,32,100,101,103,114,101,101,32,60,32,48,33,0,108,111,103,32,111,102,32,122,101,114,111,33,0,105,110,118,101,114,115,101,32,111,102,32,122,101,114,111,33,0,110,111,32,99,111,101,102,102,105,99,105,101,110,116,115,33,0,77,111,100,117,108,117,115,80,111,108,121,115,32,100,111,32,110,111,116,32,104,97,118,101,32,115,97,109,101,32,77,111,100,117,108,117,115,71,70,32,102,105,101,108,100,0,110,101,103,97,116,105,118,101,32,100,101,103,114,101,101,33,0,78,111,32,118,101,114,116,105,99,101,115,32,102,111,117,110,100,46,0,66,97,100,32,109,111,100,117,108,101,32,119,105,100,116,104,46,0,66,97,100,32,100,105,109,101,110,115,105,111,110,46,0,67,97,110,110,111,116,32,102,105,110,100,32,101,110,111,117,103,104,32,80,68,70,52,49,55,32,103,117,97,114,100,32,112,97,116,116,101,114,110,115,33,0,80,68,70,58,68,101,116,101,99,116,111,114,58,32,99,97,110,110,111,116,32,102,105,110,100,32,116,104,101,32,99,114,111,115,115,105,110,103,32,111,102,32,112,97,114,97,108,108,101,108,32,108,105,110,101,115,33,0,80,68,70,58,68,101,116,101,99,116,111,114,58,32,99,114,111,115,115,105,110,103,32,112,111,105,110,116,115,32,111,117,116,32,111,102,32,114,101,103,105,111,110,33,0,73,110,99,111,110,115,105,115,116,101,110,116,32,110,117,109,98,101,114,32,111,102,32,115,121,109,98,111,108,115,32,105,110,32,116,104,105,115,32,108,105,110,101,46,0,68,105,109,101,110,115,105,111,110,32,109,117,115,116,32,98,101,32,49,32,109,111,100,32,52,32,97,110,100,32,62,61,32,50,49,0,67,111,117,108,100,32,110,111,116,32,100,101,99,111,100,101,32,102,111,114,109,97,116,32,105,110,102,111,114,109,97,116,105,111,110,0,67,111,117,108,100,32,110,111,116,32,100,101,99,111,100,101,32,118,101,114,115,105,111,110,0,68,105,100,32,110,111,116,32,114,101,97,100,32,97,108,108,32,99,111,100,101,119,111,114,100,115,0,68,97,116,97,32,98,108,111,99,107,32,115,105,122,101,115,32,100,105,102,102,101,114,32,98,121,32,109,111,114,101,32,116,104,97,110,32,49,0,114,97,119,67,111,100,101,119,111,114,100,115,79,102,102,115,101,116,32,33,61,32,114,97,119,67,111,100,101,119,111,114,100,115,46,108,101,110,103,116,104,0,114,101,102,101,114,101,110,99,101,32,109,117,115,116,32,98,101,32,98,101,116,119,101,101,110,32,48,32,97,110,100,32,55,0,102,111,114,109,97,116,32,101,120,99,101,112,116,105,111,110,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,102,111,114,32,51,45,100,105,103,105,116,32,117,110,105,116,58,32,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,102,111,114,32,50,45,100,105,103,105,116,32,117,110,105,116,58,32,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,102,111,114,32,100,105,103,105,116,32,117,110,105,116,58,32,0,73,108,108,101,103,97,108,32,109,111,100,101,32,98,105,116,115,58,32,0,67,111,117,108,100,32,110,111,116,32,102,105,110,100,32,97,108,105,103,110,109,101,110,116,32,112,97,116,116,101,114,110,0,98,97,100,32,109,111,100,117,108,101,32,115,105,122,101,0,66,97,100,32,100,105,109,101,110,115,105,111,110,58,32,0,114,101,103,105,111,110,32,116,111,111,32,115,109,97,108,108,32,116,111,32,104,111,108,100,32,97,108,105,103,110,109,101,110,116,32,112,97,116,116,101,114,110,0,67,111,117,108,100,32,110,111,116,32,102,105,110,100,32,116,104,114,101,101,32,102,105,110,100,101,114,32,112,97,116,116,101,114,110,115,0,69,108,108,101,103,97,108,32,101,114,114,111,114,32,99,111,114,114,101,99,116,105,111,110,32,108,101,118,101,108,32,98,105,116,115,0,118,101,114,115,105,111,110,78,117,109,98,101,114,32,109,117,115,116,32,98,101,32,98,101,116,119,101,101,110,32,49,32,97,110,100,32,52,48,0,66,105,103,85,110,115,105,103,110,101,100,58,58,115,117,98,116,114,97,99,116,58,32,78,101,103,97,116,105,118,101,32,114,101,115,117,108,116,32,105,110,32,117,110,115,105,103,110,101,100,32,99,97,108,99,117,108,97,116,105,111,110,0,66,105,103,85,110,115,105,103,110,101,100,58,58,100,105,118,105,100,101,87,105,116,104,82,101,109,97,105,110,100,101,114,58,32,67,97,110,110,111,116,32,119,114,105,116,101,32,113,117,111,116,105,101,110,116,32,97,110,100,32,114,101,109,97,105,110,100,101,114,32,105,110,116,111,32,116,104,101,32,115,97,109,101,32,118,97,114,105,97,98,108,101,0,66,105,103,85,110,115,105,103,110,101,100,73,110,65,66,97,115,101,40,66,105,103,85,110,115,105,103,110,101,100,44,32,66,97,115,101,41,58,32,84,104,101,32,98,97,115,101,32,109,117,115,116,32,98,101,32,97,116,32,108,101,97,115,116,32,50,0,66,105,103,85,110,115,105,103,110,101,100,73,110,65,66,97,115,101,32,61,61,62,32,115,116,100,58,58,115,116,114,105,110,103,58,32,84,104,101,32,100,101,102,97,117,108,116,32,115,116,114,105,110,103,32,99,111,110,118,101,114,115,105,111,110,32,114,111,117,116,105,110,101,115,32,117,115,101,32,116,104,101,32,115,121,109,98,111,108,32,115,101,116,32,48,45,57,44,32,65,45,90,32,97,110,100,32,116,104,101,114,101,102,111,114,101,32,115,117,112,112,111,114,116,32,111,110,108,121,32,117,112,32,116,111,32,98,97,115,101,32,51,54,46,32,32,89,111,117,32,116,114,105,101,100,32,97,32,99,111,110,118,101,114,115,105,111,110,32,119,105,116,104,32,97,32,98,97,115,101,32,111,118,101,114,32,51,54,59,32,119,114,105,116,101,32,121,111,117,114,32,111,119,110,32,115,116,114,105,110,103,32,99,111,110,118,101,114,115,105,111,110,32,114,111,117,116,105,110,101,46,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,57,70,105,110,100,101,114,80,97,116,116,101,114,110,70,105,110,100,101,114,69,0,66,105,103,85,110,115,105,103,110,101,100,58,58,116,111,60,80,114,105,109,105,116,105,118,101,62,58,32,86,97,108,117,101,32,105,115,32,116,111,111,32,98,105,103,32,116,111,32,102,105,116,32,105,110,32,116,104,101,32,114,101,113,117,101,115,116,101,100,32,116,121,112,101,0,66,105,103,85,110,115,105,103,110,101,100,32,99,111,110,115,116,114,117,99,116,111,114,58,32,67,97,110,110,111,116,32,99,111,110,115,116,114,117,99,116,32,97,32,66,105,103,85,110,115,105,103,110,101,100,32,102,114,111,109,32,97,32,110,101,103,97,116,105,118,101,32,110,117,109,98,101,114,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,55,70,111,114,109,97,116,73,110,102,111,114,109,97,116,105,111,110,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,55,70,105,110,100,101,114,80,97,116,116,101,114,110,73,110,102,111,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,51,70,105,110,100,101,114,80,97,116,116,101,114,110,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,54,65,108,105,103,110,109,101,110,116,80,97,116,116,101,114,110,69,0,78,53,122,120,105,110,103,53,65,114,114,97,121,73,78,83,95,56,65,114,114,97,121,82,101,102,73,99,69,69,69,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,49,68,97,116,97,77,97,115,107,49,49,49,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,49,68,97,116,97,77,97,115,107,49,49,48,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,49,68,97,116,97,77,97,115,107,49,48,49,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,49,68,97,116,97,77,97,115,107,49,48,48,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,49,68,97,116,97,77,97,115,107,48,49,49,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,49,68,97,116,97,77,97,115,107,48,49,48,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,49,68,97,116,97,77,97,115,107,48,48,49,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,49,68,97,116,97,77,97,115,107,48,48,48,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,57,68,97,116,97,66,108,111,99,107,69,0,78,53,122,120,105,110,103,54,113,114,99,111,100,101,49,53,66,105,116,77,97,116,114,105,120,80,97,114,115,101,114,69,0,80,78,53,122,120,105,110,103,50,52,73,108,108,101,103,97,108,65,114,103,117,109,101,110,116,69,120,99,101,112,116,105,111,110,69,0,78,53,122,120,105,110,103,54,112,100,102,52,49,55,55,100,101,99,111,100,101,114,50,101,99,49,53,69,114,114,111,114,67,111,114,114,101,99,116,105,111,110,69,0,78,53,122,120,105,110,103,56,65,114,114,97,121,82,101,102,73,49,48,66,105,103,73,110,116,101,103,101,114,69,69,0,78,53,122,120,105,110,103,53,65,114,114,97,121,73,49,48,66,105,103,73,110,116,101,103,101,114,69,69,0,78,53,122,120,105,110,103,54,112,100,102,52,49,55,55,100,101,99,111,100,101,114,49,53,66,105,116,77,97,116,114,105,120,80,97,114,115,101,114,69,0,78,53,122,120,105,110,103,52,111,110,101,100,49,53,79,110,101,68,82,101,115,117,108,116,80,111,105,110,116,69,0,78,53,122,120,105,110,103,49,48,100,97,116,97,109,97,116,114,105,120,50,54,82,101,115,117,108,116,80,111,105,110,116,115,65,110,100,84,114,97,110,115,105,116,105,111,110,115,69,0,78,53,122,120,105,110,103,57,66,105,116,83,111,117,114,99,101,69,0,78,53,122,120,105,110,103,49,48,100,97,116,97,109,97,116,114,105,120,57,68,97,116,97,66,108,111,99,107,69,0,78,53,122,120,105,110,103,49,48,100,97,116,97,109,97,116,114,105,120,49,53,66,105,116,77,97,116,114,105,120,80,97,114,115,101,114,69,0,78,53,122,120,105,110,103,54,83,116,114,105,110,103,69,0,78,53,122,120,105,110,103,50,49,73,108,108,101,103,97,108,83,116,97,116,101,69,120,99,101,112,116,105,111,110,69,0,78,53,122,120,105,110,103,49,51,71,101,110,101,114,105,99,71,70,80,111,108,121,69,0,78,53,122,120,105,110,103,57,71,101,110,101,114,105,99,71,70,69,0,78,53,122,120,105,110,103,50,48,80,101,114,115,112,101,99,116,105,118,101,84,114,97,110,115,102,111,114,109,69,0,78,53,122,120,105,110,103,49,52,68,101,116,101,99,116,111,114,82,101,115,117,108,116,69,0,78,53,122,120,105,110,103,56,65,114,114,97,121,82,101,102,73,78,83,48,95,73,99,69,69,69,69,0,78,53,122,120,105,110,103,49,51,68,101,99,111,100,101,114,82,101,115,117,108,116,69,0,78,53,122,120,105,110,103,54,99,111,109,109,111,110,49,53,67,104,97,114,97,99,116,101,114,83,101,116,69,67,73,69,0,69,85,67,95,75,82,0,69,85,67,45,75,82,0,71,66,49,56,48,51,48,0,71,66,50,51,49,50,0,69,85,67,95,67,78,0,71,66,75,0,66,105,103,53,0,65,83,67,73,73,0,85,83,45,65,83,67,73,73,0,85,84,70,56,0,85,84,70,45,56,0,85,110,105,99,111,100,101,66,105,103,85,110,109,97,114,107,101,100,0,85,84,70,45,49,54,66,69,0,85,110,105,99,111,100,101,66,105,103,0,67,112,49,50,53,54,0,119,105,110,100,111,119,115,45,49,50,53,54,0,67,112,49,50,53,50,0,119,105,110,100,111,119,115,45,49,50,53,50,0,67,112,49,50,53,49,0,119,105,110,100,111,119,115,45,49,50,53,49,0,67,112,49,50,53,48,0,119,105,110,100,111,119,115,45,49,50,53,48,0,83,74,73,83,0,83,104,105,102,116,95,74,73,83,0,73,83,79,56,56,53,57,95,49,54,0,73,83,79,45,56,56,53,57,45,49,54,0,73,83,79,56,56,53,57,95,49,53,0,73,83,79,45,56,56,53,57,45,49,53,0,73,83,79,56,56,53,57,95,49,52,0,73,83,79,45,56,56,53,57,45,49,52,0,73,83,79,56,56,53,57,95,49,51,0,73,83,79,45,56,56,53,57,45,49,51,0,73,83,79,56,56,53,57,95,49,49,0,73,83,79,45,56,56,53,57,45,49,49,0,73,83,79,56,56,53,57,95,49,48,0,73,83,79,45,56,56,53,57,45,49,48,0,73,83,79,56,56,53,57,95,57,0,73,83,79,45,56,56,53,57,45,57,0,73,83,79,56,56,53,57,95,56,0,73,83,79,45,56,56,53,57,45,56,0,73,83,79,56,56,53,57,95,55,0,73,83,79,45,56,56,53,57,45,55,0,73,83,79,56,56,53,57,95,54,0,73,83,79,45,56,56,53,57,45,54,0,73,83,79,56,56,53,57,95,53,0,73,83,79,45,56,56,53,57,45,53,0,73,83,79,56,56,53,57,95,52,0,73,83,79,45,56,56,53,57,45,52,0,73,83,79,56,56,53,57,95,51,0,73,83,79,45,56,56,53,57,45,51,0,73,83,79,56,56,53,57,95,50,0,73,83,79,45,56,56,53,57,45,50,0,73,83,79,56,56,53,57,95,49,0,73,83,79,45,56,56,53,57,45,49,0,67,112,52,51,55,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,105,110,103,98,117,102,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,78,83,116,51,95,95,49,49,57,98,97,115,105,99,95,111,115,116,114,105,110,103,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,66,111,116,104,32,100,105,109,101,110,115,105,111,110,115,32,109,117,115,116,32,98,101,32,103,114,101,97,116,101,114,32,116,104,97,110,32,48,0,78,53,122,120,105,110,103,56,65,114,114,97,121,82,101,102,73,105,69,69,0,78,53,122,120,105,110,103,53,65,114,114,97,121,73,105,69,69,0,78,53,122,120,105,110,103,53,65,114,114,97,121,73,78,83,95,51,82,101,102,73,78,83,95,49,49,82,101,115,117,108,116,80,111,105,110,116,69,69,69,69,69,0,78,53,122,120,105,110,103,53,97,122,116,101,99,53,80,111,105,110,116,69,0,78,53,122,120,105,110,103,49,55,78,111,116,70,111,117,110,100,69,120,99,101,112,116,105,111,110,69,0,78,53,122,120,105,110,103,50,50,87,104,105,116,101,82,101,99,116,97,110,103,108,101,68,101,116,101,99,116,111,114,69,0,67,84,82,76,95,80,83,0,32,0,48,0,49,0,50,0,51,0,52,0,53,0,54,0,55,0,56,0,57,0,44,0,67,84,82,76,95,85,76,0,67,84,82,76,95,85,83,0,13,0,13,10,0,46,32,0,44,32,0,33,0,34,0,35,0,36,0,37,0,38,0,39,0,40,0,41,0,42,0,43,0,45,0,47,0,58,0,59,0,60,0,61,0,62,0,63,0,91,0,93,0,123,0,125,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,11,0,12,0,27,0,28,0,29,0,30,0,31,0,64,0,92,0,94,0,95,0,96,0,124,0,126,0,127,0,67,84,82,76,95,76,76,0,67,84,82,76,95,80,76,0,67,84,82,76,95,66,83,0,97,0,98,0,99,0,100,0,101,0,102,0,103,0,104,0,105,0,106,0,107,0,109,0,110,0,111,0,112,0,113,0,114,0,115,0,116,0,117,0,118,0,119,0,120,0,121,0,122,0,67,84,82,76,95,77,76,0,67,84,82,76,95,68,76,0,65,0,66,0,68,0,69,0,70,0,71,0,73,0,74,0,75,0,78,0,79,0,80,0,82,0,83,0,84,0,85,0,86,0,87,0,88,0,89,0,90,0,78,53,122,120,105,110,103,53,97,122,116,101,99,55,68,101,99,111,100,101,114,69,0,78,53,122,120,105,110,103,53,97,122,116,101,99,56,68,101,116,101,99,116,111,114,69,0,78,53,122,120,105,110,103,53,97,122,116,101,99,49,57,65,122,116,101,99,68,101,116,101,99,116,111,114,82,101,115,117,108,116,69,0,77,0,81,0,72,0,84,69,82,77,73,78,65,84,79,82,0,78,85,77,69,82,73,67,0,65,76,80,72,65,78,85,77,69,82,73,67,0,83,84,82,85,67,84,85,82,69,68,95,65,80,80,69,78,68,0,66,89,84,69,0,69,67,73,0,75,65,78,74,73,0,70,78,67,49,95,70,73,82,83,84,95,80,79,83,73,84,73,79,78,0,70,78,67,49,95,83,69,67,79,78,68,95,80,79,83,73,84,73,79,78,0,72,65,78,90,73,0,118,111,105,100,0,98,111,111,108,0,99,104,97,114,0,115,105,103,110,101,100,32,99,104,97,114,0,117,110,115,105,103,110,101,100,32,99,104,97,114,0,115,104,111,114,116,0,117,110,115,105,103,110,101,100,32,115,104,111,114,116,0,105,110,116,0,117,110,115,105,103,110,101,100,32,105,110,116,0,108,111,110,103,0,117,110,115,105,103,110,101,100,32,108,111,110,103,0,102,108,111,97,116,0,100,111,117,98,108,101,0,115,116,100,58,58,115,116,114,105,110,103,0,115,116,100,58,58,98,97,115,105,99,95,115,116,114,105,110,103,60,117,110,115,105,103,110,101,100,32,99,104,97,114,62,0,115,116,100,58,58,119,115,116,114,105,110,103,0,101,109,115,99,114,105,112,116,101,110,58,58,118,97,108,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,99,104,97,114,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,115,105,103,110,101,100,32,99,104,97,114,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,110,115,105,103,110,101,100,32,99,104,97,114,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,115,104,111,114,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,110,115,105,103,110,101,100,32,115,104,111,114,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,105,110,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,110,115,105,103,110,101,100,32,105,110,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,108,111,110,103,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,110,115,105,103,110,101,100,32,108,111,110,103,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,105,110,116,56,95,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,105,110,116,56,95,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,105,110,116,49,54,95,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,105,110,116,49,54,95,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,105,110,116,51,50,95,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,105,110,116,51,50,95,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,102,108,111,97,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,100,111,117,98,108,101,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,108,111,110,103,32,100,111,117,98,108,101,62,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,101,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,100,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,102,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,109,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,108,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,106,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,105,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,116,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,115,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,104,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,97,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,99,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,51,118,97,108,69,0,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,119,69,69,69,69,0,78,83,116,51,95,95,49,50,49,95,95,98,97,115,105,99,95,115,116,114,105,110,103,95,99,111,109,109,111,110,73,76,98,49,69,69,69,0,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,104,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,104,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,104,69,69,69,69,0,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,83,116,57,98,97,100,95,97,108,108,111,99,0,83,116,57,101,120,99,101,112,116,105,111,110,0,83,116,49,51,114,117,110,116,105,109,101,95,101,114,114,111,114,0,83,116,57,116,121,112,101,95,105,110,102,111,0,83,116,56,98,97,100,95,99,97,115,116,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,51,95,95,102,117,110,100,97,109,101,110,116,97,108,95,116,121,112,101,95,105,110,102,111,69,0,68,110,0,80,75,99,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,33,34,98,97,115,105,99,95,115,116,114,105,110,103,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,47,85,115,101,114,115,47,105,108,109,97,114,105,47,68,111,119,110,108,111,97,100,115,47,101,109,115,100,107,95,112,111,114,116,97,98,108,101,47,101,109,115,99,114,105,112,116,101,110,47,49,46,51,53,46,48,47,115,121,115,116,101,109,47,105,110,99,108,117,100,101,47,108,105,98,99,120,120,47,115,116,114,105,110,103,0,95,95,116,104,114,111,119,95,108,101,110,103,116,104,95,101,114,114,111,114,0,33,34,118,101,99,116,111,114,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,47,85,115,101,114,115,47,105,108,109,97,114,105,47,68,111,119,110,108,111,97,100,115,47,101,109,115,100,107,95,112,111,114,116,97,98,108,101,47,101,109,115,99,114,105,112,116,101,110,47,49,46,51,53,46,48,47,115,121,115,116,101,109,47,105,110,99,108,117,100,101,47,108,105,98,99,120,120,47,118,101,99,116,111,114,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,116,104,114,101,119,32,97,110,32,101,120,99,101,112,116,105,111,110,0,115,116,100,58,58,98,97,100,95,99,97,115,116,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,33,34,98,97,115,105,99,95,115,116,114,105,110,103,32,111,117,116,95,111,102,95,114,97,110,103,101,34,0,95,95,116,104,114,111,119,95,111,117,116,95,111,102,95,114,97,110,103,101,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,116,101,114,109,105,110,97,116,105,110,103,0,117,110,99,97,117,103,104,116,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,105,110,102,105,110,105,116,121,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,4,7,3,6,5,0,80,79,83,73,88],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+48376);allocate([17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,55,102,97,105,108,117,114,101,69,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,69,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,78,83,116,51,95,95,49,49,57,95,95,105,111,115,116,114,101,97,109,95,99,97,116,101,103,111,114,121,69,0,105,111,115,95,98,97,115,101,58,58,99,108,101,97,114,0,105,111,115,116,114,101,97,109,0,117,110,115,112,101,99,105,102,105,101,100,32,105,111,115,116,114,101,97,109,95,99,97,116,101,103,111,114,121,32,101,114,114,111,114,0,48,49,50,51,52,53,54,55,56,57,97,98,99,100,101,102,65,66,67,68,69,70,120,88,43,45,112,80,105,73,110,78,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,102,97,99,101,116,69,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,119,69,69,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,99,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,115,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,105,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,78,83,116,51,95,95,49,49,54,95,95,110,97,114,114,111,119,95,116,111,95,117,116,102,56,73,76,106,51,50,69,69,69,0,78,83,116,51,95,95,49,49,55,95,95,119,105,100,101,110,95,102,114,111,109,95,117,116,102,56,73,76,106,51,50,69,69,69,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,119,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,95,95,105,109,112,69,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,99,69,69,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,119,69,69,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,99,69,69,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,99,69,69,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,119,69,69,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,48,69,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,49,69,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,48,69,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,49,69,69,69,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,99,69,69,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,119,69,69,0,37,112,0,67,0,37,0,0,0,0,0,108,0,108,108,0,0,76,0,37,112,0,0,0,0,37,72,58,37,77,58,37,83,37,109,47,37,100,47,37,121,37,89,45,37,109,45,37,100,37,73,58,37,77,58,37,83,32,37,112,37,72,58,37,77,37,72,58,37,77,58,37,83,108,111,99,97,108,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,48,49,50,51,52,53,54,55,56,57,0,37,76,102,0,109,111,110,101,121,95,103,101,116,32,101,114,114,111,114,0,48,49,50,51,52,53,54,55,56,57,0,37,46,48,76,102,0,116,114,117,101,0,102,97,108,115,101,0,83,117,110,100,97,121,0,77,111,110,100,97,121,0,84,117,101,115,100,97,121,0,87,101,100,110,101,115,100,97,121,0,84,104,117,114,115,100,97,121,0,70,114,105,100,97,121,0,83,97,116,117,114,100,97,121,0,83,117,110,0,77,111,110,0,84,117,101,0,87,101,100,0,84,104,117,0,70,114,105,0,83,97,116,0,74,97,110,117,97,114,121,0,70,101,98,114,117,97,114,121,0,77,97,114,99,104,0,65,112,114,105,108,0,77,97,121,0,74,117,110,101,0,74,117,108,121,0,65,117,103,117,115,116,0,83,101,112,116,101,109,98,101,114,0,79,99,116,111,98,101,114,0,78,111,118,101,109,98,101,114,0,68,101,99,101,109,98,101,114,0,74,97,110,0,70,101,98,0,77,97,114,0,65,112,114,0,74,117,110,0,74,117,108,0,65,117,103,0,83,101,112,0,79,99,116,0,78,111,118,0,68,101,99,0,65,77,0,80,77,0,37,109,47,37,100,47,37,121,0,37,72,58,37,77,58,37,83,0,37,97,32,37,98,32,37,100,32,37,72,58,37,77,58,37,83,32,37,89,0,37,73,58,37,77,58,37,83,32,37,112,0,78,83,116,51,95,95,49,49,51,109,101,115,115,97,103,101,115,95,98,97,115,101,69,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,119,69,69,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,99,69,69,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,119,69,69,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,99,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,95,98,97,115,101,69,0,78,83,116,51,95,95,49,49,48,95,95,116,105,109,101,95,112,117,116,69,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,119,69,69,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,99,69,69,0,78,83,116,51,95,95,49,57,116,105,109,101,95,98,97,115,101,69,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,119,69,69,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,112,117,116,95,98,97,115,101,69,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,99,69,69,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,119,69,69,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,103,101,116,95,98,97,115,101,69,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,99,69,69,0,78,83,116,51,95,95,49,49,50,99,111,100,101,99,118,116,95,98,97,115,101,69,0,78,83,116,51,95,95,49,49,48,99,116,121,112,101,95,98,97,115,101,69,0,78,83,116,51,95,95,49,49,52,95,95,115,104,97,114,101,100,95,99,111,117,110,116,69,0,78,83,116,51,95,95,49,49,50,115,121,115,116,101,109,95,101,114,114,111,114,69,0,78,83,116,51,95,95,49,49,52,101,114,114,111,114,95,99,97,116,101,103,111,114,121,69,0,78,83,116,51,95,95,49,49,50,95,95,100,111,95,109,101,115,115,97,103,101,69,0,58,32,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+59042);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}function _atexit(func,arg){__ATEXIT__.unshift({func:func,arg:arg})}function ___cxa_atexit(){return _atexit.apply(null,arguments)}Module["_i64Add"]=_i64Add;Module["_i64Subtract"]=_i64Subtract;var _fabsf=Math_abs;var _floorf=Math_floor;function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr}function getShiftFromSize(size){switch(size){case 1:return 0;case 2:return 1;case 4:return 2;case 8:return 3;default:throw new TypeError("Unknown type size: "+size)}}function embind_init_charCodes(){var codes=new Array(256);for(var i=0;i<256;++i){codes[i]=String.fromCharCode(i)}embind_charCodes=codes}var embind_charCodes=undefined;function readLatin1String(ptr){var ret="";var c=ptr;while(HEAPU8[c]){ret+=embind_charCodes[HEAPU8[c++]]}return ret}var awaitingDependencies={};var registeredTypes={};var typeDependencies={};var char_0=48;var char_9=57;function makeLegalFunctionName(name){if(undefined===name){return"_unknown"}name=name.replace(/[^a-zA-Z0-9_]/g,"$");var f=name.charCodeAt(0);if(f>=char_0&&f<=char_9){return"_"+name}else{return name}}function createNamedFunction(name,body){name=makeLegalFunctionName(name);return(new Function("body","return function "+name+"() {\n"+'    "use strict";'+"    return body.apply(this, arguments);\n"+"};\n"))(body)}function extendError(baseErrorType,errorName){var errorClass=createNamedFunction(errorName,(function(message){this.name=errorName;this.message=message;var stack=(new Error(message)).stack;if(stack!==undefined){this.stack=this.toString()+"\n"+stack.replace(/^Error(:[^\n]*)?\n/,"")}}));errorClass.prototype=Object.create(baseErrorType.prototype);errorClass.prototype.constructor=errorClass;errorClass.prototype.toString=(function(){if(this.message===undefined){return this.name}else{return this.name+": "+this.message}});return errorClass}var BindingError=undefined;function throwBindingError(message){throw new BindingError(message)}var InternalError=undefined;function throwInternalError(message){throw new InternalError(message)}function whenDependentTypesAreResolved(myTypes,dependentTypes,getTypeConverters){myTypes.forEach((function(type){typeDependencies[type]=dependentTypes}));function onComplete(typeConverters){var myTypeConverters=getTypeConverters(typeConverters);if(myTypeConverters.length!==myTypes.length){throwInternalError("Mismatched type converter count")}for(var i=0;i<myTypes.length;++i){registerType(myTypes[i],myTypeConverters[i])}}var typeConverters=new Array(dependentTypes.length);var unregisteredTypes=[];var registered=0;dependentTypes.forEach((function(dt,i){if(registeredTypes.hasOwnProperty(dt)){typeConverters[i]=registeredTypes[dt]}else{unregisteredTypes.push(dt);if(!awaitingDependencies.hasOwnProperty(dt)){awaitingDependencies[dt]=[]}awaitingDependencies[dt].push((function(){typeConverters[i]=registeredTypes[dt];++registered;if(registered===unregisteredTypes.length){onComplete(typeConverters)}}))}}));if(0===unregisteredTypes.length){onComplete(typeConverters)}}function registerType(rawType,registeredInstance,options){options=options||{};if(!("argPackAdvance"in registeredInstance)){throw new TypeError("registerType registeredInstance requires argPackAdvance")}var name=registeredInstance.name;if(!rawType){throwBindingError('type "'+name+'" must have a positive integer typeid pointer')}if(registeredTypes.hasOwnProperty(rawType)){if(options.ignoreDuplicateRegistrations){return}else{throwBindingError("Cannot register type '"+name+"' twice")}}registeredTypes[rawType]=registeredInstance;delete typeDependencies[rawType];if(awaitingDependencies.hasOwnProperty(rawType)){var callbacks=awaitingDependencies[rawType];delete awaitingDependencies[rawType];callbacks.forEach((function(cb){cb()}))}}function __embind_register_bool(rawType,name,size,trueValue,falseValue){var shift=getShiftFromSize(size);name=readLatin1String(name);registerType(rawType,{name:name,"fromWireType":(function(wt){return!!wt}),"toWireType":(function(destructors,o){return o?trueValue:falseValue}),"argPackAdvance":8,"readValueFromPointer":(function(pointer){var heap;if(size===1){heap=HEAP8}else if(size===2){heap=HEAP16}else if(size===4){heap=HEAP32}else{throw new TypeError("Unknown boolean type size: "+name)}return this["fromWireType"](heap[pointer>>shift])}),destructorFunction:null})}var _emscripten_landingpad=true;function _free(){}Module["_free"]=_free;function ___cxa_free_exception(ptr){try{return _free(ptr)}catch(e){}}function ___cxa_end_catch(){if(___cxa_end_catch.rethrown){___cxa_end_catch.rethrown=false;return}asm["setThrew"](0);var ptr=EXCEPTIONS.caught.pop();if(ptr){EXCEPTIONS.decRef(EXCEPTIONS.deAdjust(ptr));EXCEPTIONS.last=0}}function _embind_repr(v){if(v===null){return"null"}var t=typeof v;if(t==="object"||t==="array"||t==="function"){return v.toString()}else{return""+v}}function integerReadValueFromPointer(name,shift,signed){switch(shift){case 0:return signed?function readS8FromPointer(pointer){return HEAP8[pointer]}:function readU8FromPointer(pointer){return HEAPU8[pointer]};case 1:return signed?function readS16FromPointer(pointer){return HEAP16[pointer>>1]}:function readU16FromPointer(pointer){return HEAPU16[pointer>>1]};case 2:return signed?function readS32FromPointer(pointer){return HEAP32[pointer>>2]}:function readU32FromPointer(pointer){return HEAPU32[pointer>>2]};default:throw new TypeError("Unknown integer type: "+name)}}function __embind_register_integer(primitiveType,name,size,minRange,maxRange){name=readLatin1String(name);if(maxRange===-1){maxRange=4294967295}var shift=getShiftFromSize(size);var fromWireType=(function(value){return value});if(minRange===0){var bitshift=32-8*size;fromWireType=(function(value){return value<<bitshift>>>bitshift})}registerType(primitiveType,{name:name,"fromWireType":fromWireType,"toWireType":(function(destructors,value){if(typeof value!=="number"&&typeof value!=="boolean"){throw new TypeError('Cannot convert "'+_embind_repr(value)+'" to '+this.name)}if(value<minRange||value>maxRange){throw new TypeError('Passing a number "'+_embind_repr(value)+'" from JS side to C/C++ side to an argument of type "'+name+'", which is outside the valid range ['+minRange+", "+maxRange+"]!")}return value|0}),"argPackAdvance":8,"readValueFromPointer":integerReadValueFromPointer(name,shift,minRange!==0),destructorFunction:null})}var _sqrtf=Math_sqrt;function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 85:return totalMemory/PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}var _emscripten_postinvoke=true;var PTHREAD_SPECIFIC={};var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}var emval_free_list=[];var emval_handle_array=[{},{value:undefined},{value:null},{value:true},{value:false}];function __emval_decref(handle){if(handle>4&&0===--emval_handle_array[handle].refcount){emval_handle_array[handle]=undefined;emval_free_list.push(handle)}}function count_emval_handles(){var count=0;for(var i=5;i<emval_handle_array.length;++i){if(emval_handle_array[i]!==undefined){++count}}return count}function get_first_emval(){for(var i=5;i<emval_handle_array.length;++i){if(emval_handle_array[i]!==undefined){return emval_handle_array[i]}}return null}function init_emval(){Module["count_emval_handles"]=count_emval_handles;Module["get_first_emval"]=get_first_emval}function __emval_register(value){switch(value){case undefined:{return 1};case null:{return 2};case true:{return 3};case false:{return 4};default:{var handle=emval_free_list.length?emval_free_list.pop():emval_handle_array.length;emval_handle_array[handle]={refcount:1,value:value};return handle}}}function simpleReadValueFromPointer(pointer){return this["fromWireType"](HEAPU32[pointer>>2])}function __embind_register_emval(rawType,name){name=readLatin1String(name);registerType(rawType,{name:name,"fromWireType":(function(handle){var rv=emval_handle_array[handle].value;__emval_decref(handle);return rv}),"toWireType":(function(destructors,value){return __emval_register(value)}),"argPackAdvance":8,"readValueFromPointer":simpleReadValueFromPointer,destructorFunction:null})}var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};var PATH={splitPath:(function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)}),normalizeArray:(function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up--;up){parts.unshift("..")}}return parts}),normalize:(function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path}),dirname:(function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir}),basename:(function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)}),extname:(function(path){return PATH.splitPath(path)[3]}),join:(function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))}),join2:(function(l,r){return PATH.normalize(l+"/"+r)}),resolve:(function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:FS.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){return""}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter((function(p){return!!p})),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."}),relative:(function(from,to){from=PATH.resolve(from).substr(1);to=PATH.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")})};var TTY={ttys:[],init:(function(){}),shutdown:(function(){}),register:(function(dev,ops){TTY.ttys[dev]={input:[],output:[],ops:ops};FS.registerDevice(dev,TTY.stream_ops)}),stream_ops:{open:(function(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}stream.tty=tty;stream.seekable=false}),close:(function(stream){stream.tty.ops.flush(stream.tty)}),flush:(function(stream){stream.tty.ops.flush(stream.tty)}),read:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}for(var i=0;i<length;i++){try{stream.tty.ops.put_char(stream.tty,buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})},default_tty_ops:{get_char:(function(tty){if(!tty.input.length){var result=null;if(ENVIRONMENT_IS_NODE){var BUFSIZE=256;var buf=new Buffer(BUFSIZE);var bytesRead=0;var fd=process.stdin.fd;var usingDevice=false;try{fd=fs.openSync("/dev/stdin","r");usingDevice=true}catch(e){}bytesRead=fs.readSync(fd,buf,0,BUFSIZE,null);if(usingDevice){fs.closeSync(fd)}if(bytesRead>0){result=buf.slice(0,bytesRead).toString("utf-8")}else{result=null}}else if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else if(typeof readline=="function"){result=readline();if(result!==null){result+="\n"}}if(!result){return null}tty.input=intArrayFromString(result,true)}return tty.input.shift()}),put_char:(function(tty,val){if(val===null||val===10){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}})},default_tty1_ops:{put_char:(function(tty,val){if(val===null||val===10){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}})}};var MEMFS={ops_table:null,mount:(function(mount){return MEMFS.createNode(null,"/",16384|511,0)}),createNode:(function(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(!MEMFS.ops_table){MEMFS.ops_table={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap,msync:MEMFS.stream_ops.msync}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}}}var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.timestamp=Date.now();if(parent){parent.contents[name]=node}return node}),getFileDataAsRegularArray:(function(node){if(node.contents&&node.contents.subarray){var arr=[];for(var i=0;i<node.usedBytes;++i)arr.push(node.contents[i]);return arr}return node.contents}),getFileDataAsTypedArray:(function(node){if(!node.contents)return new Uint8Array;if(node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)}),expandFileStorage:(function(node,newCapacity){if(node.contents&&node.contents.subarray&&newCapacity>node.contents.length){node.contents=MEMFS.getFileDataAsRegularArray(node);node.usedBytes=node.contents.length}if(!node.contents||node.contents.subarray){var prevCapacity=node.contents?node.contents.buffer.byteLength:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)|0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0);return}if(!node.contents&&newCapacity>0)node.contents=[];while(node.contents.length<newCapacity)node.contents.push(0)}),resizeFileStorage:(function(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0;return}if(!node.contents||node.contents.subarray){var oldContents=node.contents;node.contents=new Uint8Array(new ArrayBuffer(newSize));if(oldContents){node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)))}node.usedBytes=newSize;return}if(!node.contents)node.contents=[];if(node.contents.length>newSize)node.contents.length=newSize;else while(node.contents.length<newSize)node.contents.push(0);node.usedBytes=newSize}),node_ops:{getattr:(function(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.timestamp);attr.mtime=new Date(node.timestamp);attr.ctime=new Date(node.timestamp);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}}),lookup:(function(parent,name){throw FS.genericErrors[ERRNO_CODES.ENOENT]}),mknod:(function(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)}),rename:(function(old_node,new_dir,new_name){if(FS.isDir(old_node.mode)){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){for(var i in new_node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}}}delete old_node.parent.contents[old_node.name];old_node.name=new_name;new_dir.contents[new_name]=old_node;old_node.parent=new_dir}),unlink:(function(parent,name){delete parent.contents[name]}),rmdir:(function(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}delete parent.contents[name]}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node}),readlink:(function(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return node.link})},stream_ops:{read:(function(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);assert(size>=0);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size}),write:(function(stream,buffer,offset,length,position,canOwn){if(!length)return 0;var node=stream.node;node.timestamp=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=new Uint8Array(buffer.subarray(offset,offset+length));node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray)node.contents.set(buffer.subarray(offset,offset+length),position);else{for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}}node.usedBytes=Math.max(node.usedBytes,position+length);return length}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position}),allocate:(function(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&(contents.buffer===buffer||contents.buffer===buffer.buffer)){allocated=false;ptr=contents.byteOffset}else{if(position>0||position+length<stream.node.usedBytes){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}allocated=true;ptr=_malloc(length);if(!ptr){throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)}buffer.set(contents,ptr)}return{ptr:ptr,allocated:allocated}}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(mmapFlags&2){return 0}var bytesWritten=MEMFS.stream_ops.write(stream,buffer,0,length,offset,false);return 0})}};var IDBFS={dbs:{},indexedDB:(function(){if(typeof indexedDB!=="undefined")return indexedDB;var ret=null;if(typeof window==="object")ret=window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB;assert(ret,"IDBFS used, but indexedDB not supported");return ret}),DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:(function(mount){return MEMFS.mount.apply(null,arguments)}),syncfs:(function(mount,populate,callback){IDBFS.getLocalSet(mount,(function(err,local){if(err)return callback(err);IDBFS.getRemoteSet(mount,(function(err,remote){if(err)return callback(err);var src=populate?remote:local;var dst=populate?local:remote;IDBFS.reconcile(src,dst,callback)}))}))}),getDB:(function(name,callback){var db=IDBFS.dbs[name];if(db){return callback(null,db)}var req;try{req=IDBFS.indexedDB().open(name,IDBFS.DB_VERSION)}catch(e){return callback(e)}req.onupgradeneeded=(function(e){var db=e.target.result;var transaction=e.target.transaction;var fileStore;if(db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)){fileStore=transaction.objectStore(IDBFS.DB_STORE_NAME)}else{fileStore=db.createObjectStore(IDBFS.DB_STORE_NAME)}if(!fileStore.indexNames.contains("timestamp")){fileStore.createIndex("timestamp","timestamp",{unique:false})}});req.onsuccess=(function(){db=req.result;IDBFS.dbs[name]=db;callback(null,db)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),getLocalSet:(function(mount,callback){var entries={};function isRealDir(p){return p!=="."&&p!==".."}function toAbsolute(root){return(function(p){return PATH.join2(root,p)})}var check=FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));while(check.length){var path=check.pop();var stat;try{stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){check.push.apply(check,FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))}entries[path]={timestamp:stat.mtime}}return callback(null,{type:"local",entries:entries})}),getRemoteSet:(function(mount,callback){var entries={};IDBFS.getDB(mount.mountpoint,(function(err,db){if(err)return callback(err);var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readonly");transaction.onerror=(function(e){callback(this.error);e.preventDefault()});var store=transaction.objectStore(IDBFS.DB_STORE_NAME);var index=store.index("timestamp");index.openKeyCursor().onsuccess=(function(event){var cursor=event.target.result;if(!cursor){return callback(null,{type:"remote",db:db,entries:entries})}entries[cursor.primaryKey]={timestamp:cursor.key};cursor.continue()})}))}),loadLocalEntry:(function(path,callback){var stat,node;try{var lookup=FS.lookupPath(path);node=lookup.node;stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){return callback(null,{timestamp:stat.mtime,mode:stat.mode})}else if(FS.isFile(stat.mode)){node.contents=MEMFS.getFileDataAsTypedArray(node);return callback(null,{timestamp:stat.mtime,mode:stat.mode,contents:node.contents})}else{return callback(new Error("node type not supported"))}}),storeLocalEntry:(function(path,entry,callback){try{if(FS.isDir(entry.mode)){FS.mkdir(path,entry.mode)}else if(FS.isFile(entry.mode)){FS.writeFile(path,entry.contents,{encoding:"binary",canOwn:true})}else{return callback(new Error("node type not supported"))}FS.chmod(path,entry.mode);FS.utime(path,entry.timestamp,entry.timestamp)}catch(e){return callback(e)}callback(null)}),removeLocalEntry:(function(path,callback){try{var lookup=FS.lookupPath(path);var stat=FS.stat(path);if(FS.isDir(stat.mode)){FS.rmdir(path)}else if(FS.isFile(stat.mode)){FS.unlink(path)}}catch(e){return callback(e)}callback(null)}),loadRemoteEntry:(function(store,path,callback){var req=store.get(path);req.onsuccess=(function(event){callback(null,event.target.result)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),storeRemoteEntry:(function(store,path,entry,callback){var req=store.put(entry,path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),removeRemoteEntry:(function(store,path,callback){var req=store.delete(path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),reconcile:(function(src,dst,callback){var total=0;var create=[];Object.keys(src.entries).forEach((function(key){var e=src.entries[key];var e2=dst.entries[key];if(!e2||e.timestamp>e2.timestamp){create.push(key);total++}}));var remove=[];Object.keys(dst.entries).forEach((function(key){var e=dst.entries[key];var e2=src.entries[key];if(!e2){remove.push(key);total++}}));if(!total){return callback(null)}var errored=false;var completed=0;var db=src.type==="remote"?src.db:dst.db;var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readwrite");var store=transaction.objectStore(IDBFS.DB_STORE_NAME);function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=total){return callback(null)}}transaction.onerror=(function(e){done(this.error);e.preventDefault()});create.sort().forEach((function(path){if(dst.type==="local"){IDBFS.loadRemoteEntry(store,path,(function(err,entry){if(err)return done(err);IDBFS.storeLocalEntry(path,entry,done)}))}else{IDBFS.loadLocalEntry(path,(function(err,entry){if(err)return done(err);IDBFS.storeRemoteEntry(store,path,entry,done)}))}}));remove.sort().reverse().forEach((function(path){if(dst.type==="local"){IDBFS.removeLocalEntry(path,done)}else{IDBFS.removeRemoteEntry(store,path,done)}}))})};var NODEFS={isWindows:false,staticInit:(function(){NODEFS.isWindows=!!process.platform.match(/^win/)}),mount:(function(mount){assert(ENVIRONMENT_IS_NODE);return NODEFS.createNode(null,"/",NODEFS.getMode(mount.opts.root),0)}),createNode:(function(parent,name,mode,dev){if(!FS.isDir(mode)&&!FS.isFile(mode)&&!FS.isLink(mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=FS.createNode(parent,name,mode);node.node_ops=NODEFS.node_ops;node.stream_ops=NODEFS.stream_ops;return node}),getMode:(function(path){var stat;try{stat=fs.lstatSync(path);if(NODEFS.isWindows){stat.mode=stat.mode|(stat.mode&146)>>1}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return stat.mode}),realPath:(function(node){var parts=[];while(node.parent!==node){parts.push(node.name);node=node.parent}parts.push(node.mount.opts.root);parts.reverse();return PATH.join.apply(null,parts)}),flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:(function(flags){flags&=~32768;if(flags in NODEFS.flagsToPermissionStringMap){return NODEFS.flagsToPermissionStringMap[flags]}else{throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}}),node_ops:{getattr:(function(node){var path=NODEFS.realPath(node);var stat;try{stat=fs.lstatSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(NODEFS.isWindows&&!stat.blksize){stat.blksize=4096}if(NODEFS.isWindows&&!stat.blocks){stat.blocks=(stat.size+stat.blksize-1)/stat.blksize|0}return{dev:stat.dev,ino:stat.ino,mode:stat.mode,nlink:stat.nlink,uid:stat.uid,gid:stat.gid,rdev:stat.rdev,size:stat.size,atime:stat.atime,mtime:stat.mtime,ctime:stat.ctime,blksize:stat.blksize,blocks:stat.blocks}}),setattr:(function(node,attr){var path=NODEFS.realPath(node);try{if(attr.mode!==undefined){fs.chmodSync(path,attr.mode);node.mode=attr.mode}if(attr.timestamp!==undefined){var date=new Date(attr.timestamp);fs.utimesSync(path,date,date)}if(attr.size!==undefined){fs.truncateSync(path,attr.size)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),lookup:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);var mode=NODEFS.getMode(path);return NODEFS.createNode(parent,name,mode)}),mknod:(function(parent,name,mode,dev){var node=NODEFS.createNode(parent,name,mode,dev);var path=NODEFS.realPath(node);try{if(FS.isDir(node.mode)){fs.mkdirSync(path,node.mode)}else{fs.writeFileSync(path,"",{mode:node.mode})}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return node}),rename:(function(oldNode,newDir,newName){var oldPath=NODEFS.realPath(oldNode);var newPath=PATH.join2(NODEFS.realPath(newDir),newName);try{fs.renameSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),unlink:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.unlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),rmdir:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.rmdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readdir:(function(node){var path=NODEFS.realPath(node);try{return fs.readdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),symlink:(function(parent,newName,oldPath){var newPath=PATH.join2(NODEFS.realPath(parent),newName);try{fs.symlinkSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readlink:(function(node){var path=NODEFS.realPath(node);try{path=fs.readlinkSync(path);path=NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root),path);return path}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}})},stream_ops:{open:(function(stream){var path=NODEFS.realPath(stream.node);try{if(FS.isFile(stream.node.mode)){stream.nfd=fs.openSync(path,NODEFS.flagsToPermissionString(stream.flags))}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),close:(function(stream){try{if(FS.isFile(stream.node.mode)&&stream.nfd){fs.closeSync(stream.nfd)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),read:(function(stream,buffer,offset,length,position){if(length===0)return 0;var nbuffer=new Buffer(length);var res;try{res=fs.readSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(res>0){for(var i=0;i<res;i++){buffer[offset+i]=nbuffer[i]}}return res}),write:(function(stream,buffer,offset,length,position){var nbuffer=new Buffer(buffer.subarray(offset,offset+length));var res;try{res=fs.writeSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}return res}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){try{var stat=fs.fstatSync(stream.nfd);position+=stat.size}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:(function(mount){assert(ENVIRONMENT_IS_WORKER);if(!WORKERFS.reader)WORKERFS.reader=new FileReaderSync;var root=WORKERFS.createNode(null,"/",WORKERFS.DIR_MODE,0);var createdParents={};function ensureParent(path){var parts=path.split("/");var parent=root;for(var i=0;i<parts.length-1;i++){var curr=parts.slice(0,i+1).join("/");if(!createdParents[curr]){createdParents[curr]=WORKERFS.createNode(parent,curr,WORKERFS.DIR_MODE,0)}parent=createdParents[curr]}return parent}function base(path){var parts=path.split("/");return parts[parts.length-1]}Array.prototype.forEach.call(mount.opts["files"]||[],(function(file){WORKERFS.createNode(ensureParent(file.name),base(file.name),WORKERFS.FILE_MODE,0,file,file.lastModifiedDate)}));(mount.opts["blobs"]||[]).forEach((function(obj){WORKERFS.createNode(ensureParent(obj["name"]),base(obj["name"]),WORKERFS.FILE_MODE,0,obj["data"])}));(mount.opts["packages"]||[]).forEach((function(pack){pack["metadata"].files.forEach((function(file){var name=file.filename.substr(1);WORKERFS.createNode(ensureParent(name),base(name),WORKERFS.FILE_MODE,0,pack["blob"].slice(file.start,file.end))}))}));return root}),createNode:(function(parent,name,mode,dev,contents,mtime){var node=FS.createNode(parent,name,mode);node.mode=mode;node.node_ops=WORKERFS.node_ops;node.stream_ops=WORKERFS.stream_ops;node.timestamp=(mtime||new Date).getTime();assert(WORKERFS.FILE_MODE!==WORKERFS.DIR_MODE);if(mode===WORKERFS.FILE_MODE){node.size=contents.size;node.contents=contents}else{node.size=4096;node.contents={}}if(parent){parent.contents[name]=node}return node}),node_ops:{getattr:(function(node){return{dev:1,ino:undefined,mode:node.mode,nlink:1,uid:0,gid:0,rdev:undefined,size:node.size,atime:new Date(node.timestamp),mtime:new Date(node.timestamp),ctime:new Date(node.timestamp),blksize:4096,blocks:Math.ceil(node.size/4096)}}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}}),lookup:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}),mknod:(function(parent,name,mode,dev){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rename:(function(oldNode,newDir,newName){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),unlink:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rmdir:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readdir:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),symlink:(function(parent,newName,oldPath){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readlink:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)})},stream_ops:{read:(function(stream,buffer,offset,length,position){if(position>=stream.node.size)return 0;var chunk=stream.node.contents.slice(position,position+length);var ab=WORKERFS.reader.readAsArrayBuffer(chunk);buffer.set(new Uint8Array(ab),offset);return chunk.size}),write:(function(stream,buffer,offset,length,position){throw new FS.ErrnoError(ERRNO_CODES.EIO)}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.size}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var _stdin=allocate(1,"i32*",ALLOC_STATIC);var _stdout=allocate(1,"i32*",ALLOC_STATIC);var _stderr=allocate(1,"i32*",ALLOC_STATIC);var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,handleFSError:(function(e){if(!(e instanceof FS.ErrnoError))throw e+" : "+stackTrace();return ___setErrNo(e.errno)}),lookupPath:(function(path,opts){path=PATH.resolve(FS.cwd(),path);opts=opts||{};if(!path)return{path:"",node:null};var defaults={follow_mount:true,recurse_count:0};for(var key in defaults){if(opts[key]===undefined){opts[key]=defaults[key]}}if(opts.recurse_count>8){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}var parts=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),false);var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}current=FS.lookupNode(current,parts[i]);current_path=PATH.join2(current_path,parts[i]);if(FS.isMountpoint(current)){if(!islast||islast&&opts.follow_mount){current=current.mounted.root}}if(!islast||opts.follow){var count=0;while(FS.isLink(current.mode)){var link=FS.readlink(current_path);current_path=PATH.resolve(PATH.dirname(current_path),link);var lookup=FS.lookupPath(current_path,{recurse_count:opts.recurse_count});current=lookup.node;if(count++>40){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}}}}return{path:current_path,node:current}}),getPath:(function(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?mount+"/"+path:mount+path}path=path?node.name+"/"+path:node.name;node=node.parent}}),hashName:(function(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length}),hashAddNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node}),hashRemoveNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}}),lookupNode:(function(parent,name){var err=FS.mayLookup(parent);if(err){throw new FS.ErrnoError(err,parent)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)}),createNode:(function(parent,name,mode,rdev){if(!FS.FSNode){FS.FSNode=(function(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.mounted=null;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.node_ops={};this.stream_ops={};this.rdev=rdev});FS.FSNode.prototype={};var readMode=292|73;var writeMode=146;Object.defineProperties(FS.FSNode.prototype,{read:{get:(function(){return(this.mode&readMode)===readMode}),set:(function(val){val?this.mode|=readMode:this.mode&=~readMode})},write:{get:(function(){return(this.mode&writeMode)===writeMode}),set:(function(val){val?this.mode|=writeMode:this.mode&=~writeMode})},isFolder:{get:(function(){return FS.isDir(this.mode)})},isDevice:{get:(function(){return FS.isChrdev(this.mode)})}})}var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node}),destroyNode:(function(node){FS.hashRemoveNode(node)}),isRoot:(function(node){return node===node.parent}),isMountpoint:(function(node){return!!node.mounted}),isFile:(function(mode){return(mode&61440)===32768}),isDir:(function(mode){return(mode&61440)===16384}),isLink:(function(mode){return(mode&61440)===40960}),isChrdev:(function(mode){return(mode&61440)===8192}),isBlkdev:(function(mode){return(mode&61440)===24576}),isFIFO:(function(mode){return(mode&61440)===4096}),isSocket:(function(mode){return(mode&49152)===49152}),flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:(function(str){var flags=FS.flagModes[str];if(typeof flags==="undefined"){throw new Error("Unknown file open mode: "+str)}return flags}),flagsToPermissionString:(function(flag){var perms=["r","w","rw"][flag&3];if(flag&512){perms+="w"}return perms}),nodePermissions:(function(node,perms){if(FS.ignorePermissions){return 0}if(perms.indexOf("r")!==-1&&!(node.mode&292)){return ERRNO_CODES.EACCES}else if(perms.indexOf("w")!==-1&&!(node.mode&146)){return ERRNO_CODES.EACCES}else if(perms.indexOf("x")!==-1&&!(node.mode&73)){return ERRNO_CODES.EACCES}return 0}),mayLookup:(function(dir){var err=FS.nodePermissions(dir,"x");if(err)return err;if(!dir.node_ops.lookup)return ERRNO_CODES.EACCES;return 0}),mayCreate:(function(dir,name){try{var node=FS.lookupNode(dir,name);return ERRNO_CODES.EEXIST}catch(e){}return FS.nodePermissions(dir,"wx")}),mayDelete:(function(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var err=FS.nodePermissions(dir,"wx");if(err){return err}if(isdir){if(!FS.isDir(node.mode)){return ERRNO_CODES.ENOTDIR}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return ERRNO_CODES.EBUSY}}else{if(FS.isDir(node.mode)){return ERRNO_CODES.EISDIR}}return 0}),mayOpen:(function(node,flags){if(!node){return ERRNO_CODES.ENOENT}if(FS.isLink(node.mode)){return ERRNO_CODES.ELOOP}else if(FS.isDir(node.mode)){if((flags&2097155)!==0||flags&512){return ERRNO_CODES.EISDIR}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))}),MAX_OPEN_FDS:4096,nextfd:(function(fd_start,fd_end){fd_start=fd_start||0;fd_end=fd_end||FS.MAX_OPEN_FDS;for(var fd=fd_start;fd<=fd_end;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(ERRNO_CODES.EMFILE)}),getStream:(function(fd){return FS.streams[fd]}),createStream:(function(stream,fd_start,fd_end){if(!FS.FSStream){FS.FSStream=(function(){});FS.FSStream.prototype={};Object.defineProperties(FS.FSStream.prototype,{object:{get:(function(){return this.node}),set:(function(val){this.node=val})},isRead:{get:(function(){return(this.flags&2097155)!==1})},isWrite:{get:(function(){return(this.flags&2097155)!==0})},isAppend:{get:(function(){return this.flags&1024})}})}var newStream=new FS.FSStream;for(var p in stream){newStream[p]=stream[p]}stream=newStream;var fd=FS.nextfd(fd_start,fd_end);stream.fd=fd;FS.streams[fd]=stream;return stream}),closeStream:(function(fd){FS.streams[fd]=null}),chrdev_stream_ops:{open:(function(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;if(stream.stream_ops.open){stream.stream_ops.open(stream)}}),llseek:(function(){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)})},major:(function(dev){return dev>>8}),minor:(function(dev){return dev&255}),makedev:(function(ma,mi){return ma<<8|mi}),registerDevice:(function(dev,ops){FS.devices[dev]={stream_ops:ops}}),getDevice:(function(dev){return FS.devices[dev]}),getMounts:(function(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push.apply(check,m.mounts)}return mounts}),syncfs:(function(populate,callback){if(typeof populate==="function"){callback=populate;populate=false}var mounts=FS.getMounts(FS.root.mount);var completed=0;function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=mounts.length){callback(null)}}mounts.forEach((function(mount){if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)}))}),mount:(function(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}}var mount={type:type,opts:opts,mountpoint:mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot}),unmount:(function(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach((function(hash){var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.indexOf(current.mount)!==-1){FS.destroyNode(current)}current=next}}));node.mounted=null;var idx=node.mount.mounts.indexOf(mount);assert(idx!==-1);node.mount.mounts.splice(idx,1)}),lookup:(function(parent,name){return parent.node_ops.lookup(parent,name)}),mknod:(function(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);if(!name||name==="."||name===".."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.mayCreate(parent,name);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.mknod(parent,name,mode,dev)}),create:(function(path,mode){mode=mode!==undefined?mode:438;mode&=4095;mode|=32768;return FS.mknod(path,mode,0)}),mkdir:(function(path,mode){mode=mode!==undefined?mode:511;mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)}),mkdev:(function(path,mode,dev){if(typeof dev==="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)}),symlink:(function(oldpath,newpath){if(!PATH.resolve(oldpath)){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var newname=PATH.basename(newpath);var err=FS.mayCreate(parent,newname);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.symlink(parent,newname,oldpath)}),rename:(function(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;try{lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!old_dir||!new_dir)throw new FS.ErrnoError(ERRNO_CODES.ENOENT);if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(ERRNO_CODES.EXDEV)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}relative=PATH.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var err=FS.mayDelete(old_dir,old_name,isdir);if(err){throw new FS.ErrnoError(err)}err=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(err){throw new FS.ErrnoError(err)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(new_dir!==old_dir){err=FS.nodePermissions(old_dir,"w");if(err){throw new FS.ErrnoError(err)}}try{if(FS.trackingDelegate["willMovePath"]){FS.trackingDelegate["willMovePath"](old_path,new_path)}}catch(e){console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name)}catch(e){throw e}finally{FS.hashAddNode(old_node)}try{if(FS.trackingDelegate["onMovePath"])FS.trackingDelegate["onMovePath"](old_path,new_path)}catch(e){console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}}),rmdir:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,true);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}return node.node_ops.readdir(node)}),unlink:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,false);if(err){if(err===ERRNO_CODES.EISDIR)err=ERRNO_CODES.EPERM;throw new FS.ErrnoError(err)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.unlink(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readlink:(function(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!link.node_ops.readlink){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return PATH.resolve(FS.getPath(link.parent),link.node_ops.readlink(link))}),stat:(function(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!node.node_ops.getattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return node.node_ops.getattr(node)}),lstat:(function(path){return FS.stat(path,true)}),chmod:(function(path,mode,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,timestamp:Date.now()})}),lchmod:(function(path,mode){FS.chmod(path,mode,true)}),fchmod:(function(fd,mode){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chmod(stream.node,mode)}),chown:(function(path,uid,gid,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{timestamp:Date.now()})}),lchown:(function(path,uid,gid){FS.chown(path,uid,gid,true)}),fchown:(function(fd,uid,gid){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chown(stream.node,uid,gid)}),truncate:(function(path,len){if(len<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.nodePermissions(node,"w");if(err){throw new FS.ErrnoError(err)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})}),ftruncate:(function(fd,len){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}FS.truncate(stream.node,len)}),utime:(function(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{timestamp:Math.max(atime,mtime)})}),open:(function(path,flags,mode,fd_start,fd_end){if(path===""){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}flags=typeof flags==="string"?FS.modeStringToFlags(flags):flags;mode=typeof mode==="undefined"?438:mode;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path==="object"){node=path}else{path=PATH.normalize(path);try{var lookup=FS.lookupPath(path,{follow:!(flags&131072)});node=lookup.node}catch(e){}}var created=false;if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(ERRNO_CODES.EEXIST)}}else{node=FS.mknod(path,mode,0);created=true}}if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(FS.isChrdev(node.mode)){flags&=~512}if(flags&65536&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}if(!created){var err=FS.mayOpen(node,flags);if(err){throw new FS.ErrnoError(err)}}if(flags&512){FS.truncate(node,0)}flags&=~(128|512);var stream=FS.createStream({node:node,path:FS.getPath(node),flags:flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false},fd_start,fd_end);if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!FS.readFiles)FS.readFiles={};if(!(path in FS.readFiles)){FS.readFiles[path]=1;Module["printErr"]("read file: "+path)}}try{if(FS.trackingDelegate["onOpenFile"]){var trackingFlags=0;if((flags&2097155)!==1){trackingFlags|=FS.tracking.openFlags.READ}if((flags&2097155)!==0){trackingFlags|=FS.tracking.openFlags.WRITE}FS.trackingDelegate["onOpenFile"](path,trackingFlags)}}catch(e){console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: "+e.message)}return stream}),close:(function(stream){if(stream.getdents)stream.getdents=null;try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}}),llseek:(function(stream,offset,whence){if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}stream.position=stream.stream_ops.llseek(stream,offset,whence);stream.ungotten=[];return stream.position}),read:(function(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.read){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead}),write:(function(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.write){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(stream.flags&1024){FS.llseek(stream,0,2)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;try{if(stream.path&&FS.trackingDelegate["onWriteToFile"])FS.trackingDelegate["onWriteToFile"](stream.path)}catch(e){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+e.message)}return bytesWritten}),allocate:(function(stream,offset,length){if(offset<0||length<=0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}stream.stream_ops.allocate(stream,offset,length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EACCES)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}return stream.stream_ops.mmap(stream,buffer,offset,length,position,prot,flags)}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!stream||!stream.stream_ops.msync){return 0}return stream.stream_ops.msync(stream,buffer,offset,length,mmapFlags)}),munmap:(function(stream){return 0}),ioctl:(function(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)}return stream.stream_ops.ioctl(stream,cmd,arg)}),readFile:(function(path,opts){opts=opts||{};opts.flags=opts.flags||"r";opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret=UTF8ArrayToString(buf,0)}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret}),writeFile:(function(path,data,opts){opts=opts||{};opts.flags=opts.flags||"w";opts.encoding=opts.encoding||"utf8";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var stream=FS.open(path,opts.flags,opts.mode);if(opts.encoding==="utf8"){var buf=new Uint8Array(lengthBytesUTF8(data)+1);var actualNumBytes=stringToUTF8Array(data,buf,0,buf.length);FS.write(stream,buf,0,actualNumBytes,0,opts.canOwn)}else if(opts.encoding==="binary"){FS.write(stream,data,0,data.length,0,opts.canOwn)}FS.close(stream)}),cwd:(function(){return FS.currentPath}),chdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}var err=FS.nodePermissions(lookup.node,"x");if(err){throw new FS.ErrnoError(err)}FS.currentPath=lookup.path}),createDefaultDirectories:(function(){FS.mkdir("/tmp");FS.mkdir("/home");FS.mkdir("/home/web_user")}),createDefaultDevices:(function(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:(function(){return 0}),write:(function(stream,buffer,offset,length,pos){return length})});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var random_device;if(typeof crypto!=="undefined"){var randomBuffer=new Uint8Array(1);random_device=(function(){crypto.getRandomValues(randomBuffer);return randomBuffer[0]})}else if(ENVIRONMENT_IS_NODE){random_device=(function(){return __webpack_require__(417).randomBytes(1)[0]})}else{random_device=(function(){return Math.random()*256|0})}FS.createDevice("/dev","random",random_device);FS.createDevice("/dev","urandom",random_device);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")}),createSpecialDirectories:(function(){FS.mkdir("/proc");FS.mkdir("/proc/self");FS.mkdir("/proc/self/fd");FS.mount({mount:(function(){var node=FS.createNode("/proc/self","fd",16384|511,73);node.node_ops={lookup:(function(parent,name){var fd=+name;var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);var ret={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:(function(){return stream.path})}};ret.parent=ret;return ret})};return node})},{},"/proc/self/fd")}),createStandardStreams:(function(){if(Module["stdin"]){FS.createDevice("/dev","stdin",Module["stdin"])}else{FS.symlink("/dev/tty","/dev/stdin")}if(Module["stdout"]){FS.createDevice("/dev","stdout",null,Module["stdout"])}else{FS.symlink("/dev/tty","/dev/stdout")}if(Module["stderr"]){FS.createDevice("/dev","stderr",null,Module["stderr"])}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin","r");assert(stdin.fd===0,"invalid handle for stdin ("+stdin.fd+")");var stdout=FS.open("/dev/stdout","w");assert(stdout.fd===1,"invalid handle for stdout ("+stdout.fd+")");var stderr=FS.open("/dev/stderr","w");assert(stderr.fd===2,"invalid handle for stderr ("+stderr.fd+")")}),ensureErrnoError:(function(){if(FS.ErrnoError)return;FS.ErrnoError=function ErrnoError(errno,node){this.node=node;this.setErrno=(function(errno){this.errno=errno;for(var key in ERRNO_CODES){if(ERRNO_CODES[key]===errno){this.code=key;break}}});this.setErrno(errno);this.message=ERRNO_MESSAGES[errno]};FS.ErrnoError.prototype=new Error;FS.ErrnoError.prototype.constructor=FS.ErrnoError;[ERRNO_CODES.ENOENT].forEach((function(code){FS.genericErrors[code]=new FS.ErrnoError(code);FS.genericErrors[code].stack="<generic error, no stack>"}))}),staticInit:(function(){FS.ensureErrnoError();FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices();FS.createSpecialDirectories();FS.filesystems={"MEMFS":MEMFS,"IDBFS":IDBFS,"NODEFS":NODEFS,"WORKERFS":WORKERFS}}),init:(function(input,output,error){assert(!FS.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");FS.init.initialized=true;FS.ensureErrnoError();Module["stdin"]=input||Module["stdin"];Module["stdout"]=output||Module["stdout"];Module["stderr"]=error||Module["stderr"];FS.createStandardStreams()}),quit:(function(){FS.init.initialized=false;var fflush=Module["_fflush"];if(fflush)fflush(0);for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}}),getMode:(function(canRead,canWrite){var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode}),joinPath:(function(parts,forceRelative){var path=PATH.join.apply(null,parts);if(forceRelative&&path[0]=="/")path=path.substr(1);return path}),absolutePath:(function(relative,base){return PATH.resolve(base,relative)}),standardizePath:(function(path){return PATH.normalize(path)}),findObject:(function(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object}else{___setErrNo(ret.error);return null}}),analyzePath:(function(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret}),createFolder:(function(parent,name,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.mkdir(path,mode)}),createPath:(function(parent,path,canRead,canWrite){parent=typeof parent==="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current}),createFile:(function(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.create(path,mode)}),createDataFile:(function(parent,name,data,canRead,canWrite,canOwn){var path=name?PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name):parent;var mode=FS.getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data==="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,"w");FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}return node}),createDevice:(function(parent,name,input,output){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(!!input,!!output);if(!FS.createDevice.major)FS.createDevice.major=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open:(function(stream){stream.seekable=false}),close:(function(stream){if(output&&output.buffer&&output.buffer.length){output(10)}}),read:(function(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})});return FS.mkdev(path,mode,dev)}),createLink:(function(parent,name,target,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);return FS.symlink(target,path)}),forceLoadFile:(function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;var success=true;if(typeof XMLHttpRequest!=="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else if(Module["read"]){try{obj.contents=intArrayFromString(Module["read"](obj.url),true);obj.usedBytes=obj.contents.length}catch(e){success=false}}else{throw new Error("Cannot load without read() or XMLHttpRequest.")}if(!success)___setErrNo(ERRNO_CODES.EIO);return success}),createLazyFile:(function(parent,name,url,canRead,canWrite){function LazyUint8Array(){this.lengthKnown=false;this.chunks=[]}LazyUint8Array.prototype.get=function LazyUint8Array_get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=idx/this.chunkSize|0;return this.getter(chunkNum)[chunkOffset]};LazyUint8Array.prototype.setDataGetter=function LazyUint8Array_setDataGetter(getter){this.getter=getter};LazyUint8Array.prototype.cacheLength=function LazyUint8Array_cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=(function(from,to){if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);if(typeof Uint8Array!="undefined")xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}else{return intArrayFromString(xhr.responseText||"",true)}});var lazyArray=this;lazyArray.setDataGetter((function(chunkNum){var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]==="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]==="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]}));this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true};if(typeof XMLHttpRequest!=="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;Object.defineProperty(lazyArray,"length",{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._length})});Object.defineProperty(lazyArray,"chunkSize",{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize})});var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url:url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperty(node,"usedBytes",{get:(function(){return this.contents.length})});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach((function(key){var fn=node.stream_ops[key];stream_ops[key]=function forceLoadLazyFile(){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}return fn.apply(null,arguments)}}));stream_ops.read=function stream_ops_read(stream,buffer,offset,length,position){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);assert(size>=0);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size};node.stream_ops=stream_ops;return node}),createPreloadedFile:(function(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn,preFinish){Browser.init();var fullname=name?PATH.resolve(PATH.join2(parent,name)):parent;var dep=getUniqueRunDependency("cp "+fullname);function processData(byteArray){function finish(byteArray){if(preFinish)preFinish();if(!dontCreateFile){FS.createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}if(onload)onload();removeRunDependency(dep)}var handled=false;Module["preloadPlugins"].forEach((function(plugin){if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,(function(){if(onerror)onerror();removeRunDependency(dep)}));handled=true}}));if(!handled)finish(byteArray)}addRunDependency(dep);if(typeof url=="string"){Browser.asyncLoad(url,(function(byteArray){processData(byteArray)}),onerror)}else{processData(url)}}),indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_NAME:(function(){return"EM_FS_"+window.location.pathname}),DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=function openRequest_onupgradeneeded(){console.log("creating db");var db=openRequest.result;db.createObjectStore(FS.DB_STORE_NAME)};openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;var transaction=db.transaction([FS.DB_STORE_NAME],"readwrite");var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var putRequest=files.put(FS.analyzePath(path).object.contents,path);putRequest.onsuccess=function putRequest_onsuccess(){ok++;if(ok+fail==total)finish()};putRequest.onerror=function putRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror}),loadFilesFromDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=onerror;openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;try{var transaction=db.transaction([FS.DB_STORE_NAME],"readonly")}catch(e){onerror(e);return}var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var getRequest=files.get(path);getRequest.onsuccess=function getRequest_onsuccess(){if(FS.analyzePath(path).exists){FS.unlink(path)}FS.createDataFile(PATH.dirname(path),PATH.basename(path),getRequest.result,true,true,true);ok++;if(ok+fail==total)finish()};getRequest.onerror=function getRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror})};var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:(function(dirfd,path){if(path[0]!=="/"){var dir;if(dirfd===-100){dir=FS.cwd()}else{var dirstream=FS.getStream(dirfd);if(!dirstream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);dir=dirstream.path}path=PATH.join2(dir,path)}return path}),doStat:(function(func,path,buf){try{var stat=func(path)}catch(e){if(e&&e.node&&PATH.normalize(path)!==PATH.normalize(FS.getPath(e.node))){return-ERRNO_CODES.ENOTDIR}throw e}HEAP32[buf>>2]=stat.dev;HEAP32[buf+4>>2]=0;HEAP32[buf+8>>2]=stat.ino;HEAP32[buf+12>>2]=stat.mode;HEAP32[buf+16>>2]=stat.nlink;HEAP32[buf+20>>2]=stat.uid;HEAP32[buf+24>>2]=stat.gid;HEAP32[buf+28>>2]=stat.rdev;HEAP32[buf+32>>2]=0;HEAP32[buf+36>>2]=stat.size;HEAP32[buf+40>>2]=4096;HEAP32[buf+44>>2]=stat.blocks;HEAP32[buf+48>>2]=stat.atime.getTime()/1e3|0;HEAP32[buf+52>>2]=0;HEAP32[buf+56>>2]=stat.mtime.getTime()/1e3|0;HEAP32[buf+60>>2]=0;HEAP32[buf+64>>2]=stat.ctime.getTime()/1e3|0;HEAP32[buf+68>>2]=0;HEAP32[buf+72>>2]=stat.ino;return 0}),doMsync:(function(addr,stream,len,flags){var buffer=new Uint8Array(HEAPU8.subarray(addr,addr+len));FS.msync(stream,buffer,0,len,flags)}),doMkdir:(function(path,mode){path=PATH.normalize(path);if(path[path.length-1]==="/")path=path.substr(0,path.length-1);FS.mkdir(path,mode,0);return 0}),doMknod:(function(path,mode,dev){switch(mode&61440){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:return-ERRNO_CODES.EINVAL}FS.mknod(path,mode,dev);return 0}),doReadlink:(function(path,buf,bufsize){if(bufsize<=0)return-ERRNO_CODES.EINVAL;var ret=FS.readlink(path);ret=ret.slice(0,Math.max(0,bufsize));writeStringToMemory(ret,buf,true);return ret.length}),doAccess:(function(path,amode){if(amode&~7){return-ERRNO_CODES.EINVAL}var node;var lookup=FS.lookupPath(path,{follow:true});node=lookup.node;var perms="";if(amode&4)perms+="r";if(amode&2)perms+="w";if(amode&1)perms+="x";if(perms&&FS.nodePermissions(node,perms)){return-ERRNO_CODES.EACCES}return 0}),doDup:(function(path,flags,suggestFD){var suggest=FS.getStream(suggestFD);if(suggest)FS.close(suggest);return FS.open(path,flags,0,suggestFD,suggestFD).fd}),doReadv:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.read(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len)break}return ret}),doWritev:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.write(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr}return ret}),varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),getStreamFromFD:(function(){var stream=FS.getStream(SYSCALLS.get());if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return stream}),getSocketFromFD:(function(){var socket=SOCKFS.getSocket(SYSCALLS.get());if(!socket)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return socket}),getSocketAddress:(function(allowNull){var addrp=SYSCALLS.get(),addrlen=SYSCALLS.get();if(allowNull&&addrp===0)return null;var info=__read_sockaddr(addrp,addrlen);if(info.errno)throw new FS.ErrnoError(info.errno);info.addr=DNS.lookup_addr(info.addr)||info.addr;return info}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall54(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),op=SYSCALLS.get();switch(op){case 21505:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21506:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21519:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;var argp=SYSCALLS.get();HEAP32[argp>>2]=0;return 0};case 21520:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return-ERRNO_CODES.EINVAL};case 21531:{var argp=SYSCALLS.get();return FS.ioctl(stream,op,argp)};default:abort("bad ioctl syscall "+op)}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}Module["_bitshift64Ashr"]=_bitshift64Ashr;Module["_bitshift64Lshr"]=_bitshift64Lshr;var _BDtoIHigh=true;function _pthread_cleanup_push(routine,arg){__ATEXIT__.push((function(){Runtime.dynCall("vi",routine,[arg])}));_pthread_cleanup_push.level=__ATEXIT__.length}function _pthread_cond_broadcast(){return 0}var _emscripten_resume=true;function _pthread_cleanup_pop(){assert(_pthread_cleanup_push.level==__ATEXIT__.length,"cannot pop if something else added meanwhile!");__ATEXIT__.pop();_pthread_cleanup_push.level=__ATEXIT__.length}function _pthread_mutex_unlock(){}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;function _pthread_mutex_lock(){}function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0){var success=self.alloc(bytes);if(!success)return-1>>>0}return ret}function __isLeapYear(year){return year%4===0&&(year%100!==0||year%400===0)}function __arraySum(array,index){var sum=0;for(var i=0;i<=index;sum+=array[i++]);return sum}var __MONTH_DAYS_LEAP=[31,29,31,30,31,30,31,31,30,31,30,31];var __MONTH_DAYS_REGULAR=[31,28,31,30,31,30,31,31,30,31,30,31];function __addDays(date,days){var newDate=new Date(date.getTime());while(days>0){var leap=__isLeapYear(newDate.getFullYear());var currentMonth=newDate.getMonth();var daysInCurrentMonth=(leap?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR)[currentMonth];if(days>daysInCurrentMonth-newDate.getDate()){days-=daysInCurrentMonth-newDate.getDate()+1;newDate.setDate(1);if(currentMonth<11){newDate.setMonth(currentMonth+1)}else{newDate.setMonth(0);newDate.setFullYear(newDate.getFullYear()+1)}}else{newDate.setDate(newDate.getDate()+days);return newDate}}return newDate}function _strftime(s,maxsize,format,tm){var tm_zone=HEAP32[tm+40>>2];var date={tm_sec:HEAP32[tm>>2],tm_min:HEAP32[tm+4>>2],tm_hour:HEAP32[tm+8>>2],tm_mday:HEAP32[tm+12>>2],tm_mon:HEAP32[tm+16>>2],tm_year:HEAP32[tm+20>>2],tm_wday:HEAP32[tm+24>>2],tm_yday:HEAP32[tm+28>>2],tm_isdst:HEAP32[tm+32>>2],tm_gmtoff:HEAP32[tm+36>>2],tm_zone:tm_zone?Pointer_stringify(tm_zone):""};var pattern=Pointer_stringify(format);var EXPANSION_RULES_1={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S"};for(var rule in EXPANSION_RULES_1){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_1[rule])}var WEEKDAYS=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];var MONTHS=["January","February","March","April","May","June","July","August","September","October","November","December"];function leadingSomething(value,digits,character){var str=typeof value==="number"?value.toString():value||"";while(str.length<digits){str=character[0]+str}return str}function leadingNulls(value,digits){return leadingSomething(value,digits,"0")}function compareByDay(date1,date2){function sgn(value){return value<0?-1:value>0?1:0}var compare;if((compare=sgn(date1.getFullYear()-date2.getFullYear()))===0){if((compare=sgn(date1.getMonth()-date2.getMonth()))===0){compare=sgn(date1.getDate()-date2.getDate())}}return compare}function getFirstWeekStartDate(janFourth){switch(janFourth.getDay()){case 0:return new Date(janFourth.getFullYear()-1,11,29);case 1:return janFourth;case 2:return new Date(janFourth.getFullYear(),0,3);case 3:return new Date(janFourth.getFullYear(),0,2);case 4:return new Date(janFourth.getFullYear(),0,1);case 5:return new Date(janFourth.getFullYear()-1,11,31);case 6:return new Date(janFourth.getFullYear()-1,11,30)}}function getWeekBasedYear(date){var thisDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);var janFourthThisYear=new Date(thisDate.getFullYear(),0,4);var janFourthNextYear=new Date(thisDate.getFullYear()+1,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);if(compareByDay(firstWeekStartThisYear,thisDate)<=0){if(compareByDay(firstWeekStartNextYear,thisDate)<=0){return thisDate.getFullYear()+1}else{return thisDate.getFullYear()}}else{return thisDate.getFullYear()-1}}var EXPANSION_RULES_2={"%a":(function(date){return WEEKDAYS[date.tm_wday].substring(0,3)}),"%A":(function(date){return WEEKDAYS[date.tm_wday]}),"%b":(function(date){return MONTHS[date.tm_mon].substring(0,3)}),"%B":(function(date){return MONTHS[date.tm_mon]}),"%C":(function(date){var year=date.tm_year+1900;return leadingNulls(year/100|0,2)}),"%d":(function(date){return leadingNulls(date.tm_mday,2)}),"%e":(function(date){return leadingSomething(date.tm_mday,2," ")}),"%g":(function(date){return getWeekBasedYear(date).toString().substring(2)}),"%G":(function(date){return getWeekBasedYear(date)}),"%H":(function(date){return leadingNulls(date.tm_hour,2)}),"%I":(function(date){return leadingNulls(date.tm_hour<13?date.tm_hour:date.tm_hour-12,2)}),"%j":(function(date){return leadingNulls(date.tm_mday+__arraySum(__isLeapYear(date.tm_year+1900)?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,date.tm_mon-1),3)}),"%m":(function(date){return leadingNulls(date.tm_mon+1,2)}),"%M":(function(date){return leadingNulls(date.tm_min,2)}),"%n":(function(){return"\n"}),"%p":(function(date){if(date.tm_hour>0&&date.tm_hour<13){return"AM"}else{return"PM"}}),"%S":(function(date){return leadingNulls(date.tm_sec,2)}),"%t":(function(){return"\t"}),"%u":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()||7}),"%U":(function(date){var janFirst=new Date(date.tm_year+1900,0,1);var firstSunday=janFirst.getDay()===0?janFirst:__addDays(janFirst,7-janFirst.getDay());var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstSunday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstSundayUntilEndJanuary=31-firstSunday.getDate();var days=firstSundayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstSunday,janFirst)===0?"01":"00"}),"%V":(function(date){var janFourthThisYear=new Date(date.tm_year+1900,0,4);var janFourthNextYear=new Date(date.tm_year+1901,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);var endDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);if(compareByDay(endDate,firstWeekStartThisYear)<0){return"53"}if(compareByDay(firstWeekStartNextYear,endDate)<=0){return"01"}var daysDifference;if(firstWeekStartThisYear.getFullYear()<date.tm_year+1900){daysDifference=date.tm_yday+32-firstWeekStartThisYear.getDate()}else{daysDifference=date.tm_yday+1-firstWeekStartThisYear.getDate()}return leadingNulls(Math.ceil(daysDifference/7),2)}),"%w":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()}),"%W":(function(date){var janFirst=new Date(date.tm_year,0,1);var firstMonday=janFirst.getDay()===1?janFirst:__addDays(janFirst,janFirst.getDay()===0?1:7-janFirst.getDay()+1);var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstMonday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstMondayUntilEndJanuary=31-firstMonday.getDate();var days=firstMondayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstMonday,janFirst)===0?"01":"00"}),"%y":(function(date){return(date.tm_year+1900).toString().substring(2)}),"%Y":(function(date){return date.tm_year+1900}),"%z":(function(date){var off=date.tm_gmtoff;var ahead=off>=0;off=Math.abs(off)/60;off=off/60*100+off%60;return(ahead?"+":"-")+String("0000"+off).slice(-4)}),"%Z":(function(date){return date.tm_zone}),"%%":(function(){return"%"})};for(var rule in EXPANSION_RULES_2){if(pattern.indexOf(rule)>=0){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_2[rule](date))}}var bytes=intArrayFromString(pattern,false);if(bytes.length>maxsize){return 0}writeArrayToMemory(bytes,s);return bytes.length-1}function _strftime_l(s,maxsize,format,tm){return _strftime(s,maxsize,format,tm)}function ___cxa_guard_abort(){}Module["_memmove"]=_memmove;var _emscripten_preinvoke=true;var _BItoD=true;function _pthread_cond_wait(){return 0}function ___cxa_rethrow(){___cxa_end_catch.rethrown=true;var ptr=EXCEPTIONS.caught.pop();EXCEPTIONS.last=ptr;throw ptr}function __embind_register_memory_view(rawType,dataTypeIndex,name){var typeMapping=[Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];var TA=typeMapping[dataTypeIndex];function decodeMemoryView(handle){handle=handle>>2;var heap=HEAPU32;var size=heap[handle];var data=heap[handle+1];return new TA(heap["buffer"],data,size)}name=readLatin1String(name);registerType(rawType,{name:name,"fromWireType":decodeMemoryView,"argPackAdvance":8,"readValueFromPointer":decodeMemoryView},{ignoreDuplicateRegistrations:true})}function ___cxa_guard_release(){}function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function __embind_register_std_string(rawType,name){name=readLatin1String(name);registerType(rawType,{name:name,"fromWireType":(function(value){var length=HEAPU32[value>>2];var a=new Array(length);for(var i=0;i<length;++i){a[i]=String.fromCharCode(HEAPU8[value+4+i])}_free(value);return a.join("")}),"toWireType":(function(destructors,value){if(value instanceof ArrayBuffer){value=new Uint8Array(value)}function getTAElement(ta,index){return ta[index]}function getStringElement(string,index){return string.charCodeAt(index)}var getElement;if(value instanceof Uint8Array){getElement=getTAElement}else if(value instanceof Int8Array){getElement=getTAElement}else if(typeof value==="string"){getElement=getStringElement}else{throwBindingError("Cannot pass non-string to std::string")}var length=value.length;var ptr=_malloc(4+length);HEAPU32[ptr>>2]=length;for(var i=0;i<length;++i){var charCode=getElement(value,i);if(charCode>255){_free(ptr);throwBindingError("String has UTF-16 code units that do not fit in 8 bits")}HEAPU8[ptr+4+i]=charCode}if(destructors!==null){destructors.push(_free,ptr)}return ptr}),"argPackAdvance":8,"readValueFromPointer":simpleReadValueFromPointer,destructorFunction:(function(ptr){_free(ptr)})})}function ___assert_fail(condition,filename,line,func){ABORT=true;throw"Assertion failed: "+Pointer_stringify(condition)+", at: "+[filename?Pointer_stringify(filename):"unknown filename",line,func?Pointer_stringify(func):"unknown function"]+" at "+stackTrace()}function __embind_register_void(rawType,name){name=readLatin1String(name);registerType(rawType,{isVoid:true,name:name,"argPackAdvance":0,"fromWireType":(function(){return undefined}),"toWireType":(function(destructors,o){return undefined})})}Module["_memset"]=_memset;var _BDtoILow=true;function ___gxx_personality_v0(){}Module["_bitshift64Shl"]=_bitshift64Shl;function _abort(){Module["abort"]()}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Runtime.dynCall("v",func);_pthread_once.seen[ptr]=1}function ___lock(){}function ___unlock(){}function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}var _fabs=Math_abs;function _emscripten_set_main_loop_timing(mode,value){Browser.mainLoop.timingMode=mode;Browser.mainLoop.timingValue=value;if(!Browser.mainLoop.func){return 1}if(mode==0){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setTimeout(){setTimeout(Browser.mainLoop.runner,value)};Browser.mainLoop.method="timeout"}else if(mode==1){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_rAF(){Browser.requestAnimationFrame(Browser.mainLoop.runner)};Browser.mainLoop.method="rAF"}else if(mode==2){if(!window["setImmediate"]){var setImmediates=[];var emscriptenMainLoopMessageId="__emcc";function Browser_setImmediate_messageHandler(event){if(event.source===window&&event.data===emscriptenMainLoopMessageId){event.stopPropagation();setImmediates.shift()()}}window.addEventListener("message",Browser_setImmediate_messageHandler,true);window["setImmediate"]=function Browser_emulated_setImmediate(func){setImmediates.push(func);window.postMessage(emscriptenMainLoopMessageId,"*")}}Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setImmediate(){window["setImmediate"](Browser.mainLoop.runner)};Browser.mainLoop.method="immediate"}return 0}function _emscripten_set_main_loop(func,fps,simulateInfiniteLoop,arg,noSetTiming){Module["noExitRuntime"]=true;assert(!Browser.mainLoop.func,"emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.");Browser.mainLoop.func=func;Browser.mainLoop.arg=arg;var thisMainLoopId=Browser.mainLoop.currentlyRunningMainloop;Browser.mainLoop.runner=function Browser_mainLoop_runner(){if(ABORT)return;if(Browser.mainLoop.queue.length>0){var start=Date.now();var blocker=Browser.mainLoop.queue.shift();blocker.func(blocker.arg);if(Browser.mainLoop.remainingBlockers){var remaining=Browser.mainLoop.remainingBlockers;var next=remaining%1==0?remaining-1:Math.floor(remaining);if(blocker.counted){Browser.mainLoop.remainingBlockers=next}else{next=next+.5;Browser.mainLoop.remainingBlockers=(8*remaining+next)/9}}console.log('main loop blocker "'+blocker.name+'" took '+(Date.now()-start)+" ms");Browser.mainLoop.updateStatus();setTimeout(Browser.mainLoop.runner,0);return}if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;Browser.mainLoop.currentFrameNumber=Browser.mainLoop.currentFrameNumber+1|0;if(Browser.mainLoop.timingMode==1&&Browser.mainLoop.timingValue>1&&Browser.mainLoop.currentFrameNumber%Browser.mainLoop.timingValue!=0){Browser.mainLoop.scheduler();return}if(Browser.mainLoop.method==="timeout"&&Module.ctx){Module.printErr("Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!");Browser.mainLoop.method=""}Browser.mainLoop.runIter((function(){if(typeof arg!=="undefined"){Runtime.dynCall("vi",func,[arg])}else{Runtime.dynCall("v",func)}}));if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;if(typeof SDL==="object"&&SDL.audio&&SDL.audio.queueNewAudioData)SDL.audio.queueNewAudioData();Browser.mainLoop.scheduler()};if(!noSetTiming){if(fps&&fps>0)_emscripten_set_main_loop_timing(0,1e3/fps);else _emscripten_set_main_loop_timing(1,1);Browser.mainLoop.scheduler()}if(simulateInfiniteLoop){throw"SimulateInfiniteLoop"}}var Browser={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:(function(){Browser.mainLoop.scheduler=null;Browser.mainLoop.currentlyRunningMainloop++}),resume:(function(){Browser.mainLoop.currentlyRunningMainloop++;var timingMode=Browser.mainLoop.timingMode;var timingValue=Browser.mainLoop.timingValue;var func=Browser.mainLoop.func;Browser.mainLoop.func=null;_emscripten_set_main_loop(func,0,false,Browser.mainLoop.arg,true);_emscripten_set_main_loop_timing(timingMode,timingValue);Browser.mainLoop.scheduler()}),updateStatus:(function(){if(Module["setStatus"]){var message=Module["statusMessage"]||"Please wait...";var remaining=Browser.mainLoop.remainingBlockers;var expected=Browser.mainLoop.expectedBlockers;if(remaining){if(remaining<expected){Module["setStatus"](message+" ("+(expected-remaining)+"/"+expected+")")}else{Module["setStatus"](message)}}else{Module["setStatus"]("")}}}),runIter:(function(func){if(ABORT)return;if(Module["preMainLoop"]){var preRet=Module["preMainLoop"]();if(preRet===false){return}}try{func()}catch(e){if(e instanceof ExitStatus){return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}if(Module["postMainLoop"])Module["postMainLoop"]()})},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:(function(){if(!Module["preloadPlugins"])Module["preloadPlugins"]=[];if(Browser.initted)return;Browser.initted=true;try{new Blob;Browser.hasBlobConstructor=true}catch(e){Browser.hasBlobConstructor=false;console.log("warning: no blob constructor, cannot create blobs with mimetypes")}Browser.BlobBuilder=typeof MozBlobBuilder!="undefined"?MozBlobBuilder:typeof WebKitBlobBuilder!="undefined"?WebKitBlobBuilder:!Browser.hasBlobConstructor?console.log("warning: no BlobBuilder"):null;Browser.URLObject=typeof window!="undefined"?window.URL?window.URL:window.webkitURL:undefined;if(!Module.noImageDecoding&&typeof Browser.URLObject==="undefined"){console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");Module.noImageDecoding=true}var imagePlugin={};imagePlugin["canHandle"]=function imagePlugin_canHandle(name){return!Module.noImageDecoding&&/\.(jpg|jpeg|png|bmp)$/i.test(name)};imagePlugin["handle"]=function imagePlugin_handle(byteArray,name,onload,onerror){var b=null;if(Browser.hasBlobConstructor){try{b=new Blob([byteArray],{type:Browser.getMimetype(name)});if(b.size!==byteArray.length){b=new Blob([(new Uint8Array(byteArray)).buffer],{type:Browser.getMimetype(name)})}}catch(e){Runtime.warnOnce("Blob constructor present but fails: "+e+"; falling back to blob builder")}}if(!b){var bb=new Browser.BlobBuilder;bb.append((new Uint8Array(byteArray)).buffer);b=bb.getBlob()}var url=Browser.URLObject.createObjectURL(b);var img=new Image;img.onload=function img_onload(){assert(img.complete,"Image "+name+" could not be decoded");var canvas=document.createElement("canvas");canvas.width=img.width;canvas.height=img.height;var ctx=canvas.getContext("2d");ctx.drawImage(img,0,0);Module["preloadedImages"][name]=canvas;Browser.URLObject.revokeObjectURL(url);if(onload)onload(byteArray)};img.onerror=function img_onerror(event){console.log("Image "+url+" could not be decoded");if(onerror)onerror()};img.src=url};Module["preloadPlugins"].push(imagePlugin);var audioPlugin={};audioPlugin["canHandle"]=function audioPlugin_canHandle(name){return!Module.noAudioDecoding&&name.substr(-4)in{".ogg":1,".wav":1,".mp3":1}};audioPlugin["handle"]=function audioPlugin_handle(byteArray,name,onload,onerror){var done=false;function finish(audio){if(done)return;done=true;Module["preloadedAudios"][name]=audio;if(onload)onload(byteArray)}function fail(){if(done)return;done=true;Module["preloadedAudios"][name]=new Audio;if(onerror)onerror()}if(Browser.hasBlobConstructor){try{var b=new Blob([byteArray],{type:Browser.getMimetype(name)})}catch(e){return fail()}var url=Browser.URLObject.createObjectURL(b);var audio=new Audio;audio.addEventListener("canplaythrough",(function(){finish(audio)}),false);audio.onerror=function audio_onerror(event){if(done)return;console.log("warning: browser could not fully decode audio "+name+", trying slower base64 approach");function encode64(data){var BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var PAD="=";var ret="";var leftchar=0;var leftbits=0;for(var i=0;i<data.length;i++){leftchar=leftchar<<8|data[i];leftbits+=8;while(leftbits>=6){var curr=leftchar>>leftbits-6&63;leftbits-=6;ret+=BASE[curr]}}if(leftbits==2){ret+=BASE[(leftchar&3)<<4];ret+=PAD+PAD}else if(leftbits==4){ret+=BASE[(leftchar&15)<<2];ret+=PAD}return ret}audio.src="data:audio/x-"+name.substr(-3)+";base64,"+encode64(byteArray);finish(audio)};audio.src=url;Browser.safeSetTimeout((function(){finish(audio)}),1e4)}else{return fail()}};Module["preloadPlugins"].push(audioPlugin);var canvas=Module["canvas"];function pointerLockChange(){Browser.pointerLock=document["pointerLockElement"]===canvas||document["mozPointerLockElement"]===canvas||document["webkitPointerLockElement"]===canvas||document["msPointerLockElement"]===canvas}if(canvas){canvas.requestPointerLock=canvas["requestPointerLock"]||canvas["mozRequestPointerLock"]||canvas["webkitRequestPointerLock"]||canvas["msRequestPointerLock"]||(function(){});canvas.exitPointerLock=document["exitPointerLock"]||document["mozExitPointerLock"]||document["webkitExitPointerLock"]||document["msExitPointerLock"]||(function(){});canvas.exitPointerLock=canvas.exitPointerLock.bind(document);document.addEventListener("pointerlockchange",pointerLockChange,false);document.addEventListener("mozpointerlockchange",pointerLockChange,false);document.addEventListener("webkitpointerlockchange",pointerLockChange,false);document.addEventListener("mspointerlockchange",pointerLockChange,false);if(Module["elementPointerLock"]){canvas.addEventListener("click",(function(ev){if(!Browser.pointerLock&&canvas.requestPointerLock){canvas.requestPointerLock();ev.preventDefault()}}),false)}}}),createContext:(function(canvas,useWebGL,setInModule,webGLContextAttributes){if(useWebGL&&Module.ctx&&canvas==Module.canvas)return Module.ctx;var ctx;var contextHandle;if(useWebGL){var contextAttributes={antialias:false,alpha:false};if(webGLContextAttributes){for(var attribute in webGLContextAttributes){contextAttributes[attribute]=webGLContextAttributes[attribute]}}contextHandle=GL.createContext(canvas,contextAttributes);if(contextHandle){ctx=GL.getContext(contextHandle).GLctx}canvas.style.backgroundColor="black"}else{ctx=canvas.getContext("2d")}if(!ctx)return null;if(setInModule){if(!useWebGL)assert(typeof GLctx==="undefined","cannot set in module if GLctx is used, but we are a non-GL context that would replace it");Module.ctx=ctx;if(useWebGL)GL.makeContextCurrent(contextHandle);Module.useWebGL=useWebGL;Browser.moduleContextCreatedCallbacks.forEach((function(callback){callback()}));Browser.init()}return ctx}),destroyContext:(function(canvas,useWebGL,setInModule){}),fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:(function(lockPointer,resizeCanvas,vrDevice){Browser.lockPointer=lockPointer;Browser.resizeCanvas=resizeCanvas;Browser.vrDevice=vrDevice;if(typeof Browser.lockPointer==="undefined")Browser.lockPointer=true;if(typeof Browser.resizeCanvas==="undefined")Browser.resizeCanvas=false;if(typeof Browser.vrDevice==="undefined")Browser.vrDevice=null;var canvas=Module["canvas"];function fullScreenChange(){Browser.isFullScreen=false;var canvasContainer=canvas.parentNode;if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvasContainer){canvas.cancelFullScreen=document["cancelFullScreen"]||document["mozCancelFullScreen"]||document["webkitCancelFullScreen"]||document["msExitFullscreen"]||document["exitFullscreen"]||(function(){});canvas.cancelFullScreen=canvas.cancelFullScreen.bind(document);if(Browser.lockPointer)canvas.requestPointerLock();Browser.isFullScreen=true;if(Browser.resizeCanvas)Browser.setFullScreenCanvasSize()}else{canvasContainer.parentNode.insertBefore(canvas,canvasContainer);canvasContainer.parentNode.removeChild(canvasContainer);if(Browser.resizeCanvas)Browser.setWindowedCanvasSize()}if(Module["onFullScreen"])Module["onFullScreen"](Browser.isFullScreen);Browser.updateCanvasDimensions(canvas)}if(!Browser.fullScreenHandlersInstalled){Browser.fullScreenHandlersInstalled=true;document.addEventListener("fullscreenchange",fullScreenChange,false);document.addEventListener("mozfullscreenchange",fullScreenChange,false);document.addEventListener("webkitfullscreenchange",fullScreenChange,false);document.addEventListener("MSFullscreenChange",fullScreenChange,false)}var canvasContainer=document.createElement("div");canvas.parentNode.insertBefore(canvasContainer,canvas);canvasContainer.appendChild(canvas);canvasContainer.requestFullScreen=canvasContainer["requestFullScreen"]||canvasContainer["mozRequestFullScreen"]||canvasContainer["msRequestFullscreen"]||(canvasContainer["webkitRequestFullScreen"]?(function(){canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"])}):null);if(vrDevice){canvasContainer.requestFullScreen({vrDisplay:vrDevice})}else{canvasContainer.requestFullScreen()}}),nextRAF:0,fakeRequestAnimationFrame:(function(func){var now=Date.now();if(Browser.nextRAF===0){Browser.nextRAF=now+1e3/60}else{while(now+2>=Browser.nextRAF){Browser.nextRAF+=1e3/60}}var delay=Math.max(Browser.nextRAF-now,0);setTimeout(func,delay)}),requestAnimationFrame:function requestAnimationFrame(func){if(typeof window==="undefined"){Browser.fakeRequestAnimationFrame(func)}else{if(!window.requestAnimationFrame){window.requestAnimationFrame=window["requestAnimationFrame"]||window["mozRequestAnimationFrame"]||window["webkitRequestAnimationFrame"]||window["msRequestAnimationFrame"]||window["oRequestAnimationFrame"]||Browser.fakeRequestAnimationFrame}window.requestAnimationFrame(func)}},safeCallback:(function(func){return(function(){if(!ABORT)return func.apply(null,arguments)})}),allowAsyncCallbacks:true,queuedAsyncCallbacks:[],pauseAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=false}),resumeAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=true;if(Browser.queuedAsyncCallbacks.length>0){var callbacks=Browser.queuedAsyncCallbacks;Browser.queuedAsyncCallbacks=[];callbacks.forEach((function(func){func()}))}}),safeRequestAnimationFrame:(function(func){return Browser.requestAnimationFrame((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}))}),safeSetTimeout:(function(func,timeout){Module["noExitRuntime"]=true;return setTimeout((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}),timeout)}),safeSetInterval:(function(func,timeout){Module["noExitRuntime"]=true;return setInterval((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}}),timeout)}),getMimetype:(function(name){return{"jpg":"image/jpeg","jpeg":"image/jpeg","png":"image/png","bmp":"image/bmp","ogg":"audio/ogg","wav":"audio/wav","mp3":"audio/mpeg"}[name.substr(name.lastIndexOf(".")+1)]}),getUserMedia:(function(func){if(!window.getUserMedia){window.getUserMedia=navigator["getUserMedia"]||navigator["mozGetUserMedia"]}window.getUserMedia(func)}),getMovementX:(function(event){return event["movementX"]||event["mozMovementX"]||event["webkitMovementX"]||0}),getMovementY:(function(event){return event["movementY"]||event["mozMovementY"]||event["webkitMovementY"]||0}),getMouseWheelDelta:(function(event){var delta=0;switch(event.type){case"DOMMouseScroll":delta=event.detail;break;case"mousewheel":delta=event.wheelDelta;break;case"wheel":delta=event["deltaY"];break;default:throw"unrecognized mouse wheel event: "+event.type}return delta}),mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:(function(event){if(Browser.pointerLock){if(event.type!="mousemove"&&"mozMovementX"in event){Browser.mouseMovementX=Browser.mouseMovementY=0}else{Browser.mouseMovementX=Browser.getMovementX(event);Browser.mouseMovementY=Browser.getMovementY(event)}if(typeof SDL!="undefined"){Browser.mouseX=SDL.mouseX+Browser.mouseMovementX;Browser.mouseY=SDL.mouseY+Browser.mouseMovementY}else{Browser.mouseX+=Browser.mouseMovementX;Browser.mouseY+=Browser.mouseMovementY}}else{var rect=Module["canvas"].getBoundingClientRect();var cw=Module["canvas"].width;var ch=Module["canvas"].height;var scrollX=typeof window.scrollX!=="undefined"?window.scrollX:window.pageXOffset;var scrollY=typeof window.scrollY!=="undefined"?window.scrollY:window.pageYOffset;if(event.type==="touchstart"||event.type==="touchend"||event.type==="touchmove"){var touch=event.touch;if(touch===undefined){return}var adjustedX=touch.pageX-(scrollX+rect.left);var adjustedY=touch.pageY-(scrollY+rect.top);adjustedX=adjustedX*(cw/rect.width);adjustedY=adjustedY*(ch/rect.height);var coords={x:adjustedX,y:adjustedY};if(event.type==="touchstart"){Browser.lastTouches[touch.identifier]=coords;Browser.touches[touch.identifier]=coords}else if(event.type==="touchend"||event.type==="touchmove"){var last=Browser.touches[touch.identifier];if(!last)last=coords;Browser.lastTouches[touch.identifier]=last;Browser.touches[touch.identifier]=coords}return}var x=event.pageX-(scrollX+rect.left);var y=event.pageY-(scrollY+rect.top);x=x*(cw/rect.width);y=y*(ch/rect.height);Browser.mouseMovementX=x-Browser.mouseX;Browser.mouseMovementY=y-Browser.mouseY;Browser.mouseX=x;Browser.mouseY=y}}),xhrLoad:(function(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)}),asyncLoad:(function(url,onload,onerror,noRunDep){Browser.xhrLoad(url,(function(arrayBuffer){assert(arrayBuffer,'Loading data file "'+url+'" failed (no arrayBuffer).');onload(new Uint8Array(arrayBuffer));if(!noRunDep)removeRunDependency("al "+url)}),(function(event){if(onerror){onerror()}else{throw'Loading data file "'+url+'" failed.'}}));if(!noRunDep)addRunDependency("al "+url)}),resizeListeners:[],updateResizeListeners:(function(){var canvas=Module["canvas"];Browser.resizeListeners.forEach((function(listener){listener(canvas.width,canvas.height)}))}),setCanvasSize:(function(width,height,noUpdates){var canvas=Module["canvas"];Browser.updateCanvasDimensions(canvas,width,height);if(!noUpdates)Browser.updateResizeListeners()}),windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags|8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),setWindowedCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags&~8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),updateCanvasDimensions:(function(canvas,wNative,hNative){if(wNative&&hNative){canvas.widthNative=wNative;canvas.heightNative=hNative}else{wNative=canvas.widthNative;hNative=canvas.heightNative}var w=wNative;var h=hNative;if(Module["forcedAspectRatio"]&&Module["forcedAspectRatio"]>0){if(w/h<Module["forcedAspectRatio"]){w=Math.round(h*Module["forcedAspectRatio"])}else{h=Math.round(w/Module["forcedAspectRatio"])}}if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvas.parentNode&&typeof screen!="undefined"){var factor=Math.min(screen.width/w,screen.height/h);w=Math.round(w*factor);h=Math.round(h*factor)}if(Browser.resizeCanvas){if(canvas.width!=w)canvas.width=w;if(canvas.height!=h)canvas.height=h;if(typeof canvas.style!="undefined"){canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}else{if(canvas.width!=wNative)canvas.width=wNative;if(canvas.height!=hNative)canvas.height=hNative;if(typeof canvas.style!="undefined"){if(w!=wNative||h!=hNative){canvas.style.setProperty("width",w+"px","important");canvas.style.setProperty("height",h+"px","important")}else{canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}}}),wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:(function(){var handle=Browser.nextWgetRequestHandle;Browser.nextWgetRequestHandle++;return handle})};function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function ___cxa_allocate_exception(size){return _malloc(size)}function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}function floatReadValueFromPointer(name,shift){switch(shift){case 2:return(function(pointer){return this["fromWireType"](HEAPF32[pointer>>2])});case 3:return(function(pointer){return this["fromWireType"](HEAPF64[pointer>>3])});default:throw new TypeError("Unknown float type: "+name)}}function __embind_register_float(rawType,name,size){var shift=getShiftFromSize(size);name=readLatin1String(name);registerType(rawType,{name:name,"fromWireType":(function(value){return value}),"toWireType":(function(destructors,value){if(typeof value!=="number"&&typeof value!=="boolean"){throw new TypeError('Cannot convert "'+_embind_repr(value)+'" to '+this.name)}return value}),"argPackAdvance":8,"readValueFromPointer":floatReadValueFromPointer(name,shift),destructorFunction:null})}function ___cxa_guard_acquire(variable){if(!HEAP8[variable>>0]){HEAP8[variable>>0]=1;return 1}return 0}function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}function _llvm_eh_typeid_for(type){return type}function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___cxa_call_unexpected(exception){Module.printErr("Unexpected exception thrown, this is not properly supported - aborting");ABORT=true;throw exception}function __embind_register_std_wstring(rawType,charSize,name){name=readLatin1String(name);var getHeap,shift;if(charSize===2){getHeap=(function(){return HEAPU16});shift=1}else if(charSize===4){getHeap=(function(){return HEAPU32});shift=2}registerType(rawType,{name:name,"fromWireType":(function(value){var HEAP=getHeap();var length=HEAPU32[value>>2];var a=new Array(length);var start=value+4>>shift;for(var i=0;i<length;++i){a[i]=String.fromCharCode(HEAP[start+i])}_free(value);return a.join("")}),"toWireType":(function(destructors,value){var HEAP=getHeap();var length=value.length;var ptr=_malloc(4+length*charSize);HEAPU32[ptr>>2]=length;var start=ptr+4>>shift;for(var i=0;i<length;++i){HEAP[start+i]=value.charCodeAt(i)}if(destructors!==null){destructors.push(_free,ptr)}return ptr}),"argPackAdvance":8,"readValueFromPointer":simpleReadValueFromPointer,destructorFunction:(function(ptr){_free(ptr)})})}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function _pthread_self(){return 0}function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;assert(offset_high===0);FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doWritev(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var ___dso_handle=allocate(1,"i32*",ALLOC_STATIC);embind_init_charCodes();BindingError=Module["BindingError"]=extendError(Error,"BindingError");InternalError=Module["InternalError"]=extendError(Error,"InternalError");init_emval();FS.staticInit();__ATINIT__.unshift((function(){if(!Module["noFSInit"]&&!FS.init.initialized)FS.init()}));__ATMAIN__.push((function(){FS.ignorePermissions=false}));__ATEXIT__.push((function(){FS.quit()}));Module["FS_createFolder"]=FS.createFolder;Module["FS_createPath"]=FS.createPath;Module["FS_createDataFile"]=FS.createDataFile;Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_createLazyFile"]=FS.createLazyFile;Module["FS_createLink"]=FS.createLink;Module["FS_createDevice"]=FS.createDevice;Module["FS_unlink"]=FS.unlink;__ATINIT__.unshift((function(){TTY.init()}));__ATEXIT__.push((function(){TTY.shutdown()}));if(ENVIRONMENT_IS_NODE){var fs=__webpack_require__(163);var NODEJS_PATH=__webpack_require__(164);NODEFS.staticInit()}Module["requestFullScreen"]=function Module_requestFullScreen(lockPointer,resizeCanvas,vrDevice){Browser.requestFullScreen(lockPointer,resizeCanvas,vrDevice)};Module["requestAnimationFrame"]=function Module_requestAnimationFrame(func){Browser.requestAnimationFrame(func)};Module["setCanvasSize"]=function Module_setCanvasSize(width,height,noUpdates){Browser.setCanvasSize(width,height,noUpdates)};Module["pauseMainLoop"]=function Module_pauseMainLoop(){Browser.mainLoop.pause()};Module["resumeMainLoop"]=function Module_resumeMainLoop(){Browser.mainLoop.resume()};Module["getUserMedia"]=function Module_getUserMedia(){Browser.getUserMedia()};Module["createContext"]=function Module_createContext(canvas,useWebGL,setInModule,webGLContextAttributes){return Browser.createContext(canvas,useWebGL,setInModule,webGLContextAttributes)};STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_iiiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{return Module["dynCall_iiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiiiiiii(index,a1,a2,a3,a4,a5,a6,a7){return Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6,a7)}function invoke_iiiiiid(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiid"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiiiiid(index,a1,a2,a3,a4,a5,a6){return Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6)}function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_viiiii(index,a1,a2,a3,a4,a5){Runtime.functionPointers[index](a1,a2,a3,a4,a5)}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_vi(index,a1){Runtime.functionPointers[index](a1)}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_vii(index,a1,a2){Runtime.functionPointers[index](a1,a2)}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiiiiii(index,a1,a2,a3,a4,a5,a6){return Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6)}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_ii(index,a1){return Runtime.functionPointers[index](a1)}function invoke_idddddddd(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_idddddddd"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_idddddddd(index,a1,a2,a3,a4,a5,a6,a7,a8){return Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6,a7,a8)}function invoke_iiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){try{return Module["dynCall_iiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){return Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}function invoke_vidd(index,a1,a2,a3){try{Module["dynCall_vidd"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_vidd(index,a1,a2,a3){Runtime.functionPointers[index](a1,a2,a3)}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiii(index,a1,a2,a3){return Runtime.functionPointers[index](a1,a2,a3)}function invoke_viiiiiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15){try{Module["dynCall_viiiiiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_viiiiiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15){Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15)}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_viiiiii(index,a1,a2,a3,a4,a5,a6){Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6)}function invoke_diiii(index,a1,a2,a3,a4){try{return Module["dynCall_diiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_diiii(index,a1,a2,a3,a4){return Runtime.functionPointers[index](a1,a2,a3,a4)}function invoke_iidiid(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iidiid"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iidiid(index,a1,a2,a3,a4,a5){return Runtime.functionPointers[index](a1,a2,a3,a4,a5)}function invoke_viddd(index,a1,a2,a3,a4){try{Module["dynCall_viddd"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_viddd(index,a1,a2,a3,a4){Runtime.functionPointers[index](a1,a2,a3,a4)}function invoke_di(index,a1){try{return Module["dynCall_di"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_di(index,a1){return Runtime.functionPointers[index](a1)}function invoke_iiiiidddddddd(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){try{return Module["dynCall_iiiiidddddddd"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiiiidddddddd(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){return Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6,a7)}function invoke_iiddd(index,a1,a2,a3,a4){try{return Module["dynCall_iiddd"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiddd(index,a1,a2,a3,a4){return Runtime.functionPointers[index](a1,a2,a3,a4)}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6,a7,a8,a9)}function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iii(index,a1,a2){return Runtime.functionPointers[index](a1,a2)}function invoke_iiiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiiiii(index,a1,a2,a3,a4,a5){return Runtime.functionPointers[index](a1,a2,a3,a4,a5)}function invoke_diii(index,a1,a2,a3){try{return Module["dynCall_diii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_diii(index,a1,a2,a3){return Runtime.functionPointers[index](a1,a2,a3)}function invoke_iiiidddddddddddddddd(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19){try{return Module["dynCall_iiiidddddddddddddddd"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiiidddddddddddddddd(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19){return Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19)}function invoke_viiiiiidi(index,a1,a2,a3,a4,a5,a6,a7,a8){try{Module["dynCall_viiiiiidi"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_viiiiiidi(index,a1,a2,a3,a4,a5,a6,a7,a8){Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6,a7,a8)}function invoke_dii(index,a1,a2){try{return Module["dynCall_dii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_dii(index,a1,a2){return Runtime.functionPointers[index](a1,a2)}function invoke_i(index){try{return Module["dynCall_i"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_i(index){return Runtime.functionPointers[index]()}function invoke_iiiid(index,a1,a2,a3,a4){try{return Module["dynCall_iiiid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiiid(index,a1,a2,a3,a4){return Runtime.functionPointers[index](a1,a2,a3,a4)}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiiii(index,a1,a2,a3,a4){return Runtime.functionPointers[index](a1,a2,a3,a4)}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_viii(index,a1,a2,a3){Runtime.functionPointers[index](a1,a2,a3)}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_v(index){Runtime.functionPointers[index]()}function invoke_iiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_iiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){return Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6,a7,a8)}function invoke_iiiiid(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiid"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_iiiiid(index,a1,a2,a3,a4,a5){return Runtime.functionPointers[index](a1,a2,a3,a4,a5)}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function jsCall_viiii(index,a1,a2,a3,a4){Runtime.functionPointers[index](a1,a2,a3,a4)}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_iiiiiiii":invoke_iiiiiiii,"jsCall_iiiiiiii":jsCall_iiiiiiii,"invoke_iiiiiid":invoke_iiiiiid,"jsCall_iiiiiid":jsCall_iiiiiid,"invoke_viiiii":invoke_viiiii,"jsCall_viiiii":jsCall_viiiii,"invoke_vi":invoke_vi,"jsCall_vi":jsCall_vi,"invoke_vii":invoke_vii,"jsCall_vii":jsCall_vii,"invoke_iiiiiii":invoke_iiiiiii,"jsCall_iiiiiii":jsCall_iiiiiii,"invoke_ii":invoke_ii,"jsCall_ii":jsCall_ii,"invoke_idddddddd":invoke_idddddddd,"jsCall_idddddddd":jsCall_idddddddd,"invoke_iiiiiiiiiiii":invoke_iiiiiiiiiiii,"jsCall_iiiiiiiiiiii":jsCall_iiiiiiiiiiii,"invoke_vidd":invoke_vidd,"jsCall_vidd":jsCall_vidd,"invoke_iiii":invoke_iiii,"jsCall_iiii":jsCall_iiii,"invoke_viiiiiiiiiiiiiii":invoke_viiiiiiiiiiiiiii,"jsCall_viiiiiiiiiiiiiii":jsCall_viiiiiiiiiiiiiii,"invoke_viiiiii":invoke_viiiiii,"jsCall_viiiiii":jsCall_viiiiii,"invoke_diiii":invoke_diiii,"jsCall_diiii":jsCall_diiii,"invoke_iidiid":invoke_iidiid,"jsCall_iidiid":jsCall_iidiid,"invoke_viddd":invoke_viddd,"jsCall_viddd":jsCall_viddd,"invoke_di":invoke_di,"jsCall_di":jsCall_di,"invoke_iiiiidddddddd":invoke_iiiiidddddddd,"jsCall_iiiiidddddddd":jsCall_iiiiidddddddd,"invoke_viiiiiii":invoke_viiiiiii,"jsCall_viiiiiii":jsCall_viiiiiii,"invoke_iiddd":invoke_iiddd,"jsCall_iiddd":jsCall_iiddd,"invoke_viiiiiiiii":invoke_viiiiiiiii,"jsCall_viiiiiiiii":jsCall_viiiiiiiii,"invoke_viiiiiiiiii":invoke_viiiiiiiiii,"jsCall_viiiiiiiiii":jsCall_viiiiiiiiii,"invoke_iii":invoke_iii,"jsCall_iii":jsCall_iii,"invoke_iiiiii":invoke_iiiiii,"jsCall_iiiiii":jsCall_iiiiii,"invoke_diii":invoke_diii,"jsCall_diii":jsCall_diii,"invoke_iiiidddddddddddddddd":invoke_iiiidddddddddddddddd,"jsCall_iiiidddddddddddddddd":jsCall_iiiidddddddddddddddd,"invoke_viiiiiidi":invoke_viiiiiidi,"jsCall_viiiiiidi":jsCall_viiiiiidi,"invoke_dii":invoke_dii,"jsCall_dii":jsCall_dii,"invoke_i":invoke_i,"jsCall_i":jsCall_i,"invoke_iiiid":invoke_iiiid,"jsCall_iiiid":jsCall_iiiid,"invoke_iiiii":invoke_iiiii,"jsCall_iiiii":jsCall_iiiii,"invoke_viii":invoke_viii,"jsCall_viii":jsCall_viii,"invoke_v":invoke_v,"jsCall_v":jsCall_v,"invoke_iiiiiiiii":invoke_iiiiiiiii,"jsCall_iiiiiiiii":jsCall_iiiiiiiii,"invoke_iiiiid":invoke_iiiiid,"jsCall_iiiiid":jsCall_iiiiid,"invoke_viiii":invoke_viiii,"jsCall_viiii":jsCall_viiii,"_fabs":_fabs,"_pthread_cleanup_pop":_pthread_cleanup_pop,"_pthread_cond_wait":_pthread_cond_wait,"___lock":___lock,"floatReadValueFromPointer":floatReadValueFromPointer,"simpleReadValueFromPointer":simpleReadValueFromPointer,"_sqrtf":_sqrtf,"__embind_register_memory_view":__embind_register_memory_view,"throwInternalError":throwInternalError,"get_first_emval":get_first_emval,"_abort":_abort,"___cxa_guard_acquire":___cxa_guard_acquire,"___setErrNo":___setErrNo,"___gxx_personality_v0":___gxx_personality_v0,"__embind_register_integer":__embind_register_integer,"_fabsf":_fabsf,"___assert_fail":___assert_fail,"___cxa_free_exception":___cxa_free_exception,"___cxa_allocate_exception":___cxa_allocate_exception,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"extendError":extendError,"getShiftFromSize":getShiftFromSize,"__embind_register_emval":__embind_register_emval,"__addDays":__addDays,"_strftime_l":_strftime_l,"throwBindingError":throwBindingError,"_emscripten_set_main_loop_timing":_emscripten_set_main_loop_timing,"_llvm_eh_typeid_for":_llvm_eh_typeid_for,"_sbrk":_sbrk,"__embind_register_void":__embind_register_void,"_emscripten_memcpy_big":_emscripten_memcpy_big,"___cxa_end_catch":___cxa_end_catch,"__embind_register_bool":__embind_register_bool,"___resumeException":___resumeException,"___cxa_find_matching_catch":___cxa_find_matching_catch,"_sysconf":_sysconf,"_embind_repr":_embind_repr,"___cxa_begin_catch":___cxa_begin_catch,"_strftime":_strftime,"createNamedFunction":createNamedFunction,"__emval_register":__emval_register,"embind_init_charCodes":embind_init_charCodes,"readLatin1String":readLatin1String,"_pthread_self":_pthread_self,"___cxa_call_unexpected":___cxa_call_unexpected,"__emval_decref":__emval_decref,"_pthread_once":_pthread_once,"_pthread_mutex_unlock":_pthread_mutex_unlock,"_pthread_getspecific":_pthread_getspecific,"___cxa_guard_abort":___cxa_guard_abort,"__embind_register_float":__embind_register_float,"_floorf":_floorf,"makeLegalFunctionName":makeLegalFunctionName,"whenDependentTypesAreResolved":whenDependentTypesAreResolved,"___syscall54":___syscall54,"___unlock":___unlock,"__embind_register_std_wstring":__embind_register_std_wstring,"init_emval":init_emval,"__isLeapYear":__isLeapYear,"_emscripten_set_main_loop":_emscripten_set_main_loop,"___cxa_guard_release":___cxa_guard_release,"_pthread_setspecific":_pthread_setspecific,"___cxa_atexit":___cxa_atexit,"integerReadValueFromPointer":integerReadValueFromPointer,"registerType":registerType,"___cxa_throw":___cxa_throw,"_pthread_cond_broadcast":_pthread_cond_broadcast,"___cxa_rethrow":___cxa_rethrow,"__arraySum":__arraySum,"___syscall6":___syscall6,"_pthread_cleanup_push":_pthread_cleanup_push,"count_emval_handles":count_emval_handles,"_time":_time,"_pthread_mutex_lock":_pthread_mutex_lock,"_pthread_key_create":_pthread_key_create,"_atexit":_atexit,"___syscall140":___syscall140,"__embind_register_std_string":__embind_register_std_string,"___cxa_pure_virtual":___cxa_pure_virtual,"___syscall146":___syscall146,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8,"___dso_handle":___dso_handle};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env.___dso_handle|0;var o=0;var p=0;var q=0;var r=0;var s=global.NaN,t=global.Infinity;var u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0.0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=global.Math.floor;var O=global.Math.abs;var P=global.Math.sqrt;var Q=global.Math.pow;var R=global.Math.cos;var S=global.Math.sin;var T=global.Math.tan;var U=global.Math.acos;var V=global.Math.asin;var W=global.Math.atan;var X=global.Math.atan2;var Y=global.Math.exp;var Z=global.Math.log;var _=global.Math.ceil;var $=global.Math.imul;var aa=global.Math.min;var ba=global.Math.clz32;var ca=env.abort;var da=env.assert;var ea=env.invoke_iiiiiiii;var fa=env.jsCall_iiiiiiii;var ga=env.invoke_iiiiiid;var ha=env.jsCall_iiiiiid;var ia=env.invoke_viiiii;var ja=env.jsCall_viiiii;var ka=env.invoke_vi;var la=env.jsCall_vi;var ma=env.invoke_vii;var na=env.jsCall_vii;var oa=env.invoke_iiiiiii;var pa=env.jsCall_iiiiiii;var qa=env.invoke_ii;var ra=env.jsCall_ii;var sa=env.invoke_idddddddd;var ta=env.jsCall_idddddddd;var ua=env.invoke_iiiiiiiiiiii;var va=env.jsCall_iiiiiiiiiiii;var wa=env.invoke_vidd;var xa=env.jsCall_vidd;var ya=env.invoke_iiii;var za=env.jsCall_iiii;var Aa=env.invoke_viiiiiiiiiiiiiii;var Ba=env.jsCall_viiiiiiiiiiiiiii;var Ca=env.invoke_viiiiii;var Da=env.jsCall_viiiiii;var Ea=env.invoke_diiii;var Fa=env.jsCall_diiii;var Ga=env.invoke_iidiid;var Ha=env.jsCall_iidiid;var Ia=env.invoke_viddd;var Ja=env.jsCall_viddd;var Ka=env.invoke_di;var La=env.jsCall_di;var Ma=env.invoke_iiiiidddddddd;var Na=env.jsCall_iiiiidddddddd;var Oa=env.invoke_viiiiiii;var Pa=env.jsCall_viiiiiii;var Qa=env.invoke_iiddd;var Ra=env.jsCall_iiddd;var Sa=env.invoke_viiiiiiiii;var Ta=env.jsCall_viiiiiiiii;var Ua=env.invoke_viiiiiiiiii;var Va=env.jsCall_viiiiiiiiii;var Wa=env.invoke_iii;var Xa=env.jsCall_iii;var Ya=env.invoke_iiiiii;var Za=env.jsCall_iiiiii;var _a=env.invoke_diii;var $a=env.jsCall_diii;var ab=env.invoke_iiiidddddddddddddddd;var bb=env.jsCall_iiiidddddddddddddddd;var cb=env.invoke_viiiiiidi;var db=env.jsCall_viiiiiidi;var eb=env.invoke_dii;var fb=env.jsCall_dii;var gb=env.invoke_i;var hb=env.jsCall_i;var ib=env.invoke_iiiid;var jb=env.jsCall_iiiid;var kb=env.invoke_iiiii;var lb=env.jsCall_iiiii;var mb=env.invoke_viii;var nb=env.jsCall_viii;var ob=env.invoke_v;var pb=env.jsCall_v;var qb=env.invoke_iiiiiiiii;var rb=env.jsCall_iiiiiiiii;var sb=env.invoke_iiiiid;var tb=env.jsCall_iiiiid;var ub=env.invoke_viiii;var vb=env.jsCall_viiii;var wb=env._fabs;var xb=env._pthread_cleanup_pop;var yb=env._pthread_cond_wait;var zb=env.___lock;var Ab=env.floatReadValueFromPointer;var Bb=env.simpleReadValueFromPointer;var Cb=env._sqrtf;var Db=env.__embind_register_memory_view;var Eb=env.throwInternalError;var Fb=env.get_first_emval;var Gb=env._abort;var Hb=env.___cxa_guard_acquire;var Ib=env.___setErrNo;var Jb=env.___gxx_personality_v0;var Kb=env.__embind_register_integer;var Lb=env._fabsf;var Mb=env.___assert_fail;var Nb=env.___cxa_free_exception;var Ob=env.___cxa_allocate_exception;var Pb=env.__ZSt18uncaught_exceptionv;var Qb=env.extendError;var Rb=env.getShiftFromSize;var Sb=env.__embind_register_emval;var Tb=env.__addDays;var Ub=env._strftime_l;var Vb=env.throwBindingError;var Wb=env._emscripten_set_main_loop_timing;var Xb=env._llvm_eh_typeid_for;var Yb=env._sbrk;var Zb=env.__embind_register_void;var _b=env._emscripten_memcpy_big;var $b=env.___cxa_end_catch;var ac=env.__embind_register_bool;var bc=env.___resumeException;var cc=env.___cxa_find_matching_catch;var dc=env._sysconf;var ec=env._embind_repr;var fc=env.___cxa_begin_catch;var gc=env._strftime;var hc=env.createNamedFunction;var ic=env.__emval_register;var jc=env.embind_init_charCodes;var kc=env.readLatin1String;var lc=env._pthread_self;var mc=env.___cxa_call_unexpected;var nc=env.__emval_decref;var oc=env._pthread_once;var pc=env._pthread_mutex_unlock;var qc=env._pthread_getspecific;var rc=env.___cxa_guard_abort;var sc=env.__embind_register_float;var tc=env._floorf;var uc=env.makeLegalFunctionName;var vc=env.whenDependentTypesAreResolved;var wc=env.___syscall54;var xc=env.___unlock;var yc=env.__embind_register_std_wstring;var zc=env.init_emval;var Ac=env.__isLeapYear;var Bc=env._emscripten_set_main_loop;var Cc=env.___cxa_guard_release;var Dc=env._pthread_setspecific;var Ec=env.___cxa_atexit;var Fc=env.integerReadValueFromPointer;var Gc=env.registerType;var Hc=env.___cxa_throw;var Ic=env._pthread_cond_broadcast;var Jc=env.___cxa_rethrow;var Kc=env.__arraySum;var Lc=env.___syscall6;var Mc=env._pthread_cleanup_push;var Nc=env.count_emval_handles;var Oc=env._time;var Pc=env._pthread_mutex_lock;var Qc=env._pthread_key_create;var Rc=env._atexit;var Sc=env.___syscall140;var Tc=env.__embind_register_std_string;var Uc=env.___cxa_pure_virtual;var Vc=env.___syscall146;var Wc=0.0;
// EMSCRIPTEN_START_FUNCS
function Po(a){a=a|0;return c[a+8>>2]|0}function Qo(a){a=a|0;return c[a+12>>2]|0}function Ro(a){a=a|0;return c[a+28>>2]|0}function So(a){a=a|0;return (c[a+8>>2]<<2)+17|0}function To(a,b){a=a|0;b=b|0;b=to(b)|0;return c[(c[a+16>>2]|0)+(b<<2)>>2]|0}function Uo(a){a=a|0;var b=0,c=0;do if(((a|0)%4|0|0)==1){o=0;a=qa(189,a+-17>>2|0)|0;c=o;o=0;if(!(c&1))return a|0;a=cc(240)|0;c=D;if((c|0)==(Xb(240)|0)){fc(a|0)|0;a=Ob(8)|0;o=0;ka(308,a|0);c=o;o=0;if(c&1){c=cc()|0;Nb(a|0);a=c}else{o=0;mb(55,a|0,320,76);o=0;a=cc()|0}o=0;ob(44);c=o;o=0;if(c&1){c=cc(0)|0;oq(c)}else b=a}else b=a}else{a=Ob(8)|0;o=0;ka(308,a|0);c=o;o=0;if(c&1){b=cc()|0;Nb(a|0);break}else Hc(a|0,320,76)}while(0);bc(b|0);return 0}function Vo(a){a=a|0;if((a|0)<1|(c[8619]|0)<(a|0)){a=Ob(8)|0;zq(a,50292);c[a>>2]=29736;Hc(a|0,24,146)}else return c[(c[7175]|0)+(a+-1<<2)>>2]|0;return 0}function Wo(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0;c[a+4>>2]=0;c[a>>2]=28720;c[a+8>>2]=b;c[a+12>>2]=d;b=a+16|0;Qt(b,4);i=a+28|0;c[i>>2]=0;c[c[b>>2]>>2]=e;c[(c[b>>2]|0)+4>>2]=f;c[(c[b>>2]|0)+8>>2]=g;c[(c[b>>2]|0)+12>>2]=h;f=c[e>>2]|0;g=c[e+4>>2]|0;a=(c[e+8>>2]|0)-g>>2;if(!a)d=0;else{b=0;d=0;do{e=c[g+(b<<2)>>2]|0;d=($((c[e+4>>2]|0)+f|0,c[e>>2]|0)|0)+d|0;b=b+1|0}while((b|0)!=(a|0))}c[i>>2]=d;return}function Xo(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=28720;b=c[a+12>>2]|0;if(b){br(b);Uz(b)}e=a+16|0;d=a+20|0;b=c[e>>2]|0;if((c[d>>2]|0)!=(b|0)){a=0;do{b=c[b+(a<<2)>>2]|0;if(b){No(b);Uz(b)}a=a+1|0;b=c[e>>2]|0}while(a>>>0<(c[d>>2]|0)-b>>2>>>0)}Rt(e);return}function Yo(a){a=a|0;Xo(a);Uz(a);return}function Zo(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;do if((c[7174]|0)>0){d=2147483647;f=0;b=0;while(1){e=c[28560+(b<<2)>>2]|0;if((e|0)==(a|0)){e=3;break}e=zo(a,e)|0;g=(e|0)<(d|0);f=g?b+7|0:f;d=g?e:d;b=b+1|0;if((b|0)>=(c[7174]|0)){b=f;e=5;break}}if((e|0)==3){b=Vo(b+7|0)|0;break}else if((e|0)==5){d=(d|0)<4;e=6;break}}else{d=0;b=0;e=6}while(0);if((e|0)==6)if(d)b=Vo(b)|0;else b=0;return b|0}function _o(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;r=i;i=i+16|0;s=r;m=a+8|0;n=c[m>>2]<<2;b=Sz(32)|0;o=0;ma(110,b|0,n+17|0);p=o;o=0;if(p&1){s=cc()|0;Uz(b);b=s}else{c[s>>2]=0;Ke(s,b);p=c[s>>2]|0;o=0;ia(54,p|0,0,0,9,9);l=o;o=0;a:do if((!(l&1)?(d=n+9|0,o=0,ia(54,p|0,d|0,0,8,9),l=o,o=0,!(l&1)):0)?(o=0,ia(54,p|0,0,d|0,9,8),l=o,o=0,!(l&1)):0){b=a+12|0;d=c[b>>2]|0;d=(c[d+4>>2]|0)-(c[d>>2]|0)>>2;a=d+-1|0;b:do if(d){e=(d|0)==0;k=0;c:while(1){f=(c[(c[c[b>>2]>>2]|0)+(k<<2)>>2]|0)+-2|0;g=(k|0)==0;h=(k|0)==(a|0);if(!e){l=0;do{j=(l|0)==0;if(g){if(!(j|(l|0)==(a|0)|h&(l|0)==0))q=15}else if(!(h&j))q=15;if((q|0)==15?(q=0,o=0,ia(54,p|0,(c[(c[c[b>>2]>>2]|0)+(l<<2)>>2]|0)+-2|0,f|0,5,5),j=o,o=0,j&1):0)break c;l=l+1|0}while(l>>>0<d>>>0)}k=k+1|0;if(k>>>0>=d>>>0)break b}b=cc()|0;break a}while(0);o=0;ia(54,p|0,6,9,1,n|0);q=o;o=0;if(!(q&1)?(o=0,ia(54,p|0,9,6,n|0,1),q=o,o=0,!(q&1)):0){if((c[m>>2]|0)>6){b=n+6|0;o=0;ia(54,p|0,b|0,0,3,6);q=o;o=0;if(q&1){q=13;break}o=0;ia(54,p|0,0,b|0,6,3);q=o;o=0;if(q&1){q=13;break}}i=r;return p|0}else q=13}else q=13;while(0);if((q|0)==13)b=cc()|0;Yd(s)}bc(b|0);return 0}function $o(a){a=a|0;return}function ap(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;f=i;i=i+16|0;d=f+8|0;e=f;g=c[(c[a>>2]|0)+12>>2]|0;_d(d,b);$d(e,4500);o=0;b=ya(g|0,a|0,d|0,e|0)|0;a=o;o=0;if(a&1){g=cc()|0;ze(e+4|0);ce(d);bc(g|0)}else{ze(e+4|0);ce(d);i=f;return b|0}return 0}function bp(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[a+4>>2]=0;c[a>>2]=28736;Sq(a+8|0,b);Pd(a+12|0,d);oe(a+24|0,e);c[a+36>>2]=c[f>>2];return}function cp(a){a=a|0;c[a>>2]=28736;pe(a+24|0);Sd(a+12|0);ne(a+8|0);return}function dp(a){a=a|0;cp(a);Uz(a);return}function ep(a){a=a|0;var b=0,d=0;d=i;i=i+16|0;b=d;Sq(b,a+8|0);i=d;return c[b>>2]|0}function fp(a,b){a=a|0;b=b|0;Pd(a,b+12|0);return}function gp(a){a=a|0;return a+24|0}function hp(a){a=a|0;return c[a+36>>2]|0}function ip(a,b,d){a=a|0;b=+b;d=+d;c[a+4>>2]=0;c[a>>2]=28752;g[a+8>>2]=b;g[a+12>>2]=d;return}function jp(a){a=a|0;return}function kp(a){a=a|0;Uz(a);return}function lp(a){a=a|0;return +(+g[a+8>>2])}function mp(a){a=a|0;return +(+g[a+12>>2])}function np(a,b){a=a|0;b=b|0;var d=0,e=0.0;e=+g[a+8>>2];d=c[b>>2]|0;if(e==+ld[c[(c[d>>2]|0)+8>>2]&63](d)){e=+g[a+12>>2];b=c[b>>2]|0;b=e==+ld[c[(c[b>>2]|0)+12>>2]&63](b)}else b=0;return b|0}function op(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,g=0.0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0;r=i;i=i+32|0;n=r+24|0;p=r+20|0;q=r+16|0;j=r+12|0;k=r+8|0;l=r+4|0;m=r;h=c[c[a>>2]>>2]|0;t=+ld[c[(c[h>>2]|0)+8>>2]&63](h);h=c[(c[a>>2]|0)+4>>2]|0;s=+ld[c[(c[h>>2]|0)+8>>2]&63](h);h=c[c[a>>2]>>2]|0;e=+ld[c[(c[h>>2]|0)+12>>2]&63](h);h=c[(c[a>>2]|0)+4>>2]|0;s=t-s;e=e-+ld[c[(c[h>>2]|0)+12>>2]&63](h);e=+P(+(s*s+e*e));h=c[(c[a>>2]|0)+4>>2]|0;s=+ld[c[(c[h>>2]|0)+8>>2]&63](h);h=c[(c[a>>2]|0)+8>>2]|0;t=+ld[c[(c[h>>2]|0)+8>>2]&63](h);h=c[(c[a>>2]|0)+4>>2]|0;f=+ld[c[(c[h>>2]|0)+12>>2]&63](h);h=c[(c[a>>2]|0)+8>>2]|0;t=s-t;f=f-+ld[c[(c[h>>2]|0)+12>>2]&63](h);f=+P(+(t*t+f*f));h=c[c[a>>2]>>2]|0;t=+ld[c[(c[h>>2]|0)+8>>2]&63](h);h=c[(c[a>>2]|0)+8>>2]|0;s=+ld[c[(c[h>>2]|0)+8>>2]&63](h);h=c[c[a>>2]>>2]|0;g=+ld[c[(c[h>>2]|0)+12>>2]&63](h);h=c[(c[a>>2]|0)+8>>2]|0;s=t-s;g=g-+ld[c[(c[h>>2]|0)+12>>2]&63](h);g=+P(+(s*s+g*g));c[n>>2]=0;vq(n,0);c[p>>2]=0;vq(p,0);c[q>>2]=0;vq(q,0);do if(!(f>=e)|!(f>=g)){b=c[a>>2]|0;if(!(g>=f)|!(g>=e)){vq(p,c[b+8>>2]|0);vq(n,c[c[a>>2]>>2]|0);vq(q,c[(c[a>>2]|0)+4>>2]|0);break}else{vq(p,c[b+4>>2]|0);vq(n,c[c[a>>2]>>2]|0);vq(q,c[(c[a>>2]|0)+8>>2]|0);break}}else{vq(p,c[c[a>>2]>>2]|0);vq(n,c[(c[a>>2]|0)+4>>2]|0);vq(q,c[(c[a>>2]|0)+8>>2]|0)}while(0);c[j>>2]=0;d=c[n>>2]|0;vq(j,d);c[k>>2]=0;h=c[p>>2]|0;vq(k,h);c[l>>2]=0;b=c[q>>2]|0;vq(l,b);o=0;e=+_a(43,j|0,k|0,l|0);u=o;o=0;if(u&1){u=cc()|0;uq(l);uq(k);uq(j);uq(q);uq(p);uq(n);bc(u|0)}uq(l);uq(k);uq(j);if(e<0.0){c[m>>2]=0;vq(m,d);vq(n,b);vq(q,c[m>>2]|0);uq(m);d=c[n>>2]|0;b=c[q>>2]|0}vq(c[a>>2]|0,d);vq((c[a>>2]|0)+4|0,h);vq((c[a>>2]|0)+8|0,b);uq(q);uq(p);uq(n);i=r;return}function pp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,g=0.0,h=0;h=c[b>>2]|0;e=+ld[c[(c[h>>2]|0)+8>>2]&63](h);b=c[b>>2]|0;f=+ld[c[(c[b>>2]|0)+12>>2]&63](b);b=c[d>>2]|0;g=+ld[c[(c[b>>2]|0)+8>>2]&63](b)-e;b=c[a>>2]|0;g=g*(+ld[c[(c[b>>2]|0)+12>>2]&63](b)-f);d=c[d>>2]|0;f=+ld[c[(c[d>>2]|0)+12>>2]&63](d)-f;d=c[a>>2]|0;return +(g-f*(+ld[c[(c[d>>2]|0)+8>>2]&63](d)-e))}function qp(a,b){a=a|0;b=b|0;var d=0.0,e=0.0;a=c[a>>2]|0;b=c[b>>2]|0;e=+g[a+8>>2]-+g[b+8>>2];d=+g[a+12>>2]-+g[b+12>>2];return +(+P(+(e*e+d*d)))}function rp(a,b){a=a|0;b=b|0;if((a|0)!=(b|0)){c[a>>2]=c[b>>2];St(a+4|0,b+4|0)}return}function sp(a,b){a=a|0;b=b|0;c[a>>2]=(b|0)==0?0:(b|0)>0?1:-1;xp(a+4|0,(b|0)<0?0-b|0:b);return}function tp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=i;i=i+32|0;e=h+16|0;g=h;a:do if((a|0)==(b|0)|(a|0)==(d|0)){c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;o=0;mb(105,e|0,b|0,d|0);d=o;o=0;if(!(d&1)?(o=0,ma(155,a|0,e|0),a=o,o=0,!(a&1)):0){Ds(e+4|0);f=18;break}f=cc()|0;Ds(e+4|0);e=f;f=19}else{e=c[b>>2]|0;if(!e){rp(a,d);f=18;break}f=c[d>>2]|0;if(!f){rp(a,b);f=18;break}if((e|0)==(f|0)){c[a>>2]=e;Cp(a+4|0,b+4|0,d+4|0);f=18;break}e=b+4|0;f=d+4|0;switch(Bp(e,f)|0){case 0:{zp(g,0);o=0;ma(186,a+4|0,g|0);d=o;o=0;if(d&1){e=cc()|0;Ds(g);f=19;break a}else{Ds(g);c[a>>2]=0;f=18;break a}}case 1:{c[a>>2]=c[b>>2];Dp(a+4|0,e,f);f=18;break a}case -1:{c[a>>2]=c[d>>2];Dp(a+4|0,f,e);f=18;break a}default:{f=18;break a}}}while(0);if((f|0)==18){i=h;return}else if((f|0)==19)bc(e|0)}function up(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=i;i=i+32|0;e=h+16|0;f=h;do if(!((a|0)==(b|0)|(a|0)==(d|0))){e=c[b>>2]|0;if((e|0)!=0?(g=c[d>>2]|0,(g|0)!=0):0){c[a>>2]=(e|0)==(g|0)?1:-1;Ep(a+4|0,b+4|0,d+4|0);f=12;break}c[a>>2]=0;zp(f,0);o=0;ma(186,a+4|0,f|0);a=o;o=0;if(a&1){e=cc()|0;Ds(f);f=13;break}else{Ds(f);f=12;break}}else{c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;o=0;mb(106,e|0,b|0,d|0);d=o;o=0;if(!(d&1)?(o=0,ma(155,a|0,e|0),a=o,o=0,!(a&1)):0){Ds(e+4|0);f=12;break}f=cc()|0;Ds(e+4|0);e=f;f=13}while(0);if((f|0)==12){i=h;return}else if((f|0)==13)bc(e|0)}function vp(a,b){a=a|0;b=b|0;var c=0,d=0;d=i;i=i+16|0;c=d;Gp(c,b,10);o=0;ma(187,a|0,c|0);b=o;o=0;if(b&1){d=cc()|0;Vt(c);bc(d|0)}else{Vt(c);i=d;return}}function wp(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;g=i;i=i+32|0;f=g+12|0;e=g;a:do if((c[d>>2]|0)!=-1){o=0;ma(188,b|0,d+4|0);f=o;o=0;if(f&1){d=cc()|0;e=11}else e=6}else{FC(f,52976,1);o=0;ma(188,e|0,d+4|0);d=o;o=0;do if(!(d&1)){d=a[e>>0]|0;h=(d&1)==0;o=0;d=ya(90,f|0,(h?e+1|0:c[e+8>>2]|0)|0,(h?(d&255)>>>1:c[e+4>>2]|0)|0)|0;h=o;o=0;if(h&1){d=cc()|0;IC(e);break}else{c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;IC(e);IC(f);e=6;break a}}else d=cc()|0;while(0);IC(f);e=11}while(0);if((e|0)==6){i=g;return}else if((e|0)==11)bc(d|0)}function xp(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;o=0;ma(189,a|0,b|0);b=o;o=0;if(b&1){b=cc()|0;Ds(a);bc(b|0)}else return}function yp(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;o=0;ma(190,a|0,b|0);b=o;o=0;if(b&1){b=cc()|0;Ds(a);bc(b|0)}else return}function zp(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;o=0;ma(191,a|0,b|0);b=o;o=0;if(b&1){b=cc()|0;Ds(a);bc(b|0)}else return}function Ap(a){a=a|0;return Zt(a)|0}function Bp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=c[a+4>>2]|0;d=c[b+4>>2]|0;a:do if(e>>>0>=d>>>0)if(e>>>0>d>>>0)d=1;else{f=a+8|0;b=c[b+8>>2]|0;do{if(!e){d=0;break a}e=e+-1|0;a=c[(c[f>>2]|0)+(e<<2)>>2]|0;d=c[b+(e<<2)>>2]|0}while((a|0)==(d|0));d=a>>>0>d>>>0?1:-1}else d=-1;while(0);return d|0}function Cp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0;p=i;i=i+16|0;e=p;do if(!((a|0)==(b|0)|(a|0)==(d|0))){e=c[b+4>>2]|0;if(!e){St(a,d);break}f=c[d+4>>2]|0;if(!f){St(a,b);break}e=e>>>0<f>>>0;l=e?d:b;e=e?b:d;k=l+4|0;f=(c[k>>2]|0)+1|0;n=a+4|0;c[n>>2]=f;au(a,f);f=c[e+4>>2]|0;l=l+8|0;m=a+8|0;if(!f)e=0;else{j=c[l>>2]|0;a=c[e+8>>2]|0;g=c[m>>2]|0;d=0;h=0;while(1){e=c[j+(h<<2)>>2]|0;b=(c[a+(h<<2)>>2]|0)+e|0;e=b>>>0<e>>>0;if(d){b=b+1|0;e=((b|0)==0|e&1|0)!=0}c[g+(h<<2)>>2]=b;h=h+1|0;if((h|0)==(f|0))break;else d=e}}h=c[k>>2]|0;if(e&f>>>0<h>>>0){b=c[l>>2]|0;d=c[m>>2]|0;do{k=(c[b+(f<<2)>>2]|0)+1|0;e=(k|0)==0;c[d+(f<<2)>>2]=k;f=f+1|0}while(e&f>>>0<h>>>0)}g=f>>>0>h>>>0;if(f>>>0<h>>>0){b=c[l>>2]|0;d=c[m>>2]|0;a=f;do{c[d+(a<<2)>>2]=c[b+(a<<2)>>2];a=a+1|0}while(a>>>0<h>>>0)}if(e){c[(c[m>>2]|0)+((g?f:h)<<2)>>2]=1;break}else{c[n>>2]=(c[n>>2]|0)+-1;break}}else{c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;o=0;mb(107,e|0,b|0,d|0);n=o;o=0;if(!(n&1)?(o=0,ma(186,a|0,e|0),n=o,o=0,!(n&1)):0){Ds(e);break}p=cc()|0;Ds(e);bc(p|0)}while(0);i=p;return}function Dp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;r=i;i=i+16|0;e=r;do if((a|0)==(b|0)|(a|0)==(d|0)){c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;o=0;mb(108,e|0,b|0,d|0);q=o;o=0;if(!(q&1)?(o=0,ma(186,a|0,e|0),a=o,o=0,!(a&1)):0){Ds(e);break}r=cc()|0;Ds(e);bc(r|0)}else{f=d+4|0;e=c[f>>2]|0;if(!e){St(a,b);break}m=b+4|0;g=c[m>>2]|0;if(g>>>0<e>>>0){r=Ob(4)|0;c[r>>2]=50331;Hc(r|0,1952,0)}q=a+4|0;c[q>>2]=g;au(a,g);e=c[f>>2]|0;p=c[b+8>>2]|0;j=c[d+8>>2]|0;n=a+8|0;if(!e)f=0;else{k=c[n>>2]|0;h=0;l=0;while(1){b=c[p+(l<<2)>>2]|0;d=c[j+(l<<2)>>2]|0;g=b-d|0;f=g>>>0>b>>>0;if(h){f=(f&1|(b|0)==(d|0)|0)!=0;g=g+-1|0}c[k+(l<<2)>>2]=g;l=l+1|0;if((l|0)==(e|0))break;else h=f}}b=c[m>>2]|0;if(f&e>>>0<b>>>0){g=c[n>>2]|0;do{m=c[p+(e<<2)>>2]|0;f=(m|0)==0;c[g+(e<<2)>>2]=m+-1;e=e+1|0}while(f&e>>>0<b>>>0)}if(f){c[q>>2]=0;r=Ob(4)|0;c[r>>2]=50331;Hc(r|0,1952,0)}if(e>>>0<b>>>0){f=c[n>>2]|0;do{c[f+(e<<2)>>2]=c[p+(e<<2)>>2];e=e+1|0}while(e>>>0<b>>>0)}_t(a)}while(0);i=r;return}function Ep(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;s=i;i=i+16|0;e=s;do if((a|0)==(b|0)|(a|0)==(d|0)){c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;o=0;mb(109,e|0,b|0,d|0);d=o;o=0;if(!(d&1)?(o=0,ma(186,a|0,e|0),d=o,o=0,!(d&1)):0){Ds(e);break}s=cc()|0;Ds(e);bc(s|0)}else{q=b+4|0;e=c[q>>2]|0;if((e|0)!=0?(r=d+4|0,f=c[r>>2]|0,(f|0)!=0):0){m=f+e|0;p=a+4|0;c[p>>2]=m;au(a,m);m=c[p>>2]|0;n=a+8|0;if(m){e=c[n>>2]|0;f=0;do{c[e+(f<<2)>>2]=0;f=f+1|0}while((f|0)!=(m|0))}j=b+8|0;if(c[q>>2]|0){k=0;do{l=0;do{if(c[(c[j>>2]|0)+(k<<2)>>2]&1<<l){b=0;h=0;e=k;while(1){g=(c[n>>2]|0)+(e<<2)|0;a=c[g>>2]|0;f=(bu(d,h,l)|0)+a|0;a=f>>>0<a>>>0;if(b){f=f+1|0;a=((f|0)==0|a&1|0)!=0}c[g>>2]=f;h=h+1|0;e=e+1|0;if(h>>>0>(c[r>>2]|0)>>>0)break;else b=a}if(a){f=c[n>>2]|0;while(1){g=f+(e<<2)|0;h=(c[g>>2]|0)+1|0;c[g>>2]=h;if(!h)e=e+1|0;else break}}}l=l+1|0}while((l|0)!=32);k=k+1|0}while(k>>>0<(c[q>>2]|0)>>>0)}e=m+-1|0;if(c[(c[n>>2]|0)+(e<<2)>>2]|0)break;c[p>>2]=e;break}c[a+4>>2]=0}while(0);i=s;return}function Fp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+16|0;e=x;if((a|0)==(d|0)){x=Ob(4)|0;c[x>>2]=50394;Hc(x|0,1952,0)}do if((a|0)==(b|0)|(d|0)==(b|0)){Tt(e,b);o=0;mb(110,a|0,e|0,d|0);a=o;o=0;if(a&1){x=cc()|0;Ds(e);bc(x|0)}else{Ds(e);break}}else{w=b+4|0;f=c[w>>2]|0;if(!f){c[d+4>>2]=0;break}e=a+4|0;v=c[e>>2]|0;if(v>>>0<f>>>0){c[d+4>>2]=0;break}$t(a,v+1|0);t=(c[e>>2]|0)+1|0;c[e>>2]=t;q=a+8|0;c[(c[q>>2]|0)+(v<<2)>>2]=0;t=Tz(t>>>0>1073741823?-1:t<<2)|0;r=v-(c[w>>2]|0)+1|0;u=d+4|0;c[u>>2]=r;au(d,r);r=c[u>>2]|0;s=c[d+8>>2]|0;if(r){e=0;do{c[s+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=(r|0))}if(r){n=r;do{n=n+-1|0;m=s+(n<<2)|0;c[m>>2]=0;p=32;do{p=p+-1|0;k=c[w>>2]|0;j=0;l=0;d=n;while(1){g=c[(c[q>>2]|0)+(d<<2)>>2]|0;h=bu(b,l,p)|0;f=g-h|0;e=f>>>0>g>>>0;if(j){e=(e&1|(g|0)==(h|0)|0)!=0;f=f+-1|0}c[t+(d<<2)>>2]=f;l=l+1|0;d=d+1|0;if(l>>>0>k>>>0)break;else j=e}if(d>>>0<v>>>0&e){f=c[q>>2]|0;do{l=c[f+(d<<2)>>2]|0;e=(l|0)==0;c[t+(d<<2)>>2]=l+-1;d=d+1|0}while(d>>>0<v>>>0&e)}if(!e?(c[m>>2]=c[m>>2]|1<<p,d>>>0>n>>>0):0){f=c[q>>2]|0;e=d;do{e=e+-1|0;c[f+(e<<2)>>2]=c[t+(e<<2)>>2]}while(e>>>0>n>>>0)}}while((p|0)!=0)}while((n|0)!=0)}e=r+-1|0;if(!(c[s+(e<<2)>>2]|0))c[u>>2]=e;_t(a);Vz(t)}while(0);i=x;return}function Gp(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0;n=i;i=i+48|0;q=n+24|0;p=n+12|0;l=n;c[a>>2]=0;m=a+4|0;c[m>>2]=0;k=a+8|0;c[k>>2]=0;if((e&65535)>=2){b[a+12>>1]=e;h=c[d+4>>2]|0;if(!(e<<16>>16))f=-1;else{g=e&65535;f=0;while(1){g=g>>>1;if(!g)break;else f=f+1|0}}h=(((h<<5)+-1+f|0)>>>0)/(f>>>0)|0;c[m>>2]=h;o=0;ma(192,a|0,h|0);h=o;o=0;if(!(h&1)?(o=0,ma(193,q|0,d|0),d=o,o=0,!(d&1)):0){o=0;ma(194,p|0,e|0);d=o;o=0;a:do if(d&1)f=cc()|0;else{h=q+4|0;b:do if(!(c[h>>2]|0))f=0;else{f=0;while(1){o=0;ma(193,l|0,q|0);j=o;o=0;if(j&1){j=16;break}o=0;mb(110,l|0,p|0,q|0);j=o;o=0;if(j&1){j=17;break}o=0;g=qa(190,l|0)|0;j=o;o=0;if(j&1){j=17;break}b[(c[k>>2]|0)+(f<<1)>>1]=g;f=f+1|0;Ds(l);if(!(c[h>>2]|0))break b}if((j|0)==16)f=cc()|0;else if((j|0)==17){f=cc()|0;Ds(l)}Ds(p);break a}while(0);c[m>>2]=f;Ds(p);Ds(q);i=n;return}while(0);Ds(q)}else j=3}else{j=Ob(4)|0;c[j>>2]=50487;o=0;mb(55,j|0,1952,0);o=0;j=3}if((j|0)==3)f=cc()|0;Vt(a);bc(f|0)}function Hp(d,f){d=d|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;k=l;if((e[f+12>>1]|0)>36){l=Ob(4)|0;c[l>>2]=50554;Hc(l|0,1952,0)}h=c[f+4>>2]|0;if(!h)FC(d,52905,1);else{j=Tz(h+1|0)|0;a[j+h>>0]=0;f=c[f+8>>2]|0;g=0;do{m=b[f+(h+~g<<1)>>1]|0;a[j+g>>0]=(m&65535)+((m&65535)<10?48:55);g=g+1|0}while((g|0)!=(h|0));FC(k,j,iC(j)|0);Vz(j);c[d>>2]=c[k>>2];c[d+4>>2]=c[k+4>>2];c[d+8>>2]=c[k+8>>2];c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;IC(k)}i=l;return}function Ip(){c[1062]=0;c[1063]=0;c[1061]=4248;Ec(326,4244,n|0)|0;c[1065]=0;c[1066]=0;c[1064]=4260;Ec(327,4256,n|0)|0;mg()|0;a[45587]=1;return}function Jp(){Rd(30580,0);Ec(44,30580,n|0)|0;return}function Kp(){var a=0,b=0;a=Sz(56)|0;o=0;ub(70,a|0,4201,4096,1);b=o;o=0;if(b&1){b=cc()|0;Uz(a);bc(b|0)}c[1088]=0;jq(4352,a);Ec(328,4352,n|0)|0;a=Sz(56)|0;o=0;ub(70,a|0,1033,1024,1);b=o;o=0;if(b&1){b=cc()|0;Uz(a);bc(b|0)}c[1089]=0;jq(4356,a);Ec(328,4356,n|0)|0;a=Sz(56)|0;o=0;ub(70,a|0,67,64,1);b=o;o=0;if(b&1){b=cc()|0;Uz(a);bc(b|0)}c[1090]=0;jq(4360,a);Ec(328,4360,n|0)|0;a=Sz(56)|0;o=0;ub(70,a|0,19,16,1);b=o;o=0;if(b&1){b=cc()|0;Uz(a);bc(b|0)}c[1091]=0;jq(4364,a);Ec(328,4364,n|0)|0;a=Sz(56)|0;o=0;ub(70,a|0,285,256,0);b=o;o=0;if(b&1){b=cc()|0;Uz(a);bc(b|0)}c[1092]=0;jq(4368,a);Ec(328,4368,n|0)|0;a=Sz(56)|0;o=0;ub(70,a|0,301,256,1);b=o;o=0;if(b&1){b=cc()|0;Uz(a);bc(b|0)}else{c[1093]=0;jq(4372,a);Ec(328,4372,n|0)|0;iq(4376,4372);Ec(328,4376,n|0)|0;iq(4380,4360);Ec(328,4380,n|0)|0;return}}function Lp(){c[1113]=0;c[1114]=0;c[1115]=0;Ec(329,4452,n|0)|0;c[7681]=Qi()|0;return}function Mp(){var a=0,b=0,c=0,d=0,e=0,f=0,g=0,h=0;a=i;i=i+64|0;g=a+48|0;e=a+40|0;c=a+32|0;b=a+24|0;d=a+16|0;f=a+8|0;h=a;bj(4484,106880);Ec(330,4484,n|0)|0;bj(g,572);$i(4492,g,4484);ze(g+4|0);Ec(330,4492,n|0)|0;bj(b,4096);$i(c,4492,b);bj(d,64);$i(e,c,d);bj(f,2);$i(g,e,f);bj(h,2048);$i(4500,g,h);ze(h+4|0);ze(g+4|0);ze(f+4|0);ze(e+4|0);ze(d+4|0);ze(c+4|0);ze(b+4|0);Ec(330,4500,n|0)|0;i=a;return}function Np(){FC(33384,48499,44);Ec(331,33384,n|0)|0;return}function Op(){FC(33768,48544,48);Ec(331,33768,n|0)|0;c[8393]=350;return}function Pp(){var a=0,b=0;a=Sz(20)|0;o=0;mb(111,a|0,35116,35160);b=o;o=0;if(b&1){b=cc()|0;Uz(a);bc(b|0)}else{Fq(33820,a);Ec(150,33820,n|0)|0;rz(33832,35160,35176);Ec(332,33832,n|0)|0;rz(33844,35176,35188);Ec(332,33844,n|0)|0;return}}function Qp(){rz(5128,34604,34616);Ec(332,5128,n|0)|0;rz(5140,34616,34636);Ec(332,5140,n|0)|0;sz(5152,34636,34796);Ec(333,5152,n|0)|0;sz(5164,34796,35116);Ec(333,5164,n|0)|0;return}function Rp(){rz(34160,34580,34604);Ec(332,34160,n|0)|0;return}function Sp(){Tl(27572);Ec(207,27572,n|0)|0;return}function Tp(){gm(27584,929,3);Ec(334,27584,n|0)|0;return}function Up(){Sm(27772);Ec(335,27772,n|0)|0;return}function Vp(){c[6952]=0;c[6953]=0;c[6954]=0;Ec(336,27808,n|0)|0;ln()|0;return}function Wp(){An(27820,0,0,0,0,53271);Ec(337,27820,n|0)|0;An(27844,10,12,14,0,53282);Ec(337,27844,n|0)|0;An(27868,9,11,13,0,53290);Ec(337,27868,n|0)|0;An(27892,0,0,0,0,53303);Ec(337,27892,n|0)|0;An(27916,8,16,16,0,53321);Ec(337,27916,n|0)|0;An(27940,0,0,0,0,53326);Ec(337,27940,n|0)|0;An(27964,8,10,12,0,53330);Ec(337,27964,n|0)|0;An(27988,0,0,0,0,53336);Ec(337,27988,n|0)|0;An(28012,0,0,0,0,53356);Ec(337,28012,n|0)|0;An(28036,8,10,12,0,53377);Ec(337,28036,n|0)|0;return}function Xp(){so(28112,0,1,61258);Ec(338,28112,n|0)|0;so(28132,1,0,53265);Ec(338,28132,n|0)|0;so(28152,2,3,53267);Ec(338,28152,n|0)|0;so(28172,3,2,53269);Ec(338,28172,n|0)|0;return}function Yp(){c[7175]=0;c[7176]=0;c[7177]=0;Ec(339,28700,n|0)|0;c[8619]=Oo()|0;return}function Zp(a,b){a=a|0;b=b|0;c[a>>2]=0;Ke(a,c[b>>2]|0);return}function _p(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function $p(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function aq(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function bq(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function cq(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function dq(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function eq(a,b,d){a=a|0;b=b|0;d=d|0;d=($(c[a+16>>2]|0,d)|0)+(b>>5)|0;return (c[(c[(c[a+28>>2]|0)+8>>2]|0)+(d<<2)>>2]&1<<(b&31)|0)!=0|0}function fq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;f=i;i=i+16|0;d=f;c[a>>2]=0;e=a+4|0;c[e>>2]=0;c[a+8>>2]=0;if(b){fz(a,b);g=c[e>>2]|0;c[e>>2]=g+b;c[d>>2]=(c[a>>2]|0)+(g>>>5<<2);c[d+4>>2]=g&31;gz(d,b)}i=f;return}function gq(a){a=a|0;var b=0;b=c[a>>2]|0;if(b){Uz(b);c[a>>2]=0;c[a+8>>2]=0;c[a+4>>2]=0}return}function hq(a){a=a|0;a=c[a>>2]|0;if(a)Uz(a);return}function iq(a,b){a=a|0;b=b|0;c[a>>2]=0;jq(a,c[b>>2]|0);return}function jq(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function kq(a,b){a=a|0;b=b|0;var d=0,e=0;c[a+4>>2]=0;c[a>>2]=29772;c[a+8>>2]=0;o=0;d=qa(111,20)|0;e=o;o=0;do if(!(e&1)){o=0;ma(102,d|0,b|0);e=o;o=0;if(e&1){e=cc()|0;Uz(d);d=e;break}else{Hq(a,d);return}}else d=cc()|0;while(0);bc(d|0)}function lq(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function mq(a,b){a=a|0;b=b|0;c[a+4>>2]=0;c[a>>2]=29772;c[a+8>>2]=0;Hq(a,c[b+8>>2]|0);return}function nq(a){a=a|0;var b=0;c[a>>2]=29772;a=a+8|0;b=c[a>>2]|0;if(b)ye(b);c[a>>2]=0;return}function oq(a){a=a|0;fc(a|0)|0;$z()}function pq(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function qq(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function rq(a,b){a=a|0;b=b|0;var d=0,e=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;d=b+4|0;e=(c[d>>2]|0)-(c[b>>2]|0)>>2;do if(e){o=0;ma(195,a|0,e|0);e=o;o=0;if(e&1){b=cc()|0;sq(a);bc(b|0)}else{ez(a,c[b>>2]|0,c[d>>2]|0);break}}while(0);return}function sq(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;qq(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function tq(a,b){a=a|0;b=b|0;c[a>>2]=0;vq(a,c[b>>2]|0);return}function uq(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function vq(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function wq(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;uq(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function xq(a){a=a|0;var b=0,d=0,e=0;e=i;i=i+16|0;b=e;d=Sz(16)|0;o=0;wa(42,d|0,+(+(c[a+8>>2]|0)),+(+(c[a+12>>2]|0)));a=o;o=0;if(a&1){e=cc()|0;Uz(d);bc(e|0)}else{c[b>>2]=0;vq(b,d);i=e;return c[b>>2]|0}return 0}function yq(a,b){a=a|0;b=b|0;c[a>>2]=0;pq(a,c[b>>2]|0);return}function zq(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=34536;o=0;b=qa(191,b|0)|0;d=o;o=0;if(d&1){d=cc()|0;mc(d|0)}else{c[a+4>>2]=b;return}}function Aq(a){a=a|0;c[a>>2]=34536;if((c[a+4>>2]|0)!=0?(o=0,ka(340,a|0),a=o,o=0,a&1):0){a=cc()|0;mc(a|0)}return}function Bq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;Yy(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;yq(f,b);c[g>>2]=f+4;Zy(a,h);_y(h);i=j;return}function Cq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;Ty(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;tq(f,b);c[g>>2]=f+4;Uy(a,h);Vy(h);i=j;return}function Dq(a,b){a=a|0;b=b|0;c[a+4>>2]=0;c[a>>2]=4116;c[a+8>>2]=0;Te(a,b);return}function Eq(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d;c[a+4>>2]=0;c[a>>2]=34572;c[e>>2]=0;ms(a+8|0,b,e);i=d;return}function Fq(a,b){a=a|0;b=b|0;c[a+4>>2]=0;c[a>>2]=29772;c[a+8>>2]=0;Hq(a,b);return}function Gq(a,b){a=a|0;b=b|0;c[a>>2]=0;Le(a,c[b>>2]|0);return}function Hq(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}a=a+8|0;d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function Iq(a){a=a|0;var b=0,c=0,d=0;if(!a)a=32;else{c=a<<16;d=(c|0)==0;a=d?a:c;d=d?31:15;c=a<<8;b=(c|0)==0;c=b?a:c;d=b?d:d+-8|0;b=c<<4;a=(b|0)==0;b=a?c:b;d=a?d:d+-4|0;a=b<<2;c=(a|0)==0;a=(c?d:d+-2|0)-((c?b:a)>>>30&1)|0}return a|0}function Jq(b,c){b=b|0;c=c|0;var d=0,e=0;d=i;i=i+16|0;e=d;a[e>>0]=c;b=dy(b,e,1)|0;i=d;return b|0}function Kq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;i=i+16|0;e=f;if(!((b|0)<1|(d|0)<1)){c[a+8>>2]=b;c[a+12>>2]=d;b=b+31>>5;c[a+16>>2]=b;kq(e,$(b,d)|0);Hq(a+20|0,c[e+8>>2]|0);nq(e);i=f;return}e=Ob(8)|0;o=0;ma(103,e|0,52691);f=o;o=0;if(f&1){f=cc()|0;Nb(e|0);bc(f|0)}else Hc(e|0,240,66)}function Lq(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;i=b+32|0;JC(i,d)|0;h=b+44|0;c[h>>2]=0;j=b+48|0;g=c[j>>2]|0;if(g&8){d=a[i>>0]|0;if(!(d&1)){d=((d&255)>>>1)+(i+1)|0;c[h>>2]=d;e=i+1|0;f=i+1|0}else{d=(c[b+40>>2]|0)+(c[b+36>>2]|0)|0;c[h>>2]=d;f=c[b+40>>2]|0;e=f}c[b+8>>2]=e;c[b+12>>2]=f;c[b+16>>2]=d}if(g&16){d=a[i>>0]|0;if(!(d&1)){g=(d&255)>>>1;c[h>>2]=i+1+g;d=10;h=g}else{g=c[b+36>>2]|0;c[h>>2]=(c[b+40>>2]|0)+g;d=(c[i>>2]&-2)+-1|0;h=g}MC(i,d,0);d=a[i>>0]|0;if(!(d&1)){g=i+1|0;f=(d&255)>>>1;e=i+1|0}else{e=c[b+40>>2]|0;g=e;f=c[b+36>>2]|0}d=b+24|0;c[d>>2]=e;c[b+20>>2]=e;c[b+28>>2]=g+f;if(c[j>>2]&3)c[d>>2]=e+h}return}function Mq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=c[b+48>>2]|0;do if(!(d&16))if(!(d&8)){c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;break}else{Gy(a,c[b+8>>2]|0,c[b+16>>2]|0);break}else{e=b+44|0;d=c[e>>2]|0;f=c[b+24>>2]|0;if(d>>>0<f>>>0){c[e>>2]=f;d=f}Gy(a,c[b+20>>2]|0,d)}while(0);return}function Nq(a){a=a|0;Ey(a,29924);iD(a+56|0);return}function Oq(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function Pq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+16|0;g=h+12|0;f=h;e=Ay(a,g,b)|0;d=c[e>>2]|0;if(!d){By(f,a,b);d=c[f>>2]|0;Cy(a,c[g>>2]|0,e,d);c[f>>2]=0}i=h;return d+20|0}function Qq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+16|0;g=h+12|0;f=h;e=xy(a,g,b)|0;d=c[e>>2]|0;if(!d){zy(f,a,b);d=c[f>>2]|0;yy(a,c[g>>2]|0,e,d);c[f>>2]=0}i=h;return d+28|0}function Rq(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function Sq(a,b){a=a|0;b=b|0;c[a>>2]=0;cq(a,c[b>>2]|0);return}function Tq(a,b){a=a|0;b=b|0;c[a+4>>2]=0;c[a>>2]=30536;c[a+8>>2]=0;iv(a,c[b+8>>2]|0);return}function Uq(a){a=a|0;var b=0;c[a>>2]=30536;a=a+8|0;b=c[a>>2]|0;if(b)ye(b);c[a>>2]=0;return}function Vq(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(196,a|0,b|0);d=o;o=0;if(d&1){d=cc()|0;wq(a);bc(d|0)}else{ty(a,b);break}}while(0);return}function Wq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;c[a>>2]=0;f=a+4|0;c[f>>2]=0;c[a+8>>2]=0;if(b){o=0;ma(197,a|0,b|0);e=o;o=0;if(e&1){d=cc()|0;Xq(a);bc(d|0)}g=c[f>>2]|0;e=g+(b<<2)|0;a=b;b=g;while(1){c[b>>2]=c[d>>2];a=a+-1|0;if(!a)break;else b=b+4|0}c[f>>2]=e}return}function Xq(a){a=a|0;var b=0,d=0;d=c[a>>2]|0;if(d){b=a+4|0;a=c[b>>2]|0;if((a|0)!=(d|0)){do a=a+-4|0;while((a|0)!=(d|0));c[b>>2]=a}Uz(d)}return}function Yq(a,b){a=a|0;b=b|0;return dy(a,b,iC(b)|0)|0}function Zq(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function _q(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function $q(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function ar(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function br(a){a=a|0;var b=0,d=0;d=c[a>>2]|0;if(d){b=a+4|0;a=c[b>>2]|0;if((a|0)!=(d|0)){do a=a+-4|0;while((a|0)!=(d|0));c[b>>2]=a}Uz(d)}return}function cr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;h=a+4|0;d=c[h>>2]|0;e=c[a>>2]|0;f=d-e>>2;if(f>>>0>=b>>>0){if(f>>>0>b>>>0?(g=e+(b<<2)|0,(d|0)!=(g|0)):0){do d=d+-4|0;while((d|0)!=(g|0));c[h>>2]=d}}else my(a,b-f|0);return}function dr(a,b){a=a|0;b=b|0;c[a>>2]=0;$q(a,c[b>>2]|0);return}function er(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(198,a|0,b|0);d=o;o=0;if(d&1){d=cc()|0;fr(a);bc(d|0)}else{jy(a,b);break}}while(0);return}function fr(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;ar(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function gr(b,d){b=b|0;d=d|0;var e=0,f=0;e=a[d>>0]|0;f=(e&1)==0;return dy(b,f?d+1|0:c[d+8>>2]|0,f?(e&255)>>>1:c[d+4>>2]|0)|0}function hr(a,b){a=a|0;b=b|0;var d=0,e=0;e=a+4|0;d=c[b>>2]|0;b=c[e>>2]|0;a:do if(!b)a=e;else{a=e;do{while(1){if((c[b+16>>2]|0)>>>0>=d>>>0){a=b;break}b=c[b+4>>2]|0;if(!b)break a}b=c[a>>2]|0}while((b|0)!=0)}while(0);if(!((a|0)!=(e|0)?d>>>0>=(c[a+16>>2]|0)>>>0:0))a=e;return a|0}function ir(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function jr(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function kr(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function lr(a,b){a=a|0;b=b|0;c[a>>2]=0;jr(a,c[b>>2]|0);return}function mr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[a>>2]=0;f=a+4|0;c[f>>2]=0;c[a+8>>2]=0;e=b+4|0;d=(c[e>>2]|0)-(c[b>>2]|0)>>2;if(d){o=0;ma(199,a|0,d|0);d=o;o=0;if(d&1){f=cc()|0;qr(a);bc(f|0)}d=c[b>>2]|0;b=c[e>>2]|0;if((d|0)!=(b|0))do{c[c[f>>2]>>2]=c[d>>2];c[f>>2]=(c[f>>2]|0)+4;d=d+4|0}while((d|0)!=(b|0))}return}function nr(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(200,a|0,b|0);d=o;o=0;if(d&1){d=cc()|0;rr(a);bc(d|0)}else{$x(a,b);break}}while(0);return}function or(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function pr(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function qr(a){a=a|0;var b=0,d=0;d=c[a>>2]|0;if(d){b=a+4|0;a=c[b>>2]|0;if((a|0)!=(d|0)){do a=a+-4|0;while((a|0)!=(d|0));c[b>>2]=a}Uz(d)}return}function rr(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;pr(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function sr(a,b){a=a|0;b=b|0;c[a+4>>2]=0;c[a>>2]=34556;Pd(a+8|0,b);c[a+20>>2]=0;c[a+24>>2]=0;return}function tr(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function ur(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function vr(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;c[b>>2]=0;h=b+4|0;c[h>>2]=0;c[b+8>>2]=0;g=d+4|0;e=c[g>>2]|0;f=c[d>>2]|0;if((e|0)!=(f|0)){o=0;ma(83,b|0,e-f|0);f=o;o=0;if(f&1){h=cc()|0;He(b);bc(h|0)}e=c[d>>2]|0;f=c[g>>2]|0;if((e|0)!=(f|0))do{a[c[h>>2]>>0]=a[e>>0]|0;c[h>>2]=(c[h>>2]|0)+1;e=e+1|0}while((e|0)!=(f|0))}return}function wr(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+32|0;j=k;h=b+4|0;e=c[b>>2]|0;g=(c[h>>2]|0)-e+1|0;if((g|0)<0)Qz(b);f=e;e=(c[b+8>>2]|0)-f|0;if(e>>>0<1073741823){e=e<<1;e=e>>>0<g>>>0?g:e}else e=2147483647;Vx(j,e,(c[h>>2]|0)-f|0,b+8|0);h=j+8|0;g=c[h>>2]|0;a[g>>0]=a[d>>0]|0;c[h>>2]=g+1;Wx(b,j);Xx(j);i=k;return}function xr(a,b){a=a|0;b=b|0;c[a>>2]=0;or(a,c[b>>2]|0);return}function yr(a){a=a|0;c[a>>2]=30684;Yd(a+16|0);kr(a+12|0);Yd(a+8|0);return}function zr(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function Ar(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(201,a|0,b|0);d=o;o=0;if(d&1){d=cc()|0;Jr(a);bc(d|0)}else{Sx(a,b);break}}while(0);return}function Br(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function Cr(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function Dr(a,b){a=a|0;b=b|0;c[a>>2]=0;Br(a,c[b>>2]|0);return}function Er(a,b){a=a|0;b=b|0;a=Nx(a,b)|0;c[a>>2]=(c[a>>2]|0)+1;return}function Fr(a){a=a|0;var b=0;b=c[a+4>>2]|0;if(!b)while(1){b=c[a+8>>2]|0;if((c[b>>2]|0)==(a|0))break;else a=b}else while(1){a=c[b>>2]|0;if(!a)break;else b=a}return b|0}function Gr(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;i=i+16|0;d=e;c[a+4>>2]=0;c[a>>2]=29756;c[d>>2]=0;vq(d,0);o=0;mb(112,a+8|0,b|0,d|0);a=o;o=0;if(a&1){e=cc()|0;uq(d);bc(e|0)}else{uq(d);i=e;return}}function Hr(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function Ir(a){a=a|0;Kx(a,c[a+4>>2]|0);return}function Jr(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;Cr(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function Kr(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function Lr(a,b){a=a|0;b=b|0;c[a>>2]=0;Zq(a,c[b>>2]|0);return}function Mr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;c[a>>2]=0;e=a+4|0;c[e>>2]=0;c[a+8>>2]=0;if(b){o=0;ma(199,a|0,b|0);f=o;o=0;if(f&1){f=cc()|0;qr(a);bc(f|0)}a=c[e>>2]|0;do{c[a>>2]=c[d>>2];a=(c[e>>2]|0)+4|0;c[e>>2]=a;b=b+-1|0}while((b|0)!=0)}return}function Nr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;Gx(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;c[f>>2]=c[b>>2];c[g>>2]=f+4;Hx(a,h);Ix(h);i=j;return}function Or(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;Dx(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;lr(f,b);c[g>>2]=f+4;Ex(a,h);Fx(h);i=j;return}function Pr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;hx(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;Pe(f,b);c[g>>2]=f+4;ix(a,h);jx(h);i=j;return}function Qr(a){a=a|0;c[a>>2]=28084;ze(a+12|0);Yd(a+8|0);return}function Rr(a,b){a=a|0;b=b|0;c[a>>2]=0;_r(a,c[b>>2]|0);return}function Sr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;zx(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;Ax(f,b);c[g>>2]=f+4;Bx(a,h);Cx(h);i=j;return}function Tr(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function Ur(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;Tr(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function Vr(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;ir(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function Wr(a){a=a|0;ze(a+20|0);Zr(a+4|0);Yd(a);return}function Xr(a,b){a=a|0;b=b|0;var d=0,e=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;d=b+4|0;e=(c[d>>2]|0)-(c[b>>2]|0)>>2;do if(e){o=0;ma(202,a|0,e|0);e=o;o=0;if(e&1){b=cc()|0;Zr(a);bc(b|0)}else{yx(a,c[b>>2]|0,c[d>>2]|0);break}}while(0);return}function Yr(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;fs(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0);c[a+8>>2]=0;c[e>>2]=0;c[a>>2]=0}return}function Zr(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;fs(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function _r(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function $r(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;vx(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;Rr(f,b);c[g>>2]=f+4;wx(a,h);xx(h);i=j;return}function as(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-12|0;c[e>>2]=f;Zr(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function bs(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=(((c[g>>2]|0)-d|0)/12|0)+1|0;if(f>>>0>357913941)Qz(a);e=d;d=((c[a+8>>2]|0)-e|0)/12|0;if(d>>>0<178956970){d=d<<1;d=d>>>0<f>>>0?f:d}else d=357913941;sx(h,d,((c[g>>2]|0)-e|0)/12|0,a+8|0);d=h+8|0;e=c[d>>2]|0;o=0;ma(133,e|0,b|0);b=o;o=0;if(b&1){j=cc()|0;ux(h);bc(j|0)}else{c[d>>2]=e+12;tx(a,h);ux(h);i=j;return}}function cs(a,b){a=a|0;b=b|0;var d=0.0;d=+$n(c[a>>2]|0);return d-+$n(c[b>>2]|0)<0.0|0}function ds(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;L=i;i=i+96|0;J=L+80|0;H=L+76|0;I=L+72|0;y=L+68|0;z=L+64|0;A=L+60|0;B=L+56|0;C=L+52|0;D=L+48|0;E=L+44|0;F=L+40|0;n=L+36|0;p=L+32|0;q=L+28|0;r=L+24|0;s=L+20|0;t=L+16|0;u=L+12|0;v=L+8|0;w=L+4|0;x=L;a:while(1){m=b;G=b+-4|0;b:while(1){l=a;e=m-l|0;f=e>>2;switch(f|0){case 1:case 0:{K=69;break a}case 2:{f=G;e=G;K=4;break a}case 3:{b=G;K=8;break a}case 4:{b=G;K=9;break a}case 5:{b=G;K=10;break a}default:{}}if((e|0)<28){K=12;break a}g=(f|0)/2|0;h=a+(g<<2)|0;if((e|0)>3996){f=(f|0)/4|0;f=px(a,a+(f<<2)|0,h,a+(f+g<<2)|0,G,d)|0}else f=nx(a,h,G,d)|0;e=c[d>>2]|0;es(y,a);es(z,h);o=0;e=Wa(e|0,y|0,z|0)|0;k=o;o=0;if(k&1){K=22;break a}fs(z);fs(y);do if(e)g=G;else{e=G;while(1){e=e+-4|0;if((a|0)==(e|0))break;g=c[d>>2]|0;es(q,e);es(r,h);o=0;g=Wa(g|0,q|0,r|0)|0;k=o;o=0;if(k&1){K=44;break a}fs(r);fs(q);if(g){K=43;break}}if((K|0)==43){K=0;es(J,a);hs(a,c[e>>2]|0);hs(e,c[J>>2]|0);fs(J);g=e;f=f+1|0;break}e=a+4|0;f=c[d>>2]|0;es(A,a);es(B,G);o=0;f=Wa(f|0,A|0,B|0)|0;l=o;o=0;if(l&1){K=23;break a}fs(B);fs(A);if(!f){if((e|0)==(G|0)){K=69;break a}else f=a;while(1){g=c[d>>2]|0;es(C,a);es(D,e);o=0;g=Wa(g|0,C|0,D|0)|0;l=o;o=0;if(l&1){K=27;break a}fs(D);fs(C);if(g)break;f=e+4|0;if((f|0)==(G|0)){K=69;break a}else{l=e;e=f;f=l}}es(J,e);hs(e,c[G>>2]|0);hs(G,c[J>>2]|0);fs(J);e=f+8|0}if((e|0)==(G|0)){K=69;break a}else f=G;while(1){while(1){g=c[d>>2]|0;es(E,a);es(F,e);o=0;g=Wa(g|0,E|0,F|0)|0;l=o;o=0;if(l&1){K=35;break a}fs(F);fs(E);if(g)break;e=e+4|0}do{g=c[d>>2]|0;es(n,a);f=f+-4|0;es(p,f);o=0;g=Wa(g|0,n|0,p|0)|0;l=o;o=0;if(l&1){K=38;break a}fs(p);fs(n)}while(g);if(e>>>0>=f>>>0){a=e;continue b}es(J,e);hs(e,c[f>>2]|0);hs(f,c[J>>2]|0);fs(J);e=e+4|0}}while(0);e=a+4|0;c:do if(e>>>0<g>>>0){k=g;while(1){while(1){g=c[d>>2]|0;es(s,e);es(t,h);o=0;g=Wa(g|0,s|0,t|0)|0;j=o;o=0;if(j&1){K=51;break a}fs(t);fs(s);if(!g){j=e;break}e=e+4|0}e=k;while(1){g=c[d>>2]|0;e=e+-4|0;es(u,e);es(v,h);o=0;g=Wa(g|0,u|0,v|0)|0;k=o;o=0;if(k&1){K=54;break a}fs(v);fs(u);if(g){g=e;break}}if(j>>>0>g>>>0){e=j;break c}es(J,j);hs(j,c[g>>2]|0);hs(g,c[J>>2]|0);fs(J);e=j+4|0;k=g;h=(h|0)==(j|0)?g:h;f=f+1|0}}while(0);if((e|0)!=(h|0)){g=c[d>>2]|0;es(w,h);es(x,e);o=0;g=Wa(g|0,w|0,x|0)|0;k=o;o=0;if(k&1){K=61;break a}fs(x);fs(w);if(g){es(J,e);hs(e,c[h>>2]|0);hs(h,c[J>>2]|0);fs(J);f=f+1|0}}if(!f){f=rx(a,e,d)|0;g=e+4|0;if(rx(g,b,d)|0){K=64;break}if(f){a=g;continue}}k=e;if((k-l|0)>=(m-k|0)){K=68;break}ds(a,e,d);a=e+4|0}if((K|0)==64){K=0;if(f){K=69;break}else{b=e;continue}}else if((K|0)==68){K=0;ds(e+4|0,b,d);b=e;continue}}switch(K|0){case 4:{b=c[d>>2]|0;es(H,f);es(I,a);o=0;b=Wa(b|0,H|0,I|0)|0;K=o;o=0;if(K&1){b=cc()|0;fs(I);fs(H);K=70;break}fs(I);fs(H);if(b){es(J,a);hs(a,c[e>>2]|0);hs(f,c[J>>2]|0);fs(J);K=69}else K=69;break}case 8:{nx(a,a+4|0,b,d)|0;K=69;break}case 9:{ox(a,a+4|0,a+8|0,b,d)|0;K=69;break}case 10:{px(a,a+4|0,a+8|0,a+12|0,b,d)|0;K=69;break}case 12:{qx(a,b,d);K=69;break}case 22:{b=cc()|0;fs(z);fs(y);K=70;break}case 23:{b=cc()|0;fs(B);fs(A);K=70;break}case 27:{b=cc()|0;fs(D);fs(C);K=70;break}case 35:{b=cc()|0;fs(F);fs(E);K=70;break}case 38:{b=cc()|0;fs(p);fs(n);K=70;break}case 44:{b=cc()|0;fs(r);fs(q);K=70;break}case 51:{b=cc()|0;fs(t);fs(s);K=70;break}case 54:{b=cc()|0;fs(v);fs(u);K=70;break}case 61:{b=cc()|0;fs(x);fs(w);K=70;break}}if((K|0)==69){i=L;return}else if((K|0)==70)bc(b|0)}function es(a,b){a=a|0;b=b|0;c[a>>2]=0;hs(a,c[b>>2]|0);return}function fs(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function gs(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;kx(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;es(f,b);c[g>>2]=f+4;lx(a,h);mx(h);i=j;return}function hs(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function is(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;hx(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;Pe(f,b);c[g>>2]=f+4;ix(a,h);jx(h);i=j;return}function js(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;de(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function ks(a,b){a=a|0;b=b|0;c[a>>2]=c[b>>2];xe(a+4|0,c[b+4>>2]|0);return a|0}function ls(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;dx(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;ex(f,b);c[g>>2]=f+4;fx(a,h);gx(h);i=j;return}function ms(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;c[a>>2]=0;g=a+4|0;c[g>>2]=0;c[a+8>>2]=0;if(b){o=0;ma(203,a|0,b|0);f=o;o=0;if(f&1){d=cc()|0;br(a);bc(d|0)}e=c[g>>2]|0;a=b;f=e;while(1){c[f>>2]=c[d>>2];a=a+-1|0;if(!a)break;else f=f+4|0}c[g>>2]=e+(b<<2)}return}function ns(a,b){a=a|0;b=b|0;var d=0,e=0;c[a+4>>2]=0;c[a>>2]=4116;c[a+8>>2]=0;o=0;d=qa(111,20)|0;e=o;o=0;do if(!(e&1)){o=0;ma(124,d|0,b|0);e=o;o=0;if(e&1){e=cc()|0;Uz(d);d=e;break}else{Te(a,d);return}}else d=cc()|0;while(0);bc(d|0)}function os(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function ps(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function qs(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;Yv(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;c[f>>2]=c[b>>2];c[g>>2]=f+4;Zv(a,h);_v(h);i=j;return}function rs(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=34536;o=0;b=qa(191,c[b+4>>2]|0)|0;d=o;o=0;if(d&1){d=cc()|0;mc(d|0)}else{c[a+4>>2]=b;return}}function ss(a,b){a=a|0;b=b|0;var d=0,e=0;c[a>>2]=0;d=a+4|0;c[d>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(203,a|0,b|0);e=o;o=0;if(e&1){e=cc()|0;br(a);bc(e|0)}else{e=c[d>>2]|0;ZL(e|0,0,b<<2|0)|0;c[d>>2]=e+(b<<2);break}}while(0);return}function ts(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function us(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;_w(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;$w(f,b);c[g>>2]=f+4;ax(a,h);bx(h);i=j;return}function vs(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function ws(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;vs(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function xs(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function ys(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;Xw(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;Bs(f,b);c[g>>2]=f+4;Yw(a,h);Zw(h);i=j;return}function zs(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function As(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;zs(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function Bs(a,b){a=a|0;b=b|0;c[a>>2]=0;xs(a,c[b>>2]|0);return}function Cs(a,b){a=a|0;b=b|0;var d=0,e=0;c[a+4>>2]=0;c[a>>2]=34504;c[a+8>>2]=0;o=0;d=qa(111,20)|0;e=o;o=0;do if(!(e&1)){o=0;ma(204,d|0,b|0);e=o;o=0;if(e&1){e=cc()|0;Uz(d);d=e;break}else{Pw(a,d);return}}else d=cc()|0;while(0);bc(d|0)}function Ds(a){a=a|0;a=c[a+8>>2]|0;if(a)Vz(a);return}function Es(a,b,d){a=a|0;b=b|0;d=d|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;o=0;mb(106,a|0,b|0,d|0);d=o;o=0;if(d&1){d=cc()|0;Ds(a+4|0);bc(d|0)}else return}function Fs(a){a=a|0;var b=0;c[a>>2]=34504;a=a+8|0;b=c[a>>2]|0;if(b)ye(b);c[a>>2]=0;return}function Gs(a,b,d){a=a|0;b=b|0;d=d|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;o=0;mb(105,a|0,b|0,d|0);d=o;o=0;if(d&1){d=cc()|0;Ds(a+4|0);bc(d|0)}else return}function Hs(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;g=c[d>>2]|0;i=c[e>>2]|0;j=i-g|0;f=a[b>>0]|0;if(!(f&1))h=10;else{f=c[b>>2]|0;h=(f&-2)+-1|0;f=f&255}if(j>>>0>h>>>0){if(!(f&1))f=(f&255)>>>1;else f=c[b+4>>2]|0;TC(b,h,j-h|0,f,0,f,0);f=a[b>>0]|0}if(!(f&1))f=b+1|0;else f=c[b+8>>2]|0;if((g|0)!=(i|0))do{a[f>>0]=a[g>>0]|0;g=(c[d>>2]|0)+1|0;c[d>>2]=g;f=f+1|0}while((g|0)!=(c[e>>2]|0));a[f>>0]=0;if(!(a[b>>0]&1))a[b>>0]=j<<1;else c[b+4>>2]=j;return b|0}function Is(a){a=a|0;c[a>>2]=34180;nq(a+52|0);Yd(a+8|0);return}function Js(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function Ks(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function Ls(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function Ms(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function Ns(a,b){a=a|0;b=b|0;c[a>>2]=0;Ls(a,c[b>>2]|0);return}function Os(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;Ms(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function Ps(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(205,a|0,b|0);d=o;o=0;if(d&1){d=cc()|0;Os(a);bc(d|0)}else{Lw(a,b);break}}while(0);return}function Qs(a,b){a=a|0;b=b|0;if((a|0)!=(b|0))Jw(a+8|0,c[b+8>>2]|0,c[b+12>>2]|0);return a|0}function Rs(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=a+8|0;i=c[a>>2]|0;f=i;do if((c[e>>2]|0)-f>>2>>>0>=b>>>0){j=a+4|0;e=c[j>>2]|0;g=e-f>>2;h=g>>>0<b>>>0;f=h?g:b;if(f){a=i;while(1){c[a>>2]=c[d>>2];f=f+-1|0;if(!f)break;else a=a+4|0}}if(h){a=b-g|0;f=a;g=e;while(1){c[g>>2]=c[d>>2];f=f+-1|0;if(!f)break;else g=g+4|0}c[j>>2]=e+(a<<2);break}else{f=i+(b<<2)|0;if((e|0)==(f|0))break;do e=e+-4|0;while((e|0)!=(f|0));c[j>>2]=e;break}}else{Xv(a);if(b>>>0>1073741823)Qz(a);e=(c[e>>2]|0)-(c[a>>2]|0)|0;if(e>>2>>>0<536870911){e=e>>1;e=e>>>0<b>>>0?b:e}else e=1073741823;Iw(a,e);a=a+4|0;f=c[a>>2]|0;e=b;g=f;while(1){c[g>>2]=c[d>>2];e=e+-1|0;if(!e)break;else g=g+4|0}c[a>>2]=f+(b<<2)}while(0);return}function Ss(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(206,a|0,b|0);d=o;o=0;if(d&1){d=cc()|0;Us(a);bc(d|0)}else{Hw(a,b);break}}while(0);return}function Ts(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;h=a+4|0;d=c[h>>2]|0;e=c[a>>2]|0;f=d-e>>2;if(f>>>0>=b>>>0){if(f>>>0>b>>>0?(g=e+(b<<2)|0,(d|0)!=(g|0)):0){do d=d+-4|0;while((d|0)!=(g|0));c[h>>2]=d}}else Fw(a,b-f|0);return}function Us(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-12|0;c[e>>2]=f;Xq(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function Vs(a,b){a=a|0;b=b|0;var d=0,e=0;c[a>>2]=0;d=a+4|0;c[d>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(197,a|0,b|0);e=o;o=0;if(e&1){e=cc()|0;Xq(a);bc(e|0)}else{e=c[d>>2]|0;ZL(e|0,0,b<<2|0)|0;c[d>>2]=e+(b<<2);break}}while(0);return}function Ws(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(207,a|0,b|0);d=o;o=0;if(d&1){d=cc()|0;_s(a);bc(d|0)}else{zw(a,b);break}}while(0);return}function Xs(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;i=a+4|0;e=c[i>>2]|0;f=c[a>>2]|0;g=e-f>>2;if(g>>>0>=b>>>0){if(g>>>0>b>>>0?(h=f+(b<<2)|0,(e|0)!=(h|0)):0){do e=e+-4|0;while((e|0)!=(h|0));c[i>>2]=e}}else Cw(a,b-g|0,d);return}function Ys(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;a[b>>0]=0;h=b+4|0;c[h>>2]=0;e=c[d>>2]|0;g=d+4|0;if((e|0)!=(g|0)){f=0;while(1){d=c[e+20>>2]|0;if((d|0)<=(f|0))if((d|0)==(f|0)){a[b>>0]=1;d=f}else d=f;else{c[h>>2]=c[e+16>>2];a[b>>0]=0}e=Fr(e)|0;if((e|0)==(g|0))break;else f=d}}return}function Zs(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;g=a+4|0;d=c[g>>2]|0;e=c[a>>2]|0;f=(d-e|0)/12|0;if(f>>>0>=b>>>0){if(f>>>0>b>>>0?(h=e+(b*12|0)|0,(d|0)!=(h|0)):0)do{a=d+-12|0;c[g>>2]=a;br(a);d=c[g>>2]|0}while((d|0)!=(h|0))}else yw(a,b-f|0);return}function _s(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-12|0;c[e>>2]=f;br(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function $s(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-12|0;c[e>>2]=f;aw(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function at(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;vw(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;c[f>>2]=c[b>>2];c[g>>2]=f+4;ww(a,h);xw(h);i=j;return}function bt(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;i=a+4|0;e=c[i>>2]|0;f=c[a>>2]|0;g=e-f>>2;if(g>>>0>=b>>>0){if(g>>>0>b>>>0?(h=f+(b<<2)|0,(e|0)!=(h|0)):0){do e=e+-4|0;while((e|0)!=(h|0));c[i>>2]=e}}else uw(a,b-g|0,d);return}function ct(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(208,a|0,b|0);d=o;o=0;if(d&1){d=cc()|0;$s(a);bc(d|0)}else{bw(a,b);break}}while(0);return}function dt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;g=a+4|0;d=c[g>>2]|0;e=c[a>>2]|0;f=(d-e|0)/12|0;if(f>>>0>=b>>>0){if(f>>>0>b>>>0?(h=e+(b*12|0)|0,(d|0)!=(h|0)):0)do{a=d+-12|0;c[g>>2]=a;gt(a);d=c[g>>2]|0}while((d|0)!=(h|0))}else nw(a,b-f|0);return}function et(a){a=a|0;var b=0;b=a+4|0;gw(a,c[b>>2]|0);c[a+8>>2]=0;c[a>>2]=b;c[b>>2]=0;return}function ft(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+16|0;g=h+12|0;f=h;e=hw(a,g,b)|0;d=c[e>>2]|0;if(!d){iw(f,a,b);d=c[f>>2]|0;jw(a,c[g>>2]|0,e,d);c[f>>2]=0}i=h;return d+20|0}function gt(a){a=a|0;gw(a,c[a+4>>2]|0);return}function ht(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;g=a+4|0;d=c[g>>2]|0;e=c[a>>2]|0;f=(d-e|0)/12|0;if(f>>>0>=b>>>0){if(f>>>0>b>>>0?(h=e+(b*12|0)|0,(d|0)!=(h|0)):0)do{a=d+-12|0;c[g>>2]=a;aw(a);d=c[g>>2]|0}while((d|0)!=(h|0))}else $v(a,b-f|0);return}function it(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;Yv(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;c[f>>2]=c[b>>2];c[g>>2]=f+4;Zv(a,h);_v(h);i=j;return}function jt(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;r=i;i=i+32|0;l=r+21|0;m=r+20|0;q=r;h=c[b>>2]|0;d=c[d>>2]|0;p=d;f=h;g=(p-f|0)/12|0;j=b+4|0;k=c[j>>2]|0;n=c[b+8>>2]|0;do if(k>>>0<n>>>0)if((d|0)==(k|0)){c[d>>2]=0;q=d+4|0;c[q>>2]=0;c[d+8>>2]=0;c[d>>2]=c[e>>2];b=e+4|0;c[q>>2]=c[b>>2];q=e+8|0;c[d+8>>2]=c[q>>2];c[q>>2]=0;c[b>>2]=0;c[e>>2]=0;c[j>>2]=(c[j>>2]|0)+12;break}else{Qv(b,d,k,h+((g+1|0)*12|0)|0);a[l>>0]=a[m>>0]|0;Rv(d,e,l);break}else{g=((k-f|0)/12|0)+1|0;if(g>>>0>357913941)Qz(b);f=(n-h|0)/12|0;if(f>>>0<178956970){f=f<<1;f=f>>>0<g>>>0?g:f}else f=357913941;Sv(q,f,(p-h|0)/12|0,b+8|0);o=0;ma(209,q|0,e|0);e=o;o=0;if(e&1){r=cc()|0;Vv(q);bc(r|0)}else{d=Uv(b,q,d)|0;Vv(q);break}}while(0);i=r;return d|0}function kt(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function lt(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function mt(a,b){a=a|0;b=b|0;c[a>>2]=0;kt(a,c[b>>2]|0);return}function nt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[a>>2]=0;f=a+4|0;c[f>>2]=0;c[a+8>>2]=0;e=b+4|0;d=(c[e>>2]|0)-(c[b>>2]|0)>>2;if(d){o=0;ma(210,a|0,d|0);d=o;o=0;if(d&1){f=cc()|0;rt(a);bc(f|0)}d=c[b>>2]|0;b=c[e>>2]|0;if((d|0)!=(b|0))do{c[c[f>>2]>>2]=c[d>>2];c[f>>2]=(c[f>>2]|0)+4;d=d+4|0}while((d|0)!=(b|0))}return}function ot(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(211,a|0,b|0);d=o;o=0;if(d&1){d=cc()|0;st(a);bc(d|0)}else{Mv(a,b);break}}while(0);return}function pt(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function qt(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function rt(a){a=a|0;var b=0,d=0;d=c[a>>2]|0;if(d){b=a+4|0;a=c[b>>2]|0;if((a|0)!=(d|0)){do a=a+-4|0;while((a|0)!=(d|0));c[b>>2]=a}Uz(d)}return}function st(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;qt(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function tt(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function ut(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;Fv(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;Gv(f,b);c[g>>2]=f+4;Hv(a,h);Iv(h);i=j;return}function vt(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function wt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=(((c[g>>2]|0)-d|0)/12|0)+1|0;if(f>>>0>357913941)Qz(a);e=d;d=((c[a+8>>2]|0)-e|0)/12|0;if(d>>>0<178956970){d=d<<1;d=d>>>0<f>>>0?f:d}else d=357913941;ov(h,d,((c[g>>2]|0)-e|0)/12|0,a+8|0);g=h+8|0;f=c[g>>2]|0;Pd(f,b);c[g>>2]=f+12;pv(a,h);qv(h);i=j;return}function xt(a,b){a=a|0;b=b|0;var d=0,e=0;c[a+4>>2]=0;c[a>>2]=30536;c[a+8>>2]=0;o=0;d=qa(111,20)|0;e=o;o=0;do if(!(e&1)){o=0;ma(212,d|0,b|0);e=o;o=0;if(e&1){e=cc()|0;Uz(d);d=e;break}else{iv(a,d);return}}else d=cc()|0;while(0);bc(d|0)}function yt(a,b){a=a|0;b=b|0;c[a>>2]=0;pt(a,c[b>>2]|0);return}function zt(a){a=a|0;gv(a,c[a+4>>2]|0);return}function At(a){a=a|0;c[a>>2]=34212;lt(a+16|0);Yd(a+8|0);return}function Bt(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function Ct(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function Dt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;cv(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;c[f>>2]=c[b>>2];c[g>>2]=f+4;dv(a,h);ev(h);i=j;return}function Et(a){a=a|0;var b=0,d=0;d=c[a>>2]|0;if(d){b=a+4|0;a=c[b>>2]|0;if((a|0)!=(d|0)){do a=a+-4|0;while((a|0)!=(d|0));c[b>>2]=a}Uz(d)}return}function Ft(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0;O=i;i=i+112|0;N=O+96|0;J=O+84|0;M=O+80|0;K=O+72|0;L=O+60|0;H=O+92|0;I=O+88|0;C=O+76|0;D=O+68|0;E=O+64|0;F=O+56|0;G=O+52|0;p=O+48|0;q=O+44|0;r=O+40|0;s=O+36|0;t=O+32|0;u=O+28|0;v=O+24|0;w=O+20|0;x=O+16|0;y=O+12|0;z=O+8|0;A=O+4|0;B=O;a:while(1){n=b;e=b+-4|0;b:while(1){m=a;f=n-m|0;g=f>>2;switch(g|0){case 1:case 0:{P=82;break a}case 2:{g=e;f=e;P=4;break a}case 3:{P=8;break a}case 4:{P=9;break a}case 5:{P=10;break a}default:{}}if((f|0)<28){P=12;break a}h=(g|0)/2|0;j=a+(h<<2)|0;if((f|0)>3996){f=(g|0)/4|0;f=$u(a,a+(f<<2)|0,j,a+(f+h<<2)|0,e,d)|0}else f=Zu(a,j,e,d)|0;es(C,a);es(D,j);o=0;g=ya(118,d|0,C|0,D|0)|0;l=o;o=0;if(l&1){P=35;break a}fs(D);fs(C);do if(g)g=e;else{g=e;while(1){g=g+-4|0;if((a|0)==(g|0))break;es(u,g);es(v,j);o=0;h=ya(118,d|0,u|0,v|0)|0;l=o;o=0;if(l&1){P=57;break a}fs(v);fs(u);if(h){P=56;break}}if((P|0)==56){P=0;es(N,a);hs(a,c[g>>2]|0);hs(g,c[N>>2]|0);fs(N);f=f+1|0;break}f=a+4|0;es(E,a);es(F,e);o=0;g=ya(118,d|0,E|0,F|0)|0;m=o;o=0;if(m&1){P=36;break a}fs(F);fs(E);if(!g){if((f|0)==(e|0)){P=82;break a}else g=a;while(1){es(G,a);es(p,f);o=0;h=ya(118,d|0,G|0,p|0)|0;m=o;o=0;if(m&1){P=40;break a}fs(p);fs(G);if(h)break;g=f+4|0;if((g|0)==(e|0)){P=82;break a}else{m=f;f=g;g=m}}es(N,f);hs(f,c[e>>2]|0);hs(e,c[N>>2]|0);fs(N);f=g+8|0}if((f|0)==(e|0)){P=82;break a}else g=e;while(1){while(1){es(q,a);es(r,f);o=0;h=ya(118,d|0,q|0,r|0)|0;m=o;o=0;if(m&1){P=48;break a}fs(r);fs(q);if(h)break;f=f+4|0}do{es(s,a);g=g+-4|0;es(t,g);o=0;h=ya(118,d|0,s|0,t|0)|0;m=o;o=0;if(m&1){P=51;break a}fs(t);fs(s)}while(h);if(f>>>0>=g>>>0){a=f;continue b}es(N,f);hs(f,c[g>>2]|0);hs(g,c[N>>2]|0);fs(N);f=f+4|0}}while(0);h=a+4|0;c:do if(h>>>0<g>>>0){l=j;while(1){while(1){es(w,h);es(x,l);o=0;j=ya(118,d|0,w|0,x|0)|0;k=o;o=0;if(k&1){P=64;break a}fs(x);fs(w);if(!j){k=h;break}h=h+4|0}while(1){g=g+-4|0;es(y,g);es(z,l);o=0;h=ya(118,d|0,y|0,z|0)|0;j=o;o=0;if(j&1){P=67;break a}fs(z);fs(y);if(h){j=g;break}}if(k>>>0>j>>>0){h=k;j=l;break c}es(N,k);hs(k,c[j>>2]|0);hs(j,c[N>>2]|0);fs(N);h=k+4|0;g=j;l=(l|0)==(k|0)?j:l;f=f+1|0}}while(0);if((h|0)!=(j|0)){es(A,j);es(B,h);o=0;g=ya(118,d|0,A|0,B|0)|0;l=o;o=0;if(l&1){P=74;break a}fs(B);fs(A);if(g){es(N,h);hs(h,c[j>>2]|0);hs(j,c[N>>2]|0);fs(N);f=f+1|0}}if(!f){f=av(a,h,d)|0;g=h+4|0;if(av(g,b,d)|0){P=77;break}if(f){a=g;continue}}l=h;if((l-m|0)>=(n-l|0)){e=h;P=81;break}Ft(a,h,d);a=h+4|0}if((P|0)==77){P=0;if(f){P=82;break}else{b=h;continue}}else if((P|0)==81){P=0;Ft(e+4|0,b,d);b=e;continue}}switch(P|0){case 4:{es(H,g);es(I,a);o=0;e=ya(118,d|0,H|0,I|0)|0;P=o;o=0;if(P&1){e=cc()|0;fs(I);fs(H);P=83;break}fs(I);fs(H);if(e){es(N,a);hs(a,c[f>>2]|0);hs(g,c[N>>2]|0);fs(N);P=82}else P=82;break}case 8:{Zu(a,a+4|0,e,d)|0;P=82;break}case 9:{_u(a,a+4|0,a+8|0,e,d)|0;P=82;break}case 10:{$u(a,a+4|0,a+8|0,a+12|0,e,d)|0;P=82;break}case 12:{f=a+8|0;Zu(a,a+4|0,f,d)|0;e=a+12|0;d:do if((e|0)!=(b|0)){e:while(1){es(N,e);es(J,f);o=0;g=ya(118,d|0,N|0,J|0)|0;I=o;o=0;if(I&1){P=21;break}fs(J);fs(N);if(g){es(M,e);g=e;while(1){hs(g,c[f>>2]|0);if((f|0)==(a|0)){P=17;break}c[K>>2]=0;g=c[M>>2]|0;hs(K,g);h=f+-4|0;es(L,h);o=0;j=ya(118,d|0,K|0,L|0)|0;I=o;o=0;if(I&1){P=22;break e}fs(L);fs(K);if(j){g=f;f=h}else break}if((P|0)==17){P=0;g=c[M>>2]|0;f=a}hs(f,g);fs(M)}f=e+4|0;if((f|0)==(b|0))break d;else{I=e;e=f;f=I}}if((P|0)==21){e=cc()|0;fs(J);fs(N)}else if((P|0)==22){e=cc()|0;fs(L);fs(K);fs(M)}bc(e|0)}while(0);P=82;break}case 35:{e=cc()|0;fs(D);fs(C);P=83;break}case 36:{e=cc()|0;fs(F);fs(E);P=83;break}case 40:{e=cc()|0;fs(p);fs(G);P=83;break}case 48:{e=cc()|0;fs(r);fs(q);P=83;break}case 51:{e=cc()|0;fs(t);fs(s);P=83;break}case 57:{e=cc()|0;fs(v);fs(u);P=83;break}case 64:{e=cc()|0;fs(x);fs(w);P=83;break}case 67:{e=cc()|0;fs(z);fs(y);P=83;break}case 74:{e=cc()|0;fs(B);fs(A);P=83;break}}if((P|0)==82){i=O;return}else if((P|0)==83)bc(e|0)}function Gt(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0;O=i;i=i+112|0;N=O+96|0;J=O+84|0;M=O+80|0;K=O+72|0;L=O+60|0;H=O+92|0;I=O+88|0;C=O+76|0;D=O+68|0;E=O+64|0;F=O+56|0;G=O+52|0;p=O+48|0;q=O+44|0;r=O+40|0;s=O+36|0;t=O+32|0;u=O+28|0;v=O+24|0;w=O+20|0;x=O+16|0;y=O+12|0;z=O+8|0;A=O+4|0;B=O;a:while(1){n=b;e=b+-4|0;b:while(1){m=a;f=n-m|0;g=f>>2;switch(g|0){case 1:case 0:{P=82;break a}case 2:{g=e;f=e;P=4;break a}case 3:{P=8;break a}case 4:{P=9;break a}case 5:{P=10;break a}default:{}}if((f|0)<28){P=12;break a}h=(g|0)/2|0;j=a+(h<<2)|0;if((f|0)>3996){f=(g|0)/4|0;f=Wu(a,a+(f<<2)|0,j,a+(f+h<<2)|0,e,d)|0}else f=Uu(a,j,e,d)|0;es(C,a);es(D,j);o=0;g=ya(119,d|0,C|0,D|0)|0;l=o;o=0;if(l&1){P=35;break a}fs(D);fs(C);do if(g)g=e;else{g=e;while(1){g=g+-4|0;if((a|0)==(g|0))break;es(u,g);es(v,j);o=0;h=ya(119,d|0,u|0,v|0)|0;l=o;o=0;if(l&1){P=57;break a}fs(v);fs(u);if(h){P=56;break}}if((P|0)==56){P=0;es(N,a);hs(a,c[g>>2]|0);hs(g,c[N>>2]|0);fs(N);f=f+1|0;break}f=a+4|0;es(E,a);es(F,e);o=0;g=ya(119,d|0,E|0,F|0)|0;m=o;o=0;if(m&1){P=36;break a}fs(F);fs(E);if(!g){if((f|0)==(e|0)){P=82;break a}else g=a;while(1){es(G,a);es(p,f);o=0;h=ya(119,d|0,G|0,p|0)|0;m=o;o=0;if(m&1){P=40;break a}fs(p);fs(G);if(h)break;g=f+4|0;if((g|0)==(e|0)){P=82;break a}else{m=f;f=g;g=m}}es(N,f);hs(f,c[e>>2]|0);hs(e,c[N>>2]|0);fs(N);f=g+8|0}if((f|0)==(e|0)){P=82;break a}else g=e;while(1){while(1){es(q,a);es(r,f);o=0;h=ya(119,d|0,q|0,r|0)|0;m=o;o=0;if(m&1){P=48;break a}fs(r);fs(q);if(h)break;f=f+4|0}do{es(s,a);g=g+-4|0;es(t,g);o=0;h=ya(119,d|0,s|0,t|0)|0;m=o;o=0;if(m&1){P=51;break a}fs(t);fs(s)}while(h);if(f>>>0>=g>>>0){a=f;continue b}es(N,f);hs(f,c[g>>2]|0);hs(g,c[N>>2]|0);fs(N);f=f+4|0}}while(0);h=a+4|0;c:do if(h>>>0<g>>>0){l=j;while(1){while(1){es(w,h);es(x,l);o=0;j=ya(119,d|0,w|0,x|0)|0;k=o;o=0;if(k&1){P=64;break a}fs(x);fs(w);if(!j){k=h;break}h=h+4|0}while(1){g=g+-4|0;es(y,g);es(z,l);o=0;h=ya(119,d|0,y|0,z|0)|0;j=o;o=0;if(j&1){P=67;break a}fs(z);fs(y);if(h){j=g;break}}if(k>>>0>j>>>0){h=k;j=l;break c}es(N,k);hs(k,c[j>>2]|0);hs(j,c[N>>2]|0);fs(N);h=k+4|0;g=j;l=(l|0)==(k|0)?j:l;f=f+1|0}}while(0);if((h|0)!=(j|0)){es(A,j);es(B,h);o=0;g=ya(119,d|0,A|0,B|0)|0;l=o;o=0;if(l&1){P=74;break a}fs(B);fs(A);if(g){es(N,h);hs(h,c[j>>2]|0);hs(j,c[N>>2]|0);fs(N);f=f+1|0}}if(!f){f=Xu(a,h,d)|0;g=h+4|0;if(Xu(g,b,d)|0){P=77;break}if(f){a=g;continue}}l=h;if((l-m|0)>=(n-l|0)){e=h;P=81;break}Gt(a,h,d);a=h+4|0}if((P|0)==77){P=0;if(f){P=82;break}else{b=h;continue}}else if((P|0)==81){P=0;Gt(e+4|0,b,d);b=e;continue}}switch(P|0){case 4:{es(H,g);es(I,a);o=0;e=ya(119,d|0,H|0,I|0)|0;P=o;o=0;if(P&1){e=cc()|0;fs(I);fs(H);P=83;break}fs(I);fs(H);if(e){es(N,a);hs(a,c[f>>2]|0);hs(g,c[N>>2]|0);fs(N);P=82}else P=82;break}case 8:{Uu(a,a+4|0,e,d)|0;P=82;break}case 9:{Vu(a,a+4|0,a+8|0,e,d)|0;P=82;break}case 10:{Wu(a,a+4|0,a+8|0,a+12|0,e,d)|0;P=82;break}case 12:{f=a+8|0;Uu(a,a+4|0,f,d)|0;e=a+12|0;d:do if((e|0)!=(b|0)){e:while(1){es(N,e);es(J,f);o=0;g=ya(119,d|0,N|0,J|0)|0;I=o;o=0;if(I&1){P=21;break}fs(J);fs(N);if(g){es(M,e);g=e;while(1){hs(g,c[f>>2]|0);if((f|0)==(a|0)){P=17;break}c[K>>2]=0;g=c[M>>2]|0;hs(K,g);h=f+-4|0;es(L,h);o=0;j=ya(119,d|0,K|0,L|0)|0;I=o;o=0;if(I&1){P=22;break e}fs(L);fs(K);if(j){g=f;f=h}else break}if((P|0)==17){P=0;g=c[M>>2]|0;f=a}hs(f,g);fs(M)}f=e+4|0;if((f|0)==(b|0))break d;else{I=e;e=f;f=I}}if((P|0)==21){e=cc()|0;fs(J);fs(N)}else if((P|0)==22){e=cc()|0;fs(L);fs(K);fs(M)}bc(e|0)}while(0);P=82;break}case 35:{e=cc()|0;fs(D);fs(C);P=83;break}case 36:{e=cc()|0;fs(F);fs(E);P=83;break}case 40:{e=cc()|0;fs(p);fs(G);P=83;break}case 48:{e=cc()|0;fs(r);fs(q);P=83;break}case 51:{e=cc()|0;fs(t);fs(s);P=83;break}case 57:{e=cc()|0;fs(v);fs(u);P=83;break}case 64:{e=cc()|0;fs(x);fs(w);P=83;break}case 67:{e=cc()|0;fs(z);fs(y);P=83;break}case 74:{e=cc()|0;fs(B);fs(A);P=83;break}}if((P|0)==82){i=O;return}else if((P|0)==83)bc(e|0)}function Ht(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;f=c[a>>2]|0;h=c[b>>2]|0;e=h;b=c[d>>2]|0;if((h|0)!=(b|0)){g=f+((b-e>>2)+(e-f>>2)<<2)|0;a=a+4|0;d=c[a>>2]|0;f=d;if((g|0)!=(d|0)){b=h;e=g;while(1){hs(b,c[e>>2]|0);e=e+4|0;if((e|0)==(d|0))break;else b=b+4|0}}e=h+((f-g|0)>>>2<<2)|0;b=c[a>>2]|0;if((b|0)!=(e|0))do{g=b+-4|0;c[a>>2]=g;fs(g);b=c[a>>2]|0}while((b|0)!=(e|0))}return h|0}function It(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(202,a|0,b|0);d=o;o=0;if(d&1){d=cc()|0;Zr(a);bc(d|0)}else{Su(a,b);break}}while(0);return}function Jt(a,b){a=a|0;b=b|0;c[a>>2]=0;vq(a,c[b>>2]|0);return}function Kt(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;c[a>>2]=0;e=a+4|0;c[e>>2]=0;c[a+8>>2]=0;if(b){o=0;ma(210,a|0,b|0);f=o;o=0;if(f&1){f=cc()|0;rt(a);bc(f|0)}a=c[e>>2]|0;do{c[a>>2]=c[d>>2];a=(c[e>>2]|0)+4|0;c[e>>2]=a;b=b+-1|0}while((b|0)!=0)}return}function Lt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;Ju(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;c[f>>2]=c[b>>2];c[g>>2]=f+4;Ku(a,h);Lu(h);i=j;return}function Mt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;g=i;i=i+16|0;f=g;c[f>>2]=b;b=Sz(12)|0;o=0;ma(213,b|0,a|0);e=o;o=0;if(e&1){g=cc()|0;Uz(b);bc(g|0)}if(a){d=c[b>>2]|0;e=0;do{j=(c[f>>2]|0)+(4-1)&~(4-1);h=c[j>>2]|0;c[f>>2]=j+4;c[d+(e<<2)>>2]=h;e=e+1|0}while((e|0)!=(a|0))}i=g;return b|0}function Nt(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function Ot(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;i=i+32|0;h=j;g=a+4|0;d=c[a>>2]|0;f=((c[g>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823)Qz(a);e=d;d=(c[a+8>>2]|0)-e|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<f>>>0?f:d}else d=1073741823;Fu(h,d,(c[g>>2]|0)-e>>2,a+8|0);g=h+8|0;f=c[g>>2]|0;Gu(f,b);c[g>>2]=f+4;Hu(a,h);Iu(h);i=j;return}function Pt(a){a=a|0;a=c[a>>2]|0;if(a)ye(a);return}function Qt(a,b){a=a|0;b=b|0;var d=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;do if(b){o=0;ma(214,a|0,b|0);d=o;o=0;if(d&1){d=cc()|0;Rt(a);bc(d|0)}else{Eu(a,b);break}}while(0);return}function Rt(a){a=a|0;var b=0,d=0;d=c[a>>2]|0;if(d){b=a+4|0;a=c[b>>2]|0;if((a|0)!=(d|0)){do a=a+-4|0;while((a|0)!=(d|0));c[b>>2]=a}Uz(d)}return}function St(a,b){a=a|0;b=b|0;var d=0,e=0;if((a|0)!=(b|0)?(e=c[b+4>>2]|0,d=a+4|0,c[d>>2]=e,au(a,e),d=c[d>>2]|0,e=c[b+8>>2]|0,(d|0)!=0):0){a=c[a+8>>2]|0;b=0;do{c[a+(b<<2)>>2]=c[e+(b<<2)>>2];b=b+1|0}while((b|0)!=(d|0))}return}function Tt(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[b+4>>2]|0;c[a+4>>2]=d;c[a>>2]=d;e=Tz(d>>>0>1073741823?-1:d<<2)|0;c[a+8>>2]=e;a=c[b+8>>2]|0;if(d){b=0;do{c[e+(b<<2)>>2]=c[a+(b<<2)>>2];b=b+1|0}while((b|0)!=(d|0))}return}function Ut(a,b){a=a|0;b=b|0;c[a>>2]=c[b>>2];Tt(a+4|0,b+4|0);return}function Vt(a){a=a|0;a=c[a+8>>2]|0;if(a)Vz(a);return}function Wt(a,b){a=a|0;b=b|0;var d=0;if(b){c[a>>2]=1;d=Tz(4)|0;c[a+8>>2]=d;c[a+4>>2]=1;c[d>>2]=b}return}function Xt(a,b){a=a|0;b=b|0;var d=0;if(b<<16>>16){c[a>>2]=1;d=Tz(4)|0;c[a+8>>2]=d;c[a+4>>2]=1;c[d>>2]=b&65535}return}function Yt(a,b){a=a|0;b=b|0;if((b|0)<0){b=Ob(4)|0;c[b>>2]=50897;Hc(b|0,1952,0)}else{Cu(a,b);return}}function Zt(a){a=a|0;var b=0;switch(c[a+4>>2]|0){case 0:{a=0;b=5;break}case 1:{a=c[c[a+8>>2]>>2]|0;if((a&65535|0)==(a|0)){a=a&65535;b=5}else b=4;break}default:b=4}if((b|0)==4){b=Ob(4)|0;c[b>>2]=50823;Hc(b|0,1952,0)}else if((b|0)==5)return a|0;return 0}function _t(a){a=a|0;var b=0,d=0;d=a+4|0;b=c[d>>2]|0;a:do if(b){a=c[a+8>>2]|0;do{b=b+-1|0;if(c[a+(b<<2)>>2]|0)break a;c[d>>2]=b}while((b|0)!=0)}while(0);return}function $t(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;if((c[a>>2]|0)>>>0<b>>>0){f=a+8|0;e=c[f>>2]|0;c[a>>2]=b;d=Tz(b>>>0>1073741823?-1:b<<2)|0;c[f>>2]=d;b=c[a+4>>2]|0;if(b){a=0;do{c[d+(a<<2)>>2]=c[e+(a<<2)>>2];a=a+1|0}while((a|0)!=(b|0))}if(e)Vz(e)}return}function au(a,b){a=a|0;b=b|0;var d=0,e=0;if((c[a>>2]|0)>>>0<b>>>0){d=a+8|0;e=c[d>>2]|0;if(e)Vz(e);c[a>>2]=b;c[d>>2]=Tz(b>>>0>1073741823?-1:b<<2)|0}return}function bu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if((b|0)==0|(d|0)==0)e=0;else e=(c[(c[a+8>>2]|0)+(b+-1<<2)>>2]|0)>>>(32-d|0);if((c[a+4>>2]|0)==(b|0))a=0;else a=c[(c[a+8>>2]|0)+(b<<2)>>2]<<d;return a|e|0}function cu(a,b){a=a|0;b=b|0;var d=0,e=0;if((c[a>>2]|0)>>>0<b>>>0){d=a+8|0;e=c[d>>2]|0;if(e)Vz(e);c[a>>2]=b;c[d>>2]=Tz(b>>>0>2147483647?-1:b<<1)|0}return}function du(a){a=a|0;a=c[a+4>>2]|0;return ((a|0)==0?61257:a)|0}function eu(a){a=a|0;c[a>>2]=4440;Yd(a+8|0);return}function fu(a){a=a|0;c[a>>2]=4440;Yd(a+8|0);Uz(a);return}function gu(a){a=a|0;c[a>>2]=4536;Vd(a+16|0);return}function hu(a){a=a|0;gu(a);Uz(a);return}function iu(a){a=a|0;c[a>>2]=4768;br(a+20|0);IC(a+8|0);il(a);return}function ju(a){a=a|0;iu(a);Uz(a);return}function ku(a){a=a|0;c[a>>2]=4824;br(a+24|0);IC(a+12|0);il(a);return}function lu(a){a=a|0;ku(a);Uz(a);return}function mu(a){a=a|0;c[a>>2]=4852;br(a+20|0);IC(a+8|0);il(a);return}function nu(a){a=a|0;mu(a);Uz(a);return}function ou(a){a=a|0;c[a>>2]=4880;br(a+20|0);Cl(a);return}function pu(a){a=a|0;ou(a);Uz(a);return}function qu(a){a=a|0;c[a>>2]=4928;br(a+20|0);Cl(a);return}function ru(a){a=a|0;qu(a);Uz(a);return}function su(a){a=a|0;c[a>>2]=5004;ws(a+8|0);il(a);return}function tu(a){a=a|0;su(a);Uz(a);return}function uu(a){a=a|0;c[a>>2]=5032;As(a+8|0);il(a);return}function vu(a){a=a|0;uu(a);Uz(a);return}function wu(a){a=a|0;c[a>>2]=5088;ou(a+20|0);Cl(a);return}function xu(a){a=a|0;wu(a);Uz(a);return}function yu(a){a=a|0;c[a>>2]=5232;br(a+20|0);Cl(a);return}function zu(a){a=a|0;yu(a);Uz(a);return}function Au(a){a=a|0;Uz(a);return}function Bu(a){a=a|0;Qr(a);Uz(a);return}function Cu(a,b){a=a|0;b=b|0;var d=0;if(b){c[a>>2]=1;d=Tz(4)|0;c[a+8>>2]=d;c[a+4>>2]=1;c[d>>2]=b}return}function Du(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>1073741823)Qz(a);else{d=Sz(b<<2)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<2);return}}function Eu(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;b=c[d>>2]|0;do{c[b>>2]=0;b=(c[d>>2]|0)+4|0;c[d>>2]=b;a=a+-1|0}while((a|0)!=0);return}function Fu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function Gu(a,b){a=a|0;b=b|0;c[a>>2]=0;Nt(a,c[b>>2]|0);return}function Hu(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{d=d+-4|0;Gu((c[g>>2]|0)+-4|0,d);c[g>>2]=(c[g>>2]|0)+-4}while((d|0)!=(e|0));e=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=e;e=b+8|0;d=c[f>>2]|0;c[f>>2]=c[e>>2];c[e>>2]=d;e=a+8|0;a=b+12|0;f=c[e>>2]|0;c[e>>2]=c[a>>2];c[a>>2]=f;c[b>>2]=c[g>>2];return}function Iu(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;Pt(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function Ju(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function Ku(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;e=c[a>>2]|0;g=a+4|0;d=b+4|0;f=(c[g>>2]|0)-e|0;h=(c[d>>2]|0)+(0-(f>>2)<<2)|0;c[d>>2]=h;XL(h|0,e|0,f|0)|0;f=c[a>>2]|0;c[a>>2]=c[d>>2];c[d>>2]=f;f=b+8|0;e=c[g>>2]|0;c[g>>2]=c[f>>2];c[f>>2]=e;f=a+8|0;a=b+12|0;e=c[f>>2]|0;c[f>>2]=c[a>>2];c[a>>2]=e;c[b>>2]=c[d>>2];return}function Lu(a){a=a|0;var b=0,d=0,e=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0)){do b=b+-4|0;while((b|0)!=(d|0));c[e>>2]=b}b=c[a>>2]|0;if(b)Uz(b);return}function Mu(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>1073741823)Qz(a);else{d=Sz(b<<2)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<2);return}}function Nu(a){a=a|0;return}function Ou(a){a=a|0;Uz(a);return}function Pu(a){a=a|0;c[a>>2]=34452;fs(a+16|0);fs(a+12|0);fs(a+8|0);return}function Qu(a){a=a|0;Pu(a);Uz(a);return}function Ru(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>1073741823)Qz(a);else{d=Sz(b<<2)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<2);return}}function Su(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;b=c[d>>2]|0;do{c[b>>2]=0;hs(b,0);b=(c[d>>2]|0)+4|0;c[d>>2]=b;a=a+-1|0}while((a|0)!=0);return}function Tu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0;e=_n(c[b>>2]|0)|0;e=(e|0)==(_n(c[d>>2]|0)|0);b=c[b>>2]|0;if(e){h=+$n(b);h=+O(+(h-+g[a>>2]));f=+$n(c[d>>2]|0);b=h<+O(+(f-+g[a>>2]))}else{b=_n(b)|0;b=(b|0)>(_n(c[d>>2]|0)|0)}return b|0}function Uu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+48|0;s=t+40|0;f=t+36|0;g=t+32|0;j=t+28|0;k=t+24|0;n=t+20|0;p=t+16|0;l=t+12|0;m=t+8|0;q=t+4|0;r=t;es(f,b);es(g,a);o=0;h=ya(119,e|0,f|0,g|0)|0;u=o;o=0;a:do if(u&1){u=cc()|0;fs(g);fs(f);f=u}else{fs(g);fs(f);do if(h){es(l,d);es(m,b);o=0;f=ya(119,e|0,l|0,m|0)|0;u=o;o=0;if(u&1){f=cc()|0;fs(m);fs(l);break a}fs(m);fs(l);if(f){es(s,a);hs(a,c[d>>2]|0);hs(d,c[s>>2]|0);fs(s);f=1;break}es(s,a);hs(a,c[b>>2]|0);hs(b,c[s>>2]|0);fs(s);es(q,d);es(r,b);o=0;f=ya(119,e|0,q|0,r|0)|0;u=o;o=0;if(u&1){f=cc()|0;fs(r);fs(q);break a}fs(r);fs(q);if(f){es(s,b);hs(b,c[d>>2]|0);hs(d,c[s>>2]|0);fs(s);f=2}else f=1}else{es(j,d);es(k,b);o=0;f=ya(119,e|0,j|0,k|0)|0;u=o;o=0;if(u&1){f=cc()|0;fs(k);fs(j);break a}fs(k);fs(j);if(f){es(s,b);hs(b,c[d>>2]|0);hs(d,c[s>>2]|0);fs(s);es(n,b);es(p,a);o=0;f=ya(119,e|0,n|0,p|0)|0;u=o;o=0;if(u&1){f=cc()|0;fs(p);fs(n);break a}fs(p);fs(n);if(f){es(s,a);hs(a,c[b>>2]|0);hs(b,c[s>>2]|0);fs(s);f=2}else f=1}else f=0}while(0);i=t;return f|0}while(0);bc(f|0);return 0}function Vu(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;r=i;i=i+32|0;q=r+24|0;g=r+20|0;h=r+16|0;k=r+12|0;l=r+8|0;m=r+4|0;n=r;p=Uu(a,b,d,f)|0;es(g,e);es(h,d);o=0;j=ya(119,f|0,g|0,h|0)|0;s=o;o=0;do if(s&1){s=cc()|0;fs(h);fs(g);g=s}else{fs(h);fs(g);if(j){es(q,d);hs(d,c[e>>2]|0);hs(e,c[q>>2]|0);fs(q);es(k,d);es(l,b);o=0;h=ya(119,f|0,k|0,l|0)|0;s=o;o=0;if(s&1){g=cc()|0;fs(l);fs(k);break}g=p+1|0;fs(l);fs(k);if(h){es(q,b);hs(b,c[d>>2]|0);hs(d,c[q>>2]|0);fs(q);es(m,b);es(n,a);o=0;g=ya(119,f|0,m|0,n|0)|0;s=o;o=0;if(s&1){g=cc()|0;fs(n);fs(m);break}fs(n);fs(m);if(g){es(q,a);hs(a,c[b>>2]|0);hs(b,c[q>>2]|0);fs(q);g=p+3|0}else g=p+2|0}}else g=p;i=r;return g|0}while(0);bc(g|0);return 0}function Wu(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;u=i;i=i+48|0;t=u+32|0;h=u+28|0;j=u+24|0;l=u+20|0;m=u+16|0;n=u+12|0;p=u+8|0;q=u+4|0;r=u;s=Vu(a,b,d,e,g)|0;es(h,f);es(j,e);o=0;k=ya(119,g|0,h|0,j|0)|0;v=o;o=0;do if(v&1){v=cc()|0;fs(j);fs(h);h=v}else{fs(j);fs(h);if(k){es(t,e);hs(e,c[f>>2]|0);hs(f,c[t>>2]|0);fs(t);es(l,e);es(m,d);o=0;j=ya(119,g|0,l|0,m|0)|0;v=o;o=0;if(v&1){h=cc()|0;fs(m);fs(l);break}h=s+1|0;fs(m);fs(l);if(j){es(t,d);hs(d,c[e>>2]|0);hs(e,c[t>>2]|0);fs(t);es(n,d);es(p,b);o=0;j=ya(119,g|0,n|0,p|0)|0;v=o;o=0;if(v&1){h=cc()|0;fs(p);fs(n);break}h=s+2|0;fs(p);fs(n);if(j){es(t,b);hs(b,c[d>>2]|0);hs(d,c[t>>2]|0);fs(t);es(q,b);es(r,a);o=0;h=ya(119,g|0,q|0,r|0)|0;v=o;o=0;if(v&1){h=cc()|0;fs(r);fs(q);break}fs(r);fs(q);if(h){es(t,a);hs(a,c[b>>2]|0);hs(b,c[t>>2]|0);fs(t);h=s+4|0}else h=s+3|0}}}else h=s;i=u;return h|0}while(0);bc(h|0);return 0}function Xu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+32|0;j=t+28|0;g=t+24|0;h=t+20|0;m=t+16|0;n=t+12|0;r=t+8|0;p=t+4|0;q=t;a:do switch(b-a>>2|0){case 1:case 0:{e=1;s=21;break}case 2:{f=b+-4|0;es(g,f);es(h,a);o=0;e=ya(119,d|0,g|0,h|0)|0;s=o;o=0;if(s&1){e=cc()|0;fs(h);fs(g);s=22;break a}fs(h);fs(g);if(e){es(j,a);hs(a,c[f>>2]|0);hs(f,c[j>>2]|0);fs(j);e=1;s=21}else{e=1;s=21}break}case 3:{Uu(a,a+4|0,b+-4|0,d)|0;e=1;s=21;break}case 4:{Vu(a,a+4|0,a+8|0,b+-4|0,d)|0;e=1;s=21;break}case 5:{Wu(a,a+4|0,a+8|0,a+12|0,b+-4|0,d)|0;e=1;s=21;break}default:{g=a+8|0;Uu(a,a+4|0,g,d)|0;f=a+12|0;if((f|0)!=(b|0)){e=0;l=0;b:while(1){es(m,f);es(n,g);o=0;h=ya(119,d|0,m|0,n|0)|0;k=o;o=0;if(k&1){s=18;break}fs(n);fs(m);if(h){es(r,f);h=f;while(1){hs(h,c[g>>2]|0);if((g|0)==(a|0)){s=14;break}c[p>>2]=0;h=c[r>>2]|0;hs(p,h);j=g+-4|0;es(q,j);o=0;k=ya(119,d|0,p|0,q|0)|0;u=o;o=0;if(u&1){s=19;break b}fs(q);fs(p);if(k){h=g;g=j}else break}if((s|0)==14){s=0;h=c[r>>2]|0;g=a}hs(g,h);g=l+1|0;j=(g|0)==8;k=f+4|0;e=j?(k|0)==(b|0):e;fs(r);if(j){s=21;break a}else{h=g;g=j?k:f}}else{h=l;g=f}f=g+4|0;if((f|0)==(b|0)){e=1;s=21;break a}else l=h}if((s|0)==18){e=cc()|0;fs(n);fs(m);s=22;break a}else if((s|0)==19){e=cc()|0;fs(q);fs(p);fs(r);s=22;break a}}else{e=1;s=21}}}while(0);if((s|0)==21){i=t;return e|0}else if((s|0)==22)bc(e|0);return 0}function Yu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0;f=+$n(c[b>>2]|0);f=+O(+(f-+g[a>>2]));e=+$n(c[d>>2]|0);return f>+O(+(e-+g[a>>2]))|0}function Zu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+48|0;s=t+40|0;f=t+36|0;g=t+32|0;j=t+28|0;k=t+24|0;n=t+20|0;p=t+16|0;l=t+12|0;m=t+8|0;q=t+4|0;r=t;es(f,b);es(g,a);o=0;h=ya(118,e|0,f|0,g|0)|0;u=o;o=0;a:do if(u&1){u=cc()|0;fs(g);fs(f);f=u}else{fs(g);fs(f);do if(h){es(l,d);es(m,b);o=0;f=ya(118,e|0,l|0,m|0)|0;u=o;o=0;if(u&1){f=cc()|0;fs(m);fs(l);break a}fs(m);fs(l);if(f){es(s,a);hs(a,c[d>>2]|0);hs(d,c[s>>2]|0);fs(s);f=1;break}es(s,a);hs(a,c[b>>2]|0);hs(b,c[s>>2]|0);fs(s);es(q,d);es(r,b);o=0;f=ya(118,e|0,q|0,r|0)|0;u=o;o=0;if(u&1){f=cc()|0;fs(r);fs(q);break a}fs(r);fs(q);if(f){es(s,b);hs(b,c[d>>2]|0);hs(d,c[s>>2]|0);fs(s);f=2}else f=1}else{es(j,d);es(k,b);o=0;f=ya(118,e|0,j|0,k|0)|0;u=o;o=0;if(u&1){f=cc()|0;fs(k);fs(j);break a}fs(k);fs(j);if(f){es(s,b);hs(b,c[d>>2]|0);hs(d,c[s>>2]|0);fs(s);es(n,b);es(p,a);o=0;f=ya(118,e|0,n|0,p|0)|0;u=o;o=0;if(u&1){f=cc()|0;fs(p);fs(n);break a}fs(p);fs(n);if(f){es(s,a);hs(a,c[b>>2]|0);hs(b,c[s>>2]|0);fs(s);f=2}else f=1}else f=0}while(0);i=t;return f|0}while(0);bc(f|0);return 0}function _u(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;r=i;i=i+32|0;q=r+24|0;g=r+20|0;h=r+16|0;k=r+12|0;l=r+8|0;m=r+4|0;n=r;p=Zu(a,b,d,f)|0;es(g,e);es(h,d);o=0;j=ya(118,f|0,g|0,h|0)|0;s=o;o=0;do if(s&1){s=cc()|0;fs(h);fs(g);g=s}else{fs(h);fs(g);if(j){es(q,d);hs(d,c[e>>2]|0);hs(e,c[q>>2]|0);fs(q);es(k,d);es(l,b);o=0;h=ya(118,f|0,k|0,l|0)|0;s=o;o=0;if(s&1){g=cc()|0;fs(l);fs(k);break}g=p+1|0;fs(l);fs(k);if(h){es(q,b);hs(b,c[d>>2]|0);hs(d,c[q>>2]|0);fs(q);es(m,b);es(n,a);o=0;g=ya(118,f|0,m|0,n|0)|0;s=o;o=0;if(s&1){g=cc()|0;fs(n);fs(m);break}fs(n);fs(m);if(g){es(q,a);hs(a,c[b>>2]|0);hs(b,c[q>>2]|0);fs(q);g=p+3|0}else g=p+2|0}}else g=p;i=r;return g|0}while(0);bc(g|0);return 0}function $u(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;u=i;i=i+48|0;t=u+32|0;h=u+28|0;j=u+24|0;l=u+20|0;m=u+16|0;n=u+12|0;p=u+8|0;q=u+4|0;r=u;s=_u(a,b,d,e,g)|0;es(h,f);es(j,e);o=0;k=ya(118,g|0,h|0,j|0)|0;v=o;o=0;do if(v&1){v=cc()|0;fs(j);fs(h);h=v}else{fs(j);fs(h);if(k){es(t,e);hs(e,c[f>>2]|0);hs(f,c[t>>2]|0);fs(t);es(l,e);es(m,d);o=0;j=ya(118,g|0,l|0,m|0)|0;v=o;o=0;if(v&1){h=cc()|0;fs(m);fs(l);break}h=s+1|0;fs(m);fs(l);if(j){es(t,d);hs(d,c[e>>2]|0);hs(e,c[t>>2]|0);fs(t);es(n,d);es(p,b);o=0;j=ya(118,g|0,n|0,p|0)|0;v=o;o=0;if(v&1){h=cc()|0;fs(p);fs(n);break}h=s+2|0;fs(p);fs(n);if(j){es(t,b);hs(b,c[d>>2]|0);hs(d,c[t>>2]|0);fs(t);es(q,b);es(r,a);o=0;h=ya(118,g|0,q|0,r|0)|0;v=o;o=0;if(v&1){h=cc()|0;fs(r);fs(q);break}fs(r);fs(q);if(h){es(t,a);hs(a,c[b>>2]|0);hs(b,c[t>>2]|0);fs(t);h=s+4|0}else h=s+3|0}}}else h=s;i=u;return h|0}while(0);bc(h|0);return 0}function av(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+32|0;j=t+28|0;g=t+24|0;h=t+20|0;m=t+16|0;n=t+12|0;r=t+8|0;p=t+4|0;q=t;a:do switch(b-a>>2|0){case 1:case 0:{e=1;s=21;break}case 2:{f=b+-4|0;es(g,f);es(h,a);o=0;e=ya(118,d|0,g|0,h|0)|0;s=o;o=0;if(s&1){e=cc()|0;fs(h);fs(g);s=22;break a}fs(h);fs(g);if(e){es(j,a);hs(a,c[f>>2]|0);hs(f,c[j>>2]|0);fs(j);e=1;s=21}else{e=1;s=21}break}case 3:{Zu(a,a+4|0,b+-4|0,d)|0;e=1;s=21;break}case 4:{_u(a,a+4|0,a+8|0,b+-4|0,d)|0;e=1;s=21;break}case 5:{$u(a,a+4|0,a+8|0,a+12|0,b+-4|0,d)|0;e=1;s=21;break}default:{g=a+8|0;Zu(a,a+4|0,g,d)|0;f=a+12|0;if((f|0)!=(b|0)){e=0;l=0;b:while(1){es(m,f);es(n,g);o=0;h=ya(118,d|0,m|0,n|0)|0;k=o;o=0;if(k&1){s=18;break}fs(n);fs(m);if(h){es(r,f);h=f;while(1){hs(h,c[g>>2]|0);if((g|0)==(a|0)){s=14;break}c[p>>2]=0;h=c[r>>2]|0;hs(p,h);j=g+-4|0;es(q,j);o=0;k=ya(118,d|0,p|0,q|0)|0;u=o;o=0;if(u&1){s=19;break b}fs(q);fs(p);if(k){h=g;g=j}else break}if((s|0)==14){s=0;h=c[r>>2]|0;g=a}hs(g,h);g=l+1|0;j=(g|0)==8;k=f+4|0;e=j?(k|0)==(b|0):e;fs(r);if(j){s=21;break a}else{h=g;g=j?k:f}}else{h=l;g=f}f=g+4|0;if((f|0)==(b|0)){e=1;s=21;break a}else l=h}if((s|0)==18){e=cc()|0;fs(n);fs(m);s=22;break a}else if((s|0)==19){e=cc()|0;fs(q);fs(p);fs(r);s=22;break a}}else{e=1;s=21}}}while(0);if((s|0)==21){i=t;return e|0}else if((s|0)==22)bc(e|0);return 0}function bv(a){a=a|0;Uz(a);return}function cv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function dv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;e=c[a>>2]|0;g=a+4|0;d=b+4|0;f=(c[g>>2]|0)-e|0;h=(c[d>>2]|0)+(0-(f>>2)<<2)|0;c[d>>2]=h;XL(h|0,e|0,f|0)|0;f=c[a>>2]|0;c[a>>2]=c[d>>2];c[d>>2]=f;f=b+8|0;e=c[g>>2]|0;c[g>>2]=c[f>>2];c[f>>2]=e;f=a+8|0;a=b+12|0;e=c[f>>2]|0;c[f>>2]=c[a>>2];c[a>>2]=e;c[b>>2]=c[d>>2];return}function ev(a){a=a|0;var b=0,d=0,e=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0)){do b=b+-4|0;while((b|0)!=(d|0));c[e>>2]=b}b=c[a>>2]|0;if(b)Uz(b);return}function fv(a){a=a|0;Uz(a);return}function gv(a,b){a=a|0;b=b|0;if(!b)return;else{gv(a,c[b>>2]|0);gv(a,c[b+4>>2]|0);IC(b+20|0);Uz(b);return}}function hv(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;i=i+16|0;d=e;c[a+4>>2]=0;c[a>>2]=34488;c[d+4>>2]=0;c[d>>2]=4084;c[d+8>>2]=0;o=0;mb(113,a+8|0,b|0,d|0);a=o;o=0;if(a&1){e=cc()|0;Sd(d);bc(e|0)}else{Sd(d);i=e;return}}function iv(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}a=a+8|0;d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function jv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;c[a>>2]=0;e=a+4|0;c[e>>2]=0;c[a+8>>2]=0;if(b){o=0;ma(215,a|0,b|0);f=o;o=0;if(f&1){f=cc()|0;lv(a);bc(f|0)}a=c[e>>2]|0;do{Pd(a,d);a=(c[e>>2]|0)+12|0;c[e>>2]=a;b=b+-1|0}while((b|0)!=0)}return}function kv(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>357913941)Qz(a);else{d=Sz(b*12|0)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b*12|0);return}}function lv(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-12|0;c[e>>2]=f;_c[c[c[f>>2]>>2]&511](f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function mv(a){a=a|0;c[a>>2]=34488;lv(a+8|0);return}function nv(a){a=a|0;c[a>>2]=34488;lv(a+8|0);Uz(a);return}function ov(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b*12|0)|0;c[a>>2]=e;d=e+(d*12|0)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b*12|0);return}function pv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{d=d+-12|0;Pd((c[g>>2]|0)+-12|0,d);c[g>>2]=(c[g>>2]|0)+-12}while((d|0)!=(e|0));e=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=e;e=b+8|0;d=c[f>>2]|0;c[f>>2]=c[e>>2];c[e>>2]=d;e=a+8|0;a=b+12|0;f=c[e>>2]|0;c[e>>2]=c[a>>2];c[a>>2]=f;c[b>>2]=c[g>>2];return}function qv(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-12|0;c[e>>2]=f;_c[c[c[f>>2]>>2]&511](f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function rv(a){a=a|0;Uz(a);return}function sv(a,b,c){a=a|0;b=b|0;c=c|0;return (c+b+((($(c,b)|0)>>>0)%3|0)&1|0)==0|0}function tv(a){a=a|0;Uz(a);return}function uv(a,b,c){a=a|0;b=b|0;c=c|0;c=$(c,b)|0;return (((c>>>0)%3|0)+c&1|0)==0|0}function vv(a){a=a|0;Uz(a);return}function wv(a,b,c){a=a|0;b=b|0;c=c|0;c=$(c,b)|0;return (c&1|0)==(0-((c>>>0)%3|0)|0)|0}function xv(a){a=a|0;Uz(a);return}function yv(a,b,c){a=a|0;b=b|0;c=c|0;return (((c>>>0)/3|0)+(b>>>1)&1|0)==0|0}function zv(a){a=a|0;Uz(a);return}function Av(a,b,c){a=a|0;b=b|0;c=c|0;return (((c+b|0)>>>0)%3|0|0)==0|0}function Bv(a){a=a|0;Uz(a);return}function Cv(a,b,c){a=a|0;b=b|0;c=c|0;return ((c>>>0)%3|0|0)==0|0}function Dv(a){a=a|0;Uz(a);return}function Ev(a,b,c){a=a|0;b=b|0;c=c|0;return (b&1|0)==0|0}function Fv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function Gv(a,b){a=a|0;b=b|0;c[a>>2]=0;tt(a,c[b>>2]|0);return}function Hv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{d=d+-4|0;Gv((c[g>>2]|0)+-4|0,d);c[g>>2]=(c[g>>2]|0)+-4}while((d|0)!=(e|0));e=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=e;e=b+8|0;d=c[f>>2]|0;c[f>>2]=c[e>>2];c[e>>2]=d;e=a+8|0;a=b+12|0;f=c[e>>2]|0;c[e>>2]=c[a>>2];c[a>>2]=f;c[b>>2]=c[g>>2];return}function Iv(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;vt(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function Jv(a){a=a|0;Uz(a);return}function Kv(a,b,c){a=a|0;b=b|0;c=c|0;return (c+b&1|0)==0|0}function Lv(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>1073741823)Qz(a);else{d=Sz(b<<2)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<2);return}}function Mv(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;b=c[d>>2]|0;do{c[b>>2]=0;pt(b,0);b=(c[d>>2]|0)+4|0;c[d>>2]=b;a=a+-1|0}while((a|0)!=0);return}function Nv(a){a=a|0;c[a>>2]=34228;Sd(a+12|0);return}function Ov(a){a=a|0;c[a>>2]=34228;Sd(a+12|0);Uz(a);return}function Pv(a){a=a|0;At(a);Uz(a);return}function Qv(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;n=i;i=i+16|0;l=n+1|0;m=n;h=b+4|0;g=c[h>>2]|0;b=d+(((g-f|0)/12|0)*12|0)|0;if(b>>>0<e>>>0){j=g;k=b;do{c[j>>2]=0;p=j+4|0;c[p>>2]=0;c[j+8>>2]=0;c[j>>2]=c[k>>2];o=k+4|0;c[p>>2]=c[o>>2];p=k+8|0;c[j+8>>2]=c[p>>2];c[p>>2]=0;c[o>>2]=0;c[k>>2]=0;k=k+12|0;j=(c[h>>2]|0)+12|0;c[h>>2]=j}while(k>>>0<e>>>0)}if((g|0)!=(f|0))do{g=g+-12|0;b=b+-12|0;a[l>>0]=a[m>>0]|0;Rv(g,b,l)}while((b|0)!=(d|0));i=n;return}function Rv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;Xv(a);c[a>>2]=c[b>>2];d=b+4|0;c[a+4>>2]=c[d>>2];e=b+8|0;c[a+8>>2]=c[e>>2];c[e>>2]=0;c[d>>2]=0;c[b>>2]=0;return}function Sv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b*12|0)|0;c[a>>2]=e;d=e+(d*12|0)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b*12|0);return}function Tv(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+48|0;m=q+32|0;l=q+28|0;j=q+8|0;f=q+4|0;g=q;p=b+8|0;e=c[p>>2]|0;h=b+12|0;do if((e|0)==(c[h>>2]|0)){n=b+4|0;o=c[n>>2]|0;k=c[b>>2]|0;if(o>>>0<=k>>>0){e=(e|0)==(k|0)?1:((e-k|0)/12|0)<<1;Sv(j,e,e>>>2,c[b+16>>2]|0);c[f>>2]=c[n>>2];c[g>>2]=c[p>>2];c[l>>2]=c[f>>2];c[m>>2]=c[g>>2];Wv(j,l,m);e=c[b>>2]|0;c[b>>2]=c[j>>2];c[j>>2]=e;e=j+4|0;o=c[n>>2]|0;c[n>>2]=c[e>>2];c[e>>2]=o;e=j+8|0;o=c[p>>2]|0;c[p>>2]=c[e>>2];c[e>>2]=o;e=j+12|0;o=c[h>>2]|0;c[h>>2]=c[e>>2];c[e>>2]=o;Vv(j);e=c[p>>2]|0;break}b=o;h=(((b-k|0)/12|0)+1|0)/-2|0;j=e;if((o|0)!=(e|0)){f=o+(h*12|0)|0;g=o;while(1){a[m>>0]=a[l>>0]|0;Rv(f,g,m);g=g+12|0;if((g|0)==(e|0))break;else f=f+12|0}}e=o+(((((j-b|0)>>>0)/12|0)+h|0)*12|0)|0;c[p>>2]=e;c[n>>2]=(c[n>>2]|0)+(h*12|0)}while(0);c[e>>2]=0;n=e+4|0;c[n>>2]=0;c[e+8>>2]=0;c[e>>2]=c[d>>2];o=d+4|0;c[n>>2]=c[o>>2];n=d+8|0;c[e+8>>2]=c[n>>2];c[n>>2]=0;c[o>>2]=0;c[d>>2]=0;c[p>>2]=(c[p>>2]|0)+12;i=q;return}function Uv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;i=b+4|0;j=c[i>>2]|0;f=c[a>>2]|0;if((f|0)!=(d|0)){e=d;g=j;do{h=g+-12|0;k=e;e=e+-12|0;c[h>>2]=0;l=g+-8|0;c[l>>2]=0;c[g+-4>>2]=0;c[h>>2]=c[e>>2];h=k+-8|0;c[l>>2]=c[h>>2];k=k+-4|0;c[g+-4>>2]=c[k>>2];c[k>>2]=0;c[h>>2]=0;c[e>>2]=0;g=(c[i>>2]|0)+-12|0;c[i>>2]=g}while((e|0)!=(f|0))}f=a+4|0;g=c[f>>2]|0;h=b+8|0;if((g|0)!=(d|0)){e=d;do{d=c[h>>2]|0;c[d>>2]=0;k=d+4|0;c[k>>2]=0;c[d+8>>2]=0;c[d>>2]=c[e>>2];l=e+4|0;c[k>>2]=c[l>>2];k=e+8|0;c[d+8>>2]=c[k>>2];c[k>>2]=0;c[l>>2]=0;c[e>>2]=0;e=e+12|0;c[h>>2]=(c[h>>2]|0)+12}while((e|0)!=(g|0))}l=c[a>>2]|0;c[a>>2]=c[i>>2];c[i>>2]=l;l=c[f>>2]|0;c[f>>2]=c[h>>2];c[h>>2]=l;a=a+8|0;l=b+12|0;k=c[a>>2]|0;c[a>>2]=c[l>>2];c[l>>2]=k;c[b>>2]=c[i>>2];return j|0}function Vv(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-12|0;c[e>>2]=f;br(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function Wv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[d>>2]|0;a=a+8|0;d=c[b>>2]|0;if((d|0)!=(e|0))do{h=c[a>>2]|0;c[h>>2]=0;g=h+4|0;c[g>>2]=0;c[h+8>>2]=0;c[h>>2]=c[d>>2];f=d+4|0;c[g>>2]=c[f>>2];g=d+8|0;c[h+8>>2]=c[g>>2];c[g>>2]=0;c[f>>2]=0;c[d>>2]=0;c[a>>2]=(c[a>>2]|0)+12;d=d+12|0;c[b>>2]=d}while((d|0)!=(e|0));return}function Xv(a){a=a|0;var b=0,d=0,e=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0)){do b=b+-4|0;while((b|0)!=(d|0));c[e>>2]=b}Uz(d);c[a+8>>2]=0;c[e>>2]=0;c[a>>2]=0}return}function Yv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function Zv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;e=c[a>>2]|0;g=a+4|0;d=b+4|0;f=(c[g>>2]|0)-e|0;h=(c[d>>2]|0)+(0-(f>>2)<<2)|0;c[d>>2]=h;XL(h|0,e|0,f|0)|0;f=c[a>>2]|0;c[a>>2]=c[d>>2];c[d>>2]=f;f=b+8|0;e=c[g>>2]|0;c[g>>2]=c[f>>2];c[f>>2]=e;f=a+8|0;a=b+12|0;e=c[f>>2]|0;c[f>>2]=c[a>>2];c[a>>2]=e;c[b>>2]=c[d>>2];return}function _v(a){a=a|0;var b=0,d=0,e=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0)){do b=b+-4|0;while((b|0)!=(d|0));c[e>>2]=b}b=c[a>>2]|0;if(b)Uz(b);return}function $v(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+32|0;j=k;f=c[a+8>>2]|0;h=a+4|0;d=c[h>>2]|0;if(((f-d|0)/12|0)>>>0<b>>>0){e=c[a>>2]|0;g=((d-e|0)/12|0)+b|0;if(g>>>0>357913941)Qz(a);d=(f-e|0)/12|0;if(d>>>0<178956970){d=d<<1;d=d>>>0<g>>>0?g:d}else d=357913941;cw(j,d,((c[h>>2]|0)-e|0)/12|0,a+8|0);dw(j,b);ew(a,j);fw(j)}else bw(a,b);i=k;return}function aw(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-12|0;c[e>>2]=f;gt(f);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function bw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=a+4|0;d=c[e>>2]|0;a=b;f=d;while(1){c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;a=a+-1|0;if(!a)break;else f=f+12|0}c[e>>2]=d+(b*12|0);return}function cw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b*12|0)|0;c[a>>2]=e;d=e+(d*12|0)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b*12|0);return}function dw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=a+8|0;d=c[e>>2]|0;a=b;f=d;while(1){c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;a=a+-1|0;if(!a)break;else f=f+12|0}c[e>>2]=d+(b*12|0);return}function ew(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{j=c[g>>2]|0;h=j+-12|0;i=d;d=d+-12|0;c[h>>2]=0;k=j+-8|0;c[k>>2]=0;c[j+-4>>2]=0;c[h>>2]=c[d>>2];h=i+-8|0;c[k>>2]=c[h>>2];i=i+-4|0;c[j+-4>>2]=c[i>>2];c[i>>2]=0;c[h>>2]=0;c[d>>2]=0;c[g>>2]=(c[g>>2]|0)+-12}while((d|0)!=(e|0));i=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=i;i=b+8|0;k=c[f>>2]|0;c[f>>2]=c[i>>2];c[i>>2]=k;i=a+8|0;k=b+12|0;j=c[i>>2]|0;c[i>>2]=c[k>>2];c[k>>2]=j;c[b>>2]=c[g>>2];return}function fw(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-12|0;c[e>>2]=f;aw(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function gw(a,b){a=a|0;b=b|0;if(!b)return;else{gw(a,c[b>>2]|0);gw(a,c[b+4>>2]|0);Uz(b);return}}function hw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;a=a+4|0;e=c[a>>2]|0;do if(e){f=c[d>>2]|0;while(1){a=c[e+16>>2]|0;if((f|0)<(a|0)){a=c[e>>2]|0;if(!a){a=e;d=5;break}}else{if((a|0)>=(f|0)){a=e;d=10;break}a=e+4|0;d=c[a>>2]|0;if(!d){d=9;break}else a=d}e=a}if((d|0)==5){c[b>>2]=e;break}else if((d|0)==9){c[b>>2]=e;break}else if((d|0)==10){c[b>>2]=a;a=b;break}}else c[b>>2]=a;while(0);return a|0}function iw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=Sz(24)|0;c[e+16>>2]=c[d>>2];c[e+20>>2]=0;c[a>>2]=e;a=a+4|0;c[a>>2]=b+4;c[a+4>>2]=257;return}function jw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=b;c[d>>2]=e;b=c[a>>2]|0;if(c[b>>2]|0){c[a>>2]=c[b>>2];e=c[d>>2]|0}kw(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1;return}function kw(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;a[d+12>>0]=(d|0)==(b|0)&1;a:do if((d|0)!=(b|0)){while(1){e=c[d+8>>2]|0;i=e+12|0;if(a[i>>0]|0)break a;f=e+8|0;h=d;d=c[f>>2]|0;g=c[d>>2]|0;if((g|0)==(e|0)){g=c[d+4>>2]|0;if(!g){g=h;h=7;break}g=g+12|0;if(a[g>>0]|0){g=h;h=7;break}a[i>>0]=1;a[d+12>>0]=(d|0)==(b|0)&1;a[g>>0]=1}else{if(!g){g=h;h=14;break}g=g+12|0;if(a[g>>0]|0){g=h;h=14;break}a[i>>0]=1;a[d+12>>0]=(d|0)==(b|0)&1;a[g>>0]=1}if((d|0)==(b|0))break a}if((h|0)==7){if((c[e>>2]|0)!=(g|0)){lw(e);d=c[f>>2]|0;e=d;d=c[d+8>>2]|0}a[e+12>>0]=1;a[d+12>>0]=0;mw(d);break}else if((h|0)==14){if((c[e>>2]|0)==(g|0)){mw(e);d=c[f>>2]|0;e=d;d=c[d+8>>2]|0}a[e+12>>0]=1;a[d+12>>0]=0;lw(d);break}}while(0);return}function lw(a){a=a|0;var b=0,d=0,e=0;d=a+4|0;e=c[d>>2]|0;b=c[e>>2]|0;c[d>>2]=b;if(b)c[b+8>>2]=a;b=a+8|0;c[e+8>>2]=c[b>>2];d=c[b>>2]|0;if((c[d>>2]|0)==(a|0))c[d>>2]=e;else c[d+4>>2]=e;c[e>>2]=a;c[b>>2]=e;return}function mw(a){a=a|0;var b=0,d=0,e=0,f=0;e=c[a>>2]|0;f=e+4|0;b=c[f>>2]|0;c[a>>2]=b;if(b)c[b+8>>2]=a;b=a+8|0;c[e+8>>2]=c[b>>2];d=c[b>>2]|0;if((c[d>>2]|0)==(a|0))c[d>>2]=e;else c[d+4>>2]=e;c[f>>2]=a;c[b>>2]=e;return}function nw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+32|0;j=k;f=c[a+8>>2]|0;h=a+4|0;d=c[h>>2]|0;if(((f-d|0)/12|0)>>>0<b>>>0){e=c[a>>2]|0;g=((d-e|0)/12|0)+b|0;if(g>>>0>357913941)Qz(a);d=(f-e|0)/12|0;if(d>>>0<178956970){d=d<<1;d=d>>>0<g>>>0?g:d}else d=357913941;pw(j,d,((c[h>>2]|0)-e|0)/12|0,a+8|0);f=j+8|0;e=c[f>>2]|0;d=b;g=e;while(1){c[g+4>>2]=0;c[g+8>>2]=0;c[g>>2]=g+4;d=d+-1|0;if(!d)break;else g=g+12|0}c[f>>2]=e+(b*12|0);qw(a,j);rw(j)}else ow(a,b);i=k;return}function ow(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;b=c[d>>2]|0;do{c[b+4>>2]=0;c[b+8>>2]=0;c[b>>2]=b+4;b=(c[d>>2]|0)+12|0;c[d>>2]=b;a=a+-1|0}while((a|0)!=0);return}function pw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b*12|0)|0;c[a>>2]=e;d=e+(d*12|0)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b*12|0);return}function qw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{d=d+-12|0;sw((c[g>>2]|0)+-12|0,d);c[g>>2]=(c[g>>2]|0)+-12}while((d|0)!=(e|0));e=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=e;e=b+8|0;d=c[f>>2]|0;c[f>>2]=c[e>>2];c[e>>2]=d;e=a+8|0;a=b+12|0;f=c[e>>2]|0;c[e>>2]=c[a>>2];c[a>>2]=f;c[b>>2]=c[g>>2];return}function rw(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-12|0;c[e>>2]=f;gt(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function sw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;c[a>>2]=c[b>>2];d=c[b+4>>2]|0;c[a+4>>2]=d;e=b+8|0;g=c[e>>2]|0;c[a+8>>2]=g;f=a+4|0;if(!g)c[a>>2]=f;else{c[d+8>>2]=f;g=b+4|0;c[b>>2]=g;c[g>>2]=0;c[e>>2]=0}return}function tw(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>357913941)Qz(a);else{d=Sz(b*12|0)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b*12|0);return}}function uw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;l=i;i=i+32|0;k=l;h=c[a+8>>2]|0;j=a+4|0;e=c[j>>2]|0;f=e;if(h-f>>2>>>0<b>>>0){e=c[a>>2]|0;f=(f-e>>2)+b|0;if(f>>>0>1073741823)Qz(a);g=e;e=h-g|0;if(e>>2>>>0<536870911){e=e>>1;e=e>>>0<f>>>0?f:e}else e=1073741823;vw(k,e,(c[j>>2]|0)-g>>2,a+8|0);f=k+8|0;e=c[f>>2]|0;g=e+(b<<2)|0;while(1){c[e>>2]=c[d>>2];b=b+-1|0;if(!b)break;else e=e+4|0}c[f>>2]=g;ww(a,k);xw(k)}else{f=e+(b<<2)|0;while(1){c[e>>2]=c[d>>2];b=b+-1|0;if(!b)break;else e=e+4|0}c[j>>2]=f}i=l;return}function vw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function ww(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;e=c[a>>2]|0;g=a+4|0;d=b+4|0;f=(c[g>>2]|0)-e|0;h=(c[d>>2]|0)+(0-(f>>2)<<2)|0;c[d>>2]=h;XL(h|0,e|0,f|0)|0;f=c[a>>2]|0;c[a>>2]=c[d>>2];c[d>>2]=f;f=b+8|0;e=c[g>>2]|0;c[g>>2]=c[f>>2];c[f>>2]=e;f=a+8|0;a=b+12|0;e=c[f>>2]|0;c[f>>2]=c[a>>2];c[a>>2]=e;c[b>>2]=c[d>>2];return}function xw(a){a=a|0;var b=0,d=0,e=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0)){do b=b+-4|0;while((b|0)!=(d|0));c[e>>2]=b}b=c[a>>2]|0;if(b)Uz(b);return}function yw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+32|0;j=k;f=c[a+8>>2]|0;h=a+4|0;d=c[h>>2]|0;if(((f-d|0)/12|0)>>>0<b>>>0){e=c[a>>2]|0;g=((d-e|0)/12|0)+b|0;if(g>>>0>357913941)Qz(a);d=(f-e|0)/12|0;if(d>>>0<178956970){d=d<<1;d=d>>>0<g>>>0?g:d}else d=357913941;Sv(j,d,((c[h>>2]|0)-e|0)/12|0,a+8|0);Aw(j,b);Bw(a,j);Vv(j)}else zw(a,b);i=k;return}function zw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=a+4|0;d=c[e>>2]|0;a=b;f=d;while(1){c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;a=a+-1|0;if(!a)break;else f=f+12|0}c[e>>2]=d+(b*12|0);return}function Aw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=a+8|0;d=c[e>>2]|0;a=b;f=d;while(1){c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;a=a+-1|0;if(!a)break;else f=f+12|0}c[e>>2]=d+(b*12|0);return}function Bw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{j=c[g>>2]|0;h=j+-12|0;i=d;d=d+-12|0;c[h>>2]=0;k=j+-8|0;c[k>>2]=0;c[j+-4>>2]=0;c[h>>2]=c[d>>2];h=i+-8|0;c[k>>2]=c[h>>2];i=i+-4|0;c[j+-4>>2]=c[i>>2];c[i>>2]=0;c[h>>2]=0;c[d>>2]=0;c[g>>2]=(c[g>>2]|0)+-12}while((d|0)!=(e|0));i=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=i;i=b+8|0;k=c[f>>2]|0;c[f>>2]=c[i>>2];c[i>>2]=k;i=a+8|0;k=b+12|0;j=c[i>>2]|0;c[i>>2]=c[k>>2];c[k>>2]=j;c[b>>2]=c[g>>2];return}function Cw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;l=i;i=i+32|0;k=l;h=c[a+8>>2]|0;j=a+4|0;g=c[j>>2]|0;f=g;if(h-f>>2>>>0<b>>>0){e=c[a>>2]|0;f=(f-e>>2)+b|0;if(f>>>0>1073741823)Qz(a);g=e;e=h-g|0;if(e>>2>>>0<536870911){e=e>>1;e=e>>>0<f>>>0?f:e}else e=1073741823;Yv(k,e,(c[j>>2]|0)-g>>2,a+8|0);g=k+8|0;f=c[g>>2]|0;e=b;h=f;while(1){c[h>>2]=c[d>>2];e=e+-1|0;if(!e)break;else h=h+4|0}c[g>>2]=f+(b<<2);Zv(a,k);_v(k)}else{e=b;f=g;while(1){c[f>>2]=c[d>>2];e=e+-1|0;if(!e)break;else f=f+4|0}c[j>>2]=g+(b<<2)}i=l;return}function Dw(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>357913941)Qz(a);else{d=Sz(b*12|0)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b*12|0);return}}function Ew(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>1073741823)Qz(a);else{d=Sz(b<<2)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<2);return}}function Fw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+32|0;j=k;g=c[a+8>>2]|0;h=a+4|0;d=c[h>>2]|0;e=d;if(g-e>>2>>>0<b>>>0){d=c[a>>2]|0;e=(e-d>>2)+b|0;if(e>>>0>1073741823)Qz(a);f=d;d=g-f|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<e>>>0?e:d}else d=1073741823;vw(j,d,(c[h>>2]|0)-f>>2,a+8|0);h=j+8|0;g=c[h>>2]|0;ZL(g|0,0,b<<2|0)|0;c[h>>2]=g+(b<<2);ww(a,j);xw(j)}else{ZL(d|0,0,b<<2|0)|0;c[h>>2]=d+(b<<2)}i=k;return}function Gw(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>357913941)Qz(a);else{d=Sz(b*12|0)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b*12|0);return}}function Hw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=a+4|0;d=c[e>>2]|0;a=b;f=d;while(1){c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;a=a+-1|0;if(!a)break;else f=f+12|0}c[e>>2]=d+(b*12|0);return}function Iw(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>1073741823)Qz(a);else{d=Sz(b<<2)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<2);return}}function Jw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;g=b;h=d-g>>2;e=a+8|0;i=c[a>>2]|0;f=i;do if(h>>>0>(c[e>>2]|0)-f>>2>>>0){Xv(a);if(h>>>0>1073741823)Qz(a);e=(c[e>>2]|0)-(c[a>>2]|0)|0;if(e>>2>>>0<536870911){e=e>>1;e=e>>>0<h>>>0?h:e}else e=1073741823;Iw(a,e);f=a+4|0;if((b|0)!=(d|0)){e=c[f>>2]|0;do{c[e>>2]=c[b>>2];e=e+4|0;b=b+4|0}while((b|0)!=(d|0));c[f>>2]=e}}else{a=a+4|0;e=(c[a>>2]|0)-f>>2;h=h>>>0>e>>>0;e=h?b+(e<<2)|0:d;g=e-g|0;YL(i|0,b|0,g|0)|0;b=i+(g>>2<<2)|0;if(!h){e=c[a>>2]|0;if((e|0)==(b|0))break;do e=e+-4|0;while((e|0)!=(b|0));c[a>>2]=e;break}if((e|0)!=(d|0)){b=e;e=c[a>>2]|0;do{c[e>>2]=c[b>>2];e=e+4|0;b=b+4|0}while((b|0)!=(d|0));c[a>>2]=e}}while(0);return}function Kw(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>1073741823)Qz(a);else{d=Sz(b<<2)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<2);return}}function Lw(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;b=c[d>>2]|0;do{c[b>>2]=0;Ls(b,0);b=(c[d>>2]|0)+4|0;c[d>>2]=b;a=a+-1|0}while((a|0)!=0);return}function Mw(a){a=a|0;Uz(a);return}function Nw(a){a=a|0;Fs(a);Uz(a);return}function Ow(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;i=i+16|0;d=e;c[a+4>>2]=0;c[a>>2]=34520;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;o=0;mb(114,a+8|0,b|0,d|0);a=o;o=0;if(a&1){e=cc()|0;Ds(d+4|0);bc(e|0)}else{Ds(d+4|0);i=e;return}}function Pw(a,b){a=a|0;b=b|0;var d=0;if(b){d=b+4|0;c[d>>2]=(c[d>>2]|0)+1}a=a+8|0;d=c[a>>2]|0;if(d)ye(d);c[a>>2]=b;return}function Qw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;c[a>>2]=0;f=a+4|0;c[f>>2]=0;c[a+8>>2]=0;a:do if(b){o=0;ma(216,a|0,b|0);e=o;o=0;if(e&1)b=cc()|0;else{e=c[f>>2]|0;while(1){o=0;ma(217,e|0,d|0);e=o;o=0;if(e&1)break;e=(c[f>>2]|0)+16|0;c[f>>2]=e;b=b+-1|0;if(!b)break a}b=cc()|0}Sw(a);bc(b|0)}while(0);return}function Rw(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>268435455)Qz(a);else{d=Sz(b<<4)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<4);return}}function Sw(a){a=a|0;var b=0,d=0,e=0;d=c[a>>2]|0;if(d){e=a+4|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{c[e>>2]=b+-16;Ds(b+-12|0);b=c[e>>2]|0}while((b|0)!=(d|0));Uz(c[a>>2]|0)}return}function Tw(a){a=a|0;c[a>>2]=34520;Sw(a+8|0);return}function Uw(a){a=a|0;c[a>>2]=34520;Sw(a+8|0);Uz(a);return}function Vw(a){a=a|0;Is(a);Uz(a);return}function Ww(a){a=a|0;Uz(a);return}function Xw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function Yw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{d=d+-4|0;Bs((c[g>>2]|0)+-4|0,d);c[g>>2]=(c[g>>2]|0)+-4}while((d|0)!=(e|0));e=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=e;e=b+8|0;d=c[f>>2]|0;c[f>>2]=c[e>>2];c[e>>2]=d;e=a+8|0;a=b+12|0;f=c[e>>2]|0;c[e>>2]=c[a>>2];c[a>>2]=f;c[b>>2]=c[g>>2];return}function Zw(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;zs(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function _w(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function $w(a,b){a=a|0;b=b|0;c[a>>2]=0;ts(a,c[b>>2]|0);return}function ax(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{d=d+-4|0;$w((c[g>>2]|0)+-4|0,d);c[g>>2]=(c[g>>2]|0)+-4}while((d|0)!=(e|0));e=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=e;e=b+8|0;d=c[f>>2]|0;c[f>>2]=c[e>>2];c[e>>2]=d;e=a+8|0;a=b+12|0;f=c[e>>2]|0;c[e>>2]=c[a>>2];c[a>>2]=f;c[b>>2]=c[g>>2];return}function bx(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;vs(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function cx(a){a=a|0;Aq(a);Uz(a);return}function dx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function ex(a,b){a=a|0;b=b|0;c[a>>2]=0;Me(a,c[b>>2]|0);return}function fx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{d=d+-4|0;ex((c[g>>2]|0)+-4|0,d);c[g>>2]=(c[g>>2]|0)+-4}while((d|0)!=(e|0));e=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=e;e=b+8|0;d=c[f>>2]|0;c[f>>2]=c[e>>2];c[e>>2]=d;e=a+8|0;a=b+12|0;f=c[e>>2]|0;c[e>>2]=c[a>>2];c[a>>2]=f;c[b>>2]=c[g>>2];return}function gx(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;de(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function hx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function ix(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{d=d+-4|0;Pe((c[g>>2]|0)+-4|0,d);c[g>>2]=(c[g>>2]|0)+-4}while((d|0)!=(e|0));e=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=e;e=b+8|0;d=c[f>>2]|0;c[f>>2]=c[e>>2];c[e>>2]=d;e=a+8|0;a=b+12|0;f=c[e>>2]|0;c[e>>2]=c[a>>2];c[a>>2]=f;c[b>>2]=c[g>>2];return}function jx(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;be(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function kx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function lx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{d=d+-4|0;es((c[g>>2]|0)+-4|0,d);c[g>>2]=(c[g>>2]|0)+-4}while((d|0)!=(e|0));e=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=e;e=b+8|0;d=c[f>>2]|0;c[f>>2]=c[e>>2];c[e>>2]=d;e=a+8|0;a=b+12|0;f=c[e>>2]|0;c[e>>2]=c[a>>2];c[a>>2]=f;c[b>>2]=c[g>>2];return}function mx(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;fs(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function nx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+48|0;s=t+40|0;f=t+36|0;g=t+32|0;j=t+28|0;k=t+24|0;n=t+20|0;p=t+16|0;l=t+12|0;m=t+8|0;q=t+4|0;r=t;h=c[e>>2]|0;es(f,b);es(g,a);o=0;h=Wa(h|0,f|0,g|0)|0;u=o;o=0;a:do if(u&1){u=cc()|0;fs(g);fs(f);f=u}else{fs(g);fs(f);f=c[e>>2]|0;do if(h){es(l,d);es(m,b);o=0;f=Wa(f|0,l|0,m|0)|0;u=o;o=0;if(u&1){f=cc()|0;fs(m);fs(l);break a}fs(m);fs(l);if(f){es(s,a);hs(a,c[d>>2]|0);hs(d,c[s>>2]|0);fs(s);f=1;break}es(s,a);hs(a,c[b>>2]|0);hs(b,c[s>>2]|0);fs(s);f=c[e>>2]|0;es(q,d);es(r,b);o=0;f=Wa(f|0,q|0,r|0)|0;u=o;o=0;if(u&1){f=cc()|0;fs(r);fs(q);break a}fs(r);fs(q);if(f){es(s,b);hs(b,c[d>>2]|0);hs(d,c[s>>2]|0);fs(s);f=2}else f=1}else{es(j,d);es(k,b);o=0;f=Wa(f|0,j|0,k|0)|0;u=o;o=0;if(u&1){f=cc()|0;fs(k);fs(j);break a}fs(k);fs(j);if(f){es(s,b);hs(b,c[d>>2]|0);hs(d,c[s>>2]|0);fs(s);f=c[e>>2]|0;es(n,b);es(p,a);o=0;f=Wa(f|0,n|0,p|0)|0;u=o;o=0;if(u&1){f=cc()|0;fs(p);fs(n);break a}fs(p);fs(n);if(f){es(s,a);hs(a,c[b>>2]|0);hs(b,c[s>>2]|0);fs(s);f=2}else f=1}else f=0}while(0);i=t;return f|0}while(0);bc(f|0);return 0}function ox(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;r=i;i=i+32|0;q=r+24|0;g=r+20|0;h=r+16|0;k=r+12|0;l=r+8|0;m=r+4|0;n=r;p=nx(a,b,d,f)|0;j=c[f>>2]|0;es(g,e);es(h,d);o=0;j=Wa(j|0,g|0,h|0)|0;s=o;o=0;do if(s&1){s=cc()|0;fs(h);fs(g);g=s}else{fs(h);fs(g);if(j){es(q,d);hs(d,c[e>>2]|0);hs(e,c[q>>2]|0);fs(q);h=c[f>>2]|0;es(k,d);es(l,b);o=0;h=Wa(h|0,k|0,l|0)|0;s=o;o=0;if(s&1){g=cc()|0;fs(l);fs(k);break}g=p+1|0;fs(l);fs(k);if(h){es(q,b);hs(b,c[d>>2]|0);hs(d,c[q>>2]|0);fs(q);g=c[f>>2]|0;es(m,b);es(n,a);o=0;g=Wa(g|0,m|0,n|0)|0;s=o;o=0;if(s&1){g=cc()|0;fs(n);fs(m);break}fs(n);fs(m);if(g){es(q,a);hs(a,c[b>>2]|0);hs(b,c[q>>2]|0);fs(q);g=p+3|0}else g=p+2|0}}else g=p;i=r;return g|0}while(0);bc(g|0);return 0}function px(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;u=i;i=i+48|0;t=u+32|0;h=u+28|0;j=u+24|0;l=u+20|0;m=u+16|0;n=u+12|0;p=u+8|0;q=u+4|0;r=u;s=ox(a,b,d,e,g)|0;k=c[g>>2]|0;es(h,f);es(j,e);o=0;k=Wa(k|0,h|0,j|0)|0;v=o;o=0;do if(v&1){v=cc()|0;fs(j);fs(h);h=v}else{fs(j);fs(h);if(k){es(t,e);hs(e,c[f>>2]|0);hs(f,c[t>>2]|0);fs(t);j=c[g>>2]|0;es(l,e);es(m,d);o=0;j=Wa(j|0,l|0,m|0)|0;v=o;o=0;if(v&1){h=cc()|0;fs(m);fs(l);break}h=s+1|0;fs(m);fs(l);if(j){es(t,d);hs(d,c[e>>2]|0);hs(e,c[t>>2]|0);fs(t);j=c[g>>2]|0;es(n,d);es(p,b);o=0;j=Wa(j|0,n|0,p|0)|0;v=o;o=0;if(v&1){h=cc()|0;fs(p);fs(n);break}h=s+2|0;fs(p);fs(n);if(j){es(t,b);hs(b,c[d>>2]|0);hs(d,c[t>>2]|0);fs(t);h=c[g>>2]|0;es(q,b);es(r,a);o=0;h=Wa(h|0,q|0,r|0)|0;v=o;o=0;if(v&1){h=cc()|0;fs(r);fs(q);break}fs(r);fs(q);if(h){es(t,a);hs(a,c[b>>2]|0);hs(b,c[t>>2]|0);fs(t);h=s+4|0}else h=s+3|0}}}else h=s;i=u;return h|0}while(0);bc(h|0);return 0}function qx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;q=i;i=i+32|0;k=q+16|0;l=q+12|0;p=q+8|0;m=q+4|0;n=q;f=a+8|0;nx(a,a+4|0,f,d)|0;e=a+12|0;a:do if((e|0)!=(b|0)){j=e;b:while(1){e=c[d>>2]|0;es(k,j);es(l,f);o=0;e=Wa(e|0,k|0,l|0)|0;h=o;o=0;if(h&1){r=10;break}fs(l);fs(k);if(e){es(p,j);e=j;while(1){hs(e,c[f>>2]|0);if((f|0)==(a|0)){r=6;break}h=c[d>>2]|0;c[m>>2]=0;e=c[p>>2]|0;hs(m,e);g=f+-4|0;es(n,g);o=0;h=Wa(h|0,m|0,n|0)|0;s=o;o=0;if(s&1){r=11;break b}fs(n);fs(m);if(h){e=f;f=g}else break}if((r|0)==6){r=0;e=c[p>>2]|0;f=a}hs(f,e);fs(p)}e=j+4|0;if((e|0)==(b|0))break a;else{f=j;j=e}}if((r|0)==10){e=cc()|0;fs(l);fs(k)}else if((r|0)==11){e=cc()|0;fs(n);fs(m);fs(p)}bc(e|0)}while(0);i=q;return}function rx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+32|0;j=t+28|0;g=t+24|0;h=t+20|0;m=t+16|0;n=t+12|0;r=t+8|0;p=t+4|0;q=t;a:do switch(b-a>>2|0){case 1:case 0:{e=1;s=21;break}case 2:{f=c[d>>2]|0;e=b+-4|0;es(g,e);es(h,a);o=0;f=Wa(f|0,g|0,h|0)|0;s=o;o=0;if(s&1){e=cc()|0;fs(h);fs(g);s=22;break a}fs(h);fs(g);if(f){es(j,a);hs(a,c[e>>2]|0);hs(e,c[j>>2]|0);fs(j);e=1;s=21}else{e=1;s=21}break}case 3:{nx(a,a+4|0,b+-4|0,d)|0;e=1;s=21;break}case 4:{ox(a,a+4|0,a+8|0,b+-4|0,d)|0;e=1;s=21;break}case 5:{px(a,a+4|0,a+8|0,a+12|0,b+-4|0,d)|0;e=1;s=21;break}default:{g=a+8|0;nx(a,a+4|0,g,d)|0;f=a+12|0;if((f|0)!=(b|0)){e=0;l=0;b:while(1){h=c[d>>2]|0;es(m,f);es(n,g);o=0;h=Wa(h|0,m|0,n|0)|0;k=o;o=0;if(k&1){s=18;break}fs(n);fs(m);if(h){es(r,f);h=f;while(1){hs(h,c[g>>2]|0);if((g|0)==(a|0)){s=14;break}k=c[d>>2]|0;c[p>>2]=0;h=c[r>>2]|0;hs(p,h);j=g+-4|0;es(q,j);o=0;k=Wa(k|0,p|0,q|0)|0;u=o;o=0;if(u&1){s=19;break b}fs(q);fs(p);if(k){h=g;g=j}else break}if((s|0)==14){s=0;h=c[r>>2]|0;g=a}hs(g,h);g=l+1|0;j=(g|0)==8;k=f+4|0;e=j?(k|0)==(b|0):e;fs(r);if(j){s=21;break a}else{h=g;g=j?k:f}}else{h=l;g=f}f=g+4|0;if((f|0)==(b|0)){e=1;s=21;break a}else l=h}if((s|0)==18){e=cc()|0;fs(n);fs(m);s=22;break a}else if((s|0)==19){e=cc()|0;fs(q);fs(p);fs(r);s=22;break a}}else{e=1;s=21}}}while(0);if((s|0)==21){i=t;return e|0}else if((s|0)==22)bc(e|0);return 0}function sx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b*12|0)|0;c[a>>2]=e;d=e+(d*12|0)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b*12|0);return}function tx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{j=c[g>>2]|0;h=j+-12|0;i=d;d=d+-12|0;c[h>>2]=0;k=j+-8|0;c[k>>2]=0;c[j+-4>>2]=0;c[h>>2]=c[d>>2];h=i+-8|0;c[k>>2]=c[h>>2];i=i+-4|0;c[j+-4>>2]=c[i>>2];c[i>>2]=0;c[h>>2]=0;c[d>>2]=0;c[g>>2]=(c[g>>2]|0)+-12}while((d|0)!=(e|0));i=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=i;i=b+8|0;k=c[f>>2]|0;c[f>>2]=c[i>>2];c[i>>2]=k;i=a+8|0;k=b+12|0;j=c[i>>2]|0;c[i>>2]=c[k>>2];c[k>>2]=j;c[b>>2]=c[g>>2];return}function ux(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-12|0;c[e>>2]=f;Zr(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function vx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function wx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{d=d+-4|0;Rr((c[g>>2]|0)+-4|0,d);c[g>>2]=(c[g>>2]|0)+-4}while((d|0)!=(e|0));e=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=e;e=b+8|0;d=c[f>>2]|0;c[f>>2]=c[e>>2];c[e>>2]=d;e=a+8|0;a=b+12|0;f=c[e>>2]|0;c[e>>2]=c[a>>2];c[a>>2]=f;c[b>>2]=c[g>>2];return}function xx(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;Tr(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function yx(a,b,d){a=a|0;b=b|0;d=d|0;a=a+4|0;if((b|0)!=(d|0))do{es(c[a>>2]|0,b);c[a>>2]=(c[a>>2]|0)+4;b=b+4|0}while((b|0)!=(d|0));return}function zx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function Ax(a,b){a=a|0;b=b|0;c[a>>2]=0;Hr(a,c[b>>2]|0);return}function Bx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{d=d+-4|0;Ax((c[g>>2]|0)+-4|0,d);c[g>>2]=(c[g>>2]|0)+-4}while((d|0)!=(e|0));e=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=e;e=b+8|0;d=c[f>>2]|0;c[f>>2]=c[e>>2];c[e>>2]=d;e=a+8|0;a=b+12|0;f=c[e>>2]|0;c[e>>2]=c[a>>2];c[a>>2]=f;c[b>>2]=c[g>>2];return}function Cx(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;ir(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function Dx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function Ex(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=c[a>>2]|0;f=a+4|0;d=c[f>>2]|0;g=b+4|0;if((d|0)!=(e|0))do{d=d+-4|0;lr((c[g>>2]|0)+-4|0,d);c[g>>2]=(c[g>>2]|0)+-4}while((d|0)!=(e|0));e=c[a>>2]|0;c[a>>2]=c[g>>2];c[g>>2]=e;e=b+8|0;d=c[f>>2]|0;c[f>>2]=c[e>>2];c[e>>2]=d;e=a+8|0;a=b+12|0;f=c[e>>2]|0;c[e>>2]=c[a>>2];c[a>>2]=f;c[b>>2]=c[g>>2];return}function Fx(a){a=a|0;var b=0,d=0,e=0,f=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0))do{f=b+-4|0;c[e>>2]=f;kr(f);b=c[e>>2]|0}while((b|0)!=(d|0));b=c[a>>2]|0;if(b)Uz(b);return}function Gx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+(b<<2);return}function Hx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;e=c[a>>2]|0;g=a+4|0;d=b+4|0;f=(c[g>>2]|0)-e|0;h=(c[d>>2]|0)+(0-(f>>2)<<2)|0;c[d>>2]=h;XL(h|0,e|0,f|0)|0;f=c[a>>2]|0;c[a>>2]=c[d>>2];c[d>>2]=f;f=b+8|0;e=c[g>>2]|0;c[g>>2]=c[f>>2];c[f>>2]=e;f=a+8|0;a=b+12|0;e=c[f>>2]|0;c[f>>2]=c[a>>2];c[a>>2]=e;c[b>>2]=c[d>>2];return}function Ix(a){a=a|0;var b=0,d=0,e=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0)){do b=b+-4|0;while((b|0)!=(d|0));c[e>>2]=b}b=c[a>>2]|0;if(b)Uz(b);return}function Jx(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>1073741823)Qz(a);else{d=Sz(b<<2)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<2);return}}function Kx(a,b){a=a|0;b=b|0;if(!b)return;else{Kx(a,c[b>>2]|0);Kx(a,c[b+4>>2]|0);uq(b+16|0);Uz(b);return}}function Lx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;c[a>>2]=0;e=a+4|0;c[e>>2]=0;c[a+8>>2]=0;if(b){o=0;ma(196,a|0,b|0);f=o;o=0;if(f&1){f=cc()|0;wq(a);bc(f|0)}a=c[e>>2]|0;do{tq(a,d);a=(c[e>>2]|0)+4|0;c[e>>2]=a;b=b+-1|0}while((b|0)!=0)}return}function Mx(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>1073741823)Qz(a);else{d=Sz(b<<2)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<2);return}}function Nx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+16|0;g=h+12|0;f=h;e=Ox(a,g,b)|0;d=c[e>>2]|0;if(!d){Px(f,a,b);d=c[f>>2]|0;Qx(a,c[g>>2]|0,e,d);c[f>>2]=0}i=h;return d+20|0}function Ox(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;a=a+4|0;e=c[a>>2]|0;do if(e){f=c[d>>2]|0;while(1){a=c[e+16>>2]|0;if(f>>>0<a>>>0){a=c[e>>2]|0;if(!a){a=e;d=5;break}}else{if(a>>>0>=f>>>0){a=e;d=10;break}a=e+4|0;d=c[a>>2]|0;if(!d){d=9;break}else a=d}e=a}if((d|0)==5){c[b>>2]=e;break}else if((d|0)==9){c[b>>2]=e;break}else if((d|0)==10){c[b>>2]=a;a=b;break}}else c[b>>2]=a;while(0);return a|0}function Px(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=Sz(24)|0;tq(e+16|0,d);c[e+20>>2]=0;c[a>>2]=e;a=a+4|0;c[a>>2]=b+4;c[a+4>>2]=257;return}function Qx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=b;c[d>>2]=e;b=c[a>>2]|0;if(c[b>>2]|0){c[a>>2]=c[b>>2];e=c[d>>2]|0}kw(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1;return}function Rx(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>1073741823)Qz(a);else{d=Sz(b<<2)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<2);return}}function Sx(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;b=c[d>>2]|0;do{c[b>>2]=0;Br(b,0);b=(c[d>>2]|0)+4|0;c[d>>2]=b;a=a+-1|0}while((a|0)!=0);return}function Tx(a){a=a|0;c[a>>2]=30716;uq(a+12|0);uq(a+8|0);return}function Ux(a){a=a|0;Tx(a);Uz(a);return}function Vx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+12>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=Sz(b)|0;c[a>>2]=e;d=e+d|0;c[a+8>>2]=d;c[a+4>>2]=d;c[a+12>>2]=e+b;return}function Wx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;e=c[a>>2]|0;g=a+4|0;d=b+4|0;f=(c[g>>2]|0)-e|0;h=(c[d>>2]|0)+(0-f)|0;c[d>>2]=h;XL(h|0,e|0,f|0)|0;f=c[a>>2]|0;c[a>>2]=c[d>>2];c[d>>2]=f;f=b+8|0;e=c[g>>2]|0;c[g>>2]=c[f>>2];c[f>>2]=e;f=a+8|0;a=b+12|0;e=c[f>>2]|0;c[f>>2]=c[a>>2];c[a>>2]=e;c[b>>2]=c[d>>2];return}function Xx(a){a=a|0;var b=0,d=0,e=0;d=c[a+4>>2]|0;e=a+8|0;b=c[e>>2]|0;if((b|0)!=(d|0)){do b=b+-1|0;while((b|0)!=(d|0));c[e>>2]=b}Uz(c[a>>2]|0);return}function Yx(a){a=a|0;c[a>>2]=34556;Sd(a+8|0);return}function Zx(a){a=a|0;c[a>>2]=34556;Sd(a+8|0);Uz(a);return}function _x(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>1073741823)Qz(a);else{d=Sz(b<<2)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<2);return}}function $x(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;b=c[d>>2]|0;do{c[b>>2]=0;or(b,0);b=(c[d>>2]|0)+4|0;c[d>>2]=b;a=a+-1|0}while((a|0)!=0);return}function ay(a){a=a|0;c[a>>2]=30700;Sd(a+12|0);return}function by(a){a=a|0;c[a>>2]=30700;Sd(a+12|0);Uz(a);return}function cy(a){a=a|0;yr(a);Uz(a);return}function dy(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;q=i;i=i+32|0;j=q+16|0;n=q+8|0;k=q;o=0;ma(218,n|0,b|0);m=o;o=0;a:do if(m&1){e=cc(0)|0;f=b;g=b;p=15}else{do if(a[n>>0]|0){f=c[(c[b>>2]|0)+-12>>2]|0;c[k>>2]=c[b+(f+24)>>2];l=b+f|0;m=c[b+(f+4)>>2]|0;g=d+e|0;f=b+(f+76)|0;e=c[f>>2]|0;do if((e|0)==-1){o=0;e=qa(192,l|0)|0;r=o;o=0;if(r&1)p=13;else{c[j>>2]=e;o=0;e=Wa(115,j|0,40904)|0;r=o;o=0;if(!(r&1)?(o=0,h=Wa(c[(c[e>>2]|0)+28>>2]|0,e|0,32)|0,r=o,o=0,!(r&1)):0){aI(j);e=h<<24>>24;c[f>>2]=e;p=9;break}e=cc(0)|0;aI(j)}}else p=9;while(0);if((p|0)==9){o=0;c[j>>2]=c[k>>2];e=oa(83,j|0,d|0,((m&176|0)==32?g:d)|0,g|0,l|0,e&255|0)|0;r=o;o=0;if(!(r&1)){if(e)break;r=c[(c[b>>2]|0)+-12>>2]|0;o=0;ma(146,b+r|0,c[b+(r+16)>>2]|5|0);r=o;o=0;if(!(r&1))break;else p=13}else p=13}if((p|0)==13)e=cc(0)|0;KD(n);f=b;g=b;p=15;break a}while(0);KD(n)}while(0);do if((p|0)==15){fc(e|0)|0;o=0;ka(341,f+(c[(c[g>>2]|0)+-12>>2]|0)|0);r=o;o=0;if(!(r&1)){$b();break}e=cc()|0;o=0;ob(44);r=o;o=0;if(r&1){r=cc(0)|0;oq(r)}else bc(e|0)}while(0);i=q;return b|0}function ey(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0;p=i;i=i+16|0;n=p;j=c[b>>2]|0;a:do if(!j)j=0;else{q=d;l=f-q|0;m=g+12|0;k=c[m>>2]|0;l=(k|0)>(l|0)?k-l|0:0;k=e;g=k-q|0;if((g|0)>0?(fd[c[(c[j>>2]|0)+48>>2]&127](j,d,g)|0)!=(g|0):0){c[b>>2]=0;j=0;break}do if((l|0)>0){GC(n,l,h);o=0;g=ya(c[(c[j>>2]|0)+48>>2]|0,j|0,((a[n>>0]&1)==0?n+1|0:c[n+8>>2]|0)|0,l|0)|0;q=o;o=0;if(q&1){q=cc()|0;IC(n);bc(q|0)}if((g|0)==(l|0)){IC(n);break}else{c[b>>2]=0;IC(n);j=0;break a}}while(0);f=f-k|0;if((f|0)>0?(fd[c[(c[j>>2]|0)+48>>2]&127](j,e,f)|0)!=(f|0):0){c[b>>2]=0;j=0;break}c[m>>2]=0}while(0);i=p;return j|0}function fy(a){a=a|0;c[a>>2]=30668;IC(a+8|0);return}function gy(a){a=a|0;c[a>>2]=30668;IC(a+8|0);Uz(a);return}function hy(a){a=a|0;Aq(a);Uz(a);return}function iy(a,b){a=a|0;b=b|0;var d=0;if(b>>>0>1073741823)Qz(a);else{d=Sz(b<<2)|0;c[a+4>>2]=d;c[a>>2]=d;c[a+8>>2]=d+(b<<2);return}}function jy(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;b=c[d>>2]|0;do{c[b>>2]=0;$q(b,0);b=(c[d>>2]|0)+4|0;c[d>>2]=b;a=a+-1|0}while((a|0)!=0);return}function ky(a){a=a|0;c[a>>2]=30632;nq(a+12|0);return}function ly(a){a=a|0;c[a>>2]=30632;nq(a+12|0);Uz(a);return}function my(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+32|0;j=k;g=c[a+8>>2]|0;h=a+4|0;d=c[h>>2]|0;e=d;if(g-e>>2>>>0<b>>>0){d=c[a>>2]|0;e=(e-d>>2)+b|0;if(e>>>0>1073741823)Qz(a);f=d;d=g-f|0;if(d>>2>>>0<536870911){d=d>>1;d=d>>>0<e>>>0?e:d}else d=1073741823;Yv(j,d,(c[h>>2]|0)-f>>2,a+8|0);h=j+8|0;g=c[h>>2]|0;ZL(g|0,0,b<<2|0)|0;c[h>>2]=g+(b<<2);Zv(a,j);_v(j)}else{ZL(d|0,0,b<<2|0)|0;c[h>>2]=d+(b<<2)}i=k;return}function ny(a){a=a|0;c[a>>2]=30616;ar(a+36|0);ar(a+32|0);br(a+20|0);br(a+8|0);return}function oy(a){a=a|0;ny(a);Uz(a);return}
function MC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;f=a[b>>0]|0;g=(f&1)==0;if(g)f=(f&255)>>>1;else f=c[b+4>>2]|0;do if(f>>>0>=d>>>0)if(g){a[b+1+d>>0]=0;a[b>>0]=d<<1;break}else{a[(c[b+8>>2]|0)+d>>0]=0;c[b+4>>2]=d;break}else NC(b,d-f|0,e)|0;while(0);return}function NC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;if(d){f=a[b>>0]|0;if(!(f&1))g=10;else{f=c[b>>2]|0;g=(f&-2)+-1|0;f=f&255}if(!(f&1))h=(f&255)>>>1;else h=c[b+4>>2]|0;if((g-h|0)>>>0<d>>>0){TC(b,g,d-g+h|0,h,h,0,0);f=a[b>>0]|0}if(!(f&1))g=b+1|0;else g=c[b+8>>2]|0;ZL(g+h|0,e|0,d|0)|0;f=h+d|0;if(!(a[b>>0]&1))a[b>>0]=f<<1;else c[b+4>>2]=f;a[g+f>>0]=0}return b|0}function OC(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;if(d>>>0>4294967279)Pz(b);e=a[b>>0]|0;if(!(e&1))f=10;else{e=c[b>>2]|0;f=(e&-2)+-1|0;e=e&255}if(!(e&1))j=(e&255)>>>1;else j=c[b+4>>2]|0;d=j>>>0>d>>>0?j:d;if(d>>>0<11)i=10;else i=(d+16&-16)+-1|0;a:do if((i|0)!=(f|0)){do if((i|0)!=10){d=i+1|0;if(i>>>0<=f>>>0){o=0;d=qa(111,d|0)|0;h=o;o=0;if(h&1){b=cc(0)|0;fc(b|0)|0;$b();break a}}else d=Sz(d)|0;if(!(e&1)){f=1;g=b+1|0;h=0;break}else{f=1;g=c[b+8>>2]|0;h=1;break}}else{d=b+1|0;f=0;g=c[b+8>>2]|0;h=1}while(0);if(!(e&1))e=(e&255)>>>1;else e=c[b+4>>2]|0;XL(d|0,g|0,e+1|0)|0;if(h)Uz(g);if(f){c[b>>2]=i+1|1;c[b+4>>2]=j;c[b+8>>2]=d;break}else{a[b>>0]=j<<1;break}}while(0);return}function PC(a,b){a=a|0;b=b|0;return RC(a,b,iC(b)|0)|0}function QC(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=a[b>>0]|0;f=(e&1)!=0;if(f){g=(c[b>>2]&-2)+-1|0;h=c[b+4>>2]|0}else{g=10;h=(e&255)>>>1}if((h|0)==(g|0)){TC(b,g,1,g,g,0,0);if(!(a[b>>0]&1))g=7;else g=8}else if(f)g=8;else g=7;if((g|0)==7){a[b>>0]=(h<<1)+2;e=b+1|0;f=h+1|0}else if((g|0)==8){e=c[b+8>>2]|0;f=h+1|0;c[b+4>>2]=f}a[e+h>>0]=d;a[e+f>>0]=0;return}function RC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=a[b>>0]|0;if(!(f&1))g=10;else{f=c[b>>2]|0;g=(f&-2)+-1|0;f=f&255}if(!(f&1))h=(f&255)>>>1;else h=c[b+4>>2]|0;if((g-h|0)>>>0>=e>>>0){if(e){if(!(f&1))g=b+1|0;else g=c[b+8>>2]|0;XL(g+h|0,d|0,e|0)|0;f=h+e|0;if(!(a[b>>0]&1))a[b>>0]=f<<1;else c[b+4>>2]=f;a[g+f>>0]=0}}else SC(b,g,e-g+h|0,h,h,0,e,d);return b|0}function SC(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0;if((-18-d|0)>>>0<e>>>0)Pz(b);if(!(a[b>>0]&1))m=b+1|0;else m=c[b+8>>2]|0;if(d>>>0<2147483623){k=e+d|0;l=d<<1;k=k>>>0<l>>>0?l:k;k=k>>>0<11?11:k+16&-16}else k=-17;l=Sz(k)|0;if(g)XL(l|0,m|0,g|0)|0;if(i)XL(l+g|0,j|0,i|0)|0;e=f-h|0;if((e|0)!=(g|0))XL(l+(i+g)|0,m+(h+g)|0,e-g|0)|0;if((d|0)!=10)Uz(m);c[b+8>>2]=l;c[b>>2]=k|1;d=e+i|0;c[b+4>>2]=d;a[l+d>>0]=0;return}function TC(b,d,e,f,g,h,i){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0;if((-17-d|0)>>>0<e>>>0)Pz(b);if(!(a[b>>0]&1))l=b+1|0;else l=c[b+8>>2]|0;if(d>>>0<2147483623){j=e+d|0;k=d<<1;j=j>>>0<k>>>0?k:j;j=j>>>0<11?11:j+16&-16}else j=-17;k=Sz(j)|0;if(g)XL(k|0,l|0,g|0)|0;e=f-h|0;if((e|0)!=(g|0))XL(k+(i+g)|0,l+(h+g)|0,e-g|0)|0;if((d|0)!=10)Uz(l);c[b+8>>2]=k;c[b>>2]=j|1;return}function UC(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;g=a[b>>0]|0;h=(g&1)==0;if(h)i=(g&255)>>>1;else i=c[b+4>>2]|0;if(i>>>0<d>>>0)RA(b);if(e){if(h)h=10;else{g=c[b>>2]|0;h=(g&-2)+-1|0;g=g&255}if((h-i|0)>>>0>=e>>>0){if(!(g&1))g=b+1|0;else g=c[b+8>>2]|0;if((i|0)==(d|0))h=g;else{YL(g+(e+d)|0,g+d|0,i-d|0)|0;h=g}}else{TC(b,h,i+e-h|0,i,d,0,e);h=c[b+8>>2]|0}ZL(h+d|0,f|0,e|0)|0;g=i+e|0;if(!(a[b>>0]&1))a[b>>0]=g<<1;else c[b+4>>2]=g;a[h+g>>0]=0}return b|0}function VC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;g=a[b>>0]|0;f=(g&1)==0;if(f)i=(g&255)>>>1;else i=c[b+4>>2]|0;if(i>>>0<d>>>0)RA(b);if(e){if(f)h=b+1|0;else h=c[b+8>>2]|0;f=i-d|0;e=f>>>0<e>>>0?f:e;if((f|0)!=(e|0)){YL(h+d|0,h+(e+d)|0,f-e|0)|0;g=a[b>>0]|0}f=i-e|0;if(!(g&1))a[b>>0]=f<<1;else c[b+4>>2]=f;a[h+f>>0]=0}return b|0}function WC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=a[b>>0]|0;if(!(f&1)){g=(f&255)>>>1;f=b+1|0}else{g=c[b+4>>2]|0;f=c[b+8>>2]|0}if(g>>>0>e>>>0?(h=aC(f+e|0,d&255,g-e|0)|0,(h|0)!=0):0)f=h-f|0;else f=-1;return f|0}function XC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if(e>>>0>1073741807)Pz(b);if(e>>>0<2){a[b>>0]=e<<1;b=b+4|0}else{g=e+4&-4;f=Sz(g<<2)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=e;b=f}kC(b,d,e)|0;c[b+(e<<2)>>2]=0;return}function YC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if(d>>>0>1073741807)Pz(b);if(d>>>0<2){a[b>>0]=d<<1;b=b+4|0}else{g=d+4&-4;f=Sz(g<<2)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=d;b=f}mC(b,e,d)|0;c[b+(d<<2)>>2]=0;return}function ZC(b){b=b|0;if(a[b>>0]&1)Uz(c[b+8>>2]|0);return}function _C(a,b){a=a|0;b=b|0;return $C(a,b,jC(b)|0)|0}function $C(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=a[b>>0]|0;if(!(f&1))h=1;else{f=c[b>>2]|0;h=(f&-2)+-1|0;f=f&255}g=(f&1)==0;do if(h>>>0>=e>>>0){if(g)f=b+4|0;else f=c[b+8>>2]|0;lC(f,d,e)|0;c[f+(e<<2)>>2]=0;if(!(a[b>>0]&1)){a[b>>0]=e<<1;break}else{c[b+4>>2]=e;break}}else{if(g)f=(f&255)>>>1;else f=c[b+4>>2]|0;cD(b,h,e-h|0,f,0,f,e,d)}while(0);return b|0}function aD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;if(d>>>0>1073741807)Pz(b);e=a[b>>0]|0;if(!(e&1))f=1;else{e=c[b>>2]|0;f=(e&-2)+-1|0;e=e&255}if(!(e&1))j=(e&255)>>>1;else j=c[b+4>>2]|0;d=j>>>0>d>>>0?j:d;if(d>>>0<2)i=1;else i=(d+4&-4)+-1|0;a:do if((i|0)!=(f|0)){do if((i|0)!=1){d=(i<<2)+4|0;if(i>>>0<=f>>>0){o=0;d=qa(111,d|0)|0;h=o;o=0;if(h&1){b=cc(0)|0;fc(b|0)|0;$b();break a}}else d=Sz(d)|0;if(!(e&1)){f=1;g=b+4|0;h=0;break}else{f=1;g=c[b+8>>2]|0;h=1;break}}else{d=b+4|0;f=0;g=c[b+8>>2]|0;h=1}while(0);if(!(e&1))e=(e&255)>>>1;else e=c[b+4>>2]|0;kC(d,g,e+1|0)|0;if(h)Uz(g);if(f){c[b>>2]=i+1|1;c[b+4>>2]=j;c[b+8>>2]=d;break}else{a[b>>0]=j<<1;break}}while(0);return}function bD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=a[b>>0]|0;f=(e&1)!=0;if(f){g=(c[b>>2]&-2)+-1|0;h=c[b+4>>2]|0}else{g=1;h=(e&255)>>>1}if((h|0)==(g|0)){dD(b,g,1,g,g,0,0);if(!(a[b>>0]&1))g=7;else g=8}else if(f)g=8;else g=7;if((g|0)==7){a[b>>0]=(h<<1)+2;e=b+4|0;f=h+1|0}else if((g|0)==8){e=c[b+8>>2]|0;f=h+1|0;c[b+4>>2]=f}c[e+(h<<2)>>2]=d;c[e+(f<<2)>>2]=0;return}function cD(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0;if((1073741806-d|0)>>>0<e>>>0)Pz(b);if(!(a[b>>0]&1))m=b+4|0;else m=c[b+8>>2]|0;if(d>>>0<536870887){k=e+d|0;l=d<<1;k=k>>>0<l>>>0?l:k;k=k>>>0<2?2:k+4&-4}else k=1073741807;l=Sz(k<<2)|0;if(g)kC(l,m,g)|0;if(i)kC(l+(g<<2)|0,j,i)|0;e=f-h|0;if((e|0)!=(g|0))kC(l+(i+g<<2)|0,m+(h+g<<2)|0,e-g|0)|0;if((d|0)!=1)Uz(m);c[b+8>>2]=l;c[b>>2]=k|1;d=e+i|0;c[b+4>>2]=d;c[l+(d<<2)>>2]=0;return}function dD(b,d,e,f,g,h,i){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0;if((1073741807-d|0)>>>0<e>>>0)Pz(b);if(!(a[b>>0]&1))l=b+4|0;else l=c[b+8>>2]|0;if(d>>>0<536870887){j=e+d|0;k=d<<1;j=j>>>0<k>>>0?k:j;j=j>>>0<2?2:j+4&-4}else j=1073741807;k=Sz(j<<2)|0;if(g)kC(k,l,g)|0;e=f-h|0;if((e|0)!=(g|0))kC(k+(i+g<<2)|0,l+(h+g<<2)|0,e-g|0)|0;if((d|0)!=1)Uz(l);c[b+8>>2]=k;c[b>>2]=j|1;return}function eD(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;g=d;f=e-g|0;if(f>>>0>4294967279)Pz(b);if(f>>>0<11){a[b>>0]=f<<1;h=b+1|0}else{i=f+16&-16;h=Sz(i)|0;c[b+8>>2]=h;c[b>>2]=i|1;c[b+4>>2]=f}b=e-g|0;if((d|0)!=(e|0)){f=h;while(1){a[f>>0]=a[d>>0]|0;d=d+1|0;if((d|0)==(e|0))break;else f=f+1|0}}a[h+b>>0]=0;return}function fD(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;h=d;f=e-h|0;g=f>>2;if(g>>>0>1073741807)Pz(b);if(g>>>0<2){a[b>>0]=f>>>1;b=b+4|0}else{i=g+4&-4;f=Sz(i<<2)|0;c[b+8>>2]=f;c[b>>2]=i|1;c[b+4>>2]=g;b=f}g=(e-h|0)>>>2;if((d|0)!=(e|0)){f=b;while(1){c[f>>2]=c[d>>2];d=d+4|0;if((d|0)==(e|0))break;else f=f+4|0}}c[b+(g<<2)>>2]=0;return}function gD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d;f=(c[a+24>>2]|0)==0;c[a+16>>2]=f&1|b;if(!((f&1|b)&c[a+20>>2])){i=d;return}b=Ob(16)|0;OD()|0;c[e>>2]=1;c[e+4>>2]=39796;o=0;mb(115,b|0,59796,e|0);f=o;o=0;if(f&1){f=cc()|0;Nb(b|0);bc(f|0)}else Hc(b|0,2080,232)}function hD(a){a=a|0;var b=0;c[a>>2]=39752;o=0;ma(221,a|0,0);b=o;o=0;if(b&1){b=cc(0)|0;oq(b)}else{aI(a+28|0);zC(c[a+32>>2]|0);zC(c[a+36>>2]|0);zC(c[a+48>>2]|0);zC(c[a+60>>2]|0);return}}function iD(a){a=a|0;hD(a);return}function jD(a){a=a|0;hD(a);Uz(a);return}function kD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=c[a+40>>2]|0;e=a+32|0;f=a+36|0;if(d)do{d=d+-1|0;Ad[c[(c[e>>2]|0)+(d<<2)>>2]&127](b,a,c[(c[f>>2]|0)+(d<<2)>>2]|0)}while((d|0)!=0);return}function lD(a){a=a|0;var b=0,d=0;d=i;i=i+16|0;b=d;$H(b,a+28|0);i=d;return c[b>>2]|0}function mD(a,b){a=a|0;b=b|0;var d=0;c[a+24>>2]=b;c[a+16>>2]=(b|0)==0&1;c[a+20>>2]=0;c[a+4>>2]=4098;c[a+12>>2]=0;c[a+8>>2]=6;d=a+28|0;b=a+32|0;a=b+40|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(a|0));_H(d);return}function nD(a){a=a|0;c[a>>2]=39668;aI(a+4|0);return}function oD(a){a=a|0;c[a>>2]=39668;aI(a+4|0);Uz(a);return}function pD(a){a=a|0;c[a>>2]=39668;_H(a+4|0);a=a+8|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;return}function qD(a,b){a=a|0;b=b|0;return}function rD(a,b,c){a=a|0;b=b|0;c=c|0;return a|0}function sD(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;return}function tD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;return}function uD(a){a=a|0;return 0}function vD(a){a=a|0;return 0}function wD(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;h=b+12|0;i=b+16|0;a:do if((e|0)>0){g=d;d=0;while(1){f=c[h>>2]|0;if(f>>>0<(c[i>>2]|0)>>>0){c[h>>2]=f+1;f=a[f>>0]|0}else{f=bd[c[(c[b>>2]|0)+40>>2]&255](b)|0;if((f|0)==-1)break a;f=f&255}a[g>>0]=f;d=d+1|0;if((d|0)<(e|0))g=g+1|0;else break}}else d=0;while(0);return d|0}function xD(a){a=a|0;return -1}function yD(a){a=a|0;var b=0;if((bd[c[(c[a>>2]|0)+36>>2]&255](a)|0)==-1)a=-1;else{b=a+12|0;a=c[b>>2]|0;c[b>>2]=a+1;a=d[a>>0]|0}return a|0}function zD(a,b){a=a|0;b=b|0;return -1}function AD(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;i=b+24|0;j=b+28|0;a:do if((f|0)>0){h=e;e=0;while(1){g=c[i>>2]|0;if(g>>>0>=(c[j>>2]|0)>>>0){if((rd[c[(c[b>>2]|0)+52>>2]&127](b,d[h>>0]|0)|0)==-1)break a}else{k=a[h>>0]|0;c[i>>2]=g+1;a[g>>0]=k}e=e+1|0;if((e|0)<(f|0))h=h+1|0;else break}}else e=0;while(0);return e|0}function BD(a,b){a=a|0;b=b|0;return -1}function CD(b){b=b|0;var d=0,e=0,f=0,g=0;f=i;i=i+16|0;e=f;a:do if(c[b+((c[(c[b>>2]|0)+-12>>2]|0)+24)>>2]|0){o=0;ma(218,e|0,b|0);d=o;o=0;b:do if(d&1)d=cc(0)|0;else{do if(a[e>>0]|0){d=c[b+((c[(c[b>>2]|0)+-12>>2]|0)+24)>>2]|0;o=0;d=qa(c[(c[d>>2]|0)+24>>2]|0,d|0)|0;g=o;o=0;if(!(g&1)){if((d|0)!=-1)break;g=c[(c[b>>2]|0)+-12>>2]|0;o=0;ma(146,b+g|0,c[b+(g+16)>>2]|1|0);g=o;o=0;if(!(g&1))break}d=cc(0)|0;KD(e);break b}while(0);KD(e);break a}while(0);fc(d|0)|0;o=0;ka(341,b+(c[(c[b>>2]|0)+-12>>2]|0)|0);g=o;o=0;if(!(g&1)){$b();break}d=cc()|0;o=0;ob(44);g=o;o=0;if(g&1){g=cc(0)|0;oq(g)}else bc(d|0)}while(0);i=f;return b|0}function DD(a){a=a|0;var b=0;b=a+16|0;c[b>>2]=c[b>>2]|1;if(!(c[a+20>>2]&1))return;else Jc()}function ED(a,b){a=a|0;b=b|0;return}function FD(a){a=a|0;hD(a+4|0);return}function GD(a){a=a|0;hD(a+((c[(c[a>>2]|0)+-12>>2]|0)+4)|0);return}function HD(a){a=a|0;hD(a+4|0);Uz(a);return}function ID(a){a=a|0;HD(a+(c[(c[a>>2]|0)+-12>>2]|0)|0);return}function JD(b,d){b=b|0;d=d|0;var e=0;a[b>>0]=0;c[b+4>>2]=d;e=c[(c[d>>2]|0)+-12>>2]|0;if(!(c[d+(e+16)>>2]|0)){e=c[d+(e+72)>>2]|0;if(e)CD(e)|0;a[b>>0]=1}return}function KD(a){a=a|0;var b=0,d=0;a=a+4|0;d=c[a>>2]|0;b=c[(c[d>>2]|0)+-12>>2]|0;do if((((c[d+(b+24)>>2]|0)!=0?(c[d+(b+16)>>2]|0)==0:0)?(c[d+(b+4)>>2]&8192|0)!=0:0)?!(Pb()|0):0){b=c[a>>2]|0;b=c[b+((c[(c[b>>2]|0)+-12>>2]|0)+24)>>2]|0;o=0;b=qa(c[(c[b>>2]|0)+24>>2]|0,b|0)|0;d=o;o=0;if(!(d&1)){if((b|0)!=-1)break;b=c[a>>2]|0;d=c[(c[b>>2]|0)+-12>>2]|0;o=0;ma(146,b+d|0,c[b+(d+16)>>2]|1|0);d=o;o=0;if(!(d&1))break}d=cc(0)|0;fc(d|0)|0;o=0;ob(44);d=o;o=0;if(d&1){d=cc(0)|0;oq(d)}}while(0);return}function LD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;q=i;i=i+32|0;k=q+20|0;l=q+16|0;n=q+8|0;e=q;o=0;ma(218,n|0,b|0);m=o;o=0;a:do if(m&1){e=cc(0)|0;f=b;g=b;p=19}else{do if(a[n>>0]|0){c[e>>2]=lD(b+(c[(c[b>>2]|0)+-12>>2]|0)|0)|0;o=0;m=Wa(115,e|0,40076)|0;j=o;o=0;if(j&1){p=cc(0)|0;aI(e);e=p}else{aI(e);g=c[(c[b>>2]|0)+-12>>2]|0;j=c[b+(g+24)>>2]|0;f=b+g|0;g=b+(g+76)|0;e=c[g>>2]|0;do if((e|0)==-1){c[k>>2]=lD(f)|0;o=0;e=Wa(115,k|0,40904)|0;r=o;o=0;if(!(r&1)?(o=0,h=Wa(c[(c[e>>2]|0)+28>>2]|0,e|0,32)|0,r=o,o=0,!(r&1)):0){aI(k);e=h<<24>>24;c[g>>2]=e;p=10;break}e=cc(0)|0;aI(k)}else p=10;while(0);if((p|0)==10){r=c[(c[m>>2]|0)+16>>2]|0;c[l>>2]=j;o=0;c[k>>2]=c[l>>2];e=Ya(r|0,m|0,k|0,f|0,e&255|0,d|0)|0;r=o;o=0;if(!(r&1)){if(e)break;r=c[(c[b>>2]|0)+-12>>2]|0;o=0;ma(146,b+r|0,c[b+(r+16)>>2]|5|0);r=o;o=0;if(!(r&1))break}e=cc(0)|0}}KD(n);f=b;g=b;p=19;break a}while(0);KD(n)}while(0);do if((p|0)==19){fc(e|0)|0;o=0;ka(341,f+(c[(c[g>>2]|0)+-12>>2]|0)|0);r=o;o=0;if(!(r&1)){$b();break}e=cc()|0;o=0;ob(44);r=o;o=0;if(r&1){r=cc(0)|0;oq(r)}else bc(e|0)}while(0);i=q;return b|0}function MD(a){a=a|0;return 59812}function ND(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)!=1&(c|0)<257)LL(a,b,c);else FC(a,59821,35);return}function OD(){if((a[2168]|0)==0?(Hb(2168)|0)!=0:0){c[9949]=39768;Ec(236,39796,n|0)|0;Cc(2168)}return 39796}function PD(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+8|0;g=e;j=d;h=c[j+4>>2]|0;d=g;c[d>>2]=c[j>>2];c[d+4>>2]=h;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];NL(a,f,b);c[a>>2]=39732;i=e;return}function QD(a){a=a|0;OL(a);return}function RD(a){a=a|0;OL(a);Uz(a);return}function SD(a){a=a|0;hD(a);Uz(a);return}function TD(a){a=a|0;Uz(a);return}function UD(a){a=a|0;return}function VD(a){a=a|0;return}function WD(a){a=a|0;Uz(a);return}function XD(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;a:do if((e|0)==(f|0))h=6;else while(1){if((c|0)==(d|0)){c=-1;break a}b=a[c>>0]|0;g=a[e>>0]|0;if(b<<24>>24<g<<24>>24){c=-1;break a}if(g<<24>>24<b<<24>>24){c=1;break a}c=c+1|0;e=e+1|0;if((e|0)==(f|0)){h=6;break}}while(0);if((h|0)==6)c=(c|0)!=(d|0)&1;return c|0}function YD(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;eD(a,c,d);return}function ZD(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if((c|0)==(d|0))b=0;else{b=0;do{b=(a[c>>0]|0)+(b<<4)|0;e=b&-268435456;b=(e>>>24|e)^b;c=c+1|0}while((c|0)!=(d|0))}return b|0}function _D(a){a=a|0;return}function $D(a){a=a|0;Uz(a);return}function aE(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;a:do if((e|0)==(f|0))h=6;else while(1){if((b|0)==(d|0)){b=-1;break a}a=c[b>>2]|0;g=c[e>>2]|0;if((a|0)<(g|0)){b=-1;break a}if((g|0)<(a|0)){b=1;break a}b=b+4|0;e=e+4|0;if((e|0)==(f|0)){h=6;break}}while(0);if((h|0)==6)b=(b|0)!=(d|0)&1;return b|0}function bE(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;fD(a,c,d);return}function cE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if((b|0)==(d|0))a=0;else{a=0;do{a=(c[b>>2]|0)+(a<<4)|0;e=a&-268435456;a=(e>>>24|e)^a;b=b+4|0}while((b|0)!=(d|0))}return a|0}function dE(a){a=a|0;return}function eE(a){a=a|0;Uz(a);return}function fE(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0;s=i;i=i+64|0;q=s+56|0;j=s+52|0;n=s+48|0;k=s+44|0;l=s+40|0;m=s+36|0;p=s+32|0;t=s+8|0;r=s;a:do if(!(c[f+4>>2]&1)){c[n>>2]=-1;t=c[(c[b>>2]|0)+16>>2]|0;c[k>>2]=c[d>>2];c[l>>2]=c[e>>2];c[j>>2]=c[k>>2];c[q>>2]=c[l>>2];j=ad[t&127](b,j,q,f,g,n)|0;c[d>>2]=j;switch(c[n>>2]|0){case 0:{a[h>>0]=0;break a}case 1:{a[h>>0]=1;break a}default:{a[h>>0]=1;c[g>>2]=4;break a}}}else{j=lD(f)|0;c[m>>2]=j;o=0;b=Wa(115,m|0,40904)|0;n=o;o=0;do if(!(n&1)){EL(j)|0;j=lD(f)|0;c[p>>2]=j;o=0;l=Wa(115,p|0,41044)|0;p=o;o=0;if(p&1){t=cc()|0;EL(j)|0;j=t;break}EL(j)|0;o=0;ma(c[(c[l>>2]|0)+24>>2]|0,t|0,l|0);p=o;o=0;if(!(p&1)){k=t+12|0;o=0;ma(c[(c[l>>2]|0)+28>>2]|0,k|0,l|0);p=o;o=0;if(!(p&1)){c[r>>2]=c[e>>2];o=0;c[q>>2]=c[r>>2];j=ea(50,d|0,q|0,t|0,t+24|0,b|0,g|0,1)|0;g=o;o=0;if(g&1){j=cc()|0;IC(t+12|0);IC(t);break}else{a[h>>0]=(j|0)==(t|0)&1;j=c[d>>2]|0;IC(t+12|0);IC(t);break a}}}else k=t;j=cc()|0;l=D;if((t|0)!=(k|0))do{k=k+-12|0;IC(k)}while((k|0)!=(t|0))}else{t=cc()|0;EL(j)|0;j=t}while(0);bc(j|0)}while(0);i=s;return j|0}function gE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=UJ(a,k,j,e,f,g)|0;i=h;return a|0}function hE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=VJ(a,k,j,e,f,g)|0;i=h;return a|0}function iE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=WJ(a,k,j,e,f,g)|0;i=h;return a|0}function jE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=XJ(a,k,j,e,f,g)|0;i=h;return a|0}function kE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=YJ(a,k,j,e,f,g)|0;i=h;return a|0}function lE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=ZJ(a,k,j,e,f,g)|0;i=h;return a|0}function mE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=_J(a,k,j,e,f,g)|0;i=h;return a|0}function nE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=$J(a,k,j,e,f,g)|0;i=h;return a|0}function oE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=aK(a,k,j,e,f,g)|0;i=h;return a|0}function pE(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;C=i;i=i+240|0;x=C;s=C+208|0;E=C+32|0;b=C+28|0;D=C+16|0;w=C+12|0;u=C+48|0;v=C+8|0;t=C+4|0;c[E>>2]=0;c[E+4>>2]=0;c[E+8>>2]=0;o=0;g=qa(192,g|0)|0;r=o;o=0;do if(r&1)b=cc()|0;else{c[b>>2]=g;o=0;b=Wa(115,b|0,40904)|0;r=o;o=0;if(!(r&1)?(o=0,kb(c[(c[b>>2]|0)+32>>2]|0,b|0,59857,59883,s|0)|0,r=o,o=0,!(r&1)):0){EL(g)|0;c[D>>2]=0;c[D+4>>2]=0;c[D+8>>2]=0;if(!(a[D>>0]&1))b=10;else b=(c[D>>2]&-2)+-1|0;o=0;mb(80,D|0,b|0,0);r=o;o=0;a:do if(!(r&1)){q=D+8|0;r=D+1|0;g=(a[D>>0]&1)==0?r:c[q>>2]|0;c[w>>2]=g;c[v>>2]=u;c[t>>2]=0;p=D+4|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;k=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;n=o;o=0;if(n&1){F=29;break}if((k|0)==-1){c[e>>2]=0;b=0}}}else b=0;l=(b|0)==0;k=c[f>>2]|0;do if(k){if((c[k+12>>2]|0)!=(c[k+16>>2]|0))if(l)break;else break b;o=0;m=qa(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;n=o;o=0;if(n&1){F=29;break b}if((m|0)!=-1)if(l)break;else break b;else{c[f>>2]=0;F=19;break}}else F=19;while(0);if((F|0)==19){F=0;if(l){k=0;break}else k=0}l=a[D>>0]|0;l=(l&1)==0?(l&255)>>>1:c[p>>2]|0;if((c[w>>2]|0)==(g+l|0)){o=0;mb(80,D|0,l<<1|0,0);n=o;o=0;if(n&1){F=29;break}if(!(a[D>>0]&1))g=10;else g=(c[D>>2]&-2)+-1|0;o=0;mb(80,D|0,g|0,0);n=o;o=0;if(n&1){F=29;break}g=(a[D>>0]&1)==0?r:c[q>>2]|0;c[w>>2]=g+l}m=b+12|0;l=c[m>>2]|0;n=b+16|0;if((l|0)==(c[n>>2]|0)){o=0;l=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;G=o;o=0;if(G&1){F=29;break}}else l=d[l>>0]|0;if(qE(l&255,16,g,w,t,0,E,u,v,s)|0)break;k=c[m>>2]|0;if((k|0)==(c[n>>2]|0)){o=0;qa(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;G=o;o=0;if(G&1){F=29;break}else continue}else{c[m>>2]=k+1;continue}}if((F|0)==29){b=cc()|0;break}o=0;mb(80,D|0,(c[w>>2]|0)-g|0,0);G=o;o=0;if((!(G&1)?(y=a[D>>0]|0,z=c[q>>2]|0,o=0,A=gb(45)|0,G=o,o=0,!(G&1)):0)?(o=0,c[x>>2]=j,B=kb(64,((y&1)==0?r:z)|0,A|0,61241,x|0)|0,G=o,o=0,!(G&1)):0){if((B|0)!=1)c[h>>2]=4;if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;G=o;o=0;if(G&1){F=30;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(k){if((c[k+12>>2]|0)==(c[k+16>>2]|0)){o=0;b=qa(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;G=o;o=0;if(G&1){F=30;break a}if((b|0)==-1){c[f>>2]=0;F=55;break}}if(!g)F=56}else F=55;while(0);if((F|0)==55?g:0)F=56;if((F|0)==56)c[h>>2]=c[h>>2]|2;G=c[e>>2]|0;IC(D);IC(E);i=C;return G|0}else F=30}else F=30;while(0);if((F|0)==30)b=cc()|0;IC(D);break}b=cc()|0;EL(g)|0}while(0);IC(E);bc(b|0);return 0}function qE(b,d,e,f,g,h,i,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0;o=c[f>>2]|0;p=(o|0)==(e|0);do if(p){m=(a[l+24>>0]|0)==b<<24>>24;if(!m?(a[l+25>>0]|0)!=b<<24>>24:0){n=5;break}c[f>>2]=e+1;a[e>>0]=m?43:45;c[g>>2]=0;m=0}else n=5;while(0);a:do if((n|0)==5){n=a[i>>0]|0;if(b<<24>>24==h<<24>>24?(((n&1)==0?(n&255)>>>1:c[i+4>>2]|0)|0)!=0:0){m=c[k>>2]|0;if((m-j|0)>=160){m=0;break}d=c[g>>2]|0;c[k>>2]=m+4;c[m>>2]=d;c[g>>2]=0;m=0;break}i=l+26|0;m=l;while(1){if((a[m>>0]|0)==b<<24>>24)break;m=m+1|0;if((m|0)==(i|0)){m=i;break}}m=m-l|0;if((m|0)>23)m=-1;else{switch(d|0){case 10:case 8:{if((m|0)>=(d|0)){m=-1;break a}break}case 16:{if((m|0)>=22){if(p){m=-1;break a}if((o-e|0)>=3){m=-1;break a}if((a[o+-1>>0]|0)!=48){m=-1;break a}c[g>>2]=0;m=a[59857+m>>0]|0;c[f>>2]=o+1;a[o>>0]=m;m=0;break a}break}default:{}}m=a[59857+m>>0]|0;c[f>>2]=o+1;a[o>>0]=m;c[g>>2]=(c[g>>2]|0)+1;m=0}}while(0);return m|0}function rE(){var b=0,d=0;do if((a[3088]|0)==0?(Hb(3088)|0)!=0:0){o=0;b=ya(121,2147483647,61244,0)|0;d=o;o=0;if(d&1){d=cc()|0;rc(3088);bc(d|0)}else{c[10367]=b;Cc(3088);break}}while(0);return c[10367]|0}function sE(a){a=a|0;return}function tE(a){a=a|0;Uz(a);return}function uE(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0;s=i;i=i+64|0;q=s+56|0;j=s+52|0;n=s+48|0;k=s+44|0;l=s+40|0;m=s+36|0;p=s+32|0;t=s+8|0;r=s;a:do if(!(c[f+4>>2]&1)){c[n>>2]=-1;t=c[(c[b>>2]|0)+16>>2]|0;c[k>>2]=c[d>>2];c[l>>2]=c[e>>2];c[j>>2]=c[k>>2];c[q>>2]=c[l>>2];j=ad[t&127](b,j,q,f,g,n)|0;c[d>>2]=j;switch(c[n>>2]|0){case 0:{a[h>>0]=0;break a}case 1:{a[h>>0]=1;break a}default:{a[h>>0]=1;c[g>>2]=4;break a}}}else{j=lD(f)|0;c[m>>2]=j;o=0;b=Wa(115,m|0,40896)|0;n=o;o=0;do if(!(n&1)){EL(j)|0;j=lD(f)|0;c[p>>2]=j;o=0;l=Wa(115,p|0,41052)|0;p=o;o=0;if(p&1){t=cc()|0;EL(j)|0;j=t;break}EL(j)|0;o=0;ma(c[(c[l>>2]|0)+24>>2]|0,t|0,l|0);p=o;o=0;if(!(p&1)){k=t+12|0;o=0;ma(c[(c[l>>2]|0)+28>>2]|0,k|0,l|0);p=o;o=0;if(!(p&1)){c[r>>2]=c[e>>2];o=0;c[q>>2]=c[r>>2];j=ea(51,d|0,q|0,t|0,t+24|0,b|0,g|0,1)|0;g=o;o=0;if(g&1){j=cc()|0;ZC(t+12|0);ZC(t);break}else{a[h>>0]=(j|0)==(t|0)&1;j=c[d>>2]|0;ZC(t+12|0);ZC(t);break a}}}else k=t;j=cc()|0;l=D;if((t|0)!=(k|0))do{k=k+-12|0;ZC(k)}while((k|0)!=(t|0))}else{t=cc()|0;EL(j)|0;j=t}while(0);bc(j|0)}while(0);i=s;return j|0}function vE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=dK(a,k,j,e,f,g)|0;i=h;return a|0}function wE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=eK(a,k,j,e,f,g)|0;i=h;return a|0}function xE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=fK(a,k,j,e,f,g)|0;i=h;return a|0}function yE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=gK(a,k,j,e,f,g)|0;i=h;return a|0}function zE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=hK(a,k,j,e,f,g)|0;i=h;return a|0}function AE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=iK(a,k,j,e,f,g)|0;i=h;return a|0}function BE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=jK(a,k,j,e,f,g)|0;i=h;return a|0}function CE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=kK(a,k,j,e,f,g)|0;i=h;return a|0}function DE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=lK(a,k,j,e,f,g)|0;i=h;return a|0}function EE(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;B=i;i=i+320|0;w=B;r=B+208|0;D=B+32|0;b=B+28|0;C=B+16|0;v=B+12|0;t=B+48|0;u=B+8|0;s=B+4|0;c[D>>2]=0;c[D+4>>2]=0;c[D+8>>2]=0;o=0;f=qa(192,f|0)|0;q=o;o=0;do if(q&1)b=cc()|0;else{c[b>>2]=f;o=0;b=Wa(115,b|0,40896)|0;q=o;o=0;if(!(q&1)?(o=0,kb(c[(c[b>>2]|0)+48>>2]|0,b|0,59857,59883,r|0)|0,q=o,o=0,!(q&1)):0){EL(f)|0;c[C>>2]=0;c[C+4>>2]=0;c[C+8>>2]=0;if(!(a[C>>0]&1))b=10;else b=(c[C>>2]&-2)+-1|0;o=0;mb(80,C|0,b|0,0);q=o;o=0;a:do if(!(q&1)){p=C+8|0;q=C+1|0;b=(a[C>>0]&1)==0?q:c[p>>2]|0;c[v>>2]=b;c[u>>2]=t;c[s>>2]=0;n=C+4|0;j=c[d>>2]|0;b:while(1){if(j){f=c[j+12>>2]|0;if((f|0)==(c[j+16>>2]|0)){o=0;f=qa(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;m=o;o=0;if(m&1){E=30;break}}else f=c[f>>2]|0;if((f|0)==-1){c[d>>2]=0;f=0;k=1}else{f=j;k=0}}else{f=0;k=1}l=c[e>>2]|0;do if(l){j=c[l+12>>2]|0;if((j|0)==(c[l+16>>2]|0)){o=0;j=qa(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;m=o;o=0;if(m&1){E=30;break b}}else j=c[j>>2]|0;if((j|0)!=-1)if(k){j=l;break}else{j=l;break b}else{c[e>>2]=0;E=20;break}}else E=20;while(0);if((E|0)==20){E=0;if(k){j=0;break}else j=0}k=a[C>>0]|0;k=(k&1)==0?(k&255)>>>1:c[n>>2]|0;if((c[v>>2]|0)==(b+k|0)){o=0;mb(80,C|0,k<<1|0,0);m=o;o=0;if(m&1){E=30;break}if(!(a[C>>0]&1))b=10;else b=(c[C>>2]&-2)+-1|0;o=0;mb(80,C|0,b|0,0);m=o;o=0;if(m&1){E=30;break}b=(a[C>>0]&1)==0?q:c[p>>2]|0;c[v>>2]=b+k}l=f+12|0;k=c[l>>2]|0;m=f+16|0;if((k|0)==(c[m>>2]|0)){o=0;k=qa(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;F=o;o=0;if(F&1){E=30;break}}else k=c[k>>2]|0;if(FE(k,16,b,v,s,0,D,t,u,r)|0)break;j=c[l>>2]|0;if((j|0)==(c[m>>2]|0)){o=0;qa(c[(c[f>>2]|0)+40>>2]|0,f|0)|0;F=o;o=0;if(F&1){E=30;break}else{j=f;continue}}else{c[l>>2]=j+4;j=f;continue}}if((E|0)==30){b=cc()|0;break}o=0;mb(80,C|0,(c[v>>2]|0)-b|0,0);F=o;o=0;if((!(F&1)?(x=a[C>>0]|0,y=c[p>>2]|0,o=0,z=gb(45)|0,F=o,o=0,!(F&1)):0)?(o=0,c[w>>2]=h,A=kb(64,((x&1)==0?q:y)|0,z|0,61241,w|0)|0,F=o,o=0,!(F&1)):0){if((A|0)!=1)c[g>>2]=4;if(f){b=c[f+12>>2]|0;if((b|0)==(c[f+16>>2]|0)){o=0;b=qa(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;F=o;o=0;if(F&1){E=31;break}}else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;f=1}else f=0}else f=1;do if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0)){o=0;b=qa(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;F=o;o=0;if(F&1){E=31;break a}}else b=c[b>>2]|0;if((b|0)!=-1)if(f)break;else{E=59;break}else{c[e>>2]=0;E=57;break}}else E=57;while(0);if((E|0)==57?f:0)E=59;if((E|0)==59)c[g>>2]=c[g>>2]|2;F=c[d>>2]|0;IC(C);IC(D);i=B;return F|0}else E=31}else E=31;while(0);if((E|0)==31)b=cc()|0;IC(C);break}b=cc()|0;EL(f)|0}while(0);IC(D);bc(b|0);return 0}function FE(b,d,e,f,g,h,i,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0;o=c[f>>2]|0;p=(o|0)==(e|0);do if(p){m=(c[l+96>>2]|0)==(b|0);if(!m?(c[l+100>>2]|0)!=(b|0):0){n=5;break}c[f>>2]=e+1;a[e>>0]=m?43:45;c[g>>2]=0;m=0}else n=5;while(0);a:do if((n|0)==5){n=a[i>>0]|0;if((b|0)==(h|0)?(((n&1)==0?(n&255)>>>1:c[i+4>>2]|0)|0)!=0:0){m=c[k>>2]|0;if((m-j|0)>=160){m=0;break}d=c[g>>2]|0;c[k>>2]=m+4;c[m>>2]=d;c[g>>2]=0;m=0;break}i=l+104|0;m=l;while(1){if((c[m>>2]|0)==(b|0))break;m=m+4|0;if((m|0)==(i|0)){m=i;break}}m=m-l|0;i=m>>2;if((m|0)>92)m=-1;else{switch(d|0){case 10:case 8:{if((i|0)>=(d|0)){m=-1;break a}break}case 16:{if((m|0)>=88){if(p){m=-1;break a}if((o-e|0)>=3){m=-1;break a}if((a[o+-1>>0]|0)!=48){m=-1;break a}c[g>>2]=0;m=a[59857+i>>0]|0;c[f>>2]=o+1;a[o>>0]=m;m=0;break a}break}default:{}}m=a[59857+i>>0]|0;c[f>>2]=o+1;a[o>>0]=m;c[g>>2]=(c[g>>2]|0)+1;m=0}}while(0);return m|0}function GE(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;k=l;d=lD(d)|0;c[k>>2]=d;o=0;g=Wa(115,k|0,40904)|0;m=o;o=0;if((((!(m&1)?(o=0,kb(c[(c[g>>2]|0)+32>>2]|0,g|0,59857,59883,e|0)|0,m=o,o=0,!(m&1)):0)?(o=0,j=Wa(115,k|0,41044)|0,m=o,o=0,!(m&1)):0)?(o=0,h=qa(c[(c[j>>2]|0)+16>>2]|0,j|0)|0,m=o,o=0,!(m&1)):0)?(a[f>>0]=h,o=0,ma(c[(c[j>>2]|0)+20>>2]|0,b|0,j|0),m=o,o=0,!(m&1)):0){EL(d)|0;i=l;return}m=cc()|0;EL(d)|0;bc(m|0)}function HE(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0;n=i;i=i+16|0;m=n;d=lD(d)|0;c[m>>2]=d;o=0;h=Wa(115,m|0,40904)|0;p=o;o=0;if(((((!(p&1)?(o=0,kb(c[(c[h>>2]|0)+32>>2]|0,h|0,59857,59889,e|0)|0,p=o,o=0,!(p&1)):0)?(o=0,l=Wa(115,m|0,41044)|0,p=o,o=0,!(p&1)):0)?(o=0,j=qa(c[(c[l>>2]|0)+12>>2]|0,l|0)|0,p=o,o=0,!(p&1)):0)?(a[f>>0]=j,o=0,k=qa(c[(c[l>>2]|0)+16>>2]|0,l|0)|0,p=o,o=0,!(p&1)):0)?(a[g>>0]=k,o=0,ma(c[(c[l>>2]|0)+20>>2]|0,b|0,l|0),p=o,o=0,!(p&1)):0){EL(d)|0;i=n;return}p=cc()|0;EL(d)|0;bc(p|0)}function IE(b,e,f,g,h,i,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0;a:do if(b<<24>>24==i<<24>>24)if(a[e>>0]|0){a[e>>0]=0;f=c[h>>2]|0;c[h>>2]=f+1;a[f>>0]=46;f=a[k>>0]|0;if((((f&1)==0?(f&255)>>>1:c[k+4>>2]|0)|0)!=0?(p=c[m>>2]|0,(p-l|0)<160):0){l=c[n>>2]|0;c[m>>2]=p+4;c[p>>2]=l;p=0}else p=0}else p=-1;else{if(b<<24>>24==j<<24>>24?(j=a[k>>0]|0,(((j&1)==0?(j&255)>>>1:c[k+4>>2]|0)|0)!=0):0){if(!(a[e>>0]|0)){p=-1;break}p=c[m>>2]|0;if((p-l|0)>=160){p=0;break}l=c[n>>2]|0;c[m>>2]=p+4;c[p>>2]=l;c[n>>2]=0;p=0;break}i=o+32|0;p=o;while(1){if((a[p>>0]|0)==b<<24>>24)break;p=p+1|0;if((p|0)==(i|0)){p=i;break}}i=p-o|0;if((i|0)>31)p=-1;else{j=a[59857+i>>0]|0;switch(i|0){case 24:case 25:{p=c[h>>2]|0;if((p|0)!=(g|0)?(d[p+-1>>0]&95|0)!=(d[f>>0]&127|0):0){p=-1;break a}c[h>>2]=p+1;a[p>>0]=j;p=0;break a}case 23:case 22:{a[f>>0]=80;p=c[h>>2]|0;c[h>>2]=p+1;a[p>>0]=j;p=0;break a}default:{p=j&95;if((((p|0)==(a[f>>0]|0)?(a[f>>0]=p|128,(a[e>>0]|0)!=0):0)?(a[e>>0]=0,f=a[k>>0]|0,(((f&1)==0?(f&255)>>>1:c[k+4>>2]|0)|0)!=0):0)?(q=c[m>>2]|0,(q-l|0)<160):0){l=c[n>>2]|0;c[m>>2]=q+4;c[q>>2]=l}m=c[h>>2]|0;c[h>>2]=m+1;a[m>>0]=j;if((i|0)>21){p=0;break a}c[n>>2]=(c[n>>2]|0)+1;p=0;break a}}}}while(0);return p|0}function JE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;k=i;i=i+16|0;j=k;b=lD(b)|0;c[j>>2]=b;o=0;f=Wa(115,j|0,40896)|0;l=o;o=0;if((((!(l&1)?(o=0,kb(c[(c[f>>2]|0)+48>>2]|0,f|0,59857,59883,d|0)|0,l=o,o=0,!(l&1)):0)?(o=0,h=Wa(115,j|0,41052)|0,l=o,o=0,!(l&1)):0)?(o=0,g=qa(c[(c[h>>2]|0)+16>>2]|0,h|0)|0,l=o,o=0,!(l&1)):0)?(c[e>>2]=g,o=0,ma(c[(c[h>>2]|0)+20>>2]|0,a|0,h|0),l=o,o=0,!(l&1)):0){EL(b)|0;i=k;return}l=cc()|0;EL(b)|0;bc(l|0)}function KE(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;m=i;i=i+16|0;l=m;b=lD(b)|0;c[l>>2]=b;o=0;g=Wa(115,l|0,40896)|0;n=o;o=0;if(((((!(n&1)?(o=0,kb(c[(c[g>>2]|0)+48>>2]|0,g|0,59857,59889,d|0)|0,n=o,o=0,!(n&1)):0)?(o=0,k=Wa(115,l|0,41052)|0,n=o,o=0,!(n&1)):0)?(o=0,h=qa(c[(c[k>>2]|0)+12>>2]|0,k|0)|0,n=o,o=0,!(n&1)):0)?(c[e>>2]=h,o=0,j=qa(c[(c[k>>2]|0)+16>>2]|0,k|0)|0,n=o,o=0,!(n&1)):0)?(c[f>>2]=j,o=0,ma(c[(c[k>>2]|0)+20>>2]|0,a|0,k|0),n=o,o=0,!(n&1)):0){EL(b)|0;i=m;return}n=cc()|0;EL(b)|0;bc(n|0)}function LE(b,e,f,g,h,i,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0;a:do if((b|0)==(i|0))if(a[e>>0]|0){a[e>>0]=0;f=c[h>>2]|0;c[h>>2]=f+1;a[f>>0]=46;f=a[k>>0]|0;if((((f&1)==0?(f&255)>>>1:c[k+4>>2]|0)|0)!=0?(p=c[m>>2]|0,(p-l|0)<160):0){l=c[n>>2]|0;c[m>>2]=p+4;c[p>>2]=l;p=0}else p=0}else p=-1;else{if((b|0)==(j|0)?(j=a[k>>0]|0,(((j&1)==0?(j&255)>>>1:c[k+4>>2]|0)|0)!=0):0){if(!(a[e>>0]|0)){p=-1;break}p=c[m>>2]|0;if((p-l|0)>=160){p=0;break}l=c[n>>2]|0;c[m>>2]=p+4;c[p>>2]=l;c[n>>2]=0;p=0;break}i=o+128|0;p=o;while(1){if((c[p>>2]|0)==(b|0))break;p=p+4|0;if((p|0)==(i|0)){p=i;break}}i=p-o|0;p=i>>2;if((i|0)<=124){j=a[59857+p>>0]|0;switch(p|0){case 24:case 25:{p=c[h>>2]|0;if((p|0)!=(g|0)?(d[p+-1>>0]&95|0)!=(d[f>>0]&127|0):0){p=-1;break a}c[h>>2]=p+1;a[p>>0]=j;p=0;break a}case 23:case 22:{a[f>>0]=80;break}default:{p=j&95;if((((p|0)==(a[f>>0]|0)?(a[f>>0]=p|128,(a[e>>0]|0)!=0):0)?(a[e>>0]=0,f=a[k>>0]|0,(((f&1)==0?(f&255)>>>1:c[k+4>>2]|0)|0)!=0):0)?(q=c[m>>2]|0,(q-l|0)<160):0){l=c[n>>2]|0;c[m>>2]=q+4;c[q>>2]=l}}}m=c[h>>2]|0;c[h>>2]=m+1;a[m>>0]=j;if((i|0)>84)p=0;else{c[n>>2]=(c[n>>2]|0)+1;p=0}}else p=-1}while(0);return p|0}function ME(a){a=a|0;return}function NE(a){a=a|0;Uz(a);return}function OE(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;h=n+20|0;j=n+16|0;k=n+12|0;m=n;a:do if(!(c[e+4>>2]&1)){m=c[(c[b>>2]|0)+24>>2]|0;c[j>>2]=c[d>>2];c[h>>2]=c[j>>2];h=sd[m&127](b,h,e,f,g&1)|0}else{h=lD(e)|0;c[k>>2]=h;o=0;j=Wa(115,k|0,41044)|0;l=o;o=0;b:do if(l&1){n=cc()|0;EL(h)|0;h=n}else{EL(h)|0;h=c[j>>2]|0;if(g)$c[c[h+24>>2]&511](m,j);else $c[c[h+28>>2]&511](m,j);b=a[m>>0]|0;l=(b&1)==0;h=m+1|0;g=m+8|0;k=l?h:m+1|0;h=l?h:c[m+8>>2]|0;l=m+4|0;e=(b&1)==0;c:do if((h|0)!=((e?k:c[g>>2]|0)+(e?(b&255)>>>1:c[l>>2]|0)|0)){d:while(1){j=a[h>>0]|0;f=c[d>>2]|0;do if(f){e=f+24|0;b=c[e>>2]|0;if((b|0)!=(c[f+28>>2]|0)){c[e>>2]=b+1;a[b>>0]=j;break}o=0;j=Wa(c[(c[f>>2]|0)+52>>2]|0,f|0,j&255|0)|0;b=o;o=0;if(b&1)break d;if((j|0)==-1)c[d>>2]=0}while(0);h=h+1|0;b=a[m>>0]|0;e=(b&1)==0;if((h|0)==((e?k:c[g>>2]|0)+(e?(b&255)>>>1:c[l>>2]|0)|0))break c}h=cc()|0;IC(m);break b}while(0);h=c[d>>2]|0;IC(m);break a}while(0);bc(h|0)}while(0);i=n;return h|0}function PE(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;n=i;i=i+64|0;h=n;q=n+56|0;r=n+44|0;k=n+20|0;m=n+16|0;l=n+12|0;p=n+8|0;j=n+4|0;a[q>>0]=a[61246]|0;a[q+1>>0]=a[61247]|0;a[q+2>>0]=a[61248]|0;a[q+3>>0]=a[61249]|0;a[q+4>>0]=a[61250]|0;a[q+5>>0]=a[61251]|0;QE(q+1|0,61252,1,c[e+4>>2]|0);b=rE()|0;c[h>>2]=g;g=r+(mK(r,12,b,q,h)|0)|0;q=RE(r,g,e)|0;b=lD(e)|0;c[p>>2]=b;o=0;Oa(46,r|0,q|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){r=cc()|0;EL(b)|0;bc(r|0)}else{EL(b)|0;c[j>>2]=c[d>>2];q=c[m>>2]|0;r=c[l>>2]|0;c[h>>2]=c[j>>2];r=ey(h,k,q,r,e,f)|0;i=n;return r|0}return 0}function QE(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0;if(e&2048){a[b>>0]=43;b=b+1|0}if(e&512){a[b>>0]=35;b=b+1|0}f=a[c>>0]|0;if(f<<24>>24){g=c;while(1){g=g+1|0;c=b+1|0;a[b>>0]=f;f=a[g>>0]|0;if(!(f<<24>>24)){b=c;break}else b=c}}a:do switch(e&74|0){case 64:{a[b>>0]=111;break}case 8:if(!(e&16384)){a[b>>0]=120;break a}else{a[b>>0]=88;break a}default:if(d){a[b>>0]=100;break a}else{a[b>>0]=117;break a}}while(0);return}function RE(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;a:do switch(c[e+4>>2]&176|0){case 16:{e=a[b>>0]|0;switch(e<<24>>24){case 43:case 45:{b=b+1|0;break a}default:{}}if((d-b|0)>1&e<<24>>24==48){switch(a[b+1>>0]|0){case 88:case 120:break;default:{f=7;break a}}b=b+2|0}else f=7;break}case 32:{b=d;break}default:f=7}while(0);return b|0}function SE(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;v=i;i=i+16|0;w=v;t=cI(j,40904)|0;m=cI(j,41044)|0;$c[c[(c[m>>2]|0)+20>>2]&511](w,m);r=a[w>>0]|0;s=w+4|0;a:do if(!(((r&1)==0?(r&255)>>>1:c[s>>2]|0)|0)){o=0;kb(c[(c[t>>2]|0)+32>>2]|0,t|0,b|0,e|0,f|0)|0;u=o;o=0;if(u&1)u=5;else{j=f+(e-b)|0;c[h>>2]=j;u=29}}else{c[h>>2]=f;j=a[b>>0]|0;switch(j<<24>>24){case 43:case 45:{o=0;j=Wa(c[(c[t>>2]|0)+28>>2]|0,t|0,j|0)|0;r=o;o=0;if(r&1){u=5;break a}l=c[h>>2]|0;c[h>>2]=l+1;a[l>>0]=j;l=b+1|0;break}default:l=b}b:do if((e-l|0)>1?(a[l>>0]|0)==48:0){j=l+1|0;switch(a[j>>0]|0){case 88:case 120:break;default:break b}o=0;k=Wa(c[(c[t>>2]|0)+28>>2]|0,t|0,48)|0;r=o;o=0;if(r&1){u=5;break a}r=c[h>>2]|0;c[h>>2]=r+1;a[r>>0]=k;o=0;j=Wa(c[(c[t>>2]|0)+28>>2]|0,t|0,a[j>>0]|0)|0;r=o;o=0;if(r&1){u=5;break a}r=c[h>>2]|0;c[h>>2]=r+1;a[r>>0]=j;l=l+2|0}while(0);if((l|0)!=(e|0)?(n=e+-1|0,l>>>0<n>>>0):0){k=l;j=n;do{r=a[k>>0]|0;a[k>>0]=a[j>>0]|0;a[j>>0]=r;k=k+1|0;j=j+-1|0}while(k>>>0<j>>>0)}o=0;n=qa(c[(c[m>>2]|0)+16>>2]|0,m|0)|0;r=o;o=0;if(!(r&1)){p=w+8|0;q=w+1|0;c:do if(l>>>0<e>>>0){j=0;k=0;r=l;while(1){m=a[((a[w>>0]&1)==0?q:c[p>>2]|0)+k>>0]|0;if(m<<24>>24!=0&(j|0)==(m<<24>>24|0)){j=c[h>>2]|0;c[h>>2]=j+1;a[j>>0]=n;j=a[w>>0]|0;m=0;k=(k>>>0<(((j&1)==0?(j&255)>>>1:c[s>>2]|0)+-1|0)>>>0&1)+k|0}else m=j;o=0;j=Wa(c[(c[t>>2]|0)+28>>2]|0,t|0,a[r>>0]|0)|0;x=o;o=0;if(x&1)break;x=c[h>>2]|0;c[h>>2]=x+1;a[x>>0]=j;r=r+1|0;if(r>>>0>=e>>>0)break c;else j=m+1|0}j=cc()|0;break a}while(0);k=b;j=f+(l-k)|0;b=c[h>>2]|0;if((j|0)==(b|0)){b=k;u=29}else{b=b+-1|0;if(j>>>0<b>>>0)do{x=a[j>>0]|0;a[j>>0]=a[b>>0]|0;a[b>>0]=x;j=j+1|0;b=b+-1|0}while(j>>>0<b>>>0);b=k;j=c[h>>2]|0;u=29}}else u=5}while(0);if((u|0)==5)j=cc()|0;else if((u|0)==29){c[g>>2]=(d|0)==(e|0)?j:f+(d-b)|0;IC(w);i=v;return}IC(w);bc(j|0)}function TE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;n=i;i=i+96|0;h=n+8|0;a=n;q=n+74|0;k=n+32|0;m=n+28|0;l=n+24|0;p=n+20|0;j=n+16|0;r=a;c[r>>2]=37;c[r+4>>2]=0;QE(a+1|0,61254,1,c[d+4>>2]|0);r=rE()|0;s=h;c[s>>2]=f;c[s+4>>2]=g;g=q+(mK(q,22,r,a,h)|0)|0;f=RE(q,g,d)|0;a=lD(d)|0;c[p>>2]=a;o=0;Oa(46,q|0,f|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){s=cc()|0;EL(a)|0;bc(s|0)}else{EL(a)|0;c[j>>2]=c[b>>2];r=c[m>>2]|0;s=c[l>>2]|0;c[h>>2]=c[j>>2];s=ey(h,k,r,s,d,e)|0;i=n;return s|0}return 0}function UE(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;n=i;i=i+64|0;h=n;q=n+56|0;r=n+44|0;k=n+20|0;m=n+16|0;l=n+12|0;p=n+8|0;j=n+4|0;a[q>>0]=a[61246]|0;a[q+1>>0]=a[61247]|0;a[q+2>>0]=a[61248]|0;a[q+3>>0]=a[61249]|0;a[q+4>>0]=a[61250]|0;a[q+5>>0]=a[61251]|0;QE(q+1|0,61252,0,c[e+4>>2]|0);b=rE()|0;c[h>>2]=g;g=r+(mK(r,12,b,q,h)|0)|0;q=RE(r,g,e)|0;b=lD(e)|0;c[p>>2]=b;o=0;Oa(46,r|0,q|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){r=cc()|0;EL(b)|0;bc(r|0)}else{EL(b)|0;c[j>>2]=c[d>>2];q=c[m>>2]|0;r=c[l>>2]|0;c[h>>2]=c[j>>2];r=ey(h,k,q,r,e,f)|0;i=n;return r|0}return 0}function VE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;n=i;i=i+112|0;h=n+8|0;a=n;q=n+75|0;k=n+32|0;m=n+28|0;l=n+24|0;p=n+20|0;j=n+16|0;r=a;c[r>>2]=37;c[r+4>>2]=0;QE(a+1|0,61254,0,c[d+4>>2]|0);r=rE()|0;s=h;c[s>>2]=f;c[s+4>>2]=g;g=q+(mK(q,23,r,a,h)|0)|0;f=RE(q,g,d)|0;a=lD(d)|0;c[p>>2]=a;o=0;Oa(46,q|0,f|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){s=cc()|0;EL(a)|0;bc(s|0)}else{EL(a)|0;c[j>>2]=c[b>>2];r=c[m>>2]|0;s=c[l>>2]|0;c[h>>2]=c[j>>2];s=ey(h,k,r,s,d,e)|0;i=n;return s|0}return 0}function WE(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+176|0;u=z+84|0;q=z+48|0;p=z+32|0;l=z+24|0;g=z+8|0;n=z;s=z+88|0;t=z+80|0;k=z+118|0;y=z+76|0;x=z+72|0;v=z+68|0;w=z+64|0;m=n;c[m>>2]=37;c[m+4>>2]=0;m=XE(n+1|0,61257,c[d+4>>2]|0)|0;c[t>>2]=s;a=rE()|0;if(m){c[g>>2]=c[d+8>>2];h[g+8>>3]=f;g=mK(s,30,a,n,g)|0}else{h[l>>3]=f;g=mK(s,30,a,n,l)|0}a:do if((g|0)>29){o=0;a=gb(45)|0;g=o;o=0;g=g&1;if(m){if(!g?(o=0,c[p>>2]=c[d+8>>2],h[p+8>>3]=f,j=kb(65,t|0,a|0,n|0,p|0)|0,r=o,o=0,!(r&1)):0)A=12}else if(!g?(o=0,c[q>>2]=c[d+8>>2],h[q+8>>3]=f,r=kb(65,t|0,a|0,n|0,q|0)|0,q=o,o=0,!(q&1)):0){j=r;A=12}do if((A|0)==12){a=c[t>>2]|0;if(!a){o=0;ob(46);r=o;o=0;if(r&1)break;g=c[t>>2]|0}else g=a;a=g;n=g;A=16;break a}while(0);a=cc()|0}else{a=c[t>>2]|0;n=0;j=g;A=16}while(0);if((A|0)==16){l=a+j|0;m=RE(a,l,d)|0;do if((a|0)==(s|0)){a=s;g=0;A=22}else{j=yC(j<<1)|0;if(!j){o=0;ob(46);A=o;o=0;if(A&1){g=0;A=20;break}a=c[t>>2]|0}g=j;k=j;A=22}while(0);do if((A|0)==22){o=0;j=qa(192,d|0)|0;t=o;o=0;if(!(t&1)){c[v>>2]=j;o=0;Oa(47,a|0,m|0,l|0,k|0,y|0,x|0,v|0);v=o;o=0;if(v&1){a=cc()|0;EL(j)|0;break}EL(j)|0;c[w>>2]=c[b>>2];A=c[y>>2]|0;a=c[x>>2]|0;o=0;c[u>>2]=c[w>>2];a=oa(83,u|0,k|0,A|0,a|0,d|0,e|0)|0;A=o;o=0;if(!(A&1)){c[b>>2]=a;if(g)zC(g);if(n)zC(n);i=z;return a|0}else A=20}else A=20}while(0);if((A|0)==20)a=cc()|0;if(g)zC(g);if(n)zC(n)}bc(a|0);return 0}function XE(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if(d&2048){a[b>>0]=43;b=b+1|0}if(d&1024){a[b>>0]=35;b=b+1|0}h=d&260;f=d>>>14;i=(h|0)==260;if(i)g=0;else{a[b>>0]=46;a[b+1>>0]=42;b=b+2|0;g=1}d=a[c>>0]|0;if(d<<24>>24){e=b;while(1){c=c+1|0;b=e+1|0;a[e>>0]=d;d=a[c>>0]|0;if(!(d<<24>>24))break;else e=b}}a:do switch(h|0){case 4:if(!(f&1)){a[b>>0]=102;break a}else{a[b>>0]=70;break a}case 256:if(!(f&1)){a[b>>0]=101;break a}else{a[b>>0]=69;break a}default:{d=(f&1|0)!=0;if(i)if(d){a[b>>0]=65;break a}else{a[b>>0]=97;break a}else if(d){a[b>>0]=71;break a}else{a[b>>0]=103;break a}}}while(0);return g|0}function YE(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;z=i;i=i+16|0;A=z;y=cI(j,40904)|0;w=cI(j,41044)|0;$c[c[(c[w>>2]|0)+20>>2]&511](A,w);c[h>>2]=f;j=a[b>>0]|0;switch(j<<24>>24){case 43:case 45:{o=0;j=Wa(c[(c[y>>2]|0)+28>>2]|0,y|0,j|0)|0;x=o;o=0;if(x&1)v=8;else{n=c[h>>2]|0;c[h>>2]=n+1;a[n>>0]=j;n=b+1|0;v=10}break}default:{n=b;v=10}}a:do if((v|0)==10){x=e;b:do if((x-n|0)>1?(a[n>>0]|0)==48:0){l=n+1|0;switch(a[l>>0]|0){case 88:case 120:break;default:{v=11;break b}}o=0;j=Wa(c[(c[y>>2]|0)+28>>2]|0,y|0,48)|0;u=o;o=0;if(u&1){v=8;break a}u=c[h>>2]|0;c[h>>2]=u+1;a[u>>0]=j;n=n+2|0;o=0;j=Wa(c[(c[y>>2]|0)+28>>2]|0,y|0,a[l>>0]|0)|0;u=o;o=0;if(u&1){v=8;break a}u=c[h>>2]|0;c[h>>2]=u+1;a[u>>0]=j;if(n>>>0<e>>>0){j=n;while(1){l=a[j>>0]|0;o=0;m=gb(45)|0;u=o;o=0;if(u&1)break;o=0;l=Wa(116,l<<24>>24|0,m|0)|0;u=o;o=0;if(u&1)break;if(!l){u=n;break b}j=j+1|0;if(j>>>0>=e>>>0){u=n;break b}}j=cc()|0;break a}else{u=n;j=n}}else v=11;while(0);c:do if((v|0)==11)if(n>>>0<e>>>0){j=n;while(1){l=a[j>>0]|0;o=0;m=gb(45)|0;u=o;o=0;if(u&1)break;o=0;l=Wa(117,l<<24>>24|0,m|0)|0;u=o;o=0;if(u&1)break;if(!l){u=n;break c}j=j+1|0;if(j>>>0>=e>>>0){u=n;break c}}j=cc()|0;break a}else{u=n;j=n}while(0);s=a[A>>0]|0;t=A+4|0;if(((s&1)==0?(s&255)>>>1:c[t>>2]|0)|0){if((u|0)!=(j|0)?(p=j+-1|0,u>>>0<p>>>0):0){m=u;l=p;do{s=a[m>>0]|0;a[m>>0]=a[l>>0]|0;a[l>>0]=s;m=m+1|0;l=l+-1|0}while(m>>>0<l>>>0)}o=0;p=qa(c[(c[w>>2]|0)+16>>2]|0,w|0)|0;s=o;o=0;if(s&1){v=8;break}q=A+8|0;r=A+1|0;d:do if(u>>>0<j>>>0){l=0;m=0;s=u;while(1){n=a[((a[A>>0]&1)==0?r:c[q>>2]|0)+m>>0]|0;if(n<<24>>24>0&(l|0)==(n<<24>>24|0)){l=c[h>>2]|0;c[h>>2]=l+1;a[l>>0]=p;l=a[A>>0]|0;n=0;m=(m>>>0<(((l&1)==0?(l&255)>>>1:c[t>>2]|0)+-1|0)>>>0&1)+m|0}else n=l;o=0;l=Wa(c[(c[y>>2]|0)+28>>2]|0,y|0,a[s>>0]|0)|0;B=o;o=0;if(B&1)break;B=c[h>>2]|0;c[h>>2]=B+1;a[B>>0]=l;s=s+1|0;if(s>>>0>=j>>>0)break d;else l=n+1|0}j=cc()|0;break a}while(0);l=f+(u-b)|0;m=c[h>>2]|0;if((l|0)!=(m|0)?(k=m+-1|0,l>>>0<k>>>0):0){do{B=a[l>>0]|0;a[l>>0]=a[k>>0]|0;a[k>>0]=B;l=l+1|0;k=k+-1|0}while(l>>>0<k>>>0);l=y}else l=y}else{o=0;kb(c[(c[y>>2]|0)+32>>2]|0,y|0,u|0,j|0,c[h>>2]|0)|0;B=o;o=0;if(B&1){v=8;break}c[h>>2]=(c[h>>2]|0)+(j-u);l=y}e:do if(j>>>0<e>>>0){while(1){k=a[j>>0]|0;if(k<<24>>24==46)break;o=0;k=Wa(c[(c[l>>2]|0)+28>>2]|0,y|0,k|0)|0;B=o;o=0;if(B&1){v=4;break}B=c[h>>2]|0;c[h>>2]=B+1;a[B>>0]=k;j=j+1|0;if(j>>>0>=e>>>0)break e}if((v|0)==4){j=cc()|0;break a}o=0;k=qa(c[(c[w>>2]|0)+12>>2]|0,w|0)|0;B=o;o=0;if(B&1){v=8;break a}B=c[h>>2]|0;c[h>>2]=B+1;a[B>>0]=k;j=j+1|0}while(0);o=0;kb(c[(c[y>>2]|0)+32>>2]|0,y|0,j|0,e|0,c[h>>2]|0)|0;B=o;o=0;if(B&1)v=8;else{B=(c[h>>2]|0)+(x-j)|0;c[h>>2]=B;c[g>>2]=(d|0)==(e|0)?B:f+(d-b)|0;IC(A);i=z;return}}while(0);if((v|0)==8)j=cc()|0;IC(A);bc(j|0)}function ZE(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+176|0;u=z+76|0;q=z+48|0;p=z+32|0;l=z+24|0;g=z+8|0;n=z;s=z+80|0;t=z+72|0;k=z+110|0;y=z+68|0;x=z+64|0;v=z+60|0;w=z+56|0;m=n;c[m>>2]=37;c[m+4>>2]=0;m=XE(n+1|0,61258,c[d+4>>2]|0)|0;c[t>>2]=s;a=rE()|0;if(m){c[g>>2]=c[d+8>>2];h[g+8>>3]=f;g=mK(s,30,a,n,g)|0}else{h[l>>3]=f;g=mK(s,30,a,n,l)|0}a:do if((g|0)>29){o=0;a=gb(45)|0;g=o;o=0;g=g&1;if(m){if(!g?(o=0,c[p>>2]=c[d+8>>2],h[p+8>>3]=f,j=kb(65,t|0,a|0,n|0,p|0)|0,r=o,o=0,!(r&1)):0)A=12}else if(!g?(o=0,h[q>>3]=f,r=kb(65,t|0,a|0,n|0,q|0)|0,q=o,o=0,!(q&1)):0){j=r;A=12}do if((A|0)==12){a=c[t>>2]|0;if(!a){o=0;ob(46);r=o;o=0;if(r&1)break;g=c[t>>2]|0}else g=a;a=g;n=g;A=16;break a}while(0);a=cc()|0}else{a=c[t>>2]|0;n=0;j=g;A=16}while(0);if((A|0)==16){l=a+j|0;m=RE(a,l,d)|0;do if((a|0)==(s|0)){a=s;g=0;A=22}else{j=yC(j<<1)|0;if(!j){o=0;ob(46);A=o;o=0;if(A&1){g=0;A=20;break}a=c[t>>2]|0}g=j;k=j;A=22}while(0);do if((A|0)==22){o=0;j=qa(192,d|0)|0;t=o;o=0;if(!(t&1)){c[v>>2]=j;o=0;Oa(47,a|0,m|0,l|0,k|0,y|0,x|0,v|0);v=o;o=0;if(v&1){a=cc()|0;EL(j)|0;break}EL(j)|0;c[w>>2]=c[b>>2];A=c[y>>2]|0;a=c[x>>2]|0;o=0;c[u>>2]=c[w>>2];a=oa(83,u|0,k|0,A|0,a|0,d|0,e|0)|0;A=o;o=0;if(!(A&1)){c[b>>2]=a;if(g)zC(g);if(n)zC(n);i=z;return a|0}else A=20}else A=20}while(0);if((A|0)==20)a=cc()|0;if(g)zC(g);if(n)zC(n)}bc(a|0);return 0}function _E(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;q=i;i=i+80|0;l=q;b=q+70|0;n=q+12|0;p=q+32|0;k=q+8|0;m=q+4|0;a[b>>0]=a[61260]|0;a[b+1>>0]=a[61261]|0;a[b+2>>0]=a[61262]|0;a[b+3>>0]=a[61263]|0;a[b+4>>0]=a[61264]|0;a[b+5>>0]=a[61265]|0;h=rE()|0;c[l>>2]=g;b=mK(n,20,h,b,l)|0;g=n+b|0;h=RE(n,g,e)|0;j=lD(e)|0;c[k>>2]=j;o=0;k=Wa(115,k|0,40904)|0;r=o;o=0;if(r&1){r=cc()|0;EL(j)|0;bc(r|0)}else{EL(j)|0;zd[c[(c[k>>2]|0)+32>>2]&127](k,n,g,p)|0;r=p+b|0;c[m>>2]=c[d>>2];c[l>>2]=c[m>>2];r=ey(l,p,(h|0)==(g|0)?r:p+(h-n)|0,r,e,f)|0;i=q;return r|0}return 0}function $E(a){a=a|0;return}function aF(a){a=a|0;Uz(a);return}function bF(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;h=m+20|0;j=m+16|0;k=m+12|0;l=m;a:do if(!(c[e+4>>2]&1)){l=c[(c[b>>2]|0)+24>>2]|0;c[j>>2]=c[d>>2];c[h>>2]=c[j>>2];h=sd[l&127](b,h,e,f,g&1)|0}else{h=lD(e)|0;c[k>>2]=h;o=0;j=Wa(115,k|0,41052)|0;k=o;o=0;b:do if(k&1){m=cc()|0;EL(h)|0;h=m}else{EL(h)|0;h=c[j>>2]|0;if(g)$c[c[h+24>>2]&511](l,j);else $c[c[h+28>>2]&511](l,j);b=a[l>>0]|0;e=(b&1)==0;h=l+4|0;g=l+8|0;k=e?h:l+4|0;h=e?h:c[l+8>>2]|0;e=(b&1)==0;c:do if((h|0)!=((e?k:c[g>>2]|0)+((e?(b&255)>>>1:c[k>>2]|0)<<2)|0)){while(1){j=c[h>>2]|0;f=c[d>>2]|0;if(f){e=f+24|0;b=c[e>>2]|0;if((b|0)==(c[f+28>>2]|0)){o=0;j=Wa(c[(c[f>>2]|0)+52>>2]|0,f|0,j|0)|0;b=o;o=0;if(b&1)break}else{c[e>>2]=b+4;c[b>>2]=j}if((j|0)==-1)c[d>>2]=0}h=h+4|0;b=a[l>>0]|0;e=(b&1)==0;if((h|0)==((e?k:c[g>>2]|0)+((e?(b&255)>>>1:c[k>>2]|0)<<2)|0))break c}h=cc()|0;ZC(l);break b}while(0);h=c[d>>2]|0;ZC(l);break a}while(0);bc(h|0)}while(0);i=m;return h|0}function cF(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;n=i;i=i+128|0;h=n;q=n+116|0;r=n+104|0;k=n+20|0;m=n+16|0;l=n+12|0;p=n+8|0;j=n+4|0;a[q>>0]=a[61246]|0;a[q+1>>0]=a[61247]|0;a[q+2>>0]=a[61248]|0;a[q+3>>0]=a[61249]|0;a[q+4>>0]=a[61250]|0;a[q+5>>0]=a[61251]|0;QE(q+1|0,61252,1,c[e+4>>2]|0);b=rE()|0;c[h>>2]=g;g=r+(mK(r,12,b,q,h)|0)|0;q=RE(r,g,e)|0;b=lD(e)|0;c[p>>2]=b;o=0;Oa(48,r|0,q|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){r=cc()|0;EL(b)|0;bc(r|0)}else{EL(b)|0;c[j>>2]=c[d>>2];q=c[m>>2]|0;r=c[l>>2]|0;c[h>>2]=c[j>>2];r=oK(h,k,q,r,e,f)|0;i=n;return r|0}return 0}function dF(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;v=i;i=i+16|0;w=v;t=cI(j,40896)|0;m=cI(j,41052)|0;$c[c[(c[m>>2]|0)+20>>2]&511](w,m);r=a[w>>0]|0;s=w+4|0;a:do if(!(((r&1)==0?(r&255)>>>1:c[s>>2]|0)|0)){o=0;kb(c[(c[t>>2]|0)+48>>2]|0,t|0,b|0,e|0,f|0)|0;u=o;o=0;if(u&1)u=5;else{j=f+(e-b<<2)|0;c[h>>2]=j;u=28}}else{c[h>>2]=f;j=a[b>>0]|0;switch(j<<24>>24){case 43:case 45:{o=0;j=Wa(c[(c[t>>2]|0)+44>>2]|0,t|0,j|0)|0;r=o;o=0;if(r&1){u=5;break a}l=c[h>>2]|0;c[h>>2]=l+4;c[l>>2]=j;l=b+1|0;break}default:l=b}b:do if((e-l|0)>1?(a[l>>0]|0)==48:0){j=l+1|0;switch(a[j>>0]|0){case 88:case 120:break;default:{r=l;break b}}o=0;k=Wa(c[(c[t>>2]|0)+44>>2]|0,t|0,48)|0;r=o;o=0;if(r&1){u=5;break a}r=c[h>>2]|0;c[h>>2]=r+4;c[r>>2]=k;o=0;j=Wa(c[(c[t>>2]|0)+44>>2]|0,t|0,a[j>>0]|0)|0;r=o;o=0;if(r&1){u=5;break a}r=c[h>>2]|0;c[h>>2]=r+4;c[r>>2]=j;r=l+2|0}else r=l;while(0);if((r|0)!=(e|0)?(n=e+-1|0,r>>>0<n>>>0):0){k=r;j=n;do{q=a[k>>0]|0;a[k>>0]=a[j>>0]|0;a[j>>0]=q;k=k+1|0;j=j+-1|0}while(k>>>0<j>>>0)}o=0;m=qa(c[(c[m>>2]|0)+16>>2]|0,m|0)|0;q=o;o=0;if(!(q&1)){n=w+8|0;p=w+1|0;c:do if(r>>>0<e>>>0){j=0;k=0;q=r;while(1){l=a[((a[w>>0]&1)==0?p:c[n>>2]|0)+k>>0]|0;if(l<<24>>24!=0&(j|0)==(l<<24>>24|0)){j=c[h>>2]|0;c[h>>2]=j+4;c[j>>2]=m;j=a[w>>0]|0;l=0;k=(k>>>0<(((j&1)==0?(j&255)>>>1:c[s>>2]|0)+-1|0)>>>0&1)+k|0}else l=j;o=0;j=Wa(c[(c[t>>2]|0)+44>>2]|0,t|0,a[q>>0]|0)|0;x=o;o=0;if(x&1)break;x=c[h>>2]|0;c[h>>2]=x+4;c[x>>2]=j;q=q+1|0;if(q>>>0>=e>>>0)break c;else j=l+1|0}j=cc()|0;break a}while(0);l=b;j=f+(r-l<<2)|0;k=c[h>>2]|0;if((j|0)!=(k|0)){b=k+-4|0;if(j>>>0<b>>>0){do{x=c[j>>2]|0;c[j>>2]=c[b>>2];c[b>>2]=x;j=j+4|0;b=b+-4|0}while(j>>>0<b>>>0);b=l;j=k;u=28}else{b=l;j=k;u=28}}else{b=l;u=28}}else u=5}while(0);if((u|0)==5)j=cc()|0;else if((u|0)==28){c[g>>2]=(d|0)==(e|0)?j:f+(d-b<<2)|0;IC(w);i=v;return}IC(w);bc(j|0)}function eF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;n=i;i=i+224|0;h=n+8|0;a=n;q=n+196|0;k=n+32|0;m=n+28|0;l=n+24|0;p=n+20|0;j=n+16|0;r=a;c[r>>2]=37;c[r+4>>2]=0;QE(a+1|0,61254,1,c[d+4>>2]|0);r=rE()|0;s=h;c[s>>2]=f;c[s+4>>2]=g;g=q+(mK(q,22,r,a,h)|0)|0;f=RE(q,g,d)|0;a=lD(d)|0;c[p>>2]=a;o=0;Oa(48,q|0,f|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){s=cc()|0;EL(a)|0;bc(s|0)}else{EL(a)|0;c[j>>2]=c[b>>2];r=c[m>>2]|0;s=c[l>>2]|0;c[h>>2]=c[j>>2];s=oK(h,k,r,s,d,e)|0;i=n;return s|0}return 0}function fF(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;n=i;i=i+128|0;h=n;q=n+116|0;r=n+104|0;k=n+20|0;m=n+16|0;l=n+12|0;p=n+8|0;j=n+4|0;a[q>>0]=a[61246]|0;a[q+1>>0]=a[61247]|0;a[q+2>>0]=a[61248]|0;a[q+3>>0]=a[61249]|0;a[q+4>>0]=a[61250]|0;a[q+5>>0]=a[61251]|0;QE(q+1|0,61252,0,c[e+4>>2]|0);b=rE()|0;c[h>>2]=g;g=r+(mK(r,12,b,q,h)|0)|0;q=RE(r,g,e)|0;b=lD(e)|0;c[p>>2]=b;o=0;Oa(48,r|0,q|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){r=cc()|0;EL(b)|0;bc(r|0)}else{EL(b)|0;c[j>>2]=c[d>>2];q=c[m>>2]|0;r=c[l>>2]|0;c[h>>2]=c[j>>2];r=oK(h,k,q,r,e,f)|0;i=n;return r|0}return 0}function gF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;n=i;i=i+240|0;h=n+8|0;a=n;q=n+204|0;k=n+32|0;m=n+28|0;l=n+24|0;p=n+20|0;j=n+16|0;r=a;c[r>>2]=37;c[r+4>>2]=0;QE(a+1|0,61254,0,c[d+4>>2]|0);r=rE()|0;s=h;c[s>>2]=f;c[s+4>>2]=g;g=q+(mK(q,23,r,a,h)|0)|0;f=RE(q,g,d)|0;a=lD(d)|0;c[p>>2]=a;o=0;Oa(48,q|0,f|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){s=cc()|0;EL(a)|0;bc(s|0)}else{EL(a)|0;c[j>>2]=c[b>>2];r=c[m>>2]|0;s=c[l>>2]|0;c[h>>2]=c[j>>2];s=oK(h,k,r,s,d,e)|0;i=n;return s|0}return 0}function hF(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+352|0;u=z+312|0;q=z+48|0;p=z+32|0;l=z+24|0;g=z+8|0;n=z;s=z+316|0;t=z+80|0;k=z+84|0;y=z+76|0;x=z+72|0;v=z+68|0;w=z+64|0;m=n;c[m>>2]=37;c[m+4>>2]=0;m=XE(n+1|0,61257,c[d+4>>2]|0)|0;c[t>>2]=s;a=rE()|0;if(m){c[g>>2]=c[d+8>>2];h[g+8>>3]=f;g=mK(s,30,a,n,g)|0}else{h[l>>3]=f;g=mK(s,30,a,n,l)|0}a:do if((g|0)>29){o=0;a=gb(45)|0;g=o;o=0;g=g&1;if(m){if(!g?(o=0,c[p>>2]=c[d+8>>2],h[p+8>>3]=f,j=kb(65,t|0,a|0,n|0,p|0)|0,r=o,o=0,!(r&1)):0)A=12}else if(!g?(o=0,c[q>>2]=c[d+8>>2],h[q+8>>3]=f,r=kb(65,t|0,a|0,n|0,q|0)|0,q=o,o=0,!(q&1)):0){j=r;A=12}do if((A|0)==12){a=c[t>>2]|0;if(!a){o=0;ob(46);r=o;o=0;if(r&1)break;g=c[t>>2]|0}else g=a;a=g;n=g;A=16;break a}while(0);a=cc()|0}else{a=c[t>>2]|0;n=0;j=g;A=16}while(0);if((A|0)==16){l=a+j|0;m=RE(a,l,d)|0;do if((a|0)==(s|0)){a=s;g=0;A=22}else{j=yC(j<<3)|0;if(!j){o=0;ob(46);A=o;o=0;if(A&1){g=0;A=20;break}a=c[t>>2]|0}g=j;k=j;A=22}while(0);do if((A|0)==22){o=0;j=qa(192,d|0)|0;t=o;o=0;if(!(t&1)){c[v>>2]=j;o=0;Oa(49,a|0,m|0,l|0,k|0,y|0,x|0,v|0);v=o;o=0;if(v&1){a=cc()|0;EL(j)|0;break}EL(j)|0;c[w>>2]=c[b>>2];A=c[y>>2]|0;a=c[x>>2]|0;o=0;c[u>>2]=c[w>>2];a=oa(84,u|0,k|0,A|0,a|0,d|0,e|0)|0;A=o;o=0;if(!(A&1)){c[b>>2]=a;if(g)zC(g);if(n)zC(n);i=z;return a|0}else A=20}else A=20}while(0);if((A|0)==20)a=cc()|0;if(g)zC(g);if(n)zC(n)}bc(a|0);return 0}function iF(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;y=i;i=i+16|0;z=y;x=cI(j,40896)|0;v=cI(j,41052)|0;$c[c[(c[v>>2]|0)+20>>2]&511](z,v);c[h>>2]=f;j=a[b>>0]|0;switch(j<<24>>24){case 43:case 45:{o=0;j=Wa(c[(c[x>>2]|0)+44>>2]|0,x|0,j|0)|0;w=o;o=0;if(w&1)u=8;else{m=c[h>>2]|0;c[h>>2]=m+4;c[m>>2]=j;m=b+1|0;u=10}break}default:{m=b;u=10}}a:do if((u|0)==10){w=e;b:do if((w-m|0)>1?(a[m>>0]|0)==48:0){k=m+1|0;switch(a[k>>0]|0){case 88:case 120:break;default:{u=11;break b}}o=0;j=Wa(c[(c[x>>2]|0)+44>>2]|0,x|0,48)|0;t=o;o=0;if(t&1){u=8;break a}t=c[h>>2]|0;c[h>>2]=t+4;c[t>>2]=j;m=m+2|0;o=0;j=Wa(c[(c[x>>2]|0)+44>>2]|0,x|0,a[k>>0]|0)|0;t=o;o=0;if(t&1){u=8;break a}t=c[h>>2]|0;c[h>>2]=t+4;c[t>>2]=j;if(m>>>0<e>>>0){j=m;while(1){k=a[j>>0]|0;o=0;l=gb(45)|0;t=o;o=0;if(t&1)break;o=0;k=Wa(116,k<<24>>24|0,l|0)|0;t=o;o=0;if(t&1)break;if(!k){t=m;break b}j=j+1|0;if(j>>>0>=e>>>0){t=m;break b}}j=cc()|0;break a}else{t=m;j=m}}else u=11;while(0);c:do if((u|0)==11)if(m>>>0<e>>>0){j=m;while(1){k=a[j>>0]|0;o=0;l=gb(45)|0;t=o;o=0;if(t&1)break;o=0;k=Wa(117,k<<24>>24|0,l|0)|0;t=o;o=0;if(t&1)break;if(!k){t=m;break c}j=j+1|0;if(j>>>0>=e>>>0){t=m;break c}}j=cc()|0;break a}else{t=m;j=m}while(0);r=a[z>>0]|0;s=z+4|0;if(((r&1)==0?(r&255)>>>1:c[s>>2]|0)|0){if((t|0)!=(j|0)?(n=j+-1|0,t>>>0<n>>>0):0){l=t;k=n;do{r=a[l>>0]|0;a[l>>0]=a[k>>0]|0;a[k>>0]=r;l=l+1|0;k=k+-1|0}while(l>>>0<k>>>0)}o=0;n=qa(c[(c[v>>2]|0)+16>>2]|0,v|0)|0;r=o;o=0;if(r&1){u=8;break}p=z+8|0;q=z+1|0;d:do if(t>>>0<j>>>0){k=0;l=0;r=t;while(1){m=a[((a[z>>0]&1)==0?q:c[p>>2]|0)+l>>0]|0;if(m<<24>>24>0&(k|0)==(m<<24>>24|0)){k=c[h>>2]|0;c[h>>2]=k+4;c[k>>2]=n;k=a[z>>0]|0;m=0;l=(l>>>0<(((k&1)==0?(k&255)>>>1:c[s>>2]|0)+-1|0)>>>0&1)+l|0}else m=k;o=0;k=Wa(c[(c[x>>2]|0)+44>>2]|0,x|0,a[r>>0]|0)|0;A=o;o=0;if(A&1)break;A=c[h>>2]|0;c[h>>2]=A+4;c[A>>2]=k;r=r+1|0;if(r>>>0>=j>>>0)break d;else k=m+1|0}j=cc()|0;break a}while(0);k=f+(t-b<<2)|0;m=c[h>>2]|0;if((k|0)!=(m|0)){l=m+-4|0;if(k>>>0<l>>>0){do{A=c[k>>2]|0;c[k>>2]=c[l>>2];c[l>>2]=A;k=k+4|0;l=l+-4|0}while(k>>>0<l>>>0);n=x;k=m}else{n=x;k=m}}else n=x}else{o=0;kb(c[(c[x>>2]|0)+48>>2]|0,x|0,t|0,j|0,c[h>>2]|0)|0;A=o;o=0;if(A&1){u=8;break}k=(c[h>>2]|0)+(j-t<<2)|0;c[h>>2]=k;n=x}e:do if(j>>>0<e>>>0){while(1){k=a[j>>0]|0;if(k<<24>>24==46){l=j;break}o=0;l=Wa(c[(c[n>>2]|0)+44>>2]|0,x|0,k|0)|0;A=o;o=0;if(A&1){u=4;break}A=c[h>>2]|0;k=A+4|0;c[h>>2]=k;c[A>>2]=l;j=j+1|0;if(j>>>0>=e>>>0)break e}if((u|0)==4){j=cc()|0;break a}o=0;j=qa(c[(c[v>>2]|0)+12>>2]|0,v|0)|0;A=o;o=0;if(A&1){u=8;break a}A=c[h>>2]|0;k=A+4|0;c[h>>2]=k;c[A>>2]=j;j=l+1|0}while(0);o=0;kb(c[(c[x>>2]|0)+48>>2]|0,x|0,j|0,e|0,k|0)|0;A=o;o=0;if(A&1)u=8;else{A=(c[h>>2]|0)+(w-j<<2)|0;c[h>>2]=A;c[g>>2]=(d|0)==(e|0)?A:f+(d-b<<2)|0;IC(z);i=y;return}}while(0);if((u|0)==8)j=cc()|0;IC(z);bc(j|0)}function jF(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+352|0;u=z+304|0;q=z+48|0;p=z+32|0;l=z+24|0;g=z+8|0;n=z;s=z+308|0;t=z+72|0;k=z+76|0;y=z+68|0;x=z+64|0;v=z+60|0;w=z+56|0;m=n;c[m>>2]=37;c[m+4>>2]=0;m=XE(n+1|0,61258,c[d+4>>2]|0)|0;c[t>>2]=s;a=rE()|0;if(m){c[g>>2]=c[d+8>>2];h[g+8>>3]=f;g=mK(s,30,a,n,g)|0}else{h[l>>3]=f;g=mK(s,30,a,n,l)|0}a:do if((g|0)>29){o=0;a=gb(45)|0;g=o;o=0;g=g&1;if(m){if(!g?(o=0,c[p>>2]=c[d+8>>2],h[p+8>>3]=f,j=kb(65,t|0,a|0,n|0,p|0)|0,r=o,o=0,!(r&1)):0)A=12}else if(!g?(o=0,h[q>>3]=f,r=kb(65,t|0,a|0,n|0,q|0)|0,q=o,o=0,!(q&1)):0){j=r;A=12}do if((A|0)==12){a=c[t>>2]|0;if(!a){o=0;ob(46);r=o;o=0;if(r&1)break;g=c[t>>2]|0}else g=a;a=g;n=g;A=16;break a}while(0);a=cc()|0}else{a=c[t>>2]|0;n=0;j=g;A=16}while(0);if((A|0)==16){l=a+j|0;m=RE(a,l,d)|0;do if((a|0)==(s|0)){a=s;g=0;A=22}else{j=yC(j<<3)|0;if(!j){o=0;ob(46);A=o;o=0;if(A&1){g=0;A=20;break}a=c[t>>2]|0}g=j;k=j;A=22}while(0);do if((A|0)==22){o=0;j=qa(192,d|0)|0;t=o;o=0;if(!(t&1)){c[v>>2]=j;o=0;Oa(49,a|0,m|0,l|0,k|0,y|0,x|0,v|0);v=o;o=0;if(v&1){a=cc()|0;EL(j)|0;break}EL(j)|0;c[w>>2]=c[b>>2];A=c[y>>2]|0;a=c[x>>2]|0;o=0;c[u>>2]=c[w>>2];a=oa(84,u|0,k|0,A|0,a|0,d|0,e|0)|0;A=o;o=0;if(!(A&1)){c[b>>2]=a;if(g)zC(g);if(n)zC(n);i=z;return a|0}else A=20}else A=20}while(0);if((A|0)==20)a=cc()|0;if(g)zC(g);if(n)zC(n)}bc(a|0);return 0}function kF(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;q=i;i=i+192|0;l=q;b=q+180|0;n=q+160|0;p=q+12|0;k=q+8|0;m=q+4|0;a[b>>0]=a[61260]|0;a[b+1>>0]=a[61261]|0;a[b+2>>0]=a[61262]|0;a[b+3>>0]=a[61263]|0;a[b+4>>0]=a[61264]|0;a[b+5>>0]=a[61265]|0;h=rE()|0;c[l>>2]=g;b=mK(n,20,h,b,l)|0;g=n+b|0;h=RE(n,g,e)|0;j=lD(e)|0;c[k>>2]=j;o=0;k=Wa(115,k|0,40896)|0;r=o;o=0;if(r&1){r=cc()|0;EL(j)|0;bc(r|0)}else{EL(j)|0;zd[c[(c[k>>2]|0)+48>>2]&127](k,n,g,p)|0;r=p+(b<<2)|0;c[m>>2]=c[d>>2];c[l>>2]=c[m>>2];r=oK(l,p,(h|0)==(g|0)?r:p+(h-n<<2)|0,r,e,f)|0;i=q;return r|0}return 0}function lF(e,f,g,h,j,k,l,m){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;C=i;i=i+32|0;w=C+16|0;v=C+12|0;z=C+8|0;x=C+4|0;y=C;n=lD(h)|0;c[z>>2]=n;o=0;z=Wa(115,z|0,40904)|0;u=o;o=0;if(u&1){C=cc()|0;EL(n)|0;bc(C|0)}EL(n)|0;c[j>>2]=0;u=z+8|0;n=c[f>>2]|0;a:do if((l|0)!=(m|0)){b:while(1){p=n;if(n){if((c[n+12>>2]|0)==(c[n+16>>2]|0)?(bd[c[(c[n>>2]|0)+36>>2]&255](n)|0)==-1:0){c[f>>2]=0;n=0;p=0}}else n=0;s=(n|0)==0;r=c[g>>2]|0;q=r;do if(r){if((c[r+12>>2]|0)==(c[r+16>>2]|0)?(bd[c[(c[r>>2]|0)+36>>2]&255](r)|0)==-1:0){c[g>>2]=0;q=0;B=12;break}if(!s){B=13;break b}}else B=12;while(0);if((B|0)==12){B=0;if(s){B=13;break}else r=0}c:do if((fd[c[(c[z>>2]|0)+36>>2]&127](z,a[l>>0]|0,0)|0)<<24>>24==37){r=l+1|0;if((r|0)==(m|0)){B=17;break b}t=fd[c[(c[z>>2]|0)+36>>2]&127](z,a[r>>0]|0,0)|0;switch(t<<24>>24){case 48:case 69:{s=l+2|0;if((s|0)==(m|0)){B=20;break b}l=r;r=fd[c[(c[z>>2]|0)+36>>2]&127](z,a[s>>0]|0,0)|0;n=t;break}default:{r=t;n=0}}t=c[(c[e>>2]|0)+36>>2]|0;c[x>>2]=p;c[y>>2]=q;c[v>>2]=c[x>>2];c[w>>2]=c[y>>2];c[f>>2]=Cd[t&63](e,v,w,h,j,k,r,n)|0;l=l+2|0}else{p=a[l>>0]|0;if(p<<24>>24>-1?(A=c[u>>2]|0,(b[A+(p<<24>>24<<1)>>1]&8192)!=0):0){do{l=l+1|0;if((l|0)==(m|0)){l=m;break}p=a[l>>0]|0;if(p<<24>>24<=-1)break}while((b[A+(p<<24>>24<<1)>>1]&8192)!=0);p=r;while(1){if(n){if((c[n+12>>2]|0)==(c[n+16>>2]|0)?(bd[c[(c[n>>2]|0)+36>>2]&255](n)|0)==-1:0){c[f>>2]=0;n=0}}else n=0;q=(n|0)==0;do if(r){if((c[r+12>>2]|0)!=(c[r+16>>2]|0))if(q){t=p;break}else break c;if((bd[c[(c[r>>2]|0)+36>>2]&255](r)|0)!=-1)if(q^(p|0)==0){t=p;r=p;break}else break c;else{c[g>>2]=0;p=0;B=39;break}}else B=39;while(0);if((B|0)==39){B=0;if(q)break c;else{t=p;r=0}}q=n+12|0;p=c[q>>2]|0;s=n+16|0;if((p|0)==(c[s>>2]|0))p=bd[c[(c[n>>2]|0)+36>>2]&255](n)|0;else p=d[p>>0]|0;if((p&255)<<24>>24<=-1)break c;if(!(b[(c[u>>2]|0)+(p<<24>>24<<1)>>1]&8192))break c;p=c[q>>2]|0;if((p|0)==(c[s>>2]|0)){bd[c[(c[n>>2]|0)+40>>2]&255](n)|0;p=t;continue}else{c[q>>2]=p+1;p=t;continue}}}q=n+12|0;p=c[q>>2]|0;r=n+16|0;if((p|0)==(c[r>>2]|0))p=bd[c[(c[n>>2]|0)+36>>2]&255](n)|0;else p=d[p>>0]|0;t=rd[c[(c[z>>2]|0)+12>>2]&127](z,p&255)|0;if(t<<24>>24!=(rd[c[(c[z>>2]|0)+12>>2]&127](z,a[l>>0]|0)|0)<<24>>24){B=57;break b}p=c[q>>2]|0;if((p|0)==(c[r>>2]|0))bd[c[(c[n>>2]|0)+40>>2]&255](n)|0;else c[q>>2]=p+1;l=l+1|0}while(0);n=c[f>>2]|0;if(!((l|0)!=(m|0)&(c[j>>2]|0)==0))break a}if((B|0)==13){c[j>>2]=4;break}else if((B|0)==17){c[j>>2]=4;break}else if((B|0)==20){c[j>>2]=4;break}else if((B|0)==57){c[j>>2]=4;n=c[f>>2]|0;break}}while(0);if(n){if((c[n+12>>2]|0)==(c[n+16>>2]|0)?(bd[c[(c[n>>2]|0)+36>>2]&255](n)|0)==-1:0){c[f>>2]=0;n=0}}else n=0;l=(n|0)==0;p=c[g>>2]|0;do if(p){if((c[p+12>>2]|0)==(c[p+16>>2]|0)?(bd[c[(c[p>>2]|0)+36>>2]&255](p)|0)==-1:0){c[g>>2]=0;B=67;break}if(!l)B=68}else B=67;while(0);if((B|0)==67?l:0)B=68;if((B|0)==68)c[j>>2]=c[j>>2]|2;i=C;return n|0}function mF(a){a=a|0;return}function nF(a){a=a|0;Uz(a);return}function oF(a){a=a|0;return 2}function pF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=lF(a,k,j,e,f,g,61266,61274)|0;i=h;return a|0}function qF(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=i;i=i+16|0;k=j+12|0;l=j+8|0;n=j+4|0;m=j;o=b+8|0;o=bd[c[(c[o>>2]|0)+20>>2]&255](o)|0;c[n>>2]=c[d>>2];c[m>>2]=c[e>>2];e=a[o>>0]|0;p=(e&1)==0;d=p?o+1|0:c[o+8>>2]|0;e=d+(p?(e&255)>>>1:c[o+4>>2]|0)|0;c[l>>2]=c[n>>2];c[k>>2]=c[m>>2];b=lF(b,l,k,f,g,h,d,e)|0;i=j;return b|0}function rF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l+4|0;k=l;e=lD(e)|0;c[h>>2]=e;o=0;h=Wa(115,h|0,40904)|0;m=o;o=0;if(m&1){m=cc()|0;EL(e)|0;bc(m|0)}else{EL(e)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];sF(a,g+24|0,b,j,f,h);i=l;return c[b>>2]|0}return 0}function sF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h+4|0;k=h;a=a+8|0;a=bd[c[c[a>>2]>>2]&255](a)|0;c[k>>2]=c[e>>2];c[j>>2]=c[k>>2];d=(TJ(d,j,a,a+168|0,g,f,0)|0)-a|0;if((d|0)<168)c[b>>2]=((d|0)/12|0|0)%7|0;i=h;return}function tF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l+4|0;k=l;e=lD(e)|0;c[h>>2]=e;o=0;h=Wa(115,h|0,40904)|0;m=o;o=0;if(m&1){m=cc()|0;EL(e)|0;bc(m|0)}else{EL(e)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];uF(a,g+16|0,b,j,f,h);i=l;return c[b>>2]|0}return 0}function uF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h+4|0;k=h;a=a+8|0;a=bd[c[(c[a>>2]|0)+4>>2]&255](a)|0;c[k>>2]=c[e>>2];c[j>>2]=c[k>>2];d=(TJ(d,j,a,a+288|0,g,f,0)|0)-a|0;if((d|0)<288)c[b>>2]=((d|0)/12|0|0)%12|0;i=h;return}function vF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l+4|0;k=l;e=lD(e)|0;c[h>>2]=e;o=0;h=Wa(115,h|0,40904)|0;m=o;o=0;if(m&1){m=cc()|0;EL(e)|0;bc(m|0)}else{EL(e)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];wF(a,g+20|0,b,j,f,h);i=l;return c[b>>2]|0}return 0}function wF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=pK(d,a,f,g,4)|0;if(!(c[f>>2]&4)){if((a|0)<69)a=a+2e3|0;else a=(a+-69|0)>>>0<31?a+1900|0:a;c[b>>2]=a+-1900}i=h;return}function xF(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0;U=i;i=i+144|0;l=U+132|0;k=U+116|0;N=U+128|0;x=U+124|0;I=U+120|0;O=U+112|0;P=U+108|0;Q=U+104|0;R=U+100|0;S=U+96|0;T=U+92|0;m=U+88|0;n=U+84|0;p=U+80|0;q=U+76|0;r=U+72|0;s=U+68|0;t=U+64|0;u=U+60|0;v=U+56|0;w=U+52|0;y=U+48|0;z=U+44|0;A=U+40|0;B=U+36|0;C=U+32|0;D=U+28|0;E=U+24|0;F=U+20|0;G=U+16|0;H=U+12|0;J=U+8|0;K=U+4|0;L=U;c[g>>2]=0;M=lD(f)|0;c[N>>2]=M;o=0;N=Wa(115,N|0,40904)|0;W=o;o=0;if(W&1){W=cc()|0;EL(M)|0;bc(W|0)}EL(M)|0;do switch(j<<24>>24|0){case 65:case 97:{c[x>>2]=c[e>>2];c[l>>2]=c[x>>2];sF(b,h+24|0,d,l,g,N);V=28;break}case 104:case 66:case 98:{c[I>>2]=c[e>>2];c[l>>2]=c[I>>2];uF(b,h+16|0,d,l,g,N);V=28;break}case 99:{V=b+8|0;V=bd[c[(c[V>>2]|0)+12>>2]&255](V)|0;c[O>>2]=c[d>>2];c[P>>2]=c[e>>2];j=a[V>>0]|0;e=(j&1)==0;W=e?V+1|0:c[V+8>>2]|0;V=W+(e?(j&255)>>>1:c[V+4>>2]|0)|0;c[k>>2]=c[O>>2];c[l>>2]=c[P>>2];c[d>>2]=lF(b,k,l,f,g,h,W,V)|0;V=28;break}case 101:case 100:{c[Q>>2]=c[e>>2];c[l>>2]=c[Q>>2];yF(b,h+12|0,d,l,g,N);V=28;break}case 68:{c[R>>2]=c[d>>2];c[S>>2]=c[e>>2];c[k>>2]=c[R>>2];c[l>>2]=c[S>>2];c[d>>2]=lF(b,k,l,f,g,h,61274,61282)|0;V=28;break}case 70:{c[T>>2]=c[d>>2];c[m>>2]=c[e>>2];c[k>>2]=c[T>>2];c[l>>2]=c[m>>2];c[d>>2]=lF(b,k,l,f,g,h,61282,61290)|0;V=28;break}case 72:{c[n>>2]=c[e>>2];c[l>>2]=c[n>>2];zF(b,h+8|0,d,l,g,N);V=28;break}case 73:{c[p>>2]=c[e>>2];c[l>>2]=c[p>>2];AF(b,h+8|0,d,l,g,N);V=28;break}case 106:{c[q>>2]=c[e>>2];c[l>>2]=c[q>>2];BF(b,h+28|0,d,l,g,N);V=28;break}case 109:{c[r>>2]=c[e>>2];c[l>>2]=c[r>>2];CF(b,h+16|0,d,l,g,N);V=28;break}case 77:{c[s>>2]=c[e>>2];c[l>>2]=c[s>>2];DF(b,h+4|0,d,l,g,N);V=28;break}case 116:case 110:{c[t>>2]=c[e>>2];c[l>>2]=c[t>>2];EF(b,d,l,g,N);V=28;break}case 112:{c[u>>2]=c[e>>2];c[l>>2]=c[u>>2];FF(b,h+8|0,d,l,g,N);V=28;break}case 114:{c[v>>2]=c[d>>2];c[w>>2]=c[e>>2];c[k>>2]=c[v>>2];c[l>>2]=c[w>>2];c[d>>2]=lF(b,k,l,f,g,h,61290,61301)|0;V=28;break}case 82:{c[y>>2]=c[d>>2];c[z>>2]=c[e>>2];c[k>>2]=c[y>>2];c[l>>2]=c[z>>2];c[d>>2]=lF(b,k,l,f,g,h,61301,61306)|0;V=28;break}case 83:{c[A>>2]=c[e>>2];c[l>>2]=c[A>>2];GF(b,h,d,l,g,N);V=28;break}case 84:{c[B>>2]=c[d>>2];c[C>>2]=c[e>>2];c[k>>2]=c[B>>2];c[l>>2]=c[C>>2];c[d>>2]=lF(b,k,l,f,g,h,61306,61314)|0;V=28;break}case 119:{c[D>>2]=c[e>>2];c[l>>2]=c[D>>2];HF(b,h+24|0,d,l,g,N);V=28;break}case 120:{W=c[(c[b>>2]|0)+20>>2]|0;c[E>>2]=c[d>>2];c[F>>2]=c[e>>2];c[k>>2]=c[E>>2];c[l>>2]=c[F>>2];k=ad[W&127](b,k,l,f,g,h)|0;break}case 88:{V=b+8|0;V=bd[c[(c[V>>2]|0)+24>>2]&255](V)|0;c[G>>2]=c[d>>2];c[H>>2]=c[e>>2];j=a[V>>0]|0;e=(j&1)==0;W=e?V+1|0:c[V+8>>2]|0;V=W+(e?(j&255)>>>1:c[V+4>>2]|0)|0;c[k>>2]=c[G>>2];c[l>>2]=c[H>>2];c[d>>2]=lF(b,k,l,f,g,h,W,V)|0;V=28;break}case 121:{c[J>>2]=c[e>>2];c[l>>2]=c[J>>2];wF(b,h+20|0,d,l,g,N);V=28;break}case 89:{c[K>>2]=c[e>>2];c[l>>2]=c[K>>2];IF(b,h+20|0,d,l,g,N);V=28;break}case 37:{c[L>>2]=c[e>>2];c[l>>2]=c[L>>2];JF(b,d,l,g,N);V=28;break}default:{c[g>>2]=c[g>>2]|4;V=28}}while(0);if((V|0)==28)k=c[d>>2]|0;i=U;return k|0}function yF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=pK(d,a,f,g,2)|0;d=c[f>>2]|0;if((a+-1|0)>>>0<31&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function zF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=pK(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<24&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function AF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=pK(d,a,f,g,2)|0;d=c[f>>2]|0;if((a+-1|0)>>>0<12&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function BF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=pK(d,a,f,g,3)|0;d=c[f>>2]|0;if((a|0)<366&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function CF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=pK(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<13&(d&4|0)==0)c[b>>2]=a+-1;else c[f>>2]=d|4;i=h;return}function DF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=pK(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<60&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function EF(a,e,f,g,h){a=a|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0;j=h+8|0;a:while(1){h=c[e>>2]|0;do if(h){if((c[h+12>>2]|0)==(c[h+16>>2]|0))if((bd[c[(c[h>>2]|0)+36>>2]&255](h)|0)==-1){c[e>>2]=0;h=0;break}else{h=c[e>>2]|0;break}}else h=0;while(0);h=(h|0)==0;a=c[f>>2]|0;do if(a){if((c[a+12>>2]|0)!=(c[a+16>>2]|0))if(h)break;else break a;if((bd[c[(c[a>>2]|0)+36>>2]&255](a)|0)!=-1)if(h)break;else break a;else{c[f>>2]=0;k=12;break}}else k=12;while(0);if((k|0)==12){k=0;if(h){a=0;break}else a=0}h=c[e>>2]|0;i=c[h+12>>2]|0;if((i|0)==(c[h+16>>2]|0))h=bd[c[(c[h>>2]|0)+36>>2]&255](h)|0;else h=d[i>>0]|0;if((h&255)<<24>>24<=-1)break;if(!(b[(c[j>>2]|0)+(h<<24>>24<<1)>>1]&8192))break;h=c[e>>2]|0;a=h+12|0;i=c[a>>2]|0;if((i|0)==(c[h+16>>2]|0)){bd[c[(c[h>>2]|0)+40>>2]&255](h)|0;continue}else{c[a>>2]=i+1;continue}}h=c[e>>2]|0;do if(h){if((c[h+12>>2]|0)==(c[h+16>>2]|0))if((bd[c[(c[h>>2]|0)+36>>2]&255](h)|0)==-1){c[e>>2]=0;h=0;break}else{h=c[e>>2]|0;break}}else h=0;while(0);h=(h|0)==0;do if(a){if((c[a+12>>2]|0)==(c[a+16>>2]|0)?(bd[c[(c[a>>2]|0)+36>>2]&255](a)|0)==-1:0){c[f>>2]=0;k=32;break}if(!h)k=33}else k=32;while(0);if((k|0)==32?h:0)k=33;if((k|0)==33)c[g>>2]=c[g>>2]|2;return}function FF(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;n=i;i=i+16|0;k=n+4|0;l=n;m=b+8|0;m=bd[c[(c[m>>2]|0)+8>>2]&255](m)|0;b=a[m>>0]|0;if(!(b&1))j=(b&255)>>>1;else j=c[m+4>>2]|0;b=a[m+12>>0]|0;if(!(b&1))b=(b&255)>>>1;else b=c[m+16>>2]|0;do if((j|0)!=(0-b|0)){c[l>>2]=c[f>>2];c[k>>2]=c[l>>2];b=TJ(e,k,m,m+24|0,h,g,0)|0;j=c[d>>2]|0;if((b|0)==(m|0)&(j|0)==12){c[d>>2]=0;break}if((j|0)<12&(b-m|0)==12)c[d>>2]=j+12}else c[g>>2]=c[g>>2]|4;while(0);i=n;return}function GF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=pK(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<61&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function HF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=pK(d,a,f,g,1)|0;d=c[f>>2]|0;if((a|0)<7&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function IF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=pK(d,a,f,g,4)|0;if(!(c[f>>2]&4))c[b>>2]=a+-1900;i=h;return}function JF(a,b,e,f,g){a=a|0;b=b|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;a=c[b>>2]|0;do if(a){if((c[a+12>>2]|0)==(c[a+16>>2]|0))if((bd[c[(c[a>>2]|0)+36>>2]&255](a)|0)==-1){c[b>>2]=0;a=0;break}else{a=c[b>>2]|0;break}}else a=0;while(0);h=(a|0)==0;a=c[e>>2]|0;do if(a){if((c[a+12>>2]|0)==(c[a+16>>2]|0)?(bd[c[(c[a>>2]|0)+36>>2]&255](a)|0)==-1:0){c[e>>2]=0;j=11;break}if(h){i=a;j=13}else j=12}else j=11;while(0);if((j|0)==11)if(h)j=12;else{i=0;j=13}a:do if((j|0)==12)c[f>>2]=c[f>>2]|6;else if((j|0)==13){a=c[b>>2]|0;h=c[a+12>>2]|0;if((h|0)==(c[a+16>>2]|0))a=bd[c[(c[a>>2]|0)+36>>2]&255](a)|0;else a=d[h>>0]|0;if((fd[c[(c[g>>2]|0)+36>>2]&127](g,a&255,0)|0)<<24>>24!=37){c[f>>2]=c[f>>2]|4;break}a=c[b>>2]|0;h=a+12|0;g=c[h>>2]|0;if((g|0)==(c[a+16>>2]|0)){bd[c[(c[a>>2]|0)+40>>2]&255](a)|0;a=c[b>>2]|0;if(!a)a=0;else j=21}else{c[h>>2]=g+1;j=21}do if((j|0)==21)if((c[a+12>>2]|0)==(c[a+16>>2]|0))if((bd[c[(c[a>>2]|0)+36>>2]&255](a)|0)==-1){c[b>>2]=0;a=0;break}else{a=c[b>>2]|0;break}while(0);a=(a|0)==0;do if(i){if((c[i+12>>2]|0)==(c[i+16>>2]|0)?(bd[c[(c[i>>2]|0)+36>>2]&255](i)|0)==-1:0){c[e>>2]=0;j=30;break}if(a)break a}else j=30;while(0);if((j|0)==30?!a:0)break;c[f>>2]=c[f>>2]|2}while(0);return}function KF(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+32|0;s=x+16|0;r=x+12|0;v=x+8|0;t=x+4|0;u=x;k=lD(e)|0;c[v>>2]=k;o=0;v=Wa(115,v|0,40896)|0;q=o;o=0;if(q&1){x=cc()|0;EL(k)|0;bc(x|0)}EL(k)|0;c[f>>2]=0;k=c[b>>2]|0;a:do if((h|0)!=(j|0)){b:while(1){m=k;if(k){l=c[k+12>>2]|0;if((l|0)==(c[k+16>>2]|0))l=bd[c[(c[k>>2]|0)+36>>2]&255](k)|0;else l=c[l>>2]|0;if((l|0)==-1){c[b>>2]=0;k=0;p=1;q=0}else{p=0;q=m}}else{k=0;p=1;q=m}n=c[d>>2]|0;l=n;do if(n){m=c[n+12>>2]|0;if((m|0)==(c[n+16>>2]|0))m=bd[c[(c[n>>2]|0)+36>>2]&255](n)|0;else m=c[m>>2]|0;if((m|0)!=-1)if(p)break;else{w=17;break b}else{c[d>>2]=0;l=0;w=15;break}}else w=15;while(0);if((w|0)==15){w=0;if(p){w=17;break}else n=0}c:do if((fd[c[(c[v>>2]|0)+52>>2]&127](v,c[h>>2]|0,0)|0)<<24>>24==37){m=h+4|0;if((m|0)==(j|0)){w=21;break b}p=fd[c[(c[v>>2]|0)+52>>2]&127](v,c[m>>2]|0,0)|0;switch(p<<24>>24){case 48:case 69:{n=h+8|0;if((n|0)==(j|0)){w=24;break b}h=m;m=fd[c[(c[v>>2]|0)+52>>2]&127](v,c[n>>2]|0,0)|0;k=p;break}default:{m=p;k=0}}p=c[(c[a>>2]|0)+36>>2]|0;c[t>>2]=q;c[u>>2]=l;c[r>>2]=c[t>>2];c[s>>2]=c[u>>2];c[b>>2]=Cd[p&63](a,r,s,e,f,g,m,k)|0;h=h+8|0}else{if(!(fd[c[(c[v>>2]|0)+12>>2]&127](v,8192,c[h>>2]|0)|0)){m=k+12|0;l=c[m>>2]|0;n=k+16|0;if((l|0)==(c[n>>2]|0))l=bd[c[(c[k>>2]|0)+36>>2]&255](k)|0;else l=c[l>>2]|0;q=rd[c[(c[v>>2]|0)+28>>2]&127](v,l)|0;if((q|0)!=(rd[c[(c[v>>2]|0)+28>>2]&127](v,c[h>>2]|0)|0)){w=61;break b}l=c[m>>2]|0;if((l|0)==(c[n>>2]|0))bd[c[(c[k>>2]|0)+40>>2]&255](k)|0;else c[m>>2]=l+4;h=h+4|0;break}do{h=h+4|0;if((h|0)==(j|0)){h=j;break}}while(fd[c[(c[v>>2]|0)+12>>2]&127](v,8192,c[h>>2]|0)|0);l=n;p=n;while(1){if(k){m=c[k+12>>2]|0;if((m|0)==(c[k+16>>2]|0))m=bd[c[(c[k>>2]|0)+36>>2]&255](k)|0;else m=c[m>>2]|0;if((m|0)==-1){c[b>>2]=0;n=1;k=0}else n=0}else{n=1;k=0}do if(p){m=c[p+12>>2]|0;if((m|0)==(c[p+16>>2]|0))m=bd[c[(c[p>>2]|0)+36>>2]&255](p)|0;else m=c[m>>2]|0;if((m|0)!=-1)if(n^(l|0)==0){q=l;p=l;break}else break c;else{c[d>>2]=0;l=0;w=44;break}}else w=44;while(0);if((w|0)==44){w=0;if(n)break c;else{q=l;p=0}}m=k+12|0;l=c[m>>2]|0;n=k+16|0;if((l|0)==(c[n>>2]|0))l=bd[c[(c[k>>2]|0)+36>>2]&255](k)|0;else l=c[l>>2]|0;if(!(fd[c[(c[v>>2]|0)+12>>2]&127](v,8192,l)|0))break c;l=c[m>>2]|0;if((l|0)==(c[n>>2]|0)){bd[c[(c[k>>2]|0)+40>>2]&255](k)|0;l=q;continue}else{c[m>>2]=l+4;l=q;continue}}}while(0);k=c[b>>2]|0;if(!((h|0)!=(j|0)&(c[f>>2]|0)==0))break a}if((w|0)==17){c[f>>2]=4;break}else if((w|0)==21){c[f>>2]=4;break}else if((w|0)==24){c[f>>2]=4;break}else if((w|0)==61){c[f>>2]=4;k=c[b>>2]|0;break}}while(0);if(k){h=c[k+12>>2]|0;if((h|0)==(c[k+16>>2]|0))h=bd[c[(c[k>>2]|0)+36>>2]&255](k)|0;else h=c[h>>2]|0;if((h|0)==-1){c[b>>2]=0;k=0;m=1}else m=0}else{k=0;m=1}h=c[d>>2]|0;do if(h){l=c[h+12>>2]|0;if((l|0)==(c[h+16>>2]|0))h=bd[c[(c[h>>2]|0)+36>>2]&255](h)|0;else h=c[l>>2]|0;if((h|0)!=-1)if(m)break;else{w=76;break}else{c[d>>2]=0;w=74;break}}else w=74;while(0);if((w|0)==74?m:0)w=76;if((w|0)==76)c[f>>2]=c[f>>2]|2;i=x;return k|0}function LF(a){a=a|0;return}function MF(a){a=a|0;Uz(a);return}function NF(a){a=a|0;return 2}function OF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=KF(a,k,j,e,f,g,41472,41504)|0;i=h;return a|0}function PF(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;j=i;i=i+16|0;k=j+12|0;l=j+8|0;n=j+4|0;m=j;q=b+8|0;q=bd[c[(c[q>>2]|0)+20>>2]&255](q)|0;c[n>>2]=c[d>>2];c[m>>2]=c[e>>2];o=a[q>>0]|0;p=(o&1)==0;e=q+4|0;d=p?e:c[q+8>>2]|0;e=d+((p?(o&255)>>>1:c[e>>2]|0)<<2)|0;c[l>>2]=c[n>>2];c[k>>2]=c[m>>2];b=KF(b,l,k,f,g,h,d,e)|0;i=j;return b|0}function QF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l+4|0;k=l;e=lD(e)|0;c[h>>2]=e;o=0;h=Wa(115,h|0,40896)|0;m=o;o=0;if(m&1){m=cc()|0;EL(e)|0;bc(m|0)}else{EL(e)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];RF(a,g+24|0,b,j,f,h);i=l;return c[b>>2]|0}return 0}function RF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h+4|0;k=h;a=a+8|0;a=bd[c[c[a>>2]>>2]&255](a)|0;c[k>>2]=c[e>>2];c[j>>2]=c[k>>2];d=(cK(d,j,a,a+168|0,g,f,0)|0)-a|0;if((d|0)<168)c[b>>2]=((d|0)/12|0|0)%7|0;i=h;return}function SF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l+4|0;k=l;e=lD(e)|0;c[h>>2]=e;o=0;h=Wa(115,h|0,40896)|0;m=o;o=0;if(m&1){m=cc()|0;EL(e)|0;bc(m|0)}else{EL(e)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];TF(a,g+16|0,b,j,f,h);i=l;return c[b>>2]|0}return 0}function TF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h+4|0;k=h;a=a+8|0;a=bd[c[(c[a>>2]|0)+4>>2]&255](a)|0;c[k>>2]=c[e>>2];c[j>>2]=c[k>>2];d=(cK(d,j,a,a+288|0,g,f,0)|0)-a|0;if((d|0)<288)c[b>>2]=((d|0)/12|0|0)%12|0;i=h;return}function UF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l+4|0;k=l;e=lD(e)|0;c[h>>2]=e;o=0;h=Wa(115,h|0,40896)|0;m=o;o=0;if(m&1){m=cc()|0;EL(e)|0;bc(m|0)}else{EL(e)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];VF(a,g+20|0,b,j,f,h);i=l;return c[b>>2]|0}return 0}function VF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=qK(d,a,f,g,4)|0;if(!(c[f>>2]&4)){if((a|0)<69)a=a+2e3|0;else a=(a+-69|0)>>>0<31?a+1900|0:a;c[b>>2]=a+-1900}i=h;return}function WF(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0;U=i;i=i+144|0;l=U+132|0;k=U+116|0;N=U+128|0;x=U+124|0;I=U+120|0;O=U+112|0;P=U+108|0;Q=U+104|0;R=U+100|0;S=U+96|0;T=U+92|0;m=U+88|0;n=U+84|0;p=U+80|0;q=U+76|0;r=U+72|0;s=U+68|0;t=U+64|0;u=U+60|0;v=U+56|0;w=U+52|0;y=U+48|0;z=U+44|0;A=U+40|0;B=U+36|0;C=U+32|0;D=U+28|0;E=U+24|0;F=U+20|0;G=U+16|0;H=U+12|0;J=U+8|0;K=U+4|0;L=U;c[g>>2]=0;M=lD(f)|0;c[N>>2]=M;o=0;N=Wa(115,N|0,40896)|0;W=o;o=0;if(W&1){W=cc()|0;EL(M)|0;bc(W|0)}EL(M)|0;do switch(j<<24>>24|0){case 65:case 97:{c[x>>2]=c[e>>2];c[l>>2]=c[x>>2];RF(b,h+24|0,d,l,g,N);V=28;break}case 104:case 66:case 98:{c[I>>2]=c[e>>2];c[l>>2]=c[I>>2];TF(b,h+16|0,d,l,g,N);V=28;break}case 99:{W=b+8|0;W=bd[c[(c[W>>2]|0)+12>>2]&255](W)|0;c[O>>2]=c[d>>2];c[P>>2]=c[e>>2];j=a[W>>0]|0;e=(j&1)==0;V=W+4|0;W=e?V:c[W+8>>2]|0;V=W+((e?(j&255)>>>1:c[V>>2]|0)<<2)|0;c[k>>2]=c[O>>2];c[l>>2]=c[P>>2];c[d>>2]=KF(b,k,l,f,g,h,W,V)|0;V=28;break}case 101:case 100:{c[Q>>2]=c[e>>2];c[l>>2]=c[Q>>2];XF(b,h+12|0,d,l,g,N);V=28;break}case 68:{c[R>>2]=c[d>>2];c[S>>2]=c[e>>2];c[k>>2]=c[R>>2];c[l>>2]=c[S>>2];c[d>>2]=KF(b,k,l,f,g,h,41504,41536)|0;V=28;break}case 70:{c[T>>2]=c[d>>2];c[m>>2]=c[e>>2];c[k>>2]=c[T>>2];c[l>>2]=c[m>>2];c[d>>2]=KF(b,k,l,f,g,h,41536,41568)|0;V=28;break}case 72:{c[n>>2]=c[e>>2];c[l>>2]=c[n>>2];YF(b,h+8|0,d,l,g,N);V=28;break}case 73:{c[p>>2]=c[e>>2];c[l>>2]=c[p>>2];ZF(b,h+8|0,d,l,g,N);V=28;break}case 106:{c[q>>2]=c[e>>2];c[l>>2]=c[q>>2];_F(b,h+28|0,d,l,g,N);V=28;break}case 109:{c[r>>2]=c[e>>2];c[l>>2]=c[r>>2];$F(b,h+16|0,d,l,g,N);V=28;break}case 77:{c[s>>2]=c[e>>2];c[l>>2]=c[s>>2];aG(b,h+4|0,d,l,g,N);V=28;break}case 116:case 110:{c[t>>2]=c[e>>2];c[l>>2]=c[t>>2];bG(b,d,l,g,N);V=28;break}case 112:{c[u>>2]=c[e>>2];c[l>>2]=c[u>>2];cG(b,h+8|0,d,l,g,N);V=28;break}case 114:{c[v>>2]=c[d>>2];c[w>>2]=c[e>>2];c[k>>2]=c[v>>2];c[l>>2]=c[w>>2];c[d>>2]=KF(b,k,l,f,g,h,41568,41612)|0;V=28;break}case 82:{c[y>>2]=c[d>>2];c[z>>2]=c[e>>2];c[k>>2]=c[y>>2];c[l>>2]=c[z>>2];c[d>>2]=KF(b,k,l,f,g,h,41612,41632)|0;V=28;break}case 83:{c[A>>2]=c[e>>2];c[l>>2]=c[A>>2];dG(b,h,d,l,g,N);V=28;break}case 84:{c[B>>2]=c[d>>2];c[C>>2]=c[e>>2];c[k>>2]=c[B>>2];c[l>>2]=c[C>>2];c[d>>2]=KF(b,k,l,f,g,h,41632,41664)|0;V=28;break}case 119:{c[D>>2]=c[e>>2];c[l>>2]=c[D>>2];eG(b,h+24|0,d,l,g,N);V=28;break}case 120:{W=c[(c[b>>2]|0)+20>>2]|0;c[E>>2]=c[d>>2];c[F>>2]=c[e>>2];c[k>>2]=c[E>>2];c[l>>2]=c[F>>2];k=ad[W&127](b,k,l,f,g,h)|0;break}case 88:{W=b+8|0;W=bd[c[(c[W>>2]|0)+24>>2]&255](W)|0;c[G>>2]=c[d>>2];c[H>>2]=c[e>>2];j=a[W>>0]|0;e=(j&1)==0;V=W+4|0;W=e?V:c[W+8>>2]|0;V=W+((e?(j&255)>>>1:c[V>>2]|0)<<2)|0;c[k>>2]=c[G>>2];c[l>>2]=c[H>>2];c[d>>2]=KF(b,k,l,f,g,h,W,V)|0;V=28;break}case 121:{c[J>>2]=c[e>>2];c[l>>2]=c[J>>2];VF(b,h+20|0,d,l,g,N);V=28;break}case 89:{c[K>>2]=c[e>>2];c[l>>2]=c[K>>2];fG(b,h+20|0,d,l,g,N);V=28;break}case 37:{c[L>>2]=c[e>>2];c[l>>2]=c[L>>2];gG(b,d,l,g,N);V=28;break}default:{c[g>>2]=c[g>>2]|4;V=28}}while(0);if((V|0)==28)k=c[d>>2]|0;i=U;return k|0}function XF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=qK(d,a,f,g,2)|0;d=c[f>>2]|0;if((a+-1|0)>>>0<31&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function YF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=qK(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<24&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function ZF(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=qK(d,a,f,g,2)|0;d=c[f>>2]|0;if((a+-1|0)>>>0<12&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function _F(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=qK(d,a,f,g,3)|0;d=c[f>>2]|0;if((a|0)<366&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function $F(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=qK(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<13&(d&4|0)==0)c[b>>2]=a+-1;else c[f>>2]=d|4;i=h;return}function aG(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=qK(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<60&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function bG(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;a:while(1){a=c[b>>2]|0;do if(a){g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=bd[c[(c[a>>2]|0)+36>>2]&255](a)|0;else a=c[g>>2]|0;if((a|0)==-1){c[b>>2]=0;h=1;break}else{h=(c[b>>2]|0)==0;break}}else h=1;while(0);g=c[d>>2]|0;do if(g){a=c[g+12>>2]|0;if((a|0)==(c[g+16>>2]|0))a=bd[c[(c[g>>2]|0)+36>>2]&255](g)|0;else a=c[a>>2]|0;if((a|0)!=-1)if(h){h=g;break}else{h=g;break a}else{c[d>>2]=0;i=15;break}}else i=15;while(0);if((i|0)==15){i=0;if(h){h=0;break}else h=0}a=c[b>>2]|0;g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=bd[c[(c[a>>2]|0)+36>>2]&255](a)|0;else a=c[g>>2]|0;if(!(fd[c[(c[f>>2]|0)+12>>2]&127](f,8192,a)|0))break;a=c[b>>2]|0;g=a+12|0;h=c[g>>2]|0;if((h|0)==(c[a+16>>2]|0)){bd[c[(c[a>>2]|0)+40>>2]&255](a)|0;continue}else{c[g>>2]=h+4;continue}}a=c[b>>2]|0;do if(a){g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=bd[c[(c[a>>2]|0)+36>>2]&255](a)|0;else a=c[g>>2]|0;if((a|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(h){a=c[h+12>>2]|0;if((a|0)==(c[h+16>>2]|0))a=bd[c[(c[h>>2]|0)+36>>2]&255](h)|0;else a=c[a>>2]|0;if((a|0)!=-1)if(g)break;else{i=39;break}else{c[d>>2]=0;i=37;break}}else i=37;while(0);if((i|0)==37?g:0)i=39;if((i|0)==39)c[e>>2]=c[e>>2]|2;return}function cG(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;n=i;i=i+16|0;k=n+4|0;l=n;m=b+8|0;m=bd[c[(c[m>>2]|0)+8>>2]&255](m)|0;b=a[m>>0]|0;if(!(b&1))j=(b&255)>>>1;else j=c[m+4>>2]|0;b=a[m+12>>0]|0;if(!(b&1))b=(b&255)>>>1;else b=c[m+16>>2]|0;do if((j|0)!=(0-b|0)){c[l>>2]=c[f>>2];c[k>>2]=c[l>>2];b=cK(e,k,m,m+24|0,h,g,0)|0;j=c[d>>2]|0;if((b|0)==(m|0)&(j|0)==12){c[d>>2]=0;break}if((j|0)<12&(b-m|0)==12)c[d>>2]=j+12}else c[g>>2]=c[g>>2]|4;while(0);i=n;return}function dG(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=qK(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<61&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function eG(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=qK(d,a,f,g,1)|0;d=c[f>>2]|0;if((a|0)<7&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function fG(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=qK(d,a,f,g,4)|0;if(!(c[f>>2]&4))c[b>>2]=a+-1900;i=h;return}function gG(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;a=c[b>>2]|0;do if(a){g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=bd[c[(c[a>>2]|0)+36>>2]&255](a)|0;else a=c[g>>2]|0;if((a|0)==-1){c[b>>2]=0;h=1;break}else{h=(c[b>>2]|0)==0;break}}else h=1;while(0);g=c[d>>2]|0;do if(g){a=c[g+12>>2]|0;if((a|0)==(c[g+16>>2]|0))a=bd[c[(c[g>>2]|0)+36>>2]&255](g)|0;else a=c[a>>2]|0;if((a|0)!=-1)if(h){i=g;j=17;break}else{j=16;break}else{c[d>>2]=0;j=14;break}}else j=14;while(0);if((j|0)==14)if(h)j=16;else{i=0;j=17}a:do if((j|0)==16)c[e>>2]=c[e>>2]|6;else if((j|0)==17){a=c[b>>2]|0;g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=bd[c[(c[a>>2]|0)+36>>2]&255](a)|0;else a=c[g>>2]|0;if((fd[c[(c[f>>2]|0)+52>>2]&127](f,a,0)|0)<<24>>24!=37){c[e>>2]=c[e>>2]|4;break}a=c[b>>2]|0;g=a+12|0;h=c[g>>2]|0;if((h|0)==(c[a+16>>2]|0)){bd[c[(c[a>>2]|0)+40>>2]&255](a)|0;a=c[b>>2]|0;if(!a)g=1;else j=25}else{c[g>>2]=h+4;j=25}do if((j|0)==25){g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=bd[c[(c[a>>2]|0)+36>>2]&255](a)|0;else a=c[g>>2]|0;if((a|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}while(0);do if(i){a=c[i+12>>2]|0;if((a|0)==(c[i+16>>2]|0))a=bd[c[(c[i>>2]|0)+36>>2]&255](i)|0;else a=c[a>>2]|0;if((a|0)!=-1)if(g)break a;else break;else{c[d>>2]=0;j=37;break}}else j=37;while(0);if((j|0)==37?!g:0)break;c[e>>2]=c[e>>2]|2}while(0);return}function hG(a){a=a|0;iG(a+8|0);return}function iG(a){a=a|0;var b=0,d=0,e=0;b=c[a>>2]|0;o=0;d=gb(45)|0;e=o;o=0;do if(!(e&1)){if((b|0)!=(d|0)?(o=0,ka(344,c[a>>2]|0),e=o,o=0,e&1):0)break;return}while(0);e=cc(0)|0;oq(e)}function jG(a){a=a|0;iG(a+8|0);Uz(a);return}function kG(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0;l=i;i=i+112|0;k=l+4|0;e=l;c[e>>2]=k+100;lG(b+8|0,k,e,g,h,j);g=c[e>>2]|0;e=c[d>>2]|0;if((k|0)!=(g|0))do{j=a[k>>0]|0;do if(e){f=e+24|0;h=c[f>>2]|0;if((h|0)==(c[e+28>>2]|0)){d=(rd[c[(c[e>>2]|0)+52>>2]&127](e,j&255)|0)==-1;e=d?0:e;break}else{c[f>>2]=h+1;a[h>>0]=j;break}}else e=0;while(0);k=k+1|0}while((k|0)!=(g|0));i=l;return e|0}function lG(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;m=i;i=i+16|0;l=m;a[l>>0]=37;j=l+1|0;a[j>>0]=g;k=l+2|0;a[k>>0]=h;a[l+3>>0]=0;if(h<<24>>24){a[j>>0]=h;a[k>>0]=g}c[e>>2]=d+(Ub(d|0,(c[e>>2]|0)-d|0,l|0,f|0,c[b>>2]|0)|0);i=m;return}function mG(a){a=a|0;iG(a+8|0);return}function nG(a){a=a|0;iG(a+8|0);Uz(a);return}function oG(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0;j=i;i=i+416|0;e=j+8|0;d=j;c[d>>2]=e+400;pG(a+8|0,e,d,f,g,h);a=c[d>>2]|0;d=c[b>>2]|0;if((e|0)!=(a|0)){f=e;do{e=c[f>>2]|0;if(!d)d=0;else{g=d+24|0;h=c[g>>2]|0;if((h|0)==(c[d+28>>2]|0))e=rd[c[(c[d>>2]|0)+52>>2]&127](d,e)|0;else{c[g>>2]=h+4;c[h>>2]=e}d=(e|0)==-1?0:d}f=f+4|0}while((f|0)!=(a|0))}i=j;return d|0}function pG(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+128|0;l=h+16|0;m=h+12|0;j=h;k=h+8|0;c[m>>2]=l+100;lG(a,l,m,e,f,g);f=j;c[f>>2]=0;c[f+4>>2]=0;c[k>>2]=l;f=(c[d>>2]|0)-b>>2;g=lB(c[a>>2]|0)|0;o=0;f=kb(66,b|0,k|0,f|0,j|0)|0;a=o;o=0;if(a&1){f=cc()|0;if((g|0)!=0?(o=0,qa(193,g|0)|0,m=o,o=0,m&1):0){m=cc(0)|0;oq(m)}bc(f|0)}if((g|0)!=0?(o=0,qa(193,g|0)|0,m=o,o=0,m&1):0){m=cc(0)|0;oq(m)}if((f|0)==-1)lH(61314);else{c[d>>2]=b+(f<<2);i=h;return}}function qG(a){a=a|0;return}function rG(a){a=a|0;Uz(a);return}function sG(a){a=a|0;return 127}function tG(a){a=a|0;return 127}function uG(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function vG(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function wG(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function xG(a,b){a=a|0;b=b|0;GC(a,1,45);return}function yG(a){a=a|0;return 0}function zG(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function AG(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function BG(a){a=a|0;return}function CG(a){a=a|0;Uz(a);return}function DG(a){a=a|0;return 127}function EG(a){a=a|0;return 127}function FG(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function GG(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function HG(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function IG(a,b){a=a|0;b=b|0;GC(a,1,45);return}function JG(a){a=a|0;return 0}function KG(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function LG(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function MG(a){a=a|0;return}function NG(a){a=a|0;Uz(a);return}function OG(a){a=a|0;return 2147483647}function PG(a){a=a|0;return 2147483647}function QG(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function RG(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function SG(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function TG(a,b){a=a|0;b=b|0;YC(a,1,45);return}function UG(a){a=a|0;return 0}function VG(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function WG(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function XG(a){a=a|0;return}function YG(a){a=a|0;Uz(a);return}function ZG(a){a=a|0;return 2147483647}function _G(a){a=a|0;return 2147483647}function $G(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function aH(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function bH(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function cH(a,b){a=a|0;b=b|0;YC(a,1,45);return}function dH(a){a=a|0;return 0}function eH(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function fH(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function gH(a){a=a|0;return}function hH(a){a=a|0;Uz(a);return}function iH(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;B=i;i=i+240|0;z=B+24|0;A=B;b=B+136|0;D=B+16|0;y=B+12|0;C=B+8|0;p=B+134|0;l=B+4|0;x=B+124|0;c[D>>2]=b;E=D+4|0;c[E>>2]=345;m=b+100|0;o=0;k=qa(192,g|0)|0;w=o;o=0;if(!(w&1)){c[C>>2]=k;o=0;b=Wa(115,C|0,40904)|0;w=o;o=0;a:do if(!(w&1)?(a[p>>0]=0,c[l>>2]=c[e>>2],n=c[g+4>>2]|0,o=0,c[z>>2]=c[l>>2],n=ua(42,d|0,z|0,f|0,C|0,n|0,h|0,p|0,b|0,D|0,y|0,m|0)|0,w=o,o=0,!(w&1)):0){b:do if(n){o=0;kb(c[(c[b>>2]|0)+32>>2]|0,b|0,61335,61345,x|0)|0;w=o;o=0;if(w&1){G=10;break a}l=c[y>>2]|0;m=c[D>>2]|0;b=l-m|0;if((b|0)>98){b=yC(b+2|0)|0;k=b;if(!b){o=0;ob(46);w=o;o=0;if(!(w&1)){b=0;G=13}}else G=13}else{k=0;b=z;G=13}do if((G|0)==13){if(a[p>>0]|0){a[b>>0]=45;b=b+1|0}v=x+10|0;w=x;if(m>>>0<l>>>0){n=x+1|0;f=n+1|0;g=f+1|0;p=g+1|0;q=p+1|0;r=q+1|0;s=r+1|0;t=s+1|0;u=t+1|0;do{l=a[m>>0]|0;do if((a[x>>0]|0)!=l<<24>>24)if((a[n>>0]|0)!=l<<24>>24)if((a[f>>0]|0)!=l<<24>>24)if((a[g>>0]|0)!=l<<24>>24)if((a[p>>0]|0)==l<<24>>24)l=p;else{if((a[q>>0]|0)==l<<24>>24){l=q;break}if((a[r>>0]|0)==l<<24>>24){l=r;break}if((a[s>>0]|0)==l<<24>>24){l=s;break}if((a[t>>0]|0)==l<<24>>24){l=t;break}l=(a[u>>0]|0)==l<<24>>24?u:v}else l=g;else l=f;else l=n;else l=x;while(0);a[b>>0]=a[61335+(l-w)>>0]|0;m=m+1|0;b=b+1|0}while(m>>>0<(c[y>>2]|0)>>>0)}a[b>>0]=0;c[A>>2]=j;if((TB(z,61346,A)|0)!=1?(o=0,ka(346,61350),j=o,o=0,j&1):0)break;if(k)zC(k);break b}while(0);b=cc()|0;if(!k){l=b;k=D;break a}zC(k);l=b;k=D;break a}while(0);b=c[d>>2]|0;do if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;b=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;j=o;o=0;if(j&1){G=10;break a}if((b|0)==-1){c[d>>2]=0;b=0;break}else{b=c[d>>2]|0;break}}}else b=0;while(0);k=(b|0)==0;b=c[e>>2]|0;do if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;b=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;j=o;o=0;if(j&1){G=10;break a}if((b|0)==-1){c[e>>2]=0;G=37;break}}if(!k)G=38}else G=37;while(0);if((G|0)==37?k:0)G=38;if((G|0)==38)c[h>>2]=c[h>>2]|2;k=c[d>>2]|0;EL(c[C>>2]|0)|0;b=c[D>>2]|0;c[D>>2]=0;if((b|0)!=0?(o=0,ka(c[E>>2]|0,b|0),G=o,o=0,G&1):0){G=cc(0)|0;oq(G)}i=B;return k|0}else G=10;while(0);if((G|0)==10){l=cc()|0;k=D}EL(c[C>>2]|0)|0;b=c[k>>2]|0;c[k>>2]=0;if(!b)F=l;else{k=c[E>>2]|0;G=45}}else{l=cc()|0;c[D>>2]=0;k=345;G=45}if((G|0)==45){o=0;ka(k|0,b|0);G=o;o=0;if(G&1){G=cc(0)|0;oq(G)}else F=l}bc(F|0);return 0}function jH(a){a=a|0;return}function kH(e,f,g,h,j,k,l,m,n,p,q){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;p=p|0;q=q|0;var r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0;ba=i;i=i+512|0;P=ba+88|0;u=ba+96|0;da=ba+80|0;T=ba+72|0;S=ba+68|0;U=ba+500|0;Q=ba+497|0;V=ba+496|0;Y=ba+56|0;aa=ba+44|0;_=ba+32|0;Z=ba+20|0;$=ba+8|0;R=ba+4|0;X=ba;c[P>>2]=q;c[da>>2]=u;ca=da+4|0;c[ca>>2]=345;c[T>>2]=u;c[S>>2]=u+400;c[Y>>2]=0;c[Y+4>>2]=0;c[Y+8>>2]=0;c[aa>>2]=0;c[aa+4>>2]=0;c[aa+8>>2]=0;c[_>>2]=0;c[_+4>>2]=0;c[_+8>>2]=0;c[Z>>2]=0;c[Z+4>>2]=0;c[Z+8>>2]=0;c[$>>2]=0;c[$+4>>2]=0;c[$+8>>2]=0;o=0;Ua(42,g|0,h|0,U|0,Q|0,V|0,Y|0,aa|0,_|0,Z|0,R|0);O=o;o=0;a:do if(O&1)m=cc()|0;else{c[p>>2]=c[n>>2];I=m+8|0;J=_+4|0;K=Z+4|0;L=Z+8|0;M=Z+1|0;N=_+8|0;O=_+1|0;z=(j&512|0)!=0;A=aa+8|0;B=aa+1|0;C=aa+4|0;D=$+4|0;E=$+8|0;F=$+1|0;G=U+3|0;H=Y+4|0;y=0;t=0;b:while(1){q=c[e>>2]|0;do if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;q=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}if((q|0)==-1){c[e>>2]=0;q=0;break}else{q=c[e>>2]|0;break}}}else q=0;while(0);q=(q|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(q){x=m;break}else{W=235;break b}o=0;g=qa(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=24;break b}if((g|0)!=-1)if(q){x=m;break}else{W=235;break b}else{c[f>>2]=0;W=15;break}}else W=15;while(0);if((W|0)==15){W=0;if(q){W=235;break}else x=0}c:do switch(a[U+y>>0]|0){case 1:{if((y|0)!=3){q=c[e>>2]|0;m=c[q+12>>2]|0;if((m|0)==(c[q+16>>2]|0)){o=0;q=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;W=o;o=0;if(W&1){W=24;break b}}else q=d[m>>0]|0;if((q&255)<<24>>24<=-1){W=40;break b}if(!(b[(c[I>>2]|0)+(q<<24>>24<<1)>>1]&8192)){W=40;break b}q=c[e>>2]|0;m=q+12|0;g=c[m>>2]|0;if((g|0)==(c[q+16>>2]|0)){o=0;q=qa(c[(c[q>>2]|0)+40>>2]|0,q|0)|0;W=o;o=0;if(W&1){W=24;break b}}else{c[m>>2]=g+1;q=d[g>>0]|0}o=0;ma(93,$|0,q&255|0);W=o;o=0;if(W&1){W=24;break b}else{q=x;h=x;W=42}}break}case 0:{if((y|0)!=3){q=x;h=x;W=42}break}case 3:{m=a[_>>0]|0;q=(m&1)==0?(m&255)>>>1:c[J>>2]|0;g=a[Z>>0]|0;h=(g&1)==0?(g&255)>>>1:c[K>>2]|0;if((q|0)!=(0-h|0)){if(!q){q=c[e>>2]|0;m=c[q+12>>2]|0;if((m|0)==(c[q+16>>2]|0)){o=0;q=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}m=a[Z>>0]|0}else{q=d[m>>0]|0;m=g}if((q&255)<<24>>24!=(a[((m&1)==0?M:c[L>>2]|0)>>0]|0))break c;q=c[e>>2]|0;m=q+12|0;g=c[m>>2]|0;if((g|0)==(c[q+16>>2]|0)){o=0;qa(c[(c[q>>2]|0)+40>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}}else c[m>>2]=g+1;a[l>>0]=1;x=a[Z>>0]|0;t=((x&1)==0?(x&255)>>>1:c[K>>2]|0)>>>0>1?Z:t;break c}j=c[e>>2]|0;r=c[j+12>>2]|0;g=c[j+16>>2]|0;q=(r|0)==(g|0);if(!h){if(q){o=0;q=qa(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;x=o;o=0;if(x&1){W=24;break b}m=a[_>>0]|0}else q=d[r>>0]|0;if((q&255)<<24>>24!=(a[((m&1)==0?O:c[N>>2]|0)>>0]|0)){a[l>>0]=1;break c}q=c[e>>2]|0;m=q+12|0;g=c[m>>2]|0;if((g|0)==(c[q+16>>2]|0)){o=0;qa(c[(c[q>>2]|0)+40>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}}else c[m>>2]=g+1;x=a[_>>0]|0;t=((x&1)==0?(x&255)>>>1:c[J>>2]|0)>>>0>1?_:t;break c}if(q){o=0;q=qa(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;x=o;o=0;if(x&1){W=24;break b}g=c[e>>2]|0;m=a[_>>0]|0;j=g;r=c[g+12>>2]|0;g=c[g+16>>2]|0}else q=d[r>>0]|0;h=j+12|0;g=(r|0)==(g|0);if((q&255)<<24>>24==(a[((m&1)==0?O:c[N>>2]|0)>>0]|0)){if(g){o=0;qa(c[(c[j>>2]|0)+40>>2]|0,j|0)|0;x=o;o=0;if(x&1){W=24;break b}}else c[h>>2]=r+1;x=a[_>>0]|0;t=((x&1)==0?(x&255)>>>1:c[J>>2]|0)>>>0>1?_:t;break c}if(g){o=0;q=qa(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;x=o;o=0;if(x&1){W=24;break b}}else q=d[r>>0]|0;if((q&255)<<24>>24!=(a[((a[Z>>0]&1)==0?M:c[L>>2]|0)>>0]|0)){W=104;break b}q=c[e>>2]|0;m=q+12|0;g=c[m>>2]|0;if((g|0)==(c[q+16>>2]|0)){o=0;qa(c[(c[q>>2]|0)+40>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}}else c[m>>2]=g+1;a[l>>0]=1;x=a[Z>>0]|0;t=((x&1)==0?(x&255)>>>1:c[K>>2]|0)>>>0>1?Z:t}break}case 2:{if(!(y>>>0<2|(t|0)!=0)?!(z|(y|0)==2&(a[G>>0]|0)!=0):0){t=0;break c}v=a[aa>>0]|0;q=(v&1)==0;w=c[A>>2]|0;g=q?B:w;s=g;d:do if((y|0)!=0?(d[U+(y+-1)>>0]|0)<2:0){r=q?(v&255)>>>1:c[C>>2]|0;h=g+r|0;j=c[I>>2]|0;e:do if(!r)m=s;else{r=g;m=s;do{q=a[r>>0]|0;if(q<<24>>24<=-1)break e;if(!(b[j+(q<<24>>24<<1)>>1]&8192))break e;r=r+1|0;m=r}while((r|0)!=(h|0))}while(0);h=m-s|0;j=a[$>>0]|0;q=(j&1)==0;j=q?(j&255)>>>1:c[D>>2]|0;if(j>>>0>=h>>>0){q=q?F:c[E>>2]|0;r=q+j|0;if((m|0)!=(s|0)){q=q+(j-h)|0;while(1){if((a[q>>0]|0)!=(a[g>>0]|0)){m=s;break d}q=q+1|0;if((q|0)==(r|0))break;else g=g+1|0}}}else m=s}else m=s;while(0);q=(v&1)==0;q=(q?B:w)+(q?(v&255)>>>1:c[C>>2]|0)|0;f:do if((m|0)!=(q|0)){j=x;h=x;q=m;while(1){m=c[e>>2]|0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)){o=0;m=qa(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=21;break b}if((m|0)==-1){c[e>>2]=0;m=0;break}else{m=c[e>>2]|0;break}}}else m=0;while(0);g=(m|0)==0;do if(h){if((c[h+12>>2]|0)!=(c[h+16>>2]|0))if(g){m=j;r=h;break}else break f;o=0;m=qa(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){W=21;break b}if((m|0)!=-1)if(g^(j|0)==0){m=j;r=j;break}else break f;else{c[f>>2]=0;m=0;W=131;break}}else{m=j;W=131}while(0);if((W|0)==131){W=0;if(g)break f;else r=0}g=c[e>>2]|0;h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0)){o=0;g=qa(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){W=21;break b}}else g=d[h>>0]|0;if((g&255)<<24>>24!=(a[q>>0]|0))break f;g=c[e>>2]|0;h=g+12|0;j=c[h>>2]|0;if((j|0)==(c[g+16>>2]|0)){o=0;qa(c[(c[g>>2]|0)+40>>2]|0,g|0)|0;x=o;o=0;if(x&1){W=21;break b}}else c[h>>2]=j+1;q=q+1|0;g=a[aa>>0]|0;x=(g&1)==0;g=(x?B:c[A>>2]|0)+(x?(g&255)>>>1:c[C>>2]|0)|0;if((q|0)==(g|0)){q=g;break}else{j=m;h=r}}}while(0);if(z?(x=a[aa>>0]|0,w=(x&1)==0,(q|0)!=((w?B:c[A>>2]|0)+(w?(x&255)>>>1:c[C>>2]|0)|0)):0){W=143;break b}break}case 4:{s=a[V>>0]|0;m=x;j=x;q=0;g:while(1){g=c[e>>2]|0;do if(g){if((c[g+12>>2]|0)==(c[g+16>>2]|0)){o=0;g=qa(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){W=23;break b}if((g|0)==-1){c[e>>2]=0;g=0;break}else{g=c[e>>2]|0;break}}}else g=0;while(0);h=(g|0)==0;do if(j){if((c[j+12>>2]|0)!=(c[j+16>>2]|0))if(h){r=m;break}else{h=m;break g}o=0;g=qa(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;x=o;o=0;if(x&1){W=23;break b}if((g|0)!=-1)if(h^(m|0)==0){r=m;j=m;break}else{h=m;break g}else{c[f>>2]=0;m=0;W=156;break}}else W=156;while(0);if((W|0)==156){W=0;if(h){h=m;break}else{r=m;j=0}}m=c[e>>2]|0;g=c[m+12>>2]|0;if((g|0)==(c[m+16>>2]|0)){o=0;m=qa(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=23;break b}}else m=d[g>>0]|0;g=m&255;if(g<<24>>24>-1?(b[(c[I>>2]|0)+(m<<24>>24<<1)>>1]&2048)!=0:0){m=c[p>>2]|0;if((m|0)==(c[P>>2]|0)){o=0;mb(116,n|0,p|0,P|0);x=o;o=0;if(x&1){W=23;break b}m=c[p>>2]|0}c[p>>2]=m+1;a[m>>0]=g;q=q+1|0}else{x=a[Y>>0]|0;if(!(g<<24>>24==s<<24>>24&((q|0)!=0?(((x&1)==0?(x&255)>>>1:c[H>>2]|0)|0)!=0:0))){h=r;break}if((u|0)==(c[S>>2]|0)){o=0;mb(117,da|0,T|0,S|0);x=o;o=0;if(x&1){W=23;break b}u=c[T>>2]|0}x=u+4|0;c[T>>2]=x;c[u>>2]=q;u=x;q=0}m=c[e>>2]|0;g=m+12|0;h=c[g>>2]|0;if((h|0)==(c[m+16>>2]|0)){o=0;qa(c[(c[m>>2]|0)+40>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=23;break b}else{m=r;continue}}else{c[g>>2]=h+1;m=r;continue}}if((q|0)!=0?(c[da>>2]|0)!=(u|0):0){if((u|0)==(c[S>>2]|0)){o=0;mb(117,da|0,T|0,S|0);x=o;o=0;if(x&1){W=24;break b}u=c[T>>2]|0}x=u+4|0;c[T>>2]=x;c[u>>2]=q;u=x}r=c[R>>2]|0;if((r|0)>0){q=c[e>>2]|0;do if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;q=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}if((q|0)==-1){c[e>>2]=0;q=0;break}else{q=c[e>>2]|0;break}}}else q=0;while(0);q=(q|0)==0;do if(h){if((c[h+12>>2]|0)==(c[h+16>>2]|0)){o=0;m=qa(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){W=24;break b}if((m|0)==-1){c[f>>2]=0;W=193;break}}if(!q){W=198;break b}}else W=193;while(0);if((W|0)==193){W=0;if(q){W=198;break b}else h=0}q=c[e>>2]|0;m=c[q+12>>2]|0;if((m|0)==(c[q+16>>2]|0)){o=0;q=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}}else q=d[m>>0]|0;if((q&255)<<24>>24!=(a[Q>>0]|0)){W=198;break b}q=c[e>>2]|0;m=q+12|0;g=c[m>>2]|0;if((g|0)==(c[q+16>>2]|0)){o=0;qa(c[(c[q>>2]|0)+40>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}}else c[m>>2]=g+1;if((r|0)>0){j=h;g=h;s=r;while(1){q=c[e>>2]|0;do if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;q=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=22;break b}if((q|0)==-1){c[e>>2]=0;q=0;break}else{q=c[e>>2]|0;break}}}else q=0;while(0);m=(q|0)==0;do if(g){if((c[g+12>>2]|0)!=(c[g+16>>2]|0))if(m){q=j;r=g;break}else{W=222;break b}o=0;q=qa(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){W=22;break b}if((q|0)!=-1)if(m^(j|0)==0){q=j;r=j;break}else{W=222;break b}else{c[f>>2]=0;q=0;W=215;break}}else{q=j;W=215}while(0);if((W|0)==215){W=0;if(m){W=222;break b}else r=0}m=c[e>>2]|0;g=c[m+12>>2]|0;if((g|0)==(c[m+16>>2]|0)){o=0;m=qa(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=22;break b}}else m=d[g>>0]|0;if((m&255)<<24>>24<=-1){W=222;break b}if(!(b[(c[I>>2]|0)+(m<<24>>24<<1)>>1]&2048)){W=222;break b}if((c[p>>2]|0)==(c[P>>2]|0)?(o=0,mb(116,n|0,p|0,P|0),x=o,o=0,x&1):0){W=22;break b}m=c[e>>2]|0;g=c[m+12>>2]|0;if((g|0)==(c[m+16>>2]|0)){o=0;m=qa(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=22;break b}}else m=d[g>>0]|0;g=c[p>>2]|0;c[p>>2]=g+1;a[g>>0]=m;m=s;s=s+-1|0;c[R>>2]=s;g=c[e>>2]|0;h=g+12|0;j=c[h>>2]|0;if((j|0)==(c[g+16>>2]|0)){o=0;qa(c[(c[g>>2]|0)+40>>2]|0,g|0)|0;x=o;o=0;if(x&1){W=22;break b}}else c[h>>2]=j+1;if((m|0)<=1)break;else{j=q;g=r}}}}if((c[p>>2]|0)==(c[n>>2]|0)){W=233;break b}break}default:{}}while(0);h:do if((W|0)==42)while(1){W=0;m=c[e>>2]|0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)){o=0;m=qa(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=20;break b}if((m|0)==-1){c[e>>2]=0;m=0;break}else{m=c[e>>2]|0;break}}}else m=0;while(0);g=(m|0)==0;do if(h){if((c[h+12>>2]|0)!=(c[h+16>>2]|0))if(g){j=q;break}else break h;o=0;m=qa(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){W=20;break b}if((m|0)!=-1)if(g^(q|0)==0){j=q;h=q;break}else break h;else{c[f>>2]=0;q=0;W=54;break}}else W=54;while(0);if((W|0)==54){W=0;if(g)break h;else{j=q;h=0}}q=c[e>>2]|0;m=c[q+12>>2]|0;if((m|0)==(c[q+16>>2]|0)){o=0;q=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=20;break b}}else q=d[m>>0]|0;if((q&255)<<24>>24<=-1)break h;if(!(b[(c[I>>2]|0)+(q<<24>>24<<1)>>1]&8192))break h;q=c[e>>2]|0;m=q+12|0;g=c[m>>2]|0;if((g|0)==(c[q+16>>2]|0)){o=0;q=qa(c[(c[q>>2]|0)+40>>2]|0,q|0)|0;W=o;o=0;if(W&1){W=20;break b}}else{c[m>>2]=g+1;q=d[g>>0]|0}o=0;ma(93,$|0,q&255|0);W=o;o=0;if(W&1){W=20;break b}else{q=j;W=42}}while(0);y=y+1|0;if(y>>>0>=4){W=235;break}}i:switch(W|0){case 20:{m=cc()|0;break a}case 21:{m=cc()|0;break a}case 22:{m=cc()|0;break a}case 23:{m=cc()|0;break a}case 24:{m=cc()|0;break a}case 40:{c[k>>2]=c[k>>2]|4;m=0;break}case 104:{c[k>>2]=c[k>>2]|4;m=0;break}case 143:{c[k>>2]=c[k>>2]|4;m=0;break}case 198:{c[k>>2]=c[k>>2]|4;m=0;break}case 222:{c[k>>2]=c[k>>2]|4;m=0;break}case 233:{c[k>>2]=c[k>>2]|4;m=0;break}case 235:{j:do if(t){j=t+1|0;r=t+8|0;s=t+4|0;g=1;k:while(1){q=a[t>>0]|0;if(!(q&1))q=(q&255)>>>1;else q=c[s>>2]|0;if(g>>>0>=q>>>0)break j;q=c[e>>2]|0;do if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;q=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;p=o;o=0;if(p&1){W=19;break k}if((q|0)==-1){c[e>>2]=0;q=0;break}else{q=c[e>>2]|0;break}}}else q=0;while(0);m=(q|0)==0;q=c[f>>2]|0;do if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;q=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;p=o;o=0;if(p&1){W=19;break k}if((q|0)==-1){c[f>>2]=0;W=253;break}}if(!m){W=260;break k}}else W=253;while(0);if((W|0)==253?(W=0,m):0){W=260;break}q=c[e>>2]|0;m=c[q+12>>2]|0;if((m|0)==(c[q+16>>2]|0)){o=0;q=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;p=o;o=0;if(p&1){W=19;break}}else q=d[m>>0]|0;if(!(a[t>>0]&1))m=j;else m=c[r>>2]|0;if((q&255)<<24>>24!=(a[m+g>>0]|0)){W=260;break}q=g+1|0;m=c[e>>2]|0;g=m+12|0;h=c[g>>2]|0;if((h|0)==(c[m+16>>2]|0)){o=0;qa(c[(c[m>>2]|0)+40>>2]|0,m|0)|0;p=o;o=0;if(p&1){W=19;break}else{g=q;continue}}else{c[g>>2]=h+1;g=q;continue}}if((W|0)==19){m=cc()|0;break a}else if((W|0)==260){c[k>>2]=c[k>>2]|4;m=0;break i}}while(0);q=c[da>>2]|0;if((q|0)!=(u|0)?(c[X>>2]=0,oH(Y,q,u,X),(c[X>>2]|0)!=0):0){c[k>>2]=c[k>>2]|4;m=0}else m=1;break}}IC($);IC(Z);IC(_);IC(aa);IC(Y);q=c[da>>2]|0;c[da>>2]=0;if((q|0)!=0?(o=0,ka(c[ca>>2]|0,q|0),da=o,o=0,da&1):0){da=cc(0)|0;oq(da)}i=ba;return m|0}while(0);IC($);IC(Z);IC(_);IC(aa);IC(Y);q=c[da>>2]|0;c[da>>2]=0;if((q|0)!=0?(o=0,ka(c[ca>>2]|0,q|0),da=o,o=0,da&1):0){da=cc(0)|0;oq(da)}bc(m|0);return 0}function lH(a){a=a|0;var b=0;b=Ob(8)|0;o=0;ma(222,b|0,a|0);a=o;o=0;if(a&1){a=cc()|0;Nb(b|0);bc(a|0)}else Hc(b|0,1800,218)}function mH(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;w=i;i=i+144|0;k=w+24|0;b=w+32|0;x=w+16|0;s=w+8|0;p=w+4|0;q=w+28|0;l=w;c[x>>2]=b;A=x+4|0;c[A>>2]=345;m=b+100|0;o=0;v=qa(192,g|0)|0;n=o;o=0;if(!(n&1)){c[p>>2]=v;o=0;n=Wa(115,p|0,40904)|0;b=o;o=0;a:do if(!(b&1)?(a[q>>0]=0,t=c[e>>2]|0,c[l>>2]=t,r=c[g+4>>2]|0,u=t,o=0,c[k>>2]=c[l>>2],r=ua(42,d|0,k|0,f|0,p|0,r|0,h|0,q|0,n|0,x|0,s|0,m|0)|0,g=o,o=0,!(g&1)):0){if(r){if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}if(a[q>>0]|0){o=0;b=Wa(c[(c[n>>2]|0)+28>>2]|0,n|0,45)|0;g=o;o=0;if(g&1)break;o=0;ma(93,j|0,b|0);g=o;o=0;if(g&1)break}o=0;l=Wa(c[(c[n>>2]|0)+28>>2]|0,n|0,48)|0;g=o;o=0;if(g&1)break;b=c[x>>2]|0;m=c[s>>2]|0;k=m+-1|0;b:do if(b>>>0<k>>>0)do{if((a[b>>0]|0)!=l<<24>>24)break b;b=b+1|0}while(b>>>0<k>>>0);while(0);o=0;ya(122,j|0,b|0,m|0)|0;j=o;o=0;if(j&1)break}b=c[d>>2]|0;do if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;b=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;j=o;o=0;if(j&1)break a;if((b|0)==-1){c[d>>2]=0;b=0;break}else{b=c[d>>2]|0;break}}}else b=0;while(0);k=(b|0)==0;do if(t){if((c[u+12>>2]|0)==(c[u+16>>2]|0)){o=0;b=qa(c[(c[t>>2]|0)+36>>2]|0,u|0)|0;u=o;o=0;if(u&1)break a;if((b|0)==-1){c[e>>2]=0;z=29;break}}if(!k)z=30}else z=29;while(0);if((z|0)==29?k:0)z=30;if((z|0)==30)c[h>>2]=c[h>>2]|2;k=c[d>>2]|0;EL(v)|0;b=c[x>>2]|0;c[x>>2]=0;if((b|0)!=0?(o=0,ka(c[A>>2]|0,b|0),A=o,o=0,A&1):0){A=cc(0)|0;oq(A)}i=w;return k|0}while(0);k=cc()|0;EL(v)|0;b=c[x>>2]|0;c[x>>2]=0;if(!b)y=k;else z=36}else{k=cc()|0;c[x>>2]=0;z=36}if((z|0)==36){o=0;ka(c[A>>2]|0,b|0);A=o;o=0;if(A&1){A=cc(0)|0;oq(A)}else y=k}bc(y|0);return 0}function nH(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;z=i;i=i+112|0;n=z+100|0;p=z+88|0;q=z+76|0;r=z+64|0;s=z+52|0;t=z+48|0;u=z+36|0;v=z+24|0;w=z+12|0;x=z;do if(b){b=cI(d,40512)|0;$c[c[(c[b>>2]|0)+44>>2]&511](n,b);x=c[n>>2]|0;a[e>>0]=x;a[e+1>>0]=x>>8;a[e+2>>0]=x>>16;a[e+3>>0]=x>>24;$c[c[(c[b>>2]|0)+32>>2]&511](p,b);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}o=0;ma(114,l|0,0);e=o;o=0;if(e&1){e=cc(0)|0;oq(e)};c[l>>2]=c[p>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;IC(p);$c[c[(c[b>>2]|0)+28>>2]&511](q,b);if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}o=0;ma(114,k|0,0);e=o;o=0;if(e&1){e=cc(0)|0;oq(e)};c[k>>2]=c[q>>2];c[k+4>>2]=c[q+4>>2];c[k+8>>2]=c[q+8>>2];c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;IC(q);a[f>>0]=bd[c[(c[b>>2]|0)+12>>2]&255](b)|0;a[g>>0]=bd[c[(c[b>>2]|0)+16>>2]&255](b)|0;$c[c[(c[b>>2]|0)+20>>2]&511](r,b);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}o=0;ma(114,h|0,0);g=o;o=0;if(g&1){g=cc(0)|0;oq(g)};c[h>>2]=c[r>>2];c[h+4>>2]=c[r+4>>2];c[h+8>>2]=c[r+8>>2];c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;IC(r);$c[c[(c[b>>2]|0)+24>>2]&511](s,b);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}o=0;ma(114,j|0,0);g=o;o=0;if(g&1){g=cc(0)|0;oq(g)}else{c[j>>2]=c[s>>2];c[j+4>>2]=c[s+4>>2];c[j+8>>2]=c[s+8>>2];c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;IC(s);y=bd[c[(c[b>>2]|0)+36>>2]&255](b)|0;break}}else{b=cI(d,40448)|0;$c[c[(c[b>>2]|0)+44>>2]&511](t,b);t=c[t>>2]|0;a[e>>0]=t;a[e+1>>0]=t>>8;a[e+2>>0]=t>>16;a[e+3>>0]=t>>24;$c[c[(c[b>>2]|0)+32>>2]&511](u,b);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}o=0;ma(114,l|0,0);e=o;o=0;if(e&1){e=cc(0)|0;oq(e)};c[l>>2]=c[u>>2];c[l+4>>2]=c[u+4>>2];c[l+8>>2]=c[u+8>>2];c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;IC(u);$c[c[(c[b>>2]|0)+28>>2]&511](v,b);if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}o=0;ma(114,k|0,0);e=o;o=0;if(e&1){e=cc(0)|0;oq(e)};c[k>>2]=c[v>>2];c[k+4>>2]=c[v+4>>2];c[k+8>>2]=c[v+8>>2];c[v>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;IC(v);a[f>>0]=bd[c[(c[b>>2]|0)+12>>2]&255](b)|0;a[g>>0]=bd[c[(c[b>>2]|0)+16>>2]&255](b)|0;$c[c[(c[b>>2]|0)+20>>2]&511](w,b);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}o=0;ma(114,h|0,0);g=o;o=0;if(g&1){g=cc(0)|0;oq(g)};c[h>>2]=c[w>>2];c[h+4>>2]=c[w+4>>2];c[h+8>>2]=c[w+8>>2];c[w>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;IC(w);$c[c[(c[b>>2]|0)+24>>2]&511](x,b);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}o=0;ma(114,j|0,0);g=o;o=0;if(g&1){g=cc(0)|0;oq(g)}else{c[j>>2]=c[x>>2];c[j+4>>2]=c[x+4>>2];c[j+8>>2]=c[x+8>>2];c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;IC(x);y=bd[c[(c[b>>2]|0)+36>>2]&255](b)|0;break}}while(0);c[m>>2]=y;i=z;return}function oH(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;g=a[b>>0]|0;i=b+4|0;h=c[i>>2]|0;a:do if(((g&1)==0?(g&255)>>>1:h)|0){if((d|0)!=(e|0)){g=e+-4|0;if(g>>>0>d>>>0){h=d;do{j=c[h>>2]|0;c[h>>2]=c[g>>2];c[g>>2]=j;h=h+4|0;g=g+-4|0}while(h>>>0<g>>>0)}g=a[b>>0]|0;h=c[i>>2]|0}j=(g&1)==0;i=j?b+1|0:c[b+8>>2]|0;e=e+-4|0;b=i+(j?(g&255)>>>1:h)|0;h=a[i>>0]|0;g=h<<24>>24<1|h<<24>>24==127;b:do if(e>>>0>d>>>0){while(1){if(!g?(h<<24>>24|0)!=(c[d>>2]|0):0)break;i=(b-i|0)>1?i+1|0:i;d=d+4|0;h=a[i>>0]|0;g=h<<24>>24<1|h<<24>>24==127;if(d>>>0>=e>>>0)break b}c[f>>2]=4;break a}while(0);if(!g?((c[e>>2]|0)+-1|0)>>>0>=h<<24>>24>>>0:0)c[f>>2]=4}while(0);return}function pH(a){a=a|0;return}function qH(a){a=a|0;Uz(a);return}function rH(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;B=i;i=i+576|0;x=B+424|0;A=B;b=B+24|0;D=B+16|0;y=B+12|0;C=B+8|0;p=B+464|0;l=B+4|0;z=B+468|0;c[D>>2]=b;F=D+4|0;c[F>>2]=345;m=b+400|0;o=0;k=qa(192,g|0)|0;w=o;o=0;if(!(w&1)){c[C>>2]=k;o=0;b=Wa(115,C|0,40896)|0;w=o;o=0;a:do if(!(w&1)?(a[p>>0]=0,c[l>>2]=c[e>>2],n=c[g+4>>2]|0,o=0,c[x>>2]=c[l>>2],n=ua(43,d|0,x|0,f|0,C|0,n|0,h|0,p|0,b|0,D|0,y|0,m|0)|0,w=o,o=0,!(w&1)):0){b:do if(n){o=0;kb(c[(c[b>>2]|0)+48>>2]|0,b|0,61366,61376,x|0)|0;w=o;o=0;if(w&1){G=10;break a}l=c[y>>2]|0;m=c[D>>2]|0;b=l-m|0;if((b|0)>392){b=yC((b>>2)+2|0)|0;k=b;if(!b){o=0;ob(46);w=o;o=0;if(!(w&1)){b=0;G=13}}else G=13}else{k=0;b=z;G=13}do if((G|0)==13){if(a[p>>0]|0){a[b>>0]=45;b=b+1|0}v=x+40|0;w=x;if(m>>>0<l>>>0){n=x+4|0;f=n+4|0;g=f+4|0;p=g+4|0;q=p+4|0;r=q+4|0;s=r+4|0;t=s+4|0;u=t+4|0;do{l=c[m>>2]|0;do if((c[x>>2]|0)!=(l|0))if((c[n>>2]|0)!=(l|0))if((c[f>>2]|0)!=(l|0))if((c[g>>2]|0)!=(l|0))if((c[p>>2]|0)==(l|0))l=p;else{if((c[q>>2]|0)==(l|0)){l=q;break}if((c[r>>2]|0)==(l|0)){l=r;break}if((c[s>>2]|0)==(l|0)){l=s;break}if((c[t>>2]|0)==(l|0)){l=t;break}l=(c[u>>2]|0)==(l|0)?u:v}else l=g;else l=f;else l=n;else l=x;while(0);a[b>>0]=a[61366+(l-w>>2)>>0]|0;m=m+4|0;b=b+1|0}while(m>>>0<(c[y>>2]|0)>>>0)}a[b>>0]=0;c[A>>2]=j;if((TB(z,61346,A)|0)!=1?(o=0,ka(346,61350),j=o,o=0,j&1):0)break;if(k)zC(k);break b}while(0);b=cc()|0;if(!k){l=b;k=D;break a}zC(k);l=b;k=D;break a}while(0);b=c[d>>2]|0;do if(b){k=c[b+12>>2]|0;if((k|0)==(c[b+16>>2]|0)){o=0;b=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;j=o;o=0;if(j&1){G=10;break a}}else b=c[k>>2]|0;if((b|0)==-1){c[d>>2]=0;l=1;break}else{l=(c[d>>2]|0)==0;break}}else l=1;while(0);b=c[e>>2]|0;do if(b){k=c[b+12>>2]|0;if((k|0)==(c[b+16>>2]|0)){o=0;b=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;j=o;o=0;if(j&1){G=10;break a}}else b=c[k>>2]|0;if((b|0)!=-1)if(l)break;else{G=40;break}else{c[e>>2]=0;G=38;break}}else G=38;while(0);if((G|0)==38?l:0)G=40;if((G|0)==40)c[h>>2]=c[h>>2]|2;k=c[d>>2]|0;EL(c[C>>2]|0)|0;b=c[D>>2]|0;c[D>>2]=0;if((b|0)!=0?(o=0,ka(c[F>>2]|0,b|0),G=o,o=0,G&1):0){G=cc(0)|0;oq(G)}i=B;return k|0}else G=10;while(0);if((G|0)==10){l=cc()|0;k=D}EL(c[C>>2]|0)|0;b=c[k>>2]|0;c[k>>2]=0;if(!b)E=l;else{k=c[F>>2]|0;G=47}}else{l=cc()|0;c[D>>2]=0;k=345;G=47}if((G|0)==47){o=0;ka(k|0,b|0);G=o;o=0;if(G&1){G=cc(0)|0;oq(G)}else E=l}bc(E|0);return 0}
function sH(b,e,f,g,h,j,k,l,m,n,p){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;p=p|0;var q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0;Y=i;i=i+512|0;K=Y+96|0;q=Y+104|0;_=Y+88|0;O=Y+80|0;N=Y+76|0;P=Y+504|0;L=Y+72|0;Q=Y+68|0;T=Y+56|0;X=Y+44|0;V=Y+32|0;U=Y+20|0;W=Y+8|0;M=Y+4|0;S=Y;c[K>>2]=p;c[_>>2]=q;Z=_+4|0;c[Z>>2]=345;c[O>>2]=q;c[N>>2]=q+400;c[T>>2]=0;c[T+4>>2]=0;c[T+8>>2]=0;c[X>>2]=0;c[X+4>>2]=0;c[X+8>>2]=0;c[V>>2]=0;c[V+4>>2]=0;c[V+8>>2]=0;c[U>>2]=0;c[U+4>>2]=0;c[U+8>>2]=0;c[W>>2]=0;c[W+4>>2]=0;c[W+8>>2]=0;o=0;Ua(43,f|0,g|0,P|0,L|0,Q|0,T|0,X|0,V|0,U|0,M|0);J=o;o=0;a:do if(J&1)f=cc()|0;else{c[n>>2]=c[m>>2];G=V+4|0;H=U+4|0;I=U+8|0;J=V+8|0;z=(h&512|0)!=0;A=X+8|0;B=X+4|0;C=W+4|0;D=W+8|0;E=P+3|0;F=T+4|0;y=0;s=0;b:while(1){p=c[b>>2]|0;do if(p){f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;x=o;o=0;if(x&1){R=26;break b}}else p=c[f>>2]|0;if((p|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);f=c[e>>2]|0;do if(f){p=c[f+12>>2]|0;if((p|0)==(c[f+16>>2]|0)){o=0;p=qa(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=26;break b}}else p=c[p>>2]|0;if((p|0)!=-1)if(g){x=f;break}else{t=q;R=244;break b}else{c[e>>2]=0;R=16;break}}else R=16;while(0);if((R|0)==16){R=0;if(g){t=q;R=244;break}else x=0}c:do switch(a[P+y>>0]|0){case 1:{if((y|0)!=3){p=c[b>>2]|0;f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;R=o;o=0;if(R&1){R=26;break b}}else p=c[f>>2]|0;o=0;p=ya(c[(c[l>>2]|0)+12>>2]|0,l|0,8192,p|0)|0;R=o;o=0;if(R&1){R=26;break b}if(!p){R=42;break b}p=c[b>>2]|0;f=p+12|0;g=c[f>>2]|0;if((g|0)==(c[p+16>>2]|0)){o=0;p=qa(c[(c[p>>2]|0)+40>>2]|0,p|0)|0;R=o;o=0;if(R&1){R=26;break b}}else{c[f>>2]=g+4;p=c[g>>2]|0}o=0;ma(223,W|0,p|0);R=o;o=0;if(R&1){R=26;break b}else{p=x;h=x;R=44}}else p=q;break}case 0:{if((y|0)==3)p=q;else{p=x;h=x;R=44}break}case 3:{f=a[V>>0]|0;p=(f&1)==0?(f&255)>>>1:c[G>>2]|0;g=a[U>>0]|0;h=(g&1)==0?(g&255)>>>1:c[H>>2]|0;if((p|0)==(0-h|0))p=q;else{if(!p){p=c[b>>2]|0;f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;x=o;o=0;if(x&1){R=26;break b}f=a[U>>0]|0}else{p=c[f>>2]|0;f=g}if((p|0)!=(c[((f&1)==0?H:c[I>>2]|0)>>2]|0)){p=q;break c}p=c[b>>2]|0;f=p+12|0;g=c[f>>2]|0;if((g|0)==(c[p+16>>2]|0)){o=0;qa(c[(c[p>>2]|0)+40>>2]|0,p|0)|0;x=o;o=0;if(x&1){R=26;break b}}else c[f>>2]=g+4;a[k>>0]=1;x=a[U>>0]|0;p=q;s=((x&1)==0?(x&255)>>>1:c[H>>2]|0)>>>0>1?U:s;break c}r=c[b>>2]|0;t=c[r+12>>2]|0;g=c[r+16>>2]|0;p=(t|0)==(g|0);if(!h){if(p){o=0;p=qa(c[(c[r>>2]|0)+36>>2]|0,r|0)|0;x=o;o=0;if(x&1){R=26;break b}f=a[V>>0]|0}else p=c[t>>2]|0;if((p|0)!=(c[((f&1)==0?G:c[J>>2]|0)>>2]|0)){a[k>>0]=1;p=q;break c}p=c[b>>2]|0;f=p+12|0;g=c[f>>2]|0;if((g|0)==(c[p+16>>2]|0)){o=0;qa(c[(c[p>>2]|0)+40>>2]|0,p|0)|0;x=o;o=0;if(x&1){R=26;break b}}else c[f>>2]=g+4;x=a[V>>0]|0;p=q;s=((x&1)==0?(x&255)>>>1:c[G>>2]|0)>>>0>1?V:s;break c}if(p){o=0;p=qa(c[(c[r>>2]|0)+36>>2]|0,r|0)|0;x=o;o=0;if(x&1){R=26;break b}g=c[b>>2]|0;f=a[V>>0]|0;r=g;t=c[g+12>>2]|0;g=c[g+16>>2]|0}else p=c[t>>2]|0;h=r+12|0;g=(t|0)==(g|0);if((p|0)==(c[((f&1)==0?G:c[J>>2]|0)>>2]|0)){if(g){o=0;qa(c[(c[r>>2]|0)+40>>2]|0,r|0)|0;x=o;o=0;if(x&1){R=26;break b}}else c[h>>2]=t+4;x=a[V>>0]|0;p=q;s=((x&1)==0?(x&255)>>>1:c[G>>2]|0)>>>0>1?V:s;break c}if(g){o=0;p=qa(c[(c[r>>2]|0)+36>>2]|0,r|0)|0;x=o;o=0;if(x&1){R=26;break b}}else p=c[t>>2]|0;if((p|0)!=(c[((a[U>>0]&1)==0?H:c[I>>2]|0)>>2]|0)){R=107;break b}p=c[b>>2]|0;f=p+12|0;g=c[f>>2]|0;if((g|0)==(c[p+16>>2]|0)){o=0;qa(c[(c[p>>2]|0)+40>>2]|0,p|0)|0;x=o;o=0;if(x&1){R=26;break b}}else c[f>>2]=g+4;a[k>>0]=1;x=a[U>>0]|0;p=q;s=((x&1)==0?(x&255)>>>1:c[H>>2]|0)>>>0>1?U:s}break}case 2:{if(!(y>>>0<2|(s|0)!=0)?!(z|(y|0)==2&(a[E>>0]|0)!=0):0){p=q;s=0;break c}h=a[X>>0]|0;g=c[A>>2]|0;f=(h&1)==0?B:g;p=f;d:do if((y|0)!=0?(d[P+(y+-1)>>0]|0)<2:0){w=(h&1)==0;e:do if((f|0)!=((w?B:g)+((w?(h&255)>>>1:c[B>>2]|0)<<2)|0)){h=f;while(1){o=0;f=ya(c[(c[l>>2]|0)+12>>2]|0,l|0,8192,c[h>>2]|0)|0;w=o;o=0;if(w&1){R=23;break b}if(!f)break;h=h+4|0;p=h;f=a[X>>0]|0;g=c[A>>2]|0;w=(f&1)==0;if((h|0)==((w?B:g)+((w?(f&255)>>>1:c[B>>2]|0)<<2)|0)){h=f;break e}}h=a[X>>0]|0;g=c[A>>2]|0}while(0);t=(h&1)==0?B:g;f=t;u=p-f>>2;v=a[W>>0]|0;r=(v&1)==0;v=r?(v&255)>>>1:c[C>>2]|0;if(v>>>0>=u>>>0){r=r?C:c[D>>2]|0;w=r+(v<<2)|0;if(!u)f=p;else{r=r+(v-u<<2)|0;while(1){if((c[r>>2]|0)!=(c[t>>2]|0))break d;r=r+4|0;if((r|0)==(w|0)){f=p;break}else t=t+4|0}}}}else f=p;while(0);p=(h&1)==0;p=(p?B:g)+((p?(h&255)>>>1:c[B>>2]|0)<<2)|0;f:do if((f|0)!=(p|0)){r=x;h=x;p=f;while(1){f=c[b>>2]|0;do if(f){g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0)){o=0;f=qa(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=22;break b}}else f=c[g>>2]|0;if((f|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(h){f=c[h+12>>2]|0;if((f|0)==(c[h+16>>2]|0)){o=0;f=qa(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){R=22;break b}}else f=c[f>>2]|0;if((f|0)!=-1)if(g^(r|0)==0){f=r;t=r;break}else break f;else{c[e>>2]=0;f=0;R=136;break}}else{f=r;R=136}while(0);if((R|0)==136){R=0;if(g)break f;else t=0}g=c[b>>2]|0;h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0)){o=0;g=qa(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){R=22;break b}}else g=c[h>>2]|0;if((g|0)!=(c[p>>2]|0))break f;g=c[b>>2]|0;h=g+12|0;r=c[h>>2]|0;if((r|0)==(c[g+16>>2]|0)){o=0;qa(c[(c[g>>2]|0)+40>>2]|0,g|0)|0;x=o;o=0;if(x&1){R=22;break b}}else c[h>>2]=r+4;p=p+4|0;g=a[X>>0]|0;x=(g&1)==0;g=(x?B:c[A>>2]|0)+((x?(g&255)>>>1:c[B>>2]|0)<<2)|0;if((p|0)==(g|0)){p=g;break}else{r=f;h=t}}}while(0);if(z?(x=a[X>>0]|0,w=(x&1)==0,(p|0)!=((w?B:c[A>>2]|0)+((w?(x&255)>>>1:c[B>>2]|0)<<2)|0)):0){R=148;break b}else p=q;break}case 4:{v=c[Q>>2]|0;u=x;r=x;p=q;f=0;g:while(1){g=c[b>>2]|0;do if(g){h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0)){o=0;g=qa(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){R=25;break b}}else g=c[h>>2]|0;if((g|0)==-1){c[b>>2]=0;h=1;break}else{h=(c[b>>2]|0)==0;break}}else h=1;while(0);do if(r){g=c[r+12>>2]|0;if((g|0)==(c[r+16>>2]|0)){o=0;g=qa(c[(c[r>>2]|0)+36>>2]|0,r|0)|0;x=o;o=0;if(x&1){R=25;break b}}else g=c[g>>2]|0;if((g|0)!=-1)if(h^(u|0)==0){g=u;t=u;break}else{q=u;break g}else{c[e>>2]=0;g=0;R=162;break}}else{g=u;R=162}while(0);if((R|0)==162){R=0;if(h){q=g;break}else t=0}h=c[b>>2]|0;q=c[h+12>>2]|0;if((q|0)==(c[h+16>>2]|0)){o=0;h=qa(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){R=25;break b}}else h=c[q>>2]|0;o=0;q=ya(c[(c[l>>2]|0)+12>>2]|0,l|0,2048,h|0)|0;x=o;o=0;if(x&1){R=25;break b}if(q){q=c[n>>2]|0;if((q|0)==(c[K>>2]|0)){o=0;mb(118,m|0,n|0,K|0);x=o;o=0;if(x&1){R=25;break b}q=c[n>>2]|0}c[n>>2]=q+4;c[q>>2]=h;f=f+1|0}else{x=a[T>>0]|0;if(!((h|0)==(v|0)&((f|0)!=0?(((x&1)==0?(x&255)>>>1:c[F>>2]|0)|0)!=0:0))){q=g;break}if((p|0)==(c[N>>2]|0)){o=0;mb(117,_|0,O|0,N|0);x=o;o=0;if(x&1){R=25;break b}p=c[O>>2]|0}x=p+4|0;c[O>>2]=x;c[p>>2]=f;p=x;f=0}h=c[b>>2]|0;q=h+12|0;r=c[q>>2]|0;if((r|0)==(c[h+16>>2]|0)){o=0;qa(c[(c[h>>2]|0)+40>>2]|0,h|0)|0;x=o;o=0;if(x&1){R=25;break b}else{u=g;r=t;continue}}else{c[q>>2]=r+4;u=g;r=t;continue}}if((f|0)!=0?(c[_>>2]|0)!=(p|0):0){if((p|0)==(c[N>>2]|0)){o=0;mb(117,_|0,O|0,N|0);x=o;o=0;if(x&1){R=26;break b}p=c[O>>2]|0}x=p+4|0;c[O>>2]=x;c[p>>2]=f;p=x}t=c[M>>2]|0;if((t|0)>0){f=c[b>>2]|0;do if(f){g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0)){o=0;f=qa(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=26;break b}}else f=c[g>>2]|0;if((f|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(q){f=c[q+12>>2]|0;if((f|0)==(c[q+16>>2]|0)){o=0;f=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){R=26;break b}}else f=c[f>>2]|0;if((f|0)!=-1)if(g)break;else{R=206;break b}else{c[e>>2]=0;R=200;break}}else R=200;while(0);if((R|0)==200){R=0;if(g){R=206;break b}else q=0}f=c[b>>2]|0;g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0)){o=0;f=qa(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=26;break b}}else f=c[g>>2]|0;if((f|0)!=(c[L>>2]|0)){R=206;break b}f=c[b>>2]|0;g=f+12|0;h=c[g>>2]|0;if((h|0)==(c[f+16>>2]|0)){o=0;qa(c[(c[f>>2]|0)+40>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=26;break b}}else c[g>>2]=h+4;if((t|0)>0){r=q;h=q;u=t;while(1){f=c[b>>2]|0;do if(f){g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0)){o=0;f=qa(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=24;break b}}else f=c[g>>2]|0;if((f|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(h){f=c[h+12>>2]|0;if((f|0)==(c[h+16>>2]|0)){o=0;f=qa(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){R=24;break b}}else f=c[f>>2]|0;if((f|0)!=-1)if(g^(r|0)==0){f=r;t=r;break}else{R=231;break b}else{c[e>>2]=0;f=0;R=224;break}}else{f=r;R=224}while(0);if((R|0)==224){R=0;if(g){R=231;break b}else t=0}g=c[b>>2]|0;h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0)){o=0;g=qa(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){R=24;break b}}else g=c[h>>2]|0;o=0;g=ya(c[(c[l>>2]|0)+12>>2]|0,l|0,2048,g|0)|0;x=o;o=0;if(x&1){R=24;break b}if(!g){R=231;break b}if((c[n>>2]|0)==(c[K>>2]|0)?(o=0,mb(118,m|0,n|0,K|0),x=o,o=0,x&1):0){R=24;break b}g=c[b>>2]|0;h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0)){o=0;g=qa(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){R=24;break b}}else g=c[h>>2]|0;h=c[n>>2]|0;c[n>>2]=h+4;c[h>>2]=g;g=u;u=u+-1|0;c[M>>2]=u;h=c[b>>2]|0;q=h+12|0;r=c[q>>2]|0;if((r|0)==(c[h+16>>2]|0)){o=0;qa(c[(c[h>>2]|0)+40>>2]|0,h|0)|0;x=o;o=0;if(x&1){R=24;break b}}else c[q>>2]=r+4;if((g|0)<=1)break;else{r=f;h=t}}}}if((c[n>>2]|0)==(c[m>>2]|0)){R=242;break b}break}default:p=q}while(0);h:do if((R|0)==44)while(1){R=0;f=c[b>>2]|0;do if(f){g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0)){o=0;f=qa(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=21;break b}}else f=c[g>>2]|0;if((f|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(h){f=c[h+12>>2]|0;if((f|0)==(c[h+16>>2]|0)){o=0;f=qa(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){R=21;break b}}else f=c[f>>2]|0;if((f|0)!=-1)if(g^(p|0)==0){r=p;h=p;break}else{p=q;break h}else{c[e>>2]=0;p=0;R=57;break}}else R=57;while(0);if((R|0)==57){R=0;if(g){p=q;break h}else{r=p;h=0}}p=c[b>>2]|0;f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;x=o;o=0;if(x&1){R=21;break b}}else p=c[f>>2]|0;o=0;p=ya(c[(c[l>>2]|0)+12>>2]|0,l|0,8192,p|0)|0;x=o;o=0;if(x&1){R=21;break b}if(!p){p=q;break h}p=c[b>>2]|0;f=p+12|0;g=c[f>>2]|0;if((g|0)==(c[p+16>>2]|0)){o=0;p=qa(c[(c[p>>2]|0)+40>>2]|0,p|0)|0;R=o;o=0;if(R&1){R=21;break b}}else{c[f>>2]=g+4;p=c[g>>2]|0}o=0;ma(223,W|0,p|0);R=o;o=0;if(R&1){R=21;break b}else{p=r;R=44}}while(0);y=y+1|0;if(y>>>0>=4){t=p;R=244;break}else q=p}i:switch(R|0){case 21:{f=cc()|0;break a}case 22:{f=cc()|0;break a}case 23:{f=cc()|0;break a}case 24:{f=cc()|0;break a}case 25:{f=cc()|0;break a}case 26:{f=cc()|0;break a}case 42:{c[j>>2]=c[j>>2]|4;f=0;break}case 107:{c[j>>2]=c[j>>2]|4;f=0;break}case 148:{c[j>>2]=c[j>>2]|4;f=0;break}case 206:{c[j>>2]=c[j>>2]|4;f=0;break}case 231:{c[j>>2]=c[j>>2]|4;f=0;break}case 242:{c[j>>2]=c[j>>2]|4;f=0;break}case 244:{j:do if(s){q=s+4|0;r=s+8|0;h=1;k:while(1){p=a[s>>0]|0;if(!(p&1))p=(p&255)>>>1;else p=c[q>>2]|0;if(h>>>0>=p>>>0)break j;p=c[b>>2]|0;do if(p){f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;n=o;o=0;if(n&1){R=20;break k}}else p=c[f>>2]|0;if((p|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);p=c[e>>2]|0;do if(p){f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;n=o;o=0;if(n&1){R=20;break k}}else p=c[f>>2]|0;if((p|0)!=-1)if(g)break;else{R=271;break k}else{c[e>>2]=0;R=263;break}}else R=263;while(0);if((R|0)==263?(R=0,g):0){R=271;break}p=c[b>>2]|0;f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;n=o;o=0;if(n&1){R=20;break}}else p=c[f>>2]|0;if(!(a[s>>0]&1))f=q;else f=c[r>>2]|0;if((p|0)!=(c[f+(h<<2)>>2]|0)){R=271;break}p=h+1|0;f=c[b>>2]|0;g=f+12|0;h=c[g>>2]|0;if((h|0)==(c[f+16>>2]|0)){o=0;qa(c[(c[f>>2]|0)+40>>2]|0,f|0)|0;n=o;o=0;if(n&1){R=20;break}else{h=p;continue}}else{c[g>>2]=h+4;h=p;continue}}if((R|0)==20){f=cc()|0;break a}else if((R|0)==271){c[j>>2]=c[j>>2]|4;f=0;break i}}while(0);p=c[_>>2]|0;if((p|0)!=(t|0)?(c[S>>2]=0,oH(T,p,t,S),(c[S>>2]|0)!=0):0){c[j>>2]=c[j>>2]|4;f=0}else f=1;break}}ZC(W);ZC(U);ZC(V);ZC(X);IC(T);p=c[_>>2]|0;c[_>>2]=0;if((p|0)!=0?(o=0,ka(c[Z>>2]|0,p|0),_=o,o=0,_&1):0){_=cc(0)|0;oq(_)}i=Y;return f|0}while(0);ZC(W);ZC(U);ZC(V);ZC(X);IC(T);p=c[_>>2]|0;c[_>>2]=0;if((p|0)!=0?(o=0,ka(c[Z>>2]|0,p|0),_=o,o=0,_&1):0){_=cc(0)|0;oq(_)}bc(f|0);return 0}function tH(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;w=i;i=i+432|0;k=w+424|0;b=w+24|0;y=w+16|0;s=w+8|0;p=w+4|0;q=w+428|0;l=w;c[y>>2]=b;A=y+4|0;c[A>>2]=345;m=b+400|0;o=0;v=qa(192,g|0)|0;n=o;o=0;if(!(n&1)){c[p>>2]=v;o=0;n=Wa(115,p|0,40896)|0;b=o;o=0;a:do if(!(b&1)?(a[q>>0]=0,t=c[e>>2]|0,c[l>>2]=t,r=c[g+4>>2]|0,u=t,o=0,c[k>>2]=c[l>>2],r=ua(43,d|0,k|0,f|0,p|0,r|0,h|0,q|0,n|0,y|0,s|0,m|0)|0,g=o,o=0,!(g&1)):0){if(r){if(!(a[j>>0]&1))a[j>>0]=0;else c[c[j+8>>2]>>2]=0;c[j+4>>2]=0;if(a[q>>0]|0){o=0;b=Wa(c[(c[n>>2]|0)+44>>2]|0,n|0,45)|0;g=o;o=0;if(g&1)break;o=0;ma(223,j|0,b|0);g=o;o=0;if(g&1)break}o=0;l=Wa(c[(c[n>>2]|0)+44>>2]|0,n|0,48)|0;g=o;o=0;if(g&1)break;b=c[y>>2]|0;m=c[s>>2]|0;k=m+-4|0;b:do if(b>>>0<k>>>0)do{if((c[b>>2]|0)!=(l|0))break b;b=b+4|0}while(b>>>0<k>>>0);while(0);o=0;ya(123,j|0,b|0,m|0)|0;j=o;o=0;if(j&1)break}b=c[d>>2]|0;do if(b){k=c[b+12>>2]|0;if((k|0)==(c[b+16>>2]|0)){o=0;b=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;j=o;o=0;if(j&1)break a}else b=c[k>>2]|0;if((b|0)==-1){c[d>>2]=0;k=1;break}else{k=(c[d>>2]|0)==0;break}}else k=1;while(0);do if(t){b=c[u+12>>2]|0;if((b|0)==(c[u+16>>2]|0)){o=0;b=qa(c[(c[t>>2]|0)+36>>2]|0,u|0)|0;u=o;o=0;if(u&1)break a}else b=c[b>>2]|0;if((b|0)!=-1)if(k)break;else{z=32;break}else{c[e>>2]=0;z=30;break}}else z=30;while(0);if((z|0)==30?k:0)z=32;if((z|0)==32)c[h>>2]=c[h>>2]|2;k=c[d>>2]|0;EL(v)|0;b=c[y>>2]|0;c[y>>2]=0;if((b|0)!=0?(o=0,ka(c[A>>2]|0,b|0),A=o,o=0,A&1):0){A=cc(0)|0;oq(A)}i=w;return k|0}while(0);k=cc()|0;EL(v)|0;b=c[y>>2]|0;c[y>>2]=0;if(!b)x=k;else z=38}else{k=cc()|0;c[y>>2]=0;z=38}if((z|0)==38){o=0;ka(c[A>>2]|0,b|0);A=o;o=0;if(A&1){A=cc(0)|0;oq(A)}else x=k}bc(x|0);return 0}function uH(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;z=i;i=i+112|0;n=z+100|0;p=z+88|0;q=z+76|0;r=z+64|0;s=z+52|0;t=z+48|0;u=z+36|0;v=z+24|0;w=z+12|0;x=z;do if(b){b=cI(d,40640)|0;$c[c[(c[b>>2]|0)+44>>2]&511](n,b);x=c[n>>2]|0;a[e>>0]=x;a[e+1>>0]=x>>8;a[e+2>>0]=x>>16;a[e+3>>0]=x>>24;$c[c[(c[b>>2]|0)+32>>2]&511](p,b);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;o=0;ma(224,l|0,0);e=o;o=0;if(e&1){e=cc(0)|0;oq(e)};c[l>>2]=c[p>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;ZC(p);$c[c[(c[b>>2]|0)+28>>2]&511](q,b);if(!(a[k>>0]&1))a[k>>0]=0;else c[c[k+8>>2]>>2]=0;c[k+4>>2]=0;o=0;ma(224,k|0,0);e=o;o=0;if(e&1){e=cc(0)|0;oq(e)};c[k>>2]=c[q>>2];c[k+4>>2]=c[q+4>>2];c[k+8>>2]=c[q+8>>2];c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;ZC(q);c[f>>2]=bd[c[(c[b>>2]|0)+12>>2]&255](b)|0;c[g>>2]=bd[c[(c[b>>2]|0)+16>>2]&255](b)|0;$c[c[(c[b>>2]|0)+20>>2]&511](r,b);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}o=0;ma(114,h|0,0);g=o;o=0;if(g&1){g=cc(0)|0;oq(g)};c[h>>2]=c[r>>2];c[h+4>>2]=c[r+4>>2];c[h+8>>2]=c[r+8>>2];c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;IC(r);$c[c[(c[b>>2]|0)+24>>2]&511](s,b);if(!(a[j>>0]&1))a[j>>0]=0;else c[c[j+8>>2]>>2]=0;c[j+4>>2]=0;o=0;ma(224,j|0,0);g=o;o=0;if(g&1){g=cc(0)|0;oq(g)}else{c[j>>2]=c[s>>2];c[j+4>>2]=c[s+4>>2];c[j+8>>2]=c[s+8>>2];c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;ZC(s);y=bd[c[(c[b>>2]|0)+36>>2]&255](b)|0;break}}else{b=cI(d,40576)|0;$c[c[(c[b>>2]|0)+44>>2]&511](t,b);t=c[t>>2]|0;a[e>>0]=t;a[e+1>>0]=t>>8;a[e+2>>0]=t>>16;a[e+3>>0]=t>>24;$c[c[(c[b>>2]|0)+32>>2]&511](u,b);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;o=0;ma(224,l|0,0);e=o;o=0;if(e&1){e=cc(0)|0;oq(e)};c[l>>2]=c[u>>2];c[l+4>>2]=c[u+4>>2];c[l+8>>2]=c[u+8>>2];c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;ZC(u);$c[c[(c[b>>2]|0)+28>>2]&511](v,b);if(!(a[k>>0]&1))a[k>>0]=0;else c[c[k+8>>2]>>2]=0;c[k+4>>2]=0;o=0;ma(224,k|0,0);e=o;o=0;if(e&1){e=cc(0)|0;oq(e)};c[k>>2]=c[v>>2];c[k+4>>2]=c[v+4>>2];c[k+8>>2]=c[v+8>>2];c[v>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;ZC(v);c[f>>2]=bd[c[(c[b>>2]|0)+12>>2]&255](b)|0;c[g>>2]=bd[c[(c[b>>2]|0)+16>>2]&255](b)|0;$c[c[(c[b>>2]|0)+20>>2]&511](w,b);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}o=0;ma(114,h|0,0);g=o;o=0;if(g&1){g=cc(0)|0;oq(g)};c[h>>2]=c[w>>2];c[h+4>>2]=c[w+4>>2];c[h+8>>2]=c[w+8>>2];c[w>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;IC(w);$c[c[(c[b>>2]|0)+24>>2]&511](x,b);if(!(a[j>>0]&1))a[j>>0]=0;else c[c[j+8>>2]>>2]=0;c[j+4>>2]=0;o=0;ma(224,j|0,0);g=o;o=0;if(g&1){g=cc(0)|0;oq(g)}else{c[j>>2]=c[x>>2];c[j+4>>2]=c[x+4>>2];c[j+8>>2]=c[x+8>>2];c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;ZC(x);y=bd[c[(c[b>>2]|0)+36>>2]&255](b)|0;break}}while(0);c[m>>2]=y;i=z;return}function vH(a){a=a|0;return}function wH(a){a=a|0;Uz(a);return}function xH(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=+j;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;D=i;i=i+384|0;v=D+8|0;k=D;m=D+284|0;n=D+72|0;l=D+184|0;F=D+68|0;A=D+80|0;x=D+77|0;B=D+76|0;G=D+56|0;I=D+44|0;H=D+32|0;p=D+28|0;u=D+84|0;z=D+24|0;y=D+20|0;w=D+16|0;c[n>>2]=m;h[v>>3]=j;m=SB(m,100,61377,v)|0;do if(m>>>0>99){o=0;b=gb(45)|0;C=o;o=0;if(!(C&1)?(o=0,h[k>>3]=j,s=kb(65,n|0,b|0,61377,k|0)|0,C=o,o=0,!(C&1)):0){b=c[n>>2]|0;if(!b){o=0;ob(46);C=o;o=0;if(C&1){b=0;k=0;C=7;break}b=c[n>>2]|0}l=yC(s)|0;k=l;if(!l){o=0;ob(46);C=o;o=0;if(C&1)C=7;else{t=0;C=10}}else{t=l;C=10}}else{b=0;k=0;C=7}}else{k=0;b=0;t=l;s=m;C=10}while(0);if((C|0)==10){o=0;l=qa(192,f|0)|0;r=o;o=0;if(r&1)C=7;else{c[F>>2]=l;o=0;r=Wa(115,F|0,40904)|0;q=o;o=0;if(!(q&1)?(q=c[n>>2]|0,o=0,kb(c[(c[r>>2]|0)+32>>2]|0,r|0,q|0,q+s|0,t|0)|0,q=o,o=0,!(q&1)):0){if(!s)q=0;else q=(a[c[n>>2]>>0]|0)==45;c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;c[I>>2]=0;c[I+4>>2]=0;c[I+8>>2]=0;c[H>>2]=0;c[H+4>>2]=0;c[H+8>>2]=0;o=0;Ua(44,e|0,q|0,F|0,A|0,x|0,B|0,G|0,I|0,H|0,p|0);e=o;o=0;if(!(e&1)){p=c[p>>2]|0;if((s|0)>(p|0)){e=a[H>>0]|0;m=a[I>>0]|0;m=(s-p<<1|1)+p+((e&1)==0?(e&255)>>>1:c[H+4>>2]|0)+((m&1)==0?(m&255)>>>1:c[I+4>>2]|0)|0}else{e=a[H>>0]|0;m=a[I>>0]|0;m=p+2+((e&1)==0?(e&255)>>>1:c[H+4>>2]|0)+((m&1)==0?(m&255)>>>1:c[I+4>>2]|0)|0}if(m>>>0>100){m=yC(m)|0;n=m;if(!m){o=0;ob(46);u=o;o=0;if(!(u&1)){m=0;C=26}}else C=26}else{n=0;m=u;C=26}if((C|0)==26){o=0;Aa(42,m|0,z|0,y|0,c[f+4>>2]|0,t|0,t+s|0,r|0,q|0,A|0,a[x>>0]|0,a[B>>0]|0,G|0,I|0,H|0,p|0);B=o;o=0;if(!(B&1)?(c[w>>2]=c[d>>2],d=c[z>>2]|0,E=c[y>>2]|0,o=0,c[v>>2]=c[w>>2],E=oa(83,v|0,m|0,d|0,E|0,f|0,g|0)|0,d=o,o=0,!(d&1)):0){if(n){zC(n);l=c[F>>2]|0}IC(H);IC(I);IC(G);EL(l)|0;if(k)zC(k);if(b)zC(b);i=D;return E|0}}m=cc()|0;if(n){zC(n);l=c[F>>2]|0}}else m=cc()|0;IC(H);IC(I);IC(G)}else m=cc()|0;EL(l)|0}}if((C|0)==7)m=cc()|0;if(k)zC(k);if(b)zC(b);bc(m|0);return 0}function yH(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;D=i;i=i+112|0;q=D+108|0;r=D+96|0;u=D+92|0;v=D+80|0;w=D+68|0;x=D+56|0;y=D+52|0;z=D+40|0;A=D+36|0;B=D+24|0;s=D+12|0;t=D;do if(b){b=cI(e,40512)|0;e=c[b>>2]|0;do if(d){$c[c[e+44>>2]&511](q,b);d=c[q>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;$c[c[(c[b>>2]|0)+32>>2]&511](r,b);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}o=0;ma(114,l|0,0);f=o;o=0;if(f&1){l=cc(0)|0;oq(l)}else{c[l>>2]=c[r>>2];c[l+4>>2]=c[r+4>>2];c[l+8>>2]=c[r+8>>2];c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;IC(r);p=b;break}}else{$c[c[e+40>>2]&511](u,b);d=c[u>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;$c[c[(c[b>>2]|0)+28>>2]&511](v,b);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}o=0;ma(114,l|0,0);f=o;o=0;if(f&1){l=cc(0)|0;oq(l)}else{c[l>>2]=c[v>>2];c[l+4>>2]=c[v+4>>2];c[l+8>>2]=c[v+8>>2];c[v>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;IC(v);p=b;break}}while(0);a[g>>0]=bd[c[(c[b>>2]|0)+12>>2]&255](b)|0;a[h>>0]=bd[c[(c[b>>2]|0)+16>>2]&255](b)|0;$c[c[(c[p>>2]|0)+20>>2]&511](w,b);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}o=0;ma(114,j|0,0);h=o;o=0;if(h&1){h=cc(0)|0;oq(h)};c[j>>2]=c[w>>2];c[j+4>>2]=c[w+4>>2];c[j+8>>2]=c[w+8>>2];c[w>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;IC(w);$c[c[(c[p>>2]|0)+24>>2]&511](x,b);if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}o=0;ma(114,k|0,0);h=o;o=0;if(h&1){h=cc(0)|0;oq(h)}else{c[k>>2]=c[x>>2];c[k+4>>2]=c[x+4>>2];c[k+8>>2]=c[x+8>>2];c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;IC(x);C=bd[c[(c[b>>2]|0)+36>>2]&255](b)|0;break}}else{b=cI(e,40448)|0;e=c[b>>2]|0;do if(d){$c[c[e+44>>2]&511](y,b);d=c[y>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;$c[c[(c[b>>2]|0)+32>>2]&511](z,b);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}o=0;ma(114,l|0,0);f=o;o=0;if(f&1){l=cc(0)|0;oq(l)}else{c[l>>2]=c[z>>2];c[l+4>>2]=c[z+4>>2];c[l+8>>2]=c[z+8>>2];c[z>>2]=0;c[z+4>>2]=0;c[z+8>>2]=0;IC(z);n=b;break}}else{$c[c[e+40>>2]&511](A,b);d=c[A>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;$c[c[(c[b>>2]|0)+28>>2]&511](B,b);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}o=0;ma(114,l|0,0);f=o;o=0;if(f&1){l=cc(0)|0;oq(l)}else{c[l>>2]=c[B>>2];c[l+4>>2]=c[B+4>>2];c[l+8>>2]=c[B+8>>2];c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;IC(B);n=b;break}}while(0);a[g>>0]=bd[c[(c[b>>2]|0)+12>>2]&255](b)|0;a[h>>0]=bd[c[(c[b>>2]|0)+16>>2]&255](b)|0;$c[c[(c[n>>2]|0)+20>>2]&511](s,b);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}o=0;ma(114,j|0,0);h=o;o=0;if(h&1){h=cc(0)|0;oq(h)};c[j>>2]=c[s>>2];c[j+4>>2]=c[s+4>>2];c[j+8>>2]=c[s+8>>2];c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;IC(s);$c[c[(c[n>>2]|0)+24>>2]&511](t,b);if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}o=0;ma(114,k|0,0);h=o;o=0;if(h&1){h=cc(0)|0;oq(h)}else{c[k>>2]=c[t>>2];c[k+4>>2]=c[t+4>>2];c[k+8>>2]=c[t+8>>2];c[t>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;IC(t);C=bd[c[(c[b>>2]|0)+36>>2]&255](b)|0;break}}while(0);c[m>>2]=C;i=D;return}function zH(d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;var s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0;c[f>>2]=d;N=q+4|0;O=q+8|0;P=q+1|0;H=p+4|0;I=(g&512|0)==0;J=p+8|0;K=p+1|0;L=j+8|0;M=(r|0)>0;A=o+4|0;B=o+8|0;C=o+1|0;D=r+1|0;F=-2-r-((r|0)<0?~r:-1)|0;G=(r|0)>0;z=0;do{switch(a[l+z>>0]|0){case 0:{c[e>>2]=c[f>>2];break}case 1:{c[e>>2]=c[f>>2];x=rd[c[(c[j>>2]|0)+28>>2]&127](j,32)|0;y=c[f>>2]|0;c[f>>2]=y+1;a[y>>0]=x;break}case 3:{y=a[q>>0]|0;s=(y&1)==0;if((s?(y&255)>>>1:c[N>>2]|0)|0){x=a[(s?P:c[O>>2]|0)>>0]|0;y=c[f>>2]|0;c[f>>2]=y+1;a[y>>0]=x}break}case 2:{u=a[p>>0]|0;s=(u&1)==0;u=s?(u&255)>>>1:c[H>>2]|0;if(!(I|(u|0)==0)){t=s?K:c[J>>2]|0;v=t+u|0;s=c[f>>2]|0;if(u)do{a[s>>0]=a[t>>0]|0;t=t+1|0;s=s+1|0}while((t|0)!=(v|0));c[f>>2]=s}break}case 4:{s=c[f>>2]|0;h=k?h+1|0:h;w=h;v=c[L>>2]|0;a:do if(h>>>0<i>>>0){t=h;do{u=a[t>>0]|0;if(u<<24>>24<=-1)break a;if(!(b[v+(u<<24>>24<<1)>>1]&2048))break a;t=t+1|0}while(t>>>0<i>>>0)}else t=h;while(0);u=t;if(M){x=-2-u-~(u>>>0>w>>>0?w:u)|0;x=F>>>0>x>>>0?F:x;if(t>>>0>h>>>0&G){u=t;w=r;while(1){u=u+-1|0;y=a[u>>0]|0;v=c[f>>2]|0;c[f>>2]=v+1;a[v>>0]=y;v=(w|0)>1;if(!(u>>>0>h>>>0&v))break;else w=w+-1|0}}else v=G;y=D+x|0;u=t+(x+1)|0;if(v)w=rd[c[(c[j>>2]|0)+28>>2]&127](j,48)|0;else w=0;t=c[f>>2]|0;c[f>>2]=t+1;if((y|0)>0){v=y;while(1){a[t>>0]=w;t=c[f>>2]|0;c[f>>2]=t+1;if((v|0)>1)v=v+-1|0;else break}}a[t>>0]=m}else u=t;if((u|0)!=(h|0)){y=a[o>>0]|0;t=(y&1)==0;if(!((t?(y&255)>>>1:c[A>>2]|0)|0))t=-1;else t=a[(t?C:c[B>>2]|0)>>0]|0;if((u|0)!=(h|0)){v=0;w=0;while(1){if((w|0)==(t|0)){y=c[f>>2]|0;c[f>>2]=y+1;a[y>>0]=n;v=v+1|0;y=a[o>>0]|0;t=(y&1)==0;if(v>>>0<(t?(y&255)>>>1:c[A>>2]|0)>>>0){t=a[(t?C:c[B>>2]|0)+v>>0]|0;t=t<<24>>24==127?-1:t<<24>>24;w=0}else{t=w;w=0}}u=u+-1|0;x=a[u>>0]|0;y=c[f>>2]|0;c[f>>2]=y+1;a[y>>0]=x;if((u|0)==(h|0))break;else w=w+1|0}}}else{x=rd[c[(c[j>>2]|0)+28>>2]&127](j,48)|0;y=c[f>>2]|0;c[f>>2]=y+1;a[y>>0]=x}t=c[f>>2]|0;if((s|0)!=(t|0)?(E=t+-1|0,s>>>0<E>>>0):0){t=E;do{y=a[s>>0]|0;a[s>>0]=a[t>>0]|0;a[t>>0]=y;s=s+1|0;t=t+-1|0}while(s>>>0<t>>>0)}break}default:{}}z=z+1|0}while((z|0)!=4);t=a[q>>0]|0;h=(t&1)==0;t=h?(t&255)>>>1:c[N>>2]|0;if(t>>>0>1){s=h?P:c[O>>2]|0;u=s+t|0;h=c[f>>2]|0;if((t|0)!=1){s=s+1|0;do{a[h>>0]=a[s>>0]|0;h=h+1|0;s=s+1|0}while((s|0)!=(u|0))}c[f>>2]=h}switch(g&176|0){case 32:{c[e>>2]=c[f>>2];break}case 16:break;default:c[e>>2]=d}return}function AH(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;z=i;i=i+176|0;r=z+56|0;B=z+52|0;x=z+64|0;u=z+61|0;y=z+60|0;C=z+40|0;E=z+28|0;D=z+16|0;m=z+12|0;q=z+68|0;w=z+8|0;v=z+4|0;s=z;b=lD(f)|0;c[B>>2]=b;o=0;t=Wa(115,B|0,40904)|0;p=o;o=0;do if(p&1)F=13;else{n=a[h>>0]|0;j=(n&1)==0;p=h+4|0;if(!((j?(n&255)>>>1:c[p>>2]|0)|0))n=0;else{j=a[(j?h+1|0:c[h+8>>2]|0)>>0]|0;o=0;k=Wa(c[(c[t>>2]|0)+28>>2]|0,t|0,45)|0;n=o;o=0;if(n&1){F=13;break}n=j<<24>>24==k<<24>>24}c[C>>2]=0;c[C+4>>2]=0;c[C+8>>2]=0;c[E>>2]=0;c[E+4>>2]=0;c[E+8>>2]=0;c[D>>2]=0;c[D+4>>2]=0;c[D+8>>2]=0;o=0;Ua(44,e|0,n|0,B|0,x|0,u|0,y|0,C|0,E|0,D|0,m|0);l=o;o=0;if(!(l&1)){l=a[h>>0]|0;e=c[p>>2]|0;j=(l&1)==0?(l&255)>>>1:e;m=c[m>>2]|0;if((j|0)>(m|0)){G=a[D>>0]|0;k=a[E>>0]|0;j=(j-m<<1|1)+m+((G&1)==0?(G&255)>>>1:c[D+4>>2]|0)+((k&1)==0?(k&255)>>>1:c[E+4>>2]|0)|0}else{G=a[D>>0]|0;j=a[E>>0]|0;j=m+2+((G&1)==0?(G&255)>>>1:c[D+4>>2]|0)+((j&1)==0?(j&255)>>>1:c[E+4>>2]|0)|0}if(j>>>0>100){j=yC(j)|0;k=j;if(!j){o=0;ob(46);G=o;o=0;if(!(G&1)){l=a[h>>0]|0;e=c[p>>2]|0;j=0;F=17}}else F=17}else{k=0;j=q;F=17}if((F|0)==17){G=(l&1)==0;h=G?h+1|0:c[h+8>>2]|0;o=0;Aa(42,j|0,w|0,v|0,c[f+4>>2]|0,h|0,h+(G?(l&255)>>>1:e)|0,t|0,n|0,x|0,a[u>>0]|0,a[y>>0]|0,C|0,E|0,D|0,m|0);G=o;o=0;if(!(G&1)?(c[s>>2]=c[d>>2],G=c[w>>2]|0,A=c[v>>2]|0,o=0,c[r>>2]=c[s>>2],A=oa(83,r|0,j|0,G|0,A|0,f|0,g|0)|0,G=o,o=0,!(G&1)):0){if(k){zC(k);b=c[B>>2]|0}IC(D);IC(E);IC(C);EL(b)|0;i=z;return A|0}}j=cc()|0;if(k){zC(k);b=c[B>>2]|0}}else j=cc()|0;IC(D);IC(E);IC(C)}while(0);if((F|0)==13)j=cc()|0;EL(b)|0;bc(j|0);return 0}function BH(a){a=a|0;return}function CH(a){a=a|0;Uz(a);return}function DH(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=+j;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;D=i;i=i+992|0;v=D+8|0;k=D;m=D+888|0;n=D+880|0;l=D+480|0;F=D+76|0;A=D+884|0;x=D+72|0;B=D+68|0;G=D+56|0;I=D+44|0;H=D+32|0;p=D+28|0;u=D+80|0;z=D+24|0;y=D+20|0;w=D+16|0;c[n>>2]=m;h[v>>3]=j;m=SB(m,100,61377,v)|0;do if(m>>>0>99){o=0;b=gb(45)|0;C=o;o=0;if(!(C&1)?(o=0,h[k>>3]=j,s=kb(65,n|0,b|0,61377,k|0)|0,C=o,o=0,!(C&1)):0){b=c[n>>2]|0;if(!b){o=0;ob(46);C=o;o=0;if(C&1){b=0;k=0;C=7;break}b=c[n>>2]|0}l=yC(s<<2)|0;k=l;if(!l){o=0;ob(46);C=o;o=0;if(C&1)C=7;else{t=0;C=10}}else{t=l;C=10}}else{b=0;k=0;C=7}}else{k=0;b=0;t=l;s=m;C=10}while(0);if((C|0)==10){o=0;l=qa(192,f|0)|0;r=o;o=0;if(r&1)C=7;else{c[F>>2]=l;o=0;r=Wa(115,F|0,40896)|0;q=o;o=0;if(!(q&1)?(q=c[n>>2]|0,o=0,kb(c[(c[r>>2]|0)+48>>2]|0,r|0,q|0,q+s|0,t|0)|0,q=o,o=0,!(q&1)):0){if(!s)q=0;else q=(a[c[n>>2]>>0]|0)==45;c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;c[I>>2]=0;c[I+4>>2]=0;c[I+8>>2]=0;c[H>>2]=0;c[H+4>>2]=0;c[H+8>>2]=0;o=0;Ua(45,e|0,q|0,F|0,A|0,x|0,B|0,G|0,I|0,H|0,p|0);e=o;o=0;if(!(e&1)){p=c[p>>2]|0;if((s|0)>(p|0)){e=a[H>>0]|0;m=a[I>>0]|0;m=(s-p<<1|1)+p+((e&1)==0?(e&255)>>>1:c[H+4>>2]|0)+((m&1)==0?(m&255)>>>1:c[I+4>>2]|0)|0}else{e=a[H>>0]|0;m=a[I>>0]|0;m=p+2+((e&1)==0?(e&255)>>>1:c[H+4>>2]|0)+((m&1)==0?(m&255)>>>1:c[I+4>>2]|0)|0}if(m>>>0>100){m=yC(m<<2)|0;n=m;if(!m){o=0;ob(46);u=o;o=0;if(!(u&1)){m=0;C=26}}else C=26}else{n=0;m=u;C=26}if((C|0)==26){o=0;Aa(43,m|0,z|0,y|0,c[f+4>>2]|0,t|0,t+(s<<2)|0,r|0,q|0,A|0,c[x>>2]|0,c[B>>2]|0,G|0,I|0,H|0,p|0);B=o;o=0;if(!(B&1)?(c[w>>2]=c[d>>2],d=c[z>>2]|0,E=c[y>>2]|0,o=0,c[v>>2]=c[w>>2],E=oa(84,v|0,m|0,d|0,E|0,f|0,g|0)|0,d=o,o=0,!(d&1)):0){if(n){zC(n);l=c[F>>2]|0}ZC(H);ZC(I);IC(G);EL(l)|0;if(k)zC(k);if(b)zC(b);i=D;return E|0}}m=cc()|0;if(n){zC(n);l=c[F>>2]|0}}else m=cc()|0;ZC(H);ZC(I);IC(G)}else m=cc()|0;EL(l)|0}}if((C|0)==7)m=cc()|0;if(k)zC(k);if(b)zC(b);bc(m|0);return 0}function EH(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;B=i;i=i+112|0;n=B+108|0;p=B+96|0;s=B+92|0;t=B+80|0;u=B+68|0;v=B+56|0;w=B+52|0;x=B+40|0;y=B+36|0;z=B+24|0;q=B+12|0;r=B;do if(b){b=cI(e,40640)|0;e=c[b>>2]|0;do if(d){$c[c[e+44>>2]&511](n,b);d=c[n>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;$c[c[(c[b>>2]|0)+32>>2]&511](p,b);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;o=0;ma(224,l|0,0);f=o;o=0;if(f&1){l=cc(0)|0;oq(l)}else{c[l>>2]=c[p>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;ZC(p);break}}else{$c[c[e+40>>2]&511](s,b);d=c[s>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;$c[c[(c[b>>2]|0)+28>>2]&511](t,b);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;o=0;ma(224,l|0,0);f=o;o=0;if(f&1){l=cc(0)|0;oq(l)}else{c[l>>2]=c[t>>2];c[l+4>>2]=c[t+4>>2];c[l+8>>2]=c[t+8>>2];c[t>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;ZC(t);break}}while(0);c[g>>2]=bd[c[(c[b>>2]|0)+12>>2]&255](b)|0;c[h>>2]=bd[c[(c[b>>2]|0)+16>>2]&255](b)|0;$c[c[(c[b>>2]|0)+20>>2]&511](u,b);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}o=0;ma(114,j|0,0);h=o;o=0;if(h&1){h=cc(0)|0;oq(h)};c[j>>2]=c[u>>2];c[j+4>>2]=c[u+4>>2];c[j+8>>2]=c[u+8>>2];c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;IC(u);$c[c[(c[b>>2]|0)+24>>2]&511](v,b);if(!(a[k>>0]&1))a[k>>0]=0;else c[c[k+8>>2]>>2]=0;c[k+4>>2]=0;o=0;ma(224,k|0,0);h=o;o=0;if(h&1){h=cc(0)|0;oq(h)}else{c[k>>2]=c[v>>2];c[k+4>>2]=c[v+4>>2];c[k+8>>2]=c[v+8>>2];c[v>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;ZC(v);A=bd[c[(c[b>>2]|0)+36>>2]&255](b)|0;break}}else{b=cI(e,40576)|0;e=c[b>>2]|0;do if(d){$c[c[e+44>>2]&511](w,b);d=c[w>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;$c[c[(c[b>>2]|0)+32>>2]&511](x,b);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;o=0;ma(224,l|0,0);f=o;o=0;if(f&1){l=cc(0)|0;oq(l)}else{c[l>>2]=c[x>>2];c[l+4>>2]=c[x+4>>2];c[l+8>>2]=c[x+8>>2];c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;ZC(x);break}}else{$c[c[e+40>>2]&511](y,b);d=c[y>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;$c[c[(c[b>>2]|0)+28>>2]&511](z,b);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;o=0;ma(224,l|0,0);f=o;o=0;if(f&1){l=cc(0)|0;oq(l)}else{c[l>>2]=c[z>>2];c[l+4>>2]=c[z+4>>2];c[l+8>>2]=c[z+8>>2];c[z>>2]=0;c[z+4>>2]=0;c[z+8>>2]=0;ZC(z);break}}while(0);c[g>>2]=bd[c[(c[b>>2]|0)+12>>2]&255](b)|0;c[h>>2]=bd[c[(c[b>>2]|0)+16>>2]&255](b)|0;$c[c[(c[b>>2]|0)+20>>2]&511](q,b);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}o=0;ma(114,j|0,0);h=o;o=0;if(h&1){h=cc(0)|0;oq(h)};c[j>>2]=c[q>>2];c[j+4>>2]=c[q+4>>2];c[j+8>>2]=c[q+8>>2];c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;IC(q);$c[c[(c[b>>2]|0)+24>>2]&511](r,b);if(!(a[k>>0]&1))a[k>>0]=0;else c[c[k+8>>2]>>2]=0;c[k+4>>2]=0;o=0;ma(224,k|0,0);h=o;o=0;if(h&1){h=cc(0)|0;oq(h)}else{c[k>>2]=c[r>>2];c[k+4>>2]=c[r+4>>2];c[k+8>>2]=c[r+8>>2];c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;ZC(r);A=bd[c[(c[b>>2]|0)+36>>2]&255](b)|0;break}}while(0);c[m>>2]=A;i=B;return}function FH(b,d,e,f,g,h,i,j,k,l,m,n,o,p,q){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;var r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0;c[e>>2]=b;J=p+4|0;K=p+8|0;C=o+4|0;D=(f&512|0)==0;E=o+8|0;F=(q|0)>0;G=n+4|0;H=n+8|0;I=n+1|0;A=(q|0)>0;z=0;do{switch(a[k+z>>0]|0){case 0:{c[d>>2]=c[e>>2];break}case 1:{c[d>>2]=c[e>>2];x=rd[c[(c[i>>2]|0)+44>>2]&127](i,32)|0;y=c[e>>2]|0;c[e>>2]=y+4;c[y>>2]=x;break}case 3:{y=a[p>>0]|0;r=(y&1)==0;if((r?(y&255)>>>1:c[J>>2]|0)|0){x=c[(r?J:c[K>>2]|0)>>2]|0;y=c[e>>2]|0;c[e>>2]=y+4;c[y>>2]=x}break}case 2:{v=a[o>>0]|0;r=(v&1)==0;v=r?(v&255)>>>1:c[C>>2]|0;if(!(D|(v|0)==0)){r=r?C:c[E>>2]|0;t=r+(v<<2)|0;u=c[e>>2]|0;if(v){s=u;while(1){c[s>>2]=c[r>>2];r=r+4|0;if((r|0)==(t|0))break;else s=s+4|0}}c[e>>2]=u+(v<<2)}break}case 4:{r=c[e>>2]|0;g=j?g+4|0:g;a:do if(g>>>0<h>>>0){s=g;do{if(!(fd[c[(c[i>>2]|0)+12>>2]&127](i,2048,c[s>>2]|0)|0))break a;s=s+4|0}while(s>>>0<h>>>0)}else s=g;while(0);if(F){if(s>>>0>g>>>0&A){v=c[e>>2]|0;u=q;while(1){s=s+-4|0;t=v+4|0;c[v>>2]=c[s>>2];w=u+-1|0;u=(u|0)>1;if(s>>>0>g>>>0&u){v=t;u=w}else{v=w;break}}c[e>>2]=t;t=v}else{u=A;t=q}if(u)w=rd[c[(c[i>>2]|0)+44>>2]&127](i,48)|0;else w=0;x=c[e>>2]|0;u=t+((t|0)<0?~t:-1)|0;if((t|0)>0){v=x;while(1){c[v>>2]=w;if((t|0)>1){v=v+4|0;t=t+-1|0}else break}}c[e>>2]=x+(u+2<<2);c[x+(u+1<<2)>>2]=l}if((s|0)==(g|0)){x=rd[c[(c[i>>2]|0)+44>>2]&127](i,48)|0;y=c[e>>2]|0;s=y+4|0;c[e>>2]=s;c[y>>2]=x}else{x=a[n>>0]|0;t=(x&1)==0;y=c[G>>2]|0;if(!((t?(x&255)>>>1:y)|0))t=-1;else t=a[(t?I:c[H>>2]|0)>>0]|0;if((s|0)!=(g|0)){w=0;x=0;while(1){u=c[e>>2]|0;if((x|0)==(t|0)){v=u+4|0;c[e>>2]=v;c[u>>2]=m;w=w+1|0;u=a[n>>0]|0;t=(u&1)==0;if(w>>>0<(t?(u&255)>>>1:y)>>>0){t=a[(t?I:c[H>>2]|0)+w>>0]|0;u=v;t=t<<24>>24==127?-1:t<<24>>24;v=0}else{u=v;t=x;v=0}}else v=x;s=s+-4|0;x=c[s>>2]|0;c[e>>2]=u+4;c[u>>2]=x;if((s|0)==(g|0))break;else x=v+1|0}}s=c[e>>2]|0}if((r|0)!=(s|0)?(B=s+-4|0,r>>>0<B>>>0):0){s=B;do{y=c[r>>2]|0;c[r>>2]=c[s>>2];c[s>>2]=y;r=r+4|0;s=s+-4|0}while(r>>>0<s>>>0)}break}default:{}}z=z+1|0}while((z|0)!=4);r=a[p>>0]|0;g=(r&1)==0;r=g?(r&255)>>>1:c[J>>2]|0;if(r>>>0>1){s=g?J:c[K>>2]|0;g=s+4|0;s=s+(r<<2)|0;t=c[e>>2]|0;u=s-g|0;if((r|0)!=1){r=t;while(1){c[r>>2]=c[g>>2];g=g+4|0;if((g|0)==(s|0))break;else r=r+4|0}}c[e>>2]=t+(u>>>2<<2)}switch(f&176|0){case 32:{c[d>>2]=c[e>>2];break}case 16:break;default:c[d>>2]=b}return}function GH(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;z=i;i=i+480|0;q=z+468|0;B=z+464|0;x=z+472|0;u=z+56|0;y=z+52|0;C=z+40|0;E=z+28|0;D=z+16|0;m=z+12|0;p=z+64|0;w=z+8|0;v=z+4|0;r=z;b=lD(f)|0;c[B>>2]=b;o=0;s=Wa(115,B|0,40896)|0;t=o;o=0;do if(t&1)F=13;else{n=a[h>>0]|0;j=(n&1)==0;t=h+4|0;if(!((j?(n&255)>>>1:c[t>>2]|0)|0))n=0;else{j=c[(j?t:c[h+8>>2]|0)>>2]|0;o=0;k=Wa(c[(c[s>>2]|0)+44>>2]|0,s|0,45)|0;n=o;o=0;if(n&1){F=13;break}n=(j|0)==(k|0)}c[C>>2]=0;c[C+4>>2]=0;c[C+8>>2]=0;c[E>>2]=0;c[E+4>>2]=0;c[E+8>>2]=0;c[D>>2]=0;c[D+4>>2]=0;c[D+8>>2]=0;o=0;Ua(45,e|0,n|0,B|0,x|0,u|0,y|0,C|0,E|0,D|0,m|0);l=o;o=0;if(!(l&1)){l=a[h>>0]|0;e=c[t>>2]|0;j=(l&1)==0?(l&255)>>>1:e;m=c[m>>2]|0;if((j|0)>(m|0)){G=a[D>>0]|0;k=a[E>>0]|0;j=(j-m<<1|1)+m+((G&1)==0?(G&255)>>>1:c[D+4>>2]|0)+((k&1)==0?(k&255)>>>1:c[E+4>>2]|0)|0}else{G=a[D>>0]|0;j=a[E>>0]|0;j=m+2+((G&1)==0?(G&255)>>>1:c[D+4>>2]|0)+((j&1)==0?(j&255)>>>1:c[E+4>>2]|0)|0}if(j>>>0>100){j=yC(j<<2)|0;k=j;if(!j){o=0;ob(46);G=o;o=0;if(!(G&1)){l=a[h>>0]|0;e=c[t>>2]|0;j=0;F=17}}else F=17}else{k=0;j=p;F=17}if((F|0)==17){G=(l&1)==0;h=G?t:c[h+8>>2]|0;o=0;Aa(43,j|0,w|0,v|0,c[f+4>>2]|0,h|0,h+((G?(l&255)>>>1:e)<<2)|0,s|0,n|0,x|0,c[u>>2]|0,c[y>>2]|0,C|0,E|0,D|0,m|0);G=o;o=0;if(!(G&1)?(c[r>>2]=c[d>>2],G=c[w>>2]|0,A=c[v>>2]|0,o=0,c[q>>2]=c[r>>2],A=oa(84,q|0,j|0,G|0,A|0,f|0,g|0)|0,G=o,o=0,!(G&1)):0){if(k){zC(k);b=c[B>>2]|0}ZC(D);ZC(E);IC(C);EL(b)|0;i=z;return A|0}}j=cc()|0;if(k){zC(k);b=c[B>>2]|0}}else j=cc()|0;ZC(D);ZC(E);IC(C)}while(0);if((F|0)==13)j=cc()|0;EL(b)|0;bc(j|0);return 0}function HH(a){a=a|0;return}function IH(a){a=a|0;Uz(a);return}function JH(b,d,e){b=b|0;d=d|0;e=e|0;b=gB((a[d>>0]&1)==0?d+1|0:c[d+8>>2]|0,1)|0;return b>>>((b|0)!=(-1|0)&1)|0}function KH(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;k=i;i=i+16|0;l=k;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;j=a[h>>0]|0;m=(j&1)==0;d=m?h+1|0:c[h+8>>2]|0;j=m?(j&255)>>>1:c[h+4>>2]|0;h=d+j|0;a:do if((j|0)>0){while(1){o=0;ma(93,l|0,a[d>>0]|0);m=o;o=0;if(m&1)break;d=d+1|0;if(d>>>0>=h>>>0){j=4;break a}}d=cc()|0;j=7}else j=4;while(0);b:do if((j|0)==4){o=0;d=kb(67,((e|0)==-1?-1:e<<1)|0,f|0,g|0,((a[l>>0]&1)==0?l+1|0:c[l+8>>2]|0)|0)|0;m=o;o=0;if(m&1){d=cc()|0;j=7;break}c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;m=iC(d)|0;h=d+m|0;c:do if((m|0)>0){while(1){o=0;ma(93,b|0,a[d>>0]|0);m=o;o=0;if(m&1)break;d=d+1|0;if(d>>>0>=h>>>0)break c}d=cc()|0;IC(b);break b}while(0);IC(l);i=k;return}while(0);IC(l);bc(d|0)}function LH(a,b){a=a|0;b=b|0;return}function MH(a){a=a|0;return}function NH(a){a=a|0;Uz(a);return}function OH(b,d,e){b=b|0;d=d|0;e=e|0;b=gB((a[d>>0]&1)==0?d+1|0:c[d+8>>2]|0,1)|0;return b>>>((b|0)!=(-1|0)&1)|0}function PH(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;w=i;i=i+224|0;p=w+184|0;n=w+192|0;m=w+180|0;q=w+176|0;u=w+168|0;t=w+40|0;s=w+32|0;v=w+28|0;x=w+16|0;l=w+8|0;r=w;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[l+4>>2]=0;c[l>>2]=41380;k=a[h>>0]|0;y=(k&1)==0;j=h+4|0;d=y?j:c[h+8>>2]|0;h=y?(k&255)>>>1:c[j>>2]|0;j=d+(h<<2)|0;k=n+32|0;a:do if((h|0)>0){b:while(1){c[q>>2]=d;o=0;h=qb(c[(c[l>>2]|0)+12>>2]|0,l|0,p|0,d|0,j|0,q|0,n|0,k|0,m|0)|0;y=o;o=0;if(y&1){h=12;break}if((h|0)==2?1:(c[q>>2]|0)==(d|0)){h=5;break}if(n>>>0<(c[m>>2]|0)>>>0){d=n;do{o=0;ma(93,x|0,a[d>>0]|0);y=o;o=0;if(y&1){h=11;break b}d=d+1|0}while(d>>>0<(c[m>>2]|0)>>>0)}d=c[q>>2]|0;if(!((h|0)!=2&d>>>0<j>>>0)){h=9;break a}}if((h|0)==5){o=0;ka(346,61314);o=0;d=cc()|0}else if((h|0)==11)d=cc()|0;else if((h|0)==12)d=cc()|0}else h=9;while(0);c:do if((h|0)==9){o=0;d=kb(67,((e|0)==-1?-1:e<<1)|0,f|0,g|0,((a[x>>0]&1)==0?x+1|0:c[x+8>>2]|0)|0)|0;y=o;o=0;if(y&1){d=cc()|0;break}c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[r+4>>2]=0;c[r>>2]=41428;y=iC(d)|0;j=d+y|0;k=j;l=t+128|0;d:do if((y|0)>0){e:while(1){c[v>>2]=d;o=0;h=qb(c[(c[r>>2]|0)+16>>2]|0,r|0,u|0,d|0,((k-d|0)>32?d+32|0:j)|0,v|0,t|0,l|0,s|0)|0;y=o;o=0;if(y&1){h=24;break}if((h|0)==2?1:(c[v>>2]|0)==(d|0)){h=18;break}if(t>>>0<(c[s>>2]|0)>>>0){d=t;do{o=0;ma(223,b|0,c[d>>2]|0);y=o;o=0;if(y&1){h=23;break e}d=d+4|0}while(d>>>0<(c[s>>2]|0)>>>0)}d=c[v>>2]|0;if(!((h|0)!=2&d>>>0<j>>>0))break d}if((h|0)==18){o=0;ka(346,61314);o=0;d=cc()|0}else if((h|0)==23)d=cc()|0;else if((h|0)==24)d=cc()|0;ZC(b);break c}while(0);IC(x);i=w;return}while(0);IC(x);bc(d|0)}function QH(a,b){a=a|0;b=b|0;return}function RH(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;c[b+4>>2]=d+-1;c[b>>2]=40880;h=b+8|0;o=0;ma(225,h|0,28);g=o;o=0;if(g&1)d=cc()|0;else{g=b+144|0;o=0;mb(57,g|0,61244,1);f=o;o=0;if(f&1)d=cc()|0;else{e=c[h>>2]|0;f=b+12|0;d=c[f>>2]|0;if((d|0)!=(e|0)){do d=d+-4|0;while((d|0)!=(e|0));c[f>>2]=d}c[775]=0;c[774]=39808;o=0;ma(226,b|0,3096);f=o;o=0;do if(((((((((((((!(f&1)?(c[777]=0,c[776]=39848,o=0,ma(227,b|0,3104),f=o,o=0,!(f&1)):0)?(c[779]=0,c[778]=40920,c[780]=0,a[3124]=0,c[780]=iI()|0,o=0,ma(228,b|0,3112),f=o,o=0,!(f&1)):0)?(c[783]=0,c[782]=41168,o=0,ma(229,b|0,3128),f=o,o=0,!(f&1)):0)?(c[785]=0,c[784]=41236,o=0,ma(230,b|0,3136),f=o,o=0,!(f&1)):0)?(o=0,ma(231,3144,1),f=o,o=0,!(f&1)):0)?(o=0,ma(232,b|0,3144),f=o,o=0,!(f&1)):0)?(c[791]=0,c[790]=41284,o=0,ma(233,b|0,3160),f=o,o=0,!(f&1)):0)?(c[793]=0,c[792]=41332,o=0,ma(234,b|0,3168),f=o,o=0,!(f&1)):0)?(nJ(3176,1),o=0,ma(235,b|0,3176),f=o,o=0,!(f&1)):0)?(oJ(3200,1),o=0,ma(236,b|0,3200),f=o,o=0,!(f&1)):0)?(c[809]=0,c[808]=39888,o=0,ma(237,b|0,3232),f=o,o=0,!(f&1)):0)?(c[811]=0,c[810]=39960,o=0,ma(238,b|0,3240),f=o,o=0,!(f&1)):0)?(c[813]=0,c[812]=40032,o=0,ma(239,b|0,3248),f=o,o=0,!(f&1)):0){c[815]=0;c[814]=40092;o=0;ma(240,b|0,3256);f=o;o=0;if(f&1){i=42;break}c[817]=0;c[816]=40400;o=0;ma(241,b|0,3264);f=o;o=0;if(f&1){i=42;break}c[819]=0;c[818]=40464;o=0;ma(242,b|0,3272);f=o;o=0;if(f&1){i=42;break}c[821]=0;c[820]=40528;o=0;ma(243,b|0,3280);f=o;o=0;if(f&1){i=42;break}c[823]=0;c[822]=40592;o=0;ma(244,b|0,3288);f=o;o=0;if(f&1){i=42;break}c[825]=0;c[824]=40656;o=0;ma(245,b|0,3296);f=o;o=0;if(f&1){i=42;break}c[827]=0;c[826]=40692;o=0;ma(246,b|0,3304);f=o;o=0;if(f&1){i=42;break}c[829]=0;c[828]=40728;o=0;ma(247,b|0,3312);f=o;o=0;if(f&1){i=42;break}c[831]=0;c[830]=40764;o=0;ma(248,b|0,3320);f=o;o=0;if(f&1){i=42;break}c[833]=0;c[832]=40152;c[834]=40200;o=0;ma(249,b|0,3328);f=o;o=0;if(f&1){i=42;break}c[837]=0;c[836]=40244;c[838]=40292;o=0;ma(250,b|0,3344);f=o;o=0;if(f&1){i=42;break}c[841]=0;c[840]=41148;o=0;d=gb(45)|0;f=o;o=0;if(f&1){d=cc()|0;break}c[842]=d;c[840]=40336;o=0;ma(251,b|0,3360);f=o;o=0;if(f&1){i=42;break}c[845]=0;c[844]=41148;o=0;d=gb(45)|0;f=o;o=0;if(f&1){d=cc()|0;break}c[846]=d;c[844]=40368;o=0;ma(252,b|0,3376);i=o;o=0;if(i&1){i=42;break}c[849]=0;c[848]=40800;o=0;ma(253,b|0,3392);i=o;o=0;if(i&1){i=42;break}c[851]=0;c[850]=40840;o=0;ma(254,b|0,3400);i=o;o=0;if(i&1){i=42;break}return}else i=42;while(0);if((i|0)==42)d=cc()|0;IC(g)}ZK(h)}bc(d|0)}function SH(){var b=0;do if((a[3408]|0)==0?(Hb(3408)|0)!=0:0){o=0;gb(46)|0;b=o;o=0;if(b&1){b=cc()|0;rc(3408);bc(b|0)}else{c[10417]=41664;Cc(3408);break}}while(0);return c[10417]|0}function TH(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;DL(b);f=a+8|0;e=c[f>>2]|0;do if((c[a+12>>2]|0)-e>>2>>>0<=d>>>0){o=0;ma(255,f|0,d+1|0);a=o;o=0;if(!(a&1)){e=c[f>>2]|0;break}e=cc()|0;if(b)EL(b)|0;bc(e|0)}while(0);a=c[e+(d<<2)>>2]|0;if(a){EL(a)|0;e=c[f>>2]|0}c[e+(d<<2)>>2]=b;return}function UH(a){a=a|0;var b=0,d=0,e=0,f=0;c[a>>2]=40880;e=a+8|0;f=a+12|0;b=c[e>>2]|0;if((c[f>>2]|0)!=(b|0)){d=0;do{b=c[b+(d<<2)>>2]|0;if(b)EL(b)|0;d=d+1|0;b=c[e>>2]|0}while(d>>>0<(c[f>>2]|0)-b>>2>>>0)}IC(a+144|0);ZK(e);return}function VH(a){a=a|0;UH(a);Uz(a);return}function WH(a,b){a=a|0;b=b|0;if($K(a,b)|0)return c[(c[a+8>>2]|0)+(b<<2)>>2]|0;else{a=Ob(4)|0;gA(a);Hc(a|0,1824,220)}return 0}function XH(){RH(3416,1);c[10416]=3416;return 41664}function YH(){var a=0;a=c[(SH()|0)>>2]|0;c[10418]=a;DL(a);return 41672}function ZH(){var b=0;do if((a[3576]|0)==0?(Hb(3576)|0)!=0:0){o=0;gb(47)|0;b=o;o=0;if(b&1){b=cc()|0;rc(3576);bc(b|0)}else{c[10419]=41672;Cc(3576);break}}while(0);return c[10419]|0}function _H(a){a=a|0;var b=0,d=0;o=0;b=gb(48)|0;d=o;o=0;if(d&1){d=cc(0)|0;oq(d)}else{d=c[b>>2]|0;c[a>>2]=d;DL(d);return}}function $H(a,b){a=a|0;b=b|0;b=c[b>>2]|0;c[a>>2]=b;DL(b);return}function aI(a){a=a|0;EL(c[a>>2]|0)|0;return}function bI(a){a=a|0;var b=0,d=0;d=i;i=i+16|0;b=d;if((c[a>>2]|0)!=-1){c[b>>2]=a;c[b+4>>2]=347;c[b+8>>2]=0;RL(a,b,348)}i=d;return (c[a+4>>2]|0)+-1|0}function cI(a,b){a=a|0;b=b|0;a=c[a>>2]|0;return WH(a,bI(b)|0)|0}function dI(a){a=a|0;Uz(a);return}function eI(a){a=a|0;if(a)_c[c[(c[a>>2]|0)+4>>2]&511](a);return}function fI(a){a=a|0;var b=0;b=c[10223]|0;c[10223]=b+1;c[a+4>>2]=b+1;return}function gI(a){a=a|0;Uz(a);return}function hI(a,c,d){a=a|0;c=c|0;d=d|0;if(d>>>0<128)d=(b[(iI()|0)+(d<<1)>>1]&c)<<16>>16!=0;else d=0;return d|0}function iI(){var a=0,b=0;o=0;a=gb(49)|0;b=o;o=0;if(b&1){b=cc(0)|0;oq(b)}else return c[a>>2]|0;return 0}function jI(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,i=0;i=(f-d|0)>>>2;if((d|0)!=(f|0)){h=d;while(1){a=c[h>>2]|0;if(a>>>0<128)a=e[(iI()|0)+(a<<1)>>1]|0;else a=0;b[g>>1]=a;h=h+4|0;if((h|0)==(f|0))break;else g=g+2|0}}return d+(i<<2)|0}function kI(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;a:do if((e|0)==(f|0))e=f;else while(1){a=c[e>>2]|0;if(a>>>0<128?(b[(iI()|0)+(a<<1)>>1]&d)<<16>>16!=0:0)break a;e=e+4|0;if((e|0)==(f|0)){e=f;break}}while(0);return e|0}function lI(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;a:do if((e|0)==(f|0))e=f;else while(1){a=c[e>>2]|0;if(a>>>0>=128)break a;if(!((b[(iI()|0)+(a<<1)>>1]&d)<<16>>16))break a;e=e+4|0;if((e|0)==(f|0)){e=f;break}}while(0);return e|0}function mI(a,b){a=a|0;b=b|0;if(b>>>0<128)b=c[(nI()|0)+(b<<2)>>2]|0;return b|0}function nI(){var a=0,b=0;o=0;a=gb(50)|0;b=o;o=0;if(b&1){b=cc(0)|0;oq(b)}else return c[a>>2]|0;return 0}function oI(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=(d-b|0)>>>2;if((b|0)!=(d|0)){e=b;do{a=c[e>>2]|0;if(a>>>0<128)a=c[(nI()|0)+(a<<2)>>2]|0;c[e>>2]=a;e=e+4|0}while((e|0)!=(d|0))}return b+(f<<2)|0}function pI(a,b){a=a|0;b=b|0;if(b>>>0<128)b=c[(qI()|0)+(b<<2)>>2]|0;return b|0}function qI(){var a=0,b=0;o=0;a=gb(51)|0;b=o;o=0;if(b&1){b=cc(0)|0;oq(b)}else return c[a>>2]|0;return 0}function rI(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=(d-b|0)>>>2;if((b|0)!=(d|0)){e=b;do{a=c[e>>2]|0;if(a>>>0<128)a=c[(qI()|0)+(a<<2)>>2]|0;c[e>>2]=a;e=e+4|0}while((e|0)!=(d|0))}return b+(f<<2)|0}function sI(a,b){a=a|0;b=b|0;return b<<24>>24|0}function tI(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;if((d|0)!=(e|0))while(1){c[f>>2]=a[d>>0];d=d+1|0;if((d|0)==(e|0))break;else f=f+4|0}return e|0}function uI(a,b,c){a=a|0;b=b|0;c=c|0;return (b>>>0<128?b&255:c)|0}function vI(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;i=(e-d|0)>>>2;if((d|0)!=(e|0)){h=d;b=g;while(1){g=c[h>>2]|0;a[b>>0]=g>>>0<128?g&255:f;h=h+4|0;if((h|0)==(e|0))break;else b=b+1|0}}return d+(i<<2)|0}function wI(b){b=b|0;var d=0;c[b>>2]=40920;d=c[b+8>>2]|0;if((d|0)!=0?(a[b+12>>0]|0)!=0:0)Vz(d);return}function xI(a){a=a|0;wI(a);Uz(a);return}function yI(a,b){a=a|0;b=b|0;if(b<<24>>24>-1)b=c[(nI()|0)+((b&255)<<2)>>2]&255;return b|0}function zI(b,d,e){b=b|0;d=d|0;e=e|0;if((d|0)!=(e|0)){b=d;do{d=a[b>>0]|0;if(d<<24>>24>-1)d=c[(nI()|0)+(d<<24>>24<<2)>>2]&255;a[b>>0]=d;b=b+1|0}while((b|0)!=(e|0))}return e|0}function AI(a,b){a=a|0;b=b|0;if(b<<24>>24>-1)b=c[(qI()|0)+(b<<24>>24<<2)>>2]&255;return b|0}function BI(b,d,e){b=b|0;d=d|0;e=e|0;if((d|0)!=(e|0)){b=d;do{d=a[b>>0]|0;if(d<<24>>24>-1)d=c[(qI()|0)+(d<<24>>24<<2)>>2]&255;a[b>>0]=d;b=b+1|0}while((b|0)!=(e|0))}return e|0}function CI(a,b){a=a|0;b=b|0;return b|0}function DI(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;if((c|0)!=(d|0))while(1){a[e>>0]=a[c>>0]|0;c=c+1|0;if((c|0)==(d|0))break;else e=e+1|0}return d|0}function EI(a,b,c){a=a|0;b=b|0;c=c|0;return (b<<24>>24>-1?b:c)|0}function FI(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;if((c|0)!=(d|0))while(1){b=a[c>>0]|0;a[f>>0]=b<<24>>24>-1?b:e;c=c+1|0;if((c|0)==(d|0))break;else f=f+1|0}return d|0}function GI(a){a=a|0;Uz(a);return}function HI(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;c[f>>2]=d;c[i>>2]=g;return 3}function II(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;c[f>>2]=d;c[i>>2]=g;return 3}function JI(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=d;return 3}function KI(a){a=a|0;return 1}function LI(a){a=a|0;return 1}function MI(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;a=d-c|0;return (a>>>0<e>>>0?a:e)|0}function NI(a){a=a|0;return 1}function OI(a,b){a=a|0;b=b|0;var d=0;c[a+4>>2]=b+-1;c[a>>2]=40988;o=0;b=gb(45)|0;d=o;o=0;if(d&1){d=cc()|0;bc(d|0)}else{c[a+8>>2]=b;return}}function PI(a){a=a|0;SJ(a);Uz(a);return}function QI(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;u=i;i=i+16|0;s=u;q=u+8|0;a:do if((e|0)==(f|0))l=f;else{l=e;while(1){if(!(c[l>>2]|0))break a;l=l+4|0;if((l|0)==(f|0)){l=f;break}}}while(0);c[k>>2]=h;c[g>>2]=e;n=j;r=b+8|0;b:do if(!((h|0)==(j|0)|(e|0)==(f|0))){b=h;m=l;c:while(1){w=d;h=c[w+4>>2]|0;l=s;c[l>>2]=c[w>>2];c[l+4>>2]=h;l=lB(c[r>>2]|0)|0;o=0;h=Ya(70,b|0,g|0,m-e>>2|0,n-b|0,d|0)|0;w=o;o=0;if(w&1){v=9;break}if((l|0)!=0?(o=0,qa(193,l|0)|0,w=o,o=0,w&1):0){v=8;break}switch(h|0){case 0:{p=1;break b}case -1:{l=b;v=14;break c}default:{}}l=(c[k>>2]|0)+h|0;c[k>>2]=l;if((l|0)==(j|0)){v=27;break}if((m|0)==(f|0)){e=c[g>>2]|0;b=l;l=f}else{l=lB(c[r>>2]|0)|0;o=0;e=ya(124,q|0,0,d|0)|0;w=o;o=0;if(w&1){v=35;break}if((l|0)!=0?(o=0,qa(193,l|0)|0,w=o,o=0,w&1):0){v=34;break}if((e|0)==-1){p=2;break b}if(e>>>0>(n-(c[k>>2]|0)|0)>>>0){p=1;break b}if(e){l=q;while(1){m=a[l>>0]|0;w=c[k>>2]|0;c[k>>2]=w+1;a[w>>0]=m;e=e+-1|0;if(!e)break;else l=l+1|0}}e=(c[g>>2]|0)+4|0;c[g>>2]=e;d:do if((e|0)==(f|0))l=f;else{l=e;while(1){if(!(c[l>>2]|0))break d;l=l+4|0;if((l|0)==(f|0)){l=f;break}}}while(0);b=c[k>>2]|0}if((b|0)==(j|0)|(e|0)==(f|0)){v=47;break b}else m=l}if((v|0)==8){w=cc(0)|0;oq(w)}else if((v|0)==9){e=cc()|0;if((l|0)!=0?(o=0,qa(193,l|0)|0,w=o,o=0,w&1):0){w=cc(0)|0;oq(w)}bc(e|0)}else if((v|0)==14){c[k>>2]=l;e:do if((e|0)!=(c[g>>2]|0)){while(1){w=c[e>>2]|0;b=lB(c[r>>2]|0)|0;o=0;l=ya(124,l|0,w|0,s|0)|0;w=o;o=0;if(w&1){t=b;break}if((b|0)!=0?(o=0,qa(193,b|0)|0,w=o,o=0,w&1):0){v=18;break}if((l|0)==-1)break e;l=(c[k>>2]|0)+l|0;c[k>>2]=l;e=e+4|0;if((e|0)==(c[g>>2]|0))break e}if((v|0)==18){w=cc(0)|0;oq(w)}e=cc()|0;if((t|0)!=0?(o=0,qa(193,t|0)|0,w=o,o=0,w&1):0){w=cc(0)|0;oq(w)}bc(e|0)}while(0);c[g>>2]=e;p=2;break}else if((v|0)==27){e=c[g>>2]|0;v=47;break}else if((v|0)==34){w=cc(0)|0;oq(w)}else if((v|0)==35){e=cc()|0;if((l|0)!=0?(o=0,qa(193,l|0)|0,w=o,o=0,w&1):0){w=cc(0)|0;oq(w)}bc(e|0)}}else v=47;while(0);if((v|0)==47)p=(e|0)!=(f|0)&1;i=u;return p|0}function RI(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;u=i;i=i+16|0;t=u;a:do if((e|0)==(f|0))l=f;else{l=e;while(1){if(!(a[l>>0]|0))break a;l=l+1|0;if((l|0)==(f|0)){l=f;break}}}while(0);c[k>>2]=h;c[g>>2]=e;p=j;r=b+8|0;b:do if(!((h|0)==(j|0)|(e|0)==(f|0))){b=h;n=l;c:while(1){m=d;l=c[m+4>>2]|0;h=t;c[h>>2]=c[m>>2];c[h+4>>2]=l;h=n;l=lB(c[r>>2]|0)|0;o=0;m=Ya(71,b|0,g|0,h-e|0,p-b>>2|0,d|0)|0;w=o;o=0;if(w&1){v=9;break}if((l|0)!=0?(o=0,qa(193,l|0)|0,w=o,o=0,w&1):0){v=8;break}switch(m|0){case 0:{q=2;break b}case -1:{l=b;v=14;break c}default:{}}b=(c[k>>2]|0)+(m<<2)|0;c[k>>2]=b;if((b|0)==(j|0)){v=31;break}e=c[g>>2]|0;if((n|0)==(f|0))l=f;else{l=lB(c[r>>2]|0)|0;o=0;e=kb(68,b|0,e|0,1,d|0)|0;w=o;o=0;if(w&1){v=38;break}if((l|0)!=0?(o=0,qa(193,l|0)|0,w=o,o=0,w&1):0){v=37;break}if(e){q=2;break b}c[k>>2]=(c[k>>2]|0)+4;e=(c[g>>2]|0)+1|0;c[g>>2]=e;d:do if((e|0)==(f|0))l=f;else{l=e;while(1){if(!(a[l>>0]|0))break d;l=l+1|0;if((l|0)==(f|0)){l=f;break}}}while(0);b=c[k>>2]|0}if((b|0)==(j|0)|(e|0)==(f|0)){v=47;break b}else n=l}if((v|0)==8){w=cc(0)|0;oq(w)}else if((v|0)==9){e=cc()|0;if((l|0)!=0?(o=0,qa(193,l|0)|0,w=o,o=0,w&1):0){w=cc(0)|0;oq(w)}bc(e|0)}else if((v|0)==14){c[k>>2]=l;e:do if((e|0)!=(c[g>>2]|0)){b=l;f:while(1){l=lB(c[r>>2]|0)|0;o=0;b=kb(68,b|0,e|0,h-e|0,t|0)|0;w=o;o=0;if(w&1){v=19;break}if((l|0)!=0?(o=0,qa(193,l|0)|0,w=o,o=0,w&1):0){v=18;break}switch(b|0){case -1:{v=25;break f}case -2:{v=26;break f}case 0:{e=e+1|0;break}default:e=e+b|0}b=(c[k>>2]|0)+4|0;c[k>>2]=b;if((e|0)==(c[g>>2]|0)){s=e;break e}}if((v|0)==18){w=cc(0)|0;oq(w)}else if((v|0)==19){e=cc()|0;if((l|0)!=0?(o=0,qa(193,l|0)|0,w=o,o=0,w&1):0){w=cc(0)|0;oq(w)}bc(e|0)}else if((v|0)==25){c[g>>2]=e;q=2;break b}else if((v|0)==26){c[g>>2]=e;q=1;break b}}else s=e;while(0);c[g>>2]=s;q=(s|0)!=(f|0)&1;break}else if((v|0)==31){e=c[g>>2]|0;v=47;break}else if((v|0)==37){w=cc(0)|0;oq(w)}else if((v|0)==38){e=cc()|0;if((l|0)!=0?(o=0,qa(193,l|0)|0,w=o,o=0,w&1):0){w=cc(0)|0;oq(w)}bc(e|0)}}else v=47;while(0);if((v|0)==47)q=(e|0)!=(f|0)&1;i=u;return q|0}function SI(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;j=i;i=i+16|0;h=j;c[g>>2]=e;e=lB(c[b+8>>2]|0)|0;o=0;b=ya(124,h|0,0,d|0)|0;d=o;o=0;if(d&1){h=cc()|0;if((e|0)!=0?(o=0,qa(193,e|0)|0,j=o,o=0,j&1):0){j=cc(0)|0;oq(j)}bc(h|0)}if((e|0)!=0?(o=0,qa(193,e|0)|0,d=o,o=0,d&1):0){d=cc(0)|0;oq(d)}switch(b|0){case 0:case -1:{h=2;break}default:{b=b+-1|0;if(b>>>0<=(f-(c[g>>2]|0)|0)>>>0)if(!b)h=0;else while(1){d=a[h>>0]|0;f=c[g>>2]|0;c[g>>2]=f+1;a[f>>0]=d;b=b+-1|0;if(!b){h=0;break}else h=h+1|0}else h=1}}i=j;return h|0}function TI(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=a+8|0;o=0;d=qa(193,c[b>>2]|0)|0;e=o;o=0;do if(e&1)f=16;else{o=0;e=ya(125,0,0,4)|0;a=o;o=0;if(a&1){a=cc(0)|0;if(!d)break;o=0;qa(193,d|0)|0;h=o;o=0;if(!(h&1))break;h=cc(0)|0;oq(h)}if((d|0)!=0?(o=0,qa(193,d|0)|0,h=o,o=0,h&1):0){h=cc(0)|0;oq(h)}if(!e){a=c[b>>2]|0;if(a){o=0;a=qa(193,a|0)|0;h=o;o=0;if(h&1){f=16;break}if((a|0)!=0?(o=0,qa(193,a|0)|0,h=o,o=0,h&1):0){h=cc(0)|0;oq(h)}else g=0}else g=1}else g=-1;return g|0}while(0);if((f|0)==16)a=cc(0)|0;oq(a);return 0}function UI(a){a=a|0;return 0}function VI(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=e;j=a+8|0;a:do if((d|0)==(e|0)|(f|0)==0)a=0;else{a=0;i=0;while(1){h=lB(c[j>>2]|0)|0;o=0;g=ya(126,d|0,k-d|0,b|0)|0;n=o;o=0;if(n&1){m=h;break}if((h|0)!=0?(o=0,qa(193,h|0)|0,n=o,o=0,n&1):0){l=5;break}switch(g|0){case -2:case -1:break a;case 0:{d=d+1|0;g=1;break}default:d=d+g|0}a=g+a|0;i=i+1|0;if((d|0)==(e|0)|i>>>0>=f>>>0)break a}if((l|0)==5){n=cc(0)|0;oq(n)}a=cc()|0;if((m|0)!=0?(o=0,qa(193,m|0)|0,n=o,o=0,n&1):0){n=cc(0)|0;oq(n)}bc(a|0)}while(0);return a|0}function WI(a){a=a|0;var b=0,d=0;a=c[a+8>>2]|0;if(a){o=0;a=qa(193,a|0)|0;d=o;o=0;if(d&1){d=cc(0)|0;oq(d)}if((a|0)!=0?(o=0,qa(193,a|0)|0,d=o,o=0,d&1):0){d=cc(0)|0;oq(d)}else b=4}else b=1;return b|0}function XI(a){a=a|0;Uz(a);return}function YI(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;a=i;i=i+16|0;k=a+4|0;b=a;c[k>>2]=d;c[b>>2]=g;h=bL(d,e,k,g,h,b,1114111,0)|0;c[f>>2]=c[k>>2];c[j>>2]=c[b>>2];i=a;return h|0}function ZI(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;a=i;i=i+16|0;k=a+4|0;b=a;c[k>>2]=d;c[b>>2]=g;h=cL(d,e,k,g,h,b,1114111,0)|0;c[f>>2]=c[k>>2];c[j>>2]=c[b>>2];i=a;return h|0}function _I(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=d;return 3}function $I(a){a=a|0;return 0}function aJ(a){a=a|0;return 0}function bJ(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return dL(c,d,e,1114111,0)|0}function cJ(a){a=a|0;return 4}function dJ(a){a=a|0;Uz(a);return}function eJ(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;a=i;i=i+16|0;k=a+4|0;b=a;c[k>>2]=d;c[b>>2]=g;h=eL(d,e,k,g,h,b,1114111,0)|0;c[f>>2]=c[k>>2];c[j>>2]=c[b>>2];i=a;return h|0}function fJ(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;a=i;i=i+16|0;k=a+4|0;b=a;c[k>>2]=d;c[b>>2]=g;h=fL(d,e,k,g,h,b,1114111,0)|0;c[f>>2]=c[k>>2];c[j>>2]=c[b>>2];i=a;return h|0}function gJ(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=d;return 3}function hJ(a){a=a|0;return 0}function iJ(a){a=a|0;return 0}function jJ(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return gL(c,d,e,1114111,0)|0}function kJ(a){a=a|0;return 4}function lJ(a){a=a|0;Uz(a);return}function mJ(a){a=a|0;Uz(a);return}function nJ(b,d){b=b|0;d=d|0;c[b+4>>2]=d+-1;c[b>>2]=41068;a[b+8>>0]=46;a[b+9>>0]=44;b=b+12|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;return}function oJ(a,b){a=a|0;b=b|0;c[a+4>>2]=b+-1;c[a>>2]=41108;c[a+8>>2]=46;c[a+12>>2]=44;a=a+16|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function pJ(a){a=a|0;c[a>>2]=41068;IC(a+12|0);return}function qJ(a){a=a|0;pJ(a);Uz(a);return}function rJ(a){a=a|0;c[a>>2]=41108;IC(a+16|0);return}function sJ(a){a=a|0;rJ(a);Uz(a);return}function tJ(b){b=b|0;return a[b+8>>0]|0}function uJ(a){a=a|0;return c[a+8>>2]|0}function vJ(b){b=b|0;return a[b+9>>0]|0}function wJ(a){a=a|0;return c[a+12>>2]|0}function xJ(a,b){a=a|0;b=b|0;EC(a,b+12|0);return}function yJ(a,b){a=a|0;b=b|0;EC(a,b+16|0);return}function zJ(a,b){a=a|0;b=b|0;FC(a,61383,4);return}function AJ(a,b){a=a|0;b=b|0;XC(a,41680,jC(41680)|0);return}function BJ(a,b){a=a|0;b=b|0;FC(a,61388,5);return}function CJ(a,b){a=a|0;b=b|0;XC(a,41700,jC(41700)|0);return}function DJ(a){a=a|0;switch(c[a+4>>2]&74|0){case 64:{a=8;break}case 8:{a=16;break}case 0:{a=0;break}default:a=10}return a|0}function EJ(b){b=b|0;do if((a[3584]|0)==0?(Hb(3584)|0)!=0:0){if((a[3592]|0)==0?(Hb(3592)|0)!=0:0){b=41724;do{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;b=b+12|0}while((b|0)!=41892);Ec(349,0,n|0)|0;Cc(3592)}o=0;Wa(108,41724,61394)|0;b=o;o=0;if(((((((((((((!(b&1)?(o=0,Wa(108,41736,61401)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,41748,61408)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,41760,61416)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,41772,61426)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,41784,61435)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,41796,61442)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,41808,61451)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,41820,61455)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,41832,61459)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,41844,61463)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,41856,61467)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,41868,61471)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,41880,61475)|0,b=o,o=0,!(b&1)):0){c[10473]=41724;Cc(3584);break}b=cc()|0;rc(3584);bc(b|0)}while(0);return c[10473]|0}function FJ(b){b=b|0;do if((a[3600]|0)==0?(Hb(3600)|0)!=0:0){if((a[3608]|0)==0?(Hb(3608)|0)!=0:0){b=41896;do{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;b=b+12|0}while((b|0)!=42064);Ec(350,0,n|0)|0;Cc(3608)}o=0;Wa(118,41896,42064)|0;b=o;o=0;if(((((((((((((!(b&1)?(o=0,Wa(118,41908,42092)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,41920,42120)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,41932,42152)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,41944,42192)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,41956,42228)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,41968,42256)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,41980,42292)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,41992,42308)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42004,42324)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42016,42340)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42028,42356)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42040,42372)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42052,42388)|0,b=o,o=0,!(b&1)):0){c[10601]=41896;Cc(3600);break}b=cc()|0;rc(3600);bc(b|0)}while(0);return c[10601]|0}function GJ(b){b=b|0;a:do if((a[3616]|0)==0?(Hb(3616)|0)!=0:0){if((a[3624]|0)==0?(Hb(3624)|0)!=0:0){b=42408;do{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;b=b+12|0}while((b|0)!=42696);Ec(351,0,n|0)|0;Cc(3624)}o=0;Wa(108,42408,61479)|0;b=o;o=0;do if((((((((((((((!(b&1)?(o=0,Wa(108,42420,61487)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42432,61496)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42444,61502)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42456,61508)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42468,61512)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42480,61517)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42492,61522)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42504,61529)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42516,61539)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42528,61547)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42540,61556)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42552,61565)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42564,61569)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(108,42576,61573)|0,b=o,o=0,!(b&1)):0){o=0;Wa(108,42588,61577)|0;b=o;o=0;if(b&1)break;o=0;Wa(108,42600,61508)|0;b=o;o=0;if(b&1)break;o=0;Wa(108,42612,61581)|0;b=o;o=0;if(b&1)break;o=0;Wa(108,42624,61585)|0;b=o;o=0;if(b&1)break;o=0;Wa(108,42636,61589)|0;b=o;o=0;if(b&1)break;o=0;Wa(108,42648,61593)|0;b=o;o=0;if(b&1)break;o=0;Wa(108,42660,61597)|0;b=o;o=0;if(b&1)break;o=0;Wa(108,42672,61601)|0;b=o;o=0;if(b&1)break;o=0;Wa(108,42684,61605)|0;b=o;o=0;if(b&1)break;c[10674]=42408;Cc(3616);break a}while(0);b=cc()|0;rc(3616);bc(b|0)}while(0);return c[10674]|0}function HJ(b){b=b|0;a:do if((a[3632]|0)==0?(Hb(3632)|0)!=0:0){if((a[3640]|0)==0?(Hb(3640)|0)!=0:0){b=42700;do{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;b=b+12|0}while((b|0)!=42988);Ec(352,0,n|0)|0;Cc(3640)}o=0;Wa(118,42700,42988)|0;b=o;o=0;do if((((((((((((((!(b&1)?(o=0,Wa(118,42712,43020)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42724,43056)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42736,43080)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42748,43104)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42760,43120)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42772,43140)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42784,43160)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42796,43188)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42808,43228)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42820,43260)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42832,43296)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42844,43332)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42856,43348)|0,b=o,o=0,!(b&1)):0)?(o=0,Wa(118,42868,43364)|0,b=o,o=0,!(b&1)):0){o=0;Wa(118,42880,43380)|0;b=o;o=0;if(b&1)break;o=0;Wa(118,42892,43104)|0;b=o;o=0;if(b&1)break;o=0;Wa(118,42904,43396)|0;b=o;o=0;if(b&1)break;o=0;Wa(118,42916,43412)|0;b=o;o=0;if(b&1)break;o=0;Wa(118,42928,43428)|0;b=o;o=0;if(b&1)break;o=0;Wa(118,42940,43444)|0;b=o;o=0;if(b&1)break;o=0;Wa(118,42952,43460)|0;b=o;o=0;if(b&1)break;o=0;Wa(118,42964,43476)|0;b=o;o=0;if(b&1)break;o=0;Wa(118,42976,43492)|0;b=o;o=0;if(b&1)break;c[10877]=42700;Cc(3632);break a}while(0);b=cc()|0;rc(3632);bc(b|0)}while(0);return c[10877]|0}function IJ(b){b=b|0;do if((a[3648]|0)==0?(Hb(3648)|0)!=0:0){if((a[3656]|0)==0?(Hb(3656)|0)!=0:0){b=43512;do{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;b=b+12|0}while((b|0)!=43800);Ec(353,0,n|0)|0;Cc(3656)}o=0;Wa(108,43512,61609)|0;b=o;o=0;if(!(b&1)?(o=0,Wa(108,43524,61612)|0,b=o,o=0,!(b&1)):0){c[10950]=43512;Cc(3648);break}b=cc()|0;rc(3648);bc(b|0)}while(0);return c[10950]|0}function JJ(b){b=b|0;do if((a[3664]|0)==0?(Hb(3664)|0)!=0:0){if((a[3672]|0)==0?(Hb(3672)|0)!=0:0){b=43804;do{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;b=b+12|0}while((b|0)!=44092);Ec(354,0,n|0)|0;Cc(3672)}o=0;Wa(118,43804,44092)|0;b=o;o=0;if(!(b&1)?(o=0,Wa(118,43816,44104)|0,b=o,o=0,!(b&1)):0){c[11029]=43804;Cc(3664);break}b=cc()|0;rc(3664);bc(b|0)}while(0);return c[11029]|0}function KJ(b){b=b|0;do if((a[3680]|0)==0?(Hb(3680)|0)!=0:0){o=0;mb(57,44120,61615,8);b=o;o=0;if(b&1){b=cc()|0;rc(3680);bc(b|0)}else{Ec(331,44120,n|0)|0;Cc(3680);break}}while(0);return 44120}function LJ(b){b=b|0;var c=0;do if((a[3688]|0)==0?(Hb(3688)|0)!=0:0){o=0;b=qa(194,44132)|0;c=o;o=0;if(!(c&1)?(o=0,mb(119,44168,44132,b|0),c=o,o=0,!(c&1)):0){Ec(355,44168,n|0)|0;Cc(3688);break}c=cc()|0;rc(3688);bc(c|0)}while(0);return 44168}function MJ(b){b=b|0;do if((a[3696]|0)==0?(Hb(3696)|0)!=0:0){o=0;mb(57,44180,61624,8);b=o;o=0;if(b&1){b=cc()|0;rc(3696);bc(b|0)}else{Ec(331,44180,n|0)|0;Cc(3696);break}}while(0);return 44180}function NJ(b){b=b|0;var c=0;do if((a[3704]|0)==0?(Hb(3704)|0)!=0:0){o=0;b=qa(194,44192)|0;c=o;o=0;if(!(c&1)?(o=0,mb(119,44228,44192,b|0),c=o,o=0,!(c&1)):0){Ec(355,44228,n|0)|0;Cc(3704);break}c=cc()|0;rc(3704);bc(c|0)}while(0);return 44228}function OJ(b){b=b|0;do if((a[3712]|0)==0?(Hb(3712)|0)!=0:0){o=0;mb(57,44240,61633,20);b=o;o=0;if(b&1){b=cc()|0;rc(3712);bc(b|0)}else{Ec(331,44240,n|0)|0;Cc(3712);break}}while(0);return 44240}function PJ(b){b=b|0;var c=0;do if((a[3720]|0)==0?(Hb(3720)|0)!=0:0){o=0;b=qa(194,44252)|0;c=o;o=0;if(!(c&1)?(o=0,mb(119,44336,44252,b|0),c=o,o=0,!(c&1)):0){Ec(355,44336,n|0)|0;Cc(3720);break}c=cc()|0;rc(3720);bc(c|0)}while(0);return 44336}function QJ(b){b=b|0;do if((a[3728]|0)==0?(Hb(3728)|0)!=0:0){o=0;mb(57,44348,61654,11);b=o;o=0;if(b&1){b=cc()|0;rc(3728);bc(b|0)}else{Ec(331,44348,n|0)|0;Cc(3728);break}}while(0);return 44348}function RJ(b){b=b|0;var c=0;do if((a[3736]|0)==0?(Hb(3736)|0)!=0:0){o=0;b=qa(194,44360)|0;c=o;o=0;if(!(c&1)?(o=0,mb(119,44408,44360,b|0),c=o,o=0,!(c&1)):0){Ec(355,44408,n|0)|0;Cc(3736);break}c=cc()|0;rc(3736);bc(c|0)}while(0);return 44408}function SJ(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=40988;a=a+8|0;b=c[a>>2]|0;o=0;d=gb(45)|0;e=o;o=0;do if(!(e&1)){if((b|0)!=(d|0)?(o=0,ka(344,c[a>>2]|0),e=o,o=0,e&1):0)break;return}while(0);e=cc(0)|0;oq(e)}function TJ(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+112|0;m=z;p=(g-f|0)/12|0;do if(p>>>0>100){m=yC(p)|0;if((m|0)==0?(o=0,ob(46),y=o,o=0,y&1):0){l=0;s=6;break}l=m;s=11}else{l=0;s=11}while(0);a:do if((s|0)==11){if((f|0)==(g|0))n=0;else{s=f;q=0;r=m;while(1){n=a[s>>0]|0;if(!(n&1))n=(n&255)>>>1;else n=c[s+4>>2]|0;if(!n){a[r>>0]=2;n=q+1|0;p=p+-1|0}else{a[r>>0]=1;n=q}s=s+12|0;if((s|0)==(g|0))break;else{q=n;r=r+1|0}}}x=(f|0)==(g|0);y=(f|0)==(g|0);w=0;t=n;b:while(1){n=c[b>>2]|0;do if(n){if((c[n+12>>2]|0)==(c[n+16>>2]|0)){o=0;n=qa(c[(c[n>>2]|0)+36>>2]|0,n|0)|0;v=o;o=0;if(v&1){s=5;break b}if((n|0)==-1){c[b>>2]=0;n=0;break}else{n=c[b>>2]|0;break}}}else n=0;while(0);s=(n|0)==0;q=c[e>>2]|0;if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;n=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;v=o;o=0;if(v&1){s=5;break}if((n|0)==-1){c[e>>2]=0;q=0}}}else q=0;r=(q|0)==0;n=c[b>>2]|0;if(!((p|0)!=0&(s^r))){s=64;break}q=c[n+12>>2]|0;if((q|0)==(c[n+16>>2]|0)){o=0;n=qa(c[(c[n>>2]|0)+36>>2]|0,n|0)|0;v=o;o=0;if(v&1){s=5;break}}else n=d[q>>0]|0;n=n&255;if(!k){o=0;n=Wa(c[(c[h>>2]|0)+12>>2]|0,h|0,n|0)|0;v=o;o=0;if(v&1){s=5;break}}v=w+1|0;if(x){n=0;s=t}else{r=0;u=f;s=t;t=m;while(1){do if((a[t>>0]|0)==1){if(!(a[u>>0]&1))q=u+1|0;else q=c[u+8>>2]|0;q=a[q+w>>0]|0;if(!k){o=0;q=Wa(c[(c[h>>2]|0)+12>>2]|0,h|0,q|0)|0;A=o;o=0;if(A&1){s=4;break b}}if(n<<24>>24!=q<<24>>24){a[t>>0]=0;q=r;p=p+-1|0;break}q=a[u>>0]|0;if(!(q&1))q=(q&255)>>>1;else q=c[u+4>>2]|0;if((q|0)==(v|0)){a[t>>0]=2;q=1;s=s+1|0;p=p+-1|0}else q=1}else q=r;while(0);u=u+12|0;if((u|0)==(g|0)){n=q;break}else{r=q;t=t+1|0}}}if(!n){w=v;t=s;continue}n=c[b>>2]|0;q=n+12|0;r=c[q>>2]|0;if((r|0)==(c[n+16>>2]|0)){o=0;qa(c[(c[n>>2]|0)+40>>2]|0,n|0)|0;A=o;o=0;if(A&1){s=5;break}}else c[q>>2]=r+1;if((s+p|0)>>>0<2|y){w=v;t=s;continue}else{n=f;r=s;s=m}while(1){if((a[s>>0]|0)==2){q=a[n>>0]|0;if(!(q&1))q=(q&255)>>>1;else q=c[n+4>>2]|0;if((q|0)!=(v|0)){a[s>>0]=0;r=r+-1|0}}n=n+12|0;if((n|0)==(g|0)){w=v;t=r;continue b}else s=s+1|0}}if((s|0)==4){f=cc()|0;break}else if((s|0)==5){f=cc()|0;break}else if((s|0)==64){do if(n){if((c[n+12>>2]|0)==(c[n+16>>2]|0)){o=0;n=qa(c[(c[n>>2]|0)+36>>2]|0,n|0)|0;A=o;o=0;if(A&1){s=6;break a}if((n|0)==-1){c[b>>2]=0;n=0;break}else{n=c[b>>2]|0;break}}}else n=0;while(0);p=(n|0)==0;do if(!r){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;n=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;A=o;o=0;if(A&1){s=6;break a}if((n|0)==-1){c[e>>2]=0;s=76;break}}if(!p)s=77}else s=76;while(0);if((s|0)==76?p:0)s=77;if((s|0)==77)c[j>>2]=c[j>>2]|2;c:do if((f|0)==(g|0))s=81;else while(1){if((a[m>>0]|0)==2)break c;f=f+12|0;if((f|0)==(g|0)){s=81;break}else m=m+1|0}while(0);if((s|0)==81){c[j>>2]=c[j>>2]|4;f=g}if(l)zC(l);i=z;return f|0}}while(0);if((s|0)==6)f=cc()|0;if(l)zC(l);bc(f|0);return 0}function UJ(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;A=i;i=i+240|0;t=A+202|0;k=A+200|0;C=A+24|0;B=A+12|0;v=A+8|0;y=A+40|0;z=A+4|0;w=A;u=DJ(g)|0;GE(C,g,t,k);c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;o=0;mb(80,B|0,b|0,0);s=o;o=0;a:do if(!(s&1)){q=B+8|0;r=B+1|0;g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g;c[z>>2]=y;c[w>>2]=0;s=B+4|0;p=a[k>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;k=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;n=o;o=0;if(n&1){D=24;break}if((k|0)==-1){c[e>>2]=0;b=0}}}else b=0;l=(b|0)==0;k=c[f>>2]|0;do if(k){if((c[k+12>>2]|0)!=(c[k+16>>2]|0))if(l)break;else break b;o=0;m=qa(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;n=o;o=0;if(n&1){D=24;break b}if((m|0)!=-1)if(l)break;else break b;else{c[f>>2]=0;D=16;break}}else D=16;while(0);if((D|0)==16){D=0;if(l){k=0;break}else k=0}l=a[B>>0]|0;l=(l&1)==0?(l&255)>>>1:c[s>>2]|0;if((c[v>>2]|0)==(g+l|0)){o=0;mb(80,B|0,l<<1|0,0);n=o;o=0;if(n&1){D=24;break}if(!(a[B>>0]&1))g=10;else g=(c[B>>2]&-2)+-1|0;o=0;mb(80,B|0,g|0,0);n=o;o=0;if(n&1){D=24;break}g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g+l}m=b+12|0;l=c[m>>2]|0;n=b+16|0;if((l|0)==(c[n>>2]|0)){o=0;l=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=24;break}}else l=d[l>>0]|0;if(qE(l&255,u,g,v,w,p,C,y,z,t)|0)break;k=c[m>>2]|0;if((k|0)==(c[n>>2]|0)){o=0;qa(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=24;break}else continue}else{c[m>>2]=k+1;continue}}if((D|0)==24){b=cc()|0;break}E=a[C>>0]|0;if((((E&1)==0?(E&255)>>>1:c[C+4>>2]|0)|0)!=0?(x=c[z>>2]|0,(x-y|0)<160):0){E=c[w>>2]|0;c[z>>2]=x+4;c[x>>2]=E}o=0;g=kb(69,g|0,c[v>>2]|0,h|0,u|0)|0;E=o;o=0;if(!(E&1)){c[j>>2]=g;oH(C,y,c[z>>2]|0,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(k){if((c[k+12>>2]|0)==(c[k+16>>2]|0)){o=0;b=qa(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;E=o;o=0;if(E&1){D=25;break a}if((b|0)==-1){c[f>>2]=0;D=49;break}}if(!g)D=50}else D=49;while(0);if((D|0)==49?g:0)D=50;if((D|0)==50)c[h>>2]=c[h>>2]|2;E=c[e>>2]|0;IC(B);IC(C);i=A;return E|0}else D=25}else D=25;while(0);if((D|0)==25)b=cc()|0;IC(B);IC(C);bc(b|0);return 0}function VJ(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0;A=i;i=i+240|0;t=A+202|0;k=A+200|0;C=A+24|0;B=A+12|0;v=A+8|0;y=A+40|0;z=A+4|0;w=A;u=DJ(g)|0;GE(C,g,t,k);c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;o=0;mb(80,B|0,b|0,0);s=o;o=0;a:do if(!(s&1)){q=B+8|0;r=B+1|0;g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g;c[z>>2]=y;c[w>>2]=0;s=B+4|0;p=a[k>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;k=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;n=o;o=0;if(n&1){E=24;break}if((k|0)==-1){c[e>>2]=0;b=0}}}else b=0;k=(b|0)==0;l=c[f>>2]|0;do if(l){if((c[l+12>>2]|0)!=(c[l+16>>2]|0))if(k)break;else break b;o=0;m=qa(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;n=o;o=0;if(n&1){E=24;break b}if((m|0)!=-1)if(k)break;else break b;else{c[f>>2]=0;E=16;break}}else E=16;while(0);if((E|0)==16){E=0;if(k){l=0;break}else l=0}k=a[B>>0]|0;k=(k&1)==0?(k&255)>>>1:c[s>>2]|0;if((c[v>>2]|0)==(g+k|0)){o=0;mb(80,B|0,k<<1|0,0);n=o;o=0;if(n&1){E=24;break}if(!(a[B>>0]&1))g=10;else g=(c[B>>2]&-2)+-1|0;o=0;mb(80,B|0,g|0,0);n=o;o=0;if(n&1){E=24;break}g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g+k}m=b+12|0;k=c[m>>2]|0;n=b+16|0;if((k|0)==(c[n>>2]|0)){o=0;k=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;F=o;o=0;if(F&1){E=24;break}}else k=d[k>>0]|0;if(qE(k&255,u,g,v,w,p,C,y,z,t)|0)break;k=c[m>>2]|0;if((k|0)==(c[n>>2]|0)){o=0;qa(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;F=o;o=0;if(F&1){E=24;break}else continue}else{c[m>>2]=k+1;continue}}if((E|0)==24){b=cc()|0;break}F=a[C>>0]|0;if((((F&1)==0?(F&255)>>>1:c[C+4>>2]|0)|0)!=0?(x=c[z>>2]|0,(x-y|0)<160):0){F=c[w>>2]|0;c[z>>2]=x+4;c[x>>2]=F}o=0;g=kb(70,g|0,c[v>>2]|0,h|0,u|0)|0;k=D;F=o;o=0;if(!(F&1)){F=j;c[F>>2]=g;c[F+4>>2]=k;oH(C,y,c[z>>2]|0,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;F=o;o=0;if(F&1){E=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)){o=0;b=qa(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;F=o;o=0;if(F&1){E=25;break a}if((b|0)==-1){c[f>>2]=0;E=49;break}}if(!g)E=50}else E=49;while(0);if((E|0)==49?g:0)E=50;if((E|0)==50)c[h>>2]=c[h>>2]|2;F=c[e>>2]|0;IC(B);IC(C);i=A;return F|0}else E=25}else E=25;while(0);if((E|0)==25)b=cc()|0;IC(B);IC(C);bc(b|0);return 0}function WJ(e,f,g,h,j,k){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;B=i;i=i+240|0;u=B+202|0;l=B+200|0;D=B+24|0;C=B+12|0;w=B+8|0;z=B+40|0;A=B+4|0;x=B;v=DJ(h)|0;GE(D,h,u,l);c[C>>2]=0;c[C+4>>2]=0;c[C+8>>2]=0;if(!(a[C>>0]&1))e=10;else e=(c[C>>2]&-2)+-1|0;o=0;mb(80,C|0,e|0,0);t=o;o=0;a:do if(!(t&1)){r=C+8|0;s=C+1|0;h=(a[C>>0]&1)==0?s:c[r>>2]|0;c[w>>2]=h;c[A>>2]=z;c[x>>2]=0;t=C+4|0;q=a[l>>0]|0;e=c[f>>2]|0;b:while(1){if(e){if((c[e+12>>2]|0)==(c[e+16>>2]|0)){o=0;l=qa(c[(c[e>>2]|0)+36>>2]|0,e|0)|0;p=o;o=0;if(p&1){E=24;break}if((l|0)==-1){c[f>>2]=0;e=0}}}else e=0;m=(e|0)==0;l=c[g>>2]|0;do if(l){if((c[l+12>>2]|0)!=(c[l+16>>2]|0))if(m)break;else break b;o=0;n=qa(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;p=o;o=0;if(p&1){E=24;break b}if((n|0)!=-1)if(m)break;else break b;else{c[g>>2]=0;E=16;break}}else E=16;while(0);if((E|0)==16){E=0;if(m){l=0;break}else l=0}m=a[C>>0]|0;m=(m&1)==0?(m&255)>>>1:c[t>>2]|0;if((c[w>>2]|0)==(h+m|0)){o=0;mb(80,C|0,m<<1|0,0);p=o;o=0;if(p&1){E=24;break}if(!(a[C>>0]&1))h=10;else h=(c[C>>2]&-2)+-1|0;o=0;mb(80,C|0,h|0,0);p=o;o=0;if(p&1){E=24;break}h=(a[C>>0]&1)==0?s:c[r>>2]|0;c[w>>2]=h+m}n=e+12|0;m=c[n>>2]|0;p=e+16|0;if((m|0)==(c[p>>2]|0)){o=0;m=qa(c[(c[e>>2]|0)+36>>2]|0,e|0)|0;F=o;o=0;if(F&1){E=24;break}}else m=d[m>>0]|0;if(qE(m&255,v,h,w,x,q,D,z,A,u)|0)break;l=c[n>>2]|0;if((l|0)==(c[p>>2]|0)){o=0;qa(c[(c[e>>2]|0)+40>>2]|0,e|0)|0;F=o;o=0;if(F&1){E=24;break}else continue}else{c[n>>2]=l+1;continue}}if((E|0)==24){e=cc()|0;break}F=a[D>>0]|0;if((((F&1)==0?(F&255)>>>1:c[D+4>>2]|0)|0)!=0?(y=c[A>>2]|0,(y-z|0)<160):0){F=c[x>>2]|0;c[A>>2]=y+4;c[y>>2]=F}o=0;h=kb(71,h|0,c[w>>2]|0,j|0,v|0)|0;F=o;o=0;if(!(F&1)){b[k>>1]=h;oH(D,z,c[A>>2]|0,j);if(e){if((c[e+12>>2]|0)==(c[e+16>>2]|0)){o=0;h=qa(c[(c[e>>2]|0)+36>>2]|0,e|0)|0;F=o;o=0;if(F&1){E=25;break}if((h|0)==-1){c[f>>2]=0;e=0}}}else e=0;h=(e|0)==0;do if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)){o=0;e=qa(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;F=o;o=0;if(F&1){E=25;break a}if((e|0)==-1){c[g>>2]=0;E=49;break}}if(!h)E=50}else E=49;while(0);if((E|0)==49?h:0)E=50;if((E|0)==50)c[j>>2]=c[j>>2]|2;F=c[f>>2]|0;IC(C);IC(D);i=B;return F|0}else E=25}else E=25;while(0);if((E|0)==25)e=cc()|0;IC(C);IC(D);bc(e|0);return 0}function XJ(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;A=i;i=i+240|0;t=A+202|0;k=A+200|0;C=A+24|0;B=A+12|0;v=A+8|0;y=A+40|0;z=A+4|0;w=A;u=DJ(g)|0;GE(C,g,t,k);c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;o=0;mb(80,B|0,b|0,0);s=o;o=0;a:do if(!(s&1)){q=B+8|0;r=B+1|0;g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g;c[z>>2]=y;c[w>>2]=0;s=B+4|0;p=a[k>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;k=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;n=o;o=0;if(n&1){D=24;break}if((k|0)==-1){c[e>>2]=0;b=0}}}else b=0;l=(b|0)==0;k=c[f>>2]|0;do if(k){if((c[k+12>>2]|0)!=(c[k+16>>2]|0))if(l)break;else break b;o=0;m=qa(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;n=o;o=0;if(n&1){D=24;break b}if((m|0)!=-1)if(l)break;else break b;else{c[f>>2]=0;D=16;break}}else D=16;while(0);if((D|0)==16){D=0;if(l){k=0;break}else k=0}l=a[B>>0]|0;l=(l&1)==0?(l&255)>>>1:c[s>>2]|0;if((c[v>>2]|0)==(g+l|0)){o=0;mb(80,B|0,l<<1|0,0);n=o;o=0;if(n&1){D=24;break}if(!(a[B>>0]&1))g=10;else g=(c[B>>2]&-2)+-1|0;o=0;mb(80,B|0,g|0,0);n=o;o=0;if(n&1){D=24;break}g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g+l}m=b+12|0;l=c[m>>2]|0;n=b+16|0;if((l|0)==(c[n>>2]|0)){o=0;l=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=24;break}}else l=d[l>>0]|0;if(qE(l&255,u,g,v,w,p,C,y,z,t)|0)break;k=c[m>>2]|0;if((k|0)==(c[n>>2]|0)){o=0;qa(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=24;break}else continue}else{c[m>>2]=k+1;continue}}if((D|0)==24){b=cc()|0;break}E=a[C>>0]|0;if((((E&1)==0?(E&255)>>>1:c[C+4>>2]|0)|0)!=0?(x=c[z>>2]|0,(x-y|0)<160):0){E=c[w>>2]|0;c[z>>2]=x+4;c[x>>2]=E}o=0;g=kb(72,g|0,c[v>>2]|0,h|0,u|0)|0;E=o;o=0;if(!(E&1)){c[j>>2]=g;oH(C,y,c[z>>2]|0,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(k){if((c[k+12>>2]|0)==(c[k+16>>2]|0)){o=0;b=qa(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;E=o;o=0;if(E&1){D=25;break a}if((b|0)==-1){c[f>>2]=0;D=49;break}}if(!g)D=50}else D=49;while(0);if((D|0)==49?g:0)D=50;if((D|0)==50)c[h>>2]=c[h>>2]|2;E=c[e>>2]|0;IC(B);IC(C);i=A;return E|0}else D=25}else D=25;while(0);if((D|0)==25)b=cc()|0;IC(B);IC(C);bc(b|0);return 0}function YJ(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;A=i;i=i+240|0;t=A+202|0;k=A+200|0;C=A+24|0;B=A+12|0;v=A+8|0;y=A+40|0;z=A+4|0;w=A;u=DJ(g)|0;GE(C,g,t,k);c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;o=0;mb(80,B|0,b|0,0);s=o;o=0;a:do if(!(s&1)){q=B+8|0;r=B+1|0;g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g;c[z>>2]=y;c[w>>2]=0;s=B+4|0;p=a[k>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;k=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;n=o;o=0;if(n&1){D=24;break}if((k|0)==-1){c[e>>2]=0;b=0}}}else b=0;l=(b|0)==0;k=c[f>>2]|0;do if(k){if((c[k+12>>2]|0)!=(c[k+16>>2]|0))if(l)break;else break b;o=0;m=qa(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;n=o;o=0;if(n&1){D=24;break b}if((m|0)!=-1)if(l)break;else break b;else{c[f>>2]=0;D=16;break}}else D=16;while(0);if((D|0)==16){D=0;if(l){k=0;break}else k=0}l=a[B>>0]|0;l=(l&1)==0?(l&255)>>>1:c[s>>2]|0;if((c[v>>2]|0)==(g+l|0)){o=0;mb(80,B|0,l<<1|0,0);n=o;o=0;if(n&1){D=24;break}if(!(a[B>>0]&1))g=10;else g=(c[B>>2]&-2)+-1|0;o=0;mb(80,B|0,g|0,0);n=o;o=0;if(n&1){D=24;break}g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g+l}m=b+12|0;l=c[m>>2]|0;n=b+16|0;if((l|0)==(c[n>>2]|0)){o=0;l=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=24;break}}else l=d[l>>0]|0;if(qE(l&255,u,g,v,w,p,C,y,z,t)|0)break;k=c[m>>2]|0;if((k|0)==(c[n>>2]|0)){o=0;qa(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=24;break}else continue}else{c[m>>2]=k+1;continue}}if((D|0)==24){b=cc()|0;break}E=a[C>>0]|0;if((((E&1)==0?(E&255)>>>1:c[C+4>>2]|0)|0)!=0?(x=c[z>>2]|0,(x-y|0)<160):0){E=c[w>>2]|0;c[z>>2]=x+4;c[x>>2]=E}o=0;g=kb(73,g|0,c[v>>2]|0,h|0,u|0)|0;E=o;o=0;if(!(E&1)){c[j>>2]=g;oH(C,y,c[z>>2]|0,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(k){if((c[k+12>>2]|0)==(c[k+16>>2]|0)){o=0;b=qa(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;E=o;o=0;if(E&1){D=25;break a}if((b|0)==-1){c[f>>2]=0;D=49;break}}if(!g)D=50}else D=49;while(0);if((D|0)==49?g:0)D=50;if((D|0)==50)c[h>>2]=c[h>>2]|2;E=c[e>>2]|0;IC(B);IC(C);i=A;return E|0}else D=25}else D=25;while(0);if((D|0)==25)b=cc()|0;IC(B);IC(C);bc(b|0);return 0}function ZJ(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0;A=i;i=i+240|0;t=A+202|0;k=A+200|0;C=A+24|0;B=A+12|0;v=A+8|0;y=A+40|0;z=A+4|0;w=A;u=DJ(g)|0;GE(C,g,t,k);c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;o=0;mb(80,B|0,b|0,0);s=o;o=0;a:do if(!(s&1)){q=B+8|0;r=B+1|0;g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g;c[z>>2]=y;c[w>>2]=0;s=B+4|0;p=a[k>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;k=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;n=o;o=0;if(n&1){E=24;break}if((k|0)==-1){c[e>>2]=0;b=0}}}else b=0;k=(b|0)==0;l=c[f>>2]|0;do if(l){if((c[l+12>>2]|0)!=(c[l+16>>2]|0))if(k)break;else break b;o=0;m=qa(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;n=o;o=0;if(n&1){E=24;break b}if((m|0)!=-1)if(k)break;else break b;else{c[f>>2]=0;E=16;break}}else E=16;while(0);if((E|0)==16){E=0;if(k){l=0;break}else l=0}k=a[B>>0]|0;k=(k&1)==0?(k&255)>>>1:c[s>>2]|0;if((c[v>>2]|0)==(g+k|0)){o=0;mb(80,B|0,k<<1|0,0);n=o;o=0;if(n&1){E=24;break}if(!(a[B>>0]&1))g=10;else g=(c[B>>2]&-2)+-1|0;o=0;mb(80,B|0,g|0,0);n=o;o=0;if(n&1){E=24;break}g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g+k}m=b+12|0;k=c[m>>2]|0;n=b+16|0;if((k|0)==(c[n>>2]|0)){o=0;k=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;F=o;o=0;if(F&1){E=24;break}}else k=d[k>>0]|0;if(qE(k&255,u,g,v,w,p,C,y,z,t)|0)break;k=c[m>>2]|0;if((k|0)==(c[n>>2]|0)){o=0;qa(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;F=o;o=0;if(F&1){E=24;break}else continue}else{c[m>>2]=k+1;continue}}if((E|0)==24){b=cc()|0;break}F=a[C>>0]|0;if((((F&1)==0?(F&255)>>>1:c[C+4>>2]|0)|0)!=0?(x=c[z>>2]|0,(x-y|0)<160):0){F=c[w>>2]|0;c[z>>2]=x+4;c[x>>2]=F}o=0;g=kb(74,g|0,c[v>>2]|0,h|0,u|0)|0;k=D;F=o;o=0;if(!(F&1)){F=j;c[F>>2]=g;c[F+4>>2]=k;oH(C,y,c[z>>2]|0,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;F=o;o=0;if(F&1){E=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)){o=0;b=qa(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;F=o;o=0;if(F&1){E=25;break a}if((b|0)==-1){c[f>>2]=0;E=49;break}}if(!g)E=50}else E=49;while(0);if((E|0)==49?g:0)E=50;if((E|0)==50)c[h>>2]=c[h>>2]|2;F=c[e>>2]|0;IC(B);IC(C);i=A;return F|0}else E=25}else E=25;while(0);if((E|0)==25)b=cc()|0;IC(B);IC(C);bc(b|0);return 0}function _J(b,e,f,h,j,k){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0.0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;E=i;i=i+240|0;w=E+208|0;m=E+203|0;n=E+202|0;G=E+24|0;F=E+12|0;y=E+8|0;C=E+40|0;D=E+4|0;z=E;A=E+201|0;x=E+200|0;HE(G,h,w,m,n);c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;if(!(a[F>>0]&1))b=10;else b=(c[F>>2]&-2)+-1|0;o=0;mb(80,F|0,b|0,0);v=o;o=0;a:do if(!(v&1)){t=F+8|0;u=F+1|0;h=(a[F>>0]&1)==0?u:c[t>>2]|0;c[y>>2]=h;c[D>>2]=C;c[z>>2]=0;a[A>>0]=1;a[x>>0]=69;v=F+4|0;s=a[m>>0]|0;r=a[n>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;m=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;q=o;o=0;if(q&1){H=24;break}if((m|0)==-1){c[e>>2]=0;b=0}}}else b=0;n=(b|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(n)break;else break b;o=0;p=qa(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;q=o;o=0;if(q&1){H=24;break b}if((p|0)!=-1)if(n)break;else break b;else{c[f>>2]=0;H=16;break}}else H=16;while(0);if((H|0)==16){H=0;if(n){m=0;break}else m=0}n=a[F>>0]|0;n=(n&1)==0?(n&255)>>>1:c[v>>2]|0;if((c[y>>2]|0)==(h+n|0)){o=0;mb(80,F|0,n<<1|0,0);q=o;o=0;if(q&1){H=24;break}if(!(a[F>>0]&1))h=10;else h=(c[F>>2]&-2)+-1|0;o=0;mb(80,F|0,h|0,0);q=o;o=0;if(q&1){H=24;break}h=(a[F>>0]&1)==0?u:c[t>>2]|0;c[y>>2]=h+n}p=b+12|0;n=c[p>>2]|0;q=b+16|0;if((n|0)==(c[q>>2]|0)){o=0;n=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=24;break}}else n=d[n>>0]|0;if(IE(n&255,A,x,h,y,s,r,G,C,D,z,w)|0)break;m=c[p>>2]|0;if((m|0)==(c[q>>2]|0)){o=0;qa(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=24;break}else continue}else{c[p>>2]=m+1;continue}}if((H|0)==24){b=cc()|0;break}I=a[G>>0]|0;if(!((a[A>>0]|0)==0?1:(((I&1)==0?(I&255)>>>1:c[G+4>>2]|0)|0)==0)?(B=c[D>>2]|0,(B-C|0)<160):0){I=c[z>>2]|0;c[D>>2]=B+4;c[B>>2]=I}o=0;l=+_a(44,h|0,c[y>>2]|0,j|0);I=o;o=0;if(!(I&1)){g[k>>2]=l;oH(G,C,c[D>>2]|0,j);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;h=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=25;break}if((h|0)==-1){c[e>>2]=0;b=0}}}else b=0;h=(b|0)==0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)){o=0;b=qa(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;I=o;o=0;if(I&1){H=25;break a}if((b|0)==-1){c[f>>2]=0;H=49;break}}if(!h)H=50}else H=49;while(0);if((H|0)==49?h:0)H=50;if((H|0)==50)c[j>>2]=c[j>>2]|2;I=c[e>>2]|0;IC(F);IC(G);i=E;return I|0}else H=25}else H=25;while(0);if((H|0)==25)b=cc()|0;IC(F);IC(G);bc(b|0);return 0}function $J(b,e,f,g,j,k){b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;var l=0.0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;E=i;i=i+240|0;w=E+208|0;m=E+203|0;n=E+202|0;G=E+24|0;F=E+12|0;y=E+8|0;C=E+40|0;D=E+4|0;z=E;A=E+201|0;x=E+200|0;HE(G,g,w,m,n);c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;if(!(a[F>>0]&1))b=10;else b=(c[F>>2]&-2)+-1|0;o=0;mb(80,F|0,b|0,0);v=o;o=0;a:do if(!(v&1)){t=F+8|0;u=F+1|0;g=(a[F>>0]&1)==0?u:c[t>>2]|0;c[y>>2]=g;c[D>>2]=C;c[z>>2]=0;a[A>>0]=1;a[x>>0]=69;v=F+4|0;s=a[m>>0]|0;r=a[n>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;m=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;q=o;o=0;if(q&1){H=24;break}if((m|0)==-1){c[e>>2]=0;b=0}}}else b=0;n=(b|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(n)break;else break b;o=0;p=qa(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;q=o;o=0;if(q&1){H=24;break b}if((p|0)!=-1)if(n)break;else break b;else{c[f>>2]=0;H=16;break}}else H=16;while(0);if((H|0)==16){H=0;if(n){m=0;break}else m=0}n=a[F>>0]|0;n=(n&1)==0?(n&255)>>>1:c[v>>2]|0;if((c[y>>2]|0)==(g+n|0)){o=0;mb(80,F|0,n<<1|0,0);q=o;o=0;if(q&1){H=24;break}if(!(a[F>>0]&1))g=10;else g=(c[F>>2]&-2)+-1|0;o=0;mb(80,F|0,g|0,0);q=o;o=0;if(q&1){H=24;break}g=(a[F>>0]&1)==0?u:c[t>>2]|0;c[y>>2]=g+n}p=b+12|0;n=c[p>>2]|0;q=b+16|0;if((n|0)==(c[q>>2]|0)){o=0;n=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=24;break}}else n=d[n>>0]|0;if(IE(n&255,A,x,g,y,s,r,G,C,D,z,w)|0)break;m=c[p>>2]|0;if((m|0)==(c[q>>2]|0)){o=0;qa(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=24;break}else continue}else{c[p>>2]=m+1;continue}}if((H|0)==24){b=cc()|0;break}I=a[G>>0]|0;if(!((a[A>>0]|0)==0?1:(((I&1)==0?(I&255)>>>1:c[G+4>>2]|0)|0)==0)?(B=c[D>>2]|0,(B-C|0)<160):0){I=c[z>>2]|0;c[D>>2]=B+4;c[B>>2]=I}o=0;l=+_a(45,g|0,c[y>>2]|0,j|0);I=o;o=0;if(!(I&1)){h[k>>3]=l;oH(G,C,c[D>>2]|0,j);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)){o=0;b=qa(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;I=o;o=0;if(I&1){H=25;break a}if((b|0)==-1){c[f>>2]=0;H=49;break}}if(!g)H=50}else H=49;while(0);if((H|0)==49?g:0)H=50;if((H|0)==50)c[j>>2]=c[j>>2]|2;I=c[e>>2]|0;IC(F);IC(G);i=E;return I|0}else H=25}else H=25;while(0);if((H|0)==25)b=cc()|0;IC(F);IC(G);bc(b|0);return 0}function aK(b,e,f,g,j,k){b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;var l=0.0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;E=i;i=i+240|0;w=E+208|0;m=E+203|0;n=E+202|0;G=E+24|0;F=E+12|0;y=E+8|0;C=E+40|0;D=E+4|0;z=E;A=E+201|0;x=E+200|0;HE(G,g,w,m,n);c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;if(!(a[F>>0]&1))b=10;else b=(c[F>>2]&-2)+-1|0;o=0;mb(80,F|0,b|0,0);v=o;o=0;a:do if(!(v&1)){t=F+8|0;u=F+1|0;g=(a[F>>0]&1)==0?u:c[t>>2]|0;c[y>>2]=g;c[D>>2]=C;c[z>>2]=0;a[A>>0]=1;a[x>>0]=69;v=F+4|0;s=a[m>>0]|0;r=a[n>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;m=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;q=o;o=0;if(q&1){H=24;break}if((m|0)==-1){c[e>>2]=0;b=0}}}else b=0;n=(b|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(n)break;else break b;o=0;p=qa(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;q=o;o=0;if(q&1){H=24;break b}if((p|0)!=-1)if(n)break;else break b;else{c[f>>2]=0;H=16;break}}else H=16;while(0);if((H|0)==16){H=0;if(n){m=0;break}else m=0}n=a[F>>0]|0;n=(n&1)==0?(n&255)>>>1:c[v>>2]|0;if((c[y>>2]|0)==(g+n|0)){o=0;mb(80,F|0,n<<1|0,0);q=o;o=0;if(q&1){H=24;break}if(!(a[F>>0]&1))g=10;else g=(c[F>>2]&-2)+-1|0;o=0;mb(80,F|0,g|0,0);q=o;o=0;if(q&1){H=24;break}g=(a[F>>0]&1)==0?u:c[t>>2]|0;c[y>>2]=g+n}p=b+12|0;n=c[p>>2]|0;q=b+16|0;if((n|0)==(c[q>>2]|0)){o=0;n=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=24;break}}else n=d[n>>0]|0;if(IE(n&255,A,x,g,y,s,r,G,C,D,z,w)|0)break;m=c[p>>2]|0;if((m|0)==(c[q>>2]|0)){o=0;qa(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=24;break}else continue}else{c[p>>2]=m+1;continue}}if((H|0)==24){b=cc()|0;break}I=a[G>>0]|0;if(!((a[A>>0]|0)==0?1:(((I&1)==0?(I&255)>>>1:c[G+4>>2]|0)|0)==0)?(B=c[D>>2]|0,(B-C|0)<160):0){I=c[z>>2]|0;c[D>>2]=B+4;c[B>>2]=I}o=0;l=+_a(46,g|0,c[y>>2]|0,j|0);I=o;o=0;if(!(I&1)){h[k>>3]=l;oH(G,C,c[D>>2]|0,j);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=qa(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)){o=0;b=qa(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;I=o;o=0;if(I&1){H=25;break a}if((b|0)==-1){c[f>>2]=0;H=49;break}}if(!g)H=50}else H=49;while(0);if((H|0)==49?g:0)H=50;if((H|0)==50)c[j>>2]=c[j>>2]|2;I=c[e>>2]|0;IC(F);IC(G);i=E;return I|0}else H=25}else H=25;while(0);if((H|0)==25)b=cc()|0;IC(F);IC(G);bc(b|0);return 0}function bK(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;c[g>>2]=e;e=lB(b)|0;b=YB(a,d,g)|0;if((e|0)!=0?(o=0,qa(193,e|0)|0,g=o,o=0,g&1):0){g=cc(0)|0;oq(g)}i=f;return b|0}function cK(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;y=i;i=i+112|0;l=y;n=(f-e|0)/12|0;do if(n>>>0>100){l=yC(n)|0;if((l|0)==0?(o=0,ob(46),x=o,o=0,x&1):0){k=0;q=6;break}k=l;q=11}else{k=0;q=11}while(0);a:do if((q|0)==11){if((e|0)==(f|0))m=0;else{r=e;p=0;q=l;while(1){m=a[r>>0]|0;if(!(m&1))m=