define(["jquery","core/log"],(function($,log){return log.debug("Interactive Transcript: initialising"),{init:function(opts){var component=opts.component,playerid=opts.playerid,containerid=opts.containerid,cssprefix=opts.cssprefix,config={settings:{}};if(playerid&&$("#"+playerid).length){config.component=component,config.prefix=cssprefix,config.player=$("#"+playerid)[0],config.title=M.util.get_string("transcripttitle",component),this.doPolyfills();var transcript=this.transcript(config);$("#"+containerid).append(transcript.el())}},doPolyfills:function(){for(var lastTime=0,vendors=["ms","moz","webkit","o"],x=0;x<vendors.length&&!window.requestAnimationFrame;++x)window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"];window.requestAnimationFrame||(window.requestAnimationFrame=function(callback,element){var currTime=(new Date).getTime(),timeToCall=Math.max(0,16-(currTime-lastTime)),id=window.setTimeout((function(){callback(currTime+timeToCall)}),timeToCall);return lastTime=currTime+timeToCall,id}),window.cancelAnimationFrame||(window.cancelAnimationFrame=function(id){clearTimeout(id)}),"function"!=typeof Object.create&&(Object.create=function(){var Object=function(){};return function(prototype){if(arguments.length>1)throw Error("Second argument not supported");if("object"!=typeof prototype)throw TypeError("Argument must be an object");Object.prototype=prototype;var result={};return Object.prototype=null,result}}()),Array.prototype.forEach||(Array.prototype.forEach=function(callback,thisArg){var T,k;if(null==this)throw new TypeError(" this is null or not defined");var O=Object(this),len=O.length>>>0;if("function"!=typeof callback)throw new TypeError(callback+" is not a function");for(arguments.length>1&&(T=thisArg),k=0;k<len;){var kValue;k in O&&(kValue=O[k],callback.call(T,kValue,k,O)),k++}}),"document"in self&&!("classList"in document.createElement("_"))&&function(j){if("Element"in j){var a="classList",f="prototype",m=j.Element[f],b=Object,k=String[f].trim||function(){return this.replace(/^\s+|\s+$/g,"")},c=Array[f].indexOf||function(q){for(var p=0,o=this.length;p<o;p++)if(p in this&&this[p]===q)return p;return-1},n=function(o,p){this.name=o,this.code=DOMException[o],this.message=p},g=function(p,o){if(""===o)throw new n("SYNTAX_ERR","An invalid or illegal string was specified");if(/\s/.test(o))throw new n("INVALID_CHARACTER_ERR","String contains an invalid character");return c.call(p,o)},d=function(s){for(var r=k.call(s.getAttribute("class")||""),q=r?r.split(/\s+/):[],p=0,o=q.length;p<o;p++)this.push(q[p]);this._updateClassName=function(){s.setAttribute("class",this.toString())}},e=d[f]=[],i=function(){return new d(this)};if(n[f]=Error[f],e.item=function(o){return this[o]||null},e.contains=function(o){return-1!==g(this,o+="")},e.add=function(){var q,s=arguments,r=0,p=s.length,o=!1;do{q=s[r]+"",-1===g(this,q)&&(this.push(q),o=!0)}while(++r<p);o&&this._updateClassName()},e.remove=function(){var r,t=arguments,s=0,p=t.length,o=!1;do{r=t[s]+"";var q=g(this,r);-1!==q&&(this.splice(q,1),o=!0)}while(++s<p);o&&this._updateClassName()},e.toggle=function(p,q){p+="";var o=this.contains(p),r=o?!0!==q&&"remove":!1!==q&&"add";return r&&this[r](p),!o},e.toString=function(){return this.join(" ")},b.defineProperty){var l={get:i,enumerable:!0,configurable:!0};try{b.defineProperty(m,a,l)}catch(h){-2146823252===h.number&&(l.enumerable=!1,b.defineProperty(m,a,l))}}else b[f].__defineGetter__&&m.__defineGetter__(a,i)}}(self)},defaults:{autoscroll:!0,clickArea:"line",showTitle:!0,showTrackSelector:!1,followPlayerTrack:!0,scrollToCenter:!1,stopScrollWhenInUse:!0},utils:{prefix:"transcript",secondsToTime:function(timeInSeconds){var hour=Math.floor(timeInSeconds/3600),min=Math.floor(timeInSeconds%3600/60),sec=Math.floor(timeInSeconds%60);return sec=sec<10?"0"+sec:sec,min=hour>0&&min<10?"0"+min:min,hour>0?hour+":"+min+":"+sec:min+":"+sec},localize:function(string){return string},createEl:function(elementName,className){className=className||"";var el=document.createElement(elementName);return el.className=className,el},extend:function(obj){var source,prop,type=typeof obj;if(!("function"===type||"object"===type&&obj))return obj;for(var i=1,length=arguments.length;i<length;i++)for(prop in source=arguments[i])obj[prop]=source[prop];return obj}},eventEmitter:{handlers_:[],on:function(object,eventtype,callback){if("function"!=typeof callback)throw new TypeError("Callback is not a function.");this.handlers_.push([object,eventtype,callback])},trigger:function(object,eventtype){this.handlers_.forEach((function(h){h[0]===object&&h[1]===eventtype&&h[2].apply()}))}},scrollerProto:function(config){var initHandlers=function(el){var self=this;el.addEventListener("scroll",(function(){self.isAutoScrolling?self.isAutoScrolling=!1:(self.userIsScrolling=!0,el.classList.add("is-inuse"))})),el.addEventListener("mouseenter",(function(){self.mouseIsOverTranscript=!0})),el.addEventListener("mouseleave",(function(){self.mouseIsOverTranscript=!1,setTimeout((function(){self.mouseIsOverTranscript||(self.userIsScrolling=!1,el.classList.remove("is-inuse"))}),1e3)}))},scrollTo=function(element,newPos,duration){var startTime=Date.now(),startPos=element.scrollTop,self=this;newPos=Math.max(0,newPos);var change=(newPos=Math.min(element.scrollHeight-element.clientHeight,newPos))-startPos,updateScroll=function(){var time=Date.now()-startTime;self.isAutoScrolling=!0,element.scrollTop=function(time,start,change,duration){return start+change*Math.sin(Math.min(1,time/duration)*(Math.PI/2))}(time,startPos,change,duration),element.scrollTop!==newPos&&requestAnimationFrame(updateScroll,element)};requestAnimationFrame(updateScroll,element)};return{init:function(element){return this.element=element,this.userIsScrolling=!1,this.mouseIsOverTranscript=!0,this.isAutoScrolling=!0,initHandlers.call(this,this.element),this},to:function(element){if(this.canScroll()){var newPos,parent=element.parentElement,elementOffsetBottom=(parent.offsetTop,parent.clientHeight,element.offsetTop+element.clientHeight),relTop=element.offsetTop,relBottom=element.offsetTop+element.clientHeight,centerPosCorrection=0;config.settings.scrollToCenter&&(centerPosCorrection=Math.round(parent.clientHeight/2-element.clientHeight/2)),relTop<parent.scrollTop+centerPosCorrection?newPos=element.offsetTop-centerPosCorrection:relBottom>parent.scrollTop+parent.clientHeight-centerPosCorrection&&(newPos=elementOffsetBottom+centerPosCorrection),void 0!==newPos&&parent.scrollTop!==newPos&&scrollTo.call(this,parent,newPos,400)}},canScroll:function(){var el=this.element;return el.scrollHeight>el.offsetHeight},inUse:function(){return this.userIsScrolling}}},scroller:function(element,config){return Object.create(this.scrollerProto(config)).init(element)},trackList:function(config){var activeTrack;return{get:function(){var i,track,validTracks=[];for(config.tracks=config.player.textTracks,i=0;i<config.tracks.length;i++)"captions"!==(track=config.tracks[i]).kind&&"subtitles"!==track.kind||validTracks.push(track);return validTracks},active:function(tracks){var i,track;for(i=0;i<config.tracks.length;i++)if("showing"===(track=config.tracks[i]).mode)return activeTrack=track,track;return activeTrack||tracks[0]}}},widget:function(config){var that=this,thewidget={element:{},body:{}},trigger=function(event){eventEmitter.trigger(that,event)},clickToSeekHandler=function(event){var clickedClasses=event.target.classList,clickedTime=event.target.getAttribute("data-begin")||event.target.parentElement.getAttribute("data-begin");null!=clickedTime&&("line"===config.settings.clickArea||"timestamp"===config.settings.clickArea&&clickedClasses.contains(config.prefix+"-timestamp")||"text"===config.settings.clickArea&&clickedClasses.contains(config.prefix+"-text"))&&(config.player.currentTime=clickedTime)},createLine=function(cue){var line=that.utils.createEl("div",config.prefix+"-line"),timestamp=that.utils.createEl("span",config.prefix+"-timestamp"),text=that.utils.createEl("span",config.prefix+"-text");return line.setAttribute("data-begin",cue.startTime),line.setAttribute("tabindex",thewidget._options.tabIndex||0),timestamp.textContent=that.utils.secondsToTime(cue.startTime),text.innerHTML=cue.text,line.appendChild(timestamp),line.appendChild(text),line},createTranscriptBody=function(track){"object"!=typeof track&&(track=config.player.textTracks()[track]);var line,i,body=that.utils.createEl("div",config.prefix+"-body"),fragment=document.createDocumentFragment();if(track.activeCues){var cues=track.cues;for(i=0;i<cues.length;i++)line=createLine(cues[i]),fragment.appendChild(line);body.innerHTML="",body.appendChild(fragment),body.setAttribute("lang",track.language),body.scroll=that.scroller(body,config),body.addEventListener("click",clickToSeekHandler),thewidget.element.replaceChild(body,thewidget.body),thewidget.body=body}else"showing"!==track.mode&&(track.mode="hidden"),window.setTimeout((function(){createTranscriptBody(track)}),100)},setTrack=function(track,trackCreated){createTranscriptBody(track,trackCreated)};return{create:function(options){var header,el=document.createElement("div");if(thewidget._options=options,thewidget.element=el,el.setAttribute("id",config.prefix+"-"+config.player.id),config.settings.showTitle){var title=((header=that.utils.createEl("header",config.prefix+"-header")).textContent=config.title,header);el.appendChild(title)}if(config.settings.showTrackSelector){var selector=function(){var selector=that.utils.createEl("select",config.prefix+"-selector");return config.validTracks.forEach((function(track,i){var option=document.createElement("option");option.value=i,option.textContent=track.label+" ("+track.language+")",selector.appendChild(option)})),selector.addEventListener("change",(function(e){setTrack(document.querySelector("#"+config.prefix+"-"+config.player.id+" option:checked").value),trigger("trackchanged")})),selector}();el.appendChild(selector)}return thewidget.body=that.utils.createEl("div",config.prefix+"-body"),el.appendChild(thewidget.body),setTrack(config.currentTrack),this},setTrack:setTrack,setCue:function(time){var i,line,begin,end,lines=thewidget.body.children;for(i=0;i<lines.length;i++)begin=(line=lines[i]).getAttribute("data-begin"),end=i<lines.length-1?lines[i+1].getAttribute("data-begin"):config.player.duration||1/0,time>begin&&time<end?line.classList.contains("is-active")||(line.classList.add("is-active"),!config.settings.autoscroll||config.settings.stopScrollWhenInUse&&thewidget.body.scroll.inUse()||thewidget.body.scroll.to(line)):line.classList.remove("is-active")},el:function(){return thewidget.element},on:function(event,callback){eventEmitter.on(that,event,callback)},trigger:trigger}},transcript:function(config){var that=this,options=this.defaults;this.utils.prefix="transcript",config.validTracks=this.trackList(config).get(),config.currentTrack=this.trackList(config).active(config.validTracks),config.settings=options,config.widget=this.widget(config).create(options);var updateTrack=function(){config.currentTrack=that.trackList(config).active(config.validTracks),config.widget.setTrack(config.currentTrack)};if(!(config.validTracks.length>0))throw new Error("transcript: No tracks found!");return updateTrack(),config.player.ontimeupdate=function(){config.widget.setCue(config.player.currentTime)},config.settings.followPlayerTrack&&(config.player.oncaptionstrackchange=updateTrack,config.player.onsubtitlestrackchange=updateTrack),{el:function(){return config.widget.el()},setTrack:config.widget.setTrack}}}}));

//# sourceMappingURL=interactivetranscript.min.js.map