<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assignfeedback_cloudpoodll', language 'en'
 *
 * @package   assignfeedback_cloudpoodll
 * @copyright 2019 Justin Hunt {@link https://poodll.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['default'] = 'Enabled by default';
$string['default_help'] = 'If set, this feedback method will be enabled by default for all new assignments.';
$string['enabled'] = 'Cloud Poodll feedback';
$string['enabled_help'] = 'If enabled, the marker can leave feedback cloudpoodll for each submission. ';
$string['pluginname'] = 'Cloud Poodll Feedback';
$string['privacy:feedbackpath'] = 'Cloud Poodll Feedback';
$string['privacy:metadata:assignmentid'] = 'Assignment identifier';
$string['privacy:metadata:commentpurpose'] = 'The comment text.';
$string['privacy:metadata:gradepurpose'] = 'The grade ID associated with the comment.';
$string['privacy:metadata:tablesummary'] =
        'This stores cloudpoodll made by the graders as feedback for the student on their submission.';
$string['cloudpoodll:use'] = 'Allow use of Cloud Poodll feedback';

//$string['recorder'] = 'Recorder Type';
$string['recorderaudio'] = 'Audio Feedback';
$string['recorderfree'] = 'Audio, Video, Screen,Text or Corrections Feedback';
$string['recorderfree_noscreen'] = 'Audio,Video,Text or Corrections Feedback';
$string['recordervideo'] = 'Video Feedback';
$string['recorderscreen'] = 'Screencast Feedback (beta)';
$string['recordercorrections'] = 'Corrections Feedback';
$string['recorderfeedbackcorrections'] = 'Corrections Feedback';
$string['recorderfeedbacktext'] = 'Text Feedback';
$string['defaultrecorder'] = 'Recorder Type';
$string['defaultrecorderdetails'] = '';

$string['apiuser'] = 'Poodll API User ';
$string['apiuser_details'] = 'The Poodll account username that authorises Poodll on this site.';
$string['apisecret'] = 'Poodll API Secret ';
$string['apisecret_details'] =
        'The Poodll API secret. See <a href= "https://support.poodll.com/support/solutions/articles/19000083076-cloud-poodll-api-secret">here</a> for more details';
$string['enabletranscription'] = 'Enable Transcription';
$string['enabletranscription_details'] = 'Cloud Poodll can transcribe the student speaking if required';
$string['enabletranscode'] = 'Enable Transcode';
$string['enabletranscode_details'] = 'Cloud Poodll can transcode the recording to mp3/mp4';
$string['language'] = 'Speaker Language';

$string['useast1'] = 'US East';
$string['tokyo'] = 'Tokyo, Japan';
$string['sydney'] = 'Sydney, Australia';
$string['dublin'] = 'Dublin, Ireland';
$string['ottawa'] = 'Ottawa, Canada';
$string['frankfurt'] = 'Frankfurt, Germany';
$string['london'] = 'London, U.K';
$string['saopaulo'] = 'Sao Paulo, Brazil';
$string['singapore']='Singapore';
$string['mumbai']='Mumbai, India';
$string['capetown'] = 'Capetown, South Africa';
$string['bahrain'] = 'Bahrain';
$string['ningxia'] = 'Ningxia, China (req. Poodll China account)';
$string['forever'] = 'Never expire';

$string['en-us'] = 'English (US)';
$string['en-gb'] = 'English (GB)';
$string['en-au'] = 'English (AU)';
$string['en-in'] = 'English (IN)';
$string['es-es'] = 'Spanish (ES)';
$string['es-us'] = 'Spanish (US)';
$string['fr-fr'] = 'French (FR.)';
$string['fr-ca'] = 'French (CA)';
$string['ko-kr'] = 'Korean';
$string['pt-br'] = 'Portuguese (BR)';
$string['it-it'] = 'Italian (IT)';
$string['de-de'] = 'German (DE)';
$string['hi-in'] = 'Hindi';

$string['ar-ae'] = 'Arabic (Gulf)';
$string['ar-sa'] = 'Arabic (Modern Standard)';
$string['zh-cn'] = 'Chinese (Mandarin-Mainland)';
$string['nl-nl'] = 'Dutch';
$string['en-ie'] = 'English (Ireland)';
$string['en-wl'] = 'English (Wales)';
$string['en-ab'] = 'English (Scotland)';
$string['fa-ir'] = 'Farsi';
$string['de-ch'] = 'German (Swiss)';
$string['he-il'] = 'Hebrew';
$string['id-id'] = 'Indonesian';
$string['ja-jp'] = 'Japanese';
$string['ms-my'] = 'Malay';
$string['pt-pt'] = 'Portuguese (PT)';
$string['ru-ru'] = 'Russian';
$string['ta-in'] = 'Tamil';
$string['te-in'] = 'Telugu';
$string['tr-tr'] = 'Turkish';
$string['uk-ua'] = 'Ukranian';
$string['eu-es'] = 'Basque';
$string['fi-fi'] = 'Finnish';
$string['hu-hu'] = 'Hungarian';
$string['sv-se'] = 'Swedish';
$string['no-no'] = 'Norwegian';
$string['nb-no'] = 'Norwegian'; //unused
$string['pl-pl'] = 'Polish';
$string['ro-ro'] = 'Romanian';
$string['mi-nz'] = 'Maori';
$string['bg-bg'] = 'Bulgarian'; // Bulgarian
$string['cs-cz'] = 'Czech'; // Czech
$string['el-gr'] = 'Greek'; // Greek
$string['hr-hr'] = 'Croatian'; // Croatian
$string['hu-hu'] = 'Hungarian'; // Hungarian
$string['lt-lt'] = 'Lithuanian'; // Lithuanian
$string['lv-lv'] = 'Latvian'; // Latvian
$string['sk-sk'] = 'Slovak'; // Slovak
$string['sl-si'] = 'Slovenian'; // Slovenian
$string['is-is'] = 'Icelandic'; // Icelandic
$string['mk-mk'] = 'Macedonian'; // Macedonian
$string['no-no'] = 'Norwegian'; // Norwegian
$string['sr-rs'] = 'Serbian'; // Serbian
$string['vi-vn'] = 'Vietnamese'; // Vietnamese

$string['awsregion'] = 'AWS Region';
//$string['region'] = 'AWS Region';
$string['expiredays'] = 'Days to keep file';

$string['timelimit'] = 'Recording Time Limit';
$string['currentfeedback'] = 'Current Feedback:';
$string['yes'] = 'yes';
$string['no'] = 'no';

$string['displayaudioplayersingle'] = 'Show audio player(normal)';
$string['displayaudioplayerlist'] = 'Show audio player(lists)';

$string['displaysizesingle'] = 'Video player size(normal)';
$string['displaysizesingledetails'] = '';
$string['displaysizelist'] = 'Video player size(in lists)';
$string['displaysizelistdetails'] = '';
$string['shownovideo'] = 'Do not display video';
$string['videoplaceholder'] = ' [video submitted] ';
$string['audioplaceholder'] = ' [audio submitted] ';
//$string['shownoimage'] = 'Do not display image';

$string['setting_audio_heading'] = 'Audio player settings';
$string['setting_audio_heading_details'] = 'Settings controlling player appearance in feedback review and list pages';
$string['setting_video_heading'] = 'Video player settings';
$string['setting_video_heading_details'] = 'Settings controlling player appearance in feedback review and list pages';
//$string['setting_snapshot_heading'] = 'Snapshot image settings';
//$string['setting_snapshot_heading_details'] = 'Settings controlling image appearance in feedback review and list pages';
//$string['setting_whiteboard_heading'] = 'Whiteboard image settings';
//$string['setting_whiteboard_heading_details'] = 'Settings controlling image appearance in feedback review and list pages';
$string['deletefeedback'] = 'Delete this feedback.';
$string['reallydeletefeedback'] = 'Really delete this feedback?';

$string['cloudpoodll:use'] = 'Allow use of Cloud Poodll feedbacks';
$string['privacy:metadata:cloudpoodllcom'] =
        'The assignfeedback_cloudpoodll plugin stores recordings in AWS S3 buckets via cloud.poodll.com.';
$string['privacy:metadata:cloudpoodllcom:userid'] =
        'The assignfeedback_cloudpoodll plugin includes the moodle userid in the urls of recordings.';
$string['privacy:metadata:assignmentid'] = 'Assignment identifier';
$string['privacy:metadata:filepurpose'] = 'File urls of submitted recordings.';
$string['privacy:metadata:feedbackpurpose'] = 'The feedback ID that links to feedbacks for the user.';
$string['privacy:metadata:tablepurpose'] = 'Stores the text and URLs that make the feedback for each attempt.';
$string['privacy:metadata:transcriptpurpose'] = 'The transcript for this attempt of the assignment.';
$string['privacy:metadata:fulltranscriptpurpose'] = 'The transcript with metadata for this attempt of the assignment.';
$string['privacy:metadata:vttpurpose'] = 'The subtitle rendering of transcript for this attempt of the assignment.';
$string['privacy:path'] = 'Feedback Text';

$string['recordertype'] = 'Recorder Type';
$string['recorderskin'] = 'Recorder Skin';
$string['skinplain'] = 'Plain';
$string['skinbmr'] = 'Burnt Rose';
$string['skinfresh'] = 'Fresh (audio only)';
$string['skin123'] = 'One Two Three';
$string['skinonce'] = 'Once';
$string['skinupload'] = 'Upload';
$string['skinscreen'] = 'Screen Recorder (video)';

$string['fallback'] = 'non-HTML5 Fallback';
$string['fallbackdetails'] =
        'If the browser does not support HTML5 recording for the selected mediatype, fallback to an upload screen or a warning.';
$string['fallbackupload'] = 'Upload';
$string['fallbackiosupload'] = 'iOS: upload, else warning';
$string['fallbackwarning'] = 'Warning';

$string['playertype'] = 'Transcript Display (teacher)';
$string['playertypestudent'] = 'Transcript Display(student)';
$string['playertypedefault'] = 'No transcript.';
$string['playertypeinteractivetranscript'] = 'Interactive transcript';
$string['playertypestandardtranscript'] = 'Static transcript';
$string['defaultplayertype'] = 'Transcript display(teacher)';
$string['defaultplayertypestudent'] = 'Transcript display(student)';
$string['defaultplayertypedetails'] =
        'Use the interactive or static transcript player if you are transcribing or show no transcript';
$string['transcripttitle'] = 'Transcript';

//these errors are displayed on settings page
$string['displaysubs'] = '{$a->subscriptionname} : expires {$a->expiredate}';
$string['noapiuser'] = "No API user entered. This plugin will not work correctly.";
$string['noapisecret'] = "No API secret entered. This plugin will not work correctly.";
$string['credentialsinvalid'] = "The API user and secret entered could not be used to get access. Please check them.";
$string['appauthorised'] = "Assign Feedback Cloud Poodll is authorised for this site.";
$string['appnotauthorised'] = "Assign Feedback Cloud Poodll  is NOT authorised for this site.";
$string['refreshtoken'] = "Refresh license information";
$string['notokenincache'] = "Refresh to see license information. Contact Poodll support if there is a problem.";

//these errors are displayed on activity page
$string['nocredentials'] = 'API user and secret not entered. Please enter them on <a href="{$a}">the settings page.</a> You can get them from <a href="https://poodll.com/member">Poodll.com.</a>';
$string['novalidcredentials'] = 'API user and secret were rejected and could not gain access. Please check them on <a href="{$a}">the settings page.</a> You can get them from <a href="https://poodll.com/member">Poodll.com.</a>';
$string['nosubscriptions'] = "There is no current subscription for this site/plugin.";

$string['clicktohide'] = "Hide current feedback";
$string['clicktoshow'] = "Show current feedback";

$string['transcribernone'] = "No transcription";
$string['transcriberamazon'] = "Normal transcription";
$string['transcribergooglecloud'] = "Fast transcription(short audio only)";
$string['divider']= '---------------{$a}----------------';
$string['customdivider']= '---------------{$a->customname} ("{$a->pluginname}")----------------';

$string['recorderdisplayname']= "Feedback Recorder";
$string['customname']= "Custom name";
$string['customnamedetails']= "Set a custom name for the plugin(ie not 'Feedback Recorder') as displayed inside the plugin";

$string['freetrial'] = "Get Cloud Poodll API Credentials and a Free Trial";
$string['freetrial_desc'] = "A dialog should appear that allows you to register for a free trial with Poodll. After registering you should login to the members dashboard to get your API user and secret. And to register your site URL.";
//$string['memberdashboard'] = "Member Dashboard";
//$string['memberdashboard_desc'] = "";
$string['fillcredentials']="Set API user and secret with existing credentials";
$string['startscreencast']="Start Screencast";

$string['checking']=' ... checking ... ';
$string['nosuggestions'] = "No suggestions.";
$string['correctionslanguage']='Corrections language';
$string['correctionslanguagedetails']='If using AI powered corrections for the student submission(transcript/text), set the default language of submissions here.';
$string['getgrammarsuggestions'] = "Get Grammar Suggestions";
$string['previewtext_instructions']="Corrections Preview.";
$string['submittedtext_instructions']="Fetch, paste or enter the text of the student submission that you wish to correct in the text area below. Click the 'Get Grammar Suggestions' button to get suggested corrections.";
$string['correctedtext_instructions']="Enter / edit the corrected version of the submitted text. When displayed to the student, the original and corrected text will be shown and the differences highlighted.";
$string['fetchsubmittedtext']="Fetch Submitted Text";
$string['submittedtext']="Submitted Text";
$string['correctedtext']="Corrected Text";
$string['overwrite']="OVERWRITE";
$string['overwritewarning']="WARNING: Overwrite?";
$string['overwritesuggestions']="Overwrite the existing grammar suggestions?";
$string['overwritefetchedsubmission']="Overwrite the submission text?";
$string['correctionstitle'] = 'Corrections';
$string['loomunavailable'] = 'Poodll screen recording using the Loom service is not available in the Frankfurt or Dublin AWS regions.';
$string['showcorrections']='Show inline corrections';
$string['hidecorrections']='Hide inline corrections';
$string['cloudpoodllserver'] = 'Cloud Poodll Server';
$string['cloudpoodllserver_details'] = 'The server to use for Cloud Poodll. Only change this if Poodll has provided a different one.';
