/* drawingboard.js v0.4.2 - https://github.com/Leimi/drawingboard.js
* Copyright (c) 2013 Emmanuel Pelletier
* Licensed MIT */
window.DrawingBoard={},DrawingBoard.Board=function(a,b){if(this.opts=$.extend({},DrawingBoard.Board.defaultOpts,b),this.ev=new DrawingBoard.Utils.MicroEvent,this.id=a,this.$el=$(document.getElementById(a)),!this.$el.length)return!1;var c='<div class="drawing-board-canvas-wrapper"></canvas><canvas class="drawing-board-canvas"></canvas><div class="drawing-board-cursor drawing-board-utils-hidden"></div></div>';return this.opts.controlsPosition.indexOf("bottom")>-1?c+='<div class="drawing-board-controls"></div>':c='<div class="drawing-board-controls"></div>'+c,this.$el.addClass("drawing-board").append(c),this.dom={$canvasWrapper:this.$el.find(".drawing-board-canvas-wrapper"),$canvas:this.$el.find(".drawing-board-canvas"),$cursor:this.$el.find(".drawing-board-cursor"),$controls:this.$el.find(".drawing-board-controls")},$.each(["left","right","center"],$.proxy(function(a,b){return this.opts.controlsPosition.indexOf(b)>-1?(this.dom.$controls.attr("data-align",b),!1):void 0},this)),this.canvas=this.dom.$canvas.get(0),this.ctx=this.canvas&&this.canvas.getContext&&this.canvas.getContext("2d")?this.canvas.getContext("2d"):null,this.color=this.opts.color,this.ctx?(this.storage=this._getStorage(),this.initHistory(),this.reset({webStorage:!1,history:!1,background:!1}),this.initControls(),this.resize(),this.reset({webStorage:!1,history:!0,background:!0}),this.restoreWebStorage(),this.initDropEvents(),this.initDrawEvents(),void 0):(this.opts.errorMessage&&this.$el.html(this.opts.errorMessage),!1)},DrawingBoard.Board.defaultOpts={controls:["Color","DrawingMode","Size","Navigation"],controlsPosition:"top left",color:"#000000",size:1,background:"#fff",eraserColor:"background",webStorage:"session",droppable:!1,enlargeYourContainer:!1,errorMessage:'<p>It seems you use an obsolete browser. <a href="http://browsehappy.com/" target="_blank">Update it</a> to start drawing.</p>'},DrawingBoard.Board.prototype={reset:function(a){a=$.extend({color:this.opts.color,size:this.opts.size,webStorage:!0,history:!0,background:!1},a),this.setMode("pencil"),a.background&&this.resetBackground(this.opts.background,!1),a.color&&this.setColor(a.color),a.size&&(this.ctx.lineWidth=a.size),this.ctx.lineCap="round",this.ctx.lineJoin="round",a.webStorage&&this.saveWebStorage(),a.history&&this.saveHistory(),this.blankCanvas=this.getImg(),this.ev.trigger("board:reset",a)},resetBackground:function(a,b){a=a||this.opts.background,b="undefined"!=typeof b?b:!0;var c=DrawingBoard.Utils.isColor(a),d=this.getMode();this.setMode("pencil"),this.ctx.clearRect(0,0,this.ctx.canvas.width,this.ctx.canvas.width),c?(this.ctx.fillStyle=a,this.ctx.fillRect(0,0,this.ctx.canvas.width,this.ctx.canvas.height)):a&&this.setImg(a),this.setMode(d),b&&this.saveHistory()},resize:function(){this.dom.$controls.toggleClass("drawing-board-controls-hidden",!this.controls||!this.controls.length);var a,b,c=[this.$el.width(),DrawingBoard.Utils.boxBorderWidth(this.$el),DrawingBoard.Utils.boxBorderWidth(this.dom.$canvasWrapper,!0,!0)],d=[this.$el.height(),DrawingBoard.Utils.boxBorderHeight(this.$el),this.dom.$controls.height(),DrawingBoard.Utils.boxBorderHeight(this.dom.$controls,!1,!0),DrawingBoard.Utils.boxBorderHeight(this.dom.$canvasWrapper,!0,!0)],e=function(a,b){b=b||1;for(var c=a[0],d=1;d<a.length;d++)c+=a[d]*b;return c},f=function(a){return e(a,-1)};this.opts.enlargeYourContainer?(a=this.$el.width(),b=this.$el.height(),this.$el.width(e(c)),this.$el.height(e(d))):(a=f(c),b=f(d)),this.dom.$canvasWrapper.css("width",a+"px"),this.dom.$canvasWrapper.css("height",b+"px"),this.dom.$canvas.css("width",a+"px"),this.dom.$canvas.css("height",b+"px"),this.canvas.width=a,this.canvas.height=b},initControls:function(){if(this.controls=[],!this.opts.controls.length||!DrawingBoard.Control)return!1;for(var a=0;a<this.opts.controls.length;a++){var b=null;if("string"==typeof this.opts.controls[a])b=new window.DrawingBoard.Control[this.opts.controls[a]](this);else if("object"==typeof this.opts.controls[a]){for(var c in this.opts.controls[a])break;b=new window.DrawingBoard.Control[c](this,this.opts.controls[a][c])}b&&this.addControl(b)}},addControl:function(a,b,c){if("string"!=typeof a&&("object"!=typeof a||!a instanceof DrawingBoard.Control))return!1;var d="object"==typeof b?b:{};c=c?1*c:"number"==typeof b?b:null,"string"==typeof a&&(a=new window.DrawingBoard.Control[a](this,d)),c?this.dom.$controls.children().eq(c).before(a.$el):this.dom.$controls.append(a.$el),this.controls||(this.controls=[]),this.controls.push(a),this.dom.$controls.removeClass("drawing-board-controls-hidden")},initHistory:function(){this.history={values:[],position:0}},saveHistory:function(){for(;this.history.values.length>30;)this.history.values.shift(),this.history.position--;0!==this.history.position&&this.history.position<this.history.values.length?(this.history.values=this.history.values.slice(0,this.history.position),this.history.position++):this.history.position=this.history.values.length+1,this.history.values.push(this.getImg()),this.ev.trigger("historyNavigation",this.history.position)},_goThroughHistory:function(a){if(!(a&&this.history.position==this.history.values.length||!a&&1==this.history.position)){var b=a?this.history.position+1:this.history.position-1;this.history.values.length&&void 0!==this.history.values[b-1]&&(this.history.position=b,this.setImg(this.history.values[b-1])),this.ev.trigger("historyNavigation",b),this.saveWebStorage()}},goBackInHistory:function(){this._goThroughHistory(!1)},goForthInHistory:function(){this._goThroughHistory(!0)},setImg:function(a){var b=this.ctx,c=new Image,d=b.globalCompositeOperation;c.onload=function(){b.globalCompositeOperation="source-over",b.clearRect(0,0,b.canvas.width,b.canvas.width),b.drawImage(c,0,0),b.globalCompositeOperation=d},c.src=a},getImg:function(){return this.canvas.toDataURL("image/png")},downloadImg:function(){var a=this.getImg();a=a.replace("image/png","image/octet-stream"),window.location.href=a},saveWebStorage:function(){window[this.storage]&&(window[this.storage].setItem("drawing-board-"+this.id,this.getImg()),this.ev.trigger("board:save"+this.storage.charAt(0).toUpperCase()+this.storage.slice(1),this.getImg()))},restoreWebStorage:function(){window[this.storage]&&null!==window[this.storage].getItem("drawing-board-"+this.id)&&(this.setImg(window[this.storage].getItem("drawing-board-"+this.id)),this.ev.trigger("board:restore"+this.storage.charAt(0).toUpperCase()+this.storage.slice(1),window[this.storage].getItem("drawing-board-"+this.id)))},clearWebStorage:function(){window[this.storage]&&null!==window[this.storage].getItem("drawing-board-"+this.id)&&(window[this.storage].removeItem("drawing-board-"+this.id),this.ev.trigger("board:clear"+this.storage.charAt(0).toUpperCase()+this.storage.slice(1)))},_getStorage:function(){return!this.opts.webStorage||"session"!==this.opts.webStorage&&"local"!==this.opts.webStorage?!1:this.opts.webStorage+"Storage"},initDropEvents:function(){return this.opts.droppable?(this.dom.$canvas.on("dragover dragenter drop",function(a){a.stopPropagation(),a.preventDefault()}),this.dom.$canvas.on("drop",$.proxy(this._onCanvasDrop,this)),void 0):!1},_onCanvasDrop:function(a){a=a.originalEvent?a.originalEvent:a;var b=a.dataTransfer.files;if(!b||!b.length||-1==b[0].type.indexOf("image")||!window.FileReader)return!1;var c=new FileReader;c.readAsDataURL(b[0]),c.onload=$.proxy(function(a){this.setImg(a.target.result),this.ev.trigger("board:imageDropped",a.target.result),this.ev.trigger("board:userAction"),this.saveHistory()},this)},setMode:function(a,b){b=b||!1,a=a||"pencil",this.ev.unbind("board:startDrawing",$.proxy(this.fill,this)),"transparent"===this.opts.eraserColor?this.ctx.globalCompositeOperation="eraser"===a?"destination-out":"source-over":("eraser"===a?"background"===this.opts.eraserColor&&DrawingBoard.Utils.isColor(this.opts.background)?this.ctx.strokeStyle=this.opts.background:DrawingBoard.Utils.isColor(this.opts.eraserColor)&&(this.ctx.strokeStyle=this.opts.eraserColor):this.mode&&"eraser"!==this.mode||(this.ctx.strokeStyle=this.color),"filler"===a&&this.ev.bind("board:startDrawing",$.proxy(this.fill,this))),this.mode=a,b||this.ev.trigger("board:mode",this.mode)},getMode:function(){return this.mode||"pencil"},setColor:function(a){var b=this;if(a=a||this.color,!DrawingBoard.Utils.isColor(a))return!1;if(this.color=a,"transparent"!==this.opts.eraserColor&&"eraser"===this.mode){var c=function(a){"eraser"!==a&&(b.strokeStyle=b.color),b.ev.unbind("board:mode",c)};this.ev.bind("board:mode",c)}else this.ctx.strokeStyle=this.color},fill:function(a){if(this.getImg()===this.blankCanvas)return this.ctx.clearRect(0,0,this.ctx.canvas.width,this.ctx.canvas.width),this.ctx.fillStyle=this.color,this.ctx.fillRect(0,0,this.ctx.canvas.width,this.ctx.canvas.height),void 0;var b=this.ctx.getImageData(0,0,this.canvas.width,this.canvas.height),c=0,d=1,e=2,f=3,g=this.ctx.strokeStyle,h=parseInt(g.substr(1,2),16),i=parseInt(g.substr(3,2),16),j=parseInt(g.substr(5,2),16),k=DrawingBoard.Utils.pixelAt(b,parseInt(a.coords.x,10),parseInt(a.coords.y,10));if(k[f]!==DrawingBoard.Utils.RGBToInt(h,i,j)){for(var l,m=[k],n=b.width-1,o=b.height-1;l=m.pop();)l[f]===k[f]&&(b.data[l[c]]=h,b.data[l[c]+1]=i,b.data[l[c]+2]=j,l[d]>0&&m.push(DrawingBoard.Utils.pixelAt(b,l[d]-1,l[e])),l[d]<n&&m.push(DrawingBoard.Utils.pixelAt(b,l[d]+1,l[e])),l[e]>0&&m.push(DrawingBoard.Utils.pixelAt(b,l[d],l[e]-1)),l[e]<o&&m.push(DrawingBoard.Utils.pixelAt(b,l[d],l[e]+1)));this.ctx.putImageData(b,0,0)}},initDrawEvents:function(){this.isDrawing=!1,this.isMouseHovering=!1,this.coords={},this.coords.old=this.coords.current=this.coords.oldMid={x:0,y:0},this.dom.$canvas.on("mousedown touchstart",$.proxy(function(a){this._onInputStart(a,this._getInputCoords(a))},this)),this.dom.$canvas.on("mousemove touchmove",$.proxy(function(a){this._onInputMove(a,this._getInputCoords(a))},this)),this.dom.$canvas.on("mousemove",$.proxy(function(){},this)),this.dom.$canvas.on("mouseup touchend",$.proxy(function(a){this._onInputStop(a,this._getInputCoords(a))},this)),this.dom.$canvas.on("mouseover",$.proxy(function(a){this._onMouseOver(a,this._getInputCoords(a))},this)),this.dom.$canvas.on("mouseout",$.proxy(function(a){this._onMouseOut(a,this._getInputCoords(a))},this)),$("body").on("mouseup touchend",$.proxy(function(){this.isDrawing=!1},this)),window.requestAnimationFrame&&requestAnimationFrame($.proxy(this.draw,this))},draw:function(){if(window.requestAnimationFrame&&this.ctx.lineWidth>10&&this.isMouseHovering){this.dom.$cursor.css({width:this.ctx.lineWidth+"px",height:this.ctx.lineWidth+"px"});var a=DrawingBoard.Utils.tpl("translateX({{x}}px) translateY({{y}}px)",{x:this.coords.current.x-this.ctx.lineWidth/2,y:this.coords.current.y-this.ctx.lineWidth/2});this.dom.$cursor.css({transform:a,"-webkit-transform":a,"-ms-transform":a}),this.dom.$cursor.removeClass("drawing-board-utils-hidden")}else this.dom.$cursor.addClass("drawing-board-utils-hidden");if(this.isDrawing){var b=this._getMidInputCoords(this.coords.current);this.ctx.beginPath(),this.ctx.moveTo(b.x,b.y),this.ctx.quadraticCurveTo(this.coords.old.x,this.coords.old.y,this.coords.oldMid.x,this.coords.oldMid.y),this.ctx.stroke(),this.coords.old=this.coords.current,this.coords.oldMid=b}window.requestAnimationFrame&&requestAnimationFrame($.proxy(function(){this.draw()},this))},_onInputStart:function(a,b){this.coords.current=this.coords.old=b,this.coords.oldMid=this._getMidInputCoords(b),this.isDrawing=!0,window.requestAnimationFrame||this.draw(),this.ev.trigger("board:startDrawing",{e:a,coords:b}),a.preventDefault()},_onInputMove:function(a,b){this.coords.current=b,this.ev.trigger("board:drawing",{e:a,coords:b}),window.requestAnimationFrame||this.draw(),a.preventDefault()},_onInputStop:function(a,b){!this.isDrawing||a.touches&&0!==a.touches.length||(this.isDrawing=!1,this.saveWebStorage(),this.saveHistory(),this.ev.trigger("board:stopDrawing",{e:a,coords:b}),this.ev.trigger("board:userAction"),a.preventDefault())},_onMouseOver:function(a,b){this.isMouseHovering=!0,this.coords.old=this._getInputCoords(a),this.coords.oldMid=this._getMidInputCoords(this.coords.old),this.ev.trigger("board:mouseOver",{e:a,coords:b})},_onMouseOut:function(a,b){this.isMouseHovering=!1,this.ev.trigger("board:mouseOut",{e:a,coords:b})},_getInputCoords:function(a){a=a.originalEvent?a.originalEvent:a;var b,c;return a.touches&&1==a.touches.length?(b=a.touches[0].pageX,c=a.touches[0].pageY):(b=a.pageX,c=a.pageY),{x:b-this.dom.$canvas.offset().left,y:c-this.dom.$canvas.offset().top}},_getMidInputCoords:function(a){return{x:this.coords.old.x+a.x>>1,y:this.coords.old.y+a.y>>1}}},DrawingBoard.Utils={},DrawingBoard.Utils.tpl=function(){"use strict";var a,b="{{",c="}}",d="[a-z0-9_][\\.a-z0-9_]*",e=new RegExp(b+"\\s*("+d+")\\s*"+c,"gi");return function(b,c){return b.replace(e,function(b,d){for(var e=d.split("."),f=e.length,g=c,h=0;f>h;h++){if(g=g[e[h]],g===a)throw"tim: '"+e[h]+"' not found in "+b;if(h===f-1)return g}})}}(),DrawingBoard.Utils.MicroEvent=function(){},DrawingBoard.Utils.MicroEvent.prototype={bind:function(a,b){this._events=this._events||{},this._events[a]=this._events[a]||[],this._events[a].push(b)},unbind:function(a,b){this._events=this._events||{},a in this._events!=!1&&this._events[a].splice(this._events[a].indexOf(b),1)},trigger:function(a){if(this._events=this._events||{},a in this._events!=!1)for(var b=0;b<this._events[a].length;b++)this._events[a][b].apply(this,Array.prototype.slice.call(arguments,1))}},DrawingBoard.Utils._boxBorderSize=function(a,b,c,d){b=!!b||!0,c=!!c||!1;var e,f=0;"width"==d?(e=["border-left-width","border-right-width"],b&&e.push("padding-left","padding-right"),c&&e.push("margin-left","margin-right")):(e=["border-top-width","border-bottom-width"],b&&e.push("padding-top","padding-bottom"),c&&e.push("margin-top","margin-bottom"));for(var g=e.length-1;g>=0;g--)f+=parseInt(a.css(e[g]).replace("px",""),10);return f},DrawingBoard.Utils.boxBorderWidth=function(a,b,c){return DrawingBoard.Utils._boxBorderSize(a,b,c,"width")},DrawingBoard.Utils.boxBorderHeight=function(a,b,c){return DrawingBoard.Utils._boxBorderSize(a,b,c,"height")},DrawingBoard.Utils.isColor=function(a){return a&&a.length?/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(a)||-1!==$.inArray(a.substring(0,3),["rgb","hsl"]):!1},DrawingBoard.Utils.RGBToInt=function(a,b,c){var d=0;return d|=(255&a)<<16,d|=(255&b)<<8,d|=255&c},DrawingBoard.Utils.pixelAt=function(a,b,c){var d=4*(c*a.width+b),e=DrawingBoard.Utils.RGBToInt(a.data[d],a.data[d+1],a.data[d+2]);return[d,b,c,e]},function(){for(var a=["ms","moz","webkit","o"],b=0;b<a.length&&!window.requestAnimationFrame;++b)window.requestAnimationFrame=window[a[b]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[a[b]+"CancelAnimationFrame"]||window[a[b]+"CancelRequestAnimationFrame"]}();