define(["jquery"],(function($){var pattern,DrawingBoard={};return DrawingBoard.Board=function(id,opts){if(this.opts=$.extend({},DrawingBoard.Board.defaultOpts,opts),this.ev=new DrawingBoard.Utils.MicroEvent,this.id=id,this.$el=$(document.getElementById(id)),!this.$el.length)return!1;var tpl='<div class="drawing-board-canvas-wrapper"></canvas><canvas class="drawing-board-canvas"></canvas><div class="drawing-board-cursor drawing-board-utils-hidden"></div></div>';if(this.opts.controlsPosition.indexOf("bottom")>-1?tpl+='<div class="drawing-board-controls"></div>':tpl='<div class="drawing-board-controls"></div>'+tpl,this.$el.addClass("drawing-board").append(tpl),this.dom={$canvasWrapper:this.$el.find(".drawing-board-canvas-wrapper"),$canvas:this.$el.find(".drawing-board-canvas"),$cursor:this.$el.find(".drawing-board-cursor"),$controls:this.$el.find(".drawing-board-controls")},$.each(["left","right","center"],$.proxy((function(n,val){if(this.opts.controlsPosition.indexOf(val)>-1)return this.dom.$controls.attr("data-align",val),!1}),this)),this.canvas=this.dom.$canvas.get(0),this.ctx=this.canvas&&this.canvas.getContext&&this.canvas.getContext("2d")?this.canvas.getContext("2d"):null,this.color=this.opts.color,!this.ctx)return this.opts.errorMessage&&this.$el.html(this.opts.errorMessage),!1;this.storage=this._getStorage(),this.initHistory(),this.reset({webStorage:!1,history:!1,background:!1}),this.initControls(),this.resize(),this.reset({webStorage:!1,history:!0,background:!0}),this.restoreWebStorage(),this.initDropEvents(),this.initDrawEvents()},DrawingBoard.Board.defaultOpts={controls:["Color","DrawingMode","Size","Navigation"],controlsPosition:"top left",color:"#000000",size:1,background:"#fff",eraserColor:"background",webStorage:"session",droppable:!1,enlargeYourContainer:!1,errorMessage:'<p>It seems you use an obsolete browser. <a href="http://browsehappy.com/" target="_blank">Update it</a> to start drawing.</p>'},DrawingBoard.Board.prototype={reset:function(opts){opts=$.extend({color:this.opts.color,size:this.opts.size,webStorage:!0,history:!0,background:!1},opts),this.setMode("pencil"),opts.background&&this.resetBackground(this.opts.background,!1),opts.color&&this.setColor(opts.color),opts.size&&(this.ctx.lineWidth=opts.size),this.ctx.lineCap="round",this.ctx.lineJoin="round",opts.webStorage&&this.saveWebStorage(),opts.history&&this.saveHistory(),this.blankCanvas=this.getImg(),this.ev.trigger("board:reset",opts)},resetBackground:function(background,historize){background=background||this.opts.background,historize=void 0===historize||historize;var bgIsColor=DrawingBoard.Utils.isColor(background),prevMode=this.getMode();this.setMode("pencil"),this.ctx.clearRect(0,0,this.ctx.canvas.width,this.ctx.canvas.width),bgIsColor?(this.ctx.fillStyle=background,this.ctx.fillRect(0,0,this.ctx.canvas.width,this.ctx.canvas.height)):background&&this.setImg(background),this.setMode(prevMode),historize&&this.saveHistory()},resize:function(){var canvasWidth,canvasHeight;this.dom.$controls.toggleClass("drawing-board-controls-hidden",!this.controls||!this.controls.length);var widths=[this.$el.width(),DrawingBoard.Utils.boxBorderWidth(this.$el),DrawingBoard.Utils.boxBorderWidth(this.dom.$canvasWrapper,!0,!0)],heights=[this.$el.height(),DrawingBoard.Utils.boxBorderHeight(this.$el),this.dom.$controls.height(),DrawingBoard.Utils.boxBorderHeight(this.dom.$controls,!1,!0),DrawingBoard.Utils.boxBorderHeight(this.dom.$canvasWrapper,!0,!0)],sum=function(values,multiplier){multiplier=multiplier||1;for(var res=values[0],i=1;i<values.length;i++)res+=values[i]*multiplier;return res},sub=function(values){return sum(values,-1)};this.opts.enlargeYourContainer?(canvasWidth=this.$el.width(),canvasHeight=this.$el.height(),this.$el.width(sum(widths)),this.$el.height(sum(heights))):(canvasWidth=sub(widths),canvasHeight=sub(heights)),this.dom.$canvasWrapper.css("width",canvasWidth+"px"),this.dom.$canvasWrapper.css("height",canvasHeight+"px"),this.dom.$canvas.css("width",canvasWidth+"px"),this.dom.$canvas.css("height",canvasHeight+"px"),this.canvas.width=canvasWidth,this.canvas.height=canvasHeight},initControls:function(){if(this.controls=[],!this.opts.controls.length||!DrawingBoard.Control)return!1;for(var i=0;i<this.opts.controls.length;i++){var c=null;if("string"==typeof this.opts.controls[i])c=new window.DrawingBoard.Control[this.opts.controls[i]](this);else if("object"==typeof this.opts.controls[i]){for(var controlName in this.opts.controls[i])break;c=new window.DrawingBoard.Control[controlName](this,this.opts.controls[i][controlName])}c&&this.addControl(c)}},addControl:function(control,optsOrPos,pos){if("string"!=typeof control&&("object"!=typeof control||!control instanceof DrawingBoard.Control))return!1;var opts="object"==typeof optsOrPos?optsOrPos:{};pos=pos?1*pos:"number"==typeof optsOrPos?optsOrPos:null,"string"==typeof control&&(control=new window.DrawingBoard.Control[control](this,opts)),pos?this.dom.$controls.children().eq(pos).before(control.$el):this.dom.$controls.append(control.$el),this.controls||(this.controls=[]),this.controls.push(control),this.dom.$controls.removeClass("drawing-board-controls-hidden")},initHistory:function(){this.history={values:[],position:0}},saveHistory:function(){for(;this.history.values.length>30;)this.history.values.shift(),this.history.position--;0!==this.history.position&&this.history.position<this.history.values.length?(this.history.values=this.history.values.slice(0,this.history.position),this.history.position++):this.history.position=this.history.values.length+1,this.history.values.push(this.getImg()),this.ev.trigger("historyNavigation",this.history.position)},_goThroughHistory:function(goForth){if(!(goForth&&this.history.position==this.history.values.length||!goForth&&1==this.history.position)){var pos=goForth?this.history.position+1:this.history.position-1;this.history.values.length&&void 0!==this.history.values[pos-1]&&(this.history.position=pos,this.setImg(this.history.values[pos-1])),this.ev.trigger("historyNavigation",pos),this.saveWebStorage()}},goBackInHistory:function(){this._goThroughHistory(!1)},goForthInHistory:function(){this._goThroughHistory(!0)},setImg:function(src){var ctx=this.ctx,img=new Image,oldGCO=ctx.globalCompositeOperation;img.onload=function(){ctx.globalCompositeOperation="source-over",ctx.clearRect(0,0,ctx.canvas.width,ctx.canvas.width),ctx.drawImage(img,0,0),ctx.globalCompositeOperation=oldGCO},img.src=src},getImg:function(){return this.canvas.toDataURL("image/png")},downloadImg:function(){var img=this.getImg();img=img.replace("image/png","image/octet-stream"),window.location.href=img},saveWebStorage:function(){window[this.storage]&&(window[this.storage].setItem("drawing-board-"+this.id,this.getImg()),this.ev.trigger("board:save"+this.storage.charAt(0).toUpperCase()+this.storage.slice(1),this.getImg()))},restoreWebStorage:function(){window[this.storage]&&null!==window[this.storage].getItem("drawing-board-"+this.id)&&(this.setImg(window[this.storage].getItem("drawing-board-"+this.id)),this.ev.trigger("board:restore"+this.storage.charAt(0).toUpperCase()+this.storage.slice(1),window[this.storage].getItem("drawing-board-"+this.id)))},clearWebStorage:function(){window[this.storage]&&null!==window[this.storage].getItem("drawing-board-"+this.id)&&(window[this.storage].removeItem("drawing-board-"+this.id),this.ev.trigger("board:clear"+this.storage.charAt(0).toUpperCase()+this.storage.slice(1)))},_getStorage:function(){return!(!this.opts.webStorage||"session"!==this.opts.webStorage&&"local"!==this.opts.webStorage)&&this.opts.webStorage+"Storage"},initDropEvents:function(){if(!this.opts.droppable)return!1;this.dom.$canvas.on("dragover dragenter drop",(function(e){e.stopPropagation(),e.preventDefault()})),this.dom.$canvas.on("drop",$.proxy(this._onCanvasDrop,this))},_onCanvasDrop:function(e){var files=(e=e.originalEvent?e.originalEvent:e).dataTransfer.files;if(!files||!files.length||-1==files[0].type.indexOf("image")||!window.FileReader)return!1;var fr=new FileReader;fr.readAsDataURL(files[0]),fr.onload=$.proxy((function(ev){this.setImg(ev.target.result),this.ev.trigger("board:imageDropped",ev.target.result),this.ev.trigger("board:userAction"),this.saveHistory()}),this)},setMode:function(newMode,silent){silent=silent||!1,newMode=newMode||"pencil",this.ev.unbind("board:startDrawing",$.proxy(this.fill,this)),"transparent"===this.opts.eraserColor?this.ctx.globalCompositeOperation="eraser"===newMode?"destination-out":"source-over":("eraser"===newMode?"background"===this.opts.eraserColor&&DrawingBoard.Utils.isColor(this.opts.background)?this.ctx.strokeStyle=this.opts.background:DrawingBoard.Utils.isColor(this.opts.eraserColor)&&(this.ctx.strokeStyle=this.opts.eraserColor):this.mode&&"eraser"!==this.mode||(this.ctx.strokeStyle=this.color),"filler"===newMode&&this.ev.bind("board:startDrawing",$.proxy(this.fill,this))),this.mode=newMode,silent||this.ev.trigger("board:mode",this.mode)},getMode:function(){return this.mode||"pencil"},setColor:function(color){var that=this;if(color=color||this.color,!DrawingBoard.Utils.isColor(color))return!1;if(this.color=color,"transparent"!==this.opts.eraserColor&&"eraser"===this.mode){var setStrokeStyle=function(mode){"eraser"!==mode&&(that.strokeStyle=that.color),that.ev.unbind("board:mode",setStrokeStyle)};this.ev.bind("board:mode",setStrokeStyle)}else this.ctx.strokeStyle=this.color},fill:function(e){if(this.getImg()===this.blankCanvas)return this.ctx.clearRect(0,0,this.ctx.canvas.width,this.ctx.canvas.width),this.ctx.fillStyle=this.color,void this.ctx.fillRect(0,0,this.ctx.canvas.width,this.ctx.canvas.height);var img=this.ctx.getImageData(0,0,this.canvas.width,this.canvas.height),stroke=this.ctx.strokeStyle,r=parseInt(stroke.substr(1,2),16),g=parseInt(stroke.substr(3,2),16),b=parseInt(stroke.substr(5,2),16),start=DrawingBoard.Utils.pixelAt(img,parseInt(e.coords.x,10),parseInt(e.coords.y,10));if(start[3]!==DrawingBoard.Utils.RGBToInt(r,g,b)){for(var pixel,queue=[start],maxX=img.width-1,maxY=img.height-1;pixel=queue.pop();)pixel[3]===start[3]&&(img.data[pixel[0]]=r,img.data[pixel[0]+1]=g,img.data[pixel[0]+2]=b,pixel[1]>0&&queue.push(DrawingBoard.Utils.pixelAt(img,pixel[1]-1,pixel[2])),pixel[1]<maxX&&queue.push(DrawingBoard.Utils.pixelAt(img,pixel[1]+1,pixel[2])),pixel[2]>0&&queue.push(DrawingBoard.Utils.pixelAt(img,pixel[1],pixel[2]-1)),pixel[2]<maxY&&queue.push(DrawingBoard.Utils.pixelAt(img,pixel[1],pixel[2]+1)));this.ctx.putImageData(img,0,0)}},initDrawEvents:function(){this.isDrawing=!1,this.isMouseHovering=!1,this.coords={},this.coords.old=this.coords.current=this.coords.oldMid={x:0,y:0},this.dom.$canvas.on("mousedown touchstart",$.proxy((function(e){this._onInputStart(e,this._getInputCoords(e))}),this)),this.dom.$canvas.on("mousemove touchmove",$.proxy((function(e){this._onInputMove(e,this._getInputCoords(e))}),this)),this.dom.$canvas.on("mousemove",$.proxy((function(e){}),this)),this.dom.$canvas.on("mouseup touchend",$.proxy((function(e){this._onInputStop(e,this._getInputCoords(e))}),this)),this.dom.$canvas.on("mouseover",$.proxy((function(e){this._onMouseOver(e,this._getInputCoords(e))}),this)),this.dom.$canvas.on("mouseout",$.proxy((function(e){this._onMouseOut(e,this._getInputCoords(e))}),this)),$("body").on("mouseup touchend",$.proxy((function(e){this.isDrawing=!1}),this)),window.requestAnimationFrame&&requestAnimationFrame($.proxy(this.draw,this))},draw:function(){if(window.requestAnimationFrame&&this.ctx.lineWidth>10&&this.isMouseHovering){this.dom.$cursor.css({width:this.ctx.lineWidth+"px",height:this.ctx.lineWidth+"px"});var transform=DrawingBoard.Utils.tpl("translateX({{x}}px) translateY({{y}}px)",{x:this.coords.current.x-this.ctx.lineWidth/2,y:this.coords.current.y-this.ctx.lineWidth/2});this.dom.$cursor.css({transform:transform,"-webkit-transform":transform,"-ms-transform":transform}),this.dom.$cursor.removeClass("drawing-board-utils-hidden")}else this.dom.$cursor.addClass("drawing-board-utils-hidden");if(this.isDrawing){var currentMid=this._getMidInputCoords(this.coords.current);this.ctx.beginPath(),this.ctx.moveTo(currentMid.x,currentMid.y),this.ctx.quadraticCurveTo(this.coords.old.x,this.coords.old.y,this.coords.oldMid.x,this.coords.oldMid.y),this.ctx.stroke(),this.coords.old=this.coords.current,this.coords.oldMid=currentMid}window.requestAnimationFrame&&requestAnimationFrame($.proxy((function(){this.draw()}),this))},_onInputStart:function(e,coords){this.coords.current=this.coords.old=coords,this.coords.oldMid=this._getMidInputCoords(coords),this.isDrawing=!0,window.requestAnimationFrame||this.draw(),this.ev.trigger("board:startDrawing",{e:e,coords:coords}),e.preventDefault()},_onInputMove:function(e,coords){this.coords.current=coords,this.ev.trigger("board:drawing",{e:e,coords:coords}),window.requestAnimationFrame||this.draw(),e.preventDefault()},_onInputStop:function(e,coords){!this.isDrawing||e.touches&&0!==e.touches.length||(this.isDrawing=!1,this.saveWebStorage(),this.saveHistory(),this.ev.trigger("board:stopDrawing",{e:e,coords:coords}),this.ev.trigger("board:userAction"),e.preventDefault())},_onMouseOver:function(e,coords){this.isMouseHovering=!0,this.coords.old=this._getInputCoords(e),this.coords.oldMid=this._getMidInputCoords(this.coords.old),this.ev.trigger("board:mouseOver",{e:e,coords:coords})},_onMouseOut:function(e,coords){this.isMouseHovering=!1,this.ev.trigger("board:mouseOut",{e:e,coords:coords})},_getInputCoords:function(e){var x,y;return(e=e.originalEvent?e.originalEvent:e).touches&&1==e.touches.length?(x=e.touches[0].pageX,y=e.touches[0].pageY):(x=e.pageX,y=e.pageY),{x:x-this.dom.$canvas.offset().left,y:y-this.dom.$canvas.offset().top}},_getMidInputCoords:function(coords){return{x:this.coords.old.x+coords.x>>1,y:this.coords.old.y+coords.y>>1}}},DrawingBoard.Control=function(drawingBoard,opts){return this.board=drawingBoard,this.opts=$.extend({},this.defaults,opts),this.$el=$(document.createElement("div")).addClass("drawing-board-control"),this.name&&this.$el.addClass("drawing-board-control-"+this.name),this.board.ev.bind("board:reset",$.proxy(this.onBoardReset,this)),this.initialize.apply(this,arguments),this},DrawingBoard.Control.prototype={name:"",defaults:{},initialize:function(){},addToBoard:function(){this.board.addControl(this)},onBoardReset:function(opts){}},DrawingBoard.Control.extend=function(protoProps,staticProps){var child,parent=this;child=protoProps&&protoProps.hasOwnProperty("constructor")?protoProps.constructor:function(){return parent.apply(this,arguments)},$.extend(child,parent,staticProps);var Surrogate=function(){this.constructor=child};return Surrogate.prototype=parent.prototype,child.prototype=new Surrogate,protoProps&&$.extend(child.prototype,protoProps),child.__super__=parent.prototype,child},DrawingBoard.Control.Color=DrawingBoard.Control.extend({name:"colors",initialize:function(){this.initTemplate();var that=this;this.$el.on("click",".drawing-board-control-colors-picker",(function(e){var color=$(this).attr("data-color");that.board.setColor(color),that.$el.find(".drawing-board-control-colors-current").css("background-color",color).attr("data-color",color),that.board.ev.trigger("color:changed",color),that.$el.find(".drawing-board-control-colors-rainbows").addClass("drawing-board-utils-hidden"),e.preventDefault()})),this.$el.on("click",".drawing-board-control-colors-current",(function(e){that.$el.find(".drawing-board-control-colors-rainbows").toggleClass("drawing-board-utils-hidden"),e.preventDefault()})),$("body").on("click",(function(e){var $target=$(e.target),$relatedButton=$target.hasClass("drawing-board-control-colors-current")?$target:$target.closest(".drawing-board-control-colors-current"),$myButton=that.$el.find(".drawing-board-control-colors-current"),$popup=that.$el.find(".drawing-board-control-colors-rainbows");$relatedButton.length&&$relatedButton.get(0)===$myButton.get(0)||$popup.hasClass("drawing-board-utils-hidden")||$popup.addClass("drawing-board-utils-hidden")}))},initTemplate:function(){var oneColorTpl='<div class="drawing-board-control-colors-picker" data-color="{{color}}" style="background-color: {{color}}"></div>',rainbows="";$.each([.75,.5,.25],$.proxy((function(key,val){var i=0,additionalColor=null;for(rainbows+='<div class="drawing-board-control-colors-rainbow">',.25==val&&(additionalColor=this._rgba(0,0,0,1)),.5==val&&(additionalColor=this._rgba(150,150,150,1)),.75==val&&(additionalColor=this._rgba(255,255,255,1)),rainbows+=DrawingBoard.Utils.tpl(oneColorTpl,{color:additionalColor.toString()});i<=330;)rainbows+=DrawingBoard.Utils.tpl(oneColorTpl,{color:this._hsl2Rgba(this._hsl(i-60,1,val)).toString()}),i+=30;rainbows+="</div>"}),this)),this.$el.append($(DrawingBoard.Utils.tpl('<div class="drawing-board-control-inner"><div class="drawing-board-control-colors-current" style="background-color: {{color}}" data-color="{{color}}"></div><div class="drawing-board-control-colors-rainbows">{{rainbows}}</div></div>',{color:this.board.color,rainbows:rainbows}))),this.$el.find(".drawing-board-control-colors-rainbows").addClass("drawing-board-utils-hidden")},onBoardReset:function(opts){this.board.setColor(this.$el.find(".drawing-board-control-colors-current").attr("data-color"))},_rgba:function(r,g,b,a){return{r:r,g:g,b:b,a:a,toString:function(){return"rgba("+r+", "+g+", "+b+", "+a+")"}}},_hsl:function(h,s,l){return{h:h,s:s,l:l,toString:function(){return"hsl("+h+", "+100*s+"%, "+100*l+"%)"}}},_hex2Rgba:function(hex){var num=parseInt(hex.substring(1),16);return this._rgba(num>>16,num>>8&255,255&num,1)},_hsl2Rgba:function(hsl){var r,g,b,h=hsl.h/360,s=hsl.s,l=hsl.l;function hue2rgb(p,q,t){return t<0&&(t+=1),t>1&&(t-=1),t<1/6?p+6*(q-p)*t:t<.5?q:t<2/3?p+(q-p)*(2/3-t)*6:p}if(0===s)r=g=b=l;else{var q=l<.5?l*(1+s):l+s-l*s,p=2*l-q;r=Math.floor(255*hue2rgb(p,q,h+1/3)),g=Math.floor(255*hue2rgb(p,q,h)),b=Math.floor(255*hue2rgb(p,q,h-1/3))}return this._rgba(r,g,b,1)}}),DrawingBoard.Control.DrawingMode=DrawingBoard.Control.extend({name:"drawingmode",defaults:{pencil:!0,eraser:!0,filler:!0},initialize:function(){this.prevMode=this.board.getMode(),$.each(["pencil","eraser","filler"],$.proxy((function(k,value){this.opts[value]&&this.$el.append('<button class="drawing-board-control-drawingmode-'+value+'-button" data-mode="'+value+'"></button>')}),this)),this.$el.on("click","button[data-mode]",$.proxy((function(e){var value=$(e.currentTarget).attr("data-mode"),mode=this.board.getMode();mode!==value&&(this.prevMode=mode);var newMode=mode===value?this.prevMode:value;this.board.setMode(newMode),e.preventDefault()}),this)),this.board.ev.bind("board:mode",$.proxy((function(mode){this.toggleButtons(mode)}),this)),this.toggleButtons(this.board.getMode())},toggleButtons:function(mode){this.$el.find("button[data-mode]").each((function(k,item){var $item=$(item);$item.toggleClass("active",mode===$item.attr("data-mode"))}))}}),DrawingBoard.Control.Navigation=DrawingBoard.Control.extend({name:"navigation",defaults:{back:!0,forward:!0,reset:!0},initialize:function(){var el="";if(this.opts.back&&(el+='<button class="drawing-board-control-navigation-back">&larr;</button>'),this.opts.forward&&(el+='<button class="drawing-board-control-navigation-forward">&rarr;</button>'),this.opts.reset&&(el+='<button class="drawing-board-control-navigation-reset">&times;</button>'),this.$el.append(el),this.opts.back){var $back=this.$el.find(".drawing-board-control-navigation-back");this.board.ev.bind("historyNavigation",$.proxy((function(pos){1===pos?$back.attr("disabled","disabled"):$back.removeAttr("disabled")}),this)),this.$el.on("click",".drawing-board-control-navigation-back",$.proxy((function(e){this.board.goBackInHistory(),e.preventDefault()}),this))}if(this.opts.forward){var $forward=this.$el.find(".drawing-board-control-navigation-forward");this.board.ev.bind("historyNavigation",$.proxy((function(pos){pos===this.board.history.values.length?$forward.attr("disabled","disabled"):$forward.removeAttr("disabled")}),this)),this.$el.on("click",".drawing-board-control-navigation-forward",$.proxy((function(e){this.board.goForthInHistory(),e.preventDefault()}),this))}this.opts.reset&&this.$el.on("click",".drawing-board-control-navigation-reset",$.proxy((function(e){this.board.reset({background:!0}),e.preventDefault()}),this))}}),DrawingBoard.Control.Size=DrawingBoard.Control.extend({name:"size",defaults:{type:"auto",dropdownValues:[1,3,6,10,20,30,40,50]},types:["dropdown","range"],initialize:function(){"auto"==this.opts.type&&(this.opts.type=this._iHasRangeInput()?"range":"dropdown");var tpl=$.inArray(this.opts.type,this.types)>-1&&this["_"+this.opts.type+"Template"]();if(!tpl)return!1;this.val=this.board.opts.size,this.$el.append($(tpl)),this.$el.attr("data-drawing-board-type",this.opts.type),this.updateView();var that=this;"range"==this.opts.type&&this.$el.on("change",".drawing-board-control-size-range-input",(function(e){that.val=$(this).val(),that.updateView(),that.board.ev.trigger("size:changed",that.val),e.preventDefault()})),"dropdown"==this.opts.type&&(this.$el.on("click",".drawing-board-control-size-dropdown-current",$.proxy((function(e){this.$el.find(".drawing-board-control-size-dropdown").toggleClass("drawing-board-utils-hidden")}),this)),this.$el.on("click","[data-size]",(function(e){that.val=parseInt($(this).attr("data-size"),0),that.updateView(),that.board.ev.trigger("size:changed",that.val),e.preventDefault()})))},_rangeTemplate:function(){return DrawingBoard.Utils.tpl('<div class="drawing-board-control-inner" title="{{size}}"><input type="range" min="1" max="50" value="{{size}}" step="1" class="drawing-board-control-size-range-input"><span class="drawing-board-control-size-range-current"></span></div>',{size:this.board.opts.size})},_dropdownTemplate:function(){var tpl='<div class="drawing-board-control-inner" title="{{size}}"><div class="drawing-board-control-size-dropdown-current"><span></span></div><ul class="drawing-board-control-size-dropdown">';return $.each(this.opts.dropdownValues,(function(i,size){tpl+=DrawingBoard.Utils.tpl('<li data-size="{{size}}"><span style="width: {{size}}px; height: {{size}}px; border-radius: {{size}}px;"></span></li>',{size:size})})),tpl+="</ul></div>"},onBoardReset:function(opts){this.updateView()},updateView:function(){var val=this.val;if(this.board.ctx.lineWidth=val,this.$el.find(".drawing-board-control-size-range-current, .drawing-board-control-size-dropdown-current span").css({width:val+"px",height:val+"px",borderRadius:val+"px",marginLeft:-1*val/2+"px",marginTop:-1*val/2+"px"}),this.$el.find(".drawing-board-control-inner").attr("title",val),"dropdown"==this.opts.type){var closest=null;$.each(this.opts.dropdownValues,(function(i,size){(null===closest||Math.abs(size-val)<Math.abs(closest-val))&&(closest=size)})),this.$el.find(".drawing-board-control-size-dropdown").addClass("drawing-board-utils-hidden")}},_iHasRangeInput:function(){var available,inputElem=document.createElement("input"),docElement=document.documentElement;return inputElem.setAttribute("type","range"),available="text"!==inputElem.type,inputElem.value=":)",inputElem.style.cssText="position:absolute;visibility:hidden;",/^range$/.test("range")&&void 0!==inputElem.style.WebkitAppearance&&(docElement.appendChild(inputElem),defaultView=document.defaultView,available=defaultView.getComputedStyle&&"textfield"!==defaultView.getComputedStyle(inputElem,null).WebkitAppearance&&0!==inputElem.offsetHeight,docElement.removeChild(inputElem)),!!available}}),DrawingBoard.Control.Download=DrawingBoard.Control.extend({name:"download",initialize:function(){this.$el.append('<button class="drawing-board-control-download-button"></button>'),this.$el.on("click",".drawing-board-control-download-button",$.proxy((function(e){this.board.downloadImg(),e.preventDefault()}),this))}}),DrawingBoard.Utils={},DrawingBoard.Utils.tpl=(pattern=new RegExp("{{\\s*([a-z0-9_][\\.a-z0-9_]*)\\s*}}","gi"),function(template,data){return template.replace(pattern,(function(tag,token){for(var path=token.split("."),len=path.length,lookup=data,i=0;i<len;i++){if(void 0===(lookup=lookup[path[i]]))throw"tim: '"+path[i]+"' not found in "+tag;if(i===len-1)return lookup}}))}),DrawingBoard.Utils.MicroEvent=function(){},DrawingBoard.Utils.MicroEvent.prototype={bind:function(event,fct){this._events=this._events||{},this._events[event]=this._events[event]||[],this._events[event].push(fct)},unbind:function(event,fct){this._events=this._events||{},event in this._events!=!1&&this._events[event].splice(this._events[event].indexOf(fct),1)},trigger:function(event){if(this._events=this._events||{},event in this._events!=!1)for(var i=0;i<this._events[event].length;i++)this._events[event][i].apply(this,Array.prototype.slice.call(arguments,1))}},DrawingBoard.Utils._boxBorderSize=function($el,withPadding,withMargin,direction){withPadding=!!withPadding||!0,withMargin=!!withMargin||!1;var props,width=0;"width"==direction?(props=["border-left-width","border-right-width"],withPadding&&props.push("padding-left","padding-right"),withMargin&&props.push("margin-left","margin-right")):(props=["border-top-width","border-bottom-width"],withPadding&&props.push("padding-top","padding-bottom"),withMargin&&props.push("margin-top","margin-bottom"));for(var i=props.length-1;i>=0;i--)width+=parseInt($el.css(props[i]).replace("px",""),10);return width},DrawingBoard.Utils.boxBorderWidth=function($el,withPadding,withMargin){return DrawingBoard.Utils._boxBorderSize($el,withPadding,withMargin,"width")},DrawingBoard.Utils.boxBorderHeight=function($el,withPadding,withMargin){return DrawingBoard.Utils._boxBorderSize($el,withPadding,withMargin,"height")},DrawingBoard.Utils.isColor=function(string){return!(!string||!string.length)&&(/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(string)||-1!==$.inArray(string.substring(0,3),["rgb","hsl"]))},DrawingBoard.Utils.RGBToInt=function(r,g,b){var c=0;return c|=(255&r)<<16,c|=(255&g)<<8,c|=255&b},DrawingBoard.Utils.pixelAt=function(image,x,y){var i=4*(y*image.width+x);return[i,x,y,DrawingBoard.Utils.RGBToInt(image.data[i],image.data[i+1],image.data[i+2])]},function(){for(var vendors=["ms","moz","webkit","o"],x=0;x<vendors.length&&!window.requestAnimationFrame;++x)window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"]}(),("undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this).DrawingBoard=DrawingBoard,DrawingBoard}));

//# sourceMappingURL=drawingboard.min.js.map