define(["jquery","core/log"],(function($,log){return log.debug("PoodLL Stereo Audio Recorder Helper: initialising"),{scriptprocessornode:null,requestDataInvoked:!1,recordingLength:0,isPaused:!1,deviceSampleRate:48e3,leftchannel:[],rightchannel:[],recording:!1,volume:null,audioInput:null,context:null,sampleRate:0,mimeType:0,isPCM:!1,numChannels:1,msr:null,audioctx:null,mediaStream:null,volumeGainNode:null,clone:function(){return $.extend(!0,{},this)},init:function(msr,mediaStream,audioctx){this.msr=msr,this.audioctx=audioctx,this.mediaStream=mediaStream,this.deviceSampleRate=audioctx.sampleRate,this.sampleRate=this.deviceSampleRate,this.mimeType=msr.mimeType||"audio/wav",this.isPCM=this.mimeType.indexOf("audio/pcm")>-1,this.numChannels=msr.audioChannels||1,log.debug("stereohelper mimetype: "+this.mimeType),this.misc()},misc:function(){var that=this,context=this.audioctx;this.volumeGainNode=context.createGain();var volume=this.volumeGainNode;this.audioInput=context.createMediaStreamSource(this.mediaStream),this.audioInput.connect(volume);var bufferSize=this.msr.bufferSize||2048;0===this.msr.bufferSize&&(bufferSize=0);var scriptprocessornode=null;if(context.createJavaScriptNode)scriptprocessornode=context.createJavaScriptNode(bufferSize,this.numChannels,this.numChannels);else{if(!context.createScriptProcessor)throw"WebAudio API has no support on this browser.";scriptprocessornode=context.createScriptProcessor(bufferSize,this.numChannels,this.numChannels)}this.bufferSize=scriptprocessornode.bufferSize,this.requestDataInvoked=!1,this.scriptprocessornode=scriptprocessornode,1===this.numChannels&&log.debug("All right-channels are skipped."),this.isPaused=!1,scriptprocessornode.onaudioprocess=function(e){if(that.recording&&!that.requestDataInvoked&&!that.isPaused){var left=e.inputBuffer.getChannelData(0);if(that.leftchannel.push(new Float32Array(left)),2===that.numChannels){var right=e.inputBuffer.getChannelData(1);that.rightchannel.push(new Float32Array(right))}that.recordingLength+=that.bufferSize}},volume.connect(this.msr.audioanalyser.core),this.msr.audioanalyser.core.connect(scriptprocessornode),scriptprocessornode.connect(context.destination)},record:function(){this.recording=!0,this.leftchannel.length=this.rightchannel.length=0,this.recordingLength=0},encodeWAV:function(samples){var buffer=new ArrayBuffer(44+2*samples.length),view=new DataView(buffer);return this.writeString(view,0,"RIFF"),view.setUint32(4,36+2*samples.length,!0),this.writeString(view,8,"WAVE"),this.writeString(view,12,"fmt "),view.setUint32(16,16,!0),view.setUint16(20,1,!0),view.setUint16(22,this.numChannels,!0),view.setUint32(24,this.sampleRate,!0),view.setUint32(28,4*this.sampleRate,!0),view.setUint16(32,2*this.numChannels,!0),view.setUint16(34,16,!0),this.writeString(view,36,"data"),view.setUint32(40,2*samples.length,!0),this.floatTo16BitPCM(view,44,samples),log.debug(2*samples.length),view},floatTo16BitPCM:function(output,offset,input){for(var i=0;i<input.length;i++,offset+=2){var s=Math.max(-1,Math.min(1,input[i]));output.setInt16(offset,s<0?32768*s:32767*s,!0)}},writeString:function(view,offset,string){for(var i=0;i<string.length;i++)view.setUint8(offset+i,string.charCodeAt(i))},requestData:function(){if(!this.isPaused)if(0!==this.recordingLength){this.requestDataInvoked=!0;var internalLeftChannel=this.leftchannel.slice(0),internalRightChannel=this.rightchannel.slice(0),internalRecordingLength=this.recordingLength;this.leftchannel.length=this.rightchannel.length=[],this.recordingLength=0,this.requestDataInvoked=!1;var leftBuffer=this.mergeBuffers(internalLeftChannel,internalRecordingLength),interleaved=leftBuffer;if(2===this.numChannels){var rightBuffer=this.mergeBuffers(internalRightChannel,internalRecordingLength);interleaved=this.interleave(leftBuffer,rightBuffer)}var dataview=this.encodeWAV(interleaved),audioBlob=new Blob([dataview],{type:"audio/wav"});this.msr.ondataavailable(audioBlob)}else this.requestDataInvoked=!1},xrequestData:function(){if(!this.isPaused)if(0!==this.recordingLength){this.requestDataInvoked=!0;var internalLeftChannel=this.leftchannel.slice(0),internalRightChannel=this.rightchannel.slice(0),internalRecordingLength=this.recordingLength;this.leftchannel.length=this.rightchannel.length=[],this.recordingLength=0,this.requestDataInvoked=!1;var leftBuffer=this.mergeBuffers(internalLeftChannel,internalRecordingLength),interleaved=leftBuffer;if(2===this.numChannels){var rightBuffer=this.mergeBuffers(internalRightChannel,internalRecordingLength);this.interleaved=this.interleave(leftBuffer,rightBuffer)}if(this.isPCM){var blob=new Blob([this.convertoFloat32ToInt16(interleaved)],{type:"audio/pcm"});this.msr.ondataavailable(blob)}else{var buffer=new ArrayBuffer(44+2*interleaved.length),view=new DataView(buffer);this.writeUTFBytes(view,0,"RIFF"),view.setUint32(4,44+2*interleaved.length-8,!0),this.writeUTFBytes(view,8,"WAVE"),this.writeUTFBytes(view,12,"fmt "),view.setUint32(16,16,!0),view.setUint16(20,1,!0),view.setUint16(22,this.numChannels,!0),view.setUint32(24,this.sampleRate,!0),view.setUint32(28,this.sampleRate*this.numChannels*2,!0),view.setUint16(32,2*this.numChannels,!0),view.setUint16(34,16,!0),this.writeUTFBytes(view,36,"data"),view.setUint32(40,2*interleaved.length,!0);for(var lng=interleaved.length,index=44,i=0;i<lng;i++)view.setInt16(index,32767*interleaved[i],!0),index+=2;blob=new Blob([view],{type:"audio/wav"});this.msr.ondataavailable(blob)}}else this.requestDataInvoked=!1},stop:function(){this.recording=!1,this.requestData(),this.audioInput.disconnect()},interleave:function(leftChannel,rightChannel){for(var length=leftChannel.length+rightChannel.length,result=new Float32Array(length),inputIndex=0,index=0;index<length;)result[index++]=leftChannel[inputIndex],result[index++]=rightChannel[inputIndex],inputIndex++;return result},mergeBuffers:function(channelBuffer,recordingLength){for(var result=new Float32Array(recordingLength),offset=0,lng=channelBuffer.length,i=0;i<lng;i++){var buffer=channelBuffer[i];result.set(buffer,offset),offset+=buffer.length}return result},writeUTFBytes:function(view,offset,string){for(var lng=string.length,i=0;i<lng;i++)view.setUint8(offset+i,string.charCodeAt(i))},convertoFloat32ToInt16:function(buffer){for(var l=buffer.length,buf=new Int16Array(l);l--;)buf[l]=65535*buffer[l];return buf.buffer},pause:function(){this.isPaused=!0},resume:function(){this.isPaused=!1}}}));

//# sourceMappingURL=msr_helper_stereoaudio.min.js.map