/*!
 * wavesurfer.js 3.3.3 (2020-04-16)
 * https://github.com/katspaugh/wavesurfer.js
 * @license BSD-3-Clause
 */
var root,factory;root=window,factory=function(){return function(modules){var installedModules={};function __webpack_require__(moduleId){if(installedModules[moduleId])return installedModules[moduleId].exports;var module=installedModules[moduleId]={i:moduleId,l:!1,exports:{}};return modules[moduleId].call(module.exports,module,module.exports,__webpack_require__),module.l=!0,module.exports}return __webpack_require__.m=modules,__webpack_require__.c=installedModules,__webpack_require__.d=function(exports,name,getter){__webpack_require__.o(exports,name)||Object.defineProperty(exports,name,{enumerable:!0,get:getter})},__webpack_require__.r=function(exports){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(exports,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(exports,"__esModule",{value:!0})},__webpack_require__.t=function(value,mode){if(1&mode&&(value=__webpack_require__(value)),8&mode)return value;if(4&mode&&"object"==typeof value&&value&&value.__esModule)return value;var ns=Object.create(null);if(__webpack_require__.r(ns),Object.defineProperty(ns,"default",{enumerable:!0,value:value}),2&mode&&"string"!=typeof value)for(var key in value)__webpack_require__.d(ns,key,function(key){return value[key]}.bind(null,key));return ns},__webpack_require__.n=function(module){var getter=module&&module.__esModule?function(){return module.default}:function(){return module};return __webpack_require__.d(getter,"a",getter),getter},__webpack_require__.o=function(object,property){return Object.prototype.hasOwnProperty.call(object,property)},__webpack_require__.p="",__webpack_require__(__webpack_require__.s="./src/wavesurfer.js")}({"./node_modules/debounce/index.js":function(module,exports){function debounce(func,wait,immediate){var timeout,args,context,timestamp,result;function later(){var last=Date.now()-timestamp;last<wait&&last>=0?timeout=setTimeout(later,wait-last):(timeout=null,immediate||(result=func.apply(context,args),context=args=null))}null==wait&&(wait=100);var debounced=function(){context=this,args=arguments,timestamp=Date.now();var callNow=immediate&&!timeout;return timeout||(timeout=setTimeout(later,wait)),callNow&&(result=func.apply(context,args),context=args=null),result};return debounced.clear=function(){timeout&&(clearTimeout(timeout),timeout=null)},debounced.flush=function(){timeout&&(result=func.apply(context,args),context=args=null,clearTimeout(timeout),timeout=null)},debounced}debounce.debounce=debounce,module.exports=debounce},"./src/drawer.canvasentry.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=void 0;var _style=_interopRequireDefault(__webpack_require__("./src/util/style.js")),_getId=_interopRequireDefault(__webpack_require__("./src/util/get-id.js"));function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}var CanvasEntry=function(){function CanvasEntry(){!function(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}(this,CanvasEntry),this.wave=null,this.waveCtx=null,this.progress=null,this.progressCtx=null,this.start=0,this.end=1,this.id=(0,_getId.default)(void 0!==this.constructor.name?this.constructor.name.toLowerCase()+"_":"canvasentry_"),this.canvasContextAttributes={}}var Constructor,protoProps,staticProps;return Constructor=CanvasEntry,(protoProps=[{key:"initWave",value:function(element){this.wave=element,this.waveCtx=this.wave.getContext("2d",this.canvasContextAttributes)}},{key:"initProgress",value:function(element){this.progress=element,this.progressCtx=this.progress.getContext("2d",this.canvasContextAttributes)}},{key:"updateDimensions",value:function(elementWidth,totalWidth,width,height){this.start=this.wave.offsetLeft/totalWidth||0,this.end=this.start+elementWidth/totalWidth,this.wave.width=width,this.wave.height=height;var elementSize={width:elementWidth+"px"};(0,_style.default)(this.wave,elementSize),this.hasProgressCanvas&&(this.progress.width=width,this.progress.height=height,(0,_style.default)(this.progress,elementSize))}},{key:"clearWave",value:function(){this.waveCtx.clearRect(0,0,this.waveCtx.canvas.width,this.waveCtx.canvas.height),this.hasProgressCanvas&&this.progressCtx.clearRect(0,0,this.progressCtx.canvas.width,this.progressCtx.canvas.height)}},{key:"setFillStyles",value:function(waveColor,progressColor){this.waveCtx.fillStyle=waveColor,this.hasProgressCanvas&&(this.progressCtx.fillStyle=progressColor)}},{key:"fillRects",value:function(x,y,width,height,radius){this.fillRectToContext(this.waveCtx,x,y,width,height,radius),this.hasProgressCanvas&&this.fillRectToContext(this.progressCtx,x,y,width,height,radius)}},{key:"fillRectToContext",value:function(ctx,x,y,width,height,radius){ctx&&(radius?this.drawRoundedRect(ctx,x,y,width,height,radius):ctx.fillRect(x,y,width,height))}},{key:"drawRoundedRect",value:function(ctx,x,y,width,height,radius){0!==height&&(height<0&&(y-=height*=-1),ctx.beginPath(),ctx.moveTo(x+radius,y),ctx.lineTo(x+width-radius,y),ctx.quadraticCurveTo(x+width,y,x+width,y+radius),ctx.lineTo(x+width,y+height-radius),ctx.quadraticCurveTo(x+width,y+height,x+width-radius,y+height),ctx.lineTo(x+radius,y+height),ctx.quadraticCurveTo(x,y+height,x,y+height-radius),ctx.lineTo(x,y+radius),ctx.quadraticCurveTo(x,y,x+radius,y),ctx.closePath(),ctx.fill())}},{key:"drawLines",value:function(peaks,absmax,halfH,offsetY,start,end){this.drawLineToContext(this.waveCtx,peaks,absmax,halfH,offsetY,start,end),this.hasProgressCanvas&&this.drawLineToContext(this.progressCtx,peaks,absmax,halfH,offsetY,start,end)}},{key:"drawLineToContext",value:function(ctx,peaks,absmax,halfH,offsetY,start,end){if(ctx){var i,peak,h,length=peaks.length/2,first=Math.round(length*this.start),canvasStart=first,canvasEnd=Math.round(length*this.end)+1,scale=this.wave.width/(canvasEnd-canvasStart-1),halfOffset=halfH+offsetY,absmaxHalf=absmax/halfH;for(ctx.beginPath(),ctx.moveTo((canvasStart-first)*scale,halfOffset),ctx.lineTo((canvasStart-first)*scale,halfOffset-Math.round((peaks[2*canvasStart]||0)/absmaxHalf)),i=canvasStart;i<canvasEnd;i++)peak=peaks[2*i]||0,h=Math.round(peak/absmaxHalf),ctx.lineTo((i-first)*scale+this.halfPixel,halfOffset-h);for(var j=canvasEnd-1;j>=canvasStart;j--)peak=peaks[2*j+1]||0,h=Math.round(peak/absmaxHalf),ctx.lineTo((j-first)*scale+this.halfPixel,halfOffset-h);ctx.lineTo((canvasStart-first)*scale,halfOffset-Math.round((peaks[2*canvasStart+1]||0)/absmaxHalf)),ctx.closePath(),ctx.fill()}}},{key:"destroy",value:function(){this.waveCtx=null,this.wave=null,this.progressCtx=null,this.progress=null}},{key:"getImage",value:function(format,quality,type){var _this=this;return"blob"===type?new Promise((function(resolve){_this.wave.toBlob(resolve,format,quality)})):"dataURL"===type?this.wave.toDataURL(format,quality):void 0}}])&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),CanvasEntry}();return exports.default=CanvasEntry,module.exports=exports.default,exports.default},"./src/drawer.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=void 0;var util=function(obj){if(obj&&obj.__esModule)return obj;if(null===obj||"object"!==_typeof(obj)&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache();if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}(__webpack_require__("./src/util/index.js"));function _getRequireWildcardCache(){if("function"!=typeof WeakMap)return null;var cache=new WeakMap;return _getRequireWildcardCache=function(){return cache},cache}function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}function _possibleConstructorReturn(self,call){return!call||"object"!==_typeof(call)&&"function"!=typeof call?function(self){if(void 0===self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return self}(self):call}function _getPrototypeOf(o){return _getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function(o){return o.__proto__||Object.getPrototypeOf(o)},_getPrototypeOf(o)}function _setPrototypeOf(o,p){return _setPrototypeOf=Object.setPrototypeOf||function(o,p){return o.__proto__=p,o},_setPrototypeOf(o,p)}var Drawer=function(_util$Observer){function Drawer(container,params){var _this;return function(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}(this,Drawer),(_this=_possibleConstructorReturn(this,_getPrototypeOf(Drawer).call(this))).container=container,_this.params=params,_this.width=0,_this.height=params.height*_this.params.pixelRatio,_this.lastPos=0,_this.wrapper=null,_this}var Constructor,protoProps,staticProps;return function(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),superClass&&_setPrototypeOf(subClass,superClass)}(Drawer,_util$Observer),Constructor=Drawer,(protoProps=[{key:"style",value:function(el,styles){return util.style(el,styles)}},{key:"createWrapper",value:function(){this.wrapper=this.container.appendChild(document.createElement("wave")),this.style(this.wrapper,{display:"block",position:"relative",userSelect:"none",webkitUserSelect:"none",height:this.params.height+"px"}),(this.params.fillParent||this.params.scrollParent)&&this.style(this.wrapper,{width:"100%",overflowX:this.params.hideScrollbar?"hidden":"auto",overflowY:"hidden"}),this.setupWrapperEvents()}},{key:"handleEvent",value:function(e,noPrevent){!noPrevent&&e.preventDefault();var progress,clientX=e.targetTouches?e.targetTouches[0].clientX:e.clientX,bbox=this.wrapper.getBoundingClientRect(),nominalWidth=this.width,parentWidth=this.getWidth();return!this.params.fillParent&&nominalWidth<parentWidth?(progress=(this.params.rtl?bbox.right-clientX:clientX-bbox.left)*(this.params.pixelRatio/nominalWidth)||0)>1&&(progress=1):progress=((this.params.rtl?bbox.right-clientX:clientX-bbox.left)+this.wrapper.scrollLeft)/this.wrapper.scrollWidth||0,progress}},{key:"setupWrapperEvents",value:function(){var _this2=this;this.wrapper.addEventListener("click",(function(e){var scrollbarHeight=_this2.wrapper.offsetHeight-_this2.wrapper.clientHeight;if(0!==scrollbarHeight){var bbox=_this2.wrapper.getBoundingClientRect();if(e.clientY>=bbox.bottom-scrollbarHeight)return}_this2.params.interact&&_this2.fireEvent("click",e,_this2.handleEvent(e))})),this.wrapper.addEventListener("dblclick",(function(e){_this2.params.interact&&_this2.fireEvent("dblclick",e,_this2.handleEvent(e))})),this.wrapper.addEventListener("scroll",(function(e){return _this2.fireEvent("scroll",e)}))}},{key:"drawPeaks",value:function(peaks,length,start,end){this.setWidth(length)||this.clearWave(),this.params.barWidth?this.drawBars(peaks,0,start,end):this.drawWave(peaks,0,start,end)}},{key:"resetScroll",value:function(){null!==this.wrapper&&(this.wrapper.scrollLeft=0)}},{key:"recenter",value:function(percent){var position=this.wrapper.scrollWidth*percent;this.recenterOnPosition(position,!0)}},{key:"recenterOnPosition",value:function(position,immediate){var scrollLeft=this.wrapper.scrollLeft,half=~~(this.wrapper.clientWidth/2),maxScroll=this.wrapper.scrollWidth-this.wrapper.clientWidth,target=position-half,offset=target-scrollLeft;if(0!=maxScroll){if(!immediate&&-half<=offset&&offset<half){var rate=this.params.autoCenterRate;rate/=half,rate*=maxScroll,target=scrollLeft+(offset=Math.max(-rate,Math.min(rate,offset)))}(target=Math.max(0,Math.min(maxScroll,target)))!=scrollLeft&&(this.wrapper.scrollLeft=target)}}},{key:"getScrollX",value:function(){var x=0;if(this.wrapper){var pixelRatio=this.params.pixelRatio;if(x=Math.round(this.wrapper.scrollLeft*pixelRatio),this.params.scrollParent){var maxScroll=~~(this.wrapper.scrollWidth*pixelRatio-this.getWidth());x=Math.min(maxScroll,Math.max(0,x))}}return x}},{key:"getWidth",value:function(){return Math.round(this.container.clientWidth*this.params.pixelRatio)}},{key:"setWidth",value:function(width){return this.width!=width&&(this.width=width,this.params.fillParent||this.params.scrollParent?this.style(this.wrapper,{width:""}):this.style(this.wrapper,{width:~~(this.width/this.params.pixelRatio)+"px"}),this.updateSize(),!0)}},{key:"setHeight",value:function(height){return height!=this.height&&(this.height=height,this.style(this.wrapper,{height:~~(this.height/this.params.pixelRatio)+"px"}),this.updateSize(),!0)}},{key:"progress",value:function(_progress){var minPxDelta=1/this.params.pixelRatio,pos=Math.round(_progress*this.width)*minPxDelta;if(pos<this.lastPos||pos-this.lastPos>=minPxDelta){if(this.lastPos=pos,this.params.scrollParent&&this.params.autoCenter){var newPos=~~(this.wrapper.scrollWidth*_progress);this.recenterOnPosition(newPos,this.params.autoCenterImmediately)}this.updateProgress(pos)}}},{key:"destroy",value:function(){this.unAll(),this.wrapper&&(this.wrapper.parentNode==this.container&&this.container.removeChild(this.wrapper),this.wrapper=null)}},{key:"updateCursor",value:function(){}},{key:"updateSize",value:function(){}},{key:"drawBars",value:function(peaks,channelIndex,start,end){}},{key:"drawWave",value:function(peaks,channelIndex,start,end){}},{key:"clearWave",value:function(){}},{key:"updateProgress",value:function(position){}}])&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Drawer}(util.Observer);exports.default=Drawer,module.exports=exports.default},"./src/drawer.multicanvas.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=void 0;var _drawer=_interopRequireDefault(__webpack_require__("./src/drawer.js")),util=function(obj){if(obj&&obj.__esModule)return obj;if(null===obj||"object"!==_typeof(obj)&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache();if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}(__webpack_require__("./src/util/index.js")),_drawer2=_interopRequireDefault(__webpack_require__("./src/drawer.canvasentry.js"));function _getRequireWildcardCache(){if("function"!=typeof WeakMap)return null;var cache=new WeakMap;return _getRequireWildcardCache=function(){return cache},cache}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}function _possibleConstructorReturn(self,call){return!call||"object"!==_typeof(call)&&"function"!=typeof call?function(self){if(void 0===self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return self}(self):call}function _getPrototypeOf(o){return _getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function(o){return o.__proto__||Object.getPrototypeOf(o)},_getPrototypeOf(o)}function _setPrototypeOf(o,p){return _setPrototypeOf=Object.setPrototypeOf||function(o,p){return o.__proto__=p,o},_setPrototypeOf(o,p)}var MultiCanvas=function(_Drawer){function MultiCanvas(container,params){var _this;return function(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}(this,MultiCanvas),(_this=_possibleConstructorReturn(this,_getPrototypeOf(MultiCanvas).call(this,container,params))).maxCanvasWidth=params.maxCanvasWidth,_this.maxCanvasElementWidth=Math.round(params.maxCanvasWidth/params.pixelRatio),_this.hasProgressCanvas=params.waveColor!=params.progressColor,_this.halfPixel=.5/params.pixelRatio,_this.canvases=[],_this.progressWave=null,_this.EntryClass=_drawer2.default,_this.canvasContextAttributes=params.drawingContextAttributes,_this.overlap=2*Math.ceil(params.pixelRatio/2),_this.barRadius=params.barRadius||0,_this}var Constructor,protoProps,staticProps;return function(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),superClass&&_setPrototypeOf(subClass,superClass)}(MultiCanvas,_Drawer),Constructor=MultiCanvas,(protoProps=[{key:"init",value:function(){this.createWrapper(),this.createElements()}},{key:"createElements",value:function(){this.progressWave=this.wrapper.appendChild(this.style(document.createElement("wave"),{position:"absolute",zIndex:3,left:0,top:0,bottom:0,overflow:"hidden",width:"0",display:"none",boxSizing:"border-box",borderRightStyle:"solid",pointerEvents:"none"})),this.addCanvas(),this.updateCursor()}},{key:"updateCursor",value:function(){this.style(this.progressWave,{borderRightWidth:this.params.cursorWidth+"px",borderRightColor:this.params.cursorColor})}},{key:"updateSize",value:function(){for(var _this2=this,totalWidth=Math.round(this.width/this.params.pixelRatio),requiredCanvases=Math.ceil(totalWidth/(this.maxCanvasElementWidth+this.overlap));this.canvases.length<requiredCanvases;)this.addCanvas();for(;this.canvases.length>requiredCanvases;)this.removeCanvas();var canvasWidth=this.maxCanvasWidth+this.overlap,lastCanvas=this.canvases.length-1;this.canvases.forEach((function(entry,i){i==lastCanvas&&(canvasWidth=_this2.width-_this2.maxCanvasWidth*lastCanvas),_this2.updateDimensions(entry,canvasWidth,_this2.height),entry.clearWave()}))}},{key:"addCanvas",value:function(){var entry=new this.EntryClass;entry.canvasContextAttributes=this.canvasContextAttributes,entry.hasProgressCanvas=this.hasProgressCanvas,entry.halfPixel=this.halfPixel;var leftOffset=this.maxCanvasElementWidth*this.canvases.length;entry.initWave(this.wrapper.appendChild(this.style(document.createElement("canvas"),{position:"absolute",zIndex:2,left:leftOffset+"px",top:0,bottom:0,height:"100%",pointerEvents:"none"}))),this.hasProgressCanvas&&entry.initProgress(this.progressWave.appendChild(this.style(document.createElement("canvas"),{position:"absolute",left:leftOffset+"px",top:0,bottom:0,height:"100%"}))),this.canvases.push(entry)}},{key:"removeCanvas",value:function(){var lastEntry=this.canvases[this.canvases.length-1];lastEntry.wave.parentElement.removeChild(lastEntry.wave),this.hasProgressCanvas&&lastEntry.progress.parentElement.removeChild(lastEntry.progress),lastEntry&&(lastEntry.destroy(),lastEntry=null),this.canvases.pop()}},{key:"updateDimensions",value:function(entry,width,height){var elementWidth=Math.round(width/this.params.pixelRatio),totalWidth=Math.round(this.width/this.params.pixelRatio);entry.updateDimensions(elementWidth,totalWidth,width,height),this.style(this.progressWave,{display:"block"})}},{key:"clearWave",value:function(){var _this3=this;util.frame((function(){_this3.canvases.forEach((function(entry){return entry.clearWave()}))}))()}},{key:"drawBars",value:function(peaks,channelIndex,start,end){var _this4=this;return this.prepareDraw(peaks,channelIndex,start,end,(function(_ref){var absmax=_ref.absmax,hasMinVals=_ref.hasMinVals,offsetY=(_ref.height,_ref.offsetY),halfH=_ref.halfH,peaks=_ref.peaks;if(void 0!==start)for(var peakIndexScale=hasMinVals?2:1,length=peaks.length/peakIndexScale,bar=_this4.params.barWidth*_this4.params.pixelRatio,step=bar+(null===_this4.params.barGap?Math.max(_this4.params.pixelRatio,~~(bar/2)):Math.max(_this4.params.pixelRatio,_this4.params.barGap*_this4.params.pixelRatio)),scale=length/_this4.width,last=end,i=start;i<last;i+=step){var peak=peaks[Math.floor(i*scale*peakIndexScale)]||0,h=Math.round(peak/absmax*halfH);0==h&&_this4.params.barMinHeight&&(h=_this4.params.barMinHeight),_this4.fillRect(i+_this4.halfPixel,halfH-h+offsetY,bar+_this4.halfPixel,2*h,_this4.barRadius)}}))}},{key:"drawWave",value:function(peaks,channelIndex,start,end){var _this5=this;return this.prepareDraw(peaks,channelIndex,start,end,(function(_ref2){var absmax=_ref2.absmax,hasMinVals=_ref2.hasMinVals,offsetY=(_ref2.height,_ref2.offsetY),halfH=_ref2.halfH,peaks=_ref2.peaks;if(!hasMinVals){for(var reflectedPeaks=[],len=peaks.length,i=0;i<len;i++)reflectedPeaks[2*i]=peaks[i],reflectedPeaks[2*i+1]=-peaks[i];peaks=reflectedPeaks}void 0!==start&&_this5.drawLine(peaks,absmax,halfH,offsetY,start,end),_this5.fillRect(0,halfH+offsetY-_this5.halfPixel,_this5.width,_this5.halfPixel,_this5.barRadius)}))}},{key:"drawLine",value:function(peaks,absmax,halfH,offsetY,start,end){var _this6=this;this.canvases.forEach((function(entry){_this6.setFillStyles(entry),entry.drawLines(peaks,absmax,halfH,offsetY,start,end)}))}},{key:"fillRect",value:function(x,y,width,height,radius){for(var startCanvas=Math.floor(x/this.maxCanvasWidth),endCanvas=Math.min(Math.ceil((x+width)/this.maxCanvasWidth)+1,this.canvases.length),i=startCanvas;i<endCanvas;i++){var entry=this.canvases[i],leftOffset=i*this.maxCanvasWidth,intersection={x1:Math.max(x,i*this.maxCanvasWidth),y1:y,x2:Math.min(x+width,i*this.maxCanvasWidth+entry.wave.width),y2:y+height};intersection.x1<intersection.x2&&(this.setFillStyles(entry),entry.fillRects(intersection.x1-leftOffset,intersection.y1,intersection.x2-intersection.x1,intersection.y2-intersection.y1,radius))}}},{key:"prepareDraw",value:function(peaks,channelIndex,start,end,fn){var _this7=this;return util.frame((function(){if(peaks[0]instanceof Array){var channels=peaks;if(_this7.params.splitChannels)return _this7.setHeight(channels.length*_this7.params.height*_this7.params.pixelRatio),channels.forEach((function(channelPeaks,i){return _this7.prepareDraw(channelPeaks,i,start,end,fn)}));peaks=channels[0]}var absmax=1/_this7.params.barHeight;if(_this7.params.normalize){var max=util.max(peaks),min=util.min(peaks);absmax=-min>max?-min:max}var hasMinVals=[].some.call(peaks,(function(val){return val<0})),height=_this7.params.height*_this7.params.pixelRatio;return fn({absmax:absmax,hasMinVals:hasMinVals,height:height,offsetY:height*channelIndex||0,halfH:height/2,peaks:peaks})}))()}},{key:"setFillStyles",value:function(entry){entry.setFillStyles(this.params.waveColor,this.params.progressColor)}},{key:"getImage",value:function(format,quality,type){if("blob"===type)return Promise.all(this.canvases.map((function(entry){return entry.getImage(format,quality,type)})));if("dataURL"===type){var images=this.canvases.map((function(entry){return entry.getImage(format,quality,type)}));return images.length>1?images:images[0]}}},{key:"updateProgress",value:function(position){this.style(this.progressWave,{width:position+"px"})}}])&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),MultiCanvas}(_drawer.default);exports.default=MultiCanvas,module.exports=exports.default},"./src/mediaelement-webaudio.js":function(module,exports,__webpack_require__){var obj;function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}function _possibleConstructorReturn(self,call){return!call||"object"!==_typeof(call)&&"function"!=typeof call?function(self){if(void 0===self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return self}(self):call}function _get(target,property,receiver){return _get="undefined"!=typeof Reflect&&Reflect.get?Reflect.get:function(target,property,receiver){var base=function(object,property){for(;!Object.prototype.hasOwnProperty.call(object,property)&&null!==(object=_getPrototypeOf(object)););return object}(target,property);if(base){var desc=Object.getOwnPropertyDescriptor(base,property);return desc.get?desc.get.call(receiver):desc.value}},_get(target,property,receiver||target)}function _getPrototypeOf(o){return _getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function(o){return o.__proto__||Object.getPrototypeOf(o)},_getPrototypeOf(o)}function _setPrototypeOf(o,p){return _setPrototypeOf=Object.setPrototypeOf||function(o,p){return o.__proto__=p,o},_setPrototypeOf(o,p)}Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=void 0;var MediaElementWebAudio=function(_MediaElement){function MediaElementWebAudio(params){var _this;return function(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}(this,MediaElementWebAudio),(_this=_possibleConstructorReturn(this,_getPrototypeOf(MediaElementWebAudio).call(this,params))).params=params,_this.sourceMediaElement=null,_this}var Constructor,protoProps,staticProps;return function(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),superClass&&_setPrototypeOf(subClass,superClass)}(MediaElementWebAudio,_MediaElement),Constructor=MediaElementWebAudio,(protoProps=[{key:"init",value:function(){this.setPlaybackRate(this.params.audioRate),this.createTimer(),this.createVolumeNode(),this.createScriptNode(),this.createAnalyserNode()}},{key:"_load",value:function(media,peaks){_get(_getPrototypeOf(MediaElementWebAudio.prototype),"_load",this).call(this,media,peaks),this.createMediaElementSource(media)}},{key:"createMediaElementSource",value:function(mediaElement){this.sourceMediaElement=this.ac.createMediaElementSource(mediaElement),this.sourceMediaElement.connect(this.analyser)}}])&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),MediaElementWebAudio}(((obj=__webpack_require__("./src/mediaelement.js"))&&obj.__esModule?obj:{default:obj}).default);exports.default=MediaElementWebAudio,module.exports=exports.default},"./src/mediaelement.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=void 0;var obj,_webaudio=(obj=__webpack_require__("./src/webaudio.js"))&&obj.__esModule?obj:{default:obj},util=function(obj){if(obj&&obj.__esModule)return obj;if(null===obj||"object"!==_typeof(obj)&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache();if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}(__webpack_require__("./src/util/index.js"));function _getRequireWildcardCache(){if("function"!=typeof WeakMap)return null;var cache=new WeakMap;return _getRequireWildcardCache=function(){return cache},cache}function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}function _possibleConstructorReturn(self,call){return!call||"object"!==_typeof(call)&&"function"!=typeof call?function(self){if(void 0===self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return self}(self):call}function _get(target,property,receiver){return _get="undefined"!=typeof Reflect&&Reflect.get?Reflect.get:function(target,property,receiver){var base=function(object,property){for(;!Object.prototype.hasOwnProperty.call(object,property)&&null!==(object=_getPrototypeOf(object)););return object}(target,property);if(base){var desc=Object.getOwnPropertyDescriptor(base,property);return desc.get?desc.get.call(receiver):desc.value}},_get(target,property,receiver||target)}function _getPrototypeOf(o){return _getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function(o){return o.__proto__||Object.getPrototypeOf(o)},_getPrototypeOf(o)}function _setPrototypeOf(o,p){return _setPrototypeOf=Object.setPrototypeOf||function(o,p){return o.__proto__=p,o},_setPrototypeOf(o,p)}var MediaElement=function(_WebAudio){function MediaElement(params){var _this;return function(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}(this,MediaElement),(_this=_possibleConstructorReturn(this,_getPrototypeOf(MediaElement).call(this,params))).params=params,_this.media={currentTime:0,duration:0,paused:!0,playbackRate:1,play:function(){},pause:function(){},volume:0},_this.mediaType=params.mediaType.toLowerCase(),_this.elementPosition=params.elementPosition,_this.peaks=null,_this.playbackRate=1,_this.volume=1,_this.isMuted=!1,_this.buffer=null,_this.onPlayEnd=null,_this.mediaListeners={},_this}var Constructor,protoProps,staticProps;return function(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),superClass&&_setPrototypeOf(subClass,superClass)}(MediaElement,_WebAudio),Constructor=MediaElement,(protoProps=[{key:"init",value:function(){this.setPlaybackRate(this.params.audioRate),this.createTimer()}},{key:"_setupMediaListeners",value:function(){var _this2=this;this.mediaListeners.error=function(){_this2.fireEvent("error","Error loading media element")},this.mediaListeners.canplay=function(){_this2.fireEvent("canplay")},this.mediaListeners.ended=function(){_this2.fireEvent("finish")},this.mediaListeners.play=function(){_this2.fireEvent("play")},this.mediaListeners.pause=function(){_this2.fireEvent("pause")},this.mediaListeners.seeked=function(event){_this2.fireEvent("seek")},this.mediaListeners.volumechange=function(event){_this2.isMuted=_this2.media.muted,_this2.isMuted?_this2.volume=0:_this2.volume=_this2.media.volume,_this2.fireEvent("volume")},Object.keys(this.mediaListeners).forEach((function(id){_this2.media.removeEventListener(id,_this2.mediaListeners[id]),_this2.media.addEventListener(id,_this2.mediaListeners[id])}))}},{key:"createTimer",value:function(){var _this3=this;this.on("play",(function onAudioProcess(){_this3.isPaused()||(_this3.fireEvent("audioprocess",_this3.getCurrentTime()),util.frame(onAudioProcess)())})),this.on("pause",(function(){_this3.fireEvent("audioprocess",_this3.getCurrentTime())}))}},{key:"load",value:function(url,container,peaks,preload){var media=document.createElement(this.mediaType);media.controls=this.params.mediaControls,media.autoplay=this.params.autoplay||!1,media.preload=null==preload?"auto":preload,media.src=url,media.style.width="100%";var prevMedia=container.querySelector(this.mediaType);prevMedia&&container.removeChild(prevMedia),container.appendChild(media),this._load(media,peaks)}},{key:"loadElt",value:function(elt,peaks){elt.controls=this.params.mediaControls,elt.autoplay=this.params.autoplay||!1,this._load(elt,peaks)}},{key:"_load",value:function(media,peaks){if(!(media instanceof HTMLMediaElement)||void 0===media.addEventListener)throw new Error("media parameter is not a valid media element");"function"==typeof media.load&&media.load(),this.media=media,this._setupMediaListeners(),this.peaks=peaks,this.onPlayEnd=null,this.buffer=null,this.isMuted=media.muted,this.setPlaybackRate(this.playbackRate),this.setVolume(this.volume)}},{key:"isPaused",value:function(){return!this.media||this.media.paused}},{key:"getDuration",value:function(){if(this.explicitDuration)return this.explicitDuration;var duration=(this.buffer||this.media).duration;return duration>=1/0&&(duration=this.media.seekable.end(0)),duration}},{key:"getCurrentTime",value:function(){return this.media&&this.media.currentTime}},{key:"getPlayedPercents",value:function(){return this.getCurrentTime()/this.getDuration()||0}},{key:"getPlaybackRate",value:function(){return this.playbackRate||this.media.playbackRate}},{key:"setPlaybackRate",value:function(value){this.playbackRate=value||1,this.media.playbackRate=this.playbackRate}},{key:"seekTo",value:function(start){null!=start&&(this.media.currentTime=start),this.clearPlayEnd()}},{key:"play",value:function(start,end){this.seekTo(start);var promise=this.media.play();return end&&this.setPlayEnd(end),promise}},{key:"pause",value:function(){var promise;return this.media&&(promise=this.media.pause()),this.clearPlayEnd(),promise}},{key:"setPlayEnd",value:function(end){var _this4=this;this.clearPlayEnd(),this._onPlayEnd=function(time){time>=end&&(_this4.pause(),_this4.seekTo(end))},this.on("audioprocess",this._onPlayEnd)}},{key:"clearPlayEnd",value:function(){this._onPlayEnd&&(this.un("audioprocess",this._onPlayEnd),this._onPlayEnd=null)}},{key:"getPeaks",value:function(length,first,last){return this.buffer?_get(_getPrototypeOf(MediaElement.prototype),"getPeaks",this).call(this,length,first,last):this.peaks||[]}},{key:"setSinkId",value:function(deviceId){return deviceId?this.media.setSinkId?this.media.setSinkId(deviceId):Promise.reject(new Error("setSinkId is not supported in your browser")):Promise.reject(new Error("Invalid deviceId: "+deviceId))}},{key:"getVolume",value:function(){return this.volume}},{key:"setVolume",value:function(value){this.volume=value,this.media.volume!==this.volume&&(this.media.volume=this.volume)}},{key:"destroy",value:function(){var _this5=this;this.pause(),this.unAll(),this.destroyed=!0,Object.keys(this.mediaListeners).forEach((function(id){_this5.media&&_this5.media.removeEventListener(id,_this5.mediaListeners[id])})),this.params.removeMediaElementOnDestroy&&this.media&&this.media.parentNode&&this.media.parentNode.removeChild(this.media),this.media=null}}])&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),MediaElement}(_webaudio.default);exports.default=MediaElement,module.exports=exports.default},"./src/peakcache.js":function(module,exports,__webpack_require__){function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=void 0;var PeakCache=function(){function PeakCache(){!function(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}(this,PeakCache),this.clearPeakCache()}var Constructor,protoProps,staticProps;return Constructor=PeakCache,(protoProps=[{key:"clearPeakCache",value:function(){this.peakCacheRanges=[],this.peakCacheLength=-1}},{key:"addRangeToPeakCache",value:function(length,start,end){length!=this.peakCacheLength&&(this.clearPeakCache(),this.peakCacheLength=length);for(var uncachedRanges=[],i=0;i<this.peakCacheRanges.length&&this.peakCacheRanges[i]<start;)i++;for(i%2==0&&uncachedRanges.push(start);i<this.peakCacheRanges.length&&this.peakCacheRanges[i]<=end;)uncachedRanges.push(this.peakCacheRanges[i]),i++;i%2==0&&uncachedRanges.push(end),uncachedRanges=uncachedRanges.filter((function(item,pos,arr){return 0==pos?item!=arr[pos+1]:pos==arr.length-1?item!=arr[pos-1]:item!=arr[pos-1]&&item!=arr[pos+1]})),this.peakCacheRanges=this.peakCacheRanges.concat(uncachedRanges),this.peakCacheRanges=this.peakCacheRanges.sort((function(a,b){return a-b})).filter((function(item,pos,arr){return 0==pos?item!=arr[pos+1]:pos==arr.length-1?item!=arr[pos-1]:item!=arr[pos-1]&&item!=arr[pos+1]}));var uncachedRangePairs=[];for(i=0;i<uncachedRanges.length;i+=2)uncachedRangePairs.push([uncachedRanges[i],uncachedRanges[i+1]]);return uncachedRangePairs}},{key:"getCacheRanges",value:function(){var i,peakCacheRangePairs=[];for(i=0;i<this.peakCacheRanges.length;i+=2)peakCacheRangePairs.push([this.peakCacheRanges[i],this.peakCacheRanges[i+1]]);return peakCacheRangePairs}}])&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),PeakCache}();exports.default=PeakCache,module.exports=exports.default},"./src/util/ajax.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=function(options){var instance=new _observer.default,xhr=new XMLHttpRequest,fired100=!1;return xhr.open(options.method||"GET",options.url,!0),xhr.responseType=options.responseType||"json",options.xhr&&(options.xhr.requestHeaders&&options.xhr.requestHeaders.forEach((function(header){xhr.setRequestHeader(header.key,header.value)})),options.xhr.withCredentials&&(xhr.withCredentials=!0)),xhr.addEventListener("progress",(function(e){instance.fireEvent("progress",e),e.lengthComputable&&e.loaded==e.total&&(fired100=!0)})),xhr.addEventListener("load",(function(e){fired100||instance.fireEvent("progress",e),instance.fireEvent("load",e),200==xhr.status||206==xhr.status?instance.fireEvent("success",xhr.response,e):instance.fireEvent("error",e)})),xhr.addEventListener("error",(function(e){return instance.fireEvent("error",e)})),xhr.send(),instance.xhr=xhr,instance};var obj,_observer=(obj=__webpack_require__("./src/util/observer.js"))&&obj.__esModule?obj:{default:obj};module.exports=exports.default},"./src/util/extend.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=function(dest){console.warn("util.extend is deprecated; use Object.assign instead");for(var _len=arguments.length,sources=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++)sources[_key-1]=arguments[_key];return sources.forEach((function(source){Object.keys(source).forEach((function(key){dest[key]=source[key]}))})),dest},module.exports=exports.default},"./src/util/fetch.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=function(options){if(!options)throw new Error("fetch options missing");if(!options.url)throw new Error("fetch url missing");var instance=new _observer.default,fetchHeaders=new Headers,fetchRequest=new Request(options.url);instance.controller=new AbortController,options&&options.requestHeaders&&options.requestHeaders.forEach((function(header){fetchHeaders.append(header.key,header.value)}));var responseType=options.responseType||"json",fetchOptions={method:options.method||"GET",headers:fetchHeaders,mode:options.mode||"cors",credentials:options.credentials||"same-origin",cache:options.cache||"default",redirect:options.redirect||"follow",referrer:options.referrer||"client",signal:instance.controller.signal};return fetch(fetchRequest,fetchOptions).then((function(response){instance.response=response;var progressAvailable=!0;response.body||(progressAvailable=!1);var contentLength=response.headers.get("content-length");return null===contentLength&&(progressAvailable=!1),progressAvailable?(instance.onProgress=function(e){instance.fireEvent("progress",e)},new Response(new ReadableStream(new ProgressHandler(instance,contentLength,response)),fetchOptions)):response})).then((function(response){var errMsg;if(response.ok)switch(responseType){case"arraybuffer":return response.arrayBuffer();case"json":return response.json();case"blob":return response.blob();case"text":return response.text();default:errMsg="Unknown responseType: "+responseType}throw errMsg||(errMsg="HTTP error status: "+response.status),new Error(errMsg)})).then((function(response){instance.fireEvent("success",response)})).catch((function(error){instance.fireEvent("error",error)})),instance.fetchRequest=fetchRequest,instance};var obj,_observer=(obj=__webpack_require__("./src/util/observer.js"))&&obj.__esModule?obj:{default:obj};function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}var ProgressHandler=function(){function ProgressHandler(instance,contentLength,response){!function(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}(this,ProgressHandler),this.instance=instance,this.instance._reader=response.body.getReader(),this.total=parseInt(contentLength,10),this.loaded=0}var Constructor,protoProps,staticProps;return Constructor=ProgressHandler,(protoProps=[{key:"start",value:function(controller){var _this=this;!function read(){_this.instance._reader.read().then((function(_ref){var done=_ref.done,value=_ref.value;if(done)return 0===_this.total&&_this.instance.onProgress.call(_this.instance,{loaded:_this.loaded,total:_this.total,lengthComputable:!1}),void controller.close();_this.loaded+=value.byteLength,_this.instance.onProgress.call(_this.instance,{loaded:_this.loaded,total:_this.total,lengthComputable:!(0===_this.total)}),controller.enqueue(value),read()})).catch((function(error){controller.error(error)}))}()}}])&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),ProgressHandler}();module.exports=exports.default},"./src/util/frame.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=function(func){return function(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return(0,_requestAnimationFrame.default)((function(){return func.apply(void 0,args)}))}};var obj,_requestAnimationFrame=(obj=__webpack_require__("./src/util/request-animation-frame.js"))&&obj.__esModule?obj:{default:obj};module.exports=exports.default},"./src/util/get-id.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=function(prefix){return void 0===prefix&&(prefix="wavesurfer_"),prefix+Math.random().toString(32).substring(2)},module.exports=exports.default},"./src/util/index.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),Object.defineProperty(exports,"ajax",{enumerable:!0,get:function(){return _ajax.default}}),Object.defineProperty(exports,"getId",{enumerable:!0,get:function(){return _getId.default}}),Object.defineProperty(exports,"max",{enumerable:!0,get:function(){return _max.default}}),Object.defineProperty(exports,"min",{enumerable:!0,get:function(){return _min.default}}),Object.defineProperty(exports,"Observer",{enumerable:!0,get:function(){return _observer.default}}),Object.defineProperty(exports,"extend",{enumerable:!0,get:function(){return _extend.default}}),Object.defineProperty(exports,"style",{enumerable:!0,get:function(){return _style.default}}),Object.defineProperty(exports,"requestAnimationFrame",{enumerable:!0,get:function(){return _requestAnimationFrame.default}}),Object.defineProperty(exports,"frame",{enumerable:!0,get:function(){return _frame.default}}),Object.defineProperty(exports,"debounce",{enumerable:!0,get:function(){return _debounce.default}}),Object.defineProperty(exports,"preventClick",{enumerable:!0,get:function(){return _preventClick.default}}),Object.defineProperty(exports,"fetchFile",{enumerable:!0,get:function(){return _fetch.default}});var _ajax=_interopRequireDefault(__webpack_require__("./src/util/ajax.js")),_getId=_interopRequireDefault(__webpack_require__("./src/util/get-id.js")),_max=_interopRequireDefault(__webpack_require__("./src/util/max.js")),_min=_interopRequireDefault(__webpack_require__("./src/util/min.js")),_observer=_interopRequireDefault(__webpack_require__("./src/util/observer.js")),_extend=_interopRequireDefault(__webpack_require__("./src/util/extend.js")),_style=_interopRequireDefault(__webpack_require__("./src/util/style.js")),_requestAnimationFrame=_interopRequireDefault(__webpack_require__("./src/util/request-animation-frame.js")),_frame=_interopRequireDefault(__webpack_require__("./src/util/frame.js")),_debounce=_interopRequireDefault(__webpack_require__("./node_modules/debounce/index.js")),_preventClick=_interopRequireDefault(__webpack_require__("./src/util/prevent-click.js")),_fetch=_interopRequireDefault(__webpack_require__("./src/util/fetch.js"));function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}},"./src/util/max.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=function(values){var largest=-1/0;return Object.keys(values).forEach((function(i){values[i]>largest&&(largest=values[i])})),largest},module.exports=exports.default},"./src/util/min.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=function(values){var smallest=Number(1/0);return Object.keys(values).forEach((function(i){values[i]<smallest&&(smallest=values[i])})),smallest},module.exports=exports.default},"./src/util/observer.js":function(module,exports,__webpack_require__){function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=void 0;var Observer=function(){function Observer(){!function(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}(this,Observer),this.handlers=null}var Constructor,protoProps,staticProps;return Constructor=Observer,protoProps=[{key:"on",value:function(event,fn){var _this=this;this.handlers||(this.handlers={});var handlers=this.handlers[event];return handlers||(handlers=this.handlers[event]=[]),handlers.push(fn),{name:event,callback:fn,un:function(e,fn){return _this.un(e,fn)}}}},{key:"un",value:function(event,fn){if(this.handlers){var i,handlers=this.handlers[event];if(handlers)if(fn)for(i=handlers.length-1;i>=0;i--)handlers[i]==fn&&handlers.splice(i,1);else handlers.length=0}}},{key:"unAll",value:function(){this.handlers=null}},{key:"once",value:function(event,handler){var _this2=this;return this.on(event,(function fn(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];handler.apply(_this2,args),setTimeout((function(){_this2.un(event,fn)}),0)}))}},{key:"fireEvent",value:function(event){for(var _len2=arguments.length,args=new Array(_len2>1?_len2-1:0),_key2=1;_key2<_len2;_key2++)args[_key2-1]=arguments[_key2];if(this.handlers){var handlers=this.handlers[event];handlers&&handlers.forEach((function(fn){fn.apply(void 0,args)}))}}}],protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Observer}();exports.default=Observer,module.exports=exports.default},"./src/util/prevent-click.js":function(module,exports,__webpack_require__){function preventClickHandler(event){event.stopPropagation(),document.body.removeEventListener("click",preventClickHandler,!0)}Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=function(values){document.body.addEventListener("click",preventClickHandler,!0)},module.exports=exports.default},"./src/util/request-animation-frame.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=void 0;var _default=(window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(callback,element){return setTimeout(callback,1e3/60)}).bind(window);exports.default=_default,module.exports=exports.default},"./src/util/style.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=function(el,styles){return Object.keys(styles).forEach((function(prop){el.style[prop]!==styles[prop]&&(el.style[prop]=styles[prop])})),el},module.exports=exports.default},"./src/wavesurfer.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=void 0;var util=function(obj){if(obj&&obj.__esModule)return obj;if(null===obj||"object"!==_typeof(obj)&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache();if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}(__webpack_require__("./src/util/index.js")),_drawer=_interopRequireDefault(__webpack_require__("./src/drawer.multicanvas.js")),_webaudio=_interopRequireDefault(__webpack_require__("./src/webaudio.js")),_mediaelement=_interopRequireDefault(__webpack_require__("./src/mediaelement.js")),_peakcache=_interopRequireDefault(__webpack_require__("./src/peakcache.js")),_mediaelementWebaudio=_interopRequireDefault(__webpack_require__("./src/mediaelement-webaudio.js"));function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _getRequireWildcardCache(){if("function"!=typeof WeakMap)return null;var cache=new WeakMap;return _getRequireWildcardCache=function(){return cache},cache}function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)}function _possibleConstructorReturn(self,call){return!call||"object"!==_typeof(call)&&"function"!=typeof call?_assertThisInitialized(self):call}function _getPrototypeOf(o){return _getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function(o){return o.__proto__||Object.getPrototypeOf(o)},_getPrototypeOf(o)}function _assertThisInitialized(self){if(void 0===self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return self}function _setPrototypeOf(o,p){return _setPrototypeOf=Object.setPrototypeOf||function(o,p){return o.__proto__=p,o},_setPrototypeOf(o,p)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Constructor}!function(){function PluginClass(params,ws){_classCallCheck(this,PluginClass)}_createClass(PluginClass,[{key:"create",value:function(params){}}]),_createClass(PluginClass,[{key:"init",value:function(){}},{key:"destroy",value:function(){}}])}();var WaveSurfer=function(_util$Observer){function WaveSurfer(params){var _this;if(_classCallCheck(this,WaveSurfer),(_this=_possibleConstructorReturn(this,_getPrototypeOf(WaveSurfer).call(this))).defaultParams={audioContext:null,audioScriptProcessor:null,audioRate:1,autoCenter:!0,autoCenterRate:5,autoCenterImmediately:!1,backend:"WebAudio",backgroundColor:null,barHeight:1,barRadius:0,barGap:null,barMinHeight:null,container:null,cursorColor:"#333",cursorWidth:1,dragSelection:!0,drawingContextAttributes:{desynchronized:!1},duration:null,fillParent:!0,forceDecode:!1,height:128,hideScrollbar:!1,interact:!0,loopSelection:!0,maxCanvasWidth:4e3,mediaContainer:null,mediaControls:!1,mediaType:"audio",minPxPerSec:20,normalize:!1,partialRender:!1,pixelRatio:window.devicePixelRatio||screen.deviceXDPI/screen.logicalXDPI,plugins:[],progressColor:"#555",removeMediaElementOnDestroy:!0,renderer:_drawer.default,responsive:!1,rtl:!1,scrollParent:!1,skipLength:2,splitChannels:!1,waveColor:"#999",xhr:{}},_this.backends={MediaElement:_mediaelement.default,WebAudio:_webaudio.default,MediaElementWebAudio:_mediaelementWebaudio.default},_this.util=util,_this.params=Object.assign({},_this.defaultParams,params),_this.container="string"==typeof params.container?document.querySelector(_this.params.container):_this.params.container,!_this.container)throw new Error("Container element not found");if(null==_this.params.mediaContainer?_this.mediaContainer=_this.container:"string"==typeof _this.params.mediaContainer?_this.mediaContainer=document.querySelector(_this.params.mediaContainer):_this.mediaContainer=_this.params.mediaContainer,!_this.mediaContainer)throw new Error("Media Container element not found");if(_this.params.maxCanvasWidth<=1)throw new Error("maxCanvasWidth must be greater than 1");if(_this.params.maxCanvasWidth%2==1)throw new Error("maxCanvasWidth must be an even number");if(!0===_this.params.rtl&&util.style(_this.container,{transform:"rotateY(180deg)"}),_this.params.backgroundColor&&_this.setBackgroundColor(_this.params.backgroundColor),_this.savedVolume=0,_this.isMuted=!1,_this.tmpEvents=[],_this.currentRequest=null,_this.arraybuffer=null,_this.drawer=null,_this.backend=null,_this.peakCache=null,"function"!=typeof _this.params.renderer)throw new Error("Renderer parameter is invalid");_this.Drawer=_this.params.renderer,"AudioElement"==_this.params.backend&&(_this.params.backend="MediaElement"),"WebAudio"!=_this.params.backend&&"MediaElementWebAudio"!==_this.params.backend||_webaudio.default.prototype.supportsWebAudio.call(null)||(_this.params.backend="MediaElement"),_this.Backend=_this.backends[_this.params.backend],_this.initialisedPluginList={},_this.isDestroyed=!1,_this.isReady=!1;var prevWidth=0;return _this._onResize=util.debounce((function(){prevWidth==_this.drawer.wrapper.clientWidth||_this.params.scrollParent||(prevWidth=_this.drawer.wrapper.clientWidth,_this.drawer.fireEvent("redraw"))}),"number"==typeof _this.params.responsive?_this.params.responsive:100),_possibleConstructorReturn(_this,_assertThisInitialized(_this))}return function(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),superClass&&_setPrototypeOf(subClass,superClass)}(WaveSurfer,_util$Observer),_createClass(WaveSurfer,null,[{key:"create",value:function(params){return new WaveSurfer(params).init()}}]),_createClass(WaveSurfer,[{key:"init",value:function(){return this.registerPlugins(this.params.plugins),this.createDrawer(),this.createBackend(),this.createPeakCache(),this}},{key:"registerPlugins",value:function(plugins){var _this2=this;return plugins.forEach((function(plugin){return _this2.addPlugin(plugin)})),plugins.forEach((function(plugin){plugin.deferInit||_this2.initPlugin(plugin.name)})),this.fireEvent("plugins-registered",plugins),this}},{key:"getActivePlugins",value:function(){return this.initialisedPluginList}},{key:"addPlugin",value:function(plugin){var _this3=this;if(!plugin.name)throw new Error("Plugin does not have a name!");if(!plugin.instance)throw new Error("Plugin ".concat(plugin.name," does not have an instance property!"));plugin.staticProps&&Object.keys(plugin.staticProps).forEach((function(pluginStaticProp){_this3[pluginStaticProp]=plugin.staticProps[pluginStaticProp]}));var Instance=plugin.instance;return Object.getOwnPropertyNames(util.Observer.prototype).forEach((function(key){Instance.prototype[key]=util.Observer.prototype[key]})),this[plugin.name]=new Instance(plugin.params||{},this),this.fireEvent("plugin-added",plugin.name),this}},{key:"initPlugin",value:function(name){if(!this[name])throw new Error("Plugin ".concat(name," has not been added yet!"));return this.initialisedPluginList[name]&&this.destroyPlugin(name),this[name].init(),this.initialisedPluginList[name]=!0,this.fireEvent("plugin-initialised",name),this}},{key:"destroyPlugin",value:function(name){if(!this[name])throw new Error("Plugin ".concat(name," has not been added yet and cannot be destroyed!"));if(!this.initialisedPluginList[name])throw new Error("Plugin ".concat(name," is not active and cannot be destroyed!"));if("function"!=typeof this[name].destroy)throw new Error("Plugin ".concat(name," does not have a destroy function!"));return this[name].destroy(),delete this.initialisedPluginList[name],this.fireEvent("plugin-destroyed",name),this}},{key:"destroyAllPlugins",value:function(){var _this4=this;Object.keys(this.initialisedPluginList).forEach((function(name){return _this4.destroyPlugin(name)}))}},{key:"createDrawer",value:function(){var _this5=this;this.drawer=new this.Drawer(this.container,this.params),this.drawer.init(),this.fireEvent("drawer-created",this.drawer),!1!==this.params.responsive&&(window.addEventListener("resize",this._onResize,!0),window.addEventListener("orientationchange",this._onResize,!0)),this.drawer.on("redraw",(function(){_this5.drawBuffer(),_this5.drawer.progress(_this5.backend.getPlayedPercents())})),this.drawer.on("click",(function(e,progress){setTimeout((function(){return _this5.seekTo(progress)}),0)})),this.drawer.on("scroll",(function(e){_this5.params.partialRender&&_this5.drawBuffer(),_this5.fireEvent("scroll",e)}))}},{key:"createBackend",value:function(){var _this6=this;this.backend&&this.backend.destroy(),this.backend=new this.Backend(this.params),this.backend.init(),this.fireEvent("backend-created",this.backend),this.backend.on("finish",(function(){_this6.drawer.progress(_this6.backend.getPlayedPercents()),_this6.fireEvent("finish")})),this.backend.on("play",(function(){return _this6.fireEvent("play")})),this.backend.on("pause",(function(){return _this6.fireEvent("pause")})),this.backend.on("audioprocess",(function(time){_this6.drawer.progress(_this6.backend.getPlayedPercents()),_this6.fireEvent("audioprocess",time)})),"MediaElement"!==this.params.backend&&"MediaElementWebAudio"!==this.params.backend||(this.backend.on("seek",(function(){_this6.drawer.progress(_this6.backend.getPlayedPercents())})),this.backend.on("volume",(function(){var newVolume=_this6.getVolume();_this6.fireEvent("volume",newVolume),_this6.backend.isMuted!==_this6.isMuted&&(_this6.isMuted=_this6.backend.isMuted,_this6.fireEvent("mute",_this6.isMuted))})))}},{key:"createPeakCache",value:function(){this.params.partialRender&&(this.peakCache=new _peakcache.default)}},{key:"getDuration",value:function(){return this.backend.getDuration()}},{key:"getCurrentTime",value:function(){return this.backend.getCurrentTime()}},{key:"setCurrentTime",value:function(seconds){seconds>=this.getDuration()?this.seekTo(1):this.seekTo(seconds/this.getDuration())}},{key:"play",value:function(start,end){var _this7=this;return this.fireEvent("interaction",(function(){return _this7.play(start,end)})),this.backend.play(start,end)}},{key:"setPlayEnd",value:function(position){this.backend.setPlayEnd(position)}},{key:"pause",value:function(){if(!this.backend.isPaused())return this.backend.pause()}},{key:"playPause",value:function(){return this.backend.isPaused()?this.play():this.pause()}},{key:"isPlaying",value:function(){return!this.backend.isPaused()}},{key:"skipBackward",value:function(seconds){this.skip(-seconds||-this.params.skipLength)}},{key:"skipForward",value:function(seconds){this.skip(seconds||this.params.skipLength)}},{key:"skip",value:function(offset){var duration=this.getDuration()||1,position=this.getCurrentTime()||0;position=Math.max(0,Math.min(duration,position+(offset||0))),this.seekAndCenter(position/duration)}},{key:"seekAndCenter",value:function(progress){this.seekTo(progress),this.drawer.recenter(progress)}},{key:"seekTo",value:function(progress){var _this8=this;if("number"!=typeof progress||!isFinite(progress)||progress<0||progress>1)throw new Error("Error calling wavesurfer.seekTo, parameter must be a number between 0 and 1!");this.fireEvent("interaction",(function(){return _this8.seekTo(progress)}));var paused=this.backend.isPaused();paused||this.backend.pause();var oldScrollParent=this.params.scrollParent;this.params.scrollParent=!1,this.backend.seekTo(progress*this.getDuration()),this.drawer.progress(progress),paused||this.backend.play(),this.params.scrollParent=oldScrollParent,this.fireEvent("seek",progress)}},{key:"stop",value:function(){this.pause(),this.seekTo(0),this.drawer.progress(0)}},{key:"setSinkId",value:function(deviceId){return this.backend.setSinkId(deviceId)}},{key:"setVolume",value:function(newVolume){this.backend.setVolume(newVolume),this.fireEvent("volume",newVolume)}},{key:"getVolume",value:function(){return this.backend.getVolume()}},{key:"setPlaybackRate",value:function(rate){this.backend.setPlaybackRate(rate)}},{key:"getPlaybackRate",value:function(){return this.backend.getPlaybackRate()}},{key:"toggleMute",value:function(){this.setMute(!this.isMuted)}},{key:"setMute",value:function(mute){mute!==this.isMuted?(mute?(this.savedVolume=this.backend.getVolume(),this.backend.setVolume(0),this.isMuted=!0,this.fireEvent("volume",0)):(this.backend.setVolume(this.savedVolume),this.isMuted=!1,this.fireEvent("volume",this.savedVolume)),this.fireEvent("mute",this.isMuted)):this.fireEvent("mute",this.isMuted)}},{key:"getMute",value:function(){return this.isMuted}},{key:"getFilters",value:function(){return this.backend.filters||[]}},{key:"toggleScroll",value:function(){this.params.scrollParent=!this.params.scrollParent,this.drawBuffer()}},{key:"toggleInteraction",value:function(){this.params.interact=!this.params.interact}},{key:"getWaveColor",value:function(){return this.params.waveColor}},{key:"setWaveColor",value:function(color){this.params.waveColor=color,this.drawBuffer()}},{key:"getProgressColor",value:function(){return this.params.progressColor}},{key:"setProgressColor",value:function(color){this.params.progressColor=color,this.drawBuffer()}},{key:"getBackgroundColor",value:function(){return this.params.backgroundColor}},{key:"setBackgroundColor",value:function(color){this.params.backgroundColor=color,util.style(this.container,{background:this.params.backgroundColor})}},{key:"getCursorColor",value:function(){return this.params.cursorColor}},{key:"setCursorColor",value:function(color){this.params.cursorColor=color,this.drawer.updateCursor()}},{key:"getHeight",value:function(){return this.params.height}},{key:"setHeight",value:function(height){this.params.height=height,this.drawer.setHeight(height*this.params.pixelRatio),this.drawBuffer()}},{key:"drawBuffer",value:function(){var peaks,nominalWidth=Math.round(this.getDuration()*this.params.minPxPerSec*this.params.pixelRatio),parentWidth=this.drawer.getWidth(),width=nominalWidth,start=0,end=Math.max(start+parentWidth,width);if(this.params.fillParent&&(!this.params.scrollParent||nominalWidth<parentWidth)&&(start=0,end=width=parentWidth),this.params.partialRender){var i,newRanges=this.peakCache.addRangeToPeakCache(width,start,end);for(i=0;i<newRanges.length;i++)peaks=this.backend.getPeaks(width,newRanges[i][0],newRanges[i][1]),this.drawer.drawPeaks(peaks,width,newRanges[i][0],newRanges[i][1])}else peaks=this.backend.getPeaks(width,start,end),this.drawer.drawPeaks(peaks,width,start,end);this.fireEvent("redraw",peaks,width)}},{key:"zoom",value:function(pxPerSec){pxPerSec?(this.params.minPxPerSec=pxPerSec,this.params.scrollParent=!0):(this.params.minPxPerSec=this.defaultParams.minPxPerSec,this.params.scrollParent=!1),this.drawBuffer(),this.drawer.progress(this.backend.getPlayedPercents()),this.drawer.recenter(this.getCurrentTime()/this.getDuration()),this.fireEvent("zoom",pxPerSec)}},{key:"loadArrayBuffer",value:function(arraybuffer){var _this9=this;this.decodeArrayBuffer(arraybuffer,(function(data){_this9.isDestroyed||_this9.loadDecodedBuffer(data)}))}},{key:"loadDecodedBuffer",value:function(buffer){this.backend.load(buffer),this.drawBuffer(),this.isReady=!0,this.fireEvent("ready")}},{key:"loadBlob",value:function(blob){var _this10=this,reader=new FileReader;reader.addEventListener("progress",(function(e){return _this10.onProgress(e)})),reader.addEventListener("load",(function(e){return _this10.loadArrayBuffer(e.target.result)})),reader.addEventListener("error",(function(){return _this10.fireEvent("error","Error reading file")})),reader.readAsArrayBuffer(blob),this.empty()}},{key:"load",value:function(url,peaks,preload,duration){if(!url)throw new Error("url parameter cannot be empty");if(this.empty(),preload){var preloadIgnoreReasons={"Preload is not 'auto', 'none' or 'metadata'":-1===["auto","metadata","none"].indexOf(preload),"Peaks are not provided":!peaks,"Backend is not of type 'MediaElement' or 'MediaElementWebAudio'":-1===["MediaElement","MediaElementWebAudio"].indexOf(this.params.backend),"Url is not of type string":"string"!=typeof url},activeReasons=Object.keys(preloadIgnoreReasons).filter((function(reason){return preloadIgnoreReasons[reason]}));activeReasons.length&&(console.warn("Preload parameter of wavesurfer.load will be ignored because:\n\t- "+activeReasons.join("\n\t- ")),preload=null)}switch(this.params.backend){case"WebAudio":return this.loadBuffer(url,peaks,duration);case"MediaElement":case"MediaElementWebAudio":return this.loadMediaElement(url,peaks,preload,duration)}}},{key:"loadBuffer",value:function(url,peaks,duration){var _this11=this,load=function(action){return action&&_this11.tmpEvents.push(_this11.once("ready",action)),_this11.getArrayBuffer(url,(function(data){return _this11.loadArrayBuffer(data)}))};if(!peaks)return load();this.backend.setPeaks(peaks,duration),this.drawBuffer(),this.tmpEvents.push(this.once("interaction",load))}},{key:"loadMediaElement",value:function(urlOrElt,peaks,preload,duration){var _this12=this,url=urlOrElt;if("string"==typeof urlOrElt)this.backend.load(url,this.mediaContainer,peaks,preload);else{var elt=urlOrElt;this.backend.loadElt(elt,peaks),url=elt.src}this.tmpEvents.push(this.backend.once("canplay",(function(){_this12.backend.destroyed||(_this12.drawBuffer(),_this12.isReady=!0,_this12.fireEvent("ready"))})),this.backend.once("error",(function(err){return _this12.fireEvent("error",err)}))),peaks&&this.backend.setPeaks(peaks,duration),peaks&&!this.params.forceDecode||!this.backend.supportsWebAudio()||this.getArrayBuffer(url,(function(arraybuffer){_this12.decodeArrayBuffer(arraybuffer,(function(buffer){_this12.backend.buffer=buffer,_this12.backend.setPeaks(null),_this12.drawBuffer(),_this12.fireEvent("waveform-ready")}))}))}},{key:"decodeArrayBuffer",value:function(arraybuffer,callback){var _this13=this;this.arraybuffer=arraybuffer,this.backend.decodeArrayBuffer(arraybuffer,(function(data){_this13.isDestroyed||_this13.arraybuffer!=arraybuffer||(callback(data),_this13.arraybuffer=null)}),(function(){return _this13.fireEvent("error","Error decoding audiobuffer")}))}},{key:"getArrayBuffer",value:function(url,callback){var _this14=this,options=Object.assign({url:url,responseType:"arraybuffer"},this.params.xhr),request=util.fetchFile(options);return this.currentRequest=request,this.tmpEvents.push(request.on("progress",(function(e){_this14.onProgress(e)})),request.on("success",(function(data){callback(data),_this14.currentRequest=null})),request.on("error",(function(e){_this14.fireEvent("error",e),_this14.currentRequest=null}))),request}},{key:"onProgress",value:function(e){var percentComplete;percentComplete=e.lengthComputable?e.loaded/e.total:e.loaded/(e.loaded+1e6),this.fireEvent("loading",Math.round(100*percentComplete),e.target)}},{key:"exportPCM",value:function(length,accuracy,noWindow,start,end){length=length||1024,start=start||0,accuracy=accuracy||1e4,noWindow=noWindow||!1;var peaks=this.backend.getPeaks(length,start,end),arr=[].map.call(peaks,(function(val){return Math.round(val*accuracy)/accuracy}));return new Promise((function(resolve,reject){var json=JSON.stringify(arr);noWindow||window.open("data:application/json;charset=utf-8,"+encodeURIComponent(json)),resolve(json)}))}},{key:"exportImage",value:function(format,quality,type){return format||(format="image/png"),quality||(quality=1),type||(type="dataURL"),this.drawer.getImage(format,quality,type)}},{key:"cancelAjax",value:function(){this.currentRequest&&this.currentRequest.controller&&(this.currentRequest.controller.abort(),this.currentRequest=null)}},{key:"clearTmpEvents",value:function(){this.tmpEvents.forEach((function(e){return e.un()}))}},{key:"empty",value:function(){this.backend.isPaused()||(this.stop(),this.backend.disconnectSource()),this.isReady=!1,this.cancelAjax(),this.clearTmpEvents(),this.drawer.progress(0),this.drawer.setWidth(0),this.drawer.drawPeaks({length:this.drawer.getWidth()},0)}},{key:"destroy",value:function(){this.destroyAllPlugins(),this.fireEvent("destroy"),this.cancelAjax(),this.clearTmpEvents(),this.unAll(),!1!==this.params.responsive&&(window.removeEventListener("resize",this._onResize,!0),window.removeEventListener("orientationchange",this._onResize,!0)),this.backend&&this.backend.destroy(),this.drawer&&this.drawer.destroy(),this.isDestroyed=!0,this.isReady=!1,this.arraybuffer=null}}]),WaveSurfer}(util.Observer);exports.default=WaveSurfer,WaveSurfer.VERSION="3.3.3",WaveSurfer.util=util,module.exports=exports.default},"./src/webaudio.js":function(module,exports,__webpack_require__){Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=void 0;var util=function(obj){if(obj&&obj.__esModule)return obj;if(null===obj||"object"!==_typeof(obj)&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache();if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}(__webpack_require__("./src/util/index.js"));function _getRequireWildcardCache(){if("function"!=typeof WeakMap)return null;var cache=new WeakMap;return _getRequireWildcardCache=function(){return cache},cache}function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _possibleConstructorReturn(self,call){return!call||"object"!==_typeof(call)&&"function"!=typeof call?function(self){if(void 0===self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return self}(self):call}function _getPrototypeOf(o){return _getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function(o){return o.__proto__||Object.getPrototypeOf(o)},_getPrototypeOf(o)}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Constructor}function _setPrototypeOf(o,p){return _setPrototypeOf=Object.setPrototypeOf||function(o,p){return o.__proto__=p,o},_setPrototypeOf(o,p)}var WebAudio=function(_util$Observer){function WebAudio(params){var _this$stateBehaviors,_this$states,_this;return function(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}(this,WebAudio),(_this=_possibleConstructorReturn(this,_getPrototypeOf(WebAudio).call(this))).audioContext=null,_this.offlineAudioContext=null,_this.stateBehaviors=(_defineProperty(_this$stateBehaviors={},"playing",{init:function(){this.addOnAudioProcess()},getPlayedPercents:function(){var duration=this.getDuration();return this.getCurrentTime()/duration||0},getCurrentTime:function(){return this.startPosition+this.getPlayedTime()}}),_defineProperty(_this$stateBehaviors,"paused",{init:function(){this.removeOnAudioProcess()},getPlayedPercents:function(){var duration=this.getDuration();return this.getCurrentTime()/duration||0},getCurrentTime:function(){return this.startPosition}}),_defineProperty(_this$stateBehaviors,"finished",{init:function(){this.removeOnAudioProcess(),this.fireEvent("finish")},getPlayedPercents:function(){return 1},getCurrentTime:function(){return this.getDuration()}}),_this$stateBehaviors),_this.params=params,_this.ac=params.audioContext||(_this.supportsWebAudio()?_this.getAudioContext():{}),_this.lastPlay=_this.ac.currentTime,_this.startPosition=0,_this.scheduledPause=null,_this.states=(_defineProperty(_this$states={},"playing",Object.create(_this.stateBehaviors.playing)),_defineProperty(_this$states,"paused",Object.create(_this.stateBehaviors.paused)),_defineProperty(_this$states,"finished",Object.create(_this.stateBehaviors.finished)),_this$states),_this.buffer=null,_this.filters=[],_this.gainNode=null,_this.mergedPeaks=null,_this.offlineAc=null,_this.peaks=null,_this.playbackRate=1,_this.analyser=null,_this.scriptNode=null,_this.source=null,_this.splitPeaks=[],_this.state=null,_this.explicitDuration=params.duration,_this.destroyed=!1,_this}return function(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),superClass&&_setPrototypeOf(subClass,superClass)}(WebAudio,_util$Observer),_createClass(WebAudio,[{key:"supportsWebAudio",value:function(){return!(!window.AudioContext&&!window.webkitAudioContext)}},{key:"getAudioContext",value:function(){return window.WaveSurferAudioContext||(window.WaveSurferAudioContext=new(window.AudioContext||window.webkitAudioContext)),window.WaveSurferAudioContext}},{key:"getOfflineAudioContext",value:function(sampleRate){return window.WaveSurferOfflineAudioContext||(window.WaveSurferOfflineAudioContext=new(window.OfflineAudioContext||window.webkitOfflineAudioContext)(1,2,sampleRate)),window.WaveSurferOfflineAudioContext}}]),_createClass(WebAudio,[{key:"init",value:function(){this.createVolumeNode(),this.createScriptNode(),this.createAnalyserNode(),this.setState("paused"),this.setPlaybackRate(this.params.audioRate),this.setLength(0)}},{key:"disconnectFilters",value:function(){this.filters&&(this.filters.forEach((function(filter){filter&&filter.disconnect()})),this.filters=null,this.analyser.connect(this.gainNode))}},{key:"setState",value:function(state){this.state!==this.states[state]&&(this.state=this.states[state],this.state.init.call(this))}},{key:"setFilter",value:function(){for(var _len=arguments.length,filters=new Array(_len),_key=0;_key<_len;_key++)filters[_key]=arguments[_key];this.setFilters(filters)}},{key:"setFilters",value:function(filters){this.disconnectFilters(),filters&&filters.length&&(this.filters=filters,this.analyser.disconnect(),filters.reduce((function(prev,curr){return prev.connect(curr),curr}),this.analyser).connect(this.gainNode))}},{key:"createScriptNode",value:function(){this.params.audioScriptProcessor?this.scriptNode=this.params.audioScriptProcessor:this.ac.createScriptProcessor?this.scriptNode=this.ac.createScriptProcessor(WebAudio.scriptBufferSize):this.scriptNode=this.ac.createJavaScriptNode(WebAudio.scriptBufferSize),this.scriptNode.connect(this.ac.destination)}},{key:"addOnAudioProcess",value:function(){var _this2=this;this.scriptNode.onaudioprocess=function(){var time=_this2.getCurrentTime();time>=_this2.getDuration()?(_this2.setState("finished"),_this2.fireEvent("pause")):time>=_this2.scheduledPause?_this2.pause():_this2.state===_this2.states.playing&&_this2.fireEvent("audioprocess",time)}}},{key:"removeOnAudioProcess",value:function(){this.scriptNode.onaudioprocess=function(){}}},{key:"createAnalyserNode",value:function(){this.analyser=this.ac.createAnalyser(),this.analyser.connect(this.gainNode)}},{key:"createVolumeNode",value:function(){this.ac.createGain?this.gainNode=this.ac.createGain():this.gainNode=this.ac.createGainNode(),this.gainNode.connect(this.ac.destination)}},{key:"setSinkId",value:function(deviceId){if(deviceId){var audio=new window.Audio;if(!audio.setSinkId)return Promise.reject(new Error("setSinkId is not supported in your browser"));audio.autoplay=!0;var dest=this.ac.createMediaStreamDestination();return this.gainNode.disconnect(),this.gainNode.connect(dest),audio.srcObject=dest.stream,audio.setSinkId(deviceId)}return Promise.reject(new Error("Invalid deviceId: "+deviceId))}},{key:"setVolume",value:function(value){this.gainNode.gain.setValueAtTime(value,this.ac.currentTime)}},{key:"getVolume",value:function(){return this.gainNode.gain.value}},{key:"decodeArrayBuffer",value:function(arraybuffer,callback,errback){this.offlineAc||(this.offlineAc=this.getOfflineAudioContext(this.ac&&this.ac.sampleRate?this.ac.sampleRate:44100)),this.offlineAc.decodeAudioData(arraybuffer,(function(data){return callback(data)}),errback)}},{key:"setPeaks",value:function(peaks,duration){null!=duration&&(this.explicitDuration=duration),this.peaks=peaks}},{key:"setLength",value:function(length){if(!this.mergedPeaks||length!=2*this.mergedPeaks.length-1+2){this.splitPeaks=[],this.mergedPeaks=[];var c,channels=this.buffer?this.buffer.numberOfChannels:1;for(c=0;c<channels;c++)this.splitPeaks[c]=[],this.splitPeaks[c][2*(length-1)]=0,this.splitPeaks[c][2*(length-1)+1]=0;this.mergedPeaks[2*(length-1)]=0,this.mergedPeaks[2*(length-1)+1]=0}}},{key:"getPeaks",value:function(length,first,last){if(this.peaks)return this.peaks;if(!this.buffer)return[];if(first=first||0,last=last||length-1,this.setLength(length),!this.buffer)return this.params.splitChannels?this.splitPeaks:this.mergedPeaks;if(!this.buffer.length){var newBuffer=this.createBuffer(1,4096,this.sampleRate);this.buffer=newBuffer.buffer}var c,sampleSize=this.buffer.length/length,sampleStep=~~(sampleSize/10)||1,channels=this.buffer.numberOfChannels;for(c=0;c<channels;c++){var peaks=this.splitPeaks[c],chan=this.buffer.getChannelData(c),i=void 0;for(i=first;i<=last;i++){var start=~~(i*sampleSize),end=~~(start+sampleSize),min=0,max=0,j=void 0;for(j=start;j<end;j+=sampleStep){var value=chan[j];value>max&&(max=value),value<min&&(min=value)}peaks[2*i]=max,peaks[2*i+1]=min,(0==c||max>this.mergedPeaks[2*i])&&(this.mergedPeaks[2*i]=max),(0==c||min<this.mergedPeaks[2*i+1])&&(this.mergedPeaks[2*i+1]=min)}}return this.params.splitChannels?this.splitPeaks:this.mergedPeaks}},{key:"getPlayedPercents",value:function(){return this.state.getPlayedPercents.call(this)}},{key:"disconnectSource",value:function(){this.source&&this.source.disconnect()}},{key:"destroy",value:function(){this.isPaused()||this.pause(),this.unAll(),this.buffer=null,this.destroyed=!0,this.disconnectFilters(),this.disconnectSource(),this.gainNode.disconnect(),this.scriptNode.disconnect(),this.analyser.disconnect(),this.params.closeAudioContext&&("function"==typeof this.ac.close&&"closed"!=this.ac.state&&this.ac.close(),this.ac=null,this.params.audioContext?this.params.audioContext=null:window.WaveSurferAudioContext=null,window.WaveSurferOfflineAudioContext=null)}},{key:"load",value:function(buffer){this.startPosition=0,this.lastPlay=this.ac.currentTime,this.buffer=buffer,this.createSource()}},{key:"createSource",value:function(){this.disconnectSource(),this.source=this.ac.createBufferSource(),this.source.start=this.source.start||this.source.noteGrainOn,this.source.stop=this.source.stop||this.source.noteOff,this.source.playbackRate.setValueAtTime(this.playbackRate,this.ac.currentTime),this.source.buffer=this.buffer,this.source.connect(this.analyser)}},{key:"isPaused",value:function(){return this.state!==this.states.playing}},{key:"getDuration",value:function(){return this.explicitDuration?this.explicitDuration:this.buffer?this.buffer.duration:0}},{key:"seekTo",value:function(start,end){if(this.buffer)return this.scheduledPause=null,null==start&&(start=this.getCurrentTime())>=this.getDuration()&&(start=0),null==end&&(end=this.getDuration()),this.startPosition=start,this.lastPlay=this.ac.currentTime,this.state===this.states.finished&&this.setState("paused"),{start:start,end:end}}},{key:"getPlayedTime",value:function(){return(this.ac.currentTime-this.lastPlay)*this.playbackRate}},{key:"play",value:function(start,end){if(this.buffer){this.createSource();var adjustedTime=this.seekTo(start,end);start=adjustedTime.start,end=adjustedTime.end,this.scheduledPause=end,this.source.start(0,start),"suspended"==this.ac.state&&this.ac.resume&&this.ac.resume(),this.setState("playing"),this.fireEvent("play")}}},{key:"pause",value:function(){this.scheduledPause=null,this.startPosition+=this.getPlayedTime(),this.source&&this.source.stop(0),this.setState("paused"),this.fireEvent("pause")}},{key:"getCurrentTime",value:function(){return this.state.getCurrentTime.call(this)}},{key:"getPlaybackRate",value:function(){return this.playbackRate}},{key:"setPlaybackRate",value:function(value){value=value||1,this.isPaused()?this.playbackRate=value:(this.pause(),this.playbackRate=value,this.play())}},{key:"setPlayEnd",value:function(end){this.scheduledPause=end}}]),WebAudio}(util.Observer);exports.default=WebAudio,WebAudio.scriptBufferSize=256,module.exports=exports.default}})},"object"==typeof exports&&"object"==typeof module?module.exports=factory():"function"==typeof define&&define.amd?define("filter_poodll/wavesurfer",[],factory):"object"==typeof exports?exports.WaveSurfer=factory():root.WaveSurfer=factory();

//# sourceMappingURL=wavesurfer.min.js.map