/**
 * load object to produce HTML tags
 *
 * @module      mod_englishcentral/html
 * @category    output
 * @copyright   Gordon Bateson
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since       2.9
 */
define("mod_englishcentral/html",[],(function(){var HTML={};return HTML.nonalphanumeric=new RegExp("[^a-zA-Z0-9_-]+","g"),HTML.htmlescape=function(value){return(value+="").replace(new RegExp("&","g"),"&amp;").replace(new RegExp("'","g"),"&apos;").replace(new RegExp('"',"g"),"&quot;").replace(new RegExp("<","g"),"&lt;").replace(new RegExp(">","g"),"&gt;")},HTML.attribute=function(name,value){var attr=name.replace(HTML.nonalphanumeric,"");return attr&&(attr=" "+attr+'="'+HTML.htmlescape(value)+'"'),attr},HTML.attributes=function(attr){var html="";if(attr)for(var name in attr)html+=HTML.attribute(name,attr[name]);return html},HTML.starttag=function(tag,attr){return"<"+tag+HTML.attributes(attr)+">"},HTML.endtag=function(tag){return"</"+tag+">"},HTML.emptytag=function(tag,attr){return"<"+tag+HTML.attributes(attr)+"/>"},HTML.tag=function(tag,content,attr){return HTML.starttag(tag,attr)+content+HTML.endtag(tag)},HTML.input=function(name,type,attr,id){return attr.type=type,attr.name=name,attr.id=id||"id_"+name,HTML.emptytag("input",attr)},HTML.hidden=function(name,value){var attr={value:value||""};return HTML.input(name,"hidden",attr)},HTML.text=function(name,value,size){var attr={value:value||"",size:size||"15"};return HTML.input(name,"text",attr)},HTML.checkbox=function(name,checked){var attr={value:"1"};return checked&&(attr.checked="checked"),HTML.input(name,"checkbox",attr)},HTML.alist=function(tag,items){var alist="";for(var i in items)alist+=HTML.tag("li",items[i]);return HTML.tag(tag,alist,{})},HTML.select=function(name,options,selected,attr){var html="";for(var value in options){var a={value:value};value==selected&&(a.selected="selected"),html+=HTML.tag("option",options[value],a)}return attr.name=name,attr.id="id_"+name,HTML.tag("select",html,attr)},HTML}));

//# sourceMappingURL=html.min.js.map