define("mod_minilesson/audiostory",["jquery","core/log"],(function($,log){return log.debug("MiniLesson Audio Story: initialising"),{animateFrameId:null,currentIndex:-1,secondsPerImage:25,pp:10,pm:-10,maxzoom:1.3,entryTimes:[],controls:{},panOptions:null,clone:function(){return $.extend(!0,{},this)},init:function(uniqid){this.panOptions=[{xStart:this.pm,yStart:0,xEnd:this.pp,yEnd:0},{xStart:this.pp,yStart:0,xEnd:this.pm,yEnd:0},{xStart:0,yStart:this.pm,xEnd:0,yEnd:this.pp},{xStart:0,yStart:this.pp,xEnd:0,yEnd:this.pm},{xStart:this.pm,yStart:this.pm,xEnd:this.pp,yEnd:this.pp},{xStart:this.pp,yStart:this.pp,xEnd:this.pm,yEnd:this.pm}],this.init_controls(uniqid),this.register_events()},init_controls:function(uniqid){var self=this;self.controls.aplayer=$("#"+uniqid+"_audiostory_audio"),self.controls.slideshowcontainer=$("#"+uniqid+"_audiostory_slideshow_container"),self.controls.captioncontainer=$("#"+uniqid+"_audiostory_caption"),self.controls.images=$("#"+uniqid+"_audiostory_slideshow_container .audiostory_image_container"),self.controls.overlay=self.controls.slideshowcontainer.find(".audiostory_overlay"),self.controls.playbutton=self.controls.overlay.find(".audiostory_play_button"),self.controls.layers=[],self.controls.entryTimes=[],self.controls.images.each((function(index,element){var entrytime=element.dataset.entrytime;if(""==entrytime)return;const pan=self.panOptions[Math.floor(Math.random()*self.panOptions.length)];self.controls.layers.push({element:element,pan:pan}),self.controls.entryTimes.push(entrytime)})),self.controls.layers.forEach((layer=>{layer.animation={direction:1,progress:0,lastTimestamp:null}}));const firstImage=self.controls.layers[0];firstImage&&(firstImage.element.style.opacity="1",firstImage.element.style.transform="scale(1) translate(0, 0)")},register_events:function(){var self=this;const audio=self.controls.aplayer[0],captionDiv=self.controls.captioncontainer[0];self.controls.layers;var doUpdate=function(timestamp){const audio=self.controls.aplayer[0],layers=self.controls.layers,currentTime=audio.currentTime,entryTimes=self.controls.entryTimes;let newIndex=-1;for(let i=0;i<entryTimes.length&&currentTime>=entryTimes[i];i++)newIndex=i;newIndex!==self.currentIndex&&(self.currentIndex=newIndex,layers.forEach(((l,i)=>{l.element.style.opacity=i===self.currentIndex?"1":"0",l.animation.progress=0,l.animation.direction=1,l.animation.lastTimestamp=null}))),self.animateCurrentImage(timestamp),self.animationFrameId=requestAnimationFrame(doUpdate)};self.controls.playbutton.on("click",(()=>{self.controls.overlay.hide(),audio.play()})),audio.addEventListener("play",(()=>{self.controls.overlay.hide(),self.animationFrameId||(self.animationFrameId=requestAnimationFrame(doUpdate))})),audio.addEventListener("pause",(()=>{self.animationFrameId&&(cancelAnimationFrame(self.animationFrameId),self.animationFrameId=null)})),audio.addEventListener("seeked",(()=>{self.currentIndex=-1,audio.paused||doUpdate()}));const handleLoadedMetadata=()=>{log.debug("Audio metadata loaded, setting up captions");const track=audio.textTracks[0];track?(track.mode="hidden",track.addEventListener("cuechange",(()=>{const cue=track.activeCues[0];captionDiv.textContent=cue?cue.text:""}))):log.debug("no text tracks not setting up captions")};audio.readyState>=1?handleLoadedMetadata():audio.addEventListener("loadedmetadata",handleLoadedMetadata)},animateCurrentImage:function(timestamp){var layers=this.controls.layers;this.controls.entryTimes,this.controls.aplayer[0];if(this.currentIndex<0||this.currentIndex>=layers.length)return;const imageObj=layers[this.currentIndex],{element:element,pan:pan,animation:animation}=imageObj;if(null!=animation.lastTimestamp){const delta=timestamp-animation.lastTimestamp,duration=1e3*this.secondsPerImage;animation.progress+=delta/duration*animation.direction,animation.progress>1?(animation.progress=1,animation.direction=-1):animation.progress<0&&(animation.progress=0,animation.direction=1)}animation.lastTimestamp=timestamp;const easedProgress=.5-.5*Math.cos(Math.PI*animation.progress),scale=this.maxzoom-(this.maxzoom-1)*easedProgress,panFactor=easedProgress,x=pan.xStart+(pan.xEnd-pan.xStart)*panFactor,y=pan.yStart+(pan.yEnd-pan.yStart)*panFactor;element.style.transform="scale(".concat(scale,") translate(").concat(x,"px, ").concat(y,"px)")}}}));

//# sourceMappingURL=audiostory.min.js.map