<?php
/**
 * English strings for Mini Lesson
 *
 * You can have a rather longer description of the file as well,
 * if you like, and it can span multiple lines.
 *
 * @package    mod_minilesson
 * @copyright  2015 Justin Hunt (poodllsupport@gmail.com)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['modulename'] = 'Poodll MiniLesson';
$string['modulenameplural'] = 'Poodll MiniLessons';
$string['modulename_help'] = 'MiniLesson combines several auto-graded language learning activities into a simple self guided online lesson.';
//$string['minilessonfieldset'] = 'Custom example fieldset';
$string['minilessonname'] = 'Poodll MiniLesson';
$string['minilessonname_help'] = 'This is the content of the help tooltip associated with the Mini Lesson name field. Markdown syntax is supported.';
$string['minilesson'] = 'Poodll MiniLesson';
$string['activitylink'] = 'Link to next activity';
$string['activitylink_help'] = 'To provide a link after the attempt to another activity in the course, select the activity from the dropdown list.';
$string['activitylinkname'] = 'Continue to next activity: {$a}';
$string['pluginadministration'] = 'Mini Lesson Administration';
$string['pluginname'] = 'Poodll MiniLesson';
//$string['someadminsetting'] = 'Some Admin Setting';
//$string['someadminsetting_details'] = 'More info about Some Admin Setting';
//$string['someinstancesetting'] = 'Some Instance Setting';
//$string['someinstancesetting_details'] = 'More infor about Some Instance Setting';
//$string['minilessonsettings'] = 'MiniLesson settings';
$string['minilesson:addinstance'] = 'Add a new Mini Lesson';
$string['minilesson:view'] = 'View MiniLesson';
$string['minilesson:view'] = 'Preview MiniLesson';
$string['minilesson:itemview'] = 'View lesson items';
$string['minilesson:itemedit'] = 'Edit lesson ittems';
$string['minilesson:tts'] = 'Can use Text To Speech(tts)';
$string['minilesson:managequestions'] = 'Can manage lesson items';
$string['minilesson:export'] = 'Can export lesson items';
$string['minilesson:canmanageattempts'] = 'Can manage MiniLesson attempts';
$string['minilesson:manage'] = 'Can manage MiniLesson instances';
$string['minilesson:canpreview'] = 'Can preview MiniLesson activities';
$string['minilesson:evaluate'] = 'Can evaluate student MiniLesson attempts';
$string['minilesson:submit'] = 'Can submit MiniLesson attempts';
$string['minilesson:push'] = 'Push settings from one instance to others';
$string['minilesson:canuseaigen'] = 'Can use AI Generation feature';


$string['id']='ID';
$string['name']='Name';
$string['timecreated']='Time Created';
$string['basicheading']='Basic Report';
$string['attemptsheading']='Attempts Report';
$string['incompleteattemptsheading']='Incomplete Attempts Report';
$string['gradereport']='Grade Report';
$string['gradereport_explanation']='A list of grades';
$string['gradereportheading']='Grade Report';
//$string['attemptsbyuserheading']='User Attempts Report';
$string['gradingheading']='Grades for each user latest attempts.';
$string['gradingbyuserheading']='Grades for all attempts by: {$a}';
$string['totalattempts']='Attempts';
$string['overview']='Overview';
$string['overview_help']='Overview Help';
$string['view']='View';
$string['preview']='Preview';
$string['viewreports']='View Reports';
$string['reports']='Reports';
$string['viewgrading']='View Grades';
$string['grading']='Grades';
$string['showingattempt']='Showing attempt for: {$a}';
$string['showingmachinegradedattempt']='Machine evaluated attempt for: {$a}';
$string['basicreport']='Basic Report';
$string['basicreport_explanation']='A Basic Report';

$string['returntoreports']='Return to Reports';
$string['returntogradinghome']='Return to Grades Top';
$string['exportexcel']='Export to CSV';
$string['mingradedetails'] = 'The minimum grade required to "complete" this activity.';
$string['mingrade'] = 'Minimum Grade';
$string['deletealluserdata'] = 'Delete all user data';
$string['maxattempts'] ='Max. Attempts';
$string['maxattempts_details'] ='Maximum number of attempts allowed in this activity.';
$string['unlimited'] ='unlimited';
$string['gradeoptions'] ='Grade Options';
$string['gradenone'] ='No grade';
$string['gradelowest'] ='lowest scoring attempt';
$string['gradehighest'] ='highest scoring attempt';
$string['gradelatest'] ='score of latest attempt';
$string['gradeaverage'] ='average score of all attempts';
//$string['defaultsettings'] ='Default Settings';
$string['exceededattempts'] ='You have completed the maximum {$a} attempts.';
//$string['minilessontask'] ='Mini Lesson Task';
$string['welcomelabel'] ='Default Welcome';
$string['welcomelabel_details'] ='The default text to show in the welcome field when creating a new Mini Lesson activity.';
//$string['feedbacklabel'] ='Default Feedback';
//$string['feedbacklabel_details'] ='The default text to show in the feedback field when creating a new Mini Lesson activity.';
$string['welcomelabel'] = 'Welcome Message';
//$string['feedbacklabel'] = 'Feedback Message';
$string['alternatives']='Alternatives';
$string['alternatives_descr']='Specify matching options for specific passage words. 1 word set per line. e.g their|there|they\'re See <a href="https://support.poodll.com/support/solutions/articles/19000096937-tuning-your-read-aloud-activity">docs</a> for more details.';
//$string['defaultwelcome'] = 'To begin the activity first test your microphone. When we can hear sound from your microphone a start button will appear. After you press the start button, a reading passage will appear. Read the passage aloud as clearly as you can.';
//$string['defaultfeedback'] = 'Thanks for reading. Please be patient until your attempt has been evaluated.';
$string['timelimit'] = 'Time Limit';
//$string['gotnosound'] = 'We could not hear you. Please check the permissions and settings for microphone and try again.';
//$string['done'] = 'Done';
$string['processing'] = 'Processing';
//$string['feedbackheader'] = 'Finished';
//$string['beginreading'] = 'Begin Reading';
$string['errorheader'] = 'Error';
//$string['uploadconverterror'] = 'An error occured while posting your file to the server. Your submission has NOT been received. Please refresh the page and try again.';
$string['attemptsreport'] = 'Attempts Report';
$string['attemptsreport_explanation']='A list of attempts';
$string['incompleteattemptsreport'] = 'Incomplete Attempts Report';
$string['incompleteattemptsreport_explanation']='A list of incomplete attempts';
//$string['submitted'] = 'submitted';
$string['id'] = 'ID';
$string['username'] = 'User';
//$string['audiofile'] = 'Audio';
$string['timecreated'] = 'Time Created';
$string['nodataavailable'] = 'No Data Available Yet';
$string['saveandnext'] = 'Save .... and next';
//$string['notgradedyet'] = 'Your submission has been received, but has not been graded yet';
//$string['enabletts'] = 'Enable TTS(experimental)';
//$string['enabletts_details'] = 'TTS is currently not implemented';
//we hijacked this setting for both TTS STT .... bad ... but they are always the same aren't they?
$string['ttslanguage'] = 'Target/Voice Language';
$string['deleteattemptconfirm'] = "Are you sure that you want to delete this attempt?";
$string['deletenow']='';
$string['itemsperpage']='Items per page';
$string['itemsperpage_details']='This sets the number of rows to be shown on reports or lists of attempts.';
$string['mistakes']='Mistakes';
$string['grade']='Grade';
$string['grade_p']='Grade(%)';
$string['quiz_p']='Quiz(%)';
$string['quizanswers']='Answers';

$string['apiuser']='Poodll API User ';
$string['apiuser_details']='The Poodll account username that authorises Poodll on this site.';
$string['apisecret']='Poodll API Secret ';
$string['apisecret_details']='The Poodll API secret. See <a href= "https://support.poodll.com/support/solutions/articles/19000083076-cloud-poodll-api-secret">here</a> for more details';



$string['useast1'] = 'US East';
$string['tokyo'] = 'Tokyo, Japan';
$string['sydney'] = 'Sydney, Australia';
$string['dublin'] = 'Dublin, Ireland';
$string['ottawa'] = 'Ottawa, Canada';
$string['frankfurt'] = 'Frankfurt, Germany';
$string['london'] = 'London, U.K';
$string['saopaulo'] = 'Sao Paulo, Brazil';
$string['singapore'] = 'Singapore';
$string['mumbai'] = 'Mumbai, India';
$string['capetown'] = 'Capetown, South Africa';
$string['bahrain'] = 'Bahrain';
$string['ningxia'] = 'Ningxia, China';

//$string['forever'] = 'Never expire';

$string['en-us'] = 'English (US)';
$string['es-us'] = 'Spanish (US)';
$string['en-au'] = 'English (Aus.)';
$string['en-nz'] = 'English (NZ)';
$string['en-za'] = 'English (S.Africa)';
$string['en-gb'] = 'English (GB)';
$string['fr-ca'] = 'French (Can.)';
$string['fr-fr'] = 'French (FR)';
$string['it-it'] = 'Italian (IT)';
$string['pt-br'] = 'Portuguese (BR)';
$string['en-in'] = 'English (IN)';
$string['es-es'] = 'Spanish (ES)';
$string['fr-fr'] = 'French (FR)';
$string['fil-ph'] = 'Filipino';
$string['de-de'] = 'German (DE)';
$string['de-ch'] = 'German (CH)';
$string['de-at'] = 'German (AT)';
$string['da-dk'] = 'Danish (DK)';
$string['hi-in'] = 'Hindi';
$string['ko-kr'] = 'Korean';
$string['ar-ae'] = 'Arabic (Gulf)';
$string['ar-sa'] = 'Arabic (Modern Standard)';
$string['zh-cn'] = 'Chinese (Mandarin-Mainland)';
$string['nl-nl'] = 'Dutch (NL)';
$string['nl-be'] = 'Dutch (BE)';
$string['en-ie'] = 'English (Ireland)';
$string['en-wl'] = 'English (Wales)';
$string['en-ab'] = 'English (Scotland)';
$string['fa-ir'] = 'Persian';
$string['he-il'] = 'Hebrew';
$string['id-id'] = 'Indonesian';
$string['ja-jp'] = 'Japanese';
$string['ms-my'] = 'Malay';
$string['pt-pt'] = 'Portuguese (PT)';
$string['ru-ru'] = 'Russian';
$string['ta-in'] = 'Tamil';
$string['te-in'] = 'Telugu';
$string['tr-tr'] = 'Turkish';

$string['uk-ua'] = 'Ukranian';
$string['eu-es'] = 'Basque';
$string['fi-fi'] = 'Finnish';
$string['hu-hu'] = 'Hungarian';

$string['sv-se'] = 'Swedish';
$string['no-no'] = 'Norwegian';
$string['nb-no'] = 'Norwegian (Bokmål)';
$string['nn-no'] = 'Norwegian (Nynorsk)';
$string['pl-pl'] = 'Polish';
$string['ro-ro'] = 'Romanian';
$string['mi-nz'] = 'Maori';

$string['bg-bg'] = 'Bulgarian'; // Bulgarian
$string['cs-cz'] = 'Czech'; // Czech
$string['el-gr'] = 'Greek'; // Greek
$string['hr-hr'] = 'Croatian'; // Croatian
$string['hu-hu'] = 'Hungarian'; // Hungarian
$string['lt-lt'] = 'Lithuanian'; // Lithuanian
$string['lv-lv'] = 'Latvian'; // Latvian
$string['sk-sk'] = 'Slovak'; // Slovak
$string['sl-si'] = 'Slovenian'; // Slovenian
$string['is-is'] = 'Icelandic'; // Icelandic
$string['mk-mk'] = 'Macedonian'; // Macedonian
$string['no-no'] = 'Norwegian'; // Norwegian
$string['sr-rs'] = 'Serbian'; // Serbian
$string['vi-vn'] = 'Vietnamese'; // Vietnamese
$string['so-so'] = 'Somali'; // Somali
$string['ps-af'] = 'Pashto'; // Afghan Pashto

$string['awsregion'] = 'AWS Region';
$string['region']='AWS Region';
$string['region_details']='The AWS Region sets where data is stored and processed.';
//$string['expiredays']='Days to keep file';


//$string['machinegrading']='Machine Evaluations';
//$string['viewmachinegrading']='Machine Evaluation';
$string['review']='Review';
$string['regrade']='Regrade';


//$string['humanevaluatedmessage']='Your latest attempt has been graded by your teacher and results are displayed below.';
//$string['machineevaluatedmessage']='Your latest attempt has been graded <i>automatically</i> and results are displayed below.';

//$string['dospotcheck']="Spot Check";
//$string['spotcheckbutton']="Quick Grade";
//$string['gradingbutton']="Manual Grade";
//$string['transcriptcheckbutton']="Transcript Check";
//$string['doclear']="Clear all markers";

//$string['gradethisattempt']="Grade this attempt";
$string['rawgrade_p']='Grade(%)';
$string['adjustedgrade_p']='Adj. Grade(%)';

//$string['evaluationview']="Evaluation display";
//$string['evaluationview_details']="What to show students after they have attempted and received an evaluation";
//$string['humanpostattempt']="Evaluation display (human)";
//$string['humanpostattempt_details']="What to show students after they have attempted and received a human evaluation";
//$string['machinepostattempt']="Evaluation display (machine)";
//$string['machinepostattempt_details']="What to show students after they have attempted and received a machine evaluation";
//$string['postattempt_none']="Show the passage. Don't show evaluation or errors.";
//$string['postattempt_eval']="Show the passage, and evaluation(scores)";
//$string['postattempt_evalerrors']="Show the passage, evaluation(scores) and errors";
$string['attemptsperpage']="Attempts to show per page: ";
$string['backtotop']="Back to Course Page";
//$string['transcript']="Transcript";
//$string['quickgrade']="Quick Grade";
//$string['ok']="OK";
//$string['ng']="Not OK";
//$string['notok']="Not OK";
//$string['machinegrademethod']="Human/Machine Grading";
//$string['machinegrademethod_help']="Use machine evaluations or human evaluations as grades in grade book.";
//$string['machinegradenone']="Never use machine eval. for grade";
//$string['machinegrademachine']="Use human or machine eval. for grade";

//$string['noattemptsregrade']='No attempts to regrade';
//$string['machineregraded']='Successfully regraded {$a->done} attempts. Skipped {$a->skipped} attempts.';
//$string['machinegradespushed']='Successfully pushed grades to gradebook';

$string['notimelimit']='No time limit';
$string['xsecs']='{$a} seconds';
$string['onemin']='1 minute';
$string['xmins']='{$a} minutes';
$string['oneminxsecs']='1 minutes {$a} seconds';
$string['xminsecs']='{$a->minutes} minutes {$a->seconds} seconds';

$string['postattemptheader']='Post attempt options';
$string['recordingaiheader']='Recording and AI options';

$string['displaysubs'] = '{$a->subscriptionname} : expires {$a->expiredate}';
$string['noapiuser'] = "No API user entered. MiniLesson will not work correctly.";
$string['noapisecret'] = "No API secret entered. MiniLesson will not work correctly.";
$string['credentialsinvalid'] = "The API user and secret entered could not be used to get access. Please check them.";
$string['appauthorised']= "Poodll MiniLesson is authorised for this site.";
$string['appnotauthorised']= "Poodll MiniLesson is NOT authorised for this site.";
$string['refreshtoken']= "Refresh license information";
$string['notokenincache']= "Refresh to see license information. Contact Poodll support if there is a problem.";
//these errors are displayed on activity page
$string['nocredentials'] = 'API user and secret not entered. Please enter them on <a href="{$a}">the settings page.</a> You can get them from <a href="https://poodll.com/member">Poodll.com.</a>';
$string['novalidcredentials'] = 'API user and secret were rejected and could not gain access. Please check them on <a href="{$a}">the settings page.</a> You can get them from <a href="https://poodll.com/member">Poodll.com.</a>';
$string['nosubscriptions'] = "There is no current subscription for this site/plugin.";

$string['privacy:metadata:attemptid']='The unique identifier of a users MiniLesson attempt.';
$string['privacy:metadata:minilessonid']='The unique identifier of a MiniLesson activity instance.';
$string['privacy:metadata:userid']='The user id for the MiniLesson attempt';
$string['privacy:metadata:sessionscore']='The session score for the attempt';
$string['privacy:metadata:sessiontime']='The session time(recording time) for the attempt';
$string['privacy:metadata:sessiondata']='The session data for the attempt';
$string['privacy:metadata:sessionend']='The sessionend for the attempt';
$string['privacy:metadata:timemodified']='The last time attempt was modified for the attempt';
$string['privacy:metadata:attempttable']='Stores the scores and other user data associated with a MiniLesson attempt.';
$string['privacy:metadata:transcriptpurpose']='The recording short transcripts.';
$string['privacy:metadata:fulltranscriptpurpose']='The full transcripts of recordings.';
$string['privacy:metadata:cloudpoodllcom:userid']='The MiniLesson plugin includes the moodle userid in the urls of recordings and transcripts';
$string['privacy:metadata:cloudpoodllcom']='The MiniLesson plugin stores recordings in AWS S3 buckets via cloud.poodll.com.';
$string['privacy:metadata'] = 'The Poodll MiniLesson plugin does store personal data.';
$string['privacy:metadata:moduleid'] = 'The unique identifier of a MiniLesson activity instance.';
$string['privacy:metadata:errorcount']='The error count of a users MiniLesson attempt.';

//rsquestions
$string['rsquestions'] ='Lesson Items';
$string['managersquestions'] ='Manage Lesson Items';
$string['correctanswer'] ='Correct answer';
$string['incorrectanswer'] ='Incorrect answer';
$string['whatdonow'] = 'Add lesson items to activity:';
$string['addnewitem'] = 'Add a new lesson item';
$string['addingitem'] = 'Adding a new {$a} item';
$string['editingitem'] = 'Editing a {$a} item';
$string['createaitem'] = 'Create a lesson item';
$string['item'] = 'Item';
$string['newitem'] = 'Item: {$a}';
$string['itemtitle'] = 'Item Title';
$string['itemcontents'] = 'Item Text/Question';
$string['answer'] = 'Answer';
$string['saveitem'] = 'Save item';
$string['audioitemfile'] = 'item Audio(MP3)';
$string['itemname'] = 'Item Name';
$string['itemorder'] = 'Item Order';
$string['correct'] = 'Correct';
$string['itemtype'] = 'Item Type';
$string['actions'] = 'Actions';
$string['edititem'] = 'Edit item';
$string['previewitem'] = 'Preview item';
$string['duplicateitem'] = 'Duplicate item';
$string['deleteitem'] = 'Delete item';
$string['confirmitemdelete'] = 'Are you sure you want to <i>DELETE</i> item? : {$a}';
$string['confirmitemdeletetitle'] = 'Really Delete item?';
$string['confirmattemptdeletetitle'] = 'Really Delete Attempt?';
$string['confirmattemptdelete'] = 'Are you sure you want to <i>DELETE</i> this attempt?';
$string['confirmattemptdeletealltitle'] = 'Really Delete ALL Attempts?';
$string['confirmattemptdeleteall'] = 'Are you sure you want to <i>DELETE ALL</i> attempts?';
$string['noitems'] = 'This MiniLesson contains no lesson items';
//$string['itemdetails'] = 'item Details: {$a}';
//$string['itemsummary'] = 'item Summary: {$a}';
//$string['viewreport'] = 'view report';
//$string['translate'] = 'Translate';
//$string['iscorrectlabel'] = 'Correct/Incorrect';
//$string['correcttranslationtitle'] = 'Correct Translation';
$string['edit'] = 'Edit';
//$string['gotoactivity'] = 'Start Activity';
//$string['tryactivityagain'] = 'Try Again';
//$string['shuffleanswers'] = 'Shuffle Answers';
//$string['shufflequestions'] = 'Shuffle Questions';
$string['minilesson:itemview'] = 'View items';
$string['minilesson:itemedit'] = 'Edit items';
//$string['fbquestionname'] = 'Item';
$string['avgcorrect'] = 'Av. Correct';
$string['avgtotaltime'] = 'Av. Duration';
//$string['quiz'] = 'Quiz';


//MSV stuff
//$string['error']="Error";
//$string['notes']="Notes";


$string['addmultichoiceitem']='Multi Choice';
$string['addmultiaudioitem']='MC Audio';
$string['adddictationchatitem']='Dictation Chat';
$string['adddictationitem']='Dictation';
$string['addlistenrepeatitem']='Listen and Speak';
$string['addspeechcardsitem']='Speech Cards';
$string['addpageitem']='Content Page';
$string['addsmartframeitem']='SmartFrame';
$string['addshortansweritem']='Short Answer';
$string['addlisteninggapfillitem']='Listening Gapfill';
$string['addspeakinggapfillitem']='Speaking Gapfill';
$string['addtypinggapfillitem']='Typing Gapfill';
$string['addpassagegapfillitem']='Passage Gapfill';
$string['addcomprehensionquizitem']='Comprehension Quiz';
$string['addh5pitem']='H5P';
$string['addspacegameitem']='Space Game';
$string['addfreewritingitem']='Free Writing';
$string['addfreespeakingitem']='Free Speaking';
$string['addfluencyitem']='Fluency';
$string['addpassagereadingitem']='Passage Reading';
$string['addconversationitem']='Conversation';

$string['multichoice'] = 'Multi Choice';
$string['multiaudio'] = 'MC Audio';
$string['dictation']='Dictation';
$string['dictationchat']='Dictation Chat';
$string['speechcards']='Speech Cards';
$string['listenrepeat']='Listen and Speak';
$string['page']='Content Page';
$string['smartframe']='SmartFrame';
$string['shortanswer']='Short Answer';
$string['lgapfill']='Listening Gapfill';
$string['sgapfill']='Speaking Gapfill';
$string['tgapfill']='Typing Gapfill';
$string['pgapfill']='Passage Gapfill';
$string['spacegame']='Space Game';
$string['freewriting']='Free Writing';
$string['freespeaking']='Free Speaking';
$string['fluency']='Fluency';
$string['fluencyresults']='Fluency Results';
$string['passagereading']='Passage Reading';
$string['conversation']='Conversation';
$string['transcriber'] = 'Transcriber';
$string['transcriber_details'] = 'The transcription engine to use';
$string['transcriber_auto'] = 'Open STT (Strict)';
$string['transcriber_poodll'] = 'Guided STT (Poodll)';


$string['pagelayout'] = 'Page layout';

$string['thatsnotright'] = 'Something is Wrong';
//$string['invalidattempt'] = 'Invalid attempt';
//$string['notyourattempt'] = 'I think that is not your reading attempt.';
//$string['notfinished'] = 'This reading is not finished';

//$string['title'] = 'Title';
//$string['level'] = 'Level';
//$string['errors'] = 'Errors';
//$string['studentname'] = 'Student';
//$string['goback'] = 'Go Back';
//$string['teacher'] = 'Teacher';
//$string['close'] = 'Close';

//$string['submitrawaudio'] = 'Submit uncompressed audio';
//$string['submitrawaudio_details'] = 'Submitting uncompressed audio may increase transcription accuracy, but at the expense of upload speed and reliability.';

//dictation chat
$string['dc_results'] = 'Results';
$string['listenandtype'] = 'Listen and Type';
$string['listen'] = 'Listen';
$string['check'] = 'Check';
$string['skip'] = 'Skip';
$string['skip-fluency'] = 'Continue';
$string['start'] = 'Start';
//$string['next'] = 'Next';
$string['nextlessonitem'] = 'Next Page';
$string['loading'] = 'Loading...';
$string['dictation_instructions1'] = 'Listen and type each sentence that you hear.';
$string['sc_instructions1'] = 'Read the phrase on each card aloud.';
$string['dc_instructions1'] = 'Listen and type the sentences you hear.';
//$string['dc_instructions2'] = 'Click \'Start\' to begin!';
//dictation
$string['d_question'] = 'Item';
//listen and repeat
$string['listenandrepeat'] = 'Listen and Speak';
$string['lr_instructions1'] = 'Listen and respond to the sentences you hear.';
//$string['lr_instructions2'] = 'Click \'Start\' to begin!';
$string['spacegame_instructions1'] = 'Shoot the aliens by selecting the correct answer.';
$string['freespeaking_instructions1'] = 'Use the microphone to record your answer to the question.';
$string['passagereading_instructions1'] = 'Use the microphone to record yourself reading the passage.';
$string['freewriting_instructions1'] = 'Type your answer to the question in the text area below.';
$string['fluency_instructions1'] = 'Read the sentences aloud. Click the microphone icon to start recording.';
$string['conversation_instructions1'] = 'replace these instructions.';

$string['choosevoice'] = "Choose the prompt speaker's voice";
$string['choosemultiaudiovoice'] = "Choose the answer reader's voice";
$string['showoptionsastext'] = 'Show answers as text';
$string['showtextprompt'] = 'Show text prompt';
$string['textprompt_words'] = 'Show full text';
$string['textprompt_dots'] = 'Show dots instead of letters';
$string['listenorread'] = "Display options as";
$string['listenorread_read'] = 'plain text';
$string['listenorread_listen']= 'audio players + dots';
$string['listenorread_listenandread']= 'audio players + plain text';
$string['listenorread_image']= 'images + plain text';

//$string['gradenow']= 'Grade Now';

$string['itemtype']= 'Item Type';
$string['action']= 'Action';
$string['order']= 'Order';
$string['deleteitem'] = 'Delete Item';
$string['deleteitem_message'] = 'Really delete item:&nbsp;';
$string['deletebuttonlabel'] = 'DELETE';

$string['noitems'] ='There are no lesson items yet in this activity';
$string['letsadditems'] ='Lets add some lesson items!';
$string['additems'] ='Add Items';
$string['showqtitles'] ='Show item titles in lesson';
$string['previewitem'] ='Preview Item';
$string['showitemscores'] ='See All Results';
//$string['ttshorturl'] = 'SmartFrame URL:';
$string['reattempt'] ='Try Again';
$string['attemptresultsheading']='{$a->username}: Attempt({$a->attemptid}): Score: {$a->sessionscore}% : - {$a->date} ';
$string['result'] ='Result';
$string['qnumber'] ='No.';
$string['title'] ='Title';
$string['type'] ='Type';
$string['sentences'] ='Sentences';
$string['correctresponses'] ='Correct responses';
$string['enterresponses'] ='Enter a list of correct responses in the text area below. Place each response on a new line.';
$string['sentenceprompts'] ='Sentences (prompts)';
//$string['entersentences'] ='Enter a list of sentences in the text area below. Place each sentence on a new line.';
$string['phraseresponses'] ='Enter a list of items in the text area below. Each item should be a on a new line. The format is:<br> audio prompt | correct response (optional)| text prompt (optional) <br>e.g How are you?|I am fine.';
$string['fluencyresponses'] ='Enter a list of phrases/sentences in the text area below. Each item should be a on a new line. ';
$string['itemmedia'] ='Image, audio or video to show';
$string['itemttsquestion'] ='TTS prompt text';
$string['itemttsquestionvoice'] ='TTS prompt speaker';
$string['itemiframe'] ='iFrame embed code';
$string['itemtextarea'] = 'Text Block';
$string['prompt-separate'] ='Text and media separate (recommended)';
$string['prompt-richtext'] ='Rich Text';
$string['prompttype'] ='Text and Media';
$string['prompttype_help'] ='Use plain text and separate selectors for adding media files, or a rich text editor';

//repeatable
//$string['sentence'] ='Sentence';
//$string['sentence_help'] ='Sentence_help';
//$string['sentenceno'] ='Sentence No.';
//$string['sentence_add_fields'] ='Add another sentence';

//reattempt
$string['reattempt'] = 'Try Again';
$string['reattempttitle'] = 'Really Try Again?';
$string['reattemptbody'] = 'If you continue your previous attempt will be replaced with this one. OK?';

//media toggles
$string['addmedia'] = 'Image / audio or video';
$string['addmedia_instructions'] = 'Choose the media type you want to show in the lesson item.';
$string['addiframe'] = 'iFrame / custom HTML';
$string['addiframe_instructions'] = 'Paste the embed code for the iframe you want to show in the lesson item.';
$string['addttsaudio'] = 'TTS Audio';
$string['addttsaudio_instructions'] = 'Enter the text you want to be spoken by the TTS engine.';
$string['addtextarea'] = 'Text Block';
$string['addtextarea_instructions'] = 'Enter the text you want to show in the lesson item.';
$string['addyoutubeclip'] = 'YouTube Clip';
$string['addyoutubeclip_instructions'] = 'Enter the Youtube/Vimeo video ID and start and end times for the clip you want to show in the lesson item.';
$string['addttsdialog'] = "TTS Dialog";
$string['addttsdialog_instructions'] = "Add TTS Dialog";
$string['addttspassage'] = "TTS Passage";
$string['ttspassageinstructions']="Choose the speaker voice and speed, and enter the passage to be read.";
$string['addttspassage_instructions']="Choose the speaker voice and speed, and enter the passage to be read.";
$string['addaudiostory'] = 'Audio Story';
$string['addaudiostory_instructions'] = 'To create an audio story, add an audio file, image files with numerical names (eg 1.png,2.jpg) and an optional subtitle track (.vtt file). Set image entry times (format HH:MM:SS) in the text area.';
$string['audiostorytimes'] = 'Image Entry Times';
$string['audiostoryfiles'] = 'Audio Story Files';

//showtextprompt
$string['enablesetuptab']="Enable setup tab";
$string['enablesetuptab_details']="Probably don't check this. It will show a tab containing the activity instance settings to admins. This is for a special use case and minilesson pages will show without headers,footers or blocks.";
$string['setup']="Setup";

//TTS options
$string['ttsnormal']='Normal';
$string['ttsslow']='Slow';
$string['ttsveryslow']='Very Slow';
$string['ttsssml']='SSML';
$string['choosevoiceoption']='TTS prompt options';
$string['autoplay']='Autoplay';

$string['reportsmenutoptext'] = "Review grade and attempts details using the report buttons below.";

$string['mediaprompts']="Media Prompts";
$string['ignorepunctuation'] = 'Ignore Punctuation';

$string['chooselayout']='Choose layout';
$string['layoutauto']='Auto';
$string['layoutvertical']='Vertical';
$string['layouthorizontal']='Horizontal';
$string['layoutmagazine']='Magazine';

$string['freetrial'] = "Get Cloud Poodll API Credentials and a Free Trial";
$string['freetrial_desc'] = "A dialog should appear that allows you to register for a free trial with Poodll. After registering you should login to the members dashboard to get your API user and secret. And to register your site URL.";
//$string['memberdashboard'] = "Member Dashboard";
//$string['memberdashboard_desc'] = "";
$string['fillcredentials']="Set API user and secret with existing credentials";


$string['viewstart']="Activity open";
$string['viewend']="Activity close";
$string['viewstart_help']="If set, prevents a student from entering the activity before the start date/time.";
$string['viewend_help']="If set, prevents a student from entering the activity after the closing date/time.";
$string['activitydate:submissionsdue'] = 'Due:';
$string['activitydate:submissionsopen'] = 'Opens:';
$string['activitydate:submissionsopened'] = 'Opened:';
$string['activityisnotopenyet']="This activity is not open yet.";
$string['activityisclosed']="This activity is closed.";
$string['open']="Open: ";
$string['until']="Until: ";
$string['activityopenscloses']="Activity open/close dates";

$string['ytclipdetails'] = "Youtube Clip";
$string['itemytid'] = "Youtube Video ID";
$string['itemytstart'] = "Start Secs";
$string['itemytend'] = "End Secs";
$string['itemscomplete'] = "Items Complete";

$string['ttsdialog'] = "TTS Dialog";
$string['ttsdialogvoicea'] = "Voice A";
$string['ttsdialogvoiceb'] = "Voice B";
$string['ttsdialogvoicec'] = "Voice C";
$string['ttsdialogvisible'] = "Dialog Visible";
$string['ttsdialogvisible_desc'] = "Uncheck if the students should not see the dialog text.";

$string['ttspassage']="TTS Passage";
$string['ttspassagespeed']="Speed";
$string['ttspassagevoice']="Voice";


$string['totalscore'] = 'Total Score:';
$string['score'] = 'Score';
$string['questiontext'] = 'Question';
$string['ttsdialoginstructions']="Choose the speaker voices for roles A,B and C and enter the dialog. Begin each dialog line with the speaker role + ')'. e.g A) Hello. Sound effect lines begin with >> e.g >>seagulls";

$string['courseattempts'] = 'Course Attempts';
$string['courseattemptsreport'] = 'Course Attempts Report';
$string['courseattemptsheading'] = 'Course Attempts Report';
$string['courseattemptsreport_explanation']='All minilesson attempts in the course';
$string['studentid']="St. No.";
$string['studentname']="Student Name";
$string['activityname']="Lesson Name.";
$string['itemcount']="No. of items";
$string['correctcount']="No. of correct items";
$string['lessonkey']="Lesson Key";
$string['lessonkey_details'] =
    'The lesson key is just a tag that will be exported to csv with some reports to make post processing those reports in a spreadsheet easier. It is fine to leave it empty.';
$string['lessonkey_help'] =
    'The lesson key is just a tag that will be exported to csv with some reports to make post processing those reports in a spreadsheet easier.';
$string['csskey']="CSS Key";
$string['csskey_details'] =
    'The CSS key is just a custom CSS class that will be appended to the question container, so designers can customize the look and feel easily(?). It is fine to leave it empty.';
$string['csskey_help'] =
    'The CSS key is just a custom CSS class that will be appended to the question container, so designers can customize the look and feel easily(?).';
$string['reportstable']="Reports Style";
$string['reportstable_details']="Ajax tables are faster to use and can sort data. Paged tables load faster but are harder to navigate with.";
$string['reporttableajax']="Ajax Tables";
$string['reporttablepaged']="Paged Tables";
$string['anim_fancy']="Fancy animation";
$string['anim_plain']="Plain animation";
$string['animations']="Animations";
$string['animations_details']="Transitions between item subtypes are animated. If fancy animation causes trouble, choose plain.";
$string['confirmchoice_formlabel']="Must attempt (no skip)";
$string['continue']="Continue <i class='fa fa-arrow-right'></i>";
$string['confirmchoice']="Check";
$string['containerwidth_details']="Sets the max-width of the minilesson activity container in view mode.";
$string['containerwidth_help']="Sets the max-width of the minilesson activity container in view mode.";
$string['containerwidth']="Container width";
$string['contwidth-compact']="Compact";
$string['contwidth-wide']="Wide";
$string['contwidth-full']="Full";
$string['lessonfont']="Custom font";
$string['lessonfont_details']="A font name that will override site default for this minilesson when displayed. Must be exact in spelling and case. eg Andika or Comic Sans MS";
$string['lessonfont_help']="A font name that will override site default for this minilesson when displayed. Must be exact in spelling and case. eg Andika or Comic Sans MS";
$string['advanced']="Advanced";
$string['multiaudio_instructions1'] = 'Choose the correct answer. Use the mic to read it aloud.';
$string['multichoice_instructions1'] = 'Choose the correct answer.';
$string['shortanswer_instructions1'] = 'Answer the question by using the mic.';
$string['smartframe_instructions1'] = 'The page content will load below.';

$string['lg_results'] = 'Results';
$string['sg_results'] = 'Results';
$string['listeninggapfill'] = 'Listening GapFill';
$string['speakinggapfill'] = 'Speaking GapFill';
$string['typinggapfill'] = 'Typing GapFill';
$string['comprehensionquiz'] = 'Comprehension Quiz';
$string['h5p'] = 'H5P';
$string['lg_instructions1'] = 'Listen and fill in the gaps';
$string['sg_instructions1'] = 'Use the microphone and say the full sentence including the missing words';
$string['tg_instructions1'] = 'Fill in the missing words or letters';
$string['pg_instructions1'] = 'Fill in each of the missing words.';
$string['compquiz_results'] = 'Results';
$string['h5p_results'] = 'Results';
$string['compquiz_instructions1'] = 'Comprehension Quiz instructions';
$string['h5p_instructions1'] = 'Complete the task below.';
$string['iteminstructions'] = 'Item instructions';
$string['modaleditform'] = 'Item Edit Form';
$string['modaleditform_details'] = 'Adding or editing items in the Minilesson can be done via a modal(popup) form or on a new page';
$string['modaleditform_newpage'] = 'New page';
$string['modaleditform_modalform'] = 'Modal form (popup)';
$string['timelimit'] = 'Time limit';
$string['gapfillitemsdesc'] ='Enter the list of items in the text area below. Each item should be on a new line. The letter gaps should be enclosed in square brackets: [ ].The format is:<br>Text prompt | hint<br>.e.g  This is my d[og]| a common pet';
$string['listeninggapfillitemsdesc'] ='Enter the list of items in the text area below. Each item should be on a new line. The letter gaps should be enclosed in square brackets: [ ]. The format is:<br>Text prompt<br>.e.g  This is my d[og]';
$string['readsentences'] = 'Read Sentences (TTS)';
$string['readsentences_desc'] = 'If checked each sentence will be read aloud. It will be a form of dictation';
$string['allowretry'] = 'Allow retry';
$string['allowretry_desc'] = 'If checked allows students to submit new attempts, if their previous response was not correct.';
$string['eventminilessonstepsubmitted'] = 'Minilesson step submitted';
$string['eventminilessonattemptsubmitted'] = 'Minilesson attempt submitted';
$string['import'] = 'Import';
$string['importing'] = 'Importing';
$string['importresults'] = 'Import Results';
$string['backtoimport'] = 'Return to Import Top';
$string['importinstructions']='You can import Minilesson items using form below. The import file should be a CSV or JSON file. Refer to the <a href="https://support.poodll.com/en/support/solutions/articles/19000153051-importing-items-into-minilesson" target="_blank">import documentation</a> for the data and data format to include for each item type. There is an sample import file below. Or use the export button further down the page to export the items in this activity to a JSON file.';
$string['cannotsavecsv'] = 'Cannot save csv file';
$string['csvdelimiter'] = 'Delimiter';
$string['importitemsresult']="Import Items Results";
$string['examplecsv'] = 'Example csv/text file';
$string['examplecsv_help'] = 'To use the example csv file, download it then open it with a text or spreadsheet editor. Leave the first line unchanged, then edit the following lines (records) and add your Minilesson item data, adding more lines as necessary. Save the file as CSV then upload it.';
$string['examplejson'] = 'Example json file';
$string['examplejson_help'] = 'To use the example json file, download it then open it with a text or spreadsheet editor. Edit and re-use items in the items array where they match the item type you need, and remove items you don\'t need. Save the file as JSON then upload.';

$string['error:emptyfield'] = 'CANNOT BE EMPTY';
$string['error:failed'] = 'FAILED';
$string['error:correctanswer'] = 'INVALID ANSWER';
$string['error:invaliditemtype'] = 'INVALID ITEM TYPE';
$string['error:invalidjson'] = 'INVALID JSON';
$string['error:noitemsinjson'] = 'NO ITEMS IN JSON';
$string['error:csvloaderror'] = 'CSV LOAD ERROR';


$string['bulkdelete'] = 'Delete selected';
$string['bulkdeletequestion'] = 'Are you sure you want to delete the selected question?';

$string['speechtester_recordinstructions'] = 'Record audio here to be used in testing. You can optionally choose to upload audio by pressing the upload audio button.';
$string['modelaudio_playerinstructions'] = 'The current audio can be played using the player below.';
$string['speechtester_recordtitle'] = 'Record Audio';
$string['speechtester_playertitle'] = 'Play Audio';
$string["savestaudio"]='Record Audio';
$string["uploadstaudio"]='Upload Audio';
$string["sttstaudio"]='STT Audio';
$string["speechtester"]='SpeechTester';
$string["exportinstructions"]='Export items  in this MiniLesson activity to a JSON file. This can be used to backup or transfer items to another MiniLesson activity. Or you can edit the exported items and re-import them as new items.';
$string["exportitems"]='Export Items';
$string["importformat"]="Import Format";
$string["exportheading"]='Export Items as JSON';
$string["importheading"]="Import JSON or CSV Items";
$string["allowmicaccess"]="Please allow access to your microphone.";
$string["nomicdetected"]="No microphone detected.";
$string["speechnotrecognized"]="We could not recognize your speech.";
$string["nominilessons"]="No MiniLessons";

$string["reallydeletemediaprompt"]="Really delete media: ";
$string["deletemediaprompt"]="Delete media?";
$string["choosemediaprompt"]="Choose media type ..";
$string["deletefilesfirst"]="Delete any files you added manually. They will not be deleted automatically.";
$string["cleartextfirst"]="Clear any content you added manually. It will not be deleted automatically.";

$string["itemsettingsheadings"]="Item Settings";

$string["finishscreen"]="Finish Screen";
$string["finishscreen_details"]="When you finish the activity, you can see a simple screen, a full screen or a custom screen. The custom screen is a page you can design yourself.";
$string["finishscreen_help"]="When you finish the activity, you can see a simple screen, a full screen or a custom screen. The custom screen is a page you can design yourself.";
$string["finishscreen_simple"]="Simple";
$string["finishscreen_full"]="Full";
$string["finishscreen_custom"]="Custom";
$string["finishscreencustom"]="Custom finish screen";
$string["finishscreencustom_help"]="The custom screen is an advanced feature, that allows you to build a custom finish screen using mustache notation and variables. Some of the variables are: {total} {courseurl} {coursename} {yellowstars} {graystars} {reattempturl} and an array of {results} each with {title}, {grade}, {yellowstars} and {graystars} variables.";
$string['finishscreencustom_details'] = "If the activity finish screen options are set to 'custom' this will be the default mustache template that generates the finish screen. It can be overridden at the activity level.";
$string['freewritingdesc'] ='Set target word count and grading and feedback guidelines for the AI evaluation. Students should type their answer to the topic, and they will receive an AI powered grade and feedback.';
$string['freespeakingdesc'] ='<b>Free Speaking is a BETA item type.</b> Different browsers and mobile devices may behave differently.<br/><br/> Set target word count and grading and feedback guidelines for the AI evaluation. Students should record themselves speaking on the topic, and they will receive an AI powered grade and feedback.';
$string['conversationdesc'] ='[conversation desc. here]';
$string['fluencydesc'] ='[fluency desc. here]';
$string['spacegamedesc'] ='[space game desc. here]';
$string['passagereadingdesc'] ='<b>Passage Reading is a BETA item type.</b> Different browsers and mobile devices may behave differently.<br/><br/> Enter a passage to read in the text area below. The student should read the passage aloud.';
$string['passagegapfilldesc'] ='Enter a passage of text in the text area below. The word gaps should be enclosed in square brackets: [ ]. A short passage might look like this:  This is my [dog] and my [cat].';
$string['passagetoread'] ='Passage to read';
$string['passagewithgaps'] ='Passage with gaps';
// Spacegame.
$string['achievedhighscoreof'] = 'Achieved a high score of {$a}';
$string['addtomywords'] = "Click to add to My Words";
$string['emptyquiz'] = 'There are no multiple choice questions in the selected category.';
$string['endofgame'] = 'Your score was: {$a}. Press space or click to restart.';
$string['fullscreen'] = 'Fullscreen';
$string['howtoplay'] = 'How to play';
$string['howtoplay_help'] = 'You can move the ship by using the arrow keys, or by dragging it with the mouse.
Press the spacebar or click the mouse button to shoot, or tap with two fingers anywhere on the game.
Clear as many questions as possible by shooting the correct answer.  Good Luck!';
$string['notyetplayed'] = 'Not yet played';
$string['playedxtimeswithhighscore'] = 'Played {$a->times} times. The last game ended with a high score of {$a->score}';
$string['playerscores'] = 'Player scores';
$string['points'] = 'Points';
$string['removefrommywords'] = "Click to remove from My Words";
$string['removescores'] = 'Remove all user scores';
$string['score'] = 'Score';
$string['scoreheader'] = 'Score';
$string['scoreslink'] = 'View all attempts';
$string['scoreslink_help'] = 'View all player attempts and scores';
$string['shootthepairs'] = 'Shoot the Pairs';
$string['spacegameclickclick']  = 'Click the button to start the game';
$string['spacetostart'] = 'Press space or click to start';
$string['sound'] = 'Sound';
$string['done'] = 'Done';
$string['starttest'] = 'Begin';
$string['tryagain'] = 'Try Again';
$string['lives'] = 'Lives: ';
$string['includematching'] = 'Include Shoot-the-Pairs';
$string['includematching_desc'] = 'Include \'Shoot the Pairs\' matching game in the Space Game';
$string['aliencount_mc'] = 'Alien Count (Multiple Choice)';
$string['aliencount_match'] = 'Alien Pair Count (Shoot the Pairs)';
$string['spacegameitems'] = 'Spacegame Items';
$string['enterspacegameitems'] = 'Enter the list of items in the text area below. Each item should be on a new line. The format is:<br>Question | Answer<br>e.g What is the capital of France?|Paris';
$string['showdetailedresults'] = 'Show detailed results';
$string['hidestartpage'] = 'Hide start page';
$string['hidestartpage_desc'] = 'If checked the activity item begins as soon as it has loaded.';
$string['aigrade_modelanswer'] = 'Model answer';
$string['relevancetype'] = 'Relevance type';
$string['relevancetype_desc'] = 'AI will penalize answers of low relevance. Choose the type of relevance to use.';
$string['aigrade_instructions'] = 'Grading Instructions for AI';
$string['aigrade_feedback'] = 'Feedback Instructions for AI';
$string['aigrade_feedback_language'] = 'AI Feedback Language';
$string['targetwordcount_title'] = 'Target Word Count';
$string['totalmarks'] = 'Total Marks';
$string['relevancetype_none'] = 'Relevance not considered';
$string['relevancetype_question'] = 'Relevance to the Question (Item Text)';
$string['relevancetype_modelanswer'] = 'Relevance to a Model Answer';
$string['numberonly'] = 'Numbers only';
$string['targetwordcount'] = 'Target Word Count: {$a}';
$string['currentwordcount'] = 'Word Count: ';
$string['fs_totalmarks_instructions'] = 'The total marks this free speaking item contributes to the MiniLesson activity score.';
$string['fw_totalmarks_instructions'] = 'The total marks this free writing item contributes to the MiniLesson activity score.';
$string['reallyreattempt'] = 'Your previous attempt will be overwritten. Are you sure you want to try again?';
$string['pr_totalmarks_instructions'] = 'The total marks this passage reading contributes to the MiniLesson activity score. Leave as 0 and total marks will equal the passage word count. A score will be calculated from the percentage read correctly otherwise.';
$string['alternates'] = 'Alternates';
$string['pr_alternates_instructions'] =  'Alternates allows the activity author to specify acceptable mistranscriptions for specific passage words. 1 word set per line. e.g their|there|they\'re See <a href="https://support.poodll.com/support/solutions/articles/19000096937-tuning-your-read-aloud-activity">docs</a> for more details.';
$string['rp_result_read'] = "Words Read";
$string['rp_result_correct'] = "Correct";
$string['rp_result_incorrect'] = "Incorrect";
$string['rp_result_unreached'] = "Not Read";
$string['rp_result_accuracy'] = "Accuracy";
$string['rp_result_score'] = "Score";
$string['showcorrections'] = "Show inline corrections";
$string['hidecorrections'] = "Hide inline corrections";
$string['showitemreview'] = "Show Item Review";
$string['showitemreview_help']="Immediately after the student has attempted the item, show them the correct answer and any feedback, if the item supports it.";
$string['showitemreview_details']="Immediately after the student has attempted the item, show them the correct answer and any feedback, if the item supports it.";
$string['enablepushtab'] = "Enable Push Tab";
$string['enablepushtab_details'] = "The push tab allows someone with the Minilesson push capability (by default .. managers) to push settings from this activity to other activities on the site.";
$string['push'] = 'Push';
$string['pushpage'] = 'Push Page';
$string['pushpage_explanation'] = 'Use the buttons on this page to push a setting from THIS MiniLesson instance to other MiniLesson activities. Be careful. There is no going back.';
$string['pushpage_clonecount'] = 'Pushing settings from this activity will affect <b>{$a}</b> other activities.';
$string['pushpage_noclones'] = 'There are no other activities in the affected scope. So there is nothing to push settings to.<br><br>';
$string['pushpage_done'] = 'Settings pushed to {$a} MiniLesson activities';
$string['pushpage_scopemodule'] = 'MiniLesson activities (sitewide) with this activity name: <b>{$a}</b>';
$string['pushpage_scopecourse'] = 'MiniLesson activities in this course: <b>{$a}</b>';
$string['pushpage_scopesite'] = 'All MiniLesson activities in the site';
$string['pushpage_scopenone'] = 'NO MiniLesson activities';
$string['pushpage_noactivities'] = 'No MiniLesson activities match the criteria';
$string['pushpage_noitems'] = 'There MiniLesson activities items in this activity';
$string['pushitems'] = 'Lesson Items';
$string['pushitems_details'] = 'The items in this MiniLesson will be pushed to matching MiniLessons. It will only push to MiniLessons in which every item\'s type, order and name match the items in this MiniLesson. It is intended to overwrite only existing items. It wont push files, only text and settings.';
$string['pushconfirm'] = 'You are about to push the setting: <b>{$a->pushthing}</b> to {$a->clonecount} other activities. Are you sure?';
$string['scopeselector']  = 'Scope: ';
$string['freespeaking_default_aigrade']  = 'Deduct 1 point for each grammar mistake but do not penalize for spelling or punctuation errors.';
$string['freespeaking_default_aigradefeedback']  = 'Explain each grammar mistake simply. Do not comment on spelling or punctuation.';
$string['freewriting_default_aigrade'] = 'Deduct 1 point for each grammar, spelling or punctuation error.';
$string['freewriting_default_aigradefeedback']  = 'Explain each mistake simply.';
$string['writehere']  = 'Write here ..';
$string['submit']='Submit';
$string['feedback']='Feedback';
$string['totalwords'] = 'Total Words';
$string['sentences'] = 'Sentences';
$string['uniquewords'] = 'Unique Words';
$string['ideacount'] = 'Concepts';
$string['relevance'] = 'Relevance';
$string['original'] = 'Original';
$string['corrected'] = 'Corrected';
$string['answerdetails'] = 'Answer Details';
$string['seeanswerdetails'] = 'see details';
$string['notsubmit'] = 'Not Submitted';
$string['notsubmitted'] = 'You have not submitted your answer. Submit now?';
$string['submitnow'] = 'Submit';
$string['enablenativelanguage'] = "Enable Native Language";
$string['enablenativelanguage_details'] = 'If set, the student can choose their native language, this will override the default language of the feedback language that AI returns with the results. The language must currently be <a href="https://support.poodll.com/en/support/solutions/articles/19000163890-definitions-in-user-s-native-language">set in Poodll WordCards</a>, and it is picked up here.';
$string['nopasting'] = "Disable copy/paste";
$string['nopasting_desc'] = "Disable copy/paste into the text area. This is to prevent students from pasting in answers from elsewhere.";
$string['attemptfor'] = 'Attempt: {$a}';
$string['alternatestreaming'] = 'Enable alternate streaming';
$string['alternatestreaming_details'] = 'Streams recorded audio for open transcription. Slightly slower then the default browser transcription and only works in English. On by default in mobile app on iOS.';
$string['cloudpoodllserver'] = 'Cloud Poodll Server';
$string['cloudpoodllserver_details'] = 'The server to use for Cloud Poodll. Only change this if Poodll has provided a different one.';
$string['language'] = 'Language';
$string['voice'] = 'Voice';
$string['passagegapfill'] = 'Passage GapFill';
$string['hints'] = 'Hints';
$string['gethints'] = 'Get Hints';
$string['sentenceimage'] = 'Sentence Images';
$string['sentenceimage_help'] = '(optional) Upload image files to be displayed with the sentence prompt. The image file name should match the sentence prompt number, eg. 1.png or 2.jpg';
$string['sentenceaudio'] = 'Sentence Audios';
$string['sentenceaudio_help'] = '(optional) Upload audio files to match the sentence prompt. The audio file name should match the sentence prompt number, eg. 1.mp3 or 2.mp3';
$string['correctthreshold_desc'] = 'The accuracy percentage required to pass the item.';
$string['correctthreshold'] = 'Correct Threshold (%)';
$string['anotherhint'] = 'Another hint';
$string['finish'] = 'Finish';
$string['penalizehints'] = 'Penalize for hints';
$string['penalizehints_desc'] = 'If checked, the student will be penalized for using hints.';
$string['h5pforminstructions'] = 'Select an H5P activity from the content bank and set the number of points this activity should contribute to the MiniLesson. Open the content bank (link below) and choose -add- to create an H5P activity if you need to.';
$string['aigen'] = 'AI Generate';
$string['aigenpage'] = 'AI Generate (beta)';
$string['aigenpage_done'] = 'AI Generation Done: {$a} items created and added to the activity.';
$string['aigenpage_explanation'] = 'Select a lesson template and then set the template options. The AI will use the current activity settings and the information you provide to generate the lesson items. The lesson items will be added to the current activity.';
$string['aigenpage_notemplates'] = 'There are no templates available for AI generation. Please create a template first.';
$string['itemcount'] = 'Item Count';
$string['aigenconfirm'] = 'You are about to use template: <b>{$a->title}</b> to generate {$a->templatecount} items. Are you sure?';
$string['contextmapping:enabled'] = 'Enabled';
$string['contextmapping:title'] = 'Title';
$string['contextmapping:title_desc'] = 'Input Title';
$string['contextmapping:description'] = 'Explanation';
$string['contextmapping:description_desc'] = 'Input Explanation';
$string['contextmapping:type'] = 'Field type';
$string['contextmapping:options'] = 'Field options';
$string['contextmapping:options_desc'] = 'Input Field Options';
$string['aigenmodaltitle'] = 'Input context data';
$string['generatingtextdata'] = 'Making text data for: {$a}';
$string['generatingimagedata'] = 'Making image data for: {$a}';
$string['aigenpageimporting'] = 'Importing AI generated items';
$string['aigenviewresult'] = 'View AI Generated Items';
$string['col:templateid'] = 'ID';
$string['col:name'] = 'Name';
$string['col:timemodified'] = 'Modified On';
$string['col:action'] = 'Action';
$string['action:addtemplate'] = '+ Add template';
$string['action:edittemplate'] = 'Edit';
$string['action:deletetemplate'] = 'Delete';
$string['action:duplicatetemplate'] = 'Duplicate';
$string['action:downloadtemplate'] = 'Download';
$string['templatedeleteconfirmation'] = 'Are you sure want to delete template?';
$string['minilesson:managetemplate'] = 'Manage template';
$string['templatedeleted'] = 'Template deleted successfully';
$string['templateduplicated'] = 'Template duplicated successfully';
