define(["jquery","core/log","core/notification","mod_minilesson/ttaudiohelper","mod_minilesson/ttbrowserrec","core/str","mod_minilesson/timer","mod_minilesson/ttmsspeech"],(function($,log,notification,audioHelper,browserRec,str,timer,msspeech){return log.debug("TT Recorder: initialising"),{waveHeight:75,audio:{stream:null,blob:null,dataURI:null,start:null,end:null,isRecording:!1,isRecognizing:!1,isWaiting:!1,transcript:null},submitting:!1,owner:"",controls:{},uniqueid:null,audio_updated:null,maxtime:0,passagehash:null,region:null,asrurl:null,lang:null,browserrec:null,usebrowserrec:!1,currentTime:0,stt_guided:!1,currentPrompt:!1,speechtoken:"",speechtokentype:"",forcestreaming:!1,is_streaming:!1,using_msspeech:!1,strings:{},clone:function(){return $.extend(!0,{},this)},init:function(opts){var that=this;if(this.uniqueid=opts.uniqueid,this.callback=opts.callback,this.stt_guided=!!opts.stt_guided&&opts.stt_guided,this.init_strings(),this.prepare_html(),this.controls.recordercontainer.show(),this.register_events(),this.using_msspeech=this.can_msspeech(),this.using_msspeech){var referencetext=opts.referencetext;msspeech.init(this.speechtoken,this.region,this.lang,referencetext)}var handle_timer_update=function(){var displaytime=that.timer.fetch_display_time();that.controls.timerstatus.html(displaytime),log.debug("timer_seconds: "+that.timer.seconds),log.debug("displaytime: "+displaytime),0==that.timer.seconds&&that.timer.initseconds>0&&(that.update_audio("isRecognizing",!0),that.usebrowserrec?that.browserrec.stop():that.audiohelper.stop())},on_error=function(error){switch(error.name){case"PermissionDeniedError":case"NotAllowedError":notification.alert("Error",that.strings.allowmicaccess,"OK");break;case"DevicesNotFoundError":case"NotFoundError":notification.alert("Error",that.strings.nomicdetected,"OK");break;default:log.debug("Error",error.name)}},on_stopped=function(blob){if(that.timer.stop(),void 0!==blob){var newaudio={blob:blob,dataURI:URL.createObjectURL(blob),end:new Date,isRecording:!1,length:Math.round((that.audio.end-that.audio.start)/1e3)};that.update_audio(newaudio),that.is_streaming||(that.using_msspeech?that.do_msspeech(that.audio.blob,(function(response){that.gotMSResults(response),that.update_audio("isRecognizing",!1)})):that.upload_transcribe(that.audio.blob,(function(response){log.debug(response),"success"===response.data.result&&response.data.transcript?that.gotRecognition(response.data.transcript.trim()):notification.alert("Information",that.strings.speechnotrecognized,"OK"),that.update_audio("isRecognizing",!1)})))}},on_gotstream=function(stream){var newaudio={stream:stream,isRecording:!0,isWaiting:!1};that.update_audio(newaudio)};!browserRec.will_work_ok()||this.stt_guided||this.forcestreaming||this.using_msspeech?this.can_stream()&&!this.stt_guided?(this.is_streaming=!0,log.debug("using audio helper and streaming rec"),this.audiohelper=audioHelper.clone(),this.audiohelper.init(this.waveHeight,this.uniqueid,this),that.audiohelper.onError=on_error,that.audiohelper.onStop=on_stopped,that.audiohelper.onStream=on_gotstream,that.audiohelper.onfinalspeechcapture=function(speechtext){that.gotRecognition(speechtext),that.update_audio("isRecording",!1),that.update_audio("isRecognizing",!1)},that.audiohelper.oninterimspeechcapture=function(speechtext){that.gotInterimRecognition(speechtext)}):(log.debug("using upload_transcriber"),this.audiohelper=audioHelper.clone(),this.audiohelper.init(this.waveHeight,this.uniqueid,this),that.audiohelper.onError=on_error,that.audiohelper.onStop=on_stopped,that.audiohelper.onStream=on_gotstream):(log.debug("using browser rec"),this.browserrec=browserRec.clone(),this.browserrec.init(this.lang,this.waveHeight,this.uniqueid),this.usebrowserrec=!0,that.browserrec.onerror=on_error,that.browserrec.onend=function(){},that.browserrec.onstart=function(){},that.browserrec.onfinalspeechcapture=function(speechtext){that.gotRecognition(speechtext),that.update_audio("isRecording",!1),that.update_audio("isRecognizing",!1)},that.browserrec.oninterimspeechcapture=function(speechtext){that.gotInterimRecognition(speechtext)}),this.timer=timer.clone(),this.timer.init(this.maxtime,handle_timer_update),handle_timer_update()},can_stream:function(){return this.speechtoken&&"false"!==this.speechtoken&&"assemblyai"===this.speechtokentype&&!this.stt_guided},can_msspeech:function(){return this.speechtoken&&"false"!==this.speechtoken&&"msspeech"===this.speechtokentype},update_currentprompt:function(targettext){this.currentPrompt=targettext,this.using_msspeech&&msspeech.set_reference_text(targettext)},blobToArrayBuffer:function(blob){return new Promise(((resolve,reject)=>{const reader=new FileReader;reader.onload=function(event){resolve(event.target.result)},reader.onerror=function(error){reject(error)},reader.readAsArrayBuffer(blob)}))},init_strings:function(){var that=this;str.get_strings([{key:"allowmicaccess",component:"mod_minilesson"},{key:"nomicdetected",component:"mod_minilesson"},{key:"speechnotrecognized",component:"mod_minilesson"}]).done((function(s){var i=0;that.strings.allowmicaccess=s[i++],that.strings.nomicdetected=s[i++],that.strings.speechnotrecognized=s[i++]}))},prepare_html:function(){this.controls.recordercontainer=$("#ttrec_container_"+this.uniqueid),this.controls.recorderbutton=$("#"+this.uniqueid+"_recorderdiv"),this.controls.waveform=$("#"+this.uniqueid+"_waveform"),this.controls.timerstatus=$(".timerstatus_"+this.uniqueid),this.passagehash=this.controls.recorderbutton.data("passagehash"),this.region=this.controls.recorderbutton.data("region"),this.lang=this.controls.recorderbutton.data("lang"),this.asrurl=this.controls.recorderbutton.data("asrurl"),this.speechtoken=this.controls.recorderbutton.data("speechtoken"),this.speechtokentype=this.controls.recorderbutton.data("speechtokentype"),this.forcestreaming=this.controls.recorderbutton.data("forcestreaming"),this.maxtime=this.controls.recorderbutton.data("maxtime"),this.waveHeight=this.controls.recorderbutton.data("waveheight")},silence_detected:function(){this.audio.isRecording&&this.toggleRecording()},update_audio:function(newprops,val){if("string"==typeof newprops)log.debug("update_audio:"+newprops+":"+val),this.audio[newprops]!==val&&(this.audio[newprops]=val,this.audio_updated());else{for(var theprop in newprops)this.audio[theprop]=newprops[theprop],log.debug("update_audio:"+theprop+":"+newprops[theprop]);this.audio_updated()}},register_events:function(){var that=this;this.controls.recordercontainer.click((function(){that.toggleRecording()})),this.audio_updated=function(){that.audio.isRecognizing||that.audio.isWaiting?that.show_recorder_pointer("none"):that.show_recorder_pointer("auto"),that.audio.isRecognizing||that.audio.isRecording||that.audio.isWaiting?(this.controls.recorderbutton.removeClass("ttrec_ready"),this.controls.recorderbutton.removeClass("ttrec_waiting"),this.controls.waveform.removeClass("ttrec_waiting"),this.controls.recorderbutton.addClass("ttrec_engaged")):(that.audio.isWaiting,this.controls.recorderbutton.removeClass("ttrec_engaged"),this.controls.recorderbutton.removeClass("ttrec_waiting"),this.controls.waveform.removeClass("ttrec_waiting"),this.controls.recorderbutton.addClass("ttrec_ready")),that.controls.recorderbutton.html(that.recordBtnContent())}},show_recorder_pointer:function(show){show?this.controls.recorderbutton.css("pointer-events","none"):this.controls.recorderbutton.css("pointer-events","auto")},startedRecording:function(){var message={type:"recording",results:""};this.callback(message)},gotMSResults:function(results){log.debug(results);var message={type:"pronunciation_results"};message.results=results,this.callback(message)},gotRecognition:function(transcript){if(log.debug("transcript:"+transcript),""!=transcript.trim()){var message={type:"speech"};message.capturedspeech=transcript,this.callback(message)}},gotInterimRecognition:function(transcript){var message={type:"interimspeech"};message.capturedspeech=transcript,this.callback(message)},cleanWord:function(word){return word.replace(/['!"#$%&\\'()\*+,\-\.\/:;<=>?@\[\\\]\^_`{|}~']/g,"").toLowerCase()},recordBtnContent:function(){return this.audio.isRecognizing?'<i class="fa fa-spinner fa-spin">':this.audio.isRecording?'<i class="fa fa-stop">':this.audio.isWaiting?'<i class="fa fa-solid fa-cog fa-spin">':'<i class="fa fa-microphone">'},toggleRecording:function(){if(!this.audio.isRecognizing&&!this.audio.isWaiting)if(this.audio.isRecording)this.timer.stop(),this.usebrowserrec?(this.update_audio("isRecording",!1),this.update_audio("isRecognizing",!0),this.browserrec.stop()):(this.update_audio("isRecognizing",!0),this.audiohelper.stop());else{if(this.currentTime=0,this.timer.reset(),this.timer.start(),this.usebrowserrec)this.update_audio("isRecording",!0),this.browserrec.start();else{var newaudio={stream:null,blob:null,dataURI:null,start:new Date,end:null,isRecording:!1,isRecognizing:!1,isWaiting:!0,transcript:null};this.update_audio(newaudio),this.audiohelper.start()}this.startedRecording()}},upload_transcribe:function(blob,callback){var bodyFormData=new FormData,blobname=this.uniqueid+Math.floor(100*Math.random())+".wav";bodyFormData.append("audioFile",blob,blobname),bodyFormData.append("scorer",this.passagehash),this.stt_guided?bodyFormData.append("strictmode","false"):bodyFormData.append("strictmode","true"),!1!==this.currentPrompt&&bodyFormData.append("prompt",this.currentPrompt),bodyFormData.append("lang",this.lang),bodyFormData.append("wwwroot",M.cfg.wwwroot);var oReq=new XMLHttpRequest;oReq.open("POST",this.asrurl,!0),oReq.onUploadProgress=function(progressEvent){},oReq.onload=function(oEvent){200===oReq.status?callback(JSON.parse(oReq.response)):(callback({data:{result:"error"}}),log.debug(oReq.error))};try{oReq.send(bodyFormData)}catch(err){callback({data:{result:"error"}}),log.debug(err)}},do_msspeech:function(blob,callback){msspeech.recognize(blob,callback)}}}));

//# sourceMappingURL=ttrecorder.min.js.map