define("mod_minilesson/audiochat",["jquery","core/log","mod_minilesson/definitions","mod_minilesson/ttrecorder","core/templates"],(function($,log,def,ttrecorder,templates){return log.debug("MiniLesson AudioChat: initialising"),{controls:{},itemdata:{},index:0,quizhelper:{},pc:null,dc:null,micStream:null,audiochat_voice:"alloy",clone:function(){return $.extend(!0,{},this)},init:function(index,itemdata,quizhelper){this.itemdata=itemdata,log.debug("itemdata",itemdata),this.quizhelper=quizhelper,this.index=index,this.init_controls(quizhelper,itemdata),this.init_voice(itemdata.audiochat_voice),this.register_events(index,itemdata,quizhelper)},next_question:function(){var stepdata={};stepdata.index=this.index,stepdata.hasgrade=!0,stepdata.totalitems=this.itemdata.totalmarks,stepdata.correctitems=this.itemdata.totalmarks,stepdata.grade=1,stepdata.resultsdata={},this.quizhelper.do_next(stepdata)},register_events:function(index,itemdata,quizhelper){var self=this;self.controls.startbutton.on("click",(function(e){self.startSession()})),self.controls.stopbutton.on("click",(function(e){self.stopSession()})),self.controls.talkbutton.on("click",(function(e){self.pushToTalk()})),self.controls.nextbutton.on("click",(function(e){self.next_question()})),$("#"+itemdata.uniqueid+"_container").on("showElement",(()=>{itemdata.timelimit>0&&($("#"+itemdata.uniqueid+"_container .progress-container").show(),$("#"+itemdata.uniqueid+"_container .progress-container i").show(),$("#"+itemdata.uniqueid+"_container .progress-container #progresstimer").progressTimer({height:"5px",timeLimit:itemdata.timelimit,onFinish:function(){nextbutton.trigger("click")}}))}))},init_voice:function(voice){voice&&["alloy","ash","ballad","coral","echo","sage","shimmer","verse"].includes(voice)?this.audiochat_voice=voice:this.audiochat_voice="alloy",log.debug("AudioChat voice set to:",this.audiochat_voice)},init_controls:function(){this.controls={sessionpending:$("#"+this.itemdata.uniqueid+"_container .ml_audiochat_sessionpending_box"),sessionactive:$("#"+this.itemdata.uniqueid+"_container .ml_audiochat_sessionactive_box"),startbutton:$("#"+this.itemdata.uniqueid+"_container .ml_ac_start"),stopbutton:$("#"+this.itemdata.uniqueid+"_container .ml_ac_stop"),talkbutton:$("#"+this.itemdata.uniqueid+"_container .ml_ac_talk"),studenttranscript:$("#"+this.itemdata.uniqueid+"_container .ml_ac_studenttranscript"),aitranscript:$("#"+this.itemdata.uniqueid+"_container .ml_ac_aitranscript"),hiddenaudio:$("#"+this.itemdata.uniqueid+"_container .ml_ac_hiddenaudio"),nextbutton:$("#"+this.itemdata.uniqueid+"_container .minilesson_nextbutton")}},waitForIceGathering:function(pc){return new Promise((resolve=>{if("complete"===pc.iceGatheringState)resolve();else{function checkState(){"complete"===pc.iceGatheringState&&(pc.removeEventListener("icegatheringstatechange",checkState),resolve())}pc.addEventListener("icegatheringstatechange",checkState)}}))},sendEvent:function(obj){this.dc&&"open"===this.dc.readyState&&this.dc.send(JSON.stringify(obj))},handleRTCEvent:function(msg){var aitranscript=this.controls.aitranscript[0],studenttranscript=this.controls.studenttranscript[0];switch(log.debug("Received event:",msg),msg.type){case"response.done":if(msg.response&&msg.response.output&&msg.response.output[0].content){const content=msg.response.output[0].content[0];content.transcript&&(aitranscript.textContent+=content.transcript+"\n")}break;case"response.output_text.delta":aitranscript.textContent+=msg.delta;break;case"response.output_text.completed":aitranscript.textContent+="\n";break;case"conversation.item.input_audio_transcription.completed":case"input_audio_buffer.speech_recognized":msg.transcript&&(studenttranscript.textContent+=msg.transcript+"\n")}},stopSession:function(){log.debug("Session stopping...");var startBtn=this.controls.startbutton[0],stopBtn=this.controls.stopbutton[0];void 0!==this.dc&&this.dc&&(this.dc.close(),this.dc=null),void 0!==this.pc&&this.pc&&(this.pc.close(),this.pc=null),void 0!==this.micStream&&this.micStream&&(this.micStream.getTracks().forEach((track=>track.stop())),this.micStream=null),startBtn.disabled=!1,stopBtn.disabled=!0,this.controls.sessionpending.hide(),this.controls.sessionactive.hide(),log.debug("Session stopped")},startSession:async function(){var self=this;log.debug("Session starting");var startBtn=self.controls.startbutton[0],stopBtn=self.controls.stopbutton[0],talkBtn=self.controls.talkbutton[0],twoletterlang=self.itemdata.language.substr(0,2),hiddenaudio=(self.itemdata.audiochatnativelanguage.substr(0,2),self.controls.hiddenaudio[0]);startBtn.disabled=!0,self.controls.sessionpending.show(),self.controls.sessionactive.hide(),log.debug("Opening peer connection..."),self.pc=new RTCPeerConnection({iceServers:[{urls:"stun:stun.l.google.com:19302"}]}),log.debug("creating data channel..."),self.dc=self.pc.createDataChannel("oai-events"),self.dc.onopen=()=>{log.debug("DataChannel open"),self.sendEvent({type:"session.update",session:{instructions:self.itemdata.audiochatinstructions,input_audio_format:"pcm16",input_audio_transcription:{language:twoletterlang,model:"whisper-1"},speed:.9,voice:self.audiochat_voice}}),self.sendEvent({type:"response.create",response:{modalities:["audio","text"],instructions:"Please introduce yourself to the student and explain todays topic.",audio:{voice:self.audiochat_voice}}})},self.dc.onmessage=e=>{log.debug("DataChannel message:",e.data);try{const lines=e.data.split("\n").filter(Boolean);for(const line of lines)self.handleRTCEvent(JSON.parse(line))}catch(err){log.debug("Failed to parse",err)}},self.pc.ontrack=event=>hiddenaudio.srcObject=event.streams[0],self.micStream=await navigator.mediaDevices.getUserMedia({audio:!0}),self.micStream.getTracks().forEach((track=>self.pc.addTrack(track,self.micStream)));const offer=await self.pc.createOffer({offerToReceiveAudio:!0});await self.pc.setLocalDescription(offer),await self.waitForIceGathering(self.pc);const sdpResponse=await fetch(M.cfg.wwwroot+"/mod/minilesson/openairtc.php",{method:"POST",headers:{"Content-Type":"application/sdp"},body:self.pc.localDescription.sdp});if(!sdpResponse.ok)return void log.debug("Failed /rtc:",await sdpResponse.text());log.debug("Received SDP answer from server"),log.debug(sdpResponse);const answer=await sdpResponse.text();log.debug(answer),await self.pc.setRemoteDescription({type:"answer",sdp:answer}),self.controls.sessionpending.hide(),self.controls.sessionactive.show(),talkBtn.disabled=!1,stopBtn.disabled=!1,log.debug("Session started")},pushToTalk:function(){this.dc&&"open"===this.dc.readyState&&this.sendEvent({type:"response.create",response:{modalities:["audio","text"],audio:{voice:this.audiochat_voice}}})}}}));

//# sourceMappingURL=audiochat.min.js.map